/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef FB2BLOCKCONTEXT_H_INCLUDED
#define FB2BLOCKCONTEXT_H_INCLUDED

#include <string>

#include "FB2ParserContext.h"

namespace libebook
{

class FB2BodyContext : public FB2NodeContextBase
{
public:
  FB2BodyContext(FB2ParserContext *parentContext, FB2Collector *collector);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

class FB2CiteContext : public FB2BlockFormatContextBase
{
public:
  FB2CiteContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

class FB2EmptyLineContext : public FB2DataContextBase
{
public:
  explicit FB2EmptyLineContext(FB2ParserContext *parentContext);

private:
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

class FB2EpigraphContext : public FB2BlockFormatContextBase
{
public:
  FB2EpigraphContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

class FB2ImageContext : public FB2NodeContextBase
{
public:
  FB2ImageContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);

private:
  std::string m_href;
  std::string m_altText;
  bool m_valid;
};

class FB2PoemContext : public FB2BlockFormatContextBase
{
public:
  FB2PoemContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

class FB2SectionContext : public FB2NodeContextBase
{
public:
  FB2SectionContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

class FB2StanzaContext : public FB2BlockFormatContextBase
{
public:
  FB2StanzaContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

class FB2TitleContext : public FB2BlockFormatContextBase
{
public:
  FB2TitleContext(FB2ParserContext *const parentContext, const FB2BlockFormat &format);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
};

}

#endif // FB2BLOCKCONTEXT_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
