/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 36 "./parser.y"

#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libgda/sql-parser/gda-sql-parser-private.h>
#include <libgda/sql-parser/gda-statement-struct-util.h>
#include <libgda/sql-parser/gda-statement-struct-trans.h>
#include <libgda/sql-parser/gda-statement-struct-insert.h>
#include <libgda/sql-parser/gda-statement-struct-update.h>
#include <libgda/sql-parser/gda-statement-struct-delete.h>
#include <libgda/sql-parser/gda-statement-struct-select.h>
#include <libgda/sql-parser/gda-statement-struct-compound.h>
#include <libgda/sql-parser/gda-statement-struct-parts.h>
#include <assert.h>

typedef struct {
	GValue *fname;
	GdaSqlExpr *expr;
} UpdateSet;

typedef struct {
	gboolean    distinct;
	GdaSqlExpr *expr;
} Distinct;

typedef struct {
	GdaSqlExpr *count;
	GdaSqlExpr *offset;
} Limit;

typedef struct {
	GSList *when_list;
	GSList *then_list;
} CaseBody;

static GdaSqlOperatorType
sql_operation_string_to_operator (const gchar *op)
{
	switch (g_ascii_toupper (*op)) {
	case 'A':
		return GDA_SQL_OPERATOR_TYPE_AND;
	case 'O':
		return GDA_SQL_OPERATOR_TYPE_OR;
	case 'N':
		return GDA_SQL_OPERATOR_TYPE_NOT;
	case '=':
		return GDA_SQL_OPERATOR_TYPE_EQ;
	case 'I':
		if (op[1] == 'S')
			return GDA_SQL_OPERATOR_TYPE_IS;
		else if (op[1] == 'N')
			return GDA_SQL_OPERATOR_TYPE_IN;
		break;
	case 'L':
		return GDA_SQL_OPERATOR_TYPE_LIKE;
	case 'B':
		return GDA_SQL_OPERATOR_TYPE_BETWEEN;
	case '>':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_GEQ;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_GT;
		break;
	case '<':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_LEQ;
		else if (op[1] == '>')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_LT;
		break;
	case '!':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == '~') {
			if (op[2] == 0)
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP;
			else if (op[2] == '*')
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI;
		}
		break;
	case '~':
		if (op[1] == '*')
			return GDA_SQL_OPERATOR_TYPE_REGEXP_CI;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_REGEXP;
		break;
	case 'S':
		return GDA_SQL_OPERATOR_TYPE_SIMILAR;
	case '|':
		if (op[1] == '|')
			return GDA_SQL_OPERATOR_TYPE_CONCAT;
		else
			return GDA_SQL_OPERATOR_TYPE_BITOR;
	case '+':
		return GDA_SQL_OPERATOR_TYPE_PLUS;
	case '-':
		return GDA_SQL_OPERATOR_TYPE_MINUS;
	case '*':
		return GDA_SQL_OPERATOR_TYPE_STAR;
	case '/':
		return GDA_SQL_OPERATOR_TYPE_DIV;
	case '%':
		return GDA_SQL_OPERATOR_TYPE_REM;
	case '&':
		return GDA_SQL_OPERATOR_TYPE_BITAND;
	}
	g_error ("Unhandled operator named '%s'\n", op);
	return 0;
}

static GdaSqlOperatorType
string_to_op_type (GValue *value)
{
	GdaSqlOperatorType op;
	op = sql_operation_string_to_operator (g_value_get_string (value));
	g_value_reset (value);
	g_free (value);
	return op;
}

static GdaSqlExpr *
compose_multiple_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	if (left->cond && (left->cond->operator_type == op)) {
		ret = left;
		ret->cond->operands = g_slist_append (ret->cond->operands, right);
	}
	else {
		GdaSqlOperation *cond;
		ret = gda_sql_expr_new (NULL);
		cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
		ret->cond = cond;
		cond->operator_type = op;
		cond->operands = g_slist_prepend (NULL, right);
		GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
		cond->operands = g_slist_prepend (cond->operands, left);
		GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	}
	return ret;
}

static GdaSqlExpr *
create_two_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, right);
	GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
	cond->operands = g_slist_prepend (cond->operands, left);
	GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlExpr *
create_uni_expr (GdaSqlOperatorType op, GdaSqlExpr *expr) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, expr);
	GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlStatement *
compose_multiple_compounds (GdaSqlStatementCompoundType ctype, GdaSqlStatement *left, GdaSqlStatement *right) {
	GdaSqlStatement *ret = NULL;
	GdaSqlStatementCompound *lc = (GdaSqlStatementCompound*) left->contents;
	if (lc->compound_type == ctype) {
		GdaSqlStatementCompound *rc = (GdaSqlStatementCompound*) right->contents;
		if (!rc->stmt_list->next || rc->compound_type == ctype) {
			GSList *list;
			for (list = rc->stmt_list; list; list = list->next)
				GDA_SQL_ANY_PART (((GdaSqlStatement*)list->data)->contents)->parent = GDA_SQL_ANY_PART (lc);

			ret = left;
			lc->stmt_list = g_slist_concat (lc->stmt_list, rc->stmt_list);
			rc->stmt_list = NULL;
			gda_sql_statement_free (right);
		}
	}
	else {
		ret = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
		gda_sql_statement_compound_set_type (ret, ctype);
		gda_sql_statement_compound_take_stmt (ret, left);
		gda_sql_statement_compound_take_stmt (ret, right);
	}
	return ret;
}

#line 206 "parser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    gda_sql_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is gda_sql_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    gda_sql_parserARG_SDECL     A static variable declaration for the %extra_argument
**    gda_sql_parserARG_PDECL     A parameter declaration for the %extra_argument
**    gda_sql_parserARG_STORE     Code to store %extra_argument into yypParser
**    gda_sql_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 208
#define YYACTIONTYPE unsigned short int
#define gda_sql_parserTOKENTYPE GValue *
typedef union {
  int yyinit;
  gda_sql_parserTOKENTYPE yy0;
  Limit yy20;
  GdaSqlSelectFrom * yy59;
  GdaSqlExpr* yy122;
  Distinct * yy189;
  gboolean yy216;
  GdaSqlSelectTarget * yy224;
  GSList * yy247;
  CaseBody yy263;
  GdaTransactionIsolation yy307;
  GdaSqlStatement * yy308;
  GdaSqlSelectJoinType yy317;
  GdaSqlExpr * yy328;
  GdaSqlOperatorType yy381;
  GSList* yy393;
  GdaSqlParamSpec * yy405;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define gda_sql_parserARG_SDECL GdaSqlParserIface *pdata;
#define gda_sql_parserARG_PDECL ,GdaSqlParserIface *pdata
#define gda_sql_parserARG_FETCH GdaSqlParserIface *pdata = yypParser->pdata
#define gda_sql_parserARG_STORE yypParser->pdata = pdata
#define YYNSTATE 359
#define YYNRULE 195
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (1304)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    38,  240,  359,  237,  555,  141,   22,  119,  321,  100,
 /*    10 */   360,   36,   40,   40,   40,   40,   37,   37,   37,   37,
 /*    20 */    37,  132,   44,   44,  355,   47,   49,   49,   48,   46,
 /*    30 */    46,   41,  238,  347,  346,  159,  345,  344,  343,  342,
 /*    40 */   280,  279,   42,   43,  197,   13,  232,  332,   75,   39,
 /*    50 */    39,   36,   40,   40,   40,   40,   37,   37,   37,   37,
 /*    60 */    37,  131,   44,   44,  316,  333,   49,   49,   48,   46,
 /*    70 */    46,   41,  322,  315,  311,  222,  221,  194,  193,  192,
 /*    80 */   223,  283,   47,  276,  189,   38,  281,  213,   75,   47,
 /*    90 */   312,  282,  299,  240,   21,  135,   79,   40,   40,   40,
 /*   100 */    40,   37,   37,   37,   37,   37,  169,   44,   44,   73,
 /*   110 */   307,   49,   49,   48,   46,   46,   41,  154,  214,  207,
 /*   120 */   326,  190,  345,  344,  343,  342,  140,   42,   43,  197,
 /*   130 */    13,  232,  332,   75,   39,   39,   36,   40,   40,   40,
 /*   140 */    40,   37,   37,   37,   37,   37,  220,   44,   44,  305,
 /*   150 */     1,   49,   49,   48,   46,   46,   41,   38,   37,  289,
 /*   160 */    44,   44,  274,  273,   49,   49,   48,   46,   46,   41,
 /*   170 */   240,  216,  199,   75,  167,  166,  165,  229,  283,  133,
 /*   180 */   358,  357,   34,  281,  127,  219,   75,   51,  282,  139,
 /*   190 */   240,  188,  237,  126,  186,  167,  166,  165,  101,   42,
 /*   200 */    43,  197,   13,  232,  332,    6,   39,   39,   36,   40,
 /*   210 */    40,   40,   40,   37,   37,   37,   37,   37,  190,   44,
 /*   220 */    44,  238,  347,   49,   49,   48,   46,   46,   41,   38,
 /*   230 */   291,  257,  256,  187,  341,  335,   37,   37,   37,   37,
 /*   240 */    37,  350,   44,   44,  336,   75,   49,   49,   48,   46,
 /*   250 */    46,   41,  356,  283,  261,  260,  178,   28,  281,   26,
 /*   260 */   167,  166,  165,  282,  167,  166,  165,  331,   75,  358,
 /*   270 */   357,   42,   43,  197,   13,  232,  332,  144,   39,   39,
 /*   280 */    36,   40,   40,   40,   40,   37,   37,   37,   37,   37,
 /*   290 */   214,   44,   44,  190,   47,   49,   49,   48,   46,   46,
 /*   300 */    41,  177,  292,   45,  176,   38,  349,   79,  236,   81,
 /*   310 */   237,  240,  198,  237,  362,  196,  101,   75,  355,  101,
 /*   320 */   265,  355,  362,  362,  362,  255,  272,  215,  296,  180,
 /*   330 */   303,   49,   49,   48,   46,   46,   41,  140,  228,  238,
 /*   340 */   347,  395,  238,  347,  351,   74,  355,   42,   43,  197,
 /*   350 */    13,  232,  332,   75,   39,   39,   36,   40,   40,   40,
 /*   360 */    40,   37,   37,   37,   37,   37,  218,   44,   44,  317,
 /*   370 */   370,   49,   49,   48,   46,   46,   41,   38,    3,  175,
 /*   380 */   248,  240,  335,  237,  370,  370,  240,  278,  237,   60,
 /*   390 */   195,  259,  258,   75,  101,  340,  355,   47,  247,  334,
 /*   400 */   226,    2,   65,  167,  166,  165,  168,  167,  166,  165,
 /*   410 */    50,  278,  238,  347,  320,   47,  310,  238,  347,   42,
 /*   420 */    43,  197,   13,  232,  332,   27,   39,   39,   36,   40,
 /*   430 */    40,   40,   40,   37,   37,   37,   37,   37,   11,   44,
 /*   440 */    44,  314,  246,   49,   49,   48,   46,   46,   41,   38,
 /*   450 */   240,  174,  298,  240,  335,  237,  191,  350,  240,   73,
 /*   460 */   237,   92,  323,   41,   20,   75,   87,  319,  355,   54,
 /*   470 */   167,  166,  165,  271,  224,  167,  166,  165,  152,  272,
 /*   480 */    75,  116,   56,   10,  238,  347,  167,  166,  165,  238,
 /*   490 */   347,   42,   43,  197,   13,  232,  332,   24,   39,   39,
 /*   500 */    36,   40,   40,   40,   40,   37,   37,   37,   37,   37,
 /*   510 */    18,   44,   44,  309,  179,   49,   49,   48,   46,   46,
 /*   520 */    41,  240,  349,  237,   38,  240,  240,  295,  237,   87,
 /*   530 */   185,  355,  369,   59,  101,   55,  123,   75,  287,   48,
 /*   540 */    46,   46,   41,  308,  306,  270,  369,  369,  150,  278,
 /*   550 */   338,  272,  238,  347,  304,  355,  294,  238,  347,   75,
 /*   560 */   351,  240,  302,  352,   38,   54,   42,   43,  197,   13,
 /*   570 */   232,  332,  180,   39,   39,   36,   40,   40,   40,   40,
 /*   580 */    37,   37,   37,   37,   37,   16,   44,   44,  286,  355,
 /*   590 */    49,   49,   48,   46,   46,   41,  240,  240,  298,  237,
 /*   600 */   182,  184,  183,  275,   38,  101,   42,   35,  197,   13,
 /*   610 */   232,  332,   75,   39,   39,   36,   40,   40,   40,   40,
 /*   620 */    37,   37,   37,   37,   37,  211,   44,   44,  238,  347,
 /*   630 */    49,   49,   48,   46,   46,   41,  285,  134,  125,  240,
 /*   640 */   210,  233,  272,  240,   38,  145,   42,   33,  197,   13,
 /*   650 */   232,  332,   75,   39,   39,   36,   40,   40,   40,   40,
 /*   660 */    37,   37,   37,   37,   37,  354,   44,   44,  353,  173,
 /*   670 */    49,   49,   48,   46,   46,   41,  263,  240,  240,  300,
 /*   680 */   143,  240,  355,  201,   38,  355,  355,   43,  197,   13,
 /*   690 */   232,  332,   75,   39,   39,   36,   40,   40,   40,   40,
 /*   700 */    37,   37,   37,   37,   37,  181,   44,   44,  350,  148,
 /*   710 */    49,   49,   48,   46,   46,   41,  350,  234,  350,  267,
 /*   720 */   264,  240,  355,  200,   69,  272,  272,  205,  197,   13,
 /*   730 */   232,  332,   75,   39,   39,   36,   40,   40,   40,   40,
 /*   740 */    37,   37,   37,   37,   37,    9,   44,   44,    8,  350,
 /*   750 */    49,   49,   48,   46,   46,   41,    7,  254,  234,  245,
 /*   760 */   236,   67,  237,  272,   15,  395,  171,   57,   62,   14,
 /*   770 */   170,  288,   75,  349,  329,   80,  130,   30,  350,  350,
 /*   780 */    50,  349,   78,  349,   77,  240,  158,  237,  234,  335,
 /*   790 */   290,  238,  347,  105,  240,   75,  237,  138,   25,   31,
 /*   800 */    32,  339,  118,  350,  157,  240,  225,  237,   29,    4,
 /*   810 */    19,  351,  156,  136,  349,  329,  238,  347,   30,  351,
 /*   820 */   350,  351,  324,   63,  155,  238,  347,   23,  328,  234,
 /*   830 */   227,  318,  149,  153,   72,  278,  238,  347,   17,  140,
 /*   840 */    31,   32,  350,  349,  349,  329,  301,  217,   30,   29,
 /*   850 */     5,   12,  351,  350,  350,  330,  327,  230,  293,  240,
 /*   860 */   325,  237,   54,   53,  147,  277,  214,  104,  349,  328,
 /*   870 */    31,   32,  339,  269,  129,  120,  266,   71,  172,   29,
 /*   880 */     5,  351,  351,   64,  350,  349,  329,  262,  208,   30,
 /*   890 */   238,  347,   12,  234,  350,  350,  330,  327,  230,  328,
 /*   900 */   203,  325,  240,   68,  237,   58,  351,  349,  329,  172,
 /*   910 */   137,   31,   32,  209,  212,  206,  204,   52,  349,  349,
 /*   920 */    29,    4,   12,  351,  121,  244,  330,  327,  230,   66,
 /*   930 */   242,  325,   82,  238,  347,  164,  297,  231,  146,  151,
 /*   940 */   328,  202,  243,  239,  142,  351,  124,  140,  348,  349,
 /*   950 */   329,  140,  128,   30,  252,   76,  351,  351,  251,  349,
 /*   960 */   349,  250,  328,   12,  235,  284,  122,  330,  327,  230,
 /*   970 */   268,   70,  325,  253,  249,   31,   32,  313,  240,  241,
 /*   980 */   237,  556,  556,  556,   29,    5,   86,  351,  337,  330,
 /*   990 */   327,  556,  240,  556,  237,  556,  556,  351,  351,  556,
 /*  1000 */   117,  556,  556,  556,  328,  556,  240,  556,  237,  238,
 /*  1010 */   347,  240,  556,  237,  109,  556,  556,  556,  240,  106,
 /*  1020 */   237,  556,  556,  238,  347,  556,  163,   12,  556,  556,
 /*  1030 */   556,  330,  327,  230,  556,  556,  325,  238,  347,  240,
 /*  1040 */   556,  237,  238,  347,  240,  556,  237,  114,  556,  238,
 /*  1050 */   347,  556,  112,  556,  240,  556,  237,  556,  556,  240,
 /*  1060 */   556,  237,  111,  556,  556,  556,  240,  115,  237,  556,
 /*  1070 */   238,  347,  556,  556,  103,  238,  347,  556,  556,  240,
 /*  1080 */   556,  237,  556,  556,  556,  238,  347,  113,  556,  556,
 /*  1090 */   238,  347,  240,  556,  237,  556,  556,  238,  347,  556,
 /*  1100 */   102,  240,  556,  237,  240,  556,  237,  556,  556,  108,
 /*  1110 */   238,  347,  162,  556,  240,  556,  237,  240,  556,  237,
 /*  1120 */   556,  556,  161,  238,  347,  107,  240,  556,  237,  556,
 /*  1130 */   556,  556,  238,  347,  160,  238,  347,  556,  556,  240,
 /*  1140 */   556,  237,  240,  556,  237,  238,  347,   85,  238,  347,
 /*  1150 */    99,  556,  556,  556,  240,  556,  237,  238,  347,  240,
 /*  1160 */   556,  237,   98,  556,  240,  556,  237,   84,  556,  556,
 /*  1170 */   238,  347,   97,  238,  347,  556,  240,  556,  237,  240,
 /*  1180 */   556,  237,  556,  556,   83,  238,  347,   96,  556,  556,
 /*  1190 */   238,  347,  556,  556,  556,  238,  347,  240,  556,  237,
 /*  1200 */   556,  240,  556,  237,  556,   95,  556,  238,  347,   61,
 /*  1210 */   238,  347,  240,  556,  237,  556,  240,  556,  237,  240,
 /*  1220 */    94,  237,  556,  556,   93,  556,  556,   91,  238,  347,
 /*  1230 */   556,  556,  238,  347,  556,  556,  556,  240,  556,  237,
 /*  1240 */   556,  556,  556,  238,  347,   90,  556,  238,  347,  556,
 /*  1250 */   238,  347,  556,  556,  556,  240,  556,  237,  556,  556,
 /*  1260 */   556,  556,  240,   89,  237,  556,  556,  556,  238,  347,
 /*  1270 */    88,  240,  556,  237,  556,  556,  556,  556,  556,  110,
 /*  1280 */   556,  556,  556,  556,  556,  556,  238,  347,  556,  556,
 /*  1290 */   556,  556,  556,  238,  347,  556,  556,  556,  556,  556,
 /*  1300 */   556,  556,  238,  347,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    26,  169,    0,  171,  159,  160,   32,  162,  103,  177,
 /*    10 */     0,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    20 */    86,  141,   88,   89,  179,  120,   92,   93,   94,   95,
 /*    30 */    96,   97,  200,  201,  152,  203,  154,  155,  156,  157,
 /*    40 */    57,   58,   68,   69,   70,   71,   72,   73,  114,   75,
 /*    50 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    60 */    86,  141,   88,   89,    5,  103,   92,   93,   94,   95,
 /*    70 */    96,   97,  103,   14,  104,  105,  106,  107,  108,  109,
 /*    80 */   110,   13,  120,   52,   53,   26,   18,   56,  114,  120,
 /*    90 */   120,   23,  103,  169,  120,  171,  102,   78,   79,   80,
 /*   100 */    81,   82,   83,   84,   85,   86,  151,   88,   89,  120,
 /*   110 */   104,   92,   93,   94,   95,   96,   97,  193,   50,  125,
 /*   120 */   152,   53,  154,  155,  156,  157,  132,   68,   69,   70,
 /*   130 */    71,   72,   73,  114,   75,   76,   77,   78,   79,   80,
 /*   140 */    81,   82,   83,   84,   85,   86,  140,   88,   89,  104,
 /*   150 */   102,   92,   93,   94,   95,   96,   97,   26,   86,  131,
 /*   160 */    88,   89,   54,   55,   92,   93,   94,   95,   96,   97,
 /*   170 */   169,  143,  171,  114,  111,  112,  113,   72,   13,  178,
 /*   180 */   117,  118,   77,   18,  141,  140,  114,  119,   23,  182,
 /*   190 */   169,   23,  171,  141,  173,  111,  112,  113,  177,   68,
 /*   200 */    69,   70,   71,   72,   73,  198,   75,   76,   77,   78,
 /*   210 */    79,   80,   81,   82,   83,   84,   85,   86,   53,   88,
 /*   220 */    89,  200,  201,   92,   93,   94,   95,   96,   97,   26,
 /*   230 */   197,   63,   64,   65,  103,  202,   82,   83,   84,   85,
 /*   240 */    86,    1,   88,   89,  103,  114,   92,   93,   94,   95,
 /*   250 */    96,   97,  103,   13,   63,   64,  103,  145,   18,  147,
 /*   260 */   111,  112,  113,   23,  111,  112,  113,   17,  114,  117,
 /*   270 */   118,   68,   69,   70,   71,   72,   73,  103,   75,   76,
 /*   280 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   290 */    50,   88,   89,   53,  120,   92,   93,   94,   95,   96,
 /*   300 */    97,  162,  120,  102,  162,   26,   66,  102,  169,  127,
 /*   310 */   171,  169,  173,  171,  103,  173,  177,  114,  179,  177,
 /*   320 */   163,  179,  111,  112,  113,  168,  169,  160,    1,  162,
 /*   330 */   104,   92,   93,   94,   95,   96,   97,  132,  199,  200,
 /*   340 */   201,   50,  200,  201,  104,  142,  179,   68,   69,   70,
 /*   350 */    71,   72,   73,  114,   75,   76,   77,   78,   79,   80,
 /*   360 */    81,   82,   83,   84,   85,   86,  140,   88,   89,  189,
 /*   370 */   103,   92,   93,   94,   95,   96,   97,   26,  102,  162,
 /*   380 */   103,  169,  202,  171,  117,  118,  169,  120,  171,  177,
 /*   390 */   173,   63,   64,  114,  177,  103,  179,  120,  103,  103,
 /*   400 */   188,  102,  120,  111,  112,  113,  151,  111,  112,  113,
 /*   410 */   128,  120,  200,  201,  103,  120,  104,  200,  201,   68,
 /*   420 */    69,   70,   71,   72,   73,  146,   75,   76,   77,   78,
 /*   430 */    79,   80,   81,   82,   83,   84,   85,   86,  135,   88,
 /*   440 */    89,  189,  103,   92,   93,   94,   95,   96,   97,   26,
 /*   450 */   169,  162,  171,  169,  202,  171,  175,    1,  169,  120,
 /*   460 */   171,  177,  103,   97,  120,  114,  177,  103,  179,  142,
 /*   470 */   111,  112,  113,  163,  190,  111,  112,  113,  103,  169,
 /*   480 */   114,  191,  192,  135,  200,  201,  111,  112,  113,  200,
 /*   490 */   201,   68,   69,   70,   71,   72,   73,  146,   75,   76,
 /*   500 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   510 */   120,   88,   89,  104,  162,   92,   93,   94,   95,   96,
 /*   520 */    97,  169,   66,  171,   26,  169,  169,  171,  171,  177,
 /*   530 */   173,  179,  103,  102,  177,  164,  165,  114,  162,   94,
 /*   540 */    95,   96,   97,  104,  104,  163,  117,  118,  166,  120,
 /*   550 */    94,  169,  200,  201,  104,  179,  200,  200,  201,  114,
 /*   560 */   104,  169,  104,  171,   26,  142,   68,   69,   70,   71,
 /*   570 */    72,   73,  162,   75,   76,   77,   78,   79,   80,   81,
 /*   580 */    82,   83,   84,   85,   86,  139,   88,   89,  103,  179,
 /*   590 */    92,   93,   94,   95,   96,   97,  169,  169,  171,  171,
 /*   600 */    51,  173,  175,   53,   26,  177,   68,   69,   70,   71,
 /*   610 */    72,   73,  114,   75,   76,   77,   78,   79,   80,   81,
 /*   620 */    82,   83,   84,   85,   86,   67,   88,   89,  200,  201,
 /*   630 */    92,   93,   94,   95,   96,   97,  163,  164,  165,  169,
 /*   640 */   120,  171,  169,  169,   26,  171,   68,   69,   70,   71,
 /*   650 */    72,   73,  114,   75,   76,   77,   78,   79,   80,   81,
 /*   660 */    82,   83,   84,   85,   86,  162,   88,   89,  162,  162,
 /*   670 */    92,   93,   94,   95,   96,   97,  121,  169,  169,  171,
 /*   680 */   171,  169,  179,  171,   26,  179,  179,   69,   70,   71,
 /*   690 */    72,   73,  114,   75,   76,   77,   78,   79,   80,   81,
 /*   700 */    82,   83,   84,   85,   86,  162,   88,   89,    1,   67,
 /*   710 */    92,   93,   94,   95,   96,   97,    1,   10,    1,  163,
 /*   720 */   163,  169,  179,  171,  124,  169,  169,  120,   70,   71,
 /*   730 */    72,   73,  114,   75,   76,   77,   78,   79,   80,   81,
 /*   740 */    82,   83,   84,   85,   86,  102,   88,   89,  102,    1,
 /*   750 */    92,   93,   94,   95,   96,   97,  102,  163,   10,    1,
 /*   760 */   169,  127,  171,  169,   76,   50,  206,  130,  177,   76,
 /*   770 */   206,  131,  114,   66,   67,  180,   59,   70,    1,    1,
 /*   780 */   128,   66,  180,   66,  180,  169,  176,  171,   10,  202,
 /*   790 */   199,  200,  201,  177,  169,  114,  171,  204,  145,   92,
 /*   800 */    93,   94,  177,    1,  184,  169,  137,  171,  101,  102,
 /*   810 */   136,  104,  185,  177,   66,   67,  200,  201,   70,  104,
 /*   820 */     1,  104,   74,    8,  186,  200,  201,  133,  121,   10,
 /*   830 */   134,  187,   17,  194,  119,  120,  200,  201,  139,  132,
 /*   840 */    92,   93,    1,   66,   66,   67,  195,  138,   70,  101,
 /*   850 */   102,  144,  104,    1,    1,  148,  149,  150,  197,  169,
 /*   860 */   153,  171,  142,   48,   49,  165,   50,  177,   66,  121,
 /*   870 */    92,   93,   94,  165,   59,   60,  119,  167,   57,  101,
 /*   880 */   102,  104,  104,  167,    1,   66,   67,  168,  170,   70,
 /*   890 */   200,  201,  144,   10,    1,    1,  148,  149,  150,  121,
 /*   900 */    68,  153,  169,  172,  171,  102,  104,   66,   67,   57,
 /*   910 */   177,   92,   93,   61,   62,  174,  120,  102,   66,   66,
 /*   920 */   101,  102,  144,  104,  122,  176,  148,  149,  150,  170,
 /*   930 */   161,  153,  181,  200,  201,  183,  197,  205,  123,  166,
 /*   940 */   121,  126,  176,  169,  129,  104,  166,  132,  169,   66,
 /*   950 */    67,  132,   59,   70,  169,  102,  104,  104,  169,   66,
 /*   960 */    66,  169,  121,  144,  169,  164,  166,  148,  149,  150,
 /*   970 */   164,  119,  153,  169,  169,   92,   93,  196,  169,  161,
 /*   980 */   171,  207,  207,  207,  101,  102,  177,  104,   94,  148,
 /*   990 */   149,  207,  169,  207,  171,  207,  207,  104,  104,  207,
 /*  1000 */   177,  207,  207,  207,  121,  207,  169,  207,  171,  200,
 /*  1010 */   201,  169,  207,  171,  177,  207,  207,  207,  169,  177,
 /*  1020 */   171,  207,  207,  200,  201,  207,  177,  144,  207,  207,
 /*  1030 */   207,  148,  149,  150,  207,  207,  153,  200,  201,  169,
 /*  1040 */   207,  171,  200,  201,  169,  207,  171,  177,  207,  200,
 /*  1050 */   201,  207,  177,  207,  169,  207,  171,  207,  207,  169,
 /*  1060 */   207,  171,  177,  207,  207,  207,  169,  177,  171,  207,
 /*  1070 */   200,  201,  207,  207,  177,  200,  201,  207,  207,  169,
 /*  1080 */   207,  171,  207,  207,  207,  200,  201,  177,  207,  207,
 /*  1090 */   200,  201,  169,  207,  171,  207,  207,  200,  201,  207,
 /*  1100 */   177,  169,  207,  171,  169,  207,  171,  207,  207,  177,
 /*  1110 */   200,  201,  177,  207,  169,  207,  171,  169,  207,  171,
 /*  1120 */   207,  207,  177,  200,  201,  177,  169,  207,  171,  207,
 /*  1130 */   207,  207,  200,  201,  177,  200,  201,  207,  207,  169,
 /*  1140 */   207,  171,  169,  207,  171,  200,  201,  177,  200,  201,
 /*  1150 */   177,  207,  207,  207,  169,  207,  171,  200,  201,  169,
 /*  1160 */   207,  171,  177,  207,  169,  207,  171,  177,  207,  207,
 /*  1170 */   200,  201,  177,  200,  201,  207,  169,  207,  171,  169,
 /*  1180 */   207,  171,  207,  207,  177,  200,  201,  177,  207,  207,
 /*  1190 */   200,  201,  207,  207,  207,  200,  201,  169,  207,  171,
 /*  1200 */   207,  169,  207,  171,  207,  177,  207,  200,  201,  177,
 /*  1210 */   200,  201,  169,  207,  171,  207,  169,  207,  171,  169,
 /*  1220 */   177,  171,  207,  207,  177,  207,  207,  177,  200,  201,
 /*  1230 */   207,  207,  200,  201,  207,  207,  207,  169,  207,  171,
 /*  1240 */   207,  207,  207,  200,  201,  177,  207,  200,  201,  207,
 /*  1250 */   200,  201,  207,  207,  207,  169,  207,  171,  207,  207,
 /*  1260 */   207,  207,  169,  177,  171,  207,  207,  207,  200,  201,
 /*  1270 */   177,  169,  207,  171,  207,  207,  207,  207,  207,  177,
 /*  1280 */   207,  207,  207,  207,  207,  207,  200,  201,  207,  207,
 /*  1290 */   207,  207,  207,  200,  201,  207,  207,  207,  207,  207,
 /*  1300 */   207,  207,  200,  201,
};
#define YY_SHIFT_USE_DFLT (-121)
#define YY_SHIFT_COUNT (242)
#define YY_SHIFT_MIN   (-120)
#define YY_SHIFT_MAX   (894)
static const short yy_shift_ofst[] = {
 /*     0 */   815,  707,  819,  819,  819,  819,  778,  883,  883,  883,
 /*    10 */   883,  883,  883,  748,  883,  883,  883,  883,  883,  883,
 /*    20 */   883,  883,  883,  883,  883,  883,  883,  883,  883,  883,
 /*    30 */   883,  883,  883,  883,  883,  883,  883,  883,  883,  883,
 /*    40 */   883,  883,  883,  883,  883,  883,  883,  883,  883,  883,
 /*    50 */   883,  240,  815,  852,  841,  715,  853,  777,  777,  777,
 /*    60 */    59,   59,  423,   68,  802,  777,  777,  777,   -6,  777,
 /*    70 */   777,  777,  777,  777,  777,  777,  205,  205,  205,  205,
 /*    80 */   205, -121, -121,  -26,  351,  279,  203,  131,  498,  498,
 /*    90 */   498,  498,  498,  498,  498,  498,  498,  498,  498,  498,
 /*   100 */   498,  498,  578,  538,  498,  498,  618,  658,  658,  658,
 /*   110 */   -66,  -66,  -66,   19,  154,   72,  -30,  239,  445,   63,
 /*   120 */   893,  717,  165,  429,  165,  267,  894,  456,  777,  777,
 /*   130 */   777,  777,  777,  282,  291,  327,  366,  366,  112,  182,
 /*   140 */    28,  152,  832,  652,  796,  803,  832,  757,  821,  757,
 /*   150 */   816,  816,  720,  709,  699,  694,  696,  674,  669,  653,
 /*   160 */   681,  681,  681,  681,  652,  640,  640,  640, -121, -121,
 /*   170 */   -32, -118,  168,  375,  364,  359,  296,  292,  211,  153,
 /*   180 */   149,   84,   31,  339,  295,  277,  174,  328,  191,  108,
 /*   190 */   -17,  -11,  226,   45,    6,  -31,  -38,  105,  -95,  693,
 /*   200 */   688,  637,  634,  758,  654,  646,  607,  643,  600,  642,
 /*   210 */   555,  520,  558,  550,  549,  485,  446,  431,  458,  450,
 /*   220 */   440,  439,  409,  312,  390,  348,  344,  303,  311,  299,
 /*   230 */   255,  250,  276,  141,  201,   52,   43,   48,  -45,  -80,
 /*   240 */  -120,   10,    2,
};
#define YY_REDUCE_USE_DFLT (-169)
#define YY_REDUCE_COUNT (169)
#define YY_REDUCE_MIN   (-168)
#define YY_REDUCE_MAX   (1102)
static const short yy_reduce_ofst[] = {
 /*     0 */  -155,  139,  217,  142,  352,  289,  591,  428,  357,   21,
 /*    10 */   284,  212, -168, 1102, 1093, 1086, 1068, 1050, 1047, 1043,
 /*    20 */  1032, 1028, 1010, 1007,  995,  990,  985,  973,  970,  957,
 /*    30 */   948,  945,  935,  932,  923,  910,  897,  890,  885,  875,
 /*    40 */   870,  849,  842,  837,  823,  809,  733,  690,  636,  625,
 /*    50 */   616,  473,  167,  157,  356,  382,  -76,    1,  427,  281,
 /*    60 */   252,  180,   33,  371,  594,  552,  512,  509,  543,  474,
 /*    70 */   557,  556,  310,  508,  470,  392,  507,  506,  503,  410,
 /*    80 */   376,  290,    7,  587,  587,  587,  587,  587,  587,  587,
 /*    90 */   587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
 /*   100 */   587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
 /*   110 */   587,  587,  587,  587,  587,  587,  781,  587,  587,  818,
 /*   120 */   805,  804,  806,  800,  801,  780,  779,  795,  792,  789,
 /*   130 */   785,  779,  774,  766,  773,  739,  587,  587,  732,  752,
 /*   140 */   751,  769,  759,  749,  741,  731,  718,  716,  719,  710,
 /*   150 */   708,  700,  661,  651,  639,  644,  638,  627,  620,  593,
 /*   160 */   587,  587,  587,  587,  610,  604,  602,  595,  564,  560,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   554,  491,  491,  491,  554,  554,  554,  491,  491,  491,
 /*    10 */   554,  554,  529,  554,  554,  554,  554,  554,  554,  554,
 /*    20 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    30 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    40 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    50 */   554,  401,  554,  401,  554,  401,  554,  554,  554,  554,
 /*    60 */   447,  447,  484,  365,  401,  554,  554,  554,  554,  554,
 /*    70 */   401,  401,  401,  554,  554,  554,  554,  554,  554,  554,
 /*    80 */   554,  457,  476,  438,  554,  554,  554,  554,  429,  428,
 /*    90 */   488,  459,  490,  489,  449,  440,  439,  531,  532,  530,
 /*   100 */   528,  493,  554,  554,  492,  426,  510,  518,  517,  509,
 /*   110 */   521,  514,  513,  516,  512,  515,  453,  506,  503,  554,
 /*   120 */   554,  554,  554,  395,  554,  395,  554,  554,  554,  554,
 /*   130 */   554,  554,  554,  425,  371,  484,  504,  505,  533,  452,
 /*   140 */   485,  554,  416,  425,  413,  420,  416,  393,  381,  393,
 /*   150 */   554,  554,  484,  456,  460,  437,  441,  448,  450,  554,
 /*   160 */   519,  508,  507,  511,  425,  434,  434,  434,  543,  543,
 /*   170 */   554,  554,  554,  554,  554,  554,  554,  554,  522,  554,
 /*   180 */   554,  415,  554,  554,  554,  554,  554,  386,  385,  554,
 /*   190 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*   200 */   554,  554,  554,  554,  554,  554,  414,  554,  554,  554,
 /*   210 */   554,  379,  554,  554,  554,  554,  487,  554,  554,  554,
 /*   220 */   554,  554,  554,  554,  451,  554,  442,  554,  554,  554,
 /*   230 */   554,  554,  554,  554,  554,  552,  551,  497,  495,  552,
 /*   240 */   551,  554,  554,  427,  424,  417,  421,  419,  418,  410,
 /*   250 */   409,  408,  412,  411,  384,  383,  388,  387,  392,  391,
 /*   260 */   390,  389,  382,  380,  378,  377,  394,  376,  375,  374,
 /*   270 */   368,  367,  402,  400,  399,  398,  397,  372,  396,  407,
 /*   280 */   406,  405,  404,  403,  373,  366,  361,  431,  435,  486,
 /*   290 */   478,  477,  475,  474,  483,  482,  473,  472,  423,  455,
 /*   300 */   422,  454,  471,  470,  469,  468,  467,  466,  465,  464,
 /*   310 */   463,  462,  461,  458,  444,  446,  445,  443,  436,  522,
 /*   320 */   500,  498,  525,  526,  535,  542,  540,  539,  538,  537,
 /*   330 */   536,  527,  534,  523,  524,  520,  501,  481,  480,  479,
 /*   340 */   499,  496,  547,  546,  545,  544,  541,  494,  553,  550,
 /*   350 */   549,  548,  502,  433,  432,  430,  362,  364,  363,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         ID => nothing */
    1,  /*      ABORT => ID */
    1,  /*      AFTER => ID */
    1,  /*    ANALYZE => ID */
    1,  /*        ASC => ID */
    1,  /*     ATTACH => ID */
    1,  /*     BEFORE => ID */
    1,  /*      BEGIN => ID */
    1,  /*    CASCADE => ID */
    1,  /*       CAST => ID */
    1,  /*   CONFLICT => ID */
    1,  /*   DATABASE => ID */
    1,  /*   DEFERRED => ID */
    1,  /*       DESC => ID */
    1,  /*     DETACH => ID */
    1,  /*       EACH => ID */
    1,  /*        END => ID */
    1,  /*  EXCLUSIVE => ID */
    1,  /*    EXPLAIN => ID */
    1,  /*       FAIL => ID */
    1,  /*        FOR => ID */
    1,  /*     IGNORE => ID */
    1,  /*  IMMEDIATE => ID */
    1,  /*  INITIALLY => ID */
    1,  /*    INSTEAD => ID */
    1,  /*       LIKE => ID */
    1,  /*      MATCH => ID */
    1,  /*       PLAN => ID */
    1,  /*      QUERY => ID */
    1,  /*        KEY => ID */
    1,  /*         OF => ID */
    1,  /*     OFFSET => ID */
    1,  /*     PRAGMA => ID */
    1,  /*      RAISE => ID */
    1,  /*    REPLACE => ID */
    1,  /*   RESTRICT => ID */
    1,  /*        ROW => ID */
    1,  /*       TEMP => ID */
    1,  /*    TRIGGER => ID */
    1,  /*     VACUUM => ID */
    1,  /*       VIEW => ID */
    1,  /*    VIRTUAL => ID */
    1,  /*    REINDEX => ID */
    1,  /*     RENAME => ID */
    1,  /*   CTIME_KW => ID */
    1,  /*         IF => ID */
    1,  /*  DELIMITER => ID */
    1,  /*     COMMIT => ID */
    1,  /*   ROLLBACK => ID */
    1,  /*  ISOLATION => ID */
    1,  /*      LEVEL => ID */
    1,  /* SERIALIZABLE => ID */
    1,  /*       READ => ID */
    1,  /*  COMMITTED => ID */
    1,  /* UNCOMMITTED => ID */
    1,  /* REPEATABLE => ID */
    1,  /*      WRITE => ID */
    1,  /*       ONLY => ID */
    1,  /*  SAVEPOINT => ID */
    1,  /*    RELEASE => ID */
    1,  /*    COMMENT => ID */
    1,  /*      FORCE => ID */
    1,  /*       WAIT => ID */
    1,  /*     NOWAIT => ID */
    1,  /*      BATCH => ID */
    0,  /*    TEXTUAL => nothing */
   66,  /*     STRING => TEXTUAL */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  gda_sql_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void gda_sql_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ID",            "ABORT",         "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "END",           "EXCLUSIVE",     "EXPLAIN",     
  "FAIL",          "FOR",           "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "MATCH",       
  "PLAN",          "QUERY",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "TEMP",          "TRIGGER",     
  "VACUUM",        "VIEW",          "VIRTUAL",       "REINDEX",     
  "RENAME",        "CTIME_KW",      "IF",            "DELIMITER",   
  "COMMIT",        "ROLLBACK",      "ISOLATION",     "LEVEL",       
  "SERIALIZABLE",  "READ",          "COMMITTED",     "UNCOMMITTED", 
  "REPEATABLE",    "WRITE",         "ONLY",          "SAVEPOINT",   
  "RELEASE",       "COMMENT",       "FORCE",         "WAIT",        
  "NOWAIT",        "BATCH",         "TEXTUAL",       "STRING",      
  "OR",            "AND",           "NOT",           "IS",          
  "IN",            "ISNULL",        "NOTNULL",       "DIFF",        
  "EQ",            "BETWEEN",       "GT",            "LEQ",         
  "LT",            "GEQ",           "REGEXP",        "REGEXP_CI",   
  "NOT_REGEXP",    "NOT_REGEXP_CI",  "SIMILAR",       "ESCAPE",      
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "COLLATE",       "UMINUS",      
  "UPLUS",         "BITNOT",        "LP",            "RP",          
  "JOIN",          "INNER",         "NATURAL",       "LEFT",        
  "RIGHT",         "FULL",          "CROSS",         "UNION",       
  "EXCEPT",        "INTERSECT",     "PGCAST",        "ILLEGAL",     
  "SQLCOMMENT",    "SEMI",          "END_OF_FILE",   "TRANSACTION", 
  "COMMA",         "INTEGER",       "TO",            "INSERT",      
  "INTO",          "VALUES",        "DELETE",        "FROM",        
  "WHERE",         "UPDATE",        "SET",           "ALL",         
  "SELECT",        "LIMIT",         "ORDER",         "BY",          
  "HAVING",        "GROUP",         "USING",         "ON",          
  "OUTER",         "DOT",           "AS",            "DISTINCT",    
  "CASE",          "WHEN",          "THEN",          "ELSE",        
  "NULL",          "FLOAT",         "UNSPECVAL",     "LSBRACKET",   
  "RSBRACKET",     "SIMPLEPARAM",   "PNAME",         "PDESCR",      
  "PTYPE",         "PNULLOK",       "error",         "stmt",        
  "cmd",           "eos",           "compound",      "nm_opt",      
  "transtype",     "transilev",     "opt_comma",     "trans_opt_kw",
  "ora_commit_write",  "nm",            "opt_on_conflict",  "fullname",    
  "inscollist_opt",  "exprlist",      "ins_extra_values",  "inscollist",  
  "where_opt",     "expr",          "setlist",       "selectcmd",   
  "opt_compound_all",  "distinct",      "selcollist",    "from",        
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sortlist",      "sortorder",     "nexprlist",     "seltablist",  
  "stl_prefix",    "seltarget",     "on_cond",       "using_opt",   
  "jointype",      "as",            "sclp",          "starname",    
  "value",         "pvalue",        "uni_op",        "case_operand",
  "case_exprlist",  "case_else",     "paramspec",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stmt ::= cmd eos",
 /*   1 */ "stmt ::= compound eos",
 /*   2 */ "cmd ::= LP cmd RP",
 /*   3 */ "compound ::= LP compound RP",
 /*   4 */ "eos ::= SEMI",
 /*   5 */ "eos ::= END_OF_FILE",
 /*   6 */ "cmd ::= BEGIN",
 /*   7 */ "cmd ::= BEGIN TRANSACTION nm_opt",
 /*   8 */ "cmd ::= BEGIN transtype TRANSACTION nm_opt",
 /*   9 */ "cmd ::= BEGIN transtype nm_opt",
 /*  10 */ "cmd ::= BEGIN transilev",
 /*  11 */ "cmd ::= BEGIN TRANSACTION transilev",
 /*  12 */ "cmd ::= BEGIN TRANSACTION transtype",
 /*  13 */ "cmd ::= BEGIN TRANSACTION transtype opt_comma transilev",
 /*  14 */ "cmd ::= BEGIN TRANSACTION transilev opt_comma transtype",
 /*  15 */ "cmd ::= BEGIN transtype opt_comma transilev",
 /*  16 */ "cmd ::= BEGIN transilev opt_comma transtype",
 /*  17 */ "cmd ::= END trans_opt_kw nm_opt",
 /*  18 */ "cmd ::= COMMIT nm_opt",
 /*  19 */ "cmd ::= COMMIT TRANSACTION nm_opt",
 /*  20 */ "cmd ::= COMMIT FORCE STRING",
 /*  21 */ "cmd ::= COMMIT FORCE STRING COMMA INTEGER",
 /*  22 */ "cmd ::= COMMIT COMMENT STRING",
 /*  23 */ "cmd ::= COMMIT COMMENT STRING ora_commit_write",
 /*  24 */ "cmd ::= COMMIT ora_commit_write",
 /*  25 */ "cmd ::= ROLLBACK trans_opt_kw nm_opt",
 /*  26 */ "ora_commit_write ::= WRITE IMMEDIATE",
 /*  27 */ "ora_commit_write ::= WRITE BATCH",
 /*  28 */ "ora_commit_write ::= WRITE WAIT",
 /*  29 */ "ora_commit_write ::= WRITE NOWAIT",
 /*  30 */ "ora_commit_write ::= WRITE IMMEDIATE WAIT",
 /*  31 */ "ora_commit_write ::= WRITE IMMEDIATE NOWAIT",
 /*  32 */ "ora_commit_write ::= WRITE BATCH WAIT",
 /*  33 */ "ora_commit_write ::= WRITE BATCH NOWAIT",
 /*  34 */ "trans_opt_kw ::=",
 /*  35 */ "trans_opt_kw ::= TRANSACTION",
 /*  36 */ "opt_comma ::=",
 /*  37 */ "opt_comma ::= COMMA",
 /*  38 */ "transilev ::= ISOLATION LEVEL SERIALIZABLE",
 /*  39 */ "transilev ::= ISOLATION LEVEL REPEATABLE READ",
 /*  40 */ "transilev ::= ISOLATION LEVEL READ COMMITTED",
 /*  41 */ "transilev ::= ISOLATION LEVEL READ UNCOMMITTED",
 /*  42 */ "nm_opt ::=",
 /*  43 */ "nm_opt ::= nm",
 /*  44 */ "transtype ::= DEFERRED",
 /*  45 */ "transtype ::= IMMEDIATE",
 /*  46 */ "transtype ::= EXCLUSIVE",
 /*  47 */ "transtype ::= READ WRITE",
 /*  48 */ "transtype ::= READ ONLY",
 /*  49 */ "cmd ::= SAVEPOINT nm",
 /*  50 */ "cmd ::= RELEASE SAVEPOINT nm",
 /*  51 */ "cmd ::= RELEASE nm",
 /*  52 */ "cmd ::= ROLLBACK trans_opt_kw TO nm",
 /*  53 */ "cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm",
 /*  54 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP",
 /*  55 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values",
 /*  56 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound",
 /*  57 */ "opt_on_conflict ::=",
 /*  58 */ "opt_on_conflict ::= OR ID",
 /*  59 */ "ins_extra_values ::= ins_extra_values COMMA LP exprlist RP",
 /*  60 */ "ins_extra_values ::= COMMA LP exprlist RP",
 /*  61 */ "inscollist_opt ::=",
 /*  62 */ "inscollist_opt ::= LP inscollist RP",
 /*  63 */ "inscollist ::= inscollist COMMA fullname",
 /*  64 */ "inscollist ::= fullname",
 /*  65 */ "cmd ::= DELETE FROM fullname where_opt",
 /*  66 */ "where_opt ::=",
 /*  67 */ "where_opt ::= WHERE expr",
 /*  68 */ "cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt",
 /*  69 */ "setlist ::= setlist COMMA fullname EQ expr",
 /*  70 */ "setlist ::= fullname EQ expr",
 /*  71 */ "compound ::= selectcmd",
 /*  72 */ "compound ::= compound UNION opt_compound_all compound",
 /*  73 */ "compound ::= compound EXCEPT opt_compound_all compound",
 /*  74 */ "compound ::= compound INTERSECT opt_compound_all compound",
 /*  75 */ "opt_compound_all ::=",
 /*  76 */ "opt_compound_all ::= ALL",
 /*  77 */ "selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  78 */ "limit_opt ::=",
 /*  79 */ "limit_opt ::= LIMIT expr",
 /*  80 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /*  81 */ "limit_opt ::= LIMIT expr COMMA expr",
 /*  82 */ "orderby_opt ::=",
 /*  83 */ "orderby_opt ::= ORDER BY sortlist",
 /*  84 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  85 */ "sortlist ::= expr sortorder",
 /*  86 */ "sortorder ::= ASC",
 /*  87 */ "sortorder ::= DESC",
 /*  88 */ "sortorder ::=",
 /*  89 */ "having_opt ::=",
 /*  90 */ "having_opt ::= HAVING expr",
 /*  91 */ "groupby_opt ::=",
 /*  92 */ "groupby_opt ::= GROUP BY nexprlist",
 /*  93 */ "from ::=",
 /*  94 */ "from ::= FROM seltablist",
 /*  95 */ "seltablist ::= stl_prefix seltarget on_cond using_opt",
 /*  96 */ "using_opt ::= USING LP inscollist RP",
 /*  97 */ "using_opt ::=",
 /*  98 */ "stl_prefix ::=",
 /*  99 */ "stl_prefix ::= seltablist jointype",
 /* 100 */ "on_cond ::= ON expr",
 /* 101 */ "on_cond ::=",
 /* 102 */ "jointype ::= COMMA",
 /* 103 */ "jointype ::= JOIN",
 /* 104 */ "jointype ::= CROSS JOIN",
 /* 105 */ "jointype ::= INNER JOIN",
 /* 106 */ "jointype ::= NATURAL JOIN",
 /* 107 */ "jointype ::= LEFT JOIN",
 /* 108 */ "jointype ::= LEFT OUTER JOIN",
 /* 109 */ "jointype ::= RIGHT JOIN",
 /* 110 */ "jointype ::= RIGHT OUTER JOIN",
 /* 111 */ "jointype ::= FULL JOIN",
 /* 112 */ "jointype ::= FULL OUTER JOIN",
 /* 113 */ "seltarget ::= fullname as",
 /* 114 */ "seltarget ::= fullname ID",
 /* 115 */ "seltarget ::= LP compound RP as",
 /* 116 */ "sclp ::= selcollist COMMA",
 /* 117 */ "sclp ::=",
 /* 118 */ "selcollist ::= sclp expr as",
 /* 119 */ "selcollist ::= sclp starname",
 /* 120 */ "starname ::= STAR",
 /* 121 */ "starname ::= nm DOT STAR",
 /* 122 */ "starname ::= nm DOT nm DOT STAR",
 /* 123 */ "as ::= AS fullname",
 /* 124 */ "as ::= AS value",
 /* 125 */ "as ::=",
 /* 126 */ "distinct ::=",
 /* 127 */ "distinct ::= ALL",
 /* 128 */ "distinct ::= DISTINCT",
 /* 129 */ "distinct ::= DISTINCT ON expr",
 /* 130 */ "nexprlist ::= nexprlist COMMA expr",
 /* 131 */ "nexprlist ::= expr",
 /* 132 */ "exprlist ::=",
 /* 133 */ "exprlist ::= exprlist COMMA expr",
 /* 134 */ "exprlist ::= expr",
 /* 135 */ "expr ::= pvalue",
 /* 136 */ "expr ::= value",
 /* 137 */ "expr ::= LP expr RP",
 /* 138 */ "expr ::= fullname",
 /* 139 */ "expr ::= fullname LP exprlist RP",
 /* 140 */ "expr ::= fullname LP compound RP",
 /* 141 */ "expr ::= fullname LP starname RP",
 /* 142 */ "expr ::= CAST LP expr AS fullname RP",
 /* 143 */ "expr ::= expr PGCAST fullname",
 /* 144 */ "expr ::= expr PLUS|MINUS expr",
 /* 145 */ "expr ::= expr STAR expr",
 /* 146 */ "expr ::= expr SLASH|REM expr",
 /* 147 */ "expr ::= expr BITAND|BITOR expr",
 /* 148 */ "expr ::= MINUS expr",
 /* 149 */ "expr ::= PLUS expr",
 /* 150 */ "expr ::= expr AND expr",
 /* 151 */ "expr ::= expr OR expr",
 /* 152 */ "expr ::= expr CONCAT expr",
 /* 153 */ "expr ::= expr GT|LEQ|GEQ|LT expr",
 /* 154 */ "expr ::= expr DIFF|EQ expr",
 /* 155 */ "expr ::= expr LIKE expr",
 /* 156 */ "expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr",
 /* 157 */ "expr ::= expr BETWEEN expr AND expr",
 /* 158 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 159 */ "expr ::= NOT expr",
 /* 160 */ "expr ::= BITNOT expr",
 /* 161 */ "expr ::= expr uni_op",
 /* 162 */ "expr ::= expr IS expr",
 /* 163 */ "expr ::= LP compound RP",
 /* 164 */ "expr ::= expr IN LP exprlist RP",
 /* 165 */ "expr ::= expr IN LP compound RP",
 /* 166 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 167 */ "expr ::= expr NOT IN LP compound RP",
 /* 168 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 169 */ "case_operand ::= expr",
 /* 170 */ "case_operand ::=",
 /* 171 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 172 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 173 */ "case_else ::= ELSE expr",
 /* 174 */ "case_else ::=",
 /* 175 */ "uni_op ::= ISNULL",
 /* 176 */ "uni_op ::= IS NOTNULL",
 /* 177 */ "value ::= NULL",
 /* 178 */ "value ::= STRING",
 /* 179 */ "value ::= INTEGER",
 /* 180 */ "value ::= FLOAT",
 /* 181 */ "pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET",
 /* 182 */ "pvalue ::= value LSBRACKET paramspec RSBRACKET",
 /* 183 */ "pvalue ::= SIMPLEPARAM",
 /* 184 */ "paramspec ::=",
 /* 185 */ "paramspec ::= paramspec PNAME",
 /* 186 */ "paramspec ::= paramspec PDESCR",
 /* 187 */ "paramspec ::= paramspec PTYPE",
 /* 188 */ "paramspec ::= paramspec PNULLOK",
 /* 189 */ "nm ::= JOIN",
 /* 190 */ "nm ::= ID",
 /* 191 */ "nm ::= TEXTUAL",
 /* 192 */ "fullname ::= nm",
 /* 193 */ "fullname ::= nm DOT nm",
 /* 194 */ "fullname ::= nm DOT nm DOT nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to gda_sql_parser and gda_sql_parserFree.
*/
void *gda_sql_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  gda_sql_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
      /* TERMINAL Destructor */
    case 1: /* ID */
    case 2: /* ABORT */
    case 3: /* AFTER */
    case 4: /* ANALYZE */
    case 5: /* ASC */
    case 6: /* ATTACH */
    case 7: /* BEFORE */
    case 8: /* BEGIN */
    case 9: /* CASCADE */
    case 10: /* CAST */
    case 11: /* CONFLICT */
    case 12: /* DATABASE */
    case 13: /* DEFERRED */
    case 14: /* DESC */
    case 15: /* DETACH */
    case 16: /* EACH */
    case 17: /* END */
    case 18: /* EXCLUSIVE */
    case 19: /* EXPLAIN */
    case 20: /* FAIL */
    case 21: /* FOR */
    case 22: /* IGNORE */
    case 23: /* IMMEDIATE */
    case 24: /* INITIALLY */
    case 25: /* INSTEAD */
    case 26: /* LIKE */
    case 27: /* MATCH */
    case 28: /* PLAN */
    case 29: /* QUERY */
    case 30: /* KEY */
    case 31: /* OF */
    case 32: /* OFFSET */
    case 33: /* PRAGMA */
    case 34: /* RAISE */
    case 35: /* REPLACE */
    case 36: /* RESTRICT */
    case 37: /* ROW */
    case 38: /* TEMP */
    case 39: /* TRIGGER */
    case 40: /* VACUUM */
    case 41: /* VIEW */
    case 42: /* VIRTUAL */
    case 43: /* REINDEX */
    case 44: /* RENAME */
    case 45: /* CTIME_KW */
    case 46: /* IF */
    case 47: /* DELIMITER */
    case 48: /* COMMIT */
    case 49: /* ROLLBACK */
    case 50: /* ISOLATION */
    case 51: /* LEVEL */
    case 52: /* SERIALIZABLE */
    case 53: /* READ */
    case 54: /* COMMITTED */
    case 55: /* UNCOMMITTED */
    case 56: /* REPEATABLE */
    case 57: /* WRITE */
    case 58: /* ONLY */
    case 59: /* SAVEPOINT */
    case 60: /* RELEASE */
    case 61: /* COMMENT */
    case 62: /* FORCE */
    case 63: /* WAIT */
    case 64: /* NOWAIT */
    case 65: /* BATCH */
    case 66: /* TEXTUAL */
    case 67: /* STRING */
    case 68: /* OR */
    case 69: /* AND */
    case 70: /* NOT */
    case 71: /* IS */
    case 72: /* IN */
    case 73: /* ISNULL */
    case 74: /* NOTNULL */
    case 75: /* DIFF */
    case 76: /* EQ */
    case 77: /* BETWEEN */
    case 78: /* GT */
    case 79: /* LEQ */
    case 80: /* LT */
    case 81: /* GEQ */
    case 82: /* REGEXP */
    case 83: /* REGEXP_CI */
    case 84: /* NOT_REGEXP */
    case 85: /* NOT_REGEXP_CI */
    case 86: /* SIMILAR */
    case 87: /* ESCAPE */
    case 88: /* BITAND */
    case 89: /* BITOR */
    case 90: /* LSHIFT */
    case 91: /* RSHIFT */
    case 92: /* PLUS */
    case 93: /* MINUS */
    case 94: /* STAR */
    case 95: /* SLASH */
    case 96: /* REM */
    case 97: /* CONCAT */
    case 98: /* COLLATE */
    case 99: /* UMINUS */
    case 100: /* UPLUS */
    case 101: /* BITNOT */
    case 102: /* LP */
    case 103: /* RP */
    case 104: /* JOIN */
    case 105: /* INNER */
    case 106: /* NATURAL */
    case 107: /* LEFT */
    case 108: /* RIGHT */
    case 109: /* FULL */
    case 110: /* CROSS */
    case 111: /* UNION */
    case 112: /* EXCEPT */
    case 113: /* INTERSECT */
    case 114: /* PGCAST */
    case 115: /* ILLEGAL */
    case 116: /* SQLCOMMENT */
    case 117: /* SEMI */
    case 118: /* END_OF_FILE */
    case 119: /* TRANSACTION */
    case 120: /* COMMA */
    case 121: /* INTEGER */
    case 122: /* TO */
    case 123: /* INSERT */
    case 124: /* INTO */
    case 125: /* VALUES */
    case 126: /* DELETE */
    case 127: /* FROM */
    case 128: /* WHERE */
    case 129: /* UPDATE */
    case 130: /* SET */
    case 131: /* ALL */
    case 132: /* SELECT */
    case 133: /* LIMIT */
    case 134: /* ORDER */
    case 135: /* BY */
    case 136: /* HAVING */
    case 137: /* GROUP */
    case 138: /* USING */
    case 139: /* ON */
    case 140: /* OUTER */
    case 141: /* DOT */
    case 142: /* AS */
    case 143: /* DISTINCT */
    case 144: /* CASE */
    case 145: /* WHEN */
    case 146: /* THEN */
    case 147: /* ELSE */
    case 148: /* NULL */
    case 149: /* FLOAT */
    case 150: /* UNSPECVAL */
    case 151: /* LSBRACKET */
    case 152: /* RSBRACKET */
    case 153: /* SIMPLEPARAM */
    case 154: /* PNAME */
    case 155: /* PDESCR */
    case 156: /* PTYPE */
    case 157: /* PNULLOK */
{
#line 9 "./parser.y"
if ((yypminor->yy0)) {
#ifdef GDA_DEBUG_NO
		 gchar *str = gda_sql_value_stringify ((yypminor->yy0));
		 g_print ("___ token destructor /%s/\n", str)
		 g_free (str);
#endif
		 g_value_unset ((yypminor->yy0)); g_free ((yypminor->yy0));}
#line 1374 "parser.c"
}
      break;
    case 159: /* stmt */
{
#line 278 "./parser.y"
g_print ("Statement destroyed by parser: %p\n", (yypminor->yy308)); gda_sql_statement_free ((yypminor->yy308));
#line 1381 "parser.c"
}
      break;
    case 160: /* cmd */
    case 162: /* compound */
    case 179: /* selectcmd */
{
#line 301 "./parser.y"
gda_sql_statement_free ((yypminor->yy308));
#line 1390 "parser.c"
}
      break;
    case 172: /* inscollist_opt */
    case 175: /* inscollist */
    case 195: /* using_opt */
{
#line 478 "./parser.y"
if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_field_free, NULL); g_slist_free ((yypminor->yy393));}
#line 1399 "parser.c"
}
      break;
    case 173: /* exprlist */
    case 190: /* nexprlist */
{
#line 764 "./parser.y"
if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy247));}
#line 1407 "parser.c"
}
      break;
    case 174: /* ins_extra_values */
{
#line 467 "./parser.y"
GSList *list;
		for (list = (yypminor->yy393); list; list = list->next) {
			g_slist_foreach ((GSList*) list->data, (GFunc) gda_sql_field_free, NULL); 
			g_slist_free ((GSList*) list->data);
		}
		g_slist_free ((yypminor->yy393));

#line 1420 "parser.c"
}
      break;
    case 176: /* where_opt */
    case 177: /* expr */
    case 185: /* having_opt */
    case 194: /* on_cond */
    case 201: /* pvalue */
{
#line 500 "./parser.y"
gda_sql_expr_free ((yypminor->yy328));
#line 1431 "parser.c"
}
      break;
    case 178: /* setlist */
{
#line 520 "./parser.y"
GSList *list;
	for (list = (yypminor->yy393); list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		g_value_reset (set->fname); g_free (set->fname);
		gda_sql_expr_free (set->expr);
		g_free (set);
	}
	g_slist_free ((yypminor->yy393));

#line 1446 "parser.c"
}
      break;
    case 181: /* distinct */
{
#line 750 "./parser.y"
if ((yypminor->yy189)) {if ((yypminor->yy189)->expr) gda_sql_expr_free ((yypminor->yy189)->expr); g_free ((yypminor->yy189));}
#line 1453 "parser.c"
}
      break;
    case 182: /* selcollist */
    case 198: /* sclp */
{
#line 707 "./parser.y"
g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_field_free, NULL); g_slist_free ((yypminor->yy247));
#line 1461 "parser.c"
}
      break;
    case 183: /* from */
    case 191: /* seltablist */
    case 192: /* stl_prefix */
{
#line 633 "./parser.y"
gda_sql_select_from_free ((yypminor->yy59));
#line 1470 "parser.c"
}
      break;
    case 184: /* groupby_opt */
{
#line 628 "./parser.y"
if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy393));}
#line 1477 "parser.c"
}
      break;
    case 186: /* orderby_opt */
    case 188: /* sortlist */
{
#line 597 "./parser.y"
if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_order_free, NULL); g_slist_free ((yypminor->yy247));}
#line 1485 "parser.c"
}
      break;
    case 187: /* limit_opt */
{
#line 590 "./parser.y"
gda_sql_expr_free ((yypminor->yy20).count); gda_sql_expr_free ((yypminor->yy20).offset);
#line 1492 "parser.c"
}
      break;
    case 193: /* seltarget */
{
#line 692 "./parser.y"
gda_sql_select_target_free ((yypminor->yy224));
#line 1499 "parser.c"
}
      break;
    case 203: /* case_operand */
    case 205: /* case_else */
{
#line 928 "./parser.y"
gda_sql_expr_free ((yypminor->yy122));
#line 1507 "parser.c"
}
      break;
    case 204: /* case_exprlist */
{
#line 933 "./parser.y"
g_slist_foreach ((yypminor->yy263).when_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).when_list);
	g_slist_foreach ((yypminor->yy263).then_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).then_list);
#line 1515 "parser.c"
}
      break;
    case 206: /* paramspec */
{
#line 971 "./parser.y"
gda_sql_param_spec_free ((yypminor->yy405));
#line 1522 "parser.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from gda_sql_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void gda_sql_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int gda_sql_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   gda_sql_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 25 "./parser.y"

	gda_sql_parser_set_overflow_error (pdata->parser);
#line 1707 "parser.c"
   gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 159, 2 },
  { 159, 2 },
  { 160, 3 },
  { 162, 3 },
  { 161, 1 },
  { 161, 1 },
  { 160, 1 },
  { 160, 3 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 5 },
  { 160, 4 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 3 },
  { 160, 4 },
  { 160, 2 },
  { 160, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 167, 0 },
  { 167, 1 },
  { 166, 0 },
  { 166, 1 },
  { 165, 3 },
  { 165, 4 },
  { 165, 4 },
  { 165, 4 },
  { 163, 0 },
  { 163, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 2 },
  { 164, 2 },
  { 160, 2 },
  { 160, 3 },
  { 160, 2 },
  { 160, 4 },
  { 160, 5 },
  { 160, 9 },
  { 160, 10 },
  { 160, 6 },
  { 170, 0 },
  { 170, 2 },
  { 174, 5 },
  { 174, 4 },
  { 172, 0 },
  { 172, 3 },
  { 175, 3 },
  { 175, 1 },
  { 160, 4 },
  { 176, 0 },
  { 176, 2 },
  { 160, 6 },
  { 178, 5 },
  { 178, 3 },
  { 162, 1 },
  { 162, 4 },
  { 162, 4 },
  { 162, 4 },
  { 180, 0 },
  { 180, 1 },
  { 179, 9 },
  { 187, 0 },
  { 187, 2 },
  { 187, 4 },
  { 187, 4 },
  { 186, 0 },
  { 186, 3 },
  { 188, 4 },
  { 188, 2 },
  { 189, 1 },
  { 189, 1 },
  { 189, 0 },
  { 185, 0 },
  { 185, 2 },
  { 184, 0 },
  { 184, 3 },
  { 183, 0 },
  { 183, 2 },
  { 191, 4 },
  { 195, 4 },
  { 195, 0 },
  { 192, 0 },
  { 192, 2 },
  { 194, 2 },
  { 194, 0 },
  { 196, 1 },
  { 196, 1 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 193, 2 },
  { 193, 2 },
  { 193, 4 },
  { 198, 2 },
  { 198, 0 },
  { 182, 3 },
  { 182, 2 },
  { 199, 1 },
  { 199, 3 },
  { 199, 5 },
  { 197, 2 },
  { 197, 2 },
  { 197, 0 },
  { 181, 0 },
  { 181, 1 },
  { 181, 1 },
  { 181, 3 },
  { 190, 3 },
  { 190, 1 },
  { 173, 0 },
  { 173, 3 },
  { 173, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 3 },
  { 177, 1 },
  { 177, 4 },
  { 177, 4 },
  { 177, 4 },
  { 177, 6 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 6 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 5 },
  { 177, 6 },
  { 177, 6 },
  { 177, 5 },
  { 203, 1 },
  { 203, 0 },
  { 204, 5 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 202, 1 },
  { 202, 2 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 201, 4 },
  { 201, 4 },
  { 201, 1 },
  { 206, 0 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 169, 1 },
  { 169, 1 },
  { 169, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  gda_sql_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* stmt ::= cmd eos */
#line 279 "./parser.y"
{pdata->parsed_statement = yymsp[-1].minor.yy308;}
#line 2016 "parser.c"
        break;
      case 1: /* stmt ::= compound eos */
#line 280 "./parser.y"
{
	GdaSqlStatementCompound *scompound = (GdaSqlStatementCompound *) yymsp[-1].minor.yy308->contents;
	if (scompound->stmt_list->next)
		/* real compound (multiple statements) */
		pdata->parsed_statement = yymsp[-1].minor.yy308;
	else {
		/* false compound (only 1 select) */
		pdata->parsed_statement = (GdaSqlStatement*) scompound->stmt_list->data;
		GDA_SQL_ANY_PART (pdata->parsed_statement->contents)->parent = NULL;
		g_slist_free (scompound->stmt_list);
		scompound->stmt_list = NULL;
		gda_sql_statement_free (yymsp[-1].minor.yy308);
	}
}
#line 2034 "parser.c"
        break;
      case 2: /* cmd ::= LP cmd RP */
      case 3: /* compound ::= LP compound RP */ yytestcase(yyruleno==3);
#line 294 "./parser.y"
{yygotominor.yy308 = yymsp[-1].minor.yy308;  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2042 "parser.c"
        break;
      case 4: /* eos ::= SEMI */
#line 297 "./parser.y"
{
  yy_destructor(yypParser,117,&yymsp[0].minor);
}
#line 2049 "parser.c"
        break;
      case 5: /* eos ::= END_OF_FILE */
#line 298 "./parser.y"
{
  yy_destructor(yypParser,118,&yymsp[0].minor);
}
#line 2056 "parser.c"
        break;
      case 6: /* cmd ::= BEGIN */
#line 306 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);  yy_destructor(yypParser,8,&yymsp[0].minor);
}
#line 2062 "parser.c"
        break;
      case 7: /* cmd ::= BEGIN TRANSACTION nm_opt */
#line 307 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					 gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 2071 "parser.c"
        break;
      case 8: /* cmd ::= BEGIN transtype TRANSACTION nm_opt */
#line 311 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						      gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy0);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 2081 "parser.c"
        break;
      case 9: /* cmd ::= BEGIN transtype nm_opt */
#line 316 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					  gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-1].minor.yy0);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
}
#line 2090 "parser.c"
        break;
      case 10: /* cmd ::= BEGIN transilev */
#line 321 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
				gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-1].minor);
}
#line 2098 "parser.c"
        break;
      case 11: /* cmd ::= BEGIN TRANSACTION transilev */
#line 325 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 2107 "parser.c"
        break;
      case 12: /* cmd ::= BEGIN TRANSACTION transtype */
#line 329 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 2116 "parser.c"
        break;
      case 13: /* cmd ::= BEGIN TRANSACTION transtype opt_comma transilev */
#line 333 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,119,&yymsp[-3].minor);
}
#line 2126 "parser.c"
        break;
      case 14: /* cmd ::= BEGIN TRANSACTION transilev opt_comma transtype */
#line 338 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,119,&yymsp[-3].minor);
}
#line 2136 "parser.c"
        break;
      case 15: /* cmd ::= BEGIN transtype opt_comma transilev */
#line 343 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2145 "parser.c"
        break;
      case 16: /* cmd ::= BEGIN transilev opt_comma transtype */
#line 348 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2154 "parser.c"
        break;
      case 17: /* cmd ::= END trans_opt_kw nm_opt */
#line 353 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,17,&yymsp[-2].minor);
}
#line 2162 "parser.c"
        break;
      case 18: /* cmd ::= COMMIT nm_opt */
#line 357 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
			      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,48,&yymsp[-1].minor);
}
#line 2170 "parser.c"
        break;
      case 19: /* cmd ::= COMMIT TRANSACTION nm_opt */
#line 361 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,48,&yymsp[-2].minor);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 2179 "parser.c"
        break;
      case 20: /* cmd ::= COMMIT FORCE STRING */
#line 365 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-2].minor);
  yy_destructor(yypParser,62,&yymsp[-1].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 2187 "parser.c"
        break;
      case 21: /* cmd ::= COMMIT FORCE STRING COMMA INTEGER */
#line 366 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-4].minor);
  yy_destructor(yypParser,62,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[-2].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
  yy_destructor(yypParser,121,&yymsp[0].minor);
}
#line 2197 "parser.c"
        break;
      case 22: /* cmd ::= COMMIT COMMENT STRING */
#line 367 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[-1].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 2205 "parser.c"
        break;
      case 23: /* cmd ::= COMMIT COMMENT STRING ora_commit_write */
#line 368 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-3].minor);
  yy_destructor(yypParser,61,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 2213 "parser.c"
        break;
      case 24: /* cmd ::= COMMIT ora_commit_write */
#line 369 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-1].minor);
}
#line 2219 "parser.c"
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt_kw nm_opt */
#line 371 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK);
					     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-2].minor);
}
#line 2227 "parser.c"
        break;
      case 26: /* ora_commit_write ::= WRITE IMMEDIATE */
#line 375 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,23,&yymsp[0].minor);
}
#line 2235 "parser.c"
        break;
      case 27: /* ora_commit_write ::= WRITE BATCH */
#line 376 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2243 "parser.c"
        break;
      case 28: /* ora_commit_write ::= WRITE WAIT */
#line 377 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,63,&yymsp[0].minor);
}
#line 2251 "parser.c"
        break;
      case 29: /* ora_commit_write ::= WRITE NOWAIT */
#line 378 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2259 "parser.c"
        break;
      case 30: /* ora_commit_write ::= WRITE IMMEDIATE WAIT */
#line 379 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,63,&yymsp[0].minor);
}
#line 2268 "parser.c"
        break;
      case 31: /* ora_commit_write ::= WRITE IMMEDIATE NOWAIT */
#line 380 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2277 "parser.c"
        break;
      case 32: /* ora_commit_write ::= WRITE BATCH WAIT */
#line 381 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,65,&yymsp[-1].minor);
  yy_destructor(yypParser,63,&yymsp[0].minor);
}
#line 2286 "parser.c"
        break;
      case 33: /* ora_commit_write ::= WRITE BATCH NOWAIT */
#line 382 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,65,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2295 "parser.c"
        break;
      case 35: /* trans_opt_kw ::= TRANSACTION */
#line 385 "./parser.y"
{
  yy_destructor(yypParser,119,&yymsp[0].minor);
}
#line 2302 "parser.c"
        break;
      case 37: /* opt_comma ::= COMMA */
#line 388 "./parser.y"
{
  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2309 "parser.c"
        break;
      case 38: /* transilev ::= ISOLATION LEVEL SERIALIZABLE */
#line 391 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_SERIALIZABLE;  yy_destructor(yypParser,50,&yymsp[-2].minor);
  yy_destructor(yypParser,51,&yymsp[-1].minor);
  yy_destructor(yypParser,52,&yymsp[0].minor);
}
#line 2317 "parser.c"
        break;
      case 39: /* transilev ::= ISOLATION LEVEL REPEATABLE READ */
#line 392 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_REPEATABLE_READ;  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,56,&yymsp[-1].minor);
  yy_destructor(yypParser,53,&yymsp[0].minor);
}
#line 2326 "parser.c"
        break;
      case 40: /* transilev ::= ISOLATION LEVEL READ COMMITTED */
#line 393 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_COMMITTED;  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,54,&yymsp[0].minor);
}
#line 2335 "parser.c"
        break;
      case 41: /* transilev ::= ISOLATION LEVEL READ UNCOMMITTED */
#line 394 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED;  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,55,&yymsp[0].minor);
}
#line 2344 "parser.c"
        break;
      case 42: /* nm_opt ::= */
      case 57: /* opt_on_conflict ::= */ yytestcase(yyruleno==57);
      case 125: /* as ::= */ yytestcase(yyruleno==125);
#line 396 "./parser.y"
{yygotominor.yy0 = NULL;}
#line 2351 "parser.c"
        break;
      case 43: /* nm_opt ::= nm */
      case 44: /* transtype ::= DEFERRED */ yytestcase(yyruleno==44);
      case 45: /* transtype ::= IMMEDIATE */ yytestcase(yyruleno==45);
      case 46: /* transtype ::= EXCLUSIVE */ yytestcase(yyruleno==46);
      case 120: /* starname ::= STAR */ yytestcase(yyruleno==120);
      case 178: /* value ::= STRING */ yytestcase(yyruleno==178);
      case 179: /* value ::= INTEGER */ yytestcase(yyruleno==179);
      case 180: /* value ::= FLOAT */ yytestcase(yyruleno==180);
      case 189: /* nm ::= JOIN */ yytestcase(yyruleno==189);
      case 190: /* nm ::= ID */ yytestcase(yyruleno==190);
      case 191: /* nm ::= TEXTUAL */ yytestcase(yyruleno==191);
      case 192: /* fullname ::= nm */ yytestcase(yyruleno==192);
#line 397 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2367 "parser.c"
        break;
      case 47: /* transtype ::= READ WRITE */
#line 402 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			      g_value_init (yygotominor.yy0, G_TYPE_STRING);
			      g_value_set_string (yygotominor.yy0, "READ_WRITE");
  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2377 "parser.c"
        break;
      case 48: /* transtype ::= READ ONLY */
#line 406 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			     g_value_init (yygotominor.yy0, G_TYPE_STRING);
			     g_value_set_string (yygotominor.yy0, "READ_ONLY");
  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,58,&yymsp[0].minor);
}
#line 2387 "parser.c"
        break;
      case 49: /* cmd ::= SAVEPOINT nm */
#line 414 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SAVEPOINT);
				    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 2395 "parser.c"
        break;
      case 50: /* cmd ::= RELEASE SAVEPOINT nm */
#line 418 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
				     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 2404 "parser.c"
        break;
      case 51: /* cmd ::= RELEASE nm */
#line 422 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
			   gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2412 "parser.c"
        break;
      case 52: /* cmd ::= ROLLBACK trans_opt_kw TO nm */
#line 426 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
					    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-3].minor);
  yy_destructor(yypParser,122,&yymsp[-1].minor);
}
#line 2421 "parser.c"
        break;
      case 53: /* cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm */
#line 430 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-4].minor);
  yy_destructor(yypParser,122,&yymsp[-2].minor);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 2431 "parser.c"
        break;
      case 54: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP */
#line 437 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-5].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-4].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-7].minor.yy0);
  yy_destructor(yypParser,123,&yymsp[-8].minor);
  yy_destructor(yypParser,124,&yymsp[-6].minor);
  yy_destructor(yypParser,125,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2447 "parser.c"
        break;
      case 55: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values */
#line 445 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-6].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-5].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-2].minor.yy247);
	gda_sql_statement_insert_take_extra_values_list (yygotominor.yy308, yymsp[0].minor.yy393);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-8].minor.yy0);
  yy_destructor(yypParser,123,&yymsp[-9].minor);
  yy_destructor(yypParser,124,&yymsp[-7].minor);
  yy_destructor(yypParser,125,&yymsp[-4].minor);
  yy_destructor(yypParser,102,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-1].minor);
}
#line 2464 "parser.c"
        break;
      case 56: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound */
#line 454 "./parser.y"
{
        yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
        gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-2].minor.yy0);
        gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-1].minor.yy393);
        gda_sql_statement_insert_take_select (yygotominor.yy308, yymsp[0].minor.yy308);
        gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy0);
  yy_destructor(yypParser,123,&yymsp[-5].minor);
  yy_destructor(yypParser,124,&yymsp[-3].minor);
}
#line 2477 "parser.c"
        break;
      case 58: /* opt_on_conflict ::= OR ID */
#line 464 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,68,&yymsp[-1].minor);
}
#line 2483 "parser.c"
        break;
      case 59: /* ins_extra_values ::= ins_extra_values COMMA LP exprlist RP */
#line 474 "./parser.y"
{yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, yymsp[-1].minor.yy247);  yy_destructor(yypParser,120,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2491 "parser.c"
        break;
      case 60: /* ins_extra_values ::= COMMA LP exprlist RP */
#line 475 "./parser.y"
{yygotominor.yy393 = g_slist_append (NULL, yymsp[-1].minor.yy247);  yy_destructor(yypParser,120,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2499 "parser.c"
        break;
      case 61: /* inscollist_opt ::= */
      case 97: /* using_opt ::= */ yytestcase(yyruleno==97);
#line 479 "./parser.y"
{yygotominor.yy393 = NULL;}
#line 2505 "parser.c"
        break;
      case 62: /* inscollist_opt ::= LP inscollist RP */
#line 480 "./parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2512 "parser.c"
        break;
      case 63: /* inscollist ::= inscollist COMMA fullname */
#line 484 "./parser.y"
{GdaSqlField *field;
						    field = gda_sql_field_new (NULL);
						    gda_sql_field_take_name (field, yymsp[0].minor.yy0);
						    yygotominor.yy393 = g_slist_append (yymsp[-2].minor.yy393, field);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2522 "parser.c"
        break;
      case 64: /* inscollist ::= fullname */
#line 489 "./parser.y"
{GdaSqlField *field = gda_sql_field_new (NULL);
				gda_sql_field_take_name (field, yymsp[0].minor.yy0);
				yygotominor.yy393 = g_slist_prepend (NULL, field);
}
#line 2530 "parser.c"
        break;
      case 65: /* cmd ::= DELETE FROM fullname where_opt */
#line 495 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE); 
						  gda_sql_statement_delete_take_table_name (yygotominor.yy308, yymsp[-1].minor.yy0);
						  gda_sql_statement_delete_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);  yy_destructor(yypParser,126,&yymsp[-3].minor);
  yy_destructor(yypParser,127,&yymsp[-2].minor);
}
#line 2539 "parser.c"
        break;
      case 66: /* where_opt ::= */
      case 89: /* having_opt ::= */ yytestcase(yyruleno==89);
      case 101: /* on_cond ::= */ yytestcase(yyruleno==101);
#line 501 "./parser.y"
{yygotominor.yy328 = NULL;}
#line 2546 "parser.c"
        break;
      case 67: /* where_opt ::= WHERE expr */
#line 502 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(yypParser,128,&yymsp[-1].minor);
}
#line 2552 "parser.c"
        break;
      case 68: /* cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt */
#line 505 "./parser.y"
{
	GSList *list;
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_UPDATE);
	gda_sql_statement_update_take_table_name (yygotominor.yy308, yymsp[-3].minor.yy0);
	gda_sql_statement_update_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy0);
	gda_sql_statement_update_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);
	for (list = yymsp[-1].minor.yy393; list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		gda_sql_statement_update_take_set_value (yygotominor.yy308, set->fname, set->expr);
		g_free (set);
	}
	g_slist_free (yymsp[-1].minor.yy393);
  yy_destructor(yypParser,129,&yymsp[-5].minor);
  yy_destructor(yypParser,130,&yymsp[-2].minor);
}
#line 2571 "parser.c"
        break;
      case 69: /* setlist ::= setlist COMMA fullname EQ expr */
#line 529 "./parser.y"
{UpdateSet *set;
							 set = g_new (UpdateSet, 1);
							 set->fname = yymsp[-2].minor.yy0;
							 set->expr = yymsp[0].minor.yy328;
							 yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, set);
  yy_destructor(yypParser,120,&yymsp[-3].minor);
  yy_destructor(yypParser,76,&yymsp[-1].minor);
}
#line 2583 "parser.c"
        break;
      case 70: /* setlist ::= fullname EQ expr */
#line 535 "./parser.y"
{UpdateSet *set;
					set = g_new (UpdateSet, 1);
					set->fname = yymsp[-2].minor.yy0;
					set->expr = yymsp[0].minor.yy328;
					yygotominor.yy393 = g_slist_append (NULL, set);
  yy_destructor(yypParser,76,&yymsp[-1].minor);
}
#line 2594 "parser.c"
        break;
      case 71: /* compound ::= selectcmd */
#line 546 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
	gda_sql_statement_compound_take_stmt (yygotominor.yy308, yymsp[0].minor.yy308);
}
#line 2602 "parser.c"
        break;
      case 72: /* compound ::= compound UNION opt_compound_all compound */
#line 550 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_UNION_ALL : GDA_SQL_STATEMENT_COMPOUND_UNION,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(yypParser,111,&yymsp[-2].minor);
}
#line 2611 "parser.c"
        break;
      case 73: /* compound ::= compound EXCEPT opt_compound_all compound */
#line 555 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL : GDA_SQL_STATEMENT_COMPOUND_EXCEPT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(yypParser,112,&yymsp[-2].minor);
}
#line 2620 "parser.c"
        break;
      case 74: /* compound ::= compound INTERSECT opt_compound_all compound */
#line 560 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL : GDA_SQL_STATEMENT_COMPOUND_INTERSECT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(yypParser,113,&yymsp[-2].minor);
}
#line 2629 "parser.c"
        break;
      case 75: /* opt_compound_all ::= */
#line 566 "./parser.y"
{yygotominor.yy216 = FALSE;}
#line 2634 "parser.c"
        break;
      case 76: /* opt_compound_all ::= ALL */
#line 567 "./parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(yypParser,131,&yymsp[0].minor);
}
#line 2640 "parser.c"
        break;
      case 77: /* selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 574 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SELECT);
	if (yymsp[-7].minor.yy189) {
		gda_sql_statement_select_take_distinct (yygotominor.yy308, yymsp[-7].minor.yy189->distinct, yymsp[-7].minor.yy189->expr);
		g_free (yymsp[-7].minor.yy189);
	}
	gda_sql_statement_select_take_expr_list (yygotominor.yy308, yymsp[-6].minor.yy247);
	gda_sql_statement_select_take_from (yygotominor.yy308, yymsp[-5].minor.yy59);
	gda_sql_statement_select_take_where_cond (yygotominor.yy308, yymsp[-4].minor.yy328);
	gda_sql_statement_select_take_group_by (yygotominor.yy308, yymsp[-3].minor.yy393);
	gda_sql_statement_select_take_having_cond (yygotominor.yy308, yymsp[-2].minor.yy328);
	gda_sql_statement_select_take_order_by (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_select_take_limits (yygotominor.yy308, yymsp[0].minor.yy20.count, yymsp[0].minor.yy20.offset);
  yy_destructor(yypParser,132,&yymsp[-8].minor);
}
#line 2659 "parser.c"
        break;
      case 78: /* limit_opt ::= */
#line 591 "./parser.y"
{yygotominor.yy20.count = NULL; yygotominor.yy20.offset = NULL;}
#line 2664 "parser.c"
        break;
      case 79: /* limit_opt ::= LIMIT expr */
#line 592 "./parser.y"
{yygotominor.yy20.count = yymsp[0].minor.yy328; yygotominor.yy20.offset = NULL;  yy_destructor(yypParser,133,&yymsp[-1].minor);
}
#line 2670 "parser.c"
        break;
      case 80: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 593 "./parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(yypParser,133,&yymsp[-3].minor);
  yy_destructor(yypParser,32,&yymsp[-1].minor);
}
#line 2677 "parser.c"
        break;
      case 81: /* limit_opt ::= LIMIT expr COMMA expr */
#line 594 "./parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(yypParser,133,&yymsp[-3].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2684 "parser.c"
        break;
      case 82: /* orderby_opt ::= */
#line 598 "./parser.y"
{yygotominor.yy247 = 0;}
#line 2689 "parser.c"
        break;
      case 83: /* orderby_opt ::= ORDER BY sortlist */
#line 599 "./parser.y"
{yygotominor.yy247 = yymsp[0].minor.yy247;  yy_destructor(yypParser,134,&yymsp[-2].minor);
  yy_destructor(yypParser,135,&yymsp[-1].minor);
}
#line 2696 "parser.c"
        break;
      case 84: /* sortlist ::= sortlist COMMA expr sortorder */
#line 603 "./parser.y"
{GdaSqlSelectOrder *order;
							 order = gda_sql_select_order_new (NULL);
							 order->expr = yymsp[-1].minor.yy328;
							 order->asc = yymsp[0].minor.yy216;
							 yygotominor.yy247 = g_slist_append (yymsp[-3].minor.yy247, order);
  yy_destructor(yypParser,120,&yymsp[-2].minor);
}
#line 2707 "parser.c"
        break;
      case 85: /* sortlist ::= expr sortorder */
#line 609 "./parser.y"
{GdaSqlSelectOrder *order;
				       order = gda_sql_select_order_new (NULL);
				       order->expr = yymsp[-1].minor.yy328;
				       order->asc = yymsp[0].minor.yy216;
				       yygotominor.yy247 = g_slist_prepend (NULL, order);
}
#line 2717 "parser.c"
        break;
      case 86: /* sortorder ::= ASC */
#line 617 "./parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(yypParser,5,&yymsp[0].minor);
}
#line 2723 "parser.c"
        break;
      case 87: /* sortorder ::= DESC */
#line 618 "./parser.y"
{yygotominor.yy216 = FALSE;  yy_destructor(yypParser,14,&yymsp[0].minor);
}
#line 2729 "parser.c"
        break;
      case 88: /* sortorder ::= */
#line 619 "./parser.y"
{yygotominor.yy216 = TRUE;}
#line 2734 "parser.c"
        break;
      case 90: /* having_opt ::= HAVING expr */
#line 625 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(yypParser,136,&yymsp[-1].minor);
}
#line 2740 "parser.c"
        break;
      case 91: /* groupby_opt ::= */
#line 629 "./parser.y"
{yygotominor.yy393 = 0;}
#line 2745 "parser.c"
        break;
      case 92: /* groupby_opt ::= GROUP BY nexprlist */
#line 630 "./parser.y"
{yygotominor.yy393 = yymsp[0].minor.yy247;  yy_destructor(yypParser,137,&yymsp[-2].minor);
  yy_destructor(yypParser,135,&yymsp[-1].minor);
}
#line 2752 "parser.c"
        break;
      case 93: /* from ::= */
      case 98: /* stl_prefix ::= */ yytestcase(yyruleno==98);
#line 634 "./parser.y"
{yygotominor.yy59 = NULL;}
#line 2758 "parser.c"
        break;
      case 94: /* from ::= FROM seltablist */
#line 635 "./parser.y"
{yygotominor.yy59 = yymsp[0].minor.yy59;  yy_destructor(yypParser,127,&yymsp[-1].minor);
}
#line 2764 "parser.c"
        break;
      case 95: /* seltablist ::= stl_prefix seltarget on_cond using_opt */
#line 642 "./parser.y"
{
	GSList *last;
	if (yymsp[-3].minor.yy59)
		yygotominor.yy59 = yymsp[-3].minor.yy59;
	else 
		yygotominor.yy59 = gda_sql_select_from_new (NULL);
	gda_sql_select_from_take_new_target (yygotominor.yy59, yymsp[-2].minor.yy224);
	last = g_slist_last (yygotominor.yy59->joins);
	if (last) {
		GdaSqlSelectJoin *join = (GdaSqlSelectJoin *) (last->data);
		join->expr = yymsp[-1].minor.yy328;
		join->position = g_slist_length (yygotominor.yy59->targets) - 1;
		join->use = yymsp[0].minor.yy393;
	}
}
#line 2783 "parser.c"
        break;
      case 96: /* using_opt ::= USING LP inscollist RP */
#line 660 "./parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(yypParser,138,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2791 "parser.c"
        break;
      case 99: /* stl_prefix ::= seltablist jointype */
#line 664 "./parser.y"
{GdaSqlSelectJoin *join;
					      yygotominor.yy59 = yymsp[-1].minor.yy59;
					      join = gda_sql_select_join_new (GDA_SQL_ANY_PART (yygotominor.yy59));
					      join->type = yymsp[0].minor.yy317;
					      gda_sql_select_from_take_new_join (yygotominor.yy59, join);
}
#line 2801 "parser.c"
        break;
      case 100: /* on_cond ::= ON expr */
#line 674 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(yypParser,139,&yymsp[-1].minor);
}
#line 2807 "parser.c"
        break;
      case 102: /* jointype ::= COMMA */
#line 678 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2813 "parser.c"
        break;
      case 103: /* jointype ::= JOIN */
#line 679 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2819 "parser.c"
        break;
      case 104: /* jointype ::= CROSS JOIN */
#line 680 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,110,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2826 "parser.c"
        break;
      case 105: /* jointype ::= INNER JOIN */
#line 681 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,105,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2833 "parser.c"
        break;
      case 106: /* jointype ::= NATURAL JOIN */
#line 682 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_NATURAL;  yy_destructor(yypParser,106,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2840 "parser.c"
        break;
      case 107: /* jointype ::= LEFT JOIN */
#line 683 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,107,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2847 "parser.c"
        break;
      case 108: /* jointype ::= LEFT OUTER JOIN */
#line 684 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,107,&yymsp[-2].minor);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2855 "parser.c"
        break;
      case 109: /* jointype ::= RIGHT JOIN */
#line 685 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,108,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2862 "parser.c"
        break;
      case 110: /* jointype ::= RIGHT OUTER JOIN */
#line 686 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,108,&yymsp[-2].minor);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2870 "parser.c"
        break;
      case 111: /* jointype ::= FULL JOIN */
#line 687 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,109,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2877 "parser.c"
        break;
      case 112: /* jointype ::= FULL OUTER JOIN */
#line 688 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,109,&yymsp[-2].minor);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2885 "parser.c"
        break;
      case 113: /* seltarget ::= fullname as */
#line 693 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
				     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
				     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy0);
}
#line 2893 "parser.c"
        break;
      case 114: /* seltarget ::= fullname ID */
#line 697 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
                                     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
                                     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy0);
}
#line 2901 "parser.c"
        break;
      case 115: /* seltarget ::= LP compound RP as */
#line 701 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
					     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
					     gda_sql_select_target_take_select (yygotominor.yy224, yymsp[-2].minor.yy308);
  yy_destructor(yypParser,102,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-1].minor);
}
#line 2911 "parser.c"
        break;
      case 116: /* sclp ::= selcollist COMMA */
#line 711 "./parser.y"
{yygotominor.yy247 = yymsp[-1].minor.yy247;  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2917 "parser.c"
        break;
      case 117: /* sclp ::= */
      case 132: /* exprlist ::= */ yytestcase(yyruleno==132);
#line 712 "./parser.y"
{yygotominor.yy247 = NULL;}
#line 2923 "parser.c"
        break;
      case 118: /* selcollist ::= sclp expr as */
#line 714 "./parser.y"
{GdaSqlSelectField *field;
					  field = gda_sql_select_field_new (NULL);
					  gda_sql_select_field_take_expr (field, yymsp[-1].minor.yy328);
					  gda_sql_select_field_take_alias (field, yymsp[0].minor.yy0); 
					  yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, field);}
#line 2932 "parser.c"
        break;
      case 119: /* selcollist ::= sclp starname */
#line 719 "./parser.y"
{GdaSqlSelectField *field;
					field = gda_sql_select_field_new (NULL);
					gda_sql_select_field_take_star_value (field, yymsp[0].minor.yy0);
					yygotominor.yy247 = g_slist_append (yymsp[-1].minor.yy247, field);}
#line 2940 "parser.c"
        break;
      case 121: /* starname ::= nm DOT STAR */
      case 193: /* fullname ::= nm DOT nm */ yytestcase(yyruleno==193);
#line 725 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,141,&yymsp[-1].minor);
}
#line 2954 "parser.c"
        break;
      case 122: /* starname ::= nm DOT nm DOT STAR */
      case 194: /* fullname ::= nm DOT nm DOT nm */ yytestcase(yyruleno==194);
#line 734 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy0), 
							 g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-4].minor.yy0); g_free (yymsp[-4].minor.yy0);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,141,&yymsp[-3].minor);
  yy_destructor(yypParser,141,&yymsp[-1].minor);
}
#line 2971 "parser.c"
        break;
      case 123: /* as ::= AS fullname */
      case 124: /* as ::= AS value */ yytestcase(yyruleno==124);
#line 745 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,142,&yymsp[-1].minor);
}
#line 2978 "parser.c"
        break;
      case 126: /* distinct ::= */
#line 751 "./parser.y"
{yygotominor.yy189 = NULL;}
#line 2983 "parser.c"
        break;
      case 127: /* distinct ::= ALL */
#line 752 "./parser.y"
{yygotominor.yy189 = NULL;  yy_destructor(yypParser,131,&yymsp[0].minor);
}
#line 2989 "parser.c"
        break;
      case 128: /* distinct ::= DISTINCT */
#line 753 "./parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE;  yy_destructor(yypParser,143,&yymsp[0].minor);
}
#line 2995 "parser.c"
        break;
      case 129: /* distinct ::= DISTINCT ON expr */
#line 754 "./parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE; yygotominor.yy189->expr = yymsp[0].minor.yy328;  yy_destructor(yypParser,143,&yymsp[-2].minor);
  yy_destructor(yypParser,139,&yymsp[-1].minor);
}
#line 3002 "parser.c"
        break;
      case 130: /* nexprlist ::= nexprlist COMMA expr */
      case 133: /* exprlist ::= exprlist COMMA expr */ yytestcase(yyruleno==133);
#line 759 "./parser.y"
{yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, yymsp[0].minor.yy328);  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 3009 "parser.c"
        break;
      case 131: /* nexprlist ::= expr */
      case 134: /* exprlist ::= expr */ yytestcase(yyruleno==134);
#line 760 "./parser.y"
{yygotominor.yy247 = g_slist_append (NULL, yymsp[0].minor.yy328);}
#line 3015 "parser.c"
        break;
      case 135: /* expr ::= pvalue */
#line 772 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;}
#line 3020 "parser.c"
        break;
      case 136: /* expr ::= value */
      case 138: /* expr ::= fullname */ yytestcase(yyruleno==138);
#line 773 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[0].minor.yy0;}
#line 3026 "parser.c"
        break;
      case 137: /* expr ::= LP expr RP */
#line 774 "./parser.y"
{yygotominor.yy328 = yymsp[-1].minor.yy328;  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3033 "parser.c"
        break;
      case 139: /* expr ::= fullname LP exprlist RP */
#line 776 "./parser.y"
{GdaSqlFunction *func;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    gda_sql_function_take_args_list (func, yymsp[-1].minor.yy247);
					    yygotominor.yy328->func = func;  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3045 "parser.c"
        break;
      case 140: /* expr ::= fullname LP compound RP */
#line 782 "./parser.y"
{GdaSqlFunction *func;
					     GdaSqlExpr *expr;
					     yygotominor.yy328 = gda_sql_expr_new (NULL); 
					     func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					     gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					     expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					     gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					     gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					     yygotominor.yy328->func = func;  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3060 "parser.c"
        break;
      case 141: /* expr ::= fullname LP starname RP */
#line 791 "./parser.y"
{GdaSqlFunction *func;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					    expr->value = yymsp[-1].minor.yy0;
					    gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					    yygotominor.yy328->func = func;  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3075 "parser.c"
        break;
      case 142: /* expr ::= CAST LP expr AS fullname RP */
#line 800 "./parser.y"
{yygotominor.yy328 = yymsp[-3].minor.yy328;
						yymsp[-3].minor.yy328->cast_as = g_value_dup_string (yymsp[-1].minor.yy0);
						g_value_reset (yymsp[-1].minor.yy0);
						g_free (yymsp[-1].minor.yy0);  yy_destructor(yypParser,10,&yymsp[-5].minor);
  yy_destructor(yypParser,102,&yymsp[-4].minor);
  yy_destructor(yypParser,142,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3087 "parser.c"
        break;
      case 143: /* expr ::= expr PGCAST fullname */
#line 804 "./parser.y"
{yygotominor.yy328 = yymsp[-2].minor.yy328;
					 yymsp[-2].minor.yy328->cast_as = g_value_dup_string (yymsp[0].minor.yy0);
					 g_value_reset (yymsp[0].minor.yy0);
					 g_free (yymsp[0].minor.yy0);  yy_destructor(yypParser,114,&yymsp[-1].minor);
}
#line 3096 "parser.c"
        break;
      case 144: /* expr ::= expr PLUS|MINUS expr */
#line 809 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3101 "parser.c"
        break;
      case 145: /* expr ::= expr STAR expr */
#line 810 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_STAR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,94,&yymsp[-1].minor);
}
#line 3107 "parser.c"
        break;
      case 146: /* expr ::= expr SLASH|REM expr */
      case 147: /* expr ::= expr BITAND|BITOR expr */ yytestcase(yyruleno==147);
      case 153: /* expr ::= expr GT|LEQ|GEQ|LT expr */ yytestcase(yyruleno==153);
      case 154: /* expr ::= expr DIFF|EQ expr */ yytestcase(yyruleno==154);
      case 156: /* expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr */ yytestcase(yyruleno==156);
#line 811 "./parser.y"
{yygotominor.yy328 = create_two_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3116 "parser.c"
        break;
      case 148: /* expr ::= MINUS expr */
#line 814 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_MINUS, yymsp[0].minor.yy328);  yy_destructor(yypParser,93,&yymsp[-1].minor);
}
#line 3122 "parser.c"
        break;
      case 149: /* expr ::= PLUS expr */
#line 815 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_PLUS, yymsp[0].minor.yy328);  yy_destructor(yypParser,92,&yymsp[-1].minor);
}
#line 3128 "parser.c"
        break;
      case 150: /* expr ::= expr AND expr */
#line 817 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_AND, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 3134 "parser.c"
        break;
      case 151: /* expr ::= expr OR expr */
#line 818 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_OR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,68,&yymsp[-1].minor);
}
#line 3140 "parser.c"
        break;
      case 152: /* expr ::= expr CONCAT expr */
#line 819 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_CONCAT, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,97,&yymsp[-1].minor);
}
#line 3146 "parser.c"
        break;
      case 155: /* expr ::= expr LIKE expr */
#line 823 "./parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_TYPE_LIKE, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,26,&yymsp[-1].minor);
}
#line 3152 "parser.c"
        break;
      case 157: /* expr ::= expr BETWEEN expr AND expr */
#line 825 "./parser.y"
{GdaSqlOperation *cond;
						  yygotominor.yy328 = gda_sql_expr_new (NULL);
						  cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						  yygotominor.yy328->cond = cond;
						  cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						  cond->operands = g_slist_append (NULL, yymsp[-4].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,77,&yymsp[-3].minor);
  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 3170 "parser.c"
        break;
      case 158: /* expr ::= expr NOT BETWEEN expr AND expr */
#line 838 "./parser.y"
{GdaSqlOperation *cond;
						      GdaSqlExpr *expr;
						      expr = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (expr));
						      expr->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						      cond->operands = g_slist_append (NULL, yymsp[-5].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);

						      yygotominor.yy328 = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						      yygotominor.yy328->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOT;
						      cond->operands = g_slist_prepend (NULL, expr);
						      GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,70,&yymsp[-4].minor);
  yy_destructor(yypParser,77,&yymsp[-3].minor);
  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 3197 "parser.c"
        break;
      case 159: /* expr ::= NOT expr */
#line 859 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_NOT, yymsp[0].minor.yy328);  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 3203 "parser.c"
        break;
      case 160: /* expr ::= BITNOT expr */
#line 860 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_BITNOT, yymsp[0].minor.yy328);  yy_destructor(yypParser,101,&yymsp[-1].minor);
}
#line 3209 "parser.c"
        break;
      case 161: /* expr ::= expr uni_op */
#line 861 "./parser.y"
{yygotominor.yy328 = create_uni_expr (yymsp[0].minor.yy381, yymsp[-1].minor.yy328);}
#line 3214 "parser.c"
        break;
      case 162: /* expr ::= expr IS expr */
#line 863 "./parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_TYPE_IS, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,71,&yymsp[-1].minor);
}
#line 3220 "parser.c"
        break;
      case 163: /* expr ::= LP compound RP */
#line 864 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); gda_sql_expr_take_select (yygotominor.yy328, yymsp[-1].minor.yy308);  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3227 "parser.c"
        break;
      case 164: /* expr ::= expr IN LP exprlist RP */
#line 865 "./parser.y"
{GdaSqlOperation *cond;
					   GSList *list;
					   yygotominor.yy328 = gda_sql_expr_new (NULL);
					   cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					   yygotominor.yy328->cond = cond;
					   cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					   cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-4].minor.yy328);
					   for (list = cond->operands; list; list = list->next)
						   GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3244 "parser.c"
        break;
      case 165: /* expr ::= expr IN LP compound RP */
#line 875 "./parser.y"
{GdaSqlOperation *cond;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL);
					    cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    yygotominor.yy328->cond = cond;
					    cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					    
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					    gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					    cond->operands = g_slist_prepend (NULL, expr);
					    cond->operands = g_slist_prepend (cond->operands, yymsp[-4].minor.yy328);
					    GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3264 "parser.c"
        break;
      case 166: /* expr ::= expr NOT IN LP exprlist RP */
#line 888 "./parser.y"
{GdaSqlOperation *cond;
					       GSList *list;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-5].minor.yy328);
					       for (list = cond->operands; list; list = list->next)
						       GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,70,&yymsp[-4].minor);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3282 "parser.c"
        break;
      case 167: /* expr ::= expr NOT IN LP compound RP */
#line 898 "./parser.y"
{GdaSqlOperation *cond;
					       GdaSqlExpr *expr;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       
					       expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					       gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					       cond->operands = g_slist_prepend (NULL, expr);
					       cond->operands = g_slist_prepend (cond->operands, yymsp[-5].minor.yy328);
					       GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,70,&yymsp[-4].minor);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-2].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 3303 "parser.c"
        break;
      case 168: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 911 "./parser.y"
{
	GdaSqlCase *sc;
	GSList *list;
	yygotominor.yy328 = gda_sql_expr_new (NULL);
	sc = gda_sql_case_new (GDA_SQL_ANY_PART (yygotominor.yy328));
	sc->base_expr = yymsp[-3].minor.yy122;
	sc->else_expr = yymsp[-1].minor.yy122;
	sc->when_expr_list = yymsp[-2].minor.yy263.when_list;
	sc->then_expr_list = yymsp[-2].minor.yy263.then_list;
	yygotominor.yy328->case_s = sc;
	for (list = sc->when_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
	for (list = sc->then_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
  yy_destructor(yypParser,144,&yymsp[-4].minor);
  yy_destructor(yypParser,17,&yymsp[0].minor);
}
#line 3324 "parser.c"
        break;
      case 169: /* case_operand ::= expr */
#line 929 "./parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;}
#line 3329 "parser.c"
        break;
      case 170: /* case_operand ::= */
      case 174: /* case_else ::= */ yytestcase(yyruleno==174);
#line 930 "./parser.y"
{yygotominor.yy122 = NULL;}
#line 3335 "parser.c"
        break;
      case 171: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 936 "./parser.y"
{
	yygotominor.yy263.when_list = g_slist_append (yymsp[-4].minor.yy263.when_list, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_append (yymsp[-4].minor.yy263.then_list, yymsp[0].minor.yy328);
  yy_destructor(yypParser,145,&yymsp[-3].minor);
  yy_destructor(yypParser,146,&yymsp[-1].minor);
}
#line 3345 "parser.c"
        break;
      case 172: /* case_exprlist ::= WHEN expr THEN expr */
#line 940 "./parser.y"
{
	yygotominor.yy263.when_list = g_slist_prepend (NULL, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_prepend (NULL, yymsp[0].minor.yy328);
  yy_destructor(yypParser,145,&yymsp[-3].minor);
  yy_destructor(yypParser,146,&yymsp[-1].minor);
}
#line 3355 "parser.c"
        break;
      case 173: /* case_else ::= ELSE expr */
#line 947 "./parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;  yy_destructor(yypParser,147,&yymsp[-1].minor);
}
#line 3361 "parser.c"
        break;
      case 175: /* uni_op ::= ISNULL */
#line 951 "./parser.y"
{yygotominor.yy381 = GDA_SQL_OPERATOR_TYPE_ISNULL;  yy_destructor(yypParser,73,&yymsp[0].minor);
}
#line 3367 "parser.c"
        break;
      case 176: /* uni_op ::= IS NOTNULL */
#line 952 "./parser.y"
{yygotominor.yy381 = GDA_SQL_OPERATOR_TYPE_ISNOTNULL;  yy_destructor(yypParser,71,&yymsp[-1].minor);
  yy_destructor(yypParser,74,&yymsp[0].minor);
}
#line 3374 "parser.c"
        break;
      case 177: /* value ::= NULL */
#line 956 "./parser.y"
{yygotominor.yy0 = NULL;  yy_destructor(yypParser,148,&yymsp[0].minor);
}
#line 3380 "parser.c"
        break;
      case 181: /* pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET */
#line 965 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(yypParser,150,&yymsp[-3].minor);
  yy_destructor(yypParser,151,&yymsp[-2].minor);
  yy_destructor(yypParser,152,&yymsp[0].minor);
}
#line 3388 "parser.c"
        break;
      case 182: /* pvalue ::= value LSBRACKET paramspec RSBRACKET */
#line 966 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[-3].minor.yy0; yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(yypParser,151,&yymsp[-2].minor);
  yy_destructor(yypParser,152,&yymsp[0].minor);
}
#line 3395 "parser.c"
        break;
      case 183: /* pvalue ::= SIMPLEPARAM */
#line 967 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = gda_sql_param_spec_new (yymsp[0].minor.yy0);}
#line 3400 "parser.c"
        break;
      case 184: /* paramspec ::= */
#line 972 "./parser.y"
{yygotominor.yy405 = NULL;}
#line 3405 "parser.c"
        break;
      case 185: /* paramspec ::= paramspec PNAME */
#line 973 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_name (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3411 "parser.c"
        break;
      case 186: /* paramspec ::= paramspec PDESCR */
#line 975 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_descr (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3417 "parser.c"
        break;
      case 187: /* paramspec ::= paramspec PTYPE */
#line 977 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_type (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3423 "parser.c"
        break;
      case 188: /* paramspec ::= paramspec PNULLOK */
#line 979 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					   gda_sql_param_spec_take_nullok (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3429 "parser.c"
        break;
      default:
      /* (34) trans_opt_kw ::= */ yytestcase(yyruleno==34);
      /* (36) opt_comma ::= */ yytestcase(yyruleno==36);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  gda_sql_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 22 "./parser.y"

	gda_sql_parser_set_syntax_error (pdata->parser);
#line 3496 "parser.c"
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "gda_sql_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void gda_sql_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  gda_sql_parserTOKENTYPE yyminor       /* The value for the token */
  gda_sql_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  gda_sql_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
