/* abstractcollection.c generated by valac 0.11.5, the Vala compiler
 * generated from abstractcollection.vala, do not modify */

/* abstractcollection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define GEE_TYPE_READ_ONLY_COLLECTION (gee_read_only_collection_get_type ())
#define GEE_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection))
#define GEE_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))
#define GEE_IS_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_IS_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_READ_ONLY_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))

typedef struct _GeeReadOnlyCollection GeeReadOnlyCollection;
typedef struct _GeeReadOnlyCollectionClass GeeReadOnlyCollectionClass;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeCollection* _read_only_view;
};


static gpointer gee_abstract_collection_parent_class = NULL;
static GeeIterableIface* gee_abstract_collection_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_abstract_collection_gee_collection_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
#define GEE_ABSTRACT_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionPrivate))
enum  {
	GEE_ABSTRACT_COLLECTION_DUMMY_PROPERTY,
	GEE_ABSTRACT_COLLECTION_G_TYPE,
	GEE_ABSTRACT_COLLECTION_G_DUP_FUNC,
	GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC,
	GEE_ABSTRACT_COLLECTION_SIZE,
	GEE_ABSTRACT_COLLECTION_IS_EMPTY,
	GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE,
	GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW
};
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_contains (GeeAbstractCollection* self, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_add (GeeAbstractCollection* self, gconstpointer item);
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_remove (GeeAbstractCollection* self, gconstpointer item);
void gee_abstract_collection_clear (GeeAbstractCollection* self);
static void gee_abstract_collection_real_clear (GeeAbstractCollection* self);
gpointer* gee_abstract_collection_to_array (GeeAbstractCollection* self, int* result_length1);
static gpointer* gee_abstract_collection_real_to_array (GeeAbstractCollection* self, int* result_length1);
static gboolean* gee_abstract_collection_to_bool_array (GeeCollection* coll, int* result_length1);
static gchar* gee_abstract_collection_to_char_array (GeeCollection* coll, int* result_length1);
static guchar* gee_abstract_collection_to_uchar_array (GeeCollection* coll, int* result_length1);
static gint* gee_abstract_collection_to_int_array (GeeCollection* coll, int* result_length1);
static guint* gee_abstract_collection_to_uint_array (GeeCollection* coll, int* result_length1);
static gint64* gee_abstract_collection_to_int64_array (GeeCollection* coll, int* result_length1);
static guint64* gee_abstract_collection_to_uint64_array (GeeCollection* coll, int* result_length1);
static glong* gee_abstract_collection_to_long_array (GeeCollection* coll, int* result_length1);
static gulong* gee_abstract_collection_to_ulong_array (GeeCollection* coll, int* result_length1);
static gfloat* gee_abstract_collection_to_float_array (GeeCollection* coll, int* result_length1);
static gdouble* gee_abstract_collection_to_double_array (GeeCollection* coll, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_abstract_collection_add_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_add_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_collection_get_is_empty (GeeCollection* self);
gboolean gee_abstract_collection_contains_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_contains_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_abstract_collection_remove_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_remove_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_abstract_collection_retain_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_retain_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
static GeeIterator* gee_abstract_collection_real_iterator (GeeAbstractCollection* self);
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self);
GeeCollection* gee_abstract_collection_get_read_only_view (GeeAbstractCollection* self);
GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GeeReadOnlyCollection* gee_read_only_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GType gee_read_only_collection_get_type (void) G_GNUC_CONST;
static void gee_abstract_collection_finalize (GObject* obj);
GType gee_iterable_get_element_type (GeeIterable* self);
static void _vala_gee_abstract_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_abstract_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_contains (GeeAbstractCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_contains'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->contains (self, item);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_add (GeeAbstractCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_add'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->add (self, item);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_remove (GeeAbstractCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->remove (self, item);
}


/**
 * {@inheritDoc}
 */
static void gee_abstract_collection_real_clear (GeeAbstractCollection* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_clear'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void gee_abstract_collection_clear (GeeAbstractCollection* self) {
	GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->clear (self);
}


/**
 * {@inheritDoc}
 */
static gpointer* gee_abstract_collection_real_to_array (GeeAbstractCollection* self, int* result_length1) {
	gpointer* result = NULL;
	GType t;
	g_return_val_if_fail (self != NULL, NULL);
	t = self->priv->g_type;
	if (t == G_TYPE_BOOLEAN) {
		gint _tmp0_;
		gboolean* _tmp1_ = NULL;
		gpointer* _tmp2_;
		_tmp1_ = gee_abstract_collection_to_bool_array (GEE_COLLECTION (self), &_tmp0_);
		_tmp2_ = (gpointer*) _tmp1_;
		*result_length1 = _tmp0_;
		result = _tmp2_;
		return result;
	} else {
		if (t == G_TYPE_CHAR) {
			gint _tmp3_;
			gchar* _tmp4_ = NULL;
			gpointer* _tmp5_;
			_tmp4_ = gee_abstract_collection_to_char_array (GEE_COLLECTION (self), &_tmp3_);
			_tmp5_ = (gpointer*) _tmp4_;
			*result_length1 = _tmp3_;
			result = _tmp5_;
			return result;
		} else {
			if (t == G_TYPE_UCHAR) {
				gint _tmp6_;
				guchar* _tmp7_ = NULL;
				gpointer* _tmp8_;
				_tmp7_ = gee_abstract_collection_to_uchar_array (GEE_COLLECTION (self), &_tmp6_);
				_tmp8_ = (gpointer*) _tmp7_;
				*result_length1 = _tmp6_;
				result = _tmp8_;
				return result;
			} else {
				if (t == G_TYPE_INT) {
					gint _tmp9_;
					gint* _tmp10_ = NULL;
					gpointer* _tmp11_;
					_tmp10_ = gee_abstract_collection_to_int_array (GEE_COLLECTION (self), &_tmp9_);
					_tmp11_ = (gpointer*) _tmp10_;
					*result_length1 = _tmp9_;
					result = _tmp11_;
					return result;
				} else {
					if (t == G_TYPE_UINT) {
						gint _tmp12_;
						guint* _tmp13_ = NULL;
						gpointer* _tmp14_;
						_tmp13_ = gee_abstract_collection_to_uint_array (GEE_COLLECTION (self), &_tmp12_);
						_tmp14_ = (gpointer*) _tmp13_;
						*result_length1 = _tmp12_;
						result = _tmp14_;
						return result;
					} else {
						if (t == G_TYPE_INT64) {
							gint _tmp15_;
							gint64* _tmp16_ = NULL;
							gpointer* _tmp17_;
							_tmp16_ = gee_abstract_collection_to_int64_array (GEE_COLLECTION (self), &_tmp15_);
							_tmp17_ = (gpointer*) _tmp16_;
							*result_length1 = _tmp15_;
							result = _tmp17_;
							return result;
						} else {
							if (t == G_TYPE_UINT64) {
								gint _tmp18_;
								guint64* _tmp19_ = NULL;
								gpointer* _tmp20_;
								_tmp19_ = gee_abstract_collection_to_uint64_array (GEE_COLLECTION (self), &_tmp18_);
								_tmp20_ = (gpointer*) _tmp19_;
								*result_length1 = _tmp18_;
								result = _tmp20_;
								return result;
							} else {
								if (t == G_TYPE_LONG) {
									gint _tmp21_;
									glong* _tmp22_ = NULL;
									gpointer* _tmp23_;
									_tmp22_ = gee_abstract_collection_to_long_array (GEE_COLLECTION (self), &_tmp21_);
									_tmp23_ = (gpointer*) _tmp22_;
									*result_length1 = _tmp21_;
									result = _tmp23_;
									return result;
								} else {
									if (t == G_TYPE_ULONG) {
										gint _tmp24_;
										gulong* _tmp25_ = NULL;
										gpointer* _tmp26_;
										_tmp25_ = gee_abstract_collection_to_ulong_array (GEE_COLLECTION (self), &_tmp24_);
										_tmp26_ = (gpointer*) _tmp25_;
										*result_length1 = _tmp24_;
										result = _tmp26_;
										return result;
									} else {
										if (t == G_TYPE_FLOAT) {
											gint _tmp27_;
											gfloat* _tmp28_ = NULL;
											gpointer* _tmp29_;
											_tmp28_ = gee_abstract_collection_to_float_array (GEE_COLLECTION (self), &_tmp27_);
											_tmp29_ = (gpointer*) _tmp28_;
											*result_length1 = _tmp27_;
											result = _tmp29_;
											return result;
										} else {
											if (t == G_TYPE_DOUBLE) {
												gint _tmp30_;
												gdouble* _tmp31_ = NULL;
												gpointer* _tmp32_;
												_tmp31_ = gee_abstract_collection_to_double_array (GEE_COLLECTION (self), &_tmp30_);
												_tmp32_ = (gpointer*) _tmp31_;
												*result_length1 = _tmp30_;
												result = _tmp32_;
												return result;
											} else {
												gint _tmp33_;
												gpointer* _tmp34_ = NULL;
												gpointer* array;
												gint array_length1;
												gint _array_size_;
												gint index;
												gpointer* _tmp42_;
												_tmp33_ = gee_collection_get_size ((GeeCollection*) self);
												_tmp34_ = g_new0 (gpointer, _tmp33_);
												array = _tmp34_;
												array_length1 = _tmp33_;
												_array_size_ = _tmp33_;
												index = 0;
												{
													GeeIterator* _tmp35_ = NULL;
													GeeIterator* _element_it;
													_tmp35_ = gee_abstract_collection_iterator (self);
													_element_it = _tmp35_;
													while (TRUE) {
														gboolean _tmp36_;
														gpointer _tmp37_ = NULL;
														gpointer element;
														gint _tmp38_;
														gpointer _tmp39_;
														gconstpointer _tmp40_;
														gpointer _tmp41_;
														_tmp36_ = gee_iterator_next (_element_it);
														if (!_tmp36_) {
															break;
														}
														_tmp37_ = gee_iterator_get (_element_it);
														element = _tmp37_;
														_tmp38_ = index;
														index = _tmp38_ + 1;
														_tmp39_ = (_tmp40_ = element, ((_tmp40_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp40_) : self->priv->g_dup_func ((gpointer) _tmp40_));
														_tmp41_ = _tmp39_;
														((array[_tmp38_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (array[_tmp38_] = (self->priv->g_destroy_func (array[_tmp38_]), NULL));
														array[_tmp38_] = _tmp41_;
														((element == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (element = (self->priv->g_destroy_func (element), NULL));
													}
													_g_object_unref0 (_element_it);
												}
												_tmp42_ = array;
												*result_length1 = array_length1;
												result = _tmp42_;
												return result;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


gpointer* gee_abstract_collection_to_array (GeeAbstractCollection* self, int* result_length1) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->to_array (self, result_length1);
}


static gboolean* gee_abstract_collection_to_bool_array (GeeCollection* coll, int* result_length1) {
	gboolean* result = NULL;
	gint _tmp0_;
	gboolean* _tmp1_ = NULL;
	gboolean* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gboolean* _tmp6_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (gboolean, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gboolean element;
			gint _tmp5_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			element = GPOINTER_TO_INT (_tmp4_);
			_tmp5_ = index;
			index = _tmp5_ + 1;
			array[_tmp5_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp6_ = array;
	*result_length1 = array_length1;
	result = _tmp6_;
	return result;
}


static gchar* gee_abstract_collection_to_char_array (GeeCollection* coll, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gchar* _tmp6_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (gchar, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gchar element;
			gint _tmp5_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			element = GPOINTER_TO_INT (_tmp4_);
			_tmp5_ = index;
			index = _tmp5_ + 1;
			array[_tmp5_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp6_ = array;
	*result_length1 = array_length1;
	result = _tmp6_;
	return result;
}


static guchar* gee_abstract_collection_to_uchar_array (GeeCollection* coll, int* result_length1) {
	guchar* result = NULL;
	gint _tmp0_;
	guchar* _tmp1_ = NULL;
	guchar* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	guchar* _tmp6_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (guchar, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			guchar element;
			gint _tmp5_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			element = GPOINTER_TO_UINT (_tmp4_);
			_tmp5_ = index;
			index = _tmp5_ + 1;
			array[_tmp5_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp6_ = array;
	*result_length1 = array_length1;
	result = _tmp6_;
	return result;
}


static gint* gee_abstract_collection_to_int_array (GeeCollection* coll, int* result_length1) {
	gint* result = NULL;
	gint _tmp0_;
	gint* _tmp1_ = NULL;
	gint* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gint* _tmp6_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (gint, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gint element;
			gint _tmp5_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			element = GPOINTER_TO_INT (_tmp4_);
			_tmp5_ = index;
			index = _tmp5_ + 1;
			array[_tmp5_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp6_ = array;
	*result_length1 = array_length1;
	result = _tmp6_;
	return result;
}


static guint* gee_abstract_collection_to_uint_array (GeeCollection* coll, int* result_length1) {
	guint* result = NULL;
	gint _tmp0_;
	guint* _tmp1_ = NULL;
	guint* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	guint* _tmp6_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (guint, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			guint element;
			gint _tmp5_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			element = GPOINTER_TO_UINT (_tmp4_);
			_tmp5_ = index;
			index = _tmp5_ + 1;
			array[_tmp5_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp6_ = array;
	*result_length1 = array_length1;
	result = _tmp6_;
	return result;
}


static gint64* gee_abstract_collection_to_int64_array (GeeCollection* coll, int* result_length1) {
	gint64* result = NULL;
	gint _tmp0_;
	gint64* _tmp1_ = NULL;
	gint64* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gint64* _tmp8_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (gint64, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gint64* _tmp5_;
			gint64 _tmp6_;
			gint64 element;
			gint _tmp7_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			_tmp5_ = (gint64*) _tmp4_;
			element = (_tmp6_ = *_tmp5_, _g_free0 (_tmp5_), _tmp6_);
			_tmp7_ = index;
			index = _tmp7_ + 1;
			array[_tmp7_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp8_ = array;
	*result_length1 = array_length1;
	result = _tmp8_;
	return result;
}


static guint64* gee_abstract_collection_to_uint64_array (GeeCollection* coll, int* result_length1) {
	guint64* result = NULL;
	gint _tmp0_;
	guint64* _tmp1_ = NULL;
	guint64* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	guint64* _tmp8_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (guint64, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			guint64* _tmp5_;
			guint64 _tmp6_;
			guint64 element;
			gint _tmp7_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			_tmp5_ = (guint64*) _tmp4_;
			element = (_tmp6_ = *_tmp5_, _g_free0 (_tmp5_), _tmp6_);
			_tmp7_ = index;
			index = _tmp7_ + 1;
			array[_tmp7_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp8_ = array;
	*result_length1 = array_length1;
	result = _tmp8_;
	return result;
}


static glong* gee_abstract_collection_to_long_array (GeeCollection* coll, int* result_length1) {
	glong* result = NULL;
	gint _tmp0_;
	glong* _tmp1_ = NULL;
	glong* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	glong* _tmp6_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (glong, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			glong element;
			gint _tmp5_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			element = GPOINTER_TO_INT (_tmp4_);
			_tmp5_ = index;
			index = _tmp5_ + 1;
			array[_tmp5_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp6_ = array;
	*result_length1 = array_length1;
	result = _tmp6_;
	return result;
}


static gulong* gee_abstract_collection_to_ulong_array (GeeCollection* coll, int* result_length1) {
	gulong* result = NULL;
	gint _tmp0_;
	gulong* _tmp1_ = NULL;
	gulong* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gulong* _tmp6_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (gulong, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gulong element;
			gint _tmp5_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			element = GPOINTER_TO_UINT (_tmp4_);
			_tmp5_ = index;
			index = _tmp5_ + 1;
			array[_tmp5_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp6_ = array;
	*result_length1 = array_length1;
	result = _tmp6_;
	return result;
}


static gfloat* gee_abstract_collection_to_float_array (GeeCollection* coll, int* result_length1) {
	gfloat* result = NULL;
	gint _tmp0_;
	gfloat* _tmp1_ = NULL;
	gfloat* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gfloat* _tmp8_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (gfloat, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gfloat* _tmp5_;
			gfloat _tmp6_;
			gfloat element;
			gint _tmp7_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			_tmp5_ = (gfloat*) _tmp4_;
			element = (_tmp6_ = *_tmp5_, _g_free0 (_tmp5_), _tmp6_);
			_tmp7_ = index;
			index = _tmp7_ + 1;
			array[_tmp7_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp8_ = array;
	*result_length1 = array_length1;
	result = _tmp8_;
	return result;
}


static gdouble* gee_abstract_collection_to_double_array (GeeCollection* coll, int* result_length1) {
	gdouble* result = NULL;
	gint _tmp0_;
	gdouble* _tmp1_ = NULL;
	gdouble* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gdouble* _tmp8_;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = g_new0 (gdouble, _tmp0_);
	array = _tmp1_;
	array_length1 = _tmp0_;
	_array_size_ = _tmp0_;
	index = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _element_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gdouble* _tmp5_;
			gdouble _tmp6_;
			gdouble element;
			gint _tmp7_;
			_tmp3_ = gee_iterator_next (_element_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_element_it);
			_tmp5_ = (gdouble*) _tmp4_;
			element = (_tmp6_ = *_tmp5_, _g_free0 (_tmp5_), _tmp6_);
			_tmp7_ = index;
			index = _tmp7_ + 1;
			array[_tmp7_] = element;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp8_ = array;
	*result_length1 = array_length1;
	result = _tmp8_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_add_all (GeeAbstractCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean changed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp0_ = gee_collection_get_is_empty (collection);
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	changed = FALSE;
	{
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _item_it;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) collection);
		_item_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			gpointer item;
			gboolean _tmp4_;
			_tmp2_ = gee_iterator_next (_item_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_item_it);
			item = _tmp3_;
			_tmp4_ = gee_abstract_collection_add (self, item);
			changed = changed | _tmp4_;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = changed;
	return result;
}


gboolean gee_abstract_collection_add_all (GeeAbstractCollection* self, GeeCollection* collection) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->add_all (self, collection);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_contains_all (GeeAbstractCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp0_ = gee_collection_get_size (collection);
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self);
	if (_tmp0_ > _tmp1_) {
		result = FALSE;
		return result;
	}
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _item_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) collection);
		_item_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			gpointer item;
			gboolean _tmp5_;
			_tmp3_ = gee_iterator_next (_item_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_item_it);
			item = _tmp4_;
			_tmp5_ = gee_abstract_collection_contains (self, item);
			if (!_tmp5_) {
				result = FALSE;
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				_g_object_unref0 (_item_it);
				return result;
			}
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = TRUE;
	return result;
}


gboolean gee_abstract_collection_contains_all (GeeAbstractCollection* self, GeeCollection* collection) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->contains_all (self, collection);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_remove_all (GeeAbstractCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gboolean changed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	changed = FALSE;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _item_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) collection);
		_item_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			gpointer item;
			gboolean _tmp3_;
			_tmp1_ = gee_iterator_next (_item_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_item_it);
			item = _tmp2_;
			_tmp3_ = gee_abstract_collection_remove (self, item);
			changed = changed | _tmp3_;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = changed;
	return result;
}


gboolean gee_abstract_collection_remove_all (GeeAbstractCollection* self, GeeCollection* collection) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->remove_all (self, collection);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_retain_all (GeeAbstractCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gboolean changed;
	gint _tmp0_;
	gpointer* _tmp1_ = NULL;
	gpointer* items;
	gint items_length1;
	gint _items_size_;
	gint _tmp2_;
	gint size_of_items;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	changed = FALSE;
	_tmp1_ = gee_abstract_collection_to_array (self, &_tmp0_);
	items = _tmp1_;
	items_length1 = _tmp0_;
	_items_size_ = _tmp0_;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) self);
	size_of_items = _tmp2_;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				if (!_tmp3_) {
					index++;
				}
				_tmp3_ = FALSE;
				if (!(index < size_of_items)) {
					break;
				}
				_tmp4_ = gee_collection_contains (collection, items[index]);
				if (!_tmp4_) {
					gboolean _tmp5_;
					_tmp5_ = gee_abstract_collection_remove (self, items[index]);
					changed = changed | _tmp5_;
				}
			}
		}
	}
	result = changed;
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	return result;
}


gboolean gee_abstract_collection_retain_all (GeeAbstractCollection* self, GeeCollection* collection) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->retain_all (self, collection);
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_abstract_collection_real_iterator (GeeAbstractCollection* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_iterator'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->iterator (self);
}


GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeAbstractCollection * self = NULL;
	self = (GeeAbstractCollection*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


gint gee_abstract_collection_get_size (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_size (self);
}


gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_is_empty (self);
}


static gboolean gee_abstract_collection_real_get_is_empty (GeeAbstractCollection* base) {
	gboolean result;
	GeeAbstractCollection* self;
	gint _tmp0_;
	self = base;
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self);
	result = _tmp0_ == 0;
	return result;
}


static GType gee_abstract_collection_real_get_element_type (GeeIterable* base) {
	GType result;
	GeeAbstractCollection* self;
	self = (GeeAbstractCollection*) base;
	result = self->priv->g_type;
	return result;
}


GeeCollection* gee_abstract_collection_get_read_only_view (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_read_only_view (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeCollection* gee_abstract_collection_real_get_read_only_view (GeeAbstractCollection* base) {
	GeeCollection* result;
	GeeAbstractCollection* self;
	GeeCollection* _tmp0_;
	GeeCollection* instance;
	self = base;
	_tmp0_ = _g_object_ref0 (self->priv->_read_only_view);
	instance = _tmp0_;
	if (self->priv->_read_only_view == NULL) {
		GeeReadOnlyCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		_tmp1_ = gee_read_only_collection_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, (GeeCollection*) self);
		_tmp2_ = (GeeCollection*) _tmp1_;
		_g_object_unref0 (instance);
		instance = _tmp2_;
		self->priv->_read_only_view = instance;
		g_object_add_weak_pointer ((GObject*) instance, (void**) (&self->priv->_read_only_view));
	}
	result = instance;
	return result;
}


static void gee_abstract_collection_class_init (GeeAbstractCollectionClass * klass) {
	gee_abstract_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractCollectionPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_abstract_collection_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_abstract_collection_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_abstract_collection_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_abstract_collection_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->to_array = gee_abstract_collection_real_to_array;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add_all = gee_abstract_collection_real_add_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains_all = gee_abstract_collection_real_contains_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove_all = gee_abstract_collection_real_remove_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->retain_all = gee_abstract_collection_real_retain_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_abstract_collection_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_is_empty = gee_abstract_collection_real_get_is_empty;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only_view = gee_abstract_collection_real_get_read_only_view;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_abstract_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_abstract_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_abstract_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_SIZE, "size");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_IS_EMPTY, "is-empty");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE, "element-type");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW, "read-only-view");
}


static void gee_abstract_collection_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_abstract_collection_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) gee_abstract_collection_iterator;
	iface->get_element_type = gee_abstract_collection_real_get_element_type;
}


static void gee_abstract_collection_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_abstract_collection_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_contains;
	iface->add = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_add;
	iface->remove = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_remove;
	iface->clear = (void (*)(GeeCollection*)) gee_abstract_collection_clear;
	iface->to_array = (gpointer* (*)(GeeCollection* ,int*)) gee_abstract_collection_to_array;
	iface->add_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_add_all;
	iface->contains_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_contains_all;
	iface->remove_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_remove_all;
	iface->retain_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_retain_all;
	iface->get_size = (gint (*) (GeeCollection *)) gee_abstract_collection_get_size;
	iface->get_is_empty = (gboolean (*) (GeeCollection *)) gee_abstract_collection_get_is_empty;
	iface->get_read_only_view = (GeeCollection* (*) (GeeCollection *)) gee_abstract_collection_get_read_only_view;
}


static void gee_abstract_collection_instance_init (GeeAbstractCollection * self) {
	self->priv = GEE_ABSTRACT_COLLECTION_GET_PRIVATE (self);
}


static void gee_abstract_collection_finalize (GObject* obj) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (obj);
	G_OBJECT_CLASS (gee_abstract_collection_parent_class)->finalize (obj);
}


/**
 * Skeletal implementation of the {@link Collection} interface.
 *
 * Contains common code shared by all collection implementations.
 *
 * @see AbstractList
 * @see AbstractSet
 * @see AbstractMultiSet
 */
GType gee_abstract_collection_get_type (void) {
	static volatile gsize gee_abstract_collection_type_id__volatile = 0;
	if (g_once_init_enter (&gee_abstract_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractCollection), 0, (GInstanceInitFunc) gee_abstract_collection_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_abstract_collection_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_abstract_collection_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_abstract_collection_type_id;
		gee_abstract_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeAbstractCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_collection_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_abstract_collection_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
		g_once_init_leave (&gee_abstract_collection_type_id__volatile, gee_abstract_collection_type_id);
	}
	return gee_abstract_collection_type_id__volatile;
}


static void _vala_gee_abstract_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (object);
	switch (property_id) {
		case GEE_ABSTRACT_COLLECTION_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_collection_get_is_empty (self));
		break;
		case GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		case GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW:
		g_value_take_object (value, gee_abstract_collection_get_read_only_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_abstract_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_COLLECTION_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_COLLECTION_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



