/* linkedlist.c generated by valac 0.18.0.57-8d977, the Vala compiler
 * generated from linkedlist.vala, do not modify */

/* linkedlist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Mark Lee, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mark Lee <marklee@src.gnome.org>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_LINKED_LIST (gee_linked_list_get_type ())
#define GEE_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedList))
#define GEE_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))
#define GEE_IS_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LINKED_LIST))
#define GEE_IS_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LINKED_LIST))
#define GEE_LINKED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))

typedef struct _GeeLinkedList GeeLinkedList;
typedef struct _GeeLinkedListClass GeeLinkedListClass;
typedef struct _GeeLinkedListPrivate GeeLinkedListPrivate;
typedef struct _GeeLinkedListNode GeeLinkedListNode;
#define _gee_linked_list_node_free0(var) ((var == NULL) ? NULL : (var = (gee_linked_list_node_free (var), NULL)))

#define GEE_LINKED_LIST_TYPE_ITERATOR (gee_linked_list_iterator_get_type ())
#define GEE_LINKED_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator))
#define GEE_LINKED_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))
#define GEE_LINKED_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))

typedef struct _GeeLinkedListIterator GeeLinkedListIterator;
typedef struct _GeeLinkedListIteratorClass GeeLinkedListIteratorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeLinkedListIteratorPrivate GeeLinkedListIteratorPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*insert) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareFunc compare_func);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeLinkedList {
	GeeAbstractList parent_instance;
	GeeLinkedListPrivate * priv;
};

struct _GeeLinkedListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeLinkedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _size;
	gint _stamp;
	GeeLinkedListNode* _head;
	GeeLinkedListNode* _tail;
	GEqualFunc _equal_func;
};

struct _GeeLinkedListNode {
	gpointer data;
	GeeLinkedListNode* prev;
	GeeLinkedListNode* next;
};

struct _GeeLinkedListIterator {
	GObject parent_instance;
	GeeLinkedListIteratorPrivate * priv;
};

struct _GeeLinkedListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeLinkedListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gboolean started;
	gboolean removed;
	GeeLinkedListNode* position;
	gint _stamp;
	GeeLinkedList* _list;
	gint _index;
};


static gpointer gee_linked_list_parent_class = NULL;
static gpointer gee_linked_list_iterator_parent_class = NULL;
static GeeIteratorIface* gee_linked_list_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_linked_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeListIteratorIface* gee_linked_list_iterator_gee_list_iterator_parent_iface = NULL;
static GeeQueueIface* gee_linked_list_gee_queue_parent_iface = NULL;
static GeeDequeIface* gee_linked_list_gee_deque_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_linked_list_get_type (void) G_GNUC_CONST;
static void gee_linked_list_node_free (GeeLinkedListNode* self);
#define GEE_LINKED_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_LINKED_LIST, GeeLinkedListPrivate))
enum  {
	GEE_LINKED_LIST_DUMMY_PROPERTY,
	GEE_LINKED_LIST_G_TYPE,
	GEE_LINKED_LIST_G_DUP_FUNC,
	GEE_LINKED_LIST_G_DESTROY_FUNC,
	GEE_LINKED_LIST_EQUAL_FUNC,
	GEE_LINKED_LIST_SIZE,
	GEE_LINKED_LIST_CAPACITY,
	GEE_LINKED_LIST_REMAINING_CAPACITY,
	GEE_LINKED_LIST_IS_FULL
};
void gee_abstract_collection_clear (GeeAbstractCollection* self);
GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeAbstractList* gee_abstract_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GEqualFunc gee_functions_get_equal_func_for (GType t);
static void gee_linked_list_set_equal_func (GeeLinkedList* self, GEqualFunc value);
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base);
static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list);
static GType gee_linked_list_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base);
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item);
gint gee_abstract_list_index_of (GeeAbstractList* self, gconstpointer item);
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item);
static GeeLinkedListNode* gee_linked_list_node_new (gpointer data);
static GeeLinkedListNode* gee_linked_list_node_new (gpointer data);
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item);
GEqualFunc gee_linked_list_get_equal_func (GeeLinkedList* self);
static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* _n);
static void gee_linked_list_real_clear (GeeAbstractCollection* base);
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index);
static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index);
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item);
static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gpointer gee_abstract_list_get (GeeAbstractList* self, gint index);
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base, gint index);
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
static gpointer gee_linked_list_real_first (GeeAbstractList* base);
static gpointer gee_linked_list_real_last (GeeAbstractList* base);
static gboolean gee_linked_list_real_offer (GeeQueue* base, gconstpointer element);
gboolean gee_deque_offer_tail (GeeDeque* self, gconstpointer element);
static gpointer gee_linked_list_real_peek (GeeQueue* base);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_linked_list_real_poll (GeeQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gint gee_linked_list_real_drain (GeeQueue* base, GeeCollection* recipient, gint amount);
gint gee_deque_drain_head (GeeDeque* self, GeeCollection* recipient, gint amount);
static gboolean gee_linked_list_real_offer_head (GeeDeque* base, gconstpointer element);
void gee_abstract_list_insert (GeeAbstractList* self, gint index, gconstpointer item);
static gpointer gee_linked_list_real_peek_head (GeeDeque* base);
static gpointer gee_linked_list_real_poll_head (GeeDeque* base);
gpointer gee_abstract_list_remove_at (GeeAbstractList* self, gint index);
static gint gee_linked_list_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount);
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base, gconstpointer element);
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base);
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base);
static gint gee_linked_list_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
static void gee_linked_list_node_instance_init (GeeLinkedListNode * self);
#define GEE_LINKED_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorPrivate))
enum  {
	GEE_LINKED_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_LINKED_LIST_ITERATOR_G_TYPE,
	GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC,
	GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_linked_list_iterator_real_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_first (GeeIterator* base);
static gpointer gee_linked_list_iterator_real_get (GeeIterator* base);
static void gee_linked_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base);
static void gee_linked_list_iterator_real_set (GeeListIterator* base, gconstpointer item);
static void gee_linked_list_iterator_real_insert (GeeListIterator* base, gconstpointer item);
static void gee_linked_list_iterator_real_add (GeeListIterator* base, gconstpointer item);
static gint gee_linked_list_iterator_real_index (GeeListIterator* base);
static void gee_linked_list_iterator_finalize (GObject* obj);
static void _vala_gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_linked_list_finalize (GObject* obj);
gint gee_queue_get_capacity (GeeQueue* self);
gint gee_queue_get_remaining_capacity (GeeQueue* self);
gboolean gee_queue_get_is_full (GeeQueue* self);
static void _vala_gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Constructs a new, empty linked list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeLinkedList* gee_linked_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	GeeLinkedList * self = NULL;
	GEqualFunc _tmp0_;
	GEqualFunc _tmp2_;
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) gee_abstract_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->g_type = g_type;
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->g_dup_func = g_dup_func;
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 55 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = equal_func;
#line 55 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == NULL) {
#line 461 "linkedlist.c"
		GEqualFunc _tmp1_ = NULL;
#line 56 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp1_ = gee_functions_get_equal_func_for (g_type);
#line 56 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		equal_func = _tmp1_;
#line 467 "linkedlist.c"
	}
#line 58 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = equal_func;
#line 58 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_set_equal_func (self, _tmp2_);
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return self;
#line 475 "linkedlist.c"
}


GeeLinkedList* gee_linked_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return gee_linked_list_construct (GEE_TYPE_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
#line 482 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base) {
	GeeLinkedList * self;
	GeeIterator* result = NULL;
	GeeLinkedListIterator* _tmp0_;
#line 68 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = (GeeIterator*) _tmp0_;
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 501 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base) {
	GeeLinkedList * self;
	GeeListIterator* result = NULL;
	GeeLinkedListIterator* _tmp0_;
#line 75 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 76 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 76 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = (GeeListIterator*) _tmp0_;
#line 76 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 520 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gint _tmp1_ = 0;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 90 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = item;
#line 90 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = gee_abstract_list_index_of ((GeeAbstractList*) self, _tmp0_);
#line 90 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp1_ != (-1);
#line 90 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 542 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	GeeLinkedListNode* _tmp2_;
	GeeLinkedListNode* n;
	gboolean _tmp3_ = FALSE;
	GeeLinkedListNode* _tmp4_;
	gboolean _tmp6_;
	gint _tmp15_;
#line 96 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = item;
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = gee_linked_list_node_new (_tmp1_);
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = _tmp2_;
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = self->priv->_head;
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp4_ == NULL) {
#line 574 "linkedlist.c"
		GeeLinkedListNode* _tmp5_;
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp5_ = self->priv->_tail;
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp3_ = _tmp5_ == NULL;
#line 580 "linkedlist.c"
	} else {
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp3_ = FALSE;
#line 584 "linkedlist.c"
	}
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = _tmp3_;
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp6_) {
#line 590 "linkedlist.c"
		GeeLinkedListNode* _tmp7_;
		GeeLinkedListNode* _tmp8_;
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp7_ = n;
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->_tail = _tmp7_;
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp8_ = n;
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = NULL;
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (self->priv->_head);
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->_head = _tmp8_;
#line 605 "linkedlist.c"
	} else {
		GeeLinkedListNode* _tmp9_;
		GeeLinkedListNode* _tmp10_;
		GeeLinkedListNode* _tmp11_;
		GeeLinkedListNode* _tmp12_;
		GeeLinkedListNode* _tmp13_;
		GeeLinkedListNode* _tmp14_;
#line 102 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp9_ = n;
#line 102 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp10_ = self->priv->_tail;
#line 102 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp9_->prev = _tmp10_;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp11_ = self->priv->_tail;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp12_ = n;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = NULL;
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (_tmp11_->next);
#line 103 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp11_->next = _tmp12_;
#line 104 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp13_ = self->priv->_tail;
#line 104 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp14_ = _tmp13_->next;
#line 104 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->_tail = _tmp14_;
#line 635 "linkedlist.c"
	}
#line 110 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp15_ = self->priv->_size;
#line 110 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_size = _tmp15_ + 1;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = TRUE;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (n);
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 647 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeLinkedList * self;
	gboolean result = FALSE;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 659 "linkedlist.c"
	{
		GeeLinkedListNode* _tmp0_;
		GeeLinkedListNode* n;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp0_ = self->priv->_head;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = _tmp0_;
#line 667 "linkedlist.c"
		{
			gboolean _tmp1_;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp1_ = TRUE;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			while (TRUE) {
#line 674 "linkedlist.c"
				gboolean _tmp2_;
				GeeLinkedListNode* _tmp5_;
				GEqualFunc _tmp6_;
				GEqualFunc _tmp7_;
				gconstpointer _tmp8_;
				GeeLinkedListNode* _tmp9_;
				gconstpointer _tmp10_;
				gboolean _tmp11_ = FALSE;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp2_ = _tmp1_;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (!_tmp2_) {
#line 687 "linkedlist.c"
					GeeLinkedListNode* _tmp3_;
					GeeLinkedListNode* _tmp4_;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp3_ = n;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp4_ = _tmp3_->next;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					n = _tmp4_;
#line 696 "linkedlist.c"
				}
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp1_ = FALSE;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp5_ = n;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (!(_tmp5_ != NULL)) {
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					break;
#line 706 "linkedlist.c"
				}
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp6_ = gee_linked_list_get_equal_func (self);
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp7_ = _tmp6_;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp8_ = item;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp9_ = n;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp10_ = _tmp9_->data;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp11_ = _tmp7_ (_tmp8_, _tmp10_);
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (_tmp11_) {
#line 722 "linkedlist.c"
					GeeLinkedListNode* _tmp12_;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp12_ = n;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_gee_linked_list_remove_node (self, _tmp12_);
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					result = TRUE;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					return result;
#line 732 "linkedlist.c"
				}
			}
		}
	}
#line 124 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = FALSE;
#line 124 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 741 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_clear (GeeAbstractCollection* base) {
	GeeLinkedList * self;
	gint _tmp2_;
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	while (TRUE) {
#line 755 "linkedlist.c"
		GeeLinkedListNode* _tmp0_;
		GeeLinkedListNode* _tmp1_;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp0_ = self->priv->_head;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (!(_tmp0_ != NULL)) {
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			break;
#line 764 "linkedlist.c"
		}
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp1_ = self->priv->_head;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_remove_node (self, _tmp1_);
#line 770 "linkedlist.c"
	}
#line 135 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = self->priv->_stamp;
#line 135 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_stamp = _tmp2_ + 1;
#line 136 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (self->priv->_head);
#line 136 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_head = NULL;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_tail = NULL;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_size = 0;
#line 784 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_get (GeeAbstractList* base, gint index) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeLinkedListNode* _tmp4_ = NULL;
	GeeLinkedListNode* n;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = index;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ >= 0, "index >= 0");
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = index;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = self->priv->_size;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp1_ < _tmp2_, "index < this._size");
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = index;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = _gee_linked_list_get_node_at (self, _tmp3_);
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = _tmp4_;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (n != NULL, "n != null");
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = n->data;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp6_;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 830 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeLinkedList * self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeLinkedListNode* _tmp4_ = NULL;
	GeeLinkedListNode* n;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = index;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ >= 0, "index >= 0");
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = index;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = self->priv->_size;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp1_ < _tmp2_, "index < this._size");
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = index;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = _gee_linked_list_get_node_at (self, _tmp3_);
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = _tmp4_;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_if_fail (n != NULL);
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = item;
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	((n->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (n->data = (self->priv->g_destroy_func (n->data), NULL));
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n->data = _tmp6_;
#line 875 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer _g_object_ref0 (gpointer self) {
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return self ? g_object_ref (self) : NULL;
#line 885 "linkedlist.c"
}


static gint gee_linked_list_real_index_of (GeeAbstractList* base, gconstpointer item) {
	GeeLinkedList * self;
	gint result = 0;
	gint _result_;
	gint idx;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_result_ = -1;
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	idx = 0;
#line 900 "linkedlist.c"
	{
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _node_item_list;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _node_item_size;
		gint _node_item_index;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp0_ = _g_object_ref0 (self);
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_node_item_list = _tmp0_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp1_ = _node_item_list;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp3_ = _tmp2_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_node_item_size = _tmp3_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_node_item_index = -1;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		while (TRUE) {
#line 925 "linkedlist.c"
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			GeeLinkedList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_ = NULL;
			gpointer node_item;
			GEqualFunc _tmp10_;
			GEqualFunc _tmp11_;
			gconstpointer _tmp12_;
			gconstpointer _tmp13_;
			gboolean _tmp14_ = FALSE;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp4_ = _node_item_index;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_node_item_index = _tmp4_ + 1;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp5_ = _node_item_index;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp6_ = _node_item_size;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				break;
#line 950 "linkedlist.c"
			}
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp7_ = _node_item_list;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp8_ = _node_item_index;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			node_item = _tmp9_;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp10_ = gee_linked_list_get_equal_func (self);
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp11_ = _tmp10_;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp12_ = item;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp13_ = node_item;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp14_ = _tmp11_ (_tmp12_, _tmp13_);
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			if (_tmp14_) {
#line 972 "linkedlist.c"
				gint _tmp15_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp15_ = idx;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_result_ = _tmp15_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				((node_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node_item = (self->priv->g_destroy_func (node_item), NULL));
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				break;
#line 982 "linkedlist.c"
			} else {
				gint _tmp16_;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp16_ = idx;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				idx = _tmp16_ + 1;
#line 989 "linkedlist.c"
			}
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			((node_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node_item = (self->priv->g_destroy_func (node_item), NULL));
#line 993 "linkedlist.c"
		}
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_g_object_unref0 (_node_item_list);
#line 997 "linkedlist.c"
	}
#line 179 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _result_;
#line 179 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1003 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static void gee_linked_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeLinkedList * self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = index;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ >= 0, "index >= 0");
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = index;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = self->priv->_size;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp1_ <= _tmp2_, "index <= this._size");
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = index;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = self->priv->_size;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp3_ == _tmp4_) {
#line 1035 "linkedlist.c"
		gconstpointer _tmp5_;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp5_ = item;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) self, _tmp5_);
#line 1041 "linkedlist.c"
	} else {
		gconstpointer _tmp6_;
		gpointer _tmp7_;
		GeeLinkedListNode* _tmp8_;
		GeeLinkedListNode* n;
		gint _tmp9_;
		gint _tmp34_;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp6_ = item;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp8_ = gee_linked_list_node_new (_tmp7_);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = _tmp8_;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp9_ = index;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (_tmp9_ == 0) {
#line 1061 "linkedlist.c"
			GeeLinkedListNode* _tmp10_;
			GeeLinkedListNode* _tmp11_;
			GeeLinkedListNode* _tmp12_;
			GeeLinkedListNode* _tmp13_;
			GeeLinkedListNode* _tmp14_;
			GeeLinkedListNode* _tmp15_;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp10_ = n;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp11_ = self->priv->_head;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			self->priv->_head = NULL;
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_gee_linked_list_node_free0 (_tmp10_->next);
#line 194 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp10_->next = _tmp11_;
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp12_ = n;
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp13_ = _tmp12_->next;
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp14_ = n;
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp13_->prev = _tmp14_;
#line 196 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp15_ = n;
#line 196 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			n = NULL;
#line 196 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_gee_linked_list_node_free0 (self->priv->_head);
#line 196 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			self->priv->_head = _tmp15_;
#line 1094 "linkedlist.c"
		} else {
			GeeLinkedListNode* _tmp16_;
			GeeLinkedListNode* prev;
			GeeLinkedListNode* _tmp24_;
			GeeLinkedListNode* _tmp25_;
			GeeLinkedListNode* _tmp26_;
			GeeLinkedListNode* _tmp27_;
			GeeLinkedListNode* _tmp28_;
			GeeLinkedListNode* _tmp29_;
			GeeLinkedListNode* _tmp30_;
			GeeLinkedListNode* _tmp31_;
			GeeLinkedListNode* _tmp32_;
			GeeLinkedListNode* _tmp33_;
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp16_ = self->priv->_head;
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			prev = _tmp16_;
#line 1112 "linkedlist.c"
			{
				gint i;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				i = 0;
#line 1117 "linkedlist.c"
				{
					gboolean _tmp17_;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp17_ = TRUE;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					while (TRUE) {
#line 1124 "linkedlist.c"
						gboolean _tmp18_;
						gint _tmp20_;
						gint _tmp21_;
						GeeLinkedListNode* _tmp22_;
						GeeLinkedListNode* _tmp23_;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						_tmp18_ = _tmp17_;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						if (!_tmp18_) {
#line 1134 "linkedlist.c"
							gint _tmp19_;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp19_ = i;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							i = _tmp19_ + 1;
#line 1140 "linkedlist.c"
						}
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						_tmp17_ = FALSE;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						_tmp20_ = i;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						_tmp21_ = index;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						if (!(_tmp20_ < (_tmp21_ - 1))) {
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							break;
#line 1152 "linkedlist.c"
						}
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						_tmp22_ = prev;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						_tmp23_ = _tmp22_->next;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						prev = _tmp23_;
#line 1160 "linkedlist.c"
					}
				}
			}
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp24_ = n;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp25_ = prev;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp24_->prev = _tmp25_;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp26_ = n;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp27_ = prev;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp28_ = _tmp27_->next;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp27_->next = NULL;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_gee_linked_list_node_free0 (_tmp26_->next);
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp26_->next = _tmp28_;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp29_ = n;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp30_ = _tmp29_->next;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp31_ = n;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp30_->prev = _tmp31_;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp32_ = prev;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp33_ = n;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			n = NULL;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_gee_linked_list_node_free0 (_tmp32_->next);
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp32_->next = _tmp33_;
#line 1200 "linkedlist.c"
		}
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp34_ = self->priv->_size;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->_size = _tmp34_ + 1;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (n);
#line 1208 "linkedlist.c"
	}
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base, gint index) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeLinkedListNode* _tmp4_ = NULL;
	GeeLinkedListNode* n;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
	gpointer element;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = index;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ >= 0, "index >= 0");
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = index;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = self->priv->_size;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp1_ < _tmp2_, "index < this._size");
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = index;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = _gee_linked_list_get_node_at (self, _tmp3_);
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = _tmp4_;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (n != NULL, "n != null");
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = n->data;
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	element = _tmp6_;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_remove_node (self, n);
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = element;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1260 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base, gint start, gint stop) {
	GeeLinkedList * self;
	GeeList* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	GeeLinkedList* _tmp7_;
	GeeList* slice;
	gint _tmp8_;
	GeeLinkedListNode* _tmp9_ = NULL;
	GeeLinkedListNode* n;
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = start;
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = stop;
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (_tmp0_ <= _tmp1_, NULL);
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = start;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (_tmp2_ >= 0, NULL);
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = stop;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = self->priv->_size;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (_tmp3_ <= _tmp4_, NULL);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = gee_linked_list_get_equal_func (self);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = _tmp5_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp7_ = gee_linked_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp6_);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	slice = (GeeList*) _tmp7_;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp8_ = start;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp9_ = _gee_linked_list_get_node_at (self, _tmp8_);
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = _tmp9_;
#line 1314 "linkedlist.c"
	{
		gint _tmp10_;
		gint i;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp10_ = start;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		i = _tmp10_;
#line 1322 "linkedlist.c"
		{
			gboolean _tmp11_;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp11_ = TRUE;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			while (TRUE) {
#line 1329 "linkedlist.c"
				gboolean _tmp12_;
				gint _tmp14_;
				gint _tmp15_;
				GeeList* _tmp16_;
				GeeLinkedListNode* _tmp17_;
				gconstpointer _tmp18_;
				GeeLinkedListNode* _tmp19_;
				GeeLinkedListNode* _tmp20_;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp12_ = _tmp11_;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (!_tmp12_) {
#line 1342 "linkedlist.c"
					gint _tmp13_;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp13_ = i;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					i = _tmp13_ + 1;
#line 1348 "linkedlist.c"
				}
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp11_ = FALSE;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp14_ = i;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp15_ = stop;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (!(_tmp14_ < _tmp15_)) {
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					break;
#line 1360 "linkedlist.c"
				}
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp16_ = slice;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp17_ = n;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp18_ = _tmp17_->data;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				gee_collection_add ((GeeCollection*) _tmp16_, _tmp18_);
#line 241 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp19_ = n;
#line 241 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp20_ = _tmp19_->next;
#line 241 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				n = _tmp20_;
#line 1376 "linkedlist.c"
			}
		}
	}
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = slice;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1384 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_first (GeeAbstractList* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_;
	GeeLinkedListNode* _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_size;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ > 0, "_size > 0");
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_head;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->data;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp3_;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1414 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_last (GeeAbstractList* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_;
	GeeLinkedListNode* _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_size;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ > 0, "_size > 0");
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_tail;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->data;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp3_;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1444 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer (GeeQueue* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 287 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = element;
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = gee_deque_offer_tail ((GeeDeque*) self, _tmp0_);
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp1_;
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1466 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek (GeeQueue* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = gee_deque_peek_head ((GeeDeque*) self);
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp0_;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1485 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll (GeeQueue* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = gee_deque_poll_head ((GeeDeque*) self);
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp0_;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1504 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain (GeeQueue* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = recipient;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = amount;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = gee_deque_drain_head ((GeeDeque*) self, _tmp0_, _tmp1_);
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp2_;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1531 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer_head (GeeDeque* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
#line 315 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = element;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_abstract_list_insert ((GeeAbstractList*) self, 0, _tmp0_);
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = TRUE;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1552 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek_head (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_;
	gpointer _tmp1_ = NULL;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_size;
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == 0) {
#line 325 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = NULL;
#line 325 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 1574 "linkedlist.c"
	}
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) self, 0);
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp1_;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1582 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll_head (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_;
	gpointer _tmp1_ = NULL;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_size;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == 0) {
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = NULL;
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 1604 "linkedlist.c"
	}
#line 337 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0);
#line 337 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp1_;
#line 337 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1612 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp11_;
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 344 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = amount;
#line 344 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == (-1)) {
#line 1632 "linkedlist.c"
		gint _tmp1_;
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp1_ = self->priv->_size;
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		amount = _tmp1_;
#line 1638 "linkedlist.c"
	}
	{
		gint i;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		i = 0;
#line 1644 "linkedlist.c"
		{
			gboolean _tmp2_;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp2_ = TRUE;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			while (TRUE) {
#line 1651 "linkedlist.c"
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GeeCollection* _tmp8_;
				gpointer _tmp9_ = NULL;
				gpointer _tmp10_;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp3_ = _tmp2_;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (!_tmp3_) {
#line 1663 "linkedlist.c"
					gint _tmp4_;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp4_ = i;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					i = _tmp4_ + 1;
#line 1669 "linkedlist.c"
				}
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp2_ = FALSE;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp5_ = i;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp6_ = amount;
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 347 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					break;
#line 1681 "linkedlist.c"
				}
#line 348 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp7_ = self->priv->_size;
#line 348 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (_tmp7_ == 0) {
#line 349 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					result = i;
#line 349 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					return result;
#line 1691 "linkedlist.c"
				}
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp8_ = recipient;
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp9_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0);
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp10_ = _tmp9_;
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				gee_collection_add (_tmp8_, _tmp10_);
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				((_tmp10_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp10_ = (self->priv->g_destroy_func (_tmp10_), NULL));
#line 1703 "linkedlist.c"
			}
		}
	}
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp11_ = amount;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp11_;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1713 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base, gconstpointer element) {
	GeeLinkedList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 360 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = element;
#line 360 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = gee_abstract_collection_add ((GeeAbstractCollection*) self, _tmp0_);
#line 360 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp1_;
#line 360 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1735 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
#line 366 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_size;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == 0) {
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = NULL;
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 1758 "linkedlist.c"
	}
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_size;
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) self, _tmp1_ - 1);
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp2_;
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1768 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base) {
	GeeLinkedList * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
#line 376 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_size;
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == 0) {
#line 378 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = NULL;
#line 378 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 1791 "linkedlist.c"
	}
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_size;
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, _tmp1_ - 1);
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp2_;
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1801 "linkedlist.c"
}


/**
 * {@inheritDoc}
 */
static gint gee_linked_list_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeLinkedList * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp12_;
#line 386 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 386 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 387 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = amount;
#line 387 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == (-1)) {
#line 1821 "linkedlist.c"
		gint _tmp1_;
#line 388 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp1_ = self->priv->_size;
#line 388 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		amount = _tmp1_;
#line 1827 "linkedlist.c"
	}
	{
		gint i;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		i = 0;
#line 1833 "linkedlist.c"
		{
			gboolean _tmp2_;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp2_ = TRUE;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			while (TRUE) {
#line 1840 "linkedlist.c"
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GeeCollection* _tmp8_;
				gint _tmp9_;
				gpointer _tmp10_ = NULL;
				gpointer _tmp11_;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp3_ = _tmp2_;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (!_tmp3_) {
#line 1853 "linkedlist.c"
					gint _tmp4_;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp4_ = i;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					i = _tmp4_ + 1;
#line 1859 "linkedlist.c"
				}
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp2_ = FALSE;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp5_ = i;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp6_ = amount;
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 390 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					break;
#line 1871 "linkedlist.c"
				}
#line 391 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp7_ = self->priv->_size;
#line 391 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (_tmp7_ == 0) {
#line 392 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					result = i;
#line 392 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					return result;
#line 1881 "linkedlist.c"
				}
#line 394 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp8_ = recipient;
#line 394 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp9_ = self->priv->_size;
#line 394 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp10_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, _tmp9_ - 1);
#line 394 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp11_ = _tmp10_;
#line 394 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				gee_collection_add (_tmp8_, _tmp11_);
#line 394 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				((_tmp11_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp11_ = (self->priv->g_destroy_func (_tmp11_), NULL));
#line 1895 "linkedlist.c"
			}
		}
	}
#line 396 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp12_ = amount;
#line 396 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp12_;
#line 396 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 1905 "linkedlist.c"
}


static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self, gint index) {
	GeeLinkedListNode* result = NULL;
	GeeLinkedListNode* n;
	gint _tmp0_;
	GeeLinkedListNode* _tmp24_;
#line 595 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 596 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = NULL;
#line 597 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = index;
#line 597 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == 0) {
#line 1922 "linkedlist.c"
		GeeLinkedListNode* _tmp1_;
#line 598 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp1_ = self->priv->_head;
#line 598 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = _tmp1_;
#line 1928 "linkedlist.c"
	} else {
		gint _tmp2_;
		gint _tmp3_;
#line 599 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp2_ = index;
#line 599 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp3_ = self->priv->_size;
#line 599 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (_tmp2_ == (_tmp3_ - 1)) {
#line 1938 "linkedlist.c"
			GeeLinkedListNode* _tmp4_;
#line 600 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp4_ = self->priv->_tail;
#line 600 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			n = _tmp4_;
#line 1944 "linkedlist.c"
		} else {
			gint _tmp5_;
			gint _tmp6_;
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp5_ = index;
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp6_ = self->priv->_size;
#line 601 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			if (_tmp5_ <= (_tmp6_ / 2)) {
#line 1954 "linkedlist.c"
				GeeLinkedListNode* _tmp7_;
#line 602 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp7_ = self->priv->_head;
#line 602 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				n = _tmp7_;
#line 1960 "linkedlist.c"
				{
					gint i;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					i = 0;
#line 1965 "linkedlist.c"
					{
						gboolean _tmp8_;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						_tmp8_ = TRUE;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						while (TRUE) {
#line 1972 "linkedlist.c"
							gboolean _tmp9_;
							gint _tmp11_;
							gint _tmp12_;
							GeeLinkedListNode* _tmp13_;
							GeeLinkedListNode* _tmp14_;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp9_ = _tmp8_;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							if (!_tmp9_) {
#line 1982 "linkedlist.c"
								gint _tmp10_;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
								_tmp10_ = i;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
								i = _tmp10_ + 1;
#line 1988 "linkedlist.c"
							}
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp8_ = FALSE;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp11_ = index;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp12_ = i;
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							if (!(_tmp11_ != _tmp12_)) {
#line 603 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
								break;
#line 2000 "linkedlist.c"
							}
#line 604 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp13_ = n;
#line 604 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp14_ = _tmp13_->next;
#line 604 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							n = _tmp14_;
#line 2008 "linkedlist.c"
						}
					}
				}
			} else {
				GeeLinkedListNode* _tmp15_;
#line 607 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp15_ = self->priv->_tail;
#line 607 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				n = _tmp15_;
#line 2018 "linkedlist.c"
				{
					gint _tmp16_;
					gint i;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp16_ = self->priv->_size;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					i = _tmp16_ - 1;
#line 2026 "linkedlist.c"
					{
						gboolean _tmp17_;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						_tmp17_ = TRUE;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
						while (TRUE) {
#line 2033 "linkedlist.c"
							gboolean _tmp18_;
							gint _tmp20_;
							gint _tmp21_;
							GeeLinkedListNode* _tmp22_;
							GeeLinkedListNode* _tmp23_;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp18_ = _tmp17_;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							if (!_tmp18_) {
#line 2043 "linkedlist.c"
								gint _tmp19_;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
								_tmp19_ = i;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
								i = _tmp19_ - 1;
#line 2049 "linkedlist.c"
							}
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp17_ = FALSE;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp20_ = index;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp21_ = i;
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							if (!(_tmp20_ != _tmp21_)) {
#line 608 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
								break;
#line 2061 "linkedlist.c"
							}
#line 609 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp22_ = n;
#line 609 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							_tmp23_ = _tmp22_->prev;
#line 609 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
							n = _tmp23_;
#line 2069 "linkedlist.c"
						}
					}
				}
			}
		}
	}
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp24_ = n;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp24_;
#line 612 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2082 "linkedlist.c"
}


static void _gee_linked_list_remove_node (GeeLinkedList* self, GeeLinkedListNode* _n) {
	GeeLinkedListNode* n = NULL;
	GeeLinkedListNode* next = NULL;
	GeeLinkedListNode* _tmp0_;
	GeeLinkedListNode* _tmp1_;
	GeeLinkedListNode* _tmp14_;
	GeeLinkedListNode* _tmp15_;
	GeeLinkedListNode* _tmp21_;
	GeeLinkedListNode* _tmp22_;
	GeeLinkedListNode* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
#line 615 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_if_fail (self != NULL);
#line 615 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_if_fail (_n != NULL);
#line 618 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = _n;
#line 618 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_head;
#line 618 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp0_ == _tmp1_) {
#line 2108 "linkedlist.c"
		GeeLinkedListNode* _tmp2_;
		GeeLinkedListNode* _tmp3_;
		GeeLinkedListNode* _tmp4_;
		GeeLinkedListNode* _tmp5_;
#line 619 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp2_ = self->priv->_head;
#line 619 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->_head = NULL;
#line 619 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (n);
#line 619 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = _tmp2_;
#line 620 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp3_ = n;
#line 620 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp4_ = _tmp3_->next;
#line 620 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp3_->next = NULL;
#line 620 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (self->priv->_head);
#line 620 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->_head = _tmp4_;
#line 620 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp5_ = self->priv->_head;
#line 620 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		next = _tmp5_;
#line 2135 "linkedlist.c"
	} else {
		GeeLinkedListNode* _tmp6_;
		GeeLinkedListNode* _tmp7_;
		GeeLinkedListNode* _tmp8_;
		GeeLinkedListNode* _tmp9_;
		GeeLinkedListNode* _tmp10_;
		GeeLinkedListNode* _tmp11_;
		GeeLinkedListNode* _tmp12_;
		GeeLinkedListNode* _tmp13_;
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp6_ = _n;
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp7_ = _tmp6_->prev;
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp8_ = _tmp7_->next;
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp7_->next = NULL;
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (n);
#line 622 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = _tmp8_;
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp9_ = n;
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp10_ = _tmp9_->prev;
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp11_ = n;
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp12_ = _tmp11_->next;
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp11_->next = NULL;
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (_tmp10_->next);
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp10_->next = _tmp12_;
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp13_ = _tmp10_->next;
#line 623 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		next = _tmp13_;
#line 2175 "linkedlist.c"
	}
#line 625 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp14_ = n;
#line 625 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp15_ = self->priv->_tail;
#line 625 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp14_ == _tmp15_) {
#line 2183 "linkedlist.c"
		GeeLinkedListNode* _tmp16_;
		GeeLinkedListNode* _tmp17_;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp16_ = n;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp17_ = _tmp16_->prev;
#line 626 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->_tail = _tmp17_;
#line 2192 "linkedlist.c"
	} else {
		GeeLinkedListNode* _tmp18_;
		GeeLinkedListNode* _tmp19_;
		GeeLinkedListNode* _tmp20_;
#line 628 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp18_ = next;
#line 628 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp19_ = n;
#line 628 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp20_ = _tmp19_->prev;
#line 628 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp18_->prev = _tmp20_;
#line 2205 "linkedlist.c"
	}
#line 630 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp21_ = n;
#line 630 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp21_->prev = NULL;
#line 631 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp22_ = n;
#line 631 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (_tmp22_->next);
#line 631 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp22_->next = NULL;
#line 632 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp23_ = n;
#line 632 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	((_tmp23_->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp23_->data = (self->priv->g_destroy_func (_tmp23_->data), NULL));
#line 632 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp23_->data = NULL;
#line 633 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp24_ = self->priv->_stamp;
#line 633 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_stamp = _tmp24_ + 1;
#line 634 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp25_ = self->priv->_size;
#line 634 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_size = _tmp25_ - 1;
#line 615 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (n);
#line 2233 "linkedlist.c"
}


GEqualFunc gee_linked_list_get_equal_func (GeeLinkedList* self) {
	GEqualFunc result;
	GEqualFunc _tmp0_;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_equal_func;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp0_;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2248 "linkedlist.c"
}


static void gee_linked_list_set_equal_func (GeeLinkedList* self, GEqualFunc value) {
	GEqualFunc _tmp0_;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = value;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_equal_func = _tmp0_;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_notify ((GObject *) self, "equal-func");
#line 2262 "linkedlist.c"
}


static gint gee_linked_list_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeLinkedList* self;
	gint _tmp0_;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_size;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp0_;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2278 "linkedlist.c"
}


static gint gee_linked_list_real_get_capacity (GeeQueue* base) {
	gint result;
	GeeLinkedList* self;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2291 "linkedlist.c"
}


static gint gee_linked_list_real_get_remaining_capacity (GeeQueue* base) {
	gint result;
	GeeLinkedList* self;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2304 "linkedlist.c"
}


static gboolean gee_linked_list_real_get_is_full (GeeQueue* base) {
	gboolean result;
	GeeLinkedList* self;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedList*) base;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = FALSE;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2317 "linkedlist.c"
}


static GeeLinkedListNode* gee_linked_list_node_new (gpointer data) {
	GeeLinkedListNode* self;
	gconstpointer _tmp0_;
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = g_slice_new0 (GeeLinkedListNode);
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_node_instance_init (self);
#line 405 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = data;
#line 405 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->data = _tmp0_;
#line 404 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return self;
#line 2334 "linkedlist.c"
}


static void gee_linked_list_node_instance_init (GeeLinkedListNode * self) {
#line 402 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->prev = NULL;
#line 403 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->next = NULL;
#line 2343 "linkedlist.c"
}


static void gee_linked_list_node_free (GeeLinkedListNode* self) {
#line 403 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (self->next);
#line 400 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_slice_free (GeeLinkedListNode, self);
#line 2352 "linkedlist.c"
}


static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
	GeeLinkedListIterator * self = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_return_val_if_fail (list != NULL, NULL);
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) g_object_new (object_type, NULL);
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->g_type = g_type;
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->g_dup_func = g_dup_func;
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 418 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = list;
#line 418 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 418 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_g_object_unref0 (self->priv->_list);
#line 418 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_list = _tmp1_;
#line 419 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->position = NULL;
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_index = -1;
#line 421 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = list;
#line 421 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = _tmp2_->priv->_stamp;
#line 421 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_stamp = _tmp3_;
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return self;
#line 2392 "linkedlist.c"
}


static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLinkedList* list) {
#line 417 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return gee_linked_list_iterator_construct (GEE_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
#line 2399 "linkedlist.c"
}


static gboolean gee_linked_list_iterator_real_next (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 427 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->removed;
#line 427 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp3_) {
#line 2424 "linkedlist.c"
		GeeLinkedListNode* _tmp4_;
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp4_ = self->priv->position;
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (_tmp4_ != NULL) {
#line 429 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			self->priv->removed = FALSE;
#line 430 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			result = TRUE;
#line 430 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			return result;
#line 2436 "linkedlist.c"
		} else {
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			result = FALSE;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			return result;
#line 2442 "linkedlist.c"
		}
	} else {
		gboolean _tmp5_;
#line 434 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp5_ = self->priv->started;
#line 434 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (!_tmp5_) {
#line 2450 "linkedlist.c"
			GeeLinkedList* _tmp6_;
			GeeLinkedListNode* _tmp7_;
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp6_ = self->priv->_list;
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp7_ = _tmp6_->priv->_head;
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			if (_tmp7_ != NULL) {
#line 2459 "linkedlist.c"
				GeeLinkedList* _tmp8_;
				GeeLinkedListNode* _tmp9_;
				gint _tmp10_;
#line 436 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				self->priv->started = TRUE;
#line 437 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp8_ = self->priv->_list;
#line 437 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp9_ = _tmp8_->priv->_head;
#line 437 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				self->priv->position = _tmp9_;
#line 438 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp10_ = self->priv->_index;
#line 438 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				self->priv->_index = _tmp10_ + 1;
#line 439 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				result = TRUE;
#line 439 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				return result;
#line 2479 "linkedlist.c"
			} else {
#line 441 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				result = FALSE;
#line 441 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				return result;
#line 2485 "linkedlist.c"
			}
		} else {
			GeeLinkedListNode* _tmp11_;
#line 443 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp11_ = self->priv->position;
#line 443 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			if (_tmp11_ != NULL) {
#line 2493 "linkedlist.c"
				GeeLinkedListNode* _tmp12_;
				GeeLinkedListNode* _tmp13_;
#line 444 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp12_ = self->priv->position;
#line 444 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp13_ = _tmp12_->next;
#line 444 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				if (_tmp13_ != NULL) {
#line 2502 "linkedlist.c"
					GeeLinkedListNode* _tmp14_;
					GeeLinkedListNode* _tmp15_;
					gint _tmp16_;
#line 445 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp14_ = self->priv->position;
#line 445 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp15_ = _tmp14_->next;
#line 445 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					self->priv->position = _tmp15_;
#line 446 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					_tmp16_ = self->priv->_index;
#line 446 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					self->priv->_index = _tmp16_ + 1;
#line 447 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					result = TRUE;
#line 447 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					return result;
#line 2520 "linkedlist.c"
				} else {
#line 449 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					result = FALSE;
#line 449 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
					return result;
#line 2526 "linkedlist.c"
				}
			}
		}
	}
#line 452 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = FALSE;
#line 452 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2535 "linkedlist.c"
}


static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
#line 455 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 456 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 456 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 456 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 456 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 458 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->removed;
#line 458 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp3_) {
#line 2560 "linkedlist.c"
		GeeLinkedListNode* _tmp4_;
#line 459 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp4_ = self->priv->position;
#line 459 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = _tmp4_ != NULL;
#line 459 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 2568 "linkedlist.c"
	} else {
		gboolean _tmp5_;
#line 460 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp5_ = self->priv->started;
#line 460 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (!_tmp5_) {
#line 2575 "linkedlist.c"
			GeeLinkedList* _tmp6_;
			GeeLinkedListNode* _tmp7_;
#line 461 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp6_ = self->priv->_list;
#line 461 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp7_ = _tmp6_->priv->_head;
#line 461 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			result = _tmp7_ != NULL;
#line 461 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			return result;
#line 2586 "linkedlist.c"
		} else {
			GeeLinkedListNode* _tmp8_;
#line 462 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp8_ = self->priv->position;
#line 462 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			if (_tmp8_ != NULL) {
#line 2593 "linkedlist.c"
				GeeLinkedListNode* _tmp9_;
				GeeLinkedListNode* _tmp10_;
#line 463 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp9_ = self->priv->position;
#line 463 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				_tmp10_ = _tmp9_->next;
#line 463 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				result = _tmp10_ != NULL;
#line 463 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
				return result;
#line 2604 "linkedlist.c"
			}
		}
	}
#line 465 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = FALSE;
#line 465 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2612 "linkedlist.c"
}


static gboolean gee_linked_list_iterator_real_first (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeLinkedList* _tmp6_;
	GeeLinkedListNode* _tmp7_;
	GeeLinkedListNode* _tmp8_;
#line 468 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 469 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 469 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 469 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 469 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 470 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->_list;
#line 470 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 470 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = _tmp4_;
#line 470 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp5_ == 0) {
#line 471 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = FALSE;
#line 471 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 2650 "linkedlist.c"
	}
#line 473 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = self->priv->_list;
#line 473 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp7_ = _tmp6_->priv->_head;
#line 473 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->position = _tmp7_;
#line 474 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->started = TRUE;
#line 475 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_index = 0;
#line 476 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->removed = FALSE;
#line 477 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp8_ = self->priv->position;
#line 477 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp8_ != NULL;
#line 477 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2670 "linkedlist.c"
}


static gpointer gee_linked_list_iterator_real_get (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gpointer result = NULL;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
#line 480 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 481 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 481 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 481 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 481 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 482 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->position;
#line 482 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp3_ != NULL, "this.position != null");
#line 484 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = self->priv->position;
#line 484 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = _tmp4_->data;
#line 484 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 484 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp6_;
#line 484 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2708 "linkedlist.c"
}


static void gee_linked_list_iterator_real_remove (GeeIterator* base) {
	GeeLinkedListIterator * self;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	GeeLinkedListNode* _tmp5_;
	GeeLinkedListNode* new_position;
	GeeLinkedListNode* _tmp6_;
	GeeLinkedList* _tmp7_;
	GeeLinkedListNode* _tmp8_;
	GeeLinkedListNode* _tmp9_;
	GeeLinkedList* _tmp10_;
	gint _tmp11_;
#line 487 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 488 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 488 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 488 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 488 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 489 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->position;
#line 489 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp3_ != NULL, "this.position != null");
#line 491 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = self->priv->position;
#line 491 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = _tmp4_->next;
#line 491 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	new_position = _tmp5_;
#line 492 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = new_position;
#line 492 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp6_ == NULL) {
#line 493 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->started = FALSE;
#line 2753 "linkedlist.c"
	}
#line 495 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp7_ = self->priv->_list;
#line 495 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp8_ = self->priv->position;
#line 495 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_remove_node (_tmp7_, _tmp8_);
#line 496 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp9_ = new_position;
#line 496 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->position = _tmp9_;
#line 497 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->removed = TRUE;
#line 498 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp10_ = self->priv->_list;
#line 498 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp11_ = _tmp10_->priv->_stamp;
#line 498 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_stamp = _tmp11_;
#line 2773 "linkedlist.c"
}


static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
#line 501 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 502 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 502 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 502 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 502 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 504 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->started;
#line 504 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (!_tmp3_) {
#line 505 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->position = NULL;
#line 506 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = FALSE;
#line 506 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 2804 "linkedlist.c"
	} else {
		gboolean _tmp4_ = FALSE;
		GeeLinkedListNode* _tmp5_;
		gboolean _tmp8_;
#line 507 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp5_ = self->priv->position;
#line 507 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (_tmp5_ != NULL) {
#line 2813 "linkedlist.c"
			GeeLinkedListNode* _tmp6_;
			GeeLinkedListNode* _tmp7_;
#line 507 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp6_ = self->priv->position;
#line 507 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp7_ = _tmp6_->prev;
#line 507 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp4_ = _tmp7_ != NULL;
#line 2822 "linkedlist.c"
		} else {
#line 507 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp4_ = FALSE;
#line 2826 "linkedlist.c"
		}
#line 507 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp8_ = _tmp4_;
#line 507 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (_tmp8_) {
#line 2832 "linkedlist.c"
			GeeLinkedListNode* _tmp9_;
			GeeLinkedListNode* _tmp10_;
			gint _tmp11_;
#line 508 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp9_ = self->priv->position;
#line 508 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp10_ = _tmp9_->prev;
#line 508 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			self->priv->position = _tmp10_;
#line 509 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp11_ = self->priv->_index;
#line 509 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			self->priv->_index = _tmp11_ - 1;
#line 510 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			result = TRUE;
#line 510 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			return result;
#line 2850 "linkedlist.c"
		}
	}
#line 512 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = FALSE;
#line 512 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2857 "linkedlist.c"
}


static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
#line 515 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 516 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 516 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 516 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 516 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 518 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->started;
#line 518 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (!_tmp3_) {
#line 519 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = FALSE;
#line 519 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 2886 "linkedlist.c"
	} else {
		GeeLinkedListNode* _tmp4_;
#line 520 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp4_ = self->priv->position;
#line 520 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		if (_tmp4_ != NULL) {
#line 2893 "linkedlist.c"
			GeeLinkedListNode* _tmp5_;
			GeeLinkedListNode* _tmp6_;
#line 521 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp5_ = self->priv->position;
#line 521 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			_tmp6_ = _tmp5_->prev;
#line 521 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			result = _tmp6_ != NULL;
#line 521 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
			return result;
#line 2904 "linkedlist.c"
		}
	}
#line 523 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = FALSE;
#line 523 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2911 "linkedlist.c"
}


static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base) {
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeLinkedList* _tmp6_;
	GeeLinkedListNode* _tmp7_;
	GeeLinkedList* _tmp8_;
	gint _tmp9_;
	GeeLinkedListNode* _tmp10_;
#line 526 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 527 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 527 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 527 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 527 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 529 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->_list;
#line 529 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 529 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = _tmp4_;
#line 529 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp5_ == 0) {
#line 530 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		result = FALSE;
#line 530 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		return result;
#line 2951 "linkedlist.c"
	}
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = self->priv->_list;
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp7_ = _tmp6_->priv->_tail;
#line 532 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->position = _tmp7_;
#line 533 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->started = TRUE;
#line 534 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp8_ = self->priv->_list;
#line 534 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp9_ = _tmp8_->priv->_size;
#line 534 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_index = _tmp9_ - 1;
#line 535 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp10_ = self->priv->position;
#line 535 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp10_ != NULL;
#line 535 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 2973 "linkedlist.c"
}


static void gee_linked_list_iterator_real_set (GeeListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
#line 538 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 539 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 539 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 539 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 539 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 540 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->position;
#line 540 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp3_ != NULL, "this.position != null");
#line 542 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = self->priv->position;
#line 542 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = item;
#line 542 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 542 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	((_tmp4_->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp4_->data = (self->priv->g_destroy_func (_tmp4_->data), NULL));
#line 542 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_->data = _tmp6_;
#line 3010 "linkedlist.c"
}


static void gee_linked_list_iterator_real_insert (GeeListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	GeeLinkedListNode* _tmp3_;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	GeeLinkedListNode* _tmp6_;
	GeeLinkedListNode* n;
	GeeLinkedListNode* _tmp7_;
	GeeLinkedListNode* _tmp8_;
	GeeLinkedList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GeeLinkedList* _tmp34_;
	gint _tmp35_;
#line 545 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 546 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 546 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 546 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 546 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 547 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->position;
#line 547 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp3_ != NULL, "this.position != null");
#line 549 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = item;
#line 549 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
#line 549 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = gee_linked_list_node_new (_tmp5_);
#line 549 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = _tmp6_;
#line 550 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp7_ = self->priv->position;
#line 550 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp8_ = _tmp7_->prev;
#line 550 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp8_ != NULL) {
#line 3059 "linkedlist.c"
		GeeLinkedListNode* _tmp9_;
		GeeLinkedListNode* _tmp10_;
		GeeLinkedListNode* _tmp11_;
		GeeLinkedListNode* position;
		GeeLinkedListNode* _tmp12_;
		GeeLinkedListNode* _tmp13_;
		GeeLinkedListNode* _tmp14_;
		GeeLinkedListNode* _tmp15_;
		GeeLinkedListNode* _tmp16_;
		GeeLinkedListNode* _tmp17_;
		GeeLinkedListNode* _tmp18_;
		GeeLinkedListNode* _tmp19_;
		GeeLinkedListNode* _n;
		GeeLinkedListNode* _tmp20_;
		GeeLinkedListNode* _tmp21_;
		GeeLinkedListNode* _tmp22_;
#line 551 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp9_ = self->priv->position;
#line 551 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp10_ = _tmp9_->prev;
#line 551 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp11_ = _tmp10_->next;
#line 551 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp10_->next = NULL;
#line 551 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		position = _tmp11_;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp12_ = n;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp13_ = position;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp14_ = _tmp13_->prev;
#line 552 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp12_->prev = _tmp14_;
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp15_ = position;
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp16_ = n;
#line 553 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp15_->prev = _tmp16_;
#line 554 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp17_ = n;
#line 554 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp18_ = position;
#line 554 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		position = NULL;
#line 554 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (_tmp17_->next);
#line 554 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp17_->next = _tmp18_;
#line 555 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp19_ = n;
#line 555 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_n = _tmp19_;
#line 556 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp20_ = _n;
#line 556 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp21_ = _tmp20_->prev;
#line 556 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp22_ = n;
#line 556 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = NULL;
#line 556 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (_tmp21_->next);
#line 556 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp21_->next = _tmp22_;
#line 550 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (position);
#line 3128 "linkedlist.c"
	} else {
		GeeLinkedList* _tmp23_;
		GeeLinkedListNode* _tmp24_;
		GeeLinkedListNode* position;
		GeeLinkedListNode* _tmp25_;
		GeeLinkedListNode* _tmp26_;
		GeeLinkedListNode* _tmp27_;
		GeeLinkedListNode* _tmp28_;
		GeeLinkedList* _tmp29_;
		GeeLinkedListNode* _tmp30_;
#line 558 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp23_ = self->priv->_list;
#line 558 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp24_ = _tmp23_->priv->_head;
#line 558 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp23_->priv->_head = NULL;
#line 558 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		position = _tmp24_;
#line 559 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp25_ = position;
#line 559 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp26_ = n;
#line 559 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp25_->prev = _tmp26_;
#line 560 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp27_ = n;
#line 560 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp28_ = position;
#line 560 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		position = NULL;
#line 560 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (_tmp27_->next);
#line 560 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp27_->next = _tmp28_;
#line 561 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp29_ = self->priv->_list;
#line 561 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp30_ = n;
#line 561 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		n = NULL;
#line 561 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (_tmp29_->priv->_head);
#line 561 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp29_->priv->_head = _tmp30_;
#line 550 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (position);
#line 3175 "linkedlist.c"
	}
#line 563 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp31_ = self->priv->_list;
#line 563 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp32_ = _tmp31_->priv->_size;
#line 563 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp31_->priv->_size = _tmp32_ + 1;
#line 564 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp33_ = self->priv->_index;
#line 564 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_index = _tmp33_ + 1;
#line 565 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp34_ = self->priv->_list;
#line 565 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp35_ = _tmp34_->priv->_stamp;
#line 565 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_stamp = _tmp35_;
#line 545 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (n);
#line 3195 "linkedlist.c"
}


static void gee_linked_list_iterator_real_add (GeeListIterator* base, gconstpointer item) {
	GeeLinkedListIterator * self;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	GeeLinkedListNode* _tmp3_;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	GeeLinkedListNode* _tmp6_;
	GeeLinkedListNode* n;
	GeeLinkedListNode* _tmp7_;
	GeeLinkedListNode* _tmp8_;
	GeeLinkedListNode* _tmp17_;
	GeeLinkedListNode* _tmp18_;
	GeeLinkedListNode* _tmp19_;
	GeeLinkedListNode* _tmp20_;
	GeeLinkedListNode* _tmp21_;
	GeeLinkedListNode* _tmp22_;
	GeeLinkedListNode* _tmp23_;
	GeeLinkedList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GeeLinkedList* _tmp27_;
	gint _tmp28_;
#line 568 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 569 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 569 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 569 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 569 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 570 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->position;
#line 570 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp3_ != NULL, "this.position != null");
#line 572 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = item;
#line 572 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
#line 572 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp6_ = gee_linked_list_node_new (_tmp5_);
#line 572 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = _tmp6_;
#line 573 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp7_ = self->priv->position;
#line 573 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp8_ = _tmp7_->next;
#line 573 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	if (_tmp8_ != NULL) {
#line 3251 "linkedlist.c"
		GeeLinkedListNode* _tmp9_;
		GeeLinkedListNode* _tmp10_;
		GeeLinkedListNode* _tmp11_;
		GeeLinkedListNode* _tmp12_;
		GeeLinkedListNode* _tmp13_;
		GeeLinkedListNode* _tmp14_;
#line 574 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp9_ = self->priv->position;
#line 574 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp10_ = _tmp9_->next;
#line 574 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp11_ = n;
#line 574 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp10_->prev = _tmp11_;
#line 575 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp12_ = n;
#line 575 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp13_ = self->priv->position;
#line 575 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp14_ = _tmp13_->next;
#line 575 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp13_->next = NULL;
#line 575 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_gee_linked_list_node_free0 (_tmp12_->next);
#line 575 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp12_->next = _tmp14_;
#line 3278 "linkedlist.c"
	} else {
		GeeLinkedList* _tmp15_;
		GeeLinkedListNode* _tmp16_;
#line 577 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp15_ = self->priv->_list;
#line 577 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp16_ = n;
#line 577 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		_tmp15_->priv->_tail = _tmp16_;
#line 3288 "linkedlist.c"
	}
#line 579 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp17_ = self->priv->position;
#line 579 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp18_ = n;
#line 579 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	n = NULL;
#line 579 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (_tmp17_->next);
#line 579 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp17_->next = _tmp18_;
#line 580 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp19_ = self->priv->position;
#line 580 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp20_ = _tmp19_->next;
#line 580 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp21_ = self->priv->position;
#line 580 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp20_->prev = _tmp21_;
#line 581 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp22_ = self->priv->position;
#line 581 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp23_ = _tmp22_->next;
#line 581 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->position = _tmp23_;
#line 582 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp24_ = self->priv->_list;
#line 582 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp25_ = _tmp24_->priv->_size;
#line 582 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp24_->priv->_size = _tmp25_ + 1;
#line 583 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp26_ = self->priv->_index;
#line 583 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_index = _tmp26_ + 1;
#line 584 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp27_ = self->priv->_list;
#line 584 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp28_ = _tmp27_->priv->_stamp;
#line 584 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_stamp = _tmp28_;
#line 568 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (n);
#line 3332 "linkedlist.c"
}


static gint gee_linked_list_iterator_real_index (GeeListIterator* base) {
	GeeLinkedListIterator * self;
	gint result = 0;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	GeeLinkedListNode* _tmp3_;
	gint _tmp4_;
#line 587 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = (GeeLinkedListIterator*) base;
#line 588 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp0_ = self->priv->_stamp;
#line 588 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp1_ = self->priv->_list;
#line 588 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 588 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp0_ == _tmp2_, "this._stamp == this._list._stamp");
#line 589 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp3_ = self->priv->position;
#line 589 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_vala_assert (_tmp3_ != NULL, "this.position != null");
#line 591 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_tmp4_ = self->priv->_index;
#line 591 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	result = _tmp4_;
#line 591 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	return result;
#line 3364 "linkedlist.c"
}


static void gee_linked_list_iterator_class_init (GeeLinkedListIteratorClass * klass) {
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_iterator_parent_class = g_type_class_peek_parent (klass);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_type_class_add_private (klass, sizeof (GeeLinkedListIteratorPrivate));
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_linked_list_iterator_get_property;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_linked_list_iterator_set_property;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_iterator_finalize;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 3385 "linkedlist.c"
}


static void gee_linked_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->next = (gboolean (*)(GeeIterator*)) gee_linked_list_iterator_real_next;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_linked_list_iterator_real_has_next;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->first = (gboolean (*)(GeeIterator*)) gee_linked_list_iterator_real_first;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->get = (gpointer (*)(GeeIterator*)) gee_linked_list_iterator_real_get;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->remove = (void (*)(GeeIterator*)) gee_linked_list_iterator_real_remove;
#line 3402 "linkedlist.c"
}


static void gee_linked_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->previous = (gboolean (*)(GeeBidirIterator*)) gee_linked_list_iterator_real_previous;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->has_previous = (gboolean (*)(GeeBidirIterator*)) gee_linked_list_iterator_real_has_previous;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->last = (gboolean (*)(GeeBidirIterator*)) gee_linked_list_iterator_real_last;
#line 3415 "linkedlist.c"
}


static void gee_linked_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface) {
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->set = (void (*)(GeeListIterator*, gconstpointer)) gee_linked_list_iterator_real_set;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->insert = (void (*)(GeeListIterator*, gconstpointer)) gee_linked_list_iterator_real_insert;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->add = (void (*)(GeeListIterator*, gconstpointer)) gee_linked_list_iterator_real_add;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->index = (gint (*)(GeeListIterator*)) gee_linked_list_iterator_real_index;
#line 3430 "linkedlist.c"
}


static void gee_linked_list_iterator_instance_init (GeeLinkedListIterator * self) {
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv = GEE_LINKED_LIST_ITERATOR_GET_PRIVATE (self);
#line 410 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->started = FALSE;
#line 411 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->removed = FALSE;
#line 3441 "linkedlist.c"
}


static void gee_linked_list_iterator_finalize (GObject* obj) {
	GeeLinkedListIterator * self;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_g_object_unref0 (self->priv->_list);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	G_OBJECT_CLASS (gee_linked_list_iterator_parent_class)->finalize (obj);
#line 3453 "linkedlist.c"
}


static GType gee_linked_list_iterator_get_type (void) {
	static volatile gsize gee_linked_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedListIterator), 0, (GInstanceInitFunc) gee_linked_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_iterator_type_id;
		gee_linked_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeLinkedListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
		g_once_init_leave (&gee_linked_list_iterator_type_id__volatile, gee_linked_list_iterator_type_id);
	}
	return gee_linked_list_iterator_type_id__volatile;
}


static void _vala_gee_linked_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	switch (property_id) {
#line 3480 "linkedlist.c"
		default:
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 3486 "linkedlist.c"
	}
}


static void _vala_gee_linked_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	switch (property_id) {
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_ITERATOR_G_TYPE:
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC:
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC:
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 3514 "linkedlist.c"
		default:
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 409 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 3520 "linkedlist.c"
	}
}


static void gee_linked_list_class_init (GeeLinkedListClass * klass) {
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_type_class_add_private (klass, sizeof (GeeLinkedListPrivate));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_linked_list_real_iterator;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->list_iterator = gee_linked_list_real_list_iterator;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_linked_list_real_contains;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_linked_list_real_add;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_linked_list_real_remove;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_linked_list_real_clear;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->get = gee_linked_list_real_get;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->set = gee_linked_list_real_set;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = gee_linked_list_real_index_of;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = gee_linked_list_real_insert;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = gee_linked_list_real_remove_at;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = gee_linked_list_real_slice;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->first = gee_linked_list_real_first;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->last = gee_linked_list_real_last;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_linked_list_real_get_size;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_linked_list_get_property;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_linked_list_set_property;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_finalize;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 3572 "linkedlist.c"
	/**
	 * The elements' equality testing function.
	 */
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_EQUAL_FUNC, g_param_spec_pointer ("equal-func", "equal-func", "equal-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3578 "linkedlist.c"
	/**
	 * {@inheritDoc}
	 */
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3584 "linkedlist.c"
	/**
	 * {@inheritDoc}
	 */
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_CAPACITY, g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3590 "linkedlist.c"
	/**
	 * {@inheritDoc}
	 */
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_REMAINING_CAPACITY, g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3596 "linkedlist.c"
	/**
	 * {@inheritDoc}
	 */
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_IS_FULL, g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3602 "linkedlist.c"
}


static void gee_linked_list_gee_queue_interface_init (GeeQueueIface * iface) {
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_gee_queue_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->offer = (gboolean (*)(GeeQueue*, gconstpointer)) gee_linked_list_real_offer;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->peek = (gpointer (*)(GeeQueue*)) gee_linked_list_real_peek;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->poll = (gpointer (*)(GeeQueue*)) gee_linked_list_real_poll;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->drain = (gint (*)(GeeQueue*, GeeCollection*, gint)) gee_linked_list_real_drain;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->get_capacity = gee_linked_list_real_get_capacity;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->get_remaining_capacity = gee_linked_list_real_get_remaining_capacity;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->get_is_full = gee_linked_list_real_get_is_full;
#line 3623 "linkedlist.c"
}


static void gee_linked_list_gee_deque_interface_init (GeeDequeIface * iface) {
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_linked_list_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->offer_head = (gboolean (*)(GeeDeque*, gconstpointer)) gee_linked_list_real_offer_head;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->peek_head = (gpointer (*)(GeeDeque*)) gee_linked_list_real_peek_head;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->poll_head = (gpointer (*)(GeeDeque*)) gee_linked_list_real_poll_head;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->drain_head = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_linked_list_real_drain_head;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->offer_tail = (gboolean (*)(GeeDeque*, gconstpointer)) gee_linked_list_real_offer_tail;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->peek_tail = (gpointer (*)(GeeDeque*)) gee_linked_list_real_peek_tail;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->poll_tail = (gpointer (*)(GeeDeque*)) gee_linked_list_real_poll_tail;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	iface->drain_tail = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_linked_list_real_drain_tail;
#line 3646 "linkedlist.c"
}


static void gee_linked_list_instance_init (GeeLinkedList * self) {
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv = GEE_LINKED_LIST_GET_PRIVATE (self);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_size = 0;
#line 37 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_stamp = 0;
#line 38 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_head = NULL;
#line 39 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self->priv->_tail = NULL;
#line 3661 "linkedlist.c"
}


static void gee_linked_list_finalize (GObject* obj) {
	GeeLinkedList * self;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_LINKED_LIST, GeeLinkedList);
#line 62 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
#line 38 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	_gee_linked_list_node_free0 (self->priv->_head);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	G_OBJECT_CLASS (gee_linked_list_parent_class)->finalize (obj);
#line 3675 "linkedlist.c"
}


/**
 * Doubly-linked list implementation of the {@link List} interface.
 *
 * This implementation is pretty well designed for highly mutable data. When
 * indexed access is privileged prefer using {@link ArrayList}.
 *
 * @see ArrayList
 */
GType gee_linked_list_get_type (void) {
	static volatile gsize gee_linked_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedList), 0, (GInstanceInitFunc) gee_linked_list_instance_init, NULL };
		static const GInterfaceInfo gee_queue_info = { (GInterfaceInitFunc) gee_linked_list_gee_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_linked_list_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_type_id;
		gee_linked_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_LIST, "GeeLinkedList", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_QUEUE, &gee_queue_info);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		g_once_init_leave (&gee_linked_list_type_id__volatile, gee_linked_list_type_id);
	}
	return gee_linked_list_type_id__volatile;
}


static void _vala_gee_linked_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_LINKED_LIST, GeeLinkedList);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	switch (property_id) {
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_EQUAL_FUNC:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		g_value_set_pointer (value, gee_linked_list_get_equal_func (self));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_SIZE:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_CAPACITY:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		g_value_set_int (value, gee_queue_get_capacity ((GeeQueue*) self));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_REMAINING_CAPACITY:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		g_value_set_int (value, gee_queue_get_remaining_capacity ((GeeQueue*) self));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_IS_FULL:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		g_value_set_boolean (value, gee_queue_get_is_full ((GeeQueue*) self));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 3738 "linkedlist.c"
		default:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 3744 "linkedlist.c"
	}
}


static void _vala_gee_linked_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_LINKED_LIST, GeeLinkedList);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
	switch (property_id) {
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_EQUAL_FUNC:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		gee_linked_list_set_equal_func (self, g_value_get_pointer (value));
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_G_TYPE:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_G_DUP_FUNC:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		case GEE_LINKED_LIST_G_DESTROY_FUNC:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 3778 "linkedlist.c"
		default:
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/mpiechotka/Projects/contributions/libgee/gee/linkedlist.vala"
		break;
#line 3784 "linkedlist.c"
	}
}



