/* $Id: init.c,v 1.1.1.1 2001/05/12 23:00:04 cegger Exp $
******************************************************************************

   LibGG - Init/Exit functions

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>

#include <ggi/gg.h>
#include "plat.h"

void		*_gg_global_mutex = NULL;
static int	 _ggLibIsUp = 0;

int  _ggInitLocks(void);
void _ggExitLocks(void);

int ggInit(void)
{
	int ret;
	if (_ggLibIsUp > 0) {
		/* Initialize only at first call. */
		_ggLibIsUp++;
		return 0;
	}
	ret = _ggInitLocks();
	if (ret != 0) {
		fprintf(stderr, "LibGG: unable to initialize mutex code\n");
		return ret;
	}

	if ((_gg_global_mutex = ggLockCreate()) == NULL) {
		_ggExitLocks();
		return GGI_EUNKNOWN;
	}

	_ggLibIsUp++;
	return 0;
}

int ggExit(void)
{
	if (!_ggLibIsUp) return GGI_ENOTALLOC;

	_ggLibIsUp--;
	if (_ggLibIsUp > 0) {
		return _ggLibIsUp;
	}

	ggLockDestroy(_gg_global_mutex);
	_ggExitLocks();

	return 0;
}


