dnl Check data types

AC_DEFUN([GGI_CHECK_TYPES],
[

AC_CHECK_SIZEOF(char, 1)
AC_CHECK_SIZEOF(short, 2)
AC_CHECK_SIZEOF(int, 4)
AC_CHECK_SIZEOF(long, 4)
AC_CHECK_SIZEOF(long long, 8)

if test "x$cross_compiling" = "xyes"; then
  AC_MSG_WARN([
  You are using a cross-compiler, please set the SIZEOF_* defines in config.h
  properly before compiling this package. Also check that the typedefs and
  defines in include/ggi/system.h are correct.
])
fi


if test "$ac_cv_sizeof_int" = "1"; then
  GGI_8="int"
elif test "$ac_cv_sizeof_char" = "1"; then
  GGI_8="char"
elif test "$ac_cv_sizeof_short" = "1"; then
  GGI_8="short"
else
  AC_MSG_ERROR(No 8-bit datatype on this system???)
fi


if test "$ac_cv_sizeof_int" = "2"; then
  GGI_16="int"
elif test "$ac_cv_sizeof_char" = "2"; then
  GGI_16="char"
elif test "$ac_cv_sizeof_short" = "2"; then
  GGI_16="short"
elif test "$ac_cv_sizeof_long" = "2"; then
  GGI_16="long"
else
  AC_MSG_ERROR(No 16-bit datatype on this system???)
fi

if test "$ac_cv_sizeof_int" = "4"; then
  GGI_32="int"
elif test "$ac_cv_sizeof_long" = "4"; then
  GGI_32="long"
elif test "$ac_cv_sizeof_char" = "4"; then
  GGI_32="char"
elif test "$ac_cv_sizeof_short" = "4"; then
  GGI_32="short"
elif test "$ac_cv_sizeof_long_LONG" = "4"; then
  GGI_32="long long"
else
  AC_MSG_ERROR(No 32-bit datatype on this system???)
fi

ac_cc_can_int64="no"
if test "$ac_cv_sizeof_int" = "8"; then
  GGI_64="int"
  AC_CC_CAN_INT64
fi
if test "x$ac_cc_can_int64" = "xno"; then 
  if test "$ac_cv_sizeof_long" = "8"; then
    GGI_64="long"
    AC_CC_CAN_INT64
  fi
fi
if test "x$ac_cc_can_int64" = "xno"; then
  if test "$ac_cv_sizeof_char" = "8"; then
    GGI_64="char"
    AC_CC_CAN_INT64
  fi
fi
if test "x$ac_cc_can_int64" = "xno"; then
  if test "$ac_cv_sizeof_short" = "8"; then
    GGI_64="short"
    AC_CC_CAN_INT64
  fi
fi
if test "x$ac_cc_can_int64" = "xno"; then 
  if test "$ac_cv_sizeof_long_long" = "8"; then
    GGI_64="long long"
    AC_CC_CAN_INT64
  fi
fi

if test "x$ac_cc_can_int64" = "xno"; then 
  GGI_DEFINE_INT64="#undef"
  AC_MSG_RESULT([No working 64-bit integers.  64-bit code will be disabled.])
else
  GGI_DEFINE_INT64="#define"
  AC_MSG_RESULT(Using type $GGI_64 for 64-bit integers)
fi

])
