/* context.c generated by valac 0.42.3, the Vala compiler
 * generated from context.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 * Copyright © 2015 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>


#define GAMES_SCORES_TYPE_STYLE (games_scores_style_get_type ())

#define GAMES_SCORES_TYPE_CONTEXT (games_scores_context_get_type ())
#define GAMES_SCORES_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext))
#define GAMES_SCORES_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContextClass))
#define GAMES_SCORES_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_CONTEXT))
#define GAMES_SCORES_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_CONTEXT))
#define GAMES_SCORES_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContextClass))

typedef struct _GamesScoresContext GamesScoresContext;
typedef struct _GamesScoresContextClass GamesScoresContextClass;
typedef struct _GamesScoresContextPrivate GamesScoresContextPrivate;

#define GAMES_SCORES_TYPE_IMPORTER (games_scores_importer_get_type ())
#define GAMES_SCORES_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_IMPORTER, GamesScoresImporter))
#define GAMES_SCORES_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_IMPORTER, GamesScoresImporterClass))
#define GAMES_SCORES_IS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_IMPORTER))
#define GAMES_SCORES_IS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_IMPORTER))
#define GAMES_SCORES_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_IMPORTER, GamesScoresImporterClass))

typedef struct _GamesScoresImporter GamesScoresImporter;
typedef struct _GamesScoresImporterClass GamesScoresImporterClass;

#define GAMES_SCORES_TYPE_CATEGORY (games_scores_category_get_type ())
#define GAMES_SCORES_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory))
#define GAMES_SCORES_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategoryClass))
#define GAMES_SCORES_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_CATEGORY))
#define GAMES_SCORES_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_CATEGORY))
#define GAMES_SCORES_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategoryClass))

typedef struct _GamesScoresCategory GamesScoresCategory;
typedef struct _GamesScoresCategoryClass GamesScoresCategoryClass;

#define GAMES_SCORES_TYPE_SCORE (games_scores_score_get_type ())
#define GAMES_SCORES_SCORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_SCORE, GamesScoresScore))
#define GAMES_SCORES_SCORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_SCORE, GamesScoresScoreClass))
#define GAMES_SCORES_IS_SCORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_SCORE))
#define GAMES_SCORES_IS_SCORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_SCORE))
#define GAMES_SCORES_SCORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_SCORE, GamesScoresScoreClass))

typedef struct _GamesScoresScore GamesScoresScore;
typedef struct _GamesScoresScoreClass GamesScoresScoreClass;
enum  {
	GAMES_SCORES_CONTEXT_0_PROPERTY,
	GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY,
	GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY,
	GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY,
	GAMES_SCORES_CONTEXT_STYLE_PROPERTY,
	GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY,
	GAMES_SCORES_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* games_scores_context_properties[GAMES_SCORES_CONTEXT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesScoresContextSaveScoreToFileData GamesScoresContextSaveScoreToFileData;
typedef struct _GamesScoresContextAddScoreInternalData GamesScoresContextAddScoreInternalData;
typedef struct _GamesScoresContextAddScoreData GamesScoresContextAddScoreData;
typedef struct _Block2Data Block2Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block3Data Block3Data;

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER,
	GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER,
	GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER,
	GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER
} GamesScoresStyle;

struct _GamesScoresContext {
	GObject parent_instance;
	GamesScoresContextPrivate * priv;
};

struct _GamesScoresContextClass {
	GObjectClass parent_class;
};

typedef GamesScoresCategory* (*GamesScoresContextCategoryRequestFunc) (const gchar* category_key, gpointer user_data);
struct _GamesScoresContextPrivate {
	gchar* _app_name;
	gchar* _category_type;
	GtkWindow* _game_window;
	GamesScoresStyle _style;
	GamesScoresImporter* _importer;
	GamesScoresCategory* current_category;
	GeeHashMap* scores_per_category;
	gchar* user_score_dir;
	gboolean scores_loaded;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
	GDestroyNotify category_request_target_destroy_notify;
};

struct _Block1Data {
	int _ref_count_;
	GamesScoresContext* self;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
};

struct _GamesScoresContextSaveScoreToFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesScoresContext* self;
	GamesScoresScore* score;
	GamesScoresCategory* category;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GFile* file;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFileOutputStream* stream;
	GFile* _tmp12_;
	GFileOutputStream* _tmp13_;
	gchar* line;
	glong _tmp14_;
	glong _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint64 _tmp18_;
	gint64 _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GFileOutputStream* _tmp27_;
	const gchar* _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	guint8* _tmp30_;
	gint _tmp30__length1;
	GError * _inner_error_;
};

struct _GamesScoresContextAddScoreInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesScoresContext* self;
	GamesScoresScore* score;
	GamesScoresCategory* category;
	gboolean allow_dialog;
	GCancellable* cancellable;
	gboolean result;
	gboolean high_score_added;
	glong _tmp0_;
	glong _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeHashMap* _tmp6_;
	gpointer _tmp7_;
	GeeList* _tmp8_;
	gboolean _tmp9_;
	GamesScoresCategory* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GamesScoresCategory* _tmp13_;
	GError * _inner_error_;
};

struct _GamesScoresContextAddScoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesScoresContext* self;
	glong score;
	GamesScoresCategory* category;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresScore* _tmp2_;
	GtkWindow* _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	GamesScoresContext* self;
	GMainLoop* main_loop;
	gboolean ret;
	GError* _error_;
};

struct _Block3Data {
	int _ref_count_;
	GamesScoresContext* self;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
};


static gint GamesScoresContext_private_offset;
static gpointer games_scores_context_parent_class = NULL;
static GeeHashDataFunc games_scores_context_category_hash;
static gpointer games_scores_context_category_hash_target;
static GDestroyNotify games_scores_context_category_hash_target_destroy_notify;
static GeeHashDataFunc games_scores_context_category_hash = NULL;
static gpointer games_scores_context_category_hash_target = NULL;
static GDestroyNotify games_scores_context_category_hash_target_destroy_notify = NULL;
static GeeEqualDataFunc games_scores_context_category_equal;
static gpointer games_scores_context_category_equal_target;
static GDestroyNotify games_scores_context_category_equal_target_destroy_notify;
static GeeEqualDataFunc games_scores_context_category_equal = NULL;
static gpointer games_scores_context_category_equal_target = NULL;
static GDestroyNotify games_scores_context_category_equal_target_destroy_notify = NULL;

GType games_scores_style_get_type (void) G_GNUC_CONST;
GType games_scores_context_get_type (void) G_GNUC_CONST;
GType games_scores_importer_get_type (void) G_GNUC_CONST;
GType games_scores_category_get_type (void) G_GNUC_CONST;
GType games_scores_score_get_type (void) G_GNUC_CONST;
static guint _games_scores_context_category_hash_lambda4_ (GamesScoresCategory* a);
const gchar* games_scores_category_get_key (GamesScoresCategory* self);
static guint __games_scores_context_category_hash_lambda4__gee_hash_data_func (gconstpointer v,
                                                                        gpointer self);
static gboolean _games_scores_context_category_equal_lambda5_ (GamesScoresCategory* a,
                                                        GamesScoresCategory* b);
static gboolean __games_scores_context_category_equal_lambda5__gee_equal_data_func (gconstpointer a,
                                                                             gconstpointer b,
                                                                             gpointer self);
GamesScoresContext* games_scores_context_new (const gchar* app_name,
                                              const gchar* category_type,
                                              GtkWindow* game_window,
                                              GamesScoresContextCategoryRequestFunc category_request,
                                              gpointer category_request_target,
                                              GamesScoresStyle style);
GamesScoresContext* games_scores_context_construct (GType object_type,
                                                    const gchar* app_name,
                                                    const gchar* category_type,
                                                    GtkWindow* game_window,
                                                    GamesScoresContextCategoryRequestFunc category_request,
                                                    gpointer category_request_target,
                                                    GamesScoresStyle style);
GamesScoresContext* games_scores_context_new_with_importer (const gchar* app_name,
                                                            const gchar* category_type,
                                                            GtkWindow* game_window,
                                                            GamesScoresContextCategoryRequestFunc category_request,
                                                            gpointer category_request_target,
                                                            GamesScoresStyle style,
                                                            GamesScoresImporter* importer);
GamesScoresContext* games_scores_context_construct_with_importer (GType object_type,
                                                                  const gchar* app_name,
                                                                  const gchar* category_type,
                                                                  GtkWindow* game_window,
                                                                  GamesScoresContextCategoryRequestFunc category_request,
                                                                  gpointer category_request_target,
                                                                  GamesScoresStyle style,
                                                                  GamesScoresImporter* importer);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GamesScoresCategory* __lambda6_ (Block1Data* _data1_,
                                 const gchar* key);
static GamesScoresCategory* ___lambda6__games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self);
static void games_scores_context_load_scores_from_files (GamesScoresContext* self,
                                                  GError** error);
static void games_scores_context_real_constructed (GObject* base);
const gchar* games_scores_context_get_app_name (GamesScoresContext* self);
GamesScoresImporter* games_scores_context_get_importer (GamesScoresContext* self);
void games_scores_importer_run (GamesScoresImporter* self,
                                GamesScoresContext* context,
                                const gchar* new_scores_dir);
GList* games_scores_context_get_categories (GamesScoresContext* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
gboolean games_scores_score_equals (GamesScoresScore* a,
                                    GamesScoresScore* b);
void games_scores_score_set_user (GamesScoresScore* self,
                                  const gchar* value);
GeeList* games_scores_context_get_high_scores (GamesScoresContext* self,
                                               GamesScoresCategory* category,
                                               gint n);
GamesScoresStyle games_scores_context_get_style (GamesScoresContext* self);
static gint ___lambda7_ (GamesScoresContext* self,
                  GamesScoresScore* a,
                  GamesScoresScore* b);
glong games_scores_score_get_score (GamesScoresScore* self);
static gint ____lambda7__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gint ___lambda8_ (GamesScoresContext* self,
                  GamesScoresScore* a,
                  GamesScoresScore* b);
static gint ____lambda8__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gboolean games_scores_context_is_high_score (GamesScoresContext* self,
                                             glong score_value,
                                             GamesScoresCategory* category);
static void games_scores_context_save_score_to_file_data_free (gpointer _data);
static void games_scores_context_save_score_to_file_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data);
static void games_scores_context_save_score_to_file (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void games_scores_context_save_score_to_file_finish (GamesScoresContext* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static gboolean games_scores_context_save_score_to_file_co (GamesScoresContextSaveScoreToFileData* _data_);
gint64 games_scores_score_get_time (GamesScoresScore* self);
const gchar* games_scores_score_get_user (GamesScoresScore* self);
static void games_scores_context_save_score_to_file_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void games_scores_context_add_score_internal_data_free (gpointer _data);
static void games_scores_context_add_score_internal_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data);
void games_scores_context_add_score_internal (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              gboolean allow_dialog,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
gboolean games_scores_context_add_score_internal_finish (GamesScoresContext* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static gboolean games_scores_context_add_score_internal_co (GamesScoresContextAddScoreInternalData* _data_);
void games_scores_context_run_dialog_internal (GamesScoresContext* self,
                                               GamesScoresScore* new_high_score);
static void games_scores_context_add_score_internal_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void games_scores_context_add_score_data_free (gpointer _data);
static void games_scores_context_add_score_async_ready_wrapper (GObject *source_object,
                                                         GAsyncResult *res,
                                                         void *user_data);
void games_scores_context_add_score (GamesScoresContext* self,
                                     glong score,
                                     GamesScoresCategory* category,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean games_scores_context_add_score_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static gboolean games_scores_context_add_score_co (GamesScoresContextAddScoreData* _data_);
GamesScoresScore* games_scores_score_new (glong score,
                                          gint64 time,
                                          const gchar* user);
GamesScoresScore* games_scores_score_construct (GType object_type,
                                                glong score,
                                                gint64 time,
                                                const gchar* user);
GtkWindow* games_scores_context_get_game_window (GamesScoresContext* self);
static void games_scores_context_add_score_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
gboolean games_scores_context_add_score_sync (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda11_ (Block2Data* _data2_,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda11__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void games_scores_context_load_scores_from_file (GamesScoresContext* self,
                                                 GFileInfo* file_info,
                                                 GError** error);
void games_scores_context_load_scores (GamesScoresContext* self,
                                       GamesScoresContextCategoryRequestFunc category_request,
                                       gpointer category_request_target,
                                       GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static GamesScoresCategory* __lambda12_ (Block3Data* _data3_,
                                  const gchar* key);
static GamesScoresCategory* ___lambda12__games_scores_context_category_request_func (const gchar* category_key,
                                                                              gpointer self);
GType games_scores_dialog_get_type (void) G_GNUC_CONST;
const gchar* games_scores_context_get_category_type (GamesScoresContext* self);
GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            GtkWindow* window,
                                            const gchar* app_name);
GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  GtkWindow* window,
                                                  const gchar* app_name);
void games_scores_context_run_dialog (GamesScoresContext* self);
gboolean games_scores_context_has_scores (GamesScoresContext* self);
static void games_scores_context_set_app_name (GamesScoresContext* self,
                                        const gchar* value);
static void games_scores_context_set_category_type (GamesScoresContext* self,
                                             const gchar* value);
static void games_scores_context_set_game_window (GamesScoresContext* self,
                                           GtkWindow* value);
static void games_scores_context_set_style (GamesScoresContext* self,
                                     GamesScoresStyle value);
static void games_scores_context_set_importer (GamesScoresContext* self,
                                        GamesScoresImporter* value);
static void games_scores_context_finalize (GObject * obj);
static void _vala_games_scores_context_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_games_scores_context_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType
games_scores_style_get_type (void)
{
	static volatile gsize games_scores_style_type_id__volatile = 0;
	if (g_once_init_enter (&games_scores_style_type_id__volatile)) {
		static const GEnumValue values[] = {{GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER", "points-greater-is-better"}, {GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER, "GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER", "points-less-is-better"}, {GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER, "GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER", "time-greater-is-better"}, {GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER, "GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER", "time-less-is-better"}, {0, NULL, NULL}};
		GType games_scores_style_type_id;
		games_scores_style_type_id = g_enum_register_static ("GamesScoresStyle", values);
		g_once_init_leave (&games_scores_style_type_id__volatile, games_scores_style_type_id);
	}
	return games_scores_style_type_id__volatile;
}


static inline gpointer
games_scores_context_get_instance_private (GamesScoresContext* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresContext_private_offset);
}


static guint
_games_scores_context_category_hash_lambda4_ (GamesScoresCategory* a)
{
	guint result = 0U;
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 44 "scores/context.vala"
	_tmp0_ = g_str_hash;
#line 44 "scores/context.vala"
	_tmp1_ = games_scores_category_get_key (a);
#line 44 "scores/context.vala"
	_tmp2_ = _tmp1_;
#line 44 "scores/context.vala"
	result = _tmp0_ (_tmp2_);
#line 44 "scores/context.vala"
	return result;
#line 552 "context.c"
}


static guint
__games_scores_context_category_hash_lambda4__gee_hash_data_func (gconstpointer v,
                                                                  gpointer self)
{
	guint result;
	result = _games_scores_context_category_hash_lambda4_ ((GamesScoresCategory*) v);
#line 43 "scores/context.vala"
	return result;
#line 564 "context.c"
}


static gboolean
_games_scores_context_category_equal_lambda5_ (GamesScoresCategory* a,
                                               GamesScoresCategory* b)
{
	gboolean result = FALSE;
	GEqualFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 47 "scores/context.vala"
	_tmp0_ = g_str_equal;
#line 47 "scores/context.vala"
	_tmp1_ = games_scores_category_get_key (a);
#line 47 "scores/context.vala"
	_tmp2_ = _tmp1_;
#line 47 "scores/context.vala"
	_tmp3_ = games_scores_category_get_key (b);
#line 47 "scores/context.vala"
	_tmp4_ = _tmp3_;
#line 47 "scores/context.vala"
	result = _tmp0_ (_tmp2_, _tmp4_);
#line 47 "scores/context.vala"
	return result;
#line 592 "context.c"
}


static gboolean
__games_scores_context_category_equal_lambda5__gee_equal_data_func (gconstpointer a,
                                                                    gconstpointer b,
                                                                    gpointer self)
{
	gboolean result;
	result = _games_scores_context_category_equal_lambda5_ ((GamesScoresCategory*) a, (GamesScoresCategory*) b);
#line 46 "scores/context.vala"
	return result;
#line 605 "context.c"
}


GamesScoresContext*
games_scores_context_construct (GType object_type,
                                const gchar* app_name,
                                const gchar* category_type,
                                GtkWindow* game_window,
                                GamesScoresContextCategoryRequestFunc category_request,
                                gpointer category_request_target,
                                GamesScoresStyle style)
{
	GamesScoresContext * self = NULL;
#line 70 "scores/context.vala"
	g_return_val_if_fail (app_name != NULL, NULL);
#line 70 "scores/context.vala"
	g_return_val_if_fail (category_type != NULL, NULL);
#line 76 "scores/context.vala"
	self = (GamesScoresContext*) games_scores_context_construct_with_importer (object_type, app_name, category_type, game_window, category_request, category_request_target, style, NULL);
#line 70 "scores/context.vala"
	return self;
#line 627 "context.c"
}


GamesScoresContext*
games_scores_context_new (const gchar* app_name,
                          const gchar* category_type,
                          GtkWindow* game_window,
                          GamesScoresContextCategoryRequestFunc category_request,
                          gpointer category_request_target,
                          GamesScoresStyle style)
{
#line 70 "scores/context.vala"
	return games_scores_context_construct (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, game_window, category_request, category_request_target, style);
#line 641 "context.c"
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 79 "scores/context.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 79 "scores/context.vala"
	return _data1_;
#line 652 "context.c"
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 79 "scores/context.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 663 "context.c"
		GamesScoresContext* self;
#line 79 "scores/context.vala"
		self = _data1_->self;
#line 79 "scores/context.vala"
		_g_object_unref0 (self);
#line 79 "scores/context.vala"
		g_slice_free (Block1Data, _data1_);
#line 671 "context.c"
	}
}


static GamesScoresCategory*
__lambda6_ (Block1Data* _data1_,
            const gchar* key)
{
	GamesScoresContext* self;
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
#line 96 "scores/context.vala"
	self = _data1_->self;
#line 96 "scores/context.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 96 "scores/context.vala"
	_tmp0_ = _data1_->category_request (key, _data1_->category_request_target);
#line 96 "scores/context.vala"
	result = _tmp0_;
#line 96 "scores/context.vala"
	return result;
#line 693 "context.c"
}


static GamesScoresCategory*
___lambda6__games_scores_context_category_request_func (const gchar* category_key,
                                                        gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda6_ (self, category_key);
#line 96 "scores/context.vala"
	return result;
#line 705 "context.c"
}


GamesScoresContext*
games_scores_context_construct_with_importer (GType object_type,
                                              const gchar* app_name,
                                              const gchar* category_type,
                                              GtkWindow* game_window,
                                              GamesScoresContextCategoryRequestFunc category_request,
                                              gpointer category_request_target,
                                              GamesScoresStyle style,
                                              GamesScoresImporter* importer)
{
	GamesScoresContext * self = NULL;
	Block1Data* _data1_;
	GError * _inner_error_ = NULL;
#line 79 "scores/context.vala"
	g_return_val_if_fail (app_name != NULL, NULL);
#line 79 "scores/context.vala"
	g_return_val_if_fail (category_type != NULL, NULL);
#line 79 "scores/context.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 79 "scores/context.vala"
	_data1_->_ref_count_ = 1;
#line 79 "scores/context.vala"
	_data1_->category_request = category_request;
#line 79 "scores/context.vala"
	_data1_->category_request_target = category_request_target;
#line 86 "scores/context.vala"
	self = (GamesScoresContext*) g_object_new (object_type, "app-name", app_name, "category-type", category_type, "game-window", game_window, "style", style, "importer", importer, NULL);
#line 86 "scores/context.vala"
	_data1_->self = g_object_ref (self);
#line 96 "scores/context.vala"
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
#line 96 "scores/context.vala"
	self->priv->category_request = NULL;
#line 96 "scores/context.vala"
	self->priv->category_request_target = NULL;
#line 96 "scores/context.vala"
	self->priv->category_request_target_destroy_notify = NULL;
#line 96 "scores/context.vala"
	self->priv->category_request = ___lambda6__games_scores_context_category_request_func;
#line 96 "scores/context.vala"
	self->priv->category_request_target = block1_data_ref (_data1_);
#line 96 "scores/context.vala"
	self->priv->category_request_target_destroy_notify = block1_data_unref;
#line 752 "context.c"
	{
#line 99 "scores/context.vala"
		games_scores_context_load_scores_from_files (self, &_inner_error_);
#line 99 "scores/context.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 758 "context.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 97 "scores/context.vala"
		e = _inner_error_;
#line 97 "scores/context.vala"
		_inner_error_ = NULL;
#line 103 "scores/context.vala"
		_tmp0_ = e;
#line 103 "scores/context.vala"
		_tmp1_ = _tmp0_->message;
#line 103 "scores/context.vala"
		g_warning ("context.vala:103: Failed to load scores: %s", _tmp1_);
#line 97 "scores/context.vala"
		_g_error_free0 (e);
#line 780 "context.c"
	}
	__finally0:
#line 97 "scores/context.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 97 "scores/context.vala"
		block1_data_unref (_data1_);
#line 97 "scores/context.vala"
		_data1_ = NULL;
#line 97 "scores/context.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "scores/context.vala"
		g_clear_error (&_inner_error_);
#line 97 "scores/context.vala"
		return NULL;
#line 795 "context.c"
	}
#line 79 "scores/context.vala"
	block1_data_unref (_data1_);
#line 79 "scores/context.vala"
	_data1_ = NULL;
#line 79 "scores/context.vala"
	return self;
#line 803 "context.c"
}


GamesScoresContext*
games_scores_context_new_with_importer (const gchar* app_name,
                                        const gchar* category_type,
                                        GtkWindow* game_window,
                                        GamesScoresContextCategoryRequestFunc category_request,
                                        gpointer category_request_target,
                                        GamesScoresStyle style,
                                        GamesScoresImporter* importer)
{
#line 79 "scores/context.vala"
	return games_scores_context_construct_with_importer (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, game_window, category_request, category_request_target, style, importer);
#line 818 "context.c"
}


static void
games_scores_context_real_constructed (GObject* base)
{
	GamesScoresContext * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GamesScoresImporter* _tmp3_;
#line 107 "scores/context.vala"
	self = (GamesScoresContext*) base;
#line 109 "scores/context.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 109 "scores/context.vala"
	_tmp1_ = self->priv->_app_name;
#line 109 "scores/context.vala"
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, "scores", NULL, NULL);
#line 109 "scores/context.vala"
	_g_free0 (self->priv->user_score_dir);
#line 109 "scores/context.vala"
	self->priv->user_score_dir = _tmp2_;
#line 111 "scores/context.vala"
	_tmp3_ = self->priv->_importer;
#line 111 "scores/context.vala"
	if (_tmp3_ != NULL) {
#line 846 "context.c"
		GamesScoresImporter* _tmp4_;
		const gchar* _tmp5_;
#line 112 "scores/context.vala"
		_tmp4_ = self->priv->_importer;
#line 112 "scores/context.vala"
		_tmp5_ = self->priv->user_score_dir;
#line 112 "scores/context.vala"
		games_scores_importer_run (_tmp4_, self, _tmp5_);
#line 855 "context.c"
	}
}


static void
_g_object_unref0_ (gpointer var)
{
#line 115 "scores/context.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 865 "context.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 115 "scores/context.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 874 "context.c"
}


GList*
games_scores_context_get_categories (GamesScoresContext* self)
{
	GList* result = NULL;
	GList* categories = NULL;
	GeeMapIterator* iterator = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
#line 115 "scores/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 117 "scores/context.vala"
	categories = NULL;
#line 118 "scores/context.vala"
	_tmp0_ = self->priv->scores_per_category;
#line 118 "scores/context.vala"
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
#line 118 "scores/context.vala"
	iterator = _tmp1_;
#line 120 "scores/context.vala"
	while (TRUE) {
#line 898 "context.c"
		GeeMapIterator* _tmp2_;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
#line 120 "scores/context.vala"
		_tmp2_ = iterator;
#line 120 "scores/context.vala"
		if (!gee_map_iterator_next (_tmp2_)) {
#line 120 "scores/context.vala"
			break;
#line 908 "context.c"
		}
#line 122 "scores/context.vala"
		_tmp3_ = iterator;
#line 122 "scores/context.vala"
		_tmp4_ = gee_map_iterator_get_key (_tmp3_);
#line 122 "scores/context.vala"
		categories = g_list_append (categories, (GamesScoresCategory*) _tmp4_);
#line 916 "context.c"
	}
#line 125 "scores/context.vala"
	result = categories;
#line 125 "scores/context.vala"
	_g_object_unref0 (iterator);
#line 125 "scores/context.vala"
	return result;
#line 924 "context.c"
}


void
games_scores_context_update_score_name (GamesScoresContext* self,
                                        GamesScoresScore* old_score,
                                        GamesScoresCategory* category,
                                        const gchar* new_name)
{
#line 129 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 129 "scores/context.vala"
	g_return_if_fail (old_score != NULL);
#line 129 "scores/context.vala"
	g_return_if_fail (category != NULL);
#line 129 "scores/context.vala"
	g_return_if_fail (new_name != NULL);
#line 942 "context.c"
	{
		GeeList* _score_list = NULL;
		GeeHashMap* _tmp0_;
		gpointer _tmp1_;
		gint _score_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _score_index = 0;
#line 131 "scores/context.vala"
		_tmp0_ = self->priv->scores_per_category;
#line 131 "scores/context.vala"
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, category);
#line 131 "scores/context.vala"
		_score_list = (GeeList*) _tmp1_;
#line 131 "scores/context.vala"
		_tmp2_ = _score_list;
#line 131 "scores/context.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 131 "scores/context.vala"
		_tmp4_ = _tmp3_;
#line 131 "scores/context.vala"
		_score_size = _tmp4_;
#line 131 "scores/context.vala"
		_score_index = -1;
#line 131 "scores/context.vala"
		while (TRUE) {
#line 970 "context.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GamesScoresScore* score = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GamesScoresScore* _tmp11_;
#line 131 "scores/context.vala"
			_tmp5_ = _score_index;
#line 131 "scores/context.vala"
			_score_index = _tmp5_ + 1;
#line 131 "scores/context.vala"
			_tmp6_ = _score_index;
#line 131 "scores/context.vala"
			_tmp7_ = _score_size;
#line 131 "scores/context.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 131 "scores/context.vala"
				break;
#line 991 "context.c"
			}
#line 131 "scores/context.vala"
			_tmp8_ = _score_list;
#line 131 "scores/context.vala"
			_tmp9_ = _score_index;
#line 131 "scores/context.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 131 "scores/context.vala"
			score = (GamesScoresScore*) _tmp10_;
#line 133 "scores/context.vala"
			_tmp11_ = score;
#line 133 "scores/context.vala"
			if (games_scores_score_equals (_tmp11_, old_score)) {
#line 1005 "context.c"
				GamesScoresScore* _tmp12_;
#line 135 "scores/context.vala"
				_tmp12_ = score;
#line 135 "scores/context.vala"
				games_scores_score_set_user (_tmp12_, new_name);
#line 136 "scores/context.vala"
				_g_object_unref0 (score);
#line 136 "scores/context.vala"
				_g_object_unref0 (_score_list);
#line 136 "scores/context.vala"
				return;
#line 1017 "context.c"
			}
#line 131 "scores/context.vala"
			_g_object_unref0 (score);
#line 1021 "context.c"
		}
#line 131 "scores/context.vala"
		_g_object_unref0 (_score_list);
#line 1025 "context.c"
	}
#line 139 "scores/context.vala"
	g_assert_not_reached ();
#line 1029 "context.c"
}


static gint
___lambda7_ (GamesScoresContext* self,
             GamesScoresScore* a,
             GamesScoresScore* b)
{
	gint result = 0;
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong _tmp3_;
	glong _tmp4_;
	glong _tmp5_;
	glong _tmp6_;
	glong _tmp7_;
#line 151 "scores/context.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 151 "scores/context.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 152 "scores/context.vala"
	_tmp0_ = games_scores_score_get_score (b);
#line 152 "scores/context.vala"
	_tmp1_ = _tmp0_;
#line 152 "scores/context.vala"
	_tmp2_ = games_scores_score_get_score (a);
#line 152 "scores/context.vala"
	_tmp3_ = _tmp2_;
#line 152 "scores/context.vala"
	_tmp4_ = games_scores_score_get_score (a);
#line 152 "scores/context.vala"
	_tmp5_ = _tmp4_;
#line 152 "scores/context.vala"
	_tmp6_ = games_scores_score_get_score (b);
#line 152 "scores/context.vala"
	_tmp7_ = _tmp6_;
#line 152 "scores/context.vala"
	result = ((gint) (_tmp1_ > _tmp3_)) - ((gint) (_tmp5_ > _tmp7_));
#line 152 "scores/context.vala"
	return result;
#line 1071 "context.c"
}


static gint
____lambda7__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = ___lambda7_ ((GamesScoresContext*) self, (GamesScoresScore*) a, (GamesScoresScore*) b);
#line 151 "scores/context.vala"
	return result;
#line 1084 "context.c"
}


static gint
___lambda8_ (GamesScoresContext* self,
             GamesScoresScore* a,
             GamesScoresScore* b)
{
	gint result = 0;
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong _tmp3_;
	glong _tmp4_;
	glong _tmp5_;
	glong _tmp6_;
	glong _tmp7_;
#line 157 "scores/context.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 157 "scores/context.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 158 "scores/context.vala"
	_tmp0_ = games_scores_score_get_score (b);
#line 158 "scores/context.vala"
	_tmp1_ = _tmp0_;
#line 158 "scores/context.vala"
	_tmp2_ = games_scores_score_get_score (a);
#line 158 "scores/context.vala"
	_tmp3_ = _tmp2_;
#line 158 "scores/context.vala"
	_tmp4_ = games_scores_score_get_score (a);
#line 158 "scores/context.vala"
	_tmp5_ = _tmp4_;
#line 158 "scores/context.vala"
	_tmp6_ = games_scores_score_get_score (b);
#line 158 "scores/context.vala"
	_tmp7_ = _tmp6_;
#line 158 "scores/context.vala"
	result = ((gint) (_tmp1_ < _tmp3_)) - ((gint) (_tmp5_ < _tmp7_));
#line 158 "scores/context.vala"
	return result;
#line 1126 "context.c"
}


static gint
____lambda8__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = ___lambda8_ ((GamesScoresContext*) self, (GamesScoresScore*) a, (GamesScoresScore*) b);
#line 157 "scores/context.vala"
	return result;
#line 1139 "context.c"
}


GeeList*
games_scores_context_get_high_scores (GamesScoresContext* self,
                                      GamesScoresCategory* category,
                                      gint n)
{
	GeeList* result = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GamesScoresStyle _tmp3_;
#line 143 "scores/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 143 "scores/context.vala"
	g_return_val_if_fail (category != NULL, NULL);
#line 145 "scores/context.vala"
	_tmp0_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 145 "scores/context.vala"
	_result_ = _tmp0_;
#line 146 "scores/context.vala"
	_tmp1_ = self->priv->scores_per_category;
#line 146 "scores/context.vala"
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, category)) {
#line 147 "scores/context.vala"
		result = (GeeList*) _result_;
#line 147 "scores/context.vala"
		return result;
#line 1170 "context.c"
	}
#line 149 "scores/context.vala"
	_tmp3_ = self->priv->_style;
#line 149 "scores/context.vala"
	if (_tmp3_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
#line 149 "scores/context.vala"
		_tmp2_ = TRUE;
#line 1178 "context.c"
	} else {
		GamesScoresStyle _tmp4_;
#line 149 "scores/context.vala"
		_tmp4_ = self->priv->_style;
#line 149 "scores/context.vala"
		_tmp2_ = _tmp4_ == GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER;
#line 1185 "context.c"
	}
#line 149 "scores/context.vala"
	if (_tmp2_) {
#line 1189 "context.c"
		GeeHashMap* _tmp5_;
		gpointer _tmp6_;
		GeeList* _tmp7_;
#line 151 "scores/context.vala"
		_tmp5_ = self->priv->scores_per_category;
#line 151 "scores/context.vala"
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, category);
#line 151 "scores/context.vala"
		_tmp7_ = (GeeList*) _tmp6_;
#line 151 "scores/context.vala"
		gee_list_sort (_tmp7_, ____lambda7__gcompare_data_func, g_object_ref (self), g_object_unref);
#line 151 "scores/context.vala"
		_g_object_unref0 (_tmp7_);
#line 1203 "context.c"
	} else {
		GeeHashMap* _tmp8_;
		gpointer _tmp9_;
		GeeList* _tmp10_;
#line 157 "scores/context.vala"
		_tmp8_ = self->priv->scores_per_category;
#line 157 "scores/context.vala"
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, category);
#line 157 "scores/context.vala"
		_tmp10_ = (GeeList*) _tmp9_;
#line 157 "scores/context.vala"
		gee_list_sort (_tmp10_, ____lambda8__gcompare_data_func, g_object_ref (self), g_object_unref);
#line 157 "scores/context.vala"
		_g_object_unref0 (_tmp10_);
#line 1218 "context.c"
	}
	{
		gint i = 0;
#line 162 "scores/context.vala"
		i = 0;
#line 1224 "context.c"
		{
			gboolean _tmp11_ = FALSE;
#line 162 "scores/context.vala"
			_tmp11_ = TRUE;
#line 162 "scores/context.vala"
			while (TRUE) {
#line 1231 "context.c"
				gboolean _tmp13_ = FALSE;
				gint _tmp14_;
				GeeArrayList* _tmp21_;
				GeeHashMap* _tmp22_;
				gpointer _tmp23_;
				GeeList* _tmp24_;
				gint _tmp25_;
				gpointer _tmp26_;
				GamesScoresScore* _tmp27_;
#line 162 "scores/context.vala"
				if (!_tmp11_) {
#line 1243 "context.c"
					gint _tmp12_;
#line 162 "scores/context.vala"
					_tmp12_ = i;
#line 162 "scores/context.vala"
					i = _tmp12_ + 1;
#line 1249 "context.c"
				}
#line 162 "scores/context.vala"
				_tmp11_ = FALSE;
#line 162 "scores/context.vala"
				_tmp14_ = i;
#line 162 "scores/context.vala"
				if (_tmp14_ < n) {
#line 1257 "context.c"
					gint _tmp15_;
					GeeHashMap* _tmp16_;
					gpointer _tmp17_;
					GeeList* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
#line 162 "scores/context.vala"
					_tmp15_ = i;
#line 162 "scores/context.vala"
					_tmp16_ = self->priv->scores_per_category;
#line 162 "scores/context.vala"
					_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, category);
#line 162 "scores/context.vala"
					_tmp18_ = (GeeList*) _tmp17_;
#line 162 "scores/context.vala"
					_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
#line 162 "scores/context.vala"
					_tmp20_ = _tmp19_;
#line 162 "scores/context.vala"
					_tmp13_ = _tmp15_ < _tmp20_;
#line 162 "scores/context.vala"
					_g_object_unref0 (_tmp18_);
#line 1280 "context.c"
				} else {
#line 162 "scores/context.vala"
					_tmp13_ = FALSE;
#line 1284 "context.c"
				}
#line 162 "scores/context.vala"
				if (!_tmp13_) {
#line 162 "scores/context.vala"
					break;
#line 1290 "context.c"
				}
#line 163 "scores/context.vala"
				_tmp21_ = _result_;
#line 163 "scores/context.vala"
				_tmp22_ = self->priv->scores_per_category;
#line 163 "scores/context.vala"
				_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, category);
#line 163 "scores/context.vala"
				_tmp24_ = (GeeList*) _tmp23_;
#line 163 "scores/context.vala"
				_tmp25_ = i;
#line 163 "scores/context.vala"
				_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
#line 163 "scores/context.vala"
				_tmp27_ = (GamesScoresScore*) _tmp26_;
#line 163 "scores/context.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp27_);
#line 163 "scores/context.vala"
				_g_object_unref0 (_tmp27_);
#line 163 "scores/context.vala"
				_g_object_unref0 (_tmp24_);
#line 1312 "context.c"
			}
		}
	}
#line 164 "scores/context.vala"
	result = (GeeList*) _result_;
#line 164 "scores/context.vala"
	return result;
#line 1320 "context.c"
}


static gboolean
games_scores_context_is_high_score (GamesScoresContext* self,
                                    glong score_value,
                                    GamesScoresCategory* category)
{
	gboolean result = FALSE;
	GeeList* best_scores = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong lowest = 0L;
	GeeList* _tmp5_;
	gpointer _tmp6_;
	GamesScoresScore* _tmp7_;
	glong _tmp8_;
	glong _tmp9_;
	glong _tmp10_;
	gboolean _tmp11_ = FALSE;
	GamesScoresStyle _tmp12_;
	glong _tmp15_;
#line 167 "scores/context.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 167 "scores/context.vala"
	g_return_val_if_fail (category != NULL, FALSE);
#line 169 "scores/context.vala"
	_tmp0_ = games_scores_context_get_high_scores (self, category, 10);
#line 169 "scores/context.vala"
	best_scores = _tmp0_;
#line 172 "scores/context.vala"
	_tmp1_ = best_scores;
#line 172 "scores/context.vala"
	if (_tmp1_ == NULL) {
#line 173 "scores/context.vala"
		result = TRUE;
#line 173 "scores/context.vala"
		_g_object_unref0 (best_scores);
#line 173 "scores/context.vala"
		return result;
#line 1364 "context.c"
	}
#line 175 "scores/context.vala"
	_tmp2_ = best_scores;
#line 175 "scores/context.vala"
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 175 "scores/context.vala"
	_tmp4_ = _tmp3_;
#line 175 "scores/context.vala"
	if (_tmp4_ < 10) {
#line 176 "scores/context.vala"
		result = TRUE;
#line 176 "scores/context.vala"
		_g_object_unref0 (best_scores);
#line 176 "scores/context.vala"
		return result;
#line 1380 "context.c"
	}
#line 178 "scores/context.vala"
	_tmp5_ = best_scores;
#line 178 "scores/context.vala"
	_tmp6_ = gee_list_get (_tmp5_, 9);
#line 178 "scores/context.vala"
	_tmp7_ = (GamesScoresScore*) _tmp6_;
#line 178 "scores/context.vala"
	_tmp8_ = games_scores_score_get_score (_tmp7_);
#line 178 "scores/context.vala"
	_tmp9_ = _tmp8_;
#line 178 "scores/context.vala"
	_tmp10_ = _tmp9_;
#line 178 "scores/context.vala"
	_g_object_unref0 (_tmp7_);
#line 178 "scores/context.vala"
	lowest = _tmp10_;
#line 180 "scores/context.vala"
	_tmp12_ = self->priv->_style;
#line 180 "scores/context.vala"
	if (_tmp12_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER) {
#line 180 "scores/context.vala"
		_tmp11_ = TRUE;
#line 1404 "context.c"
	} else {
		GamesScoresStyle _tmp13_;
#line 180 "scores/context.vala"
		_tmp13_ = self->priv->_style;
#line 180 "scores/context.vala"
		_tmp11_ = _tmp13_ == GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER;
#line 1411 "context.c"
	}
#line 180 "scores/context.vala"
	if (_tmp11_) {
#line 1415 "context.c"
		glong _tmp14_;
#line 181 "scores/context.vala"
		_tmp14_ = lowest;
#line 181 "scores/context.vala"
		result = score_value < _tmp14_;
#line 181 "scores/context.vala"
		_g_object_unref0 (best_scores);
#line 181 "scores/context.vala"
		return result;
#line 1425 "context.c"
	}
#line 183 "scores/context.vala"
	_tmp15_ = lowest;
#line 183 "scores/context.vala"
	result = score_value > _tmp15_;
#line 183 "scores/context.vala"
	_g_object_unref0 (best_scores);
#line 183 "scores/context.vala"
	return result;
#line 1435 "context.c"
}


static void
games_scores_context_save_score_to_file_data_free (gpointer _data)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = _data;
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->score);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->category);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->cancellable);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->self);
#line 33 "scores/context.vala"
	g_slice_free (GamesScoresContextSaveScoreToFileData, _data_);
#line 1454 "context.c"
}


static void
games_scores_context_save_score_to_file_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data)
{
	GamesScoresContextSaveScoreToFileData* _task_data_;
#line 33 "scores/context.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 33 "scores/context.vala"
	if (_task_data_->_callback_ != NULL) {
#line 33 "scores/context.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 1470 "context.c"
	}
#line 33 "scores/context.vala"
	_task_data_->_task_complete_ = TRUE;
#line 1474 "context.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 33 "scores/context.vala"
	return self ? g_object_ref (self) : NULL;
#line 1483 "context.c"
}


static void
games_scores_context_save_score_to_file (GamesScoresContext* self,
                                         GamesScoresScore* score,
                                         GamesScoresCategory* category,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GCancellable* _tmp3_;
#line 33 "scores/context.vala"
	_data_ = g_slice_new0 (GamesScoresContextSaveScoreToFileData);
#line 33 "scores/context.vala"
	_data_->_callback_ = _callback_;
#line 33 "scores/context.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, games_scores_context_save_score_to_file_async_ready_wrapper, _user_data_);
#line 33 "scores/context.vala"
	if (_callback_ == NULL) {
#line 33 "scores/context.vala"
		_data_->_task_complete_ = TRUE;
#line 1510 "context.c"
	}
#line 33 "scores/context.vala"
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_save_score_to_file_data_free);
#line 33 "scores/context.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "scores/context.vala"
	_data_->self = _tmp0_;
#line 33 "scores/context.vala"
	_tmp1_ = _g_object_ref0 (score);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->score);
#line 33 "scores/context.vala"
	_data_->score = _tmp1_;
#line 33 "scores/context.vala"
	_tmp2_ = _g_object_ref0 (category);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->category);
#line 33 "scores/context.vala"
	_data_->category = _tmp2_;
#line 33 "scores/context.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->cancellable);
#line 33 "scores/context.vala"
	_data_->cancellable = _tmp3_;
#line 33 "scores/context.vala"
	games_scores_context_save_score_to_file_co (_data_);
#line 1538 "context.c"
}


static void
games_scores_context_save_score_to_file_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GamesScoresContextSaveScoreToFileData* _data_;
#line 33 "scores/context.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 33 "scores/context.vala"
	if (NULL == _data_) {
#line 33 "scores/context.vala"
		return;
#line 1554 "context.c"
	}
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1513 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	result = self;
#line 1514 "glib-2.0.vapi"
	return result;
#line 1569 "context.c"
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1498 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1499 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1499 "glib-2.0.vapi"
	res_length1 = -1;
#line 1499 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1500 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1500 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1500 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1500 "glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1501 "glib-2.0.vapi"
	_tmp3_ = res;
#line 1501 "glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1501 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1501 "glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1501 "glib-2.0.vapi"
	if (result_length1) {
#line 1501 "glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1616 "context.c"
	}
#line 1501 "glib-2.0.vapi"
	result = _tmp4_;
#line 1501 "glib-2.0.vapi"
	return result;
#line 1622 "context.c"
}


static void
games_scores_context_save_score_to_file_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GamesScoresContextSaveScoreToFileData* _data_;
#line 197 "scores/context.vala"
	_data_ = _user_data_;
#line 197 "scores/context.vala"
	_data_->_source_object_ = source_object;
#line 197 "scores/context.vala"
	_data_->_res_ = _res_;
#line 197 "scores/context.vala"
	_data_->_task_complete_ = TRUE;
#line 197 "scores/context.vala"
	games_scores_context_save_score_to_file_co (_data_);
#line 1642 "context.c"
}


static gboolean
games_scores_context_save_score_to_file_co (GamesScoresContextSaveScoreToFileData* _data_)
{
#line 186 "scores/context.vala"
	switch (_data_->_state_) {
#line 186 "scores/context.vala"
		case 0:
#line 1653 "context.c"
		goto _state_0;
#line 186 "scores/context.vala"
		case 1:
#line 1657 "context.c"
		goto _state_1;
		default:
#line 186 "scores/context.vala"
		g_assert_not_reached ();
#line 1662 "context.c"
	}
	_state_0:
#line 188 "scores/context.vala"
	_data_->_tmp0_ = _data_->self->priv->user_score_dir;
#line 188 "scores/context.vala"
	if (g_mkdir_with_parents (_data_->_tmp0_, 0766) == -1) {
#line 190 "scores/context.vala"
		_data_->_tmp1_ = _data_->self->priv->user_score_dir;
#line 190 "scores/context.vala"
		_data_->_tmp2_ = errno;
#line 190 "scores/context.vala"
		_data_->_tmp3_ = g_strerror (_data_->_tmp2_);
#line 190 "scores/context.vala"
		_data_->_tmp4_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Failed to create %s: %s", _data_->_tmp1_, _data_->_tmp3_);
#line 190 "scores/context.vala"
		_data_->_inner_error_ = _data_->_tmp4_;
#line 190 "scores/context.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 190 "scores/context.vala"
		g_object_unref (_data_->_async_result);
#line 190 "scores/context.vala"
		return FALSE;
#line 1685 "context.c"
	}
#line 193 "scores/context.vala"
	_data_->_tmp5_ = _data_->self->priv->user_score_dir;
#line 193 "scores/context.vala"
	_data_->_tmp6_ = games_scores_category_get_key (_data_->category);
#line 193 "scores/context.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 193 "scores/context.vala"
	_data_->_tmp8_ = g_build_filename (_data_->_tmp5_, _data_->_tmp7_, NULL);
#line 193 "scores/context.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 193 "scores/context.vala"
	_data_->_tmp10_ = g_file_new_for_path (_data_->_tmp9_);
#line 193 "scores/context.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 193 "scores/context.vala"
	_g_free0 (_data_->_tmp9_);
#line 193 "scores/context.vala"
	_data_->file = _data_->_tmp11_;
#line 194 "scores/context.vala"
	_data_->_tmp12_ = _data_->file;
#line 194 "scores/context.vala"
	_data_->_tmp13_ = g_file_append_to (_data_->_tmp12_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error_);
#line 194 "scores/context.vala"
	_data_->stream = _data_->_tmp13_;
#line 194 "scores/context.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 194 "scores/context.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 194 "scores/context.vala"
		_g_object_unref0 (_data_->file);
#line 194 "scores/context.vala"
		g_object_unref (_data_->_async_result);
#line 194 "scores/context.vala"
		return FALSE;
#line 1721 "context.c"
	}
#line 195 "scores/context.vala"
	_data_->_tmp14_ = games_scores_score_get_score (_data_->score);
#line 195 "scores/context.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 195 "scores/context.vala"
	_data_->_tmp16_ = g_strdup_printf ("%li", _data_->_tmp15_);
#line 195 "scores/context.vala"
	_data_->_tmp17_ = _data_->_tmp16_;
#line 195 "scores/context.vala"
	_data_->_tmp18_ = games_scores_score_get_time (_data_->score);
#line 195 "scores/context.vala"
	_data_->_tmp19_ = _data_->_tmp18_;
#line 195 "scores/context.vala"
	_data_->_tmp20_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp19_);
#line 195 "scores/context.vala"
	_data_->_tmp21_ = _data_->_tmp20_;
#line 195 "scores/context.vala"
	_data_->_tmp22_ = games_scores_score_get_user (_data_->score);
#line 195 "scores/context.vala"
	_data_->_tmp23_ = _data_->_tmp22_;
#line 195 "scores/context.vala"
	_data_->_tmp24_ = string_to_string (_data_->_tmp23_);
#line 195 "scores/context.vala"
	_data_->_tmp25_ = g_strconcat (_data_->_tmp17_, " ", _data_->_tmp21_, " ", _data_->_tmp24_, "\n", NULL);
#line 195 "scores/context.vala"
	_data_->_tmp26_ = _data_->_tmp25_;
#line 195 "scores/context.vala"
	_g_free0 (_data_->_tmp21_);
#line 195 "scores/context.vala"
	_g_free0 (_data_->_tmp17_);
#line 195 "scores/context.vala"
	_data_->line = _data_->_tmp26_;
#line 197 "scores/context.vala"
	_data_->_tmp27_ = _data_->stream;
#line 197 "scores/context.vala"
	_data_->_tmp28_ = _data_->line;
#line 197 "scores/context.vala"
	_data_->_tmp29_ = string_get_data (_data_->_tmp28_, &_data_->_tmp29__length1);
#line 197 "scores/context.vala"
	_data_->_tmp30_ = _data_->_tmp29_;
#line 197 "scores/context.vala"
	_data_->_tmp30__length1 = _data_->_tmp29__length1;
#line 197 "scores/context.vala"
	_data_->_state_ = 1;
#line 197 "scores/context.vala"
	g_output_stream_write_all_async ((GOutputStream*) _data_->_tmp27_, _data_->_tmp30_, (gsize) _data_->_tmp30__length1, G_PRIORITY_DEFAULT, _data_->cancellable, games_scores_context_save_score_to_file_ready, _data_);
#line 197 "scores/context.vala"
	return FALSE;
#line 1771 "context.c"
	_state_1:
#line 197 "scores/context.vala"
	g_output_stream_write_all_finish ((GOutputStream*) _data_->_tmp27_, _data_->_res_, NULL, &_data_->_inner_error_);
#line 197 "scores/context.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 197 "scores/context.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 197 "scores/context.vala"
		_g_free0 (_data_->line);
#line 197 "scores/context.vala"
		_g_object_unref0 (_data_->stream);
#line 197 "scores/context.vala"
		_g_object_unref0 (_data_->file);
#line 197 "scores/context.vala"
		g_object_unref (_data_->_async_result);
#line 197 "scores/context.vala"
		return FALSE;
#line 1789 "context.c"
	}
#line 186 "scores/context.vala"
	_g_free0 (_data_->line);
#line 186 "scores/context.vala"
	_g_object_unref0 (_data_->stream);
#line 186 "scores/context.vala"
	_g_object_unref0 (_data_->file);
#line 186 "scores/context.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 186 "scores/context.vala"
	if (_data_->_state_ != 0) {
#line 186 "scores/context.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 186 "scores/context.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1805 "context.c"
		}
	}
#line 186 "scores/context.vala"
	g_object_unref (_data_->_async_result);
#line 186 "scores/context.vala"
	return FALSE;
#line 1812 "context.c"
}


static void
games_scores_context_add_score_internal_data_free (gpointer _data)
{
	GamesScoresContextAddScoreInternalData* _data_;
	_data_ = _data;
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->score);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->category);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->cancellable);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->self);
#line 33 "scores/context.vala"
	g_slice_free (GamesScoresContextAddScoreInternalData, _data_);
#line 1831 "context.c"
}


static void
games_scores_context_add_score_internal_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data)
{
	GamesScoresContextAddScoreInternalData* _task_data_;
#line 33 "scores/context.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 33 "scores/context.vala"
	if (_task_data_->_callback_ != NULL) {
#line 33 "scores/context.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 1847 "context.c"
	}
#line 33 "scores/context.vala"
	_task_data_->_task_complete_ = TRUE;
#line 1851 "context.c"
}


void
games_scores_context_add_score_internal (GamesScoresContext* self,
                                         GamesScoresScore* score,
                                         GamesScoresCategory* category,
                                         gboolean allow_dialog,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GamesScoresContextAddScoreInternalData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GCancellable* _tmp3_;
#line 33 "scores/context.vala"
	_data_ = g_slice_new0 (GamesScoresContextAddScoreInternalData);
#line 33 "scores/context.vala"
	_data_->_callback_ = _callback_;
#line 33 "scores/context.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, games_scores_context_add_score_internal_async_ready_wrapper, _user_data_);
#line 33 "scores/context.vala"
	if (_callback_ == NULL) {
#line 33 "scores/context.vala"
		_data_->_task_complete_ = TRUE;
#line 1879 "context.c"
	}
#line 33 "scores/context.vala"
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_internal_data_free);
#line 33 "scores/context.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "scores/context.vala"
	_data_->self = _tmp0_;
#line 33 "scores/context.vala"
	_tmp1_ = _g_object_ref0 (score);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->score);
#line 33 "scores/context.vala"
	_data_->score = _tmp1_;
#line 33 "scores/context.vala"
	_tmp2_ = _g_object_ref0 (category);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->category);
#line 33 "scores/context.vala"
	_data_->category = _tmp2_;
#line 33 "scores/context.vala"
	_data_->allow_dialog = allow_dialog;
#line 33 "scores/context.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->cancellable);
#line 33 "scores/context.vala"
	_data_->cancellable = _tmp3_;
#line 33 "scores/context.vala"
	games_scores_context_add_score_internal_co (_data_);
#line 1909 "context.c"
}


gboolean
games_scores_context_add_score_internal_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreInternalData* _data_;
#line 33 "scores/context.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 33 "scores/context.vala"
	if (NULL == _data_) {
#line 1924 "context.c"
		gboolean _tmp0_ = FALSE;
#line 33 "scores/context.vala"
		return _tmp0_;
#line 1928 "context.c"
	}
#line 33 "scores/context.vala"
	result = _data_->result;
#line 33 "scores/context.vala"
	return result;
#line 1934 "context.c"
}


static void
games_scores_context_add_score_internal_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GamesScoresContextAddScoreInternalData* _data_;
#line 220 "scores/context.vala"
	_data_ = _user_data_;
#line 220 "scores/context.vala"
	_data_->_source_object_ = source_object;
#line 220 "scores/context.vala"
	_data_->_res_ = _res_;
#line 220 "scores/context.vala"
	_data_->_task_complete_ = TRUE;
#line 220 "scores/context.vala"
	games_scores_context_add_score_internal_co (_data_);
#line 1954 "context.c"
}


static gboolean
games_scores_context_add_score_internal_co (GamesScoresContextAddScoreInternalData* _data_)
{
#line 200 "scores/context.vala"
	switch (_data_->_state_) {
#line 200 "scores/context.vala"
		case 0:
#line 1965 "context.c"
		goto _state_0;
#line 200 "scores/context.vala"
		case 1:
#line 1969 "context.c"
		goto _state_1;
		default:
#line 200 "scores/context.vala"
		g_assert_not_reached ();
#line 1974 "context.c"
	}
	_state_0:
#line 205 "scores/context.vala"
	_data_->_tmp0_ = games_scores_score_get_score (_data_->score);
#line 205 "scores/context.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 205 "scores/context.vala"
	_data_->high_score_added = games_scores_context_is_high_score (_data_->self, _data_->_tmp1_, _data_->category);
#line 208 "scores/context.vala"
	_data_->_tmp2_ = _data_->self->priv->scores_per_category;
#line 208 "scores/context.vala"
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp2_, _data_->category)) {
#line 209 "scores/context.vala"
		_data_->_tmp3_ = _data_->self->priv->scores_per_category;
#line 209 "scores/context.vala"
		_data_->_tmp4_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 209 "scores/context.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 209 "scores/context.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp3_, _data_->category, (GeeList*) _data_->_tmp5_);
#line 209 "scores/context.vala"
		_g_object_unref0 (_data_->_tmp5_);
#line 1997 "context.c"
	}
#line 211 "scores/context.vala"
	_data_->_tmp6_ = _data_->self->priv->scores_per_category;
#line 211 "scores/context.vala"
	_data_->_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp6_, _data_->category);
#line 211 "scores/context.vala"
	_data_->_tmp8_ = (GeeList*) _data_->_tmp7_;
#line 211 "scores/context.vala"
	_data_->_tmp9_ = gee_collection_add ((GeeCollection*) _data_->_tmp8_, _data_->score);
#line 211 "scores/context.vala"
	_g_object_unref0 (_data_->_tmp8_);
#line 211 "scores/context.vala"
	if (_data_->_tmp9_) {
#line 212 "scores/context.vala"
		_data_->_tmp10_ = _g_object_ref0 (_data_->category);
#line 212 "scores/context.vala"
		_g_object_unref0 (_data_->self->priv->current_category);
#line 212 "scores/context.vala"
		_data_->self->priv->current_category = _data_->_tmp10_;
#line 2017 "context.c"
	}
#line 217 "scores/context.vala"
	_data_->_tmp12_ = _data_->high_score_added;
#line 217 "scores/context.vala"
	if (_data_->_tmp12_) {
#line 217 "scores/context.vala"
		_data_->_tmp11_ = _data_->allow_dialog;
#line 2025 "context.c"
	} else {
#line 217 "scores/context.vala"
		_data_->_tmp11_ = FALSE;
#line 2029 "context.c"
	}
#line 217 "scores/context.vala"
	if (_data_->_tmp11_) {
#line 218 "scores/context.vala"
		games_scores_context_run_dialog_internal (_data_->self, _data_->score);
#line 2035 "context.c"
	}
#line 220 "scores/context.vala"
	_data_->_tmp13_ = _data_->self->priv->current_category;
#line 220 "scores/context.vala"
	_data_->_state_ = 1;
#line 220 "scores/context.vala"
	games_scores_context_save_score_to_file (_data_->self, _data_->score, _data_->_tmp13_, _data_->cancellable, games_scores_context_add_score_internal_ready, _data_);
#line 220 "scores/context.vala"
	return FALSE;
#line 2045 "context.c"
	_state_1:
#line 220 "scores/context.vala"
	games_scores_context_save_score_to_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 220 "scores/context.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 220 "scores/context.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 220 "scores/context.vala"
		g_object_unref (_data_->_async_result);
#line 220 "scores/context.vala"
		return FALSE;
#line 2057 "context.c"
	}
#line 221 "scores/context.vala"
	_data_->result = _data_->high_score_added;
#line 221 "scores/context.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 221 "scores/context.vala"
	if (_data_->_state_ != 0) {
#line 221 "scores/context.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 221 "scores/context.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2069 "context.c"
		}
	}
#line 221 "scores/context.vala"
	g_object_unref (_data_->_async_result);
#line 221 "scores/context.vala"
	return FALSE;
#line 2076 "context.c"
}


static void
games_scores_context_add_score_data_free (gpointer _data)
{
	GamesScoresContextAddScoreData* _data_;
	_data_ = _data;
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->category);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->cancellable);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->self);
#line 33 "scores/context.vala"
	g_slice_free (GamesScoresContextAddScoreData, _data_);
#line 2093 "context.c"
}


static void
games_scores_context_add_score_async_ready_wrapper (GObject *source_object,
                                                    GAsyncResult *res,
                                                    void *user_data)
{
	GamesScoresContextAddScoreData* _task_data_;
#line 33 "scores/context.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 33 "scores/context.vala"
	if (_task_data_->_callback_ != NULL) {
#line 33 "scores/context.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 2109 "context.c"
	}
#line 33 "scores/context.vala"
	_task_data_->_task_complete_ = TRUE;
#line 2113 "context.c"
}


void
games_scores_context_add_score (GamesScoresContext* self,
                                glong score,
                                GamesScoresCategory* category,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GamesScoresContextAddScoreData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GCancellable* _tmp2_;
#line 33 "scores/context.vala"
	_data_ = g_slice_new0 (GamesScoresContextAddScoreData);
#line 33 "scores/context.vala"
	_data_->_callback_ = _callback_;
#line 33 "scores/context.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, games_scores_context_add_score_async_ready_wrapper, _user_data_);
#line 33 "scores/context.vala"
	if (_callback_ == NULL) {
#line 33 "scores/context.vala"
		_data_->_task_complete_ = TRUE;
#line 2139 "context.c"
	}
#line 33 "scores/context.vala"
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_data_free);
#line 33 "scores/context.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "scores/context.vala"
	_data_->self = _tmp0_;
#line 33 "scores/context.vala"
	_data_->score = score;
#line 33 "scores/context.vala"
	_tmp1_ = _g_object_ref0 (category);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->category);
#line 33 "scores/context.vala"
	_data_->category = _tmp1_;
#line 33 "scores/context.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 33 "scores/context.vala"
	_g_object_unref0 (_data_->cancellable);
#line 33 "scores/context.vala"
	_data_->cancellable = _tmp2_;
#line 33 "scores/context.vala"
	games_scores_context_add_score_co (_data_);
#line 2163 "context.c"
}


gboolean
games_scores_context_add_score_finish (GamesScoresContext* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreData* _data_;
#line 33 "scores/context.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 33 "scores/context.vala"
	if (NULL == _data_) {
#line 2178 "context.c"
		gboolean _tmp0_ = FALSE;
#line 33 "scores/context.vala"
		return _tmp0_;
#line 2182 "context.c"
	}
#line 33 "scores/context.vala"
	result = _data_->result;
#line 33 "scores/context.vala"
	return result;
#line 2188 "context.c"
}


static void
games_scores_context_add_score_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GamesScoresContextAddScoreData* _data_;
#line 228 "scores/context.vala"
	_data_ = _user_data_;
#line 228 "scores/context.vala"
	_data_->_source_object_ = source_object;
#line 228 "scores/context.vala"
	_data_->_res_ = _res_;
#line 228 "scores/context.vala"
	_data_->_task_complete_ = TRUE;
#line 228 "scores/context.vala"
	games_scores_context_add_score_co (_data_);
#line 2208 "context.c"
}


static gboolean
games_scores_context_add_score_co (GamesScoresContextAddScoreData* _data_)
{
#line 225 "scores/context.vala"
	switch (_data_->_state_) {
#line 225 "scores/context.vala"
		case 0:
#line 2219 "context.c"
		goto _state_0;
#line 225 "scores/context.vala"
		case 1:
#line 2223 "context.c"
		goto _state_1;
		default:
#line 225 "scores/context.vala"
		g_assert_not_reached ();
#line 2228 "context.c"
	}
	_state_0:
#line 228 "scores/context.vala"
	_data_->_tmp1_ = games_scores_score_new (_data_->score, (gint64) 0, NULL);
#line 228 "scores/context.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 228 "scores/context.vala"
	_data_->_tmp3_ = _data_->self->priv->_game_window;
#line 228 "scores/context.vala"
	_data_->_state_ = 1;
#line 228 "scores/context.vala"
	games_scores_context_add_score_internal (_data_->self, _data_->_tmp2_, _data_->category, _data_->_tmp3_ != NULL, _data_->cancellable, games_scores_context_add_score_ready, _data_);
#line 228 "scores/context.vala"
	return FALSE;
#line 2243 "context.c"
	_state_1:
#line 228 "scores/context.vala"
	_data_->_tmp4_ = games_scores_context_add_score_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 228 "scores/context.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 228 "scores/context.vala"
	_data_->_tmp0_ = _data_->_tmp4_;
#line 228 "scores/context.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 228 "scores/context.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 228 "scores/context.vala"
		g_object_unref (_data_->_async_result);
#line 228 "scores/context.vala"
		return FALSE;
#line 2259 "context.c"
	}
#line 228 "scores/context.vala"
	_data_->result = _data_->_tmp0_;
#line 228 "scores/context.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 228 "scores/context.vala"
	if (_data_->_state_ != 0) {
#line 228 "scores/context.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 228 "scores/context.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2271 "context.c"
		}
	}
#line 228 "scores/context.vala"
	g_object_unref (_data_->_async_result);
#line 228 "scores/context.vala"
	return FALSE;
#line 2278 "context.c"
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 231 "scores/context.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 231 "scores/context.vala"
	return _data2_;
#line 2289 "context.c"
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 231 "scores/context.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2300 "context.c"
		GamesScoresContext* self;
#line 231 "scores/context.vala"
		self = _data2_->self;
#line 231 "scores/context.vala"
		_g_error_free0 (_data2_->_error_);
#line 231 "scores/context.vala"
		_g_main_loop_unref0 (_data2_->main_loop);
#line 231 "scores/context.vala"
		_g_object_unref0 (self);
#line 231 "scores/context.vala"
		g_slice_free (Block2Data, _data2_);
#line 2312 "context.c"
	}
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 246 "scores/context.vala"
	return self ? g_error_copy (self) : NULL;
#line 2322 "context.c"
}


static void
__lambda11_ (Block2Data* _data2_,
             GObject* object,
             GAsyncResult* _result_)
{
	GamesScoresContext* self;
	GMainLoop* _tmp3_;
	GError * _inner_error_ = NULL;
#line 239 "scores/context.vala"
	self = _data2_->self;
#line 239 "scores/context.vala"
	g_return_if_fail (_result_ != NULL);
#line 2338 "context.c"
	{
		gboolean _tmp0_ = FALSE;
#line 242 "scores/context.vala"
		_tmp0_ = games_scores_context_add_score_internal_finish (self, _result_, &_inner_error_);
#line 242 "scores/context.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2345 "context.c"
			goto __catch1_g_error;
		}
#line 242 "scores/context.vala"
		_data2_->ret = _tmp0_;
#line 2350 "context.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		GError* _tmp2_;
#line 240 "scores/context.vala"
		e = _inner_error_;
#line 240 "scores/context.vala"
		_inner_error_ = NULL;
#line 246 "scores/context.vala"
		_tmp1_ = e;
#line 246 "scores/context.vala"
		_tmp2_ = _g_error_copy0 (_tmp1_);
#line 246 "scores/context.vala"
		_g_error_free0 (_data2_->_error_);
#line 246 "scores/context.vala"
		_data2_->_error_ = _tmp2_;
#line 240 "scores/context.vala"
		_g_error_free0 (e);
#line 2372 "context.c"
	}
	__finally1:
#line 240 "scores/context.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 240 "scores/context.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 240 "scores/context.vala"
		g_clear_error (&_inner_error_);
#line 240 "scores/context.vala"
		return;
#line 2383 "context.c"
	}
#line 248 "scores/context.vala"
	_tmp3_ = _data2_->main_loop;
#line 248 "scores/context.vala"
	g_main_loop_quit (_tmp3_);
#line 2389 "context.c"
}


static void
___lambda11__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 239 "scores/context.vala"
	__lambda11_ (self, source_object, res);
#line 239 "scores/context.vala"
	block2_data_unref (self);
#line 2402 "context.c"
}


gboolean
games_scores_context_add_score_sync (GamesScoresContext* self,
                                     GamesScoresScore* score,
                                     GamesScoresCategory* category,
                                     GError** error)
{
	gboolean result = FALSE;
	Block2Data* _data2_;
	GMainContext* main_context = NULL;
	GMainContext* _tmp0_;
	GMainContext* _tmp1_;
	GMainLoop* _tmp2_;
	GMainContext* _tmp3_;
	GMainLoop* _tmp4_;
	GMainContext* _tmp5_;
	GError* _tmp6_;
	gboolean _tmp10_;
	GError * _inner_error_ = NULL;
#line 231 "scores/context.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 231 "scores/context.vala"
	g_return_val_if_fail (score != NULL, FALSE);
#line 231 "scores/context.vala"
	g_return_val_if_fail (category != NULL, FALSE);
#line 231 "scores/context.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 231 "scores/context.vala"
	_data2_->_ref_count_ = 1;
#line 231 "scores/context.vala"
	_data2_->self = g_object_ref (self);
#line 233 "scores/context.vala"
	_tmp0_ = g_main_context_new ();
#line 233 "scores/context.vala"
	main_context = _tmp0_;
#line 234 "scores/context.vala"
	_tmp1_ = main_context;
#line 234 "scores/context.vala"
	_tmp2_ = g_main_loop_new (_tmp1_, FALSE);
#line 234 "scores/context.vala"
	_data2_->main_loop = _tmp2_;
#line 235 "scores/context.vala"
	_data2_->ret = FALSE;
#line 236 "scores/context.vala"
	_data2_->_error_ = NULL;
#line 238 "scores/context.vala"
	_tmp3_ = main_context;
#line 238 "scores/context.vala"
	g_main_context_push_thread_default (_tmp3_);
#line 239 "scores/context.vala"
	games_scores_context_add_score_internal (self, score, category, FALSE, NULL, ___lambda11__gasync_ready_callback, block2_data_ref (_data2_));
#line 250 "scores/context.vala"
	_tmp4_ = _data2_->main_loop;
#line 250 "scores/context.vala"
	g_main_loop_run (_tmp4_);
#line 251 "scores/context.vala"
	_tmp5_ = main_context;
#line 251 "scores/context.vala"
	g_main_context_pop_thread_default (_tmp5_);
#line 253 "scores/context.vala"
	_tmp6_ = _data2_->_error_;
#line 253 "scores/context.vala"
	if (_tmp6_ != NULL) {
#line 2468 "context.c"
		GError* _tmp7_;
		GError* _tmp8_;
		gboolean _tmp9_ = FALSE;
#line 254 "scores/context.vala"
		_tmp7_ = _data2_->_error_;
#line 254 "scores/context.vala"
		_tmp8_ = _g_error_copy0 (_tmp7_);
#line 254 "scores/context.vala"
		_inner_error_ = _tmp8_;
#line 254 "scores/context.vala"
		g_propagate_error (error, _inner_error_);
#line 254 "scores/context.vala"
		_g_main_context_unref0 (main_context);
#line 254 "scores/context.vala"
		block2_data_unref (_data2_);
#line 254 "scores/context.vala"
		_data2_ = NULL;
#line 254 "scores/context.vala"
		return _tmp9_;
#line 2488 "context.c"
	}
#line 255 "scores/context.vala"
	_tmp10_ = _data2_->ret;
#line 255 "scores/context.vala"
	result = _tmp10_;
#line 255 "scores/context.vala"
	_g_main_context_unref0 (main_context);
#line 255 "scores/context.vala"
	block2_data_unref (_data2_);
#line 255 "scores/context.vala"
	_data2_ = NULL;
#line 255 "scores/context.vala"
	return result;
#line 2502 "context.c"
}


static gchar*
g_file_stream_read_line (FILE* self)
{
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp6_;
#line 3643 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 3645 "glib-2.0.vapi"
	ret = NULL;
#line 3646 "glib-2.0.vapi"
	while (TRUE) {
#line 2519 "context.c"
		gint _tmp0_;
		GString* _tmp1_;
		gint _tmp3_;
		GString* _tmp4_;
		gint _tmp5_;
#line 3646 "glib-2.0.vapi"
		c = fgetc (self);
#line 3646 "glib-2.0.vapi"
		_tmp0_ = c;
#line 3646 "glib-2.0.vapi"
		if (!(_tmp0_ != EOF)) {
#line 3646 "glib-2.0.vapi"
			break;
#line 2533 "context.c"
		}
#line 3647 "glib-2.0.vapi"
		_tmp1_ = ret;
#line 3647 "glib-2.0.vapi"
		if (_tmp1_ == NULL) {
#line 2539 "context.c"
			GString* _tmp2_;
#line 3648 "glib-2.0.vapi"
			_tmp2_ = g_string_new ("");
#line 3648 "glib-2.0.vapi"
			_g_string_free0 (ret);
#line 3648 "glib-2.0.vapi"
			ret = _tmp2_;
#line 2547 "context.c"
		}
#line 3650 "glib-2.0.vapi"
		_tmp3_ = c;
#line 3650 "glib-2.0.vapi"
		if (_tmp3_ == ((gint) '\n')) {
#line 3651 "glib-2.0.vapi"
			break;
#line 2555 "context.c"
		}
#line 3653 "glib-2.0.vapi"
		_tmp4_ = ret;
#line 3653 "glib-2.0.vapi"
		_tmp5_ = c;
#line 3653 "glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp4_, (gchar) _tmp5_);
#line 2563 "context.c"
	}
#line 3655 "glib-2.0.vapi"
	_tmp6_ = ret;
#line 3655 "glib-2.0.vapi"
	if (_tmp6_ == NULL) {
#line 3656 "glib-2.0.vapi"
		result = NULL;
#line 3656 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 3656 "glib-2.0.vapi"
		return result;
#line 2575 "context.c"
	} else {
		GString* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 3658 "glib-2.0.vapi"
		_tmp7_ = ret;
#line 3658 "glib-2.0.vapi"
		_tmp8_ = ((GString*) _tmp7_)->str;
#line 3658 "glib-2.0.vapi"
		_tmp9_ = g_strdup (_tmp8_);
#line 3658 "glib-2.0.vapi"
		result = _tmp9_;
#line 3658 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 3658 "glib-2.0.vapi"
		return result;
#line 2592 "context.c"
	}
#line 3643 "glib-2.0.vapi"
	_g_string_free0 (ret);
#line 2596 "context.c"
}


static glong
long_parse (const gchar* str)
{
	glong result = 0L;
	glong _tmp0_;
#line 269 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0L);
#line 270 "glib-2.0.vapi"
	_tmp0_ = strtol (str, NULL, (guint) 0);
#line 270 "glib-2.0.vapi"
	result = _tmp0_;
#line 270 "glib-2.0.vapi"
	return result;
#line 2613 "context.c"
}


static gint64
int64_parse (const gchar* str)
{
	gint64 result = 0LL;
	gint64 _tmp0_;
#line 722 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 723 "glib-2.0.vapi"
	_tmp0_ = g_ascii_strtoll (str, NULL, (guint) 0);
#line 723 "glib-2.0.vapi"
	result = _tmp0_;
#line 723 "glib-2.0.vapi"
	return result;
#line 2630 "context.c"
}


static void
games_scores_context_load_scores_from_file (GamesScoresContext* self,
                                            GFileInfo* file_info,
                                            GError** error)
{
	gchar* category_key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GamesScoresCategory* category = NULL;
	GamesScoresContextCategoryRequestFunc _tmp2_;
	void* _tmp2__target;
	const gchar* _tmp3_;
	GamesScoresCategory* _tmp4_;
	GamesScoresCategory* _tmp5_;
	gchar* filename = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GeeArrayList* scores_of_single_category = NULL;
	GeeArrayList* _tmp9_;
	FILE* stream = NULL;
	const gchar* _tmp10_;
	FILE* _tmp11_;
	gchar* line = NULL;
	GeeHashMap* _tmp48_;
	GamesScoresCategory* _tmp49_;
	GeeArrayList* _tmp50_;
#line 258 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 258 "scores/context.vala"
	g_return_if_fail (file_info != NULL);
#line 260 "scores/context.vala"
	_tmp0_ = g_file_info_get_name (file_info);
#line 260 "scores/context.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 260 "scores/context.vala"
	category_key = _tmp1_;
#line 261 "scores/context.vala"
	_tmp2_ = self->priv->category_request;
#line 261 "scores/context.vala"
	_tmp2__target = self->priv->category_request_target;
#line 261 "scores/context.vala"
	_tmp3_ = category_key;
#line 261 "scores/context.vala"
	_tmp4_ = _tmp2_ (_tmp3_, _tmp2__target);
#line 261 "scores/context.vala"
	category = _tmp4_;
#line 262 "scores/context.vala"
	_tmp5_ = category;
#line 262 "scores/context.vala"
	if (_tmp5_ == NULL) {
#line 263 "scores/context.vala"
		_g_object_unref0 (category);
#line 263 "scores/context.vala"
		_g_free0 (category_key);
#line 263 "scores/context.vala"
		return;
#line 2691 "context.c"
	}
#line 265 "scores/context.vala"
	_tmp6_ = self->priv->user_score_dir;
#line 265 "scores/context.vala"
	_tmp7_ = category_key;
#line 265 "scores/context.vala"
	_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
#line 265 "scores/context.vala"
	filename = _tmp8_;
#line 266 "scores/context.vala"
	_tmp9_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 266 "scores/context.vala"
	scores_of_single_category = _tmp9_;
#line 267 "scores/context.vala"
	_tmp10_ = filename;
#line 267 "scores/context.vala"
	_tmp11_ = g_fopen (_tmp10_, "r");
#line 267 "scores/context.vala"
	stream = _tmp11_;
#line 269 "scores/context.vala"
	while (TRUE) {
#line 2713 "context.c"
		FILE* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar** tokens = NULL;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar* user = NULL;
		gchar** _tmp18_;
		gint _tmp18__length1;
		glong score_value = 0L;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gint64 time = 0LL;
		gchar** _tmp23_;
		gint _tmp23__length1;
		const gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		glong _tmp27_;
		gchar** _tmp36_;
		gint _tmp36__length1;
		GeeArrayList* _tmp42_;
		glong _tmp43_;
		gint64 _tmp44_;
		const gchar* _tmp45_;
		GamesScoresScore* _tmp46_;
		GamesScoresScore* _tmp47_;
#line 269 "scores/context.vala"
		_tmp12_ = stream;
#line 269 "scores/context.vala"
		_tmp13_ = g_file_stream_read_line (_tmp12_);
#line 269 "scores/context.vala"
		_g_free0 (line);
#line 269 "scores/context.vala"
		line = _tmp13_;
#line 269 "scores/context.vala"
		_tmp14_ = line;
#line 269 "scores/context.vala"
		if (!(_tmp14_ != NULL)) {
#line 269 "scores/context.vala"
			break;
#line 2759 "context.c"
		}
#line 271 "scores/context.vala"
		_tmp15_ = line;
#line 271 "scores/context.vala"
		_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, " ", 3);
#line 271 "scores/context.vala"
		tokens = _tmp17_;
#line 271 "scores/context.vala"
		tokens_length1 = _vala_array_length (_tmp16_);
#line 271 "scores/context.vala"
		_tokens_size_ = tokens_length1;
#line 272 "scores/context.vala"
		user = NULL;
#line 274 "scores/context.vala"
		_tmp18_ = tokens;
#line 274 "scores/context.vala"
		_tmp18__length1 = tokens_length1;
#line 274 "scores/context.vala"
		if (_tmp18__length1 < 2) {
#line 2779 "context.c"
			const gchar* _tmp19_;
			const gchar* _tmp20_;
#line 276 "scores/context.vala"
			_tmp19_ = line;
#line 276 "scores/context.vala"
			_tmp20_ = filename;
#line 276 "scores/context.vala"
			g_warning ("context.vala:276: Failed to read malformed score %s in %s.", _tmp19_, _tmp20_);
#line 277 "scores/context.vala"
			_g_free0 (user);
#line 277 "scores/context.vala"
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 277 "scores/context.vala"
			continue;
#line 2794 "context.c"
		}
#line 280 "scores/context.vala"
		_tmp21_ = tokens;
#line 280 "scores/context.vala"
		_tmp21__length1 = tokens_length1;
#line 280 "scores/context.vala"
		_tmp22_ = _tmp21_[0];
#line 280 "scores/context.vala"
		score_value = long_parse (_tmp22_);
#line 281 "scores/context.vala"
		_tmp23_ = tokens;
#line 281 "scores/context.vala"
		_tmp23__length1 = tokens_length1;
#line 281 "scores/context.vala"
		_tmp24_ = _tmp23_[1];
#line 281 "scores/context.vala"
		time = int64_parse (_tmp24_);
#line 283 "scores/context.vala"
		_tmp27_ = score_value;
#line 283 "scores/context.vala"
		if (_tmp27_ == ((glong) 0)) {
#line 2816 "context.c"
			gchar** _tmp28_;
			gint _tmp28__length1;
			const gchar* _tmp29_;
#line 283 "scores/context.vala"
			_tmp28_ = tokens;
#line 283 "scores/context.vala"
			_tmp28__length1 = tokens_length1;
#line 283 "scores/context.vala"
			_tmp29_ = _tmp28_[0];
#line 283 "scores/context.vala"
			_tmp26_ = g_strcmp0 (_tmp29_, "0") != 0;
#line 2828 "context.c"
		} else {
#line 283 "scores/context.vala"
			_tmp26_ = FALSE;
#line 2832 "context.c"
		}
#line 283 "scores/context.vala"
		if (_tmp26_) {
#line 283 "scores/context.vala"
			_tmp25_ = TRUE;
#line 2838 "context.c"
		} else {
			gboolean _tmp30_ = FALSE;
			gint64 _tmp31_;
#line 284 "scores/context.vala"
			_tmp31_ = time;
#line 284 "scores/context.vala"
			if (_tmp31_ == ((gint64) 0)) {
#line 2846 "context.c"
				gchar** _tmp32_;
				gint _tmp32__length1;
				const gchar* _tmp33_;
#line 284 "scores/context.vala"
				_tmp32_ = tokens;
#line 284 "scores/context.vala"
				_tmp32__length1 = tokens_length1;
#line 284 "scores/context.vala"
				_tmp33_ = _tmp32_[1];
#line 284 "scores/context.vala"
				_tmp30_ = g_strcmp0 (_tmp33_, "0") != 0;
#line 2858 "context.c"
			} else {
#line 284 "scores/context.vala"
				_tmp30_ = FALSE;
#line 2862 "context.c"
			}
#line 284 "scores/context.vala"
			_tmp25_ = _tmp30_;
#line 2866 "context.c"
		}
#line 283 "scores/context.vala"
		if (_tmp25_) {
#line 2870 "context.c"
			const gchar* _tmp34_;
			const gchar* _tmp35_;
#line 286 "scores/context.vala"
			_tmp34_ = line;
#line 286 "scores/context.vala"
			_tmp35_ = filename;
#line 286 "scores/context.vala"
			g_warning ("context.vala:286: Failed to read malformed score %s in %s.", _tmp34_, _tmp35_);
#line 287 "scores/context.vala"
			_g_free0 (user);
#line 287 "scores/context.vala"
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 287 "scores/context.vala"
			continue;
#line 2885 "context.c"
		}
#line 290 "scores/context.vala"
		_tmp36_ = tokens;
#line 290 "scores/context.vala"
		_tmp36__length1 = tokens_length1;
#line 290 "scores/context.vala"
		if (_tmp36__length1 == 3) {
#line 2893 "context.c"
			gchar** _tmp37_;
			gint _tmp37__length1;
			const gchar* _tmp38_;
			gchar* _tmp39_;
#line 291 "scores/context.vala"
			_tmp37_ = tokens;
#line 291 "scores/context.vala"
			_tmp37__length1 = tokens_length1;
#line 291 "scores/context.vala"
			_tmp38_ = _tmp37_[2];
#line 291 "scores/context.vala"
			_tmp39_ = g_strdup (_tmp38_);
#line 291 "scores/context.vala"
			_g_free0 (user);
#line 291 "scores/context.vala"
			user = _tmp39_;
#line 2910 "context.c"
		} else {
			const gchar* _tmp40_;
			const gchar* _tmp41_;
#line 293 "scores/context.vala"
			_tmp40_ = line;
#line 293 "scores/context.vala"
			_tmp41_ = filename;
#line 293 "scores/context.vala"
			g_debug ("context.vala:293: Assuming current username for old score %s in %s.", _tmp40_, _tmp41_);
#line 2920 "context.c"
		}
#line 295 "scores/context.vala"
		_tmp42_ = scores_of_single_category;
#line 295 "scores/context.vala"
		_tmp43_ = score_value;
#line 295 "scores/context.vala"
		_tmp44_ = time;
#line 295 "scores/context.vala"
		_tmp45_ = user;
#line 295 "scores/context.vala"
		_tmp46_ = games_scores_score_new (_tmp43_, _tmp44_, _tmp45_);
#line 295 "scores/context.vala"
		_tmp47_ = _tmp46_;
#line 295 "scores/context.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp47_);
#line 295 "scores/context.vala"
		_g_object_unref0 (_tmp47_);
#line 269 "scores/context.vala"
		_g_free0 (user);
#line 269 "scores/context.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 2942 "context.c"
	}
#line 298 "scores/context.vala"
	_tmp48_ = self->priv->scores_per_category;
#line 298 "scores/context.vala"
	_tmp49_ = category;
#line 298 "scores/context.vala"
	_tmp50_ = scores_of_single_category;
#line 298 "scores/context.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp48_, _tmp49_, (GeeList*) _tmp50_);
#line 258 "scores/context.vala"
	_g_free0 (line);
#line 258 "scores/context.vala"
	_fclose0 (stream);
#line 258 "scores/context.vala"
	_g_object_unref0 (scores_of_single_category);
#line 258 "scores/context.vala"
	_g_free0 (filename);
#line 258 "scores/context.vala"
	_g_object_unref0 (category);
#line 258 "scores/context.vala"
	_g_free0 (category_key);
#line 2964 "context.c"
}


static void
games_scores_context_load_scores_from_files (GamesScoresContext* self,
                                             GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkWindow* _tmp2_;
	GFile* directory = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp9_;
	GFileEnumerator* _tmp10_;
	GFileInfo* file_info = NULL;
	GError * _inner_error_ = NULL;
#line 301 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 301 "scores/context.vala"
	_tmp0_ = self->priv->scores_loaded;
#line 301 "scores/context.vala"
	_vala_return_if_fail (!_tmp0_, "!scores_loaded");
#line 304 "scores/context.vala"
	self->priv->scores_loaded = TRUE;
#line 306 "scores/context.vala"
	_tmp2_ = self->priv->_game_window;
#line 306 "scores/context.vala"
	if (_tmp2_ != NULL) {
#line 2996 "context.c"
		GtkWindow* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 306 "scores/context.vala"
		_tmp3_ = self->priv->_game_window;
#line 306 "scores/context.vala"
		_tmp4_ = gtk_widget_get_visible ((GtkWidget*) _tmp3_);
#line 306 "scores/context.vala"
		_tmp5_ = _tmp4_;
#line 306 "scores/context.vala"
		_tmp1_ = _tmp5_;
#line 3008 "context.c"
	} else {
#line 306 "scores/context.vala"
		_tmp1_ = FALSE;
#line 3012 "context.c"
	}
#line 306 "scores/context.vala"
	if (_tmp1_) {
#line 308 "scores/context.vala"
		g_error ("context.vala:308: %s", "The application window associated with the GamesScoresContext " "was set visible before loading scores. The Context performs " "synchronous I/O in the default main context to load scores, so " "so you should do this before showing your main window.");
#line 3018 "context.c"
	}
#line 314 "scores/context.vala"
	_tmp6_ = self->priv->user_score_dir;
#line 314 "scores/context.vala"
	_tmp7_ = g_file_new_for_path (_tmp6_);
#line 314 "scores/context.vala"
	directory = _tmp7_;
#line 315 "scores/context.vala"
	_tmp8_ = directory;
#line 315 "scores/context.vala"
	if (!g_file_query_exists (_tmp8_, NULL)) {
#line 316 "scores/context.vala"
		_g_object_unref0 (directory);
#line 316 "scores/context.vala"
		return;
#line 3034 "context.c"
	}
#line 318 "scores/context.vala"
	_tmp9_ = directory;
#line 318 "scores/context.vala"
	_tmp10_ = g_file_enumerate_children (_tmp9_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
#line 318 "scores/context.vala"
	enumerator = _tmp10_;
#line 318 "scores/context.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 318 "scores/context.vala"
		g_propagate_error (error, _inner_error_);
#line 318 "scores/context.vala"
		_g_object_unref0 (directory);
#line 318 "scores/context.vala"
		return;
#line 3050 "context.c"
	}
#line 320 "scores/context.vala"
	while (TRUE) {
#line 3054 "context.c"
		GFileInfo* _tmp11_ = NULL;
		GFileEnumerator* _tmp12_;
		GFileInfo* _tmp13_;
		GFileInfo* _tmp14_;
		GFileInfo* _tmp15_;
		GFileInfo* _tmp16_;
#line 320 "scores/context.vala"
		_tmp12_ = enumerator;
#line 320 "scores/context.vala"
		_tmp13_ = g_file_enumerator_next_file (_tmp12_, NULL, &_inner_error_);
#line 320 "scores/context.vala"
		_tmp11_ = _tmp13_;
#line 320 "scores/context.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 320 "scores/context.vala"
			g_propagate_error (error, _inner_error_);
#line 320 "scores/context.vala"
			_g_object_unref0 (file_info);
#line 320 "scores/context.vala"
			_g_object_unref0 (enumerator);
#line 320 "scores/context.vala"
			_g_object_unref0 (directory);
#line 320 "scores/context.vala"
			return;
#line 3079 "context.c"
		}
#line 320 "scores/context.vala"
		_tmp14_ = _tmp11_;
#line 320 "scores/context.vala"
		_tmp11_ = NULL;
#line 320 "scores/context.vala"
		_g_object_unref0 (file_info);
#line 320 "scores/context.vala"
		file_info = _tmp14_;
#line 320 "scores/context.vala"
		_tmp15_ = file_info;
#line 320 "scores/context.vala"
		if (!(_tmp15_ != NULL)) {
#line 320 "scores/context.vala"
			_g_object_unref0 (_tmp11_);
#line 320 "scores/context.vala"
			break;
#line 3097 "context.c"
		}
#line 322 "scores/context.vala"
		_tmp16_ = file_info;
#line 322 "scores/context.vala"
		games_scores_context_load_scores_from_file (self, _tmp16_, &_inner_error_);
#line 322 "scores/context.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 322 "scores/context.vala"
			g_propagate_error (error, _inner_error_);
#line 322 "scores/context.vala"
			_g_object_unref0 (_tmp11_);
#line 322 "scores/context.vala"
			_g_object_unref0 (file_info);
#line 322 "scores/context.vala"
			_g_object_unref0 (enumerator);
#line 322 "scores/context.vala"
			_g_object_unref0 (directory);
#line 322 "scores/context.vala"
			return;
#line 3117 "context.c"
		}
#line 320 "scores/context.vala"
		_g_object_unref0 (_tmp11_);
#line 3121 "context.c"
	}
#line 301 "scores/context.vala"
	_g_object_unref0 (file_info);
#line 301 "scores/context.vala"
	_g_object_unref0 (enumerator);
#line 301 "scores/context.vala"
	_g_object_unref0 (directory);
#line 3129 "context.c"
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 328 "scores/context.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 328 "scores/context.vala"
	return _data3_;
#line 3140 "context.c"
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 328 "scores/context.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 3151 "context.c"
		GamesScoresContext* self;
#line 328 "scores/context.vala"
		self = _data3_->self;
#line 328 "scores/context.vala"
		_g_object_unref0 (self);
#line 328 "scores/context.vala"
		g_slice_free (Block3Data, _data3_);
#line 3159 "context.c"
	}
}


static GamesScoresCategory*
__lambda12_ (Block3Data* _data3_,
             const gchar* key)
{
	GamesScoresContext* self;
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
#line 331 "scores/context.vala"
	self = _data3_->self;
#line 331 "scores/context.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 331 "scores/context.vala"
	_tmp0_ = _data3_->category_request (key, _data3_->category_request_target);
#line 331 "scores/context.vala"
	result = _tmp0_;
#line 331 "scores/context.vala"
	return result;
#line 3181 "context.c"
}


static GamesScoresCategory*
___lambda12__games_scores_context_category_request_func (const gchar* category_key,
                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda12_ (self, category_key);
#line 331 "scores/context.vala"
	return result;
#line 3193 "context.c"
}


void
games_scores_context_load_scores (GamesScoresContext* self,
                                  GamesScoresContextCategoryRequestFunc category_request,
                                  gpointer category_request_target,
                                  GError** error)
{
	GamesScoresContextCategoryRequestFunc _tmp0_;
	void* _tmp0__target;
	Block3Data* _data3_;
	GError * _inner_error_ = NULL;
#line 328 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 328 "scores/context.vala"
	_tmp0_ = self->priv->category_request;
#line 328 "scores/context.vala"
	_tmp0__target = self->priv->category_request_target;
#line 328 "scores/context.vala"
	_vala_return_if_fail (_tmp0_ == NULL, "this.category_request == null");
#line 328 "scores/context.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 328 "scores/context.vala"
	_data3_->_ref_count_ = 1;
#line 328 "scores/context.vala"
	_data3_->self = g_object_ref (self);
#line 328 "scores/context.vala"
	_data3_->category_request = category_request;
#line 328 "scores/context.vala"
	_data3_->category_request_target = category_request_target;
#line 331 "scores/context.vala"
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
#line 331 "scores/context.vala"
	self->priv->category_request = NULL;
#line 331 "scores/context.vala"
	self->priv->category_request_target = NULL;
#line 331 "scores/context.vala"
	self->priv->category_request_target_destroy_notify = NULL;
#line 331 "scores/context.vala"
	self->priv->category_request = ___lambda12__games_scores_context_category_request_func;
#line 331 "scores/context.vala"
	self->priv->category_request_target = block3_data_ref (_data3_);
#line 331 "scores/context.vala"
	self->priv->category_request_target_destroy_notify = block3_data_unref;
#line 332 "scores/context.vala"
	games_scores_context_load_scores_from_files (self, &_inner_error_);
#line 332 "scores/context.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 332 "scores/context.vala"
		g_propagate_error (error, _inner_error_);
#line 332 "scores/context.vala"
		block3_data_unref (_data3_);
#line 332 "scores/context.vala"
		_data3_ = NULL;
#line 332 "scores/context.vala"
		return;
#line 3251 "context.c"
	}
#line 328 "scores/context.vala"
	block3_data_unref (_data3_);
#line 328 "scores/context.vala"
	_data3_ = NULL;
#line 3257 "context.c"
}


void
games_scores_context_run_dialog_internal (GamesScoresContext* self,
                                          GamesScoresScore* new_high_score)
{
	GtkWindow* _tmp0_;
	GamesScoresDialog* dialog = NULL;
	const gchar* _tmp1_;
	GamesScoresStyle _tmp2_;
	GamesScoresCategory* _tmp3_;
	GtkWindow* _tmp4_;
	const gchar* _tmp5_;
	GamesScoresDialog* _tmp6_;
#line 335 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 335 "scores/context.vala"
	_tmp0_ = self->priv->_game_window;
#line 335 "scores/context.vala"
	_vala_return_if_fail (_tmp0_ != NULL, "game_window != null");
#line 338 "scores/context.vala"
	_tmp1_ = self->priv->_category_type;
#line 338 "scores/context.vala"
	_tmp2_ = self->priv->_style;
#line 338 "scores/context.vala"
	_tmp3_ = self->priv->current_category;
#line 338 "scores/context.vala"
	_tmp4_ = self->priv->_game_window;
#line 338 "scores/context.vala"
	_tmp5_ = self->priv->_app_name;
#line 338 "scores/context.vala"
	_tmp6_ = games_scores_dialog_new (self, _tmp1_, _tmp2_, new_high_score, _tmp3_, _tmp4_, _tmp5_);
#line 338 "scores/context.vala"
	g_object_ref_sink (_tmp6_);
#line 338 "scores/context.vala"
	dialog = _tmp6_;
#line 339 "scores/context.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 340 "scores/context.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 335 "scores/context.vala"
	_g_object_unref0 (dialog);
#line 3301 "context.c"
}


void
games_scores_context_run_dialog (GamesScoresContext* self)
{
#line 343 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 345 "scores/context.vala"
	games_scores_context_run_dialog_internal (self, NULL);
#line 3312 "context.c"
}


gboolean
games_scores_context_has_scores (GamesScoresContext* self)
{
	gboolean result = FALSE;
#line 348 "scores/context.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 3322 "context.c"
	{
		GeeIterator* _scores_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 350 "scores/context.vala"
		_tmp0_ = self->priv->scores_per_category;
#line 350 "scores/context.vala"
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
#line 350 "scores/context.vala"
		_tmp2_ = _tmp1_;
#line 350 "scores/context.vala"
		_tmp3_ = _tmp2_;
#line 350 "scores/context.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 350 "scores/context.vala"
		_tmp5_ = _tmp4_;
#line 350 "scores/context.vala"
		_g_object_unref0 (_tmp3_);
#line 350 "scores/context.vala"
		_scores_it = _tmp5_;
#line 350 "scores/context.vala"
		while (TRUE) {
#line 3349 "context.c"
			GeeIterator* _tmp6_;
			GeeList* scores = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
#line 350 "scores/context.vala"
			_tmp6_ = _scores_it;
#line 350 "scores/context.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 350 "scores/context.vala"
				break;
#line 3363 "context.c"
			}
#line 350 "scores/context.vala"
			_tmp7_ = _scores_it;
#line 350 "scores/context.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 350 "scores/context.vala"
			scores = (GeeList*) _tmp8_;
#line 352 "scores/context.vala"
			_tmp9_ = scores;
#line 352 "scores/context.vala"
			_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
#line 352 "scores/context.vala"
			_tmp11_ = _tmp10_;
#line 352 "scores/context.vala"
			if (_tmp11_ > 0) {
#line 353 "scores/context.vala"
				result = TRUE;
#line 353 "scores/context.vala"
				_g_object_unref0 (scores);
#line 353 "scores/context.vala"
				_g_object_unref0 (_scores_it);
#line 353 "scores/context.vala"
				return result;
#line 3387 "context.c"
			}
#line 350 "scores/context.vala"
			_g_object_unref0 (scores);
#line 3391 "context.c"
		}
#line 350 "scores/context.vala"
		_g_object_unref0 (_scores_it);
#line 3395 "context.c"
	}
#line 355 "scores/context.vala"
	result = FALSE;
#line 355 "scores/context.vala"
	return result;
#line 3401 "context.c"
}


const gchar*
games_scores_context_get_app_name (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 35 "scores/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "scores/context.vala"
	_tmp0_ = self->priv->_app_name;
#line 35 "scores/context.vala"
	result = _tmp0_;
#line 35 "scores/context.vala"
	return result;
#line 3418 "context.c"
}


static void
games_scores_context_set_app_name (GamesScoresContext* self,
                                   const gchar* value)
{
#line 35 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 35 "scores/context.vala"
	if (g_strcmp0 (value, games_scores_context_get_app_name (self)) != 0) {
#line 3430 "context.c"
		gchar* _tmp0_;
#line 35 "scores/context.vala"
		_tmp0_ = g_strdup (value);
#line 35 "scores/context.vala"
		_g_free0 (self->priv->_app_name);
#line 35 "scores/context.vala"
		self->priv->_app_name = _tmp0_;
#line 35 "scores/context.vala"
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY]);
#line 3440 "context.c"
	}
}


const gchar*
games_scores_context_get_category_type (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 36 "scores/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "scores/context.vala"
	_tmp0_ = self->priv->_category_type;
#line 36 "scores/context.vala"
	result = _tmp0_;
#line 36 "scores/context.vala"
	return result;
#line 3458 "context.c"
}


static void
games_scores_context_set_category_type (GamesScoresContext* self,
                                        const gchar* value)
{
#line 36 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 36 "scores/context.vala"
	if (g_strcmp0 (value, games_scores_context_get_category_type (self)) != 0) {
#line 3470 "context.c"
		gchar* _tmp0_;
#line 36 "scores/context.vala"
		_tmp0_ = g_strdup (value);
#line 36 "scores/context.vala"
		_g_free0 (self->priv->_category_type);
#line 36 "scores/context.vala"
		self->priv->_category_type = _tmp0_;
#line 36 "scores/context.vala"
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY]);
#line 3480 "context.c"
	}
}


GtkWindow*
games_scores_context_get_game_window (GamesScoresContext* self)
{
	GtkWindow* result;
	GtkWindow* _tmp0_;
#line 37 "scores/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "scores/context.vala"
	_tmp0_ = self->priv->_game_window;
#line 37 "scores/context.vala"
	result = _tmp0_;
#line 37 "scores/context.vala"
	return result;
#line 3498 "context.c"
}


static void
games_scores_context_set_game_window (GamesScoresContext* self,
                                      GtkWindow* value)
{
#line 37 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 37 "scores/context.vala"
	if (games_scores_context_get_game_window (self) != value) {
#line 3510 "context.c"
		GtkWindow* _tmp0_;
#line 37 "scores/context.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 37 "scores/context.vala"
		_g_object_unref0 (self->priv->_game_window);
#line 37 "scores/context.vala"
		self->priv->_game_window = _tmp0_;
#line 37 "scores/context.vala"
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY]);
#line 3520 "context.c"
	}
}


GamesScoresStyle
games_scores_context_get_style (GamesScoresContext* self)
{
	GamesScoresStyle result;
	GamesScoresStyle _tmp0_;
#line 38 "scores/context.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 38 "scores/context.vala"
	_tmp0_ = self->priv->_style;
#line 38 "scores/context.vala"
	result = _tmp0_;
#line 38 "scores/context.vala"
	return result;
#line 3538 "context.c"
}


static void
games_scores_context_set_style (GamesScoresContext* self,
                                GamesScoresStyle value)
{
#line 38 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 38 "scores/context.vala"
	if (games_scores_context_get_style (self) != value) {
#line 38 "scores/context.vala"
		self->priv->_style = value;
#line 38 "scores/context.vala"
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_STYLE_PROPERTY]);
#line 3554 "context.c"
	}
}


GamesScoresImporter*
games_scores_context_get_importer (GamesScoresContext* self)
{
	GamesScoresImporter* result;
	GamesScoresImporter* _tmp0_;
#line 39 "scores/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "scores/context.vala"
	_tmp0_ = self->priv->_importer;
#line 39 "scores/context.vala"
	result = _tmp0_;
#line 39 "scores/context.vala"
	return result;
#line 3572 "context.c"
}


static void
games_scores_context_set_importer (GamesScoresContext* self,
                                   GamesScoresImporter* value)
{
#line 39 "scores/context.vala"
	g_return_if_fail (self != NULL);
#line 39 "scores/context.vala"
	if (games_scores_context_get_importer (self) != value) {
#line 3584 "context.c"
		GamesScoresImporter* _tmp0_;
#line 39 "scores/context.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 39 "scores/context.vala"
		_g_object_unref0 (self->priv->_importer);
#line 39 "scores/context.vala"
		self->priv->_importer = _tmp0_;
#line 39 "scores/context.vala"
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY]);
#line 3594 "context.c"
	}
}


static void
games_scores_context_base_init (GamesScoresContextClass * klass)
{
#line 66 "scores/context.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 67 "scores/context.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 3606 "context.c"
}


static void
games_scores_context_class_init (GamesScoresContextClass * klass)
{
#line 33 "scores/context.vala"
	games_scores_context_parent_class = g_type_class_peek_parent (klass);
#line 33 "scores/context.vala"
	g_type_class_adjust_private_offset (klass, &GamesScoresContext_private_offset);
#line 33 "scores/context.vala"
	((GObjectClass *) klass)->constructed = (void (*) (GObject *)) games_scores_context_real_constructed;
#line 33 "scores/context.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_games_scores_context_get_property;
#line 33 "scores/context.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_games_scores_context_set_property;
#line 33 "scores/context.vala"
	G_OBJECT_CLASS (klass)->finalize = games_scores_context_finalize;
#line 33 "scores/context.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 33 "scores/context.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY] = g_param_spec_string ("category-type", "category-type", "category-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 33 "scores/context.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY] = g_param_spec_object ("game-window", "game-window", "game-window", gtk_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 33 "scores/context.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_STYLE_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_STYLE_PROPERTY] = g_param_spec_enum ("style", "style", "style", GAMES_SCORES_TYPE_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 33 "scores/context.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY] = g_param_spec_object ("importer", "importer", "importer", GAMES_SCORES_TYPE_IMPORTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 43 "scores/context.vala"
	games_scores_context_category_hash = __games_scores_context_category_hash_lambda4__gee_hash_data_func;
#line 46 "scores/context.vala"
	games_scores_context_category_equal = __games_scores_context_category_equal_lambda5__gee_equal_data_func;
#line 3639 "context.c"
}


static void
games_scores_context_instance_init (GamesScoresContext * self)
{
	GeeHashDataFunc _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeEqualDataFunc _tmp1_;
	void* _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeHashMap* _tmp2_;
#line 33 "scores/context.vala"
	self->priv = games_scores_context_get_instance_private (self);
#line 41 "scores/context.vala"
	self->priv->current_category = NULL;
#line 49 "scores/context.vala"
	_tmp0_ = games_scores_context_category_hash;
#line 49 "scores/context.vala"
	_tmp0__target = games_scores_context_category_hash_target;
#line 49 "scores/context.vala"
	_tmp0__target_destroy_notify = games_scores_context_category_hash_target_destroy_notify;
#line 49 "scores/context.vala"
	games_scores_context_category_hash = NULL;
#line 49 "scores/context.vala"
	games_scores_context_category_hash_target = NULL;
#line 49 "scores/context.vala"
	games_scores_context_category_hash_target_destroy_notify = NULL;
#line 49 "scores/context.vala"
	_tmp1_ = games_scores_context_category_equal;
#line 49 "scores/context.vala"
	_tmp1__target = games_scores_context_category_equal_target;
#line 49 "scores/context.vala"
	_tmp1__target_destroy_notify = games_scores_context_category_equal_target_destroy_notify;
#line 49 "scores/context.vala"
	games_scores_context_category_equal = NULL;
#line 49 "scores/context.vala"
	games_scores_context_category_equal_target = NULL;
#line 49 "scores/context.vala"
	games_scores_context_category_equal_target_destroy_notify = NULL;
#line 49 "scores/context.vala"
	_tmp2_ = gee_hash_map_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify, NULL, NULL, NULL);
#line 49 "scores/context.vala"
	self->priv->scores_per_category = _tmp2_;
#line 53 "scores/context.vala"
	self->priv->scores_loaded = FALSE;
#line 62 "scores/context.vala"
	self->priv->category_request = NULL;
#line 62 "scores/context.vala"
	self->priv->category_request_target = self;
#line 62 "scores/context.vala"
	self->priv->category_request_target_destroy_notify = NULL;
#line 3693 "context.c"
}


static void
games_scores_context_finalize (GObject * obj)
{
	GamesScoresContext * self;
#line 33 "scores/context.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
#line 35 "scores/context.vala"
	_g_free0 (self->priv->_app_name);
#line 36 "scores/context.vala"
	_g_free0 (self->priv->_category_type);
#line 37 "scores/context.vala"
	_g_object_unref0 (self->priv->_game_window);
#line 39 "scores/context.vala"
	_g_object_unref0 (self->priv->_importer);
#line 41 "scores/context.vala"
	_g_object_unref0 (self->priv->current_category);
#line 49 "scores/context.vala"
	_g_object_unref0 (self->priv->scores_per_category);
#line 52 "scores/context.vala"
	_g_free0 (self->priv->user_score_dir);
#line 62 "scores/context.vala"
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
#line 62 "scores/context.vala"
	self->priv->category_request = NULL;
#line 62 "scores/context.vala"
	self->priv->category_request_target = NULL;
#line 62 "scores/context.vala"
	self->priv->category_request_target_destroy_notify = NULL;
#line 33 "scores/context.vala"
	G_OBJECT_CLASS (games_scores_context_parent_class)->finalize (obj);
#line 3727 "context.c"
}


GType
games_scores_context_get_type (void)
{
	static volatile gsize games_scores_context_type_id__volatile = 0;
	if (g_once_init_enter (&games_scores_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesScoresContextClass), (GBaseInitFunc) games_scores_context_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresContext), 0, (GInstanceInitFunc) games_scores_context_instance_init, NULL };
		GType games_scores_context_type_id;
		games_scores_context_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesScoresContext", &g_define_type_info, 0);
		GamesScoresContext_private_offset = g_type_add_instance_private (games_scores_context_type_id, sizeof (GamesScoresContextPrivate));
		g_once_init_leave (&games_scores_context_type_id__volatile, games_scores_context_type_id);
	}
	return games_scores_context_type_id__volatile;
}


static void
_vala_games_scores_context_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
#line 33 "scores/context.vala"
	switch (property_id) {
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY:
#line 33 "scores/context.vala"
		g_value_set_string (value, games_scores_context_get_app_name (self));
#line 33 "scores/context.vala"
		break;
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY:
#line 33 "scores/context.vala"
		g_value_set_string (value, games_scores_context_get_category_type (self));
#line 33 "scores/context.vala"
		break;
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY:
#line 33 "scores/context.vala"
		g_value_set_object (value, games_scores_context_get_game_window (self));
#line 33 "scores/context.vala"
		break;
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_STYLE_PROPERTY:
#line 33 "scores/context.vala"
		g_value_set_enum (value, games_scores_context_get_style (self));
#line 33 "scores/context.vala"
		break;
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY:
#line 33 "scores/context.vala"
		g_value_set_object (value, games_scores_context_get_importer (self));
#line 33 "scores/context.vala"
		break;
#line 3786 "context.c"
		default:
#line 33 "scores/context.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "scores/context.vala"
		break;
#line 3792 "context.c"
	}
}


static void
_vala_games_scores_context_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
#line 33 "scores/context.vala"
	switch (property_id) {
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY:
#line 33 "scores/context.vala"
		games_scores_context_set_app_name (self, g_value_get_string (value));
#line 33 "scores/context.vala"
		break;
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY:
#line 33 "scores/context.vala"
		games_scores_context_set_category_type (self, g_value_get_string (value));
#line 33 "scores/context.vala"
		break;
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY:
#line 33 "scores/context.vala"
		games_scores_context_set_game_window (self, g_value_get_object (value));
#line 33 "scores/context.vala"
		break;
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_STYLE_PROPERTY:
#line 33 "scores/context.vala"
		games_scores_context_set_style (self, g_value_get_enum (value));
#line 33 "scores/context.vala"
		break;
#line 33 "scores/context.vala"
		case GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY:
#line 33 "scores/context.vala"
		games_scores_context_set_importer (self, g_value_get_object (value));
#line 33 "scores/context.vala"
		break;
#line 3837 "context.c"
		default:
#line 33 "scores/context.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "scores/context.vala"
		break;
#line 3843 "context.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



