var NAVTREE =
[
  [ "libgphoto2 photo camera library (libgphoto2) API", "index.html", [
    [ "Related Pages", "pages.html", [
      [ "Deprecated List", "deprecated.html", null ]
    ] ],
    [ "Data Structures", "annotated.html", [
      [ "_Camera", "struct__Camera.html", null ],
      [ "_CameraAbilitiesList", "struct__CameraAbilitiesList.html", null ],
      [ "_CameraFile", "struct__CameraFile.html", null ],
      [ "_CameraFileHandler", "struct__CameraFileHandler.html", null ],
      [ "_CameraFileInfo", "struct__CameraFileInfo.html", null ],
      [ "_CameraFileInfoAudio", "struct__CameraFileInfoAudio.html", null ],
      [ "_CameraFileInfoFile", "struct__CameraFileInfoFile.html", null ],
      [ "_CameraFileInfoPreview", "struct__CameraFileInfoPreview.html", null ],
      [ "_CameraFilesystem", "struct__CameraFilesystem.html", null ],
      [ "_CameraFilesystemFile", "struct__CameraFilesystemFile.html", null ],
      [ "_CameraFilesystemFolder", "struct__CameraFilesystemFolder.html", null ],
      [ "_CameraFilesystemFuncs", "struct__CameraFilesystemFuncs.html", null ],
      [ "_CameraFunctions", "struct__CameraFunctions.html", null ],
      [ "_CameraList", "struct__CameraList.html", null ],
      [ "_CameraPrivateCore", "struct__CameraPrivateCore.html", null ],
      [ "_CameraStorageInformation", "struct__CameraStorageInformation.html", null ],
      [ "_CameraWidget", "struct__CameraWidget.html", null ],
      [ "_entry", "struct__entry.html", null ],
      [ "_GPContext", "struct__GPContext.html", null ],
      [ "_GPPort", "struct__GPPort.html", null ],
      [ "_GPPortInfo", "struct__GPPortInfo.html", null ],
      [ "_GPPortInfoList", "struct__GPPortInfoList.html", null ],
      [ "_GPPortOperations", "struct__GPPortOperations.html", null ],
      [ "_GPPortPrivateCore", "struct__GPPortPrivateCore.html", null ],
      [ "_GPPortSettings", "union__GPPortSettings.html", null ],
      [ "_GPPortSettingsSerial", "struct__GPPortSettingsSerial.html", null ],
      [ "_GPPortSettingsUSB", "struct__GPPortSettingsUSB.html", null ],
      [ "_GPPortSettingsUsbDiskDirect", "struct__GPPortSettingsUsbDiskDirect.html", null ],
      [ "_GPPortSettingsUsbScsi", "struct__GPPortSettingsUsbScsi.html", null ],
      [ "CameraAbilities", "structCameraAbilities.html", null ],
      [ "CameraFile", "structCameraFile.html", null ],
      [ "CameraFilePath", "structCameraFilePath.html", null ],
      [ "CameraText", "structCameraText.html", null ],
      [ "chunk", "structchunk.html", null ],
      [ "exif_parser", "structexif__parser.html", null ],
      [ "ExifData", "structExifData.html", null ],
      [ "foreach_data_t", "structforeach__data__t.html", null ],
      [ "jpeg", "structjpeg.html", null ],
      [ "LogFunc", "structLogFunc.html", null ],
      [ "Setting", "structSetting.html", null ]
    ] ],
    [ "Data Structure Index", "classes.html", null ],
    [ "Data Fields", "functions.html", null ],
    [ "File List", "files.html", [
      [ "camlibs/template/template.c", "template_8c.html", null ],
      [ "gphoto2/gphoto2-abilities-list.h", "gphoto2-abilities-list_8h.html", null ],
      [ "gphoto2/gphoto2-camera.h", "gphoto2-camera_8h.html", null ],
      [ "gphoto2/gphoto2-context.h", "gphoto2-context_8h.html", null ],
      [ "gphoto2/gphoto2-file.h", "gphoto2-file_8h.html", null ],
      [ "gphoto2/gphoto2-filesys.h", "gphoto2-filesys_8h.html", null ],
      [ "gphoto2/gphoto2-library.h", "gphoto2-library_8h.html", null ],
      [ "gphoto2/gphoto2-list.h", "gphoto2-list_8h.html", null ],
      [ "gphoto2/gphoto2-result.h", "gphoto2-result_8h.html", null ],
      [ "gphoto2/gphoto2-setting.h", "gphoto2-setting_8h.html", null ],
      [ "gphoto2/gphoto2-version.h", "gphoto2-version_8h.html", null ],
      [ "gphoto2/gphoto2-widget.h", "gphoto2-widget_8h.html", null ],
      [ "gphoto2/gphoto2.h", "gphoto2_8h.html", null ],
      [ "libgphoto2/_stdint.h", null, null ],
      [ "libgphoto2/ahd_bayer.c", "ahd__bayer_8c.html", null ],
      [ "libgphoto2/bayer.c", "bayer_8c.html", null ],
      [ "libgphoto2/bayer.h", "bayer_8h.html", null ],
      [ "libgphoto2/exif.c", "exif_8c.html", null ],
      [ "libgphoto2/exif.h", "exif_8h.html", null ],
      [ "libgphoto2/gamma.c", "gamma_8c.html", null ],
      [ "libgphoto2/gamma.h", "gamma_8h.html", null ],
      [ "libgphoto2/gphoto2-abilities-list.c", "gphoto2-abilities-list_8c.html", null ],
      [ "libgphoto2/gphoto2-camera.c", "gphoto2-camera_8c.html", null ],
      [ "libgphoto2/gphoto2-context.c", "gphoto2-context_8c.html", null ],
      [ "libgphoto2/gphoto2-endian.h", null, null ],
      [ "libgphoto2/gphoto2-file.c", "gphoto2-file_8c.html", null ],
      [ "libgphoto2/gphoto2-filesys.c", "gphoto2-filesys_8c.html", null ],
      [ "libgphoto2/gphoto2-library.c", "gphoto2-library_8c.html", null ],
      [ "libgphoto2/gphoto2-list.c", "gphoto2-list_8c.html", null ],
      [ "libgphoto2/gphoto2-result.c", "gphoto2-result_8c.html", null ],
      [ "libgphoto2/gphoto2-setting.c", "gphoto2-setting_8c.html", null ],
      [ "libgphoto2/gphoto2-version.c", "gphoto2-version_8c.html", null ],
      [ "libgphoto2/gphoto2-widget.c", "gphoto2-widget_8c.html", null ],
      [ "libgphoto2/jpeg.c", "jpeg_8c.html", null ],
      [ "libgphoto2/jpeg.h", "jpeg_8h.html", null ],
      [ "libgphoto2_port/gphoto2/gphoto2-port-info-list.h", "gphoto2-port-info-list_8h.html", null ],
      [ "libgphoto2_port/gphoto2/gphoto2-port-library.h", "gphoto2-port-library_8h.html", null ],
      [ "libgphoto2_port/gphoto2/gphoto2-port-log.h", "gphoto2-port-log_8h.html", null ],
      [ "libgphoto2_port/gphoto2/gphoto2-port-portability.h", "gphoto2-port-portability_8h.html", null ],
      [ "libgphoto2_port/gphoto2/gphoto2-port-result.h", "gphoto2-port-result_8h.html", null ],
      [ "libgphoto2_port/gphoto2/gphoto2-port-version.h", "gphoto2-port-version_8h.html", null ],
      [ "libgphoto2_port/gphoto2/gphoto2-port.h", "gphoto2-port_8h.html", null ],
      [ "libgphoto2_port/libgphoto2_port/gphoto2-port-info-list.c", "gphoto2-port-info-list_8c.html", null ],
      [ "libgphoto2_port/libgphoto2_port/gphoto2-port-info.h", "gphoto2-port-info_8h.html", null ],
      [ "libgphoto2_port/libgphoto2_port/gphoto2-port-log.c", "gphoto2-port-log_8c.html", null ],
      [ "libgphoto2_port/libgphoto2_port/gphoto2-port-portability.c", "gphoto2-port-portability_8c.html", null ],
      [ "libgphoto2_port/libgphoto2_port/gphoto2-port-result.c", "gphoto2-port-result_8c.html", null ],
      [ "libgphoto2_port/libgphoto2_port/gphoto2-port-version.c", "gphoto2-port-version_8c.html", null ],
      [ "libgphoto2_port/libgphoto2_port/gphoto2-port.c", "gphoto2-port_8c.html", null ]
    ] ],
    [ "Directories", "dirs.html", [
      [ "camlibs", "dir_877c88313a52070a838f6ed1a44e0b14.html", [
        [ "template", "dir_860dd5bca5f3bd619ce8c1c470b3cd70.html", null ]
      ] ],
      [ "gphoto2", "dir_186123d7f06f7847aa8e2feb33e15bd5.html", null ],
      [ "libgphoto2", "dir_60c21775b61714dc27d7c95fd5f538ff.html", null ],
      [ "libgphoto2_port", "dir_5ea97c592dda5b96c12b9e2106c72836.html", [
        [ "gphoto2", "dir_cc502d2dd1f17d247dd16aff37f90d03.html", null ],
        [ "libgphoto2_port", "dir_cda7eec3a35e3a7261471f3ede043665.html", null ]
      ] ]
    ] ],
    [ "Globals", "globals.html", null ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

