#ifndef INCLUDED_BASE64_H
#define INCLUDED_BASE64_H

//
// base64encoder and base64decoder
//
// A template implementation of base64 according to RFC 1113
//
// (c) 2003 by mixter@hacktivismo.com
//
// Distributed according to the terms of the
// Hacktivismo Enhanced-Source Software License,
// Version 0.1, or any higher version at your choice
// http://www.hacktivismo.com/hessla.html
//

#include <vector>
#include <utility>
#include <cassert>
#include <cmath>
#include <iterator>

using namespace std;

#define RFC1113_COMPLIANT

namespace leobase {

template <class InputIterator, class OutputIterator> class base64encoder
{
  enum { LINE_MAX_SIZE = 76 };
  typedef InputIterator cast_val;
  cast_val encoder;

public:
  base64encoder() : encoder((cast_val)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/") {}

  // Returns the number of bytes written, in case anyone cares.
  int
  operator()(InputIterator begin, InputIterator end, OutputIterator out)
  {
  	register int bc = 0, fin = 0, col = 0;

	while(((begin+bc) < end) && !fin)
	{
	 (begin+bc) >= end ? fin++ : 0;
	 (begin+bc+1) >= end ? fin++ : 0;
	 (begin+bc+2) >= end ? fin++ : 0;

	 *out++ = encoder[begin[bc]>>2];
	 *out++ = encoder[((begin[bc]&0x03)<<4) | ((begin[bc+1]&0xf0)>>4)];
	 *out++ = ((fin<2) ? encoder[((begin[bc+1]&0x0f)<<2) | ((begin[bc+2]&0xc0)>>6)] : '=');
	 *out++ = ((fin<1) ? encoder[begin[bc+2]&0x3f] : '=');

	 !fin ? bc += 3 : 0;

	 if(!((col += 4) % LINE_MAX_SIZE))
	 {
#ifdef	RFC1113_COMPLIANT
	  *out++ = '\r';
#endif
	  *out++ = '\n';
	 }
	}

        *out++ = '\0';

#ifdef	RFC1113_COMPLIANT
	return (col + ((col/LINE_MAX_SIZE) * 2));
#else
	return (col + (col/LINE_MAX_SIZE));
#endif
  }
};

template <class InputIterator, class OutputIterator> class base64decoder
{
  typedef InputIterator cast_val;
  cast_val decoder;

  template<typename T> T conv64(T *b64atom, int &bc)
  {
   // Is it inside the base64 charset? If so, decode.
   T atom = ((b64atom[bc] < 43 || b64atom[bc] > 122) ? 0 : decoder[ b64atom[bc] - 43 ]);
   // Skip decoded non-base64
   atom = atom ? ((atom == '.') ? 0 : atom - 61) : 0;
   atom ? atom-- : atom = conv64(b64atom, ++bc);
   return atom;
  }

  public:
  base64decoder() : decoder((cast_val)"|...}rstuvwxyz{.......>?@ABCDEFGHIJKLMNOPQRSTUVW......XYZ[\\]^_`abcdefghijklmnopq") {}

  void operator()(InputIterator begin, InputIterator end, OutputIterator out)
  {
   register int bc=0;

   while((begin+bc) < end)
   {
    if(begin+bc+1 < end)
     *out++ = (conv64(begin,bc) << 2 | conv64(begin+1,bc) >> 4);
     
    if(begin+bc+2 < end)
     *out++ = (conv64(begin+1,bc) << 4 | conv64(begin+2,bc) >> 2);
     
    if(begin+bc+3 < end)
     *out++ = (((conv64(begin+2,bc) << 6) & 0xc0) | conv64(begin+3,bc));

    bc += 4;
   }
  }
};

#endif // INCLUDED_BASE64_H
