# libmypaint - MyPaint brush engine library

[![Translation Status](https://hosted.weblate.org/widgets/mypaint/libmypaint/svg-badge.svg)](https://hosted.weblate.org/engage/mypaint/?utm_source=widget)
[![Travis Build Status](https://travis-ci.org/mypaint/libmypaint.svg?branch=master)](https://travis-ci.org/mypaint/libmypaint)
[![Appveyor Build Status](https://ci.appveyor.com/api/projects/status/github/mypaint/libmypaint?branch=master&svg=true)](https://ci.appveyor.com/project/jonnor/libmypaint)

This is the brush library used by MyPaint. A number of other painting
programs use it too.

License: ISC, see [COPYING](./COPYING) for details.

## Dependencies

* All configurations and builds:
  - [json-c](https://github.com/json-c/json-c/wiki) (>= 0.11)
  - C compiler, `make` etc.
* Most configurations (all except `--disable-introspection --without-glib`):
  - [GObject-Introspection](https://live.gnome.org/GObjectIntrospection)
  - [GLib](https://wiki.gnome.org/Projects/GLib)
* When building from `git`:
  - [Python](http://python.org/)
  - [autotools](https://en.wikipedia.org/wiki/GNU_Build_System)
  - [intltool](https://freedesktop.org/wiki/Software/intltool/)
* For `--enable-gegl` (GIMP *does not* require this):
  - [GEGL + BABL](http://gegl.org/)

On recent Debian-like systems, you can type the following
to get started with a standard configuration:

    $ sudo apt install build-essential
    $ sudo apt install libjson-c-dev libjson-c-dev libglib2.0-dev
    $ sudo apt install python2 autotools intltool    # Building from git

## Build and install

The traditional setup works just fine.

    $ ./autogen.sh    # Only needed when building from git.
    $ ./configure
    $ make install

### Maintainer mode

We don't ship a `configure` script in our git repository. If you're
building from git, you have to kickstart the build environment with:

    $ ./autogen.sh

This script generates `configure` from `configure.ac`, after running a
few checks to make sure your build environment is broadly OK. It also
regenerates certain important generated headers if they need it.

Folks building from a release tarball don't need to do this: they will
have a `configure` script from the start.

### Configure

    $ ./configure
    $ ./configure --prefix=/tmp/junk/example

There are several MyPaint-specific options.
These can be shown by running

    $ ./configure --help

### Build

    $ make

Once MyPaint is built, you can run the test suite and/or install it.

### Test

    $ make check

This runs all the unit tests.

### Install

    $ make install

Uninstall libmypaint with `make uninstall`.

## Contributing

The MyPaint project welcomes and encourages participation by everyone.
We want our community to be skilled and diverse,
and we want it to be a community that anybody can feel good about joining.
No matter who you are or what your background is, we welcome you.

Please note that MyPaint is released with a
[Contributor Code of Conduct](CODE_OF_CONDUCT.md).
By participating in this project you agree to abide by its terms.

Please see the file [CONTRIBUTING.md](CONTRIBUTING.md)
for details of how you can begin contributing.

## Making releases

The distribution release can be generated with:

    $ make dist

And it should be checked before public release with:

    $ make distcheck

## Localization

Contribute translations here: <https://hosted.weblate.org/engage/mypaint/>.

The list of languages is maintained in [po/LINGUAS](po/LINGUAS).
Currently this file lists all the languages we have translations for.
It can be regenerated with:

    $ ls po/*.po | sed 's$^.*po/\([^.]*\).po$\1$' | sort > po/LINGUAS

You can also disable languages by removing them from the list if needed.

A list of files where localizable strings can be found is maintained
in `po/POTFILES.in`.

### Strings update

You can update the .po files when translated strings in the code change
using:

    $ cd po && make update-po

When the results of this are pushed, Weblate translators will see the
new strings immediately.

## Documentation

Further documentation can be found in the libmypaint wiki:
<https://github.com/mypaint/libmypaint/wiki>.
