/*
Copyright (c) 2014, Ronnie Sahlberg
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer. 
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies, 
either expressed or implied, of the FreeBSD Project.
*/

/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "libnfs-zdr.h"
#include "libnfs-raw-rquota.h"

uint32_t
zdr_rquotastat (ZDR *zdrs, rquotastat *objp)
{
	register int32_t *buf;
	buf = NULL;

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_exportpath (ZDR *zdrs, exportpath *objp)
{
	register int32_t *buf;
	buf = NULL;

	 if (!zdr_string (zdrs, objp, RQUOTAPATHLEN))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETQUOTA1args (ZDR *zdrs, GETQUOTA1args *objp)
{
	register int32_t *buf;
	buf = NULL;

	 if (!zdr_exportpath (zdrs, &objp->export))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->uid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_quotatype (ZDR *zdrs, quotatype *objp)
{
	register int32_t *buf;
	buf = NULL;

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETQUOTA2args (ZDR *zdrs, GETQUOTA2args *objp)
{
	register int32_t *buf;
	buf = NULL;

	 if (!zdr_exportpath (zdrs, &objp->export))
		 return FALSE;
	 if (!zdr_quotatype (zdrs, &objp->type))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->uid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETQUOTA1res_ok (ZDR *zdrs, GETQUOTA1res_ok *objp)
{
	register int32_t *buf;
	buf = NULL;


	if (zdrs->x_op == ZDR_ENCODE) {
		buf = ZDR_INLINE (zdrs, 10 * BYTES_PER_ZDR_UNIT);
		if (buf == NULL) {
			 if (!zdr_int (zdrs, &objp->bsize))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->active))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->bhardlimit))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->bsoftlimit))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->curblocks))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->fhardlimit))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->fsoftlimit))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->curfiles))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->btimeleft))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->ftimeleft))
				 return FALSE;
		} else {
			IZDR_PUT_LONG(buf, objp->bsize);
			IZDR_PUT_LONG(buf, objp->active);
			IZDR_PUT_LONG(buf, objp->bhardlimit);
			IZDR_PUT_LONG(buf, objp->bsoftlimit);
			IZDR_PUT_LONG(buf, objp->curblocks);
			IZDR_PUT_LONG(buf, objp->fhardlimit);
			IZDR_PUT_LONG(buf, objp->fsoftlimit);
			IZDR_PUT_LONG(buf, objp->curfiles);
			IZDR_PUT_LONG(buf, objp->btimeleft);
			IZDR_PUT_LONG(buf, objp->ftimeleft);
		}
		return TRUE;
	} else if (zdrs->x_op == ZDR_DECODE) {
		buf = ZDR_INLINE (zdrs, 10 * BYTES_PER_ZDR_UNIT);
		if (buf == NULL) {
			 if (!zdr_int (zdrs, &objp->bsize))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->active))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->bhardlimit))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->bsoftlimit))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->curblocks))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->fhardlimit))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->fsoftlimit))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->curfiles))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->btimeleft))
				 return FALSE;
			 if (!zdr_int (zdrs, &objp->ftimeleft))
				 return FALSE;
		} else {
			objp->bsize = IZDR_GET_LONG(buf);
			objp->active = IZDR_GET_LONG(buf);
			objp->bhardlimit = IZDR_GET_LONG(buf);
			objp->bsoftlimit = IZDR_GET_LONG(buf);
			objp->curblocks = IZDR_GET_LONG(buf);
			objp->fhardlimit = IZDR_GET_LONG(buf);
			objp->fsoftlimit = IZDR_GET_LONG(buf);
			objp->curfiles = IZDR_GET_LONG(buf);
			objp->btimeleft = IZDR_GET_LONG(buf);
			objp->ftimeleft = IZDR_GET_LONG(buf);
		}
	 return TRUE;
	}

	 if (!zdr_int (zdrs, &objp->bsize))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->active))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->bhardlimit))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->bsoftlimit))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->curblocks))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->fhardlimit))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->fsoftlimit))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->curfiles))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->btimeleft))
		 return FALSE;
	 if (!zdr_int (zdrs, &objp->ftimeleft))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETQUOTA1res (ZDR *zdrs, GETQUOTA1res *objp)
{
	register int32_t *buf;
	buf = NULL;

	 if (!zdr_rquotastat (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case RQUOTA_OK:
		 if (!zdr_GETQUOTA1res_ok (zdrs, &objp->GETQUOTA1res_u.quota))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}
