/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* libodfgen
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2003 William Lachance (wrlach@gmail.com)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#include "FilterInternal.hxx"

#include "FontStyle.hxx"

#include "DocumentElement.hxx"

FontStyle::FontStyle(const char *psName, const char *psFontFamily) : Style(psName, Style::Z_Font),
	msFontFamily()
{
	msFontFamily.appendEscapedXML(psFontFamily);
}

FontStyle::~FontStyle()
{
}

void FontStyle::write(OdfDocumentHandler *pHandler) const
{
	TagOpenElement styleOpen("style:font-face");
	styleOpen.addAttribute("style:name", getName());
	styleOpen.addAttribute("svg:font-family", msFontFamily);
	styleOpen.write(pHandler);
	TagCloseElement styleClose("style:font-face");
	styleClose.write(pHandler);
}

void FontStyleManager::clean()
{
	mStyleHash.clear();
}

void FontStyleManager::write(OdfDocumentHandler *pHandler, Style::Zone zone) const
{
	std::map<librevenge::RVNGString, shared_ptr<FontStyle> >::const_iterator iter;
	for (iter = mStyleHash.begin(); iter != mStyleHash.end(); ++iter)
	{
		if (iter->second->getZone()==zone)
			(iter->second)->write(pHandler);
	}

	if (zone!=Style::Z_Font)
		return;
	TagOpenElement symbolFontOpen("style:font-face");
	symbolFontOpen.addAttribute("style:name", "StarSymbol");
	symbolFontOpen.addAttribute("svg:font-family", "StarSymbol");
	symbolFontOpen.addAttribute("style:font-charset", "x-symbol");
	symbolFontOpen.write(pHandler);
	pHandler->endElement("style:font-face");
}

librevenge::RVNGString FontStyleManager::findOrAdd(const char *psFontFamily)
{
	std::map<librevenge::RVNGString, shared_ptr<FontStyle> >::const_iterator iter =
	    mStyleHash.find(psFontFamily);
	if (iter!=mStyleHash.end()) return psFontFamily;

	// ok create a new font
	shared_ptr<FontStyle> font(new FontStyle(psFontFamily, psFontFamily));
	mStyleHash[psFontFamily] = font;
	return psFontFamily;
}

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
