/*
 * Decompiled with CFR 0.152.
 */
package intel.rssdk;

import intel.rssdk.PXCMBase;
import intel.rssdk.PXCMImage;
import intel.rssdk.PXCMPoint3DF32;
import intel.rssdk.PXCMSizeI32;
import intel.rssdk.pxcmStatus;

public class PXCM3DScan
extends PXCMBase {
    public static final int CUID = 826884947;

    private static native void PXCM3DScan_QueryConfiguration(long var0, Configuration var2);

    private static native pxcmStatus PXCM3DScan_SetConfiguration(long var0, Configuration var2);

    private static native long PXCM3DScan_AcquirePreviewImage(long var0);

    private static native pxcmStatus PXCM3DScan_Reconstruct(long var0, FileFormat var2, String var3);

    private static native boolean PXCM3DScan_IsScanning(long var0);

    public Configuration QueryConfiguration() {
        Configuration configuration = new Configuration();
        PXCM3DScan.PXCM3DScan_QueryConfiguration(this.instance, configuration);
        return configuration;
    }

    public pxcmStatus SetConfiguration(Configuration configuration) {
        return PXCM3DScan.PXCM3DScan_SetConfiguration(this.instance, configuration);
    }

    public PXCMImage AcquirePreviewImage() {
        long l = PXCM3DScan.PXCM3DScan_AcquirePreviewImage(this.instance);
        if (l == 0L) {
            return null;
        }
        return new PXCMImage(l, true);
    }

    public boolean IsScanning() {
        return PXCM3DScan.PXCM3DScan_IsScanning(this.instance);
    }

    public pxcmStatus Reconstruct(FileFormat fileFormat, String string) {
        return PXCM3DScan.PXCM3DScan_Reconstruct(this.instance, fileFormat, string);
    }

    public static String FileFormatToString(FileFormat fileFormat) {
        switch (fileFormat) {
            case OBJ: {
                return "obj";
            }
            case PLY: {
                return "ply";
            }
            case STL: {
                return "stl";
            }
        }
        return "Unknown";
    }

    PXCM3DScan(long l, boolean bl) {
        super(l, bl);
    }

    public static class Configuration {
        int min_frames_before_scan_start = 2;
        ScanningMode mode = ScanningMode.VARIABLE;
        ReconstructionOption options = ReconstructionOption.NONE;
        PXCMPoint3DF32[] scanningVolumeBoundingBox = new PXCMPoint3DF32[2];
        int[] scanningVolumeResolution = new int[3];
        PXCMSizeI32 textureResolution = new PXCMSizeI32(2048, 2048);
        int targetTriangles = 0;
    }

    public static enum ReconstructionOption {
        NONE,
        SOLIDIFICATION,
        TEXTURE;

    }

    public static enum FileFormat {
        OBJ,
        PLY,
        STL;

    }

    public static enum ScanningMode {
        VARIABLE,
        OBJECT_ON_PLANAR_SURFACE_DETECTION,
        FACE,
        HEAD,
        BODY;

    }
}

