/*
 * Decompiled with CFR 0.152.
 */
package intel.rssdk;

import intel.rssdk.PXCMBase;
import intel.rssdk.pxcmStatus;
import java.util.EnumSet;

public class PXCMAudio
extends PXCMBase {
    public static final int CUID = 962214344;

    private static native void PXCMAudio_QueryInfo(long var0, AudioInfo var2);

    private static native EnumSet<Option> PXCMAudio_QueryOptions(long var0);

    private static native void PXCMAudio_SetOptions(long var0, EnumSet<Option> var2);

    private static native long PXCMAudio_QueryTimeStamp(long var0);

    private static native void PXCMAudio_SetTimeStamp(long var0, long var2);

    private static native pxcmStatus PXCMAudio_CopyAudio(long var0, PXCMAudio var2);

    private static native pxcmStatus PXCMAudio_AcquireAccess(long var0, Access var2, int var3, int var4, AudioData var5);

    private static native pxcmStatus PXCMAudio_ReleaseAccess(long var0, AudioData var2);

    private static native void PXCMAudio_Release(long var0);

    public static String AudioFormatToString(AudioFormat audioFormat) {
        switch (audioFormat) {
            case AUDIO_FORMAT_PCM: {
                return "PCM";
            }
            case AUDIO_FORMAT_IEEE_FLOAT: {
                return "Float";
            }
        }
        return "Unknown";
    }

    public static int AudioFormatToSize(AudioFormat audioFormat) {
        return (audioFormat.value & 0xFF) >> 3;
    }

    public AudioInfo QueryInfo() {
        AudioInfo audioInfo = new AudioInfo();
        PXCMAudio.PXCMAudio_QueryInfo(this.instance, audioInfo);
        return audioInfo;
    }

    public EnumSet<Option> QueryOptions() {
        return PXCMAudio.PXCMAudio_QueryOptions(this.instance);
    }

    public void SetOptions(EnumSet<Option> enumSet) {
        PXCMAudio.PXCMAudio_SetOptions(this.instance, enumSet);
    }

    public long QueryTimeStamp() {
        return PXCMAudio.PXCMAudio_QueryTimeStamp(this.instance);
    }

    public void SetTimeStamp(long l) {
        PXCMAudio.PXCMAudio_SetTimeStamp(this.instance, l);
    }

    public pxcmStatus CopyAudio(PXCMAudio pXCMAudio) {
        return PXCMAudio.PXCMAudio_CopyAudio(this.instance, pXCMAudio);
    }

    public pxcmStatus AcquireAccess(Access access, AudioFormat audioFormat, Option option, AudioData audioData) {
        return PXCMAudio.PXCMAudio_AcquireAccess(this.instance, access, audioFormat.value, option.value, audioData);
    }

    public pxcmStatus AcquireAccess(Access access, AudioFormat audioFormat, AudioData audioData) {
        return this.AcquireAccess(access, audioFormat, Option.OPTION_ANY, audioData);
    }

    public pxcmStatus AcquireAccess(Access access, AudioData audioData) {
        return this.AcquireAccess(access, AudioFormat.AUDIO_FORMAT_PCM, Option.OPTION_ANY, audioData);
    }

    public pxcmStatus ReleaseAccess(AudioData audioData) {
        return PXCMAudio.PXCMAudio_ReleaseAccess(this.instance, audioData);
    }

    @Override
    public void close() {
        super.close();
    }

    public PXCMAudio() {
        super(0L, true);
    }

    public PXCMAudio(long l, boolean bl) {
        super(l, bl);
    }

    public static enum Access {
        ACCESS_READ,
        ACCESS_WRITE,
        ACCESS_READ_WRITE;

    }

    public static class AudioData {
        public AudioFormat format;
        public int dataSize;
        public long dataPtr;
        public long nativeRef;

        private static native byte[] PXCMAudio_AudioData_ToByteArray(long var0, byte[] var2);

        private static native short[] PXCMAudio_AudioData_ToShortArray(long var0, short[] var2);

        private static native int[] PXCMAudio_AudioData_ToIntArray(long var0, int[] var2);

        private static native float[] PXCMAudio_AudioData_ToFloatArray(long var0, float[] var2);

        private static native void PXCMAudio_AudioData_FromByteArray(long var0, byte[] var2);

        private static native void PXCMAudio_AudioData_FromShortArray(long var0, short[] var2);

        private static native void PXCMAudio_AudioData_FromFloatArray(long var0, float[] var2);

        public byte[] ToByteArray(byte[] byArray) {
            return AudioData.PXCMAudio_AudioData_ToByteArray(this.nativeRef, byArray);
        }

        public byte[] ToByteArray(int n) {
            byte[] byArray = new byte[n];
            AudioData.PXCMAudio_AudioData_ToByteArray(this.nativeRef, byArray);
            return byArray;
        }

        public short[] ToShortArray(short[] sArray) {
            return AudioData.PXCMAudio_AudioData_ToShortArray(this.nativeRef, sArray);
        }

        public short[] ToShortArray(int n) {
            short[] sArray = new short[n];
            AudioData.PXCMAudio_AudioData_ToShortArray(this.nativeRef, sArray);
            return sArray;
        }

        public int[] ToIntArray(int[] nArray) {
            AudioData.PXCMAudio_AudioData_ToIntArray(this.nativeRef, nArray);
            return nArray;
        }

        public int[] ToIntArray(int n) {
            int[] nArray = new int[n];
            AudioData.PXCMAudio_AudioData_ToIntArray(this.nativeRef, nArray);
            return nArray;
        }

        public float[] ToFloatArray(float[] fArray) {
            return AudioData.PXCMAudio_AudioData_ToFloatArray(this.nativeRef, fArray);
        }

        public float[] ToByeArray(int n) {
            float[] fArray = new float[n];
            AudioData.PXCMAudio_AudioData_ToFloatArray(this.nativeRef, fArray);
            return fArray;
        }

        public void FromByteArray(byte[] byArray) {
            AudioData.PXCMAudio_AudioData_FromByteArray(this.nativeRef, byArray);
        }

        public void FromShortArray(short[] sArray) {
            AudioData.PXCMAudio_AudioData_FromShortArray(this.nativeRef, sArray);
        }

        public void FromFloatArray(float[] fArray) {
            AudioData.PXCMAudio_AudioData_FromFloatArray(this.nativeRef, fArray);
        }
    }

    public static class AudioInfo {
        public int bufferSize;
        public AudioFormat format = AudioFormat.AUDIO_FORMAT_PCM;
        public int sampleRate;
        public int nchannels;
        public EnumSet<ChannelMask> channelMask = EnumSet.noneOf(ChannelMask.class);
    }

    public static enum Option {
        OPTION_ANY(0);

        public final int value;

        private Option(int n2) {
            this.value = n2;
        }
    }

    public static enum ChannelMask {
        CHANNEL_MASK_FRONT_LEFT(1),
        CHANNEL_MASK_FRONT_RIGHT(2),
        CHANNEL_MASK_FRONT_CENTER(4),
        CHANNEL_MASK_LOW_FREQUENCY(8),
        CHANNEL_MASK_BACK_LEFT(16),
        CHANNEL_MASK_BACK_RIGHT(32),
        CHANNEL_MASK_SIDE_LEFT(512),
        CHANNEL_MASK_SIDE_RIGHT(1024);

        public final int value;

        private ChannelMask(int n2) {
            this.value = n2;
        }
    }

    public static enum AudioFormat {
        AUDIO_FORMAT_PCM(1296257040, "PCM"),
        AUDIO_FORMAT_IEEE_FLOAT(1414284832, "Float");

        public final int value;
        public final String name;

        private AudioFormat(int n2, String string2) {
            this.value = n2;
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public int toSize() {
            return (this.value & 0xFF) >> 3;
        }
    }
}

