/*
 * Decompiled with CFR 0.152.
 */
package intel.rssdk;

import intel.rssdk.PXCMBase;
import intel.rssdk.PXCMBoxedData;
import intel.rssdk.PXCMImage;
import intel.rssdk.PXCMPointF32;
import intel.rssdk.PXCMProjection;
import intel.rssdk.PXCMRangeF32;
import intel.rssdk.PXCMSyncPoint;
import intel.rssdk.pxcmStatus;
import java.util.EnumSet;

public class PXCMCapture
extends PXCMBase {
    public static final int CUID = -2080953776;
    public static final int STREAM_LIMIT = 8;
    public static final int PROPERTY_VALUE_INVALID = Short.MAX_VALUE;

    private static native int PXCMCapture_QueryDeviceNum(long var0);

    private static native pxcmStatus PXCMCapture_QueryDeviceInfo(long var0, int var2, DeviceInfo var3);

    private static native long PXCMCapture_CreateDevice(long var0, int var2);

    public int QueryDeviceNum() {
        return PXCMCapture.PXCMCapture_QueryDeviceNum(this.instance);
    }

    public pxcmStatus QueryDeviceInfo(int n, DeviceInfo deviceInfo) {
        return PXCMCapture.PXCMCapture_QueryDeviceInfo(this.instance, n, deviceInfo);
    }

    public Device CreateDevice(int n) {
        long l = PXCMCapture.PXCMCapture_CreateDevice(this.instance, n);
        if (l == 0L) {
            return null;
        }
        return new Device(l, true);
    }

    public static String StreamTypeToString(StreamType streamType) {
        switch (streamType) {
            case STREAM_TYPE_COLOR: {
                return "Color";
            }
            case STREAM_TYPE_DEPTH: {
                return "Depth";
            }
            case STREAM_TYPE_IR: {
                return "IR";
            }
            case STREAM_TYPE_LEFT: {
                return "Left";
            }
            case STREAM_TYPE_RIGHT: {
                return "Right";
            }
        }
        return "Unknown";
    }

    public static StreamType StreamTypeFromIndex(int n) {
        for (StreamType streamType : StreamType.values()) {
            if (streamType.value != 1 << n) continue;
            return streamType;
        }
        return StreamType.STREAM_TYPE_ANY;
    }

    public static int StreamTypeToIndex(StreamType streamType) {
        int n = streamType.value;
        int n2 = 0;
        while (n > 1) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    public PXCMCapture() {
        super(0L, true);
    }

    PXCMCapture(long l, boolean bl) {
        super(l, bl);
    }

    public static class Device
    extends PXCMBase {
        public static final int CUID = -1820065340;

        private static native void PXCMCapture_Device_QueryDeviceInfo(long var0, DeviceInfo var2);

        private static native int PXCMCapture_Device_QueryStreamProfileSetNum(long var0, StreamType var2);

        private static native pxcmStatus PXCMCapture_Device_QueryStreamProfileSet(long var0, StreamType var2, int var3, StreamProfileSet var4);

        private static native boolean PXCMCapture_Device_IsStreamProfileSetValid(long var0, StreamProfileSet var2);

        private static native pxcmStatus PXCMCapture_Device_SetStreamProfileSet(long var0, StreamProfileSet var2);

        private static native pxcmStatus PXCMCapture_Device_QueryProperty(long var0, Property var2, PXCMBoxedData var3);

        private static native pxcmStatus PXCMCapture_Device_QueryPropertyInfo(long var0, Property var2, PropertyInfo var3);

        private static native pxcmStatus PXCMCapture_Device_QueryPropertyPoint(long var0, Property var2, PXCMPointF32 var3);

        private static native pxcmStatus PXCMCapture_Device_QueryPropertyRange(long var0, Property var2, PXCMRangeF32 var3);

        private static native boolean PXCMCapture_Device_QueryPropertyAuto(long var0, Property var2);

        private static native pxcmStatus PXCMCapture_Device_SetPropertyAuto(long var0, Property var2, boolean var3);

        private static native pxcmStatus PXCMCapture_Device_SetProperty(long var0, Property var2, float var3);

        private static native pxcmStatus PXCMCapture_Device_SetPropertyRange(long var0, Property var2, PXCMRangeF32 var3);

        private static native long PXCMCapture_Device_CreateProjection(long var0);

        private static native pxcmStatus PXCMCapture_Device_ReadStreamsAsync(long var0, StreamType var2, long[] var3, PXCMBoxedData var4);

        private static native void PXCMCapture_Device_ResetProperties(long var0, StreamType var2);

        private static native void PXCMCapture_Device_RestorePropertiesUponFocus(long var0);

        public void QueryDeviceInfo(DeviceInfo deviceInfo) {
            Device.PXCMCapture_Device_QueryDeviceInfo(this.instance, deviceInfo);
        }

        public int QueryStreamProfileSetNum(StreamType streamType) {
            return Device.PXCMCapture_Device_QueryStreamProfileSetNum(this.instance, streamType);
        }

        public pxcmStatus QueryStreamProfileSet(StreamType streamType, int n, StreamProfileSet streamProfileSet) {
            return Device.PXCMCapture_Device_QueryStreamProfileSet(this.instance, streamType, n, streamProfileSet);
        }

        public pxcmStatus QueryStreamProfileSet(StreamProfileSet streamProfileSet) {
            return this.QueryStreamProfileSet(StreamType.STREAM_TYPE_ANY, -1, streamProfileSet);
        }

        public boolean IsStreamProfileSetValid(StreamProfileSet streamProfileSet) {
            return Device.PXCMCapture_Device_IsStreamProfileSetValid(this.instance, streamProfileSet);
        }

        public pxcmStatus SetStreamProfileSet(StreamProfileSet streamProfileSet) {
            return Device.PXCMCapture_Device_SetStreamProfileSet(this.instance, streamProfileSet);
        }

        public pxcmStatus ReadStreamsAsync(StreamType streamType, Sample sample, PXCMSyncPoint pXCMSyncPoint) {
            PXCMBoxedData pXCMBoxedData = new PXCMBoxedData();
            long[] lArray = new long[8];
            for (int i = 0; i < 8; ++i) {
                lArray[i] = 0L;
            }
            pxcmStatus pxcmStatus2 = Device.PXCMCapture_Device_ReadStreamsAsync(this.instance, streamType, lArray, pXCMBoxedData);
            if (pxcmStatus2.compareTo(pxcmStatus.PXCM_STATUS_NO_ERROR) >= 0) {
                if (pXCMSyncPoint != null) {
                    pXCMSyncPoint.ResetInstance(pXCMBoxedData.longValue);
                    pXCMSyncPoint.AddRef();
                }
                if (sample != null) {
                    if (lArray[0] != 0L && sample.color != null) {
                        sample.color.ResetInstance(lArray[0]);
                        sample.color.AddRef();
                    }
                    if (lArray[1] != 0L && sample.depth != null) {
                        sample.depth.ResetInstance(lArray[1]);
                        sample.depth.AddRef();
                    }
                    if (lArray[2] != 0L && sample.ir != null) {
                        sample.ir.ResetInstance(lArray[2]);
                        sample.ir.AddRef();
                    }
                    for (int i = 0; i < 5; ++i) {
                        if (lArray[i + 3] == 0L || sample.reserved[i] == null) continue;
                        sample.reserved[i].ResetInstance(lArray[i + 3]);
                        sample.reserved[i].AddRef();
                    }
                }
            }
            return pxcmStatus2;
        }

        public pxcmStatus ReadStreamsAsync(Sample sample, PXCMSyncPoint pXCMSyncPoint) {
            return this.ReadStreamsAsync(StreamType.STREAM_TYPE_ANY, sample, pXCMSyncPoint);
        }

        public pxcmStatus ReadStreams(StreamType streamType, Sample sample) {
            PXCMSyncPoint pXCMSyncPoint = new PXCMSyncPoint();
            pxcmStatus pxcmStatus2 = this.ReadStreamsAsync(streamType, sample, pXCMSyncPoint);
            if (pxcmStatus2.compareTo(pxcmStatus.PXCM_STATUS_NO_ERROR) >= 0) {
                return pxcmStatus2;
            }
            pxcmStatus2 = pXCMSyncPoint.Synchronize(0);
            pXCMSyncPoint.close();
            return pxcmStatus2;
        }

        private float QueryProperty(Property property) {
            PXCMBoxedData pXCMBoxedData = new PXCMBoxedData();
            pxcmStatus pxcmStatus2 = Device.PXCMCapture_Device_QueryProperty(this.instance, property, pXCMBoxedData);
            if (pxcmStatus2.compareTo(pxcmStatus.PXCM_STATUS_NO_ERROR) >= 0) {
                return pXCMBoxedData.floatValue;
            }
            return 0.0f;
        }

        private pxcmStatus QueryProperty(Property property, PXCMPointF32 pXCMPointF32) {
            return Device.PXCMCapture_Device_QueryPropertyPoint(this.instance, property, pXCMPointF32);
        }

        private pxcmStatus QueryProperty(Property property, PXCMRangeF32 pXCMRangeF32) {
            return Device.PXCMCapture_Device_QueryPropertyRange(this.instance, property, pXCMRangeF32);
        }

        private pxcmStatus QueryPropertyInfo(Property property, PropertyInfo propertyInfo) {
            return Device.PXCMCapture_Device_QueryPropertyInfo(this.instance, property, propertyInfo);
        }

        private boolean QueryPropertyAuto(Property property) {
            return Device.PXCMCapture_Device_QueryPropertyAuto(this.instance, property);
        }

        private pxcmStatus SetPropertyAuto(Property property, boolean bl) {
            return Device.PXCMCapture_Device_SetPropertyAuto(this.instance, property, bl);
        }

        private pxcmStatus SetProperty(Property property, float f) {
            return Device.PXCMCapture_Device_SetProperty(this.instance, property, f);
        }

        private pxcmStatus SetProperty(Property property, int n) {
            return Device.PXCMCapture_Device_SetProperty(this.instance, property, n);
        }

        private pxcmStatus SetProperty(Property property, short s) {
            return Device.PXCMCapture_Device_SetProperty(this.instance, property, s);
        }

        private pxcmStatus SetProperty(Property property, boolean bl) {
            return Device.PXCMCapture_Device_SetProperty(this.instance, property, bl ? 1.0f : 0.0f);
        }

        public PXCMProjection CreateProjection() {
            long l = Device.PXCMCapture_Device_CreateProjection(this.instance);
            if (l != 0L) {
                return new PXCMProjection(l, true);
            }
            return null;
        }

        public void ResetProperties(StreamType streamType) {
            Device.PXCMCapture_Device_ResetProperties(this.instance, streamType);
        }

        public void RestorePropertiesUponFocus() {
            Device.PXCMCapture_Device_RestorePropertiesUponFocus(this.instance);
        }

        public int QueryColorExposure() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_EXPOSURE);
        }

        public PropertyInfo QueryColorExposureInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_EXPOSURE, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorExposure(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_EXPOSURE, (float)n);
        }

        public boolean QueryColorAutoExposure() {
            return this.QueryPropertyAuto(Property.PROPERTY_COLOR_EXPOSURE);
        }

        public pxcmStatus SetColorAutoExposure(boolean bl) {
            return this.SetPropertyAuto(Property.PROPERTY_COLOR_EXPOSURE, bl);
        }

        public int QueryColorBrightness() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_BRIGHTNESS);
        }

        public PropertyInfo QueryColorBrightnessInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_BRIGHTNESS, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorBrightness(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_BRIGHTNESS, (float)n);
        }

        public int QueryColorContrast() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_CONTRAST);
        }

        public PropertyInfo QueryColorContrastInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_CONTRAST, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorContrast(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_CONTRAST, (float)n);
        }

        public int QueryColorSaturation() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_SATURATION);
        }

        public PropertyInfo QueryColorSaturationInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_SATURATION, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorSaturation(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_SATURATION, (float)n);
        }

        public int QueryColorHue() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_HUE);
        }

        public PropertyInfo QueryColorHueInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_HUE, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorHue(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_HUE, (float)n);
        }

        public int QueryColorGamma() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_GAMMA);
        }

        public PropertyInfo QueryColorGammaInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_GAMMA, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorGamma(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_GAMMA, (float)n);
        }

        public int QueryColorWhiteBalance() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_WHITE_BALANCE);
        }

        public PropertyInfo QueryColorWhiteBalanceInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_WHITE_BALANCE, propertyInfo);
            return propertyInfo;
        }

        public boolean QueryColorAutoWhiteBalance() {
            return this.QueryPropertyAuto(Property.PROPERTY_COLOR_WHITE_BALANCE);
        }

        public pxcmStatus SetColorWhiteBalance(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_WHITE_BALANCE, (float)n);
        }

        public pxcmStatus SetColorAutoWhiteBalance(boolean bl) {
            return this.SetPropertyAuto(Property.PROPERTY_COLOR_WHITE_BALANCE, bl);
        }

        public int QueryColorSharpness() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_SHARPNESS);
        }

        public PropertyInfo QueryColorSharpnessInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_SHARPNESS, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorSharpness(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_SHARPNESS, (float)n);
        }

        public boolean QueryColorBackLightCompensation() {
            float f = this.QueryProperty(Property.PROPERTY_COLOR_BACK_LIGHT_COMPENSATION);
            return f != 0.0f;
        }

        public PropertyInfo QueryColorBackLightCompensationInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_BACK_LIGHT_COMPENSATION, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorBackLightCompensation(boolean bl) {
            return this.SetProperty(Property.PROPERTY_COLOR_BACK_LIGHT_COMPENSATION, bl ? 1 : 0);
        }

        public int QueryColorGain() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_GAIN);
        }

        public PropertyInfo QueryColorGainInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_GAIN, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetColorGain(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_GAIN, (float)n);
        }

        public int QueryColorPowerLineFrequency() {
            return (int)this.QueryProperty(Property.PROPERTY_COLOR_POWER_LINE_FREQUENCY);
        }

        public pxcmStatus SetColorPowerLineFrequency(int n) {
            return this.SetProperty(Property.PROPERTY_COLOR_POWER_LINE_FREQUENCY, (float)n);
        }

        public pxcmStatus SetColorAutoPowerLineFrequency(boolean bl) {
            return this.SetPropertyAuto(Property.PROPERTY_COLOR_POWER_LINE_FREQUENCY, bl);
        }

        public PowerLineFrequency QueryColorPowerLineFrequencyDefaultValue() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_COLOR_POWER_LINE_FREQUENCY, propertyInfo);
            return PowerLineFrequency.values()[(int)propertyInfo.defaultValue];
        }

        public boolean QueryColorAutoPowerLineFrequency() {
            return this.QueryPropertyAuto(Property.PROPERTY_COLOR_POWER_LINE_FREQUENCY);
        }

        public PXCMPointF32 QueryColorFieldOfView() {
            PXCMPointF32 pXCMPointF32 = new PXCMPointF32();
            this.QueryProperty(Property.PROPERTY_COLOR_FIELD_OF_VIEW, pXCMPointF32);
            return pXCMPointF32;
        }

        public PXCMPointF32 QueryColorFocalLength() {
            PXCMPointF32 pXCMPointF32 = new PXCMPointF32();
            this.QueryProperty(Property.PROPERTY_COLOR_FOCAL_LENGTH, pXCMPointF32);
            return pXCMPointF32;
        }

        public float QueryColorFocalLengthMM() {
            return this.QueryProperty(Property.PROPERTY_COLOR_FOCAL_LENGTH_MM);
        }

        public PXCMPointF32 QueryColorPrincipalPoint() {
            PXCMPointF32 pXCMPointF32 = new PXCMPointF32();
            this.QueryProperty(Property.PROPERTY_COLOR_PRINCIPAL_POINT, pXCMPointF32);
            return pXCMPointF32;
        }

        public int QueryDepthLowConfidenceValue() {
            return (int)this.QueryProperty(Property.PROPERTY_DEPTH_LOW_CONFIDENCE_VALUE);
        }

        public int QueryDepthConfidenceThreshold() {
            return (int)this.QueryProperty(Property.PROPERTY_DEPTH_CONFIDENCE_THRESHOLD);
        }

        public PropertyInfo QueryDepthConfidenceThresholdInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_DEPTH_CONFIDENCE_THRESHOLD, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetDepthConfidenceThreshold(int n) {
            return this.SetProperty(Property.PROPERTY_DEPTH_CONFIDENCE_THRESHOLD, (float)n);
        }

        public int QueryDepthUnit() {
            return (int)this.QueryProperty(Property.PROPERTY_DEPTH_UNIT);
        }

        public pxcmStatus SetDepthUnit(float f) {
            return this.SetProperty(Property.PROPERTY_DEPTH_UNIT, f);
        }

        public PXCMPointF32 QueryDepthFieldOfView() {
            PXCMPointF32 pXCMPointF32 = new PXCMPointF32();
            this.QueryProperty(Property.PROPERTY_DEPTH_FIELD_OF_VIEW, pXCMPointF32);
            return pXCMPointF32;
        }

        public PXCMPointF32 QueryDepthFocalLength() {
            PXCMPointF32 pXCMPointF32 = new PXCMPointF32();
            this.QueryProperty(Property.PROPERTY_DEPTH_FOCAL_LENGTH, pXCMPointF32);
            return pXCMPointF32;
        }

        public float QueryDepthFocalLengthMM() {
            return this.QueryProperty(Property.PROPERTY_DEPTH_FOCAL_LENGTH_MM);
        }

        public PXCMPointF32 QueryDepthPrincipalPoint() {
            PXCMPointF32 pXCMPointF32 = new PXCMPointF32();
            this.QueryProperty(Property.PROPERTY_DEPTH_PRINCIPAL_POINT, pXCMPointF32);
            return pXCMPointF32;
        }

        public boolean QueryDeviceAllowProfileChange() {
            float f = this.QueryProperty(Property.PROPERTY_DEVICE_ALLOW_PROFILE_CHANGE);
            return f != 0.0f;
        }

        public pxcmStatus SetDeviceAllowProfileChange(boolean bl) {
            return this.SetProperty(Property.PROPERTY_DEVICE_ALLOW_PROFILE_CHANGE, bl ? 1 : 0);
        }

        public int QueryIVCAMLaserPower() {
            return (int)this.QueryProperty(Property.PROPERTY_IVCAM_LASER_POWER);
        }

        public PropertyInfo QueryIVCAMLaserPowerInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_IVCAM_LASER_POWER, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetIVCAMLaserPower(int n) {
            return this.SetProperty(Property.PROPERTY_IVCAM_ACCURACY, (float)n);
        }

        public int QueryIVCAMAccuracy() {
            return (int)this.QueryProperty(Property.PROPERTY_IVCAM_ACCURACY);
        }

        public IVCAMAccuracy QueryIVCAMAccuracyDefaultValue() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_IVCAM_ACCURACY, propertyInfo);
            return IVCAMAccuracy.values()[(int)propertyInfo.defaultValue];
        }

        public pxcmStatus SetIVCAMAccuracy(IVCAMAccuracy iVCAMAccuracy) {
            return this.SetProperty(Property.PROPERTY_IVCAM_ACCURACY, iVCAMAccuracy.value);
        }

        public MirrorMode QueryMirrorMode() {
            int n = (int)this.QueryProperty(Property.PROPERTY_DEVICE_MIRROR);
            return MirrorMode.values()[n];
        }

        public pxcmStatus SetMirrorMode(MirrorMode mirrorMode) {
            return this.SetProperty(Property.PROPERTY_DEVICE_MIRROR, mirrorMode.value);
        }

        public int QueryIVCAMFilterOption() {
            return (int)this.QueryProperty(Property.PROPERTY_IVCAM_FILTER_OPTION);
        }

        public PropertyInfo QueryIVCAMFilterOptionInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            pxcmStatus pxcmStatus2 = this.QueryPropertyInfo(Property.PROPERTY_IVCAM_FILTER_OPTION, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetIVCAMFilterOption(int n) {
            return this.SetProperty(Property.PROPERTY_IVCAM_FILTER_OPTION, (float)n);
        }

        public int QueryIVCAMMotionRangeTradeOff() {
            return (int)this.QueryProperty(Property.PROPERTY_IVCAM_MOTION_RANGE_TRADE_OFF);
        }

        public PropertyInfo QueryIVCAMMotionRangeTradeOffInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_IVCAM_MOTION_RANGE_TRADE_OFF, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetIVCAMMotionRangeTradeOff(int n) {
            return this.SetProperty(Property.PROPERTY_IVCAM_MOTION_RANGE_TRADE_OFF, (float)n);
        }

        public boolean QueryDSLeftRightCropping() {
            float f = this.QueryProperty(Property.PROPERTY_DS_CROP);
            return f != 0.0f;
        }

        public pxcmStatus SetDSLeftRightCropping(boolean bl) {
            return this.SetProperty(Property.PROPERTY_DS_CROP, bl ? 1.0f : 0.0f);
        }

        public boolean QueryDSEmitterEnabled() {
            float f = this.QueryProperty(Property.PROPERTY_DS_EMITTER);
            return f != 0.0f;
        }

        public pxcmStatus SetDSEnableEmitter(boolean bl) {
            return this.SetProperty(Property.PROPERTY_DS_EMITTER, bl ? 1.0f : 0.0f);
        }

        public boolean QueryDSDisparityOutputEnabled() {
            float f = this.QueryProperty(Property.PROPERTY_DS_DISPARITY_OUTPUT);
            return f != 0.0f;
        }

        public pxcmStatus SetDSEnableDisparityOutput(boolean bl) {
            return this.SetProperty(Property.PROPERTY_DS_DISPARITY_OUTPUT, bl ? 1.0f : 0.0f);
        }

        public int QueryDSDisparityMultiplier() {
            return (int)this.QueryProperty(Property.PROPERTY_DS_DISPARITY_MULTIPLIER);
        }

        public pxcmStatus SetDSDisparityMultiplier(int n) {
            return this.SetProperty(Property.PROPERTY_DS_DISPARITY_MULTIPLIER, (float)n);
        }

        public int QueryDSDisparityShift() {
            return (int)this.QueryProperty(Property.PROPERTY_DS_DISPARITY_SHIFT);
        }

        public pxcmStatus SetDSDisparityShift(int n) {
            return this.SetProperty(Property.PROPERTY_DS_DISPARITY_SHIFT, (float)n);
        }

        public PXCMRangeF32 QueryDSMinMaxZ() {
            PXCMRangeF32 pXCMRangeF32 = new PXCMRangeF32();
            Device.PXCMCapture_Device_QueryPropertyRange(this.instance, Property.PROPERTY_DS_MIN_MAX_Z, pXCMRangeF32);
            return pXCMRangeF32;
        }

        public pxcmStatus SetDSMinMaxZ(PXCMRangeF32 pXCMRangeF32) {
            return Device.PXCMCapture_Device_SetPropertyRange(this.instance, Property.PROPERTY_DS_MIN_MAX_Z, pXCMRangeF32);
        }

        public boolean QueryDSColorRectificationEnabled() {
            float f = this.QueryProperty(Property.PROPERTY_DS_COLOR_RECTIFICATION);
            return f != 0.0f;
        }

        public boolean QueryDSDepthRectificationEnabled() {
            float f = this.QueryProperty(Property.PROPERTY_DS_DEPTH_RECTIFICATION);
            return f != 0.0f;
        }

        public float QueryDSLeftRightExposure() {
            return this.QueryProperty(Property.PROPERTY_DS_LEFTRIGHT_EXPOSURE);
        }

        public PropertyInfo QueryDSLeftRightExposureInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_DS_LEFTRIGHT_EXPOSURE, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetDSLeftRightExposure(float f) {
            return this.SetProperty(Property.PROPERTY_DS_LEFTRIGHT_EXPOSURE, f);
        }

        public boolean QueryDSLeftRightAutoExposure() {
            return this.QueryPropertyAuto(Property.PROPERTY_DS_LEFTRIGHT_EXPOSURE);
        }

        public pxcmStatus SetDSLeftRightAutoExposure(boolean bl) {
            return this.SetPropertyAuto(Property.PROPERTY_DS_LEFTRIGHT_EXPOSURE, bl);
        }

        public int QueryDSLeftRightGain() {
            return (int)this.QueryProperty(Property.PROPERTY_DS_LEFTRIGHT_GAIN);
        }

        public PropertyInfo QueryDSLeftRightGainInfo() {
            PropertyInfo propertyInfo = new PropertyInfo();
            this.QueryPropertyInfo(Property.PROPERTY_DS_LEFTRIGHT_GAIN, propertyInfo);
            return propertyInfo;
        }

        public pxcmStatus SetDSLeftRightGain(int n) {
            return this.SetProperty(Property.PROPERTY_DS_LEFTRIGHT_GAIN, (float)n);
        }

        public Device() {
            super(0L, true);
        }

        Device(long l, boolean bl) {
            super(l, bl);
        }

        public static class PropertyInfo {
            public PXCMRangeF32 range = new PXCMRangeF32();
            public float step = 0.0f;
            public float defaultValue = 0.0f;
            public boolean automatic = false;
        }

        public static class StreamProfileSet {
            public StreamProfile color = new StreamProfile();
            public StreamProfile depth = new StreamProfile();
            public StreamProfile ir = new StreamProfile();
            public StreamProfile left = new StreamProfile();
            public StreamProfile right = new StreamProfile();
            public StreamProfile[] reserved = new StreamProfile[3];

            public StreamProfileSet() {
                for (int i = 0; i < 3; ++i) {
                    this.reserved[i] = new StreamProfile();
                }
            }
        }

        public static class StreamProfile {
            public PXCMImage.ImageInfo imageInfo = new PXCMImage.ImageInfo();
            public PXCMRangeF32 frameRate = new PXCMRangeF32();
            public StreamOption options = StreamOption.STREAM_OPTION_ANY;
        }

        public static enum StreamOption {
            STREAM_OPTION_ANY(0),
            STREAM_OPTION_DEPTH_PRECALCULATE_UVMAP(1),
            STREAM_OPTION_STRONG_STREAM_SYNC(2);

            public int value;

            private StreamOption(int n2) {
                this.value = n2;
            }
        }

        public static enum Property {
            PROPERTY_ANY(0),
            PROPERTY_COLOR_EXPOSURE(1),
            PROPERTY_COLOR_BRIGHTNESS(2),
            PROPERTY_COLOR_CONTRAST(3),
            PROPERTY_COLOR_SATURATION(4),
            PROPERTY_COLOR_HUE(5),
            PROPERTY_COLOR_GAMMA(6),
            PROPERTY_COLOR_WHITE_BALANCE(7),
            PROPERTY_COLOR_SHARPNESS(8),
            PROPERTY_COLOR_BACK_LIGHT_COMPENSATION(9),
            PROPERTY_COLOR_GAIN(10),
            PROPERTY_COLOR_POWER_LINE_FREQUENCY(11),
            PROPERTY_COLOR_FOCAL_LENGTH_MM(12),
            PROPERTY_COLOR_FIELD_OF_VIEW(1000),
            PROPERTY_COLOR_FIELD_OF_VIEW_Y(1001),
            PROPERTY_COLOR_FOCAL_LENGTH(1006),
            PROPERTY_COLOR_FOCAL_LENGTH_Y(1007),
            PROPERTY_COLOR_PRINCIPAL_POINT(1008),
            PROPERTY_COLOR_PRINCIPAL_POINT_Y(1009),
            PROPERTY_DEPTH_LOW_CONFIDENCE_VALUE(201),
            PROPERTY_DEPTH_CONFIDENCE_THRESHOLD(202),
            PROPERTY_DEPTH_UNIT(204),
            PROPERTY_DEPTH_FOCAL_LENGTH_MM(205),
            PROPERTY_DEPTH_FIELD_OF_VIEW(2000),
            PROPERTY_DEPTH_FIELD_OF_VIEW_Y(2001),
            PROPERTY_DEPTH_SENSOR_RANGE(2002),
            PROPERTY_DEPTH_FOCAL_LENGTH(2006),
            PROPERTY_DEPTH_FOCAL_LENGTH_Y(2007),
            PROPERTY_DEPTH_PRINCIPAL_POINT(2008),
            PROPERTY_DEPTH_PRINCIPAL_POINT_Y(2009),
            PROPERTY_DEVICE_ALLOW_PROFILE_CHANGE(302),
            PROPERTY_DEVICE_MIRROR(304),
            PROPERTY_PROJECTION_SERIALIZABLE(3003),
            PROPERTY_IVCAM_LASER_POWER(65536),
            PROPERTY_IVCAM_ACCURACY(65537),
            PROPERTY_IVCAM_FILTER_OPTION(65539),
            PROPERTY_IVCAM_MOTION_RANGE_TRADE_OFF(65540),
            PROPERTY_DS_CROP(131072),
            PROPERTY_DS_EMITTER(131073),
            PROPERTY_DS_DISPARITY_OUTPUT(131075),
            PROPERTY_DS_DISPARITY_MULTIPLIER(131076),
            PROPERTY_DS_DISPARITY_SHIFT(131077),
            PROPERTY_DS_MIN_MAX_Z(131077),
            PROPERTY_DS_COLOR_RECTIFICATION(131079),
            PROPERTY_DS_DEPTH_RECTIFICATION(131080),
            PROPERTY_DS_LEFTRIGHT_EXPOSURE(131082),
            PROPERTY_DS_LEFTRIGHT_GAIN(131083),
            PROPERTY_CUSTOMIZED(0x4000000);

            public int value;

            private Property(int n2) {
                this.value = n2;
            }
        }

        public static enum IVCAMAccuracy {
            IVCAM_ACCURACY_FINEST(1),
            IVCAM_ACCURACY_MEDIAN(2),
            IVCAM_ACCURACY_COARSE(3);

            public int value;

            private IVCAMAccuracy(int n2) {
                this.value = n2;
            }
        }

        public static enum MirrorMode {
            MIRROR_MODE_DISABLED(0),
            MIRROR_MODE_HORIZONTAL(1);

            public int value;

            private MirrorMode(int n2) {
                this.value = n2;
            }
        }

        public static enum PowerLineFrequency {
            POWER_LINE_FREQUENCY_DISABLED(0),
            POWER_LINE_FREQUENCY_50HZ(1),
            POWER_LINE_FREQUENCY_60HZ(2);

            public int value;

            private PowerLineFrequency(int n2) {
                this.value = n2;
            }
        }
    }

    public static class Sample {
        public PXCMImage color = null;
        public PXCMImage depth = null;
        public PXCMImage ir = null;
        public PXCMImage left = null;
        public PXCMImage right = null;
        public PXCMImage[] reserved = new PXCMImage[3];

        public void ReleaseImages() {
            if (this.color != null) {
                this.color.close();
                this.color = null;
            }
            if (this.depth != null) {
                this.depth.close();
                this.depth = null;
            }
            if (this.ir != null) {
                this.ir.close();
                this.ir = null;
            }
            if (this.left != null) {
                this.left.close();
                this.left = null;
            }
            if (this.right != null) {
                this.right.close();
                this.right = null;
            }
            for (int i = 0; i < 3; ++i) {
                if (this.reserved[i] == null) continue;
                this.reserved[i].close();
                this.reserved[i] = null;
            }
        }
    }

    public static class DeviceInfo {
        public String name = "";
        public String serial = "";
        public String did = "";
        public int[] firmware = new int[4];
        public PXCMPointF32 location = new PXCMPointF32();
        public DeviceModel model = DeviceModel.DEVICE_MODEL_GENERIC;
        public DeviceOrientation orientation = DeviceOrientation.DEVICE_ORIENTATION_ANY;
        public EnumSet<StreamType> streams = EnumSet.of(StreamType.STREAM_TYPE_ANY);
        public int didx;
        public int duid;

        public int QueryStreamNum() {
            return this.streams.size();
        }
    }

    public static enum DeviceOrientation {
        DEVICE_ORIENTATION_ANY(0),
        DEVICE_ORIENTATION_USER_FACING(1),
        DEVICE_ORIENTATION_FRONT_FACING(1),
        DEVICE_ORIENTATION_WORLD_FACING(2),
        DEVICE_ORIENTATION_REAR_FACING(2);

        public final int value;

        private DeviceOrientation(int n2) {
            this.value = n2;
        }
    }

    public static enum DeviceModel {
        DEVICE_MODEL_GENERIC(0),
        DEVICE_MODEL_F200(0x20000E),
        DEVICE_MODEL_IVCAM(0x20000E),
        DEVICE_MODEL_R200(0x20000F),
        DEVICE_MODEL_DS4(0x20000F);

        public final int value;

        private DeviceModel(int n2) {
            this.value = n2;
        }
    }

    public static enum StreamType {
        STREAM_TYPE_ANY(0),
        STREAM_TYPE_COLOR(1),
        STREAM_TYPE_DEPTH(2),
        STREAM_TYPE_IR(4),
        STREAM_TYPE_LEFT(8),
        STREAM_TYPE_RIGHT(16);

        public final int value;

        private StreamType(int n2) {
            this.value = n2;
        }
    }
}

