/*
 * Decompiled with CFR 0.152.
 */
package intel.rssdk;

import intel.rssdk.PXCMBase;
import intel.rssdk.PXCMBoxedData;
import intel.rssdk.PXCMCapture;
import intel.rssdk.PXCMSession;
import intel.rssdk.PXCMSizeI32;
import intel.rssdk.PXCMSyncPoint;
import intel.rssdk.PXCMVideoModule;
import intel.rssdk.pxcmStatus;
import java.util.ArrayList;

public class PXCMCaptureManager
extends PXCMBase {
    public static final int CUID = -661576891;
    ArrayList<PXCMVideoModule.DataDesc> listVideoRequests = new ArrayList();

    private static native void PXCMCaptureManager_FilterByDeviceInfo(long var0, PXCMCapture.DeviceInfo var2);

    private static native void PXCMCaptureManager_FilterByStreamProfiles(long var0, PXCMCapture.Device.StreamProfileSet var2);

    private static native pxcmStatus PXCMCaptureManager_RequestStreams(long var0, int var2, PXCMVideoModule.DataDesc var3);

    private static native pxcmStatus PXCMCaptureManager_LocateStreams(long var0, CMHandler var2, ArrayList<PXCMVideoModule.DataDesc> var3, PXCMSession.ImplDesc var4);

    private static native void PXCMCaptureManager_CloseStreams(long var0);

    private static native long PXCMCaptureManager_QueryCapture(long var0);

    private static native long PXCMCaptureManager_QueryDevice(long var0);

    private static native void PXCMCaptureManager_QueryImageSize(long var0, PXCMCapture.StreamType var2, PXCMSizeI32 var3);

    private static native pxcmStatus PXCMCaptureManager_ReadModuleStreamsAsync(long var0, int var2, long[] var3, PXCMBoxedData var4);

    private static native pxcmStatus PXCMCaptureManager_SetFileName(long var0, String var2, boolean var3);

    private static native void PXCMCaptureManager_SetMask(long var0, PXCMCapture.StreamType var2);

    private static native void PXCMCaptureManager_SetPause(long var0, boolean var2);

    private static native void PXCMCaptureManager_SetRealtime(long var0, boolean var2);

    private static native void PXCMCaptureManager_SetFrameByIndex(long var0, int var2);

    private static native int PXCMCaptureManager_QueryFrameIndex(long var0);

    private static native void PXCMCaptureManager_SetFrameByTimeStamp(long var0, long var2);

    private static native long PXCMCaptureManager_QueryFrameTimeStamp(long var0);

    private static native int PXCMCaptureManager_QueryNumberOfFrames(long var0);

    private static native void PXCMCaptureManager_FreeNativeReferences(long var0, long[] var2);

    public void FilterByDeviceInfo(PXCMCapture.DeviceInfo deviceInfo) {
        PXCMCaptureManager.PXCMCaptureManager_FilterByDeviceInfo(this.instance, deviceInfo);
    }

    public void FilterByDeviceInfo(String string, String string2, int n) {
        PXCMCapture.DeviceInfo deviceInfo = new PXCMCapture.DeviceInfo();
        if (string != null) {
            deviceInfo.name = string;
        }
        if (string2 != null) {
            deviceInfo.did = string2;
        }
        deviceInfo.didx = n;
        this.FilterByDeviceInfo(deviceInfo);
    }

    public void FilterByStreamProfiles(PXCMCapture.Device.StreamProfileSet streamProfileSet) {
        PXCMCaptureManager.PXCMCaptureManager_FilterByStreamProfiles(this.instance, streamProfileSet);
    }

    public void FilterByStreamProfiles(PXCMCapture.StreamType streamType, int n, int n2, float f) {
        PXCMCapture.Device.StreamProfileSet streamProfileSet = new PXCMCapture.Device.StreamProfileSet();
        switch (streamType) {
            case STREAM_TYPE_COLOR: {
                streamProfileSet.color.imageInfo.width = n;
                streamProfileSet.color.imageInfo.height = n2;
                streamProfileSet.color.frameRate.min = f;
                streamProfileSet.color.frameRate.max = f;
                break;
            }
            case STREAM_TYPE_DEPTH: {
                streamProfileSet.depth.imageInfo.width = n;
                streamProfileSet.depth.imageInfo.height = n2;
                streamProfileSet.depth.frameRate.min = f;
                streamProfileSet.depth.frameRate.max = f;
                break;
            }
            case STREAM_TYPE_IR: {
                streamProfileSet.ir.imageInfo.width = n;
                streamProfileSet.ir.imageInfo.height = n2;
                streamProfileSet.ir.frameRate.min = f;
                streamProfileSet.ir.frameRate.max = f;
                break;
            }
            case STREAM_TYPE_LEFT: {
                streamProfileSet.left.imageInfo.width = n;
                streamProfileSet.left.imageInfo.height = n2;
                streamProfileSet.left.frameRate.min = f;
                streamProfileSet.left.frameRate.max = f;
                break;
            }
            case STREAM_TYPE_RIGHT: {
                streamProfileSet.right.imageInfo.width = n;
                streamProfileSet.right.imageInfo.height = n2;
                streamProfileSet.right.frameRate.min = f;
                streamProfileSet.right.frameRate.max = f;
                break;
            }
        }
        this.FilterByStreamProfiles(streamProfileSet);
    }

    public pxcmStatus RequestStreams(int n, PXCMVideoModule.DataDesc dataDesc) {
        this.listVideoRequests.add(dataDesc);
        return PXCMCaptureManager.PXCMCaptureManager_RequestStreams(this.instance, n, dataDesc);
    }

    public pxcmStatus LocateStreams(Handler handler) {
        CMHandler cMHandler = null;
        if (handler != null) {
            cMHandler = new CMHandler(handler);
        }
        pxcmStatus pxcmStatus2 = PXCMCaptureManager.PXCMCaptureManager_LocateStreams(this.instance, cMHandler, this.listVideoRequests, new PXCMSession.ImplDesc());
        return pxcmStatus2;
    }

    public pxcmStatus LocateStreams() {
        return this.LocateStreams(null);
    }

    public void CloseStreams() {
        PXCMCaptureManager.PXCMCaptureManager_CloseStreams(this.instance);
    }

    public PXCMCapture QueryCapture() {
        long l = PXCMCaptureManager.PXCMCaptureManager_QueryCapture(this.instance);
        if (l == 0L) {
            return null;
        }
        return new PXCMCapture(l, false);
    }

    public PXCMCapture.Device QueryDevice() {
        long l = PXCMCaptureManager.PXCMCaptureManager_QueryDevice(this.instance);
        if (l == 0L) {
            return null;
        }
        return new PXCMCapture.Device(l, false);
    }

    public PXCMSizeI32 QueryImageSize(PXCMCapture.StreamType streamType) {
        PXCMSizeI32 pXCMSizeI32 = new PXCMSizeI32();
        PXCMCaptureManager.PXCMCaptureManager_QueryImageSize(this.instance, streamType, pXCMSizeI32);
        return pXCMSizeI32;
    }

    public pxcmStatus ReadModuleStreamsAsync(int n, PXCMCapture.Sample sample, PXCMSyncPoint pXCMSyncPoint) {
        PXCMBoxedData pXCMBoxedData = new PXCMBoxedData();
        long[] lArray = new long[8];
        for (int i = 0; i < 8; ++i) {
            lArray[i] = 0L;
        }
        pxcmStatus pxcmStatus2 = PXCMCaptureManager.PXCMCaptureManager_ReadModuleStreamsAsync(this.instance, n, lArray, pXCMBoxedData);
        if (pxcmStatus2.compareTo(pxcmStatus.PXCM_STATUS_NO_ERROR) >= 0) {
            if (pXCMSyncPoint != null) {
                pXCMSyncPoint.ResetInstance(pXCMBoxedData.longValue);
                pXCMSyncPoint.AddRef();
            }
            if (sample != null) {
                if (lArray[0] != 0L && sample.color != null) {
                    sample.color.ResetInstance(lArray[0]);
                    sample.color.AddRef();
                }
                if (lArray[1] != 0L && sample.depth != null) {
                    sample.depth.ResetInstance(lArray[1]);
                    sample.depth.AddRef();
                }
                if (lArray[2] != 0L && sample.ir != null) {
                    sample.ir.ResetInstance(lArray[2]);
                    sample.ir.AddRef();
                }
                if (lArray[3] != 0L && sample.left != null) {
                    sample.left.ResetInstance(lArray[3]);
                    sample.left.AddRef();
                }
                if (lArray[4] != 0L && sample.right != null) {
                    sample.right.ResetInstance(lArray[4]);
                    sample.right.AddRef();
                }
                for (int i = 0; i < 3; ++i) {
                    if (lArray[i + 5] == 0L || sample.reserved[i] == null) continue;
                    sample.reserved[i].ResetInstance(lArray[i + 5]);
                    sample.reserved[i].AddRef();
                }
            }
        }
        return pxcmStatus2;
    }

    public pxcmStatus SetFileName(String string, boolean bl) {
        return PXCMCaptureManager.PXCMCaptureManager_SetFileName(this.instance, string, bl);
    }

    public void SetMask(PXCMCapture.StreamType streamType) {
        PXCMCaptureManager.PXCMCaptureManager_SetMask(this.instance, streamType);
    }

    public void SetPause(boolean bl) {
        PXCMCaptureManager.PXCMCaptureManager_SetPause(this.instance, bl);
    }

    public void SetRealtime(boolean bl) {
        PXCMCaptureManager.PXCMCaptureManager_SetRealtime(this.instance, bl);
    }

    public void SetFrameByIndex(int n) {
        PXCMCaptureManager.PXCMCaptureManager_SetFrameByIndex(this.instance, n);
    }

    public int QueryFrameIndex() {
        return PXCMCaptureManager.PXCMCaptureManager_QueryFrameIndex(this.instance);
    }

    public void SetFrameByTimeStamp(long l) {
        PXCMCaptureManager.PXCMCaptureManager_SetFrameByTimeStamp(this.instance, l);
    }

    public long QueryFrameTimeStamp() {
        return PXCMCaptureManager.PXCMCaptureManager_QueryFrameTimeStamp(this.instance);
    }

    public int QueryNumberOfFrames() {
        return PXCMCaptureManager.PXCMCaptureManager_QueryNumberOfFrames(this.instance);
    }

    @Override
    public void close() {
        int n = this.listVideoRequests.size();
        if (n > 0) {
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = this.listVideoRequests.get((int)i).nativeRef;
            }
            PXCMCaptureManager.PXCMCaptureManager_FreeNativeReferences(this.instance, lArray);
        }
        super.close();
    }

    public PXCMCaptureManager() {
        super(0L, true);
    }

    PXCMCaptureManager(long l, boolean bl) {
        super(l, bl);
    }

    private class CMHandler {
        private Handler jhandler;

        public pxcmStatus OnCreateDevice(PXCMSession.ImplDesc implDesc, long l) {
            if (this.jhandler != null) {
                PXCMCapture.Device device = new PXCMCapture.Device(l, false);
                return this.jhandler.OnCreateDevice(implDesc, device);
            }
            return pxcmStatus.PXCM_STATUS_NO_ERROR;
        }

        public pxcmStatus OnSetupStreams(long l, PXCMCapture.StreamType streamType) {
            if (this.jhandler != null) {
                PXCMCapture.Device device = new PXCMCapture.Device(l, false);
                return this.jhandler.OnSetupStreams(device, streamType);
            }
            return pxcmStatus.PXCM_STATUS_NO_ERROR;
        }

        public pxcmStatus OnNextDevice(long l) {
            if (this.jhandler != null) {
                PXCMCapture.Device device = new PXCMCapture.Device(l, false);
                return this.jhandler.OnNextDevice(device);
            }
            return pxcmStatus.PXCM_STATUS_NO_ERROR;
        }

        public CMHandler(Handler handler) {
            this.jhandler = handler;
        }
    }

    public static interface Handler {
        public pxcmStatus OnCreateDevice(PXCMSession.ImplDesc var1, PXCMCapture.Device var2);

        public pxcmStatus OnSetupStreams(PXCMCapture.Device var1, PXCMCapture.StreamType var2);

        public pxcmStatus OnNextDevice(PXCMCapture.Device var1);
    }
}

