/*
 * Decompiled with CFR 0.152.
 */
package intel.rssdk;

import intel.rssdk.PXCMBase;
import intel.rssdk.PXCMCapture;
import intel.rssdk.pxcmStatus;
import java.util.EnumSet;

public class PXCMImage
extends PXCMBase {
    public static final int CUID = 611585910;
    public static final int NUM_OF_PLANES = 4;
    public static final int METADATA_DEVICE_PROPERTIES = 1632724787;
    public static final int METADATA_DEVICE_PROJECTION = 893810778;

    private static native pxcmStatus PXCMImage_QueryInfo(long var0, ImageInfo var2);

    private static native long PXCMImage_QueryTimeStamp(long var0);

    private static native PXCMCapture.StreamType PXCMImage_QueryStreamType(long var0);

    private static native void PXCMImage_SetTimeStamp(long var0, long var2);

    private static native void PXCMImage_SetStreamType(long var0, PXCMCapture.StreamType var2);

    private static native EnumSet<Option> PXCMImage_QueryOptions(long var0);

    private static native void PXCMImage_SetOptions(long var0, EnumSet<Option> var2);

    private static native pxcmStatus PXCMImage_CopyImage(long var0, PXCMImage var2);

    private static native pxcmStatus PXCMImage_ExportData(long var0, ImageData var2, int var3);

    private static native pxcmStatus PXCMImage_ImportData(long var0, ImageData var2, int var3);

    private static native pxcmStatus PXCMImage_AcquireAccess(long var0, Access var2, int var3, int var4, ImageData var5);

    private static native pxcmStatus PXCMImage_ReleaseAccess(long var0, ImageData var2);

    private static native void PXCMImage_Release(long var0);

    public static String PixelFormatToString(PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case PIXEL_FORMAT_RGB24: {
                return "RGB24";
            }
            case PIXEL_FORMAT_RGB32: {
                return "RGB32";
            }
            case PIXEL_FORMAT_YUY2: {
                return "YUY2";
            }
            case PIXEL_FORMAT_NV12: {
                return "NV12";
            }
            case PIXEL_FORMAT_Y8: {
                return "Y8";
            }
            case PIXEL_FORMAT_Y16: {
                return "Y16";
            }
            case PIXEL_FORMAT_DEPTH: {
                return "Depth";
            }
            case PIXEL_FORMAT_DEPTH_F32: {
                return "Depth(float)";
            }
            case PIXEL_FORMAT_DEPTH_RAW: {
                return "Depth(native)";
            }
        }
        return "Unknown";
    }

    public ImageInfo QueryInfo() {
        ImageInfo imageInfo = new ImageInfo();
        PXCMImage.PXCMImage_QueryInfo(this.instance, imageInfo);
        return imageInfo;
    }

    public long QueryTimeStamp() {
        return PXCMImage.PXCMImage_QueryTimeStamp(this.instance);
    }

    public PXCMCapture.StreamType QueryStreamType() {
        return PXCMImage.PXCMImage_QueryStreamType(this.instance);
    }

    public EnumSet<Option> QueryOptions() {
        return PXCMImage.PXCMImage_QueryOptions(this.instance);
    }

    public void SetTimeStamp(long l) {
        PXCMImage.PXCMImage_SetTimeStamp(this.instance, l);
    }

    public void SetStreamType(PXCMCapture.StreamType streamType) {
        PXCMImage.PXCMImage_SetStreamType(this.instance, streamType);
    }

    public void SetOptions(EnumSet<Option> enumSet) {
        PXCMImage.PXCMImage_SetOptions(this.instance, enumSet);
    }

    public pxcmStatus CopyImage(PXCMImage pXCMImage) {
        return PXCMImage.PXCMImage_CopyImage(this.instance, pXCMImage);
    }

    public pxcmStatus ExportData(ImageData imageData, int n) {
        return PXCMImage.PXCMImage_ExportData(this.instance, imageData, n);
    }

    public pxcmStatus ExportData(ImageData imageData) {
        return this.ExportData(imageData, 0);
    }

    public pxcmStatus ImportData(ImageData imageData, int n) {
        return PXCMImage.PXCMImage_ImportData(this.instance, imageData, n);
    }

    public pxcmStatus ImportData(ImageData imageData) {
        return this.ImportData(imageData, 0);
    }

    public pxcmStatus AcquireAccess(Access access, PixelFormat pixelFormat, Option option, ImageData imageData) {
        return PXCMImage.PXCMImage_AcquireAccess(this.instance, access, pixelFormat.value, option.value, imageData);
    }

    public pxcmStatus AcquireAccess(Access access, PixelFormat pixelFormat, ImageData imageData) {
        return PXCMImage.PXCMImage_AcquireAccess(this.instance, access, pixelFormat.value, 0, imageData);
    }

    public pxcmStatus AcquireAccess(Access access, ImageData imageData) {
        return PXCMImage.PXCMImage_AcquireAccess(this.instance, access, 0, 0, imageData);
    }

    public pxcmStatus ReleaseAccess(ImageData imageData) {
        return PXCMImage.PXCMImage_ReleaseAccess(this.instance, imageData);
    }

    public PXCMImage() {
        super(0L, true);
    }

    public PXCMImage(long l, boolean bl) {
        super(l, bl);
    }

    public static enum Access {
        ACCESS_READ,
        ACCESS_WRITE,
        ACCESS_READ_WRITE;

    }

    public static class ImageData {
        public PixelFormat format = PixelFormat.PIXEL_FORMAT_RGB32;
        public int[] pitches = new int[4];
        private long[] planes = new long[4];
        public long nativeRef;

        private static native byte[] PXCMImage_ImageData_ToByteArray(long var0, int var2, byte[] var3);

        private static native short[] PXCMImage_ImageData_ToShortArray(long var0, int var2, short[] var3);

        private static native int[] PXCMImage_ImageData_ToIntArray(long var0, int var2, int[] var3);

        private static native float[] PXCMImage_ImageData_ToFloatArray(long var0, int var2, float[] var3);

        private static native void PXCMImage_ImageData_FromByteArray(long var0, int var2, byte[] var3);

        private static native void PXCMImage_ImageData_FromShortArray(long var0, int var2, short[] var3);

        private static native void PXCMImage_ImageData_FromIntArray(long var0, int var2, int[] var3);

        private static native void PXCMImage_ImageData_FromFloatArray(long var0, int var2, float[] var3);

        public byte[] ToByteArray(int n, byte[] byArray) {
            return ImageData.PXCMImage_ImageData_ToByteArray(this.nativeRef, n, byArray);
        }

        public byte[] ToByteArray(int n, int n2) {
            byte[] byArray = new byte[n2];
            ImageData.PXCMImage_ImageData_ToByteArray(this.nativeRef, n, byArray);
            return byArray;
        }

        public short[] ToShortArray(int n, short[] sArray) {
            return ImageData.PXCMImage_ImageData_ToShortArray(this.nativeRef, n, sArray);
        }

        public short[] ToShortArray(int n, int n2) {
            short[] sArray = new short[n2];
            ImageData.PXCMImage_ImageData_ToShortArray(this.nativeRef, n, sArray);
            return sArray;
        }

        public int[] ToIntArray(int n, int[] nArray) {
            ImageData.PXCMImage_ImageData_ToIntArray(this.nativeRef, n, nArray);
            return nArray;
        }

        public int[] ToIntArray(int n, int n2) {
            int[] nArray = new int[n2];
            ImageData.PXCMImage_ImageData_ToIntArray(this.nativeRef, n, nArray);
            return nArray;
        }

        public float[] ToFloatArray(int n, float[] fArray) {
            return ImageData.PXCMImage_ImageData_ToFloatArray(this.nativeRef, n, fArray);
        }

        public float[] ToFloatArray(int n, int n2) {
            float[] fArray = new float[n2];
            ImageData.PXCMImage_ImageData_ToFloatArray(this.nativeRef, n, fArray);
            return fArray;
        }

        public void FromByteArray(int n, byte[] byArray) {
            if (n < 0 || n >= 4) {
                return;
            }
            ImageData.PXCMImage_ImageData_FromByteArray(this.nativeRef, n, byArray);
        }

        public void FromShortArray(int n, short[] sArray) {
            if (n < 0 || n >= 4) {
                return;
            }
            ImageData.PXCMImage_ImageData_FromShortArray(this.nativeRef, n, sArray);
        }

        public void FromIntArray(int n, int[] nArray) {
            if (n < 0 || n >= 4) {
                return;
            }
            ImageData.PXCMImage_ImageData_FromIntArray(this.nativeRef, n, nArray);
        }

        public void FromFloatArray(int n, float[] fArray) {
            if (n < 0 || n >= 4) {
                return;
            }
            ImageData.PXCMImage_ImageData_FromFloatArray(this.nativeRef, n, fArray);
        }
    }

    public static class ImageInfo {
        public int width = 0;
        public int height = 0;
        public PixelFormat format = PixelFormat.PIXEL_FORMAT_RGB32;
    }

    public static enum Option {
        OPTION_ANY(0);

        public final int value;

        private Option(int n2) {
            this.value = n2;
        }
    }

    public static enum PixelFormat {
        PIXEL_FORMAT_ANY(0, "Unknown"),
        PIXEL_FORMAT_YUY2(65536, "YUY2"),
        PIXEL_FORMAT_NV12(65537, "NV12"),
        PIXEL_FORMAT_RGB32(65538, "RGB32"),
        PIXEL_FORMAT_RGB24(65539, "RGB24"),
        PIXEL_FORMAT_Y8(65540, "Y8"),
        PIXEL_FORMAT_DEPTH(131072, "Depth"),
        PIXEL_FORMAT_DEPTH_RAW(131073, "Depth(native)"),
        PIXEL_FORMAT_DEPTH_F32(131074, "Depth(float)"),
        PIXEL_FORMAT_Y16(262144, "Y16"),
        PIXEL_FORMAT_Y8_IR_RELATIVE(524288, "Y8IR");

        public final int value;
        public final String name;

        public String toString() {
            return this.name;
        }

        private PixelFormat(int n2, String string2) {
            this.value = n2;
            this.name = string2;
        }
    }
}

