/*
 * Decompiled with CFR 0.152.
 */
package intel.rssdk;

import intel.rssdk.PXCM3DScan;
import intel.rssdk.PXCM3DSeg;
import intel.rssdk.PXCMBase;
import intel.rssdk.PXCMCapture;
import intel.rssdk.PXCMCaptureManager;
import intel.rssdk.PXCMFaceModule;
import intel.rssdk.PXCMHandModule;
import intel.rssdk.PXCMImage;
import intel.rssdk.PXCMSession;
import intel.rssdk.PXCMTracker;
import intel.rssdk.PXCMVideoModule;
import intel.rssdk.pxcmStatus;
import java.util.EnumSet;

public class PXCMSenseManager
extends PXCMBase {
    public static final int CUID = -661306591;
    public static final int TIMEOUT_INFINITE = -1;

    private static native long PXCMSenseManager_QuerySession(long var0);

    private static native long PXCMSenseManager_QueryCaptureManager(long var0);

    private static native void PXCMSenseManager_QuerySample(long var0, int var2, long[] var3);

    private static native long PXCMSenseManager_QueryModule(long var0, int var2);

    private static native boolean PXCMSenseManager_IsConnected(long var0);

    private static native pxcmStatus PXCMSenseManager_AcquireFrame(long var0, boolean var2, int var3);

    private static native void PXCMSenseManager_FlushFrame(long var0);

    private static native void PXCMSenseManager_ReleaseFrame(long var0);

    private static native void PXCMSenseManager_Close(long var0);

    private static native pxcmStatus PXCMSenseManager_EnableStreams(long var0, PXCMVideoModule.DataDesc var2);

    private static native pxcmStatus PXCMSenseManager_EnableModule(long var0, int var2, PXCMSession.ImplDesc var3);

    private static native void PXCMSenseManager_PauseModule(long var0, int var2, boolean var3);

    private static native long PXCMSenseManager_CreateInstance();

    private static native pxcmStatus PXCMSenseManager_StreamFrames(long var0, boolean var2);

    private static native pxcmStatus PXCMSenseManager_Init(long var0, SMHandler var2);

    public PXCMSession QuerySession() {
        long l = PXCMSenseManager.PXCMSenseManager_QuerySession(this.instance);
        if (l == 0L) {
            return null;
        }
        return new PXCMSession(l, false);
    }

    public PXCMCaptureManager QueryCaptureManager() {
        long l = PXCMSenseManager.PXCMSenseManager_QueryCaptureManager(this.instance);
        if (l == 0L) {
            return null;
        }
        return new PXCMCaptureManager(l, false);
    }

    public PXCMCapture.Sample QuerySample(int n) {
        long[] lArray = new long[8];
        PXCMSenseManager.PXCMSenseManager_QuerySample(this.instance, n, lArray);
        PXCMCapture.Sample sample = new PXCMCapture.Sample();
        if (lArray[0] != 0L) {
            sample.color = new PXCMImage(lArray[0], false);
        }
        if (lArray[1] != 0L) {
            sample.depth = new PXCMImage(lArray[1], false);
        }
        if (lArray[2] != 0L) {
            sample.ir = new PXCMImage(lArray[2], false);
        }
        if (lArray[3] != 0L) {
            sample.left = new PXCMImage(lArray[3], false);
        }
        if (lArray[4] != 0L) {
            sample.right = new PXCMImage(lArray[4], false);
        }
        for (int i = 0; i < 3; ++i) {
            if (lArray[5 + i] == 0L) continue;
            sample.reserved[i] = new PXCMImage(lArray[5 + i], false);
        }
        return sample;
    }

    public PXCMCapture.Sample QuerySample() {
        return this.QuerySample(0);
    }

    public PXCMCapture.Sample QueryFaceSample() {
        return this.QuerySample(1144209734);
    }

    public PXCMCapture.Sample QueryHandSample() {
        return this.QuerySample(1313751368);
    }

    public long QueryModule(int n) {
        return PXCMSenseManager.PXCMSenseManager_QueryModule(this.instance, n);
    }

    public PXCMFaceModule QueryFace() {
        long l = this.QueryModule(1144209734);
        if (l == 0L) {
            return null;
        }
        PXCMBase pXCMBase = new PXCMBase(l, false).QueryInstance(1144209734);
        return (PXCMFaceModule)pXCMBase;
    }

    public PXCM3DSeg Query3DSeg() {
        long l = this.QueryModule(826885971);
        if (l == 0L) {
            return null;
        }
        PXCMBase pXCMBase = new PXCMBase(l, false).QueryInstance(826885971);
        return (PXCM3DSeg)pXCMBase;
    }

    public PXCMHandModule QueryHand() {
        long l = this.QueryModule(1313751368);
        if (l == 0L) {
            return null;
        }
        PXCMBase pXCMBase = new PXCMBase(l, false).QueryInstance(1313751368);
        return (PXCMHandModule)pXCMBase;
    }

    public PXCMTracker QueryTracker() {
        long l = this.QueryModule(1380667988);
        if (l == 0L) {
            return null;
        }
        PXCMBase pXCMBase = new PXCMBase(l, false).QueryInstance(1380667988);
        return (PXCMTracker)pXCMBase;
    }

    public PXCM3DScan Query3DScan() {
        long l = this.QueryModule(826884947);
        if (l == 0L) {
            return null;
        }
        PXCMBase pXCMBase = new PXCMBase(l, false).QueryInstance(826884947);
        return (PXCM3DScan)pXCMBase;
    }

    public pxcmStatus Init(Handler handler) {
        SMHandler sMHandler = null;
        if (handler != null) {
            sMHandler = new SMHandler(handler);
        }
        return PXCMSenseManager.PXCMSenseManager_Init(this.instance, sMHandler);
    }

    public pxcmStatus Init() {
        return this.Init(null);
    }

    public pxcmStatus StreamFrames(boolean bl) {
        return PXCMSenseManager.PXCMSenseManager_StreamFrames(this.instance, bl);
    }

    public pxcmStatus StreamFrames() {
        return this.StreamFrames(true);
    }

    public boolean IsConnected() {
        return PXCMSenseManager.PXCMSenseManager_IsConnected(this.instance);
    }

    public pxcmStatus AcquireFrame(boolean bl, int n) {
        return PXCMSenseManager.PXCMSenseManager_AcquireFrame(this.instance, bl, n);
    }

    public pxcmStatus AcquireFrame(boolean bl) {
        return this.AcquireFrame(bl, -1);
    }

    public pxcmStatus AcquireFrame() {
        return this.AcquireFrame(true);
    }

    public void FlushFrame() {
        PXCMSenseManager.PXCMSenseManager_FlushFrame(this.instance);
    }

    public void ReleaseFrame() {
        PXCMSenseManager.PXCMSenseManager_ReleaseFrame(this.instance);
    }

    public void Close() {
        PXCMSenseManager.PXCMSenseManager_Close(this.instance);
    }

    public pxcmStatus EnableStreams(PXCMVideoModule.DataDesc dataDesc) {
        return PXCMSenseManager.PXCMSenseManager_EnableStreams(this.instance, dataDesc);
    }

    public pxcmStatus EnableStream(PXCMCapture.StreamType streamType, int n, int n2, int n3) {
        PXCMVideoModule.DataDesc dataDesc = new PXCMVideoModule.DataDesc();
        dataDesc.deviceInfo.streams = EnumSet.of(streamType);
        switch (streamType) {
            case STREAM_TYPE_COLOR: {
                dataDesc.streams.color.sizeMin.width = dataDesc.streams.color.sizeMax.width = n;
                dataDesc.streams.color.sizeMin.height = dataDesc.streams.color.sizeMax.height = n2;
                dataDesc.streams.color.frameRate.min = n3;
                dataDesc.streams.color.frameRate.max = n3;
                break;
            }
            case STREAM_TYPE_DEPTH: {
                dataDesc.streams.depth.sizeMin.width = dataDesc.streams.depth.sizeMax.width = n;
                dataDesc.streams.depth.sizeMin.height = dataDesc.streams.depth.sizeMax.height = n2;
                dataDesc.streams.depth.frameRate.min = n3;
                dataDesc.streams.depth.frameRate.max = n3;
                break;
            }
            case STREAM_TYPE_IR: {
                dataDesc.streams.ir.sizeMin.width = dataDesc.streams.ir.sizeMax.width = n;
                dataDesc.streams.ir.sizeMin.height = dataDesc.streams.ir.sizeMax.height = n2;
                dataDesc.streams.ir.frameRate.min = n3;
                dataDesc.streams.ir.frameRate.max = n3;
                break;
            }
            case STREAM_TYPE_LEFT: {
                dataDesc.streams.left.sizeMin.width = dataDesc.streams.left.sizeMax.width = n;
                dataDesc.streams.left.sizeMin.height = dataDesc.streams.left.sizeMax.height = n2;
                dataDesc.streams.left.frameRate.min = n3;
                dataDesc.streams.left.frameRate.max = n3;
                break;
            }
            case STREAM_TYPE_RIGHT: {
                dataDesc.streams.right.sizeMin.width = dataDesc.streams.right.sizeMax.width = n;
                dataDesc.streams.right.sizeMin.height = dataDesc.streams.right.sizeMax.height = n2;
                dataDesc.streams.right.frameRate.min = n3;
                dataDesc.streams.right.frameRate.max = n3;
                break;
            }
        }
        return this.EnableStreams(dataDesc);
    }

    public pxcmStatus EnableStream(PXCMCapture.StreamType streamType, int n, int n2) {
        return this.EnableStream(streamType, n, n2, 0);
    }

    public pxcmStatus EnableStream(PXCMCapture.StreamType streamType) {
        return this.EnableStream(streamType, 0, 0, 0);
    }

    public pxcmStatus EnableModule(int n, PXCMSession.ImplDesc implDesc) {
        return PXCMSenseManager.PXCMSenseManager_EnableModule(this.instance, n, implDesc);
    }

    public pxcmStatus EnableFace(String string) {
        PXCMSession.ImplDesc implDesc = new PXCMSession.ImplDesc();
        implDesc.cuids[0] = 1144209734;
        if (string != null) {
            implDesc.friendlyName = string;
        }
        return this.EnableModule(1144209734, implDesc);
    }

    public pxcmStatus Enable3DSeg() {
        PXCMSession.ImplDesc implDesc = new PXCMSession.ImplDesc();
        implDesc.cuids[0] = 826885971;
        return this.EnableModule(826885971, implDesc);
    }

    public pxcmStatus EnableTracker() {
        PXCMSession.ImplDesc implDesc = new PXCMSession.ImplDesc();
        implDesc.cuids[0] = 1380667988;
        return this.EnableModule(1380667988, implDesc);
    }

    public pxcmStatus Enable3DScan() {
        PXCMSession.ImplDesc implDesc = new PXCMSession.ImplDesc();
        implDesc.cuids[0] = 826884947;
        return this.EnableModule(826884947, implDesc);
    }

    public pxcmStatus EnableHand(String string) {
        PXCMSession.ImplDesc implDesc = new PXCMSession.ImplDesc();
        implDesc.cuids[0] = 1313751368;
        if (string != null) {
            implDesc.friendlyName = string;
        }
        return this.EnableModule(1313751368, implDesc);
    }

    public void PauseModule(int n, boolean bl) {
        PXCMSenseManager.PXCMSenseManager_PauseModule(this.instance, n, bl);
    }

    public void PauseFace(boolean bl) {
        this.PauseModule(1144209734, bl);
    }

    public void PauseSegmentation(boolean bl) {
        this.PauseModule(826885971, bl);
    }

    public void PauseTracker(boolean bl) {
        this.PauseModule(1380667988, bl);
    }

    public void PauseHand(boolean bl) {
        this.PauseModule(1313751368, bl);
    }

    public static PXCMSenseManager CreateInstance() {
        long l = PXCMSenseManager.PXCMSenseManager_CreateInstance();
        if (l != 0L) {
            return new PXCMSenseManager(l, true);
        }
        return null;
    }

    public PXCMSenseManager() {
        super(0L, true);
    }

    PXCMSenseManager(long l, boolean bl) {
        super(l, bl);
    }

    static {
        if (System.getProperty("os.arch").equals("x86")) {
            System.loadLibrary("libpxcclr.jni32");
        } else {
            System.loadLibrary("libpxcclr.jni64");
        }
    }

    private class SMHandler {
        private Handler jhandler;

        public pxcmStatus OnConnect(long l, boolean bl) {
            if (this.jhandler != null) {
                return this.jhandler.OnConnect(new PXCMCapture.Device(l, false), bl);
            }
            return pxcmStatus.PXCM_STATUS_NO_ERROR;
        }

        public pxcmStatus OnModuleSetProfile(int n, long l) {
            if (this.jhandler != null) {
                return this.jhandler.OnModuleSetProfile(n, new PXCMBase(l, false));
            }
            return pxcmStatus.PXCM_STATUS_NO_ERROR;
        }

        public pxcmStatus OnModuleProcessedFrame(int n, long l, long[] lArray) {
            if (this.jhandler != null) {
                int n2 = lArray.length;
                PXCMCapture.Sample sample = new PXCMCapture.Sample();
                if (n2 >= 1 && lArray[0] != 0L) {
                    sample.color = new PXCMImage(lArray[0], false);
                }
                if (n2 >= 2 && lArray[1] != 0L) {
                    sample.depth = new PXCMImage(lArray[1], false);
                }
                if (n2 >= 3 && lArray[2] != 0L) {
                    sample.ir = new PXCMImage(lArray[2], false);
                }
                if (n2 >= 4 && lArray[3] != 0L) {
                    sample.left = new PXCMImage(lArray[3], false);
                }
                if (n2 >= 5 && lArray[4] != 0L) {
                    sample.right = new PXCMImage(lArray[4], false);
                }
                for (int i = 0; i < 3; ++i) {
                    if (n2 < 5 + i || lArray[5 + i] == 0L) continue;
                    sample.reserved[i] = new PXCMImage(lArray[5 + i], false);
                }
                return this.jhandler.OnModuleProcessedFrame(n, new PXCMBase(l, false), sample);
            }
            return pxcmStatus.PXCM_STATUS_NO_ERROR;
        }

        public pxcmStatus OnNewSample(int n, long[] lArray) {
            if (this.jhandler != null && lArray.length > 0) {
                int n2 = lArray.length;
                PXCMCapture.Sample sample = new PXCMCapture.Sample();
                if (n2 >= 1 && lArray[0] != 0L) {
                    sample.color = new PXCMImage(lArray[0], false);
                }
                if (n2 >= 2 && lArray[1] != 0L) {
                    sample.depth = new PXCMImage(lArray[1], false);
                }
                if (n2 >= 3 && lArray[2] != 0L) {
                    sample.ir = new PXCMImage(lArray[2], false);
                }
                if (n2 >= 4 && lArray[3] != 0L) {
                    sample.left = new PXCMImage(lArray[3], false);
                }
                if (n2 >= 5 && lArray[4] != 0L) {
                    sample.right = new PXCMImage(lArray[4], false);
                }
                for (int i = 0; i < 3; ++i) {
                    if (n2 < 5 + i || lArray[5 + i] == 0L) continue;
                    sample.reserved[i] = new PXCMImage(lArray[5 + i], false);
                }
                return this.jhandler.OnNewSample(n, sample);
            }
            return pxcmStatus.PXCM_STATUS_NO_ERROR;
        }

        public void OnStatus(int n, pxcmStatus pxcmStatus2) {
            if (this.jhandler != null) {
                this.jhandler.OnStatus(n, pxcmStatus2);
            }
        }

        public SMHandler(Handler handler) {
            this.jhandler = handler;
        }
    }

    public static interface Handler {
        public pxcmStatus OnConnect(PXCMCapture.Device var1, boolean var2);

        public pxcmStatus OnModuleSetProfile(int var1, PXCMBase var2);

        public pxcmStatus OnModuleProcessedFrame(int var1, PXCMBase var2, PXCMCapture.Sample var3);

        public pxcmStatus OnNewSample(int var1, PXCMCapture.Sample var2);

        public void OnStatus(int var1, pxcmStatus var2);
    }
}

