/*
 * Decompiled with CFR 0.152.
 */
package intel.rssdk;

import intel.rssdk.PXCMAudioSource;
import intel.rssdk.PXCMBase;
import intel.rssdk.pxcmStatus;

public class PXCMSpeechRecognition
extends PXCMBase {
    public static final int CUID = -2146187993;
    public static final int NBEST_SIZE = 4;
    public static final int DICTATION_BUFFER_SIZE = 1024;
    public static final int TAG_BUFFER_SIZE = 1024;
    public static final int SENTENCE_BUFFER_SIZE = 1024;

    private static native pxcmStatus PXCMSpeechRecognition_QueryProfile(long var0, int var2, ProfileInfo var3);

    private static native pxcmStatus PXCMSpeechRecognition_SetProfile(long var0, ProfileInfo var2);

    private static native pxcmStatus PXCMSpeechRecognition_BuildGrammarFromStringList(long var0, int var2, String[] var3, int[] var4, int var5);

    private static native pxcmStatus PXCMSpeechRecognition_BuildGrammarFromFile(long var0, int var2, GrammarFileType var3, String var4);

    private static native pxcmStatus PXCMSpeechRecognition_BuildGrammarFromMemory(long var0, int var2, GrammarFileType var3, byte[] var4);

    private static native pxcmStatus PXCMSpeechRecognition_ReleaseGrammar(long var0, int var2);

    private static native pxcmStatus PXCMSpeechRecognition_SetGrammar(long var0, int var2);

    private static native String PXCMSpeechRecognition_GetGrammarCompileErrors(long var0, int var2);

    private static native pxcmStatus PXCMSpeechRecognition_AddVocabToDictation(long var0, VocabFileType var2, String var3);

    private static native pxcmStatus PXCMSpeechRecognition_StartRec(long var0, long var2, Handler var4, RecognitionData var5, AlertData var6);

    private static native void PXCMSpeechRecognition_StopRec(long var0);

    public pxcmStatus QueryProfile(int n, ProfileInfo profileInfo) {
        if (profileInfo == null) {
            return pxcmStatus.PXCM_STATUS_HANDLE_INVALID;
        }
        return PXCMSpeechRecognition.PXCMSpeechRecognition_QueryProfile(this.instance, n, profileInfo);
    }

    public pxcmStatus QueryProfile(ProfileInfo profileInfo) {
        return this.QueryProfile(-1, profileInfo);
    }

    public pxcmStatus SetProfile(ProfileInfo profileInfo) {
        return PXCMSpeechRecognition.PXCMSpeechRecognition_SetProfile(this.instance, profileInfo);
    }

    public pxcmStatus BuildGrammarFromStringList(int n, String[] stringArray, int[] nArray, int n2) {
        return PXCMSpeechRecognition.PXCMSpeechRecognition_BuildGrammarFromStringList(this.instance, n, stringArray, nArray, n2);
    }

    public pxcmStatus BuildGrammarFromFile(int n, GrammarFileType grammarFileType, String string) {
        return PXCMSpeechRecognition.PXCMSpeechRecognition_BuildGrammarFromFile(this.instance, n, grammarFileType, string);
    }

    public pxcmStatus BuildGrammarFromMemory(int n, GrammarFileType grammarFileType, byte[] byArray) {
        return PXCMSpeechRecognition.PXCMSpeechRecognition_BuildGrammarFromMemory(this.instance, n, grammarFileType, byArray);
    }

    public String GetGrammarCompileErrors(int n) {
        return PXCMSpeechRecognition.PXCMSpeechRecognition_GetGrammarCompileErrors(this.instance, n);
    }

    public pxcmStatus AddVocabToDictation(VocabFileType vocabFileType, String string) {
        return PXCMSpeechRecognition.PXCMSpeechRecognition_AddVocabToDictation(this.instance, vocabFileType, string);
    }

    public pxcmStatus SetGrammar(int n) {
        return PXCMSpeechRecognition.PXCMSpeechRecognition_SetGrammar(this.instance, n);
    }

    public pxcmStatus SetDictation() {
        return this.SetGrammar(0);
    }

    public pxcmStatus ReleaseGrammar(int n) {
        return PXCMSpeechRecognition.PXCMSpeechRecognition_ReleaseGrammar(this.instance, n);
    }

    public pxcmStatus StartRec(PXCMAudioSource pXCMAudioSource, Handler handler) {
        RecognitionData recognitionData = new RecognitionData();
        AlertData alertData = new AlertData();
        return PXCMSpeechRecognition.PXCMSpeechRecognition_StartRec(this.instance, pXCMAudioSource.instance, handler, recognitionData, alertData);
    }

    public void StopRec() {
        PXCMSpeechRecognition.PXCMSpeechRecognition_StopRec(this.instance);
    }

    public PXCMSpeechRecognition() {
        super(0L, true);
    }

    PXCMSpeechRecognition(long l, boolean bl) {
        super(l, bl);
    }

    static enum VocabFileType {
        VFT_NONE,
        VFT_LIST;

    }

    public static enum GrammarFileType {
        GFT_NONE,
        GFT_LIST,
        GFT_JSGF,
        GFT_COMPILED_CONTEXT;

    }

    public static class ProfileInfo {
        public String speaker = "";
        public LanguageType language = LanguageType.LANGUAGE_US_ENGLISH;
        public int endOfSentence = 200;
        public int threshold = 0;
    }

    public static enum LanguageType {
        LANGUAGE_US_ENGLISH,
        LANGUAGE_GB_ENGLISH,
        LANGUAGE_DE_GERMAN,
        LANGUAGE_US_SPANISH,
        LANGUAGE_LA_SPANISH,
        LANGUAGE_FR_FRENCH,
        LANGUAGE_IT_ITALIAN,
        LANGUAGE_JP_JAPANESE,
        LANGUAGE_CN_CHINESE,
        LANGUAGE_BR_PORTUGUESE,
        LANGUAGE_RU_RUSSIAN;

    }

    public static interface Handler {
        public void OnRecognition(RecognitionData var1);

        public void OnAlert(AlertData var1);
    }

    public static class AlertData {
        public long timeStamp;
        public AlertType label;
    }

    public static enum AlertType {
        ALERT_VOLUME_HIGH(1),
        ALERT_VOLUME_LOW(2),
        ALERT_SNR_LOW(4),
        ALERT_SPEECH_UNRECOGNIZABLE(8),
        ALERT_SPEECH_BEGIN(16),
        ALERT_SPEECH_END(32),
        ALERT_RECOGNITION_ABORTED(64),
        ALERT_RECOGNITION_END(128);

        public int value;

        private AlertType(int n2) {
            this.value = n2;
        }
    }

    public static class RecognitionData {
        public long timeStamp;
        public int grammar;
        public int duration;
        public NBest[] scores = new NBest[4];
    }

    public static class NBest {
        public int label;
        public int confidence;
        public String sentence = "";
        public String tags = "";
    }
}

