#include <quicktime/lqt.h>
#include <quicktime/lqt_codecapi.h>
#include <quicktime/colormodels.h>

#include "cinepak.h"

static char * fourccs_cinepak[]  = { "cvid", (char*)0 };

static lqt_codec_info_static_t codec_info_cinepak =
  {
  name:        "cinepak",
  long_name:   "Radius Cinepak",
  description: "Cinepak decoder, based on code from Tim Ferguson (http://www.csse.monash.edu.au/~timf/)",
  fourccs:     fourccs_cinepak,
  type:        LQT_CODEC_VIDEO,
  direction:   LQT_DIRECTION_DECODE,
  encoding_parameters: (lqt_parameter_info_static_t*)0,
  decoding_parameters: (lqt_parameter_info_static_t*)0,
  encoding_colormodels: (int*)0,
  decoding_colormodel: BC_BGR8888
  };

extern int get_num_codecs() { return 1; }

extern lqt_codec_info_static_t * get_codec_info(int index)
  {
  switch(index)
    {
    case 0:
      return &codec_info_cinepak;
    }
  return (lqt_codec_info_static_t*)0;
  }

extern lqt_init_video_codec_func_t get_video_codec(int index)
  {
  switch(index)
    {
    case 0:
      return init_codec_cinepak;
    }
  return (lqt_init_video_codec_func_t)0;
  }
