/**************************************************************************
 *                                                                        *
 * This code has been developed by Andrea Graziani. This software is an   *
 * implementation of a part of one or more MPEG-4 Video tools as          *
 * specified in ISO/IEC 14496-2 standard.  Those intending to use this    *
 * software module in hardware or software products are advised that its  *
 * use may infringe existing patents or copyrights, and any such use      *
 * would be at such party's own risk.  The original developer of this     *
 * software module and his/her company, and subsequent editors and their  *
 * companies (including Project Mayo), will have no liability for use of  *
 * this software or modifications or derivatives thereof.                 *
 *                                                                        *
 * Project Mayo gives users of the Codec a license to this software       *
 * module or modifications thereof for use in hardware or software        *
 * products claiming conformance to the MPEG-4 Video Standard as          *
 * described in the Open DivX license.                                    *
 *                                                                        *
 * The complete Open DivX license can be found at                         *
 * http://www.projectmayo.com/opendivx/license.php                        *
 *                                                                        *
 **************************************************************************/
/**
*  Copyright (C) 2001 - Project Mayo
 *
 * Andrea Graziani (Ag)
 * Jonathan White
 *
 * DivX Advanced Research Center <darc@projectmayo.com>
*
**/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "portab.h"
#include "mp4_vars.h"


extern	unsigned int zig_zag_scan[64];
extern	unsigned int alternate_horizontal_scan[64];
extern	unsigned int alternate_vertical_scan[64];
extern	unsigned int intra_quant_matrix[64];
extern	unsigned int nonintra_quant_matrix[64];


extern	unsigned int msk[33];
extern	int roundtab[16];
extern	int saiAcLeftIndex[8];
extern	int DQtab[4];
extern	tab_type MCBPCtabIntra[32];
extern	tab_type MCBPCtabInter[256];
extern	tab_type CBPYtab[48];
extern	tab_type MVtab0[14];
extern	tab_type MVtab1[96];
extern	tab_type MVtab2[124];
extern	tab_type tableB16_1[112];
extern	tab_type tableB16_2[96];
extern	tab_type tableB16_3[120];
extern	tab_type tableB17_1[112];
extern	tab_type tableB17_2[96];
extern	tab_type tableB17_3[120];


void save_tables(MP4_TABLES * tables) 
{
	// FILE * ftables;

	memcpy(tables->zig_zag_scan, zig_zag_scan, sizeof(zig_zag_scan));
	memcpy(tables->alternate_vertical_scan, alternate_vertical_scan, sizeof(alternate_vertical_scan));
	memcpy(tables->alternate_horizontal_scan, alternate_horizontal_scan, sizeof(alternate_horizontal_scan));
	memcpy(tables->intra_quant_matrix, intra_quant_matrix, sizeof(intra_quant_matrix));
	memcpy(tables->nonintra_quant_matrix, nonintra_quant_matrix, sizeof(nonintra_quant_matrix));
	memcpy(tables->msk, msk, sizeof(msk));
	memcpy(tables->roundtab, roundtab, sizeof(roundtab));
	memcpy(tables->saiAcLeftIndex, saiAcLeftIndex, sizeof( saiAcLeftIndex));
	memcpy(tables->DQtab, DQtab, sizeof( DQtab));
	memcpy(tables->MCBPCtabIntra, MCBPCtabIntra, sizeof( MCBPCtabIntra));
	memcpy(tables->MCBPCtabInter, MCBPCtabInter, sizeof( MCBPCtabInter));
	memcpy(tables->CBPYtab, CBPYtab, sizeof( CBPYtab));
	memcpy(tables->MVtab0, MVtab0, sizeof( MVtab0));
	memcpy(tables->MVtab1, MVtab1, sizeof( MVtab1));
	memcpy(tables->MVtab2, MVtab2, sizeof( MVtab2));
	memcpy(tables->tableB16_1, tableB16_1, sizeof( tableB16_1));
	memcpy(tables->tableB16_2, tableB16_2, sizeof( tableB16_2));
	memcpy(tables->tableB16_3, tableB16_3, sizeof( tableB16_3));
	memcpy(tables->tableB17_1, tableB17_1, sizeof( tableB17_1));
	memcpy(tables->tableB17_2, tableB17_2, sizeof( tableB17_2));
	memcpy(tables->tableB17_3, tableB17_3, sizeof( tableB17_3));

	// ftables = fopen("mp4_tables.bin", "wb");	
	// fwrite(tables, sizeof(char), sizeof(MP4_TABLES), ftables);
	// fclose(ftables);
}

// zig-zag scan
unsigned int zig_zag_scan[64] =
{
  0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5,
  12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28,
  35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51,
  58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63
};

// other scan orders
unsigned int alternate_horizontal_scan[64] =
{
   0,  1,  2,  3,  8,  9, 16, 17, 
	10, 11,  4,  5,  6,  7, 15, 14,
  13, 12, 19, 18, 24, 25, 32, 33, 
	26, 27, 20, 21, 22, 23, 28, 29,
  30, 31, 34, 35, 40, 41, 48, 49, 
	42, 43, 36, 37, 38, 39, 44, 45,
  46, 47, 50, 51, 56, 57, 58, 59, 
	52, 53, 54, 55, 60, 61, 62, 63
};

unsigned int alternate_vertical_scan[64] =
{
   0,  8, 16, 24,  1,  9,  2, 10, 
	17, 25, 32, 40, 48, 56, 57, 49,
  41, 33, 26, 18,  3, 11,  4, 12, 
	19, 27, 34, 42, 50, 58, 35, 43,
  51, 59, 20, 28,  5, 13,  6, 14, 
	21, 29, 36, 44, 52, 60, 37, 45,
  53, 61, 22, 30,  7, 15, 23, 31, 
	38, 46, 54, 62, 39, 47, 55, 63
};

unsigned int intra_quant_matrix[64] = 
{
	 8,17,18,19,21,23,25,27,
	17,18,19,21,23,25,27,28,
	20,21,22,23,24,26,28,30,
	21,22,23,24,26,28,30,32,
	22,23,24,26,28,30,32,35,
	23,24,26,28,30,32,35,38,
	25,26,28,30,32,35,38,41,
	27,28,30,32,35,38,41,45
};

unsigned int nonintra_quant_matrix[64] =
{
	16,17,18,19,20,21,22,23,
	17,18,19,20,21,22,23,24,
	18,19,20,21,22,23,24,25,
	19,20,21,22,23,24,26,27,
	20,21,22,23,25,26,27,28,
	21,22,23,24,26,27,28,30,
	22,23,24,26,27,28,30,31,
	23,24,25,27,28,30,31,33
};

// to mask the n least significant bits of an integer 
unsigned int msk[33] =
{
  0x00000000, 0x00000001, 0x00000003, 0x00000007,
  0x0000000f, 0x0000001f, 0x0000003f, 0x0000007f,
  0x000000ff, 0x000001ff, 0x000003ff, 0x000007ff,
  0x00000fff, 0x00001fff, 0x00003fff, 0x00007fff,
  0x0000ffff, 0x0001ffff, 0x0003ffff, 0x0007ffff,
  0x000fffff, 0x001fffff, 0x003fffff, 0x007fffff,
  0x00ffffff, 0x01ffffff, 0x03ffffff, 0x07ffffff,
  0x0fffffff, 0x1fffffff, 0x3fffffff, 0x7fffffff,
  0xffffffff
};

int roundtab[16] = {0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2};

int saiAcLeftIndex[8] = 
{
	0, 8,16,24,32,40,48,56
};

int DQtab[4] = {
	-1, -2, 1, 2
};

tab_type MCBPCtabIntra[32] = {
	{-1,0},
	{20,6}, {36,6}, {52,6}, {4,4}, {4,4}, {4,4}, 
	{4,4}, {19,3}, {19,3}, {19,3}, {19,3}, {19,3}, 
	{19,3}, {19,3}, {19,3}, {35,3}, {35,3}, {35,3}, 
	{35,3}, {35,3}, {35,3}, {35,3}, {35,3}, {51,3}, 
	{51,3}, {51,3}, {51,3}, {51,3}, {51,3}, {51,3}, 
	{51,3},
};

tab_type MCBPCtabInter[256] = {
	{-1,0}, 
	{255,9}, {52,9}, {36,9}, {20,9}, {49,9}, {35,8}, {35,8}, {19,8}, {19,8},
	{50,8}, {50,8}, {51,7}, {51,7}, {51,7}, {51,7}, {34,7}, {34,7}, {34,7},
	{34,7}, {18,7}, {18,7}, {18,7}, {18,7}, {33,7}, {33,7}, {33,7}, {33,7}, 
	{17,7}, {17,7}, {17,7}, {17,7}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, 
	{4,6}, {4,6}, {4,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6}, 
	{48,6}, {48,6}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, 
	{3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, 
	{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
	{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
	{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, 
	{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
	{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
	{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
	{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, 
	{16,4}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
	{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
	{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
	{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
	{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
	{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
	{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, 
	{2,3}, {2,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
	{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
	{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
	{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
	{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
	{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
	{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, 
	{1,3}, {1,3}, {1,3}, 
};

tab_type CBPYtab[48] = 
{ 
	{-1,0}, {-1,0}, {6,6},  {9,6},  {8,5},  {8,5},  {4,5},  {4,5},
	{2,5},  {2,5},  {1,5},  {1,5},  {0,4},  {0,4},  {0,4},  {0,4}, 
  {12,4}, {12,4}, {12,4}, {12,4}, {10,4}, {10,4}, {10,4}, {10,4},
  {14,4}, {14,4}, {14,4}, {14,4}, {5,4},  {5,4},  {5,4},  {5,4},
  {13,4}, {13,4}, {13,4}, {13,4}, {3,4},  {3,4},  {3,4},  {3,4}, 
  {11,4}, {11,4}, {11,4}, {11,4}, {7,4},  {7,4},  {7,4},  {7,4}, 
};

tab_type MVtab0[14] =
{
	{3,4}, {-3,4}, {2,3}, {2,3}, {-2,3}, {-2,3}, {1,2}, {1,2}, {1,2}, {1,2},
	{-1,2}, {-1,2}, {-1,2}, {-1,2}
};

tab_type MVtab1[96] = 
{
	{12,10}, {-12,10}, {11,10}, {-11,10}, {10,9}, {10,9}, {-10,9}, {-10,9},
	{9,9}, {9,9}, {-9,9}, {-9,9}, {8,9}, {8,9}, {-8,9}, {-8,9}, {7,7}, {7,7},
	{7,7}, {7,7}, {7,7}, {7,7}, {7,7}, {7,7}, {-7,7}, {-7,7}, {-7,7}, {-7,7},
	{-7,7}, {-7,7}, {-7,7}, {-7,7}, {6,7}, {6,7}, {6,7}, {6,7}, {6,7}, {6,7},
	{6,7}, {6,7}, {-6,7}, {-6,7}, {-6,7}, {-6,7}, {-6,7}, {-6,7}, {-6,7},
	{-6,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {-5,7},
	{-5,7}, {-5,7}, {-5,7}, {-5,7}, {-5,7}, {-5,7}, {-5,7}, {4,6}, {4,6}, {4,6},
	{4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6},
	{4,6}, {4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6},
	{-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}, {-4,6}
};

tab_type MVtab2[124] = 
{
	{32,12}, {-32,12}, {31,12}, {-31,12}, {30,11}, {30,11}, {-30,11}, {-30,11},
	{29,11}, {29,11}, {-29,11}, {-29,11}, {28,11}, {28,11}, {-28,11}, {-28,11},
	{27,11}, {27,11}, {-27,11}, {-27,11}, {26,11}, {26,11}, {-26,11}, {-26,11},
	{25,11}, {25,11}, {-25,11}, {-25,11}, {24,10}, {24,10}, {24,10}, {24,10},
	{-24,10}, {-24,10}, {-24,10}, {-24,10}, {23,10}, {23,10}, {23,10}, {23,10},
	{-23,10}, {-23,10}, {-23,10}, {-23,10}, {22,10}, {22,10}, {22,10}, {22,10},
	{-22,10}, {-22,10}, {-22,10}, {-22,10}, {21,10}, {21,10}, {21,10}, {21,10},
	{-21,10}, {-21,10}, {-21,10}, {-21,10}, {20,10}, {20,10}, {20,10}, {20,10},
	{-20,10}, {-20,10}, {-20,10}, {-20,10}, {19,10}, {19,10}, {19,10}, {19,10},
	{-19,10}, {-19,10}, {-19,10}, {-19,10}, {18,10}, {18,10}, {18,10}, {18,10},
	{-18,10}, {-18,10}, {-18,10}, {-18,10}, {17,10}, {17,10}, {17,10}, {17,10},
	{-17,10}, {-17,10}, {-17,10}, {-17,10}, {16,10}, {16,10}, {16,10}, {16,10},
	{-16,10}, {-16,10}, {-16,10}, {-16,10}, {15,10}, {15,10}, {15,10}, {15,10},
	{-15,10}, {-15,10}, {-15,10}, {-15,10}, {14,10}, {14,10}, {14,10}, {14,10},
	{-14,10}, {-14,10}, {-14,10}, {-14,10}, {13,10}, {13,10}, {13,10}, {13,10},
	{-13,10}, {-13,10}, {-13,10}, {-13,10}
};

/*** REVIEW  * This tables have been automatically generated!

// tables to decode Table B16 VLC - 112 values

tab_type tableB16_1[112] = 
{ 
	{4353, 7},  {4289, 7},  {385, 7},  {4417, 7},  {449, 7},  {130, 7},  {67, 7},  {9, 7},  {4098, 6},  {4098, 6},  
	{321, 6},  {321, 6},  {4225, 6},  {4225, 6},  {4161, 6},  {4161, 6},  {257, 6},  {257, 6},  {193, 6},  {193, 6},  
	{8, 6},  {8, 6},  {7, 6},  {7, 6},  {66, 6},  {66, 6},  {6, 6},  {6, 6},  {129, 5},  {129, 5},  
	{129, 5},  {129, 5},  {5, 5},  {5, 5},  {5, 5},  {5, 5},  {4, 5},  {4, 5},  {4, 5},  {4, 5},  
	{4097, 4},  {4097, 4},  {4097, 4},  {4097, 4},  {4097, 4},  {4097, 4},  {4097, 4},  {4097, 4},  {1, 2},  {1, 2},  
	{1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  
	{1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  
	{1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  {1, 2},  
	{2, 3},  {2, 3},  {2, 3},  {2, 3},  {2, 3},  {2, 3},  {2, 3},  {2, 3},  {2, 3},  {2, 3},  
	{2, 3},  {2, 3},  {2, 3},  {2, 3},  {2, 3},  {2, 3},  {65, 4},  {65, 4},  {65, 4},  {65, 4},  
	{65, 4},  {65, 4},  {65, 4},  {65, 4},  {3, 4},  {3, 4},  {3, 4},  {3, 4},  {3, 4},  {3, 4},  
	{3, 4},  {3, 4} 
};

tab_type tableB16_2[96] = 
{ 
	{18, 10},  {17, 10},  {4993, 9},  {4993, 9},  {4929, 9},  {4929, 9},  {4865, 9}, {4865, 9}, {4801, 9}, {4801, 9},
	{4737, 9}, {4737, 9}, {4162, 9},  {4162, 9},  {4100, 9},  {4100, 9},  {769, 9},  {769, 9},  {705, 9},  {705, 9},
	{450, 9},  {450, 9},  {386, 9},   {386, 9},   {322, 9},   {322, 9},   {195, 9},  {195, 9},  {131, 9},  {131, 9},
	{70, 9},   {70, 9},   {69, 9},    {69, 9},    {16, 9},    {16, 9},    {258, 9},  {258, 9},  {15, 9},   {15, 9},
	{14, 9},   {14, 9},   {13, 9},    {13, 9},    {4609, 8},  {4609, 8},  {4609, 8}, {4609, 8}, {4545, 8}, {4545, 8},
	{4545, 8}, {4545, 8}, {4481, 8},  {4481, 8},  {4481, 8},  {4481, 8},  {4099, 8}, {4099, 8}, {4099, 8}, {4099, 8},
	{641, 8},  {641, 8},  {641, 8},   {641, 8},   {577, 8},   {577, 8},   {577, 8},  {577, 8},  {513, 8},  {513, 8},
	{513, 8},  {513, 8},  {4673, 8},  {4673, 8},  {4673, 8},  {4673, 8},  {194, 8},  {194, 8},  {194, 8},  {194, 8},
	{68, 8},   {68, 8},   {68, 8},    {68, 8},    {12, 8},    {12, 8},    {12, 8},   {12, 8},   {11, 8},   {11, 8},
	{11, 8},   {11, 8},   {10, 8},    {10, 8},    {10, 8},    {10, 8}
};

tab_type tableB16_3[120] = 
{ 
	{4103, 11}, {4103, 11}, {4102, 11}, {4102, 11},  {22, 11},   {22, 11},   {21, 11},   {21, 11},   {4226, 10},  {4226, 10},
	{4226, 10}, {4226, 10}, {4163, 10}, {4163, 10},  {4163, 10}, {4163, 10}, {4101, 10}, {4101, 10}, {4101, 10},  {4101, 10},
	{833, 10},  {833, 10},  {833, 10},  {833, 10},   {323, 10},  {323, 10},  {323, 10},  {323, 10},  {514, 10},   {514, 10},
	{514, 10},  {514, 10},  {259, 10},  {259, 10},   {259, 10},  {259, 10},  {196, 10},  {196, 10},  {196, 10},   {196, 10},
	{132, 10},  {132, 10},  {132, 10},  {132, 10},   {71, 10},   {71, 10},   {71, 10},   {71, 10},   {20, 10},    {20, 10},
	{20, 10},   {20, 10},   {19, 10},   {19, 10},    {19, 10},   {19, 10},   {23, 11},   {23, 11},   {24, 11},    {24, 11},
	{72, 11},   {72, 11},   {578, 11},  {578, 11},   {4290, 11}, {4290, 11}, {4354, 11}, {4354, 11}, {5057, 11},  {5057, 11},
	{5121, 11}, {5121, 11}, {25, 12},   {26, 12},    {27, 12},   {73, 12},   {387, 12},  {74, 12},   {133, 12},   {451, 12},
	{897, 12},  {4104, 12}, {4418, 12}, {4482, 12},  {5185, 12}, {5249, 12}, {5313, 12}, {5377, 12}, {7167, 7},   {7167, 7},
	{7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},   {7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},   {7167, 7},
	{7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},   {7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},   {7167, 7},
	{7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},   {7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},  {7167, 7},   {7167, 7}
};

// tables to decode Table B17 VLC

tab_type tableB17_1[112] = 
{ 
	{4225,7}, {4209,7}, {4193,7}, {4177,7}, {193,7},  {177,7},  {161,7},  {4,7},    {4161,6}, {4161,6},
	{4145,6}, {4145,6}, {4129,6}, {4129,6}, {4113,6}, {4113,6}, {145,6},  {145,6},  {129,6},  {129,6},
	{113,6},  {113,6},  {97,6},   {97,6},   {18,6},   {18,6},   {3,6},    {3,6},    {81,5},   {81,5},
	{81,5},   {81,5},   {65,5},   {65,5},   {65,5},   {65,5},   {49,5},   {49,5},   {49,5},   {49,5},
	{4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4}, {1,2},    {1,2},
	{1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2}, 
	{1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2}, 
	{1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2},    {1,2}, 
	{17,3},   {17,3},   {17,3},   {17,3},   {17,3},   {17,3},   {17,3},   {17,3},   {17,3},   {17,3}, 
	{17,3},   {17,3},   {17,3},   {17,3},   {17,3},   {17,3},   {33,4},   {33,4},   {33,4},   {33,4}, 
	{33,4},   {33,4},   {33,4},   {33,4},   {2,4},    {2,4},    {2,4},    {2,4},    {2,4},    {2,4},
	{2,4},    {2,4}
};

tab_type tableB17_2[96] = 
{ 
	{9,10},   {8,10},   {4481,9}, {4481,9}, {4465,9}, {4465,9}, {4449,9}, {4449,9}, {4433,9}, {4433,9}, 
	{4417,9}, {4417,9}, {4401,9}, {4401,9}, {4385,9}, {4385,9}, {4369,9}, {4369,9}, {4098,9}, {4098,9}, 
	{353,9},  {353,9},  {337,9},  {337,9},  {321,9},  {321,9},  {305,9},  {305,9},  {289,9},  {289,9},
	{273,9},  {273,9},  {257,9},  {257,9},  {241,9},  {241,9},  {66,9},   {66,9},   {50,9},   {50,9},
	{7,9},    {7,9},    {6,9},    {6,9},    {4353,8}, {4353,8}, {4353,8}, {4353,8}, {4337,8}, {4337,8}, 
	{4337,8}, {4337,8}, {4321,8}, {4321,8}, {4321,8}, {4321,8}, {4305,8}, {4305,8}, {4305,8}, {4305,8}, 
	{4289,8}, {4289,8}, {4289,8}, {4289,8}, {4273,8}, {4273,8}, {4273,8}, {4273,8}, {4257,8}, {4257,8}, 
	{4257,8}, {4257,8}, {4241,8}, {4241,8}, {4241,8}, {4241,8}, {225,8},  {225,8},  {225,8},  {225,8}, 
	{209,8},  {209,8},  {209,8},  {209,8},  {34,8},   {34,8},   {34,8},   {34,8},   {19,8},   {19,8},
	{19,8},   {19,8},   {5,8},    {5,8},    {5,8},    {5,8}
};

tab_type tableB17_3[120] = 
{ 
	{4114,11}, {4114,11}, {4099,11}, {4099,11}, {11,11},   {11,11},   {10,11},   {10,11},   {4545,10}, {4545,10}, 
	{4545,10}, {4545,10}, {4529,10}, {4529,10}, {4529,10}, {4529,10}, {4513,10}, {4513,10}, {4513,10}, {4513,10},
	{4497,10}, {4497,10}, {4497,10}, {4497,10}, {146,10},  {146,10},  {146,10},  {146,10},  {130,10},  {130,10}, 
	{130,10},  {130,10},  {114,10},  {114,10},  {114,10},  {114,10},  {98,10},   {98,10},   {98,10},   {98,10},
	{82,10},   {82,10},   {82,10},   {82,10},   {51,10},   {51,10},   {51,10},   {51,10},   {35,10},   {35,10},
	{35,10},   {35,10},   {20,10},   {20,10},   {20,10},   {20,10},   {12,11},   {12,11},   {21,11},   {21,11},
	{369,11},  {369,11},  {385,11},  {385,11},  {4561,11}, {4561,11}, {4577,11}, {4577,11}, {4593,11}, {4593,11},
	{4609,11}, {4609,11}, {22,12},   {36,12},   {67,12},   {83,12},   {99,12},   {162,12},  {401,12},  {417,12},
	{4625,12}, {4641,12}, {4657,12}, {4673,12}, {4689,12}, {4705,12}, {4721,12}, {4737,12}, {7167,7},  {7167,7},
	{7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},
	{7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},
	{7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7},  {7167,7}
};

***/
