#include <quicktime/lqt.h>
#include <quicktime/lqt_codecapi.h>
#include <quicktime/colormodels.h>
#include "divx.h"

static char * fourccs_divx[]  = { QUICKTIME_DIVX, (char*)0 };

static int encoding_colormodels_divx[] =
  {
    BC_YUV420P,
    LQT_COLORMODEL_NONE
  };

static lqt_parameter_info_static_t decode_parameters_divx[] =
  {
     {
       name:               "divx_postprocess",
       real_name:          "Postprocessing Level",
       type:               LQT_PARAMETER_INT,
       val_default:        {0 },
       val_min:            0,
       val_max:            100,
       stringlist_options: (char**)0
     },
     {}
  };

static lqt_parameter_info_static_t encode_parameters_divx[] =
  {
     {
       name:               "divx_bitrate",
       real_name:          "Bitrate",
       type:               LQT_PARAMETER_INT,
       val_default:        {1000000 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_rc_period",
       real_name:          "RC Peroid",
       type:               LQT_PARAMETER_INT,
       val_default:        { 50 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_rc_reaction_ratio",
       real_name:          "RC reaction ratio",
       type:               LQT_PARAMETER_INT,
       val_default:        { 45 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_rc_reaction_period",
       real_name:          "RC reaction period",
       type:               LQT_PARAMETER_INT,
       val_default:        { 10 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_max_key_interval",
       real_name:          "Max key interval",
       type:               LQT_PARAMETER_INT,
       val_default:        { 45 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_max_quantizer",
       real_name:          "Max quantizer",
       type:               LQT_PARAMETER_INT,
       val_default:        { 31 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_min_quantizer",
       real_name:          "Min quantizer",
       type:               LQT_PARAMETER_INT,
       val_default:        { 1 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_quantizer",
       real_name:          "Quantizer",
       type:               LQT_PARAMETER_INT,
       val_default:        { 10 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_quality",
       real_name:          "Quality",
       type:               LQT_PARAMETER_INT,
       val_default:        { 5 },
       val_min:            0,
       val_max:            0,
       stringlist_options: (char**)0
     },
     { 
       name:               "divx_fix_bitrate",
       real_name:          "Fixed bitrate",
       type:               LQT_PARAMETER_INT,
       val_default:        { 1 },
       val_min:            0,
       val_max:            1,
       stringlist_options: (char**)0
     },
     { /* End of array */ }
  };

static lqt_codec_info_static_t codec_info_divx =
  {
    name:        "opendivx",
    long_name:   "Opendivx",                  /* Long name of the codec */
    description: "MPEG4 based video codec",   /* Description            */
    fourccs:     fourccs_divx,
    type:        LQT_CODEC_VIDEO,
    direction:   LQT_DIRECTION_BOTH,
    encoding_parameters: encode_parameters_divx,
    decoding_parameters: decode_parameters_divx,
    encoding_colormodels: encoding_colormodels_divx,
    decoding_colormodel: BC_YUV420P
  };

/* These are called from the plugin loader */

extern int get_num_codecs() { return 1; }

extern lqt_codec_info_static_t * get_codec_info(int index)
  {
  if(!index)
    return &codec_info_divx;
  return (lqt_codec_info_static_t*)0;
  }
     

/*
 *   Return the actual codec constructor
 */

extern lqt_init_video_codec_func_t get_video_codec(int index)
  {
  if(index == 0)
    return quicktime_init_codec_divx;
  return (lqt_init_video_codec_func_t)0;
  }
