/*
 *  Definitions moved from svq1.c so we can access them from
 *  other sourcefiles
 */

#define SVQ1_FRAME_INTRA	0
#define SVQ1_FRAME_INTER	1
#define SVQ1_FRAME_DROPPABLE	2


/* memory bit stream */
typedef struct bit_buffer_s {
  uint8_t	*buffer;
  uint32_t	 bitpos;
} bit_buffer_t;

/* variable length (bit) code */
typedef struct vlc_code_s {
  int16_t	 value	:10,
		 length	:6;
} vlc_code_t;

/* motion vector (prediction) */
typedef struct svq1_pmv_s {
  int		 x;
  int		 y;
} svq1_pmv_t;

typedef struct svq1_s {
  int		 frame_code;
  int		 frame_type;
  int		 frame_width;
  int		 frame_height;
  int		 luma_width;
  int		 luma_height;
  int		 chroma_width;
  int		 chroma_height;
  svq1_pmv_t	*motion;
  uint8_t	*current;
  uint8_t	*previous;
  int		 offsets[3];
  int		 reference_frame;
 
  uint8_t	*base[3];
  int		 width;
  int		 height;
} svq1_t;

/* Actual decoding function */

int svq1_decode_frame (svq1_t *svq1, uint8_t *buffer);

void svq1_copy_frame (svq1_t *svq1, uint8_t *base[3], int pitch);
