#ifndef __xanim_h_
#define __xanim_h_


/*
 *  This contains all definitions and externs, which
 *  are moved from the xanim core to the codec library
 */

typedef int             xaLONG;
typedef unsigned int    xaULONG;
typedef short           xaSHORT;
typedef unsigned short  xaUSHORT;
typedef char            xaBYTE;
typedef unsigned char   xaUBYTE;

#define xaFALSE  0
#define xaTRUE   1
#define xaNOFILE 2
#define xaERROR  3
#define xaPAUSE  4


#define xaMIN(x,y)   ( ((x)>(y))?(y):(x) )
#define xaMAX(x,y)   ( ((x)>(y))?(x):(y) )
#define xaABS(x)     (((x)<0)?(-(x)):(x))

typedef struct
{
  xaUSHORT red,green,blue,gray;
} ColorReg;

typedef struct XA_ACTION_STRUCT
{
 xaLONG type;           /* type of action */
 xaLONG cmap_rev;          /* rev of cmap */
 xaUBYTE *data;         /* data ptr */
 struct XA_ACTION_STRUCT *next;
 struct XA_CHDR_STRUCT *chdr;
 ColorReg *h_cmap;      /* For IFF HAM images */
 xaULONG *map;
 struct XA_ACTION_STRUCT *next_same_chdr; /*ptr to next action with same cmap*/
} XA_ACTION;

typedef struct XA_CHDR_STRUCT
{
 xaLONG rev;
 ColorReg *cmap;
 xaULONG csize,coff;
 xaULONG *map;
 xaULONG msize,moff;
 struct XA_CHDR_STRUCT *next;
 XA_ACTION *acts;
 struct XA_CHDR_STRUCT *new_chdr;
} XA_CHDR;

/* REV 1 */
typedef struct
{
  xaULONG cmd;                  /* decode or query */
  xaULONG skip_flag;            /* skip_flag */
  xaULONG imagex,imagey;        /* Image Buffer Size */
  xaULONG imaged;               /* Image depth */
  XA_CHDR *chdr;                /* Color Map Header */
  xaULONG map_flag;             /* remap image? */
  xaULONG *map;                 /* map to use */
  xaULONG xs,ys;                /* pos of changed area */
  xaULONG xe,ye;                /* size of change area */
  xaULONG special;              /* Special Info */
  void *extra;                  /* Decompression specific info */
} XA_DEC_INFO;

/* DELTA Return VALUES */
#define ACT_DLTA_NORM   0x00000000   /* nothing special */
#define ACT_DLTA_BODY   0x00000001   /* IFF BODY - used for dbl buffer */
#define ACT_DLTA_XOR    0x00000002   /* delta work in both directions */
#define ACT_DLTA_NOP    0x00000004   /* delta didn't change anything */
#define ACT_DLTA_MAPD   0x00000008   /* delta was able to map image */
#define ACT_DLTA_DROP   0x00000010   /* drop this one */
#define ACT_DLTA_BAD    0x80000000   /* uninitialize value if needed */

#define XA_GRAYSCALE    0x06
#define XA_STATICGRAY   0x03
#define XA_PSEUDOCOLOR  0x14
#define XA_STATICCOLOR  0x11
#define XA_DIRECTCOLOR  0x18
#define XA_TRUECOLOR    0x19
#define XA_MONOCHROME   0x00

#define XA_X11_STATIC   0x01
#define XA_X11_GRAY     0x02
#define XA_X11_CMAP     0x04
#define XA_X11_TRUE     0x08
#define XA_X11_COLOR    0x10


extern int xa_debug;
extern int xa_verbose;
extern int xa_optimize_flag;

extern int cmap_color_func;
extern int cmap_true_to_332;

#define DEBUG_LEVEL1   if (xa_debug >= 1) 
#define DEBUG_LEVEL2   if (xa_debug >= 2) 
#define DEBUG_LEVEL3   if (xa_debug >= 3) 
#define DEBUG_LEVEL4   if (xa_debug >= 4) 
#define DEBUG_LEVEL5   if (xa_debug >= 5) 
#define DEBUG_LEVEL1   if (xa_debug >= 1)
#define DEBUG_LEVEL2   if (xa_debug >= 2)
#define DEBUG_LEVEL3   if (xa_debug >= 3)
#define DEBUG_LEVEL4   if (xa_debug >= 4)
#define DEBUG_LEVEL5   if (xa_debug >= 5)

#define x11_bytes_pixel 4

extern xaLONG x11_cmap_size;
extern int xa_dither_flag;
 
extern int x11_display_type;

extern xaUSHORT xa_gamma_adj[256];
extern xaUSHORT qt_gamma_adj[32];

extern xaULONG xa_gamma_flag;

/*
 * Init function: Set up all tables and must be called at least once at
 * the beginning
 */

void init_xanimcodecs();

void xanim_create_qt_colormap(XA_DEC_INFO * info, int depth, char * fourcc);

/* extern YUVBufs jpg_YUVBufs; */

xaULONG X11_Get_True_Color(xaULONG r,xaULONG g,xaULONG b,xaULONG bits);

xaULONG AVI_Get_Color(xaULONG color,xaULONG map_flag,xaULONG * map,
                      XA_CHDR *chdr);

#endif
