#include "libxanimcodecs/xanim.h"
#include "libxanimcodecs/xa_dec2.h"

/* Fourcc definitions (not all are supported!) */

#define LQT_rle    "rle "
#define LQT_smc    "smc "
#define LQT_rpza   "rpza"
#define LQT_azpr   "azpr"
#define LQT_CVID   "CVID"
#define LQT_cvid   "cvid"
#define LQT_jpeg   "jpeg"
#define LQT_MJPG   "MJPG"
#define LQT_mjpg   "mjpg"
#define LQT_mjpa   "mjpa"
#define LQT_mjpb   "mjpb"
#define LQT_SPIG   "SPIG"
#define LQT_yuv2   "yuv2"
#define LQT_PGVV   "PGVV"
#define LQT_YUV9   "YVU9"
#define LQT_YVU9   "YUV9"
#define LQT_RT21   "RT21"
#define LQT_rt21   "rt21"
#define LQT_IV31   "IV31"
#define LQT_iv31   "iv31"
#define LQT_IV32   "IV32"
#define LQT_iv32   "iv32"
#define LQT_IV41   "IV41"
#define LQT_iv41   "iv41"
#define LQT_kpcd   "kpcd"
#define LQT_KPCD   "KPCD"
#define LQT_cram  "cram"
#define LQT_CRAM  "CRAM"
#define LQT_wham  "wham"
#define LQT_WHAM  "WHAM"
#define LQT_msvc  "msvc"
#define LQT_MSVC  "MSVC"
#define LQT_SVQ1  "SVQ1"
#define LQT_UCOD  "UCOD"
#define LQT_8BPS  "8BPS"

#define LQT_raw "raw "
#define LQT_raw3 "raw3"

void lqt_xanim_init_codec_rle(quicktime_video_map_t *vtrack);

void lqt_xanim_init_codec_cram(quicktime_video_map_t *vtrack);

void lqt_xanim_init_codec_raw(quicktime_video_map_t *vtrack);

void lqt_xanim_init_codec_smc(quicktime_video_map_t *vtrack);

void lqt_xanim_init_codec_rpza(quicktime_video_map_t *vtrack);

void lqt_xanim_init_codec_8bps(quicktime_video_map_t *vtrack);

/* Xanim has 3 Codec API layers: 1 and 2 are for internal use, 3 is for dynamic codecs */

typedef struct
  {
  int initialized;
  xaULONG (*decode_func)(xaUBYTE *, xaUBYTE *, xaULONG, XA_DEC_INFO *);

  char * work_buffer;
  int work_buffer_size;

  unsigned char * pixel_buffer;
  unsigned char ** pixel_buffer_rows;

  int width;
  int height;
  int depth;
  
  XA_DEC_INFO info;
  } lqt_xanim_codec_1_t;

typedef struct
  {
  int initialized;
  xaULONG (*decode_func)(xaUBYTE *, xaUBYTE *, xaULONG, XA_DEC2_INFO *);

  char * work_buffer;
  int work_buffer_size;
  
  XA_DEC2_INFO info;
  } lqt_xanim_codec_2_t;

int lqt_xanim_decode_video_1(quicktime_t *file, unsigned char **row_pointers, 
                              int track);

int lqt_xanim_decode_video_2(quicktime_t *file, unsigned char **row_pointers, 
                              int track);

int lqt_xanim_delete_vcodec_1(quicktime_video_map_t *vtrack);

int lqt_xanim_delete_vcodec_2(quicktime_video_map_t *vtrack);

void lqt_xanim_init_vcodec_1(quicktime_t * file, int track);

void lqt_xanim_init_vcodec_2(quicktime_t * file, int track);

int lqt_xanim_reads_colormodel(quicktime_t * file, int colormodel, int track);

void lqt_xanim_alloc_temp_frame_1(quicktime_t * file, int track);
  

/*
 * Xanim colormodel, can be changed in libxanimcodecs/xanim.c,
 * It should be enough to suport only one colormodel and BC_RGB888
 * (with conversion)
 */

#define XANIM_COLORMODEL BC_BGR8888 /* Don't know, if this will change */
