#ifndef DRW_CPTABLE932_H
#define DRW_CPTABLE932_H

//Japanese

//first entry in this table are 0xA1
#define CPOFFSET932 0xFEC0
//#define CP1LENGHT932 63
#define CPLENGHT932 7724
#define NOTFOUND932 0x30FB

//Table 932 one byte are
//from 0xA1 -> 0xFF61
//to   0xDF .> 0xFF9F
static const int DRW_Table932[] = {
};

//Table 932 lead byte
//pairs of start/end in DRW_DoubleTable932
static const int DRW_LeadTable932[] = {
    0,  //1 #DBCS LEAD BYTE 0x81
    147,  //2 #DBCS LEAD BYTE 0x82
    292,  //3 #DBCS LEAD BYTE 0x83
    426,  //4 #DBCS LEAD BYTE 0x84
    524,  //5 #DBCS LEAD BYTE 0x85, empty
    524,  //6 #DBCS LEAD BYTE 0x86, empty
    524,  //7 #DBCS LEAD BYTE 0x87
    607,  //8 #DBCS LEAD BYTE 0x88
    701,  //9 #DBCS LEAD BYTE 0x89
    889,  //10 #DBCS LEAD BYTE 0x8A
    1077,  //11 #DBCS LEAD BYTE 0x8B
    1265,  //12 #DBCS LEAD BYTE 0x8C
    1453,  //13 #DBCS LEAD BYTE 0x8D
    1641,  //14 #DBCS LEAD BYTE 0x8E
    1829,  //15 #DBCS LEAD BYTE 0x8F
    2017,  //16 #DBCS LEAD BYTE 0x90
    2205,  //17 #DBCS LEAD BYTE 0x91
    2393,  //18 #DBCS LEAD BYTE 0x92
    2581,  //19 #DBCS LEAD BYTE 0x93
    2769,  //20 #DBCS LEAD BYTE 0x94
    2957,  //21 #DBCS LEAD BYTE 0x95
    3145,  //22 #DBCS LEAD BYTE 0x96
    3333,  //23 #DBCS LEAD BYTE 0x97
    3521,  //24 #DBCS LEAD BYTE 0x98
    3666,  //25 #DBCS LEAD BYTE 0x99
    3854,  //26 #DBCS LEAD BYTE 0x9A
    4042,  //27 #DBCS LEAD BYTE 0x9B
    4230,  //28 #DBCS LEAD BYTE 0x9C
    4418,  //29 #DBCS LEAD BYTE 0x9D
    4606,  //30 #DBCS LEAD BYTE 0x9E
    4794,  //31 #DBCS LEAD BYTE 0x9F
//0xA0 to 0xDF are empty
    4982,  //32 #DBCS LEAD BYTE 0xE0
    5170,  //33 #DBCS LEAD BYTE 0xE1
    5358,  //34 #DBCS LEAD BYTE 0xE2
    5546,  //35 #DBCS LEAD BYTE 0xE3
    5734,  //36 #DBCS LEAD BYTE 0xE4
    5922,  //37 #DBCS LEAD BYTE 0xE5
    6110,  //38 #DBCS LEAD BYTE 0xE6
    6298,  //39 #DBCS LEAD BYTE 0xE7
    6486,  //40 #DBCS LEAD BYTE 0xE8
    6674,  //41 #DBCS LEAD BYTE 0xE9
    6862,  //42 #DBCS LEAD BYTE 0xEA
    6962,  //43 #DBCS LEAD BYTE 0xEB, empty
    6962,  //44 #DBCS LEAD BYTE 0xEC, empty
    6962,  //45 #DBCS LEAD BYTE 0xED
    7150,  //46 #DBCS LEAD BYTE 0xEE
    7336,  //47 #DBCS LEAD BYTE 0xEF, empty
    7336,  //48 #DBCS LEAD BYTE 0xF0, empty
    7336,  //49 #DBCS LEAD BYTE 0xF1, empty
    7336,  //50 #DBCS LEAD BYTE 0xF2, empty
    7336,  //51 #DBCS LEAD BYTE 0xF3, empty
    7336,  //52 #DBCS LEAD BYTE 0xF4, empty
    7336,  //53 #DBCS LEAD BYTE 0xF5, empty
    7336,  //54 #DBCS LEAD BYTE 0xF6, empty
    7336,  //55 #DBCS LEAD BYTE 0xF7, empty
    7336,  //56 #DBCS LEAD BYTE 0xF8, empty
    7336,  //57 #DBCS LEAD BYTE 0xF9, empty
    7336,  //58 #DBCS LEAD BYTE 0xFA
    7524,  //59 #DBCS LEAD BYTE 0xFB
    7712,  //60 #DBCS LEAD BYTE 0xFC
    7724   //61 #END OF TABLE 0xFD
};

//Table 932 tail byte
static const int DRW_DoubleTable932[][2] = {
    {0x8140, 0x3000}, //1 #IDEOGRAPHIC SPACE
    {0x8141, 0x3001}, //2 #IDEOGRAPHIC COMMA
    {0x8142, 0x3002}, //3 #IDEOGRAPHIC FULL STOP
    {0x8143, 0xFF0C}, //4 #FULLWIDTH COMMA
    {0x8144, 0xFF0E}, //5 #FULLWIDTH FULL STOP
    {0x8145, 0x30FB}, //6 #KATAKANA MIDDLE DOT
    {0x8146, 0xFF1A}, //7 #FULLWIDTH COLON
    {0x8147, 0xFF1B}, //8 #FULLWIDTH SEMICOLON
    {0x8148, 0xFF1F}, //9 #FULLWIDTH QUESTION MARK
    {0x8149, 0xFF01}, //10 #FULLWIDTH EXCLAMATION MARK
    {0x814A, 0x309B}, //11 #KATAKANA-HIRAGANA VOICED SOUND MARK
    {0x814B, 0x309C}, //12 #KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
    {0x814C, 0x00B4}, //13 #ACUTE ACCENT
    {0x814D, 0xFF40}, //14 #FULLWIDTH GRAVE ACCENT
    {0x814E, 0x00A8}, //15 #DIAERESIS
    {0x814F, 0xFF3E}, //16 #FULLWIDTH CIRCUMFLEX ACCENT
    {0x8150, 0xFFE3}, //17 #FULLWIDTH MACRON
    {0x8151, 0xFF3F}, //18 #FULLWIDTH LOW LINE
    {0x8152, 0x30FD}, //19 #KATAKANA ITERATION MARK
    {0x8153, 0x30FE}, //20 #KATAKANA VOICED ITERATION MARK
    {0x8154, 0x309D}, //21 #HIRAGANA ITERATION MARK
    {0x8155, 0x309E}, //22 #HIRAGANA VOICED ITERATION MARK
    {0x8156, 0x3003}, //23 #DITTO MARK
    {0x8157, 0x4EDD}, //24 #CJK UNIFIED IDEOGRAPH
    {0x8158, 0x3005}, //25 #IDEOGRAPHIC ITERATION MARK
    {0x8159, 0x3006}, //26 #IDEOGRAPHIC CLOSING MARK
    {0x815A, 0x3007}, //27 #IDEOGRAPHIC NUMBER ZERO
    {0x815B, 0x30FC}, //28 #KATAKANA-HIRAGANA PROLONGED SOUND MARK
    {0x815C, 0x2015}, //29 #HORIZONTAL BAR
    {0x815D, 0x2010}, //30 #HYPHEN
    {0x815E, 0xFF0F}, //31 #FULLWIDTH SOLIDUS
    {0x815F, 0xFF3C}, //32 #FULLWIDTH REVERSE SOLIDUS
    {0x8160, 0xFF5E}, //33 #FULLWIDTH TILDE
    {0x8161, 0x2225}, //34 #PARALLEL TO
    {0x8162, 0xFF5C}, //35 #FULLWIDTH VERTICAL LINE
    {0x8163, 0x2026}, //36 #HORIZONTAL ELLIPSIS
    {0x8164, 0x2025}, //37 #TWO DOT LEADER
    {0x8165, 0x2018}, //38 #LEFT SINGLE QUOTATION MARK
    {0x8166, 0x2019}, //39 #RIGHT SINGLE QUOTATION MARK
    {0x8167, 0x201C}, //40 #LEFT DOUBLE QUOTATION MARK
    {0x8168, 0x201D}, //41 #RIGHT DOUBLE QUOTATION MARK
    {0x8169, 0xFF08}, //42 #FULLWIDTH LEFT PARENTHESIS
    {0x816A, 0xFF09}, //43 #FULLWIDTH RIGHT PARENTHESIS
    {0x816B, 0x3014}, //44 #LEFT TORTOISE SHELL BRACKET
    {0x816C, 0x3015}, //45 #RIGHT TORTOISE SHELL BRACKET
    {0x816D, 0xFF3B}, //46 #FULLWIDTH LEFT SQUARE BRACKET
    {0x816E, 0xFF3D}, //47 #FULLWIDTH RIGHT SQUARE BRACKET
    {0x816F, 0xFF5B}, //48 #FULLWIDTH LEFT CURLY BRACKET
    {0x8170, 0xFF5D}, //49 #FULLWIDTH RIGHT CURLY BRACKET
    {0x8171, 0x3008}, //50 #LEFT ANGLE BRACKET
    {0x8172, 0x3009}, //51 #RIGHT ANGLE BRACKET
    {0x8173, 0x300A}, //52 #LEFT DOUBLE ANGLE BRACKET
    {0x8174, 0x300B}, //53 #RIGHT DOUBLE ANGLE BRACKET
    {0x8175, 0x300C}, //54 #LEFT CORNER BRACKET
    {0x8176, 0x300D}, //55 #RIGHT CORNER BRACKET
    {0x8177, 0x300E}, //56 #LEFT WHITE CORNER BRACKET
    {0x8178, 0x300F}, //57 #RIGHT WHITE CORNER BRACKET
    {0x8179, 0x3010}, //58 #LEFT BLACK LENTICULAR BRACKET
    {0x817A, 0x3011}, //59 #RIGHT BLACK LENTICULAR BRACKET
    {0x817B, 0xFF0B}, //60 #FULLWIDTH PLUS SIGN
    {0x817C, 0xFF0D}, //61 #FULLWIDTH HYPHEN-MINUS
    {0x817D, 0x00B1}, //62 #PLUS-MINUS SIGN
    {0x817E, 0x00D7}, //63 #MULTIPLICATION SIGN
    {0x8180, 0x00F7}, //64 #DIVISION SIGN
    {0x8181, 0xFF1D}, //65 #FULLWIDTH EQUALS SIGN
    {0x8182, 0x2260}, //66 #NOT EQUAL TO
    {0x8183, 0xFF1C}, //67 #FULLWIDTH LESS-THAN SIGN
    {0x8184, 0xFF1E}, //68 #FULLWIDTH GREATER-THAN SIGN
    {0x8185, 0x2266}, //69 #LESS-THAN OVER EQUAL TO
    {0x8186, 0x2267}, //70 #GREATER-THAN OVER EQUAL TO
    {0x8187, 0x221E}, //71 #INFINITY
    {0x8188, 0x2234}, //72 #THEREFORE
    {0x8189, 0x2642}, //73 #MALE SIGN
    {0x818A, 0x2640}, //74 #FEMALE SIGN
    {0x818B, 0x00B0}, //75 #DEGREE SIGN
    {0x818C, 0x2032}, //76 #PRIME
    {0x818D, 0x2033}, //77 #DOUBLE PRIME
    {0x818E, 0x2103}, //78 #DEGREE CELSIUS
    {0x818F, 0xFFE5}, //79 #FULLWIDTH YEN SIGN
    {0x8190, 0xFF04}, //80 #FULLWIDTH DOLLAR SIGN
    {0x8191, 0xFFE0}, //81 #FULLWIDTH CENT SIGN
    {0x8192, 0xFFE1}, //82 #FULLWIDTH POUND SIGN
    {0x8193, 0xFF05}, //83 #FULLWIDTH PERCENT SIGN
    {0x8194, 0xFF03}, //84 #FULLWIDTH NUMBER SIGN
    {0x8195, 0xFF06}, //85 #FULLWIDTH AMPERSAND
    {0x8196, 0xFF0A}, //86 #FULLWIDTH ASTERISK
    {0x8197, 0xFF20}, //87 #FULLWIDTH COMMERCIAL AT
    {0x8198, 0x00A7}, //88 #SECTION SIGN
    {0x8199, 0x2606}, //89 #WHITE STAR
    {0x819A, 0x2605}, //90 #BLACK STAR
    {0x819B, 0x25CB}, //91 #WHITE CIRCLE
    {0x819C, 0x25CF}, //92 #BLACK CIRCLE
    {0x819D, 0x25CE}, //93 #BULLSEYE
    {0x819E, 0x25C7}, //94 #WHITE DIAMOND
    {0x819F, 0x25C6}, //95 #BLACK DIAMOND
    {0x81A0, 0x25A1}, //96 #WHITE SQUARE
    {0x81A1, 0x25A0}, //97 #BLACK SQUARE
    {0x81A2, 0x25B3}, //98 #WHITE UP-POINTING TRIANGLE
    {0x81A3, 0x25B2}, //99 #BLACK UP-POINTING TRIANGLE
    {0x81A4, 0x25BD}, //100 #WHITE DOWN-POINTING TRIANGLE
    {0x81A5, 0x25BC}, //101 #BLACK DOWN-POINTING TRIANGLE
    {0x81A6, 0x203B}, //102 #REFERENCE MARK
    {0x81A7, 0x3012}, //103 #POSTAL MARK
    {0x81A8, 0x2192}, //104 #RIGHTWARDS ARROW
    {0x81A9, 0x2190}, //105 #LEFTWARDS ARROW
    {0x81AA, 0x2191}, //106 #UPWARDS ARROW
    {0x81AB, 0x2193}, //107 #DOWNWARDS ARROW
    {0x81AC, 0x3013}, //108 #GETA MARK
    {0x81B8, 0x2208}, //109 #ELEMENT OF
    {0x81B9, 0x220B}, //110 #CONTAINS AS MEMBER
    {0x81BA, 0x2286}, //111 #SUBSET OF OR EQUAL TO
    {0x81BB, 0x2287}, //112 #SUPERSET OF OR EQUAL TO
    {0x81BC, 0x2282}, //113 #SUBSET OF
    {0x81BD, 0x2283}, //114 #SUPERSET OF
    {0x81BE, 0x222A}, //115 #UNION
    {0x81BF, 0x2229}, //116 #INTERSECTION
    {0x81C8, 0x2227}, //117 #LOGICAL AND
    {0x81C9, 0x2228}, //118 #LOGICAL OR
    {0x81CA, 0xFFE2}, //119 #FULLWIDTH NOT SIGN
    {0x81CB, 0x21D2}, //120 #RIGHTWARDS DOUBLE ARROW
    {0x81CC, 0x21D4}, //121 #LEFT RIGHT DOUBLE ARROW
    {0x81CD, 0x2200}, //122 #FOR ALL
    {0x81CE, 0x2203}, //123 #THERE EXISTS
    {0x81DA, 0x2220}, //124 #ANGLE
    {0x81DB, 0x22A5}, //125 #UP TACK
    {0x81DC, 0x2312}, //126 #ARC
    {0x81DD, 0x2202}, //127 #PARTIAL DIFFERENTIAL
    {0x81DE, 0x2207}, //128 #NABLA
    {0x81DF, 0x2261}, //129 #IDENTICAL TO
    {0x81E0, 0x2252}, //130 #APPROXIMATELY EQUAL TO OR THE IMAGE OF
    {0x81E1, 0x226A}, //131 #MUCH LESS-THAN
    {0x81E2, 0x226B}, //132 #MUCH GREATER-THAN
    {0x81E3, 0x221A}, //133 #SQUARE ROOT
    {0x81E4, 0x223D}, //134 #REVERSED TILDE
    {0x81E5, 0x221D}, //135 #PROPORTIONAL TO
    {0x81E6, 0x2235}, //136 #BECAUSE
    {0x81E7, 0x222B}, //137 #INTEGRAL
    {0x81E8, 0x222C}, //138 #DOUBLE INTEGRAL
    {0x81F0, 0x212B}, //139 #ANGSTROM SIGN
    {0x81F1, 0x2030}, //140 #PER MILLE SIGN
    {0x81F2, 0x266F}, //141 #MUSIC SHARP SIGN
    {0x81F3, 0x266D}, //142 #MUSIC FLAT SIGN
    {0x81F4, 0x266A}, //143 #EIGHTH NOTE
    {0x81F5, 0x2020}, //144 #DAGGER
    {0x81F6, 0x2021}, //145 #DOUBLE DAGGER
    {0x81F7, 0x00B6}, //146 #PILCROW SIGN
    {0x81FC, 0x25EF}, //147 #LARGE CIRCLE
    {0x824F, 0xFF10}, //148 #FULLWIDTH DIGIT ZERO
    {0x8250, 0xFF11}, //149 #FULLWIDTH DIGIT ONE
    {0x8251, 0xFF12}, //150 #FULLWIDTH DIGIT TWO
    {0x8252, 0xFF13}, //151 #FULLWIDTH DIGIT THREE
    {0x8253, 0xFF14}, //152 #FULLWIDTH DIGIT FOUR
    {0x8254, 0xFF15}, //153 #FULLWIDTH DIGIT FIVE
    {0x8255, 0xFF16}, //154 #FULLWIDTH DIGIT SIX
    {0x8256, 0xFF17}, //155 #FULLWIDTH DIGIT SEVEN
    {0x8257, 0xFF18}, //156 #FULLWIDTH DIGIT EIGHT
    {0x8258, 0xFF19}, //157 #FULLWIDTH DIGIT NINE
    {0x8260, 0xFF21}, //158 #FULLWIDTH LATIN CAPITAL LETTER A
    {0x8261, 0xFF22}, //159 #FULLWIDTH LATIN CAPITAL LETTER B
    {0x8262, 0xFF23}, //160 #FULLWIDTH LATIN CAPITAL LETTER C
    {0x8263, 0xFF24}, //161 #FULLWIDTH LATIN CAPITAL LETTER D
    {0x8264, 0xFF25}, //162 #FULLWIDTH LATIN CAPITAL LETTER E
    {0x8265, 0xFF26}, //163 #FULLWIDTH LATIN CAPITAL LETTER F
    {0x8266, 0xFF27}, //164 #FULLWIDTH LATIN CAPITAL LETTER G
    {0x8267, 0xFF28}, //165 #FULLWIDTH LATIN CAPITAL LETTER H
    {0x8268, 0xFF29}, //166 #FULLWIDTH LATIN CAPITAL LETTER I
    {0x8269, 0xFF2A}, //167 #FULLWIDTH LATIN CAPITAL LETTER J
    {0x826A, 0xFF2B}, //168 #FULLWIDTH LATIN CAPITAL LETTER K
    {0x826B, 0xFF2C}, //169 #FULLWIDTH LATIN CAPITAL LETTER L
    {0x826C, 0xFF2D}, //170 #FULLWIDTH LATIN CAPITAL LETTER M
    {0x826D, 0xFF2E}, //171 #FULLWIDTH LATIN CAPITAL LETTER N
    {0x826E, 0xFF2F}, //172 #FULLWIDTH LATIN CAPITAL LETTER O
    {0x826F, 0xFF30}, //173 #FULLWIDTH LATIN CAPITAL LETTER P
    {0x8270, 0xFF31}, //174 #FULLWIDTH LATIN CAPITAL LETTER Q
    {0x8271, 0xFF32}, //175 #FULLWIDTH LATIN CAPITAL LETTER R
    {0x8272, 0xFF33}, //176 #FULLWIDTH LATIN CAPITAL LETTER S
    {0x8273, 0xFF34}, //177 #FULLWIDTH LATIN CAPITAL LETTER T
    {0x8274, 0xFF35}, //178 #FULLWIDTH LATIN CAPITAL LETTER U
    {0x8275, 0xFF36}, //179 #FULLWIDTH LATIN CAPITAL LETTER V
    {0x8276, 0xFF37}, //180 #FULLWIDTH LATIN CAPITAL LETTER W
    {0x8277, 0xFF38}, //181 #FULLWIDTH LATIN CAPITAL LETTER X
    {0x8278, 0xFF39}, //182 #FULLWIDTH LATIN CAPITAL LETTER Y
    {0x8279, 0xFF3A}, //183 #FULLWIDTH LATIN CAPITAL LETTER Z
    {0x8281, 0xFF41}, //184 #FULLWIDTH LATIN SMALL LETTER A
    {0x8282, 0xFF42}, //185 #FULLWIDTH LATIN SMALL LETTER B
    {0x8283, 0xFF43}, //186 #FULLWIDTH LATIN SMALL LETTER C
    {0x8284, 0xFF44}, //187 #FULLWIDTH LATIN SMALL LETTER D
    {0x8285, 0xFF45}, //188 #FULLWIDTH LATIN SMALL LETTER E
    {0x8286, 0xFF46}, //189 #FULLWIDTH LATIN SMALL LETTER F
    {0x8287, 0xFF47}, //190 #FULLWIDTH LATIN SMALL LETTER G
    {0x8288, 0xFF48}, //191 #FULLWIDTH LATIN SMALL LETTER H
    {0x8289, 0xFF49}, //192 #FULLWIDTH LATIN SMALL LETTER I
    {0x828A, 0xFF4A}, //193 #FULLWIDTH LATIN SMALL LETTER J
    {0x828B, 0xFF4B}, //194 #FULLWIDTH LATIN SMALL LETTER K
    {0x828C, 0xFF4C}, //195 #FULLWIDTH LATIN SMALL LETTER L
    {0x828D, 0xFF4D}, //196 #FULLWIDTH LATIN SMALL LETTER M
    {0x828E, 0xFF4E}, //197 #FULLWIDTH LATIN SMALL LETTER N
    {0x828F, 0xFF4F}, //198 #FULLWIDTH LATIN SMALL LETTER O
    {0x8290, 0xFF50}, //199 #FULLWIDTH LATIN SMALL LETTER P
    {0x8291, 0xFF51}, //200 #FULLWIDTH LATIN SMALL LETTER Q
    {0x8292, 0xFF52}, //201 #FULLWIDTH LATIN SMALL LETTER R
    {0x8293, 0xFF53}, //202 #FULLWIDTH LATIN SMALL LETTER S
    {0x8294, 0xFF54}, //203 #FULLWIDTH LATIN SMALL LETTER T
    {0x8295, 0xFF55}, //204 #FULLWIDTH LATIN SMALL LETTER U
    {0x8296, 0xFF56}, //205 #FULLWIDTH LATIN SMALL LETTER V
    {0x8297, 0xFF57}, //206 #FULLWIDTH LATIN SMALL LETTER W
    {0x8298, 0xFF58}, //207 #FULLWIDTH LATIN SMALL LETTER X
    {0x8299, 0xFF59}, //208 #FULLWIDTH LATIN SMALL LETTER Y
    {0x829A, 0xFF5A}, //209 #FULLWIDTH LATIN SMALL LETTER Z
    {0x829F, 0x3041}, //210 #HIRAGANA LETTER SMALL A
    {0x82A0, 0x3042}, //211 #HIRAGANA LETTER A
    {0x82A1, 0x3043}, //212 #HIRAGANA LETTER SMALL I
    {0x82A2, 0x3044}, //213 #HIRAGANA LETTER I
    {0x82A3, 0x3045}, //214 #HIRAGANA LETTER SMALL U
    {0x82A4, 0x3046}, //215 #HIRAGANA LETTER U
    {0x82A5, 0x3047}, //216 #HIRAGANA LETTER SMALL E
    {0x82A6, 0x3048}, //217 #HIRAGANA LETTER E
    {0x82A7, 0x3049}, //218 #HIRAGANA LETTER SMALL O
    {0x82A8, 0x304A}, //219 #HIRAGANA LETTER O
    {0x82A9, 0x304B}, //220 #HIRAGANA LETTER KA
    {0x82AA, 0x304C}, //221 #HIRAGANA LETTER GA
    {0x82AB, 0x304D}, //222 #HIRAGANA LETTER KI
    {0x82AC, 0x304E}, //223 #HIRAGANA LETTER GI
    {0x82AD, 0x304F}, //224 #HIRAGANA LETTER KU
    {0x82AE, 0x3050}, //225 #HIRAGANA LETTER GU
    {0x82AF, 0x3051}, //226 #HIRAGANA LETTER KE
    {0x82B0, 0x3052}, //227 #HIRAGANA LETTER GE
    {0x82B1, 0x3053}, //228 #HIRAGANA LETTER KO
    {0x82B2, 0x3054}, //229 #HIRAGANA LETTER GO
    {0x82B3, 0x3055}, //230 #HIRAGANA LETTER SA
    {0x82B4, 0x3056}, //231 #HIRAGANA LETTER ZA
    {0x82B5, 0x3057}, //232 #HIRAGANA LETTER SI
    {0x82B6, 0x3058}, //233 #HIRAGANA LETTER ZI
    {0x82B7, 0x3059}, //234 #HIRAGANA LETTER SU
    {0x82B8, 0x305A}, //235 #HIRAGANA LETTER ZU
    {0x82B9, 0x305B}, //236 #HIRAGANA LETTER SE
    {0x82BA, 0x305C}, //237 #HIRAGANA LETTER ZE
    {0x82BB, 0x305D}, //238 #HIRAGANA LETTER SO
    {0x82BC, 0x305E}, //239 #HIRAGANA LETTER ZO
    {0x82BD, 0x305F}, //240 #HIRAGANA LETTER TA
    {0x82BE, 0x3060}, //241 #HIRAGANA LETTER DA
    {0x82BF, 0x3061}, //242 #HIRAGANA LETTER TI
    {0x82C0, 0x3062}, //243 #HIRAGANA LETTER DI
    {0x82C1, 0x3063}, //244 #HIRAGANA LETTER SMALL TU
    {0x82C2, 0x3064}, //245 #HIRAGANA LETTER TU
    {0x82C3, 0x3065}, //246 #HIRAGANA LETTER DU
    {0x82C4, 0x3066}, //247 #HIRAGANA LETTER TE
    {0x82C5, 0x3067}, //248 #HIRAGANA LETTER DE
    {0x82C6, 0x3068}, //249 #HIRAGANA LETTER TO
    {0x82C7, 0x3069}, //250 #HIRAGANA LETTER DO
    {0x82C8, 0x306A}, //251 #HIRAGANA LETTER NA
    {0x82C9, 0x306B}, //252 #HIRAGANA LETTER NI
    {0x82CA, 0x306C}, //253 #HIRAGANA LETTER NU
    {0x82CB, 0x306D}, //254 #HIRAGANA LETTER NE
    {0x82CC, 0x306E}, //255 #HIRAGANA LETTER NO
    {0x82CD, 0x306F}, //256 #HIRAGANA LETTER HA
    {0x82CE, 0x3070}, //257 #HIRAGANA LETTER BA
    {0x82CF, 0x3071}, //258 #HIRAGANA LETTER PA
    {0x82D0, 0x3072}, //259 #HIRAGANA LETTER HI
    {0x82D1, 0x3073}, //260 #HIRAGANA LETTER BI
    {0x82D2, 0x3074}, //261 #HIRAGANA LETTER PI
    {0x82D3, 0x3075}, //262 #HIRAGANA LETTER HU
    {0x82D4, 0x3076}, //263 #HIRAGANA LETTER BU
    {0x82D5, 0x3077}, //264 #HIRAGANA LETTER PU
    {0x82D6, 0x3078}, //265 #HIRAGANA LETTER HE
    {0x82D7, 0x3079}, //266 #HIRAGANA LETTER BE
    {0x82D8, 0x307A}, //267 #HIRAGANA LETTER PE
    {0x82D9, 0x307B}, //268 #HIRAGANA LETTER HO
    {0x82DA, 0x307C}, //269 #HIRAGANA LETTER BO
    {0x82DB, 0x307D}, //270 #HIRAGANA LETTER PO
    {0x82DC, 0x307E}, //271 #HIRAGANA LETTER MA
    {0x82DD, 0x307F}, //272 #HIRAGANA LETTER MI
    {0x82DE, 0x3080}, //273 #HIRAGANA LETTER MU
    {0x82DF, 0x3081}, //274 #HIRAGANA LETTER ME
    {0x82E0, 0x3082}, //275 #HIRAGANA LETTER MO
    {0x82E1, 0x3083}, //276 #HIRAGANA LETTER SMALL YA
    {0x82E2, 0x3084}, //277 #HIRAGANA LETTER YA
    {0x82E3, 0x3085}, //278 #HIRAGANA LETTER SMALL YU
    {0x82E4, 0x3086}, //279 #HIRAGANA LETTER YU
    {0x82E5, 0x3087}, //280 #HIRAGANA LETTER SMALL YO
    {0x82E6, 0x3088}, //281 #HIRAGANA LETTER YO
    {0x82E7, 0x3089}, //282 #HIRAGANA LETTER RA
    {0x82E8, 0x308A}, //283 #HIRAGANA LETTER RI
    {0x82E9, 0x308B}, //284 #HIRAGANA LETTER RU
    {0x82EA, 0x308C}, //285 #HIRAGANA LETTER RE
    {0x82EB, 0x308D}, //286 #HIRAGANA LETTER RO
    {0x82EC, 0x308E}, //287 #HIRAGANA LETTER SMALL WA
    {0x82ED, 0x308F}, //288 #HIRAGANA LETTER WA
    {0x82EE, 0x3090}, //289 #HIRAGANA LETTER WI
    {0x82EF, 0x3091}, //290 #HIRAGANA LETTER WE
    {0x82F0, 0x3092}, //291 #HIRAGANA LETTER WO
    {0x82F1, 0x3093}, //292 #HIRAGANA LETTER N
    {0x8340, 0x30A1}, //293 #KATAKANA LETTER SMALL A
    {0x8341, 0x30A2}, //294 #KATAKANA LETTER A
    {0x8342, 0x30A3}, //295 #KATAKANA LETTER SMALL I
    {0x8343, 0x30A4}, //296 #KATAKANA LETTER I
    {0x8344, 0x30A5}, //297 #KATAKANA LETTER SMALL U
    {0x8345, 0x30A6}, //298 #KATAKANA LETTER U
    {0x8346, 0x30A7}, //299 #KATAKANA LETTER SMALL E
    {0x8347, 0x30A8}, //300 #KATAKANA LETTER E
    {0x8348, 0x30A9}, //301 #KATAKANA LETTER SMALL O
    {0x8349, 0x30AA}, //302 #KATAKANA LETTER O
    {0x834A, 0x30AB}, //303 #KATAKANA LETTER KA
    {0x834B, 0x30AC}, //304 #KATAKANA LETTER GA
    {0x834C, 0x30AD}, //305 #KATAKANA LETTER KI
    {0x834D, 0x30AE}, //306 #KATAKANA LETTER GI
    {0x834E, 0x30AF}, //307 #KATAKANA LETTER KU
    {0x834F, 0x30B0}, //308 #KATAKANA LETTER GU
    {0x8350, 0x30B1}, //309 #KATAKANA LETTER KE
    {0x8351, 0x30B2}, //310 #KATAKANA LETTER GE
    {0x8352, 0x30B3}, //311 #KATAKANA LETTER KO
    {0x8353, 0x30B4}, //312 #KATAKANA LETTER GO
    {0x8354, 0x30B5}, //313 #KATAKANA LETTER SA
    {0x8355, 0x30B6}, //314 #KATAKANA LETTER ZA
    {0x8356, 0x30B7}, //315 #KATAKANA LETTER SI
    {0x8357, 0x30B8}, //316 #KATAKANA LETTER ZI
    {0x8358, 0x30B9}, //317 #KATAKANA LETTER SU
    {0x8359, 0x30BA}, //318 #KATAKANA LETTER ZU
    {0x835A, 0x30BB}, //319 #KATAKANA LETTER SE
    {0x835B, 0x30BC}, //320 #KATAKANA LETTER ZE
    {0x835C, 0x30BD}, //321 #KATAKANA LETTER SO
    {0x835D, 0x30BE}, //322 #KATAKANA LETTER ZO
    {0x835E, 0x30BF}, //323 #KATAKANA LETTER TA
    {0x835F, 0x30C0}, //324 #KATAKANA LETTER DA
    {0x8360, 0x30C1}, //325 #KATAKANA LETTER TI
    {0x8361, 0x30C2}, //326 #KATAKANA LETTER DI
    {0x8362, 0x30C3}, //327 #KATAKANA LETTER SMALL TU
    {0x8363, 0x30C4}, //328 #KATAKANA LETTER TU
    {0x8364, 0x30C5}, //329 #KATAKANA LETTER DU
    {0x8365, 0x30C6}, //330 #KATAKANA LETTER TE
    {0x8366, 0x30C7}, //331 #KATAKANA LETTER DE
    {0x8367, 0x30C8}, //332 #KATAKANA LETTER TO
    {0x8368, 0x30C9}, //333 #KATAKANA LETTER DO
    {0x8369, 0x30CA}, //334 #KATAKANA LETTER NA
    {0x836A, 0x30CB}, //335 #KATAKANA LETTER NI
    {0x836B, 0x30CC}, //336 #KATAKANA LETTER NU
    {0x836C, 0x30CD}, //337 #KATAKANA LETTER NE
    {0x836D, 0x30CE}, //338 #KATAKANA LETTER NO
    {0x836E, 0x30CF}, //339 #KATAKANA LETTER HA
    {0x836F, 0x30D0}, //340 #KATAKANA LETTER BA
    {0x8370, 0x30D1}, //341 #KATAKANA LETTER PA
    {0x8371, 0x30D2}, //342 #KATAKANA LETTER HI
    {0x8372, 0x30D3}, //343 #KATAKANA LETTER BI
    {0x8373, 0x30D4}, //344 #KATAKANA LETTER PI
    {0x8374, 0x30D5}, //345 #KATAKANA LETTER HU
    {0x8375, 0x30D6}, //346 #KATAKANA LETTER BU
    {0x8376, 0x30D7}, //347 #KATAKANA LETTER PU
    {0x8377, 0x30D8}, //348 #KATAKANA LETTER HE
    {0x8378, 0x30D9}, //349 #KATAKANA LETTER BE
    {0x8379, 0x30DA}, //350 #KATAKANA LETTER PE
    {0x837A, 0x30DB}, //351 #KATAKANA LETTER HO
    {0x837B, 0x30DC}, //352 #KATAKANA LETTER BO
    {0x837C, 0x30DD}, //353 #KATAKANA LETTER PO
    {0x837D, 0x30DE}, //354 #KATAKANA LETTER MA
    {0x837E, 0x30DF}, //355 #KATAKANA LETTER MI
    {0x8380, 0x30E0}, //356 #KATAKANA LETTER MU
    {0x8381, 0x30E1}, //357 #KATAKANA LETTER ME
    {0x8382, 0x30E2}, //358 #KATAKANA LETTER MO
    {0x8383, 0x30E3}, //359 #KATAKANA LETTER SMALL YA
    {0x8384, 0x30E4}, //360 #KATAKANA LETTER YA
    {0x8385, 0x30E5}, //361 #KATAKANA LETTER SMALL YU
    {0x8386, 0x30E6}, //362 #KATAKANA LETTER YU
    {0x8387, 0x30E7}, //363 #KATAKANA LETTER SMALL YO
    {0x8388, 0x30E8}, //364 #KATAKANA LETTER YO
    {0x8389, 0x30E9}, //365 #KATAKANA LETTER RA
    {0x838A, 0x30EA}, //366 #KATAKANA LETTER RI
    {0x838B, 0x30EB}, //367 #KATAKANA LETTER RU
    {0x838C, 0x30EC}, //368 #KATAKANA LETTER RE
    {0x838D, 0x30ED}, //369 #KATAKANA LETTER RO
    {0x838E, 0x30EE}, //370 #KATAKANA LETTER SMALL WA
    {0x838F, 0x30EF}, //371 #KATAKANA LETTER WA
    {0x8390, 0x30F0}, //372 #KATAKANA LETTER WI
    {0x8391, 0x30F1}, //373 #KATAKANA LETTER WE
    {0x8392, 0x30F2}, //374 #KATAKANA LETTER WO
    {0x8393, 0x30F3}, //375 #KATAKANA LETTER N
    {0x8394, 0x30F4}, //376 #KATAKANA LETTER VU
    {0x8395, 0x30F5}, //377 #KATAKANA LETTER SMALL KA
    {0x8396, 0x30F6}, //378 #KATAKANA LETTER SMALL KE
    {0x839F, 0x0391}, //379 #GREEK CAPITAL LETTER ALPHA
    {0x83A0, 0x0392}, //380 #GREEK CAPITAL LETTER BETA
    {0x83A1, 0x0393}, //381 #GREEK CAPITAL LETTER GAMMA
    {0x83A2, 0x0394}, //382 #GREEK CAPITAL LETTER DELTA
    {0x83A3, 0x0395}, //383 #GREEK CAPITAL LETTER EPSILON
    {0x83A4, 0x0396}, //384 #GREEK CAPITAL LETTER ZETA
    {0x83A5, 0x0397}, //385 #GREEK CAPITAL LETTER ETA
    {0x83A6, 0x0398}, //386 #GREEK CAPITAL LETTER THETA
    {0x83A7, 0x0399}, //387 #GREEK CAPITAL LETTER IOTA
    {0x83A8, 0x039A}, //388 #GREEK CAPITAL LETTER KAPPA
    {0x83A9, 0x039B}, //389 #GREEK CAPITAL LETTER LAMDA
    {0x83AA, 0x039C}, //390 #GREEK CAPITAL LETTER MU
    {0x83AB, 0x039D}, //391 #GREEK CAPITAL LETTER NU
    {0x83AC, 0x039E}, //392 #GREEK CAPITAL LETTER XI
    {0x83AD, 0x039F}, //393 #GREEK CAPITAL LETTER OMICRON
    {0x83AE, 0x03A0}, //394 #GREEK CAPITAL LETTER PI
    {0x83AF, 0x03A1}, //395 #GREEK CAPITAL LETTER RHO
    {0x83B0, 0x03A3}, //396 #GREEK CAPITAL LETTER SIGMA
    {0x83B1, 0x03A4}, //397 #GREEK CAPITAL LETTER TAU
    {0x83B2, 0x03A5}, //398 #GREEK CAPITAL LETTER UPSILON
    {0x83B3, 0x03A6}, //399 #GREEK CAPITAL LETTER PHI
    {0x83B4, 0x03A7}, //400 #GREEK CAPITAL LETTER CHI
    {0x83B5, 0x03A8}, //401 #GREEK CAPITAL LETTER PSI
    {0x83B6, 0x03A9}, //402 #GREEK CAPITAL LETTER OMEGA
    {0x83BF, 0x03B1}, //403 #GREEK SMALL LETTER ALPHA
    {0x83C0, 0x03B2}, //404 #GREEK SMALL LETTER BETA
    {0x83C1, 0x03B3}, //405 #GREEK SMALL LETTER GAMMA
    {0x83C2, 0x03B4}, //406 #GREEK SMALL LETTER DELTA
    {0x83C3, 0x03B5}, //407 #GREEK SMALL LETTER EPSILON
    {0x83C4, 0x03B6}, //408 #GREEK SMALL LETTER ZETA
    {0x83C5, 0x03B7}, //409 #GREEK SMALL LETTER ETA
    {0x83C6, 0x03B8}, //410 #GREEK SMALL LETTER THETA
    {0x83C7, 0x03B9}, //411 #GREEK SMALL LETTER IOTA
    {0x83C8, 0x03BA}, //412 #GREEK SMALL LETTER KAPPA
    {0x83C9, 0x03BB}, //413 #GREEK SMALL LETTER LAMDA
    {0x83CA, 0x03BC}, //414 #GREEK SMALL LETTER MU
    {0x83CB, 0x03BD}, //415 #GREEK SMALL LETTER NU
    {0x83CC, 0x03BE}, //416 #GREEK SMALL LETTER XI
    {0x83CD, 0x03BF}, //417 #GREEK SMALL LETTER OMICRON
    {0x83CE, 0x03C0}, //418 #GREEK SMALL LETTER PI
    {0x83CF, 0x03C1}, //419 #GREEK SMALL LETTER RHO
    {0x83D0, 0x03C3}, //420 #GREEK SMALL LETTER SIGMA
    {0x83D1, 0x03C4}, //421 #GREEK SMALL LETTER TAU
    {0x83D2, 0x03C5}, //422 #GREEK SMALL LETTER UPSILON
    {0x83D3, 0x03C6}, //423 #GREEK SMALL LETTER PHI
    {0x83D4, 0x03C7}, //424 #GREEK SMALL LETTER CHI
    {0x83D5, 0x03C8}, //425 #GREEK SMALL LETTER PSI
    {0x83D6, 0x03C9}, //426 #GREEK SMALL LETTER OMEGA
    {0x8440, 0x0410}, //427 #CYRILLIC CAPITAL LETTER A
    {0x8441, 0x0411}, //428 #CYRILLIC CAPITAL LETTER BE
    {0x8442, 0x0412}, //429 #CYRILLIC CAPITAL LETTER VE
    {0x8443, 0x0413}, //430 #CYRILLIC CAPITAL LETTER GHE
    {0x8444, 0x0414}, //431 #CYRILLIC CAPITAL LETTER DE
    {0x8445, 0x0415}, //432 #CYRILLIC CAPITAL LETTER IE
    {0x8446, 0x0401}, //433 #CYRILLIC CAPITAL LETTER IO
    {0x8447, 0x0416}, //434 #CYRILLIC CAPITAL LETTER ZHE
    {0x8448, 0x0417}, //435 #CYRILLIC CAPITAL LETTER ZE
    {0x8449, 0x0418}, //436 #CYRILLIC CAPITAL LETTER I
    {0x844A, 0x0419}, //437 #CYRILLIC CAPITAL LETTER SHORT I
    {0x844B, 0x041A}, //438 #CYRILLIC CAPITAL LETTER KA
    {0x844C, 0x041B}, //439 #CYRILLIC CAPITAL LETTER EL
    {0x844D, 0x041C}, //440 #CYRILLIC CAPITAL LETTER EM
    {0x844E, 0x041D}, //441 #CYRILLIC CAPITAL LETTER EN
    {0x844F, 0x041E}, //442 #CYRILLIC CAPITAL LETTER O
    {0x8450, 0x041F}, //443 #CYRILLIC CAPITAL LETTER PE
    {0x8451, 0x0420}, //444 #CYRILLIC CAPITAL LETTER ER
    {0x8452, 0x0421}, //445 #CYRILLIC CAPITAL LETTER ES
    {0x8453, 0x0422}, //446 #CYRILLIC CAPITAL LETTER TE
    {0x8454, 0x0423}, //447 #CYRILLIC CAPITAL LETTER U
    {0x8455, 0x0424}, //448 #CYRILLIC CAPITAL LETTER EF
    {0x8456, 0x0425}, //449 #CYRILLIC CAPITAL LETTER HA
    {0x8457, 0x0426}, //450 #CYRILLIC CAPITAL LETTER TSE
    {0x8458, 0x0427}, //451 #CYRILLIC CAPITAL LETTER CHE
    {0x8459, 0x0428}, //452 #CYRILLIC CAPITAL LETTER SHA
    {0x845A, 0x0429}, //453 #CYRILLIC CAPITAL LETTER SHCHA
    {0x845B, 0x042A}, //454 #CYRILLIC CAPITAL LETTER HARD SIGN
    {0x845C, 0x042B}, //455 #CYRILLIC CAPITAL LETTER YERU
    {0x845D, 0x042C}, //456 #CYRILLIC CAPITAL LETTER SOFT SIGN
    {0x845E, 0x042D}, //457 #CYRILLIC CAPITAL LETTER E
    {0x845F, 0x042E}, //458 #CYRILLIC CAPITAL LETTER YU
    {0x8460, 0x042F}, //459 #CYRILLIC CAPITAL LETTER YA
    {0x8470, 0x0430}, //460 #CYRILLIC SMALL LETTER A
    {0x8471, 0x0431}, //461 #CYRILLIC SMALL LETTER BE
    {0x8472, 0x0432}, //462 #CYRILLIC SMALL LETTER VE
    {0x8473, 0x0433}, //463 #CYRILLIC SMALL LETTER GHE
    {0x8474, 0x0434}, //464 #CYRILLIC SMALL LETTER DE
    {0x8475, 0x0435}, //465 #CYRILLIC SMALL LETTER IE
    {0x8476, 0x0451}, //466 #CYRILLIC SMALL LETTER IO
    {0x8477, 0x0436}, //467 #CYRILLIC SMALL LETTER ZHE
    {0x8478, 0x0437}, //468 #CYRILLIC SMALL LETTER ZE
    {0x8479, 0x0438}, //469 #CYRILLIC SMALL LETTER I
    {0x847A, 0x0439}, //470 #CYRILLIC SMALL LETTER SHORT I
    {0x847B, 0x043A}, //471 #CYRILLIC SMALL LETTER KA
    {0x847C, 0x043B}, //472 #CYRILLIC SMALL LETTER EL
    {0x847D, 0x043C}, //473 #CYRILLIC SMALL LETTER EM
    {0x847E, 0x043D}, //474 #CYRILLIC SMALL LETTER EN
    {0x8480, 0x043E}, //475 #CYRILLIC SMALL LETTER O
    {0x8481, 0x043F}, //476 #CYRILLIC SMALL LETTER PE
    {0x8482, 0x0440}, //477 #CYRILLIC SMALL LETTER ER
    {0x8483, 0x0441}, //478 #CYRILLIC SMALL LETTER ES
    {0x8484, 0x0442}, //479 #CYRILLIC SMALL LETTER TE
    {0x8485, 0x0443}, //480 #CYRILLIC SMALL LETTER U
    {0x8486, 0x0444}, //481 #CYRILLIC SMALL LETTER EF
    {0x8487, 0x0445}, //482 #CYRILLIC SMALL LETTER HA
    {0x8488, 0x0446}, //483 #CYRILLIC SMALL LETTER TSE
    {0x8489, 0x0447}, //484 #CYRILLIC SMALL LETTER CHE
    {0x848A, 0x0448}, //485 #CYRILLIC SMALL LETTER SHA
    {0x848B, 0x0449}, //486 #CYRILLIC SMALL LETTER SHCHA
    {0x848C, 0x044A}, //487 #CYRILLIC SMALL LETTER HARD SIGN
    {0x848D, 0x044B}, //488 #CYRILLIC SMALL LETTER YERU
    {0x848E, 0x044C}, //489 #CYRILLIC SMALL LETTER SOFT SIGN
    {0x848F, 0x044D}, //490 #CYRILLIC SMALL LETTER E
    {0x8490, 0x044E}, //491 #CYRILLIC SMALL LETTER YU
    {0x8491, 0x044F}, //492 #CYRILLIC SMALL LETTER YA
    {0x849F, 0x2500}, //493 #BOX DRAWINGS LIGHT HORIZONTAL
    {0x84A0, 0x2502}, //494 #BOX DRAWINGS LIGHT VERTICAL
    {0x84A1, 0x250C}, //495 #BOX DRAWINGS LIGHT DOWN AND RIGHT
    {0x84A2, 0x2510}, //496 #BOX DRAWINGS LIGHT DOWN AND LEFT
    {0x84A3, 0x2518}, //497 #BOX DRAWINGS LIGHT UP AND LEFT
    {0x84A4, 0x2514}, //498 #BOX DRAWINGS LIGHT UP AND RIGHT
    {0x84A5, 0x251C}, //499 #BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    {0x84A6, 0x252C}, //500 #BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    {0x84A7, 0x2524}, //501 #BOX DRAWINGS LIGHT VERTICAL AND LEFT
    {0x84A8, 0x2534}, //502 #BOX DRAWINGS LIGHT UP AND HORIZONTAL
    {0x84A9, 0x253C}, //503 #BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    {0x84AA, 0x2501}, //504 #BOX DRAWINGS HEAVY HORIZONTAL
    {0x84AB, 0x2503}, //505 #BOX DRAWINGS HEAVY VERTICAL
    {0x84AC, 0x250F}, //506 #BOX DRAWINGS HEAVY DOWN AND RIGHT
    {0x84AD, 0x2513}, //507 #BOX DRAWINGS HEAVY DOWN AND LEFT
    {0x84AE, 0x251B}, //508 #BOX DRAWINGS HEAVY UP AND LEFT
    {0x84AF, 0x2517}, //509 #BOX DRAWINGS HEAVY UP AND RIGHT
    {0x84B0, 0x2523}, //510 #BOX DRAWINGS HEAVY VERTICAL AND RIGHT
    {0x84B1, 0x2533}, //511 #BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
    {0x84B2, 0x252B}, //512 #BOX DRAWINGS HEAVY VERTICAL AND LEFT
    {0x84B3, 0x253B}, //513 #BOX DRAWINGS HEAVY UP AND HORIZONTAL
    {0x84B4, 0x254B}, //514 #BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
    {0x84B5, 0x2520}, //515 #BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
    {0x84B6, 0x252F}, //516 #BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
    {0x84B7, 0x2528}, //517 #BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
    {0x84B8, 0x2537}, //518 #BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
    {0x84B9, 0x253F}, //519 #BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
    {0x84BA, 0x251D}, //520 #BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
    {0x84BB, 0x2530}, //521 #BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
    {0x84BC, 0x2525}, //522 #BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
    {0x84BD, 0x2538}, //523 #BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
    {0x84BE, 0x2542}, //524 #BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
    {0x8740, 0x2460}, //525 #CIRCLED DIGIT ONE
    {0x8741, 0x2461}, //526 #CIRCLED DIGIT TWO
    {0x8742, 0x2462}, //527 #CIRCLED DIGIT THREE
    {0x8743, 0x2463}, //528 #CIRCLED DIGIT FOUR
    {0x8744, 0x2464}, //529 #CIRCLED DIGIT FIVE
    {0x8745, 0x2465}, //530 #CIRCLED DIGIT SIX
    {0x8746, 0x2466}, //531 #CIRCLED DIGIT SEVEN
    {0x8747, 0x2467}, //532 #CIRCLED DIGIT EIGHT
    {0x8748, 0x2468}, //533 #CIRCLED DIGIT NINE
    {0x8749, 0x2469}, //534 #CIRCLED NUMBER TEN
    {0x874A, 0x246A}, //535 #CIRCLED NUMBER ELEVEN
    {0x874B, 0x246B}, //536 #CIRCLED NUMBER TWELVE
    {0x874C, 0x246C}, //537 #CIRCLED NUMBER THIRTEEN
    {0x874D, 0x246D}, //538 #CIRCLED NUMBER FOURTEEN
    {0x874E, 0x246E}, //539 #CIRCLED NUMBER FIFTEEN
    {0x874F, 0x246F}, //540 #CIRCLED NUMBER SIXTEEN
    {0x8750, 0x2470}, //541 #CIRCLED NUMBER SEVENTEEN
    {0x8751, 0x2471}, //542 #CIRCLED NUMBER EIGHTEEN
    {0x8752, 0x2472}, //543 #CIRCLED NUMBER NINETEEN
    {0x8753, 0x2473}, //544 #CIRCLED NUMBER TWENTY
    {0x8754, 0x2160}, //545 #ROMAN NUMERAL ONE
    {0x8755, 0x2161}, //546 #ROMAN NUMERAL TWO
    {0x8756, 0x2162}, //547 #ROMAN NUMERAL THREE
    {0x8757, 0x2163}, //548 #ROMAN NUMERAL FOUR
    {0x8758, 0x2164}, //549 #ROMAN NUMERAL FIVE
    {0x8759, 0x2165}, //550 #ROMAN NUMERAL SIX
    {0x875A, 0x2166}, //551 #ROMAN NUMERAL SEVEN
    {0x875B, 0x2167}, //552 #ROMAN NUMERAL EIGHT
    {0x875C, 0x2168}, //553 #ROMAN NUMERAL NINE
    {0x875D, 0x2169}, //554 #ROMAN NUMERAL TEN
    {0x875F, 0x3349}, //555 #SQUARE MIRI
    {0x8760, 0x3314}, //556 #SQUARE KIRO
    {0x8761, 0x3322}, //557 #SQUARE SENTI
    {0x8762, 0x334D}, //558 #SQUARE MEETORU
    {0x8763, 0x3318}, //559 #SQUARE GURAMU
    {0x8764, 0x3327}, //560 #SQUARE TON
    {0x8765, 0x3303}, //561 #SQUARE AARU
    {0x8766, 0x3336}, //562 #SQUARE HEKUTAARU
    {0x8767, 0x3351}, //563 #SQUARE RITTORU
    {0x8768, 0x3357}, //564 #SQUARE WATTO
    {0x8769, 0x330D}, //565 #SQUARE KARORII
    {0x876A, 0x3326}, //566 #SQUARE DORU
    {0x876B, 0x3323}, //567 #SQUARE SENTO
    {0x876C, 0x332B}, //568 #SQUARE PAASENTO
    {0x876D, 0x334A}, //569 #SQUARE MIRIBAARU
    {0x876E, 0x333B}, //570 #SQUARE PEEZI
    {0x876F, 0x339C}, //571 #SQUARE MM
    {0x8770, 0x339D}, //572 #SQUARE CM
    {0x8771, 0x339E}, //573 #SQUARE KM
    {0x8772, 0x338E}, //574 #SQUARE MG
    {0x8773, 0x338F}, //575 #SQUARE KG
    {0x8774, 0x33C4}, //576 #SQUARE CC
    {0x8775, 0x33A1}, //577 #SQUARE M SQUARED
    {0x877E, 0x337B}, //578 #SQUARE ERA NAME HEISEI
    {0x8780, 0x301D}, //579 #REVERSED DOUBLE PRIME QUOTATION MARK
    {0x8781, 0x301F}, //580 #LOW DOUBLE PRIME QUOTATION MARK
    {0x8782, 0x2116}, //581 #NUMERO SIGN
    {0x8783, 0x33CD}, //582 #SQUARE KK
    {0x8784, 0x2121}, //583 #TELEPHONE SIGN
    {0x8785, 0x32A4}, //584 #CIRCLED IDEOGRAPH HIGH
    {0x8786, 0x32A5}, //585 #CIRCLED IDEOGRAPH CENTRE
    {0x8787, 0x32A6}, //586 #CIRCLED IDEOGRAPH LOW
    {0x8788, 0x32A7}, //587 #CIRCLED IDEOGRAPH LEFT
    {0x8789, 0x32A8}, //588 #CIRCLED IDEOGRAPH RIGHT
    {0x878A, 0x3231}, //589 #PARENTHESIZED IDEOGRAPH STOCK
    {0x878B, 0x3232}, //590 #PARENTHESIZED IDEOGRAPH HAVE
    {0x878C, 0x3239}, //591 #PARENTHESIZED IDEOGRAPH REPRESENT
    {0x878D, 0x337E}, //592 #SQUARE ERA NAME MEIZI
    {0x878E, 0x337D}, //593 #SQUARE ERA NAME TAISYOU
    {0x878F, 0x337C}, //594 #SQUARE ERA NAME SYOUWA
    {0x8790, 0x2252}, //595 #APPROXIMATELY EQUAL TO OR THE IMAGE OF
    {0x8791, 0x2261}, //596 #IDENTICAL TO
    {0x8792, 0x222B}, //597 #INTEGRAL
    {0x8793, 0x222E}, //598 #CONTOUR INTEGRAL
    {0x8794, 0x2211}, //599 #N-ARY SUMMATION
    {0x8795, 0x221A}, //600 #SQUARE ROOT
    {0x8796, 0x22A5}, //601 #UP TACK
    {0x8797, 0x2220}, //602 #ANGLE
    {0x8798, 0x221F}, //603 #RIGHT ANGLE
    {0x8799, 0x22BF}, //604 #RIGHT TRIANGLE
    {0x879A, 0x2235}, //605 #BECAUSE
    {0x879B, 0x2229}, //606 #INTERSECTION
    {0x879C, 0x222A}, //607 #UNION
    {0x889F, 0x4E9C}, //608 #CJK UNIFIED IDEOGRAPH
    {0x88A0, 0x5516}, //609 #CJK UNIFIED IDEOGRAPH
    {0x88A1, 0x5A03}, //610 #CJK UNIFIED IDEOGRAPH
    {0x88A2, 0x963F}, //611 #CJK UNIFIED IDEOGRAPH
    {0x88A3, 0x54C0}, //612 #CJK UNIFIED IDEOGRAPH
    {0x88A4, 0x611B}, //613 #CJK UNIFIED IDEOGRAPH
    {0x88A5, 0x6328}, //614 #CJK UNIFIED IDEOGRAPH
    {0x88A6, 0x59F6}, //615 #CJK UNIFIED IDEOGRAPH
    {0x88A7, 0x9022}, //616 #CJK UNIFIED IDEOGRAPH
    {0x88A8, 0x8475}, //617 #CJK UNIFIED IDEOGRAPH
    {0x88A9, 0x831C}, //618 #CJK UNIFIED IDEOGRAPH
    {0x88AA, 0x7A50}, //619 #CJK UNIFIED IDEOGRAPH
    {0x88AB, 0x60AA}, //620 #CJK UNIFIED IDEOGRAPH
    {0x88AC, 0x63E1}, //621 #CJK UNIFIED IDEOGRAPH
    {0x88AD, 0x6E25}, //622 #CJK UNIFIED IDEOGRAPH
    {0x88AE, 0x65ED}, //623 #CJK UNIFIED IDEOGRAPH
    {0x88AF, 0x8466}, //624 #CJK UNIFIED IDEOGRAPH
    {0x88B0, 0x82A6}, //625 #CJK UNIFIED IDEOGRAPH
    {0x88B1, 0x9BF5}, //626 #CJK UNIFIED IDEOGRAPH
    {0x88B2, 0x6893}, //627 #CJK UNIFIED IDEOGRAPH
    {0x88B3, 0x5727}, //628 #CJK UNIFIED IDEOGRAPH
    {0x88B4, 0x65A1}, //629 #CJK UNIFIED IDEOGRAPH
    {0x88B5, 0x6271}, //630 #CJK UNIFIED IDEOGRAPH
    {0x88B6, 0x5B9B}, //631 #CJK UNIFIED IDEOGRAPH
    {0x88B7, 0x59D0}, //632 #CJK UNIFIED IDEOGRAPH
    {0x88B8, 0x867B}, //633 #CJK UNIFIED IDEOGRAPH
    {0x88B9, 0x98F4}, //634 #CJK UNIFIED IDEOGRAPH
    {0x88BA, 0x7D62}, //635 #CJK UNIFIED IDEOGRAPH
    {0x88BB, 0x7DBE}, //636 #CJK UNIFIED IDEOGRAPH
    {0x88BC, 0x9B8E}, //637 #CJK UNIFIED IDEOGRAPH
    {0x88BD, 0x6216}, //638 #CJK UNIFIED IDEOGRAPH
    {0x88BE, 0x7C9F}, //639 #CJK UNIFIED IDEOGRAPH
    {0x88BF, 0x88B7}, //640 #CJK UNIFIED IDEOGRAPH
    {0x88C0, 0x5B89}, //641 #CJK UNIFIED IDEOGRAPH
    {0x88C1, 0x5EB5}, //642 #CJK UNIFIED IDEOGRAPH
    {0x88C2, 0x6309}, //643 #CJK UNIFIED IDEOGRAPH
    {0x88C3, 0x6697}, //644 #CJK UNIFIED IDEOGRAPH
    {0x88C4, 0x6848}, //645 #CJK UNIFIED IDEOGRAPH
    {0x88C5, 0x95C7}, //646 #CJK UNIFIED IDEOGRAPH
    {0x88C6, 0x978D}, //647 #CJK UNIFIED IDEOGRAPH
    {0x88C7, 0x674F}, //648 #CJK UNIFIED IDEOGRAPH
    {0x88C8, 0x4EE5}, //649 #CJK UNIFIED IDEOGRAPH
    {0x88C9, 0x4F0A}, //650 #CJK UNIFIED IDEOGRAPH
    {0x88CA, 0x4F4D}, //651 #CJK UNIFIED IDEOGRAPH
    {0x88CB, 0x4F9D}, //652 #CJK UNIFIED IDEOGRAPH
    {0x88CC, 0x5049}, //653 #CJK UNIFIED IDEOGRAPH
    {0x88CD, 0x56F2}, //654 #CJK UNIFIED IDEOGRAPH
    {0x88CE, 0x5937}, //655 #CJK UNIFIED IDEOGRAPH
    {0x88CF, 0x59D4}, //656 #CJK UNIFIED IDEOGRAPH
    {0x88D0, 0x5A01}, //657 #CJK UNIFIED IDEOGRAPH
    {0x88D1, 0x5C09}, //658 #CJK UNIFIED IDEOGRAPH
    {0x88D2, 0x60DF}, //659 #CJK UNIFIED IDEOGRAPH
    {0x88D3, 0x610F}, //660 #CJK UNIFIED IDEOGRAPH
    {0x88D4, 0x6170}, //661 #CJK UNIFIED IDEOGRAPH
    {0x88D5, 0x6613}, //662 #CJK UNIFIED IDEOGRAPH
    {0x88D6, 0x6905}, //663 #CJK UNIFIED IDEOGRAPH
    {0x88D7, 0x70BA}, //664 #CJK UNIFIED IDEOGRAPH
    {0x88D8, 0x754F}, //665 #CJK UNIFIED IDEOGRAPH
    {0x88D9, 0x7570}, //666 #CJK UNIFIED IDEOGRAPH
    {0x88DA, 0x79FB}, //667 #CJK UNIFIED IDEOGRAPH
    {0x88DB, 0x7DAD}, //668 #CJK UNIFIED IDEOGRAPH
    {0x88DC, 0x7DEF}, //669 #CJK UNIFIED IDEOGRAPH
    {0x88DD, 0x80C3}, //670 #CJK UNIFIED IDEOGRAPH
    {0x88DE, 0x840E}, //671 #CJK UNIFIED IDEOGRAPH
    {0x88DF, 0x8863}, //672 #CJK UNIFIED IDEOGRAPH
    {0x88E0, 0x8B02}, //673 #CJK UNIFIED IDEOGRAPH
    {0x88E1, 0x9055}, //674 #CJK UNIFIED IDEOGRAPH
    {0x88E2, 0x907A}, //675 #CJK UNIFIED IDEOGRAPH
    {0x88E3, 0x533B}, //676 #CJK UNIFIED IDEOGRAPH
    {0x88E4, 0x4E95}, //677 #CJK UNIFIED IDEOGRAPH
    {0x88E5, 0x4EA5}, //678 #CJK UNIFIED IDEOGRAPH
    {0x88E6, 0x57DF}, //679 #CJK UNIFIED IDEOGRAPH
    {0x88E7, 0x80B2}, //680 #CJK UNIFIED IDEOGRAPH
    {0x88E8, 0x90C1}, //681 #CJK UNIFIED IDEOGRAPH
    {0x88E9, 0x78EF}, //682 #CJK UNIFIED IDEOGRAPH
    {0x88EA, 0x4E00}, //683 #CJK UNIFIED IDEOGRAPH
    {0x88EB, 0x58F1}, //684 #CJK UNIFIED IDEOGRAPH
    {0x88EC, 0x6EA2}, //685 #CJK UNIFIED IDEOGRAPH
    {0x88ED, 0x9038}, //686 #CJK UNIFIED IDEOGRAPH
    {0x88EE, 0x7A32}, //687 #CJK UNIFIED IDEOGRAPH
    {0x88EF, 0x8328}, //688 #CJK UNIFIED IDEOGRAPH
    {0x88F0, 0x828B}, //689 #CJK UNIFIED IDEOGRAPH
    {0x88F1, 0x9C2F}, //690 #CJK UNIFIED IDEOGRAPH
    {0x88F2, 0x5141}, //691 #CJK UNIFIED IDEOGRAPH
    {0x88F3, 0x5370}, //692 #CJK UNIFIED IDEOGRAPH
    {0x88F4, 0x54BD}, //693 #CJK UNIFIED IDEOGRAPH
    {0x88F5, 0x54E1}, //694 #CJK UNIFIED IDEOGRAPH
    {0x88F6, 0x56E0}, //695 #CJK UNIFIED IDEOGRAPH
    {0x88F7, 0x59FB}, //696 #CJK UNIFIED IDEOGRAPH
    {0x88F8, 0x5F15}, //697 #CJK UNIFIED IDEOGRAPH
    {0x88F9, 0x98F2}, //698 #CJK UNIFIED IDEOGRAPH
    {0x88FA, 0x6DEB}, //699 #CJK UNIFIED IDEOGRAPH
    {0x88FB, 0x80E4}, //700 #CJK UNIFIED IDEOGRAPH
    {0x88FC, 0x852D}, //701 #CJK UNIFIED IDEOGRAPH
    {0x8940, 0x9662}, //702 #CJK UNIFIED IDEOGRAPH
    {0x8941, 0x9670}, //703 #CJK UNIFIED IDEOGRAPH
    {0x8942, 0x96A0}, //704 #CJK UNIFIED IDEOGRAPH
    {0x8943, 0x97FB}, //705 #CJK UNIFIED IDEOGRAPH
    {0x8944, 0x540B}, //706 #CJK UNIFIED IDEOGRAPH
    {0x8945, 0x53F3}, //707 #CJK UNIFIED IDEOGRAPH
    {0x8946, 0x5B87}, //708 #CJK UNIFIED IDEOGRAPH
    {0x8947, 0x70CF}, //709 #CJK UNIFIED IDEOGRAPH
    {0x8948, 0x7FBD}, //710 #CJK UNIFIED IDEOGRAPH
    {0x8949, 0x8FC2}, //711 #CJK UNIFIED IDEOGRAPH
    {0x894A, 0x96E8}, //712 #CJK UNIFIED IDEOGRAPH
    {0x894B, 0x536F}, //713 #CJK UNIFIED IDEOGRAPH
    {0x894C, 0x9D5C}, //714 #CJK UNIFIED IDEOGRAPH
    {0x894D, 0x7ABA}, //715 #CJK UNIFIED IDEOGRAPH
    {0x894E, 0x4E11}, //716 #CJK UNIFIED IDEOGRAPH
    {0x894F, 0x7893}, //717 #CJK UNIFIED IDEOGRAPH
    {0x8950, 0x81FC}, //718 #CJK UNIFIED IDEOGRAPH
    {0x8951, 0x6E26}, //719 #CJK UNIFIED IDEOGRAPH
    {0x8952, 0x5618}, //720 #CJK UNIFIED IDEOGRAPH
    {0x8953, 0x5504}, //721 #CJK UNIFIED IDEOGRAPH
    {0x8954, 0x6B1D}, //722 #CJK UNIFIED IDEOGRAPH
    {0x8955, 0x851A}, //723 #CJK UNIFIED IDEOGRAPH
    {0x8956, 0x9C3B}, //724 #CJK UNIFIED IDEOGRAPH
    {0x8957, 0x59E5}, //725 #CJK UNIFIED IDEOGRAPH
    {0x8958, 0x53A9}, //726 #CJK UNIFIED IDEOGRAPH
    {0x8959, 0x6D66}, //727 #CJK UNIFIED IDEOGRAPH
    {0x895A, 0x74DC}, //728 #CJK UNIFIED IDEOGRAPH
    {0x895B, 0x958F}, //729 #CJK UNIFIED IDEOGRAPH
    {0x895C, 0x5642}, //730 #CJK UNIFIED IDEOGRAPH
    {0x895D, 0x4E91}, //731 #CJK UNIFIED IDEOGRAPH
    {0x895E, 0x904B}, //732 #CJK UNIFIED IDEOGRAPH
    {0x895F, 0x96F2}, //733 #CJK UNIFIED IDEOGRAPH
    {0x8960, 0x834F}, //734 #CJK UNIFIED IDEOGRAPH
    {0x8961, 0x990C}, //735 #CJK UNIFIED IDEOGRAPH
    {0x8962, 0x53E1}, //736 #CJK UNIFIED IDEOGRAPH
    {0x8963, 0x55B6}, //737 #CJK UNIFIED IDEOGRAPH
    {0x8964, 0x5B30}, //738 #CJK UNIFIED IDEOGRAPH
    {0x8965, 0x5F71}, //739 #CJK UNIFIED IDEOGRAPH
    {0x8966, 0x6620}, //740 #CJK UNIFIED IDEOGRAPH
    {0x8967, 0x66F3}, //741 #CJK UNIFIED IDEOGRAPH
    {0x8968, 0x6804}, //742 #CJK UNIFIED IDEOGRAPH
    {0x8969, 0x6C38}, //743 #CJK UNIFIED IDEOGRAPH
    {0x896A, 0x6CF3}, //744 #CJK UNIFIED IDEOGRAPH
    {0x896B, 0x6D29}, //745 #CJK UNIFIED IDEOGRAPH
    {0x896C, 0x745B}, //746 #CJK UNIFIED IDEOGRAPH
    {0x896D, 0x76C8}, //747 #CJK UNIFIED IDEOGRAPH
    {0x896E, 0x7A4E}, //748 #CJK UNIFIED IDEOGRAPH
    {0x896F, 0x9834}, //749 #CJK UNIFIED IDEOGRAPH
    {0x8970, 0x82F1}, //750 #CJK UNIFIED IDEOGRAPH
    {0x8971, 0x885B}, //751 #CJK UNIFIED IDEOGRAPH
    {0x8972, 0x8A60}, //752 #CJK UNIFIED IDEOGRAPH
    {0x8973, 0x92ED}, //753 #CJK UNIFIED IDEOGRAPH
    {0x8974, 0x6DB2}, //754 #CJK UNIFIED IDEOGRAPH
    {0x8975, 0x75AB}, //755 #CJK UNIFIED IDEOGRAPH
    {0x8976, 0x76CA}, //756 #CJK UNIFIED IDEOGRAPH
    {0x8977, 0x99C5}, //757 #CJK UNIFIED IDEOGRAPH
    {0x8978, 0x60A6}, //758 #CJK UNIFIED IDEOGRAPH
    {0x8979, 0x8B01}, //759 #CJK UNIFIED IDEOGRAPH
    {0x897A, 0x8D8A}, //760 #CJK UNIFIED IDEOGRAPH
    {0x897B, 0x95B2}, //761 #CJK UNIFIED IDEOGRAPH
    {0x897C, 0x698E}, //762 #CJK UNIFIED IDEOGRAPH
    {0x897D, 0x53AD}, //763 #CJK UNIFIED IDEOGRAPH
    {0x897E, 0x5186}, //764 #CJK UNIFIED IDEOGRAPH
    {0x8980, 0x5712}, //765 #CJK UNIFIED IDEOGRAPH
    {0x8981, 0x5830}, //766 #CJK UNIFIED IDEOGRAPH
    {0x8982, 0x5944}, //767 #CJK UNIFIED IDEOGRAPH
    {0x8983, 0x5BB4}, //768 #CJK UNIFIED IDEOGRAPH
    {0x8984, 0x5EF6}, //769 #CJK UNIFIED IDEOGRAPH
    {0x8985, 0x6028}, //770 #CJK UNIFIED IDEOGRAPH
    {0x8986, 0x63A9}, //771 #CJK UNIFIED IDEOGRAPH
    {0x8987, 0x63F4}, //772 #CJK UNIFIED IDEOGRAPH
    {0x8988, 0x6CBF}, //773 #CJK UNIFIED IDEOGRAPH
    {0x8989, 0x6F14}, //774 #CJK UNIFIED IDEOGRAPH
    {0x898A, 0x708E}, //775 #CJK UNIFIED IDEOGRAPH
    {0x898B, 0x7114}, //776 #CJK UNIFIED IDEOGRAPH
    {0x898C, 0x7159}, //777 #CJK UNIFIED IDEOGRAPH
    {0x898D, 0x71D5}, //778 #CJK UNIFIED IDEOGRAPH
    {0x898E, 0x733F}, //779 #CJK UNIFIED IDEOGRAPH
    {0x898F, 0x7E01}, //780 #CJK UNIFIED IDEOGRAPH
    {0x8990, 0x8276}, //781 #CJK UNIFIED IDEOGRAPH
    {0x8991, 0x82D1}, //782 #CJK UNIFIED IDEOGRAPH
    {0x8992, 0x8597}, //783 #CJK UNIFIED IDEOGRAPH
    {0x8993, 0x9060}, //784 #CJK UNIFIED IDEOGRAPH
    {0x8994, 0x925B}, //785 #CJK UNIFIED IDEOGRAPH
    {0x8995, 0x9D1B}, //786 #CJK UNIFIED IDEOGRAPH
    {0x8996, 0x5869}, //787 #CJK UNIFIED IDEOGRAPH
    {0x8997, 0x65BC}, //788 #CJK UNIFIED IDEOGRAPH
    {0x8998, 0x6C5A}, //789 #CJK UNIFIED IDEOGRAPH
    {0x8999, 0x7525}, //790 #CJK UNIFIED IDEOGRAPH
    {0x899A, 0x51F9}, //791 #CJK UNIFIED IDEOGRAPH
    {0x899B, 0x592E}, //792 #CJK UNIFIED IDEOGRAPH
    {0x899C, 0x5965}, //793 #CJK UNIFIED IDEOGRAPH
    {0x899D, 0x5F80}, //794 #CJK UNIFIED IDEOGRAPH
    {0x899E, 0x5FDC}, //795 #CJK UNIFIED IDEOGRAPH
    {0x899F, 0x62BC}, //796 #CJK UNIFIED IDEOGRAPH
    {0x89A0, 0x65FA}, //797 #CJK UNIFIED IDEOGRAPH
    {0x89A1, 0x6A2A}, //798 #CJK UNIFIED IDEOGRAPH
    {0x89A2, 0x6B27}, //799 #CJK UNIFIED IDEOGRAPH
    {0x89A3, 0x6BB4}, //800 #CJK UNIFIED IDEOGRAPH
    {0x89A4, 0x738B}, //801 #CJK UNIFIED IDEOGRAPH
    {0x89A5, 0x7FC1}, //802 #CJK UNIFIED IDEOGRAPH
    {0x89A6, 0x8956}, //803 #CJK UNIFIED IDEOGRAPH
    {0x89A7, 0x9D2C}, //804 #CJK UNIFIED IDEOGRAPH
    {0x89A8, 0x9D0E}, //805 #CJK UNIFIED IDEOGRAPH
    {0x89A9, 0x9EC4}, //806 #CJK UNIFIED IDEOGRAPH
    {0x89AA, 0x5CA1}, //807 #CJK UNIFIED IDEOGRAPH
    {0x89AB, 0x6C96}, //808 #CJK UNIFIED IDEOGRAPH
    {0x89AC, 0x837B}, //809 #CJK UNIFIED IDEOGRAPH
    {0x89AD, 0x5104}, //810 #CJK UNIFIED IDEOGRAPH
    {0x89AE, 0x5C4B}, //811 #CJK UNIFIED IDEOGRAPH
    {0x89AF, 0x61B6}, //812 #CJK UNIFIED IDEOGRAPH
    {0x89B0, 0x81C6}, //813 #CJK UNIFIED IDEOGRAPH
    {0x89B1, 0x6876}, //814 #CJK UNIFIED IDEOGRAPH
    {0x89B2, 0x7261}, //815 #CJK UNIFIED IDEOGRAPH
    {0x89B3, 0x4E59}, //816 #CJK UNIFIED IDEOGRAPH
    {0x89B4, 0x4FFA}, //817 #CJK UNIFIED IDEOGRAPH
    {0x89B5, 0x5378}, //818 #CJK UNIFIED IDEOGRAPH
    {0x89B6, 0x6069}, //819 #CJK UNIFIED IDEOGRAPH
    {0x89B7, 0x6E29}, //820 #CJK UNIFIED IDEOGRAPH
    {0x89B8, 0x7A4F}, //821 #CJK UNIFIED IDEOGRAPH
    {0x89B9, 0x97F3}, //822 #CJK UNIFIED IDEOGRAPH
    {0x89BA, 0x4E0B}, //823 #CJK UNIFIED IDEOGRAPH
    {0x89BB, 0x5316}, //824 #CJK UNIFIED IDEOGRAPH
    {0x89BC, 0x4EEE}, //825 #CJK UNIFIED IDEOGRAPH
    {0x89BD, 0x4F55}, //826 #CJK UNIFIED IDEOGRAPH
    {0x89BE, 0x4F3D}, //827 #CJK UNIFIED IDEOGRAPH
    {0x89BF, 0x4FA1}, //828 #CJK UNIFIED IDEOGRAPH
    {0x89C0, 0x4F73}, //829 #CJK UNIFIED IDEOGRAPH
    {0x89C1, 0x52A0}, //830 #CJK UNIFIED IDEOGRAPH
    {0x89C2, 0x53EF}, //831 #CJK UNIFIED IDEOGRAPH
    {0x89C3, 0x5609}, //832 #CJK UNIFIED IDEOGRAPH
    {0x89C4, 0x590F}, //833 #CJK UNIFIED IDEOGRAPH
    {0x89C5, 0x5AC1}, //834 #CJK UNIFIED IDEOGRAPH
    {0x89C6, 0x5BB6}, //835 #CJK UNIFIED IDEOGRAPH
    {0x89C7, 0x5BE1}, //836 #CJK UNIFIED IDEOGRAPH
    {0x89C8, 0x79D1}, //837 #CJK UNIFIED IDEOGRAPH
    {0x89C9, 0x6687}, //838 #CJK UNIFIED IDEOGRAPH
    {0x89CA, 0x679C}, //839 #CJK UNIFIED IDEOGRAPH
    {0x89CB, 0x67B6}, //840 #CJK UNIFIED IDEOGRAPH
    {0x89CC, 0x6B4C}, //841 #CJK UNIFIED IDEOGRAPH
    {0x89CD, 0x6CB3}, //842 #CJK UNIFIED IDEOGRAPH
    {0x89CE, 0x706B}, //843 #CJK UNIFIED IDEOGRAPH
    {0x89CF, 0x73C2}, //844 #CJK UNIFIED IDEOGRAPH
    {0x89D0, 0x798D}, //845 #CJK UNIFIED IDEOGRAPH
    {0x89D1, 0x79BE}, //846 #CJK UNIFIED IDEOGRAPH
    {0x89D2, 0x7A3C}, //847 #CJK UNIFIED IDEOGRAPH
    {0x89D3, 0x7B87}, //848 #CJK UNIFIED IDEOGRAPH
    {0x89D4, 0x82B1}, //849 #CJK UNIFIED IDEOGRAPH
    {0x89D5, 0x82DB}, //850 #CJK UNIFIED IDEOGRAPH
    {0x89D6, 0x8304}, //851 #CJK UNIFIED IDEOGRAPH
    {0x89D7, 0x8377}, //852 #CJK UNIFIED IDEOGRAPH
    {0x89D8, 0x83EF}, //853 #CJK UNIFIED IDEOGRAPH
    {0x89D9, 0x83D3}, //854 #CJK UNIFIED IDEOGRAPH
    {0x89DA, 0x8766}, //855 #CJK UNIFIED IDEOGRAPH
    {0x89DB, 0x8AB2}, //856 #CJK UNIFIED IDEOGRAPH
    {0x89DC, 0x5629}, //857 #CJK UNIFIED IDEOGRAPH
    {0x89DD, 0x8CA8}, //858 #CJK UNIFIED IDEOGRAPH
    {0x89DE, 0x8FE6}, //859 #CJK UNIFIED IDEOGRAPH
    {0x89DF, 0x904E}, //860 #CJK UNIFIED IDEOGRAPH
    {0x89E0, 0x971E}, //861 #CJK UNIFIED IDEOGRAPH
    {0x89E1, 0x868A}, //862 #CJK UNIFIED IDEOGRAPH
    {0x89E2, 0x4FC4}, //863 #CJK UNIFIED IDEOGRAPH
    {0x89E3, 0x5CE8}, //864 #CJK UNIFIED IDEOGRAPH
    {0x89E4, 0x6211}, //865 #CJK UNIFIED IDEOGRAPH
    {0x89E5, 0x7259}, //866 #CJK UNIFIED IDEOGRAPH
    {0x89E6, 0x753B}, //867 #CJK UNIFIED IDEOGRAPH
    {0x89E7, 0x81E5}, //868 #CJK UNIFIED IDEOGRAPH
    {0x89E8, 0x82BD}, //869 #CJK UNIFIED IDEOGRAPH
    {0x89E9, 0x86FE}, //870 #CJK UNIFIED IDEOGRAPH
    {0x89EA, 0x8CC0}, //871 #CJK UNIFIED IDEOGRAPH
    {0x89EB, 0x96C5}, //872 #CJK UNIFIED IDEOGRAPH
    {0x89EC, 0x9913}, //873 #CJK UNIFIED IDEOGRAPH
    {0x89ED, 0x99D5}, //874 #CJK UNIFIED IDEOGRAPH
    {0x89EE, 0x4ECB}, //875 #CJK UNIFIED IDEOGRAPH
    {0x89EF, 0x4F1A}, //876 #CJK UNIFIED IDEOGRAPH
    {0x89F0, 0x89E3}, //877 #CJK UNIFIED IDEOGRAPH
    {0x89F1, 0x56DE}, //878 #CJK UNIFIED IDEOGRAPH
    {0x89F2, 0x584A}, //879 #CJK UNIFIED IDEOGRAPH
    {0x89F3, 0x58CA}, //880 #CJK UNIFIED IDEOGRAPH
    {0x89F4, 0x5EFB}, //881 #CJK UNIFIED IDEOGRAPH
    {0x89F5, 0x5FEB}, //882 #CJK UNIFIED IDEOGRAPH
    {0x89F6, 0x602A}, //883 #CJK UNIFIED IDEOGRAPH
    {0x89F7, 0x6094}, //884 #CJK UNIFIED IDEOGRAPH
    {0x89F8, 0x6062}, //885 #CJK UNIFIED IDEOGRAPH
    {0x89F9, 0x61D0}, //886 #CJK UNIFIED IDEOGRAPH
    {0x89FA, 0x6212}, //887 #CJK UNIFIED IDEOGRAPH
    {0x89FB, 0x62D0}, //888 #CJK UNIFIED IDEOGRAPH
    {0x89FC, 0x6539}, //889 #CJK UNIFIED IDEOGRAPH
    {0x8A40, 0x9B41}, //890 #CJK UNIFIED IDEOGRAPH
    {0x8A41, 0x6666}, //891 #CJK UNIFIED IDEOGRAPH
    {0x8A42, 0x68B0}, //892 #CJK UNIFIED IDEOGRAPH
    {0x8A43, 0x6D77}, //893 #CJK UNIFIED IDEOGRAPH
    {0x8A44, 0x7070}, //894 #CJK UNIFIED IDEOGRAPH
    {0x8A45, 0x754C}, //895 #CJK UNIFIED IDEOGRAPH
    {0x8A46, 0x7686}, //896 #CJK UNIFIED IDEOGRAPH
    {0x8A47, 0x7D75}, //897 #CJK UNIFIED IDEOGRAPH
    {0x8A48, 0x82A5}, //898 #CJK UNIFIED IDEOGRAPH
    {0x8A49, 0x87F9}, //899 #CJK UNIFIED IDEOGRAPH
    {0x8A4A, 0x958B}, //900 #CJK UNIFIED IDEOGRAPH
    {0x8A4B, 0x968E}, //901 #CJK UNIFIED IDEOGRAPH
    {0x8A4C, 0x8C9D}, //902 #CJK UNIFIED IDEOGRAPH
    {0x8A4D, 0x51F1}, //903 #CJK UNIFIED IDEOGRAPH
    {0x8A4E, 0x52BE}, //904 #CJK UNIFIED IDEOGRAPH
    {0x8A4F, 0x5916}, //905 #CJK UNIFIED IDEOGRAPH
    {0x8A50, 0x54B3}, //906 #CJK UNIFIED IDEOGRAPH
    {0x8A51, 0x5BB3}, //907 #CJK UNIFIED IDEOGRAPH
    {0x8A52, 0x5D16}, //908 #CJK UNIFIED IDEOGRAPH
    {0x8A53, 0x6168}, //909 #CJK UNIFIED IDEOGRAPH
    {0x8A54, 0x6982}, //910 #CJK UNIFIED IDEOGRAPH
    {0x8A55, 0x6DAF}, //911 #CJK UNIFIED IDEOGRAPH
    {0x8A56, 0x788D}, //912 #CJK UNIFIED IDEOGRAPH
    {0x8A57, 0x84CB}, //913 #CJK UNIFIED IDEOGRAPH
    {0x8A58, 0x8857}, //914 #CJK UNIFIED IDEOGRAPH
    {0x8A59, 0x8A72}, //915 #CJK UNIFIED IDEOGRAPH
    {0x8A5A, 0x93A7}, //916 #CJK UNIFIED IDEOGRAPH
    {0x8A5B, 0x9AB8}, //917 #CJK UNIFIED IDEOGRAPH
    {0x8A5C, 0x6D6C}, //918 #CJK UNIFIED IDEOGRAPH
    {0x8A5D, 0x99A8}, //919 #CJK UNIFIED IDEOGRAPH
    {0x8A5E, 0x86D9}, //920 #CJK UNIFIED IDEOGRAPH
    {0x8A5F, 0x57A3}, //921 #CJK UNIFIED IDEOGRAPH
    {0x8A60, 0x67FF}, //922 #CJK UNIFIED IDEOGRAPH
    {0x8A61, 0x86CE}, //923 #CJK UNIFIED IDEOGRAPH
    {0x8A62, 0x920E}, //924 #CJK UNIFIED IDEOGRAPH
    {0x8A63, 0x5283}, //925 #CJK UNIFIED IDEOGRAPH
    {0x8A64, 0x5687}, //926 #CJK UNIFIED IDEOGRAPH
    {0x8A65, 0x5404}, //927 #CJK UNIFIED IDEOGRAPH
    {0x8A66, 0x5ED3}, //928 #CJK UNIFIED IDEOGRAPH
    {0x8A67, 0x62E1}, //929 #CJK UNIFIED IDEOGRAPH
    {0x8A68, 0x64B9}, //930 #CJK UNIFIED IDEOGRAPH
    {0x8A69, 0x683C}, //931 #CJK UNIFIED IDEOGRAPH
    {0x8A6A, 0x6838}, //932 #CJK UNIFIED IDEOGRAPH
    {0x8A6B, 0x6BBB}, //933 #CJK UNIFIED IDEOGRAPH
    {0x8A6C, 0x7372}, //934 #CJK UNIFIED IDEOGRAPH
    {0x8A6D, 0x78BA}, //935 #CJK UNIFIED IDEOGRAPH
    {0x8A6E, 0x7A6B}, //936 #CJK UNIFIED IDEOGRAPH
    {0x8A6F, 0x899A}, //937 #CJK UNIFIED IDEOGRAPH
    {0x8A70, 0x89D2}, //938 #CJK UNIFIED IDEOGRAPH
    {0x8A71, 0x8D6B}, //939 #CJK UNIFIED IDEOGRAPH
    {0x8A72, 0x8F03}, //940 #CJK UNIFIED IDEOGRAPH
    {0x8A73, 0x90ED}, //941 #CJK UNIFIED IDEOGRAPH
    {0x8A74, 0x95A3}, //942 #CJK UNIFIED IDEOGRAPH
    {0x8A75, 0x9694}, //943 #CJK UNIFIED IDEOGRAPH
    {0x8A76, 0x9769}, //944 #CJK UNIFIED IDEOGRAPH
    {0x8A77, 0x5B66}, //945 #CJK UNIFIED IDEOGRAPH
    {0x8A78, 0x5CB3}, //946 #CJK UNIFIED IDEOGRAPH
    {0x8A79, 0x697D}, //947 #CJK UNIFIED IDEOGRAPH
    {0x8A7A, 0x984D}, //948 #CJK UNIFIED IDEOGRAPH
    {0x8A7B, 0x984E}, //949 #CJK UNIFIED IDEOGRAPH
    {0x8A7C, 0x639B}, //950 #CJK UNIFIED IDEOGRAPH
    {0x8A7D, 0x7B20}, //951 #CJK UNIFIED IDEOGRAPH
    {0x8A7E, 0x6A2B}, //952 #CJK UNIFIED IDEOGRAPH
    {0x8A80, 0x6A7F}, //953 #CJK UNIFIED IDEOGRAPH
    {0x8A81, 0x68B6}, //954 #CJK UNIFIED IDEOGRAPH
    {0x8A82, 0x9C0D}, //955 #CJK UNIFIED IDEOGRAPH
    {0x8A83, 0x6F5F}, //956 #CJK UNIFIED IDEOGRAPH
    {0x8A84, 0x5272}, //957 #CJK UNIFIED IDEOGRAPH
    {0x8A85, 0x559D}, //958 #CJK UNIFIED IDEOGRAPH
    {0x8A86, 0x6070}, //959 #CJK UNIFIED IDEOGRAPH
    {0x8A87, 0x62EC}, //960 #CJK UNIFIED IDEOGRAPH
    {0x8A88, 0x6D3B}, //961 #CJK UNIFIED IDEOGRAPH
    {0x8A89, 0x6E07}, //962 #CJK UNIFIED IDEOGRAPH
    {0x8A8A, 0x6ED1}, //963 #CJK UNIFIED IDEOGRAPH
    {0x8A8B, 0x845B}, //964 #CJK UNIFIED IDEOGRAPH
    {0x8A8C, 0x8910}, //965 #CJK UNIFIED IDEOGRAPH
    {0x8A8D, 0x8F44}, //966 #CJK UNIFIED IDEOGRAPH
    {0x8A8E, 0x4E14}, //967 #CJK UNIFIED IDEOGRAPH
    {0x8A8F, 0x9C39}, //968 #CJK UNIFIED IDEOGRAPH
    {0x8A90, 0x53F6}, //969 #CJK UNIFIED IDEOGRAPH
    {0x8A91, 0x691B}, //970 #CJK UNIFIED IDEOGRAPH
    {0x8A92, 0x6A3A}, //971 #CJK UNIFIED IDEOGRAPH
    {0x8A93, 0x9784}, //972 #CJK UNIFIED IDEOGRAPH
    {0x8A94, 0x682A}, //973 #CJK UNIFIED IDEOGRAPH
    {0x8A95, 0x515C}, //974 #CJK UNIFIED IDEOGRAPH
    {0x8A96, 0x7AC3}, //975 #CJK UNIFIED IDEOGRAPH
    {0x8A97, 0x84B2}, //976 #CJK UNIFIED IDEOGRAPH
    {0x8A98, 0x91DC}, //977 #CJK UNIFIED IDEOGRAPH
    {0x8A99, 0x938C}, //978 #CJK UNIFIED IDEOGRAPH
    {0x8A9A, 0x565B}, //979 #CJK UNIFIED IDEOGRAPH
    {0x8A9B, 0x9D28}, //980 #CJK UNIFIED IDEOGRAPH
    {0x8A9C, 0x6822}, //981 #CJK UNIFIED IDEOGRAPH
    {0x8A9D, 0x8305}, //982 #CJK UNIFIED IDEOGRAPH
    {0x8A9E, 0x8431}, //983 #CJK UNIFIED IDEOGRAPH
    {0x8A9F, 0x7CA5}, //984 #CJK UNIFIED IDEOGRAPH
    {0x8AA0, 0x5208}, //985 #CJK UNIFIED IDEOGRAPH
    {0x8AA1, 0x82C5}, //986 #CJK UNIFIED IDEOGRAPH
    {0x8AA2, 0x74E6}, //987 #CJK UNIFIED IDEOGRAPH
    {0x8AA3, 0x4E7E}, //988 #CJK UNIFIED IDEOGRAPH
    {0x8AA4, 0x4F83}, //989 #CJK UNIFIED IDEOGRAPH
    {0x8AA5, 0x51A0}, //990 #CJK UNIFIED IDEOGRAPH
    {0x8AA6, 0x5BD2}, //991 #CJK UNIFIED IDEOGRAPH
    {0x8AA7, 0x520A}, //992 #CJK UNIFIED IDEOGRAPH
    {0x8AA8, 0x52D8}, //993 #CJK UNIFIED IDEOGRAPH
    {0x8AA9, 0x52E7}, //994 #CJK UNIFIED IDEOGRAPH
    {0x8AAA, 0x5DFB}, //995 #CJK UNIFIED IDEOGRAPH
    {0x8AAB, 0x559A}, //996 #CJK UNIFIED IDEOGRAPH
    {0x8AAC, 0x582A}, //997 #CJK UNIFIED IDEOGRAPH
    {0x8AAD, 0x59E6}, //998 #CJK UNIFIED IDEOGRAPH
    {0x8AAE, 0x5B8C}, //999 #CJK UNIFIED IDEOGRAPH
    {0x8AAF, 0x5B98}, //1000 #CJK UNIFIED IDEOGRAPH
    {0x8AB0, 0x5BDB}, //1001 #CJK UNIFIED IDEOGRAPH
    {0x8AB1, 0x5E72}, //1002 #CJK UNIFIED IDEOGRAPH
    {0x8AB2, 0x5E79}, //1003 #CJK UNIFIED IDEOGRAPH
    {0x8AB3, 0x60A3}, //1004 #CJK UNIFIED IDEOGRAPH
    {0x8AB4, 0x611F}, //1005 #CJK UNIFIED IDEOGRAPH
    {0x8AB5, 0x6163}, //1006 #CJK UNIFIED IDEOGRAPH
    {0x8AB6, 0x61BE}, //1007 #CJK UNIFIED IDEOGRAPH
    {0x8AB7, 0x63DB}, //1008 #CJK UNIFIED IDEOGRAPH
    {0x8AB8, 0x6562}, //1009 #CJK UNIFIED IDEOGRAPH
    {0x8AB9, 0x67D1}, //1010 #CJK UNIFIED IDEOGRAPH
    {0x8ABA, 0x6853}, //1011 #CJK UNIFIED IDEOGRAPH
    {0x8ABB, 0x68FA}, //1012 #CJK UNIFIED IDEOGRAPH
    {0x8ABC, 0x6B3E}, //1013 #CJK UNIFIED IDEOGRAPH
    {0x8ABD, 0x6B53}, //1014 #CJK UNIFIED IDEOGRAPH
    {0x8ABE, 0x6C57}, //1015 #CJK UNIFIED IDEOGRAPH
    {0x8ABF, 0x6F22}, //1016 #CJK UNIFIED IDEOGRAPH
    {0x8AC0, 0x6F97}, //1017 #CJK UNIFIED IDEOGRAPH
    {0x8AC1, 0x6F45}, //1018 #CJK UNIFIED IDEOGRAPH
    {0x8AC2, 0x74B0}, //1019 #CJK UNIFIED IDEOGRAPH
    {0x8AC3, 0x7518}, //1020 #CJK UNIFIED IDEOGRAPH
    {0x8AC4, 0x76E3}, //1021 #CJK UNIFIED IDEOGRAPH
    {0x8AC5, 0x770B}, //1022 #CJK UNIFIED IDEOGRAPH
    {0x8AC6, 0x7AFF}, //1023 #CJK UNIFIED IDEOGRAPH
    {0x8AC7, 0x7BA1}, //1024 #CJK UNIFIED IDEOGRAPH
    {0x8AC8, 0x7C21}, //1025 #CJK UNIFIED IDEOGRAPH
    {0x8AC9, 0x7DE9}, //1026 #CJK UNIFIED IDEOGRAPH
    {0x8ACA, 0x7F36}, //1027 #CJK UNIFIED IDEOGRAPH
    {0x8ACB, 0x7FF0}, //1028 #CJK UNIFIED IDEOGRAPH
    {0x8ACC, 0x809D}, //1029 #CJK UNIFIED IDEOGRAPH
    {0x8ACD, 0x8266}, //1030 #CJK UNIFIED IDEOGRAPH
    {0x8ACE, 0x839E}, //1031 #CJK UNIFIED IDEOGRAPH
    {0x8ACF, 0x89B3}, //1032 #CJK UNIFIED IDEOGRAPH
    {0x8AD0, 0x8ACC}, //1033 #CJK UNIFIED IDEOGRAPH
    {0x8AD1, 0x8CAB}, //1034 #CJK UNIFIED IDEOGRAPH
    {0x8AD2, 0x9084}, //1035 #CJK UNIFIED IDEOGRAPH
    {0x8AD3, 0x9451}, //1036 #CJK UNIFIED IDEOGRAPH
    {0x8AD4, 0x9593}, //1037 #CJK UNIFIED IDEOGRAPH
    {0x8AD5, 0x9591}, //1038 #CJK UNIFIED IDEOGRAPH
    {0x8AD6, 0x95A2}, //1039 #CJK UNIFIED IDEOGRAPH
    {0x8AD7, 0x9665}, //1040 #CJK UNIFIED IDEOGRAPH
    {0x8AD8, 0x97D3}, //1041 #CJK UNIFIED IDEOGRAPH
    {0x8AD9, 0x9928}, //1042 #CJK UNIFIED IDEOGRAPH
    {0x8ADA, 0x8218}, //1043 #CJK UNIFIED IDEOGRAPH
    {0x8ADB, 0x4E38}, //1044 #CJK UNIFIED IDEOGRAPH
    {0x8ADC, 0x542B}, //1045 #CJK UNIFIED IDEOGRAPH
    {0x8ADD, 0x5CB8}, //1046 #CJK UNIFIED IDEOGRAPH
    {0x8ADE, 0x5DCC}, //1047 #CJK UNIFIED IDEOGRAPH
    {0x8ADF, 0x73A9}, //1048 #CJK UNIFIED IDEOGRAPH
    {0x8AE0, 0x764C}, //1049 #CJK UNIFIED IDEOGRAPH
    {0x8AE1, 0x773C}, //1050 #CJK UNIFIED IDEOGRAPH
    {0x8AE2, 0x5CA9}, //1051 #CJK UNIFIED IDEOGRAPH
    {0x8AE3, 0x7FEB}, //1052 #CJK UNIFIED IDEOGRAPH
    {0x8AE4, 0x8D0B}, //1053 #CJK UNIFIED IDEOGRAPH
    {0x8AE5, 0x96C1}, //1054 #CJK UNIFIED IDEOGRAPH
    {0x8AE6, 0x9811}, //1055 #CJK UNIFIED IDEOGRAPH
    {0x8AE7, 0x9854}, //1056 #CJK UNIFIED IDEOGRAPH
    {0x8AE8, 0x9858}, //1057 #CJK UNIFIED IDEOGRAPH
    {0x8AE9, 0x4F01}, //1058 #CJK UNIFIED IDEOGRAPH
    {0x8AEA, 0x4F0E}, //1059 #CJK UNIFIED IDEOGRAPH
    {0x8AEB, 0x5371}, //1060 #CJK UNIFIED IDEOGRAPH
    {0x8AEC, 0x559C}, //1061 #CJK UNIFIED IDEOGRAPH
    {0x8AED, 0x5668}, //1062 #CJK UNIFIED IDEOGRAPH
    {0x8AEE, 0x57FA}, //1063 #CJK UNIFIED IDEOGRAPH
    {0x8AEF, 0x5947}, //1064 #CJK UNIFIED IDEOGRAPH
    {0x8AF0, 0x5B09}, //1065 #CJK UNIFIED IDEOGRAPH
    {0x8AF1, 0x5BC4}, //1066 #CJK UNIFIED IDEOGRAPH
    {0x8AF2, 0x5C90}, //1067 #CJK UNIFIED IDEOGRAPH
    {0x8AF3, 0x5E0C}, //1068 #CJK UNIFIED IDEOGRAPH
    {0x8AF4, 0x5E7E}, //1069 #CJK UNIFIED IDEOGRAPH
    {0x8AF5, 0x5FCC}, //1070 #CJK UNIFIED IDEOGRAPH
    {0x8AF6, 0x63EE}, //1071 #CJK UNIFIED IDEOGRAPH
    {0x8AF7, 0x673A}, //1072 #CJK UNIFIED IDEOGRAPH
    {0x8AF8, 0x65D7}, //1073 #CJK UNIFIED IDEOGRAPH
    {0x8AF9, 0x65E2}, //1074 #CJK UNIFIED IDEOGRAPH
    {0x8AFA, 0x671F}, //1075 #CJK UNIFIED IDEOGRAPH
    {0x8AFB, 0x68CB}, //1076 #CJK UNIFIED IDEOGRAPH
    {0x8AFC, 0x68C4}, //1077 #CJK UNIFIED IDEOGRAPH
    {0x8B40, 0x6A5F}, //1078 #CJK UNIFIED IDEOGRAPH
    {0x8B41, 0x5E30}, //1079 #CJK UNIFIED IDEOGRAPH
    {0x8B42, 0x6BC5}, //1080 #CJK UNIFIED IDEOGRAPH
    {0x8B43, 0x6C17}, //1081 #CJK UNIFIED IDEOGRAPH
    {0x8B44, 0x6C7D}, //1082 #CJK UNIFIED IDEOGRAPH
    {0x8B45, 0x757F}, //1083 #CJK UNIFIED IDEOGRAPH
    {0x8B46, 0x7948}, //1084 #CJK UNIFIED IDEOGRAPH
    {0x8B47, 0x5B63}, //1085 #CJK UNIFIED IDEOGRAPH
    {0x8B48, 0x7A00}, //1086 #CJK UNIFIED IDEOGRAPH
    {0x8B49, 0x7D00}, //1087 #CJK UNIFIED IDEOGRAPH
    {0x8B4A, 0x5FBD}, //1088 #CJK UNIFIED IDEOGRAPH
    {0x8B4B, 0x898F}, //1089 #CJK UNIFIED IDEOGRAPH
    {0x8B4C, 0x8A18}, //1090 #CJK UNIFIED IDEOGRAPH
    {0x8B4D, 0x8CB4}, //1091 #CJK UNIFIED IDEOGRAPH
    {0x8B4E, 0x8D77}, //1092 #CJK UNIFIED IDEOGRAPH
    {0x8B4F, 0x8ECC}, //1093 #CJK UNIFIED IDEOGRAPH
    {0x8B50, 0x8F1D}, //1094 #CJK UNIFIED IDEOGRAPH
    {0x8B51, 0x98E2}, //1095 #CJK UNIFIED IDEOGRAPH
    {0x8B52, 0x9A0E}, //1096 #CJK UNIFIED IDEOGRAPH
    {0x8B53, 0x9B3C}, //1097 #CJK UNIFIED IDEOGRAPH
    {0x8B54, 0x4E80}, //1098 #CJK UNIFIED IDEOGRAPH
    {0x8B55, 0x507D}, //1099 #CJK UNIFIED IDEOGRAPH
    {0x8B56, 0x5100}, //1100 #CJK UNIFIED IDEOGRAPH
    {0x8B57, 0x5993}, //1101 #CJK UNIFIED IDEOGRAPH
    {0x8B58, 0x5B9C}, //1102 #CJK UNIFIED IDEOGRAPH
    {0x8B59, 0x622F}, //1103 #CJK UNIFIED IDEOGRAPH
    {0x8B5A, 0x6280}, //1104 #CJK UNIFIED IDEOGRAPH
    {0x8B5B, 0x64EC}, //1105 #CJK UNIFIED IDEOGRAPH
    {0x8B5C, 0x6B3A}, //1106 #CJK UNIFIED IDEOGRAPH
    {0x8B5D, 0x72A0}, //1107 #CJK UNIFIED IDEOGRAPH
    {0x8B5E, 0x7591}, //1108 #CJK UNIFIED IDEOGRAPH
    {0x8B5F, 0x7947}, //1109 #CJK UNIFIED IDEOGRAPH
    {0x8B60, 0x7FA9}, //1110 #CJK UNIFIED IDEOGRAPH
    {0x8B61, 0x87FB}, //1111 #CJK UNIFIED IDEOGRAPH
    {0x8B62, 0x8ABC}, //1112 #CJK UNIFIED IDEOGRAPH
    {0x8B63, 0x8B70}, //1113 #CJK UNIFIED IDEOGRAPH
    {0x8B64, 0x63AC}, //1114 #CJK UNIFIED IDEOGRAPH
    {0x8B65, 0x83CA}, //1115 #CJK UNIFIED IDEOGRAPH
    {0x8B66, 0x97A0}, //1116 #CJK UNIFIED IDEOGRAPH
    {0x8B67, 0x5409}, //1117 #CJK UNIFIED IDEOGRAPH
    {0x8B68, 0x5403}, //1118 #CJK UNIFIED IDEOGRAPH
    {0x8B69, 0x55AB}, //1119 #CJK UNIFIED IDEOGRAPH
    {0x8B6A, 0x6854}, //1120 #CJK UNIFIED IDEOGRAPH
    {0x8B6B, 0x6A58}, //1121 #CJK UNIFIED IDEOGRAPH
    {0x8B6C, 0x8A70}, //1122 #CJK UNIFIED IDEOGRAPH
    {0x8B6D, 0x7827}, //1123 #CJK UNIFIED IDEOGRAPH
    {0x8B6E, 0x6775}, //1124 #CJK UNIFIED IDEOGRAPH
    {0x8B6F, 0x9ECD}, //1125 #CJK UNIFIED IDEOGRAPH
    {0x8B70, 0x5374}, //1126 #CJK UNIFIED IDEOGRAPH
    {0x8B71, 0x5BA2}, //1127 #CJK UNIFIED IDEOGRAPH
    {0x8B72, 0x811A}, //1128 #CJK UNIFIED IDEOGRAPH
    {0x8B73, 0x8650}, //1129 #CJK UNIFIED IDEOGRAPH
    {0x8B74, 0x9006}, //1130 #CJK UNIFIED IDEOGRAPH
    {0x8B75, 0x4E18}, //1131 #CJK UNIFIED IDEOGRAPH
    {0x8B76, 0x4E45}, //1132 #CJK UNIFIED IDEOGRAPH
    {0x8B77, 0x4EC7}, //1133 #CJK UNIFIED IDEOGRAPH
    {0x8B78, 0x4F11}, //1134 #CJK UNIFIED IDEOGRAPH
    {0x8B79, 0x53CA}, //1135 #CJK UNIFIED IDEOGRAPH
    {0x8B7A, 0x5438}, //1136 #CJK UNIFIED IDEOGRAPH
    {0x8B7B, 0x5BAE}, //1137 #CJK UNIFIED IDEOGRAPH
    {0x8B7C, 0x5F13}, //1138 #CJK UNIFIED IDEOGRAPH
    {0x8B7D, 0x6025}, //1139 #CJK UNIFIED IDEOGRAPH
    {0x8B7E, 0x6551}, //1140 #CJK UNIFIED IDEOGRAPH
    {0x8B80, 0x673D}, //1141 #CJK UNIFIED IDEOGRAPH
    {0x8B81, 0x6C42}, //1142 #CJK UNIFIED IDEOGRAPH
    {0x8B82, 0x6C72}, //1143 #CJK UNIFIED IDEOGRAPH
    {0x8B83, 0x6CE3}, //1144 #CJK UNIFIED IDEOGRAPH
    {0x8B84, 0x7078}, //1145 #CJK UNIFIED IDEOGRAPH
    {0x8B85, 0x7403}, //1146 #CJK UNIFIED IDEOGRAPH
    {0x8B86, 0x7A76}, //1147 #CJK UNIFIED IDEOGRAPH
    {0x8B87, 0x7AAE}, //1148 #CJK UNIFIED IDEOGRAPH
    {0x8B88, 0x7B08}, //1149 #CJK UNIFIED IDEOGRAPH
    {0x8B89, 0x7D1A}, //1150 #CJK UNIFIED IDEOGRAPH
    {0x8B8A, 0x7CFE}, //1151 #CJK UNIFIED IDEOGRAPH
    {0x8B8B, 0x7D66}, //1152 #CJK UNIFIED IDEOGRAPH
    {0x8B8C, 0x65E7}, //1153 #CJK UNIFIED IDEOGRAPH
    {0x8B8D, 0x725B}, //1154 #CJK UNIFIED IDEOGRAPH
    {0x8B8E, 0x53BB}, //1155 #CJK UNIFIED IDEOGRAPH
    {0x8B8F, 0x5C45}, //1156 #CJK UNIFIED IDEOGRAPH
    {0x8B90, 0x5DE8}, //1157 #CJK UNIFIED IDEOGRAPH
    {0x8B91, 0x62D2}, //1158 #CJK UNIFIED IDEOGRAPH
    {0x8B92, 0x62E0}, //1159 #CJK UNIFIED IDEOGRAPH
    {0x8B93, 0x6319}, //1160 #CJK UNIFIED IDEOGRAPH
    {0x8B94, 0x6E20}, //1161 #CJK UNIFIED IDEOGRAPH
    {0x8B95, 0x865A}, //1162 #CJK UNIFIED IDEOGRAPH
    {0x8B96, 0x8A31}, //1163 #CJK UNIFIED IDEOGRAPH
    {0x8B97, 0x8DDD}, //1164 #CJK UNIFIED IDEOGRAPH
    {0x8B98, 0x92F8}, //1165 #CJK UNIFIED IDEOGRAPH
    {0x8B99, 0x6F01}, //1166 #CJK UNIFIED IDEOGRAPH
    {0x8B9A, 0x79A6}, //1167 #CJK UNIFIED IDEOGRAPH
    {0x8B9B, 0x9B5A}, //1168 #CJK UNIFIED IDEOGRAPH
    {0x8B9C, 0x4EA8}, //1169 #CJK UNIFIED IDEOGRAPH
    {0x8B9D, 0x4EAB}, //1170 #CJK UNIFIED IDEOGRAPH
    {0x8B9E, 0x4EAC}, //1171 #CJK UNIFIED IDEOGRAPH
    {0x8B9F, 0x4F9B}, //1172 #CJK UNIFIED IDEOGRAPH
    {0x8BA0, 0x4FA0}, //1173 #CJK UNIFIED IDEOGRAPH
    {0x8BA1, 0x50D1}, //1174 #CJK UNIFIED IDEOGRAPH
    {0x8BA2, 0x5147}, //1175 #CJK UNIFIED IDEOGRAPH
    {0x8BA3, 0x7AF6}, //1176 #CJK UNIFIED IDEOGRAPH
    {0x8BA4, 0x5171}, //1177 #CJK UNIFIED IDEOGRAPH
    {0x8BA5, 0x51F6}, //1178 #CJK UNIFIED IDEOGRAPH
    {0x8BA6, 0x5354}, //1179 #CJK UNIFIED IDEOGRAPH
    {0x8BA7, 0x5321}, //1180 #CJK UNIFIED IDEOGRAPH
    {0x8BA8, 0x537F}, //1181 #CJK UNIFIED IDEOGRAPH
    {0x8BA9, 0x53EB}, //1182 #CJK UNIFIED IDEOGRAPH
    {0x8BAA, 0x55AC}, //1183 #CJK UNIFIED IDEOGRAPH
    {0x8BAB, 0x5883}, //1184 #CJK UNIFIED IDEOGRAPH
    {0x8BAC, 0x5CE1}, //1185 #CJK UNIFIED IDEOGRAPH
    {0x8BAD, 0x5F37}, //1186 #CJK UNIFIED IDEOGRAPH
    {0x8BAE, 0x5F4A}, //1187 #CJK UNIFIED IDEOGRAPH
    {0x8BAF, 0x602F}, //1188 #CJK UNIFIED IDEOGRAPH
    {0x8BB0, 0x6050}, //1189 #CJK UNIFIED IDEOGRAPH
    {0x8BB1, 0x606D}, //1190 #CJK UNIFIED IDEOGRAPH
    {0x8BB2, 0x631F}, //1191 #CJK UNIFIED IDEOGRAPH
    {0x8BB3, 0x6559}, //1192 #CJK UNIFIED IDEOGRAPH
    {0x8BB4, 0x6A4B}, //1193 #CJK UNIFIED IDEOGRAPH
    {0x8BB5, 0x6CC1}, //1194 #CJK UNIFIED IDEOGRAPH
    {0x8BB6, 0x72C2}, //1195 #CJK UNIFIED IDEOGRAPH
    {0x8BB7, 0x72ED}, //1196 #CJK UNIFIED IDEOGRAPH
    {0x8BB8, 0x77EF}, //1197 #CJK UNIFIED IDEOGRAPH
    {0x8BB9, 0x80F8}, //1198 #CJK UNIFIED IDEOGRAPH
    {0x8BBA, 0x8105}, //1199 #CJK UNIFIED IDEOGRAPH
    {0x8BBB, 0x8208}, //1200 #CJK UNIFIED IDEOGRAPH
    {0x8BBC, 0x854E}, //1201 #CJK UNIFIED IDEOGRAPH
    {0x8BBD, 0x90F7}, //1202 #CJK UNIFIED IDEOGRAPH
    {0x8BBE, 0x93E1}, //1203 #CJK UNIFIED IDEOGRAPH
    {0x8BBF, 0x97FF}, //1204 #CJK UNIFIED IDEOGRAPH
    {0x8BC0, 0x9957}, //1205 #CJK UNIFIED IDEOGRAPH
    {0x8BC1, 0x9A5A}, //1206 #CJK UNIFIED IDEOGRAPH
    {0x8BC2, 0x4EF0}, //1207 #CJK UNIFIED IDEOGRAPH
    {0x8BC3, 0x51DD}, //1208 #CJK UNIFIED IDEOGRAPH
    {0x8BC4, 0x5C2D}, //1209 #CJK UNIFIED IDEOGRAPH
    {0x8BC5, 0x6681}, //1210 #CJK UNIFIED IDEOGRAPH
    {0x8BC6, 0x696D}, //1211 #CJK UNIFIED IDEOGRAPH
    {0x8BC7, 0x5C40}, //1212 #CJK UNIFIED IDEOGRAPH
    {0x8BC8, 0x66F2}, //1213 #CJK UNIFIED IDEOGRAPH
    {0x8BC9, 0x6975}, //1214 #CJK UNIFIED IDEOGRAPH
    {0x8BCA, 0x7389}, //1215 #CJK UNIFIED IDEOGRAPH
    {0x8BCB, 0x6850}, //1216 #CJK UNIFIED IDEOGRAPH
    {0x8BCC, 0x7C81}, //1217 #CJK UNIFIED IDEOGRAPH
    {0x8BCD, 0x50C5}, //1218 #CJK UNIFIED IDEOGRAPH
    {0x8BCE, 0x52E4}, //1219 #CJK UNIFIED IDEOGRAPH
    {0x8BCF, 0x5747}, //1220 #CJK UNIFIED IDEOGRAPH
    {0x8BD0, 0x5DFE}, //1221 #CJK UNIFIED IDEOGRAPH
    {0x8BD1, 0x9326}, //1222 #CJK UNIFIED IDEOGRAPH
    {0x8BD2, 0x65A4}, //1223 #CJK UNIFIED IDEOGRAPH
    {0x8BD3, 0x6B23}, //1224 #CJK UNIFIED IDEOGRAPH
    {0x8BD4, 0x6B3D}, //1225 #CJK UNIFIED IDEOGRAPH
    {0x8BD5, 0x7434}, //1226 #CJK UNIFIED IDEOGRAPH
    {0x8BD6, 0x7981}, //1227 #CJK UNIFIED IDEOGRAPH
    {0x8BD7, 0x79BD}, //1228 #CJK UNIFIED IDEOGRAPH
    {0x8BD8, 0x7B4B}, //1229 #CJK UNIFIED IDEOGRAPH
    {0x8BD9, 0x7DCA}, //1230 #CJK UNIFIED IDEOGRAPH
    {0x8BDA, 0x82B9}, //1231 #CJK UNIFIED IDEOGRAPH
    {0x8BDB, 0x83CC}, //1232 #CJK UNIFIED IDEOGRAPH
    {0x8BDC, 0x887F}, //1233 #CJK UNIFIED IDEOGRAPH
    {0x8BDD, 0x895F}, //1234 #CJK UNIFIED IDEOGRAPH
    {0x8BDE, 0x8B39}, //1235 #CJK UNIFIED IDEOGRAPH
    {0x8BDF, 0x8FD1}, //1236 #CJK UNIFIED IDEOGRAPH
    {0x8BE0, 0x91D1}, //1237 #CJK UNIFIED IDEOGRAPH
    {0x8BE1, 0x541F}, //1238 #CJK UNIFIED IDEOGRAPH
    {0x8BE2, 0x9280}, //1239 #CJK UNIFIED IDEOGRAPH
    {0x8BE3, 0x4E5D}, //1240 #CJK UNIFIED IDEOGRAPH
    {0x8BE4, 0x5036}, //1241 #CJK UNIFIED IDEOGRAPH
    {0x8BE5, 0x53E5}, //1242 #CJK UNIFIED IDEOGRAPH
    {0x8BE6, 0x533A}, //1243 #CJK UNIFIED IDEOGRAPH
    {0x8BE7, 0x72D7}, //1244 #CJK UNIFIED IDEOGRAPH
    {0x8BE8, 0x7396}, //1245 #CJK UNIFIED IDEOGRAPH
    {0x8BE9, 0x77E9}, //1246 #CJK UNIFIED IDEOGRAPH
    {0x8BEA, 0x82E6}, //1247 #CJK UNIFIED IDEOGRAPH
    {0x8BEB, 0x8EAF}, //1248 #CJK UNIFIED IDEOGRAPH
    {0x8BEC, 0x99C6}, //1249 #CJK UNIFIED IDEOGRAPH
    {0x8BED, 0x99C8}, //1250 #CJK UNIFIED IDEOGRAPH
    {0x8BEE, 0x99D2}, //1251 #CJK UNIFIED IDEOGRAPH
    {0x8BEF, 0x5177}, //1252 #CJK UNIFIED IDEOGRAPH
    {0x8BF0, 0x611A}, //1253 #CJK UNIFIED IDEOGRAPH
    {0x8BF1, 0x865E}, //1254 #CJK UNIFIED IDEOGRAPH
    {0x8BF2, 0x55B0}, //1255 #CJK UNIFIED IDEOGRAPH
    {0x8BF3, 0x7A7A}, //1256 #CJK UNIFIED IDEOGRAPH
    {0x8BF4, 0x5076}, //1257 #CJK UNIFIED IDEOGRAPH
    {0x8BF5, 0x5BD3}, //1258 #CJK UNIFIED IDEOGRAPH
    {0x8BF6, 0x9047}, //1259 #CJK UNIFIED IDEOGRAPH
    {0x8BF7, 0x9685}, //1260 #CJK UNIFIED IDEOGRAPH
    {0x8BF8, 0x4E32}, //1261 #CJK UNIFIED IDEOGRAPH
    {0x8BF9, 0x6ADB}, //1262 #CJK UNIFIED IDEOGRAPH
    {0x8BFA, 0x91E7}, //1263 #CJK UNIFIED IDEOGRAPH
    {0x8BFB, 0x5C51}, //1264 #CJK UNIFIED IDEOGRAPH
    {0x8BFC, 0x5C48}, //1265 #CJK UNIFIED IDEOGRAPH
    {0x8C40, 0x6398}, //1266 #CJK UNIFIED IDEOGRAPH
    {0x8C41, 0x7A9F}, //1267 #CJK UNIFIED IDEOGRAPH
    {0x8C42, 0x6C93}, //1268 #CJK UNIFIED IDEOGRAPH
    {0x8C43, 0x9774}, //1269 #CJK UNIFIED IDEOGRAPH
    {0x8C44, 0x8F61}, //1270 #CJK UNIFIED IDEOGRAPH
    {0x8C45, 0x7AAA}, //1271 #CJK UNIFIED IDEOGRAPH
    {0x8C46, 0x718A}, //1272 #CJK UNIFIED IDEOGRAPH
    {0x8C47, 0x9688}, //1273 #CJK UNIFIED IDEOGRAPH
    {0x8C48, 0x7C82}, //1274 #CJK UNIFIED IDEOGRAPH
    {0x8C49, 0x6817}, //1275 #CJK UNIFIED IDEOGRAPH
    {0x8C4A, 0x7E70}, //1276 #CJK UNIFIED IDEOGRAPH
    {0x8C4B, 0x6851}, //1277 #CJK UNIFIED IDEOGRAPH
    {0x8C4C, 0x936C}, //1278 #CJK UNIFIED IDEOGRAPH
    {0x8C4D, 0x52F2}, //1279 #CJK UNIFIED IDEOGRAPH
    {0x8C4E, 0x541B}, //1280 #CJK UNIFIED IDEOGRAPH
    {0x8C4F, 0x85AB}, //1281 #CJK UNIFIED IDEOGRAPH
    {0x8C50, 0x8A13}, //1282 #CJK UNIFIED IDEOGRAPH
    {0x8C51, 0x7FA4}, //1283 #CJK UNIFIED IDEOGRAPH
    {0x8C52, 0x8ECD}, //1284 #CJK UNIFIED IDEOGRAPH
    {0x8C53, 0x90E1}, //1285 #CJK UNIFIED IDEOGRAPH
    {0x8C54, 0x5366}, //1286 #CJK UNIFIED IDEOGRAPH
    {0x8C55, 0x8888}, //1287 #CJK UNIFIED IDEOGRAPH
    {0x8C56, 0x7941}, //1288 #CJK UNIFIED IDEOGRAPH
    {0x8C57, 0x4FC2}, //1289 #CJK UNIFIED IDEOGRAPH
    {0x8C58, 0x50BE}, //1290 #CJK UNIFIED IDEOGRAPH
    {0x8C59, 0x5211}, //1291 #CJK UNIFIED IDEOGRAPH
    {0x8C5A, 0x5144}, //1292 #CJK UNIFIED IDEOGRAPH
    {0x8C5B, 0x5553}, //1293 #CJK UNIFIED IDEOGRAPH
    {0x8C5C, 0x572D}, //1294 #CJK UNIFIED IDEOGRAPH
    {0x8C5D, 0x73EA}, //1295 #CJK UNIFIED IDEOGRAPH
    {0x8C5E, 0x578B}, //1296 #CJK UNIFIED IDEOGRAPH
    {0x8C5F, 0x5951}, //1297 #CJK UNIFIED IDEOGRAPH
    {0x8C60, 0x5F62}, //1298 #CJK UNIFIED IDEOGRAPH
    {0x8C61, 0x5F84}, //1299 #CJK UNIFIED IDEOGRAPH
    {0x8C62, 0x6075}, //1300 #CJK UNIFIED IDEOGRAPH
    {0x8C63, 0x6176}, //1301 #CJK UNIFIED IDEOGRAPH
    {0x8C64, 0x6167}, //1302 #CJK UNIFIED IDEOGRAPH
    {0x8C65, 0x61A9}, //1303 #CJK UNIFIED IDEOGRAPH
    {0x8C66, 0x63B2}, //1304 #CJK UNIFIED IDEOGRAPH
    {0x8C67, 0x643A}, //1305 #CJK UNIFIED IDEOGRAPH
    {0x8C68, 0x656C}, //1306 #CJK UNIFIED IDEOGRAPH
    {0x8C69, 0x666F}, //1307 #CJK UNIFIED IDEOGRAPH
    {0x8C6A, 0x6842}, //1308 #CJK UNIFIED IDEOGRAPH
    {0x8C6B, 0x6E13}, //1309 #CJK UNIFIED IDEOGRAPH
    {0x8C6C, 0x7566}, //1310 #CJK UNIFIED IDEOGRAPH
    {0x8C6D, 0x7A3D}, //1311 #CJK UNIFIED IDEOGRAPH
    {0x8C6E, 0x7CFB}, //1312 #CJK UNIFIED IDEOGRAPH
    {0x8C6F, 0x7D4C}, //1313 #CJK UNIFIED IDEOGRAPH
    {0x8C70, 0x7D99}, //1314 #CJK UNIFIED IDEOGRAPH
    {0x8C71, 0x7E4B}, //1315 #CJK UNIFIED IDEOGRAPH
    {0x8C72, 0x7F6B}, //1316 #CJK UNIFIED IDEOGRAPH
    {0x8C73, 0x830E}, //1317 #CJK UNIFIED IDEOGRAPH
    {0x8C74, 0x834A}, //1318 #CJK UNIFIED IDEOGRAPH
    {0x8C75, 0x86CD}, //1319 #CJK UNIFIED IDEOGRAPH
    {0x8C76, 0x8A08}, //1320 #CJK UNIFIED IDEOGRAPH
    {0x8C77, 0x8A63}, //1321 #CJK UNIFIED IDEOGRAPH
    {0x8C78, 0x8B66}, //1322 #CJK UNIFIED IDEOGRAPH
    {0x8C79, 0x8EFD}, //1323 #CJK UNIFIED IDEOGRAPH
    {0x8C7A, 0x981A}, //1324 #CJK UNIFIED IDEOGRAPH
    {0x8C7B, 0x9D8F}, //1325 #CJK UNIFIED IDEOGRAPH
    {0x8C7C, 0x82B8}, //1326 #CJK UNIFIED IDEOGRAPH
    {0x8C7D, 0x8FCE}, //1327 #CJK UNIFIED IDEOGRAPH
    {0x8C7E, 0x9BE8}, //1328 #CJK UNIFIED IDEOGRAPH
    {0x8C80, 0x5287}, //1329 #CJK UNIFIED IDEOGRAPH
    {0x8C81, 0x621F}, //1330 #CJK UNIFIED IDEOGRAPH
    {0x8C82, 0x6483}, //1331 #CJK UNIFIED IDEOGRAPH
    {0x8C83, 0x6FC0}, //1332 #CJK UNIFIED IDEOGRAPH
    {0x8C84, 0x9699}, //1333 #CJK UNIFIED IDEOGRAPH
    {0x8C85, 0x6841}, //1334 #CJK UNIFIED IDEOGRAPH
    {0x8C86, 0x5091}, //1335 #CJK UNIFIED IDEOGRAPH
    {0x8C87, 0x6B20}, //1336 #CJK UNIFIED IDEOGRAPH
    {0x8C88, 0x6C7A}, //1337 #CJK UNIFIED IDEOGRAPH
    {0x8C89, 0x6F54}, //1338 #CJK UNIFIED IDEOGRAPH
    {0x8C8A, 0x7A74}, //1339 #CJK UNIFIED IDEOGRAPH
    {0x8C8B, 0x7D50}, //1340 #CJK UNIFIED IDEOGRAPH
    {0x8C8C, 0x8840}, //1341 #CJK UNIFIED IDEOGRAPH
    {0x8C8D, 0x8A23}, //1342 #CJK UNIFIED IDEOGRAPH
    {0x8C8E, 0x6708}, //1343 #CJK UNIFIED IDEOGRAPH
    {0x8C8F, 0x4EF6}, //1344 #CJK UNIFIED IDEOGRAPH
    {0x8C90, 0x5039}, //1345 #CJK UNIFIED IDEOGRAPH
    {0x8C91, 0x5026}, //1346 #CJK UNIFIED IDEOGRAPH
    {0x8C92, 0x5065}, //1347 #CJK UNIFIED IDEOGRAPH
    {0x8C93, 0x517C}, //1348 #CJK UNIFIED IDEOGRAPH
    {0x8C94, 0x5238}, //1349 #CJK UNIFIED IDEOGRAPH
    {0x8C95, 0x5263}, //1350 #CJK UNIFIED IDEOGRAPH
    {0x8C96, 0x55A7}, //1351 #CJK UNIFIED IDEOGRAPH
    {0x8C97, 0x570F}, //1352 #CJK UNIFIED IDEOGRAPH
    {0x8C98, 0x5805}, //1353 #CJK UNIFIED IDEOGRAPH
    {0x8C99, 0x5ACC}, //1354 #CJK UNIFIED IDEOGRAPH
    {0x8C9A, 0x5EFA}, //1355 #CJK UNIFIED IDEOGRAPH
    {0x8C9B, 0x61B2}, //1356 #CJK UNIFIED IDEOGRAPH
    {0x8C9C, 0x61F8}, //1357 #CJK UNIFIED IDEOGRAPH
    {0x8C9D, 0x62F3}, //1358 #CJK UNIFIED IDEOGRAPH
    {0x8C9E, 0x6372}, //1359 #CJK UNIFIED IDEOGRAPH
    {0x8C9F, 0x691C}, //1360 #CJK UNIFIED IDEOGRAPH
    {0x8CA0, 0x6A29}, //1361 #CJK UNIFIED IDEOGRAPH
    {0x8CA1, 0x727D}, //1362 #CJK UNIFIED IDEOGRAPH
    {0x8CA2, 0x72AC}, //1363 #CJK UNIFIED IDEOGRAPH
    {0x8CA3, 0x732E}, //1364 #CJK UNIFIED IDEOGRAPH
    {0x8CA4, 0x7814}, //1365 #CJK UNIFIED IDEOGRAPH
    {0x8CA5, 0x786F}, //1366 #CJK UNIFIED IDEOGRAPH
    {0x8CA6, 0x7D79}, //1367 #CJK UNIFIED IDEOGRAPH
    {0x8CA7, 0x770C}, //1368 #CJK UNIFIED IDEOGRAPH
    {0x8CA8, 0x80A9}, //1369 #CJK UNIFIED IDEOGRAPH
    {0x8CA9, 0x898B}, //1370 #CJK UNIFIED IDEOGRAPH
    {0x8CAA, 0x8B19}, //1371 #CJK UNIFIED IDEOGRAPH
    {0x8CAB, 0x8CE2}, //1372 #CJK UNIFIED IDEOGRAPH
    {0x8CAC, 0x8ED2}, //1373 #CJK UNIFIED IDEOGRAPH
    {0x8CAD, 0x9063}, //1374 #CJK UNIFIED IDEOGRAPH
    {0x8CAE, 0x9375}, //1375 #CJK UNIFIED IDEOGRAPH
    {0x8CAF, 0x967A}, //1376 #CJK UNIFIED IDEOGRAPH
    {0x8CB0, 0x9855}, //1377 #CJK UNIFIED IDEOGRAPH
    {0x8CB1, 0x9A13}, //1378 #CJK UNIFIED IDEOGRAPH
    {0x8CB2, 0x9E78}, //1379 #CJK UNIFIED IDEOGRAPH
    {0x8CB3, 0x5143}, //1380 #CJK UNIFIED IDEOGRAPH
    {0x8CB4, 0x539F}, //1381 #CJK UNIFIED IDEOGRAPH
    {0x8CB5, 0x53B3}, //1382 #CJK UNIFIED IDEOGRAPH
    {0x8CB6, 0x5E7B}, //1383 #CJK UNIFIED IDEOGRAPH
    {0x8CB7, 0x5F26}, //1384 #CJK UNIFIED IDEOGRAPH
    {0x8CB8, 0x6E1B}, //1385 #CJK UNIFIED IDEOGRAPH
    {0x8CB9, 0x6E90}, //1386 #CJK UNIFIED IDEOGRAPH
    {0x8CBA, 0x7384}, //1387 #CJK UNIFIED IDEOGRAPH
    {0x8CBB, 0x73FE}, //1388 #CJK UNIFIED IDEOGRAPH
    {0x8CBC, 0x7D43}, //1389 #CJK UNIFIED IDEOGRAPH
    {0x8CBD, 0x8237}, //1390 #CJK UNIFIED IDEOGRAPH
    {0x8CBE, 0x8A00}, //1391 #CJK UNIFIED IDEOGRAPH
    {0x8CBF, 0x8AFA}, //1392 #CJK UNIFIED IDEOGRAPH
    {0x8CC0, 0x9650}, //1393 #CJK UNIFIED IDEOGRAPH
    {0x8CC1, 0x4E4E}, //1394 #CJK UNIFIED IDEOGRAPH
    {0x8CC2, 0x500B}, //1395 #CJK UNIFIED IDEOGRAPH
    {0x8CC3, 0x53E4}, //1396 #CJK UNIFIED IDEOGRAPH
    {0x8CC4, 0x547C}, //1397 #CJK UNIFIED IDEOGRAPH
    {0x8CC5, 0x56FA}, //1398 #CJK UNIFIED IDEOGRAPH
    {0x8CC6, 0x59D1}, //1399 #CJK UNIFIED IDEOGRAPH
    {0x8CC7, 0x5B64}, //1400 #CJK UNIFIED IDEOGRAPH
    {0x8CC8, 0x5DF1}, //1401 #CJK UNIFIED IDEOGRAPH
    {0x8CC9, 0x5EAB}, //1402 #CJK UNIFIED IDEOGRAPH
    {0x8CCA, 0x5F27}, //1403 #CJK UNIFIED IDEOGRAPH
    {0x8CCB, 0x6238}, //1404 #CJK UNIFIED IDEOGRAPH
    {0x8CCC, 0x6545}, //1405 #CJK UNIFIED IDEOGRAPH
    {0x8CCD, 0x67AF}, //1406 #CJK UNIFIED IDEOGRAPH
    {0x8CCE, 0x6E56}, //1407 #CJK UNIFIED IDEOGRAPH
    {0x8CCF, 0x72D0}, //1408 #CJK UNIFIED IDEOGRAPH
    {0x8CD0, 0x7CCA}, //1409 #CJK UNIFIED IDEOGRAPH
    {0x8CD1, 0x88B4}, //1410 #CJK UNIFIED IDEOGRAPH
    {0x8CD2, 0x80A1}, //1411 #CJK UNIFIED IDEOGRAPH
    {0x8CD3, 0x80E1}, //1412 #CJK UNIFIED IDEOGRAPH
    {0x8CD4, 0x83F0}, //1413 #CJK UNIFIED IDEOGRAPH
    {0x8CD5, 0x864E}, //1414 #CJK UNIFIED IDEOGRAPH
    {0x8CD6, 0x8A87}, //1415 #CJK UNIFIED IDEOGRAPH
    {0x8CD7, 0x8DE8}, //1416 #CJK UNIFIED IDEOGRAPH
    {0x8CD8, 0x9237}, //1417 #CJK UNIFIED IDEOGRAPH
    {0x8CD9, 0x96C7}, //1418 #CJK UNIFIED IDEOGRAPH
    {0x8CDA, 0x9867}, //1419 #CJK UNIFIED IDEOGRAPH
    {0x8CDB, 0x9F13}, //1420 #CJK UNIFIED IDEOGRAPH
    {0x8CDC, 0x4E94}, //1421 #CJK UNIFIED IDEOGRAPH
    {0x8CDD, 0x4E92}, //1422 #CJK UNIFIED IDEOGRAPH
    {0x8CDE, 0x4F0D}, //1423 #CJK UNIFIED IDEOGRAPH
    {0x8CDF, 0x5348}, //1424 #CJK UNIFIED IDEOGRAPH
    {0x8CE0, 0x5449}, //1425 #CJK UNIFIED IDEOGRAPH
    {0x8CE1, 0x543E}, //1426 #CJK UNIFIED IDEOGRAPH
    {0x8CE2, 0x5A2F}, //1427 #CJK UNIFIED IDEOGRAPH
    {0x8CE3, 0x5F8C}, //1428 #CJK UNIFIED IDEOGRAPH
    {0x8CE4, 0x5FA1}, //1429 #CJK UNIFIED IDEOGRAPH
    {0x8CE5, 0x609F}, //1430 #CJK UNIFIED IDEOGRAPH
    {0x8CE6, 0x68A7}, //1431 #CJK UNIFIED IDEOGRAPH
    {0x8CE7, 0x6A8E}, //1432 #CJK UNIFIED IDEOGRAPH
    {0x8CE8, 0x745A}, //1433 #CJK UNIFIED IDEOGRAPH
    {0x8CE9, 0x7881}, //1434 #CJK UNIFIED IDEOGRAPH
    {0x8CEA, 0x8A9E}, //1435 #CJK UNIFIED IDEOGRAPH
    {0x8CEB, 0x8AA4}, //1436 #CJK UNIFIED IDEOGRAPH
    {0x8CEC, 0x8B77}, //1437 #CJK UNIFIED IDEOGRAPH
    {0x8CED, 0x9190}, //1438 #CJK UNIFIED IDEOGRAPH
    {0x8CEE, 0x4E5E}, //1439 #CJK UNIFIED IDEOGRAPH
    {0x8CEF, 0x9BC9}, //1440 #CJK UNIFIED IDEOGRAPH
    {0x8CF0, 0x4EA4}, //1441 #CJK UNIFIED IDEOGRAPH
    {0x8CF1, 0x4F7C}, //1442 #CJK UNIFIED IDEOGRAPH
    {0x8CF2, 0x4FAF}, //1443 #CJK UNIFIED IDEOGRAPH
    {0x8CF3, 0x5019}, //1444 #CJK UNIFIED IDEOGRAPH
    {0x8CF4, 0x5016}, //1445 #CJK UNIFIED IDEOGRAPH
    {0x8CF5, 0x5149}, //1446 #CJK UNIFIED IDEOGRAPH
    {0x8CF6, 0x516C}, //1447 #CJK UNIFIED IDEOGRAPH
    {0x8CF7, 0x529F}, //1448 #CJK UNIFIED IDEOGRAPH
    {0x8CF8, 0x52B9}, //1449 #CJK UNIFIED IDEOGRAPH
    {0x8CF9, 0x52FE}, //1450 #CJK UNIFIED IDEOGRAPH
    {0x8CFA, 0x539A}, //1451 #CJK UNIFIED IDEOGRAPH
    {0x8CFB, 0x53E3}, //1452 #CJK UNIFIED IDEOGRAPH
    {0x8CFC, 0x5411}, //1453 #CJK UNIFIED IDEOGRAPH
    {0x8D40, 0x540E}, //1454 #CJK UNIFIED IDEOGRAPH
    {0x8D41, 0x5589}, //1455 #CJK UNIFIED IDEOGRAPH
    {0x8D42, 0x5751}, //1456 #CJK UNIFIED IDEOGRAPH
    {0x8D43, 0x57A2}, //1457 #CJK UNIFIED IDEOGRAPH
    {0x8D44, 0x597D}, //1458 #CJK UNIFIED IDEOGRAPH
    {0x8D45, 0x5B54}, //1459 #CJK UNIFIED IDEOGRAPH
    {0x8D46, 0x5B5D}, //1460 #CJK UNIFIED IDEOGRAPH
    {0x8D47, 0x5B8F}, //1461 #CJK UNIFIED IDEOGRAPH
    {0x8D48, 0x5DE5}, //1462 #CJK UNIFIED IDEOGRAPH
    {0x8D49, 0x5DE7}, //1463 #CJK UNIFIED IDEOGRAPH
    {0x8D4A, 0x5DF7}, //1464 #CJK UNIFIED IDEOGRAPH
    {0x8D4B, 0x5E78}, //1465 #CJK UNIFIED IDEOGRAPH
    {0x8D4C, 0x5E83}, //1466 #CJK UNIFIED IDEOGRAPH
    {0x8D4D, 0x5E9A}, //1467 #CJK UNIFIED IDEOGRAPH
    {0x8D4E, 0x5EB7}, //1468 #CJK UNIFIED IDEOGRAPH
    {0x8D4F, 0x5F18}, //1469 #CJK UNIFIED IDEOGRAPH
    {0x8D50, 0x6052}, //1470 #CJK UNIFIED IDEOGRAPH
    {0x8D51, 0x614C}, //1471 #CJK UNIFIED IDEOGRAPH
    {0x8D52, 0x6297}, //1472 #CJK UNIFIED IDEOGRAPH
    {0x8D53, 0x62D8}, //1473 #CJK UNIFIED IDEOGRAPH
    {0x8D54, 0x63A7}, //1474 #CJK UNIFIED IDEOGRAPH
    {0x8D55, 0x653B}, //1475 #CJK UNIFIED IDEOGRAPH
    {0x8D56, 0x6602}, //1476 #CJK UNIFIED IDEOGRAPH
    {0x8D57, 0x6643}, //1477 #CJK UNIFIED IDEOGRAPH
    {0x8D58, 0x66F4}, //1478 #CJK UNIFIED IDEOGRAPH
    {0x8D59, 0x676D}, //1479 #CJK UNIFIED IDEOGRAPH
    {0x8D5A, 0x6821}, //1480 #CJK UNIFIED IDEOGRAPH
    {0x8D5B, 0x6897}, //1481 #CJK UNIFIED IDEOGRAPH
    {0x8D5C, 0x69CB}, //1482 #CJK UNIFIED IDEOGRAPH
    {0x8D5D, 0x6C5F}, //1483 #CJK UNIFIED IDEOGRAPH
    {0x8D5E, 0x6D2A}, //1484 #CJK UNIFIED IDEOGRAPH
    {0x8D5F, 0x6D69}, //1485 #CJK UNIFIED IDEOGRAPH
    {0x8D60, 0x6E2F}, //1486 #CJK UNIFIED IDEOGRAPH
    {0x8D61, 0x6E9D}, //1487 #CJK UNIFIED IDEOGRAPH
    {0x8D62, 0x7532}, //1488 #CJK UNIFIED IDEOGRAPH
    {0x8D63, 0x7687}, //1489 #CJK UNIFIED IDEOGRAPH
    {0x8D64, 0x786C}, //1490 #CJK UNIFIED IDEOGRAPH
    {0x8D65, 0x7A3F}, //1491 #CJK UNIFIED IDEOGRAPH
    {0x8D66, 0x7CE0}, //1492 #CJK UNIFIED IDEOGRAPH
    {0x8D67, 0x7D05}, //1493 #CJK UNIFIED IDEOGRAPH
    {0x8D68, 0x7D18}, //1494 #CJK UNIFIED IDEOGRAPH
    {0x8D69, 0x7D5E}, //1495 #CJK UNIFIED IDEOGRAPH
    {0x8D6A, 0x7DB1}, //1496 #CJK UNIFIED IDEOGRAPH
    {0x8D6B, 0x8015}, //1497 #CJK UNIFIED IDEOGRAPH
    {0x8D6C, 0x8003}, //1498 #CJK UNIFIED IDEOGRAPH
    {0x8D6D, 0x80AF}, //1499 #CJK UNIFIED IDEOGRAPH
    {0x8D6E, 0x80B1}, //1500 #CJK UNIFIED IDEOGRAPH
    {0x8D6F, 0x8154}, //1501 #CJK UNIFIED IDEOGRAPH
    {0x8D70, 0x818F}, //1502 #CJK UNIFIED IDEOGRAPH
    {0x8D71, 0x822A}, //1503 #CJK UNIFIED IDEOGRAPH
    {0x8D72, 0x8352}, //1504 #CJK UNIFIED IDEOGRAPH
    {0x8D73, 0x884C}, //1505 #CJK UNIFIED IDEOGRAPH
    {0x8D74, 0x8861}, //1506 #CJK UNIFIED IDEOGRAPH
    {0x8D75, 0x8B1B}, //1507 #CJK UNIFIED IDEOGRAPH
    {0x8D76, 0x8CA2}, //1508 #CJK UNIFIED IDEOGRAPH
    {0x8D77, 0x8CFC}, //1509 #CJK UNIFIED IDEOGRAPH
    {0x8D78, 0x90CA}, //1510 #CJK UNIFIED IDEOGRAPH
    {0x8D79, 0x9175}, //1511 #CJK UNIFIED IDEOGRAPH
    {0x8D7A, 0x9271}, //1512 #CJK UNIFIED IDEOGRAPH
    {0x8D7B, 0x783F}, //1513 #CJK UNIFIED IDEOGRAPH
    {0x8D7C, 0x92FC}, //1514 #CJK UNIFIED IDEOGRAPH
    {0x8D7D, 0x95A4}, //1515 #CJK UNIFIED IDEOGRAPH
    {0x8D7E, 0x964D}, //1516 #CJK UNIFIED IDEOGRAPH
    {0x8D80, 0x9805}, //1517 #CJK UNIFIED IDEOGRAPH
    {0x8D81, 0x9999}, //1518 #CJK UNIFIED IDEOGRAPH
    {0x8D82, 0x9AD8}, //1519 #CJK UNIFIED IDEOGRAPH
    {0x8D83, 0x9D3B}, //1520 #CJK UNIFIED IDEOGRAPH
    {0x8D84, 0x525B}, //1521 #CJK UNIFIED IDEOGRAPH
    {0x8D85, 0x52AB}, //1522 #CJK UNIFIED IDEOGRAPH
    {0x8D86, 0x53F7}, //1523 #CJK UNIFIED IDEOGRAPH
    {0x8D87, 0x5408}, //1524 #CJK UNIFIED IDEOGRAPH
    {0x8D88, 0x58D5}, //1525 #CJK UNIFIED IDEOGRAPH
    {0x8D89, 0x62F7}, //1526 #CJK UNIFIED IDEOGRAPH
    {0x8D8A, 0x6FE0}, //1527 #CJK UNIFIED IDEOGRAPH
    {0x8D8B, 0x8C6A}, //1528 #CJK UNIFIED IDEOGRAPH
    {0x8D8C, 0x8F5F}, //1529 #CJK UNIFIED IDEOGRAPH
    {0x8D8D, 0x9EB9}, //1530 #CJK UNIFIED IDEOGRAPH
    {0x8D8E, 0x514B}, //1531 #CJK UNIFIED IDEOGRAPH
    {0x8D8F, 0x523B}, //1532 #CJK UNIFIED IDEOGRAPH
    {0x8D90, 0x544A}, //1533 #CJK UNIFIED IDEOGRAPH
    {0x8D91, 0x56FD}, //1534 #CJK UNIFIED IDEOGRAPH
    {0x8D92, 0x7A40}, //1535 #CJK UNIFIED IDEOGRAPH
    {0x8D93, 0x9177}, //1536 #CJK UNIFIED IDEOGRAPH
    {0x8D94, 0x9D60}, //1537 #CJK UNIFIED IDEOGRAPH
    {0x8D95, 0x9ED2}, //1538 #CJK UNIFIED IDEOGRAPH
    {0x8D96, 0x7344}, //1539 #CJK UNIFIED IDEOGRAPH
    {0x8D97, 0x6F09}, //1540 #CJK UNIFIED IDEOGRAPH
    {0x8D98, 0x8170}, //1541 #CJK UNIFIED IDEOGRAPH
    {0x8D99, 0x7511}, //1542 #CJK UNIFIED IDEOGRAPH
    {0x8D9A, 0x5FFD}, //1543 #CJK UNIFIED IDEOGRAPH
    {0x8D9B, 0x60DA}, //1544 #CJK UNIFIED IDEOGRAPH
    {0x8D9C, 0x9AA8}, //1545 #CJK UNIFIED IDEOGRAPH
    {0x8D9D, 0x72DB}, //1546 #CJK UNIFIED IDEOGRAPH
    {0x8D9E, 0x8FBC}, //1547 #CJK UNIFIED IDEOGRAPH
    {0x8D9F, 0x6B64}, //1548 #CJK UNIFIED IDEOGRAPH
    {0x8DA0, 0x9803}, //1549 #CJK UNIFIED IDEOGRAPH
    {0x8DA1, 0x4ECA}, //1550 #CJK UNIFIED IDEOGRAPH
    {0x8DA2, 0x56F0}, //1551 #CJK UNIFIED IDEOGRAPH
    {0x8DA3, 0x5764}, //1552 #CJK UNIFIED IDEOGRAPH
    {0x8DA4, 0x58BE}, //1553 #CJK UNIFIED IDEOGRAPH
    {0x8DA5, 0x5A5A}, //1554 #CJK UNIFIED IDEOGRAPH
    {0x8DA6, 0x6068}, //1555 #CJK UNIFIED IDEOGRAPH
    {0x8DA7, 0x61C7}, //1556 #CJK UNIFIED IDEOGRAPH
    {0x8DA8, 0x660F}, //1557 #CJK UNIFIED IDEOGRAPH
    {0x8DA9, 0x6606}, //1558 #CJK UNIFIED IDEOGRAPH
    {0x8DAA, 0x6839}, //1559 #CJK UNIFIED IDEOGRAPH
    {0x8DAB, 0x68B1}, //1560 #CJK UNIFIED IDEOGRAPH
    {0x8DAC, 0x6DF7}, //1561 #CJK UNIFIED IDEOGRAPH
    {0x8DAD, 0x75D5}, //1562 #CJK UNIFIED IDEOGRAPH
    {0x8DAE, 0x7D3A}, //1563 #CJK UNIFIED IDEOGRAPH
    {0x8DAF, 0x826E}, //1564 #CJK UNIFIED IDEOGRAPH
    {0x8DB0, 0x9B42}, //1565 #CJK UNIFIED IDEOGRAPH
    {0x8DB1, 0x4E9B}, //1566 #CJK UNIFIED IDEOGRAPH
    {0x8DB2, 0x4F50}, //1567 #CJK UNIFIED IDEOGRAPH
    {0x8DB3, 0x53C9}, //1568 #CJK UNIFIED IDEOGRAPH
    {0x8DB4, 0x5506}, //1569 #CJK UNIFIED IDEOGRAPH
    {0x8DB5, 0x5D6F}, //1570 #CJK UNIFIED IDEOGRAPH
    {0x8DB6, 0x5DE6}, //1571 #CJK UNIFIED IDEOGRAPH
    {0x8DB7, 0x5DEE}, //1572 #CJK UNIFIED IDEOGRAPH
    {0x8DB8, 0x67FB}, //1573 #CJK UNIFIED IDEOGRAPH
    {0x8DB9, 0x6C99}, //1574 #CJK UNIFIED IDEOGRAPH
    {0x8DBA, 0x7473}, //1575 #CJK UNIFIED IDEOGRAPH
    {0x8DBB, 0x7802}, //1576 #CJK UNIFIED IDEOGRAPH
    {0x8DBC, 0x8A50}, //1577 #CJK UNIFIED IDEOGRAPH
    {0x8DBD, 0x9396}, //1578 #CJK UNIFIED IDEOGRAPH
    {0x8DBE, 0x88DF}, //1579 #CJK UNIFIED IDEOGRAPH
    {0x8DBF, 0x5750}, //1580 #CJK UNIFIED IDEOGRAPH
    {0x8DC0, 0x5EA7}, //1581 #CJK UNIFIED IDEOGRAPH
    {0x8DC1, 0x632B}, //1582 #CJK UNIFIED IDEOGRAPH
    {0x8DC2, 0x50B5}, //1583 #CJK UNIFIED IDEOGRAPH
    {0x8DC3, 0x50AC}, //1584 #CJK UNIFIED IDEOGRAPH
    {0x8DC4, 0x518D}, //1585 #CJK UNIFIED IDEOGRAPH
    {0x8DC5, 0x6700}, //1586 #CJK UNIFIED IDEOGRAPH
    {0x8DC6, 0x54C9}, //1587 #CJK UNIFIED IDEOGRAPH
    {0x8DC7, 0x585E}, //1588 #CJK UNIFIED IDEOGRAPH
    {0x8DC8, 0x59BB}, //1589 #CJK UNIFIED IDEOGRAPH
    {0x8DC9, 0x5BB0}, //1590 #CJK UNIFIED IDEOGRAPH
    {0x8DCA, 0x5F69}, //1591 #CJK UNIFIED IDEOGRAPH
    {0x8DCB, 0x624D}, //1592 #CJK UNIFIED IDEOGRAPH
    {0x8DCC, 0x63A1}, //1593 #CJK UNIFIED IDEOGRAPH
    {0x8DCD, 0x683D}, //1594 #CJK UNIFIED IDEOGRAPH
    {0x8DCE, 0x6B73}, //1595 #CJK UNIFIED IDEOGRAPH
    {0x8DCF, 0x6E08}, //1596 #CJK UNIFIED IDEOGRAPH
    {0x8DD0, 0x707D}, //1597 #CJK UNIFIED IDEOGRAPH
    {0x8DD1, 0x91C7}, //1598 #CJK UNIFIED IDEOGRAPH
    {0x8DD2, 0x7280}, //1599 #CJK UNIFIED IDEOGRAPH
    {0x8DD3, 0x7815}, //1600 #CJK UNIFIED IDEOGRAPH
    {0x8DD4, 0x7826}, //1601 #CJK UNIFIED IDEOGRAPH
    {0x8DD5, 0x796D}, //1602 #CJK UNIFIED IDEOGRAPH
    {0x8DD6, 0x658E}, //1603 #CJK UNIFIED IDEOGRAPH
    {0x8DD7, 0x7D30}, //1604 #CJK UNIFIED IDEOGRAPH
    {0x8DD8, 0x83DC}, //1605 #CJK UNIFIED IDEOGRAPH
    {0x8DD9, 0x88C1}, //1606 #CJK UNIFIED IDEOGRAPH
    {0x8DDA, 0x8F09}, //1607 #CJK UNIFIED IDEOGRAPH
    {0x8DDB, 0x969B}, //1608 #CJK UNIFIED IDEOGRAPH
    {0x8DDC, 0x5264}, //1609 #CJK UNIFIED IDEOGRAPH
    {0x8DDD, 0x5728}, //1610 #CJK UNIFIED IDEOGRAPH
    {0x8DDE, 0x6750}, //1611 #CJK UNIFIED IDEOGRAPH
    {0x8DDF, 0x7F6A}, //1612 #CJK UNIFIED IDEOGRAPH
    {0x8DE0, 0x8CA1}, //1613 #CJK UNIFIED IDEOGRAPH
    {0x8DE1, 0x51B4}, //1614 #CJK UNIFIED IDEOGRAPH
    {0x8DE2, 0x5742}, //1615 #CJK UNIFIED IDEOGRAPH
    {0x8DE3, 0x962A}, //1616 #CJK UNIFIED IDEOGRAPH
    {0x8DE4, 0x583A}, //1617 #CJK UNIFIED IDEOGRAPH
    {0x8DE5, 0x698A}, //1618 #CJK UNIFIED IDEOGRAPH
    {0x8DE6, 0x80B4}, //1619 #CJK UNIFIED IDEOGRAPH
    {0x8DE7, 0x54B2}, //1620 #CJK UNIFIED IDEOGRAPH
    {0x8DE8, 0x5D0E}, //1621 #CJK UNIFIED IDEOGRAPH
    {0x8DE9, 0x57FC}, //1622 #CJK UNIFIED IDEOGRAPH
    {0x8DEA, 0x7895}, //1623 #CJK UNIFIED IDEOGRAPH
    {0x8DEB, 0x9DFA}, //1624 #CJK UNIFIED IDEOGRAPH
    {0x8DEC, 0x4F5C}, //1625 #CJK UNIFIED IDEOGRAPH
    {0x8DED, 0x524A}, //1626 #CJK UNIFIED IDEOGRAPH
    {0x8DEE, 0x548B}, //1627 #CJK UNIFIED IDEOGRAPH
    {0x8DEF, 0x643E}, //1628 #CJK UNIFIED IDEOGRAPH
    {0x8DF0, 0x6628}, //1629 #CJK UNIFIED IDEOGRAPH
    {0x8DF1, 0x6714}, //1630 #CJK UNIFIED IDEOGRAPH
    {0x8DF2, 0x67F5}, //1631 #CJK UNIFIED IDEOGRAPH
    {0x8DF3, 0x7A84}, //1632 #CJK UNIFIED IDEOGRAPH
    {0x8DF4, 0x7B56}, //1633 #CJK UNIFIED IDEOGRAPH
    {0x8DF5, 0x7D22}, //1634 #CJK UNIFIED IDEOGRAPH
    {0x8DF6, 0x932F}, //1635 #CJK UNIFIED IDEOGRAPH
    {0x8DF7, 0x685C}, //1636 #CJK UNIFIED IDEOGRAPH
    {0x8DF8, 0x9BAD}, //1637 #CJK UNIFIED IDEOGRAPH
    {0x8DF9, 0x7B39}, //1638 #CJK UNIFIED IDEOGRAPH
    {0x8DFA, 0x5319}, //1639 #CJK UNIFIED IDEOGRAPH
    {0x8DFB, 0x518A}, //1640 #CJK UNIFIED IDEOGRAPH
    {0x8DFC, 0x5237}, //1641 #CJK UNIFIED IDEOGRAPH
    {0x8E40, 0x5BDF}, //1642 #CJK UNIFIED IDEOGRAPH
    {0x8E41, 0x62F6}, //1643 #CJK UNIFIED IDEOGRAPH
    {0x8E42, 0x64AE}, //1644 #CJK UNIFIED IDEOGRAPH
    {0x8E43, 0x64E6}, //1645 #CJK UNIFIED IDEOGRAPH
    {0x8E44, 0x672D}, //1646 #CJK UNIFIED IDEOGRAPH
    {0x8E45, 0x6BBA}, //1647 #CJK UNIFIED IDEOGRAPH
    {0x8E46, 0x85A9}, //1648 #CJK UNIFIED IDEOGRAPH
    {0x8E47, 0x96D1}, //1649 #CJK UNIFIED IDEOGRAPH
    {0x8E48, 0x7690}, //1650 #CJK UNIFIED IDEOGRAPH
    {0x8E49, 0x9BD6}, //1651 #CJK UNIFIED IDEOGRAPH
    {0x8E4A, 0x634C}, //1652 #CJK UNIFIED IDEOGRAPH
    {0x8E4B, 0x9306}, //1653 #CJK UNIFIED IDEOGRAPH
    {0x8E4C, 0x9BAB}, //1654 #CJK UNIFIED IDEOGRAPH
    {0x8E4D, 0x76BF}, //1655 #CJK UNIFIED IDEOGRAPH
    {0x8E4E, 0x6652}, //1656 #CJK UNIFIED IDEOGRAPH
    {0x8E4F, 0x4E09}, //1657 #CJK UNIFIED IDEOGRAPH
    {0x8E50, 0x5098}, //1658 #CJK UNIFIED IDEOGRAPH
    {0x8E51, 0x53C2}, //1659 #CJK UNIFIED IDEOGRAPH
    {0x8E52, 0x5C71}, //1660 #CJK UNIFIED IDEOGRAPH
    {0x8E53, 0x60E8}, //1661 #CJK UNIFIED IDEOGRAPH
    {0x8E54, 0x6492}, //1662 #CJK UNIFIED IDEOGRAPH
    {0x8E55, 0x6563}, //1663 #CJK UNIFIED IDEOGRAPH
    {0x8E56, 0x685F}, //1664 #CJK UNIFIED IDEOGRAPH
    {0x8E57, 0x71E6}, //1665 #CJK UNIFIED IDEOGRAPH
    {0x8E58, 0x73CA}, //1666 #CJK UNIFIED IDEOGRAPH
    {0x8E59, 0x7523}, //1667 #CJK UNIFIED IDEOGRAPH
    {0x8E5A, 0x7B97}, //1668 #CJK UNIFIED IDEOGRAPH
    {0x8E5B, 0x7E82}, //1669 #CJK UNIFIED IDEOGRAPH
    {0x8E5C, 0x8695}, //1670 #CJK UNIFIED IDEOGRAPH
    {0x8E5D, 0x8B83}, //1671 #CJK UNIFIED IDEOGRAPH
    {0x8E5E, 0x8CDB}, //1672 #CJK UNIFIED IDEOGRAPH
    {0x8E5F, 0x9178}, //1673 #CJK UNIFIED IDEOGRAPH
    {0x8E60, 0x9910}, //1674 #CJK UNIFIED IDEOGRAPH
    {0x8E61, 0x65AC}, //1675 #CJK UNIFIED IDEOGRAPH
    {0x8E62, 0x66AB}, //1676 #CJK UNIFIED IDEOGRAPH
    {0x8E63, 0x6B8B}, //1677 #CJK UNIFIED IDEOGRAPH
    {0x8E64, 0x4ED5}, //1678 #CJK UNIFIED IDEOGRAPH
    {0x8E65, 0x4ED4}, //1679 #CJK UNIFIED IDEOGRAPH
    {0x8E66, 0x4F3A}, //1680 #CJK UNIFIED IDEOGRAPH
    {0x8E67, 0x4F7F}, //1681 #CJK UNIFIED IDEOGRAPH
    {0x8E68, 0x523A}, //1682 #CJK UNIFIED IDEOGRAPH
    {0x8E69, 0x53F8}, //1683 #CJK UNIFIED IDEOGRAPH
    {0x8E6A, 0x53F2}, //1684 #CJK UNIFIED IDEOGRAPH
    {0x8E6B, 0x55E3}, //1685 #CJK UNIFIED IDEOGRAPH
    {0x8E6C, 0x56DB}, //1686 #CJK UNIFIED IDEOGRAPH
    {0x8E6D, 0x58EB}, //1687 #CJK UNIFIED IDEOGRAPH
    {0x8E6E, 0x59CB}, //1688 #CJK UNIFIED IDEOGRAPH
    {0x8E6F, 0x59C9}, //1689 #CJK UNIFIED IDEOGRAPH
    {0x8E70, 0x59FF}, //1690 #CJK UNIFIED IDEOGRAPH
    {0x8E71, 0x5B50}, //1691 #CJK UNIFIED IDEOGRAPH
    {0x8E72, 0x5C4D}, //1692 #CJK UNIFIED IDEOGRAPH
    {0x8E73, 0x5E02}, //1693 #CJK UNIFIED IDEOGRAPH
    {0x8E74, 0x5E2B}, //1694 #CJK UNIFIED IDEOGRAPH
    {0x8E75, 0x5FD7}, //1695 #CJK UNIFIED IDEOGRAPH
    {0x8E76, 0x601D}, //1696 #CJK UNIFIED IDEOGRAPH
    {0x8E77, 0x6307}, //1697 #CJK UNIFIED IDEOGRAPH
    {0x8E78, 0x652F}, //1698 #CJK UNIFIED IDEOGRAPH
    {0x8E79, 0x5B5C}, //1699 #CJK UNIFIED IDEOGRAPH
    {0x8E7A, 0x65AF}, //1700 #CJK UNIFIED IDEOGRAPH
    {0x8E7B, 0x65BD}, //1701 #CJK UNIFIED IDEOGRAPH
    {0x8E7C, 0x65E8}, //1702 #CJK UNIFIED IDEOGRAPH
    {0x8E7D, 0x679D}, //1703 #CJK UNIFIED IDEOGRAPH
    {0x8E7E, 0x6B62}, //1704 #CJK UNIFIED IDEOGRAPH
    {0x8E80, 0x6B7B}, //1705 #CJK UNIFIED IDEOGRAPH
    {0x8E81, 0x6C0F}, //1706 #CJK UNIFIED IDEOGRAPH
    {0x8E82, 0x7345}, //1707 #CJK UNIFIED IDEOGRAPH
    {0x8E83, 0x7949}, //1708 #CJK UNIFIED IDEOGRAPH
    {0x8E84, 0x79C1}, //1709 #CJK UNIFIED IDEOGRAPH
    {0x8E85, 0x7CF8}, //1710 #CJK UNIFIED IDEOGRAPH
    {0x8E86, 0x7D19}, //1711 #CJK UNIFIED IDEOGRAPH
    {0x8E87, 0x7D2B}, //1712 #CJK UNIFIED IDEOGRAPH
    {0x8E88, 0x80A2}, //1713 #CJK UNIFIED IDEOGRAPH
    {0x8E89, 0x8102}, //1714 #CJK UNIFIED IDEOGRAPH
    {0x8E8A, 0x81F3}, //1715 #CJK UNIFIED IDEOGRAPH
    {0x8E8B, 0x8996}, //1716 #CJK UNIFIED IDEOGRAPH
    {0x8E8C, 0x8A5E}, //1717 #CJK UNIFIED IDEOGRAPH
    {0x8E8D, 0x8A69}, //1718 #CJK UNIFIED IDEOGRAPH
    {0x8E8E, 0x8A66}, //1719 #CJK UNIFIED IDEOGRAPH
    {0x8E8F, 0x8A8C}, //1720 #CJK UNIFIED IDEOGRAPH
    {0x8E90, 0x8AEE}, //1721 #CJK UNIFIED IDEOGRAPH
    {0x8E91, 0x8CC7}, //1722 #CJK UNIFIED IDEOGRAPH
    {0x8E92, 0x8CDC}, //1723 #CJK UNIFIED IDEOGRAPH
    {0x8E93, 0x96CC}, //1724 #CJK UNIFIED IDEOGRAPH
    {0x8E94, 0x98FC}, //1725 #CJK UNIFIED IDEOGRAPH
    {0x8E95, 0x6B6F}, //1726 #CJK UNIFIED IDEOGRAPH
    {0x8E96, 0x4E8B}, //1727 #CJK UNIFIED IDEOGRAPH
    {0x8E97, 0x4F3C}, //1728 #CJK UNIFIED IDEOGRAPH
    {0x8E98, 0x4F8D}, //1729 #CJK UNIFIED IDEOGRAPH
    {0x8E99, 0x5150}, //1730 #CJK UNIFIED IDEOGRAPH
    {0x8E9A, 0x5B57}, //1731 #CJK UNIFIED IDEOGRAPH
    {0x8E9B, 0x5BFA}, //1732 #CJK UNIFIED IDEOGRAPH
    {0x8E9C, 0x6148}, //1733 #CJK UNIFIED IDEOGRAPH
    {0x8E9D, 0x6301}, //1734 #CJK UNIFIED IDEOGRAPH
    {0x8E9E, 0x6642}, //1735 #CJK UNIFIED IDEOGRAPH
    {0x8E9F, 0x6B21}, //1736 #CJK UNIFIED IDEOGRAPH
    {0x8EA0, 0x6ECB}, //1737 #CJK UNIFIED IDEOGRAPH
    {0x8EA1, 0x6CBB}, //1738 #CJK UNIFIED IDEOGRAPH
    {0x8EA2, 0x723E}, //1739 #CJK UNIFIED IDEOGRAPH
    {0x8EA3, 0x74BD}, //1740 #CJK UNIFIED IDEOGRAPH
    {0x8EA4, 0x75D4}, //1741 #CJK UNIFIED IDEOGRAPH
    {0x8EA5, 0x78C1}, //1742 #CJK UNIFIED IDEOGRAPH
    {0x8EA6, 0x793A}, //1743 #CJK UNIFIED IDEOGRAPH
    {0x8EA7, 0x800C}, //1744 #CJK UNIFIED IDEOGRAPH
    {0x8EA8, 0x8033}, //1745 #CJK UNIFIED IDEOGRAPH
    {0x8EA9, 0x81EA}, //1746 #CJK UNIFIED IDEOGRAPH
    {0x8EAA, 0x8494}, //1747 #CJK UNIFIED IDEOGRAPH
    {0x8EAB, 0x8F9E}, //1748 #CJK UNIFIED IDEOGRAPH
    {0x8EAC, 0x6C50}, //1749 #CJK UNIFIED IDEOGRAPH
    {0x8EAD, 0x9E7F}, //1750 #CJK UNIFIED IDEOGRAPH
    {0x8EAE, 0x5F0F}, //1751 #CJK UNIFIED IDEOGRAPH
    {0x8EAF, 0x8B58}, //1752 #CJK UNIFIED IDEOGRAPH
    {0x8EB0, 0x9D2B}, //1753 #CJK UNIFIED IDEOGRAPH
    {0x8EB1, 0x7AFA}, //1754 #CJK UNIFIED IDEOGRAPH
    {0x8EB2, 0x8EF8}, //1755 #CJK UNIFIED IDEOGRAPH
    {0x8EB3, 0x5B8D}, //1756 #CJK UNIFIED IDEOGRAPH
    {0x8EB4, 0x96EB}, //1757 #CJK UNIFIED IDEOGRAPH
    {0x8EB5, 0x4E03}, //1758 #CJK UNIFIED IDEOGRAPH
    {0x8EB6, 0x53F1}, //1759 #CJK UNIFIED IDEOGRAPH
    {0x8EB7, 0x57F7}, //1760 #CJK UNIFIED IDEOGRAPH
    {0x8EB8, 0x5931}, //1761 #CJK UNIFIED IDEOGRAPH
    {0x8EB9, 0x5AC9}, //1762 #CJK UNIFIED IDEOGRAPH
    {0x8EBA, 0x5BA4}, //1763 #CJK UNIFIED IDEOGRAPH
    {0x8EBB, 0x6089}, //1764 #CJK UNIFIED IDEOGRAPH
    {0x8EBC, 0x6E7F}, //1765 #CJK UNIFIED IDEOGRAPH
    {0x8EBD, 0x6F06}, //1766 #CJK UNIFIED IDEOGRAPH
    {0x8EBE, 0x75BE}, //1767 #CJK UNIFIED IDEOGRAPH
    {0x8EBF, 0x8CEA}, //1768 #CJK UNIFIED IDEOGRAPH
    {0x8EC0, 0x5B9F}, //1769 #CJK UNIFIED IDEOGRAPH
    {0x8EC1, 0x8500}, //1770 #CJK UNIFIED IDEOGRAPH
    {0x8EC2, 0x7BE0}, //1771 #CJK UNIFIED IDEOGRAPH
    {0x8EC3, 0x5072}, //1772 #CJK UNIFIED IDEOGRAPH
    {0x8EC4, 0x67F4}, //1773 #CJK UNIFIED IDEOGRAPH
    {0x8EC5, 0x829D}, //1774 #CJK UNIFIED IDEOGRAPH
    {0x8EC6, 0x5C61}, //1775 #CJK UNIFIED IDEOGRAPH
    {0x8EC7, 0x854A}, //1776 #CJK UNIFIED IDEOGRAPH
    {0x8EC8, 0x7E1E}, //1777 #CJK UNIFIED IDEOGRAPH
    {0x8EC9, 0x820E}, //1778 #CJK UNIFIED IDEOGRAPH
    {0x8ECA, 0x5199}, //1779 #CJK UNIFIED IDEOGRAPH
    {0x8ECB, 0x5C04}, //1780 #CJK UNIFIED IDEOGRAPH
    {0x8ECC, 0x6368}, //1781 #CJK UNIFIED IDEOGRAPH
    {0x8ECD, 0x8D66}, //1782 #CJK UNIFIED IDEOGRAPH
    {0x8ECE, 0x659C}, //1783 #CJK UNIFIED IDEOGRAPH
    {0x8ECF, 0x716E}, //1784 #CJK UNIFIED IDEOGRAPH
    {0x8ED0, 0x793E}, //1785 #CJK UNIFIED IDEOGRAPH
    {0x8ED1, 0x7D17}, //1786 #CJK UNIFIED IDEOGRAPH
    {0x8ED2, 0x8005}, //1787 #CJK UNIFIED IDEOGRAPH
    {0x8ED3, 0x8B1D}, //1788 #CJK UNIFIED IDEOGRAPH
    {0x8ED4, 0x8ECA}, //1789 #CJK UNIFIED IDEOGRAPH
    {0x8ED5, 0x906E}, //1790 #CJK UNIFIED IDEOGRAPH
    {0x8ED6, 0x86C7}, //1791 #CJK UNIFIED IDEOGRAPH
    {0x8ED7, 0x90AA}, //1792 #CJK UNIFIED IDEOGRAPH
    {0x8ED8, 0x501F}, //1793 #CJK UNIFIED IDEOGRAPH
    {0x8ED9, 0x52FA}, //1794 #CJK UNIFIED IDEOGRAPH
    {0x8EDA, 0x5C3A}, //1795 #CJK UNIFIED IDEOGRAPH
    {0x8EDB, 0x6753}, //1796 #CJK UNIFIED IDEOGRAPH
    {0x8EDC, 0x707C}, //1797 #CJK UNIFIED IDEOGRAPH
    {0x8EDD, 0x7235}, //1798 #CJK UNIFIED IDEOGRAPH
    {0x8EDE, 0x914C}, //1799 #CJK UNIFIED IDEOGRAPH
    {0x8EDF, 0x91C8}, //1800 #CJK UNIFIED IDEOGRAPH
    {0x8EE0, 0x932B}, //1801 #CJK UNIFIED IDEOGRAPH
    {0x8EE1, 0x82E5}, //1802 #CJK UNIFIED IDEOGRAPH
    {0x8EE2, 0x5BC2}, //1803 #CJK UNIFIED IDEOGRAPH
    {0x8EE3, 0x5F31}, //1804 #CJK UNIFIED IDEOGRAPH
    {0x8EE4, 0x60F9}, //1805 #CJK UNIFIED IDEOGRAPH
    {0x8EE5, 0x4E3B}, //1806 #CJK UNIFIED IDEOGRAPH
    {0x8EE6, 0x53D6}, //1807 #CJK UNIFIED IDEOGRAPH
    {0x8EE7, 0x5B88}, //1808 #CJK UNIFIED IDEOGRAPH
    {0x8EE8, 0x624B}, //1809 #CJK UNIFIED IDEOGRAPH
    {0x8EE9, 0x6731}, //1810 #CJK UNIFIED IDEOGRAPH
    {0x8EEA, 0x6B8A}, //1811 #CJK UNIFIED IDEOGRAPH
    {0x8EEB, 0x72E9}, //1812 #CJK UNIFIED IDEOGRAPH
    {0x8EEC, 0x73E0}, //1813 #CJK UNIFIED IDEOGRAPH
    {0x8EED, 0x7A2E}, //1814 #CJK UNIFIED IDEOGRAPH
    {0x8EEE, 0x816B}, //1815 #CJK UNIFIED IDEOGRAPH
    {0x8EEF, 0x8DA3}, //1816 #CJK UNIFIED IDEOGRAPH
    {0x8EF0, 0x9152}, //1817 #CJK UNIFIED IDEOGRAPH
    {0x8EF1, 0x9996}, //1818 #CJK UNIFIED IDEOGRAPH
    {0x8EF2, 0x5112}, //1819 #CJK UNIFIED IDEOGRAPH
    {0x8EF3, 0x53D7}, //1820 #CJK UNIFIED IDEOGRAPH
    {0x8EF4, 0x546A}, //1821 #CJK UNIFIED IDEOGRAPH
    {0x8EF5, 0x5BFF}, //1822 #CJK UNIFIED IDEOGRAPH
    {0x8EF6, 0x6388}, //1823 #CJK UNIFIED IDEOGRAPH
    {0x8EF7, 0x6A39}, //1824 #CJK UNIFIED IDEOGRAPH
    {0x8EF8, 0x7DAC}, //1825 #CJK UNIFIED IDEOGRAPH
    {0x8EF9, 0x9700}, //1826 #CJK UNIFIED IDEOGRAPH
    {0x8EFA, 0x56DA}, //1827 #CJK UNIFIED IDEOGRAPH
    {0x8EFB, 0x53CE}, //1828 #CJK UNIFIED IDEOGRAPH
    {0x8EFC, 0x5468}, //1829 #CJK UNIFIED IDEOGRAPH
    {0x8F40, 0x5B97}, //1830 #CJK UNIFIED IDEOGRAPH
    {0x8F41, 0x5C31}, //1831 #CJK UNIFIED IDEOGRAPH
    {0x8F42, 0x5DDE}, //1832 #CJK UNIFIED IDEOGRAPH
    {0x8F43, 0x4FEE}, //1833 #CJK UNIFIED IDEOGRAPH
    {0x8F44, 0x6101}, //1834 #CJK UNIFIED IDEOGRAPH
    {0x8F45, 0x62FE}, //1835 #CJK UNIFIED IDEOGRAPH
    {0x8F46, 0x6D32}, //1836 #CJK UNIFIED IDEOGRAPH
    {0x8F47, 0x79C0}, //1837 #CJK UNIFIED IDEOGRAPH
    {0x8F48, 0x79CB}, //1838 #CJK UNIFIED IDEOGRAPH
    {0x8F49, 0x7D42}, //1839 #CJK UNIFIED IDEOGRAPH
    {0x8F4A, 0x7E4D}, //1840 #CJK UNIFIED IDEOGRAPH
    {0x8F4B, 0x7FD2}, //1841 #CJK UNIFIED IDEOGRAPH
    {0x8F4C, 0x81ED}, //1842 #CJK UNIFIED IDEOGRAPH
    {0x8F4D, 0x821F}, //1843 #CJK UNIFIED IDEOGRAPH
    {0x8F4E, 0x8490}, //1844 #CJK UNIFIED IDEOGRAPH
    {0x8F4F, 0x8846}, //1845 #CJK UNIFIED IDEOGRAPH
    {0x8F50, 0x8972}, //1846 #CJK UNIFIED IDEOGRAPH
    {0x8F51, 0x8B90}, //1847 #CJK UNIFIED IDEOGRAPH
    {0x8F52, 0x8E74}, //1848 #CJK UNIFIED IDEOGRAPH
    {0x8F53, 0x8F2F}, //1849 #CJK UNIFIED IDEOGRAPH
    {0x8F54, 0x9031}, //1850 #CJK UNIFIED IDEOGRAPH
    {0x8F55, 0x914B}, //1851 #CJK UNIFIED IDEOGRAPH
    {0x8F56, 0x916C}, //1852 #CJK UNIFIED IDEOGRAPH
    {0x8F57, 0x96C6}, //1853 #CJK UNIFIED IDEOGRAPH
    {0x8F58, 0x919C}, //1854 #CJK UNIFIED IDEOGRAPH
    {0x8F59, 0x4EC0}, //1855 #CJK UNIFIED IDEOGRAPH
    {0x8F5A, 0x4F4F}, //1856 #CJK UNIFIED IDEOGRAPH
    {0x8F5B, 0x5145}, //1857 #CJK UNIFIED IDEOGRAPH
    {0x8F5C, 0x5341}, //1858 #CJK UNIFIED IDEOGRAPH
    {0x8F5D, 0x5F93}, //1859 #CJK UNIFIED IDEOGRAPH
    {0x8F5E, 0x620E}, //1860 #CJK UNIFIED IDEOGRAPH
    {0x8F5F, 0x67D4}, //1861 #CJK UNIFIED IDEOGRAPH
    {0x8F60, 0x6C41}, //1862 #CJK UNIFIED IDEOGRAPH
    {0x8F61, 0x6E0B}, //1863 #CJK UNIFIED IDEOGRAPH
    {0x8F62, 0x7363}, //1864 #CJK UNIFIED IDEOGRAPH
    {0x8F63, 0x7E26}, //1865 #CJK UNIFIED IDEOGRAPH
    {0x8F64, 0x91CD}, //1866 #CJK UNIFIED IDEOGRAPH
    {0x8F65, 0x9283}, //1867 #CJK UNIFIED IDEOGRAPH
    {0x8F66, 0x53D4}, //1868 #CJK UNIFIED IDEOGRAPH
    {0x8F67, 0x5919}, //1869 #CJK UNIFIED IDEOGRAPH
    {0x8F68, 0x5BBF}, //1870 #CJK UNIFIED IDEOGRAPH
    {0x8F69, 0x6DD1}, //1871 #CJK UNIFIED IDEOGRAPH
    {0x8F6A, 0x795D}, //1872 #CJK UNIFIED IDEOGRAPH
    {0x8F6B, 0x7E2E}, //1873 #CJK UNIFIED IDEOGRAPH
    {0x8F6C, 0x7C9B}, //1874 #CJK UNIFIED IDEOGRAPH
    {0x8F6D, 0x587E}, //1875 #CJK UNIFIED IDEOGRAPH
    {0x8F6E, 0x719F}, //1876 #CJK UNIFIED IDEOGRAPH
    {0x8F6F, 0x51FA}, //1877 #CJK UNIFIED IDEOGRAPH
    {0x8F70, 0x8853}, //1878 #CJK UNIFIED IDEOGRAPH
    {0x8F71, 0x8FF0}, //1879 #CJK UNIFIED IDEOGRAPH
    {0x8F72, 0x4FCA}, //1880 #CJK UNIFIED IDEOGRAPH
    {0x8F73, 0x5CFB}, //1881 #CJK UNIFIED IDEOGRAPH
    {0x8F74, 0x6625}, //1882 #CJK UNIFIED IDEOGRAPH
    {0x8F75, 0x77AC}, //1883 #CJK UNIFIED IDEOGRAPH
    {0x8F76, 0x7AE3}, //1884 #CJK UNIFIED IDEOGRAPH
    {0x8F77, 0x821C}, //1885 #CJK UNIFIED IDEOGRAPH
    {0x8F78, 0x99FF}, //1886 #CJK UNIFIED IDEOGRAPH
    {0x8F79, 0x51C6}, //1887 #CJK UNIFIED IDEOGRAPH
    {0x8F7A, 0x5FAA}, //1888 #CJK UNIFIED IDEOGRAPH
    {0x8F7B, 0x65EC}, //1889 #CJK UNIFIED IDEOGRAPH
    {0x8F7C, 0x696F}, //1890 #CJK UNIFIED IDEOGRAPH
    {0x8F7D, 0x6B89}, //1891 #CJK UNIFIED IDEOGRAPH
    {0x8F7E, 0x6DF3}, //1892 #CJK UNIFIED IDEOGRAPH
    {0x8F80, 0x6E96}, //1893 #CJK UNIFIED IDEOGRAPH
    {0x8F81, 0x6F64}, //1894 #CJK UNIFIED IDEOGRAPH
    {0x8F82, 0x76FE}, //1895 #CJK UNIFIED IDEOGRAPH
    {0x8F83, 0x7D14}, //1896 #CJK UNIFIED IDEOGRAPH
    {0x8F84, 0x5DE1}, //1897 #CJK UNIFIED IDEOGRAPH
    {0x8F85, 0x9075}, //1898 #CJK UNIFIED IDEOGRAPH
    {0x8F86, 0x9187}, //1899 #CJK UNIFIED IDEOGRAPH
    {0x8F87, 0x9806}, //1900 #CJK UNIFIED IDEOGRAPH
    {0x8F88, 0x51E6}, //1901 #CJK UNIFIED IDEOGRAPH
    {0x8F89, 0x521D}, //1902 #CJK UNIFIED IDEOGRAPH
    {0x8F8A, 0x6240}, //1903 #CJK UNIFIED IDEOGRAPH
    {0x8F8B, 0x6691}, //1904 #CJK UNIFIED IDEOGRAPH
    {0x8F8C, 0x66D9}, //1905 #CJK UNIFIED IDEOGRAPH
    {0x8F8D, 0x6E1A}, //1906 #CJK UNIFIED IDEOGRAPH
    {0x8F8E, 0x5EB6}, //1907 #CJK UNIFIED IDEOGRAPH
    {0x8F8F, 0x7DD2}, //1908 #CJK UNIFIED IDEOGRAPH
    {0x8F90, 0x7F72}, //1909 #CJK UNIFIED IDEOGRAPH
    {0x8F91, 0x66F8}, //1910 #CJK UNIFIED IDEOGRAPH
    {0x8F92, 0x85AF}, //1911 #CJK UNIFIED IDEOGRAPH
    {0x8F93, 0x85F7}, //1912 #CJK UNIFIED IDEOGRAPH
    {0x8F94, 0x8AF8}, //1913 #CJK UNIFIED IDEOGRAPH
    {0x8F95, 0x52A9}, //1914 #CJK UNIFIED IDEOGRAPH
    {0x8F96, 0x53D9}, //1915 #CJK UNIFIED IDEOGRAPH
    {0x8F97, 0x5973}, //1916 #CJK UNIFIED IDEOGRAPH
    {0x8F98, 0x5E8F}, //1917 #CJK UNIFIED IDEOGRAPH
    {0x8F99, 0x5F90}, //1918 #CJK UNIFIED IDEOGRAPH
    {0x8F9A, 0x6055}, //1919 #CJK UNIFIED IDEOGRAPH
    {0x8F9B, 0x92E4}, //1920 #CJK UNIFIED IDEOGRAPH
    {0x8F9C, 0x9664}, //1921 #CJK UNIFIED IDEOGRAPH
    {0x8F9D, 0x50B7}, //1922 #CJK UNIFIED IDEOGRAPH
    {0x8F9E, 0x511F}, //1923 #CJK UNIFIED IDEOGRAPH
    {0x8F9F, 0x52DD}, //1924 #CJK UNIFIED IDEOGRAPH
    {0x8FA0, 0x5320}, //1925 #CJK UNIFIED IDEOGRAPH
    {0x8FA1, 0x5347}, //1926 #CJK UNIFIED IDEOGRAPH
    {0x8FA2, 0x53EC}, //1927 #CJK UNIFIED IDEOGRAPH
    {0x8FA3, 0x54E8}, //1928 #CJK UNIFIED IDEOGRAPH
    {0x8FA4, 0x5546}, //1929 #CJK UNIFIED IDEOGRAPH
    {0x8FA5, 0x5531}, //1930 #CJK UNIFIED IDEOGRAPH
    {0x8FA6, 0x5617}, //1931 #CJK UNIFIED IDEOGRAPH
    {0x8FA7, 0x5968}, //1932 #CJK UNIFIED IDEOGRAPH
    {0x8FA8, 0x59BE}, //1933 #CJK UNIFIED IDEOGRAPH
    {0x8FA9, 0x5A3C}, //1934 #CJK UNIFIED IDEOGRAPH
    {0x8FAA, 0x5BB5}, //1935 #CJK UNIFIED IDEOGRAPH
    {0x8FAB, 0x5C06}, //1936 #CJK UNIFIED IDEOGRAPH
    {0x8FAC, 0x5C0F}, //1937 #CJK UNIFIED IDEOGRAPH
    {0x8FAD, 0x5C11}, //1938 #CJK UNIFIED IDEOGRAPH
    {0x8FAE, 0x5C1A}, //1939 #CJK UNIFIED IDEOGRAPH
    {0x8FAF, 0x5E84}, //1940 #CJK UNIFIED IDEOGRAPH
    {0x8FB0, 0x5E8A}, //1941 #CJK UNIFIED IDEOGRAPH
    {0x8FB1, 0x5EE0}, //1942 #CJK UNIFIED IDEOGRAPH
    {0x8FB2, 0x5F70}, //1943 #CJK UNIFIED IDEOGRAPH
    {0x8FB3, 0x627F}, //1944 #CJK UNIFIED IDEOGRAPH
    {0x8FB4, 0x6284}, //1945 #CJK UNIFIED IDEOGRAPH
    {0x8FB5, 0x62DB}, //1946 #CJK UNIFIED IDEOGRAPH
    {0x8FB6, 0x638C}, //1947 #CJK UNIFIED IDEOGRAPH
    {0x8FB7, 0x6377}, //1948 #CJK UNIFIED IDEOGRAPH
    {0x8FB8, 0x6607}, //1949 #CJK UNIFIED IDEOGRAPH
    {0x8FB9, 0x660C}, //1950 #CJK UNIFIED IDEOGRAPH
    {0x8FBA, 0x662D}, //1951 #CJK UNIFIED IDEOGRAPH
    {0x8FBB, 0x6676}, //1952 #CJK UNIFIED IDEOGRAPH
    {0x8FBC, 0x677E}, //1953 #CJK UNIFIED IDEOGRAPH
    {0x8FBD, 0x68A2}, //1954 #CJK UNIFIED IDEOGRAPH
    {0x8FBE, 0x6A1F}, //1955 #CJK UNIFIED IDEOGRAPH
    {0x8FBF, 0x6A35}, //1956 #CJK UNIFIED IDEOGRAPH
    {0x8FC0, 0x6CBC}, //1957 #CJK UNIFIED IDEOGRAPH
    {0x8FC1, 0x6D88}, //1958 #CJK UNIFIED IDEOGRAPH
    {0x8FC2, 0x6E09}, //1959 #CJK UNIFIED IDEOGRAPH
    {0x8FC3, 0x6E58}, //1960 #CJK UNIFIED IDEOGRAPH
    {0x8FC4, 0x713C}, //1961 #CJK UNIFIED IDEOGRAPH
    {0x8FC5, 0x7126}, //1962 #CJK UNIFIED IDEOGRAPH
    {0x8FC6, 0x7167}, //1963 #CJK UNIFIED IDEOGRAPH
    {0x8FC7, 0x75C7}, //1964 #CJK UNIFIED IDEOGRAPH
    {0x8FC8, 0x7701}, //1965 #CJK UNIFIED IDEOGRAPH
    {0x8FC9, 0x785D}, //1966 #CJK UNIFIED IDEOGRAPH
    {0x8FCA, 0x7901}, //1967 #CJK UNIFIED IDEOGRAPH
    {0x8FCB, 0x7965}, //1968 #CJK UNIFIED IDEOGRAPH
    {0x8FCC, 0x79F0}, //1969 #CJK UNIFIED IDEOGRAPH
    {0x8FCD, 0x7AE0}, //1970 #CJK UNIFIED IDEOGRAPH
    {0x8FCE, 0x7B11}, //1971 #CJK UNIFIED IDEOGRAPH
    {0x8FCF, 0x7CA7}, //1972 #CJK UNIFIED IDEOGRAPH
    {0x8FD0, 0x7D39}, //1973 #CJK UNIFIED IDEOGRAPH
    {0x8FD1, 0x8096}, //1974 #CJK UNIFIED IDEOGRAPH
    {0x8FD2, 0x83D6}, //1975 #CJK UNIFIED IDEOGRAPH
    {0x8FD3, 0x848B}, //1976 #CJK UNIFIED IDEOGRAPH
    {0x8FD4, 0x8549}, //1977 #CJK UNIFIED IDEOGRAPH
    {0x8FD5, 0x885D}, //1978 #CJK UNIFIED IDEOGRAPH
    {0x8FD6, 0x88F3}, //1979 #CJK UNIFIED IDEOGRAPH
    {0x8FD7, 0x8A1F}, //1980 #CJK UNIFIED IDEOGRAPH
    {0x8FD8, 0x8A3C}, //1981 #CJK UNIFIED IDEOGRAPH
    {0x8FD9, 0x8A54}, //1982 #CJK UNIFIED IDEOGRAPH
    {0x8FDA, 0x8A73}, //1983 #CJK UNIFIED IDEOGRAPH
    {0x8FDB, 0x8C61}, //1984 #CJK UNIFIED IDEOGRAPH
    {0x8FDC, 0x8CDE}, //1985 #CJK UNIFIED IDEOGRAPH
    {0x8FDD, 0x91A4}, //1986 #CJK UNIFIED IDEOGRAPH
    {0x8FDE, 0x9266}, //1987 #CJK UNIFIED IDEOGRAPH
    {0x8FDF, 0x937E}, //1988 #CJK UNIFIED IDEOGRAPH
    {0x8FE0, 0x9418}, //1989 #CJK UNIFIED IDEOGRAPH
    {0x8FE1, 0x969C}, //1990 #CJK UNIFIED IDEOGRAPH
    {0x8FE2, 0x9798}, //1991 #CJK UNIFIED IDEOGRAPH
    {0x8FE3, 0x4E0A}, //1992 #CJK UNIFIED IDEOGRAPH
    {0x8FE4, 0x4E08}, //1993 #CJK UNIFIED IDEOGRAPH
    {0x8FE5, 0x4E1E}, //1994 #CJK UNIFIED IDEOGRAPH
    {0x8FE6, 0x4E57}, //1995 #CJK UNIFIED IDEOGRAPH
    {0x8FE7, 0x5197}, //1996 #CJK UNIFIED IDEOGRAPH
    {0x8FE8, 0x5270}, //1997 #CJK UNIFIED IDEOGRAPH
    {0x8FE9, 0x57CE}, //1998 #CJK UNIFIED IDEOGRAPH
    {0x8FEA, 0x5834}, //1999 #CJK UNIFIED IDEOGRAPH
    {0x8FEB, 0x58CC}, //2000 #CJK UNIFIED IDEOGRAPH
    {0x8FEC, 0x5B22}, //2001 #CJK UNIFIED IDEOGRAPH
    {0x8FED, 0x5E38}, //2002 #CJK UNIFIED IDEOGRAPH
    {0x8FEE, 0x60C5}, //2003 #CJK UNIFIED IDEOGRAPH
    {0x8FEF, 0x64FE}, //2004 #CJK UNIFIED IDEOGRAPH
    {0x8FF0, 0x6761}, //2005 #CJK UNIFIED IDEOGRAPH
    {0x8FF1, 0x6756}, //2006 #CJK UNIFIED IDEOGRAPH
    {0x8FF2, 0x6D44}, //2007 #CJK UNIFIED IDEOGRAPH
    {0x8FF3, 0x72B6}, //2008 #CJK UNIFIED IDEOGRAPH
    {0x8FF4, 0x7573}, //2009 #CJK UNIFIED IDEOGRAPH
    {0x8FF5, 0x7A63}, //2010 #CJK UNIFIED IDEOGRAPH
    {0x8FF6, 0x84B8}, //2011 #CJK UNIFIED IDEOGRAPH
    {0x8FF7, 0x8B72}, //2012 #CJK UNIFIED IDEOGRAPH
    {0x8FF8, 0x91B8}, //2013 #CJK UNIFIED IDEOGRAPH
    {0x8FF9, 0x9320}, //2014 #CJK UNIFIED IDEOGRAPH
    {0x8FFA, 0x5631}, //2015 #CJK UNIFIED IDEOGRAPH
    {0x8FFB, 0x57F4}, //2016 #CJK UNIFIED IDEOGRAPH
    {0x8FFC, 0x98FE}, //2017 #CJK UNIFIED IDEOGRAPH
    {0x9040, 0x62ED}, //2018 #CJK UNIFIED IDEOGRAPH
    {0x9041, 0x690D}, //2019 #CJK UNIFIED IDEOGRAPH
    {0x9042, 0x6B96}, //2020 #CJK UNIFIED IDEOGRAPH
    {0x9043, 0x71ED}, //2021 #CJK UNIFIED IDEOGRAPH
    {0x9044, 0x7E54}, //2022 #CJK UNIFIED IDEOGRAPH
    {0x9045, 0x8077}, //2023 #CJK UNIFIED IDEOGRAPH
    {0x9046, 0x8272}, //2024 #CJK UNIFIED IDEOGRAPH
    {0x9047, 0x89E6}, //2025 #CJK UNIFIED IDEOGRAPH
    {0x9048, 0x98DF}, //2026 #CJK UNIFIED IDEOGRAPH
    {0x9049, 0x8755}, //2027 #CJK UNIFIED IDEOGRAPH
    {0x904A, 0x8FB1}, //2028 #CJK UNIFIED IDEOGRAPH
    {0x904B, 0x5C3B}, //2029 #CJK UNIFIED IDEOGRAPH
    {0x904C, 0x4F38}, //2030 #CJK UNIFIED IDEOGRAPH
    {0x904D, 0x4FE1}, //2031 #CJK UNIFIED IDEOGRAPH
    {0x904E, 0x4FB5}, //2032 #CJK UNIFIED IDEOGRAPH
    {0x904F, 0x5507}, //2033 #CJK UNIFIED IDEOGRAPH
    {0x9050, 0x5A20}, //2034 #CJK UNIFIED IDEOGRAPH
    {0x9051, 0x5BDD}, //2035 #CJK UNIFIED IDEOGRAPH
    {0x9052, 0x5BE9}, //2036 #CJK UNIFIED IDEOGRAPH
    {0x9053, 0x5FC3}, //2037 #CJK UNIFIED IDEOGRAPH
    {0x9054, 0x614E}, //2038 #CJK UNIFIED IDEOGRAPH
    {0x9055, 0x632F}, //2039 #CJK UNIFIED IDEOGRAPH
    {0x9056, 0x65B0}, //2040 #CJK UNIFIED IDEOGRAPH
    {0x9057, 0x664B}, //2041 #CJK UNIFIED IDEOGRAPH
    {0x9058, 0x68EE}, //2042 #CJK UNIFIED IDEOGRAPH
    {0x9059, 0x699B}, //2043 #CJK UNIFIED IDEOGRAPH
    {0x905A, 0x6D78}, //2044 #CJK UNIFIED IDEOGRAPH
    {0x905B, 0x6DF1}, //2045 #CJK UNIFIED IDEOGRAPH
    {0x905C, 0x7533}, //2046 #CJK UNIFIED IDEOGRAPH
    {0x905D, 0x75B9}, //2047 #CJK UNIFIED IDEOGRAPH
    {0x905E, 0x771F}, //2048 #CJK UNIFIED IDEOGRAPH
    {0x905F, 0x795E}, //2049 #CJK UNIFIED IDEOGRAPH
    {0x9060, 0x79E6}, //2050 #CJK UNIFIED IDEOGRAPH
    {0x9061, 0x7D33}, //2051 #CJK UNIFIED IDEOGRAPH
    {0x9062, 0x81E3}, //2052 #CJK UNIFIED IDEOGRAPH
    {0x9063, 0x82AF}, //2053 #CJK UNIFIED IDEOGRAPH
    {0x9064, 0x85AA}, //2054 #CJK UNIFIED IDEOGRAPH
    {0x9065, 0x89AA}, //2055 #CJK UNIFIED IDEOGRAPH
    {0x9066, 0x8A3A}, //2056 #CJK UNIFIED IDEOGRAPH
    {0x9067, 0x8EAB}, //2057 #CJK UNIFIED IDEOGRAPH
    {0x9068, 0x8F9B}, //2058 #CJK UNIFIED IDEOGRAPH
    {0x9069, 0x9032}, //2059 #CJK UNIFIED IDEOGRAPH
    {0x906A, 0x91DD}, //2060 #CJK UNIFIED IDEOGRAPH
    {0x906B, 0x9707}, //2061 #CJK UNIFIED IDEOGRAPH
    {0x906C, 0x4EBA}, //2062 #CJK UNIFIED IDEOGRAPH
    {0x906D, 0x4EC1}, //2063 #CJK UNIFIED IDEOGRAPH
    {0x906E, 0x5203}, //2064 #CJK UNIFIED IDEOGRAPH
    {0x906F, 0x5875}, //2065 #CJK UNIFIED IDEOGRAPH
    {0x9070, 0x58EC}, //2066 #CJK UNIFIED IDEOGRAPH
    {0x9071, 0x5C0B}, //2067 #CJK UNIFIED IDEOGRAPH
    {0x9072, 0x751A}, //2068 #CJK UNIFIED IDEOGRAPH
    {0x9073, 0x5C3D}, //2069 #CJK UNIFIED IDEOGRAPH
    {0x9074, 0x814E}, //2070 #CJK UNIFIED IDEOGRAPH
    {0x9075, 0x8A0A}, //2071 #CJK UNIFIED IDEOGRAPH
    {0x9076, 0x8FC5}, //2072 #CJK UNIFIED IDEOGRAPH
    {0x9077, 0x9663}, //2073 #CJK UNIFIED IDEOGRAPH
    {0x9078, 0x976D}, //2074 #CJK UNIFIED IDEOGRAPH
    {0x9079, 0x7B25}, //2075 #CJK UNIFIED IDEOGRAPH
    {0x907A, 0x8ACF}, //2076 #CJK UNIFIED IDEOGRAPH
    {0x907B, 0x9808}, //2077 #CJK UNIFIED IDEOGRAPH
    {0x907C, 0x9162}, //2078 #CJK UNIFIED IDEOGRAPH
    {0x907D, 0x56F3}, //2079 #CJK UNIFIED IDEOGRAPH
    {0x907E, 0x53A8}, //2080 #CJK UNIFIED IDEOGRAPH
    {0x9080, 0x9017}, //2081 #CJK UNIFIED IDEOGRAPH
    {0x9081, 0x5439}, //2082 #CJK UNIFIED IDEOGRAPH
    {0x9082, 0x5782}, //2083 #CJK UNIFIED IDEOGRAPH
    {0x9083, 0x5E25}, //2084 #CJK UNIFIED IDEOGRAPH
    {0x9084, 0x63A8}, //2085 #CJK UNIFIED IDEOGRAPH
    {0x9085, 0x6C34}, //2086 #CJK UNIFIED IDEOGRAPH
    {0x9086, 0x708A}, //2087 #CJK UNIFIED IDEOGRAPH
    {0x9087, 0x7761}, //2088 #CJK UNIFIED IDEOGRAPH
    {0x9088, 0x7C8B}, //2089 #CJK UNIFIED IDEOGRAPH
    {0x9089, 0x7FE0}, //2090 #CJK UNIFIED IDEOGRAPH
    {0x908A, 0x8870}, //2091 #CJK UNIFIED IDEOGRAPH
    {0x908B, 0x9042}, //2092 #CJK UNIFIED IDEOGRAPH
    {0x908C, 0x9154}, //2093 #CJK UNIFIED IDEOGRAPH
    {0x908D, 0x9310}, //2094 #CJK UNIFIED IDEOGRAPH
    {0x908E, 0x9318}, //2095 #CJK UNIFIED IDEOGRAPH
    {0x908F, 0x968F}, //2096 #CJK UNIFIED IDEOGRAPH
    {0x9090, 0x745E}, //2097 #CJK UNIFIED IDEOGRAPH
    {0x9091, 0x9AC4}, //2098 #CJK UNIFIED IDEOGRAPH
    {0x9092, 0x5D07}, //2099 #CJK UNIFIED IDEOGRAPH
    {0x9093, 0x5D69}, //2100 #CJK UNIFIED IDEOGRAPH
    {0x9094, 0x6570}, //2101 #CJK UNIFIED IDEOGRAPH
    {0x9095, 0x67A2}, //2102 #CJK UNIFIED IDEOGRAPH
    {0x9096, 0x8DA8}, //2103 #CJK UNIFIED IDEOGRAPH
    {0x9097, 0x96DB}, //2104 #CJK UNIFIED IDEOGRAPH
    {0x9098, 0x636E}, //2105 #CJK UNIFIED IDEOGRAPH
    {0x9099, 0x6749}, //2106 #CJK UNIFIED IDEOGRAPH
    {0x909A, 0x6919}, //2107 #CJK UNIFIED IDEOGRAPH
    {0x909B, 0x83C5}, //2108 #CJK UNIFIED IDEOGRAPH
    {0x909C, 0x9817}, //2109 #CJK UNIFIED IDEOGRAPH
    {0x909D, 0x96C0}, //2110 #CJK UNIFIED IDEOGRAPH
    {0x909E, 0x88FE}, //2111 #CJK UNIFIED IDEOGRAPH
    {0x909F, 0x6F84}, //2112 #CJK UNIFIED IDEOGRAPH
    {0x90A0, 0x647A}, //2113 #CJK UNIFIED IDEOGRAPH
    {0x90A1, 0x5BF8}, //2114 #CJK UNIFIED IDEOGRAPH
    {0x90A2, 0x4E16}, //2115 #CJK UNIFIED IDEOGRAPH
    {0x90A3, 0x702C}, //2116 #CJK UNIFIED IDEOGRAPH
    {0x90A4, 0x755D}, //2117 #CJK UNIFIED IDEOGRAPH
    {0x90A5, 0x662F}, //2118 #CJK UNIFIED IDEOGRAPH
    {0x90A6, 0x51C4}, //2119 #CJK UNIFIED IDEOGRAPH
    {0x90A7, 0x5236}, //2120 #CJK UNIFIED IDEOGRAPH
    {0x90A8, 0x52E2}, //2121 #CJK UNIFIED IDEOGRAPH
    {0x90A9, 0x59D3}, //2122 #CJK UNIFIED IDEOGRAPH
    {0x90AA, 0x5F81}, //2123 #CJK UNIFIED IDEOGRAPH
    {0x90AB, 0x6027}, //2124 #CJK UNIFIED IDEOGRAPH
    {0x90AC, 0x6210}, //2125 #CJK UNIFIED IDEOGRAPH
    {0x90AD, 0x653F}, //2126 #CJK UNIFIED IDEOGRAPH
    {0x90AE, 0x6574}, //2127 #CJK UNIFIED IDEOGRAPH
    {0x90AF, 0x661F}, //2128 #CJK UNIFIED IDEOGRAPH
    {0x90B0, 0x6674}, //2129 #CJK UNIFIED IDEOGRAPH
    {0x90B1, 0x68F2}, //2130 #CJK UNIFIED IDEOGRAPH
    {0x90B2, 0x6816}, //2131 #CJK UNIFIED IDEOGRAPH
    {0x90B3, 0x6B63}, //2132 #CJK UNIFIED IDEOGRAPH
    {0x90B4, 0x6E05}, //2133 #CJK UNIFIED IDEOGRAPH
    {0x90B5, 0x7272}, //2134 #CJK UNIFIED IDEOGRAPH
    {0x90B6, 0x751F}, //2135 #CJK UNIFIED IDEOGRAPH
    {0x90B7, 0x76DB}, //2136 #CJK UNIFIED IDEOGRAPH
    {0x90B8, 0x7CBE}, //2137 #CJK UNIFIED IDEOGRAPH
    {0x90B9, 0x8056}, //2138 #CJK UNIFIED IDEOGRAPH
    {0x90BA, 0x58F0}, //2139 #CJK UNIFIED IDEOGRAPH
    {0x90BB, 0x88FD}, //2140 #CJK UNIFIED IDEOGRAPH
    {0x90BC, 0x897F}, //2141 #CJK UNIFIED IDEOGRAPH
    {0x90BD, 0x8AA0}, //2142 #CJK UNIFIED IDEOGRAPH
    {0x90BE, 0x8A93}, //2143 #CJK UNIFIED IDEOGRAPH
    {0x90BF, 0x8ACB}, //2144 #CJK UNIFIED IDEOGRAPH
    {0x90C0, 0x901D}, //2145 #CJK UNIFIED IDEOGRAPH
    {0x90C1, 0x9192}, //2146 #CJK UNIFIED IDEOGRAPH
    {0x90C2, 0x9752}, //2147 #CJK UNIFIED IDEOGRAPH
    {0x90C3, 0x9759}, //2148 #CJK UNIFIED IDEOGRAPH
    {0x90C4, 0x6589}, //2149 #CJK UNIFIED IDEOGRAPH
    {0x90C5, 0x7A0E}, //2150 #CJK UNIFIED IDEOGRAPH
    {0x90C6, 0x8106}, //2151 #CJK UNIFIED IDEOGRAPH
    {0x90C7, 0x96BB}, //2152 #CJK UNIFIED IDEOGRAPH
    {0x90C8, 0x5E2D}, //2153 #CJK UNIFIED IDEOGRAPH
    {0x90C9, 0x60DC}, //2154 #CJK UNIFIED IDEOGRAPH
    {0x90CA, 0x621A}, //2155 #CJK UNIFIED IDEOGRAPH
    {0x90CB, 0x65A5}, //2156 #CJK UNIFIED IDEOGRAPH
    {0x90CC, 0x6614}, //2157 #CJK UNIFIED IDEOGRAPH
    {0x90CD, 0x6790}, //2158 #CJK UNIFIED IDEOGRAPH
    {0x90CE, 0x77F3}, //2159 #CJK UNIFIED IDEOGRAPH
    {0x90CF, 0x7A4D}, //2160 #CJK UNIFIED IDEOGRAPH
    {0x90D0, 0x7C4D}, //2161 #CJK UNIFIED IDEOGRAPH
    {0x90D1, 0x7E3E}, //2162 #CJK UNIFIED IDEOGRAPH
    {0x90D2, 0x810A}, //2163 #CJK UNIFIED IDEOGRAPH
    {0x90D3, 0x8CAC}, //2164 #CJK UNIFIED IDEOGRAPH
    {0x90D4, 0x8D64}, //2165 #CJK UNIFIED IDEOGRAPH
    {0x90D5, 0x8DE1}, //2166 #CJK UNIFIED IDEOGRAPH
    {0x90D6, 0x8E5F}, //2167 #CJK UNIFIED IDEOGRAPH
    {0x90D7, 0x78A9}, //2168 #CJK UNIFIED IDEOGRAPH
    {0x90D8, 0x5207}, //2169 #CJK UNIFIED IDEOGRAPH
    {0x90D9, 0x62D9}, //2170 #CJK UNIFIED IDEOGRAPH
    {0x90DA, 0x63A5}, //2171 #CJK UNIFIED IDEOGRAPH
    {0x90DB, 0x6442}, //2172 #CJK UNIFIED IDEOGRAPH
    {0x90DC, 0x6298}, //2173 #CJK UNIFIED IDEOGRAPH
    {0x90DD, 0x8A2D}, //2174 #CJK UNIFIED IDEOGRAPH
    {0x90DE, 0x7A83}, //2175 #CJK UNIFIED IDEOGRAPH
    {0x90DF, 0x7BC0}, //2176 #CJK UNIFIED IDEOGRAPH
    {0x90E0, 0x8AAC}, //2177 #CJK UNIFIED IDEOGRAPH
    {0x90E1, 0x96EA}, //2178 #CJK UNIFIED IDEOGRAPH
    {0x90E2, 0x7D76}, //2179 #CJK UNIFIED IDEOGRAPH
    {0x90E3, 0x820C}, //2180 #CJK UNIFIED IDEOGRAPH
    {0x90E4, 0x8749}, //2181 #CJK UNIFIED IDEOGRAPH
    {0x90E5, 0x4ED9}, //2182 #CJK UNIFIED IDEOGRAPH
    {0x90E6, 0x5148}, //2183 #CJK UNIFIED IDEOGRAPH
    {0x90E7, 0x5343}, //2184 #CJK UNIFIED IDEOGRAPH
    {0x90E8, 0x5360}, //2185 #CJK UNIFIED IDEOGRAPH
    {0x90E9, 0x5BA3}, //2186 #CJK UNIFIED IDEOGRAPH
    {0x90EA, 0x5C02}, //2187 #CJK UNIFIED IDEOGRAPH
    {0x90EB, 0x5C16}, //2188 #CJK UNIFIED IDEOGRAPH
    {0x90EC, 0x5DDD}, //2189 #CJK UNIFIED IDEOGRAPH
    {0x90ED, 0x6226}, //2190 #CJK UNIFIED IDEOGRAPH
    {0x90EE, 0x6247}, //2191 #CJK UNIFIED IDEOGRAPH
    {0x90EF, 0x64B0}, //2192 #CJK UNIFIED IDEOGRAPH
    {0x90F0, 0x6813}, //2193 #CJK UNIFIED IDEOGRAPH
    {0x90F1, 0x6834}, //2194 #CJK UNIFIED IDEOGRAPH
    {0x90F2, 0x6CC9}, //2195 #CJK UNIFIED IDEOGRAPH
    {0x90F3, 0x6D45}, //2196 #CJK UNIFIED IDEOGRAPH
    {0x90F4, 0x6D17}, //2197 #CJK UNIFIED IDEOGRAPH
    {0x90F5, 0x67D3}, //2198 #CJK UNIFIED IDEOGRAPH
    {0x90F6, 0x6F5C}, //2199 #CJK UNIFIED IDEOGRAPH
    {0x90F7, 0x714E}, //2200 #CJK UNIFIED IDEOGRAPH
    {0x90F8, 0x717D}, //2201 #CJK UNIFIED IDEOGRAPH
    {0x90F9, 0x65CB}, //2202 #CJK UNIFIED IDEOGRAPH
    {0x90FA, 0x7A7F}, //2203 #CJK UNIFIED IDEOGRAPH
    {0x90FB, 0x7BAD}, //2204 #CJK UNIFIED IDEOGRAPH
    {0x90FC, 0x7DDA}, //2205 #CJK UNIFIED IDEOGRAPH
    {0x9140, 0x7E4A}, //2206 #CJK UNIFIED IDEOGRAPH
    {0x9141, 0x7FA8}, //2207 #CJK UNIFIED IDEOGRAPH
    {0x9142, 0x817A}, //2208 #CJK UNIFIED IDEOGRAPH
    {0x9143, 0x821B}, //2209 #CJK UNIFIED IDEOGRAPH
    {0x9144, 0x8239}, //2210 #CJK UNIFIED IDEOGRAPH
    {0x9145, 0x85A6}, //2211 #CJK UNIFIED IDEOGRAPH
    {0x9146, 0x8A6E}, //2212 #CJK UNIFIED IDEOGRAPH
    {0x9147, 0x8CCE}, //2213 #CJK UNIFIED IDEOGRAPH
    {0x9148, 0x8DF5}, //2214 #CJK UNIFIED IDEOGRAPH
    {0x9149, 0x9078}, //2215 #CJK UNIFIED IDEOGRAPH
    {0x914A, 0x9077}, //2216 #CJK UNIFIED IDEOGRAPH
    {0x914B, 0x92AD}, //2217 #CJK UNIFIED IDEOGRAPH
    {0x914C, 0x9291}, //2218 #CJK UNIFIED IDEOGRAPH
    {0x914D, 0x9583}, //2219 #CJK UNIFIED IDEOGRAPH
    {0x914E, 0x9BAE}, //2220 #CJK UNIFIED IDEOGRAPH
    {0x914F, 0x524D}, //2221 #CJK UNIFIED IDEOGRAPH
    {0x9150, 0x5584}, //2222 #CJK UNIFIED IDEOGRAPH
    {0x9151, 0x6F38}, //2223 #CJK UNIFIED IDEOGRAPH
    {0x9152, 0x7136}, //2224 #CJK UNIFIED IDEOGRAPH
    {0x9153, 0x5168}, //2225 #CJK UNIFIED IDEOGRAPH
    {0x9154, 0x7985}, //2226 #CJK UNIFIED IDEOGRAPH
    {0x9155, 0x7E55}, //2227 #CJK UNIFIED IDEOGRAPH
    {0x9156, 0x81B3}, //2228 #CJK UNIFIED IDEOGRAPH
    {0x9157, 0x7CCE}, //2229 #CJK UNIFIED IDEOGRAPH
    {0x9158, 0x564C}, //2230 #CJK UNIFIED IDEOGRAPH
    {0x9159, 0x5851}, //2231 #CJK UNIFIED IDEOGRAPH
    {0x915A, 0x5CA8}, //2232 #CJK UNIFIED IDEOGRAPH
    {0x915B, 0x63AA}, //2233 #CJK UNIFIED IDEOGRAPH
    {0x915C, 0x66FE}, //2234 #CJK UNIFIED IDEOGRAPH
    {0x915D, 0x66FD}, //2235 #CJK UNIFIED IDEOGRAPH
    {0x915E, 0x695A}, //2236 #CJK UNIFIED IDEOGRAPH
    {0x915F, 0x72D9}, //2237 #CJK UNIFIED IDEOGRAPH
    {0x9160, 0x758F}, //2238 #CJK UNIFIED IDEOGRAPH
    {0x9161, 0x758E}, //2239 #CJK UNIFIED IDEOGRAPH
    {0x9162, 0x790E}, //2240 #CJK UNIFIED IDEOGRAPH
    {0x9163, 0x7956}, //2241 #CJK UNIFIED IDEOGRAPH
    {0x9164, 0x79DF}, //2242 #CJK UNIFIED IDEOGRAPH
    {0x9165, 0x7C97}, //2243 #CJK UNIFIED IDEOGRAPH
    {0x9166, 0x7D20}, //2244 #CJK UNIFIED IDEOGRAPH
    {0x9167, 0x7D44}, //2245 #CJK UNIFIED IDEOGRAPH
    {0x9168, 0x8607}, //2246 #CJK UNIFIED IDEOGRAPH
    {0x9169, 0x8A34}, //2247 #CJK UNIFIED IDEOGRAPH
    {0x916A, 0x963B}, //2248 #CJK UNIFIED IDEOGRAPH
    {0x916B, 0x9061}, //2249 #CJK UNIFIED IDEOGRAPH
    {0x916C, 0x9F20}, //2250 #CJK UNIFIED IDEOGRAPH
    {0x916D, 0x50E7}, //2251 #CJK UNIFIED IDEOGRAPH
    {0x916E, 0x5275}, //2252 #CJK UNIFIED IDEOGRAPH
    {0x916F, 0x53CC}, //2253 #CJK UNIFIED IDEOGRAPH
    {0x9170, 0x53E2}, //2254 #CJK UNIFIED IDEOGRAPH
    {0x9171, 0x5009}, //2255 #CJK UNIFIED IDEOGRAPH
    {0x9172, 0x55AA}, //2256 #CJK UNIFIED IDEOGRAPH
    {0x9173, 0x58EE}, //2257 #CJK UNIFIED IDEOGRAPH
    {0x9174, 0x594F}, //2258 #CJK UNIFIED IDEOGRAPH
    {0x9175, 0x723D}, //2259 #CJK UNIFIED IDEOGRAPH
    {0x9176, 0x5B8B}, //2260 #CJK UNIFIED IDEOGRAPH
    {0x9177, 0x5C64}, //2261 #CJK UNIFIED IDEOGRAPH
    {0x9178, 0x531D}, //2262 #CJK UNIFIED IDEOGRAPH
    {0x9179, 0x60E3}, //2263 #CJK UNIFIED IDEOGRAPH
    {0x917A, 0x60F3}, //2264 #CJK UNIFIED IDEOGRAPH
    {0x917B, 0x635C}, //2265 #CJK UNIFIED IDEOGRAPH
    {0x917C, 0x6383}, //2266 #CJK UNIFIED IDEOGRAPH
    {0x917D, 0x633F}, //2267 #CJK UNIFIED IDEOGRAPH
    {0x917E, 0x63BB}, //2268 #CJK UNIFIED IDEOGRAPH
    {0x9180, 0x64CD}, //2269 #CJK UNIFIED IDEOGRAPH
    {0x9181, 0x65E9}, //2270 #CJK UNIFIED IDEOGRAPH
    {0x9182, 0x66F9}, //2271 #CJK UNIFIED IDEOGRAPH
    {0x9183, 0x5DE3}, //2272 #CJK UNIFIED IDEOGRAPH
    {0x9184, 0x69CD}, //2273 #CJK UNIFIED IDEOGRAPH
    {0x9185, 0x69FD}, //2274 #CJK UNIFIED IDEOGRAPH
    {0x9186, 0x6F15}, //2275 #CJK UNIFIED IDEOGRAPH
    {0x9187, 0x71E5}, //2276 #CJK UNIFIED IDEOGRAPH
    {0x9188, 0x4E89}, //2277 #CJK UNIFIED IDEOGRAPH
    {0x9189, 0x75E9}, //2278 #CJK UNIFIED IDEOGRAPH
    {0x918A, 0x76F8}, //2279 #CJK UNIFIED IDEOGRAPH
    {0x918B, 0x7A93}, //2280 #CJK UNIFIED IDEOGRAPH
    {0x918C, 0x7CDF}, //2281 #CJK UNIFIED IDEOGRAPH
    {0x918D, 0x7DCF}, //2282 #CJK UNIFIED IDEOGRAPH
    {0x918E, 0x7D9C}, //2283 #CJK UNIFIED IDEOGRAPH
    {0x918F, 0x8061}, //2284 #CJK UNIFIED IDEOGRAPH
    {0x9190, 0x8349}, //2285 #CJK UNIFIED IDEOGRAPH
    {0x9191, 0x8358}, //2286 #CJK UNIFIED IDEOGRAPH
    {0x9192, 0x846C}, //2287 #CJK UNIFIED IDEOGRAPH
    {0x9193, 0x84BC}, //2288 #CJK UNIFIED IDEOGRAPH
    {0x9194, 0x85FB}, //2289 #CJK UNIFIED IDEOGRAPH
    {0x9195, 0x88C5}, //2290 #CJK UNIFIED IDEOGRAPH
    {0x9196, 0x8D70}, //2291 #CJK UNIFIED IDEOGRAPH
    {0x9197, 0x9001}, //2292 #CJK UNIFIED IDEOGRAPH
    {0x9198, 0x906D}, //2293 #CJK UNIFIED IDEOGRAPH
    {0x9199, 0x9397}, //2294 #CJK UNIFIED IDEOGRAPH
    {0x919A, 0x971C}, //2295 #CJK UNIFIED IDEOGRAPH
    {0x919B, 0x9A12}, //2296 #CJK UNIFIED IDEOGRAPH
    {0x919C, 0x50CF}, //2297 #CJK UNIFIED IDEOGRAPH
    {0x919D, 0x5897}, //2298 #CJK UNIFIED IDEOGRAPH
    {0x919E, 0x618E}, //2299 #CJK UNIFIED IDEOGRAPH
    {0x919F, 0x81D3}, //2300 #CJK UNIFIED IDEOGRAPH
    {0x91A0, 0x8535}, //2301 #CJK UNIFIED IDEOGRAPH
    {0x91A1, 0x8D08}, //2302 #CJK UNIFIED IDEOGRAPH
    {0x91A2, 0x9020}, //2303 #CJK UNIFIED IDEOGRAPH
    {0x91A3, 0x4FC3}, //2304 #CJK UNIFIED IDEOGRAPH
    {0x91A4, 0x5074}, //2305 #CJK UNIFIED IDEOGRAPH
    {0x91A5, 0x5247}, //2306 #CJK UNIFIED IDEOGRAPH
    {0x91A6, 0x5373}, //2307 #CJK UNIFIED IDEOGRAPH
    {0x91A7, 0x606F}, //2308 #CJK UNIFIED IDEOGRAPH
    {0x91A8, 0x6349}, //2309 #CJK UNIFIED IDEOGRAPH
    {0x91A9, 0x675F}, //2310 #CJK UNIFIED IDEOGRAPH
    {0x91AA, 0x6E2C}, //2311 #CJK UNIFIED IDEOGRAPH
    {0x91AB, 0x8DB3}, //2312 #CJK UNIFIED IDEOGRAPH
    {0x91AC, 0x901F}, //2313 #CJK UNIFIED IDEOGRAPH
    {0x91AD, 0x4FD7}, //2314 #CJK UNIFIED IDEOGRAPH
    {0x91AE, 0x5C5E}, //2315 #CJK UNIFIED IDEOGRAPH
    {0x91AF, 0x8CCA}, //2316 #CJK UNIFIED IDEOGRAPH
    {0x91B0, 0x65CF}, //2317 #CJK UNIFIED IDEOGRAPH
    {0x91B1, 0x7D9A}, //2318 #CJK UNIFIED IDEOGRAPH
    {0x91B2, 0x5352}, //2319 #CJK UNIFIED IDEOGRAPH
    {0x91B3, 0x8896}, //2320 #CJK UNIFIED IDEOGRAPH
    {0x91B4, 0x5176}, //2321 #CJK UNIFIED IDEOGRAPH
    {0x91B5, 0x63C3}, //2322 #CJK UNIFIED IDEOGRAPH
    {0x91B6, 0x5B58}, //2323 #CJK UNIFIED IDEOGRAPH
    {0x91B7, 0x5B6B}, //2324 #CJK UNIFIED IDEOGRAPH
    {0x91B8, 0x5C0A}, //2325 #CJK UNIFIED IDEOGRAPH
    {0x91B9, 0x640D}, //2326 #CJK UNIFIED IDEOGRAPH
    {0x91BA, 0x6751}, //2327 #CJK UNIFIED IDEOGRAPH
    {0x91BB, 0x905C}, //2328 #CJK UNIFIED IDEOGRAPH
    {0x91BC, 0x4ED6}, //2329 #CJK UNIFIED IDEOGRAPH
    {0x91BD, 0x591A}, //2330 #CJK UNIFIED IDEOGRAPH
    {0x91BE, 0x592A}, //2331 #CJK UNIFIED IDEOGRAPH
    {0x91BF, 0x6C70}, //2332 #CJK UNIFIED IDEOGRAPH
    {0x91C0, 0x8A51}, //2333 #CJK UNIFIED IDEOGRAPH
    {0x91C1, 0x553E}, //2334 #CJK UNIFIED IDEOGRAPH
    {0x91C2, 0x5815}, //2335 #CJK UNIFIED IDEOGRAPH
    {0x91C3, 0x59A5}, //2336 #CJK UNIFIED IDEOGRAPH
    {0x91C4, 0x60F0}, //2337 #CJK UNIFIED IDEOGRAPH
    {0x91C5, 0x6253}, //2338 #CJK UNIFIED IDEOGRAPH
    {0x91C6, 0x67C1}, //2339 #CJK UNIFIED IDEOGRAPH
    {0x91C7, 0x8235}, //2340 #CJK UNIFIED IDEOGRAPH
    {0x91C8, 0x6955}, //2341 #CJK UNIFIED IDEOGRAPH
    {0x91C9, 0x9640}, //2342 #CJK UNIFIED IDEOGRAPH
    {0x91CA, 0x99C4}, //2343 #CJK UNIFIED IDEOGRAPH
    {0x91CB, 0x9A28}, //2344 #CJK UNIFIED IDEOGRAPH
    {0x91CC, 0x4F53}, //2345 #CJK UNIFIED IDEOGRAPH
    {0x91CD, 0x5806}, //2346 #CJK UNIFIED IDEOGRAPH
    {0x91CE, 0x5BFE}, //2347 #CJK UNIFIED IDEOGRAPH
    {0x91CF, 0x8010}, //2348 #CJK UNIFIED IDEOGRAPH
    {0x91D0, 0x5CB1}, //2349 #CJK UNIFIED IDEOGRAPH
    {0x91D1, 0x5E2F}, //2350 #CJK UNIFIED IDEOGRAPH
    {0x91D2, 0x5F85}, //2351 #CJK UNIFIED IDEOGRAPH
    {0x91D3, 0x6020}, //2352 #CJK UNIFIED IDEOGRAPH
    {0x91D4, 0x614B}, //2353 #CJK UNIFIED IDEOGRAPH
    {0x91D5, 0x6234}, //2354 #CJK UNIFIED IDEOGRAPH
    {0x91D6, 0x66FF}, //2355 #CJK UNIFIED IDEOGRAPH
    {0x91D7, 0x6CF0}, //2356 #CJK UNIFIED IDEOGRAPH
    {0x91D8, 0x6EDE}, //2357 #CJK UNIFIED IDEOGRAPH
    {0x91D9, 0x80CE}, //2358 #CJK UNIFIED IDEOGRAPH
    {0x91DA, 0x817F}, //2359 #CJK UNIFIED IDEOGRAPH
    {0x91DB, 0x82D4}, //2360 #CJK UNIFIED IDEOGRAPH
    {0x91DC, 0x888B}, //2361 #CJK UNIFIED IDEOGRAPH
    {0x91DD, 0x8CB8}, //2362 #CJK UNIFIED IDEOGRAPH
    {0x91DE, 0x9000}, //2363 #CJK UNIFIED IDEOGRAPH
    {0x91DF, 0x902E}, //2364 #CJK UNIFIED IDEOGRAPH
    {0x91E0, 0x968A}, //2365 #CJK UNIFIED IDEOGRAPH
    {0x91E1, 0x9EDB}, //2366 #CJK UNIFIED IDEOGRAPH
    {0x91E2, 0x9BDB}, //2367 #CJK UNIFIED IDEOGRAPH
    {0x91E3, 0x4EE3}, //2368 #CJK UNIFIED IDEOGRAPH
    {0x91E4, 0x53F0}, //2369 #CJK UNIFIED IDEOGRAPH
    {0x91E5, 0x5927}, //2370 #CJK UNIFIED IDEOGRAPH
    {0x91E6, 0x7B2C}, //2371 #CJK UNIFIED IDEOGRAPH
    {0x91E7, 0x918D}, //2372 #CJK UNIFIED IDEOGRAPH
    {0x91E8, 0x984C}, //2373 #CJK UNIFIED IDEOGRAPH
    {0x91E9, 0x9DF9}, //2374 #CJK UNIFIED IDEOGRAPH
    {0x91EA, 0x6EDD}, //2375 #CJK UNIFIED IDEOGRAPH
    {0x91EB, 0x7027}, //2376 #CJK UNIFIED IDEOGRAPH
    {0x91EC, 0x5353}, //2377 #CJK UNIFIED IDEOGRAPH
    {0x91ED, 0x5544}, //2378 #CJK UNIFIED IDEOGRAPH
    {0x91EE, 0x5B85}, //2379 #CJK UNIFIED IDEOGRAPH
    {0x91EF, 0x6258}, //2380 #CJK UNIFIED IDEOGRAPH
    {0x91F0, 0x629E}, //2381 #CJK UNIFIED IDEOGRAPH
    {0x91F1, 0x62D3}, //2382 #CJK UNIFIED IDEOGRAPH
    {0x91F2, 0x6CA2}, //2383 #CJK UNIFIED IDEOGRAPH
    {0x91F3, 0x6FEF}, //2384 #CJK UNIFIED IDEOGRAPH
    {0x91F4, 0x7422}, //2385 #CJK UNIFIED IDEOGRAPH
    {0x91F5, 0x8A17}, //2386 #CJK UNIFIED IDEOGRAPH
    {0x91F6, 0x9438}, //2387 #CJK UNIFIED IDEOGRAPH
    {0x91F7, 0x6FC1}, //2388 #CJK UNIFIED IDEOGRAPH
    {0x91F8, 0x8AFE}, //2389 #CJK UNIFIED IDEOGRAPH
    {0x91F9, 0x8338}, //2390 #CJK UNIFIED IDEOGRAPH
    {0x91FA, 0x51E7}, //2391 #CJK UNIFIED IDEOGRAPH
    {0x91FB, 0x86F8}, //2392 #CJK UNIFIED IDEOGRAPH
    {0x91FC, 0x53EA}, //2393 #CJK UNIFIED IDEOGRAPH
    {0x9240, 0x53E9}, //2394 #CJK UNIFIED IDEOGRAPH
    {0x9241, 0x4F46}, //2395 #CJK UNIFIED IDEOGRAPH
    {0x9242, 0x9054}, //2396 #CJK UNIFIED IDEOGRAPH
    {0x9243, 0x8FB0}, //2397 #CJK UNIFIED IDEOGRAPH
    {0x9244, 0x596A}, //2398 #CJK UNIFIED IDEOGRAPH
    {0x9245, 0x8131}, //2399 #CJK UNIFIED IDEOGRAPH
    {0x9246, 0x5DFD}, //2400 #CJK UNIFIED IDEOGRAPH
    {0x9247, 0x7AEA}, //2401 #CJK UNIFIED IDEOGRAPH
    {0x9248, 0x8FBF}, //2402 #CJK UNIFIED IDEOGRAPH
    {0x9249, 0x68DA}, //2403 #CJK UNIFIED IDEOGRAPH
    {0x924A, 0x8C37}, //2404 #CJK UNIFIED IDEOGRAPH
    {0x924B, 0x72F8}, //2405 #CJK UNIFIED IDEOGRAPH
    {0x924C, 0x9C48}, //2406 #CJK UNIFIED IDEOGRAPH
    {0x924D, 0x6A3D}, //2407 #CJK UNIFIED IDEOGRAPH
    {0x924E, 0x8AB0}, //2408 #CJK UNIFIED IDEOGRAPH
    {0x924F, 0x4E39}, //2409 #CJK UNIFIED IDEOGRAPH
    {0x9250, 0x5358}, //2410 #CJK UNIFIED IDEOGRAPH
    {0x9251, 0x5606}, //2411 #CJK UNIFIED IDEOGRAPH
    {0x9252, 0x5766}, //2412 #CJK UNIFIED IDEOGRAPH
    {0x9253, 0x62C5}, //2413 #CJK UNIFIED IDEOGRAPH
    {0x9254, 0x63A2}, //2414 #CJK UNIFIED IDEOGRAPH
    {0x9255, 0x65E6}, //2415 #CJK UNIFIED IDEOGRAPH
    {0x9256, 0x6B4E}, //2416 #CJK UNIFIED IDEOGRAPH
    {0x9257, 0x6DE1}, //2417 #CJK UNIFIED IDEOGRAPH
    {0x9258, 0x6E5B}, //2418 #CJK UNIFIED IDEOGRAPH
    {0x9259, 0x70AD}, //2419 #CJK UNIFIED IDEOGRAPH
    {0x925A, 0x77ED}, //2420 #CJK UNIFIED IDEOGRAPH
    {0x925B, 0x7AEF}, //2421 #CJK UNIFIED IDEOGRAPH
    {0x925C, 0x7BAA}, //2422 #CJK UNIFIED IDEOGRAPH
    {0x925D, 0x7DBB}, //2423 #CJK UNIFIED IDEOGRAPH
    {0x925E, 0x803D}, //2424 #CJK UNIFIED IDEOGRAPH
    {0x925F, 0x80C6}, //2425 #CJK UNIFIED IDEOGRAPH
    {0x9260, 0x86CB}, //2426 #CJK UNIFIED IDEOGRAPH
    {0x9261, 0x8A95}, //2427 #CJK UNIFIED IDEOGRAPH
    {0x9262, 0x935B}, //2428 #CJK UNIFIED IDEOGRAPH
    {0x9263, 0x56E3}, //2429 #CJK UNIFIED IDEOGRAPH
    {0x9264, 0x58C7}, //2430 #CJK UNIFIED IDEOGRAPH
    {0x9265, 0x5F3E}, //2431 #CJK UNIFIED IDEOGRAPH
    {0x9266, 0x65AD}, //2432 #CJK UNIFIED IDEOGRAPH
    {0x9267, 0x6696}, //2433 #CJK UNIFIED IDEOGRAPH
    {0x9268, 0x6A80}, //2434 #CJK UNIFIED IDEOGRAPH
    {0x9269, 0x6BB5}, //2435 #CJK UNIFIED IDEOGRAPH
    {0x926A, 0x7537}, //2436 #CJK UNIFIED IDEOGRAPH
    {0x926B, 0x8AC7}, //2437 #CJK UNIFIED IDEOGRAPH
    {0x926C, 0x5024}, //2438 #CJK UNIFIED IDEOGRAPH
    {0x926D, 0x77E5}, //2439 #CJK UNIFIED IDEOGRAPH
    {0x926E, 0x5730}, //2440 #CJK UNIFIED IDEOGRAPH
    {0x926F, 0x5F1B}, //2441 #CJK UNIFIED IDEOGRAPH
    {0x9270, 0x6065}, //2442 #CJK UNIFIED IDEOGRAPH
    {0x9271, 0x667A}, //2443 #CJK UNIFIED IDEOGRAPH
    {0x9272, 0x6C60}, //2444 #CJK UNIFIED IDEOGRAPH
    {0x9273, 0x75F4}, //2445 #CJK UNIFIED IDEOGRAPH
    {0x9274, 0x7A1A}, //2446 #CJK UNIFIED IDEOGRAPH
    {0x9275, 0x7F6E}, //2447 #CJK UNIFIED IDEOGRAPH
    {0x9276, 0x81F4}, //2448 #CJK UNIFIED IDEOGRAPH
    {0x9277, 0x8718}, //2449 #CJK UNIFIED IDEOGRAPH
    {0x9278, 0x9045}, //2450 #CJK UNIFIED IDEOGRAPH
    {0x9279, 0x99B3}, //2451 #CJK UNIFIED IDEOGRAPH
    {0x927A, 0x7BC9}, //2452 #CJK UNIFIED IDEOGRAPH
    {0x927B, 0x755C}, //2453 #CJK UNIFIED IDEOGRAPH
    {0x927C, 0x7AF9}, //2454 #CJK UNIFIED IDEOGRAPH
    {0x927D, 0x7B51}, //2455 #CJK UNIFIED IDEOGRAPH
    {0x927E, 0x84C4}, //2456 #CJK UNIFIED IDEOGRAPH
    {0x9280, 0x9010}, //2457 #CJK UNIFIED IDEOGRAPH
    {0x9281, 0x79E9}, //2458 #CJK UNIFIED IDEOGRAPH
    {0x9282, 0x7A92}, //2459 #CJK UNIFIED IDEOGRAPH
    {0x9283, 0x8336}, //2460 #CJK UNIFIED IDEOGRAPH
    {0x9284, 0x5AE1}, //2461 #CJK UNIFIED IDEOGRAPH
    {0x9285, 0x7740}, //2462 #CJK UNIFIED IDEOGRAPH
    {0x9286, 0x4E2D}, //2463 #CJK UNIFIED IDEOGRAPH
    {0x9287, 0x4EF2}, //2464 #CJK UNIFIED IDEOGRAPH
    {0x9288, 0x5B99}, //2465 #CJK UNIFIED IDEOGRAPH
    {0x9289, 0x5FE0}, //2466 #CJK UNIFIED IDEOGRAPH
    {0x928A, 0x62BD}, //2467 #CJK UNIFIED IDEOGRAPH
    {0x928B, 0x663C}, //2468 #CJK UNIFIED IDEOGRAPH
    {0x928C, 0x67F1}, //2469 #CJK UNIFIED IDEOGRAPH
    {0x928D, 0x6CE8}, //2470 #CJK UNIFIED IDEOGRAPH
    {0x928E, 0x866B}, //2471 #CJK UNIFIED IDEOGRAPH
    {0x928F, 0x8877}, //2472 #CJK UNIFIED IDEOGRAPH
    {0x9290, 0x8A3B}, //2473 #CJK UNIFIED IDEOGRAPH
    {0x9291, 0x914E}, //2474 #CJK UNIFIED IDEOGRAPH
    {0x9292, 0x92F3}, //2475 #CJK UNIFIED IDEOGRAPH
    {0x9293, 0x99D0}, //2476 #CJK UNIFIED IDEOGRAPH
    {0x9294, 0x6A17}, //2477 #CJK UNIFIED IDEOGRAPH
    {0x9295, 0x7026}, //2478 #CJK UNIFIED IDEOGRAPH
    {0x9296, 0x732A}, //2479 #CJK UNIFIED IDEOGRAPH
    {0x9297, 0x82E7}, //2480 #CJK UNIFIED IDEOGRAPH
    {0x9298, 0x8457}, //2481 #CJK UNIFIED IDEOGRAPH
    {0x9299, 0x8CAF}, //2482 #CJK UNIFIED IDEOGRAPH
    {0x929A, 0x4E01}, //2483 #CJK UNIFIED IDEOGRAPH
    {0x929B, 0x5146}, //2484 #CJK UNIFIED IDEOGRAPH
    {0x929C, 0x51CB}, //2485 #CJK UNIFIED IDEOGRAPH
    {0x929D, 0x558B}, //2486 #CJK UNIFIED IDEOGRAPH
    {0x929E, 0x5BF5}, //2487 #CJK UNIFIED IDEOGRAPH
    {0x929F, 0x5E16}, //2488 #CJK UNIFIED IDEOGRAPH
    {0x92A0, 0x5E33}, //2489 #CJK UNIFIED IDEOGRAPH
    {0x92A1, 0x5E81}, //2490 #CJK UNIFIED IDEOGRAPH
    {0x92A2, 0x5F14}, //2491 #CJK UNIFIED IDEOGRAPH
    {0x92A3, 0x5F35}, //2492 #CJK UNIFIED IDEOGRAPH
    {0x92A4, 0x5F6B}, //2493 #CJK UNIFIED IDEOGRAPH
    {0x92A5, 0x5FB4}, //2494 #CJK UNIFIED IDEOGRAPH
    {0x92A6, 0x61F2}, //2495 #CJK UNIFIED IDEOGRAPH
    {0x92A7, 0x6311}, //2496 #CJK UNIFIED IDEOGRAPH
    {0x92A8, 0x66A2}, //2497 #CJK UNIFIED IDEOGRAPH
    {0x92A9, 0x671D}, //2498 #CJK UNIFIED IDEOGRAPH
    {0x92AA, 0x6F6E}, //2499 #CJK UNIFIED IDEOGRAPH
    {0x92AB, 0x7252}, //2500 #CJK UNIFIED IDEOGRAPH
    {0x92AC, 0x753A}, //2501 #CJK UNIFIED IDEOGRAPH
    {0x92AD, 0x773A}, //2502 #CJK UNIFIED IDEOGRAPH
    {0x92AE, 0x8074}, //2503 #CJK UNIFIED IDEOGRAPH
    {0x92AF, 0x8139}, //2504 #CJK UNIFIED IDEOGRAPH
    {0x92B0, 0x8178}, //2505 #CJK UNIFIED IDEOGRAPH
    {0x92B1, 0x8776}, //2506 #CJK UNIFIED IDEOGRAPH
    {0x92B2, 0x8ABF}, //2507 #CJK UNIFIED IDEOGRAPH
    {0x92B3, 0x8ADC}, //2508 #CJK UNIFIED IDEOGRAPH
    {0x92B4, 0x8D85}, //2509 #CJK UNIFIED IDEOGRAPH
    {0x92B5, 0x8DF3}, //2510 #CJK UNIFIED IDEOGRAPH
    {0x92B6, 0x929A}, //2511 #CJK UNIFIED IDEOGRAPH
    {0x92B7, 0x9577}, //2512 #CJK UNIFIED IDEOGRAPH
    {0x92B8, 0x9802}, //2513 #CJK UNIFIED IDEOGRAPH
    {0x92B9, 0x9CE5}, //2514 #CJK UNIFIED IDEOGRAPH
    {0x92BA, 0x52C5}, //2515 #CJK UNIFIED IDEOGRAPH
    {0x92BB, 0x6357}, //2516 #CJK UNIFIED IDEOGRAPH
    {0x92BC, 0x76F4}, //2517 #CJK UNIFIED IDEOGRAPH
    {0x92BD, 0x6715}, //2518 #CJK UNIFIED IDEOGRAPH
    {0x92BE, 0x6C88}, //2519 #CJK UNIFIED IDEOGRAPH
    {0x92BF, 0x73CD}, //2520 #CJK UNIFIED IDEOGRAPH
    {0x92C0, 0x8CC3}, //2521 #CJK UNIFIED IDEOGRAPH
    {0x92C1, 0x93AE}, //2522 #CJK UNIFIED IDEOGRAPH
    {0x92C2, 0x9673}, //2523 #CJK UNIFIED IDEOGRAPH
    {0x92C3, 0x6D25}, //2524 #CJK UNIFIED IDEOGRAPH
    {0x92C4, 0x589C}, //2525 #CJK UNIFIED IDEOGRAPH
    {0x92C5, 0x690E}, //2526 #CJK UNIFIED IDEOGRAPH
    {0x92C6, 0x69CC}, //2527 #CJK UNIFIED IDEOGRAPH
    {0x92C7, 0x8FFD}, //2528 #CJK UNIFIED IDEOGRAPH
    {0x92C8, 0x939A}, //2529 #CJK UNIFIED IDEOGRAPH
    {0x92C9, 0x75DB}, //2530 #CJK UNIFIED IDEOGRAPH
    {0x92CA, 0x901A}, //2531 #CJK UNIFIED IDEOGRAPH
    {0x92CB, 0x585A}, //2532 #CJK UNIFIED IDEOGRAPH
    {0x92CC, 0x6802}, //2533 #CJK UNIFIED IDEOGRAPH
    {0x92CD, 0x63B4}, //2534 #CJK UNIFIED IDEOGRAPH
    {0x92CE, 0x69FB}, //2535 #CJK UNIFIED IDEOGRAPH
    {0x92CF, 0x4F43}, //2536 #CJK UNIFIED IDEOGRAPH
    {0x92D0, 0x6F2C}, //2537 #CJK UNIFIED IDEOGRAPH
    {0x92D1, 0x67D8}, //2538 #CJK UNIFIED IDEOGRAPH
    {0x92D2, 0x8FBB}, //2539 #CJK UNIFIED IDEOGRAPH
    {0x92D3, 0x8526}, //2540 #CJK UNIFIED IDEOGRAPH
    {0x92D4, 0x7DB4}, //2541 #CJK UNIFIED IDEOGRAPH
    {0x92D5, 0x9354}, //2542 #CJK UNIFIED IDEOGRAPH
    {0x92D6, 0x693F}, //2543 #CJK UNIFIED IDEOGRAPH
    {0x92D7, 0x6F70}, //2544 #CJK UNIFIED IDEOGRAPH
    {0x92D8, 0x576A}, //2545 #CJK UNIFIED IDEOGRAPH
    {0x92D9, 0x58F7}, //2546 #CJK UNIFIED IDEOGRAPH
    {0x92DA, 0x5B2C}, //2547 #CJK UNIFIED IDEOGRAPH
    {0x92DB, 0x7D2C}, //2548 #CJK UNIFIED IDEOGRAPH
    {0x92DC, 0x722A}, //2549 #CJK UNIFIED IDEOGRAPH
    {0x92DD, 0x540A}, //2550 #CJK UNIFIED IDEOGRAPH
    {0x92DE, 0x91E3}, //2551 #CJK UNIFIED IDEOGRAPH
    {0x92DF, 0x9DB4}, //2552 #CJK UNIFIED IDEOGRAPH
    {0x92E0, 0x4EAD}, //2553 #CJK UNIFIED IDEOGRAPH
    {0x92E1, 0x4F4E}, //2554 #CJK UNIFIED IDEOGRAPH
    {0x92E2, 0x505C}, //2555 #CJK UNIFIED IDEOGRAPH
    {0x92E3, 0x5075}, //2556 #CJK UNIFIED IDEOGRAPH
    {0x92E4, 0x5243}, //2557 #CJK UNIFIED IDEOGRAPH
    {0x92E5, 0x8C9E}, //2558 #CJK UNIFIED IDEOGRAPH
    {0x92E6, 0x5448}, //2559 #CJK UNIFIED IDEOGRAPH
    {0x92E7, 0x5824}, //2560 #CJK UNIFIED IDEOGRAPH
    {0x92E8, 0x5B9A}, //2561 #CJK UNIFIED IDEOGRAPH
    {0x92E9, 0x5E1D}, //2562 #CJK UNIFIED IDEOGRAPH
    {0x92EA, 0x5E95}, //2563 #CJK UNIFIED IDEOGRAPH
    {0x92EB, 0x5EAD}, //2564 #CJK UNIFIED IDEOGRAPH
    {0x92EC, 0x5EF7}, //2565 #CJK UNIFIED IDEOGRAPH
    {0x92ED, 0x5F1F}, //2566 #CJK UNIFIED IDEOGRAPH
    {0x92EE, 0x608C}, //2567 #CJK UNIFIED IDEOGRAPH
    {0x92EF, 0x62B5}, //2568 #CJK UNIFIED IDEOGRAPH
    {0x92F0, 0x633A}, //2569 #CJK UNIFIED IDEOGRAPH
    {0x92F1, 0x63D0}, //2570 #CJK UNIFIED IDEOGRAPH
    {0x92F2, 0x68AF}, //2571 #CJK UNIFIED IDEOGRAPH
    {0x92F3, 0x6C40}, //2572 #CJK UNIFIED IDEOGRAPH
    {0x92F4, 0x7887}, //2573 #CJK UNIFIED IDEOGRAPH
    {0x92F5, 0x798E}, //2574 #CJK UNIFIED IDEOGRAPH
    {0x92F6, 0x7A0B}, //2575 #CJK UNIFIED IDEOGRAPH
    {0x92F7, 0x7DE0}, //2576 #CJK UNIFIED IDEOGRAPH
    {0x92F8, 0x8247}, //2577 #CJK UNIFIED IDEOGRAPH
    {0x92F9, 0x8A02}, //2578 #CJK UNIFIED IDEOGRAPH
    {0x92FA, 0x8AE6}, //2579 #CJK UNIFIED IDEOGRAPH
    {0x92FB, 0x8E44}, //2580 #CJK UNIFIED IDEOGRAPH
    {0x92FC, 0x9013}, //2581 #CJK UNIFIED IDEOGRAPH
    {0x9340, 0x90B8}, //2582 #CJK UNIFIED IDEOGRAPH
    {0x9341, 0x912D}, //2583 #CJK UNIFIED IDEOGRAPH
    {0x9342, 0x91D8}, //2584 #CJK UNIFIED IDEOGRAPH
    {0x9343, 0x9F0E}, //2585 #CJK UNIFIED IDEOGRAPH
    {0x9344, 0x6CE5}, //2586 #CJK UNIFIED IDEOGRAPH
    {0x9345, 0x6458}, //2587 #CJK UNIFIED IDEOGRAPH
    {0x9346, 0x64E2}, //2588 #CJK UNIFIED IDEOGRAPH
    {0x9347, 0x6575}, //2589 #CJK UNIFIED IDEOGRAPH
    {0x9348, 0x6EF4}, //2590 #CJK UNIFIED IDEOGRAPH
    {0x9349, 0x7684}, //2591 #CJK UNIFIED IDEOGRAPH
    {0x934A, 0x7B1B}, //2592 #CJK UNIFIED IDEOGRAPH
    {0x934B, 0x9069}, //2593 #CJK UNIFIED IDEOGRAPH
    {0x934C, 0x93D1}, //2594 #CJK UNIFIED IDEOGRAPH
    {0x934D, 0x6EBA}, //2595 #CJK UNIFIED IDEOGRAPH
    {0x934E, 0x54F2}, //2596 #CJK UNIFIED IDEOGRAPH
    {0x934F, 0x5FB9}, //2597 #CJK UNIFIED IDEOGRAPH
    {0x9350, 0x64A4}, //2598 #CJK UNIFIED IDEOGRAPH
    {0x9351, 0x8F4D}, //2599 #CJK UNIFIED IDEOGRAPH
    {0x9352, 0x8FED}, //2600 #CJK UNIFIED IDEOGRAPH
    {0x9353, 0x9244}, //2601 #CJK UNIFIED IDEOGRAPH
    {0x9354, 0x5178}, //2602 #CJK UNIFIED IDEOGRAPH
    {0x9355, 0x586B}, //2603 #CJK UNIFIED IDEOGRAPH
    {0x9356, 0x5929}, //2604 #CJK UNIFIED IDEOGRAPH
    {0x9357, 0x5C55}, //2605 #CJK UNIFIED IDEOGRAPH
    {0x9358, 0x5E97}, //2606 #CJK UNIFIED IDEOGRAPH
    {0x9359, 0x6DFB}, //2607 #CJK UNIFIED IDEOGRAPH
    {0x935A, 0x7E8F}, //2608 #CJK UNIFIED IDEOGRAPH
    {0x935B, 0x751C}, //2609 #CJK UNIFIED IDEOGRAPH
    {0x935C, 0x8CBC}, //2610 #CJK UNIFIED IDEOGRAPH
    {0x935D, 0x8EE2}, //2611 #CJK UNIFIED IDEOGRAPH
    {0x935E, 0x985B}, //2612 #CJK UNIFIED IDEOGRAPH
    {0x935F, 0x70B9}, //2613 #CJK UNIFIED IDEOGRAPH
    {0x9360, 0x4F1D}, //2614 #CJK UNIFIED IDEOGRAPH
    {0x9361, 0x6BBF}, //2615 #CJK UNIFIED IDEOGRAPH
    {0x9362, 0x6FB1}, //2616 #CJK UNIFIED IDEOGRAPH
    {0x9363, 0x7530}, //2617 #CJK UNIFIED IDEOGRAPH
    {0x9364, 0x96FB}, //2618 #CJK UNIFIED IDEOGRAPH
    {0x9365, 0x514E}, //2619 #CJK UNIFIED IDEOGRAPH
    {0x9366, 0x5410}, //2620 #CJK UNIFIED IDEOGRAPH
    {0x9367, 0x5835}, //2621 #CJK UNIFIED IDEOGRAPH
    {0x9368, 0x5857}, //2622 #CJK UNIFIED IDEOGRAPH
    {0x9369, 0x59AC}, //2623 #CJK UNIFIED IDEOGRAPH
    {0x936A, 0x5C60}, //2624 #CJK UNIFIED IDEOGRAPH
    {0x936B, 0x5F92}, //2625 #CJK UNIFIED IDEOGRAPH
    {0x936C, 0x6597}, //2626 #CJK UNIFIED IDEOGRAPH
    {0x936D, 0x675C}, //2627 #CJK UNIFIED IDEOGRAPH
    {0x936E, 0x6E21}, //2628 #CJK UNIFIED IDEOGRAPH
    {0x936F, 0x767B}, //2629 #CJK UNIFIED IDEOGRAPH
    {0x9370, 0x83DF}, //2630 #CJK UNIFIED IDEOGRAPH
    {0x9371, 0x8CED}, //2631 #CJK UNIFIED IDEOGRAPH
    {0x9372, 0x9014}, //2632 #CJK UNIFIED IDEOGRAPH
    {0x9373, 0x90FD}, //2633 #CJK UNIFIED IDEOGRAPH
    {0x9374, 0x934D}, //2634 #CJK UNIFIED IDEOGRAPH
    {0x9375, 0x7825}, //2635 #CJK UNIFIED IDEOGRAPH
    {0x9376, 0x783A}, //2636 #CJK UNIFIED IDEOGRAPH
    {0x9377, 0x52AA}, //2637 #CJK UNIFIED IDEOGRAPH
    {0x9378, 0x5EA6}, //2638 #CJK UNIFIED IDEOGRAPH
    {0x9379, 0x571F}, //2639 #CJK UNIFIED IDEOGRAPH
    {0x937A, 0x5974}, //2640 #CJK UNIFIED IDEOGRAPH
    {0x937B, 0x6012}, //2641 #CJK UNIFIED IDEOGRAPH
    {0x937C, 0x5012}, //2642 #CJK UNIFIED IDEOGRAPH
    {0x937D, 0x515A}, //2643 #CJK UNIFIED IDEOGRAPH
    {0x937E, 0x51AC}, //2644 #CJK UNIFIED IDEOGRAPH
    {0x9380, 0x51CD}, //2645 #CJK UNIFIED IDEOGRAPH
    {0x9381, 0x5200}, //2646 #CJK UNIFIED IDEOGRAPH
    {0x9382, 0x5510}, //2647 #CJK UNIFIED IDEOGRAPH
    {0x9383, 0x5854}, //2648 #CJK UNIFIED IDEOGRAPH
    {0x9384, 0x5858}, //2649 #CJK UNIFIED IDEOGRAPH
    {0x9385, 0x5957}, //2650 #CJK UNIFIED IDEOGRAPH
    {0x9386, 0x5B95}, //2651 #CJK UNIFIED IDEOGRAPH
    {0x9387, 0x5CF6}, //2652 #CJK UNIFIED IDEOGRAPH
    {0x9388, 0x5D8B}, //2653 #CJK UNIFIED IDEOGRAPH
    {0x9389, 0x60BC}, //2654 #CJK UNIFIED IDEOGRAPH
    {0x938A, 0x6295}, //2655 #CJK UNIFIED IDEOGRAPH
    {0x938B, 0x642D}, //2656 #CJK UNIFIED IDEOGRAPH
    {0x938C, 0x6771}, //2657 #CJK UNIFIED IDEOGRAPH
    {0x938D, 0x6843}, //2658 #CJK UNIFIED IDEOGRAPH
    {0x938E, 0x68BC}, //2659 #CJK UNIFIED IDEOGRAPH
    {0x938F, 0x68DF}, //2660 #CJK UNIFIED IDEOGRAPH
    {0x9390, 0x76D7}, //2661 #CJK UNIFIED IDEOGRAPH
    {0x9391, 0x6DD8}, //2662 #CJK UNIFIED IDEOGRAPH
    {0x9392, 0x6E6F}, //2663 #CJK UNIFIED IDEOGRAPH
    {0x9393, 0x6D9B}, //2664 #CJK UNIFIED IDEOGRAPH
    {0x9394, 0x706F}, //2665 #CJK UNIFIED IDEOGRAPH
    {0x9395, 0x71C8}, //2666 #CJK UNIFIED IDEOGRAPH
    {0x9396, 0x5F53}, //2667 #CJK UNIFIED IDEOGRAPH
    {0x9397, 0x75D8}, //2668 #CJK UNIFIED IDEOGRAPH
    {0x9398, 0x7977}, //2669 #CJK UNIFIED IDEOGRAPH
    {0x9399, 0x7B49}, //2670 #CJK UNIFIED IDEOGRAPH
    {0x939A, 0x7B54}, //2671 #CJK UNIFIED IDEOGRAPH
    {0x939B, 0x7B52}, //2672 #CJK UNIFIED IDEOGRAPH
    {0x939C, 0x7CD6}, //2673 #CJK UNIFIED IDEOGRAPH
    {0x939D, 0x7D71}, //2674 #CJK UNIFIED IDEOGRAPH
    {0x939E, 0x5230}, //2675 #CJK UNIFIED IDEOGRAPH
    {0x939F, 0x8463}, //2676 #CJK UNIFIED IDEOGRAPH
    {0x93A0, 0x8569}, //2677 #CJK UNIFIED IDEOGRAPH
    {0x93A1, 0x85E4}, //2678 #CJK UNIFIED IDEOGRAPH
    {0x93A2, 0x8A0E}, //2679 #CJK UNIFIED IDEOGRAPH
    {0x93A3, 0x8B04}, //2680 #CJK UNIFIED IDEOGRAPH
    {0x93A4, 0x8C46}, //2681 #CJK UNIFIED IDEOGRAPH
    {0x93A5, 0x8E0F}, //2682 #CJK UNIFIED IDEOGRAPH
    {0x93A6, 0x9003}, //2683 #CJK UNIFIED IDEOGRAPH
    {0x93A7, 0x900F}, //2684 #CJK UNIFIED IDEOGRAPH
    {0x93A8, 0x9419}, //2685 #CJK UNIFIED IDEOGRAPH
    {0x93A9, 0x9676}, //2686 #CJK UNIFIED IDEOGRAPH
    {0x93AA, 0x982D}, //2687 #CJK UNIFIED IDEOGRAPH
    {0x93AB, 0x9A30}, //2688 #CJK UNIFIED IDEOGRAPH
    {0x93AC, 0x95D8}, //2689 #CJK UNIFIED IDEOGRAPH
    {0x93AD, 0x50CD}, //2690 #CJK UNIFIED IDEOGRAPH
    {0x93AE, 0x52D5}, //2691 #CJK UNIFIED IDEOGRAPH
    {0x93AF, 0x540C}, //2692 #CJK UNIFIED IDEOGRAPH
    {0x93B0, 0x5802}, //2693 #CJK UNIFIED IDEOGRAPH
    {0x93B1, 0x5C0E}, //2694 #CJK UNIFIED IDEOGRAPH
    {0x93B2, 0x61A7}, //2695 #CJK UNIFIED IDEOGRAPH
    {0x93B3, 0x649E}, //2696 #CJK UNIFIED IDEOGRAPH
    {0x93B4, 0x6D1E}, //2697 #CJK UNIFIED IDEOGRAPH
    {0x93B5, 0x77B3}, //2698 #CJK UNIFIED IDEOGRAPH
    {0x93B6, 0x7AE5}, //2699 #CJK UNIFIED IDEOGRAPH
    {0x93B7, 0x80F4}, //2700 #CJK UNIFIED IDEOGRAPH
    {0x93B8, 0x8404}, //2701 #CJK UNIFIED IDEOGRAPH
    {0x93B9, 0x9053}, //2702 #CJK UNIFIED IDEOGRAPH
    {0x93BA, 0x9285}, //2703 #CJK UNIFIED IDEOGRAPH
    {0x93BB, 0x5CE0}, //2704 #CJK UNIFIED IDEOGRAPH
    {0x93BC, 0x9D07}, //2705 #CJK UNIFIED IDEOGRAPH
    {0x93BD, 0x533F}, //2706 #CJK UNIFIED IDEOGRAPH
    {0x93BE, 0x5F97}, //2707 #CJK UNIFIED IDEOGRAPH
    {0x93BF, 0x5FB3}, //2708 #CJK UNIFIED IDEOGRAPH
    {0x93C0, 0x6D9C}, //2709 #CJK UNIFIED IDEOGRAPH
    {0x93C1, 0x7279}, //2710 #CJK UNIFIED IDEOGRAPH
    {0x93C2, 0x7763}, //2711 #CJK UNIFIED IDEOGRAPH
    {0x93C3, 0x79BF}, //2712 #CJK UNIFIED IDEOGRAPH
    {0x93C4, 0x7BE4}, //2713 #CJK UNIFIED IDEOGRAPH
    {0x93C5, 0x6BD2}, //2714 #CJK UNIFIED IDEOGRAPH
    {0x93C6, 0x72EC}, //2715 #CJK UNIFIED IDEOGRAPH
    {0x93C7, 0x8AAD}, //2716 #CJK UNIFIED IDEOGRAPH
    {0x93C8, 0x6803}, //2717 #CJK UNIFIED IDEOGRAPH
    {0x93C9, 0x6A61}, //2718 #CJK UNIFIED IDEOGRAPH
    {0x93CA, 0x51F8}, //2719 #CJK UNIFIED IDEOGRAPH
    {0x93CB, 0x7A81}, //2720 #CJK UNIFIED IDEOGRAPH
    {0x93CC, 0x6934}, //2721 #CJK UNIFIED IDEOGRAPH
    {0x93CD, 0x5C4A}, //2722 #CJK UNIFIED IDEOGRAPH
    {0x93CE, 0x9CF6}, //2723 #CJK UNIFIED IDEOGRAPH
    {0x93CF, 0x82EB}, //2724 #CJK UNIFIED IDEOGRAPH
    {0x93D0, 0x5BC5}, //2725 #CJK UNIFIED IDEOGRAPH
    {0x93D1, 0x9149}, //2726 #CJK UNIFIED IDEOGRAPH
    {0x93D2, 0x701E}, //2727 #CJK UNIFIED IDEOGRAPH
    {0x93D3, 0x5678}, //2728 #CJK UNIFIED IDEOGRAPH
    {0x93D4, 0x5C6F}, //2729 #CJK UNIFIED IDEOGRAPH
    {0x93D5, 0x60C7}, //2730 #CJK UNIFIED IDEOGRAPH
    {0x93D6, 0x6566}, //2731 #CJK UNIFIED IDEOGRAPH
    {0x93D7, 0x6C8C}, //2732 #CJK UNIFIED IDEOGRAPH
    {0x93D8, 0x8C5A}, //2733 #CJK UNIFIED IDEOGRAPH
    {0x93D9, 0x9041}, //2734 #CJK UNIFIED IDEOGRAPH
    {0x93DA, 0x9813}, //2735 #CJK UNIFIED IDEOGRAPH
    {0x93DB, 0x5451}, //2736 #CJK UNIFIED IDEOGRAPH
    {0x93DC, 0x66C7}, //2737 #CJK UNIFIED IDEOGRAPH
    {0x93DD, 0x920D}, //2738 #CJK UNIFIED IDEOGRAPH
    {0x93DE, 0x5948}, //2739 #CJK UNIFIED IDEOGRAPH
    {0x93DF, 0x90A3}, //2740 #CJK UNIFIED IDEOGRAPH
    {0x93E0, 0x5185}, //2741 #CJK UNIFIED IDEOGRAPH
    {0x93E1, 0x4E4D}, //2742 #CJK UNIFIED IDEOGRAPH
    {0x93E2, 0x51EA}, //2743 #CJK UNIFIED IDEOGRAPH
    {0x93E3, 0x8599}, //2744 #CJK UNIFIED IDEOGRAPH
    {0x93E4, 0x8B0E}, //2745 #CJK UNIFIED IDEOGRAPH
    {0x93E5, 0x7058}, //2746 #CJK UNIFIED IDEOGRAPH
    {0x93E6, 0x637A}, //2747 #CJK UNIFIED IDEOGRAPH
    {0x93E7, 0x934B}, //2748 #CJK UNIFIED IDEOGRAPH
    {0x93E8, 0x6962}, //2749 #CJK UNIFIED IDEOGRAPH
    {0x93E9, 0x99B4}, //2750 #CJK UNIFIED IDEOGRAPH
    {0x93EA, 0x7E04}, //2751 #CJK UNIFIED IDEOGRAPH
    {0x93EB, 0x7577}, //2752 #CJK UNIFIED IDEOGRAPH
    {0x93EC, 0x5357}, //2753 #CJK UNIFIED IDEOGRAPH
    {0x93ED, 0x6960}, //2754 #CJK UNIFIED IDEOGRAPH
    {0x93EE, 0x8EDF}, //2755 #CJK UNIFIED IDEOGRAPH
    {0x93EF, 0x96E3}, //2756 #CJK UNIFIED IDEOGRAPH
    {0x93F0, 0x6C5D}, //2757 #CJK UNIFIED IDEOGRAPH
    {0x93F1, 0x4E8C}, //2758 #CJK UNIFIED IDEOGRAPH
    {0x93F2, 0x5C3C}, //2759 #CJK UNIFIED IDEOGRAPH
    {0x93F3, 0x5F10}, //2760 #CJK UNIFIED IDEOGRAPH
    {0x93F4, 0x8FE9}, //2761 #CJK UNIFIED IDEOGRAPH
    {0x93F5, 0x5302}, //2762 #CJK UNIFIED IDEOGRAPH
    {0x93F6, 0x8CD1}, //2763 #CJK UNIFIED IDEOGRAPH
    {0x93F7, 0x8089}, //2764 #CJK UNIFIED IDEOGRAPH
    {0x93F8, 0x8679}, //2765 #CJK UNIFIED IDEOGRAPH
    {0x93F9, 0x5EFF}, //2766 #CJK UNIFIED IDEOGRAPH
    {0x93FA, 0x65E5}, //2767 #CJK UNIFIED IDEOGRAPH
    {0x93FB, 0x4E73}, //2768 #CJK UNIFIED IDEOGRAPH
    {0x93FC, 0x5165}, //2769 #CJK UNIFIED IDEOGRAPH
    {0x9440, 0x5982}, //2770 #CJK UNIFIED IDEOGRAPH
    {0x9441, 0x5C3F}, //2771 #CJK UNIFIED IDEOGRAPH
    {0x9442, 0x97EE}, //2772 #CJK UNIFIED IDEOGRAPH
    {0x9443, 0x4EFB}, //2773 #CJK UNIFIED IDEOGRAPH
    {0x9444, 0x598A}, //2774 #CJK UNIFIED IDEOGRAPH
    {0x9445, 0x5FCD}, //2775 #CJK UNIFIED IDEOGRAPH
    {0x9446, 0x8A8D}, //2776 #CJK UNIFIED IDEOGRAPH
    {0x9447, 0x6FE1}, //2777 #CJK UNIFIED IDEOGRAPH
    {0x9448, 0x79B0}, //2778 #CJK UNIFIED IDEOGRAPH
    {0x9449, 0x7962}, //2779 #CJK UNIFIED IDEOGRAPH
    {0x944A, 0x5BE7}, //2780 #CJK UNIFIED IDEOGRAPH
    {0x944B, 0x8471}, //2781 #CJK UNIFIED IDEOGRAPH
    {0x944C, 0x732B}, //2782 #CJK UNIFIED IDEOGRAPH
    {0x944D, 0x71B1}, //2783 #CJK UNIFIED IDEOGRAPH
    {0x944E, 0x5E74}, //2784 #CJK UNIFIED IDEOGRAPH
    {0x944F, 0x5FF5}, //2785 #CJK UNIFIED IDEOGRAPH
    {0x9450, 0x637B}, //2786 #CJK UNIFIED IDEOGRAPH
    {0x9451, 0x649A}, //2787 #CJK UNIFIED IDEOGRAPH
    {0x9452, 0x71C3}, //2788 #CJK UNIFIED IDEOGRAPH
    {0x9453, 0x7C98}, //2789 #CJK UNIFIED IDEOGRAPH
    {0x9454, 0x4E43}, //2790 #CJK UNIFIED IDEOGRAPH
    {0x9455, 0x5EFC}, //2791 #CJK UNIFIED IDEOGRAPH
    {0x9456, 0x4E4B}, //2792 #CJK UNIFIED IDEOGRAPH
    {0x9457, 0x57DC}, //2793 #CJK UNIFIED IDEOGRAPH
    {0x9458, 0x56A2}, //2794 #CJK UNIFIED IDEOGRAPH
    {0x9459, 0x60A9}, //2795 #CJK UNIFIED IDEOGRAPH
    {0x945A, 0x6FC3}, //2796 #CJK UNIFIED IDEOGRAPH
    {0x945B, 0x7D0D}, //2797 #CJK UNIFIED IDEOGRAPH
    {0x945C, 0x80FD}, //2798 #CJK UNIFIED IDEOGRAPH
    {0x945D, 0x8133}, //2799 #CJK UNIFIED IDEOGRAPH
    {0x945E, 0x81BF}, //2800 #CJK UNIFIED IDEOGRAPH
    {0x945F, 0x8FB2}, //2801 #CJK UNIFIED IDEOGRAPH
    {0x9460, 0x8997}, //2802 #CJK UNIFIED IDEOGRAPH
    {0x9461, 0x86A4}, //2803 #CJK UNIFIED IDEOGRAPH
    {0x9462, 0x5DF4}, //2804 #CJK UNIFIED IDEOGRAPH
    {0x9463, 0x628A}, //2805 #CJK UNIFIED IDEOGRAPH
    {0x9464, 0x64AD}, //2806 #CJK UNIFIED IDEOGRAPH
    {0x9465, 0x8987}, //2807 #CJK UNIFIED IDEOGRAPH
    {0x9466, 0x6777}, //2808 #CJK UNIFIED IDEOGRAPH
    {0x9467, 0x6CE2}, //2809 #CJK UNIFIED IDEOGRAPH
    {0x9468, 0x6D3E}, //2810 #CJK UNIFIED IDEOGRAPH
    {0x9469, 0x7436}, //2811 #CJK UNIFIED IDEOGRAPH
    {0x946A, 0x7834}, //2812 #CJK UNIFIED IDEOGRAPH
    {0x946B, 0x5A46}, //2813 #CJK UNIFIED IDEOGRAPH
    {0x946C, 0x7F75}, //2814 #CJK UNIFIED IDEOGRAPH
    {0x946D, 0x82AD}, //2815 #CJK UNIFIED IDEOGRAPH
    {0x946E, 0x99AC}, //2816 #CJK UNIFIED IDEOGRAPH
    {0x946F, 0x4FF3}, //2817 #CJK UNIFIED IDEOGRAPH
    {0x9470, 0x5EC3}, //2818 #CJK UNIFIED IDEOGRAPH
    {0x9471, 0x62DD}, //2819 #CJK UNIFIED IDEOGRAPH
    {0x9472, 0x6392}, //2820 #CJK UNIFIED IDEOGRAPH
    {0x9473, 0x6557}, //2821 #CJK UNIFIED IDEOGRAPH
    {0x9474, 0x676F}, //2822 #CJK UNIFIED IDEOGRAPH
    {0x9475, 0x76C3}, //2823 #CJK UNIFIED IDEOGRAPH
    {0x9476, 0x724C}, //2824 #CJK UNIFIED IDEOGRAPH
    {0x9477, 0x80CC}, //2825 #CJK UNIFIED IDEOGRAPH
    {0x9478, 0x80BA}, //2826 #CJK UNIFIED IDEOGRAPH
    {0x9479, 0x8F29}, //2827 #CJK UNIFIED IDEOGRAPH
    {0x947A, 0x914D}, //2828 #CJK UNIFIED IDEOGRAPH
    {0x947B, 0x500D}, //2829 #CJK UNIFIED IDEOGRAPH
    {0x947C, 0x57F9}, //2830 #CJK UNIFIED IDEOGRAPH
    {0x947D, 0x5A92}, //2831 #CJK UNIFIED IDEOGRAPH
    {0x947E, 0x6885}, //2832 #CJK UNIFIED IDEOGRAPH
    {0x9480, 0x6973}, //2833 #CJK UNIFIED IDEOGRAPH
    {0x9481, 0x7164}, //2834 #CJK UNIFIED IDEOGRAPH
    {0x9482, 0x72FD}, //2835 #CJK UNIFIED IDEOGRAPH
    {0x9483, 0x8CB7}, //2836 #CJK UNIFIED IDEOGRAPH
    {0x9484, 0x58F2}, //2837 #CJK UNIFIED IDEOGRAPH
    {0x9485, 0x8CE0}, //2838 #CJK UNIFIED IDEOGRAPH
    {0x9486, 0x966A}, //2839 #CJK UNIFIED IDEOGRAPH
    {0x9487, 0x9019}, //2840 #CJK UNIFIED IDEOGRAPH
    {0x9488, 0x877F}, //2841 #CJK UNIFIED IDEOGRAPH
    {0x9489, 0x79E4}, //2842 #CJK UNIFIED IDEOGRAPH
    {0x948A, 0x77E7}, //2843 #CJK UNIFIED IDEOGRAPH
    {0x948B, 0x8429}, //2844 #CJK UNIFIED IDEOGRAPH
    {0x948C, 0x4F2F}, //2845 #CJK UNIFIED IDEOGRAPH
    {0x948D, 0x5265}, //2846 #CJK UNIFIED IDEOGRAPH
    {0x948E, 0x535A}, //2847 #CJK UNIFIED IDEOGRAPH
    {0x948F, 0x62CD}, //2848 #CJK UNIFIED IDEOGRAPH
    {0x9490, 0x67CF}, //2849 #CJK UNIFIED IDEOGRAPH
    {0x9491, 0x6CCA}, //2850 #CJK UNIFIED IDEOGRAPH
    {0x9492, 0x767D}, //2851 #CJK UNIFIED IDEOGRAPH
    {0x9493, 0x7B94}, //2852 #CJK UNIFIED IDEOGRAPH
    {0x9494, 0x7C95}, //2853 #CJK UNIFIED IDEOGRAPH
    {0x9495, 0x8236}, //2854 #CJK UNIFIED IDEOGRAPH
    {0x9496, 0x8584}, //2855 #CJK UNIFIED IDEOGRAPH
    {0x9497, 0x8FEB}, //2856 #CJK UNIFIED IDEOGRAPH
    {0x9498, 0x66DD}, //2857 #CJK UNIFIED IDEOGRAPH
    {0x9499, 0x6F20}, //2858 #CJK UNIFIED IDEOGRAPH
    {0x949A, 0x7206}, //2859 #CJK UNIFIED IDEOGRAPH
    {0x949B, 0x7E1B}, //2860 #CJK UNIFIED IDEOGRAPH
    {0x949C, 0x83AB}, //2861 #CJK UNIFIED IDEOGRAPH
    {0x949D, 0x99C1}, //2862 #CJK UNIFIED IDEOGRAPH
    {0x949E, 0x9EA6}, //2863 #CJK UNIFIED IDEOGRAPH
    {0x949F, 0x51FD}, //2864 #CJK UNIFIED IDEOGRAPH
    {0x94A0, 0x7BB1}, //2865 #CJK UNIFIED IDEOGRAPH
    {0x94A1, 0x7872}, //2866 #CJK UNIFIED IDEOGRAPH
    {0x94A2, 0x7BB8}, //2867 #CJK UNIFIED IDEOGRAPH
    {0x94A3, 0x8087}, //2868 #CJK UNIFIED IDEOGRAPH
    {0x94A4, 0x7B48}, //2869 #CJK UNIFIED IDEOGRAPH
    {0x94A5, 0x6AE8}, //2870 #CJK UNIFIED IDEOGRAPH
    {0x94A6, 0x5E61}, //2871 #CJK UNIFIED IDEOGRAPH
    {0x94A7, 0x808C}, //2872 #CJK UNIFIED IDEOGRAPH
    {0x94A8, 0x7551}, //2873 #CJK UNIFIED IDEOGRAPH
    {0x94A9, 0x7560}, //2874 #CJK UNIFIED IDEOGRAPH
    {0x94AA, 0x516B}, //2875 #CJK UNIFIED IDEOGRAPH
    {0x94AB, 0x9262}, //2876 #CJK UNIFIED IDEOGRAPH
    {0x94AC, 0x6E8C}, //2877 #CJK UNIFIED IDEOGRAPH
    {0x94AD, 0x767A}, //2878 #CJK UNIFIED IDEOGRAPH
    {0x94AE, 0x9197}, //2879 #CJK UNIFIED IDEOGRAPH
    {0x94AF, 0x9AEA}, //2880 #CJK UNIFIED IDEOGRAPH
    {0x94B0, 0x4F10}, //2881 #CJK UNIFIED IDEOGRAPH
    {0x94B1, 0x7F70}, //2882 #CJK UNIFIED IDEOGRAPH
    {0x94B2, 0x629C}, //2883 #CJK UNIFIED IDEOGRAPH
    {0x94B3, 0x7B4F}, //2884 #CJK UNIFIED IDEOGRAPH
    {0x94B4, 0x95A5}, //2885 #CJK UNIFIED IDEOGRAPH
    {0x94B5, 0x9CE9}, //2886 #CJK UNIFIED IDEOGRAPH
    {0x94B6, 0x567A}, //2887 #CJK UNIFIED IDEOGRAPH
    {0x94B7, 0x5859}, //2888 #CJK UNIFIED IDEOGRAPH
    {0x94B8, 0x86E4}, //2889 #CJK UNIFIED IDEOGRAPH
    {0x94B9, 0x96BC}, //2890 #CJK UNIFIED IDEOGRAPH
    {0x94BA, 0x4F34}, //2891 #CJK UNIFIED IDEOGRAPH
    {0x94BB, 0x5224}, //2892 #CJK UNIFIED IDEOGRAPH
    {0x94BC, 0x534A}, //2893 #CJK UNIFIED IDEOGRAPH
    {0x94BD, 0x53CD}, //2894 #CJK UNIFIED IDEOGRAPH
    {0x94BE, 0x53DB}, //2895 #CJK UNIFIED IDEOGRAPH
    {0x94BF, 0x5E06}, //2896 #CJK UNIFIED IDEOGRAPH
    {0x94C0, 0x642C}, //2897 #CJK UNIFIED IDEOGRAPH
    {0x94C1, 0x6591}, //2898 #CJK UNIFIED IDEOGRAPH
    {0x94C2, 0x677F}, //2899 #CJK UNIFIED IDEOGRAPH
    {0x94C3, 0x6C3E}, //2900 #CJK UNIFIED IDEOGRAPH
    {0x94C4, 0x6C4E}, //2901 #CJK UNIFIED IDEOGRAPH
    {0x94C5, 0x7248}, //2902 #CJK UNIFIED IDEOGRAPH
    {0x94C6, 0x72AF}, //2903 #CJK UNIFIED IDEOGRAPH
    {0x94C7, 0x73ED}, //2904 #CJK UNIFIED IDEOGRAPH
    {0x94C8, 0x7554}, //2905 #CJK UNIFIED IDEOGRAPH
    {0x94C9, 0x7E41}, //2906 #CJK UNIFIED IDEOGRAPH
    {0x94CA, 0x822C}, //2907 #CJK UNIFIED IDEOGRAPH
    {0x94CB, 0x85E9}, //2908 #CJK UNIFIED IDEOGRAPH
    {0x94CC, 0x8CA9}, //2909 #CJK UNIFIED IDEOGRAPH
    {0x94CD, 0x7BC4}, //2910 #CJK UNIFIED IDEOGRAPH
    {0x94CE, 0x91C6}, //2911 #CJK UNIFIED IDEOGRAPH
    {0x94CF, 0x7169}, //2912 #CJK UNIFIED IDEOGRAPH
    {0x94D0, 0x9812}, //2913 #CJK UNIFIED IDEOGRAPH
    {0x94D1, 0x98EF}, //2914 #CJK UNIFIED IDEOGRAPH
    {0x94D2, 0x633D}, //2915 #CJK UNIFIED IDEOGRAPH
    {0x94D3, 0x6669}, //2916 #CJK UNIFIED IDEOGRAPH
    {0x94D4, 0x756A}, //2917 #CJK UNIFIED IDEOGRAPH
    {0x94D5, 0x76E4}, //2918 #CJK UNIFIED IDEOGRAPH
    {0x94D6, 0x78D0}, //2919 #CJK UNIFIED IDEOGRAPH
    {0x94D7, 0x8543}, //2920 #CJK UNIFIED IDEOGRAPH
    {0x94D8, 0x86EE}, //2921 #CJK UNIFIED IDEOGRAPH
    {0x94D9, 0x532A}, //2922 #CJK UNIFIED IDEOGRAPH
    {0x94DA, 0x5351}, //2923 #CJK UNIFIED IDEOGRAPH
    {0x94DB, 0x5426}, //2924 #CJK UNIFIED IDEOGRAPH
    {0x94DC, 0x5983}, //2925 #CJK UNIFIED IDEOGRAPH
    {0x94DD, 0x5E87}, //2926 #CJK UNIFIED IDEOGRAPH
    {0x94DE, 0x5F7C}, //2927 #CJK UNIFIED IDEOGRAPH
    {0x94DF, 0x60B2}, //2928 #CJK UNIFIED IDEOGRAPH
    {0x94E0, 0x6249}, //2929 #CJK UNIFIED IDEOGRAPH
    {0x94E1, 0x6279}, //2930 #CJK UNIFIED IDEOGRAPH
    {0x94E2, 0x62AB}, //2931 #CJK UNIFIED IDEOGRAPH
    {0x94E3, 0x6590}, //2932 #CJK UNIFIED IDEOGRAPH
    {0x94E4, 0x6BD4}, //2933 #CJK UNIFIED IDEOGRAPH
    {0x94E5, 0x6CCC}, //2934 #CJK UNIFIED IDEOGRAPH
    {0x94E6, 0x75B2}, //2935 #CJK UNIFIED IDEOGRAPH
    {0x94E7, 0x76AE}, //2936 #CJK UNIFIED IDEOGRAPH
    {0x94E8, 0x7891}, //2937 #CJK UNIFIED IDEOGRAPH
    {0x94E9, 0x79D8}, //2938 #CJK UNIFIED IDEOGRAPH
    {0x94EA, 0x7DCB}, //2939 #CJK UNIFIED IDEOGRAPH
    {0x94EB, 0x7F77}, //2940 #CJK UNIFIED IDEOGRAPH
    {0x94EC, 0x80A5}, //2941 #CJK UNIFIED IDEOGRAPH
    {0x94ED, 0x88AB}, //2942 #CJK UNIFIED IDEOGRAPH
    {0x94EE, 0x8AB9}, //2943 #CJK UNIFIED IDEOGRAPH
    {0x94EF, 0x8CBB}, //2944 #CJK UNIFIED IDEOGRAPH
    {0x94F0, 0x907F}, //2945 #CJK UNIFIED IDEOGRAPH
    {0x94F1, 0x975E}, //2946 #CJK UNIFIED IDEOGRAPH
    {0x94F2, 0x98DB}, //2947 #CJK UNIFIED IDEOGRAPH
    {0x94F3, 0x6A0B}, //2948 #CJK UNIFIED IDEOGRAPH
    {0x94F4, 0x7C38}, //2949 #CJK UNIFIED IDEOGRAPH
    {0x94F5, 0x5099}, //2950 #CJK UNIFIED IDEOGRAPH
    {0x94F6, 0x5C3E}, //2951 #CJK UNIFIED IDEOGRAPH
    {0x94F7, 0x5FAE}, //2952 #CJK UNIFIED IDEOGRAPH
    {0x94F8, 0x6787}, //2953 #CJK UNIFIED IDEOGRAPH
    {0x94F9, 0x6BD8}, //2954 #CJK UNIFIED IDEOGRAPH
    {0x94FA, 0x7435}, //2955 #CJK UNIFIED IDEOGRAPH
    {0x94FB, 0x7709}, //2956 #CJK UNIFIED IDEOGRAPH
    {0x94FC, 0x7F8E}, //2957 #CJK UNIFIED IDEOGRAPH
    {0x9540, 0x9F3B}, //2958 #CJK UNIFIED IDEOGRAPH
    {0x9541, 0x67CA}, //2959 #CJK UNIFIED IDEOGRAPH
    {0x9542, 0x7A17}, //2960 #CJK UNIFIED IDEOGRAPH
    {0x9543, 0x5339}, //2961 #CJK UNIFIED IDEOGRAPH
    {0x9544, 0x758B}, //2962 #CJK UNIFIED IDEOGRAPH
    {0x9545, 0x9AED}, //2963 #CJK UNIFIED IDEOGRAPH
    {0x9546, 0x5F66}, //2964 #CJK UNIFIED IDEOGRAPH
    {0x9547, 0x819D}, //2965 #CJK UNIFIED IDEOGRAPH
    {0x9548, 0x83F1}, //2966 #CJK UNIFIED IDEOGRAPH
    {0x9549, 0x8098}, //2967 #CJK UNIFIED IDEOGRAPH
    {0x954A, 0x5F3C}, //2968 #CJK UNIFIED IDEOGRAPH
    {0x954B, 0x5FC5}, //2969 #CJK UNIFIED IDEOGRAPH
    {0x954C, 0x7562}, //2970 #CJK UNIFIED IDEOGRAPH
    {0x954D, 0x7B46}, //2971 #CJK UNIFIED IDEOGRAPH
    {0x954E, 0x903C}, //2972 #CJK UNIFIED IDEOGRAPH
    {0x954F, 0x6867}, //2973 #CJK UNIFIED IDEOGRAPH
    {0x9550, 0x59EB}, //2974 #CJK UNIFIED IDEOGRAPH
    {0x9551, 0x5A9B}, //2975 #CJK UNIFIED IDEOGRAPH
    {0x9552, 0x7D10}, //2976 #CJK UNIFIED IDEOGRAPH
    {0x9553, 0x767E}, //2977 #CJK UNIFIED IDEOGRAPH
    {0x9554, 0x8B2C}, //2978 #CJK UNIFIED IDEOGRAPH
    {0x9555, 0x4FF5}, //2979 #CJK UNIFIED IDEOGRAPH
    {0x9556, 0x5F6A}, //2980 #CJK UNIFIED IDEOGRAPH
    {0x9557, 0x6A19}, //2981 #CJK UNIFIED IDEOGRAPH
    {0x9558, 0x6C37}, //2982 #CJK UNIFIED IDEOGRAPH
    {0x9559, 0x6F02}, //2983 #CJK UNIFIED IDEOGRAPH
    {0x955A, 0x74E2}, //2984 #CJK UNIFIED IDEOGRAPH
    {0x955B, 0x7968}, //2985 #CJK UNIFIED IDEOGRAPH
    {0x955C, 0x8868}, //2986 #CJK UNIFIED IDEOGRAPH
    {0x955D, 0x8A55}, //2987 #CJK UNIFIED IDEOGRAPH
    {0x955E, 0x8C79}, //2988 #CJK UNIFIED IDEOGRAPH
    {0x955F, 0x5EDF}, //2989 #CJK UNIFIED IDEOGRAPH
    {0x9560, 0x63CF}, //2990 #CJK UNIFIED IDEOGRAPH
    {0x9561, 0x75C5}, //2991 #CJK UNIFIED IDEOGRAPH
    {0x9562, 0x79D2}, //2992 #CJK UNIFIED IDEOGRAPH
    {0x9563, 0x82D7}, //2993 #CJK UNIFIED IDEOGRAPH
    {0x9564, 0x9328}, //2994 #CJK UNIFIED IDEOGRAPH
    {0x9565, 0x92F2}, //2995 #CJK UNIFIED IDEOGRAPH
    {0x9566, 0x849C}, //2996 #CJK UNIFIED IDEOGRAPH
    {0x9567, 0x86ED}, //2997 #CJK UNIFIED IDEOGRAPH
    {0x9568, 0x9C2D}, //2998 #CJK UNIFIED IDEOGRAPH
    {0x9569, 0x54C1}, //2999 #CJK UNIFIED IDEOGRAPH
    {0x956A, 0x5F6C}, //3000 #CJK UNIFIED IDEOGRAPH
    {0x956B, 0x658C}, //3001 #CJK UNIFIED IDEOGRAPH
    {0x956C, 0x6D5C}, //3002 #CJK UNIFIED IDEOGRAPH
    {0x956D, 0x7015}, //3003 #CJK UNIFIED IDEOGRAPH
    {0x956E, 0x8CA7}, //3004 #CJK UNIFIED IDEOGRAPH
    {0x956F, 0x8CD3}, //3005 #CJK UNIFIED IDEOGRAPH
    {0x9570, 0x983B}, //3006 #CJK UNIFIED IDEOGRAPH
    {0x9571, 0x654F}, //3007 #CJK UNIFIED IDEOGRAPH
    {0x9572, 0x74F6}, //3008 #CJK UNIFIED IDEOGRAPH
    {0x9573, 0x4E0D}, //3009 #CJK UNIFIED IDEOGRAPH
    {0x9574, 0x4ED8}, //3010 #CJK UNIFIED IDEOGRAPH
    {0x9575, 0x57E0}, //3011 #CJK UNIFIED IDEOGRAPH
    {0x9576, 0x592B}, //3012 #CJK UNIFIED IDEOGRAPH
    {0x9577, 0x5A66}, //3013 #CJK UNIFIED IDEOGRAPH
    {0x9578, 0x5BCC}, //3014 #CJK UNIFIED IDEOGRAPH
    {0x9579, 0x51A8}, //3015 #CJK UNIFIED IDEOGRAPH
    {0x957A, 0x5E03}, //3016 #CJK UNIFIED IDEOGRAPH
    {0x957B, 0x5E9C}, //3017 #CJK UNIFIED IDEOGRAPH
    {0x957C, 0x6016}, //3018 #CJK UNIFIED IDEOGRAPH
    {0x957D, 0x6276}, //3019 #CJK UNIFIED IDEOGRAPH
    {0x957E, 0x6577}, //3020 #CJK UNIFIED IDEOGRAPH
    {0x9580, 0x65A7}, //3021 #CJK UNIFIED IDEOGRAPH
    {0x9581, 0x666E}, //3022 #CJK UNIFIED IDEOGRAPH
    {0x9582, 0x6D6E}, //3023 #CJK UNIFIED IDEOGRAPH
    {0x9583, 0x7236}, //3024 #CJK UNIFIED IDEOGRAPH
    {0x9584, 0x7B26}, //3025 #CJK UNIFIED IDEOGRAPH
    {0x9585, 0x8150}, //3026 #CJK UNIFIED IDEOGRAPH
    {0x9586, 0x819A}, //3027 #CJK UNIFIED IDEOGRAPH
    {0x9587, 0x8299}, //3028 #CJK UNIFIED IDEOGRAPH
    {0x9588, 0x8B5C}, //3029 #CJK UNIFIED IDEOGRAPH
    {0x9589, 0x8CA0}, //3030 #CJK UNIFIED IDEOGRAPH
    {0x958A, 0x8CE6}, //3031 #CJK UNIFIED IDEOGRAPH
    {0x958B, 0x8D74}, //3032 #CJK UNIFIED IDEOGRAPH
    {0x958C, 0x961C}, //3033 #CJK UNIFIED IDEOGRAPH
    {0x958D, 0x9644}, //3034 #CJK UNIFIED IDEOGRAPH
    {0x958E, 0x4FAE}, //3035 #CJK UNIFIED IDEOGRAPH
    {0x958F, 0x64AB}, //3036 #CJK UNIFIED IDEOGRAPH
    {0x9590, 0x6B66}, //3037 #CJK UNIFIED IDEOGRAPH
    {0x9591, 0x821E}, //3038 #CJK UNIFIED IDEOGRAPH
    {0x9592, 0x8461}, //3039 #CJK UNIFIED IDEOGRAPH
    {0x9593, 0x856A}, //3040 #CJK UNIFIED IDEOGRAPH
    {0x9594, 0x90E8}, //3041 #CJK UNIFIED IDEOGRAPH
    {0x9595, 0x5C01}, //3042 #CJK UNIFIED IDEOGRAPH
    {0x9596, 0x6953}, //3043 #CJK UNIFIED IDEOGRAPH
    {0x9597, 0x98A8}, //3044 #CJK UNIFIED IDEOGRAPH
    {0x9598, 0x847A}, //3045 #CJK UNIFIED IDEOGRAPH
    {0x9599, 0x8557}, //3046 #CJK UNIFIED IDEOGRAPH
    {0x959A, 0x4F0F}, //3047 #CJK UNIFIED IDEOGRAPH
    {0x959B, 0x526F}, //3048 #CJK UNIFIED IDEOGRAPH
    {0x959C, 0x5FA9}, //3049 #CJK UNIFIED IDEOGRAPH
    {0x959D, 0x5E45}, //3050 #CJK UNIFIED IDEOGRAPH
    {0x959E, 0x670D}, //3051 #CJK UNIFIED IDEOGRAPH
    {0x959F, 0x798F}, //3052 #CJK UNIFIED IDEOGRAPH
    {0x95A0, 0x8179}, //3053 #CJK UNIFIED IDEOGRAPH
    {0x95A1, 0x8907}, //3054 #CJK UNIFIED IDEOGRAPH
    {0x95A2, 0x8986}, //3055 #CJK UNIFIED IDEOGRAPH
    {0x95A3, 0x6DF5}, //3056 #CJK UNIFIED IDEOGRAPH
    {0x95A4, 0x5F17}, //3057 #CJK UNIFIED IDEOGRAPH
    {0x95A5, 0x6255}, //3058 #CJK UNIFIED IDEOGRAPH
    {0x95A6, 0x6CB8}, //3059 #CJK UNIFIED IDEOGRAPH
    {0x95A7, 0x4ECF}, //3060 #CJK UNIFIED IDEOGRAPH
    {0x95A8, 0x7269}, //3061 #CJK UNIFIED IDEOGRAPH
    {0x95A9, 0x9B92}, //3062 #CJK UNIFIED IDEOGRAPH
    {0x95AA, 0x5206}, //3063 #CJK UNIFIED IDEOGRAPH
    {0x95AB, 0x543B}, //3064 #CJK UNIFIED IDEOGRAPH
    {0x95AC, 0x5674}, //3065 #CJK UNIFIED IDEOGRAPH
    {0x95AD, 0x58B3}, //3066 #CJK UNIFIED IDEOGRAPH
    {0x95AE, 0x61A4}, //3067 #CJK UNIFIED IDEOGRAPH
    {0x95AF, 0x626E}, //3068 #CJK UNIFIED IDEOGRAPH
    {0x95B0, 0x711A}, //3069 #CJK UNIFIED IDEOGRAPH
    {0x95B1, 0x596E}, //3070 #CJK UNIFIED IDEOGRAPH
    {0x95B2, 0x7C89}, //3071 #CJK UNIFIED IDEOGRAPH
    {0x95B3, 0x7CDE}, //3072 #CJK UNIFIED IDEOGRAPH
    {0x95B4, 0x7D1B}, //3073 #CJK UNIFIED IDEOGRAPH
    {0x95B5, 0x96F0}, //3074 #CJK UNIFIED IDEOGRAPH
    {0x95B6, 0x6587}, //3075 #CJK UNIFIED IDEOGRAPH
    {0x95B7, 0x805E}, //3076 #CJK UNIFIED IDEOGRAPH
    {0x95B8, 0x4E19}, //3077 #CJK UNIFIED IDEOGRAPH
    {0x95B9, 0x4F75}, //3078 #CJK UNIFIED IDEOGRAPH
    {0x95BA, 0x5175}, //3079 #CJK UNIFIED IDEOGRAPH
    {0x95BB, 0x5840}, //3080 #CJK UNIFIED IDEOGRAPH
    {0x95BC, 0x5E63}, //3081 #CJK UNIFIED IDEOGRAPH
    {0x95BD, 0x5E73}, //3082 #CJK UNIFIED IDEOGRAPH
    {0x95BE, 0x5F0A}, //3083 #CJK UNIFIED IDEOGRAPH
    {0x95BF, 0x67C4}, //3084 #CJK UNIFIED IDEOGRAPH
    {0x95C0, 0x4E26}, //3085 #CJK UNIFIED IDEOGRAPH
    {0x95C1, 0x853D}, //3086 #CJK UNIFIED IDEOGRAPH
    {0x95C2, 0x9589}, //3087 #CJK UNIFIED IDEOGRAPH
    {0x95C3, 0x965B}, //3088 #CJK UNIFIED IDEOGRAPH
    {0x95C4, 0x7C73}, //3089 #CJK UNIFIED IDEOGRAPH
    {0x95C5, 0x9801}, //3090 #CJK UNIFIED IDEOGRAPH
    {0x95C6, 0x50FB}, //3091 #CJK UNIFIED IDEOGRAPH
    {0x95C7, 0x58C1}, //3092 #CJK UNIFIED IDEOGRAPH
    {0x95C8, 0x7656}, //3093 #CJK UNIFIED IDEOGRAPH
    {0x95C9, 0x78A7}, //3094 #CJK UNIFIED IDEOGRAPH
    {0x95CA, 0x5225}, //3095 #CJK UNIFIED IDEOGRAPH
    {0x95CB, 0x77A5}, //3096 #CJK UNIFIED IDEOGRAPH
    {0x95CC, 0x8511}, //3097 #CJK UNIFIED IDEOGRAPH
    {0x95CD, 0x7B86}, //3098 #CJK UNIFIED IDEOGRAPH
    {0x95CE, 0x504F}, //3099 #CJK UNIFIED IDEOGRAPH
    {0x95CF, 0x5909}, //3100 #CJK UNIFIED IDEOGRAPH
    {0x95D0, 0x7247}, //3101 #CJK UNIFIED IDEOGRAPH
    {0x95D1, 0x7BC7}, //3102 #CJK UNIFIED IDEOGRAPH
    {0x95D2, 0x7DE8}, //3103 #CJK UNIFIED IDEOGRAPH
    {0x95D3, 0x8FBA}, //3104 #CJK UNIFIED IDEOGRAPH
    {0x95D4, 0x8FD4}, //3105 #CJK UNIFIED IDEOGRAPH
    {0x95D5, 0x904D}, //3106 #CJK UNIFIED IDEOGRAPH
    {0x95D6, 0x4FBF}, //3107 #CJK UNIFIED IDEOGRAPH
    {0x95D7, 0x52C9}, //3108 #CJK UNIFIED IDEOGRAPH
    {0x95D8, 0x5A29}, //3109 #CJK UNIFIED IDEOGRAPH
    {0x95D9, 0x5F01}, //3110 #CJK UNIFIED IDEOGRAPH
    {0x95DA, 0x97AD}, //3111 #CJK UNIFIED IDEOGRAPH
    {0x95DB, 0x4FDD}, //3112 #CJK UNIFIED IDEOGRAPH
    {0x95DC, 0x8217}, //3113 #CJK UNIFIED IDEOGRAPH
    {0x95DD, 0x92EA}, //3114 #CJK UNIFIED IDEOGRAPH
    {0x95DE, 0x5703}, //3115 #CJK UNIFIED IDEOGRAPH
    {0x95DF, 0x6355}, //3116 #CJK UNIFIED IDEOGRAPH
    {0x95E0, 0x6B69}, //3117 #CJK UNIFIED IDEOGRAPH
    {0x95E1, 0x752B}, //3118 #CJK UNIFIED IDEOGRAPH
    {0x95E2, 0x88DC}, //3119 #CJK UNIFIED IDEOGRAPH
    {0x95E3, 0x8F14}, //3120 #CJK UNIFIED IDEOGRAPH
    {0x95E4, 0x7A42}, //3121 #CJK UNIFIED IDEOGRAPH
    {0x95E5, 0x52DF}, //3122 #CJK UNIFIED IDEOGRAPH
    {0x95E6, 0x5893}, //3123 #CJK UNIFIED IDEOGRAPH
    {0x95E7, 0x6155}, //3124 #CJK UNIFIED IDEOGRAPH
    {0x95E8, 0x620A}, //3125 #CJK UNIFIED IDEOGRAPH
    {0x95E9, 0x66AE}, //3126 #CJK UNIFIED IDEOGRAPH
    {0x95EA, 0x6BCD}, //3127 #CJK UNIFIED IDEOGRAPH
    {0x95EB, 0x7C3F}, //3128 #CJK UNIFIED IDEOGRAPH
    {0x95EC, 0x83E9}, //3129 #CJK UNIFIED IDEOGRAPH
    {0x95ED, 0x5023}, //3130 #CJK UNIFIED IDEOGRAPH
    {0x95EE, 0x4FF8}, //3131 #CJK UNIFIED IDEOGRAPH
    {0x95EF, 0x5305}, //3132 #CJK UNIFIED IDEOGRAPH
    {0x95F0, 0x5446}, //3133 #CJK UNIFIED IDEOGRAPH
    {0x95F1, 0x5831}, //3134 #CJK UNIFIED IDEOGRAPH
    {0x95F2, 0x5949}, //3135 #CJK UNIFIED IDEOGRAPH
    {0x95F3, 0x5B9D}, //3136 #CJK UNIFIED IDEOGRAPH
    {0x95F4, 0x5CF0}, //3137 #CJK UNIFIED IDEOGRAPH
    {0x95F5, 0x5CEF}, //3138 #CJK UNIFIED IDEOGRAPH
    {0x95F6, 0x5D29}, //3139 #CJK UNIFIED IDEOGRAPH
    {0x95F7, 0x5E96}, //3140 #CJK UNIFIED IDEOGRAPH
    {0x95F8, 0x62B1}, //3141 #CJK UNIFIED IDEOGRAPH
    {0x95F9, 0x6367}, //3142 #CJK UNIFIED IDEOGRAPH
    {0x95FA, 0x653E}, //3143 #CJK UNIFIED IDEOGRAPH
    {0x95FB, 0x65B9}, //3144 #CJK UNIFIED IDEOGRAPH
    {0x95FC, 0x670B}, //3145 #CJK UNIFIED IDEOGRAPH
    {0x9640, 0x6CD5}, //3146 #CJK UNIFIED IDEOGRAPH
    {0x9641, 0x6CE1}, //3147 #CJK UNIFIED IDEOGRAPH
    {0x9642, 0x70F9}, //3148 #CJK UNIFIED IDEOGRAPH
    {0x9643, 0x7832}, //3149 #CJK UNIFIED IDEOGRAPH
    {0x9644, 0x7E2B}, //3150 #CJK UNIFIED IDEOGRAPH
    {0x9645, 0x80DE}, //3151 #CJK UNIFIED IDEOGRAPH
    {0x9646, 0x82B3}, //3152 #CJK UNIFIED IDEOGRAPH
    {0x9647, 0x840C}, //3153 #CJK UNIFIED IDEOGRAPH
    {0x9648, 0x84EC}, //3154 #CJK UNIFIED IDEOGRAPH
    {0x9649, 0x8702}, //3155 #CJK UNIFIED IDEOGRAPH
    {0x964A, 0x8912}, //3156 #CJK UNIFIED IDEOGRAPH
    {0x964B, 0x8A2A}, //3157 #CJK UNIFIED IDEOGRAPH
    {0x964C, 0x8C4A}, //3158 #CJK UNIFIED IDEOGRAPH
    {0x964D, 0x90A6}, //3159 #CJK UNIFIED IDEOGRAPH
    {0x964E, 0x92D2}, //3160 #CJK UNIFIED IDEOGRAPH
    {0x964F, 0x98FD}, //3161 #CJK UNIFIED IDEOGRAPH
    {0x9650, 0x9CF3}, //3162 #CJK UNIFIED IDEOGRAPH
    {0x9651, 0x9D6C}, //3163 #CJK UNIFIED IDEOGRAPH
    {0x9652, 0x4E4F}, //3164 #CJK UNIFIED IDEOGRAPH
    {0x9653, 0x4EA1}, //3165 #CJK UNIFIED IDEOGRAPH
    {0x9654, 0x508D}, //3166 #CJK UNIFIED IDEOGRAPH
    {0x9655, 0x5256}, //3167 #CJK UNIFIED IDEOGRAPH
    {0x9656, 0x574A}, //3168 #CJK UNIFIED IDEOGRAPH
    {0x9657, 0x59A8}, //3169 #CJK UNIFIED IDEOGRAPH
    {0x9658, 0x5E3D}, //3170 #CJK UNIFIED IDEOGRAPH
    {0x9659, 0x5FD8}, //3171 #CJK UNIFIED IDEOGRAPH
    {0x965A, 0x5FD9}, //3172 #CJK UNIFIED IDEOGRAPH
    {0x965B, 0x623F}, //3173 #CJK UNIFIED IDEOGRAPH
    {0x965C, 0x66B4}, //3174 #CJK UNIFIED IDEOGRAPH
    {0x965D, 0x671B}, //3175 #CJK UNIFIED IDEOGRAPH
    {0x965E, 0x67D0}, //3176 #CJK UNIFIED IDEOGRAPH
    {0x965F, 0x68D2}, //3177 #CJK UNIFIED IDEOGRAPH
    {0x9660, 0x5192}, //3178 #CJK UNIFIED IDEOGRAPH
    {0x9661, 0x7D21}, //3179 #CJK UNIFIED IDEOGRAPH
    {0x9662, 0x80AA}, //3180 #CJK UNIFIED IDEOGRAPH
    {0x9663, 0x81A8}, //3181 #CJK UNIFIED IDEOGRAPH
    {0x9664, 0x8B00}, //3182 #CJK UNIFIED IDEOGRAPH
    {0x9665, 0x8C8C}, //3183 #CJK UNIFIED IDEOGRAPH
    {0x9666, 0x8CBF}, //3184 #CJK UNIFIED IDEOGRAPH
    {0x9667, 0x927E}, //3185 #CJK UNIFIED IDEOGRAPH
    {0x9668, 0x9632}, //3186 #CJK UNIFIED IDEOGRAPH
    {0x9669, 0x5420}, //3187 #CJK UNIFIED IDEOGRAPH
    {0x966A, 0x982C}, //3188 #CJK UNIFIED IDEOGRAPH
    {0x966B, 0x5317}, //3189 #CJK UNIFIED IDEOGRAPH
    {0x966C, 0x50D5}, //3190 #CJK UNIFIED IDEOGRAPH
    {0x966D, 0x535C}, //3191 #CJK UNIFIED IDEOGRAPH
    {0x966E, 0x58A8}, //3192 #CJK UNIFIED IDEOGRAPH
    {0x966F, 0x64B2}, //3193 #CJK UNIFIED IDEOGRAPH
    {0x9670, 0x6734}, //3194 #CJK UNIFIED IDEOGRAPH
    {0x9671, 0x7267}, //3195 #CJK UNIFIED IDEOGRAPH
    {0x9672, 0x7766}, //3196 #CJK UNIFIED IDEOGRAPH
    {0x9673, 0x7A46}, //3197 #CJK UNIFIED IDEOGRAPH
    {0x9674, 0x91E6}, //3198 #CJK UNIFIED IDEOGRAPH
    {0x9675, 0x52C3}, //3199 #CJK UNIFIED IDEOGRAPH
    {0x9676, 0x6CA1}, //3200 #CJK UNIFIED IDEOGRAPH
    {0x9677, 0x6B86}, //3201 #CJK UNIFIED IDEOGRAPH
    {0x9678, 0x5800}, //3202 #CJK UNIFIED IDEOGRAPH
    {0x9679, 0x5E4C}, //3203 #CJK UNIFIED IDEOGRAPH
    {0x967A, 0x5954}, //3204 #CJK UNIFIED IDEOGRAPH
    {0x967B, 0x672C}, //3205 #CJK UNIFIED IDEOGRAPH
    {0x967C, 0x7FFB}, //3206 #CJK UNIFIED IDEOGRAPH
    {0x967D, 0x51E1}, //3207 #CJK UNIFIED IDEOGRAPH
    {0x967E, 0x76C6}, //3208 #CJK UNIFIED IDEOGRAPH
    {0x9680, 0x6469}, //3209 #CJK UNIFIED IDEOGRAPH
    {0x9681, 0x78E8}, //3210 #CJK UNIFIED IDEOGRAPH
    {0x9682, 0x9B54}, //3211 #CJK UNIFIED IDEOGRAPH
    {0x9683, 0x9EBB}, //3212 #CJK UNIFIED IDEOGRAPH
    {0x9684, 0x57CB}, //3213 #CJK UNIFIED IDEOGRAPH
    {0x9685, 0x59B9}, //3214 #CJK UNIFIED IDEOGRAPH
    {0x9686, 0x6627}, //3215 #CJK UNIFIED IDEOGRAPH
    {0x9687, 0x679A}, //3216 #CJK UNIFIED IDEOGRAPH
    {0x9688, 0x6BCE}, //3217 #CJK UNIFIED IDEOGRAPH
    {0x9689, 0x54E9}, //3218 #CJK UNIFIED IDEOGRAPH
    {0x968A, 0x69D9}, //3219 #CJK UNIFIED IDEOGRAPH
    {0x968B, 0x5E55}, //3220 #CJK UNIFIED IDEOGRAPH
    {0x968C, 0x819C}, //3221 #CJK UNIFIED IDEOGRAPH
    {0x968D, 0x6795}, //3222 #CJK UNIFIED IDEOGRAPH
    {0x968E, 0x9BAA}, //3223 #CJK UNIFIED IDEOGRAPH
    {0x968F, 0x67FE}, //3224 #CJK UNIFIED IDEOGRAPH
    {0x9690, 0x9C52}, //3225 #CJK UNIFIED IDEOGRAPH
    {0x9691, 0x685D}, //3226 #CJK UNIFIED IDEOGRAPH
    {0x9692, 0x4EA6}, //3227 #CJK UNIFIED IDEOGRAPH
    {0x9693, 0x4FE3}, //3228 #CJK UNIFIED IDEOGRAPH
    {0x9694, 0x53C8}, //3229 #CJK UNIFIED IDEOGRAPH
    {0x9695, 0x62B9}, //3230 #CJK UNIFIED IDEOGRAPH
    {0x9696, 0x672B}, //3231 #CJK UNIFIED IDEOGRAPH
    {0x9697, 0x6CAB}, //3232 #CJK UNIFIED IDEOGRAPH
    {0x9698, 0x8FC4}, //3233 #CJK UNIFIED IDEOGRAPH
    {0x9699, 0x4FAD}, //3234 #CJK UNIFIED IDEOGRAPH
    {0x969A, 0x7E6D}, //3235 #CJK UNIFIED IDEOGRAPH
    {0x969B, 0x9EBF}, //3236 #CJK UNIFIED IDEOGRAPH
    {0x969C, 0x4E07}, //3237 #CJK UNIFIED IDEOGRAPH
    {0x969D, 0x6162}, //3238 #CJK UNIFIED IDEOGRAPH
    {0x969E, 0x6E80}, //3239 #CJK UNIFIED IDEOGRAPH
    {0x969F, 0x6F2B}, //3240 #CJK UNIFIED IDEOGRAPH
    {0x96A0, 0x8513}, //3241 #CJK UNIFIED IDEOGRAPH
    {0x96A1, 0x5473}, //3242 #CJK UNIFIED IDEOGRAPH
    {0x96A2, 0x672A}, //3243 #CJK UNIFIED IDEOGRAPH
    {0x96A3, 0x9B45}, //3244 #CJK UNIFIED IDEOGRAPH
    {0x96A4, 0x5DF3}, //3245 #CJK UNIFIED IDEOGRAPH
    {0x96A5, 0x7B95}, //3246 #CJK UNIFIED IDEOGRAPH
    {0x96A6, 0x5CAC}, //3247 #CJK UNIFIED IDEOGRAPH
    {0x96A7, 0x5BC6}, //3248 #CJK UNIFIED IDEOGRAPH
    {0x96A8, 0x871C}, //3249 #CJK UNIFIED IDEOGRAPH
    {0x96A9, 0x6E4A}, //3250 #CJK UNIFIED IDEOGRAPH
    {0x96AA, 0x84D1}, //3251 #CJK UNIFIED IDEOGRAPH
    {0x96AB, 0x7A14}, //3252 #CJK UNIFIED IDEOGRAPH
    {0x96AC, 0x8108}, //3253 #CJK UNIFIED IDEOGRAPH
    {0x96AD, 0x5999}, //3254 #CJK UNIFIED IDEOGRAPH
    {0x96AE, 0x7C8D}, //3255 #CJK UNIFIED IDEOGRAPH
    {0x96AF, 0x6C11}, //3256 #CJK UNIFIED IDEOGRAPH
    {0x96B0, 0x7720}, //3257 #CJK UNIFIED IDEOGRAPH
    {0x96B1, 0x52D9}, //3258 #CJK UNIFIED IDEOGRAPH
    {0x96B2, 0x5922}, //3259 #CJK UNIFIED IDEOGRAPH
    {0x96B3, 0x7121}, //3260 #CJK UNIFIED IDEOGRAPH
    {0x96B4, 0x725F}, //3261 #CJK UNIFIED IDEOGRAPH
    {0x96B5, 0x77DB}, //3262 #CJK UNIFIED IDEOGRAPH
    {0x96B6, 0x9727}, //3263 #CJK UNIFIED IDEOGRAPH
    {0x96B7, 0x9D61}, //3264 #CJK UNIFIED IDEOGRAPH
    {0x96B8, 0x690B}, //3265 #CJK UNIFIED IDEOGRAPH
    {0x96B9, 0x5A7F}, //3266 #CJK UNIFIED IDEOGRAPH
    {0x96BA, 0x5A18}, //3267 #CJK UNIFIED IDEOGRAPH
    {0x96BB, 0x51A5}, //3268 #CJK UNIFIED IDEOGRAPH
    {0x96BC, 0x540D}, //3269 #CJK UNIFIED IDEOGRAPH
    {0x96BD, 0x547D}, //3270 #CJK UNIFIED IDEOGRAPH
    {0x96BE, 0x660E}, //3271 #CJK UNIFIED IDEOGRAPH
    {0x96BF, 0x76DF}, //3272 #CJK UNIFIED IDEOGRAPH
    {0x96C0, 0x8FF7}, //3273 #CJK UNIFIED IDEOGRAPH
    {0x96C1, 0x9298}, //3274 #CJK UNIFIED IDEOGRAPH
    {0x96C2, 0x9CF4}, //3275 #CJK UNIFIED IDEOGRAPH
    {0x96C3, 0x59EA}, //3276 #CJK UNIFIED IDEOGRAPH
    {0x96C4, 0x725D}, //3277 #CJK UNIFIED IDEOGRAPH
    {0x96C5, 0x6EC5}, //3278 #CJK UNIFIED IDEOGRAPH
    {0x96C6, 0x514D}, //3279 #CJK UNIFIED IDEOGRAPH
    {0x96C7, 0x68C9}, //3280 #CJK UNIFIED IDEOGRAPH
    {0x96C8, 0x7DBF}, //3281 #CJK UNIFIED IDEOGRAPH
    {0x96C9, 0x7DEC}, //3282 #CJK UNIFIED IDEOGRAPH
    {0x96CA, 0x9762}, //3283 #CJK UNIFIED IDEOGRAPH
    {0x96CB, 0x9EBA}, //3284 #CJK UNIFIED IDEOGRAPH
    {0x96CC, 0x6478}, //3285 #CJK UNIFIED IDEOGRAPH
    {0x96CD, 0x6A21}, //3286 #CJK UNIFIED IDEOGRAPH
    {0x96CE, 0x8302}, //3287 #CJK UNIFIED IDEOGRAPH
    {0x96CF, 0x5984}, //3288 #CJK UNIFIED IDEOGRAPH
    {0x96D0, 0x5B5F}, //3289 #CJK UNIFIED IDEOGRAPH
    {0x96D1, 0x6BDB}, //3290 #CJK UNIFIED IDEOGRAPH
    {0x96D2, 0x731B}, //3291 #CJK UNIFIED IDEOGRAPH
    {0x96D3, 0x76F2}, //3292 #CJK UNIFIED IDEOGRAPH
    {0x96D4, 0x7DB2}, //3293 #CJK UNIFIED IDEOGRAPH
    {0x96D5, 0x8017}, //3294 #CJK UNIFIED IDEOGRAPH
    {0x96D6, 0x8499}, //3295 #CJK UNIFIED IDEOGRAPH
    {0x96D7, 0x5132}, //3296 #CJK UNIFIED IDEOGRAPH
    {0x96D8, 0x6728}, //3297 #CJK UNIFIED IDEOGRAPH
    {0x96D9, 0x9ED9}, //3298 #CJK UNIFIED IDEOGRAPH
    {0x96DA, 0x76EE}, //3299 #CJK UNIFIED IDEOGRAPH
    {0x96DB, 0x6762}, //3300 #CJK UNIFIED IDEOGRAPH
    {0x96DC, 0x52FF}, //3301 #CJK UNIFIED IDEOGRAPH
    {0x96DD, 0x9905}, //3302 #CJK UNIFIED IDEOGRAPH
    {0x96DE, 0x5C24}, //3303 #CJK UNIFIED IDEOGRAPH
    {0x96DF, 0x623B}, //3304 #CJK UNIFIED IDEOGRAPH
    {0x96E0, 0x7C7E}, //3305 #CJK UNIFIED IDEOGRAPH
    {0x96E1, 0x8CB0}, //3306 #CJK UNIFIED IDEOGRAPH
    {0x96E2, 0x554F}, //3307 #CJK UNIFIED IDEOGRAPH
    {0x96E3, 0x60B6}, //3308 #CJK UNIFIED IDEOGRAPH
    {0x96E4, 0x7D0B}, //3309 #CJK UNIFIED IDEOGRAPH
    {0x96E5, 0x9580}, //3310 #CJK UNIFIED IDEOGRAPH
    {0x96E6, 0x5301}, //3311 #CJK UNIFIED IDEOGRAPH
    {0x96E7, 0x4E5F}, //3312 #CJK UNIFIED IDEOGRAPH
    {0x96E8, 0x51B6}, //3313 #CJK UNIFIED IDEOGRAPH
    {0x96E9, 0x591C}, //3314 #CJK UNIFIED IDEOGRAPH
    {0x96EA, 0x723A}, //3315 #CJK UNIFIED IDEOGRAPH
    {0x96EB, 0x8036}, //3316 #CJK UNIFIED IDEOGRAPH
    {0x96EC, 0x91CE}, //3317 #CJK UNIFIED IDEOGRAPH
    {0x96ED, 0x5F25}, //3318 #CJK UNIFIED IDEOGRAPH
    {0x96EE, 0x77E2}, //3319 #CJK UNIFIED IDEOGRAPH
    {0x96EF, 0x5384}, //3320 #CJK UNIFIED IDEOGRAPH
    {0x96F0, 0x5F79}, //3321 #CJK UNIFIED IDEOGRAPH
    {0x96F1, 0x7D04}, //3322 #CJK UNIFIED IDEOGRAPH
    {0x96F2, 0x85AC}, //3323 #CJK UNIFIED IDEOGRAPH
    {0x96F3, 0x8A33}, //3324 #CJK UNIFIED IDEOGRAPH
    {0x96F4, 0x8E8D}, //3325 #CJK UNIFIED IDEOGRAPH
    {0x96F5, 0x9756}, //3326 #CJK UNIFIED IDEOGRAPH
    {0x96F6, 0x67F3}, //3327 #CJK UNIFIED IDEOGRAPH
    {0x96F7, 0x85AE}, //3328 #CJK UNIFIED IDEOGRAPH
    {0x96F8, 0x9453}, //3329 #CJK UNIFIED IDEOGRAPH
    {0x96F9, 0x6109}, //3330 #CJK UNIFIED IDEOGRAPH
    {0x96FA, 0x6108}, //3331 #CJK UNIFIED IDEOGRAPH
    {0x96FB, 0x6CB9}, //3332 #CJK UNIFIED IDEOGRAPH
    {0x96FC, 0x7652}, //3333 #CJK UNIFIED IDEOGRAPH
    {0x9740, 0x8AED}, //3334 #CJK UNIFIED IDEOGRAPH
    {0x9741, 0x8F38}, //3335 #CJK UNIFIED IDEOGRAPH
    {0x9742, 0x552F}, //3336 #CJK UNIFIED IDEOGRAPH
    {0x9743, 0x4F51}, //3337 #CJK UNIFIED IDEOGRAPH
    {0x9744, 0x512A}, //3338 #CJK UNIFIED IDEOGRAPH
    {0x9745, 0x52C7}, //3339 #CJK UNIFIED IDEOGRAPH
    {0x9746, 0x53CB}, //3340 #CJK UNIFIED IDEOGRAPH
    {0x9747, 0x5BA5}, //3341 #CJK UNIFIED IDEOGRAPH
    {0x9748, 0x5E7D}, //3342 #CJK UNIFIED IDEOGRAPH
    {0x9749, 0x60A0}, //3343 #CJK UNIFIED IDEOGRAPH
    {0x974A, 0x6182}, //3344 #CJK UNIFIED IDEOGRAPH
    {0x974B, 0x63D6}, //3345 #CJK UNIFIED IDEOGRAPH
    {0x974C, 0x6709}, //3346 #CJK UNIFIED IDEOGRAPH
    {0x974D, 0x67DA}, //3347 #CJK UNIFIED IDEOGRAPH
    {0x974E, 0x6E67}, //3348 #CJK UNIFIED IDEOGRAPH
    {0x974F, 0x6D8C}, //3349 #CJK UNIFIED IDEOGRAPH
    {0x9750, 0x7336}, //3350 #CJK UNIFIED IDEOGRAPH
    {0x9751, 0x7337}, //3351 #CJK UNIFIED IDEOGRAPH
    {0x9752, 0x7531}, //3352 #CJK UNIFIED IDEOGRAPH
    {0x9753, 0x7950}, //3353 #CJK UNIFIED IDEOGRAPH
    {0x9754, 0x88D5}, //3354 #CJK UNIFIED IDEOGRAPH
    {0x9755, 0x8A98}, //3355 #CJK UNIFIED IDEOGRAPH
    {0x9756, 0x904A}, //3356 #CJK UNIFIED IDEOGRAPH
    {0x9757, 0x9091}, //3357 #CJK UNIFIED IDEOGRAPH
    {0x9758, 0x90F5}, //3358 #CJK UNIFIED IDEOGRAPH
    {0x9759, 0x96C4}, //3359 #CJK UNIFIED IDEOGRAPH
    {0x975A, 0x878D}, //3360 #CJK UNIFIED IDEOGRAPH
    {0x975B, 0x5915}, //3361 #CJK UNIFIED IDEOGRAPH
    {0x975C, 0x4E88}, //3362 #CJK UNIFIED IDEOGRAPH
    {0x975D, 0x4F59}, //3363 #CJK UNIFIED IDEOGRAPH
    {0x975E, 0x4E0E}, //3364 #CJK UNIFIED IDEOGRAPH
    {0x975F, 0x8A89}, //3365 #CJK UNIFIED IDEOGRAPH
    {0x9760, 0x8F3F}, //3366 #CJK UNIFIED IDEOGRAPH
    {0x9761, 0x9810}, //3367 #CJK UNIFIED IDEOGRAPH
    {0x9762, 0x50AD}, //3368 #CJK UNIFIED IDEOGRAPH
    {0x9763, 0x5E7C}, //3369 #CJK UNIFIED IDEOGRAPH
    {0x9764, 0x5996}, //3370 #CJK UNIFIED IDEOGRAPH
    {0x9765, 0x5BB9}, //3371 #CJK UNIFIED IDEOGRAPH
    {0x9766, 0x5EB8}, //3372 #CJK UNIFIED IDEOGRAPH
    {0x9767, 0x63DA}, //3373 #CJK UNIFIED IDEOGRAPH
    {0x9768, 0x63FA}, //3374 #CJK UNIFIED IDEOGRAPH
    {0x9769, 0x64C1}, //3375 #CJK UNIFIED IDEOGRAPH
    {0x976A, 0x66DC}, //3376 #CJK UNIFIED IDEOGRAPH
    {0x976B, 0x694A}, //3377 #CJK UNIFIED IDEOGRAPH
    {0x976C, 0x69D8}, //3378 #CJK UNIFIED IDEOGRAPH
    {0x976D, 0x6D0B}, //3379 #CJK UNIFIED IDEOGRAPH
    {0x976E, 0x6EB6}, //3380 #CJK UNIFIED IDEOGRAPH
    {0x976F, 0x7194}, //3381 #CJK UNIFIED IDEOGRAPH
    {0x9770, 0x7528}, //3382 #CJK UNIFIED IDEOGRAPH
    {0x9771, 0x7AAF}, //3383 #CJK UNIFIED IDEOGRAPH
    {0x9772, 0x7F8A}, //3384 #CJK UNIFIED IDEOGRAPH
    {0x9773, 0x8000}, //3385 #CJK UNIFIED IDEOGRAPH
    {0x9774, 0x8449}, //3386 #CJK UNIFIED IDEOGRAPH
    {0x9775, 0x84C9}, //3387 #CJK UNIFIED IDEOGRAPH
    {0x9776, 0x8981}, //3388 #CJK UNIFIED IDEOGRAPH
    {0x9777, 0x8B21}, //3389 #CJK UNIFIED IDEOGRAPH
    {0x9778, 0x8E0A}, //3390 #CJK UNIFIED IDEOGRAPH
    {0x9779, 0x9065}, //3391 #CJK UNIFIED IDEOGRAPH
    {0x977A, 0x967D}, //3392 #CJK UNIFIED IDEOGRAPH
    {0x977B, 0x990A}, //3393 #CJK UNIFIED IDEOGRAPH
    {0x977C, 0x617E}, //3394 #CJK UNIFIED IDEOGRAPH
    {0x977D, 0x6291}, //3395 #CJK UNIFIED IDEOGRAPH
    {0x977E, 0x6B32}, //3396 #CJK UNIFIED IDEOGRAPH
    {0x9780, 0x6C83}, //3397 #CJK UNIFIED IDEOGRAPH
    {0x9781, 0x6D74}, //3398 #CJK UNIFIED IDEOGRAPH
    {0x9782, 0x7FCC}, //3399 #CJK UNIFIED IDEOGRAPH
    {0x9783, 0x7FFC}, //3400 #CJK UNIFIED IDEOGRAPH
    {0x9784, 0x6DC0}, //3401 #CJK UNIFIED IDEOGRAPH
    {0x9785, 0x7F85}, //3402 #CJK UNIFIED IDEOGRAPH
    {0x9786, 0x87BA}, //3403 #CJK UNIFIED IDEOGRAPH
    {0x9787, 0x88F8}, //3404 #CJK UNIFIED IDEOGRAPH
    {0x9788, 0x6765}, //3405 #CJK UNIFIED IDEOGRAPH
    {0x9789, 0x83B1}, //3406 #CJK UNIFIED IDEOGRAPH
    {0x978A, 0x983C}, //3407 #CJK UNIFIED IDEOGRAPH
    {0x978B, 0x96F7}, //3408 #CJK UNIFIED IDEOGRAPH
    {0x978C, 0x6D1B}, //3409 #CJK UNIFIED IDEOGRAPH
    {0x978D, 0x7D61}, //3410 #CJK UNIFIED IDEOGRAPH
    {0x978E, 0x843D}, //3411 #CJK UNIFIED IDEOGRAPH
    {0x978F, 0x916A}, //3412 #CJK UNIFIED IDEOGRAPH
    {0x9790, 0x4E71}, //3413 #CJK UNIFIED IDEOGRAPH
    {0x9791, 0x5375}, //3414 #CJK UNIFIED IDEOGRAPH
    {0x9792, 0x5D50}, //3415 #CJK UNIFIED IDEOGRAPH
    {0x9793, 0x6B04}, //3416 #CJK UNIFIED IDEOGRAPH
    {0x9794, 0x6FEB}, //3417 #CJK UNIFIED IDEOGRAPH
    {0x9795, 0x85CD}, //3418 #CJK UNIFIED IDEOGRAPH
    {0x9796, 0x862D}, //3419 #CJK UNIFIED IDEOGRAPH
    {0x9797, 0x89A7}, //3420 #CJK UNIFIED IDEOGRAPH
    {0x9798, 0x5229}, //3421 #CJK UNIFIED IDEOGRAPH
    {0x9799, 0x540F}, //3422 #CJK UNIFIED IDEOGRAPH
    {0x979A, 0x5C65}, //3423 #CJK UNIFIED IDEOGRAPH
    {0x979B, 0x674E}, //3424 #CJK UNIFIED IDEOGRAPH
    {0x979C, 0x68A8}, //3425 #CJK UNIFIED IDEOGRAPH
    {0x979D, 0x7406}, //3426 #CJK UNIFIED IDEOGRAPH
    {0x979E, 0x7483}, //3427 #CJK UNIFIED IDEOGRAPH
    {0x979F, 0x75E2}, //3428 #CJK UNIFIED IDEOGRAPH
    {0x97A0, 0x88CF}, //3429 #CJK UNIFIED IDEOGRAPH
    {0x97A1, 0x88E1}, //3430 #CJK UNIFIED IDEOGRAPH
    {0x97A2, 0x91CC}, //3431 #CJK UNIFIED IDEOGRAPH
    {0x97A3, 0x96E2}, //3432 #CJK UNIFIED IDEOGRAPH
    {0x97A4, 0x9678}, //3433 #CJK UNIFIED IDEOGRAPH
    {0x97A5, 0x5F8B}, //3434 #CJK UNIFIED IDEOGRAPH
    {0x97A6, 0x7387}, //3435 #CJK UNIFIED IDEOGRAPH
    {0x97A7, 0x7ACB}, //3436 #CJK UNIFIED IDEOGRAPH
    {0x97A8, 0x844E}, //3437 #CJK UNIFIED IDEOGRAPH
    {0x97A9, 0x63A0}, //3438 #CJK UNIFIED IDEOGRAPH
    {0x97AA, 0x7565}, //3439 #CJK UNIFIED IDEOGRAPH
    {0x97AB, 0x5289}, //3440 #CJK UNIFIED IDEOGRAPH
    {0x97AC, 0x6D41}, //3441 #CJK UNIFIED IDEOGRAPH
    {0x97AD, 0x6E9C}, //3442 #CJK UNIFIED IDEOGRAPH
    {0x97AE, 0x7409}, //3443 #CJK UNIFIED IDEOGRAPH
    {0x97AF, 0x7559}, //3444 #CJK UNIFIED IDEOGRAPH
    {0x97B0, 0x786B}, //3445 #CJK UNIFIED IDEOGRAPH
    {0x97B1, 0x7C92}, //3446 #CJK UNIFIED IDEOGRAPH
    {0x97B2, 0x9686}, //3447 #CJK UNIFIED IDEOGRAPH
    {0x97B3, 0x7ADC}, //3448 #CJK UNIFIED IDEOGRAPH
    {0x97B4, 0x9F8D}, //3449 #CJK UNIFIED IDEOGRAPH
    {0x97B5, 0x4FB6}, //3450 #CJK UNIFIED IDEOGRAPH
    {0x97B6, 0x616E}, //3451 #CJK UNIFIED IDEOGRAPH
    {0x97B7, 0x65C5}, //3452 #CJK UNIFIED IDEOGRAPH
    {0x97B8, 0x865C}, //3453 #CJK UNIFIED IDEOGRAPH
    {0x97B9, 0x4E86}, //3454 #CJK UNIFIED IDEOGRAPH
    {0x97BA, 0x4EAE}, //3455 #CJK UNIFIED IDEOGRAPH
    {0x97BB, 0x50DA}, //3456 #CJK UNIFIED IDEOGRAPH
    {0x97BC, 0x4E21}, //3457 #CJK UNIFIED IDEOGRAPH
    {0x97BD, 0x51CC}, //3458 #CJK UNIFIED IDEOGRAPH
    {0x97BE, 0x5BEE}, //3459 #CJK UNIFIED IDEOGRAPH
    {0x97BF, 0x6599}, //3460 #CJK UNIFIED IDEOGRAPH
    {0x97C0, 0x6881}, //3461 #CJK UNIFIED IDEOGRAPH
    {0x97C1, 0x6DBC}, //3462 #CJK UNIFIED IDEOGRAPH
    {0x97C2, 0x731F}, //3463 #CJK UNIFIED IDEOGRAPH
    {0x97C3, 0x7642}, //3464 #CJK UNIFIED IDEOGRAPH
    {0x97C4, 0x77AD}, //3465 #CJK UNIFIED IDEOGRAPH
    {0x97C5, 0x7A1C}, //3466 #CJK UNIFIED IDEOGRAPH
    {0x97C6, 0x7CE7}, //3467 #CJK UNIFIED IDEOGRAPH
    {0x97C7, 0x826F}, //3468 #CJK UNIFIED IDEOGRAPH
    {0x97C8, 0x8AD2}, //3469 #CJK UNIFIED IDEOGRAPH
    {0x97C9, 0x907C}, //3470 #CJK UNIFIED IDEOGRAPH
    {0x97CA, 0x91CF}, //3471 #CJK UNIFIED IDEOGRAPH
    {0x97CB, 0x9675}, //3472 #CJK UNIFIED IDEOGRAPH
    {0x97CC, 0x9818}, //3473 #CJK UNIFIED IDEOGRAPH
    {0x97CD, 0x529B}, //3474 #CJK UNIFIED IDEOGRAPH
    {0x97CE, 0x7DD1}, //3475 #CJK UNIFIED IDEOGRAPH
    {0x97CF, 0x502B}, //3476 #CJK UNIFIED IDEOGRAPH
    {0x97D0, 0x5398}, //3477 #CJK UNIFIED IDEOGRAPH
    {0x97D1, 0x6797}, //3478 #CJK UNIFIED IDEOGRAPH
    {0x97D2, 0x6DCB}, //3479 #CJK UNIFIED IDEOGRAPH
    {0x97D3, 0x71D0}, //3480 #CJK UNIFIED IDEOGRAPH
    {0x97D4, 0x7433}, //3481 #CJK UNIFIED IDEOGRAPH
    {0x97D5, 0x81E8}, //3482 #CJK UNIFIED IDEOGRAPH
    {0x97D6, 0x8F2A}, //3483 #CJK UNIFIED IDEOGRAPH
    {0x97D7, 0x96A3}, //3484 #CJK UNIFIED IDEOGRAPH
    {0x97D8, 0x9C57}, //3485 #CJK UNIFIED IDEOGRAPH
    {0x97D9, 0x9E9F}, //3486 #CJK UNIFIED IDEOGRAPH
    {0x97DA, 0x7460}, //3487 #CJK UNIFIED IDEOGRAPH
    {0x97DB, 0x5841}, //3488 #CJK UNIFIED IDEOGRAPH
    {0x97DC, 0x6D99}, //3489 #CJK UNIFIED IDEOGRAPH
    {0x97DD, 0x7D2F}, //3490 #CJK UNIFIED IDEOGRAPH
    {0x97DE, 0x985E}, //3491 #CJK UNIFIED IDEOGRAPH
    {0x97DF, 0x4EE4}, //3492 #CJK UNIFIED IDEOGRAPH
    {0x97E0, 0x4F36}, //3493 #CJK UNIFIED IDEOGRAPH
    {0x97E1, 0x4F8B}, //3494 #CJK UNIFIED IDEOGRAPH
    {0x97E2, 0x51B7}, //3495 #CJK UNIFIED IDEOGRAPH
    {0x97E3, 0x52B1}, //3496 #CJK UNIFIED IDEOGRAPH
    {0x97E4, 0x5DBA}, //3497 #CJK UNIFIED IDEOGRAPH
    {0x97E5, 0x601C}, //3498 #CJK UNIFIED IDEOGRAPH
    {0x97E6, 0x73B2}, //3499 #CJK UNIFIED IDEOGRAPH
    {0x97E7, 0x793C}, //3500 #CJK UNIFIED IDEOGRAPH
    {0x97E8, 0x82D3}, //3501 #CJK UNIFIED IDEOGRAPH
    {0x97E9, 0x9234}, //3502 #CJK UNIFIED IDEOGRAPH
    {0x97EA, 0x96B7}, //3503 #CJK UNIFIED IDEOGRAPH
    {0x97EB, 0x96F6}, //3504 #CJK UNIFIED IDEOGRAPH
    {0x97EC, 0x970A}, //3505 #CJK UNIFIED IDEOGRAPH
    {0x97ED, 0x9E97}, //3506 #CJK UNIFIED IDEOGRAPH
    {0x97EE, 0x9F62}, //3507 #CJK UNIFIED IDEOGRAPH
    {0x97EF, 0x66A6}, //3508 #CJK UNIFIED IDEOGRAPH
    {0x97F0, 0x6B74}, //3509 #CJK UNIFIED IDEOGRAPH
    {0x97F1, 0x5217}, //3510 #CJK UNIFIED IDEOGRAPH
    {0x97F2, 0x52A3}, //3511 #CJK UNIFIED IDEOGRAPH
    {0x97F3, 0x70C8}, //3512 #CJK UNIFIED IDEOGRAPH
    {0x97F4, 0x88C2}, //3513 #CJK UNIFIED IDEOGRAPH
    {0x97F5, 0x5EC9}, //3514 #CJK UNIFIED IDEOGRAPH
    {0x97F6, 0x604B}, //3515 #CJK UNIFIED IDEOGRAPH
    {0x97F7, 0x6190}, //3516 #CJK UNIFIED IDEOGRAPH
    {0x97F8, 0x6F23}, //3517 #CJK UNIFIED IDEOGRAPH
    {0x97F9, 0x7149}, //3518 #CJK UNIFIED IDEOGRAPH
    {0x97FA, 0x7C3E}, //3519 #CJK UNIFIED IDEOGRAPH
    {0x97FB, 0x7DF4}, //3520 #CJK UNIFIED IDEOGRAPH
    {0x97FC, 0x806F}, //3521 #CJK UNIFIED IDEOGRAPH
    {0x9840, 0x84EE}, //3522 #CJK UNIFIED IDEOGRAPH
    {0x9841, 0x9023}, //3523 #CJK UNIFIED IDEOGRAPH
    {0x9842, 0x932C}, //3524 #CJK UNIFIED IDEOGRAPH
    {0x9843, 0x5442}, //3525 #CJK UNIFIED IDEOGRAPH
    {0x9844, 0x9B6F}, //3526 #CJK UNIFIED IDEOGRAPH
    {0x9845, 0x6AD3}, //3527 #CJK UNIFIED IDEOGRAPH
    {0x9846, 0x7089}, //3528 #CJK UNIFIED IDEOGRAPH
    {0x9847, 0x8CC2}, //3529 #CJK UNIFIED IDEOGRAPH
    {0x9848, 0x8DEF}, //3530 #CJK UNIFIED IDEOGRAPH
    {0x9849, 0x9732}, //3531 #CJK UNIFIED IDEOGRAPH
    {0x984A, 0x52B4}, //3532 #CJK UNIFIED IDEOGRAPH
    {0x984B, 0x5A41}, //3533 #CJK UNIFIED IDEOGRAPH
    {0x984C, 0x5ECA}, //3534 #CJK UNIFIED IDEOGRAPH
    {0x984D, 0x5F04}, //3535 #CJK UNIFIED IDEOGRAPH
    {0x984E, 0x6717}, //3536 #CJK UNIFIED IDEOGRAPH
    {0x984F, 0x697C}, //3537 #CJK UNIFIED IDEOGRAPH
    {0x9850, 0x6994}, //3538 #CJK UNIFIED IDEOGRAPH
    {0x9851, 0x6D6A}, //3539 #CJK UNIFIED IDEOGRAPH
    {0x9852, 0x6F0F}, //3540 #CJK UNIFIED IDEOGRAPH
    {0x9853, 0x7262}, //3541 #CJK UNIFIED IDEOGRAPH
    {0x9854, 0x72FC}, //3542 #CJK UNIFIED IDEOGRAPH
    {0x9855, 0x7BED}, //3543 #CJK UNIFIED IDEOGRAPH
    {0x9856, 0x8001}, //3544 #CJK UNIFIED IDEOGRAPH
    {0x9857, 0x807E}, //3545 #CJK UNIFIED IDEOGRAPH
    {0x9858, 0x874B}, //3546 #CJK UNIFIED IDEOGRAPH
    {0x9859, 0x90CE}, //3547 #CJK UNIFIED IDEOGRAPH
    {0x985A, 0x516D}, //3548 #CJK UNIFIED IDEOGRAPH
    {0x985B, 0x9E93}, //3549 #CJK UNIFIED IDEOGRAPH
    {0x985C, 0x7984}, //3550 #CJK UNIFIED IDEOGRAPH
    {0x985D, 0x808B}, //3551 #CJK UNIFIED IDEOGRAPH
    {0x985E, 0x9332}, //3552 #CJK UNIFIED IDEOGRAPH
    {0x985F, 0x8AD6}, //3553 #CJK UNIFIED IDEOGRAPH
    {0x9860, 0x502D}, //3554 #CJK UNIFIED IDEOGRAPH
    {0x9861, 0x548C}, //3555 #CJK UNIFIED IDEOGRAPH
    {0x9862, 0x8A71}, //3556 #CJK UNIFIED IDEOGRAPH
    {0x9863, 0x6B6A}, //3557 #CJK UNIFIED IDEOGRAPH
    {0x9864, 0x8CC4}, //3558 #CJK UNIFIED IDEOGRAPH
    {0x9865, 0x8107}, //3559 #CJK UNIFIED IDEOGRAPH
    {0x9866, 0x60D1}, //3560 #CJK UNIFIED IDEOGRAPH
    {0x9867, 0x67A0}, //3561 #CJK UNIFIED IDEOGRAPH
    {0x9868, 0x9DF2}, //3562 #CJK UNIFIED IDEOGRAPH
    {0x9869, 0x4E99}, //3563 #CJK UNIFIED IDEOGRAPH
    {0x986A, 0x4E98}, //3564 #CJK UNIFIED IDEOGRAPH
    {0x986B, 0x9C10}, //3565 #CJK UNIFIED IDEOGRAPH
    {0x986C, 0x8A6B}, //3566 #CJK UNIFIED IDEOGRAPH
    {0x986D, 0x85C1}, //3567 #CJK UNIFIED IDEOGRAPH
    {0x986E, 0x8568}, //3568 #CJK UNIFIED IDEOGRAPH
    {0x986F, 0x6900}, //3569 #CJK UNIFIED IDEOGRAPH
    {0x9870, 0x6E7E}, //3570 #CJK UNIFIED IDEOGRAPH
    {0x9871, 0x7897}, //3571 #CJK UNIFIED IDEOGRAPH
    {0x9872, 0x8155}, //3572 #CJK UNIFIED IDEOGRAPH
    {0x989F, 0x5F0C}, //3573 #CJK UNIFIED IDEOGRAPH
    {0x98A0, 0x4E10}, //3574 #CJK UNIFIED IDEOGRAPH
    {0x98A1, 0x4E15}, //3575 #CJK UNIFIED IDEOGRAPH
    {0x98A2, 0x4E2A}, //3576 #CJK UNIFIED IDEOGRAPH
    {0x98A3, 0x4E31}, //3577 #CJK UNIFIED IDEOGRAPH
    {0x98A4, 0x4E36}, //3578 #CJK UNIFIED IDEOGRAPH
    {0x98A5, 0x4E3C}, //3579 #CJK UNIFIED IDEOGRAPH
    {0x98A6, 0x4E3F}, //3580 #CJK UNIFIED IDEOGRAPH
    {0x98A7, 0x4E42}, //3581 #CJK UNIFIED IDEOGRAPH
    {0x98A8, 0x4E56}, //3582 #CJK UNIFIED IDEOGRAPH
    {0x98A9, 0x4E58}, //3583 #CJK UNIFIED IDEOGRAPH
    {0x98AA, 0x4E82}, //3584 #CJK UNIFIED IDEOGRAPH
    {0x98AB, 0x4E85}, //3585 #CJK UNIFIED IDEOGRAPH
    {0x98AC, 0x8C6B}, //3586 #CJK UNIFIED IDEOGRAPH
    {0x98AD, 0x4E8A}, //3587 #CJK UNIFIED IDEOGRAPH
    {0x98AE, 0x8212}, //3588 #CJK UNIFIED IDEOGRAPH
    {0x98AF, 0x5F0D}, //3589 #CJK UNIFIED IDEOGRAPH
    {0x98B0, 0x4E8E}, //3590 #CJK UNIFIED IDEOGRAPH
    {0x98B1, 0x4E9E}, //3591 #CJK UNIFIED IDEOGRAPH
    {0x98B2, 0x4E9F}, //3592 #CJK UNIFIED IDEOGRAPH
    {0x98B3, 0x4EA0}, //3593 #CJK UNIFIED IDEOGRAPH
    {0x98B4, 0x4EA2}, //3594 #CJK UNIFIED IDEOGRAPH
    {0x98B5, 0x4EB0}, //3595 #CJK UNIFIED IDEOGRAPH
    {0x98B6, 0x4EB3}, //3596 #CJK UNIFIED IDEOGRAPH
    {0x98B7, 0x4EB6}, //3597 #CJK UNIFIED IDEOGRAPH
    {0x98B8, 0x4ECE}, //3598 #CJK UNIFIED IDEOGRAPH
    {0x98B9, 0x4ECD}, //3599 #CJK UNIFIED IDEOGRAPH
    {0x98BA, 0x4EC4}, //3600 #CJK UNIFIED IDEOGRAPH
    {0x98BB, 0x4EC6}, //3601 #CJK UNIFIED IDEOGRAPH
    {0x98BC, 0x4EC2}, //3602 #CJK UNIFIED IDEOGRAPH
    {0x98BD, 0x4ED7}, //3603 #CJK UNIFIED IDEOGRAPH
    {0x98BE, 0x4EDE}, //3604 #CJK UNIFIED IDEOGRAPH
    {0x98BF, 0x4EED}, //3605 #CJK UNIFIED IDEOGRAPH
    {0x98C0, 0x4EDF}, //3606 #CJK UNIFIED IDEOGRAPH
    {0x98C1, 0x4EF7}, //3607 #CJK UNIFIED IDEOGRAPH
    {0x98C2, 0x4F09}, //3608 #CJK UNIFIED IDEOGRAPH
    {0x98C3, 0x4F5A}, //3609 #CJK UNIFIED IDEOGRAPH
    {0x98C4, 0x4F30}, //3610 #CJK UNIFIED IDEOGRAPH
    {0x98C5, 0x4F5B}, //3611 #CJK UNIFIED IDEOGRAPH
    {0x98C6, 0x4F5D}, //3612 #CJK UNIFIED IDEOGRAPH
    {0x98C7, 0x4F57}, //3613 #CJK UNIFIED IDEOGRAPH
    {0x98C8, 0x4F47}, //3614 #CJK UNIFIED IDEOGRAPH
    {0x98C9, 0x4F76}, //3615 #CJK UNIFIED IDEOGRAPH
    {0x98CA, 0x4F88}, //3616 #CJK UNIFIED IDEOGRAPH
    {0x98CB, 0x4F8F}, //3617 #CJK UNIFIED IDEOGRAPH
    {0x98CC, 0x4F98}, //3618 #CJK UNIFIED IDEOGRAPH
    {0x98CD, 0x4F7B}, //3619 #CJK UNIFIED IDEOGRAPH
    {0x98CE, 0x4F69}, //3620 #CJK UNIFIED IDEOGRAPH
    {0x98CF, 0x4F70}, //3621 #CJK UNIFIED IDEOGRAPH
    {0x98D0, 0x4F91}, //3622 #CJK UNIFIED IDEOGRAPH
    {0x98D1, 0x4F6F}, //3623 #CJK UNIFIED IDEOGRAPH
    {0x98D2, 0x4F86}, //3624 #CJK UNIFIED IDEOGRAPH
    {0x98D3, 0x4F96}, //3625 #CJK UNIFIED IDEOGRAPH
    {0x98D4, 0x5118}, //3626 #CJK UNIFIED IDEOGRAPH
    {0x98D5, 0x4FD4}, //3627 #CJK UNIFIED IDEOGRAPH
    {0x98D6, 0x4FDF}, //3628 #CJK UNIFIED IDEOGRAPH
    {0x98D7, 0x4FCE}, //3629 #CJK UNIFIED IDEOGRAPH
    {0x98D8, 0x4FD8}, //3630 #CJK UNIFIED IDEOGRAPH
    {0x98D9, 0x4FDB}, //3631 #CJK UNIFIED IDEOGRAPH
    {0x98DA, 0x4FD1}, //3632 #CJK UNIFIED IDEOGRAPH
    {0x98DB, 0x4FDA}, //3633 #CJK UNIFIED IDEOGRAPH
    {0x98DC, 0x4FD0}, //3634 #CJK UNIFIED IDEOGRAPH
    {0x98DD, 0x4FE4}, //3635 #CJK UNIFIED IDEOGRAPH
    {0x98DE, 0x4FE5}, //3636 #CJK UNIFIED IDEOGRAPH
    {0x98DF, 0x501A}, //3637 #CJK UNIFIED IDEOGRAPH
    {0x98E0, 0x5028}, //3638 #CJK UNIFIED IDEOGRAPH
    {0x98E1, 0x5014}, //3639 #CJK UNIFIED IDEOGRAPH
    {0x98E2, 0x502A}, //3640 #CJK UNIFIED IDEOGRAPH
    {0x98E3, 0x5025}, //3641 #CJK UNIFIED IDEOGRAPH
    {0x98E4, 0x5005}, //3642 #CJK UNIFIED IDEOGRAPH
    {0x98E5, 0x4F1C}, //3643 #CJK UNIFIED IDEOGRAPH
    {0x98E6, 0x4FF6}, //3644 #CJK UNIFIED IDEOGRAPH
    {0x98E7, 0x5021}, //3645 #CJK UNIFIED IDEOGRAPH
    {0x98E8, 0x5029}, //3646 #CJK UNIFIED IDEOGRAPH
    {0x98E9, 0x502C}, //3647 #CJK UNIFIED IDEOGRAPH
    {0x98EA, 0x4FFE}, //3648 #CJK UNIFIED IDEOGRAPH
    {0x98EB, 0x4FEF}, //3649 #CJK UNIFIED IDEOGRAPH
    {0x98EC, 0x5011}, //3650 #CJK UNIFIED IDEOGRAPH
    {0x98ED, 0x5006}, //3651 #CJK UNIFIED IDEOGRAPH
    {0x98EE, 0x5043}, //3652 #CJK UNIFIED IDEOGRAPH
    {0x98EF, 0x5047}, //3653 #CJK UNIFIED IDEOGRAPH
    {0x98F0, 0x6703}, //3654 #CJK UNIFIED IDEOGRAPH
    {0x98F1, 0x5055}, //3655 #CJK UNIFIED IDEOGRAPH
    {0x98F2, 0x5050}, //3656 #CJK UNIFIED IDEOGRAPH
    {0x98F3, 0x5048}, //3657 #CJK UNIFIED IDEOGRAPH
    {0x98F4, 0x505A}, //3658 #CJK UNIFIED IDEOGRAPH
    {0x98F5, 0x5056}, //3659 #CJK UNIFIED IDEOGRAPH
    {0x98F6, 0x506C}, //3660 #CJK UNIFIED IDEOGRAPH
    {0x98F7, 0x5078}, //3661 #CJK UNIFIED IDEOGRAPH
    {0x98F8, 0x5080}, //3662 #CJK UNIFIED IDEOGRAPH
    {0x98F9, 0x509A}, //3663 #CJK UNIFIED IDEOGRAPH
    {0x98FA, 0x5085}, //3664 #CJK UNIFIED IDEOGRAPH
    {0x98FB, 0x50B4}, //3665 #CJK UNIFIED IDEOGRAPH
    {0x98FC, 0x50B2}, //3666 #CJK UNIFIED IDEOGRAPH
    {0x9940, 0x50C9}, //3667 #CJK UNIFIED IDEOGRAPH
    {0x9941, 0x50CA}, //3668 #CJK UNIFIED IDEOGRAPH
    {0x9942, 0x50B3}, //3669 #CJK UNIFIED IDEOGRAPH
    {0x9943, 0x50C2}, //3670 #CJK UNIFIED IDEOGRAPH
    {0x9944, 0x50D6}, //3671 #CJK UNIFIED IDEOGRAPH
    {0x9945, 0x50DE}, //3672 #CJK UNIFIED IDEOGRAPH
    {0x9946, 0x50E5}, //3673 #CJK UNIFIED IDEOGRAPH
    {0x9947, 0x50ED}, //3674 #CJK UNIFIED IDEOGRAPH
    {0x9948, 0x50E3}, //3675 #CJK UNIFIED IDEOGRAPH
    {0x9949, 0x50EE}, //3676 #CJK UNIFIED IDEOGRAPH
    {0x994A, 0x50F9}, //3677 #CJK UNIFIED IDEOGRAPH
    {0x994B, 0x50F5}, //3678 #CJK UNIFIED IDEOGRAPH
    {0x994C, 0x5109}, //3679 #CJK UNIFIED IDEOGRAPH
    {0x994D, 0x5101}, //3680 #CJK UNIFIED IDEOGRAPH
    {0x994E, 0x5102}, //3681 #CJK UNIFIED IDEOGRAPH
    {0x994F, 0x5116}, //3682 #CJK UNIFIED IDEOGRAPH
    {0x9950, 0x5115}, //3683 #CJK UNIFIED IDEOGRAPH
    {0x9951, 0x5114}, //3684 #CJK UNIFIED IDEOGRAPH
    {0x9952, 0x511A}, //3685 #CJK UNIFIED IDEOGRAPH
    {0x9953, 0x5121}, //3686 #CJK UNIFIED IDEOGRAPH
    {0x9954, 0x513A}, //3687 #CJK UNIFIED IDEOGRAPH
    {0x9955, 0x5137}, //3688 #CJK UNIFIED IDEOGRAPH
    {0x9956, 0x513C}, //3689 #CJK UNIFIED IDEOGRAPH
    {0x9957, 0x513B}, //3690 #CJK UNIFIED IDEOGRAPH
    {0x9958, 0x513F}, //3691 #CJK UNIFIED IDEOGRAPH
    {0x9959, 0x5140}, //3692 #CJK UNIFIED IDEOGRAPH
    {0x995A, 0x5152}, //3693 #CJK UNIFIED IDEOGRAPH
    {0x995B, 0x514C}, //3694 #CJK UNIFIED IDEOGRAPH
    {0x995C, 0x5154}, //3695 #CJK UNIFIED IDEOGRAPH
    {0x995D, 0x5162}, //3696 #CJK UNIFIED IDEOGRAPH
    {0x995E, 0x7AF8}, //3697 #CJK UNIFIED IDEOGRAPH
    {0x995F, 0x5169}, //3698 #CJK UNIFIED IDEOGRAPH
    {0x9960, 0x516A}, //3699 #CJK UNIFIED IDEOGRAPH
    {0x9961, 0x516E}, //3700 #CJK UNIFIED IDEOGRAPH
    {0x9962, 0x5180}, //3701 #CJK UNIFIED IDEOGRAPH
    {0x9963, 0x5182}, //3702 #CJK UNIFIED IDEOGRAPH
    {0x9964, 0x56D8}, //3703 #CJK UNIFIED IDEOGRAPH
    {0x9965, 0x518C}, //3704 #CJK UNIFIED IDEOGRAPH
    {0x9966, 0x5189}, //3705 #CJK UNIFIED IDEOGRAPH
    {0x9967, 0x518F}, //3706 #CJK UNIFIED IDEOGRAPH
    {0x9968, 0x5191}, //3707 #CJK UNIFIED IDEOGRAPH
    {0x9969, 0x5193}, //3708 #CJK UNIFIED IDEOGRAPH
    {0x996A, 0x5195}, //3709 #CJK UNIFIED IDEOGRAPH
    {0x996B, 0x5196}, //3710 #CJK UNIFIED IDEOGRAPH
    {0x996C, 0x51A4}, //3711 #CJK UNIFIED IDEOGRAPH
    {0x996D, 0x51A6}, //3712 #CJK UNIFIED IDEOGRAPH
    {0x996E, 0x51A2}, //3713 #CJK UNIFIED IDEOGRAPH
    {0x996F, 0x51A9}, //3714 #CJK UNIFIED IDEOGRAPH
    {0x9970, 0x51AA}, //3715 #CJK UNIFIED IDEOGRAPH
    {0x9971, 0x51AB}, //3716 #CJK UNIFIED IDEOGRAPH
    {0x9972, 0x51B3}, //3717 #CJK UNIFIED IDEOGRAPH
    {0x9973, 0x51B1}, //3718 #CJK UNIFIED IDEOGRAPH
    {0x9974, 0x51B2}, //3719 #CJK UNIFIED IDEOGRAPH
    {0x9975, 0x51B0}, //3720 #CJK UNIFIED IDEOGRAPH
    {0x9976, 0x51B5}, //3721 #CJK UNIFIED IDEOGRAPH
    {0x9977, 0x51BD}, //3722 #CJK UNIFIED IDEOGRAPH
    {0x9978, 0x51C5}, //3723 #CJK UNIFIED IDEOGRAPH
    {0x9979, 0x51C9}, //3724 #CJK UNIFIED IDEOGRAPH
    {0x997A, 0x51DB}, //3725 #CJK UNIFIED IDEOGRAPH
    {0x997B, 0x51E0}, //3726 #CJK UNIFIED IDEOGRAPH
    {0x997C, 0x8655}, //3727 #CJK UNIFIED IDEOGRAPH
    {0x997D, 0x51E9}, //3728 #CJK UNIFIED IDEOGRAPH
    {0x997E, 0x51ED}, //3729 #CJK UNIFIED IDEOGRAPH
    {0x9980, 0x51F0}, //3730 #CJK UNIFIED IDEOGRAPH
    {0x9981, 0x51F5}, //3731 #CJK UNIFIED IDEOGRAPH
    {0x9982, 0x51FE}, //3732 #CJK UNIFIED IDEOGRAPH
    {0x9983, 0x5204}, //3733 #CJK UNIFIED IDEOGRAPH
    {0x9984, 0x520B}, //3734 #CJK UNIFIED IDEOGRAPH
    {0x9985, 0x5214}, //3735 #CJK UNIFIED IDEOGRAPH
    {0x9986, 0x520E}, //3736 #CJK UNIFIED IDEOGRAPH
    {0x9987, 0x5227}, //3737 #CJK UNIFIED IDEOGRAPH
    {0x9988, 0x522A}, //3738 #CJK UNIFIED IDEOGRAPH
    {0x9989, 0x522E}, //3739 #CJK UNIFIED IDEOGRAPH
    {0x998A, 0x5233}, //3740 #CJK UNIFIED IDEOGRAPH
    {0x998B, 0x5239}, //3741 #CJK UNIFIED IDEOGRAPH
    {0x998C, 0x524F}, //3742 #CJK UNIFIED IDEOGRAPH
    {0x998D, 0x5244}, //3743 #CJK UNIFIED IDEOGRAPH
    {0x998E, 0x524B}, //3744 #CJK UNIFIED IDEOGRAPH
    {0x998F, 0x524C}, //3745 #CJK UNIFIED IDEOGRAPH
    {0x9990, 0x525E}, //3746 #CJK UNIFIED IDEOGRAPH
    {0x9991, 0x5254}, //3747 #CJK UNIFIED IDEOGRAPH
    {0x9992, 0x526A}, //3748 #CJK UNIFIED IDEOGRAPH
    {0x9993, 0x5274}, //3749 #CJK UNIFIED IDEOGRAPH
    {0x9994, 0x5269}, //3750 #CJK UNIFIED IDEOGRAPH
    {0x9995, 0x5273}, //3751 #CJK UNIFIED IDEOGRAPH
    {0x9996, 0x527F}, //3752 #CJK UNIFIED IDEOGRAPH
    {0x9997, 0x527D}, //3753 #CJK UNIFIED IDEOGRAPH
    {0x9998, 0x528D}, //3754 #CJK UNIFIED IDEOGRAPH
    {0x9999, 0x5294}, //3755 #CJK UNIFIED IDEOGRAPH
    {0x999A, 0x5292}, //3756 #CJK UNIFIED IDEOGRAPH
    {0x999B, 0x5271}, //3757 #CJK UNIFIED IDEOGRAPH
    {0x999C, 0x5288}, //3758 #CJK UNIFIED IDEOGRAPH
    {0x999D, 0x5291}, //3759 #CJK UNIFIED IDEOGRAPH
    {0x999E, 0x8FA8}, //3760 #CJK UNIFIED IDEOGRAPH
    {0x999F, 0x8FA7}, //3761 #CJK UNIFIED IDEOGRAPH
    {0x99A0, 0x52AC}, //3762 #CJK UNIFIED IDEOGRAPH
    {0x99A1, 0x52AD}, //3763 #CJK UNIFIED IDEOGRAPH
    {0x99A2, 0x52BC}, //3764 #CJK UNIFIED IDEOGRAPH
    {0x99A3, 0x52B5}, //3765 #CJK UNIFIED IDEOGRAPH
    {0x99A4, 0x52C1}, //3766 #CJK UNIFIED IDEOGRAPH
    {0x99A5, 0x52CD}, //3767 #CJK UNIFIED IDEOGRAPH
    {0x99A6, 0x52D7}, //3768 #CJK UNIFIED IDEOGRAPH
    {0x99A7, 0x52DE}, //3769 #CJK UNIFIED IDEOGRAPH
    {0x99A8, 0x52E3}, //3770 #CJK UNIFIED IDEOGRAPH
    {0x99A9, 0x52E6}, //3771 #CJK UNIFIED IDEOGRAPH
    {0x99AA, 0x98ED}, //3772 #CJK UNIFIED IDEOGRAPH
    {0x99AB, 0x52E0}, //3773 #CJK UNIFIED IDEOGRAPH
    {0x99AC, 0x52F3}, //3774 #CJK UNIFIED IDEOGRAPH
    {0x99AD, 0x52F5}, //3775 #CJK UNIFIED IDEOGRAPH
    {0x99AE, 0x52F8}, //3776 #CJK UNIFIED IDEOGRAPH
    {0x99AF, 0x52F9}, //3777 #CJK UNIFIED IDEOGRAPH
    {0x99B0, 0x5306}, //3778 #CJK UNIFIED IDEOGRAPH
    {0x99B1, 0x5308}, //3779 #CJK UNIFIED IDEOGRAPH
    {0x99B2, 0x7538}, //3780 #CJK UNIFIED IDEOGRAPH
    {0x99B3, 0x530D}, //3781 #CJK UNIFIED IDEOGRAPH
    {0x99B4, 0x5310}, //3782 #CJK UNIFIED IDEOGRAPH
    {0x99B5, 0x530F}, //3783 #CJK UNIFIED IDEOGRAPH
    {0x99B6, 0x5315}, //3784 #CJK UNIFIED IDEOGRAPH
    {0x99B7, 0x531A}, //3785 #CJK UNIFIED IDEOGRAPH
    {0x99B8, 0x5323}, //3786 #CJK UNIFIED IDEOGRAPH
    {0x99B9, 0x532F}, //3787 #CJK UNIFIED IDEOGRAPH
    {0x99BA, 0x5331}, //3788 #CJK UNIFIED IDEOGRAPH
    {0x99BB, 0x5333}, //3789 #CJK UNIFIED IDEOGRAPH
    {0x99BC, 0x5338}, //3790 #CJK UNIFIED IDEOGRAPH
    {0x99BD, 0x5340}, //3791 #CJK UNIFIED IDEOGRAPH
    {0x99BE, 0x5346}, //3792 #CJK UNIFIED IDEOGRAPH
    {0x99BF, 0x5345}, //3793 #CJK UNIFIED IDEOGRAPH
    {0x99C0, 0x4E17}, //3794 #CJK UNIFIED IDEOGRAPH
    {0x99C1, 0x5349}, //3795 #CJK UNIFIED IDEOGRAPH
    {0x99C2, 0x534D}, //3796 #CJK UNIFIED IDEOGRAPH
    {0x99C3, 0x51D6}, //3797 #CJK UNIFIED IDEOGRAPH
    {0x99C4, 0x535E}, //3798 #CJK UNIFIED IDEOGRAPH
    {0x99C5, 0x5369}, //3799 #CJK UNIFIED IDEOGRAPH
    {0x99C6, 0x536E}, //3800 #CJK UNIFIED IDEOGRAPH
    {0x99C7, 0x5918}, //3801 #CJK UNIFIED IDEOGRAPH
    {0x99C8, 0x537B}, //3802 #CJK UNIFIED IDEOGRAPH
    {0x99C9, 0x5377}, //3803 #CJK UNIFIED IDEOGRAPH
    {0x99CA, 0x5382}, //3804 #CJK UNIFIED IDEOGRAPH
    {0x99CB, 0x5396}, //3805 #CJK UNIFIED IDEOGRAPH
    {0x99CC, 0x53A0}, //3806 #CJK UNIFIED IDEOGRAPH
    {0x99CD, 0x53A6}, //3807 #CJK UNIFIED IDEOGRAPH
    {0x99CE, 0x53A5}, //3808 #CJK UNIFIED IDEOGRAPH
    {0x99CF, 0x53AE}, //3809 #CJK UNIFIED IDEOGRAPH
    {0x99D0, 0x53B0}, //3810 #CJK UNIFIED IDEOGRAPH
    {0x99D1, 0x53B6}, //3811 #CJK UNIFIED IDEOGRAPH
    {0x99D2, 0x53C3}, //3812 #CJK UNIFIED IDEOGRAPH
    {0x99D3, 0x7C12}, //3813 #CJK UNIFIED IDEOGRAPH
    {0x99D4, 0x96D9}, //3814 #CJK UNIFIED IDEOGRAPH
    {0x99D5, 0x53DF}, //3815 #CJK UNIFIED IDEOGRAPH
    {0x99D6, 0x66FC}, //3816 #CJK UNIFIED IDEOGRAPH
    {0x99D7, 0x71EE}, //3817 #CJK UNIFIED IDEOGRAPH
    {0x99D8, 0x53EE}, //3818 #CJK UNIFIED IDEOGRAPH
    {0x99D9, 0x53E8}, //3819 #CJK UNIFIED IDEOGRAPH
    {0x99DA, 0x53ED}, //3820 #CJK UNIFIED IDEOGRAPH
    {0x99DB, 0x53FA}, //3821 #CJK UNIFIED IDEOGRAPH
    {0x99DC, 0x5401}, //3822 #CJK UNIFIED IDEOGRAPH
    {0x99DD, 0x543D}, //3823 #CJK UNIFIED IDEOGRAPH
    {0x99DE, 0x5440}, //3824 #CJK UNIFIED IDEOGRAPH
    {0x99DF, 0x542C}, //3825 #CJK UNIFIED IDEOGRAPH
    {0x99E0, 0x542D}, //3826 #CJK UNIFIED IDEOGRAPH
    {0x99E1, 0x543C}, //3827 #CJK UNIFIED IDEOGRAPH
    {0x99E2, 0x542E}, //3828 #CJK UNIFIED IDEOGRAPH
    {0x99E3, 0x5436}, //3829 #CJK UNIFIED IDEOGRAPH
    {0x99E4, 0x5429}, //3830 #CJK UNIFIED IDEOGRAPH
    {0x99E5, 0x541D}, //3831 #CJK UNIFIED IDEOGRAPH
    {0x99E6, 0x544E}, //3832 #CJK UNIFIED IDEOGRAPH
    {0x99E7, 0x548F}, //3833 #CJK UNIFIED IDEOGRAPH
    {0x99E8, 0x5475}, //3834 #CJK UNIFIED IDEOGRAPH
    {0x99E9, 0x548E}, //3835 #CJK UNIFIED IDEOGRAPH
    {0x99EA, 0x545F}, //3836 #CJK UNIFIED IDEOGRAPH
    {0x99EB, 0x5471}, //3837 #CJK UNIFIED IDEOGRAPH
    {0x99EC, 0x5477}, //3838 #CJK UNIFIED IDEOGRAPH
    {0x99ED, 0x5470}, //3839 #CJK UNIFIED IDEOGRAPH
    {0x99EE, 0x5492}, //3840 #CJK UNIFIED IDEOGRAPH
    {0x99EF, 0x547B}, //3841 #CJK UNIFIED IDEOGRAPH
    {0x99F0, 0x5480}, //3842 #CJK UNIFIED IDEOGRAPH
    {0x99F1, 0x5476}, //3843 #CJK UNIFIED IDEOGRAPH
    {0x99F2, 0x5484}, //3844 #CJK UNIFIED IDEOGRAPH
    {0x99F3, 0x5490}, //3845 #CJK UNIFIED IDEOGRAPH
    {0x99F4, 0x5486}, //3846 #CJK UNIFIED IDEOGRAPH
    {0x99F5, 0x54C7}, //3847 #CJK UNIFIED IDEOGRAPH
    {0x99F6, 0x54A2}, //3848 #CJK UNIFIED IDEOGRAPH
    {0x99F7, 0x54B8}, //3849 #CJK UNIFIED IDEOGRAPH
    {0x99F8, 0x54A5}, //3850 #CJK UNIFIED IDEOGRAPH
    {0x99F9, 0x54AC}, //3851 #CJK UNIFIED IDEOGRAPH
    {0x99FA, 0x54C4}, //3852 #CJK UNIFIED IDEOGRAPH
    {0x99FB, 0x54C8}, //3853 #CJK UNIFIED IDEOGRAPH
    {0x99FC, 0x54A8}, //3854 #CJK UNIFIED IDEOGRAPH
    {0x9A40, 0x54AB}, //3855 #CJK UNIFIED IDEOGRAPH
    {0x9A41, 0x54C2}, //3856 #CJK UNIFIED IDEOGRAPH
    {0x9A42, 0x54A4}, //3857 #CJK UNIFIED IDEOGRAPH
    {0x9A43, 0x54BE}, //3858 #CJK UNIFIED IDEOGRAPH
    {0x9A44, 0x54BC}, //3859 #CJK UNIFIED IDEOGRAPH
    {0x9A45, 0x54D8}, //3860 #CJK UNIFIED IDEOGRAPH
    {0x9A46, 0x54E5}, //3861 #CJK UNIFIED IDEOGRAPH
    {0x9A47, 0x54E6}, //3862 #CJK UNIFIED IDEOGRAPH
    {0x9A48, 0x550F}, //3863 #CJK UNIFIED IDEOGRAPH
    {0x9A49, 0x5514}, //3864 #CJK UNIFIED IDEOGRAPH
    {0x9A4A, 0x54FD}, //3865 #CJK UNIFIED IDEOGRAPH
    {0x9A4B, 0x54EE}, //3866 #CJK UNIFIED IDEOGRAPH
    {0x9A4C, 0x54ED}, //3867 #CJK UNIFIED IDEOGRAPH
    {0x9A4D, 0x54FA}, //3868 #CJK UNIFIED IDEOGRAPH
    {0x9A4E, 0x54E2}, //3869 #CJK UNIFIED IDEOGRAPH
    {0x9A4F, 0x5539}, //3870 #CJK UNIFIED IDEOGRAPH
    {0x9A50, 0x5540}, //3871 #CJK UNIFIED IDEOGRAPH
    {0x9A51, 0x5563}, //3872 #CJK UNIFIED IDEOGRAPH
    {0x9A52, 0x554C}, //3873 #CJK UNIFIED IDEOGRAPH
    {0x9A53, 0x552E}, //3874 #CJK UNIFIED IDEOGRAPH
    {0x9A54, 0x555C}, //3875 #CJK UNIFIED IDEOGRAPH
    {0x9A55, 0x5545}, //3876 #CJK UNIFIED IDEOGRAPH
    {0x9A56, 0x5556}, //3877 #CJK UNIFIED IDEOGRAPH
    {0x9A57, 0x5557}, //3878 #CJK UNIFIED IDEOGRAPH
    {0x9A58, 0x5538}, //3879 #CJK UNIFIED IDEOGRAPH
    {0x9A59, 0x5533}, //3880 #CJK UNIFIED IDEOGRAPH
    {0x9A5A, 0x555D}, //3881 #CJK UNIFIED IDEOGRAPH
    {0x9A5B, 0x5599}, //3882 #CJK UNIFIED IDEOGRAPH
    {0x9A5C, 0x5580}, //3883 #CJK UNIFIED IDEOGRAPH
    {0x9A5D, 0x54AF}, //3884 #CJK UNIFIED IDEOGRAPH
    {0x9A5E, 0x558A}, //3885 #CJK UNIFIED IDEOGRAPH
    {0x9A5F, 0x559F}, //3886 #CJK UNIFIED IDEOGRAPH
    {0x9A60, 0x557B}, //3887 #CJK UNIFIED IDEOGRAPH
    {0x9A61, 0x557E}, //3888 #CJK UNIFIED IDEOGRAPH
    {0x9A62, 0x5598}, //3889 #CJK UNIFIED IDEOGRAPH
    {0x9A63, 0x559E}, //3890 #CJK UNIFIED IDEOGRAPH
    {0x9A64, 0x55AE}, //3891 #CJK UNIFIED IDEOGRAPH
    {0x9A65, 0x557C}, //3892 #CJK UNIFIED IDEOGRAPH
    {0x9A66, 0x5583}, //3893 #CJK UNIFIED IDEOGRAPH
    {0x9A67, 0x55A9}, //3894 #CJK UNIFIED IDEOGRAPH
    {0x9A68, 0x5587}, //3895 #CJK UNIFIED IDEOGRAPH
    {0x9A69, 0x55A8}, //3896 #CJK UNIFIED IDEOGRAPH
    {0x9A6A, 0x55DA}, //3897 #CJK UNIFIED IDEOGRAPH
    {0x9A6B, 0x55C5}, //3898 #CJK UNIFIED IDEOGRAPH
    {0x9A6C, 0x55DF}, //3899 #CJK UNIFIED IDEOGRAPH
    {0x9A6D, 0x55C4}, //3900 #CJK UNIFIED IDEOGRAPH
    {0x9A6E, 0x55DC}, //3901 #CJK UNIFIED IDEOGRAPH
    {0x9A6F, 0x55E4}, //3902 #CJK UNIFIED IDEOGRAPH
    {0x9A70, 0x55D4}, //3903 #CJK UNIFIED IDEOGRAPH
    {0x9A71, 0x5614}, //3904 #CJK UNIFIED IDEOGRAPH
    {0x9A72, 0x55F7}, //3905 #CJK UNIFIED IDEOGRAPH
    {0x9A73, 0x5616}, //3906 #CJK UNIFIED IDEOGRAPH
    {0x9A74, 0x55FE}, //3907 #CJK UNIFIED IDEOGRAPH
    {0x9A75, 0x55FD}, //3908 #CJK UNIFIED IDEOGRAPH
    {0x9A76, 0x561B}, //3909 #CJK UNIFIED IDEOGRAPH
    {0x9A77, 0x55F9}, //3910 #CJK UNIFIED IDEOGRAPH
    {0x9A78, 0x564E}, //3911 #CJK UNIFIED IDEOGRAPH
    {0x9A79, 0x5650}, //3912 #CJK UNIFIED IDEOGRAPH
    {0x9A7A, 0x71DF}, //3913 #CJK UNIFIED IDEOGRAPH
    {0x9A7B, 0x5634}, //3914 #CJK UNIFIED IDEOGRAPH
    {0x9A7C, 0x5636}, //3915 #CJK UNIFIED IDEOGRAPH
    {0x9A7D, 0x5632}, //3916 #CJK UNIFIED IDEOGRAPH
    {0x9A7E, 0x5638}, //3917 #CJK UNIFIED IDEOGRAPH
    {0x9A80, 0x566B}, //3918 #CJK UNIFIED IDEOGRAPH
    {0x9A81, 0x5664}, //3919 #CJK UNIFIED IDEOGRAPH
    {0x9A82, 0x562F}, //3920 #CJK UNIFIED IDEOGRAPH
    {0x9A83, 0x566C}, //3921 #CJK UNIFIED IDEOGRAPH
    {0x9A84, 0x566A}, //3922 #CJK UNIFIED IDEOGRAPH
    {0x9A85, 0x5686}, //3923 #CJK UNIFIED IDEOGRAPH
    {0x9A86, 0x5680}, //3924 #CJK UNIFIED IDEOGRAPH
    {0x9A87, 0x568A}, //3925 #CJK UNIFIED IDEOGRAPH
    {0x9A88, 0x56A0}, //3926 #CJK UNIFIED IDEOGRAPH
    {0x9A89, 0x5694}, //3927 #CJK UNIFIED IDEOGRAPH
    {0x9A8A, 0x568F}, //3928 #CJK UNIFIED IDEOGRAPH
    {0x9A8B, 0x56A5}, //3929 #CJK UNIFIED IDEOGRAPH
    {0x9A8C, 0x56AE}, //3930 #CJK UNIFIED IDEOGRAPH
    {0x9A8D, 0x56B6}, //3931 #CJK UNIFIED IDEOGRAPH
    {0x9A8E, 0x56B4}, //3932 #CJK UNIFIED IDEOGRAPH
    {0x9A8F, 0x56C2}, //3933 #CJK UNIFIED IDEOGRAPH
    {0x9A90, 0x56BC}, //3934 #CJK UNIFIED IDEOGRAPH
    {0x9A91, 0x56C1}, //3935 #CJK UNIFIED IDEOGRAPH
    {0x9A92, 0x56C3}, //3936 #CJK UNIFIED IDEOGRAPH
    {0x9A93, 0x56C0}, //3937 #CJK UNIFIED IDEOGRAPH
    {0x9A94, 0x56C8}, //3938 #CJK UNIFIED IDEOGRAPH
    {0x9A95, 0x56CE}, //3939 #CJK UNIFIED IDEOGRAPH
    {0x9A96, 0x56D1}, //3940 #CJK UNIFIED IDEOGRAPH
    {0x9A97, 0x56D3}, //3941 #CJK UNIFIED IDEOGRAPH
    {0x9A98, 0x56D7}, //3942 #CJK UNIFIED IDEOGRAPH
    {0x9A99, 0x56EE}, //3943 #CJK UNIFIED IDEOGRAPH
    {0x9A9A, 0x56F9}, //3944 #CJK UNIFIED IDEOGRAPH
    {0x9A9B, 0x5700}, //3945 #CJK UNIFIED IDEOGRAPH
    {0x9A9C, 0x56FF}, //3946 #CJK UNIFIED IDEOGRAPH
    {0x9A9D, 0x5704}, //3947 #CJK UNIFIED IDEOGRAPH
    {0x9A9E, 0x5709}, //3948 #CJK UNIFIED IDEOGRAPH
    {0x9A9F, 0x5708}, //3949 #CJK UNIFIED IDEOGRAPH
    {0x9AA0, 0x570B}, //3950 #CJK UNIFIED IDEOGRAPH
    {0x9AA1, 0x570D}, //3951 #CJK UNIFIED IDEOGRAPH
    {0x9AA2, 0x5713}, //3952 #CJK UNIFIED IDEOGRAPH
    {0x9AA3, 0x5718}, //3953 #CJK UNIFIED IDEOGRAPH
    {0x9AA4, 0x5716}, //3954 #CJK UNIFIED IDEOGRAPH
    {0x9AA5, 0x55C7}, //3955 #CJK UNIFIED IDEOGRAPH
    {0x9AA6, 0x571C}, //3956 #CJK UNIFIED IDEOGRAPH
    {0x9AA7, 0x5726}, //3957 #CJK UNIFIED IDEOGRAPH
    {0x9AA8, 0x5737}, //3958 #CJK UNIFIED IDEOGRAPH
    {0x9AA9, 0x5738}, //3959 #CJK UNIFIED IDEOGRAPH
    {0x9AAA, 0x574E}, //3960 #CJK UNIFIED IDEOGRAPH
    {0x9AAB, 0x573B}, //3961 #CJK UNIFIED IDEOGRAPH
    {0x9AAC, 0x5740}, //3962 #CJK UNIFIED IDEOGRAPH
    {0x9AAD, 0x574F}, //3963 #CJK UNIFIED IDEOGRAPH
    {0x9AAE, 0x5769}, //3964 #CJK UNIFIED IDEOGRAPH
    {0x9AAF, 0x57C0}, //3965 #CJK UNIFIED IDEOGRAPH
    {0x9AB0, 0x5788}, //3966 #CJK UNIFIED IDEOGRAPH
    {0x9AB1, 0x5761}, //3967 #CJK UNIFIED IDEOGRAPH
    {0x9AB2, 0x577F}, //3968 #CJK UNIFIED IDEOGRAPH
    {0x9AB3, 0x5789}, //3969 #CJK UNIFIED IDEOGRAPH
    {0x9AB4, 0x5793}, //3970 #CJK UNIFIED IDEOGRAPH
    {0x9AB5, 0x57A0}, //3971 #CJK UNIFIED IDEOGRAPH
    {0x9AB6, 0x57B3}, //3972 #CJK UNIFIED IDEOGRAPH
    {0x9AB7, 0x57A4}, //3973 #CJK UNIFIED IDEOGRAPH
    {0x9AB8, 0x57AA}, //3974 #CJK UNIFIED IDEOGRAPH
    {0x9AB9, 0x57B0}, //3975 #CJK UNIFIED IDEOGRAPH
    {0x9ABA, 0x57C3}, //3976 #CJK UNIFIED IDEOGRAPH
    {0x9ABB, 0x57C6}, //3977 #CJK UNIFIED IDEOGRAPH
    {0x9ABC, 0x57D4}, //3978 #CJK UNIFIED IDEOGRAPH
    {0x9ABD, 0x57D2}, //3979 #CJK UNIFIED IDEOGRAPH
    {0x9ABE, 0x57D3}, //3980 #CJK UNIFIED IDEOGRAPH
    {0x9ABF, 0x580A}, //3981 #CJK UNIFIED IDEOGRAPH
    {0x9AC0, 0x57D6}, //3982 #CJK UNIFIED IDEOGRAPH
    {0x9AC1, 0x57E3}, //3983 #CJK UNIFIED IDEOGRAPH
    {0x9AC2, 0x580B}, //3984 #CJK UNIFIED IDEOGRAPH
    {0x9AC3, 0x5819}, //3985 #CJK UNIFIED IDEOGRAPH
    {0x9AC4, 0x581D}, //3986 #CJK UNIFIED IDEOGRAPH
    {0x9AC5, 0x5872}, //3987 #CJK UNIFIED IDEOGRAPH
    {0x9AC6, 0x5821}, //3988 #CJK UNIFIED IDEOGRAPH
    {0x9AC7, 0x5862}, //3989 #CJK UNIFIED IDEOGRAPH
    {0x9AC8, 0x584B}, //3990 #CJK UNIFIED IDEOGRAPH
    {0x9AC9, 0x5870}, //3991 #CJK UNIFIED IDEOGRAPH
    {0x9ACA, 0x6BC0}, //3992 #CJK UNIFIED IDEOGRAPH
    {0x9ACB, 0x5852}, //3993 #CJK UNIFIED IDEOGRAPH
    {0x9ACC, 0x583D}, //3994 #CJK UNIFIED IDEOGRAPH
    {0x9ACD, 0x5879}, //3995 #CJK UNIFIED IDEOGRAPH
    {0x9ACE, 0x5885}, //3996 #CJK UNIFIED IDEOGRAPH
    {0x9ACF, 0x58B9}, //3997 #CJK UNIFIED IDEOGRAPH
    {0x9AD0, 0x589F}, //3998 #CJK UNIFIED IDEOGRAPH
    {0x9AD1, 0x58AB}, //3999 #CJK UNIFIED IDEOGRAPH
    {0x9AD2, 0x58BA}, //4000 #CJK UNIFIED IDEOGRAPH
    {0x9AD3, 0x58DE}, //4001 #CJK UNIFIED IDEOGRAPH
    {0x9AD4, 0x58BB}, //4002 #CJK UNIFIED IDEOGRAPH
    {0x9AD5, 0x58B8}, //4003 #CJK UNIFIED IDEOGRAPH
    {0x9AD6, 0x58AE}, //4004 #CJK UNIFIED IDEOGRAPH
    {0x9AD7, 0x58C5}, //4005 #CJK UNIFIED IDEOGRAPH
    {0x9AD8, 0x58D3}, //4006 #CJK UNIFIED IDEOGRAPH
    {0x9AD9, 0x58D1}, //4007 #CJK UNIFIED IDEOGRAPH
    {0x9ADA, 0x58D7}, //4008 #CJK UNIFIED IDEOGRAPH
    {0x9ADB, 0x58D9}, //4009 #CJK UNIFIED IDEOGRAPH
    {0x9ADC, 0x58D8}, //4010 #CJK UNIFIED IDEOGRAPH
    {0x9ADD, 0x58E5}, //4011 #CJK UNIFIED IDEOGRAPH
    {0x9ADE, 0x58DC}, //4012 #CJK UNIFIED IDEOGRAPH
    {0x9ADF, 0x58E4}, //4013 #CJK UNIFIED IDEOGRAPH
    {0x9AE0, 0x58DF}, //4014 #CJK UNIFIED IDEOGRAPH
    {0x9AE1, 0x58EF}, //4015 #CJK UNIFIED IDEOGRAPH
    {0x9AE2, 0x58FA}, //4016 #CJK UNIFIED IDEOGRAPH
    {0x9AE3, 0x58F9}, //4017 #CJK UNIFIED IDEOGRAPH
    {0x9AE4, 0x58FB}, //4018 #CJK UNIFIED IDEOGRAPH
    {0x9AE5, 0x58FC}, //4019 #CJK UNIFIED IDEOGRAPH
    {0x9AE6, 0x58FD}, //4020 #CJK UNIFIED IDEOGRAPH
    {0x9AE7, 0x5902}, //4021 #CJK UNIFIED IDEOGRAPH
    {0x9AE8, 0x590A}, //4022 #CJK UNIFIED IDEOGRAPH
    {0x9AE9, 0x5910}, //4023 #CJK UNIFIED IDEOGRAPH
    {0x9AEA, 0x591B}, //4024 #CJK UNIFIED IDEOGRAPH
    {0x9AEB, 0x68A6}, //4025 #CJK UNIFIED IDEOGRAPH
    {0x9AEC, 0x5925}, //4026 #CJK UNIFIED IDEOGRAPH
    {0x9AED, 0x592C}, //4027 #CJK UNIFIED IDEOGRAPH
    {0x9AEE, 0x592D}, //4028 #CJK UNIFIED IDEOGRAPH
    {0x9AEF, 0x5932}, //4029 #CJK UNIFIED IDEOGRAPH
    {0x9AF0, 0x5938}, //4030 #CJK UNIFIED IDEOGRAPH
    {0x9AF1, 0x593E}, //4031 #CJK UNIFIED IDEOGRAPH
    {0x9AF2, 0x7AD2}, //4032 #CJK UNIFIED IDEOGRAPH
    {0x9AF3, 0x5955}, //4033 #CJK UNIFIED IDEOGRAPH
    {0x9AF4, 0x5950}, //4034 #CJK UNIFIED IDEOGRAPH
    {0x9AF5, 0x594E}, //4035 #CJK UNIFIED IDEOGRAPH
    {0x9AF6, 0x595A}, //4036 #CJK UNIFIED IDEOGRAPH
    {0x9AF7, 0x5958}, //4037 #CJK UNIFIED IDEOGRAPH
    {0x9AF8, 0x5962}, //4038 #CJK UNIFIED IDEOGRAPH
    {0x9AF9, 0x5960}, //4039 #CJK UNIFIED IDEOGRAPH
    {0x9AFA, 0x5967}, //4040 #CJK UNIFIED IDEOGRAPH
    {0x9AFB, 0x596C}, //4041 #CJK UNIFIED IDEOGRAPH
    {0x9AFC, 0x5969}, //4042 #CJK UNIFIED IDEOGRAPH
    {0x9B40, 0x5978}, //4043 #CJK UNIFIED IDEOGRAPH
    {0x9B41, 0x5981}, //4044 #CJK UNIFIED IDEOGRAPH
    {0x9B42, 0x599D}, //4045 #CJK UNIFIED IDEOGRAPH
    {0x9B43, 0x4F5E}, //4046 #CJK UNIFIED IDEOGRAPH
    {0x9B44, 0x4FAB}, //4047 #CJK UNIFIED IDEOGRAPH
    {0x9B45, 0x59A3}, //4048 #CJK UNIFIED IDEOGRAPH
    {0x9B46, 0x59B2}, //4049 #CJK UNIFIED IDEOGRAPH
    {0x9B47, 0x59C6}, //4050 #CJK UNIFIED IDEOGRAPH
    {0x9B48, 0x59E8}, //4051 #CJK UNIFIED IDEOGRAPH
    {0x9B49, 0x59DC}, //4052 #CJK UNIFIED IDEOGRAPH
    {0x9B4A, 0x598D}, //4053 #CJK UNIFIED IDEOGRAPH
    {0x9B4B, 0x59D9}, //4054 #CJK UNIFIED IDEOGRAPH
    {0x9B4C, 0x59DA}, //4055 #CJK UNIFIED IDEOGRAPH
    {0x9B4D, 0x5A25}, //4056 #CJK UNIFIED IDEOGRAPH
    {0x9B4E, 0x5A1F}, //4057 #CJK UNIFIED IDEOGRAPH
    {0x9B4F, 0x5A11}, //4058 #CJK UNIFIED IDEOGRAPH
    {0x9B50, 0x5A1C}, //4059 #CJK UNIFIED IDEOGRAPH
    {0x9B51, 0x5A09}, //4060 #CJK UNIFIED IDEOGRAPH
    {0x9B52, 0x5A1A}, //4061 #CJK UNIFIED IDEOGRAPH
    {0x9B53, 0x5A40}, //4062 #CJK UNIFIED IDEOGRAPH
    {0x9B54, 0x5A6C}, //4063 #CJK UNIFIED IDEOGRAPH
    {0x9B55, 0x5A49}, //4064 #CJK UNIFIED IDEOGRAPH
    {0x9B56, 0x5A35}, //4065 #CJK UNIFIED IDEOGRAPH
    {0x9B57, 0x5A36}, //4066 #CJK UNIFIED IDEOGRAPH
    {0x9B58, 0x5A62}, //4067 #CJK UNIFIED IDEOGRAPH
    {0x9B59, 0x5A6A}, //4068 #CJK UNIFIED IDEOGRAPH
    {0x9B5A, 0x5A9A}, //4069 #CJK UNIFIED IDEOGRAPH
    {0x9B5B, 0x5ABC}, //4070 #CJK UNIFIED IDEOGRAPH
    {0x9B5C, 0x5ABE}, //4071 #CJK UNIFIED IDEOGRAPH
    {0x9B5D, 0x5ACB}, //4072 #CJK UNIFIED IDEOGRAPH
    {0x9B5E, 0x5AC2}, //4073 #CJK UNIFIED IDEOGRAPH
    {0x9B5F, 0x5ABD}, //4074 #CJK UNIFIED IDEOGRAPH
    {0x9B60, 0x5AE3}, //4075 #CJK UNIFIED IDEOGRAPH
    {0x9B61, 0x5AD7}, //4076 #CJK UNIFIED IDEOGRAPH
    {0x9B62, 0x5AE6}, //4077 #CJK UNIFIED IDEOGRAPH
    {0x9B63, 0x5AE9}, //4078 #CJK UNIFIED IDEOGRAPH
    {0x9B64, 0x5AD6}, //4079 #CJK UNIFIED IDEOGRAPH
    {0x9B65, 0x5AFA}, //4080 #CJK UNIFIED IDEOGRAPH
    {0x9B66, 0x5AFB}, //4081 #CJK UNIFIED IDEOGRAPH
    {0x9B67, 0x5B0C}, //4082 #CJK UNIFIED IDEOGRAPH
    {0x9B68, 0x5B0B}, //4083 #CJK UNIFIED IDEOGRAPH
    {0x9B69, 0x5B16}, //4084 #CJK UNIFIED IDEOGRAPH
    {0x9B6A, 0x5B32}, //4085 #CJK UNIFIED IDEOGRAPH
    {0x9B6B, 0x5AD0}, //4086 #CJK UNIFIED IDEOGRAPH
    {0x9B6C, 0x5B2A}, //4087 #CJK UNIFIED IDEOGRAPH
    {0x9B6D, 0x5B36}, //4088 #CJK UNIFIED IDEOGRAPH
    {0x9B6E, 0x5B3E}, //4089 #CJK UNIFIED IDEOGRAPH
    {0x9B6F, 0x5B43}, //4090 #CJK UNIFIED IDEOGRAPH
    {0x9B70, 0x5B45}, //4091 #CJK UNIFIED IDEOGRAPH
    {0x9B71, 0x5B40}, //4092 #CJK UNIFIED IDEOGRAPH
    {0x9B72, 0x5B51}, //4093 #CJK UNIFIED IDEOGRAPH
    {0x9B73, 0x5B55}, //4094 #CJK UNIFIED IDEOGRAPH
    {0x9B74, 0x5B5A}, //4095 #CJK UNIFIED IDEOGRAPH
    {0x9B75, 0x5B5B}, //4096 #CJK UNIFIED IDEOGRAPH
    {0x9B76, 0x5B65}, //4097 #CJK UNIFIED IDEOGRAPH
    {0x9B77, 0x5B69}, //4098 #CJK UNIFIED IDEOGRAPH
    {0x9B78, 0x5B70}, //4099 #CJK UNIFIED IDEOGRAPH
    {0x9B79, 0x5B73}, //4100 #CJK UNIFIED IDEOGRAPH
    {0x9B7A, 0x5B75}, //4101 #CJK UNIFIED IDEOGRAPH
    {0x9B7B, 0x5B78}, //4102 #CJK UNIFIED IDEOGRAPH
    {0x9B7C, 0x6588}, //4103 #CJK UNIFIED IDEOGRAPH
    {0x9B7D, 0x5B7A}, //4104 #CJK UNIFIED IDEOGRAPH
    {0x9B7E, 0x5B80}, //4105 #CJK UNIFIED IDEOGRAPH
    {0x9B80, 0x5B83}, //4106 #CJK UNIFIED IDEOGRAPH
    {0x9B81, 0x5BA6}, //4107 #CJK UNIFIED IDEOGRAPH
    {0x9B82, 0x5BB8}, //4108 #CJK UNIFIED IDEOGRAPH
    {0x9B83, 0x5BC3}, //4109 #CJK UNIFIED IDEOGRAPH
    {0x9B84, 0x5BC7}, //4110 #CJK UNIFIED IDEOGRAPH
    {0x9B85, 0x5BC9}, //4111 #CJK UNIFIED IDEOGRAPH
    {0x9B86, 0x5BD4}, //4112 #CJK UNIFIED IDEOGRAPH
    {0x9B87, 0x5BD0}, //4113 #CJK UNIFIED IDEOGRAPH
    {0x9B88, 0x5BE4}, //4114 #CJK UNIFIED IDEOGRAPH
    {0x9B89, 0x5BE6}, //4115 #CJK UNIFIED IDEOGRAPH
    {0x9B8A, 0x5BE2}, //4116 #CJK UNIFIED IDEOGRAPH
    {0x9B8B, 0x5BDE}, //4117 #CJK UNIFIED IDEOGRAPH
    {0x9B8C, 0x5BE5}, //4118 #CJK UNIFIED IDEOGRAPH
    {0x9B8D, 0x5BEB}, //4119 #CJK UNIFIED IDEOGRAPH
    {0x9B8E, 0x5BF0}, //4120 #CJK UNIFIED IDEOGRAPH
    {0x9B8F, 0x5BF6}, //4121 #CJK UNIFIED IDEOGRAPH
    {0x9B90, 0x5BF3}, //4122 #CJK UNIFIED IDEOGRAPH
    {0x9B91, 0x5C05}, //4123 #CJK UNIFIED IDEOGRAPH
    {0x9B92, 0x5C07}, //4124 #CJK UNIFIED IDEOGRAPH
    {0x9B93, 0x5C08}, //4125 #CJK UNIFIED IDEOGRAPH
    {0x9B94, 0x5C0D}, //4126 #CJK UNIFIED IDEOGRAPH
    {0x9B95, 0x5C13}, //4127 #CJK UNIFIED IDEOGRAPH
    {0x9B96, 0x5C20}, //4128 #CJK UNIFIED IDEOGRAPH
    {0x9B97, 0x5C22}, //4129 #CJK UNIFIED IDEOGRAPH
    {0x9B98, 0x5C28}, //4130 #CJK UNIFIED IDEOGRAPH
    {0x9B99, 0x5C38}, //4131 #CJK UNIFIED IDEOGRAPH
    {0x9B9A, 0x5C39}, //4132 #CJK UNIFIED IDEOGRAPH
    {0x9B9B, 0x5C41}, //4133 #CJK UNIFIED IDEOGRAPH
    {0x9B9C, 0x5C46}, //4134 #CJK UNIFIED IDEOGRAPH
    {0x9B9D, 0x5C4E}, //4135 #CJK UNIFIED IDEOGRAPH
    {0x9B9E, 0x5C53}, //4136 #CJK UNIFIED IDEOGRAPH
    {0x9B9F, 0x5C50}, //4137 #CJK UNIFIED IDEOGRAPH
    {0x9BA0, 0x5C4F}, //4138 #CJK UNIFIED IDEOGRAPH
    {0x9BA1, 0x5B71}, //4139 #CJK UNIFIED IDEOGRAPH
    {0x9BA2, 0x5C6C}, //4140 #CJK UNIFIED IDEOGRAPH
    {0x9BA3, 0x5C6E}, //4141 #CJK UNIFIED IDEOGRAPH
    {0x9BA4, 0x4E62}, //4142 #CJK UNIFIED IDEOGRAPH
    {0x9BA5, 0x5C76}, //4143 #CJK UNIFIED IDEOGRAPH
    {0x9BA6, 0x5C79}, //4144 #CJK UNIFIED IDEOGRAPH
    {0x9BA7, 0x5C8C}, //4145 #CJK UNIFIED IDEOGRAPH
    {0x9BA8, 0x5C91}, //4146 #CJK UNIFIED IDEOGRAPH
    {0x9BA9, 0x5C94}, //4147 #CJK UNIFIED IDEOGRAPH
    {0x9BAA, 0x599B}, //4148 #CJK UNIFIED IDEOGRAPH
    {0x9BAB, 0x5CAB}, //4149 #CJK UNIFIED IDEOGRAPH
    {0x9BAC, 0x5CBB}, //4150 #CJK UNIFIED IDEOGRAPH
    {0x9BAD, 0x5CB6}, //4151 #CJK UNIFIED IDEOGRAPH
    {0x9BAE, 0x5CBC}, //4152 #CJK UNIFIED IDEOGRAPH
    {0x9BAF, 0x5CB7}, //4153 #CJK UNIFIED IDEOGRAPH
    {0x9BB0, 0x5CC5}, //4154 #CJK UNIFIED IDEOGRAPH
    {0x9BB1, 0x5CBE}, //4155 #CJK UNIFIED IDEOGRAPH
    {0x9BB2, 0x5CC7}, //4156 #CJK UNIFIED IDEOGRAPH
    {0x9BB3, 0x5CD9}, //4157 #CJK UNIFIED IDEOGRAPH
    {0x9BB4, 0x5CE9}, //4158 #CJK UNIFIED IDEOGRAPH
    {0x9BB5, 0x5CFD}, //4159 #CJK UNIFIED IDEOGRAPH
    {0x9BB6, 0x5CFA}, //4160 #CJK UNIFIED IDEOGRAPH
    {0x9BB7, 0x5CED}, //4161 #CJK UNIFIED IDEOGRAPH
    {0x9BB8, 0x5D8C}, //4162 #CJK UNIFIED IDEOGRAPH
    {0x9BB9, 0x5CEA}, //4163 #CJK UNIFIED IDEOGRAPH
    {0x9BBA, 0x5D0B}, //4164 #CJK UNIFIED IDEOGRAPH
    {0x9BBB, 0x5D15}, //4165 #CJK UNIFIED IDEOGRAPH
    {0x9BBC, 0x5D17}, //4166 #CJK UNIFIED IDEOGRAPH
    {0x9BBD, 0x5D5C}, //4167 #CJK UNIFIED IDEOGRAPH
    {0x9BBE, 0x5D1F}, //4168 #CJK UNIFIED IDEOGRAPH
    {0x9BBF, 0x5D1B}, //4169 #CJK UNIFIED IDEOGRAPH
    {0x9BC0, 0x5D11}, //4170 #CJK UNIFIED IDEOGRAPH
    {0x9BC1, 0x5D14}, //4171 #CJK UNIFIED IDEOGRAPH
    {0x9BC2, 0x5D22}, //4172 #CJK UNIFIED IDEOGRAPH
    {0x9BC3, 0x5D1A}, //4173 #CJK UNIFIED IDEOGRAPH
    {0x9BC4, 0x5D19}, //4174 #CJK UNIFIED IDEOGRAPH
    {0x9BC5, 0x5D18}, //4175 #CJK UNIFIED IDEOGRAPH
    {0x9BC6, 0x5D4C}, //4176 #CJK UNIFIED IDEOGRAPH
    {0x9BC7, 0x5D52}, //4177 #CJK UNIFIED IDEOGRAPH
    {0x9BC8, 0x5D4E}, //4178 #CJK UNIFIED IDEOGRAPH
    {0x9BC9, 0x5D4B}, //4179 #CJK UNIFIED IDEOGRAPH
    {0x9BCA, 0x5D6C}, //4180 #CJK UNIFIED IDEOGRAPH
    {0x9BCB, 0x5D73}, //4181 #CJK UNIFIED IDEOGRAPH
    {0x9BCC, 0x5D76}, //4182 #CJK UNIFIED IDEOGRAPH
    {0x9BCD, 0x5D87}, //4183 #CJK UNIFIED IDEOGRAPH
    {0x9BCE, 0x5D84}, //4184 #CJK UNIFIED IDEOGRAPH
    {0x9BCF, 0x5D82}, //4185 #CJK UNIFIED IDEOGRAPH
    {0x9BD0, 0x5DA2}, //4186 #CJK UNIFIED IDEOGRAPH
    {0x9BD1, 0x5D9D}, //4187 #CJK UNIFIED IDEOGRAPH
    {0x9BD2, 0x5DAC}, //4188 #CJK UNIFIED IDEOGRAPH
    {0x9BD3, 0x5DAE}, //4189 #CJK UNIFIED IDEOGRAPH
    {0x9BD4, 0x5DBD}, //4190 #CJK UNIFIED IDEOGRAPH
    {0x9BD5, 0x5D90}, //4191 #CJK UNIFIED IDEOGRAPH
    {0x9BD6, 0x5DB7}, //4192 #CJK UNIFIED IDEOGRAPH
    {0x9BD7, 0x5DBC}, //4193 #CJK UNIFIED IDEOGRAPH
    {0x9BD8, 0x5DC9}, //4194 #CJK UNIFIED IDEOGRAPH
    {0x9BD9, 0x5DCD}, //4195 #CJK UNIFIED IDEOGRAPH
    {0x9BDA, 0x5DD3}, //4196 #CJK UNIFIED IDEOGRAPH
    {0x9BDB, 0x5DD2}, //4197 #CJK UNIFIED IDEOGRAPH
    {0x9BDC, 0x5DD6}, //4198 #CJK UNIFIED IDEOGRAPH
    {0x9BDD, 0x5DDB}, //4199 #CJK UNIFIED IDEOGRAPH
    {0x9BDE, 0x5DEB}, //4200 #CJK UNIFIED IDEOGRAPH
    {0x9BDF, 0x5DF2}, //4201 #CJK UNIFIED IDEOGRAPH
    {0x9BE0, 0x5DF5}, //4202 #CJK UNIFIED IDEOGRAPH
    {0x9BE1, 0x5E0B}, //4203 #CJK UNIFIED IDEOGRAPH
    {0x9BE2, 0x5E1A}, //4204 #CJK UNIFIED IDEOGRAPH
    {0x9BE3, 0x5E19}, //4205 #CJK UNIFIED IDEOGRAPH
    {0x9BE4, 0x5E11}, //4206 #CJK UNIFIED IDEOGRAPH
    {0x9BE5, 0x5E1B}, //4207 #CJK UNIFIED IDEOGRAPH
    {0x9BE6, 0x5E36}, //4208 #CJK UNIFIED IDEOGRAPH
    {0x9BE7, 0x5E37}, //4209 #CJK UNIFIED IDEOGRAPH
    {0x9BE8, 0x5E44}, //4210 #CJK UNIFIED IDEOGRAPH
    {0x9BE9, 0x5E43}, //4211 #CJK UNIFIED IDEOGRAPH
    {0x9BEA, 0x5E40}, //4212 #CJK UNIFIED IDEOGRAPH
    {0x9BEB, 0x5E4E}, //4213 #CJK UNIFIED IDEOGRAPH
    {0x9BEC, 0x5E57}, //4214 #CJK UNIFIED IDEOGRAPH
    {0x9BED, 0x5E54}, //4215 #CJK UNIFIED IDEOGRAPH
    {0x9BEE, 0x5E5F}, //4216 #CJK UNIFIED IDEOGRAPH
    {0x9BEF, 0x5E62}, //4217 #CJK UNIFIED IDEOGRAPH
    {0x9BF0, 0x5E64}, //4218 #CJK UNIFIED IDEOGRAPH
    {0x9BF1, 0x5E47}, //4219 #CJK UNIFIED IDEOGRAPH
    {0x9BF2, 0x5E75}, //4220 #CJK UNIFIED IDEOGRAPH
    {0x9BF3, 0x5E76}, //4221 #CJK UNIFIED IDEOGRAPH
    {0x9BF4, 0x5E7A}, //4222 #CJK UNIFIED IDEOGRAPH
    {0x9BF5, 0x9EBC}, //4223 #CJK UNIFIED IDEOGRAPH
    {0x9BF6, 0x5E7F}, //4224 #CJK UNIFIED IDEOGRAPH
    {0x9BF7, 0x5EA0}, //4225 #CJK UNIFIED IDEOGRAPH
    {0x9BF8, 0x5EC1}, //4226 #CJK UNIFIED IDEOGRAPH
    {0x9BF9, 0x5EC2}, //4227 #CJK UNIFIED IDEOGRAPH
    {0x9BFA, 0x5EC8}, //4228 #CJK UNIFIED IDEOGRAPH
    {0x9BFB, 0x5ED0}, //4229 #CJK UNIFIED IDEOGRAPH
    {0x9BFC, 0x5ECF}, //4230 #CJK UNIFIED IDEOGRAPH
    {0x9C40, 0x5ED6}, //4231 #CJK UNIFIED IDEOGRAPH
    {0x9C41, 0x5EE3}, //4232 #CJK UNIFIED IDEOGRAPH
    {0x9C42, 0x5EDD}, //4233 #CJK UNIFIED IDEOGRAPH
    {0x9C43, 0x5EDA}, //4234 #CJK UNIFIED IDEOGRAPH
    {0x9C44, 0x5EDB}, //4235 #CJK UNIFIED IDEOGRAPH
    {0x9C45, 0x5EE2}, //4236 #CJK UNIFIED IDEOGRAPH
    {0x9C46, 0x5EE1}, //4237 #CJK UNIFIED IDEOGRAPH
    {0x9C47, 0x5EE8}, //4238 #CJK UNIFIED IDEOGRAPH
    {0x9C48, 0x5EE9}, //4239 #CJK UNIFIED IDEOGRAPH
    {0x9C49, 0x5EEC}, //4240 #CJK UNIFIED IDEOGRAPH
    {0x9C4A, 0x5EF1}, //4241 #CJK UNIFIED IDEOGRAPH
    {0x9C4B, 0x5EF3}, //4242 #CJK UNIFIED IDEOGRAPH
    {0x9C4C, 0x5EF0}, //4243 #CJK UNIFIED IDEOGRAPH
    {0x9C4D, 0x5EF4}, //4244 #CJK UNIFIED IDEOGRAPH
    {0x9C4E, 0x5EF8}, //4245 #CJK UNIFIED IDEOGRAPH
    {0x9C4F, 0x5EFE}, //4246 #CJK UNIFIED IDEOGRAPH
    {0x9C50, 0x5F03}, //4247 #CJK UNIFIED IDEOGRAPH
    {0x9C51, 0x5F09}, //4248 #CJK UNIFIED IDEOGRAPH
    {0x9C52, 0x5F5D}, //4249 #CJK UNIFIED IDEOGRAPH
    {0x9C53, 0x5F5C}, //4250 #CJK UNIFIED IDEOGRAPH
    {0x9C54, 0x5F0B}, //4251 #CJK UNIFIED IDEOGRAPH
    {0x9C55, 0x5F11}, //4252 #CJK UNIFIED IDEOGRAPH
    {0x9C56, 0x5F16}, //4253 #CJK UNIFIED IDEOGRAPH
    {0x9C57, 0x5F29}, //4254 #CJK UNIFIED IDEOGRAPH
    {0x9C58, 0x5F2D}, //4255 #CJK UNIFIED IDEOGRAPH
    {0x9C59, 0x5F38}, //4256 #CJK UNIFIED IDEOGRAPH
    {0x9C5A, 0x5F41}, //4257 #CJK UNIFIED IDEOGRAPH
    {0x9C5B, 0x5F48}, //4258 #CJK UNIFIED IDEOGRAPH
    {0x9C5C, 0x5F4C}, //4259 #CJK UNIFIED IDEOGRAPH
    {0x9C5D, 0x5F4E}, //4260 #CJK UNIFIED IDEOGRAPH
    {0x9C5E, 0x5F2F}, //4261 #CJK UNIFIED IDEOGRAPH
    {0x9C5F, 0x5F51}, //4262 #CJK UNIFIED IDEOGRAPH
    {0x9C60, 0x5F56}, //4263 #CJK UNIFIED IDEOGRAPH
    {0x9C61, 0x5F57}, //4264 #CJK UNIFIED IDEOGRAPH
    {0x9C62, 0x5F59}, //4265 #CJK UNIFIED IDEOGRAPH
    {0x9C63, 0x5F61}, //4266 #CJK UNIFIED IDEOGRAPH
    {0x9C64, 0x5F6D}, //4267 #CJK UNIFIED IDEOGRAPH
    {0x9C65, 0x5F73}, //4268 #CJK UNIFIED IDEOGRAPH
    {0x9C66, 0x5F77}, //4269 #CJK UNIFIED IDEOGRAPH
    {0x9C67, 0x5F83}, //4270 #CJK UNIFIED IDEOGRAPH
    {0x9C68, 0x5F82}, //4271 #CJK UNIFIED IDEOGRAPH
    {0x9C69, 0x5F7F}, //4272 #CJK UNIFIED IDEOGRAPH
    {0x9C6A, 0x5F8A}, //4273 #CJK UNIFIED IDEOGRAPH
    {0x9C6B, 0x5F88}, //4274 #CJK UNIFIED IDEOGRAPH
    {0x9C6C, 0x5F91}, //4275 #CJK UNIFIED IDEOGRAPH
    {0x9C6D, 0x5F87}, //4276 #CJK UNIFIED IDEOGRAPH
    {0x9C6E, 0x5F9E}, //4277 #CJK UNIFIED IDEOGRAPH
    {0x9C6F, 0x5F99}, //4278 #CJK UNIFIED IDEOGRAPH
    {0x9C70, 0x5F98}, //4279 #CJK UNIFIED IDEOGRAPH
    {0x9C71, 0x5FA0}, //4280 #CJK UNIFIED IDEOGRAPH
    {0x9C72, 0x5FA8}, //4281 #CJK UNIFIED IDEOGRAPH
    {0x9C73, 0x5FAD}, //4282 #CJK UNIFIED IDEOGRAPH
    {0x9C74, 0x5FBC}, //4283 #CJK UNIFIED IDEOGRAPH
    {0x9C75, 0x5FD6}, //4284 #CJK UNIFIED IDEOGRAPH
    {0x9C76, 0x5FFB}, //4285 #CJK UNIFIED IDEOGRAPH
    {0x9C77, 0x5FE4}, //4286 #CJK UNIFIED IDEOGRAPH
    {0x9C78, 0x5FF8}, //4287 #CJK UNIFIED IDEOGRAPH
    {0x9C79, 0x5FF1}, //4288 #CJK UNIFIED IDEOGRAPH
    {0x9C7A, 0x5FDD}, //4289 #CJK UNIFIED IDEOGRAPH
    {0x9C7B, 0x60B3}, //4290 #CJK UNIFIED IDEOGRAPH
    {0x9C7C, 0x5FFF}, //4291 #CJK UNIFIED IDEOGRAPH
    {0x9C7D, 0x6021}, //4292 #CJK UNIFIED IDEOGRAPH
    {0x9C7E, 0x6060}, //4293 #CJK UNIFIED IDEOGRAPH
    {0x9C80, 0x6019}, //4294 #CJK UNIFIED IDEOGRAPH
    {0x9C81, 0x6010}, //4295 #CJK UNIFIED IDEOGRAPH
    {0x9C82, 0x6029}, //4296 #CJK UNIFIED IDEOGRAPH
    {0x9C83, 0x600E}, //4297 #CJK UNIFIED IDEOGRAPH
    {0x9C84, 0x6031}, //4298 #CJK UNIFIED IDEOGRAPH
    {0x9C85, 0x601B}, //4299 #CJK UNIFIED IDEOGRAPH
    {0x9C86, 0x6015}, //4300 #CJK UNIFIED IDEOGRAPH
    {0x9C87, 0x602B}, //4301 #CJK UNIFIED IDEOGRAPH
    {0x9C88, 0x6026}, //4302 #CJK UNIFIED IDEOGRAPH
    {0x9C89, 0x600F}, //4303 #CJK UNIFIED IDEOGRAPH
    {0x9C8A, 0x603A}, //4304 #CJK UNIFIED IDEOGRAPH
    {0x9C8B, 0x605A}, //4305 #CJK UNIFIED IDEOGRAPH
    {0x9C8C, 0x6041}, //4306 #CJK UNIFIED IDEOGRAPH
    {0x9C8D, 0x606A}, //4307 #CJK UNIFIED IDEOGRAPH
    {0x9C8E, 0x6077}, //4308 #CJK UNIFIED IDEOGRAPH
    {0x9C8F, 0x605F}, //4309 #CJK UNIFIED IDEOGRAPH
    {0x9C90, 0x604A}, //4310 #CJK UNIFIED IDEOGRAPH
    {0x9C91, 0x6046}, //4311 #CJK UNIFIED IDEOGRAPH
    {0x9C92, 0x604D}, //4312 #CJK UNIFIED IDEOGRAPH
    {0x9C93, 0x6063}, //4313 #CJK UNIFIED IDEOGRAPH
    {0x9C94, 0x6043}, //4314 #CJK UNIFIED IDEOGRAPH
    {0x9C95, 0x6064}, //4315 #CJK UNIFIED IDEOGRAPH
    {0x9C96, 0x6042}, //4316 #CJK UNIFIED IDEOGRAPH
    {0x9C97, 0x606C}, //4317 #CJK UNIFIED IDEOGRAPH
    {0x9C98, 0x606B}, //4318 #CJK UNIFIED IDEOGRAPH
    {0x9C99, 0x6059}, //4319 #CJK UNIFIED IDEOGRAPH
    {0x9C9A, 0x6081}, //4320 #CJK UNIFIED IDEOGRAPH
    {0x9C9B, 0x608D}, //4321 #CJK UNIFIED IDEOGRAPH
    {0x9C9C, 0x60E7}, //4322 #CJK UNIFIED IDEOGRAPH
    {0x9C9D, 0x6083}, //4323 #CJK UNIFIED IDEOGRAPH
    {0x9C9E, 0x609A}, //4324 #CJK UNIFIED IDEOGRAPH
    {0x9C9F, 0x6084}, //4325 #CJK UNIFIED IDEOGRAPH
    {0x9CA0, 0x609B}, //4326 #CJK UNIFIED IDEOGRAPH
    {0x9CA1, 0x6096}, //4327 #CJK UNIFIED IDEOGRAPH
    {0x9CA2, 0x6097}, //4328 #CJK UNIFIED IDEOGRAPH
    {0x9CA3, 0x6092}, //4329 #CJK UNIFIED IDEOGRAPH
    {0x9CA4, 0x60A7}, //4330 #CJK UNIFIED IDEOGRAPH
    {0x9CA5, 0x608B}, //4331 #CJK UNIFIED IDEOGRAPH
    {0x9CA6, 0x60E1}, //4332 #CJK UNIFIED IDEOGRAPH
    {0x9CA7, 0x60B8}, //4333 #CJK UNIFIED IDEOGRAPH
    {0x9CA8, 0x60E0}, //4334 #CJK UNIFIED IDEOGRAPH
    {0x9CA9, 0x60D3}, //4335 #CJK UNIFIED IDEOGRAPH
    {0x9CAA, 0x60B4}, //4336 #CJK UNIFIED IDEOGRAPH
    {0x9CAB, 0x5FF0}, //4337 #CJK UNIFIED IDEOGRAPH
    {0x9CAC, 0x60BD}, //4338 #CJK UNIFIED IDEOGRAPH
    {0x9CAD, 0x60C6}, //4339 #CJK UNIFIED IDEOGRAPH
    {0x9CAE, 0x60B5}, //4340 #CJK UNIFIED IDEOGRAPH
    {0x9CAF, 0x60D8}, //4341 #CJK UNIFIED IDEOGRAPH
    {0x9CB0, 0x614D}, //4342 #CJK UNIFIED IDEOGRAPH
    {0x9CB1, 0x6115}, //4343 #CJK UNIFIED IDEOGRAPH
    {0x9CB2, 0x6106}, //4344 #CJK UNIFIED IDEOGRAPH
    {0x9CB3, 0x60F6}, //4345 #CJK UNIFIED IDEOGRAPH
    {0x9CB4, 0x60F7}, //4346 #CJK UNIFIED IDEOGRAPH
    {0x9CB5, 0x6100}, //4347 #CJK UNIFIED IDEOGRAPH
    {0x9CB6, 0x60F4}, //4348 #CJK UNIFIED IDEOGRAPH
    {0x9CB7, 0x60FA}, //4349 #CJK UNIFIED IDEOGRAPH
    {0x9CB8, 0x6103}, //4350 #CJK UNIFIED IDEOGRAPH
    {0x9CB9, 0x6121}, //4351 #CJK UNIFIED IDEOGRAPH
    {0x9CBA, 0x60FB}, //4352 #CJK UNIFIED IDEOGRAPH
    {0x9CBB, 0x60F1}, //4353 #CJK UNIFIED IDEOGRAPH
    {0x9CBC, 0x610D}, //4354 #CJK UNIFIED IDEOGRAPH
    {0x9CBD, 0x610E}, //4355 #CJK UNIFIED IDEOGRAPH
    {0x9CBE, 0x6147}, //4356 #CJK UNIFIED IDEOGRAPH
    {0x9CBF, 0x613E}, //4357 #CJK UNIFIED IDEOGRAPH
    {0x9CC0, 0x6128}, //4358 #CJK UNIFIED IDEOGRAPH
    {0x9CC1, 0x6127}, //4359 #CJK UNIFIED IDEOGRAPH
    {0x9CC2, 0x614A}, //4360 #CJK UNIFIED IDEOGRAPH
    {0x9CC3, 0x613F}, //4361 #CJK UNIFIED IDEOGRAPH
    {0x9CC4, 0x613C}, //4362 #CJK UNIFIED IDEOGRAPH
    {0x9CC5, 0x612C}, //4363 #CJK UNIFIED IDEOGRAPH
    {0x9CC6, 0x6134}, //4364 #CJK UNIFIED IDEOGRAPH
    {0x9CC7, 0x613D}, //4365 #CJK UNIFIED IDEOGRAPH
    {0x9CC8, 0x6142}, //4366 #CJK UNIFIED IDEOGRAPH
    {0x9CC9, 0x6144}, //4367 #CJK UNIFIED IDEOGRAPH
    {0x9CCA, 0x6173}, //4368 #CJK UNIFIED IDEOGRAPH
    {0x9CCB, 0x6177}, //4369 #CJK UNIFIED IDEOGRAPH
    {0x9CCC, 0x6158}, //4370 #CJK UNIFIED IDEOGRAPH
    {0x9CCD, 0x6159}, //4371 #CJK UNIFIED IDEOGRAPH
    {0x9CCE, 0x615A}, //4372 #CJK UNIFIED IDEOGRAPH
    {0x9CCF, 0x616B}, //4373 #CJK UNIFIED IDEOGRAPH
    {0x9CD0, 0x6174}, //4374 #CJK UNIFIED IDEOGRAPH
    {0x9CD1, 0x616F}, //4375 #CJK UNIFIED IDEOGRAPH
    {0x9CD2, 0x6165}, //4376 #CJK UNIFIED IDEOGRAPH
    {0x9CD3, 0x6171}, //4377 #CJK UNIFIED IDEOGRAPH
    {0x9CD4, 0x615F}, //4378 #CJK UNIFIED IDEOGRAPH
    {0x9CD5, 0x615D}, //4379 #CJK UNIFIED IDEOGRAPH
    {0x9CD6, 0x6153}, //4380 #CJK UNIFIED IDEOGRAPH
    {0x9CD7, 0x6175}, //4381 #CJK UNIFIED IDEOGRAPH
    {0x9CD8, 0x6199}, //4382 #CJK UNIFIED IDEOGRAPH
    {0x9CD9, 0x6196}, //4383 #CJK UNIFIED IDEOGRAPH
    {0x9CDA, 0x6187}, //4384 #CJK UNIFIED IDEOGRAPH
    {0x9CDB, 0x61AC}, //4385 #CJK UNIFIED IDEOGRAPH
    {0x9CDC, 0x6194}, //4386 #CJK UNIFIED IDEOGRAPH
    {0x9CDD, 0x619A}, //4387 #CJK UNIFIED IDEOGRAPH
    {0x9CDE, 0x618A}, //4388 #CJK UNIFIED IDEOGRAPH
    {0x9CDF, 0x6191}, //4389 #CJK UNIFIED IDEOGRAPH
    {0x9CE0, 0x61AB}, //4390 #CJK UNIFIED IDEOGRAPH
    {0x9CE1, 0x61AE}, //4391 #CJK UNIFIED IDEOGRAPH
    {0x9CE2, 0x61CC}, //4392 #CJK UNIFIED IDEOGRAPH
    {0x9CE3, 0x61CA}, //4393 #CJK UNIFIED IDEOGRAPH
    {0x9CE4, 0x61C9}, //4394 #CJK UNIFIED IDEOGRAPH
    {0x9CE5, 0x61F7}, //4395 #CJK UNIFIED IDEOGRAPH
    {0x9CE6, 0x61C8}, //4396 #CJK UNIFIED IDEOGRAPH
    {0x9CE7, 0x61C3}, //4397 #CJK UNIFIED IDEOGRAPH
    {0x9CE8, 0x61C6}, //4398 #CJK UNIFIED IDEOGRAPH
    {0x9CE9, 0x61BA}, //4399 #CJK UNIFIED IDEOGRAPH
    {0x9CEA, 0x61CB}, //4400 #CJK UNIFIED IDEOGRAPH
    {0x9CEB, 0x7F79}, //4401 #CJK UNIFIED IDEOGRAPH
    {0x9CEC, 0x61CD}, //4402 #CJK UNIFIED IDEOGRAPH
    {0x9CED, 0x61E6}, //4403 #CJK UNIFIED IDEOGRAPH
    {0x9CEE, 0x61E3}, //4404 #CJK UNIFIED IDEOGRAPH
    {0x9CEF, 0x61F6}, //4405 #CJK UNIFIED IDEOGRAPH
    {0x9CF0, 0x61FA}, //4406 #CJK UNIFIED IDEOGRAPH
    {0x9CF1, 0x61F4}, //4407 #CJK UNIFIED IDEOGRAPH
    {0x9CF2, 0x61FF}, //4408 #CJK UNIFIED IDEOGRAPH
    {0x9CF3, 0x61FD}, //4409 #CJK UNIFIED IDEOGRAPH
    {0x9CF4, 0x61FC}, //4410 #CJK UNIFIED IDEOGRAPH
    {0x9CF5, 0x61FE}, //4411 #CJK UNIFIED IDEOGRAPH
    {0x9CF6, 0x6200}, //4412 #CJK UNIFIED IDEOGRAPH
    {0x9CF7, 0x6208}, //4413 #CJK UNIFIED IDEOGRAPH
    {0x9CF8, 0x6209}, //4414 #CJK UNIFIED IDEOGRAPH
    {0x9CF9, 0x620D}, //4415 #CJK UNIFIED IDEOGRAPH
    {0x9CFA, 0x620C}, //4416 #CJK UNIFIED IDEOGRAPH
    {0x9CFB, 0x6214}, //4417 #CJK UNIFIED IDEOGRAPH
    {0x9CFC, 0x621B}, //4418 #CJK UNIFIED IDEOGRAPH
    {0x9D40, 0x621E}, //4419 #CJK UNIFIED IDEOGRAPH
    {0x9D41, 0x6221}, //4420 #CJK UNIFIED IDEOGRAPH
    {0x9D42, 0x622A}, //4421 #CJK UNIFIED IDEOGRAPH
    {0x9D43, 0x622E}, //4422 #CJK UNIFIED IDEOGRAPH
    {0x9D44, 0x6230}, //4423 #CJK UNIFIED IDEOGRAPH
    {0x9D45, 0x6232}, //4424 #CJK UNIFIED IDEOGRAPH
    {0x9D46, 0x6233}, //4425 #CJK UNIFIED IDEOGRAPH
    {0x9D47, 0x6241}, //4426 #CJK UNIFIED IDEOGRAPH
    {0x9D48, 0x624E}, //4427 #CJK UNIFIED IDEOGRAPH
    {0x9D49, 0x625E}, //4428 #CJK UNIFIED IDEOGRAPH
    {0x9D4A, 0x6263}, //4429 #CJK UNIFIED IDEOGRAPH
    {0x9D4B, 0x625B}, //4430 #CJK UNIFIED IDEOGRAPH
    {0x9D4C, 0x6260}, //4431 #CJK UNIFIED IDEOGRAPH
    {0x9D4D, 0x6268}, //4432 #CJK UNIFIED IDEOGRAPH
    {0x9D4E, 0x627C}, //4433 #CJK UNIFIED IDEOGRAPH
    {0x9D4F, 0x6282}, //4434 #CJK UNIFIED IDEOGRAPH
    {0x9D50, 0x6289}, //4435 #CJK UNIFIED IDEOGRAPH
    {0x9D51, 0x627E}, //4436 #CJK UNIFIED IDEOGRAPH
    {0x9D52, 0x6292}, //4437 #CJK UNIFIED IDEOGRAPH
    {0x9D53, 0x6293}, //4438 #CJK UNIFIED IDEOGRAPH
    {0x9D54, 0x6296}, //4439 #CJK UNIFIED IDEOGRAPH
    {0x9D55, 0x62D4}, //4440 #CJK UNIFIED IDEOGRAPH
    {0x9D56, 0x6283}, //4441 #CJK UNIFIED IDEOGRAPH
    {0x9D57, 0x6294}, //4442 #CJK UNIFIED IDEOGRAPH
    {0x9D58, 0x62D7}, //4443 #CJK UNIFIED IDEOGRAPH
    {0x9D59, 0x62D1}, //4444 #CJK UNIFIED IDEOGRAPH
    {0x9D5A, 0x62BB}, //4445 #CJK UNIFIED IDEOGRAPH
    {0x9D5B, 0x62CF}, //4446 #CJK UNIFIED IDEOGRAPH
    {0x9D5C, 0x62FF}, //4447 #CJK UNIFIED IDEOGRAPH
    {0x9D5D, 0x62C6}, //4448 #CJK UNIFIED IDEOGRAPH
    {0x9D5E, 0x64D4}, //4449 #CJK UNIFIED IDEOGRAPH
    {0x9D5F, 0x62C8}, //4450 #CJK UNIFIED IDEOGRAPH
    {0x9D60, 0x62DC}, //4451 #CJK UNIFIED IDEOGRAPH
    {0x9D61, 0x62CC}, //4452 #CJK UNIFIED IDEOGRAPH
    {0x9D62, 0x62CA}, //4453 #CJK UNIFIED IDEOGRAPH
    {0x9D63, 0x62C2}, //4454 #CJK UNIFIED IDEOGRAPH
    {0x9D64, 0x62C7}, //4455 #CJK UNIFIED IDEOGRAPH
    {0x9D65, 0x629B}, //4456 #CJK UNIFIED IDEOGRAPH
    {0x9D66, 0x62C9}, //4457 #CJK UNIFIED IDEOGRAPH
    {0x9D67, 0x630C}, //4458 #CJK UNIFIED IDEOGRAPH
    {0x9D68, 0x62EE}, //4459 #CJK UNIFIED IDEOGRAPH
    {0x9D69, 0x62F1}, //4460 #CJK UNIFIED IDEOGRAPH
    {0x9D6A, 0x6327}, //4461 #CJK UNIFIED IDEOGRAPH
    {0x9D6B, 0x6302}, //4462 #CJK UNIFIED IDEOGRAPH
    {0x9D6C, 0x6308}, //4463 #CJK UNIFIED IDEOGRAPH
    {0x9D6D, 0x62EF}, //4464 #CJK UNIFIED IDEOGRAPH
    {0x9D6E, 0x62F5}, //4465 #CJK UNIFIED IDEOGRAPH
    {0x9D6F, 0x6350}, //4466 #CJK UNIFIED IDEOGRAPH
    {0x9D70, 0x633E}, //4467 #CJK UNIFIED IDEOGRAPH
    {0x9D71, 0x634D}, //4468 #CJK UNIFIED IDEOGRAPH
    {0x9D72, 0x641C}, //4469 #CJK UNIFIED IDEOGRAPH
    {0x9D73, 0x634F}, //4470 #CJK UNIFIED IDEOGRAPH
    {0x9D74, 0x6396}, //4471 #CJK UNIFIED IDEOGRAPH
    {0x9D75, 0x638E}, //4472 #CJK UNIFIED IDEOGRAPH
    {0x9D76, 0x6380}, //4473 #CJK UNIFIED IDEOGRAPH
    {0x9D77, 0x63AB}, //4474 #CJK UNIFIED IDEOGRAPH
    {0x9D78, 0x6376}, //4475 #CJK UNIFIED IDEOGRAPH
    {0x9D79, 0x63A3}, //4476 #CJK UNIFIED IDEOGRAPH
    {0x9D7A, 0x638F}, //4477 #CJK UNIFIED IDEOGRAPH
    {0x9D7B, 0x6389}, //4478 #CJK UNIFIED IDEOGRAPH
    {0x9D7C, 0x639F}, //4479 #CJK UNIFIED IDEOGRAPH
    {0x9D7D, 0x63B5}, //4480 #CJK UNIFIED IDEOGRAPH
    {0x9D7E, 0x636B}, //4481 #CJK UNIFIED IDEOGRAPH
    {0x9D80, 0x6369}, //4482 #CJK UNIFIED IDEOGRAPH
    {0x9D81, 0x63BE}, //4483 #CJK UNIFIED IDEOGRAPH
    {0x9D82, 0x63E9}, //4484 #CJK UNIFIED IDEOGRAPH
    {0x9D83, 0x63C0}, //4485 #CJK UNIFIED IDEOGRAPH
    {0x9D84, 0x63C6}, //4486 #CJK UNIFIED IDEOGRAPH
    {0x9D85, 0x63E3}, //4487 #CJK UNIFIED IDEOGRAPH
    {0x9D86, 0x63C9}, //4488 #CJK UNIFIED IDEOGRAPH
    {0x9D87, 0x63D2}, //4489 #CJK UNIFIED IDEOGRAPH
    {0x9D88, 0x63F6}, //4490 #CJK UNIFIED IDEOGRAPH
    {0x9D89, 0x63C4}, //4491 #CJK UNIFIED IDEOGRAPH
    {0x9D8A, 0x6416}, //4492 #CJK UNIFIED IDEOGRAPH
    {0x9D8B, 0x6434}, //4493 #CJK UNIFIED IDEOGRAPH
    {0x9D8C, 0x6406}, //4494 #CJK UNIFIED IDEOGRAPH
    {0x9D8D, 0x6413}, //4495 #CJK UNIFIED IDEOGRAPH
    {0x9D8E, 0x6426}, //4496 #CJK UNIFIED IDEOGRAPH
    {0x9D8F, 0x6436}, //4497 #CJK UNIFIED IDEOGRAPH
    {0x9D90, 0x651D}, //4498 #CJK UNIFIED IDEOGRAPH
    {0x9D91, 0x6417}, //4499 #CJK UNIFIED IDEOGRAPH
    {0x9D92, 0x6428}, //4500 #CJK UNIFIED IDEOGRAPH
    {0x9D93, 0x640F}, //4501 #CJK UNIFIED IDEOGRAPH
    {0x9D94, 0x6467}, //4502 #CJK UNIFIED IDEOGRAPH
    {0x9D95, 0x646F}, //4503 #CJK UNIFIED IDEOGRAPH
    {0x9D96, 0x6476}, //4504 #CJK UNIFIED IDEOGRAPH
    {0x9D97, 0x644E}, //4505 #CJK UNIFIED IDEOGRAPH
    {0x9D98, 0x652A}, //4506 #CJK UNIFIED IDEOGRAPH
    {0x9D99, 0x6495}, //4507 #CJK UNIFIED IDEOGRAPH
    {0x9D9A, 0x6493}, //4508 #CJK UNIFIED IDEOGRAPH
    {0x9D9B, 0x64A5}, //4509 #CJK UNIFIED IDEOGRAPH
    {0x9D9C, 0x64A9}, //4510 #CJK UNIFIED IDEOGRAPH
    {0x9D9D, 0x6488}, //4511 #CJK UNIFIED IDEOGRAPH
    {0x9D9E, 0x64BC}, //4512 #CJK UNIFIED IDEOGRAPH
    {0x9D9F, 0x64DA}, //4513 #CJK UNIFIED IDEOGRAPH
    {0x9DA0, 0x64D2}, //4514 #CJK UNIFIED IDEOGRAPH
    {0x9DA1, 0x64C5}, //4515 #CJK UNIFIED IDEOGRAPH
    {0x9DA2, 0x64C7}, //4516 #CJK UNIFIED IDEOGRAPH
    {0x9DA3, 0x64BB}, //4517 #CJK UNIFIED IDEOGRAPH
    {0x9DA4, 0x64D8}, //4518 #CJK UNIFIED IDEOGRAPH
    {0x9DA5, 0x64C2}, //4519 #CJK UNIFIED IDEOGRAPH
    {0x9DA6, 0x64F1}, //4520 #CJK UNIFIED IDEOGRAPH
    {0x9DA7, 0x64E7}, //4521 #CJK UNIFIED IDEOGRAPH
    {0x9DA8, 0x8209}, //4522 #CJK UNIFIED IDEOGRAPH
    {0x9DA9, 0x64E0}, //4523 #CJK UNIFIED IDEOGRAPH
    {0x9DAA, 0x64E1}, //4524 #CJK UNIFIED IDEOGRAPH
    {0x9DAB, 0x62AC}, //4525 #CJK UNIFIED IDEOGRAPH
    {0x9DAC, 0x64E3}, //4526 #CJK UNIFIED IDEOGRAPH
    {0x9DAD, 0x64EF}, //4527 #CJK UNIFIED IDEOGRAPH
    {0x9DAE, 0x652C}, //4528 #CJK UNIFIED IDEOGRAPH
    {0x9DAF, 0x64F6}, //4529 #CJK UNIFIED IDEOGRAPH
    {0x9DB0, 0x64F4}, //4530 #CJK UNIFIED IDEOGRAPH
    {0x9DB1, 0x64F2}, //4531 #CJK UNIFIED IDEOGRAPH
    {0x9DB2, 0x64FA}, //4532 #CJK UNIFIED IDEOGRAPH
    {0x9DB3, 0x6500}, //4533 #CJK UNIFIED IDEOGRAPH
    {0x9DB4, 0x64FD}, //4534 #CJK UNIFIED IDEOGRAPH
    {0x9DB5, 0x6518}, //4535 #CJK UNIFIED IDEOGRAPH
    {0x9DB6, 0x651C}, //4536 #CJK UNIFIED IDEOGRAPH
    {0x9DB7, 0x6505}, //4537 #CJK UNIFIED IDEOGRAPH
    {0x9DB8, 0x6524}, //4538 #CJK UNIFIED IDEOGRAPH
    {0x9DB9, 0x6523}, //4539 #CJK UNIFIED IDEOGRAPH
    {0x9DBA, 0x652B}, //4540 #CJK UNIFIED IDEOGRAPH
    {0x9DBB, 0x6534}, //4541 #CJK UNIFIED IDEOGRAPH
    {0x9DBC, 0x6535}, //4542 #CJK UNIFIED IDEOGRAPH
    {0x9DBD, 0x6537}, //4543 #CJK UNIFIED IDEOGRAPH
    {0x9DBE, 0x6536}, //4544 #CJK UNIFIED IDEOGRAPH
    {0x9DBF, 0x6538}, //4545 #CJK UNIFIED IDEOGRAPH
    {0x9DC0, 0x754B}, //4546 #CJK UNIFIED IDEOGRAPH
    {0x9DC1, 0x6548}, //4547 #CJK UNIFIED IDEOGRAPH
    {0x9DC2, 0x6556}, //4548 #CJK UNIFIED IDEOGRAPH
    {0x9DC3, 0x6555}, //4549 #CJK UNIFIED IDEOGRAPH
    {0x9DC4, 0x654D}, //4550 #CJK UNIFIED IDEOGRAPH
    {0x9DC5, 0x6558}, //4551 #CJK UNIFIED IDEOGRAPH
    {0x9DC6, 0x655E}, //4552 #CJK UNIFIED IDEOGRAPH
    {0x9DC7, 0x655D}, //4553 #CJK UNIFIED IDEOGRAPH
    {0x9DC8, 0x6572}, //4554 #CJK UNIFIED IDEOGRAPH
    {0x9DC9, 0x6578}, //4555 #CJK UNIFIED IDEOGRAPH
    {0x9DCA, 0x6582}, //4556 #CJK UNIFIED IDEOGRAPH
    {0x9DCB, 0x6583}, //4557 #CJK UNIFIED IDEOGRAPH
    {0x9DCC, 0x8B8A}, //4558 #CJK UNIFIED IDEOGRAPH
    {0x9DCD, 0x659B}, //4559 #CJK UNIFIED IDEOGRAPH
    {0x9DCE, 0x659F}, //4560 #CJK UNIFIED IDEOGRAPH
    {0x9DCF, 0x65AB}, //4561 #CJK UNIFIED IDEOGRAPH
    {0x9DD0, 0x65B7}, //4562 #CJK UNIFIED IDEOGRAPH
    {0x9DD1, 0x65C3}, //4563 #CJK UNIFIED IDEOGRAPH
    {0x9DD2, 0x65C6}, //4564 #CJK UNIFIED IDEOGRAPH
    {0x9DD3, 0x65C1}, //4565 #CJK UNIFIED IDEOGRAPH
    {0x9DD4, 0x65C4}, //4566 #CJK UNIFIED IDEOGRAPH
    {0x9DD5, 0x65CC}, //4567 #CJK UNIFIED IDEOGRAPH
    {0x9DD6, 0x65D2}, //4568 #CJK UNIFIED IDEOGRAPH
    {0x9DD7, 0x65DB}, //4569 #CJK UNIFIED IDEOGRAPH
    {0x9DD8, 0x65D9}, //4570 #CJK UNIFIED IDEOGRAPH
    {0x9DD9, 0x65E0}, //4571 #CJK UNIFIED IDEOGRAPH
    {0x9DDA, 0x65E1}, //4572 #CJK UNIFIED IDEOGRAPH
    {0x9DDB, 0x65F1}, //4573 #CJK UNIFIED IDEOGRAPH
    {0x9DDC, 0x6772}, //4574 #CJK UNIFIED IDEOGRAPH
    {0x9DDD, 0x660A}, //4575 #CJK UNIFIED IDEOGRAPH
    {0x9DDE, 0x6603}, //4576 #CJK UNIFIED IDEOGRAPH
    {0x9DDF, 0x65FB}, //4577 #CJK UNIFIED IDEOGRAPH
    {0x9DE0, 0x6773}, //4578 #CJK UNIFIED IDEOGRAPH
    {0x9DE1, 0x6635}, //4579 #CJK UNIFIED IDEOGRAPH
    {0x9DE2, 0x6636}, //4580 #CJK UNIFIED IDEOGRAPH
    {0x9DE3, 0x6634}, //4581 #CJK UNIFIED IDEOGRAPH
    {0x9DE4, 0x661C}, //4582 #CJK UNIFIED IDEOGRAPH
    {0x9DE5, 0x664F}, //4583 #CJK UNIFIED IDEOGRAPH
    {0x9DE6, 0x6644}, //4584 #CJK UNIFIED IDEOGRAPH
    {0x9DE7, 0x6649}, //4585 #CJK UNIFIED IDEOGRAPH
    {0x9DE8, 0x6641}, //4586 #CJK UNIFIED IDEOGRAPH
    {0x9DE9, 0x665E}, //4587 #CJK UNIFIED IDEOGRAPH
    {0x9DEA, 0x665D}, //4588 #CJK UNIFIED IDEOGRAPH
    {0x9DEB, 0x6664}, //4589 #CJK UNIFIED IDEOGRAPH
    {0x9DEC, 0x6667}, //4590 #CJK UNIFIED IDEOGRAPH
    {0x9DED, 0x6668}, //4591 #CJK UNIFIED IDEOGRAPH
    {0x9DEE, 0x665F}, //4592 #CJK UNIFIED IDEOGRAPH
    {0x9DEF, 0x6662}, //4593 #CJK UNIFIED IDEOGRAPH
    {0x9DF0, 0x6670}, //4594 #CJK UNIFIED IDEOGRAPH
    {0x9DF1, 0x6683}, //4595 #CJK UNIFIED IDEOGRAPH
    {0x9DF2, 0x6688}, //4596 #CJK UNIFIED IDEOGRAPH
    {0x9DF3, 0x668E}, //4597 #CJK UNIFIED IDEOGRAPH
    {0x9DF4, 0x6689}, //4598 #CJK UNIFIED IDEOGRAPH
    {0x9DF5, 0x6684}, //4599 #CJK UNIFIED IDEOGRAPH
    {0x9DF6, 0x6698}, //4600 #CJK UNIFIED IDEOGRAPH
    {0x9DF7, 0x669D}, //4601 #CJK UNIFIED IDEOGRAPH
    {0x9DF8, 0x66C1}, //4602 #CJK UNIFIED IDEOGRAPH
    {0x9DF9, 0x66B9}, //4603 #CJK UNIFIED IDEOGRAPH
    {0x9DFA, 0x66C9}, //4604 #CJK UNIFIED IDEOGRAPH
    {0x9DFB, 0x66BE}, //4605 #CJK UNIFIED IDEOGRAPH
    {0x9DFC, 0x66BC}, //4606 #CJK UNIFIED IDEOGRAPH
    {0x9E40, 0x66C4}, //4607 #CJK UNIFIED IDEOGRAPH
    {0x9E41, 0x66B8}, //4608 #CJK UNIFIED IDEOGRAPH
    {0x9E42, 0x66D6}, //4609 #CJK UNIFIED IDEOGRAPH
    {0x9E43, 0x66DA}, //4610 #CJK UNIFIED IDEOGRAPH
    {0x9E44, 0x66E0}, //4611 #CJK UNIFIED IDEOGRAPH
    {0x9E45, 0x663F}, //4612 #CJK UNIFIED IDEOGRAPH
    {0x9E46, 0x66E6}, //4613 #CJK UNIFIED IDEOGRAPH
    {0x9E47, 0x66E9}, //4614 #CJK UNIFIED IDEOGRAPH
    {0x9E48, 0x66F0}, //4615 #CJK UNIFIED IDEOGRAPH
    {0x9E49, 0x66F5}, //4616 #CJK UNIFIED IDEOGRAPH
    {0x9E4A, 0x66F7}, //4617 #CJK UNIFIED IDEOGRAPH
    {0x9E4B, 0x670F}, //4618 #CJK UNIFIED IDEOGRAPH
    {0x9E4C, 0x6716}, //4619 #CJK UNIFIED IDEOGRAPH
    {0x9E4D, 0x671E}, //4620 #CJK UNIFIED IDEOGRAPH
    {0x9E4E, 0x6726}, //4621 #CJK UNIFIED IDEOGRAPH
    {0x9E4F, 0x6727}, //4622 #CJK UNIFIED IDEOGRAPH
    {0x9E50, 0x9738}, //4623 #CJK UNIFIED IDEOGRAPH
    {0x9E51, 0x672E}, //4624 #CJK UNIFIED IDEOGRAPH
    {0x9E52, 0x673F}, //4625 #CJK UNIFIED IDEOGRAPH
    {0x9E53, 0x6736}, //4626 #CJK UNIFIED IDEOGRAPH
    {0x9E54, 0x6741}, //4627 #CJK UNIFIED IDEOGRAPH
    {0x9E55, 0x6738}, //4628 #CJK UNIFIED IDEOGRAPH
    {0x9E56, 0x6737}, //4629 #CJK UNIFIED IDEOGRAPH
    {0x9E57, 0x6746}, //4630 #CJK UNIFIED IDEOGRAPH
    {0x9E58, 0x675E}, //4631 #CJK UNIFIED IDEOGRAPH
    {0x9E59, 0x6760}, //4632 #CJK UNIFIED IDEOGRAPH
    {0x9E5A, 0x6759}, //4633 #CJK UNIFIED IDEOGRAPH
    {0x9E5B, 0x6763}, //4634 #CJK UNIFIED IDEOGRAPH
    {0x9E5C, 0x6764}, //4635 #CJK UNIFIED IDEOGRAPH
    {0x9E5D, 0x6789}, //4636 #CJK UNIFIED IDEOGRAPH
    {0x9E5E, 0x6770}, //4637 #CJK UNIFIED IDEOGRAPH
    {0x9E5F, 0x67A9}, //4638 #CJK UNIFIED IDEOGRAPH
    {0x9E60, 0x677C}, //4639 #CJK UNIFIED IDEOGRAPH
    {0x9E61, 0x676A}, //4640 #CJK UNIFIED IDEOGRAPH
    {0x9E62, 0x678C}, //4641 #CJK UNIFIED IDEOGRAPH
    {0x9E63, 0x678B}, //4642 #CJK UNIFIED IDEOGRAPH
    {0x9E64, 0x67A6}, //4643 #CJK UNIFIED IDEOGRAPH
    {0x9E65, 0x67A1}, //4644 #CJK UNIFIED IDEOGRAPH
    {0x9E66, 0x6785}, //4645 #CJK UNIFIED IDEOGRAPH
    {0x9E67, 0x67B7}, //4646 #CJK UNIFIED IDEOGRAPH
    {0x9E68, 0x67EF}, //4647 #CJK UNIFIED IDEOGRAPH
    {0x9E69, 0x67B4}, //4648 #CJK UNIFIED IDEOGRAPH
    {0x9E6A, 0x67EC}, //4649 #CJK UNIFIED IDEOGRAPH
    {0x9E6B, 0x67B3}, //4650 #CJK UNIFIED IDEOGRAPH
    {0x9E6C, 0x67E9}, //4651 #CJK UNIFIED IDEOGRAPH
    {0x9E6D, 0x67B8}, //4652 #CJK UNIFIED IDEOGRAPH
    {0x9E6E, 0x67E4}, //4653 #CJK UNIFIED IDEOGRAPH
    {0x9E6F, 0x67DE}, //4654 #CJK UNIFIED IDEOGRAPH
    {0x9E70, 0x67DD}, //4655 #CJK UNIFIED IDEOGRAPH
    {0x9E71, 0x67E2}, //4656 #CJK UNIFIED IDEOGRAPH
    {0x9E72, 0x67EE}, //4657 #CJK UNIFIED IDEOGRAPH
    {0x9E73, 0x67B9}, //4658 #CJK UNIFIED IDEOGRAPH
    {0x9E74, 0x67CE}, //4659 #CJK UNIFIED IDEOGRAPH
    {0x9E75, 0x67C6}, //4660 #CJK UNIFIED IDEOGRAPH
    {0x9E76, 0x67E7}, //4661 #CJK UNIFIED IDEOGRAPH
    {0x9E77, 0x6A9C}, //4662 #CJK UNIFIED IDEOGRAPH
    {0x9E78, 0x681E}, //4663 #CJK UNIFIED IDEOGRAPH
    {0x9E79, 0x6846}, //4664 #CJK UNIFIED IDEOGRAPH
    {0x9E7A, 0x6829}, //4665 #CJK UNIFIED IDEOGRAPH
    {0x9E7B, 0x6840}, //4666 #CJK UNIFIED IDEOGRAPH
    {0x9E7C, 0x684D}, //4667 #CJK UNIFIED IDEOGRAPH
    {0x9E7D, 0x6832}, //4668 #CJK UNIFIED IDEOGRAPH
    {0x9E7E, 0x684E}, //4669 #CJK UNIFIED IDEOGRAPH
    {0x9E80, 0x68B3}, //4670 #CJK UNIFIED IDEOGRAPH
    {0x9E81, 0x682B}, //4671 #CJK UNIFIED IDEOGRAPH
    {0x9E82, 0x6859}, //4672 #CJK UNIFIED IDEOGRAPH
    {0x9E83, 0x6863}, //4673 #CJK UNIFIED IDEOGRAPH
    {0x9E84, 0x6877}, //4674 #CJK UNIFIED IDEOGRAPH
    {0x9E85, 0x687F}, //4675 #CJK UNIFIED IDEOGRAPH
    {0x9E86, 0x689F}, //4676 #CJK UNIFIED IDEOGRAPH
    {0x9E87, 0x688F}, //4677 #CJK UNIFIED IDEOGRAPH
    {0x9E88, 0x68AD}, //4678 #CJK UNIFIED IDEOGRAPH
    {0x9E89, 0x6894}, //4679 #CJK UNIFIED IDEOGRAPH
    {0x9E8A, 0x689D}, //4680 #CJK UNIFIED IDEOGRAPH
    {0x9E8B, 0x689B}, //4681 #CJK UNIFIED IDEOGRAPH
    {0x9E8C, 0x6883}, //4682 #CJK UNIFIED IDEOGRAPH
    {0x9E8D, 0x6AAE}, //4683 #CJK UNIFIED IDEOGRAPH
    {0x9E8E, 0x68B9}, //4684 #CJK UNIFIED IDEOGRAPH
    {0x9E8F, 0x6874}, //4685 #CJK UNIFIED IDEOGRAPH
    {0x9E90, 0x68B5}, //4686 #CJK UNIFIED IDEOGRAPH
    {0x9E91, 0x68A0}, //4687 #CJK UNIFIED IDEOGRAPH
    {0x9E92, 0x68BA}, //4688 #CJK UNIFIED IDEOGRAPH
    {0x9E93, 0x690F}, //4689 #CJK UNIFIED IDEOGRAPH
    {0x9E94, 0x688D}, //4690 #CJK UNIFIED IDEOGRAPH
    {0x9E95, 0x687E}, //4691 #CJK UNIFIED IDEOGRAPH
    {0x9E96, 0x6901}, //4692 #CJK UNIFIED IDEOGRAPH
    {0x9E97, 0x68CA}, //4693 #CJK UNIFIED IDEOGRAPH
    {0x9E98, 0x6908}, //4694 #CJK UNIFIED IDEOGRAPH
    {0x9E99, 0x68D8}, //4695 #CJK UNIFIED IDEOGRAPH
    {0x9E9A, 0x6922}, //4696 #CJK UNIFIED IDEOGRAPH
    {0x9E9B, 0x6926}, //4697 #CJK UNIFIED IDEOGRAPH
    {0x9E9C, 0x68E1}, //4698 #CJK UNIFIED IDEOGRAPH
    {0x9E9D, 0x690C}, //4699 #CJK UNIFIED IDEOGRAPH
    {0x9E9E, 0x68CD}, //4700 #CJK UNIFIED IDEOGRAPH
    {0x9E9F, 0x68D4}, //4701 #CJK UNIFIED IDEOGRAPH
    {0x9EA0, 0x68E7}, //4702 #CJK UNIFIED IDEOGRAPH
    {0x9EA1, 0x68D5}, //4703 #CJK UNIFIED IDEOGRAPH
    {0x9EA2, 0x6936}, //4704 #CJK UNIFIED IDEOGRAPH
    {0x9EA3, 0x6912}, //4705 #CJK UNIFIED IDEOGRAPH
    {0x9EA4, 0x6904}, //4706 #CJK UNIFIED IDEOGRAPH
    {0x9EA5, 0x68D7}, //4707 #CJK UNIFIED IDEOGRAPH
    {0x9EA6, 0x68E3}, //4708 #CJK UNIFIED IDEOGRAPH
    {0x9EA7, 0x6925}, //4709 #CJK UNIFIED IDEOGRAPH
    {0x9EA8, 0x68F9}, //4710 #CJK UNIFIED IDEOGRAPH
    {0x9EA9, 0x68E0}, //4711 #CJK UNIFIED IDEOGRAPH
    {0x9EAA, 0x68EF}, //4712 #CJK UNIFIED IDEOGRAPH
    {0x9EAB, 0x6928}, //4713 #CJK UNIFIED IDEOGRAPH
    {0x9EAC, 0x692A}, //4714 #CJK UNIFIED IDEOGRAPH
    {0x9EAD, 0x691A}, //4715 #CJK UNIFIED IDEOGRAPH
    {0x9EAE, 0x6923}, //4716 #CJK UNIFIED IDEOGRAPH
    {0x9EAF, 0x6921}, //4717 #CJK UNIFIED IDEOGRAPH
    {0x9EB0, 0x68C6}, //4718 #CJK UNIFIED IDEOGRAPH
    {0x9EB1, 0x6979}, //4719 #CJK UNIFIED IDEOGRAPH
    {0x9EB2, 0x6977}, //4720 #CJK UNIFIED IDEOGRAPH
    {0x9EB3, 0x695C}, //4721 #CJK UNIFIED IDEOGRAPH
    {0x9EB4, 0x6978}, //4722 #CJK UNIFIED IDEOGRAPH
    {0x9EB5, 0x696B}, //4723 #CJK UNIFIED IDEOGRAPH
    {0x9EB6, 0x6954}, //4724 #CJK UNIFIED IDEOGRAPH
    {0x9EB7, 0x697E}, //4725 #CJK UNIFIED IDEOGRAPH
    {0x9EB8, 0x696E}, //4726 #CJK UNIFIED IDEOGRAPH
    {0x9EB9, 0x6939}, //4727 #CJK UNIFIED IDEOGRAPH
    {0x9EBA, 0x6974}, //4728 #CJK UNIFIED IDEOGRAPH
    {0x9EBB, 0x693D}, //4729 #CJK UNIFIED IDEOGRAPH
    {0x9EBC, 0x6959}, //4730 #CJK UNIFIED IDEOGRAPH
    {0x9EBD, 0x6930}, //4731 #CJK UNIFIED IDEOGRAPH
    {0x9EBE, 0x6961}, //4732 #CJK UNIFIED IDEOGRAPH
    {0x9EBF, 0x695E}, //4733 #CJK UNIFIED IDEOGRAPH
    {0x9EC0, 0x695D}, //4734 #CJK UNIFIED IDEOGRAPH
    {0x9EC1, 0x6981}, //4735 #CJK UNIFIED IDEOGRAPH
    {0x9EC2, 0x696A}, //4736 #CJK UNIFIED IDEOGRAPH
    {0x9EC3, 0x69B2}, //4737 #CJK UNIFIED IDEOGRAPH
    {0x9EC4, 0x69AE}, //4738 #CJK UNIFIED IDEOGRAPH
    {0x9EC5, 0x69D0}, //4739 #CJK UNIFIED IDEOGRAPH
    {0x9EC6, 0x69BF}, //4740 #CJK UNIFIED IDEOGRAPH
    {0x9EC7, 0x69C1}, //4741 #CJK UNIFIED IDEOGRAPH
    {0x9EC8, 0x69D3}, //4742 #CJK UNIFIED IDEOGRAPH
    {0x9EC9, 0x69BE}, //4743 #CJK UNIFIED IDEOGRAPH
    {0x9ECA, 0x69CE}, //4744 #CJK UNIFIED IDEOGRAPH
    {0x9ECB, 0x5BE8}, //4745 #CJK UNIFIED IDEOGRAPH
    {0x9ECC, 0x69CA}, //4746 #CJK UNIFIED IDEOGRAPH
    {0x9ECD, 0x69DD}, //4747 #CJK UNIFIED IDEOGRAPH
    {0x9ECE, 0x69BB}, //4748 #CJK UNIFIED IDEOGRAPH
    {0x9ECF, 0x69C3}, //4749 #CJK UNIFIED IDEOGRAPH
    {0x9ED0, 0x69A7}, //4750 #CJK UNIFIED IDEOGRAPH
    {0x9ED1, 0x6A2E}, //4751 #CJK UNIFIED IDEOGRAPH
    {0x9ED2, 0x6991}, //4752 #CJK UNIFIED IDEOGRAPH
    {0x9ED3, 0x69A0}, //4753 #CJK UNIFIED IDEOGRAPH
    {0x9ED4, 0x699C}, //4754 #CJK UNIFIED IDEOGRAPH
    {0x9ED5, 0x6995}, //4755 #CJK UNIFIED IDEOGRAPH
    {0x9ED6, 0x69B4}, //4756 #CJK UNIFIED IDEOGRAPH
    {0x9ED7, 0x69DE}, //4757 #CJK UNIFIED IDEOGRAPH
    {0x9ED8, 0x69E8}, //4758 #CJK UNIFIED IDEOGRAPH
    {0x9ED9, 0x6A02}, //4759 #CJK UNIFIED IDEOGRAPH
    {0x9EDA, 0x6A1B}, //4760 #CJK UNIFIED IDEOGRAPH
    {0x9EDB, 0x69FF}, //4761 #CJK UNIFIED IDEOGRAPH
    {0x9EDC, 0x6B0A}, //4762 #CJK UNIFIED IDEOGRAPH
    {0x9EDD, 0x69F9}, //4763 #CJK UNIFIED IDEOGRAPH
    {0x9EDE, 0x69F2}, //4764 #CJK UNIFIED IDEOGRAPH
    {0x9EDF, 0x69E7}, //4765 #CJK UNIFIED IDEOGRAPH
    {0x9EE0, 0x6A05}, //4766 #CJK UNIFIED IDEOGRAPH
    {0x9EE1, 0x69B1}, //4767 #CJK UNIFIED IDEOGRAPH
    {0x9EE2, 0x6A1E}, //4768 #CJK UNIFIED IDEOGRAPH
    {0x9EE3, 0x69ED}, //4769 #CJK UNIFIED IDEOGRAPH
    {0x9EE4, 0x6A14}, //4770 #CJK UNIFIED IDEOGRAPH
    {0x9EE5, 0x69EB}, //4771 #CJK UNIFIED IDEOGRAPH
    {0x9EE6, 0x6A0A}, //4772 #CJK UNIFIED IDEOGRAPH
    {0x9EE7, 0x6A12}, //4773 #CJK UNIFIED IDEOGRAPH
    {0x9EE8, 0x6AC1}, //4774 #CJK UNIFIED IDEOGRAPH
    {0x9EE9, 0x6A23}, //4775 #CJK UNIFIED IDEOGRAPH
    {0x9EEA, 0x6A13}, //4776 #CJK UNIFIED IDEOGRAPH
    {0x9EEB, 0x6A44}, //4777 #CJK UNIFIED IDEOGRAPH
    {0x9EEC, 0x6A0C}, //4778 #CJK UNIFIED IDEOGRAPH
    {0x9EED, 0x6A72}, //4779 #CJK UNIFIED IDEOGRAPH
    {0x9EEE, 0x6A36}, //4780 #CJK UNIFIED IDEOGRAPH
    {0x9EEF, 0x6A78}, //4781 #CJK UNIFIED IDEOGRAPH
    {0x9EF0, 0x6A47}, //4782 #CJK UNIFIED IDEOGRAPH
    {0x9EF1, 0x6A62}, //4783 #CJK UNIFIED IDEOGRAPH
    {0x9EF2, 0x6A59}, //4784 #CJK UNIFIED IDEOGRAPH
    {0x9EF3, 0x6A66}, //4785 #CJK UNIFIED IDEOGRAPH
    {0x9EF4, 0x6A48}, //4786 #CJK UNIFIED IDEOGRAPH
    {0x9EF5, 0x6A38}, //4787 #CJK UNIFIED IDEOGRAPH
    {0x9EF6, 0x6A22}, //4788 #CJK UNIFIED IDEOGRAPH
    {0x9EF7, 0x6A90}, //4789 #CJK UNIFIED IDEOGRAPH
    {0x9EF8, 0x6A8D}, //4790 #CJK UNIFIED IDEOGRAPH
    {0x9EF9, 0x6AA0}, //4791 #CJK UNIFIED IDEOGRAPH
    {0x9EFA, 0x6A84}, //4792 #CJK UNIFIED IDEOGRAPH
    {0x9EFB, 0x6AA2}, //4793 #CJK UNIFIED IDEOGRAPH
    {0x9EFC, 0x6AA3}, //4794 #CJK UNIFIED IDEOGRAPH
    {0x9F40, 0x6A97}, //4795 #CJK UNIFIED IDEOGRAPH
    {0x9F41, 0x8617}, //4796 #CJK UNIFIED IDEOGRAPH
    {0x9F42, 0x6ABB}, //4797 #CJK UNIFIED IDEOGRAPH
    {0x9F43, 0x6AC3}, //4798 #CJK UNIFIED IDEOGRAPH
    {0x9F44, 0x6AC2}, //4799 #CJK UNIFIED IDEOGRAPH
    {0x9F45, 0x6AB8}, //4800 #CJK UNIFIED IDEOGRAPH
    {0x9F46, 0x6AB3}, //4801 #CJK UNIFIED IDEOGRAPH
    {0x9F47, 0x6AAC}, //4802 #CJK UNIFIED IDEOGRAPH
    {0x9F48, 0x6ADE}, //4803 #CJK UNIFIED IDEOGRAPH
    {0x9F49, 0x6AD1}, //4804 #CJK UNIFIED IDEOGRAPH
    {0x9F4A, 0x6ADF}, //4805 #CJK UNIFIED IDEOGRAPH
    {0x9F4B, 0x6AAA}, //4806 #CJK UNIFIED IDEOGRAPH
    {0x9F4C, 0x6ADA}, //4807 #CJK UNIFIED IDEOGRAPH
    {0x9F4D, 0x6AEA}, //4808 #CJK UNIFIED IDEOGRAPH
    {0x9F4E, 0x6AFB}, //4809 #CJK UNIFIED IDEOGRAPH
    {0x9F4F, 0x6B05}, //4810 #CJK UNIFIED IDEOGRAPH
    {0x9F50, 0x8616}, //4811 #CJK UNIFIED IDEOGRAPH
    {0x9F51, 0x6AFA}, //4812 #CJK UNIFIED IDEOGRAPH
    {0x9F52, 0x6B12}, //4813 #CJK UNIFIED IDEOGRAPH
    {0x9F53, 0x6B16}, //4814 #CJK UNIFIED IDEOGRAPH
    {0x9F54, 0x9B31}, //4815 #CJK UNIFIED IDEOGRAPH
    {0x9F55, 0x6B1F}, //4816 #CJK UNIFIED IDEOGRAPH
    {0x9F56, 0x6B38}, //4817 #CJK UNIFIED IDEOGRAPH
    {0x9F57, 0x6B37}, //4818 #CJK UNIFIED IDEOGRAPH
    {0x9F58, 0x76DC}, //4819 #CJK UNIFIED IDEOGRAPH
    {0x9F59, 0x6B39}, //4820 #CJK UNIFIED IDEOGRAPH
    {0x9F5A, 0x98EE}, //4821 #CJK UNIFIED IDEOGRAPH
    {0x9F5B, 0x6B47}, //4822 #CJK UNIFIED IDEOGRAPH
    {0x9F5C, 0x6B43}, //4823 #CJK UNIFIED IDEOGRAPH
    {0x9F5D, 0x6B49}, //4824 #CJK UNIFIED IDEOGRAPH
    {0x9F5E, 0x6B50}, //4825 #CJK UNIFIED IDEOGRAPH
    {0x9F5F, 0x6B59}, //4826 #CJK UNIFIED IDEOGRAPH
    {0x9F60, 0x6B54}, //4827 #CJK UNIFIED IDEOGRAPH
    {0x9F61, 0x6B5B}, //4828 #CJK UNIFIED IDEOGRAPH
    {0x9F62, 0x6B5F}, //4829 #CJK UNIFIED IDEOGRAPH
    {0x9F63, 0x6B61}, //4830 #CJK UNIFIED IDEOGRAPH
    {0x9F64, 0x6B78}, //4831 #CJK UNIFIED IDEOGRAPH
    {0x9F65, 0x6B79}, //4832 #CJK UNIFIED IDEOGRAPH
    {0x9F66, 0x6B7F}, //4833 #CJK UNIFIED IDEOGRAPH
    {0x9F67, 0x6B80}, //4834 #CJK UNIFIED IDEOGRAPH
    {0x9F68, 0x6B84}, //4835 #CJK UNIFIED IDEOGRAPH
    {0x9F69, 0x6B83}, //4836 #CJK UNIFIED IDEOGRAPH
    {0x9F6A, 0x6B8D}, //4837 #CJK UNIFIED IDEOGRAPH
    {0x9F6B, 0x6B98}, //4838 #CJK UNIFIED IDEOGRAPH
    {0x9F6C, 0x6B95}, //4839 #CJK UNIFIED IDEOGRAPH
    {0x9F6D, 0x6B9E}, //4840 #CJK UNIFIED IDEOGRAPH
    {0x9F6E, 0x6BA4}, //4841 #CJK UNIFIED IDEOGRAPH
    {0x9F6F, 0x6BAA}, //4842 #CJK UNIFIED IDEOGRAPH
    {0x9F70, 0x6BAB}, //4843 #CJK UNIFIED IDEOGRAPH
    {0x9F71, 0x6BAF}, //4844 #CJK UNIFIED IDEOGRAPH
    {0x9F72, 0x6BB2}, //4845 #CJK UNIFIED IDEOGRAPH
    {0x9F73, 0x6BB1}, //4846 #CJK UNIFIED IDEOGRAPH
    {0x9F74, 0x6BB3}, //4847 #CJK UNIFIED IDEOGRAPH
    {0x9F75, 0x6BB7}, //4848 #CJK UNIFIED IDEOGRAPH
    {0x9F76, 0x6BBC}, //4849 #CJK UNIFIED IDEOGRAPH
    {0x9F77, 0x6BC6}, //4850 #CJK UNIFIED IDEOGRAPH
    {0x9F78, 0x6BCB}, //4851 #CJK UNIFIED IDEOGRAPH
    {0x9F79, 0x6BD3}, //4852 #CJK UNIFIED IDEOGRAPH
    {0x9F7A, 0x6BDF}, //4853 #CJK UNIFIED IDEOGRAPH
    {0x9F7B, 0x6BEC}, //4854 #CJK UNIFIED IDEOGRAPH
    {0x9F7C, 0x6BEB}, //4855 #CJK UNIFIED IDEOGRAPH
    {0x9F7D, 0x6BF3}, //4856 #CJK UNIFIED IDEOGRAPH
    {0x9F7E, 0x6BEF}, //4857 #CJK UNIFIED IDEOGRAPH
    {0x9F80, 0x9EBE}, //4858 #CJK UNIFIED IDEOGRAPH
    {0x9F81, 0x6C08}, //4859 #CJK UNIFIED IDEOGRAPH
    {0x9F82, 0x6C13}, //4860 #CJK UNIFIED IDEOGRAPH
    {0x9F83, 0x6C14}, //4861 #CJK UNIFIED IDEOGRAPH
    {0x9F84, 0x6C1B}, //4862 #CJK UNIFIED IDEOGRAPH
    {0x9F85, 0x6C24}, //4863 #CJK UNIFIED IDEOGRAPH
    {0x9F86, 0x6C23}, //4864 #CJK UNIFIED IDEOGRAPH
    {0x9F87, 0x6C5E}, //4865 #CJK UNIFIED IDEOGRAPH
    {0x9F88, 0x6C55}, //4866 #CJK UNIFIED IDEOGRAPH
    {0x9F89, 0x6C62}, //4867 #CJK UNIFIED IDEOGRAPH
    {0x9F8A, 0x6C6A}, //4868 #CJK UNIFIED IDEOGRAPH
    {0x9F8B, 0x6C82}, //4869 #CJK UNIFIED IDEOGRAPH
    {0x9F8C, 0x6C8D}, //4870 #CJK UNIFIED IDEOGRAPH
    {0x9F8D, 0x6C9A}, //4871 #CJK UNIFIED IDEOGRAPH
    {0x9F8E, 0x6C81}, //4872 #CJK UNIFIED IDEOGRAPH
    {0x9F8F, 0x6C9B}, //4873 #CJK UNIFIED IDEOGRAPH
    {0x9F90, 0x6C7E}, //4874 #CJK UNIFIED IDEOGRAPH
    {0x9F91, 0x6C68}, //4875 #CJK UNIFIED IDEOGRAPH
    {0x9F92, 0x6C73}, //4876 #CJK UNIFIED IDEOGRAPH
    {0x9F93, 0x6C92}, //4877 #CJK UNIFIED IDEOGRAPH
    {0x9F94, 0x6C90}, //4878 #CJK UNIFIED IDEOGRAPH
    {0x9F95, 0x6CC4}, //4879 #CJK UNIFIED IDEOGRAPH
    {0x9F96, 0x6CF1}, //4880 #CJK UNIFIED IDEOGRAPH
    {0x9F97, 0x6CD3}, //4881 #CJK UNIFIED IDEOGRAPH
    {0x9F98, 0x6CBD}, //4882 #CJK UNIFIED IDEOGRAPH
    {0x9F99, 0x6CD7}, //4883 #CJK UNIFIED IDEOGRAPH
    {0x9F9A, 0x6CC5}, //4884 #CJK UNIFIED IDEOGRAPH
    {0x9F9B, 0x6CDD}, //4885 #CJK UNIFIED IDEOGRAPH
    {0x9F9C, 0x6CAE}, //4886 #CJK UNIFIED IDEOGRAPH
    {0x9F9D, 0x6CB1}, //4887 #CJK UNIFIED IDEOGRAPH
    {0x9F9E, 0x6CBE}, //4888 #CJK UNIFIED IDEOGRAPH
    {0x9F9F, 0x6CBA}, //4889 #CJK UNIFIED IDEOGRAPH
    {0x9FA0, 0x6CDB}, //4890 #CJK UNIFIED IDEOGRAPH
    {0x9FA1, 0x6CEF}, //4891 #CJK UNIFIED IDEOGRAPH
    {0x9FA2, 0x6CD9}, //4892 #CJK UNIFIED IDEOGRAPH
    {0x9FA3, 0x6CEA}, //4893 #CJK UNIFIED IDEOGRAPH
    {0x9FA4, 0x6D1F}, //4894 #CJK UNIFIED IDEOGRAPH
    {0x9FA5, 0x884D}, //4895 #CJK UNIFIED IDEOGRAPH
    {0x9FA6, 0x6D36}, //4896 #CJK UNIFIED IDEOGRAPH
    {0x9FA7, 0x6D2B}, //4897 #CJK UNIFIED IDEOGRAPH
    {0x9FA8, 0x6D3D}, //4898 #CJK UNIFIED IDEOGRAPH
    {0x9FA9, 0x6D38}, //4899 #CJK UNIFIED IDEOGRAPH
    {0x9FAA, 0x6D19}, //4900 #CJK UNIFIED IDEOGRAPH
    {0x9FAB, 0x6D35}, //4901 #CJK UNIFIED IDEOGRAPH
    {0x9FAC, 0x6D33}, //4902 #CJK UNIFIED IDEOGRAPH
    {0x9FAD, 0x6D12}, //4903 #CJK UNIFIED IDEOGRAPH
    {0x9FAE, 0x6D0C}, //4904 #CJK UNIFIED IDEOGRAPH
    {0x9FAF, 0x6D63}, //4905 #CJK UNIFIED IDEOGRAPH
    {0x9FB0, 0x6D93}, //4906 #CJK UNIFIED IDEOGRAPH
    {0x9FB1, 0x6D64}, //4907 #CJK UNIFIED IDEOGRAPH
    {0x9FB2, 0x6D5A}, //4908 #CJK UNIFIED IDEOGRAPH
    {0x9FB3, 0x6D79}, //4909 #CJK UNIFIED IDEOGRAPH
    {0x9FB4, 0x6D59}, //4910 #CJK UNIFIED IDEOGRAPH
    {0x9FB5, 0x6D8E}, //4911 #CJK UNIFIED IDEOGRAPH
    {0x9FB6, 0x6D95}, //4912 #CJK UNIFIED IDEOGRAPH
    {0x9FB7, 0x6FE4}, //4913 #CJK UNIFIED IDEOGRAPH
    {0x9FB8, 0x6D85}, //4914 #CJK UNIFIED IDEOGRAPH
    {0x9FB9, 0x6DF9}, //4915 #CJK UNIFIED IDEOGRAPH
    {0x9FBA, 0x6E15}, //4916 #CJK UNIFIED IDEOGRAPH
    {0x9FBB, 0x6E0A}, //4917 #CJK UNIFIED IDEOGRAPH
    {0x9FBC, 0x6DB5}, //4918 #CJK UNIFIED IDEOGRAPH
    {0x9FBD, 0x6DC7}, //4919 #CJK UNIFIED IDEOGRAPH
    {0x9FBE, 0x6DE6}, //4920 #CJK UNIFIED IDEOGRAPH
    {0x9FBF, 0x6DB8}, //4921 #CJK UNIFIED IDEOGRAPH
    {0x9FC0, 0x6DC6}, //4922 #CJK UNIFIED IDEOGRAPH
    {0x9FC1, 0x6DEC}, //4923 #CJK UNIFIED IDEOGRAPH
    {0x9FC2, 0x6DDE}, //4924 #CJK UNIFIED IDEOGRAPH
    {0x9FC3, 0x6DCC}, //4925 #CJK UNIFIED IDEOGRAPH
    {0x9FC4, 0x6DE8}, //4926 #CJK UNIFIED IDEOGRAPH
    {0x9FC5, 0x6DD2}, //4927 #CJK UNIFIED IDEOGRAPH
    {0x9FC6, 0x6DC5}, //4928 #CJK UNIFIED IDEOGRAPH
    {0x9FC7, 0x6DFA}, //4929 #CJK UNIFIED IDEOGRAPH
    {0x9FC8, 0x6DD9}, //4930 #CJK UNIFIED IDEOGRAPH
    {0x9FC9, 0x6DE4}, //4931 #CJK UNIFIED IDEOGRAPH
    {0x9FCA, 0x6DD5}, //4932 #CJK UNIFIED IDEOGRAPH
    {0x9FCB, 0x6DEA}, //4933 #CJK UNIFIED IDEOGRAPH
    {0x9FCC, 0x6DEE}, //4934 #CJK UNIFIED IDEOGRAPH
    {0x9FCD, 0x6E2D}, //4935 #CJK UNIFIED IDEOGRAPH
    {0x9FCE, 0x6E6E}, //4936 #CJK UNIFIED IDEOGRAPH
    {0x9FCF, 0x6E2E}, //4937 #CJK UNIFIED IDEOGRAPH
    {0x9FD0, 0x6E19}, //4938 #CJK UNIFIED IDEOGRAPH
    {0x9FD1, 0x6E72}, //4939 #CJK UNIFIED IDEOGRAPH
    {0x9FD2, 0x6E5F}, //4940 #CJK UNIFIED IDEOGRAPH
    {0x9FD3, 0x6E3E}, //4941 #CJK UNIFIED IDEOGRAPH
    {0x9FD4, 0x6E23}, //4942 #CJK UNIFIED IDEOGRAPH
    {0x9FD5, 0x6E6B}, //4943 #CJK UNIFIED IDEOGRAPH
    {0x9FD6, 0x6E2B}, //4944 #CJK UNIFIED IDEOGRAPH
    {0x9FD7, 0x6E76}, //4945 #CJK UNIFIED IDEOGRAPH
    {0x9FD8, 0x6E4D}, //4946 #CJK UNIFIED IDEOGRAPH
    {0x9FD9, 0x6E1F}, //4947 #CJK UNIFIED IDEOGRAPH
    {0x9FDA, 0x6E43}, //4948 #CJK UNIFIED IDEOGRAPH
    {0x9FDB, 0x6E3A}, //4949 #CJK UNIFIED IDEOGRAPH
    {0x9FDC, 0x6E4E}, //4950 #CJK UNIFIED IDEOGRAPH
    {0x9FDD, 0x6E24}, //4951 #CJK UNIFIED IDEOGRAPH
    {0x9FDE, 0x6EFF}, //4952 #CJK UNIFIED IDEOGRAPH
    {0x9FDF, 0x6E1D}, //4953 #CJK UNIFIED IDEOGRAPH
    {0x9FE0, 0x6E38}, //4954 #CJK UNIFIED IDEOGRAPH
    {0x9FE1, 0x6E82}, //4955 #CJK UNIFIED IDEOGRAPH
    {0x9FE2, 0x6EAA}, //4956 #CJK UNIFIED IDEOGRAPH
    {0x9FE3, 0x6E98}, //4957 #CJK UNIFIED IDEOGRAPH
    {0x9FE4, 0x6EC9}, //4958 #CJK UNIFIED IDEOGRAPH
    {0x9FE5, 0x6EB7}, //4959 #CJK UNIFIED IDEOGRAPH
    {0x9FE6, 0x6ED3}, //4960 #CJK UNIFIED IDEOGRAPH
    {0x9FE7, 0x6EBD}, //4961 #CJK UNIFIED IDEOGRAPH
    {0x9FE8, 0x6EAF}, //4962 #CJK UNIFIED IDEOGRAPH
    {0x9FE9, 0x6EC4}, //4963 #CJK UNIFIED IDEOGRAPH
    {0x9FEA, 0x6EB2}, //4964 #CJK UNIFIED IDEOGRAPH
    {0x9FEB, 0x6ED4}, //4965 #CJK UNIFIED IDEOGRAPH
    {0x9FEC, 0x6ED5}, //4966 #CJK UNIFIED IDEOGRAPH
    {0x9FED, 0x6E8F}, //4967 #CJK UNIFIED IDEOGRAPH
    {0x9FEE, 0x6EA5}, //4968 #CJK UNIFIED IDEOGRAPH
    {0x9FEF, 0x6EC2}, //4969 #CJK UNIFIED IDEOGRAPH
    {0x9FF0, 0x6E9F}, //4970 #CJK UNIFIED IDEOGRAPH
    {0x9FF1, 0x6F41}, //4971 #CJK UNIFIED IDEOGRAPH
    {0x9FF2, 0x6F11}, //4972 #CJK UNIFIED IDEOGRAPH
    {0x9FF3, 0x704C}, //4973 #CJK UNIFIED IDEOGRAPH
    {0x9FF4, 0x6EEC}, //4974 #CJK UNIFIED IDEOGRAPH
    {0x9FF5, 0x6EF8}, //4975 #CJK UNIFIED IDEOGRAPH
    {0x9FF6, 0x6EFE}, //4976 #CJK UNIFIED IDEOGRAPH
    {0x9FF7, 0x6F3F}, //4977 #CJK UNIFIED IDEOGRAPH
    {0x9FF8, 0x6EF2}, //4978 #CJK UNIFIED IDEOGRAPH
    {0x9FF9, 0x6F31}, //4979 #CJK UNIFIED IDEOGRAPH
    {0x9FFA, 0x6EEF}, //4980 #CJK UNIFIED IDEOGRAPH
    {0x9FFB, 0x6F32}, //4981 #CJK UNIFIED IDEOGRAPH
    {0x9FFC, 0x6ECC}, //4982 #CJK UNIFIED IDEOGRAPH
    {0xE040, 0x6F3E}, //4983 #CJK UNIFIED IDEOGRAPH
    {0xE041, 0x6F13}, //4984 #CJK UNIFIED IDEOGRAPH
    {0xE042, 0x6EF7}, //4985 #CJK UNIFIED IDEOGRAPH
    {0xE043, 0x6F86}, //4986 #CJK UNIFIED IDEOGRAPH
    {0xE044, 0x6F7A}, //4987 #CJK UNIFIED IDEOGRAPH
    {0xE045, 0x6F78}, //4988 #CJK UNIFIED IDEOGRAPH
    {0xE046, 0x6F81}, //4989 #CJK UNIFIED IDEOGRAPH
    {0xE047, 0x6F80}, //4990 #CJK UNIFIED IDEOGRAPH
    {0xE048, 0x6F6F}, //4991 #CJK UNIFIED IDEOGRAPH
    {0xE049, 0x6F5B}, //4992 #CJK UNIFIED IDEOGRAPH
    {0xE04A, 0x6FF3}, //4993 #CJK UNIFIED IDEOGRAPH
    {0xE04B, 0x6F6D}, //4994 #CJK UNIFIED IDEOGRAPH
    {0xE04C, 0x6F82}, //4995 #CJK UNIFIED IDEOGRAPH
    {0xE04D, 0x6F7C}, //4996 #CJK UNIFIED IDEOGRAPH
    {0xE04E, 0x6F58}, //4997 #CJK UNIFIED IDEOGRAPH
    {0xE04F, 0x6F8E}, //4998 #CJK UNIFIED IDEOGRAPH
    {0xE050, 0x6F91}, //4999 #CJK UNIFIED IDEOGRAPH
    {0xE051, 0x6FC2}, //5000 #CJK UNIFIED IDEOGRAPH
    {0xE052, 0x6F66}, //5001 #CJK UNIFIED IDEOGRAPH
    {0xE053, 0x6FB3}, //5002 #CJK UNIFIED IDEOGRAPH
    {0xE054, 0x6FA3}, //5003 #CJK UNIFIED IDEOGRAPH
    {0xE055, 0x6FA1}, //5004 #CJK UNIFIED IDEOGRAPH
    {0xE056, 0x6FA4}, //5005 #CJK UNIFIED IDEOGRAPH
    {0xE057, 0x6FB9}, //5006 #CJK UNIFIED IDEOGRAPH
    {0xE058, 0x6FC6}, //5007 #CJK UNIFIED IDEOGRAPH
    {0xE059, 0x6FAA}, //5008 #CJK UNIFIED IDEOGRAPH
    {0xE05A, 0x6FDF}, //5009 #CJK UNIFIED IDEOGRAPH
    {0xE05B, 0x6FD5}, //5010 #CJK UNIFIED IDEOGRAPH
    {0xE05C, 0x6FEC}, //5011 #CJK UNIFIED IDEOGRAPH
    {0xE05D, 0x6FD4}, //5012 #CJK UNIFIED IDEOGRAPH
    {0xE05E, 0x6FD8}, //5013 #CJK UNIFIED IDEOGRAPH
    {0xE05F, 0x6FF1}, //5014 #CJK UNIFIED IDEOGRAPH
    {0xE060, 0x6FEE}, //5015 #CJK UNIFIED IDEOGRAPH
    {0xE061, 0x6FDB}, //5016 #CJK UNIFIED IDEOGRAPH
    {0xE062, 0x7009}, //5017 #CJK UNIFIED IDEOGRAPH
    {0xE063, 0x700B}, //5018 #CJK UNIFIED IDEOGRAPH
    {0xE064, 0x6FFA}, //5019 #CJK UNIFIED IDEOGRAPH
    {0xE065, 0x7011}, //5020 #CJK UNIFIED IDEOGRAPH
    {0xE066, 0x7001}, //5021 #CJK UNIFIED IDEOGRAPH
    {0xE067, 0x700F}, //5022 #CJK UNIFIED IDEOGRAPH
    {0xE068, 0x6FFE}, //5023 #CJK UNIFIED IDEOGRAPH
    {0xE069, 0x701B}, //5024 #CJK UNIFIED IDEOGRAPH
    {0xE06A, 0x701A}, //5025 #CJK UNIFIED IDEOGRAPH
    {0xE06B, 0x6F74}, //5026 #CJK UNIFIED IDEOGRAPH
    {0xE06C, 0x701D}, //5027 #CJK UNIFIED IDEOGRAPH
    {0xE06D, 0x7018}, //5028 #CJK UNIFIED IDEOGRAPH
    {0xE06E, 0x701F}, //5029 #CJK UNIFIED IDEOGRAPH
    {0xE06F, 0x7030}, //5030 #CJK UNIFIED IDEOGRAPH
    {0xE070, 0x703E}, //5031 #CJK UNIFIED IDEOGRAPH
    {0xE071, 0x7032}, //5032 #CJK UNIFIED IDEOGRAPH
    {0xE072, 0x7051}, //5033 #CJK UNIFIED IDEOGRAPH
    {0xE073, 0x7063}, //5034 #CJK UNIFIED IDEOGRAPH
    {0xE074, 0x7099}, //5035 #CJK UNIFIED IDEOGRAPH
    {0xE075, 0x7092}, //5036 #CJK UNIFIED IDEOGRAPH
    {0xE076, 0x70AF}, //5037 #CJK UNIFIED IDEOGRAPH
    {0xE077, 0x70F1}, //5038 #CJK UNIFIED IDEOGRAPH
    {0xE078, 0x70AC}, //5039 #CJK UNIFIED IDEOGRAPH
    {0xE079, 0x70B8}, //5040 #CJK UNIFIED IDEOGRAPH
    {0xE07A, 0x70B3}, //5041 #CJK UNIFIED IDEOGRAPH
    {0xE07B, 0x70AE}, //5042 #CJK UNIFIED IDEOGRAPH
    {0xE07C, 0x70DF}, //5043 #CJK UNIFIED IDEOGRAPH
    {0xE07D, 0x70CB}, //5044 #CJK UNIFIED IDEOGRAPH
    {0xE07E, 0x70DD}, //5045 #CJK UNIFIED IDEOGRAPH
    {0xE080, 0x70D9}, //5046 #CJK UNIFIED IDEOGRAPH
    {0xE081, 0x7109}, //5047 #CJK UNIFIED IDEOGRAPH
    {0xE082, 0x70FD}, //5048 #CJK UNIFIED IDEOGRAPH
    {0xE083, 0x711C}, //5049 #CJK UNIFIED IDEOGRAPH
    {0xE084, 0x7119}, //5050 #CJK UNIFIED IDEOGRAPH
    {0xE085, 0x7165}, //5051 #CJK UNIFIED IDEOGRAPH
    {0xE086, 0x7155}, //5052 #CJK UNIFIED IDEOGRAPH
    {0xE087, 0x7188}, //5053 #CJK UNIFIED IDEOGRAPH
    {0xE088, 0x7166}, //5054 #CJK UNIFIED IDEOGRAPH
    {0xE089, 0x7162}, //5055 #CJK UNIFIED IDEOGRAPH
    {0xE08A, 0x714C}, //5056 #CJK UNIFIED IDEOGRAPH
    {0xE08B, 0x7156}, //5057 #CJK UNIFIED IDEOGRAPH
    {0xE08C, 0x716C}, //5058 #CJK UNIFIED IDEOGRAPH
    {0xE08D, 0x718F}, //5059 #CJK UNIFIED IDEOGRAPH
    {0xE08E, 0x71FB}, //5060 #CJK UNIFIED IDEOGRAPH
    {0xE08F, 0x7184}, //5061 #CJK UNIFIED IDEOGRAPH
    {0xE090, 0x7195}, //5062 #CJK UNIFIED IDEOGRAPH
    {0xE091, 0x71A8}, //5063 #CJK UNIFIED IDEOGRAPH
    {0xE092, 0x71AC}, //5064 #CJK UNIFIED IDEOGRAPH
    {0xE093, 0x71D7}, //5065 #CJK UNIFIED IDEOGRAPH
    {0xE094, 0x71B9}, //5066 #CJK UNIFIED IDEOGRAPH
    {0xE095, 0x71BE}, //5067 #CJK UNIFIED IDEOGRAPH
    {0xE096, 0x71D2}, //5068 #CJK UNIFIED IDEOGRAPH
    {0xE097, 0x71C9}, //5069 #CJK UNIFIED IDEOGRAPH
    {0xE098, 0x71D4}, //5070 #CJK UNIFIED IDEOGRAPH
    {0xE099, 0x71CE}, //5071 #CJK UNIFIED IDEOGRAPH
    {0xE09A, 0x71E0}, //5072 #CJK UNIFIED IDEOGRAPH
    {0xE09B, 0x71EC}, //5073 #CJK UNIFIED IDEOGRAPH
    {0xE09C, 0x71E7}, //5074 #CJK UNIFIED IDEOGRAPH
    {0xE09D, 0x71F5}, //5075 #CJK UNIFIED IDEOGRAPH
    {0xE09E, 0x71FC}, //5076 #CJK UNIFIED IDEOGRAPH
    {0xE09F, 0x71F9}, //5077 #CJK UNIFIED IDEOGRAPH
    {0xE0A0, 0x71FF}, //5078 #CJK UNIFIED IDEOGRAPH
    {0xE0A1, 0x720D}, //5079 #CJK UNIFIED IDEOGRAPH
    {0xE0A2, 0x7210}, //5080 #CJK UNIFIED IDEOGRAPH
    {0xE0A3, 0x721B}, //5081 #CJK UNIFIED IDEOGRAPH
    {0xE0A4, 0x7228}, //5082 #CJK UNIFIED IDEOGRAPH
    {0xE0A5, 0x722D}, //5083 #CJK UNIFIED IDEOGRAPH
    {0xE0A6, 0x722C}, //5084 #CJK UNIFIED IDEOGRAPH
    {0xE0A7, 0x7230}, //5085 #CJK UNIFIED IDEOGRAPH
    {0xE0A8, 0x7232}, //5086 #CJK UNIFIED IDEOGRAPH
    {0xE0A9, 0x723B}, //5087 #CJK UNIFIED IDEOGRAPH
    {0xE0AA, 0x723C}, //5088 #CJK UNIFIED IDEOGRAPH
    {0xE0AB, 0x723F}, //5089 #CJK UNIFIED IDEOGRAPH
    {0xE0AC, 0x7240}, //5090 #CJK UNIFIED IDEOGRAPH
    {0xE0AD, 0x7246}, //5091 #CJK UNIFIED IDEOGRAPH
    {0xE0AE, 0x724B}, //5092 #CJK UNIFIED IDEOGRAPH
    {0xE0AF, 0x7258}, //5093 #CJK UNIFIED IDEOGRAPH
    {0xE0B0, 0x7274}, //5094 #CJK UNIFIED IDEOGRAPH
    {0xE0B1, 0x727E}, //5095 #CJK UNIFIED IDEOGRAPH
    {0xE0B2, 0x7282}, //5096 #CJK UNIFIED IDEOGRAPH
    {0xE0B3, 0x7281}, //5097 #CJK UNIFIED IDEOGRAPH
    {0xE0B4, 0x7287}, //5098 #CJK UNIFIED IDEOGRAPH
    {0xE0B5, 0x7292}, //5099 #CJK UNIFIED IDEOGRAPH
    {0xE0B6, 0x7296}, //5100 #CJK UNIFIED IDEOGRAPH
    {0xE0B7, 0x72A2}, //5101 #CJK UNIFIED IDEOGRAPH
    {0xE0B8, 0x72A7}, //5102 #CJK UNIFIED IDEOGRAPH
    {0xE0B9, 0x72B9}, //5103 #CJK UNIFIED IDEOGRAPH
    {0xE0BA, 0x72B2}, //5104 #CJK UNIFIED IDEOGRAPH
    {0xE0BB, 0x72C3}, //5105 #CJK UNIFIED IDEOGRAPH
    {0xE0BC, 0x72C6}, //5106 #CJK UNIFIED IDEOGRAPH
    {0xE0BD, 0x72C4}, //5107 #CJK UNIFIED IDEOGRAPH
    {0xE0BE, 0x72CE}, //5108 #CJK UNIFIED IDEOGRAPH
    {0xE0BF, 0x72D2}, //5109 #CJK UNIFIED IDEOGRAPH
    {0xE0C0, 0x72E2}, //5110 #CJK UNIFIED IDEOGRAPH
    {0xE0C1, 0x72E0}, //5111 #CJK UNIFIED IDEOGRAPH
    {0xE0C2, 0x72E1}, //5112 #CJK UNIFIED IDEOGRAPH
    {0xE0C3, 0x72F9}, //5113 #CJK UNIFIED IDEOGRAPH
    {0xE0C4, 0x72F7}, //5114 #CJK UNIFIED IDEOGRAPH
    {0xE0C5, 0x500F}, //5115 #CJK UNIFIED IDEOGRAPH
    {0xE0C6, 0x7317}, //5116 #CJK UNIFIED IDEOGRAPH
    {0xE0C7, 0x730A}, //5117 #CJK UNIFIED IDEOGRAPH
    {0xE0C8, 0x731C}, //5118 #CJK UNIFIED IDEOGRAPH
    {0xE0C9, 0x7316}, //5119 #CJK UNIFIED IDEOGRAPH
    {0xE0CA, 0x731D}, //5120 #CJK UNIFIED IDEOGRAPH
    {0xE0CB, 0x7334}, //5121 #CJK UNIFIED IDEOGRAPH
    {0xE0CC, 0x732F}, //5122 #CJK UNIFIED IDEOGRAPH
    {0xE0CD, 0x7329}, //5123 #CJK UNIFIED IDEOGRAPH
    {0xE0CE, 0x7325}, //5124 #CJK UNIFIED IDEOGRAPH
    {0xE0CF, 0x733E}, //5125 #CJK UNIFIED IDEOGRAPH
    {0xE0D0, 0x734E}, //5126 #CJK UNIFIED IDEOGRAPH
    {0xE0D1, 0x734F}, //5127 #CJK UNIFIED IDEOGRAPH
    {0xE0D2, 0x9ED8}, //5128 #CJK UNIFIED IDEOGRAPH
    {0xE0D3, 0x7357}, //5129 #CJK UNIFIED IDEOGRAPH
    {0xE0D4, 0x736A}, //5130 #CJK UNIFIED IDEOGRAPH
    {0xE0D5, 0x7368}, //5131 #CJK UNIFIED IDEOGRAPH
    {0xE0D6, 0x7370}, //5132 #CJK UNIFIED IDEOGRAPH
    {0xE0D7, 0x7378}, //5133 #CJK UNIFIED IDEOGRAPH
    {0xE0D8, 0x7375}, //5134 #CJK UNIFIED IDEOGRAPH
    {0xE0D9, 0x737B}, //5135 #CJK UNIFIED IDEOGRAPH
    {0xE0DA, 0x737A}, //5136 #CJK UNIFIED IDEOGRAPH
    {0xE0DB, 0x73C8}, //5137 #CJK UNIFIED IDEOGRAPH
    {0xE0DC, 0x73B3}, //5138 #CJK UNIFIED IDEOGRAPH
    {0xE0DD, 0x73CE}, //5139 #CJK UNIFIED IDEOGRAPH
    {0xE0DE, 0x73BB}, //5140 #CJK UNIFIED IDEOGRAPH
    {0xE0DF, 0x73C0}, //5141 #CJK UNIFIED IDEOGRAPH
    {0xE0E0, 0x73E5}, //5142 #CJK UNIFIED IDEOGRAPH
    {0xE0E1, 0x73EE}, //5143 #CJK UNIFIED IDEOGRAPH
    {0xE0E2, 0x73DE}, //5144 #CJK UNIFIED IDEOGRAPH
    {0xE0E3, 0x74A2}, //5145 #CJK UNIFIED IDEOGRAPH
    {0xE0E4, 0x7405}, //5146 #CJK UNIFIED IDEOGRAPH
    {0xE0E5, 0x746F}, //5147 #CJK UNIFIED IDEOGRAPH
    {0xE0E6, 0x7425}, //5148 #CJK UNIFIED IDEOGRAPH
    {0xE0E7, 0x73F8}, //5149 #CJK UNIFIED IDEOGRAPH
    {0xE0E8, 0x7432}, //5150 #CJK UNIFIED IDEOGRAPH
    {0xE0E9, 0x743A}, //5151 #CJK UNIFIED IDEOGRAPH
    {0xE0EA, 0x7455}, //5152 #CJK UNIFIED IDEOGRAPH
    {0xE0EB, 0x743F}, //5153 #CJK UNIFIED IDEOGRAPH
    {0xE0EC, 0x745F}, //5154 #CJK UNIFIED IDEOGRAPH
    {0xE0ED, 0x7459}, //5155 #CJK UNIFIED IDEOGRAPH
    {0xE0EE, 0x7441}, //5156 #CJK UNIFIED IDEOGRAPH
    {0xE0EF, 0x745C}, //5157 #CJK UNIFIED IDEOGRAPH
    {0xE0F0, 0x7469}, //5158 #CJK UNIFIED IDEOGRAPH
    {0xE0F1, 0x7470}, //5159 #CJK UNIFIED IDEOGRAPH
    {0xE0F2, 0x7463}, //5160 #CJK UNIFIED IDEOGRAPH
    {0xE0F3, 0x746A}, //5161 #CJK UNIFIED IDEOGRAPH
    {0xE0F4, 0x7476}, //5162 #CJK UNIFIED IDEOGRAPH
    {0xE0F5, 0x747E}, //5163 #CJK UNIFIED IDEOGRAPH
    {0xE0F6, 0x748B}, //5164 #CJK UNIFIED IDEOGRAPH
    {0xE0F7, 0x749E}, //5165 #CJK UNIFIED IDEOGRAPH
    {0xE0F8, 0x74A7}, //5166 #CJK UNIFIED IDEOGRAPH
    {0xE0F9, 0x74CA}, //5167 #CJK UNIFIED IDEOGRAPH
    {0xE0FA, 0x74CF}, //5168 #CJK UNIFIED IDEOGRAPH
    {0xE0FB, 0x74D4}, //5169 #CJK UNIFIED IDEOGRAPH
    {0xE0FC, 0x73F1}, //5170 #CJK UNIFIED IDEOGRAPH
    {0xE140, 0x74E0}, //5171 #CJK UNIFIED IDEOGRAPH
    {0xE141, 0x74E3}, //5172 #CJK UNIFIED IDEOGRAPH
    {0xE142, 0x74E7}, //5173 #CJK UNIFIED IDEOGRAPH
    {0xE143, 0x74E9}, //5174 #CJK UNIFIED IDEOGRAPH
    {0xE144, 0x74EE}, //5175 #CJK UNIFIED IDEOGRAPH
    {0xE145, 0x74F2}, //5176 #CJK UNIFIED IDEOGRAPH
    {0xE146, 0x74F0}, //5177 #CJK UNIFIED IDEOGRAPH
    {0xE147, 0x74F1}, //5178 #CJK UNIFIED IDEOGRAPH
    {0xE148, 0x74F8}, //5179 #CJK UNIFIED IDEOGRAPH
    {0xE149, 0x74F7}, //5180 #CJK UNIFIED IDEOGRAPH
    {0xE14A, 0x7504}, //5181 #CJK UNIFIED IDEOGRAPH
    {0xE14B, 0x7503}, //5182 #CJK UNIFIED IDEOGRAPH
    {0xE14C, 0x7505}, //5183 #CJK UNIFIED IDEOGRAPH
    {0xE14D, 0x750C}, //5184 #CJK UNIFIED IDEOGRAPH
    {0xE14E, 0x750E}, //5185 #CJK UNIFIED IDEOGRAPH
    {0xE14F, 0x750D}, //5186 #CJK UNIFIED IDEOGRAPH
    {0xE150, 0x7515}, //5187 #CJK UNIFIED IDEOGRAPH
    {0xE151, 0x7513}, //5188 #CJK UNIFIED IDEOGRAPH
    {0xE152, 0x751E}, //5189 #CJK UNIFIED IDEOGRAPH
    {0xE153, 0x7526}, //5190 #CJK UNIFIED IDEOGRAPH
    {0xE154, 0x752C}, //5191 #CJK UNIFIED IDEOGRAPH
    {0xE155, 0x753C}, //5192 #CJK UNIFIED IDEOGRAPH
    {0xE156, 0x7544}, //5193 #CJK UNIFIED IDEOGRAPH
    {0xE157, 0x754D}, //5194 #CJK UNIFIED IDEOGRAPH
    {0xE158, 0x754A}, //5195 #CJK UNIFIED IDEOGRAPH
    {0xE159, 0x7549}, //5196 #CJK UNIFIED IDEOGRAPH
    {0xE15A, 0x755B}, //5197 #CJK UNIFIED IDEOGRAPH
    {0xE15B, 0x7546}, //5198 #CJK UNIFIED IDEOGRAPH
    {0xE15C, 0x755A}, //5199 #CJK UNIFIED IDEOGRAPH
    {0xE15D, 0x7569}, //5200 #CJK UNIFIED IDEOGRAPH
    {0xE15E, 0x7564}, //5201 #CJK UNIFIED IDEOGRAPH
    {0xE15F, 0x7567}, //5202 #CJK UNIFIED IDEOGRAPH
    {0xE160, 0x756B}, //5203 #CJK UNIFIED IDEOGRAPH
    {0xE161, 0x756D}, //5204 #CJK UNIFIED IDEOGRAPH
    {0xE162, 0x7578}, //5205 #CJK UNIFIED IDEOGRAPH
    {0xE163, 0x7576}, //5206 #CJK UNIFIED IDEOGRAPH
    {0xE164, 0x7586}, //5207 #CJK UNIFIED IDEOGRAPH
    {0xE165, 0x7587}, //5208 #CJK UNIFIED IDEOGRAPH
    {0xE166, 0x7574}, //5209 #CJK UNIFIED IDEOGRAPH
    {0xE167, 0x758A}, //5210 #CJK UNIFIED IDEOGRAPH
    {0xE168, 0x7589}, //5211 #CJK UNIFIED IDEOGRAPH
    {0xE169, 0x7582}, //5212 #CJK UNIFIED IDEOGRAPH
    {0xE16A, 0x7594}, //5213 #CJK UNIFIED IDEOGRAPH
    {0xE16B, 0x759A}, //5214 #CJK UNIFIED IDEOGRAPH
    {0xE16C, 0x759D}, //5215 #CJK UNIFIED IDEOGRAPH
    {0xE16D, 0x75A5}, //5216 #CJK UNIFIED IDEOGRAPH
    {0xE16E, 0x75A3}, //5217 #CJK UNIFIED IDEOGRAPH
    {0xE16F, 0x75C2}, //5218 #CJK UNIFIED IDEOGRAPH
    {0xE170, 0x75B3}, //5219 #CJK UNIFIED IDEOGRAPH
    {0xE171, 0x75C3}, //5220 #CJK UNIFIED IDEOGRAPH
    {0xE172, 0x75B5}, //5221 #CJK UNIFIED IDEOGRAPH
    {0xE173, 0x75BD}, //5222 #CJK UNIFIED IDEOGRAPH
    {0xE174, 0x75B8}, //5223 #CJK UNIFIED IDEOGRAPH
    {0xE175, 0x75BC}, //5224 #CJK UNIFIED IDEOGRAPH
    {0xE176, 0x75B1}, //5225 #CJK UNIFIED IDEOGRAPH
    {0xE177, 0x75CD}, //5226 #CJK UNIFIED IDEOGRAPH
    {0xE178, 0x75CA}, //5227 #CJK UNIFIED IDEOGRAPH
    {0xE179, 0x75D2}, //5228 #CJK UNIFIED IDEOGRAPH
    {0xE17A, 0x75D9}, //5229 #CJK UNIFIED IDEOGRAPH
    {0xE17B, 0x75E3}, //5230 #CJK UNIFIED IDEOGRAPH
    {0xE17C, 0x75DE}, //5231 #CJK UNIFIED IDEOGRAPH
    {0xE17D, 0x75FE}, //5232 #CJK UNIFIED IDEOGRAPH
    {0xE17E, 0x75FF}, //5233 #CJK UNIFIED IDEOGRAPH
    {0xE180, 0x75FC}, //5234 #CJK UNIFIED IDEOGRAPH
    {0xE181, 0x7601}, //5235 #CJK UNIFIED IDEOGRAPH
    {0xE182, 0x75F0}, //5236 #CJK UNIFIED IDEOGRAPH
    {0xE183, 0x75FA}, //5237 #CJK UNIFIED IDEOGRAPH
    {0xE184, 0x75F2}, //5238 #CJK UNIFIED IDEOGRAPH
    {0xE185, 0x75F3}, //5239 #CJK UNIFIED IDEOGRAPH
    {0xE186, 0x760B}, //5240 #CJK UNIFIED IDEOGRAPH
    {0xE187, 0x760D}, //5241 #CJK UNIFIED IDEOGRAPH
    {0xE188, 0x7609}, //5242 #CJK UNIFIED IDEOGRAPH
    {0xE189, 0x761F}, //5243 #CJK UNIFIED IDEOGRAPH
    {0xE18A, 0x7627}, //5244 #CJK UNIFIED IDEOGRAPH
    {0xE18B, 0x7620}, //5245 #CJK UNIFIED IDEOGRAPH
    {0xE18C, 0x7621}, //5246 #CJK UNIFIED IDEOGRAPH
    {0xE18D, 0x7622}, //5247 #CJK UNIFIED IDEOGRAPH
    {0xE18E, 0x7624}, //5248 #CJK UNIFIED IDEOGRAPH
    {0xE18F, 0x7634}, //5249 #CJK UNIFIED IDEOGRAPH
    {0xE190, 0x7630}, //5250 #CJK UNIFIED IDEOGRAPH
    {0xE191, 0x763B}, //5251 #CJK UNIFIED IDEOGRAPH
    {0xE192, 0x7647}, //5252 #CJK UNIFIED IDEOGRAPH
    {0xE193, 0x7648}, //5253 #CJK UNIFIED IDEOGRAPH
    {0xE194, 0x7646}, //5254 #CJK UNIFIED IDEOGRAPH
    {0xE195, 0x765C}, //5255 #CJK UNIFIED IDEOGRAPH
    {0xE196, 0x7658}, //5256 #CJK UNIFIED IDEOGRAPH
    {0xE197, 0x7661}, //5257 #CJK UNIFIED IDEOGRAPH
    {0xE198, 0x7662}, //5258 #CJK UNIFIED IDEOGRAPH
    {0xE199, 0x7668}, //5259 #CJK UNIFIED IDEOGRAPH
    {0xE19A, 0x7669}, //5260 #CJK UNIFIED IDEOGRAPH
    {0xE19B, 0x766A}, //5261 #CJK UNIFIED IDEOGRAPH
    {0xE19C, 0x7667}, //5262 #CJK UNIFIED IDEOGRAPH
    {0xE19D, 0x766C}, //5263 #CJK UNIFIED IDEOGRAPH
    {0xE19E, 0x7670}, //5264 #CJK UNIFIED IDEOGRAPH
    {0xE19F, 0x7672}, //5265 #CJK UNIFIED IDEOGRAPH
    {0xE1A0, 0x7676}, //5266 #CJK UNIFIED IDEOGRAPH
    {0xE1A1, 0x7678}, //5267 #CJK UNIFIED IDEOGRAPH
    {0xE1A2, 0x767C}, //5268 #CJK UNIFIED IDEOGRAPH
    {0xE1A3, 0x7680}, //5269 #CJK UNIFIED IDEOGRAPH
    {0xE1A4, 0x7683}, //5270 #CJK UNIFIED IDEOGRAPH
    {0xE1A5, 0x7688}, //5271 #CJK UNIFIED IDEOGRAPH
    {0xE1A6, 0x768B}, //5272 #CJK UNIFIED IDEOGRAPH
    {0xE1A7, 0x768E}, //5273 #CJK UNIFIED IDEOGRAPH
    {0xE1A8, 0x7696}, //5274 #CJK UNIFIED IDEOGRAPH
    {0xE1A9, 0x7693}, //5275 #CJK UNIFIED IDEOGRAPH
    {0xE1AA, 0x7699}, //5276 #CJK UNIFIED IDEOGRAPH
    {0xE1AB, 0x769A}, //5277 #CJK UNIFIED IDEOGRAPH
    {0xE1AC, 0x76B0}, //5278 #CJK UNIFIED IDEOGRAPH
    {0xE1AD, 0x76B4}, //5279 #CJK UNIFIED IDEOGRAPH
    {0xE1AE, 0x76B8}, //5280 #CJK UNIFIED IDEOGRAPH
    {0xE1AF, 0x76B9}, //5281 #CJK UNIFIED IDEOGRAPH
    {0xE1B0, 0x76BA}, //5282 #CJK UNIFIED IDEOGRAPH
    {0xE1B1, 0x76C2}, //5283 #CJK UNIFIED IDEOGRAPH
    {0xE1B2, 0x76CD}, //5284 #CJK UNIFIED IDEOGRAPH
    {0xE1B3, 0x76D6}, //5285 #CJK UNIFIED IDEOGRAPH
    {0xE1B4, 0x76D2}, //5286 #CJK UNIFIED IDEOGRAPH
    {0xE1B5, 0x76DE}, //5287 #CJK UNIFIED IDEOGRAPH
    {0xE1B6, 0x76E1}, //5288 #CJK UNIFIED IDEOGRAPH
    {0xE1B7, 0x76E5}, //5289 #CJK UNIFIED IDEOGRAPH
    {0xE1B8, 0x76E7}, //5290 #CJK UNIFIED IDEOGRAPH
    {0xE1B9, 0x76EA}, //5291 #CJK UNIFIED IDEOGRAPH
    {0xE1BA, 0x862F}, //5292 #CJK UNIFIED IDEOGRAPH
    {0xE1BB, 0x76FB}, //5293 #CJK UNIFIED IDEOGRAPH
    {0xE1BC, 0x7708}, //5294 #CJK UNIFIED IDEOGRAPH
    {0xE1BD, 0x7707}, //5295 #CJK UNIFIED IDEOGRAPH
    {0xE1BE, 0x7704}, //5296 #CJK UNIFIED IDEOGRAPH
    {0xE1BF, 0x7729}, //5297 #CJK UNIFIED IDEOGRAPH
    {0xE1C0, 0x7724}, //5298 #CJK UNIFIED IDEOGRAPH
    {0xE1C1, 0x771E}, //5299 #CJK UNIFIED IDEOGRAPH
    {0xE1C2, 0x7725}, //5300 #CJK UNIFIED IDEOGRAPH
    {0xE1C3, 0x7726}, //5301 #CJK UNIFIED IDEOGRAPH
    {0xE1C4, 0x771B}, //5302 #CJK UNIFIED IDEOGRAPH
    {0xE1C5, 0x7737}, //5303 #CJK UNIFIED IDEOGRAPH
    {0xE1C6, 0x7738}, //5304 #CJK UNIFIED IDEOGRAPH
    {0xE1C7, 0x7747}, //5305 #CJK UNIFIED IDEOGRAPH
    {0xE1C8, 0x775A}, //5306 #CJK UNIFIED IDEOGRAPH
    {0xE1C9, 0x7768}, //5307 #CJK UNIFIED IDEOGRAPH
    {0xE1CA, 0x776B}, //5308 #CJK UNIFIED IDEOGRAPH
    {0xE1CB, 0x775B}, //5309 #CJK UNIFIED IDEOGRAPH
    {0xE1CC, 0x7765}, //5310 #CJK UNIFIED IDEOGRAPH
    {0xE1CD, 0x777F}, //5311 #CJK UNIFIED IDEOGRAPH
    {0xE1CE, 0x777E}, //5312 #CJK UNIFIED IDEOGRAPH
    {0xE1CF, 0x7779}, //5313 #CJK UNIFIED IDEOGRAPH
    {0xE1D0, 0x778E}, //5314 #CJK UNIFIED IDEOGRAPH
    {0xE1D1, 0x778B}, //5315 #CJK UNIFIED IDEOGRAPH
    {0xE1D2, 0x7791}, //5316 #CJK UNIFIED IDEOGRAPH
    {0xE1D3, 0x77A0}, //5317 #CJK UNIFIED IDEOGRAPH
    {0xE1D4, 0x779E}, //5318 #CJK UNIFIED IDEOGRAPH
    {0xE1D5, 0x77B0}, //5319 #CJK UNIFIED IDEOGRAPH
    {0xE1D6, 0x77B6}, //5320 #CJK UNIFIED IDEOGRAPH
    {0xE1D7, 0x77B9}, //5321 #CJK UNIFIED IDEOGRAPH
    {0xE1D8, 0x77BF}, //5322 #CJK UNIFIED IDEOGRAPH
    {0xE1D9, 0x77BC}, //5323 #CJK UNIFIED IDEOGRAPH
    {0xE1DA, 0x77BD}, //5324 #CJK UNIFIED IDEOGRAPH
    {0xE1DB, 0x77BB}, //5325 #CJK UNIFIED IDEOGRAPH
    {0xE1DC, 0x77C7}, //5326 #CJK UNIFIED IDEOGRAPH
    {0xE1DD, 0x77CD}, //5327 #CJK UNIFIED IDEOGRAPH
    {0xE1DE, 0x77D7}, //5328 #CJK UNIFIED IDEOGRAPH
    {0xE1DF, 0x77DA}, //5329 #CJK UNIFIED IDEOGRAPH
    {0xE1E0, 0x77DC}, //5330 #CJK UNIFIED IDEOGRAPH
    {0xE1E1, 0x77E3}, //5331 #CJK UNIFIED IDEOGRAPH
    {0xE1E2, 0x77EE}, //5332 #CJK UNIFIED IDEOGRAPH
    {0xE1E3, 0x77FC}, //5333 #CJK UNIFIED IDEOGRAPH
    {0xE1E4, 0x780C}, //5334 #CJK UNIFIED IDEOGRAPH
    {0xE1E5, 0x7812}, //5335 #CJK UNIFIED IDEOGRAPH
    {0xE1E6, 0x7926}, //5336 #CJK UNIFIED IDEOGRAPH
    {0xE1E7, 0x7820}, //5337 #CJK UNIFIED IDEOGRAPH
    {0xE1E8, 0x792A}, //5338 #CJK UNIFIED IDEOGRAPH
    {0xE1E9, 0x7845}, //5339 #CJK UNIFIED IDEOGRAPH
    {0xE1EA, 0x788E}, //5340 #CJK UNIFIED IDEOGRAPH
    {0xE1EB, 0x7874}, //5341 #CJK UNIFIED IDEOGRAPH
    {0xE1EC, 0x7886}, //5342 #CJK UNIFIED IDEOGRAPH
    {0xE1ED, 0x787C}, //5343 #CJK UNIFIED IDEOGRAPH
    {0xE1EE, 0x789A}, //5344 #CJK UNIFIED IDEOGRAPH
    {0xE1EF, 0x788C}, //5345 #CJK UNIFIED IDEOGRAPH
    {0xE1F0, 0x78A3}, //5346 #CJK UNIFIED IDEOGRAPH
    {0xE1F1, 0x78B5}, //5347 #CJK UNIFIED IDEOGRAPH
    {0xE1F2, 0x78AA}, //5348 #CJK UNIFIED IDEOGRAPH
    {0xE1F3, 0x78AF}, //5349 #CJK UNIFIED IDEOGRAPH
    {0xE1F4, 0x78D1}, //5350 #CJK UNIFIED IDEOGRAPH
    {0xE1F5, 0x78C6}, //5351 #CJK UNIFIED IDEOGRAPH
    {0xE1F6, 0x78CB}, //5352 #CJK UNIFIED IDEOGRAPH
    {0xE1F7, 0x78D4}, //5353 #CJK UNIFIED IDEOGRAPH
    {0xE1F8, 0x78BE}, //5354 #CJK UNIFIED IDEOGRAPH
    {0xE1F9, 0x78BC}, //5355 #CJK UNIFIED IDEOGRAPH
    {0xE1FA, 0x78C5}, //5356 #CJK UNIFIED IDEOGRAPH
    {0xE1FB, 0x78CA}, //5357 #CJK UNIFIED IDEOGRAPH
    {0xE1FC, 0x78EC}, //5358 #CJK UNIFIED IDEOGRAPH
    {0xE240, 0x78E7}, //5359 #CJK UNIFIED IDEOGRAPH
    {0xE241, 0x78DA}, //5360 #CJK UNIFIED IDEOGRAPH
    {0xE242, 0x78FD}, //5361 #CJK UNIFIED IDEOGRAPH
    {0xE243, 0x78F4}, //5362 #CJK UNIFIED IDEOGRAPH
    {0xE244, 0x7907}, //5363 #CJK UNIFIED IDEOGRAPH
    {0xE245, 0x7912}, //5364 #CJK UNIFIED IDEOGRAPH
    {0xE246, 0x7911}, //5365 #CJK UNIFIED IDEOGRAPH
    {0xE247, 0x7919}, //5366 #CJK UNIFIED IDEOGRAPH
    {0xE248, 0x792C}, //5367 #CJK UNIFIED IDEOGRAPH
    {0xE249, 0x792B}, //5368 #CJK UNIFIED IDEOGRAPH
    {0xE24A, 0x7940}, //5369 #CJK UNIFIED IDEOGRAPH
    {0xE24B, 0x7960}, //5370 #CJK UNIFIED IDEOGRAPH
    {0xE24C, 0x7957}, //5371 #CJK UNIFIED IDEOGRAPH
    {0xE24D, 0x795F}, //5372 #CJK UNIFIED IDEOGRAPH
    {0xE24E, 0x795A}, //5373 #CJK UNIFIED IDEOGRAPH
    {0xE24F, 0x7955}, //5374 #CJK UNIFIED IDEOGRAPH
    {0xE250, 0x7953}, //5375 #CJK UNIFIED IDEOGRAPH
    {0xE251, 0x797A}, //5376 #CJK UNIFIED IDEOGRAPH
    {0xE252, 0x797F}, //5377 #CJK UNIFIED IDEOGRAPH
    {0xE253, 0x798A}, //5378 #CJK UNIFIED IDEOGRAPH
    {0xE254, 0x799D}, //5379 #CJK UNIFIED IDEOGRAPH
    {0xE255, 0x79A7}, //5380 #CJK UNIFIED IDEOGRAPH
    {0xE256, 0x9F4B}, //5381 #CJK UNIFIED IDEOGRAPH
    {0xE257, 0x79AA}, //5382 #CJK UNIFIED IDEOGRAPH
    {0xE258, 0x79AE}, //5383 #CJK UNIFIED IDEOGRAPH
    {0xE259, 0x79B3}, //5384 #CJK UNIFIED IDEOGRAPH
    {0xE25A, 0x79B9}, //5385 #CJK UNIFIED IDEOGRAPH
    {0xE25B, 0x79BA}, //5386 #CJK UNIFIED IDEOGRAPH
    {0xE25C, 0x79C9}, //5387 #CJK UNIFIED IDEOGRAPH
    {0xE25D, 0x79D5}, //5388 #CJK UNIFIED IDEOGRAPH
    {0xE25E, 0x79E7}, //5389 #CJK UNIFIED IDEOGRAPH
    {0xE25F, 0x79EC}, //5390 #CJK UNIFIED IDEOGRAPH
    {0xE260, 0x79E1}, //5391 #CJK UNIFIED IDEOGRAPH
    {0xE261, 0x79E3}, //5392 #CJK UNIFIED IDEOGRAPH
    {0xE262, 0x7A08}, //5393 #CJK UNIFIED IDEOGRAPH
    {0xE263, 0x7A0D}, //5394 #CJK UNIFIED IDEOGRAPH
    {0xE264, 0x7A18}, //5395 #CJK UNIFIED IDEOGRAPH
    {0xE265, 0x7A19}, //5396 #CJK UNIFIED IDEOGRAPH
    {0xE266, 0x7A20}, //5397 #CJK UNIFIED IDEOGRAPH
    {0xE267, 0x7A1F}, //5398 #CJK UNIFIED IDEOGRAPH
    {0xE268, 0x7980}, //5399 #CJK UNIFIED IDEOGRAPH
    {0xE269, 0x7A31}, //5400 #CJK UNIFIED IDEOGRAPH
    {0xE26A, 0x7A3B}, //5401 #CJK UNIFIED IDEOGRAPH
    {0xE26B, 0x7A3E}, //5402 #CJK UNIFIED IDEOGRAPH
    {0xE26C, 0x7A37}, //5403 #CJK UNIFIED IDEOGRAPH
    {0xE26D, 0x7A43}, //5404 #CJK UNIFIED IDEOGRAPH
    {0xE26E, 0x7A57}, //5405 #CJK UNIFIED IDEOGRAPH
    {0xE26F, 0x7A49}, //5406 #CJK UNIFIED IDEOGRAPH
    {0xE270, 0x7A61}, //5407 #CJK UNIFIED IDEOGRAPH
    {0xE271, 0x7A62}, //5408 #CJK UNIFIED IDEOGRAPH
    {0xE272, 0x7A69}, //5409 #CJK UNIFIED IDEOGRAPH
    {0xE273, 0x9F9D}, //5410 #CJK UNIFIED IDEOGRAPH
    {0xE274, 0x7A70}, //5411 #CJK UNIFIED IDEOGRAPH
    {0xE275, 0x7A79}, //5412 #CJK UNIFIED IDEOGRAPH
    {0xE276, 0x7A7D}, //5413 #CJK UNIFIED IDEOGRAPH
    {0xE277, 0x7A88}, //5414 #CJK UNIFIED IDEOGRAPH
    {0xE278, 0x7A97}, //5415 #CJK UNIFIED IDEOGRAPH
    {0xE279, 0x7A95}, //5416 #CJK UNIFIED IDEOGRAPH
    {0xE27A, 0x7A98}, //5417 #CJK UNIFIED IDEOGRAPH
    {0xE27B, 0x7A96}, //5418 #CJK UNIFIED IDEOGRAPH
    {0xE27C, 0x7AA9}, //5419 #CJK UNIFIED IDEOGRAPH
    {0xE27D, 0x7AC8}, //5420 #CJK UNIFIED IDEOGRAPH
    {0xE27E, 0x7AB0}, //5421 #CJK UNIFIED IDEOGRAPH
    {0xE280, 0x7AB6}, //5422 #CJK UNIFIED IDEOGRAPH
    {0xE281, 0x7AC5}, //5423 #CJK UNIFIED IDEOGRAPH
    {0xE282, 0x7AC4}, //5424 #CJK UNIFIED IDEOGRAPH
    {0xE283, 0x7ABF}, //5425 #CJK UNIFIED IDEOGRAPH
    {0xE284, 0x9083}, //5426 #CJK UNIFIED IDEOGRAPH
    {0xE285, 0x7AC7}, //5427 #CJK UNIFIED IDEOGRAPH
    {0xE286, 0x7ACA}, //5428 #CJK UNIFIED IDEOGRAPH
    {0xE287, 0x7ACD}, //5429 #CJK UNIFIED IDEOGRAPH
    {0xE288, 0x7ACF}, //5430 #CJK UNIFIED IDEOGRAPH
    {0xE289, 0x7AD5}, //5431 #CJK UNIFIED IDEOGRAPH
    {0xE28A, 0x7AD3}, //5432 #CJK UNIFIED IDEOGRAPH
    {0xE28B, 0x7AD9}, //5433 #CJK UNIFIED IDEOGRAPH
    {0xE28C, 0x7ADA}, //5434 #CJK UNIFIED IDEOGRAPH
    {0xE28D, 0x7ADD}, //5435 #CJK UNIFIED IDEOGRAPH
    {0xE28E, 0x7AE1}, //5436 #CJK UNIFIED IDEOGRAPH
    {0xE28F, 0x7AE2}, //5437 #CJK UNIFIED IDEOGRAPH
    {0xE290, 0x7AE6}, //5438 #CJK UNIFIED IDEOGRAPH
    {0xE291, 0x7AED}, //5439 #CJK UNIFIED IDEOGRAPH
    {0xE292, 0x7AF0}, //5440 #CJK UNIFIED IDEOGRAPH
    {0xE293, 0x7B02}, //5441 #CJK UNIFIED IDEOGRAPH
    {0xE294, 0x7B0F}, //5442 #CJK UNIFIED IDEOGRAPH
    {0xE295, 0x7B0A}, //5443 #CJK UNIFIED IDEOGRAPH
    {0xE296, 0x7B06}, //5444 #CJK UNIFIED IDEOGRAPH
    {0xE297, 0x7B33}, //5445 #CJK UNIFIED IDEOGRAPH
    {0xE298, 0x7B18}, //5446 #CJK UNIFIED IDEOGRAPH
    {0xE299, 0x7B19}, //5447 #CJK UNIFIED IDEOGRAPH
    {0xE29A, 0x7B1E}, //5448 #CJK UNIFIED IDEOGRAPH
    {0xE29B, 0x7B35}, //5449 #CJK UNIFIED IDEOGRAPH
    {0xE29C, 0x7B28}, //5450 #CJK UNIFIED IDEOGRAPH
    {0xE29D, 0x7B36}, //5451 #CJK UNIFIED IDEOGRAPH
    {0xE29E, 0x7B50}, //5452 #CJK UNIFIED IDEOGRAPH
    {0xE29F, 0x7B7A}, //5453 #CJK UNIFIED IDEOGRAPH
    {0xE2A0, 0x7B04}, //5454 #CJK UNIFIED IDEOGRAPH
    {0xE2A1, 0x7B4D}, //5455 #CJK UNIFIED IDEOGRAPH
    {0xE2A2, 0x7B0B}, //5456 #CJK UNIFIED IDEOGRAPH
    {0xE2A3, 0x7B4C}, //5457 #CJK UNIFIED IDEOGRAPH
    {0xE2A4, 0x7B45}, //5458 #CJK UNIFIED IDEOGRAPH
    {0xE2A5, 0x7B75}, //5459 #CJK UNIFIED IDEOGRAPH
    {0xE2A6, 0x7B65}, //5460 #CJK UNIFIED IDEOGRAPH
    {0xE2A7, 0x7B74}, //5461 #CJK UNIFIED IDEOGRAPH
    {0xE2A8, 0x7B67}, //5462 #CJK UNIFIED IDEOGRAPH
    {0xE2A9, 0x7B70}, //5463 #CJK UNIFIED IDEOGRAPH
    {0xE2AA, 0x7B71}, //5464 #CJK UNIFIED IDEOGRAPH
    {0xE2AB, 0x7B6C}, //5465 #CJK UNIFIED IDEOGRAPH
    {0xE2AC, 0x7B6E}, //5466 #CJK UNIFIED IDEOGRAPH
    {0xE2AD, 0x7B9D}, //5467 #CJK UNIFIED IDEOGRAPH
    {0xE2AE, 0x7B98}, //5468 #CJK UNIFIED IDEOGRAPH
    {0xE2AF, 0x7B9F}, //5469 #CJK UNIFIED IDEOGRAPH
    {0xE2B0, 0x7B8D}, //5470 #CJK UNIFIED IDEOGRAPH
    {0xE2B1, 0x7B9C}, //5471 #CJK UNIFIED IDEOGRAPH
    {0xE2B2, 0x7B9A}, //5472 #CJK UNIFIED IDEOGRAPH
    {0xE2B3, 0x7B8B}, //5473 #CJK UNIFIED IDEOGRAPH
    {0xE2B4, 0x7B92}, //5474 #CJK UNIFIED IDEOGRAPH
    {0xE2B5, 0x7B8F}, //5475 #CJK UNIFIED IDEOGRAPH
    {0xE2B6, 0x7B5D}, //5476 #CJK UNIFIED IDEOGRAPH
    {0xE2B7, 0x7B99}, //5477 #CJK UNIFIED IDEOGRAPH
    {0xE2B8, 0x7BCB}, //5478 #CJK UNIFIED IDEOGRAPH
    {0xE2B9, 0x7BC1}, //5479 #CJK UNIFIED IDEOGRAPH
    {0xE2BA, 0x7BCC}, //5480 #CJK UNIFIED IDEOGRAPH
    {0xE2BB, 0x7BCF}, //5481 #CJK UNIFIED IDEOGRAPH
    {0xE2BC, 0x7BB4}, //5482 #CJK UNIFIED IDEOGRAPH
    {0xE2BD, 0x7BC6}, //5483 #CJK UNIFIED IDEOGRAPH
    {0xE2BE, 0x7BDD}, //5484 #CJK UNIFIED IDEOGRAPH
    {0xE2BF, 0x7BE9}, //5485 #CJK UNIFIED IDEOGRAPH
    {0xE2C0, 0x7C11}, //5486 #CJK UNIFIED IDEOGRAPH
    {0xE2C1, 0x7C14}, //5487 #CJK UNIFIED IDEOGRAPH
    {0xE2C2, 0x7BE6}, //5488 #CJK UNIFIED IDEOGRAPH
    {0xE2C3, 0x7BE5}, //5489 #CJK UNIFIED IDEOGRAPH
    {0xE2C4, 0x7C60}, //5490 #CJK UNIFIED IDEOGRAPH
    {0xE2C5, 0x7C00}, //5491 #CJK UNIFIED IDEOGRAPH
    {0xE2C6, 0x7C07}, //5492 #CJK UNIFIED IDEOGRAPH
    {0xE2C7, 0x7C13}, //5493 #CJK UNIFIED IDEOGRAPH
    {0xE2C8, 0x7BF3}, //5494 #CJK UNIFIED IDEOGRAPH
    {0xE2C9, 0x7BF7}, //5495 #CJK UNIFIED IDEOGRAPH
    {0xE2CA, 0x7C17}, //5496 #CJK UNIFIED IDEOGRAPH
    {0xE2CB, 0x7C0D}, //5497 #CJK UNIFIED IDEOGRAPH
    {0xE2CC, 0x7BF6}, //5498 #CJK UNIFIED IDEOGRAPH
    {0xE2CD, 0x7C23}, //5499 #CJK UNIFIED IDEOGRAPH
    {0xE2CE, 0x7C27}, //5500 #CJK UNIFIED IDEOGRAPH
    {0xE2CF, 0x7C2A}, //5501 #CJK UNIFIED IDEOGRAPH
    {0xE2D0, 0x7C1F}, //5502 #CJK UNIFIED IDEOGRAPH
    {0xE2D1, 0x7C37}, //5503 #CJK UNIFIED IDEOGRAPH
    {0xE2D2, 0x7C2B}, //5504 #CJK UNIFIED IDEOGRAPH
    {0xE2D3, 0x7C3D}, //5505 #CJK UNIFIED IDEOGRAPH
    {0xE2D4, 0x7C4C}, //5506 #CJK UNIFIED IDEOGRAPH
    {0xE2D5, 0x7C43}, //5507 #CJK UNIFIED IDEOGRAPH
    {0xE2D6, 0x7C54}, //5508 #CJK UNIFIED IDEOGRAPH
    {0xE2D7, 0x7C4F}, //5509 #CJK UNIFIED IDEOGRAPH
    {0xE2D8, 0x7C40}, //5510 #CJK UNIFIED IDEOGRAPH
    {0xE2D9, 0x7C50}, //5511 #CJK UNIFIED IDEOGRAPH
    {0xE2DA, 0x7C58}, //5512 #CJK UNIFIED IDEOGRAPH
    {0xE2DB, 0x7C5F}, //5513 #CJK UNIFIED IDEOGRAPH
    {0xE2DC, 0x7C64}, //5514 #CJK UNIFIED IDEOGRAPH
    {0xE2DD, 0x7C56}, //5515 #CJK UNIFIED IDEOGRAPH
    {0xE2DE, 0x7C65}, //5516 #CJK UNIFIED IDEOGRAPH
    {0xE2DF, 0x7C6C}, //5517 #CJK UNIFIED IDEOGRAPH
    {0xE2E0, 0x7C75}, //5518 #CJK UNIFIED IDEOGRAPH
    {0xE2E1, 0x7C83}, //5519 #CJK UNIFIED IDEOGRAPH
    {0xE2E2, 0x7C90}, //5520 #CJK UNIFIED IDEOGRAPH
    {0xE2E3, 0x7CA4}, //5521 #CJK UNIFIED IDEOGRAPH
    {0xE2E4, 0x7CAD}, //5522 #CJK UNIFIED IDEOGRAPH
    {0xE2E5, 0x7CA2}, //5523 #CJK UNIFIED IDEOGRAPH
    {0xE2E6, 0x7CAB}, //5524 #CJK UNIFIED IDEOGRAPH
    {0xE2E7, 0x7CA1}, //5525 #CJK UNIFIED IDEOGRAPH
    {0xE2E8, 0x7CA8}, //5526 #CJK UNIFIED IDEOGRAPH
    {0xE2E9, 0x7CB3}, //5527 #CJK UNIFIED IDEOGRAPH
    {0xE2EA, 0x7CB2}, //5528 #CJK UNIFIED IDEOGRAPH
    {0xE2EB, 0x7CB1}, //5529 #CJK UNIFIED IDEOGRAPH
    {0xE2EC, 0x7CAE}, //5530 #CJK UNIFIED IDEOGRAPH
    {0xE2ED, 0x7CB9}, //5531 #CJK UNIFIED IDEOGRAPH
    {0xE2EE, 0x7CBD}, //5532 #CJK UNIFIED IDEOGRAPH
    {0xE2EF, 0x7CC0}, //5533 #CJK UNIFIED IDEOGRAPH
    {0xE2F0, 0x7CC5}, //5534 #CJK UNIFIED IDEOGRAPH
    {0xE2F1, 0x7CC2}, //5535 #CJK UNIFIED IDEOGRAPH
    {0xE2F2, 0x7CD8}, //5536 #CJK UNIFIED IDEOGRAPH
    {0xE2F3, 0x7CD2}, //5537 #CJK UNIFIED IDEOGRAPH
    {0xE2F4, 0x7CDC}, //5538 #CJK UNIFIED IDEOGRAPH
    {0xE2F5, 0x7CE2}, //5539 #CJK UNIFIED IDEOGRAPH
    {0xE2F6, 0x9B3B}, //5540 #CJK UNIFIED IDEOGRAPH
    {0xE2F7, 0x7CEF}, //5541 #CJK UNIFIED IDEOGRAPH
    {0xE2F8, 0x7CF2}, //5542 #CJK UNIFIED IDEOGRAPH
    {0xE2F9, 0x7CF4}, //5543 #CJK UNIFIED IDEOGRAPH
    {0xE2FA, 0x7CF6}, //5544 #CJK UNIFIED IDEOGRAPH
    {0xE2FB, 0x7CFA}, //5545 #CJK UNIFIED IDEOGRAPH
    {0xE2FC, 0x7D06}, //5546 #CJK UNIFIED IDEOGRAPH
    {0xE340, 0x7D02}, //5547 #CJK UNIFIED IDEOGRAPH
    {0xE341, 0x7D1C}, //5548 #CJK UNIFIED IDEOGRAPH
    {0xE342, 0x7D15}, //5549 #CJK UNIFIED IDEOGRAPH
    {0xE343, 0x7D0A}, //5550 #CJK UNIFIED IDEOGRAPH
    {0xE344, 0x7D45}, //5551 #CJK UNIFIED IDEOGRAPH
    {0xE345, 0x7D4B}, //5552 #CJK UNIFIED IDEOGRAPH
    {0xE346, 0x7D2E}, //5553 #CJK UNIFIED IDEOGRAPH
    {0xE347, 0x7D32}, //5554 #CJK UNIFIED IDEOGRAPH
    {0xE348, 0x7D3F}, //5555 #CJK UNIFIED IDEOGRAPH
    {0xE349, 0x7D35}, //5556 #CJK UNIFIED IDEOGRAPH
    {0xE34A, 0x7D46}, //5557 #CJK UNIFIED IDEOGRAPH
    {0xE34B, 0x7D73}, //5558 #CJK UNIFIED IDEOGRAPH
    {0xE34C, 0x7D56}, //5559 #CJK UNIFIED IDEOGRAPH
    {0xE34D, 0x7D4E}, //5560 #CJK UNIFIED IDEOGRAPH
    {0xE34E, 0x7D72}, //5561 #CJK UNIFIED IDEOGRAPH
    {0xE34F, 0x7D68}, //5562 #CJK UNIFIED IDEOGRAPH
    {0xE350, 0x7D6E}, //5563 #CJK UNIFIED IDEOGRAPH
    {0xE351, 0x7D4F}, //5564 #CJK UNIFIED IDEOGRAPH
    {0xE352, 0x7D63}, //5565 #CJK UNIFIED IDEOGRAPH
    {0xE353, 0x7D93}, //5566 #CJK UNIFIED IDEOGRAPH
    {0xE354, 0x7D89}, //5567 #CJK UNIFIED IDEOGRAPH
    {0xE355, 0x7D5B}, //5568 #CJK UNIFIED IDEOGRAPH
    {0xE356, 0x7D8F}, //5569 #CJK UNIFIED IDEOGRAPH
    {0xE357, 0x7D7D}, //5570 #CJK UNIFIED IDEOGRAPH
    {0xE358, 0x7D9B}, //5571 #CJK UNIFIED IDEOGRAPH
    {0xE359, 0x7DBA}, //5572 #CJK UNIFIED IDEOGRAPH
    {0xE35A, 0x7DAE}, //5573 #CJK UNIFIED IDEOGRAPH
    {0xE35B, 0x7DA3}, //5574 #CJK UNIFIED IDEOGRAPH
    {0xE35C, 0x7DB5}, //5575 #CJK UNIFIED IDEOGRAPH
    {0xE35D, 0x7DC7}, //5576 #CJK UNIFIED IDEOGRAPH
    {0xE35E, 0x7DBD}, //5577 #CJK UNIFIED IDEOGRAPH
    {0xE35F, 0x7DAB}, //5578 #CJK UNIFIED IDEOGRAPH
    {0xE360, 0x7E3D}, //5579 #CJK UNIFIED IDEOGRAPH
    {0xE361, 0x7DA2}, //5580 #CJK UNIFIED IDEOGRAPH
    {0xE362, 0x7DAF}, //5581 #CJK UNIFIED IDEOGRAPH
    {0xE363, 0x7DDC}, //5582 #CJK UNIFIED IDEOGRAPH
    {0xE364, 0x7DB8}, //5583 #CJK UNIFIED IDEOGRAPH
    {0xE365, 0x7D9F}, //5584 #CJK UNIFIED IDEOGRAPH
    {0xE366, 0x7DB0}, //5585 #CJK UNIFIED IDEOGRAPH
    {0xE367, 0x7DD8}, //5586 #CJK UNIFIED IDEOGRAPH
    {0xE368, 0x7DDD}, //5587 #CJK UNIFIED IDEOGRAPH
    {0xE369, 0x7DE4}, //5588 #CJK UNIFIED IDEOGRAPH
    {0xE36A, 0x7DDE}, //5589 #CJK UNIFIED IDEOGRAPH
    {0xE36B, 0x7DFB}, //5590 #CJK UNIFIED IDEOGRAPH
    {0xE36C, 0x7DF2}, //5591 #CJK UNIFIED IDEOGRAPH
    {0xE36D, 0x7DE1}, //5592 #CJK UNIFIED IDEOGRAPH
    {0xE36E, 0x7E05}, //5593 #CJK UNIFIED IDEOGRAPH
    {0xE36F, 0x7E0A}, //5594 #CJK UNIFIED IDEOGRAPH
    {0xE370, 0x7E23}, //5595 #CJK UNIFIED IDEOGRAPH
    {0xE371, 0x7E21}, //5596 #CJK UNIFIED IDEOGRAPH
    {0xE372, 0x7E12}, //5597 #CJK UNIFIED IDEOGRAPH
    {0xE373, 0x7E31}, //5598 #CJK UNIFIED IDEOGRAPH
    {0xE374, 0x7E1F}, //5599 #CJK UNIFIED IDEOGRAPH
    {0xE375, 0x7E09}, //5600 #CJK UNIFIED IDEOGRAPH
    {0xE376, 0x7E0B}, //5601 #CJK UNIFIED IDEOGRAPH
    {0xE377, 0x7E22}, //5602 #CJK UNIFIED IDEOGRAPH
    {0xE378, 0x7E46}, //5603 #CJK UNIFIED IDEOGRAPH
    {0xE379, 0x7E66}, //5604 #CJK UNIFIED IDEOGRAPH
    {0xE37A, 0x7E3B}, //5605 #CJK UNIFIED IDEOGRAPH
    {0xE37B, 0x7E35}, //5606 #CJK UNIFIED IDEOGRAPH
    {0xE37C, 0x7E39}, //5607 #CJK UNIFIED IDEOGRAPH
    {0xE37D, 0x7E43}, //5608 #CJK UNIFIED IDEOGRAPH
    {0xE37E, 0x7E37}, //5609 #CJK UNIFIED IDEOGRAPH
    {0xE380, 0x7E32}, //5610 #CJK UNIFIED IDEOGRAPH
    {0xE381, 0x7E3A}, //5611 #CJK UNIFIED IDEOGRAPH
    {0xE382, 0x7E67}, //5612 #CJK UNIFIED IDEOGRAPH
    {0xE383, 0x7E5D}, //5613 #CJK UNIFIED IDEOGRAPH
    {0xE384, 0x7E56}, //5614 #CJK UNIFIED IDEOGRAPH
    {0xE385, 0x7E5E}, //5615 #CJK UNIFIED IDEOGRAPH
    {0xE386, 0x7E59}, //5616 #CJK UNIFIED IDEOGRAPH
    {0xE387, 0x7E5A}, //5617 #CJK UNIFIED IDEOGRAPH
    {0xE388, 0x7E79}, //5618 #CJK UNIFIED IDEOGRAPH
    {0xE389, 0x7E6A}, //5619 #CJK UNIFIED IDEOGRAPH
    {0xE38A, 0x7E69}, //5620 #CJK UNIFIED IDEOGRAPH
    {0xE38B, 0x7E7C}, //5621 #CJK UNIFIED IDEOGRAPH
    {0xE38C, 0x7E7B}, //5622 #CJK UNIFIED IDEOGRAPH
    {0xE38D, 0x7E83}, //5623 #CJK UNIFIED IDEOGRAPH
    {0xE38E, 0x7DD5}, //5624 #CJK UNIFIED IDEOGRAPH
    {0xE38F, 0x7E7D}, //5625 #CJK UNIFIED IDEOGRAPH
    {0xE390, 0x8FAE}, //5626 #CJK UNIFIED IDEOGRAPH
    {0xE391, 0x7E7F}, //5627 #CJK UNIFIED IDEOGRAPH
    {0xE392, 0x7E88}, //5628 #CJK UNIFIED IDEOGRAPH
    {0xE393, 0x7E89}, //5629 #CJK UNIFIED IDEOGRAPH
    {0xE394, 0x7E8C}, //5630 #CJK UNIFIED IDEOGRAPH
    {0xE395, 0x7E92}, //5631 #CJK UNIFIED IDEOGRAPH
    {0xE396, 0x7E90}, //5632 #CJK UNIFIED IDEOGRAPH
    {0xE397, 0x7E93}, //5633 #CJK UNIFIED IDEOGRAPH
    {0xE398, 0x7E94}, //5634 #CJK UNIFIED IDEOGRAPH
    {0xE399, 0x7E96}, //5635 #CJK UNIFIED IDEOGRAPH
    {0xE39A, 0x7E8E}, //5636 #CJK UNIFIED IDEOGRAPH
    {0xE39B, 0x7E9B}, //5637 #CJK UNIFIED IDEOGRAPH
    {0xE39C, 0x7E9C}, //5638 #CJK UNIFIED IDEOGRAPH
    {0xE39D, 0x7F38}, //5639 #CJK UNIFIED IDEOGRAPH
    {0xE39E, 0x7F3A}, //5640 #CJK UNIFIED IDEOGRAPH
    {0xE39F, 0x7F45}, //5641 #CJK UNIFIED IDEOGRAPH
    {0xE3A0, 0x7F4C}, //5642 #CJK UNIFIED IDEOGRAPH
    {0xE3A1, 0x7F4D}, //5643 #CJK UNIFIED IDEOGRAPH
    {0xE3A2, 0x7F4E}, //5644 #CJK UNIFIED IDEOGRAPH
    {0xE3A3, 0x7F50}, //5645 #CJK UNIFIED IDEOGRAPH
    {0xE3A4, 0x7F51}, //5646 #CJK UNIFIED IDEOGRAPH
    {0xE3A5, 0x7F55}, //5647 #CJK UNIFIED IDEOGRAPH
    {0xE3A6, 0x7F54}, //5648 #CJK UNIFIED IDEOGRAPH
    {0xE3A7, 0x7F58}, //5649 #CJK UNIFIED IDEOGRAPH
    {0xE3A8, 0x7F5F}, //5650 #CJK UNIFIED IDEOGRAPH
    {0xE3A9, 0x7F60}, //5651 #CJK UNIFIED IDEOGRAPH
    {0xE3AA, 0x7F68}, //5652 #CJK UNIFIED IDEOGRAPH
    {0xE3AB, 0x7F69}, //5653 #CJK UNIFIED IDEOGRAPH
    {0xE3AC, 0x7F67}, //5654 #CJK UNIFIED IDEOGRAPH
    {0xE3AD, 0x7F78}, //5655 #CJK UNIFIED IDEOGRAPH
    {0xE3AE, 0x7F82}, //5656 #CJK UNIFIED IDEOGRAPH
    {0xE3AF, 0x7F86}, //5657 #CJK UNIFIED IDEOGRAPH
    {0xE3B0, 0x7F83}, //5658 #CJK UNIFIED IDEOGRAPH
    {0xE3B1, 0x7F88}, //5659 #CJK UNIFIED IDEOGRAPH
    {0xE3B2, 0x7F87}, //5660 #CJK UNIFIED IDEOGRAPH
    {0xE3B3, 0x7F8C}, //5661 #CJK UNIFIED IDEOGRAPH
    {0xE3B4, 0x7F94}, //5662 #CJK UNIFIED IDEOGRAPH
    {0xE3B5, 0x7F9E}, //5663 #CJK UNIFIED IDEOGRAPH
    {0xE3B6, 0x7F9D}, //5664 #CJK UNIFIED IDEOGRAPH
    {0xE3B7, 0x7F9A}, //5665 #CJK UNIFIED IDEOGRAPH
    {0xE3B8, 0x7FA3}, //5666 #CJK UNIFIED IDEOGRAPH
    {0xE3B9, 0x7FAF}, //5667 #CJK UNIFIED IDEOGRAPH
    {0xE3BA, 0x7FB2}, //5668 #CJK UNIFIED IDEOGRAPH
    {0xE3BB, 0x7FB9}, //5669 #CJK UNIFIED IDEOGRAPH
    {0xE3BC, 0x7FAE}, //5670 #CJK UNIFIED IDEOGRAPH
    {0xE3BD, 0x7FB6}, //5671 #CJK UNIFIED IDEOGRAPH
    {0xE3BE, 0x7FB8}, //5672 #CJK UNIFIED IDEOGRAPH
    {0xE3BF, 0x8B71}, //5673 #CJK UNIFIED IDEOGRAPH
    {0xE3C0, 0x7FC5}, //5674 #CJK UNIFIED IDEOGRAPH
    {0xE3C1, 0x7FC6}, //5675 #CJK UNIFIED IDEOGRAPH
    {0xE3C2, 0x7FCA}, //5676 #CJK UNIFIED IDEOGRAPH
    {0xE3C3, 0x7FD5}, //5677 #CJK UNIFIED IDEOGRAPH
    {0xE3C4, 0x7FD4}, //5678 #CJK UNIFIED IDEOGRAPH
    {0xE3C5, 0x7FE1}, //5679 #CJK UNIFIED IDEOGRAPH
    {0xE3C6, 0x7FE6}, //5680 #CJK UNIFIED IDEOGRAPH
    {0xE3C7, 0x7FE9}, //5681 #CJK UNIFIED IDEOGRAPH
    {0xE3C8, 0x7FF3}, //5682 #CJK UNIFIED IDEOGRAPH
    {0xE3C9, 0x7FF9}, //5683 #CJK UNIFIED IDEOGRAPH
    {0xE3CA, 0x98DC}, //5684 #CJK UNIFIED IDEOGRAPH
    {0xE3CB, 0x8006}, //5685 #CJK UNIFIED IDEOGRAPH
    {0xE3CC, 0x8004}, //5686 #CJK UNIFIED IDEOGRAPH
    {0xE3CD, 0x800B}, //5687 #CJK UNIFIED IDEOGRAPH
    {0xE3CE, 0x8012}, //5688 #CJK UNIFIED IDEOGRAPH
    {0xE3CF, 0x8018}, //5689 #CJK UNIFIED IDEOGRAPH
    {0xE3D0, 0x8019}, //5690 #CJK UNIFIED IDEOGRAPH
    {0xE3D1, 0x801C}, //5691 #CJK UNIFIED IDEOGRAPH
    {0xE3D2, 0x8021}, //5692 #CJK UNIFIED IDEOGRAPH
    {0xE3D3, 0x8028}, //5693 #CJK UNIFIED IDEOGRAPH
    {0xE3D4, 0x803F}, //5694 #CJK UNIFIED IDEOGRAPH
    {0xE3D5, 0x803B}, //5695 #CJK UNIFIED IDEOGRAPH
    {0xE3D6, 0x804A}, //5696 #CJK UNIFIED IDEOGRAPH
    {0xE3D7, 0x8046}, //5697 #CJK UNIFIED IDEOGRAPH
    {0xE3D8, 0x8052}, //5698 #CJK UNIFIED IDEOGRAPH
    {0xE3D9, 0x8058}, //5699 #CJK UNIFIED IDEOGRAPH
    {0xE3DA, 0x805A}, //5700 #CJK UNIFIED IDEOGRAPH
    {0xE3DB, 0x805F}, //5701 #CJK UNIFIED IDEOGRAPH
    {0xE3DC, 0x8062}, //5702 #CJK UNIFIED IDEOGRAPH
    {0xE3DD, 0x8068}, //5703 #CJK UNIFIED IDEOGRAPH
    {0xE3DE, 0x8073}, //5704 #CJK UNIFIED IDEOGRAPH
    {0xE3DF, 0x8072}, //5705 #CJK UNIFIED IDEOGRAPH
    {0xE3E0, 0x8070}, //5706 #CJK UNIFIED IDEOGRAPH
    {0xE3E1, 0x8076}, //5707 #CJK UNIFIED IDEOGRAPH
    {0xE3E2, 0x8079}, //5708 #CJK UNIFIED IDEOGRAPH
    {0xE3E3, 0x807D}, //5709 #CJK UNIFIED IDEOGRAPH
    {0xE3E4, 0x807F}, //5710 #CJK UNIFIED IDEOGRAPH
    {0xE3E5, 0x8084}, //5711 #CJK UNIFIED IDEOGRAPH
    {0xE3E6, 0x8086}, //5712 #CJK UNIFIED IDEOGRAPH
    {0xE3E7, 0x8085}, //5713 #CJK UNIFIED IDEOGRAPH
    {0xE3E8, 0x809B}, //5714 #CJK UNIFIED IDEOGRAPH
    {0xE3E9, 0x8093}, //5715 #CJK UNIFIED IDEOGRAPH
    {0xE3EA, 0x809A}, //5716 #CJK UNIFIED IDEOGRAPH
    {0xE3EB, 0x80AD}, //5717 #CJK UNIFIED IDEOGRAPH
    {0xE3EC, 0x5190}, //5718 #CJK UNIFIED IDEOGRAPH
    {0xE3ED, 0x80AC}, //5719 #CJK UNIFIED IDEOGRAPH
    {0xE3EE, 0x80DB}, //5720 #CJK UNIFIED IDEOGRAPH
    {0xE3EF, 0x80E5}, //5721 #CJK UNIFIED IDEOGRAPH
    {0xE3F0, 0x80D9}, //5722 #CJK UNIFIED IDEOGRAPH
    {0xE3F1, 0x80DD}, //5723 #CJK UNIFIED IDEOGRAPH
    {0xE3F2, 0x80C4}, //5724 #CJK UNIFIED IDEOGRAPH
    {0xE3F3, 0x80DA}, //5725 #CJK UNIFIED IDEOGRAPH
    {0xE3F4, 0x80D6}, //5726 #CJK UNIFIED IDEOGRAPH
    {0xE3F5, 0x8109}, //5727 #CJK UNIFIED IDEOGRAPH
    {0xE3F6, 0x80EF}, //5728 #CJK UNIFIED IDEOGRAPH
    {0xE3F7, 0x80F1}, //5729 #CJK UNIFIED IDEOGRAPH
    {0xE3F8, 0x811B}, //5730 #CJK UNIFIED IDEOGRAPH
    {0xE3F9, 0x8129}, //5731 #CJK UNIFIED IDEOGRAPH
    {0xE3FA, 0x8123}, //5732 #CJK UNIFIED IDEOGRAPH
    {0xE3FB, 0x812F}, //5733 #CJK UNIFIED IDEOGRAPH
    {0xE3FC, 0x814B}, //5734 #CJK UNIFIED IDEOGRAPH
    {0xE440, 0x968B}, //5735 #CJK UNIFIED IDEOGRAPH
    {0xE441, 0x8146}, //5736 #CJK UNIFIED IDEOGRAPH
    {0xE442, 0x813E}, //5737 #CJK UNIFIED IDEOGRAPH
    {0xE443, 0x8153}, //5738 #CJK UNIFIED IDEOGRAPH
    {0xE444, 0x8151}, //5739 #CJK UNIFIED IDEOGRAPH
    {0xE445, 0x80FC}, //5740 #CJK UNIFIED IDEOGRAPH
    {0xE446, 0x8171}, //5741 #CJK UNIFIED IDEOGRAPH
    {0xE447, 0x816E}, //5742 #CJK UNIFIED IDEOGRAPH
    {0xE448, 0x8165}, //5743 #CJK UNIFIED IDEOGRAPH
    {0xE449, 0x8166}, //5744 #CJK UNIFIED IDEOGRAPH
    {0xE44A, 0x8174}, //5745 #CJK UNIFIED IDEOGRAPH
    {0xE44B, 0x8183}, //5746 #CJK UNIFIED IDEOGRAPH
    {0xE44C, 0x8188}, //5747 #CJK UNIFIED IDEOGRAPH
    {0xE44D, 0x818A}, //5748 #CJK UNIFIED IDEOGRAPH
    {0xE44E, 0x8180}, //5749 #CJK UNIFIED IDEOGRAPH
    {0xE44F, 0x8182}, //5750 #CJK UNIFIED IDEOGRAPH
    {0xE450, 0x81A0}, //5751 #CJK UNIFIED IDEOGRAPH
    {0xE451, 0x8195}, //5752 #CJK UNIFIED IDEOGRAPH
    {0xE452, 0x81A4}, //5753 #CJK UNIFIED IDEOGRAPH
    {0xE453, 0x81A3}, //5754 #CJK UNIFIED IDEOGRAPH
    {0xE454, 0x815F}, //5755 #CJK UNIFIED IDEOGRAPH
    {0xE455, 0x8193}, //5756 #CJK UNIFIED IDEOGRAPH
    {0xE456, 0x81A9}, //5757 #CJK UNIFIED IDEOGRAPH
    {0xE457, 0x81B0}, //5758 #CJK UNIFIED IDEOGRAPH
    {0xE458, 0x81B5}, //5759 #CJK UNIFIED IDEOGRAPH
    {0xE459, 0x81BE}, //5760 #CJK UNIFIED IDEOGRAPH
    {0xE45A, 0x81B8}, //5761 #CJK UNIFIED IDEOGRAPH
    {0xE45B, 0x81BD}, //5762 #CJK UNIFIED IDEOGRAPH
    {0xE45C, 0x81C0}, //5763 #CJK UNIFIED IDEOGRAPH
    {0xE45D, 0x81C2}, //5764 #CJK UNIFIED IDEOGRAPH
    {0xE45E, 0x81BA}, //5765 #CJK UNIFIED IDEOGRAPH
    {0xE45F, 0x81C9}, //5766 #CJK UNIFIED IDEOGRAPH
    {0xE460, 0x81CD}, //5767 #CJK UNIFIED IDEOGRAPH
    {0xE461, 0x81D1}, //5768 #CJK UNIFIED IDEOGRAPH
    {0xE462, 0x81D9}, //5769 #CJK UNIFIED IDEOGRAPH
    {0xE463, 0x81D8}, //5770 #CJK UNIFIED IDEOGRAPH
    {0xE464, 0x81C8}, //5771 #CJK UNIFIED IDEOGRAPH
    {0xE465, 0x81DA}, //5772 #CJK UNIFIED IDEOGRAPH
    {0xE466, 0x81DF}, //5773 #CJK UNIFIED IDEOGRAPH
    {0xE467, 0x81E0}, //5774 #CJK UNIFIED IDEOGRAPH
    {0xE468, 0x81E7}, //5775 #CJK UNIFIED IDEOGRAPH
    {0xE469, 0x81FA}, //5776 #CJK UNIFIED IDEOGRAPH
    {0xE46A, 0x81FB}, //5777 #CJK UNIFIED IDEOGRAPH
    {0xE46B, 0x81FE}, //5778 #CJK UNIFIED IDEOGRAPH
    {0xE46C, 0x8201}, //5779 #CJK UNIFIED IDEOGRAPH
    {0xE46D, 0x8202}, //5780 #CJK UNIFIED IDEOGRAPH
    {0xE46E, 0x8205}, //5781 #CJK UNIFIED IDEOGRAPH
    {0xE46F, 0x8207}, //5782 #CJK UNIFIED IDEOGRAPH
    {0xE470, 0x820A}, //5783 #CJK UNIFIED IDEOGRAPH
    {0xE471, 0x820D}, //5784 #CJK UNIFIED IDEOGRAPH
    {0xE472, 0x8210}, //5785 #CJK UNIFIED IDEOGRAPH
    {0xE473, 0x8216}, //5786 #CJK UNIFIED IDEOGRAPH
    {0xE474, 0x8229}, //5787 #CJK UNIFIED IDEOGRAPH
    {0xE475, 0x822B}, //5788 #CJK UNIFIED IDEOGRAPH
    {0xE476, 0x8238}, //5789 #CJK UNIFIED IDEOGRAPH
    {0xE477, 0x8233}, //5790 #CJK UNIFIED IDEOGRAPH
    {0xE478, 0x8240}, //5791 #CJK UNIFIED IDEOGRAPH
    {0xE479, 0x8259}, //5792 #CJK UNIFIED IDEOGRAPH
    {0xE47A, 0x8258}, //5793 #CJK UNIFIED IDEOGRAPH
    {0xE47B, 0x825D}, //5794 #CJK UNIFIED IDEOGRAPH
    {0xE47C, 0x825A}, //5795 #CJK UNIFIED IDEOGRAPH
    {0xE47D, 0x825F}, //5796 #CJK UNIFIED IDEOGRAPH
    {0xE47E, 0x8264}, //5797 #CJK UNIFIED IDEOGRAPH
    {0xE480, 0x8262}, //5798 #CJK UNIFIED IDEOGRAPH
    {0xE481, 0x8268}, //5799 #CJK UNIFIED IDEOGRAPH
    {0xE482, 0x826A}, //5800 #CJK UNIFIED IDEOGRAPH
    {0xE483, 0x826B}, //5801 #CJK UNIFIED IDEOGRAPH
    {0xE484, 0x822E}, //5802 #CJK UNIFIED IDEOGRAPH
    {0xE485, 0x8271}, //5803 #CJK UNIFIED IDEOGRAPH
    {0xE486, 0x8277}, //5804 #CJK UNIFIED IDEOGRAPH
    {0xE487, 0x8278}, //5805 #CJK UNIFIED IDEOGRAPH
    {0xE488, 0x827E}, //5806 #CJK UNIFIED IDEOGRAPH
    {0xE489, 0x828D}, //5807 #CJK UNIFIED IDEOGRAPH
    {0xE48A, 0x8292}, //5808 #CJK UNIFIED IDEOGRAPH
    {0xE48B, 0x82AB}, //5809 #CJK UNIFIED IDEOGRAPH
    {0xE48C, 0x829F}, //5810 #CJK UNIFIED IDEOGRAPH
    {0xE48D, 0x82BB}, //5811 #CJK UNIFIED IDEOGRAPH
    {0xE48E, 0x82AC}, //5812 #CJK UNIFIED IDEOGRAPH
    {0xE48F, 0x82E1}, //5813 #CJK UNIFIED IDEOGRAPH
    {0xE490, 0x82E3}, //5814 #CJK UNIFIED IDEOGRAPH
    {0xE491, 0x82DF}, //5815 #CJK UNIFIED IDEOGRAPH
    {0xE492, 0x82D2}, //5816 #CJK UNIFIED IDEOGRAPH
    {0xE493, 0x82F4}, //5817 #CJK UNIFIED IDEOGRAPH
    {0xE494, 0x82F3}, //5818 #CJK UNIFIED IDEOGRAPH
    {0xE495, 0x82FA}, //5819 #CJK UNIFIED IDEOGRAPH
    {0xE496, 0x8393}, //5820 #CJK UNIFIED IDEOGRAPH
    {0xE497, 0x8303}, //5821 #CJK UNIFIED IDEOGRAPH
    {0xE498, 0x82FB}, //5822 #CJK UNIFIED IDEOGRAPH
    {0xE499, 0x82F9}, //5823 #CJK UNIFIED IDEOGRAPH
    {0xE49A, 0x82DE}, //5824 #CJK UNIFIED IDEOGRAPH
    {0xE49B, 0x8306}, //5825 #CJK UNIFIED IDEOGRAPH
    {0xE49C, 0x82DC}, //5826 #CJK UNIFIED IDEOGRAPH
    {0xE49D, 0x8309}, //5827 #CJK UNIFIED IDEOGRAPH
    {0xE49E, 0x82D9}, //5828 #CJK UNIFIED IDEOGRAPH
    {0xE49F, 0x8335}, //5829 #CJK UNIFIED IDEOGRAPH
    {0xE4A0, 0x8334}, //5830 #CJK UNIFIED IDEOGRAPH
    {0xE4A1, 0x8316}, //5831 #CJK UNIFIED IDEOGRAPH
    {0xE4A2, 0x8332}, //5832 #CJK UNIFIED IDEOGRAPH
    {0xE4A3, 0x8331}, //5833 #CJK UNIFIED IDEOGRAPH
    {0xE4A4, 0x8340}, //5834 #CJK UNIFIED IDEOGRAPH
    {0xE4A5, 0x8339}, //5835 #CJK UNIFIED IDEOGRAPH
    {0xE4A6, 0x8350}, //5836 #CJK UNIFIED IDEOGRAPH
    {0xE4A7, 0x8345}, //5837 #CJK UNIFIED IDEOGRAPH
    {0xE4A8, 0x832F}, //5838 #CJK UNIFIED IDEOGRAPH
    {0xE4A9, 0x832B}, //5839 #CJK UNIFIED IDEOGRAPH
    {0xE4AA, 0x8317}, //5840 #CJK UNIFIED IDEOGRAPH
    {0xE4AB, 0x8318}, //5841 #CJK UNIFIED IDEOGRAPH
    {0xE4AC, 0x8385}, //5842 #CJK UNIFIED IDEOGRAPH
    {0xE4AD, 0x839A}, //5843 #CJK UNIFIED IDEOGRAPH
    {0xE4AE, 0x83AA}, //5844 #CJK UNIFIED IDEOGRAPH
    {0xE4AF, 0x839F}, //5845 #CJK UNIFIED IDEOGRAPH
    {0xE4B0, 0x83A2}, //5846 #CJK UNIFIED IDEOGRAPH
    {0xE4B1, 0x8396}, //5847 #CJK UNIFIED IDEOGRAPH
    {0xE4B2, 0x8323}, //5848 #CJK UNIFIED IDEOGRAPH
    {0xE4B3, 0x838E}, //5849 #CJK UNIFIED IDEOGRAPH
    {0xE4B4, 0x8387}, //5850 #CJK UNIFIED IDEOGRAPH
    {0xE4B5, 0x838A}, //5851 #CJK UNIFIED IDEOGRAPH
    {0xE4B6, 0x837C}, //5852 #CJK UNIFIED IDEOGRAPH
    {0xE4B7, 0x83B5}, //5853 #CJK UNIFIED IDEOGRAPH
    {0xE4B8, 0x8373}, //5854 #CJK UNIFIED IDEOGRAPH
    {0xE4B9, 0x8375}, //5855 #CJK UNIFIED IDEOGRAPH
    {0xE4BA, 0x83A0}, //5856 #CJK UNIFIED IDEOGRAPH
    {0xE4BB, 0x8389}, //5857 #CJK UNIFIED IDEOGRAPH
    {0xE4BC, 0x83A8}, //5858 #CJK UNIFIED IDEOGRAPH
    {0xE4BD, 0x83F4}, //5859 #CJK UNIFIED IDEOGRAPH
    {0xE4BE, 0x8413}, //5860 #CJK UNIFIED IDEOGRAPH
    {0xE4BF, 0x83EB}, //5861 #CJK UNIFIED IDEOGRAPH
    {0xE4C0, 0x83CE}, //5862 #CJK UNIFIED IDEOGRAPH
    {0xE4C1, 0x83FD}, //5863 #CJK UNIFIED IDEOGRAPH
    {0xE4C2, 0x8403}, //5864 #CJK UNIFIED IDEOGRAPH
    {0xE4C3, 0x83D8}, //5865 #CJK UNIFIED IDEOGRAPH
    {0xE4C4, 0x840B}, //5866 #CJK UNIFIED IDEOGRAPH
    {0xE4C5, 0x83C1}, //5867 #CJK UNIFIED IDEOGRAPH
    {0xE4C6, 0x83F7}, //5868 #CJK UNIFIED IDEOGRAPH
    {0xE4C7, 0x8407}, //5869 #CJK UNIFIED IDEOGRAPH
    {0xE4C8, 0x83E0}, //5870 #CJK UNIFIED IDEOGRAPH
    {0xE4C9, 0x83F2}, //5871 #CJK UNIFIED IDEOGRAPH
    {0xE4CA, 0x840D}, //5872 #CJK UNIFIED IDEOGRAPH
    {0xE4CB, 0x8422}, //5873 #CJK UNIFIED IDEOGRAPH
    {0xE4CC, 0x8420}, //5874 #CJK UNIFIED IDEOGRAPH
    {0xE4CD, 0x83BD}, //5875 #CJK UNIFIED IDEOGRAPH
    {0xE4CE, 0x8438}, //5876 #CJK UNIFIED IDEOGRAPH
    {0xE4CF, 0x8506}, //5877 #CJK UNIFIED IDEOGRAPH
    {0xE4D0, 0x83FB}, //5878 #CJK UNIFIED IDEOGRAPH
    {0xE4D1, 0x846D}, //5879 #CJK UNIFIED IDEOGRAPH
    {0xE4D2, 0x842A}, //5880 #CJK UNIFIED IDEOGRAPH
    {0xE4D3, 0x843C}, //5881 #CJK UNIFIED IDEOGRAPH
    {0xE4D4, 0x855A}, //5882 #CJK UNIFIED IDEOGRAPH
    {0xE4D5, 0x8484}, //5883 #CJK UNIFIED IDEOGRAPH
    {0xE4D6, 0x8477}, //5884 #CJK UNIFIED IDEOGRAPH
    {0xE4D7, 0x846B}, //5885 #CJK UNIFIED IDEOGRAPH
    {0xE4D8, 0x84AD}, //5886 #CJK UNIFIED IDEOGRAPH
    {0xE4D9, 0x846E}, //5887 #CJK UNIFIED IDEOGRAPH
    {0xE4DA, 0x8482}, //5888 #CJK UNIFIED IDEOGRAPH
    {0xE4DB, 0x8469}, //5889 #CJK UNIFIED IDEOGRAPH
    {0xE4DC, 0x8446}, //5890 #CJK UNIFIED IDEOGRAPH
    {0xE4DD, 0x842C}, //5891 #CJK UNIFIED IDEOGRAPH
    {0xE4DE, 0x846F}, //5892 #CJK UNIFIED IDEOGRAPH
    {0xE4DF, 0x8479}, //5893 #CJK UNIFIED IDEOGRAPH
    {0xE4E0, 0x8435}, //5894 #CJK UNIFIED IDEOGRAPH
    {0xE4E1, 0x84CA}, //5895 #CJK UNIFIED IDEOGRAPH
    {0xE4E2, 0x8462}, //5896 #CJK UNIFIED IDEOGRAPH
    {0xE4E3, 0x84B9}, //5897 #CJK UNIFIED IDEOGRAPH
    {0xE4E4, 0x84BF}, //5898 #CJK UNIFIED IDEOGRAPH
    {0xE4E5, 0x849F}, //5899 #CJK UNIFIED IDEOGRAPH
    {0xE4E6, 0x84D9}, //5900 #CJK UNIFIED IDEOGRAPH
    {0xE4E7, 0x84CD}, //5901 #CJK UNIFIED IDEOGRAPH
    {0xE4E8, 0x84BB}, //5902 #CJK UNIFIED IDEOGRAPH
    {0xE4E9, 0x84DA}, //5903 #CJK UNIFIED IDEOGRAPH
    {0xE4EA, 0x84D0}, //5904 #CJK UNIFIED IDEOGRAPH
    {0xE4EB, 0x84C1}, //5905 #CJK UNIFIED IDEOGRAPH
    {0xE4EC, 0x84C6}, //5906 #CJK UNIFIED IDEOGRAPH
    {0xE4ED, 0x84D6}, //5907 #CJK UNIFIED IDEOGRAPH
    {0xE4EE, 0x84A1}, //5908 #CJK UNIFIED IDEOGRAPH
    {0xE4EF, 0x8521}, //5909 #CJK UNIFIED IDEOGRAPH
    {0xE4F0, 0x84FF}, //5910 #CJK UNIFIED IDEOGRAPH
    {0xE4F1, 0x84F4}, //5911 #CJK UNIFIED IDEOGRAPH
    {0xE4F2, 0x8517}, //5912 #CJK UNIFIED IDEOGRAPH
    {0xE4F3, 0x8518}, //5913 #CJK UNIFIED IDEOGRAPH
    {0xE4F4, 0x852C}, //5914 #CJK UNIFIED IDEOGRAPH
    {0xE4F5, 0x851F}, //5915 #CJK UNIFIED IDEOGRAPH
    {0xE4F6, 0x8515}, //5916 #CJK UNIFIED IDEOGRAPH
    {0xE4F7, 0x8514}, //5917 #CJK UNIFIED IDEOGRAPH
    {0xE4F8, 0x84FC}, //5918 #CJK UNIFIED IDEOGRAPH
    {0xE4F9, 0x8540}, //5919 #CJK UNIFIED IDEOGRAPH
    {0xE4FA, 0x8563}, //5920 #CJK UNIFIED IDEOGRAPH
    {0xE4FB, 0x8558}, //5921 #CJK UNIFIED IDEOGRAPH
    {0xE4FC, 0x8548}, //5922 #CJK UNIFIED IDEOGRAPH
    {0xE540, 0x8541}, //5923 #CJK UNIFIED IDEOGRAPH
    {0xE541, 0x8602}, //5924 #CJK UNIFIED IDEOGRAPH
    {0xE542, 0x854B}, //5925 #CJK UNIFIED IDEOGRAPH
    {0xE543, 0x8555}, //5926 #CJK UNIFIED IDEOGRAPH
    {0xE544, 0x8580}, //5927 #CJK UNIFIED IDEOGRAPH
    {0xE545, 0x85A4}, //5928 #CJK UNIFIED IDEOGRAPH
    {0xE546, 0x8588}, //5929 #CJK UNIFIED IDEOGRAPH
    {0xE547, 0x8591}, //5930 #CJK UNIFIED IDEOGRAPH
    {0xE548, 0x858A}, //5931 #CJK UNIFIED IDEOGRAPH
    {0xE549, 0x85A8}, //5932 #CJK UNIFIED IDEOGRAPH
    {0xE54A, 0x856D}, //5933 #CJK UNIFIED IDEOGRAPH
    {0xE54B, 0x8594}, //5934 #CJK UNIFIED IDEOGRAPH
    {0xE54C, 0x859B}, //5935 #CJK UNIFIED IDEOGRAPH
    {0xE54D, 0x85EA}, //5936 #CJK UNIFIED IDEOGRAPH
    {0xE54E, 0x8587}, //5937 #CJK UNIFIED IDEOGRAPH
    {0xE54F, 0x859C}, //5938 #CJK UNIFIED IDEOGRAPH
    {0xE550, 0x8577}, //5939 #CJK UNIFIED IDEOGRAPH
    {0xE551, 0x857E}, //5940 #CJK UNIFIED IDEOGRAPH
    {0xE552, 0x8590}, //5941 #CJK UNIFIED IDEOGRAPH
    {0xE553, 0x85C9}, //5942 #CJK UNIFIED IDEOGRAPH
    {0xE554, 0x85BA}, //5943 #CJK UNIFIED IDEOGRAPH
    {0xE555, 0x85CF}, //5944 #CJK UNIFIED IDEOGRAPH
    {0xE556, 0x85B9}, //5945 #CJK UNIFIED IDEOGRAPH
    {0xE557, 0x85D0}, //5946 #CJK UNIFIED IDEOGRAPH
    {0xE558, 0x85D5}, //5947 #CJK UNIFIED IDEOGRAPH
    {0xE559, 0x85DD}, //5948 #CJK UNIFIED IDEOGRAPH
    {0xE55A, 0x85E5}, //5949 #CJK UNIFIED IDEOGRAPH
    {0xE55B, 0x85DC}, //5950 #CJK UNIFIED IDEOGRAPH
    {0xE55C, 0x85F9}, //5951 #CJK UNIFIED IDEOGRAPH
    {0xE55D, 0x860A}, //5952 #CJK UNIFIED IDEOGRAPH
    {0xE55E, 0x8613}, //5953 #CJK UNIFIED IDEOGRAPH
    {0xE55F, 0x860B}, //5954 #CJK UNIFIED IDEOGRAPH
    {0xE560, 0x85FE}, //5955 #CJK UNIFIED IDEOGRAPH
    {0xE561, 0x85FA}, //5956 #CJK UNIFIED IDEOGRAPH
    {0xE562, 0x8606}, //5957 #CJK UNIFIED IDEOGRAPH
    {0xE563, 0x8622}, //5958 #CJK UNIFIED IDEOGRAPH
    {0xE564, 0x861A}, //5959 #CJK UNIFIED IDEOGRAPH
    {0xE565, 0x8630}, //5960 #CJK UNIFIED IDEOGRAPH
    {0xE566, 0x863F}, //5961 #CJK UNIFIED IDEOGRAPH
    {0xE567, 0x864D}, //5962 #CJK UNIFIED IDEOGRAPH
    {0xE568, 0x4E55}, //5963 #CJK UNIFIED IDEOGRAPH
    {0xE569, 0x8654}, //5964 #CJK UNIFIED IDEOGRAPH
    {0xE56A, 0x865F}, //5965 #CJK UNIFIED IDEOGRAPH
    {0xE56B, 0x8667}, //5966 #CJK UNIFIED IDEOGRAPH
    {0xE56C, 0x8671}, //5967 #CJK UNIFIED IDEOGRAPH
    {0xE56D, 0x8693}, //5968 #CJK UNIFIED IDEOGRAPH
    {0xE56E, 0x86A3}, //5969 #CJK UNIFIED IDEOGRAPH
    {0xE56F, 0x86A9}, //5970 #CJK UNIFIED IDEOGRAPH
    {0xE570, 0x86AA}, //5971 #CJK UNIFIED IDEOGRAPH
    {0xE571, 0x868B}, //5972 #CJK UNIFIED IDEOGRAPH
    {0xE572, 0x868C}, //5973 #CJK UNIFIED IDEOGRAPH
    {0xE573, 0x86B6}, //5974 #CJK UNIFIED IDEOGRAPH
    {0xE574, 0x86AF}, //5975 #CJK UNIFIED IDEOGRAPH
    {0xE575, 0x86C4}, //5976 #CJK UNIFIED IDEOGRAPH
    {0xE576, 0x86C6}, //5977 #CJK UNIFIED IDEOGRAPH
    {0xE577, 0x86B0}, //5978 #CJK UNIFIED IDEOGRAPH
    {0xE578, 0x86C9}, //5979 #CJK UNIFIED IDEOGRAPH
    {0xE579, 0x8823}, //5980 #CJK UNIFIED IDEOGRAPH
    {0xE57A, 0x86AB}, //5981 #CJK UNIFIED IDEOGRAPH
    {0xE57B, 0x86D4}, //5982 #CJK UNIFIED IDEOGRAPH
    {0xE57C, 0x86DE}, //5983 #CJK UNIFIED IDEOGRAPH
    {0xE57D, 0x86E9}, //5984 #CJK UNIFIED IDEOGRAPH
    {0xE57E, 0x86EC}, //5985 #CJK UNIFIED IDEOGRAPH
    {0xE580, 0x86DF}, //5986 #CJK UNIFIED IDEOGRAPH
    {0xE581, 0x86DB}, //5987 #CJK UNIFIED IDEOGRAPH
    {0xE582, 0x86EF}, //5988 #CJK UNIFIED IDEOGRAPH
    {0xE583, 0x8712}, //5989 #CJK UNIFIED IDEOGRAPH
    {0xE584, 0x8706}, //5990 #CJK UNIFIED IDEOGRAPH
    {0xE585, 0x8708}, //5991 #CJK UNIFIED IDEOGRAPH
    {0xE586, 0x8700}, //5992 #CJK UNIFIED IDEOGRAPH
    {0xE587, 0x8703}, //5993 #CJK UNIFIED IDEOGRAPH
    {0xE588, 0x86FB}, //5994 #CJK UNIFIED IDEOGRAPH
    {0xE589, 0x8711}, //5995 #CJK UNIFIED IDEOGRAPH
    {0xE58A, 0x8709}, //5996 #CJK UNIFIED IDEOGRAPH
    {0xE58B, 0x870D}, //5997 #CJK UNIFIED IDEOGRAPH
    {0xE58C, 0x86F9}, //5998 #CJK UNIFIED IDEOGRAPH
    {0xE58D, 0x870A}, //5999 #CJK UNIFIED IDEOGRAPH
    {0xE58E, 0x8734}, //6000 #CJK UNIFIED IDEOGRAPH
    {0xE58F, 0x873F}, //6001 #CJK UNIFIED IDEOGRAPH
    {0xE590, 0x8737}, //6002 #CJK UNIFIED IDEOGRAPH
    {0xE591, 0x873B}, //6003 #CJK UNIFIED IDEOGRAPH
    {0xE592, 0x8725}, //6004 #CJK UNIFIED IDEOGRAPH
    {0xE593, 0x8729}, //6005 #CJK UNIFIED IDEOGRAPH
    {0xE594, 0x871A}, //6006 #CJK UNIFIED IDEOGRAPH
    {0xE595, 0x8760}, //6007 #CJK UNIFIED IDEOGRAPH
    {0xE596, 0x875F}, //6008 #CJK UNIFIED IDEOGRAPH
    {0xE597, 0x8778}, //6009 #CJK UNIFIED IDEOGRAPH
    {0xE598, 0x874C}, //6010 #CJK UNIFIED IDEOGRAPH
    {0xE599, 0x874E}, //6011 #CJK UNIFIED IDEOGRAPH
    {0xE59A, 0x8774}, //6012 #CJK UNIFIED IDEOGRAPH
    {0xE59B, 0x8757}, //6013 #CJK UNIFIED IDEOGRAPH
    {0xE59C, 0x8768}, //6014 #CJK UNIFIED IDEOGRAPH
    {0xE59D, 0x876E}, //6015 #CJK UNIFIED IDEOGRAPH
    {0xE59E, 0x8759}, //6016 #CJK UNIFIED IDEOGRAPH
    {0xE59F, 0x8753}, //6017 #CJK UNIFIED IDEOGRAPH
    {0xE5A0, 0x8763}, //6018 #CJK UNIFIED IDEOGRAPH
    {0xE5A1, 0x876A}, //6019 #CJK UNIFIED IDEOGRAPH
    {0xE5A2, 0x8805}, //6020 #CJK UNIFIED IDEOGRAPH
    {0xE5A3, 0x87A2}, //6021 #CJK UNIFIED IDEOGRAPH
    {0xE5A4, 0x879F}, //6022 #CJK UNIFIED IDEOGRAPH
    {0xE5A5, 0x8782}, //6023 #CJK UNIFIED IDEOGRAPH
    {0xE5A6, 0x87AF}, //6024 #CJK UNIFIED IDEOGRAPH
    {0xE5A7, 0x87CB}, //6025 #CJK UNIFIED IDEOGRAPH
    {0xE5A8, 0x87BD}, //6026 #CJK UNIFIED IDEOGRAPH
    {0xE5A9, 0x87C0}, //6027 #CJK UNIFIED IDEOGRAPH
    {0xE5AA, 0x87D0}, //6028 #CJK UNIFIED IDEOGRAPH
    {0xE5AB, 0x96D6}, //6029 #CJK UNIFIED IDEOGRAPH
    {0xE5AC, 0x87AB}, //6030 #CJK UNIFIED IDEOGRAPH
    {0xE5AD, 0x87C4}, //6031 #CJK UNIFIED IDEOGRAPH
    {0xE5AE, 0x87B3}, //6032 #CJK UNIFIED IDEOGRAPH
    {0xE5AF, 0x87C7}, //6033 #CJK UNIFIED IDEOGRAPH
    {0xE5B0, 0x87C6}, //6034 #CJK UNIFIED IDEOGRAPH
    {0xE5B1, 0x87BB}, //6035 #CJK UNIFIED IDEOGRAPH
    {0xE5B2, 0x87EF}, //6036 #CJK UNIFIED IDEOGRAPH
    {0xE5B3, 0x87F2}, //6037 #CJK UNIFIED IDEOGRAPH
    {0xE5B4, 0x87E0}, //6038 #CJK UNIFIED IDEOGRAPH
    {0xE5B5, 0x880F}, //6039 #CJK UNIFIED IDEOGRAPH
    {0xE5B6, 0x880D}, //6040 #CJK UNIFIED IDEOGRAPH
    {0xE5B7, 0x87FE}, //6041 #CJK UNIFIED IDEOGRAPH
    {0xE5B8, 0x87F6}, //6042 #CJK UNIFIED IDEOGRAPH
    {0xE5B9, 0x87F7}, //6043 #CJK UNIFIED IDEOGRAPH
    {0xE5BA, 0x880E}, //6044 #CJK UNIFIED IDEOGRAPH
    {0xE5BB, 0x87D2}, //6045 #CJK UNIFIED IDEOGRAPH
    {0xE5BC, 0x8811}, //6046 #CJK UNIFIED IDEOGRAPH
    {0xE5BD, 0x8816}, //6047 #CJK UNIFIED IDEOGRAPH
    {0xE5BE, 0x8815}, //6048 #CJK UNIFIED IDEOGRAPH
    {0xE5BF, 0x8822}, //6049 #CJK UNIFIED IDEOGRAPH
    {0xE5C0, 0x8821}, //6050 #CJK UNIFIED IDEOGRAPH
    {0xE5C1, 0x8831}, //6051 #CJK UNIFIED IDEOGRAPH
    {0xE5C2, 0x8836}, //6052 #CJK UNIFIED IDEOGRAPH
    {0xE5C3, 0x8839}, //6053 #CJK UNIFIED IDEOGRAPH
    {0xE5C4, 0x8827}, //6054 #CJK UNIFIED IDEOGRAPH
    {0xE5C5, 0x883B}, //6055 #CJK UNIFIED IDEOGRAPH
    {0xE5C6, 0x8844}, //6056 #CJK UNIFIED IDEOGRAPH
    {0xE5C7, 0x8842}, //6057 #CJK UNIFIED IDEOGRAPH
    {0xE5C8, 0x8852}, //6058 #CJK UNIFIED IDEOGRAPH
    {0xE5C9, 0x8859}, //6059 #CJK UNIFIED IDEOGRAPH
    {0xE5CA, 0x885E}, //6060 #CJK UNIFIED IDEOGRAPH
    {0xE5CB, 0x8862}, //6061 #CJK UNIFIED IDEOGRAPH
    {0xE5CC, 0x886B}, //6062 #CJK UNIFIED IDEOGRAPH
    {0xE5CD, 0x8881}, //6063 #CJK UNIFIED IDEOGRAPH
    {0xE5CE, 0x887E}, //6064 #CJK UNIFIED IDEOGRAPH
    {0xE5CF, 0x889E}, //6065 #CJK UNIFIED IDEOGRAPH
    {0xE5D0, 0x8875}, //6066 #CJK UNIFIED IDEOGRAPH
    {0xE5D1, 0x887D}, //6067 #CJK UNIFIED IDEOGRAPH
    {0xE5D2, 0x88B5}, //6068 #CJK UNIFIED IDEOGRAPH
    {0xE5D3, 0x8872}, //6069 #CJK UNIFIED IDEOGRAPH
    {0xE5D4, 0x8882}, //6070 #CJK UNIFIED IDEOGRAPH
    {0xE5D5, 0x8897}, //6071 #CJK UNIFIED IDEOGRAPH
    {0xE5D6, 0x8892}, //6072 #CJK UNIFIED IDEOGRAPH
    {0xE5D7, 0x88AE}, //6073 #CJK UNIFIED IDEOGRAPH
    {0xE5D8, 0x8899}, //6074 #CJK UNIFIED IDEOGRAPH
    {0xE5D9, 0x88A2}, //6075 #CJK UNIFIED IDEOGRAPH
    {0xE5DA, 0x888D}, //6076 #CJK UNIFIED IDEOGRAPH
    {0xE5DB, 0x88A4}, //6077 #CJK UNIFIED IDEOGRAPH
    {0xE5DC, 0x88B0}, //6078 #CJK UNIFIED IDEOGRAPH
    {0xE5DD, 0x88BF}, //6079 #CJK UNIFIED IDEOGRAPH
    {0xE5DE, 0x88B1}, //6080 #CJK UNIFIED IDEOGRAPH
    {0xE5DF, 0x88C3}, //6081 #CJK UNIFIED IDEOGRAPH
    {0xE5E0, 0x88C4}, //6082 #CJK UNIFIED IDEOGRAPH
    {0xE5E1, 0x88D4}, //6083 #CJK UNIFIED IDEOGRAPH
    {0xE5E2, 0x88D8}, //6084 #CJK UNIFIED IDEOGRAPH
    {0xE5E3, 0x88D9}, //6085 #CJK UNIFIED IDEOGRAPH
    {0xE5E4, 0x88DD}, //6086 #CJK UNIFIED IDEOGRAPH
    {0xE5E5, 0x88F9}, //6087 #CJK UNIFIED IDEOGRAPH
    {0xE5E6, 0x8902}, //6088 #CJK UNIFIED IDEOGRAPH
    {0xE5E7, 0x88FC}, //6089 #CJK UNIFIED IDEOGRAPH
    {0xE5E8, 0x88F4}, //6090 #CJK UNIFIED IDEOGRAPH
    {0xE5E9, 0x88E8}, //6091 #CJK UNIFIED IDEOGRAPH
    {0xE5EA, 0x88F2}, //6092 #CJK UNIFIED IDEOGRAPH
    {0xE5EB, 0x8904}, //6093 #CJK UNIFIED IDEOGRAPH
    {0xE5EC, 0x890C}, //6094 #CJK UNIFIED IDEOGRAPH
    {0xE5ED, 0x890A}, //6095 #CJK UNIFIED IDEOGRAPH
    {0xE5EE, 0x8913}, //6096 #CJK UNIFIED IDEOGRAPH
    {0xE5EF, 0x8943}, //6097 #CJK UNIFIED IDEOGRAPH
    {0xE5F0, 0x891E}, //6098 #CJK UNIFIED IDEOGRAPH
    {0xE5F1, 0x8925}, //6099 #CJK UNIFIED IDEOGRAPH
    {0xE5F2, 0x892A}, //6100 #CJK UNIFIED IDEOGRAPH
    {0xE5F3, 0x892B}, //6101 #CJK UNIFIED IDEOGRAPH
    {0xE5F4, 0x8941}, //6102 #CJK UNIFIED IDEOGRAPH
    {0xE5F5, 0x8944}, //6103 #CJK UNIFIED IDEOGRAPH
    {0xE5F6, 0x893B}, //6104 #CJK UNIFIED IDEOGRAPH
    {0xE5F7, 0x8936}, //6105 #CJK UNIFIED IDEOGRAPH
    {0xE5F8, 0x8938}, //6106 #CJK UNIFIED IDEOGRAPH
    {0xE5F9, 0x894C}, //6107 #CJK UNIFIED IDEOGRAPH
    {0xE5FA, 0x891D}, //6108 #CJK UNIFIED IDEOGRAPH
    {0xE5FB, 0x8960}, //6109 #CJK UNIFIED IDEOGRAPH
    {0xE5FC, 0x895E}, //6110 #CJK UNIFIED IDEOGRAPH
    {0xE640, 0x8966}, //6111 #CJK UNIFIED IDEOGRAPH
    {0xE641, 0x8964}, //6112 #CJK UNIFIED IDEOGRAPH
    {0xE642, 0x896D}, //6113 #CJK UNIFIED IDEOGRAPH
    {0xE643, 0x896A}, //6114 #CJK UNIFIED IDEOGRAPH
    {0xE644, 0x896F}, //6115 #CJK UNIFIED IDEOGRAPH
    {0xE645, 0x8974}, //6116 #CJK UNIFIED IDEOGRAPH
    {0xE646, 0x8977}, //6117 #CJK UNIFIED IDEOGRAPH
    {0xE647, 0x897E}, //6118 #CJK UNIFIED IDEOGRAPH
    {0xE648, 0x8983}, //6119 #CJK UNIFIED IDEOGRAPH
    {0xE649, 0x8988}, //6120 #CJK UNIFIED IDEOGRAPH
    {0xE64A, 0x898A}, //6121 #CJK UNIFIED IDEOGRAPH
    {0xE64B, 0x8993}, //6122 #CJK UNIFIED IDEOGRAPH
    {0xE64C, 0x8998}, //6123 #CJK UNIFIED IDEOGRAPH
    {0xE64D, 0x89A1}, //6124 #CJK UNIFIED IDEOGRAPH
    {0xE64E, 0x89A9}, //6125 #CJK UNIFIED IDEOGRAPH
    {0xE64F, 0x89A6}, //6126 #CJK UNIFIED IDEOGRAPH
    {0xE650, 0x89AC}, //6127 #CJK UNIFIED IDEOGRAPH
    {0xE651, 0x89AF}, //6128 #CJK UNIFIED IDEOGRAPH
    {0xE652, 0x89B2}, //6129 #CJK UNIFIED IDEOGRAPH
    {0xE653, 0x89BA}, //6130 #CJK UNIFIED IDEOGRAPH
    {0xE654, 0x89BD}, //6131 #CJK UNIFIED IDEOGRAPH
    {0xE655, 0x89BF}, //6132 #CJK UNIFIED IDEOGRAPH
    {0xE656, 0x89C0}, //6133 #CJK UNIFIED IDEOGRAPH
    {0xE657, 0x89DA}, //6134 #CJK UNIFIED IDEOGRAPH
    {0xE658, 0x89DC}, //6135 #CJK UNIFIED IDEOGRAPH
    {0xE659, 0x89DD}, //6136 #CJK UNIFIED IDEOGRAPH
    {0xE65A, 0x89E7}, //6137 #CJK UNIFIED IDEOGRAPH
    {0xE65B, 0x89F4}, //6138 #CJK UNIFIED IDEOGRAPH
    {0xE65C, 0x89F8}, //6139 #CJK UNIFIED IDEOGRAPH
    {0xE65D, 0x8A03}, //6140 #CJK UNIFIED IDEOGRAPH
    {0xE65E, 0x8A16}, //6141 #CJK UNIFIED IDEOGRAPH
    {0xE65F, 0x8A10}, //6142 #CJK UNIFIED IDEOGRAPH
    {0xE660, 0x8A0C}, //6143 #CJK UNIFIED IDEOGRAPH
    {0xE661, 0x8A1B}, //6144 #CJK UNIFIED IDEOGRAPH
    {0xE662, 0x8A1D}, //6145 #CJK UNIFIED IDEOGRAPH
    {0xE663, 0x8A25}, //6146 #CJK UNIFIED IDEOGRAPH
    {0xE664, 0x8A36}, //6147 #CJK UNIFIED IDEOGRAPH
    {0xE665, 0x8A41}, //6148 #CJK UNIFIED IDEOGRAPH
    {0xE666, 0x8A5B}, //6149 #CJK UNIFIED IDEOGRAPH
    {0xE667, 0x8A52}, //6150 #CJK UNIFIED IDEOGRAPH
    {0xE668, 0x8A46}, //6151 #CJK UNIFIED IDEOGRAPH
    {0xE669, 0x8A48}, //6152 #CJK UNIFIED IDEOGRAPH
    {0xE66A, 0x8A7C}, //6153 #CJK UNIFIED IDEOGRAPH
    {0xE66B, 0x8A6D}, //6154 #CJK UNIFIED IDEOGRAPH
    {0xE66C, 0x8A6C}, //6155 #CJK UNIFIED IDEOGRAPH
    {0xE66D, 0x8A62}, //6156 #CJK UNIFIED IDEOGRAPH
    {0xE66E, 0x8A85}, //6157 #CJK UNIFIED IDEOGRAPH
    {0xE66F, 0x8A82}, //6158 #CJK UNIFIED IDEOGRAPH
    {0xE670, 0x8A84}, //6159 #CJK UNIFIED IDEOGRAPH
    {0xE671, 0x8AA8}, //6160 #CJK UNIFIED IDEOGRAPH
    {0xE672, 0x8AA1}, //6161 #CJK UNIFIED IDEOGRAPH
    {0xE673, 0x8A91}, //6162 #CJK UNIFIED IDEOGRAPH
    {0xE674, 0x8AA5}, //6163 #CJK UNIFIED IDEOGRAPH
    {0xE675, 0x8AA6}, //6164 #CJK UNIFIED IDEOGRAPH
    {0xE676, 0x8A9A}, //6165 #CJK UNIFIED IDEOGRAPH
    {0xE677, 0x8AA3}, //6166 #CJK UNIFIED IDEOGRAPH
    {0xE678, 0x8AC4}, //6167 #CJK UNIFIED IDEOGRAPH
    {0xE679, 0x8ACD}, //6168 #CJK UNIFIED IDEOGRAPH
    {0xE67A, 0x8AC2}, //6169 #CJK UNIFIED IDEOGRAPH
    {0xE67B, 0x8ADA}, //6170 #CJK UNIFIED IDEOGRAPH
    {0xE67C, 0x8AEB}, //6171 #CJK UNIFIED IDEOGRAPH
    {0xE67D, 0x8AF3}, //6172 #CJK UNIFIED IDEOGRAPH
    {0xE67E, 0x8AE7}, //6173 #CJK UNIFIED IDEOGRAPH
    {0xE680, 0x8AE4}, //6174 #CJK UNIFIED IDEOGRAPH
    {0xE681, 0x8AF1}, //6175 #CJK UNIFIED IDEOGRAPH
    {0xE682, 0x8B14}, //6176 #CJK UNIFIED IDEOGRAPH
    {0xE683, 0x8AE0}, //6177 #CJK UNIFIED IDEOGRAPH
    {0xE684, 0x8AE2}, //6178 #CJK UNIFIED IDEOGRAPH
    {0xE685, 0x8AF7}, //6179 #CJK UNIFIED IDEOGRAPH
    {0xE686, 0x8ADE}, //6180 #CJK UNIFIED IDEOGRAPH
    {0xE687, 0x8ADB}, //6181 #CJK UNIFIED IDEOGRAPH
    {0xE688, 0x8B0C}, //6182 #CJK UNIFIED IDEOGRAPH
    {0xE689, 0x8B07}, //6183 #CJK UNIFIED IDEOGRAPH
    {0xE68A, 0x8B1A}, //6184 #CJK UNIFIED IDEOGRAPH
    {0xE68B, 0x8AE1}, //6185 #CJK UNIFIED IDEOGRAPH
    {0xE68C, 0x8B16}, //6186 #CJK UNIFIED IDEOGRAPH
    {0xE68D, 0x8B10}, //6187 #CJK UNIFIED IDEOGRAPH
    {0xE68E, 0x8B17}, //6188 #CJK UNIFIED IDEOGRAPH
    {0xE68F, 0x8B20}, //6189 #CJK UNIFIED IDEOGRAPH
    {0xE690, 0x8B33}, //6190 #CJK UNIFIED IDEOGRAPH
    {0xE691, 0x97AB}, //6191 #CJK UNIFIED IDEOGRAPH
    {0xE692, 0x8B26}, //6192 #CJK UNIFIED IDEOGRAPH
    {0xE693, 0x8B2B}, //6193 #CJK UNIFIED IDEOGRAPH
    {0xE694, 0x8B3E}, //6194 #CJK UNIFIED IDEOGRAPH
    {0xE695, 0x8B28}, //6195 #CJK UNIFIED IDEOGRAPH
    {0xE696, 0x8B41}, //6196 #CJK UNIFIED IDEOGRAPH
    {0xE697, 0x8B4C}, //6197 #CJK UNIFIED IDEOGRAPH
    {0xE698, 0x8B4F}, //6198 #CJK UNIFIED IDEOGRAPH
    {0xE699, 0x8B4E}, //6199 #CJK UNIFIED IDEOGRAPH
    {0xE69A, 0x8B49}, //6200 #CJK UNIFIED IDEOGRAPH
    {0xE69B, 0x8B56}, //6201 #CJK UNIFIED IDEOGRAPH
    {0xE69C, 0x8B5B}, //6202 #CJK UNIFIED IDEOGRAPH
    {0xE69D, 0x8B5A}, //6203 #CJK UNIFIED IDEOGRAPH
    {0xE69E, 0x8B6B}, //6204 #CJK UNIFIED IDEOGRAPH
    {0xE69F, 0x8B5F}, //6205 #CJK UNIFIED IDEOGRAPH
    {0xE6A0, 0x8B6C}, //6206 #CJK UNIFIED IDEOGRAPH
    {0xE6A1, 0x8B6F}, //6207 #CJK UNIFIED IDEOGRAPH
    {0xE6A2, 0x8B74}, //6208 #CJK UNIFIED IDEOGRAPH
    {0xE6A3, 0x8B7D}, //6209 #CJK UNIFIED IDEOGRAPH
    {0xE6A4, 0x8B80}, //6210 #CJK UNIFIED IDEOGRAPH
    {0xE6A5, 0x8B8C}, //6211 #CJK UNIFIED IDEOGRAPH
    {0xE6A6, 0x8B8E}, //6212 #CJK UNIFIED IDEOGRAPH
    {0xE6A7, 0x8B92}, //6213 #CJK UNIFIED IDEOGRAPH
    {0xE6A8, 0x8B93}, //6214 #CJK UNIFIED IDEOGRAPH
    {0xE6A9, 0x8B96}, //6215 #CJK UNIFIED IDEOGRAPH
    {0xE6AA, 0x8B99}, //6216 #CJK UNIFIED IDEOGRAPH
    {0xE6AB, 0x8B9A}, //6217 #CJK UNIFIED IDEOGRAPH
    {0xE6AC, 0x8C3A}, //6218 #CJK UNIFIED IDEOGRAPH
    {0xE6AD, 0x8C41}, //6219 #CJK UNIFIED IDEOGRAPH
    {0xE6AE, 0x8C3F}, //6220 #CJK UNIFIED IDEOGRAPH
    {0xE6AF, 0x8C48}, //6221 #CJK UNIFIED IDEOGRAPH
    {0xE6B0, 0x8C4C}, //6222 #CJK UNIFIED IDEOGRAPH
    {0xE6B1, 0x8C4E}, //6223 #CJK UNIFIED IDEOGRAPH
    {0xE6B2, 0x8C50}, //6224 #CJK UNIFIED IDEOGRAPH
    {0xE6B3, 0x8C55}, //6225 #CJK UNIFIED IDEOGRAPH
    {0xE6B4, 0x8C62}, //6226 #CJK UNIFIED IDEOGRAPH
    {0xE6B5, 0x8C6C}, //6227 #CJK UNIFIED IDEOGRAPH
    {0xE6B6, 0x8C78}, //6228 #CJK UNIFIED IDEOGRAPH
    {0xE6B7, 0x8C7A}, //6229 #CJK UNIFIED IDEOGRAPH
    {0xE6B8, 0x8C82}, //6230 #CJK UNIFIED IDEOGRAPH
    {0xE6B9, 0x8C89}, //6231 #CJK UNIFIED IDEOGRAPH
    {0xE6BA, 0x8C85}, //6232 #CJK UNIFIED IDEOGRAPH
    {0xE6BB, 0x8C8A}, //6233 #CJK UNIFIED IDEOGRAPH
    {0xE6BC, 0x8C8D}, //6234 #CJK UNIFIED IDEOGRAPH
    {0xE6BD, 0x8C8E}, //6235 #CJK UNIFIED IDEOGRAPH
    {0xE6BE, 0x8C94}, //6236 #CJK UNIFIED IDEOGRAPH
    {0xE6BF, 0x8C7C}, //6237 #CJK UNIFIED IDEOGRAPH
    {0xE6C0, 0x8C98}, //6238 #CJK UNIFIED IDEOGRAPH
    {0xE6C1, 0x621D}, //6239 #CJK UNIFIED IDEOGRAPH
    {0xE6C2, 0x8CAD}, //6240 #CJK UNIFIED IDEOGRAPH
    {0xE6C3, 0x8CAA}, //6241 #CJK UNIFIED IDEOGRAPH
    {0xE6C4, 0x8CBD}, //6242 #CJK UNIFIED IDEOGRAPH
    {0xE6C5, 0x8CB2}, //6243 #CJK UNIFIED IDEOGRAPH
    {0xE6C6, 0x8CB3}, //6244 #CJK UNIFIED IDEOGRAPH
    {0xE6C7, 0x8CAE}, //6245 #CJK UNIFIED IDEOGRAPH
    {0xE6C8, 0x8CB6}, //6246 #CJK UNIFIED IDEOGRAPH
    {0xE6C9, 0x8CC8}, //6247 #CJK UNIFIED IDEOGRAPH
    {0xE6CA, 0x8CC1}, //6248 #CJK UNIFIED IDEOGRAPH
    {0xE6CB, 0x8CE4}, //6249 #CJK UNIFIED IDEOGRAPH
    {0xE6CC, 0x8CE3}, //6250 #CJK UNIFIED IDEOGRAPH
    {0xE6CD, 0x8CDA}, //6251 #CJK UNIFIED IDEOGRAPH
    {0xE6CE, 0x8CFD}, //6252 #CJK UNIFIED IDEOGRAPH
    {0xE6CF, 0x8CFA}, //6253 #CJK UNIFIED IDEOGRAPH
    {0xE6D0, 0x8CFB}, //6254 #CJK UNIFIED IDEOGRAPH
    {0xE6D1, 0x8D04}, //6255 #CJK UNIFIED IDEOGRAPH
    {0xE6D2, 0x8D05}, //6256 #CJK UNIFIED IDEOGRAPH
    {0xE6D3, 0x8D0A}, //6257 #CJK UNIFIED IDEOGRAPH
    {0xE6D4, 0x8D07}, //6258 #CJK UNIFIED IDEOGRAPH
    {0xE6D5, 0x8D0F}, //6259 #CJK UNIFIED IDEOGRAPH
    {0xE6D6, 0x8D0D}, //6260 #CJK UNIFIED IDEOGRAPH
    {0xE6D7, 0x8D10}, //6261 #CJK UNIFIED IDEOGRAPH
    {0xE6D8, 0x9F4E}, //6262 #CJK UNIFIED IDEOGRAPH
    {0xE6D9, 0x8D13}, //6263 #CJK UNIFIED IDEOGRAPH
    {0xE6DA, 0x8CCD}, //6264 #CJK UNIFIED IDEOGRAPH
    {0xE6DB, 0x8D14}, //6265 #CJK UNIFIED IDEOGRAPH
    {0xE6DC, 0x8D16}, //6266 #CJK UNIFIED IDEOGRAPH
    {0xE6DD, 0x8D67}, //6267 #CJK UNIFIED IDEOGRAPH
    {0xE6DE, 0x8D6D}, //6268 #CJK UNIFIED IDEOGRAPH
    {0xE6DF, 0x8D71}, //6269 #CJK UNIFIED IDEOGRAPH
    {0xE6E0, 0x8D73}, //6270 #CJK UNIFIED IDEOGRAPH
    {0xE6E1, 0x8D81}, //6271 #CJK UNIFIED IDEOGRAPH
    {0xE6E2, 0x8D99}, //6272 #CJK UNIFIED IDEOGRAPH
    {0xE6E3, 0x8DC2}, //6273 #CJK UNIFIED IDEOGRAPH
    {0xE6E4, 0x8DBE}, //6274 #CJK UNIFIED IDEOGRAPH
    {0xE6E5, 0x8DBA}, //6275 #CJK UNIFIED IDEOGRAPH
    {0xE6E6, 0x8DCF}, //6276 #CJK UNIFIED IDEOGRAPH
    {0xE6E7, 0x8DDA}, //6277 #CJK UNIFIED IDEOGRAPH
    {0xE6E8, 0x8DD6}, //6278 #CJK UNIFIED IDEOGRAPH
    {0xE6E9, 0x8DCC}, //6279 #CJK UNIFIED IDEOGRAPH
    {0xE6EA, 0x8DDB}, //6280 #CJK UNIFIED IDEOGRAPH
    {0xE6EB, 0x8DCB}, //6281 #CJK UNIFIED IDEOGRAPH
    {0xE6EC, 0x8DEA}, //6282 #CJK UNIFIED IDEOGRAPH
    {0xE6ED, 0x8DEB}, //6283 #CJK UNIFIED IDEOGRAPH
    {0xE6EE, 0x8DDF}, //6284 #CJK UNIFIED IDEOGRAPH
    {0xE6EF, 0x8DE3}, //6285 #CJK UNIFIED IDEOGRAPH
    {0xE6F0, 0x8DFC}, //6286 #CJK UNIFIED IDEOGRAPH
    {0xE6F1, 0x8E08}, //6287 #CJK UNIFIED IDEOGRAPH
    {0xE6F2, 0x8E09}, //6288 #CJK UNIFIED IDEOGRAPH
    {0xE6F3, 0x8DFF}, //6289 #CJK UNIFIED IDEOGRAPH
    {0xE6F4, 0x8E1D}, //6290 #CJK UNIFIED IDEOGRAPH
    {0xE6F5, 0x8E1E}, //6291 #CJK UNIFIED IDEOGRAPH
    {0xE6F6, 0x8E10}, //6292 #CJK UNIFIED IDEOGRAPH
    {0xE6F7, 0x8E1F}, //6293 #CJK UNIFIED IDEOGRAPH
    {0xE6F8, 0x8E42}, //6294 #CJK UNIFIED IDEOGRAPH
    {0xE6F9, 0x8E35}, //6295 #CJK UNIFIED IDEOGRAPH
    {0xE6FA, 0x8E30}, //6296 #CJK UNIFIED IDEOGRAPH
    {0xE6FB, 0x8E34}, //6297 #CJK UNIFIED IDEOGRAPH
    {0xE6FC, 0x8E4A}, //6298 #CJK UNIFIED IDEOGRAPH
    {0xE740, 0x8E47}, //6299 #CJK UNIFIED IDEOGRAPH
    {0xE741, 0x8E49}, //6300 #CJK UNIFIED IDEOGRAPH
    {0xE742, 0x8E4C}, //6301 #CJK UNIFIED IDEOGRAPH
    {0xE743, 0x8E50}, //6302 #CJK UNIFIED IDEOGRAPH
    {0xE744, 0x8E48}, //6303 #CJK UNIFIED IDEOGRAPH
    {0xE745, 0x8E59}, //6304 #CJK UNIFIED IDEOGRAPH
    {0xE746, 0x8E64}, //6305 #CJK UNIFIED IDEOGRAPH
    {0xE747, 0x8E60}, //6306 #CJK UNIFIED IDEOGRAPH
    {0xE748, 0x8E2A}, //6307 #CJK UNIFIED IDEOGRAPH
    {0xE749, 0x8E63}, //6308 #CJK UNIFIED IDEOGRAPH
    {0xE74A, 0x8E55}, //6309 #CJK UNIFIED IDEOGRAPH
    {0xE74B, 0x8E76}, //6310 #CJK UNIFIED IDEOGRAPH
    {0xE74C, 0x8E72}, //6311 #CJK UNIFIED IDEOGRAPH
    {0xE74D, 0x8E7C}, //6312 #CJK UNIFIED IDEOGRAPH
    {0xE74E, 0x8E81}, //6313 #CJK UNIFIED IDEOGRAPH
    {0xE74F, 0x8E87}, //6314 #CJK UNIFIED IDEOGRAPH
    {0xE750, 0x8E85}, //6315 #CJK UNIFIED IDEOGRAPH
    {0xE751, 0x8E84}, //6316 #CJK UNIFIED IDEOGRAPH
    {0xE752, 0x8E8B}, //6317 #CJK UNIFIED IDEOGRAPH
    {0xE753, 0x8E8A}, //6318 #CJK UNIFIED IDEOGRAPH
    {0xE754, 0x8E93}, //6319 #CJK UNIFIED IDEOGRAPH
    {0xE755, 0x8E91}, //6320 #CJK UNIFIED IDEOGRAPH
    {0xE756, 0x8E94}, //6321 #CJK UNIFIED IDEOGRAPH
    {0xE757, 0x8E99}, //6322 #CJK UNIFIED IDEOGRAPH
    {0xE758, 0x8EAA}, //6323 #CJK UNIFIED IDEOGRAPH
    {0xE759, 0x8EA1}, //6324 #CJK UNIFIED IDEOGRAPH
    {0xE75A, 0x8EAC}, //6325 #CJK UNIFIED IDEOGRAPH
    {0xE75B, 0x8EB0}, //6326 #CJK UNIFIED IDEOGRAPH
    {0xE75C, 0x8EC6}, //6327 #CJK UNIFIED IDEOGRAPH
    {0xE75D, 0x8EB1}, //6328 #CJK UNIFIED IDEOGRAPH
    {0xE75E, 0x8EBE}, //6329 #CJK UNIFIED IDEOGRAPH
    {0xE75F, 0x8EC5}, //6330 #CJK UNIFIED IDEOGRAPH
    {0xE760, 0x8EC8}, //6331 #CJK UNIFIED IDEOGRAPH
    {0xE761, 0x8ECB}, //6332 #CJK UNIFIED IDEOGRAPH
    {0xE762, 0x8EDB}, //6333 #CJK UNIFIED IDEOGRAPH
    {0xE763, 0x8EE3}, //6334 #CJK UNIFIED IDEOGRAPH
    {0xE764, 0x8EFC}, //6335 #CJK UNIFIED IDEOGRAPH
    {0xE765, 0x8EFB}, //6336 #CJK UNIFIED IDEOGRAPH
    {0xE766, 0x8EEB}, //6337 #CJK UNIFIED IDEOGRAPH
    {0xE767, 0x8EFE}, //6338 #CJK UNIFIED IDEOGRAPH
    {0xE768, 0x8F0A}, //6339 #CJK UNIFIED IDEOGRAPH
    {0xE769, 0x8F05}, //6340 #CJK UNIFIED IDEOGRAPH
    {0xE76A, 0x8F15}, //6341 #CJK UNIFIED IDEOGRAPH
    {0xE76B, 0x8F12}, //6342 #CJK UNIFIED IDEOGRAPH
    {0xE76C, 0x8F19}, //6343 #CJK UNIFIED IDEOGRAPH
    {0xE76D, 0x8F13}, //6344 #CJK UNIFIED IDEOGRAPH
    {0xE76E, 0x8F1C}, //6345 #CJK UNIFIED IDEOGRAPH
    {0xE76F, 0x8F1F}, //6346 #CJK UNIFIED IDEOGRAPH
    {0xE770, 0x8F1B}, //6347 #CJK UNIFIED IDEOGRAPH
    {0xE771, 0x8F0C}, //6348 #CJK UNIFIED IDEOGRAPH
    {0xE772, 0x8F26}, //6349 #CJK UNIFIED IDEOGRAPH
    {0xE773, 0x8F33}, //6350 #CJK UNIFIED IDEOGRAPH
    {0xE774, 0x8F3B}, //6351 #CJK UNIFIED IDEOGRAPH
    {0xE775, 0x8F39}, //6352 #CJK UNIFIED IDEOGRAPH
    {0xE776, 0x8F45}, //6353 #CJK UNIFIED IDEOGRAPH
    {0xE777, 0x8F42}, //6354 #CJK UNIFIED IDEOGRAPH
    {0xE778, 0x8F3E}, //6355 #CJK UNIFIED IDEOGRAPH
    {0xE779, 0x8F4C}, //6356 #CJK UNIFIED IDEOGRAPH
    {0xE77A, 0x8F49}, //6357 #CJK UNIFIED IDEOGRAPH
    {0xE77B, 0x8F46}, //6358 #CJK UNIFIED IDEOGRAPH
    {0xE77C, 0x8F4E}, //6359 #CJK UNIFIED IDEOGRAPH
    {0xE77D, 0x8F57}, //6360 #CJK UNIFIED IDEOGRAPH
    {0xE77E, 0x8F5C}, //6361 #CJK UNIFIED IDEOGRAPH
    {0xE780, 0x8F62}, //6362 #CJK UNIFIED IDEOGRAPH
    {0xE781, 0x8F63}, //6363 #CJK UNIFIED IDEOGRAPH
    {0xE782, 0x8F64}, //6364 #CJK UNIFIED IDEOGRAPH
    {0xE783, 0x8F9C}, //6365 #CJK UNIFIED IDEOGRAPH
    {0xE784, 0x8F9F}, //6366 #CJK UNIFIED IDEOGRAPH
    {0xE785, 0x8FA3}, //6367 #CJK UNIFIED IDEOGRAPH
    {0xE786, 0x8FAD}, //6368 #CJK UNIFIED IDEOGRAPH
    {0xE787, 0x8FAF}, //6369 #CJK UNIFIED IDEOGRAPH
    {0xE788, 0x8FB7}, //6370 #CJK UNIFIED IDEOGRAPH
    {0xE789, 0x8FDA}, //6371 #CJK UNIFIED IDEOGRAPH
    {0xE78A, 0x8FE5}, //6372 #CJK UNIFIED IDEOGRAPH
    {0xE78B, 0x8FE2}, //6373 #CJK UNIFIED IDEOGRAPH
    {0xE78C, 0x8FEA}, //6374 #CJK UNIFIED IDEOGRAPH
    {0xE78D, 0x8FEF}, //6375 #CJK UNIFIED IDEOGRAPH
    {0xE78E, 0x9087}, //6376 #CJK UNIFIED IDEOGRAPH
    {0xE78F, 0x8FF4}, //6377 #CJK UNIFIED IDEOGRAPH
    {0xE790, 0x9005}, //6378 #CJK UNIFIED IDEOGRAPH
    {0xE791, 0x8FF9}, //6379 #CJK UNIFIED IDEOGRAPH
    {0xE792, 0x8FFA}, //6380 #CJK UNIFIED IDEOGRAPH
    {0xE793, 0x9011}, //6381 #CJK UNIFIED IDEOGRAPH
    {0xE794, 0x9015}, //6382 #CJK UNIFIED IDEOGRAPH
    {0xE795, 0x9021}, //6383 #CJK UNIFIED IDEOGRAPH
    {0xE796, 0x900D}, //6384 #CJK UNIFIED IDEOGRAPH
    {0xE797, 0x901E}, //6385 #CJK UNIFIED IDEOGRAPH
    {0xE798, 0x9016}, //6386 #CJK UNIFIED IDEOGRAPH
    {0xE799, 0x900B}, //6387 #CJK UNIFIED IDEOGRAPH
    {0xE79A, 0x9027}, //6388 #CJK UNIFIED IDEOGRAPH
    {0xE79B, 0x9036}, //6389 #CJK UNIFIED IDEOGRAPH
    {0xE79C, 0x9035}, //6390 #CJK UNIFIED IDEOGRAPH
    {0xE79D, 0x9039}, //6391 #CJK UNIFIED IDEOGRAPH
    {0xE79E, 0x8FF8}, //6392 #CJK UNIFIED IDEOGRAPH
    {0xE79F, 0x904F}, //6393 #CJK UNIFIED IDEOGRAPH
    {0xE7A0, 0x9050}, //6394 #CJK UNIFIED IDEOGRAPH
    {0xE7A1, 0x9051}, //6395 #CJK UNIFIED IDEOGRAPH
    {0xE7A2, 0x9052}, //6396 #CJK UNIFIED IDEOGRAPH
    {0xE7A3, 0x900E}, //6397 #CJK UNIFIED IDEOGRAPH
    {0xE7A4, 0x9049}, //6398 #CJK UNIFIED IDEOGRAPH
    {0xE7A5, 0x903E}, //6399 #CJK UNIFIED IDEOGRAPH
    {0xE7A6, 0x9056}, //6400 #CJK UNIFIED IDEOGRAPH
    {0xE7A7, 0x9058}, //6401 #CJK UNIFIED IDEOGRAPH
    {0xE7A8, 0x905E}, //6402 #CJK UNIFIED IDEOGRAPH
    {0xE7A9, 0x9068}, //6403 #CJK UNIFIED IDEOGRAPH
    {0xE7AA, 0x906F}, //6404 #CJK UNIFIED IDEOGRAPH
    {0xE7AB, 0x9076}, //6405 #CJK UNIFIED IDEOGRAPH
    {0xE7AC, 0x96A8}, //6406 #CJK UNIFIED IDEOGRAPH
    {0xE7AD, 0x9072}, //6407 #CJK UNIFIED IDEOGRAPH
    {0xE7AE, 0x9082}, //6408 #CJK UNIFIED IDEOGRAPH
    {0xE7AF, 0x907D}, //6409 #CJK UNIFIED IDEOGRAPH
    {0xE7B0, 0x9081}, //6410 #CJK UNIFIED IDEOGRAPH
    {0xE7B1, 0x9080}, //6411 #CJK UNIFIED IDEOGRAPH
    {0xE7B2, 0x908A}, //6412 #CJK UNIFIED IDEOGRAPH
    {0xE7B3, 0x9089}, //6413 #CJK UNIFIED IDEOGRAPH
    {0xE7B4, 0x908F}, //6414 #CJK UNIFIED IDEOGRAPH
    {0xE7B5, 0x90A8}, //6415 #CJK UNIFIED IDEOGRAPH
    {0xE7B6, 0x90AF}, //6416 #CJK UNIFIED IDEOGRAPH
    {0xE7B7, 0x90B1}, //6417 #CJK UNIFIED IDEOGRAPH
    {0xE7B8, 0x90B5}, //6418 #CJK UNIFIED IDEOGRAPH
    {0xE7B9, 0x90E2}, //6419 #CJK UNIFIED IDEOGRAPH
    {0xE7BA, 0x90E4}, //6420 #CJK UNIFIED IDEOGRAPH
    {0xE7BB, 0x6248}, //6421 #CJK UNIFIED IDEOGRAPH
    {0xE7BC, 0x90DB}, //6422 #CJK UNIFIED IDEOGRAPH
    {0xE7BD, 0x9102}, //6423 #CJK UNIFIED IDEOGRAPH
    {0xE7BE, 0x9112}, //6424 #CJK UNIFIED IDEOGRAPH
    {0xE7BF, 0x9119}, //6425 #CJK UNIFIED IDEOGRAPH
    {0xE7C0, 0x9132}, //6426 #CJK UNIFIED IDEOGRAPH
    {0xE7C1, 0x9130}, //6427 #CJK UNIFIED IDEOGRAPH
    {0xE7C2, 0x914A}, //6428 #CJK UNIFIED IDEOGRAPH
    {0xE7C3, 0x9156}, //6429 #CJK UNIFIED IDEOGRAPH
    {0xE7C4, 0x9158}, //6430 #CJK UNIFIED IDEOGRAPH
    {0xE7C5, 0x9163}, //6431 #CJK UNIFIED IDEOGRAPH
    {0xE7C6, 0x9165}, //6432 #CJK UNIFIED IDEOGRAPH
    {0xE7C7, 0x9169}, //6433 #CJK UNIFIED IDEOGRAPH
    {0xE7C8, 0x9173}, //6434 #CJK UNIFIED IDEOGRAPH
    {0xE7C9, 0x9172}, //6435 #CJK UNIFIED IDEOGRAPH
    {0xE7CA, 0x918B}, //6436 #CJK UNIFIED IDEOGRAPH
    {0xE7CB, 0x9189}, //6437 #CJK UNIFIED IDEOGRAPH
    {0xE7CC, 0x9182}, //6438 #CJK UNIFIED IDEOGRAPH
    {0xE7CD, 0x91A2}, //6439 #CJK UNIFIED IDEOGRAPH
    {0xE7CE, 0x91AB}, //6440 #CJK UNIFIED IDEOGRAPH
    {0xE7CF, 0x91AF}, //6441 #CJK UNIFIED IDEOGRAPH
    {0xE7D0, 0x91AA}, //6442 #CJK UNIFIED IDEOGRAPH
    {0xE7D1, 0x91B5}, //6443 #CJK UNIFIED IDEOGRAPH
    {0xE7D2, 0x91B4}, //6444 #CJK UNIFIED IDEOGRAPH
    {0xE7D3, 0x91BA}, //6445 #CJK UNIFIED IDEOGRAPH
    {0xE7D4, 0x91C0}, //6446 #CJK UNIFIED IDEOGRAPH
    {0xE7D5, 0x91C1}, //6447 #CJK UNIFIED IDEOGRAPH
    {0xE7D6, 0x91C9}, //6448 #CJK UNIFIED IDEOGRAPH
    {0xE7D7, 0x91CB}, //6449 #CJK UNIFIED IDEOGRAPH
    {0xE7D8, 0x91D0}, //6450 #CJK UNIFIED IDEOGRAPH
    {0xE7D9, 0x91D6}, //6451 #CJK UNIFIED IDEOGRAPH
    {0xE7DA, 0x91DF}, //6452 #CJK UNIFIED IDEOGRAPH
    {0xE7DB, 0x91E1}, //6453 #CJK UNIFIED IDEOGRAPH
    {0xE7DC, 0x91DB}, //6454 #CJK UNIFIED IDEOGRAPH
    {0xE7DD, 0x91FC}, //6455 #CJK UNIFIED IDEOGRAPH
    {0xE7DE, 0x91F5}, //6456 #CJK UNIFIED IDEOGRAPH
    {0xE7DF, 0x91F6}, //6457 #CJK UNIFIED IDEOGRAPH
    {0xE7E0, 0x921E}, //6458 #CJK UNIFIED IDEOGRAPH
    {0xE7E1, 0x91FF}, //6459 #CJK UNIFIED IDEOGRAPH
    {0xE7E2, 0x9214}, //6460 #CJK UNIFIED IDEOGRAPH
    {0xE7E3, 0x922C}, //6461 #CJK UNIFIED IDEOGRAPH
    {0xE7E4, 0x9215}, //6462 #CJK UNIFIED IDEOGRAPH
    {0xE7E5, 0x9211}, //6463 #CJK UNIFIED IDEOGRAPH
    {0xE7E6, 0x925E}, //6464 #CJK UNIFIED IDEOGRAPH
    {0xE7E7, 0x9257}, //6465 #CJK UNIFIED IDEOGRAPH
    {0xE7E8, 0x9245}, //6466 #CJK UNIFIED IDEOGRAPH
    {0xE7E9, 0x9249}, //6467 #CJK UNIFIED IDEOGRAPH
    {0xE7EA, 0x9264}, //6468 #CJK UNIFIED IDEOGRAPH
    {0xE7EB, 0x9248}, //6469 #CJK UNIFIED IDEOGRAPH
    {0xE7EC, 0x9295}, //6470 #CJK UNIFIED IDEOGRAPH
    {0xE7ED, 0x923F}, //6471 #CJK UNIFIED IDEOGRAPH
    {0xE7EE, 0x924B}, //6472 #CJK UNIFIED IDEOGRAPH
    {0xE7EF, 0x9250}, //6473 #CJK UNIFIED IDEOGRAPH
    {0xE7F0, 0x929C}, //6474 #CJK UNIFIED IDEOGRAPH
    {0xE7F1, 0x9296}, //6475 #CJK UNIFIED IDEOGRAPH
    {0xE7F2, 0x9293}, //6476 #CJK UNIFIED IDEOGRAPH
    {0xE7F3, 0x929B}, //6477 #CJK UNIFIED IDEOGRAPH
    {0xE7F4, 0x925A}, //6478 #CJK UNIFIED IDEOGRAPH
    {0xE7F5, 0x92CF}, //6479 #CJK UNIFIED IDEOGRAPH
    {0xE7F6, 0x92B9}, //6480 #CJK UNIFIED IDEOGRAPH
    {0xE7F7, 0x92B7}, //6481 #CJK UNIFIED IDEOGRAPH
    {0xE7F8, 0x92E9}, //6482 #CJK UNIFIED IDEOGRAPH
    {0xE7F9, 0x930F}, //6483 #CJK UNIFIED IDEOGRAPH
    {0xE7FA, 0x92FA}, //6484 #CJK UNIFIED IDEOGRAPH
    {0xE7FB, 0x9344}, //6485 #CJK UNIFIED IDEOGRAPH
    {0xE7FC, 0x932E}, //6486 #CJK UNIFIED IDEOGRAPH
    {0xE840, 0x9319}, //6487 #CJK UNIFIED IDEOGRAPH
    {0xE841, 0x9322}, //6488 #CJK UNIFIED IDEOGRAPH
    {0xE842, 0x931A}, //6489 #CJK UNIFIED IDEOGRAPH
    {0xE843, 0x9323}, //6490 #CJK UNIFIED IDEOGRAPH
    {0xE844, 0x933A}, //6491 #CJK UNIFIED IDEOGRAPH
    {0xE845, 0x9335}, //6492 #CJK UNIFIED IDEOGRAPH
    {0xE846, 0x933B}, //6493 #CJK UNIFIED IDEOGRAPH
    {0xE847, 0x935C}, //6494 #CJK UNIFIED IDEOGRAPH
    {0xE848, 0x9360}, //6495 #CJK UNIFIED IDEOGRAPH
    {0xE849, 0x937C}, //6496 #CJK UNIFIED IDEOGRAPH
    {0xE84A, 0x936E}, //6497 #CJK UNIFIED IDEOGRAPH
    {0xE84B, 0x9356}, //6498 #CJK UNIFIED IDEOGRAPH
    {0xE84C, 0x93B0}, //6499 #CJK UNIFIED IDEOGRAPH
    {0xE84D, 0x93AC}, //6500 #CJK UNIFIED IDEOGRAPH
    {0xE84E, 0x93AD}, //6501 #CJK UNIFIED IDEOGRAPH
    {0xE84F, 0x9394}, //6502 #CJK UNIFIED IDEOGRAPH
    {0xE850, 0x93B9}, //6503 #CJK UNIFIED IDEOGRAPH
    {0xE851, 0x93D6}, //6504 #CJK UNIFIED IDEOGRAPH
    {0xE852, 0x93D7}, //6505 #CJK UNIFIED IDEOGRAPH
    {0xE853, 0x93E8}, //6506 #CJK UNIFIED IDEOGRAPH
    {0xE854, 0x93E5}, //6507 #CJK UNIFIED IDEOGRAPH
    {0xE855, 0x93D8}, //6508 #CJK UNIFIED IDEOGRAPH
    {0xE856, 0x93C3}, //6509 #CJK UNIFIED IDEOGRAPH
    {0xE857, 0x93DD}, //6510 #CJK UNIFIED IDEOGRAPH
    {0xE858, 0x93D0}, //6511 #CJK UNIFIED IDEOGRAPH
    {0xE859, 0x93C8}, //6512 #CJK UNIFIED IDEOGRAPH
    {0xE85A, 0x93E4}, //6513 #CJK UNIFIED IDEOGRAPH
    {0xE85B, 0x941A}, //6514 #CJK UNIFIED IDEOGRAPH
    {0xE85C, 0x9414}, //6515 #CJK UNIFIED IDEOGRAPH
    {0xE85D, 0x9413}, //6516 #CJK UNIFIED IDEOGRAPH
    {0xE85E, 0x9403}, //6517 #CJK UNIFIED IDEOGRAPH
    {0xE85F, 0x9407}, //6518 #CJK UNIFIED IDEOGRAPH
    {0xE860, 0x9410}, //6519 #CJK UNIFIED IDEOGRAPH
    {0xE861, 0x9436}, //6520 #CJK UNIFIED IDEOGRAPH
    {0xE862, 0x942B}, //6521 #CJK UNIFIED IDEOGRAPH
    {0xE863, 0x9435}, //6522 #CJK UNIFIED IDEOGRAPH
    {0xE864, 0x9421}, //6523 #CJK UNIFIED IDEOGRAPH
    {0xE865, 0x943A}, //6524 #CJK UNIFIED IDEOGRAPH
    {0xE866, 0x9441}, //6525 #CJK UNIFIED IDEOGRAPH
    {0xE867, 0x9452}, //6526 #CJK UNIFIED IDEOGRAPH
    {0xE868, 0x9444}, //6527 #CJK UNIFIED IDEOGRAPH
    {0xE869, 0x945B}, //6528 #CJK UNIFIED IDEOGRAPH
    {0xE86A, 0x9460}, //6529 #CJK UNIFIED IDEOGRAPH
    {0xE86B, 0x9462}, //6530 #CJK UNIFIED IDEOGRAPH
    {0xE86C, 0x945E}, //6531 #CJK UNIFIED IDEOGRAPH
    {0xE86D, 0x946A}, //6532 #CJK UNIFIED IDEOGRAPH
    {0xE86E, 0x9229}, //6533 #CJK UNIFIED IDEOGRAPH
    {0xE86F, 0x9470}, //6534 #CJK UNIFIED IDEOGRAPH
    {0xE870, 0x9475}, //6535 #CJK UNIFIED IDEOGRAPH
    {0xE871, 0x9477}, //6536 #CJK UNIFIED IDEOGRAPH
    {0xE872, 0x947D}, //6537 #CJK UNIFIED IDEOGRAPH
    {0xE873, 0x945A}, //6538 #CJK UNIFIED IDEOGRAPH
    {0xE874, 0x947C}, //6539 #CJK UNIFIED IDEOGRAPH
    {0xE875, 0x947E}, //6540 #CJK UNIFIED IDEOGRAPH
    {0xE876, 0x9481}, //6541 #CJK UNIFIED IDEOGRAPH
    {0xE877, 0x947F}, //6542 #CJK UNIFIED IDEOGRAPH
    {0xE878, 0x9582}, //6543 #CJK UNIFIED IDEOGRAPH
    {0xE879, 0x9587}, //6544 #CJK UNIFIED IDEOGRAPH
    {0xE87A, 0x958A}, //6545 #CJK UNIFIED IDEOGRAPH
    {0xE87B, 0x9594}, //6546 #CJK UNIFIED IDEOGRAPH
    {0xE87C, 0x9596}, //6547 #CJK UNIFIED IDEOGRAPH
    {0xE87D, 0x9598}, //6548 #CJK UNIFIED IDEOGRAPH
    {0xE87E, 0x9599}, //6549 #CJK UNIFIED IDEOGRAPH
    {0xE880, 0x95A0}, //6550 #CJK UNIFIED IDEOGRAPH
    {0xE881, 0x95A8}, //6551 #CJK UNIFIED IDEOGRAPH
    {0xE882, 0x95A7}, //6552 #CJK UNIFIED IDEOGRAPH
    {0xE883, 0x95AD}, //6553 #CJK UNIFIED IDEOGRAPH
    {0xE884, 0x95BC}, //6554 #CJK UNIFIED IDEOGRAPH
    {0xE885, 0x95BB}, //6555 #CJK UNIFIED IDEOGRAPH
    {0xE886, 0x95B9}, //6556 #CJK UNIFIED IDEOGRAPH
    {0xE887, 0x95BE}, //6557 #CJK UNIFIED IDEOGRAPH
    {0xE888, 0x95CA}, //6558 #CJK UNIFIED IDEOGRAPH
    {0xE889, 0x6FF6}, //6559 #CJK UNIFIED IDEOGRAPH
    {0xE88A, 0x95C3}, //6560 #CJK UNIFIED IDEOGRAPH
    {0xE88B, 0x95CD}, //6561 #CJK UNIFIED IDEOGRAPH
    {0xE88C, 0x95CC}, //6562 #CJK UNIFIED IDEOGRAPH
    {0xE88D, 0x95D5}, //6563 #CJK UNIFIED IDEOGRAPH
    {0xE88E, 0x95D4}, //6564 #CJK UNIFIED IDEOGRAPH
    {0xE88F, 0x95D6}, //6565 #CJK UNIFIED IDEOGRAPH
    {0xE890, 0x95DC}, //6566 #CJK UNIFIED IDEOGRAPH
    {0xE891, 0x95E1}, //6567 #CJK UNIFIED IDEOGRAPH
    {0xE892, 0x95E5}, //6568 #CJK UNIFIED IDEOGRAPH
    {0xE893, 0x95E2}, //6569 #CJK UNIFIED IDEOGRAPH
    {0xE894, 0x9621}, //6570 #CJK UNIFIED IDEOGRAPH
    {0xE895, 0x9628}, //6571 #CJK UNIFIED IDEOGRAPH
    {0xE896, 0x962E}, //6572 #CJK UNIFIED IDEOGRAPH
    {0xE897, 0x962F}, //6573 #CJK UNIFIED IDEOGRAPH
    {0xE898, 0x9642}, //6574 #CJK UNIFIED IDEOGRAPH
    {0xE899, 0x964C}, //6575 #CJK UNIFIED IDEOGRAPH
    {0xE89A, 0x964F}, //6576 #CJK UNIFIED IDEOGRAPH
    {0xE89B, 0x964B}, //6577 #CJK UNIFIED IDEOGRAPH
    {0xE89C, 0x9677}, //6578 #CJK UNIFIED IDEOGRAPH
    {0xE89D, 0x965C}, //6579 #CJK UNIFIED IDEOGRAPH
    {0xE89E, 0x965E}, //6580 #CJK UNIFIED IDEOGRAPH
    {0xE89F, 0x965D}, //6581 #CJK UNIFIED IDEOGRAPH
    {0xE8A0, 0x965F}, //6582 #CJK UNIFIED IDEOGRAPH
    {0xE8A1, 0x9666}, //6583 #CJK UNIFIED IDEOGRAPH
    {0xE8A2, 0x9672}, //6584 #CJK UNIFIED IDEOGRAPH
    {0xE8A3, 0x966C}, //6585 #CJK UNIFIED IDEOGRAPH
    {0xE8A4, 0x968D}, //6586 #CJK UNIFIED IDEOGRAPH
    {0xE8A5, 0x9698}, //6587 #CJK UNIFIED IDEOGRAPH
    {0xE8A6, 0x9695}, //6588 #CJK UNIFIED IDEOGRAPH
    {0xE8A7, 0x9697}, //6589 #CJK UNIFIED IDEOGRAPH
    {0xE8A8, 0x96AA}, //6590 #CJK UNIFIED IDEOGRAPH
    {0xE8A9, 0x96A7}, //6591 #CJK UNIFIED IDEOGRAPH
    {0xE8AA, 0x96B1}, //6592 #CJK UNIFIED IDEOGRAPH
    {0xE8AB, 0x96B2}, //6593 #CJK UNIFIED IDEOGRAPH
    {0xE8AC, 0x96B0}, //6594 #CJK UNIFIED IDEOGRAPH
    {0xE8AD, 0x96B4}, //6595 #CJK UNIFIED IDEOGRAPH
    {0xE8AE, 0x96B6}, //6596 #CJK UNIFIED IDEOGRAPH
    {0xE8AF, 0x96B8}, //6597 #CJK UNIFIED IDEOGRAPH
    {0xE8B0, 0x96B9}, //6598 #CJK UNIFIED IDEOGRAPH
    {0xE8B1, 0x96CE}, //6599 #CJK UNIFIED IDEOGRAPH
    {0xE8B2, 0x96CB}, //6600 #CJK UNIFIED IDEOGRAPH
    {0xE8B3, 0x96C9}, //6601 #CJK UNIFIED IDEOGRAPH
    {0xE8B4, 0x96CD}, //6602 #CJK UNIFIED IDEOGRAPH
    {0xE8B5, 0x894D}, //6603 #CJK UNIFIED IDEOGRAPH
    {0xE8B6, 0x96DC}, //6604 #CJK UNIFIED IDEOGRAPH
    {0xE8B7, 0x970D}, //6605 #CJK UNIFIED IDEOGRAPH
    {0xE8B8, 0x96D5}, //6606 #CJK UNIFIED IDEOGRAPH
    {0xE8B9, 0x96F9}, //6607 #CJK UNIFIED IDEOGRAPH
    {0xE8BA, 0x9704}, //6608 #CJK UNIFIED IDEOGRAPH
    {0xE8BB, 0x9706}, //6609 #CJK UNIFIED IDEOGRAPH
    {0xE8BC, 0x9708}, //6610 #CJK UNIFIED IDEOGRAPH
    {0xE8BD, 0x9713}, //6611 #CJK UNIFIED IDEOGRAPH
    {0xE8BE, 0x970E}, //6612 #CJK UNIFIED IDEOGRAPH
    {0xE8BF, 0x9711}, //6613 #CJK UNIFIED IDEOGRAPH
    {0xE8C0, 0x970F}, //6614 #CJK UNIFIED IDEOGRAPH
    {0xE8C1, 0x9716}, //6615 #CJK UNIFIED IDEOGRAPH
    {0xE8C2, 0x9719}, //6616 #CJK UNIFIED IDEOGRAPH
    {0xE8C3, 0x9724}, //6617 #CJK UNIFIED IDEOGRAPH
    {0xE8C4, 0x972A}, //6618 #CJK UNIFIED IDEOGRAPH
    {0xE8C5, 0x9730}, //6619 #CJK UNIFIED IDEOGRAPH
    {0xE8C6, 0x9739}, //6620 #CJK UNIFIED IDEOGRAPH
    {0xE8C7, 0x973D}, //6621 #CJK UNIFIED IDEOGRAPH
    {0xE8C8, 0x973E}, //6622 #CJK UNIFIED IDEOGRAPH
    {0xE8C9, 0x9744}, //6623 #CJK UNIFIED IDEOGRAPH
    {0xE8CA, 0x9746}, //6624 #CJK UNIFIED IDEOGRAPH
    {0xE8CB, 0x9748}, //6625 #CJK UNIFIED IDEOGRAPH
    {0xE8CC, 0x9742}, //6626 #CJK UNIFIED IDEOGRAPH
    {0xE8CD, 0x9749}, //6627 #CJK UNIFIED IDEOGRAPH
    {0xE8CE, 0x975C}, //6628 #CJK UNIFIED IDEOGRAPH
    {0xE8CF, 0x9760}, //6629 #CJK UNIFIED IDEOGRAPH
    {0xE8D0, 0x9764}, //6630 #CJK UNIFIED IDEOGRAPH
    {0xE8D1, 0x9766}, //6631 #CJK UNIFIED IDEOGRAPH
    {0xE8D2, 0x9768}, //6632 #CJK UNIFIED IDEOGRAPH
    {0xE8D3, 0x52D2}, //6633 #CJK UNIFIED IDEOGRAPH
    {0xE8D4, 0x976B}, //6634 #CJK UNIFIED IDEOGRAPH
    {0xE8D5, 0x9771}, //6635 #CJK UNIFIED IDEOGRAPH
    {0xE8D6, 0x9779}, //6636 #CJK UNIFIED IDEOGRAPH
    {0xE8D7, 0x9785}, //6637 #CJK UNIFIED IDEOGRAPH
    {0xE8D8, 0x977C}, //6638 #CJK UNIFIED IDEOGRAPH
    {0xE8D9, 0x9781}, //6639 #CJK UNIFIED IDEOGRAPH
    {0xE8DA, 0x977A}, //6640 #CJK UNIFIED IDEOGRAPH
    {0xE8DB, 0x9786}, //6641 #CJK UNIFIED IDEOGRAPH
    {0xE8DC, 0x978B}, //6642 #CJK UNIFIED IDEOGRAPH
    {0xE8DD, 0x978F}, //6643 #CJK UNIFIED IDEOGRAPH
    {0xE8DE, 0x9790}, //6644 #CJK UNIFIED IDEOGRAPH
    {0xE8DF, 0x979C}, //6645 #CJK UNIFIED IDEOGRAPH
    {0xE8E0, 0x97A8}, //6646 #CJK UNIFIED IDEOGRAPH
    {0xE8E1, 0x97A6}, //6647 #CJK UNIFIED IDEOGRAPH
    {0xE8E2, 0x97A3}, //6648 #CJK UNIFIED IDEOGRAPH
    {0xE8E3, 0x97B3}, //6649 #CJK UNIFIED IDEOGRAPH
    {0xE8E4, 0x97B4}, //6650 #CJK UNIFIED IDEOGRAPH
    {0xE8E5, 0x97C3}, //6651 #CJK UNIFIED IDEOGRAPH
    {0xE8E6, 0x97C6}, //6652 #CJK UNIFIED IDEOGRAPH
    {0xE8E7, 0x97C8}, //6653 #CJK UNIFIED IDEOGRAPH
    {0xE8E8, 0x97CB}, //6654 #CJK UNIFIED IDEOGRAPH
    {0xE8E9, 0x97DC}, //6655 #CJK UNIFIED IDEOGRAPH
    {0xE8EA, 0x97ED}, //6656 #CJK UNIFIED IDEOGRAPH
    {0xE8EB, 0x9F4F}, //6657 #CJK UNIFIED IDEOGRAPH
    {0xE8EC, 0x97F2}, //6658 #CJK UNIFIED IDEOGRAPH
    {0xE8ED, 0x7ADF}, //6659 #CJK UNIFIED IDEOGRAPH
    {0xE8EE, 0x97F6}, //6660 #CJK UNIFIED IDEOGRAPH
    {0xE8EF, 0x97F5}, //6661 #CJK UNIFIED IDEOGRAPH
    {0xE8F0, 0x980F}, //6662 #CJK UNIFIED IDEOGRAPH
    {0xE8F1, 0x980C}, //6663 #CJK UNIFIED IDEOGRAPH
    {0xE8F2, 0x9838}, //6664 #CJK UNIFIED IDEOGRAPH
    {0xE8F3, 0x9824}, //6665 #CJK UNIFIED IDEOGRAPH
    {0xE8F4, 0x9821}, //6666 #CJK UNIFIED IDEOGRAPH
    {0xE8F5, 0x9837}, //6667 #CJK UNIFIED IDEOGRAPH
    {0xE8F6, 0x983D}, //6668 #CJK UNIFIED IDEOGRAPH
    {0xE8F7, 0x9846}, //6669 #CJK UNIFIED IDEOGRAPH
    {0xE8F8, 0x984F}, //6670 #CJK UNIFIED IDEOGRAPH
    {0xE8F9, 0x984B}, //6671 #CJK UNIFIED IDEOGRAPH
    {0xE8FA, 0x986B}, //6672 #CJK UNIFIED IDEOGRAPH
    {0xE8FB, 0x986F}, //6673 #CJK UNIFIED IDEOGRAPH
    {0xE8FC, 0x9870}, //6674 #CJK UNIFIED IDEOGRAPH
    {0xE940, 0x9871}, //6675 #CJK UNIFIED IDEOGRAPH
    {0xE941, 0x9874}, //6676 #CJK UNIFIED IDEOGRAPH
    {0xE942, 0x9873}, //6677 #CJK UNIFIED IDEOGRAPH
    {0xE943, 0x98AA}, //6678 #CJK UNIFIED IDEOGRAPH
    {0xE944, 0x98AF}, //6679 #CJK UNIFIED IDEOGRAPH
    {0xE945, 0x98B1}, //6680 #CJK UNIFIED IDEOGRAPH
    {0xE946, 0x98B6}, //6681 #CJK UNIFIED IDEOGRAPH
    {0xE947, 0x98C4}, //6682 #CJK UNIFIED IDEOGRAPH
    {0xE948, 0x98C3}, //6683 #CJK UNIFIED IDEOGRAPH
    {0xE949, 0x98C6}, //6684 #CJK UNIFIED IDEOGRAPH
    {0xE94A, 0x98E9}, //6685 #CJK UNIFIED IDEOGRAPH
    {0xE94B, 0x98EB}, //6686 #CJK UNIFIED IDEOGRAPH
    {0xE94C, 0x9903}, //6687 #CJK UNIFIED IDEOGRAPH
    {0xE94D, 0x9909}, //6688 #CJK UNIFIED IDEOGRAPH
    {0xE94E, 0x9912}, //6689 #CJK UNIFIED IDEOGRAPH
    {0xE94F, 0x9914}, //6690 #CJK UNIFIED IDEOGRAPH
    {0xE950, 0x9918}, //6691 #CJK UNIFIED IDEOGRAPH
    {0xE951, 0x9921}, //6692 #CJK UNIFIED IDEOGRAPH
    {0xE952, 0x991D}, //6693 #CJK UNIFIED IDEOGRAPH
    {0xE953, 0x991E}, //6694 #CJK UNIFIED IDEOGRAPH
    {0xE954, 0x9924}, //6695 #CJK UNIFIED IDEOGRAPH
    {0xE955, 0x9920}, //6696 #CJK UNIFIED IDEOGRAPH
    {0xE956, 0x992C}, //6697 #CJK UNIFIED IDEOGRAPH
    {0xE957, 0x992E}, //6698 #CJK UNIFIED IDEOGRAPH
    {0xE958, 0x993D}, //6699 #CJK UNIFIED IDEOGRAPH
    {0xE959, 0x993E}, //6700 #CJK UNIFIED IDEOGRAPH
    {0xE95A, 0x9942}, //6701 #CJK UNIFIED IDEOGRAPH
    {0xE95B, 0x9949}, //6702 #CJK UNIFIED IDEOGRAPH
    {0xE95C, 0x9945}, //6703 #CJK UNIFIED IDEOGRAPH
    {0xE95D, 0x9950}, //6704 #CJK UNIFIED IDEOGRAPH
    {0xE95E, 0x994B}, //6705 #CJK UNIFIED IDEOGRAPH
    {0xE95F, 0x9951}, //6706 #CJK UNIFIED IDEOGRAPH
    {0xE960, 0x9952}, //6707 #CJK UNIFIED IDEOGRAPH
    {0xE961, 0x994C}, //6708 #CJK UNIFIED IDEOGRAPH
    {0xE962, 0x9955}, //6709 #CJK UNIFIED IDEOGRAPH
    {0xE963, 0x9997}, //6710 #CJK UNIFIED IDEOGRAPH
    {0xE964, 0x9998}, //6711 #CJK UNIFIED IDEOGRAPH
    {0xE965, 0x99A5}, //6712 #CJK UNIFIED IDEOGRAPH
    {0xE966, 0x99AD}, //6713 #CJK UNIFIED IDEOGRAPH
    {0xE967, 0x99AE}, //6714 #CJK UNIFIED IDEOGRAPH
    {0xE968, 0x99BC}, //6715 #CJK UNIFIED IDEOGRAPH
    {0xE969, 0x99DF}, //6716 #CJK UNIFIED IDEOGRAPH
    {0xE96A, 0x99DB}, //6717 #CJK UNIFIED IDEOGRAPH
    {0xE96B, 0x99DD}, //6718 #CJK UNIFIED IDEOGRAPH
    {0xE96C, 0x99D8}, //6719 #CJK UNIFIED IDEOGRAPH
    {0xE96D, 0x99D1}, //6720 #CJK UNIFIED IDEOGRAPH
    {0xE96E, 0x99ED}, //6721 #CJK UNIFIED IDEOGRAPH
    {0xE96F, 0x99EE}, //6722 #CJK UNIFIED IDEOGRAPH
    {0xE970, 0x99F1}, //6723 #CJK UNIFIED IDEOGRAPH
    {0xE971, 0x99F2}, //6724 #CJK UNIFIED IDEOGRAPH
    {0xE972, 0x99FB}, //6725 #CJK UNIFIED IDEOGRAPH
    {0xE973, 0x99F8}, //6726 #CJK UNIFIED IDEOGRAPH
    {0xE974, 0x9A01}, //6727 #CJK UNIFIED IDEOGRAPH
    {0xE975, 0x9A0F}, //6728 #CJK UNIFIED IDEOGRAPH
    {0xE976, 0x9A05}, //6729 #CJK UNIFIED IDEOGRAPH
    {0xE977, 0x99E2}, //6730 #CJK UNIFIED IDEOGRAPH
    {0xE978, 0x9A19}, //6731 #CJK UNIFIED IDEOGRAPH
    {0xE979, 0x9A2B}, //6732 #CJK UNIFIED IDEOGRAPH
    {0xE97A, 0x9A37}, //6733 #CJK UNIFIED IDEOGRAPH
    {0xE97B, 0x9A45}, //6734 #CJK UNIFIED IDEOGRAPH
    {0xE97C, 0x9A42}, //6735 #CJK UNIFIED IDEOGRAPH
    {0xE97D, 0x9A40}, //6736 #CJK UNIFIED IDEOGRAPH
    {0xE97E, 0x9A43}, //6737 #CJK UNIFIED IDEOGRAPH
    {0xE980, 0x9A3E}, //6738 #CJK UNIFIED IDEOGRAPH
    {0xE981, 0x9A55}, //6739 #CJK UNIFIED IDEOGRAPH
    {0xE982, 0x9A4D}, //6740 #CJK UNIFIED IDEOGRAPH
    {0xE983, 0x9A5B}, //6741 #CJK UNIFIED IDEOGRAPH
    {0xE984, 0x9A57}, //6742 #CJK UNIFIED IDEOGRAPH
    {0xE985, 0x9A5F}, //6743 #CJK UNIFIED IDEOGRAPH
    {0xE986, 0x9A62}, //6744 #CJK UNIFIED IDEOGRAPH
    {0xE987, 0x9A65}, //6745 #CJK UNIFIED IDEOGRAPH
    {0xE988, 0x9A64}, //6746 #CJK UNIFIED IDEOGRAPH
    {0xE989, 0x9A69}, //6747 #CJK UNIFIED IDEOGRAPH
    {0xE98A, 0x9A6B}, //6748 #CJK UNIFIED IDEOGRAPH
    {0xE98B, 0x9A6A}, //6749 #CJK UNIFIED IDEOGRAPH
    {0xE98C, 0x9AAD}, //6750 #CJK UNIFIED IDEOGRAPH
    {0xE98D, 0x9AB0}, //6751 #CJK UNIFIED IDEOGRAPH
    {0xE98E, 0x9ABC}, //6752 #CJK UNIFIED IDEOGRAPH
    {0xE98F, 0x9AC0}, //6753 #CJK UNIFIED IDEOGRAPH
    {0xE990, 0x9ACF}, //6754 #CJK UNIFIED IDEOGRAPH
    {0xE991, 0x9AD1}, //6755 #CJK UNIFIED IDEOGRAPH
    {0xE992, 0x9AD3}, //6756 #CJK UNIFIED IDEOGRAPH
    {0xE993, 0x9AD4}, //6757 #CJK UNIFIED IDEOGRAPH
    {0xE994, 0x9ADE}, //6758 #CJK UNIFIED IDEOGRAPH
    {0xE995, 0x9ADF}, //6759 #CJK UNIFIED IDEOGRAPH
    {0xE996, 0x9AE2}, //6760 #CJK UNIFIED IDEOGRAPH
    {0xE997, 0x9AE3}, //6761 #CJK UNIFIED IDEOGRAPH
    {0xE998, 0x9AE6}, //6762 #CJK UNIFIED IDEOGRAPH
    {0xE999, 0x9AEF}, //6763 #CJK UNIFIED IDEOGRAPH
    {0xE99A, 0x9AEB}, //6764 #CJK UNIFIED IDEOGRAPH
    {0xE99B, 0x9AEE}, //6765 #CJK UNIFIED IDEOGRAPH
    {0xE99C, 0x9AF4}, //6766 #CJK UNIFIED IDEOGRAPH
    {0xE99D, 0x9AF1}, //6767 #CJK UNIFIED IDEOGRAPH
    {0xE99E, 0x9AF7}, //6768 #CJK UNIFIED IDEOGRAPH
    {0xE99F, 0x9AFB}, //6769 #CJK UNIFIED IDEOGRAPH
    {0xE9A0, 0x9B06}, //6770 #CJK UNIFIED IDEOGRAPH
    {0xE9A1, 0x9B18}, //6771 #CJK UNIFIED IDEOGRAPH
    {0xE9A2, 0x9B1A}, //6772 #CJK UNIFIED IDEOGRAPH
    {0xE9A3, 0x9B1F}, //6773 #CJK UNIFIED IDEOGRAPH
    {0xE9A4, 0x9B22}, //6774 #CJK UNIFIED IDEOGRAPH
    {0xE9A5, 0x9B23}, //6775 #CJK UNIFIED IDEOGRAPH
    {0xE9A6, 0x9B25}, //6776 #CJK UNIFIED IDEOGRAPH
    {0xE9A7, 0x9B27}, //6777 #CJK UNIFIED IDEOGRAPH
    {0xE9A8, 0x9B28}, //6778 #CJK UNIFIED IDEOGRAPH
    {0xE9A9, 0x9B29}, //6779 #CJK UNIFIED IDEOGRAPH
    {0xE9AA, 0x9B2A}, //6780 #CJK UNIFIED IDEOGRAPH
    {0xE9AB, 0x9B2E}, //6781 #CJK UNIFIED IDEOGRAPH
    {0xE9AC, 0x9B2F}, //6782 #CJK UNIFIED IDEOGRAPH
    {0xE9AD, 0x9B32}, //6783 #CJK UNIFIED IDEOGRAPH
    {0xE9AE, 0x9B44}, //6784 #CJK UNIFIED IDEOGRAPH
    {0xE9AF, 0x9B43}, //6785 #CJK UNIFIED IDEOGRAPH
    {0xE9B0, 0x9B4F}, //6786 #CJK UNIFIED IDEOGRAPH
    {0xE9B1, 0x9B4D}, //6787 #CJK UNIFIED IDEOGRAPH
    {0xE9B2, 0x9B4E}, //6788 #CJK UNIFIED IDEOGRAPH
    {0xE9B3, 0x9B51}, //6789 #CJK UNIFIED IDEOGRAPH
    {0xE9B4, 0x9B58}, //6790 #CJK UNIFIED IDEOGRAPH
    {0xE9B5, 0x9B74}, //6791 #CJK UNIFIED IDEOGRAPH
    {0xE9B6, 0x9B93}, //6792 #CJK UNIFIED IDEOGRAPH
    {0xE9B7, 0x9B83}, //6793 #CJK UNIFIED IDEOGRAPH
    {0xE9B8, 0x9B91}, //6794 #CJK UNIFIED IDEOGRAPH
    {0xE9B9, 0x9B96}, //6795 #CJK UNIFIED IDEOGRAPH
    {0xE9BA, 0x9B97}, //6796 #CJK UNIFIED IDEOGRAPH
    {0xE9BB, 0x9B9F}, //6797 #CJK UNIFIED IDEOGRAPH
    {0xE9BC, 0x9BA0}, //6798 #CJK UNIFIED IDEOGRAPH
    {0xE9BD, 0x9BA8}, //6799 #CJK UNIFIED IDEOGRAPH
    {0xE9BE, 0x9BB4}, //6800 #CJK UNIFIED IDEOGRAPH
    {0xE9BF, 0x9BC0}, //6801 #CJK UNIFIED IDEOGRAPH
    {0xE9C0, 0x9BCA}, //6802 #CJK UNIFIED IDEOGRAPH
    {0xE9C1, 0x9BB9}, //6803 #CJK UNIFIED IDEOGRAPH
    {0xE9C2, 0x9BC6}, //6804 #CJK UNIFIED IDEOGRAPH
    {0xE9C3, 0x9BCF}, //6805 #CJK UNIFIED IDEOGRAPH
    {0xE9C4, 0x9BD1}, //6806 #CJK UNIFIED IDEOGRAPH
    {0xE9C5, 0x9BD2}, //6807 #CJK UNIFIED IDEOGRAPH
    {0xE9C6, 0x9BE3}, //6808 #CJK UNIFIED IDEOGRAPH
    {0xE9C7, 0x9BE2}, //6809 #CJK UNIFIED IDEOGRAPH
    {0xE9C8, 0x9BE4}, //6810 #CJK UNIFIED IDEOGRAPH
    {0xE9C9, 0x9BD4}, //6811 #CJK UNIFIED IDEOGRAPH
    {0xE9CA, 0x9BE1}, //6812 #CJK UNIFIED IDEOGRAPH
    {0xE9CB, 0x9C3A}, //6813 #CJK UNIFIED IDEOGRAPH
    {0xE9CC, 0x9BF2}, //6814 #CJK UNIFIED IDEOGRAPH
    {0xE9CD, 0x9BF1}, //6815 #CJK UNIFIED IDEOGRAPH
    {0xE9CE, 0x9BF0}, //6816 #CJK UNIFIED IDEOGRAPH
    {0xE9CF, 0x9C15}, //6817 #CJK UNIFIED IDEOGRAPH
    {0xE9D0, 0x9C14}, //6818 #CJK UNIFIED IDEOGRAPH
    {0xE9D1, 0x9C09}, //6819 #CJK UNIFIED IDEOGRAPH
    {0xE9D2, 0x9C13}, //6820 #CJK UNIFIED IDEOGRAPH
    {0xE9D3, 0x9C0C}, //6821 #CJK UNIFIED IDEOGRAPH
    {0xE9D4, 0x9C06}, //6822 #CJK UNIFIED IDEOGRAPH
    {0xE9D5, 0x9C08}, //6823 #CJK UNIFIED IDEOGRAPH
    {0xE9D6, 0x9C12}, //6824 #CJK UNIFIED IDEOGRAPH
    {0xE9D7, 0x9C0A}, //6825 #CJK UNIFIED IDEOGRAPH
    {0xE9D8, 0x9C04}, //6826 #CJK UNIFIED IDEOGRAPH
    {0xE9D9, 0x9C2E}, //6827 #CJK UNIFIED IDEOGRAPH
    {0xE9DA, 0x9C1B}, //6828 #CJK UNIFIED IDEOGRAPH
    {0xE9DB, 0x9C25}, //6829 #CJK UNIFIED IDEOGRAPH
    {0xE9DC, 0x9C24}, //6830 #CJK UNIFIED IDEOGRAPH
    {0xE9DD, 0x9C21}, //6831 #CJK UNIFIED IDEOGRAPH
    {0xE9DE, 0x9C30}, //6832 #CJK UNIFIED IDEOGRAPH
    {0xE9DF, 0x9C47}, //6833 #CJK UNIFIED IDEOGRAPH
    {0xE9E0, 0x9C32}, //6834 #CJK UNIFIED IDEOGRAPH
    {0xE9E1, 0x9C46}, //6835 #CJK UNIFIED IDEOGRAPH
    {0xE9E2, 0x9C3E}, //6836 #CJK UNIFIED IDEOGRAPH
    {0xE9E3, 0x9C5A}, //6837 #CJK UNIFIED IDEOGRAPH
    {0xE9E4, 0x9C60}, //6838 #CJK UNIFIED IDEOGRAPH
    {0xE9E5, 0x9C67}, //6839 #CJK UNIFIED IDEOGRAPH
    {0xE9E6, 0x9C76}, //6840 #CJK UNIFIED IDEOGRAPH
    {0xE9E7, 0x9C78}, //6841 #CJK UNIFIED IDEOGRAPH
    {0xE9E8, 0x9CE7}, //6842 #CJK UNIFIED IDEOGRAPH
    {0xE9E9, 0x9CEC}, //6843 #CJK UNIFIED IDEOGRAPH
    {0xE9EA, 0x9CF0}, //6844 #CJK UNIFIED IDEOGRAPH
    {0xE9EB, 0x9D09}, //6845 #CJK UNIFIED IDEOGRAPH
    {0xE9EC, 0x9D08}, //6846 #CJK UNIFIED IDEOGRAPH
    {0xE9ED, 0x9CEB}, //6847 #CJK UNIFIED IDEOGRAPH
    {0xE9EE, 0x9D03}, //6848 #CJK UNIFIED IDEOGRAPH
    {0xE9EF, 0x9D06}, //6849 #CJK UNIFIED IDEOGRAPH
    {0xE9F0, 0x9D2A}, //6850 #CJK UNIFIED IDEOGRAPH
    {0xE9F1, 0x9D26}, //6851 #CJK UNIFIED IDEOGRAPH
    {0xE9F2, 0x9DAF}, //6852 #CJK UNIFIED IDEOGRAPH
    {0xE9F3, 0x9D23}, //6853 #CJK UNIFIED IDEOGRAPH
    {0xE9F4, 0x9D1F}, //6854 #CJK UNIFIED IDEOGRAPH
    {0xE9F5, 0x9D44}, //6855 #CJK UNIFIED IDEOGRAPH
    {0xE9F6, 0x9D15}, //6856 #CJK UNIFIED IDEOGRAPH
    {0xE9F7, 0x9D12}, //6857 #CJK UNIFIED IDEOGRAPH
    {0xE9F8, 0x9D41}, //6858 #CJK UNIFIED IDEOGRAPH
    {0xE9F9, 0x9D3F}, //6859 #CJK UNIFIED IDEOGRAPH
    {0xE9FA, 0x9D3E}, //6860 #CJK UNIFIED IDEOGRAPH
    {0xE9FB, 0x9D46}, //6861 #CJK UNIFIED IDEOGRAPH
    {0xE9FC, 0x9D48}, //6862 #CJK UNIFIED IDEOGRAPH
    {0xEA40, 0x9D5D}, //6863 #CJK UNIFIED IDEOGRAPH
    {0xEA41, 0x9D5E}, //6864 #CJK UNIFIED IDEOGRAPH
    {0xEA42, 0x9D64}, //6865 #CJK UNIFIED IDEOGRAPH
    {0xEA43, 0x9D51}, //6866 #CJK UNIFIED IDEOGRAPH
    {0xEA44, 0x9D50}, //6867 #CJK UNIFIED IDEOGRAPH
    {0xEA45, 0x9D59}, //6868 #CJK UNIFIED IDEOGRAPH
    {0xEA46, 0x9D72}, //6869 #CJK UNIFIED IDEOGRAPH
    {0xEA47, 0x9D89}, //6870 #CJK UNIFIED IDEOGRAPH
    {0xEA48, 0x9D87}, //6871 #CJK UNIFIED IDEOGRAPH
    {0xEA49, 0x9DAB}, //6872 #CJK UNIFIED IDEOGRAPH
    {0xEA4A, 0x9D6F}, //6873 #CJK UNIFIED IDEOGRAPH
    {0xEA4B, 0x9D7A}, //6874 #CJK UNIFIED IDEOGRAPH
    {0xEA4C, 0x9D9A}, //6875 #CJK UNIFIED IDEOGRAPH
    {0xEA4D, 0x9DA4}, //6876 #CJK UNIFIED IDEOGRAPH
    {0xEA4E, 0x9DA9}, //6877 #CJK UNIFIED IDEOGRAPH
    {0xEA4F, 0x9DB2}, //6878 #CJK UNIFIED IDEOGRAPH
    {0xEA50, 0x9DC4}, //6879 #CJK UNIFIED IDEOGRAPH
    {0xEA51, 0x9DC1}, //6880 #CJK UNIFIED IDEOGRAPH
    {0xEA52, 0x9DBB}, //6881 #CJK UNIFIED IDEOGRAPH
    {0xEA53, 0x9DB8}, //6882 #CJK UNIFIED IDEOGRAPH
    {0xEA54, 0x9DBA}, //6883 #CJK UNIFIED IDEOGRAPH
    {0xEA55, 0x9DC6}, //6884 #CJK UNIFIED IDEOGRAPH
    {0xEA56, 0x9DCF}, //6885 #CJK UNIFIED IDEOGRAPH
    {0xEA57, 0x9DC2}, //6886 #CJK UNIFIED IDEOGRAPH
    {0xEA58, 0x9DD9}, //6887 #CJK UNIFIED IDEOGRAPH
    {0xEA59, 0x9DD3}, //6888 #CJK UNIFIED IDEOGRAPH
    {0xEA5A, 0x9DF8}, //6889 #CJK UNIFIED IDEOGRAPH
    {0xEA5B, 0x9DE6}, //6890 #CJK UNIFIED IDEOGRAPH
    {0xEA5C, 0x9DED}, //6891 #CJK UNIFIED IDEOGRAPH
    {0xEA5D, 0x9DEF}, //6892 #CJK UNIFIED IDEOGRAPH
    {0xEA5E, 0x9DFD}, //6893 #CJK UNIFIED IDEOGRAPH
    {0xEA5F, 0x9E1A}, //6894 #CJK UNIFIED IDEOGRAPH
    {0xEA60, 0x9E1B}, //6895 #CJK UNIFIED IDEOGRAPH
    {0xEA61, 0x9E1E}, //6896 #CJK UNIFIED IDEOGRAPH
    {0xEA62, 0x9E75}, //6897 #CJK UNIFIED IDEOGRAPH
    {0xEA63, 0x9E79}, //6898 #CJK UNIFIED IDEOGRAPH
    {0xEA64, 0x9E7D}, //6899 #CJK UNIFIED IDEOGRAPH
    {0xEA65, 0x9E81}, //6900 #CJK UNIFIED IDEOGRAPH
    {0xEA66, 0x9E88}, //6901 #CJK UNIFIED IDEOGRAPH
    {0xEA67, 0x9E8B}, //6902 #CJK UNIFIED IDEOGRAPH
    {0xEA68, 0x9E8C}, //6903 #CJK UNIFIED IDEOGRAPH
    {0xEA69, 0x9E92}, //6904 #CJK UNIFIED IDEOGRAPH
    {0xEA6A, 0x9E95}, //6905 #CJK UNIFIED IDEOGRAPH
    {0xEA6B, 0x9E91}, //6906 #CJK UNIFIED IDEOGRAPH
    {0xEA6C, 0x9E9D}, //6907 #CJK UNIFIED IDEOGRAPH
    {0xEA6D, 0x9EA5}, //6908 #CJK UNIFIED IDEOGRAPH
    {0xEA6E, 0x9EA9}, //6909 #CJK UNIFIED IDEOGRAPH
    {0xEA6F, 0x9EB8}, //6910 #CJK UNIFIED IDEOGRAPH
    {0xEA70, 0x9EAA}, //6911 #CJK UNIFIED IDEOGRAPH
    {0xEA71, 0x9EAD}, //6912 #CJK UNIFIED IDEOGRAPH
    {0xEA72, 0x9761}, //6913 #CJK UNIFIED IDEOGRAPH
    {0xEA73, 0x9ECC}, //6914 #CJK UNIFIED IDEOGRAPH
    {0xEA74, 0x9ECE}, //6915 #CJK UNIFIED IDEOGRAPH
    {0xEA75, 0x9ECF}, //6916 #CJK UNIFIED IDEOGRAPH
    {0xEA76, 0x9ED0}, //6917 #CJK UNIFIED IDEOGRAPH
    {0xEA77, 0x9ED4}, //6918 #CJK UNIFIED IDEOGRAPH
    {0xEA78, 0x9EDC}, //6919 #CJK UNIFIED IDEOGRAPH
    {0xEA79, 0x9EDE}, //6920 #CJK UNIFIED IDEOGRAPH
    {0xEA7A, 0x9EDD}, //6921 #CJK UNIFIED IDEOGRAPH
    {0xEA7B, 0x9EE0}, //6922 #CJK UNIFIED IDEOGRAPH
    {0xEA7C, 0x9EE5}, //6923 #CJK UNIFIED IDEOGRAPH
    {0xEA7D, 0x9EE8}, //6924 #CJK UNIFIED IDEOGRAPH
    {0xEA7E, 0x9EEF}, //6925 #CJK UNIFIED IDEOGRAPH
    {0xEA80, 0x9EF4}, //6926 #CJK UNIFIED IDEOGRAPH
    {0xEA81, 0x9EF6}, //6927 #CJK UNIFIED IDEOGRAPH
    {0xEA82, 0x9EF7}, //6928 #CJK UNIFIED IDEOGRAPH
    {0xEA83, 0x9EF9}, //6929 #CJK UNIFIED IDEOGRAPH
    {0xEA84, 0x9EFB}, //6930 #CJK UNIFIED IDEOGRAPH
    {0xEA85, 0x9EFC}, //6931 #CJK UNIFIED IDEOGRAPH
    {0xEA86, 0x9EFD}, //6932 #CJK UNIFIED IDEOGRAPH
    {0xEA87, 0x9F07}, //6933 #CJK UNIFIED IDEOGRAPH
    {0xEA88, 0x9F08}, //6934 #CJK UNIFIED IDEOGRAPH
    {0xEA89, 0x76B7}, //6935 #CJK UNIFIED IDEOGRAPH
    {0xEA8A, 0x9F15}, //6936 #CJK UNIFIED IDEOGRAPH
    {0xEA8B, 0x9F21}, //6937 #CJK UNIFIED IDEOGRAPH
    {0xEA8C, 0x9F2C}, //6938 #CJK UNIFIED IDEOGRAPH
    {0xEA8D, 0x9F3E}, //6939 #CJK UNIFIED IDEOGRAPH
    {0xEA8E, 0x9F4A}, //6940 #CJK UNIFIED IDEOGRAPH
    {0xEA8F, 0x9F52}, //6941 #CJK UNIFIED IDEOGRAPH
    {0xEA90, 0x9F54}, //6942 #CJK UNIFIED IDEOGRAPH
    {0xEA91, 0x9F63}, //6943 #CJK UNIFIED IDEOGRAPH
    {0xEA92, 0x9F5F}, //6944 #CJK UNIFIED IDEOGRAPH
    {0xEA93, 0x9F60}, //6945 #CJK UNIFIED IDEOGRAPH
    {0xEA94, 0x9F61}, //6946 #CJK UNIFIED IDEOGRAPH
    {0xEA95, 0x9F66}, //6947 #CJK UNIFIED IDEOGRAPH
    {0xEA96, 0x9F67}, //6948 #CJK UNIFIED IDEOGRAPH
    {0xEA97, 0x9F6C}, //6949 #CJK UNIFIED IDEOGRAPH
    {0xEA98, 0x9F6A}, //6950 #CJK UNIFIED IDEOGRAPH
    {0xEA99, 0x9F77}, //6951 #CJK UNIFIED IDEOGRAPH
    {0xEA9A, 0x9F72}, //6952 #CJK UNIFIED IDEOGRAPH
    {0xEA9B, 0x9F76}, //6953 #CJK UNIFIED IDEOGRAPH
    {0xEA9C, 0x9F95}, //6954 #CJK UNIFIED IDEOGRAPH
    {0xEA9D, 0x9F9C}, //6955 #CJK UNIFIED IDEOGRAPH
    {0xEA9E, 0x9FA0}, //6956 #CJK UNIFIED IDEOGRAPH
    {0xEA9F, 0x582F}, //6957 #CJK UNIFIED IDEOGRAPH
    {0xEAA0, 0x69C7}, //6958 #CJK UNIFIED IDEOGRAPH
    {0xEAA1, 0x9059}, //6959 #CJK UNIFIED IDEOGRAPH
    {0xEAA2, 0x7464}, //6960 #CJK UNIFIED IDEOGRAPH
    {0xEAA3, 0x51DC}, //6961 #CJK UNIFIED IDEOGRAPH
    {0xEAA4, 0x7199}, //6962 #CJK UNIFIED IDEOGRAPH
    {0xED40, 0x7E8A}, //6963 #CJK UNIFIED IDEOGRAPH
    {0xED41, 0x891C}, //6964 #CJK UNIFIED IDEOGRAPH
    {0xED42, 0x9348}, //6965 #CJK UNIFIED IDEOGRAPH
    {0xED43, 0x9288}, //6966 #CJK UNIFIED IDEOGRAPH
    {0xED44, 0x84DC}, //6967 #CJK UNIFIED IDEOGRAPH
    {0xED45, 0x4FC9}, //6968 #CJK UNIFIED IDEOGRAPH
    {0xED46, 0x70BB}, //6969 #CJK UNIFIED IDEOGRAPH
    {0xED47, 0x6631}, //6970 #CJK UNIFIED IDEOGRAPH
    {0xED48, 0x68C8}, //6971 #CJK UNIFIED IDEOGRAPH
    {0xED49, 0x92F9}, //6972 #CJK UNIFIED IDEOGRAPH
    {0xED4A, 0x66FB}, //6973 #CJK UNIFIED IDEOGRAPH
    {0xED4B, 0x5F45}, //6974 #CJK UNIFIED IDEOGRAPH
    {0xED4C, 0x4E28}, //6975 #CJK UNIFIED IDEOGRAPH
    {0xED4D, 0x4EE1}, //6976 #CJK UNIFIED IDEOGRAPH
    {0xED4E, 0x4EFC}, //6977 #CJK UNIFIED IDEOGRAPH
    {0xED4F, 0x4F00}, //6978 #CJK UNIFIED IDEOGRAPH
    {0xED50, 0x4F03}, //6979 #CJK UNIFIED IDEOGRAPH
    {0xED51, 0x4F39}, //6980 #CJK UNIFIED IDEOGRAPH
    {0xED52, 0x4F56}, //6981 #CJK UNIFIED IDEOGRAPH
    {0xED53, 0x4F92}, //6982 #CJK UNIFIED IDEOGRAPH
    {0xED54, 0x4F8A}, //6983 #CJK UNIFIED IDEOGRAPH
    {0xED55, 0x4F9A}, //6984 #CJK UNIFIED IDEOGRAPH
    {0xED56, 0x4F94}, //6985 #CJK UNIFIED IDEOGRAPH
    {0xED57, 0x4FCD}, //6986 #CJK UNIFIED IDEOGRAPH
    {0xED58, 0x5040}, //6987 #CJK UNIFIED IDEOGRAPH
    {0xED59, 0x5022}, //6988 #CJK UNIFIED IDEOGRAPH
    {0xED5A, 0x4FFF}, //6989 #CJK UNIFIED IDEOGRAPH
    {0xED5B, 0x501E}, //6990 #CJK UNIFIED IDEOGRAPH
    {0xED5C, 0x5046}, //6991 #CJK UNIFIED IDEOGRAPH
    {0xED5D, 0x5070}, //6992 #CJK UNIFIED IDEOGRAPH
    {0xED5E, 0x5042}, //6993 #CJK UNIFIED IDEOGRAPH
    {0xED5F, 0x5094}, //6994 #CJK UNIFIED IDEOGRAPH
    {0xED60, 0x50F4}, //6995 #CJK UNIFIED IDEOGRAPH
    {0xED61, 0x50D8}, //6996 #CJK UNIFIED IDEOGRAPH
    {0xED62, 0x514A}, //6997 #CJK UNIFIED IDEOGRAPH
    {0xED63, 0x5164}, //6998 #CJK UNIFIED IDEOGRAPH
    {0xED64, 0x519D}, //6999 #CJK UNIFIED IDEOGRAPH
    {0xED65, 0x51BE}, //7000 #CJK UNIFIED IDEOGRAPH
    {0xED66, 0x51EC}, //7001 #CJK UNIFIED IDEOGRAPH
    {0xED67, 0x5215}, //7002 #CJK UNIFIED IDEOGRAPH
    {0xED68, 0x529C}, //7003 #CJK UNIFIED IDEOGRAPH
    {0xED69, 0x52A6}, //7004 #CJK UNIFIED IDEOGRAPH
    {0xED6A, 0x52C0}, //7005 #CJK UNIFIED IDEOGRAPH
    {0xED6B, 0x52DB}, //7006 #CJK UNIFIED IDEOGRAPH
    {0xED6C, 0x5300}, //7007 #CJK UNIFIED IDEOGRAPH
    {0xED6D, 0x5307}, //7008 #CJK UNIFIED IDEOGRAPH
    {0xED6E, 0x5324}, //7009 #CJK UNIFIED IDEOGRAPH
    {0xED6F, 0x5372}, //7010 #CJK UNIFIED IDEOGRAPH
    {0xED70, 0x5393}, //7011 #CJK UNIFIED IDEOGRAPH
    {0xED71, 0x53B2}, //7012 #CJK UNIFIED IDEOGRAPH
    {0xED72, 0x53DD}, //7013 #CJK UNIFIED IDEOGRAPH
    {0xED73, 0xFA0E}, //7014 #CJK COMPATIBILITY IDEOGRAPH
    {0xED74, 0x549C}, //7015 #CJK UNIFIED IDEOGRAPH
    {0xED75, 0x548A}, //7016 #CJK UNIFIED IDEOGRAPH
    {0xED76, 0x54A9}, //7017 #CJK UNIFIED IDEOGRAPH
    {0xED77, 0x54FF}, //7018 #CJK UNIFIED IDEOGRAPH
    {0xED78, 0x5586}, //7019 #CJK UNIFIED IDEOGRAPH
    {0xED79, 0x5759}, //7020 #CJK UNIFIED IDEOGRAPH
    {0xED7A, 0x5765}, //7021 #CJK UNIFIED IDEOGRAPH
    {0xED7B, 0x57AC}, //7022 #CJK UNIFIED IDEOGRAPH
    {0xED7C, 0x57C8}, //7023 #CJK UNIFIED IDEOGRAPH
    {0xED7D, 0x57C7}, //7024 #CJK UNIFIED IDEOGRAPH
    {0xED7E, 0xFA0F}, //7025 #CJK COMPATIBILITY IDEOGRAPH
    {0xED80, 0xFA10}, //7026 #CJK COMPATIBILITY IDEOGRAPH
    {0xED81, 0x589E}, //7027 #CJK UNIFIED IDEOGRAPH
    {0xED82, 0x58B2}, //7028 #CJK UNIFIED IDEOGRAPH
    {0xED83, 0x590B}, //7029 #CJK UNIFIED IDEOGRAPH
    {0xED84, 0x5953}, //7030 #CJK UNIFIED IDEOGRAPH
    {0xED85, 0x595B}, //7031 #CJK UNIFIED IDEOGRAPH
    {0xED86, 0x595D}, //7032 #CJK UNIFIED IDEOGRAPH
    {0xED87, 0x5963}, //7033 #CJK UNIFIED IDEOGRAPH
    {0xED88, 0x59A4}, //7034 #CJK UNIFIED IDEOGRAPH
    {0xED89, 0x59BA}, //7035 #CJK UNIFIED IDEOGRAPH
    {0xED8A, 0x5B56}, //7036 #CJK UNIFIED IDEOGRAPH
    {0xED8B, 0x5BC0}, //7037 #CJK UNIFIED IDEOGRAPH
    {0xED8C, 0x752F}, //7038 #CJK UNIFIED IDEOGRAPH
    {0xED8D, 0x5BD8}, //7039 #CJK UNIFIED IDEOGRAPH
    {0xED8E, 0x5BEC}, //7040 #CJK UNIFIED IDEOGRAPH
    {0xED8F, 0x5C1E}, //7041 #CJK UNIFIED IDEOGRAPH
    {0xED90, 0x5CA6}, //7042 #CJK UNIFIED IDEOGRAPH
    {0xED91, 0x5CBA}, //7043 #CJK UNIFIED IDEOGRAPH
    {0xED92, 0x5CF5}, //7044 #CJK UNIFIED IDEOGRAPH
    {0xED93, 0x5D27}, //7045 #CJK UNIFIED IDEOGRAPH
    {0xED94, 0x5D53}, //7046 #CJK UNIFIED IDEOGRAPH
    {0xED95, 0xFA11}, //7047 #CJK COMPATIBILITY IDEOGRAPH
    {0xED96, 0x5D42}, //7048 #CJK UNIFIED IDEOGRAPH
    {0xED97, 0x5D6D}, //7049 #CJK UNIFIED IDEOGRAPH
    {0xED98, 0x5DB8}, //7050 #CJK UNIFIED IDEOGRAPH
    {0xED99, 0x5DB9}, //7051 #CJK UNIFIED IDEOGRAPH
    {0xED9A, 0x5DD0}, //7052 #CJK UNIFIED IDEOGRAPH
    {0xED9B, 0x5F21}, //7053 #CJK UNIFIED IDEOGRAPH
    {0xED9C, 0x5F34}, //7054 #CJK UNIFIED IDEOGRAPH
    {0xED9D, 0x5F67}, //7055 #CJK UNIFIED IDEOGRAPH
    {0xED9E, 0x5FB7}, //7056 #CJK UNIFIED IDEOGRAPH
    {0xED9F, 0x5FDE}, //7057 #CJK UNIFIED IDEOGRAPH
    {0xEDA0, 0x605D}, //7058 #CJK UNIFIED IDEOGRAPH
    {0xEDA1, 0x6085}, //7059 #CJK UNIFIED IDEOGRAPH
    {0xEDA2, 0x608A}, //7060 #CJK UNIFIED IDEOGRAPH
    {0xEDA3, 0x60DE}, //7061 #CJK UNIFIED IDEOGRAPH
    {0xEDA4, 0x60D5}, //7062 #CJK UNIFIED IDEOGRAPH
    {0xEDA5, 0x6120}, //7063 #CJK UNIFIED IDEOGRAPH
    {0xEDA6, 0x60F2}, //7064 #CJK UNIFIED IDEOGRAPH
    {0xEDA7, 0x6111}, //7065 #CJK UNIFIED IDEOGRAPH
    {0xEDA8, 0x6137}, //7066 #CJK UNIFIED IDEOGRAPH
    {0xEDA9, 0x6130}, //7067 #CJK UNIFIED IDEOGRAPH
    {0xEDAA, 0x6198}, //7068 #CJK UNIFIED IDEOGRAPH
    {0xEDAB, 0x6213}, //7069 #CJK UNIFIED IDEOGRAPH
    {0xEDAC, 0x62A6}, //7070 #CJK UNIFIED IDEOGRAPH
    {0xEDAD, 0x63F5}, //7071 #CJK UNIFIED IDEOGRAPH
    {0xEDAE, 0x6460}, //7072 #CJK UNIFIED IDEOGRAPH
    {0xEDAF, 0x649D}, //7073 #CJK UNIFIED IDEOGRAPH
    {0xEDB0, 0x64CE}, //7074 #CJK UNIFIED IDEOGRAPH
    {0xEDB1, 0x654E}, //7075 #CJK UNIFIED IDEOGRAPH
    {0xEDB2, 0x6600}, //7076 #CJK UNIFIED IDEOGRAPH
    {0xEDB3, 0x6615}, //7077 #CJK UNIFIED IDEOGRAPH
    {0xEDB4, 0x663B}, //7078 #CJK UNIFIED IDEOGRAPH
    {0xEDB5, 0x6609}, //7079 #CJK UNIFIED IDEOGRAPH
    {0xEDB6, 0x662E}, //7080 #CJK UNIFIED IDEOGRAPH
    {0xEDB7, 0x661E}, //7081 #CJK UNIFIED IDEOGRAPH
    {0xEDB8, 0x6624}, //7082 #CJK UNIFIED IDEOGRAPH
    {0xEDB9, 0x6665}, //7083 #CJK UNIFIED IDEOGRAPH
    {0xEDBA, 0x6657}, //7084 #CJK UNIFIED IDEOGRAPH
    {0xEDBB, 0x6659}, //7085 #CJK UNIFIED IDEOGRAPH
    {0xEDBC, 0xFA12}, //7086 #CJK COMPATIBILITY IDEOGRAPH
    {0xEDBD, 0x6673}, //7087 #CJK UNIFIED IDEOGRAPH
    {0xEDBE, 0x6699}, //7088 #CJK UNIFIED IDEOGRAPH
    {0xEDBF, 0x66A0}, //7089 #CJK UNIFIED IDEOGRAPH
    {0xEDC0, 0x66B2}, //7090 #CJK UNIFIED IDEOGRAPH
    {0xEDC1, 0x66BF}, //7091 #CJK UNIFIED IDEOGRAPH
    {0xEDC2, 0x66FA}, //7092 #CJK UNIFIED IDEOGRAPH
    {0xEDC3, 0x670E}, //7093 #CJK UNIFIED IDEOGRAPH
    {0xEDC4, 0xF929}, //7094 #CJK COMPATIBILITY IDEOGRAPH
    {0xEDC5, 0x6766}, //7095 #CJK UNIFIED IDEOGRAPH
    {0xEDC6, 0x67BB}, //7096 #CJK UNIFIED IDEOGRAPH
    {0xEDC7, 0x6852}, //7097 #CJK UNIFIED IDEOGRAPH
    {0xEDC8, 0x67C0}, //7098 #CJK UNIFIED IDEOGRAPH
    {0xEDC9, 0x6801}, //7099 #CJK UNIFIED IDEOGRAPH
    {0xEDCA, 0x6844}, //7100 #CJK UNIFIED IDEOGRAPH
    {0xEDCB, 0x68CF}, //7101 #CJK UNIFIED IDEOGRAPH
    {0xEDCC, 0xFA13}, //7102 #CJK COMPATIBILITY IDEOGRAPH
    {0xEDCD, 0x6968}, //7103 #CJK UNIFIED IDEOGRAPH
    {0xEDCE, 0xFA14}, //7104 #CJK COMPATIBILITY IDEOGRAPH
    {0xEDCF, 0x6998}, //7105 #CJK UNIFIED IDEOGRAPH
    {0xEDD0, 0x69E2}, //7106 #CJK UNIFIED IDEOGRAPH
    {0xEDD1, 0x6A30}, //7107 #CJK UNIFIED IDEOGRAPH
    {0xEDD2, 0x6A6B}, //7108 #CJK UNIFIED IDEOGRAPH
    {0xEDD3, 0x6A46}, //7109 #CJK UNIFIED IDEOGRAPH
    {0xEDD4, 0x6A73}, //7110 #CJK UNIFIED IDEOGRAPH
    {0xEDD5, 0x6A7E}, //7111 #CJK UNIFIED IDEOGRAPH
    {0xEDD6, 0x6AE2}, //7112 #CJK UNIFIED IDEOGRAPH
    {0xEDD7, 0x6AE4}, //7113 #CJK UNIFIED IDEOGRAPH
    {0xEDD8, 0x6BD6}, //7114 #CJK UNIFIED IDEOGRAPH
    {0xEDD9, 0x6C3F}, //7115 #CJK UNIFIED IDEOGRAPH
    {0xEDDA, 0x6C5C}, //7116 #CJK UNIFIED IDEOGRAPH
    {0xEDDB, 0x6C86}, //7117 #CJK UNIFIED IDEOGRAPH
    {0xEDDC, 0x6C6F}, //7118 #CJK UNIFIED IDEOGRAPH
    {0xEDDD, 0x6CDA}, //7119 #CJK UNIFIED IDEOGRAPH
    {0xEDDE, 0x6D04}, //7120 #CJK UNIFIED IDEOGRAPH
    {0xEDDF, 0x6D87}, //7121 #CJK UNIFIED IDEOGRAPH
    {0xEDE0, 0x6D6F}, //7122 #CJK UNIFIED IDEOGRAPH
    {0xEDE1, 0x6D96}, //7123 #CJK UNIFIED IDEOGRAPH
    {0xEDE2, 0x6DAC}, //7124 #CJK UNIFIED IDEOGRAPH
    {0xEDE3, 0x6DCF}, //7125 #CJK UNIFIED IDEOGRAPH
    {0xEDE4, 0x6DF8}, //7126 #CJK UNIFIED IDEOGRAPH
    {0xEDE5, 0x6DF2}, //7127 #CJK UNIFIED IDEOGRAPH
    {0xEDE6, 0x6DFC}, //7128 #CJK UNIFIED IDEOGRAPH
    {0xEDE7, 0x6E39}, //7129 #CJK UNIFIED IDEOGRAPH
    {0xEDE8, 0x6E5C}, //7130 #CJK UNIFIED IDEOGRAPH
    {0xEDE9, 0x6E27}, //7131 #CJK UNIFIED IDEOGRAPH
    {0xEDEA, 0x6E3C}, //7132 #CJK UNIFIED IDEOGRAPH
    {0xEDEB, 0x6EBF}, //7133 #CJK UNIFIED IDEOGRAPH
    {0xEDEC, 0x6F88}, //7134 #CJK UNIFIED IDEOGRAPH
    {0xEDED, 0x6FB5}, //7135 #CJK UNIFIED IDEOGRAPH
    {0xEDEE, 0x6FF5}, //7136 #CJK UNIFIED IDEOGRAPH
    {0xEDEF, 0x7005}, //7137 #CJK UNIFIED IDEOGRAPH
    {0xEDF0, 0x7007}, //7138 #CJK UNIFIED IDEOGRAPH
    {0xEDF1, 0x7028}, //7139 #CJK UNIFIED IDEOGRAPH
    {0xEDF2, 0x7085}, //7140 #CJK UNIFIED IDEOGRAPH
    {0xEDF3, 0x70AB}, //7141 #CJK UNIFIED IDEOGRAPH
    {0xEDF4, 0x710F}, //7142 #CJK UNIFIED IDEOGRAPH
    {0xEDF5, 0x7104}, //7143 #CJK UNIFIED IDEOGRAPH
    {0xEDF6, 0x715C}, //7144 #CJK UNIFIED IDEOGRAPH
    {0xEDF7, 0x7146}, //7145 #CJK UNIFIED IDEOGRAPH
    {0xEDF8, 0x7147}, //7146 #CJK UNIFIED IDEOGRAPH
    {0xEDF9, 0xFA15}, //7147 #CJK COMPATIBILITY IDEOGRAPH
    {0xEDFA, 0x71C1}, //7148 #CJK UNIFIED IDEOGRAPH
    {0xEDFB, 0x71FE}, //7149 #CJK UNIFIED IDEOGRAPH
    {0xEDFC, 0x72B1}, //7150 #CJK UNIFIED IDEOGRAPH
    {0xEE40, 0x72BE}, //7151 #CJK UNIFIED IDEOGRAPH
    {0xEE41, 0x7324}, //7152 #CJK UNIFIED IDEOGRAPH
    {0xEE42, 0xFA16}, //7153 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE43, 0x7377}, //7154 #CJK UNIFIED IDEOGRAPH
    {0xEE44, 0x73BD}, //7155 #CJK UNIFIED IDEOGRAPH
    {0xEE45, 0x73C9}, //7156 #CJK UNIFIED IDEOGRAPH
    {0xEE46, 0x73D6}, //7157 #CJK UNIFIED IDEOGRAPH
    {0xEE47, 0x73E3}, //7158 #CJK UNIFIED IDEOGRAPH
    {0xEE48, 0x73D2}, //7159 #CJK UNIFIED IDEOGRAPH
    {0xEE49, 0x7407}, //7160 #CJK UNIFIED IDEOGRAPH
    {0xEE4A, 0x73F5}, //7161 #CJK UNIFIED IDEOGRAPH
    {0xEE4B, 0x7426}, //7162 #CJK UNIFIED IDEOGRAPH
    {0xEE4C, 0x742A}, //7163 #CJK UNIFIED IDEOGRAPH
    {0xEE4D, 0x7429}, //7164 #CJK UNIFIED IDEOGRAPH
    {0xEE4E, 0x742E}, //7165 #CJK UNIFIED IDEOGRAPH
    {0xEE4F, 0x7462}, //7166 #CJK UNIFIED IDEOGRAPH
    {0xEE50, 0x7489}, //7167 #CJK UNIFIED IDEOGRAPH
    {0xEE51, 0x749F}, //7168 #CJK UNIFIED IDEOGRAPH
    {0xEE52, 0x7501}, //7169 #CJK UNIFIED IDEOGRAPH
    {0xEE53, 0x756F}, //7170 #CJK UNIFIED IDEOGRAPH
    {0xEE54, 0x7682}, //7171 #CJK UNIFIED IDEOGRAPH
    {0xEE55, 0x769C}, //7172 #CJK UNIFIED IDEOGRAPH
    {0xEE56, 0x769E}, //7173 #CJK UNIFIED IDEOGRAPH
    {0xEE57, 0x769B}, //7174 #CJK UNIFIED IDEOGRAPH
    {0xEE58, 0x76A6}, //7175 #CJK UNIFIED IDEOGRAPH
    {0xEE59, 0xFA17}, //7176 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE5A, 0x7746}, //7177 #CJK UNIFIED IDEOGRAPH
    {0xEE5B, 0x52AF}, //7178 #CJK UNIFIED IDEOGRAPH
    {0xEE5C, 0x7821}, //7179 #CJK UNIFIED IDEOGRAPH
    {0xEE5D, 0x784E}, //7180 #CJK UNIFIED IDEOGRAPH
    {0xEE5E, 0x7864}, //7181 #CJK UNIFIED IDEOGRAPH
    {0xEE5F, 0x787A}, //7182 #CJK UNIFIED IDEOGRAPH
    {0xEE60, 0x7930}, //7183 #CJK UNIFIED IDEOGRAPH
    {0xEE61, 0xFA18}, //7184 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE62, 0xFA19}, //7185 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE63, 0xFA1A}, //7186 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE64, 0x7994}, //7187 #CJK UNIFIED IDEOGRAPH
    {0xEE65, 0xFA1B}, //7188 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE66, 0x799B}, //7189 #CJK UNIFIED IDEOGRAPH
    {0xEE67, 0x7AD1}, //7190 #CJK UNIFIED IDEOGRAPH
    {0xEE68, 0x7AE7}, //7191 #CJK UNIFIED IDEOGRAPH
    {0xEE69, 0xFA1C}, //7192 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE6A, 0x7AEB}, //7193 #CJK UNIFIED IDEOGRAPH
    {0xEE6B, 0x7B9E}, //7194 #CJK UNIFIED IDEOGRAPH
    {0xEE6C, 0xFA1D}, //7195 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE6D, 0x7D48}, //7196 #CJK UNIFIED IDEOGRAPH
    {0xEE6E, 0x7D5C}, //7197 #CJK UNIFIED IDEOGRAPH
    {0xEE6F, 0x7DB7}, //7198 #CJK UNIFIED IDEOGRAPH
    {0xEE70, 0x7DA0}, //7199 #CJK UNIFIED IDEOGRAPH
    {0xEE71, 0x7DD6}, //7200 #CJK UNIFIED IDEOGRAPH
    {0xEE72, 0x7E52}, //7201 #CJK UNIFIED IDEOGRAPH
    {0xEE73, 0x7F47}, //7202 #CJK UNIFIED IDEOGRAPH
    {0xEE74, 0x7FA1}, //7203 #CJK UNIFIED IDEOGRAPH
    {0xEE75, 0xFA1E}, //7204 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE76, 0x8301}, //7205 #CJK UNIFIED IDEOGRAPH
    {0xEE77, 0x8362}, //7206 #CJK UNIFIED IDEOGRAPH
    {0xEE78, 0x837F}, //7207 #CJK UNIFIED IDEOGRAPH
    {0xEE79, 0x83C7}, //7208 #CJK UNIFIED IDEOGRAPH
    {0xEE7A, 0x83F6}, //7209 #CJK UNIFIED IDEOGRAPH
    {0xEE7B, 0x8448}, //7210 #CJK UNIFIED IDEOGRAPH
    {0xEE7C, 0x84B4}, //7211 #CJK UNIFIED IDEOGRAPH
    {0xEE7D, 0x8553}, //7212 #CJK UNIFIED IDEOGRAPH
    {0xEE7E, 0x8559}, //7213 #CJK UNIFIED IDEOGRAPH
    {0xEE80, 0x856B}, //7214 #CJK UNIFIED IDEOGRAPH
    {0xEE81, 0xFA1F}, //7215 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE82, 0x85B0}, //7216 #CJK UNIFIED IDEOGRAPH
    {0xEE83, 0xFA20}, //7217 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE84, 0xFA21}, //7218 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE85, 0x8807}, //7219 #CJK UNIFIED IDEOGRAPH
    {0xEE86, 0x88F5}, //7220 #CJK UNIFIED IDEOGRAPH
    {0xEE87, 0x8A12}, //7221 #CJK UNIFIED IDEOGRAPH
    {0xEE88, 0x8A37}, //7222 #CJK UNIFIED IDEOGRAPH
    {0xEE89, 0x8A79}, //7223 #CJK UNIFIED IDEOGRAPH
    {0xEE8A, 0x8AA7}, //7224 #CJK UNIFIED IDEOGRAPH
    {0xEE8B, 0x8ABE}, //7225 #CJK UNIFIED IDEOGRAPH
    {0xEE8C, 0x8ADF}, //7226 #CJK UNIFIED IDEOGRAPH
    {0xEE8D, 0xFA22}, //7227 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE8E, 0x8AF6}, //7228 #CJK UNIFIED IDEOGRAPH
    {0xEE8F, 0x8B53}, //7229 #CJK UNIFIED IDEOGRAPH
    {0xEE90, 0x8B7F}, //7230 #CJK UNIFIED IDEOGRAPH
    {0xEE91, 0x8CF0}, //7231 #CJK UNIFIED IDEOGRAPH
    {0xEE92, 0x8CF4}, //7232 #CJK UNIFIED IDEOGRAPH
    {0xEE93, 0x8D12}, //7233 #CJK UNIFIED IDEOGRAPH
    {0xEE94, 0x8D76}, //7234 #CJK UNIFIED IDEOGRAPH
    {0xEE95, 0xFA23}, //7235 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE96, 0x8ECF}, //7236 #CJK UNIFIED IDEOGRAPH
    {0xEE97, 0xFA24}, //7237 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE98, 0xFA25}, //7238 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE99, 0x9067}, //7239 #CJK UNIFIED IDEOGRAPH
    {0xEE9A, 0x90DE}, //7240 #CJK UNIFIED IDEOGRAPH
    {0xEE9B, 0xFA26}, //7241 #CJK COMPATIBILITY IDEOGRAPH
    {0xEE9C, 0x9115}, //7242 #CJK UNIFIED IDEOGRAPH
    {0xEE9D, 0x9127}, //7243 #CJK UNIFIED IDEOGRAPH
    {0xEE9E, 0x91DA}, //7244 #CJK UNIFIED IDEOGRAPH
    {0xEE9F, 0x91D7}, //7245 #CJK UNIFIED IDEOGRAPH
    {0xEEA0, 0x91DE}, //7246 #CJK UNIFIED IDEOGRAPH
    {0xEEA1, 0x91ED}, //7247 #CJK UNIFIED IDEOGRAPH
    {0xEEA2, 0x91EE}, //7248 #CJK UNIFIED IDEOGRAPH
    {0xEEA3, 0x91E4}, //7249 #CJK UNIFIED IDEOGRAPH
    {0xEEA4, 0x91E5}, //7250 #CJK UNIFIED IDEOGRAPH
    {0xEEA5, 0x9206}, //7251 #CJK UNIFIED IDEOGRAPH
    {0xEEA6, 0x9210}, //7252 #CJK UNIFIED IDEOGRAPH
    {0xEEA7, 0x920A}, //7253 #CJK UNIFIED IDEOGRAPH
    {0xEEA8, 0x923A}, //7254 #CJK UNIFIED IDEOGRAPH
    {0xEEA9, 0x9240}, //7255 #CJK UNIFIED IDEOGRAPH
    {0xEEAA, 0x923C}, //7256 #CJK UNIFIED IDEOGRAPH
    {0xEEAB, 0x924E}, //7257 #CJK UNIFIED IDEOGRAPH
    {0xEEAC, 0x9259}, //7258 #CJK UNIFIED IDEOGRAPH
    {0xEEAD, 0x9251}, //7259 #CJK UNIFIED IDEOGRAPH
    {0xEEAE, 0x9239}, //7260 #CJK UNIFIED IDEOGRAPH
    {0xEEAF, 0x9267}, //7261 #CJK UNIFIED IDEOGRAPH
    {0xEEB0, 0x92A7}, //7262 #CJK UNIFIED IDEOGRAPH
    {0xEEB1, 0x9277}, //7263 #CJK UNIFIED IDEOGRAPH
    {0xEEB2, 0x9278}, //7264 #CJK UNIFIED IDEOGRAPH
    {0xEEB3, 0x92E7}, //7265 #CJK UNIFIED IDEOGRAPH
    {0xEEB4, 0x92D7}, //7266 #CJK UNIFIED IDEOGRAPH
    {0xEEB5, 0x92D9}, //7267 #CJK UNIFIED IDEOGRAPH
    {0xEEB6, 0x92D0}, //7268 #CJK UNIFIED IDEOGRAPH
    {0xEEB7, 0xFA27}, //7269 #CJK COMPATIBILITY IDEOGRAPH
    {0xEEB8, 0x92D5}, //7270 #CJK UNIFIED IDEOGRAPH
    {0xEEB9, 0x92E0}, //7271 #CJK UNIFIED IDEOGRAPH
    {0xEEBA, 0x92D3}, //7272 #CJK UNIFIED IDEOGRAPH
    {0xEEBB, 0x9325}, //7273 #CJK UNIFIED IDEOGRAPH
    {0xEEBC, 0x9321}, //7274 #CJK UNIFIED IDEOGRAPH
    {0xEEBD, 0x92FB}, //7275 #CJK UNIFIED IDEOGRAPH
    {0xEEBE, 0xFA28}, //7276 #CJK COMPATIBILITY IDEOGRAPH
    {0xEEBF, 0x931E}, //7277 #CJK UNIFIED IDEOGRAPH
    {0xEEC0, 0x92FF}, //7278 #CJK UNIFIED IDEOGRAPH
    {0xEEC1, 0x931D}, //7279 #CJK UNIFIED IDEOGRAPH
    {0xEEC2, 0x9302}, //7280 #CJK UNIFIED IDEOGRAPH
    {0xEEC3, 0x9370}, //7281 #CJK UNIFIED IDEOGRAPH
    {0xEEC4, 0x9357}, //7282 #CJK UNIFIED IDEOGRAPH
    {0xEEC5, 0x93A4}, //7283 #CJK UNIFIED IDEOGRAPH
    {0xEEC6, 0x93C6}, //7284 #CJK UNIFIED IDEOGRAPH
    {0xEEC7, 0x93DE}, //7285 #CJK UNIFIED IDEOGRAPH
    {0xEEC8, 0x93F8}, //7286 #CJK UNIFIED IDEOGRAPH
    {0xEEC9, 0x9431}, //7287 #CJK UNIFIED IDEOGRAPH
    {0xEECA, 0x9445}, //7288 #CJK UNIFIED IDEOGRAPH
    {0xEECB, 0x9448}, //7289 #CJK UNIFIED IDEOGRAPH
    {0xEECC, 0x9592}, //7290 #CJK UNIFIED IDEOGRAPH
    {0xEECD, 0xF9DC}, //7291 #CJK COMPATIBILITY IDEOGRAPH
    {0xEECE, 0xFA29}, //7292 #CJK COMPATIBILITY IDEOGRAPH
    {0xEECF, 0x969D}, //7293 #CJK UNIFIED IDEOGRAPH
    {0xEED0, 0x96AF}, //7294 #CJK UNIFIED IDEOGRAPH
    {0xEED1, 0x9733}, //7295 #CJK UNIFIED IDEOGRAPH
    {0xEED2, 0x973B}, //7296 #CJK UNIFIED IDEOGRAPH
    {0xEED3, 0x9743}, //7297 #CJK UNIFIED IDEOGRAPH
    {0xEED4, 0x974D}, //7298 #CJK UNIFIED IDEOGRAPH
    {0xEED5, 0x974F}, //7299 #CJK UNIFIED IDEOGRAPH
    {0xEED6, 0x9751}, //7300 #CJK UNIFIED IDEOGRAPH
    {0xEED7, 0x9755}, //7301 #CJK UNIFIED IDEOGRAPH
    {0xEED8, 0x9857}, //7302 #CJK UNIFIED IDEOGRAPH
    {0xEED9, 0x9865}, //7303 #CJK UNIFIED IDEOGRAPH
    {0xEEDA, 0xFA2A}, //7304 #CJK COMPATIBILITY IDEOGRAPH
    {0xEEDB, 0xFA2B}, //7305 #CJK COMPATIBILITY IDEOGRAPH
    {0xEEDC, 0x9927}, //7306 #CJK UNIFIED IDEOGRAPH
    {0xEEDD, 0xFA2C}, //7307 #CJK COMPATIBILITY IDEOGRAPH
    {0xEEDE, 0x999E}, //7308 #CJK UNIFIED IDEOGRAPH
    {0xEEDF, 0x9A4E}, //7309 #CJK UNIFIED IDEOGRAPH
    {0xEEE0, 0x9AD9}, //7310 #CJK UNIFIED IDEOGRAPH
    {0xEEE1, 0x9ADC}, //7311 #CJK UNIFIED IDEOGRAPH
    {0xEEE2, 0x9B75}, //7312 #CJK UNIFIED IDEOGRAPH
    {0xEEE3, 0x9B72}, //7313 #CJK UNIFIED IDEOGRAPH
    {0xEEE4, 0x9B8F}, //7314 #CJK UNIFIED IDEOGRAPH
    {0xEEE5, 0x9BB1}, //7315 #CJK UNIFIED IDEOGRAPH
    {0xEEE6, 0x9BBB}, //7316 #CJK UNIFIED IDEOGRAPH
    {0xEEE7, 0x9C00}, //7317 #CJK UNIFIED IDEOGRAPH
    {0xEEE8, 0x9D70}, //7318 #CJK UNIFIED IDEOGRAPH
    {0xEEE9, 0x9D6B}, //7319 #CJK UNIFIED IDEOGRAPH
    {0xEEEA, 0xFA2D}, //7320 #CJK COMPATIBILITY IDEOGRAPH
    {0xEEEB, 0x9E19}, //7321 #CJK UNIFIED IDEOGRAPH
    {0xEEEC, 0x9ED1}, //7322 #CJK UNIFIED IDEOGRAPH
    {0xEEEF, 0x2170}, //7323 #SMALL ROMAN NUMERAL ONE
    {0xEEF0, 0x2171}, //7324 #SMALL ROMAN NUMERAL TWO
    {0xEEF1, 0x2172}, //7325 #SMALL ROMAN NUMERAL THREE
    {0xEEF2, 0x2173}, //7326 #SMALL ROMAN NUMERAL FOUR
    {0xEEF3, 0x2174}, //7327 #SMALL ROMAN NUMERAL FIVE
    {0xEEF4, 0x2175}, //7328 #SMALL ROMAN NUMERAL SIX
    {0xEEF5, 0x2176}, //7329 #SMALL ROMAN NUMERAL SEVEN
    {0xEEF6, 0x2177}, //7330 #SMALL ROMAN NUMERAL EIGHT
    {0xEEF7, 0x2178}, //7331 #SMALL ROMAN NUMERAL NINE
    {0xEEF8, 0x2179}, //7332 #SMALL ROMAN NUMERAL TEN
    {0xEEF9, 0xFFE2}, //7333 #FULLWIDTH NOT SIGN
    {0xEEFA, 0xFFE4}, //7334 #FULLWIDTH BROKEN BAR
    {0xEEFB, 0xFF07}, //7335 #FULLWIDTH APOSTROPHE
    {0xEEFC, 0xFF02}, //7336 #FULLWIDTH QUOTATION MARK
    {0xFA40, 0x2170}, //7337 #SMALL ROMAN NUMERAL ONE
    {0xFA41, 0x2171}, //7338 #SMALL ROMAN NUMERAL TWO
    {0xFA42, 0x2172}, //7339 #SMALL ROMAN NUMERAL THREE
    {0xFA43, 0x2173}, //7340 #SMALL ROMAN NUMERAL FOUR
    {0xFA44, 0x2174}, //7341 #SMALL ROMAN NUMERAL FIVE
    {0xFA45, 0x2175}, //7342 #SMALL ROMAN NUMERAL SIX
    {0xFA46, 0x2176}, //7343 #SMALL ROMAN NUMERAL SEVEN
    {0xFA47, 0x2177}, //7344 #SMALL ROMAN NUMERAL EIGHT
    {0xFA48, 0x2178}, //7345 #SMALL ROMAN NUMERAL NINE
    {0xFA49, 0x2179}, //7346 #SMALL ROMAN NUMERAL TEN
    {0xFA4A, 0x2160}, //7347 #ROMAN NUMERAL ONE
    {0xFA4B, 0x2161}, //7348 #ROMAN NUMERAL TWO
    {0xFA4C, 0x2162}, //7349 #ROMAN NUMERAL THREE
    {0xFA4D, 0x2163}, //7350 #ROMAN NUMERAL FOUR
    {0xFA4E, 0x2164}, //7351 #ROMAN NUMERAL FIVE
    {0xFA4F, 0x2165}, //7352 #ROMAN NUMERAL SIX
    {0xFA50, 0x2166}, //7353 #ROMAN NUMERAL SEVEN
    {0xFA51, 0x2167}, //7354 #ROMAN NUMERAL EIGHT
    {0xFA52, 0x2168}, //7355 #ROMAN NUMERAL NINE
    {0xFA53, 0x2169}, //7356 #ROMAN NUMERAL TEN
    {0xFA54, 0xFFE2}, //7357 #FULLWIDTH NOT SIGN
    {0xFA55, 0xFFE4}, //7358 #FULLWIDTH BROKEN BAR
    {0xFA56, 0xFF07}, //7359 #FULLWIDTH APOSTROPHE
    {0xFA57, 0xFF02}, //7360 #FULLWIDTH QUOTATION MARK
    {0xFA58, 0x3231}, //7361 #PARENTHESIZED IDEOGRAPH STOCK
    {0xFA59, 0x2116}, //7362 #NUMERO SIGN
    {0xFA5A, 0x2121}, //7363 #TELEPHONE SIGN
    {0xFA5B, 0x2235}, //7364 #BECAUSE
    {0xFA5C, 0x7E8A}, //7365 #CJK UNIFIED IDEOGRAPH
    {0xFA5D, 0x891C}, //7366 #CJK UNIFIED IDEOGRAPH
    {0xFA5E, 0x9348}, //7367 #CJK UNIFIED IDEOGRAPH
    {0xFA5F, 0x9288}, //7368 #CJK UNIFIED IDEOGRAPH
    {0xFA60, 0x84DC}, //7369 #CJK UNIFIED IDEOGRAPH
    {0xFA61, 0x4FC9}, //7370 #CJK UNIFIED IDEOGRAPH
    {0xFA62, 0x70BB}, //7371 #CJK UNIFIED IDEOGRAPH
    {0xFA63, 0x6631}, //7372 #CJK UNIFIED IDEOGRAPH
    {0xFA64, 0x68C8}, //7373 #CJK UNIFIED IDEOGRAPH
    {0xFA65, 0x92F9}, //7374 #CJK UNIFIED IDEOGRAPH
    {0xFA66, 0x66FB}, //7375 #CJK UNIFIED IDEOGRAPH
    {0xFA67, 0x5F45}, //7376 #CJK UNIFIED IDEOGRAPH
    {0xFA68, 0x4E28}, //7377 #CJK UNIFIED IDEOGRAPH
    {0xFA69, 0x4EE1}, //7378 #CJK UNIFIED IDEOGRAPH
    {0xFA6A, 0x4EFC}, //7379 #CJK UNIFIED IDEOGRAPH
    {0xFA6B, 0x4F00}, //7380 #CJK UNIFIED IDEOGRAPH
    {0xFA6C, 0x4F03}, //7381 #CJK UNIFIED IDEOGRAPH
    {0xFA6D, 0x4F39}, //7382 #CJK UNIFIED IDEOGRAPH
    {0xFA6E, 0x4F56}, //7383 #CJK UNIFIED IDEOGRAPH
    {0xFA6F, 0x4F92}, //7384 #CJK UNIFIED IDEOGRAPH
    {0xFA70, 0x4F8A}, //7385 #CJK UNIFIED IDEOGRAPH
    {0xFA71, 0x4F9A}, //7386 #CJK UNIFIED IDEOGRAPH
    {0xFA72, 0x4F94}, //7387 #CJK UNIFIED IDEOGRAPH
    {0xFA73, 0x4FCD}, //7388 #CJK UNIFIED IDEOGRAPH
    {0xFA74, 0x5040}, //7389 #CJK UNIFIED IDEOGRAPH
    {0xFA75, 0x5022}, //7390 #CJK UNIFIED IDEOGRAPH
    {0xFA76, 0x4FFF}, //7391 #CJK UNIFIED IDEOGRAPH
    {0xFA77, 0x501E}, //7392 #CJK UNIFIED IDEOGRAPH
    {0xFA78, 0x5046}, //7393 #CJK UNIFIED IDEOGRAPH
    {0xFA79, 0x5070}, //7394 #CJK UNIFIED IDEOGRAPH
    {0xFA7A, 0x5042}, //7395 #CJK UNIFIED IDEOGRAPH
    {0xFA7B, 0x5094}, //7396 #CJK UNIFIED IDEOGRAPH
    {0xFA7C, 0x50F4}, //7397 #CJK UNIFIED IDEOGRAPH
    {0xFA7D, 0x50D8}, //7398 #CJK UNIFIED IDEOGRAPH
    {0xFA7E, 0x514A}, //7399 #CJK UNIFIED IDEOGRAPH
    {0xFA80, 0x5164}, //7400 #CJK UNIFIED IDEOGRAPH
    {0xFA81, 0x519D}, //7401 #CJK UNIFIED IDEOGRAPH
    {0xFA82, 0x51BE}, //7402 #CJK UNIFIED IDEOGRAPH
    {0xFA83, 0x51EC}, //7403 #CJK UNIFIED IDEOGRAPH
    {0xFA84, 0x5215}, //7404 #CJK UNIFIED IDEOGRAPH
    {0xFA85, 0x529C}, //7405 #CJK UNIFIED IDEOGRAPH
    {0xFA86, 0x52A6}, //7406 #CJK UNIFIED IDEOGRAPH
    {0xFA87, 0x52C0}, //7407 #CJK UNIFIED IDEOGRAPH
    {0xFA88, 0x52DB}, //7408 #CJK UNIFIED IDEOGRAPH
    {0xFA89, 0x5300}, //7409 #CJK UNIFIED IDEOGRAPH
    {0xFA8A, 0x5307}, //7410 #CJK UNIFIED IDEOGRAPH
    {0xFA8B, 0x5324}, //7411 #CJK UNIFIED IDEOGRAPH
    {0xFA8C, 0x5372}, //7412 #CJK UNIFIED IDEOGRAPH
    {0xFA8D, 0x5393}, //7413 #CJK UNIFIED IDEOGRAPH
    {0xFA8E, 0x53B2}, //7414 #CJK UNIFIED IDEOGRAPH
    {0xFA8F, 0x53DD}, //7415 #CJK UNIFIED IDEOGRAPH
    {0xFA90, 0xFA0E}, //7416 #CJK COMPATIBILITY IDEOGRAPH
    {0xFA91, 0x549C}, //7417 #CJK UNIFIED IDEOGRAPH
    {0xFA92, 0x548A}, //7418 #CJK UNIFIED IDEOGRAPH
    {0xFA93, 0x54A9}, //7419 #CJK UNIFIED IDEOGRAPH
    {0xFA94, 0x54FF}, //7420 #CJK UNIFIED IDEOGRAPH
    {0xFA95, 0x5586}, //7421 #CJK UNIFIED IDEOGRAPH
    {0xFA96, 0x5759}, //7422 #CJK UNIFIED IDEOGRAPH
    {0xFA97, 0x5765}, //7423 #CJK UNIFIED IDEOGRAPH
    {0xFA98, 0x57AC}, //7424 #CJK UNIFIED IDEOGRAPH
    {0xFA99, 0x57C8}, //7425 #CJK UNIFIED IDEOGRAPH
    {0xFA9A, 0x57C7}, //7426 #CJK UNIFIED IDEOGRAPH
    {0xFA9B, 0xFA0F}, //7427 #CJK COMPATIBILITY IDEOGRAPH
    {0xFA9C, 0xFA10}, //7428 #CJK COMPATIBILITY IDEOGRAPH
    {0xFA9D, 0x589E}, //7429 #CJK UNIFIED IDEOGRAPH
    {0xFA9E, 0x58B2}, //7430 #CJK UNIFIED IDEOGRAPH
    {0xFA9F, 0x590B}, //7431 #CJK UNIFIED IDEOGRAPH
    {0xFAA0, 0x5953}, //7432 #CJK UNIFIED IDEOGRAPH
    {0xFAA1, 0x595B}, //7433 #CJK UNIFIED IDEOGRAPH
    {0xFAA2, 0x595D}, //7434 #CJK UNIFIED IDEOGRAPH
    {0xFAA3, 0x5963}, //7435 #CJK UNIFIED IDEOGRAPH
    {0xFAA4, 0x59A4}, //7436 #CJK UNIFIED IDEOGRAPH
    {0xFAA5, 0x59BA}, //7437 #CJK UNIFIED IDEOGRAPH
    {0xFAA6, 0x5B56}, //7438 #CJK UNIFIED IDEOGRAPH
    {0xFAA7, 0x5BC0}, //7439 #CJK UNIFIED IDEOGRAPH
    {0xFAA8, 0x752F}, //7440 #CJK UNIFIED IDEOGRAPH
    {0xFAA9, 0x5BD8}, //7441 #CJK UNIFIED IDEOGRAPH
    {0xFAAA, 0x5BEC}, //7442 #CJK UNIFIED IDEOGRAPH
    {0xFAAB, 0x5C1E}, //7443 #CJK UNIFIED IDEOGRAPH
    {0xFAAC, 0x5CA6}, //7444 #CJK UNIFIED IDEOGRAPH
    {0xFAAD, 0x5CBA}, //7445 #CJK UNIFIED IDEOGRAPH
    {0xFAAE, 0x5CF5}, //7446 #CJK UNIFIED IDEOGRAPH
    {0xFAAF, 0x5D27}, //7447 #CJK UNIFIED IDEOGRAPH
    {0xFAB0, 0x5D53}, //7448 #CJK UNIFIED IDEOGRAPH
    {0xFAB1, 0xFA11}, //7449 #CJK COMPATIBILITY IDEOGRAPH
    {0xFAB2, 0x5D42}, //7450 #CJK UNIFIED IDEOGRAPH
    {0xFAB3, 0x5D6D}, //7451 #CJK UNIFIED IDEOGRAPH
    {0xFAB4, 0x5DB8}, //7452 #CJK UNIFIED IDEOGRAPH
    {0xFAB5, 0x5DB9}, //7453 #CJK UNIFIED IDEOGRAPH
    {0xFAB6, 0x5DD0}, //7454 #CJK UNIFIED IDEOGRAPH
    {0xFAB7, 0x5F21}, //7455 #CJK UNIFIED IDEOGRAPH
    {0xFAB8, 0x5F34}, //7456 #CJK UNIFIED IDEOGRAPH
    {0xFAB9, 0x5F67}, //7457 #CJK UNIFIED IDEOGRAPH
    {0xFABA, 0x5FB7}, //7458 #CJK UNIFIED IDEOGRAPH
    {0xFABB, 0x5FDE}, //7459 #CJK UNIFIED IDEOGRAPH
    {0xFABC, 0x605D}, //7460 #CJK UNIFIED IDEOGRAPH
    {0xFABD, 0x6085}, //7461 #CJK UNIFIED IDEOGRAPH
    {0xFABE, 0x608A}, //7462 #CJK UNIFIED IDEOGRAPH
    {0xFABF, 0x60DE}, //7463 #CJK UNIFIED IDEOGRAPH
    {0xFAC0, 0x60D5}, //7464 #CJK UNIFIED IDEOGRAPH
    {0xFAC1, 0x6120}, //7465 #CJK UNIFIED IDEOGRAPH
    {0xFAC2, 0x60F2}, //7466 #CJK UNIFIED IDEOGRAPH
    {0xFAC3, 0x6111}, //7467 #CJK UNIFIED IDEOGRAPH
    {0xFAC4, 0x6137}, //7468 #CJK UNIFIED IDEOGRAPH
    {0xFAC5, 0x6130}, //7469 #CJK UNIFIED IDEOGRAPH
    {0xFAC6, 0x6198}, //7470 #CJK UNIFIED IDEOGRAPH
    {0xFAC7, 0x6213}, //7471 #CJK UNIFIED IDEOGRAPH
    {0xFAC8, 0x62A6}, //7472 #CJK UNIFIED IDEOGRAPH
    {0xFAC9, 0x63F5}, //7473 #CJK UNIFIED IDEOGRAPH
    {0xFACA, 0x6460}, //7474 #CJK UNIFIED IDEOGRAPH
    {0xFACB, 0x649D}, //7475 #CJK UNIFIED IDEOGRAPH
    {0xFACC, 0x64CE}, //7476 #CJK UNIFIED IDEOGRAPH
    {0xFACD, 0x654E}, //7477 #CJK UNIFIED IDEOGRAPH
    {0xFACE, 0x6600}, //7478 #CJK UNIFIED IDEOGRAPH
    {0xFACF, 0x6615}, //7479 #CJK UNIFIED IDEOGRAPH
    {0xFAD0, 0x663B}, //7480 #CJK UNIFIED IDEOGRAPH
    {0xFAD1, 0x6609}, //7481 #CJK UNIFIED IDEOGRAPH
    {0xFAD2, 0x662E}, //7482 #CJK UNIFIED IDEOGRAPH
    {0xFAD3, 0x661E}, //7483 #CJK UNIFIED IDEOGRAPH
    {0xFAD4, 0x6624}, //7484 #CJK UNIFIED IDEOGRAPH
    {0xFAD5, 0x6665}, //7485 #CJK UNIFIED IDEOGRAPH
    {0xFAD6, 0x6657}, //7486 #CJK UNIFIED IDEOGRAPH
    {0xFAD7, 0x6659}, //7487 #CJK UNIFIED IDEOGRAPH
    {0xFAD8, 0xFA12}, //7488 #CJK COMPATIBILITY IDEOGRAPH
    {0xFAD9, 0x6673}, //7489 #CJK UNIFIED IDEOGRAPH
    {0xFADA, 0x6699}, //7490 #CJK UNIFIED IDEOGRAPH
    {0xFADB, 0x66A0}, //7491 #CJK UNIFIED IDEOGRAPH
    {0xFADC, 0x66B2}, //7492 #CJK UNIFIED IDEOGRAPH
    {0xFADD, 0x66BF}, //7493 #CJK UNIFIED IDEOGRAPH
    {0xFADE, 0x66FA}, //7494 #CJK UNIFIED IDEOGRAPH
    {0xFADF, 0x670E}, //7495 #CJK UNIFIED IDEOGRAPH
    {0xFAE0, 0xF929}, //7496 #CJK COMPATIBILITY IDEOGRAPH
    {0xFAE1, 0x6766}, //7497 #CJK UNIFIED IDEOGRAPH
    {0xFAE2, 0x67BB}, //7498 #CJK UNIFIED IDEOGRAPH
    {0xFAE3, 0x6852}, //7499 #CJK UNIFIED IDEOGRAPH
    {0xFAE4, 0x67C0}, //7500 #CJK UNIFIED IDEOGRAPH
    {0xFAE5, 0x6801}, //7501 #CJK UNIFIED IDEOGRAPH
    {0xFAE6, 0x6844}, //7502 #CJK UNIFIED IDEOGRAPH
    {0xFAE7, 0x68CF}, //7503 #CJK UNIFIED IDEOGRAPH
    {0xFAE8, 0xFA13}, //7504 #CJK COMPATIBILITY IDEOGRAPH
    {0xFAE9, 0x6968}, //7505 #CJK UNIFIED IDEOGRAPH
    {0xFAEA, 0xFA14}, //7506 #CJK COMPATIBILITY IDEOGRAPH
    {0xFAEB, 0x6998}, //7507 #CJK UNIFIED IDEOGRAPH
    {0xFAEC, 0x69E2}, //7508 #CJK UNIFIED IDEOGRAPH
    {0xFAED, 0x6A30}, //7509 #CJK UNIFIED IDEOGRAPH
    {0xFAEE, 0x6A6B}, //7510 #CJK UNIFIED IDEOGRAPH
    {0xFAEF, 0x6A46}, //7511 #CJK UNIFIED IDEOGRAPH
    {0xFAF0, 0x6A73}, //7512 #CJK UNIFIED IDEOGRAPH
    {0xFAF1, 0x6A7E}, //7513 #CJK UNIFIED IDEOGRAPH
    {0xFAF2, 0x6AE2}, //7514 #CJK UNIFIED IDEOGRAPH
    {0xFAF3, 0x6AE4}, //7515 #CJK UNIFIED IDEOGRAPH
    {0xFAF4, 0x6BD6}, //7516 #CJK UNIFIED IDEOGRAPH
    {0xFAF5, 0x6C3F}, //7517 #CJK UNIFIED IDEOGRAPH
    {0xFAF6, 0x6C5C}, //7518 #CJK UNIFIED IDEOGRAPH
    {0xFAF7, 0x6C86}, //7519 #CJK UNIFIED IDEOGRAPH
    {0xFAF8, 0x6C6F}, //7520 #CJK UNIFIED IDEOGRAPH
    {0xFAF9, 0x6CDA}, //7521 #CJK UNIFIED IDEOGRAPH
    {0xFAFA, 0x6D04}, //7522 #CJK UNIFIED IDEOGRAPH
    {0xFAFB, 0x6D87}, //7523 #CJK UNIFIED IDEOGRAPH
    {0xFAFC, 0x6D6F}, //7524 #CJK UNIFIED IDEOGRAPH
    {0xFB40, 0x6D96}, //7525 #CJK UNIFIED IDEOGRAPH
    {0xFB41, 0x6DAC}, //7526 #CJK UNIFIED IDEOGRAPH
    {0xFB42, 0x6DCF}, //7527 #CJK UNIFIED IDEOGRAPH
    {0xFB43, 0x6DF8}, //7528 #CJK UNIFIED IDEOGRAPH
    {0xFB44, 0x6DF2}, //7529 #CJK UNIFIED IDEOGRAPH
    {0xFB45, 0x6DFC}, //7530 #CJK UNIFIED IDEOGRAPH
    {0xFB46, 0x6E39}, //7531 #CJK UNIFIED IDEOGRAPH
    {0xFB47, 0x6E5C}, //7532 #CJK UNIFIED IDEOGRAPH
    {0xFB48, 0x6E27}, //7533 #CJK UNIFIED IDEOGRAPH
    {0xFB49, 0x6E3C}, //7534 #CJK UNIFIED IDEOGRAPH
    {0xFB4A, 0x6EBF}, //7535 #CJK UNIFIED IDEOGRAPH
    {0xFB4B, 0x6F88}, //7536 #CJK UNIFIED IDEOGRAPH
    {0xFB4C, 0x6FB5}, //7537 #CJK UNIFIED IDEOGRAPH
    {0xFB4D, 0x6FF5}, //7538 #CJK UNIFIED IDEOGRAPH
    {0xFB4E, 0x7005}, //7539 #CJK UNIFIED IDEOGRAPH
    {0xFB4F, 0x7007}, //7540 #CJK UNIFIED IDEOGRAPH
    {0xFB50, 0x7028}, //7541 #CJK UNIFIED IDEOGRAPH
    {0xFB51, 0x7085}, //7542 #CJK UNIFIED IDEOGRAPH
    {0xFB52, 0x70AB}, //7543 #CJK UNIFIED IDEOGRAPH
    {0xFB53, 0x710F}, //7544 #CJK UNIFIED IDEOGRAPH
    {0xFB54, 0x7104}, //7545 #CJK UNIFIED IDEOGRAPH
    {0xFB55, 0x715C}, //7546 #CJK UNIFIED IDEOGRAPH
    {0xFB56, 0x7146}, //7547 #CJK UNIFIED IDEOGRAPH
    {0xFB57, 0x7147}, //7548 #CJK UNIFIED IDEOGRAPH
    {0xFB58, 0xFA15}, //7549 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB59, 0x71C1}, //7550 #CJK UNIFIED IDEOGRAPH
    {0xFB5A, 0x71FE}, //7551 #CJK UNIFIED IDEOGRAPH
    {0xFB5B, 0x72B1}, //7552 #CJK UNIFIED IDEOGRAPH
    {0xFB5C, 0x72BE}, //7553 #CJK UNIFIED IDEOGRAPH
    {0xFB5D, 0x7324}, //7554 #CJK UNIFIED IDEOGRAPH
    {0xFB5E, 0xFA16}, //7555 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB5F, 0x7377}, //7556 #CJK UNIFIED IDEOGRAPH
    {0xFB60, 0x73BD}, //7557 #CJK UNIFIED IDEOGRAPH
    {0xFB61, 0x73C9}, //7558 #CJK UNIFIED IDEOGRAPH
    {0xFB62, 0x73D6}, //7559 #CJK UNIFIED IDEOGRAPH
    {0xFB63, 0x73E3}, //7560 #CJK UNIFIED IDEOGRAPH
    {0xFB64, 0x73D2}, //7561 #CJK UNIFIED IDEOGRAPH
    {0xFB65, 0x7407}, //7562 #CJK UNIFIED IDEOGRAPH
    {0xFB66, 0x73F5}, //7563 #CJK UNIFIED IDEOGRAPH
    {0xFB67, 0x7426}, //7564 #CJK UNIFIED IDEOGRAPH
    {0xFB68, 0x742A}, //7565 #CJK UNIFIED IDEOGRAPH
    {0xFB69, 0x7429}, //7566 #CJK UNIFIED IDEOGRAPH
    {0xFB6A, 0x742E}, //7567 #CJK UNIFIED IDEOGRAPH
    {0xFB6B, 0x7462}, //7568 #CJK UNIFIED IDEOGRAPH
    {0xFB6C, 0x7489}, //7569 #CJK UNIFIED IDEOGRAPH
    {0xFB6D, 0x749F}, //7570 #CJK UNIFIED IDEOGRAPH
    {0xFB6E, 0x7501}, //7571 #CJK UNIFIED IDEOGRAPH
    {0xFB6F, 0x756F}, //7572 #CJK UNIFIED IDEOGRAPH
    {0xFB70, 0x7682}, //7573 #CJK UNIFIED IDEOGRAPH
    {0xFB71, 0x769C}, //7574 #CJK UNIFIED IDEOGRAPH
    {0xFB72, 0x769E}, //7575 #CJK UNIFIED IDEOGRAPH
    {0xFB73, 0x769B}, //7576 #CJK UNIFIED IDEOGRAPH
    {0xFB74, 0x76A6}, //7577 #CJK UNIFIED IDEOGRAPH
    {0xFB75, 0xFA17}, //7578 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB76, 0x7746}, //7579 #CJK UNIFIED IDEOGRAPH
    {0xFB77, 0x52AF}, //7580 #CJK UNIFIED IDEOGRAPH
    {0xFB78, 0x7821}, //7581 #CJK UNIFIED IDEOGRAPH
    {0xFB79, 0x784E}, //7582 #CJK UNIFIED IDEOGRAPH
    {0xFB7A, 0x7864}, //7583 #CJK UNIFIED IDEOGRAPH
    {0xFB7B, 0x787A}, //7584 #CJK UNIFIED IDEOGRAPH
    {0xFB7C, 0x7930}, //7585 #CJK UNIFIED IDEOGRAPH
    {0xFB7D, 0xFA18}, //7586 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB7E, 0xFA19}, //7587 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB80, 0xFA1A}, //7588 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB81, 0x7994}, //7589 #CJK UNIFIED IDEOGRAPH
    {0xFB82, 0xFA1B}, //7590 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB83, 0x799B}, //7591 #CJK UNIFIED IDEOGRAPH
    {0xFB84, 0x7AD1}, //7592 #CJK UNIFIED IDEOGRAPH
    {0xFB85, 0x7AE7}, //7593 #CJK UNIFIED IDEOGRAPH
    {0xFB86, 0xFA1C}, //7594 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB87, 0x7AEB}, //7595 #CJK UNIFIED IDEOGRAPH
    {0xFB88, 0x7B9E}, //7596 #CJK UNIFIED IDEOGRAPH
    {0xFB89, 0xFA1D}, //7597 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB8A, 0x7D48}, //7598 #CJK UNIFIED IDEOGRAPH
    {0xFB8B, 0x7D5C}, //7599 #CJK UNIFIED IDEOGRAPH
    {0xFB8C, 0x7DB7}, //7600 #CJK UNIFIED IDEOGRAPH
    {0xFB8D, 0x7DA0}, //7601 #CJK UNIFIED IDEOGRAPH
    {0xFB8E, 0x7DD6}, //7602 #CJK UNIFIED IDEOGRAPH
    {0xFB8F, 0x7E52}, //7603 #CJK UNIFIED IDEOGRAPH
    {0xFB90, 0x7F47}, //7604 #CJK UNIFIED IDEOGRAPH
    {0xFB91, 0x7FA1}, //7605 #CJK UNIFIED IDEOGRAPH
    {0xFB92, 0xFA1E}, //7606 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB93, 0x8301}, //7607 #CJK UNIFIED IDEOGRAPH
    {0xFB94, 0x8362}, //7608 #CJK UNIFIED IDEOGRAPH
    {0xFB95, 0x837F}, //7609 #CJK UNIFIED IDEOGRAPH
    {0xFB96, 0x83C7}, //7610 #CJK UNIFIED IDEOGRAPH
    {0xFB97, 0x83F6}, //7611 #CJK UNIFIED IDEOGRAPH
    {0xFB98, 0x8448}, //7612 #CJK UNIFIED IDEOGRAPH
    {0xFB99, 0x84B4}, //7613 #CJK UNIFIED IDEOGRAPH
    {0xFB9A, 0x8553}, //7614 #CJK UNIFIED IDEOGRAPH
    {0xFB9B, 0x8559}, //7615 #CJK UNIFIED IDEOGRAPH
    {0xFB9C, 0x856B}, //7616 #CJK UNIFIED IDEOGRAPH
    {0xFB9D, 0xFA1F}, //7617 #CJK COMPATIBILITY IDEOGRAPH
    {0xFB9E, 0x85B0}, //7618 #CJK UNIFIED IDEOGRAPH
    {0xFB9F, 0xFA20}, //7619 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBA0, 0xFA21}, //7620 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBA1, 0x8807}, //7621 #CJK UNIFIED IDEOGRAPH
    {0xFBA2, 0x88F5}, //7622 #CJK UNIFIED IDEOGRAPH
    {0xFBA3, 0x8A12}, //7623 #CJK UNIFIED IDEOGRAPH
    {0xFBA4, 0x8A37}, //7624 #CJK UNIFIED IDEOGRAPH
    {0xFBA5, 0x8A79}, //7625 #CJK UNIFIED IDEOGRAPH
    {0xFBA6, 0x8AA7}, //7626 #CJK UNIFIED IDEOGRAPH
    {0xFBA7, 0x8ABE}, //7627 #CJK UNIFIED IDEOGRAPH
    {0xFBA8, 0x8ADF}, //7628 #CJK UNIFIED IDEOGRAPH
    {0xFBA9, 0xFA22}, //7629 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBAA, 0x8AF6}, //7630 #CJK UNIFIED IDEOGRAPH
    {0xFBAB, 0x8B53}, //7631 #CJK UNIFIED IDEOGRAPH
    {0xFBAC, 0x8B7F}, //7632 #CJK UNIFIED IDEOGRAPH
    {0xFBAD, 0x8CF0}, //7633 #CJK UNIFIED IDEOGRAPH
    {0xFBAE, 0x8CF4}, //7634 #CJK UNIFIED IDEOGRAPH
    {0xFBAF, 0x8D12}, //7635 #CJK UNIFIED IDEOGRAPH
    {0xFBB0, 0x8D76}, //7636 #CJK UNIFIED IDEOGRAPH
    {0xFBB1, 0xFA23}, //7637 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBB2, 0x8ECF}, //7638 #CJK UNIFIED IDEOGRAPH
    {0xFBB3, 0xFA24}, //7639 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBB4, 0xFA25}, //7640 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBB5, 0x9067}, //7641 #CJK UNIFIED IDEOGRAPH
    {0xFBB6, 0x90DE}, //7642 #CJK UNIFIED IDEOGRAPH
    {0xFBB7, 0xFA26}, //7643 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBB8, 0x9115}, //7644 #CJK UNIFIED IDEOGRAPH
    {0xFBB9, 0x9127}, //7645 #CJK UNIFIED IDEOGRAPH
    {0xFBBA, 0x91DA}, //7646 #CJK UNIFIED IDEOGRAPH
    {0xFBBB, 0x91D7}, //7647 #CJK UNIFIED IDEOGRAPH
    {0xFBBC, 0x91DE}, //7648 #CJK UNIFIED IDEOGRAPH
    {0xFBBD, 0x91ED}, //7649 #CJK UNIFIED IDEOGRAPH
    {0xFBBE, 0x91EE}, //7650 #CJK UNIFIED IDEOGRAPH
    {0xFBBF, 0x91E4}, //7651 #CJK UNIFIED IDEOGRAPH
    {0xFBC0, 0x91E5}, //7652 #CJK UNIFIED IDEOGRAPH
    {0xFBC1, 0x9206}, //7653 #CJK UNIFIED IDEOGRAPH
    {0xFBC2, 0x9210}, //7654 #CJK UNIFIED IDEOGRAPH
    {0xFBC3, 0x920A}, //7655 #CJK UNIFIED IDEOGRAPH
    {0xFBC4, 0x923A}, //7656 #CJK UNIFIED IDEOGRAPH
    {0xFBC5, 0x9240}, //7657 #CJK UNIFIED IDEOGRAPH
    {0xFBC6, 0x923C}, //7658 #CJK UNIFIED IDEOGRAPH
    {0xFBC7, 0x924E}, //7659 #CJK UNIFIED IDEOGRAPH
    {0xFBC8, 0x9259}, //7660 #CJK UNIFIED IDEOGRAPH
    {0xFBC9, 0x9251}, //7661 #CJK UNIFIED IDEOGRAPH
    {0xFBCA, 0x9239}, //7662 #CJK UNIFIED IDEOGRAPH
    {0xFBCB, 0x9267}, //7663 #CJK UNIFIED IDEOGRAPH
    {0xFBCC, 0x92A7}, //7664 #CJK UNIFIED IDEOGRAPH
    {0xFBCD, 0x9277}, //7665 #CJK UNIFIED IDEOGRAPH
    {0xFBCE, 0x9278}, //7666 #CJK UNIFIED IDEOGRAPH
    {0xFBCF, 0x92E7}, //7667 #CJK UNIFIED IDEOGRAPH
    {0xFBD0, 0x92D7}, //7668 #CJK UNIFIED IDEOGRAPH
    {0xFBD1, 0x92D9}, //7669 #CJK UNIFIED IDEOGRAPH
    {0xFBD2, 0x92D0}, //7670 #CJK UNIFIED IDEOGRAPH
    {0xFBD3, 0xFA27}, //7671 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBD4, 0x92D5}, //7672 #CJK UNIFIED IDEOGRAPH
    {0xFBD5, 0x92E0}, //7673 #CJK UNIFIED IDEOGRAPH
    {0xFBD6, 0x92D3}, //7674 #CJK UNIFIED IDEOGRAPH
    {0xFBD7, 0x9325}, //7675 #CJK UNIFIED IDEOGRAPH
    {0xFBD8, 0x9321}, //7676 #CJK UNIFIED IDEOGRAPH
    {0xFBD9, 0x92FB}, //7677 #CJK UNIFIED IDEOGRAPH
    {0xFBDA, 0xFA28}, //7678 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBDB, 0x931E}, //7679 #CJK UNIFIED IDEOGRAPH
    {0xFBDC, 0x92FF}, //7680 #CJK UNIFIED IDEOGRAPH
    {0xFBDD, 0x931D}, //7681 #CJK UNIFIED IDEOGRAPH
    {0xFBDE, 0x9302}, //7682 #CJK UNIFIED IDEOGRAPH
    {0xFBDF, 0x9370}, //7683 #CJK UNIFIED IDEOGRAPH
    {0xFBE0, 0x9357}, //7684 #CJK UNIFIED IDEOGRAPH
    {0xFBE1, 0x93A4}, //7685 #CJK UNIFIED IDEOGRAPH
    {0xFBE2, 0x93C6}, //7686 #CJK UNIFIED IDEOGRAPH
    {0xFBE3, 0x93DE}, //7687 #CJK UNIFIED IDEOGRAPH
    {0xFBE4, 0x93F8}, //7688 #CJK UNIFIED IDEOGRAPH
    {0xFBE5, 0x9431}, //7689 #CJK UNIFIED IDEOGRAPH
    {0xFBE6, 0x9445}, //7690 #CJK UNIFIED IDEOGRAPH
    {0xFBE7, 0x9448}, //7691 #CJK UNIFIED IDEOGRAPH
    {0xFBE8, 0x9592}, //7692 #CJK UNIFIED IDEOGRAPH
    {0xFBE9, 0xF9DC}, //7693 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBEA, 0xFA29}, //7694 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBEB, 0x969D}, //7695 #CJK UNIFIED IDEOGRAPH
    {0xFBEC, 0x96AF}, //7696 #CJK UNIFIED IDEOGRAPH
    {0xFBED, 0x9733}, //7697 #CJK UNIFIED IDEOGRAPH
    {0xFBEE, 0x973B}, //7698 #CJK UNIFIED IDEOGRAPH
    {0xFBEF, 0x9743}, //7699 #CJK UNIFIED IDEOGRAPH
    {0xFBF0, 0x974D}, //7700 #CJK UNIFIED IDEOGRAPH
    {0xFBF1, 0x974F}, //7701 #CJK UNIFIED IDEOGRAPH
    {0xFBF2, 0x9751}, //7702 #CJK UNIFIED IDEOGRAPH
    {0xFBF3, 0x9755}, //7703 #CJK UNIFIED IDEOGRAPH
    {0xFBF4, 0x9857}, //7704 #CJK UNIFIED IDEOGRAPH
    {0xFBF5, 0x9865}, //7705 #CJK UNIFIED IDEOGRAPH
    {0xFBF6, 0xFA2A}, //7706 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBF7, 0xFA2B}, //7707 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBF8, 0x9927}, //7708 #CJK UNIFIED IDEOGRAPH
    {0xFBF9, 0xFA2C}, //7709 #CJK COMPATIBILITY IDEOGRAPH
    {0xFBFA, 0x999E}, //7710 #CJK UNIFIED IDEOGRAPH
    {0xFBFB, 0x9A4E}, //7711 #CJK UNIFIED IDEOGRAPH
    {0xFBFC, 0x9AD9}, //7712 #CJK UNIFIED IDEOGRAPH
    {0xFC40, 0x9ADC}, //7713 #CJK UNIFIED IDEOGRAPH
    {0xFC41, 0x9B75}, //7714 #CJK UNIFIED IDEOGRAPH
    {0xFC42, 0x9B72}, //7715 #CJK UNIFIED IDEOGRAPH
    {0xFC43, 0x9B8F}, //7716 #CJK UNIFIED IDEOGRAPH
    {0xFC44, 0x9BB1}, //7717 #CJK UNIFIED IDEOGRAPH
    {0xFC45, 0x9BBB}, //7718 #CJK UNIFIED IDEOGRAPH
    {0xFC46, 0x9C00}, //7719 #CJK UNIFIED IDEOGRAPH
    {0xFC47, 0x9D70}, //7720 #CJK UNIFIED IDEOGRAPH
    {0xFC48, 0x9D6B}, //7721 #CJK UNIFIED IDEOGRAPH
    {0xFC49, 0xFA2D}, //7722 #CJK COMPATIBILITY IDEOGRAPH
    {0xFC4A, 0x9E19}, //7723 #CJK UNIFIED IDEOGRAPH
    {0xFC4B, 0x9ED1}  //7724 #CJK UNIFIED IDEOGRAPH
};
#endif // DRW_CPTABLE932_H
