#ifndef DRW_CPTABLE950_H
#define DRW_CPTABLE950_H

//Chinese (Taiwan, Hong Kong SAR)

//first entry in this table are 0x80
#define CPOFFSET950 0x80
#define CPLENGHT950 13503
#define NOTFOUND950 0x003F

//Table 950 one byte
static const int DRW_Table950[] = {
};

//Table 950 lead byte
//pairs of start/end in DRW_DoubleTable950
static const int DRW_LeadTable950[] = {
    0, //1#DBCS LEAD BYTE 0x81, empty
    0, //2#DBCS LEAD BYTE 0x82, empty
    0, //3#DBCS LEAD BYTE 0x83, empty
    0, //4#DBCS LEAD BYTE 0x84, empty
    0, //5#DBCS LEAD BYTE 0x85, empty
    0, //6#DBCS LEAD BYTE 0x86, empty
    0, //7#DBCS LEAD BYTE 0x87, empty
    0, //8#DBCS LEAD BYTE 0x88, empty
    0, //9#DBCS LEAD BYTE 0x89, empty
    0, //10#DBCS LEAD BYTE 0x8A, empty
    0, //11#DBCS LEAD BYTE 0x8B, empty
    0, //12#DBCS LEAD BYTE 0x8C, empty
    0, //13#DBCS LEAD BYTE 0x8D, empty
    0, //14#DBCS LEAD BYTE 0x8E, empty
    0, //15#DBCS LEAD BYTE 0x8F, empty
    0, //16#DBCS LEAD BYTE 0x90, empty
    0, //17#DBCS LEAD BYTE 0x91, empty
    0, //18#DBCS LEAD BYTE 0x92, empty
    0, //19#DBCS LEAD BYTE 0x93, empty
    0, //20#DBCS LEAD BYTE 0x94, empty
    0, //21#DBCS LEAD BYTE 0x95, empty
    0, //22#DBCS LEAD BYTE 0x96, empty
    0, //23#DBCS LEAD BYTE 0x97, empty
    0, //24#DBCS LEAD BYTE 0x98, empty
    0, //25#DBCS LEAD BYTE 0x99, empty
    0, //26#DBCS LEAD BYTE 0x9A, empty
    0, //27#DBCS LEAD BYTE 0x9B, empty
    0, //28#DBCS LEAD BYTE 0x9C, empty
    0, //29#DBCS LEAD BYTE 0x9D, empty
    0, //30#DBCS LEAD BYTE 0x9E, empty
    0, //31#DBCS LEAD BYTE 0x9F, empty
    0, //32#DBCS LEAD BYTE 0xA0, empty
    0, //33#DBCS LEAD BYTE 0xA1
    157, //34#DBCS LEAD BYTE 0xA2
    314, //35#DBCS LEAD BYTE 0xA3
    409, //36#DBCS LEAD BYTE 0xA4
    566, //37#DBCS LEAD BYTE 0xA5
    723, //38#DBCS LEAD BYTE 0xA6
    880, //39#DBCS LEAD BYTE 0xA7
    1037, //40#DBCS LEAD BYTE 0xA8
    1194, //41#DBCS LEAD BYTE 0xA9
    1351, //42#DBCS LEAD BYTE 0xAA
    1508, //43#DBCS LEAD BYTE 0xAB
    1665, //44#DBCS LEAD BYTE 0xAC
    1822, //45#DBCS LEAD BYTE 0xAD
    1979, //46#DBCS LEAD BYTE 0xAE
    2136, //47#DBCS LEAD BYTE 0xAF
    2293, //48#DBCS LEAD BYTE 0xB0
    2450, //49#DBCS LEAD BYTE 0xB1
    2607, //50#DBCS LEAD BYTE 0xB2
    2764, //51#DBCS LEAD BYTE 0xB3
    2921, //52#DBCS LEAD BYTE 0xB4
    3078, //53#DBCS LEAD BYTE 0xB5
    3235, //54#DBCS LEAD BYTE 0xB6
    3392, //55#DBCS LEAD BYTE 0xB7
    3549, //56#DBCS LEAD BYTE 0xB8
    3706, //57#DBCS LEAD BYTE 0xB9
    3863, //58#DBCS LEAD BYTE 0xBA
    4020, //59#DBCS LEAD BYTE 0xBB
    4177, //60#DBCS LEAD BYTE 0xBC
    4334, //61#DBCS LEAD BYTE 0xBD
    4491, //62#DBCS LEAD BYTE 0xBE
    4648, //63#DBCS LEAD BYTE 0xBF
    4805, //64#DBCS LEAD BYTE 0xC0
    4962, //65#DBCS LEAD BYTE 0xC1
    5119, //66#DBCS LEAD BYTE 0xC2
    5276, //67#DBCS LEAD BYTE 0xC3
    5443, //68#DBCS LEAD BYTE 0xC4
    5590, //69#DBCS LEAD BYTE 0xC5
    5747, //70#DBCS LEAD BYTE 0xC6
    5810, //71#DBCS LEAD BYTE 0xC7, empty
    5810, //72#DBCS LEAD BYTE 0xC8, empty
    5810, //73#DBCS LEAD BYTE 0xC9
    5967, //74#DBCS LEAD BYTE 0xCA
    6124, //75#DBCS LEAD BYTE 0xCB
    6281, //76#DBCS LEAD BYTE 0xCC
    6438, //77#DBCS LEAD BYTE 0xCD
    6595, //78#DBCS LEAD BYTE 0xCE
    6752, //79#DBCS LEAD BYTE 0xCF
    6909, //80#DBCS LEAD BYTE 0xD0
    7066, //81#DBCS LEAD BYTE 0xD1
    7223, //82#DBCS LEAD BYTE 0xD2
    7380, //83#DBCS LEAD BYTE 0xD3
    7537, //84#DBCS LEAD BYTE 0xD4
    7694, //85#DBCS LEAD BYTE 0xD5
    7851, //86#DBCS LEAD BYTE 0xD6
    8008, //87#DBCS LEAD BYTE 0xD7
    8165, //88#DBCS LEAD BYTE 0xD8
    8322, //89#DBCS LEAD BYTE 0xD9
    8479, //90#DBCS LEAD BYTE 0xDA
    8636, //91#DBCS LEAD BYTE 0xDB
    8793, //92#DBCS LEAD BYTE 0xDC
    8950, //93#DBCS LEAD BYTE 0xDD
    9107, //94#DBCS LEAD BYTE 0xDE
    9264, //95#DBCS LEAD BYTE 0xDF
    9421, //96#DBCS LEAD BYTE 0xE0
    9578, //97#DBCS LEAD BYTE 0xE1
    9735, //98#DBCS LEAD BYTE 0xE2
    9892, //99#DBCS LEAD BYTE 0xE3
    10049, //100#DBCS LEAD BYTE 0xE4
    10206, //101#DBCS LEAD BYTE 0xE5
    10363, //102#DBCS LEAD BYTE 0xE6
    10520, //103#DBCS LEAD BYTE 0xE7
    10677, //104#DBCS LEAD BYTE 0xE8
    10834, //105#DBCS LEAD BYTE 0xE9
    10991, //106#DBCS LEAD BYTE 0xEA
    11148, //107#DBCS LEAD BYTE 0xEB
    11305, //108#DBCS LEAD BYTE 0xEC
    11462, //109#DBCS LEAD BYTE 0xED
    11619, //110#DBCS LEAD BYTE 0xEE
    11776, //111#DBCS LEAD BYTE 0xEF
    11933, //112#DBCS LEAD BYTE 0xF0
    12090, //113#DBCS LEAD BYTE 0xF1
    12247, //114#DBCS LEAD BYTE 0xF2
    12404, //115#DBCS LEAD BYTE 0xF3
    12561, //116#DBCS LEAD BYTE 0xF4
    12718, //117#DBCS LEAD BYTE 0xF5
    12875, //118#DBCS LEAD BYTE 0xF6
    13032, //119#DBCS LEAD BYTE 0xF7
    13189, //120#DBCS LEAD BYTE 0xF8
    13346, //121#DBCS LEAD BYTE 0xF9
    13502, //122#DBCS LEAD BYTE 0xFA, empty
    13502, //123#DBCS LEAD BYTE 0xFB, empty
    13502, //124#DBCS LEAD BYTE 0xFC, empty
    13502, //125#DBCS LEAD BYTE 0xFD, empty
    13502, //126#DBCS LEAD BYTE 0xFE, empty
    13502, //127#UNDEFINED 0xFF, END OF TABLE
};

//Table 950 tail byte
static const int DRW_DoubleTable950[][2] = {
    {0xA140, 0x3000}, //1 #IDEOGRAPHIC SPACE
    {0xA141, 0xFF0C}, //2 #FULLWIDTH COMMA
    {0xA142, 0x3001}, //3 #IDEOGRAPHIC COMMA
    {0xA143, 0x3002}, //4 #IDEOGRAPHIC FULL STOP
    {0xA144, 0xFF0E}, //5 #FULLWIDTH FULL STOP
    {0xA145, 0x2027}, //6 #HYPHENATION POINT
    {0xA146, 0xFF1B}, //7 #FULLWIDTH SEMICOLON
    {0xA147, 0xFF1A}, //8 #FULLWIDTH COLON
    {0xA148, 0xFF1F}, //9 #FULLWIDTH QUESTION MARK
    {0xA149, 0xFF01}, //10 #FULLWIDTH EXCLAMATION MARK
    {0xA14A, 0xFE30}, //11 #PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
    {0xA14B, 0x2026}, //12 #HORIZONTAL ELLIPSIS
    {0xA14C, 0x2025}, //13 #TWO DOT LEADER
    {0xA14D, 0xFE50}, //14 #SMALL COMMA
    {0xA14E, 0xFE51}, //15 #SMALL IDEOGRAPHIC COMMA
    {0xA14F, 0xFE52}, //16 #SMALL FULL STOP
    {0xA150, 0x00B7}, //17 #MIDDLE DOT
    {0xA151, 0xFE54}, //18 #SMALL SEMICOLON
    {0xA152, 0xFE55}, //19 #SMALL COLON
    {0xA153, 0xFE56}, //20 #SMALL QUESTION MARK
    {0xA154, 0xFE57}, //21 #SMALL EXCLAMATION MARK
    {0xA155, 0xFF5C}, //22 #FULLWIDTH VERTICAL LINE
    {0xA156, 0x2013}, //23 #EN DASH
    {0xA157, 0xFE31}, //24 #PRESENTATION FORM FOR VERTICAL EM DASH
    {0xA158, 0x2014}, //25 #EM DASH
    {0xA159, 0xFE33}, //26 #PRESENTATION FORM FOR VERTICAL LOW LINE
    {0xA15A, 0x2574}, //27 #BOX DRAWINGS LIGHT LEFT
    {0xA15B, 0xFE34}, //28 #PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
    {0xA15C, 0xFE4F}, //29 #WAVY LOW LINE
    {0xA15D, 0xFF08}, //30 #FULLWIDTH LEFT PARENTHESIS
    {0xA15E, 0xFF09}, //31 #FULLWIDTH RIGHT PARENTHESIS
    {0xA15F, 0xFE35}, //32 #PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
    {0xA160, 0xFE36}, //33 #PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
    {0xA161, 0xFF5B}, //34 #FULLWIDTH LEFT CURLY BRACKET
    {0xA162, 0xFF5D}, //35 #FULLWIDTH RIGHT CURLY BRACKET
    {0xA163, 0xFE37}, //36 #PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
    {0xA164, 0xFE38}, //37 #PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
    {0xA165, 0x3014}, //38 #LEFT TORTOISE SHELL BRACKET
    {0xA166, 0x3015}, //39 #RIGHT TORTOISE SHELL BRACKET
    {0xA167, 0xFE39}, //40 #PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
    {0xA168, 0xFE3A}, //41 #PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
    {0xA169, 0x3010}, //42 #LEFT BLACK LENTICULAR BRACKET
    {0xA16A, 0x3011}, //43 #RIGHT BLACK LENTICULAR BRACKET
    {0xA16B, 0xFE3B}, //44 #PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
    {0xA16C, 0xFE3C}, //45 #PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
    {0xA16D, 0x300A}, //46 #LEFT DOUBLE ANGLE BRACKET
    {0xA16E, 0x300B}, //47 #RIGHT DOUBLE ANGLE BRACKET
    {0xA16F, 0xFE3D}, //48 #PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
    {0xA170, 0xFE3E}, //49 #PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
    {0xA171, 0x3008}, //50 #LEFT ANGLE BRACKET
    {0xA172, 0x3009}, //51 #RIGHT ANGLE BRACKET
    {0xA173, 0xFE3F}, //52 #PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
    {0xA174, 0xFE40}, //53 #PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
    {0xA175, 0x300C}, //54 #LEFT CORNER BRACKET
    {0xA176, 0x300D}, //55 #RIGHT CORNER BRACKET
    {0xA177, 0xFE41}, //56 #PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
    {0xA178, 0xFE42}, //57 #PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
    {0xA179, 0x300E}, //58 #LEFT WHITE CORNER BRACKET
    {0xA17A, 0x300F}, //59 #RIGHT WHITE CORNER BRACKET
    {0xA17B, 0xFE43}, //60 #PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
    {0xA17C, 0xFE44}, //61 #PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
    {0xA17D, 0xFE59}, //62 #SMALL LEFT PARENTHESIS
    {0xA17E, 0xFE5A}, //63 #SMALL RIGHT PARENTHESIS
    {0xA1A1, 0xFE5B}, //64 #SMALL LEFT CURLY BRACKET
    {0xA1A2, 0xFE5C}, //65 #SMALL RIGHT CURLY BRACKET
    {0xA1A3, 0xFE5D}, //66 #SMALL LEFT TORTOISE SHELL BRACKET
    {0xA1A4, 0xFE5E}, //67 #SMALL RIGHT TORTOISE SHELL BRACKET
    {0xA1A5, 0x2018}, //68 #LEFT SINGLE QUOTATION MARK
    {0xA1A6, 0x2019}, //69 #RIGHT SINGLE QUOTATION MARK
    {0xA1A7, 0x201C}, //70 #LEFT DOUBLE QUOTATION MARK
    {0xA1A8, 0x201D}, //71 #RIGHT DOUBLE QUOTATION MARK
    {0xA1A9, 0x301D}, //72 #REVERSED DOUBLE PRIME QUOTATION MARK
    {0xA1AA, 0x301E}, //73 #DOUBLE PRIME QUOTATION MARK
    {0xA1AB, 0x2035}, //74 #REVERSED PRIME
    {0xA1AC, 0x2032}, //75 #PRIME
    {0xA1AD, 0xFF03}, //76 #FULLWIDTH NUMBER SIGN
    {0xA1AE, 0xFF06}, //77 #FULLWIDTH AMPERSAND
    {0xA1AF, 0xFF0A}, //78 #FULLWIDTH ASTERISK
    {0xA1B0, 0x203B}, //79 #REFERENCE MARK
    {0xA1B1, 0x00A7}, //80 #SECTION SIGN
    {0xA1B2, 0x3003}, //81 #DITTO MARK
    {0xA1B3, 0x25CB}, //82 #WHITE CIRCLE
    {0xA1B4, 0x25CF}, //83 #BLACK CIRCLE
    {0xA1B5, 0x25B3}, //84 #WHITE UP-POINTING TRIANGLE
    {0xA1B6, 0x25B2}, //85 #BLACK UP-POINTING TRIANGLE
    {0xA1B7, 0x25CE}, //86 #BULLSEYE
    {0xA1B8, 0x2606}, //87 #WHITE STAR
    {0xA1B9, 0x2605}, //88 #BLACK STAR
    {0xA1BA, 0x25C7}, //89 #WHITE DIAMOND
    {0xA1BB, 0x25C6}, //90 #BLACK DIAMOND
    {0xA1BC, 0x25A1}, //91 #WHITE SQUARE
    {0xA1BD, 0x25A0}, //92 #BLACK SQUARE
    {0xA1BE, 0x25BD}, //93 #WHITE DOWN-POINTING TRIANGLE
    {0xA1BF, 0x25BC}, //94 #BLACK DOWN-POINTING TRIANGLE
    {0xA1C0, 0x32A3}, //95 #CIRCLED IDEOGRAPH CORRECT
    {0xA1C1, 0x2105}, //96 #CARE OF
    {0xA1C2, 0x00AF}, //97 #MACRON
    {0xA1C3, 0xFFE3}, //98 #FULLWIDTH MACRON
    {0xA1C4, 0xFF3F}, //99 #FULLWIDTH LOW LINE
    {0xA1C5, 0x02CD}, //100 #MODIFIER LETTER LOW MACRON
    {0xA1C6, 0xFE49}, //101 #DASHED OVERLINE
    {0xA1C7, 0xFE4A}, //102 #CENTRELINE OVERLINE
    {0xA1C8, 0xFE4D}, //103 #DASHED LOW LINE
    {0xA1C9, 0xFE4E}, //104 #CENTRELINE LOW LINE
    {0xA1CA, 0xFE4B}, //105 #WAVY OVERLINE
    {0xA1CB, 0xFE4C}, //106 #DOUBLE WAVY OVERLINE
    {0xA1CC, 0xFE5F}, //107 #SMALL NUMBER SIGN
    {0xA1CD, 0xFE60}, //108 #SMALL AMPERSAND
    {0xA1CE, 0xFE61}, //109 #SMALL ASTERISK
    {0xA1CF, 0xFF0B}, //110 #FULLWIDTH PLUS SIGN
    {0xA1D0, 0xFF0D}, //111 #FULLWIDTH HYPHEN-MINUS
    {0xA1D1, 0x00D7}, //112 #MULTIPLICATION SIGN
    {0xA1D2, 0x00F7}, //113 #DIVISION SIGN
    {0xA1D3, 0x00B1}, //114 #PLUS-MINUS SIGN
    {0xA1D4, 0x221A}, //115 #SQUARE ROOT
    {0xA1D5, 0xFF1C}, //116 #FULLWIDTH LESS-THAN SIGN
    {0xA1D6, 0xFF1E}, //117 #FULLWIDTH GREATER-THAN SIGN
    {0xA1D7, 0xFF1D}, //118 #FULLWIDTH EQUALS SIGN
    {0xA1D8, 0x2266}, //119 #LESS-THAN OVER EQUAL TO
    {0xA1D9, 0x2267}, //120 #GREATER-THAN OVER EQUAL TO
    {0xA1DA, 0x2260}, //121 #NOT EQUAL TO
    {0xA1DB, 0x221E}, //122 #INFINITY
    {0xA1DC, 0x2252}, //123 #APPROXIMATELY EQUAL TO OR THE IMAGE OF
    {0xA1DD, 0x2261}, //124 #IDENTICAL TO
    {0xA1DE, 0xFE62}, //125 #SMALL PLUS SIGN
    {0xA1DF, 0xFE63}, //126 #SMALL HYPHEN-MINUS
    {0xA1E0, 0xFE64}, //127 #SMALL LESS-THAN SIGN
    {0xA1E1, 0xFE65}, //128 #SMALL GREATER-THAN SIGN
    {0xA1E2, 0xFE66}, //129 #SMALL EQUALS SIGN
    {0xA1E3, 0xFF5E}, //130 #FULLWIDTH TILDE
    {0xA1E4, 0x2229}, //131 #INTERSECTION
    {0xA1E5, 0x222A}, //132 #UNION
    {0xA1E6, 0x22A5}, //133 #UP TACK
    {0xA1E7, 0x2220}, //134 #ANGLE
    {0xA1E8, 0x221F}, //135 #RIGHT ANGLE
    {0xA1E9, 0x22BF}, //136 #RIGHT TRIANGLE
    {0xA1EA, 0x33D2}, //137 #SQUARE LOG
    {0xA1EB, 0x33D1}, //138 #SQUARE LN
    {0xA1EC, 0x222B}, //139 #INTEGRAL
    {0xA1ED, 0x222E}, //140 #CONTOUR INTEGRAL
    {0xA1EE, 0x2235}, //141 #BECAUSE
    {0xA1EF, 0x2234}, //142 #THEREFORE
    {0xA1F0, 0x2640}, //143 #FEMALE SIGN
    {0xA1F1, 0x2642}, //144 #MALE SIGN
    {0xA1F2, 0x2295}, //145 #CIRCLED PLUS
    {0xA1F3, 0x2299}, //146 #CIRCLED DOT OPERATOR
    {0xA1F4, 0x2191}, //147 #UPWARDS ARROW
    {0xA1F5, 0x2193}, //148 #DOWNWARDS ARROW
    {0xA1F6, 0x2190}, //149 #LEFTWARDS ARROW
    {0xA1F7, 0x2192}, //150 #RIGHTWARDS ARROW
    {0xA1F8, 0x2196}, //151 #NORTH WEST ARROW
    {0xA1F9, 0x2197}, //152 #NORTH EAST ARROW
    {0xA1FA, 0x2199}, //153 #SOUTH WEST ARROW
    {0xA1FB, 0x2198}, //154 #SOUTH EAST ARROW
    {0xA1FC, 0x2225}, //155 #PARALLEL TO
    {0xA1FD, 0x2223}, //156 #DIVIDES
    {0xA1FE, 0xFF0F}, //157 #FULLWIDTH SOLIDUS
    {0xA240, 0xFF3C}, //158 #FULLWIDTH REVERSE SOLIDUS
    {0xA241, 0x2215}, //159 #DIVISION SLASH
    {0xA242, 0xFE68}, //160 #SMALL REVERSE SOLIDUS
    {0xA243, 0xFF04}, //161 #FULLWIDTH DOLLAR SIGN
    {0xA244, 0xFFE5}, //162 #FULLWIDTH YEN SIGN
    {0xA245, 0x3012}, //163 #POSTAL MARK
    {0xA246, 0xFFE0}, //164 #FULLWIDTH CENT SIGN
    {0xA247, 0xFFE1}, //165 #FULLWIDTH POUND SIGN
    {0xA248, 0xFF05}, //166 #FULLWIDTH PERCENT SIGN
    {0xA249, 0xFF20}, //167 #FULLWIDTH COMMERCIAL AT
    {0xA24A, 0x2103}, //168 #DEGREE CELSIUS
    {0xA24B, 0x2109}, //169 #DEGREE FAHRENHEIT
    {0xA24C, 0xFE69}, //170 #SMALL DOLLAR SIGN
    {0xA24D, 0xFE6A}, //171 #SMALL PERCENT SIGN
    {0xA24E, 0xFE6B}, //172 #SMALL COMMERCIAL AT
    {0xA24F, 0x33D5}, //173 #SQUARE MIL
    {0xA250, 0x339C}, //174 #SQUARE MM
    {0xA251, 0x339D}, //175 #SQUARE CM
    {0xA252, 0x339E}, //176 #SQUARE KM
    {0xA253, 0x33CE}, //177 #SQUARE KM CAPITAL
    {0xA254, 0x33A1}, //178 #SQUARE M SQUARED
    {0xA255, 0x338E}, //179 #SQUARE MG
    {0xA256, 0x338F}, //180 #SQUARE KG
    {0xA257, 0x33C4}, //181 #SQUARE CC
    {0xA258, 0x00B0}, //182 #DEGREE SIGN
    {0xA259, 0x5159}, //183 #CJK UNIFIED IDEOGRAPH
    {0xA25A, 0x515B}, //184 #CJK UNIFIED IDEOGRAPH
    {0xA25B, 0x515E}, //185 #CJK UNIFIED IDEOGRAPH
    {0xA25C, 0x515D}, //186 #CJK UNIFIED IDEOGRAPH
    {0xA25D, 0x5161}, //187 #CJK UNIFIED IDEOGRAPH
    {0xA25E, 0x5163}, //188 #CJK UNIFIED IDEOGRAPH
    {0xA25F, 0x55E7}, //189 #CJK UNIFIED IDEOGRAPH
    {0xA260, 0x74E9}, //190 #CJK UNIFIED IDEOGRAPH
    {0xA261, 0x7CCE}, //191 #CJK UNIFIED IDEOGRAPH
    {0xA262, 0x2581}, //192 #LOWER ONE EIGHTH BLOCK
    {0xA263, 0x2582}, //193 #LOWER ONE QUARTER BLOCK
    {0xA264, 0x2583}, //194 #LOWER THREE EIGHTHS BLOCK
    {0xA265, 0x2584}, //195 #LOWER HALF BLOCK
    {0xA266, 0x2585}, //196 #LOWER FIVE EIGHTHS BLOCK
    {0xA267, 0x2586}, //197 #LOWER THREE QUARTERS BLOCK
    {0xA268, 0x2587}, //198 #LOWER SEVEN EIGHTHS BLOCK
    {0xA269, 0x2588}, //199 #FULL BLOCK
    {0xA26A, 0x258F}, //200 #LEFT ONE EIGHTH BLOCK
    {0xA26B, 0x258E}, //201 #LEFT ONE QUARTER BLOCK
    {0xA26C, 0x258D}, //202 #LEFT THREE EIGHTHS BLOCK
    {0xA26D, 0x258C}, //203 #LEFT HALF BLOCK
    {0xA26E, 0x258B}, //204 #LEFT FIVE EIGHTHS BLOCK
    {0xA26F, 0x258A}, //205 #LEFT THREE QUARTERS BLOCK
    {0xA270, 0x2589}, //206 #LEFT SEVEN EIGHTHS BLOCK
    {0xA271, 0x253C}, //207 #BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    {0xA272, 0x2534}, //208 #BOX DRAWINGS LIGHT UP AND HORIZONTAL
    {0xA273, 0x252C}, //209 #BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    {0xA274, 0x2524}, //210 #BOX DRAWINGS LIGHT VERTICAL AND LEFT
    {0xA275, 0x251C}, //211 #BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    {0xA276, 0x2594}, //212 #UPPER ONE EIGHTH BLOCK
    {0xA277, 0x2500}, //213 #BOX DRAWINGS LIGHT HORIZONTAL
    {0xA278, 0x2502}, //214 #BOX DRAWINGS LIGHT VERTICAL
    {0xA279, 0x2595}, //215 #RIGHT ONE EIGHTH BLOCK
    {0xA27A, 0x250C}, //216 #BOX DRAWINGS LIGHT DOWN AND RIGHT
    {0xA27B, 0x2510}, //217 #BOX DRAWINGS LIGHT DOWN AND LEFT
    {0xA27C, 0x2514}, //218 #BOX DRAWINGS LIGHT UP AND RIGHT
    {0xA27D, 0x2518}, //219 #BOX DRAWINGS LIGHT UP AND LEFT
    {0xA27E, 0x256D}, //220 #BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
    {0xA2A1, 0x256E}, //221 #BOX DRAWINGS LIGHT ARC DOWN AND LEFT
    {0xA2A2, 0x2570}, //222 #BOX DRAWINGS LIGHT ARC UP AND RIGHT
    {0xA2A3, 0x256F}, //223 #BOX DRAWINGS LIGHT ARC UP AND LEFT
    {0xA2A4, 0x2550}, //224 #BOX DRAWINGS DOUBLE HORIZONTAL
    {0xA2A5, 0x255E}, //225 #BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
    {0xA2A6, 0x256A}, //226 #BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
    {0xA2A7, 0x2561}, //227 #BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
    {0xA2A8, 0x25E2}, //228 #BLACK LOWER RIGHT TRIANGLE
    {0xA2A9, 0x25E3}, //229 #BLACK LOWER LEFT TRIANGLE
    {0xA2AA, 0x25E5}, //230 #BLACK UPPER RIGHT TRIANGLE
    {0xA2AB, 0x25E4}, //231 #BLACK UPPER LEFT TRIANGLE
    {0xA2AC, 0x2571}, //232 #BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
    {0xA2AD, 0x2572}, //233 #BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
    {0xA2AE, 0x2573}, //234 #BOX DRAWINGS LIGHT DIAGONAL CROSS
    {0xA2AF, 0xFF10}, //235 #FULLWIDTH DIGIT ZERO
    {0xA2B0, 0xFF11}, //236 #FULLWIDTH DIGIT ONE
    {0xA2B1, 0xFF12}, //237 #FULLWIDTH DIGIT TWO
    {0xA2B2, 0xFF13}, //238 #FULLWIDTH DIGIT THREE
    {0xA2B3, 0xFF14}, //239 #FULLWIDTH DIGIT FOUR
    {0xA2B4, 0xFF15}, //240 #FULLWIDTH DIGIT FIVE
    {0xA2B5, 0xFF16}, //241 #FULLWIDTH DIGIT SIX
    {0xA2B6, 0xFF17}, //242 #FULLWIDTH DIGIT SEVEN
    {0xA2B7, 0xFF18}, //243 #FULLWIDTH DIGIT EIGHT
    {0xA2B8, 0xFF19}, //244 #FULLWIDTH DIGIT NINE
    {0xA2B9, 0x2160}, //245 #ROMAN NUMERAL ONE
    {0xA2BA, 0x2161}, //246 #ROMAN NUMERAL TWO
    {0xA2BB, 0x2162}, //247 #ROMAN NUMERAL THREE
    {0xA2BC, 0x2163}, //248 #ROMAN NUMERAL FOUR
    {0xA2BD, 0x2164}, //249 #ROMAN NUMERAL FIVE
    {0xA2BE, 0x2165}, //250 #ROMAN NUMERAL SIX
    {0xA2BF, 0x2166}, //251 #ROMAN NUMERAL SEVEN
    {0xA2C0, 0x2167}, //252 #ROMAN NUMERAL EIGHT
    {0xA2C1, 0x2168}, //253 #ROMAN NUMERAL NINE
    {0xA2C2, 0x2169}, //254 #ROMAN NUMERAL TEN
    {0xA2C3, 0x3021}, //255 #HANGZHOU NUMERAL ONE
    {0xA2C4, 0x3022}, //256 #HANGZHOU NUMERAL TWO
    {0xA2C5, 0x3023}, //257 #HANGZHOU NUMERAL THREE
    {0xA2C6, 0x3024}, //258 #HANGZHOU NUMERAL FOUR
    {0xA2C7, 0x3025}, //259 #HANGZHOU NUMERAL FIVE
    {0xA2C8, 0x3026}, //260 #HANGZHOU NUMERAL SIX
    {0xA2C9, 0x3027}, //261 #HANGZHOU NUMERAL SEVEN
    {0xA2CA, 0x3028}, //262 #HANGZHOU NUMERAL EIGHT
    {0xA2CB, 0x3029}, //263 #HANGZHOU NUMERAL NINE
    {0xA2CC, 0x5341}, //264 #CJK UNIFIED IDEOGRAPH
    {0xA2CD, 0x5344}, //265 #CJK UNIFIED IDEOGRAPH
    {0xA2CE, 0x5345}, //266 #CJK UNIFIED IDEOGRAPH
    {0xA2CF, 0xFF21}, //267 #FULLWIDTH LATIN CAPITAL LETTER A
    {0xA2D0, 0xFF22}, //268 #FULLWIDTH LATIN CAPITAL LETTER B
    {0xA2D1, 0xFF23}, //269 #FULLWIDTH LATIN CAPITAL LETTER C
    {0xA2D2, 0xFF24}, //270 #FULLWIDTH LATIN CAPITAL LETTER D
    {0xA2D3, 0xFF25}, //271 #FULLWIDTH LATIN CAPITAL LETTER E
    {0xA2D4, 0xFF26}, //272 #FULLWIDTH LATIN CAPITAL LETTER F
    {0xA2D5, 0xFF27}, //273 #FULLWIDTH LATIN CAPITAL LETTER G
    {0xA2D6, 0xFF28}, //274 #FULLWIDTH LATIN CAPITAL LETTER H
    {0xA2D7, 0xFF29}, //275 #FULLWIDTH LATIN CAPITAL LETTER I
    {0xA2D8, 0xFF2A}, //276 #FULLWIDTH LATIN CAPITAL LETTER J
    {0xA2D9, 0xFF2B}, //277 #FULLWIDTH LATIN CAPITAL LETTER K
    {0xA2DA, 0xFF2C}, //278 #FULLWIDTH LATIN CAPITAL LETTER L
    {0xA2DB, 0xFF2D}, //279 #FULLWIDTH LATIN CAPITAL LETTER M
    {0xA2DC, 0xFF2E}, //280 #FULLWIDTH LATIN CAPITAL LETTER N
    {0xA2DD, 0xFF2F}, //281 #FULLWIDTH LATIN CAPITAL LETTER O
    {0xA2DE, 0xFF30}, //282 #FULLWIDTH LATIN CAPITAL LETTER P
    {0xA2DF, 0xFF31}, //283 #FULLWIDTH LATIN CAPITAL LETTER Q
    {0xA2E0, 0xFF32}, //284 #FULLWIDTH LATIN CAPITAL LETTER R
    {0xA2E1, 0xFF33}, //285 #FULLWIDTH LATIN CAPITAL LETTER S
    {0xA2E2, 0xFF34}, //286 #FULLWIDTH LATIN CAPITAL LETTER T
    {0xA2E3, 0xFF35}, //287 #FULLWIDTH LATIN CAPITAL LETTER U
    {0xA2E4, 0xFF36}, //288 #FULLWIDTH LATIN CAPITAL LETTER V
    {0xA2E5, 0xFF37}, //289 #FULLWIDTH LATIN CAPITAL LETTER W
    {0xA2E6, 0xFF38}, //290 #FULLWIDTH LATIN CAPITAL LETTER X
    {0xA2E7, 0xFF39}, //291 #FULLWIDTH LATIN CAPITAL LETTER Y
    {0xA2E8, 0xFF3A}, //292 #FULLWIDTH LATIN CAPITAL LETTER Z
    {0xA2E9, 0xFF41}, //293 #FULLWIDTH LATIN SMALL LETTER A
    {0xA2EA, 0xFF42}, //294 #FULLWIDTH LATIN SMALL LETTER B
    {0xA2EB, 0xFF43}, //295 #FULLWIDTH LATIN SMALL LETTER C
    {0xA2EC, 0xFF44}, //296 #FULLWIDTH LATIN SMALL LETTER D
    {0xA2ED, 0xFF45}, //297 #FULLWIDTH LATIN SMALL LETTER E
    {0xA2EE, 0xFF46}, //298 #FULLWIDTH LATIN SMALL LETTER F
    {0xA2EF, 0xFF47}, //299 #FULLWIDTH LATIN SMALL LETTER G
    {0xA2F0, 0xFF48}, //300 #FULLWIDTH LATIN SMALL LETTER H
    {0xA2F1, 0xFF49}, //301 #FULLWIDTH LATIN SMALL LETTER I
    {0xA2F2, 0xFF4A}, //302 #FULLWIDTH LATIN SMALL LETTER J
    {0xA2F3, 0xFF4B}, //303 #FULLWIDTH LATIN SMALL LETTER K
    {0xA2F4, 0xFF4C}, //304 #FULLWIDTH LATIN SMALL LETTER L
    {0xA2F5, 0xFF4D}, //305 #FULLWIDTH LATIN SMALL LETTER M
    {0xA2F6, 0xFF4E}, //306 #FULLWIDTH LATIN SMALL LETTER N
    {0xA2F7, 0xFF4F}, //307 #FULLWIDTH LATIN SMALL LETTER O
    {0xA2F8, 0xFF50}, //308 #FULLWIDTH LATIN SMALL LETTER P
    {0xA2F9, 0xFF51}, //309 #FULLWIDTH LATIN SMALL LETTER Q
    {0xA2FA, 0xFF52}, //310 #FULLWIDTH LATIN SMALL LETTER R
    {0xA2FB, 0xFF53}, //311 #FULLWIDTH LATIN SMALL LETTER S
    {0xA2FC, 0xFF54}, //312 #FULLWIDTH LATIN SMALL LETTER T
    {0xA2FD, 0xFF55}, //313 #FULLWIDTH LATIN SMALL LETTER U
    {0xA2FE, 0xFF56}, //314 #FULLWIDTH LATIN SMALL LETTER V
    {0xA340, 0xFF57}, //315 #FULLWIDTH LATIN SMALL LETTER W
    {0xA341, 0xFF58}, //316 #FULLWIDTH LATIN SMALL LETTER X
    {0xA342, 0xFF59}, //317 #FULLWIDTH LATIN SMALL LETTER Y
    {0xA343, 0xFF5A}, //318 #FULLWIDTH LATIN SMALL LETTER Z
    {0xA344, 0x0391}, //319 #GREEK CAPITAL LETTER ALPHA
    {0xA345, 0x0392}, //320 #GREEK CAPITAL LETTER BETA
    {0xA346, 0x0393}, //321 #GREEK CAPITAL LETTER GAMMA
    {0xA347, 0x0394}, //322 #GREEK CAPITAL LETTER DELTA
    {0xA348, 0x0395}, //323 #GREEK CAPITAL LETTER EPSILON
    {0xA349, 0x0396}, //324 #GREEK CAPITAL LETTER ZETA
    {0xA34A, 0x0397}, //325 #GREEK CAPITAL LETTER ETA
    {0xA34B, 0x0398}, //326 #GREEK CAPITAL LETTER THETA
    {0xA34C, 0x0399}, //327 #GREEK CAPITAL LETTER IOTA
    {0xA34D, 0x039A}, //328 #GREEK CAPITAL LETTER KAPPA
    {0xA34E, 0x039B}, //329 #GREEK CAPITAL LETTER LAMDA
    {0xA34F, 0x039C}, //330 #GREEK CAPITAL LETTER MU
    {0xA350, 0x039D}, //331 #GREEK CAPITAL LETTER NU
    {0xA351, 0x039E}, //332 #GREEK CAPITAL LETTER XI
    {0xA352, 0x039F}, //333 #GREEK CAPITAL LETTER OMICRON
    {0xA353, 0x03A0}, //334 #GREEK CAPITAL LETTER PI
    {0xA354, 0x03A1}, //335 #GREEK CAPITAL LETTER RHO
    {0xA355, 0x03A3}, //336 #GREEK CAPITAL LETTER SIGMA
    {0xA356, 0x03A4}, //337 #GREEK CAPITAL LETTER TAU
    {0xA357, 0x03A5}, //338 #GREEK CAPITAL LETTER UPSILON
    {0xA358, 0x03A6}, //339 #GREEK CAPITAL LETTER PHI
    {0xA359, 0x03A7}, //340 #GREEK CAPITAL LETTER CHI
    {0xA35A, 0x03A8}, //341 #GREEK CAPITAL LETTER PSI
    {0xA35B, 0x03A9}, //342 #GREEK CAPITAL LETTER OMEGA
    {0xA35C, 0x03B1}, //343 #GREEK SMALL LETTER ALPHA
    {0xA35D, 0x03B2}, //344 #GREEK SMALL LETTER BETA
    {0xA35E, 0x03B3}, //345 #GREEK SMALL LETTER GAMMA
    {0xA35F, 0x03B4}, //346 #GREEK SMALL LETTER DELTA
    {0xA360, 0x03B5}, //347 #GREEK SMALL LETTER EPSILON
    {0xA361, 0x03B6}, //348 #GREEK SMALL LETTER ZETA
    {0xA362, 0x03B7}, //349 #GREEK SMALL LETTER ETA
    {0xA363, 0x03B8}, //350 #GREEK SMALL LETTER THETA
    {0xA364, 0x03B9}, //351 #GREEK SMALL LETTER IOTA
    {0xA365, 0x03BA}, //352 #GREEK SMALL LETTER KAPPA
    {0xA366, 0x03BB}, //353 #GREEK SMALL LETTER LAMDA
    {0xA367, 0x03BC}, //354 #GREEK SMALL LETTER MU
    {0xA368, 0x03BD}, //355 #GREEK SMALL LETTER NU
    {0xA369, 0x03BE}, //356 #GREEK SMALL LETTER XI
    {0xA36A, 0x03BF}, //357 #GREEK SMALL LETTER OMICRON
    {0xA36B, 0x03C0}, //358 #GREEK SMALL LETTER PI
    {0xA36C, 0x03C1}, //359 #GREEK SMALL LETTER RHO
    {0xA36D, 0x03C3}, //360 #GREEK SMALL LETTER SIGMA
    {0xA36E, 0x03C4}, //361 #GREEK SMALL LETTER TAU
    {0xA36F, 0x03C5}, //362 #GREEK SMALL LETTER UPSILON
    {0xA370, 0x03C6}, //363 #GREEK SMALL LETTER PHI
    {0xA371, 0x03C7}, //364 #GREEK SMALL LETTER CHI
    {0xA372, 0x03C8}, //365 #GREEK SMALL LETTER PSI
    {0xA373, 0x03C9}, //366 #GREEK SMALL LETTER OMEGA
    {0xA374, 0x3105}, //367 #BOPOMOFO LETTER B
    {0xA375, 0x3106}, //368 #BOPOMOFO LETTER P
    {0xA376, 0x3107}, //369 #BOPOMOFO LETTER M
    {0xA377, 0x3108}, //370 #BOPOMOFO LETTER F
    {0xA378, 0x3109}, //371 #BOPOMOFO LETTER D
    {0xA379, 0x310A}, //372 #BOPOMOFO LETTER T
    {0xA37A, 0x310B}, //373 #BOPOMOFO LETTER N
    {0xA37B, 0x310C}, //374 #BOPOMOFO LETTER L
    {0xA37C, 0x310D}, //375 #BOPOMOFO LETTER G
    {0xA37D, 0x310E}, //376 #BOPOMOFO LETTER K
    {0xA37E, 0x310F}, //377 #BOPOMOFO LETTER H
    {0xA3A1, 0x3110}, //378 #BOPOMOFO LETTER J
    {0xA3A2, 0x3111}, //379 #BOPOMOFO LETTER Q
    {0xA3A3, 0x3112}, //380 #BOPOMOFO LETTER X
    {0xA3A4, 0x3113}, //381 #BOPOMOFO LETTER ZH
    {0xA3A5, 0x3114}, //382 #BOPOMOFO LETTER CH
    {0xA3A6, 0x3115}, //383 #BOPOMOFO LETTER SH
    {0xA3A7, 0x3116}, //384 #BOPOMOFO LETTER R
    {0xA3A8, 0x3117}, //385 #BOPOMOFO LETTER Z
    {0xA3A9, 0x3118}, //386 #BOPOMOFO LETTER C
    {0xA3AA, 0x3119}, //387 #BOPOMOFO LETTER S
    {0xA3AB, 0x311A}, //388 #BOPOMOFO LETTER A
    {0xA3AC, 0x311B}, //389 #BOPOMOFO LETTER O
    {0xA3AD, 0x311C}, //390 #BOPOMOFO LETTER E
    {0xA3AE, 0x311D}, //391 #BOPOMOFO LETTER EH
    {0xA3AF, 0x311E}, //392 #BOPOMOFO LETTER AI
    {0xA3B0, 0x311F}, //393 #BOPOMOFO LETTER EI
    {0xA3B1, 0x3120}, //394 #BOPOMOFO LETTER AU
    {0xA3B2, 0x3121}, //395 #BOPOMOFO LETTER OU
    {0xA3B3, 0x3122}, //396 #BOPOMOFO LETTER AN
    {0xA3B4, 0x3123}, //397 #BOPOMOFO LETTER EN
    {0xA3B5, 0x3124}, //398 #BOPOMOFO LETTER ANG
    {0xA3B6, 0x3125}, //399 #BOPOMOFO LETTER ENG
    {0xA3B7, 0x3126}, //400 #BOPOMOFO LETTER ER
    {0xA3B8, 0x3127}, //401 #BOPOMOFO LETTER I
    {0xA3B9, 0x3128}, //402 #BOPOMOFO LETTER U
    {0xA3BA, 0x3129}, //403 #BOPOMOFO LETTER IU
    {0xA3BB, 0x02D9}, //404 #DOT ABOVE
    {0xA3BC, 0x02C9}, //405 #MODIFIER LETTER MACRON
    {0xA3BD, 0x02CA}, //406 #MODIFIER LETTER ACUTE ACCENT
    {0xA3BE, 0x02C7}, //407 #CARON
    {0xA3BF, 0x02CB}, //408 #MODIFIER LETTER GRAVE ACCENT
    {0xA3E1, 0x20AC}, //409 #EURO SIGN
    {0xA440, 0x4E00}, //410 #CJK UNIFIED IDEOGRAPH
    {0xA441, 0x4E59}, //411 #CJK UNIFIED IDEOGRAPH
    {0xA442, 0x4E01}, //412 #CJK UNIFIED IDEOGRAPH
    {0xA443, 0x4E03}, //413 #CJK UNIFIED IDEOGRAPH
    {0xA444, 0x4E43}, //414 #CJK UNIFIED IDEOGRAPH
    {0xA445, 0x4E5D}, //415 #CJK UNIFIED IDEOGRAPH
    {0xA446, 0x4E86}, //416 #CJK UNIFIED IDEOGRAPH
    {0xA447, 0x4E8C}, //417 #CJK UNIFIED IDEOGRAPH
    {0xA448, 0x4EBA}, //418 #CJK UNIFIED IDEOGRAPH
    {0xA449, 0x513F}, //419 #CJK UNIFIED IDEOGRAPH
    {0xA44A, 0x5165}, //420 #CJK UNIFIED IDEOGRAPH
    {0xA44B, 0x516B}, //421 #CJK UNIFIED IDEOGRAPH
    {0xA44C, 0x51E0}, //422 #CJK UNIFIED IDEOGRAPH
    {0xA44D, 0x5200}, //423 #CJK UNIFIED IDEOGRAPH
    {0xA44E, 0x5201}, //424 #CJK UNIFIED IDEOGRAPH
    {0xA44F, 0x529B}, //425 #CJK UNIFIED IDEOGRAPH
    {0xA450, 0x5315}, //426 #CJK UNIFIED IDEOGRAPH
    {0xA451, 0x5341}, //427 #CJK UNIFIED IDEOGRAPH
    {0xA452, 0x535C}, //428 #CJK UNIFIED IDEOGRAPH
    {0xA453, 0x53C8}, //429 #CJK UNIFIED IDEOGRAPH
    {0xA454, 0x4E09}, //430 #CJK UNIFIED IDEOGRAPH
    {0xA455, 0x4E0B}, //431 #CJK UNIFIED IDEOGRAPH
    {0xA456, 0x4E08}, //432 #CJK UNIFIED IDEOGRAPH
    {0xA457, 0x4E0A}, //433 #CJK UNIFIED IDEOGRAPH
    {0xA458, 0x4E2B}, //434 #CJK UNIFIED IDEOGRAPH
    {0xA459, 0x4E38}, //435 #CJK UNIFIED IDEOGRAPH
    {0xA45A, 0x51E1}, //436 #CJK UNIFIED IDEOGRAPH
    {0xA45B, 0x4E45}, //437 #CJK UNIFIED IDEOGRAPH
    {0xA45C, 0x4E48}, //438 #CJK UNIFIED IDEOGRAPH
    {0xA45D, 0x4E5F}, //439 #CJK UNIFIED IDEOGRAPH
    {0xA45E, 0x4E5E}, //440 #CJK UNIFIED IDEOGRAPH
    {0xA45F, 0x4E8E}, //441 #CJK UNIFIED IDEOGRAPH
    {0xA460, 0x4EA1}, //442 #CJK UNIFIED IDEOGRAPH
    {0xA461, 0x5140}, //443 #CJK UNIFIED IDEOGRAPH
    {0xA462, 0x5203}, //444 #CJK UNIFIED IDEOGRAPH
    {0xA463, 0x52FA}, //445 #CJK UNIFIED IDEOGRAPH
    {0xA464, 0x5343}, //446 #CJK UNIFIED IDEOGRAPH
    {0xA465, 0x53C9}, //447 #CJK UNIFIED IDEOGRAPH
    {0xA466, 0x53E3}, //448 #CJK UNIFIED IDEOGRAPH
    {0xA467, 0x571F}, //449 #CJK UNIFIED IDEOGRAPH
    {0xA468, 0x58EB}, //450 #CJK UNIFIED IDEOGRAPH
    {0xA469, 0x5915}, //451 #CJK UNIFIED IDEOGRAPH
    {0xA46A, 0x5927}, //452 #CJK UNIFIED IDEOGRAPH
    {0xA46B, 0x5973}, //453 #CJK UNIFIED IDEOGRAPH
    {0xA46C, 0x5B50}, //454 #CJK UNIFIED IDEOGRAPH
    {0xA46D, 0x5B51}, //455 #CJK UNIFIED IDEOGRAPH
    {0xA46E, 0x5B53}, //456 #CJK UNIFIED IDEOGRAPH
    {0xA46F, 0x5BF8}, //457 #CJK UNIFIED IDEOGRAPH
    {0xA470, 0x5C0F}, //458 #CJK UNIFIED IDEOGRAPH
    {0xA471, 0x5C22}, //459 #CJK UNIFIED IDEOGRAPH
    {0xA472, 0x5C38}, //460 #CJK UNIFIED IDEOGRAPH
    {0xA473, 0x5C71}, //461 #CJK UNIFIED IDEOGRAPH
    {0xA474, 0x5DDD}, //462 #CJK UNIFIED IDEOGRAPH
    {0xA475, 0x5DE5}, //463 #CJK UNIFIED IDEOGRAPH
    {0xA476, 0x5DF1}, //464 #CJK UNIFIED IDEOGRAPH
    {0xA477, 0x5DF2}, //465 #CJK UNIFIED IDEOGRAPH
    {0xA478, 0x5DF3}, //466 #CJK UNIFIED IDEOGRAPH
    {0xA479, 0x5DFE}, //467 #CJK UNIFIED IDEOGRAPH
    {0xA47A, 0x5E72}, //468 #CJK UNIFIED IDEOGRAPH
    {0xA47B, 0x5EFE}, //469 #CJK UNIFIED IDEOGRAPH
    {0xA47C, 0x5F0B}, //470 #CJK UNIFIED IDEOGRAPH
    {0xA47D, 0x5F13}, //471 #CJK UNIFIED IDEOGRAPH
    {0xA47E, 0x624D}, //472 #CJK UNIFIED IDEOGRAPH
    {0xA4A1, 0x4E11}, //473 #CJK UNIFIED IDEOGRAPH
    {0xA4A2, 0x4E10}, //474 #CJK UNIFIED IDEOGRAPH
    {0xA4A3, 0x4E0D}, //475 #CJK UNIFIED IDEOGRAPH
    {0xA4A4, 0x4E2D}, //476 #CJK UNIFIED IDEOGRAPH
    {0xA4A5, 0x4E30}, //477 #CJK UNIFIED IDEOGRAPH
    {0xA4A6, 0x4E39}, //478 #CJK UNIFIED IDEOGRAPH
    {0xA4A7, 0x4E4B}, //479 #CJK UNIFIED IDEOGRAPH
    {0xA4A8, 0x5C39}, //480 #CJK UNIFIED IDEOGRAPH
    {0xA4A9, 0x4E88}, //481 #CJK UNIFIED IDEOGRAPH
    {0xA4AA, 0x4E91}, //482 #CJK UNIFIED IDEOGRAPH
    {0xA4AB, 0x4E95}, //483 #CJK UNIFIED IDEOGRAPH
    {0xA4AC, 0x4E92}, //484 #CJK UNIFIED IDEOGRAPH
    {0xA4AD, 0x4E94}, //485 #CJK UNIFIED IDEOGRAPH
    {0xA4AE, 0x4EA2}, //486 #CJK UNIFIED IDEOGRAPH
    {0xA4AF, 0x4EC1}, //487 #CJK UNIFIED IDEOGRAPH
    {0xA4B0, 0x4EC0}, //488 #CJK UNIFIED IDEOGRAPH
    {0xA4B1, 0x4EC3}, //489 #CJK UNIFIED IDEOGRAPH
    {0xA4B2, 0x4EC6}, //490 #CJK UNIFIED IDEOGRAPH
    {0xA4B3, 0x4EC7}, //491 #CJK UNIFIED IDEOGRAPH
    {0xA4B4, 0x4ECD}, //492 #CJK UNIFIED IDEOGRAPH
    {0xA4B5, 0x4ECA}, //493 #CJK UNIFIED IDEOGRAPH
    {0xA4B6, 0x4ECB}, //494 #CJK UNIFIED IDEOGRAPH
    {0xA4B7, 0x4EC4}, //495 #CJK UNIFIED IDEOGRAPH
    {0xA4B8, 0x5143}, //496 #CJK UNIFIED IDEOGRAPH
    {0xA4B9, 0x5141}, //497 #CJK UNIFIED IDEOGRAPH
    {0xA4BA, 0x5167}, //498 #CJK UNIFIED IDEOGRAPH
    {0xA4BB, 0x516D}, //499 #CJK UNIFIED IDEOGRAPH
    {0xA4BC, 0x516E}, //500 #CJK UNIFIED IDEOGRAPH
    {0xA4BD, 0x516C}, //501 #CJK UNIFIED IDEOGRAPH
    {0xA4BE, 0x5197}, //502 #CJK UNIFIED IDEOGRAPH
    {0xA4BF, 0x51F6}, //503 #CJK UNIFIED IDEOGRAPH
    {0xA4C0, 0x5206}, //504 #CJK UNIFIED IDEOGRAPH
    {0xA4C1, 0x5207}, //505 #CJK UNIFIED IDEOGRAPH
    {0xA4C2, 0x5208}, //506 #CJK UNIFIED IDEOGRAPH
    {0xA4C3, 0x52FB}, //507 #CJK UNIFIED IDEOGRAPH
    {0xA4C4, 0x52FE}, //508 #CJK UNIFIED IDEOGRAPH
    {0xA4C5, 0x52FF}, //509 #CJK UNIFIED IDEOGRAPH
    {0xA4C6, 0x5316}, //510 #CJK UNIFIED IDEOGRAPH
    {0xA4C7, 0x5339}, //511 #CJK UNIFIED IDEOGRAPH
    {0xA4C8, 0x5348}, //512 #CJK UNIFIED IDEOGRAPH
    {0xA4C9, 0x5347}, //513 #CJK UNIFIED IDEOGRAPH
    {0xA4CA, 0x5345}, //514 #CJK UNIFIED IDEOGRAPH
    {0xA4CB, 0x535E}, //515 #CJK UNIFIED IDEOGRAPH
    {0xA4CC, 0x5384}, //516 #CJK UNIFIED IDEOGRAPH
    {0xA4CD, 0x53CB}, //517 #CJK UNIFIED IDEOGRAPH
    {0xA4CE, 0x53CA}, //518 #CJK UNIFIED IDEOGRAPH
    {0xA4CF, 0x53CD}, //519 #CJK UNIFIED IDEOGRAPH
    {0xA4D0, 0x58EC}, //520 #CJK UNIFIED IDEOGRAPH
    {0xA4D1, 0x5929}, //521 #CJK UNIFIED IDEOGRAPH
    {0xA4D2, 0x592B}, //522 #CJK UNIFIED IDEOGRAPH
    {0xA4D3, 0x592A}, //523 #CJK UNIFIED IDEOGRAPH
    {0xA4D4, 0x592D}, //524 #CJK UNIFIED IDEOGRAPH
    {0xA4D5, 0x5B54}, //525 #CJK UNIFIED IDEOGRAPH
    {0xA4D6, 0x5C11}, //526 #CJK UNIFIED IDEOGRAPH
    {0xA4D7, 0x5C24}, //527 #CJK UNIFIED IDEOGRAPH
    {0xA4D8, 0x5C3A}, //528 #CJK UNIFIED IDEOGRAPH
    {0xA4D9, 0x5C6F}, //529 #CJK UNIFIED IDEOGRAPH
    {0xA4DA, 0x5DF4}, //530 #CJK UNIFIED IDEOGRAPH
    {0xA4DB, 0x5E7B}, //531 #CJK UNIFIED IDEOGRAPH
    {0xA4DC, 0x5EFF}, //532 #CJK UNIFIED IDEOGRAPH
    {0xA4DD, 0x5F14}, //533 #CJK UNIFIED IDEOGRAPH
    {0xA4DE, 0x5F15}, //534 #CJK UNIFIED IDEOGRAPH
    {0xA4DF, 0x5FC3}, //535 #CJK UNIFIED IDEOGRAPH
    {0xA4E0, 0x6208}, //536 #CJK UNIFIED IDEOGRAPH
    {0xA4E1, 0x6236}, //537 #CJK UNIFIED IDEOGRAPH
    {0xA4E2, 0x624B}, //538 #CJK UNIFIED IDEOGRAPH
    {0xA4E3, 0x624E}, //539 #CJK UNIFIED IDEOGRAPH
    {0xA4E4, 0x652F}, //540 #CJK UNIFIED IDEOGRAPH
    {0xA4E5, 0x6587}, //541 #CJK UNIFIED IDEOGRAPH
    {0xA4E6, 0x6597}, //542 #CJK UNIFIED IDEOGRAPH
    {0xA4E7, 0x65A4}, //543 #CJK UNIFIED IDEOGRAPH
    {0xA4E8, 0x65B9}, //544 #CJK UNIFIED IDEOGRAPH
    {0xA4E9, 0x65E5}, //545 #CJK UNIFIED IDEOGRAPH
    {0xA4EA, 0x66F0}, //546 #CJK UNIFIED IDEOGRAPH
    {0xA4EB, 0x6708}, //547 #CJK UNIFIED IDEOGRAPH
    {0xA4EC, 0x6728}, //548 #CJK UNIFIED IDEOGRAPH
    {0xA4ED, 0x6B20}, //549 #CJK UNIFIED IDEOGRAPH
    {0xA4EE, 0x6B62}, //550 #CJK UNIFIED IDEOGRAPH
    {0xA4EF, 0x6B79}, //551 #CJK UNIFIED IDEOGRAPH
    {0xA4F0, 0x6BCB}, //552 #CJK UNIFIED IDEOGRAPH
    {0xA4F1, 0x6BD4}, //553 #CJK UNIFIED IDEOGRAPH
    {0xA4F2, 0x6BDB}, //554 #CJK UNIFIED IDEOGRAPH
    {0xA4F3, 0x6C0F}, //555 #CJK UNIFIED IDEOGRAPH
    {0xA4F4, 0x6C34}, //556 #CJK UNIFIED IDEOGRAPH
    {0xA4F5, 0x706B}, //557 #CJK UNIFIED IDEOGRAPH
    {0xA4F6, 0x722A}, //558 #CJK UNIFIED IDEOGRAPH
    {0xA4F7, 0x7236}, //559 #CJK UNIFIED IDEOGRAPH
    {0xA4F8, 0x723B}, //560 #CJK UNIFIED IDEOGRAPH
    {0xA4F9, 0x7247}, //561 #CJK UNIFIED IDEOGRAPH
    {0xA4FA, 0x7259}, //562 #CJK UNIFIED IDEOGRAPH
    {0xA4FB, 0x725B}, //563 #CJK UNIFIED IDEOGRAPH
    {0xA4FC, 0x72AC}, //564 #CJK UNIFIED IDEOGRAPH
    {0xA4FD, 0x738B}, //565 #CJK UNIFIED IDEOGRAPH
    {0xA4FE, 0x4E19}, //566 #CJK UNIFIED IDEOGRAPH
    {0xA540, 0x4E16}, //567 #CJK UNIFIED IDEOGRAPH
    {0xA541, 0x4E15}, //568 #CJK UNIFIED IDEOGRAPH
    {0xA542, 0x4E14}, //569 #CJK UNIFIED IDEOGRAPH
    {0xA543, 0x4E18}, //570 #CJK UNIFIED IDEOGRAPH
    {0xA544, 0x4E3B}, //571 #CJK UNIFIED IDEOGRAPH
    {0xA545, 0x4E4D}, //572 #CJK UNIFIED IDEOGRAPH
    {0xA546, 0x4E4F}, //573 #CJK UNIFIED IDEOGRAPH
    {0xA547, 0x4E4E}, //574 #CJK UNIFIED IDEOGRAPH
    {0xA548, 0x4EE5}, //575 #CJK UNIFIED IDEOGRAPH
    {0xA549, 0x4ED8}, //576 #CJK UNIFIED IDEOGRAPH
    {0xA54A, 0x4ED4}, //577 #CJK UNIFIED IDEOGRAPH
    {0xA54B, 0x4ED5}, //578 #CJK UNIFIED IDEOGRAPH
    {0xA54C, 0x4ED6}, //579 #CJK UNIFIED IDEOGRAPH
    {0xA54D, 0x4ED7}, //580 #CJK UNIFIED IDEOGRAPH
    {0xA54E, 0x4EE3}, //581 #CJK UNIFIED IDEOGRAPH
    {0xA54F, 0x4EE4}, //582 #CJK UNIFIED IDEOGRAPH
    {0xA550, 0x4ED9}, //583 #CJK UNIFIED IDEOGRAPH
    {0xA551, 0x4EDE}, //584 #CJK UNIFIED IDEOGRAPH
    {0xA552, 0x5145}, //585 #CJK UNIFIED IDEOGRAPH
    {0xA553, 0x5144}, //586 #CJK UNIFIED IDEOGRAPH
    {0xA554, 0x5189}, //587 #CJK UNIFIED IDEOGRAPH
    {0xA555, 0x518A}, //588 #CJK UNIFIED IDEOGRAPH
    {0xA556, 0x51AC}, //589 #CJK UNIFIED IDEOGRAPH
    {0xA557, 0x51F9}, //590 #CJK UNIFIED IDEOGRAPH
    {0xA558, 0x51FA}, //591 #CJK UNIFIED IDEOGRAPH
    {0xA559, 0x51F8}, //592 #CJK UNIFIED IDEOGRAPH
    {0xA55A, 0x520A}, //593 #CJK UNIFIED IDEOGRAPH
    {0xA55B, 0x52A0}, //594 #CJK UNIFIED IDEOGRAPH
    {0xA55C, 0x529F}, //595 #CJK UNIFIED IDEOGRAPH
    {0xA55D, 0x5305}, //596 #CJK UNIFIED IDEOGRAPH
    {0xA55E, 0x5306}, //597 #CJK UNIFIED IDEOGRAPH
    {0xA55F, 0x5317}, //598 #CJK UNIFIED IDEOGRAPH
    {0xA560, 0x531D}, //599 #CJK UNIFIED IDEOGRAPH
    {0xA561, 0x4EDF}, //600 #CJK UNIFIED IDEOGRAPH
    {0xA562, 0x534A}, //601 #CJK UNIFIED IDEOGRAPH
    {0xA563, 0x5349}, //602 #CJK UNIFIED IDEOGRAPH
    {0xA564, 0x5361}, //603 #CJK UNIFIED IDEOGRAPH
    {0xA565, 0x5360}, //604 #CJK UNIFIED IDEOGRAPH
    {0xA566, 0x536F}, //605 #CJK UNIFIED IDEOGRAPH
    {0xA567, 0x536E}, //606 #CJK UNIFIED IDEOGRAPH
    {0xA568, 0x53BB}, //607 #CJK UNIFIED IDEOGRAPH
    {0xA569, 0x53EF}, //608 #CJK UNIFIED IDEOGRAPH
    {0xA56A, 0x53E4}, //609 #CJK UNIFIED IDEOGRAPH
    {0xA56B, 0x53F3}, //610 #CJK UNIFIED IDEOGRAPH
    {0xA56C, 0x53EC}, //611 #CJK UNIFIED IDEOGRAPH
    {0xA56D, 0x53EE}, //612 #CJK UNIFIED IDEOGRAPH
    {0xA56E, 0x53E9}, //613 #CJK UNIFIED IDEOGRAPH
    {0xA56F, 0x53E8}, //614 #CJK UNIFIED IDEOGRAPH
    {0xA570, 0x53FC}, //615 #CJK UNIFIED IDEOGRAPH
    {0xA571, 0x53F8}, //616 #CJK UNIFIED IDEOGRAPH
    {0xA572, 0x53F5}, //617 #CJK UNIFIED IDEOGRAPH
    {0xA573, 0x53EB}, //618 #CJK UNIFIED IDEOGRAPH
    {0xA574, 0x53E6}, //619 #CJK UNIFIED IDEOGRAPH
    {0xA575, 0x53EA}, //620 #CJK UNIFIED IDEOGRAPH
    {0xA576, 0x53F2}, //621 #CJK UNIFIED IDEOGRAPH
    {0xA577, 0x53F1}, //622 #CJK UNIFIED IDEOGRAPH
    {0xA578, 0x53F0}, //623 #CJK UNIFIED IDEOGRAPH
    {0xA579, 0x53E5}, //624 #CJK UNIFIED IDEOGRAPH
    {0xA57A, 0x53ED}, //625 #CJK UNIFIED IDEOGRAPH
    {0xA57B, 0x53FB}, //626 #CJK UNIFIED IDEOGRAPH
    {0xA57C, 0x56DB}, //627 #CJK UNIFIED IDEOGRAPH
    {0xA57D, 0x56DA}, //628 #CJK UNIFIED IDEOGRAPH
    {0xA57E, 0x5916}, //629 #CJK UNIFIED IDEOGRAPH
    {0xA5A1, 0x592E}, //630 #CJK UNIFIED IDEOGRAPH
    {0xA5A2, 0x5931}, //631 #CJK UNIFIED IDEOGRAPH
    {0xA5A3, 0x5974}, //632 #CJK UNIFIED IDEOGRAPH
    {0xA5A4, 0x5976}, //633 #CJK UNIFIED IDEOGRAPH
    {0xA5A5, 0x5B55}, //634 #CJK UNIFIED IDEOGRAPH
    {0xA5A6, 0x5B83}, //635 #CJK UNIFIED IDEOGRAPH
    {0xA5A7, 0x5C3C}, //636 #CJK UNIFIED IDEOGRAPH
    {0xA5A8, 0x5DE8}, //637 #CJK UNIFIED IDEOGRAPH
    {0xA5A9, 0x5DE7}, //638 #CJK UNIFIED IDEOGRAPH
    {0xA5AA, 0x5DE6}, //639 #CJK UNIFIED IDEOGRAPH
    {0xA5AB, 0x5E02}, //640 #CJK UNIFIED IDEOGRAPH
    {0xA5AC, 0x5E03}, //641 #CJK UNIFIED IDEOGRAPH
    {0xA5AD, 0x5E73}, //642 #CJK UNIFIED IDEOGRAPH
    {0xA5AE, 0x5E7C}, //643 #CJK UNIFIED IDEOGRAPH
    {0xA5AF, 0x5F01}, //644 #CJK UNIFIED IDEOGRAPH
    {0xA5B0, 0x5F18}, //645 #CJK UNIFIED IDEOGRAPH
    {0xA5B1, 0x5F17}, //646 #CJK UNIFIED IDEOGRAPH
    {0xA5B2, 0x5FC5}, //647 #CJK UNIFIED IDEOGRAPH
    {0xA5B3, 0x620A}, //648 #CJK UNIFIED IDEOGRAPH
    {0xA5B4, 0x6253}, //649 #CJK UNIFIED IDEOGRAPH
    {0xA5B5, 0x6254}, //650 #CJK UNIFIED IDEOGRAPH
    {0xA5B6, 0x6252}, //651 #CJK UNIFIED IDEOGRAPH
    {0xA5B7, 0x6251}, //652 #CJK UNIFIED IDEOGRAPH
    {0xA5B8, 0x65A5}, //653 #CJK UNIFIED IDEOGRAPH
    {0xA5B9, 0x65E6}, //654 #CJK UNIFIED IDEOGRAPH
    {0xA5BA, 0x672E}, //655 #CJK UNIFIED IDEOGRAPH
    {0xA5BB, 0x672C}, //656 #CJK UNIFIED IDEOGRAPH
    {0xA5BC, 0x672A}, //657 #CJK UNIFIED IDEOGRAPH
    {0xA5BD, 0x672B}, //658 #CJK UNIFIED IDEOGRAPH
    {0xA5BE, 0x672D}, //659 #CJK UNIFIED IDEOGRAPH
    {0xA5BF, 0x6B63}, //660 #CJK UNIFIED IDEOGRAPH
    {0xA5C0, 0x6BCD}, //661 #CJK UNIFIED IDEOGRAPH
    {0xA5C1, 0x6C11}, //662 #CJK UNIFIED IDEOGRAPH
    {0xA5C2, 0x6C10}, //663 #CJK UNIFIED IDEOGRAPH
    {0xA5C3, 0x6C38}, //664 #CJK UNIFIED IDEOGRAPH
    {0xA5C4, 0x6C41}, //665 #CJK UNIFIED IDEOGRAPH
    {0xA5C5, 0x6C40}, //666 #CJK UNIFIED IDEOGRAPH
    {0xA5C6, 0x6C3E}, //667 #CJK UNIFIED IDEOGRAPH
    {0xA5C7, 0x72AF}, //668 #CJK UNIFIED IDEOGRAPH
    {0xA5C8, 0x7384}, //669 #CJK UNIFIED IDEOGRAPH
    {0xA5C9, 0x7389}, //670 #CJK UNIFIED IDEOGRAPH
    {0xA5CA, 0x74DC}, //671 #CJK UNIFIED IDEOGRAPH
    {0xA5CB, 0x74E6}, //672 #CJK UNIFIED IDEOGRAPH
    {0xA5CC, 0x7518}, //673 #CJK UNIFIED IDEOGRAPH
    {0xA5CD, 0x751F}, //674 #CJK UNIFIED IDEOGRAPH
    {0xA5CE, 0x7528}, //675 #CJK UNIFIED IDEOGRAPH
    {0xA5CF, 0x7529}, //676 #CJK UNIFIED IDEOGRAPH
    {0xA5D0, 0x7530}, //677 #CJK UNIFIED IDEOGRAPH
    {0xA5D1, 0x7531}, //678 #CJK UNIFIED IDEOGRAPH
    {0xA5D2, 0x7532}, //679 #CJK UNIFIED IDEOGRAPH
    {0xA5D3, 0x7533}, //680 #CJK UNIFIED IDEOGRAPH
    {0xA5D4, 0x758B}, //681 #CJK UNIFIED IDEOGRAPH
    {0xA5D5, 0x767D}, //682 #CJK UNIFIED IDEOGRAPH
    {0xA5D6, 0x76AE}, //683 #CJK UNIFIED IDEOGRAPH
    {0xA5D7, 0x76BF}, //684 #CJK UNIFIED IDEOGRAPH
    {0xA5D8, 0x76EE}, //685 #CJK UNIFIED IDEOGRAPH
    {0xA5D9, 0x77DB}, //686 #CJK UNIFIED IDEOGRAPH
    {0xA5DA, 0x77E2}, //687 #CJK UNIFIED IDEOGRAPH
    {0xA5DB, 0x77F3}, //688 #CJK UNIFIED IDEOGRAPH
    {0xA5DC, 0x793A}, //689 #CJK UNIFIED IDEOGRAPH
    {0xA5DD, 0x79BE}, //690 #CJK UNIFIED IDEOGRAPH
    {0xA5DE, 0x7A74}, //691 #CJK UNIFIED IDEOGRAPH
    {0xA5DF, 0x7ACB}, //692 #CJK UNIFIED IDEOGRAPH
    {0xA5E0, 0x4E1E}, //693 #CJK UNIFIED IDEOGRAPH
    {0xA5E1, 0x4E1F}, //694 #CJK UNIFIED IDEOGRAPH
    {0xA5E2, 0x4E52}, //695 #CJK UNIFIED IDEOGRAPH
    {0xA5E3, 0x4E53}, //696 #CJK UNIFIED IDEOGRAPH
    {0xA5E4, 0x4E69}, //697 #CJK UNIFIED IDEOGRAPH
    {0xA5E5, 0x4E99}, //698 #CJK UNIFIED IDEOGRAPH
    {0xA5E6, 0x4EA4}, //699 #CJK UNIFIED IDEOGRAPH
    {0xA5E7, 0x4EA6}, //700 #CJK UNIFIED IDEOGRAPH
    {0xA5E8, 0x4EA5}, //701 #CJK UNIFIED IDEOGRAPH
    {0xA5E9, 0x4EFF}, //702 #CJK UNIFIED IDEOGRAPH
    {0xA5EA, 0x4F09}, //703 #CJK UNIFIED IDEOGRAPH
    {0xA5EB, 0x4F19}, //704 #CJK UNIFIED IDEOGRAPH
    {0xA5EC, 0x4F0A}, //705 #CJK UNIFIED IDEOGRAPH
    {0xA5ED, 0x4F15}, //706 #CJK UNIFIED IDEOGRAPH
    {0xA5EE, 0x4F0D}, //707 #CJK UNIFIED IDEOGRAPH
    {0xA5EF, 0x4F10}, //708 #CJK UNIFIED IDEOGRAPH
    {0xA5F0, 0x4F11}, //709 #CJK UNIFIED IDEOGRAPH
    {0xA5F1, 0x4F0F}, //710 #CJK UNIFIED IDEOGRAPH
    {0xA5F2, 0x4EF2}, //711 #CJK UNIFIED IDEOGRAPH
    {0xA5F3, 0x4EF6}, //712 #CJK UNIFIED IDEOGRAPH
    {0xA5F4, 0x4EFB}, //713 #CJK UNIFIED IDEOGRAPH
    {0xA5F5, 0x4EF0}, //714 #CJK UNIFIED IDEOGRAPH
    {0xA5F6, 0x4EF3}, //715 #CJK UNIFIED IDEOGRAPH
    {0xA5F7, 0x4EFD}, //716 #CJK UNIFIED IDEOGRAPH
    {0xA5F8, 0x4F01}, //717 #CJK UNIFIED IDEOGRAPH
    {0xA5F9, 0x4F0B}, //718 #CJK UNIFIED IDEOGRAPH
    {0xA5FA, 0x5149}, //719 #CJK UNIFIED IDEOGRAPH
    {0xA5FB, 0x5147}, //720 #CJK UNIFIED IDEOGRAPH
    {0xA5FC, 0x5146}, //721 #CJK UNIFIED IDEOGRAPH
    {0xA5FD, 0x5148}, //722 #CJK UNIFIED IDEOGRAPH
    {0xA5FE, 0x5168}, //723 #CJK UNIFIED IDEOGRAPH
    {0xA640, 0x5171}, //724 #CJK UNIFIED IDEOGRAPH
    {0xA641, 0x518D}, //725 #CJK UNIFIED IDEOGRAPH
    {0xA642, 0x51B0}, //726 #CJK UNIFIED IDEOGRAPH
    {0xA643, 0x5217}, //727 #CJK UNIFIED IDEOGRAPH
    {0xA644, 0x5211}, //728 #CJK UNIFIED IDEOGRAPH
    {0xA645, 0x5212}, //729 #CJK UNIFIED IDEOGRAPH
    {0xA646, 0x520E}, //730 #CJK UNIFIED IDEOGRAPH
    {0xA647, 0x5216}, //731 #CJK UNIFIED IDEOGRAPH
    {0xA648, 0x52A3}, //732 #CJK UNIFIED IDEOGRAPH
    {0xA649, 0x5308}, //733 #CJK UNIFIED IDEOGRAPH
    {0xA64A, 0x5321}, //734 #CJK UNIFIED IDEOGRAPH
    {0xA64B, 0x5320}, //735 #CJK UNIFIED IDEOGRAPH
    {0xA64C, 0x5370}, //736 #CJK UNIFIED IDEOGRAPH
    {0xA64D, 0x5371}, //737 #CJK UNIFIED IDEOGRAPH
    {0xA64E, 0x5409}, //738 #CJK UNIFIED IDEOGRAPH
    {0xA64F, 0x540F}, //739 #CJK UNIFIED IDEOGRAPH
    {0xA650, 0x540C}, //740 #CJK UNIFIED IDEOGRAPH
    {0xA651, 0x540A}, //741 #CJK UNIFIED IDEOGRAPH
    {0xA652, 0x5410}, //742 #CJK UNIFIED IDEOGRAPH
    {0xA653, 0x5401}, //743 #CJK UNIFIED IDEOGRAPH
    {0xA654, 0x540B}, //744 #CJK UNIFIED IDEOGRAPH
    {0xA655, 0x5404}, //745 #CJK UNIFIED IDEOGRAPH
    {0xA656, 0x5411}, //746 #CJK UNIFIED IDEOGRAPH
    {0xA657, 0x540D}, //747 #CJK UNIFIED IDEOGRAPH
    {0xA658, 0x5408}, //748 #CJK UNIFIED IDEOGRAPH
    {0xA659, 0x5403}, //749 #CJK UNIFIED IDEOGRAPH
    {0xA65A, 0x540E}, //750 #CJK UNIFIED IDEOGRAPH
    {0xA65B, 0x5406}, //751 #CJK UNIFIED IDEOGRAPH
    {0xA65C, 0x5412}, //752 #CJK UNIFIED IDEOGRAPH
    {0xA65D, 0x56E0}, //753 #CJK UNIFIED IDEOGRAPH
    {0xA65E, 0x56DE}, //754 #CJK UNIFIED IDEOGRAPH
    {0xA65F, 0x56DD}, //755 #CJK UNIFIED IDEOGRAPH
    {0xA660, 0x5733}, //756 #CJK UNIFIED IDEOGRAPH
    {0xA661, 0x5730}, //757 #CJK UNIFIED IDEOGRAPH
    {0xA662, 0x5728}, //758 #CJK UNIFIED IDEOGRAPH
    {0xA663, 0x572D}, //759 #CJK UNIFIED IDEOGRAPH
    {0xA664, 0x572C}, //760 #CJK UNIFIED IDEOGRAPH
    {0xA665, 0x572F}, //761 #CJK UNIFIED IDEOGRAPH
    {0xA666, 0x5729}, //762 #CJK UNIFIED IDEOGRAPH
    {0xA667, 0x5919}, //763 #CJK UNIFIED IDEOGRAPH
    {0xA668, 0x591A}, //764 #CJK UNIFIED IDEOGRAPH
    {0xA669, 0x5937}, //765 #CJK UNIFIED IDEOGRAPH
    {0xA66A, 0x5938}, //766 #CJK UNIFIED IDEOGRAPH
    {0xA66B, 0x5984}, //767 #CJK UNIFIED IDEOGRAPH
    {0xA66C, 0x5978}, //768 #CJK UNIFIED IDEOGRAPH
    {0xA66D, 0x5983}, //769 #CJK UNIFIED IDEOGRAPH
    {0xA66E, 0x597D}, //770 #CJK UNIFIED IDEOGRAPH
    {0xA66F, 0x5979}, //771 #CJK UNIFIED IDEOGRAPH
    {0xA670, 0x5982}, //772 #CJK UNIFIED IDEOGRAPH
    {0xA671, 0x5981}, //773 #CJK UNIFIED IDEOGRAPH
    {0xA672, 0x5B57}, //774 #CJK UNIFIED IDEOGRAPH
    {0xA673, 0x5B58}, //775 #CJK UNIFIED IDEOGRAPH
    {0xA674, 0x5B87}, //776 #CJK UNIFIED IDEOGRAPH
    {0xA675, 0x5B88}, //777 #CJK UNIFIED IDEOGRAPH
    {0xA676, 0x5B85}, //778 #CJK UNIFIED IDEOGRAPH
    {0xA677, 0x5B89}, //779 #CJK UNIFIED IDEOGRAPH
    {0xA678, 0x5BFA}, //780 #CJK UNIFIED IDEOGRAPH
    {0xA679, 0x5C16}, //781 #CJK UNIFIED IDEOGRAPH
    {0xA67A, 0x5C79}, //782 #CJK UNIFIED IDEOGRAPH
    {0xA67B, 0x5DDE}, //783 #CJK UNIFIED IDEOGRAPH
    {0xA67C, 0x5E06}, //784 #CJK UNIFIED IDEOGRAPH
    {0xA67D, 0x5E76}, //785 #CJK UNIFIED IDEOGRAPH
    {0xA67E, 0x5E74}, //786 #CJK UNIFIED IDEOGRAPH
    {0xA6A1, 0x5F0F}, //787 #CJK UNIFIED IDEOGRAPH
    {0xA6A2, 0x5F1B}, //788 #CJK UNIFIED IDEOGRAPH
    {0xA6A3, 0x5FD9}, //789 #CJK UNIFIED IDEOGRAPH
    {0xA6A4, 0x5FD6}, //790 #CJK UNIFIED IDEOGRAPH
    {0xA6A5, 0x620E}, //791 #CJK UNIFIED IDEOGRAPH
    {0xA6A6, 0x620C}, //792 #CJK UNIFIED IDEOGRAPH
    {0xA6A7, 0x620D}, //793 #CJK UNIFIED IDEOGRAPH
    {0xA6A8, 0x6210}, //794 #CJK UNIFIED IDEOGRAPH
    {0xA6A9, 0x6263}, //795 #CJK UNIFIED IDEOGRAPH
    {0xA6AA, 0x625B}, //796 #CJK UNIFIED IDEOGRAPH
    {0xA6AB, 0x6258}, //797 #CJK UNIFIED IDEOGRAPH
    {0xA6AC, 0x6536}, //798 #CJK UNIFIED IDEOGRAPH
    {0xA6AD, 0x65E9}, //799 #CJK UNIFIED IDEOGRAPH
    {0xA6AE, 0x65E8}, //800 #CJK UNIFIED IDEOGRAPH
    {0xA6AF, 0x65EC}, //801 #CJK UNIFIED IDEOGRAPH
    {0xA6B0, 0x65ED}, //802 #CJK UNIFIED IDEOGRAPH
    {0xA6B1, 0x66F2}, //803 #CJK UNIFIED IDEOGRAPH
    {0xA6B2, 0x66F3}, //804 #CJK UNIFIED IDEOGRAPH
    {0xA6B3, 0x6709}, //805 #CJK UNIFIED IDEOGRAPH
    {0xA6B4, 0x673D}, //806 #CJK UNIFIED IDEOGRAPH
    {0xA6B5, 0x6734}, //807 #CJK UNIFIED IDEOGRAPH
    {0xA6B6, 0x6731}, //808 #CJK UNIFIED IDEOGRAPH
    {0xA6B7, 0x6735}, //809 #CJK UNIFIED IDEOGRAPH
    {0xA6B8, 0x6B21}, //810 #CJK UNIFIED IDEOGRAPH
    {0xA6B9, 0x6B64}, //811 #CJK UNIFIED IDEOGRAPH
    {0xA6BA, 0x6B7B}, //812 #CJK UNIFIED IDEOGRAPH
    {0xA6BB, 0x6C16}, //813 #CJK UNIFIED IDEOGRAPH
    {0xA6BC, 0x6C5D}, //814 #CJK UNIFIED IDEOGRAPH
    {0xA6BD, 0x6C57}, //815 #CJK UNIFIED IDEOGRAPH
    {0xA6BE, 0x6C59}, //816 #CJK UNIFIED IDEOGRAPH
    {0xA6BF, 0x6C5F}, //817 #CJK UNIFIED IDEOGRAPH
    {0xA6C0, 0x6C60}, //818 #CJK UNIFIED IDEOGRAPH
    {0xA6C1, 0x6C50}, //819 #CJK UNIFIED IDEOGRAPH
    {0xA6C2, 0x6C55}, //820 #CJK UNIFIED IDEOGRAPH
    {0xA6C3, 0x6C61}, //821 #CJK UNIFIED IDEOGRAPH
    {0xA6C4, 0x6C5B}, //822 #CJK UNIFIED IDEOGRAPH
    {0xA6C5, 0x6C4D}, //823 #CJK UNIFIED IDEOGRAPH
    {0xA6C6, 0x6C4E}, //824 #CJK UNIFIED IDEOGRAPH
    {0xA6C7, 0x7070}, //825 #CJK UNIFIED IDEOGRAPH
    {0xA6C8, 0x725F}, //826 #CJK UNIFIED IDEOGRAPH
    {0xA6C9, 0x725D}, //827 #CJK UNIFIED IDEOGRAPH
    {0xA6CA, 0x767E}, //828 #CJK UNIFIED IDEOGRAPH
    {0xA6CB, 0x7AF9}, //829 #CJK UNIFIED IDEOGRAPH
    {0xA6CC, 0x7C73}, //830 #CJK UNIFIED IDEOGRAPH
    {0xA6CD, 0x7CF8}, //831 #CJK UNIFIED IDEOGRAPH
    {0xA6CE, 0x7F36}, //832 #CJK UNIFIED IDEOGRAPH
    {0xA6CF, 0x7F8A}, //833 #CJK UNIFIED IDEOGRAPH
    {0xA6D0, 0x7FBD}, //834 #CJK UNIFIED IDEOGRAPH
    {0xA6D1, 0x8001}, //835 #CJK UNIFIED IDEOGRAPH
    {0xA6D2, 0x8003}, //836 #CJK UNIFIED IDEOGRAPH
    {0xA6D3, 0x800C}, //837 #CJK UNIFIED IDEOGRAPH
    {0xA6D4, 0x8012}, //838 #CJK UNIFIED IDEOGRAPH
    {0xA6D5, 0x8033}, //839 #CJK UNIFIED IDEOGRAPH
    {0xA6D6, 0x807F}, //840 #CJK UNIFIED IDEOGRAPH
    {0xA6D7, 0x8089}, //841 #CJK UNIFIED IDEOGRAPH
    {0xA6D8, 0x808B}, //842 #CJK UNIFIED IDEOGRAPH
    {0xA6D9, 0x808C}, //843 #CJK UNIFIED IDEOGRAPH
    {0xA6DA, 0x81E3}, //844 #CJK UNIFIED IDEOGRAPH
    {0xA6DB, 0x81EA}, //845 #CJK UNIFIED IDEOGRAPH
    {0xA6DC, 0x81F3}, //846 #CJK UNIFIED IDEOGRAPH
    {0xA6DD, 0x81FC}, //847 #CJK UNIFIED IDEOGRAPH
    {0xA6DE, 0x820C}, //848 #CJK UNIFIED IDEOGRAPH
    {0xA6DF, 0x821B}, //849 #CJK UNIFIED IDEOGRAPH
    {0xA6E0, 0x821F}, //850 #CJK UNIFIED IDEOGRAPH
    {0xA6E1, 0x826E}, //851 #CJK UNIFIED IDEOGRAPH
    {0xA6E2, 0x8272}, //852 #CJK UNIFIED IDEOGRAPH
    {0xA6E3, 0x827E}, //853 #CJK UNIFIED IDEOGRAPH
    {0xA6E4, 0x866B}, //854 #CJK UNIFIED IDEOGRAPH
    {0xA6E5, 0x8840}, //855 #CJK UNIFIED IDEOGRAPH
    {0xA6E6, 0x884C}, //856 #CJK UNIFIED IDEOGRAPH
    {0xA6E7, 0x8863}, //857 #CJK UNIFIED IDEOGRAPH
    {0xA6E8, 0x897F}, //858 #CJK UNIFIED IDEOGRAPH
    {0xA6E9, 0x9621}, //859 #CJK UNIFIED IDEOGRAPH
    {0xA6EA, 0x4E32}, //860 #CJK UNIFIED IDEOGRAPH
    {0xA6EB, 0x4EA8}, //861 #CJK UNIFIED IDEOGRAPH
    {0xA6EC, 0x4F4D}, //862 #CJK UNIFIED IDEOGRAPH
    {0xA6ED, 0x4F4F}, //863 #CJK UNIFIED IDEOGRAPH
    {0xA6EE, 0x4F47}, //864 #CJK UNIFIED IDEOGRAPH
    {0xA6EF, 0x4F57}, //865 #CJK UNIFIED IDEOGRAPH
    {0xA6F0, 0x4F5E}, //866 #CJK UNIFIED IDEOGRAPH
    {0xA6F1, 0x4F34}, //867 #CJK UNIFIED IDEOGRAPH
    {0xA6F2, 0x4F5B}, //868 #CJK UNIFIED IDEOGRAPH
    {0xA6F3, 0x4F55}, //869 #CJK UNIFIED IDEOGRAPH
    {0xA6F4, 0x4F30}, //870 #CJK UNIFIED IDEOGRAPH
    {0xA6F5, 0x4F50}, //871 #CJK UNIFIED IDEOGRAPH
    {0xA6F6, 0x4F51}, //872 #CJK UNIFIED IDEOGRAPH
    {0xA6F7, 0x4F3D}, //873 #CJK UNIFIED IDEOGRAPH
    {0xA6F8, 0x4F3A}, //874 #CJK UNIFIED IDEOGRAPH
    {0xA6F9, 0x4F38}, //875 #CJK UNIFIED IDEOGRAPH
    {0xA6FA, 0x4F43}, //876 #CJK UNIFIED IDEOGRAPH
    {0xA6FB, 0x4F54}, //877 #CJK UNIFIED IDEOGRAPH
    {0xA6FC, 0x4F3C}, //878 #CJK UNIFIED IDEOGRAPH
    {0xA6FD, 0x4F46}, //879 #CJK UNIFIED IDEOGRAPH
    {0xA6FE, 0x4F63}, //880 #CJK UNIFIED IDEOGRAPH
    {0xA740, 0x4F5C}, //881 #CJK UNIFIED IDEOGRAPH
    {0xA741, 0x4F60}, //882 #CJK UNIFIED IDEOGRAPH
    {0xA742, 0x4F2F}, //883 #CJK UNIFIED IDEOGRAPH
    {0xA743, 0x4F4E}, //884 #CJK UNIFIED IDEOGRAPH
    {0xA744, 0x4F36}, //885 #CJK UNIFIED IDEOGRAPH
    {0xA745, 0x4F59}, //886 #CJK UNIFIED IDEOGRAPH
    {0xA746, 0x4F5D}, //887 #CJK UNIFIED IDEOGRAPH
    {0xA747, 0x4F48}, //888 #CJK UNIFIED IDEOGRAPH
    {0xA748, 0x4F5A}, //889 #CJK UNIFIED IDEOGRAPH
    {0xA749, 0x514C}, //890 #CJK UNIFIED IDEOGRAPH
    {0xA74A, 0x514B}, //891 #CJK UNIFIED IDEOGRAPH
    {0xA74B, 0x514D}, //892 #CJK UNIFIED IDEOGRAPH
    {0xA74C, 0x5175}, //893 #CJK UNIFIED IDEOGRAPH
    {0xA74D, 0x51B6}, //894 #CJK UNIFIED IDEOGRAPH
    {0xA74E, 0x51B7}, //895 #CJK UNIFIED IDEOGRAPH
    {0xA74F, 0x5225}, //896 #CJK UNIFIED IDEOGRAPH
    {0xA750, 0x5224}, //897 #CJK UNIFIED IDEOGRAPH
    {0xA751, 0x5229}, //898 #CJK UNIFIED IDEOGRAPH
    {0xA752, 0x522A}, //899 #CJK UNIFIED IDEOGRAPH
    {0xA753, 0x5228}, //900 #CJK UNIFIED IDEOGRAPH
    {0xA754, 0x52AB}, //901 #CJK UNIFIED IDEOGRAPH
    {0xA755, 0x52A9}, //902 #CJK UNIFIED IDEOGRAPH
    {0xA756, 0x52AA}, //903 #CJK UNIFIED IDEOGRAPH
    {0xA757, 0x52AC}, //904 #CJK UNIFIED IDEOGRAPH
    {0xA758, 0x5323}, //905 #CJK UNIFIED IDEOGRAPH
    {0xA759, 0x5373}, //906 #CJK UNIFIED IDEOGRAPH
    {0xA75A, 0x5375}, //907 #CJK UNIFIED IDEOGRAPH
    {0xA75B, 0x541D}, //908 #CJK UNIFIED IDEOGRAPH
    {0xA75C, 0x542D}, //909 #CJK UNIFIED IDEOGRAPH
    {0xA75D, 0x541E}, //910 #CJK UNIFIED IDEOGRAPH
    {0xA75E, 0x543E}, //911 #CJK UNIFIED IDEOGRAPH
    {0xA75F, 0x5426}, //912 #CJK UNIFIED IDEOGRAPH
    {0xA760, 0x544E}, //913 #CJK UNIFIED IDEOGRAPH
    {0xA761, 0x5427}, //914 #CJK UNIFIED IDEOGRAPH
    {0xA762, 0x5446}, //915 #CJK UNIFIED IDEOGRAPH
    {0xA763, 0x5443}, //916 #CJK UNIFIED IDEOGRAPH
    {0xA764, 0x5433}, //917 #CJK UNIFIED IDEOGRAPH
    {0xA765, 0x5448}, //918 #CJK UNIFIED IDEOGRAPH
    {0xA766, 0x5442}, //919 #CJK UNIFIED IDEOGRAPH
    {0xA767, 0x541B}, //920 #CJK UNIFIED IDEOGRAPH
    {0xA768, 0x5429}, //921 #CJK UNIFIED IDEOGRAPH
    {0xA769, 0x544A}, //922 #CJK UNIFIED IDEOGRAPH
    {0xA76A, 0x5439}, //923 #CJK UNIFIED IDEOGRAPH
    {0xA76B, 0x543B}, //924 #CJK UNIFIED IDEOGRAPH
    {0xA76C, 0x5438}, //925 #CJK UNIFIED IDEOGRAPH
    {0xA76D, 0x542E}, //926 #CJK UNIFIED IDEOGRAPH
    {0xA76E, 0x5435}, //927 #CJK UNIFIED IDEOGRAPH
    {0xA76F, 0x5436}, //928 #CJK UNIFIED IDEOGRAPH
    {0xA770, 0x5420}, //929 #CJK UNIFIED IDEOGRAPH
    {0xA771, 0x543C}, //930 #CJK UNIFIED IDEOGRAPH
    {0xA772, 0x5440}, //931 #CJK UNIFIED IDEOGRAPH
    {0xA773, 0x5431}, //932 #CJK UNIFIED IDEOGRAPH
    {0xA774, 0x542B}, //933 #CJK UNIFIED IDEOGRAPH
    {0xA775, 0x541F}, //934 #CJK UNIFIED IDEOGRAPH
    {0xA776, 0x542C}, //935 #CJK UNIFIED IDEOGRAPH
    {0xA777, 0x56EA}, //936 #CJK UNIFIED IDEOGRAPH
    {0xA778, 0x56F0}, //937 #CJK UNIFIED IDEOGRAPH
    {0xA779, 0x56E4}, //938 #CJK UNIFIED IDEOGRAPH
    {0xA77A, 0x56EB}, //939 #CJK UNIFIED IDEOGRAPH
    {0xA77B, 0x574A}, //940 #CJK UNIFIED IDEOGRAPH
    {0xA77C, 0x5751}, //941 #CJK UNIFIED IDEOGRAPH
    {0xA77D, 0x5740}, //942 #CJK UNIFIED IDEOGRAPH
    {0xA77E, 0x574D}, //943 #CJK UNIFIED IDEOGRAPH
    {0xA7A1, 0x5747}, //944 #CJK UNIFIED IDEOGRAPH
    {0xA7A2, 0x574E}, //945 #CJK UNIFIED IDEOGRAPH
    {0xA7A3, 0x573E}, //946 #CJK UNIFIED IDEOGRAPH
    {0xA7A4, 0x5750}, //947 #CJK UNIFIED IDEOGRAPH
    {0xA7A5, 0x574F}, //948 #CJK UNIFIED IDEOGRAPH
    {0xA7A6, 0x573B}, //949 #CJK UNIFIED IDEOGRAPH
    {0xA7A7, 0x58EF}, //950 #CJK UNIFIED IDEOGRAPH
    {0xA7A8, 0x593E}, //951 #CJK UNIFIED IDEOGRAPH
    {0xA7A9, 0x599D}, //952 #CJK UNIFIED IDEOGRAPH
    {0xA7AA, 0x5992}, //953 #CJK UNIFIED IDEOGRAPH
    {0xA7AB, 0x59A8}, //954 #CJK UNIFIED IDEOGRAPH
    {0xA7AC, 0x599E}, //955 #CJK UNIFIED IDEOGRAPH
    {0xA7AD, 0x59A3}, //956 #CJK UNIFIED IDEOGRAPH
    {0xA7AE, 0x5999}, //957 #CJK UNIFIED IDEOGRAPH
    {0xA7AF, 0x5996}, //958 #CJK UNIFIED IDEOGRAPH
    {0xA7B0, 0x598D}, //959 #CJK UNIFIED IDEOGRAPH
    {0xA7B1, 0x59A4}, //960 #CJK UNIFIED IDEOGRAPH
    {0xA7B2, 0x5993}, //961 #CJK UNIFIED IDEOGRAPH
    {0xA7B3, 0x598A}, //962 #CJK UNIFIED IDEOGRAPH
    {0xA7B4, 0x59A5}, //963 #CJK UNIFIED IDEOGRAPH
    {0xA7B5, 0x5B5D}, //964 #CJK UNIFIED IDEOGRAPH
    {0xA7B6, 0x5B5C}, //965 #CJK UNIFIED IDEOGRAPH
    {0xA7B7, 0x5B5A}, //966 #CJK UNIFIED IDEOGRAPH
    {0xA7B8, 0x5B5B}, //967 #CJK UNIFIED IDEOGRAPH
    {0xA7B9, 0x5B8C}, //968 #CJK UNIFIED IDEOGRAPH
    {0xA7BA, 0x5B8B}, //969 #CJK UNIFIED IDEOGRAPH
    {0xA7BB, 0x5B8F}, //970 #CJK UNIFIED IDEOGRAPH
    {0xA7BC, 0x5C2C}, //971 #CJK UNIFIED IDEOGRAPH
    {0xA7BD, 0x5C40}, //972 #CJK UNIFIED IDEOGRAPH
    {0xA7BE, 0x5C41}, //973 #CJK UNIFIED IDEOGRAPH
    {0xA7BF, 0x5C3F}, //974 #CJK UNIFIED IDEOGRAPH
    {0xA7C0, 0x5C3E}, //975 #CJK UNIFIED IDEOGRAPH
    {0xA7C1, 0x5C90}, //976 #CJK UNIFIED IDEOGRAPH
    {0xA7C2, 0x5C91}, //977 #CJK UNIFIED IDEOGRAPH
    {0xA7C3, 0x5C94}, //978 #CJK UNIFIED IDEOGRAPH
    {0xA7C4, 0x5C8C}, //979 #CJK UNIFIED IDEOGRAPH
    {0xA7C5, 0x5DEB}, //980 #CJK UNIFIED IDEOGRAPH
    {0xA7C6, 0x5E0C}, //981 #CJK UNIFIED IDEOGRAPH
    {0xA7C7, 0x5E8F}, //982 #CJK UNIFIED IDEOGRAPH
    {0xA7C8, 0x5E87}, //983 #CJK UNIFIED IDEOGRAPH
    {0xA7C9, 0x5E8A}, //984 #CJK UNIFIED IDEOGRAPH
    {0xA7CA, 0x5EF7}, //985 #CJK UNIFIED IDEOGRAPH
    {0xA7CB, 0x5F04}, //986 #CJK UNIFIED IDEOGRAPH
    {0xA7CC, 0x5F1F}, //987 #CJK UNIFIED IDEOGRAPH
    {0xA7CD, 0x5F64}, //988 #CJK UNIFIED IDEOGRAPH
    {0xA7CE, 0x5F62}, //989 #CJK UNIFIED IDEOGRAPH
    {0xA7CF, 0x5F77}, //990 #CJK UNIFIED IDEOGRAPH
    {0xA7D0, 0x5F79}, //991 #CJK UNIFIED IDEOGRAPH
    {0xA7D1, 0x5FD8}, //992 #CJK UNIFIED IDEOGRAPH
    {0xA7D2, 0x5FCC}, //993 #CJK UNIFIED IDEOGRAPH
    {0xA7D3, 0x5FD7}, //994 #CJK UNIFIED IDEOGRAPH
    {0xA7D4, 0x5FCD}, //995 #CJK UNIFIED IDEOGRAPH
    {0xA7D5, 0x5FF1}, //996 #CJK UNIFIED IDEOGRAPH
    {0xA7D6, 0x5FEB}, //997 #CJK UNIFIED IDEOGRAPH
    {0xA7D7, 0x5FF8}, //998 #CJK UNIFIED IDEOGRAPH
    {0xA7D8, 0x5FEA}, //999 #CJK UNIFIED IDEOGRAPH
    {0xA7D9, 0x6212}, //1000 #CJK UNIFIED IDEOGRAPH
    {0xA7DA, 0x6211}, //1001 #CJK UNIFIED IDEOGRAPH
    {0xA7DB, 0x6284}, //1002 #CJK UNIFIED IDEOGRAPH
    {0xA7DC, 0x6297}, //1003 #CJK UNIFIED IDEOGRAPH
    {0xA7DD, 0x6296}, //1004 #CJK UNIFIED IDEOGRAPH
    {0xA7DE, 0x6280}, //1005 #CJK UNIFIED IDEOGRAPH
    {0xA7DF, 0x6276}, //1006 #CJK UNIFIED IDEOGRAPH
    {0xA7E0, 0x6289}, //1007 #CJK UNIFIED IDEOGRAPH
    {0xA7E1, 0x626D}, //1008 #CJK UNIFIED IDEOGRAPH
    {0xA7E2, 0x628A}, //1009 #CJK UNIFIED IDEOGRAPH
    {0xA7E3, 0x627C}, //1010 #CJK UNIFIED IDEOGRAPH
    {0xA7E4, 0x627E}, //1011 #CJK UNIFIED IDEOGRAPH
    {0xA7E5, 0x6279}, //1012 #CJK UNIFIED IDEOGRAPH
    {0xA7E6, 0x6273}, //1013 #CJK UNIFIED IDEOGRAPH
    {0xA7E7, 0x6292}, //1014 #CJK UNIFIED IDEOGRAPH
    {0xA7E8, 0x626F}, //1015 #CJK UNIFIED IDEOGRAPH
    {0xA7E9, 0x6298}, //1016 #CJK UNIFIED IDEOGRAPH
    {0xA7EA, 0x626E}, //1017 #CJK UNIFIED IDEOGRAPH
    {0xA7EB, 0x6295}, //1018 #CJK UNIFIED IDEOGRAPH
    {0xA7EC, 0x6293}, //1019 #CJK UNIFIED IDEOGRAPH
    {0xA7ED, 0x6291}, //1020 #CJK UNIFIED IDEOGRAPH
    {0xA7EE, 0x6286}, //1021 #CJK UNIFIED IDEOGRAPH
    {0xA7EF, 0x6539}, //1022 #CJK UNIFIED IDEOGRAPH
    {0xA7F0, 0x653B}, //1023 #CJK UNIFIED IDEOGRAPH
    {0xA7F1, 0x6538}, //1024 #CJK UNIFIED IDEOGRAPH
    {0xA7F2, 0x65F1}, //1025 #CJK UNIFIED IDEOGRAPH
    {0xA7F3, 0x66F4}, //1026 #CJK UNIFIED IDEOGRAPH
    {0xA7F4, 0x675F}, //1027 #CJK UNIFIED IDEOGRAPH
    {0xA7F5, 0x674E}, //1028 #CJK UNIFIED IDEOGRAPH
    {0xA7F6, 0x674F}, //1029 #CJK UNIFIED IDEOGRAPH
    {0xA7F7, 0x6750}, //1030 #CJK UNIFIED IDEOGRAPH
    {0xA7F8, 0x6751}, //1031 #CJK UNIFIED IDEOGRAPH
    {0xA7F9, 0x675C}, //1032 #CJK UNIFIED IDEOGRAPH
    {0xA7FA, 0x6756}, //1033 #CJK UNIFIED IDEOGRAPH
    {0xA7FB, 0x675E}, //1034 #CJK UNIFIED IDEOGRAPH
    {0xA7FC, 0x6749}, //1035 #CJK UNIFIED IDEOGRAPH
    {0xA7FD, 0x6746}, //1036 #CJK UNIFIED IDEOGRAPH
    {0xA7FE, 0x6760}, //1037 #CJK UNIFIED IDEOGRAPH
    {0xA840, 0x6753}, //1038 #CJK UNIFIED IDEOGRAPH
    {0xA841, 0x6757}, //1039 #CJK UNIFIED IDEOGRAPH
    {0xA842, 0x6B65}, //1040 #CJK UNIFIED IDEOGRAPH
    {0xA843, 0x6BCF}, //1041 #CJK UNIFIED IDEOGRAPH
    {0xA844, 0x6C42}, //1042 #CJK UNIFIED IDEOGRAPH
    {0xA845, 0x6C5E}, //1043 #CJK UNIFIED IDEOGRAPH
    {0xA846, 0x6C99}, //1044 #CJK UNIFIED IDEOGRAPH
    {0xA847, 0x6C81}, //1045 #CJK UNIFIED IDEOGRAPH
    {0xA848, 0x6C88}, //1046 #CJK UNIFIED IDEOGRAPH
    {0xA849, 0x6C89}, //1047 #CJK UNIFIED IDEOGRAPH
    {0xA84A, 0x6C85}, //1048 #CJK UNIFIED IDEOGRAPH
    {0xA84B, 0x6C9B}, //1049 #CJK UNIFIED IDEOGRAPH
    {0xA84C, 0x6C6A}, //1050 #CJK UNIFIED IDEOGRAPH
    {0xA84D, 0x6C7A}, //1051 #CJK UNIFIED IDEOGRAPH
    {0xA84E, 0x6C90}, //1052 #CJK UNIFIED IDEOGRAPH
    {0xA84F, 0x6C70}, //1053 #CJK UNIFIED IDEOGRAPH
    {0xA850, 0x6C8C}, //1054 #CJK UNIFIED IDEOGRAPH
    {0xA851, 0x6C68}, //1055 #CJK UNIFIED IDEOGRAPH
    {0xA852, 0x6C96}, //1056 #CJK UNIFIED IDEOGRAPH
    {0xA853, 0x6C92}, //1057 #CJK UNIFIED IDEOGRAPH
    {0xA854, 0x6C7D}, //1058 #CJK UNIFIED IDEOGRAPH
    {0xA855, 0x6C83}, //1059 #CJK UNIFIED IDEOGRAPH
    {0xA856, 0x6C72}, //1060 #CJK UNIFIED IDEOGRAPH
    {0xA857, 0x6C7E}, //1061 #CJK UNIFIED IDEOGRAPH
    {0xA858, 0x6C74}, //1062 #CJK UNIFIED IDEOGRAPH
    {0xA859, 0x6C86}, //1063 #CJK UNIFIED IDEOGRAPH
    {0xA85A, 0x6C76}, //1064 #CJK UNIFIED IDEOGRAPH
    {0xA85B, 0x6C8D}, //1065 #CJK UNIFIED IDEOGRAPH
    {0xA85C, 0x6C94}, //1066 #CJK UNIFIED IDEOGRAPH
    {0xA85D, 0x6C98}, //1067 #CJK UNIFIED IDEOGRAPH
    {0xA85E, 0x6C82}, //1068 #CJK UNIFIED IDEOGRAPH
    {0xA85F, 0x7076}, //1069 #CJK UNIFIED IDEOGRAPH
    {0xA860, 0x707C}, //1070 #CJK UNIFIED IDEOGRAPH
    {0xA861, 0x707D}, //1071 #CJK UNIFIED IDEOGRAPH
    {0xA862, 0x7078}, //1072 #CJK UNIFIED IDEOGRAPH
    {0xA863, 0x7262}, //1073 #CJK UNIFIED IDEOGRAPH
    {0xA864, 0x7261}, //1074 #CJK UNIFIED IDEOGRAPH
    {0xA865, 0x7260}, //1075 #CJK UNIFIED IDEOGRAPH
    {0xA866, 0x72C4}, //1076 #CJK UNIFIED IDEOGRAPH
    {0xA867, 0x72C2}, //1077 #CJK UNIFIED IDEOGRAPH
    {0xA868, 0x7396}, //1078 #CJK UNIFIED IDEOGRAPH
    {0xA869, 0x752C}, //1079 #CJK UNIFIED IDEOGRAPH
    {0xA86A, 0x752B}, //1080 #CJK UNIFIED IDEOGRAPH
    {0xA86B, 0x7537}, //1081 #CJK UNIFIED IDEOGRAPH
    {0xA86C, 0x7538}, //1082 #CJK UNIFIED IDEOGRAPH
    {0xA86D, 0x7682}, //1083 #CJK UNIFIED IDEOGRAPH
    {0xA86E, 0x76EF}, //1084 #CJK UNIFIED IDEOGRAPH
    {0xA86F, 0x77E3}, //1085 #CJK UNIFIED IDEOGRAPH
    {0xA870, 0x79C1}, //1086 #CJK UNIFIED IDEOGRAPH
    {0xA871, 0x79C0}, //1087 #CJK UNIFIED IDEOGRAPH
    {0xA872, 0x79BF}, //1088 #CJK UNIFIED IDEOGRAPH
    {0xA873, 0x7A76}, //1089 #CJK UNIFIED IDEOGRAPH
    {0xA874, 0x7CFB}, //1090 #CJK UNIFIED IDEOGRAPH
    {0xA875, 0x7F55}, //1091 #CJK UNIFIED IDEOGRAPH
    {0xA876, 0x8096}, //1092 #CJK UNIFIED IDEOGRAPH
    {0xA877, 0x8093}, //1093 #CJK UNIFIED IDEOGRAPH
    {0xA878, 0x809D}, //1094 #CJK UNIFIED IDEOGRAPH
    {0xA879, 0x8098}, //1095 #CJK UNIFIED IDEOGRAPH
    {0xA87A, 0x809B}, //1096 #CJK UNIFIED IDEOGRAPH
    {0xA87B, 0x809A}, //1097 #CJK UNIFIED IDEOGRAPH
    {0xA87C, 0x80B2}, //1098 #CJK UNIFIED IDEOGRAPH
    {0xA87D, 0x826F}, //1099 #CJK UNIFIED IDEOGRAPH
    {0xA87E, 0x8292}, //1100 #CJK UNIFIED IDEOGRAPH
    {0xA8A1, 0x828B}, //1101 #CJK UNIFIED IDEOGRAPH
    {0xA8A2, 0x828D}, //1102 #CJK UNIFIED IDEOGRAPH
    {0xA8A3, 0x898B}, //1103 #CJK UNIFIED IDEOGRAPH
    {0xA8A4, 0x89D2}, //1104 #CJK UNIFIED IDEOGRAPH
    {0xA8A5, 0x8A00}, //1105 #CJK UNIFIED IDEOGRAPH
    {0xA8A6, 0x8C37}, //1106 #CJK UNIFIED IDEOGRAPH
    {0xA8A7, 0x8C46}, //1107 #CJK UNIFIED IDEOGRAPH
    {0xA8A8, 0x8C55}, //1108 #CJK UNIFIED IDEOGRAPH
    {0xA8A9, 0x8C9D}, //1109 #CJK UNIFIED IDEOGRAPH
    {0xA8AA, 0x8D64}, //1110 #CJK UNIFIED IDEOGRAPH
    {0xA8AB, 0x8D70}, //1111 #CJK UNIFIED IDEOGRAPH
    {0xA8AC, 0x8DB3}, //1112 #CJK UNIFIED IDEOGRAPH
    {0xA8AD, 0x8EAB}, //1113 #CJK UNIFIED IDEOGRAPH
    {0xA8AE, 0x8ECA}, //1114 #CJK UNIFIED IDEOGRAPH
    {0xA8AF, 0x8F9B}, //1115 #CJK UNIFIED IDEOGRAPH
    {0xA8B0, 0x8FB0}, //1116 #CJK UNIFIED IDEOGRAPH
    {0xA8B1, 0x8FC2}, //1117 #CJK UNIFIED IDEOGRAPH
    {0xA8B2, 0x8FC6}, //1118 #CJK UNIFIED IDEOGRAPH
    {0xA8B3, 0x8FC5}, //1119 #CJK UNIFIED IDEOGRAPH
    {0xA8B4, 0x8FC4}, //1120 #CJK UNIFIED IDEOGRAPH
    {0xA8B5, 0x5DE1}, //1121 #CJK UNIFIED IDEOGRAPH
    {0xA8B6, 0x9091}, //1122 #CJK UNIFIED IDEOGRAPH
    {0xA8B7, 0x90A2}, //1123 #CJK UNIFIED IDEOGRAPH
    {0xA8B8, 0x90AA}, //1124 #CJK UNIFIED IDEOGRAPH
    {0xA8B9, 0x90A6}, //1125 #CJK UNIFIED IDEOGRAPH
    {0xA8BA, 0x90A3}, //1126 #CJK UNIFIED IDEOGRAPH
    {0xA8BB, 0x9149}, //1127 #CJK UNIFIED IDEOGRAPH
    {0xA8BC, 0x91C6}, //1128 #CJK UNIFIED IDEOGRAPH
    {0xA8BD, 0x91CC}, //1129 #CJK UNIFIED IDEOGRAPH
    {0xA8BE, 0x9632}, //1130 #CJK UNIFIED IDEOGRAPH
    {0xA8BF, 0x962E}, //1131 #CJK UNIFIED IDEOGRAPH
    {0xA8C0, 0x9631}, //1132 #CJK UNIFIED IDEOGRAPH
    {0xA8C1, 0x962A}, //1133 #CJK UNIFIED IDEOGRAPH
    {0xA8C2, 0x962C}, //1134 #CJK UNIFIED IDEOGRAPH
    {0xA8C3, 0x4E26}, //1135 #CJK UNIFIED IDEOGRAPH
    {0xA8C4, 0x4E56}, //1136 #CJK UNIFIED IDEOGRAPH
    {0xA8C5, 0x4E73}, //1137 #CJK UNIFIED IDEOGRAPH
    {0xA8C6, 0x4E8B}, //1138 #CJK UNIFIED IDEOGRAPH
    {0xA8C7, 0x4E9B}, //1139 #CJK UNIFIED IDEOGRAPH
    {0xA8C8, 0x4E9E}, //1140 #CJK UNIFIED IDEOGRAPH
    {0xA8C9, 0x4EAB}, //1141 #CJK UNIFIED IDEOGRAPH
    {0xA8CA, 0x4EAC}, //1142 #CJK UNIFIED IDEOGRAPH
    {0xA8CB, 0x4F6F}, //1143 #CJK UNIFIED IDEOGRAPH
    {0xA8CC, 0x4F9D}, //1144 #CJK UNIFIED IDEOGRAPH
    {0xA8CD, 0x4F8D}, //1145 #CJK UNIFIED IDEOGRAPH
    {0xA8CE, 0x4F73}, //1146 #CJK UNIFIED IDEOGRAPH
    {0xA8CF, 0x4F7F}, //1147 #CJK UNIFIED IDEOGRAPH
    {0xA8D0, 0x4F6C}, //1148 #CJK UNIFIED IDEOGRAPH
    {0xA8D1, 0x4F9B}, //1149 #CJK UNIFIED IDEOGRAPH
    {0xA8D2, 0x4F8B}, //1150 #CJK UNIFIED IDEOGRAPH
    {0xA8D3, 0x4F86}, //1151 #CJK UNIFIED IDEOGRAPH
    {0xA8D4, 0x4F83}, //1152 #CJK UNIFIED IDEOGRAPH
    {0xA8D5, 0x4F70}, //1153 #CJK UNIFIED IDEOGRAPH
    {0xA8D6, 0x4F75}, //1154 #CJK UNIFIED IDEOGRAPH
    {0xA8D7, 0x4F88}, //1155 #CJK UNIFIED IDEOGRAPH
    {0xA8D8, 0x4F69}, //1156 #CJK UNIFIED IDEOGRAPH
    {0xA8D9, 0x4F7B}, //1157 #CJK UNIFIED IDEOGRAPH
    {0xA8DA, 0x4F96}, //1158 #CJK UNIFIED IDEOGRAPH
    {0xA8DB, 0x4F7E}, //1159 #CJK UNIFIED IDEOGRAPH
    {0xA8DC, 0x4F8F}, //1160 #CJK UNIFIED IDEOGRAPH
    {0xA8DD, 0x4F91}, //1161 #CJK UNIFIED IDEOGRAPH
    {0xA8DE, 0x4F7A}, //1162 #CJK UNIFIED IDEOGRAPH
    {0xA8DF, 0x5154}, //1163 #CJK UNIFIED IDEOGRAPH
    {0xA8E0, 0x5152}, //1164 #CJK UNIFIED IDEOGRAPH
    {0xA8E1, 0x5155}, //1165 #CJK UNIFIED IDEOGRAPH
    {0xA8E2, 0x5169}, //1166 #CJK UNIFIED IDEOGRAPH
    {0xA8E3, 0x5177}, //1167 #CJK UNIFIED IDEOGRAPH
    {0xA8E4, 0x5176}, //1168 #CJK UNIFIED IDEOGRAPH
    {0xA8E5, 0x5178}, //1169 #CJK UNIFIED IDEOGRAPH
    {0xA8E6, 0x51BD}, //1170 #CJK UNIFIED IDEOGRAPH
    {0xA8E7, 0x51FD}, //1171 #CJK UNIFIED IDEOGRAPH
    {0xA8E8, 0x523B}, //1172 #CJK UNIFIED IDEOGRAPH
    {0xA8E9, 0x5238}, //1173 #CJK UNIFIED IDEOGRAPH
    {0xA8EA, 0x5237}, //1174 #CJK UNIFIED IDEOGRAPH
    {0xA8EB, 0x523A}, //1175 #CJK UNIFIED IDEOGRAPH
    {0xA8EC, 0x5230}, //1176 #CJK UNIFIED IDEOGRAPH
    {0xA8ED, 0x522E}, //1177 #CJK UNIFIED IDEOGRAPH
    {0xA8EE, 0x5236}, //1178 #CJK UNIFIED IDEOGRAPH
    {0xA8EF, 0x5241}, //1179 #CJK UNIFIED IDEOGRAPH
    {0xA8F0, 0x52BE}, //1180 #CJK UNIFIED IDEOGRAPH
    {0xA8F1, 0x52BB}, //1181 #CJK UNIFIED IDEOGRAPH
    {0xA8F2, 0x5352}, //1182 #CJK UNIFIED IDEOGRAPH
    {0xA8F3, 0x5354}, //1183 #CJK UNIFIED IDEOGRAPH
    {0xA8F4, 0x5353}, //1184 #CJK UNIFIED IDEOGRAPH
    {0xA8F5, 0x5351}, //1185 #CJK UNIFIED IDEOGRAPH
    {0xA8F6, 0x5366}, //1186 #CJK UNIFIED IDEOGRAPH
    {0xA8F7, 0x5377}, //1187 #CJK UNIFIED IDEOGRAPH
    {0xA8F8, 0x5378}, //1188 #CJK UNIFIED IDEOGRAPH
    {0xA8F9, 0x5379}, //1189 #CJK UNIFIED IDEOGRAPH
    {0xA8FA, 0x53D6}, //1190 #CJK UNIFIED IDEOGRAPH
    {0xA8FB, 0x53D4}, //1191 #CJK UNIFIED IDEOGRAPH
    {0xA8FC, 0x53D7}, //1192 #CJK UNIFIED IDEOGRAPH
    {0xA8FD, 0x5473}, //1193 #CJK UNIFIED IDEOGRAPH
    {0xA8FE, 0x5475}, //1194 #CJK UNIFIED IDEOGRAPH
    {0xA940, 0x5496}, //1195 #CJK UNIFIED IDEOGRAPH
    {0xA941, 0x5478}, //1196 #CJK UNIFIED IDEOGRAPH
    {0xA942, 0x5495}, //1197 #CJK UNIFIED IDEOGRAPH
    {0xA943, 0x5480}, //1198 #CJK UNIFIED IDEOGRAPH
    {0xA944, 0x547B}, //1199 #CJK UNIFIED IDEOGRAPH
    {0xA945, 0x5477}, //1200 #CJK UNIFIED IDEOGRAPH
    {0xA946, 0x5484}, //1201 #CJK UNIFIED IDEOGRAPH
    {0xA947, 0x5492}, //1202 #CJK UNIFIED IDEOGRAPH
    {0xA948, 0x5486}, //1203 #CJK UNIFIED IDEOGRAPH
    {0xA949, 0x547C}, //1204 #CJK UNIFIED IDEOGRAPH
    {0xA94A, 0x5490}, //1205 #CJK UNIFIED IDEOGRAPH
    {0xA94B, 0x5471}, //1206 #CJK UNIFIED IDEOGRAPH
    {0xA94C, 0x5476}, //1207 #CJK UNIFIED IDEOGRAPH
    {0xA94D, 0x548C}, //1208 #CJK UNIFIED IDEOGRAPH
    {0xA94E, 0x549A}, //1209 #CJK UNIFIED IDEOGRAPH
    {0xA94F, 0x5462}, //1210 #CJK UNIFIED IDEOGRAPH
    {0xA950, 0x5468}, //1211 #CJK UNIFIED IDEOGRAPH
    {0xA951, 0x548B}, //1212 #CJK UNIFIED IDEOGRAPH
    {0xA952, 0x547D}, //1213 #CJK UNIFIED IDEOGRAPH
    {0xA953, 0x548E}, //1214 #CJK UNIFIED IDEOGRAPH
    {0xA954, 0x56FA}, //1215 #CJK UNIFIED IDEOGRAPH
    {0xA955, 0x5783}, //1216 #CJK UNIFIED IDEOGRAPH
    {0xA956, 0x5777}, //1217 #CJK UNIFIED IDEOGRAPH
    {0xA957, 0x576A}, //1218 #CJK UNIFIED IDEOGRAPH
    {0xA958, 0x5769}, //1219 #CJK UNIFIED IDEOGRAPH
    {0xA959, 0x5761}, //1220 #CJK UNIFIED IDEOGRAPH
    {0xA95A, 0x5766}, //1221 #CJK UNIFIED IDEOGRAPH
    {0xA95B, 0x5764}, //1222 #CJK UNIFIED IDEOGRAPH
    {0xA95C, 0x577C}, //1223 #CJK UNIFIED IDEOGRAPH
    {0xA95D, 0x591C}, //1224 #CJK UNIFIED IDEOGRAPH
    {0xA95E, 0x5949}, //1225 #CJK UNIFIED IDEOGRAPH
    {0xA95F, 0x5947}, //1226 #CJK UNIFIED IDEOGRAPH
    {0xA960, 0x5948}, //1227 #CJK UNIFIED IDEOGRAPH
    {0xA961, 0x5944}, //1228 #CJK UNIFIED IDEOGRAPH
    {0xA962, 0x5954}, //1229 #CJK UNIFIED IDEOGRAPH
    {0xA963, 0x59BE}, //1230 #CJK UNIFIED IDEOGRAPH
    {0xA964, 0x59BB}, //1231 #CJK UNIFIED IDEOGRAPH
    {0xA965, 0x59D4}, //1232 #CJK UNIFIED IDEOGRAPH
    {0xA966, 0x59B9}, //1233 #CJK UNIFIED IDEOGRAPH
    {0xA967, 0x59AE}, //1234 #CJK UNIFIED IDEOGRAPH
    {0xA968, 0x59D1}, //1235 #CJK UNIFIED IDEOGRAPH
    {0xA969, 0x59C6}, //1236 #CJK UNIFIED IDEOGRAPH
    {0xA96A, 0x59D0}, //1237 #CJK UNIFIED IDEOGRAPH
    {0xA96B, 0x59CD}, //1238 #CJK UNIFIED IDEOGRAPH
    {0xA96C, 0x59CB}, //1239 #CJK UNIFIED IDEOGRAPH
    {0xA96D, 0x59D3}, //1240 #CJK UNIFIED IDEOGRAPH
    {0xA96E, 0x59CA}, //1241 #CJK UNIFIED IDEOGRAPH
    {0xA96F, 0x59AF}, //1242 #CJK UNIFIED IDEOGRAPH
    {0xA970, 0x59B3}, //1243 #CJK UNIFIED IDEOGRAPH
    {0xA971, 0x59D2}, //1244 #CJK UNIFIED IDEOGRAPH
    {0xA972, 0x59C5}, //1245 #CJK UNIFIED IDEOGRAPH
    {0xA973, 0x5B5F}, //1246 #CJK UNIFIED IDEOGRAPH
    {0xA974, 0x5B64}, //1247 #CJK UNIFIED IDEOGRAPH
    {0xA975, 0x5B63}, //1248 #CJK UNIFIED IDEOGRAPH
    {0xA976, 0x5B97}, //1249 #CJK UNIFIED IDEOGRAPH
    {0xA977, 0x5B9A}, //1250 #CJK UNIFIED IDEOGRAPH
    {0xA978, 0x5B98}, //1251 #CJK UNIFIED IDEOGRAPH
    {0xA979, 0x5B9C}, //1252 #CJK UNIFIED IDEOGRAPH
    {0xA97A, 0x5B99}, //1253 #CJK UNIFIED IDEOGRAPH
    {0xA97B, 0x5B9B}, //1254 #CJK UNIFIED IDEOGRAPH
    {0xA97C, 0x5C1A}, //1255 #CJK UNIFIED IDEOGRAPH
    {0xA97D, 0x5C48}, //1256 #CJK UNIFIED IDEOGRAPH
    {0xA97E, 0x5C45}, //1257 #CJK UNIFIED IDEOGRAPH
    {0xA9A1, 0x5C46}, //1258 #CJK UNIFIED IDEOGRAPH
    {0xA9A2, 0x5CB7}, //1259 #CJK UNIFIED IDEOGRAPH
    {0xA9A3, 0x5CA1}, //1260 #CJK UNIFIED IDEOGRAPH
    {0xA9A4, 0x5CB8}, //1261 #CJK UNIFIED IDEOGRAPH
    {0xA9A5, 0x5CA9}, //1262 #CJK UNIFIED IDEOGRAPH
    {0xA9A6, 0x5CAB}, //1263 #CJK UNIFIED IDEOGRAPH
    {0xA9A7, 0x5CB1}, //1264 #CJK UNIFIED IDEOGRAPH
    {0xA9A8, 0x5CB3}, //1265 #CJK UNIFIED IDEOGRAPH
    {0xA9A9, 0x5E18}, //1266 #CJK UNIFIED IDEOGRAPH
    {0xA9AA, 0x5E1A}, //1267 #CJK UNIFIED IDEOGRAPH
    {0xA9AB, 0x5E16}, //1268 #CJK UNIFIED IDEOGRAPH
    {0xA9AC, 0x5E15}, //1269 #CJK UNIFIED IDEOGRAPH
    {0xA9AD, 0x5E1B}, //1270 #CJK UNIFIED IDEOGRAPH
    {0xA9AE, 0x5E11}, //1271 #CJK UNIFIED IDEOGRAPH
    {0xA9AF, 0x5E78}, //1272 #CJK UNIFIED IDEOGRAPH
    {0xA9B0, 0x5E9A}, //1273 #CJK UNIFIED IDEOGRAPH
    {0xA9B1, 0x5E97}, //1274 #CJK UNIFIED IDEOGRAPH
    {0xA9B2, 0x5E9C}, //1275 #CJK UNIFIED IDEOGRAPH
    {0xA9B3, 0x5E95}, //1276 #CJK UNIFIED IDEOGRAPH
    {0xA9B4, 0x5E96}, //1277 #CJK UNIFIED IDEOGRAPH
    {0xA9B5, 0x5EF6}, //1278 #CJK UNIFIED IDEOGRAPH
    {0xA9B6, 0x5F26}, //1279 #CJK UNIFIED IDEOGRAPH
    {0xA9B7, 0x5F27}, //1280 #CJK UNIFIED IDEOGRAPH
    {0xA9B8, 0x5F29}, //1281 #CJK UNIFIED IDEOGRAPH
    {0xA9B9, 0x5F80}, //1282 #CJK UNIFIED IDEOGRAPH
    {0xA9BA, 0x5F81}, //1283 #CJK UNIFIED IDEOGRAPH
    {0xA9BB, 0x5F7F}, //1284 #CJK UNIFIED IDEOGRAPH
    {0xA9BC, 0x5F7C}, //1285 #CJK UNIFIED IDEOGRAPH
    {0xA9BD, 0x5FDD}, //1286 #CJK UNIFIED IDEOGRAPH
    {0xA9BE, 0x5FE0}, //1287 #CJK UNIFIED IDEOGRAPH
    {0xA9BF, 0x5FFD}, //1288 #CJK UNIFIED IDEOGRAPH
    {0xA9C0, 0x5FF5}, //1289 #CJK UNIFIED IDEOGRAPH
    {0xA9C1, 0x5FFF}, //1290 #CJK UNIFIED IDEOGRAPH
    {0xA9C2, 0x600F}, //1291 #CJK UNIFIED IDEOGRAPH
    {0xA9C3, 0x6014}, //1292 #CJK UNIFIED IDEOGRAPH
    {0xA9C4, 0x602F}, //1293 #CJK UNIFIED IDEOGRAPH
    {0xA9C5, 0x6035}, //1294 #CJK UNIFIED IDEOGRAPH
    {0xA9C6, 0x6016}, //1295 #CJK UNIFIED IDEOGRAPH
    {0xA9C7, 0x602A}, //1296 #CJK UNIFIED IDEOGRAPH
    {0xA9C8, 0x6015}, //1297 #CJK UNIFIED IDEOGRAPH
    {0xA9C9, 0x6021}, //1298 #CJK UNIFIED IDEOGRAPH
    {0xA9CA, 0x6027}, //1299 #CJK UNIFIED IDEOGRAPH
    {0xA9CB, 0x6029}, //1300 #CJK UNIFIED IDEOGRAPH
    {0xA9CC, 0x602B}, //1301 #CJK UNIFIED IDEOGRAPH
    {0xA9CD, 0x601B}, //1302 #CJK UNIFIED IDEOGRAPH
    {0xA9CE, 0x6216}, //1303 #CJK UNIFIED IDEOGRAPH
    {0xA9CF, 0x6215}, //1304 #CJK UNIFIED IDEOGRAPH
    {0xA9D0, 0x623F}, //1305 #CJK UNIFIED IDEOGRAPH
    {0xA9D1, 0x623E}, //1306 #CJK UNIFIED IDEOGRAPH
    {0xA9D2, 0x6240}, //1307 #CJK UNIFIED IDEOGRAPH
    {0xA9D3, 0x627F}, //1308 #CJK UNIFIED IDEOGRAPH
    {0xA9D4, 0x62C9}, //1309 #CJK UNIFIED IDEOGRAPH
    {0xA9D5, 0x62CC}, //1310 #CJK UNIFIED IDEOGRAPH
    {0xA9D6, 0x62C4}, //1311 #CJK UNIFIED IDEOGRAPH
    {0xA9D7, 0x62BF}, //1312 #CJK UNIFIED IDEOGRAPH
    {0xA9D8, 0x62C2}, //1313 #CJK UNIFIED IDEOGRAPH
    {0xA9D9, 0x62B9}, //1314 #CJK UNIFIED IDEOGRAPH
    {0xA9DA, 0x62D2}, //1315 #CJK UNIFIED IDEOGRAPH
    {0xA9DB, 0x62DB}, //1316 #CJK UNIFIED IDEOGRAPH
    {0xA9DC, 0x62AB}, //1317 #CJK UNIFIED IDEOGRAPH
    {0xA9DD, 0x62D3}, //1318 #CJK UNIFIED IDEOGRAPH
    {0xA9DE, 0x62D4}, //1319 #CJK UNIFIED IDEOGRAPH
    {0xA9DF, 0x62CB}, //1320 #CJK UNIFIED IDEOGRAPH
    {0xA9E0, 0x62C8}, //1321 #CJK UNIFIED IDEOGRAPH
    {0xA9E1, 0x62A8}, //1322 #CJK UNIFIED IDEOGRAPH
    {0xA9E2, 0x62BD}, //1323 #CJK UNIFIED IDEOGRAPH
    {0xA9E3, 0x62BC}, //1324 #CJK UNIFIED IDEOGRAPH
    {0xA9E4, 0x62D0}, //1325 #CJK UNIFIED IDEOGRAPH
    {0xA9E5, 0x62D9}, //1326 #CJK UNIFIED IDEOGRAPH
    {0xA9E6, 0x62C7}, //1327 #CJK UNIFIED IDEOGRAPH
    {0xA9E7, 0x62CD}, //1328 #CJK UNIFIED IDEOGRAPH
    {0xA9E8, 0x62B5}, //1329 #CJK UNIFIED IDEOGRAPH
    {0xA9E9, 0x62DA}, //1330 #CJK UNIFIED IDEOGRAPH
    {0xA9EA, 0x62B1}, //1331 #CJK UNIFIED IDEOGRAPH
    {0xA9EB, 0x62D8}, //1332 #CJK UNIFIED IDEOGRAPH
    {0xA9EC, 0x62D6}, //1333 #CJK UNIFIED IDEOGRAPH
    {0xA9ED, 0x62D7}, //1334 #CJK UNIFIED IDEOGRAPH
    {0xA9EE, 0x62C6}, //1335 #CJK UNIFIED IDEOGRAPH
    {0xA9EF, 0x62AC}, //1336 #CJK UNIFIED IDEOGRAPH
    {0xA9F0, 0x62CE}, //1337 #CJK UNIFIED IDEOGRAPH
    {0xA9F1, 0x653E}, //1338 #CJK UNIFIED IDEOGRAPH
    {0xA9F2, 0x65A7}, //1339 #CJK UNIFIED IDEOGRAPH
    {0xA9F3, 0x65BC}, //1340 #CJK UNIFIED IDEOGRAPH
    {0xA9F4, 0x65FA}, //1341 #CJK UNIFIED IDEOGRAPH
    {0xA9F5, 0x6614}, //1342 #CJK UNIFIED IDEOGRAPH
    {0xA9F6, 0x6613}, //1343 #CJK UNIFIED IDEOGRAPH
    {0xA9F7, 0x660C}, //1344 #CJK UNIFIED IDEOGRAPH
    {0xA9F8, 0x6606}, //1345 #CJK UNIFIED IDEOGRAPH
    {0xA9F9, 0x6602}, //1346 #CJK UNIFIED IDEOGRAPH
    {0xA9FA, 0x660E}, //1347 #CJK UNIFIED IDEOGRAPH
    {0xA9FB, 0x6600}, //1348 #CJK UNIFIED IDEOGRAPH
    {0xA9FC, 0x660F}, //1349 #CJK UNIFIED IDEOGRAPH
    {0xA9FD, 0x6615}, //1350 #CJK UNIFIED IDEOGRAPH
    {0xA9FE, 0x660A}, //1351 #CJK UNIFIED IDEOGRAPH
    {0xAA40, 0x6607}, //1352 #CJK UNIFIED IDEOGRAPH
    {0xAA41, 0x670D}, //1353 #CJK UNIFIED IDEOGRAPH
    {0xAA42, 0x670B}, //1354 #CJK UNIFIED IDEOGRAPH
    {0xAA43, 0x676D}, //1355 #CJK UNIFIED IDEOGRAPH
    {0xAA44, 0x678B}, //1356 #CJK UNIFIED IDEOGRAPH
    {0xAA45, 0x6795}, //1357 #CJK UNIFIED IDEOGRAPH
    {0xAA46, 0x6771}, //1358 #CJK UNIFIED IDEOGRAPH
    {0xAA47, 0x679C}, //1359 #CJK UNIFIED IDEOGRAPH
    {0xAA48, 0x6773}, //1360 #CJK UNIFIED IDEOGRAPH
    {0xAA49, 0x6777}, //1361 #CJK UNIFIED IDEOGRAPH
    {0xAA4A, 0x6787}, //1362 #CJK UNIFIED IDEOGRAPH
    {0xAA4B, 0x679D}, //1363 #CJK UNIFIED IDEOGRAPH
    {0xAA4C, 0x6797}, //1364 #CJK UNIFIED IDEOGRAPH
    {0xAA4D, 0x676F}, //1365 #CJK UNIFIED IDEOGRAPH
    {0xAA4E, 0x6770}, //1366 #CJK UNIFIED IDEOGRAPH
    {0xAA4F, 0x677F}, //1367 #CJK UNIFIED IDEOGRAPH
    {0xAA50, 0x6789}, //1368 #CJK UNIFIED IDEOGRAPH
    {0xAA51, 0x677E}, //1369 #CJK UNIFIED IDEOGRAPH
    {0xAA52, 0x6790}, //1370 #CJK UNIFIED IDEOGRAPH
    {0xAA53, 0x6775}, //1371 #CJK UNIFIED IDEOGRAPH
    {0xAA54, 0x679A}, //1372 #CJK UNIFIED IDEOGRAPH
    {0xAA55, 0x6793}, //1373 #CJK UNIFIED IDEOGRAPH
    {0xAA56, 0x677C}, //1374 #CJK UNIFIED IDEOGRAPH
    {0xAA57, 0x676A}, //1375 #CJK UNIFIED IDEOGRAPH
    {0xAA58, 0x6772}, //1376 #CJK UNIFIED IDEOGRAPH
    {0xAA59, 0x6B23}, //1377 #CJK UNIFIED IDEOGRAPH
    {0xAA5A, 0x6B66}, //1378 #CJK UNIFIED IDEOGRAPH
    {0xAA5B, 0x6B67}, //1379 #CJK UNIFIED IDEOGRAPH
    {0xAA5C, 0x6B7F}, //1380 #CJK UNIFIED IDEOGRAPH
    {0xAA5D, 0x6C13}, //1381 #CJK UNIFIED IDEOGRAPH
    {0xAA5E, 0x6C1B}, //1382 #CJK UNIFIED IDEOGRAPH
    {0xAA5F, 0x6CE3}, //1383 #CJK UNIFIED IDEOGRAPH
    {0xAA60, 0x6CE8}, //1384 #CJK UNIFIED IDEOGRAPH
    {0xAA61, 0x6CF3}, //1385 #CJK UNIFIED IDEOGRAPH
    {0xAA62, 0x6CB1}, //1386 #CJK UNIFIED IDEOGRAPH
    {0xAA63, 0x6CCC}, //1387 #CJK UNIFIED IDEOGRAPH
    {0xAA64, 0x6CE5}, //1388 #CJK UNIFIED IDEOGRAPH
    {0xAA65, 0x6CB3}, //1389 #CJK UNIFIED IDEOGRAPH
    {0xAA66, 0x6CBD}, //1390 #CJK UNIFIED IDEOGRAPH
    {0xAA67, 0x6CBE}, //1391 #CJK UNIFIED IDEOGRAPH
    {0xAA68, 0x6CBC}, //1392 #CJK UNIFIED IDEOGRAPH
    {0xAA69, 0x6CE2}, //1393 #CJK UNIFIED IDEOGRAPH
    {0xAA6A, 0x6CAB}, //1394 #CJK UNIFIED IDEOGRAPH
    {0xAA6B, 0x6CD5}, //1395 #CJK UNIFIED IDEOGRAPH
    {0xAA6C, 0x6CD3}, //1396 #CJK UNIFIED IDEOGRAPH
    {0xAA6D, 0x6CB8}, //1397 #CJK UNIFIED IDEOGRAPH
    {0xAA6E, 0x6CC4}, //1398 #CJK UNIFIED IDEOGRAPH
    {0xAA6F, 0x6CB9}, //1399 #CJK UNIFIED IDEOGRAPH
    {0xAA70, 0x6CC1}, //1400 #CJK UNIFIED IDEOGRAPH
    {0xAA71, 0x6CAE}, //1401 #CJK UNIFIED IDEOGRAPH
    {0xAA72, 0x6CD7}, //1402 #CJK UNIFIED IDEOGRAPH
    {0xAA73, 0x6CC5}, //1403 #CJK UNIFIED IDEOGRAPH
    {0xAA74, 0x6CF1}, //1404 #CJK UNIFIED IDEOGRAPH
    {0xAA75, 0x6CBF}, //1405 #CJK UNIFIED IDEOGRAPH
    {0xAA76, 0x6CBB}, //1406 #CJK UNIFIED IDEOGRAPH
    {0xAA77, 0x6CE1}, //1407 #CJK UNIFIED IDEOGRAPH
    {0xAA78, 0x6CDB}, //1408 #CJK UNIFIED IDEOGRAPH
    {0xAA79, 0x6CCA}, //1409 #CJK UNIFIED IDEOGRAPH
    {0xAA7A, 0x6CAC}, //1410 #CJK UNIFIED IDEOGRAPH
    {0xAA7B, 0x6CEF}, //1411 #CJK UNIFIED IDEOGRAPH
    {0xAA7C, 0x6CDC}, //1412 #CJK UNIFIED IDEOGRAPH
    {0xAA7D, 0x6CD6}, //1413 #CJK UNIFIED IDEOGRAPH
    {0xAA7E, 0x6CE0}, //1414 #CJK UNIFIED IDEOGRAPH
    {0xAAA1, 0x7095}, //1415 #CJK UNIFIED IDEOGRAPH
    {0xAAA2, 0x708E}, //1416 #CJK UNIFIED IDEOGRAPH
    {0xAAA3, 0x7092}, //1417 #CJK UNIFIED IDEOGRAPH
    {0xAAA4, 0x708A}, //1418 #CJK UNIFIED IDEOGRAPH
    {0xAAA5, 0x7099}, //1419 #CJK UNIFIED IDEOGRAPH
    {0xAAA6, 0x722C}, //1420 #CJK UNIFIED IDEOGRAPH
    {0xAAA7, 0x722D}, //1421 #CJK UNIFIED IDEOGRAPH
    {0xAAA8, 0x7238}, //1422 #CJK UNIFIED IDEOGRAPH
    {0xAAA9, 0x7248}, //1423 #CJK UNIFIED IDEOGRAPH
    {0xAAAA, 0x7267}, //1424 #CJK UNIFIED IDEOGRAPH
    {0xAAAB, 0x7269}, //1425 #CJK UNIFIED IDEOGRAPH
    {0xAAAC, 0x72C0}, //1426 #CJK UNIFIED IDEOGRAPH
    {0xAAAD, 0x72CE}, //1427 #CJK UNIFIED IDEOGRAPH
    {0xAAAE, 0x72D9}, //1428 #CJK UNIFIED IDEOGRAPH
    {0xAAAF, 0x72D7}, //1429 #CJK UNIFIED IDEOGRAPH
    {0xAAB0, 0x72D0}, //1430 #CJK UNIFIED IDEOGRAPH
    {0xAAB1, 0x73A9}, //1431 #CJK UNIFIED IDEOGRAPH
    {0xAAB2, 0x73A8}, //1432 #CJK UNIFIED IDEOGRAPH
    {0xAAB3, 0x739F}, //1433 #CJK UNIFIED IDEOGRAPH
    {0xAAB4, 0x73AB}, //1434 #CJK UNIFIED IDEOGRAPH
    {0xAAB5, 0x73A5}, //1435 #CJK UNIFIED IDEOGRAPH
    {0xAAB6, 0x753D}, //1436 #CJK UNIFIED IDEOGRAPH
    {0xAAB7, 0x759D}, //1437 #CJK UNIFIED IDEOGRAPH
    {0xAAB8, 0x7599}, //1438 #CJK UNIFIED IDEOGRAPH
    {0xAAB9, 0x759A}, //1439 #CJK UNIFIED IDEOGRAPH
    {0xAABA, 0x7684}, //1440 #CJK UNIFIED IDEOGRAPH
    {0xAABB, 0x76C2}, //1441 #CJK UNIFIED IDEOGRAPH
    {0xAABC, 0x76F2}, //1442 #CJK UNIFIED IDEOGRAPH
    {0xAABD, 0x76F4}, //1443 #CJK UNIFIED IDEOGRAPH
    {0xAABE, 0x77E5}, //1444 #CJK UNIFIED IDEOGRAPH
    {0xAABF, 0x77FD}, //1445 #CJK UNIFIED IDEOGRAPH
    {0xAAC0, 0x793E}, //1446 #CJK UNIFIED IDEOGRAPH
    {0xAAC1, 0x7940}, //1447 #CJK UNIFIED IDEOGRAPH
    {0xAAC2, 0x7941}, //1448 #CJK UNIFIED IDEOGRAPH
    {0xAAC3, 0x79C9}, //1449 #CJK UNIFIED IDEOGRAPH
    {0xAAC4, 0x79C8}, //1450 #CJK UNIFIED IDEOGRAPH
    {0xAAC5, 0x7A7A}, //1451 #CJK UNIFIED IDEOGRAPH
    {0xAAC6, 0x7A79}, //1452 #CJK UNIFIED IDEOGRAPH
    {0xAAC7, 0x7AFA}, //1453 #CJK UNIFIED IDEOGRAPH
    {0xAAC8, 0x7CFE}, //1454 #CJK UNIFIED IDEOGRAPH
    {0xAAC9, 0x7F54}, //1455 #CJK UNIFIED IDEOGRAPH
    {0xAACA, 0x7F8C}, //1456 #CJK UNIFIED IDEOGRAPH
    {0xAACB, 0x7F8B}, //1457 #CJK UNIFIED IDEOGRAPH
    {0xAACC, 0x8005}, //1458 #CJK UNIFIED IDEOGRAPH
    {0xAACD, 0x80BA}, //1459 #CJK UNIFIED IDEOGRAPH
    {0xAACE, 0x80A5}, //1460 #CJK UNIFIED IDEOGRAPH
    {0xAACF, 0x80A2}, //1461 #CJK UNIFIED IDEOGRAPH
    {0xAAD0, 0x80B1}, //1462 #CJK UNIFIED IDEOGRAPH
    {0xAAD1, 0x80A1}, //1463 #CJK UNIFIED IDEOGRAPH
    {0xAAD2, 0x80AB}, //1464 #CJK UNIFIED IDEOGRAPH
    {0xAAD3, 0x80A9}, //1465 #CJK UNIFIED IDEOGRAPH
    {0xAAD4, 0x80B4}, //1466 #CJK UNIFIED IDEOGRAPH
    {0xAAD5, 0x80AA}, //1467 #CJK UNIFIED IDEOGRAPH
    {0xAAD6, 0x80AF}, //1468 #CJK UNIFIED IDEOGRAPH
    {0xAAD7, 0x81E5}, //1469 #CJK UNIFIED IDEOGRAPH
    {0xAAD8, 0x81FE}, //1470 #CJK UNIFIED IDEOGRAPH
    {0xAAD9, 0x820D}, //1471 #CJK UNIFIED IDEOGRAPH
    {0xAADA, 0x82B3}, //1472 #CJK UNIFIED IDEOGRAPH
    {0xAADB, 0x829D}, //1473 #CJK UNIFIED IDEOGRAPH
    {0xAADC, 0x8299}, //1474 #CJK UNIFIED IDEOGRAPH
    {0xAADD, 0x82AD}, //1475 #CJK UNIFIED IDEOGRAPH
    {0xAADE, 0x82BD}, //1476 #CJK UNIFIED IDEOGRAPH
    {0xAADF, 0x829F}, //1477 #CJK UNIFIED IDEOGRAPH
    {0xAAE0, 0x82B9}, //1478 #CJK UNIFIED IDEOGRAPH
    {0xAAE1, 0x82B1}, //1479 #CJK UNIFIED IDEOGRAPH
    {0xAAE2, 0x82AC}, //1480 #CJK UNIFIED IDEOGRAPH
    {0xAAE3, 0x82A5}, //1481 #CJK UNIFIED IDEOGRAPH
    {0xAAE4, 0x82AF}, //1482 #CJK UNIFIED IDEOGRAPH
    {0xAAE5, 0x82B8}, //1483 #CJK UNIFIED IDEOGRAPH
    {0xAAE6, 0x82A3}, //1484 #CJK UNIFIED IDEOGRAPH
    {0xAAE7, 0x82B0}, //1485 #CJK UNIFIED IDEOGRAPH
    {0xAAE8, 0x82BE}, //1486 #CJK UNIFIED IDEOGRAPH
    {0xAAE9, 0x82B7}, //1487 #CJK UNIFIED IDEOGRAPH
    {0xAAEA, 0x864E}, //1488 #CJK UNIFIED IDEOGRAPH
    {0xAAEB, 0x8671}, //1489 #CJK UNIFIED IDEOGRAPH
    {0xAAEC, 0x521D}, //1490 #CJK UNIFIED IDEOGRAPH
    {0xAAED, 0x8868}, //1491 #CJK UNIFIED IDEOGRAPH
    {0xAAEE, 0x8ECB}, //1492 #CJK UNIFIED IDEOGRAPH
    {0xAAEF, 0x8FCE}, //1493 #CJK UNIFIED IDEOGRAPH
    {0xAAF0, 0x8FD4}, //1494 #CJK UNIFIED IDEOGRAPH
    {0xAAF1, 0x8FD1}, //1495 #CJK UNIFIED IDEOGRAPH
    {0xAAF2, 0x90B5}, //1496 #CJK UNIFIED IDEOGRAPH
    {0xAAF3, 0x90B8}, //1497 #CJK UNIFIED IDEOGRAPH
    {0xAAF4, 0x90B1}, //1498 #CJK UNIFIED IDEOGRAPH
    {0xAAF5, 0x90B6}, //1499 #CJK UNIFIED IDEOGRAPH
    {0xAAF6, 0x91C7}, //1500 #CJK UNIFIED IDEOGRAPH
    {0xAAF7, 0x91D1}, //1501 #CJK UNIFIED IDEOGRAPH
    {0xAAF8, 0x9577}, //1502 #CJK UNIFIED IDEOGRAPH
    {0xAAF9, 0x9580}, //1503 #CJK UNIFIED IDEOGRAPH
    {0xAAFA, 0x961C}, //1504 #CJK UNIFIED IDEOGRAPH
    {0xAAFB, 0x9640}, //1505 #CJK UNIFIED IDEOGRAPH
    {0xAAFC, 0x963F}, //1506 #CJK UNIFIED IDEOGRAPH
    {0xAAFD, 0x963B}, //1507 #CJK UNIFIED IDEOGRAPH
    {0xAAFE, 0x9644}, //1508 #CJK UNIFIED IDEOGRAPH
    {0xAB40, 0x9642}, //1509 #CJK UNIFIED IDEOGRAPH
    {0xAB41, 0x96B9}, //1510 #CJK UNIFIED IDEOGRAPH
    {0xAB42, 0x96E8}, //1511 #CJK UNIFIED IDEOGRAPH
    {0xAB43, 0x9752}, //1512 #CJK UNIFIED IDEOGRAPH
    {0xAB44, 0x975E}, //1513 #CJK UNIFIED IDEOGRAPH
    {0xAB45, 0x4E9F}, //1514 #CJK UNIFIED IDEOGRAPH
    {0xAB46, 0x4EAD}, //1515 #CJK UNIFIED IDEOGRAPH
    {0xAB47, 0x4EAE}, //1516 #CJK UNIFIED IDEOGRAPH
    {0xAB48, 0x4FE1}, //1517 #CJK UNIFIED IDEOGRAPH
    {0xAB49, 0x4FB5}, //1518 #CJK UNIFIED IDEOGRAPH
    {0xAB4A, 0x4FAF}, //1519 #CJK UNIFIED IDEOGRAPH
    {0xAB4B, 0x4FBF}, //1520 #CJK UNIFIED IDEOGRAPH
    {0xAB4C, 0x4FE0}, //1521 #CJK UNIFIED IDEOGRAPH
    {0xAB4D, 0x4FD1}, //1522 #CJK UNIFIED IDEOGRAPH
    {0xAB4E, 0x4FCF}, //1523 #CJK UNIFIED IDEOGRAPH
    {0xAB4F, 0x4FDD}, //1524 #CJK UNIFIED IDEOGRAPH
    {0xAB50, 0x4FC3}, //1525 #CJK UNIFIED IDEOGRAPH
    {0xAB51, 0x4FB6}, //1526 #CJK UNIFIED IDEOGRAPH
    {0xAB52, 0x4FD8}, //1527 #CJK UNIFIED IDEOGRAPH
    {0xAB53, 0x4FDF}, //1528 #CJK UNIFIED IDEOGRAPH
    {0xAB54, 0x4FCA}, //1529 #CJK UNIFIED IDEOGRAPH
    {0xAB55, 0x4FD7}, //1530 #CJK UNIFIED IDEOGRAPH
    {0xAB56, 0x4FAE}, //1531 #CJK UNIFIED IDEOGRAPH
    {0xAB57, 0x4FD0}, //1532 #CJK UNIFIED IDEOGRAPH
    {0xAB58, 0x4FC4}, //1533 #CJK UNIFIED IDEOGRAPH
    {0xAB59, 0x4FC2}, //1534 #CJK UNIFIED IDEOGRAPH
    {0xAB5A, 0x4FDA}, //1535 #CJK UNIFIED IDEOGRAPH
    {0xAB5B, 0x4FCE}, //1536 #CJK UNIFIED IDEOGRAPH
    {0xAB5C, 0x4FDE}, //1537 #CJK UNIFIED IDEOGRAPH
    {0xAB5D, 0x4FB7}, //1538 #CJK UNIFIED IDEOGRAPH
    {0xAB5E, 0x5157}, //1539 #CJK UNIFIED IDEOGRAPH
    {0xAB5F, 0x5192}, //1540 #CJK UNIFIED IDEOGRAPH
    {0xAB60, 0x5191}, //1541 #CJK UNIFIED IDEOGRAPH
    {0xAB61, 0x51A0}, //1542 #CJK UNIFIED IDEOGRAPH
    {0xAB62, 0x524E}, //1543 #CJK UNIFIED IDEOGRAPH
    {0xAB63, 0x5243}, //1544 #CJK UNIFIED IDEOGRAPH
    {0xAB64, 0x524A}, //1545 #CJK UNIFIED IDEOGRAPH
    {0xAB65, 0x524D}, //1546 #CJK UNIFIED IDEOGRAPH
    {0xAB66, 0x524C}, //1547 #CJK UNIFIED IDEOGRAPH
    {0xAB67, 0x524B}, //1548 #CJK UNIFIED IDEOGRAPH
    {0xAB68, 0x5247}, //1549 #CJK UNIFIED IDEOGRAPH
    {0xAB69, 0x52C7}, //1550 #CJK UNIFIED IDEOGRAPH
    {0xAB6A, 0x52C9}, //1551 #CJK UNIFIED IDEOGRAPH
    {0xAB6B, 0x52C3}, //1552 #CJK UNIFIED IDEOGRAPH
    {0xAB6C, 0x52C1}, //1553 #CJK UNIFIED IDEOGRAPH
    {0xAB6D, 0x530D}, //1554 #CJK UNIFIED IDEOGRAPH
    {0xAB6E, 0x5357}, //1555 #CJK UNIFIED IDEOGRAPH
    {0xAB6F, 0x537B}, //1556 #CJK UNIFIED IDEOGRAPH
    {0xAB70, 0x539A}, //1557 #CJK UNIFIED IDEOGRAPH
    {0xAB71, 0x53DB}, //1558 #CJK UNIFIED IDEOGRAPH
    {0xAB72, 0x54AC}, //1559 #CJK UNIFIED IDEOGRAPH
    {0xAB73, 0x54C0}, //1560 #CJK UNIFIED IDEOGRAPH
    {0xAB74, 0x54A8}, //1561 #CJK UNIFIED IDEOGRAPH
    {0xAB75, 0x54CE}, //1562 #CJK UNIFIED IDEOGRAPH
    {0xAB76, 0x54C9}, //1563 #CJK UNIFIED IDEOGRAPH
    {0xAB77, 0x54B8}, //1564 #CJK UNIFIED IDEOGRAPH
    {0xAB78, 0x54A6}, //1565 #CJK UNIFIED IDEOGRAPH
    {0xAB79, 0x54B3}, //1566 #CJK UNIFIED IDEOGRAPH
    {0xAB7A, 0x54C7}, //1567 #CJK UNIFIED IDEOGRAPH
    {0xAB7B, 0x54C2}, //1568 #CJK UNIFIED IDEOGRAPH
    {0xAB7C, 0x54BD}, //1569 #CJK UNIFIED IDEOGRAPH
    {0xAB7D, 0x54AA}, //1570 #CJK UNIFIED IDEOGRAPH
    {0xAB7E, 0x54C1}, //1571 #CJK UNIFIED IDEOGRAPH
    {0xABA1, 0x54C4}, //1572 #CJK UNIFIED IDEOGRAPH
    {0xABA2, 0x54C8}, //1573 #CJK UNIFIED IDEOGRAPH
    {0xABA3, 0x54AF}, //1574 #CJK UNIFIED IDEOGRAPH
    {0xABA4, 0x54AB}, //1575 #CJK UNIFIED IDEOGRAPH
    {0xABA5, 0x54B1}, //1576 #CJK UNIFIED IDEOGRAPH
    {0xABA6, 0x54BB}, //1577 #CJK UNIFIED IDEOGRAPH
    {0xABA7, 0x54A9}, //1578 #CJK UNIFIED IDEOGRAPH
    {0xABA8, 0x54A7}, //1579 #CJK UNIFIED IDEOGRAPH
    {0xABA9, 0x54BF}, //1580 #CJK UNIFIED IDEOGRAPH
    {0xABAA, 0x56FF}, //1581 #CJK UNIFIED IDEOGRAPH
    {0xABAB, 0x5782}, //1582 #CJK UNIFIED IDEOGRAPH
    {0xABAC, 0x578B}, //1583 #CJK UNIFIED IDEOGRAPH
    {0xABAD, 0x57A0}, //1584 #CJK UNIFIED IDEOGRAPH
    {0xABAE, 0x57A3}, //1585 #CJK UNIFIED IDEOGRAPH
    {0xABAF, 0x57A2}, //1586 #CJK UNIFIED IDEOGRAPH
    {0xABB0, 0x57CE}, //1587 #CJK UNIFIED IDEOGRAPH
    {0xABB1, 0x57AE}, //1588 #CJK UNIFIED IDEOGRAPH
    {0xABB2, 0x5793}, //1589 #CJK UNIFIED IDEOGRAPH
    {0xABB3, 0x5955}, //1590 #CJK UNIFIED IDEOGRAPH
    {0xABB4, 0x5951}, //1591 #CJK UNIFIED IDEOGRAPH
    {0xABB5, 0x594F}, //1592 #CJK UNIFIED IDEOGRAPH
    {0xABB6, 0x594E}, //1593 #CJK UNIFIED IDEOGRAPH
    {0xABB7, 0x5950}, //1594 #CJK UNIFIED IDEOGRAPH
    {0xABB8, 0x59DC}, //1595 #CJK UNIFIED IDEOGRAPH
    {0xABB9, 0x59D8}, //1596 #CJK UNIFIED IDEOGRAPH
    {0xABBA, 0x59FF}, //1597 #CJK UNIFIED IDEOGRAPH
    {0xABBB, 0x59E3}, //1598 #CJK UNIFIED IDEOGRAPH
    {0xABBC, 0x59E8}, //1599 #CJK UNIFIED IDEOGRAPH
    {0xABBD, 0x5A03}, //1600 #CJK UNIFIED IDEOGRAPH
    {0xABBE, 0x59E5}, //1601 #CJK UNIFIED IDEOGRAPH
    {0xABBF, 0x59EA}, //1602 #CJK UNIFIED IDEOGRAPH
    {0xABC0, 0x59DA}, //1603 #CJK UNIFIED IDEOGRAPH
    {0xABC1, 0x59E6}, //1604 #CJK UNIFIED IDEOGRAPH
    {0xABC2, 0x5A01}, //1605 #CJK UNIFIED IDEOGRAPH
    {0xABC3, 0x59FB}, //1606 #CJK UNIFIED IDEOGRAPH
    {0xABC4, 0x5B69}, //1607 #CJK UNIFIED IDEOGRAPH
    {0xABC5, 0x5BA3}, //1608 #CJK UNIFIED IDEOGRAPH
    {0xABC6, 0x5BA6}, //1609 #CJK UNIFIED IDEOGRAPH
    {0xABC7, 0x5BA4}, //1610 #CJK UNIFIED IDEOGRAPH
    {0xABC8, 0x5BA2}, //1611 #CJK UNIFIED IDEOGRAPH
    {0xABC9, 0x5BA5}, //1612 #CJK UNIFIED IDEOGRAPH
    {0xABCA, 0x5C01}, //1613 #CJK UNIFIED IDEOGRAPH
    {0xABCB, 0x5C4E}, //1614 #CJK UNIFIED IDEOGRAPH
    {0xABCC, 0x5C4F}, //1615 #CJK UNIFIED IDEOGRAPH
    {0xABCD, 0x5C4D}, //1616 #CJK UNIFIED IDEOGRAPH
    {0xABCE, 0x5C4B}, //1617 #CJK UNIFIED IDEOGRAPH
    {0xABCF, 0x5CD9}, //1618 #CJK UNIFIED IDEOGRAPH
    {0xABD0, 0x5CD2}, //1619 #CJK UNIFIED IDEOGRAPH
    {0xABD1, 0x5DF7}, //1620 #CJK UNIFIED IDEOGRAPH
    {0xABD2, 0x5E1D}, //1621 #CJK UNIFIED IDEOGRAPH
    {0xABD3, 0x5E25}, //1622 #CJK UNIFIED IDEOGRAPH
    {0xABD4, 0x5E1F}, //1623 #CJK UNIFIED IDEOGRAPH
    {0xABD5, 0x5E7D}, //1624 #CJK UNIFIED IDEOGRAPH
    {0xABD6, 0x5EA0}, //1625 #CJK UNIFIED IDEOGRAPH
    {0xABD7, 0x5EA6}, //1626 #CJK UNIFIED IDEOGRAPH
    {0xABD8, 0x5EFA}, //1627 #CJK UNIFIED IDEOGRAPH
    {0xABD9, 0x5F08}, //1628 #CJK UNIFIED IDEOGRAPH
    {0xABDA, 0x5F2D}, //1629 #CJK UNIFIED IDEOGRAPH
    {0xABDB, 0x5F65}, //1630 #CJK UNIFIED IDEOGRAPH
    {0xABDC, 0x5F88}, //1631 #CJK UNIFIED IDEOGRAPH
    {0xABDD, 0x5F85}, //1632 #CJK UNIFIED IDEOGRAPH
    {0xABDE, 0x5F8A}, //1633 #CJK UNIFIED IDEOGRAPH
    {0xABDF, 0x5F8B}, //1634 #CJK UNIFIED IDEOGRAPH
    {0xABE0, 0x5F87}, //1635 #CJK UNIFIED IDEOGRAPH
    {0xABE1, 0x5F8C}, //1636 #CJK UNIFIED IDEOGRAPH
    {0xABE2, 0x5F89}, //1637 #CJK UNIFIED IDEOGRAPH
    {0xABE3, 0x6012}, //1638 #CJK UNIFIED IDEOGRAPH
    {0xABE4, 0x601D}, //1639 #CJK UNIFIED IDEOGRAPH
    {0xABE5, 0x6020}, //1640 #CJK UNIFIED IDEOGRAPH
    {0xABE6, 0x6025}, //1641 #CJK UNIFIED IDEOGRAPH
    {0xABE7, 0x600E}, //1642 #CJK UNIFIED IDEOGRAPH
    {0xABE8, 0x6028}, //1643 #CJK UNIFIED IDEOGRAPH
    {0xABE9, 0x604D}, //1644 #CJK UNIFIED IDEOGRAPH
    {0xABEA, 0x6070}, //1645 #CJK UNIFIED IDEOGRAPH
    {0xABEB, 0x6068}, //1646 #CJK UNIFIED IDEOGRAPH
    {0xABEC, 0x6062}, //1647 #CJK UNIFIED IDEOGRAPH
    {0xABED, 0x6046}, //1648 #CJK UNIFIED IDEOGRAPH
    {0xABEE, 0x6043}, //1649 #CJK UNIFIED IDEOGRAPH
    {0xABEF, 0x606C}, //1650 #CJK UNIFIED IDEOGRAPH
    {0xABF0, 0x606B}, //1651 #CJK UNIFIED IDEOGRAPH
    {0xABF1, 0x606A}, //1652 #CJK UNIFIED IDEOGRAPH
    {0xABF2, 0x6064}, //1653 #CJK UNIFIED IDEOGRAPH
    {0xABF3, 0x6241}, //1654 #CJK UNIFIED IDEOGRAPH
    {0xABF4, 0x62DC}, //1655 #CJK UNIFIED IDEOGRAPH
    {0xABF5, 0x6316}, //1656 #CJK UNIFIED IDEOGRAPH
    {0xABF6, 0x6309}, //1657 #CJK UNIFIED IDEOGRAPH
    {0xABF7, 0x62FC}, //1658 #CJK UNIFIED IDEOGRAPH
    {0xABF8, 0x62ED}, //1659 #CJK UNIFIED IDEOGRAPH
    {0xABF9, 0x6301}, //1660 #CJK UNIFIED IDEOGRAPH
    {0xABFA, 0x62EE}, //1661 #CJK UNIFIED IDEOGRAPH
    {0xABFB, 0x62FD}, //1662 #CJK UNIFIED IDEOGRAPH
    {0xABFC, 0x6307}, //1663 #CJK UNIFIED IDEOGRAPH
    {0xABFD, 0x62F1}, //1664 #CJK UNIFIED IDEOGRAPH
    {0xABFE, 0x62F7}, //1665 #CJK UNIFIED IDEOGRAPH
    {0xAC40, 0x62EF}, //1666 #CJK UNIFIED IDEOGRAPH
    {0xAC41, 0x62EC}, //1667 #CJK UNIFIED IDEOGRAPH
    {0xAC42, 0x62FE}, //1668 #CJK UNIFIED IDEOGRAPH
    {0xAC43, 0x62F4}, //1669 #CJK UNIFIED IDEOGRAPH
    {0xAC44, 0x6311}, //1670 #CJK UNIFIED IDEOGRAPH
    {0xAC45, 0x6302}, //1671 #CJK UNIFIED IDEOGRAPH
    {0xAC46, 0x653F}, //1672 #CJK UNIFIED IDEOGRAPH
    {0xAC47, 0x6545}, //1673 #CJK UNIFIED IDEOGRAPH
    {0xAC48, 0x65AB}, //1674 #CJK UNIFIED IDEOGRAPH
    {0xAC49, 0x65BD}, //1675 #CJK UNIFIED IDEOGRAPH
    {0xAC4A, 0x65E2}, //1676 #CJK UNIFIED IDEOGRAPH
    {0xAC4B, 0x6625}, //1677 #CJK UNIFIED IDEOGRAPH
    {0xAC4C, 0x662D}, //1678 #CJK UNIFIED IDEOGRAPH
    {0xAC4D, 0x6620}, //1679 #CJK UNIFIED IDEOGRAPH
    {0xAC4E, 0x6627}, //1680 #CJK UNIFIED IDEOGRAPH
    {0xAC4F, 0x662F}, //1681 #CJK UNIFIED IDEOGRAPH
    {0xAC50, 0x661F}, //1682 #CJK UNIFIED IDEOGRAPH
    {0xAC51, 0x6628}, //1683 #CJK UNIFIED IDEOGRAPH
    {0xAC52, 0x6631}, //1684 #CJK UNIFIED IDEOGRAPH
    {0xAC53, 0x6624}, //1685 #CJK UNIFIED IDEOGRAPH
    {0xAC54, 0x66F7}, //1686 #CJK UNIFIED IDEOGRAPH
    {0xAC55, 0x67FF}, //1687 #CJK UNIFIED IDEOGRAPH
    {0xAC56, 0x67D3}, //1688 #CJK UNIFIED IDEOGRAPH
    {0xAC57, 0x67F1}, //1689 #CJK UNIFIED IDEOGRAPH
    {0xAC58, 0x67D4}, //1690 #CJK UNIFIED IDEOGRAPH
    {0xAC59, 0x67D0}, //1691 #CJK UNIFIED IDEOGRAPH
    {0xAC5A, 0x67EC}, //1692 #CJK UNIFIED IDEOGRAPH
    {0xAC5B, 0x67B6}, //1693 #CJK UNIFIED IDEOGRAPH
    {0xAC5C, 0x67AF}, //1694 #CJK UNIFIED IDEOGRAPH
    {0xAC5D, 0x67F5}, //1695 #CJK UNIFIED IDEOGRAPH
    {0xAC5E, 0x67E9}, //1696 #CJK UNIFIED IDEOGRAPH
    {0xAC5F, 0x67EF}, //1697 #CJK UNIFIED IDEOGRAPH
    {0xAC60, 0x67C4}, //1698 #CJK UNIFIED IDEOGRAPH
    {0xAC61, 0x67D1}, //1699 #CJK UNIFIED IDEOGRAPH
    {0xAC62, 0x67B4}, //1700 #CJK UNIFIED IDEOGRAPH
    {0xAC63, 0x67DA}, //1701 #CJK UNIFIED IDEOGRAPH
    {0xAC64, 0x67E5}, //1702 #CJK UNIFIED IDEOGRAPH
    {0xAC65, 0x67B8}, //1703 #CJK UNIFIED IDEOGRAPH
    {0xAC66, 0x67CF}, //1704 #CJK UNIFIED IDEOGRAPH
    {0xAC67, 0x67DE}, //1705 #CJK UNIFIED IDEOGRAPH
    {0xAC68, 0x67F3}, //1706 #CJK UNIFIED IDEOGRAPH
    {0xAC69, 0x67B0}, //1707 #CJK UNIFIED IDEOGRAPH
    {0xAC6A, 0x67D9}, //1708 #CJK UNIFIED IDEOGRAPH
    {0xAC6B, 0x67E2}, //1709 #CJK UNIFIED IDEOGRAPH
    {0xAC6C, 0x67DD}, //1710 #CJK UNIFIED IDEOGRAPH
    {0xAC6D, 0x67D2}, //1711 #CJK UNIFIED IDEOGRAPH
    {0xAC6E, 0x6B6A}, //1712 #CJK UNIFIED IDEOGRAPH
    {0xAC6F, 0x6B83}, //1713 #CJK UNIFIED IDEOGRAPH
    {0xAC70, 0x6B86}, //1714 #CJK UNIFIED IDEOGRAPH
    {0xAC71, 0x6BB5}, //1715 #CJK UNIFIED IDEOGRAPH
    {0xAC72, 0x6BD2}, //1716 #CJK UNIFIED IDEOGRAPH
    {0xAC73, 0x6BD7}, //1717 #CJK UNIFIED IDEOGRAPH
    {0xAC74, 0x6C1F}, //1718 #CJK UNIFIED IDEOGRAPH
    {0xAC75, 0x6CC9}, //1719 #CJK UNIFIED IDEOGRAPH
    {0xAC76, 0x6D0B}, //1720 #CJK UNIFIED IDEOGRAPH
    {0xAC77, 0x6D32}, //1721 #CJK UNIFIED IDEOGRAPH
    {0xAC78, 0x6D2A}, //1722 #CJK UNIFIED IDEOGRAPH
    {0xAC79, 0x6D41}, //1723 #CJK UNIFIED IDEOGRAPH
    {0xAC7A, 0x6D25}, //1724 #CJK UNIFIED IDEOGRAPH
    {0xAC7B, 0x6D0C}, //1725 #CJK UNIFIED IDEOGRAPH
    {0xAC7C, 0x6D31}, //1726 #CJK UNIFIED IDEOGRAPH
    {0xAC7D, 0x6D1E}, //1727 #CJK UNIFIED IDEOGRAPH
    {0xAC7E, 0x6D17}, //1728 #CJK UNIFIED IDEOGRAPH
    {0xACA1, 0x6D3B}, //1729 #CJK UNIFIED IDEOGRAPH
    {0xACA2, 0x6D3D}, //1730 #CJK UNIFIED IDEOGRAPH
    {0xACA3, 0x6D3E}, //1731 #CJK UNIFIED IDEOGRAPH
    {0xACA4, 0x6D36}, //1732 #CJK UNIFIED IDEOGRAPH
    {0xACA5, 0x6D1B}, //1733 #CJK UNIFIED IDEOGRAPH
    {0xACA6, 0x6CF5}, //1734 #CJK UNIFIED IDEOGRAPH
    {0xACA7, 0x6D39}, //1735 #CJK UNIFIED IDEOGRAPH
    {0xACA8, 0x6D27}, //1736 #CJK UNIFIED IDEOGRAPH
    {0xACA9, 0x6D38}, //1737 #CJK UNIFIED IDEOGRAPH
    {0xACAA, 0x6D29}, //1738 #CJK UNIFIED IDEOGRAPH
    {0xACAB, 0x6D2E}, //1739 #CJK UNIFIED IDEOGRAPH
    {0xACAC, 0x6D35}, //1740 #CJK UNIFIED IDEOGRAPH
    {0xACAD, 0x6D0E}, //1741 #CJK UNIFIED IDEOGRAPH
    {0xACAE, 0x6D2B}, //1742 #CJK UNIFIED IDEOGRAPH
    {0xACAF, 0x70AB}, //1743 #CJK UNIFIED IDEOGRAPH
    {0xACB0, 0x70BA}, //1744 #CJK UNIFIED IDEOGRAPH
    {0xACB1, 0x70B3}, //1745 #CJK UNIFIED IDEOGRAPH
    {0xACB2, 0x70AC}, //1746 #CJK UNIFIED IDEOGRAPH
    {0xACB3, 0x70AF}, //1747 #CJK UNIFIED IDEOGRAPH
    {0xACB4, 0x70AD}, //1748 #CJK UNIFIED IDEOGRAPH
    {0xACB5, 0x70B8}, //1749 #CJK UNIFIED IDEOGRAPH
    {0xACB6, 0x70AE}, //1750 #CJK UNIFIED IDEOGRAPH
    {0xACB7, 0x70A4}, //1751 #CJK UNIFIED IDEOGRAPH
    {0xACB8, 0x7230}, //1752 #CJK UNIFIED IDEOGRAPH
    {0xACB9, 0x7272}, //1753 #CJK UNIFIED IDEOGRAPH
    {0xACBA, 0x726F}, //1754 #CJK UNIFIED IDEOGRAPH
    {0xACBB, 0x7274}, //1755 #CJK UNIFIED IDEOGRAPH
    {0xACBC, 0x72E9}, //1756 #CJK UNIFIED IDEOGRAPH
    {0xACBD, 0x72E0}, //1757 #CJK UNIFIED IDEOGRAPH
    {0xACBE, 0x72E1}, //1758 #CJK UNIFIED IDEOGRAPH
    {0xACBF, 0x73B7}, //1759 #CJK UNIFIED IDEOGRAPH
    {0xACC0, 0x73CA}, //1760 #CJK UNIFIED IDEOGRAPH
    {0xACC1, 0x73BB}, //1761 #CJK UNIFIED IDEOGRAPH
    {0xACC2, 0x73B2}, //1762 #CJK UNIFIED IDEOGRAPH
    {0xACC3, 0x73CD}, //1763 #CJK UNIFIED IDEOGRAPH
    {0xACC4, 0x73C0}, //1764 #CJK UNIFIED IDEOGRAPH
    {0xACC5, 0x73B3}, //1765 #CJK UNIFIED IDEOGRAPH
    {0xACC6, 0x751A}, //1766 #CJK UNIFIED IDEOGRAPH
    {0xACC7, 0x752D}, //1767 #CJK UNIFIED IDEOGRAPH
    {0xACC8, 0x754F}, //1768 #CJK UNIFIED IDEOGRAPH
    {0xACC9, 0x754C}, //1769 #CJK UNIFIED IDEOGRAPH
    {0xACCA, 0x754E}, //1770 #CJK UNIFIED IDEOGRAPH
    {0xACCB, 0x754B}, //1771 #CJK UNIFIED IDEOGRAPH
    {0xACCC, 0x75AB}, //1772 #CJK UNIFIED IDEOGRAPH
    {0xACCD, 0x75A4}, //1773 #CJK UNIFIED IDEOGRAPH
    {0xACCE, 0x75A5}, //1774 #CJK UNIFIED IDEOGRAPH
    {0xACCF, 0x75A2}, //1775 #CJK UNIFIED IDEOGRAPH
    {0xACD0, 0x75A3}, //1776 #CJK UNIFIED IDEOGRAPH
    {0xACD1, 0x7678}, //1777 #CJK UNIFIED IDEOGRAPH
    {0xACD2, 0x7686}, //1778 #CJK UNIFIED IDEOGRAPH
    {0xACD3, 0x7687}, //1779 #CJK UNIFIED IDEOGRAPH
    {0xACD4, 0x7688}, //1780 #CJK UNIFIED IDEOGRAPH
    {0xACD5, 0x76C8}, //1781 #CJK UNIFIED IDEOGRAPH
    {0xACD6, 0x76C6}, //1782 #CJK UNIFIED IDEOGRAPH
    {0xACD7, 0x76C3}, //1783 #CJK UNIFIED IDEOGRAPH
    {0xACD8, 0x76C5}, //1784 #CJK UNIFIED IDEOGRAPH
    {0xACD9, 0x7701}, //1785 #CJK UNIFIED IDEOGRAPH
    {0xACDA, 0x76F9}, //1786 #CJK UNIFIED IDEOGRAPH
    {0xACDB, 0x76F8}, //1787 #CJK UNIFIED IDEOGRAPH
    {0xACDC, 0x7709}, //1788 #CJK UNIFIED IDEOGRAPH
    {0xACDD, 0x770B}, //1789 #CJK UNIFIED IDEOGRAPH
    {0xACDE, 0x76FE}, //1790 #CJK UNIFIED IDEOGRAPH
    {0xACDF, 0x76FC}, //1791 #CJK UNIFIED IDEOGRAPH
    {0xACE0, 0x7707}, //1792 #CJK UNIFIED IDEOGRAPH
    {0xACE1, 0x77DC}, //1793 #CJK UNIFIED IDEOGRAPH
    {0xACE2, 0x7802}, //1794 #CJK UNIFIED IDEOGRAPH
    {0xACE3, 0x7814}, //1795 #CJK UNIFIED IDEOGRAPH
    {0xACE4, 0x780C}, //1796 #CJK UNIFIED IDEOGRAPH
    {0xACE5, 0x780D}, //1797 #CJK UNIFIED IDEOGRAPH
    {0xACE6, 0x7946}, //1798 #CJK UNIFIED IDEOGRAPH
    {0xACE7, 0x7949}, //1799 #CJK UNIFIED IDEOGRAPH
    {0xACE8, 0x7948}, //1800 #CJK UNIFIED IDEOGRAPH
    {0xACE9, 0x7947}, //1801 #CJK UNIFIED IDEOGRAPH
    {0xACEA, 0x79B9}, //1802 #CJK UNIFIED IDEOGRAPH
    {0xACEB, 0x79BA}, //1803 #CJK UNIFIED IDEOGRAPH
    {0xACEC, 0x79D1}, //1804 #CJK UNIFIED IDEOGRAPH
    {0xACED, 0x79D2}, //1805 #CJK UNIFIED IDEOGRAPH
    {0xACEE, 0x79CB}, //1806 #CJK UNIFIED IDEOGRAPH
    {0xACEF, 0x7A7F}, //1807 #CJK UNIFIED IDEOGRAPH
    {0xACF0, 0x7A81}, //1808 #CJK UNIFIED IDEOGRAPH
    {0xACF1, 0x7AFF}, //1809 #CJK UNIFIED IDEOGRAPH
    {0xACF2, 0x7AFD}, //1810 #CJK UNIFIED IDEOGRAPH
    {0xACF3, 0x7C7D}, //1811 #CJK UNIFIED IDEOGRAPH
    {0xACF4, 0x7D02}, //1812 #CJK UNIFIED IDEOGRAPH
    {0xACF5, 0x7D05}, //1813 #CJK UNIFIED IDEOGRAPH
    {0xACF6, 0x7D00}, //1814 #CJK UNIFIED IDEOGRAPH
    {0xACF7, 0x7D09}, //1815 #CJK UNIFIED IDEOGRAPH
    {0xACF8, 0x7D07}, //1816 #CJK UNIFIED IDEOGRAPH
    {0xACF9, 0x7D04}, //1817 #CJK UNIFIED IDEOGRAPH
    {0xACFA, 0x7D06}, //1818 #CJK UNIFIED IDEOGRAPH
    {0xACFB, 0x7F38}, //1819 #CJK UNIFIED IDEOGRAPH
    {0xACFC, 0x7F8E}, //1820 #CJK UNIFIED IDEOGRAPH
    {0xACFD, 0x7FBF}, //1821 #CJK UNIFIED IDEOGRAPH
    {0xACFE, 0x8004}, //1822 #CJK UNIFIED IDEOGRAPH
    {0xAD40, 0x8010}, //1823 #CJK UNIFIED IDEOGRAPH
    {0xAD41, 0x800D}, //1824 #CJK UNIFIED IDEOGRAPH
    {0xAD42, 0x8011}, //1825 #CJK UNIFIED IDEOGRAPH
    {0xAD43, 0x8036}, //1826 #CJK UNIFIED IDEOGRAPH
    {0xAD44, 0x80D6}, //1827 #CJK UNIFIED IDEOGRAPH
    {0xAD45, 0x80E5}, //1828 #CJK UNIFIED IDEOGRAPH
    {0xAD46, 0x80DA}, //1829 #CJK UNIFIED IDEOGRAPH
    {0xAD47, 0x80C3}, //1830 #CJK UNIFIED IDEOGRAPH
    {0xAD48, 0x80C4}, //1831 #CJK UNIFIED IDEOGRAPH
    {0xAD49, 0x80CC}, //1832 #CJK UNIFIED IDEOGRAPH
    {0xAD4A, 0x80E1}, //1833 #CJK UNIFIED IDEOGRAPH
    {0xAD4B, 0x80DB}, //1834 #CJK UNIFIED IDEOGRAPH
    {0xAD4C, 0x80CE}, //1835 #CJK UNIFIED IDEOGRAPH
    {0xAD4D, 0x80DE}, //1836 #CJK UNIFIED IDEOGRAPH
    {0xAD4E, 0x80E4}, //1837 #CJK UNIFIED IDEOGRAPH
    {0xAD4F, 0x80DD}, //1838 #CJK UNIFIED IDEOGRAPH
    {0xAD50, 0x81F4}, //1839 #CJK UNIFIED IDEOGRAPH
    {0xAD51, 0x8222}, //1840 #CJK UNIFIED IDEOGRAPH
    {0xAD52, 0x82E7}, //1841 #CJK UNIFIED IDEOGRAPH
    {0xAD53, 0x8303}, //1842 #CJK UNIFIED IDEOGRAPH
    {0xAD54, 0x8305}, //1843 #CJK UNIFIED IDEOGRAPH
    {0xAD55, 0x82E3}, //1844 #CJK UNIFIED IDEOGRAPH
    {0xAD56, 0x82DB}, //1845 #CJK UNIFIED IDEOGRAPH
    {0xAD57, 0x82E6}, //1846 #CJK UNIFIED IDEOGRAPH
    {0xAD58, 0x8304}, //1847 #CJK UNIFIED IDEOGRAPH
    {0xAD59, 0x82E5}, //1848 #CJK UNIFIED IDEOGRAPH
    {0xAD5A, 0x8302}, //1849 #CJK UNIFIED IDEOGRAPH
    {0xAD5B, 0x8309}, //1850 #CJK UNIFIED IDEOGRAPH
    {0xAD5C, 0x82D2}, //1851 #CJK UNIFIED IDEOGRAPH
    {0xAD5D, 0x82D7}, //1852 #CJK UNIFIED IDEOGRAPH
    {0xAD5E, 0x82F1}, //1853 #CJK UNIFIED IDEOGRAPH
    {0xAD5F, 0x8301}, //1854 #CJK UNIFIED IDEOGRAPH
    {0xAD60, 0x82DC}, //1855 #CJK UNIFIED IDEOGRAPH
    {0xAD61, 0x82D4}, //1856 #CJK UNIFIED IDEOGRAPH
    {0xAD62, 0x82D1}, //1857 #CJK UNIFIED IDEOGRAPH
    {0xAD63, 0x82DE}, //1858 #CJK UNIFIED IDEOGRAPH
    {0xAD64, 0x82D3}, //1859 #CJK UNIFIED IDEOGRAPH
    {0xAD65, 0x82DF}, //1860 #CJK UNIFIED IDEOGRAPH
    {0xAD66, 0x82EF}, //1861 #CJK UNIFIED IDEOGRAPH
    {0xAD67, 0x8306}, //1862 #CJK UNIFIED IDEOGRAPH
    {0xAD68, 0x8650}, //1863 #CJK UNIFIED IDEOGRAPH
    {0xAD69, 0x8679}, //1864 #CJK UNIFIED IDEOGRAPH
    {0xAD6A, 0x867B}, //1865 #CJK UNIFIED IDEOGRAPH
    {0xAD6B, 0x867A}, //1866 #CJK UNIFIED IDEOGRAPH
    {0xAD6C, 0x884D}, //1867 #CJK UNIFIED IDEOGRAPH
    {0xAD6D, 0x886B}, //1868 #CJK UNIFIED IDEOGRAPH
    {0xAD6E, 0x8981}, //1869 #CJK UNIFIED IDEOGRAPH
    {0xAD6F, 0x89D4}, //1870 #CJK UNIFIED IDEOGRAPH
    {0xAD70, 0x8A08}, //1871 #CJK UNIFIED IDEOGRAPH
    {0xAD71, 0x8A02}, //1872 #CJK UNIFIED IDEOGRAPH
    {0xAD72, 0x8A03}, //1873 #CJK UNIFIED IDEOGRAPH
    {0xAD73, 0x8C9E}, //1874 #CJK UNIFIED IDEOGRAPH
    {0xAD74, 0x8CA0}, //1875 #CJK UNIFIED IDEOGRAPH
    {0xAD75, 0x8D74}, //1876 #CJK UNIFIED IDEOGRAPH
    {0xAD76, 0x8D73}, //1877 #CJK UNIFIED IDEOGRAPH
    {0xAD77, 0x8DB4}, //1878 #CJK UNIFIED IDEOGRAPH
    {0xAD78, 0x8ECD}, //1879 #CJK UNIFIED IDEOGRAPH
    {0xAD79, 0x8ECC}, //1880 #CJK UNIFIED IDEOGRAPH
    {0xAD7A, 0x8FF0}, //1881 #CJK UNIFIED IDEOGRAPH
    {0xAD7B, 0x8FE6}, //1882 #CJK UNIFIED IDEOGRAPH
    {0xAD7C, 0x8FE2}, //1883 #CJK UNIFIED IDEOGRAPH
    {0xAD7D, 0x8FEA}, //1884 #CJK UNIFIED IDEOGRAPH
    {0xAD7E, 0x8FE5}, //1885 #CJK UNIFIED IDEOGRAPH
    {0xADA1, 0x8FED}, //1886 #CJK UNIFIED IDEOGRAPH
    {0xADA2, 0x8FEB}, //1887 #CJK UNIFIED IDEOGRAPH
    {0xADA3, 0x8FE4}, //1888 #CJK UNIFIED IDEOGRAPH
    {0xADA4, 0x8FE8}, //1889 #CJK UNIFIED IDEOGRAPH
    {0xADA5, 0x90CA}, //1890 #CJK UNIFIED IDEOGRAPH
    {0xADA6, 0x90CE}, //1891 #CJK UNIFIED IDEOGRAPH
    {0xADA7, 0x90C1}, //1892 #CJK UNIFIED IDEOGRAPH
    {0xADA8, 0x90C3}, //1893 #CJK UNIFIED IDEOGRAPH
    {0xADA9, 0x914B}, //1894 #CJK UNIFIED IDEOGRAPH
    {0xADAA, 0x914A}, //1895 #CJK UNIFIED IDEOGRAPH
    {0xADAB, 0x91CD}, //1896 #CJK UNIFIED IDEOGRAPH
    {0xADAC, 0x9582}, //1897 #CJK UNIFIED IDEOGRAPH
    {0xADAD, 0x9650}, //1898 #CJK UNIFIED IDEOGRAPH
    {0xADAE, 0x964B}, //1899 #CJK UNIFIED IDEOGRAPH
    {0xADAF, 0x964C}, //1900 #CJK UNIFIED IDEOGRAPH
    {0xADB0, 0x964D}, //1901 #CJK UNIFIED IDEOGRAPH
    {0xADB1, 0x9762}, //1902 #CJK UNIFIED IDEOGRAPH
    {0xADB2, 0x9769}, //1903 #CJK UNIFIED IDEOGRAPH
    {0xADB3, 0x97CB}, //1904 #CJK UNIFIED IDEOGRAPH
    {0xADB4, 0x97ED}, //1905 #CJK UNIFIED IDEOGRAPH
    {0xADB5, 0x97F3}, //1906 #CJK UNIFIED IDEOGRAPH
    {0xADB6, 0x9801}, //1907 #CJK UNIFIED IDEOGRAPH
    {0xADB7, 0x98A8}, //1908 #CJK UNIFIED IDEOGRAPH
    {0xADB8, 0x98DB}, //1909 #CJK UNIFIED IDEOGRAPH
    {0xADB9, 0x98DF}, //1910 #CJK UNIFIED IDEOGRAPH
    {0xADBA, 0x9996}, //1911 #CJK UNIFIED IDEOGRAPH
    {0xADBB, 0x9999}, //1912 #CJK UNIFIED IDEOGRAPH
    {0xADBC, 0x4E58}, //1913 #CJK UNIFIED IDEOGRAPH
    {0xADBD, 0x4EB3}, //1914 #CJK UNIFIED IDEOGRAPH
    {0xADBE, 0x500C}, //1915 #CJK UNIFIED IDEOGRAPH
    {0xADBF, 0x500D}, //1916 #CJK UNIFIED IDEOGRAPH
    {0xADC0, 0x5023}, //1917 #CJK UNIFIED IDEOGRAPH
    {0xADC1, 0x4FEF}, //1918 #CJK UNIFIED IDEOGRAPH
    {0xADC2, 0x5026}, //1919 #CJK UNIFIED IDEOGRAPH
    {0xADC3, 0x5025}, //1920 #CJK UNIFIED IDEOGRAPH
    {0xADC4, 0x4FF8}, //1921 #CJK UNIFIED IDEOGRAPH
    {0xADC5, 0x5029}, //1922 #CJK UNIFIED IDEOGRAPH
    {0xADC6, 0x5016}, //1923 #CJK UNIFIED IDEOGRAPH
    {0xADC7, 0x5006}, //1924 #CJK UNIFIED IDEOGRAPH
    {0xADC8, 0x503C}, //1925 #CJK UNIFIED IDEOGRAPH
    {0xADC9, 0x501F}, //1926 #CJK UNIFIED IDEOGRAPH
    {0xADCA, 0x501A}, //1927 #CJK UNIFIED IDEOGRAPH
    {0xADCB, 0x5012}, //1928 #CJK UNIFIED IDEOGRAPH
    {0xADCC, 0x5011}, //1929 #CJK UNIFIED IDEOGRAPH
    {0xADCD, 0x4FFA}, //1930 #CJK UNIFIED IDEOGRAPH
    {0xADCE, 0x5000}, //1931 #CJK UNIFIED IDEOGRAPH
    {0xADCF, 0x5014}, //1932 #CJK UNIFIED IDEOGRAPH
    {0xADD0, 0x5028}, //1933 #CJK UNIFIED IDEOGRAPH
    {0xADD1, 0x4FF1}, //1934 #CJK UNIFIED IDEOGRAPH
    {0xADD2, 0x5021}, //1935 #CJK UNIFIED IDEOGRAPH
    {0xADD3, 0x500B}, //1936 #CJK UNIFIED IDEOGRAPH
    {0xADD4, 0x5019}, //1937 #CJK UNIFIED IDEOGRAPH
    {0xADD5, 0x5018}, //1938 #CJK UNIFIED IDEOGRAPH
    {0xADD6, 0x4FF3}, //1939 #CJK UNIFIED IDEOGRAPH
    {0xADD7, 0x4FEE}, //1940 #CJK UNIFIED IDEOGRAPH
    {0xADD8, 0x502D}, //1941 #CJK UNIFIED IDEOGRAPH
    {0xADD9, 0x502A}, //1942 #CJK UNIFIED IDEOGRAPH
    {0xADDA, 0x4FFE}, //1943 #CJK UNIFIED IDEOGRAPH
    {0xADDB, 0x502B}, //1944 #CJK UNIFIED IDEOGRAPH
    {0xADDC, 0x5009}, //1945 #CJK UNIFIED IDEOGRAPH
    {0xADDD, 0x517C}, //1946 #CJK UNIFIED IDEOGRAPH
    {0xADDE, 0x51A4}, //1947 #CJK UNIFIED IDEOGRAPH
    {0xADDF, 0x51A5}, //1948 #CJK UNIFIED IDEOGRAPH
    {0xADE0, 0x51A2}, //1949 #CJK UNIFIED IDEOGRAPH
    {0xADE1, 0x51CD}, //1950 #CJK UNIFIED IDEOGRAPH
    {0xADE2, 0x51CC}, //1951 #CJK UNIFIED IDEOGRAPH
    {0xADE3, 0x51C6}, //1952 #CJK UNIFIED IDEOGRAPH
    {0xADE4, 0x51CB}, //1953 #CJK UNIFIED IDEOGRAPH
    {0xADE5, 0x5256}, //1954 #CJK UNIFIED IDEOGRAPH
    {0xADE6, 0x525C}, //1955 #CJK UNIFIED IDEOGRAPH
    {0xADE7, 0x5254}, //1956 #CJK UNIFIED IDEOGRAPH
    {0xADE8, 0x525B}, //1957 #CJK UNIFIED IDEOGRAPH
    {0xADE9, 0x525D}, //1958 #CJK UNIFIED IDEOGRAPH
    {0xADEA, 0x532A}, //1959 #CJK UNIFIED IDEOGRAPH
    {0xADEB, 0x537F}, //1960 #CJK UNIFIED IDEOGRAPH
    {0xADEC, 0x539F}, //1961 #CJK UNIFIED IDEOGRAPH
    {0xADED, 0x539D}, //1962 #CJK UNIFIED IDEOGRAPH
    {0xADEE, 0x53DF}, //1963 #CJK UNIFIED IDEOGRAPH
    {0xADEF, 0x54E8}, //1964 #CJK UNIFIED IDEOGRAPH
    {0xADF0, 0x5510}, //1965 #CJK UNIFIED IDEOGRAPH
    {0xADF1, 0x5501}, //1966 #CJK UNIFIED IDEOGRAPH
    {0xADF2, 0x5537}, //1967 #CJK UNIFIED IDEOGRAPH
    {0xADF3, 0x54FC}, //1968 #CJK UNIFIED IDEOGRAPH
    {0xADF4, 0x54E5}, //1969 #CJK UNIFIED IDEOGRAPH
    {0xADF5, 0x54F2}, //1970 #CJK UNIFIED IDEOGRAPH
    {0xADF6, 0x5506}, //1971 #CJK UNIFIED IDEOGRAPH
    {0xADF7, 0x54FA}, //1972 #CJK UNIFIED IDEOGRAPH
    {0xADF8, 0x5514}, //1973 #CJK UNIFIED IDEOGRAPH
    {0xADF9, 0x54E9}, //1974 #CJK UNIFIED IDEOGRAPH
    {0xADFA, 0x54ED}, //1975 #CJK UNIFIED IDEOGRAPH
    {0xADFB, 0x54E1}, //1976 #CJK UNIFIED IDEOGRAPH
    {0xADFC, 0x5509}, //1977 #CJK UNIFIED IDEOGRAPH
    {0xADFD, 0x54EE}, //1978 #CJK UNIFIED IDEOGRAPH
    {0xADFE, 0x54EA}, //1979 #CJK UNIFIED IDEOGRAPH
    {0xAE40, 0x54E6}, //1980 #CJK UNIFIED IDEOGRAPH
    {0xAE41, 0x5527}, //1981 #CJK UNIFIED IDEOGRAPH
    {0xAE42, 0x5507}, //1982 #CJK UNIFIED IDEOGRAPH
    {0xAE43, 0x54FD}, //1983 #CJK UNIFIED IDEOGRAPH
    {0xAE44, 0x550F}, //1984 #CJK UNIFIED IDEOGRAPH
    {0xAE45, 0x5703}, //1985 #CJK UNIFIED IDEOGRAPH
    {0xAE46, 0x5704}, //1986 #CJK UNIFIED IDEOGRAPH
    {0xAE47, 0x57C2}, //1987 #CJK UNIFIED IDEOGRAPH
    {0xAE48, 0x57D4}, //1988 #CJK UNIFIED IDEOGRAPH
    {0xAE49, 0x57CB}, //1989 #CJK UNIFIED IDEOGRAPH
    {0xAE4A, 0x57C3}, //1990 #CJK UNIFIED IDEOGRAPH
    {0xAE4B, 0x5809}, //1991 #CJK UNIFIED IDEOGRAPH
    {0xAE4C, 0x590F}, //1992 #CJK UNIFIED IDEOGRAPH
    {0xAE4D, 0x5957}, //1993 #CJK UNIFIED IDEOGRAPH
    {0xAE4E, 0x5958}, //1994 #CJK UNIFIED IDEOGRAPH
    {0xAE4F, 0x595A}, //1995 #CJK UNIFIED IDEOGRAPH
    {0xAE50, 0x5A11}, //1996 #CJK UNIFIED IDEOGRAPH
    {0xAE51, 0x5A18}, //1997 #CJK UNIFIED IDEOGRAPH
    {0xAE52, 0x5A1C}, //1998 #CJK UNIFIED IDEOGRAPH
    {0xAE53, 0x5A1F}, //1999 #CJK UNIFIED IDEOGRAPH
    {0xAE54, 0x5A1B}, //2000 #CJK UNIFIED IDEOGRAPH
    {0xAE55, 0x5A13}, //2001 #CJK UNIFIED IDEOGRAPH
    {0xAE56, 0x59EC}, //2002 #CJK UNIFIED IDEOGRAPH
    {0xAE57, 0x5A20}, //2003 #CJK UNIFIED IDEOGRAPH
    {0xAE58, 0x5A23}, //2004 #CJK UNIFIED IDEOGRAPH
    {0xAE59, 0x5A29}, //2005 #CJK UNIFIED IDEOGRAPH
    {0xAE5A, 0x5A25}, //2006 #CJK UNIFIED IDEOGRAPH
    {0xAE5B, 0x5A0C}, //2007 #CJK UNIFIED IDEOGRAPH
    {0xAE5C, 0x5A09}, //2008 #CJK UNIFIED IDEOGRAPH
    {0xAE5D, 0x5B6B}, //2009 #CJK UNIFIED IDEOGRAPH
    {0xAE5E, 0x5C58}, //2010 #CJK UNIFIED IDEOGRAPH
    {0xAE5F, 0x5BB0}, //2011 #CJK UNIFIED IDEOGRAPH
    {0xAE60, 0x5BB3}, //2012 #CJK UNIFIED IDEOGRAPH
    {0xAE61, 0x5BB6}, //2013 #CJK UNIFIED IDEOGRAPH
    {0xAE62, 0x5BB4}, //2014 #CJK UNIFIED IDEOGRAPH
    {0xAE63, 0x5BAE}, //2015 #CJK UNIFIED IDEOGRAPH
    {0xAE64, 0x5BB5}, //2016 #CJK UNIFIED IDEOGRAPH
    {0xAE65, 0x5BB9}, //2017 #CJK UNIFIED IDEOGRAPH
    {0xAE66, 0x5BB8}, //2018 #CJK UNIFIED IDEOGRAPH
    {0xAE67, 0x5C04}, //2019 #CJK UNIFIED IDEOGRAPH
    {0xAE68, 0x5C51}, //2020 #CJK UNIFIED IDEOGRAPH
    {0xAE69, 0x5C55}, //2021 #CJK UNIFIED IDEOGRAPH
    {0xAE6A, 0x5C50}, //2022 #CJK UNIFIED IDEOGRAPH
    {0xAE6B, 0x5CED}, //2023 #CJK UNIFIED IDEOGRAPH
    {0xAE6C, 0x5CFD}, //2024 #CJK UNIFIED IDEOGRAPH
    {0xAE6D, 0x5CFB}, //2025 #CJK UNIFIED IDEOGRAPH
    {0xAE6E, 0x5CEA}, //2026 #CJK UNIFIED IDEOGRAPH
    {0xAE6F, 0x5CE8}, //2027 #CJK UNIFIED IDEOGRAPH
    {0xAE70, 0x5CF0}, //2028 #CJK UNIFIED IDEOGRAPH
    {0xAE71, 0x5CF6}, //2029 #CJK UNIFIED IDEOGRAPH
    {0xAE72, 0x5D01}, //2030 #CJK UNIFIED IDEOGRAPH
    {0xAE73, 0x5CF4}, //2031 #CJK UNIFIED IDEOGRAPH
    {0xAE74, 0x5DEE}, //2032 #CJK UNIFIED IDEOGRAPH
    {0xAE75, 0x5E2D}, //2033 #CJK UNIFIED IDEOGRAPH
    {0xAE76, 0x5E2B}, //2034 #CJK UNIFIED IDEOGRAPH
    {0xAE77, 0x5EAB}, //2035 #CJK UNIFIED IDEOGRAPH
    {0xAE78, 0x5EAD}, //2036 #CJK UNIFIED IDEOGRAPH
    {0xAE79, 0x5EA7}, //2037 #CJK UNIFIED IDEOGRAPH
    {0xAE7A, 0x5F31}, //2038 #CJK UNIFIED IDEOGRAPH
    {0xAE7B, 0x5F92}, //2039 #CJK UNIFIED IDEOGRAPH
    {0xAE7C, 0x5F91}, //2040 #CJK UNIFIED IDEOGRAPH
    {0xAE7D, 0x5F90}, //2041 #CJK UNIFIED IDEOGRAPH
    {0xAE7E, 0x6059}, //2042 #CJK UNIFIED IDEOGRAPH
    {0xAEA1, 0x6063}, //2043 #CJK UNIFIED IDEOGRAPH
    {0xAEA2, 0x6065}, //2044 #CJK UNIFIED IDEOGRAPH
    {0xAEA3, 0x6050}, //2045 #CJK UNIFIED IDEOGRAPH
    {0xAEA4, 0x6055}, //2046 #CJK UNIFIED IDEOGRAPH
    {0xAEA5, 0x606D}, //2047 #CJK UNIFIED IDEOGRAPH
    {0xAEA6, 0x6069}, //2048 #CJK UNIFIED IDEOGRAPH
    {0xAEA7, 0x606F}, //2049 #CJK UNIFIED IDEOGRAPH
    {0xAEA8, 0x6084}, //2050 #CJK UNIFIED IDEOGRAPH
    {0xAEA9, 0x609F}, //2051 #CJK UNIFIED IDEOGRAPH
    {0xAEAA, 0x609A}, //2052 #CJK UNIFIED IDEOGRAPH
    {0xAEAB, 0x608D}, //2053 #CJK UNIFIED IDEOGRAPH
    {0xAEAC, 0x6094}, //2054 #CJK UNIFIED IDEOGRAPH
    {0xAEAD, 0x608C}, //2055 #CJK UNIFIED IDEOGRAPH
    {0xAEAE, 0x6085}, //2056 #CJK UNIFIED IDEOGRAPH
    {0xAEAF, 0x6096}, //2057 #CJK UNIFIED IDEOGRAPH
    {0xAEB0, 0x6247}, //2058 #CJK UNIFIED IDEOGRAPH
    {0xAEB1, 0x62F3}, //2059 #CJK UNIFIED IDEOGRAPH
    {0xAEB2, 0x6308}, //2060 #CJK UNIFIED IDEOGRAPH
    {0xAEB3, 0x62FF}, //2061 #CJK UNIFIED IDEOGRAPH
    {0xAEB4, 0x634E}, //2062 #CJK UNIFIED IDEOGRAPH
    {0xAEB5, 0x633E}, //2063 #CJK UNIFIED IDEOGRAPH
    {0xAEB6, 0x632F}, //2064 #CJK UNIFIED IDEOGRAPH
    {0xAEB7, 0x6355}, //2065 #CJK UNIFIED IDEOGRAPH
    {0xAEB8, 0x6342}, //2066 #CJK UNIFIED IDEOGRAPH
    {0xAEB9, 0x6346}, //2067 #CJK UNIFIED IDEOGRAPH
    {0xAEBA, 0x634F}, //2068 #CJK UNIFIED IDEOGRAPH
    {0xAEBB, 0x6349}, //2069 #CJK UNIFIED IDEOGRAPH
    {0xAEBC, 0x633A}, //2070 #CJK UNIFIED IDEOGRAPH
    {0xAEBD, 0x6350}, //2071 #CJK UNIFIED IDEOGRAPH
    {0xAEBE, 0x633D}, //2072 #CJK UNIFIED IDEOGRAPH
    {0xAEBF, 0x632A}, //2073 #CJK UNIFIED IDEOGRAPH
    {0xAEC0, 0x632B}, //2074 #CJK UNIFIED IDEOGRAPH
    {0xAEC1, 0x6328}, //2075 #CJK UNIFIED IDEOGRAPH
    {0xAEC2, 0x634D}, //2076 #CJK UNIFIED IDEOGRAPH
    {0xAEC3, 0x634C}, //2077 #CJK UNIFIED IDEOGRAPH
    {0xAEC4, 0x6548}, //2078 #CJK UNIFIED IDEOGRAPH
    {0xAEC5, 0x6549}, //2079 #CJK UNIFIED IDEOGRAPH
    {0xAEC6, 0x6599}, //2080 #CJK UNIFIED IDEOGRAPH
    {0xAEC7, 0x65C1}, //2081 #CJK UNIFIED IDEOGRAPH
    {0xAEC8, 0x65C5}, //2082 #CJK UNIFIED IDEOGRAPH
    {0xAEC9, 0x6642}, //2083 #CJK UNIFIED IDEOGRAPH
    {0xAECA, 0x6649}, //2084 #CJK UNIFIED IDEOGRAPH
    {0xAECB, 0x664F}, //2085 #CJK UNIFIED IDEOGRAPH
    {0xAECC, 0x6643}, //2086 #CJK UNIFIED IDEOGRAPH
    {0xAECD, 0x6652}, //2087 #CJK UNIFIED IDEOGRAPH
    {0xAECE, 0x664C}, //2088 #CJK UNIFIED IDEOGRAPH
    {0xAECF, 0x6645}, //2089 #CJK UNIFIED IDEOGRAPH
    {0xAED0, 0x6641}, //2090 #CJK UNIFIED IDEOGRAPH
    {0xAED1, 0x66F8}, //2091 #CJK UNIFIED IDEOGRAPH
    {0xAED2, 0x6714}, //2092 #CJK UNIFIED IDEOGRAPH
    {0xAED3, 0x6715}, //2093 #CJK UNIFIED IDEOGRAPH
    {0xAED4, 0x6717}, //2094 #CJK UNIFIED IDEOGRAPH
    {0xAED5, 0x6821}, //2095 #CJK UNIFIED IDEOGRAPH
    {0xAED6, 0x6838}, //2096 #CJK UNIFIED IDEOGRAPH
    {0xAED7, 0x6848}, //2097 #CJK UNIFIED IDEOGRAPH
    {0xAED8, 0x6846}, //2098 #CJK UNIFIED IDEOGRAPH
    {0xAED9, 0x6853}, //2099 #CJK UNIFIED IDEOGRAPH
    {0xAEDA, 0x6839}, //2100 #CJK UNIFIED IDEOGRAPH
    {0xAEDB, 0x6842}, //2101 #CJK UNIFIED IDEOGRAPH
    {0xAEDC, 0x6854}, //2102 #CJK UNIFIED IDEOGRAPH
    {0xAEDD, 0x6829}, //2103 #CJK UNIFIED IDEOGRAPH
    {0xAEDE, 0x68B3}, //2104 #CJK UNIFIED IDEOGRAPH
    {0xAEDF, 0x6817}, //2105 #CJK UNIFIED IDEOGRAPH
    {0xAEE0, 0x684C}, //2106 #CJK UNIFIED IDEOGRAPH
    {0xAEE1, 0x6851}, //2107 #CJK UNIFIED IDEOGRAPH
    {0xAEE2, 0x683D}, //2108 #CJK UNIFIED IDEOGRAPH
    {0xAEE3, 0x67F4}, //2109 #CJK UNIFIED IDEOGRAPH
    {0xAEE4, 0x6850}, //2110 #CJK UNIFIED IDEOGRAPH
    {0xAEE5, 0x6840}, //2111 #CJK UNIFIED IDEOGRAPH
    {0xAEE6, 0x683C}, //2112 #CJK UNIFIED IDEOGRAPH
    {0xAEE7, 0x6843}, //2113 #CJK UNIFIED IDEOGRAPH
    {0xAEE8, 0x682A}, //2114 #CJK UNIFIED IDEOGRAPH
    {0xAEE9, 0x6845}, //2115 #CJK UNIFIED IDEOGRAPH
    {0xAEEA, 0x6813}, //2116 #CJK UNIFIED IDEOGRAPH
    {0xAEEB, 0x6818}, //2117 #CJK UNIFIED IDEOGRAPH
    {0xAEEC, 0x6841}, //2118 #CJK UNIFIED IDEOGRAPH
    {0xAEED, 0x6B8A}, //2119 #CJK UNIFIED IDEOGRAPH
    {0xAEEE, 0x6B89}, //2120 #CJK UNIFIED IDEOGRAPH
    {0xAEEF, 0x6BB7}, //2121 #CJK UNIFIED IDEOGRAPH
    {0xAEF0, 0x6C23}, //2122 #CJK UNIFIED IDEOGRAPH
    {0xAEF1, 0x6C27}, //2123 #CJK UNIFIED IDEOGRAPH
    {0xAEF2, 0x6C28}, //2124 #CJK UNIFIED IDEOGRAPH
    {0xAEF3, 0x6C26}, //2125 #CJK UNIFIED IDEOGRAPH
    {0xAEF4, 0x6C24}, //2126 #CJK UNIFIED IDEOGRAPH
    {0xAEF5, 0x6CF0}, //2127 #CJK UNIFIED IDEOGRAPH
    {0xAEF6, 0x6D6A}, //2128 #CJK UNIFIED IDEOGRAPH
    {0xAEF7, 0x6D95}, //2129 #CJK UNIFIED IDEOGRAPH
    {0xAEF8, 0x6D88}, //2130 #CJK UNIFIED IDEOGRAPH
    {0xAEF9, 0x6D87}, //2131 #CJK UNIFIED IDEOGRAPH
    {0xAEFA, 0x6D66}, //2132 #CJK UNIFIED IDEOGRAPH
    {0xAEFB, 0x6D78}, //2133 #CJK UNIFIED IDEOGRAPH
    {0xAEFC, 0x6D77}, //2134 #CJK UNIFIED IDEOGRAPH
    {0xAEFD, 0x6D59}, //2135 #CJK UNIFIED IDEOGRAPH
    {0xAEFE, 0x6D93}, //2136 #CJK UNIFIED IDEOGRAPH
    {0xAF40, 0x6D6C}, //2137 #CJK UNIFIED IDEOGRAPH
    {0xAF41, 0x6D89}, //2138 #CJK UNIFIED IDEOGRAPH
    {0xAF42, 0x6D6E}, //2139 #CJK UNIFIED IDEOGRAPH
    {0xAF43, 0x6D5A}, //2140 #CJK UNIFIED IDEOGRAPH
    {0xAF44, 0x6D74}, //2141 #CJK UNIFIED IDEOGRAPH
    {0xAF45, 0x6D69}, //2142 #CJK UNIFIED IDEOGRAPH
    {0xAF46, 0x6D8C}, //2143 #CJK UNIFIED IDEOGRAPH
    {0xAF47, 0x6D8A}, //2144 #CJK UNIFIED IDEOGRAPH
    {0xAF48, 0x6D79}, //2145 #CJK UNIFIED IDEOGRAPH
    {0xAF49, 0x6D85}, //2146 #CJK UNIFIED IDEOGRAPH
    {0xAF4A, 0x6D65}, //2147 #CJK UNIFIED IDEOGRAPH
    {0xAF4B, 0x6D94}, //2148 #CJK UNIFIED IDEOGRAPH
    {0xAF4C, 0x70CA}, //2149 #CJK UNIFIED IDEOGRAPH
    {0xAF4D, 0x70D8}, //2150 #CJK UNIFIED IDEOGRAPH
    {0xAF4E, 0x70E4}, //2151 #CJK UNIFIED IDEOGRAPH
    {0xAF4F, 0x70D9}, //2152 #CJK UNIFIED IDEOGRAPH
    {0xAF50, 0x70C8}, //2153 #CJK UNIFIED IDEOGRAPH
    {0xAF51, 0x70CF}, //2154 #CJK UNIFIED IDEOGRAPH
    {0xAF52, 0x7239}, //2155 #CJK UNIFIED IDEOGRAPH
    {0xAF53, 0x7279}, //2156 #CJK UNIFIED IDEOGRAPH
    {0xAF54, 0x72FC}, //2157 #CJK UNIFIED IDEOGRAPH
    {0xAF55, 0x72F9}, //2158 #CJK UNIFIED IDEOGRAPH
    {0xAF56, 0x72FD}, //2159 #CJK UNIFIED IDEOGRAPH
    {0xAF57, 0x72F8}, //2160 #CJK UNIFIED IDEOGRAPH
    {0xAF58, 0x72F7}, //2161 #CJK UNIFIED IDEOGRAPH
    {0xAF59, 0x7386}, //2162 #CJK UNIFIED IDEOGRAPH
    {0xAF5A, 0x73ED}, //2163 #CJK UNIFIED IDEOGRAPH
    {0xAF5B, 0x7409}, //2164 #CJK UNIFIED IDEOGRAPH
    {0xAF5C, 0x73EE}, //2165 #CJK UNIFIED IDEOGRAPH
    {0xAF5D, 0x73E0}, //2166 #CJK UNIFIED IDEOGRAPH
    {0xAF5E, 0x73EA}, //2167 #CJK UNIFIED IDEOGRAPH
    {0xAF5F, 0x73DE}, //2168 #CJK UNIFIED IDEOGRAPH
    {0xAF60, 0x7554}, //2169 #CJK UNIFIED IDEOGRAPH
    {0xAF61, 0x755D}, //2170 #CJK UNIFIED IDEOGRAPH
    {0xAF62, 0x755C}, //2171 #CJK UNIFIED IDEOGRAPH
    {0xAF63, 0x755A}, //2172 #CJK UNIFIED IDEOGRAPH
    {0xAF64, 0x7559}, //2173 #CJK UNIFIED IDEOGRAPH
    {0xAF65, 0x75BE}, //2174 #CJK UNIFIED IDEOGRAPH
    {0xAF66, 0x75C5}, //2175 #CJK UNIFIED IDEOGRAPH
    {0xAF67, 0x75C7}, //2176 #CJK UNIFIED IDEOGRAPH
    {0xAF68, 0x75B2}, //2177 #CJK UNIFIED IDEOGRAPH
    {0xAF69, 0x75B3}, //2178 #CJK UNIFIED IDEOGRAPH
    {0xAF6A, 0x75BD}, //2179 #CJK UNIFIED IDEOGRAPH
    {0xAF6B, 0x75BC}, //2180 #CJK UNIFIED IDEOGRAPH
    {0xAF6C, 0x75B9}, //2181 #CJK UNIFIED IDEOGRAPH
    {0xAF6D, 0x75C2}, //2182 #CJK UNIFIED IDEOGRAPH
    {0xAF6E, 0x75B8}, //2183 #CJK UNIFIED IDEOGRAPH
    {0xAF6F, 0x768B}, //2184 #CJK UNIFIED IDEOGRAPH
    {0xAF70, 0x76B0}, //2185 #CJK UNIFIED IDEOGRAPH
    {0xAF71, 0x76CA}, //2186 #CJK UNIFIED IDEOGRAPH
    {0xAF72, 0x76CD}, //2187 #CJK UNIFIED IDEOGRAPH
    {0xAF73, 0x76CE}, //2188 #CJK UNIFIED IDEOGRAPH
    {0xAF74, 0x7729}, //2189 #CJK UNIFIED IDEOGRAPH
    {0xAF75, 0x771F}, //2190 #CJK UNIFIED IDEOGRAPH
    {0xAF76, 0x7720}, //2191 #CJK UNIFIED IDEOGRAPH
    {0xAF77, 0x7728}, //2192 #CJK UNIFIED IDEOGRAPH
    {0xAF78, 0x77E9}, //2193 #CJK UNIFIED IDEOGRAPH
    {0xAF79, 0x7830}, //2194 #CJK UNIFIED IDEOGRAPH
    {0xAF7A, 0x7827}, //2195 #CJK UNIFIED IDEOGRAPH
    {0xAF7B, 0x7838}, //2196 #CJK UNIFIED IDEOGRAPH
    {0xAF7C, 0x781D}, //2197 #CJK UNIFIED IDEOGRAPH
    {0xAF7D, 0x7834}, //2198 #CJK UNIFIED IDEOGRAPH
    {0xAF7E, 0x7837}, //2199 #CJK UNIFIED IDEOGRAPH
    {0xAFA1, 0x7825}, //2200 #CJK UNIFIED IDEOGRAPH
    {0xAFA2, 0x782D}, //2201 #CJK UNIFIED IDEOGRAPH
    {0xAFA3, 0x7820}, //2202 #CJK UNIFIED IDEOGRAPH
    {0xAFA4, 0x781F}, //2203 #CJK UNIFIED IDEOGRAPH
    {0xAFA5, 0x7832}, //2204 #CJK UNIFIED IDEOGRAPH
    {0xAFA6, 0x7955}, //2205 #CJK UNIFIED IDEOGRAPH
    {0xAFA7, 0x7950}, //2206 #CJK UNIFIED IDEOGRAPH
    {0xAFA8, 0x7960}, //2207 #CJK UNIFIED IDEOGRAPH
    {0xAFA9, 0x795F}, //2208 #CJK UNIFIED IDEOGRAPH
    {0xAFAA, 0x7956}, //2209 #CJK UNIFIED IDEOGRAPH
    {0xAFAB, 0x795E}, //2210 #CJK UNIFIED IDEOGRAPH
    {0xAFAC, 0x795D}, //2211 #CJK UNIFIED IDEOGRAPH
    {0xAFAD, 0x7957}, //2212 #CJK UNIFIED IDEOGRAPH
    {0xAFAE, 0x795A}, //2213 #CJK UNIFIED IDEOGRAPH
    {0xAFAF, 0x79E4}, //2214 #CJK UNIFIED IDEOGRAPH
    {0xAFB0, 0x79E3}, //2215 #CJK UNIFIED IDEOGRAPH
    {0xAFB1, 0x79E7}, //2216 #CJK UNIFIED IDEOGRAPH
    {0xAFB2, 0x79DF}, //2217 #CJK UNIFIED IDEOGRAPH
    {0xAFB3, 0x79E6}, //2218 #CJK UNIFIED IDEOGRAPH
    {0xAFB4, 0x79E9}, //2219 #CJK UNIFIED IDEOGRAPH
    {0xAFB5, 0x79D8}, //2220 #CJK UNIFIED IDEOGRAPH
    {0xAFB6, 0x7A84}, //2221 #CJK UNIFIED IDEOGRAPH
    {0xAFB7, 0x7A88}, //2222 #CJK UNIFIED IDEOGRAPH
    {0xAFB8, 0x7AD9}, //2223 #CJK UNIFIED IDEOGRAPH
    {0xAFB9, 0x7B06}, //2224 #CJK UNIFIED IDEOGRAPH
    {0xAFBA, 0x7B11}, //2225 #CJK UNIFIED IDEOGRAPH
    {0xAFBB, 0x7C89}, //2226 #CJK UNIFIED IDEOGRAPH
    {0xAFBC, 0x7D21}, //2227 #CJK UNIFIED IDEOGRAPH
    {0xAFBD, 0x7D17}, //2228 #CJK UNIFIED IDEOGRAPH
    {0xAFBE, 0x7D0B}, //2229 #CJK UNIFIED IDEOGRAPH
    {0xAFBF, 0x7D0A}, //2230 #CJK UNIFIED IDEOGRAPH
    {0xAFC0, 0x7D20}, //2231 #CJK UNIFIED IDEOGRAPH
    {0xAFC1, 0x7D22}, //2232 #CJK UNIFIED IDEOGRAPH
    {0xAFC2, 0x7D14}, //2233 #CJK UNIFIED IDEOGRAPH
    {0xAFC3, 0x7D10}, //2234 #CJK UNIFIED IDEOGRAPH
    {0xAFC4, 0x7D15}, //2235 #CJK UNIFIED IDEOGRAPH
    {0xAFC5, 0x7D1A}, //2236 #CJK UNIFIED IDEOGRAPH
    {0xAFC6, 0x7D1C}, //2237 #CJK UNIFIED IDEOGRAPH
    {0xAFC7, 0x7D0D}, //2238 #CJK UNIFIED IDEOGRAPH
    {0xAFC8, 0x7D19}, //2239 #CJK UNIFIED IDEOGRAPH
    {0xAFC9, 0x7D1B}, //2240 #CJK UNIFIED IDEOGRAPH
    {0xAFCA, 0x7F3A}, //2241 #CJK UNIFIED IDEOGRAPH
    {0xAFCB, 0x7F5F}, //2242 #CJK UNIFIED IDEOGRAPH
    {0xAFCC, 0x7F94}, //2243 #CJK UNIFIED IDEOGRAPH
    {0xAFCD, 0x7FC5}, //2244 #CJK UNIFIED IDEOGRAPH
    {0xAFCE, 0x7FC1}, //2245 #CJK UNIFIED IDEOGRAPH
    {0xAFCF, 0x8006}, //2246 #CJK UNIFIED IDEOGRAPH
    {0xAFD0, 0x8018}, //2247 #CJK UNIFIED IDEOGRAPH
    {0xAFD1, 0x8015}, //2248 #CJK UNIFIED IDEOGRAPH
    {0xAFD2, 0x8019}, //2249 #CJK UNIFIED IDEOGRAPH
    {0xAFD3, 0x8017}, //2250 #CJK UNIFIED IDEOGRAPH
    {0xAFD4, 0x803D}, //2251 #CJK UNIFIED IDEOGRAPH
    {0xAFD5, 0x803F}, //2252 #CJK UNIFIED IDEOGRAPH
    {0xAFD6, 0x80F1}, //2253 #CJK UNIFIED IDEOGRAPH
    {0xAFD7, 0x8102}, //2254 #CJK UNIFIED IDEOGRAPH
    {0xAFD8, 0x80F0}, //2255 #CJK UNIFIED IDEOGRAPH
    {0xAFD9, 0x8105}, //2256 #CJK UNIFIED IDEOGRAPH
    {0xAFDA, 0x80ED}, //2257 #CJK UNIFIED IDEOGRAPH
    {0xAFDB, 0x80F4}, //2258 #CJK UNIFIED IDEOGRAPH
    {0xAFDC, 0x8106}, //2259 #CJK UNIFIED IDEOGRAPH
    {0xAFDD, 0x80F8}, //2260 #CJK UNIFIED IDEOGRAPH
    {0xAFDE, 0x80F3}, //2261 #CJK UNIFIED IDEOGRAPH
    {0xAFDF, 0x8108}, //2262 #CJK UNIFIED IDEOGRAPH
    {0xAFE0, 0x80FD}, //2263 #CJK UNIFIED IDEOGRAPH
    {0xAFE1, 0x810A}, //2264 #CJK UNIFIED IDEOGRAPH
    {0xAFE2, 0x80FC}, //2265 #CJK UNIFIED IDEOGRAPH
    {0xAFE3, 0x80EF}, //2266 #CJK UNIFIED IDEOGRAPH
    {0xAFE4, 0x81ED}, //2267 #CJK UNIFIED IDEOGRAPH
    {0xAFE5, 0x81EC}, //2268 #CJK UNIFIED IDEOGRAPH
    {0xAFE6, 0x8200}, //2269 #CJK UNIFIED IDEOGRAPH
    {0xAFE7, 0x8210}, //2270 #CJK UNIFIED IDEOGRAPH
    {0xAFE8, 0x822A}, //2271 #CJK UNIFIED IDEOGRAPH
    {0xAFE9, 0x822B}, //2272 #CJK UNIFIED IDEOGRAPH
    {0xAFEA, 0x8228}, //2273 #CJK UNIFIED IDEOGRAPH
    {0xAFEB, 0x822C}, //2274 #CJK UNIFIED IDEOGRAPH
    {0xAFEC, 0x82BB}, //2275 #CJK UNIFIED IDEOGRAPH
    {0xAFED, 0x832B}, //2276 #CJK UNIFIED IDEOGRAPH
    {0xAFEE, 0x8352}, //2277 #CJK UNIFIED IDEOGRAPH
    {0xAFEF, 0x8354}, //2278 #CJK UNIFIED IDEOGRAPH
    {0xAFF0, 0x834A}, //2279 #CJK UNIFIED IDEOGRAPH
    {0xAFF1, 0x8338}, //2280 #CJK UNIFIED IDEOGRAPH
    {0xAFF2, 0x8350}, //2281 #CJK UNIFIED IDEOGRAPH
    {0xAFF3, 0x8349}, //2282 #CJK UNIFIED IDEOGRAPH
    {0xAFF4, 0x8335}, //2283 #CJK UNIFIED IDEOGRAPH
    {0xAFF5, 0x8334}, //2284 #CJK UNIFIED IDEOGRAPH
    {0xAFF6, 0x834F}, //2285 #CJK UNIFIED IDEOGRAPH
    {0xAFF7, 0x8332}, //2286 #CJK UNIFIED IDEOGRAPH
    {0xAFF8, 0x8339}, //2287 #CJK UNIFIED IDEOGRAPH
    {0xAFF9, 0x8336}, //2288 #CJK UNIFIED IDEOGRAPH
    {0xAFFA, 0x8317}, //2289 #CJK UNIFIED IDEOGRAPH
    {0xAFFB, 0x8340}, //2290 #CJK UNIFIED IDEOGRAPH
    {0xAFFC, 0x8331}, //2291 #CJK UNIFIED IDEOGRAPH
    {0xAFFD, 0x8328}, //2292 #CJK UNIFIED IDEOGRAPH
    {0xAFFE, 0x8343}, //2293 #CJK UNIFIED IDEOGRAPH
    {0xB040, 0x8654}, //2294 #CJK UNIFIED IDEOGRAPH
    {0xB041, 0x868A}, //2295 #CJK UNIFIED IDEOGRAPH
    {0xB042, 0x86AA}, //2296 #CJK UNIFIED IDEOGRAPH
    {0xB043, 0x8693}, //2297 #CJK UNIFIED IDEOGRAPH
    {0xB044, 0x86A4}, //2298 #CJK UNIFIED IDEOGRAPH
    {0xB045, 0x86A9}, //2299 #CJK UNIFIED IDEOGRAPH
    {0xB046, 0x868C}, //2300 #CJK UNIFIED IDEOGRAPH
    {0xB047, 0x86A3}, //2301 #CJK UNIFIED IDEOGRAPH
    {0xB048, 0x869C}, //2302 #CJK UNIFIED IDEOGRAPH
    {0xB049, 0x8870}, //2303 #CJK UNIFIED IDEOGRAPH
    {0xB04A, 0x8877}, //2304 #CJK UNIFIED IDEOGRAPH
    {0xB04B, 0x8881}, //2305 #CJK UNIFIED IDEOGRAPH
    {0xB04C, 0x8882}, //2306 #CJK UNIFIED IDEOGRAPH
    {0xB04D, 0x887D}, //2307 #CJK UNIFIED IDEOGRAPH
    {0xB04E, 0x8879}, //2308 #CJK UNIFIED IDEOGRAPH
    {0xB04F, 0x8A18}, //2309 #CJK UNIFIED IDEOGRAPH
    {0xB050, 0x8A10}, //2310 #CJK UNIFIED IDEOGRAPH
    {0xB051, 0x8A0E}, //2311 #CJK UNIFIED IDEOGRAPH
    {0xB052, 0x8A0C}, //2312 #CJK UNIFIED IDEOGRAPH
    {0xB053, 0x8A15}, //2313 #CJK UNIFIED IDEOGRAPH
    {0xB054, 0x8A0A}, //2314 #CJK UNIFIED IDEOGRAPH
    {0xB055, 0x8A17}, //2315 #CJK UNIFIED IDEOGRAPH
    {0xB056, 0x8A13}, //2316 #CJK UNIFIED IDEOGRAPH
    {0xB057, 0x8A16}, //2317 #CJK UNIFIED IDEOGRAPH
    {0xB058, 0x8A0F}, //2318 #CJK UNIFIED IDEOGRAPH
    {0xB059, 0x8A11}, //2319 #CJK UNIFIED IDEOGRAPH
    {0xB05A, 0x8C48}, //2320 #CJK UNIFIED IDEOGRAPH
    {0xB05B, 0x8C7A}, //2321 #CJK UNIFIED IDEOGRAPH
    {0xB05C, 0x8C79}, //2322 #CJK UNIFIED IDEOGRAPH
    {0xB05D, 0x8CA1}, //2323 #CJK UNIFIED IDEOGRAPH
    {0xB05E, 0x8CA2}, //2324 #CJK UNIFIED IDEOGRAPH
    {0xB05F, 0x8D77}, //2325 #CJK UNIFIED IDEOGRAPH
    {0xB060, 0x8EAC}, //2326 #CJK UNIFIED IDEOGRAPH
    {0xB061, 0x8ED2}, //2327 #CJK UNIFIED IDEOGRAPH
    {0xB062, 0x8ED4}, //2328 #CJK UNIFIED IDEOGRAPH
    {0xB063, 0x8ECF}, //2329 #CJK UNIFIED IDEOGRAPH
    {0xB064, 0x8FB1}, //2330 #CJK UNIFIED IDEOGRAPH
    {0xB065, 0x9001}, //2331 #CJK UNIFIED IDEOGRAPH
    {0xB066, 0x9006}, //2332 #CJK UNIFIED IDEOGRAPH
    {0xB067, 0x8FF7}, //2333 #CJK UNIFIED IDEOGRAPH
    {0xB068, 0x9000}, //2334 #CJK UNIFIED IDEOGRAPH
    {0xB069, 0x8FFA}, //2335 #CJK UNIFIED IDEOGRAPH
    {0xB06A, 0x8FF4}, //2336 #CJK UNIFIED IDEOGRAPH
    {0xB06B, 0x9003}, //2337 #CJK UNIFIED IDEOGRAPH
    {0xB06C, 0x8FFD}, //2338 #CJK UNIFIED IDEOGRAPH
    {0xB06D, 0x9005}, //2339 #CJK UNIFIED IDEOGRAPH
    {0xB06E, 0x8FF8}, //2340 #CJK UNIFIED IDEOGRAPH
    {0xB06F, 0x9095}, //2341 #CJK UNIFIED IDEOGRAPH
    {0xB070, 0x90E1}, //2342 #CJK UNIFIED IDEOGRAPH
    {0xB071, 0x90DD}, //2343 #CJK UNIFIED IDEOGRAPH
    {0xB072, 0x90E2}, //2344 #CJK UNIFIED IDEOGRAPH
    {0xB073, 0x9152}, //2345 #CJK UNIFIED IDEOGRAPH
    {0xB074, 0x914D}, //2346 #CJK UNIFIED IDEOGRAPH
    {0xB075, 0x914C}, //2347 #CJK UNIFIED IDEOGRAPH
    {0xB076, 0x91D8}, //2348 #CJK UNIFIED IDEOGRAPH
    {0xB077, 0x91DD}, //2349 #CJK UNIFIED IDEOGRAPH
    {0xB078, 0x91D7}, //2350 #CJK UNIFIED IDEOGRAPH
    {0xB079, 0x91DC}, //2351 #CJK UNIFIED IDEOGRAPH
    {0xB07A, 0x91D9}, //2352 #CJK UNIFIED IDEOGRAPH
    {0xB07B, 0x9583}, //2353 #CJK UNIFIED IDEOGRAPH
    {0xB07C, 0x9662}, //2354 #CJK UNIFIED IDEOGRAPH
    {0xB07D, 0x9663}, //2355 #CJK UNIFIED IDEOGRAPH
    {0xB07E, 0x9661}, //2356 #CJK UNIFIED IDEOGRAPH
    {0xB0A1, 0x965B}, //2357 #CJK UNIFIED IDEOGRAPH
    {0xB0A2, 0x965D}, //2358 #CJK UNIFIED IDEOGRAPH
    {0xB0A3, 0x9664}, //2359 #CJK UNIFIED IDEOGRAPH
    {0xB0A4, 0x9658}, //2360 #CJK UNIFIED IDEOGRAPH
    {0xB0A5, 0x965E}, //2361 #CJK UNIFIED IDEOGRAPH
    {0xB0A6, 0x96BB}, //2362 #CJK UNIFIED IDEOGRAPH
    {0xB0A7, 0x98E2}, //2363 #CJK UNIFIED IDEOGRAPH
    {0xB0A8, 0x99AC}, //2364 #CJK UNIFIED IDEOGRAPH
    {0xB0A9, 0x9AA8}, //2365 #CJK UNIFIED IDEOGRAPH
    {0xB0AA, 0x9AD8}, //2366 #CJK UNIFIED IDEOGRAPH
    {0xB0AB, 0x9B25}, //2367 #CJK UNIFIED IDEOGRAPH
    {0xB0AC, 0x9B32}, //2368 #CJK UNIFIED IDEOGRAPH
    {0xB0AD, 0x9B3C}, //2369 #CJK UNIFIED IDEOGRAPH
    {0xB0AE, 0x4E7E}, //2370 #CJK UNIFIED IDEOGRAPH
    {0xB0AF, 0x507A}, //2371 #CJK UNIFIED IDEOGRAPH
    {0xB0B0, 0x507D}, //2372 #CJK UNIFIED IDEOGRAPH
    {0xB0B1, 0x505C}, //2373 #CJK UNIFIED IDEOGRAPH
    {0xB0B2, 0x5047}, //2374 #CJK UNIFIED IDEOGRAPH
    {0xB0B3, 0x5043}, //2375 #CJK UNIFIED IDEOGRAPH
    {0xB0B4, 0x504C}, //2376 #CJK UNIFIED IDEOGRAPH
    {0xB0B5, 0x505A}, //2377 #CJK UNIFIED IDEOGRAPH
    {0xB0B6, 0x5049}, //2378 #CJK UNIFIED IDEOGRAPH
    {0xB0B7, 0x5065}, //2379 #CJK UNIFIED IDEOGRAPH
    {0xB0B8, 0x5076}, //2380 #CJK UNIFIED IDEOGRAPH
    {0xB0B9, 0x504E}, //2381 #CJK UNIFIED IDEOGRAPH
    {0xB0BA, 0x5055}, //2382 #CJK UNIFIED IDEOGRAPH
    {0xB0BB, 0x5075}, //2383 #CJK UNIFIED IDEOGRAPH
    {0xB0BC, 0x5074}, //2384 #CJK UNIFIED IDEOGRAPH
    {0xB0BD, 0x5077}, //2385 #CJK UNIFIED IDEOGRAPH
    {0xB0BE, 0x504F}, //2386 #CJK UNIFIED IDEOGRAPH
    {0xB0BF, 0x500F}, //2387 #CJK UNIFIED IDEOGRAPH
    {0xB0C0, 0x506F}, //2388 #CJK UNIFIED IDEOGRAPH
    {0xB0C1, 0x506D}, //2389 #CJK UNIFIED IDEOGRAPH
    {0xB0C2, 0x515C}, //2390 #CJK UNIFIED IDEOGRAPH
    {0xB0C3, 0x5195}, //2391 #CJK UNIFIED IDEOGRAPH
    {0xB0C4, 0x51F0}, //2392 #CJK UNIFIED IDEOGRAPH
    {0xB0C5, 0x526A}, //2393 #CJK UNIFIED IDEOGRAPH
    {0xB0C6, 0x526F}, //2394 #CJK UNIFIED IDEOGRAPH
    {0xB0C7, 0x52D2}, //2395 #CJK UNIFIED IDEOGRAPH
    {0xB0C8, 0x52D9}, //2396 #CJK UNIFIED IDEOGRAPH
    {0xB0C9, 0x52D8}, //2397 #CJK UNIFIED IDEOGRAPH
    {0xB0CA, 0x52D5}, //2398 #CJK UNIFIED IDEOGRAPH
    {0xB0CB, 0x5310}, //2399 #CJK UNIFIED IDEOGRAPH
    {0xB0CC, 0x530F}, //2400 #CJK UNIFIED IDEOGRAPH
    {0xB0CD, 0x5319}, //2401 #CJK UNIFIED IDEOGRAPH
    {0xB0CE, 0x533F}, //2402 #CJK UNIFIED IDEOGRAPH
    {0xB0CF, 0x5340}, //2403 #CJK UNIFIED IDEOGRAPH
    {0xB0D0, 0x533E}, //2404 #CJK UNIFIED IDEOGRAPH
    {0xB0D1, 0x53C3}, //2405 #CJK UNIFIED IDEOGRAPH
    {0xB0D2, 0x66FC}, //2406 #CJK UNIFIED IDEOGRAPH
    {0xB0D3, 0x5546}, //2407 #CJK UNIFIED IDEOGRAPH
    {0xB0D4, 0x556A}, //2408 #CJK UNIFIED IDEOGRAPH
    {0xB0D5, 0x5566}, //2409 #CJK UNIFIED IDEOGRAPH
    {0xB0D6, 0x5544}, //2410 #CJK UNIFIED IDEOGRAPH
    {0xB0D7, 0x555E}, //2411 #CJK UNIFIED IDEOGRAPH
    {0xB0D8, 0x5561}, //2412 #CJK UNIFIED IDEOGRAPH
    {0xB0D9, 0x5543}, //2413 #CJK UNIFIED IDEOGRAPH
    {0xB0DA, 0x554A}, //2414 #CJK UNIFIED IDEOGRAPH
    {0xB0DB, 0x5531}, //2415 #CJK UNIFIED IDEOGRAPH
    {0xB0DC, 0x5556}, //2416 #CJK UNIFIED IDEOGRAPH
    {0xB0DD, 0x554F}, //2417 #CJK UNIFIED IDEOGRAPH
    {0xB0DE, 0x5555}, //2418 #CJK UNIFIED IDEOGRAPH
    {0xB0DF, 0x552F}, //2419 #CJK UNIFIED IDEOGRAPH
    {0xB0E0, 0x5564}, //2420 #CJK UNIFIED IDEOGRAPH
    {0xB0E1, 0x5538}, //2421 #CJK UNIFIED IDEOGRAPH
    {0xB0E2, 0x552E}, //2422 #CJK UNIFIED IDEOGRAPH
    {0xB0E3, 0x555C}, //2423 #CJK UNIFIED IDEOGRAPH
    {0xB0E4, 0x552C}, //2424 #CJK UNIFIED IDEOGRAPH
    {0xB0E5, 0x5563}, //2425 #CJK UNIFIED IDEOGRAPH
    {0xB0E6, 0x5533}, //2426 #CJK UNIFIED IDEOGRAPH
    {0xB0E7, 0x5541}, //2427 #CJK UNIFIED IDEOGRAPH
    {0xB0E8, 0x5557}, //2428 #CJK UNIFIED IDEOGRAPH
    {0xB0E9, 0x5708}, //2429 #CJK UNIFIED IDEOGRAPH
    {0xB0EA, 0x570B}, //2430 #CJK UNIFIED IDEOGRAPH
    {0xB0EB, 0x5709}, //2431 #CJK UNIFIED IDEOGRAPH
    {0xB0EC, 0x57DF}, //2432 #CJK UNIFIED IDEOGRAPH
    {0xB0ED, 0x5805}, //2433 #CJK UNIFIED IDEOGRAPH
    {0xB0EE, 0x580A}, //2434 #CJK UNIFIED IDEOGRAPH
    {0xB0EF, 0x5806}, //2435 #CJK UNIFIED IDEOGRAPH
    {0xB0F0, 0x57E0}, //2436 #CJK UNIFIED IDEOGRAPH
    {0xB0F1, 0x57E4}, //2437 #CJK UNIFIED IDEOGRAPH
    {0xB0F2, 0x57FA}, //2438 #CJK UNIFIED IDEOGRAPH
    {0xB0F3, 0x5802}, //2439 #CJK UNIFIED IDEOGRAPH
    {0xB0F4, 0x5835}, //2440 #CJK UNIFIED IDEOGRAPH
    {0xB0F5, 0x57F7}, //2441 #CJK UNIFIED IDEOGRAPH
    {0xB0F6, 0x57F9}, //2442 #CJK UNIFIED IDEOGRAPH
    {0xB0F7, 0x5920}, //2443 #CJK UNIFIED IDEOGRAPH
    {0xB0F8, 0x5962}, //2444 #CJK UNIFIED IDEOGRAPH
    {0xB0F9, 0x5A36}, //2445 #CJK UNIFIED IDEOGRAPH
    {0xB0FA, 0x5A41}, //2446 #CJK UNIFIED IDEOGRAPH
    {0xB0FB, 0x5A49}, //2447 #CJK UNIFIED IDEOGRAPH
    {0xB0FC, 0x5A66}, //2448 #CJK UNIFIED IDEOGRAPH
    {0xB0FD, 0x5A6A}, //2449 #CJK UNIFIED IDEOGRAPH
    {0xB0FE, 0x5A40}, //2450 #CJK UNIFIED IDEOGRAPH
    {0xB140, 0x5A3C}, //2451 #CJK UNIFIED IDEOGRAPH
    {0xB141, 0x5A62}, //2452 #CJK UNIFIED IDEOGRAPH
    {0xB142, 0x5A5A}, //2453 #CJK UNIFIED IDEOGRAPH
    {0xB143, 0x5A46}, //2454 #CJK UNIFIED IDEOGRAPH
    {0xB144, 0x5A4A}, //2455 #CJK UNIFIED IDEOGRAPH
    {0xB145, 0x5B70}, //2456 #CJK UNIFIED IDEOGRAPH
    {0xB146, 0x5BC7}, //2457 #CJK UNIFIED IDEOGRAPH
    {0xB147, 0x5BC5}, //2458 #CJK UNIFIED IDEOGRAPH
    {0xB148, 0x5BC4}, //2459 #CJK UNIFIED IDEOGRAPH
    {0xB149, 0x5BC2}, //2460 #CJK UNIFIED IDEOGRAPH
    {0xB14A, 0x5BBF}, //2461 #CJK UNIFIED IDEOGRAPH
    {0xB14B, 0x5BC6}, //2462 #CJK UNIFIED IDEOGRAPH
    {0xB14C, 0x5C09}, //2463 #CJK UNIFIED IDEOGRAPH
    {0xB14D, 0x5C08}, //2464 #CJK UNIFIED IDEOGRAPH
    {0xB14E, 0x5C07}, //2465 #CJK UNIFIED IDEOGRAPH
    {0xB14F, 0x5C60}, //2466 #CJK UNIFIED IDEOGRAPH
    {0xB150, 0x5C5C}, //2467 #CJK UNIFIED IDEOGRAPH
    {0xB151, 0x5C5D}, //2468 #CJK UNIFIED IDEOGRAPH
    {0xB152, 0x5D07}, //2469 #CJK UNIFIED IDEOGRAPH
    {0xB153, 0x5D06}, //2470 #CJK UNIFIED IDEOGRAPH
    {0xB154, 0x5D0E}, //2471 #CJK UNIFIED IDEOGRAPH
    {0xB155, 0x5D1B}, //2472 #CJK UNIFIED IDEOGRAPH
    {0xB156, 0x5D16}, //2473 #CJK UNIFIED IDEOGRAPH
    {0xB157, 0x5D22}, //2474 #CJK UNIFIED IDEOGRAPH
    {0xB158, 0x5D11}, //2475 #CJK UNIFIED IDEOGRAPH
    {0xB159, 0x5D29}, //2476 #CJK UNIFIED IDEOGRAPH
    {0xB15A, 0x5D14}, //2477 #CJK UNIFIED IDEOGRAPH
    {0xB15B, 0x5D19}, //2478 #CJK UNIFIED IDEOGRAPH
    {0xB15C, 0x5D24}, //2479 #CJK UNIFIED IDEOGRAPH
    {0xB15D, 0x5D27}, //2480 #CJK UNIFIED IDEOGRAPH
    {0xB15E, 0x5D17}, //2481 #CJK UNIFIED IDEOGRAPH
    {0xB15F, 0x5DE2}, //2482 #CJK UNIFIED IDEOGRAPH
    {0xB160, 0x5E38}, //2483 #CJK UNIFIED IDEOGRAPH
    {0xB161, 0x5E36}, //2484 #CJK UNIFIED IDEOGRAPH
    {0xB162, 0x5E33}, //2485 #CJK UNIFIED IDEOGRAPH
    {0xB163, 0x5E37}, //2486 #CJK UNIFIED IDEOGRAPH
    {0xB164, 0x5EB7}, //2487 #CJK UNIFIED IDEOGRAPH
    {0xB165, 0x5EB8}, //2488 #CJK UNIFIED IDEOGRAPH
    {0xB166, 0x5EB6}, //2489 #CJK UNIFIED IDEOGRAPH
    {0xB167, 0x5EB5}, //2490 #CJK UNIFIED IDEOGRAPH
    {0xB168, 0x5EBE}, //2491 #CJK UNIFIED IDEOGRAPH
    {0xB169, 0x5F35}, //2492 #CJK UNIFIED IDEOGRAPH
    {0xB16A, 0x5F37}, //2493 #CJK UNIFIED IDEOGRAPH
    {0xB16B, 0x5F57}, //2494 #CJK UNIFIED IDEOGRAPH
    {0xB16C, 0x5F6C}, //2495 #CJK UNIFIED IDEOGRAPH
    {0xB16D, 0x5F69}, //2496 #CJK UNIFIED IDEOGRAPH
    {0xB16E, 0x5F6B}, //2497 #CJK UNIFIED IDEOGRAPH
    {0xB16F, 0x5F97}, //2498 #CJK UNIFIED IDEOGRAPH
    {0xB170, 0x5F99}, //2499 #CJK UNIFIED IDEOGRAPH
    {0xB171, 0x5F9E}, //2500 #CJK UNIFIED IDEOGRAPH
    {0xB172, 0x5F98}, //2501 #CJK UNIFIED IDEOGRAPH
    {0xB173, 0x5FA1}, //2502 #CJK UNIFIED IDEOGRAPH
    {0xB174, 0x5FA0}, //2503 #CJK UNIFIED IDEOGRAPH
    {0xB175, 0x5F9C}, //2504 #CJK UNIFIED IDEOGRAPH
    {0xB176, 0x607F}, //2505 #CJK UNIFIED IDEOGRAPH
    {0xB177, 0x60A3}, //2506 #CJK UNIFIED IDEOGRAPH
    {0xB178, 0x6089}, //2507 #CJK UNIFIED IDEOGRAPH
    {0xB179, 0x60A0}, //2508 #CJK UNIFIED IDEOGRAPH
    {0xB17A, 0x60A8}, //2509 #CJK UNIFIED IDEOGRAPH
    {0xB17B, 0x60CB}, //2510 #CJK UNIFIED IDEOGRAPH
    {0xB17C, 0x60B4}, //2511 #CJK UNIFIED IDEOGRAPH
    {0xB17D, 0x60E6}, //2512 #CJK UNIFIED IDEOGRAPH
    {0xB17E, 0x60BD}, //2513 #CJK UNIFIED IDEOGRAPH
    {0xB1A1, 0x60C5}, //2514 #CJK UNIFIED IDEOGRAPH
    {0xB1A2, 0x60BB}, //2515 #CJK UNIFIED IDEOGRAPH
    {0xB1A3, 0x60B5}, //2516 #CJK UNIFIED IDEOGRAPH
    {0xB1A4, 0x60DC}, //2517 #CJK UNIFIED IDEOGRAPH
    {0xB1A5, 0x60BC}, //2518 #CJK UNIFIED IDEOGRAPH
    {0xB1A6, 0x60D8}, //2519 #CJK UNIFIED IDEOGRAPH
    {0xB1A7, 0x60D5}, //2520 #CJK UNIFIED IDEOGRAPH
    {0xB1A8, 0x60C6}, //2521 #CJK UNIFIED IDEOGRAPH
    {0xB1A9, 0x60DF}, //2522 #CJK UNIFIED IDEOGRAPH
    {0xB1AA, 0x60B8}, //2523 #CJK UNIFIED IDEOGRAPH
    {0xB1AB, 0x60DA}, //2524 #CJK UNIFIED IDEOGRAPH
    {0xB1AC, 0x60C7}, //2525 #CJK UNIFIED IDEOGRAPH
    {0xB1AD, 0x621A}, //2526 #CJK UNIFIED IDEOGRAPH
    {0xB1AE, 0x621B}, //2527 #CJK UNIFIED IDEOGRAPH
    {0xB1AF, 0x6248}, //2528 #CJK UNIFIED IDEOGRAPH
    {0xB1B0, 0x63A0}, //2529 #CJK UNIFIED IDEOGRAPH
    {0xB1B1, 0x63A7}, //2530 #CJK UNIFIED IDEOGRAPH
    {0xB1B2, 0x6372}, //2531 #CJK UNIFIED IDEOGRAPH
    {0xB1B3, 0x6396}, //2532 #CJK UNIFIED IDEOGRAPH
    {0xB1B4, 0x63A2}, //2533 #CJK UNIFIED IDEOGRAPH
    {0xB1B5, 0x63A5}, //2534 #CJK UNIFIED IDEOGRAPH
    {0xB1B6, 0x6377}, //2535 #CJK UNIFIED IDEOGRAPH
    {0xB1B7, 0x6367}, //2536 #CJK UNIFIED IDEOGRAPH
    {0xB1B8, 0x6398}, //2537 #CJK UNIFIED IDEOGRAPH
    {0xB1B9, 0x63AA}, //2538 #CJK UNIFIED IDEOGRAPH
    {0xB1BA, 0x6371}, //2539 #CJK UNIFIED IDEOGRAPH
    {0xB1BB, 0x63A9}, //2540 #CJK UNIFIED IDEOGRAPH
    {0xB1BC, 0x6389}, //2541 #CJK UNIFIED IDEOGRAPH
    {0xB1BD, 0x6383}, //2542 #CJK UNIFIED IDEOGRAPH
    {0xB1BE, 0x639B}, //2543 #CJK UNIFIED IDEOGRAPH
    {0xB1BF, 0x636B}, //2544 #CJK UNIFIED IDEOGRAPH
    {0xB1C0, 0x63A8}, //2545 #CJK UNIFIED IDEOGRAPH
    {0xB1C1, 0x6384}, //2546 #CJK UNIFIED IDEOGRAPH
    {0xB1C2, 0x6388}, //2547 #CJK UNIFIED IDEOGRAPH
    {0xB1C3, 0x6399}, //2548 #CJK UNIFIED IDEOGRAPH
    {0xB1C4, 0x63A1}, //2549 #CJK UNIFIED IDEOGRAPH
    {0xB1C5, 0x63AC}, //2550 #CJK UNIFIED IDEOGRAPH
    {0xB1C6, 0x6392}, //2551 #CJK UNIFIED IDEOGRAPH
    {0xB1C7, 0x638F}, //2552 #CJK UNIFIED IDEOGRAPH
    {0xB1C8, 0x6380}, //2553 #CJK UNIFIED IDEOGRAPH
    {0xB1C9, 0x637B}, //2554 #CJK UNIFIED IDEOGRAPH
    {0xB1CA, 0x6369}, //2555 #CJK UNIFIED IDEOGRAPH
    {0xB1CB, 0x6368}, //2556 #CJK UNIFIED IDEOGRAPH
    {0xB1CC, 0x637A}, //2557 #CJK UNIFIED IDEOGRAPH
    {0xB1CD, 0x655D}, //2558 #CJK UNIFIED IDEOGRAPH
    {0xB1CE, 0x6556}, //2559 #CJK UNIFIED IDEOGRAPH
    {0xB1CF, 0x6551}, //2560 #CJK UNIFIED IDEOGRAPH
    {0xB1D0, 0x6559}, //2561 #CJK UNIFIED IDEOGRAPH
    {0xB1D1, 0x6557}, //2562 #CJK UNIFIED IDEOGRAPH
    {0xB1D2, 0x555F}, //2563 #CJK UNIFIED IDEOGRAPH
    {0xB1D3, 0x654F}, //2564 #CJK UNIFIED IDEOGRAPH
    {0xB1D4, 0x6558}, //2565 #CJK UNIFIED IDEOGRAPH
    {0xB1D5, 0x6555}, //2566 #CJK UNIFIED IDEOGRAPH
    {0xB1D6, 0x6554}, //2567 #CJK UNIFIED IDEOGRAPH
    {0xB1D7, 0x659C}, //2568 #CJK UNIFIED IDEOGRAPH
    {0xB1D8, 0x659B}, //2569 #CJK UNIFIED IDEOGRAPH
    {0xB1D9, 0x65AC}, //2570 #CJK UNIFIED IDEOGRAPH
    {0xB1DA, 0x65CF}, //2571 #CJK UNIFIED IDEOGRAPH
    {0xB1DB, 0x65CB}, //2572 #CJK UNIFIED IDEOGRAPH
    {0xB1DC, 0x65CC}, //2573 #CJK UNIFIED IDEOGRAPH
    {0xB1DD, 0x65CE}, //2574 #CJK UNIFIED IDEOGRAPH
    {0xB1DE, 0x665D}, //2575 #CJK UNIFIED IDEOGRAPH
    {0xB1DF, 0x665A}, //2576 #CJK UNIFIED IDEOGRAPH
    {0xB1E0, 0x6664}, //2577 #CJK UNIFIED IDEOGRAPH
    {0xB1E1, 0x6668}, //2578 #CJK UNIFIED IDEOGRAPH
    {0xB1E2, 0x6666}, //2579 #CJK UNIFIED IDEOGRAPH
    {0xB1E3, 0x665E}, //2580 #CJK UNIFIED IDEOGRAPH
    {0xB1E4, 0x66F9}, //2581 #CJK UNIFIED IDEOGRAPH
    {0xB1E5, 0x52D7}, //2582 #CJK UNIFIED IDEOGRAPH
    {0xB1E6, 0x671B}, //2583 #CJK UNIFIED IDEOGRAPH
    {0xB1E7, 0x6881}, //2584 #CJK UNIFIED IDEOGRAPH
    {0xB1E8, 0x68AF}, //2585 #CJK UNIFIED IDEOGRAPH
    {0xB1E9, 0x68A2}, //2586 #CJK UNIFIED IDEOGRAPH
    {0xB1EA, 0x6893}, //2587 #CJK UNIFIED IDEOGRAPH
    {0xB1EB, 0x68B5}, //2588 #CJK UNIFIED IDEOGRAPH
    {0xB1EC, 0x687F}, //2589 #CJK UNIFIED IDEOGRAPH
    {0xB1ED, 0x6876}, //2590 #CJK UNIFIED IDEOGRAPH
    {0xB1EE, 0x68B1}, //2591 #CJK UNIFIED IDEOGRAPH
    {0xB1EF, 0x68A7}, //2592 #CJK UNIFIED IDEOGRAPH
    {0xB1F0, 0x6897}, //2593 #CJK UNIFIED IDEOGRAPH
    {0xB1F1, 0x68B0}, //2594 #CJK UNIFIED IDEOGRAPH
    {0xB1F2, 0x6883}, //2595 #CJK UNIFIED IDEOGRAPH
    {0xB1F3, 0x68C4}, //2596 #CJK UNIFIED IDEOGRAPH
    {0xB1F4, 0x68AD}, //2597 #CJK UNIFIED IDEOGRAPH
    {0xB1F5, 0x6886}, //2598 #CJK UNIFIED IDEOGRAPH
    {0xB1F6, 0x6885}, //2599 #CJK UNIFIED IDEOGRAPH
    {0xB1F7, 0x6894}, //2600 #CJK UNIFIED IDEOGRAPH
    {0xB1F8, 0x689D}, //2601 #CJK UNIFIED IDEOGRAPH
    {0xB1F9, 0x68A8}, //2602 #CJK UNIFIED IDEOGRAPH
    {0xB1FA, 0x689F}, //2603 #CJK UNIFIED IDEOGRAPH
    {0xB1FB, 0x68A1}, //2604 #CJK UNIFIED IDEOGRAPH
    {0xB1FC, 0x6882}, //2605 #CJK UNIFIED IDEOGRAPH
    {0xB1FD, 0x6B32}, //2606 #CJK UNIFIED IDEOGRAPH
    {0xB1FE, 0x6BBA}, //2607 #CJK UNIFIED IDEOGRAPH
    {0xB240, 0x6BEB}, //2608 #CJK UNIFIED IDEOGRAPH
    {0xB241, 0x6BEC}, //2609 #CJK UNIFIED IDEOGRAPH
    {0xB242, 0x6C2B}, //2610 #CJK UNIFIED IDEOGRAPH
    {0xB243, 0x6D8E}, //2611 #CJK UNIFIED IDEOGRAPH
    {0xB244, 0x6DBC}, //2612 #CJK UNIFIED IDEOGRAPH
    {0xB245, 0x6DF3}, //2613 #CJK UNIFIED IDEOGRAPH
    {0xB246, 0x6DD9}, //2614 #CJK UNIFIED IDEOGRAPH
    {0xB247, 0x6DB2}, //2615 #CJK UNIFIED IDEOGRAPH
    {0xB248, 0x6DE1}, //2616 #CJK UNIFIED IDEOGRAPH
    {0xB249, 0x6DCC}, //2617 #CJK UNIFIED IDEOGRAPH
    {0xB24A, 0x6DE4}, //2618 #CJK UNIFIED IDEOGRAPH
    {0xB24B, 0x6DFB}, //2619 #CJK UNIFIED IDEOGRAPH
    {0xB24C, 0x6DFA}, //2620 #CJK UNIFIED IDEOGRAPH
    {0xB24D, 0x6E05}, //2621 #CJK UNIFIED IDEOGRAPH
    {0xB24E, 0x6DC7}, //2622 #CJK UNIFIED IDEOGRAPH
    {0xB24F, 0x6DCB}, //2623 #CJK UNIFIED IDEOGRAPH
    {0xB250, 0x6DAF}, //2624 #CJK UNIFIED IDEOGRAPH
    {0xB251, 0x6DD1}, //2625 #CJK UNIFIED IDEOGRAPH
    {0xB252, 0x6DAE}, //2626 #CJK UNIFIED IDEOGRAPH
    {0xB253, 0x6DDE}, //2627 #CJK UNIFIED IDEOGRAPH
    {0xB254, 0x6DF9}, //2628 #CJK UNIFIED IDEOGRAPH
    {0xB255, 0x6DB8}, //2629 #CJK UNIFIED IDEOGRAPH
    {0xB256, 0x6DF7}, //2630 #CJK UNIFIED IDEOGRAPH
    {0xB257, 0x6DF5}, //2631 #CJK UNIFIED IDEOGRAPH
    {0xB258, 0x6DC5}, //2632 #CJK UNIFIED IDEOGRAPH
    {0xB259, 0x6DD2}, //2633 #CJK UNIFIED IDEOGRAPH
    {0xB25A, 0x6E1A}, //2634 #CJK UNIFIED IDEOGRAPH
    {0xB25B, 0x6DB5}, //2635 #CJK UNIFIED IDEOGRAPH
    {0xB25C, 0x6DDA}, //2636 #CJK UNIFIED IDEOGRAPH
    {0xB25D, 0x6DEB}, //2637 #CJK UNIFIED IDEOGRAPH
    {0xB25E, 0x6DD8}, //2638 #CJK UNIFIED IDEOGRAPH
    {0xB25F, 0x6DEA}, //2639 #CJK UNIFIED IDEOGRAPH
    {0xB260, 0x6DF1}, //2640 #CJK UNIFIED IDEOGRAPH
    {0xB261, 0x6DEE}, //2641 #CJK UNIFIED IDEOGRAPH
    {0xB262, 0x6DE8}, //2642 #CJK UNIFIED IDEOGRAPH
    {0xB263, 0x6DC6}, //2643 #CJK UNIFIED IDEOGRAPH
    {0xB264, 0x6DC4}, //2644 #CJK UNIFIED IDEOGRAPH
    {0xB265, 0x6DAA}, //2645 #CJK UNIFIED IDEOGRAPH
    {0xB266, 0x6DEC}, //2646 #CJK UNIFIED IDEOGRAPH
    {0xB267, 0x6DBF}, //2647 #CJK UNIFIED IDEOGRAPH
    {0xB268, 0x6DE6}, //2648 #CJK UNIFIED IDEOGRAPH
    {0xB269, 0x70F9}, //2649 #CJK UNIFIED IDEOGRAPH
    {0xB26A, 0x7109}, //2650 #CJK UNIFIED IDEOGRAPH
    {0xB26B, 0x710A}, //2651 #CJK UNIFIED IDEOGRAPH
    {0xB26C, 0x70FD}, //2652 #CJK UNIFIED IDEOGRAPH
    {0xB26D, 0x70EF}, //2653 #CJK UNIFIED IDEOGRAPH
    {0xB26E, 0x723D}, //2654 #CJK UNIFIED IDEOGRAPH
    {0xB26F, 0x727D}, //2655 #CJK UNIFIED IDEOGRAPH
    {0xB270, 0x7281}, //2656 #CJK UNIFIED IDEOGRAPH
    {0xB271, 0x731C}, //2657 #CJK UNIFIED IDEOGRAPH
    {0xB272, 0x731B}, //2658 #CJK UNIFIED IDEOGRAPH
    {0xB273, 0x7316}, //2659 #CJK UNIFIED IDEOGRAPH
    {0xB274, 0x7313}, //2660 #CJK UNIFIED IDEOGRAPH
    {0xB275, 0x7319}, //2661 #CJK UNIFIED IDEOGRAPH
    {0xB276, 0x7387}, //2662 #CJK UNIFIED IDEOGRAPH
    {0xB277, 0x7405}, //2663 #CJK UNIFIED IDEOGRAPH
    {0xB278, 0x740A}, //2664 #CJK UNIFIED IDEOGRAPH
    {0xB279, 0x7403}, //2665 #CJK UNIFIED IDEOGRAPH
    {0xB27A, 0x7406}, //2666 #CJK UNIFIED IDEOGRAPH
    {0xB27B, 0x73FE}, //2667 #CJK UNIFIED IDEOGRAPH
    {0xB27C, 0x740D}, //2668 #CJK UNIFIED IDEOGRAPH
    {0xB27D, 0x74E0}, //2669 #CJK UNIFIED IDEOGRAPH
    {0xB27E, 0x74F6}, //2670 #CJK UNIFIED IDEOGRAPH
    {0xB2A1, 0x74F7}, //2671 #CJK UNIFIED IDEOGRAPH
    {0xB2A2, 0x751C}, //2672 #CJK UNIFIED IDEOGRAPH
    {0xB2A3, 0x7522}, //2673 #CJK UNIFIED IDEOGRAPH
    {0xB2A4, 0x7565}, //2674 #CJK UNIFIED IDEOGRAPH
    {0xB2A5, 0x7566}, //2675 #CJK UNIFIED IDEOGRAPH
    {0xB2A6, 0x7562}, //2676 #CJK UNIFIED IDEOGRAPH
    {0xB2A7, 0x7570}, //2677 #CJK UNIFIED IDEOGRAPH
    {0xB2A8, 0x758F}, //2678 #CJK UNIFIED IDEOGRAPH
    {0xB2A9, 0x75D4}, //2679 #CJK UNIFIED IDEOGRAPH
    {0xB2AA, 0x75D5}, //2680 #CJK UNIFIED IDEOGRAPH
    {0xB2AB, 0x75B5}, //2681 #CJK UNIFIED IDEOGRAPH
    {0xB2AC, 0x75CA}, //2682 #CJK UNIFIED IDEOGRAPH
    {0xB2AD, 0x75CD}, //2683 #CJK UNIFIED IDEOGRAPH
    {0xB2AE, 0x768E}, //2684 #CJK UNIFIED IDEOGRAPH
    {0xB2AF, 0x76D4}, //2685 #CJK UNIFIED IDEOGRAPH
    {0xB2B0, 0x76D2}, //2686 #CJK UNIFIED IDEOGRAPH
    {0xB2B1, 0x76DB}, //2687 #CJK UNIFIED IDEOGRAPH
    {0xB2B2, 0x7737}, //2688 #CJK UNIFIED IDEOGRAPH
    {0xB2B3, 0x773E}, //2689 #CJK UNIFIED IDEOGRAPH
    {0xB2B4, 0x773C}, //2690 #CJK UNIFIED IDEOGRAPH
    {0xB2B5, 0x7736}, //2691 #CJK UNIFIED IDEOGRAPH
    {0xB2B6, 0x7738}, //2692 #CJK UNIFIED IDEOGRAPH
    {0xB2B7, 0x773A}, //2693 #CJK UNIFIED IDEOGRAPH
    {0xB2B8, 0x786B}, //2694 #CJK UNIFIED IDEOGRAPH
    {0xB2B9, 0x7843}, //2695 #CJK UNIFIED IDEOGRAPH
    {0xB2BA, 0x784E}, //2696 #CJK UNIFIED IDEOGRAPH
    {0xB2BB, 0x7965}, //2697 #CJK UNIFIED IDEOGRAPH
    {0xB2BC, 0x7968}, //2698 #CJK UNIFIED IDEOGRAPH
    {0xB2BD, 0x796D}, //2699 #CJK UNIFIED IDEOGRAPH
    {0xB2BE, 0x79FB}, //2700 #CJK UNIFIED IDEOGRAPH
    {0xB2BF, 0x7A92}, //2701 #CJK UNIFIED IDEOGRAPH
    {0xB2C0, 0x7A95}, //2702 #CJK UNIFIED IDEOGRAPH
    {0xB2C1, 0x7B20}, //2703 #CJK UNIFIED IDEOGRAPH
    {0xB2C2, 0x7B28}, //2704 #CJK UNIFIED IDEOGRAPH
    {0xB2C3, 0x7B1B}, //2705 #CJK UNIFIED IDEOGRAPH
    {0xB2C4, 0x7B2C}, //2706 #CJK UNIFIED IDEOGRAPH
    {0xB2C5, 0x7B26}, //2707 #CJK UNIFIED IDEOGRAPH
    {0xB2C6, 0x7B19}, //2708 #CJK UNIFIED IDEOGRAPH
    {0xB2C7, 0x7B1E}, //2709 #CJK UNIFIED IDEOGRAPH
    {0xB2C8, 0x7B2E}, //2710 #CJK UNIFIED IDEOGRAPH
    {0xB2C9, 0x7C92}, //2711 #CJK UNIFIED IDEOGRAPH
    {0xB2CA, 0x7C97}, //2712 #CJK UNIFIED IDEOGRAPH
    {0xB2CB, 0x7C95}, //2713 #CJK UNIFIED IDEOGRAPH
    {0xB2CC, 0x7D46}, //2714 #CJK UNIFIED IDEOGRAPH
    {0xB2CD, 0x7D43}, //2715 #CJK UNIFIED IDEOGRAPH
    {0xB2CE, 0x7D71}, //2716 #CJK UNIFIED IDEOGRAPH
    {0xB2CF, 0x7D2E}, //2717 #CJK UNIFIED IDEOGRAPH
    {0xB2D0, 0x7D39}, //2718 #CJK UNIFIED IDEOGRAPH
    {0xB2D1, 0x7D3C}, //2719 #CJK UNIFIED IDEOGRAPH
    {0xB2D2, 0x7D40}, //2720 #CJK UNIFIED IDEOGRAPH
    {0xB2D3, 0x7D30}, //2721 #CJK UNIFIED IDEOGRAPH
    {0xB2D4, 0x7D33}, //2722 #CJK UNIFIED IDEOGRAPH
    {0xB2D5, 0x7D44}, //2723 #CJK UNIFIED IDEOGRAPH
    {0xB2D6, 0x7D2F}, //2724 #CJK UNIFIED IDEOGRAPH
    {0xB2D7, 0x7D42}, //2725 #CJK UNIFIED IDEOGRAPH
    {0xB2D8, 0x7D32}, //2726 #CJK UNIFIED IDEOGRAPH
    {0xB2D9, 0x7D31}, //2727 #CJK UNIFIED IDEOGRAPH
    {0xB2DA, 0x7F3D}, //2728 #CJK UNIFIED IDEOGRAPH
    {0xB2DB, 0x7F9E}, //2729 #CJK UNIFIED IDEOGRAPH
    {0xB2DC, 0x7F9A}, //2730 #CJK UNIFIED IDEOGRAPH
    {0xB2DD, 0x7FCC}, //2731 #CJK UNIFIED IDEOGRAPH
    {0xB2DE, 0x7FCE}, //2732 #CJK UNIFIED IDEOGRAPH
    {0xB2DF, 0x7FD2}, //2733 #CJK UNIFIED IDEOGRAPH
    {0xB2E0, 0x801C}, //2734 #CJK UNIFIED IDEOGRAPH
    {0xB2E1, 0x804A}, //2735 #CJK UNIFIED IDEOGRAPH
    {0xB2E2, 0x8046}, //2736 #CJK UNIFIED IDEOGRAPH
    {0xB2E3, 0x812F}, //2737 #CJK UNIFIED IDEOGRAPH
    {0xB2E4, 0x8116}, //2738 #CJK UNIFIED IDEOGRAPH
    {0xB2E5, 0x8123}, //2739 #CJK UNIFIED IDEOGRAPH
    {0xB2E6, 0x812B}, //2740 #CJK UNIFIED IDEOGRAPH
    {0xB2E7, 0x8129}, //2741 #CJK UNIFIED IDEOGRAPH
    {0xB2E8, 0x8130}, //2742 #CJK UNIFIED IDEOGRAPH
    {0xB2E9, 0x8124}, //2743 #CJK UNIFIED IDEOGRAPH
    {0xB2EA, 0x8202}, //2744 #CJK UNIFIED IDEOGRAPH
    {0xB2EB, 0x8235}, //2745 #CJK UNIFIED IDEOGRAPH
    {0xB2EC, 0x8237}, //2746 #CJK UNIFIED IDEOGRAPH
    {0xB2ED, 0x8236}, //2747 #CJK UNIFIED IDEOGRAPH
    {0xB2EE, 0x8239}, //2748 #CJK UNIFIED IDEOGRAPH
    {0xB2EF, 0x838E}, //2749 #CJK UNIFIED IDEOGRAPH
    {0xB2F0, 0x839E}, //2750 #CJK UNIFIED IDEOGRAPH
    {0xB2F1, 0x8398}, //2751 #CJK UNIFIED IDEOGRAPH
    {0xB2F2, 0x8378}, //2752 #CJK UNIFIED IDEOGRAPH
    {0xB2F3, 0x83A2}, //2753 #CJK UNIFIED IDEOGRAPH
    {0xB2F4, 0x8396}, //2754 #CJK UNIFIED IDEOGRAPH
    {0xB2F5, 0x83BD}, //2755 #CJK UNIFIED IDEOGRAPH
    {0xB2F6, 0x83AB}, //2756 #CJK UNIFIED IDEOGRAPH
    {0xB2F7, 0x8392}, //2757 #CJK UNIFIED IDEOGRAPH
    {0xB2F8, 0x838A}, //2758 #CJK UNIFIED IDEOGRAPH
    {0xB2F9, 0x8393}, //2759 #CJK UNIFIED IDEOGRAPH
    {0xB2FA, 0x8389}, //2760 #CJK UNIFIED IDEOGRAPH
    {0xB2FB, 0x83A0}, //2761 #CJK UNIFIED IDEOGRAPH
    {0xB2FC, 0x8377}, //2762 #CJK UNIFIED IDEOGRAPH
    {0xB2FD, 0x837B}, //2763 #CJK UNIFIED IDEOGRAPH
    {0xB2FE, 0x837C}, //2764 #CJK UNIFIED IDEOGRAPH
    {0xB340, 0x8386}, //2765 #CJK UNIFIED IDEOGRAPH
    {0xB341, 0x83A7}, //2766 #CJK UNIFIED IDEOGRAPH
    {0xB342, 0x8655}, //2767 #CJK UNIFIED IDEOGRAPH
    {0xB343, 0x5F6A}, //2768 #CJK UNIFIED IDEOGRAPH
    {0xB344, 0x86C7}, //2769 #CJK UNIFIED IDEOGRAPH
    {0xB345, 0x86C0}, //2770 #CJK UNIFIED IDEOGRAPH
    {0xB346, 0x86B6}, //2771 #CJK UNIFIED IDEOGRAPH
    {0xB347, 0x86C4}, //2772 #CJK UNIFIED IDEOGRAPH
    {0xB348, 0x86B5}, //2773 #CJK UNIFIED IDEOGRAPH
    {0xB349, 0x86C6}, //2774 #CJK UNIFIED IDEOGRAPH
    {0xB34A, 0x86CB}, //2775 #CJK UNIFIED IDEOGRAPH
    {0xB34B, 0x86B1}, //2776 #CJK UNIFIED IDEOGRAPH
    {0xB34C, 0x86AF}, //2777 #CJK UNIFIED IDEOGRAPH
    {0xB34D, 0x86C9}, //2778 #CJK UNIFIED IDEOGRAPH
    {0xB34E, 0x8853}, //2779 #CJK UNIFIED IDEOGRAPH
    {0xB34F, 0x889E}, //2780 #CJK UNIFIED IDEOGRAPH
    {0xB350, 0x8888}, //2781 #CJK UNIFIED IDEOGRAPH
    {0xB351, 0x88AB}, //2782 #CJK UNIFIED IDEOGRAPH
    {0xB352, 0x8892}, //2783 #CJK UNIFIED IDEOGRAPH
    {0xB353, 0x8896}, //2784 #CJK UNIFIED IDEOGRAPH
    {0xB354, 0x888D}, //2785 #CJK UNIFIED IDEOGRAPH
    {0xB355, 0x888B}, //2786 #CJK UNIFIED IDEOGRAPH
    {0xB356, 0x8993}, //2787 #CJK UNIFIED IDEOGRAPH
    {0xB357, 0x898F}, //2788 #CJK UNIFIED IDEOGRAPH
    {0xB358, 0x8A2A}, //2789 #CJK UNIFIED IDEOGRAPH
    {0xB359, 0x8A1D}, //2790 #CJK UNIFIED IDEOGRAPH
    {0xB35A, 0x8A23}, //2791 #CJK UNIFIED IDEOGRAPH
    {0xB35B, 0x8A25}, //2792 #CJK UNIFIED IDEOGRAPH
    {0xB35C, 0x8A31}, //2793 #CJK UNIFIED IDEOGRAPH
    {0xB35D, 0x8A2D}, //2794 #CJK UNIFIED IDEOGRAPH
    {0xB35E, 0x8A1F}, //2795 #CJK UNIFIED IDEOGRAPH
    {0xB35F, 0x8A1B}, //2796 #CJK UNIFIED IDEOGRAPH
    {0xB360, 0x8A22}, //2797 #CJK UNIFIED IDEOGRAPH
    {0xB361, 0x8C49}, //2798 #CJK UNIFIED IDEOGRAPH
    {0xB362, 0x8C5A}, //2799 #CJK UNIFIED IDEOGRAPH
    {0xB363, 0x8CA9}, //2800 #CJK UNIFIED IDEOGRAPH
    {0xB364, 0x8CAC}, //2801 #CJK UNIFIED IDEOGRAPH
    {0xB365, 0x8CAB}, //2802 #CJK UNIFIED IDEOGRAPH
    {0xB366, 0x8CA8}, //2803 #CJK UNIFIED IDEOGRAPH
    {0xB367, 0x8CAA}, //2804 #CJK UNIFIED IDEOGRAPH
    {0xB368, 0x8CA7}, //2805 #CJK UNIFIED IDEOGRAPH
    {0xB369, 0x8D67}, //2806 #CJK UNIFIED IDEOGRAPH
    {0xB36A, 0x8D66}, //2807 #CJK UNIFIED IDEOGRAPH
    {0xB36B, 0x8DBE}, //2808 #CJK UNIFIED IDEOGRAPH
    {0xB36C, 0x8DBA}, //2809 #CJK UNIFIED IDEOGRAPH
    {0xB36D, 0x8EDB}, //2810 #CJK UNIFIED IDEOGRAPH
    {0xB36E, 0x8EDF}, //2811 #CJK UNIFIED IDEOGRAPH
    {0xB36F, 0x9019}, //2812 #CJK UNIFIED IDEOGRAPH
    {0xB370, 0x900D}, //2813 #CJK UNIFIED IDEOGRAPH
    {0xB371, 0x901A}, //2814 #CJK UNIFIED IDEOGRAPH
    {0xB372, 0x9017}, //2815 #CJK UNIFIED IDEOGRAPH
    {0xB373, 0x9023}, //2816 #CJK UNIFIED IDEOGRAPH
    {0xB374, 0x901F}, //2817 #CJK UNIFIED IDEOGRAPH
    {0xB375, 0x901D}, //2818 #CJK UNIFIED IDEOGRAPH
    {0xB376, 0x9010}, //2819 #CJK UNIFIED IDEOGRAPH
    {0xB377, 0x9015}, //2820 #CJK UNIFIED IDEOGRAPH
    {0xB378, 0x901E}, //2821 #CJK UNIFIED IDEOGRAPH
    {0xB379, 0x9020}, //2822 #CJK UNIFIED IDEOGRAPH
    {0xB37A, 0x900F}, //2823 #CJK UNIFIED IDEOGRAPH
    {0xB37B, 0x9022}, //2824 #CJK UNIFIED IDEOGRAPH
    {0xB37C, 0x9016}, //2825 #CJK UNIFIED IDEOGRAPH
    {0xB37D, 0x901B}, //2826 #CJK UNIFIED IDEOGRAPH
    {0xB37E, 0x9014}, //2827 #CJK UNIFIED IDEOGRAPH
    {0xB3A1, 0x90E8}, //2828 #CJK UNIFIED IDEOGRAPH
    {0xB3A2, 0x90ED}, //2829 #CJK UNIFIED IDEOGRAPH
    {0xB3A3, 0x90FD}, //2830 #CJK UNIFIED IDEOGRAPH
    {0xB3A4, 0x9157}, //2831 #CJK UNIFIED IDEOGRAPH
    {0xB3A5, 0x91CE}, //2832 #CJK UNIFIED IDEOGRAPH
    {0xB3A6, 0x91F5}, //2833 #CJK UNIFIED IDEOGRAPH
    {0xB3A7, 0x91E6}, //2834 #CJK UNIFIED IDEOGRAPH
    {0xB3A8, 0x91E3}, //2835 #CJK UNIFIED IDEOGRAPH
    {0xB3A9, 0x91E7}, //2836 #CJK UNIFIED IDEOGRAPH
    {0xB3AA, 0x91ED}, //2837 #CJK UNIFIED IDEOGRAPH
    {0xB3AB, 0x91E9}, //2838 #CJK UNIFIED IDEOGRAPH
    {0xB3AC, 0x9589}, //2839 #CJK UNIFIED IDEOGRAPH
    {0xB3AD, 0x966A}, //2840 #CJK UNIFIED IDEOGRAPH
    {0xB3AE, 0x9675}, //2841 #CJK UNIFIED IDEOGRAPH
    {0xB3AF, 0x9673}, //2842 #CJK UNIFIED IDEOGRAPH
    {0xB3B0, 0x9678}, //2843 #CJK UNIFIED IDEOGRAPH
    {0xB3B1, 0x9670}, //2844 #CJK UNIFIED IDEOGRAPH
    {0xB3B2, 0x9674}, //2845 #CJK UNIFIED IDEOGRAPH
    {0xB3B3, 0x9676}, //2846 #CJK UNIFIED IDEOGRAPH
    {0xB3B4, 0x9677}, //2847 #CJK UNIFIED IDEOGRAPH
    {0xB3B5, 0x966C}, //2848 #CJK UNIFIED IDEOGRAPH
    {0xB3B6, 0x96C0}, //2849 #CJK UNIFIED IDEOGRAPH
    {0xB3B7, 0x96EA}, //2850 #CJK UNIFIED IDEOGRAPH
    {0xB3B8, 0x96E9}, //2851 #CJK UNIFIED IDEOGRAPH
    {0xB3B9, 0x7AE0}, //2852 #CJK UNIFIED IDEOGRAPH
    {0xB3BA, 0x7ADF}, //2853 #CJK UNIFIED IDEOGRAPH
    {0xB3BB, 0x9802}, //2854 #CJK UNIFIED IDEOGRAPH
    {0xB3BC, 0x9803}, //2855 #CJK UNIFIED IDEOGRAPH
    {0xB3BD, 0x9B5A}, //2856 #CJK UNIFIED IDEOGRAPH
    {0xB3BE, 0x9CE5}, //2857 #CJK UNIFIED IDEOGRAPH
    {0xB3BF, 0x9E75}, //2858 #CJK UNIFIED IDEOGRAPH
    {0xB3C0, 0x9E7F}, //2859 #CJK UNIFIED IDEOGRAPH
    {0xB3C1, 0x9EA5}, //2860 #CJK UNIFIED IDEOGRAPH
    {0xB3C2, 0x9EBB}, //2861 #CJK UNIFIED IDEOGRAPH
    {0xB3C3, 0x50A2}, //2862 #CJK UNIFIED IDEOGRAPH
    {0xB3C4, 0x508D}, //2863 #CJK UNIFIED IDEOGRAPH
    {0xB3C5, 0x5085}, //2864 #CJK UNIFIED IDEOGRAPH
    {0xB3C6, 0x5099}, //2865 #CJK UNIFIED IDEOGRAPH
    {0xB3C7, 0x5091}, //2866 #CJK UNIFIED IDEOGRAPH
    {0xB3C8, 0x5080}, //2867 #CJK UNIFIED IDEOGRAPH
    {0xB3C9, 0x5096}, //2868 #CJK UNIFIED IDEOGRAPH
    {0xB3CA, 0x5098}, //2869 #CJK UNIFIED IDEOGRAPH
    {0xB3CB, 0x509A}, //2870 #CJK UNIFIED IDEOGRAPH
    {0xB3CC, 0x6700}, //2871 #CJK UNIFIED IDEOGRAPH
    {0xB3CD, 0x51F1}, //2872 #CJK UNIFIED IDEOGRAPH
    {0xB3CE, 0x5272}, //2873 #CJK UNIFIED IDEOGRAPH
    {0xB3CF, 0x5274}, //2874 #CJK UNIFIED IDEOGRAPH
    {0xB3D0, 0x5275}, //2875 #CJK UNIFIED IDEOGRAPH
    {0xB3D1, 0x5269}, //2876 #CJK UNIFIED IDEOGRAPH
    {0xB3D2, 0x52DE}, //2877 #CJK UNIFIED IDEOGRAPH
    {0xB3D3, 0x52DD}, //2878 #CJK UNIFIED IDEOGRAPH
    {0xB3D4, 0x52DB}, //2879 #CJK UNIFIED IDEOGRAPH
    {0xB3D5, 0x535A}, //2880 #CJK UNIFIED IDEOGRAPH
    {0xB3D6, 0x53A5}, //2881 #CJK UNIFIED IDEOGRAPH
    {0xB3D7, 0x557B}, //2882 #CJK UNIFIED IDEOGRAPH
    {0xB3D8, 0x5580}, //2883 #CJK UNIFIED IDEOGRAPH
    {0xB3D9, 0x55A7}, //2884 #CJK UNIFIED IDEOGRAPH
    {0xB3DA, 0x557C}, //2885 #CJK UNIFIED IDEOGRAPH
    {0xB3DB, 0x558A}, //2886 #CJK UNIFIED IDEOGRAPH
    {0xB3DC, 0x559D}, //2887 #CJK UNIFIED IDEOGRAPH
    {0xB3DD, 0x5598}, //2888 #CJK UNIFIED IDEOGRAPH
    {0xB3DE, 0x5582}, //2889 #CJK UNIFIED IDEOGRAPH
    {0xB3DF, 0x559C}, //2890 #CJK UNIFIED IDEOGRAPH
    {0xB3E0, 0x55AA}, //2891 #CJK UNIFIED IDEOGRAPH
    {0xB3E1, 0x5594}, //2892 #CJK UNIFIED IDEOGRAPH
    {0xB3E2, 0x5587}, //2893 #CJK UNIFIED IDEOGRAPH
    {0xB3E3, 0x558B}, //2894 #CJK UNIFIED IDEOGRAPH
    {0xB3E4, 0x5583}, //2895 #CJK UNIFIED IDEOGRAPH
    {0xB3E5, 0x55B3}, //2896 #CJK UNIFIED IDEOGRAPH
    {0xB3E6, 0x55AE}, //2897 #CJK UNIFIED IDEOGRAPH
    {0xB3E7, 0x559F}, //2898 #CJK UNIFIED IDEOGRAPH
    {0xB3E8, 0x553E}, //2899 #CJK UNIFIED IDEOGRAPH
    {0xB3E9, 0x55B2}, //2900 #CJK UNIFIED IDEOGRAPH
    {0xB3EA, 0x559A}, //2901 #CJK UNIFIED IDEOGRAPH
    {0xB3EB, 0x55BB}, //2902 #CJK UNIFIED IDEOGRAPH
    {0xB3EC, 0x55AC}, //2903 #CJK UNIFIED IDEOGRAPH
    {0xB3ED, 0x55B1}, //2904 #CJK UNIFIED IDEOGRAPH
    {0xB3EE, 0x557E}, //2905 #CJK UNIFIED IDEOGRAPH
    {0xB3EF, 0x5589}, //2906 #CJK UNIFIED IDEOGRAPH
    {0xB3F0, 0x55AB}, //2907 #CJK UNIFIED IDEOGRAPH
    {0xB3F1, 0x5599}, //2908 #CJK UNIFIED IDEOGRAPH
    {0xB3F2, 0x570D}, //2909 #CJK UNIFIED IDEOGRAPH
    {0xB3F3, 0x582F}, //2910 #CJK UNIFIED IDEOGRAPH
    {0xB3F4, 0x582A}, //2911 #CJK UNIFIED IDEOGRAPH
    {0xB3F5, 0x5834}, //2912 #CJK UNIFIED IDEOGRAPH
    {0xB3F6, 0x5824}, //2913 #CJK UNIFIED IDEOGRAPH
    {0xB3F7, 0x5830}, //2914 #CJK UNIFIED IDEOGRAPH
    {0xB3F8, 0x5831}, //2915 #CJK UNIFIED IDEOGRAPH
    {0xB3F9, 0x5821}, //2916 #CJK UNIFIED IDEOGRAPH
    {0xB3FA, 0x581D}, //2917 #CJK UNIFIED IDEOGRAPH
    {0xB3FB, 0x5820}, //2918 #CJK UNIFIED IDEOGRAPH
    {0xB3FC, 0x58F9}, //2919 #CJK UNIFIED IDEOGRAPH
    {0xB3FD, 0x58FA}, //2920 #CJK UNIFIED IDEOGRAPH
    {0xB3FE, 0x5960}, //2921 #CJK UNIFIED IDEOGRAPH
    {0xB440, 0x5A77}, //2922 #CJK UNIFIED IDEOGRAPH
    {0xB441, 0x5A9A}, //2923 #CJK UNIFIED IDEOGRAPH
    {0xB442, 0x5A7F}, //2924 #CJK UNIFIED IDEOGRAPH
    {0xB443, 0x5A92}, //2925 #CJK UNIFIED IDEOGRAPH
    {0xB444, 0x5A9B}, //2926 #CJK UNIFIED IDEOGRAPH
    {0xB445, 0x5AA7}, //2927 #CJK UNIFIED IDEOGRAPH
    {0xB446, 0x5B73}, //2928 #CJK UNIFIED IDEOGRAPH
    {0xB447, 0x5B71}, //2929 #CJK UNIFIED IDEOGRAPH
    {0xB448, 0x5BD2}, //2930 #CJK UNIFIED IDEOGRAPH
    {0xB449, 0x5BCC}, //2931 #CJK UNIFIED IDEOGRAPH
    {0xB44A, 0x5BD3}, //2932 #CJK UNIFIED IDEOGRAPH
    {0xB44B, 0x5BD0}, //2933 #CJK UNIFIED IDEOGRAPH
    {0xB44C, 0x5C0A}, //2934 #CJK UNIFIED IDEOGRAPH
    {0xB44D, 0x5C0B}, //2935 #CJK UNIFIED IDEOGRAPH
    {0xB44E, 0x5C31}, //2936 #CJK UNIFIED IDEOGRAPH
    {0xB44F, 0x5D4C}, //2937 #CJK UNIFIED IDEOGRAPH
    {0xB450, 0x5D50}, //2938 #CJK UNIFIED IDEOGRAPH
    {0xB451, 0x5D34}, //2939 #CJK UNIFIED IDEOGRAPH
    {0xB452, 0x5D47}, //2940 #CJK UNIFIED IDEOGRAPH
    {0xB453, 0x5DFD}, //2941 #CJK UNIFIED IDEOGRAPH
    {0xB454, 0x5E45}, //2942 #CJK UNIFIED IDEOGRAPH
    {0xB455, 0x5E3D}, //2943 #CJK UNIFIED IDEOGRAPH
    {0xB456, 0x5E40}, //2944 #CJK UNIFIED IDEOGRAPH
    {0xB457, 0x5E43}, //2945 #CJK UNIFIED IDEOGRAPH
    {0xB458, 0x5E7E}, //2946 #CJK UNIFIED IDEOGRAPH
    {0xB459, 0x5ECA}, //2947 #CJK UNIFIED IDEOGRAPH
    {0xB45A, 0x5EC1}, //2948 #CJK UNIFIED IDEOGRAPH
    {0xB45B, 0x5EC2}, //2949 #CJK UNIFIED IDEOGRAPH
    {0xB45C, 0x5EC4}, //2950 #CJK UNIFIED IDEOGRAPH
    {0xB45D, 0x5F3C}, //2951 #CJK UNIFIED IDEOGRAPH
    {0xB45E, 0x5F6D}, //2952 #CJK UNIFIED IDEOGRAPH
    {0xB45F, 0x5FA9}, //2953 #CJK UNIFIED IDEOGRAPH
    {0xB460, 0x5FAA}, //2954 #CJK UNIFIED IDEOGRAPH
    {0xB461, 0x5FA8}, //2955 #CJK UNIFIED IDEOGRAPH
    {0xB462, 0x60D1}, //2956 #CJK UNIFIED IDEOGRAPH
    {0xB463, 0x60E1}, //2957 #CJK UNIFIED IDEOGRAPH
    {0xB464, 0x60B2}, //2958 #CJK UNIFIED IDEOGRAPH
    {0xB465, 0x60B6}, //2959 #CJK UNIFIED IDEOGRAPH
    {0xB466, 0x60E0}, //2960 #CJK UNIFIED IDEOGRAPH
    {0xB467, 0x611C}, //2961 #CJK UNIFIED IDEOGRAPH
    {0xB468, 0x6123}, //2962 #CJK UNIFIED IDEOGRAPH
    {0xB469, 0x60FA}, //2963 #CJK UNIFIED IDEOGRAPH
    {0xB46A, 0x6115}, //2964 #CJK UNIFIED IDEOGRAPH
    {0xB46B, 0x60F0}, //2965 #CJK UNIFIED IDEOGRAPH
    {0xB46C, 0x60FB}, //2966 #CJK UNIFIED IDEOGRAPH
    {0xB46D, 0x60F4}, //2967 #CJK UNIFIED IDEOGRAPH
    {0xB46E, 0x6168}, //2968 #CJK UNIFIED IDEOGRAPH
    {0xB46F, 0x60F1}, //2969 #CJK UNIFIED IDEOGRAPH
    {0xB470, 0x610E}, //2970 #CJK UNIFIED IDEOGRAPH
    {0xB471, 0x60F6}, //2971 #CJK UNIFIED IDEOGRAPH
    {0xB472, 0x6109}, //2972 #CJK UNIFIED IDEOGRAPH
    {0xB473, 0x6100}, //2973 #CJK UNIFIED IDEOGRAPH
    {0xB474, 0x6112}, //2974 #CJK UNIFIED IDEOGRAPH
    {0xB475, 0x621F}, //2975 #CJK UNIFIED IDEOGRAPH
    {0xB476, 0x6249}, //2976 #CJK UNIFIED IDEOGRAPH
    {0xB477, 0x63A3}, //2977 #CJK UNIFIED IDEOGRAPH
    {0xB478, 0x638C}, //2978 #CJK UNIFIED IDEOGRAPH
    {0xB479, 0x63CF}, //2979 #CJK UNIFIED IDEOGRAPH
    {0xB47A, 0x63C0}, //2980 #CJK UNIFIED IDEOGRAPH
    {0xB47B, 0x63E9}, //2981 #CJK UNIFIED IDEOGRAPH
    {0xB47C, 0x63C9}, //2982 #CJK UNIFIED IDEOGRAPH
    {0xB47D, 0x63C6}, //2983 #CJK UNIFIED IDEOGRAPH
    {0xB47E, 0x63CD}, //2984 #CJK UNIFIED IDEOGRAPH
    {0xB4A1, 0x63D2}, //2985 #CJK UNIFIED IDEOGRAPH
    {0xB4A2, 0x63E3}, //2986 #CJK UNIFIED IDEOGRAPH
    {0xB4A3, 0x63D0}, //2987 #CJK UNIFIED IDEOGRAPH
    {0xB4A4, 0x63E1}, //2988 #CJK UNIFIED IDEOGRAPH
    {0xB4A5, 0x63D6}, //2989 #CJK UNIFIED IDEOGRAPH
    {0xB4A6, 0x63ED}, //2990 #CJK UNIFIED IDEOGRAPH
    {0xB4A7, 0x63EE}, //2991 #CJK UNIFIED IDEOGRAPH
    {0xB4A8, 0x6376}, //2992 #CJK UNIFIED IDEOGRAPH
    {0xB4A9, 0x63F4}, //2993 #CJK UNIFIED IDEOGRAPH
    {0xB4AA, 0x63EA}, //2994 #CJK UNIFIED IDEOGRAPH
    {0xB4AB, 0x63DB}, //2995 #CJK UNIFIED IDEOGRAPH
    {0xB4AC, 0x6452}, //2996 #CJK UNIFIED IDEOGRAPH
    {0xB4AD, 0x63DA}, //2997 #CJK UNIFIED IDEOGRAPH
    {0xB4AE, 0x63F9}, //2998 #CJK UNIFIED IDEOGRAPH
    {0xB4AF, 0x655E}, //2999 #CJK UNIFIED IDEOGRAPH
    {0xB4B0, 0x6566}, //3000 #CJK UNIFIED IDEOGRAPH
    {0xB4B1, 0x6562}, //3001 #CJK UNIFIED IDEOGRAPH
    {0xB4B2, 0x6563}, //3002 #CJK UNIFIED IDEOGRAPH
    {0xB4B3, 0x6591}, //3003 #CJK UNIFIED IDEOGRAPH
    {0xB4B4, 0x6590}, //3004 #CJK UNIFIED IDEOGRAPH
    {0xB4B5, 0x65AF}, //3005 #CJK UNIFIED IDEOGRAPH
    {0xB4B6, 0x666E}, //3006 #CJK UNIFIED IDEOGRAPH
    {0xB4B7, 0x6670}, //3007 #CJK UNIFIED IDEOGRAPH
    {0xB4B8, 0x6674}, //3008 #CJK UNIFIED IDEOGRAPH
    {0xB4B9, 0x6676}, //3009 #CJK UNIFIED IDEOGRAPH
    {0xB4BA, 0x666F}, //3010 #CJK UNIFIED IDEOGRAPH
    {0xB4BB, 0x6691}, //3011 #CJK UNIFIED IDEOGRAPH
    {0xB4BC, 0x667A}, //3012 #CJK UNIFIED IDEOGRAPH
    {0xB4BD, 0x667E}, //3013 #CJK UNIFIED IDEOGRAPH
    {0xB4BE, 0x6677}, //3014 #CJK UNIFIED IDEOGRAPH
    {0xB4BF, 0x66FE}, //3015 #CJK UNIFIED IDEOGRAPH
    {0xB4C0, 0x66FF}, //3016 #CJK UNIFIED IDEOGRAPH
    {0xB4C1, 0x671F}, //3017 #CJK UNIFIED IDEOGRAPH
    {0xB4C2, 0x671D}, //3018 #CJK UNIFIED IDEOGRAPH
    {0xB4C3, 0x68FA}, //3019 #CJK UNIFIED IDEOGRAPH
    {0xB4C4, 0x68D5}, //3020 #CJK UNIFIED IDEOGRAPH
    {0xB4C5, 0x68E0}, //3021 #CJK UNIFIED IDEOGRAPH
    {0xB4C6, 0x68D8}, //3022 #CJK UNIFIED IDEOGRAPH
    {0xB4C7, 0x68D7}, //3023 #CJK UNIFIED IDEOGRAPH
    {0xB4C8, 0x6905}, //3024 #CJK UNIFIED IDEOGRAPH
    {0xB4C9, 0x68DF}, //3025 #CJK UNIFIED IDEOGRAPH
    {0xB4CA, 0x68F5}, //3026 #CJK UNIFIED IDEOGRAPH
    {0xB4CB, 0x68EE}, //3027 #CJK UNIFIED IDEOGRAPH
    {0xB4CC, 0x68E7}, //3028 #CJK UNIFIED IDEOGRAPH
    {0xB4CD, 0x68F9}, //3029 #CJK UNIFIED IDEOGRAPH
    {0xB4CE, 0x68D2}, //3030 #CJK UNIFIED IDEOGRAPH
    {0xB4CF, 0x68F2}, //3031 #CJK UNIFIED IDEOGRAPH
    {0xB4D0, 0x68E3}, //3032 #CJK UNIFIED IDEOGRAPH
    {0xB4D1, 0x68CB}, //3033 #CJK UNIFIED IDEOGRAPH
    {0xB4D2, 0x68CD}, //3034 #CJK UNIFIED IDEOGRAPH
    {0xB4D3, 0x690D}, //3035 #CJK UNIFIED IDEOGRAPH
    {0xB4D4, 0x6912}, //3036 #CJK UNIFIED IDEOGRAPH
    {0xB4D5, 0x690E}, //3037 #CJK UNIFIED IDEOGRAPH
    {0xB4D6, 0x68C9}, //3038 #CJK UNIFIED IDEOGRAPH
    {0xB4D7, 0x68DA}, //3039 #CJK UNIFIED IDEOGRAPH
    {0xB4D8, 0x696E}, //3040 #CJK UNIFIED IDEOGRAPH
    {0xB4D9, 0x68FB}, //3041 #CJK UNIFIED IDEOGRAPH
    {0xB4DA, 0x6B3E}, //3042 #CJK UNIFIED IDEOGRAPH
    {0xB4DB, 0x6B3A}, //3043 #CJK UNIFIED IDEOGRAPH
    {0xB4DC, 0x6B3D}, //3044 #CJK UNIFIED IDEOGRAPH
    {0xB4DD, 0x6B98}, //3045 #CJK UNIFIED IDEOGRAPH
    {0xB4DE, 0x6B96}, //3046 #CJK UNIFIED IDEOGRAPH
    {0xB4DF, 0x6BBC}, //3047 #CJK UNIFIED IDEOGRAPH
    {0xB4E0, 0x6BEF}, //3048 #CJK UNIFIED IDEOGRAPH
    {0xB4E1, 0x6C2E}, //3049 #CJK UNIFIED IDEOGRAPH
    {0xB4E2, 0x6C2F}, //3050 #CJK UNIFIED IDEOGRAPH
    {0xB4E3, 0x6C2C}, //3051 #CJK UNIFIED IDEOGRAPH
    {0xB4E4, 0x6E2F}, //3052 #CJK UNIFIED IDEOGRAPH
    {0xB4E5, 0x6E38}, //3053 #CJK UNIFIED IDEOGRAPH
    {0xB4E6, 0x6E54}, //3054 #CJK UNIFIED IDEOGRAPH
    {0xB4E7, 0x6E21}, //3055 #CJK UNIFIED IDEOGRAPH
    {0xB4E8, 0x6E32}, //3056 #CJK UNIFIED IDEOGRAPH
    {0xB4E9, 0x6E67}, //3057 #CJK UNIFIED IDEOGRAPH
    {0xB4EA, 0x6E4A}, //3058 #CJK UNIFIED IDEOGRAPH
    {0xB4EB, 0x6E20}, //3059 #CJK UNIFIED IDEOGRAPH
    {0xB4EC, 0x6E25}, //3060 #CJK UNIFIED IDEOGRAPH
    {0xB4ED, 0x6E23}, //3061 #CJK UNIFIED IDEOGRAPH
    {0xB4EE, 0x6E1B}, //3062 #CJK UNIFIED IDEOGRAPH
    {0xB4EF, 0x6E5B}, //3063 #CJK UNIFIED IDEOGRAPH
    {0xB4F0, 0x6E58}, //3064 #CJK UNIFIED IDEOGRAPH
    {0xB4F1, 0x6E24}, //3065 #CJK UNIFIED IDEOGRAPH
    {0xB4F2, 0x6E56}, //3066 #CJK UNIFIED IDEOGRAPH
    {0xB4F3, 0x6E6E}, //3067 #CJK UNIFIED IDEOGRAPH
    {0xB4F4, 0x6E2D}, //3068 #CJK UNIFIED IDEOGRAPH
    {0xB4F5, 0x6E26}, //3069 #CJK UNIFIED IDEOGRAPH
    {0xB4F6, 0x6E6F}, //3070 #CJK UNIFIED IDEOGRAPH
    {0xB4F7, 0x6E34}, //3071 #CJK UNIFIED IDEOGRAPH
    {0xB4F8, 0x6E4D}, //3072 #CJK UNIFIED IDEOGRAPH
    {0xB4F9, 0x6E3A}, //3073 #CJK UNIFIED IDEOGRAPH
    {0xB4FA, 0x6E2C}, //3074 #CJK UNIFIED IDEOGRAPH
    {0xB4FB, 0x6E43}, //3075 #CJK UNIFIED IDEOGRAPH
    {0xB4FC, 0x6E1D}, //3076 #CJK UNIFIED IDEOGRAPH
    {0xB4FD, 0x6E3E}, //3077 #CJK UNIFIED IDEOGRAPH
    {0xB4FE, 0x6ECB}, //3078 #CJK UNIFIED IDEOGRAPH
    {0xB540, 0x6E89}, //3079 #CJK UNIFIED IDEOGRAPH
    {0xB541, 0x6E19}, //3080 #CJK UNIFIED IDEOGRAPH
    {0xB542, 0x6E4E}, //3081 #CJK UNIFIED IDEOGRAPH
    {0xB543, 0x6E63}, //3082 #CJK UNIFIED IDEOGRAPH
    {0xB544, 0x6E44}, //3083 #CJK UNIFIED IDEOGRAPH
    {0xB545, 0x6E72}, //3084 #CJK UNIFIED IDEOGRAPH
    {0xB546, 0x6E69}, //3085 #CJK UNIFIED IDEOGRAPH
    {0xB547, 0x6E5F}, //3086 #CJK UNIFIED IDEOGRAPH
    {0xB548, 0x7119}, //3087 #CJK UNIFIED IDEOGRAPH
    {0xB549, 0x711A}, //3088 #CJK UNIFIED IDEOGRAPH
    {0xB54A, 0x7126}, //3089 #CJK UNIFIED IDEOGRAPH
    {0xB54B, 0x7130}, //3090 #CJK UNIFIED IDEOGRAPH
    {0xB54C, 0x7121}, //3091 #CJK UNIFIED IDEOGRAPH
    {0xB54D, 0x7136}, //3092 #CJK UNIFIED IDEOGRAPH
    {0xB54E, 0x716E}, //3093 #CJK UNIFIED IDEOGRAPH
    {0xB54F, 0x711C}, //3094 #CJK UNIFIED IDEOGRAPH
    {0xB550, 0x724C}, //3095 #CJK UNIFIED IDEOGRAPH
    {0xB551, 0x7284}, //3096 #CJK UNIFIED IDEOGRAPH
    {0xB552, 0x7280}, //3097 #CJK UNIFIED IDEOGRAPH
    {0xB553, 0x7336}, //3098 #CJK UNIFIED IDEOGRAPH
    {0xB554, 0x7325}, //3099 #CJK UNIFIED IDEOGRAPH
    {0xB555, 0x7334}, //3100 #CJK UNIFIED IDEOGRAPH
    {0xB556, 0x7329}, //3101 #CJK UNIFIED IDEOGRAPH
    {0xB557, 0x743A}, //3102 #CJK UNIFIED IDEOGRAPH
    {0xB558, 0x742A}, //3103 #CJK UNIFIED IDEOGRAPH
    {0xB559, 0x7433}, //3104 #CJK UNIFIED IDEOGRAPH
    {0xB55A, 0x7422}, //3105 #CJK UNIFIED IDEOGRAPH
    {0xB55B, 0x7425}, //3106 #CJK UNIFIED IDEOGRAPH
    {0xB55C, 0x7435}, //3107 #CJK UNIFIED IDEOGRAPH
    {0xB55D, 0x7436}, //3108 #CJK UNIFIED IDEOGRAPH
    {0xB55E, 0x7434}, //3109 #CJK UNIFIED IDEOGRAPH
    {0xB55F, 0x742F}, //3110 #CJK UNIFIED IDEOGRAPH
    {0xB560, 0x741B}, //3111 #CJK UNIFIED IDEOGRAPH
    {0xB561, 0x7426}, //3112 #CJK UNIFIED IDEOGRAPH
    {0xB562, 0x7428}, //3113 #CJK UNIFIED IDEOGRAPH
    {0xB563, 0x7525}, //3114 #CJK UNIFIED IDEOGRAPH
    {0xB564, 0x7526}, //3115 #CJK UNIFIED IDEOGRAPH
    {0xB565, 0x756B}, //3116 #CJK UNIFIED IDEOGRAPH
    {0xB566, 0x756A}, //3117 #CJK UNIFIED IDEOGRAPH
    {0xB567, 0x75E2}, //3118 #CJK UNIFIED IDEOGRAPH
    {0xB568, 0x75DB}, //3119 #CJK UNIFIED IDEOGRAPH
    {0xB569, 0x75E3}, //3120 #CJK UNIFIED IDEOGRAPH
    {0xB56A, 0x75D9}, //3121 #CJK UNIFIED IDEOGRAPH
    {0xB56B, 0x75D8}, //3122 #CJK UNIFIED IDEOGRAPH
    {0xB56C, 0x75DE}, //3123 #CJK UNIFIED IDEOGRAPH
    {0xB56D, 0x75E0}, //3124 #CJK UNIFIED IDEOGRAPH
    {0xB56E, 0x767B}, //3125 #CJK UNIFIED IDEOGRAPH
    {0xB56F, 0x767C}, //3126 #CJK UNIFIED IDEOGRAPH
    {0xB570, 0x7696}, //3127 #CJK UNIFIED IDEOGRAPH
    {0xB571, 0x7693}, //3128 #CJK UNIFIED IDEOGRAPH
    {0xB572, 0x76B4}, //3129 #CJK UNIFIED IDEOGRAPH
    {0xB573, 0x76DC}, //3130 #CJK UNIFIED IDEOGRAPH
    {0xB574, 0x774F}, //3131 #CJK UNIFIED IDEOGRAPH
    {0xB575, 0x77ED}, //3132 #CJK UNIFIED IDEOGRAPH
    {0xB576, 0x785D}, //3133 #CJK UNIFIED IDEOGRAPH
    {0xB577, 0x786C}, //3134 #CJK UNIFIED IDEOGRAPH
    {0xB578, 0x786F}, //3135 #CJK UNIFIED IDEOGRAPH
    {0xB579, 0x7A0D}, //3136 #CJK UNIFIED IDEOGRAPH
    {0xB57A, 0x7A08}, //3137 #CJK UNIFIED IDEOGRAPH
    {0xB57B, 0x7A0B}, //3138 #CJK UNIFIED IDEOGRAPH
    {0xB57C, 0x7A05}, //3139 #CJK UNIFIED IDEOGRAPH
    {0xB57D, 0x7A00}, //3140 #CJK UNIFIED IDEOGRAPH
    {0xB57E, 0x7A98}, //3141 #CJK UNIFIED IDEOGRAPH
    {0xB5A1, 0x7A97}, //3142 #CJK UNIFIED IDEOGRAPH
    {0xB5A2, 0x7A96}, //3143 #CJK UNIFIED IDEOGRAPH
    {0xB5A3, 0x7AE5}, //3144 #CJK UNIFIED IDEOGRAPH
    {0xB5A4, 0x7AE3}, //3145 #CJK UNIFIED IDEOGRAPH
    {0xB5A5, 0x7B49}, //3146 #CJK UNIFIED IDEOGRAPH
    {0xB5A6, 0x7B56}, //3147 #CJK UNIFIED IDEOGRAPH
    {0xB5A7, 0x7B46}, //3148 #CJK UNIFIED IDEOGRAPH
    {0xB5A8, 0x7B50}, //3149 #CJK UNIFIED IDEOGRAPH
    {0xB5A9, 0x7B52}, //3150 #CJK UNIFIED IDEOGRAPH
    {0xB5AA, 0x7B54}, //3151 #CJK UNIFIED IDEOGRAPH
    {0xB5AB, 0x7B4D}, //3152 #CJK UNIFIED IDEOGRAPH
    {0xB5AC, 0x7B4B}, //3153 #CJK UNIFIED IDEOGRAPH
    {0xB5AD, 0x7B4F}, //3154 #CJK UNIFIED IDEOGRAPH
    {0xB5AE, 0x7B51}, //3155 #CJK UNIFIED IDEOGRAPH
    {0xB5AF, 0x7C9F}, //3156 #CJK UNIFIED IDEOGRAPH
    {0xB5B0, 0x7CA5}, //3157 #CJK UNIFIED IDEOGRAPH
    {0xB5B1, 0x7D5E}, //3158 #CJK UNIFIED IDEOGRAPH
    {0xB5B2, 0x7D50}, //3159 #CJK UNIFIED IDEOGRAPH
    {0xB5B3, 0x7D68}, //3160 #CJK UNIFIED IDEOGRAPH
    {0xB5B4, 0x7D55}, //3161 #CJK UNIFIED IDEOGRAPH
    {0xB5B5, 0x7D2B}, //3162 #CJK UNIFIED IDEOGRAPH
    {0xB5B6, 0x7D6E}, //3163 #CJK UNIFIED IDEOGRAPH
    {0xB5B7, 0x7D72}, //3164 #CJK UNIFIED IDEOGRAPH
    {0xB5B8, 0x7D61}, //3165 #CJK UNIFIED IDEOGRAPH
    {0xB5B9, 0x7D66}, //3166 #CJK UNIFIED IDEOGRAPH
    {0xB5BA, 0x7D62}, //3167 #CJK UNIFIED IDEOGRAPH
    {0xB5BB, 0x7D70}, //3168 #CJK UNIFIED IDEOGRAPH
    {0xB5BC, 0x7D73}, //3169 #CJK UNIFIED IDEOGRAPH
    {0xB5BD, 0x5584}, //3170 #CJK UNIFIED IDEOGRAPH
    {0xB5BE, 0x7FD4}, //3171 #CJK UNIFIED IDEOGRAPH
    {0xB5BF, 0x7FD5}, //3172 #CJK UNIFIED IDEOGRAPH
    {0xB5C0, 0x800B}, //3173 #CJK UNIFIED IDEOGRAPH
    {0xB5C1, 0x8052}, //3174 #CJK UNIFIED IDEOGRAPH
    {0xB5C2, 0x8085}, //3175 #CJK UNIFIED IDEOGRAPH
    {0xB5C3, 0x8155}, //3176 #CJK UNIFIED IDEOGRAPH
    {0xB5C4, 0x8154}, //3177 #CJK UNIFIED IDEOGRAPH
    {0xB5C5, 0x814B}, //3178 #CJK UNIFIED IDEOGRAPH
    {0xB5C6, 0x8151}, //3179 #CJK UNIFIED IDEOGRAPH
    {0xB5C7, 0x814E}, //3180 #CJK UNIFIED IDEOGRAPH
    {0xB5C8, 0x8139}, //3181 #CJK UNIFIED IDEOGRAPH
    {0xB5C9, 0x8146}, //3182 #CJK UNIFIED IDEOGRAPH
    {0xB5CA, 0x813E}, //3183 #CJK UNIFIED IDEOGRAPH
    {0xB5CB, 0x814C}, //3184 #CJK UNIFIED IDEOGRAPH
    {0xB5CC, 0x8153}, //3185 #CJK UNIFIED IDEOGRAPH
    {0xB5CD, 0x8174}, //3186 #CJK UNIFIED IDEOGRAPH
    {0xB5CE, 0x8212}, //3187 #CJK UNIFIED IDEOGRAPH
    {0xB5CF, 0x821C}, //3188 #CJK UNIFIED IDEOGRAPH
    {0xB5D0, 0x83E9}, //3189 #CJK UNIFIED IDEOGRAPH
    {0xB5D1, 0x8403}, //3190 #CJK UNIFIED IDEOGRAPH
    {0xB5D2, 0x83F8}, //3191 #CJK UNIFIED IDEOGRAPH
    {0xB5D3, 0x840D}, //3192 #CJK UNIFIED IDEOGRAPH
    {0xB5D4, 0x83E0}, //3193 #CJK UNIFIED IDEOGRAPH
    {0xB5D5, 0x83C5}, //3194 #CJK UNIFIED IDEOGRAPH
    {0xB5D6, 0x840B}, //3195 #CJK UNIFIED IDEOGRAPH
    {0xB5D7, 0x83C1}, //3196 #CJK UNIFIED IDEOGRAPH
    {0xB5D8, 0x83EF}, //3197 #CJK UNIFIED IDEOGRAPH
    {0xB5D9, 0x83F1}, //3198 #CJK UNIFIED IDEOGRAPH
    {0xB5DA, 0x83F4}, //3199 #CJK UNIFIED IDEOGRAPH
    {0xB5DB, 0x8457}, //3200 #CJK UNIFIED IDEOGRAPH
    {0xB5DC, 0x840A}, //3201 #CJK UNIFIED IDEOGRAPH
    {0xB5DD, 0x83F0}, //3202 #CJK UNIFIED IDEOGRAPH
    {0xB5DE, 0x840C}, //3203 #CJK UNIFIED IDEOGRAPH
    {0xB5DF, 0x83CC}, //3204 #CJK UNIFIED IDEOGRAPH
    {0xB5E0, 0x83FD}, //3205 #CJK UNIFIED IDEOGRAPH
    {0xB5E1, 0x83F2}, //3206 #CJK UNIFIED IDEOGRAPH
    {0xB5E2, 0x83CA}, //3207 #CJK UNIFIED IDEOGRAPH
    {0xB5E3, 0x8438}, //3208 #CJK UNIFIED IDEOGRAPH
    {0xB5E4, 0x840E}, //3209 #CJK UNIFIED IDEOGRAPH
    {0xB5E5, 0x8404}, //3210 #CJK UNIFIED IDEOGRAPH
    {0xB5E6, 0x83DC}, //3211 #CJK UNIFIED IDEOGRAPH
    {0xB5E7, 0x8407}, //3212 #CJK UNIFIED IDEOGRAPH
    {0xB5E8, 0x83D4}, //3213 #CJK UNIFIED IDEOGRAPH
    {0xB5E9, 0x83DF}, //3214 #CJK UNIFIED IDEOGRAPH
    {0xB5EA, 0x865B}, //3215 #CJK UNIFIED IDEOGRAPH
    {0xB5EB, 0x86DF}, //3216 #CJK UNIFIED IDEOGRAPH
    {0xB5EC, 0x86D9}, //3217 #CJK UNIFIED IDEOGRAPH
    {0xB5ED, 0x86ED}, //3218 #CJK UNIFIED IDEOGRAPH
    {0xB5EE, 0x86D4}, //3219 #CJK UNIFIED IDEOGRAPH
    {0xB5EF, 0x86DB}, //3220 #CJK UNIFIED IDEOGRAPH
    {0xB5F0, 0x86E4}, //3221 #CJK UNIFIED IDEOGRAPH
    {0xB5F1, 0x86D0}, //3222 #CJK UNIFIED IDEOGRAPH
    {0xB5F2, 0x86DE}, //3223 #CJK UNIFIED IDEOGRAPH
    {0xB5F3, 0x8857}, //3224 #CJK UNIFIED IDEOGRAPH
    {0xB5F4, 0x88C1}, //3225 #CJK UNIFIED IDEOGRAPH
    {0xB5F5, 0x88C2}, //3226 #CJK UNIFIED IDEOGRAPH
    {0xB5F6, 0x88B1}, //3227 #CJK UNIFIED IDEOGRAPH
    {0xB5F7, 0x8983}, //3228 #CJK UNIFIED IDEOGRAPH
    {0xB5F8, 0x8996}, //3229 #CJK UNIFIED IDEOGRAPH
    {0xB5F9, 0x8A3B}, //3230 #CJK UNIFIED IDEOGRAPH
    {0xB5FA, 0x8A60}, //3231 #CJK UNIFIED IDEOGRAPH
    {0xB5FB, 0x8A55}, //3232 #CJK UNIFIED IDEOGRAPH
    {0xB5FC, 0x8A5E}, //3233 #CJK UNIFIED IDEOGRAPH
    {0xB5FD, 0x8A3C}, //3234 #CJK UNIFIED IDEOGRAPH
    {0xB5FE, 0x8A41}, //3235 #CJK UNIFIED IDEOGRAPH
    {0xB640, 0x8A54}, //3236 #CJK UNIFIED IDEOGRAPH
    {0xB641, 0x8A5B}, //3237 #CJK UNIFIED IDEOGRAPH
    {0xB642, 0x8A50}, //3238 #CJK UNIFIED IDEOGRAPH
    {0xB643, 0x8A46}, //3239 #CJK UNIFIED IDEOGRAPH
    {0xB644, 0x8A34}, //3240 #CJK UNIFIED IDEOGRAPH
    {0xB645, 0x8A3A}, //3241 #CJK UNIFIED IDEOGRAPH
    {0xB646, 0x8A36}, //3242 #CJK UNIFIED IDEOGRAPH
    {0xB647, 0x8A56}, //3243 #CJK UNIFIED IDEOGRAPH
    {0xB648, 0x8C61}, //3244 #CJK UNIFIED IDEOGRAPH
    {0xB649, 0x8C82}, //3245 #CJK UNIFIED IDEOGRAPH
    {0xB64A, 0x8CAF}, //3246 #CJK UNIFIED IDEOGRAPH
    {0xB64B, 0x8CBC}, //3247 #CJK UNIFIED IDEOGRAPH
    {0xB64C, 0x8CB3}, //3248 #CJK UNIFIED IDEOGRAPH
    {0xB64D, 0x8CBD}, //3249 #CJK UNIFIED IDEOGRAPH
    {0xB64E, 0x8CC1}, //3250 #CJK UNIFIED IDEOGRAPH
    {0xB64F, 0x8CBB}, //3251 #CJK UNIFIED IDEOGRAPH
    {0xB650, 0x8CC0}, //3252 #CJK UNIFIED IDEOGRAPH
    {0xB651, 0x8CB4}, //3253 #CJK UNIFIED IDEOGRAPH
    {0xB652, 0x8CB7}, //3254 #CJK UNIFIED IDEOGRAPH
    {0xB653, 0x8CB6}, //3255 #CJK UNIFIED IDEOGRAPH
    {0xB654, 0x8CBF}, //3256 #CJK UNIFIED IDEOGRAPH
    {0xB655, 0x8CB8}, //3257 #CJK UNIFIED IDEOGRAPH
    {0xB656, 0x8D8A}, //3258 #CJK UNIFIED IDEOGRAPH
    {0xB657, 0x8D85}, //3259 #CJK UNIFIED IDEOGRAPH
    {0xB658, 0x8D81}, //3260 #CJK UNIFIED IDEOGRAPH
    {0xB659, 0x8DCE}, //3261 #CJK UNIFIED IDEOGRAPH
    {0xB65A, 0x8DDD}, //3262 #CJK UNIFIED IDEOGRAPH
    {0xB65B, 0x8DCB}, //3263 #CJK UNIFIED IDEOGRAPH
    {0xB65C, 0x8DDA}, //3264 #CJK UNIFIED IDEOGRAPH
    {0xB65D, 0x8DD1}, //3265 #CJK UNIFIED IDEOGRAPH
    {0xB65E, 0x8DCC}, //3266 #CJK UNIFIED IDEOGRAPH
    {0xB65F, 0x8DDB}, //3267 #CJK UNIFIED IDEOGRAPH
    {0xB660, 0x8DC6}, //3268 #CJK UNIFIED IDEOGRAPH
    {0xB661, 0x8EFB}, //3269 #CJK UNIFIED IDEOGRAPH
    {0xB662, 0x8EF8}, //3270 #CJK UNIFIED IDEOGRAPH
    {0xB663, 0x8EFC}, //3271 #CJK UNIFIED IDEOGRAPH
    {0xB664, 0x8F9C}, //3272 #CJK UNIFIED IDEOGRAPH
    {0xB665, 0x902E}, //3273 #CJK UNIFIED IDEOGRAPH
    {0xB666, 0x9035}, //3274 #CJK UNIFIED IDEOGRAPH
    {0xB667, 0x9031}, //3275 #CJK UNIFIED IDEOGRAPH
    {0xB668, 0x9038}, //3276 #CJK UNIFIED IDEOGRAPH
    {0xB669, 0x9032}, //3277 #CJK UNIFIED IDEOGRAPH
    {0xB66A, 0x9036}, //3278 #CJK UNIFIED IDEOGRAPH
    {0xB66B, 0x9102}, //3279 #CJK UNIFIED IDEOGRAPH
    {0xB66C, 0x90F5}, //3280 #CJK UNIFIED IDEOGRAPH
    {0xB66D, 0x9109}, //3281 #CJK UNIFIED IDEOGRAPH
    {0xB66E, 0x90FE}, //3282 #CJK UNIFIED IDEOGRAPH
    {0xB66F, 0x9163}, //3283 #CJK UNIFIED IDEOGRAPH
    {0xB670, 0x9165}, //3284 #CJK UNIFIED IDEOGRAPH
    {0xB671, 0x91CF}, //3285 #CJK UNIFIED IDEOGRAPH
    {0xB672, 0x9214}, //3286 #CJK UNIFIED IDEOGRAPH
    {0xB673, 0x9215}, //3287 #CJK UNIFIED IDEOGRAPH
    {0xB674, 0x9223}, //3288 #CJK UNIFIED IDEOGRAPH
    {0xB675, 0x9209}, //3289 #CJK UNIFIED IDEOGRAPH
    {0xB676, 0x921E}, //3290 #CJK UNIFIED IDEOGRAPH
    {0xB677, 0x920D}, //3291 #CJK UNIFIED IDEOGRAPH
    {0xB678, 0x9210}, //3292 #CJK UNIFIED IDEOGRAPH
    {0xB679, 0x9207}, //3293 #CJK UNIFIED IDEOGRAPH
    {0xB67A, 0x9211}, //3294 #CJK UNIFIED IDEOGRAPH
    {0xB67B, 0x9594}, //3295 #CJK UNIFIED IDEOGRAPH
    {0xB67C, 0x958F}, //3296 #CJK UNIFIED IDEOGRAPH
    {0xB67D, 0x958B}, //3297 #CJK UNIFIED IDEOGRAPH
    {0xB67E, 0x9591}, //3298 #CJK UNIFIED IDEOGRAPH
    {0xB6A1, 0x9593}, //3299 #CJK UNIFIED IDEOGRAPH
    {0xB6A2, 0x9592}, //3300 #CJK UNIFIED IDEOGRAPH
    {0xB6A3, 0x958E}, //3301 #CJK UNIFIED IDEOGRAPH
    {0xB6A4, 0x968A}, //3302 #CJK UNIFIED IDEOGRAPH
    {0xB6A5, 0x968E}, //3303 #CJK UNIFIED IDEOGRAPH
    {0xB6A6, 0x968B}, //3304 #CJK UNIFIED IDEOGRAPH
    {0xB6A7, 0x967D}, //3305 #CJK UNIFIED IDEOGRAPH
    {0xB6A8, 0x9685}, //3306 #CJK UNIFIED IDEOGRAPH
    {0xB6A9, 0x9686}, //3307 #CJK UNIFIED IDEOGRAPH
    {0xB6AA, 0x968D}, //3308 #CJK UNIFIED IDEOGRAPH
    {0xB6AB, 0x9672}, //3309 #CJK UNIFIED IDEOGRAPH
    {0xB6AC, 0x9684}, //3310 #CJK UNIFIED IDEOGRAPH
    {0xB6AD, 0x96C1}, //3311 #CJK UNIFIED IDEOGRAPH
    {0xB6AE, 0x96C5}, //3312 #CJK UNIFIED IDEOGRAPH
    {0xB6AF, 0x96C4}, //3313 #CJK UNIFIED IDEOGRAPH
    {0xB6B0, 0x96C6}, //3314 #CJK UNIFIED IDEOGRAPH
    {0xB6B1, 0x96C7}, //3315 #CJK UNIFIED IDEOGRAPH
    {0xB6B2, 0x96EF}, //3316 #CJK UNIFIED IDEOGRAPH
    {0xB6B3, 0x96F2}, //3317 #CJK UNIFIED IDEOGRAPH
    {0xB6B4, 0x97CC}, //3318 #CJK UNIFIED IDEOGRAPH
    {0xB6B5, 0x9805}, //3319 #CJK UNIFIED IDEOGRAPH
    {0xB6B6, 0x9806}, //3320 #CJK UNIFIED IDEOGRAPH
    {0xB6B7, 0x9808}, //3321 #CJK UNIFIED IDEOGRAPH
    {0xB6B8, 0x98E7}, //3322 #CJK UNIFIED IDEOGRAPH
    {0xB6B9, 0x98EA}, //3323 #CJK UNIFIED IDEOGRAPH
    {0xB6BA, 0x98EF}, //3324 #CJK UNIFIED IDEOGRAPH
    {0xB6BB, 0x98E9}, //3325 #CJK UNIFIED IDEOGRAPH
    {0xB6BC, 0x98F2}, //3326 #CJK UNIFIED IDEOGRAPH
    {0xB6BD, 0x98ED}, //3327 #CJK UNIFIED IDEOGRAPH
    {0xB6BE, 0x99AE}, //3328 #CJK UNIFIED IDEOGRAPH
    {0xB6BF, 0x99AD}, //3329 #CJK UNIFIED IDEOGRAPH
    {0xB6C0, 0x9EC3}, //3330 #CJK UNIFIED IDEOGRAPH
    {0xB6C1, 0x9ECD}, //3331 #CJK UNIFIED IDEOGRAPH
    {0xB6C2, 0x9ED1}, //3332 #CJK UNIFIED IDEOGRAPH
    {0xB6C3, 0x4E82}, //3333 #CJK UNIFIED IDEOGRAPH
    {0xB6C4, 0x50AD}, //3334 #CJK UNIFIED IDEOGRAPH
    {0xB6C5, 0x50B5}, //3335 #CJK UNIFIED IDEOGRAPH
    {0xB6C6, 0x50B2}, //3336 #CJK UNIFIED IDEOGRAPH
    {0xB6C7, 0x50B3}, //3337 #CJK UNIFIED IDEOGRAPH
    {0xB6C8, 0x50C5}, //3338 #CJK UNIFIED IDEOGRAPH
    {0xB6C9, 0x50BE}, //3339 #CJK UNIFIED IDEOGRAPH
    {0xB6CA, 0x50AC}, //3340 #CJK UNIFIED IDEOGRAPH
    {0xB6CB, 0x50B7}, //3341 #CJK UNIFIED IDEOGRAPH
    {0xB6CC, 0x50BB}, //3342 #CJK UNIFIED IDEOGRAPH
    {0xB6CD, 0x50AF}, //3343 #CJK UNIFIED IDEOGRAPH
    {0xB6CE, 0x50C7}, //3344 #CJK UNIFIED IDEOGRAPH
    {0xB6CF, 0x527F}, //3345 #CJK UNIFIED IDEOGRAPH
    {0xB6D0, 0x5277}, //3346 #CJK UNIFIED IDEOGRAPH
    {0xB6D1, 0x527D}, //3347 #CJK UNIFIED IDEOGRAPH
    {0xB6D2, 0x52DF}, //3348 #CJK UNIFIED IDEOGRAPH
    {0xB6D3, 0x52E6}, //3349 #CJK UNIFIED IDEOGRAPH
    {0xB6D4, 0x52E4}, //3350 #CJK UNIFIED IDEOGRAPH
    {0xB6D5, 0x52E2}, //3351 #CJK UNIFIED IDEOGRAPH
    {0xB6D6, 0x52E3}, //3352 #CJK UNIFIED IDEOGRAPH
    {0xB6D7, 0x532F}, //3353 #CJK UNIFIED IDEOGRAPH
    {0xB6D8, 0x55DF}, //3354 #CJK UNIFIED IDEOGRAPH
    {0xB6D9, 0x55E8}, //3355 #CJK UNIFIED IDEOGRAPH
    {0xB6DA, 0x55D3}, //3356 #CJK UNIFIED IDEOGRAPH
    {0xB6DB, 0x55E6}, //3357 #CJK UNIFIED IDEOGRAPH
    {0xB6DC, 0x55CE}, //3358 #CJK UNIFIED IDEOGRAPH
    {0xB6DD, 0x55DC}, //3359 #CJK UNIFIED IDEOGRAPH
    {0xB6DE, 0x55C7}, //3360 #CJK UNIFIED IDEOGRAPH
    {0xB6DF, 0x55D1}, //3361 #CJK UNIFIED IDEOGRAPH
    {0xB6E0, 0x55E3}, //3362 #CJK UNIFIED IDEOGRAPH
    {0xB6E1, 0x55E4}, //3363 #CJK UNIFIED IDEOGRAPH
    {0xB6E2, 0x55EF}, //3364 #CJK UNIFIED IDEOGRAPH
    {0xB6E3, 0x55DA}, //3365 #CJK UNIFIED IDEOGRAPH
    {0xB6E4, 0x55E1}, //3366 #CJK UNIFIED IDEOGRAPH
    {0xB6E5, 0x55C5}, //3367 #CJK UNIFIED IDEOGRAPH
    {0xB6E6, 0x55C6}, //3368 #CJK UNIFIED IDEOGRAPH
    {0xB6E7, 0x55E5}, //3369 #CJK UNIFIED IDEOGRAPH
    {0xB6E8, 0x55C9}, //3370 #CJK UNIFIED IDEOGRAPH
    {0xB6E9, 0x5712}, //3371 #CJK UNIFIED IDEOGRAPH
    {0xB6EA, 0x5713}, //3372 #CJK UNIFIED IDEOGRAPH
    {0xB6EB, 0x585E}, //3373 #CJK UNIFIED IDEOGRAPH
    {0xB6EC, 0x5851}, //3374 #CJK UNIFIED IDEOGRAPH
    {0xB6ED, 0x5858}, //3375 #CJK UNIFIED IDEOGRAPH
    {0xB6EE, 0x5857}, //3376 #CJK UNIFIED IDEOGRAPH
    {0xB6EF, 0x585A}, //3377 #CJK UNIFIED IDEOGRAPH
    {0xB6F0, 0x5854}, //3378 #CJK UNIFIED IDEOGRAPH
    {0xB6F1, 0x586B}, //3379 #CJK UNIFIED IDEOGRAPH
    {0xB6F2, 0x584C}, //3380 #CJK UNIFIED IDEOGRAPH
    {0xB6F3, 0x586D}, //3381 #CJK UNIFIED IDEOGRAPH
    {0xB6F4, 0x584A}, //3382 #CJK UNIFIED IDEOGRAPH
    {0xB6F5, 0x5862}, //3383 #CJK UNIFIED IDEOGRAPH
    {0xB6F6, 0x5852}, //3384 #CJK UNIFIED IDEOGRAPH
    {0xB6F7, 0x584B}, //3385 #CJK UNIFIED IDEOGRAPH
    {0xB6F8, 0x5967}, //3386 #CJK UNIFIED IDEOGRAPH
    {0xB6F9, 0x5AC1}, //3387 #CJK UNIFIED IDEOGRAPH
    {0xB6FA, 0x5AC9}, //3388 #CJK UNIFIED IDEOGRAPH
    {0xB6FB, 0x5ACC}, //3389 #CJK UNIFIED IDEOGRAPH
    {0xB6FC, 0x5ABE}, //3390 #CJK UNIFIED IDEOGRAPH
    {0xB6FD, 0x5ABD}, //3391 #CJK UNIFIED IDEOGRAPH
    {0xB6FE, 0x5ABC}, //3392 #CJK UNIFIED IDEOGRAPH
    {0xB740, 0x5AB3}, //3393 #CJK UNIFIED IDEOGRAPH
    {0xB741, 0x5AC2}, //3394 #CJK UNIFIED IDEOGRAPH
    {0xB742, 0x5AB2}, //3395 #CJK UNIFIED IDEOGRAPH
    {0xB743, 0x5D69}, //3396 #CJK UNIFIED IDEOGRAPH
    {0xB744, 0x5D6F}, //3397 #CJK UNIFIED IDEOGRAPH
    {0xB745, 0x5E4C}, //3398 #CJK UNIFIED IDEOGRAPH
    {0xB746, 0x5E79}, //3399 #CJK UNIFIED IDEOGRAPH
    {0xB747, 0x5EC9}, //3400 #CJK UNIFIED IDEOGRAPH
    {0xB748, 0x5EC8}, //3401 #CJK UNIFIED IDEOGRAPH
    {0xB749, 0x5F12}, //3402 #CJK UNIFIED IDEOGRAPH
    {0xB74A, 0x5F59}, //3403 #CJK UNIFIED IDEOGRAPH
    {0xB74B, 0x5FAC}, //3404 #CJK UNIFIED IDEOGRAPH
    {0xB74C, 0x5FAE}, //3405 #CJK UNIFIED IDEOGRAPH
    {0xB74D, 0x611A}, //3406 #CJK UNIFIED IDEOGRAPH
    {0xB74E, 0x610F}, //3407 #CJK UNIFIED IDEOGRAPH
    {0xB74F, 0x6148}, //3408 #CJK UNIFIED IDEOGRAPH
    {0xB750, 0x611F}, //3409 #CJK UNIFIED IDEOGRAPH
    {0xB751, 0x60F3}, //3410 #CJK UNIFIED IDEOGRAPH
    {0xB752, 0x611B}, //3411 #CJK UNIFIED IDEOGRAPH
    {0xB753, 0x60F9}, //3412 #CJK UNIFIED IDEOGRAPH
    {0xB754, 0x6101}, //3413 #CJK UNIFIED IDEOGRAPH
    {0xB755, 0x6108}, //3414 #CJK UNIFIED IDEOGRAPH
    {0xB756, 0x614E}, //3415 #CJK UNIFIED IDEOGRAPH
    {0xB757, 0x614C}, //3416 #CJK UNIFIED IDEOGRAPH
    {0xB758, 0x6144}, //3417 #CJK UNIFIED IDEOGRAPH
    {0xB759, 0x614D}, //3418 #CJK UNIFIED IDEOGRAPH
    {0xB75A, 0x613E}, //3419 #CJK UNIFIED IDEOGRAPH
    {0xB75B, 0x6134}, //3420 #CJK UNIFIED IDEOGRAPH
    {0xB75C, 0x6127}, //3421 #CJK UNIFIED IDEOGRAPH
    {0xB75D, 0x610D}, //3422 #CJK UNIFIED IDEOGRAPH
    {0xB75E, 0x6106}, //3423 #CJK UNIFIED IDEOGRAPH
    {0xB75F, 0x6137}, //3424 #CJK UNIFIED IDEOGRAPH
    {0xB760, 0x6221}, //3425 #CJK UNIFIED IDEOGRAPH
    {0xB761, 0x6222}, //3426 #CJK UNIFIED IDEOGRAPH
    {0xB762, 0x6413}, //3427 #CJK UNIFIED IDEOGRAPH
    {0xB763, 0x643E}, //3428 #CJK UNIFIED IDEOGRAPH
    {0xB764, 0x641E}, //3429 #CJK UNIFIED IDEOGRAPH
    {0xB765, 0x642A}, //3430 #CJK UNIFIED IDEOGRAPH
    {0xB766, 0x642D}, //3431 #CJK UNIFIED IDEOGRAPH
    {0xB767, 0x643D}, //3432 #CJK UNIFIED IDEOGRAPH
    {0xB768, 0x642C}, //3433 #CJK UNIFIED IDEOGRAPH
    {0xB769, 0x640F}, //3434 #CJK UNIFIED IDEOGRAPH
    {0xB76A, 0x641C}, //3435 #CJK UNIFIED IDEOGRAPH
    {0xB76B, 0x6414}, //3436 #CJK UNIFIED IDEOGRAPH
    {0xB76C, 0x640D}, //3437 #CJK UNIFIED IDEOGRAPH
    {0xB76D, 0x6436}, //3438 #CJK UNIFIED IDEOGRAPH
    {0xB76E, 0x6416}, //3439 #CJK UNIFIED IDEOGRAPH
    {0xB76F, 0x6417}, //3440 #CJK UNIFIED IDEOGRAPH
    {0xB770, 0x6406}, //3441 #CJK UNIFIED IDEOGRAPH
    {0xB771, 0x656C}, //3442 #CJK UNIFIED IDEOGRAPH
    {0xB772, 0x659F}, //3443 #CJK UNIFIED IDEOGRAPH
    {0xB773, 0x65B0}, //3444 #CJK UNIFIED IDEOGRAPH
    {0xB774, 0x6697}, //3445 #CJK UNIFIED IDEOGRAPH
    {0xB775, 0x6689}, //3446 #CJK UNIFIED IDEOGRAPH
    {0xB776, 0x6687}, //3447 #CJK UNIFIED IDEOGRAPH
    {0xB777, 0x6688}, //3448 #CJK UNIFIED IDEOGRAPH
    {0xB778, 0x6696}, //3449 #CJK UNIFIED IDEOGRAPH
    {0xB779, 0x6684}, //3450 #CJK UNIFIED IDEOGRAPH
    {0xB77A, 0x6698}, //3451 #CJK UNIFIED IDEOGRAPH
    {0xB77B, 0x668D}, //3452 #CJK UNIFIED IDEOGRAPH
    {0xB77C, 0x6703}, //3453 #CJK UNIFIED IDEOGRAPH
    {0xB77D, 0x6994}, //3454 #CJK UNIFIED IDEOGRAPH
    {0xB77E, 0x696D}, //3455 #CJK UNIFIED IDEOGRAPH
    {0xB7A1, 0x695A}, //3456 #CJK UNIFIED IDEOGRAPH
    {0xB7A2, 0x6977}, //3457 #CJK UNIFIED IDEOGRAPH
    {0xB7A3, 0x6960}, //3458 #CJK UNIFIED IDEOGRAPH
    {0xB7A4, 0x6954}, //3459 #CJK UNIFIED IDEOGRAPH
    {0xB7A5, 0x6975}, //3460 #CJK UNIFIED IDEOGRAPH
    {0xB7A6, 0x6930}, //3461 #CJK UNIFIED IDEOGRAPH
    {0xB7A7, 0x6982}, //3462 #CJK UNIFIED IDEOGRAPH
    {0xB7A8, 0x694A}, //3463 #CJK UNIFIED IDEOGRAPH
    {0xB7A9, 0x6968}, //3464 #CJK UNIFIED IDEOGRAPH
    {0xB7AA, 0x696B}, //3465 #CJK UNIFIED IDEOGRAPH
    {0xB7AB, 0x695E}, //3466 #CJK UNIFIED IDEOGRAPH
    {0xB7AC, 0x6953}, //3467 #CJK UNIFIED IDEOGRAPH
    {0xB7AD, 0x6979}, //3468 #CJK UNIFIED IDEOGRAPH
    {0xB7AE, 0x6986}, //3469 #CJK UNIFIED IDEOGRAPH
    {0xB7AF, 0x695D}, //3470 #CJK UNIFIED IDEOGRAPH
    {0xB7B0, 0x6963}, //3471 #CJK UNIFIED IDEOGRAPH
    {0xB7B1, 0x695B}, //3472 #CJK UNIFIED IDEOGRAPH
    {0xB7B2, 0x6B47}, //3473 #CJK UNIFIED IDEOGRAPH
    {0xB7B3, 0x6B72}, //3474 #CJK UNIFIED IDEOGRAPH
    {0xB7B4, 0x6BC0}, //3475 #CJK UNIFIED IDEOGRAPH
    {0xB7B5, 0x6BBF}, //3476 #CJK UNIFIED IDEOGRAPH
    {0xB7B6, 0x6BD3}, //3477 #CJK UNIFIED IDEOGRAPH
    {0xB7B7, 0x6BFD}, //3478 #CJK UNIFIED IDEOGRAPH
    {0xB7B8, 0x6EA2}, //3479 #CJK UNIFIED IDEOGRAPH
    {0xB7B9, 0x6EAF}, //3480 #CJK UNIFIED IDEOGRAPH
    {0xB7BA, 0x6ED3}, //3481 #CJK UNIFIED IDEOGRAPH
    {0xB7BB, 0x6EB6}, //3482 #CJK UNIFIED IDEOGRAPH
    {0xB7BC, 0x6EC2}, //3483 #CJK UNIFIED IDEOGRAPH
    {0xB7BD, 0x6E90}, //3484 #CJK UNIFIED IDEOGRAPH
    {0xB7BE, 0x6E9D}, //3485 #CJK UNIFIED IDEOGRAPH
    {0xB7BF, 0x6EC7}, //3486 #CJK UNIFIED IDEOGRAPH
    {0xB7C0, 0x6EC5}, //3487 #CJK UNIFIED IDEOGRAPH
    {0xB7C1, 0x6EA5}, //3488 #CJK UNIFIED IDEOGRAPH
    {0xB7C2, 0x6E98}, //3489 #CJK UNIFIED IDEOGRAPH
    {0xB7C3, 0x6EBC}, //3490 #CJK UNIFIED IDEOGRAPH
    {0xB7C4, 0x6EBA}, //3491 #CJK UNIFIED IDEOGRAPH
    {0xB7C5, 0x6EAB}, //3492 #CJK UNIFIED IDEOGRAPH
    {0xB7C6, 0x6ED1}, //3493 #CJK UNIFIED IDEOGRAPH
    {0xB7C7, 0x6E96}, //3494 #CJK UNIFIED IDEOGRAPH
    {0xB7C8, 0x6E9C}, //3495 #CJK UNIFIED IDEOGRAPH
    {0xB7C9, 0x6EC4}, //3496 #CJK UNIFIED IDEOGRAPH
    {0xB7CA, 0x6ED4}, //3497 #CJK UNIFIED IDEOGRAPH
    {0xB7CB, 0x6EAA}, //3498 #CJK UNIFIED IDEOGRAPH
    {0xB7CC, 0x6EA7}, //3499 #CJK UNIFIED IDEOGRAPH
    {0xB7CD, 0x6EB4}, //3500 #CJK UNIFIED IDEOGRAPH
    {0xB7CE, 0x714E}, //3501 #CJK UNIFIED IDEOGRAPH
    {0xB7CF, 0x7159}, //3502 #CJK UNIFIED IDEOGRAPH
    {0xB7D0, 0x7169}, //3503 #CJK UNIFIED IDEOGRAPH
    {0xB7D1, 0x7164}, //3504 #CJK UNIFIED IDEOGRAPH
    {0xB7D2, 0x7149}, //3505 #CJK UNIFIED IDEOGRAPH
    {0xB7D3, 0x7167}, //3506 #CJK UNIFIED IDEOGRAPH
    {0xB7D4, 0x715C}, //3507 #CJK UNIFIED IDEOGRAPH
    {0xB7D5, 0x716C}, //3508 #CJK UNIFIED IDEOGRAPH
    {0xB7D6, 0x7166}, //3509 #CJK UNIFIED IDEOGRAPH
    {0xB7D7, 0x714C}, //3510 #CJK UNIFIED IDEOGRAPH
    {0xB7D8, 0x7165}, //3511 #CJK UNIFIED IDEOGRAPH
    {0xB7D9, 0x715E}, //3512 #CJK UNIFIED IDEOGRAPH
    {0xB7DA, 0x7146}, //3513 #CJK UNIFIED IDEOGRAPH
    {0xB7DB, 0x7168}, //3514 #CJK UNIFIED IDEOGRAPH
    {0xB7DC, 0x7156}, //3515 #CJK UNIFIED IDEOGRAPH
    {0xB7DD, 0x723A}, //3516 #CJK UNIFIED IDEOGRAPH
    {0xB7DE, 0x7252}, //3517 #CJK UNIFIED IDEOGRAPH
    {0xB7DF, 0x7337}, //3518 #CJK UNIFIED IDEOGRAPH
    {0xB7E0, 0x7345}, //3519 #CJK UNIFIED IDEOGRAPH
    {0xB7E1, 0x733F}, //3520 #CJK UNIFIED IDEOGRAPH
    {0xB7E2, 0x733E}, //3521 #CJK UNIFIED IDEOGRAPH
    {0xB7E3, 0x746F}, //3522 #CJK UNIFIED IDEOGRAPH
    {0xB7E4, 0x745A}, //3523 #CJK UNIFIED IDEOGRAPH
    {0xB7E5, 0x7455}, //3524 #CJK UNIFIED IDEOGRAPH
    {0xB7E6, 0x745F}, //3525 #CJK UNIFIED IDEOGRAPH
    {0xB7E7, 0x745E}, //3526 #CJK UNIFIED IDEOGRAPH
    {0xB7E8, 0x7441}, //3527 #CJK UNIFIED IDEOGRAPH
    {0xB7E9, 0x743F}, //3528 #CJK UNIFIED IDEOGRAPH
    {0xB7EA, 0x7459}, //3529 #CJK UNIFIED IDEOGRAPH
    {0xB7EB, 0x745B}, //3530 #CJK UNIFIED IDEOGRAPH
    {0xB7EC, 0x745C}, //3531 #CJK UNIFIED IDEOGRAPH
    {0xB7ED, 0x7576}, //3532 #CJK UNIFIED IDEOGRAPH
    {0xB7EE, 0x7578}, //3533 #CJK UNIFIED IDEOGRAPH
    {0xB7EF, 0x7600}, //3534 #CJK UNIFIED IDEOGRAPH
    {0xB7F0, 0x75F0}, //3535 #CJK UNIFIED IDEOGRAPH
    {0xB7F1, 0x7601}, //3536 #CJK UNIFIED IDEOGRAPH
    {0xB7F2, 0x75F2}, //3537 #CJK UNIFIED IDEOGRAPH
    {0xB7F3, 0x75F1}, //3538 #CJK UNIFIED IDEOGRAPH
    {0xB7F4, 0x75FA}, //3539 #CJK UNIFIED IDEOGRAPH
    {0xB7F5, 0x75FF}, //3540 #CJK UNIFIED IDEOGRAPH
    {0xB7F6, 0x75F4}, //3541 #CJK UNIFIED IDEOGRAPH
    {0xB7F7, 0x75F3}, //3542 #CJK UNIFIED IDEOGRAPH
    {0xB7F8, 0x76DE}, //3543 #CJK UNIFIED IDEOGRAPH
    {0xB7F9, 0x76DF}, //3544 #CJK UNIFIED IDEOGRAPH
    {0xB7FA, 0x775B}, //3545 #CJK UNIFIED IDEOGRAPH
    {0xB7FB, 0x776B}, //3546 #CJK UNIFIED IDEOGRAPH
    {0xB7FC, 0x7766}, //3547 #CJK UNIFIED IDEOGRAPH
    {0xB7FD, 0x775E}, //3548 #CJK UNIFIED IDEOGRAPH
    {0xB7FE, 0x7763}, //3549 #CJK UNIFIED IDEOGRAPH
    {0xB840, 0x7779}, //3550 #CJK UNIFIED IDEOGRAPH
    {0xB841, 0x776A}, //3551 #CJK UNIFIED IDEOGRAPH
    {0xB842, 0x776C}, //3552 #CJK UNIFIED IDEOGRAPH
    {0xB843, 0x775C}, //3553 #CJK UNIFIED IDEOGRAPH
    {0xB844, 0x7765}, //3554 #CJK UNIFIED IDEOGRAPH
    {0xB845, 0x7768}, //3555 #CJK UNIFIED IDEOGRAPH
    {0xB846, 0x7762}, //3556 #CJK UNIFIED IDEOGRAPH
    {0xB847, 0x77EE}, //3557 #CJK UNIFIED IDEOGRAPH
    {0xB848, 0x788E}, //3558 #CJK UNIFIED IDEOGRAPH
    {0xB849, 0x78B0}, //3559 #CJK UNIFIED IDEOGRAPH
    {0xB84A, 0x7897}, //3560 #CJK UNIFIED IDEOGRAPH
    {0xB84B, 0x7898}, //3561 #CJK UNIFIED IDEOGRAPH
    {0xB84C, 0x788C}, //3562 #CJK UNIFIED IDEOGRAPH
    {0xB84D, 0x7889}, //3563 #CJK UNIFIED IDEOGRAPH
    {0xB84E, 0x787C}, //3564 #CJK UNIFIED IDEOGRAPH
    {0xB84F, 0x7891}, //3565 #CJK UNIFIED IDEOGRAPH
    {0xB850, 0x7893}, //3566 #CJK UNIFIED IDEOGRAPH
    {0xB851, 0x787F}, //3567 #CJK UNIFIED IDEOGRAPH
    {0xB852, 0x797A}, //3568 #CJK UNIFIED IDEOGRAPH
    {0xB853, 0x797F}, //3569 #CJK UNIFIED IDEOGRAPH
    {0xB854, 0x7981}, //3570 #CJK UNIFIED IDEOGRAPH
    {0xB855, 0x842C}, //3571 #CJK UNIFIED IDEOGRAPH
    {0xB856, 0x79BD}, //3572 #CJK UNIFIED IDEOGRAPH
    {0xB857, 0x7A1C}, //3573 #CJK UNIFIED IDEOGRAPH
    {0xB858, 0x7A1A}, //3574 #CJK UNIFIED IDEOGRAPH
    {0xB859, 0x7A20}, //3575 #CJK UNIFIED IDEOGRAPH
    {0xB85A, 0x7A14}, //3576 #CJK UNIFIED IDEOGRAPH
    {0xB85B, 0x7A1F}, //3577 #CJK UNIFIED IDEOGRAPH
    {0xB85C, 0x7A1E}, //3578 #CJK UNIFIED IDEOGRAPH
    {0xB85D, 0x7A9F}, //3579 #CJK UNIFIED IDEOGRAPH
    {0xB85E, 0x7AA0}, //3580 #CJK UNIFIED IDEOGRAPH
    {0xB85F, 0x7B77}, //3581 #CJK UNIFIED IDEOGRAPH
    {0xB860, 0x7BC0}, //3582 #CJK UNIFIED IDEOGRAPH
    {0xB861, 0x7B60}, //3583 #CJK UNIFIED IDEOGRAPH
    {0xB862, 0x7B6E}, //3584 #CJK UNIFIED IDEOGRAPH
    {0xB863, 0x7B67}, //3585 #CJK UNIFIED IDEOGRAPH
    {0xB864, 0x7CB1}, //3586 #CJK UNIFIED IDEOGRAPH
    {0xB865, 0x7CB3}, //3587 #CJK UNIFIED IDEOGRAPH
    {0xB866, 0x7CB5}, //3588 #CJK UNIFIED IDEOGRAPH
    {0xB867, 0x7D93}, //3589 #CJK UNIFIED IDEOGRAPH
    {0xB868, 0x7D79}, //3590 #CJK UNIFIED IDEOGRAPH
    {0xB869, 0x7D91}, //3591 #CJK UNIFIED IDEOGRAPH
    {0xB86A, 0x7D81}, //3592 #CJK UNIFIED IDEOGRAPH
    {0xB86B, 0x7D8F}, //3593 #CJK UNIFIED IDEOGRAPH
    {0xB86C, 0x7D5B}, //3594 #CJK UNIFIED IDEOGRAPH
    {0xB86D, 0x7F6E}, //3595 #CJK UNIFIED IDEOGRAPH
    {0xB86E, 0x7F69}, //3596 #CJK UNIFIED IDEOGRAPH
    {0xB86F, 0x7F6A}, //3597 #CJK UNIFIED IDEOGRAPH
    {0xB870, 0x7F72}, //3598 #CJK UNIFIED IDEOGRAPH
    {0xB871, 0x7FA9}, //3599 #CJK UNIFIED IDEOGRAPH
    {0xB872, 0x7FA8}, //3600 #CJK UNIFIED IDEOGRAPH
    {0xB873, 0x7FA4}, //3601 #CJK UNIFIED IDEOGRAPH
    {0xB874, 0x8056}, //3602 #CJK UNIFIED IDEOGRAPH
    {0xB875, 0x8058}, //3603 #CJK UNIFIED IDEOGRAPH
    {0xB876, 0x8086}, //3604 #CJK UNIFIED IDEOGRAPH
    {0xB877, 0x8084}, //3605 #CJK UNIFIED IDEOGRAPH
    {0xB878, 0x8171}, //3606 #CJK UNIFIED IDEOGRAPH
    {0xB879, 0x8170}, //3607 #CJK UNIFIED IDEOGRAPH
    {0xB87A, 0x8178}, //3608 #CJK UNIFIED IDEOGRAPH
    {0xB87B, 0x8165}, //3609 #CJK UNIFIED IDEOGRAPH
    {0xB87C, 0x816E}, //3610 #CJK UNIFIED IDEOGRAPH
    {0xB87D, 0x8173}, //3611 #CJK UNIFIED IDEOGRAPH
    {0xB87E, 0x816B}, //3612 #CJK UNIFIED IDEOGRAPH
    {0xB8A1, 0x8179}, //3613 #CJK UNIFIED IDEOGRAPH
    {0xB8A2, 0x817A}, //3614 #CJK UNIFIED IDEOGRAPH
    {0xB8A3, 0x8166}, //3615 #CJK UNIFIED IDEOGRAPH
    {0xB8A4, 0x8205}, //3616 #CJK UNIFIED IDEOGRAPH
    {0xB8A5, 0x8247}, //3617 #CJK UNIFIED IDEOGRAPH
    {0xB8A6, 0x8482}, //3618 #CJK UNIFIED IDEOGRAPH
    {0xB8A7, 0x8477}, //3619 #CJK UNIFIED IDEOGRAPH
    {0xB8A8, 0x843D}, //3620 #CJK UNIFIED IDEOGRAPH
    {0xB8A9, 0x8431}, //3621 #CJK UNIFIED IDEOGRAPH
    {0xB8AA, 0x8475}, //3622 #CJK UNIFIED IDEOGRAPH
    {0xB8AB, 0x8466}, //3623 #CJK UNIFIED IDEOGRAPH
    {0xB8AC, 0x846B}, //3624 #CJK UNIFIED IDEOGRAPH
    {0xB8AD, 0x8449}, //3625 #CJK UNIFIED IDEOGRAPH
    {0xB8AE, 0x846C}, //3626 #CJK UNIFIED IDEOGRAPH
    {0xB8AF, 0x845B}, //3627 #CJK UNIFIED IDEOGRAPH
    {0xB8B0, 0x843C}, //3628 #CJK UNIFIED IDEOGRAPH
    {0xB8B1, 0x8435}, //3629 #CJK UNIFIED IDEOGRAPH
    {0xB8B2, 0x8461}, //3630 #CJK UNIFIED IDEOGRAPH
    {0xB8B3, 0x8463}, //3631 #CJK UNIFIED IDEOGRAPH
    {0xB8B4, 0x8469}, //3632 #CJK UNIFIED IDEOGRAPH
    {0xB8B5, 0x846D}, //3633 #CJK UNIFIED IDEOGRAPH
    {0xB8B6, 0x8446}, //3634 #CJK UNIFIED IDEOGRAPH
    {0xB8B7, 0x865E}, //3635 #CJK UNIFIED IDEOGRAPH
    {0xB8B8, 0x865C}, //3636 #CJK UNIFIED IDEOGRAPH
    {0xB8B9, 0x865F}, //3637 #CJK UNIFIED IDEOGRAPH
    {0xB8BA, 0x86F9}, //3638 #CJK UNIFIED IDEOGRAPH
    {0xB8BB, 0x8713}, //3639 #CJK UNIFIED IDEOGRAPH
    {0xB8BC, 0x8708}, //3640 #CJK UNIFIED IDEOGRAPH
    {0xB8BD, 0x8707}, //3641 #CJK UNIFIED IDEOGRAPH
    {0xB8BE, 0x8700}, //3642 #CJK UNIFIED IDEOGRAPH
    {0xB8BF, 0x86FE}, //3643 #CJK UNIFIED IDEOGRAPH
    {0xB8C0, 0x86FB}, //3644 #CJK UNIFIED IDEOGRAPH
    {0xB8C1, 0x8702}, //3645 #CJK UNIFIED IDEOGRAPH
    {0xB8C2, 0x8703}, //3646 #CJK UNIFIED IDEOGRAPH
    {0xB8C3, 0x8706}, //3647 #CJK UNIFIED IDEOGRAPH
    {0xB8C4, 0x870A}, //3648 #CJK UNIFIED IDEOGRAPH
    {0xB8C5, 0x8859}, //3649 #CJK UNIFIED IDEOGRAPH
    {0xB8C6, 0x88DF}, //3650 #CJK UNIFIED IDEOGRAPH
    {0xB8C7, 0x88D4}, //3651 #CJK UNIFIED IDEOGRAPH
    {0xB8C8, 0x88D9}, //3652 #CJK UNIFIED IDEOGRAPH
    {0xB8C9, 0x88DC}, //3653 #CJK UNIFIED IDEOGRAPH
    {0xB8CA, 0x88D8}, //3654 #CJK UNIFIED IDEOGRAPH
    {0xB8CB, 0x88DD}, //3655 #CJK UNIFIED IDEOGRAPH
    {0xB8CC, 0x88E1}, //3656 #CJK UNIFIED IDEOGRAPH
    {0xB8CD, 0x88CA}, //3657 #CJK UNIFIED IDEOGRAPH
    {0xB8CE, 0x88D5}, //3658 #CJK UNIFIED IDEOGRAPH
    {0xB8CF, 0x88D2}, //3659 #CJK UNIFIED IDEOGRAPH
    {0xB8D0, 0x899C}, //3660 #CJK UNIFIED IDEOGRAPH
    {0xB8D1, 0x89E3}, //3661 #CJK UNIFIED IDEOGRAPH
    {0xB8D2, 0x8A6B}, //3662 #CJK UNIFIED IDEOGRAPH
    {0xB8D3, 0x8A72}, //3663 #CJK UNIFIED IDEOGRAPH
    {0xB8D4, 0x8A73}, //3664 #CJK UNIFIED IDEOGRAPH
    {0xB8D5, 0x8A66}, //3665 #CJK UNIFIED IDEOGRAPH
    {0xB8D6, 0x8A69}, //3666 #CJK UNIFIED IDEOGRAPH
    {0xB8D7, 0x8A70}, //3667 #CJK UNIFIED IDEOGRAPH
    {0xB8D8, 0x8A87}, //3668 #CJK UNIFIED IDEOGRAPH
    {0xB8D9, 0x8A7C}, //3669 #CJK UNIFIED IDEOGRAPH
    {0xB8DA, 0x8A63}, //3670 #CJK UNIFIED IDEOGRAPH
    {0xB8DB, 0x8AA0}, //3671 #CJK UNIFIED IDEOGRAPH
    {0xB8DC, 0x8A71}, //3672 #CJK UNIFIED IDEOGRAPH
    {0xB8DD, 0x8A85}, //3673 #CJK UNIFIED IDEOGRAPH
    {0xB8DE, 0x8A6D}, //3674 #CJK UNIFIED IDEOGRAPH
    {0xB8DF, 0x8A62}, //3675 #CJK UNIFIED IDEOGRAPH
    {0xB8E0, 0x8A6E}, //3676 #CJK UNIFIED IDEOGRAPH
    {0xB8E1, 0x8A6C}, //3677 #CJK UNIFIED IDEOGRAPH
    {0xB8E2, 0x8A79}, //3678 #CJK UNIFIED IDEOGRAPH
    {0xB8E3, 0x8A7B}, //3679 #CJK UNIFIED IDEOGRAPH
    {0xB8E4, 0x8A3E}, //3680 #CJK UNIFIED IDEOGRAPH
    {0xB8E5, 0x8A68}, //3681 #CJK UNIFIED IDEOGRAPH
    {0xB8E6, 0x8C62}, //3682 #CJK UNIFIED IDEOGRAPH
    {0xB8E7, 0x8C8A}, //3683 #CJK UNIFIED IDEOGRAPH
    {0xB8E8, 0x8C89}, //3684 #CJK UNIFIED IDEOGRAPH
    {0xB8E9, 0x8CCA}, //3685 #CJK UNIFIED IDEOGRAPH
    {0xB8EA, 0x8CC7}, //3686 #CJK UNIFIED IDEOGRAPH
    {0xB8EB, 0x8CC8}, //3687 #CJK UNIFIED IDEOGRAPH
    {0xB8EC, 0x8CC4}, //3688 #CJK UNIFIED IDEOGRAPH
    {0xB8ED, 0x8CB2}, //3689 #CJK UNIFIED IDEOGRAPH
    {0xB8EE, 0x8CC3}, //3690 #CJK UNIFIED IDEOGRAPH
    {0xB8EF, 0x8CC2}, //3691 #CJK UNIFIED IDEOGRAPH
    {0xB8F0, 0x8CC5}, //3692 #CJK UNIFIED IDEOGRAPH
    {0xB8F1, 0x8DE1}, //3693 #CJK UNIFIED IDEOGRAPH
    {0xB8F2, 0x8DDF}, //3694 #CJK UNIFIED IDEOGRAPH
    {0xB8F3, 0x8DE8}, //3695 #CJK UNIFIED IDEOGRAPH
    {0xB8F4, 0x8DEF}, //3696 #CJK UNIFIED IDEOGRAPH
    {0xB8F5, 0x8DF3}, //3697 #CJK UNIFIED IDEOGRAPH
    {0xB8F6, 0x8DFA}, //3698 #CJK UNIFIED IDEOGRAPH
    {0xB8F7, 0x8DEA}, //3699 #CJK UNIFIED IDEOGRAPH
    {0xB8F8, 0x8DE4}, //3700 #CJK UNIFIED IDEOGRAPH
    {0xB8F9, 0x8DE6}, //3701 #CJK UNIFIED IDEOGRAPH
    {0xB8FA, 0x8EB2}, //3702 #CJK UNIFIED IDEOGRAPH
    {0xB8FB, 0x8F03}, //3703 #CJK UNIFIED IDEOGRAPH
    {0xB8FC, 0x8F09}, //3704 #CJK UNIFIED IDEOGRAPH
    {0xB8FD, 0x8EFE}, //3705 #CJK UNIFIED IDEOGRAPH
    {0xB8FE, 0x8F0A}, //3706 #CJK UNIFIED IDEOGRAPH
    {0xB940, 0x8F9F}, //3707 #CJK UNIFIED IDEOGRAPH
    {0xB941, 0x8FB2}, //3708 #CJK UNIFIED IDEOGRAPH
    {0xB942, 0x904B}, //3709 #CJK UNIFIED IDEOGRAPH
    {0xB943, 0x904A}, //3710 #CJK UNIFIED IDEOGRAPH
    {0xB944, 0x9053}, //3711 #CJK UNIFIED IDEOGRAPH
    {0xB945, 0x9042}, //3712 #CJK UNIFIED IDEOGRAPH
    {0xB946, 0x9054}, //3713 #CJK UNIFIED IDEOGRAPH
    {0xB947, 0x903C}, //3714 #CJK UNIFIED IDEOGRAPH
    {0xB948, 0x9055}, //3715 #CJK UNIFIED IDEOGRAPH
    {0xB949, 0x9050}, //3716 #CJK UNIFIED IDEOGRAPH
    {0xB94A, 0x9047}, //3717 #CJK UNIFIED IDEOGRAPH
    {0xB94B, 0x904F}, //3718 #CJK UNIFIED IDEOGRAPH
    {0xB94C, 0x904E}, //3719 #CJK UNIFIED IDEOGRAPH
    {0xB94D, 0x904D}, //3720 #CJK UNIFIED IDEOGRAPH
    {0xB94E, 0x9051}, //3721 #CJK UNIFIED IDEOGRAPH
    {0xB94F, 0x903E}, //3722 #CJK UNIFIED IDEOGRAPH
    {0xB950, 0x9041}, //3723 #CJK UNIFIED IDEOGRAPH
    {0xB951, 0x9112}, //3724 #CJK UNIFIED IDEOGRAPH
    {0xB952, 0x9117}, //3725 #CJK UNIFIED IDEOGRAPH
    {0xB953, 0x916C}, //3726 #CJK UNIFIED IDEOGRAPH
    {0xB954, 0x916A}, //3727 #CJK UNIFIED IDEOGRAPH
    {0xB955, 0x9169}, //3728 #CJK UNIFIED IDEOGRAPH
    {0xB956, 0x91C9}, //3729 #CJK UNIFIED IDEOGRAPH
    {0xB957, 0x9237}, //3730 #CJK UNIFIED IDEOGRAPH
    {0xB958, 0x9257}, //3731 #CJK UNIFIED IDEOGRAPH
    {0xB959, 0x9238}, //3732 #CJK UNIFIED IDEOGRAPH
    {0xB95A, 0x923D}, //3733 #CJK UNIFIED IDEOGRAPH
    {0xB95B, 0x9240}, //3734 #CJK UNIFIED IDEOGRAPH
    {0xB95C, 0x923E}, //3735 #CJK UNIFIED IDEOGRAPH
    {0xB95D, 0x925B}, //3736 #CJK UNIFIED IDEOGRAPH
    {0xB95E, 0x924B}, //3737 #CJK UNIFIED IDEOGRAPH
    {0xB95F, 0x9264}, //3738 #CJK UNIFIED IDEOGRAPH
    {0xB960, 0x9251}, //3739 #CJK UNIFIED IDEOGRAPH
    {0xB961, 0x9234}, //3740 #CJK UNIFIED IDEOGRAPH
    {0xB962, 0x9249}, //3741 #CJK UNIFIED IDEOGRAPH
    {0xB963, 0x924D}, //3742 #CJK UNIFIED IDEOGRAPH
    {0xB964, 0x9245}, //3743 #CJK UNIFIED IDEOGRAPH
    {0xB965, 0x9239}, //3744 #CJK UNIFIED IDEOGRAPH
    {0xB966, 0x923F}, //3745 #CJK UNIFIED IDEOGRAPH
    {0xB967, 0x925A}, //3746 #CJK UNIFIED IDEOGRAPH
    {0xB968, 0x9598}, //3747 #CJK UNIFIED IDEOGRAPH
    {0xB969, 0x9698}, //3748 #CJK UNIFIED IDEOGRAPH
    {0xB96A, 0x9694}, //3749 #CJK UNIFIED IDEOGRAPH
    {0xB96B, 0x9695}, //3750 #CJK UNIFIED IDEOGRAPH
    {0xB96C, 0x96CD}, //3751 #CJK UNIFIED IDEOGRAPH
    {0xB96D, 0x96CB}, //3752 #CJK UNIFIED IDEOGRAPH
    {0xB96E, 0x96C9}, //3753 #CJK UNIFIED IDEOGRAPH
    {0xB96F, 0x96CA}, //3754 #CJK UNIFIED IDEOGRAPH
    {0xB970, 0x96F7}, //3755 #CJK UNIFIED IDEOGRAPH
    {0xB971, 0x96FB}, //3756 #CJK UNIFIED IDEOGRAPH
    {0xB972, 0x96F9}, //3757 #CJK UNIFIED IDEOGRAPH
    {0xB973, 0x96F6}, //3758 #CJK UNIFIED IDEOGRAPH
    {0xB974, 0x9756}, //3759 #CJK UNIFIED IDEOGRAPH
    {0xB975, 0x9774}, //3760 #CJK UNIFIED IDEOGRAPH
    {0xB976, 0x9776}, //3761 #CJK UNIFIED IDEOGRAPH
    {0xB977, 0x9810}, //3762 #CJK UNIFIED IDEOGRAPH
    {0xB978, 0x9811}, //3763 #CJK UNIFIED IDEOGRAPH
    {0xB979, 0x9813}, //3764 #CJK UNIFIED IDEOGRAPH
    {0xB97A, 0x980A}, //3765 #CJK UNIFIED IDEOGRAPH
    {0xB97B, 0x9812}, //3766 #CJK UNIFIED IDEOGRAPH
    {0xB97C, 0x980C}, //3767 #CJK UNIFIED IDEOGRAPH
    {0xB97D, 0x98FC}, //3768 #CJK UNIFIED IDEOGRAPH
    {0xB97E, 0x98F4}, //3769 #CJK UNIFIED IDEOGRAPH
    {0xB9A1, 0x98FD}, //3770 #CJK UNIFIED IDEOGRAPH
    {0xB9A2, 0x98FE}, //3771 #CJK UNIFIED IDEOGRAPH
    {0xB9A3, 0x99B3}, //3772 #CJK UNIFIED IDEOGRAPH
    {0xB9A4, 0x99B1}, //3773 #CJK UNIFIED IDEOGRAPH
    {0xB9A5, 0x99B4}, //3774 #CJK UNIFIED IDEOGRAPH
    {0xB9A6, 0x9AE1}, //3775 #CJK UNIFIED IDEOGRAPH
    {0xB9A7, 0x9CE9}, //3776 #CJK UNIFIED IDEOGRAPH
    {0xB9A8, 0x9E82}, //3777 #CJK UNIFIED IDEOGRAPH
    {0xB9A9, 0x9F0E}, //3778 #CJK UNIFIED IDEOGRAPH
    {0xB9AA, 0x9F13}, //3779 #CJK UNIFIED IDEOGRAPH
    {0xB9AB, 0x9F20}, //3780 #CJK UNIFIED IDEOGRAPH
    {0xB9AC, 0x50E7}, //3781 #CJK UNIFIED IDEOGRAPH
    {0xB9AD, 0x50EE}, //3782 #CJK UNIFIED IDEOGRAPH
    {0xB9AE, 0x50E5}, //3783 #CJK UNIFIED IDEOGRAPH
    {0xB9AF, 0x50D6}, //3784 #CJK UNIFIED IDEOGRAPH
    {0xB9B0, 0x50ED}, //3785 #CJK UNIFIED IDEOGRAPH
    {0xB9B1, 0x50DA}, //3786 #CJK UNIFIED IDEOGRAPH
    {0xB9B2, 0x50D5}, //3787 #CJK UNIFIED IDEOGRAPH
    {0xB9B3, 0x50CF}, //3788 #CJK UNIFIED IDEOGRAPH
    {0xB9B4, 0x50D1}, //3789 #CJK UNIFIED IDEOGRAPH
    {0xB9B5, 0x50F1}, //3790 #CJK UNIFIED IDEOGRAPH
    {0xB9B6, 0x50CE}, //3791 #CJK UNIFIED IDEOGRAPH
    {0xB9B7, 0x50E9}, //3792 #CJK UNIFIED IDEOGRAPH
    {0xB9B8, 0x5162}, //3793 #CJK UNIFIED IDEOGRAPH
    {0xB9B9, 0x51F3}, //3794 #CJK UNIFIED IDEOGRAPH
    {0xB9BA, 0x5283}, //3795 #CJK UNIFIED IDEOGRAPH
    {0xB9BB, 0x5282}, //3796 #CJK UNIFIED IDEOGRAPH
    {0xB9BC, 0x5331}, //3797 #CJK UNIFIED IDEOGRAPH
    {0xB9BD, 0x53AD}, //3798 #CJK UNIFIED IDEOGRAPH
    {0xB9BE, 0x55FE}, //3799 #CJK UNIFIED IDEOGRAPH
    {0xB9BF, 0x5600}, //3800 #CJK UNIFIED IDEOGRAPH
    {0xB9C0, 0x561B}, //3801 #CJK UNIFIED IDEOGRAPH
    {0xB9C1, 0x5617}, //3802 #CJK UNIFIED IDEOGRAPH
    {0xB9C2, 0x55FD}, //3803 #CJK UNIFIED IDEOGRAPH
    {0xB9C3, 0x5614}, //3804 #CJK UNIFIED IDEOGRAPH
    {0xB9C4, 0x5606}, //3805 #CJK UNIFIED IDEOGRAPH
    {0xB9C5, 0x5609}, //3806 #CJK UNIFIED IDEOGRAPH
    {0xB9C6, 0x560D}, //3807 #CJK UNIFIED IDEOGRAPH
    {0xB9C7, 0x560E}, //3808 #CJK UNIFIED IDEOGRAPH
    {0xB9C8, 0x55F7}, //3809 #CJK UNIFIED IDEOGRAPH
    {0xB9C9, 0x5616}, //3810 #CJK UNIFIED IDEOGRAPH
    {0xB9CA, 0x561F}, //3811 #CJK UNIFIED IDEOGRAPH
    {0xB9CB, 0x5608}, //3812 #CJK UNIFIED IDEOGRAPH
    {0xB9CC, 0x5610}, //3813 #CJK UNIFIED IDEOGRAPH
    {0xB9CD, 0x55F6}, //3814 #CJK UNIFIED IDEOGRAPH
    {0xB9CE, 0x5718}, //3815 #CJK UNIFIED IDEOGRAPH
    {0xB9CF, 0x5716}, //3816 #CJK UNIFIED IDEOGRAPH
    {0xB9D0, 0x5875}, //3817 #CJK UNIFIED IDEOGRAPH
    {0xB9D1, 0x587E}, //3818 #CJK UNIFIED IDEOGRAPH
    {0xB9D2, 0x5883}, //3819 #CJK UNIFIED IDEOGRAPH
    {0xB9D3, 0x5893}, //3820 #CJK UNIFIED IDEOGRAPH
    {0xB9D4, 0x588A}, //3821 #CJK UNIFIED IDEOGRAPH
    {0xB9D5, 0x5879}, //3822 #CJK UNIFIED IDEOGRAPH
    {0xB9D6, 0x5885}, //3823 #CJK UNIFIED IDEOGRAPH
    {0xB9D7, 0x587D}, //3824 #CJK UNIFIED IDEOGRAPH
    {0xB9D8, 0x58FD}, //3825 #CJK UNIFIED IDEOGRAPH
    {0xB9D9, 0x5925}, //3826 #CJK UNIFIED IDEOGRAPH
    {0xB9DA, 0x5922}, //3827 #CJK UNIFIED IDEOGRAPH
    {0xB9DB, 0x5924}, //3828 #CJK UNIFIED IDEOGRAPH
    {0xB9DC, 0x596A}, //3829 #CJK UNIFIED IDEOGRAPH
    {0xB9DD, 0x5969}, //3830 #CJK UNIFIED IDEOGRAPH
    {0xB9DE, 0x5AE1}, //3831 #CJK UNIFIED IDEOGRAPH
    {0xB9DF, 0x5AE6}, //3832 #CJK UNIFIED IDEOGRAPH
    {0xB9E0, 0x5AE9}, //3833 #CJK UNIFIED IDEOGRAPH
    {0xB9E1, 0x5AD7}, //3834 #CJK UNIFIED IDEOGRAPH
    {0xB9E2, 0x5AD6}, //3835 #CJK UNIFIED IDEOGRAPH
    {0xB9E3, 0x5AD8}, //3836 #CJK UNIFIED IDEOGRAPH
    {0xB9E4, 0x5AE3}, //3837 #CJK UNIFIED IDEOGRAPH
    {0xB9E5, 0x5B75}, //3838 #CJK UNIFIED IDEOGRAPH
    {0xB9E6, 0x5BDE}, //3839 #CJK UNIFIED IDEOGRAPH
    {0xB9E7, 0x5BE7}, //3840 #CJK UNIFIED IDEOGRAPH
    {0xB9E8, 0x5BE1}, //3841 #CJK UNIFIED IDEOGRAPH
    {0xB9E9, 0x5BE5}, //3842 #CJK UNIFIED IDEOGRAPH
    {0xB9EA, 0x5BE6}, //3843 #CJK UNIFIED IDEOGRAPH
    {0xB9EB, 0x5BE8}, //3844 #CJK UNIFIED IDEOGRAPH
    {0xB9EC, 0x5BE2}, //3845 #CJK UNIFIED IDEOGRAPH
    {0xB9ED, 0x5BE4}, //3846 #CJK UNIFIED IDEOGRAPH
    {0xB9EE, 0x5BDF}, //3847 #CJK UNIFIED IDEOGRAPH
    {0xB9EF, 0x5C0D}, //3848 #CJK UNIFIED IDEOGRAPH
    {0xB9F0, 0x5C62}, //3849 #CJK UNIFIED IDEOGRAPH
    {0xB9F1, 0x5D84}, //3850 #CJK UNIFIED IDEOGRAPH
    {0xB9F2, 0x5D87}, //3851 #CJK UNIFIED IDEOGRAPH
    {0xB9F3, 0x5E5B}, //3852 #CJK UNIFIED IDEOGRAPH
    {0xB9F4, 0x5E63}, //3853 #CJK UNIFIED IDEOGRAPH
    {0xB9F5, 0x5E55}, //3854 #CJK UNIFIED IDEOGRAPH
    {0xB9F6, 0x5E57}, //3855 #CJK UNIFIED IDEOGRAPH
    {0xB9F7, 0x5E54}, //3856 #CJK UNIFIED IDEOGRAPH
    {0xB9F8, 0x5ED3}, //3857 #CJK UNIFIED IDEOGRAPH
    {0xB9F9, 0x5ED6}, //3858 #CJK UNIFIED IDEOGRAPH
    {0xB9FA, 0x5F0A}, //3859 #CJK UNIFIED IDEOGRAPH
    {0xB9FB, 0x5F46}, //3860 #CJK UNIFIED IDEOGRAPH
    {0xB9FC, 0x5F70}, //3861 #CJK UNIFIED IDEOGRAPH
    {0xB9FD, 0x5FB9}, //3862 #CJK UNIFIED IDEOGRAPH
    {0xB9FE, 0x6147}, //3863 #CJK UNIFIED IDEOGRAPH
    {0xBA40, 0x613F}, //3864 #CJK UNIFIED IDEOGRAPH
    {0xBA41, 0x614B}, //3865 #CJK UNIFIED IDEOGRAPH
    {0xBA42, 0x6177}, //3866 #CJK UNIFIED IDEOGRAPH
    {0xBA43, 0x6162}, //3867 #CJK UNIFIED IDEOGRAPH
    {0xBA44, 0x6163}, //3868 #CJK UNIFIED IDEOGRAPH
    {0xBA45, 0x615F}, //3869 #CJK UNIFIED IDEOGRAPH
    {0xBA46, 0x615A}, //3870 #CJK UNIFIED IDEOGRAPH
    {0xBA47, 0x6158}, //3871 #CJK UNIFIED IDEOGRAPH
    {0xBA48, 0x6175}, //3872 #CJK UNIFIED IDEOGRAPH
    {0xBA49, 0x622A}, //3873 #CJK UNIFIED IDEOGRAPH
    {0xBA4A, 0x6487}, //3874 #CJK UNIFIED IDEOGRAPH
    {0xBA4B, 0x6458}, //3875 #CJK UNIFIED IDEOGRAPH
    {0xBA4C, 0x6454}, //3876 #CJK UNIFIED IDEOGRAPH
    {0xBA4D, 0x64A4}, //3877 #CJK UNIFIED IDEOGRAPH
    {0xBA4E, 0x6478}, //3878 #CJK UNIFIED IDEOGRAPH
    {0xBA4F, 0x645F}, //3879 #CJK UNIFIED IDEOGRAPH
    {0xBA50, 0x647A}, //3880 #CJK UNIFIED IDEOGRAPH
    {0xBA51, 0x6451}, //3881 #CJK UNIFIED IDEOGRAPH
    {0xBA52, 0x6467}, //3882 #CJK UNIFIED IDEOGRAPH
    {0xBA53, 0x6434}, //3883 #CJK UNIFIED IDEOGRAPH
    {0xBA54, 0x646D}, //3884 #CJK UNIFIED IDEOGRAPH
    {0xBA55, 0x647B}, //3885 #CJK UNIFIED IDEOGRAPH
    {0xBA56, 0x6572}, //3886 #CJK UNIFIED IDEOGRAPH
    {0xBA57, 0x65A1}, //3887 #CJK UNIFIED IDEOGRAPH
    {0xBA58, 0x65D7}, //3888 #CJK UNIFIED IDEOGRAPH
    {0xBA59, 0x65D6}, //3889 #CJK UNIFIED IDEOGRAPH
    {0xBA5A, 0x66A2}, //3890 #CJK UNIFIED IDEOGRAPH
    {0xBA5B, 0x66A8}, //3891 #CJK UNIFIED IDEOGRAPH
    {0xBA5C, 0x669D}, //3892 #CJK UNIFIED IDEOGRAPH
    {0xBA5D, 0x699C}, //3893 #CJK UNIFIED IDEOGRAPH
    {0xBA5E, 0x69A8}, //3894 #CJK UNIFIED IDEOGRAPH
    {0xBA5F, 0x6995}, //3895 #CJK UNIFIED IDEOGRAPH
    {0xBA60, 0x69C1}, //3896 #CJK UNIFIED IDEOGRAPH
    {0xBA61, 0x69AE}, //3897 #CJK UNIFIED IDEOGRAPH
    {0xBA62, 0x69D3}, //3898 #CJK UNIFIED IDEOGRAPH
    {0xBA63, 0x69CB}, //3899 #CJK UNIFIED IDEOGRAPH
    {0xBA64, 0x699B}, //3900 #CJK UNIFIED IDEOGRAPH
    {0xBA65, 0x69B7}, //3901 #CJK UNIFIED IDEOGRAPH
    {0xBA66, 0x69BB}, //3902 #CJK UNIFIED IDEOGRAPH
    {0xBA67, 0x69AB}, //3903 #CJK UNIFIED IDEOGRAPH
    {0xBA68, 0x69B4}, //3904 #CJK UNIFIED IDEOGRAPH
    {0xBA69, 0x69D0}, //3905 #CJK UNIFIED IDEOGRAPH
    {0xBA6A, 0x69CD}, //3906 #CJK UNIFIED IDEOGRAPH
    {0xBA6B, 0x69AD}, //3907 #CJK UNIFIED IDEOGRAPH
    {0xBA6C, 0x69CC}, //3908 #CJK UNIFIED IDEOGRAPH
    {0xBA6D, 0x69A6}, //3909 #CJK UNIFIED IDEOGRAPH
    {0xBA6E, 0x69C3}, //3910 #CJK UNIFIED IDEOGRAPH
    {0xBA6F, 0x69A3}, //3911 #CJK UNIFIED IDEOGRAPH
    {0xBA70, 0x6B49}, //3912 #CJK UNIFIED IDEOGRAPH
    {0xBA71, 0x6B4C}, //3913 #CJK UNIFIED IDEOGRAPH
    {0xBA72, 0x6C33}, //3914 #CJK UNIFIED IDEOGRAPH
    {0xBA73, 0x6F33}, //3915 #CJK UNIFIED IDEOGRAPH
    {0xBA74, 0x6F14}, //3916 #CJK UNIFIED IDEOGRAPH
    {0xBA75, 0x6EFE}, //3917 #CJK UNIFIED IDEOGRAPH
    {0xBA76, 0x6F13}, //3918 #CJK UNIFIED IDEOGRAPH
    {0xBA77, 0x6EF4}, //3919 #CJK UNIFIED IDEOGRAPH
    {0xBA78, 0x6F29}, //3920 #CJK UNIFIED IDEOGRAPH
    {0xBA79, 0x6F3E}, //3921 #CJK UNIFIED IDEOGRAPH
    {0xBA7A, 0x6F20}, //3922 #CJK UNIFIED IDEOGRAPH
    {0xBA7B, 0x6F2C}, //3923 #CJK UNIFIED IDEOGRAPH
    {0xBA7C, 0x6F0F}, //3924 #CJK UNIFIED IDEOGRAPH
    {0xBA7D, 0x6F02}, //3925 #CJK UNIFIED IDEOGRAPH
    {0xBA7E, 0x6F22}, //3926 #CJK UNIFIED IDEOGRAPH
    {0xBAA1, 0x6EFF}, //3927 #CJK UNIFIED IDEOGRAPH
    {0xBAA2, 0x6EEF}, //3928 #CJK UNIFIED IDEOGRAPH
    {0xBAA3, 0x6F06}, //3929 #CJK UNIFIED IDEOGRAPH
    {0xBAA4, 0x6F31}, //3930 #CJK UNIFIED IDEOGRAPH
    {0xBAA5, 0x6F38}, //3931 #CJK UNIFIED IDEOGRAPH
    {0xBAA6, 0x6F32}, //3932 #CJK UNIFIED IDEOGRAPH
    {0xBAA7, 0x6F23}, //3933 #CJK UNIFIED IDEOGRAPH
    {0xBAA8, 0x6F15}, //3934 #CJK UNIFIED IDEOGRAPH
    {0xBAA9, 0x6F2B}, //3935 #CJK UNIFIED IDEOGRAPH
    {0xBAAA, 0x6F2F}, //3936 #CJK UNIFIED IDEOGRAPH
    {0xBAAB, 0x6F88}, //3937 #CJK UNIFIED IDEOGRAPH
    {0xBAAC, 0x6F2A}, //3938 #CJK UNIFIED IDEOGRAPH
    {0xBAAD, 0x6EEC}, //3939 #CJK UNIFIED IDEOGRAPH
    {0xBAAE, 0x6F01}, //3940 #CJK UNIFIED IDEOGRAPH
    {0xBAAF, 0x6EF2}, //3941 #CJK UNIFIED IDEOGRAPH
    {0xBAB0, 0x6ECC}, //3942 #CJK UNIFIED IDEOGRAPH
    {0xBAB1, 0x6EF7}, //3943 #CJK UNIFIED IDEOGRAPH
    {0xBAB2, 0x7194}, //3944 #CJK UNIFIED IDEOGRAPH
    {0xBAB3, 0x7199}, //3945 #CJK UNIFIED IDEOGRAPH
    {0xBAB4, 0x717D}, //3946 #CJK UNIFIED IDEOGRAPH
    {0xBAB5, 0x718A}, //3947 #CJK UNIFIED IDEOGRAPH
    {0xBAB6, 0x7184}, //3948 #CJK UNIFIED IDEOGRAPH
    {0xBAB7, 0x7192}, //3949 #CJK UNIFIED IDEOGRAPH
    {0xBAB8, 0x723E}, //3950 #CJK UNIFIED IDEOGRAPH
    {0xBAB9, 0x7292}, //3951 #CJK UNIFIED IDEOGRAPH
    {0xBABA, 0x7296}, //3952 #CJK UNIFIED IDEOGRAPH
    {0xBABB, 0x7344}, //3953 #CJK UNIFIED IDEOGRAPH
    {0xBABC, 0x7350}, //3954 #CJK UNIFIED IDEOGRAPH
    {0xBABD, 0x7464}, //3955 #CJK UNIFIED IDEOGRAPH
    {0xBABE, 0x7463}, //3956 #CJK UNIFIED IDEOGRAPH
    {0xBABF, 0x746A}, //3957 #CJK UNIFIED IDEOGRAPH
    {0xBAC0, 0x7470}, //3958 #CJK UNIFIED IDEOGRAPH
    {0xBAC1, 0x746D}, //3959 #CJK UNIFIED IDEOGRAPH
    {0xBAC2, 0x7504}, //3960 #CJK UNIFIED IDEOGRAPH
    {0xBAC3, 0x7591}, //3961 #CJK UNIFIED IDEOGRAPH
    {0xBAC4, 0x7627}, //3962 #CJK UNIFIED IDEOGRAPH
    {0xBAC5, 0x760D}, //3963 #CJK UNIFIED IDEOGRAPH
    {0xBAC6, 0x760B}, //3964 #CJK UNIFIED IDEOGRAPH
    {0xBAC7, 0x7609}, //3965 #CJK UNIFIED IDEOGRAPH
    {0xBAC8, 0x7613}, //3966 #CJK UNIFIED IDEOGRAPH
    {0xBAC9, 0x76E1}, //3967 #CJK UNIFIED IDEOGRAPH
    {0xBACA, 0x76E3}, //3968 #CJK UNIFIED IDEOGRAPH
    {0xBACB, 0x7784}, //3969 #CJK UNIFIED IDEOGRAPH
    {0xBACC, 0x777D}, //3970 #CJK UNIFIED IDEOGRAPH
    {0xBACD, 0x777F}, //3971 #CJK UNIFIED IDEOGRAPH
    {0xBACE, 0x7761}, //3972 #CJK UNIFIED IDEOGRAPH
    {0xBACF, 0x78C1}, //3973 #CJK UNIFIED IDEOGRAPH
    {0xBAD0, 0x789F}, //3974 #CJK UNIFIED IDEOGRAPH
    {0xBAD1, 0x78A7}, //3975 #CJK UNIFIED IDEOGRAPH
    {0xBAD2, 0x78B3}, //3976 #CJK UNIFIED IDEOGRAPH
    {0xBAD3, 0x78A9}, //3977 #CJK UNIFIED IDEOGRAPH
    {0xBAD4, 0x78A3}, //3978 #CJK UNIFIED IDEOGRAPH
    {0xBAD5, 0x798E}, //3979 #CJK UNIFIED IDEOGRAPH
    {0xBAD6, 0x798F}, //3980 #CJK UNIFIED IDEOGRAPH
    {0xBAD7, 0x798D}, //3981 #CJK UNIFIED IDEOGRAPH
    {0xBAD8, 0x7A2E}, //3982 #CJK UNIFIED IDEOGRAPH
    {0xBAD9, 0x7A31}, //3983 #CJK UNIFIED IDEOGRAPH
    {0xBADA, 0x7AAA}, //3984 #CJK UNIFIED IDEOGRAPH
    {0xBADB, 0x7AA9}, //3985 #CJK UNIFIED IDEOGRAPH
    {0xBADC, 0x7AED}, //3986 #CJK UNIFIED IDEOGRAPH
    {0xBADD, 0x7AEF}, //3987 #CJK UNIFIED IDEOGRAPH
    {0xBADE, 0x7BA1}, //3988 #CJK UNIFIED IDEOGRAPH
    {0xBADF, 0x7B95}, //3989 #CJK UNIFIED IDEOGRAPH
    {0xBAE0, 0x7B8B}, //3990 #CJK UNIFIED IDEOGRAPH
    {0xBAE1, 0x7B75}, //3991 #CJK UNIFIED IDEOGRAPH
    {0xBAE2, 0x7B97}, //3992 #CJK UNIFIED IDEOGRAPH
    {0xBAE3, 0x7B9D}, //3993 #CJK UNIFIED IDEOGRAPH
    {0xBAE4, 0x7B94}, //3994 #CJK UNIFIED IDEOGRAPH
    {0xBAE5, 0x7B8F}, //3995 #CJK UNIFIED IDEOGRAPH
    {0xBAE6, 0x7BB8}, //3996 #CJK UNIFIED IDEOGRAPH
    {0xBAE7, 0x7B87}, //3997 #CJK UNIFIED IDEOGRAPH
    {0xBAE8, 0x7B84}, //3998 #CJK UNIFIED IDEOGRAPH
    {0xBAE9, 0x7CB9}, //3999 #CJK UNIFIED IDEOGRAPH
    {0xBAEA, 0x7CBD}, //4000 #CJK UNIFIED IDEOGRAPH
    {0xBAEB, 0x7CBE}, //4001 #CJK UNIFIED IDEOGRAPH
    {0xBAEC, 0x7DBB}, //4002 #CJK UNIFIED IDEOGRAPH
    {0xBAED, 0x7DB0}, //4003 #CJK UNIFIED IDEOGRAPH
    {0xBAEE, 0x7D9C}, //4004 #CJK UNIFIED IDEOGRAPH
    {0xBAEF, 0x7DBD}, //4005 #CJK UNIFIED IDEOGRAPH
    {0xBAF0, 0x7DBE}, //4006 #CJK UNIFIED IDEOGRAPH
    {0xBAF1, 0x7DA0}, //4007 #CJK UNIFIED IDEOGRAPH
    {0xBAF2, 0x7DCA}, //4008 #CJK UNIFIED IDEOGRAPH
    {0xBAF3, 0x7DB4}, //4009 #CJK UNIFIED IDEOGRAPH
    {0xBAF4, 0x7DB2}, //4010 #CJK UNIFIED IDEOGRAPH
    {0xBAF5, 0x7DB1}, //4011 #CJK UNIFIED IDEOGRAPH
    {0xBAF6, 0x7DBA}, //4012 #CJK UNIFIED IDEOGRAPH
    {0xBAF7, 0x7DA2}, //4013 #CJK UNIFIED IDEOGRAPH
    {0xBAF8, 0x7DBF}, //4014 #CJK UNIFIED IDEOGRAPH
    {0xBAF9, 0x7DB5}, //4015 #CJK UNIFIED IDEOGRAPH
    {0xBAFA, 0x7DB8}, //4016 #CJK UNIFIED IDEOGRAPH
    {0xBAFB, 0x7DAD}, //4017 #CJK UNIFIED IDEOGRAPH
    {0xBAFC, 0x7DD2}, //4018 #CJK UNIFIED IDEOGRAPH
    {0xBAFD, 0x7DC7}, //4019 #CJK UNIFIED IDEOGRAPH
    {0xBAFE, 0x7DAC}, //4020 #CJK UNIFIED IDEOGRAPH
    {0xBB40, 0x7F70}, //4021 #CJK UNIFIED IDEOGRAPH
    {0xBB41, 0x7FE0}, //4022 #CJK UNIFIED IDEOGRAPH
    {0xBB42, 0x7FE1}, //4023 #CJK UNIFIED IDEOGRAPH
    {0xBB43, 0x7FDF}, //4024 #CJK UNIFIED IDEOGRAPH
    {0xBB44, 0x805E}, //4025 #CJK UNIFIED IDEOGRAPH
    {0xBB45, 0x805A}, //4026 #CJK UNIFIED IDEOGRAPH
    {0xBB46, 0x8087}, //4027 #CJK UNIFIED IDEOGRAPH
    {0xBB47, 0x8150}, //4028 #CJK UNIFIED IDEOGRAPH
    {0xBB48, 0x8180}, //4029 #CJK UNIFIED IDEOGRAPH
    {0xBB49, 0x818F}, //4030 #CJK UNIFIED IDEOGRAPH
    {0xBB4A, 0x8188}, //4031 #CJK UNIFIED IDEOGRAPH
    {0xBB4B, 0x818A}, //4032 #CJK UNIFIED IDEOGRAPH
    {0xBB4C, 0x817F}, //4033 #CJK UNIFIED IDEOGRAPH
    {0xBB4D, 0x8182}, //4034 #CJK UNIFIED IDEOGRAPH
    {0xBB4E, 0x81E7}, //4035 #CJK UNIFIED IDEOGRAPH
    {0xBB4F, 0x81FA}, //4036 #CJK UNIFIED IDEOGRAPH
    {0xBB50, 0x8207}, //4037 #CJK UNIFIED IDEOGRAPH
    {0xBB51, 0x8214}, //4038 #CJK UNIFIED IDEOGRAPH
    {0xBB52, 0x821E}, //4039 #CJK UNIFIED IDEOGRAPH
    {0xBB53, 0x824B}, //4040 #CJK UNIFIED IDEOGRAPH
    {0xBB54, 0x84C9}, //4041 #CJK UNIFIED IDEOGRAPH
    {0xBB55, 0x84BF}, //4042 #CJK UNIFIED IDEOGRAPH
    {0xBB56, 0x84C6}, //4043 #CJK UNIFIED IDEOGRAPH
    {0xBB57, 0x84C4}, //4044 #CJK UNIFIED IDEOGRAPH
    {0xBB58, 0x8499}, //4045 #CJK UNIFIED IDEOGRAPH
    {0xBB59, 0x849E}, //4046 #CJK UNIFIED IDEOGRAPH
    {0xBB5A, 0x84B2}, //4047 #CJK UNIFIED IDEOGRAPH
    {0xBB5B, 0x849C}, //4048 #CJK UNIFIED IDEOGRAPH
    {0xBB5C, 0x84CB}, //4049 #CJK UNIFIED IDEOGRAPH
    {0xBB5D, 0x84B8}, //4050 #CJK UNIFIED IDEOGRAPH
    {0xBB5E, 0x84C0}, //4051 #CJK UNIFIED IDEOGRAPH
    {0xBB5F, 0x84D3}, //4052 #CJK UNIFIED IDEOGRAPH
    {0xBB60, 0x8490}, //4053 #CJK UNIFIED IDEOGRAPH
    {0xBB61, 0x84BC}, //4054 #CJK UNIFIED IDEOGRAPH
    {0xBB62, 0x84D1}, //4055 #CJK UNIFIED IDEOGRAPH
    {0xBB63, 0x84CA}, //4056 #CJK UNIFIED IDEOGRAPH
    {0xBB64, 0x873F}, //4057 #CJK UNIFIED IDEOGRAPH
    {0xBB65, 0x871C}, //4058 #CJK UNIFIED IDEOGRAPH
    {0xBB66, 0x873B}, //4059 #CJK UNIFIED IDEOGRAPH
    {0xBB67, 0x8722}, //4060 #CJK UNIFIED IDEOGRAPH
    {0xBB68, 0x8725}, //4061 #CJK UNIFIED IDEOGRAPH
    {0xBB69, 0x8734}, //4062 #CJK UNIFIED IDEOGRAPH
    {0xBB6A, 0x8718}, //4063 #CJK UNIFIED IDEOGRAPH
    {0xBB6B, 0x8755}, //4064 #CJK UNIFIED IDEOGRAPH
    {0xBB6C, 0x8737}, //4065 #CJK UNIFIED IDEOGRAPH
    {0xBB6D, 0x8729}, //4066 #CJK UNIFIED IDEOGRAPH
    {0xBB6E, 0x88F3}, //4067 #CJK UNIFIED IDEOGRAPH
    {0xBB6F, 0x8902}, //4068 #CJK UNIFIED IDEOGRAPH
    {0xBB70, 0x88F4}, //4069 #CJK UNIFIED IDEOGRAPH
    {0xBB71, 0x88F9}, //4070 #CJK UNIFIED IDEOGRAPH
    {0xBB72, 0x88F8}, //4071 #CJK UNIFIED IDEOGRAPH
    {0xBB73, 0x88FD}, //4072 #CJK UNIFIED IDEOGRAPH
    {0xBB74, 0x88E8}, //4073 #CJK UNIFIED IDEOGRAPH
    {0xBB75, 0x891A}, //4074 #CJK UNIFIED IDEOGRAPH
    {0xBB76, 0x88EF}, //4075 #CJK UNIFIED IDEOGRAPH
    {0xBB77, 0x8AA6}, //4076 #CJK UNIFIED IDEOGRAPH
    {0xBB78, 0x8A8C}, //4077 #CJK UNIFIED IDEOGRAPH
    {0xBB79, 0x8A9E}, //4078 #CJK UNIFIED IDEOGRAPH
    {0xBB7A, 0x8AA3}, //4079 #CJK UNIFIED IDEOGRAPH
    {0xBB7B, 0x8A8D}, //4080 #CJK UNIFIED IDEOGRAPH
    {0xBB7C, 0x8AA1}, //4081 #CJK UNIFIED IDEOGRAPH
    {0xBB7D, 0x8A93}, //4082 #CJK UNIFIED IDEOGRAPH
    {0xBB7E, 0x8AA4}, //4083 #CJK UNIFIED IDEOGRAPH
    {0xBBA1, 0x8AAA}, //4084 #CJK UNIFIED IDEOGRAPH
    {0xBBA2, 0x8AA5}, //4085 #CJK UNIFIED IDEOGRAPH
    {0xBBA3, 0x8AA8}, //4086 #CJK UNIFIED IDEOGRAPH
    {0xBBA4, 0x8A98}, //4087 #CJK UNIFIED IDEOGRAPH
    {0xBBA5, 0x8A91}, //4088 #CJK UNIFIED IDEOGRAPH
    {0xBBA6, 0x8A9A}, //4089 #CJK UNIFIED IDEOGRAPH
    {0xBBA7, 0x8AA7}, //4090 #CJK UNIFIED IDEOGRAPH
    {0xBBA8, 0x8C6A}, //4091 #CJK UNIFIED IDEOGRAPH
    {0xBBA9, 0x8C8D}, //4092 #CJK UNIFIED IDEOGRAPH
    {0xBBAA, 0x8C8C}, //4093 #CJK UNIFIED IDEOGRAPH
    {0xBBAB, 0x8CD3}, //4094 #CJK UNIFIED IDEOGRAPH
    {0xBBAC, 0x8CD1}, //4095 #CJK UNIFIED IDEOGRAPH
    {0xBBAD, 0x8CD2}, //4096 #CJK UNIFIED IDEOGRAPH
    {0xBBAE, 0x8D6B}, //4097 #CJK UNIFIED IDEOGRAPH
    {0xBBAF, 0x8D99}, //4098 #CJK UNIFIED IDEOGRAPH
    {0xBBB0, 0x8D95}, //4099 #CJK UNIFIED IDEOGRAPH
    {0xBBB1, 0x8DFC}, //4100 #CJK UNIFIED IDEOGRAPH
    {0xBBB2, 0x8F14}, //4101 #CJK UNIFIED IDEOGRAPH
    {0xBBB3, 0x8F12}, //4102 #CJK UNIFIED IDEOGRAPH
    {0xBBB4, 0x8F15}, //4103 #CJK UNIFIED IDEOGRAPH
    {0xBBB5, 0x8F13}, //4104 #CJK UNIFIED IDEOGRAPH
    {0xBBB6, 0x8FA3}, //4105 #CJK UNIFIED IDEOGRAPH
    {0xBBB7, 0x9060}, //4106 #CJK UNIFIED IDEOGRAPH
    {0xBBB8, 0x9058}, //4107 #CJK UNIFIED IDEOGRAPH
    {0xBBB9, 0x905C}, //4108 #CJK UNIFIED IDEOGRAPH
    {0xBBBA, 0x9063}, //4109 #CJK UNIFIED IDEOGRAPH
    {0xBBBB, 0x9059}, //4110 #CJK UNIFIED IDEOGRAPH
    {0xBBBC, 0x905E}, //4111 #CJK UNIFIED IDEOGRAPH
    {0xBBBD, 0x9062}, //4112 #CJK UNIFIED IDEOGRAPH
    {0xBBBE, 0x905D}, //4113 #CJK UNIFIED IDEOGRAPH
    {0xBBBF, 0x905B}, //4114 #CJK UNIFIED IDEOGRAPH
    {0xBBC0, 0x9119}, //4115 #CJK UNIFIED IDEOGRAPH
    {0xBBC1, 0x9118}, //4116 #CJK UNIFIED IDEOGRAPH
    {0xBBC2, 0x911E}, //4117 #CJK UNIFIED IDEOGRAPH
    {0xBBC3, 0x9175}, //4118 #CJK UNIFIED IDEOGRAPH
    {0xBBC4, 0x9178}, //4119 #CJK UNIFIED IDEOGRAPH
    {0xBBC5, 0x9177}, //4120 #CJK UNIFIED IDEOGRAPH
    {0xBBC6, 0x9174}, //4121 #CJK UNIFIED IDEOGRAPH
    {0xBBC7, 0x9278}, //4122 #CJK UNIFIED IDEOGRAPH
    {0xBBC8, 0x9280}, //4123 #CJK UNIFIED IDEOGRAPH
    {0xBBC9, 0x9285}, //4124 #CJK UNIFIED IDEOGRAPH
    {0xBBCA, 0x9298}, //4125 #CJK UNIFIED IDEOGRAPH
    {0xBBCB, 0x9296}, //4126 #CJK UNIFIED IDEOGRAPH
    {0xBBCC, 0x927B}, //4127 #CJK UNIFIED IDEOGRAPH
    {0xBBCD, 0x9293}, //4128 #CJK UNIFIED IDEOGRAPH
    {0xBBCE, 0x929C}, //4129 #CJK UNIFIED IDEOGRAPH
    {0xBBCF, 0x92A8}, //4130 #CJK UNIFIED IDEOGRAPH
    {0xBBD0, 0x927C}, //4131 #CJK UNIFIED IDEOGRAPH
    {0xBBD1, 0x9291}, //4132 #CJK UNIFIED IDEOGRAPH
    {0xBBD2, 0x95A1}, //4133 #CJK UNIFIED IDEOGRAPH
    {0xBBD3, 0x95A8}, //4134 #CJK UNIFIED IDEOGRAPH
    {0xBBD4, 0x95A9}, //4135 #CJK UNIFIED IDEOGRAPH
    {0xBBD5, 0x95A3}, //4136 #CJK UNIFIED IDEOGRAPH
    {0xBBD6, 0x95A5}, //4137 #CJK UNIFIED IDEOGRAPH
    {0xBBD7, 0x95A4}, //4138 #CJK UNIFIED IDEOGRAPH
    {0xBBD8, 0x9699}, //4139 #CJK UNIFIED IDEOGRAPH
    {0xBBD9, 0x969C}, //4140 #CJK UNIFIED IDEOGRAPH
    {0xBBDA, 0x969B}, //4141 #CJK UNIFIED IDEOGRAPH
    {0xBBDB, 0x96CC}, //4142 #CJK UNIFIED IDEOGRAPH
    {0xBBDC, 0x96D2}, //4143 #CJK UNIFIED IDEOGRAPH
    {0xBBDD, 0x9700}, //4144 #CJK UNIFIED IDEOGRAPH
    {0xBBDE, 0x977C}, //4145 #CJK UNIFIED IDEOGRAPH
    {0xBBDF, 0x9785}, //4146 #CJK UNIFIED IDEOGRAPH
    {0xBBE0, 0x97F6}, //4147 #CJK UNIFIED IDEOGRAPH
    {0xBBE1, 0x9817}, //4148 #CJK UNIFIED IDEOGRAPH
    {0xBBE2, 0x9818}, //4149 #CJK UNIFIED IDEOGRAPH
    {0xBBE3, 0x98AF}, //4150 #CJK UNIFIED IDEOGRAPH
    {0xBBE4, 0x98B1}, //4151 #CJK UNIFIED IDEOGRAPH
    {0xBBE5, 0x9903}, //4152 #CJK UNIFIED IDEOGRAPH
    {0xBBE6, 0x9905}, //4153 #CJK UNIFIED IDEOGRAPH
    {0xBBE7, 0x990C}, //4154 #CJK UNIFIED IDEOGRAPH
    {0xBBE8, 0x9909}, //4155 #CJK UNIFIED IDEOGRAPH
    {0xBBE9, 0x99C1}, //4156 #CJK UNIFIED IDEOGRAPH
    {0xBBEA, 0x9AAF}, //4157 #CJK UNIFIED IDEOGRAPH
    {0xBBEB, 0x9AB0}, //4158 #CJK UNIFIED IDEOGRAPH
    {0xBBEC, 0x9AE6}, //4159 #CJK UNIFIED IDEOGRAPH
    {0xBBED, 0x9B41}, //4160 #CJK UNIFIED IDEOGRAPH
    {0xBBEE, 0x9B42}, //4161 #CJK UNIFIED IDEOGRAPH
    {0xBBEF, 0x9CF4}, //4162 #CJK UNIFIED IDEOGRAPH
    {0xBBF0, 0x9CF6}, //4163 #CJK UNIFIED IDEOGRAPH
    {0xBBF1, 0x9CF3}, //4164 #CJK UNIFIED IDEOGRAPH
    {0xBBF2, 0x9EBC}, //4165 #CJK UNIFIED IDEOGRAPH
    {0xBBF3, 0x9F3B}, //4166 #CJK UNIFIED IDEOGRAPH
    {0xBBF4, 0x9F4A}, //4167 #CJK UNIFIED IDEOGRAPH
    {0xBBF5, 0x5104}, //4168 #CJK UNIFIED IDEOGRAPH
    {0xBBF6, 0x5100}, //4169 #CJK UNIFIED IDEOGRAPH
    {0xBBF7, 0x50FB}, //4170 #CJK UNIFIED IDEOGRAPH
    {0xBBF8, 0x50F5}, //4171 #CJK UNIFIED IDEOGRAPH
    {0xBBF9, 0x50F9}, //4172 #CJK UNIFIED IDEOGRAPH
    {0xBBFA, 0x5102}, //4173 #CJK UNIFIED IDEOGRAPH
    {0xBBFB, 0x5108}, //4174 #CJK UNIFIED IDEOGRAPH
    {0xBBFC, 0x5109}, //4175 #CJK UNIFIED IDEOGRAPH
    {0xBBFD, 0x5105}, //4176 #CJK UNIFIED IDEOGRAPH
    {0xBBFE, 0x51DC}, //4177 #CJK UNIFIED IDEOGRAPH
    {0xBC40, 0x5287}, //4178 #CJK UNIFIED IDEOGRAPH
    {0xBC41, 0x5288}, //4179 #CJK UNIFIED IDEOGRAPH
    {0xBC42, 0x5289}, //4180 #CJK UNIFIED IDEOGRAPH
    {0xBC43, 0x528D}, //4181 #CJK UNIFIED IDEOGRAPH
    {0xBC44, 0x528A}, //4182 #CJK UNIFIED IDEOGRAPH
    {0xBC45, 0x52F0}, //4183 #CJK UNIFIED IDEOGRAPH
    {0xBC46, 0x53B2}, //4184 #CJK UNIFIED IDEOGRAPH
    {0xBC47, 0x562E}, //4185 #CJK UNIFIED IDEOGRAPH
    {0xBC48, 0x563B}, //4186 #CJK UNIFIED IDEOGRAPH
    {0xBC49, 0x5639}, //4187 #CJK UNIFIED IDEOGRAPH
    {0xBC4A, 0x5632}, //4188 #CJK UNIFIED IDEOGRAPH
    {0xBC4B, 0x563F}, //4189 #CJK UNIFIED IDEOGRAPH
    {0xBC4C, 0x5634}, //4190 #CJK UNIFIED IDEOGRAPH
    {0xBC4D, 0x5629}, //4191 #CJK UNIFIED IDEOGRAPH
    {0xBC4E, 0x5653}, //4192 #CJK UNIFIED IDEOGRAPH
    {0xBC4F, 0x564E}, //4193 #CJK UNIFIED IDEOGRAPH
    {0xBC50, 0x5657}, //4194 #CJK UNIFIED IDEOGRAPH
    {0xBC51, 0x5674}, //4195 #CJK UNIFIED IDEOGRAPH
    {0xBC52, 0x5636}, //4196 #CJK UNIFIED IDEOGRAPH
    {0xBC53, 0x562F}, //4197 #CJK UNIFIED IDEOGRAPH
    {0xBC54, 0x5630}, //4198 #CJK UNIFIED IDEOGRAPH
    {0xBC55, 0x5880}, //4199 #CJK UNIFIED IDEOGRAPH
    {0xBC56, 0x589F}, //4200 #CJK UNIFIED IDEOGRAPH
    {0xBC57, 0x589E}, //4201 #CJK UNIFIED IDEOGRAPH
    {0xBC58, 0x58B3}, //4202 #CJK UNIFIED IDEOGRAPH
    {0xBC59, 0x589C}, //4203 #CJK UNIFIED IDEOGRAPH
    {0xBC5A, 0x58AE}, //4204 #CJK UNIFIED IDEOGRAPH
    {0xBC5B, 0x58A9}, //4205 #CJK UNIFIED IDEOGRAPH
    {0xBC5C, 0x58A6}, //4206 #CJK UNIFIED IDEOGRAPH
    {0xBC5D, 0x596D}, //4207 #CJK UNIFIED IDEOGRAPH
    {0xBC5E, 0x5B09}, //4208 #CJK UNIFIED IDEOGRAPH
    {0xBC5F, 0x5AFB}, //4209 #CJK UNIFIED IDEOGRAPH
    {0xBC60, 0x5B0B}, //4210 #CJK UNIFIED IDEOGRAPH
    {0xBC61, 0x5AF5}, //4211 #CJK UNIFIED IDEOGRAPH
    {0xBC62, 0x5B0C}, //4212 #CJK UNIFIED IDEOGRAPH
    {0xBC63, 0x5B08}, //4213 #CJK UNIFIED IDEOGRAPH
    {0xBC64, 0x5BEE}, //4214 #CJK UNIFIED IDEOGRAPH
    {0xBC65, 0x5BEC}, //4215 #CJK UNIFIED IDEOGRAPH
    {0xBC66, 0x5BE9}, //4216 #CJK UNIFIED IDEOGRAPH
    {0xBC67, 0x5BEB}, //4217 #CJK UNIFIED IDEOGRAPH
    {0xBC68, 0x5C64}, //4218 #CJK UNIFIED IDEOGRAPH
    {0xBC69, 0x5C65}, //4219 #CJK UNIFIED IDEOGRAPH
    {0xBC6A, 0x5D9D}, //4220 #CJK UNIFIED IDEOGRAPH
    {0xBC6B, 0x5D94}, //4221 #CJK UNIFIED IDEOGRAPH
    {0xBC6C, 0x5E62}, //4222 #CJK UNIFIED IDEOGRAPH
    {0xBC6D, 0x5E5F}, //4223 #CJK UNIFIED IDEOGRAPH
    {0xBC6E, 0x5E61}, //4224 #CJK UNIFIED IDEOGRAPH
    {0xBC6F, 0x5EE2}, //4225 #CJK UNIFIED IDEOGRAPH
    {0xBC70, 0x5EDA}, //4226 #CJK UNIFIED IDEOGRAPH
    {0xBC71, 0x5EDF}, //4227 #CJK UNIFIED IDEOGRAPH
    {0xBC72, 0x5EDD}, //4228 #CJK UNIFIED IDEOGRAPH
    {0xBC73, 0x5EE3}, //4229 #CJK UNIFIED IDEOGRAPH
    {0xBC74, 0x5EE0}, //4230 #CJK UNIFIED IDEOGRAPH
    {0xBC75, 0x5F48}, //4231 #CJK UNIFIED IDEOGRAPH
    {0xBC76, 0x5F71}, //4232 #CJK UNIFIED IDEOGRAPH
    {0xBC77, 0x5FB7}, //4233 #CJK UNIFIED IDEOGRAPH
    {0xBC78, 0x5FB5}, //4234 #CJK UNIFIED IDEOGRAPH
    {0xBC79, 0x6176}, //4235 #CJK UNIFIED IDEOGRAPH
    {0xBC7A, 0x6167}, //4236 #CJK UNIFIED IDEOGRAPH
    {0xBC7B, 0x616E}, //4237 #CJK UNIFIED IDEOGRAPH
    {0xBC7C, 0x615D}, //4238 #CJK UNIFIED IDEOGRAPH
    {0xBC7D, 0x6155}, //4239 #CJK UNIFIED IDEOGRAPH
    {0xBC7E, 0x6182}, //4240 #CJK UNIFIED IDEOGRAPH
    {0xBCA1, 0x617C}, //4241 #CJK UNIFIED IDEOGRAPH
    {0xBCA2, 0x6170}, //4242 #CJK UNIFIED IDEOGRAPH
    {0xBCA3, 0x616B}, //4243 #CJK UNIFIED IDEOGRAPH
    {0xBCA4, 0x617E}, //4244 #CJK UNIFIED IDEOGRAPH
    {0xBCA5, 0x61A7}, //4245 #CJK UNIFIED IDEOGRAPH
    {0xBCA6, 0x6190}, //4246 #CJK UNIFIED IDEOGRAPH
    {0xBCA7, 0x61AB}, //4247 #CJK UNIFIED IDEOGRAPH
    {0xBCA8, 0x618E}, //4248 #CJK UNIFIED IDEOGRAPH
    {0xBCA9, 0x61AC}, //4249 #CJK UNIFIED IDEOGRAPH
    {0xBCAA, 0x619A}, //4250 #CJK UNIFIED IDEOGRAPH
    {0xBCAB, 0x61A4}, //4251 #CJK UNIFIED IDEOGRAPH
    {0xBCAC, 0x6194}, //4252 #CJK UNIFIED IDEOGRAPH
    {0xBCAD, 0x61AE}, //4253 #CJK UNIFIED IDEOGRAPH
    {0xBCAE, 0x622E}, //4254 #CJK UNIFIED IDEOGRAPH
    {0xBCAF, 0x6469}, //4255 #CJK UNIFIED IDEOGRAPH
    {0xBCB0, 0x646F}, //4256 #CJK UNIFIED IDEOGRAPH
    {0xBCB1, 0x6479}, //4257 #CJK UNIFIED IDEOGRAPH
    {0xBCB2, 0x649E}, //4258 #CJK UNIFIED IDEOGRAPH
    {0xBCB3, 0x64B2}, //4259 #CJK UNIFIED IDEOGRAPH
    {0xBCB4, 0x6488}, //4260 #CJK UNIFIED IDEOGRAPH
    {0xBCB5, 0x6490}, //4261 #CJK UNIFIED IDEOGRAPH
    {0xBCB6, 0x64B0}, //4262 #CJK UNIFIED IDEOGRAPH
    {0xBCB7, 0x64A5}, //4263 #CJK UNIFIED IDEOGRAPH
    {0xBCB8, 0x6493}, //4264 #CJK UNIFIED IDEOGRAPH
    {0xBCB9, 0x6495}, //4265 #CJK UNIFIED IDEOGRAPH
    {0xBCBA, 0x64A9}, //4266 #CJK UNIFIED IDEOGRAPH
    {0xBCBB, 0x6492}, //4267 #CJK UNIFIED IDEOGRAPH
    {0xBCBC, 0x64AE}, //4268 #CJK UNIFIED IDEOGRAPH
    {0xBCBD, 0x64AD}, //4269 #CJK UNIFIED IDEOGRAPH
    {0xBCBE, 0x64AB}, //4270 #CJK UNIFIED IDEOGRAPH
    {0xBCBF, 0x649A}, //4271 #CJK UNIFIED IDEOGRAPH
    {0xBCC0, 0x64AC}, //4272 #CJK UNIFIED IDEOGRAPH
    {0xBCC1, 0x6499}, //4273 #CJK UNIFIED IDEOGRAPH
    {0xBCC2, 0x64A2}, //4274 #CJK UNIFIED IDEOGRAPH
    {0xBCC3, 0x64B3}, //4275 #CJK UNIFIED IDEOGRAPH
    {0xBCC4, 0x6575}, //4276 #CJK UNIFIED IDEOGRAPH
    {0xBCC5, 0x6577}, //4277 #CJK UNIFIED IDEOGRAPH
    {0xBCC6, 0x6578}, //4278 #CJK UNIFIED IDEOGRAPH
    {0xBCC7, 0x66AE}, //4279 #CJK UNIFIED IDEOGRAPH
    {0xBCC8, 0x66AB}, //4280 #CJK UNIFIED IDEOGRAPH
    {0xBCC9, 0x66B4}, //4281 #CJK UNIFIED IDEOGRAPH
    {0xBCCA, 0x66B1}, //4282 #CJK UNIFIED IDEOGRAPH
    {0xBCCB, 0x6A23}, //4283 #CJK UNIFIED IDEOGRAPH
    {0xBCCC, 0x6A1F}, //4284 #CJK UNIFIED IDEOGRAPH
    {0xBCCD, 0x69E8}, //4285 #CJK UNIFIED IDEOGRAPH
    {0xBCCE, 0x6A01}, //4286 #CJK UNIFIED IDEOGRAPH
    {0xBCCF, 0x6A1E}, //4287 #CJK UNIFIED IDEOGRAPH
    {0xBCD0, 0x6A19}, //4288 #CJK UNIFIED IDEOGRAPH
    {0xBCD1, 0x69FD}, //4289 #CJK UNIFIED IDEOGRAPH
    {0xBCD2, 0x6A21}, //4290 #CJK UNIFIED IDEOGRAPH
    {0xBCD3, 0x6A13}, //4291 #CJK UNIFIED IDEOGRAPH
    {0xBCD4, 0x6A0A}, //4292 #CJK UNIFIED IDEOGRAPH
    {0xBCD5, 0x69F3}, //4293 #CJK UNIFIED IDEOGRAPH
    {0xBCD6, 0x6A02}, //4294 #CJK UNIFIED IDEOGRAPH
    {0xBCD7, 0x6A05}, //4295 #CJK UNIFIED IDEOGRAPH
    {0xBCD8, 0x69ED}, //4296 #CJK UNIFIED IDEOGRAPH
    {0xBCD9, 0x6A11}, //4297 #CJK UNIFIED IDEOGRAPH
    {0xBCDA, 0x6B50}, //4298 #CJK UNIFIED IDEOGRAPH
    {0xBCDB, 0x6B4E}, //4299 #CJK UNIFIED IDEOGRAPH
    {0xBCDC, 0x6BA4}, //4300 #CJK UNIFIED IDEOGRAPH
    {0xBCDD, 0x6BC5}, //4301 #CJK UNIFIED IDEOGRAPH
    {0xBCDE, 0x6BC6}, //4302 #CJK UNIFIED IDEOGRAPH
    {0xBCDF, 0x6F3F}, //4303 #CJK UNIFIED IDEOGRAPH
    {0xBCE0, 0x6F7C}, //4304 #CJK UNIFIED IDEOGRAPH
    {0xBCE1, 0x6F84}, //4305 #CJK UNIFIED IDEOGRAPH
    {0xBCE2, 0x6F51}, //4306 #CJK UNIFIED IDEOGRAPH
    {0xBCE3, 0x6F66}, //4307 #CJK UNIFIED IDEOGRAPH
    {0xBCE4, 0x6F54}, //4308 #CJK UNIFIED IDEOGRAPH
    {0xBCE5, 0x6F86}, //4309 #CJK UNIFIED IDEOGRAPH
    {0xBCE6, 0x6F6D}, //4310 #CJK UNIFIED IDEOGRAPH
    {0xBCE7, 0x6F5B}, //4311 #CJK UNIFIED IDEOGRAPH
    {0xBCE8, 0x6F78}, //4312 #CJK UNIFIED IDEOGRAPH
    {0xBCE9, 0x6F6E}, //4313 #CJK UNIFIED IDEOGRAPH
    {0xBCEA, 0x6F8E}, //4314 #CJK UNIFIED IDEOGRAPH
    {0xBCEB, 0x6F7A}, //4315 #CJK UNIFIED IDEOGRAPH
    {0xBCEC, 0x6F70}, //4316 #CJK UNIFIED IDEOGRAPH
    {0xBCED, 0x6F64}, //4317 #CJK UNIFIED IDEOGRAPH
    {0xBCEE, 0x6F97}, //4318 #CJK UNIFIED IDEOGRAPH
    {0xBCEF, 0x6F58}, //4319 #CJK UNIFIED IDEOGRAPH
    {0xBCF0, 0x6ED5}, //4320 #CJK UNIFIED IDEOGRAPH
    {0xBCF1, 0x6F6F}, //4321 #CJK UNIFIED IDEOGRAPH
    {0xBCF2, 0x6F60}, //4322 #CJK UNIFIED IDEOGRAPH
    {0xBCF3, 0x6F5F}, //4323 #CJK UNIFIED IDEOGRAPH
    {0xBCF4, 0x719F}, //4324 #CJK UNIFIED IDEOGRAPH
    {0xBCF5, 0x71AC}, //4325 #CJK UNIFIED IDEOGRAPH
    {0xBCF6, 0x71B1}, //4326 #CJK UNIFIED IDEOGRAPH
    {0xBCF7, 0x71A8}, //4327 #CJK UNIFIED IDEOGRAPH
    {0xBCF8, 0x7256}, //4328 #CJK UNIFIED IDEOGRAPH
    {0xBCF9, 0x729B}, //4329 #CJK UNIFIED IDEOGRAPH
    {0xBCFA, 0x734E}, //4330 #CJK UNIFIED IDEOGRAPH
    {0xBCFB, 0x7357}, //4331 #CJK UNIFIED IDEOGRAPH
    {0xBCFC, 0x7469}, //4332 #CJK UNIFIED IDEOGRAPH
    {0xBCFD, 0x748B}, //4333 #CJK UNIFIED IDEOGRAPH
    {0xBCFE, 0x7483}, //4334 #CJK UNIFIED IDEOGRAPH
    {0xBD40, 0x747E}, //4335 #CJK UNIFIED IDEOGRAPH
    {0xBD41, 0x7480}, //4336 #CJK UNIFIED IDEOGRAPH
    {0xBD42, 0x757F}, //4337 #CJK UNIFIED IDEOGRAPH
    {0xBD43, 0x7620}, //4338 #CJK UNIFIED IDEOGRAPH
    {0xBD44, 0x7629}, //4339 #CJK UNIFIED IDEOGRAPH
    {0xBD45, 0x761F}, //4340 #CJK UNIFIED IDEOGRAPH
    {0xBD46, 0x7624}, //4341 #CJK UNIFIED IDEOGRAPH
    {0xBD47, 0x7626}, //4342 #CJK UNIFIED IDEOGRAPH
    {0xBD48, 0x7621}, //4343 #CJK UNIFIED IDEOGRAPH
    {0xBD49, 0x7622}, //4344 #CJK UNIFIED IDEOGRAPH
    {0xBD4A, 0x769A}, //4345 #CJK UNIFIED IDEOGRAPH
    {0xBD4B, 0x76BA}, //4346 #CJK UNIFIED IDEOGRAPH
    {0xBD4C, 0x76E4}, //4347 #CJK UNIFIED IDEOGRAPH
    {0xBD4D, 0x778E}, //4348 #CJK UNIFIED IDEOGRAPH
    {0xBD4E, 0x7787}, //4349 #CJK UNIFIED IDEOGRAPH
    {0xBD4F, 0x778C}, //4350 #CJK UNIFIED IDEOGRAPH
    {0xBD50, 0x7791}, //4351 #CJK UNIFIED IDEOGRAPH
    {0xBD51, 0x778B}, //4352 #CJK UNIFIED IDEOGRAPH
    {0xBD52, 0x78CB}, //4353 #CJK UNIFIED IDEOGRAPH
    {0xBD53, 0x78C5}, //4354 #CJK UNIFIED IDEOGRAPH
    {0xBD54, 0x78BA}, //4355 #CJK UNIFIED IDEOGRAPH
    {0xBD55, 0x78CA}, //4356 #CJK UNIFIED IDEOGRAPH
    {0xBD56, 0x78BE}, //4357 #CJK UNIFIED IDEOGRAPH
    {0xBD57, 0x78D5}, //4358 #CJK UNIFIED IDEOGRAPH
    {0xBD58, 0x78BC}, //4359 #CJK UNIFIED IDEOGRAPH
    {0xBD59, 0x78D0}, //4360 #CJK UNIFIED IDEOGRAPH
    {0xBD5A, 0x7A3F}, //4361 #CJK UNIFIED IDEOGRAPH
    {0xBD5B, 0x7A3C}, //4362 #CJK UNIFIED IDEOGRAPH
    {0xBD5C, 0x7A40}, //4363 #CJK UNIFIED IDEOGRAPH
    {0xBD5D, 0x7A3D}, //4364 #CJK UNIFIED IDEOGRAPH
    {0xBD5E, 0x7A37}, //4365 #CJK UNIFIED IDEOGRAPH
    {0xBD5F, 0x7A3B}, //4366 #CJK UNIFIED IDEOGRAPH
    {0xBD60, 0x7AAF}, //4367 #CJK UNIFIED IDEOGRAPH
    {0xBD61, 0x7AAE}, //4368 #CJK UNIFIED IDEOGRAPH
    {0xBD62, 0x7BAD}, //4369 #CJK UNIFIED IDEOGRAPH
    {0xBD63, 0x7BB1}, //4370 #CJK UNIFIED IDEOGRAPH
    {0xBD64, 0x7BC4}, //4371 #CJK UNIFIED IDEOGRAPH
    {0xBD65, 0x7BB4}, //4372 #CJK UNIFIED IDEOGRAPH
    {0xBD66, 0x7BC6}, //4373 #CJK UNIFIED IDEOGRAPH
    {0xBD67, 0x7BC7}, //4374 #CJK UNIFIED IDEOGRAPH
    {0xBD68, 0x7BC1}, //4375 #CJK UNIFIED IDEOGRAPH
    {0xBD69, 0x7BA0}, //4376 #CJK UNIFIED IDEOGRAPH
    {0xBD6A, 0x7BCC}, //4377 #CJK UNIFIED IDEOGRAPH
    {0xBD6B, 0x7CCA}, //4378 #CJK UNIFIED IDEOGRAPH
    {0xBD6C, 0x7DE0}, //4379 #CJK UNIFIED IDEOGRAPH
    {0xBD6D, 0x7DF4}, //4380 #CJK UNIFIED IDEOGRAPH
    {0xBD6E, 0x7DEF}, //4381 #CJK UNIFIED IDEOGRAPH
    {0xBD6F, 0x7DFB}, //4382 #CJK UNIFIED IDEOGRAPH
    {0xBD70, 0x7DD8}, //4383 #CJK UNIFIED IDEOGRAPH
    {0xBD71, 0x7DEC}, //4384 #CJK UNIFIED IDEOGRAPH
    {0xBD72, 0x7DDD}, //4385 #CJK UNIFIED IDEOGRAPH
    {0xBD73, 0x7DE8}, //4386 #CJK UNIFIED IDEOGRAPH
    {0xBD74, 0x7DE3}, //4387 #CJK UNIFIED IDEOGRAPH
    {0xBD75, 0x7DDA}, //4388 #CJK UNIFIED IDEOGRAPH
    {0xBD76, 0x7DDE}, //4389 #CJK UNIFIED IDEOGRAPH
    {0xBD77, 0x7DE9}, //4390 #CJK UNIFIED IDEOGRAPH
    {0xBD78, 0x7D9E}, //4391 #CJK UNIFIED IDEOGRAPH
    {0xBD79, 0x7DD9}, //4392 #CJK UNIFIED IDEOGRAPH
    {0xBD7A, 0x7DF2}, //4393 #CJK UNIFIED IDEOGRAPH
    {0xBD7B, 0x7DF9}, //4394 #CJK UNIFIED IDEOGRAPH
    {0xBD7C, 0x7F75}, //4395 #CJK UNIFIED IDEOGRAPH
    {0xBD7D, 0x7F77}, //4396 #CJK UNIFIED IDEOGRAPH
    {0xBD7E, 0x7FAF}, //4397 #CJK UNIFIED IDEOGRAPH
    {0xBDA1, 0x7FE9}, //4398 #CJK UNIFIED IDEOGRAPH
    {0xBDA2, 0x8026}, //4399 #CJK UNIFIED IDEOGRAPH
    {0xBDA3, 0x819B}, //4400 #CJK UNIFIED IDEOGRAPH
    {0xBDA4, 0x819C}, //4401 #CJK UNIFIED IDEOGRAPH
    {0xBDA5, 0x819D}, //4402 #CJK UNIFIED IDEOGRAPH
    {0xBDA6, 0x81A0}, //4403 #CJK UNIFIED IDEOGRAPH
    {0xBDA7, 0x819A}, //4404 #CJK UNIFIED IDEOGRAPH
    {0xBDA8, 0x8198}, //4405 #CJK UNIFIED IDEOGRAPH
    {0xBDA9, 0x8517}, //4406 #CJK UNIFIED IDEOGRAPH
    {0xBDAA, 0x853D}, //4407 #CJK UNIFIED IDEOGRAPH
    {0xBDAB, 0x851A}, //4408 #CJK UNIFIED IDEOGRAPH
    {0xBDAC, 0x84EE}, //4409 #CJK UNIFIED IDEOGRAPH
    {0xBDAD, 0x852C}, //4410 #CJK UNIFIED IDEOGRAPH
    {0xBDAE, 0x852D}, //4411 #CJK UNIFIED IDEOGRAPH
    {0xBDAF, 0x8513}, //4412 #CJK UNIFIED IDEOGRAPH
    {0xBDB0, 0x8511}, //4413 #CJK UNIFIED IDEOGRAPH
    {0xBDB1, 0x8523}, //4414 #CJK UNIFIED IDEOGRAPH
    {0xBDB2, 0x8521}, //4415 #CJK UNIFIED IDEOGRAPH
    {0xBDB3, 0x8514}, //4416 #CJK UNIFIED IDEOGRAPH
    {0xBDB4, 0x84EC}, //4417 #CJK UNIFIED IDEOGRAPH
    {0xBDB5, 0x8525}, //4418 #CJK UNIFIED IDEOGRAPH
    {0xBDB6, 0x84FF}, //4419 #CJK UNIFIED IDEOGRAPH
    {0xBDB7, 0x8506}, //4420 #CJK UNIFIED IDEOGRAPH
    {0xBDB8, 0x8782}, //4421 #CJK UNIFIED IDEOGRAPH
    {0xBDB9, 0x8774}, //4422 #CJK UNIFIED IDEOGRAPH
    {0xBDBA, 0x8776}, //4423 #CJK UNIFIED IDEOGRAPH
    {0xBDBB, 0x8760}, //4424 #CJK UNIFIED IDEOGRAPH
    {0xBDBC, 0x8766}, //4425 #CJK UNIFIED IDEOGRAPH
    {0xBDBD, 0x8778}, //4426 #CJK UNIFIED IDEOGRAPH
    {0xBDBE, 0x8768}, //4427 #CJK UNIFIED IDEOGRAPH
    {0xBDBF, 0x8759}, //4428 #CJK UNIFIED IDEOGRAPH
    {0xBDC0, 0x8757}, //4429 #CJK UNIFIED IDEOGRAPH
    {0xBDC1, 0x874C}, //4430 #CJK UNIFIED IDEOGRAPH
    {0xBDC2, 0x8753}, //4431 #CJK UNIFIED IDEOGRAPH
    {0xBDC3, 0x885B}, //4432 #CJK UNIFIED IDEOGRAPH
    {0xBDC4, 0x885D}, //4433 #CJK UNIFIED IDEOGRAPH
    {0xBDC5, 0x8910}, //4434 #CJK UNIFIED IDEOGRAPH
    {0xBDC6, 0x8907}, //4435 #CJK UNIFIED IDEOGRAPH
    {0xBDC7, 0x8912}, //4436 #CJK UNIFIED IDEOGRAPH
    {0xBDC8, 0x8913}, //4437 #CJK UNIFIED IDEOGRAPH
    {0xBDC9, 0x8915}, //4438 #CJK UNIFIED IDEOGRAPH
    {0xBDCA, 0x890A}, //4439 #CJK UNIFIED IDEOGRAPH
    {0xBDCB, 0x8ABC}, //4440 #CJK UNIFIED IDEOGRAPH
    {0xBDCC, 0x8AD2}, //4441 #CJK UNIFIED IDEOGRAPH
    {0xBDCD, 0x8AC7}, //4442 #CJK UNIFIED IDEOGRAPH
    {0xBDCE, 0x8AC4}, //4443 #CJK UNIFIED IDEOGRAPH
    {0xBDCF, 0x8A95}, //4444 #CJK UNIFIED IDEOGRAPH
    {0xBDD0, 0x8ACB}, //4445 #CJK UNIFIED IDEOGRAPH
    {0xBDD1, 0x8AF8}, //4446 #CJK UNIFIED IDEOGRAPH
    {0xBDD2, 0x8AB2}, //4447 #CJK UNIFIED IDEOGRAPH
    {0xBDD3, 0x8AC9}, //4448 #CJK UNIFIED IDEOGRAPH
    {0xBDD4, 0x8AC2}, //4449 #CJK UNIFIED IDEOGRAPH
    {0xBDD5, 0x8ABF}, //4450 #CJK UNIFIED IDEOGRAPH
    {0xBDD6, 0x8AB0}, //4451 #CJK UNIFIED IDEOGRAPH
    {0xBDD7, 0x8AD6}, //4452 #CJK UNIFIED IDEOGRAPH
    {0xBDD8, 0x8ACD}, //4453 #CJK UNIFIED IDEOGRAPH
    {0xBDD9, 0x8AB6}, //4454 #CJK UNIFIED IDEOGRAPH
    {0xBDDA, 0x8AB9}, //4455 #CJK UNIFIED IDEOGRAPH
    {0xBDDB, 0x8ADB}, //4456 #CJK UNIFIED IDEOGRAPH
    {0xBDDC, 0x8C4C}, //4457 #CJK UNIFIED IDEOGRAPH
    {0xBDDD, 0x8C4E}, //4458 #CJK UNIFIED IDEOGRAPH
    {0xBDDE, 0x8C6C}, //4459 #CJK UNIFIED IDEOGRAPH
    {0xBDDF, 0x8CE0}, //4460 #CJK UNIFIED IDEOGRAPH
    {0xBDE0, 0x8CDE}, //4461 #CJK UNIFIED IDEOGRAPH
    {0xBDE1, 0x8CE6}, //4462 #CJK UNIFIED IDEOGRAPH
    {0xBDE2, 0x8CE4}, //4463 #CJK UNIFIED IDEOGRAPH
    {0xBDE3, 0x8CEC}, //4464 #CJK UNIFIED IDEOGRAPH
    {0xBDE4, 0x8CED}, //4465 #CJK UNIFIED IDEOGRAPH
    {0xBDE5, 0x8CE2}, //4466 #CJK UNIFIED IDEOGRAPH
    {0xBDE6, 0x8CE3}, //4467 #CJK UNIFIED IDEOGRAPH
    {0xBDE7, 0x8CDC}, //4468 #CJK UNIFIED IDEOGRAPH
    {0xBDE8, 0x8CEA}, //4469 #CJK UNIFIED IDEOGRAPH
    {0xBDE9, 0x8CE1}, //4470 #CJK UNIFIED IDEOGRAPH
    {0xBDEA, 0x8D6D}, //4471 #CJK UNIFIED IDEOGRAPH
    {0xBDEB, 0x8D9F}, //4472 #CJK UNIFIED IDEOGRAPH
    {0xBDEC, 0x8DA3}, //4473 #CJK UNIFIED IDEOGRAPH
    {0xBDED, 0x8E2B}, //4474 #CJK UNIFIED IDEOGRAPH
    {0xBDEE, 0x8E10}, //4475 #CJK UNIFIED IDEOGRAPH
    {0xBDEF, 0x8E1D}, //4476 #CJK UNIFIED IDEOGRAPH
    {0xBDF0, 0x8E22}, //4477 #CJK UNIFIED IDEOGRAPH
    {0xBDF1, 0x8E0F}, //4478 #CJK UNIFIED IDEOGRAPH
    {0xBDF2, 0x8E29}, //4479 #CJK UNIFIED IDEOGRAPH
    {0xBDF3, 0x8E1F}, //4480 #CJK UNIFIED IDEOGRAPH
    {0xBDF4, 0x8E21}, //4481 #CJK UNIFIED IDEOGRAPH
    {0xBDF5, 0x8E1E}, //4482 #CJK UNIFIED IDEOGRAPH
    {0xBDF6, 0x8EBA}, //4483 #CJK UNIFIED IDEOGRAPH
    {0xBDF7, 0x8F1D}, //4484 #CJK UNIFIED IDEOGRAPH
    {0xBDF8, 0x8F1B}, //4485 #CJK UNIFIED IDEOGRAPH
    {0xBDF9, 0x8F1F}, //4486 #CJK UNIFIED IDEOGRAPH
    {0xBDFA, 0x8F29}, //4487 #CJK UNIFIED IDEOGRAPH
    {0xBDFB, 0x8F26}, //4488 #CJK UNIFIED IDEOGRAPH
    {0xBDFC, 0x8F2A}, //4489 #CJK UNIFIED IDEOGRAPH
    {0xBDFD, 0x8F1C}, //4490 #CJK UNIFIED IDEOGRAPH
    {0xBDFE, 0x8F1E}, //4491 #CJK UNIFIED IDEOGRAPH
    {0xBE40, 0x8F25}, //4492 #CJK UNIFIED IDEOGRAPH
    {0xBE41, 0x9069}, //4493 #CJK UNIFIED IDEOGRAPH
    {0xBE42, 0x906E}, //4494 #CJK UNIFIED IDEOGRAPH
    {0xBE43, 0x9068}, //4495 #CJK UNIFIED IDEOGRAPH
    {0xBE44, 0x906D}, //4496 #CJK UNIFIED IDEOGRAPH
    {0xBE45, 0x9077}, //4497 #CJK UNIFIED IDEOGRAPH
    {0xBE46, 0x9130}, //4498 #CJK UNIFIED IDEOGRAPH
    {0xBE47, 0x912D}, //4499 #CJK UNIFIED IDEOGRAPH
    {0xBE48, 0x9127}, //4500 #CJK UNIFIED IDEOGRAPH
    {0xBE49, 0x9131}, //4501 #CJK UNIFIED IDEOGRAPH
    {0xBE4A, 0x9187}, //4502 #CJK UNIFIED IDEOGRAPH
    {0xBE4B, 0x9189}, //4503 #CJK UNIFIED IDEOGRAPH
    {0xBE4C, 0x918B}, //4504 #CJK UNIFIED IDEOGRAPH
    {0xBE4D, 0x9183}, //4505 #CJK UNIFIED IDEOGRAPH
    {0xBE4E, 0x92C5}, //4506 #CJK UNIFIED IDEOGRAPH
    {0xBE4F, 0x92BB}, //4507 #CJK UNIFIED IDEOGRAPH
    {0xBE50, 0x92B7}, //4508 #CJK UNIFIED IDEOGRAPH
    {0xBE51, 0x92EA}, //4509 #CJK UNIFIED IDEOGRAPH
    {0xBE52, 0x92AC}, //4510 #CJK UNIFIED IDEOGRAPH
    {0xBE53, 0x92E4}, //4511 #CJK UNIFIED IDEOGRAPH
    {0xBE54, 0x92C1}, //4512 #CJK UNIFIED IDEOGRAPH
    {0xBE55, 0x92B3}, //4513 #CJK UNIFIED IDEOGRAPH
    {0xBE56, 0x92BC}, //4514 #CJK UNIFIED IDEOGRAPH
    {0xBE57, 0x92D2}, //4515 #CJK UNIFIED IDEOGRAPH
    {0xBE58, 0x92C7}, //4516 #CJK UNIFIED IDEOGRAPH
    {0xBE59, 0x92F0}, //4517 #CJK UNIFIED IDEOGRAPH
    {0xBE5A, 0x92B2}, //4518 #CJK UNIFIED IDEOGRAPH
    {0xBE5B, 0x95AD}, //4519 #CJK UNIFIED IDEOGRAPH
    {0xBE5C, 0x95B1}, //4520 #CJK UNIFIED IDEOGRAPH
    {0xBE5D, 0x9704}, //4521 #CJK UNIFIED IDEOGRAPH
    {0xBE5E, 0x9706}, //4522 #CJK UNIFIED IDEOGRAPH
    {0xBE5F, 0x9707}, //4523 #CJK UNIFIED IDEOGRAPH
    {0xBE60, 0x9709}, //4524 #CJK UNIFIED IDEOGRAPH
    {0xBE61, 0x9760}, //4525 #CJK UNIFIED IDEOGRAPH
    {0xBE62, 0x978D}, //4526 #CJK UNIFIED IDEOGRAPH
    {0xBE63, 0x978B}, //4527 #CJK UNIFIED IDEOGRAPH
    {0xBE64, 0x978F}, //4528 #CJK UNIFIED IDEOGRAPH
    {0xBE65, 0x9821}, //4529 #CJK UNIFIED IDEOGRAPH
    {0xBE66, 0x982B}, //4530 #CJK UNIFIED IDEOGRAPH
    {0xBE67, 0x981C}, //4531 #CJK UNIFIED IDEOGRAPH
    {0xBE68, 0x98B3}, //4532 #CJK UNIFIED IDEOGRAPH
    {0xBE69, 0x990A}, //4533 #CJK UNIFIED IDEOGRAPH
    {0xBE6A, 0x9913}, //4534 #CJK UNIFIED IDEOGRAPH
    {0xBE6B, 0x9912}, //4535 #CJK UNIFIED IDEOGRAPH
    {0xBE6C, 0x9918}, //4536 #CJK UNIFIED IDEOGRAPH
    {0xBE6D, 0x99DD}, //4537 #CJK UNIFIED IDEOGRAPH
    {0xBE6E, 0x99D0}, //4538 #CJK UNIFIED IDEOGRAPH
    {0xBE6F, 0x99DF}, //4539 #CJK UNIFIED IDEOGRAPH
    {0xBE70, 0x99DB}, //4540 #CJK UNIFIED IDEOGRAPH
    {0xBE71, 0x99D1}, //4541 #CJK UNIFIED IDEOGRAPH
    {0xBE72, 0x99D5}, //4542 #CJK UNIFIED IDEOGRAPH
    {0xBE73, 0x99D2}, //4543 #CJK UNIFIED IDEOGRAPH
    {0xBE74, 0x99D9}, //4544 #CJK UNIFIED IDEOGRAPH
    {0xBE75, 0x9AB7}, //4545 #CJK UNIFIED IDEOGRAPH
    {0xBE76, 0x9AEE}, //4546 #CJK UNIFIED IDEOGRAPH
    {0xBE77, 0x9AEF}, //4547 #CJK UNIFIED IDEOGRAPH
    {0xBE78, 0x9B27}, //4548 #CJK UNIFIED IDEOGRAPH
    {0xBE79, 0x9B45}, //4549 #CJK UNIFIED IDEOGRAPH
    {0xBE7A, 0x9B44}, //4550 #CJK UNIFIED IDEOGRAPH
    {0xBE7B, 0x9B77}, //4551 #CJK UNIFIED IDEOGRAPH
    {0xBE7C, 0x9B6F}, //4552 #CJK UNIFIED IDEOGRAPH
    {0xBE7D, 0x9D06}, //4553 #CJK UNIFIED IDEOGRAPH
    {0xBE7E, 0x9D09}, //4554 #CJK UNIFIED IDEOGRAPH
    {0xBEA1, 0x9D03}, //4555 #CJK UNIFIED IDEOGRAPH
    {0xBEA2, 0x9EA9}, //4556 #CJK UNIFIED IDEOGRAPH
    {0xBEA3, 0x9EBE}, //4557 #CJK UNIFIED IDEOGRAPH
    {0xBEA4, 0x9ECE}, //4558 #CJK UNIFIED IDEOGRAPH
    {0xBEA5, 0x58A8}, //4559 #CJK UNIFIED IDEOGRAPH
    {0xBEA6, 0x9F52}, //4560 #CJK UNIFIED IDEOGRAPH
    {0xBEA7, 0x5112}, //4561 #CJK UNIFIED IDEOGRAPH
    {0xBEA8, 0x5118}, //4562 #CJK UNIFIED IDEOGRAPH
    {0xBEA9, 0x5114}, //4563 #CJK UNIFIED IDEOGRAPH
    {0xBEAA, 0x5110}, //4564 #CJK UNIFIED IDEOGRAPH
    {0xBEAB, 0x5115}, //4565 #CJK UNIFIED IDEOGRAPH
    {0xBEAC, 0x5180}, //4566 #CJK UNIFIED IDEOGRAPH
    {0xBEAD, 0x51AA}, //4567 #CJK UNIFIED IDEOGRAPH
    {0xBEAE, 0x51DD}, //4568 #CJK UNIFIED IDEOGRAPH
    {0xBEAF, 0x5291}, //4569 #CJK UNIFIED IDEOGRAPH
    {0xBEB0, 0x5293}, //4570 #CJK UNIFIED IDEOGRAPH
    {0xBEB1, 0x52F3}, //4571 #CJK UNIFIED IDEOGRAPH
    {0xBEB2, 0x5659}, //4572 #CJK UNIFIED IDEOGRAPH
    {0xBEB3, 0x566B}, //4573 #CJK UNIFIED IDEOGRAPH
    {0xBEB4, 0x5679}, //4574 #CJK UNIFIED IDEOGRAPH
    {0xBEB5, 0x5669}, //4575 #CJK UNIFIED IDEOGRAPH
    {0xBEB6, 0x5664}, //4576 #CJK UNIFIED IDEOGRAPH
    {0xBEB7, 0x5678}, //4577 #CJK UNIFIED IDEOGRAPH
    {0xBEB8, 0x566A}, //4578 #CJK UNIFIED IDEOGRAPH
    {0xBEB9, 0x5668}, //4579 #CJK UNIFIED IDEOGRAPH
    {0xBEBA, 0x5665}, //4580 #CJK UNIFIED IDEOGRAPH
    {0xBEBB, 0x5671}, //4581 #CJK UNIFIED IDEOGRAPH
    {0xBEBC, 0x566F}, //4582 #CJK UNIFIED IDEOGRAPH
    {0xBEBD, 0x566C}, //4583 #CJK UNIFIED IDEOGRAPH
    {0xBEBE, 0x5662}, //4584 #CJK UNIFIED IDEOGRAPH
    {0xBEBF, 0x5676}, //4585 #CJK UNIFIED IDEOGRAPH
    {0xBEC0, 0x58C1}, //4586 #CJK UNIFIED IDEOGRAPH
    {0xBEC1, 0x58BE}, //4587 #CJK UNIFIED IDEOGRAPH
    {0xBEC2, 0x58C7}, //4588 #CJK UNIFIED IDEOGRAPH
    {0xBEC3, 0x58C5}, //4589 #CJK UNIFIED IDEOGRAPH
    {0xBEC4, 0x596E}, //4590 #CJK UNIFIED IDEOGRAPH
    {0xBEC5, 0x5B1D}, //4591 #CJK UNIFIED IDEOGRAPH
    {0xBEC6, 0x5B34}, //4592 #CJK UNIFIED IDEOGRAPH
    {0xBEC7, 0x5B78}, //4593 #CJK UNIFIED IDEOGRAPH
    {0xBEC8, 0x5BF0}, //4594 #CJK UNIFIED IDEOGRAPH
    {0xBEC9, 0x5C0E}, //4595 #CJK UNIFIED IDEOGRAPH
    {0xBECA, 0x5F4A}, //4596 #CJK UNIFIED IDEOGRAPH
    {0xBECB, 0x61B2}, //4597 #CJK UNIFIED IDEOGRAPH
    {0xBECC, 0x6191}, //4598 #CJK UNIFIED IDEOGRAPH
    {0xBECD, 0x61A9}, //4599 #CJK UNIFIED IDEOGRAPH
    {0xBECE, 0x618A}, //4600 #CJK UNIFIED IDEOGRAPH
    {0xBECF, 0x61CD}, //4601 #CJK UNIFIED IDEOGRAPH
    {0xBED0, 0x61B6}, //4602 #CJK UNIFIED IDEOGRAPH
    {0xBED1, 0x61BE}, //4603 #CJK UNIFIED IDEOGRAPH
    {0xBED2, 0x61CA}, //4604 #CJK UNIFIED IDEOGRAPH
    {0xBED3, 0x61C8}, //4605 #CJK UNIFIED IDEOGRAPH
    {0xBED4, 0x6230}, //4606 #CJK UNIFIED IDEOGRAPH
    {0xBED5, 0x64C5}, //4607 #CJK UNIFIED IDEOGRAPH
    {0xBED6, 0x64C1}, //4608 #CJK UNIFIED IDEOGRAPH
    {0xBED7, 0x64CB}, //4609 #CJK UNIFIED IDEOGRAPH
    {0xBED8, 0x64BB}, //4610 #CJK UNIFIED IDEOGRAPH
    {0xBED9, 0x64BC}, //4611 #CJK UNIFIED IDEOGRAPH
    {0xBEDA, 0x64DA}, //4612 #CJK UNIFIED IDEOGRAPH
    {0xBEDB, 0x64C4}, //4613 #CJK UNIFIED IDEOGRAPH
    {0xBEDC, 0x64C7}, //4614 #CJK UNIFIED IDEOGRAPH
    {0xBEDD, 0x64C2}, //4615 #CJK UNIFIED IDEOGRAPH
    {0xBEDE, 0x64CD}, //4616 #CJK UNIFIED IDEOGRAPH
    {0xBEDF, 0x64BF}, //4617 #CJK UNIFIED IDEOGRAPH
    {0xBEE0, 0x64D2}, //4618 #CJK UNIFIED IDEOGRAPH
    {0xBEE1, 0x64D4}, //4619 #CJK UNIFIED IDEOGRAPH
    {0xBEE2, 0x64BE}, //4620 #CJK UNIFIED IDEOGRAPH
    {0xBEE3, 0x6574}, //4621 #CJK UNIFIED IDEOGRAPH
    {0xBEE4, 0x66C6}, //4622 #CJK UNIFIED IDEOGRAPH
    {0xBEE5, 0x66C9}, //4623 #CJK UNIFIED IDEOGRAPH
    {0xBEE6, 0x66B9}, //4624 #CJK UNIFIED IDEOGRAPH
    {0xBEE7, 0x66C4}, //4625 #CJK UNIFIED IDEOGRAPH
    {0xBEE8, 0x66C7}, //4626 #CJK UNIFIED IDEOGRAPH
    {0xBEE9, 0x66B8}, //4627 #CJK UNIFIED IDEOGRAPH
    {0xBEEA, 0x6A3D}, //4628 #CJK UNIFIED IDEOGRAPH
    {0xBEEB, 0x6A38}, //4629 #CJK UNIFIED IDEOGRAPH
    {0xBEEC, 0x6A3A}, //4630 #CJK UNIFIED IDEOGRAPH
    {0xBEED, 0x6A59}, //4631 #CJK UNIFIED IDEOGRAPH
    {0xBEEE, 0x6A6B}, //4632 #CJK UNIFIED IDEOGRAPH
    {0xBEEF, 0x6A58}, //4633 #CJK UNIFIED IDEOGRAPH
    {0xBEF0, 0x6A39}, //4634 #CJK UNIFIED IDEOGRAPH
    {0xBEF1, 0x6A44}, //4635 #CJK UNIFIED IDEOGRAPH
    {0xBEF2, 0x6A62}, //4636 #CJK UNIFIED IDEOGRAPH
    {0xBEF3, 0x6A61}, //4637 #CJK UNIFIED IDEOGRAPH
    {0xBEF4, 0x6A4B}, //4638 #CJK UNIFIED IDEOGRAPH
    {0xBEF5, 0x6A47}, //4639 #CJK UNIFIED IDEOGRAPH
    {0xBEF6, 0x6A35}, //4640 #CJK UNIFIED IDEOGRAPH
    {0xBEF7, 0x6A5F}, //4641 #CJK UNIFIED IDEOGRAPH
    {0xBEF8, 0x6A48}, //4642 #CJK UNIFIED IDEOGRAPH
    {0xBEF9, 0x6B59}, //4643 #CJK UNIFIED IDEOGRAPH
    {0xBEFA, 0x6B77}, //4644 #CJK UNIFIED IDEOGRAPH
    {0xBEFB, 0x6C05}, //4645 #CJK UNIFIED IDEOGRAPH
    {0xBEFC, 0x6FC2}, //4646 #CJK UNIFIED IDEOGRAPH
    {0xBEFD, 0x6FB1}, //4647 #CJK UNIFIED IDEOGRAPH
    {0xBEFE, 0x6FA1}, //4648 #CJK UNIFIED IDEOGRAPH
    {0xBF40, 0x6FC3}, //4649 #CJK UNIFIED IDEOGRAPH
    {0xBF41, 0x6FA4}, //4650 #CJK UNIFIED IDEOGRAPH
    {0xBF42, 0x6FC1}, //4651 #CJK UNIFIED IDEOGRAPH
    {0xBF43, 0x6FA7}, //4652 #CJK UNIFIED IDEOGRAPH
    {0xBF44, 0x6FB3}, //4653 #CJK UNIFIED IDEOGRAPH
    {0xBF45, 0x6FC0}, //4654 #CJK UNIFIED IDEOGRAPH
    {0xBF46, 0x6FB9}, //4655 #CJK UNIFIED IDEOGRAPH
    {0xBF47, 0x6FB6}, //4656 #CJK UNIFIED IDEOGRAPH
    {0xBF48, 0x6FA6}, //4657 #CJK UNIFIED IDEOGRAPH
    {0xBF49, 0x6FA0}, //4658 #CJK UNIFIED IDEOGRAPH
    {0xBF4A, 0x6FB4}, //4659 #CJK UNIFIED IDEOGRAPH
    {0xBF4B, 0x71BE}, //4660 #CJK UNIFIED IDEOGRAPH
    {0xBF4C, 0x71C9}, //4661 #CJK UNIFIED IDEOGRAPH
    {0xBF4D, 0x71D0}, //4662 #CJK UNIFIED IDEOGRAPH
    {0xBF4E, 0x71D2}, //4663 #CJK UNIFIED IDEOGRAPH
    {0xBF4F, 0x71C8}, //4664 #CJK UNIFIED IDEOGRAPH
    {0xBF50, 0x71D5}, //4665 #CJK UNIFIED IDEOGRAPH
    {0xBF51, 0x71B9}, //4666 #CJK UNIFIED IDEOGRAPH
    {0xBF52, 0x71CE}, //4667 #CJK UNIFIED IDEOGRAPH
    {0xBF53, 0x71D9}, //4668 #CJK UNIFIED IDEOGRAPH
    {0xBF54, 0x71DC}, //4669 #CJK UNIFIED IDEOGRAPH
    {0xBF55, 0x71C3}, //4670 #CJK UNIFIED IDEOGRAPH
    {0xBF56, 0x71C4}, //4671 #CJK UNIFIED IDEOGRAPH
    {0xBF57, 0x7368}, //4672 #CJK UNIFIED IDEOGRAPH
    {0xBF58, 0x749C}, //4673 #CJK UNIFIED IDEOGRAPH
    {0xBF59, 0x74A3}, //4674 #CJK UNIFIED IDEOGRAPH
    {0xBF5A, 0x7498}, //4675 #CJK UNIFIED IDEOGRAPH
    {0xBF5B, 0x749F}, //4676 #CJK UNIFIED IDEOGRAPH
    {0xBF5C, 0x749E}, //4677 #CJK UNIFIED IDEOGRAPH
    {0xBF5D, 0x74E2}, //4678 #CJK UNIFIED IDEOGRAPH
    {0xBF5E, 0x750C}, //4679 #CJK UNIFIED IDEOGRAPH
    {0xBF5F, 0x750D}, //4680 #CJK UNIFIED IDEOGRAPH
    {0xBF60, 0x7634}, //4681 #CJK UNIFIED IDEOGRAPH
    {0xBF61, 0x7638}, //4682 #CJK UNIFIED IDEOGRAPH
    {0xBF62, 0x763A}, //4683 #CJK UNIFIED IDEOGRAPH
    {0xBF63, 0x76E7}, //4684 #CJK UNIFIED IDEOGRAPH
    {0xBF64, 0x76E5}, //4685 #CJK UNIFIED IDEOGRAPH
    {0xBF65, 0x77A0}, //4686 #CJK UNIFIED IDEOGRAPH
    {0xBF66, 0x779E}, //4687 #CJK UNIFIED IDEOGRAPH
    {0xBF67, 0x779F}, //4688 #CJK UNIFIED IDEOGRAPH
    {0xBF68, 0x77A5}, //4689 #CJK UNIFIED IDEOGRAPH
    {0xBF69, 0x78E8}, //4690 #CJK UNIFIED IDEOGRAPH
    {0xBF6A, 0x78DA}, //4691 #CJK UNIFIED IDEOGRAPH
    {0xBF6B, 0x78EC}, //4692 #CJK UNIFIED IDEOGRAPH
    {0xBF6C, 0x78E7}, //4693 #CJK UNIFIED IDEOGRAPH
    {0xBF6D, 0x79A6}, //4694 #CJK UNIFIED IDEOGRAPH
    {0xBF6E, 0x7A4D}, //4695 #CJK UNIFIED IDEOGRAPH
    {0xBF6F, 0x7A4E}, //4696 #CJK UNIFIED IDEOGRAPH
    {0xBF70, 0x7A46}, //4697 #CJK UNIFIED IDEOGRAPH
    {0xBF71, 0x7A4C}, //4698 #CJK UNIFIED IDEOGRAPH
    {0xBF72, 0x7A4B}, //4699 #CJK UNIFIED IDEOGRAPH
    {0xBF73, 0x7ABA}, //4700 #CJK UNIFIED IDEOGRAPH
    {0xBF74, 0x7BD9}, //4701 #CJK UNIFIED IDEOGRAPH
    {0xBF75, 0x7C11}, //4702 #CJK UNIFIED IDEOGRAPH
    {0xBF76, 0x7BC9}, //4703 #CJK UNIFIED IDEOGRAPH
    {0xBF77, 0x7BE4}, //4704 #CJK UNIFIED IDEOGRAPH
    {0xBF78, 0x7BDB}, //4705 #CJK UNIFIED IDEOGRAPH
    {0xBF79, 0x7BE1}, //4706 #CJK UNIFIED IDEOGRAPH
    {0xBF7A, 0x7BE9}, //4707 #CJK UNIFIED IDEOGRAPH
    {0xBF7B, 0x7BE6}, //4708 #CJK UNIFIED IDEOGRAPH
    {0xBF7C, 0x7CD5}, //4709 #CJK UNIFIED IDEOGRAPH
    {0xBF7D, 0x7CD6}, //4710 #CJK UNIFIED IDEOGRAPH
    {0xBF7E, 0x7E0A}, //4711 #CJK UNIFIED IDEOGRAPH
    {0xBFA1, 0x7E11}, //4712 #CJK UNIFIED IDEOGRAPH
    {0xBFA2, 0x7E08}, //4713 #CJK UNIFIED IDEOGRAPH
    {0xBFA3, 0x7E1B}, //4714 #CJK UNIFIED IDEOGRAPH
    {0xBFA4, 0x7E23}, //4715 #CJK UNIFIED IDEOGRAPH
    {0xBFA5, 0x7E1E}, //4716 #CJK UNIFIED IDEOGRAPH
    {0xBFA6, 0x7E1D}, //4717 #CJK UNIFIED IDEOGRAPH
    {0xBFA7, 0x7E09}, //4718 #CJK UNIFIED IDEOGRAPH
    {0xBFA8, 0x7E10}, //4719 #CJK UNIFIED IDEOGRAPH
    {0xBFA9, 0x7F79}, //4720 #CJK UNIFIED IDEOGRAPH
    {0xBFAA, 0x7FB2}, //4721 #CJK UNIFIED IDEOGRAPH
    {0xBFAB, 0x7FF0}, //4722 #CJK UNIFIED IDEOGRAPH
    {0xBFAC, 0x7FF1}, //4723 #CJK UNIFIED IDEOGRAPH
    {0xBFAD, 0x7FEE}, //4724 #CJK UNIFIED IDEOGRAPH
    {0xBFAE, 0x8028}, //4725 #CJK UNIFIED IDEOGRAPH
    {0xBFAF, 0x81B3}, //4726 #CJK UNIFIED IDEOGRAPH
    {0xBFB0, 0x81A9}, //4727 #CJK UNIFIED IDEOGRAPH
    {0xBFB1, 0x81A8}, //4728 #CJK UNIFIED IDEOGRAPH
    {0xBFB2, 0x81FB}, //4729 #CJK UNIFIED IDEOGRAPH
    {0xBFB3, 0x8208}, //4730 #CJK UNIFIED IDEOGRAPH
    {0xBFB4, 0x8258}, //4731 #CJK UNIFIED IDEOGRAPH
    {0xBFB5, 0x8259}, //4732 #CJK UNIFIED IDEOGRAPH
    {0xBFB6, 0x854A}, //4733 #CJK UNIFIED IDEOGRAPH
    {0xBFB7, 0x8559}, //4734 #CJK UNIFIED IDEOGRAPH
    {0xBFB8, 0x8548}, //4735 #CJK UNIFIED IDEOGRAPH
    {0xBFB9, 0x8568}, //4736 #CJK UNIFIED IDEOGRAPH
    {0xBFBA, 0x8569}, //4737 #CJK UNIFIED IDEOGRAPH
    {0xBFBB, 0x8543}, //4738 #CJK UNIFIED IDEOGRAPH
    {0xBFBC, 0x8549}, //4739 #CJK UNIFIED IDEOGRAPH
    {0xBFBD, 0x856D}, //4740 #CJK UNIFIED IDEOGRAPH
    {0xBFBE, 0x856A}, //4741 #CJK UNIFIED IDEOGRAPH
    {0xBFBF, 0x855E}, //4742 #CJK UNIFIED IDEOGRAPH
    {0xBFC0, 0x8783}, //4743 #CJK UNIFIED IDEOGRAPH
    {0xBFC1, 0x879F}, //4744 #CJK UNIFIED IDEOGRAPH
    {0xBFC2, 0x879E}, //4745 #CJK UNIFIED IDEOGRAPH
    {0xBFC3, 0x87A2}, //4746 #CJK UNIFIED IDEOGRAPH
    {0xBFC4, 0x878D}, //4747 #CJK UNIFIED IDEOGRAPH
    {0xBFC5, 0x8861}, //4748 #CJK UNIFIED IDEOGRAPH
    {0xBFC6, 0x892A}, //4749 #CJK UNIFIED IDEOGRAPH
    {0xBFC7, 0x8932}, //4750 #CJK UNIFIED IDEOGRAPH
    {0xBFC8, 0x8925}, //4751 #CJK UNIFIED IDEOGRAPH
    {0xBFC9, 0x892B}, //4752 #CJK UNIFIED IDEOGRAPH
    {0xBFCA, 0x8921}, //4753 #CJK UNIFIED IDEOGRAPH
    {0xBFCB, 0x89AA}, //4754 #CJK UNIFIED IDEOGRAPH
    {0xBFCC, 0x89A6}, //4755 #CJK UNIFIED IDEOGRAPH
    {0xBFCD, 0x8AE6}, //4756 #CJK UNIFIED IDEOGRAPH
    {0xBFCE, 0x8AFA}, //4757 #CJK UNIFIED IDEOGRAPH
    {0xBFCF, 0x8AEB}, //4758 #CJK UNIFIED IDEOGRAPH
    {0xBFD0, 0x8AF1}, //4759 #CJK UNIFIED IDEOGRAPH
    {0xBFD1, 0x8B00}, //4760 #CJK UNIFIED IDEOGRAPH
    {0xBFD2, 0x8ADC}, //4761 #CJK UNIFIED IDEOGRAPH
    {0xBFD3, 0x8AE7}, //4762 #CJK UNIFIED IDEOGRAPH
    {0xBFD4, 0x8AEE}, //4763 #CJK UNIFIED IDEOGRAPH
    {0xBFD5, 0x8AFE}, //4764 #CJK UNIFIED IDEOGRAPH
    {0xBFD6, 0x8B01}, //4765 #CJK UNIFIED IDEOGRAPH
    {0xBFD7, 0x8B02}, //4766 #CJK UNIFIED IDEOGRAPH
    {0xBFD8, 0x8AF7}, //4767 #CJK UNIFIED IDEOGRAPH
    {0xBFD9, 0x8AED}, //4768 #CJK UNIFIED IDEOGRAPH
    {0xBFDA, 0x8AF3}, //4769 #CJK UNIFIED IDEOGRAPH
    {0xBFDB, 0x8AF6}, //4770 #CJK UNIFIED IDEOGRAPH
    {0xBFDC, 0x8AFC}, //4771 #CJK UNIFIED IDEOGRAPH
    {0xBFDD, 0x8C6B}, //4772 #CJK UNIFIED IDEOGRAPH
    {0xBFDE, 0x8C6D}, //4773 #CJK UNIFIED IDEOGRAPH
    {0xBFDF, 0x8C93}, //4774 #CJK UNIFIED IDEOGRAPH
    {0xBFE0, 0x8CF4}, //4775 #CJK UNIFIED IDEOGRAPH
    {0xBFE1, 0x8E44}, //4776 #CJK UNIFIED IDEOGRAPH
    {0xBFE2, 0x8E31}, //4777 #CJK UNIFIED IDEOGRAPH
    {0xBFE3, 0x8E34}, //4778 #CJK UNIFIED IDEOGRAPH
    {0xBFE4, 0x8E42}, //4779 #CJK UNIFIED IDEOGRAPH
    {0xBFE5, 0x8E39}, //4780 #CJK UNIFIED IDEOGRAPH
    {0xBFE6, 0x8E35}, //4781 #CJK UNIFIED IDEOGRAPH
    {0xBFE7, 0x8F3B}, //4782 #CJK UNIFIED IDEOGRAPH
    {0xBFE8, 0x8F2F}, //4783 #CJK UNIFIED IDEOGRAPH
    {0xBFE9, 0x8F38}, //4784 #CJK UNIFIED IDEOGRAPH
    {0xBFEA, 0x8F33}, //4785 #CJK UNIFIED IDEOGRAPH
    {0xBFEB, 0x8FA8}, //4786 #CJK UNIFIED IDEOGRAPH
    {0xBFEC, 0x8FA6}, //4787 #CJK UNIFIED IDEOGRAPH
    {0xBFED, 0x9075}, //4788 #CJK UNIFIED IDEOGRAPH
    {0xBFEE, 0x9074}, //4789 #CJK UNIFIED IDEOGRAPH
    {0xBFEF, 0x9078}, //4790 #CJK UNIFIED IDEOGRAPH
    {0xBFF0, 0x9072}, //4791 #CJK UNIFIED IDEOGRAPH
    {0xBFF1, 0x907C}, //4792 #CJK UNIFIED IDEOGRAPH
    {0xBFF2, 0x907A}, //4793 #CJK UNIFIED IDEOGRAPH
    {0xBFF3, 0x9134}, //4794 #CJK UNIFIED IDEOGRAPH
    {0xBFF4, 0x9192}, //4795 #CJK UNIFIED IDEOGRAPH
    {0xBFF5, 0x9320}, //4796 #CJK UNIFIED IDEOGRAPH
    {0xBFF6, 0x9336}, //4797 #CJK UNIFIED IDEOGRAPH
    {0xBFF7, 0x92F8}, //4798 #CJK UNIFIED IDEOGRAPH
    {0xBFF8, 0x9333}, //4799 #CJK UNIFIED IDEOGRAPH
    {0xBFF9, 0x932F}, //4800 #CJK UNIFIED IDEOGRAPH
    {0xBFFA, 0x9322}, //4801 #CJK UNIFIED IDEOGRAPH
    {0xBFFB, 0x92FC}, //4802 #CJK UNIFIED IDEOGRAPH
    {0xBFFC, 0x932B}, //4803 #CJK UNIFIED IDEOGRAPH
    {0xBFFD, 0x9304}, //4804 #CJK UNIFIED IDEOGRAPH
    {0xBFFE, 0x931A}, //4805 #CJK UNIFIED IDEOGRAPH
    {0xC040, 0x9310}, //4806 #CJK UNIFIED IDEOGRAPH
    {0xC041, 0x9326}, //4807 #CJK UNIFIED IDEOGRAPH
    {0xC042, 0x9321}, //4808 #CJK UNIFIED IDEOGRAPH
    {0xC043, 0x9315}, //4809 #CJK UNIFIED IDEOGRAPH
    {0xC044, 0x932E}, //4810 #CJK UNIFIED IDEOGRAPH
    {0xC045, 0x9319}, //4811 #CJK UNIFIED IDEOGRAPH
    {0xC046, 0x95BB}, //4812 #CJK UNIFIED IDEOGRAPH
    {0xC047, 0x96A7}, //4813 #CJK UNIFIED IDEOGRAPH
    {0xC048, 0x96A8}, //4814 #CJK UNIFIED IDEOGRAPH
    {0xC049, 0x96AA}, //4815 #CJK UNIFIED IDEOGRAPH
    {0xC04A, 0x96D5}, //4816 #CJK UNIFIED IDEOGRAPH
    {0xC04B, 0x970E}, //4817 #CJK UNIFIED IDEOGRAPH
    {0xC04C, 0x9711}, //4818 #CJK UNIFIED IDEOGRAPH
    {0xC04D, 0x9716}, //4819 #CJK UNIFIED IDEOGRAPH
    {0xC04E, 0x970D}, //4820 #CJK UNIFIED IDEOGRAPH
    {0xC04F, 0x9713}, //4821 #CJK UNIFIED IDEOGRAPH
    {0xC050, 0x970F}, //4822 #CJK UNIFIED IDEOGRAPH
    {0xC051, 0x975B}, //4823 #CJK UNIFIED IDEOGRAPH
    {0xC052, 0x975C}, //4824 #CJK UNIFIED IDEOGRAPH
    {0xC053, 0x9766}, //4825 #CJK UNIFIED IDEOGRAPH
    {0xC054, 0x9798}, //4826 #CJK UNIFIED IDEOGRAPH
    {0xC055, 0x9830}, //4827 #CJK UNIFIED IDEOGRAPH
    {0xC056, 0x9838}, //4828 #CJK UNIFIED IDEOGRAPH
    {0xC057, 0x983B}, //4829 #CJK UNIFIED IDEOGRAPH
    {0xC058, 0x9837}, //4830 #CJK UNIFIED IDEOGRAPH
    {0xC059, 0x982D}, //4831 #CJK UNIFIED IDEOGRAPH
    {0xC05A, 0x9839}, //4832 #CJK UNIFIED IDEOGRAPH
    {0xC05B, 0x9824}, //4833 #CJK UNIFIED IDEOGRAPH
    {0xC05C, 0x9910}, //4834 #CJK UNIFIED IDEOGRAPH
    {0xC05D, 0x9928}, //4835 #CJK UNIFIED IDEOGRAPH
    {0xC05E, 0x991E}, //4836 #CJK UNIFIED IDEOGRAPH
    {0xC05F, 0x991B}, //4837 #CJK UNIFIED IDEOGRAPH
    {0xC060, 0x9921}, //4838 #CJK UNIFIED IDEOGRAPH
    {0xC061, 0x991A}, //4839 #CJK UNIFIED IDEOGRAPH
    {0xC062, 0x99ED}, //4840 #CJK UNIFIED IDEOGRAPH
    {0xC063, 0x99E2}, //4841 #CJK UNIFIED IDEOGRAPH
    {0xC064, 0x99F1}, //4842 #CJK UNIFIED IDEOGRAPH
    {0xC065, 0x9AB8}, //4843 #CJK UNIFIED IDEOGRAPH
    {0xC066, 0x9ABC}, //4844 #CJK UNIFIED IDEOGRAPH
    {0xC067, 0x9AFB}, //4845 #CJK UNIFIED IDEOGRAPH
    {0xC068, 0x9AED}, //4846 #CJK UNIFIED IDEOGRAPH
    {0xC069, 0x9B28}, //4847 #CJK UNIFIED IDEOGRAPH
    {0xC06A, 0x9B91}, //4848 #CJK UNIFIED IDEOGRAPH
    {0xC06B, 0x9D15}, //4849 #CJK UNIFIED IDEOGRAPH
    {0xC06C, 0x9D23}, //4850 #CJK UNIFIED IDEOGRAPH
    {0xC06D, 0x9D26}, //4851 #CJK UNIFIED IDEOGRAPH
    {0xC06E, 0x9D28}, //4852 #CJK UNIFIED IDEOGRAPH
    {0xC06F, 0x9D12}, //4853 #CJK UNIFIED IDEOGRAPH
    {0xC070, 0x9D1B}, //4854 #CJK UNIFIED IDEOGRAPH
    {0xC071, 0x9ED8}, //4855 #CJK UNIFIED IDEOGRAPH
    {0xC072, 0x9ED4}, //4856 #CJK UNIFIED IDEOGRAPH
    {0xC073, 0x9F8D}, //4857 #CJK UNIFIED IDEOGRAPH
    {0xC074, 0x9F9C}, //4858 #CJK UNIFIED IDEOGRAPH
    {0xC075, 0x512A}, //4859 #CJK UNIFIED IDEOGRAPH
    {0xC076, 0x511F}, //4860 #CJK UNIFIED IDEOGRAPH
    {0xC077, 0x5121}, //4861 #CJK UNIFIED IDEOGRAPH
    {0xC078, 0x5132}, //4862 #CJK UNIFIED IDEOGRAPH
    {0xC079, 0x52F5}, //4863 #CJK UNIFIED IDEOGRAPH
    {0xC07A, 0x568E}, //4864 #CJK UNIFIED IDEOGRAPH
    {0xC07B, 0x5680}, //4865 #CJK UNIFIED IDEOGRAPH
    {0xC07C, 0x5690}, //4866 #CJK UNIFIED IDEOGRAPH
    {0xC07D, 0x5685}, //4867 #CJK UNIFIED IDEOGRAPH
    {0xC07E, 0x5687}, //4868 #CJK UNIFIED IDEOGRAPH
    {0xC0A1, 0x568F}, //4869 #CJK UNIFIED IDEOGRAPH
    {0xC0A2, 0x58D5}, //4870 #CJK UNIFIED IDEOGRAPH
    {0xC0A3, 0x58D3}, //4871 #CJK UNIFIED IDEOGRAPH
    {0xC0A4, 0x58D1}, //4872 #CJK UNIFIED IDEOGRAPH
    {0xC0A5, 0x58CE}, //4873 #CJK UNIFIED IDEOGRAPH
    {0xC0A6, 0x5B30}, //4874 #CJK UNIFIED IDEOGRAPH
    {0xC0A7, 0x5B2A}, //4875 #CJK UNIFIED IDEOGRAPH
    {0xC0A8, 0x5B24}, //4876 #CJK UNIFIED IDEOGRAPH
    {0xC0A9, 0x5B7A}, //4877 #CJK UNIFIED IDEOGRAPH
    {0xC0AA, 0x5C37}, //4878 #CJK UNIFIED IDEOGRAPH
    {0xC0AB, 0x5C68}, //4879 #CJK UNIFIED IDEOGRAPH
    {0xC0AC, 0x5DBC}, //4880 #CJK UNIFIED IDEOGRAPH
    {0xC0AD, 0x5DBA}, //4881 #CJK UNIFIED IDEOGRAPH
    {0xC0AE, 0x5DBD}, //4882 #CJK UNIFIED IDEOGRAPH
    {0xC0AF, 0x5DB8}, //4883 #CJK UNIFIED IDEOGRAPH
    {0xC0B0, 0x5E6B}, //4884 #CJK UNIFIED IDEOGRAPH
    {0xC0B1, 0x5F4C}, //4885 #CJK UNIFIED IDEOGRAPH
    {0xC0B2, 0x5FBD}, //4886 #CJK UNIFIED IDEOGRAPH
    {0xC0B3, 0x61C9}, //4887 #CJK UNIFIED IDEOGRAPH
    {0xC0B4, 0x61C2}, //4888 #CJK UNIFIED IDEOGRAPH
    {0xC0B5, 0x61C7}, //4889 #CJK UNIFIED IDEOGRAPH
    {0xC0B6, 0x61E6}, //4890 #CJK UNIFIED IDEOGRAPH
    {0xC0B7, 0x61CB}, //4891 #CJK UNIFIED IDEOGRAPH
    {0xC0B8, 0x6232}, //4892 #CJK UNIFIED IDEOGRAPH
    {0xC0B9, 0x6234}, //4893 #CJK UNIFIED IDEOGRAPH
    {0xC0BA, 0x64CE}, //4894 #CJK UNIFIED IDEOGRAPH
    {0xC0BB, 0x64CA}, //4895 #CJK UNIFIED IDEOGRAPH
    {0xC0BC, 0x64D8}, //4896 #CJK UNIFIED IDEOGRAPH
    {0xC0BD, 0x64E0}, //4897 #CJK UNIFIED IDEOGRAPH
    {0xC0BE, 0x64F0}, //4898 #CJK UNIFIED IDEOGRAPH
    {0xC0BF, 0x64E6}, //4899 #CJK UNIFIED IDEOGRAPH
    {0xC0C0, 0x64EC}, //4900 #CJK UNIFIED IDEOGRAPH
    {0xC0C1, 0x64F1}, //4901 #CJK UNIFIED IDEOGRAPH
    {0xC0C2, 0x64E2}, //4902 #CJK UNIFIED IDEOGRAPH
    {0xC0C3, 0x64ED}, //4903 #CJK UNIFIED IDEOGRAPH
    {0xC0C4, 0x6582}, //4904 #CJK UNIFIED IDEOGRAPH
    {0xC0C5, 0x6583}, //4905 #CJK UNIFIED IDEOGRAPH
    {0xC0C6, 0x66D9}, //4906 #CJK UNIFIED IDEOGRAPH
    {0xC0C7, 0x66D6}, //4907 #CJK UNIFIED IDEOGRAPH
    {0xC0C8, 0x6A80}, //4908 #CJK UNIFIED IDEOGRAPH
    {0xC0C9, 0x6A94}, //4909 #CJK UNIFIED IDEOGRAPH
    {0xC0CA, 0x6A84}, //4910 #CJK UNIFIED IDEOGRAPH
    {0xC0CB, 0x6AA2}, //4911 #CJK UNIFIED IDEOGRAPH
    {0xC0CC, 0x6A9C}, //4912 #CJK UNIFIED IDEOGRAPH
    {0xC0CD, 0x6ADB}, //4913 #CJK UNIFIED IDEOGRAPH
    {0xC0CE, 0x6AA3}, //4914 #CJK UNIFIED IDEOGRAPH
    {0xC0CF, 0x6A7E}, //4915 #CJK UNIFIED IDEOGRAPH
    {0xC0D0, 0x6A97}, //4916 #CJK UNIFIED IDEOGRAPH
    {0xC0D1, 0x6A90}, //4917 #CJK UNIFIED IDEOGRAPH
    {0xC0D2, 0x6AA0}, //4918 #CJK UNIFIED IDEOGRAPH
    {0xC0D3, 0x6B5C}, //4919 #CJK UNIFIED IDEOGRAPH
    {0xC0D4, 0x6BAE}, //4920 #CJK UNIFIED IDEOGRAPH
    {0xC0D5, 0x6BDA}, //4921 #CJK UNIFIED IDEOGRAPH
    {0xC0D6, 0x6C08}, //4922 #CJK UNIFIED IDEOGRAPH
    {0xC0D7, 0x6FD8}, //4923 #CJK UNIFIED IDEOGRAPH
    {0xC0D8, 0x6FF1}, //4924 #CJK UNIFIED IDEOGRAPH
    {0xC0D9, 0x6FDF}, //4925 #CJK UNIFIED IDEOGRAPH
    {0xC0DA, 0x6FE0}, //4926 #CJK UNIFIED IDEOGRAPH
    {0xC0DB, 0x6FDB}, //4927 #CJK UNIFIED IDEOGRAPH
    {0xC0DC, 0x6FE4}, //4928 #CJK UNIFIED IDEOGRAPH
    {0xC0DD, 0x6FEB}, //4929 #CJK UNIFIED IDEOGRAPH
    {0xC0DE, 0x6FEF}, //4930 #CJK UNIFIED IDEOGRAPH
    {0xC0DF, 0x6F80}, //4931 #CJK UNIFIED IDEOGRAPH
    {0xC0E0, 0x6FEC}, //4932 #CJK UNIFIED IDEOGRAPH
    {0xC0E1, 0x6FE1}, //4933 #CJK UNIFIED IDEOGRAPH
    {0xC0E2, 0x6FE9}, //4934 #CJK UNIFIED IDEOGRAPH
    {0xC0E3, 0x6FD5}, //4935 #CJK UNIFIED IDEOGRAPH
    {0xC0E4, 0x6FEE}, //4936 #CJK UNIFIED IDEOGRAPH
    {0xC0E5, 0x6FF0}, //4937 #CJK UNIFIED IDEOGRAPH
    {0xC0E6, 0x71E7}, //4938 #CJK UNIFIED IDEOGRAPH
    {0xC0E7, 0x71DF}, //4939 #CJK UNIFIED IDEOGRAPH
    {0xC0E8, 0x71EE}, //4940 #CJK UNIFIED IDEOGRAPH
    {0xC0E9, 0x71E6}, //4941 #CJK UNIFIED IDEOGRAPH
    {0xC0EA, 0x71E5}, //4942 #CJK UNIFIED IDEOGRAPH
    {0xC0EB, 0x71ED}, //4943 #CJK UNIFIED IDEOGRAPH
    {0xC0EC, 0x71EC}, //4944 #CJK UNIFIED IDEOGRAPH
    {0xC0ED, 0x71F4}, //4945 #CJK UNIFIED IDEOGRAPH
    {0xC0EE, 0x71E0}, //4946 #CJK UNIFIED IDEOGRAPH
    {0xC0EF, 0x7235}, //4947 #CJK UNIFIED IDEOGRAPH
    {0xC0F0, 0x7246}, //4948 #CJK UNIFIED IDEOGRAPH
    {0xC0F1, 0x7370}, //4949 #CJK UNIFIED IDEOGRAPH
    {0xC0F2, 0x7372}, //4950 #CJK UNIFIED IDEOGRAPH
    {0xC0F3, 0x74A9}, //4951 #CJK UNIFIED IDEOGRAPH
    {0xC0F4, 0x74B0}, //4952 #CJK UNIFIED IDEOGRAPH
    {0xC0F5, 0x74A6}, //4953 #CJK UNIFIED IDEOGRAPH
    {0xC0F6, 0x74A8}, //4954 #CJK UNIFIED IDEOGRAPH
    {0xC0F7, 0x7646}, //4955 #CJK UNIFIED IDEOGRAPH
    {0xC0F8, 0x7642}, //4956 #CJK UNIFIED IDEOGRAPH
    {0xC0F9, 0x764C}, //4957 #CJK UNIFIED IDEOGRAPH
    {0xC0FA, 0x76EA}, //4958 #CJK UNIFIED IDEOGRAPH
    {0xC0FB, 0x77B3}, //4959 #CJK UNIFIED IDEOGRAPH
    {0xC0FC, 0x77AA}, //4960 #CJK UNIFIED IDEOGRAPH
    {0xC0FD, 0x77B0}, //4961 #CJK UNIFIED IDEOGRAPH
    {0xC0FE, 0x77AC}, //4962 #CJK UNIFIED IDEOGRAPH
    {0xC140, 0x77A7}, //4963 #CJK UNIFIED IDEOGRAPH
    {0xC141, 0x77AD}, //4964 #CJK UNIFIED IDEOGRAPH
    {0xC142, 0x77EF}, //4965 #CJK UNIFIED IDEOGRAPH
    {0xC143, 0x78F7}, //4966 #CJK UNIFIED IDEOGRAPH
    {0xC144, 0x78FA}, //4967 #CJK UNIFIED IDEOGRAPH
    {0xC145, 0x78F4}, //4968 #CJK UNIFIED IDEOGRAPH
    {0xC146, 0x78EF}, //4969 #CJK UNIFIED IDEOGRAPH
    {0xC147, 0x7901}, //4970 #CJK UNIFIED IDEOGRAPH
    {0xC148, 0x79A7}, //4971 #CJK UNIFIED IDEOGRAPH
    {0xC149, 0x79AA}, //4972 #CJK UNIFIED IDEOGRAPH
    {0xC14A, 0x7A57}, //4973 #CJK UNIFIED IDEOGRAPH
    {0xC14B, 0x7ABF}, //4974 #CJK UNIFIED IDEOGRAPH
    {0xC14C, 0x7C07}, //4975 #CJK UNIFIED IDEOGRAPH
    {0xC14D, 0x7C0D}, //4976 #CJK UNIFIED IDEOGRAPH
    {0xC14E, 0x7BFE}, //4977 #CJK UNIFIED IDEOGRAPH
    {0xC14F, 0x7BF7}, //4978 #CJK UNIFIED IDEOGRAPH
    {0xC150, 0x7C0C}, //4979 #CJK UNIFIED IDEOGRAPH
    {0xC151, 0x7BE0}, //4980 #CJK UNIFIED IDEOGRAPH
    {0xC152, 0x7CE0}, //4981 #CJK UNIFIED IDEOGRAPH
    {0xC153, 0x7CDC}, //4982 #CJK UNIFIED IDEOGRAPH
    {0xC154, 0x7CDE}, //4983 #CJK UNIFIED IDEOGRAPH
    {0xC155, 0x7CE2}, //4984 #CJK UNIFIED IDEOGRAPH
    {0xC156, 0x7CDF}, //4985 #CJK UNIFIED IDEOGRAPH
    {0xC157, 0x7CD9}, //4986 #CJK UNIFIED IDEOGRAPH
    {0xC158, 0x7CDD}, //4987 #CJK UNIFIED IDEOGRAPH
    {0xC159, 0x7E2E}, //4988 #CJK UNIFIED IDEOGRAPH
    {0xC15A, 0x7E3E}, //4989 #CJK UNIFIED IDEOGRAPH
    {0xC15B, 0x7E46}, //4990 #CJK UNIFIED IDEOGRAPH
    {0xC15C, 0x7E37}, //4991 #CJK UNIFIED IDEOGRAPH
    {0xC15D, 0x7E32}, //4992 #CJK UNIFIED IDEOGRAPH
    {0xC15E, 0x7E43}, //4993 #CJK UNIFIED IDEOGRAPH
    {0xC15F, 0x7E2B}, //4994 #CJK UNIFIED IDEOGRAPH
    {0xC160, 0x7E3D}, //4995 #CJK UNIFIED IDEOGRAPH
    {0xC161, 0x7E31}, //4996 #CJK UNIFIED IDEOGRAPH
    {0xC162, 0x7E45}, //4997 #CJK UNIFIED IDEOGRAPH
    {0xC163, 0x7E41}, //4998 #CJK UNIFIED IDEOGRAPH
    {0xC164, 0x7E34}, //4999 #CJK UNIFIED IDEOGRAPH
    {0xC165, 0x7E39}, //5000 #CJK UNIFIED IDEOGRAPH
    {0xC166, 0x7E48}, //5001 #CJK UNIFIED IDEOGRAPH
    {0xC167, 0x7E35}, //5002 #CJK UNIFIED IDEOGRAPH
    {0xC168, 0x7E3F}, //5003 #CJK UNIFIED IDEOGRAPH
    {0xC169, 0x7E2F}, //5004 #CJK UNIFIED IDEOGRAPH
    {0xC16A, 0x7F44}, //5005 #CJK UNIFIED IDEOGRAPH
    {0xC16B, 0x7FF3}, //5006 #CJK UNIFIED IDEOGRAPH
    {0xC16C, 0x7FFC}, //5007 #CJK UNIFIED IDEOGRAPH
    {0xC16D, 0x8071}, //5008 #CJK UNIFIED IDEOGRAPH
    {0xC16E, 0x8072}, //5009 #CJK UNIFIED IDEOGRAPH
    {0xC16F, 0x8070}, //5010 #CJK UNIFIED IDEOGRAPH
    {0xC170, 0x806F}, //5011 #CJK UNIFIED IDEOGRAPH
    {0xC171, 0x8073}, //5012 #CJK UNIFIED IDEOGRAPH
    {0xC172, 0x81C6}, //5013 #CJK UNIFIED IDEOGRAPH
    {0xC173, 0x81C3}, //5014 #CJK UNIFIED IDEOGRAPH
    {0xC174, 0x81BA}, //5015 #CJK UNIFIED IDEOGRAPH
    {0xC175, 0x81C2}, //5016 #CJK UNIFIED IDEOGRAPH
    {0xC176, 0x81C0}, //5017 #CJK UNIFIED IDEOGRAPH
    {0xC177, 0x81BF}, //5018 #CJK UNIFIED IDEOGRAPH
    {0xC178, 0x81BD}, //5019 #CJK UNIFIED IDEOGRAPH
    {0xC179, 0x81C9}, //5020 #CJK UNIFIED IDEOGRAPH
    {0xC17A, 0x81BE}, //5021 #CJK UNIFIED IDEOGRAPH
    {0xC17B, 0x81E8}, //5022 #CJK UNIFIED IDEOGRAPH
    {0xC17C, 0x8209}, //5023 #CJK UNIFIED IDEOGRAPH
    {0xC17D, 0x8271}, //5024 #CJK UNIFIED IDEOGRAPH
    {0xC17E, 0x85AA}, //5025 #CJK UNIFIED IDEOGRAPH
    {0xC1A1, 0x8584}, //5026 #CJK UNIFIED IDEOGRAPH
    {0xC1A2, 0x857E}, //5027 #CJK UNIFIED IDEOGRAPH
    {0xC1A3, 0x859C}, //5028 #CJK UNIFIED IDEOGRAPH
    {0xC1A4, 0x8591}, //5029 #CJK UNIFIED IDEOGRAPH
    {0xC1A5, 0x8594}, //5030 #CJK UNIFIED IDEOGRAPH
    {0xC1A6, 0x85AF}, //5031 #CJK UNIFIED IDEOGRAPH
    {0xC1A7, 0x859B}, //5032 #CJK UNIFIED IDEOGRAPH
    {0xC1A8, 0x8587}, //5033 #CJK UNIFIED IDEOGRAPH
    {0xC1A9, 0x85A8}, //5034 #CJK UNIFIED IDEOGRAPH
    {0xC1AA, 0x858A}, //5035 #CJK UNIFIED IDEOGRAPH
    {0xC1AB, 0x8667}, //5036 #CJK UNIFIED IDEOGRAPH
    {0xC1AC, 0x87C0}, //5037 #CJK UNIFIED IDEOGRAPH
    {0xC1AD, 0x87D1}, //5038 #CJK UNIFIED IDEOGRAPH
    {0xC1AE, 0x87B3}, //5039 #CJK UNIFIED IDEOGRAPH
    {0xC1AF, 0x87D2}, //5040 #CJK UNIFIED IDEOGRAPH
    {0xC1B0, 0x87C6}, //5041 #CJK UNIFIED IDEOGRAPH
    {0xC1B1, 0x87AB}, //5042 #CJK UNIFIED IDEOGRAPH
    {0xC1B2, 0x87BB}, //5043 #CJK UNIFIED IDEOGRAPH
    {0xC1B3, 0x87BA}, //5044 #CJK UNIFIED IDEOGRAPH
    {0xC1B4, 0x87C8}, //5045 #CJK UNIFIED IDEOGRAPH
    {0xC1B5, 0x87CB}, //5046 #CJK UNIFIED IDEOGRAPH
    {0xC1B6, 0x893B}, //5047 #CJK UNIFIED IDEOGRAPH
    {0xC1B7, 0x8936}, //5048 #CJK UNIFIED IDEOGRAPH
    {0xC1B8, 0x8944}, //5049 #CJK UNIFIED IDEOGRAPH
    {0xC1B9, 0x8938}, //5050 #CJK UNIFIED IDEOGRAPH
    {0xC1BA, 0x893D}, //5051 #CJK UNIFIED IDEOGRAPH
    {0xC1BB, 0x89AC}, //5052 #CJK UNIFIED IDEOGRAPH
    {0xC1BC, 0x8B0E}, //5053 #CJK UNIFIED IDEOGRAPH
    {0xC1BD, 0x8B17}, //5054 #CJK UNIFIED IDEOGRAPH
    {0xC1BE, 0x8B19}, //5055 #CJK UNIFIED IDEOGRAPH
    {0xC1BF, 0x8B1B}, //5056 #CJK UNIFIED IDEOGRAPH
    {0xC1C0, 0x8B0A}, //5057 #CJK UNIFIED IDEOGRAPH
    {0xC1C1, 0x8B20}, //5058 #CJK UNIFIED IDEOGRAPH
    {0xC1C2, 0x8B1D}, //5059 #CJK UNIFIED IDEOGRAPH
    {0xC1C3, 0x8B04}, //5060 #CJK UNIFIED IDEOGRAPH
    {0xC1C4, 0x8B10}, //5061 #CJK UNIFIED IDEOGRAPH
    {0xC1C5, 0x8C41}, //5062 #CJK UNIFIED IDEOGRAPH
    {0xC1C6, 0x8C3F}, //5063 #CJK UNIFIED IDEOGRAPH
    {0xC1C7, 0x8C73}, //5064 #CJK UNIFIED IDEOGRAPH
    {0xC1C8, 0x8CFA}, //5065 #CJK UNIFIED IDEOGRAPH
    {0xC1C9, 0x8CFD}, //5066 #CJK UNIFIED IDEOGRAPH
    {0xC1CA, 0x8CFC}, //5067 #CJK UNIFIED IDEOGRAPH
    {0xC1CB, 0x8CF8}, //5068 #CJK UNIFIED IDEOGRAPH
    {0xC1CC, 0x8CFB}, //5069 #CJK UNIFIED IDEOGRAPH
    {0xC1CD, 0x8DA8}, //5070 #CJK UNIFIED IDEOGRAPH
    {0xC1CE, 0x8E49}, //5071 #CJK UNIFIED IDEOGRAPH
    {0xC1CF, 0x8E4B}, //5072 #CJK UNIFIED IDEOGRAPH
    {0xC1D0, 0x8E48}, //5073 #CJK UNIFIED IDEOGRAPH
    {0xC1D1, 0x8E4A}, //5074 #CJK UNIFIED IDEOGRAPH
    {0xC1D2, 0x8F44}, //5075 #CJK UNIFIED IDEOGRAPH
    {0xC1D3, 0x8F3E}, //5076 #CJK UNIFIED IDEOGRAPH
    {0xC1D4, 0x8F42}, //5077 #CJK UNIFIED IDEOGRAPH
    {0xC1D5, 0x8F45}, //5078 #CJK UNIFIED IDEOGRAPH
    {0xC1D6, 0x8F3F}, //5079 #CJK UNIFIED IDEOGRAPH
    {0xC1D7, 0x907F}, //5080 #CJK UNIFIED IDEOGRAPH
    {0xC1D8, 0x907D}, //5081 #CJK UNIFIED IDEOGRAPH
    {0xC1D9, 0x9084}, //5082 #CJK UNIFIED IDEOGRAPH
    {0xC1DA, 0x9081}, //5083 #CJK UNIFIED IDEOGRAPH
    {0xC1DB, 0x9082}, //5084 #CJK UNIFIED IDEOGRAPH
    {0xC1DC, 0x9080}, //5085 #CJK UNIFIED IDEOGRAPH
    {0xC1DD, 0x9139}, //5086 #CJK UNIFIED IDEOGRAPH
    {0xC1DE, 0x91A3}, //5087 #CJK UNIFIED IDEOGRAPH
    {0xC1DF, 0x919E}, //5088 #CJK UNIFIED IDEOGRAPH
    {0xC1E0, 0x919C}, //5089 #CJK UNIFIED IDEOGRAPH
    {0xC1E1, 0x934D}, //5090 #CJK UNIFIED IDEOGRAPH
    {0xC1E2, 0x9382}, //5091 #CJK UNIFIED IDEOGRAPH
    {0xC1E3, 0x9328}, //5092 #CJK UNIFIED IDEOGRAPH
    {0xC1E4, 0x9375}, //5093 #CJK UNIFIED IDEOGRAPH
    {0xC1E5, 0x934A}, //5094 #CJK UNIFIED IDEOGRAPH
    {0xC1E6, 0x9365}, //5095 #CJK UNIFIED IDEOGRAPH
    {0xC1E7, 0x934B}, //5096 #CJK UNIFIED IDEOGRAPH
    {0xC1E8, 0x9318}, //5097 #CJK UNIFIED IDEOGRAPH
    {0xC1E9, 0x937E}, //5098 #CJK UNIFIED IDEOGRAPH
    {0xC1EA, 0x936C}, //5099 #CJK UNIFIED IDEOGRAPH
    {0xC1EB, 0x935B}, //5100 #CJK UNIFIED IDEOGRAPH
    {0xC1EC, 0x9370}, //5101 #CJK UNIFIED IDEOGRAPH
    {0xC1ED, 0x935A}, //5102 #CJK UNIFIED IDEOGRAPH
    {0xC1EE, 0x9354}, //5103 #CJK UNIFIED IDEOGRAPH
    {0xC1EF, 0x95CA}, //5104 #CJK UNIFIED IDEOGRAPH
    {0xC1F0, 0x95CB}, //5105 #CJK UNIFIED IDEOGRAPH
    {0xC1F1, 0x95CC}, //5106 #CJK UNIFIED IDEOGRAPH
    {0xC1F2, 0x95C8}, //5107 #CJK UNIFIED IDEOGRAPH
    {0xC1F3, 0x95C6}, //5108 #CJK UNIFIED IDEOGRAPH
    {0xC1F4, 0x96B1}, //5109 #CJK UNIFIED IDEOGRAPH
    {0xC1F5, 0x96B8}, //5110 #CJK UNIFIED IDEOGRAPH
    {0xC1F6, 0x96D6}, //5111 #CJK UNIFIED IDEOGRAPH
    {0xC1F7, 0x971C}, //5112 #CJK UNIFIED IDEOGRAPH
    {0xC1F8, 0x971E}, //5113 #CJK UNIFIED IDEOGRAPH
    {0xC1F9, 0x97A0}, //5114 #CJK UNIFIED IDEOGRAPH
    {0xC1FA, 0x97D3}, //5115 #CJK UNIFIED IDEOGRAPH
    {0xC1FB, 0x9846}, //5116 #CJK UNIFIED IDEOGRAPH
    {0xC1FC, 0x98B6}, //5117 #CJK UNIFIED IDEOGRAPH
    {0xC1FD, 0x9935}, //5118 #CJK UNIFIED IDEOGRAPH
    {0xC1FE, 0x9A01}, //5119 #CJK UNIFIED IDEOGRAPH
    {0xC240, 0x99FF}, //5120 #CJK UNIFIED IDEOGRAPH
    {0xC241, 0x9BAE}, //5121 #CJK UNIFIED IDEOGRAPH
    {0xC242, 0x9BAB}, //5122 #CJK UNIFIED IDEOGRAPH
    {0xC243, 0x9BAA}, //5123 #CJK UNIFIED IDEOGRAPH
    {0xC244, 0x9BAD}, //5124 #CJK UNIFIED IDEOGRAPH
    {0xC245, 0x9D3B}, //5125 #CJK UNIFIED IDEOGRAPH
    {0xC246, 0x9D3F}, //5126 #CJK UNIFIED IDEOGRAPH
    {0xC247, 0x9E8B}, //5127 #CJK UNIFIED IDEOGRAPH
    {0xC248, 0x9ECF}, //5128 #CJK UNIFIED IDEOGRAPH
    {0xC249, 0x9EDE}, //5129 #CJK UNIFIED IDEOGRAPH
    {0xC24A, 0x9EDC}, //5130 #CJK UNIFIED IDEOGRAPH
    {0xC24B, 0x9EDD}, //5131 #CJK UNIFIED IDEOGRAPH
    {0xC24C, 0x9EDB}, //5132 #CJK UNIFIED IDEOGRAPH
    {0xC24D, 0x9F3E}, //5133 #CJK UNIFIED IDEOGRAPH
    {0xC24E, 0x9F4B}, //5134 #CJK UNIFIED IDEOGRAPH
    {0xC24F, 0x53E2}, //5135 #CJK UNIFIED IDEOGRAPH
    {0xC250, 0x5695}, //5136 #CJK UNIFIED IDEOGRAPH
    {0xC251, 0x56AE}, //5137 #CJK UNIFIED IDEOGRAPH
    {0xC252, 0x58D9}, //5138 #CJK UNIFIED IDEOGRAPH
    {0xC253, 0x58D8}, //5139 #CJK UNIFIED IDEOGRAPH
    {0xC254, 0x5B38}, //5140 #CJK UNIFIED IDEOGRAPH
    {0xC255, 0x5F5D}, //5141 #CJK UNIFIED IDEOGRAPH
    {0xC256, 0x61E3}, //5142 #CJK UNIFIED IDEOGRAPH
    {0xC257, 0x6233}, //5143 #CJK UNIFIED IDEOGRAPH
    {0xC258, 0x64F4}, //5144 #CJK UNIFIED IDEOGRAPH
    {0xC259, 0x64F2}, //5145 #CJK UNIFIED IDEOGRAPH
    {0xC25A, 0x64FE}, //5146 #CJK UNIFIED IDEOGRAPH
    {0xC25B, 0x6506}, //5147 #CJK UNIFIED IDEOGRAPH
    {0xC25C, 0x64FA}, //5148 #CJK UNIFIED IDEOGRAPH
    {0xC25D, 0x64FB}, //5149 #CJK UNIFIED IDEOGRAPH
    {0xC25E, 0x64F7}, //5150 #CJK UNIFIED IDEOGRAPH
    {0xC25F, 0x65B7}, //5151 #CJK UNIFIED IDEOGRAPH
    {0xC260, 0x66DC}, //5152 #CJK UNIFIED IDEOGRAPH
    {0xC261, 0x6726}, //5153 #CJK UNIFIED IDEOGRAPH
    {0xC262, 0x6AB3}, //5154 #CJK UNIFIED IDEOGRAPH
    {0xC263, 0x6AAC}, //5155 #CJK UNIFIED IDEOGRAPH
    {0xC264, 0x6AC3}, //5156 #CJK UNIFIED IDEOGRAPH
    {0xC265, 0x6ABB}, //5157 #CJK UNIFIED IDEOGRAPH
    {0xC266, 0x6AB8}, //5158 #CJK UNIFIED IDEOGRAPH
    {0xC267, 0x6AC2}, //5159 #CJK UNIFIED IDEOGRAPH
    {0xC268, 0x6AAE}, //5160 #CJK UNIFIED IDEOGRAPH
    {0xC269, 0x6AAF}, //5161 #CJK UNIFIED IDEOGRAPH
    {0xC26A, 0x6B5F}, //5162 #CJK UNIFIED IDEOGRAPH
    {0xC26B, 0x6B78}, //5163 #CJK UNIFIED IDEOGRAPH
    {0xC26C, 0x6BAF}, //5164 #CJK UNIFIED IDEOGRAPH
    {0xC26D, 0x7009}, //5165 #CJK UNIFIED IDEOGRAPH
    {0xC26E, 0x700B}, //5166 #CJK UNIFIED IDEOGRAPH
    {0xC26F, 0x6FFE}, //5167 #CJK UNIFIED IDEOGRAPH
    {0xC270, 0x7006}, //5168 #CJK UNIFIED IDEOGRAPH
    {0xC271, 0x6FFA}, //5169 #CJK UNIFIED IDEOGRAPH
    {0xC272, 0x7011}, //5170 #CJK UNIFIED IDEOGRAPH
    {0xC273, 0x700F}, //5171 #CJK UNIFIED IDEOGRAPH
    {0xC274, 0x71FB}, //5172 #CJK UNIFIED IDEOGRAPH
    {0xC275, 0x71FC}, //5173 #CJK UNIFIED IDEOGRAPH
    {0xC276, 0x71FE}, //5174 #CJK UNIFIED IDEOGRAPH
    {0xC277, 0x71F8}, //5175 #CJK UNIFIED IDEOGRAPH
    {0xC278, 0x7377}, //5176 #CJK UNIFIED IDEOGRAPH
    {0xC279, 0x7375}, //5177 #CJK UNIFIED IDEOGRAPH
    {0xC27A, 0x74A7}, //5178 #CJK UNIFIED IDEOGRAPH
    {0xC27B, 0x74BF}, //5179 #CJK UNIFIED IDEOGRAPH
    {0xC27C, 0x7515}, //5180 #CJK UNIFIED IDEOGRAPH
    {0xC27D, 0x7656}, //5181 #CJK UNIFIED IDEOGRAPH
    {0xC27E, 0x7658}, //5182 #CJK UNIFIED IDEOGRAPH
    {0xC2A1, 0x7652}, //5183 #CJK UNIFIED IDEOGRAPH
    {0xC2A2, 0x77BD}, //5184 #CJK UNIFIED IDEOGRAPH
    {0xC2A3, 0x77BF}, //5185 #CJK UNIFIED IDEOGRAPH
    {0xC2A4, 0x77BB}, //5186 #CJK UNIFIED IDEOGRAPH
    {0xC2A5, 0x77BC}, //5187 #CJK UNIFIED IDEOGRAPH
    {0xC2A6, 0x790E}, //5188 #CJK UNIFIED IDEOGRAPH
    {0xC2A7, 0x79AE}, //5189 #CJK UNIFIED IDEOGRAPH
    {0xC2A8, 0x7A61}, //5190 #CJK UNIFIED IDEOGRAPH
    {0xC2A9, 0x7A62}, //5191 #CJK UNIFIED IDEOGRAPH
    {0xC2AA, 0x7A60}, //5192 #CJK UNIFIED IDEOGRAPH
    {0xC2AB, 0x7AC4}, //5193 #CJK UNIFIED IDEOGRAPH
    {0xC2AC, 0x7AC5}, //5194 #CJK UNIFIED IDEOGRAPH
    {0xC2AD, 0x7C2B}, //5195 #CJK UNIFIED IDEOGRAPH
    {0xC2AE, 0x7C27}, //5196 #CJK UNIFIED IDEOGRAPH
    {0xC2AF, 0x7C2A}, //5197 #CJK UNIFIED IDEOGRAPH
    {0xC2B0, 0x7C1E}, //5198 #CJK UNIFIED IDEOGRAPH
    {0xC2B1, 0x7C23}, //5199 #CJK UNIFIED IDEOGRAPH
    {0xC2B2, 0x7C21}, //5200 #CJK UNIFIED IDEOGRAPH
    {0xC2B3, 0x7CE7}, //5201 #CJK UNIFIED IDEOGRAPH
    {0xC2B4, 0x7E54}, //5202 #CJK UNIFIED IDEOGRAPH
    {0xC2B5, 0x7E55}, //5203 #CJK UNIFIED IDEOGRAPH
    {0xC2B6, 0x7E5E}, //5204 #CJK UNIFIED IDEOGRAPH
    {0xC2B7, 0x7E5A}, //5205 #CJK UNIFIED IDEOGRAPH
    {0xC2B8, 0x7E61}, //5206 #CJK UNIFIED IDEOGRAPH
    {0xC2B9, 0x7E52}, //5207 #CJK UNIFIED IDEOGRAPH
    {0xC2BA, 0x7E59}, //5208 #CJK UNIFIED IDEOGRAPH
    {0xC2BB, 0x7F48}, //5209 #CJK UNIFIED IDEOGRAPH
    {0xC2BC, 0x7FF9}, //5210 #CJK UNIFIED IDEOGRAPH
    {0xC2BD, 0x7FFB}, //5211 #CJK UNIFIED IDEOGRAPH
    {0xC2BE, 0x8077}, //5212 #CJK UNIFIED IDEOGRAPH
    {0xC2BF, 0x8076}, //5213 #CJK UNIFIED IDEOGRAPH
    {0xC2C0, 0x81CD}, //5214 #CJK UNIFIED IDEOGRAPH
    {0xC2C1, 0x81CF}, //5215 #CJK UNIFIED IDEOGRAPH
    {0xC2C2, 0x820A}, //5216 #CJK UNIFIED IDEOGRAPH
    {0xC2C3, 0x85CF}, //5217 #CJK UNIFIED IDEOGRAPH
    {0xC2C4, 0x85A9}, //5218 #CJK UNIFIED IDEOGRAPH
    {0xC2C5, 0x85CD}, //5219 #CJK UNIFIED IDEOGRAPH
    {0xC2C6, 0x85D0}, //5220 #CJK UNIFIED IDEOGRAPH
    {0xC2C7, 0x85C9}, //5221 #CJK UNIFIED IDEOGRAPH
    {0xC2C8, 0x85B0}, //5222 #CJK UNIFIED IDEOGRAPH
    {0xC2C9, 0x85BA}, //5223 #CJK UNIFIED IDEOGRAPH
    {0xC2CA, 0x85B9}, //5224 #CJK UNIFIED IDEOGRAPH
    {0xC2CB, 0x85A6}, //5225 #CJK UNIFIED IDEOGRAPH
    {0xC2CC, 0x87EF}, //5226 #CJK UNIFIED IDEOGRAPH
    {0xC2CD, 0x87EC}, //5227 #CJK UNIFIED IDEOGRAPH
    {0xC2CE, 0x87F2}, //5228 #CJK UNIFIED IDEOGRAPH
    {0xC2CF, 0x87E0}, //5229 #CJK UNIFIED IDEOGRAPH
    {0xC2D0, 0x8986}, //5230 #CJK UNIFIED IDEOGRAPH
    {0xC2D1, 0x89B2}, //5231 #CJK UNIFIED IDEOGRAPH
    {0xC2D2, 0x89F4}, //5232 #CJK UNIFIED IDEOGRAPH
    {0xC2D3, 0x8B28}, //5233 #CJK UNIFIED IDEOGRAPH
    {0xC2D4, 0x8B39}, //5234 #CJK UNIFIED IDEOGRAPH
    {0xC2D5, 0x8B2C}, //5235 #CJK UNIFIED IDEOGRAPH
    {0xC2D6, 0x8B2B}, //5236 #CJK UNIFIED IDEOGRAPH
    {0xC2D7, 0x8C50}, //5237 #CJK UNIFIED IDEOGRAPH
    {0xC2D8, 0x8D05}, //5238 #CJK UNIFIED IDEOGRAPH
    {0xC2D9, 0x8E59}, //5239 #CJK UNIFIED IDEOGRAPH
    {0xC2DA, 0x8E63}, //5240 #CJK UNIFIED IDEOGRAPH
    {0xC2DB, 0x8E66}, //5241 #CJK UNIFIED IDEOGRAPH
    {0xC2DC, 0x8E64}, //5242 #CJK UNIFIED IDEOGRAPH
    {0xC2DD, 0x8E5F}, //5243 #CJK UNIFIED IDEOGRAPH
    {0xC2DE, 0x8E55}, //5244 #CJK UNIFIED IDEOGRAPH
    {0xC2DF, 0x8EC0}, //5245 #CJK UNIFIED IDEOGRAPH
    {0xC2E0, 0x8F49}, //5246 #CJK UNIFIED IDEOGRAPH
    {0xC2E1, 0x8F4D}, //5247 #CJK UNIFIED IDEOGRAPH
    {0xC2E2, 0x9087}, //5248 #CJK UNIFIED IDEOGRAPH
    {0xC2E3, 0x9083}, //5249 #CJK UNIFIED IDEOGRAPH
    {0xC2E4, 0x9088}, //5250 #CJK UNIFIED IDEOGRAPH
    {0xC2E5, 0x91AB}, //5251 #CJK UNIFIED IDEOGRAPH
    {0xC2E6, 0x91AC}, //5252 #CJK UNIFIED IDEOGRAPH
    {0xC2E7, 0x91D0}, //5253 #CJK UNIFIED IDEOGRAPH
    {0xC2E8, 0x9394}, //5254 #CJK UNIFIED IDEOGRAPH
    {0xC2E9, 0x938A}, //5255 #CJK UNIFIED IDEOGRAPH
    {0xC2EA, 0x9396}, //5256 #CJK UNIFIED IDEOGRAPH
    {0xC2EB, 0x93A2}, //5257 #CJK UNIFIED IDEOGRAPH
    {0xC2EC, 0x93B3}, //5258 #CJK UNIFIED IDEOGRAPH
    {0xC2ED, 0x93AE}, //5259 #CJK UNIFIED IDEOGRAPH
    {0xC2EE, 0x93AC}, //5260 #CJK UNIFIED IDEOGRAPH
    {0xC2EF, 0x93B0}, //5261 #CJK UNIFIED IDEOGRAPH
    {0xC2F0, 0x9398}, //5262 #CJK UNIFIED IDEOGRAPH
    {0xC2F1, 0x939A}, //5263 #CJK UNIFIED IDEOGRAPH
    {0xC2F2, 0x9397}, //5264 #CJK UNIFIED IDEOGRAPH
    {0xC2F3, 0x95D4}, //5265 #CJK UNIFIED IDEOGRAPH
    {0xC2F4, 0x95D6}, //5266 #CJK UNIFIED IDEOGRAPH
    {0xC2F5, 0x95D0}, //5267 #CJK UNIFIED IDEOGRAPH
    {0xC2F6, 0x95D5}, //5268 #CJK UNIFIED IDEOGRAPH
    {0xC2F7, 0x96E2}, //5269 #CJK UNIFIED IDEOGRAPH
    {0xC2F8, 0x96DC}, //5270 #CJK UNIFIED IDEOGRAPH
    {0xC2F9, 0x96D9}, //5271 #CJK UNIFIED IDEOGRAPH
    {0xC2FA, 0x96DB}, //5272 #CJK UNIFIED IDEOGRAPH
    {0xC2FB, 0x96DE}, //5273 #CJK UNIFIED IDEOGRAPH
    {0xC2FC, 0x9724}, //5274 #CJK UNIFIED IDEOGRAPH
    {0xC2FD, 0x97A3}, //5275 #CJK UNIFIED IDEOGRAPH
    {0xC2FE, 0x97A6}, //5276 #CJK UNIFIED IDEOGRAPH
    {0xC340, 0x97AD}, //5277 #CJK UNIFIED IDEOGRAPH
    {0xC341, 0x97F9}, //5278 #CJK UNIFIED IDEOGRAPH
    {0xC342, 0x984D}, //5279 #CJK UNIFIED IDEOGRAPH
    {0xC343, 0x984F}, //5280 #CJK UNIFIED IDEOGRAPH
    {0xC344, 0x984C}, //5281 #CJK UNIFIED IDEOGRAPH
    {0xC345, 0x984E}, //5282 #CJK UNIFIED IDEOGRAPH
    {0xC346, 0x9853}, //5283 #CJK UNIFIED IDEOGRAPH
    {0xC347, 0x98BA}, //5284 #CJK UNIFIED IDEOGRAPH
    {0xC348, 0x993E}, //5285 #CJK UNIFIED IDEOGRAPH
    {0xC349, 0x993F}, //5286 #CJK UNIFIED IDEOGRAPH
    {0xC34A, 0x993D}, //5287 #CJK UNIFIED IDEOGRAPH
    {0xC34B, 0x992E}, //5288 #CJK UNIFIED IDEOGRAPH
    {0xC34C, 0x99A5}, //5289 #CJK UNIFIED IDEOGRAPH
    {0xC34D, 0x9A0E}, //5290 #CJK UNIFIED IDEOGRAPH
    {0xC34E, 0x9AC1}, //5291 #CJK UNIFIED IDEOGRAPH
    {0xC34F, 0x9B03}, //5292 #CJK UNIFIED IDEOGRAPH
    {0xC350, 0x9B06}, //5293 #CJK UNIFIED IDEOGRAPH
    {0xC351, 0x9B4F}, //5294 #CJK UNIFIED IDEOGRAPH
    {0xC352, 0x9B4E}, //5295 #CJK UNIFIED IDEOGRAPH
    {0xC353, 0x9B4D}, //5296 #CJK UNIFIED IDEOGRAPH
    {0xC354, 0x9BCA}, //5297 #CJK UNIFIED IDEOGRAPH
    {0xC355, 0x9BC9}, //5298 #CJK UNIFIED IDEOGRAPH
    {0xC356, 0x9BFD}, //5299 #CJK UNIFIED IDEOGRAPH
    {0xC357, 0x9BC8}, //5300 #CJK UNIFIED IDEOGRAPH
    {0xC358, 0x9BC0}, //5301 #CJK UNIFIED IDEOGRAPH
    {0xC359, 0x9D51}, //5302 #CJK UNIFIED IDEOGRAPH
    {0xC35A, 0x9D5D}, //5303 #CJK UNIFIED IDEOGRAPH
    {0xC35B, 0x9D60}, //5304 #CJK UNIFIED IDEOGRAPH
    {0xC35C, 0x9EE0}, //5305 #CJK UNIFIED IDEOGRAPH
    {0xC35D, 0x9F15}, //5306 #CJK UNIFIED IDEOGRAPH
    {0xC35E, 0x9F2C}, //5307 #CJK UNIFIED IDEOGRAPH
    {0xC35F, 0x5133}, //5308 #CJK UNIFIED IDEOGRAPH
    {0xC360, 0x56A5}, //5309 #CJK UNIFIED IDEOGRAPH
    {0xC361, 0x58DE}, //5310 #CJK UNIFIED IDEOGRAPH
    {0xC362, 0x58DF}, //5311 #CJK UNIFIED IDEOGRAPH
    {0xC363, 0x58E2}, //5312 #CJK UNIFIED IDEOGRAPH
    {0xC364, 0x5BF5}, //5313 #CJK UNIFIED IDEOGRAPH
    {0xC365, 0x9F90}, //5314 #CJK UNIFIED IDEOGRAPH
    {0xC366, 0x5EEC}, //5315 #CJK UNIFIED IDEOGRAPH
    {0xC367, 0x61F2}, //5316 #CJK UNIFIED IDEOGRAPH
    {0xC368, 0x61F7}, //5317 #CJK UNIFIED IDEOGRAPH
    {0xC369, 0x61F6}, //5318 #CJK UNIFIED IDEOGRAPH
    {0xC36A, 0x61F5}, //5319 #CJK UNIFIED IDEOGRAPH
    {0xC36B, 0x6500}, //5320 #CJK UNIFIED IDEOGRAPH
    {0xC36C, 0x650F}, //5321 #CJK UNIFIED IDEOGRAPH
    {0xC36D, 0x66E0}, //5322 #CJK UNIFIED IDEOGRAPH
    {0xC36E, 0x66DD}, //5323 #CJK UNIFIED IDEOGRAPH
    {0xC36F, 0x6AE5}, //5324 #CJK UNIFIED IDEOGRAPH
    {0xC370, 0x6ADD}, //5325 #CJK UNIFIED IDEOGRAPH
    {0xC371, 0x6ADA}, //5326 #CJK UNIFIED IDEOGRAPH
    {0xC372, 0x6AD3}, //5327 #CJK UNIFIED IDEOGRAPH
    {0xC373, 0x701B}, //5328 #CJK UNIFIED IDEOGRAPH
    {0xC374, 0x701F}, //5329 #CJK UNIFIED IDEOGRAPH
    {0xC375, 0x7028}, //5330 #CJK UNIFIED IDEOGRAPH
    {0xC376, 0x701A}, //5331 #CJK UNIFIED IDEOGRAPH
    {0xC377, 0x701D}, //5332 #CJK UNIFIED IDEOGRAPH
    {0xC378, 0x7015}, //5333 #CJK UNIFIED IDEOGRAPH
    {0xC379, 0x7018}, //5334 #CJK UNIFIED IDEOGRAPH
    {0xC37A, 0x7206}, //5335 #CJK UNIFIED IDEOGRAPH
    {0xC37B, 0x720D}, //5336 #CJK UNIFIED IDEOGRAPH
    {0xC37C, 0x7258}, //5337 #CJK UNIFIED IDEOGRAPH
    {0xC37D, 0x72A2}, //5338 #CJK UNIFIED IDEOGRAPH
    {0xC37E, 0x7378}, //5339 #CJK UNIFIED IDEOGRAPH
    {0xC3A1, 0x737A}, //5340 #CJK UNIFIED IDEOGRAPH
    {0xC3A2, 0x74BD}, //5341 #CJK UNIFIED IDEOGRAPH
    {0xC3A3, 0x74CA}, //5342 #CJK UNIFIED IDEOGRAPH
    {0xC3A4, 0x74E3}, //5343 #CJK UNIFIED IDEOGRAPH
    {0xC3A5, 0x7587}, //5344 #CJK UNIFIED IDEOGRAPH
    {0xC3A6, 0x7586}, //5345 #CJK UNIFIED IDEOGRAPH
    {0xC3A7, 0x765F}, //5346 #CJK UNIFIED IDEOGRAPH
    {0xC3A8, 0x7661}, //5347 #CJK UNIFIED IDEOGRAPH
    {0xC3A9, 0x77C7}, //5348 #CJK UNIFIED IDEOGRAPH
    {0xC3AA, 0x7919}, //5349 #CJK UNIFIED IDEOGRAPH
    {0xC3AB, 0x79B1}, //5350 #CJK UNIFIED IDEOGRAPH
    {0xC3AC, 0x7A6B}, //5351 #CJK UNIFIED IDEOGRAPH
    {0xC3AD, 0x7A69}, //5352 #CJK UNIFIED IDEOGRAPH
    {0xC3AE, 0x7C3E}, //5353 #CJK UNIFIED IDEOGRAPH
    {0xC3AF, 0x7C3F}, //5354 #CJK UNIFIED IDEOGRAPH
    {0xC3B0, 0x7C38}, //5355 #CJK UNIFIED IDEOGRAPH
    {0xC3B1, 0x7C3D}, //5356 #CJK UNIFIED IDEOGRAPH
    {0xC3B2, 0x7C37}, //5357 #CJK UNIFIED IDEOGRAPH
    {0xC3B3, 0x7C40}, //5358 #CJK UNIFIED IDEOGRAPH
    {0xC3B4, 0x7E6B}, //5359 #CJK UNIFIED IDEOGRAPH
    {0xC3B5, 0x7E6D}, //5360 #CJK UNIFIED IDEOGRAPH
    {0xC3B6, 0x7E79}, //5361 #CJK UNIFIED IDEOGRAPH
    {0xC3B7, 0x7E69}, //5362 #CJK UNIFIED IDEOGRAPH
    {0xC3B8, 0x7E6A}, //5363 #CJK UNIFIED IDEOGRAPH
    {0xC3B9, 0x7F85}, //5364 #CJK UNIFIED IDEOGRAPH
    {0xC3BA, 0x7E73}, //5365 #CJK UNIFIED IDEOGRAPH
    {0xC3BB, 0x7FB6}, //5366 #CJK UNIFIED IDEOGRAPH
    {0xC3BC, 0x7FB9}, //5367 #CJK UNIFIED IDEOGRAPH
    {0xC3BD, 0x7FB8}, //5368 #CJK UNIFIED IDEOGRAPH
    {0xC3BE, 0x81D8}, //5369 #CJK UNIFIED IDEOGRAPH
    {0xC3BF, 0x85E9}, //5370 #CJK UNIFIED IDEOGRAPH
    {0xC3C0, 0x85DD}, //5371 #CJK UNIFIED IDEOGRAPH
    {0xC3C1, 0x85EA}, //5372 #CJK UNIFIED IDEOGRAPH
    {0xC3C2, 0x85D5}, //5373 #CJK UNIFIED IDEOGRAPH
    {0xC3C3, 0x85E4}, //5374 #CJK UNIFIED IDEOGRAPH
    {0xC3C4, 0x85E5}, //5375 #CJK UNIFIED IDEOGRAPH
    {0xC3C5, 0x85F7}, //5376 #CJK UNIFIED IDEOGRAPH
    {0xC3C6, 0x87FB}, //5377 #CJK UNIFIED IDEOGRAPH
    {0xC3C7, 0x8805}, //5378 #CJK UNIFIED IDEOGRAPH
    {0xC3C8, 0x880D}, //5379 #CJK UNIFIED IDEOGRAPH
    {0xC3C9, 0x87F9}, //5380 #CJK UNIFIED IDEOGRAPH
    {0xC3CA, 0x87FE}, //5381 #CJK UNIFIED IDEOGRAPH
    {0xC3CB, 0x8960}, //5382 #CJK UNIFIED IDEOGRAPH
    {0xC3CC, 0x895F}, //5383 #CJK UNIFIED IDEOGRAPH
    {0xC3CD, 0x8956}, //5384 #CJK UNIFIED IDEOGRAPH
    {0xC3CE, 0x895E}, //5385 #CJK UNIFIED IDEOGRAPH
    {0xC3CF, 0x8B41}, //5386 #CJK UNIFIED IDEOGRAPH
    {0xC3D0, 0x8B5C}, //5387 #CJK UNIFIED IDEOGRAPH
    {0xC3D1, 0x8B58}, //5388 #CJK UNIFIED IDEOGRAPH
    {0xC3D2, 0x8B49}, //5389 #CJK UNIFIED IDEOGRAPH
    {0xC3D3, 0x8B5A}, //5390 #CJK UNIFIED IDEOGRAPH
    {0xC3D4, 0x8B4E}, //5391 #CJK UNIFIED IDEOGRAPH
    {0xC3D5, 0x8B4F}, //5392 #CJK UNIFIED IDEOGRAPH
    {0xC3D6, 0x8B46}, //5393 #CJK UNIFIED IDEOGRAPH
    {0xC3D7, 0x8B59}, //5394 #CJK UNIFIED IDEOGRAPH
    {0xC3D8, 0x8D08}, //5395 #CJK UNIFIED IDEOGRAPH
    {0xC3D9, 0x8D0A}, //5396 #CJK UNIFIED IDEOGRAPH
    {0xC3DA, 0x8E7C}, //5397 #CJK UNIFIED IDEOGRAPH
    {0xC3DB, 0x8E72}, //5398 #CJK UNIFIED IDEOGRAPH
    {0xC3DC, 0x8E87}, //5399 #CJK UNIFIED IDEOGRAPH
    {0xC3DD, 0x8E76}, //5400 #CJK UNIFIED IDEOGRAPH
    {0xC3DE, 0x8E6C}, //5401 #CJK UNIFIED IDEOGRAPH
    {0xC3DF, 0x8E7A}, //5402 #CJK UNIFIED IDEOGRAPH
    {0xC3E0, 0x8E74}, //5403 #CJK UNIFIED IDEOGRAPH
    {0xC3E1, 0x8F54}, //5404 #CJK UNIFIED IDEOGRAPH
    {0xC3E2, 0x8F4E}, //5405 #CJK UNIFIED IDEOGRAPH
    {0xC3E3, 0x8FAD}, //5406 #CJK UNIFIED IDEOGRAPH
    {0xC3E4, 0x908A}, //5407 #CJK UNIFIED IDEOGRAPH
    {0xC3E5, 0x908B}, //5408 #CJK UNIFIED IDEOGRAPH
    {0xC3E6, 0x91B1}, //5409 #CJK UNIFIED IDEOGRAPH
    {0xC3E7, 0x91AE}, //5410 #CJK UNIFIED IDEOGRAPH
    {0xC3E8, 0x93E1}, //5411 #CJK UNIFIED IDEOGRAPH
    {0xC3E9, 0x93D1}, //5412 #CJK UNIFIED IDEOGRAPH
    {0xC3EA, 0x93DF}, //5413 #CJK UNIFIED IDEOGRAPH
    {0xC3EB, 0x93C3}, //5414 #CJK UNIFIED IDEOGRAPH
    {0xC3EC, 0x93C8}, //5415 #CJK UNIFIED IDEOGRAPH
    {0xC3ED, 0x93DC}, //5416 #CJK UNIFIED IDEOGRAPH
    {0xC3EE, 0x93DD}, //5417 #CJK UNIFIED IDEOGRAPH
    {0xC3EF, 0x93D6}, //5418 #CJK UNIFIED IDEOGRAPH
    {0xC3F0, 0x93E2}, //5419 #CJK UNIFIED IDEOGRAPH
    {0xC3F1, 0x93CD}, //5420 #CJK UNIFIED IDEOGRAPH
    {0xC3F2, 0x93D8}, //5421 #CJK UNIFIED IDEOGRAPH
    {0xC3F3, 0x93E4}, //5422 #CJK UNIFIED IDEOGRAPH
    {0xC3F4, 0x93D7}, //5423 #CJK UNIFIED IDEOGRAPH
    {0xC3F5, 0x93E8}, //5424 #CJK UNIFIED IDEOGRAPH
    {0xC3F6, 0x95DC}, //5425 #CJK UNIFIED IDEOGRAPH
    {0xC3F7, 0x96B4}, //5426 #CJK UNIFIED IDEOGRAPH
    {0xC3F8, 0x96E3}, //5427 #CJK UNIFIED IDEOGRAPH
    {0xC3F9, 0x972A}, //5428 #CJK UNIFIED IDEOGRAPH
    {0xC3FA, 0x9727}, //5429 #CJK UNIFIED IDEOGRAPH
    {0xC3FB, 0x9761}, //5430 #CJK UNIFIED IDEOGRAPH
    {0xC3FC, 0x97DC}, //5431 #CJK UNIFIED IDEOGRAPH
    {0xC3FD, 0x97FB}, //5432 #CJK UNIFIED IDEOGRAPH
    {0xC3FE, 0x985E}, //5433 #CJK UNIFIED IDEOGRAPH
    {0xC440, 0x9858}, //5434 #CJK UNIFIED IDEOGRAPH
    {0xC441, 0x985B}, //5435 #CJK UNIFIED IDEOGRAPH
    {0xC442, 0x98BC}, //5436 #CJK UNIFIED IDEOGRAPH
    {0xC443, 0x9945}, //5437 #CJK UNIFIED IDEOGRAPH
    {0xC444, 0x9949}, //5438 #CJK UNIFIED IDEOGRAPH
    {0xC445, 0x9A16}, //5439 #CJK UNIFIED IDEOGRAPH
    {0xC446, 0x9A19}, //5440 #CJK UNIFIED IDEOGRAPH
    {0xC447, 0x9B0D}, //5441 #CJK UNIFIED IDEOGRAPH
    {0xC448, 0x9BE8}, //5442 #CJK UNIFIED IDEOGRAPH
    {0xC449, 0x9BE7}, //5443 #CJK UNIFIED IDEOGRAPH
    {0xC44A, 0x9BD6}, //5444 #CJK UNIFIED IDEOGRAPH
    {0xC44B, 0x9BDB}, //5445 #CJK UNIFIED IDEOGRAPH
    {0xC44C, 0x9D89}, //5446 #CJK UNIFIED IDEOGRAPH
    {0xC44D, 0x9D61}, //5447 #CJK UNIFIED IDEOGRAPH
    {0xC44E, 0x9D72}, //5448 #CJK UNIFIED IDEOGRAPH
    {0xC44F, 0x9D6A}, //5449 #CJK UNIFIED IDEOGRAPH
    {0xC450, 0x9D6C}, //5450 #CJK UNIFIED IDEOGRAPH
    {0xC451, 0x9E92}, //5451 #CJK UNIFIED IDEOGRAPH
    {0xC452, 0x9E97}, //5452 #CJK UNIFIED IDEOGRAPH
    {0xC453, 0x9E93}, //5453 #CJK UNIFIED IDEOGRAPH
    {0xC454, 0x9EB4}, //5454 #CJK UNIFIED IDEOGRAPH
    {0xC455, 0x52F8}, //5455 #CJK UNIFIED IDEOGRAPH
    {0xC456, 0x56A8}, //5456 #CJK UNIFIED IDEOGRAPH
    {0xC457, 0x56B7}, //5457 #CJK UNIFIED IDEOGRAPH
    {0xC458, 0x56B6}, //5458 #CJK UNIFIED IDEOGRAPH
    {0xC459, 0x56B4}, //5459 #CJK UNIFIED IDEOGRAPH
    {0xC45A, 0x56BC}, //5460 #CJK UNIFIED IDEOGRAPH
    {0xC45B, 0x58E4}, //5461 #CJK UNIFIED IDEOGRAPH
    {0xC45C, 0x5B40}, //5462 #CJK UNIFIED IDEOGRAPH
    {0xC45D, 0x5B43}, //5463 #CJK UNIFIED IDEOGRAPH
    {0xC45E, 0x5B7D}, //5464 #CJK UNIFIED IDEOGRAPH
    {0xC45F, 0x5BF6}, //5465 #CJK UNIFIED IDEOGRAPH
    {0xC460, 0x5DC9}, //5466 #CJK UNIFIED IDEOGRAPH
    {0xC461, 0x61F8}, //5467 #CJK UNIFIED IDEOGRAPH
    {0xC462, 0x61FA}, //5468 #CJK UNIFIED IDEOGRAPH
    {0xC463, 0x6518}, //5469 #CJK UNIFIED IDEOGRAPH
    {0xC464, 0x6514}, //5470 #CJK UNIFIED IDEOGRAPH
    {0xC465, 0x6519}, //5471 #CJK UNIFIED IDEOGRAPH
    {0xC466, 0x66E6}, //5472 #CJK UNIFIED IDEOGRAPH
    {0xC467, 0x6727}, //5473 #CJK UNIFIED IDEOGRAPH
    {0xC468, 0x6AEC}, //5474 #CJK UNIFIED IDEOGRAPH
    {0xC469, 0x703E}, //5475 #CJK UNIFIED IDEOGRAPH
    {0xC46A, 0x7030}, //5476 #CJK UNIFIED IDEOGRAPH
    {0xC46B, 0x7032}, //5477 #CJK UNIFIED IDEOGRAPH
    {0xC46C, 0x7210}, //5478 #CJK UNIFIED IDEOGRAPH
    {0xC46D, 0x737B}, //5479 #CJK UNIFIED IDEOGRAPH
    {0xC46E, 0x74CF}, //5480 #CJK UNIFIED IDEOGRAPH
    {0xC46F, 0x7662}, //5481 #CJK UNIFIED IDEOGRAPH
    {0xC470, 0x7665}, //5482 #CJK UNIFIED IDEOGRAPH
    {0xC471, 0x7926}, //5483 #CJK UNIFIED IDEOGRAPH
    {0xC472, 0x792A}, //5484 #CJK UNIFIED IDEOGRAPH
    {0xC473, 0x792C}, //5485 #CJK UNIFIED IDEOGRAPH
    {0xC474, 0x792B}, //5486 #CJK UNIFIED IDEOGRAPH
    {0xC475, 0x7AC7}, //5487 #CJK UNIFIED IDEOGRAPH
    {0xC476, 0x7AF6}, //5488 #CJK UNIFIED IDEOGRAPH
    {0xC477, 0x7C4C}, //5489 #CJK UNIFIED IDEOGRAPH
    {0xC478, 0x7C43}, //5490 #CJK UNIFIED IDEOGRAPH
    {0xC479, 0x7C4D}, //5491 #CJK UNIFIED IDEOGRAPH
    {0xC47A, 0x7CEF}, //5492 #CJK UNIFIED IDEOGRAPH
    {0xC47B, 0x7CF0}, //5493 #CJK UNIFIED IDEOGRAPH
    {0xC47C, 0x8FAE}, //5494 #CJK UNIFIED IDEOGRAPH
    {0xC47D, 0x7E7D}, //5495 #CJK UNIFIED IDEOGRAPH
    {0xC47E, 0x7E7C}, //5496 #CJK UNIFIED IDEOGRAPH
    {0xC4A1, 0x7E82}, //5497 #CJK UNIFIED IDEOGRAPH
    {0xC4A2, 0x7F4C}, //5498 #CJK UNIFIED IDEOGRAPH
    {0xC4A3, 0x8000}, //5499 #CJK UNIFIED IDEOGRAPH
    {0xC4A4, 0x81DA}, //5500 #CJK UNIFIED IDEOGRAPH
    {0xC4A5, 0x8266}, //5501 #CJK UNIFIED IDEOGRAPH
    {0xC4A6, 0x85FB}, //5502 #CJK UNIFIED IDEOGRAPH
    {0xC4A7, 0x85F9}, //5503 #CJK UNIFIED IDEOGRAPH
    {0xC4A8, 0x8611}, //5504 #CJK UNIFIED IDEOGRAPH
    {0xC4A9, 0x85FA}, //5505 #CJK UNIFIED IDEOGRAPH
    {0xC4AA, 0x8606}, //5506 #CJK UNIFIED IDEOGRAPH
    {0xC4AB, 0x860B}, //5507 #CJK UNIFIED IDEOGRAPH
    {0xC4AC, 0x8607}, //5508 #CJK UNIFIED IDEOGRAPH
    {0xC4AD, 0x860A}, //5509 #CJK UNIFIED IDEOGRAPH
    {0xC4AE, 0x8814}, //5510 #CJK UNIFIED IDEOGRAPH
    {0xC4AF, 0x8815}, //5511 #CJK UNIFIED IDEOGRAPH
    {0xC4B0, 0x8964}, //5512 #CJK UNIFIED IDEOGRAPH
    {0xC4B1, 0x89BA}, //5513 #CJK UNIFIED IDEOGRAPH
    {0xC4B2, 0x89F8}, //5514 #CJK UNIFIED IDEOGRAPH
    {0xC4B3, 0x8B70}, //5515 #CJK UNIFIED IDEOGRAPH
    {0xC4B4, 0x8B6C}, //5516 #CJK UNIFIED IDEOGRAPH
    {0xC4B5, 0x8B66}, //5517 #CJK UNIFIED IDEOGRAPH
    {0xC4B6, 0x8B6F}, //5518 #CJK UNIFIED IDEOGRAPH
    {0xC4B7, 0x8B5F}, //5519 #CJK UNIFIED IDEOGRAPH
    {0xC4B8, 0x8B6B}, //5520 #CJK UNIFIED IDEOGRAPH
    {0xC4B9, 0x8D0F}, //5521 #CJK UNIFIED IDEOGRAPH
    {0xC4BA, 0x8D0D}, //5522 #CJK UNIFIED IDEOGRAPH
    {0xC4BB, 0x8E89}, //5523 #CJK UNIFIED IDEOGRAPH
    {0xC4BC, 0x8E81}, //5524 #CJK UNIFIED IDEOGRAPH
    {0xC4BD, 0x8E85}, //5525 #CJK UNIFIED IDEOGRAPH
    {0xC4BE, 0x8E82}, //5526 #CJK UNIFIED IDEOGRAPH
    {0xC4BF, 0x91B4}, //5527 #CJK UNIFIED IDEOGRAPH
    {0xC4C0, 0x91CB}, //5528 #CJK UNIFIED IDEOGRAPH
    {0xC4C1, 0x9418}, //5529 #CJK UNIFIED IDEOGRAPH
    {0xC4C2, 0x9403}, //5530 #CJK UNIFIED IDEOGRAPH
    {0xC4C3, 0x93FD}, //5531 #CJK UNIFIED IDEOGRAPH
    {0xC4C4, 0x95E1}, //5532 #CJK UNIFIED IDEOGRAPH
    {0xC4C5, 0x9730}, //5533 #CJK UNIFIED IDEOGRAPH
    {0xC4C6, 0x98C4}, //5534 #CJK UNIFIED IDEOGRAPH
    {0xC4C7, 0x9952}, //5535 #CJK UNIFIED IDEOGRAPH
    {0xC4C8, 0x9951}, //5536 #CJK UNIFIED IDEOGRAPH
    {0xC4C9, 0x99A8}, //5537 #CJK UNIFIED IDEOGRAPH
    {0xC4CA, 0x9A2B}, //5538 #CJK UNIFIED IDEOGRAPH
    {0xC4CB, 0x9A30}, //5539 #CJK UNIFIED IDEOGRAPH
    {0xC4CC, 0x9A37}, //5540 #CJK UNIFIED IDEOGRAPH
    {0xC4CD, 0x9A35}, //5541 #CJK UNIFIED IDEOGRAPH
    {0xC4CE, 0x9C13}, //5542 #CJK UNIFIED IDEOGRAPH
    {0xC4CF, 0x9C0D}, //5543 #CJK UNIFIED IDEOGRAPH
    {0xC4D0, 0x9E79}, //5544 #CJK UNIFIED IDEOGRAPH
    {0xC4D1, 0x9EB5}, //5545 #CJK UNIFIED IDEOGRAPH
    {0xC4D2, 0x9EE8}, //5546 #CJK UNIFIED IDEOGRAPH
    {0xC4D3, 0x9F2F}, //5547 #CJK UNIFIED IDEOGRAPH
    {0xC4D4, 0x9F5F}, //5548 #CJK UNIFIED IDEOGRAPH
    {0xC4D5, 0x9F63}, //5549 #CJK UNIFIED IDEOGRAPH
    {0xC4D6, 0x9F61}, //5550 #CJK UNIFIED IDEOGRAPH
    {0xC4D7, 0x5137}, //5551 #CJK UNIFIED IDEOGRAPH
    {0xC4D8, 0x5138}, //5552 #CJK UNIFIED IDEOGRAPH
    {0xC4D9, 0x56C1}, //5553 #CJK UNIFIED IDEOGRAPH
    {0xC4DA, 0x56C0}, //5554 #CJK UNIFIED IDEOGRAPH
    {0xC4DB, 0x56C2}, //5555 #CJK UNIFIED IDEOGRAPH
    {0xC4DC, 0x5914}, //5556 #CJK UNIFIED IDEOGRAPH
    {0xC4DD, 0x5C6C}, //5557 #CJK UNIFIED IDEOGRAPH
    {0xC4DE, 0x5DCD}, //5558 #CJK UNIFIED IDEOGRAPH
    {0xC4DF, 0x61FC}, //5559 #CJK UNIFIED IDEOGRAPH
    {0xC4E0, 0x61FE}, //5560 #CJK UNIFIED IDEOGRAPH
    {0xC4E1, 0x651D}, //5561 #CJK UNIFIED IDEOGRAPH
    {0xC4E2, 0x651C}, //5562 #CJK UNIFIED IDEOGRAPH
    {0xC4E3, 0x6595}, //5563 #CJK UNIFIED IDEOGRAPH
    {0xC4E4, 0x66E9}, //5564 #CJK UNIFIED IDEOGRAPH
    {0xC4E5, 0x6AFB}, //5565 #CJK UNIFIED IDEOGRAPH
    {0xC4E6, 0x6B04}, //5566 #CJK UNIFIED IDEOGRAPH
    {0xC4E7, 0x6AFA}, //5567 #CJK UNIFIED IDEOGRAPH
    {0xC4E8, 0x6BB2}, //5568 #CJK UNIFIED IDEOGRAPH
    {0xC4E9, 0x704C}, //5569 #CJK UNIFIED IDEOGRAPH
    {0xC4EA, 0x721B}, //5570 #CJK UNIFIED IDEOGRAPH
    {0xC4EB, 0x72A7}, //5571 #CJK UNIFIED IDEOGRAPH
    {0xC4EC, 0x74D6}, //5572 #CJK UNIFIED IDEOGRAPH
    {0xC4ED, 0x74D4}, //5573 #CJK UNIFIED IDEOGRAPH
    {0xC4EE, 0x7669}, //5574 #CJK UNIFIED IDEOGRAPH
    {0xC4EF, 0x77D3}, //5575 #CJK UNIFIED IDEOGRAPH
    {0xC4F0, 0x7C50}, //5576 #CJK UNIFIED IDEOGRAPH
    {0xC4F1, 0x7E8F}, //5577 #CJK UNIFIED IDEOGRAPH
    {0xC4F2, 0x7E8C}, //5578 #CJK UNIFIED IDEOGRAPH
    {0xC4F3, 0x7FBC}, //5579 #CJK UNIFIED IDEOGRAPH
    {0xC4F4, 0x8617}, //5580 #CJK UNIFIED IDEOGRAPH
    {0xC4F5, 0x862D}, //5581 #CJK UNIFIED IDEOGRAPH
    {0xC4F6, 0x861A}, //5582 #CJK UNIFIED IDEOGRAPH
    {0xC4F7, 0x8823}, //5583 #CJK UNIFIED IDEOGRAPH
    {0xC4F8, 0x8822}, //5584 #CJK UNIFIED IDEOGRAPH
    {0xC4F9, 0x8821}, //5585 #CJK UNIFIED IDEOGRAPH
    {0xC4FA, 0x881F}, //5586 #CJK UNIFIED IDEOGRAPH
    {0xC4FB, 0x896A}, //5587 #CJK UNIFIED IDEOGRAPH
    {0xC4FC, 0x896C}, //5588 #CJK UNIFIED IDEOGRAPH
    {0xC4FD, 0x89BD}, //5589 #CJK UNIFIED IDEOGRAPH
    {0xC4FE, 0x8B74}, //5590 #CJK UNIFIED IDEOGRAPH
    {0xC540, 0x8B77}, //5591 #CJK UNIFIED IDEOGRAPH
    {0xC541, 0x8B7D}, //5592 #CJK UNIFIED IDEOGRAPH
    {0xC542, 0x8D13}, //5593 #CJK UNIFIED IDEOGRAPH
    {0xC543, 0x8E8A}, //5594 #CJK UNIFIED IDEOGRAPH
    {0xC544, 0x8E8D}, //5595 #CJK UNIFIED IDEOGRAPH
    {0xC545, 0x8E8B}, //5596 #CJK UNIFIED IDEOGRAPH
    {0xC546, 0x8F5F}, //5597 #CJK UNIFIED IDEOGRAPH
    {0xC547, 0x8FAF}, //5598 #CJK UNIFIED IDEOGRAPH
    {0xC548, 0x91BA}, //5599 #CJK UNIFIED IDEOGRAPH
    {0xC549, 0x942E}, //5600 #CJK UNIFIED IDEOGRAPH
    {0xC54A, 0x9433}, //5601 #CJK UNIFIED IDEOGRAPH
    {0xC54B, 0x9435}, //5602 #CJK UNIFIED IDEOGRAPH
    {0xC54C, 0x943A}, //5603 #CJK UNIFIED IDEOGRAPH
    {0xC54D, 0x9438}, //5604 #CJK UNIFIED IDEOGRAPH
    {0xC54E, 0x9432}, //5605 #CJK UNIFIED IDEOGRAPH
    {0xC54F, 0x942B}, //5606 #CJK UNIFIED IDEOGRAPH
    {0xC550, 0x95E2}, //5607 #CJK UNIFIED IDEOGRAPH
    {0xC551, 0x9738}, //5608 #CJK UNIFIED IDEOGRAPH
    {0xC552, 0x9739}, //5609 #CJK UNIFIED IDEOGRAPH
    {0xC553, 0x9732}, //5610 #CJK UNIFIED IDEOGRAPH
    {0xC554, 0x97FF}, //5611 #CJK UNIFIED IDEOGRAPH
    {0xC555, 0x9867}, //5612 #CJK UNIFIED IDEOGRAPH
    {0xC556, 0x9865}, //5613 #CJK UNIFIED IDEOGRAPH
    {0xC557, 0x9957}, //5614 #CJK UNIFIED IDEOGRAPH
    {0xC558, 0x9A45}, //5615 #CJK UNIFIED IDEOGRAPH
    {0xC559, 0x9A43}, //5616 #CJK UNIFIED IDEOGRAPH
    {0xC55A, 0x9A40}, //5617 #CJK UNIFIED IDEOGRAPH
    {0xC55B, 0x9A3E}, //5618 #CJK UNIFIED IDEOGRAPH
    {0xC55C, 0x9ACF}, //5619 #CJK UNIFIED IDEOGRAPH
    {0xC55D, 0x9B54}, //5620 #CJK UNIFIED IDEOGRAPH
    {0xC55E, 0x9B51}, //5621 #CJK UNIFIED IDEOGRAPH
    {0xC55F, 0x9C2D}, //5622 #CJK UNIFIED IDEOGRAPH
    {0xC560, 0x9C25}, //5623 #CJK UNIFIED IDEOGRAPH
    {0xC561, 0x9DAF}, //5624 #CJK UNIFIED IDEOGRAPH
    {0xC562, 0x9DB4}, //5625 #CJK UNIFIED IDEOGRAPH
    {0xC563, 0x9DC2}, //5626 #CJK UNIFIED IDEOGRAPH
    {0xC564, 0x9DB8}, //5627 #CJK UNIFIED IDEOGRAPH
    {0xC565, 0x9E9D}, //5628 #CJK UNIFIED IDEOGRAPH
    {0xC566, 0x9EEF}, //5629 #CJK UNIFIED IDEOGRAPH
    {0xC567, 0x9F19}, //5630 #CJK UNIFIED IDEOGRAPH
    {0xC568, 0x9F5C}, //5631 #CJK UNIFIED IDEOGRAPH
    {0xC569, 0x9F66}, //5632 #CJK UNIFIED IDEOGRAPH
    {0xC56A, 0x9F67}, //5633 #CJK UNIFIED IDEOGRAPH
    {0xC56B, 0x513C}, //5634 #CJK UNIFIED IDEOGRAPH
    {0xC56C, 0x513B}, //5635 #CJK UNIFIED IDEOGRAPH
    {0xC56D, 0x56C8}, //5636 #CJK UNIFIED IDEOGRAPH
    {0xC56E, 0x56CA}, //5637 #CJK UNIFIED IDEOGRAPH
    {0xC56F, 0x56C9}, //5638 #CJK UNIFIED IDEOGRAPH
    {0xC570, 0x5B7F}, //5639 #CJK UNIFIED IDEOGRAPH
    {0xC571, 0x5DD4}, //5640 #CJK UNIFIED IDEOGRAPH
    {0xC572, 0x5DD2}, //5641 #CJK UNIFIED IDEOGRAPH
    {0xC573, 0x5F4E}, //5642 #CJK UNIFIED IDEOGRAPH
    {0xC574, 0x61FF}, //5643 #CJK UNIFIED IDEOGRAPH
    {0xC575, 0x6524}, //5644 #CJK UNIFIED IDEOGRAPH
    {0xC576, 0x6B0A}, //5645 #CJK UNIFIED IDEOGRAPH
    {0xC577, 0x6B61}, //5646 #CJK UNIFIED IDEOGRAPH
    {0xC578, 0x7051}, //5647 #CJK UNIFIED IDEOGRAPH
    {0xC579, 0x7058}, //5648 #CJK UNIFIED IDEOGRAPH
    {0xC57A, 0x7380}, //5649 #CJK UNIFIED IDEOGRAPH
    {0xC57B, 0x74E4}, //5650 #CJK UNIFIED IDEOGRAPH
    {0xC57C, 0x758A}, //5651 #CJK UNIFIED IDEOGRAPH
    {0xC57D, 0x766E}, //5652 #CJK UNIFIED IDEOGRAPH
    {0xC57E, 0x766C}, //5653 #CJK UNIFIED IDEOGRAPH
    {0xC5A1, 0x79B3}, //5654 #CJK UNIFIED IDEOGRAPH
    {0xC5A2, 0x7C60}, //5655 #CJK UNIFIED IDEOGRAPH
    {0xC5A3, 0x7C5F}, //5656 #CJK UNIFIED IDEOGRAPH
    {0xC5A4, 0x807E}, //5657 #CJK UNIFIED IDEOGRAPH
    {0xC5A5, 0x807D}, //5658 #CJK UNIFIED IDEOGRAPH
    {0xC5A6, 0x81DF}, //5659 #CJK UNIFIED IDEOGRAPH
    {0xC5A7, 0x8972}, //5660 #CJK UNIFIED IDEOGRAPH
    {0xC5A8, 0x896F}, //5661 #CJK UNIFIED IDEOGRAPH
    {0xC5A9, 0x89FC}, //5662 #CJK UNIFIED IDEOGRAPH
    {0xC5AA, 0x8B80}, //5663 #CJK UNIFIED IDEOGRAPH
    {0xC5AB, 0x8D16}, //5664 #CJK UNIFIED IDEOGRAPH
    {0xC5AC, 0x8D17}, //5665 #CJK UNIFIED IDEOGRAPH
    {0xC5AD, 0x8E91}, //5666 #CJK UNIFIED IDEOGRAPH
    {0xC5AE, 0x8E93}, //5667 #CJK UNIFIED IDEOGRAPH
    {0xC5AF, 0x8F61}, //5668 #CJK UNIFIED IDEOGRAPH
    {0xC5B0, 0x9148}, //5669 #CJK UNIFIED IDEOGRAPH
    {0xC5B1, 0x9444}, //5670 #CJK UNIFIED IDEOGRAPH
    {0xC5B2, 0x9451}, //5671 #CJK UNIFIED IDEOGRAPH
    {0xC5B3, 0x9452}, //5672 #CJK UNIFIED IDEOGRAPH
    {0xC5B4, 0x973D}, //5673 #CJK UNIFIED IDEOGRAPH
    {0xC5B5, 0x973E}, //5674 #CJK UNIFIED IDEOGRAPH
    {0xC5B6, 0x97C3}, //5675 #CJK UNIFIED IDEOGRAPH
    {0xC5B7, 0x97C1}, //5676 #CJK UNIFIED IDEOGRAPH
    {0xC5B8, 0x986B}, //5677 #CJK UNIFIED IDEOGRAPH
    {0xC5B9, 0x9955}, //5678 #CJK UNIFIED IDEOGRAPH
    {0xC5BA, 0x9A55}, //5679 #CJK UNIFIED IDEOGRAPH
    {0xC5BB, 0x9A4D}, //5680 #CJK UNIFIED IDEOGRAPH
    {0xC5BC, 0x9AD2}, //5681 #CJK UNIFIED IDEOGRAPH
    {0xC5BD, 0x9B1A}, //5682 #CJK UNIFIED IDEOGRAPH
    {0xC5BE, 0x9C49}, //5683 #CJK UNIFIED IDEOGRAPH
    {0xC5BF, 0x9C31}, //5684 #CJK UNIFIED IDEOGRAPH
    {0xC5C0, 0x9C3E}, //5685 #CJK UNIFIED IDEOGRAPH
    {0xC5C1, 0x9C3B}, //5686 #CJK UNIFIED IDEOGRAPH
    {0xC5C2, 0x9DD3}, //5687 #CJK UNIFIED IDEOGRAPH
    {0xC5C3, 0x9DD7}, //5688 #CJK UNIFIED IDEOGRAPH
    {0xC5C4, 0x9F34}, //5689 #CJK UNIFIED IDEOGRAPH
    {0xC5C5, 0x9F6C}, //5690 #CJK UNIFIED IDEOGRAPH
    {0xC5C6, 0x9F6A}, //5691 #CJK UNIFIED IDEOGRAPH
    {0xC5C7, 0x9F94}, //5692 #CJK UNIFIED IDEOGRAPH
    {0xC5C8, 0x56CC}, //5693 #CJK UNIFIED IDEOGRAPH
    {0xC5C9, 0x5DD6}, //5694 #CJK UNIFIED IDEOGRAPH
    {0xC5CA, 0x6200}, //5695 #CJK UNIFIED IDEOGRAPH
    {0xC5CB, 0x6523}, //5696 #CJK UNIFIED IDEOGRAPH
    {0xC5CC, 0x652B}, //5697 #CJK UNIFIED IDEOGRAPH
    {0xC5CD, 0x652A}, //5698 #CJK UNIFIED IDEOGRAPH
    {0xC5CE, 0x66EC}, //5699 #CJK UNIFIED IDEOGRAPH
    {0xC5CF, 0x6B10}, //5700 #CJK UNIFIED IDEOGRAPH
    {0xC5D0, 0x74DA}, //5701 #CJK UNIFIED IDEOGRAPH
    {0xC5D1, 0x7ACA}, //5702 #CJK UNIFIED IDEOGRAPH
    {0xC5D2, 0x7C64}, //5703 #CJK UNIFIED IDEOGRAPH
    {0xC5D3, 0x7C63}, //5704 #CJK UNIFIED IDEOGRAPH
    {0xC5D4, 0x7C65}, //5705 #CJK UNIFIED IDEOGRAPH
    {0xC5D5, 0x7E93}, //5706 #CJK UNIFIED IDEOGRAPH
    {0xC5D6, 0x7E96}, //5707 #CJK UNIFIED IDEOGRAPH
    {0xC5D7, 0x7E94}, //5708 #CJK UNIFIED IDEOGRAPH
    {0xC5D8, 0x81E2}, //5709 #CJK UNIFIED IDEOGRAPH
    {0xC5D9, 0x8638}, //5710 #CJK UNIFIED IDEOGRAPH
    {0xC5DA, 0x863F}, //5711 #CJK UNIFIED IDEOGRAPH
    {0xC5DB, 0x8831}, //5712 #CJK UNIFIED IDEOGRAPH
    {0xC5DC, 0x8B8A}, //5713 #CJK UNIFIED IDEOGRAPH
    {0xC5DD, 0x9090}, //5714 #CJK UNIFIED IDEOGRAPH
    {0xC5DE, 0x908F}, //5715 #CJK UNIFIED IDEOGRAPH
    {0xC5DF, 0x9463}, //5716 #CJK UNIFIED IDEOGRAPH
    {0xC5E0, 0x9460}, //5717 #CJK UNIFIED IDEOGRAPH
    {0xC5E1, 0x9464}, //5718 #CJK UNIFIED IDEOGRAPH
    {0xC5E2, 0x9768}, //5719 #CJK UNIFIED IDEOGRAPH
    {0xC5E3, 0x986F}, //5720 #CJK UNIFIED IDEOGRAPH
    {0xC5E4, 0x995C}, //5721 #CJK UNIFIED IDEOGRAPH
    {0xC5E5, 0x9A5A}, //5722 #CJK UNIFIED IDEOGRAPH
    {0xC5E6, 0x9A5B}, //5723 #CJK UNIFIED IDEOGRAPH
    {0xC5E7, 0x9A57}, //5724 #CJK UNIFIED IDEOGRAPH
    {0xC5E8, 0x9AD3}, //5725 #CJK UNIFIED IDEOGRAPH
    {0xC5E9, 0x9AD4}, //5726 #CJK UNIFIED IDEOGRAPH
    {0xC5EA, 0x9AD1}, //5727 #CJK UNIFIED IDEOGRAPH
    {0xC5EB, 0x9C54}, //5728 #CJK UNIFIED IDEOGRAPH
    {0xC5EC, 0x9C57}, //5729 #CJK UNIFIED IDEOGRAPH
    {0xC5ED, 0x9C56}, //5730 #CJK UNIFIED IDEOGRAPH
    {0xC5EE, 0x9DE5}, //5731 #CJK UNIFIED IDEOGRAPH
    {0xC5EF, 0x9E9F}, //5732 #CJK UNIFIED IDEOGRAPH
    {0xC5F0, 0x9EF4}, //5733 #CJK UNIFIED IDEOGRAPH
    {0xC5F1, 0x56D1}, //5734 #CJK UNIFIED IDEOGRAPH
    {0xC5F2, 0x58E9}, //5735 #CJK UNIFIED IDEOGRAPH
    {0xC5F3, 0x652C}, //5736 #CJK UNIFIED IDEOGRAPH
    {0xC5F4, 0x705E}, //5737 #CJK UNIFIED IDEOGRAPH
    {0xC5F5, 0x7671}, //5738 #CJK UNIFIED IDEOGRAPH
    {0xC5F6, 0x7672}, //5739 #CJK UNIFIED IDEOGRAPH
    {0xC5F7, 0x77D7}, //5740 #CJK UNIFIED IDEOGRAPH
    {0xC5F8, 0x7F50}, //5741 #CJK UNIFIED IDEOGRAPH
    {0xC5F9, 0x7F88}, //5742 #CJK UNIFIED IDEOGRAPH
    {0xC5FA, 0x8836}, //5743 #CJK UNIFIED IDEOGRAPH
    {0xC5FB, 0x8839}, //5744 #CJK UNIFIED IDEOGRAPH
    {0xC5FC, 0x8862}, //5745 #CJK UNIFIED IDEOGRAPH
    {0xC5FD, 0x8B93}, //5746 #CJK UNIFIED IDEOGRAPH
    {0xC5FE, 0x8B92}, //5747 #CJK UNIFIED IDEOGRAPH
    {0xC640, 0x8B96}, //5748 #CJK UNIFIED IDEOGRAPH
    {0xC641, 0x8277}, //5749 #CJK UNIFIED IDEOGRAPH
    {0xC642, 0x8D1B}, //5750 #CJK UNIFIED IDEOGRAPH
    {0xC643, 0x91C0}, //5751 #CJK UNIFIED IDEOGRAPH
    {0xC644, 0x946A}, //5752 #CJK UNIFIED IDEOGRAPH
    {0xC645, 0x9742}, //5753 #CJK UNIFIED IDEOGRAPH
    {0xC646, 0x9748}, //5754 #CJK UNIFIED IDEOGRAPH
    {0xC647, 0x9744}, //5755 #CJK UNIFIED IDEOGRAPH
    {0xC648, 0x97C6}, //5756 #CJK UNIFIED IDEOGRAPH
    {0xC649, 0x9870}, //5757 #CJK UNIFIED IDEOGRAPH
    {0xC64A, 0x9A5F}, //5758 #CJK UNIFIED IDEOGRAPH
    {0xC64B, 0x9B22}, //5759 #CJK UNIFIED IDEOGRAPH
    {0xC64C, 0x9B58}, //5760 #CJK UNIFIED IDEOGRAPH
    {0xC64D, 0x9C5F}, //5761 #CJK UNIFIED IDEOGRAPH
    {0xC64E, 0x9DF9}, //5762 #CJK UNIFIED IDEOGRAPH
    {0xC64F, 0x9DFA}, //5763 #CJK UNIFIED IDEOGRAPH
    {0xC650, 0x9E7C}, //5764 #CJK UNIFIED IDEOGRAPH
    {0xC651, 0x9E7D}, //5765 #CJK UNIFIED IDEOGRAPH
    {0xC652, 0x9F07}, //5766 #CJK UNIFIED IDEOGRAPH
    {0xC653, 0x9F77}, //5767 #CJK UNIFIED IDEOGRAPH
    {0xC654, 0x9F72}, //5768 #CJK UNIFIED IDEOGRAPH
    {0xC655, 0x5EF3}, //5769 #CJK UNIFIED IDEOGRAPH
    {0xC656, 0x6B16}, //5770 #CJK UNIFIED IDEOGRAPH
    {0xC657, 0x7063}, //5771 #CJK UNIFIED IDEOGRAPH
    {0xC658, 0x7C6C}, //5772 #CJK UNIFIED IDEOGRAPH
    {0xC659, 0x7C6E}, //5773 #CJK UNIFIED IDEOGRAPH
    {0xC65A, 0x883B}, //5774 #CJK UNIFIED IDEOGRAPH
    {0xC65B, 0x89C0}, //5775 #CJK UNIFIED IDEOGRAPH
    {0xC65C, 0x8EA1}, //5776 #CJK UNIFIED IDEOGRAPH
    {0xC65D, 0x91C1}, //5777 #CJK UNIFIED IDEOGRAPH
    {0xC65E, 0x9472}, //5778 #CJK UNIFIED IDEOGRAPH
    {0xC65F, 0x9470}, //5779 #CJK UNIFIED IDEOGRAPH
    {0xC660, 0x9871}, //5780 #CJK UNIFIED IDEOGRAPH
    {0xC661, 0x995E}, //5781 #CJK UNIFIED IDEOGRAPH
    {0xC662, 0x9AD6}, //5782 #CJK UNIFIED IDEOGRAPH
    {0xC663, 0x9B23}, //5783 #CJK UNIFIED IDEOGRAPH
    {0xC664, 0x9ECC}, //5784 #CJK UNIFIED IDEOGRAPH
    {0xC665, 0x7064}, //5785 #CJK UNIFIED IDEOGRAPH
    {0xC666, 0x77DA}, //5786 #CJK UNIFIED IDEOGRAPH
    {0xC667, 0x8B9A}, //5787 #CJK UNIFIED IDEOGRAPH
    {0xC668, 0x9477}, //5788 #CJK UNIFIED IDEOGRAPH
    {0xC669, 0x97C9}, //5789 #CJK UNIFIED IDEOGRAPH
    {0xC66A, 0x9A62}, //5790 #CJK UNIFIED IDEOGRAPH
    {0xC66B, 0x9A65}, //5791 #CJK UNIFIED IDEOGRAPH
    {0xC66C, 0x7E9C}, //5792 #CJK UNIFIED IDEOGRAPH
    {0xC66D, 0x8B9C}, //5793 #CJK UNIFIED IDEOGRAPH
    {0xC66E, 0x8EAA}, //5794 #CJK UNIFIED IDEOGRAPH
    {0xC66F, 0x91C5}, //5795 #CJK UNIFIED IDEOGRAPH
    {0xC670, 0x947D}, //5796 #CJK UNIFIED IDEOGRAPH
    {0xC671, 0x947E}, //5797 #CJK UNIFIED IDEOGRAPH
    {0xC672, 0x947C}, //5798 #CJK UNIFIED IDEOGRAPH
    {0xC673, 0x9C77}, //5799 #CJK UNIFIED IDEOGRAPH
    {0xC674, 0x9C78}, //5800 #CJK UNIFIED IDEOGRAPH
    {0xC675, 0x9EF7}, //5801 #CJK UNIFIED IDEOGRAPH
    {0xC676, 0x8C54}, //5802 #CJK UNIFIED IDEOGRAPH
    {0xC677, 0x947F}, //5803 #CJK UNIFIED IDEOGRAPH
    {0xC678, 0x9E1A}, //5804 #CJK UNIFIED IDEOGRAPH
    {0xC679, 0x7228}, //5805 #CJK UNIFIED IDEOGRAPH
    {0xC67A, 0x9A6A}, //5806 #CJK UNIFIED IDEOGRAPH
    {0xC67B, 0x9B31}, //5807 #CJK UNIFIED IDEOGRAPH
    {0xC67C, 0x9E1B}, //5808 #CJK UNIFIED IDEOGRAPH
    {0xC67D, 0x9E1E}, //5809 #CJK UNIFIED IDEOGRAPH
    {0xC67E, 0x7C72}, //5810 #CJK UNIFIED IDEOGRAPH
    {0xC940, 0x4E42}, //5811 #CJK UNIFIED IDEOGRAPH
    {0xC941, 0x4E5C}, //5812 #CJK UNIFIED IDEOGRAPH
    {0xC942, 0x51F5}, //5813 #CJK UNIFIED IDEOGRAPH
    {0xC943, 0x531A}, //5814 #CJK UNIFIED IDEOGRAPH
    {0xC944, 0x5382}, //5815 #CJK UNIFIED IDEOGRAPH
    {0xC945, 0x4E07}, //5816 #CJK UNIFIED IDEOGRAPH
    {0xC946, 0x4E0C}, //5817 #CJK UNIFIED IDEOGRAPH
    {0xC947, 0x4E47}, //5818 #CJK UNIFIED IDEOGRAPH
    {0xC948, 0x4E8D}, //5819 #CJK UNIFIED IDEOGRAPH
    {0xC949, 0x56D7}, //5820 #CJK UNIFIED IDEOGRAPH
    {0xC94A, 0xFA0C}, //5821 #CJK COMPATIBILITY IDEOGRAPH
    {0xC94B, 0x5C6E}, //5822 #CJK UNIFIED IDEOGRAPH
    {0xC94C, 0x5F73}, //5823 #CJK UNIFIED IDEOGRAPH
    {0xC94D, 0x4E0F}, //5824 #CJK UNIFIED IDEOGRAPH
    {0xC94E, 0x5187}, //5825 #CJK UNIFIED IDEOGRAPH
    {0xC94F, 0x4E0E}, //5826 #CJK UNIFIED IDEOGRAPH
    {0xC950, 0x4E2E}, //5827 #CJK UNIFIED IDEOGRAPH
    {0xC951, 0x4E93}, //5828 #CJK UNIFIED IDEOGRAPH
    {0xC952, 0x4EC2}, //5829 #CJK UNIFIED IDEOGRAPH
    {0xC953, 0x4EC9}, //5830 #CJK UNIFIED IDEOGRAPH
    {0xC954, 0x4EC8}, //5831 #CJK UNIFIED IDEOGRAPH
    {0xC955, 0x5198}, //5832 #CJK UNIFIED IDEOGRAPH
    {0xC956, 0x52FC}, //5833 #CJK UNIFIED IDEOGRAPH
    {0xC957, 0x536C}, //5834 #CJK UNIFIED IDEOGRAPH
    {0xC958, 0x53B9}, //5835 #CJK UNIFIED IDEOGRAPH
    {0xC959, 0x5720}, //5836 #CJK UNIFIED IDEOGRAPH
    {0xC95A, 0x5903}, //5837 #CJK UNIFIED IDEOGRAPH
    {0xC95B, 0x592C}, //5838 #CJK UNIFIED IDEOGRAPH
    {0xC95C, 0x5C10}, //5839 #CJK UNIFIED IDEOGRAPH
    {0xC95D, 0x5DFF}, //5840 #CJK UNIFIED IDEOGRAPH
    {0xC95E, 0x65E1}, //5841 #CJK UNIFIED IDEOGRAPH
    {0xC95F, 0x6BB3}, //5842 #CJK UNIFIED IDEOGRAPH
    {0xC960, 0x6BCC}, //5843 #CJK UNIFIED IDEOGRAPH
    {0xC961, 0x6C14}, //5844 #CJK UNIFIED IDEOGRAPH
    {0xC962, 0x723F}, //5845 #CJK UNIFIED IDEOGRAPH
    {0xC963, 0x4E31}, //5846 #CJK UNIFIED IDEOGRAPH
    {0xC964, 0x4E3C}, //5847 #CJK UNIFIED IDEOGRAPH
    {0xC965, 0x4EE8}, //5848 #CJK UNIFIED IDEOGRAPH
    {0xC966, 0x4EDC}, //5849 #CJK UNIFIED IDEOGRAPH
    {0xC967, 0x4EE9}, //5850 #CJK UNIFIED IDEOGRAPH
    {0xC968, 0x4EE1}, //5851 #CJK UNIFIED IDEOGRAPH
    {0xC969, 0x4EDD}, //5852 #CJK UNIFIED IDEOGRAPH
    {0xC96A, 0x4EDA}, //5853 #CJK UNIFIED IDEOGRAPH
    {0xC96B, 0x520C}, //5854 #CJK UNIFIED IDEOGRAPH
    {0xC96C, 0x531C}, //5855 #CJK UNIFIED IDEOGRAPH
    {0xC96D, 0x534C}, //5856 #CJK UNIFIED IDEOGRAPH
    {0xC96E, 0x5722}, //5857 #CJK UNIFIED IDEOGRAPH
    {0xC96F, 0x5723}, //5858 #CJK UNIFIED IDEOGRAPH
    {0xC970, 0x5917}, //5859 #CJK UNIFIED IDEOGRAPH
    {0xC971, 0x592F}, //5860 #CJK UNIFIED IDEOGRAPH
    {0xC972, 0x5B81}, //5861 #CJK UNIFIED IDEOGRAPH
    {0xC973, 0x5B84}, //5862 #CJK UNIFIED IDEOGRAPH
    {0xC974, 0x5C12}, //5863 #CJK UNIFIED IDEOGRAPH
    {0xC975, 0x5C3B}, //5864 #CJK UNIFIED IDEOGRAPH
    {0xC976, 0x5C74}, //5865 #CJK UNIFIED IDEOGRAPH
    {0xC977, 0x5C73}, //5866 #CJK UNIFIED IDEOGRAPH
    {0xC978, 0x5E04}, //5867 #CJK UNIFIED IDEOGRAPH
    {0xC979, 0x5E80}, //5868 #CJK UNIFIED IDEOGRAPH
    {0xC97A, 0x5E82}, //5869 #CJK UNIFIED IDEOGRAPH
    {0xC97B, 0x5FC9}, //5870 #CJK UNIFIED IDEOGRAPH
    {0xC97C, 0x6209}, //5871 #CJK UNIFIED IDEOGRAPH
    {0xC97D, 0x6250}, //5872 #CJK UNIFIED IDEOGRAPH
    {0xC97E, 0x6C15}, //5873 #CJK UNIFIED IDEOGRAPH
    {0xC9A1, 0x6C36}, //5874 #CJK UNIFIED IDEOGRAPH
    {0xC9A2, 0x6C43}, //5875 #CJK UNIFIED IDEOGRAPH
    {0xC9A3, 0x6C3F}, //5876 #CJK UNIFIED IDEOGRAPH
    {0xC9A4, 0x6C3B}, //5877 #CJK UNIFIED IDEOGRAPH
    {0xC9A5, 0x72AE}, //5878 #CJK UNIFIED IDEOGRAPH
    {0xC9A6, 0x72B0}, //5879 #CJK UNIFIED IDEOGRAPH
    {0xC9A7, 0x738A}, //5880 #CJK UNIFIED IDEOGRAPH
    {0xC9A8, 0x79B8}, //5881 #CJK UNIFIED IDEOGRAPH
    {0xC9A9, 0x808A}, //5882 #CJK UNIFIED IDEOGRAPH
    {0xC9AA, 0x961E}, //5883 #CJK UNIFIED IDEOGRAPH
    {0xC9AB, 0x4F0E}, //5884 #CJK UNIFIED IDEOGRAPH
    {0xC9AC, 0x4F18}, //5885 #CJK UNIFIED IDEOGRAPH
    {0xC9AD, 0x4F2C}, //5886 #CJK UNIFIED IDEOGRAPH
    {0xC9AE, 0x4EF5}, //5887 #CJK UNIFIED IDEOGRAPH
    {0xC9AF, 0x4F14}, //5888 #CJK UNIFIED IDEOGRAPH
    {0xC9B0, 0x4EF1}, //5889 #CJK UNIFIED IDEOGRAPH
    {0xC9B1, 0x4F00}, //5890 #CJK UNIFIED IDEOGRAPH
    {0xC9B2, 0x4EF7}, //5891 #CJK UNIFIED IDEOGRAPH
    {0xC9B3, 0x4F08}, //5892 #CJK UNIFIED IDEOGRAPH
    {0xC9B4, 0x4F1D}, //5893 #CJK UNIFIED IDEOGRAPH
    {0xC9B5, 0x4F02}, //5894 #CJK UNIFIED IDEOGRAPH
    {0xC9B6, 0x4F05}, //5895 #CJK UNIFIED IDEOGRAPH
    {0xC9B7, 0x4F22}, //5896 #CJK UNIFIED IDEOGRAPH
    {0xC9B8, 0x4F13}, //5897 #CJK UNIFIED IDEOGRAPH
    {0xC9B9, 0x4F04}, //5898 #CJK UNIFIED IDEOGRAPH
    {0xC9BA, 0x4EF4}, //5899 #CJK UNIFIED IDEOGRAPH
    {0xC9BB, 0x4F12}, //5900 #CJK UNIFIED IDEOGRAPH
    {0xC9BC, 0x51B1}, //5901 #CJK UNIFIED IDEOGRAPH
    {0xC9BD, 0x5213}, //5902 #CJK UNIFIED IDEOGRAPH
    {0xC9BE, 0x5209}, //5903 #CJK UNIFIED IDEOGRAPH
    {0xC9BF, 0x5210}, //5904 #CJK UNIFIED IDEOGRAPH
    {0xC9C0, 0x52A6}, //5905 #CJK UNIFIED IDEOGRAPH
    {0xC9C1, 0x5322}, //5906 #CJK UNIFIED IDEOGRAPH
    {0xC9C2, 0x531F}, //5907 #CJK UNIFIED IDEOGRAPH
    {0xC9C3, 0x534D}, //5908 #CJK UNIFIED IDEOGRAPH
    {0xC9C4, 0x538A}, //5909 #CJK UNIFIED IDEOGRAPH
    {0xC9C5, 0x5407}, //5910 #CJK UNIFIED IDEOGRAPH
    {0xC9C6, 0x56E1}, //5911 #CJK UNIFIED IDEOGRAPH
    {0xC9C7, 0x56DF}, //5912 #CJK UNIFIED IDEOGRAPH
    {0xC9C8, 0x572E}, //5913 #CJK UNIFIED IDEOGRAPH
    {0xC9C9, 0x572A}, //5914 #CJK UNIFIED IDEOGRAPH
    {0xC9CA, 0x5734}, //5915 #CJK UNIFIED IDEOGRAPH
    {0xC9CB, 0x593C}, //5916 #CJK UNIFIED IDEOGRAPH
    {0xC9CC, 0x5980}, //5917 #CJK UNIFIED IDEOGRAPH
    {0xC9CD, 0x597C}, //5918 #CJK UNIFIED IDEOGRAPH
    {0xC9CE, 0x5985}, //5919 #CJK UNIFIED IDEOGRAPH
    {0xC9CF, 0x597B}, //5920 #CJK UNIFIED IDEOGRAPH
    {0xC9D0, 0x597E}, //5921 #CJK UNIFIED IDEOGRAPH
    {0xC9D1, 0x5977}, //5922 #CJK UNIFIED IDEOGRAPH
    {0xC9D2, 0x597F}, //5923 #CJK UNIFIED IDEOGRAPH
    {0xC9D3, 0x5B56}, //5924 #CJK UNIFIED IDEOGRAPH
    {0xC9D4, 0x5C15}, //5925 #CJK UNIFIED IDEOGRAPH
    {0xC9D5, 0x5C25}, //5926 #CJK UNIFIED IDEOGRAPH
    {0xC9D6, 0x5C7C}, //5927 #CJK UNIFIED IDEOGRAPH
    {0xC9D7, 0x5C7A}, //5928 #CJK UNIFIED IDEOGRAPH
    {0xC9D8, 0x5C7B}, //5929 #CJK UNIFIED IDEOGRAPH
    {0xC9D9, 0x5C7E}, //5930 #CJK UNIFIED IDEOGRAPH
    {0xC9DA, 0x5DDF}, //5931 #CJK UNIFIED IDEOGRAPH
    {0xC9DB, 0x5E75}, //5932 #CJK UNIFIED IDEOGRAPH
    {0xC9DC, 0x5E84}, //5933 #CJK UNIFIED IDEOGRAPH
    {0xC9DD, 0x5F02}, //5934 #CJK UNIFIED IDEOGRAPH
    {0xC9DE, 0x5F1A}, //5935 #CJK UNIFIED IDEOGRAPH
    {0xC9DF, 0x5F74}, //5936 #CJK UNIFIED IDEOGRAPH
    {0xC9E0, 0x5FD5}, //5937 #CJK UNIFIED IDEOGRAPH
    {0xC9E1, 0x5FD4}, //5938 #CJK UNIFIED IDEOGRAPH
    {0xC9E2, 0x5FCF}, //5939 #CJK UNIFIED IDEOGRAPH
    {0xC9E3, 0x625C}, //5940 #CJK UNIFIED IDEOGRAPH
    {0xC9E4, 0x625E}, //5941 #CJK UNIFIED IDEOGRAPH
    {0xC9E5, 0x6264}, //5942 #CJK UNIFIED IDEOGRAPH
    {0xC9E6, 0x6261}, //5943 #CJK UNIFIED IDEOGRAPH
    {0xC9E7, 0x6266}, //5944 #CJK UNIFIED IDEOGRAPH
    {0xC9E8, 0x6262}, //5945 #CJK UNIFIED IDEOGRAPH
    {0xC9E9, 0x6259}, //5946 #CJK UNIFIED IDEOGRAPH
    {0xC9EA, 0x6260}, //5947 #CJK UNIFIED IDEOGRAPH
    {0xC9EB, 0x625A}, //5948 #CJK UNIFIED IDEOGRAPH
    {0xC9EC, 0x6265}, //5949 #CJK UNIFIED IDEOGRAPH
    {0xC9ED, 0x65EF}, //5950 #CJK UNIFIED IDEOGRAPH
    {0xC9EE, 0x65EE}, //5951 #CJK UNIFIED IDEOGRAPH
    {0xC9EF, 0x673E}, //5952 #CJK UNIFIED IDEOGRAPH
    {0xC9F0, 0x6739}, //5953 #CJK UNIFIED IDEOGRAPH
    {0xC9F1, 0x6738}, //5954 #CJK UNIFIED IDEOGRAPH
    {0xC9F2, 0x673B}, //5955 #CJK UNIFIED IDEOGRAPH
    {0xC9F3, 0x673A}, //5956 #CJK UNIFIED IDEOGRAPH
    {0xC9F4, 0x673F}, //5957 #CJK UNIFIED IDEOGRAPH
    {0xC9F5, 0x673C}, //5958 #CJK UNIFIED IDEOGRAPH
    {0xC9F6, 0x6733}, //5959 #CJK UNIFIED IDEOGRAPH
    {0xC9F7, 0x6C18}, //5960 #CJK UNIFIED IDEOGRAPH
    {0xC9F8, 0x6C46}, //5961 #CJK UNIFIED IDEOGRAPH
    {0xC9F9, 0x6C52}, //5962 #CJK UNIFIED IDEOGRAPH
    {0xC9FA, 0x6C5C}, //5963 #CJK UNIFIED IDEOGRAPH
    {0xC9FB, 0x6C4F}, //5964 #CJK UNIFIED IDEOGRAPH
    {0xC9FC, 0x6C4A}, //5965 #CJK UNIFIED IDEOGRAPH
    {0xC9FD, 0x6C54}, //5966 #CJK UNIFIED IDEOGRAPH
    {0xC9FE, 0x6C4B}, //5967 #CJK UNIFIED IDEOGRAPH
    {0xCA40, 0x6C4C}, //5968 #CJK UNIFIED IDEOGRAPH
    {0xCA41, 0x7071}, //5969 #CJK UNIFIED IDEOGRAPH
    {0xCA42, 0x725E}, //5970 #CJK UNIFIED IDEOGRAPH
    {0xCA43, 0x72B4}, //5971 #CJK UNIFIED IDEOGRAPH
    {0xCA44, 0x72B5}, //5972 #CJK UNIFIED IDEOGRAPH
    {0xCA45, 0x738E}, //5973 #CJK UNIFIED IDEOGRAPH
    {0xCA46, 0x752A}, //5974 #CJK UNIFIED IDEOGRAPH
    {0xCA47, 0x767F}, //5975 #CJK UNIFIED IDEOGRAPH
    {0xCA48, 0x7A75}, //5976 #CJK UNIFIED IDEOGRAPH
    {0xCA49, 0x7F51}, //5977 #CJK UNIFIED IDEOGRAPH
    {0xCA4A, 0x8278}, //5978 #CJK UNIFIED IDEOGRAPH
    {0xCA4B, 0x827C}, //5979 #CJK UNIFIED IDEOGRAPH
    {0xCA4C, 0x8280}, //5980 #CJK UNIFIED IDEOGRAPH
    {0xCA4D, 0x827D}, //5981 #CJK UNIFIED IDEOGRAPH
    {0xCA4E, 0x827F}, //5982 #CJK UNIFIED IDEOGRAPH
    {0xCA4F, 0x864D}, //5983 #CJK UNIFIED IDEOGRAPH
    {0xCA50, 0x897E}, //5984 #CJK UNIFIED IDEOGRAPH
    {0xCA51, 0x9099}, //5985 #CJK UNIFIED IDEOGRAPH
    {0xCA52, 0x9097}, //5986 #CJK UNIFIED IDEOGRAPH
    {0xCA53, 0x9098}, //5987 #CJK UNIFIED IDEOGRAPH
    {0xCA54, 0x909B}, //5988 #CJK UNIFIED IDEOGRAPH
    {0xCA55, 0x9094}, //5989 #CJK UNIFIED IDEOGRAPH
    {0xCA56, 0x9622}, //5990 #CJK UNIFIED IDEOGRAPH
    {0xCA57, 0x9624}, //5991 #CJK UNIFIED IDEOGRAPH
    {0xCA58, 0x9620}, //5992 #CJK UNIFIED IDEOGRAPH
    {0xCA59, 0x9623}, //5993 #CJK UNIFIED IDEOGRAPH
    {0xCA5A, 0x4F56}, //5994 #CJK UNIFIED IDEOGRAPH
    {0xCA5B, 0x4F3B}, //5995 #CJK UNIFIED IDEOGRAPH
    {0xCA5C, 0x4F62}, //5996 #CJK UNIFIED IDEOGRAPH
    {0xCA5D, 0x4F49}, //5997 #CJK UNIFIED IDEOGRAPH
    {0xCA5E, 0x4F53}, //5998 #CJK UNIFIED IDEOGRAPH
    {0xCA5F, 0x4F64}, //5999 #CJK UNIFIED IDEOGRAPH
    {0xCA60, 0x4F3E}, //6000 #CJK UNIFIED IDEOGRAPH
    {0xCA61, 0x4F67}, //6001 #CJK UNIFIED IDEOGRAPH
    {0xCA62, 0x4F52}, //6002 #CJK UNIFIED IDEOGRAPH
    {0xCA63, 0x4F5F}, //6003 #CJK UNIFIED IDEOGRAPH
    {0xCA64, 0x4F41}, //6004 #CJK UNIFIED IDEOGRAPH
    {0xCA65, 0x4F58}, //6005 #CJK UNIFIED IDEOGRAPH
    {0xCA66, 0x4F2D}, //6006 #CJK UNIFIED IDEOGRAPH
    {0xCA67, 0x4F33}, //6007 #CJK UNIFIED IDEOGRAPH
    {0xCA68, 0x4F3F}, //6008 #CJK UNIFIED IDEOGRAPH
    {0xCA69, 0x4F61}, //6009 #CJK UNIFIED IDEOGRAPH
    {0xCA6A, 0x518F}, //6010 #CJK UNIFIED IDEOGRAPH
    {0xCA6B, 0x51B9}, //6011 #CJK UNIFIED IDEOGRAPH
    {0xCA6C, 0x521C}, //6012 #CJK UNIFIED IDEOGRAPH
    {0xCA6D, 0x521E}, //6013 #CJK UNIFIED IDEOGRAPH
    {0xCA6E, 0x5221}, //6014 #CJK UNIFIED IDEOGRAPH
    {0xCA6F, 0x52AD}, //6015 #CJK UNIFIED IDEOGRAPH
    {0xCA70, 0x52AE}, //6016 #CJK UNIFIED IDEOGRAPH
    {0xCA71, 0x5309}, //6017 #CJK UNIFIED IDEOGRAPH
    {0xCA72, 0x5363}, //6018 #CJK UNIFIED IDEOGRAPH
    {0xCA73, 0x5372}, //6019 #CJK UNIFIED IDEOGRAPH
    {0xCA74, 0x538E}, //6020 #CJK UNIFIED IDEOGRAPH
    {0xCA75, 0x538F}, //6021 #CJK UNIFIED IDEOGRAPH
    {0xCA76, 0x5430}, //6022 #CJK UNIFIED IDEOGRAPH
    {0xCA77, 0x5437}, //6023 #CJK UNIFIED IDEOGRAPH
    {0xCA78, 0x542A}, //6024 #CJK UNIFIED IDEOGRAPH
    {0xCA79, 0x5454}, //6025 #CJK UNIFIED IDEOGRAPH
    {0xCA7A, 0x5445}, //6026 #CJK UNIFIED IDEOGRAPH
    {0xCA7B, 0x5419}, //6027 #CJK UNIFIED IDEOGRAPH
    {0xCA7C, 0x541C}, //6028 #CJK UNIFIED IDEOGRAPH
    {0xCA7D, 0x5425}, //6029 #CJK UNIFIED IDEOGRAPH
    {0xCA7E, 0x5418}, //6030 #CJK UNIFIED IDEOGRAPH
    {0xCAA1, 0x543D}, //6031 #CJK UNIFIED IDEOGRAPH
    {0xCAA2, 0x544F}, //6032 #CJK UNIFIED IDEOGRAPH
    {0xCAA3, 0x5441}, //6033 #CJK UNIFIED IDEOGRAPH
    {0xCAA4, 0x5428}, //6034 #CJK UNIFIED IDEOGRAPH
    {0xCAA5, 0x5424}, //6035 #CJK UNIFIED IDEOGRAPH
    {0xCAA6, 0x5447}, //6036 #CJK UNIFIED IDEOGRAPH
    {0xCAA7, 0x56EE}, //6037 #CJK UNIFIED IDEOGRAPH
    {0xCAA8, 0x56E7}, //6038 #CJK UNIFIED IDEOGRAPH
    {0xCAA9, 0x56E5}, //6039 #CJK UNIFIED IDEOGRAPH
    {0xCAAA, 0x5741}, //6040 #CJK UNIFIED IDEOGRAPH
    {0xCAAB, 0x5745}, //6041 #CJK UNIFIED IDEOGRAPH
    {0xCAAC, 0x574C}, //6042 #CJK UNIFIED IDEOGRAPH
    {0xCAAD, 0x5749}, //6043 #CJK UNIFIED IDEOGRAPH
    {0xCAAE, 0x574B}, //6044 #CJK UNIFIED IDEOGRAPH
    {0xCAAF, 0x5752}, //6045 #CJK UNIFIED IDEOGRAPH
    {0xCAB0, 0x5906}, //6046 #CJK UNIFIED IDEOGRAPH
    {0xCAB1, 0x5940}, //6047 #CJK UNIFIED IDEOGRAPH
    {0xCAB2, 0x59A6}, //6048 #CJK UNIFIED IDEOGRAPH
    {0xCAB3, 0x5998}, //6049 #CJK UNIFIED IDEOGRAPH
    {0xCAB4, 0x59A0}, //6050 #CJK UNIFIED IDEOGRAPH
    {0xCAB5, 0x5997}, //6051 #CJK UNIFIED IDEOGRAPH
    {0xCAB6, 0x598E}, //6052 #CJK UNIFIED IDEOGRAPH
    {0xCAB7, 0x59A2}, //6053 #CJK UNIFIED IDEOGRAPH
    {0xCAB8, 0x5990}, //6054 #CJK UNIFIED IDEOGRAPH
    {0xCAB9, 0x598F}, //6055 #CJK UNIFIED IDEOGRAPH
    {0xCABA, 0x59A7}, //6056 #CJK UNIFIED IDEOGRAPH
    {0xCABB, 0x59A1}, //6057 #CJK UNIFIED IDEOGRAPH
    {0xCABC, 0x5B8E}, //6058 #CJK UNIFIED IDEOGRAPH
    {0xCABD, 0x5B92}, //6059 #CJK UNIFIED IDEOGRAPH
    {0xCABE, 0x5C28}, //6060 #CJK UNIFIED IDEOGRAPH
    {0xCABF, 0x5C2A}, //6061 #CJK UNIFIED IDEOGRAPH
    {0xCAC0, 0x5C8D}, //6062 #CJK UNIFIED IDEOGRAPH
    {0xCAC1, 0x5C8F}, //6063 #CJK UNIFIED IDEOGRAPH
    {0xCAC2, 0x5C88}, //6064 #CJK UNIFIED IDEOGRAPH
    {0xCAC3, 0x5C8B}, //6065 #CJK UNIFIED IDEOGRAPH
    {0xCAC4, 0x5C89}, //6066 #CJK UNIFIED IDEOGRAPH
    {0xCAC5, 0x5C92}, //6067 #CJK UNIFIED IDEOGRAPH
    {0xCAC6, 0x5C8A}, //6068 #CJK UNIFIED IDEOGRAPH
    {0xCAC7, 0x5C86}, //6069 #CJK UNIFIED IDEOGRAPH
    {0xCAC8, 0x5C93}, //6070 #CJK UNIFIED IDEOGRAPH
    {0xCAC9, 0x5C95}, //6071 #CJK UNIFIED IDEOGRAPH
    {0xCACA, 0x5DE0}, //6072 #CJK UNIFIED IDEOGRAPH
    {0xCACB, 0x5E0A}, //6073 #CJK UNIFIED IDEOGRAPH
    {0xCACC, 0x5E0E}, //6074 #CJK UNIFIED IDEOGRAPH
    {0xCACD, 0x5E8B}, //6075 #CJK UNIFIED IDEOGRAPH
    {0xCACE, 0x5E89}, //6076 #CJK UNIFIED IDEOGRAPH
    {0xCACF, 0x5E8C}, //6077 #CJK UNIFIED IDEOGRAPH
    {0xCAD0, 0x5E88}, //6078 #CJK UNIFIED IDEOGRAPH
    {0xCAD1, 0x5E8D}, //6079 #CJK UNIFIED IDEOGRAPH
    {0xCAD2, 0x5F05}, //6080 #CJK UNIFIED IDEOGRAPH
    {0xCAD3, 0x5F1D}, //6081 #CJK UNIFIED IDEOGRAPH
    {0xCAD4, 0x5F78}, //6082 #CJK UNIFIED IDEOGRAPH
    {0xCAD5, 0x5F76}, //6083 #CJK UNIFIED IDEOGRAPH
    {0xCAD6, 0x5FD2}, //6084 #CJK UNIFIED IDEOGRAPH
    {0xCAD7, 0x5FD1}, //6085 #CJK UNIFIED IDEOGRAPH
    {0xCAD8, 0x5FD0}, //6086 #CJK UNIFIED IDEOGRAPH
    {0xCAD9, 0x5FED}, //6087 #CJK UNIFIED IDEOGRAPH
    {0xCADA, 0x5FE8}, //6088 #CJK UNIFIED IDEOGRAPH
    {0xCADB, 0x5FEE}, //6089 #CJK UNIFIED IDEOGRAPH
    {0xCADC, 0x5FF3}, //6090 #CJK UNIFIED IDEOGRAPH
    {0xCADD, 0x5FE1}, //6091 #CJK UNIFIED IDEOGRAPH
    {0xCADE, 0x5FE4}, //6092 #CJK UNIFIED IDEOGRAPH
    {0xCADF, 0x5FE3}, //6093 #CJK UNIFIED IDEOGRAPH
    {0xCAE0, 0x5FFA}, //6094 #CJK UNIFIED IDEOGRAPH
    {0xCAE1, 0x5FEF}, //6095 #CJK UNIFIED IDEOGRAPH
    {0xCAE2, 0x5FF7}, //6096 #CJK UNIFIED IDEOGRAPH
    {0xCAE3, 0x5FFB}, //6097 #CJK UNIFIED IDEOGRAPH
    {0xCAE4, 0x6000}, //6098 #CJK UNIFIED IDEOGRAPH
    {0xCAE5, 0x5FF4}, //6099 #CJK UNIFIED IDEOGRAPH
    {0xCAE6, 0x623A}, //6100 #CJK UNIFIED IDEOGRAPH
    {0xCAE7, 0x6283}, //6101 #CJK UNIFIED IDEOGRAPH
    {0xCAE8, 0x628C}, //6102 #CJK UNIFIED IDEOGRAPH
    {0xCAE9, 0x628E}, //6103 #CJK UNIFIED IDEOGRAPH
    {0xCAEA, 0x628F}, //6104 #CJK UNIFIED IDEOGRAPH
    {0xCAEB, 0x6294}, //6105 #CJK UNIFIED IDEOGRAPH
    {0xCAEC, 0x6287}, //6106 #CJK UNIFIED IDEOGRAPH
    {0xCAED, 0x6271}, //6107 #CJK UNIFIED IDEOGRAPH
    {0xCAEE, 0x627B}, //6108 #CJK UNIFIED IDEOGRAPH
    {0xCAEF, 0x627A}, //6109 #CJK UNIFIED IDEOGRAPH
    {0xCAF0, 0x6270}, //6110 #CJK UNIFIED IDEOGRAPH
    {0xCAF1, 0x6281}, //6111 #CJK UNIFIED IDEOGRAPH
    {0xCAF2, 0x6288}, //6112 #CJK UNIFIED IDEOGRAPH
    {0xCAF3, 0x6277}, //6113 #CJK UNIFIED IDEOGRAPH
    {0xCAF4, 0x627D}, //6114 #CJK UNIFIED IDEOGRAPH
    {0xCAF5, 0x6272}, //6115 #CJK UNIFIED IDEOGRAPH
    {0xCAF6, 0x6274}, //6116 #CJK UNIFIED IDEOGRAPH
    {0xCAF7, 0x6537}, //6117 #CJK UNIFIED IDEOGRAPH
    {0xCAF8, 0x65F0}, //6118 #CJK UNIFIED IDEOGRAPH
    {0xCAF9, 0x65F4}, //6119 #CJK UNIFIED IDEOGRAPH
    {0xCAFA, 0x65F3}, //6120 #CJK UNIFIED IDEOGRAPH
    {0xCAFB, 0x65F2}, //6121 #CJK UNIFIED IDEOGRAPH
    {0xCAFC, 0x65F5}, //6122 #CJK UNIFIED IDEOGRAPH
    {0xCAFD, 0x6745}, //6123 #CJK UNIFIED IDEOGRAPH
    {0xCAFE, 0x6747}, //6124 #CJK UNIFIED IDEOGRAPH
    {0xCB40, 0x6759}, //6125 #CJK UNIFIED IDEOGRAPH
    {0xCB41, 0x6755}, //6126 #CJK UNIFIED IDEOGRAPH
    {0xCB42, 0x674C}, //6127 #CJK UNIFIED IDEOGRAPH
    {0xCB43, 0x6748}, //6128 #CJK UNIFIED IDEOGRAPH
    {0xCB44, 0x675D}, //6129 #CJK UNIFIED IDEOGRAPH
    {0xCB45, 0x674D}, //6130 #CJK UNIFIED IDEOGRAPH
    {0xCB46, 0x675A}, //6131 #CJK UNIFIED IDEOGRAPH
    {0xCB47, 0x674B}, //6132 #CJK UNIFIED IDEOGRAPH
    {0xCB48, 0x6BD0}, //6133 #CJK UNIFIED IDEOGRAPH
    {0xCB49, 0x6C19}, //6134 #CJK UNIFIED IDEOGRAPH
    {0xCB4A, 0x6C1A}, //6135 #CJK UNIFIED IDEOGRAPH
    {0xCB4B, 0x6C78}, //6136 #CJK UNIFIED IDEOGRAPH
    {0xCB4C, 0x6C67}, //6137 #CJK UNIFIED IDEOGRAPH
    {0xCB4D, 0x6C6B}, //6138 #CJK UNIFIED IDEOGRAPH
    {0xCB4E, 0x6C84}, //6139 #CJK UNIFIED IDEOGRAPH
    {0xCB4F, 0x6C8B}, //6140 #CJK UNIFIED IDEOGRAPH
    {0xCB50, 0x6C8F}, //6141 #CJK UNIFIED IDEOGRAPH
    {0xCB51, 0x6C71}, //6142 #CJK UNIFIED IDEOGRAPH
    {0xCB52, 0x6C6F}, //6143 #CJK UNIFIED IDEOGRAPH
    {0xCB53, 0x6C69}, //6144 #CJK UNIFIED IDEOGRAPH
    {0xCB54, 0x6C9A}, //6145 #CJK UNIFIED IDEOGRAPH
    {0xCB55, 0x6C6D}, //6146 #CJK UNIFIED IDEOGRAPH
    {0xCB56, 0x6C87}, //6147 #CJK UNIFIED IDEOGRAPH
    {0xCB57, 0x6C95}, //6148 #CJK UNIFIED IDEOGRAPH
    {0xCB58, 0x6C9C}, //6149 #CJK UNIFIED IDEOGRAPH
    {0xCB59, 0x6C66}, //6150 #CJK UNIFIED IDEOGRAPH
    {0xCB5A, 0x6C73}, //6151 #CJK UNIFIED IDEOGRAPH
    {0xCB5B, 0x6C65}, //6152 #CJK UNIFIED IDEOGRAPH
    {0xCB5C, 0x6C7B}, //6153 #CJK UNIFIED IDEOGRAPH
    {0xCB5D, 0x6C8E}, //6154 #CJK UNIFIED IDEOGRAPH
    {0xCB5E, 0x7074}, //6155 #CJK UNIFIED IDEOGRAPH
    {0xCB5F, 0x707A}, //6156 #CJK UNIFIED IDEOGRAPH
    {0xCB60, 0x7263}, //6157 #CJK UNIFIED IDEOGRAPH
    {0xCB61, 0x72BF}, //6158 #CJK UNIFIED IDEOGRAPH
    {0xCB62, 0x72BD}, //6159 #CJK UNIFIED IDEOGRAPH
    {0xCB63, 0x72C3}, //6160 #CJK UNIFIED IDEOGRAPH
    {0xCB64, 0x72C6}, //6161 #CJK UNIFIED IDEOGRAPH
    {0xCB65, 0x72C1}, //6162 #CJK UNIFIED IDEOGRAPH
    {0xCB66, 0x72BA}, //6163 #CJK UNIFIED IDEOGRAPH
    {0xCB67, 0x72C5}, //6164 #CJK UNIFIED IDEOGRAPH
    {0xCB68, 0x7395}, //6165 #CJK UNIFIED IDEOGRAPH
    {0xCB69, 0x7397}, //6166 #CJK UNIFIED IDEOGRAPH
    {0xCB6A, 0x7393}, //6167 #CJK UNIFIED IDEOGRAPH
    {0xCB6B, 0x7394}, //6168 #CJK UNIFIED IDEOGRAPH
    {0xCB6C, 0x7392}, //6169 #CJK UNIFIED IDEOGRAPH
    {0xCB6D, 0x753A}, //6170 #CJK UNIFIED IDEOGRAPH
    {0xCB6E, 0x7539}, //6171 #CJK UNIFIED IDEOGRAPH
    {0xCB6F, 0x7594}, //6172 #CJK UNIFIED IDEOGRAPH
    {0xCB70, 0x7595}, //6173 #CJK UNIFIED IDEOGRAPH
    {0xCB71, 0x7681}, //6174 #CJK UNIFIED IDEOGRAPH
    {0xCB72, 0x793D}, //6175 #CJK UNIFIED IDEOGRAPH
    {0xCB73, 0x8034}, //6176 #CJK UNIFIED IDEOGRAPH
    {0xCB74, 0x8095}, //6177 #CJK UNIFIED IDEOGRAPH
    {0xCB75, 0x8099}, //6178 #CJK UNIFIED IDEOGRAPH
    {0xCB76, 0x8090}, //6179 #CJK UNIFIED IDEOGRAPH
    {0xCB77, 0x8092}, //6180 #CJK UNIFIED IDEOGRAPH
    {0xCB78, 0x809C}, //6181 #CJK UNIFIED IDEOGRAPH
    {0xCB79, 0x8290}, //6182 #CJK UNIFIED IDEOGRAPH
    {0xCB7A, 0x828F}, //6183 #CJK UNIFIED IDEOGRAPH
    {0xCB7B, 0x8285}, //6184 #CJK UNIFIED IDEOGRAPH
    {0xCB7C, 0x828E}, //6185 #CJK UNIFIED IDEOGRAPH
    {0xCB7D, 0x8291}, //6186 #CJK UNIFIED IDEOGRAPH
    {0xCB7E, 0x8293}, //6187 #CJK UNIFIED IDEOGRAPH
    {0xCBA1, 0x828A}, //6188 #CJK UNIFIED IDEOGRAPH
    {0xCBA2, 0x8283}, //6189 #CJK UNIFIED IDEOGRAPH
    {0xCBA3, 0x8284}, //6190 #CJK UNIFIED IDEOGRAPH
    {0xCBA4, 0x8C78}, //6191 #CJK UNIFIED IDEOGRAPH
    {0xCBA5, 0x8FC9}, //6192 #CJK UNIFIED IDEOGRAPH
    {0xCBA6, 0x8FBF}, //6193 #CJK UNIFIED IDEOGRAPH
    {0xCBA7, 0x909F}, //6194 #CJK UNIFIED IDEOGRAPH
    {0xCBA8, 0x90A1}, //6195 #CJK UNIFIED IDEOGRAPH
    {0xCBA9, 0x90A5}, //6196 #CJK UNIFIED IDEOGRAPH
    {0xCBAA, 0x909E}, //6197 #CJK UNIFIED IDEOGRAPH
    {0xCBAB, 0x90A7}, //6198 #CJK UNIFIED IDEOGRAPH
    {0xCBAC, 0x90A0}, //6199 #CJK UNIFIED IDEOGRAPH
    {0xCBAD, 0x9630}, //6200 #CJK UNIFIED IDEOGRAPH
    {0xCBAE, 0x9628}, //6201 #CJK UNIFIED IDEOGRAPH
    {0xCBAF, 0x962F}, //6202 #CJK UNIFIED IDEOGRAPH
    {0xCBB0, 0x962D}, //6203 #CJK UNIFIED IDEOGRAPH
    {0xCBB1, 0x4E33}, //6204 #CJK UNIFIED IDEOGRAPH
    {0xCBB2, 0x4F98}, //6205 #CJK UNIFIED IDEOGRAPH
    {0xCBB3, 0x4F7C}, //6206 #CJK UNIFIED IDEOGRAPH
    {0xCBB4, 0x4F85}, //6207 #CJK UNIFIED IDEOGRAPH
    {0xCBB5, 0x4F7D}, //6208 #CJK UNIFIED IDEOGRAPH
    {0xCBB6, 0x4F80}, //6209 #CJK UNIFIED IDEOGRAPH
    {0xCBB7, 0x4F87}, //6210 #CJK UNIFIED IDEOGRAPH
    {0xCBB8, 0x4F76}, //6211 #CJK UNIFIED IDEOGRAPH
    {0xCBB9, 0x4F74}, //6212 #CJK UNIFIED IDEOGRAPH
    {0xCBBA, 0x4F89}, //6213 #CJK UNIFIED IDEOGRAPH
    {0xCBBB, 0x4F84}, //6214 #CJK UNIFIED IDEOGRAPH
    {0xCBBC, 0x4F77}, //6215 #CJK UNIFIED IDEOGRAPH
    {0xCBBD, 0x4F4C}, //6216 #CJK UNIFIED IDEOGRAPH
    {0xCBBE, 0x4F97}, //6217 #CJK UNIFIED IDEOGRAPH
    {0xCBBF, 0x4F6A}, //6218 #CJK UNIFIED IDEOGRAPH
    {0xCBC0, 0x4F9A}, //6219 #CJK UNIFIED IDEOGRAPH
    {0xCBC1, 0x4F79}, //6220 #CJK UNIFIED IDEOGRAPH
    {0xCBC2, 0x4F81}, //6221 #CJK UNIFIED IDEOGRAPH
    {0xCBC3, 0x4F78}, //6222 #CJK UNIFIED IDEOGRAPH
    {0xCBC4, 0x4F90}, //6223 #CJK UNIFIED IDEOGRAPH
    {0xCBC5, 0x4F9C}, //6224 #CJK UNIFIED IDEOGRAPH
    {0xCBC6, 0x4F94}, //6225 #CJK UNIFIED IDEOGRAPH
    {0xCBC7, 0x4F9E}, //6226 #CJK UNIFIED IDEOGRAPH
    {0xCBC8, 0x4F92}, //6227 #CJK UNIFIED IDEOGRAPH
    {0xCBC9, 0x4F82}, //6228 #CJK UNIFIED IDEOGRAPH
    {0xCBCA, 0x4F95}, //6229 #CJK UNIFIED IDEOGRAPH
    {0xCBCB, 0x4F6B}, //6230 #CJK UNIFIED IDEOGRAPH
    {0xCBCC, 0x4F6E}, //6231 #CJK UNIFIED IDEOGRAPH
    {0xCBCD, 0x519E}, //6232 #CJK UNIFIED IDEOGRAPH
    {0xCBCE, 0x51BC}, //6233 #CJK UNIFIED IDEOGRAPH
    {0xCBCF, 0x51BE}, //6234 #CJK UNIFIED IDEOGRAPH
    {0xCBD0, 0x5235}, //6235 #CJK UNIFIED IDEOGRAPH
    {0xCBD1, 0x5232}, //6236 #CJK UNIFIED IDEOGRAPH
    {0xCBD2, 0x5233}, //6237 #CJK UNIFIED IDEOGRAPH
    {0xCBD3, 0x5246}, //6238 #CJK UNIFIED IDEOGRAPH
    {0xCBD4, 0x5231}, //6239 #CJK UNIFIED IDEOGRAPH
    {0xCBD5, 0x52BC}, //6240 #CJK UNIFIED IDEOGRAPH
    {0xCBD6, 0x530A}, //6241 #CJK UNIFIED IDEOGRAPH
    {0xCBD7, 0x530B}, //6242 #CJK UNIFIED IDEOGRAPH
    {0xCBD8, 0x533C}, //6243 #CJK UNIFIED IDEOGRAPH
    {0xCBD9, 0x5392}, //6244 #CJK UNIFIED IDEOGRAPH
    {0xCBDA, 0x5394}, //6245 #CJK UNIFIED IDEOGRAPH
    {0xCBDB, 0x5487}, //6246 #CJK UNIFIED IDEOGRAPH
    {0xCBDC, 0x547F}, //6247 #CJK UNIFIED IDEOGRAPH
    {0xCBDD, 0x5481}, //6248 #CJK UNIFIED IDEOGRAPH
    {0xCBDE, 0x5491}, //6249 #CJK UNIFIED IDEOGRAPH
    {0xCBDF, 0x5482}, //6250 #CJK UNIFIED IDEOGRAPH
    {0xCBE0, 0x5488}, //6251 #CJK UNIFIED IDEOGRAPH
    {0xCBE1, 0x546B}, //6252 #CJK UNIFIED IDEOGRAPH
    {0xCBE2, 0x547A}, //6253 #CJK UNIFIED IDEOGRAPH
    {0xCBE3, 0x547E}, //6254 #CJK UNIFIED IDEOGRAPH
    {0xCBE4, 0x5465}, //6255 #CJK UNIFIED IDEOGRAPH
    {0xCBE5, 0x546C}, //6256 #CJK UNIFIED IDEOGRAPH
    {0xCBE6, 0x5474}, //6257 #CJK UNIFIED IDEOGRAPH
    {0xCBE7, 0x5466}, //6258 #CJK UNIFIED IDEOGRAPH
    {0xCBE8, 0x548D}, //6259 #CJK UNIFIED IDEOGRAPH
    {0xCBE9, 0x546F}, //6260 #CJK UNIFIED IDEOGRAPH
    {0xCBEA, 0x5461}, //6261 #CJK UNIFIED IDEOGRAPH
    {0xCBEB, 0x5460}, //6262 #CJK UNIFIED IDEOGRAPH
    {0xCBEC, 0x5498}, //6263 #CJK UNIFIED IDEOGRAPH
    {0xCBED, 0x5463}, //6264 #CJK UNIFIED IDEOGRAPH
    {0xCBEE, 0x5467}, //6265 #CJK UNIFIED IDEOGRAPH
    {0xCBEF, 0x5464}, //6266 #CJK UNIFIED IDEOGRAPH
    {0xCBF0, 0x56F7}, //6267 #CJK UNIFIED IDEOGRAPH
    {0xCBF1, 0x56F9}, //6268 #CJK UNIFIED IDEOGRAPH
    {0xCBF2, 0x576F}, //6269 #CJK UNIFIED IDEOGRAPH
    {0xCBF3, 0x5772}, //6270 #CJK UNIFIED IDEOGRAPH
    {0xCBF4, 0x576D}, //6271 #CJK UNIFIED IDEOGRAPH
    {0xCBF5, 0x576B}, //6272 #CJK UNIFIED IDEOGRAPH
    {0xCBF6, 0x5771}, //6273 #CJK UNIFIED IDEOGRAPH
    {0xCBF7, 0x5770}, //6274 #CJK UNIFIED IDEOGRAPH
    {0xCBF8, 0x5776}, //6275 #CJK UNIFIED IDEOGRAPH
    {0xCBF9, 0x5780}, //6276 #CJK UNIFIED IDEOGRAPH
    {0xCBFA, 0x5775}, //6277 #CJK UNIFIED IDEOGRAPH
    {0xCBFB, 0x577B}, //6278 #CJK UNIFIED IDEOGRAPH
    {0xCBFC, 0x5773}, //6279 #CJK UNIFIED IDEOGRAPH
    {0xCBFD, 0x5774}, //6280 #CJK UNIFIED IDEOGRAPH
    {0xCBFE, 0x5762}, //6281 #CJK UNIFIED IDEOGRAPH
    {0xCC40, 0x5768}, //6282 #CJK UNIFIED IDEOGRAPH
    {0xCC41, 0x577D}, //6283 #CJK UNIFIED IDEOGRAPH
    {0xCC42, 0x590C}, //6284 #CJK UNIFIED IDEOGRAPH
    {0xCC43, 0x5945}, //6285 #CJK UNIFIED IDEOGRAPH
    {0xCC44, 0x59B5}, //6286 #CJK UNIFIED IDEOGRAPH
    {0xCC45, 0x59BA}, //6287 #CJK UNIFIED IDEOGRAPH
    {0xCC46, 0x59CF}, //6288 #CJK UNIFIED IDEOGRAPH
    {0xCC47, 0x59CE}, //6289 #CJK UNIFIED IDEOGRAPH
    {0xCC48, 0x59B2}, //6290 #CJK UNIFIED IDEOGRAPH
    {0xCC49, 0x59CC}, //6291 #CJK UNIFIED IDEOGRAPH
    {0xCC4A, 0x59C1}, //6292 #CJK UNIFIED IDEOGRAPH
    {0xCC4B, 0x59B6}, //6293 #CJK UNIFIED IDEOGRAPH
    {0xCC4C, 0x59BC}, //6294 #CJK UNIFIED IDEOGRAPH
    {0xCC4D, 0x59C3}, //6295 #CJK UNIFIED IDEOGRAPH
    {0xCC4E, 0x59D6}, //6296 #CJK UNIFIED IDEOGRAPH
    {0xCC4F, 0x59B1}, //6297 #CJK UNIFIED IDEOGRAPH
    {0xCC50, 0x59BD}, //6298 #CJK UNIFIED IDEOGRAPH
    {0xCC51, 0x59C0}, //6299 #CJK UNIFIED IDEOGRAPH
    {0xCC52, 0x59C8}, //6300 #CJK UNIFIED IDEOGRAPH
    {0xCC53, 0x59B4}, //6301 #CJK UNIFIED IDEOGRAPH
    {0xCC54, 0x59C7}, //6302 #CJK UNIFIED IDEOGRAPH
    {0xCC55, 0x5B62}, //6303 #CJK UNIFIED IDEOGRAPH
    {0xCC56, 0x5B65}, //6304 #CJK UNIFIED IDEOGRAPH
    {0xCC57, 0x5B93}, //6305 #CJK UNIFIED IDEOGRAPH
    {0xCC58, 0x5B95}, //6306 #CJK UNIFIED IDEOGRAPH
    {0xCC59, 0x5C44}, //6307 #CJK UNIFIED IDEOGRAPH
    {0xCC5A, 0x5C47}, //6308 #CJK UNIFIED IDEOGRAPH
    {0xCC5B, 0x5CAE}, //6309 #CJK UNIFIED IDEOGRAPH
    {0xCC5C, 0x5CA4}, //6310 #CJK UNIFIED IDEOGRAPH
    {0xCC5D, 0x5CA0}, //6311 #CJK UNIFIED IDEOGRAPH
    {0xCC5E, 0x5CB5}, //6312 #CJK UNIFIED IDEOGRAPH
    {0xCC5F, 0x5CAF}, //6313 #CJK UNIFIED IDEOGRAPH
    {0xCC60, 0x5CA8}, //6314 #CJK UNIFIED IDEOGRAPH
    {0xCC61, 0x5CAC}, //6315 #CJK UNIFIED IDEOGRAPH
    {0xCC62, 0x5C9F}, //6316 #CJK UNIFIED IDEOGRAPH
    {0xCC63, 0x5CA3}, //6317 #CJK UNIFIED IDEOGRAPH
    {0xCC64, 0x5CAD}, //6318 #CJK UNIFIED IDEOGRAPH
    {0xCC65, 0x5CA2}, //6319 #CJK UNIFIED IDEOGRAPH
    {0xCC66, 0x5CAA}, //6320 #CJK UNIFIED IDEOGRAPH
    {0xCC67, 0x5CA7}, //6321 #CJK UNIFIED IDEOGRAPH
    {0xCC68, 0x5C9D}, //6322 #CJK UNIFIED IDEOGRAPH
    {0xCC69, 0x5CA5}, //6323 #CJK UNIFIED IDEOGRAPH
    {0xCC6A, 0x5CB6}, //6324 #CJK UNIFIED IDEOGRAPH
    {0xCC6B, 0x5CB0}, //6325 #CJK UNIFIED IDEOGRAPH
    {0xCC6C, 0x5CA6}, //6326 #CJK UNIFIED IDEOGRAPH
    {0xCC6D, 0x5E17}, //6327 #CJK UNIFIED IDEOGRAPH
    {0xCC6E, 0x5E14}, //6328 #CJK UNIFIED IDEOGRAPH
    {0xCC6F, 0x5E19}, //6329 #CJK UNIFIED IDEOGRAPH
    {0xCC70, 0x5F28}, //6330 #CJK UNIFIED IDEOGRAPH
    {0xCC71, 0x5F22}, //6331 #CJK UNIFIED IDEOGRAPH
    {0xCC72, 0x5F23}, //6332 #CJK UNIFIED IDEOGRAPH
    {0xCC73, 0x5F24}, //6333 #CJK UNIFIED IDEOGRAPH
    {0xCC74, 0x5F54}, //6334 #CJK UNIFIED IDEOGRAPH
    {0xCC75, 0x5F82}, //6335 #CJK UNIFIED IDEOGRAPH
    {0xCC76, 0x5F7E}, //6336 #CJK UNIFIED IDEOGRAPH
    {0xCC77, 0x5F7D}, //6337 #CJK UNIFIED IDEOGRAPH
    {0xCC78, 0x5FDE}, //6338 #CJK UNIFIED IDEOGRAPH
    {0xCC79, 0x5FE5}, //6339 #CJK UNIFIED IDEOGRAPH
    {0xCC7A, 0x602D}, //6340 #CJK UNIFIED IDEOGRAPH
    {0xCC7B, 0x6026}, //6341 #CJK UNIFIED IDEOGRAPH
    {0xCC7C, 0x6019}, //6342 #CJK UNIFIED IDEOGRAPH
    {0xCC7D, 0x6032}, //6343 #CJK UNIFIED IDEOGRAPH
    {0xCC7E, 0x600B}, //6344 #CJK UNIFIED IDEOGRAPH
    {0xCCA1, 0x6034}, //6345 #CJK UNIFIED IDEOGRAPH
    {0xCCA2, 0x600A}, //6346 #CJK UNIFIED IDEOGRAPH
    {0xCCA3, 0x6017}, //6347 #CJK UNIFIED IDEOGRAPH
    {0xCCA4, 0x6033}, //6348 #CJK UNIFIED IDEOGRAPH
    {0xCCA5, 0x601A}, //6349 #CJK UNIFIED IDEOGRAPH
    {0xCCA6, 0x601E}, //6350 #CJK UNIFIED IDEOGRAPH
    {0xCCA7, 0x602C}, //6351 #CJK UNIFIED IDEOGRAPH
    {0xCCA8, 0x6022}, //6352 #CJK UNIFIED IDEOGRAPH
    {0xCCA9, 0x600D}, //6353 #CJK UNIFIED IDEOGRAPH
    {0xCCAA, 0x6010}, //6354 #CJK UNIFIED IDEOGRAPH
    {0xCCAB, 0x602E}, //6355 #CJK UNIFIED IDEOGRAPH
    {0xCCAC, 0x6013}, //6356 #CJK UNIFIED IDEOGRAPH
    {0xCCAD, 0x6011}, //6357 #CJK UNIFIED IDEOGRAPH
    {0xCCAE, 0x600C}, //6358 #CJK UNIFIED IDEOGRAPH
    {0xCCAF, 0x6009}, //6359 #CJK UNIFIED IDEOGRAPH
    {0xCCB0, 0x601C}, //6360 #CJK UNIFIED IDEOGRAPH
    {0xCCB1, 0x6214}, //6361 #CJK UNIFIED IDEOGRAPH
    {0xCCB2, 0x623D}, //6362 #CJK UNIFIED IDEOGRAPH
    {0xCCB3, 0x62AD}, //6363 #CJK UNIFIED IDEOGRAPH
    {0xCCB4, 0x62B4}, //6364 #CJK UNIFIED IDEOGRAPH
    {0xCCB5, 0x62D1}, //6365 #CJK UNIFIED IDEOGRAPH
    {0xCCB6, 0x62BE}, //6366 #CJK UNIFIED IDEOGRAPH
    {0xCCB7, 0x62AA}, //6367 #CJK UNIFIED IDEOGRAPH
    {0xCCB8, 0x62B6}, //6368 #CJK UNIFIED IDEOGRAPH
    {0xCCB9, 0x62CA}, //6369 #CJK UNIFIED IDEOGRAPH
    {0xCCBA, 0x62AE}, //6370 #CJK UNIFIED IDEOGRAPH
    {0xCCBB, 0x62B3}, //6371 #CJK UNIFIED IDEOGRAPH
    {0xCCBC, 0x62AF}, //6372 #CJK UNIFIED IDEOGRAPH
    {0xCCBD, 0x62BB}, //6373 #CJK UNIFIED IDEOGRAPH
    {0xCCBE, 0x62A9}, //6374 #CJK UNIFIED IDEOGRAPH
    {0xCCBF, 0x62B0}, //6375 #CJK UNIFIED IDEOGRAPH
    {0xCCC0, 0x62B8}, //6376 #CJK UNIFIED IDEOGRAPH
    {0xCCC1, 0x653D}, //6377 #CJK UNIFIED IDEOGRAPH
    {0xCCC2, 0x65A8}, //6378 #CJK UNIFIED IDEOGRAPH
    {0xCCC3, 0x65BB}, //6379 #CJK UNIFIED IDEOGRAPH
    {0xCCC4, 0x6609}, //6380 #CJK UNIFIED IDEOGRAPH
    {0xCCC5, 0x65FC}, //6381 #CJK UNIFIED IDEOGRAPH
    {0xCCC6, 0x6604}, //6382 #CJK UNIFIED IDEOGRAPH
    {0xCCC7, 0x6612}, //6383 #CJK UNIFIED IDEOGRAPH
    {0xCCC8, 0x6608}, //6384 #CJK UNIFIED IDEOGRAPH
    {0xCCC9, 0x65FB}, //6385 #CJK UNIFIED IDEOGRAPH
    {0xCCCA, 0x6603}, //6386 #CJK UNIFIED IDEOGRAPH
    {0xCCCB, 0x660B}, //6387 #CJK UNIFIED IDEOGRAPH
    {0xCCCC, 0x660D}, //6388 #CJK UNIFIED IDEOGRAPH
    {0xCCCD, 0x6605}, //6389 #CJK UNIFIED IDEOGRAPH
    {0xCCCE, 0x65FD}, //6390 #CJK UNIFIED IDEOGRAPH
    {0xCCCF, 0x6611}, //6391 #CJK UNIFIED IDEOGRAPH
    {0xCCD0, 0x6610}, //6392 #CJK UNIFIED IDEOGRAPH
    {0xCCD1, 0x66F6}, //6393 #CJK UNIFIED IDEOGRAPH
    {0xCCD2, 0x670A}, //6394 #CJK UNIFIED IDEOGRAPH
    {0xCCD3, 0x6785}, //6395 #CJK UNIFIED IDEOGRAPH
    {0xCCD4, 0x676C}, //6396 #CJK UNIFIED IDEOGRAPH
    {0xCCD5, 0x678E}, //6397 #CJK UNIFIED IDEOGRAPH
    {0xCCD6, 0x6792}, //6398 #CJK UNIFIED IDEOGRAPH
    {0xCCD7, 0x6776}, //6399 #CJK UNIFIED IDEOGRAPH
    {0xCCD8, 0x677B}, //6400 #CJK UNIFIED IDEOGRAPH
    {0xCCD9, 0x6798}, //6401 #CJK UNIFIED IDEOGRAPH
    {0xCCDA, 0x6786}, //6402 #CJK UNIFIED IDEOGRAPH
    {0xCCDB, 0x6784}, //6403 #CJK UNIFIED IDEOGRAPH
    {0xCCDC, 0x6774}, //6404 #CJK UNIFIED IDEOGRAPH
    {0xCCDD, 0x678D}, //6405 #CJK UNIFIED IDEOGRAPH
    {0xCCDE, 0x678C}, //6406 #CJK UNIFIED IDEOGRAPH
    {0xCCDF, 0x677A}, //6407 #CJK UNIFIED IDEOGRAPH
    {0xCCE0, 0x679F}, //6408 #CJK UNIFIED IDEOGRAPH
    {0xCCE1, 0x6791}, //6409 #CJK UNIFIED IDEOGRAPH
    {0xCCE2, 0x6799}, //6410 #CJK UNIFIED IDEOGRAPH
    {0xCCE3, 0x6783}, //6411 #CJK UNIFIED IDEOGRAPH
    {0xCCE4, 0x677D}, //6412 #CJK UNIFIED IDEOGRAPH
    {0xCCE5, 0x6781}, //6413 #CJK UNIFIED IDEOGRAPH
    {0xCCE6, 0x6778}, //6414 #CJK UNIFIED IDEOGRAPH
    {0xCCE7, 0x6779}, //6415 #CJK UNIFIED IDEOGRAPH
    {0xCCE8, 0x6794}, //6416 #CJK UNIFIED IDEOGRAPH
    {0xCCE9, 0x6B25}, //6417 #CJK UNIFIED IDEOGRAPH
    {0xCCEA, 0x6B80}, //6418 #CJK UNIFIED IDEOGRAPH
    {0xCCEB, 0x6B7E}, //6419 #CJK UNIFIED IDEOGRAPH
    {0xCCEC, 0x6BDE}, //6420 #CJK UNIFIED IDEOGRAPH
    {0xCCED, 0x6C1D}, //6421 #CJK UNIFIED IDEOGRAPH
    {0xCCEE, 0x6C93}, //6422 #CJK UNIFIED IDEOGRAPH
    {0xCCEF, 0x6CEC}, //6423 #CJK UNIFIED IDEOGRAPH
    {0xCCF0, 0x6CEB}, //6424 #CJK UNIFIED IDEOGRAPH
    {0xCCF1, 0x6CEE}, //6425 #CJK UNIFIED IDEOGRAPH
    {0xCCF2, 0x6CD9}, //6426 #CJK UNIFIED IDEOGRAPH
    {0xCCF3, 0x6CB6}, //6427 #CJK UNIFIED IDEOGRAPH
    {0xCCF4, 0x6CD4}, //6428 #CJK UNIFIED IDEOGRAPH
    {0xCCF5, 0x6CAD}, //6429 #CJK UNIFIED IDEOGRAPH
    {0xCCF6, 0x6CE7}, //6430 #CJK UNIFIED IDEOGRAPH
    {0xCCF7, 0x6CB7}, //6431 #CJK UNIFIED IDEOGRAPH
    {0xCCF8, 0x6CD0}, //6432 #CJK UNIFIED IDEOGRAPH
    {0xCCF9, 0x6CC2}, //6433 #CJK UNIFIED IDEOGRAPH
    {0xCCFA, 0x6CBA}, //6434 #CJK UNIFIED IDEOGRAPH
    {0xCCFB, 0x6CC3}, //6435 #CJK UNIFIED IDEOGRAPH
    {0xCCFC, 0x6CC6}, //6436 #CJK UNIFIED IDEOGRAPH
    {0xCCFD, 0x6CED}, //6437 #CJK UNIFIED IDEOGRAPH
    {0xCCFE, 0x6CF2}, //6438 #CJK UNIFIED IDEOGRAPH
    {0xCD40, 0x6CD2}, //6439 #CJK UNIFIED IDEOGRAPH
    {0xCD41, 0x6CDD}, //6440 #CJK UNIFIED IDEOGRAPH
    {0xCD42, 0x6CB4}, //6441 #CJK UNIFIED IDEOGRAPH
    {0xCD43, 0x6C8A}, //6442 #CJK UNIFIED IDEOGRAPH
    {0xCD44, 0x6C9D}, //6443 #CJK UNIFIED IDEOGRAPH
    {0xCD45, 0x6C80}, //6444 #CJK UNIFIED IDEOGRAPH
    {0xCD46, 0x6CDE}, //6445 #CJK UNIFIED IDEOGRAPH
    {0xCD47, 0x6CC0}, //6446 #CJK UNIFIED IDEOGRAPH
    {0xCD48, 0x6D30}, //6447 #CJK UNIFIED IDEOGRAPH
    {0xCD49, 0x6CCD}, //6448 #CJK UNIFIED IDEOGRAPH
    {0xCD4A, 0x6CC7}, //6449 #CJK UNIFIED IDEOGRAPH
    {0xCD4B, 0x6CB0}, //6450 #CJK UNIFIED IDEOGRAPH
    {0xCD4C, 0x6CF9}, //6451 #CJK UNIFIED IDEOGRAPH
    {0xCD4D, 0x6CCF}, //6452 #CJK UNIFIED IDEOGRAPH
    {0xCD4E, 0x6CE9}, //6453 #CJK UNIFIED IDEOGRAPH
    {0xCD4F, 0x6CD1}, //6454 #CJK UNIFIED IDEOGRAPH
    {0xCD50, 0x7094}, //6455 #CJK UNIFIED IDEOGRAPH
    {0xCD51, 0x7098}, //6456 #CJK UNIFIED IDEOGRAPH
    {0xCD52, 0x7085}, //6457 #CJK UNIFIED IDEOGRAPH
    {0xCD53, 0x7093}, //6458 #CJK UNIFIED IDEOGRAPH
    {0xCD54, 0x7086}, //6459 #CJK UNIFIED IDEOGRAPH
    {0xCD55, 0x7084}, //6460 #CJK UNIFIED IDEOGRAPH
    {0xCD56, 0x7091}, //6461 #CJK UNIFIED IDEOGRAPH
    {0xCD57, 0x7096}, //6462 #CJK UNIFIED IDEOGRAPH
    {0xCD58, 0x7082}, //6463 #CJK UNIFIED IDEOGRAPH
    {0xCD59, 0x709A}, //6464 #CJK UNIFIED IDEOGRAPH
    {0xCD5A, 0x7083}, //6465 #CJK UNIFIED IDEOGRAPH
    {0xCD5B, 0x726A}, //6466 #CJK UNIFIED IDEOGRAPH
    {0xCD5C, 0x72D6}, //6467 #CJK UNIFIED IDEOGRAPH
    {0xCD5D, 0x72CB}, //6468 #CJK UNIFIED IDEOGRAPH
    {0xCD5E, 0x72D8}, //6469 #CJK UNIFIED IDEOGRAPH
    {0xCD5F, 0x72C9}, //6470 #CJK UNIFIED IDEOGRAPH
    {0xCD60, 0x72DC}, //6471 #CJK UNIFIED IDEOGRAPH
    {0xCD61, 0x72D2}, //6472 #CJK UNIFIED IDEOGRAPH
    {0xCD62, 0x72D4}, //6473 #CJK UNIFIED IDEOGRAPH
    {0xCD63, 0x72DA}, //6474 #CJK UNIFIED IDEOGRAPH
    {0xCD64, 0x72CC}, //6475 #CJK UNIFIED IDEOGRAPH
    {0xCD65, 0x72D1}, //6476 #CJK UNIFIED IDEOGRAPH
    {0xCD66, 0x73A4}, //6477 #CJK UNIFIED IDEOGRAPH
    {0xCD67, 0x73A1}, //6478 #CJK UNIFIED IDEOGRAPH
    {0xCD68, 0x73AD}, //6479 #CJK UNIFIED IDEOGRAPH
    {0xCD69, 0x73A6}, //6480 #CJK UNIFIED IDEOGRAPH
    {0xCD6A, 0x73A2}, //6481 #CJK UNIFIED IDEOGRAPH
    {0xCD6B, 0x73A0}, //6482 #CJK UNIFIED IDEOGRAPH
    {0xCD6C, 0x73AC}, //6483 #CJK UNIFIED IDEOGRAPH
    {0xCD6D, 0x739D}, //6484 #CJK UNIFIED IDEOGRAPH
    {0xCD6E, 0x74DD}, //6485 #CJK UNIFIED IDEOGRAPH
    {0xCD6F, 0x74E8}, //6486 #CJK UNIFIED IDEOGRAPH
    {0xCD70, 0x753F}, //6487 #CJK UNIFIED IDEOGRAPH
    {0xCD71, 0x7540}, //6488 #CJK UNIFIED IDEOGRAPH
    {0xCD72, 0x753E}, //6489 #CJK UNIFIED IDEOGRAPH
    {0xCD73, 0x758C}, //6490 #CJK UNIFIED IDEOGRAPH
    {0xCD74, 0x7598}, //6491 #CJK UNIFIED IDEOGRAPH
    {0xCD75, 0x76AF}, //6492 #CJK UNIFIED IDEOGRAPH
    {0xCD76, 0x76F3}, //6493 #CJK UNIFIED IDEOGRAPH
    {0xCD77, 0x76F1}, //6494 #CJK UNIFIED IDEOGRAPH
    {0xCD78, 0x76F0}, //6495 #CJK UNIFIED IDEOGRAPH
    {0xCD79, 0x76F5}, //6496 #CJK UNIFIED IDEOGRAPH
    {0xCD7A, 0x77F8}, //6497 #CJK UNIFIED IDEOGRAPH
    {0xCD7B, 0x77FC}, //6498 #CJK UNIFIED IDEOGRAPH
    {0xCD7C, 0x77F9}, //6499 #CJK UNIFIED IDEOGRAPH
    {0xCD7D, 0x77FB}, //6500 #CJK UNIFIED IDEOGRAPH
    {0xCD7E, 0x77FA}, //6501 #CJK UNIFIED IDEOGRAPH
    {0xCDA1, 0x77F7}, //6502 #CJK UNIFIED IDEOGRAPH
    {0xCDA2, 0x7942}, //6503 #CJK UNIFIED IDEOGRAPH
    {0xCDA3, 0x793F}, //6504 #CJK UNIFIED IDEOGRAPH
    {0xCDA4, 0x79C5}, //6505 #CJK UNIFIED IDEOGRAPH
    {0xCDA5, 0x7A78}, //6506 #CJK UNIFIED IDEOGRAPH
    {0xCDA6, 0x7A7B}, //6507 #CJK UNIFIED IDEOGRAPH
    {0xCDA7, 0x7AFB}, //6508 #CJK UNIFIED IDEOGRAPH
    {0xCDA8, 0x7C75}, //6509 #CJK UNIFIED IDEOGRAPH
    {0xCDA9, 0x7CFD}, //6510 #CJK UNIFIED IDEOGRAPH
    {0xCDAA, 0x8035}, //6511 #CJK UNIFIED IDEOGRAPH
    {0xCDAB, 0x808F}, //6512 #CJK UNIFIED IDEOGRAPH
    {0xCDAC, 0x80AE}, //6513 #CJK UNIFIED IDEOGRAPH
    {0xCDAD, 0x80A3}, //6514 #CJK UNIFIED IDEOGRAPH
    {0xCDAE, 0x80B8}, //6515 #CJK UNIFIED IDEOGRAPH
    {0xCDAF, 0x80B5}, //6516 #CJK UNIFIED IDEOGRAPH
    {0xCDB0, 0x80AD}, //6517 #CJK UNIFIED IDEOGRAPH
    {0xCDB1, 0x8220}, //6518 #CJK UNIFIED IDEOGRAPH
    {0xCDB2, 0x82A0}, //6519 #CJK UNIFIED IDEOGRAPH
    {0xCDB3, 0x82C0}, //6520 #CJK UNIFIED IDEOGRAPH
    {0xCDB4, 0x82AB}, //6521 #CJK UNIFIED IDEOGRAPH
    {0xCDB5, 0x829A}, //6522 #CJK UNIFIED IDEOGRAPH
    {0xCDB6, 0x8298}, //6523 #CJK UNIFIED IDEOGRAPH
    {0xCDB7, 0x829B}, //6524 #CJK UNIFIED IDEOGRAPH
    {0xCDB8, 0x82B5}, //6525 #CJK UNIFIED IDEOGRAPH
    {0xCDB9, 0x82A7}, //6526 #CJK UNIFIED IDEOGRAPH
    {0xCDBA, 0x82AE}, //6527 #CJK UNIFIED IDEOGRAPH
    {0xCDBB, 0x82BC}, //6528 #CJK UNIFIED IDEOGRAPH
    {0xCDBC, 0x829E}, //6529 #CJK UNIFIED IDEOGRAPH
    {0xCDBD, 0x82BA}, //6530 #CJK UNIFIED IDEOGRAPH
    {0xCDBE, 0x82B4}, //6531 #CJK UNIFIED IDEOGRAPH
    {0xCDBF, 0x82A8}, //6532 #CJK UNIFIED IDEOGRAPH
    {0xCDC0, 0x82A1}, //6533 #CJK UNIFIED IDEOGRAPH
    {0xCDC1, 0x82A9}, //6534 #CJK UNIFIED IDEOGRAPH
    {0xCDC2, 0x82C2}, //6535 #CJK UNIFIED IDEOGRAPH
    {0xCDC3, 0x82A4}, //6536 #CJK UNIFIED IDEOGRAPH
    {0xCDC4, 0x82C3}, //6537 #CJK UNIFIED IDEOGRAPH
    {0xCDC5, 0x82B6}, //6538 #CJK UNIFIED IDEOGRAPH
    {0xCDC6, 0x82A2}, //6539 #CJK UNIFIED IDEOGRAPH
    {0xCDC7, 0x8670}, //6540 #CJK UNIFIED IDEOGRAPH
    {0xCDC8, 0x866F}, //6541 #CJK UNIFIED IDEOGRAPH
    {0xCDC9, 0x866D}, //6542 #CJK UNIFIED IDEOGRAPH
    {0xCDCA, 0x866E}, //6543 #CJK UNIFIED IDEOGRAPH
    {0xCDCB, 0x8C56}, //6544 #CJK UNIFIED IDEOGRAPH
    {0xCDCC, 0x8FD2}, //6545 #CJK UNIFIED IDEOGRAPH
    {0xCDCD, 0x8FCB}, //6546 #CJK UNIFIED IDEOGRAPH
    {0xCDCE, 0x8FD3}, //6547 #CJK UNIFIED IDEOGRAPH
    {0xCDCF, 0x8FCD}, //6548 #CJK UNIFIED IDEOGRAPH
    {0xCDD0, 0x8FD6}, //6549 #CJK UNIFIED IDEOGRAPH
    {0xCDD1, 0x8FD5}, //6550 #CJK UNIFIED IDEOGRAPH
    {0xCDD2, 0x8FD7}, //6551 #CJK UNIFIED IDEOGRAPH
    {0xCDD3, 0x90B2}, //6552 #CJK UNIFIED IDEOGRAPH
    {0xCDD4, 0x90B4}, //6553 #CJK UNIFIED IDEOGRAPH
    {0xCDD5, 0x90AF}, //6554 #CJK UNIFIED IDEOGRAPH
    {0xCDD6, 0x90B3}, //6555 #CJK UNIFIED IDEOGRAPH
    {0xCDD7, 0x90B0}, //6556 #CJK UNIFIED IDEOGRAPH
    {0xCDD8, 0x9639}, //6557 #CJK UNIFIED IDEOGRAPH
    {0xCDD9, 0x963D}, //6558 #CJK UNIFIED IDEOGRAPH
    {0xCDDA, 0x963C}, //6559 #CJK UNIFIED IDEOGRAPH
    {0xCDDB, 0x963A}, //6560 #CJK UNIFIED IDEOGRAPH
    {0xCDDC, 0x9643}, //6561 #CJK UNIFIED IDEOGRAPH
    {0xCDDD, 0x4FCD}, //6562 #CJK UNIFIED IDEOGRAPH
    {0xCDDE, 0x4FC5}, //6563 #CJK UNIFIED IDEOGRAPH
    {0xCDDF, 0x4FD3}, //6564 #CJK UNIFIED IDEOGRAPH
    {0xCDE0, 0x4FB2}, //6565 #CJK UNIFIED IDEOGRAPH
    {0xCDE1, 0x4FC9}, //6566 #CJK UNIFIED IDEOGRAPH
    {0xCDE2, 0x4FCB}, //6567 #CJK UNIFIED IDEOGRAPH
    {0xCDE3, 0x4FC1}, //6568 #CJK UNIFIED IDEOGRAPH
    {0xCDE4, 0x4FD4}, //6569 #CJK UNIFIED IDEOGRAPH
    {0xCDE5, 0x4FDC}, //6570 #CJK UNIFIED IDEOGRAPH
    {0xCDE6, 0x4FD9}, //6571 #CJK UNIFIED IDEOGRAPH
    {0xCDE7, 0x4FBB}, //6572 #CJK UNIFIED IDEOGRAPH
    {0xCDE8, 0x4FB3}, //6573 #CJK UNIFIED IDEOGRAPH
    {0xCDE9, 0x4FDB}, //6574 #CJK UNIFIED IDEOGRAPH
    {0xCDEA, 0x4FC7}, //6575 #CJK UNIFIED IDEOGRAPH
    {0xCDEB, 0x4FD6}, //6576 #CJK UNIFIED IDEOGRAPH
    {0xCDEC, 0x4FBA}, //6577 #CJK UNIFIED IDEOGRAPH
    {0xCDED, 0x4FC0}, //6578 #CJK UNIFIED IDEOGRAPH
    {0xCDEE, 0x4FB9}, //6579 #CJK UNIFIED IDEOGRAPH
    {0xCDEF, 0x4FEC}, //6580 #CJK UNIFIED IDEOGRAPH
    {0xCDF0, 0x5244}, //6581 #CJK UNIFIED IDEOGRAPH
    {0xCDF1, 0x5249}, //6582 #CJK UNIFIED IDEOGRAPH
    {0xCDF2, 0x52C0}, //6583 #CJK UNIFIED IDEOGRAPH
    {0xCDF3, 0x52C2}, //6584 #CJK UNIFIED IDEOGRAPH
    {0xCDF4, 0x533D}, //6585 #CJK UNIFIED IDEOGRAPH
    {0xCDF5, 0x537C}, //6586 #CJK UNIFIED IDEOGRAPH
    {0xCDF6, 0x5397}, //6587 #CJK UNIFIED IDEOGRAPH
    {0xCDF7, 0x5396}, //6588 #CJK UNIFIED IDEOGRAPH
    {0xCDF8, 0x5399}, //6589 #CJK UNIFIED IDEOGRAPH
    {0xCDF9, 0x5398}, //6590 #CJK UNIFIED IDEOGRAPH
    {0xCDFA, 0x54BA}, //6591 #CJK UNIFIED IDEOGRAPH
    {0xCDFB, 0x54A1}, //6592 #CJK UNIFIED IDEOGRAPH
    {0xCDFC, 0x54AD}, //6593 #CJK UNIFIED IDEOGRAPH
    {0xCDFD, 0x54A5}, //6594 #CJK UNIFIED IDEOGRAPH
    {0xCDFE, 0x54CF}, //6595 #CJK UNIFIED IDEOGRAPH
    {0xCE40, 0x54C3}, //6596 #CJK UNIFIED IDEOGRAPH
    {0xCE41, 0x830D}, //6597 #CJK UNIFIED IDEOGRAPH
    {0xCE42, 0x54B7}, //6598 #CJK UNIFIED IDEOGRAPH
    {0xCE43, 0x54AE}, //6599 #CJK UNIFIED IDEOGRAPH
    {0xCE44, 0x54D6}, //6600 #CJK UNIFIED IDEOGRAPH
    {0xCE45, 0x54B6}, //6601 #CJK UNIFIED IDEOGRAPH
    {0xCE46, 0x54C5}, //6602 #CJK UNIFIED IDEOGRAPH
    {0xCE47, 0x54C6}, //6603 #CJK UNIFIED IDEOGRAPH
    {0xCE48, 0x54A0}, //6604 #CJK UNIFIED IDEOGRAPH
    {0xCE49, 0x5470}, //6605 #CJK UNIFIED IDEOGRAPH
    {0xCE4A, 0x54BC}, //6606 #CJK UNIFIED IDEOGRAPH
    {0xCE4B, 0x54A2}, //6607 #CJK UNIFIED IDEOGRAPH
    {0xCE4C, 0x54BE}, //6608 #CJK UNIFIED IDEOGRAPH
    {0xCE4D, 0x5472}, //6609 #CJK UNIFIED IDEOGRAPH
    {0xCE4E, 0x54DE}, //6610 #CJK UNIFIED IDEOGRAPH
    {0xCE4F, 0x54B0}, //6611 #CJK UNIFIED IDEOGRAPH
    {0xCE50, 0x57B5}, //6612 #CJK UNIFIED IDEOGRAPH
    {0xCE51, 0x579E}, //6613 #CJK UNIFIED IDEOGRAPH
    {0xCE52, 0x579F}, //6614 #CJK UNIFIED IDEOGRAPH
    {0xCE53, 0x57A4}, //6615 #CJK UNIFIED IDEOGRAPH
    {0xCE54, 0x578C}, //6616 #CJK UNIFIED IDEOGRAPH
    {0xCE55, 0x5797}, //6617 #CJK UNIFIED IDEOGRAPH
    {0xCE56, 0x579D}, //6618 #CJK UNIFIED IDEOGRAPH
    {0xCE57, 0x579B}, //6619 #CJK UNIFIED IDEOGRAPH
    {0xCE58, 0x5794}, //6620 #CJK UNIFIED IDEOGRAPH
    {0xCE59, 0x5798}, //6621 #CJK UNIFIED IDEOGRAPH
    {0xCE5A, 0x578F}, //6622 #CJK UNIFIED IDEOGRAPH
    {0xCE5B, 0x5799}, //6623 #CJK UNIFIED IDEOGRAPH
    {0xCE5C, 0x57A5}, //6624 #CJK UNIFIED IDEOGRAPH
    {0xCE5D, 0x579A}, //6625 #CJK UNIFIED IDEOGRAPH
    {0xCE5E, 0x5795}, //6626 #CJK UNIFIED IDEOGRAPH
    {0xCE5F, 0x58F4}, //6627 #CJK UNIFIED IDEOGRAPH
    {0xCE60, 0x590D}, //6628 #CJK UNIFIED IDEOGRAPH
    {0xCE61, 0x5953}, //6629 #CJK UNIFIED IDEOGRAPH
    {0xCE62, 0x59E1}, //6630 #CJK UNIFIED IDEOGRAPH
    {0xCE63, 0x59DE}, //6631 #CJK UNIFIED IDEOGRAPH
    {0xCE64, 0x59EE}, //6632 #CJK UNIFIED IDEOGRAPH
    {0xCE65, 0x5A00}, //6633 #CJK UNIFIED IDEOGRAPH
    {0xCE66, 0x59F1}, //6634 #CJK UNIFIED IDEOGRAPH
    {0xCE67, 0x59DD}, //6635 #CJK UNIFIED IDEOGRAPH
    {0xCE68, 0x59FA}, //6636 #CJK UNIFIED IDEOGRAPH
    {0xCE69, 0x59FD}, //6637 #CJK UNIFIED IDEOGRAPH
    {0xCE6A, 0x59FC}, //6638 #CJK UNIFIED IDEOGRAPH
    {0xCE6B, 0x59F6}, //6639 #CJK UNIFIED IDEOGRAPH
    {0xCE6C, 0x59E4}, //6640 #CJK UNIFIED IDEOGRAPH
    {0xCE6D, 0x59F2}, //6641 #CJK UNIFIED IDEOGRAPH
    {0xCE6E, 0x59F7}, //6642 #CJK UNIFIED IDEOGRAPH
    {0xCE6F, 0x59DB}, //6643 #CJK UNIFIED IDEOGRAPH
    {0xCE70, 0x59E9}, //6644 #CJK UNIFIED IDEOGRAPH
    {0xCE71, 0x59F3}, //6645 #CJK UNIFIED IDEOGRAPH
    {0xCE72, 0x59F5}, //6646 #CJK UNIFIED IDEOGRAPH
    {0xCE73, 0x59E0}, //6647 #CJK UNIFIED IDEOGRAPH
    {0xCE74, 0x59FE}, //6648 #CJK UNIFIED IDEOGRAPH
    {0xCE75, 0x59F4}, //6649 #CJK UNIFIED IDEOGRAPH
    {0xCE76, 0x59ED}, //6650 #CJK UNIFIED IDEOGRAPH
    {0xCE77, 0x5BA8}, //6651 #CJK UNIFIED IDEOGRAPH
    {0xCE78, 0x5C4C}, //6652 #CJK UNIFIED IDEOGRAPH
    {0xCE79, 0x5CD0}, //6653 #CJK UNIFIED IDEOGRAPH
    {0xCE7A, 0x5CD8}, //6654 #CJK UNIFIED IDEOGRAPH
    {0xCE7B, 0x5CCC}, //6655 #CJK UNIFIED IDEOGRAPH
    {0xCE7C, 0x5CD7}, //6656 #CJK UNIFIED IDEOGRAPH
    {0xCE7D, 0x5CCB}, //6657 #CJK UNIFIED IDEOGRAPH
    {0xCE7E, 0x5CDB}, //6658 #CJK UNIFIED IDEOGRAPH
    {0xCEA1, 0x5CDE}, //6659 #CJK UNIFIED IDEOGRAPH
    {0xCEA2, 0x5CDA}, //6660 #CJK UNIFIED IDEOGRAPH
    {0xCEA3, 0x5CC9}, //6661 #CJK UNIFIED IDEOGRAPH
    {0xCEA4, 0x5CC7}, //6662 #CJK UNIFIED IDEOGRAPH
    {0xCEA5, 0x5CCA}, //6663 #CJK UNIFIED IDEOGRAPH
    {0xCEA6, 0x5CD6}, //6664 #CJK UNIFIED IDEOGRAPH
    {0xCEA7, 0x5CD3}, //6665 #CJK UNIFIED IDEOGRAPH
    {0xCEA8, 0x5CD4}, //6666 #CJK UNIFIED IDEOGRAPH
    {0xCEA9, 0x5CCF}, //6667 #CJK UNIFIED IDEOGRAPH
    {0xCEAA, 0x5CC8}, //6668 #CJK UNIFIED IDEOGRAPH
    {0xCEAB, 0x5CC6}, //6669 #CJK UNIFIED IDEOGRAPH
    {0xCEAC, 0x5CCE}, //6670 #CJK UNIFIED IDEOGRAPH
    {0xCEAD, 0x5CDF}, //6671 #CJK UNIFIED IDEOGRAPH
    {0xCEAE, 0x5CF8}, //6672 #CJK UNIFIED IDEOGRAPH
    {0xCEAF, 0x5DF9}, //6673 #CJK UNIFIED IDEOGRAPH
    {0xCEB0, 0x5E21}, //6674 #CJK UNIFIED IDEOGRAPH
    {0xCEB1, 0x5E22}, //6675 #CJK UNIFIED IDEOGRAPH
    {0xCEB2, 0x5E23}, //6676 #CJK UNIFIED IDEOGRAPH
    {0xCEB3, 0x5E20}, //6677 #CJK UNIFIED IDEOGRAPH
    {0xCEB4, 0x5E24}, //6678 #CJK UNIFIED IDEOGRAPH
    {0xCEB5, 0x5EB0}, //6679 #CJK UNIFIED IDEOGRAPH
    {0xCEB6, 0x5EA4}, //6680 #CJK UNIFIED IDEOGRAPH
    {0xCEB7, 0x5EA2}, //6681 #CJK UNIFIED IDEOGRAPH
    {0xCEB8, 0x5E9B}, //6682 #CJK UNIFIED IDEOGRAPH
    {0xCEB9, 0x5EA3}, //6683 #CJK UNIFIED IDEOGRAPH
    {0xCEBA, 0x5EA5}, //6684 #CJK UNIFIED IDEOGRAPH
    {0xCEBB, 0x5F07}, //6685 #CJK UNIFIED IDEOGRAPH
    {0xCEBC, 0x5F2E}, //6686 #CJK UNIFIED IDEOGRAPH
    {0xCEBD, 0x5F56}, //6687 #CJK UNIFIED IDEOGRAPH
    {0xCEBE, 0x5F86}, //6688 #CJK UNIFIED IDEOGRAPH
    {0xCEBF, 0x6037}, //6689 #CJK UNIFIED IDEOGRAPH
    {0xCEC0, 0x6039}, //6690 #CJK UNIFIED IDEOGRAPH
    {0xCEC1, 0x6054}, //6691 #CJK UNIFIED IDEOGRAPH
    {0xCEC2, 0x6072}, //6692 #CJK UNIFIED IDEOGRAPH
    {0xCEC3, 0x605E}, //6693 #CJK UNIFIED IDEOGRAPH
    {0xCEC4, 0x6045}, //6694 #CJK UNIFIED IDEOGRAPH
    {0xCEC5, 0x6053}, //6695 #CJK UNIFIED IDEOGRAPH
    {0xCEC6, 0x6047}, //6696 #CJK UNIFIED IDEOGRAPH
    {0xCEC7, 0x6049}, //6697 #CJK UNIFIED IDEOGRAPH
    {0xCEC8, 0x605B}, //6698 #CJK UNIFIED IDEOGRAPH
    {0xCEC9, 0x604C}, //6699 #CJK UNIFIED IDEOGRAPH
    {0xCECA, 0x6040}, //6700 #CJK UNIFIED IDEOGRAPH
    {0xCECB, 0x6042}, //6701 #CJK UNIFIED IDEOGRAPH
    {0xCECC, 0x605F}, //6702 #CJK UNIFIED IDEOGRAPH
    {0xCECD, 0x6024}, //6703 #CJK UNIFIED IDEOGRAPH
    {0xCECE, 0x6044}, //6704 #CJK UNIFIED IDEOGRAPH
    {0xCECF, 0x6058}, //6705 #CJK UNIFIED IDEOGRAPH
    {0xCED0, 0x6066}, //6706 #CJK UNIFIED IDEOGRAPH
    {0xCED1, 0x606E}, //6707 #CJK UNIFIED IDEOGRAPH
    {0xCED2, 0x6242}, //6708 #CJK UNIFIED IDEOGRAPH
    {0xCED3, 0x6243}, //6709 #CJK UNIFIED IDEOGRAPH
    {0xCED4, 0x62CF}, //6710 #CJK UNIFIED IDEOGRAPH
    {0xCED5, 0x630D}, //6711 #CJK UNIFIED IDEOGRAPH
    {0xCED6, 0x630B}, //6712 #CJK UNIFIED IDEOGRAPH
    {0xCED7, 0x62F5}, //6713 #CJK UNIFIED IDEOGRAPH
    {0xCED8, 0x630E}, //6714 #CJK UNIFIED IDEOGRAPH
    {0xCED9, 0x6303}, //6715 #CJK UNIFIED IDEOGRAPH
    {0xCEDA, 0x62EB}, //6716 #CJK UNIFIED IDEOGRAPH
    {0xCEDB, 0x62F9}, //6717 #CJK UNIFIED IDEOGRAPH
    {0xCEDC, 0x630F}, //6718 #CJK UNIFIED IDEOGRAPH
    {0xCEDD, 0x630C}, //6719 #CJK UNIFIED IDEOGRAPH
    {0xCEDE, 0x62F8}, //6720 #CJK UNIFIED IDEOGRAPH
    {0xCEDF, 0x62F6}, //6721 #CJK UNIFIED IDEOGRAPH
    {0xCEE0, 0x6300}, //6722 #CJK UNIFIED IDEOGRAPH
    {0xCEE1, 0x6313}, //6723 #CJK UNIFIED IDEOGRAPH
    {0xCEE2, 0x6314}, //6724 #CJK UNIFIED IDEOGRAPH
    {0xCEE3, 0x62FA}, //6725 #CJK UNIFIED IDEOGRAPH
    {0xCEE4, 0x6315}, //6726 #CJK UNIFIED IDEOGRAPH
    {0xCEE5, 0x62FB}, //6727 #CJK UNIFIED IDEOGRAPH
    {0xCEE6, 0x62F0}, //6728 #CJK UNIFIED IDEOGRAPH
    {0xCEE7, 0x6541}, //6729 #CJK UNIFIED IDEOGRAPH
    {0xCEE8, 0x6543}, //6730 #CJK UNIFIED IDEOGRAPH
    {0xCEE9, 0x65AA}, //6731 #CJK UNIFIED IDEOGRAPH
    {0xCEEA, 0x65BF}, //6732 #CJK UNIFIED IDEOGRAPH
    {0xCEEB, 0x6636}, //6733 #CJK UNIFIED IDEOGRAPH
    {0xCEEC, 0x6621}, //6734 #CJK UNIFIED IDEOGRAPH
    {0xCEED, 0x6632}, //6735 #CJK UNIFIED IDEOGRAPH
    {0xCEEE, 0x6635}, //6736 #CJK UNIFIED IDEOGRAPH
    {0xCEEF, 0x661C}, //6737 #CJK UNIFIED IDEOGRAPH
    {0xCEF0, 0x6626}, //6738 #CJK UNIFIED IDEOGRAPH
    {0xCEF1, 0x6622}, //6739 #CJK UNIFIED IDEOGRAPH
    {0xCEF2, 0x6633}, //6740 #CJK UNIFIED IDEOGRAPH
    {0xCEF3, 0x662B}, //6741 #CJK UNIFIED IDEOGRAPH
    {0xCEF4, 0x663A}, //6742 #CJK UNIFIED IDEOGRAPH
    {0xCEF5, 0x661D}, //6743 #CJK UNIFIED IDEOGRAPH
    {0xCEF6, 0x6634}, //6744 #CJK UNIFIED IDEOGRAPH
    {0xCEF7, 0x6639}, //6745 #CJK UNIFIED IDEOGRAPH
    {0xCEF8, 0x662E}, //6746 #CJK UNIFIED IDEOGRAPH
    {0xCEF9, 0x670F}, //6747 #CJK UNIFIED IDEOGRAPH
    {0xCEFA, 0x6710}, //6748 #CJK UNIFIED IDEOGRAPH
    {0xCEFB, 0x67C1}, //6749 #CJK UNIFIED IDEOGRAPH
    {0xCEFC, 0x67F2}, //6750 #CJK UNIFIED IDEOGRAPH
    {0xCEFD, 0x67C8}, //6751 #CJK UNIFIED IDEOGRAPH
    {0xCEFE, 0x67BA}, //6752 #CJK UNIFIED IDEOGRAPH
    {0xCF40, 0x67DC}, //6753 #CJK UNIFIED IDEOGRAPH
    {0xCF41, 0x67BB}, //6754 #CJK UNIFIED IDEOGRAPH
    {0xCF42, 0x67F8}, //6755 #CJK UNIFIED IDEOGRAPH
    {0xCF43, 0x67D8}, //6756 #CJK UNIFIED IDEOGRAPH
    {0xCF44, 0x67C0}, //6757 #CJK UNIFIED IDEOGRAPH
    {0xCF45, 0x67B7}, //6758 #CJK UNIFIED IDEOGRAPH
    {0xCF46, 0x67C5}, //6759 #CJK UNIFIED IDEOGRAPH
    {0xCF47, 0x67EB}, //6760 #CJK UNIFIED IDEOGRAPH
    {0xCF48, 0x67E4}, //6761 #CJK UNIFIED IDEOGRAPH
    {0xCF49, 0x67DF}, //6762 #CJK UNIFIED IDEOGRAPH
    {0xCF4A, 0x67B5}, //6763 #CJK UNIFIED IDEOGRAPH
    {0xCF4B, 0x67CD}, //6764 #CJK UNIFIED IDEOGRAPH
    {0xCF4C, 0x67B3}, //6765 #CJK UNIFIED IDEOGRAPH
    {0xCF4D, 0x67F7}, //6766 #CJK UNIFIED IDEOGRAPH
    {0xCF4E, 0x67F6}, //6767 #CJK UNIFIED IDEOGRAPH
    {0xCF4F, 0x67EE}, //6768 #CJK UNIFIED IDEOGRAPH
    {0xCF50, 0x67E3}, //6769 #CJK UNIFIED IDEOGRAPH
    {0xCF51, 0x67C2}, //6770 #CJK UNIFIED IDEOGRAPH
    {0xCF52, 0x67B9}, //6771 #CJK UNIFIED IDEOGRAPH
    {0xCF53, 0x67CE}, //6772 #CJK UNIFIED IDEOGRAPH
    {0xCF54, 0x67E7}, //6773 #CJK UNIFIED IDEOGRAPH
    {0xCF55, 0x67F0}, //6774 #CJK UNIFIED IDEOGRAPH
    {0xCF56, 0x67B2}, //6775 #CJK UNIFIED IDEOGRAPH
    {0xCF57, 0x67FC}, //6776 #CJK UNIFIED IDEOGRAPH
    {0xCF58, 0x67C6}, //6777 #CJK UNIFIED IDEOGRAPH
    {0xCF59, 0x67ED}, //6778 #CJK UNIFIED IDEOGRAPH
    {0xCF5A, 0x67CC}, //6779 #CJK UNIFIED IDEOGRAPH
    {0xCF5B, 0x67AE}, //6780 #CJK UNIFIED IDEOGRAPH
    {0xCF5C, 0x67E6}, //6781 #CJK UNIFIED IDEOGRAPH
    {0xCF5D, 0x67DB}, //6782 #CJK UNIFIED IDEOGRAPH
    {0xCF5E, 0x67FA}, //6783 #CJK UNIFIED IDEOGRAPH
    {0xCF5F, 0x67C9}, //6784 #CJK UNIFIED IDEOGRAPH
    {0xCF60, 0x67CA}, //6785 #CJK UNIFIED IDEOGRAPH
    {0xCF61, 0x67C3}, //6786 #CJK UNIFIED IDEOGRAPH
    {0xCF62, 0x67EA}, //6787 #CJK UNIFIED IDEOGRAPH
    {0xCF63, 0x67CB}, //6788 #CJK UNIFIED IDEOGRAPH
    {0xCF64, 0x6B28}, //6789 #CJK UNIFIED IDEOGRAPH
    {0xCF65, 0x6B82}, //6790 #CJK UNIFIED IDEOGRAPH
    {0xCF66, 0x6B84}, //6791 #CJK UNIFIED IDEOGRAPH
    {0xCF67, 0x6BB6}, //6792 #CJK UNIFIED IDEOGRAPH
    {0xCF68, 0x6BD6}, //6793 #CJK UNIFIED IDEOGRAPH
    {0xCF69, 0x6BD8}, //6794 #CJK UNIFIED IDEOGRAPH
    {0xCF6A, 0x6BE0}, //6795 #CJK UNIFIED IDEOGRAPH
    {0xCF6B, 0x6C20}, //6796 #CJK UNIFIED IDEOGRAPH
    {0xCF6C, 0x6C21}, //6797 #CJK UNIFIED IDEOGRAPH
    {0xCF6D, 0x6D28}, //6798 #CJK UNIFIED IDEOGRAPH
    {0xCF6E, 0x6D34}, //6799 #CJK UNIFIED IDEOGRAPH
    {0xCF6F, 0x6D2D}, //6800 #CJK UNIFIED IDEOGRAPH
    {0xCF70, 0x6D1F}, //6801 #CJK UNIFIED IDEOGRAPH
    {0xCF71, 0x6D3C}, //6802 #CJK UNIFIED IDEOGRAPH
    {0xCF72, 0x6D3F}, //6803 #CJK UNIFIED IDEOGRAPH
    {0xCF73, 0x6D12}, //6804 #CJK UNIFIED IDEOGRAPH
    {0xCF74, 0x6D0A}, //6805 #CJK UNIFIED IDEOGRAPH
    {0xCF75, 0x6CDA}, //6806 #CJK UNIFIED IDEOGRAPH
    {0xCF76, 0x6D33}, //6807 #CJK UNIFIED IDEOGRAPH
    {0xCF77, 0x6D04}, //6808 #CJK UNIFIED IDEOGRAPH
    {0xCF78, 0x6D19}, //6809 #CJK UNIFIED IDEOGRAPH
    {0xCF79, 0x6D3A}, //6810 #CJK UNIFIED IDEOGRAPH
    {0xCF7A, 0x6D1A}, //6811 #CJK UNIFIED IDEOGRAPH
    {0xCF7B, 0x6D11}, //6812 #CJK UNIFIED IDEOGRAPH
    {0xCF7C, 0x6D00}, //6813 #CJK UNIFIED IDEOGRAPH
    {0xCF7D, 0x6D1D}, //6814 #CJK UNIFIED IDEOGRAPH
    {0xCF7E, 0x6D42}, //6815 #CJK UNIFIED IDEOGRAPH
    {0xCFA1, 0x6D01}, //6816 #CJK UNIFIED IDEOGRAPH
    {0xCFA2, 0x6D18}, //6817 #CJK UNIFIED IDEOGRAPH
    {0xCFA3, 0x6D37}, //6818 #CJK UNIFIED IDEOGRAPH
    {0xCFA4, 0x6D03}, //6819 #CJK UNIFIED IDEOGRAPH
    {0xCFA5, 0x6D0F}, //6820 #CJK UNIFIED IDEOGRAPH
    {0xCFA6, 0x6D40}, //6821 #CJK UNIFIED IDEOGRAPH
    {0xCFA7, 0x6D07}, //6822 #CJK UNIFIED IDEOGRAPH
    {0xCFA8, 0x6D20}, //6823 #CJK UNIFIED IDEOGRAPH
    {0xCFA9, 0x6D2C}, //6824 #CJK UNIFIED IDEOGRAPH
    {0xCFAA, 0x6D08}, //6825 #CJK UNIFIED IDEOGRAPH
    {0xCFAB, 0x6D22}, //6826 #CJK UNIFIED IDEOGRAPH
    {0xCFAC, 0x6D09}, //6827 #CJK UNIFIED IDEOGRAPH
    {0xCFAD, 0x6D10}, //6828 #CJK UNIFIED IDEOGRAPH
    {0xCFAE, 0x70B7}, //6829 #CJK UNIFIED IDEOGRAPH
    {0xCFAF, 0x709F}, //6830 #CJK UNIFIED IDEOGRAPH
    {0xCFB0, 0x70BE}, //6831 #CJK UNIFIED IDEOGRAPH
    {0xCFB1, 0x70B1}, //6832 #CJK UNIFIED IDEOGRAPH
    {0xCFB2, 0x70B0}, //6833 #CJK UNIFIED IDEOGRAPH
    {0xCFB3, 0x70A1}, //6834 #CJK UNIFIED IDEOGRAPH
    {0xCFB4, 0x70B4}, //6835 #CJK UNIFIED IDEOGRAPH
    {0xCFB5, 0x70B5}, //6836 #CJK UNIFIED IDEOGRAPH
    {0xCFB6, 0x70A9}, //6837 #CJK UNIFIED IDEOGRAPH
    {0xCFB7, 0x7241}, //6838 #CJK UNIFIED IDEOGRAPH
    {0xCFB8, 0x7249}, //6839 #CJK UNIFIED IDEOGRAPH
    {0xCFB9, 0x724A}, //6840 #CJK UNIFIED IDEOGRAPH
    {0xCFBA, 0x726C}, //6841 #CJK UNIFIED IDEOGRAPH
    {0xCFBB, 0x7270}, //6842 #CJK UNIFIED IDEOGRAPH
    {0xCFBC, 0x7273}, //6843 #CJK UNIFIED IDEOGRAPH
    {0xCFBD, 0x726E}, //6844 #CJK UNIFIED IDEOGRAPH
    {0xCFBE, 0x72CA}, //6845 #CJK UNIFIED IDEOGRAPH
    {0xCFBF, 0x72E4}, //6846 #CJK UNIFIED IDEOGRAPH
    {0xCFC0, 0x72E8}, //6847 #CJK UNIFIED IDEOGRAPH
    {0xCFC1, 0x72EB}, //6848 #CJK UNIFIED IDEOGRAPH
    {0xCFC2, 0x72DF}, //6849 #CJK UNIFIED IDEOGRAPH
    {0xCFC3, 0x72EA}, //6850 #CJK UNIFIED IDEOGRAPH
    {0xCFC4, 0x72E6}, //6851 #CJK UNIFIED IDEOGRAPH
    {0xCFC5, 0x72E3}, //6852 #CJK UNIFIED IDEOGRAPH
    {0xCFC6, 0x7385}, //6853 #CJK UNIFIED IDEOGRAPH
    {0xCFC7, 0x73CC}, //6854 #CJK UNIFIED IDEOGRAPH
    {0xCFC8, 0x73C2}, //6855 #CJK UNIFIED IDEOGRAPH
    {0xCFC9, 0x73C8}, //6856 #CJK UNIFIED IDEOGRAPH
    {0xCFCA, 0x73C5}, //6857 #CJK UNIFIED IDEOGRAPH
    {0xCFCB, 0x73B9}, //6858 #CJK UNIFIED IDEOGRAPH
    {0xCFCC, 0x73B6}, //6859 #CJK UNIFIED IDEOGRAPH
    {0xCFCD, 0x73B5}, //6860 #CJK UNIFIED IDEOGRAPH
    {0xCFCE, 0x73B4}, //6861 #CJK UNIFIED IDEOGRAPH
    {0xCFCF, 0x73EB}, //6862 #CJK UNIFIED IDEOGRAPH
    {0xCFD0, 0x73BF}, //6863 #CJK UNIFIED IDEOGRAPH
    {0xCFD1, 0x73C7}, //6864 #CJK UNIFIED IDEOGRAPH
    {0xCFD2, 0x73BE}, //6865 #CJK UNIFIED IDEOGRAPH
    {0xCFD3, 0x73C3}, //6866 #CJK UNIFIED IDEOGRAPH
    {0xCFD4, 0x73C6}, //6867 #CJK UNIFIED IDEOGRAPH
    {0xCFD5, 0x73B8}, //6868 #CJK UNIFIED IDEOGRAPH
    {0xCFD6, 0x73CB}, //6869 #CJK UNIFIED IDEOGRAPH
    {0xCFD7, 0x74EC}, //6870 #CJK UNIFIED IDEOGRAPH
    {0xCFD8, 0x74EE}, //6871 #CJK UNIFIED IDEOGRAPH
    {0xCFD9, 0x752E}, //6872 #CJK UNIFIED IDEOGRAPH
    {0xCFDA, 0x7547}, //6873 #CJK UNIFIED IDEOGRAPH
    {0xCFDB, 0x7548}, //6874 #CJK UNIFIED IDEOGRAPH
    {0xCFDC, 0x75A7}, //6875 #CJK UNIFIED IDEOGRAPH
    {0xCFDD, 0x75AA}, //6876 #CJK UNIFIED IDEOGRAPH
    {0xCFDE, 0x7679}, //6877 #CJK UNIFIED IDEOGRAPH
    {0xCFDF, 0x76C4}, //6878 #CJK UNIFIED IDEOGRAPH
    {0xCFE0, 0x7708}, //6879 #CJK UNIFIED IDEOGRAPH
    {0xCFE1, 0x7703}, //6880 #CJK UNIFIED IDEOGRAPH
    {0xCFE2, 0x7704}, //6881 #CJK UNIFIED IDEOGRAPH
    {0xCFE3, 0x7705}, //6882 #CJK UNIFIED IDEOGRAPH
    {0xCFE4, 0x770A}, //6883 #CJK UNIFIED IDEOGRAPH
    {0xCFE5, 0x76F7}, //6884 #CJK UNIFIED IDEOGRAPH
    {0xCFE6, 0x76FB}, //6885 #CJK UNIFIED IDEOGRAPH
    {0xCFE7, 0x76FA}, //6886 #CJK UNIFIED IDEOGRAPH
    {0xCFE8, 0x77E7}, //6887 #CJK UNIFIED IDEOGRAPH
    {0xCFE9, 0x77E8}, //6888 #CJK UNIFIED IDEOGRAPH
    {0xCFEA, 0x7806}, //6889 #CJK UNIFIED IDEOGRAPH
    {0xCFEB, 0x7811}, //6890 #CJK UNIFIED IDEOGRAPH
    {0xCFEC, 0x7812}, //6891 #CJK UNIFIED IDEOGRAPH
    {0xCFED, 0x7805}, //6892 #CJK UNIFIED IDEOGRAPH
    {0xCFEE, 0x7810}, //6893 #CJK UNIFIED IDEOGRAPH
    {0xCFEF, 0x780F}, //6894 #CJK UNIFIED IDEOGRAPH
    {0xCFF0, 0x780E}, //6895 #CJK UNIFIED IDEOGRAPH
    {0xCFF1, 0x7809}, //6896 #CJK UNIFIED IDEOGRAPH
    {0xCFF2, 0x7803}, //6897 #CJK UNIFIED IDEOGRAPH
    {0xCFF3, 0x7813}, //6898 #CJK UNIFIED IDEOGRAPH
    {0xCFF4, 0x794A}, //6899 #CJK UNIFIED IDEOGRAPH
    {0xCFF5, 0x794C}, //6900 #CJK UNIFIED IDEOGRAPH
    {0xCFF6, 0x794B}, //6901 #CJK UNIFIED IDEOGRAPH
    {0xCFF7, 0x7945}, //6902 #CJK UNIFIED IDEOGRAPH
    {0xCFF8, 0x7944}, //6903 #CJK UNIFIED IDEOGRAPH
    {0xCFF9, 0x79D5}, //6904 #CJK UNIFIED IDEOGRAPH
    {0xCFFA, 0x79CD}, //6905 #CJK UNIFIED IDEOGRAPH
    {0xCFFB, 0x79CF}, //6906 #CJK UNIFIED IDEOGRAPH
    {0xCFFC, 0x79D6}, //6907 #CJK UNIFIED IDEOGRAPH
    {0xCFFD, 0x79CE}, //6908 #CJK UNIFIED IDEOGRAPH
    {0xCFFE, 0x7A80}, //6909 #CJK UNIFIED IDEOGRAPH
    {0xD040, 0x7A7E}, //6910 #CJK UNIFIED IDEOGRAPH
    {0xD041, 0x7AD1}, //6911 #CJK UNIFIED IDEOGRAPH
    {0xD042, 0x7B00}, //6912 #CJK UNIFIED IDEOGRAPH
    {0xD043, 0x7B01}, //6913 #CJK UNIFIED IDEOGRAPH
    {0xD044, 0x7C7A}, //6914 #CJK UNIFIED IDEOGRAPH
    {0xD045, 0x7C78}, //6915 #CJK UNIFIED IDEOGRAPH
    {0xD046, 0x7C79}, //6916 #CJK UNIFIED IDEOGRAPH
    {0xD047, 0x7C7F}, //6917 #CJK UNIFIED IDEOGRAPH
    {0xD048, 0x7C80}, //6918 #CJK UNIFIED IDEOGRAPH
    {0xD049, 0x7C81}, //6919 #CJK UNIFIED IDEOGRAPH
    {0xD04A, 0x7D03}, //6920 #CJK UNIFIED IDEOGRAPH
    {0xD04B, 0x7D08}, //6921 #CJK UNIFIED IDEOGRAPH
    {0xD04C, 0x7D01}, //6922 #CJK UNIFIED IDEOGRAPH
    {0xD04D, 0x7F58}, //6923 #CJK UNIFIED IDEOGRAPH
    {0xD04E, 0x7F91}, //6924 #CJK UNIFIED IDEOGRAPH
    {0xD04F, 0x7F8D}, //6925 #CJK UNIFIED IDEOGRAPH
    {0xD050, 0x7FBE}, //6926 #CJK UNIFIED IDEOGRAPH
    {0xD051, 0x8007}, //6927 #CJK UNIFIED IDEOGRAPH
    {0xD052, 0x800E}, //6928 #CJK UNIFIED IDEOGRAPH
    {0xD053, 0x800F}, //6929 #CJK UNIFIED IDEOGRAPH
    {0xD054, 0x8014}, //6930 #CJK UNIFIED IDEOGRAPH
    {0xD055, 0x8037}, //6931 #CJK UNIFIED IDEOGRAPH
    {0xD056, 0x80D8}, //6932 #CJK UNIFIED IDEOGRAPH
    {0xD057, 0x80C7}, //6933 #CJK UNIFIED IDEOGRAPH
    {0xD058, 0x80E0}, //6934 #CJK UNIFIED IDEOGRAPH
    {0xD059, 0x80D1}, //6935 #CJK UNIFIED IDEOGRAPH
    {0xD05A, 0x80C8}, //6936 #CJK UNIFIED IDEOGRAPH
    {0xD05B, 0x80C2}, //6937 #CJK UNIFIED IDEOGRAPH
    {0xD05C, 0x80D0}, //6938 #CJK UNIFIED IDEOGRAPH
    {0xD05D, 0x80C5}, //6939 #CJK UNIFIED IDEOGRAPH
    {0xD05E, 0x80E3}, //6940 #CJK UNIFIED IDEOGRAPH
    {0xD05F, 0x80D9}, //6941 #CJK UNIFIED IDEOGRAPH
    {0xD060, 0x80DC}, //6942 #CJK UNIFIED IDEOGRAPH
    {0xD061, 0x80CA}, //6943 #CJK UNIFIED IDEOGRAPH
    {0xD062, 0x80D5}, //6944 #CJK UNIFIED IDEOGRAPH
    {0xD063, 0x80C9}, //6945 #CJK UNIFIED IDEOGRAPH
    {0xD064, 0x80CF}, //6946 #CJK UNIFIED IDEOGRAPH
    {0xD065, 0x80D7}, //6947 #CJK UNIFIED IDEOGRAPH
    {0xD066, 0x80E6}, //6948 #CJK UNIFIED IDEOGRAPH
    {0xD067, 0x80CD}, //6949 #CJK UNIFIED IDEOGRAPH
    {0xD068, 0x81FF}, //6950 #CJK UNIFIED IDEOGRAPH
    {0xD069, 0x8221}, //6951 #CJK UNIFIED IDEOGRAPH
    {0xD06A, 0x8294}, //6952 #CJK UNIFIED IDEOGRAPH
    {0xD06B, 0x82D9}, //6953 #CJK UNIFIED IDEOGRAPH
    {0xD06C, 0x82FE}, //6954 #CJK UNIFIED IDEOGRAPH
    {0xD06D, 0x82F9}, //6955 #CJK UNIFIED IDEOGRAPH
    {0xD06E, 0x8307}, //6956 #CJK UNIFIED IDEOGRAPH
    {0xD06F, 0x82E8}, //6957 #CJK UNIFIED IDEOGRAPH
    {0xD070, 0x8300}, //6958 #CJK UNIFIED IDEOGRAPH
    {0xD071, 0x82D5}, //6959 #CJK UNIFIED IDEOGRAPH
    {0xD072, 0x833A}, //6960 #CJK UNIFIED IDEOGRAPH
    {0xD073, 0x82EB}, //6961 #CJK UNIFIED IDEOGRAPH
    {0xD074, 0x82D6}, //6962 #CJK UNIFIED IDEOGRAPH
    {0xD075, 0x82F4}, //6963 #CJK UNIFIED IDEOGRAPH
    {0xD076, 0x82EC}, //6964 #CJK UNIFIED IDEOGRAPH
    {0xD077, 0x82E1}, //6965 #CJK UNIFIED IDEOGRAPH
    {0xD078, 0x82F2}, //6966 #CJK UNIFIED IDEOGRAPH
    {0xD079, 0x82F5}, //6967 #CJK UNIFIED IDEOGRAPH
    {0xD07A, 0x830C}, //6968 #CJK UNIFIED IDEOGRAPH
    {0xD07B, 0x82FB}, //6969 #CJK UNIFIED IDEOGRAPH
    {0xD07C, 0x82F6}, //6970 #CJK UNIFIED IDEOGRAPH
    {0xD07D, 0x82F0}, //6971 #CJK UNIFIED IDEOGRAPH
    {0xD07E, 0x82EA}, //6972 #CJK UNIFIED IDEOGRAPH
    {0xD0A1, 0x82E4}, //6973 #CJK UNIFIED IDEOGRAPH
    {0xD0A2, 0x82E0}, //6974 #CJK UNIFIED IDEOGRAPH
    {0xD0A3, 0x82FA}, //6975 #CJK UNIFIED IDEOGRAPH
    {0xD0A4, 0x82F3}, //6976 #CJK UNIFIED IDEOGRAPH
    {0xD0A5, 0x82ED}, //6977 #CJK UNIFIED IDEOGRAPH
    {0xD0A6, 0x8677}, //6978 #CJK UNIFIED IDEOGRAPH
    {0xD0A7, 0x8674}, //6979 #CJK UNIFIED IDEOGRAPH
    {0xD0A8, 0x867C}, //6980 #CJK UNIFIED IDEOGRAPH
    {0xD0A9, 0x8673}, //6981 #CJK UNIFIED IDEOGRAPH
    {0xD0AA, 0x8841}, //6982 #CJK UNIFIED IDEOGRAPH
    {0xD0AB, 0x884E}, //6983 #CJK UNIFIED IDEOGRAPH
    {0xD0AC, 0x8867}, //6984 #CJK UNIFIED IDEOGRAPH
    {0xD0AD, 0x886A}, //6985 #CJK UNIFIED IDEOGRAPH
    {0xD0AE, 0x8869}, //6986 #CJK UNIFIED IDEOGRAPH
    {0xD0AF, 0x89D3}, //6987 #CJK UNIFIED IDEOGRAPH
    {0xD0B0, 0x8A04}, //6988 #CJK UNIFIED IDEOGRAPH
    {0xD0B1, 0x8A07}, //6989 #CJK UNIFIED IDEOGRAPH
    {0xD0B2, 0x8D72}, //6990 #CJK UNIFIED IDEOGRAPH
    {0xD0B3, 0x8FE3}, //6991 #CJK UNIFIED IDEOGRAPH
    {0xD0B4, 0x8FE1}, //6992 #CJK UNIFIED IDEOGRAPH
    {0xD0B5, 0x8FEE}, //6993 #CJK UNIFIED IDEOGRAPH
    {0xD0B6, 0x8FE0}, //6994 #CJK UNIFIED IDEOGRAPH
    {0xD0B7, 0x90F1}, //6995 #CJK UNIFIED IDEOGRAPH
    {0xD0B8, 0x90BD}, //6996 #CJK UNIFIED IDEOGRAPH
    {0xD0B9, 0x90BF}, //6997 #CJK UNIFIED IDEOGRAPH
    {0xD0BA, 0x90D5}, //6998 #CJK UNIFIED IDEOGRAPH
    {0xD0BB, 0x90C5}, //6999 #CJK UNIFIED IDEOGRAPH
    {0xD0BC, 0x90BE}, //7000 #CJK UNIFIED IDEOGRAPH
    {0xD0BD, 0x90C7}, //7001 #CJK UNIFIED IDEOGRAPH
    {0xD0BE, 0x90CB}, //7002 #CJK UNIFIED IDEOGRAPH
    {0xD0BF, 0x90C8}, //7003 #CJK UNIFIED IDEOGRAPH
    {0xD0C0, 0x91D4}, //7004 #CJK UNIFIED IDEOGRAPH
    {0xD0C1, 0x91D3}, //7005 #CJK UNIFIED IDEOGRAPH
    {0xD0C2, 0x9654}, //7006 #CJK UNIFIED IDEOGRAPH
    {0xD0C3, 0x964F}, //7007 #CJK UNIFIED IDEOGRAPH
    {0xD0C4, 0x9651}, //7008 #CJK UNIFIED IDEOGRAPH
    {0xD0C5, 0x9653}, //7009 #CJK UNIFIED IDEOGRAPH
    {0xD0C6, 0x964A}, //7010 #CJK UNIFIED IDEOGRAPH
    {0xD0C7, 0x964E}, //7011 #CJK UNIFIED IDEOGRAPH
    {0xD0C8, 0x501E}, //7012 #CJK UNIFIED IDEOGRAPH
    {0xD0C9, 0x5005}, //7013 #CJK UNIFIED IDEOGRAPH
    {0xD0CA, 0x5007}, //7014 #CJK UNIFIED IDEOGRAPH
    {0xD0CB, 0x5013}, //7015 #CJK UNIFIED IDEOGRAPH
    {0xD0CC, 0x5022}, //7016 #CJK UNIFIED IDEOGRAPH
    {0xD0CD, 0x5030}, //7017 #CJK UNIFIED IDEOGRAPH
    {0xD0CE, 0x501B}, //7018 #CJK UNIFIED IDEOGRAPH
    {0xD0CF, 0x4FF5}, //7019 #CJK UNIFIED IDEOGRAPH
    {0xD0D0, 0x4FF4}, //7020 #CJK UNIFIED IDEOGRAPH
    {0xD0D1, 0x5033}, //7021 #CJK UNIFIED IDEOGRAPH
    {0xD0D2, 0x5037}, //7022 #CJK UNIFIED IDEOGRAPH
    {0xD0D3, 0x502C}, //7023 #CJK UNIFIED IDEOGRAPH
    {0xD0D4, 0x4FF6}, //7024 #CJK UNIFIED IDEOGRAPH
    {0xD0D5, 0x4FF7}, //7025 #CJK UNIFIED IDEOGRAPH
    {0xD0D6, 0x5017}, //7026 #CJK UNIFIED IDEOGRAPH
    {0xD0D7, 0x501C}, //7027 #CJK UNIFIED IDEOGRAPH
    {0xD0D8, 0x5020}, //7028 #CJK UNIFIED IDEOGRAPH
    {0xD0D9, 0x5027}, //7029 #CJK UNIFIED IDEOGRAPH
    {0xD0DA, 0x5035}, //7030 #CJK UNIFIED IDEOGRAPH
    {0xD0DB, 0x502F}, //7031 #CJK UNIFIED IDEOGRAPH
    {0xD0DC, 0x5031}, //7032 #CJK UNIFIED IDEOGRAPH
    {0xD0DD, 0x500E}, //7033 #CJK UNIFIED IDEOGRAPH
    {0xD0DE, 0x515A}, //7034 #CJK UNIFIED IDEOGRAPH
    {0xD0DF, 0x5194}, //7035 #CJK UNIFIED IDEOGRAPH
    {0xD0E0, 0x5193}, //7036 #CJK UNIFIED IDEOGRAPH
    {0xD0E1, 0x51CA}, //7037 #CJK UNIFIED IDEOGRAPH
    {0xD0E2, 0x51C4}, //7038 #CJK UNIFIED IDEOGRAPH
    {0xD0E3, 0x51C5}, //7039 #CJK UNIFIED IDEOGRAPH
    {0xD0E4, 0x51C8}, //7040 #CJK UNIFIED IDEOGRAPH
    {0xD0E5, 0x51CE}, //7041 #CJK UNIFIED IDEOGRAPH
    {0xD0E6, 0x5261}, //7042 #CJK UNIFIED IDEOGRAPH
    {0xD0E7, 0x525A}, //7043 #CJK UNIFIED IDEOGRAPH
    {0xD0E8, 0x5252}, //7044 #CJK UNIFIED IDEOGRAPH
    {0xD0E9, 0x525E}, //7045 #CJK UNIFIED IDEOGRAPH
    {0xD0EA, 0x525F}, //7046 #CJK UNIFIED IDEOGRAPH
    {0xD0EB, 0x5255}, //7047 #CJK UNIFIED IDEOGRAPH
    {0xD0EC, 0x5262}, //7048 #CJK UNIFIED IDEOGRAPH
    {0xD0ED, 0x52CD}, //7049 #CJK UNIFIED IDEOGRAPH
    {0xD0EE, 0x530E}, //7050 #CJK UNIFIED IDEOGRAPH
    {0xD0EF, 0x539E}, //7051 #CJK UNIFIED IDEOGRAPH
    {0xD0F0, 0x5526}, //7052 #CJK UNIFIED IDEOGRAPH
    {0xD0F1, 0x54E2}, //7053 #CJK UNIFIED IDEOGRAPH
    {0xD0F2, 0x5517}, //7054 #CJK UNIFIED IDEOGRAPH
    {0xD0F3, 0x5512}, //7055 #CJK UNIFIED IDEOGRAPH
    {0xD0F4, 0x54E7}, //7056 #CJK UNIFIED IDEOGRAPH
    {0xD0F5, 0x54F3}, //7057 #CJK UNIFIED IDEOGRAPH
    {0xD0F6, 0x54E4}, //7058 #CJK UNIFIED IDEOGRAPH
    {0xD0F7, 0x551A}, //7059 #CJK UNIFIED IDEOGRAPH
    {0xD0F8, 0x54FF}, //7060 #CJK UNIFIED IDEOGRAPH
    {0xD0F9, 0x5504}, //7061 #CJK UNIFIED IDEOGRAPH
    {0xD0FA, 0x5508}, //7062 #CJK UNIFIED IDEOGRAPH
    {0xD0FB, 0x54EB}, //7063 #CJK UNIFIED IDEOGRAPH
    {0xD0FC, 0x5511}, //7064 #CJK UNIFIED IDEOGRAPH
    {0xD0FD, 0x5505}, //7065 #CJK UNIFIED IDEOGRAPH
    {0xD0FE, 0x54F1}, //7066 #CJK UNIFIED IDEOGRAPH
    {0xD140, 0x550A}, //7067 #CJK UNIFIED IDEOGRAPH
    {0xD141, 0x54FB}, //7068 #CJK UNIFIED IDEOGRAPH
    {0xD142, 0x54F7}, //7069 #CJK UNIFIED IDEOGRAPH
    {0xD143, 0x54F8}, //7070 #CJK UNIFIED IDEOGRAPH
    {0xD144, 0x54E0}, //7071 #CJK UNIFIED IDEOGRAPH
    {0xD145, 0x550E}, //7072 #CJK UNIFIED IDEOGRAPH
    {0xD146, 0x5503}, //7073 #CJK UNIFIED IDEOGRAPH
    {0xD147, 0x550B}, //7074 #CJK UNIFIED IDEOGRAPH
    {0xD148, 0x5701}, //7075 #CJK UNIFIED IDEOGRAPH
    {0xD149, 0x5702}, //7076 #CJK UNIFIED IDEOGRAPH
    {0xD14A, 0x57CC}, //7077 #CJK UNIFIED IDEOGRAPH
    {0xD14B, 0x5832}, //7078 #CJK UNIFIED IDEOGRAPH
    {0xD14C, 0x57D5}, //7079 #CJK UNIFIED IDEOGRAPH
    {0xD14D, 0x57D2}, //7080 #CJK UNIFIED IDEOGRAPH
    {0xD14E, 0x57BA}, //7081 #CJK UNIFIED IDEOGRAPH
    {0xD14F, 0x57C6}, //7082 #CJK UNIFIED IDEOGRAPH
    {0xD150, 0x57BD}, //7083 #CJK UNIFIED IDEOGRAPH
    {0xD151, 0x57BC}, //7084 #CJK UNIFIED IDEOGRAPH
    {0xD152, 0x57B8}, //7085 #CJK UNIFIED IDEOGRAPH
    {0xD153, 0x57B6}, //7086 #CJK UNIFIED IDEOGRAPH
    {0xD154, 0x57BF}, //7087 #CJK UNIFIED IDEOGRAPH
    {0xD155, 0x57C7}, //7088 #CJK UNIFIED IDEOGRAPH
    {0xD156, 0x57D0}, //7089 #CJK UNIFIED IDEOGRAPH
    {0xD157, 0x57B9}, //7090 #CJK UNIFIED IDEOGRAPH
    {0xD158, 0x57C1}, //7091 #CJK UNIFIED IDEOGRAPH
    {0xD159, 0x590E}, //7092 #CJK UNIFIED IDEOGRAPH
    {0xD15A, 0x594A}, //7093 #CJK UNIFIED IDEOGRAPH
    {0xD15B, 0x5A19}, //7094 #CJK UNIFIED IDEOGRAPH
    {0xD15C, 0x5A16}, //7095 #CJK UNIFIED IDEOGRAPH
    {0xD15D, 0x5A2D}, //7096 #CJK UNIFIED IDEOGRAPH
    {0xD15E, 0x5A2E}, //7097 #CJK UNIFIED IDEOGRAPH
    {0xD15F, 0x5A15}, //7098 #CJK UNIFIED IDEOGRAPH
    {0xD160, 0x5A0F}, //7099 #CJK UNIFIED IDEOGRAPH
    {0xD161, 0x5A17}, //7100 #CJK UNIFIED IDEOGRAPH
    {0xD162, 0x5A0A}, //7101 #CJK UNIFIED IDEOGRAPH
    {0xD163, 0x5A1E}, //7102 #CJK UNIFIED IDEOGRAPH
    {0xD164, 0x5A33}, //7103 #CJK UNIFIED IDEOGRAPH
    {0xD165, 0x5B6C}, //7104 #CJK UNIFIED IDEOGRAPH
    {0xD166, 0x5BA7}, //7105 #CJK UNIFIED IDEOGRAPH
    {0xD167, 0x5BAD}, //7106 #CJK UNIFIED IDEOGRAPH
    {0xD168, 0x5BAC}, //7107 #CJK UNIFIED IDEOGRAPH
    {0xD169, 0x5C03}, //7108 #CJK UNIFIED IDEOGRAPH
    {0xD16A, 0x5C56}, //7109 #CJK UNIFIED IDEOGRAPH
    {0xD16B, 0x5C54}, //7110 #CJK UNIFIED IDEOGRAPH
    {0xD16C, 0x5CEC}, //7111 #CJK UNIFIED IDEOGRAPH
    {0xD16D, 0x5CFF}, //7112 #CJK UNIFIED IDEOGRAPH
    {0xD16E, 0x5CEE}, //7113 #CJK UNIFIED IDEOGRAPH
    {0xD16F, 0x5CF1}, //7114 #CJK UNIFIED IDEOGRAPH
    {0xD170, 0x5CF7}, //7115 #CJK UNIFIED IDEOGRAPH
    {0xD171, 0x5D00}, //7116 #CJK UNIFIED IDEOGRAPH
    {0xD172, 0x5CF9}, //7117 #CJK UNIFIED IDEOGRAPH
    {0xD173, 0x5E29}, //7118 #CJK UNIFIED IDEOGRAPH
    {0xD174, 0x5E28}, //7119 #CJK UNIFIED IDEOGRAPH
    {0xD175, 0x5EA8}, //7120 #CJK UNIFIED IDEOGRAPH
    {0xD176, 0x5EAE}, //7121 #CJK UNIFIED IDEOGRAPH
    {0xD177, 0x5EAA}, //7122 #CJK UNIFIED IDEOGRAPH
    {0xD178, 0x5EAC}, //7123 #CJK UNIFIED IDEOGRAPH
    {0xD179, 0x5F33}, //7124 #CJK UNIFIED IDEOGRAPH
    {0xD17A, 0x5F30}, //7125 #CJK UNIFIED IDEOGRAPH
    {0xD17B, 0x5F67}, //7126 #CJK UNIFIED IDEOGRAPH
    {0xD17C, 0x605D}, //7127 #CJK UNIFIED IDEOGRAPH
    {0xD17D, 0x605A}, //7128 #CJK UNIFIED IDEOGRAPH
    {0xD17E, 0x6067}, //7129 #CJK UNIFIED IDEOGRAPH
    {0xD1A1, 0x6041}, //7130 #CJK UNIFIED IDEOGRAPH
    {0xD1A2, 0x60A2}, //7131 #CJK UNIFIED IDEOGRAPH
    {0xD1A3, 0x6088}, //7132 #CJK UNIFIED IDEOGRAPH
    {0xD1A4, 0x6080}, //7133 #CJK UNIFIED IDEOGRAPH
    {0xD1A5, 0x6092}, //7134 #CJK UNIFIED IDEOGRAPH
    {0xD1A6, 0x6081}, //7135 #CJK UNIFIED IDEOGRAPH
    {0xD1A7, 0x609D}, //7136 #CJK UNIFIED IDEOGRAPH
    {0xD1A8, 0x6083}, //7137 #CJK UNIFIED IDEOGRAPH
    {0xD1A9, 0x6095}, //7138 #CJK UNIFIED IDEOGRAPH
    {0xD1AA, 0x609B}, //7139 #CJK UNIFIED IDEOGRAPH
    {0xD1AB, 0x6097}, //7140 #CJK UNIFIED IDEOGRAPH
    {0xD1AC, 0x6087}, //7141 #CJK UNIFIED IDEOGRAPH
    {0xD1AD, 0x609C}, //7142 #CJK UNIFIED IDEOGRAPH
    {0xD1AE, 0x608E}, //7143 #CJK UNIFIED IDEOGRAPH
    {0xD1AF, 0x6219}, //7144 #CJK UNIFIED IDEOGRAPH
    {0xD1B0, 0x6246}, //7145 #CJK UNIFIED IDEOGRAPH
    {0xD1B1, 0x62F2}, //7146 #CJK UNIFIED IDEOGRAPH
    {0xD1B2, 0x6310}, //7147 #CJK UNIFIED IDEOGRAPH
    {0xD1B3, 0x6356}, //7148 #CJK UNIFIED IDEOGRAPH
    {0xD1B4, 0x632C}, //7149 #CJK UNIFIED IDEOGRAPH
    {0xD1B5, 0x6344}, //7150 #CJK UNIFIED IDEOGRAPH
    {0xD1B6, 0x6345}, //7151 #CJK UNIFIED IDEOGRAPH
    {0xD1B7, 0x6336}, //7152 #CJK UNIFIED IDEOGRAPH
    {0xD1B8, 0x6343}, //7153 #CJK UNIFIED IDEOGRAPH
    {0xD1B9, 0x63E4}, //7154 #CJK UNIFIED IDEOGRAPH
    {0xD1BA, 0x6339}, //7155 #CJK UNIFIED IDEOGRAPH
    {0xD1BB, 0x634B}, //7156 #CJK UNIFIED IDEOGRAPH
    {0xD1BC, 0x634A}, //7157 #CJK UNIFIED IDEOGRAPH
    {0xD1BD, 0x633C}, //7158 #CJK UNIFIED IDEOGRAPH
    {0xD1BE, 0x6329}, //7159 #CJK UNIFIED IDEOGRAPH
    {0xD1BF, 0x6341}, //7160 #CJK UNIFIED IDEOGRAPH
    {0xD1C0, 0x6334}, //7161 #CJK UNIFIED IDEOGRAPH
    {0xD1C1, 0x6358}, //7162 #CJK UNIFIED IDEOGRAPH
    {0xD1C2, 0x6354}, //7163 #CJK UNIFIED IDEOGRAPH
    {0xD1C3, 0x6359}, //7164 #CJK UNIFIED IDEOGRAPH
    {0xD1C4, 0x632D}, //7165 #CJK UNIFIED IDEOGRAPH
    {0xD1C5, 0x6347}, //7166 #CJK UNIFIED IDEOGRAPH
    {0xD1C6, 0x6333}, //7167 #CJK UNIFIED IDEOGRAPH
    {0xD1C7, 0x635A}, //7168 #CJK UNIFIED IDEOGRAPH
    {0xD1C8, 0x6351}, //7169 #CJK UNIFIED IDEOGRAPH
    {0xD1C9, 0x6338}, //7170 #CJK UNIFIED IDEOGRAPH
    {0xD1CA, 0x6357}, //7171 #CJK UNIFIED IDEOGRAPH
    {0xD1CB, 0x6340}, //7172 #CJK UNIFIED IDEOGRAPH
    {0xD1CC, 0x6348}, //7173 #CJK UNIFIED IDEOGRAPH
    {0xD1CD, 0x654A}, //7174 #CJK UNIFIED IDEOGRAPH
    {0xD1CE, 0x6546}, //7175 #CJK UNIFIED IDEOGRAPH
    {0xD1CF, 0x65C6}, //7176 #CJK UNIFIED IDEOGRAPH
    {0xD1D0, 0x65C3}, //7177 #CJK UNIFIED IDEOGRAPH
    {0xD1D1, 0x65C4}, //7178 #CJK UNIFIED IDEOGRAPH
    {0xD1D2, 0x65C2}, //7179 #CJK UNIFIED IDEOGRAPH
    {0xD1D3, 0x664A}, //7180 #CJK UNIFIED IDEOGRAPH
    {0xD1D4, 0x665F}, //7181 #CJK UNIFIED IDEOGRAPH
    {0xD1D5, 0x6647}, //7182 #CJK UNIFIED IDEOGRAPH
    {0xD1D6, 0x6651}, //7183 #CJK UNIFIED IDEOGRAPH
    {0xD1D7, 0x6712}, //7184 #CJK UNIFIED IDEOGRAPH
    {0xD1D8, 0x6713}, //7185 #CJK UNIFIED IDEOGRAPH
    {0xD1D9, 0x681F}, //7186 #CJK UNIFIED IDEOGRAPH
    {0xD1DA, 0x681A}, //7187 #CJK UNIFIED IDEOGRAPH
    {0xD1DB, 0x6849}, //7188 #CJK UNIFIED IDEOGRAPH
    {0xD1DC, 0x6832}, //7189 #CJK UNIFIED IDEOGRAPH
    {0xD1DD, 0x6833}, //7190 #CJK UNIFIED IDEOGRAPH
    {0xD1DE, 0x683B}, //7191 #CJK UNIFIED IDEOGRAPH
    {0xD1DF, 0x684B}, //7192 #CJK UNIFIED IDEOGRAPH
    {0xD1E0, 0x684F}, //7193 #CJK UNIFIED IDEOGRAPH
    {0xD1E1, 0x6816}, //7194 #CJK UNIFIED IDEOGRAPH
    {0xD1E2, 0x6831}, //7195 #CJK UNIFIED IDEOGRAPH
    {0xD1E3, 0x681C}, //7196 #CJK UNIFIED IDEOGRAPH
    {0xD1E4, 0x6835}, //7197 #CJK UNIFIED IDEOGRAPH
    {0xD1E5, 0x682B}, //7198 #CJK UNIFIED IDEOGRAPH
    {0xD1E6, 0x682D}, //7199 #CJK UNIFIED IDEOGRAPH
    {0xD1E7, 0x682F}, //7200 #CJK UNIFIED IDEOGRAPH
    {0xD1E8, 0x684E}, //7201 #CJK UNIFIED IDEOGRAPH
    {0xD1E9, 0x6844}, //7202 #CJK UNIFIED IDEOGRAPH
    {0xD1EA, 0x6834}, //7203 #CJK UNIFIED IDEOGRAPH
    {0xD1EB, 0x681D}, //7204 #CJK UNIFIED IDEOGRAPH
    {0xD1EC, 0x6812}, //7205 #CJK UNIFIED IDEOGRAPH
    {0xD1ED, 0x6814}, //7206 #CJK UNIFIED IDEOGRAPH
    {0xD1EE, 0x6826}, //7207 #CJK UNIFIED IDEOGRAPH
    {0xD1EF, 0x6828}, //7208 #CJK UNIFIED IDEOGRAPH
    {0xD1F0, 0x682E}, //7209 #CJK UNIFIED IDEOGRAPH
    {0xD1F1, 0x684D}, //7210 #CJK UNIFIED IDEOGRAPH
    {0xD1F2, 0x683A}, //7211 #CJK UNIFIED IDEOGRAPH
    {0xD1F3, 0x6825}, //7212 #CJK UNIFIED IDEOGRAPH
    {0xD1F4, 0x6820}, //7213 #CJK UNIFIED IDEOGRAPH
    {0xD1F5, 0x6B2C}, //7214 #CJK UNIFIED IDEOGRAPH
    {0xD1F6, 0x6B2F}, //7215 #CJK UNIFIED IDEOGRAPH
    {0xD1F7, 0x6B2D}, //7216 #CJK UNIFIED IDEOGRAPH
    {0xD1F8, 0x6B31}, //7217 #CJK UNIFIED IDEOGRAPH
    {0xD1F9, 0x6B34}, //7218 #CJK UNIFIED IDEOGRAPH
    {0xD1FA, 0x6B6D}, //7219 #CJK UNIFIED IDEOGRAPH
    {0xD1FB, 0x8082}, //7220 #CJK UNIFIED IDEOGRAPH
    {0xD1FC, 0x6B88}, //7221 #CJK UNIFIED IDEOGRAPH
    {0xD1FD, 0x6BE6}, //7222 #CJK UNIFIED IDEOGRAPH
    {0xD1FE, 0x6BE4}, //7223 #CJK UNIFIED IDEOGRAPH
    {0xD240, 0x6BE8}, //7224 #CJK UNIFIED IDEOGRAPH
    {0xD241, 0x6BE3}, //7225 #CJK UNIFIED IDEOGRAPH
    {0xD242, 0x6BE2}, //7226 #CJK UNIFIED IDEOGRAPH
    {0xD243, 0x6BE7}, //7227 #CJK UNIFIED IDEOGRAPH
    {0xD244, 0x6C25}, //7228 #CJK UNIFIED IDEOGRAPH
    {0xD245, 0x6D7A}, //7229 #CJK UNIFIED IDEOGRAPH
    {0xD246, 0x6D63}, //7230 #CJK UNIFIED IDEOGRAPH
    {0xD247, 0x6D64}, //7231 #CJK UNIFIED IDEOGRAPH
    {0xD248, 0x6D76}, //7232 #CJK UNIFIED IDEOGRAPH
    {0xD249, 0x6D0D}, //7233 #CJK UNIFIED IDEOGRAPH
    {0xD24A, 0x6D61}, //7234 #CJK UNIFIED IDEOGRAPH
    {0xD24B, 0x6D92}, //7235 #CJK UNIFIED IDEOGRAPH
    {0xD24C, 0x6D58}, //7236 #CJK UNIFIED IDEOGRAPH
    {0xD24D, 0x6D62}, //7237 #CJK UNIFIED IDEOGRAPH
    {0xD24E, 0x6D6D}, //7238 #CJK UNIFIED IDEOGRAPH
    {0xD24F, 0x6D6F}, //7239 #CJK UNIFIED IDEOGRAPH
    {0xD250, 0x6D91}, //7240 #CJK UNIFIED IDEOGRAPH
    {0xD251, 0x6D8D}, //7241 #CJK UNIFIED IDEOGRAPH
    {0xD252, 0x6DEF}, //7242 #CJK UNIFIED IDEOGRAPH
    {0xD253, 0x6D7F}, //7243 #CJK UNIFIED IDEOGRAPH
    {0xD254, 0x6D86}, //7244 #CJK UNIFIED IDEOGRAPH
    {0xD255, 0x6D5E}, //7245 #CJK UNIFIED IDEOGRAPH
    {0xD256, 0x6D67}, //7246 #CJK UNIFIED IDEOGRAPH
    {0xD257, 0x6D60}, //7247 #CJK UNIFIED IDEOGRAPH
    {0xD258, 0x6D97}, //7248 #CJK UNIFIED IDEOGRAPH
    {0xD259, 0x6D70}, //7249 #CJK UNIFIED IDEOGRAPH
    {0xD25A, 0x6D7C}, //7250 #CJK UNIFIED IDEOGRAPH
    {0xD25B, 0x6D5F}, //7251 #CJK UNIFIED IDEOGRAPH
    {0xD25C, 0x6D82}, //7252 #CJK UNIFIED IDEOGRAPH
    {0xD25D, 0x6D98}, //7253 #CJK UNIFIED IDEOGRAPH
    {0xD25E, 0x6D2F}, //7254 #CJK UNIFIED IDEOGRAPH
    {0xD25F, 0x6D68}, //7255 #CJK UNIFIED IDEOGRAPH
    {0xD260, 0x6D8B}, //7256 #CJK UNIFIED IDEOGRAPH
    {0xD261, 0x6D7E}, //7257 #CJK UNIFIED IDEOGRAPH
    {0xD262, 0x6D80}, //7258 #CJK UNIFIED IDEOGRAPH
    {0xD263, 0x6D84}, //7259 #CJK UNIFIED IDEOGRAPH
    {0xD264, 0x6D16}, //7260 #CJK UNIFIED IDEOGRAPH
    {0xD265, 0x6D83}, //7261 #CJK UNIFIED IDEOGRAPH
    {0xD266, 0x6D7B}, //7262 #CJK UNIFIED IDEOGRAPH
    {0xD267, 0x6D7D}, //7263 #CJK UNIFIED IDEOGRAPH
    {0xD268, 0x6D75}, //7264 #CJK UNIFIED IDEOGRAPH
    {0xD269, 0x6D90}, //7265 #CJK UNIFIED IDEOGRAPH
    {0xD26A, 0x70DC}, //7266 #CJK UNIFIED IDEOGRAPH
    {0xD26B, 0x70D3}, //7267 #CJK UNIFIED IDEOGRAPH
    {0xD26C, 0x70D1}, //7268 #CJK UNIFIED IDEOGRAPH
    {0xD26D, 0x70DD}, //7269 #CJK UNIFIED IDEOGRAPH
    {0xD26E, 0x70CB}, //7270 #CJK UNIFIED IDEOGRAPH
    {0xD26F, 0x7F39}, //7271 #CJK UNIFIED IDEOGRAPH
    {0xD270, 0x70E2}, //7272 #CJK UNIFIED IDEOGRAPH
    {0xD271, 0x70D7}, //7273 #CJK UNIFIED IDEOGRAPH
    {0xD272, 0x70D2}, //7274 #CJK UNIFIED IDEOGRAPH
    {0xD273, 0x70DE}, //7275 #CJK UNIFIED IDEOGRAPH
    {0xD274, 0x70E0}, //7276 #CJK UNIFIED IDEOGRAPH
    {0xD275, 0x70D4}, //7277 #CJK UNIFIED IDEOGRAPH
    {0xD276, 0x70CD}, //7278 #CJK UNIFIED IDEOGRAPH
    {0xD277, 0x70C5}, //7279 #CJK UNIFIED IDEOGRAPH
    {0xD278, 0x70C6}, //7280 #CJK UNIFIED IDEOGRAPH
    {0xD279, 0x70C7}, //7281 #CJK UNIFIED IDEOGRAPH
    {0xD27A, 0x70DA}, //7282 #CJK UNIFIED IDEOGRAPH
    {0xD27B, 0x70CE}, //7283 #CJK UNIFIED IDEOGRAPH
    {0xD27C, 0x70E1}, //7284 #CJK UNIFIED IDEOGRAPH
    {0xD27D, 0x7242}, //7285 #CJK UNIFIED IDEOGRAPH
    {0xD27E, 0x7278}, //7286 #CJK UNIFIED IDEOGRAPH
    {0xD2A1, 0x7277}, //7287 #CJK UNIFIED IDEOGRAPH
    {0xD2A2, 0x7276}, //7288 #CJK UNIFIED IDEOGRAPH
    {0xD2A3, 0x7300}, //7289 #CJK UNIFIED IDEOGRAPH
    {0xD2A4, 0x72FA}, //7290 #CJK UNIFIED IDEOGRAPH
    {0xD2A5, 0x72F4}, //7291 #CJK UNIFIED IDEOGRAPH
    {0xD2A6, 0x72FE}, //7292 #CJK UNIFIED IDEOGRAPH
    {0xD2A7, 0x72F6}, //7293 #CJK UNIFIED IDEOGRAPH
    {0xD2A8, 0x72F3}, //7294 #CJK UNIFIED IDEOGRAPH
    {0xD2A9, 0x72FB}, //7295 #CJK UNIFIED IDEOGRAPH
    {0xD2AA, 0x7301}, //7296 #CJK UNIFIED IDEOGRAPH
    {0xD2AB, 0x73D3}, //7297 #CJK UNIFIED IDEOGRAPH
    {0xD2AC, 0x73D9}, //7298 #CJK UNIFIED IDEOGRAPH
    {0xD2AD, 0x73E5}, //7299 #CJK UNIFIED IDEOGRAPH
    {0xD2AE, 0x73D6}, //7300 #CJK UNIFIED IDEOGRAPH
    {0xD2AF, 0x73BC}, //7301 #CJK UNIFIED IDEOGRAPH
    {0xD2B0, 0x73E7}, //7302 #CJK UNIFIED IDEOGRAPH
    {0xD2B1, 0x73E3}, //7303 #CJK UNIFIED IDEOGRAPH
    {0xD2B2, 0x73E9}, //7304 #CJK UNIFIED IDEOGRAPH
    {0xD2B3, 0x73DC}, //7305 #CJK UNIFIED IDEOGRAPH
    {0xD2B4, 0x73D2}, //7306 #CJK UNIFIED IDEOGRAPH
    {0xD2B5, 0x73DB}, //7307 #CJK UNIFIED IDEOGRAPH
    {0xD2B6, 0x73D4}, //7308 #CJK UNIFIED IDEOGRAPH
    {0xD2B7, 0x73DD}, //7309 #CJK UNIFIED IDEOGRAPH
    {0xD2B8, 0x73DA}, //7310 #CJK UNIFIED IDEOGRAPH
    {0xD2B9, 0x73D7}, //7311 #CJK UNIFIED IDEOGRAPH
    {0xD2BA, 0x73D8}, //7312 #CJK UNIFIED IDEOGRAPH
    {0xD2BB, 0x73E8}, //7313 #CJK UNIFIED IDEOGRAPH
    {0xD2BC, 0x74DE}, //7314 #CJK UNIFIED IDEOGRAPH
    {0xD2BD, 0x74DF}, //7315 #CJK UNIFIED IDEOGRAPH
    {0xD2BE, 0x74F4}, //7316 #CJK UNIFIED IDEOGRAPH
    {0xD2BF, 0x74F5}, //7317 #CJK UNIFIED IDEOGRAPH
    {0xD2C0, 0x7521}, //7318 #CJK UNIFIED IDEOGRAPH
    {0xD2C1, 0x755B}, //7319 #CJK UNIFIED IDEOGRAPH
    {0xD2C2, 0x755F}, //7320 #CJK UNIFIED IDEOGRAPH
    {0xD2C3, 0x75B0}, //7321 #CJK UNIFIED IDEOGRAPH
    {0xD2C4, 0x75C1}, //7322 #CJK UNIFIED IDEOGRAPH
    {0xD2C5, 0x75BB}, //7323 #CJK UNIFIED IDEOGRAPH
    {0xD2C6, 0x75C4}, //7324 #CJK UNIFIED IDEOGRAPH
    {0xD2C7, 0x75C0}, //7325 #CJK UNIFIED IDEOGRAPH
    {0xD2C8, 0x75BF}, //7326 #CJK UNIFIED IDEOGRAPH
    {0xD2C9, 0x75B6}, //7327 #CJK UNIFIED IDEOGRAPH
    {0xD2CA, 0x75BA}, //7328 #CJK UNIFIED IDEOGRAPH
    {0xD2CB, 0x768A}, //7329 #CJK UNIFIED IDEOGRAPH
    {0xD2CC, 0x76C9}, //7330 #CJK UNIFIED IDEOGRAPH
    {0xD2CD, 0x771D}, //7331 #CJK UNIFIED IDEOGRAPH
    {0xD2CE, 0x771B}, //7332 #CJK UNIFIED IDEOGRAPH
    {0xD2CF, 0x7710}, //7333 #CJK UNIFIED IDEOGRAPH
    {0xD2D0, 0x7713}, //7334 #CJK UNIFIED IDEOGRAPH
    {0xD2D1, 0x7712}, //7335 #CJK UNIFIED IDEOGRAPH
    {0xD2D2, 0x7723}, //7336 #CJK UNIFIED IDEOGRAPH
    {0xD2D3, 0x7711}, //7337 #CJK UNIFIED IDEOGRAPH
    {0xD2D4, 0x7715}, //7338 #CJK UNIFIED IDEOGRAPH
    {0xD2D5, 0x7719}, //7339 #CJK UNIFIED IDEOGRAPH
    {0xD2D6, 0x771A}, //7340 #CJK UNIFIED IDEOGRAPH
    {0xD2D7, 0x7722}, //7341 #CJK UNIFIED IDEOGRAPH
    {0xD2D8, 0x7727}, //7342 #CJK UNIFIED IDEOGRAPH
    {0xD2D9, 0x7823}, //7343 #CJK UNIFIED IDEOGRAPH
    {0xD2DA, 0x782C}, //7344 #CJK UNIFIED IDEOGRAPH
    {0xD2DB, 0x7822}, //7345 #CJK UNIFIED IDEOGRAPH
    {0xD2DC, 0x7835}, //7346 #CJK UNIFIED IDEOGRAPH
    {0xD2DD, 0x782F}, //7347 #CJK UNIFIED IDEOGRAPH
    {0xD2DE, 0x7828}, //7348 #CJK UNIFIED IDEOGRAPH
    {0xD2DF, 0x782E}, //7349 #CJK UNIFIED IDEOGRAPH
    {0xD2E0, 0x782B}, //7350 #CJK UNIFIED IDEOGRAPH
    {0xD2E1, 0x7821}, //7351 #CJK UNIFIED IDEOGRAPH
    {0xD2E2, 0x7829}, //7352 #CJK UNIFIED IDEOGRAPH
    {0xD2E3, 0x7833}, //7353 #CJK UNIFIED IDEOGRAPH
    {0xD2E4, 0x782A}, //7354 #CJK UNIFIED IDEOGRAPH
    {0xD2E5, 0x7831}, //7355 #CJK UNIFIED IDEOGRAPH
    {0xD2E6, 0x7954}, //7356 #CJK UNIFIED IDEOGRAPH
    {0xD2E7, 0x795B}, //7357 #CJK UNIFIED IDEOGRAPH
    {0xD2E8, 0x794F}, //7358 #CJK UNIFIED IDEOGRAPH
    {0xD2E9, 0x795C}, //7359 #CJK UNIFIED IDEOGRAPH
    {0xD2EA, 0x7953}, //7360 #CJK UNIFIED IDEOGRAPH
    {0xD2EB, 0x7952}, //7361 #CJK UNIFIED IDEOGRAPH
    {0xD2EC, 0x7951}, //7362 #CJK UNIFIED IDEOGRAPH
    {0xD2ED, 0x79EB}, //7363 #CJK UNIFIED IDEOGRAPH
    {0xD2EE, 0x79EC}, //7364 #CJK UNIFIED IDEOGRAPH
    {0xD2EF, 0x79E0}, //7365 #CJK UNIFIED IDEOGRAPH
    {0xD2F0, 0x79EE}, //7366 #CJK UNIFIED IDEOGRAPH
    {0xD2F1, 0x79ED}, //7367 #CJK UNIFIED IDEOGRAPH
    {0xD2F2, 0x79EA}, //7368 #CJK UNIFIED IDEOGRAPH
    {0xD2F3, 0x79DC}, //7369 #CJK UNIFIED IDEOGRAPH
    {0xD2F4, 0x79DE}, //7370 #CJK UNIFIED IDEOGRAPH
    {0xD2F5, 0x79DD}, //7371 #CJK UNIFIED IDEOGRAPH
    {0xD2F6, 0x7A86}, //7372 #CJK UNIFIED IDEOGRAPH
    {0xD2F7, 0x7A89}, //7373 #CJK UNIFIED IDEOGRAPH
    {0xD2F8, 0x7A85}, //7374 #CJK UNIFIED IDEOGRAPH
    {0xD2F9, 0x7A8B}, //7375 #CJK UNIFIED IDEOGRAPH
    {0xD2FA, 0x7A8C}, //7376 #CJK UNIFIED IDEOGRAPH
    {0xD2FB, 0x7A8A}, //7377 #CJK UNIFIED IDEOGRAPH
    {0xD2FC, 0x7A87}, //7378 #CJK UNIFIED IDEOGRAPH
    {0xD2FD, 0x7AD8}, //7379 #CJK UNIFIED IDEOGRAPH
    {0xD2FE, 0x7B10}, //7380 #CJK UNIFIED IDEOGRAPH
    {0xD340, 0x7B04}, //7381 #CJK UNIFIED IDEOGRAPH
    {0xD341, 0x7B13}, //7382 #CJK UNIFIED IDEOGRAPH
    {0xD342, 0x7B05}, //7383 #CJK UNIFIED IDEOGRAPH
    {0xD343, 0x7B0F}, //7384 #CJK UNIFIED IDEOGRAPH
    {0xD344, 0x7B08}, //7385 #CJK UNIFIED IDEOGRAPH
    {0xD345, 0x7B0A}, //7386 #CJK UNIFIED IDEOGRAPH
    {0xD346, 0x7B0E}, //7387 #CJK UNIFIED IDEOGRAPH
    {0xD347, 0x7B09}, //7388 #CJK UNIFIED IDEOGRAPH
    {0xD348, 0x7B12}, //7389 #CJK UNIFIED IDEOGRAPH
    {0xD349, 0x7C84}, //7390 #CJK UNIFIED IDEOGRAPH
    {0xD34A, 0x7C91}, //7391 #CJK UNIFIED IDEOGRAPH
    {0xD34B, 0x7C8A}, //7392 #CJK UNIFIED IDEOGRAPH
    {0xD34C, 0x7C8C}, //7393 #CJK UNIFIED IDEOGRAPH
    {0xD34D, 0x7C88}, //7394 #CJK UNIFIED IDEOGRAPH
    {0xD34E, 0x7C8D}, //7395 #CJK UNIFIED IDEOGRAPH
    {0xD34F, 0x7C85}, //7396 #CJK UNIFIED IDEOGRAPH
    {0xD350, 0x7D1E}, //7397 #CJK UNIFIED IDEOGRAPH
    {0xD351, 0x7D1D}, //7398 #CJK UNIFIED IDEOGRAPH
    {0xD352, 0x7D11}, //7399 #CJK UNIFIED IDEOGRAPH
    {0xD353, 0x7D0E}, //7400 #CJK UNIFIED IDEOGRAPH
    {0xD354, 0x7D18}, //7401 #CJK UNIFIED IDEOGRAPH
    {0xD355, 0x7D16}, //7402 #CJK UNIFIED IDEOGRAPH
    {0xD356, 0x7D13}, //7403 #CJK UNIFIED IDEOGRAPH
    {0xD357, 0x7D1F}, //7404 #CJK UNIFIED IDEOGRAPH
    {0xD358, 0x7D12}, //7405 #CJK UNIFIED IDEOGRAPH
    {0xD359, 0x7D0F}, //7406 #CJK UNIFIED IDEOGRAPH
    {0xD35A, 0x7D0C}, //7407 #CJK UNIFIED IDEOGRAPH
    {0xD35B, 0x7F5C}, //7408 #CJK UNIFIED IDEOGRAPH
    {0xD35C, 0x7F61}, //7409 #CJK UNIFIED IDEOGRAPH
    {0xD35D, 0x7F5E}, //7410 #CJK UNIFIED IDEOGRAPH
    {0xD35E, 0x7F60}, //7411 #CJK UNIFIED IDEOGRAPH
    {0xD35F, 0x7F5D}, //7412 #CJK UNIFIED IDEOGRAPH
    {0xD360, 0x7F5B}, //7413 #CJK UNIFIED IDEOGRAPH
    {0xD361, 0x7F96}, //7414 #CJK UNIFIED IDEOGRAPH
    {0xD362, 0x7F92}, //7415 #CJK UNIFIED IDEOGRAPH
    {0xD363, 0x7FC3}, //7416 #CJK UNIFIED IDEOGRAPH
    {0xD364, 0x7FC2}, //7417 #CJK UNIFIED IDEOGRAPH
    {0xD365, 0x7FC0}, //7418 #CJK UNIFIED IDEOGRAPH
    {0xD366, 0x8016}, //7419 #CJK UNIFIED IDEOGRAPH
    {0xD367, 0x803E}, //7420 #CJK UNIFIED IDEOGRAPH
    {0xD368, 0x8039}, //7421 #CJK UNIFIED IDEOGRAPH
    {0xD369, 0x80FA}, //7422 #CJK UNIFIED IDEOGRAPH
    {0xD36A, 0x80F2}, //7423 #CJK UNIFIED IDEOGRAPH
    {0xD36B, 0x80F9}, //7424 #CJK UNIFIED IDEOGRAPH
    {0xD36C, 0x80F5}, //7425 #CJK UNIFIED IDEOGRAPH
    {0xD36D, 0x8101}, //7426 #CJK UNIFIED IDEOGRAPH
    {0xD36E, 0x80FB}, //7427 #CJK UNIFIED IDEOGRAPH
    {0xD36F, 0x8100}, //7428 #CJK UNIFIED IDEOGRAPH
    {0xD370, 0x8201}, //7429 #CJK UNIFIED IDEOGRAPH
    {0xD371, 0x822F}, //7430 #CJK UNIFIED IDEOGRAPH
    {0xD372, 0x8225}, //7431 #CJK UNIFIED IDEOGRAPH
    {0xD373, 0x8333}, //7432 #CJK UNIFIED IDEOGRAPH
    {0xD374, 0x832D}, //7433 #CJK UNIFIED IDEOGRAPH
    {0xD375, 0x8344}, //7434 #CJK UNIFIED IDEOGRAPH
    {0xD376, 0x8319}, //7435 #CJK UNIFIED IDEOGRAPH
    {0xD377, 0x8351}, //7436 #CJK UNIFIED IDEOGRAPH
    {0xD378, 0x8325}, //7437 #CJK UNIFIED IDEOGRAPH
    {0xD379, 0x8356}, //7438 #CJK UNIFIED IDEOGRAPH
    {0xD37A, 0x833F}, //7439 #CJK UNIFIED IDEOGRAPH
    {0xD37B, 0x8341}, //7440 #CJK UNIFIED IDEOGRAPH
    {0xD37C, 0x8326}, //7441 #CJK UNIFIED IDEOGRAPH
    {0xD37D, 0x831C}, //7442 #CJK UNIFIED IDEOGRAPH
    {0xD37E, 0x8322}, //7443 #CJK UNIFIED IDEOGRAPH
    {0xD3A1, 0x8342}, //7444 #CJK UNIFIED IDEOGRAPH
    {0xD3A2, 0x834E}, //7445 #CJK UNIFIED IDEOGRAPH
    {0xD3A3, 0x831B}, //7446 #CJK UNIFIED IDEOGRAPH
    {0xD3A4, 0x832A}, //7447 #CJK UNIFIED IDEOGRAPH
    {0xD3A5, 0x8308}, //7448 #CJK UNIFIED IDEOGRAPH
    {0xD3A6, 0x833C}, //7449 #CJK UNIFIED IDEOGRAPH
    {0xD3A7, 0x834D}, //7450 #CJK UNIFIED IDEOGRAPH
    {0xD3A8, 0x8316}, //7451 #CJK UNIFIED IDEOGRAPH
    {0xD3A9, 0x8324}, //7452 #CJK UNIFIED IDEOGRAPH
    {0xD3AA, 0x8320}, //7453 #CJK UNIFIED IDEOGRAPH
    {0xD3AB, 0x8337}, //7454 #CJK UNIFIED IDEOGRAPH
    {0xD3AC, 0x832F}, //7455 #CJK UNIFIED IDEOGRAPH
    {0xD3AD, 0x8329}, //7456 #CJK UNIFIED IDEOGRAPH
    {0xD3AE, 0x8347}, //7457 #CJK UNIFIED IDEOGRAPH
    {0xD3AF, 0x8345}, //7458 #CJK UNIFIED IDEOGRAPH
    {0xD3B0, 0x834C}, //7459 #CJK UNIFIED IDEOGRAPH
    {0xD3B1, 0x8353}, //7460 #CJK UNIFIED IDEOGRAPH
    {0xD3B2, 0x831E}, //7461 #CJK UNIFIED IDEOGRAPH
    {0xD3B3, 0x832C}, //7462 #CJK UNIFIED IDEOGRAPH
    {0xD3B4, 0x834B}, //7463 #CJK UNIFIED IDEOGRAPH
    {0xD3B5, 0x8327}, //7464 #CJK UNIFIED IDEOGRAPH
    {0xD3B6, 0x8348}, //7465 #CJK UNIFIED IDEOGRAPH
    {0xD3B7, 0x8653}, //7466 #CJK UNIFIED IDEOGRAPH
    {0xD3B8, 0x8652}, //7467 #CJK UNIFIED IDEOGRAPH
    {0xD3B9, 0x86A2}, //7468 #CJK UNIFIED IDEOGRAPH
    {0xD3BA, 0x86A8}, //7469 #CJK UNIFIED IDEOGRAPH
    {0xD3BB, 0x8696}, //7470 #CJK UNIFIED IDEOGRAPH
    {0xD3BC, 0x868D}, //7471 #CJK UNIFIED IDEOGRAPH
    {0xD3BD, 0x8691}, //7472 #CJK UNIFIED IDEOGRAPH
    {0xD3BE, 0x869E}, //7473 #CJK UNIFIED IDEOGRAPH
    {0xD3BF, 0x8687}, //7474 #CJK UNIFIED IDEOGRAPH
    {0xD3C0, 0x8697}, //7475 #CJK UNIFIED IDEOGRAPH
    {0xD3C1, 0x8686}, //7476 #CJK UNIFIED IDEOGRAPH
    {0xD3C2, 0x868B}, //7477 #CJK UNIFIED IDEOGRAPH
    {0xD3C3, 0x869A}, //7478 #CJK UNIFIED IDEOGRAPH
    {0xD3C4, 0x8685}, //7479 #CJK UNIFIED IDEOGRAPH
    {0xD3C5, 0x86A5}, //7480 #CJK UNIFIED IDEOGRAPH
    {0xD3C6, 0x8699}, //7481 #CJK UNIFIED IDEOGRAPH
    {0xD3C7, 0x86A1}, //7482 #CJK UNIFIED IDEOGRAPH
    {0xD3C8, 0x86A7}, //7483 #CJK UNIFIED IDEOGRAPH
    {0xD3C9, 0x8695}, //7484 #CJK UNIFIED IDEOGRAPH
    {0xD3CA, 0x8698}, //7485 #CJK UNIFIED IDEOGRAPH
    {0xD3CB, 0x868E}, //7486 #CJK UNIFIED IDEOGRAPH
    {0xD3CC, 0x869D}, //7487 #CJK UNIFIED IDEOGRAPH
    {0xD3CD, 0x8690}, //7488 #CJK UNIFIED IDEOGRAPH
    {0xD3CE, 0x8694}, //7489 #CJK UNIFIED IDEOGRAPH
    {0xD3CF, 0x8843}, //7490 #CJK UNIFIED IDEOGRAPH
    {0xD3D0, 0x8844}, //7491 #CJK UNIFIED IDEOGRAPH
    {0xD3D1, 0x886D}, //7492 #CJK UNIFIED IDEOGRAPH
    {0xD3D2, 0x8875}, //7493 #CJK UNIFIED IDEOGRAPH
    {0xD3D3, 0x8876}, //7494 #CJK UNIFIED IDEOGRAPH
    {0xD3D4, 0x8872}, //7495 #CJK UNIFIED IDEOGRAPH
    {0xD3D5, 0x8880}, //7496 #CJK UNIFIED IDEOGRAPH
    {0xD3D6, 0x8871}, //7497 #CJK UNIFIED IDEOGRAPH
    {0xD3D7, 0x887F}, //7498 #CJK UNIFIED IDEOGRAPH
    {0xD3D8, 0x886F}, //7499 #CJK UNIFIED IDEOGRAPH
    {0xD3D9, 0x8883}, //7500 #CJK UNIFIED IDEOGRAPH
    {0xD3DA, 0x887E}, //7501 #CJK UNIFIED IDEOGRAPH
    {0xD3DB, 0x8874}, //7502 #CJK UNIFIED IDEOGRAPH
    {0xD3DC, 0x887C}, //7503 #CJK UNIFIED IDEOGRAPH
    {0xD3DD, 0x8A12}, //7504 #CJK UNIFIED IDEOGRAPH
    {0xD3DE, 0x8C47}, //7505 #CJK UNIFIED IDEOGRAPH
    {0xD3DF, 0x8C57}, //7506 #CJK UNIFIED IDEOGRAPH
    {0xD3E0, 0x8C7B}, //7507 #CJK UNIFIED IDEOGRAPH
    {0xD3E1, 0x8CA4}, //7508 #CJK UNIFIED IDEOGRAPH
    {0xD3E2, 0x8CA3}, //7509 #CJK UNIFIED IDEOGRAPH
    {0xD3E3, 0x8D76}, //7510 #CJK UNIFIED IDEOGRAPH
    {0xD3E4, 0x8D78}, //7511 #CJK UNIFIED IDEOGRAPH
    {0xD3E5, 0x8DB5}, //7512 #CJK UNIFIED IDEOGRAPH
    {0xD3E6, 0x8DB7}, //7513 #CJK UNIFIED IDEOGRAPH
    {0xD3E7, 0x8DB6}, //7514 #CJK UNIFIED IDEOGRAPH
    {0xD3E8, 0x8ED1}, //7515 #CJK UNIFIED IDEOGRAPH
    {0xD3E9, 0x8ED3}, //7516 #CJK UNIFIED IDEOGRAPH
    {0xD3EA, 0x8FFE}, //7517 #CJK UNIFIED IDEOGRAPH
    {0xD3EB, 0x8FF5}, //7518 #CJK UNIFIED IDEOGRAPH
    {0xD3EC, 0x9002}, //7519 #CJK UNIFIED IDEOGRAPH
    {0xD3ED, 0x8FFF}, //7520 #CJK UNIFIED IDEOGRAPH
    {0xD3EE, 0x8FFB}, //7521 #CJK UNIFIED IDEOGRAPH
    {0xD3EF, 0x9004}, //7522 #CJK UNIFIED IDEOGRAPH
    {0xD3F0, 0x8FFC}, //7523 #CJK UNIFIED IDEOGRAPH
    {0xD3F1, 0x8FF6}, //7524 #CJK UNIFIED IDEOGRAPH
    {0xD3F2, 0x90D6}, //7525 #CJK UNIFIED IDEOGRAPH
    {0xD3F3, 0x90E0}, //7526 #CJK UNIFIED IDEOGRAPH
    {0xD3F4, 0x90D9}, //7527 #CJK UNIFIED IDEOGRAPH
    {0xD3F5, 0x90DA}, //7528 #CJK UNIFIED IDEOGRAPH
    {0xD3F6, 0x90E3}, //7529 #CJK UNIFIED IDEOGRAPH
    {0xD3F7, 0x90DF}, //7530 #CJK UNIFIED IDEOGRAPH
    {0xD3F8, 0x90E5}, //7531 #CJK UNIFIED IDEOGRAPH
    {0xD3F9, 0x90D8}, //7532 #CJK UNIFIED IDEOGRAPH
    {0xD3FA, 0x90DB}, //7533 #CJK UNIFIED IDEOGRAPH
    {0xD3FB, 0x90D7}, //7534 #CJK UNIFIED IDEOGRAPH
    {0xD3FC, 0x90DC}, //7535 #CJK UNIFIED IDEOGRAPH
    {0xD3FD, 0x90E4}, //7536 #CJK UNIFIED IDEOGRAPH
    {0xD3FE, 0x9150}, //7537 #CJK UNIFIED IDEOGRAPH
    {0xD440, 0x914E}, //7538 #CJK UNIFIED IDEOGRAPH
    {0xD441, 0x914F}, //7539 #CJK UNIFIED IDEOGRAPH
    {0xD442, 0x91D5}, //7540 #CJK UNIFIED IDEOGRAPH
    {0xD443, 0x91E2}, //7541 #CJK UNIFIED IDEOGRAPH
    {0xD444, 0x91DA}, //7542 #CJK UNIFIED IDEOGRAPH
    {0xD445, 0x965C}, //7543 #CJK UNIFIED IDEOGRAPH
    {0xD446, 0x965F}, //7544 #CJK UNIFIED IDEOGRAPH
    {0xD447, 0x96BC}, //7545 #CJK UNIFIED IDEOGRAPH
    {0xD448, 0x98E3}, //7546 #CJK UNIFIED IDEOGRAPH
    {0xD449, 0x9ADF}, //7547 #CJK UNIFIED IDEOGRAPH
    {0xD44A, 0x9B2F}, //7548 #CJK UNIFIED IDEOGRAPH
    {0xD44B, 0x4E7F}, //7549 #CJK UNIFIED IDEOGRAPH
    {0xD44C, 0x5070}, //7550 #CJK UNIFIED IDEOGRAPH
    {0xD44D, 0x506A}, //7551 #CJK UNIFIED IDEOGRAPH
    {0xD44E, 0x5061}, //7552 #CJK UNIFIED IDEOGRAPH
    {0xD44F, 0x505E}, //7553 #CJK UNIFIED IDEOGRAPH
    {0xD450, 0x5060}, //7554 #CJK UNIFIED IDEOGRAPH
    {0xD451, 0x5053}, //7555 #CJK UNIFIED IDEOGRAPH
    {0xD452, 0x504B}, //7556 #CJK UNIFIED IDEOGRAPH
    {0xD453, 0x505D}, //7557 #CJK UNIFIED IDEOGRAPH
    {0xD454, 0x5072}, //7558 #CJK UNIFIED IDEOGRAPH
    {0xD455, 0x5048}, //7559 #CJK UNIFIED IDEOGRAPH
    {0xD456, 0x504D}, //7560 #CJK UNIFIED IDEOGRAPH
    {0xD457, 0x5041}, //7561 #CJK UNIFIED IDEOGRAPH
    {0xD458, 0x505B}, //7562 #CJK UNIFIED IDEOGRAPH
    {0xD459, 0x504A}, //7563 #CJK UNIFIED IDEOGRAPH
    {0xD45A, 0x5062}, //7564 #CJK UNIFIED IDEOGRAPH
    {0xD45B, 0x5015}, //7565 #CJK UNIFIED IDEOGRAPH
    {0xD45C, 0x5045}, //7566 #CJK UNIFIED IDEOGRAPH
    {0xD45D, 0x505F}, //7567 #CJK UNIFIED IDEOGRAPH
    {0xD45E, 0x5069}, //7568 #CJK UNIFIED IDEOGRAPH
    {0xD45F, 0x506B}, //7569 #CJK UNIFIED IDEOGRAPH
    {0xD460, 0x5063}, //7570 #CJK UNIFIED IDEOGRAPH
    {0xD461, 0x5064}, //7571 #CJK UNIFIED IDEOGRAPH
    {0xD462, 0x5046}, //7572 #CJK UNIFIED IDEOGRAPH
    {0xD463, 0x5040}, //7573 #CJK UNIFIED IDEOGRAPH
    {0xD464, 0x506E}, //7574 #CJK UNIFIED IDEOGRAPH
    {0xD465, 0x5073}, //7575 #CJK UNIFIED IDEOGRAPH
    {0xD466, 0x5057}, //7576 #CJK UNIFIED IDEOGRAPH
    {0xD467, 0x5051}, //7577 #CJK UNIFIED IDEOGRAPH
    {0xD468, 0x51D0}, //7578 #CJK UNIFIED IDEOGRAPH
    {0xD469, 0x526B}, //7579 #CJK UNIFIED IDEOGRAPH
    {0xD46A, 0x526D}, //7580 #CJK UNIFIED IDEOGRAPH
    {0xD46B, 0x526C}, //7581 #CJK UNIFIED IDEOGRAPH
    {0xD46C, 0x526E}, //7582 #CJK UNIFIED IDEOGRAPH
    {0xD46D, 0x52D6}, //7583 #CJK UNIFIED IDEOGRAPH
    {0xD46E, 0x52D3}, //7584 #CJK UNIFIED IDEOGRAPH
    {0xD46F, 0x532D}, //7585 #CJK UNIFIED IDEOGRAPH
    {0xD470, 0x539C}, //7586 #CJK UNIFIED IDEOGRAPH
    {0xD471, 0x5575}, //7587 #CJK UNIFIED IDEOGRAPH
    {0xD472, 0x5576}, //7588 #CJK UNIFIED IDEOGRAPH
    {0xD473, 0x553C}, //7589 #CJK UNIFIED IDEOGRAPH
    {0xD474, 0x554D}, //7590 #CJK UNIFIED IDEOGRAPH
    {0xD475, 0x5550}, //7591 #CJK UNIFIED IDEOGRAPH
    {0xD476, 0x5534}, //7592 #CJK UNIFIED IDEOGRAPH
    {0xD477, 0x552A}, //7593 #CJK UNIFIED IDEOGRAPH
    {0xD478, 0x5551}, //7594 #CJK UNIFIED IDEOGRAPH
    {0xD479, 0x5562}, //7595 #CJK UNIFIED IDEOGRAPH
    {0xD47A, 0x5536}, //7596 #CJK UNIFIED IDEOGRAPH
    {0xD47B, 0x5535}, //7597 #CJK UNIFIED IDEOGRAPH
    {0xD47C, 0x5530}, //7598 #CJK UNIFIED IDEOGRAPH
    {0xD47D, 0x5552}, //7599 #CJK UNIFIED IDEOGRAPH
    {0xD47E, 0x5545}, //7600 #CJK UNIFIED IDEOGRAPH
    {0xD4A1, 0x550C}, //7601 #CJK UNIFIED IDEOGRAPH
    {0xD4A2, 0x5532}, //7602 #CJK UNIFIED IDEOGRAPH
    {0xD4A3, 0x5565}, //7603 #CJK UNIFIED IDEOGRAPH
    {0xD4A4, 0x554E}, //7604 #CJK UNIFIED IDEOGRAPH
    {0xD4A5, 0x5539}, //7605 #CJK UNIFIED IDEOGRAPH
    {0xD4A6, 0x5548}, //7606 #CJK UNIFIED IDEOGRAPH
    {0xD4A7, 0x552D}, //7607 #CJK UNIFIED IDEOGRAPH
    {0xD4A8, 0x553B}, //7608 #CJK UNIFIED IDEOGRAPH
    {0xD4A9, 0x5540}, //7609 #CJK UNIFIED IDEOGRAPH
    {0xD4AA, 0x554B}, //7610 #CJK UNIFIED IDEOGRAPH
    {0xD4AB, 0x570A}, //7611 #CJK UNIFIED IDEOGRAPH
    {0xD4AC, 0x5707}, //7612 #CJK UNIFIED IDEOGRAPH
    {0xD4AD, 0x57FB}, //7613 #CJK UNIFIED IDEOGRAPH
    {0xD4AE, 0x5814}, //7614 #CJK UNIFIED IDEOGRAPH
    {0xD4AF, 0x57E2}, //7615 #CJK UNIFIED IDEOGRAPH
    {0xD4B0, 0x57F6}, //7616 #CJK UNIFIED IDEOGRAPH
    {0xD4B1, 0x57DC}, //7617 #CJK UNIFIED IDEOGRAPH
    {0xD4B2, 0x57F4}, //7618 #CJK UNIFIED IDEOGRAPH
    {0xD4B3, 0x5800}, //7619 #CJK UNIFIED IDEOGRAPH
    {0xD4B4, 0x57ED}, //7620 #CJK UNIFIED IDEOGRAPH
    {0xD4B5, 0x57FD}, //7621 #CJK UNIFIED IDEOGRAPH
    {0xD4B6, 0x5808}, //7622 #CJK UNIFIED IDEOGRAPH
    {0xD4B7, 0x57F8}, //7623 #CJK UNIFIED IDEOGRAPH
    {0xD4B8, 0x580B}, //7624 #CJK UNIFIED IDEOGRAPH
    {0xD4B9, 0x57F3}, //7625 #CJK UNIFIED IDEOGRAPH
    {0xD4BA, 0x57CF}, //7626 #CJK UNIFIED IDEOGRAPH
    {0xD4BB, 0x5807}, //7627 #CJK UNIFIED IDEOGRAPH
    {0xD4BC, 0x57EE}, //7628 #CJK UNIFIED IDEOGRAPH
    {0xD4BD, 0x57E3}, //7629 #CJK UNIFIED IDEOGRAPH
    {0xD4BE, 0x57F2}, //7630 #CJK UNIFIED IDEOGRAPH
    {0xD4BF, 0x57E5}, //7631 #CJK UNIFIED IDEOGRAPH
    {0xD4C0, 0x57EC}, //7632 #CJK UNIFIED IDEOGRAPH
    {0xD4C1, 0x57E1}, //7633 #CJK UNIFIED IDEOGRAPH
    {0xD4C2, 0x580E}, //7634 #CJK UNIFIED IDEOGRAPH
    {0xD4C3, 0x57FC}, //7635 #CJK UNIFIED IDEOGRAPH
    {0xD4C4, 0x5810}, //7636 #CJK UNIFIED IDEOGRAPH
    {0xD4C5, 0x57E7}, //7637 #CJK UNIFIED IDEOGRAPH
    {0xD4C6, 0x5801}, //7638 #CJK UNIFIED IDEOGRAPH
    {0xD4C7, 0x580C}, //7639 #CJK UNIFIED IDEOGRAPH
    {0xD4C8, 0x57F1}, //7640 #CJK UNIFIED IDEOGRAPH
    {0xD4C9, 0x57E9}, //7641 #CJK UNIFIED IDEOGRAPH
    {0xD4CA, 0x57F0}, //7642 #CJK UNIFIED IDEOGRAPH
    {0xD4CB, 0x580D}, //7643 #CJK UNIFIED IDEOGRAPH
    {0xD4CC, 0x5804}, //7644 #CJK UNIFIED IDEOGRAPH
    {0xD4CD, 0x595C}, //7645 #CJK UNIFIED IDEOGRAPH
    {0xD4CE, 0x5A60}, //7646 #CJK UNIFIED IDEOGRAPH
    {0xD4CF, 0x5A58}, //7647 #CJK UNIFIED IDEOGRAPH
    {0xD4D0, 0x5A55}, //7648 #CJK UNIFIED IDEOGRAPH
    {0xD4D1, 0x5A67}, //7649 #CJK UNIFIED IDEOGRAPH
    {0xD4D2, 0x5A5E}, //7650 #CJK UNIFIED IDEOGRAPH
    {0xD4D3, 0x5A38}, //7651 #CJK UNIFIED IDEOGRAPH
    {0xD4D4, 0x5A35}, //7652 #CJK UNIFIED IDEOGRAPH
    {0xD4D5, 0x5A6D}, //7653 #CJK UNIFIED IDEOGRAPH
    {0xD4D6, 0x5A50}, //7654 #CJK UNIFIED IDEOGRAPH
    {0xD4D7, 0x5A5F}, //7655 #CJK UNIFIED IDEOGRAPH
    {0xD4D8, 0x5A65}, //7656 #CJK UNIFIED IDEOGRAPH
    {0xD4D9, 0x5A6C}, //7657 #CJK UNIFIED IDEOGRAPH
    {0xD4DA, 0x5A53}, //7658 #CJK UNIFIED IDEOGRAPH
    {0xD4DB, 0x5A64}, //7659 #CJK UNIFIED IDEOGRAPH
    {0xD4DC, 0x5A57}, //7660 #CJK UNIFIED IDEOGRAPH
    {0xD4DD, 0x5A43}, //7661 #CJK UNIFIED IDEOGRAPH
    {0xD4DE, 0x5A5D}, //7662 #CJK UNIFIED IDEOGRAPH
    {0xD4DF, 0x5A52}, //7663 #CJK UNIFIED IDEOGRAPH
    {0xD4E0, 0x5A44}, //7664 #CJK UNIFIED IDEOGRAPH
    {0xD4E1, 0x5A5B}, //7665 #CJK UNIFIED IDEOGRAPH
    {0xD4E2, 0x5A48}, //7666 #CJK UNIFIED IDEOGRAPH
    {0xD4E3, 0x5A8E}, //7667 #CJK UNIFIED IDEOGRAPH
    {0xD4E4, 0x5A3E}, //7668 #CJK UNIFIED IDEOGRAPH
    {0xD4E5, 0x5A4D}, //7669 #CJK UNIFIED IDEOGRAPH
    {0xD4E6, 0x5A39}, //7670 #CJK UNIFIED IDEOGRAPH
    {0xD4E7, 0x5A4C}, //7671 #CJK UNIFIED IDEOGRAPH
    {0xD4E8, 0x5A70}, //7672 #CJK UNIFIED IDEOGRAPH
    {0xD4E9, 0x5A69}, //7673 #CJK UNIFIED IDEOGRAPH
    {0xD4EA, 0x5A47}, //7674 #CJK UNIFIED IDEOGRAPH
    {0xD4EB, 0x5A51}, //7675 #CJK UNIFIED IDEOGRAPH
    {0xD4EC, 0x5A56}, //7676 #CJK UNIFIED IDEOGRAPH
    {0xD4ED, 0x5A42}, //7677 #CJK UNIFIED IDEOGRAPH
    {0xD4EE, 0x5A5C}, //7678 #CJK UNIFIED IDEOGRAPH
    {0xD4EF, 0x5B72}, //7679 #CJK UNIFIED IDEOGRAPH
    {0xD4F0, 0x5B6E}, //7680 #CJK UNIFIED IDEOGRAPH
    {0xD4F1, 0x5BC1}, //7681 #CJK UNIFIED IDEOGRAPH
    {0xD4F2, 0x5BC0}, //7682 #CJK UNIFIED IDEOGRAPH
    {0xD4F3, 0x5C59}, //7683 #CJK UNIFIED IDEOGRAPH
    {0xD4F4, 0x5D1E}, //7684 #CJK UNIFIED IDEOGRAPH
    {0xD4F5, 0x5D0B}, //7685 #CJK UNIFIED IDEOGRAPH
    {0xD4F6, 0x5D1D}, //7686 #CJK UNIFIED IDEOGRAPH
    {0xD4F7, 0x5D1A}, //7687 #CJK UNIFIED IDEOGRAPH
    {0xD4F8, 0x5D20}, //7688 #CJK UNIFIED IDEOGRAPH
    {0xD4F9, 0x5D0C}, //7689 #CJK UNIFIED IDEOGRAPH
    {0xD4FA, 0x5D28}, //7690 #CJK UNIFIED IDEOGRAPH
    {0xD4FB, 0x5D0D}, //7691 #CJK UNIFIED IDEOGRAPH
    {0xD4FC, 0x5D26}, //7692 #CJK UNIFIED IDEOGRAPH
    {0xD4FD, 0x5D25}, //7693 #CJK UNIFIED IDEOGRAPH
    {0xD4FE, 0x5D0F}, //7694 #CJK UNIFIED IDEOGRAPH
    {0xD540, 0x5D30}, //7695 #CJK UNIFIED IDEOGRAPH
    {0xD541, 0x5D12}, //7696 #CJK UNIFIED IDEOGRAPH
    {0xD542, 0x5D23}, //7697 #CJK UNIFIED IDEOGRAPH
    {0xD543, 0x5D1F}, //7698 #CJK UNIFIED IDEOGRAPH
    {0xD544, 0x5D2E}, //7699 #CJK UNIFIED IDEOGRAPH
    {0xD545, 0x5E3E}, //7700 #CJK UNIFIED IDEOGRAPH
    {0xD546, 0x5E34}, //7701 #CJK UNIFIED IDEOGRAPH
    {0xD547, 0x5EB1}, //7702 #CJK UNIFIED IDEOGRAPH
    {0xD548, 0x5EB4}, //7703 #CJK UNIFIED IDEOGRAPH
    {0xD549, 0x5EB9}, //7704 #CJK UNIFIED IDEOGRAPH
    {0xD54A, 0x5EB2}, //7705 #CJK UNIFIED IDEOGRAPH
    {0xD54B, 0x5EB3}, //7706 #CJK UNIFIED IDEOGRAPH
    {0xD54C, 0x5F36}, //7707 #CJK UNIFIED IDEOGRAPH
    {0xD54D, 0x5F38}, //7708 #CJK UNIFIED IDEOGRAPH
    {0xD54E, 0x5F9B}, //7709 #CJK UNIFIED IDEOGRAPH
    {0xD54F, 0x5F96}, //7710 #CJK UNIFIED IDEOGRAPH
    {0xD550, 0x5F9F}, //7711 #CJK UNIFIED IDEOGRAPH
    {0xD551, 0x608A}, //7712 #CJK UNIFIED IDEOGRAPH
    {0xD552, 0x6090}, //7713 #CJK UNIFIED IDEOGRAPH
    {0xD553, 0x6086}, //7714 #CJK UNIFIED IDEOGRAPH
    {0xD554, 0x60BE}, //7715 #CJK UNIFIED IDEOGRAPH
    {0xD555, 0x60B0}, //7716 #CJK UNIFIED IDEOGRAPH
    {0xD556, 0x60BA}, //7717 #CJK UNIFIED IDEOGRAPH
    {0xD557, 0x60D3}, //7718 #CJK UNIFIED IDEOGRAPH
    {0xD558, 0x60D4}, //7719 #CJK UNIFIED IDEOGRAPH
    {0xD559, 0x60CF}, //7720 #CJK UNIFIED IDEOGRAPH
    {0xD55A, 0x60E4}, //7721 #CJK UNIFIED IDEOGRAPH
    {0xD55B, 0x60D9}, //7722 #CJK UNIFIED IDEOGRAPH
    {0xD55C, 0x60DD}, //7723 #CJK UNIFIED IDEOGRAPH
    {0xD55D, 0x60C8}, //7724 #CJK UNIFIED IDEOGRAPH
    {0xD55E, 0x60B1}, //7725 #CJK UNIFIED IDEOGRAPH
    {0xD55F, 0x60DB}, //7726 #CJK UNIFIED IDEOGRAPH
    {0xD560, 0x60B7}, //7727 #CJK UNIFIED IDEOGRAPH
    {0xD561, 0x60CA}, //7728 #CJK UNIFIED IDEOGRAPH
    {0xD562, 0x60BF}, //7729 #CJK UNIFIED IDEOGRAPH
    {0xD563, 0x60C3}, //7730 #CJK UNIFIED IDEOGRAPH
    {0xD564, 0x60CD}, //7731 #CJK UNIFIED IDEOGRAPH
    {0xD565, 0x60C0}, //7732 #CJK UNIFIED IDEOGRAPH
    {0xD566, 0x6332}, //7733 #CJK UNIFIED IDEOGRAPH
    {0xD567, 0x6365}, //7734 #CJK UNIFIED IDEOGRAPH
    {0xD568, 0x638A}, //7735 #CJK UNIFIED IDEOGRAPH
    {0xD569, 0x6382}, //7736 #CJK UNIFIED IDEOGRAPH
    {0xD56A, 0x637D}, //7737 #CJK UNIFIED IDEOGRAPH
    {0xD56B, 0x63BD}, //7738 #CJK UNIFIED IDEOGRAPH
    {0xD56C, 0x639E}, //7739 #CJK UNIFIED IDEOGRAPH
    {0xD56D, 0x63AD}, //7740 #CJK UNIFIED IDEOGRAPH
    {0xD56E, 0x639D}, //7741 #CJK UNIFIED IDEOGRAPH
    {0xD56F, 0x6397}, //7742 #CJK UNIFIED IDEOGRAPH
    {0xD570, 0x63AB}, //7743 #CJK UNIFIED IDEOGRAPH
    {0xD571, 0x638E}, //7744 #CJK UNIFIED IDEOGRAPH
    {0xD572, 0x636F}, //7745 #CJK UNIFIED IDEOGRAPH
    {0xD573, 0x6387}, //7746 #CJK UNIFIED IDEOGRAPH
    {0xD574, 0x6390}, //7747 #CJK UNIFIED IDEOGRAPH
    {0xD575, 0x636E}, //7748 #CJK UNIFIED IDEOGRAPH
    {0xD576, 0x63AF}, //7749 #CJK UNIFIED IDEOGRAPH
    {0xD577, 0x6375}, //7750 #CJK UNIFIED IDEOGRAPH
    {0xD578, 0x639C}, //7751 #CJK UNIFIED IDEOGRAPH
    {0xD579, 0x636D}, //7752 #CJK UNIFIED IDEOGRAPH
    {0xD57A, 0x63AE}, //7753 #CJK UNIFIED IDEOGRAPH
    {0xD57B, 0x637C}, //7754 #CJK UNIFIED IDEOGRAPH
    {0xD57C, 0x63A4}, //7755 #CJK UNIFIED IDEOGRAPH
    {0xD57D, 0x633B}, //7756 #CJK UNIFIED IDEOGRAPH
    {0xD57E, 0x639F}, //7757 #CJK UNIFIED IDEOGRAPH
    {0xD5A1, 0x6378}, //7758 #CJK UNIFIED IDEOGRAPH
    {0xD5A2, 0x6385}, //7759 #CJK UNIFIED IDEOGRAPH
    {0xD5A3, 0x6381}, //7760 #CJK UNIFIED IDEOGRAPH
    {0xD5A4, 0x6391}, //7761 #CJK UNIFIED IDEOGRAPH
    {0xD5A5, 0x638D}, //7762 #CJK UNIFIED IDEOGRAPH
    {0xD5A6, 0x6370}, //7763 #CJK UNIFIED IDEOGRAPH
    {0xD5A7, 0x6553}, //7764 #CJK UNIFIED IDEOGRAPH
    {0xD5A8, 0x65CD}, //7765 #CJK UNIFIED IDEOGRAPH
    {0xD5A9, 0x6665}, //7766 #CJK UNIFIED IDEOGRAPH
    {0xD5AA, 0x6661}, //7767 #CJK UNIFIED IDEOGRAPH
    {0xD5AB, 0x665B}, //7768 #CJK UNIFIED IDEOGRAPH
    {0xD5AC, 0x6659}, //7769 #CJK UNIFIED IDEOGRAPH
    {0xD5AD, 0x665C}, //7770 #CJK UNIFIED IDEOGRAPH
    {0xD5AE, 0x6662}, //7771 #CJK UNIFIED IDEOGRAPH
    {0xD5AF, 0x6718}, //7772 #CJK UNIFIED IDEOGRAPH
    {0xD5B0, 0x6879}, //7773 #CJK UNIFIED IDEOGRAPH
    {0xD5B1, 0x6887}, //7774 #CJK UNIFIED IDEOGRAPH
    {0xD5B2, 0x6890}, //7775 #CJK UNIFIED IDEOGRAPH
    {0xD5B3, 0x689C}, //7776 #CJK UNIFIED IDEOGRAPH
    {0xD5B4, 0x686D}, //7777 #CJK UNIFIED IDEOGRAPH
    {0xD5B5, 0x686E}, //7778 #CJK UNIFIED IDEOGRAPH
    {0xD5B6, 0x68AE}, //7779 #CJK UNIFIED IDEOGRAPH
    {0xD5B7, 0x68AB}, //7780 #CJK UNIFIED IDEOGRAPH
    {0xD5B8, 0x6956}, //7781 #CJK UNIFIED IDEOGRAPH
    {0xD5B9, 0x686F}, //7782 #CJK UNIFIED IDEOGRAPH
    {0xD5BA, 0x68A3}, //7783 #CJK UNIFIED IDEOGRAPH
    {0xD5BB, 0x68AC}, //7784 #CJK UNIFIED IDEOGRAPH
    {0xD5BC, 0x68A9}, //7785 #CJK UNIFIED IDEOGRAPH
    {0xD5BD, 0x6875}, //7786 #CJK UNIFIED IDEOGRAPH
    {0xD5BE, 0x6874}, //7787 #CJK UNIFIED IDEOGRAPH
    {0xD5BF, 0x68B2}, //7788 #CJK UNIFIED IDEOGRAPH
    {0xD5C0, 0x688F}, //7789 #CJK UNIFIED IDEOGRAPH
    {0xD5C1, 0x6877}, //7790 #CJK UNIFIED IDEOGRAPH
    {0xD5C2, 0x6892}, //7791 #CJK UNIFIED IDEOGRAPH
    {0xD5C3, 0x687C}, //7792 #CJK UNIFIED IDEOGRAPH
    {0xD5C4, 0x686B}, //7793 #CJK UNIFIED IDEOGRAPH
    {0xD5C5, 0x6872}, //7794 #CJK UNIFIED IDEOGRAPH
    {0xD5C6, 0x68AA}, //7795 #CJK UNIFIED IDEOGRAPH
    {0xD5C7, 0x6880}, //7796 #CJK UNIFIED IDEOGRAPH
    {0xD5C8, 0x6871}, //7797 #CJK UNIFIED IDEOGRAPH
    {0xD5C9, 0x687E}, //7798 #CJK UNIFIED IDEOGRAPH
    {0xD5CA, 0x689B}, //7799 #CJK UNIFIED IDEOGRAPH
    {0xD5CB, 0x6896}, //7800 #CJK UNIFIED IDEOGRAPH
    {0xD5CC, 0x688B}, //7801 #CJK UNIFIED IDEOGRAPH
    {0xD5CD, 0x68A0}, //7802 #CJK UNIFIED IDEOGRAPH
    {0xD5CE, 0x6889}, //7803 #CJK UNIFIED IDEOGRAPH
    {0xD5CF, 0x68A4}, //7804 #CJK UNIFIED IDEOGRAPH
    {0xD5D0, 0x6878}, //7805 #CJK UNIFIED IDEOGRAPH
    {0xD5D1, 0x687B}, //7806 #CJK UNIFIED IDEOGRAPH
    {0xD5D2, 0x6891}, //7807 #CJK UNIFIED IDEOGRAPH
    {0xD5D3, 0x688C}, //7808 #CJK UNIFIED IDEOGRAPH
    {0xD5D4, 0x688A}, //7809 #CJK UNIFIED IDEOGRAPH
    {0xD5D5, 0x687D}, //7810 #CJK UNIFIED IDEOGRAPH
    {0xD5D6, 0x6B36}, //7811 #CJK UNIFIED IDEOGRAPH
    {0xD5D7, 0x6B33}, //7812 #CJK UNIFIED IDEOGRAPH
    {0xD5D8, 0x6B37}, //7813 #CJK UNIFIED IDEOGRAPH
    {0xD5D9, 0x6B38}, //7814 #CJK UNIFIED IDEOGRAPH
    {0xD5DA, 0x6B91}, //7815 #CJK UNIFIED IDEOGRAPH
    {0xD5DB, 0x6B8F}, //7816 #CJK UNIFIED IDEOGRAPH
    {0xD5DC, 0x6B8D}, //7817 #CJK UNIFIED IDEOGRAPH
    {0xD5DD, 0x6B8E}, //7818 #CJK UNIFIED IDEOGRAPH
    {0xD5DE, 0x6B8C}, //7819 #CJK UNIFIED IDEOGRAPH
    {0xD5DF, 0x6C2A}, //7820 #CJK UNIFIED IDEOGRAPH
    {0xD5E0, 0x6DC0}, //7821 #CJK UNIFIED IDEOGRAPH
    {0xD5E1, 0x6DAB}, //7822 #CJK UNIFIED IDEOGRAPH
    {0xD5E2, 0x6DB4}, //7823 #CJK UNIFIED IDEOGRAPH
    {0xD5E3, 0x6DB3}, //7824 #CJK UNIFIED IDEOGRAPH
    {0xD5E4, 0x6E74}, //7825 #CJK UNIFIED IDEOGRAPH
    {0xD5E5, 0x6DAC}, //7826 #CJK UNIFIED IDEOGRAPH
    {0xD5E6, 0x6DE9}, //7827 #CJK UNIFIED IDEOGRAPH
    {0xD5E7, 0x6DE2}, //7828 #CJK UNIFIED IDEOGRAPH
    {0xD5E8, 0x6DB7}, //7829 #CJK UNIFIED IDEOGRAPH
    {0xD5E9, 0x6DF6}, //7830 #CJK UNIFIED IDEOGRAPH
    {0xD5EA, 0x6DD4}, //7831 #CJK UNIFIED IDEOGRAPH
    {0xD5EB, 0x6E00}, //7832 #CJK UNIFIED IDEOGRAPH
    {0xD5EC, 0x6DC8}, //7833 #CJK UNIFIED IDEOGRAPH
    {0xD5ED, 0x6DE0}, //7834 #CJK UNIFIED IDEOGRAPH
    {0xD5EE, 0x6DDF}, //7835 #CJK UNIFIED IDEOGRAPH
    {0xD5EF, 0x6DD6}, //7836 #CJK UNIFIED IDEOGRAPH
    {0xD5F0, 0x6DBE}, //7837 #CJK UNIFIED IDEOGRAPH
    {0xD5F1, 0x6DE5}, //7838 #CJK UNIFIED IDEOGRAPH
    {0xD5F2, 0x6DDC}, //7839 #CJK UNIFIED IDEOGRAPH
    {0xD5F3, 0x6DDD}, //7840 #CJK UNIFIED IDEOGRAPH
    {0xD5F4, 0x6DDB}, //7841 #CJK UNIFIED IDEOGRAPH
    {0xD5F5, 0x6DF4}, //7842 #CJK UNIFIED IDEOGRAPH
    {0xD5F6, 0x6DCA}, //7843 #CJK UNIFIED IDEOGRAPH
    {0xD5F7, 0x6DBD}, //7844 #CJK UNIFIED IDEOGRAPH
    {0xD5F8, 0x6DED}, //7845 #CJK UNIFIED IDEOGRAPH
    {0xD5F9, 0x6DF0}, //7846 #CJK UNIFIED IDEOGRAPH
    {0xD5FA, 0x6DBA}, //7847 #CJK UNIFIED IDEOGRAPH
    {0xD5FB, 0x6DD5}, //7848 #CJK UNIFIED IDEOGRAPH
    {0xD5FC, 0x6DC2}, //7849 #CJK UNIFIED IDEOGRAPH
    {0xD5FD, 0x6DCF}, //7850 #CJK UNIFIED IDEOGRAPH
    {0xD5FE, 0x6DC9}, //7851 #CJK UNIFIED IDEOGRAPH
    {0xD640, 0x6DD0}, //7852 #CJK UNIFIED IDEOGRAPH
    {0xD641, 0x6DF2}, //7853 #CJK UNIFIED IDEOGRAPH
    {0xD642, 0x6DD3}, //7854 #CJK UNIFIED IDEOGRAPH
    {0xD643, 0x6DFD}, //7855 #CJK UNIFIED IDEOGRAPH
    {0xD644, 0x6DD7}, //7856 #CJK UNIFIED IDEOGRAPH
    {0xD645, 0x6DCD}, //7857 #CJK UNIFIED IDEOGRAPH
    {0xD646, 0x6DE3}, //7858 #CJK UNIFIED IDEOGRAPH
    {0xD647, 0x6DBB}, //7859 #CJK UNIFIED IDEOGRAPH
    {0xD648, 0x70FA}, //7860 #CJK UNIFIED IDEOGRAPH
    {0xD649, 0x710D}, //7861 #CJK UNIFIED IDEOGRAPH
    {0xD64A, 0x70F7}, //7862 #CJK UNIFIED IDEOGRAPH
    {0xD64B, 0x7117}, //7863 #CJK UNIFIED IDEOGRAPH
    {0xD64C, 0x70F4}, //7864 #CJK UNIFIED IDEOGRAPH
    {0xD64D, 0x710C}, //7865 #CJK UNIFIED IDEOGRAPH
    {0xD64E, 0x70F0}, //7866 #CJK UNIFIED IDEOGRAPH
    {0xD64F, 0x7104}, //7867 #CJK UNIFIED IDEOGRAPH
    {0xD650, 0x70F3}, //7868 #CJK UNIFIED IDEOGRAPH
    {0xD651, 0x7110}, //7869 #CJK UNIFIED IDEOGRAPH
    {0xD652, 0x70FC}, //7870 #CJK UNIFIED IDEOGRAPH
    {0xD653, 0x70FF}, //7871 #CJK UNIFIED IDEOGRAPH
    {0xD654, 0x7106}, //7872 #CJK UNIFIED IDEOGRAPH
    {0xD655, 0x7113}, //7873 #CJK UNIFIED IDEOGRAPH
    {0xD656, 0x7100}, //7874 #CJK UNIFIED IDEOGRAPH
    {0xD657, 0x70F8}, //7875 #CJK UNIFIED IDEOGRAPH
    {0xD658, 0x70F6}, //7876 #CJK UNIFIED IDEOGRAPH
    {0xD659, 0x710B}, //7877 #CJK UNIFIED IDEOGRAPH
    {0xD65A, 0x7102}, //7878 #CJK UNIFIED IDEOGRAPH
    {0xD65B, 0x710E}, //7879 #CJK UNIFIED IDEOGRAPH
    {0xD65C, 0x727E}, //7880 #CJK UNIFIED IDEOGRAPH
    {0xD65D, 0x727B}, //7881 #CJK UNIFIED IDEOGRAPH
    {0xD65E, 0x727C}, //7882 #CJK UNIFIED IDEOGRAPH
    {0xD65F, 0x727F}, //7883 #CJK UNIFIED IDEOGRAPH
    {0xD660, 0x731D}, //7884 #CJK UNIFIED IDEOGRAPH
    {0xD661, 0x7317}, //7885 #CJK UNIFIED IDEOGRAPH
    {0xD662, 0x7307}, //7886 #CJK UNIFIED IDEOGRAPH
    {0xD663, 0x7311}, //7887 #CJK UNIFIED IDEOGRAPH
    {0xD664, 0x7318}, //7888 #CJK UNIFIED IDEOGRAPH
    {0xD665, 0x730A}, //7889 #CJK UNIFIED IDEOGRAPH
    {0xD666, 0x7308}, //7890 #CJK UNIFIED IDEOGRAPH
    {0xD667, 0x72FF}, //7891 #CJK UNIFIED IDEOGRAPH
    {0xD668, 0x730F}, //7892 #CJK UNIFIED IDEOGRAPH
    {0xD669, 0x731E}, //7893 #CJK UNIFIED IDEOGRAPH
    {0xD66A, 0x7388}, //7894 #CJK UNIFIED IDEOGRAPH
    {0xD66B, 0x73F6}, //7895 #CJK UNIFIED IDEOGRAPH
    {0xD66C, 0x73F8}, //7896 #CJK UNIFIED IDEOGRAPH
    {0xD66D, 0x73F5}, //7897 #CJK UNIFIED IDEOGRAPH
    {0xD66E, 0x7404}, //7898 #CJK UNIFIED IDEOGRAPH
    {0xD66F, 0x7401}, //7899 #CJK UNIFIED IDEOGRAPH
    {0xD670, 0x73FD}, //7900 #CJK UNIFIED IDEOGRAPH
    {0xD671, 0x7407}, //7901 #CJK UNIFIED IDEOGRAPH
    {0xD672, 0x7400}, //7902 #CJK UNIFIED IDEOGRAPH
    {0xD673, 0x73FA}, //7903 #CJK UNIFIED IDEOGRAPH
    {0xD674, 0x73FC}, //7904 #CJK UNIFIED IDEOGRAPH
    {0xD675, 0x73FF}, //7905 #CJK UNIFIED IDEOGRAPH
    {0xD676, 0x740C}, //7906 #CJK UNIFIED IDEOGRAPH
    {0xD677, 0x740B}, //7907 #CJK UNIFIED IDEOGRAPH
    {0xD678, 0x73F4}, //7908 #CJK UNIFIED IDEOGRAPH
    {0xD679, 0x7408}, //7909 #CJK UNIFIED IDEOGRAPH
    {0xD67A, 0x7564}, //7910 #CJK UNIFIED IDEOGRAPH
    {0xD67B, 0x7563}, //7911 #CJK UNIFIED IDEOGRAPH
    {0xD67C, 0x75CE}, //7912 #CJK UNIFIED IDEOGRAPH
    {0xD67D, 0x75D2}, //7913 #CJK UNIFIED IDEOGRAPH
    {0xD67E, 0x75CF}, //7914 #CJK UNIFIED IDEOGRAPH
    {0xD6A1, 0x75CB}, //7915 #CJK UNIFIED IDEOGRAPH
    {0xD6A2, 0x75CC}, //7916 #CJK UNIFIED IDEOGRAPH
    {0xD6A3, 0x75D1}, //7917 #CJK UNIFIED IDEOGRAPH
    {0xD6A4, 0x75D0}, //7918 #CJK UNIFIED IDEOGRAPH
    {0xD6A5, 0x768F}, //7919 #CJK UNIFIED IDEOGRAPH
    {0xD6A6, 0x7689}, //7920 #CJK UNIFIED IDEOGRAPH
    {0xD6A7, 0x76D3}, //7921 #CJK UNIFIED IDEOGRAPH
    {0xD6A8, 0x7739}, //7922 #CJK UNIFIED IDEOGRAPH
    {0xD6A9, 0x772F}, //7923 #CJK UNIFIED IDEOGRAPH
    {0xD6AA, 0x772D}, //7924 #CJK UNIFIED IDEOGRAPH
    {0xD6AB, 0x7731}, //7925 #CJK UNIFIED IDEOGRAPH
    {0xD6AC, 0x7732}, //7926 #CJK UNIFIED IDEOGRAPH
    {0xD6AD, 0x7734}, //7927 #CJK UNIFIED IDEOGRAPH
    {0xD6AE, 0x7733}, //7928 #CJK UNIFIED IDEOGRAPH
    {0xD6AF, 0x773D}, //7929 #CJK UNIFIED IDEOGRAPH
    {0xD6B0, 0x7725}, //7930 #CJK UNIFIED IDEOGRAPH
    {0xD6B1, 0x773B}, //7931 #CJK UNIFIED IDEOGRAPH
    {0xD6B2, 0x7735}, //7932 #CJK UNIFIED IDEOGRAPH
    {0xD6B3, 0x7848}, //7933 #CJK UNIFIED IDEOGRAPH
    {0xD6B4, 0x7852}, //7934 #CJK UNIFIED IDEOGRAPH
    {0xD6B5, 0x7849}, //7935 #CJK UNIFIED IDEOGRAPH
    {0xD6B6, 0x784D}, //7936 #CJK UNIFIED IDEOGRAPH
    {0xD6B7, 0x784A}, //7937 #CJK UNIFIED IDEOGRAPH
    {0xD6B8, 0x784C}, //7938 #CJK UNIFIED IDEOGRAPH
    {0xD6B9, 0x7826}, //7939 #CJK UNIFIED IDEOGRAPH
    {0xD6BA, 0x7845}, //7940 #CJK UNIFIED IDEOGRAPH
    {0xD6BB, 0x7850}, //7941 #CJK UNIFIED IDEOGRAPH
    {0xD6BC, 0x7964}, //7942 #CJK UNIFIED IDEOGRAPH
    {0xD6BD, 0x7967}, //7943 #CJK UNIFIED IDEOGRAPH
    {0xD6BE, 0x7969}, //7944 #CJK UNIFIED IDEOGRAPH
    {0xD6BF, 0x796A}, //7945 #CJK UNIFIED IDEOGRAPH
    {0xD6C0, 0x7963}, //7946 #CJK UNIFIED IDEOGRAPH
    {0xD6C1, 0x796B}, //7947 #CJK UNIFIED IDEOGRAPH
    {0xD6C2, 0x7961}, //7948 #CJK UNIFIED IDEOGRAPH
    {0xD6C3, 0x79BB}, //7949 #CJK UNIFIED IDEOGRAPH
    {0xD6C4, 0x79FA}, //7950 #CJK UNIFIED IDEOGRAPH
    {0xD6C5, 0x79F8}, //7951 #CJK UNIFIED IDEOGRAPH
    {0xD6C6, 0x79F6}, //7952 #CJK UNIFIED IDEOGRAPH
    {0xD6C7, 0x79F7}, //7953 #CJK UNIFIED IDEOGRAPH
    {0xD6C8, 0x7A8F}, //7954 #CJK UNIFIED IDEOGRAPH
    {0xD6C9, 0x7A94}, //7955 #CJK UNIFIED IDEOGRAPH
    {0xD6CA, 0x7A90}, //7956 #CJK UNIFIED IDEOGRAPH
    {0xD6CB, 0x7B35}, //7957 #CJK UNIFIED IDEOGRAPH
    {0xD6CC, 0x7B47}, //7958 #CJK UNIFIED IDEOGRAPH
    {0xD6CD, 0x7B34}, //7959 #CJK UNIFIED IDEOGRAPH
    {0xD6CE, 0x7B25}, //7960 #CJK UNIFIED IDEOGRAPH
    {0xD6CF, 0x7B30}, //7961 #CJK UNIFIED IDEOGRAPH
    {0xD6D0, 0x7B22}, //7962 #CJK UNIFIED IDEOGRAPH
    {0xD6D1, 0x7B24}, //7963 #CJK UNIFIED IDEOGRAPH
    {0xD6D2, 0x7B33}, //7964 #CJK UNIFIED IDEOGRAPH
    {0xD6D3, 0x7B18}, //7965 #CJK UNIFIED IDEOGRAPH
    {0xD6D4, 0x7B2A}, //7966 #CJK UNIFIED IDEOGRAPH
    {0xD6D5, 0x7B1D}, //7967 #CJK UNIFIED IDEOGRAPH
    {0xD6D6, 0x7B31}, //7968 #CJK UNIFIED IDEOGRAPH
    {0xD6D7, 0x7B2B}, //7969 #CJK UNIFIED IDEOGRAPH
    {0xD6D8, 0x7B2D}, //7970 #CJK UNIFIED IDEOGRAPH
    {0xD6D9, 0x7B2F}, //7971 #CJK UNIFIED IDEOGRAPH
    {0xD6DA, 0x7B32}, //7972 #CJK UNIFIED IDEOGRAPH
    {0xD6DB, 0x7B38}, //7973 #CJK UNIFIED IDEOGRAPH
    {0xD6DC, 0x7B1A}, //7974 #CJK UNIFIED IDEOGRAPH
    {0xD6DD, 0x7B23}, //7975 #CJK UNIFIED IDEOGRAPH
    {0xD6DE, 0x7C94}, //7976 #CJK UNIFIED IDEOGRAPH
    {0xD6DF, 0x7C98}, //7977 #CJK UNIFIED IDEOGRAPH
    {0xD6E0, 0x7C96}, //7978 #CJK UNIFIED IDEOGRAPH
    {0xD6E1, 0x7CA3}, //7979 #CJK UNIFIED IDEOGRAPH
    {0xD6E2, 0x7D35}, //7980 #CJK UNIFIED IDEOGRAPH
    {0xD6E3, 0x7D3D}, //7981 #CJK UNIFIED IDEOGRAPH
    {0xD6E4, 0x7D38}, //7982 #CJK UNIFIED IDEOGRAPH
    {0xD6E5, 0x7D36}, //7983 #CJK UNIFIED IDEOGRAPH
    {0xD6E6, 0x7D3A}, //7984 #CJK UNIFIED IDEOGRAPH
    {0xD6E7, 0x7D45}, //7985 #CJK UNIFIED IDEOGRAPH
    {0xD6E8, 0x7D2C}, //7986 #CJK UNIFIED IDEOGRAPH
    {0xD6E9, 0x7D29}, //7987 #CJK UNIFIED IDEOGRAPH
    {0xD6EA, 0x7D41}, //7988 #CJK UNIFIED IDEOGRAPH
    {0xD6EB, 0x7D47}, //7989 #CJK UNIFIED IDEOGRAPH
    {0xD6EC, 0x7D3E}, //7990 #CJK UNIFIED IDEOGRAPH
    {0xD6ED, 0x7D3F}, //7991 #CJK UNIFIED IDEOGRAPH
    {0xD6EE, 0x7D4A}, //7992 #CJK UNIFIED IDEOGRAPH
    {0xD6EF, 0x7D3B}, //7993 #CJK UNIFIED IDEOGRAPH
    {0xD6F0, 0x7D28}, //7994 #CJK UNIFIED IDEOGRAPH
    {0xD6F1, 0x7F63}, //7995 #CJK UNIFIED IDEOGRAPH
    {0xD6F2, 0x7F95}, //7996 #CJK UNIFIED IDEOGRAPH
    {0xD6F3, 0x7F9C}, //7997 #CJK UNIFIED IDEOGRAPH
    {0xD6F4, 0x7F9D}, //7998 #CJK UNIFIED IDEOGRAPH
    {0xD6F5, 0x7F9B}, //7999 #CJK UNIFIED IDEOGRAPH
    {0xD6F6, 0x7FCA}, //8000 #CJK UNIFIED IDEOGRAPH
    {0xD6F7, 0x7FCB}, //8001 #CJK UNIFIED IDEOGRAPH
    {0xD6F8, 0x7FCD}, //8002 #CJK UNIFIED IDEOGRAPH
    {0xD6F9, 0x7FD0}, //8003 #CJK UNIFIED IDEOGRAPH
    {0xD6FA, 0x7FD1}, //8004 #CJK UNIFIED IDEOGRAPH
    {0xD6FB, 0x7FC7}, //8005 #CJK UNIFIED IDEOGRAPH
    {0xD6FC, 0x7FCF}, //8006 #CJK UNIFIED IDEOGRAPH
    {0xD6FD, 0x7FC9}, //8007 #CJK UNIFIED IDEOGRAPH
    {0xD6FE, 0x801F}, //8008 #CJK UNIFIED IDEOGRAPH
    {0xD740, 0x801E}, //8009 #CJK UNIFIED IDEOGRAPH
    {0xD741, 0x801B}, //8010 #CJK UNIFIED IDEOGRAPH
    {0xD742, 0x8047}, //8011 #CJK UNIFIED IDEOGRAPH
    {0xD743, 0x8043}, //8012 #CJK UNIFIED IDEOGRAPH
    {0xD744, 0x8048}, //8013 #CJK UNIFIED IDEOGRAPH
    {0xD745, 0x8118}, //8014 #CJK UNIFIED IDEOGRAPH
    {0xD746, 0x8125}, //8015 #CJK UNIFIED IDEOGRAPH
    {0xD747, 0x8119}, //8016 #CJK UNIFIED IDEOGRAPH
    {0xD748, 0x811B}, //8017 #CJK UNIFIED IDEOGRAPH
    {0xD749, 0x812D}, //8018 #CJK UNIFIED IDEOGRAPH
    {0xD74A, 0x811F}, //8019 #CJK UNIFIED IDEOGRAPH
    {0xD74B, 0x812C}, //8020 #CJK UNIFIED IDEOGRAPH
    {0xD74C, 0x811E}, //8021 #CJK UNIFIED IDEOGRAPH
    {0xD74D, 0x8121}, //8022 #CJK UNIFIED IDEOGRAPH
    {0xD74E, 0x8115}, //8023 #CJK UNIFIED IDEOGRAPH
    {0xD74F, 0x8127}, //8024 #CJK UNIFIED IDEOGRAPH
    {0xD750, 0x811D}, //8025 #CJK UNIFIED IDEOGRAPH
    {0xD751, 0x8122}, //8026 #CJK UNIFIED IDEOGRAPH
    {0xD752, 0x8211}, //8027 #CJK UNIFIED IDEOGRAPH
    {0xD753, 0x8238}, //8028 #CJK UNIFIED IDEOGRAPH
    {0xD754, 0x8233}, //8029 #CJK UNIFIED IDEOGRAPH
    {0xD755, 0x823A}, //8030 #CJK UNIFIED IDEOGRAPH
    {0xD756, 0x8234}, //8031 #CJK UNIFIED IDEOGRAPH
    {0xD757, 0x8232}, //8032 #CJK UNIFIED IDEOGRAPH
    {0xD758, 0x8274}, //8033 #CJK UNIFIED IDEOGRAPH
    {0xD759, 0x8390}, //8034 #CJK UNIFIED IDEOGRAPH
    {0xD75A, 0x83A3}, //8035 #CJK UNIFIED IDEOGRAPH
    {0xD75B, 0x83A8}, //8036 #CJK UNIFIED IDEOGRAPH
    {0xD75C, 0x838D}, //8037 #CJK UNIFIED IDEOGRAPH
    {0xD75D, 0x837A}, //8038 #CJK UNIFIED IDEOGRAPH
    {0xD75E, 0x8373}, //8039 #CJK UNIFIED IDEOGRAPH
    {0xD75F, 0x83A4}, //8040 #CJK UNIFIED IDEOGRAPH
    {0xD760, 0x8374}, //8041 #CJK UNIFIED IDEOGRAPH
    {0xD761, 0x838F}, //8042 #CJK UNIFIED IDEOGRAPH
    {0xD762, 0x8381}, //8043 #CJK UNIFIED IDEOGRAPH
    {0xD763, 0x8395}, //8044 #CJK UNIFIED IDEOGRAPH
    {0xD764, 0x8399}, //8045 #CJK UNIFIED IDEOGRAPH
    {0xD765, 0x8375}, //8046 #CJK UNIFIED IDEOGRAPH
    {0xD766, 0x8394}, //8047 #CJK UNIFIED IDEOGRAPH
    {0xD767, 0x83A9}, //8048 #CJK UNIFIED IDEOGRAPH
    {0xD768, 0x837D}, //8049 #CJK UNIFIED IDEOGRAPH
    {0xD769, 0x8383}, //8050 #CJK UNIFIED IDEOGRAPH
    {0xD76A, 0x838C}, //8051 #CJK UNIFIED IDEOGRAPH
    {0xD76B, 0x839D}, //8052 #CJK UNIFIED IDEOGRAPH
    {0xD76C, 0x839B}, //8053 #CJK UNIFIED IDEOGRAPH
    {0xD76D, 0x83AA}, //8054 #CJK UNIFIED IDEOGRAPH
    {0xD76E, 0x838B}, //8055 #CJK UNIFIED IDEOGRAPH
    {0xD76F, 0x837E}, //8056 #CJK UNIFIED IDEOGRAPH
    {0xD770, 0x83A5}, //8057 #CJK UNIFIED IDEOGRAPH
    {0xD771, 0x83AF}, //8058 #CJK UNIFIED IDEOGRAPH
    {0xD772, 0x8388}, //8059 #CJK UNIFIED IDEOGRAPH
    {0xD773, 0x8397}, //8060 #CJK UNIFIED IDEOGRAPH
    {0xD774, 0x83B0}, //8061 #CJK UNIFIED IDEOGRAPH
    {0xD775, 0x837F}, //8062 #CJK UNIFIED IDEOGRAPH
    {0xD776, 0x83A6}, //8063 #CJK UNIFIED IDEOGRAPH
    {0xD777, 0x8387}, //8064 #CJK UNIFIED IDEOGRAPH
    {0xD778, 0x83AE}, //8065 #CJK UNIFIED IDEOGRAPH
    {0xD779, 0x8376}, //8066 #CJK UNIFIED IDEOGRAPH
    {0xD77A, 0x839A}, //8067 #CJK UNIFIED IDEOGRAPH
    {0xD77B, 0x8659}, //8068 #CJK UNIFIED IDEOGRAPH
    {0xD77C, 0x8656}, //8069 #CJK UNIFIED IDEOGRAPH
    {0xD77D, 0x86BF}, //8070 #CJK UNIFIED IDEOGRAPH
    {0xD77E, 0x86B7}, //8071 #CJK UNIFIED IDEOGRAPH
    {0xD7A1, 0x86C2}, //8072 #CJK UNIFIED IDEOGRAPH
    {0xD7A2, 0x86C1}, //8073 #CJK UNIFIED IDEOGRAPH
    {0xD7A3, 0x86C5}, //8074 #CJK UNIFIED IDEOGRAPH
    {0xD7A4, 0x86BA}, //8075 #CJK UNIFIED IDEOGRAPH
    {0xD7A5, 0x86B0}, //8076 #CJK UNIFIED IDEOGRAPH
    {0xD7A6, 0x86C8}, //8077 #CJK UNIFIED IDEOGRAPH
    {0xD7A7, 0x86B9}, //8078 #CJK UNIFIED IDEOGRAPH
    {0xD7A8, 0x86B3}, //8079 #CJK UNIFIED IDEOGRAPH
    {0xD7A9, 0x86B8}, //8080 #CJK UNIFIED IDEOGRAPH
    {0xD7AA, 0x86CC}, //8081 #CJK UNIFIED IDEOGRAPH
    {0xD7AB, 0x86B4}, //8082 #CJK UNIFIED IDEOGRAPH
    {0xD7AC, 0x86BB}, //8083 #CJK UNIFIED IDEOGRAPH
    {0xD7AD, 0x86BC}, //8084 #CJK UNIFIED IDEOGRAPH
    {0xD7AE, 0x86C3}, //8085 #CJK UNIFIED IDEOGRAPH
    {0xD7AF, 0x86BD}, //8086 #CJK UNIFIED IDEOGRAPH
    {0xD7B0, 0x86BE}, //8087 #CJK UNIFIED IDEOGRAPH
    {0xD7B1, 0x8852}, //8088 #CJK UNIFIED IDEOGRAPH
    {0xD7B2, 0x8889}, //8089 #CJK UNIFIED IDEOGRAPH
    {0xD7B3, 0x8895}, //8090 #CJK UNIFIED IDEOGRAPH
    {0xD7B4, 0x88A8}, //8091 #CJK UNIFIED IDEOGRAPH
    {0xD7B5, 0x88A2}, //8092 #CJK UNIFIED IDEOGRAPH
    {0xD7B6, 0x88AA}, //8093 #CJK UNIFIED IDEOGRAPH
    {0xD7B7, 0x889A}, //8094 #CJK UNIFIED IDEOGRAPH
    {0xD7B8, 0x8891}, //8095 #CJK UNIFIED IDEOGRAPH
    {0xD7B9, 0x88A1}, //8096 #CJK UNIFIED IDEOGRAPH
    {0xD7BA, 0x889F}, //8097 #CJK UNIFIED IDEOGRAPH
    {0xD7BB, 0x8898}, //8098 #CJK UNIFIED IDEOGRAPH
    {0xD7BC, 0x88A7}, //8099 #CJK UNIFIED IDEOGRAPH
    {0xD7BD, 0x8899}, //8100 #CJK UNIFIED IDEOGRAPH
    {0xD7BE, 0x889B}, //8101 #CJK UNIFIED IDEOGRAPH
    {0xD7BF, 0x8897}, //8102 #CJK UNIFIED IDEOGRAPH
    {0xD7C0, 0x88A4}, //8103 #CJK UNIFIED IDEOGRAPH
    {0xD7C1, 0x88AC}, //8104 #CJK UNIFIED IDEOGRAPH
    {0xD7C2, 0x888C}, //8105 #CJK UNIFIED IDEOGRAPH
    {0xD7C3, 0x8893}, //8106 #CJK UNIFIED IDEOGRAPH
    {0xD7C4, 0x888E}, //8107 #CJK UNIFIED IDEOGRAPH
    {0xD7C5, 0x8982}, //8108 #CJK UNIFIED IDEOGRAPH
    {0xD7C6, 0x89D6}, //8109 #CJK UNIFIED IDEOGRAPH
    {0xD7C7, 0x89D9}, //8110 #CJK UNIFIED IDEOGRAPH
    {0xD7C8, 0x89D5}, //8111 #CJK UNIFIED IDEOGRAPH
    {0xD7C9, 0x8A30}, //8112 #CJK UNIFIED IDEOGRAPH
    {0xD7CA, 0x8A27}, //8113 #CJK UNIFIED IDEOGRAPH
    {0xD7CB, 0x8A2C}, //8114 #CJK UNIFIED IDEOGRAPH
    {0xD7CC, 0x8A1E}, //8115 #CJK UNIFIED IDEOGRAPH
    {0xD7CD, 0x8C39}, //8116 #CJK UNIFIED IDEOGRAPH
    {0xD7CE, 0x8C3B}, //8117 #CJK UNIFIED IDEOGRAPH
    {0xD7CF, 0x8C5C}, //8118 #CJK UNIFIED IDEOGRAPH
    {0xD7D0, 0x8C5D}, //8119 #CJK UNIFIED IDEOGRAPH
    {0xD7D1, 0x8C7D}, //8120 #CJK UNIFIED IDEOGRAPH
    {0xD7D2, 0x8CA5}, //8121 #CJK UNIFIED IDEOGRAPH
    {0xD7D3, 0x8D7D}, //8122 #CJK UNIFIED IDEOGRAPH
    {0xD7D4, 0x8D7B}, //8123 #CJK UNIFIED IDEOGRAPH
    {0xD7D5, 0x8D79}, //8124 #CJK UNIFIED IDEOGRAPH
    {0xD7D6, 0x8DBC}, //8125 #CJK UNIFIED IDEOGRAPH
    {0xD7D7, 0x8DC2}, //8126 #CJK UNIFIED IDEOGRAPH
    {0xD7D8, 0x8DB9}, //8127 #CJK UNIFIED IDEOGRAPH
    {0xD7D9, 0x8DBF}, //8128 #CJK UNIFIED IDEOGRAPH
    {0xD7DA, 0x8DC1}, //8129 #CJK UNIFIED IDEOGRAPH
    {0xD7DB, 0x8ED8}, //8130 #CJK UNIFIED IDEOGRAPH
    {0xD7DC, 0x8EDE}, //8131 #CJK UNIFIED IDEOGRAPH
    {0xD7DD, 0x8EDD}, //8132 #CJK UNIFIED IDEOGRAPH
    {0xD7DE, 0x8EDC}, //8133 #CJK UNIFIED IDEOGRAPH
    {0xD7DF, 0x8ED7}, //8134 #CJK UNIFIED IDEOGRAPH
    {0xD7E0, 0x8EE0}, //8135 #CJK UNIFIED IDEOGRAPH
    {0xD7E1, 0x8EE1}, //8136 #CJK UNIFIED IDEOGRAPH
    {0xD7E2, 0x9024}, //8137 #CJK UNIFIED IDEOGRAPH
    {0xD7E3, 0x900B}, //8138 #CJK UNIFIED IDEOGRAPH
    {0xD7E4, 0x9011}, //8139 #CJK UNIFIED IDEOGRAPH
    {0xD7E5, 0x901C}, //8140 #CJK UNIFIED IDEOGRAPH
    {0xD7E6, 0x900C}, //8141 #CJK UNIFIED IDEOGRAPH
    {0xD7E7, 0x9021}, //8142 #CJK UNIFIED IDEOGRAPH
    {0xD7E8, 0x90EF}, //8143 #CJK UNIFIED IDEOGRAPH
    {0xD7E9, 0x90EA}, //8144 #CJK UNIFIED IDEOGRAPH
    {0xD7EA, 0x90F0}, //8145 #CJK UNIFIED IDEOGRAPH
    {0xD7EB, 0x90F4}, //8146 #CJK UNIFIED IDEOGRAPH
    {0xD7EC, 0x90F2}, //8147 #CJK UNIFIED IDEOGRAPH
    {0xD7ED, 0x90F3}, //8148 #CJK UNIFIED IDEOGRAPH
    {0xD7EE, 0x90D4}, //8149 #CJK UNIFIED IDEOGRAPH
    {0xD7EF, 0x90EB}, //8150 #CJK UNIFIED IDEOGRAPH
    {0xD7F0, 0x90EC}, //8151 #CJK UNIFIED IDEOGRAPH
    {0xD7F1, 0x90E9}, //8152 #CJK UNIFIED IDEOGRAPH
    {0xD7F2, 0x9156}, //8153 #CJK UNIFIED IDEOGRAPH
    {0xD7F3, 0x9158}, //8154 #CJK UNIFIED IDEOGRAPH
    {0xD7F4, 0x915A}, //8155 #CJK UNIFIED IDEOGRAPH
    {0xD7F5, 0x9153}, //8156 #CJK UNIFIED IDEOGRAPH
    {0xD7F6, 0x9155}, //8157 #CJK UNIFIED IDEOGRAPH
    {0xD7F7, 0x91EC}, //8158 #CJK UNIFIED IDEOGRAPH
    {0xD7F8, 0x91F4}, //8159 #CJK UNIFIED IDEOGRAPH
    {0xD7F9, 0x91F1}, //8160 #CJK UNIFIED IDEOGRAPH
    {0xD7FA, 0x91F3}, //8161 #CJK UNIFIED IDEOGRAPH
    {0xD7FB, 0x91F8}, //8162 #CJK UNIFIED IDEOGRAPH
    {0xD7FC, 0x91E4}, //8163 #CJK UNIFIED IDEOGRAPH
    {0xD7FD, 0x91F9}, //8164 #CJK UNIFIED IDEOGRAPH
    {0xD7FE, 0x91EA}, //8165 #CJK UNIFIED IDEOGRAPH
    {0xD840, 0x91EB}, //8166 #CJK UNIFIED IDEOGRAPH
    {0xD841, 0x91F7}, //8167 #CJK UNIFIED IDEOGRAPH
    {0xD842, 0x91E8}, //8168 #CJK UNIFIED IDEOGRAPH
    {0xD843, 0x91EE}, //8169 #CJK UNIFIED IDEOGRAPH
    {0xD844, 0x957A}, //8170 #CJK UNIFIED IDEOGRAPH
    {0xD845, 0x9586}, //8171 #CJK UNIFIED IDEOGRAPH
    {0xD846, 0x9588}, //8172 #CJK UNIFIED IDEOGRAPH
    {0xD847, 0x967C}, //8173 #CJK UNIFIED IDEOGRAPH
    {0xD848, 0x966D}, //8174 #CJK UNIFIED IDEOGRAPH
    {0xD849, 0x966B}, //8175 #CJK UNIFIED IDEOGRAPH
    {0xD84A, 0x9671}, //8176 #CJK UNIFIED IDEOGRAPH
    {0xD84B, 0x966F}, //8177 #CJK UNIFIED IDEOGRAPH
    {0xD84C, 0x96BF}, //8178 #CJK UNIFIED IDEOGRAPH
    {0xD84D, 0x976A}, //8179 #CJK UNIFIED IDEOGRAPH
    {0xD84E, 0x9804}, //8180 #CJK UNIFIED IDEOGRAPH
    {0xD84F, 0x98E5}, //8181 #CJK UNIFIED IDEOGRAPH
    {0xD850, 0x9997}, //8182 #CJK UNIFIED IDEOGRAPH
    {0xD851, 0x509B}, //8183 #CJK UNIFIED IDEOGRAPH
    {0xD852, 0x5095}, //8184 #CJK UNIFIED IDEOGRAPH
    {0xD853, 0x5094}, //8185 #CJK UNIFIED IDEOGRAPH
    {0xD854, 0x509E}, //8186 #CJK UNIFIED IDEOGRAPH
    {0xD855, 0x508B}, //8187 #CJK UNIFIED IDEOGRAPH
    {0xD856, 0x50A3}, //8188 #CJK UNIFIED IDEOGRAPH
    {0xD857, 0x5083}, //8189 #CJK UNIFIED IDEOGRAPH
    {0xD858, 0x508C}, //8190 #CJK UNIFIED IDEOGRAPH
    {0xD859, 0x508E}, //8191 #CJK UNIFIED IDEOGRAPH
    {0xD85A, 0x509D}, //8192 #CJK UNIFIED IDEOGRAPH
    {0xD85B, 0x5068}, //8193 #CJK UNIFIED IDEOGRAPH
    {0xD85C, 0x509C}, //8194 #CJK UNIFIED IDEOGRAPH
    {0xD85D, 0x5092}, //8195 #CJK UNIFIED IDEOGRAPH
    {0xD85E, 0x5082}, //8196 #CJK UNIFIED IDEOGRAPH
    {0xD85F, 0x5087}, //8197 #CJK UNIFIED IDEOGRAPH
    {0xD860, 0x515F}, //8198 #CJK UNIFIED IDEOGRAPH
    {0xD861, 0x51D4}, //8199 #CJK UNIFIED IDEOGRAPH
    {0xD862, 0x5312}, //8200 #CJK UNIFIED IDEOGRAPH
    {0xD863, 0x5311}, //8201 #CJK UNIFIED IDEOGRAPH
    {0xD864, 0x53A4}, //8202 #CJK UNIFIED IDEOGRAPH
    {0xD865, 0x53A7}, //8203 #CJK UNIFIED IDEOGRAPH
    {0xD866, 0x5591}, //8204 #CJK UNIFIED IDEOGRAPH
    {0xD867, 0x55A8}, //8205 #CJK UNIFIED IDEOGRAPH
    {0xD868, 0x55A5}, //8206 #CJK UNIFIED IDEOGRAPH
    {0xD869, 0x55AD}, //8207 #CJK UNIFIED IDEOGRAPH
    {0xD86A, 0x5577}, //8208 #CJK UNIFIED IDEOGRAPH
    {0xD86B, 0x5645}, //8209 #CJK UNIFIED IDEOGRAPH
    {0xD86C, 0x55A2}, //8210 #CJK UNIFIED IDEOGRAPH
    {0xD86D, 0x5593}, //8211 #CJK UNIFIED IDEOGRAPH
    {0xD86E, 0x5588}, //8212 #CJK UNIFIED IDEOGRAPH
    {0xD86F, 0x558F}, //8213 #CJK UNIFIED IDEOGRAPH
    {0xD870, 0x55B5}, //8214 #CJK UNIFIED IDEOGRAPH
    {0xD871, 0x5581}, //8215 #CJK UNIFIED IDEOGRAPH
    {0xD872, 0x55A3}, //8216 #CJK UNIFIED IDEOGRAPH
    {0xD873, 0x5592}, //8217 #CJK UNIFIED IDEOGRAPH
    {0xD874, 0x55A4}, //8218 #CJK UNIFIED IDEOGRAPH
    {0xD875, 0x557D}, //8219 #CJK UNIFIED IDEOGRAPH
    {0xD876, 0x558C}, //8220 #CJK UNIFIED IDEOGRAPH
    {0xD877, 0x55A6}, //8221 #CJK UNIFIED IDEOGRAPH
    {0xD878, 0x557F}, //8222 #CJK UNIFIED IDEOGRAPH
    {0xD879, 0x5595}, //8223 #CJK UNIFIED IDEOGRAPH
    {0xD87A, 0x55A1}, //8224 #CJK UNIFIED IDEOGRAPH
    {0xD87B, 0x558E}, //8225 #CJK UNIFIED IDEOGRAPH
    {0xD87C, 0x570C}, //8226 #CJK UNIFIED IDEOGRAPH
    {0xD87D, 0x5829}, //8227 #CJK UNIFIED IDEOGRAPH
    {0xD87E, 0x5837}, //8228 #CJK UNIFIED IDEOGRAPH
    {0xD8A1, 0x5819}, //8229 #CJK UNIFIED IDEOGRAPH
    {0xD8A2, 0x581E}, //8230 #CJK UNIFIED IDEOGRAPH
    {0xD8A3, 0x5827}, //8231 #CJK UNIFIED IDEOGRAPH
    {0xD8A4, 0x5823}, //8232 #CJK UNIFIED IDEOGRAPH
    {0xD8A5, 0x5828}, //8233 #CJK UNIFIED IDEOGRAPH
    {0xD8A6, 0x57F5}, //8234 #CJK UNIFIED IDEOGRAPH
    {0xD8A7, 0x5848}, //8235 #CJK UNIFIED IDEOGRAPH
    {0xD8A8, 0x5825}, //8236 #CJK UNIFIED IDEOGRAPH
    {0xD8A9, 0x581C}, //8237 #CJK UNIFIED IDEOGRAPH
    {0xD8AA, 0x581B}, //8238 #CJK UNIFIED IDEOGRAPH
    {0xD8AB, 0x5833}, //8239 #CJK UNIFIED IDEOGRAPH
    {0xD8AC, 0x583F}, //8240 #CJK UNIFIED IDEOGRAPH
    {0xD8AD, 0x5836}, //8241 #CJK UNIFIED IDEOGRAPH
    {0xD8AE, 0x582E}, //8242 #CJK UNIFIED IDEOGRAPH
    {0xD8AF, 0x5839}, //8243 #CJK UNIFIED IDEOGRAPH
    {0xD8B0, 0x5838}, //8244 #CJK UNIFIED IDEOGRAPH
    {0xD8B1, 0x582D}, //8245 #CJK UNIFIED IDEOGRAPH
    {0xD8B2, 0x582C}, //8246 #CJK UNIFIED IDEOGRAPH
    {0xD8B3, 0x583B}, //8247 #CJK UNIFIED IDEOGRAPH
    {0xD8B4, 0x5961}, //8248 #CJK UNIFIED IDEOGRAPH
    {0xD8B5, 0x5AAF}, //8249 #CJK UNIFIED IDEOGRAPH
    {0xD8B6, 0x5A94}, //8250 #CJK UNIFIED IDEOGRAPH
    {0xD8B7, 0x5A9F}, //8251 #CJK UNIFIED IDEOGRAPH
    {0xD8B8, 0x5A7A}, //8252 #CJK UNIFIED IDEOGRAPH
    {0xD8B9, 0x5AA2}, //8253 #CJK UNIFIED IDEOGRAPH
    {0xD8BA, 0x5A9E}, //8254 #CJK UNIFIED IDEOGRAPH
    {0xD8BB, 0x5A78}, //8255 #CJK UNIFIED IDEOGRAPH
    {0xD8BC, 0x5AA6}, //8256 #CJK UNIFIED IDEOGRAPH
    {0xD8BD, 0x5A7C}, //8257 #CJK UNIFIED IDEOGRAPH
    {0xD8BE, 0x5AA5}, //8258 #CJK UNIFIED IDEOGRAPH
    {0xD8BF, 0x5AAC}, //8259 #CJK UNIFIED IDEOGRAPH
    {0xD8C0, 0x5A95}, //8260 #CJK UNIFIED IDEOGRAPH
    {0xD8C1, 0x5AAE}, //8261 #CJK UNIFIED IDEOGRAPH
    {0xD8C2, 0x5A37}, //8262 #CJK UNIFIED IDEOGRAPH
    {0xD8C3, 0x5A84}, //8263 #CJK UNIFIED IDEOGRAPH
    {0xD8C4, 0x5A8A}, //8264 #CJK UNIFIED IDEOGRAPH
    {0xD8C5, 0x5A97}, //8265 #CJK UNIFIED IDEOGRAPH
    {0xD8C6, 0x5A83}, //8266 #CJK UNIFIED IDEOGRAPH
    {0xD8C7, 0x5A8B}, //8267 #CJK UNIFIED IDEOGRAPH
    {0xD8C8, 0x5AA9}, //8268 #CJK UNIFIED IDEOGRAPH
    {0xD8C9, 0x5A7B}, //8269 #CJK UNIFIED IDEOGRAPH
    {0xD8CA, 0x5A7D}, //8270 #CJK UNIFIED IDEOGRAPH
    {0xD8CB, 0x5A8C}, //8271 #CJK UNIFIED IDEOGRAPH
    {0xD8CC, 0x5A9C}, //8272 #CJK UNIFIED IDEOGRAPH
    {0xD8CD, 0x5A8F}, //8273 #CJK UNIFIED IDEOGRAPH
    {0xD8CE, 0x5A93}, //8274 #CJK UNIFIED IDEOGRAPH
    {0xD8CF, 0x5A9D}, //8275 #CJK UNIFIED IDEOGRAPH
    {0xD8D0, 0x5BEA}, //8276 #CJK UNIFIED IDEOGRAPH
    {0xD8D1, 0x5BCD}, //8277 #CJK UNIFIED IDEOGRAPH
    {0xD8D2, 0x5BCB}, //8278 #CJK UNIFIED IDEOGRAPH
    {0xD8D3, 0x5BD4}, //8279 #CJK UNIFIED IDEOGRAPH
    {0xD8D4, 0x5BD1}, //8280 #CJK UNIFIED IDEOGRAPH
    {0xD8D5, 0x5BCA}, //8281 #CJK UNIFIED IDEOGRAPH
    {0xD8D6, 0x5BCE}, //8282 #CJK UNIFIED IDEOGRAPH
    {0xD8D7, 0x5C0C}, //8283 #CJK UNIFIED IDEOGRAPH
    {0xD8D8, 0x5C30}, //8284 #CJK UNIFIED IDEOGRAPH
    {0xD8D9, 0x5D37}, //8285 #CJK UNIFIED IDEOGRAPH
    {0xD8DA, 0x5D43}, //8286 #CJK UNIFIED IDEOGRAPH
    {0xD8DB, 0x5D6B}, //8287 #CJK UNIFIED IDEOGRAPH
    {0xD8DC, 0x5D41}, //8288 #CJK UNIFIED IDEOGRAPH
    {0xD8DD, 0x5D4B}, //8289 #CJK UNIFIED IDEOGRAPH
    {0xD8DE, 0x5D3F}, //8290 #CJK UNIFIED IDEOGRAPH
    {0xD8DF, 0x5D35}, //8291 #CJK UNIFIED IDEOGRAPH
    {0xD8E0, 0x5D51}, //8292 #CJK UNIFIED IDEOGRAPH
    {0xD8E1, 0x5D4E}, //8293 #CJK UNIFIED IDEOGRAPH
    {0xD8E2, 0x5D55}, //8294 #CJK UNIFIED IDEOGRAPH
    {0xD8E3, 0x5D33}, //8295 #CJK UNIFIED IDEOGRAPH
    {0xD8E4, 0x5D3A}, //8296 #CJK UNIFIED IDEOGRAPH
    {0xD8E5, 0x5D52}, //8297 #CJK UNIFIED IDEOGRAPH
    {0xD8E6, 0x5D3D}, //8298 #CJK UNIFIED IDEOGRAPH
    {0xD8E7, 0x5D31}, //8299 #CJK UNIFIED IDEOGRAPH
    {0xD8E8, 0x5D59}, //8300 #CJK UNIFIED IDEOGRAPH
    {0xD8E9, 0x5D42}, //8301 #CJK UNIFIED IDEOGRAPH
    {0xD8EA, 0x5D39}, //8302 #CJK UNIFIED IDEOGRAPH
    {0xD8EB, 0x5D49}, //8303 #CJK UNIFIED IDEOGRAPH
    {0xD8EC, 0x5D38}, //8304 #CJK UNIFIED IDEOGRAPH
    {0xD8ED, 0x5D3C}, //8305 #CJK UNIFIED IDEOGRAPH
    {0xD8EE, 0x5D32}, //8306 #CJK UNIFIED IDEOGRAPH
    {0xD8EF, 0x5D36}, //8307 #CJK UNIFIED IDEOGRAPH
    {0xD8F0, 0x5D40}, //8308 #CJK UNIFIED IDEOGRAPH
    {0xD8F1, 0x5D45}, //8309 #CJK UNIFIED IDEOGRAPH
    {0xD8F2, 0x5E44}, //8310 #CJK UNIFIED IDEOGRAPH
    {0xD8F3, 0x5E41}, //8311 #CJK UNIFIED IDEOGRAPH
    {0xD8F4, 0x5F58}, //8312 #CJK UNIFIED IDEOGRAPH
    {0xD8F5, 0x5FA6}, //8313 #CJK UNIFIED IDEOGRAPH
    {0xD8F6, 0x5FA5}, //8314 #CJK UNIFIED IDEOGRAPH
    {0xD8F7, 0x5FAB}, //8315 #CJK UNIFIED IDEOGRAPH
    {0xD8F8, 0x60C9}, //8316 #CJK UNIFIED IDEOGRAPH
    {0xD8F9, 0x60B9}, //8317 #CJK UNIFIED IDEOGRAPH
    {0xD8FA, 0x60CC}, //8318 #CJK UNIFIED IDEOGRAPH
    {0xD8FB, 0x60E2}, //8319 #CJK UNIFIED IDEOGRAPH
    {0xD8FC, 0x60CE}, //8320 #CJK UNIFIED IDEOGRAPH
    {0xD8FD, 0x60C4}, //8321 #CJK UNIFIED IDEOGRAPH
    {0xD8FE, 0x6114}, //8322 #CJK UNIFIED IDEOGRAPH
    {0xD940, 0x60F2}, //8323 #CJK UNIFIED IDEOGRAPH
    {0xD941, 0x610A}, //8324 #CJK UNIFIED IDEOGRAPH
    {0xD942, 0x6116}, //8325 #CJK UNIFIED IDEOGRAPH
    {0xD943, 0x6105}, //8326 #CJK UNIFIED IDEOGRAPH
    {0xD944, 0x60F5}, //8327 #CJK UNIFIED IDEOGRAPH
    {0xD945, 0x6113}, //8328 #CJK UNIFIED IDEOGRAPH
    {0xD946, 0x60F8}, //8329 #CJK UNIFIED IDEOGRAPH
    {0xD947, 0x60FC}, //8330 #CJK UNIFIED IDEOGRAPH
    {0xD948, 0x60FE}, //8331 #CJK UNIFIED IDEOGRAPH
    {0xD949, 0x60C1}, //8332 #CJK UNIFIED IDEOGRAPH
    {0xD94A, 0x6103}, //8333 #CJK UNIFIED IDEOGRAPH
    {0xD94B, 0x6118}, //8334 #CJK UNIFIED IDEOGRAPH
    {0xD94C, 0x611D}, //8335 #CJK UNIFIED IDEOGRAPH
    {0xD94D, 0x6110}, //8336 #CJK UNIFIED IDEOGRAPH
    {0xD94E, 0x60FF}, //8337 #CJK UNIFIED IDEOGRAPH
    {0xD94F, 0x6104}, //8338 #CJK UNIFIED IDEOGRAPH
    {0xD950, 0x610B}, //8339 #CJK UNIFIED IDEOGRAPH
    {0xD951, 0x624A}, //8340 #CJK UNIFIED IDEOGRAPH
    {0xD952, 0x6394}, //8341 #CJK UNIFIED IDEOGRAPH
    {0xD953, 0x63B1}, //8342 #CJK UNIFIED IDEOGRAPH
    {0xD954, 0x63B0}, //8343 #CJK UNIFIED IDEOGRAPH
    {0xD955, 0x63CE}, //8344 #CJK UNIFIED IDEOGRAPH
    {0xD956, 0x63E5}, //8345 #CJK UNIFIED IDEOGRAPH
    {0xD957, 0x63E8}, //8346 #CJK UNIFIED IDEOGRAPH
    {0xD958, 0x63EF}, //8347 #CJK UNIFIED IDEOGRAPH
    {0xD959, 0x63C3}, //8348 #CJK UNIFIED IDEOGRAPH
    {0xD95A, 0x649D}, //8349 #CJK UNIFIED IDEOGRAPH
    {0xD95B, 0x63F3}, //8350 #CJK UNIFIED IDEOGRAPH
    {0xD95C, 0x63CA}, //8351 #CJK UNIFIED IDEOGRAPH
    {0xD95D, 0x63E0}, //8352 #CJK UNIFIED IDEOGRAPH
    {0xD95E, 0x63F6}, //8353 #CJK UNIFIED IDEOGRAPH
    {0xD95F, 0x63D5}, //8354 #CJK UNIFIED IDEOGRAPH
    {0xD960, 0x63F2}, //8355 #CJK UNIFIED IDEOGRAPH
    {0xD961, 0x63F5}, //8356 #CJK UNIFIED IDEOGRAPH
    {0xD962, 0x6461}, //8357 #CJK UNIFIED IDEOGRAPH
    {0xD963, 0x63DF}, //8358 #CJK UNIFIED IDEOGRAPH
    {0xD964, 0x63BE}, //8359 #CJK UNIFIED IDEOGRAPH
    {0xD965, 0x63DD}, //8360 #CJK UNIFIED IDEOGRAPH
    {0xD966, 0x63DC}, //8361 #CJK UNIFIED IDEOGRAPH
    {0xD967, 0x63C4}, //8362 #CJK UNIFIED IDEOGRAPH
    {0xD968, 0x63D8}, //8363 #CJK UNIFIED IDEOGRAPH
    {0xD969, 0x63D3}, //8364 #CJK UNIFIED IDEOGRAPH
    {0xD96A, 0x63C2}, //8365 #CJK UNIFIED IDEOGRAPH
    {0xD96B, 0x63C7}, //8366 #CJK UNIFIED IDEOGRAPH
    {0xD96C, 0x63CC}, //8367 #CJK UNIFIED IDEOGRAPH
    {0xD96D, 0x63CB}, //8368 #CJK UNIFIED IDEOGRAPH
    {0xD96E, 0x63C8}, //8369 #CJK UNIFIED IDEOGRAPH
    {0xD96F, 0x63F0}, //8370 #CJK UNIFIED IDEOGRAPH
    {0xD970, 0x63D7}, //8371 #CJK UNIFIED IDEOGRAPH
    {0xD971, 0x63D9}, //8372 #CJK UNIFIED IDEOGRAPH
    {0xD972, 0x6532}, //8373 #CJK UNIFIED IDEOGRAPH
    {0xD973, 0x6567}, //8374 #CJK UNIFIED IDEOGRAPH
    {0xD974, 0x656A}, //8375 #CJK UNIFIED IDEOGRAPH
    {0xD975, 0x6564}, //8376 #CJK UNIFIED IDEOGRAPH
    {0xD976, 0x655C}, //8377 #CJK UNIFIED IDEOGRAPH
    {0xD977, 0x6568}, //8378 #CJK UNIFIED IDEOGRAPH
    {0xD978, 0x6565}, //8379 #CJK UNIFIED IDEOGRAPH
    {0xD979, 0x658C}, //8380 #CJK UNIFIED IDEOGRAPH
    {0xD97A, 0x659D}, //8381 #CJK UNIFIED IDEOGRAPH
    {0xD97B, 0x659E}, //8382 #CJK UNIFIED IDEOGRAPH
    {0xD97C, 0x65AE}, //8383 #CJK UNIFIED IDEOGRAPH
    {0xD97D, 0x65D0}, //8384 #CJK UNIFIED IDEOGRAPH
    {0xD97E, 0x65D2}, //8385 #CJK UNIFIED IDEOGRAPH
    {0xD9A1, 0x667C}, //8386 #CJK UNIFIED IDEOGRAPH
    {0xD9A2, 0x666C}, //8387 #CJK UNIFIED IDEOGRAPH
    {0xD9A3, 0x667B}, //8388 #CJK UNIFIED IDEOGRAPH
    {0xD9A4, 0x6680}, //8389 #CJK UNIFIED IDEOGRAPH
    {0xD9A5, 0x6671}, //8390 #CJK UNIFIED IDEOGRAPH
    {0xD9A6, 0x6679}, //8391 #CJK UNIFIED IDEOGRAPH
    {0xD9A7, 0x666A}, //8392 #CJK UNIFIED IDEOGRAPH
    {0xD9A8, 0x6672}, //8393 #CJK UNIFIED IDEOGRAPH
    {0xD9A9, 0x6701}, //8394 #CJK UNIFIED IDEOGRAPH
    {0xD9AA, 0x690C}, //8395 #CJK UNIFIED IDEOGRAPH
    {0xD9AB, 0x68D3}, //8396 #CJK UNIFIED IDEOGRAPH
    {0xD9AC, 0x6904}, //8397 #CJK UNIFIED IDEOGRAPH
    {0xD9AD, 0x68DC}, //8398 #CJK UNIFIED IDEOGRAPH
    {0xD9AE, 0x692A}, //8399 #CJK UNIFIED IDEOGRAPH
    {0xD9AF, 0x68EC}, //8400 #CJK UNIFIED IDEOGRAPH
    {0xD9B0, 0x68EA}, //8401 #CJK UNIFIED IDEOGRAPH
    {0xD9B1, 0x68F1}, //8402 #CJK UNIFIED IDEOGRAPH
    {0xD9B2, 0x690F}, //8403 #CJK UNIFIED IDEOGRAPH
    {0xD9B3, 0x68D6}, //8404 #CJK UNIFIED IDEOGRAPH
    {0xD9B4, 0x68F7}, //8405 #CJK UNIFIED IDEOGRAPH
    {0xD9B5, 0x68EB}, //8406 #CJK UNIFIED IDEOGRAPH
    {0xD9B6, 0x68E4}, //8407 #CJK UNIFIED IDEOGRAPH
    {0xD9B7, 0x68F6}, //8408 #CJK UNIFIED IDEOGRAPH
    {0xD9B8, 0x6913}, //8409 #CJK UNIFIED IDEOGRAPH
    {0xD9B9, 0x6910}, //8410 #CJK UNIFIED IDEOGRAPH
    {0xD9BA, 0x68F3}, //8411 #CJK UNIFIED IDEOGRAPH
    {0xD9BB, 0x68E1}, //8412 #CJK UNIFIED IDEOGRAPH
    {0xD9BC, 0x6907}, //8413 #CJK UNIFIED IDEOGRAPH
    {0xD9BD, 0x68CC}, //8414 #CJK UNIFIED IDEOGRAPH
    {0xD9BE, 0x6908}, //8415 #CJK UNIFIED IDEOGRAPH
    {0xD9BF, 0x6970}, //8416 #CJK UNIFIED IDEOGRAPH
    {0xD9C0, 0x68B4}, //8417 #CJK UNIFIED IDEOGRAPH
    {0xD9C1, 0x6911}, //8418 #CJK UNIFIED IDEOGRAPH
    {0xD9C2, 0x68EF}, //8419 #CJK UNIFIED IDEOGRAPH
    {0xD9C3, 0x68C6}, //8420 #CJK UNIFIED IDEOGRAPH
    {0xD9C4, 0x6914}, //8421 #CJK UNIFIED IDEOGRAPH
    {0xD9C5, 0x68F8}, //8422 #CJK UNIFIED IDEOGRAPH
    {0xD9C6, 0x68D0}, //8423 #CJK UNIFIED IDEOGRAPH
    {0xD9C7, 0x68FD}, //8424 #CJK UNIFIED IDEOGRAPH
    {0xD9C8, 0x68FC}, //8425 #CJK UNIFIED IDEOGRAPH
    {0xD9C9, 0x68E8}, //8426 #CJK UNIFIED IDEOGRAPH
    {0xD9CA, 0x690B}, //8427 #CJK UNIFIED IDEOGRAPH
    {0xD9CB, 0x690A}, //8428 #CJK UNIFIED IDEOGRAPH
    {0xD9CC, 0x6917}, //8429 #CJK UNIFIED IDEOGRAPH
    {0xD9CD, 0x68CE}, //8430 #CJK UNIFIED IDEOGRAPH
    {0xD9CE, 0x68C8}, //8431 #CJK UNIFIED IDEOGRAPH
    {0xD9CF, 0x68DD}, //8432 #CJK UNIFIED IDEOGRAPH
    {0xD9D0, 0x68DE}, //8433 #CJK UNIFIED IDEOGRAPH
    {0xD9D1, 0x68E6}, //8434 #CJK UNIFIED IDEOGRAPH
    {0xD9D2, 0x68F4}, //8435 #CJK UNIFIED IDEOGRAPH
    {0xD9D3, 0x68D1}, //8436 #CJK UNIFIED IDEOGRAPH
    {0xD9D4, 0x6906}, //8437 #CJK UNIFIED IDEOGRAPH
    {0xD9D5, 0x68D4}, //8438 #CJK UNIFIED IDEOGRAPH
    {0xD9D6, 0x68E9}, //8439 #CJK UNIFIED IDEOGRAPH
    {0xD9D7, 0x6915}, //8440 #CJK UNIFIED IDEOGRAPH
    {0xD9D8, 0x6925}, //8441 #CJK UNIFIED IDEOGRAPH
    {0xD9D9, 0x68C7}, //8442 #CJK UNIFIED IDEOGRAPH
    {0xD9DA, 0x6B39}, //8443 #CJK UNIFIED IDEOGRAPH
    {0xD9DB, 0x6B3B}, //8444 #CJK UNIFIED IDEOGRAPH
    {0xD9DC, 0x6B3F}, //8445 #CJK UNIFIED IDEOGRAPH
    {0xD9DD, 0x6B3C}, //8446 #CJK UNIFIED IDEOGRAPH
    {0xD9DE, 0x6B94}, //8447 #CJK UNIFIED IDEOGRAPH
    {0xD9DF, 0x6B97}, //8448 #CJK UNIFIED IDEOGRAPH
    {0xD9E0, 0x6B99}, //8449 #CJK UNIFIED IDEOGRAPH
    {0xD9E1, 0x6B95}, //8450 #CJK UNIFIED IDEOGRAPH
    {0xD9E2, 0x6BBD}, //8451 #CJK UNIFIED IDEOGRAPH
    {0xD9E3, 0x6BF0}, //8452 #CJK UNIFIED IDEOGRAPH
    {0xD9E4, 0x6BF2}, //8453 #CJK UNIFIED IDEOGRAPH
    {0xD9E5, 0x6BF3}, //8454 #CJK UNIFIED IDEOGRAPH
    {0xD9E6, 0x6C30}, //8455 #CJK UNIFIED IDEOGRAPH
    {0xD9E7, 0x6DFC}, //8456 #CJK UNIFIED IDEOGRAPH
    {0xD9E8, 0x6E46}, //8457 #CJK UNIFIED IDEOGRAPH
    {0xD9E9, 0x6E47}, //8458 #CJK UNIFIED IDEOGRAPH
    {0xD9EA, 0x6E1F}, //8459 #CJK UNIFIED IDEOGRAPH
    {0xD9EB, 0x6E49}, //8460 #CJK UNIFIED IDEOGRAPH
    {0xD9EC, 0x6E88}, //8461 #CJK UNIFIED IDEOGRAPH
    {0xD9ED, 0x6E3C}, //8462 #CJK UNIFIED IDEOGRAPH
    {0xD9EE, 0x6E3D}, //8463 #CJK UNIFIED IDEOGRAPH
    {0xD9EF, 0x6E45}, //8464 #CJK UNIFIED IDEOGRAPH
    {0xD9F0, 0x6E62}, //8465 #CJK UNIFIED IDEOGRAPH
    {0xD9F1, 0x6E2B}, //8466 #CJK UNIFIED IDEOGRAPH
    {0xD9F2, 0x6E3F}, //8467 #CJK UNIFIED IDEOGRAPH
    {0xD9F3, 0x6E41}, //8468 #CJK UNIFIED IDEOGRAPH
    {0xD9F4, 0x6E5D}, //8469 #CJK UNIFIED IDEOGRAPH
    {0xD9F5, 0x6E73}, //8470 #CJK UNIFIED IDEOGRAPH
    {0xD9F6, 0x6E1C}, //8471 #CJK UNIFIED IDEOGRAPH
    {0xD9F7, 0x6E33}, //8472 #CJK UNIFIED IDEOGRAPH
    {0xD9F8, 0x6E4B}, //8473 #CJK UNIFIED IDEOGRAPH
    {0xD9F9, 0x6E40}, //8474 #CJK UNIFIED IDEOGRAPH
    {0xD9FA, 0x6E51}, //8475 #CJK UNIFIED IDEOGRAPH
    {0xD9FB, 0x6E3B}, //8476 #CJK UNIFIED IDEOGRAPH
    {0xD9FC, 0x6E03}, //8477 #CJK UNIFIED IDEOGRAPH
    {0xD9FD, 0x6E2E}, //8478 #CJK UNIFIED IDEOGRAPH
    {0xD9FE, 0x6E5E}, //8479 #CJK UNIFIED IDEOGRAPH
    {0xDA40, 0x6E68}, //8480 #CJK UNIFIED IDEOGRAPH
    {0xDA41, 0x6E5C}, //8481 #CJK UNIFIED IDEOGRAPH
    {0xDA42, 0x6E61}, //8482 #CJK UNIFIED IDEOGRAPH
    {0xDA43, 0x6E31}, //8483 #CJK UNIFIED IDEOGRAPH
    {0xDA44, 0x6E28}, //8484 #CJK UNIFIED IDEOGRAPH
    {0xDA45, 0x6E60}, //8485 #CJK UNIFIED IDEOGRAPH
    {0xDA46, 0x6E71}, //8486 #CJK UNIFIED IDEOGRAPH
    {0xDA47, 0x6E6B}, //8487 #CJK UNIFIED IDEOGRAPH
    {0xDA48, 0x6E39}, //8488 #CJK UNIFIED IDEOGRAPH
    {0xDA49, 0x6E22}, //8489 #CJK UNIFIED IDEOGRAPH
    {0xDA4A, 0x6E30}, //8490 #CJK UNIFIED IDEOGRAPH
    {0xDA4B, 0x6E53}, //8491 #CJK UNIFIED IDEOGRAPH
    {0xDA4C, 0x6E65}, //8492 #CJK UNIFIED IDEOGRAPH
    {0xDA4D, 0x6E27}, //8493 #CJK UNIFIED IDEOGRAPH
    {0xDA4E, 0x6E78}, //8494 #CJK UNIFIED IDEOGRAPH
    {0xDA4F, 0x6E64}, //8495 #CJK UNIFIED IDEOGRAPH
    {0xDA50, 0x6E77}, //8496 #CJK UNIFIED IDEOGRAPH
    {0xDA51, 0x6E55}, //8497 #CJK UNIFIED IDEOGRAPH
    {0xDA52, 0x6E79}, //8498 #CJK UNIFIED IDEOGRAPH
    {0xDA53, 0x6E52}, //8499 #CJK UNIFIED IDEOGRAPH
    {0xDA54, 0x6E66}, //8500 #CJK UNIFIED IDEOGRAPH
    {0xDA55, 0x6E35}, //8501 #CJK UNIFIED IDEOGRAPH
    {0xDA56, 0x6E36}, //8502 #CJK UNIFIED IDEOGRAPH
    {0xDA57, 0x6E5A}, //8503 #CJK UNIFIED IDEOGRAPH
    {0xDA58, 0x7120}, //8504 #CJK UNIFIED IDEOGRAPH
    {0xDA59, 0x711E}, //8505 #CJK UNIFIED IDEOGRAPH
    {0xDA5A, 0x712F}, //8506 #CJK UNIFIED IDEOGRAPH
    {0xDA5B, 0x70FB}, //8507 #CJK UNIFIED IDEOGRAPH
    {0xDA5C, 0x712E}, //8508 #CJK UNIFIED IDEOGRAPH
    {0xDA5D, 0x7131}, //8509 #CJK UNIFIED IDEOGRAPH
    {0xDA5E, 0x7123}, //8510 #CJK UNIFIED IDEOGRAPH
    {0xDA5F, 0x7125}, //8511 #CJK UNIFIED IDEOGRAPH
    {0xDA60, 0x7122}, //8512 #CJK UNIFIED IDEOGRAPH
    {0xDA61, 0x7132}, //8513 #CJK UNIFIED IDEOGRAPH
    {0xDA62, 0x711F}, //8514 #CJK UNIFIED IDEOGRAPH
    {0xDA63, 0x7128}, //8515 #CJK UNIFIED IDEOGRAPH
    {0xDA64, 0x713A}, //8516 #CJK UNIFIED IDEOGRAPH
    {0xDA65, 0x711B}, //8517 #CJK UNIFIED IDEOGRAPH
    {0xDA66, 0x724B}, //8518 #CJK UNIFIED IDEOGRAPH
    {0xDA67, 0x725A}, //8519 #CJK UNIFIED IDEOGRAPH
    {0xDA68, 0x7288}, //8520 #CJK UNIFIED IDEOGRAPH
    {0xDA69, 0x7289}, //8521 #CJK UNIFIED IDEOGRAPH
    {0xDA6A, 0x7286}, //8522 #CJK UNIFIED IDEOGRAPH
    {0xDA6B, 0x7285}, //8523 #CJK UNIFIED IDEOGRAPH
    {0xDA6C, 0x728B}, //8524 #CJK UNIFIED IDEOGRAPH
    {0xDA6D, 0x7312}, //8525 #CJK UNIFIED IDEOGRAPH
    {0xDA6E, 0x730B}, //8526 #CJK UNIFIED IDEOGRAPH
    {0xDA6F, 0x7330}, //8527 #CJK UNIFIED IDEOGRAPH
    {0xDA70, 0x7322}, //8528 #CJK UNIFIED IDEOGRAPH
    {0xDA71, 0x7331}, //8529 #CJK UNIFIED IDEOGRAPH
    {0xDA72, 0x7333}, //8530 #CJK UNIFIED IDEOGRAPH
    {0xDA73, 0x7327}, //8531 #CJK UNIFIED IDEOGRAPH
    {0xDA74, 0x7332}, //8532 #CJK UNIFIED IDEOGRAPH
    {0xDA75, 0x732D}, //8533 #CJK UNIFIED IDEOGRAPH
    {0xDA76, 0x7326}, //8534 #CJK UNIFIED IDEOGRAPH
    {0xDA77, 0x7323}, //8535 #CJK UNIFIED IDEOGRAPH
    {0xDA78, 0x7335}, //8536 #CJK UNIFIED IDEOGRAPH
    {0xDA79, 0x730C}, //8537 #CJK UNIFIED IDEOGRAPH
    {0xDA7A, 0x742E}, //8538 #CJK UNIFIED IDEOGRAPH
    {0xDA7B, 0x742C}, //8539 #CJK UNIFIED IDEOGRAPH
    {0xDA7C, 0x7430}, //8540 #CJK UNIFIED IDEOGRAPH
    {0xDA7D, 0x742B}, //8541 #CJK UNIFIED IDEOGRAPH
    {0xDA7E, 0x7416}, //8542 #CJK UNIFIED IDEOGRAPH
    {0xDAA1, 0x741A}, //8543 #CJK UNIFIED IDEOGRAPH
    {0xDAA2, 0x7421}, //8544 #CJK UNIFIED IDEOGRAPH
    {0xDAA3, 0x742D}, //8545 #CJK UNIFIED IDEOGRAPH
    {0xDAA4, 0x7431}, //8546 #CJK UNIFIED IDEOGRAPH
    {0xDAA5, 0x7424}, //8547 #CJK UNIFIED IDEOGRAPH
    {0xDAA6, 0x7423}, //8548 #CJK UNIFIED IDEOGRAPH
    {0xDAA7, 0x741D}, //8549 #CJK UNIFIED IDEOGRAPH
    {0xDAA8, 0x7429}, //8550 #CJK UNIFIED IDEOGRAPH
    {0xDAA9, 0x7420}, //8551 #CJK UNIFIED IDEOGRAPH
    {0xDAAA, 0x7432}, //8552 #CJK UNIFIED IDEOGRAPH
    {0xDAAB, 0x74FB}, //8553 #CJK UNIFIED IDEOGRAPH
    {0xDAAC, 0x752F}, //8554 #CJK UNIFIED IDEOGRAPH
    {0xDAAD, 0x756F}, //8555 #CJK UNIFIED IDEOGRAPH
    {0xDAAE, 0x756C}, //8556 #CJK UNIFIED IDEOGRAPH
    {0xDAAF, 0x75E7}, //8557 #CJK UNIFIED IDEOGRAPH
    {0xDAB0, 0x75DA}, //8558 #CJK UNIFIED IDEOGRAPH
    {0xDAB1, 0x75E1}, //8559 #CJK UNIFIED IDEOGRAPH
    {0xDAB2, 0x75E6}, //8560 #CJK UNIFIED IDEOGRAPH
    {0xDAB3, 0x75DD}, //8561 #CJK UNIFIED IDEOGRAPH
    {0xDAB4, 0x75DF}, //8562 #CJK UNIFIED IDEOGRAPH
    {0xDAB5, 0x75E4}, //8563 #CJK UNIFIED IDEOGRAPH
    {0xDAB6, 0x75D7}, //8564 #CJK UNIFIED IDEOGRAPH
    {0xDAB7, 0x7695}, //8565 #CJK UNIFIED IDEOGRAPH
    {0xDAB8, 0x7692}, //8566 #CJK UNIFIED IDEOGRAPH
    {0xDAB9, 0x76DA}, //8567 #CJK UNIFIED IDEOGRAPH
    {0xDABA, 0x7746}, //8568 #CJK UNIFIED IDEOGRAPH
    {0xDABB, 0x7747}, //8569 #CJK UNIFIED IDEOGRAPH
    {0xDABC, 0x7744}, //8570 #CJK UNIFIED IDEOGRAPH
    {0xDABD, 0x774D}, //8571 #CJK UNIFIED IDEOGRAPH
    {0xDABE, 0x7745}, //8572 #CJK UNIFIED IDEOGRAPH
    {0xDABF, 0x774A}, //8573 #CJK UNIFIED IDEOGRAPH
    {0xDAC0, 0x774E}, //8574 #CJK UNIFIED IDEOGRAPH
    {0xDAC1, 0x774B}, //8575 #CJK UNIFIED IDEOGRAPH
    {0xDAC2, 0x774C}, //8576 #CJK UNIFIED IDEOGRAPH
    {0xDAC3, 0x77DE}, //8577 #CJK UNIFIED IDEOGRAPH
    {0xDAC4, 0x77EC}, //8578 #CJK UNIFIED IDEOGRAPH
    {0xDAC5, 0x7860}, //8579 #CJK UNIFIED IDEOGRAPH
    {0xDAC6, 0x7864}, //8580 #CJK UNIFIED IDEOGRAPH
    {0xDAC7, 0x7865}, //8581 #CJK UNIFIED IDEOGRAPH
    {0xDAC8, 0x785C}, //8582 #CJK UNIFIED IDEOGRAPH
    {0xDAC9, 0x786D}, //8583 #CJK UNIFIED IDEOGRAPH
    {0xDACA, 0x7871}, //8584 #CJK UNIFIED IDEOGRAPH
    {0xDACB, 0x786A}, //8585 #CJK UNIFIED IDEOGRAPH
    {0xDACC, 0x786E}, //8586 #CJK UNIFIED IDEOGRAPH
    {0xDACD, 0x7870}, //8587 #CJK UNIFIED IDEOGRAPH
    {0xDACE, 0x7869}, //8588 #CJK UNIFIED IDEOGRAPH
    {0xDACF, 0x7868}, //8589 #CJK UNIFIED IDEOGRAPH
    {0xDAD0, 0x785E}, //8590 #CJK UNIFIED IDEOGRAPH
    {0xDAD1, 0x7862}, //8591 #CJK UNIFIED IDEOGRAPH
    {0xDAD2, 0x7974}, //8592 #CJK UNIFIED IDEOGRAPH
    {0xDAD3, 0x7973}, //8593 #CJK UNIFIED IDEOGRAPH
    {0xDAD4, 0x7972}, //8594 #CJK UNIFIED IDEOGRAPH
    {0xDAD5, 0x7970}, //8595 #CJK UNIFIED IDEOGRAPH
    {0xDAD6, 0x7A02}, //8596 #CJK UNIFIED IDEOGRAPH
    {0xDAD7, 0x7A0A}, //8597 #CJK UNIFIED IDEOGRAPH
    {0xDAD8, 0x7A03}, //8598 #CJK UNIFIED IDEOGRAPH
    {0xDAD9, 0x7A0C}, //8599 #CJK UNIFIED IDEOGRAPH
    {0xDADA, 0x7A04}, //8600 #CJK UNIFIED IDEOGRAPH
    {0xDADB, 0x7A99}, //8601 #CJK UNIFIED IDEOGRAPH
    {0xDADC, 0x7AE6}, //8602 #CJK UNIFIED IDEOGRAPH
    {0xDADD, 0x7AE4}, //8603 #CJK UNIFIED IDEOGRAPH
    {0xDADE, 0x7B4A}, //8604 #CJK UNIFIED IDEOGRAPH
    {0xDADF, 0x7B3B}, //8605 #CJK UNIFIED IDEOGRAPH
    {0xDAE0, 0x7B44}, //8606 #CJK UNIFIED IDEOGRAPH
    {0xDAE1, 0x7B48}, //8607 #CJK UNIFIED IDEOGRAPH
    {0xDAE2, 0x7B4C}, //8608 #CJK UNIFIED IDEOGRAPH
    {0xDAE3, 0x7B4E}, //8609 #CJK UNIFIED IDEOGRAPH
    {0xDAE4, 0x7B40}, //8610 #CJK UNIFIED IDEOGRAPH
    {0xDAE5, 0x7B58}, //8611 #CJK UNIFIED IDEOGRAPH
    {0xDAE6, 0x7B45}, //8612 #CJK UNIFIED IDEOGRAPH
    {0xDAE7, 0x7CA2}, //8613 #CJK UNIFIED IDEOGRAPH
    {0xDAE8, 0x7C9E}, //8614 #CJK UNIFIED IDEOGRAPH
    {0xDAE9, 0x7CA8}, //8615 #CJK UNIFIED IDEOGRAPH
    {0xDAEA, 0x7CA1}, //8616 #CJK UNIFIED IDEOGRAPH
    {0xDAEB, 0x7D58}, //8617 #CJK UNIFIED IDEOGRAPH
    {0xDAEC, 0x7D6F}, //8618 #CJK UNIFIED IDEOGRAPH
    {0xDAED, 0x7D63}, //8619 #CJK UNIFIED IDEOGRAPH
    {0xDAEE, 0x7D53}, //8620 #CJK UNIFIED IDEOGRAPH
    {0xDAEF, 0x7D56}, //8621 #CJK UNIFIED IDEOGRAPH
    {0xDAF0, 0x7D67}, //8622 #CJK UNIFIED IDEOGRAPH
    {0xDAF1, 0x7D6A}, //8623 #CJK UNIFIED IDEOGRAPH
    {0xDAF2, 0x7D4F}, //8624 #CJK UNIFIED IDEOGRAPH
    {0xDAF3, 0x7D6D}, //8625 #CJK UNIFIED IDEOGRAPH
    {0xDAF4, 0x7D5C}, //8626 #CJK UNIFIED IDEOGRAPH
    {0xDAF5, 0x7D6B}, //8627 #CJK UNIFIED IDEOGRAPH
    {0xDAF6, 0x7D52}, //8628 #CJK UNIFIED IDEOGRAPH
    {0xDAF7, 0x7D54}, //8629 #CJK UNIFIED IDEOGRAPH
    {0xDAF8, 0x7D69}, //8630 #CJK UNIFIED IDEOGRAPH
    {0xDAF9, 0x7D51}, //8631 #CJK UNIFIED IDEOGRAPH
    {0xDAFA, 0x7D5F}, //8632 #CJK UNIFIED IDEOGRAPH
    {0xDAFB, 0x7D4E}, //8633 #CJK UNIFIED IDEOGRAPH
    {0xDAFC, 0x7F3E}, //8634 #CJK UNIFIED IDEOGRAPH
    {0xDAFD, 0x7F3F}, //8635 #CJK UNIFIED IDEOGRAPH
    {0xDAFE, 0x7F65}, //8636 #CJK UNIFIED IDEOGRAPH
    {0xDB40, 0x7F66}, //8637 #CJK UNIFIED IDEOGRAPH
    {0xDB41, 0x7FA2}, //8638 #CJK UNIFIED IDEOGRAPH
    {0xDB42, 0x7FA0}, //8639 #CJK UNIFIED IDEOGRAPH
    {0xDB43, 0x7FA1}, //8640 #CJK UNIFIED IDEOGRAPH
    {0xDB44, 0x7FD7}, //8641 #CJK UNIFIED IDEOGRAPH
    {0xDB45, 0x8051}, //8642 #CJK UNIFIED IDEOGRAPH
    {0xDB46, 0x804F}, //8643 #CJK UNIFIED IDEOGRAPH
    {0xDB47, 0x8050}, //8644 #CJK UNIFIED IDEOGRAPH
    {0xDB48, 0x80FE}, //8645 #CJK UNIFIED IDEOGRAPH
    {0xDB49, 0x80D4}, //8646 #CJK UNIFIED IDEOGRAPH
    {0xDB4A, 0x8143}, //8647 #CJK UNIFIED IDEOGRAPH
    {0xDB4B, 0x814A}, //8648 #CJK UNIFIED IDEOGRAPH
    {0xDB4C, 0x8152}, //8649 #CJK UNIFIED IDEOGRAPH
    {0xDB4D, 0x814F}, //8650 #CJK UNIFIED IDEOGRAPH
    {0xDB4E, 0x8147}, //8651 #CJK UNIFIED IDEOGRAPH
    {0xDB4F, 0x813D}, //8652 #CJK UNIFIED IDEOGRAPH
    {0xDB50, 0x814D}, //8653 #CJK UNIFIED IDEOGRAPH
    {0xDB51, 0x813A}, //8654 #CJK UNIFIED IDEOGRAPH
    {0xDB52, 0x81E6}, //8655 #CJK UNIFIED IDEOGRAPH
    {0xDB53, 0x81EE}, //8656 #CJK UNIFIED IDEOGRAPH
    {0xDB54, 0x81F7}, //8657 #CJK UNIFIED IDEOGRAPH
    {0xDB55, 0x81F8}, //8658 #CJK UNIFIED IDEOGRAPH
    {0xDB56, 0x81F9}, //8659 #CJK UNIFIED IDEOGRAPH
    {0xDB57, 0x8204}, //8660 #CJK UNIFIED IDEOGRAPH
    {0xDB58, 0x823C}, //8661 #CJK UNIFIED IDEOGRAPH
    {0xDB59, 0x823D}, //8662 #CJK UNIFIED IDEOGRAPH
    {0xDB5A, 0x823F}, //8663 #CJK UNIFIED IDEOGRAPH
    {0xDB5B, 0x8275}, //8664 #CJK UNIFIED IDEOGRAPH
    {0xDB5C, 0x833B}, //8665 #CJK UNIFIED IDEOGRAPH
    {0xDB5D, 0x83CF}, //8666 #CJK UNIFIED IDEOGRAPH
    {0xDB5E, 0x83F9}, //8667 #CJK UNIFIED IDEOGRAPH
    {0xDB5F, 0x8423}, //8668 #CJK UNIFIED IDEOGRAPH
    {0xDB60, 0x83C0}, //8669 #CJK UNIFIED IDEOGRAPH
    {0xDB61, 0x83E8}, //8670 #CJK UNIFIED IDEOGRAPH
    {0xDB62, 0x8412}, //8671 #CJK UNIFIED IDEOGRAPH
    {0xDB63, 0x83E7}, //8672 #CJK UNIFIED IDEOGRAPH
    {0xDB64, 0x83E4}, //8673 #CJK UNIFIED IDEOGRAPH
    {0xDB65, 0x83FC}, //8674 #CJK UNIFIED IDEOGRAPH
    {0xDB66, 0x83F6}, //8675 #CJK UNIFIED IDEOGRAPH
    {0xDB67, 0x8410}, //8676 #CJK UNIFIED IDEOGRAPH
    {0xDB68, 0x83C6}, //8677 #CJK UNIFIED IDEOGRAPH
    {0xDB69, 0x83C8}, //8678 #CJK UNIFIED IDEOGRAPH
    {0xDB6A, 0x83EB}, //8679 #CJK UNIFIED IDEOGRAPH
    {0xDB6B, 0x83E3}, //8680 #CJK UNIFIED IDEOGRAPH
    {0xDB6C, 0x83BF}, //8681 #CJK UNIFIED IDEOGRAPH
    {0xDB6D, 0x8401}, //8682 #CJK UNIFIED IDEOGRAPH
    {0xDB6E, 0x83DD}, //8683 #CJK UNIFIED IDEOGRAPH
    {0xDB6F, 0x83E5}, //8684 #CJK UNIFIED IDEOGRAPH
    {0xDB70, 0x83D8}, //8685 #CJK UNIFIED IDEOGRAPH
    {0xDB71, 0x83FF}, //8686 #CJK UNIFIED IDEOGRAPH
    {0xDB72, 0x83E1}, //8687 #CJK UNIFIED IDEOGRAPH
    {0xDB73, 0x83CB}, //8688 #CJK UNIFIED IDEOGRAPH
    {0xDB74, 0x83CE}, //8689 #CJK UNIFIED IDEOGRAPH
    {0xDB75, 0x83D6}, //8690 #CJK UNIFIED IDEOGRAPH
    {0xDB76, 0x83F5}, //8691 #CJK UNIFIED IDEOGRAPH
    {0xDB77, 0x83C9}, //8692 #CJK UNIFIED IDEOGRAPH
    {0xDB78, 0x8409}, //8693 #CJK UNIFIED IDEOGRAPH
    {0xDB79, 0x840F}, //8694 #CJK UNIFIED IDEOGRAPH
    {0xDB7A, 0x83DE}, //8695 #CJK UNIFIED IDEOGRAPH
    {0xDB7B, 0x8411}, //8696 #CJK UNIFIED IDEOGRAPH
    {0xDB7C, 0x8406}, //8697 #CJK UNIFIED IDEOGRAPH
    {0xDB7D, 0x83C2}, //8698 #CJK UNIFIED IDEOGRAPH
    {0xDB7E, 0x83F3}, //8699 #CJK UNIFIED IDEOGRAPH
    {0xDBA1, 0x83D5}, //8700 #CJK UNIFIED IDEOGRAPH
    {0xDBA2, 0x83FA}, //8701 #CJK UNIFIED IDEOGRAPH
    {0xDBA3, 0x83C7}, //8702 #CJK UNIFIED IDEOGRAPH
    {0xDBA4, 0x83D1}, //8703 #CJK UNIFIED IDEOGRAPH
    {0xDBA5, 0x83EA}, //8704 #CJK UNIFIED IDEOGRAPH
    {0xDBA6, 0x8413}, //8705 #CJK UNIFIED IDEOGRAPH
    {0xDBA7, 0x83C3}, //8706 #CJK UNIFIED IDEOGRAPH
    {0xDBA8, 0x83EC}, //8707 #CJK UNIFIED IDEOGRAPH
    {0xDBA9, 0x83EE}, //8708 #CJK UNIFIED IDEOGRAPH
    {0xDBAA, 0x83C4}, //8709 #CJK UNIFIED IDEOGRAPH
    {0xDBAB, 0x83FB}, //8710 #CJK UNIFIED IDEOGRAPH
    {0xDBAC, 0x83D7}, //8711 #CJK UNIFIED IDEOGRAPH
    {0xDBAD, 0x83E2}, //8712 #CJK UNIFIED IDEOGRAPH
    {0xDBAE, 0x841B}, //8713 #CJK UNIFIED IDEOGRAPH
    {0xDBAF, 0x83DB}, //8714 #CJK UNIFIED IDEOGRAPH
    {0xDBB0, 0x83FE}, //8715 #CJK UNIFIED IDEOGRAPH
    {0xDBB1, 0x86D8}, //8716 #CJK UNIFIED IDEOGRAPH
    {0xDBB2, 0x86E2}, //8717 #CJK UNIFIED IDEOGRAPH
    {0xDBB3, 0x86E6}, //8718 #CJK UNIFIED IDEOGRAPH
    {0xDBB4, 0x86D3}, //8719 #CJK UNIFIED IDEOGRAPH
    {0xDBB5, 0x86E3}, //8720 #CJK UNIFIED IDEOGRAPH
    {0xDBB6, 0x86DA}, //8721 #CJK UNIFIED IDEOGRAPH
    {0xDBB7, 0x86EA}, //8722 #CJK UNIFIED IDEOGRAPH
    {0xDBB8, 0x86DD}, //8723 #CJK UNIFIED IDEOGRAPH
    {0xDBB9, 0x86EB}, //8724 #CJK UNIFIED IDEOGRAPH
    {0xDBBA, 0x86DC}, //8725 #CJK UNIFIED IDEOGRAPH
    {0xDBBB, 0x86EC}, //8726 #CJK UNIFIED IDEOGRAPH
    {0xDBBC, 0x86E9}, //8727 #CJK UNIFIED IDEOGRAPH
    {0xDBBD, 0x86D7}, //8728 #CJK UNIFIED IDEOGRAPH
    {0xDBBE, 0x86E8}, //8729 #CJK UNIFIED IDEOGRAPH
    {0xDBBF, 0x86D1}, //8730 #CJK UNIFIED IDEOGRAPH
    {0xDBC0, 0x8848}, //8731 #CJK UNIFIED IDEOGRAPH
    {0xDBC1, 0x8856}, //8732 #CJK UNIFIED IDEOGRAPH
    {0xDBC2, 0x8855}, //8733 #CJK UNIFIED IDEOGRAPH
    {0xDBC3, 0x88BA}, //8734 #CJK UNIFIED IDEOGRAPH
    {0xDBC4, 0x88D7}, //8735 #CJK UNIFIED IDEOGRAPH
    {0xDBC5, 0x88B9}, //8736 #CJK UNIFIED IDEOGRAPH
    {0xDBC6, 0x88B8}, //8737 #CJK UNIFIED IDEOGRAPH
    {0xDBC7, 0x88C0}, //8738 #CJK UNIFIED IDEOGRAPH
    {0xDBC8, 0x88BE}, //8739 #CJK UNIFIED IDEOGRAPH
    {0xDBC9, 0x88B6}, //8740 #CJK UNIFIED IDEOGRAPH
    {0xDBCA, 0x88BC}, //8741 #CJK UNIFIED IDEOGRAPH
    {0xDBCB, 0x88B7}, //8742 #CJK UNIFIED IDEOGRAPH
    {0xDBCC, 0x88BD}, //8743 #CJK UNIFIED IDEOGRAPH
    {0xDBCD, 0x88B2}, //8744 #CJK UNIFIED IDEOGRAPH
    {0xDBCE, 0x8901}, //8745 #CJK UNIFIED IDEOGRAPH
    {0xDBCF, 0x88C9}, //8746 #CJK UNIFIED IDEOGRAPH
    {0xDBD0, 0x8995}, //8747 #CJK UNIFIED IDEOGRAPH
    {0xDBD1, 0x8998}, //8748 #CJK UNIFIED IDEOGRAPH
    {0xDBD2, 0x8997}, //8749 #CJK UNIFIED IDEOGRAPH
    {0xDBD3, 0x89DD}, //8750 #CJK UNIFIED IDEOGRAPH
    {0xDBD4, 0x89DA}, //8751 #CJK UNIFIED IDEOGRAPH
    {0xDBD5, 0x89DB}, //8752 #CJK UNIFIED IDEOGRAPH
    {0xDBD6, 0x8A4E}, //8753 #CJK UNIFIED IDEOGRAPH
    {0xDBD7, 0x8A4D}, //8754 #CJK UNIFIED IDEOGRAPH
    {0xDBD8, 0x8A39}, //8755 #CJK UNIFIED IDEOGRAPH
    {0xDBD9, 0x8A59}, //8756 #CJK UNIFIED IDEOGRAPH
    {0xDBDA, 0x8A40}, //8757 #CJK UNIFIED IDEOGRAPH
    {0xDBDB, 0x8A57}, //8758 #CJK UNIFIED IDEOGRAPH
    {0xDBDC, 0x8A58}, //8759 #CJK UNIFIED IDEOGRAPH
    {0xDBDD, 0x8A44}, //8760 #CJK UNIFIED IDEOGRAPH
    {0xDBDE, 0x8A45}, //8761 #CJK UNIFIED IDEOGRAPH
    {0xDBDF, 0x8A52}, //8762 #CJK UNIFIED IDEOGRAPH
    {0xDBE0, 0x8A48}, //8763 #CJK UNIFIED IDEOGRAPH
    {0xDBE1, 0x8A51}, //8764 #CJK UNIFIED IDEOGRAPH
    {0xDBE2, 0x8A4A}, //8765 #CJK UNIFIED IDEOGRAPH
    {0xDBE3, 0x8A4C}, //8766 #CJK UNIFIED IDEOGRAPH
    {0xDBE4, 0x8A4F}, //8767 #CJK UNIFIED IDEOGRAPH
    {0xDBE5, 0x8C5F}, //8768 #CJK UNIFIED IDEOGRAPH
    {0xDBE6, 0x8C81}, //8769 #CJK UNIFIED IDEOGRAPH
    {0xDBE7, 0x8C80}, //8770 #CJK UNIFIED IDEOGRAPH
    {0xDBE8, 0x8CBA}, //8771 #CJK UNIFIED IDEOGRAPH
    {0xDBE9, 0x8CBE}, //8772 #CJK UNIFIED IDEOGRAPH
    {0xDBEA, 0x8CB0}, //8773 #CJK UNIFIED IDEOGRAPH
    {0xDBEB, 0x8CB9}, //8774 #CJK UNIFIED IDEOGRAPH
    {0xDBEC, 0x8CB5}, //8775 #CJK UNIFIED IDEOGRAPH
    {0xDBED, 0x8D84}, //8776 #CJK UNIFIED IDEOGRAPH
    {0xDBEE, 0x8D80}, //8777 #CJK UNIFIED IDEOGRAPH
    {0xDBEF, 0x8D89}, //8778 #CJK UNIFIED IDEOGRAPH
    {0xDBF0, 0x8DD8}, //8779 #CJK UNIFIED IDEOGRAPH
    {0xDBF1, 0x8DD3}, //8780 #CJK UNIFIED IDEOGRAPH
    {0xDBF2, 0x8DCD}, //8781 #CJK UNIFIED IDEOGRAPH
    {0xDBF3, 0x8DC7}, //8782 #CJK UNIFIED IDEOGRAPH
    {0xDBF4, 0x8DD6}, //8783 #CJK UNIFIED IDEOGRAPH
    {0xDBF5, 0x8DDC}, //8784 #CJK UNIFIED IDEOGRAPH
    {0xDBF6, 0x8DCF}, //8785 #CJK UNIFIED IDEOGRAPH
    {0xDBF7, 0x8DD5}, //8786 #CJK UNIFIED IDEOGRAPH
    {0xDBF8, 0x8DD9}, //8787 #CJK UNIFIED IDEOGRAPH
    {0xDBF9, 0x8DC8}, //8788 #CJK UNIFIED IDEOGRAPH
    {0xDBFA, 0x8DD7}, //8789 #CJK UNIFIED IDEOGRAPH
    {0xDBFB, 0x8DC5}, //8790 #CJK UNIFIED IDEOGRAPH
    {0xDBFC, 0x8EEF}, //8791 #CJK UNIFIED IDEOGRAPH
    {0xDBFD, 0x8EF7}, //8792 #CJK UNIFIED IDEOGRAPH
    {0xDBFE, 0x8EFA}, //8793 #CJK UNIFIED IDEOGRAPH
    {0xDC40, 0x8EF9}, //8794 #CJK UNIFIED IDEOGRAPH
    {0xDC41, 0x8EE6}, //8795 #CJK UNIFIED IDEOGRAPH
    {0xDC42, 0x8EEE}, //8796 #CJK UNIFIED IDEOGRAPH
    {0xDC43, 0x8EE5}, //8797 #CJK UNIFIED IDEOGRAPH
    {0xDC44, 0x8EF5}, //8798 #CJK UNIFIED IDEOGRAPH
    {0xDC45, 0x8EE7}, //8799 #CJK UNIFIED IDEOGRAPH
    {0xDC46, 0x8EE8}, //8800 #CJK UNIFIED IDEOGRAPH
    {0xDC47, 0x8EF6}, //8801 #CJK UNIFIED IDEOGRAPH
    {0xDC48, 0x8EEB}, //8802 #CJK UNIFIED IDEOGRAPH
    {0xDC49, 0x8EF1}, //8803 #CJK UNIFIED IDEOGRAPH
    {0xDC4A, 0x8EEC}, //8804 #CJK UNIFIED IDEOGRAPH
    {0xDC4B, 0x8EF4}, //8805 #CJK UNIFIED IDEOGRAPH
    {0xDC4C, 0x8EE9}, //8806 #CJK UNIFIED IDEOGRAPH
    {0xDC4D, 0x902D}, //8807 #CJK UNIFIED IDEOGRAPH
    {0xDC4E, 0x9034}, //8808 #CJK UNIFIED IDEOGRAPH
    {0xDC4F, 0x902F}, //8809 #CJK UNIFIED IDEOGRAPH
    {0xDC50, 0x9106}, //8810 #CJK UNIFIED IDEOGRAPH
    {0xDC51, 0x912C}, //8811 #CJK UNIFIED IDEOGRAPH
    {0xDC52, 0x9104}, //8812 #CJK UNIFIED IDEOGRAPH
    {0xDC53, 0x90FF}, //8813 #CJK UNIFIED IDEOGRAPH
    {0xDC54, 0x90FC}, //8814 #CJK UNIFIED IDEOGRAPH
    {0xDC55, 0x9108}, //8815 #CJK UNIFIED IDEOGRAPH
    {0xDC56, 0x90F9}, //8816 #CJK UNIFIED IDEOGRAPH
    {0xDC57, 0x90FB}, //8817 #CJK UNIFIED IDEOGRAPH
    {0xDC58, 0x9101}, //8818 #CJK UNIFIED IDEOGRAPH
    {0xDC59, 0x9100}, //8819 #CJK UNIFIED IDEOGRAPH
    {0xDC5A, 0x9107}, //8820 #CJK UNIFIED IDEOGRAPH
    {0xDC5B, 0x9105}, //8821 #CJK UNIFIED IDEOGRAPH
    {0xDC5C, 0x9103}, //8822 #CJK UNIFIED IDEOGRAPH
    {0xDC5D, 0x9161}, //8823 #CJK UNIFIED IDEOGRAPH
    {0xDC5E, 0x9164}, //8824 #CJK UNIFIED IDEOGRAPH
    {0xDC5F, 0x915F}, //8825 #CJK UNIFIED IDEOGRAPH
    {0xDC60, 0x9162}, //8826 #CJK UNIFIED IDEOGRAPH
    {0xDC61, 0x9160}, //8827 #CJK UNIFIED IDEOGRAPH
    {0xDC62, 0x9201}, //8828 #CJK UNIFIED IDEOGRAPH
    {0xDC63, 0x920A}, //8829 #CJK UNIFIED IDEOGRAPH
    {0xDC64, 0x9225}, //8830 #CJK UNIFIED IDEOGRAPH
    {0xDC65, 0x9203}, //8831 #CJK UNIFIED IDEOGRAPH
    {0xDC66, 0x921A}, //8832 #CJK UNIFIED IDEOGRAPH
    {0xDC67, 0x9226}, //8833 #CJK UNIFIED IDEOGRAPH
    {0xDC68, 0x920F}, //8834 #CJK UNIFIED IDEOGRAPH
    {0xDC69, 0x920C}, //8835 #CJK UNIFIED IDEOGRAPH
    {0xDC6A, 0x9200}, //8836 #CJK UNIFIED IDEOGRAPH
    {0xDC6B, 0x9212}, //8837 #CJK UNIFIED IDEOGRAPH
    {0xDC6C, 0x91FF}, //8838 #CJK UNIFIED IDEOGRAPH
    {0xDC6D, 0x91FD}, //8839 #CJK UNIFIED IDEOGRAPH
    {0xDC6E, 0x9206}, //8840 #CJK UNIFIED IDEOGRAPH
    {0xDC6F, 0x9204}, //8841 #CJK UNIFIED IDEOGRAPH
    {0xDC70, 0x9227}, //8842 #CJK UNIFIED IDEOGRAPH
    {0xDC71, 0x9202}, //8843 #CJK UNIFIED IDEOGRAPH
    {0xDC72, 0x921C}, //8844 #CJK UNIFIED IDEOGRAPH
    {0xDC73, 0x9224}, //8845 #CJK UNIFIED IDEOGRAPH
    {0xDC74, 0x9219}, //8846 #CJK UNIFIED IDEOGRAPH
    {0xDC75, 0x9217}, //8847 #CJK UNIFIED IDEOGRAPH
    {0xDC76, 0x9205}, //8848 #CJK UNIFIED IDEOGRAPH
    {0xDC77, 0x9216}, //8849 #CJK UNIFIED IDEOGRAPH
    {0xDC78, 0x957B}, //8850 #CJK UNIFIED IDEOGRAPH
    {0xDC79, 0x958D}, //8851 #CJK UNIFIED IDEOGRAPH
    {0xDC7A, 0x958C}, //8852 #CJK UNIFIED IDEOGRAPH
    {0xDC7B, 0x9590}, //8853 #CJK UNIFIED IDEOGRAPH
    {0xDC7C, 0x9687}, //8854 #CJK UNIFIED IDEOGRAPH
    {0xDC7D, 0x967E}, //8855 #CJK UNIFIED IDEOGRAPH
    {0xDC7E, 0x9688}, //8856 #CJK UNIFIED IDEOGRAPH
    {0xDCA1, 0x9689}, //8857 #CJK UNIFIED IDEOGRAPH
    {0xDCA2, 0x9683}, //8858 #CJK UNIFIED IDEOGRAPH
    {0xDCA3, 0x9680}, //8859 #CJK UNIFIED IDEOGRAPH
    {0xDCA4, 0x96C2}, //8860 #CJK UNIFIED IDEOGRAPH
    {0xDCA5, 0x96C8}, //8861 #CJK UNIFIED IDEOGRAPH
    {0xDCA6, 0x96C3}, //8862 #CJK UNIFIED IDEOGRAPH
    {0xDCA7, 0x96F1}, //8863 #CJK UNIFIED IDEOGRAPH
    {0xDCA8, 0x96F0}, //8864 #CJK UNIFIED IDEOGRAPH
    {0xDCA9, 0x976C}, //8865 #CJK UNIFIED IDEOGRAPH
    {0xDCAA, 0x9770}, //8866 #CJK UNIFIED IDEOGRAPH
    {0xDCAB, 0x976E}, //8867 #CJK UNIFIED IDEOGRAPH
    {0xDCAC, 0x9807}, //8868 #CJK UNIFIED IDEOGRAPH
    {0xDCAD, 0x98A9}, //8869 #CJK UNIFIED IDEOGRAPH
    {0xDCAE, 0x98EB}, //8870 #CJK UNIFIED IDEOGRAPH
    {0xDCAF, 0x9CE6}, //8871 #CJK UNIFIED IDEOGRAPH
    {0xDCB0, 0x9EF9}, //8872 #CJK UNIFIED IDEOGRAPH
    {0xDCB1, 0x4E83}, //8873 #CJK UNIFIED IDEOGRAPH
    {0xDCB2, 0x4E84}, //8874 #CJK UNIFIED IDEOGRAPH
    {0xDCB3, 0x4EB6}, //8875 #CJK UNIFIED IDEOGRAPH
    {0xDCB4, 0x50BD}, //8876 #CJK UNIFIED IDEOGRAPH
    {0xDCB5, 0x50BF}, //8877 #CJK UNIFIED IDEOGRAPH
    {0xDCB6, 0x50C6}, //8878 #CJK UNIFIED IDEOGRAPH
    {0xDCB7, 0x50AE}, //8879 #CJK UNIFIED IDEOGRAPH
    {0xDCB8, 0x50C4}, //8880 #CJK UNIFIED IDEOGRAPH
    {0xDCB9, 0x50CA}, //8881 #CJK UNIFIED IDEOGRAPH
    {0xDCBA, 0x50B4}, //8882 #CJK UNIFIED IDEOGRAPH
    {0xDCBB, 0x50C8}, //8883 #CJK UNIFIED IDEOGRAPH
    {0xDCBC, 0x50C2}, //8884 #CJK UNIFIED IDEOGRAPH
    {0xDCBD, 0x50B0}, //8885 #CJK UNIFIED IDEOGRAPH
    {0xDCBE, 0x50C1}, //8886 #CJK UNIFIED IDEOGRAPH
    {0xDCBF, 0x50BA}, //8887 #CJK UNIFIED IDEOGRAPH
    {0xDCC0, 0x50B1}, //8888 #CJK UNIFIED IDEOGRAPH
    {0xDCC1, 0x50CB}, //8889 #CJK UNIFIED IDEOGRAPH
    {0xDCC2, 0x50C9}, //8890 #CJK UNIFIED IDEOGRAPH
    {0xDCC3, 0x50B6}, //8891 #CJK UNIFIED IDEOGRAPH
    {0xDCC4, 0x50B8}, //8892 #CJK UNIFIED IDEOGRAPH
    {0xDCC5, 0x51D7}, //8893 #CJK UNIFIED IDEOGRAPH
    {0xDCC6, 0x527A}, //8894 #CJK UNIFIED IDEOGRAPH
    {0xDCC7, 0x5278}, //8895 #CJK UNIFIED IDEOGRAPH
    {0xDCC8, 0x527B}, //8896 #CJK UNIFIED IDEOGRAPH
    {0xDCC9, 0x527C}, //8897 #CJK UNIFIED IDEOGRAPH
    {0xDCCA, 0x55C3}, //8898 #CJK UNIFIED IDEOGRAPH
    {0xDCCB, 0x55DB}, //8899 #CJK UNIFIED IDEOGRAPH
    {0xDCCC, 0x55CC}, //8900 #CJK UNIFIED IDEOGRAPH
    {0xDCCD, 0x55D0}, //8901 #CJK UNIFIED IDEOGRAPH
    {0xDCCE, 0x55CB}, //8902 #CJK UNIFIED IDEOGRAPH
    {0xDCCF, 0x55CA}, //8903 #CJK UNIFIED IDEOGRAPH
    {0xDCD0, 0x55DD}, //8904 #CJK UNIFIED IDEOGRAPH
    {0xDCD1, 0x55C0}, //8905 #CJK UNIFIED IDEOGRAPH
    {0xDCD2, 0x55D4}, //8906 #CJK UNIFIED IDEOGRAPH
    {0xDCD3, 0x55C4}, //8907 #CJK UNIFIED IDEOGRAPH
    {0xDCD4, 0x55E9}, //8908 #CJK UNIFIED IDEOGRAPH
    {0xDCD5, 0x55BF}, //8909 #CJK UNIFIED IDEOGRAPH
    {0xDCD6, 0x55D2}, //8910 #CJK UNIFIED IDEOGRAPH
    {0xDCD7, 0x558D}, //8911 #CJK UNIFIED IDEOGRAPH
    {0xDCD8, 0x55CF}, //8912 #CJK UNIFIED IDEOGRAPH
    {0xDCD9, 0x55D5}, //8913 #CJK UNIFIED IDEOGRAPH
    {0xDCDA, 0x55E2}, //8914 #CJK UNIFIED IDEOGRAPH
    {0xDCDB, 0x55D6}, //8915 #CJK UNIFIED IDEOGRAPH
    {0xDCDC, 0x55C8}, //8916 #CJK UNIFIED IDEOGRAPH
    {0xDCDD, 0x55F2}, //8917 #CJK UNIFIED IDEOGRAPH
    {0xDCDE, 0x55CD}, //8918 #CJK UNIFIED IDEOGRAPH
    {0xDCDF, 0x55D9}, //8919 #CJK UNIFIED IDEOGRAPH
    {0xDCE0, 0x55C2}, //8920 #CJK UNIFIED IDEOGRAPH
    {0xDCE1, 0x5714}, //8921 #CJK UNIFIED IDEOGRAPH
    {0xDCE2, 0x5853}, //8922 #CJK UNIFIED IDEOGRAPH
    {0xDCE3, 0x5868}, //8923 #CJK UNIFIED IDEOGRAPH
    {0xDCE4, 0x5864}, //8924 #CJK UNIFIED IDEOGRAPH
    {0xDCE5, 0x584F}, //8925 #CJK UNIFIED IDEOGRAPH
    {0xDCE6, 0x584D}, //8926 #CJK UNIFIED IDEOGRAPH
    {0xDCE7, 0x5849}, //8927 #CJK UNIFIED IDEOGRAPH
    {0xDCE8, 0x586F}, //8928 #CJK UNIFIED IDEOGRAPH
    {0xDCE9, 0x5855}, //8929 #CJK UNIFIED IDEOGRAPH
    {0xDCEA, 0x584E}, //8930 #CJK UNIFIED IDEOGRAPH
    {0xDCEB, 0x585D}, //8931 #CJK UNIFIED IDEOGRAPH
    {0xDCEC, 0x5859}, //8932 #CJK UNIFIED IDEOGRAPH
    {0xDCED, 0x5865}, //8933 #CJK UNIFIED IDEOGRAPH
    {0xDCEE, 0x585B}, //8934 #CJK UNIFIED IDEOGRAPH
    {0xDCEF, 0x583D}, //8935 #CJK UNIFIED IDEOGRAPH
    {0xDCF0, 0x5863}, //8936 #CJK UNIFIED IDEOGRAPH
    {0xDCF1, 0x5871}, //8937 #CJK UNIFIED IDEOGRAPH
    {0xDCF2, 0x58FC}, //8938 #CJK UNIFIED IDEOGRAPH
    {0xDCF3, 0x5AC7}, //8939 #CJK UNIFIED IDEOGRAPH
    {0xDCF4, 0x5AC4}, //8940 #CJK UNIFIED IDEOGRAPH
    {0xDCF5, 0x5ACB}, //8941 #CJK UNIFIED IDEOGRAPH
    {0xDCF6, 0x5ABA}, //8942 #CJK UNIFIED IDEOGRAPH
    {0xDCF7, 0x5AB8}, //8943 #CJK UNIFIED IDEOGRAPH
    {0xDCF8, 0x5AB1}, //8944 #CJK UNIFIED IDEOGRAPH
    {0xDCF9, 0x5AB5}, //8945 #CJK UNIFIED IDEOGRAPH
    {0xDCFA, 0x5AB0}, //8946 #CJK UNIFIED IDEOGRAPH
    {0xDCFB, 0x5ABF}, //8947 #CJK UNIFIED IDEOGRAPH
    {0xDCFC, 0x5AC8}, //8948 #CJK UNIFIED IDEOGRAPH
    {0xDCFD, 0x5ABB}, //8949 #CJK UNIFIED IDEOGRAPH
    {0xDCFE, 0x5AC6}, //8950 #CJK UNIFIED IDEOGRAPH
    {0xDD40, 0x5AB7}, //8951 #CJK UNIFIED IDEOGRAPH
    {0xDD41, 0x5AC0}, //8952 #CJK UNIFIED IDEOGRAPH
    {0xDD42, 0x5ACA}, //8953 #CJK UNIFIED IDEOGRAPH
    {0xDD43, 0x5AB4}, //8954 #CJK UNIFIED IDEOGRAPH
    {0xDD44, 0x5AB6}, //8955 #CJK UNIFIED IDEOGRAPH
    {0xDD45, 0x5ACD}, //8956 #CJK UNIFIED IDEOGRAPH
    {0xDD46, 0x5AB9}, //8957 #CJK UNIFIED IDEOGRAPH
    {0xDD47, 0x5A90}, //8958 #CJK UNIFIED IDEOGRAPH
    {0xDD48, 0x5BD6}, //8959 #CJK UNIFIED IDEOGRAPH
    {0xDD49, 0x5BD8}, //8960 #CJK UNIFIED IDEOGRAPH
    {0xDD4A, 0x5BD9}, //8961 #CJK UNIFIED IDEOGRAPH
    {0xDD4B, 0x5C1F}, //8962 #CJK UNIFIED IDEOGRAPH
    {0xDD4C, 0x5C33}, //8963 #CJK UNIFIED IDEOGRAPH
    {0xDD4D, 0x5D71}, //8964 #CJK UNIFIED IDEOGRAPH
    {0xDD4E, 0x5D63}, //8965 #CJK UNIFIED IDEOGRAPH
    {0xDD4F, 0x5D4A}, //8966 #CJK UNIFIED IDEOGRAPH
    {0xDD50, 0x5D65}, //8967 #CJK UNIFIED IDEOGRAPH
    {0xDD51, 0x5D72}, //8968 #CJK UNIFIED IDEOGRAPH
    {0xDD52, 0x5D6C}, //8969 #CJK UNIFIED IDEOGRAPH
    {0xDD53, 0x5D5E}, //8970 #CJK UNIFIED IDEOGRAPH
    {0xDD54, 0x5D68}, //8971 #CJK UNIFIED IDEOGRAPH
    {0xDD55, 0x5D67}, //8972 #CJK UNIFIED IDEOGRAPH
    {0xDD56, 0x5D62}, //8973 #CJK UNIFIED IDEOGRAPH
    {0xDD57, 0x5DF0}, //8974 #CJK UNIFIED IDEOGRAPH
    {0xDD58, 0x5E4F}, //8975 #CJK UNIFIED IDEOGRAPH
    {0xDD59, 0x5E4E}, //8976 #CJK UNIFIED IDEOGRAPH
    {0xDD5A, 0x5E4A}, //8977 #CJK UNIFIED IDEOGRAPH
    {0xDD5B, 0x5E4D}, //8978 #CJK UNIFIED IDEOGRAPH
    {0xDD5C, 0x5E4B}, //8979 #CJK UNIFIED IDEOGRAPH
    {0xDD5D, 0x5EC5}, //8980 #CJK UNIFIED IDEOGRAPH
    {0xDD5E, 0x5ECC}, //8981 #CJK UNIFIED IDEOGRAPH
    {0xDD5F, 0x5EC6}, //8982 #CJK UNIFIED IDEOGRAPH
    {0xDD60, 0x5ECB}, //8983 #CJK UNIFIED IDEOGRAPH
    {0xDD61, 0x5EC7}, //8984 #CJK UNIFIED IDEOGRAPH
    {0xDD62, 0x5F40}, //8985 #CJK UNIFIED IDEOGRAPH
    {0xDD63, 0x5FAF}, //8986 #CJK UNIFIED IDEOGRAPH
    {0xDD64, 0x5FAD}, //8987 #CJK UNIFIED IDEOGRAPH
    {0xDD65, 0x60F7}, //8988 #CJK UNIFIED IDEOGRAPH
    {0xDD66, 0x6149}, //8989 #CJK UNIFIED IDEOGRAPH
    {0xDD67, 0x614A}, //8990 #CJK UNIFIED IDEOGRAPH
    {0xDD68, 0x612B}, //8991 #CJK UNIFIED IDEOGRAPH
    {0xDD69, 0x6145}, //8992 #CJK UNIFIED IDEOGRAPH
    {0xDD6A, 0x6136}, //8993 #CJK UNIFIED IDEOGRAPH
    {0xDD6B, 0x6132}, //8994 #CJK UNIFIED IDEOGRAPH
    {0xDD6C, 0x612E}, //8995 #CJK UNIFIED IDEOGRAPH
    {0xDD6D, 0x6146}, //8996 #CJK UNIFIED IDEOGRAPH
    {0xDD6E, 0x612F}, //8997 #CJK UNIFIED IDEOGRAPH
    {0xDD6F, 0x614F}, //8998 #CJK UNIFIED IDEOGRAPH
    {0xDD70, 0x6129}, //8999 #CJK UNIFIED IDEOGRAPH
    {0xDD71, 0x6140}, //9000 #CJK UNIFIED IDEOGRAPH
    {0xDD72, 0x6220}, //9001 #CJK UNIFIED IDEOGRAPH
    {0xDD73, 0x9168}, //9002 #CJK UNIFIED IDEOGRAPH
    {0xDD74, 0x6223}, //9003 #CJK UNIFIED IDEOGRAPH
    {0xDD75, 0x6225}, //9004 #CJK UNIFIED IDEOGRAPH
    {0xDD76, 0x6224}, //9005 #CJK UNIFIED IDEOGRAPH
    {0xDD77, 0x63C5}, //9006 #CJK UNIFIED IDEOGRAPH
    {0xDD78, 0x63F1}, //9007 #CJK UNIFIED IDEOGRAPH
    {0xDD79, 0x63EB}, //9008 #CJK UNIFIED IDEOGRAPH
    {0xDD7A, 0x6410}, //9009 #CJK UNIFIED IDEOGRAPH
    {0xDD7B, 0x6412}, //9010 #CJK UNIFIED IDEOGRAPH
    {0xDD7C, 0x6409}, //9011 #CJK UNIFIED IDEOGRAPH
    {0xDD7D, 0x6420}, //9012 #CJK UNIFIED IDEOGRAPH
    {0xDD7E, 0x6424}, //9013 #CJK UNIFIED IDEOGRAPH
    {0xDDA1, 0x6433}, //9014 #CJK UNIFIED IDEOGRAPH
    {0xDDA2, 0x6443}, //9015 #CJK UNIFIED IDEOGRAPH
    {0xDDA3, 0x641F}, //9016 #CJK UNIFIED IDEOGRAPH
    {0xDDA4, 0x6415}, //9017 #CJK UNIFIED IDEOGRAPH
    {0xDDA5, 0x6418}, //9018 #CJK UNIFIED IDEOGRAPH
    {0xDDA6, 0x6439}, //9019 #CJK UNIFIED IDEOGRAPH
    {0xDDA7, 0x6437}, //9020 #CJK UNIFIED IDEOGRAPH
    {0xDDA8, 0x6422}, //9021 #CJK UNIFIED IDEOGRAPH
    {0xDDA9, 0x6423}, //9022 #CJK UNIFIED IDEOGRAPH
    {0xDDAA, 0x640C}, //9023 #CJK UNIFIED IDEOGRAPH
    {0xDDAB, 0x6426}, //9024 #CJK UNIFIED IDEOGRAPH
    {0xDDAC, 0x6430}, //9025 #CJK UNIFIED IDEOGRAPH
    {0xDDAD, 0x6428}, //9026 #CJK UNIFIED IDEOGRAPH
    {0xDDAE, 0x6441}, //9027 #CJK UNIFIED IDEOGRAPH
    {0xDDAF, 0x6435}, //9028 #CJK UNIFIED IDEOGRAPH
    {0xDDB0, 0x642F}, //9029 #CJK UNIFIED IDEOGRAPH
    {0xDDB1, 0x640A}, //9030 #CJK UNIFIED IDEOGRAPH
    {0xDDB2, 0x641A}, //9031 #CJK UNIFIED IDEOGRAPH
    {0xDDB3, 0x6440}, //9032 #CJK UNIFIED IDEOGRAPH
    {0xDDB4, 0x6425}, //9033 #CJK UNIFIED IDEOGRAPH
    {0xDDB5, 0x6427}, //9034 #CJK UNIFIED IDEOGRAPH
    {0xDDB6, 0x640B}, //9035 #CJK UNIFIED IDEOGRAPH
    {0xDDB7, 0x63E7}, //9036 #CJK UNIFIED IDEOGRAPH
    {0xDDB8, 0x641B}, //9037 #CJK UNIFIED IDEOGRAPH
    {0xDDB9, 0x642E}, //9038 #CJK UNIFIED IDEOGRAPH
    {0xDDBA, 0x6421}, //9039 #CJK UNIFIED IDEOGRAPH
    {0xDDBB, 0x640E}, //9040 #CJK UNIFIED IDEOGRAPH
    {0xDDBC, 0x656F}, //9041 #CJK UNIFIED IDEOGRAPH
    {0xDDBD, 0x6592}, //9042 #CJK UNIFIED IDEOGRAPH
    {0xDDBE, 0x65D3}, //9043 #CJK UNIFIED IDEOGRAPH
    {0xDDBF, 0x6686}, //9044 #CJK UNIFIED IDEOGRAPH
    {0xDDC0, 0x668C}, //9045 #CJK UNIFIED IDEOGRAPH
    {0xDDC1, 0x6695}, //9046 #CJK UNIFIED IDEOGRAPH
    {0xDDC2, 0x6690}, //9047 #CJK UNIFIED IDEOGRAPH
    {0xDDC3, 0x668B}, //9048 #CJK UNIFIED IDEOGRAPH
    {0xDDC4, 0x668A}, //9049 #CJK UNIFIED IDEOGRAPH
    {0xDDC5, 0x6699}, //9050 #CJK UNIFIED IDEOGRAPH
    {0xDDC6, 0x6694}, //9051 #CJK UNIFIED IDEOGRAPH
    {0xDDC7, 0x6678}, //9052 #CJK UNIFIED IDEOGRAPH
    {0xDDC8, 0x6720}, //9053 #CJK UNIFIED IDEOGRAPH
    {0xDDC9, 0x6966}, //9054 #CJK UNIFIED IDEOGRAPH
    {0xDDCA, 0x695F}, //9055 #CJK UNIFIED IDEOGRAPH
    {0xDDCB, 0x6938}, //9056 #CJK UNIFIED IDEOGRAPH
    {0xDDCC, 0x694E}, //9057 #CJK UNIFIED IDEOGRAPH
    {0xDDCD, 0x6962}, //9058 #CJK UNIFIED IDEOGRAPH
    {0xDDCE, 0x6971}, //9059 #CJK UNIFIED IDEOGRAPH
    {0xDDCF, 0x693F}, //9060 #CJK UNIFIED IDEOGRAPH
    {0xDDD0, 0x6945}, //9061 #CJK UNIFIED IDEOGRAPH
    {0xDDD1, 0x696A}, //9062 #CJK UNIFIED IDEOGRAPH
    {0xDDD2, 0x6939}, //9063 #CJK UNIFIED IDEOGRAPH
    {0xDDD3, 0x6942}, //9064 #CJK UNIFIED IDEOGRAPH
    {0xDDD4, 0x6957}, //9065 #CJK UNIFIED IDEOGRAPH
    {0xDDD5, 0x6959}, //9066 #CJK UNIFIED IDEOGRAPH
    {0xDDD6, 0x697A}, //9067 #CJK UNIFIED IDEOGRAPH
    {0xDDD7, 0x6948}, //9068 #CJK UNIFIED IDEOGRAPH
    {0xDDD8, 0x6949}, //9069 #CJK UNIFIED IDEOGRAPH
    {0xDDD9, 0x6935}, //9070 #CJK UNIFIED IDEOGRAPH
    {0xDDDA, 0x696C}, //9071 #CJK UNIFIED IDEOGRAPH
    {0xDDDB, 0x6933}, //9072 #CJK UNIFIED IDEOGRAPH
    {0xDDDC, 0x693D}, //9073 #CJK UNIFIED IDEOGRAPH
    {0xDDDD, 0x6965}, //9074 #CJK UNIFIED IDEOGRAPH
    {0xDDDE, 0x68F0}, //9075 #CJK UNIFIED IDEOGRAPH
    {0xDDDF, 0x6978}, //9076 #CJK UNIFIED IDEOGRAPH
    {0xDDE0, 0x6934}, //9077 #CJK UNIFIED IDEOGRAPH
    {0xDDE1, 0x6969}, //9078 #CJK UNIFIED IDEOGRAPH
    {0xDDE2, 0x6940}, //9079 #CJK UNIFIED IDEOGRAPH
    {0xDDE3, 0x696F}, //9080 #CJK UNIFIED IDEOGRAPH
    {0xDDE4, 0x6944}, //9081 #CJK UNIFIED IDEOGRAPH
    {0xDDE5, 0x6976}, //9082 #CJK UNIFIED IDEOGRAPH
    {0xDDE6, 0x6958}, //9083 #CJK UNIFIED IDEOGRAPH
    {0xDDE7, 0x6941}, //9084 #CJK UNIFIED IDEOGRAPH
    {0xDDE8, 0x6974}, //9085 #CJK UNIFIED IDEOGRAPH
    {0xDDE9, 0x694C}, //9086 #CJK UNIFIED IDEOGRAPH
    {0xDDEA, 0x693B}, //9087 #CJK UNIFIED IDEOGRAPH
    {0xDDEB, 0x694B}, //9088 #CJK UNIFIED IDEOGRAPH
    {0xDDEC, 0x6937}, //9089 #CJK UNIFIED IDEOGRAPH
    {0xDDED, 0x695C}, //9090 #CJK UNIFIED IDEOGRAPH
    {0xDDEE, 0x694F}, //9091 #CJK UNIFIED IDEOGRAPH
    {0xDDEF, 0x6951}, //9092 #CJK UNIFIED IDEOGRAPH
    {0xDDF0, 0x6932}, //9093 #CJK UNIFIED IDEOGRAPH
    {0xDDF1, 0x6952}, //9094 #CJK UNIFIED IDEOGRAPH
    {0xDDF2, 0x692F}, //9095 #CJK UNIFIED IDEOGRAPH
    {0xDDF3, 0x697B}, //9096 #CJK UNIFIED IDEOGRAPH
    {0xDDF4, 0x693C}, //9097 #CJK UNIFIED IDEOGRAPH
    {0xDDF5, 0x6B46}, //9098 #CJK UNIFIED IDEOGRAPH
    {0xDDF6, 0x6B45}, //9099 #CJK UNIFIED IDEOGRAPH
    {0xDDF7, 0x6B43}, //9100 #CJK UNIFIED IDEOGRAPH
    {0xDDF8, 0x6B42}, //9101 #CJK UNIFIED IDEOGRAPH
    {0xDDF9, 0x6B48}, //9102 #CJK UNIFIED IDEOGRAPH
    {0xDDFA, 0x6B41}, //9103 #CJK UNIFIED IDEOGRAPH
    {0xDDFB, 0x6B9B}, //9104 #CJK UNIFIED IDEOGRAPH
    {0xDDFC, 0xFA0D}, //9105 #CJK COMPATIBILITY IDEOGRAPH
    {0xDDFD, 0x6BFB}, //9106 #CJK UNIFIED IDEOGRAPH
    {0xDDFE, 0x6BFC}, //9107 #CJK UNIFIED IDEOGRAPH
    {0xDE40, 0x6BF9}, //9108 #CJK UNIFIED IDEOGRAPH
    {0xDE41, 0x6BF7}, //9109 #CJK UNIFIED IDEOGRAPH
    {0xDE42, 0x6BF8}, //9110 #CJK UNIFIED IDEOGRAPH
    {0xDE43, 0x6E9B}, //9111 #CJK UNIFIED IDEOGRAPH
    {0xDE44, 0x6ED6}, //9112 #CJK UNIFIED IDEOGRAPH
    {0xDE45, 0x6EC8}, //9113 #CJK UNIFIED IDEOGRAPH
    {0xDE46, 0x6E8F}, //9114 #CJK UNIFIED IDEOGRAPH
    {0xDE47, 0x6EC0}, //9115 #CJK UNIFIED IDEOGRAPH
    {0xDE48, 0x6E9F}, //9116 #CJK UNIFIED IDEOGRAPH
    {0xDE49, 0x6E93}, //9117 #CJK UNIFIED IDEOGRAPH
    {0xDE4A, 0x6E94}, //9118 #CJK UNIFIED IDEOGRAPH
    {0xDE4B, 0x6EA0}, //9119 #CJK UNIFIED IDEOGRAPH
    {0xDE4C, 0x6EB1}, //9120 #CJK UNIFIED IDEOGRAPH
    {0xDE4D, 0x6EB9}, //9121 #CJK UNIFIED IDEOGRAPH
    {0xDE4E, 0x6EC6}, //9122 #CJK UNIFIED IDEOGRAPH
    {0xDE4F, 0x6ED2}, //9123 #CJK UNIFIED IDEOGRAPH
    {0xDE50, 0x6EBD}, //9124 #CJK UNIFIED IDEOGRAPH
    {0xDE51, 0x6EC1}, //9125 #CJK UNIFIED IDEOGRAPH
    {0xDE52, 0x6E9E}, //9126 #CJK UNIFIED IDEOGRAPH
    {0xDE53, 0x6EC9}, //9127 #CJK UNIFIED IDEOGRAPH
    {0xDE54, 0x6EB7}, //9128 #CJK UNIFIED IDEOGRAPH
    {0xDE55, 0x6EB0}, //9129 #CJK UNIFIED IDEOGRAPH
    {0xDE56, 0x6ECD}, //9130 #CJK UNIFIED IDEOGRAPH
    {0xDE57, 0x6EA6}, //9131 #CJK UNIFIED IDEOGRAPH
    {0xDE58, 0x6ECF}, //9132 #CJK UNIFIED IDEOGRAPH
    {0xDE59, 0x6EB2}, //9133 #CJK UNIFIED IDEOGRAPH
    {0xDE5A, 0x6EBE}, //9134 #CJK UNIFIED IDEOGRAPH
    {0xDE5B, 0x6EC3}, //9135 #CJK UNIFIED IDEOGRAPH
    {0xDE5C, 0x6EDC}, //9136 #CJK UNIFIED IDEOGRAPH
    {0xDE5D, 0x6ED8}, //9137 #CJK UNIFIED IDEOGRAPH
    {0xDE5E, 0x6E99}, //9138 #CJK UNIFIED IDEOGRAPH
    {0xDE5F, 0x6E92}, //9139 #CJK UNIFIED IDEOGRAPH
    {0xDE60, 0x6E8E}, //9140 #CJK UNIFIED IDEOGRAPH
    {0xDE61, 0x6E8D}, //9141 #CJK UNIFIED IDEOGRAPH
    {0xDE62, 0x6EA4}, //9142 #CJK UNIFIED IDEOGRAPH
    {0xDE63, 0x6EA1}, //9143 #CJK UNIFIED IDEOGRAPH
    {0xDE64, 0x6EBF}, //9144 #CJK UNIFIED IDEOGRAPH
    {0xDE65, 0x6EB3}, //9145 #CJK UNIFIED IDEOGRAPH
    {0xDE66, 0x6ED0}, //9146 #CJK UNIFIED IDEOGRAPH
    {0xDE67, 0x6ECA}, //9147 #CJK UNIFIED IDEOGRAPH
    {0xDE68, 0x6E97}, //9148 #CJK UNIFIED IDEOGRAPH
    {0xDE69, 0x6EAE}, //9149 #CJK UNIFIED IDEOGRAPH
    {0xDE6A, 0x6EA3}, //9150 #CJK UNIFIED IDEOGRAPH
    {0xDE6B, 0x7147}, //9151 #CJK UNIFIED IDEOGRAPH
    {0xDE6C, 0x7154}, //9152 #CJK UNIFIED IDEOGRAPH
    {0xDE6D, 0x7152}, //9153 #CJK UNIFIED IDEOGRAPH
    {0xDE6E, 0x7163}, //9154 #CJK UNIFIED IDEOGRAPH
    {0xDE6F, 0x7160}, //9155 #CJK UNIFIED IDEOGRAPH
    {0xDE70, 0x7141}, //9156 #CJK UNIFIED IDEOGRAPH
    {0xDE71, 0x715D}, //9157 #CJK UNIFIED IDEOGRAPH
    {0xDE72, 0x7162}, //9158 #CJK UNIFIED IDEOGRAPH
    {0xDE73, 0x7172}, //9159 #CJK UNIFIED IDEOGRAPH
    {0xDE74, 0x7178}, //9160 #CJK UNIFIED IDEOGRAPH
    {0xDE75, 0x716A}, //9161 #CJK UNIFIED IDEOGRAPH
    {0xDE76, 0x7161}, //9162 #CJK UNIFIED IDEOGRAPH
    {0xDE77, 0x7142}, //9163 #CJK UNIFIED IDEOGRAPH
    {0xDE78, 0x7158}, //9164 #CJK UNIFIED IDEOGRAPH
    {0xDE79, 0x7143}, //9165 #CJK UNIFIED IDEOGRAPH
    {0xDE7A, 0x714B}, //9166 #CJK UNIFIED IDEOGRAPH
    {0xDE7B, 0x7170}, //9167 #CJK UNIFIED IDEOGRAPH
    {0xDE7C, 0x715F}, //9168 #CJK UNIFIED IDEOGRAPH
    {0xDE7D, 0x7150}, //9169 #CJK UNIFIED IDEOGRAPH
    {0xDE7E, 0x7153}, //9170 #CJK UNIFIED IDEOGRAPH
    {0xDEA1, 0x7144}, //9171 #CJK UNIFIED IDEOGRAPH
    {0xDEA2, 0x714D}, //9172 #CJK UNIFIED IDEOGRAPH
    {0xDEA3, 0x715A}, //9173 #CJK UNIFIED IDEOGRAPH
    {0xDEA4, 0x724F}, //9174 #CJK UNIFIED IDEOGRAPH
    {0xDEA5, 0x728D}, //9175 #CJK UNIFIED IDEOGRAPH
    {0xDEA6, 0x728C}, //9176 #CJK UNIFIED IDEOGRAPH
    {0xDEA7, 0x7291}, //9177 #CJK UNIFIED IDEOGRAPH
    {0xDEA8, 0x7290}, //9178 #CJK UNIFIED IDEOGRAPH
    {0xDEA9, 0x728E}, //9179 #CJK UNIFIED IDEOGRAPH
    {0xDEAA, 0x733C}, //9180 #CJK UNIFIED IDEOGRAPH
    {0xDEAB, 0x7342}, //9181 #CJK UNIFIED IDEOGRAPH
    {0xDEAC, 0x733B}, //9182 #CJK UNIFIED IDEOGRAPH
    {0xDEAD, 0x733A}, //9183 #CJK UNIFIED IDEOGRAPH
    {0xDEAE, 0x7340}, //9184 #CJK UNIFIED IDEOGRAPH
    {0xDEAF, 0x734A}, //9185 #CJK UNIFIED IDEOGRAPH
    {0xDEB0, 0x7349}, //9186 #CJK UNIFIED IDEOGRAPH
    {0xDEB1, 0x7444}, //9187 #CJK UNIFIED IDEOGRAPH
    {0xDEB2, 0x744A}, //9188 #CJK UNIFIED IDEOGRAPH
    {0xDEB3, 0x744B}, //9189 #CJK UNIFIED IDEOGRAPH
    {0xDEB4, 0x7452}, //9190 #CJK UNIFIED IDEOGRAPH
    {0xDEB5, 0x7451}, //9191 #CJK UNIFIED IDEOGRAPH
    {0xDEB6, 0x7457}, //9192 #CJK UNIFIED IDEOGRAPH
    {0xDEB7, 0x7440}, //9193 #CJK UNIFIED IDEOGRAPH
    {0xDEB8, 0x744F}, //9194 #CJK UNIFIED IDEOGRAPH
    {0xDEB9, 0x7450}, //9195 #CJK UNIFIED IDEOGRAPH
    {0xDEBA, 0x744E}, //9196 #CJK UNIFIED IDEOGRAPH
    {0xDEBB, 0x7442}, //9197 #CJK UNIFIED IDEOGRAPH
    {0xDEBC, 0x7446}, //9198 #CJK UNIFIED IDEOGRAPH
    {0xDEBD, 0x744D}, //9199 #CJK UNIFIED IDEOGRAPH
    {0xDEBE, 0x7454}, //9200 #CJK UNIFIED IDEOGRAPH
    {0xDEBF, 0x74E1}, //9201 #CJK UNIFIED IDEOGRAPH
    {0xDEC0, 0x74FF}, //9202 #CJK UNIFIED IDEOGRAPH
    {0xDEC1, 0x74FE}, //9203 #CJK UNIFIED IDEOGRAPH
    {0xDEC2, 0x74FD}, //9204 #CJK UNIFIED IDEOGRAPH
    {0xDEC3, 0x751D}, //9205 #CJK UNIFIED IDEOGRAPH
    {0xDEC4, 0x7579}, //9206 #CJK UNIFIED IDEOGRAPH
    {0xDEC5, 0x7577}, //9207 #CJK UNIFIED IDEOGRAPH
    {0xDEC6, 0x6983}, //9208 #CJK UNIFIED IDEOGRAPH
    {0xDEC7, 0x75EF}, //9209 #CJK UNIFIED IDEOGRAPH
    {0xDEC8, 0x760F}, //9210 #CJK UNIFIED IDEOGRAPH
    {0xDEC9, 0x7603}, //9211 #CJK UNIFIED IDEOGRAPH
    {0xDECA, 0x75F7}, //9212 #CJK UNIFIED IDEOGRAPH
    {0xDECB, 0x75FE}, //9213 #CJK UNIFIED IDEOGRAPH
    {0xDECC, 0x75FC}, //9214 #CJK UNIFIED IDEOGRAPH
    {0xDECD, 0x75F9}, //9215 #CJK UNIFIED IDEOGRAPH
    {0xDECE, 0x75F8}, //9216 #CJK UNIFIED IDEOGRAPH
    {0xDECF, 0x7610}, //9217 #CJK UNIFIED IDEOGRAPH
    {0xDED0, 0x75FB}, //9218 #CJK UNIFIED IDEOGRAPH
    {0xDED1, 0x75F6}, //9219 #CJK UNIFIED IDEOGRAPH
    {0xDED2, 0x75ED}, //9220 #CJK UNIFIED IDEOGRAPH
    {0xDED3, 0x75F5}, //9221 #CJK UNIFIED IDEOGRAPH
    {0xDED4, 0x75FD}, //9222 #CJK UNIFIED IDEOGRAPH
    {0xDED5, 0x7699}, //9223 #CJK UNIFIED IDEOGRAPH
    {0xDED6, 0x76B5}, //9224 #CJK UNIFIED IDEOGRAPH
    {0xDED7, 0x76DD}, //9225 #CJK UNIFIED IDEOGRAPH
    {0xDED8, 0x7755}, //9226 #CJK UNIFIED IDEOGRAPH
    {0xDED9, 0x775F}, //9227 #CJK UNIFIED IDEOGRAPH
    {0xDEDA, 0x7760}, //9228 #CJK UNIFIED IDEOGRAPH
    {0xDEDB, 0x7752}, //9229 #CJK UNIFIED IDEOGRAPH
    {0xDEDC, 0x7756}, //9230 #CJK UNIFIED IDEOGRAPH
    {0xDEDD, 0x775A}, //9231 #CJK UNIFIED IDEOGRAPH
    {0xDEDE, 0x7769}, //9232 #CJK UNIFIED IDEOGRAPH
    {0xDEDF, 0x7767}, //9233 #CJK UNIFIED IDEOGRAPH
    {0xDEE0, 0x7754}, //9234 #CJK UNIFIED IDEOGRAPH
    {0xDEE1, 0x7759}, //9235 #CJK UNIFIED IDEOGRAPH
    {0xDEE2, 0x776D}, //9236 #CJK UNIFIED IDEOGRAPH
    {0xDEE3, 0x77E0}, //9237 #CJK UNIFIED IDEOGRAPH
    {0xDEE4, 0x7887}, //9238 #CJK UNIFIED IDEOGRAPH
    {0xDEE5, 0x789A}, //9239 #CJK UNIFIED IDEOGRAPH
    {0xDEE6, 0x7894}, //9240 #CJK UNIFIED IDEOGRAPH
    {0xDEE7, 0x788F}, //9241 #CJK UNIFIED IDEOGRAPH
    {0xDEE8, 0x7884}, //9242 #CJK UNIFIED IDEOGRAPH
    {0xDEE9, 0x7895}, //9243 #CJK UNIFIED IDEOGRAPH
    {0xDEEA, 0x7885}, //9244 #CJK UNIFIED IDEOGRAPH
    {0xDEEB, 0x7886}, //9245 #CJK UNIFIED IDEOGRAPH
    {0xDEEC, 0x78A1}, //9246 #CJK UNIFIED IDEOGRAPH
    {0xDEED, 0x7883}, //9247 #CJK UNIFIED IDEOGRAPH
    {0xDEEE, 0x7879}, //9248 #CJK UNIFIED IDEOGRAPH
    {0xDEEF, 0x7899}, //9249 #CJK UNIFIED IDEOGRAPH
    {0xDEF0, 0x7880}, //9250 #CJK UNIFIED IDEOGRAPH
    {0xDEF1, 0x7896}, //9251 #CJK UNIFIED IDEOGRAPH
    {0xDEF2, 0x787B}, //9252 #CJK UNIFIED IDEOGRAPH
    {0xDEF3, 0x797C}, //9253 #CJK UNIFIED IDEOGRAPH
    {0xDEF4, 0x7982}, //9254 #CJK UNIFIED IDEOGRAPH
    {0xDEF5, 0x797D}, //9255 #CJK UNIFIED IDEOGRAPH
    {0xDEF6, 0x7979}, //9256 #CJK UNIFIED IDEOGRAPH
    {0xDEF7, 0x7A11}, //9257 #CJK UNIFIED IDEOGRAPH
    {0xDEF8, 0x7A18}, //9258 #CJK UNIFIED IDEOGRAPH
    {0xDEF9, 0x7A19}, //9259 #CJK UNIFIED IDEOGRAPH
    {0xDEFA, 0x7A12}, //9260 #CJK UNIFIED IDEOGRAPH
    {0xDEFB, 0x7A17}, //9261 #CJK UNIFIED IDEOGRAPH
    {0xDEFC, 0x7A15}, //9262 #CJK UNIFIED IDEOGRAPH
    {0xDEFD, 0x7A22}, //9263 #CJK UNIFIED IDEOGRAPH
    {0xDEFE, 0x7A13}, //9264 #CJK UNIFIED IDEOGRAPH
    {0xDF40, 0x7A1B}, //9265 #CJK UNIFIED IDEOGRAPH
    {0xDF41, 0x7A10}, //9266 #CJK UNIFIED IDEOGRAPH
    {0xDF42, 0x7AA3}, //9267 #CJK UNIFIED IDEOGRAPH
    {0xDF43, 0x7AA2}, //9268 #CJK UNIFIED IDEOGRAPH
    {0xDF44, 0x7A9E}, //9269 #CJK UNIFIED IDEOGRAPH
    {0xDF45, 0x7AEB}, //9270 #CJK UNIFIED IDEOGRAPH
    {0xDF46, 0x7B66}, //9271 #CJK UNIFIED IDEOGRAPH
    {0xDF47, 0x7B64}, //9272 #CJK UNIFIED IDEOGRAPH
    {0xDF48, 0x7B6D}, //9273 #CJK UNIFIED IDEOGRAPH
    {0xDF49, 0x7B74}, //9274 #CJK UNIFIED IDEOGRAPH
    {0xDF4A, 0x7B69}, //9275 #CJK UNIFIED IDEOGRAPH
    {0xDF4B, 0x7B72}, //9276 #CJK UNIFIED IDEOGRAPH
    {0xDF4C, 0x7B65}, //9277 #CJK UNIFIED IDEOGRAPH
    {0xDF4D, 0x7B73}, //9278 #CJK UNIFIED IDEOGRAPH
    {0xDF4E, 0x7B71}, //9279 #CJK UNIFIED IDEOGRAPH
    {0xDF4F, 0x7B70}, //9280 #CJK UNIFIED IDEOGRAPH
    {0xDF50, 0x7B61}, //9281 #CJK UNIFIED IDEOGRAPH
    {0xDF51, 0x7B78}, //9282 #CJK UNIFIED IDEOGRAPH
    {0xDF52, 0x7B76}, //9283 #CJK UNIFIED IDEOGRAPH
    {0xDF53, 0x7B63}, //9284 #CJK UNIFIED IDEOGRAPH
    {0xDF54, 0x7CB2}, //9285 #CJK UNIFIED IDEOGRAPH
    {0xDF55, 0x7CB4}, //9286 #CJK UNIFIED IDEOGRAPH
    {0xDF56, 0x7CAF}, //9287 #CJK UNIFIED IDEOGRAPH
    {0xDF57, 0x7D88}, //9288 #CJK UNIFIED IDEOGRAPH
    {0xDF58, 0x7D86}, //9289 #CJK UNIFIED IDEOGRAPH
    {0xDF59, 0x7D80}, //9290 #CJK UNIFIED IDEOGRAPH
    {0xDF5A, 0x7D8D}, //9291 #CJK UNIFIED IDEOGRAPH
    {0xDF5B, 0x7D7F}, //9292 #CJK UNIFIED IDEOGRAPH
    {0xDF5C, 0x7D85}, //9293 #CJK UNIFIED IDEOGRAPH
    {0xDF5D, 0x7D7A}, //9294 #CJK UNIFIED IDEOGRAPH
    {0xDF5E, 0x7D8E}, //9295 #CJK UNIFIED IDEOGRAPH
    {0xDF5F, 0x7D7B}, //9296 #CJK UNIFIED IDEOGRAPH
    {0xDF60, 0x7D83}, //9297 #CJK UNIFIED IDEOGRAPH
    {0xDF61, 0x7D7C}, //9298 #CJK UNIFIED IDEOGRAPH
    {0xDF62, 0x7D8C}, //9299 #CJK UNIFIED IDEOGRAPH
    {0xDF63, 0x7D94}, //9300 #CJK UNIFIED IDEOGRAPH
    {0xDF64, 0x7D84}, //9301 #CJK UNIFIED IDEOGRAPH
    {0xDF65, 0x7D7D}, //9302 #CJK UNIFIED IDEOGRAPH
    {0xDF66, 0x7D92}, //9303 #CJK UNIFIED IDEOGRAPH
    {0xDF67, 0x7F6D}, //9304 #CJK UNIFIED IDEOGRAPH
    {0xDF68, 0x7F6B}, //9305 #CJK UNIFIED IDEOGRAPH
    {0xDF69, 0x7F67}, //9306 #CJK UNIFIED IDEOGRAPH
    {0xDF6A, 0x7F68}, //9307 #CJK UNIFIED IDEOGRAPH
    {0xDF6B, 0x7F6C}, //9308 #CJK UNIFIED IDEOGRAPH
    {0xDF6C, 0x7FA6}, //9309 #CJK UNIFIED IDEOGRAPH
    {0xDF6D, 0x7FA5}, //9310 #CJK UNIFIED IDEOGRAPH
    {0xDF6E, 0x7FA7}, //9311 #CJK UNIFIED IDEOGRAPH
    {0xDF6F, 0x7FDB}, //9312 #CJK UNIFIED IDEOGRAPH
    {0xDF70, 0x7FDC}, //9313 #CJK UNIFIED IDEOGRAPH
    {0xDF71, 0x8021}, //9314 #CJK UNIFIED IDEOGRAPH
    {0xDF72, 0x8164}, //9315 #CJK UNIFIED IDEOGRAPH
    {0xDF73, 0x8160}, //9316 #CJK UNIFIED IDEOGRAPH
    {0xDF74, 0x8177}, //9317 #CJK UNIFIED IDEOGRAPH
    {0xDF75, 0x815C}, //9318 #CJK UNIFIED IDEOGRAPH
    {0xDF76, 0x8169}, //9319 #CJK UNIFIED IDEOGRAPH
    {0xDF77, 0x815B}, //9320 #CJK UNIFIED IDEOGRAPH
    {0xDF78, 0x8162}, //9321 #CJK UNIFIED IDEOGRAPH
    {0xDF79, 0x8172}, //9322 #CJK UNIFIED IDEOGRAPH
    {0xDF7A, 0x6721}, //9323 #CJK UNIFIED IDEOGRAPH
    {0xDF7B, 0x815E}, //9324 #CJK UNIFIED IDEOGRAPH
    {0xDF7C, 0x8176}, //9325 #CJK UNIFIED IDEOGRAPH
    {0xDF7D, 0x8167}, //9326 #CJK UNIFIED IDEOGRAPH
    {0xDF7E, 0x816F}, //9327 #CJK UNIFIED IDEOGRAPH
    {0xDFA1, 0x8144}, //9328 #CJK UNIFIED IDEOGRAPH
    {0xDFA2, 0x8161}, //9329 #CJK UNIFIED IDEOGRAPH
    {0xDFA3, 0x821D}, //9330 #CJK UNIFIED IDEOGRAPH
    {0xDFA4, 0x8249}, //9331 #CJK UNIFIED IDEOGRAPH
    {0xDFA5, 0x8244}, //9332 #CJK UNIFIED IDEOGRAPH
    {0xDFA6, 0x8240}, //9333 #CJK UNIFIED IDEOGRAPH
    {0xDFA7, 0x8242}, //9334 #CJK UNIFIED IDEOGRAPH
    {0xDFA8, 0x8245}, //9335 #CJK UNIFIED IDEOGRAPH
    {0xDFA9, 0x84F1}, //9336 #CJK UNIFIED IDEOGRAPH
    {0xDFAA, 0x843F}, //9337 #CJK UNIFIED IDEOGRAPH
    {0xDFAB, 0x8456}, //9338 #CJK UNIFIED IDEOGRAPH
    {0xDFAC, 0x8476}, //9339 #CJK UNIFIED IDEOGRAPH
    {0xDFAD, 0x8479}, //9340 #CJK UNIFIED IDEOGRAPH
    {0xDFAE, 0x848F}, //9341 #CJK UNIFIED IDEOGRAPH
    {0xDFAF, 0x848D}, //9342 #CJK UNIFIED IDEOGRAPH
    {0xDFB0, 0x8465}, //9343 #CJK UNIFIED IDEOGRAPH
    {0xDFB1, 0x8451}, //9344 #CJK UNIFIED IDEOGRAPH
    {0xDFB2, 0x8440}, //9345 #CJK UNIFIED IDEOGRAPH
    {0xDFB3, 0x8486}, //9346 #CJK UNIFIED IDEOGRAPH
    {0xDFB4, 0x8467}, //9347 #CJK UNIFIED IDEOGRAPH
    {0xDFB5, 0x8430}, //9348 #CJK UNIFIED IDEOGRAPH
    {0xDFB6, 0x844D}, //9349 #CJK UNIFIED IDEOGRAPH
    {0xDFB7, 0x847D}, //9350 #CJK UNIFIED IDEOGRAPH
    {0xDFB8, 0x845A}, //9351 #CJK UNIFIED IDEOGRAPH
    {0xDFB9, 0x8459}, //9352 #CJK UNIFIED IDEOGRAPH
    {0xDFBA, 0x8474}, //9353 #CJK UNIFIED IDEOGRAPH
    {0xDFBB, 0x8473}, //9354 #CJK UNIFIED IDEOGRAPH
    {0xDFBC, 0x845D}, //9355 #CJK UNIFIED IDEOGRAPH
    {0xDFBD, 0x8507}, //9356 #CJK UNIFIED IDEOGRAPH
    {0xDFBE, 0x845E}, //9357 #CJK UNIFIED IDEOGRAPH
    {0xDFBF, 0x8437}, //9358 #CJK UNIFIED IDEOGRAPH
    {0xDFC0, 0x843A}, //9359 #CJK UNIFIED IDEOGRAPH
    {0xDFC1, 0x8434}, //9360 #CJK UNIFIED IDEOGRAPH
    {0xDFC2, 0x847A}, //9361 #CJK UNIFIED IDEOGRAPH
    {0xDFC3, 0x8443}, //9362 #CJK UNIFIED IDEOGRAPH
    {0xDFC4, 0x8478}, //9363 #CJK UNIFIED IDEOGRAPH
    {0xDFC5, 0x8432}, //9364 #CJK UNIFIED IDEOGRAPH
    {0xDFC6, 0x8445}, //9365 #CJK UNIFIED IDEOGRAPH
    {0xDFC7, 0x8429}, //9366 #CJK UNIFIED IDEOGRAPH
    {0xDFC8, 0x83D9}, //9367 #CJK UNIFIED IDEOGRAPH
    {0xDFC9, 0x844B}, //9368 #CJK UNIFIED IDEOGRAPH
    {0xDFCA, 0x842F}, //9369 #CJK UNIFIED IDEOGRAPH
    {0xDFCB, 0x8442}, //9370 #CJK UNIFIED IDEOGRAPH
    {0xDFCC, 0x842D}, //9371 #CJK UNIFIED IDEOGRAPH
    {0xDFCD, 0x845F}, //9372 #CJK UNIFIED IDEOGRAPH
    {0xDFCE, 0x8470}, //9373 #CJK UNIFIED IDEOGRAPH
    {0xDFCF, 0x8439}, //9374 #CJK UNIFIED IDEOGRAPH
    {0xDFD0, 0x844E}, //9375 #CJK UNIFIED IDEOGRAPH
    {0xDFD1, 0x844C}, //9376 #CJK UNIFIED IDEOGRAPH
    {0xDFD2, 0x8452}, //9377 #CJK UNIFIED IDEOGRAPH
    {0xDFD3, 0x846F}, //9378 #CJK UNIFIED IDEOGRAPH
    {0xDFD4, 0x84C5}, //9379 #CJK UNIFIED IDEOGRAPH
    {0xDFD5, 0x848E}, //9380 #CJK UNIFIED IDEOGRAPH
    {0xDFD6, 0x843B}, //9381 #CJK UNIFIED IDEOGRAPH
    {0xDFD7, 0x8447}, //9382 #CJK UNIFIED IDEOGRAPH
    {0xDFD8, 0x8436}, //9383 #CJK UNIFIED IDEOGRAPH
    {0xDFD9, 0x8433}, //9384 #CJK UNIFIED IDEOGRAPH
    {0xDFDA, 0x8468}, //9385 #CJK UNIFIED IDEOGRAPH
    {0xDFDB, 0x847E}, //9386 #CJK UNIFIED IDEOGRAPH
    {0xDFDC, 0x8444}, //9387 #CJK UNIFIED IDEOGRAPH
    {0xDFDD, 0x842B}, //9388 #CJK UNIFIED IDEOGRAPH
    {0xDFDE, 0x8460}, //9389 #CJK UNIFIED IDEOGRAPH
    {0xDFDF, 0x8454}, //9390 #CJK UNIFIED IDEOGRAPH
    {0xDFE0, 0x846E}, //9391 #CJK UNIFIED IDEOGRAPH
    {0xDFE1, 0x8450}, //9392 #CJK UNIFIED IDEOGRAPH
    {0xDFE2, 0x870B}, //9393 #CJK UNIFIED IDEOGRAPH
    {0xDFE3, 0x8704}, //9394 #CJK UNIFIED IDEOGRAPH
    {0xDFE4, 0x86F7}, //9395 #CJK UNIFIED IDEOGRAPH
    {0xDFE5, 0x870C}, //9396 #CJK UNIFIED IDEOGRAPH
    {0xDFE6, 0x86FA}, //9397 #CJK UNIFIED IDEOGRAPH
    {0xDFE7, 0x86D6}, //9398 #CJK UNIFIED IDEOGRAPH
    {0xDFE8, 0x86F5}, //9399 #CJK UNIFIED IDEOGRAPH
    {0xDFE9, 0x874D}, //9400 #CJK UNIFIED IDEOGRAPH
    {0xDFEA, 0x86F8}, //9401 #CJK UNIFIED IDEOGRAPH
    {0xDFEB, 0x870E}, //9402 #CJK UNIFIED IDEOGRAPH
    {0xDFEC, 0x8709}, //9403 #CJK UNIFIED IDEOGRAPH
    {0xDFED, 0x8701}, //9404 #CJK UNIFIED IDEOGRAPH
    {0xDFEE, 0x86F6}, //9405 #CJK UNIFIED IDEOGRAPH
    {0xDFEF, 0x870D}, //9406 #CJK UNIFIED IDEOGRAPH
    {0xDFF0, 0x8705}, //9407 #CJK UNIFIED IDEOGRAPH
    {0xDFF1, 0x88D6}, //9408 #CJK UNIFIED IDEOGRAPH
    {0xDFF2, 0x88CB}, //9409 #CJK UNIFIED IDEOGRAPH
    {0xDFF3, 0x88CD}, //9410 #CJK UNIFIED IDEOGRAPH
    {0xDFF4, 0x88CE}, //9411 #CJK UNIFIED IDEOGRAPH
    {0xDFF5, 0x88DE}, //9412 #CJK UNIFIED IDEOGRAPH
    {0xDFF6, 0x88DB}, //9413 #CJK UNIFIED IDEOGRAPH
    {0xDFF7, 0x88DA}, //9414 #CJK UNIFIED IDEOGRAPH
    {0xDFF8, 0x88CC}, //9415 #CJK UNIFIED IDEOGRAPH
    {0xDFF9, 0x88D0}, //9416 #CJK UNIFIED IDEOGRAPH
    {0xDFFA, 0x8985}, //9417 #CJK UNIFIED IDEOGRAPH
    {0xDFFB, 0x899B}, //9418 #CJK UNIFIED IDEOGRAPH
    {0xDFFC, 0x89DF}, //9419 #CJK UNIFIED IDEOGRAPH
    {0xDFFD, 0x89E5}, //9420 #CJK UNIFIED IDEOGRAPH
    {0xDFFE, 0x89E4}, //9421 #CJK UNIFIED IDEOGRAPH
    {0xE040, 0x89E1}, //9422 #CJK UNIFIED IDEOGRAPH
    {0xE041, 0x89E0}, //9423 #CJK UNIFIED IDEOGRAPH
    {0xE042, 0x89E2}, //9424 #CJK UNIFIED IDEOGRAPH
    {0xE043, 0x89DC}, //9425 #CJK UNIFIED IDEOGRAPH
    {0xE044, 0x89E6}, //9426 #CJK UNIFIED IDEOGRAPH
    {0xE045, 0x8A76}, //9427 #CJK UNIFIED IDEOGRAPH
    {0xE046, 0x8A86}, //9428 #CJK UNIFIED IDEOGRAPH
    {0xE047, 0x8A7F}, //9429 #CJK UNIFIED IDEOGRAPH
    {0xE048, 0x8A61}, //9430 #CJK UNIFIED IDEOGRAPH
    {0xE049, 0x8A3F}, //9431 #CJK UNIFIED IDEOGRAPH
    {0xE04A, 0x8A77}, //9432 #CJK UNIFIED IDEOGRAPH
    {0xE04B, 0x8A82}, //9433 #CJK UNIFIED IDEOGRAPH
    {0xE04C, 0x8A84}, //9434 #CJK UNIFIED IDEOGRAPH
    {0xE04D, 0x8A75}, //9435 #CJK UNIFIED IDEOGRAPH
    {0xE04E, 0x8A83}, //9436 #CJK UNIFIED IDEOGRAPH
    {0xE04F, 0x8A81}, //9437 #CJK UNIFIED IDEOGRAPH
    {0xE050, 0x8A74}, //9438 #CJK UNIFIED IDEOGRAPH
    {0xE051, 0x8A7A}, //9439 #CJK UNIFIED IDEOGRAPH
    {0xE052, 0x8C3C}, //9440 #CJK UNIFIED IDEOGRAPH
    {0xE053, 0x8C4B}, //9441 #CJK UNIFIED IDEOGRAPH
    {0xE054, 0x8C4A}, //9442 #CJK UNIFIED IDEOGRAPH
    {0xE055, 0x8C65}, //9443 #CJK UNIFIED IDEOGRAPH
    {0xE056, 0x8C64}, //9444 #CJK UNIFIED IDEOGRAPH
    {0xE057, 0x8C66}, //9445 #CJK UNIFIED IDEOGRAPH
    {0xE058, 0x8C86}, //9446 #CJK UNIFIED IDEOGRAPH
    {0xE059, 0x8C84}, //9447 #CJK UNIFIED IDEOGRAPH
    {0xE05A, 0x8C85}, //9448 #CJK UNIFIED IDEOGRAPH
    {0xE05B, 0x8CCC}, //9449 #CJK UNIFIED IDEOGRAPH
    {0xE05C, 0x8D68}, //9450 #CJK UNIFIED IDEOGRAPH
    {0xE05D, 0x8D69}, //9451 #CJK UNIFIED IDEOGRAPH
    {0xE05E, 0x8D91}, //9452 #CJK UNIFIED IDEOGRAPH
    {0xE05F, 0x8D8C}, //9453 #CJK UNIFIED IDEOGRAPH
    {0xE060, 0x8D8E}, //9454 #CJK UNIFIED IDEOGRAPH
    {0xE061, 0x8D8F}, //9455 #CJK UNIFIED IDEOGRAPH
    {0xE062, 0x8D8D}, //9456 #CJK UNIFIED IDEOGRAPH
    {0xE063, 0x8D93}, //9457 #CJK UNIFIED IDEOGRAPH
    {0xE064, 0x8D94}, //9458 #CJK UNIFIED IDEOGRAPH
    {0xE065, 0x8D90}, //9459 #CJK UNIFIED IDEOGRAPH
    {0xE066, 0x8D92}, //9460 #CJK UNIFIED IDEOGRAPH
    {0xE067, 0x8DF0}, //9461 #CJK UNIFIED IDEOGRAPH
    {0xE068, 0x8DE0}, //9462 #CJK UNIFIED IDEOGRAPH
    {0xE069, 0x8DEC}, //9463 #CJK UNIFIED IDEOGRAPH
    {0xE06A, 0x8DF1}, //9464 #CJK UNIFIED IDEOGRAPH
    {0xE06B, 0x8DEE}, //9465 #CJK UNIFIED IDEOGRAPH
    {0xE06C, 0x8DD0}, //9466 #CJK UNIFIED IDEOGRAPH
    {0xE06D, 0x8DE9}, //9467 #CJK UNIFIED IDEOGRAPH
    {0xE06E, 0x8DE3}, //9468 #CJK UNIFIED IDEOGRAPH
    {0xE06F, 0x8DE2}, //9469 #CJK UNIFIED IDEOGRAPH
    {0xE070, 0x8DE7}, //9470 #CJK UNIFIED IDEOGRAPH
    {0xE071, 0x8DF2}, //9471 #CJK UNIFIED IDEOGRAPH
    {0xE072, 0x8DEB}, //9472 #CJK UNIFIED IDEOGRAPH
    {0xE073, 0x8DF4}, //9473 #CJK UNIFIED IDEOGRAPH
    {0xE074, 0x8F06}, //9474 #CJK UNIFIED IDEOGRAPH
    {0xE075, 0x8EFF}, //9475 #CJK UNIFIED IDEOGRAPH
    {0xE076, 0x8F01}, //9476 #CJK UNIFIED IDEOGRAPH
    {0xE077, 0x8F00}, //9477 #CJK UNIFIED IDEOGRAPH
    {0xE078, 0x8F05}, //9478 #CJK UNIFIED IDEOGRAPH
    {0xE079, 0x8F07}, //9479 #CJK UNIFIED IDEOGRAPH
    {0xE07A, 0x8F08}, //9480 #CJK UNIFIED IDEOGRAPH
    {0xE07B, 0x8F02}, //9481 #CJK UNIFIED IDEOGRAPH
    {0xE07C, 0x8F0B}, //9482 #CJK UNIFIED IDEOGRAPH
    {0xE07D, 0x9052}, //9483 #CJK UNIFIED IDEOGRAPH
    {0xE07E, 0x903F}, //9484 #CJK UNIFIED IDEOGRAPH
    {0xE0A1, 0x9044}, //9485 #CJK UNIFIED IDEOGRAPH
    {0xE0A2, 0x9049}, //9486 #CJK UNIFIED IDEOGRAPH
    {0xE0A3, 0x903D}, //9487 #CJK UNIFIED IDEOGRAPH
    {0xE0A4, 0x9110}, //9488 #CJK UNIFIED IDEOGRAPH
    {0xE0A5, 0x910D}, //9489 #CJK UNIFIED IDEOGRAPH
    {0xE0A6, 0x910F}, //9490 #CJK UNIFIED IDEOGRAPH
    {0xE0A7, 0x9111}, //9491 #CJK UNIFIED IDEOGRAPH
    {0xE0A8, 0x9116}, //9492 #CJK UNIFIED IDEOGRAPH
    {0xE0A9, 0x9114}, //9493 #CJK UNIFIED IDEOGRAPH
    {0xE0AA, 0x910B}, //9494 #CJK UNIFIED IDEOGRAPH
    {0xE0AB, 0x910E}, //9495 #CJK UNIFIED IDEOGRAPH
    {0xE0AC, 0x916E}, //9496 #CJK UNIFIED IDEOGRAPH
    {0xE0AD, 0x916F}, //9497 #CJK UNIFIED IDEOGRAPH
    {0xE0AE, 0x9248}, //9498 #CJK UNIFIED IDEOGRAPH
    {0xE0AF, 0x9252}, //9499 #CJK UNIFIED IDEOGRAPH
    {0xE0B0, 0x9230}, //9500 #CJK UNIFIED IDEOGRAPH
    {0xE0B1, 0x923A}, //9501 #CJK UNIFIED IDEOGRAPH
    {0xE0B2, 0x9266}, //9502 #CJK UNIFIED IDEOGRAPH
    {0xE0B3, 0x9233}, //9503 #CJK UNIFIED IDEOGRAPH
    {0xE0B4, 0x9265}, //9504 #CJK UNIFIED IDEOGRAPH
    {0xE0B5, 0x925E}, //9505 #CJK UNIFIED IDEOGRAPH
    {0xE0B6, 0x9283}, //9506 #CJK UNIFIED IDEOGRAPH
    {0xE0B7, 0x922E}, //9507 #CJK UNIFIED IDEOGRAPH
    {0xE0B8, 0x924A}, //9508 #CJK UNIFIED IDEOGRAPH
    {0xE0B9, 0x9246}, //9509 #CJK UNIFIED IDEOGRAPH
    {0xE0BA, 0x926D}, //9510 #CJK UNIFIED IDEOGRAPH
    {0xE0BB, 0x926C}, //9511 #CJK UNIFIED IDEOGRAPH
    {0xE0BC, 0x924F}, //9512 #CJK UNIFIED IDEOGRAPH
    {0xE0BD, 0x9260}, //9513 #CJK UNIFIED IDEOGRAPH
    {0xE0BE, 0x9267}, //9514 #CJK UNIFIED IDEOGRAPH
    {0xE0BF, 0x926F}, //9515 #CJK UNIFIED IDEOGRAPH
    {0xE0C0, 0x9236}, //9516 #CJK UNIFIED IDEOGRAPH
    {0xE0C1, 0x9261}, //9517 #CJK UNIFIED IDEOGRAPH
    {0xE0C2, 0x9270}, //9518 #CJK UNIFIED IDEOGRAPH
    {0xE0C3, 0x9231}, //9519 #CJK UNIFIED IDEOGRAPH
    {0xE0C4, 0x9254}, //9520 #CJK UNIFIED IDEOGRAPH
    {0xE0C5, 0x9263}, //9521 #CJK UNIFIED IDEOGRAPH
    {0xE0C6, 0x9250}, //9522 #CJK UNIFIED IDEOGRAPH
    {0xE0C7, 0x9272}, //9523 #CJK UNIFIED IDEOGRAPH
    {0xE0C8, 0x924E}, //9524 #CJK UNIFIED IDEOGRAPH
    {0xE0C9, 0x9253}, //9525 #CJK UNIFIED IDEOGRAPH
    {0xE0CA, 0x924C}, //9526 #CJK UNIFIED IDEOGRAPH
    {0xE0CB, 0x9256}, //9527 #CJK UNIFIED IDEOGRAPH
    {0xE0CC, 0x9232}, //9528 #CJK UNIFIED IDEOGRAPH
    {0xE0CD, 0x959F}, //9529 #CJK UNIFIED IDEOGRAPH
    {0xE0CE, 0x959C}, //9530 #CJK UNIFIED IDEOGRAPH
    {0xE0CF, 0x959E}, //9531 #CJK UNIFIED IDEOGRAPH
    {0xE0D0, 0x959B}, //9532 #CJK UNIFIED IDEOGRAPH
    {0xE0D1, 0x9692}, //9533 #CJK UNIFIED IDEOGRAPH
    {0xE0D2, 0x9693}, //9534 #CJK UNIFIED IDEOGRAPH
    {0xE0D3, 0x9691}, //9535 #CJK UNIFIED IDEOGRAPH
    {0xE0D4, 0x9697}, //9536 #CJK UNIFIED IDEOGRAPH
    {0xE0D5, 0x96CE}, //9537 #CJK UNIFIED IDEOGRAPH
    {0xE0D6, 0x96FA}, //9538 #CJK UNIFIED IDEOGRAPH
    {0xE0D7, 0x96FD}, //9539 #CJK UNIFIED IDEOGRAPH
    {0xE0D8, 0x96F8}, //9540 #CJK UNIFIED IDEOGRAPH
    {0xE0D9, 0x96F5}, //9541 #CJK UNIFIED IDEOGRAPH
    {0xE0DA, 0x9773}, //9542 #CJK UNIFIED IDEOGRAPH
    {0xE0DB, 0x9777}, //9543 #CJK UNIFIED IDEOGRAPH
    {0xE0DC, 0x9778}, //9544 #CJK UNIFIED IDEOGRAPH
    {0xE0DD, 0x9772}, //9545 #CJK UNIFIED IDEOGRAPH
    {0xE0DE, 0x980F}, //9546 #CJK UNIFIED IDEOGRAPH
    {0xE0DF, 0x980D}, //9547 #CJK UNIFIED IDEOGRAPH
    {0xE0E0, 0x980E}, //9548 #CJK UNIFIED IDEOGRAPH
    {0xE0E1, 0x98AC}, //9549 #CJK UNIFIED IDEOGRAPH
    {0xE0E2, 0x98F6}, //9550 #CJK UNIFIED IDEOGRAPH
    {0xE0E3, 0x98F9}, //9551 #CJK UNIFIED IDEOGRAPH
    {0xE0E4, 0x99AF}, //9552 #CJK UNIFIED IDEOGRAPH
    {0xE0E5, 0x99B2}, //9553 #CJK UNIFIED IDEOGRAPH
    {0xE0E6, 0x99B0}, //9554 #CJK UNIFIED IDEOGRAPH
    {0xE0E7, 0x99B5}, //9555 #CJK UNIFIED IDEOGRAPH
    {0xE0E8, 0x9AAD}, //9556 #CJK UNIFIED IDEOGRAPH
    {0xE0E9, 0x9AAB}, //9557 #CJK UNIFIED IDEOGRAPH
    {0xE0EA, 0x9B5B}, //9558 #CJK UNIFIED IDEOGRAPH
    {0xE0EB, 0x9CEA}, //9559 #CJK UNIFIED IDEOGRAPH
    {0xE0EC, 0x9CED}, //9560 #CJK UNIFIED IDEOGRAPH
    {0xE0ED, 0x9CE7}, //9561 #CJK UNIFIED IDEOGRAPH
    {0xE0EE, 0x9E80}, //9562 #CJK UNIFIED IDEOGRAPH
    {0xE0EF, 0x9EFD}, //9563 #CJK UNIFIED IDEOGRAPH
    {0xE0F0, 0x50E6}, //9564 #CJK UNIFIED IDEOGRAPH
    {0xE0F1, 0x50D4}, //9565 #CJK UNIFIED IDEOGRAPH
    {0xE0F2, 0x50D7}, //9566 #CJK UNIFIED IDEOGRAPH
    {0xE0F3, 0x50E8}, //9567 #CJK UNIFIED IDEOGRAPH
    {0xE0F4, 0x50F3}, //9568 #CJK UNIFIED IDEOGRAPH
    {0xE0F5, 0x50DB}, //9569 #CJK UNIFIED IDEOGRAPH
    {0xE0F6, 0x50EA}, //9570 #CJK UNIFIED IDEOGRAPH
    {0xE0F7, 0x50DD}, //9571 #CJK UNIFIED IDEOGRAPH
    {0xE0F8, 0x50E4}, //9572 #CJK UNIFIED IDEOGRAPH
    {0xE0F9, 0x50D3}, //9573 #CJK UNIFIED IDEOGRAPH
    {0xE0FA, 0x50EC}, //9574 #CJK UNIFIED IDEOGRAPH
    {0xE0FB, 0x50F0}, //9575 #CJK UNIFIED IDEOGRAPH
    {0xE0FC, 0x50EF}, //9576 #CJK UNIFIED IDEOGRAPH
    {0xE0FD, 0x50E3}, //9577 #CJK UNIFIED IDEOGRAPH
    {0xE0FE, 0x50E0}, //9578 #CJK UNIFIED IDEOGRAPH
    {0xE140, 0x51D8}, //9579 #CJK UNIFIED IDEOGRAPH
    {0xE141, 0x5280}, //9580 #CJK UNIFIED IDEOGRAPH
    {0xE142, 0x5281}, //9581 #CJK UNIFIED IDEOGRAPH
    {0xE143, 0x52E9}, //9582 #CJK UNIFIED IDEOGRAPH
    {0xE144, 0x52EB}, //9583 #CJK UNIFIED IDEOGRAPH
    {0xE145, 0x5330}, //9584 #CJK UNIFIED IDEOGRAPH
    {0xE146, 0x53AC}, //9585 #CJK UNIFIED IDEOGRAPH
    {0xE147, 0x5627}, //9586 #CJK UNIFIED IDEOGRAPH
    {0xE148, 0x5615}, //9587 #CJK UNIFIED IDEOGRAPH
    {0xE149, 0x560C}, //9588 #CJK UNIFIED IDEOGRAPH
    {0xE14A, 0x5612}, //9589 #CJK UNIFIED IDEOGRAPH
    {0xE14B, 0x55FC}, //9590 #CJK UNIFIED IDEOGRAPH
    {0xE14C, 0x560F}, //9591 #CJK UNIFIED IDEOGRAPH
    {0xE14D, 0x561C}, //9592 #CJK UNIFIED IDEOGRAPH
    {0xE14E, 0x5601}, //9593 #CJK UNIFIED IDEOGRAPH
    {0xE14F, 0x5613}, //9594 #CJK UNIFIED IDEOGRAPH
    {0xE150, 0x5602}, //9595 #CJK UNIFIED IDEOGRAPH
    {0xE151, 0x55FA}, //9596 #CJK UNIFIED IDEOGRAPH
    {0xE152, 0x561D}, //9597 #CJK UNIFIED IDEOGRAPH
    {0xE153, 0x5604}, //9598 #CJK UNIFIED IDEOGRAPH
    {0xE154, 0x55FF}, //9599 #CJK UNIFIED IDEOGRAPH
    {0xE155, 0x55F9}, //9600 #CJK UNIFIED IDEOGRAPH
    {0xE156, 0x5889}, //9601 #CJK UNIFIED IDEOGRAPH
    {0xE157, 0x587C}, //9602 #CJK UNIFIED IDEOGRAPH
    {0xE158, 0x5890}, //9603 #CJK UNIFIED IDEOGRAPH
    {0xE159, 0x5898}, //9604 #CJK UNIFIED IDEOGRAPH
    {0xE15A, 0x5886}, //9605 #CJK UNIFIED IDEOGRAPH
    {0xE15B, 0x5881}, //9606 #CJK UNIFIED IDEOGRAPH
    {0xE15C, 0x587F}, //9607 #CJK UNIFIED IDEOGRAPH
    {0xE15D, 0x5874}, //9608 #CJK UNIFIED IDEOGRAPH
    {0xE15E, 0x588B}, //9609 #CJK UNIFIED IDEOGRAPH
    {0xE15F, 0x587A}, //9610 #CJK UNIFIED IDEOGRAPH
    {0xE160, 0x5887}, //9611 #CJK UNIFIED IDEOGRAPH
    {0xE161, 0x5891}, //9612 #CJK UNIFIED IDEOGRAPH
    {0xE162, 0x588E}, //9613 #CJK UNIFIED IDEOGRAPH
    {0xE163, 0x5876}, //9614 #CJK UNIFIED IDEOGRAPH
    {0xE164, 0x5882}, //9615 #CJK UNIFIED IDEOGRAPH
    {0xE165, 0x5888}, //9616 #CJK UNIFIED IDEOGRAPH
    {0xE166, 0x587B}, //9617 #CJK UNIFIED IDEOGRAPH
    {0xE167, 0x5894}, //9618 #CJK UNIFIED IDEOGRAPH
    {0xE168, 0x588F}, //9619 #CJK UNIFIED IDEOGRAPH
    {0xE169, 0x58FE}, //9620 #CJK UNIFIED IDEOGRAPH
    {0xE16A, 0x596B}, //9621 #CJK UNIFIED IDEOGRAPH
    {0xE16B, 0x5ADC}, //9622 #CJK UNIFIED IDEOGRAPH
    {0xE16C, 0x5AEE}, //9623 #CJK UNIFIED IDEOGRAPH
    {0xE16D, 0x5AE5}, //9624 #CJK UNIFIED IDEOGRAPH
    {0xE16E, 0x5AD5}, //9625 #CJK UNIFIED IDEOGRAPH
    {0xE16F, 0x5AEA}, //9626 #CJK UNIFIED IDEOGRAPH
    {0xE170, 0x5ADA}, //9627 #CJK UNIFIED IDEOGRAPH
    {0xE171, 0x5AED}, //9628 #CJK UNIFIED IDEOGRAPH
    {0xE172, 0x5AEB}, //9629 #CJK UNIFIED IDEOGRAPH
    {0xE173, 0x5AF3}, //9630 #CJK UNIFIED IDEOGRAPH
    {0xE174, 0x5AE2}, //9631 #CJK UNIFIED IDEOGRAPH
    {0xE175, 0x5AE0}, //9632 #CJK UNIFIED IDEOGRAPH
    {0xE176, 0x5ADB}, //9633 #CJK UNIFIED IDEOGRAPH
    {0xE177, 0x5AEC}, //9634 #CJK UNIFIED IDEOGRAPH
    {0xE178, 0x5ADE}, //9635 #CJK UNIFIED IDEOGRAPH
    {0xE179, 0x5ADD}, //9636 #CJK UNIFIED IDEOGRAPH
    {0xE17A, 0x5AD9}, //9637 #CJK UNIFIED IDEOGRAPH
    {0xE17B, 0x5AE8}, //9638 #CJK UNIFIED IDEOGRAPH
    {0xE17C, 0x5ADF}, //9639 #CJK UNIFIED IDEOGRAPH
    {0xE17D, 0x5B77}, //9640 #CJK UNIFIED IDEOGRAPH
    {0xE17E, 0x5BE0}, //9641 #CJK UNIFIED IDEOGRAPH
    {0xE1A1, 0x5BE3}, //9642 #CJK UNIFIED IDEOGRAPH
    {0xE1A2, 0x5C63}, //9643 #CJK UNIFIED IDEOGRAPH
    {0xE1A3, 0x5D82}, //9644 #CJK UNIFIED IDEOGRAPH
    {0xE1A4, 0x5D80}, //9645 #CJK UNIFIED IDEOGRAPH
    {0xE1A5, 0x5D7D}, //9646 #CJK UNIFIED IDEOGRAPH
    {0xE1A6, 0x5D86}, //9647 #CJK UNIFIED IDEOGRAPH
    {0xE1A7, 0x5D7A}, //9648 #CJK UNIFIED IDEOGRAPH
    {0xE1A8, 0x5D81}, //9649 #CJK UNIFIED IDEOGRAPH
    {0xE1A9, 0x5D77}, //9650 #CJK UNIFIED IDEOGRAPH
    {0xE1AA, 0x5D8A}, //9651 #CJK UNIFIED IDEOGRAPH
    {0xE1AB, 0x5D89}, //9652 #CJK UNIFIED IDEOGRAPH
    {0xE1AC, 0x5D88}, //9653 #CJK UNIFIED IDEOGRAPH
    {0xE1AD, 0x5D7E}, //9654 #CJK UNIFIED IDEOGRAPH
    {0xE1AE, 0x5D7C}, //9655 #CJK UNIFIED IDEOGRAPH
    {0xE1AF, 0x5D8D}, //9656 #CJK UNIFIED IDEOGRAPH
    {0xE1B0, 0x5D79}, //9657 #CJK UNIFIED IDEOGRAPH
    {0xE1B1, 0x5D7F}, //9658 #CJK UNIFIED IDEOGRAPH
    {0xE1B2, 0x5E58}, //9659 #CJK UNIFIED IDEOGRAPH
    {0xE1B3, 0x5E59}, //9660 #CJK UNIFIED IDEOGRAPH
    {0xE1B4, 0x5E53}, //9661 #CJK UNIFIED IDEOGRAPH
    {0xE1B5, 0x5ED8}, //9662 #CJK UNIFIED IDEOGRAPH
    {0xE1B6, 0x5ED1}, //9663 #CJK UNIFIED IDEOGRAPH
    {0xE1B7, 0x5ED7}, //9664 #CJK UNIFIED IDEOGRAPH
    {0xE1B8, 0x5ECE}, //9665 #CJK UNIFIED IDEOGRAPH
    {0xE1B9, 0x5EDC}, //9666 #CJK UNIFIED IDEOGRAPH
    {0xE1BA, 0x5ED5}, //9667 #CJK UNIFIED IDEOGRAPH
    {0xE1BB, 0x5ED9}, //9668 #CJK UNIFIED IDEOGRAPH
    {0xE1BC, 0x5ED2}, //9669 #CJK UNIFIED IDEOGRAPH
    {0xE1BD, 0x5ED4}, //9670 #CJK UNIFIED IDEOGRAPH
    {0xE1BE, 0x5F44}, //9671 #CJK UNIFIED IDEOGRAPH
    {0xE1BF, 0x5F43}, //9672 #CJK UNIFIED IDEOGRAPH
    {0xE1C0, 0x5F6F}, //9673 #CJK UNIFIED IDEOGRAPH
    {0xE1C1, 0x5FB6}, //9674 #CJK UNIFIED IDEOGRAPH
    {0xE1C2, 0x612C}, //9675 #CJK UNIFIED IDEOGRAPH
    {0xE1C3, 0x6128}, //9676 #CJK UNIFIED IDEOGRAPH
    {0xE1C4, 0x6141}, //9677 #CJK UNIFIED IDEOGRAPH
    {0xE1C5, 0x615E}, //9678 #CJK UNIFIED IDEOGRAPH
    {0xE1C6, 0x6171}, //9679 #CJK UNIFIED IDEOGRAPH
    {0xE1C7, 0x6173}, //9680 #CJK UNIFIED IDEOGRAPH
    {0xE1C8, 0x6152}, //9681 #CJK UNIFIED IDEOGRAPH
    {0xE1C9, 0x6153}, //9682 #CJK UNIFIED IDEOGRAPH
    {0xE1CA, 0x6172}, //9683 #CJK UNIFIED IDEOGRAPH
    {0xE1CB, 0x616C}, //9684 #CJK UNIFIED IDEOGRAPH
    {0xE1CC, 0x6180}, //9685 #CJK UNIFIED IDEOGRAPH
    {0xE1CD, 0x6174}, //9686 #CJK UNIFIED IDEOGRAPH
    {0xE1CE, 0x6154}, //9687 #CJK UNIFIED IDEOGRAPH
    {0xE1CF, 0x617A}, //9688 #CJK UNIFIED IDEOGRAPH
    {0xE1D0, 0x615B}, //9689 #CJK UNIFIED IDEOGRAPH
    {0xE1D1, 0x6165}, //9690 #CJK UNIFIED IDEOGRAPH
    {0xE1D2, 0x613B}, //9691 #CJK UNIFIED IDEOGRAPH
    {0xE1D3, 0x616A}, //9692 #CJK UNIFIED IDEOGRAPH
    {0xE1D4, 0x6161}, //9693 #CJK UNIFIED IDEOGRAPH
    {0xE1D5, 0x6156}, //9694 #CJK UNIFIED IDEOGRAPH
    {0xE1D6, 0x6229}, //9695 #CJK UNIFIED IDEOGRAPH
    {0xE1D7, 0x6227}, //9696 #CJK UNIFIED IDEOGRAPH
    {0xE1D8, 0x622B}, //9697 #CJK UNIFIED IDEOGRAPH
    {0xE1D9, 0x642B}, //9698 #CJK UNIFIED IDEOGRAPH
    {0xE1DA, 0x644D}, //9699 #CJK UNIFIED IDEOGRAPH
    {0xE1DB, 0x645B}, //9700 #CJK UNIFIED IDEOGRAPH
    {0xE1DC, 0x645D}, //9701 #CJK UNIFIED IDEOGRAPH
    {0xE1DD, 0x6474}, //9702 #CJK UNIFIED IDEOGRAPH
    {0xE1DE, 0x6476}, //9703 #CJK UNIFIED IDEOGRAPH
    {0xE1DF, 0x6472}, //9704 #CJK UNIFIED IDEOGRAPH
    {0xE1E0, 0x6473}, //9705 #CJK UNIFIED IDEOGRAPH
    {0xE1E1, 0x647D}, //9706 #CJK UNIFIED IDEOGRAPH
    {0xE1E2, 0x6475}, //9707 #CJK UNIFIED IDEOGRAPH
    {0xE1E3, 0x6466}, //9708 #CJK UNIFIED IDEOGRAPH
    {0xE1E4, 0x64A6}, //9709 #CJK UNIFIED IDEOGRAPH
    {0xE1E5, 0x644E}, //9710 #CJK UNIFIED IDEOGRAPH
    {0xE1E6, 0x6482}, //9711 #CJK UNIFIED IDEOGRAPH
    {0xE1E7, 0x645E}, //9712 #CJK UNIFIED IDEOGRAPH
    {0xE1E8, 0x645C}, //9713 #CJK UNIFIED IDEOGRAPH
    {0xE1E9, 0x644B}, //9714 #CJK UNIFIED IDEOGRAPH
    {0xE1EA, 0x6453}, //9715 #CJK UNIFIED IDEOGRAPH
    {0xE1EB, 0x6460}, //9716 #CJK UNIFIED IDEOGRAPH
    {0xE1EC, 0x6450}, //9717 #CJK UNIFIED IDEOGRAPH
    {0xE1ED, 0x647F}, //9718 #CJK UNIFIED IDEOGRAPH
    {0xE1EE, 0x643F}, //9719 #CJK UNIFIED IDEOGRAPH
    {0xE1EF, 0x646C}, //9720 #CJK UNIFIED IDEOGRAPH
    {0xE1F0, 0x646B}, //9721 #CJK UNIFIED IDEOGRAPH
    {0xE1F1, 0x6459}, //9722 #CJK UNIFIED IDEOGRAPH
    {0xE1F2, 0x6465}, //9723 #CJK UNIFIED IDEOGRAPH
    {0xE1F3, 0x6477}, //9724 #CJK UNIFIED IDEOGRAPH
    {0xE1F4, 0x6573}, //9725 #CJK UNIFIED IDEOGRAPH
    {0xE1F5, 0x65A0}, //9726 #CJK UNIFIED IDEOGRAPH
    {0xE1F6, 0x66A1}, //9727 #CJK UNIFIED IDEOGRAPH
    {0xE1F7, 0x66A0}, //9728 #CJK UNIFIED IDEOGRAPH
    {0xE1F8, 0x669F}, //9729 #CJK UNIFIED IDEOGRAPH
    {0xE1F9, 0x6705}, //9730 #CJK UNIFIED IDEOGRAPH
    {0xE1FA, 0x6704}, //9731 #CJK UNIFIED IDEOGRAPH
    {0xE1FB, 0x6722}, //9732 #CJK UNIFIED IDEOGRAPH
    {0xE1FC, 0x69B1}, //9733 #CJK UNIFIED IDEOGRAPH
    {0xE1FD, 0x69B6}, //9734 #CJK UNIFIED IDEOGRAPH
    {0xE1FE, 0x69C9}, //9735 #CJK UNIFIED IDEOGRAPH
    {0xE240, 0x69A0}, //9736 #CJK UNIFIED IDEOGRAPH
    {0xE241, 0x69CE}, //9737 #CJK UNIFIED IDEOGRAPH
    {0xE242, 0x6996}, //9738 #CJK UNIFIED IDEOGRAPH
    {0xE243, 0x69B0}, //9739 #CJK UNIFIED IDEOGRAPH
    {0xE244, 0x69AC}, //9740 #CJK UNIFIED IDEOGRAPH
    {0xE245, 0x69BC}, //9741 #CJK UNIFIED IDEOGRAPH
    {0xE246, 0x6991}, //9742 #CJK UNIFIED IDEOGRAPH
    {0xE247, 0x6999}, //9743 #CJK UNIFIED IDEOGRAPH
    {0xE248, 0x698E}, //9744 #CJK UNIFIED IDEOGRAPH
    {0xE249, 0x69A7}, //9745 #CJK UNIFIED IDEOGRAPH
    {0xE24A, 0x698D}, //9746 #CJK UNIFIED IDEOGRAPH
    {0xE24B, 0x69A9}, //9747 #CJK UNIFIED IDEOGRAPH
    {0xE24C, 0x69BE}, //9748 #CJK UNIFIED IDEOGRAPH
    {0xE24D, 0x69AF}, //9749 #CJK UNIFIED IDEOGRAPH
    {0xE24E, 0x69BF}, //9750 #CJK UNIFIED IDEOGRAPH
    {0xE24F, 0x69C4}, //9751 #CJK UNIFIED IDEOGRAPH
    {0xE250, 0x69BD}, //9752 #CJK UNIFIED IDEOGRAPH
    {0xE251, 0x69A4}, //9753 #CJK UNIFIED IDEOGRAPH
    {0xE252, 0x69D4}, //9754 #CJK UNIFIED IDEOGRAPH
    {0xE253, 0x69B9}, //9755 #CJK UNIFIED IDEOGRAPH
    {0xE254, 0x69CA}, //9756 #CJK UNIFIED IDEOGRAPH
    {0xE255, 0x699A}, //9757 #CJK UNIFIED IDEOGRAPH
    {0xE256, 0x69CF}, //9758 #CJK UNIFIED IDEOGRAPH
    {0xE257, 0x69B3}, //9759 #CJK UNIFIED IDEOGRAPH
    {0xE258, 0x6993}, //9760 #CJK UNIFIED IDEOGRAPH
    {0xE259, 0x69AA}, //9761 #CJK UNIFIED IDEOGRAPH
    {0xE25A, 0x69A1}, //9762 #CJK UNIFIED IDEOGRAPH
    {0xE25B, 0x699E}, //9763 #CJK UNIFIED IDEOGRAPH
    {0xE25C, 0x69D9}, //9764 #CJK UNIFIED IDEOGRAPH
    {0xE25D, 0x6997}, //9765 #CJK UNIFIED IDEOGRAPH
    {0xE25E, 0x6990}, //9766 #CJK UNIFIED IDEOGRAPH
    {0xE25F, 0x69C2}, //9767 #CJK UNIFIED IDEOGRAPH
    {0xE260, 0x69B5}, //9768 #CJK UNIFIED IDEOGRAPH
    {0xE261, 0x69A5}, //9769 #CJK UNIFIED IDEOGRAPH
    {0xE262, 0x69C6}, //9770 #CJK UNIFIED IDEOGRAPH
    {0xE263, 0x6B4A}, //9771 #CJK UNIFIED IDEOGRAPH
    {0xE264, 0x6B4D}, //9772 #CJK UNIFIED IDEOGRAPH
    {0xE265, 0x6B4B}, //9773 #CJK UNIFIED IDEOGRAPH
    {0xE266, 0x6B9E}, //9774 #CJK UNIFIED IDEOGRAPH
    {0xE267, 0x6B9F}, //9775 #CJK UNIFIED IDEOGRAPH
    {0xE268, 0x6BA0}, //9776 #CJK UNIFIED IDEOGRAPH
    {0xE269, 0x6BC3}, //9777 #CJK UNIFIED IDEOGRAPH
    {0xE26A, 0x6BC4}, //9778 #CJK UNIFIED IDEOGRAPH
    {0xE26B, 0x6BFE}, //9779 #CJK UNIFIED IDEOGRAPH
    {0xE26C, 0x6ECE}, //9780 #CJK UNIFIED IDEOGRAPH
    {0xE26D, 0x6EF5}, //9781 #CJK UNIFIED IDEOGRAPH
    {0xE26E, 0x6EF1}, //9782 #CJK UNIFIED IDEOGRAPH
    {0xE26F, 0x6F03}, //9783 #CJK UNIFIED IDEOGRAPH
    {0xE270, 0x6F25}, //9784 #CJK UNIFIED IDEOGRAPH
    {0xE271, 0x6EF8}, //9785 #CJK UNIFIED IDEOGRAPH
    {0xE272, 0x6F37}, //9786 #CJK UNIFIED IDEOGRAPH
    {0xE273, 0x6EFB}, //9787 #CJK UNIFIED IDEOGRAPH
    {0xE274, 0x6F2E}, //9788 #CJK UNIFIED IDEOGRAPH
    {0xE275, 0x6F09}, //9789 #CJK UNIFIED IDEOGRAPH
    {0xE276, 0x6F4E}, //9790 #CJK UNIFIED IDEOGRAPH
    {0xE277, 0x6F19}, //9791 #CJK UNIFIED IDEOGRAPH
    {0xE278, 0x6F1A}, //9792 #CJK UNIFIED IDEOGRAPH
    {0xE279, 0x6F27}, //9793 #CJK UNIFIED IDEOGRAPH
    {0xE27A, 0x6F18}, //9794 #CJK UNIFIED IDEOGRAPH
    {0xE27B, 0x6F3B}, //9795 #CJK UNIFIED IDEOGRAPH
    {0xE27C, 0x6F12}, //9796 #CJK UNIFIED IDEOGRAPH
    {0xE27D, 0x6EED}, //9797 #CJK UNIFIED IDEOGRAPH
    {0xE27E, 0x6F0A}, //9798 #CJK UNIFIED IDEOGRAPH
    {0xE2A1, 0x6F36}, //9799 #CJK UNIFIED IDEOGRAPH
    {0xE2A2, 0x6F73}, //9800 #CJK UNIFIED IDEOGRAPH
    {0xE2A3, 0x6EF9}, //9801 #CJK UNIFIED IDEOGRAPH
    {0xE2A4, 0x6EEE}, //9802 #CJK UNIFIED IDEOGRAPH
    {0xE2A5, 0x6F2D}, //9803 #CJK UNIFIED IDEOGRAPH
    {0xE2A6, 0x6F40}, //9804 #CJK UNIFIED IDEOGRAPH
    {0xE2A7, 0x6F30}, //9805 #CJK UNIFIED IDEOGRAPH
    {0xE2A8, 0x6F3C}, //9806 #CJK UNIFIED IDEOGRAPH
    {0xE2A9, 0x6F35}, //9807 #CJK UNIFIED IDEOGRAPH
    {0xE2AA, 0x6EEB}, //9808 #CJK UNIFIED IDEOGRAPH
    {0xE2AB, 0x6F07}, //9809 #CJK UNIFIED IDEOGRAPH
    {0xE2AC, 0x6F0E}, //9810 #CJK UNIFIED IDEOGRAPH
    {0xE2AD, 0x6F43}, //9811 #CJK UNIFIED IDEOGRAPH
    {0xE2AE, 0x6F05}, //9812 #CJK UNIFIED IDEOGRAPH
    {0xE2AF, 0x6EFD}, //9813 #CJK UNIFIED IDEOGRAPH
    {0xE2B0, 0x6EF6}, //9814 #CJK UNIFIED IDEOGRAPH
    {0xE2B1, 0x6F39}, //9815 #CJK UNIFIED IDEOGRAPH
    {0xE2B2, 0x6F1C}, //9816 #CJK UNIFIED IDEOGRAPH
    {0xE2B3, 0x6EFC}, //9817 #CJK UNIFIED IDEOGRAPH
    {0xE2B4, 0x6F3A}, //9818 #CJK UNIFIED IDEOGRAPH
    {0xE2B5, 0x6F1F}, //9819 #CJK UNIFIED IDEOGRAPH
    {0xE2B6, 0x6F0D}, //9820 #CJK UNIFIED IDEOGRAPH
    {0xE2B7, 0x6F1E}, //9821 #CJK UNIFIED IDEOGRAPH
    {0xE2B8, 0x6F08}, //9822 #CJK UNIFIED IDEOGRAPH
    {0xE2B9, 0x6F21}, //9823 #CJK UNIFIED IDEOGRAPH
    {0xE2BA, 0x7187}, //9824 #CJK UNIFIED IDEOGRAPH
    {0xE2BB, 0x7190}, //9825 #CJK UNIFIED IDEOGRAPH
    {0xE2BC, 0x7189}, //9826 #CJK UNIFIED IDEOGRAPH
    {0xE2BD, 0x7180}, //9827 #CJK UNIFIED IDEOGRAPH
    {0xE2BE, 0x7185}, //9828 #CJK UNIFIED IDEOGRAPH
    {0xE2BF, 0x7182}, //9829 #CJK UNIFIED IDEOGRAPH
    {0xE2C0, 0x718F}, //9830 #CJK UNIFIED IDEOGRAPH
    {0xE2C1, 0x717B}, //9831 #CJK UNIFIED IDEOGRAPH
    {0xE2C2, 0x7186}, //9832 #CJK UNIFIED IDEOGRAPH
    {0xE2C3, 0x7181}, //9833 #CJK UNIFIED IDEOGRAPH
    {0xE2C4, 0x7197}, //9834 #CJK UNIFIED IDEOGRAPH
    {0xE2C5, 0x7244}, //9835 #CJK UNIFIED IDEOGRAPH
    {0xE2C6, 0x7253}, //9836 #CJK UNIFIED IDEOGRAPH
    {0xE2C7, 0x7297}, //9837 #CJK UNIFIED IDEOGRAPH
    {0xE2C8, 0x7295}, //9838 #CJK UNIFIED IDEOGRAPH
    {0xE2C9, 0x7293}, //9839 #CJK UNIFIED IDEOGRAPH
    {0xE2CA, 0x7343}, //9840 #CJK UNIFIED IDEOGRAPH
    {0xE2CB, 0x734D}, //9841 #CJK UNIFIED IDEOGRAPH
    {0xE2CC, 0x7351}, //9842 #CJK UNIFIED IDEOGRAPH
    {0xE2CD, 0x734C}, //9843 #CJK UNIFIED IDEOGRAPH
    {0xE2CE, 0x7462}, //9844 #CJK UNIFIED IDEOGRAPH
    {0xE2CF, 0x7473}, //9845 #CJK UNIFIED IDEOGRAPH
    {0xE2D0, 0x7471}, //9846 #CJK UNIFIED IDEOGRAPH
    {0xE2D1, 0x7475}, //9847 #CJK UNIFIED IDEOGRAPH
    {0xE2D2, 0x7472}, //9848 #CJK UNIFIED IDEOGRAPH
    {0xE2D3, 0x7467}, //9849 #CJK UNIFIED IDEOGRAPH
    {0xE2D4, 0x746E}, //9850 #CJK UNIFIED IDEOGRAPH
    {0xE2D5, 0x7500}, //9851 #CJK UNIFIED IDEOGRAPH
    {0xE2D6, 0x7502}, //9852 #CJK UNIFIED IDEOGRAPH
    {0xE2D7, 0x7503}, //9853 #CJK UNIFIED IDEOGRAPH
    {0xE2D8, 0x757D}, //9854 #CJK UNIFIED IDEOGRAPH
    {0xE2D9, 0x7590}, //9855 #CJK UNIFIED IDEOGRAPH
    {0xE2DA, 0x7616}, //9856 #CJK UNIFIED IDEOGRAPH
    {0xE2DB, 0x7608}, //9857 #CJK UNIFIED IDEOGRAPH
    {0xE2DC, 0x760C}, //9858 #CJK UNIFIED IDEOGRAPH
    {0xE2DD, 0x7615}, //9859 #CJK UNIFIED IDEOGRAPH
    {0xE2DE, 0x7611}, //9860 #CJK UNIFIED IDEOGRAPH
    {0xE2DF, 0x760A}, //9861 #CJK UNIFIED IDEOGRAPH
    {0xE2E0, 0x7614}, //9862 #CJK UNIFIED IDEOGRAPH
    {0xE2E1, 0x76B8}, //9863 #CJK UNIFIED IDEOGRAPH
    {0xE2E2, 0x7781}, //9864 #CJK UNIFIED IDEOGRAPH
    {0xE2E3, 0x777C}, //9865 #CJK UNIFIED IDEOGRAPH
    {0xE2E4, 0x7785}, //9866 #CJK UNIFIED IDEOGRAPH
    {0xE2E5, 0x7782}, //9867 #CJK UNIFIED IDEOGRAPH
    {0xE2E6, 0x776E}, //9868 #CJK UNIFIED IDEOGRAPH
    {0xE2E7, 0x7780}, //9869 #CJK UNIFIED IDEOGRAPH
    {0xE2E8, 0x776F}, //9870 #CJK UNIFIED IDEOGRAPH
    {0xE2E9, 0x777E}, //9871 #CJK UNIFIED IDEOGRAPH
    {0xE2EA, 0x7783}, //9872 #CJK UNIFIED IDEOGRAPH
    {0xE2EB, 0x78B2}, //9873 #CJK UNIFIED IDEOGRAPH
    {0xE2EC, 0x78AA}, //9874 #CJK UNIFIED IDEOGRAPH
    {0xE2ED, 0x78B4}, //9875 #CJK UNIFIED IDEOGRAPH
    {0xE2EE, 0x78AD}, //9876 #CJK UNIFIED IDEOGRAPH
    {0xE2EF, 0x78A8}, //9877 #CJK UNIFIED IDEOGRAPH
    {0xE2F0, 0x787E}, //9878 #CJK UNIFIED IDEOGRAPH
    {0xE2F1, 0x78AB}, //9879 #CJK UNIFIED IDEOGRAPH
    {0xE2F2, 0x789E}, //9880 #CJK UNIFIED IDEOGRAPH
    {0xE2F3, 0x78A5}, //9881 #CJK UNIFIED IDEOGRAPH
    {0xE2F4, 0x78A0}, //9882 #CJK UNIFIED IDEOGRAPH
    {0xE2F5, 0x78AC}, //9883 #CJK UNIFIED IDEOGRAPH
    {0xE2F6, 0x78A2}, //9884 #CJK UNIFIED IDEOGRAPH
    {0xE2F7, 0x78A4}, //9885 #CJK UNIFIED IDEOGRAPH
    {0xE2F8, 0x7998}, //9886 #CJK UNIFIED IDEOGRAPH
    {0xE2F9, 0x798A}, //9887 #CJK UNIFIED IDEOGRAPH
    {0xE2FA, 0x798B}, //9888 #CJK UNIFIED IDEOGRAPH
    {0xE2FB, 0x7996}, //9889 #CJK UNIFIED IDEOGRAPH
    {0xE2FC, 0x7995}, //9890 #CJK UNIFIED IDEOGRAPH
    {0xE2FD, 0x7994}, //9891 #CJK UNIFIED IDEOGRAPH
    {0xE2FE, 0x7993}, //9892 #CJK UNIFIED IDEOGRAPH
    {0xE340, 0x7997}, //9893 #CJK UNIFIED IDEOGRAPH
    {0xE341, 0x7988}, //9894 #CJK UNIFIED IDEOGRAPH
    {0xE342, 0x7992}, //9895 #CJK UNIFIED IDEOGRAPH
    {0xE343, 0x7990}, //9896 #CJK UNIFIED IDEOGRAPH
    {0xE344, 0x7A2B}, //9897 #CJK UNIFIED IDEOGRAPH
    {0xE345, 0x7A4A}, //9898 #CJK UNIFIED IDEOGRAPH
    {0xE346, 0x7A30}, //9899 #CJK UNIFIED IDEOGRAPH
    {0xE347, 0x7A2F}, //9900 #CJK UNIFIED IDEOGRAPH
    {0xE348, 0x7A28}, //9901 #CJK UNIFIED IDEOGRAPH
    {0xE349, 0x7A26}, //9902 #CJK UNIFIED IDEOGRAPH
    {0xE34A, 0x7AA8}, //9903 #CJK UNIFIED IDEOGRAPH
    {0xE34B, 0x7AAB}, //9904 #CJK UNIFIED IDEOGRAPH
    {0xE34C, 0x7AAC}, //9905 #CJK UNIFIED IDEOGRAPH
    {0xE34D, 0x7AEE}, //9906 #CJK UNIFIED IDEOGRAPH
    {0xE34E, 0x7B88}, //9907 #CJK UNIFIED IDEOGRAPH
    {0xE34F, 0x7B9C}, //9908 #CJK UNIFIED IDEOGRAPH
    {0xE350, 0x7B8A}, //9909 #CJK UNIFIED IDEOGRAPH
    {0xE351, 0x7B91}, //9910 #CJK UNIFIED IDEOGRAPH
    {0xE352, 0x7B90}, //9911 #CJK UNIFIED IDEOGRAPH
    {0xE353, 0x7B96}, //9912 #CJK UNIFIED IDEOGRAPH
    {0xE354, 0x7B8D}, //9913 #CJK UNIFIED IDEOGRAPH
    {0xE355, 0x7B8C}, //9914 #CJK UNIFIED IDEOGRAPH
    {0xE356, 0x7B9B}, //9915 #CJK UNIFIED IDEOGRAPH
    {0xE357, 0x7B8E}, //9916 #CJK UNIFIED IDEOGRAPH
    {0xE358, 0x7B85}, //9917 #CJK UNIFIED IDEOGRAPH
    {0xE359, 0x7B98}, //9918 #CJK UNIFIED IDEOGRAPH
    {0xE35A, 0x5284}, //9919 #CJK UNIFIED IDEOGRAPH
    {0xE35B, 0x7B99}, //9920 #CJK UNIFIED IDEOGRAPH
    {0xE35C, 0x7BA4}, //9921 #CJK UNIFIED IDEOGRAPH
    {0xE35D, 0x7B82}, //9922 #CJK UNIFIED IDEOGRAPH
    {0xE35E, 0x7CBB}, //9923 #CJK UNIFIED IDEOGRAPH
    {0xE35F, 0x7CBF}, //9924 #CJK UNIFIED IDEOGRAPH
    {0xE360, 0x7CBC}, //9925 #CJK UNIFIED IDEOGRAPH
    {0xE361, 0x7CBA}, //9926 #CJK UNIFIED IDEOGRAPH
    {0xE362, 0x7DA7}, //9927 #CJK UNIFIED IDEOGRAPH
    {0xE363, 0x7DB7}, //9928 #CJK UNIFIED IDEOGRAPH
    {0xE364, 0x7DC2}, //9929 #CJK UNIFIED IDEOGRAPH
    {0xE365, 0x7DA3}, //9930 #CJK UNIFIED IDEOGRAPH
    {0xE366, 0x7DAA}, //9931 #CJK UNIFIED IDEOGRAPH
    {0xE367, 0x7DC1}, //9932 #CJK UNIFIED IDEOGRAPH
    {0xE368, 0x7DC0}, //9933 #CJK UNIFIED IDEOGRAPH
    {0xE369, 0x7DC5}, //9934 #CJK UNIFIED IDEOGRAPH
    {0xE36A, 0x7D9D}, //9935 #CJK UNIFIED IDEOGRAPH
    {0xE36B, 0x7DCE}, //9936 #CJK UNIFIED IDEOGRAPH
    {0xE36C, 0x7DC4}, //9937 #CJK UNIFIED IDEOGRAPH
    {0xE36D, 0x7DC6}, //9938 #CJK UNIFIED IDEOGRAPH
    {0xE36E, 0x7DCB}, //9939 #CJK UNIFIED IDEOGRAPH
    {0xE36F, 0x7DCC}, //9940 #CJK UNIFIED IDEOGRAPH
    {0xE370, 0x7DAF}, //9941 #CJK UNIFIED IDEOGRAPH
    {0xE371, 0x7DB9}, //9942 #CJK UNIFIED IDEOGRAPH
    {0xE372, 0x7D96}, //9943 #CJK UNIFIED IDEOGRAPH
    {0xE373, 0x7DBC}, //9944 #CJK UNIFIED IDEOGRAPH
    {0xE374, 0x7D9F}, //9945 #CJK UNIFIED IDEOGRAPH
    {0xE375, 0x7DA6}, //9946 #CJK UNIFIED IDEOGRAPH
    {0xE376, 0x7DAE}, //9947 #CJK UNIFIED IDEOGRAPH
    {0xE377, 0x7DA9}, //9948 #CJK UNIFIED IDEOGRAPH
    {0xE378, 0x7DA1}, //9949 #CJK UNIFIED IDEOGRAPH
    {0xE379, 0x7DC9}, //9950 #CJK UNIFIED IDEOGRAPH
    {0xE37A, 0x7F73}, //9951 #CJK UNIFIED IDEOGRAPH
    {0xE37B, 0x7FE2}, //9952 #CJK UNIFIED IDEOGRAPH
    {0xE37C, 0x7FE3}, //9953 #CJK UNIFIED IDEOGRAPH
    {0xE37D, 0x7FE5}, //9954 #CJK UNIFIED IDEOGRAPH
    {0xE37E, 0x7FDE}, //9955 #CJK UNIFIED IDEOGRAPH
    {0xE3A1, 0x8024}, //9956 #CJK UNIFIED IDEOGRAPH
    {0xE3A2, 0x805D}, //9957 #CJK UNIFIED IDEOGRAPH
    {0xE3A3, 0x805C}, //9958 #CJK UNIFIED IDEOGRAPH
    {0xE3A4, 0x8189}, //9959 #CJK UNIFIED IDEOGRAPH
    {0xE3A5, 0x8186}, //9960 #CJK UNIFIED IDEOGRAPH
    {0xE3A6, 0x8183}, //9961 #CJK UNIFIED IDEOGRAPH
    {0xE3A7, 0x8187}, //9962 #CJK UNIFIED IDEOGRAPH
    {0xE3A8, 0x818D}, //9963 #CJK UNIFIED IDEOGRAPH
    {0xE3A9, 0x818C}, //9964 #CJK UNIFIED IDEOGRAPH
    {0xE3AA, 0x818B}, //9965 #CJK UNIFIED IDEOGRAPH
    {0xE3AB, 0x8215}, //9966 #CJK UNIFIED IDEOGRAPH
    {0xE3AC, 0x8497}, //9967 #CJK UNIFIED IDEOGRAPH
    {0xE3AD, 0x84A4}, //9968 #CJK UNIFIED IDEOGRAPH
    {0xE3AE, 0x84A1}, //9969 #CJK UNIFIED IDEOGRAPH
    {0xE3AF, 0x849F}, //9970 #CJK UNIFIED IDEOGRAPH
    {0xE3B0, 0x84BA}, //9971 #CJK UNIFIED IDEOGRAPH
    {0xE3B1, 0x84CE}, //9972 #CJK UNIFIED IDEOGRAPH
    {0xE3B2, 0x84C2}, //9973 #CJK UNIFIED IDEOGRAPH
    {0xE3B3, 0x84AC}, //9974 #CJK UNIFIED IDEOGRAPH
    {0xE3B4, 0x84AE}, //9975 #CJK UNIFIED IDEOGRAPH
    {0xE3B5, 0x84AB}, //9976 #CJK UNIFIED IDEOGRAPH
    {0xE3B6, 0x84B9}, //9977 #CJK UNIFIED IDEOGRAPH
    {0xE3B7, 0x84B4}, //9978 #CJK UNIFIED IDEOGRAPH
    {0xE3B8, 0x84C1}, //9979 #CJK UNIFIED IDEOGRAPH
    {0xE3B9, 0x84CD}, //9980 #CJK UNIFIED IDEOGRAPH
    {0xE3BA, 0x84AA}, //9981 #CJK UNIFIED IDEOGRAPH
    {0xE3BB, 0x849A}, //9982 #CJK UNIFIED IDEOGRAPH
    {0xE3BC, 0x84B1}, //9983 #CJK UNIFIED IDEOGRAPH
    {0xE3BD, 0x84D0}, //9984 #CJK UNIFIED IDEOGRAPH
    {0xE3BE, 0x849D}, //9985 #CJK UNIFIED IDEOGRAPH
    {0xE3BF, 0x84A7}, //9986 #CJK UNIFIED IDEOGRAPH
    {0xE3C0, 0x84BB}, //9987 #CJK UNIFIED IDEOGRAPH
    {0xE3C1, 0x84A2}, //9988 #CJK UNIFIED IDEOGRAPH
    {0xE3C2, 0x8494}, //9989 #CJK UNIFIED IDEOGRAPH
    {0xE3C3, 0x84C7}, //9990 #CJK UNIFIED IDEOGRAPH
    {0xE3C4, 0x84CC}, //9991 #CJK UNIFIED IDEOGRAPH
    {0xE3C5, 0x849B}, //9992 #CJK UNIFIED IDEOGRAPH
    {0xE3C6, 0x84A9}, //9993 #CJK UNIFIED IDEOGRAPH
    {0xE3C7, 0x84AF}, //9994 #CJK UNIFIED IDEOGRAPH
    {0xE3C8, 0x84A8}, //9995 #CJK UNIFIED IDEOGRAPH
    {0xE3C9, 0x84D6}, //9996 #CJK UNIFIED IDEOGRAPH
    {0xE3CA, 0x8498}, //9997 #CJK UNIFIED IDEOGRAPH
    {0xE3CB, 0x84B6}, //9998 #CJK UNIFIED IDEOGRAPH
    {0xE3CC, 0x84CF}, //9999 #CJK UNIFIED IDEOGRAPH
    {0xE3CD, 0x84A0}, //10000 #CJK UNIFIED IDEOGRAPH
    {0xE3CE, 0x84D7}, //10001 #CJK UNIFIED IDEOGRAPH
    {0xE3CF, 0x84D4}, //10002 #CJK UNIFIED IDEOGRAPH
    {0xE3D0, 0x84D2}, //10003 #CJK UNIFIED IDEOGRAPH
    {0xE3D1, 0x84DB}, //10004 #CJK UNIFIED IDEOGRAPH
    {0xE3D2, 0x84B0}, //10005 #CJK UNIFIED IDEOGRAPH
    {0xE3D3, 0x8491}, //10006 #CJK UNIFIED IDEOGRAPH
    {0xE3D4, 0x8661}, //10007 #CJK UNIFIED IDEOGRAPH
    {0xE3D5, 0x8733}, //10008 #CJK UNIFIED IDEOGRAPH
    {0xE3D6, 0x8723}, //10009 #CJK UNIFIED IDEOGRAPH
    {0xE3D7, 0x8728}, //10010 #CJK UNIFIED IDEOGRAPH
    {0xE3D8, 0x876B}, //10011 #CJK UNIFIED IDEOGRAPH
    {0xE3D9, 0x8740}, //10012 #CJK UNIFIED IDEOGRAPH
    {0xE3DA, 0x872E}, //10013 #CJK UNIFIED IDEOGRAPH
    {0xE3DB, 0x871E}, //10014 #CJK UNIFIED IDEOGRAPH
    {0xE3DC, 0x8721}, //10015 #CJK UNIFIED IDEOGRAPH
    {0xE3DD, 0x8719}, //10016 #CJK UNIFIED IDEOGRAPH
    {0xE3DE, 0x871B}, //10017 #CJK UNIFIED IDEOGRAPH
    {0xE3DF, 0x8743}, //10018 #CJK UNIFIED IDEOGRAPH
    {0xE3E0, 0x872C}, //10019 #CJK UNIFIED IDEOGRAPH
    {0xE3E1, 0x8741}, //10020 #CJK UNIFIED IDEOGRAPH
    {0xE3E2, 0x873E}, //10021 #CJK UNIFIED IDEOGRAPH
    {0xE3E3, 0x8746}, //10022 #CJK UNIFIED IDEOGRAPH
    {0xE3E4, 0x8720}, //10023 #CJK UNIFIED IDEOGRAPH
    {0xE3E5, 0x8732}, //10024 #CJK UNIFIED IDEOGRAPH
    {0xE3E6, 0x872A}, //10025 #CJK UNIFIED IDEOGRAPH
    {0xE3E7, 0x872D}, //10026 #CJK UNIFIED IDEOGRAPH
    {0xE3E8, 0x873C}, //10027 #CJK UNIFIED IDEOGRAPH
    {0xE3E9, 0x8712}, //10028 #CJK UNIFIED IDEOGRAPH
    {0xE3EA, 0x873A}, //10029 #CJK UNIFIED IDEOGRAPH
    {0xE3EB, 0x8731}, //10030 #CJK UNIFIED IDEOGRAPH
    {0xE3EC, 0x8735}, //10031 #CJK UNIFIED IDEOGRAPH
    {0xE3ED, 0x8742}, //10032 #CJK UNIFIED IDEOGRAPH
    {0xE3EE, 0x8726}, //10033 #CJK UNIFIED IDEOGRAPH
    {0xE3EF, 0x8727}, //10034 #CJK UNIFIED IDEOGRAPH
    {0xE3F0, 0x8738}, //10035 #CJK UNIFIED IDEOGRAPH
    {0xE3F1, 0x8724}, //10036 #CJK UNIFIED IDEOGRAPH
    {0xE3F2, 0x871A}, //10037 #CJK UNIFIED IDEOGRAPH
    {0xE3F3, 0x8730}, //10038 #CJK UNIFIED IDEOGRAPH
    {0xE3F4, 0x8711}, //10039 #CJK UNIFIED IDEOGRAPH
    {0xE3F5, 0x88F7}, //10040 #CJK UNIFIED IDEOGRAPH
    {0xE3F6, 0x88E7}, //10041 #CJK UNIFIED IDEOGRAPH
    {0xE3F7, 0x88F1}, //10042 #CJK UNIFIED IDEOGRAPH
    {0xE3F8, 0x88F2}, //10043 #CJK UNIFIED IDEOGRAPH
    {0xE3F9, 0x88FA}, //10044 #CJK UNIFIED IDEOGRAPH
    {0xE3FA, 0x88FE}, //10045 #CJK UNIFIED IDEOGRAPH
    {0xE3FB, 0x88EE}, //10046 #CJK UNIFIED IDEOGRAPH
    {0xE3FC, 0x88FC}, //10047 #CJK UNIFIED IDEOGRAPH
    {0xE3FD, 0x88F6}, //10048 #CJK UNIFIED IDEOGRAPH
    {0xE3FE, 0x88FB}, //10049 #CJK UNIFIED IDEOGRAPH
    {0xE440, 0x88F0}, //10050 #CJK UNIFIED IDEOGRAPH
    {0xE441, 0x88EC}, //10051 #CJK UNIFIED IDEOGRAPH
    {0xE442, 0x88EB}, //10052 #CJK UNIFIED IDEOGRAPH
    {0xE443, 0x899D}, //10053 #CJK UNIFIED IDEOGRAPH
    {0xE444, 0x89A1}, //10054 #CJK UNIFIED IDEOGRAPH
    {0xE445, 0x899F}, //10055 #CJK UNIFIED IDEOGRAPH
    {0xE446, 0x899E}, //10056 #CJK UNIFIED IDEOGRAPH
    {0xE447, 0x89E9}, //10057 #CJK UNIFIED IDEOGRAPH
    {0xE448, 0x89EB}, //10058 #CJK UNIFIED IDEOGRAPH
    {0xE449, 0x89E8}, //10059 #CJK UNIFIED IDEOGRAPH
    {0xE44A, 0x8AAB}, //10060 #CJK UNIFIED IDEOGRAPH
    {0xE44B, 0x8A99}, //10061 #CJK UNIFIED IDEOGRAPH
    {0xE44C, 0x8A8B}, //10062 #CJK UNIFIED IDEOGRAPH
    {0xE44D, 0x8A92}, //10063 #CJK UNIFIED IDEOGRAPH
    {0xE44E, 0x8A8F}, //10064 #CJK UNIFIED IDEOGRAPH
    {0xE44F, 0x8A96}, //10065 #CJK UNIFIED IDEOGRAPH
    {0xE450, 0x8C3D}, //10066 #CJK UNIFIED IDEOGRAPH
    {0xE451, 0x8C68}, //10067 #CJK UNIFIED IDEOGRAPH
    {0xE452, 0x8C69}, //10068 #CJK UNIFIED IDEOGRAPH
    {0xE453, 0x8CD5}, //10069 #CJK UNIFIED IDEOGRAPH
    {0xE454, 0x8CCF}, //10070 #CJK UNIFIED IDEOGRAPH
    {0xE455, 0x8CD7}, //10071 #CJK UNIFIED IDEOGRAPH
    {0xE456, 0x8D96}, //10072 #CJK UNIFIED IDEOGRAPH
    {0xE457, 0x8E09}, //10073 #CJK UNIFIED IDEOGRAPH
    {0xE458, 0x8E02}, //10074 #CJK UNIFIED IDEOGRAPH
    {0xE459, 0x8DFF}, //10075 #CJK UNIFIED IDEOGRAPH
    {0xE45A, 0x8E0D}, //10076 #CJK UNIFIED IDEOGRAPH
    {0xE45B, 0x8DFD}, //10077 #CJK UNIFIED IDEOGRAPH
    {0xE45C, 0x8E0A}, //10078 #CJK UNIFIED IDEOGRAPH
    {0xE45D, 0x8E03}, //10079 #CJK UNIFIED IDEOGRAPH
    {0xE45E, 0x8E07}, //10080 #CJK UNIFIED IDEOGRAPH
    {0xE45F, 0x8E06}, //10081 #CJK UNIFIED IDEOGRAPH
    {0xE460, 0x8E05}, //10082 #CJK UNIFIED IDEOGRAPH
    {0xE461, 0x8DFE}, //10083 #CJK UNIFIED IDEOGRAPH
    {0xE462, 0x8E00}, //10084 #CJK UNIFIED IDEOGRAPH
    {0xE463, 0x8E04}, //10085 #CJK UNIFIED IDEOGRAPH
    {0xE464, 0x8F10}, //10086 #CJK UNIFIED IDEOGRAPH
    {0xE465, 0x8F11}, //10087 #CJK UNIFIED IDEOGRAPH
    {0xE466, 0x8F0E}, //10088 #CJK UNIFIED IDEOGRAPH
    {0xE467, 0x8F0D}, //10089 #CJK UNIFIED IDEOGRAPH
    {0xE468, 0x9123}, //10090 #CJK UNIFIED IDEOGRAPH
    {0xE469, 0x911C}, //10091 #CJK UNIFIED IDEOGRAPH
    {0xE46A, 0x9120}, //10092 #CJK UNIFIED IDEOGRAPH
    {0xE46B, 0x9122}, //10093 #CJK UNIFIED IDEOGRAPH
    {0xE46C, 0x911F}, //10094 #CJK UNIFIED IDEOGRAPH
    {0xE46D, 0x911D}, //10095 #CJK UNIFIED IDEOGRAPH
    {0xE46E, 0x911A}, //10096 #CJK UNIFIED IDEOGRAPH
    {0xE46F, 0x9124}, //10097 #CJK UNIFIED IDEOGRAPH
    {0xE470, 0x9121}, //10098 #CJK UNIFIED IDEOGRAPH
    {0xE471, 0x911B}, //10099 #CJK UNIFIED IDEOGRAPH
    {0xE472, 0x917A}, //10100 #CJK UNIFIED IDEOGRAPH
    {0xE473, 0x9172}, //10101 #CJK UNIFIED IDEOGRAPH
    {0xE474, 0x9179}, //10102 #CJK UNIFIED IDEOGRAPH
    {0xE475, 0x9173}, //10103 #CJK UNIFIED IDEOGRAPH
    {0xE476, 0x92A5}, //10104 #CJK UNIFIED IDEOGRAPH
    {0xE477, 0x92A4}, //10105 #CJK UNIFIED IDEOGRAPH
    {0xE478, 0x9276}, //10106 #CJK UNIFIED IDEOGRAPH
    {0xE479, 0x929B}, //10107 #CJK UNIFIED IDEOGRAPH
    {0xE47A, 0x927A}, //10108 #CJK UNIFIED IDEOGRAPH
    {0xE47B, 0x92A0}, //10109 #CJK UNIFIED IDEOGRAPH
    {0xE47C, 0x9294}, //10110 #CJK UNIFIED IDEOGRAPH
    {0xE47D, 0x92AA}, //10111 #CJK UNIFIED IDEOGRAPH
    {0xE47E, 0x928D}, //10112 #CJK UNIFIED IDEOGRAPH
    {0xE4A1, 0x92A6}, //10113 #CJK UNIFIED IDEOGRAPH
    {0xE4A2, 0x929A}, //10114 #CJK UNIFIED IDEOGRAPH
    {0xE4A3, 0x92AB}, //10115 #CJK UNIFIED IDEOGRAPH
    {0xE4A4, 0x9279}, //10116 #CJK UNIFIED IDEOGRAPH
    {0xE4A5, 0x9297}, //10117 #CJK UNIFIED IDEOGRAPH
    {0xE4A6, 0x927F}, //10118 #CJK UNIFIED IDEOGRAPH
    {0xE4A7, 0x92A3}, //10119 #CJK UNIFIED IDEOGRAPH
    {0xE4A8, 0x92EE}, //10120 #CJK UNIFIED IDEOGRAPH
    {0xE4A9, 0x928E}, //10121 #CJK UNIFIED IDEOGRAPH
    {0xE4AA, 0x9282}, //10122 #CJK UNIFIED IDEOGRAPH
    {0xE4AB, 0x9295}, //10123 #CJK UNIFIED IDEOGRAPH
    {0xE4AC, 0x92A2}, //10124 #CJK UNIFIED IDEOGRAPH
    {0xE4AD, 0x927D}, //10125 #CJK UNIFIED IDEOGRAPH
    {0xE4AE, 0x9288}, //10126 #CJK UNIFIED IDEOGRAPH
    {0xE4AF, 0x92A1}, //10127 #CJK UNIFIED IDEOGRAPH
    {0xE4B0, 0x928A}, //10128 #CJK UNIFIED IDEOGRAPH
    {0xE4B1, 0x9286}, //10129 #CJK UNIFIED IDEOGRAPH
    {0xE4B2, 0x928C}, //10130 #CJK UNIFIED IDEOGRAPH
    {0xE4B3, 0x9299}, //10131 #CJK UNIFIED IDEOGRAPH
    {0xE4B4, 0x92A7}, //10132 #CJK UNIFIED IDEOGRAPH
    {0xE4B5, 0x927E}, //10133 #CJK UNIFIED IDEOGRAPH
    {0xE4B6, 0x9287}, //10134 #CJK UNIFIED IDEOGRAPH
    {0xE4B7, 0x92A9}, //10135 #CJK UNIFIED IDEOGRAPH
    {0xE4B8, 0x929D}, //10136 #CJK UNIFIED IDEOGRAPH
    {0xE4B9, 0x928B}, //10137 #CJK UNIFIED IDEOGRAPH
    {0xE4BA, 0x922D}, //10138 #CJK UNIFIED IDEOGRAPH
    {0xE4BB, 0x969E}, //10139 #CJK UNIFIED IDEOGRAPH
    {0xE4BC, 0x96A1}, //10140 #CJK UNIFIED IDEOGRAPH
    {0xE4BD, 0x96FF}, //10141 #CJK UNIFIED IDEOGRAPH
    {0xE4BE, 0x9758}, //10142 #CJK UNIFIED IDEOGRAPH
    {0xE4BF, 0x977D}, //10143 #CJK UNIFIED IDEOGRAPH
    {0xE4C0, 0x977A}, //10144 #CJK UNIFIED IDEOGRAPH
    {0xE4C1, 0x977E}, //10145 #CJK UNIFIED IDEOGRAPH
    {0xE4C2, 0x9783}, //10146 #CJK UNIFIED IDEOGRAPH
    {0xE4C3, 0x9780}, //10147 #CJK UNIFIED IDEOGRAPH
    {0xE4C4, 0x9782}, //10148 #CJK UNIFIED IDEOGRAPH
    {0xE4C5, 0x977B}, //10149 #CJK UNIFIED IDEOGRAPH
    {0xE4C6, 0x9784}, //10150 #CJK UNIFIED IDEOGRAPH
    {0xE4C7, 0x9781}, //10151 #CJK UNIFIED IDEOGRAPH
    {0xE4C8, 0x977F}, //10152 #CJK UNIFIED IDEOGRAPH
    {0xE4C9, 0x97CE}, //10153 #CJK UNIFIED IDEOGRAPH
    {0xE4CA, 0x97CD}, //10154 #CJK UNIFIED IDEOGRAPH
    {0xE4CB, 0x9816}, //10155 #CJK UNIFIED IDEOGRAPH
    {0xE4CC, 0x98AD}, //10156 #CJK UNIFIED IDEOGRAPH
    {0xE4CD, 0x98AE}, //10157 #CJK UNIFIED IDEOGRAPH
    {0xE4CE, 0x9902}, //10158 #CJK UNIFIED IDEOGRAPH
    {0xE4CF, 0x9900}, //10159 #CJK UNIFIED IDEOGRAPH
    {0xE4D0, 0x9907}, //10160 #CJK UNIFIED IDEOGRAPH
    {0xE4D1, 0x999D}, //10161 #CJK UNIFIED IDEOGRAPH
    {0xE4D2, 0x999C}, //10162 #CJK UNIFIED IDEOGRAPH
    {0xE4D3, 0x99C3}, //10163 #CJK UNIFIED IDEOGRAPH
    {0xE4D4, 0x99B9}, //10164 #CJK UNIFIED IDEOGRAPH
    {0xE4D5, 0x99BB}, //10165 #CJK UNIFIED IDEOGRAPH
    {0xE4D6, 0x99BA}, //10166 #CJK UNIFIED IDEOGRAPH
    {0xE4D7, 0x99C2}, //10167 #CJK UNIFIED IDEOGRAPH
    {0xE4D8, 0x99BD}, //10168 #CJK UNIFIED IDEOGRAPH
    {0xE4D9, 0x99C7}, //10169 #CJK UNIFIED IDEOGRAPH
    {0xE4DA, 0x9AB1}, //10170 #CJK UNIFIED IDEOGRAPH
    {0xE4DB, 0x9AE3}, //10171 #CJK UNIFIED IDEOGRAPH
    {0xE4DC, 0x9AE7}, //10172 #CJK UNIFIED IDEOGRAPH
    {0xE4DD, 0x9B3E}, //10173 #CJK UNIFIED IDEOGRAPH
    {0xE4DE, 0x9B3F}, //10174 #CJK UNIFIED IDEOGRAPH
    {0xE4DF, 0x9B60}, //10175 #CJK UNIFIED IDEOGRAPH
    {0xE4E0, 0x9B61}, //10176 #CJK UNIFIED IDEOGRAPH
    {0xE4E1, 0x9B5F}, //10177 #CJK UNIFIED IDEOGRAPH
    {0xE4E2, 0x9CF1}, //10178 #CJK UNIFIED IDEOGRAPH
    {0xE4E3, 0x9CF2}, //10179 #CJK UNIFIED IDEOGRAPH
    {0xE4E4, 0x9CF5}, //10180 #CJK UNIFIED IDEOGRAPH
    {0xE4E5, 0x9EA7}, //10181 #CJK UNIFIED IDEOGRAPH
    {0xE4E6, 0x50FF}, //10182 #CJK UNIFIED IDEOGRAPH
    {0xE4E7, 0x5103}, //10183 #CJK UNIFIED IDEOGRAPH
    {0xE4E8, 0x5130}, //10184 #CJK UNIFIED IDEOGRAPH
    {0xE4E9, 0x50F8}, //10185 #CJK UNIFIED IDEOGRAPH
    {0xE4EA, 0x5106}, //10186 #CJK UNIFIED IDEOGRAPH
    {0xE4EB, 0x5107}, //10187 #CJK UNIFIED IDEOGRAPH
    {0xE4EC, 0x50F6}, //10188 #CJK UNIFIED IDEOGRAPH
    {0xE4ED, 0x50FE}, //10189 #CJK UNIFIED IDEOGRAPH
    {0xE4EE, 0x510B}, //10190 #CJK UNIFIED IDEOGRAPH
    {0xE4EF, 0x510C}, //10191 #CJK UNIFIED IDEOGRAPH
    {0xE4F0, 0x50FD}, //10192 #CJK UNIFIED IDEOGRAPH
    {0xE4F1, 0x510A}, //10193 #CJK UNIFIED IDEOGRAPH
    {0xE4F2, 0x528B}, //10194 #CJK UNIFIED IDEOGRAPH
    {0xE4F3, 0x528C}, //10195 #CJK UNIFIED IDEOGRAPH
    {0xE4F4, 0x52F1}, //10196 #CJK UNIFIED IDEOGRAPH
    {0xE4F5, 0x52EF}, //10197 #CJK UNIFIED IDEOGRAPH
    {0xE4F6, 0x5648}, //10198 #CJK UNIFIED IDEOGRAPH
    {0xE4F7, 0x5642}, //10199 #CJK UNIFIED IDEOGRAPH
    {0xE4F8, 0x564C}, //10200 #CJK UNIFIED IDEOGRAPH
    {0xE4F9, 0x5635}, //10201 #CJK UNIFIED IDEOGRAPH
    {0xE4FA, 0x5641}, //10202 #CJK UNIFIED IDEOGRAPH
    {0xE4FB, 0x564A}, //10203 #CJK UNIFIED IDEOGRAPH
    {0xE4FC, 0x5649}, //10204 #CJK UNIFIED IDEOGRAPH
    {0xE4FD, 0x5646}, //10205 #CJK UNIFIED IDEOGRAPH
    {0xE4FE, 0x5658}, //10206 #CJK UNIFIED IDEOGRAPH
    {0xE540, 0x565A}, //10207 #CJK UNIFIED IDEOGRAPH
    {0xE541, 0x5640}, //10208 #CJK UNIFIED IDEOGRAPH
    {0xE542, 0x5633}, //10209 #CJK UNIFIED IDEOGRAPH
    {0xE543, 0x563D}, //10210 #CJK UNIFIED IDEOGRAPH
    {0xE544, 0x562C}, //10211 #CJK UNIFIED IDEOGRAPH
    {0xE545, 0x563E}, //10212 #CJK UNIFIED IDEOGRAPH
    {0xE546, 0x5638}, //10213 #CJK UNIFIED IDEOGRAPH
    {0xE547, 0x562A}, //10214 #CJK UNIFIED IDEOGRAPH
    {0xE548, 0x563A}, //10215 #CJK UNIFIED IDEOGRAPH
    {0xE549, 0x571A}, //10216 #CJK UNIFIED IDEOGRAPH
    {0xE54A, 0x58AB}, //10217 #CJK UNIFIED IDEOGRAPH
    {0xE54B, 0x589D}, //10218 #CJK UNIFIED IDEOGRAPH
    {0xE54C, 0x58B1}, //10219 #CJK UNIFIED IDEOGRAPH
    {0xE54D, 0x58A0}, //10220 #CJK UNIFIED IDEOGRAPH
    {0xE54E, 0x58A3}, //10221 #CJK UNIFIED IDEOGRAPH
    {0xE54F, 0x58AF}, //10222 #CJK UNIFIED IDEOGRAPH
    {0xE550, 0x58AC}, //10223 #CJK UNIFIED IDEOGRAPH
    {0xE551, 0x58A5}, //10224 #CJK UNIFIED IDEOGRAPH
    {0xE552, 0x58A1}, //10225 #CJK UNIFIED IDEOGRAPH
    {0xE553, 0x58FF}, //10226 #CJK UNIFIED IDEOGRAPH
    {0xE554, 0x5AFF}, //10227 #CJK UNIFIED IDEOGRAPH
    {0xE555, 0x5AF4}, //10228 #CJK UNIFIED IDEOGRAPH
    {0xE556, 0x5AFD}, //10229 #CJK UNIFIED IDEOGRAPH
    {0xE557, 0x5AF7}, //10230 #CJK UNIFIED IDEOGRAPH
    {0xE558, 0x5AF6}, //10231 #CJK UNIFIED IDEOGRAPH
    {0xE559, 0x5B03}, //10232 #CJK UNIFIED IDEOGRAPH
    {0xE55A, 0x5AF8}, //10233 #CJK UNIFIED IDEOGRAPH
    {0xE55B, 0x5B02}, //10234 #CJK UNIFIED IDEOGRAPH
    {0xE55C, 0x5AF9}, //10235 #CJK UNIFIED IDEOGRAPH
    {0xE55D, 0x5B01}, //10236 #CJK UNIFIED IDEOGRAPH
    {0xE55E, 0x5B07}, //10237 #CJK UNIFIED IDEOGRAPH
    {0xE55F, 0x5B05}, //10238 #CJK UNIFIED IDEOGRAPH
    {0xE560, 0x5B0F}, //10239 #CJK UNIFIED IDEOGRAPH
    {0xE561, 0x5C67}, //10240 #CJK UNIFIED IDEOGRAPH
    {0xE562, 0x5D99}, //10241 #CJK UNIFIED IDEOGRAPH
    {0xE563, 0x5D97}, //10242 #CJK UNIFIED IDEOGRAPH
    {0xE564, 0x5D9F}, //10243 #CJK UNIFIED IDEOGRAPH
    {0xE565, 0x5D92}, //10244 #CJK UNIFIED IDEOGRAPH
    {0xE566, 0x5DA2}, //10245 #CJK UNIFIED IDEOGRAPH
    {0xE567, 0x5D93}, //10246 #CJK UNIFIED IDEOGRAPH
    {0xE568, 0x5D95}, //10247 #CJK UNIFIED IDEOGRAPH
    {0xE569, 0x5DA0}, //10248 #CJK UNIFIED IDEOGRAPH
    {0xE56A, 0x5D9C}, //10249 #CJK UNIFIED IDEOGRAPH
    {0xE56B, 0x5DA1}, //10250 #CJK UNIFIED IDEOGRAPH
    {0xE56C, 0x5D9A}, //10251 #CJK UNIFIED IDEOGRAPH
    {0xE56D, 0x5D9E}, //10252 #CJK UNIFIED IDEOGRAPH
    {0xE56E, 0x5E69}, //10253 #CJK UNIFIED IDEOGRAPH
    {0xE56F, 0x5E5D}, //10254 #CJK UNIFIED IDEOGRAPH
    {0xE570, 0x5E60}, //10255 #CJK UNIFIED IDEOGRAPH
    {0xE571, 0x5E5C}, //10256 #CJK UNIFIED IDEOGRAPH
    {0xE572, 0x7DF3}, //10257 #CJK UNIFIED IDEOGRAPH
    {0xE573, 0x5EDB}, //10258 #CJK UNIFIED IDEOGRAPH
    {0xE574, 0x5EDE}, //10259 #CJK UNIFIED IDEOGRAPH
    {0xE575, 0x5EE1}, //10260 #CJK UNIFIED IDEOGRAPH
    {0xE576, 0x5F49}, //10261 #CJK UNIFIED IDEOGRAPH
    {0xE577, 0x5FB2}, //10262 #CJK UNIFIED IDEOGRAPH
    {0xE578, 0x618B}, //10263 #CJK UNIFIED IDEOGRAPH
    {0xE579, 0x6183}, //10264 #CJK UNIFIED IDEOGRAPH
    {0xE57A, 0x6179}, //10265 #CJK UNIFIED IDEOGRAPH
    {0xE57B, 0x61B1}, //10266 #CJK UNIFIED IDEOGRAPH
    {0xE57C, 0x61B0}, //10267 #CJK UNIFIED IDEOGRAPH
    {0xE57D, 0x61A2}, //10268 #CJK UNIFIED IDEOGRAPH
    {0xE57E, 0x6189}, //10269 #CJK UNIFIED IDEOGRAPH
    {0xE5A1, 0x619B}, //10270 #CJK UNIFIED IDEOGRAPH
    {0xE5A2, 0x6193}, //10271 #CJK UNIFIED IDEOGRAPH
    {0xE5A3, 0x61AF}, //10272 #CJK UNIFIED IDEOGRAPH
    {0xE5A4, 0x61AD}, //10273 #CJK UNIFIED IDEOGRAPH
    {0xE5A5, 0x619F}, //10274 #CJK UNIFIED IDEOGRAPH
    {0xE5A6, 0x6192}, //10275 #CJK UNIFIED IDEOGRAPH
    {0xE5A7, 0x61AA}, //10276 #CJK UNIFIED IDEOGRAPH
    {0xE5A8, 0x61A1}, //10277 #CJK UNIFIED IDEOGRAPH
    {0xE5A9, 0x618D}, //10278 #CJK UNIFIED IDEOGRAPH
    {0xE5AA, 0x6166}, //10279 #CJK UNIFIED IDEOGRAPH
    {0xE5AB, 0x61B3}, //10280 #CJK UNIFIED IDEOGRAPH
    {0xE5AC, 0x622D}, //10281 #CJK UNIFIED IDEOGRAPH
    {0xE5AD, 0x646E}, //10282 #CJK UNIFIED IDEOGRAPH
    {0xE5AE, 0x6470}, //10283 #CJK UNIFIED IDEOGRAPH
    {0xE5AF, 0x6496}, //10284 #CJK UNIFIED IDEOGRAPH
    {0xE5B0, 0x64A0}, //10285 #CJK UNIFIED IDEOGRAPH
    {0xE5B1, 0x6485}, //10286 #CJK UNIFIED IDEOGRAPH
    {0xE5B2, 0x6497}, //10287 #CJK UNIFIED IDEOGRAPH
    {0xE5B3, 0x649C}, //10288 #CJK UNIFIED IDEOGRAPH
    {0xE5B4, 0x648F}, //10289 #CJK UNIFIED IDEOGRAPH
    {0xE5B5, 0x648B}, //10290 #CJK UNIFIED IDEOGRAPH
    {0xE5B6, 0x648A}, //10291 #CJK UNIFIED IDEOGRAPH
    {0xE5B7, 0x648C}, //10292 #CJK UNIFIED IDEOGRAPH
    {0xE5B8, 0x64A3}, //10293 #CJK UNIFIED IDEOGRAPH
    {0xE5B9, 0x649F}, //10294 #CJK UNIFIED IDEOGRAPH
    {0xE5BA, 0x6468}, //10295 #CJK UNIFIED IDEOGRAPH
    {0xE5BB, 0x64B1}, //10296 #CJK UNIFIED IDEOGRAPH
    {0xE5BC, 0x6498}, //10297 #CJK UNIFIED IDEOGRAPH
    {0xE5BD, 0x6576}, //10298 #CJK UNIFIED IDEOGRAPH
    {0xE5BE, 0x657A}, //10299 #CJK UNIFIED IDEOGRAPH
    {0xE5BF, 0x6579}, //10300 #CJK UNIFIED IDEOGRAPH
    {0xE5C0, 0x657B}, //10301 #CJK UNIFIED IDEOGRAPH
    {0xE5C1, 0x65B2}, //10302 #CJK UNIFIED IDEOGRAPH
    {0xE5C2, 0x65B3}, //10303 #CJK UNIFIED IDEOGRAPH
    {0xE5C3, 0x66B5}, //10304 #CJK UNIFIED IDEOGRAPH
    {0xE5C4, 0x66B0}, //10305 #CJK UNIFIED IDEOGRAPH
    {0xE5C5, 0x66A9}, //10306 #CJK UNIFIED IDEOGRAPH
    {0xE5C6, 0x66B2}, //10307 #CJK UNIFIED IDEOGRAPH
    {0xE5C7, 0x66B7}, //10308 #CJK UNIFIED IDEOGRAPH
    {0xE5C8, 0x66AA}, //10309 #CJK UNIFIED IDEOGRAPH
    {0xE5C9, 0x66AF}, //10310 #CJK UNIFIED IDEOGRAPH
    {0xE5CA, 0x6A00}, //10311 #CJK UNIFIED IDEOGRAPH
    {0xE5CB, 0x6A06}, //10312 #CJK UNIFIED IDEOGRAPH
    {0xE5CC, 0x6A17}, //10313 #CJK UNIFIED IDEOGRAPH
    {0xE5CD, 0x69E5}, //10314 #CJK UNIFIED IDEOGRAPH
    {0xE5CE, 0x69F8}, //10315 #CJK UNIFIED IDEOGRAPH
    {0xE5CF, 0x6A15}, //10316 #CJK UNIFIED IDEOGRAPH
    {0xE5D0, 0x69F1}, //10317 #CJK UNIFIED IDEOGRAPH
    {0xE5D1, 0x69E4}, //10318 #CJK UNIFIED IDEOGRAPH
    {0xE5D2, 0x6A20}, //10319 #CJK UNIFIED IDEOGRAPH
    {0xE5D3, 0x69FF}, //10320 #CJK UNIFIED IDEOGRAPH
    {0xE5D4, 0x69EC}, //10321 #CJK UNIFIED IDEOGRAPH
    {0xE5D5, 0x69E2}, //10322 #CJK UNIFIED IDEOGRAPH
    {0xE5D6, 0x6A1B}, //10323 #CJK UNIFIED IDEOGRAPH
    {0xE5D7, 0x6A1D}, //10324 #CJK UNIFIED IDEOGRAPH
    {0xE5D8, 0x69FE}, //10325 #CJK UNIFIED IDEOGRAPH
    {0xE5D9, 0x6A27}, //10326 #CJK UNIFIED IDEOGRAPH
    {0xE5DA, 0x69F2}, //10327 #CJK UNIFIED IDEOGRAPH
    {0xE5DB, 0x69EE}, //10328 #CJK UNIFIED IDEOGRAPH
    {0xE5DC, 0x6A14}, //10329 #CJK UNIFIED IDEOGRAPH
    {0xE5DD, 0x69F7}, //10330 #CJK UNIFIED IDEOGRAPH
    {0xE5DE, 0x69E7}, //10331 #CJK UNIFIED IDEOGRAPH
    {0xE5DF, 0x6A40}, //10332 #CJK UNIFIED IDEOGRAPH
    {0xE5E0, 0x6A08}, //10333 #CJK UNIFIED IDEOGRAPH
    {0xE5E1, 0x69E6}, //10334 #CJK UNIFIED IDEOGRAPH
    {0xE5E2, 0x69FB}, //10335 #CJK UNIFIED IDEOGRAPH
    {0xE5E3, 0x6A0D}, //10336 #CJK UNIFIED IDEOGRAPH
    {0xE5E4, 0x69FC}, //10337 #CJK UNIFIED IDEOGRAPH
    {0xE5E5, 0x69EB}, //10338 #CJK UNIFIED IDEOGRAPH
    {0xE5E6, 0x6A09}, //10339 #CJK UNIFIED IDEOGRAPH
    {0xE5E7, 0x6A04}, //10340 #CJK UNIFIED IDEOGRAPH
    {0xE5E8, 0x6A18}, //10341 #CJK UNIFIED IDEOGRAPH
    {0xE5E9, 0x6A25}, //10342 #CJK UNIFIED IDEOGRAPH
    {0xE5EA, 0x6A0F}, //10343 #CJK UNIFIED IDEOGRAPH
    {0xE5EB, 0x69F6}, //10344 #CJK UNIFIED IDEOGRAPH
    {0xE5EC, 0x6A26}, //10345 #CJK UNIFIED IDEOGRAPH
    {0xE5ED, 0x6A07}, //10346 #CJK UNIFIED IDEOGRAPH
    {0xE5EE, 0x69F4}, //10347 #CJK UNIFIED IDEOGRAPH
    {0xE5EF, 0x6A16}, //10348 #CJK UNIFIED IDEOGRAPH
    {0xE5F0, 0x6B51}, //10349 #CJK UNIFIED IDEOGRAPH
    {0xE5F1, 0x6BA5}, //10350 #CJK UNIFIED IDEOGRAPH
    {0xE5F2, 0x6BA3}, //10351 #CJK UNIFIED IDEOGRAPH
    {0xE5F3, 0x6BA2}, //10352 #CJK UNIFIED IDEOGRAPH
    {0xE5F4, 0x6BA6}, //10353 #CJK UNIFIED IDEOGRAPH
    {0xE5F5, 0x6C01}, //10354 #CJK UNIFIED IDEOGRAPH
    {0xE5F6, 0x6C00}, //10355 #CJK UNIFIED IDEOGRAPH
    {0xE5F7, 0x6BFF}, //10356 #CJK UNIFIED IDEOGRAPH
    {0xE5F8, 0x6C02}, //10357 #CJK UNIFIED IDEOGRAPH
    {0xE5F9, 0x6F41}, //10358 #CJK UNIFIED IDEOGRAPH
    {0xE5FA, 0x6F26}, //10359 #CJK UNIFIED IDEOGRAPH
    {0xE5FB, 0x6F7E}, //10360 #CJK UNIFIED IDEOGRAPH
    {0xE5FC, 0x6F87}, //10361 #CJK UNIFIED IDEOGRAPH
    {0xE5FD, 0x6FC6}, //10362 #CJK UNIFIED IDEOGRAPH
    {0xE5FE, 0x6F92}, //10363 #CJK UNIFIED IDEOGRAPH
    {0xE640, 0x6F8D}, //10364 #CJK UNIFIED IDEOGRAPH
    {0xE641, 0x6F89}, //10365 #CJK UNIFIED IDEOGRAPH
    {0xE642, 0x6F8C}, //10366 #CJK UNIFIED IDEOGRAPH
    {0xE643, 0x6F62}, //10367 #CJK UNIFIED IDEOGRAPH
    {0xE644, 0x6F4F}, //10368 #CJK UNIFIED IDEOGRAPH
    {0xE645, 0x6F85}, //10369 #CJK UNIFIED IDEOGRAPH
    {0xE646, 0x6F5A}, //10370 #CJK UNIFIED IDEOGRAPH
    {0xE647, 0x6F96}, //10371 #CJK UNIFIED IDEOGRAPH
    {0xE648, 0x6F76}, //10372 #CJK UNIFIED IDEOGRAPH
    {0xE649, 0x6F6C}, //10373 #CJK UNIFIED IDEOGRAPH
    {0xE64A, 0x6F82}, //10374 #CJK UNIFIED IDEOGRAPH
    {0xE64B, 0x6F55}, //10375 #CJK UNIFIED IDEOGRAPH
    {0xE64C, 0x6F72}, //10376 #CJK UNIFIED IDEOGRAPH
    {0xE64D, 0x6F52}, //10377 #CJK UNIFIED IDEOGRAPH
    {0xE64E, 0x6F50}, //10378 #CJK UNIFIED IDEOGRAPH
    {0xE64F, 0x6F57}, //10379 #CJK UNIFIED IDEOGRAPH
    {0xE650, 0x6F94}, //10380 #CJK UNIFIED IDEOGRAPH
    {0xE651, 0x6F93}, //10381 #CJK UNIFIED IDEOGRAPH
    {0xE652, 0x6F5D}, //10382 #CJK UNIFIED IDEOGRAPH
    {0xE653, 0x6F00}, //10383 #CJK UNIFIED IDEOGRAPH
    {0xE654, 0x6F61}, //10384 #CJK UNIFIED IDEOGRAPH
    {0xE655, 0x6F6B}, //10385 #CJK UNIFIED IDEOGRAPH
    {0xE656, 0x6F7D}, //10386 #CJK UNIFIED IDEOGRAPH
    {0xE657, 0x6F67}, //10387 #CJK UNIFIED IDEOGRAPH
    {0xE658, 0x6F90}, //10388 #CJK UNIFIED IDEOGRAPH
    {0xE659, 0x6F53}, //10389 #CJK UNIFIED IDEOGRAPH
    {0xE65A, 0x6F8B}, //10390 #CJK UNIFIED IDEOGRAPH
    {0xE65B, 0x6F69}, //10391 #CJK UNIFIED IDEOGRAPH
    {0xE65C, 0x6F7F}, //10392 #CJK UNIFIED IDEOGRAPH
    {0xE65D, 0x6F95}, //10393 #CJK UNIFIED IDEOGRAPH
    {0xE65E, 0x6F63}, //10394 #CJK UNIFIED IDEOGRAPH
    {0xE65F, 0x6F77}, //10395 #CJK UNIFIED IDEOGRAPH
    {0xE660, 0x6F6A}, //10396 #CJK UNIFIED IDEOGRAPH
    {0xE661, 0x6F7B}, //10397 #CJK UNIFIED IDEOGRAPH
    {0xE662, 0x71B2}, //10398 #CJK UNIFIED IDEOGRAPH
    {0xE663, 0x71AF}, //10399 #CJK UNIFIED IDEOGRAPH
    {0xE664, 0x719B}, //10400 #CJK UNIFIED IDEOGRAPH
    {0xE665, 0x71B0}, //10401 #CJK UNIFIED IDEOGRAPH
    {0xE666, 0x71A0}, //10402 #CJK UNIFIED IDEOGRAPH
    {0xE667, 0x719A}, //10403 #CJK UNIFIED IDEOGRAPH
    {0xE668, 0x71A9}, //10404 #CJK UNIFIED IDEOGRAPH
    {0xE669, 0x71B5}, //10405 #CJK UNIFIED IDEOGRAPH
    {0xE66A, 0x719D}, //10406 #CJK UNIFIED IDEOGRAPH
    {0xE66B, 0x71A5}, //10407 #CJK UNIFIED IDEOGRAPH
    {0xE66C, 0x719E}, //10408 #CJK UNIFIED IDEOGRAPH
    {0xE66D, 0x71A4}, //10409 #CJK UNIFIED IDEOGRAPH
    {0xE66E, 0x71A1}, //10410 #CJK UNIFIED IDEOGRAPH
    {0xE66F, 0x71AA}, //10411 #CJK UNIFIED IDEOGRAPH
    {0xE670, 0x719C}, //10412 #CJK UNIFIED IDEOGRAPH
    {0xE671, 0x71A7}, //10413 #CJK UNIFIED IDEOGRAPH
    {0xE672, 0x71B3}, //10414 #CJK UNIFIED IDEOGRAPH
    {0xE673, 0x7298}, //10415 #CJK UNIFIED IDEOGRAPH
    {0xE674, 0x729A}, //10416 #CJK UNIFIED IDEOGRAPH
    {0xE675, 0x7358}, //10417 #CJK UNIFIED IDEOGRAPH
    {0xE676, 0x7352}, //10418 #CJK UNIFIED IDEOGRAPH
    {0xE677, 0x735E}, //10419 #CJK UNIFIED IDEOGRAPH
    {0xE678, 0x735F}, //10420 #CJK UNIFIED IDEOGRAPH
    {0xE679, 0x7360}, //10421 #CJK UNIFIED IDEOGRAPH
    {0xE67A, 0x735D}, //10422 #CJK UNIFIED IDEOGRAPH
    {0xE67B, 0x735B}, //10423 #CJK UNIFIED IDEOGRAPH
    {0xE67C, 0x7361}, //10424 #CJK UNIFIED IDEOGRAPH
    {0xE67D, 0x735A}, //10425 #CJK UNIFIED IDEOGRAPH
    {0xE67E, 0x7359}, //10426 #CJK UNIFIED IDEOGRAPH
    {0xE6A1, 0x7362}, //10427 #CJK UNIFIED IDEOGRAPH
    {0xE6A2, 0x7487}, //10428 #CJK UNIFIED IDEOGRAPH
    {0xE6A3, 0x7489}, //10429 #CJK UNIFIED IDEOGRAPH
    {0xE6A4, 0x748A}, //10430 #CJK UNIFIED IDEOGRAPH
    {0xE6A5, 0x7486}, //10431 #CJK UNIFIED IDEOGRAPH
    {0xE6A6, 0x7481}, //10432 #CJK UNIFIED IDEOGRAPH
    {0xE6A7, 0x747D}, //10433 #CJK UNIFIED IDEOGRAPH
    {0xE6A8, 0x7485}, //10434 #CJK UNIFIED IDEOGRAPH
    {0xE6A9, 0x7488}, //10435 #CJK UNIFIED IDEOGRAPH
    {0xE6AA, 0x747C}, //10436 #CJK UNIFIED IDEOGRAPH
    {0xE6AB, 0x7479}, //10437 #CJK UNIFIED IDEOGRAPH
    {0xE6AC, 0x7508}, //10438 #CJK UNIFIED IDEOGRAPH
    {0xE6AD, 0x7507}, //10439 #CJK UNIFIED IDEOGRAPH
    {0xE6AE, 0x757E}, //10440 #CJK UNIFIED IDEOGRAPH
    {0xE6AF, 0x7625}, //10441 #CJK UNIFIED IDEOGRAPH
    {0xE6B0, 0x761E}, //10442 #CJK UNIFIED IDEOGRAPH
    {0xE6B1, 0x7619}, //10443 #CJK UNIFIED IDEOGRAPH
    {0xE6B2, 0x761D}, //10444 #CJK UNIFIED IDEOGRAPH
    {0xE6B3, 0x761C}, //10445 #CJK UNIFIED IDEOGRAPH
    {0xE6B4, 0x7623}, //10446 #CJK UNIFIED IDEOGRAPH
    {0xE6B5, 0x761A}, //10447 #CJK UNIFIED IDEOGRAPH
    {0xE6B6, 0x7628}, //10448 #CJK UNIFIED IDEOGRAPH
    {0xE6B7, 0x761B}, //10449 #CJK UNIFIED IDEOGRAPH
    {0xE6B8, 0x769C}, //10450 #CJK UNIFIED IDEOGRAPH
    {0xE6B9, 0x769D}, //10451 #CJK UNIFIED IDEOGRAPH
    {0xE6BA, 0x769E}, //10452 #CJK UNIFIED IDEOGRAPH
    {0xE6BB, 0x769B}, //10453 #CJK UNIFIED IDEOGRAPH
    {0xE6BC, 0x778D}, //10454 #CJK UNIFIED IDEOGRAPH
    {0xE6BD, 0x778F}, //10455 #CJK UNIFIED IDEOGRAPH
    {0xE6BE, 0x7789}, //10456 #CJK UNIFIED IDEOGRAPH
    {0xE6BF, 0x7788}, //10457 #CJK UNIFIED IDEOGRAPH
    {0xE6C0, 0x78CD}, //10458 #CJK UNIFIED IDEOGRAPH
    {0xE6C1, 0x78BB}, //10459 #CJK UNIFIED IDEOGRAPH
    {0xE6C2, 0x78CF}, //10460 #CJK UNIFIED IDEOGRAPH
    {0xE6C3, 0x78CC}, //10461 #CJK UNIFIED IDEOGRAPH
    {0xE6C4, 0x78D1}, //10462 #CJK UNIFIED IDEOGRAPH
    {0xE6C5, 0x78CE}, //10463 #CJK UNIFIED IDEOGRAPH
    {0xE6C6, 0x78D4}, //10464 #CJK UNIFIED IDEOGRAPH
    {0xE6C7, 0x78C8}, //10465 #CJK UNIFIED IDEOGRAPH
    {0xE6C8, 0x78C3}, //10466 #CJK UNIFIED IDEOGRAPH
    {0xE6C9, 0x78C4}, //10467 #CJK UNIFIED IDEOGRAPH
    {0xE6CA, 0x78C9}, //10468 #CJK UNIFIED IDEOGRAPH
    {0xE6CB, 0x799A}, //10469 #CJK UNIFIED IDEOGRAPH
    {0xE6CC, 0x79A1}, //10470 #CJK UNIFIED IDEOGRAPH
    {0xE6CD, 0x79A0}, //10471 #CJK UNIFIED IDEOGRAPH
    {0xE6CE, 0x799C}, //10472 #CJK UNIFIED IDEOGRAPH
    {0xE6CF, 0x79A2}, //10473 #CJK UNIFIED IDEOGRAPH
    {0xE6D0, 0x799B}, //10474 #CJK UNIFIED IDEOGRAPH
    {0xE6D1, 0x6B76}, //10475 #CJK UNIFIED IDEOGRAPH
    {0xE6D2, 0x7A39}, //10476 #CJK UNIFIED IDEOGRAPH
    {0xE6D3, 0x7AB2}, //10477 #CJK UNIFIED IDEOGRAPH
    {0xE6D4, 0x7AB4}, //10478 #CJK UNIFIED IDEOGRAPH
    {0xE6D5, 0x7AB3}, //10479 #CJK UNIFIED IDEOGRAPH
    {0xE6D6, 0x7BB7}, //10480 #CJK UNIFIED IDEOGRAPH
    {0xE6D7, 0x7BCB}, //10481 #CJK UNIFIED IDEOGRAPH
    {0xE6D8, 0x7BBE}, //10482 #CJK UNIFIED IDEOGRAPH
    {0xE6D9, 0x7BAC}, //10483 #CJK UNIFIED IDEOGRAPH
    {0xE6DA, 0x7BCE}, //10484 #CJK UNIFIED IDEOGRAPH
    {0xE6DB, 0x7BAF}, //10485 #CJK UNIFIED IDEOGRAPH
    {0xE6DC, 0x7BB9}, //10486 #CJK UNIFIED IDEOGRAPH
    {0xE6DD, 0x7BCA}, //10487 #CJK UNIFIED IDEOGRAPH
    {0xE6DE, 0x7BB5}, //10488 #CJK UNIFIED IDEOGRAPH
    {0xE6DF, 0x7CC5}, //10489 #CJK UNIFIED IDEOGRAPH
    {0xE6E0, 0x7CC8}, //10490 #CJK UNIFIED IDEOGRAPH
    {0xE6E1, 0x7CCC}, //10491 #CJK UNIFIED IDEOGRAPH
    {0xE6E2, 0x7CCB}, //10492 #CJK UNIFIED IDEOGRAPH
    {0xE6E3, 0x7DF7}, //10493 #CJK UNIFIED IDEOGRAPH
    {0xE6E4, 0x7DDB}, //10494 #CJK UNIFIED IDEOGRAPH
    {0xE6E5, 0x7DEA}, //10495 #CJK UNIFIED IDEOGRAPH
    {0xE6E6, 0x7DE7}, //10496 #CJK UNIFIED IDEOGRAPH
    {0xE6E7, 0x7DD7}, //10497 #CJK UNIFIED IDEOGRAPH
    {0xE6E8, 0x7DE1}, //10498 #CJK UNIFIED IDEOGRAPH
    {0xE6E9, 0x7E03}, //10499 #CJK UNIFIED IDEOGRAPH
    {0xE6EA, 0x7DFA}, //10500 #CJK UNIFIED IDEOGRAPH
    {0xE6EB, 0x7DE6}, //10501 #CJK UNIFIED IDEOGRAPH
    {0xE6EC, 0x7DF6}, //10502 #CJK UNIFIED IDEOGRAPH
    {0xE6ED, 0x7DF1}, //10503 #CJK UNIFIED IDEOGRAPH
    {0xE6EE, 0x7DF0}, //10504 #CJK UNIFIED IDEOGRAPH
    {0xE6EF, 0x7DEE}, //10505 #CJK UNIFIED IDEOGRAPH
    {0xE6F0, 0x7DDF}, //10506 #CJK UNIFIED IDEOGRAPH
    {0xE6F1, 0x7F76}, //10507 #CJK UNIFIED IDEOGRAPH
    {0xE6F2, 0x7FAC}, //10508 #CJK UNIFIED IDEOGRAPH
    {0xE6F3, 0x7FB0}, //10509 #CJK UNIFIED IDEOGRAPH
    {0xE6F4, 0x7FAD}, //10510 #CJK UNIFIED IDEOGRAPH
    {0xE6F5, 0x7FED}, //10511 #CJK UNIFIED IDEOGRAPH
    {0xE6F6, 0x7FEB}, //10512 #CJK UNIFIED IDEOGRAPH
    {0xE6F7, 0x7FEA}, //10513 #CJK UNIFIED IDEOGRAPH
    {0xE6F8, 0x7FEC}, //10514 #CJK UNIFIED IDEOGRAPH
    {0xE6F9, 0x7FE6}, //10515 #CJK UNIFIED IDEOGRAPH
    {0xE6FA, 0x7FE8}, //10516 #CJK UNIFIED IDEOGRAPH
    {0xE6FB, 0x8064}, //10517 #CJK UNIFIED IDEOGRAPH
    {0xE6FC, 0x8067}, //10518 #CJK UNIFIED IDEOGRAPH
    {0xE6FD, 0x81A3}, //10519 #CJK UNIFIED IDEOGRAPH
    {0xE6FE, 0x819F}, //10520 #CJK UNIFIED IDEOGRAPH
    {0xE740, 0x819E}, //10521 #CJK UNIFIED IDEOGRAPH
    {0xE741, 0x8195}, //10522 #CJK UNIFIED IDEOGRAPH
    {0xE742, 0x81A2}, //10523 #CJK UNIFIED IDEOGRAPH
    {0xE743, 0x8199}, //10524 #CJK UNIFIED IDEOGRAPH
    {0xE744, 0x8197}, //10525 #CJK UNIFIED IDEOGRAPH
    {0xE745, 0x8216}, //10526 #CJK UNIFIED IDEOGRAPH
    {0xE746, 0x824F}, //10527 #CJK UNIFIED IDEOGRAPH
    {0xE747, 0x8253}, //10528 #CJK UNIFIED IDEOGRAPH
    {0xE748, 0x8252}, //10529 #CJK UNIFIED IDEOGRAPH
    {0xE749, 0x8250}, //10530 #CJK UNIFIED IDEOGRAPH
    {0xE74A, 0x824E}, //10531 #CJK UNIFIED IDEOGRAPH
    {0xE74B, 0x8251}, //10532 #CJK UNIFIED IDEOGRAPH
    {0xE74C, 0x8524}, //10533 #CJK UNIFIED IDEOGRAPH
    {0xE74D, 0x853B}, //10534 #CJK UNIFIED IDEOGRAPH
    {0xE74E, 0x850F}, //10535 #CJK UNIFIED IDEOGRAPH
    {0xE74F, 0x8500}, //10536 #CJK UNIFIED IDEOGRAPH
    {0xE750, 0x8529}, //10537 #CJK UNIFIED IDEOGRAPH
    {0xE751, 0x850E}, //10538 #CJK UNIFIED IDEOGRAPH
    {0xE752, 0x8509}, //10539 #CJK UNIFIED IDEOGRAPH
    {0xE753, 0x850D}, //10540 #CJK UNIFIED IDEOGRAPH
    {0xE754, 0x851F}, //10541 #CJK UNIFIED IDEOGRAPH
    {0xE755, 0x850A}, //10542 #CJK UNIFIED IDEOGRAPH
    {0xE756, 0x8527}, //10543 #CJK UNIFIED IDEOGRAPH
    {0xE757, 0x851C}, //10544 #CJK UNIFIED IDEOGRAPH
    {0xE758, 0x84FB}, //10545 #CJK UNIFIED IDEOGRAPH
    {0xE759, 0x852B}, //10546 #CJK UNIFIED IDEOGRAPH
    {0xE75A, 0x84FA}, //10547 #CJK UNIFIED IDEOGRAPH
    {0xE75B, 0x8508}, //10548 #CJK UNIFIED IDEOGRAPH
    {0xE75C, 0x850C}, //10549 #CJK UNIFIED IDEOGRAPH
    {0xE75D, 0x84F4}, //10550 #CJK UNIFIED IDEOGRAPH
    {0xE75E, 0x852A}, //10551 #CJK UNIFIED IDEOGRAPH
    {0xE75F, 0x84F2}, //10552 #CJK UNIFIED IDEOGRAPH
    {0xE760, 0x8515}, //10553 #CJK UNIFIED IDEOGRAPH
    {0xE761, 0x84F7}, //10554 #CJK UNIFIED IDEOGRAPH
    {0xE762, 0x84EB}, //10555 #CJK UNIFIED IDEOGRAPH
    {0xE763, 0x84F3}, //10556 #CJK UNIFIED IDEOGRAPH
    {0xE764, 0x84FC}, //10557 #CJK UNIFIED IDEOGRAPH
    {0xE765, 0x8512}, //10558 #CJK UNIFIED IDEOGRAPH
    {0xE766, 0x84EA}, //10559 #CJK UNIFIED IDEOGRAPH
    {0xE767, 0x84E9}, //10560 #CJK UNIFIED IDEOGRAPH
    {0xE768, 0x8516}, //10561 #CJK UNIFIED IDEOGRAPH
    {0xE769, 0x84FE}, //10562 #CJK UNIFIED IDEOGRAPH
    {0xE76A, 0x8528}, //10563 #CJK UNIFIED IDEOGRAPH
    {0xE76B, 0x851D}, //10564 #CJK UNIFIED IDEOGRAPH
    {0xE76C, 0x852E}, //10565 #CJK UNIFIED IDEOGRAPH
    {0xE76D, 0x8502}, //10566 #CJK UNIFIED IDEOGRAPH
    {0xE76E, 0x84FD}, //10567 #CJK UNIFIED IDEOGRAPH
    {0xE76F, 0x851E}, //10568 #CJK UNIFIED IDEOGRAPH
    {0xE770, 0x84F6}, //10569 #CJK UNIFIED IDEOGRAPH
    {0xE771, 0x8531}, //10570 #CJK UNIFIED IDEOGRAPH
    {0xE772, 0x8526}, //10571 #CJK UNIFIED IDEOGRAPH
    {0xE773, 0x84E7}, //10572 #CJK UNIFIED IDEOGRAPH
    {0xE774, 0x84E8}, //10573 #CJK UNIFIED IDEOGRAPH
    {0xE775, 0x84F0}, //10574 #CJK UNIFIED IDEOGRAPH
    {0xE776, 0x84EF}, //10575 #CJK UNIFIED IDEOGRAPH
    {0xE777, 0x84F9}, //10576 #CJK UNIFIED IDEOGRAPH
    {0xE778, 0x8518}, //10577 #CJK UNIFIED IDEOGRAPH
    {0xE779, 0x8520}, //10578 #CJK UNIFIED IDEOGRAPH
    {0xE77A, 0x8530}, //10579 #CJK UNIFIED IDEOGRAPH
    {0xE77B, 0x850B}, //10580 #CJK UNIFIED IDEOGRAPH
    {0xE77C, 0x8519}, //10581 #CJK UNIFIED IDEOGRAPH
    {0xE77D, 0x852F}, //10582 #CJK UNIFIED IDEOGRAPH
    {0xE77E, 0x8662}, //10583 #CJK UNIFIED IDEOGRAPH
    {0xE7A1, 0x8756}, //10584 #CJK UNIFIED IDEOGRAPH
    {0xE7A2, 0x8763}, //10585 #CJK UNIFIED IDEOGRAPH
    {0xE7A3, 0x8764}, //10586 #CJK UNIFIED IDEOGRAPH
    {0xE7A4, 0x8777}, //10587 #CJK UNIFIED IDEOGRAPH
    {0xE7A5, 0x87E1}, //10588 #CJK UNIFIED IDEOGRAPH
    {0xE7A6, 0x8773}, //10589 #CJK UNIFIED IDEOGRAPH
    {0xE7A7, 0x8758}, //10590 #CJK UNIFIED IDEOGRAPH
    {0xE7A8, 0x8754}, //10591 #CJK UNIFIED IDEOGRAPH
    {0xE7A9, 0x875B}, //10592 #CJK UNIFIED IDEOGRAPH
    {0xE7AA, 0x8752}, //10593 #CJK UNIFIED IDEOGRAPH
    {0xE7AB, 0x8761}, //10594 #CJK UNIFIED IDEOGRAPH
    {0xE7AC, 0x875A}, //10595 #CJK UNIFIED IDEOGRAPH
    {0xE7AD, 0x8751}, //10596 #CJK UNIFIED IDEOGRAPH
    {0xE7AE, 0x875E}, //10597 #CJK UNIFIED IDEOGRAPH
    {0xE7AF, 0x876D}, //10598 #CJK UNIFIED IDEOGRAPH
    {0xE7B0, 0x876A}, //10599 #CJK UNIFIED IDEOGRAPH
    {0xE7B1, 0x8750}, //10600 #CJK UNIFIED IDEOGRAPH
    {0xE7B2, 0x874E}, //10601 #CJK UNIFIED IDEOGRAPH
    {0xE7B3, 0x875F}, //10602 #CJK UNIFIED IDEOGRAPH
    {0xE7B4, 0x875D}, //10603 #CJK UNIFIED IDEOGRAPH
    {0xE7B5, 0x876F}, //10604 #CJK UNIFIED IDEOGRAPH
    {0xE7B6, 0x876C}, //10605 #CJK UNIFIED IDEOGRAPH
    {0xE7B7, 0x877A}, //10606 #CJK UNIFIED IDEOGRAPH
    {0xE7B8, 0x876E}, //10607 #CJK UNIFIED IDEOGRAPH
    {0xE7B9, 0x875C}, //10608 #CJK UNIFIED IDEOGRAPH
    {0xE7BA, 0x8765}, //10609 #CJK UNIFIED IDEOGRAPH
    {0xE7BB, 0x874F}, //10610 #CJK UNIFIED IDEOGRAPH
    {0xE7BC, 0x877B}, //10611 #CJK UNIFIED IDEOGRAPH
    {0xE7BD, 0x8775}, //10612 #CJK UNIFIED IDEOGRAPH
    {0xE7BE, 0x8762}, //10613 #CJK UNIFIED IDEOGRAPH
    {0xE7BF, 0x8767}, //10614 #CJK UNIFIED IDEOGRAPH
    {0xE7C0, 0x8769}, //10615 #CJK UNIFIED IDEOGRAPH
    {0xE7C1, 0x885A}, //10616 #CJK UNIFIED IDEOGRAPH
    {0xE7C2, 0x8905}, //10617 #CJK UNIFIED IDEOGRAPH
    {0xE7C3, 0x890C}, //10618 #CJK UNIFIED IDEOGRAPH
    {0xE7C4, 0x8914}, //10619 #CJK UNIFIED IDEOGRAPH
    {0xE7C5, 0x890B}, //10620 #CJK UNIFIED IDEOGRAPH
    {0xE7C6, 0x8917}, //10621 #CJK UNIFIED IDEOGRAPH
    {0xE7C7, 0x8918}, //10622 #CJK UNIFIED IDEOGRAPH
    {0xE7C8, 0x8919}, //10623 #CJK UNIFIED IDEOGRAPH
    {0xE7C9, 0x8906}, //10624 #CJK UNIFIED IDEOGRAPH
    {0xE7CA, 0x8916}, //10625 #CJK UNIFIED IDEOGRAPH
    {0xE7CB, 0x8911}, //10626 #CJK UNIFIED IDEOGRAPH
    {0xE7CC, 0x890E}, //10627 #CJK UNIFIED IDEOGRAPH
    {0xE7CD, 0x8909}, //10628 #CJK UNIFIED IDEOGRAPH
    {0xE7CE, 0x89A2}, //10629 #CJK UNIFIED IDEOGRAPH
    {0xE7CF, 0x89A4}, //10630 #CJK UNIFIED IDEOGRAPH
    {0xE7D0, 0x89A3}, //10631 #CJK UNIFIED IDEOGRAPH
    {0xE7D1, 0x89ED}, //10632 #CJK UNIFIED IDEOGRAPH
    {0xE7D2, 0x89F0}, //10633 #CJK UNIFIED IDEOGRAPH
    {0xE7D3, 0x89EC}, //10634 #CJK UNIFIED IDEOGRAPH
    {0xE7D4, 0x8ACF}, //10635 #CJK UNIFIED IDEOGRAPH
    {0xE7D5, 0x8AC6}, //10636 #CJK UNIFIED IDEOGRAPH
    {0xE7D6, 0x8AB8}, //10637 #CJK UNIFIED IDEOGRAPH
    {0xE7D7, 0x8AD3}, //10638 #CJK UNIFIED IDEOGRAPH
    {0xE7D8, 0x8AD1}, //10639 #CJK UNIFIED IDEOGRAPH
    {0xE7D9, 0x8AD4}, //10640 #CJK UNIFIED IDEOGRAPH
    {0xE7DA, 0x8AD5}, //10641 #CJK UNIFIED IDEOGRAPH
    {0xE7DB, 0x8ABB}, //10642 #CJK UNIFIED IDEOGRAPH
    {0xE7DC, 0x8AD7}, //10643 #CJK UNIFIED IDEOGRAPH
    {0xE7DD, 0x8ABE}, //10644 #CJK UNIFIED IDEOGRAPH
    {0xE7DE, 0x8AC0}, //10645 #CJK UNIFIED IDEOGRAPH
    {0xE7DF, 0x8AC5}, //10646 #CJK UNIFIED IDEOGRAPH
    {0xE7E0, 0x8AD8}, //10647 #CJK UNIFIED IDEOGRAPH
    {0xE7E1, 0x8AC3}, //10648 #CJK UNIFIED IDEOGRAPH
    {0xE7E2, 0x8ABA}, //10649 #CJK UNIFIED IDEOGRAPH
    {0xE7E3, 0x8ABD}, //10650 #CJK UNIFIED IDEOGRAPH
    {0xE7E4, 0x8AD9}, //10651 #CJK UNIFIED IDEOGRAPH
    {0xE7E5, 0x8C3E}, //10652 #CJK UNIFIED IDEOGRAPH
    {0xE7E6, 0x8C4D}, //10653 #CJK UNIFIED IDEOGRAPH
    {0xE7E7, 0x8C8F}, //10654 #CJK UNIFIED IDEOGRAPH
    {0xE7E8, 0x8CE5}, //10655 #CJK UNIFIED IDEOGRAPH
    {0xE7E9, 0x8CDF}, //10656 #CJK UNIFIED IDEOGRAPH
    {0xE7EA, 0x8CD9}, //10657 #CJK UNIFIED IDEOGRAPH
    {0xE7EB, 0x8CE8}, //10658 #CJK UNIFIED IDEOGRAPH
    {0xE7EC, 0x8CDA}, //10659 #CJK UNIFIED IDEOGRAPH
    {0xE7ED, 0x8CDD}, //10660 #CJK UNIFIED IDEOGRAPH
    {0xE7EE, 0x8CE7}, //10661 #CJK UNIFIED IDEOGRAPH
    {0xE7EF, 0x8DA0}, //10662 #CJK UNIFIED IDEOGRAPH
    {0xE7F0, 0x8D9C}, //10663 #CJK UNIFIED IDEOGRAPH
    {0xE7F1, 0x8DA1}, //10664 #CJK UNIFIED IDEOGRAPH
    {0xE7F2, 0x8D9B}, //10665 #CJK UNIFIED IDEOGRAPH
    {0xE7F3, 0x8E20}, //10666 #CJK UNIFIED IDEOGRAPH
    {0xE7F4, 0x8E23}, //10667 #CJK UNIFIED IDEOGRAPH
    {0xE7F5, 0x8E25}, //10668 #CJK UNIFIED IDEOGRAPH
    {0xE7F6, 0x8E24}, //10669 #CJK UNIFIED IDEOGRAPH
    {0xE7F7, 0x8E2E}, //10670 #CJK UNIFIED IDEOGRAPH
    {0xE7F8, 0x8E15}, //10671 #CJK UNIFIED IDEOGRAPH
    {0xE7F9, 0x8E1B}, //10672 #CJK UNIFIED IDEOGRAPH
    {0xE7FA, 0x8E16}, //10673 #CJK UNIFIED IDEOGRAPH
    {0xE7FB, 0x8E11}, //10674 #CJK UNIFIED IDEOGRAPH
    {0xE7FC, 0x8E19}, //10675 #CJK UNIFIED IDEOGRAPH
    {0xE7FD, 0x8E26}, //10676 #CJK UNIFIED IDEOGRAPH
    {0xE7FE, 0x8E27}, //10677 #CJK UNIFIED IDEOGRAPH
    {0xE840, 0x8E14}, //10678 #CJK UNIFIED IDEOGRAPH
    {0xE841, 0x8E12}, //10679 #CJK UNIFIED IDEOGRAPH
    {0xE842, 0x8E18}, //10680 #CJK UNIFIED IDEOGRAPH
    {0xE843, 0x8E13}, //10681 #CJK UNIFIED IDEOGRAPH
    {0xE844, 0x8E1C}, //10682 #CJK UNIFIED IDEOGRAPH
    {0xE845, 0x8E17}, //10683 #CJK UNIFIED IDEOGRAPH
    {0xE846, 0x8E1A}, //10684 #CJK UNIFIED IDEOGRAPH
    {0xE847, 0x8F2C}, //10685 #CJK UNIFIED IDEOGRAPH
    {0xE848, 0x8F24}, //10686 #CJK UNIFIED IDEOGRAPH
    {0xE849, 0x8F18}, //10687 #CJK UNIFIED IDEOGRAPH
    {0xE84A, 0x8F1A}, //10688 #CJK UNIFIED IDEOGRAPH
    {0xE84B, 0x8F20}, //10689 #CJK UNIFIED IDEOGRAPH
    {0xE84C, 0x8F23}, //10690 #CJK UNIFIED IDEOGRAPH
    {0xE84D, 0x8F16}, //10691 #CJK UNIFIED IDEOGRAPH
    {0xE84E, 0x8F17}, //10692 #CJK UNIFIED IDEOGRAPH
    {0xE84F, 0x9073}, //10693 #CJK UNIFIED IDEOGRAPH
    {0xE850, 0x9070}, //10694 #CJK UNIFIED IDEOGRAPH
    {0xE851, 0x906F}, //10695 #CJK UNIFIED IDEOGRAPH
    {0xE852, 0x9067}, //10696 #CJK UNIFIED IDEOGRAPH
    {0xE853, 0x906B}, //10697 #CJK UNIFIED IDEOGRAPH
    {0xE854, 0x912F}, //10698 #CJK UNIFIED IDEOGRAPH
    {0xE855, 0x912B}, //10699 #CJK UNIFIED IDEOGRAPH
    {0xE856, 0x9129}, //10700 #CJK UNIFIED IDEOGRAPH
    {0xE857, 0x912A}, //10701 #CJK UNIFIED IDEOGRAPH
    {0xE858, 0x9132}, //10702 #CJK UNIFIED IDEOGRAPH
    {0xE859, 0x9126}, //10703 #CJK UNIFIED IDEOGRAPH
    {0xE85A, 0x912E}, //10704 #CJK UNIFIED IDEOGRAPH
    {0xE85B, 0x9185}, //10705 #CJK UNIFIED IDEOGRAPH
    {0xE85C, 0x9186}, //10706 #CJK UNIFIED IDEOGRAPH
    {0xE85D, 0x918A}, //10707 #CJK UNIFIED IDEOGRAPH
    {0xE85E, 0x9181}, //10708 #CJK UNIFIED IDEOGRAPH
    {0xE85F, 0x9182}, //10709 #CJK UNIFIED IDEOGRAPH
    {0xE860, 0x9184}, //10710 #CJK UNIFIED IDEOGRAPH
    {0xE861, 0x9180}, //10711 #CJK UNIFIED IDEOGRAPH
    {0xE862, 0x92D0}, //10712 #CJK UNIFIED IDEOGRAPH
    {0xE863, 0x92C3}, //10713 #CJK UNIFIED IDEOGRAPH
    {0xE864, 0x92C4}, //10714 #CJK UNIFIED IDEOGRAPH
    {0xE865, 0x92C0}, //10715 #CJK UNIFIED IDEOGRAPH
    {0xE866, 0x92D9}, //10716 #CJK UNIFIED IDEOGRAPH
    {0xE867, 0x92B6}, //10717 #CJK UNIFIED IDEOGRAPH
    {0xE868, 0x92CF}, //10718 #CJK UNIFIED IDEOGRAPH
    {0xE869, 0x92F1}, //10719 #CJK UNIFIED IDEOGRAPH
    {0xE86A, 0x92DF}, //10720 #CJK UNIFIED IDEOGRAPH
    {0xE86B, 0x92D8}, //10721 #CJK UNIFIED IDEOGRAPH
    {0xE86C, 0x92E9}, //10722 #CJK UNIFIED IDEOGRAPH
    {0xE86D, 0x92D7}, //10723 #CJK UNIFIED IDEOGRAPH
    {0xE86E, 0x92DD}, //10724 #CJK UNIFIED IDEOGRAPH
    {0xE86F, 0x92CC}, //10725 #CJK UNIFIED IDEOGRAPH
    {0xE870, 0x92EF}, //10726 #CJK UNIFIED IDEOGRAPH
    {0xE871, 0x92C2}, //10727 #CJK UNIFIED IDEOGRAPH
    {0xE872, 0x92E8}, //10728 #CJK UNIFIED IDEOGRAPH
    {0xE873, 0x92CA}, //10729 #CJK UNIFIED IDEOGRAPH
    {0xE874, 0x92C8}, //10730 #CJK UNIFIED IDEOGRAPH
    {0xE875, 0x92CE}, //10731 #CJK UNIFIED IDEOGRAPH
    {0xE876, 0x92E6}, //10732 #CJK UNIFIED IDEOGRAPH
    {0xE877, 0x92CD}, //10733 #CJK UNIFIED IDEOGRAPH
    {0xE878, 0x92D5}, //10734 #CJK UNIFIED IDEOGRAPH
    {0xE879, 0x92C9}, //10735 #CJK UNIFIED IDEOGRAPH
    {0xE87A, 0x92E0}, //10736 #CJK UNIFIED IDEOGRAPH
    {0xE87B, 0x92DE}, //10737 #CJK UNIFIED IDEOGRAPH
    {0xE87C, 0x92E7}, //10738 #CJK UNIFIED IDEOGRAPH
    {0xE87D, 0x92D1}, //10739 #CJK UNIFIED IDEOGRAPH
    {0xE87E, 0x92D3}, //10740 #CJK UNIFIED IDEOGRAPH
    {0xE8A1, 0x92B5}, //10741 #CJK UNIFIED IDEOGRAPH
    {0xE8A2, 0x92E1}, //10742 #CJK UNIFIED IDEOGRAPH
    {0xE8A3, 0x92C6}, //10743 #CJK UNIFIED IDEOGRAPH
    {0xE8A4, 0x92B4}, //10744 #CJK UNIFIED IDEOGRAPH
    {0xE8A5, 0x957C}, //10745 #CJK UNIFIED IDEOGRAPH
    {0xE8A6, 0x95AC}, //10746 #CJK UNIFIED IDEOGRAPH
    {0xE8A7, 0x95AB}, //10747 #CJK UNIFIED IDEOGRAPH
    {0xE8A8, 0x95AE}, //10748 #CJK UNIFIED IDEOGRAPH
    {0xE8A9, 0x95B0}, //10749 #CJK UNIFIED IDEOGRAPH
    {0xE8AA, 0x96A4}, //10750 #CJK UNIFIED IDEOGRAPH
    {0xE8AB, 0x96A2}, //10751 #CJK UNIFIED IDEOGRAPH
    {0xE8AC, 0x96D3}, //10752 #CJK UNIFIED IDEOGRAPH
    {0xE8AD, 0x9705}, //10753 #CJK UNIFIED IDEOGRAPH
    {0xE8AE, 0x9708}, //10754 #CJK UNIFIED IDEOGRAPH
    {0xE8AF, 0x9702}, //10755 #CJK UNIFIED IDEOGRAPH
    {0xE8B0, 0x975A}, //10756 #CJK UNIFIED IDEOGRAPH
    {0xE8B1, 0x978A}, //10757 #CJK UNIFIED IDEOGRAPH
    {0xE8B2, 0x978E}, //10758 #CJK UNIFIED IDEOGRAPH
    {0xE8B3, 0x9788}, //10759 #CJK UNIFIED IDEOGRAPH
    {0xE8B4, 0x97D0}, //10760 #CJK UNIFIED IDEOGRAPH
    {0xE8B5, 0x97CF}, //10761 #CJK UNIFIED IDEOGRAPH
    {0xE8B6, 0x981E}, //10762 #CJK UNIFIED IDEOGRAPH
    {0xE8B7, 0x981D}, //10763 #CJK UNIFIED IDEOGRAPH
    {0xE8B8, 0x9826}, //10764 #CJK UNIFIED IDEOGRAPH
    {0xE8B9, 0x9829}, //10765 #CJK UNIFIED IDEOGRAPH
    {0xE8BA, 0x9828}, //10766 #CJK UNIFIED IDEOGRAPH
    {0xE8BB, 0x9820}, //10767 #CJK UNIFIED IDEOGRAPH
    {0xE8BC, 0x981B}, //10768 #CJK UNIFIED IDEOGRAPH
    {0xE8BD, 0x9827}, //10769 #CJK UNIFIED IDEOGRAPH
    {0xE8BE, 0x98B2}, //10770 #CJK UNIFIED IDEOGRAPH
    {0xE8BF, 0x9908}, //10771 #CJK UNIFIED IDEOGRAPH
    {0xE8C0, 0x98FA}, //10772 #CJK UNIFIED IDEOGRAPH
    {0xE8C1, 0x9911}, //10773 #CJK UNIFIED IDEOGRAPH
    {0xE8C2, 0x9914}, //10774 #CJK UNIFIED IDEOGRAPH
    {0xE8C3, 0x9916}, //10775 #CJK UNIFIED IDEOGRAPH
    {0xE8C4, 0x9917}, //10776 #CJK UNIFIED IDEOGRAPH
    {0xE8C5, 0x9915}, //10777 #CJK UNIFIED IDEOGRAPH
    {0xE8C6, 0x99DC}, //10778 #CJK UNIFIED IDEOGRAPH
    {0xE8C7, 0x99CD}, //10779 #CJK UNIFIED IDEOGRAPH
    {0xE8C8, 0x99CF}, //10780 #CJK UNIFIED IDEOGRAPH
    {0xE8C9, 0x99D3}, //10781 #CJK UNIFIED IDEOGRAPH
    {0xE8CA, 0x99D4}, //10782 #CJK UNIFIED IDEOGRAPH
    {0xE8CB, 0x99CE}, //10783 #CJK UNIFIED IDEOGRAPH
    {0xE8CC, 0x99C9}, //10784 #CJK UNIFIED IDEOGRAPH
    {0xE8CD, 0x99D6}, //10785 #CJK UNIFIED IDEOGRAPH
    {0xE8CE, 0x99D8}, //10786 #CJK UNIFIED IDEOGRAPH
    {0xE8CF, 0x99CB}, //10787 #CJK UNIFIED IDEOGRAPH
    {0xE8D0, 0x99D7}, //10788 #CJK UNIFIED IDEOGRAPH
    {0xE8D1, 0x99CC}, //10789 #CJK UNIFIED IDEOGRAPH
    {0xE8D2, 0x9AB3}, //10790 #CJK UNIFIED IDEOGRAPH
    {0xE8D3, 0x9AEC}, //10791 #CJK UNIFIED IDEOGRAPH
    {0xE8D4, 0x9AEB}, //10792 #CJK UNIFIED IDEOGRAPH
    {0xE8D5, 0x9AF3}, //10793 #CJK UNIFIED IDEOGRAPH
    {0xE8D6, 0x9AF2}, //10794 #CJK UNIFIED IDEOGRAPH
    {0xE8D7, 0x9AF1}, //10795 #CJK UNIFIED IDEOGRAPH
    {0xE8D8, 0x9B46}, //10796 #CJK UNIFIED IDEOGRAPH
    {0xE8D9, 0x9B43}, //10797 #CJK UNIFIED IDEOGRAPH
    {0xE8DA, 0x9B67}, //10798 #CJK UNIFIED IDEOGRAPH
    {0xE8DB, 0x9B74}, //10799 #CJK UNIFIED IDEOGRAPH
    {0xE8DC, 0x9B71}, //10800 #CJK UNIFIED IDEOGRAPH
    {0xE8DD, 0x9B66}, //10801 #CJK UNIFIED IDEOGRAPH
    {0xE8DE, 0x9B76}, //10802 #CJK UNIFIED IDEOGRAPH
    {0xE8DF, 0x9B75}, //10803 #CJK UNIFIED IDEOGRAPH
    {0xE8E0, 0x9B70}, //10804 #CJK UNIFIED IDEOGRAPH
    {0xE8E1, 0x9B68}, //10805 #CJK UNIFIED IDEOGRAPH
    {0xE8E2, 0x9B64}, //10806 #CJK UNIFIED IDEOGRAPH
    {0xE8E3, 0x9B6C}, //10807 #CJK UNIFIED IDEOGRAPH
    {0xE8E4, 0x9CFC}, //10808 #CJK UNIFIED IDEOGRAPH
    {0xE8E5, 0x9CFA}, //10809 #CJK UNIFIED IDEOGRAPH
    {0xE8E6, 0x9CFD}, //10810 #CJK UNIFIED IDEOGRAPH
    {0xE8E7, 0x9CFF}, //10811 #CJK UNIFIED IDEOGRAPH
    {0xE8E8, 0x9CF7}, //10812 #CJK UNIFIED IDEOGRAPH
    {0xE8E9, 0x9D07}, //10813 #CJK UNIFIED IDEOGRAPH
    {0xE8EA, 0x9D00}, //10814 #CJK UNIFIED IDEOGRAPH
    {0xE8EB, 0x9CF9}, //10815 #CJK UNIFIED IDEOGRAPH
    {0xE8EC, 0x9CFB}, //10816 #CJK UNIFIED IDEOGRAPH
    {0xE8ED, 0x9D08}, //10817 #CJK UNIFIED IDEOGRAPH
    {0xE8EE, 0x9D05}, //10818 #CJK UNIFIED IDEOGRAPH
    {0xE8EF, 0x9D04}, //10819 #CJK UNIFIED IDEOGRAPH
    {0xE8F0, 0x9E83}, //10820 #CJK UNIFIED IDEOGRAPH
    {0xE8F1, 0x9ED3}, //10821 #CJK UNIFIED IDEOGRAPH
    {0xE8F2, 0x9F0F}, //10822 #CJK UNIFIED IDEOGRAPH
    {0xE8F3, 0x9F10}, //10823 #CJK UNIFIED IDEOGRAPH
    {0xE8F4, 0x511C}, //10824 #CJK UNIFIED IDEOGRAPH
    {0xE8F5, 0x5113}, //10825 #CJK UNIFIED IDEOGRAPH
    {0xE8F6, 0x5117}, //10826 #CJK UNIFIED IDEOGRAPH
    {0xE8F7, 0x511A}, //10827 #CJK UNIFIED IDEOGRAPH
    {0xE8F8, 0x5111}, //10828 #CJK UNIFIED IDEOGRAPH
    {0xE8F9, 0x51DE}, //10829 #CJK UNIFIED IDEOGRAPH
    {0xE8FA, 0x5334}, //10830 #CJK UNIFIED IDEOGRAPH
    {0xE8FB, 0x53E1}, //10831 #CJK UNIFIED IDEOGRAPH
    {0xE8FC, 0x5670}, //10832 #CJK UNIFIED IDEOGRAPH
    {0xE8FD, 0x5660}, //10833 #CJK UNIFIED IDEOGRAPH
    {0xE8FE, 0x566E}, //10834 #CJK UNIFIED IDEOGRAPH
    {0xE940, 0x5673}, //10835 #CJK UNIFIED IDEOGRAPH
    {0xE941, 0x5666}, //10836 #CJK UNIFIED IDEOGRAPH
    {0xE942, 0x5663}, //10837 #CJK UNIFIED IDEOGRAPH
    {0xE943, 0x566D}, //10838 #CJK UNIFIED IDEOGRAPH
    {0xE944, 0x5672}, //10839 #CJK UNIFIED IDEOGRAPH
    {0xE945, 0x565E}, //10840 #CJK UNIFIED IDEOGRAPH
    {0xE946, 0x5677}, //10841 #CJK UNIFIED IDEOGRAPH
    {0xE947, 0x571C}, //10842 #CJK UNIFIED IDEOGRAPH
    {0xE948, 0x571B}, //10843 #CJK UNIFIED IDEOGRAPH
    {0xE949, 0x58C8}, //10844 #CJK UNIFIED IDEOGRAPH
    {0xE94A, 0x58BD}, //10845 #CJK UNIFIED IDEOGRAPH
    {0xE94B, 0x58C9}, //10846 #CJK UNIFIED IDEOGRAPH
    {0xE94C, 0x58BF}, //10847 #CJK UNIFIED IDEOGRAPH
    {0xE94D, 0x58BA}, //10848 #CJK UNIFIED IDEOGRAPH
    {0xE94E, 0x58C2}, //10849 #CJK UNIFIED IDEOGRAPH
    {0xE94F, 0x58BC}, //10850 #CJK UNIFIED IDEOGRAPH
    {0xE950, 0x58C6}, //10851 #CJK UNIFIED IDEOGRAPH
    {0xE951, 0x5B17}, //10852 #CJK UNIFIED IDEOGRAPH
    {0xE952, 0x5B19}, //10853 #CJK UNIFIED IDEOGRAPH
    {0xE953, 0x5B1B}, //10854 #CJK UNIFIED IDEOGRAPH
    {0xE954, 0x5B21}, //10855 #CJK UNIFIED IDEOGRAPH
    {0xE955, 0x5B14}, //10856 #CJK UNIFIED IDEOGRAPH
    {0xE956, 0x5B13}, //10857 #CJK UNIFIED IDEOGRAPH
    {0xE957, 0x5B10}, //10858 #CJK UNIFIED IDEOGRAPH
    {0xE958, 0x5B16}, //10859 #CJK UNIFIED IDEOGRAPH
    {0xE959, 0x5B28}, //10860 #CJK UNIFIED IDEOGRAPH
    {0xE95A, 0x5B1A}, //10861 #CJK UNIFIED IDEOGRAPH
    {0xE95B, 0x5B20}, //10862 #CJK UNIFIED IDEOGRAPH
    {0xE95C, 0x5B1E}, //10863 #CJK UNIFIED IDEOGRAPH
    {0xE95D, 0x5BEF}, //10864 #CJK UNIFIED IDEOGRAPH
    {0xE95E, 0x5DAC}, //10865 #CJK UNIFIED IDEOGRAPH
    {0xE95F, 0x5DB1}, //10866 #CJK UNIFIED IDEOGRAPH
    {0xE960, 0x5DA9}, //10867 #CJK UNIFIED IDEOGRAPH
    {0xE961, 0x5DA7}, //10868 #CJK UNIFIED IDEOGRAPH
    {0xE962, 0x5DB5}, //10869 #CJK UNIFIED IDEOGRAPH
    {0xE963, 0x5DB0}, //10870 #CJK UNIFIED IDEOGRAPH
    {0xE964, 0x5DAE}, //10871 #CJK UNIFIED IDEOGRAPH
    {0xE965, 0x5DAA}, //10872 #CJK UNIFIED IDEOGRAPH
    {0xE966, 0x5DA8}, //10873 #CJK UNIFIED IDEOGRAPH
    {0xE967, 0x5DB2}, //10874 #CJK UNIFIED IDEOGRAPH
    {0xE968, 0x5DAD}, //10875 #CJK UNIFIED IDEOGRAPH
    {0xE969, 0x5DAF}, //10876 #CJK UNIFIED IDEOGRAPH
    {0xE96A, 0x5DB4}, //10877 #CJK UNIFIED IDEOGRAPH
    {0xE96B, 0x5E67}, //10878 #CJK UNIFIED IDEOGRAPH
    {0xE96C, 0x5E68}, //10879 #CJK UNIFIED IDEOGRAPH
    {0xE96D, 0x5E66}, //10880 #CJK UNIFIED IDEOGRAPH
    {0xE96E, 0x5E6F}, //10881 #CJK UNIFIED IDEOGRAPH
    {0xE96F, 0x5EE9}, //10882 #CJK UNIFIED IDEOGRAPH
    {0xE970, 0x5EE7}, //10883 #CJK UNIFIED IDEOGRAPH
    {0xE971, 0x5EE6}, //10884 #CJK UNIFIED IDEOGRAPH
    {0xE972, 0x5EE8}, //10885 #CJK UNIFIED IDEOGRAPH
    {0xE973, 0x5EE5}, //10886 #CJK UNIFIED IDEOGRAPH
    {0xE974, 0x5F4B}, //10887 #CJK UNIFIED IDEOGRAPH
    {0xE975, 0x5FBC}, //10888 #CJK UNIFIED IDEOGRAPH
    {0xE976, 0x619D}, //10889 #CJK UNIFIED IDEOGRAPH
    {0xE977, 0x61A8}, //10890 #CJK UNIFIED IDEOGRAPH
    {0xE978, 0x6196}, //10891 #CJK UNIFIED IDEOGRAPH
    {0xE979, 0x61C5}, //10892 #CJK UNIFIED IDEOGRAPH
    {0xE97A, 0x61B4}, //10893 #CJK UNIFIED IDEOGRAPH
    {0xE97B, 0x61C6}, //10894 #CJK UNIFIED IDEOGRAPH
    {0xE97C, 0x61C1}, //10895 #CJK UNIFIED IDEOGRAPH
    {0xE97D, 0x61CC}, //10896 #CJK UNIFIED IDEOGRAPH
    {0xE97E, 0x61BA}, //10897 #CJK UNIFIED IDEOGRAPH
    {0xE9A1, 0x61BF}, //10898 #CJK UNIFIED IDEOGRAPH
    {0xE9A2, 0x61B8}, //10899 #CJK UNIFIED IDEOGRAPH
    {0xE9A3, 0x618C}, //10900 #CJK UNIFIED IDEOGRAPH
    {0xE9A4, 0x64D7}, //10901 #CJK UNIFIED IDEOGRAPH
    {0xE9A5, 0x64D6}, //10902 #CJK UNIFIED IDEOGRAPH
    {0xE9A6, 0x64D0}, //10903 #CJK UNIFIED IDEOGRAPH
    {0xE9A7, 0x64CF}, //10904 #CJK UNIFIED IDEOGRAPH
    {0xE9A8, 0x64C9}, //10905 #CJK UNIFIED IDEOGRAPH
    {0xE9A9, 0x64BD}, //10906 #CJK UNIFIED IDEOGRAPH
    {0xE9AA, 0x6489}, //10907 #CJK UNIFIED IDEOGRAPH
    {0xE9AB, 0x64C3}, //10908 #CJK UNIFIED IDEOGRAPH
    {0xE9AC, 0x64DB}, //10909 #CJK UNIFIED IDEOGRAPH
    {0xE9AD, 0x64F3}, //10910 #CJK UNIFIED IDEOGRAPH
    {0xE9AE, 0x64D9}, //10911 #CJK UNIFIED IDEOGRAPH
    {0xE9AF, 0x6533}, //10912 #CJK UNIFIED IDEOGRAPH
    {0xE9B0, 0x657F}, //10913 #CJK UNIFIED IDEOGRAPH
    {0xE9B1, 0x657C}, //10914 #CJK UNIFIED IDEOGRAPH
    {0xE9B2, 0x65A2}, //10915 #CJK UNIFIED IDEOGRAPH
    {0xE9B3, 0x66C8}, //10916 #CJK UNIFIED IDEOGRAPH
    {0xE9B4, 0x66BE}, //10917 #CJK UNIFIED IDEOGRAPH
    {0xE9B5, 0x66C0}, //10918 #CJK UNIFIED IDEOGRAPH
    {0xE9B6, 0x66CA}, //10919 #CJK UNIFIED IDEOGRAPH
    {0xE9B7, 0x66CB}, //10920 #CJK UNIFIED IDEOGRAPH
    {0xE9B8, 0x66CF}, //10921 #CJK UNIFIED IDEOGRAPH
    {0xE9B9, 0x66BD}, //10922 #CJK UNIFIED IDEOGRAPH
    {0xE9BA, 0x66BB}, //10923 #CJK UNIFIED IDEOGRAPH
    {0xE9BB, 0x66BA}, //10924 #CJK UNIFIED IDEOGRAPH
    {0xE9BC, 0x66CC}, //10925 #CJK UNIFIED IDEOGRAPH
    {0xE9BD, 0x6723}, //10926 #CJK UNIFIED IDEOGRAPH
    {0xE9BE, 0x6A34}, //10927 #CJK UNIFIED IDEOGRAPH
    {0xE9BF, 0x6A66}, //10928 #CJK UNIFIED IDEOGRAPH
    {0xE9C0, 0x6A49}, //10929 #CJK UNIFIED IDEOGRAPH
    {0xE9C1, 0x6A67}, //10930 #CJK UNIFIED IDEOGRAPH
    {0xE9C2, 0x6A32}, //10931 #CJK UNIFIED IDEOGRAPH
    {0xE9C3, 0x6A68}, //10932 #CJK UNIFIED IDEOGRAPH
    {0xE9C4, 0x6A3E}, //10933 #CJK UNIFIED IDEOGRAPH
    {0xE9C5, 0x6A5D}, //10934 #CJK UNIFIED IDEOGRAPH
    {0xE9C6, 0x6A6D}, //10935 #CJK UNIFIED IDEOGRAPH
    {0xE9C7, 0x6A76}, //10936 #CJK UNIFIED IDEOGRAPH
    {0xE9C8, 0x6A5B}, //10937 #CJK UNIFIED IDEOGRAPH
    {0xE9C9, 0x6A51}, //10938 #CJK UNIFIED IDEOGRAPH
    {0xE9CA, 0x6A28}, //10939 #CJK UNIFIED IDEOGRAPH
    {0xE9CB, 0x6A5A}, //10940 #CJK UNIFIED IDEOGRAPH
    {0xE9CC, 0x6A3B}, //10941 #CJK UNIFIED IDEOGRAPH
    {0xE9CD, 0x6A3F}, //10942 #CJK UNIFIED IDEOGRAPH
    {0xE9CE, 0x6A41}, //10943 #CJK UNIFIED IDEOGRAPH
    {0xE9CF, 0x6A6A}, //10944 #CJK UNIFIED IDEOGRAPH
    {0xE9D0, 0x6A64}, //10945 #CJK UNIFIED IDEOGRAPH
    {0xE9D1, 0x6A50}, //10946 #CJK UNIFIED IDEOGRAPH
    {0xE9D2, 0x6A4F}, //10947 #CJK UNIFIED IDEOGRAPH
    {0xE9D3, 0x6A54}, //10948 #CJK UNIFIED IDEOGRAPH
    {0xE9D4, 0x6A6F}, //10949 #CJK UNIFIED IDEOGRAPH
    {0xE9D5, 0x6A69}, //10950 #CJK UNIFIED IDEOGRAPH
    {0xE9D6, 0x6A60}, //10951 #CJK UNIFIED IDEOGRAPH
    {0xE9D7, 0x6A3C}, //10952 #CJK UNIFIED IDEOGRAPH
    {0xE9D8, 0x6A5E}, //10953 #CJK UNIFIED IDEOGRAPH
    {0xE9D9, 0x6A56}, //10954 #CJK UNIFIED IDEOGRAPH
    {0xE9DA, 0x6A55}, //10955 #CJK UNIFIED IDEOGRAPH
    {0xE9DB, 0x6A4D}, //10956 #CJK UNIFIED IDEOGRAPH
    {0xE9DC, 0x6A4E}, //10957 #CJK UNIFIED IDEOGRAPH
    {0xE9DD, 0x6A46}, //10958 #CJK UNIFIED IDEOGRAPH
    {0xE9DE, 0x6B55}, //10959 #CJK UNIFIED IDEOGRAPH
    {0xE9DF, 0x6B54}, //10960 #CJK UNIFIED IDEOGRAPH
    {0xE9E0, 0x6B56}, //10961 #CJK UNIFIED IDEOGRAPH
    {0xE9E1, 0x6BA7}, //10962 #CJK UNIFIED IDEOGRAPH
    {0xE9E2, 0x6BAA}, //10963 #CJK UNIFIED IDEOGRAPH
    {0xE9E3, 0x6BAB}, //10964 #CJK UNIFIED IDEOGRAPH
    {0xE9E4, 0x6BC8}, //10965 #CJK UNIFIED IDEOGRAPH
    {0xE9E5, 0x6BC7}, //10966 #CJK UNIFIED IDEOGRAPH
    {0xE9E6, 0x6C04}, //10967 #CJK UNIFIED IDEOGRAPH
    {0xE9E7, 0x6C03}, //10968 #CJK UNIFIED IDEOGRAPH
    {0xE9E8, 0x6C06}, //10969 #CJK UNIFIED IDEOGRAPH
    {0xE9E9, 0x6FAD}, //10970 #CJK UNIFIED IDEOGRAPH
    {0xE9EA, 0x6FCB}, //10971 #CJK UNIFIED IDEOGRAPH
    {0xE9EB, 0x6FA3}, //10972 #CJK UNIFIED IDEOGRAPH
    {0xE9EC, 0x6FC7}, //10973 #CJK UNIFIED IDEOGRAPH
    {0xE9ED, 0x6FBC}, //10974 #CJK UNIFIED IDEOGRAPH
    {0xE9EE, 0x6FCE}, //10975 #CJK UNIFIED IDEOGRAPH
    {0xE9EF, 0x6FC8}, //10976 #CJK UNIFIED IDEOGRAPH
    {0xE9F0, 0x6F5E}, //10977 #CJK UNIFIED IDEOGRAPH
    {0xE9F1, 0x6FC4}, //10978 #CJK UNIFIED IDEOGRAPH
    {0xE9F2, 0x6FBD}, //10979 #CJK UNIFIED IDEOGRAPH
    {0xE9F3, 0x6F9E}, //10980 #CJK UNIFIED IDEOGRAPH
    {0xE9F4, 0x6FCA}, //10981 #CJK UNIFIED IDEOGRAPH
    {0xE9F5, 0x6FA8}, //10982 #CJK UNIFIED IDEOGRAPH
    {0xE9F6, 0x7004}, //10983 #CJK UNIFIED IDEOGRAPH
    {0xE9F7, 0x6FA5}, //10984 #CJK UNIFIED IDEOGRAPH
    {0xE9F8, 0x6FAE}, //10985 #CJK UNIFIED IDEOGRAPH
    {0xE9F9, 0x6FBA}, //10986 #CJK UNIFIED IDEOGRAPH
    {0xE9FA, 0x6FAC}, //10987 #CJK UNIFIED IDEOGRAPH
    {0xE9FB, 0x6FAA}, //10988 #CJK UNIFIED IDEOGRAPH
    {0xE9FC, 0x6FCF}, //10989 #CJK UNIFIED IDEOGRAPH
    {0xE9FD, 0x6FBF}, //10990 #CJK UNIFIED IDEOGRAPH
    {0xE9FE, 0x6FB8}, //10991 #CJK UNIFIED IDEOGRAPH
    {0xEA40, 0x6FA2}, //10992 #CJK UNIFIED IDEOGRAPH
    {0xEA41, 0x6FC9}, //10993 #CJK UNIFIED IDEOGRAPH
    {0xEA42, 0x6FAB}, //10994 #CJK UNIFIED IDEOGRAPH
    {0xEA43, 0x6FCD}, //10995 #CJK UNIFIED IDEOGRAPH
    {0xEA44, 0x6FAF}, //10996 #CJK UNIFIED IDEOGRAPH
    {0xEA45, 0x6FB2}, //10997 #CJK UNIFIED IDEOGRAPH
    {0xEA46, 0x6FB0}, //10998 #CJK UNIFIED IDEOGRAPH
    {0xEA47, 0x71C5}, //10999 #CJK UNIFIED IDEOGRAPH
    {0xEA48, 0x71C2}, //11000 #CJK UNIFIED IDEOGRAPH
    {0xEA49, 0x71BF}, //11001 #CJK UNIFIED IDEOGRAPH
    {0xEA4A, 0x71B8}, //11002 #CJK UNIFIED IDEOGRAPH
    {0xEA4B, 0x71D6}, //11003 #CJK UNIFIED IDEOGRAPH
    {0xEA4C, 0x71C0}, //11004 #CJK UNIFIED IDEOGRAPH
    {0xEA4D, 0x71C1}, //11005 #CJK UNIFIED IDEOGRAPH
    {0xEA4E, 0x71CB}, //11006 #CJK UNIFIED IDEOGRAPH
    {0xEA4F, 0x71D4}, //11007 #CJK UNIFIED IDEOGRAPH
    {0xEA50, 0x71CA}, //11008 #CJK UNIFIED IDEOGRAPH
    {0xEA51, 0x71C7}, //11009 #CJK UNIFIED IDEOGRAPH
    {0xEA52, 0x71CF}, //11010 #CJK UNIFIED IDEOGRAPH
    {0xEA53, 0x71BD}, //11011 #CJK UNIFIED IDEOGRAPH
    {0xEA54, 0x71D8}, //11012 #CJK UNIFIED IDEOGRAPH
    {0xEA55, 0x71BC}, //11013 #CJK UNIFIED IDEOGRAPH
    {0xEA56, 0x71C6}, //11014 #CJK UNIFIED IDEOGRAPH
    {0xEA57, 0x71DA}, //11015 #CJK UNIFIED IDEOGRAPH
    {0xEA58, 0x71DB}, //11016 #CJK UNIFIED IDEOGRAPH
    {0xEA59, 0x729D}, //11017 #CJK UNIFIED IDEOGRAPH
    {0xEA5A, 0x729E}, //11018 #CJK UNIFIED IDEOGRAPH
    {0xEA5B, 0x7369}, //11019 #CJK UNIFIED IDEOGRAPH
    {0xEA5C, 0x7366}, //11020 #CJK UNIFIED IDEOGRAPH
    {0xEA5D, 0x7367}, //11021 #CJK UNIFIED IDEOGRAPH
    {0xEA5E, 0x736C}, //11022 #CJK UNIFIED IDEOGRAPH
    {0xEA5F, 0x7365}, //11023 #CJK UNIFIED IDEOGRAPH
    {0xEA60, 0x736B}, //11024 #CJK UNIFIED IDEOGRAPH
    {0xEA61, 0x736A}, //11025 #CJK UNIFIED IDEOGRAPH
    {0xEA62, 0x747F}, //11026 #CJK UNIFIED IDEOGRAPH
    {0xEA63, 0x749A}, //11027 #CJK UNIFIED IDEOGRAPH
    {0xEA64, 0x74A0}, //11028 #CJK UNIFIED IDEOGRAPH
    {0xEA65, 0x7494}, //11029 #CJK UNIFIED IDEOGRAPH
    {0xEA66, 0x7492}, //11030 #CJK UNIFIED IDEOGRAPH
    {0xEA67, 0x7495}, //11031 #CJK UNIFIED IDEOGRAPH
    {0xEA68, 0x74A1}, //11032 #CJK UNIFIED IDEOGRAPH
    {0xEA69, 0x750B}, //11033 #CJK UNIFIED IDEOGRAPH
    {0xEA6A, 0x7580}, //11034 #CJK UNIFIED IDEOGRAPH
    {0xEA6B, 0x762F}, //11035 #CJK UNIFIED IDEOGRAPH
    {0xEA6C, 0x762D}, //11036 #CJK UNIFIED IDEOGRAPH
    {0xEA6D, 0x7631}, //11037 #CJK UNIFIED IDEOGRAPH
    {0xEA6E, 0x763D}, //11038 #CJK UNIFIED IDEOGRAPH
    {0xEA6F, 0x7633}, //11039 #CJK UNIFIED IDEOGRAPH
    {0xEA70, 0x763C}, //11040 #CJK UNIFIED IDEOGRAPH
    {0xEA71, 0x7635}, //11041 #CJK UNIFIED IDEOGRAPH
    {0xEA72, 0x7632}, //11042 #CJK UNIFIED IDEOGRAPH
    {0xEA73, 0x7630}, //11043 #CJK UNIFIED IDEOGRAPH
    {0xEA74, 0x76BB}, //11044 #CJK UNIFIED IDEOGRAPH
    {0xEA75, 0x76E6}, //11045 #CJK UNIFIED IDEOGRAPH
    {0xEA76, 0x779A}, //11046 #CJK UNIFIED IDEOGRAPH
    {0xEA77, 0x779D}, //11047 #CJK UNIFIED IDEOGRAPH
    {0xEA78, 0x77A1}, //11048 #CJK UNIFIED IDEOGRAPH
    {0xEA79, 0x779C}, //11049 #CJK UNIFIED IDEOGRAPH
    {0xEA7A, 0x779B}, //11050 #CJK UNIFIED IDEOGRAPH
    {0xEA7B, 0x77A2}, //11051 #CJK UNIFIED IDEOGRAPH
    {0xEA7C, 0x77A3}, //11052 #CJK UNIFIED IDEOGRAPH
    {0xEA7D, 0x7795}, //11053 #CJK UNIFIED IDEOGRAPH
    {0xEA7E, 0x7799}, //11054 #CJK UNIFIED IDEOGRAPH
    {0xEAA1, 0x7797}, //11055 #CJK UNIFIED IDEOGRAPH
    {0xEAA2, 0x78DD}, //11056 #CJK UNIFIED IDEOGRAPH
    {0xEAA3, 0x78E9}, //11057 #CJK UNIFIED IDEOGRAPH
    {0xEAA4, 0x78E5}, //11058 #CJK UNIFIED IDEOGRAPH
    {0xEAA5, 0x78EA}, //11059 #CJK UNIFIED IDEOGRAPH
    {0xEAA6, 0x78DE}, //11060 #CJK UNIFIED IDEOGRAPH
    {0xEAA7, 0x78E3}, //11061 #CJK UNIFIED IDEOGRAPH
    {0xEAA8, 0x78DB}, //11062 #CJK UNIFIED IDEOGRAPH
    {0xEAA9, 0x78E1}, //11063 #CJK UNIFIED IDEOGRAPH
    {0xEAAA, 0x78E2}, //11064 #CJK UNIFIED IDEOGRAPH
    {0xEAAB, 0x78ED}, //11065 #CJK UNIFIED IDEOGRAPH
    {0xEAAC, 0x78DF}, //11066 #CJK UNIFIED IDEOGRAPH
    {0xEAAD, 0x78E0}, //11067 #CJK UNIFIED IDEOGRAPH
    {0xEAAE, 0x79A4}, //11068 #CJK UNIFIED IDEOGRAPH
    {0xEAAF, 0x7A44}, //11069 #CJK UNIFIED IDEOGRAPH
    {0xEAB0, 0x7A48}, //11070 #CJK UNIFIED IDEOGRAPH
    {0xEAB1, 0x7A47}, //11071 #CJK UNIFIED IDEOGRAPH
    {0xEAB2, 0x7AB6}, //11072 #CJK UNIFIED IDEOGRAPH
    {0xEAB3, 0x7AB8}, //11073 #CJK UNIFIED IDEOGRAPH
    {0xEAB4, 0x7AB5}, //11074 #CJK UNIFIED IDEOGRAPH
    {0xEAB5, 0x7AB1}, //11075 #CJK UNIFIED IDEOGRAPH
    {0xEAB6, 0x7AB7}, //11076 #CJK UNIFIED IDEOGRAPH
    {0xEAB7, 0x7BDE}, //11077 #CJK UNIFIED IDEOGRAPH
    {0xEAB8, 0x7BE3}, //11078 #CJK UNIFIED IDEOGRAPH
    {0xEAB9, 0x7BE7}, //11079 #CJK UNIFIED IDEOGRAPH
    {0xEABA, 0x7BDD}, //11080 #CJK UNIFIED IDEOGRAPH
    {0xEABB, 0x7BD5}, //11081 #CJK UNIFIED IDEOGRAPH
    {0xEABC, 0x7BE5}, //11082 #CJK UNIFIED IDEOGRAPH
    {0xEABD, 0x7BDA}, //11083 #CJK UNIFIED IDEOGRAPH
    {0xEABE, 0x7BE8}, //11084 #CJK UNIFIED IDEOGRAPH
    {0xEABF, 0x7BF9}, //11085 #CJK UNIFIED IDEOGRAPH
    {0xEAC0, 0x7BD4}, //11086 #CJK UNIFIED IDEOGRAPH
    {0xEAC1, 0x7BEA}, //11087 #CJK UNIFIED IDEOGRAPH
    {0xEAC2, 0x7BE2}, //11088 #CJK UNIFIED IDEOGRAPH
    {0xEAC3, 0x7BDC}, //11089 #CJK UNIFIED IDEOGRAPH
    {0xEAC4, 0x7BEB}, //11090 #CJK UNIFIED IDEOGRAPH
    {0xEAC5, 0x7BD8}, //11091 #CJK UNIFIED IDEOGRAPH
    {0xEAC6, 0x7BDF}, //11092 #CJK UNIFIED IDEOGRAPH
    {0xEAC7, 0x7CD2}, //11093 #CJK UNIFIED IDEOGRAPH
    {0xEAC8, 0x7CD4}, //11094 #CJK UNIFIED IDEOGRAPH
    {0xEAC9, 0x7CD7}, //11095 #CJK UNIFIED IDEOGRAPH
    {0xEACA, 0x7CD0}, //11096 #CJK UNIFIED IDEOGRAPH
    {0xEACB, 0x7CD1}, //11097 #CJK UNIFIED IDEOGRAPH
    {0xEACC, 0x7E12}, //11098 #CJK UNIFIED IDEOGRAPH
    {0xEACD, 0x7E21}, //11099 #CJK UNIFIED IDEOGRAPH
    {0xEACE, 0x7E17}, //11100 #CJK UNIFIED IDEOGRAPH
    {0xEACF, 0x7E0C}, //11101 #CJK UNIFIED IDEOGRAPH
    {0xEAD0, 0x7E1F}, //11102 #CJK UNIFIED IDEOGRAPH
    {0xEAD1, 0x7E20}, //11103 #CJK UNIFIED IDEOGRAPH
    {0xEAD2, 0x7E13}, //11104 #CJK UNIFIED IDEOGRAPH
    {0xEAD3, 0x7E0E}, //11105 #CJK UNIFIED IDEOGRAPH
    {0xEAD4, 0x7E1C}, //11106 #CJK UNIFIED IDEOGRAPH
    {0xEAD5, 0x7E15}, //11107 #CJK UNIFIED IDEOGRAPH
    {0xEAD6, 0x7E1A}, //11108 #CJK UNIFIED IDEOGRAPH
    {0xEAD7, 0x7E22}, //11109 #CJK UNIFIED IDEOGRAPH
    {0xEAD8, 0x7E0B}, //11110 #CJK UNIFIED IDEOGRAPH
    {0xEAD9, 0x7E0F}, //11111 #CJK UNIFIED IDEOGRAPH
    {0xEADA, 0x7E16}, //11112 #CJK UNIFIED IDEOGRAPH
    {0xEADB, 0x7E0D}, //11113 #CJK UNIFIED IDEOGRAPH
    {0xEADC, 0x7E14}, //11114 #CJK UNIFIED IDEOGRAPH
    {0xEADD, 0x7E25}, //11115 #CJK UNIFIED IDEOGRAPH
    {0xEADE, 0x7E24}, //11116 #CJK UNIFIED IDEOGRAPH
    {0xEADF, 0x7F43}, //11117 #CJK UNIFIED IDEOGRAPH
    {0xEAE0, 0x7F7B}, //11118 #CJK UNIFIED IDEOGRAPH
    {0xEAE1, 0x7F7C}, //11119 #CJK UNIFIED IDEOGRAPH
    {0xEAE2, 0x7F7A}, //11120 #CJK UNIFIED IDEOGRAPH
    {0xEAE3, 0x7FB1}, //11121 #CJK UNIFIED IDEOGRAPH
    {0xEAE4, 0x7FEF}, //11122 #CJK UNIFIED IDEOGRAPH
    {0xEAE5, 0x802A}, //11123 #CJK UNIFIED IDEOGRAPH
    {0xEAE6, 0x8029}, //11124 #CJK UNIFIED IDEOGRAPH
    {0xEAE7, 0x806C}, //11125 #CJK UNIFIED IDEOGRAPH
    {0xEAE8, 0x81B1}, //11126 #CJK UNIFIED IDEOGRAPH
    {0xEAE9, 0x81A6}, //11127 #CJK UNIFIED IDEOGRAPH
    {0xEAEA, 0x81AE}, //11128 #CJK UNIFIED IDEOGRAPH
    {0xEAEB, 0x81B9}, //11129 #CJK UNIFIED IDEOGRAPH
    {0xEAEC, 0x81B5}, //11130 #CJK UNIFIED IDEOGRAPH
    {0xEAED, 0x81AB}, //11131 #CJK UNIFIED IDEOGRAPH
    {0xEAEE, 0x81B0}, //11132 #CJK UNIFIED IDEOGRAPH
    {0xEAEF, 0x81AC}, //11133 #CJK UNIFIED IDEOGRAPH
    {0xEAF0, 0x81B4}, //11134 #CJK UNIFIED IDEOGRAPH
    {0xEAF1, 0x81B2}, //11135 #CJK UNIFIED IDEOGRAPH
    {0xEAF2, 0x81B7}, //11136 #CJK UNIFIED IDEOGRAPH
    {0xEAF3, 0x81A7}, //11137 #CJK UNIFIED IDEOGRAPH
    {0xEAF4, 0x81F2}, //11138 #CJK UNIFIED IDEOGRAPH
    {0xEAF5, 0x8255}, //11139 #CJK UNIFIED IDEOGRAPH
    {0xEAF6, 0x8256}, //11140 #CJK UNIFIED IDEOGRAPH
    {0xEAF7, 0x8257}, //11141 #CJK UNIFIED IDEOGRAPH
    {0xEAF8, 0x8556}, //11142 #CJK UNIFIED IDEOGRAPH
    {0xEAF9, 0x8545}, //11143 #CJK UNIFIED IDEOGRAPH
    {0xEAFA, 0x856B}, //11144 #CJK UNIFIED IDEOGRAPH
    {0xEAFB, 0x854D}, //11145 #CJK UNIFIED IDEOGRAPH
    {0xEAFC, 0x8553}, //11146 #CJK UNIFIED IDEOGRAPH
    {0xEAFD, 0x8561}, //11147 #CJK UNIFIED IDEOGRAPH
    {0xEAFE, 0x8558}, //11148 #CJK UNIFIED IDEOGRAPH
    {0xEB40, 0x8540}, //11149 #CJK UNIFIED IDEOGRAPH
    {0xEB41, 0x8546}, //11150 #CJK UNIFIED IDEOGRAPH
    {0xEB42, 0x8564}, //11151 #CJK UNIFIED IDEOGRAPH
    {0xEB43, 0x8541}, //11152 #CJK UNIFIED IDEOGRAPH
    {0xEB44, 0x8562}, //11153 #CJK UNIFIED IDEOGRAPH
    {0xEB45, 0x8544}, //11154 #CJK UNIFIED IDEOGRAPH
    {0xEB46, 0x8551}, //11155 #CJK UNIFIED IDEOGRAPH
    {0xEB47, 0x8547}, //11156 #CJK UNIFIED IDEOGRAPH
    {0xEB48, 0x8563}, //11157 #CJK UNIFIED IDEOGRAPH
    {0xEB49, 0x853E}, //11158 #CJK UNIFIED IDEOGRAPH
    {0xEB4A, 0x855B}, //11159 #CJK UNIFIED IDEOGRAPH
    {0xEB4B, 0x8571}, //11160 #CJK UNIFIED IDEOGRAPH
    {0xEB4C, 0x854E}, //11161 #CJK UNIFIED IDEOGRAPH
    {0xEB4D, 0x856E}, //11162 #CJK UNIFIED IDEOGRAPH
    {0xEB4E, 0x8575}, //11163 #CJK UNIFIED IDEOGRAPH
    {0xEB4F, 0x8555}, //11164 #CJK UNIFIED IDEOGRAPH
    {0xEB50, 0x8567}, //11165 #CJK UNIFIED IDEOGRAPH
    {0xEB51, 0x8560}, //11166 #CJK UNIFIED IDEOGRAPH
    {0xEB52, 0x858C}, //11167 #CJK UNIFIED IDEOGRAPH
    {0xEB53, 0x8566}, //11168 #CJK UNIFIED IDEOGRAPH
    {0xEB54, 0x855D}, //11169 #CJK UNIFIED IDEOGRAPH
    {0xEB55, 0x8554}, //11170 #CJK UNIFIED IDEOGRAPH
    {0xEB56, 0x8565}, //11171 #CJK UNIFIED IDEOGRAPH
    {0xEB57, 0x856C}, //11172 #CJK UNIFIED IDEOGRAPH
    {0xEB58, 0x8663}, //11173 #CJK UNIFIED IDEOGRAPH
    {0xEB59, 0x8665}, //11174 #CJK UNIFIED IDEOGRAPH
    {0xEB5A, 0x8664}, //11175 #CJK UNIFIED IDEOGRAPH
    {0xEB5B, 0x879B}, //11176 #CJK UNIFIED IDEOGRAPH
    {0xEB5C, 0x878F}, //11177 #CJK UNIFIED IDEOGRAPH
    {0xEB5D, 0x8797}, //11178 #CJK UNIFIED IDEOGRAPH
    {0xEB5E, 0x8793}, //11179 #CJK UNIFIED IDEOGRAPH
    {0xEB5F, 0x8792}, //11180 #CJK UNIFIED IDEOGRAPH
    {0xEB60, 0x8788}, //11181 #CJK UNIFIED IDEOGRAPH
    {0xEB61, 0x8781}, //11182 #CJK UNIFIED IDEOGRAPH
    {0xEB62, 0x8796}, //11183 #CJK UNIFIED IDEOGRAPH
    {0xEB63, 0x8798}, //11184 #CJK UNIFIED IDEOGRAPH
    {0xEB64, 0x8779}, //11185 #CJK UNIFIED IDEOGRAPH
    {0xEB65, 0x8787}, //11186 #CJK UNIFIED IDEOGRAPH
    {0xEB66, 0x87A3}, //11187 #CJK UNIFIED IDEOGRAPH
    {0xEB67, 0x8785}, //11188 #CJK UNIFIED IDEOGRAPH
    {0xEB68, 0x8790}, //11189 #CJK UNIFIED IDEOGRAPH
    {0xEB69, 0x8791}, //11190 #CJK UNIFIED IDEOGRAPH
    {0xEB6A, 0x879D}, //11191 #CJK UNIFIED IDEOGRAPH
    {0xEB6B, 0x8784}, //11192 #CJK UNIFIED IDEOGRAPH
    {0xEB6C, 0x8794}, //11193 #CJK UNIFIED IDEOGRAPH
    {0xEB6D, 0x879C}, //11194 #CJK UNIFIED IDEOGRAPH
    {0xEB6E, 0x879A}, //11195 #CJK UNIFIED IDEOGRAPH
    {0xEB6F, 0x8789}, //11196 #CJK UNIFIED IDEOGRAPH
    {0xEB70, 0x891E}, //11197 #CJK UNIFIED IDEOGRAPH
    {0xEB71, 0x8926}, //11198 #CJK UNIFIED IDEOGRAPH
    {0xEB72, 0x8930}, //11199 #CJK UNIFIED IDEOGRAPH
    {0xEB73, 0x892D}, //11200 #CJK UNIFIED IDEOGRAPH
    {0xEB74, 0x892E}, //11201 #CJK UNIFIED IDEOGRAPH
    {0xEB75, 0x8927}, //11202 #CJK UNIFIED IDEOGRAPH
    {0xEB76, 0x8931}, //11203 #CJK UNIFIED IDEOGRAPH
    {0xEB77, 0x8922}, //11204 #CJK UNIFIED IDEOGRAPH
    {0xEB78, 0x8929}, //11205 #CJK UNIFIED IDEOGRAPH
    {0xEB79, 0x8923}, //11206 #CJK UNIFIED IDEOGRAPH
    {0xEB7A, 0x892F}, //11207 #CJK UNIFIED IDEOGRAPH
    {0xEB7B, 0x892C}, //11208 #CJK UNIFIED IDEOGRAPH
    {0xEB7C, 0x891F}, //11209 #CJK UNIFIED IDEOGRAPH
    {0xEB7D, 0x89F1}, //11210 #CJK UNIFIED IDEOGRAPH
    {0xEB7E, 0x8AE0}, //11211 #CJK UNIFIED IDEOGRAPH
    {0xEBA1, 0x8AE2}, //11212 #CJK UNIFIED IDEOGRAPH
    {0xEBA2, 0x8AF2}, //11213 #CJK UNIFIED IDEOGRAPH
    {0xEBA3, 0x8AF4}, //11214 #CJK UNIFIED IDEOGRAPH
    {0xEBA4, 0x8AF5}, //11215 #CJK UNIFIED IDEOGRAPH
    {0xEBA5, 0x8ADD}, //11216 #CJK UNIFIED IDEOGRAPH
    {0xEBA6, 0x8B14}, //11217 #CJK UNIFIED IDEOGRAPH
    {0xEBA7, 0x8AE4}, //11218 #CJK UNIFIED IDEOGRAPH
    {0xEBA8, 0x8ADF}, //11219 #CJK UNIFIED IDEOGRAPH
    {0xEBA9, 0x8AF0}, //11220 #CJK UNIFIED IDEOGRAPH
    {0xEBAA, 0x8AC8}, //11221 #CJK UNIFIED IDEOGRAPH
    {0xEBAB, 0x8ADE}, //11222 #CJK UNIFIED IDEOGRAPH
    {0xEBAC, 0x8AE1}, //11223 #CJK UNIFIED IDEOGRAPH
    {0xEBAD, 0x8AE8}, //11224 #CJK UNIFIED IDEOGRAPH
    {0xEBAE, 0x8AFF}, //11225 #CJK UNIFIED IDEOGRAPH
    {0xEBAF, 0x8AEF}, //11226 #CJK UNIFIED IDEOGRAPH
    {0xEBB0, 0x8AFB}, //11227 #CJK UNIFIED IDEOGRAPH
    {0xEBB1, 0x8C91}, //11228 #CJK UNIFIED IDEOGRAPH
    {0xEBB2, 0x8C92}, //11229 #CJK UNIFIED IDEOGRAPH
    {0xEBB3, 0x8C90}, //11230 #CJK UNIFIED IDEOGRAPH
    {0xEBB4, 0x8CF5}, //11231 #CJK UNIFIED IDEOGRAPH
    {0xEBB5, 0x8CEE}, //11232 #CJK UNIFIED IDEOGRAPH
    {0xEBB6, 0x8CF1}, //11233 #CJK UNIFIED IDEOGRAPH
    {0xEBB7, 0x8CF0}, //11234 #CJK UNIFIED IDEOGRAPH
    {0xEBB8, 0x8CF3}, //11235 #CJK UNIFIED IDEOGRAPH
    {0xEBB9, 0x8D6C}, //11236 #CJK UNIFIED IDEOGRAPH
    {0xEBBA, 0x8D6E}, //11237 #CJK UNIFIED IDEOGRAPH
    {0xEBBB, 0x8DA5}, //11238 #CJK UNIFIED IDEOGRAPH
    {0xEBBC, 0x8DA7}, //11239 #CJK UNIFIED IDEOGRAPH
    {0xEBBD, 0x8E33}, //11240 #CJK UNIFIED IDEOGRAPH
    {0xEBBE, 0x8E3E}, //11241 #CJK UNIFIED IDEOGRAPH
    {0xEBBF, 0x8E38}, //11242 #CJK UNIFIED IDEOGRAPH
    {0xEBC0, 0x8E40}, //11243 #CJK UNIFIED IDEOGRAPH
    {0xEBC1, 0x8E45}, //11244 #CJK UNIFIED IDEOGRAPH
    {0xEBC2, 0x8E36}, //11245 #CJK UNIFIED IDEOGRAPH
    {0xEBC3, 0x8E3C}, //11246 #CJK UNIFIED IDEOGRAPH
    {0xEBC4, 0x8E3D}, //11247 #CJK UNIFIED IDEOGRAPH
    {0xEBC5, 0x8E41}, //11248 #CJK UNIFIED IDEOGRAPH
    {0xEBC6, 0x8E30}, //11249 #CJK UNIFIED IDEOGRAPH
    {0xEBC7, 0x8E3F}, //11250 #CJK UNIFIED IDEOGRAPH
    {0xEBC8, 0x8EBD}, //11251 #CJK UNIFIED IDEOGRAPH
    {0xEBC9, 0x8F36}, //11252 #CJK UNIFIED IDEOGRAPH
    {0xEBCA, 0x8F2E}, //11253 #CJK UNIFIED IDEOGRAPH
    {0xEBCB, 0x8F35}, //11254 #CJK UNIFIED IDEOGRAPH
    {0xEBCC, 0x8F32}, //11255 #CJK UNIFIED IDEOGRAPH
    {0xEBCD, 0x8F39}, //11256 #CJK UNIFIED IDEOGRAPH
    {0xEBCE, 0x8F37}, //11257 #CJK UNIFIED IDEOGRAPH
    {0xEBCF, 0x8F34}, //11258 #CJK UNIFIED IDEOGRAPH
    {0xEBD0, 0x9076}, //11259 #CJK UNIFIED IDEOGRAPH
    {0xEBD1, 0x9079}, //11260 #CJK UNIFIED IDEOGRAPH
    {0xEBD2, 0x907B}, //11261 #CJK UNIFIED IDEOGRAPH
    {0xEBD3, 0x9086}, //11262 #CJK UNIFIED IDEOGRAPH
    {0xEBD4, 0x90FA}, //11263 #CJK UNIFIED IDEOGRAPH
    {0xEBD5, 0x9133}, //11264 #CJK UNIFIED IDEOGRAPH
    {0xEBD6, 0x9135}, //11265 #CJK UNIFIED IDEOGRAPH
    {0xEBD7, 0x9136}, //11266 #CJK UNIFIED IDEOGRAPH
    {0xEBD8, 0x9193}, //11267 #CJK UNIFIED IDEOGRAPH
    {0xEBD9, 0x9190}, //11268 #CJK UNIFIED IDEOGRAPH
    {0xEBDA, 0x9191}, //11269 #CJK UNIFIED IDEOGRAPH
    {0xEBDB, 0x918D}, //11270 #CJK UNIFIED IDEOGRAPH
    {0xEBDC, 0x918F}, //11271 #CJK UNIFIED IDEOGRAPH
    {0xEBDD, 0x9327}, //11272 #CJK UNIFIED IDEOGRAPH
    {0xEBDE, 0x931E}, //11273 #CJK UNIFIED IDEOGRAPH
    {0xEBDF, 0x9308}, //11274 #CJK UNIFIED IDEOGRAPH
    {0xEBE0, 0x931F}, //11275 #CJK UNIFIED IDEOGRAPH
    {0xEBE1, 0x9306}, //11276 #CJK UNIFIED IDEOGRAPH
    {0xEBE2, 0x930F}, //11277 #CJK UNIFIED IDEOGRAPH
    {0xEBE3, 0x937A}, //11278 #CJK UNIFIED IDEOGRAPH
    {0xEBE4, 0x9338}, //11279 #CJK UNIFIED IDEOGRAPH
    {0xEBE5, 0x933C}, //11280 #CJK UNIFIED IDEOGRAPH
    {0xEBE6, 0x931B}, //11281 #CJK UNIFIED IDEOGRAPH
    {0xEBE7, 0x9323}, //11282 #CJK UNIFIED IDEOGRAPH
    {0xEBE8, 0x9312}, //11283 #CJK UNIFIED IDEOGRAPH
    {0xEBE9, 0x9301}, //11284 #CJK UNIFIED IDEOGRAPH
    {0xEBEA, 0x9346}, //11285 #CJK UNIFIED IDEOGRAPH
    {0xEBEB, 0x932D}, //11286 #CJK UNIFIED IDEOGRAPH
    {0xEBEC, 0x930E}, //11287 #CJK UNIFIED IDEOGRAPH
    {0xEBED, 0x930D}, //11288 #CJK UNIFIED IDEOGRAPH
    {0xEBEE, 0x92CB}, //11289 #CJK UNIFIED IDEOGRAPH
    {0xEBEF, 0x931D}, //11290 #CJK UNIFIED IDEOGRAPH
    {0xEBF0, 0x92FA}, //11291 #CJK UNIFIED IDEOGRAPH
    {0xEBF1, 0x9325}, //11292 #CJK UNIFIED IDEOGRAPH
    {0xEBF2, 0x9313}, //11293 #CJK UNIFIED IDEOGRAPH
    {0xEBF3, 0x92F9}, //11294 #CJK UNIFIED IDEOGRAPH
    {0xEBF4, 0x92F7}, //11295 #CJK UNIFIED IDEOGRAPH
    {0xEBF5, 0x9334}, //11296 #CJK UNIFIED IDEOGRAPH
    {0xEBF6, 0x9302}, //11297 #CJK UNIFIED IDEOGRAPH
    {0xEBF7, 0x9324}, //11298 #CJK UNIFIED IDEOGRAPH
    {0xEBF8, 0x92FF}, //11299 #CJK UNIFIED IDEOGRAPH
    {0xEBF9, 0x9329}, //11300 #CJK UNIFIED IDEOGRAPH
    {0xEBFA, 0x9339}, //11301 #CJK UNIFIED IDEOGRAPH
    {0xEBFB, 0x9335}, //11302 #CJK UNIFIED IDEOGRAPH
    {0xEBFC, 0x932A}, //11303 #CJK UNIFIED IDEOGRAPH
    {0xEBFD, 0x9314}, //11304 #CJK UNIFIED IDEOGRAPH
    {0xEBFE, 0x930C}, //11305 #CJK UNIFIED IDEOGRAPH
    {0xEC40, 0x930B}, //11306 #CJK UNIFIED IDEOGRAPH
    {0xEC41, 0x92FE}, //11307 #CJK UNIFIED IDEOGRAPH
    {0xEC42, 0x9309}, //11308 #CJK UNIFIED IDEOGRAPH
    {0xEC43, 0x9300}, //11309 #CJK UNIFIED IDEOGRAPH
    {0xEC44, 0x92FB}, //11310 #CJK UNIFIED IDEOGRAPH
    {0xEC45, 0x9316}, //11311 #CJK UNIFIED IDEOGRAPH
    {0xEC46, 0x95BC}, //11312 #CJK UNIFIED IDEOGRAPH
    {0xEC47, 0x95CD}, //11313 #CJK UNIFIED IDEOGRAPH
    {0xEC48, 0x95BE}, //11314 #CJK UNIFIED IDEOGRAPH
    {0xEC49, 0x95B9}, //11315 #CJK UNIFIED IDEOGRAPH
    {0xEC4A, 0x95BA}, //11316 #CJK UNIFIED IDEOGRAPH
    {0xEC4B, 0x95B6}, //11317 #CJK UNIFIED IDEOGRAPH
    {0xEC4C, 0x95BF}, //11318 #CJK UNIFIED IDEOGRAPH
    {0xEC4D, 0x95B5}, //11319 #CJK UNIFIED IDEOGRAPH
    {0xEC4E, 0x95BD}, //11320 #CJK UNIFIED IDEOGRAPH
    {0xEC4F, 0x96A9}, //11321 #CJK UNIFIED IDEOGRAPH
    {0xEC50, 0x96D4}, //11322 #CJK UNIFIED IDEOGRAPH
    {0xEC51, 0x970B}, //11323 #CJK UNIFIED IDEOGRAPH
    {0xEC52, 0x9712}, //11324 #CJK UNIFIED IDEOGRAPH
    {0xEC53, 0x9710}, //11325 #CJK UNIFIED IDEOGRAPH
    {0xEC54, 0x9799}, //11326 #CJK UNIFIED IDEOGRAPH
    {0xEC55, 0x9797}, //11327 #CJK UNIFIED IDEOGRAPH
    {0xEC56, 0x9794}, //11328 #CJK UNIFIED IDEOGRAPH
    {0xEC57, 0x97F0}, //11329 #CJK UNIFIED IDEOGRAPH
    {0xEC58, 0x97F8}, //11330 #CJK UNIFIED IDEOGRAPH
    {0xEC59, 0x9835}, //11331 #CJK UNIFIED IDEOGRAPH
    {0xEC5A, 0x982F}, //11332 #CJK UNIFIED IDEOGRAPH
    {0xEC5B, 0x9832}, //11333 #CJK UNIFIED IDEOGRAPH
    {0xEC5C, 0x9924}, //11334 #CJK UNIFIED IDEOGRAPH
    {0xEC5D, 0x991F}, //11335 #CJK UNIFIED IDEOGRAPH
    {0xEC5E, 0x9927}, //11336 #CJK UNIFIED IDEOGRAPH
    {0xEC5F, 0x9929}, //11337 #CJK UNIFIED IDEOGRAPH
    {0xEC60, 0x999E}, //11338 #CJK UNIFIED IDEOGRAPH
    {0xEC61, 0x99EE}, //11339 #CJK UNIFIED IDEOGRAPH
    {0xEC62, 0x99EC}, //11340 #CJK UNIFIED IDEOGRAPH
    {0xEC63, 0x99E5}, //11341 #CJK UNIFIED IDEOGRAPH
    {0xEC64, 0x99E4}, //11342 #CJK UNIFIED IDEOGRAPH
    {0xEC65, 0x99F0}, //11343 #CJK UNIFIED IDEOGRAPH
    {0xEC66, 0x99E3}, //11344 #CJK UNIFIED IDEOGRAPH
    {0xEC67, 0x99EA}, //11345 #CJK UNIFIED IDEOGRAPH
    {0xEC68, 0x99E9}, //11346 #CJK UNIFIED IDEOGRAPH
    {0xEC69, 0x99E7}, //11347 #CJK UNIFIED IDEOGRAPH
    {0xEC6A, 0x9AB9}, //11348 #CJK UNIFIED IDEOGRAPH
    {0xEC6B, 0x9ABF}, //11349 #CJK UNIFIED IDEOGRAPH
    {0xEC6C, 0x9AB4}, //11350 #CJK UNIFIED IDEOGRAPH
    {0xEC6D, 0x9ABB}, //11351 #CJK UNIFIED IDEOGRAPH
    {0xEC6E, 0x9AF6}, //11352 #CJK UNIFIED IDEOGRAPH
    {0xEC6F, 0x9AFA}, //11353 #CJK UNIFIED IDEOGRAPH
    {0xEC70, 0x9AF9}, //11354 #CJK UNIFIED IDEOGRAPH
    {0xEC71, 0x9AF7}, //11355 #CJK UNIFIED IDEOGRAPH
    {0xEC72, 0x9B33}, //11356 #CJK UNIFIED IDEOGRAPH
    {0xEC73, 0x9B80}, //11357 #CJK UNIFIED IDEOGRAPH
    {0xEC74, 0x9B85}, //11358 #CJK UNIFIED IDEOGRAPH
    {0xEC75, 0x9B87}, //11359 #CJK UNIFIED IDEOGRAPH
    {0xEC76, 0x9B7C}, //11360 #CJK UNIFIED IDEOGRAPH
    {0xEC77, 0x9B7E}, //11361 #CJK UNIFIED IDEOGRAPH
    {0xEC78, 0x9B7B}, //11362 #CJK UNIFIED IDEOGRAPH
    {0xEC79, 0x9B82}, //11363 #CJK UNIFIED IDEOGRAPH
    {0xEC7A, 0x9B93}, //11364 #CJK UNIFIED IDEOGRAPH
    {0xEC7B, 0x9B92}, //11365 #CJK UNIFIED IDEOGRAPH
    {0xEC7C, 0x9B90}, //11366 #CJK UNIFIED IDEOGRAPH
    {0xEC7D, 0x9B7A}, //11367 #CJK UNIFIED IDEOGRAPH
    {0xEC7E, 0x9B95}, //11368 #CJK UNIFIED IDEOGRAPH
    {0xECA1, 0x9B7D}, //11369 #CJK UNIFIED IDEOGRAPH
    {0xECA2, 0x9B88}, //11370 #CJK UNIFIED IDEOGRAPH
    {0xECA3, 0x9D25}, //11371 #CJK UNIFIED IDEOGRAPH
    {0xECA4, 0x9D17}, //11372 #CJK UNIFIED IDEOGRAPH
    {0xECA5, 0x9D20}, //11373 #CJK UNIFIED IDEOGRAPH
    {0xECA6, 0x9D1E}, //11374 #CJK UNIFIED IDEOGRAPH
    {0xECA7, 0x9D14}, //11375 #CJK UNIFIED IDEOGRAPH
    {0xECA8, 0x9D29}, //11376 #CJK UNIFIED IDEOGRAPH
    {0xECA9, 0x9D1D}, //11377 #CJK UNIFIED IDEOGRAPH
    {0xECAA, 0x9D18}, //11378 #CJK UNIFIED IDEOGRAPH
    {0xECAB, 0x9D22}, //11379 #CJK UNIFIED IDEOGRAPH
    {0xECAC, 0x9D10}, //11380 #CJK UNIFIED IDEOGRAPH
    {0xECAD, 0x9D19}, //11381 #CJK UNIFIED IDEOGRAPH
    {0xECAE, 0x9D1F}, //11382 #CJK UNIFIED IDEOGRAPH
    {0xECAF, 0x9E88}, //11383 #CJK UNIFIED IDEOGRAPH
    {0xECB0, 0x9E86}, //11384 #CJK UNIFIED IDEOGRAPH
    {0xECB1, 0x9E87}, //11385 #CJK UNIFIED IDEOGRAPH
    {0xECB2, 0x9EAE}, //11386 #CJK UNIFIED IDEOGRAPH
    {0xECB3, 0x9EAD}, //11387 #CJK UNIFIED IDEOGRAPH
    {0xECB4, 0x9ED5}, //11388 #CJK UNIFIED IDEOGRAPH
    {0xECB5, 0x9ED6}, //11389 #CJK UNIFIED IDEOGRAPH
    {0xECB6, 0x9EFA}, //11390 #CJK UNIFIED IDEOGRAPH
    {0xECB7, 0x9F12}, //11391 #CJK UNIFIED IDEOGRAPH
    {0xECB8, 0x9F3D}, //11392 #CJK UNIFIED IDEOGRAPH
    {0xECB9, 0x5126}, //11393 #CJK UNIFIED IDEOGRAPH
    {0xECBA, 0x5125}, //11394 #CJK UNIFIED IDEOGRAPH
    {0xECBB, 0x5122}, //11395 #CJK UNIFIED IDEOGRAPH
    {0xECBC, 0x5124}, //11396 #CJK UNIFIED IDEOGRAPH
    {0xECBD, 0x5120}, //11397 #CJK UNIFIED IDEOGRAPH
    {0xECBE, 0x5129}, //11398 #CJK UNIFIED IDEOGRAPH
    {0xECBF, 0x52F4}, //11399 #CJK UNIFIED IDEOGRAPH
    {0xECC0, 0x5693}, //11400 #CJK UNIFIED IDEOGRAPH
    {0xECC1, 0x568C}, //11401 #CJK UNIFIED IDEOGRAPH
    {0xECC2, 0x568D}, //11402 #CJK UNIFIED IDEOGRAPH
    {0xECC3, 0x5686}, //11403 #CJK UNIFIED IDEOGRAPH
    {0xECC4, 0x5684}, //11404 #CJK UNIFIED IDEOGRAPH
    {0xECC5, 0x5683}, //11405 #CJK UNIFIED IDEOGRAPH
    {0xECC6, 0x567E}, //11406 #CJK UNIFIED IDEOGRAPH
    {0xECC7, 0x5682}, //11407 #CJK UNIFIED IDEOGRAPH
    {0xECC8, 0x567F}, //11408 #CJK UNIFIED IDEOGRAPH
    {0xECC9, 0x5681}, //11409 #CJK UNIFIED IDEOGRAPH
    {0xECCA, 0x58D6}, //11410 #CJK UNIFIED IDEOGRAPH
    {0xECCB, 0x58D4}, //11411 #CJK UNIFIED IDEOGRAPH
    {0xECCC, 0x58CF}, //11412 #CJK UNIFIED IDEOGRAPH
    {0xECCD, 0x58D2}, //11413 #CJK UNIFIED IDEOGRAPH
    {0xECCE, 0x5B2D}, //11414 #CJK UNIFIED IDEOGRAPH
    {0xECCF, 0x5B25}, //11415 #CJK UNIFIED IDEOGRAPH
    {0xECD0, 0x5B32}, //11416 #CJK UNIFIED IDEOGRAPH
    {0xECD1, 0x5B23}, //11417 #CJK UNIFIED IDEOGRAPH
    {0xECD2, 0x5B2C}, //11418 #CJK UNIFIED IDEOGRAPH
    {0xECD3, 0x5B27}, //11419 #CJK UNIFIED IDEOGRAPH
    {0xECD4, 0x5B26}, //11420 #CJK UNIFIED IDEOGRAPH
    {0xECD5, 0x5B2F}, //11421 #CJK UNIFIED IDEOGRAPH
    {0xECD6, 0x5B2E}, //11422 #CJK UNIFIED IDEOGRAPH
    {0xECD7, 0x5B7B}, //11423 #CJK UNIFIED IDEOGRAPH
    {0xECD8, 0x5BF1}, //11424 #CJK UNIFIED IDEOGRAPH
    {0xECD9, 0x5BF2}, //11425 #CJK UNIFIED IDEOGRAPH
    {0xECDA, 0x5DB7}, //11426 #CJK UNIFIED IDEOGRAPH
    {0xECDB, 0x5E6C}, //11427 #CJK UNIFIED IDEOGRAPH
    {0xECDC, 0x5E6A}, //11428 #CJK UNIFIED IDEOGRAPH
    {0xECDD, 0x5FBE}, //11429 #CJK UNIFIED IDEOGRAPH
    {0xECDE, 0x5FBB}, //11430 #CJK UNIFIED IDEOGRAPH
    {0xECDF, 0x61C3}, //11431 #CJK UNIFIED IDEOGRAPH
    {0xECE0, 0x61B5}, //11432 #CJK UNIFIED IDEOGRAPH
    {0xECE1, 0x61BC}, //11433 #CJK UNIFIED IDEOGRAPH
    {0xECE2, 0x61E7}, //11434 #CJK UNIFIED IDEOGRAPH
    {0xECE3, 0x61E0}, //11435 #CJK UNIFIED IDEOGRAPH
    {0xECE4, 0x61E5}, //11436 #CJK UNIFIED IDEOGRAPH
    {0xECE5, 0x61E4}, //11437 #CJK UNIFIED IDEOGRAPH
    {0xECE6, 0x61E8}, //11438 #CJK UNIFIED IDEOGRAPH
    {0xECE7, 0x61DE}, //11439 #CJK UNIFIED IDEOGRAPH
    {0xECE8, 0x64EF}, //11440 #CJK UNIFIED IDEOGRAPH
    {0xECE9, 0x64E9}, //11441 #CJK UNIFIED IDEOGRAPH
    {0xECEA, 0x64E3}, //11442 #CJK UNIFIED IDEOGRAPH
    {0xECEB, 0x64EB}, //11443 #CJK UNIFIED IDEOGRAPH
    {0xECEC, 0x64E4}, //11444 #CJK UNIFIED IDEOGRAPH
    {0xECED, 0x64E8}, //11445 #CJK UNIFIED IDEOGRAPH
    {0xECEE, 0x6581}, //11446 #CJK UNIFIED IDEOGRAPH
    {0xECEF, 0x6580}, //11447 #CJK UNIFIED IDEOGRAPH
    {0xECF0, 0x65B6}, //11448 #CJK UNIFIED IDEOGRAPH
    {0xECF1, 0x65DA}, //11449 #CJK UNIFIED IDEOGRAPH
    {0xECF2, 0x66D2}, //11450 #CJK UNIFIED IDEOGRAPH
    {0xECF3, 0x6A8D}, //11451 #CJK UNIFIED IDEOGRAPH
    {0xECF4, 0x6A96}, //11452 #CJK UNIFIED IDEOGRAPH
    {0xECF5, 0x6A81}, //11453 #CJK UNIFIED IDEOGRAPH
    {0xECF6, 0x6AA5}, //11454 #CJK UNIFIED IDEOGRAPH
    {0xECF7, 0x6A89}, //11455 #CJK UNIFIED IDEOGRAPH
    {0xECF8, 0x6A9F}, //11456 #CJK UNIFIED IDEOGRAPH
    {0xECF9, 0x6A9B}, //11457 #CJK UNIFIED IDEOGRAPH
    {0xECFA, 0x6AA1}, //11458 #CJK UNIFIED IDEOGRAPH
    {0xECFB, 0x6A9E}, //11459 #CJK UNIFIED IDEOGRAPH
    {0xECFC, 0x6A87}, //11460 #CJK UNIFIED IDEOGRAPH
    {0xECFD, 0x6A93}, //11461 #CJK UNIFIED IDEOGRAPH
    {0xECFE, 0x6A8E}, //11462 #CJK UNIFIED IDEOGRAPH
    {0xED40, 0x6A95}, //11463 #CJK UNIFIED IDEOGRAPH
    {0xED41, 0x6A83}, //11464 #CJK UNIFIED IDEOGRAPH
    {0xED42, 0x6AA8}, //11465 #CJK UNIFIED IDEOGRAPH
    {0xED43, 0x6AA4}, //11466 #CJK UNIFIED IDEOGRAPH
    {0xED44, 0x6A91}, //11467 #CJK UNIFIED IDEOGRAPH
    {0xED45, 0x6A7F}, //11468 #CJK UNIFIED IDEOGRAPH
    {0xED46, 0x6AA6}, //11469 #CJK UNIFIED IDEOGRAPH
    {0xED47, 0x6A9A}, //11470 #CJK UNIFIED IDEOGRAPH
    {0xED48, 0x6A85}, //11471 #CJK UNIFIED IDEOGRAPH
    {0xED49, 0x6A8C}, //11472 #CJK UNIFIED IDEOGRAPH
    {0xED4A, 0x6A92}, //11473 #CJK UNIFIED IDEOGRAPH
    {0xED4B, 0x6B5B}, //11474 #CJK UNIFIED IDEOGRAPH
    {0xED4C, 0x6BAD}, //11475 #CJK UNIFIED IDEOGRAPH
    {0xED4D, 0x6C09}, //11476 #CJK UNIFIED IDEOGRAPH
    {0xED4E, 0x6FCC}, //11477 #CJK UNIFIED IDEOGRAPH
    {0xED4F, 0x6FA9}, //11478 #CJK UNIFIED IDEOGRAPH
    {0xED50, 0x6FF4}, //11479 #CJK UNIFIED IDEOGRAPH
    {0xED51, 0x6FD4}, //11480 #CJK UNIFIED IDEOGRAPH
    {0xED52, 0x6FE3}, //11481 #CJK UNIFIED IDEOGRAPH
    {0xED53, 0x6FDC}, //11482 #CJK UNIFIED IDEOGRAPH
    {0xED54, 0x6FED}, //11483 #CJK UNIFIED IDEOGRAPH
    {0xED55, 0x6FE7}, //11484 #CJK UNIFIED IDEOGRAPH
    {0xED56, 0x6FE6}, //11485 #CJK UNIFIED IDEOGRAPH
    {0xED57, 0x6FDE}, //11486 #CJK UNIFIED IDEOGRAPH
    {0xED58, 0x6FF2}, //11487 #CJK UNIFIED IDEOGRAPH
    {0xED59, 0x6FDD}, //11488 #CJK UNIFIED IDEOGRAPH
    {0xED5A, 0x6FE2}, //11489 #CJK UNIFIED IDEOGRAPH
    {0xED5B, 0x6FE8}, //11490 #CJK UNIFIED IDEOGRAPH
    {0xED5C, 0x71E1}, //11491 #CJK UNIFIED IDEOGRAPH
    {0xED5D, 0x71F1}, //11492 #CJK UNIFIED IDEOGRAPH
    {0xED5E, 0x71E8}, //11493 #CJK UNIFIED IDEOGRAPH
    {0xED5F, 0x71F2}, //11494 #CJK UNIFIED IDEOGRAPH
    {0xED60, 0x71E4}, //11495 #CJK UNIFIED IDEOGRAPH
    {0xED61, 0x71F0}, //11496 #CJK UNIFIED IDEOGRAPH
    {0xED62, 0x71E2}, //11497 #CJK UNIFIED IDEOGRAPH
    {0xED63, 0x7373}, //11498 #CJK UNIFIED IDEOGRAPH
    {0xED64, 0x736E}, //11499 #CJK UNIFIED IDEOGRAPH
    {0xED65, 0x736F}, //11500 #CJK UNIFIED IDEOGRAPH
    {0xED66, 0x7497}, //11501 #CJK UNIFIED IDEOGRAPH
    {0xED67, 0x74B2}, //11502 #CJK UNIFIED IDEOGRAPH
    {0xED68, 0x74AB}, //11503 #CJK UNIFIED IDEOGRAPH
    {0xED69, 0x7490}, //11504 #CJK UNIFIED IDEOGRAPH
    {0xED6A, 0x74AA}, //11505 #CJK UNIFIED IDEOGRAPH
    {0xED6B, 0x74AD}, //11506 #CJK UNIFIED IDEOGRAPH
    {0xED6C, 0x74B1}, //11507 #CJK UNIFIED IDEOGRAPH
    {0xED6D, 0x74A5}, //11508 #CJK UNIFIED IDEOGRAPH
    {0xED6E, 0x74AF}, //11509 #CJK UNIFIED IDEOGRAPH
    {0xED6F, 0x7510}, //11510 #CJK UNIFIED IDEOGRAPH
    {0xED70, 0x7511}, //11511 #CJK UNIFIED IDEOGRAPH
    {0xED71, 0x7512}, //11512 #CJK UNIFIED IDEOGRAPH
    {0xED72, 0x750F}, //11513 #CJK UNIFIED IDEOGRAPH
    {0xED73, 0x7584}, //11514 #CJK UNIFIED IDEOGRAPH
    {0xED74, 0x7643}, //11515 #CJK UNIFIED IDEOGRAPH
    {0xED75, 0x7648}, //11516 #CJK UNIFIED IDEOGRAPH
    {0xED76, 0x7649}, //11517 #CJK UNIFIED IDEOGRAPH
    {0xED77, 0x7647}, //11518 #CJK UNIFIED IDEOGRAPH
    {0xED78, 0x76A4}, //11519 #CJK UNIFIED IDEOGRAPH
    {0xED79, 0x76E9}, //11520 #CJK UNIFIED IDEOGRAPH
    {0xED7A, 0x77B5}, //11521 #CJK UNIFIED IDEOGRAPH
    {0xED7B, 0x77AB}, //11522 #CJK UNIFIED IDEOGRAPH
    {0xED7C, 0x77B2}, //11523 #CJK UNIFIED IDEOGRAPH
    {0xED7D, 0x77B7}, //11524 #CJK UNIFIED IDEOGRAPH
    {0xED7E, 0x77B6}, //11525 #CJK UNIFIED IDEOGRAPH
    {0xEDA1, 0x77B4}, //11526 #CJK UNIFIED IDEOGRAPH
    {0xEDA2, 0x77B1}, //11527 #CJK UNIFIED IDEOGRAPH
    {0xEDA3, 0x77A8}, //11528 #CJK UNIFIED IDEOGRAPH
    {0xEDA4, 0x77F0}, //11529 #CJK UNIFIED IDEOGRAPH
    {0xEDA5, 0x78F3}, //11530 #CJK UNIFIED IDEOGRAPH
    {0xEDA6, 0x78FD}, //11531 #CJK UNIFIED IDEOGRAPH
    {0xEDA7, 0x7902}, //11532 #CJK UNIFIED IDEOGRAPH
    {0xEDA8, 0x78FB}, //11533 #CJK UNIFIED IDEOGRAPH
    {0xEDA9, 0x78FC}, //11534 #CJK UNIFIED IDEOGRAPH
    {0xEDAA, 0x78F2}, //11535 #CJK UNIFIED IDEOGRAPH
    {0xEDAB, 0x7905}, //11536 #CJK UNIFIED IDEOGRAPH
    {0xEDAC, 0x78F9}, //11537 #CJK UNIFIED IDEOGRAPH
    {0xEDAD, 0x78FE}, //11538 #CJK UNIFIED IDEOGRAPH
    {0xEDAE, 0x7904}, //11539 #CJK UNIFIED IDEOGRAPH
    {0xEDAF, 0x79AB}, //11540 #CJK UNIFIED IDEOGRAPH
    {0xEDB0, 0x79A8}, //11541 #CJK UNIFIED IDEOGRAPH
    {0xEDB1, 0x7A5C}, //11542 #CJK UNIFIED IDEOGRAPH
    {0xEDB2, 0x7A5B}, //11543 #CJK UNIFIED IDEOGRAPH
    {0xEDB3, 0x7A56}, //11544 #CJK UNIFIED IDEOGRAPH
    {0xEDB4, 0x7A58}, //11545 #CJK UNIFIED IDEOGRAPH
    {0xEDB5, 0x7A54}, //11546 #CJK UNIFIED IDEOGRAPH
    {0xEDB6, 0x7A5A}, //11547 #CJK UNIFIED IDEOGRAPH
    {0xEDB7, 0x7ABE}, //11548 #CJK UNIFIED IDEOGRAPH
    {0xEDB8, 0x7AC0}, //11549 #CJK UNIFIED IDEOGRAPH
    {0xEDB9, 0x7AC1}, //11550 #CJK UNIFIED IDEOGRAPH
    {0xEDBA, 0x7C05}, //11551 #CJK UNIFIED IDEOGRAPH
    {0xEDBB, 0x7C0F}, //11552 #CJK UNIFIED IDEOGRAPH
    {0xEDBC, 0x7BF2}, //11553 #CJK UNIFIED IDEOGRAPH
    {0xEDBD, 0x7C00}, //11554 #CJK UNIFIED IDEOGRAPH
    {0xEDBE, 0x7BFF}, //11555 #CJK UNIFIED IDEOGRAPH
    {0xEDBF, 0x7BFB}, //11556 #CJK UNIFIED IDEOGRAPH
    {0xEDC0, 0x7C0E}, //11557 #CJK UNIFIED IDEOGRAPH
    {0xEDC1, 0x7BF4}, //11558 #CJK UNIFIED IDEOGRAPH
    {0xEDC2, 0x7C0B}, //11559 #CJK UNIFIED IDEOGRAPH
    {0xEDC3, 0x7BF3}, //11560 #CJK UNIFIED IDEOGRAPH
    {0xEDC4, 0x7C02}, //11561 #CJK UNIFIED IDEOGRAPH
    {0xEDC5, 0x7C09}, //11562 #CJK UNIFIED IDEOGRAPH
    {0xEDC6, 0x7C03}, //11563 #CJK UNIFIED IDEOGRAPH
    {0xEDC7, 0x7C01}, //11564 #CJK UNIFIED IDEOGRAPH
    {0xEDC8, 0x7BF8}, //11565 #CJK UNIFIED IDEOGRAPH
    {0xEDC9, 0x7BFD}, //11566 #CJK UNIFIED IDEOGRAPH
    {0xEDCA, 0x7C06}, //11567 #CJK UNIFIED IDEOGRAPH
    {0xEDCB, 0x7BF0}, //11568 #CJK UNIFIED IDEOGRAPH
    {0xEDCC, 0x7BF1}, //11569 #CJK UNIFIED IDEOGRAPH
    {0xEDCD, 0x7C10}, //11570 #CJK UNIFIED IDEOGRAPH
    {0xEDCE, 0x7C0A}, //11571 #CJK UNIFIED IDEOGRAPH
    {0xEDCF, 0x7CE8}, //11572 #CJK UNIFIED IDEOGRAPH
    {0xEDD0, 0x7E2D}, //11573 #CJK UNIFIED IDEOGRAPH
    {0xEDD1, 0x7E3C}, //11574 #CJK UNIFIED IDEOGRAPH
    {0xEDD2, 0x7E42}, //11575 #CJK UNIFIED IDEOGRAPH
    {0xEDD3, 0x7E33}, //11576 #CJK UNIFIED IDEOGRAPH
    {0xEDD4, 0x9848}, //11577 #CJK UNIFIED IDEOGRAPH
    {0xEDD5, 0x7E38}, //11578 #CJK UNIFIED IDEOGRAPH
    {0xEDD6, 0x7E2A}, //11579 #CJK UNIFIED IDEOGRAPH
    {0xEDD7, 0x7E49}, //11580 #CJK UNIFIED IDEOGRAPH
    {0xEDD8, 0x7E40}, //11581 #CJK UNIFIED IDEOGRAPH
    {0xEDD9, 0x7E47}, //11582 #CJK UNIFIED IDEOGRAPH
    {0xEDDA, 0x7E29}, //11583 #CJK UNIFIED IDEOGRAPH
    {0xEDDB, 0x7E4C}, //11584 #CJK UNIFIED IDEOGRAPH
    {0xEDDC, 0x7E30}, //11585 #CJK UNIFIED IDEOGRAPH
    {0xEDDD, 0x7E3B}, //11586 #CJK UNIFIED IDEOGRAPH
    {0xEDDE, 0x7E36}, //11587 #CJK UNIFIED IDEOGRAPH
    {0xEDDF, 0x7E44}, //11588 #CJK UNIFIED IDEOGRAPH
    {0xEDE0, 0x7E3A}, //11589 #CJK UNIFIED IDEOGRAPH
    {0xEDE1, 0x7F45}, //11590 #CJK UNIFIED IDEOGRAPH
    {0xEDE2, 0x7F7F}, //11591 #CJK UNIFIED IDEOGRAPH
    {0xEDE3, 0x7F7E}, //11592 #CJK UNIFIED IDEOGRAPH
    {0xEDE4, 0x7F7D}, //11593 #CJK UNIFIED IDEOGRAPH
    {0xEDE5, 0x7FF4}, //11594 #CJK UNIFIED IDEOGRAPH
    {0xEDE6, 0x7FF2}, //11595 #CJK UNIFIED IDEOGRAPH
    {0xEDE7, 0x802C}, //11596 #CJK UNIFIED IDEOGRAPH
    {0xEDE8, 0x81BB}, //11597 #CJK UNIFIED IDEOGRAPH
    {0xEDE9, 0x81C4}, //11598 #CJK UNIFIED IDEOGRAPH
    {0xEDEA, 0x81CC}, //11599 #CJK UNIFIED IDEOGRAPH
    {0xEDEB, 0x81CA}, //11600 #CJK UNIFIED IDEOGRAPH
    {0xEDEC, 0x81C5}, //11601 #CJK UNIFIED IDEOGRAPH
    {0xEDED, 0x81C7}, //11602 #CJK UNIFIED IDEOGRAPH
    {0xEDEE, 0x81BC}, //11603 #CJK UNIFIED IDEOGRAPH
    {0xEDEF, 0x81E9}, //11604 #CJK UNIFIED IDEOGRAPH
    {0xEDF0, 0x825B}, //11605 #CJK UNIFIED IDEOGRAPH
    {0xEDF1, 0x825A}, //11606 #CJK UNIFIED IDEOGRAPH
    {0xEDF2, 0x825C}, //11607 #CJK UNIFIED IDEOGRAPH
    {0xEDF3, 0x8583}, //11608 #CJK UNIFIED IDEOGRAPH
    {0xEDF4, 0x8580}, //11609 #CJK UNIFIED IDEOGRAPH
    {0xEDF5, 0x858F}, //11610 #CJK UNIFIED IDEOGRAPH
    {0xEDF6, 0x85A7}, //11611 #CJK UNIFIED IDEOGRAPH
    {0xEDF7, 0x8595}, //11612 #CJK UNIFIED IDEOGRAPH
    {0xEDF8, 0x85A0}, //11613 #CJK UNIFIED IDEOGRAPH
    {0xEDF9, 0x858B}, //11614 #CJK UNIFIED IDEOGRAPH
    {0xEDFA, 0x85A3}, //11615 #CJK UNIFIED IDEOGRAPH
    {0xEDFB, 0x857B}, //11616 #CJK UNIFIED IDEOGRAPH
    {0xEDFC, 0x85A4}, //11617 #CJK UNIFIED IDEOGRAPH
    {0xEDFD, 0x859A}, //11618 #CJK UNIFIED IDEOGRAPH
    {0xEDFE, 0x859E}, //11619 #CJK UNIFIED IDEOGRAPH
    {0xEE40, 0x8577}, //11620 #CJK UNIFIED IDEOGRAPH
    {0xEE41, 0x857C}, //11621 #CJK UNIFIED IDEOGRAPH
    {0xEE42, 0x8589}, //11622 #CJK UNIFIED IDEOGRAPH
    {0xEE43, 0x85A1}, //11623 #CJK UNIFIED IDEOGRAPH
    {0xEE44, 0x857A}, //11624 #CJK UNIFIED IDEOGRAPH
    {0xEE45, 0x8578}, //11625 #CJK UNIFIED IDEOGRAPH
    {0xEE46, 0x8557}, //11626 #CJK UNIFIED IDEOGRAPH
    {0xEE47, 0x858E}, //11627 #CJK UNIFIED IDEOGRAPH
    {0xEE48, 0x8596}, //11628 #CJK UNIFIED IDEOGRAPH
    {0xEE49, 0x8586}, //11629 #CJK UNIFIED IDEOGRAPH
    {0xEE4A, 0x858D}, //11630 #CJK UNIFIED IDEOGRAPH
    {0xEE4B, 0x8599}, //11631 #CJK UNIFIED IDEOGRAPH
    {0xEE4C, 0x859D}, //11632 #CJK UNIFIED IDEOGRAPH
    {0xEE4D, 0x8581}, //11633 #CJK UNIFIED IDEOGRAPH
    {0xEE4E, 0x85A2}, //11634 #CJK UNIFIED IDEOGRAPH
    {0xEE4F, 0x8582}, //11635 #CJK UNIFIED IDEOGRAPH
    {0xEE50, 0x8588}, //11636 #CJK UNIFIED IDEOGRAPH
    {0xEE51, 0x8585}, //11637 #CJK UNIFIED IDEOGRAPH
    {0xEE52, 0x8579}, //11638 #CJK UNIFIED IDEOGRAPH
    {0xEE53, 0x8576}, //11639 #CJK UNIFIED IDEOGRAPH
    {0xEE54, 0x8598}, //11640 #CJK UNIFIED IDEOGRAPH
    {0xEE55, 0x8590}, //11641 #CJK UNIFIED IDEOGRAPH
    {0xEE56, 0x859F}, //11642 #CJK UNIFIED IDEOGRAPH
    {0xEE57, 0x8668}, //11643 #CJK UNIFIED IDEOGRAPH
    {0xEE58, 0x87BE}, //11644 #CJK UNIFIED IDEOGRAPH
    {0xEE59, 0x87AA}, //11645 #CJK UNIFIED IDEOGRAPH
    {0xEE5A, 0x87AD}, //11646 #CJK UNIFIED IDEOGRAPH
    {0xEE5B, 0x87C5}, //11647 #CJK UNIFIED IDEOGRAPH
    {0xEE5C, 0x87B0}, //11648 #CJK UNIFIED IDEOGRAPH
    {0xEE5D, 0x87AC}, //11649 #CJK UNIFIED IDEOGRAPH
    {0xEE5E, 0x87B9}, //11650 #CJK UNIFIED IDEOGRAPH
    {0xEE5F, 0x87B5}, //11651 #CJK UNIFIED IDEOGRAPH
    {0xEE60, 0x87BC}, //11652 #CJK UNIFIED IDEOGRAPH
    {0xEE61, 0x87AE}, //11653 #CJK UNIFIED IDEOGRAPH
    {0xEE62, 0x87C9}, //11654 #CJK UNIFIED IDEOGRAPH
    {0xEE63, 0x87C3}, //11655 #CJK UNIFIED IDEOGRAPH
    {0xEE64, 0x87C2}, //11656 #CJK UNIFIED IDEOGRAPH
    {0xEE65, 0x87CC}, //11657 #CJK UNIFIED IDEOGRAPH
    {0xEE66, 0x87B7}, //11658 #CJK UNIFIED IDEOGRAPH
    {0xEE67, 0x87AF}, //11659 #CJK UNIFIED IDEOGRAPH
    {0xEE68, 0x87C4}, //11660 #CJK UNIFIED IDEOGRAPH
    {0xEE69, 0x87CA}, //11661 #CJK UNIFIED IDEOGRAPH
    {0xEE6A, 0x87B4}, //11662 #CJK UNIFIED IDEOGRAPH
    {0xEE6B, 0x87B6}, //11663 #CJK UNIFIED IDEOGRAPH
    {0xEE6C, 0x87BF}, //11664 #CJK UNIFIED IDEOGRAPH
    {0xEE6D, 0x87B8}, //11665 #CJK UNIFIED IDEOGRAPH
    {0xEE6E, 0x87BD}, //11666 #CJK UNIFIED IDEOGRAPH
    {0xEE6F, 0x87DE}, //11667 #CJK UNIFIED IDEOGRAPH
    {0xEE70, 0x87B2}, //11668 #CJK UNIFIED IDEOGRAPH
    {0xEE71, 0x8935}, //11669 #CJK UNIFIED IDEOGRAPH
    {0xEE72, 0x8933}, //11670 #CJK UNIFIED IDEOGRAPH
    {0xEE73, 0x893C}, //11671 #CJK UNIFIED IDEOGRAPH
    {0xEE74, 0x893E}, //11672 #CJK UNIFIED IDEOGRAPH
    {0xEE75, 0x8941}, //11673 #CJK UNIFIED IDEOGRAPH
    {0xEE76, 0x8952}, //11674 #CJK UNIFIED IDEOGRAPH
    {0xEE77, 0x8937}, //11675 #CJK UNIFIED IDEOGRAPH
    {0xEE78, 0x8942}, //11676 #CJK UNIFIED IDEOGRAPH
    {0xEE79, 0x89AD}, //11677 #CJK UNIFIED IDEOGRAPH
    {0xEE7A, 0x89AF}, //11678 #CJK UNIFIED IDEOGRAPH
    {0xEE7B, 0x89AE}, //11679 #CJK UNIFIED IDEOGRAPH
    {0xEE7C, 0x89F2}, //11680 #CJK UNIFIED IDEOGRAPH
    {0xEE7D, 0x89F3}, //11681 #CJK UNIFIED IDEOGRAPH
    {0xEE7E, 0x8B1E}, //11682 #CJK UNIFIED IDEOGRAPH
    {0xEEA1, 0x8B18}, //11683 #CJK UNIFIED IDEOGRAPH
    {0xEEA2, 0x8B16}, //11684 #CJK UNIFIED IDEOGRAPH
    {0xEEA3, 0x8B11}, //11685 #CJK UNIFIED IDEOGRAPH
    {0xEEA4, 0x8B05}, //11686 #CJK UNIFIED IDEOGRAPH
    {0xEEA5, 0x8B0B}, //11687 #CJK UNIFIED IDEOGRAPH
    {0xEEA6, 0x8B22}, //11688 #CJK UNIFIED IDEOGRAPH
    {0xEEA7, 0x8B0F}, //11689 #CJK UNIFIED IDEOGRAPH
    {0xEEA8, 0x8B12}, //11690 #CJK UNIFIED IDEOGRAPH
    {0xEEA9, 0x8B15}, //11691 #CJK UNIFIED IDEOGRAPH
    {0xEEAA, 0x8B07}, //11692 #CJK UNIFIED IDEOGRAPH
    {0xEEAB, 0x8B0D}, //11693 #CJK UNIFIED IDEOGRAPH
    {0xEEAC, 0x8B08}, //11694 #CJK UNIFIED IDEOGRAPH
    {0xEEAD, 0x8B06}, //11695 #CJK UNIFIED IDEOGRAPH
    {0xEEAE, 0x8B1C}, //11696 #CJK UNIFIED IDEOGRAPH
    {0xEEAF, 0x8B13}, //11697 #CJK UNIFIED IDEOGRAPH
    {0xEEB0, 0x8B1A}, //11698 #CJK UNIFIED IDEOGRAPH
    {0xEEB1, 0x8C4F}, //11699 #CJK UNIFIED IDEOGRAPH
    {0xEEB2, 0x8C70}, //11700 #CJK UNIFIED IDEOGRAPH
    {0xEEB3, 0x8C72}, //11701 #CJK UNIFIED IDEOGRAPH
    {0xEEB4, 0x8C71}, //11702 #CJK UNIFIED IDEOGRAPH
    {0xEEB5, 0x8C6F}, //11703 #CJK UNIFIED IDEOGRAPH
    {0xEEB6, 0x8C95}, //11704 #CJK UNIFIED IDEOGRAPH
    {0xEEB7, 0x8C94}, //11705 #CJK UNIFIED IDEOGRAPH
    {0xEEB8, 0x8CF9}, //11706 #CJK UNIFIED IDEOGRAPH
    {0xEEB9, 0x8D6F}, //11707 #CJK UNIFIED IDEOGRAPH
    {0xEEBA, 0x8E4E}, //11708 #CJK UNIFIED IDEOGRAPH
    {0xEEBB, 0x8E4D}, //11709 #CJK UNIFIED IDEOGRAPH
    {0xEEBC, 0x8E53}, //11710 #CJK UNIFIED IDEOGRAPH
    {0xEEBD, 0x8E50}, //11711 #CJK UNIFIED IDEOGRAPH
    {0xEEBE, 0x8E4C}, //11712 #CJK UNIFIED IDEOGRAPH
    {0xEEBF, 0x8E47}, //11713 #CJK UNIFIED IDEOGRAPH
    {0xEEC0, 0x8F43}, //11714 #CJK UNIFIED IDEOGRAPH
    {0xEEC1, 0x8F40}, //11715 #CJK UNIFIED IDEOGRAPH
    {0xEEC2, 0x9085}, //11716 #CJK UNIFIED IDEOGRAPH
    {0xEEC3, 0x907E}, //11717 #CJK UNIFIED IDEOGRAPH
    {0xEEC4, 0x9138}, //11718 #CJK UNIFIED IDEOGRAPH
    {0xEEC5, 0x919A}, //11719 #CJK UNIFIED IDEOGRAPH
    {0xEEC6, 0x91A2}, //11720 #CJK UNIFIED IDEOGRAPH
    {0xEEC7, 0x919B}, //11721 #CJK UNIFIED IDEOGRAPH
    {0xEEC8, 0x9199}, //11722 #CJK UNIFIED IDEOGRAPH
    {0xEEC9, 0x919F}, //11723 #CJK UNIFIED IDEOGRAPH
    {0xEECA, 0x91A1}, //11724 #CJK UNIFIED IDEOGRAPH
    {0xEECB, 0x919D}, //11725 #CJK UNIFIED IDEOGRAPH
    {0xEECC, 0x91A0}, //11726 #CJK UNIFIED IDEOGRAPH
    {0xEECD, 0x93A1}, //11727 #CJK UNIFIED IDEOGRAPH
    {0xEECE, 0x9383}, //11728 #CJK UNIFIED IDEOGRAPH
    {0xEECF, 0x93AF}, //11729 #CJK UNIFIED IDEOGRAPH
    {0xEED0, 0x9364}, //11730 #CJK UNIFIED IDEOGRAPH
    {0xEED1, 0x9356}, //11731 #CJK UNIFIED IDEOGRAPH
    {0xEED2, 0x9347}, //11732 #CJK UNIFIED IDEOGRAPH
    {0xEED3, 0x937C}, //11733 #CJK UNIFIED IDEOGRAPH
    {0xEED4, 0x9358}, //11734 #CJK UNIFIED IDEOGRAPH
    {0xEED5, 0x935C}, //11735 #CJK UNIFIED IDEOGRAPH
    {0xEED6, 0x9376}, //11736 #CJK UNIFIED IDEOGRAPH
    {0xEED7, 0x9349}, //11737 #CJK UNIFIED IDEOGRAPH
    {0xEED8, 0x9350}, //11738 #CJK UNIFIED IDEOGRAPH
    {0xEED9, 0x9351}, //11739 #CJK UNIFIED IDEOGRAPH
    {0xEEDA, 0x9360}, //11740 #CJK UNIFIED IDEOGRAPH
    {0xEEDB, 0x936D}, //11741 #CJK UNIFIED IDEOGRAPH
    {0xEEDC, 0x938F}, //11742 #CJK UNIFIED IDEOGRAPH
    {0xEEDD, 0x934C}, //11743 #CJK UNIFIED IDEOGRAPH
    {0xEEDE, 0x936A}, //11744 #CJK UNIFIED IDEOGRAPH
    {0xEEDF, 0x9379}, //11745 #CJK UNIFIED IDEOGRAPH
    {0xEEE0, 0x9357}, //11746 #CJK UNIFIED IDEOGRAPH
    {0xEEE1, 0x9355}, //11747 #CJK UNIFIED IDEOGRAPH
    {0xEEE2, 0x9352}, //11748 #CJK UNIFIED IDEOGRAPH
    {0xEEE3, 0x934F}, //11749 #CJK UNIFIED IDEOGRAPH
    {0xEEE4, 0x9371}, //11750 #CJK UNIFIED IDEOGRAPH
    {0xEEE5, 0x9377}, //11751 #CJK UNIFIED IDEOGRAPH
    {0xEEE6, 0x937B}, //11752 #CJK UNIFIED IDEOGRAPH
    {0xEEE7, 0x9361}, //11753 #CJK UNIFIED IDEOGRAPH
    {0xEEE8, 0x935E}, //11754 #CJK UNIFIED IDEOGRAPH
    {0xEEE9, 0x9363}, //11755 #CJK UNIFIED IDEOGRAPH
    {0xEEEA, 0x9367}, //11756 #CJK UNIFIED IDEOGRAPH
    {0xEEEB, 0x9380}, //11757 #CJK UNIFIED IDEOGRAPH
    {0xEEEC, 0x934E}, //11758 #CJK UNIFIED IDEOGRAPH
    {0xEEED, 0x9359}, //11759 #CJK UNIFIED IDEOGRAPH
    {0xEEEE, 0x95C7}, //11760 #CJK UNIFIED IDEOGRAPH
    {0xEEEF, 0x95C0}, //11761 #CJK UNIFIED IDEOGRAPH
    {0xEEF0, 0x95C9}, //11762 #CJK UNIFIED IDEOGRAPH
    {0xEEF1, 0x95C3}, //11763 #CJK UNIFIED IDEOGRAPH
    {0xEEF2, 0x95C5}, //11764 #CJK UNIFIED IDEOGRAPH
    {0xEEF3, 0x95B7}, //11765 #CJK UNIFIED IDEOGRAPH
    {0xEEF4, 0x96AE}, //11766 #CJK UNIFIED IDEOGRAPH
    {0xEEF5, 0x96B0}, //11767 #CJK UNIFIED IDEOGRAPH
    {0xEEF6, 0x96AC}, //11768 #CJK UNIFIED IDEOGRAPH
    {0xEEF7, 0x9720}, //11769 #CJK UNIFIED IDEOGRAPH
    {0xEEF8, 0x971F}, //11770 #CJK UNIFIED IDEOGRAPH
    {0xEEF9, 0x9718}, //11771 #CJK UNIFIED IDEOGRAPH
    {0xEEFA, 0x971D}, //11772 #CJK UNIFIED IDEOGRAPH
    {0xEEFB, 0x9719}, //11773 #CJK UNIFIED IDEOGRAPH
    {0xEEFC, 0x979A}, //11774 #CJK UNIFIED IDEOGRAPH
    {0xEEFD, 0x97A1}, //11775 #CJK UNIFIED IDEOGRAPH
    {0xEEFE, 0x979C}, //11776 #CJK UNIFIED IDEOGRAPH
    {0xEF40, 0x979E}, //11777 #CJK UNIFIED IDEOGRAPH
    {0xEF41, 0x979D}, //11778 #CJK UNIFIED IDEOGRAPH
    {0xEF42, 0x97D5}, //11779 #CJK UNIFIED IDEOGRAPH
    {0xEF43, 0x97D4}, //11780 #CJK UNIFIED IDEOGRAPH
    {0xEF44, 0x97F1}, //11781 #CJK UNIFIED IDEOGRAPH
    {0xEF45, 0x9841}, //11782 #CJK UNIFIED IDEOGRAPH
    {0xEF46, 0x9844}, //11783 #CJK UNIFIED IDEOGRAPH
    {0xEF47, 0x984A}, //11784 #CJK UNIFIED IDEOGRAPH
    {0xEF48, 0x9849}, //11785 #CJK UNIFIED IDEOGRAPH
    {0xEF49, 0x9845}, //11786 #CJK UNIFIED IDEOGRAPH
    {0xEF4A, 0x9843}, //11787 #CJK UNIFIED IDEOGRAPH
    {0xEF4B, 0x9925}, //11788 #CJK UNIFIED IDEOGRAPH
    {0xEF4C, 0x992B}, //11789 #CJK UNIFIED IDEOGRAPH
    {0xEF4D, 0x992C}, //11790 #CJK UNIFIED IDEOGRAPH
    {0xEF4E, 0x992A}, //11791 #CJK UNIFIED IDEOGRAPH
    {0xEF4F, 0x9933}, //11792 #CJK UNIFIED IDEOGRAPH
    {0xEF50, 0x9932}, //11793 #CJK UNIFIED IDEOGRAPH
    {0xEF51, 0x992F}, //11794 #CJK UNIFIED IDEOGRAPH
    {0xEF52, 0x992D}, //11795 #CJK UNIFIED IDEOGRAPH
    {0xEF53, 0x9931}, //11796 #CJK UNIFIED IDEOGRAPH
    {0xEF54, 0x9930}, //11797 #CJK UNIFIED IDEOGRAPH
    {0xEF55, 0x9998}, //11798 #CJK UNIFIED IDEOGRAPH
    {0xEF56, 0x99A3}, //11799 #CJK UNIFIED IDEOGRAPH
    {0xEF57, 0x99A1}, //11800 #CJK UNIFIED IDEOGRAPH
    {0xEF58, 0x9A02}, //11801 #CJK UNIFIED IDEOGRAPH
    {0xEF59, 0x99FA}, //11802 #CJK UNIFIED IDEOGRAPH
    {0xEF5A, 0x99F4}, //11803 #CJK UNIFIED IDEOGRAPH
    {0xEF5B, 0x99F7}, //11804 #CJK UNIFIED IDEOGRAPH
    {0xEF5C, 0x99F9}, //11805 #CJK UNIFIED IDEOGRAPH
    {0xEF5D, 0x99F8}, //11806 #CJK UNIFIED IDEOGRAPH
    {0xEF5E, 0x99F6}, //11807 #CJK UNIFIED IDEOGRAPH
    {0xEF5F, 0x99FB}, //11808 #CJK UNIFIED IDEOGRAPH
    {0xEF60, 0x99FD}, //11809 #CJK UNIFIED IDEOGRAPH
    {0xEF61, 0x99FE}, //11810 #CJK UNIFIED IDEOGRAPH
    {0xEF62, 0x99FC}, //11811 #CJK UNIFIED IDEOGRAPH
    {0xEF63, 0x9A03}, //11812 #CJK UNIFIED IDEOGRAPH
    {0xEF64, 0x9ABE}, //11813 #CJK UNIFIED IDEOGRAPH
    {0xEF65, 0x9AFE}, //11814 #CJK UNIFIED IDEOGRAPH
    {0xEF66, 0x9AFD}, //11815 #CJK UNIFIED IDEOGRAPH
    {0xEF67, 0x9B01}, //11816 #CJK UNIFIED IDEOGRAPH
    {0xEF68, 0x9AFC}, //11817 #CJK UNIFIED IDEOGRAPH
    {0xEF69, 0x9B48}, //11818 #CJK UNIFIED IDEOGRAPH
    {0xEF6A, 0x9B9A}, //11819 #CJK UNIFIED IDEOGRAPH
    {0xEF6B, 0x9BA8}, //11820 #CJK UNIFIED IDEOGRAPH
    {0xEF6C, 0x9B9E}, //11821 #CJK UNIFIED IDEOGRAPH
    {0xEF6D, 0x9B9B}, //11822 #CJK UNIFIED IDEOGRAPH
    {0xEF6E, 0x9BA6}, //11823 #CJK UNIFIED IDEOGRAPH
    {0xEF6F, 0x9BA1}, //11824 #CJK UNIFIED IDEOGRAPH
    {0xEF70, 0x9BA5}, //11825 #CJK UNIFIED IDEOGRAPH
    {0xEF71, 0x9BA4}, //11826 #CJK UNIFIED IDEOGRAPH
    {0xEF72, 0x9B86}, //11827 #CJK UNIFIED IDEOGRAPH
    {0xEF73, 0x9BA2}, //11828 #CJK UNIFIED IDEOGRAPH
    {0xEF74, 0x9BA0}, //11829 #CJK UNIFIED IDEOGRAPH
    {0xEF75, 0x9BAF}, //11830 #CJK UNIFIED IDEOGRAPH
    {0xEF76, 0x9D33}, //11831 #CJK UNIFIED IDEOGRAPH
    {0xEF77, 0x9D41}, //11832 #CJK UNIFIED IDEOGRAPH
    {0xEF78, 0x9D67}, //11833 #CJK UNIFIED IDEOGRAPH
    {0xEF79, 0x9D36}, //11834 #CJK UNIFIED IDEOGRAPH
    {0xEF7A, 0x9D2E}, //11835 #CJK UNIFIED IDEOGRAPH
    {0xEF7B, 0x9D2F}, //11836 #CJK UNIFIED IDEOGRAPH
    {0xEF7C, 0x9D31}, //11837 #CJK UNIFIED IDEOGRAPH
    {0xEF7D, 0x9D38}, //11838 #CJK UNIFIED IDEOGRAPH
    {0xEF7E, 0x9D30}, //11839 #CJK UNIFIED IDEOGRAPH
    {0xEFA1, 0x9D45}, //11840 #CJK UNIFIED IDEOGRAPH
    {0xEFA2, 0x9D42}, //11841 #CJK UNIFIED IDEOGRAPH
    {0xEFA3, 0x9D43}, //11842 #CJK UNIFIED IDEOGRAPH
    {0xEFA4, 0x9D3E}, //11843 #CJK UNIFIED IDEOGRAPH
    {0xEFA5, 0x9D37}, //11844 #CJK UNIFIED IDEOGRAPH
    {0xEFA6, 0x9D40}, //11845 #CJK UNIFIED IDEOGRAPH
    {0xEFA7, 0x9D3D}, //11846 #CJK UNIFIED IDEOGRAPH
    {0xEFA8, 0x7FF5}, //11847 #CJK UNIFIED IDEOGRAPH
    {0xEFA9, 0x9D2D}, //11848 #CJK UNIFIED IDEOGRAPH
    {0xEFAA, 0x9E8A}, //11849 #CJK UNIFIED IDEOGRAPH
    {0xEFAB, 0x9E89}, //11850 #CJK UNIFIED IDEOGRAPH
    {0xEFAC, 0x9E8D}, //11851 #CJK UNIFIED IDEOGRAPH
    {0xEFAD, 0x9EB0}, //11852 #CJK UNIFIED IDEOGRAPH
    {0xEFAE, 0x9EC8}, //11853 #CJK UNIFIED IDEOGRAPH
    {0xEFAF, 0x9EDA}, //11854 #CJK UNIFIED IDEOGRAPH
    {0xEFB0, 0x9EFB}, //11855 #CJK UNIFIED IDEOGRAPH
    {0xEFB1, 0x9EFF}, //11856 #CJK UNIFIED IDEOGRAPH
    {0xEFB2, 0x9F24}, //11857 #CJK UNIFIED IDEOGRAPH
    {0xEFB3, 0x9F23}, //11858 #CJK UNIFIED IDEOGRAPH
    {0xEFB4, 0x9F22}, //11859 #CJK UNIFIED IDEOGRAPH
    {0xEFB5, 0x9F54}, //11860 #CJK UNIFIED IDEOGRAPH
    {0xEFB6, 0x9FA0}, //11861 #CJK UNIFIED IDEOGRAPH
    {0xEFB7, 0x5131}, //11862 #CJK UNIFIED IDEOGRAPH
    {0xEFB8, 0x512D}, //11863 #CJK UNIFIED IDEOGRAPH
    {0xEFB9, 0x512E}, //11864 #CJK UNIFIED IDEOGRAPH
    {0xEFBA, 0x5698}, //11865 #CJK UNIFIED IDEOGRAPH
    {0xEFBB, 0x569C}, //11866 #CJK UNIFIED IDEOGRAPH
    {0xEFBC, 0x5697}, //11867 #CJK UNIFIED IDEOGRAPH
    {0xEFBD, 0x569A}, //11868 #CJK UNIFIED IDEOGRAPH
    {0xEFBE, 0x569D}, //11869 #CJK UNIFIED IDEOGRAPH
    {0xEFBF, 0x5699}, //11870 #CJK UNIFIED IDEOGRAPH
    {0xEFC0, 0x5970}, //11871 #CJK UNIFIED IDEOGRAPH
    {0xEFC1, 0x5B3C}, //11872 #CJK UNIFIED IDEOGRAPH
    {0xEFC2, 0x5C69}, //11873 #CJK UNIFIED IDEOGRAPH
    {0xEFC3, 0x5C6A}, //11874 #CJK UNIFIED IDEOGRAPH
    {0xEFC4, 0x5DC0}, //11875 #CJK UNIFIED IDEOGRAPH
    {0xEFC5, 0x5E6D}, //11876 #CJK UNIFIED IDEOGRAPH
    {0xEFC6, 0x5E6E}, //11877 #CJK UNIFIED IDEOGRAPH
    {0xEFC7, 0x61D8}, //11878 #CJK UNIFIED IDEOGRAPH
    {0xEFC8, 0x61DF}, //11879 #CJK UNIFIED IDEOGRAPH
    {0xEFC9, 0x61ED}, //11880 #CJK UNIFIED IDEOGRAPH
    {0xEFCA, 0x61EE}, //11881 #CJK UNIFIED IDEOGRAPH
    {0xEFCB, 0x61F1}, //11882 #CJK UNIFIED IDEOGRAPH
    {0xEFCC, 0x61EA}, //11883 #CJK UNIFIED IDEOGRAPH
    {0xEFCD, 0x61F0}, //11884 #CJK UNIFIED IDEOGRAPH
    {0xEFCE, 0x61EB}, //11885 #CJK UNIFIED IDEOGRAPH
    {0xEFCF, 0x61D6}, //11886 #CJK UNIFIED IDEOGRAPH
    {0xEFD0, 0x61E9}, //11887 #CJK UNIFIED IDEOGRAPH
    {0xEFD1, 0x64FF}, //11888 #CJK UNIFIED IDEOGRAPH
    {0xEFD2, 0x6504}, //11889 #CJK UNIFIED IDEOGRAPH
    {0xEFD3, 0x64FD}, //11890 #CJK UNIFIED IDEOGRAPH
    {0xEFD4, 0x64F8}, //11891 #CJK UNIFIED IDEOGRAPH
    {0xEFD5, 0x6501}, //11892 #CJK UNIFIED IDEOGRAPH
    {0xEFD6, 0x6503}, //11893 #CJK UNIFIED IDEOGRAPH
    {0xEFD7, 0x64FC}, //11894 #CJK UNIFIED IDEOGRAPH
    {0xEFD8, 0x6594}, //11895 #CJK UNIFIED IDEOGRAPH
    {0xEFD9, 0x65DB}, //11896 #CJK UNIFIED IDEOGRAPH
    {0xEFDA, 0x66DA}, //11897 #CJK UNIFIED IDEOGRAPH
    {0xEFDB, 0x66DB}, //11898 #CJK UNIFIED IDEOGRAPH
    {0xEFDC, 0x66D8}, //11899 #CJK UNIFIED IDEOGRAPH
    {0xEFDD, 0x6AC5}, //11900 #CJK UNIFIED IDEOGRAPH
    {0xEFDE, 0x6AB9}, //11901 #CJK UNIFIED IDEOGRAPH
    {0xEFDF, 0x6ABD}, //11902 #CJK UNIFIED IDEOGRAPH
    {0xEFE0, 0x6AE1}, //11903 #CJK UNIFIED IDEOGRAPH
    {0xEFE1, 0x6AC6}, //11904 #CJK UNIFIED IDEOGRAPH
    {0xEFE2, 0x6ABA}, //11905 #CJK UNIFIED IDEOGRAPH
    {0xEFE3, 0x6AB6}, //11906 #CJK UNIFIED IDEOGRAPH
    {0xEFE4, 0x6AB7}, //11907 #CJK UNIFIED IDEOGRAPH
    {0xEFE5, 0x6AC7}, //11908 #CJK UNIFIED IDEOGRAPH
    {0xEFE6, 0x6AB4}, //11909 #CJK UNIFIED IDEOGRAPH
    {0xEFE7, 0x6AAD}, //11910 #CJK UNIFIED IDEOGRAPH
    {0xEFE8, 0x6B5E}, //11911 #CJK UNIFIED IDEOGRAPH
    {0xEFE9, 0x6BC9}, //11912 #CJK UNIFIED IDEOGRAPH
    {0xEFEA, 0x6C0B}, //11913 #CJK UNIFIED IDEOGRAPH
    {0xEFEB, 0x7007}, //11914 #CJK UNIFIED IDEOGRAPH
    {0xEFEC, 0x700C}, //11915 #CJK UNIFIED IDEOGRAPH
    {0xEFED, 0x700D}, //11916 #CJK UNIFIED IDEOGRAPH
    {0xEFEE, 0x7001}, //11917 #CJK UNIFIED IDEOGRAPH
    {0xEFEF, 0x7005}, //11918 #CJK UNIFIED IDEOGRAPH
    {0xEFF0, 0x7014}, //11919 #CJK UNIFIED IDEOGRAPH
    {0xEFF1, 0x700E}, //11920 #CJK UNIFIED IDEOGRAPH
    {0xEFF2, 0x6FFF}, //11921 #CJK UNIFIED IDEOGRAPH
    {0xEFF3, 0x7000}, //11922 #CJK UNIFIED IDEOGRAPH
    {0xEFF4, 0x6FFB}, //11923 #CJK UNIFIED IDEOGRAPH
    {0xEFF5, 0x7026}, //11924 #CJK UNIFIED IDEOGRAPH
    {0xEFF6, 0x6FFC}, //11925 #CJK UNIFIED IDEOGRAPH
    {0xEFF7, 0x6FF7}, //11926 #CJK UNIFIED IDEOGRAPH
    {0xEFF8, 0x700A}, //11927 #CJK UNIFIED IDEOGRAPH
    {0xEFF9, 0x7201}, //11928 #CJK UNIFIED IDEOGRAPH
    {0xEFFA, 0x71FF}, //11929 #CJK UNIFIED IDEOGRAPH
    {0xEFFB, 0x71F9}, //11930 #CJK UNIFIED IDEOGRAPH
    {0xEFFC, 0x7203}, //11931 #CJK UNIFIED IDEOGRAPH
    {0xEFFD, 0x71FD}, //11932 #CJK UNIFIED IDEOGRAPH
    {0xEFFE, 0x7376}, //11933 #CJK UNIFIED IDEOGRAPH
    {0xF040, 0x74B8}, //11934 #CJK UNIFIED IDEOGRAPH
    {0xF041, 0x74C0}, //11935 #CJK UNIFIED IDEOGRAPH
    {0xF042, 0x74B5}, //11936 #CJK UNIFIED IDEOGRAPH
    {0xF043, 0x74C1}, //11937 #CJK UNIFIED IDEOGRAPH
    {0xF044, 0x74BE}, //11938 #CJK UNIFIED IDEOGRAPH
    {0xF045, 0x74B6}, //11939 #CJK UNIFIED IDEOGRAPH
    {0xF046, 0x74BB}, //11940 #CJK UNIFIED IDEOGRAPH
    {0xF047, 0x74C2}, //11941 #CJK UNIFIED IDEOGRAPH
    {0xF048, 0x7514}, //11942 #CJK UNIFIED IDEOGRAPH
    {0xF049, 0x7513}, //11943 #CJK UNIFIED IDEOGRAPH
    {0xF04A, 0x765C}, //11944 #CJK UNIFIED IDEOGRAPH
    {0xF04B, 0x7664}, //11945 #CJK UNIFIED IDEOGRAPH
    {0xF04C, 0x7659}, //11946 #CJK UNIFIED IDEOGRAPH
    {0xF04D, 0x7650}, //11947 #CJK UNIFIED IDEOGRAPH
    {0xF04E, 0x7653}, //11948 #CJK UNIFIED IDEOGRAPH
    {0xF04F, 0x7657}, //11949 #CJK UNIFIED IDEOGRAPH
    {0xF050, 0x765A}, //11950 #CJK UNIFIED IDEOGRAPH
    {0xF051, 0x76A6}, //11951 #CJK UNIFIED IDEOGRAPH
    {0xF052, 0x76BD}, //11952 #CJK UNIFIED IDEOGRAPH
    {0xF053, 0x76EC}, //11953 #CJK UNIFIED IDEOGRAPH
    {0xF054, 0x77C2}, //11954 #CJK UNIFIED IDEOGRAPH
    {0xF055, 0x77BA}, //11955 #CJK UNIFIED IDEOGRAPH
    {0xF056, 0x78FF}, //11956 #CJK UNIFIED IDEOGRAPH
    {0xF057, 0x790C}, //11957 #CJK UNIFIED IDEOGRAPH
    {0xF058, 0x7913}, //11958 #CJK UNIFIED IDEOGRAPH
    {0xF059, 0x7914}, //11959 #CJK UNIFIED IDEOGRAPH
    {0xF05A, 0x7909}, //11960 #CJK UNIFIED IDEOGRAPH
    {0xF05B, 0x7910}, //11961 #CJK UNIFIED IDEOGRAPH
    {0xF05C, 0x7912}, //11962 #CJK UNIFIED IDEOGRAPH
    {0xF05D, 0x7911}, //11963 #CJK UNIFIED IDEOGRAPH
    {0xF05E, 0x79AD}, //11964 #CJK UNIFIED IDEOGRAPH
    {0xF05F, 0x79AC}, //11965 #CJK UNIFIED IDEOGRAPH
    {0xF060, 0x7A5F}, //11966 #CJK UNIFIED IDEOGRAPH
    {0xF061, 0x7C1C}, //11967 #CJK UNIFIED IDEOGRAPH
    {0xF062, 0x7C29}, //11968 #CJK UNIFIED IDEOGRAPH
    {0xF063, 0x7C19}, //11969 #CJK UNIFIED IDEOGRAPH
    {0xF064, 0x7C20}, //11970 #CJK UNIFIED IDEOGRAPH
    {0xF065, 0x7C1F}, //11971 #CJK UNIFIED IDEOGRAPH
    {0xF066, 0x7C2D}, //11972 #CJK UNIFIED IDEOGRAPH
    {0xF067, 0x7C1D}, //11973 #CJK UNIFIED IDEOGRAPH
    {0xF068, 0x7C26}, //11974 #CJK UNIFIED IDEOGRAPH
    {0xF069, 0x7C28}, //11975 #CJK UNIFIED IDEOGRAPH
    {0xF06A, 0x7C22}, //11976 #CJK UNIFIED IDEOGRAPH
    {0xF06B, 0x7C25}, //11977 #CJK UNIFIED IDEOGRAPH
    {0xF06C, 0x7C30}, //11978 #CJK UNIFIED IDEOGRAPH
    {0xF06D, 0x7E5C}, //11979 #CJK UNIFIED IDEOGRAPH
    {0xF06E, 0x7E50}, //11980 #CJK UNIFIED IDEOGRAPH
    {0xF06F, 0x7E56}, //11981 #CJK UNIFIED IDEOGRAPH
    {0xF070, 0x7E63}, //11982 #CJK UNIFIED IDEOGRAPH
    {0xF071, 0x7E58}, //11983 #CJK UNIFIED IDEOGRAPH
    {0xF072, 0x7E62}, //11984 #CJK UNIFIED IDEOGRAPH
    {0xF073, 0x7E5F}, //11985 #CJK UNIFIED IDEOGRAPH
    {0xF074, 0x7E51}, //11986 #CJK UNIFIED IDEOGRAPH
    {0xF075, 0x7E60}, //11987 #CJK UNIFIED IDEOGRAPH
    {0xF076, 0x7E57}, //11988 #CJK UNIFIED IDEOGRAPH
    {0xF077, 0x7E53}, //11989 #CJK UNIFIED IDEOGRAPH
    {0xF078, 0x7FB5}, //11990 #CJK UNIFIED IDEOGRAPH
    {0xF079, 0x7FB3}, //11991 #CJK UNIFIED IDEOGRAPH
    {0xF07A, 0x7FF7}, //11992 #CJK UNIFIED IDEOGRAPH
    {0xF07B, 0x7FF8}, //11993 #CJK UNIFIED IDEOGRAPH
    {0xF07C, 0x8075}, //11994 #CJK UNIFIED IDEOGRAPH
    {0xF07D, 0x81D1}, //11995 #CJK UNIFIED IDEOGRAPH
    {0xF07E, 0x81D2}, //11996 #CJK UNIFIED IDEOGRAPH
    {0xF0A1, 0x81D0}, //11997 #CJK UNIFIED IDEOGRAPH
    {0xF0A2, 0x825F}, //11998 #CJK UNIFIED IDEOGRAPH
    {0xF0A3, 0x825E}, //11999 #CJK UNIFIED IDEOGRAPH
    {0xF0A4, 0x85B4}, //12000 #CJK UNIFIED IDEOGRAPH
    {0xF0A5, 0x85C6}, //12001 #CJK UNIFIED IDEOGRAPH
    {0xF0A6, 0x85C0}, //12002 #CJK UNIFIED IDEOGRAPH
    {0xF0A7, 0x85C3}, //12003 #CJK UNIFIED IDEOGRAPH
    {0xF0A8, 0x85C2}, //12004 #CJK UNIFIED IDEOGRAPH
    {0xF0A9, 0x85B3}, //12005 #CJK UNIFIED IDEOGRAPH
    {0xF0AA, 0x85B5}, //12006 #CJK UNIFIED IDEOGRAPH
    {0xF0AB, 0x85BD}, //12007 #CJK UNIFIED IDEOGRAPH
    {0xF0AC, 0x85C7}, //12008 #CJK UNIFIED IDEOGRAPH
    {0xF0AD, 0x85C4}, //12009 #CJK UNIFIED IDEOGRAPH
    {0xF0AE, 0x85BF}, //12010 #CJK UNIFIED IDEOGRAPH
    {0xF0AF, 0x85CB}, //12011 #CJK UNIFIED IDEOGRAPH
    {0xF0B0, 0x85CE}, //12012 #CJK UNIFIED IDEOGRAPH
    {0xF0B1, 0x85C8}, //12013 #CJK UNIFIED IDEOGRAPH
    {0xF0B2, 0x85C5}, //12014 #CJK UNIFIED IDEOGRAPH
    {0xF0B3, 0x85B1}, //12015 #CJK UNIFIED IDEOGRAPH
    {0xF0B4, 0x85B6}, //12016 #CJK UNIFIED IDEOGRAPH
    {0xF0B5, 0x85D2}, //12017 #CJK UNIFIED IDEOGRAPH
    {0xF0B6, 0x8624}, //12018 #CJK UNIFIED IDEOGRAPH
    {0xF0B7, 0x85B8}, //12019 #CJK UNIFIED IDEOGRAPH
    {0xF0B8, 0x85B7}, //12020 #CJK UNIFIED IDEOGRAPH
    {0xF0B9, 0x85BE}, //12021 #CJK UNIFIED IDEOGRAPH
    {0xF0BA, 0x8669}, //12022 #CJK UNIFIED IDEOGRAPH
    {0xF0BB, 0x87E7}, //12023 #CJK UNIFIED IDEOGRAPH
    {0xF0BC, 0x87E6}, //12024 #CJK UNIFIED IDEOGRAPH
    {0xF0BD, 0x87E2}, //12025 #CJK UNIFIED IDEOGRAPH
    {0xF0BE, 0x87DB}, //12026 #CJK UNIFIED IDEOGRAPH
    {0xF0BF, 0x87EB}, //12027 #CJK UNIFIED IDEOGRAPH
    {0xF0C0, 0x87EA}, //12028 #CJK UNIFIED IDEOGRAPH
    {0xF0C1, 0x87E5}, //12029 #CJK UNIFIED IDEOGRAPH
    {0xF0C2, 0x87DF}, //12030 #CJK UNIFIED IDEOGRAPH
    {0xF0C3, 0x87F3}, //12031 #CJK UNIFIED IDEOGRAPH
    {0xF0C4, 0x87E4}, //12032 #CJK UNIFIED IDEOGRAPH
    {0xF0C5, 0x87D4}, //12033 #CJK UNIFIED IDEOGRAPH
    {0xF0C6, 0x87DC}, //12034 #CJK UNIFIED IDEOGRAPH
    {0xF0C7, 0x87D3}, //12035 #CJK UNIFIED IDEOGRAPH
    {0xF0C8, 0x87ED}, //12036 #CJK UNIFIED IDEOGRAPH
    {0xF0C9, 0x87D8}, //12037 #CJK UNIFIED IDEOGRAPH
    {0xF0CA, 0x87E3}, //12038 #CJK UNIFIED IDEOGRAPH
    {0xF0CB, 0x87A4}, //12039 #CJK UNIFIED IDEOGRAPH
    {0xF0CC, 0x87D7}, //12040 #CJK UNIFIED IDEOGRAPH
    {0xF0CD, 0x87D9}, //12041 #CJK UNIFIED IDEOGRAPH
    {0xF0CE, 0x8801}, //12042 #CJK UNIFIED IDEOGRAPH
    {0xF0CF, 0x87F4}, //12043 #CJK UNIFIED IDEOGRAPH
    {0xF0D0, 0x87E8}, //12044 #CJK UNIFIED IDEOGRAPH
    {0xF0D1, 0x87DD}, //12045 #CJK UNIFIED IDEOGRAPH
    {0xF0D2, 0x8953}, //12046 #CJK UNIFIED IDEOGRAPH
    {0xF0D3, 0x894B}, //12047 #CJK UNIFIED IDEOGRAPH
    {0xF0D4, 0x894F}, //12048 #CJK UNIFIED IDEOGRAPH
    {0xF0D5, 0x894C}, //12049 #CJK UNIFIED IDEOGRAPH
    {0xF0D6, 0x8946}, //12050 #CJK UNIFIED IDEOGRAPH
    {0xF0D7, 0x8950}, //12051 #CJK UNIFIED IDEOGRAPH
    {0xF0D8, 0x8951}, //12052 #CJK UNIFIED IDEOGRAPH
    {0xF0D9, 0x8949}, //12053 #CJK UNIFIED IDEOGRAPH
    {0xF0DA, 0x8B2A}, //12054 #CJK UNIFIED IDEOGRAPH
    {0xF0DB, 0x8B27}, //12055 #CJK UNIFIED IDEOGRAPH
    {0xF0DC, 0x8B23}, //12056 #CJK UNIFIED IDEOGRAPH
    {0xF0DD, 0x8B33}, //12057 #CJK UNIFIED IDEOGRAPH
    {0xF0DE, 0x8B30}, //12058 #CJK UNIFIED IDEOGRAPH
    {0xF0DF, 0x8B35}, //12059 #CJK UNIFIED IDEOGRAPH
    {0xF0E0, 0x8B47}, //12060 #CJK UNIFIED IDEOGRAPH
    {0xF0E1, 0x8B2F}, //12061 #CJK UNIFIED IDEOGRAPH
    {0xF0E2, 0x8B3C}, //12062 #CJK UNIFIED IDEOGRAPH
    {0xF0E3, 0x8B3E}, //12063 #CJK UNIFIED IDEOGRAPH
    {0xF0E4, 0x8B31}, //12064 #CJK UNIFIED IDEOGRAPH
    {0xF0E5, 0x8B25}, //12065 #CJK UNIFIED IDEOGRAPH
    {0xF0E6, 0x8B37}, //12066 #CJK UNIFIED IDEOGRAPH
    {0xF0E7, 0x8B26}, //12067 #CJK UNIFIED IDEOGRAPH
    {0xF0E8, 0x8B36}, //12068 #CJK UNIFIED IDEOGRAPH
    {0xF0E9, 0x8B2E}, //12069 #CJK UNIFIED IDEOGRAPH
    {0xF0EA, 0x8B24}, //12070 #CJK UNIFIED IDEOGRAPH
    {0xF0EB, 0x8B3B}, //12071 #CJK UNIFIED IDEOGRAPH
    {0xF0EC, 0x8B3D}, //12072 #CJK UNIFIED IDEOGRAPH
    {0xF0ED, 0x8B3A}, //12073 #CJK UNIFIED IDEOGRAPH
    {0xF0EE, 0x8C42}, //12074 #CJK UNIFIED IDEOGRAPH
    {0xF0EF, 0x8C75}, //12075 #CJK UNIFIED IDEOGRAPH
    {0xF0F0, 0x8C99}, //12076 #CJK UNIFIED IDEOGRAPH
    {0xF0F1, 0x8C98}, //12077 #CJK UNIFIED IDEOGRAPH
    {0xF0F2, 0x8C97}, //12078 #CJK UNIFIED IDEOGRAPH
    {0xF0F3, 0x8CFE}, //12079 #CJK UNIFIED IDEOGRAPH
    {0xF0F4, 0x8D04}, //12080 #CJK UNIFIED IDEOGRAPH
    {0xF0F5, 0x8D02}, //12081 #CJK UNIFIED IDEOGRAPH
    {0xF0F6, 0x8D00}, //12082 #CJK UNIFIED IDEOGRAPH
    {0xF0F7, 0x8E5C}, //12083 #CJK UNIFIED IDEOGRAPH
    {0xF0F8, 0x8E62}, //12084 #CJK UNIFIED IDEOGRAPH
    {0xF0F9, 0x8E60}, //12085 #CJK UNIFIED IDEOGRAPH
    {0xF0FA, 0x8E57}, //12086 #CJK UNIFIED IDEOGRAPH
    {0xF0FB, 0x8E56}, //12087 #CJK UNIFIED IDEOGRAPH
    {0xF0FC, 0x8E5E}, //12088 #CJK UNIFIED IDEOGRAPH
    {0xF0FD, 0x8E65}, //12089 #CJK UNIFIED IDEOGRAPH
    {0xF0FE, 0x8E67}, //12090 #CJK UNIFIED IDEOGRAPH
    {0xF140, 0x8E5B}, //12091 #CJK UNIFIED IDEOGRAPH
    {0xF141, 0x8E5A}, //12092 #CJK UNIFIED IDEOGRAPH
    {0xF142, 0x8E61}, //12093 #CJK UNIFIED IDEOGRAPH
    {0xF143, 0x8E5D}, //12094 #CJK UNIFIED IDEOGRAPH
    {0xF144, 0x8E69}, //12095 #CJK UNIFIED IDEOGRAPH
    {0xF145, 0x8E54}, //12096 #CJK UNIFIED IDEOGRAPH
    {0xF146, 0x8F46}, //12097 #CJK UNIFIED IDEOGRAPH
    {0xF147, 0x8F47}, //12098 #CJK UNIFIED IDEOGRAPH
    {0xF148, 0x8F48}, //12099 #CJK UNIFIED IDEOGRAPH
    {0xF149, 0x8F4B}, //12100 #CJK UNIFIED IDEOGRAPH
    {0xF14A, 0x9128}, //12101 #CJK UNIFIED IDEOGRAPH
    {0xF14B, 0x913A}, //12102 #CJK UNIFIED IDEOGRAPH
    {0xF14C, 0x913B}, //12103 #CJK UNIFIED IDEOGRAPH
    {0xF14D, 0x913E}, //12104 #CJK UNIFIED IDEOGRAPH
    {0xF14E, 0x91A8}, //12105 #CJK UNIFIED IDEOGRAPH
    {0xF14F, 0x91A5}, //12106 #CJK UNIFIED IDEOGRAPH
    {0xF150, 0x91A7}, //12107 #CJK UNIFIED IDEOGRAPH
    {0xF151, 0x91AF}, //12108 #CJK UNIFIED IDEOGRAPH
    {0xF152, 0x91AA}, //12109 #CJK UNIFIED IDEOGRAPH
    {0xF153, 0x93B5}, //12110 #CJK UNIFIED IDEOGRAPH
    {0xF154, 0x938C}, //12111 #CJK UNIFIED IDEOGRAPH
    {0xF155, 0x9392}, //12112 #CJK UNIFIED IDEOGRAPH
    {0xF156, 0x93B7}, //12113 #CJK UNIFIED IDEOGRAPH
    {0xF157, 0x939B}, //12114 #CJK UNIFIED IDEOGRAPH
    {0xF158, 0x939D}, //12115 #CJK UNIFIED IDEOGRAPH
    {0xF159, 0x9389}, //12116 #CJK UNIFIED IDEOGRAPH
    {0xF15A, 0x93A7}, //12117 #CJK UNIFIED IDEOGRAPH
    {0xF15B, 0x938E}, //12118 #CJK UNIFIED IDEOGRAPH
    {0xF15C, 0x93AA}, //12119 #CJK UNIFIED IDEOGRAPH
    {0xF15D, 0x939E}, //12120 #CJK UNIFIED IDEOGRAPH
    {0xF15E, 0x93A6}, //12121 #CJK UNIFIED IDEOGRAPH
    {0xF15F, 0x9395}, //12122 #CJK UNIFIED IDEOGRAPH
    {0xF160, 0x9388}, //12123 #CJK UNIFIED IDEOGRAPH
    {0xF161, 0x9399}, //12124 #CJK UNIFIED IDEOGRAPH
    {0xF162, 0x939F}, //12125 #CJK UNIFIED IDEOGRAPH
    {0xF163, 0x938D}, //12126 #CJK UNIFIED IDEOGRAPH
    {0xF164, 0x93B1}, //12127 #CJK UNIFIED IDEOGRAPH
    {0xF165, 0x9391}, //12128 #CJK UNIFIED IDEOGRAPH
    {0xF166, 0x93B2}, //12129 #CJK UNIFIED IDEOGRAPH
    {0xF167, 0x93A4}, //12130 #CJK UNIFIED IDEOGRAPH
    {0xF168, 0x93A8}, //12131 #CJK UNIFIED IDEOGRAPH
    {0xF169, 0x93B4}, //12132 #CJK UNIFIED IDEOGRAPH
    {0xF16A, 0x93A3}, //12133 #CJK UNIFIED IDEOGRAPH
    {0xF16B, 0x93A5}, //12134 #CJK UNIFIED IDEOGRAPH
    {0xF16C, 0x95D2}, //12135 #CJK UNIFIED IDEOGRAPH
    {0xF16D, 0x95D3}, //12136 #CJK UNIFIED IDEOGRAPH
    {0xF16E, 0x95D1}, //12137 #CJK UNIFIED IDEOGRAPH
    {0xF16F, 0x96B3}, //12138 #CJK UNIFIED IDEOGRAPH
    {0xF170, 0x96D7}, //12139 #CJK UNIFIED IDEOGRAPH
    {0xF171, 0x96DA}, //12140 #CJK UNIFIED IDEOGRAPH
    {0xF172, 0x5DC2}, //12141 #CJK UNIFIED IDEOGRAPH
    {0xF173, 0x96DF}, //12142 #CJK UNIFIED IDEOGRAPH
    {0xF174, 0x96D8}, //12143 #CJK UNIFIED IDEOGRAPH
    {0xF175, 0x96DD}, //12144 #CJK UNIFIED IDEOGRAPH
    {0xF176, 0x9723}, //12145 #CJK UNIFIED IDEOGRAPH
    {0xF177, 0x9722}, //12146 #CJK UNIFIED IDEOGRAPH
    {0xF178, 0x9725}, //12147 #CJK UNIFIED IDEOGRAPH
    {0xF179, 0x97AC}, //12148 #CJK UNIFIED IDEOGRAPH
    {0xF17A, 0x97AE}, //12149 #CJK UNIFIED IDEOGRAPH
    {0xF17B, 0x97A8}, //12150 #CJK UNIFIED IDEOGRAPH
    {0xF17C, 0x97AB}, //12151 #CJK UNIFIED IDEOGRAPH
    {0xF17D, 0x97A4}, //12152 #CJK UNIFIED IDEOGRAPH
    {0xF17E, 0x97AA}, //12153 #CJK UNIFIED IDEOGRAPH
    {0xF1A1, 0x97A2}, //12154 #CJK UNIFIED IDEOGRAPH
    {0xF1A2, 0x97A5}, //12155 #CJK UNIFIED IDEOGRAPH
    {0xF1A3, 0x97D7}, //12156 #CJK UNIFIED IDEOGRAPH
    {0xF1A4, 0x97D9}, //12157 #CJK UNIFIED IDEOGRAPH
    {0xF1A5, 0x97D6}, //12158 #CJK UNIFIED IDEOGRAPH
    {0xF1A6, 0x97D8}, //12159 #CJK UNIFIED IDEOGRAPH
    {0xF1A7, 0x97FA}, //12160 #CJK UNIFIED IDEOGRAPH
    {0xF1A8, 0x9850}, //12161 #CJK UNIFIED IDEOGRAPH
    {0xF1A9, 0x9851}, //12162 #CJK UNIFIED IDEOGRAPH
    {0xF1AA, 0x9852}, //12163 #CJK UNIFIED IDEOGRAPH
    {0xF1AB, 0x98B8}, //12164 #CJK UNIFIED IDEOGRAPH
    {0xF1AC, 0x9941}, //12165 #CJK UNIFIED IDEOGRAPH
    {0xF1AD, 0x993C}, //12166 #CJK UNIFIED IDEOGRAPH
    {0xF1AE, 0x993A}, //12167 #CJK UNIFIED IDEOGRAPH
    {0xF1AF, 0x9A0F}, //12168 #CJK UNIFIED IDEOGRAPH
    {0xF1B0, 0x9A0B}, //12169 #CJK UNIFIED IDEOGRAPH
    {0xF1B1, 0x9A09}, //12170 #CJK UNIFIED IDEOGRAPH
    {0xF1B2, 0x9A0D}, //12171 #CJK UNIFIED IDEOGRAPH
    {0xF1B3, 0x9A04}, //12172 #CJK UNIFIED IDEOGRAPH
    {0xF1B4, 0x9A11}, //12173 #CJK UNIFIED IDEOGRAPH
    {0xF1B5, 0x9A0A}, //12174 #CJK UNIFIED IDEOGRAPH
    {0xF1B6, 0x9A05}, //12175 #CJK UNIFIED IDEOGRAPH
    {0xF1B7, 0x9A07}, //12176 #CJK UNIFIED IDEOGRAPH
    {0xF1B8, 0x9A06}, //12177 #CJK UNIFIED IDEOGRAPH
    {0xF1B9, 0x9AC0}, //12178 #CJK UNIFIED IDEOGRAPH
    {0xF1BA, 0x9ADC}, //12179 #CJK UNIFIED IDEOGRAPH
    {0xF1BB, 0x9B08}, //12180 #CJK UNIFIED IDEOGRAPH
    {0xF1BC, 0x9B04}, //12181 #CJK UNIFIED IDEOGRAPH
    {0xF1BD, 0x9B05}, //12182 #CJK UNIFIED IDEOGRAPH
    {0xF1BE, 0x9B29}, //12183 #CJK UNIFIED IDEOGRAPH
    {0xF1BF, 0x9B35}, //12184 #CJK UNIFIED IDEOGRAPH
    {0xF1C0, 0x9B4A}, //12185 #CJK UNIFIED IDEOGRAPH
    {0xF1C1, 0x9B4C}, //12186 #CJK UNIFIED IDEOGRAPH
    {0xF1C2, 0x9B4B}, //12187 #CJK UNIFIED IDEOGRAPH
    {0xF1C3, 0x9BC7}, //12188 #CJK UNIFIED IDEOGRAPH
    {0xF1C4, 0x9BC6}, //12189 #CJK UNIFIED IDEOGRAPH
    {0xF1C5, 0x9BC3}, //12190 #CJK UNIFIED IDEOGRAPH
    {0xF1C6, 0x9BBF}, //12191 #CJK UNIFIED IDEOGRAPH
    {0xF1C7, 0x9BC1}, //12192 #CJK UNIFIED IDEOGRAPH
    {0xF1C8, 0x9BB5}, //12193 #CJK UNIFIED IDEOGRAPH
    {0xF1C9, 0x9BB8}, //12194 #CJK UNIFIED IDEOGRAPH
    {0xF1CA, 0x9BD3}, //12195 #CJK UNIFIED IDEOGRAPH
    {0xF1CB, 0x9BB6}, //12196 #CJK UNIFIED IDEOGRAPH
    {0xF1CC, 0x9BC4}, //12197 #CJK UNIFIED IDEOGRAPH
    {0xF1CD, 0x9BB9}, //12198 #CJK UNIFIED IDEOGRAPH
    {0xF1CE, 0x9BBD}, //12199 #CJK UNIFIED IDEOGRAPH
    {0xF1CF, 0x9D5C}, //12200 #CJK UNIFIED IDEOGRAPH
    {0xF1D0, 0x9D53}, //12201 #CJK UNIFIED IDEOGRAPH
    {0xF1D1, 0x9D4F}, //12202 #CJK UNIFIED IDEOGRAPH
    {0xF1D2, 0x9D4A}, //12203 #CJK UNIFIED IDEOGRAPH
    {0xF1D3, 0x9D5B}, //12204 #CJK UNIFIED IDEOGRAPH
    {0xF1D4, 0x9D4B}, //12205 #CJK UNIFIED IDEOGRAPH
    {0xF1D5, 0x9D59}, //12206 #CJK UNIFIED IDEOGRAPH
    {0xF1D6, 0x9D56}, //12207 #CJK UNIFIED IDEOGRAPH
    {0xF1D7, 0x9D4C}, //12208 #CJK UNIFIED IDEOGRAPH
    {0xF1D8, 0x9D57}, //12209 #CJK UNIFIED IDEOGRAPH
    {0xF1D9, 0x9D52}, //12210 #CJK UNIFIED IDEOGRAPH
    {0xF1DA, 0x9D54}, //12211 #CJK UNIFIED IDEOGRAPH
    {0xF1DB, 0x9D5F}, //12212 #CJK UNIFIED IDEOGRAPH
    {0xF1DC, 0x9D58}, //12213 #CJK UNIFIED IDEOGRAPH
    {0xF1DD, 0x9D5A}, //12214 #CJK UNIFIED IDEOGRAPH
    {0xF1DE, 0x9E8E}, //12215 #CJK UNIFIED IDEOGRAPH
    {0xF1DF, 0x9E8C}, //12216 #CJK UNIFIED IDEOGRAPH
    {0xF1E0, 0x9EDF}, //12217 #CJK UNIFIED IDEOGRAPH
    {0xF1E1, 0x9F01}, //12218 #CJK UNIFIED IDEOGRAPH
    {0xF1E2, 0x9F00}, //12219 #CJK UNIFIED IDEOGRAPH
    {0xF1E3, 0x9F16}, //12220 #CJK UNIFIED IDEOGRAPH
    {0xF1E4, 0x9F25}, //12221 #CJK UNIFIED IDEOGRAPH
    {0xF1E5, 0x9F2B}, //12222 #CJK UNIFIED IDEOGRAPH
    {0xF1E6, 0x9F2A}, //12223 #CJK UNIFIED IDEOGRAPH
    {0xF1E7, 0x9F29}, //12224 #CJK UNIFIED IDEOGRAPH
    {0xF1E8, 0x9F28}, //12225 #CJK UNIFIED IDEOGRAPH
    {0xF1E9, 0x9F4C}, //12226 #CJK UNIFIED IDEOGRAPH
    {0xF1EA, 0x9F55}, //12227 #CJK UNIFIED IDEOGRAPH
    {0xF1EB, 0x5134}, //12228 #CJK UNIFIED IDEOGRAPH
    {0xF1EC, 0x5135}, //12229 #CJK UNIFIED IDEOGRAPH
    {0xF1ED, 0x5296}, //12230 #CJK UNIFIED IDEOGRAPH
    {0xF1EE, 0x52F7}, //12231 #CJK UNIFIED IDEOGRAPH
    {0xF1EF, 0x53B4}, //12232 #CJK UNIFIED IDEOGRAPH
    {0xF1F0, 0x56AB}, //12233 #CJK UNIFIED IDEOGRAPH
    {0xF1F1, 0x56AD}, //12234 #CJK UNIFIED IDEOGRAPH
    {0xF1F2, 0x56A6}, //12235 #CJK UNIFIED IDEOGRAPH
    {0xF1F3, 0x56A7}, //12236 #CJK UNIFIED IDEOGRAPH
    {0xF1F4, 0x56AA}, //12237 #CJK UNIFIED IDEOGRAPH
    {0xF1F5, 0x56AC}, //12238 #CJK UNIFIED IDEOGRAPH
    {0xF1F6, 0x58DA}, //12239 #CJK UNIFIED IDEOGRAPH
    {0xF1F7, 0x58DD}, //12240 #CJK UNIFIED IDEOGRAPH
    {0xF1F8, 0x58DB}, //12241 #CJK UNIFIED IDEOGRAPH
    {0xF1F9, 0x5912}, //12242 #CJK UNIFIED IDEOGRAPH
    {0xF1FA, 0x5B3D}, //12243 #CJK UNIFIED IDEOGRAPH
    {0xF1FB, 0x5B3E}, //12244 #CJK UNIFIED IDEOGRAPH
    {0xF1FC, 0x5B3F}, //12245 #CJK UNIFIED IDEOGRAPH
    {0xF1FD, 0x5DC3}, //12246 #CJK UNIFIED IDEOGRAPH
    {0xF1FE, 0x5E70}, //12247 #CJK UNIFIED IDEOGRAPH
    {0xF240, 0x5FBF}, //12248 #CJK UNIFIED IDEOGRAPH
    {0xF241, 0x61FB}, //12249 #CJK UNIFIED IDEOGRAPH
    {0xF242, 0x6507}, //12250 #CJK UNIFIED IDEOGRAPH
    {0xF243, 0x6510}, //12251 #CJK UNIFIED IDEOGRAPH
    {0xF244, 0x650D}, //12252 #CJK UNIFIED IDEOGRAPH
    {0xF245, 0x6509}, //12253 #CJK UNIFIED IDEOGRAPH
    {0xF246, 0x650C}, //12254 #CJK UNIFIED IDEOGRAPH
    {0xF247, 0x650E}, //12255 #CJK UNIFIED IDEOGRAPH
    {0xF248, 0x6584}, //12256 #CJK UNIFIED IDEOGRAPH
    {0xF249, 0x65DE}, //12257 #CJK UNIFIED IDEOGRAPH
    {0xF24A, 0x65DD}, //12258 #CJK UNIFIED IDEOGRAPH
    {0xF24B, 0x66DE}, //12259 #CJK UNIFIED IDEOGRAPH
    {0xF24C, 0x6AE7}, //12260 #CJK UNIFIED IDEOGRAPH
    {0xF24D, 0x6AE0}, //12261 #CJK UNIFIED IDEOGRAPH
    {0xF24E, 0x6ACC}, //12262 #CJK UNIFIED IDEOGRAPH
    {0xF24F, 0x6AD1}, //12263 #CJK UNIFIED IDEOGRAPH
    {0xF250, 0x6AD9}, //12264 #CJK UNIFIED IDEOGRAPH
    {0xF251, 0x6ACB}, //12265 #CJK UNIFIED IDEOGRAPH
    {0xF252, 0x6ADF}, //12266 #CJK UNIFIED IDEOGRAPH
    {0xF253, 0x6ADC}, //12267 #CJK UNIFIED IDEOGRAPH
    {0xF254, 0x6AD0}, //12268 #CJK UNIFIED IDEOGRAPH
    {0xF255, 0x6AEB}, //12269 #CJK UNIFIED IDEOGRAPH
    {0xF256, 0x6ACF}, //12270 #CJK UNIFIED IDEOGRAPH
    {0xF257, 0x6ACD}, //12271 #CJK UNIFIED IDEOGRAPH
    {0xF258, 0x6ADE}, //12272 #CJK UNIFIED IDEOGRAPH
    {0xF259, 0x6B60}, //12273 #CJK UNIFIED IDEOGRAPH
    {0xF25A, 0x6BB0}, //12274 #CJK UNIFIED IDEOGRAPH
    {0xF25B, 0x6C0C}, //12275 #CJK UNIFIED IDEOGRAPH
    {0xF25C, 0x7019}, //12276 #CJK UNIFIED IDEOGRAPH
    {0xF25D, 0x7027}, //12277 #CJK UNIFIED IDEOGRAPH
    {0xF25E, 0x7020}, //12278 #CJK UNIFIED IDEOGRAPH
    {0xF25F, 0x7016}, //12279 #CJK UNIFIED IDEOGRAPH
    {0xF260, 0x702B}, //12280 #CJK UNIFIED IDEOGRAPH
    {0xF261, 0x7021}, //12281 #CJK UNIFIED IDEOGRAPH
    {0xF262, 0x7022}, //12282 #CJK UNIFIED IDEOGRAPH
    {0xF263, 0x7023}, //12283 #CJK UNIFIED IDEOGRAPH
    {0xF264, 0x7029}, //12284 #CJK UNIFIED IDEOGRAPH
    {0xF265, 0x7017}, //12285 #CJK UNIFIED IDEOGRAPH
    {0xF266, 0x7024}, //12286 #CJK UNIFIED IDEOGRAPH
    {0xF267, 0x701C}, //12287 #CJK UNIFIED IDEOGRAPH
    {0xF268, 0x702A}, //12288 #CJK UNIFIED IDEOGRAPH
    {0xF269, 0x720C}, //12289 #CJK UNIFIED IDEOGRAPH
    {0xF26A, 0x720A}, //12290 #CJK UNIFIED IDEOGRAPH
    {0xF26B, 0x7207}, //12291 #CJK UNIFIED IDEOGRAPH
    {0xF26C, 0x7202}, //12292 #CJK UNIFIED IDEOGRAPH
    {0xF26D, 0x7205}, //12293 #CJK UNIFIED IDEOGRAPH
    {0xF26E, 0x72A5}, //12294 #CJK UNIFIED IDEOGRAPH
    {0xF26F, 0x72A6}, //12295 #CJK UNIFIED IDEOGRAPH
    {0xF270, 0x72A4}, //12296 #CJK UNIFIED IDEOGRAPH
    {0xF271, 0x72A3}, //12297 #CJK UNIFIED IDEOGRAPH
    {0xF272, 0x72A1}, //12298 #CJK UNIFIED IDEOGRAPH
    {0xF273, 0x74CB}, //12299 #CJK UNIFIED IDEOGRAPH
    {0xF274, 0x74C5}, //12300 #CJK UNIFIED IDEOGRAPH
    {0xF275, 0x74B7}, //12301 #CJK UNIFIED IDEOGRAPH
    {0xF276, 0x74C3}, //12302 #CJK UNIFIED IDEOGRAPH
    {0xF277, 0x7516}, //12303 #CJK UNIFIED IDEOGRAPH
    {0xF278, 0x7660}, //12304 #CJK UNIFIED IDEOGRAPH
    {0xF279, 0x77C9}, //12305 #CJK UNIFIED IDEOGRAPH
    {0xF27A, 0x77CA}, //12306 #CJK UNIFIED IDEOGRAPH
    {0xF27B, 0x77C4}, //12307 #CJK UNIFIED IDEOGRAPH
    {0xF27C, 0x77F1}, //12308 #CJK UNIFIED IDEOGRAPH
    {0xF27D, 0x791D}, //12309 #CJK UNIFIED IDEOGRAPH
    {0xF27E, 0x791B}, //12310 #CJK UNIFIED IDEOGRAPH
    {0xF2A1, 0x7921}, //12311 #CJK UNIFIED IDEOGRAPH
    {0xF2A2, 0x791C}, //12312 #CJK UNIFIED IDEOGRAPH
    {0xF2A3, 0x7917}, //12313 #CJK UNIFIED IDEOGRAPH
    {0xF2A4, 0x791E}, //12314 #CJK UNIFIED IDEOGRAPH
    {0xF2A5, 0x79B0}, //12315 #CJK UNIFIED IDEOGRAPH
    {0xF2A6, 0x7A67}, //12316 #CJK UNIFIED IDEOGRAPH
    {0xF2A7, 0x7A68}, //12317 #CJK UNIFIED IDEOGRAPH
    {0xF2A8, 0x7C33}, //12318 #CJK UNIFIED IDEOGRAPH
    {0xF2A9, 0x7C3C}, //12319 #CJK UNIFIED IDEOGRAPH
    {0xF2AA, 0x7C39}, //12320 #CJK UNIFIED IDEOGRAPH
    {0xF2AB, 0x7C2C}, //12321 #CJK UNIFIED IDEOGRAPH
    {0xF2AC, 0x7C3B}, //12322 #CJK UNIFIED IDEOGRAPH
    {0xF2AD, 0x7CEC}, //12323 #CJK UNIFIED IDEOGRAPH
    {0xF2AE, 0x7CEA}, //12324 #CJK UNIFIED IDEOGRAPH
    {0xF2AF, 0x7E76}, //12325 #CJK UNIFIED IDEOGRAPH
    {0xF2B0, 0x7E75}, //12326 #CJK UNIFIED IDEOGRAPH
    {0xF2B1, 0x7E78}, //12327 #CJK UNIFIED IDEOGRAPH
    {0xF2B2, 0x7E70}, //12328 #CJK UNIFIED IDEOGRAPH
    {0xF2B3, 0x7E77}, //12329 #CJK UNIFIED IDEOGRAPH
    {0xF2B4, 0x7E6F}, //12330 #CJK UNIFIED IDEOGRAPH
    {0xF2B5, 0x7E7A}, //12331 #CJK UNIFIED IDEOGRAPH
    {0xF2B6, 0x7E72}, //12332 #CJK UNIFIED IDEOGRAPH
    {0xF2B7, 0x7E74}, //12333 #CJK UNIFIED IDEOGRAPH
    {0xF2B8, 0x7E68}, //12334 #CJK UNIFIED IDEOGRAPH
    {0xF2B9, 0x7F4B}, //12335 #CJK UNIFIED IDEOGRAPH
    {0xF2BA, 0x7F4A}, //12336 #CJK UNIFIED IDEOGRAPH
    {0xF2BB, 0x7F83}, //12337 #CJK UNIFIED IDEOGRAPH
    {0xF2BC, 0x7F86}, //12338 #CJK UNIFIED IDEOGRAPH
    {0xF2BD, 0x7FB7}, //12339 #CJK UNIFIED IDEOGRAPH
    {0xF2BE, 0x7FFD}, //12340 #CJK UNIFIED IDEOGRAPH
    {0xF2BF, 0x7FFE}, //12341 #CJK UNIFIED IDEOGRAPH
    {0xF2C0, 0x8078}, //12342 #CJK UNIFIED IDEOGRAPH
    {0xF2C1, 0x81D7}, //12343 #CJK UNIFIED IDEOGRAPH
    {0xF2C2, 0x81D5}, //12344 #CJK UNIFIED IDEOGRAPH
    {0xF2C3, 0x8264}, //12345 #CJK UNIFIED IDEOGRAPH
    {0xF2C4, 0x8261}, //12346 #CJK UNIFIED IDEOGRAPH
    {0xF2C5, 0x8263}, //12347 #CJK UNIFIED IDEOGRAPH
    {0xF2C6, 0x85EB}, //12348 #CJK UNIFIED IDEOGRAPH
    {0xF2C7, 0x85F1}, //12349 #CJK UNIFIED IDEOGRAPH
    {0xF2C8, 0x85ED}, //12350 #CJK UNIFIED IDEOGRAPH
    {0xF2C9, 0x85D9}, //12351 #CJK UNIFIED IDEOGRAPH
    {0xF2CA, 0x85E1}, //12352 #CJK UNIFIED IDEOGRAPH
    {0xF2CB, 0x85E8}, //12353 #CJK UNIFIED IDEOGRAPH
    {0xF2CC, 0x85DA}, //12354 #CJK UNIFIED IDEOGRAPH
    {0xF2CD, 0x85D7}, //12355 #CJK UNIFIED IDEOGRAPH
    {0xF2CE, 0x85EC}, //12356 #CJK UNIFIED IDEOGRAPH
    {0xF2CF, 0x85F2}, //12357 #CJK UNIFIED IDEOGRAPH
    {0xF2D0, 0x85F8}, //12358 #CJK UNIFIED IDEOGRAPH
    {0xF2D1, 0x85D8}, //12359 #CJK UNIFIED IDEOGRAPH
    {0xF2D2, 0x85DF}, //12360 #CJK UNIFIED IDEOGRAPH
    {0xF2D3, 0x85E3}, //12361 #CJK UNIFIED IDEOGRAPH
    {0xF2D4, 0x85DC}, //12362 #CJK UNIFIED IDEOGRAPH
    {0xF2D5, 0x85D1}, //12363 #CJK UNIFIED IDEOGRAPH
    {0xF2D6, 0x85F0}, //12364 #CJK UNIFIED IDEOGRAPH
    {0xF2D7, 0x85E6}, //12365 #CJK UNIFIED IDEOGRAPH
    {0xF2D8, 0x85EF}, //12366 #CJK UNIFIED IDEOGRAPH
    {0xF2D9, 0x85DE}, //12367 #CJK UNIFIED IDEOGRAPH
    {0xF2DA, 0x85E2}, //12368 #CJK UNIFIED IDEOGRAPH
    {0xF2DB, 0x8800}, //12369 #CJK UNIFIED IDEOGRAPH
    {0xF2DC, 0x87FA}, //12370 #CJK UNIFIED IDEOGRAPH
    {0xF2DD, 0x8803}, //12371 #CJK UNIFIED IDEOGRAPH
    {0xF2DE, 0x87F6}, //12372 #CJK UNIFIED IDEOGRAPH
    {0xF2DF, 0x87F7}, //12373 #CJK UNIFIED IDEOGRAPH
    {0xF2E0, 0x8809}, //12374 #CJK UNIFIED IDEOGRAPH
    {0xF2E1, 0x880C}, //12375 #CJK UNIFIED IDEOGRAPH
    {0xF2E2, 0x880B}, //12376 #CJK UNIFIED IDEOGRAPH
    {0xF2E3, 0x8806}, //12377 #CJK UNIFIED IDEOGRAPH
    {0xF2E4, 0x87FC}, //12378 #CJK UNIFIED IDEOGRAPH
    {0xF2E5, 0x8808}, //12379 #CJK UNIFIED IDEOGRAPH
    {0xF2E6, 0x87FF}, //12380 #CJK UNIFIED IDEOGRAPH
    {0xF2E7, 0x880A}, //12381 #CJK UNIFIED IDEOGRAPH
    {0xF2E8, 0x8802}, //12382 #CJK UNIFIED IDEOGRAPH
    {0xF2E9, 0x8962}, //12383 #CJK UNIFIED IDEOGRAPH
    {0xF2EA, 0x895A}, //12384 #CJK UNIFIED IDEOGRAPH
    {0xF2EB, 0x895B}, //12385 #CJK UNIFIED IDEOGRAPH
    {0xF2EC, 0x8957}, //12386 #CJK UNIFIED IDEOGRAPH
    {0xF2ED, 0x8961}, //12387 #CJK UNIFIED IDEOGRAPH
    {0xF2EE, 0x895C}, //12388 #CJK UNIFIED IDEOGRAPH
    {0xF2EF, 0x8958}, //12389 #CJK UNIFIED IDEOGRAPH
    {0xF2F0, 0x895D}, //12390 #CJK UNIFIED IDEOGRAPH
    {0xF2F1, 0x8959}, //12391 #CJK UNIFIED IDEOGRAPH
    {0xF2F2, 0x8988}, //12392 #CJK UNIFIED IDEOGRAPH
    {0xF2F3, 0x89B7}, //12393 #CJK UNIFIED IDEOGRAPH
    {0xF2F4, 0x89B6}, //12394 #CJK UNIFIED IDEOGRAPH
    {0xF2F5, 0x89F6}, //12395 #CJK UNIFIED IDEOGRAPH
    {0xF2F6, 0x8B50}, //12396 #CJK UNIFIED IDEOGRAPH
    {0xF2F7, 0x8B48}, //12397 #CJK UNIFIED IDEOGRAPH
    {0xF2F8, 0x8B4A}, //12398 #CJK UNIFIED IDEOGRAPH
    {0xF2F9, 0x8B40}, //12399 #CJK UNIFIED IDEOGRAPH
    {0xF2FA, 0x8B53}, //12400 #CJK UNIFIED IDEOGRAPH
    {0xF2FB, 0x8B56}, //12401 #CJK UNIFIED IDEOGRAPH
    {0xF2FC, 0x8B54}, //12402 #CJK UNIFIED IDEOGRAPH
    {0xF2FD, 0x8B4B}, //12403 #CJK UNIFIED IDEOGRAPH
    {0xF2FE, 0x8B55}, //12404 #CJK UNIFIED IDEOGRAPH
    {0xF340, 0x8B51}, //12405 #CJK UNIFIED IDEOGRAPH
    {0xF341, 0x8B42}, //12406 #CJK UNIFIED IDEOGRAPH
    {0xF342, 0x8B52}, //12407 #CJK UNIFIED IDEOGRAPH
    {0xF343, 0x8B57}, //12408 #CJK UNIFIED IDEOGRAPH
    {0xF344, 0x8C43}, //12409 #CJK UNIFIED IDEOGRAPH
    {0xF345, 0x8C77}, //12410 #CJK UNIFIED IDEOGRAPH
    {0xF346, 0x8C76}, //12411 #CJK UNIFIED IDEOGRAPH
    {0xF347, 0x8C9A}, //12412 #CJK UNIFIED IDEOGRAPH
    {0xF348, 0x8D06}, //12413 #CJK UNIFIED IDEOGRAPH
    {0xF349, 0x8D07}, //12414 #CJK UNIFIED IDEOGRAPH
    {0xF34A, 0x8D09}, //12415 #CJK UNIFIED IDEOGRAPH
    {0xF34B, 0x8DAC}, //12416 #CJK UNIFIED IDEOGRAPH
    {0xF34C, 0x8DAA}, //12417 #CJK UNIFIED IDEOGRAPH
    {0xF34D, 0x8DAD}, //12418 #CJK UNIFIED IDEOGRAPH
    {0xF34E, 0x8DAB}, //12419 #CJK UNIFIED IDEOGRAPH
    {0xF34F, 0x8E6D}, //12420 #CJK UNIFIED IDEOGRAPH
    {0xF350, 0x8E78}, //12421 #CJK UNIFIED IDEOGRAPH
    {0xF351, 0x8E73}, //12422 #CJK UNIFIED IDEOGRAPH
    {0xF352, 0x8E6A}, //12423 #CJK UNIFIED IDEOGRAPH
    {0xF353, 0x8E6F}, //12424 #CJK UNIFIED IDEOGRAPH
    {0xF354, 0x8E7B}, //12425 #CJK UNIFIED IDEOGRAPH
    {0xF355, 0x8EC2}, //12426 #CJK UNIFIED IDEOGRAPH
    {0xF356, 0x8F52}, //12427 #CJK UNIFIED IDEOGRAPH
    {0xF357, 0x8F51}, //12428 #CJK UNIFIED IDEOGRAPH
    {0xF358, 0x8F4F}, //12429 #CJK UNIFIED IDEOGRAPH
    {0xF359, 0x8F50}, //12430 #CJK UNIFIED IDEOGRAPH
    {0xF35A, 0x8F53}, //12431 #CJK UNIFIED IDEOGRAPH
    {0xF35B, 0x8FB4}, //12432 #CJK UNIFIED IDEOGRAPH
    {0xF35C, 0x9140}, //12433 #CJK UNIFIED IDEOGRAPH
    {0xF35D, 0x913F}, //12434 #CJK UNIFIED IDEOGRAPH
    {0xF35E, 0x91B0}, //12435 #CJK UNIFIED IDEOGRAPH
    {0xF35F, 0x91AD}, //12436 #CJK UNIFIED IDEOGRAPH
    {0xF360, 0x93DE}, //12437 #CJK UNIFIED IDEOGRAPH
    {0xF361, 0x93C7}, //12438 #CJK UNIFIED IDEOGRAPH
    {0xF362, 0x93CF}, //12439 #CJK UNIFIED IDEOGRAPH
    {0xF363, 0x93C2}, //12440 #CJK UNIFIED IDEOGRAPH
    {0xF364, 0x93DA}, //12441 #CJK UNIFIED IDEOGRAPH
    {0xF365, 0x93D0}, //12442 #CJK UNIFIED IDEOGRAPH
    {0xF366, 0x93F9}, //12443 #CJK UNIFIED IDEOGRAPH
    {0xF367, 0x93EC}, //12444 #CJK UNIFIED IDEOGRAPH
    {0xF368, 0x93CC}, //12445 #CJK UNIFIED IDEOGRAPH
    {0xF369, 0x93D9}, //12446 #CJK UNIFIED IDEOGRAPH
    {0xF36A, 0x93A9}, //12447 #CJK UNIFIED IDEOGRAPH
    {0xF36B, 0x93E6}, //12448 #CJK UNIFIED IDEOGRAPH
    {0xF36C, 0x93CA}, //12449 #CJK UNIFIED IDEOGRAPH
    {0xF36D, 0x93D4}, //12450 #CJK UNIFIED IDEOGRAPH
    {0xF36E, 0x93EE}, //12451 #CJK UNIFIED IDEOGRAPH
    {0xF36F, 0x93E3}, //12452 #CJK UNIFIED IDEOGRAPH
    {0xF370, 0x93D5}, //12453 #CJK UNIFIED IDEOGRAPH
    {0xF371, 0x93C4}, //12454 #CJK UNIFIED IDEOGRAPH
    {0xF372, 0x93CE}, //12455 #CJK UNIFIED IDEOGRAPH
    {0xF373, 0x93C0}, //12456 #CJK UNIFIED IDEOGRAPH
    {0xF374, 0x93D2}, //12457 #CJK UNIFIED IDEOGRAPH
    {0xF375, 0x93E7}, //12458 #CJK UNIFIED IDEOGRAPH
    {0xF376, 0x957D}, //12459 #CJK UNIFIED IDEOGRAPH
    {0xF377, 0x95DA}, //12460 #CJK UNIFIED IDEOGRAPH
    {0xF378, 0x95DB}, //12461 #CJK UNIFIED IDEOGRAPH
    {0xF379, 0x96E1}, //12462 #CJK UNIFIED IDEOGRAPH
    {0xF37A, 0x9729}, //12463 #CJK UNIFIED IDEOGRAPH
    {0xF37B, 0x972B}, //12464 #CJK UNIFIED IDEOGRAPH
    {0xF37C, 0x972C}, //12465 #CJK UNIFIED IDEOGRAPH
    {0xF37D, 0x9728}, //12466 #CJK UNIFIED IDEOGRAPH
    {0xF37E, 0x9726}, //12467 #CJK UNIFIED IDEOGRAPH
    {0xF3A1, 0x97B3}, //12468 #CJK UNIFIED IDEOGRAPH
    {0xF3A2, 0x97B7}, //12469 #CJK UNIFIED IDEOGRAPH
    {0xF3A3, 0x97B6}, //12470 #CJK UNIFIED IDEOGRAPH
    {0xF3A4, 0x97DD}, //12471 #CJK UNIFIED IDEOGRAPH
    {0xF3A5, 0x97DE}, //12472 #CJK UNIFIED IDEOGRAPH
    {0xF3A6, 0x97DF}, //12473 #CJK UNIFIED IDEOGRAPH
    {0xF3A7, 0x985C}, //12474 #CJK UNIFIED IDEOGRAPH
    {0xF3A8, 0x9859}, //12475 #CJK UNIFIED IDEOGRAPH
    {0xF3A9, 0x985D}, //12476 #CJK UNIFIED IDEOGRAPH
    {0xF3AA, 0x9857}, //12477 #CJK UNIFIED IDEOGRAPH
    {0xF3AB, 0x98BF}, //12478 #CJK UNIFIED IDEOGRAPH
    {0xF3AC, 0x98BD}, //12479 #CJK UNIFIED IDEOGRAPH
    {0xF3AD, 0x98BB}, //12480 #CJK UNIFIED IDEOGRAPH
    {0xF3AE, 0x98BE}, //12481 #CJK UNIFIED IDEOGRAPH
    {0xF3AF, 0x9948}, //12482 #CJK UNIFIED IDEOGRAPH
    {0xF3B0, 0x9947}, //12483 #CJK UNIFIED IDEOGRAPH
    {0xF3B1, 0x9943}, //12484 #CJK UNIFIED IDEOGRAPH
    {0xF3B2, 0x99A6}, //12485 #CJK UNIFIED IDEOGRAPH
    {0xF3B3, 0x99A7}, //12486 #CJK UNIFIED IDEOGRAPH
    {0xF3B4, 0x9A1A}, //12487 #CJK UNIFIED IDEOGRAPH
    {0xF3B5, 0x9A15}, //12488 #CJK UNIFIED IDEOGRAPH
    {0xF3B6, 0x9A25}, //12489 #CJK UNIFIED IDEOGRAPH
    {0xF3B7, 0x9A1D}, //12490 #CJK UNIFIED IDEOGRAPH
    {0xF3B8, 0x9A24}, //12491 #CJK UNIFIED IDEOGRAPH
    {0xF3B9, 0x9A1B}, //12492 #CJK UNIFIED IDEOGRAPH
    {0xF3BA, 0x9A22}, //12493 #CJK UNIFIED IDEOGRAPH
    {0xF3BB, 0x9A20}, //12494 #CJK UNIFIED IDEOGRAPH
    {0xF3BC, 0x9A27}, //12495 #CJK UNIFIED IDEOGRAPH
    {0xF3BD, 0x9A23}, //12496 #CJK UNIFIED IDEOGRAPH
    {0xF3BE, 0x9A1E}, //12497 #CJK UNIFIED IDEOGRAPH
    {0xF3BF, 0x9A1C}, //12498 #CJK UNIFIED IDEOGRAPH
    {0xF3C0, 0x9A14}, //12499 #CJK UNIFIED IDEOGRAPH
    {0xF3C1, 0x9AC2}, //12500 #CJK UNIFIED IDEOGRAPH
    {0xF3C2, 0x9B0B}, //12501 #CJK UNIFIED IDEOGRAPH
    {0xF3C3, 0x9B0A}, //12502 #CJK UNIFIED IDEOGRAPH
    {0xF3C4, 0x9B0E}, //12503 #CJK UNIFIED IDEOGRAPH
    {0xF3C5, 0x9B0C}, //12504 #CJK UNIFIED IDEOGRAPH
    {0xF3C6, 0x9B37}, //12505 #CJK UNIFIED IDEOGRAPH
    {0xF3C7, 0x9BEA}, //12506 #CJK UNIFIED IDEOGRAPH
    {0xF3C8, 0x9BEB}, //12507 #CJK UNIFIED IDEOGRAPH
    {0xF3C9, 0x9BE0}, //12508 #CJK UNIFIED IDEOGRAPH
    {0xF3CA, 0x9BDE}, //12509 #CJK UNIFIED IDEOGRAPH
    {0xF3CB, 0x9BE4}, //12510 #CJK UNIFIED IDEOGRAPH
    {0xF3CC, 0x9BE6}, //12511 #CJK UNIFIED IDEOGRAPH
    {0xF3CD, 0x9BE2}, //12512 #CJK UNIFIED IDEOGRAPH
    {0xF3CE, 0x9BF0}, //12513 #CJK UNIFIED IDEOGRAPH
    {0xF3CF, 0x9BD4}, //12514 #CJK UNIFIED IDEOGRAPH
    {0xF3D0, 0x9BD7}, //12515 #CJK UNIFIED IDEOGRAPH
    {0xF3D1, 0x9BEC}, //12516 #CJK UNIFIED IDEOGRAPH
    {0xF3D2, 0x9BDC}, //12517 #CJK UNIFIED IDEOGRAPH
    {0xF3D3, 0x9BD9}, //12518 #CJK UNIFIED IDEOGRAPH
    {0xF3D4, 0x9BE5}, //12519 #CJK UNIFIED IDEOGRAPH
    {0xF3D5, 0x9BD5}, //12520 #CJK UNIFIED IDEOGRAPH
    {0xF3D6, 0x9BE1}, //12521 #CJK UNIFIED IDEOGRAPH
    {0xF3D7, 0x9BDA}, //12522 #CJK UNIFIED IDEOGRAPH
    {0xF3D8, 0x9D77}, //12523 #CJK UNIFIED IDEOGRAPH
    {0xF3D9, 0x9D81}, //12524 #CJK UNIFIED IDEOGRAPH
    {0xF3DA, 0x9D8A}, //12525 #CJK UNIFIED IDEOGRAPH
    {0xF3DB, 0x9D84}, //12526 #CJK UNIFIED IDEOGRAPH
    {0xF3DC, 0x9D88}, //12527 #CJK UNIFIED IDEOGRAPH
    {0xF3DD, 0x9D71}, //12528 #CJK UNIFIED IDEOGRAPH
    {0xF3DE, 0x9D80}, //12529 #CJK UNIFIED IDEOGRAPH
    {0xF3DF, 0x9D78}, //12530 #CJK UNIFIED IDEOGRAPH
    {0xF3E0, 0x9D86}, //12531 #CJK UNIFIED IDEOGRAPH
    {0xF3E1, 0x9D8B}, //12532 #CJK UNIFIED IDEOGRAPH
    {0xF3E2, 0x9D8C}, //12533 #CJK UNIFIED IDEOGRAPH
    {0xF3E3, 0x9D7D}, //12534 #CJK UNIFIED IDEOGRAPH
    {0xF3E4, 0x9D6B}, //12535 #CJK UNIFIED IDEOGRAPH
    {0xF3E5, 0x9D74}, //12536 #CJK UNIFIED IDEOGRAPH
    {0xF3E6, 0x9D75}, //12537 #CJK UNIFIED IDEOGRAPH
    {0xF3E7, 0x9D70}, //12538 #CJK UNIFIED IDEOGRAPH
    {0xF3E8, 0x9D69}, //12539 #CJK UNIFIED IDEOGRAPH
    {0xF3E9, 0x9D85}, //12540 #CJK UNIFIED IDEOGRAPH
    {0xF3EA, 0x9D73}, //12541 #CJK UNIFIED IDEOGRAPH
    {0xF3EB, 0x9D7B}, //12542 #CJK UNIFIED IDEOGRAPH
    {0xF3EC, 0x9D82}, //12543 #CJK UNIFIED IDEOGRAPH
    {0xF3ED, 0x9D6F}, //12544 #CJK UNIFIED IDEOGRAPH
    {0xF3EE, 0x9D79}, //12545 #CJK UNIFIED IDEOGRAPH
    {0xF3EF, 0x9D7F}, //12546 #CJK UNIFIED IDEOGRAPH
    {0xF3F0, 0x9D87}, //12547 #CJK UNIFIED IDEOGRAPH
    {0xF3F1, 0x9D68}, //12548 #CJK UNIFIED IDEOGRAPH
    {0xF3F2, 0x9E94}, //12549 #CJK UNIFIED IDEOGRAPH
    {0xF3F3, 0x9E91}, //12550 #CJK UNIFIED IDEOGRAPH
    {0xF3F4, 0x9EC0}, //12551 #CJK UNIFIED IDEOGRAPH
    {0xF3F5, 0x9EFC}, //12552 #CJK UNIFIED IDEOGRAPH
    {0xF3F6, 0x9F2D}, //12553 #CJK UNIFIED IDEOGRAPH
    {0xF3F7, 0x9F40}, //12554 #CJK UNIFIED IDEOGRAPH
    {0xF3F8, 0x9F41}, //12555 #CJK UNIFIED IDEOGRAPH
    {0xF3F9, 0x9F4D}, //12556 #CJK UNIFIED IDEOGRAPH
    {0xF3FA, 0x9F56}, //12557 #CJK UNIFIED IDEOGRAPH
    {0xF3FB, 0x9F57}, //12558 #CJK UNIFIED IDEOGRAPH
    {0xF3FC, 0x9F58}, //12559 #CJK UNIFIED IDEOGRAPH
    {0xF3FD, 0x5337}, //12560 #CJK UNIFIED IDEOGRAPH
    {0xF3FE, 0x56B2}, //12561 #CJK UNIFIED IDEOGRAPH
    {0xF440, 0x56B5}, //12562 #CJK UNIFIED IDEOGRAPH
    {0xF441, 0x56B3}, //12563 #CJK UNIFIED IDEOGRAPH
    {0xF442, 0x58E3}, //12564 #CJK UNIFIED IDEOGRAPH
    {0xF443, 0x5B45}, //12565 #CJK UNIFIED IDEOGRAPH
    {0xF444, 0x5DC6}, //12566 #CJK UNIFIED IDEOGRAPH
    {0xF445, 0x5DC7}, //12567 #CJK UNIFIED IDEOGRAPH
    {0xF446, 0x5EEE}, //12568 #CJK UNIFIED IDEOGRAPH
    {0xF447, 0x5EEF}, //12569 #CJK UNIFIED IDEOGRAPH
    {0xF448, 0x5FC0}, //12570 #CJK UNIFIED IDEOGRAPH
    {0xF449, 0x5FC1}, //12571 #CJK UNIFIED IDEOGRAPH
    {0xF44A, 0x61F9}, //12572 #CJK UNIFIED IDEOGRAPH
    {0xF44B, 0x6517}, //12573 #CJK UNIFIED IDEOGRAPH
    {0xF44C, 0x6516}, //12574 #CJK UNIFIED IDEOGRAPH
    {0xF44D, 0x6515}, //12575 #CJK UNIFIED IDEOGRAPH
    {0xF44E, 0x6513}, //12576 #CJK UNIFIED IDEOGRAPH
    {0xF44F, 0x65DF}, //12577 #CJK UNIFIED IDEOGRAPH
    {0xF450, 0x66E8}, //12578 #CJK UNIFIED IDEOGRAPH
    {0xF451, 0x66E3}, //12579 #CJK UNIFIED IDEOGRAPH
    {0xF452, 0x66E4}, //12580 #CJK UNIFIED IDEOGRAPH
    {0xF453, 0x6AF3}, //12581 #CJK UNIFIED IDEOGRAPH
    {0xF454, 0x6AF0}, //12582 #CJK UNIFIED IDEOGRAPH
    {0xF455, 0x6AEA}, //12583 #CJK UNIFIED IDEOGRAPH
    {0xF456, 0x6AE8}, //12584 #CJK UNIFIED IDEOGRAPH
    {0xF457, 0x6AF9}, //12585 #CJK UNIFIED IDEOGRAPH
    {0xF458, 0x6AF1}, //12586 #CJK UNIFIED IDEOGRAPH
    {0xF459, 0x6AEE}, //12587 #CJK UNIFIED IDEOGRAPH
    {0xF45A, 0x6AEF}, //12588 #CJK UNIFIED IDEOGRAPH
    {0xF45B, 0x703C}, //12589 #CJK UNIFIED IDEOGRAPH
    {0xF45C, 0x7035}, //12590 #CJK UNIFIED IDEOGRAPH
    {0xF45D, 0x702F}, //12591 #CJK UNIFIED IDEOGRAPH
    {0xF45E, 0x7037}, //12592 #CJK UNIFIED IDEOGRAPH
    {0xF45F, 0x7034}, //12593 #CJK UNIFIED IDEOGRAPH
    {0xF460, 0x7031}, //12594 #CJK UNIFIED IDEOGRAPH
    {0xF461, 0x7042}, //12595 #CJK UNIFIED IDEOGRAPH
    {0xF462, 0x7038}, //12596 #CJK UNIFIED IDEOGRAPH
    {0xF463, 0x703F}, //12597 #CJK UNIFIED IDEOGRAPH
    {0xF464, 0x703A}, //12598 #CJK UNIFIED IDEOGRAPH
    {0xF465, 0x7039}, //12599 #CJK UNIFIED IDEOGRAPH
    {0xF466, 0x7040}, //12600 #CJK UNIFIED IDEOGRAPH
    {0xF467, 0x703B}, //12601 #CJK UNIFIED IDEOGRAPH
    {0xF468, 0x7033}, //12602 #CJK UNIFIED IDEOGRAPH
    {0xF469, 0x7041}, //12603 #CJK UNIFIED IDEOGRAPH
    {0xF46A, 0x7213}, //12604 #CJK UNIFIED IDEOGRAPH
    {0xF46B, 0x7214}, //12605 #CJK UNIFIED IDEOGRAPH
    {0xF46C, 0x72A8}, //12606 #CJK UNIFIED IDEOGRAPH
    {0xF46D, 0x737D}, //12607 #CJK UNIFIED IDEOGRAPH
    {0xF46E, 0x737C}, //12608 #CJK UNIFIED IDEOGRAPH
    {0xF46F, 0x74BA}, //12609 #CJK UNIFIED IDEOGRAPH
    {0xF470, 0x76AB}, //12610 #CJK UNIFIED IDEOGRAPH
    {0xF471, 0x76AA}, //12611 #CJK UNIFIED IDEOGRAPH
    {0xF472, 0x76BE}, //12612 #CJK UNIFIED IDEOGRAPH
    {0xF473, 0x76ED}, //12613 #CJK UNIFIED IDEOGRAPH
    {0xF474, 0x77CC}, //12614 #CJK UNIFIED IDEOGRAPH
    {0xF475, 0x77CE}, //12615 #CJK UNIFIED IDEOGRAPH
    {0xF476, 0x77CF}, //12616 #CJK UNIFIED IDEOGRAPH
    {0xF477, 0x77CD}, //12617 #CJK UNIFIED IDEOGRAPH
    {0xF478, 0x77F2}, //12618 #CJK UNIFIED IDEOGRAPH
    {0xF479, 0x7925}, //12619 #CJK UNIFIED IDEOGRAPH
    {0xF47A, 0x7923}, //12620 #CJK UNIFIED IDEOGRAPH
    {0xF47B, 0x7927}, //12621 #CJK UNIFIED IDEOGRAPH
    {0xF47C, 0x7928}, //12622 #CJK UNIFIED IDEOGRAPH
    {0xF47D, 0x7924}, //12623 #CJK UNIFIED IDEOGRAPH
    {0xF47E, 0x7929}, //12624 #CJK UNIFIED IDEOGRAPH
    {0xF4A1, 0x79B2}, //12625 #CJK UNIFIED IDEOGRAPH
    {0xF4A2, 0x7A6E}, //12626 #CJK UNIFIED IDEOGRAPH
    {0xF4A3, 0x7A6C}, //12627 #CJK UNIFIED IDEOGRAPH
    {0xF4A4, 0x7A6D}, //12628 #CJK UNIFIED IDEOGRAPH
    {0xF4A5, 0x7AF7}, //12629 #CJK UNIFIED IDEOGRAPH
    {0xF4A6, 0x7C49}, //12630 #CJK UNIFIED IDEOGRAPH
    {0xF4A7, 0x7C48}, //12631 #CJK UNIFIED IDEOGRAPH
    {0xF4A8, 0x7C4A}, //12632 #CJK UNIFIED IDEOGRAPH
    {0xF4A9, 0x7C47}, //12633 #CJK UNIFIED IDEOGRAPH
    {0xF4AA, 0x7C45}, //12634 #CJK UNIFIED IDEOGRAPH
    {0xF4AB, 0x7CEE}, //12635 #CJK UNIFIED IDEOGRAPH
    {0xF4AC, 0x7E7B}, //12636 #CJK UNIFIED IDEOGRAPH
    {0xF4AD, 0x7E7E}, //12637 #CJK UNIFIED IDEOGRAPH
    {0xF4AE, 0x7E81}, //12638 #CJK UNIFIED IDEOGRAPH
    {0xF4AF, 0x7E80}, //12639 #CJK UNIFIED IDEOGRAPH
    {0xF4B0, 0x7FBA}, //12640 #CJK UNIFIED IDEOGRAPH
    {0xF4B1, 0x7FFF}, //12641 #CJK UNIFIED IDEOGRAPH
    {0xF4B2, 0x8079}, //12642 #CJK UNIFIED IDEOGRAPH
    {0xF4B3, 0x81DB}, //12643 #CJK UNIFIED IDEOGRAPH
    {0xF4B4, 0x81D9}, //12644 #CJK UNIFIED IDEOGRAPH
    {0xF4B5, 0x820B}, //12645 #CJK UNIFIED IDEOGRAPH
    {0xF4B6, 0x8268}, //12646 #CJK UNIFIED IDEOGRAPH
    {0xF4B7, 0x8269}, //12647 #CJK UNIFIED IDEOGRAPH
    {0xF4B8, 0x8622}, //12648 #CJK UNIFIED IDEOGRAPH
    {0xF4B9, 0x85FF}, //12649 #CJK UNIFIED IDEOGRAPH
    {0xF4BA, 0x8601}, //12650 #CJK UNIFIED IDEOGRAPH
    {0xF4BB, 0x85FE}, //12651 #CJK UNIFIED IDEOGRAPH
    {0xF4BC, 0x861B}, //12652 #CJK UNIFIED IDEOGRAPH
    {0xF4BD, 0x8600}, //12653 #CJK UNIFIED IDEOGRAPH
    {0xF4BE, 0x85F6}, //12654 #CJK UNIFIED IDEOGRAPH
    {0xF4BF, 0x8604}, //12655 #CJK UNIFIED IDEOGRAPH
    {0xF4C0, 0x8609}, //12656 #CJK UNIFIED IDEOGRAPH
    {0xF4C1, 0x8605}, //12657 #CJK UNIFIED IDEOGRAPH
    {0xF4C2, 0x860C}, //12658 #CJK UNIFIED IDEOGRAPH
    {0xF4C3, 0x85FD}, //12659 #CJK UNIFIED IDEOGRAPH
    {0xF4C4, 0x8819}, //12660 #CJK UNIFIED IDEOGRAPH
    {0xF4C5, 0x8810}, //12661 #CJK UNIFIED IDEOGRAPH
    {0xF4C6, 0x8811}, //12662 #CJK UNIFIED IDEOGRAPH
    {0xF4C7, 0x8817}, //12663 #CJK UNIFIED IDEOGRAPH
    {0xF4C8, 0x8813}, //12664 #CJK UNIFIED IDEOGRAPH
    {0xF4C9, 0x8816}, //12665 #CJK UNIFIED IDEOGRAPH
    {0xF4CA, 0x8963}, //12666 #CJK UNIFIED IDEOGRAPH
    {0xF4CB, 0x8966}, //12667 #CJK UNIFIED IDEOGRAPH
    {0xF4CC, 0x89B9}, //12668 #CJK UNIFIED IDEOGRAPH
    {0xF4CD, 0x89F7}, //12669 #CJK UNIFIED IDEOGRAPH
    {0xF4CE, 0x8B60}, //12670 #CJK UNIFIED IDEOGRAPH
    {0xF4CF, 0x8B6A}, //12671 #CJK UNIFIED IDEOGRAPH
    {0xF4D0, 0x8B5D}, //12672 #CJK UNIFIED IDEOGRAPH
    {0xF4D1, 0x8B68}, //12673 #CJK UNIFIED IDEOGRAPH
    {0xF4D2, 0x8B63}, //12674 #CJK UNIFIED IDEOGRAPH
    {0xF4D3, 0x8B65}, //12675 #CJK UNIFIED IDEOGRAPH
    {0xF4D4, 0x8B67}, //12676 #CJK UNIFIED IDEOGRAPH
    {0xF4D5, 0x8B6D}, //12677 #CJK UNIFIED IDEOGRAPH
    {0xF4D6, 0x8DAE}, //12678 #CJK UNIFIED IDEOGRAPH
    {0xF4D7, 0x8E86}, //12679 #CJK UNIFIED IDEOGRAPH
    {0xF4D8, 0x8E88}, //12680 #CJK UNIFIED IDEOGRAPH
    {0xF4D9, 0x8E84}, //12681 #CJK UNIFIED IDEOGRAPH
    {0xF4DA, 0x8F59}, //12682 #CJK UNIFIED IDEOGRAPH
    {0xF4DB, 0x8F56}, //12683 #CJK UNIFIED IDEOGRAPH
    {0xF4DC, 0x8F57}, //12684 #CJK UNIFIED IDEOGRAPH
    {0xF4DD, 0x8F55}, //12685 #CJK UNIFIED IDEOGRAPH
    {0xF4DE, 0x8F58}, //12686 #CJK UNIFIED IDEOGRAPH
    {0xF4DF, 0x8F5A}, //12687 #CJK UNIFIED IDEOGRAPH
    {0xF4E0, 0x908D}, //12688 #CJK UNIFIED IDEOGRAPH
    {0xF4E1, 0x9143}, //12689 #CJK UNIFIED IDEOGRAPH
    {0xF4E2, 0x9141}, //12690 #CJK UNIFIED IDEOGRAPH
    {0xF4E3, 0x91B7}, //12691 #CJK UNIFIED IDEOGRAPH
    {0xF4E4, 0x91B5}, //12692 #CJK UNIFIED IDEOGRAPH
    {0xF4E5, 0x91B2}, //12693 #CJK UNIFIED IDEOGRAPH
    {0xF4E6, 0x91B3}, //12694 #CJK UNIFIED IDEOGRAPH
    {0xF4E7, 0x940B}, //12695 #CJK UNIFIED IDEOGRAPH
    {0xF4E8, 0x9413}, //12696 #CJK UNIFIED IDEOGRAPH
    {0xF4E9, 0x93FB}, //12697 #CJK UNIFIED IDEOGRAPH
    {0xF4EA, 0x9420}, //12698 #CJK UNIFIED IDEOGRAPH
    {0xF4EB, 0x940F}, //12699 #CJK UNIFIED IDEOGRAPH
    {0xF4EC, 0x9414}, //12700 #CJK UNIFIED IDEOGRAPH
    {0xF4ED, 0x93FE}, //12701 #CJK UNIFIED IDEOGRAPH
    {0xF4EE, 0x9415}, //12702 #CJK UNIFIED IDEOGRAPH
    {0xF4EF, 0x9410}, //12703 #CJK UNIFIED IDEOGRAPH
    {0xF4F0, 0x9428}, //12704 #CJK UNIFIED IDEOGRAPH
    {0xF4F1, 0x9419}, //12705 #CJK UNIFIED IDEOGRAPH
    {0xF4F2, 0x940D}, //12706 #CJK UNIFIED IDEOGRAPH
    {0xF4F3, 0x93F5}, //12707 #CJK UNIFIED IDEOGRAPH
    {0xF4F4, 0x9400}, //12708 #CJK UNIFIED IDEOGRAPH
    {0xF4F5, 0x93F7}, //12709 #CJK UNIFIED IDEOGRAPH
    {0xF4F6, 0x9407}, //12710 #CJK UNIFIED IDEOGRAPH
    {0xF4F7, 0x940E}, //12711 #CJK UNIFIED IDEOGRAPH
    {0xF4F8, 0x9416}, //12712 #CJK UNIFIED IDEOGRAPH
    {0xF4F9, 0x9412}, //12713 #CJK UNIFIED IDEOGRAPH
    {0xF4FA, 0x93FA}, //12714 #CJK UNIFIED IDEOGRAPH
    {0xF4FB, 0x9409}, //12715 #CJK UNIFIED IDEOGRAPH
    {0xF4FC, 0x93F8}, //12716 #CJK UNIFIED IDEOGRAPH
    {0xF4FD, 0x940A}, //12717 #CJK UNIFIED IDEOGRAPH
    {0xF4FE, 0x93FF}, //12718 #CJK UNIFIED IDEOGRAPH
    {0xF540, 0x93FC}, //12719 #CJK UNIFIED IDEOGRAPH
    {0xF541, 0x940C}, //12720 #CJK UNIFIED IDEOGRAPH
    {0xF542, 0x93F6}, //12721 #CJK UNIFIED IDEOGRAPH
    {0xF543, 0x9411}, //12722 #CJK UNIFIED IDEOGRAPH
    {0xF544, 0x9406}, //12723 #CJK UNIFIED IDEOGRAPH
    {0xF545, 0x95DE}, //12724 #CJK UNIFIED IDEOGRAPH
    {0xF546, 0x95E0}, //12725 #CJK UNIFIED IDEOGRAPH
    {0xF547, 0x95DF}, //12726 #CJK UNIFIED IDEOGRAPH
    {0xF548, 0x972E}, //12727 #CJK UNIFIED IDEOGRAPH
    {0xF549, 0x972F}, //12728 #CJK UNIFIED IDEOGRAPH
    {0xF54A, 0x97B9}, //12729 #CJK UNIFIED IDEOGRAPH
    {0xF54B, 0x97BB}, //12730 #CJK UNIFIED IDEOGRAPH
    {0xF54C, 0x97FD}, //12731 #CJK UNIFIED IDEOGRAPH
    {0xF54D, 0x97FE}, //12732 #CJK UNIFIED IDEOGRAPH
    {0xF54E, 0x9860}, //12733 #CJK UNIFIED IDEOGRAPH
    {0xF54F, 0x9862}, //12734 #CJK UNIFIED IDEOGRAPH
    {0xF550, 0x9863}, //12735 #CJK UNIFIED IDEOGRAPH
    {0xF551, 0x985F}, //12736 #CJK UNIFIED IDEOGRAPH
    {0xF552, 0x98C1}, //12737 #CJK UNIFIED IDEOGRAPH
    {0xF553, 0x98C2}, //12738 #CJK UNIFIED IDEOGRAPH
    {0xF554, 0x9950}, //12739 #CJK UNIFIED IDEOGRAPH
    {0xF555, 0x994E}, //12740 #CJK UNIFIED IDEOGRAPH
    {0xF556, 0x9959}, //12741 #CJK UNIFIED IDEOGRAPH
    {0xF557, 0x994C}, //12742 #CJK UNIFIED IDEOGRAPH
    {0xF558, 0x994B}, //12743 #CJK UNIFIED IDEOGRAPH
    {0xF559, 0x9953}, //12744 #CJK UNIFIED IDEOGRAPH
    {0xF55A, 0x9A32}, //12745 #CJK UNIFIED IDEOGRAPH
    {0xF55B, 0x9A34}, //12746 #CJK UNIFIED IDEOGRAPH
    {0xF55C, 0x9A31}, //12747 #CJK UNIFIED IDEOGRAPH
    {0xF55D, 0x9A2C}, //12748 #CJK UNIFIED IDEOGRAPH
    {0xF55E, 0x9A2A}, //12749 #CJK UNIFIED IDEOGRAPH
    {0xF55F, 0x9A36}, //12750 #CJK UNIFIED IDEOGRAPH
    {0xF560, 0x9A29}, //12751 #CJK UNIFIED IDEOGRAPH
    {0xF561, 0x9A2E}, //12752 #CJK UNIFIED IDEOGRAPH
    {0xF562, 0x9A38}, //12753 #CJK UNIFIED IDEOGRAPH
    {0xF563, 0x9A2D}, //12754 #CJK UNIFIED IDEOGRAPH
    {0xF564, 0x9AC7}, //12755 #CJK UNIFIED IDEOGRAPH
    {0xF565, 0x9ACA}, //12756 #CJK UNIFIED IDEOGRAPH
    {0xF566, 0x9AC6}, //12757 #CJK UNIFIED IDEOGRAPH
    {0xF567, 0x9B10}, //12758 #CJK UNIFIED IDEOGRAPH
    {0xF568, 0x9B12}, //12759 #CJK UNIFIED IDEOGRAPH
    {0xF569, 0x9B11}, //12760 #CJK UNIFIED IDEOGRAPH
    {0xF56A, 0x9C0B}, //12761 #CJK UNIFIED IDEOGRAPH
    {0xF56B, 0x9C08}, //12762 #CJK UNIFIED IDEOGRAPH
    {0xF56C, 0x9BF7}, //12763 #CJK UNIFIED IDEOGRAPH
    {0xF56D, 0x9C05}, //12764 #CJK UNIFIED IDEOGRAPH
    {0xF56E, 0x9C12}, //12765 #CJK UNIFIED IDEOGRAPH
    {0xF56F, 0x9BF8}, //12766 #CJK UNIFIED IDEOGRAPH
    {0xF570, 0x9C40}, //12767 #CJK UNIFIED IDEOGRAPH
    {0xF571, 0x9C07}, //12768 #CJK UNIFIED IDEOGRAPH
    {0xF572, 0x9C0E}, //12769 #CJK UNIFIED IDEOGRAPH
    {0xF573, 0x9C06}, //12770 #CJK UNIFIED IDEOGRAPH
    {0xF574, 0x9C17}, //12771 #CJK UNIFIED IDEOGRAPH
    {0xF575, 0x9C14}, //12772 #CJK UNIFIED IDEOGRAPH
    {0xF576, 0x9C09}, //12773 #CJK UNIFIED IDEOGRAPH
    {0xF577, 0x9D9F}, //12774 #CJK UNIFIED IDEOGRAPH
    {0xF578, 0x9D99}, //12775 #CJK UNIFIED IDEOGRAPH
    {0xF579, 0x9DA4}, //12776 #CJK UNIFIED IDEOGRAPH
    {0xF57A, 0x9D9D}, //12777 #CJK UNIFIED IDEOGRAPH
    {0xF57B, 0x9D92}, //12778 #CJK UNIFIED IDEOGRAPH
    {0xF57C, 0x9D98}, //12779 #CJK UNIFIED IDEOGRAPH
    {0xF57D, 0x9D90}, //12780 #CJK UNIFIED IDEOGRAPH
    {0xF57E, 0x9D9B}, //12781 #CJK UNIFIED IDEOGRAPH
    {0xF5A1, 0x9DA0}, //12782 #CJK UNIFIED IDEOGRAPH
    {0xF5A2, 0x9D94}, //12783 #CJK UNIFIED IDEOGRAPH
    {0xF5A3, 0x9D9C}, //12784 #CJK UNIFIED IDEOGRAPH
    {0xF5A4, 0x9DAA}, //12785 #CJK UNIFIED IDEOGRAPH
    {0xF5A5, 0x9D97}, //12786 #CJK UNIFIED IDEOGRAPH
    {0xF5A6, 0x9DA1}, //12787 #CJK UNIFIED IDEOGRAPH
    {0xF5A7, 0x9D9A}, //12788 #CJK UNIFIED IDEOGRAPH
    {0xF5A8, 0x9DA2}, //12789 #CJK UNIFIED IDEOGRAPH
    {0xF5A9, 0x9DA8}, //12790 #CJK UNIFIED IDEOGRAPH
    {0xF5AA, 0x9D9E}, //12791 #CJK UNIFIED IDEOGRAPH
    {0xF5AB, 0x9DA3}, //12792 #CJK UNIFIED IDEOGRAPH
    {0xF5AC, 0x9DBF}, //12793 #CJK UNIFIED IDEOGRAPH
    {0xF5AD, 0x9DA9}, //12794 #CJK UNIFIED IDEOGRAPH
    {0xF5AE, 0x9D96}, //12795 #CJK UNIFIED IDEOGRAPH
    {0xF5AF, 0x9DA6}, //12796 #CJK UNIFIED IDEOGRAPH
    {0xF5B0, 0x9DA7}, //12797 #CJK UNIFIED IDEOGRAPH
    {0xF5B1, 0x9E99}, //12798 #CJK UNIFIED IDEOGRAPH
    {0xF5B2, 0x9E9B}, //12799 #CJK UNIFIED IDEOGRAPH
    {0xF5B3, 0x9E9A}, //12800 #CJK UNIFIED IDEOGRAPH
    {0xF5B4, 0x9EE5}, //12801 #CJK UNIFIED IDEOGRAPH
    {0xF5B5, 0x9EE4}, //12802 #CJK UNIFIED IDEOGRAPH
    {0xF5B6, 0x9EE7}, //12803 #CJK UNIFIED IDEOGRAPH
    {0xF5B7, 0x9EE6}, //12804 #CJK UNIFIED IDEOGRAPH
    {0xF5B8, 0x9F30}, //12805 #CJK UNIFIED IDEOGRAPH
    {0xF5B9, 0x9F2E}, //12806 #CJK UNIFIED IDEOGRAPH
    {0xF5BA, 0x9F5B}, //12807 #CJK UNIFIED IDEOGRAPH
    {0xF5BB, 0x9F60}, //12808 #CJK UNIFIED IDEOGRAPH
    {0xF5BC, 0x9F5E}, //12809 #CJK UNIFIED IDEOGRAPH
    {0xF5BD, 0x9F5D}, //12810 #CJK UNIFIED IDEOGRAPH
    {0xF5BE, 0x9F59}, //12811 #CJK UNIFIED IDEOGRAPH
    {0xF5BF, 0x9F91}, //12812 #CJK UNIFIED IDEOGRAPH
    {0xF5C0, 0x513A}, //12813 #CJK UNIFIED IDEOGRAPH
    {0xF5C1, 0x5139}, //12814 #CJK UNIFIED IDEOGRAPH
    {0xF5C2, 0x5298}, //12815 #CJK UNIFIED IDEOGRAPH
    {0xF5C3, 0x5297}, //12816 #CJK UNIFIED IDEOGRAPH
    {0xF5C4, 0x56C3}, //12817 #CJK UNIFIED IDEOGRAPH
    {0xF5C5, 0x56BD}, //12818 #CJK UNIFIED IDEOGRAPH
    {0xF5C6, 0x56BE}, //12819 #CJK UNIFIED IDEOGRAPH
    {0xF5C7, 0x5B48}, //12820 #CJK UNIFIED IDEOGRAPH
    {0xF5C8, 0x5B47}, //12821 #CJK UNIFIED IDEOGRAPH
    {0xF5C9, 0x5DCB}, //12822 #CJK UNIFIED IDEOGRAPH
    {0xF5CA, 0x5DCF}, //12823 #CJK UNIFIED IDEOGRAPH
    {0xF5CB, 0x5EF1}, //12824 #CJK UNIFIED IDEOGRAPH
    {0xF5CC, 0x61FD}, //12825 #CJK UNIFIED IDEOGRAPH
    {0xF5CD, 0x651B}, //12826 #CJK UNIFIED IDEOGRAPH
    {0xF5CE, 0x6B02}, //12827 #CJK UNIFIED IDEOGRAPH
    {0xF5CF, 0x6AFC}, //12828 #CJK UNIFIED IDEOGRAPH
    {0xF5D0, 0x6B03}, //12829 #CJK UNIFIED IDEOGRAPH
    {0xF5D1, 0x6AF8}, //12830 #CJK UNIFIED IDEOGRAPH
    {0xF5D2, 0x6B00}, //12831 #CJK UNIFIED IDEOGRAPH
    {0xF5D3, 0x7043}, //12832 #CJK UNIFIED IDEOGRAPH
    {0xF5D4, 0x7044}, //12833 #CJK UNIFIED IDEOGRAPH
    {0xF5D5, 0x704A}, //12834 #CJK UNIFIED IDEOGRAPH
    {0xF5D6, 0x7048}, //12835 #CJK UNIFIED IDEOGRAPH
    {0xF5D7, 0x7049}, //12836 #CJK UNIFIED IDEOGRAPH
    {0xF5D8, 0x7045}, //12837 #CJK UNIFIED IDEOGRAPH
    {0xF5D9, 0x7046}, //12838 #CJK UNIFIED IDEOGRAPH
    {0xF5DA, 0x721D}, //12839 #CJK UNIFIED IDEOGRAPH
    {0xF5DB, 0x721A}, //12840 #CJK UNIFIED IDEOGRAPH
    {0xF5DC, 0x7219}, //12841 #CJK UNIFIED IDEOGRAPH
    {0xF5DD, 0x737E}, //12842 #CJK UNIFIED IDEOGRAPH
    {0xF5DE, 0x7517}, //12843 #CJK UNIFIED IDEOGRAPH
    {0xF5DF, 0x766A}, //12844 #CJK UNIFIED IDEOGRAPH
    {0xF5E0, 0x77D0}, //12845 #CJK UNIFIED IDEOGRAPH
    {0xF5E1, 0x792D}, //12846 #CJK UNIFIED IDEOGRAPH
    {0xF5E2, 0x7931}, //12847 #CJK UNIFIED IDEOGRAPH
    {0xF5E3, 0x792F}, //12848 #CJK UNIFIED IDEOGRAPH
    {0xF5E4, 0x7C54}, //12849 #CJK UNIFIED IDEOGRAPH
    {0xF5E5, 0x7C53}, //12850 #CJK UNIFIED IDEOGRAPH
    {0xF5E6, 0x7CF2}, //12851 #CJK UNIFIED IDEOGRAPH
    {0xF5E7, 0x7E8A}, //12852 #CJK UNIFIED IDEOGRAPH
    {0xF5E8, 0x7E87}, //12853 #CJK UNIFIED IDEOGRAPH
    {0xF5E9, 0x7E88}, //12854 #CJK UNIFIED IDEOGRAPH
    {0xF5EA, 0x7E8B}, //12855 #CJK UNIFIED IDEOGRAPH
    {0xF5EB, 0x7E86}, //12856 #CJK UNIFIED IDEOGRAPH
    {0xF5EC, 0x7E8D}, //12857 #CJK UNIFIED IDEOGRAPH
    {0xF5ED, 0x7F4D}, //12858 #CJK UNIFIED IDEOGRAPH
    {0xF5EE, 0x7FBB}, //12859 #CJK UNIFIED IDEOGRAPH
    {0xF5EF, 0x8030}, //12860 #CJK UNIFIED IDEOGRAPH
    {0xF5F0, 0x81DD}, //12861 #CJK UNIFIED IDEOGRAPH
    {0xF5F1, 0x8618}, //12862 #CJK UNIFIED IDEOGRAPH
    {0xF5F2, 0x862A}, //12863 #CJK UNIFIED IDEOGRAPH
    {0xF5F3, 0x8626}, //12864 #CJK UNIFIED IDEOGRAPH
    {0xF5F4, 0x861F}, //12865 #CJK UNIFIED IDEOGRAPH
    {0xF5F5, 0x8623}, //12866 #CJK UNIFIED IDEOGRAPH
    {0xF5F6, 0x861C}, //12867 #CJK UNIFIED IDEOGRAPH
    {0xF5F7, 0x8619}, //12868 #CJK UNIFIED IDEOGRAPH
    {0xF5F8, 0x8627}, //12869 #CJK UNIFIED IDEOGRAPH
    {0xF5F9, 0x862E}, //12870 #CJK UNIFIED IDEOGRAPH
    {0xF5FA, 0x8621}, //12871 #CJK UNIFIED IDEOGRAPH
    {0xF5FB, 0x8620}, //12872 #CJK UNIFIED IDEOGRAPH
    {0xF5FC, 0x8629}, //12873 #CJK UNIFIED IDEOGRAPH
    {0xF5FD, 0x861E}, //12874 #CJK UNIFIED IDEOGRAPH
    {0xF5FE, 0x8625}, //12875 #CJK UNIFIED IDEOGRAPH
    {0xF640, 0x8829}, //12876 #CJK UNIFIED IDEOGRAPH
    {0xF641, 0x881D}, //12877 #CJK UNIFIED IDEOGRAPH
    {0xF642, 0x881B}, //12878 #CJK UNIFIED IDEOGRAPH
    {0xF643, 0x8820}, //12879 #CJK UNIFIED IDEOGRAPH
    {0xF644, 0x8824}, //12880 #CJK UNIFIED IDEOGRAPH
    {0xF645, 0x881C}, //12881 #CJK UNIFIED IDEOGRAPH
    {0xF646, 0x882B}, //12882 #CJK UNIFIED IDEOGRAPH
    {0xF647, 0x884A}, //12883 #CJK UNIFIED IDEOGRAPH
    {0xF648, 0x896D}, //12884 #CJK UNIFIED IDEOGRAPH
    {0xF649, 0x8969}, //12885 #CJK UNIFIED IDEOGRAPH
    {0xF64A, 0x896E}, //12886 #CJK UNIFIED IDEOGRAPH
    {0xF64B, 0x896B}, //12887 #CJK UNIFIED IDEOGRAPH
    {0xF64C, 0x89FA}, //12888 #CJK UNIFIED IDEOGRAPH
    {0xF64D, 0x8B79}, //12889 #CJK UNIFIED IDEOGRAPH
    {0xF64E, 0x8B78}, //12890 #CJK UNIFIED IDEOGRAPH
    {0xF64F, 0x8B45}, //12891 #CJK UNIFIED IDEOGRAPH
    {0xF650, 0x8B7A}, //12892 #CJK UNIFIED IDEOGRAPH
    {0xF651, 0x8B7B}, //12893 #CJK UNIFIED IDEOGRAPH
    {0xF652, 0x8D10}, //12894 #CJK UNIFIED IDEOGRAPH
    {0xF653, 0x8D14}, //12895 #CJK UNIFIED IDEOGRAPH
    {0xF654, 0x8DAF}, //12896 #CJK UNIFIED IDEOGRAPH
    {0xF655, 0x8E8E}, //12897 #CJK UNIFIED IDEOGRAPH
    {0xF656, 0x8E8C}, //12898 #CJK UNIFIED IDEOGRAPH
    {0xF657, 0x8F5E}, //12899 #CJK UNIFIED IDEOGRAPH
    {0xF658, 0x8F5B}, //12900 #CJK UNIFIED IDEOGRAPH
    {0xF659, 0x8F5D}, //12901 #CJK UNIFIED IDEOGRAPH
    {0xF65A, 0x9146}, //12902 #CJK UNIFIED IDEOGRAPH
    {0xF65B, 0x9144}, //12903 #CJK UNIFIED IDEOGRAPH
    {0xF65C, 0x9145}, //12904 #CJK UNIFIED IDEOGRAPH
    {0xF65D, 0x91B9}, //12905 #CJK UNIFIED IDEOGRAPH
    {0xF65E, 0x943F}, //12906 #CJK UNIFIED IDEOGRAPH
    {0xF65F, 0x943B}, //12907 #CJK UNIFIED IDEOGRAPH
    {0xF660, 0x9436}, //12908 #CJK UNIFIED IDEOGRAPH
    {0xF661, 0x9429}, //12909 #CJK UNIFIED IDEOGRAPH
    {0xF662, 0x943D}, //12910 #CJK UNIFIED IDEOGRAPH
    {0xF663, 0x943C}, //12911 #CJK UNIFIED IDEOGRAPH
    {0xF664, 0x9430}, //12912 #CJK UNIFIED IDEOGRAPH
    {0xF665, 0x9439}, //12913 #CJK UNIFIED IDEOGRAPH
    {0xF666, 0x942A}, //12914 #CJK UNIFIED IDEOGRAPH
    {0xF667, 0x9437}, //12915 #CJK UNIFIED IDEOGRAPH
    {0xF668, 0x942C}, //12916 #CJK UNIFIED IDEOGRAPH
    {0xF669, 0x9440}, //12917 #CJK UNIFIED IDEOGRAPH
    {0xF66A, 0x9431}, //12918 #CJK UNIFIED IDEOGRAPH
    {0xF66B, 0x95E5}, //12919 #CJK UNIFIED IDEOGRAPH
    {0xF66C, 0x95E4}, //12920 #CJK UNIFIED IDEOGRAPH
    {0xF66D, 0x95E3}, //12921 #CJK UNIFIED IDEOGRAPH
    {0xF66E, 0x9735}, //12922 #CJK UNIFIED IDEOGRAPH
    {0xF66F, 0x973A}, //12923 #CJK UNIFIED IDEOGRAPH
    {0xF670, 0x97BF}, //12924 #CJK UNIFIED IDEOGRAPH
    {0xF671, 0x97E1}, //12925 #CJK UNIFIED IDEOGRAPH
    {0xF672, 0x9864}, //12926 #CJK UNIFIED IDEOGRAPH
    {0xF673, 0x98C9}, //12927 #CJK UNIFIED IDEOGRAPH
    {0xF674, 0x98C6}, //12928 #CJK UNIFIED IDEOGRAPH
    {0xF675, 0x98C0}, //12929 #CJK UNIFIED IDEOGRAPH
    {0xF676, 0x9958}, //12930 #CJK UNIFIED IDEOGRAPH
    {0xF677, 0x9956}, //12931 #CJK UNIFIED IDEOGRAPH
    {0xF678, 0x9A39}, //12932 #CJK UNIFIED IDEOGRAPH
    {0xF679, 0x9A3D}, //12933 #CJK UNIFIED IDEOGRAPH
    {0xF67A, 0x9A46}, //12934 #CJK UNIFIED IDEOGRAPH
    {0xF67B, 0x9A44}, //12935 #CJK UNIFIED IDEOGRAPH
    {0xF67C, 0x9A42}, //12936 #CJK UNIFIED IDEOGRAPH
    {0xF67D, 0x9A41}, //12937 #CJK UNIFIED IDEOGRAPH
    {0xF67E, 0x9A3A}, //12938 #CJK UNIFIED IDEOGRAPH
    {0xF6A1, 0x9A3F}, //12939 #CJK UNIFIED IDEOGRAPH
    {0xF6A2, 0x9ACD}, //12940 #CJK UNIFIED IDEOGRAPH
    {0xF6A3, 0x9B15}, //12941 #CJK UNIFIED IDEOGRAPH
    {0xF6A4, 0x9B17}, //12942 #CJK UNIFIED IDEOGRAPH
    {0xF6A5, 0x9B18}, //12943 #CJK UNIFIED IDEOGRAPH
    {0xF6A6, 0x9B16}, //12944 #CJK UNIFIED IDEOGRAPH
    {0xF6A7, 0x9B3A}, //12945 #CJK UNIFIED IDEOGRAPH
    {0xF6A8, 0x9B52}, //12946 #CJK UNIFIED IDEOGRAPH
    {0xF6A9, 0x9C2B}, //12947 #CJK UNIFIED IDEOGRAPH
    {0xF6AA, 0x9C1D}, //12948 #CJK UNIFIED IDEOGRAPH
    {0xF6AB, 0x9C1C}, //12949 #CJK UNIFIED IDEOGRAPH
    {0xF6AC, 0x9C2C}, //12950 #CJK UNIFIED IDEOGRAPH
    {0xF6AD, 0x9C23}, //12951 #CJK UNIFIED IDEOGRAPH
    {0xF6AE, 0x9C28}, //12952 #CJK UNIFIED IDEOGRAPH
    {0xF6AF, 0x9C29}, //12953 #CJK UNIFIED IDEOGRAPH
    {0xF6B0, 0x9C24}, //12954 #CJK UNIFIED IDEOGRAPH
    {0xF6B1, 0x9C21}, //12955 #CJK UNIFIED IDEOGRAPH
    {0xF6B2, 0x9DB7}, //12956 #CJK UNIFIED IDEOGRAPH
    {0xF6B3, 0x9DB6}, //12957 #CJK UNIFIED IDEOGRAPH
    {0xF6B4, 0x9DBC}, //12958 #CJK UNIFIED IDEOGRAPH
    {0xF6B5, 0x9DC1}, //12959 #CJK UNIFIED IDEOGRAPH
    {0xF6B6, 0x9DC7}, //12960 #CJK UNIFIED IDEOGRAPH
    {0xF6B7, 0x9DCA}, //12961 #CJK UNIFIED IDEOGRAPH
    {0xF6B8, 0x9DCF}, //12962 #CJK UNIFIED IDEOGRAPH
    {0xF6B9, 0x9DBE}, //12963 #CJK UNIFIED IDEOGRAPH
    {0xF6BA, 0x9DC5}, //12964 #CJK UNIFIED IDEOGRAPH
    {0xF6BB, 0x9DC3}, //12965 #CJK UNIFIED IDEOGRAPH
    {0xF6BC, 0x9DBB}, //12966 #CJK UNIFIED IDEOGRAPH
    {0xF6BD, 0x9DB5}, //12967 #CJK UNIFIED IDEOGRAPH
    {0xF6BE, 0x9DCE}, //12968 #CJK UNIFIED IDEOGRAPH
    {0xF6BF, 0x9DB9}, //12969 #CJK UNIFIED IDEOGRAPH
    {0xF6C0, 0x9DBA}, //12970 #CJK UNIFIED IDEOGRAPH
    {0xF6C1, 0x9DAC}, //12971 #CJK UNIFIED IDEOGRAPH
    {0xF6C2, 0x9DC8}, //12972 #CJK UNIFIED IDEOGRAPH
    {0xF6C3, 0x9DB1}, //12973 #CJK UNIFIED IDEOGRAPH
    {0xF6C4, 0x9DAD}, //12974 #CJK UNIFIED IDEOGRAPH
    {0xF6C5, 0x9DCC}, //12975 #CJK UNIFIED IDEOGRAPH
    {0xF6C6, 0x9DB3}, //12976 #CJK UNIFIED IDEOGRAPH
    {0xF6C7, 0x9DCD}, //12977 #CJK UNIFIED IDEOGRAPH
    {0xF6C8, 0x9DB2}, //12978 #CJK UNIFIED IDEOGRAPH
    {0xF6C9, 0x9E7A}, //12979 #CJK UNIFIED IDEOGRAPH
    {0xF6CA, 0x9E9C}, //12980 #CJK UNIFIED IDEOGRAPH
    {0xF6CB, 0x9EEB}, //12981 #CJK UNIFIED IDEOGRAPH
    {0xF6CC, 0x9EEE}, //12982 #CJK UNIFIED IDEOGRAPH
    {0xF6CD, 0x9EED}, //12983 #CJK UNIFIED IDEOGRAPH
    {0xF6CE, 0x9F1B}, //12984 #CJK UNIFIED IDEOGRAPH
    {0xF6CF, 0x9F18}, //12985 #CJK UNIFIED IDEOGRAPH
    {0xF6D0, 0x9F1A}, //12986 #CJK UNIFIED IDEOGRAPH
    {0xF6D1, 0x9F31}, //12987 #CJK UNIFIED IDEOGRAPH
    {0xF6D2, 0x9F4E}, //12988 #CJK UNIFIED IDEOGRAPH
    {0xF6D3, 0x9F65}, //12989 #CJK UNIFIED IDEOGRAPH
    {0xF6D4, 0x9F64}, //12990 #CJK UNIFIED IDEOGRAPH
    {0xF6D5, 0x9F92}, //12991 #CJK UNIFIED IDEOGRAPH
    {0xF6D6, 0x4EB9}, //12992 #CJK UNIFIED IDEOGRAPH
    {0xF6D7, 0x56C6}, //12993 #CJK UNIFIED IDEOGRAPH
    {0xF6D8, 0x56C5}, //12994 #CJK UNIFIED IDEOGRAPH
    {0xF6D9, 0x56CB}, //12995 #CJK UNIFIED IDEOGRAPH
    {0xF6DA, 0x5971}, //12996 #CJK UNIFIED IDEOGRAPH
    {0xF6DB, 0x5B4B}, //12997 #CJK UNIFIED IDEOGRAPH
    {0xF6DC, 0x5B4C}, //12998 #CJK UNIFIED IDEOGRAPH
    {0xF6DD, 0x5DD5}, //12999 #CJK UNIFIED IDEOGRAPH
    {0xF6DE, 0x5DD1}, //13000 #CJK UNIFIED IDEOGRAPH
    {0xF6DF, 0x5EF2}, //13001 #CJK UNIFIED IDEOGRAPH
    {0xF6E0, 0x6521}, //13002 #CJK UNIFIED IDEOGRAPH
    {0xF6E1, 0x6520}, //13003 #CJK UNIFIED IDEOGRAPH
    {0xF6E2, 0x6526}, //13004 #CJK UNIFIED IDEOGRAPH
    {0xF6E3, 0x6522}, //13005 #CJK UNIFIED IDEOGRAPH
    {0xF6E4, 0x6B0B}, //13006 #CJK UNIFIED IDEOGRAPH
    {0xF6E5, 0x6B08}, //13007 #CJK UNIFIED IDEOGRAPH
    {0xF6E6, 0x6B09}, //13008 #CJK UNIFIED IDEOGRAPH
    {0xF6E7, 0x6C0D}, //13009 #CJK UNIFIED IDEOGRAPH
    {0xF6E8, 0x7055}, //13010 #CJK UNIFIED IDEOGRAPH
    {0xF6E9, 0x7056}, //13011 #CJK UNIFIED IDEOGRAPH
    {0xF6EA, 0x7057}, //13012 #CJK UNIFIED IDEOGRAPH
    {0xF6EB, 0x7052}, //13013 #CJK UNIFIED IDEOGRAPH
    {0xF6EC, 0x721E}, //13014 #CJK UNIFIED IDEOGRAPH
    {0xF6ED, 0x721F}, //13015 #CJK UNIFIED IDEOGRAPH
    {0xF6EE, 0x72A9}, //13016 #CJK UNIFIED IDEOGRAPH
    {0xF6EF, 0x737F}, //13017 #CJK UNIFIED IDEOGRAPH
    {0xF6F0, 0x74D8}, //13018 #CJK UNIFIED IDEOGRAPH
    {0xF6F1, 0x74D5}, //13019 #CJK UNIFIED IDEOGRAPH
    {0xF6F2, 0x74D9}, //13020 #CJK UNIFIED IDEOGRAPH
    {0xF6F3, 0x74D7}, //13021 #CJK UNIFIED IDEOGRAPH
    {0xF6F4, 0x766D}, //13022 #CJK UNIFIED IDEOGRAPH
    {0xF6F5, 0x76AD}, //13023 #CJK UNIFIED IDEOGRAPH
    {0xF6F6, 0x7935}, //13024 #CJK UNIFIED IDEOGRAPH
    {0xF6F7, 0x79B4}, //13025 #CJK UNIFIED IDEOGRAPH
    {0xF6F8, 0x7A70}, //13026 #CJK UNIFIED IDEOGRAPH
    {0xF6F9, 0x7A71}, //13027 #CJK UNIFIED IDEOGRAPH
    {0xF6FA, 0x7C57}, //13028 #CJK UNIFIED IDEOGRAPH
    {0xF6FB, 0x7C5C}, //13029 #CJK UNIFIED IDEOGRAPH
    {0xF6FC, 0x7C59}, //13030 #CJK UNIFIED IDEOGRAPH
    {0xF6FD, 0x7C5B}, //13031 #CJK UNIFIED IDEOGRAPH
    {0xF6FE, 0x7C5A}, //13032 #CJK UNIFIED IDEOGRAPH
    {0xF740, 0x7CF4}, //13033 #CJK UNIFIED IDEOGRAPH
    {0xF741, 0x7CF1}, //13034 #CJK UNIFIED IDEOGRAPH
    {0xF742, 0x7E91}, //13035 #CJK UNIFIED IDEOGRAPH
    {0xF743, 0x7F4F}, //13036 #CJK UNIFIED IDEOGRAPH
    {0xF744, 0x7F87}, //13037 #CJK UNIFIED IDEOGRAPH
    {0xF745, 0x81DE}, //13038 #CJK UNIFIED IDEOGRAPH
    {0xF746, 0x826B}, //13039 #CJK UNIFIED IDEOGRAPH
    {0xF747, 0x8634}, //13040 #CJK UNIFIED IDEOGRAPH
    {0xF748, 0x8635}, //13041 #CJK UNIFIED IDEOGRAPH
    {0xF749, 0x8633}, //13042 #CJK UNIFIED IDEOGRAPH
    {0xF74A, 0x862C}, //13043 #CJK UNIFIED IDEOGRAPH
    {0xF74B, 0x8632}, //13044 #CJK UNIFIED IDEOGRAPH
    {0xF74C, 0x8636}, //13045 #CJK UNIFIED IDEOGRAPH
    {0xF74D, 0x882C}, //13046 #CJK UNIFIED IDEOGRAPH
    {0xF74E, 0x8828}, //13047 #CJK UNIFIED IDEOGRAPH
    {0xF74F, 0x8826}, //13048 #CJK UNIFIED IDEOGRAPH
    {0xF750, 0x882A}, //13049 #CJK UNIFIED IDEOGRAPH
    {0xF751, 0x8825}, //13050 #CJK UNIFIED IDEOGRAPH
    {0xF752, 0x8971}, //13051 #CJK UNIFIED IDEOGRAPH
    {0xF753, 0x89BF}, //13052 #CJK UNIFIED IDEOGRAPH
    {0xF754, 0x89BE}, //13053 #CJK UNIFIED IDEOGRAPH
    {0xF755, 0x89FB}, //13054 #CJK UNIFIED IDEOGRAPH
    {0xF756, 0x8B7E}, //13055 #CJK UNIFIED IDEOGRAPH
    {0xF757, 0x8B84}, //13056 #CJK UNIFIED IDEOGRAPH
    {0xF758, 0x8B82}, //13057 #CJK UNIFIED IDEOGRAPH
    {0xF759, 0x8B86}, //13058 #CJK UNIFIED IDEOGRAPH
    {0xF75A, 0x8B85}, //13059 #CJK UNIFIED IDEOGRAPH
    {0xF75B, 0x8B7F}, //13060 #CJK UNIFIED IDEOGRAPH
    {0xF75C, 0x8D15}, //13061 #CJK UNIFIED IDEOGRAPH
    {0xF75D, 0x8E95}, //13062 #CJK UNIFIED IDEOGRAPH
    {0xF75E, 0x8E94}, //13063 #CJK UNIFIED IDEOGRAPH
    {0xF75F, 0x8E9A}, //13064 #CJK UNIFIED IDEOGRAPH
    {0xF760, 0x8E92}, //13065 #CJK UNIFIED IDEOGRAPH
    {0xF761, 0x8E90}, //13066 #CJK UNIFIED IDEOGRAPH
    {0xF762, 0x8E96}, //13067 #CJK UNIFIED IDEOGRAPH
    {0xF763, 0x8E97}, //13068 #CJK UNIFIED IDEOGRAPH
    {0xF764, 0x8F60}, //13069 #CJK UNIFIED IDEOGRAPH
    {0xF765, 0x8F62}, //13070 #CJK UNIFIED IDEOGRAPH
    {0xF766, 0x9147}, //13071 #CJK UNIFIED IDEOGRAPH
    {0xF767, 0x944C}, //13072 #CJK UNIFIED IDEOGRAPH
    {0xF768, 0x9450}, //13073 #CJK UNIFIED IDEOGRAPH
    {0xF769, 0x944A}, //13074 #CJK UNIFIED IDEOGRAPH
    {0xF76A, 0x944B}, //13075 #CJK UNIFIED IDEOGRAPH
    {0xF76B, 0x944F}, //13076 #CJK UNIFIED IDEOGRAPH
    {0xF76C, 0x9447}, //13077 #CJK UNIFIED IDEOGRAPH
    {0xF76D, 0x9445}, //13078 #CJK UNIFIED IDEOGRAPH
    {0xF76E, 0x9448}, //13079 #CJK UNIFIED IDEOGRAPH
    {0xF76F, 0x9449}, //13080 #CJK UNIFIED IDEOGRAPH
    {0xF770, 0x9446}, //13081 #CJK UNIFIED IDEOGRAPH
    {0xF771, 0x973F}, //13082 #CJK UNIFIED IDEOGRAPH
    {0xF772, 0x97E3}, //13083 #CJK UNIFIED IDEOGRAPH
    {0xF773, 0x986A}, //13084 #CJK UNIFIED IDEOGRAPH
    {0xF774, 0x9869}, //13085 #CJK UNIFIED IDEOGRAPH
    {0xF775, 0x98CB}, //13086 #CJK UNIFIED IDEOGRAPH
    {0xF776, 0x9954}, //13087 #CJK UNIFIED IDEOGRAPH
    {0xF777, 0x995B}, //13088 #CJK UNIFIED IDEOGRAPH
    {0xF778, 0x9A4E}, //13089 #CJK UNIFIED IDEOGRAPH
    {0xF779, 0x9A53}, //13090 #CJK UNIFIED IDEOGRAPH
    {0xF77A, 0x9A54}, //13091 #CJK UNIFIED IDEOGRAPH
    {0xF77B, 0x9A4C}, //13092 #CJK UNIFIED IDEOGRAPH
    {0xF77C, 0x9A4F}, //13093 #CJK UNIFIED IDEOGRAPH
    {0xF77D, 0x9A48}, //13094 #CJK UNIFIED IDEOGRAPH
    {0xF77E, 0x9A4A}, //13095 #CJK UNIFIED IDEOGRAPH
    {0xF7A1, 0x9A49}, //13096 #CJK UNIFIED IDEOGRAPH
    {0xF7A2, 0x9A52}, //13097 #CJK UNIFIED IDEOGRAPH
    {0xF7A3, 0x9A50}, //13098 #CJK UNIFIED IDEOGRAPH
    {0xF7A4, 0x9AD0}, //13099 #CJK UNIFIED IDEOGRAPH
    {0xF7A5, 0x9B19}, //13100 #CJK UNIFIED IDEOGRAPH
    {0xF7A6, 0x9B2B}, //13101 #CJK UNIFIED IDEOGRAPH
    {0xF7A7, 0x9B3B}, //13102 #CJK UNIFIED IDEOGRAPH
    {0xF7A8, 0x9B56}, //13103 #CJK UNIFIED IDEOGRAPH
    {0xF7A9, 0x9B55}, //13104 #CJK UNIFIED IDEOGRAPH
    {0xF7AA, 0x9C46}, //13105 #CJK UNIFIED IDEOGRAPH
    {0xF7AB, 0x9C48}, //13106 #CJK UNIFIED IDEOGRAPH
    {0xF7AC, 0x9C3F}, //13107 #CJK UNIFIED IDEOGRAPH
    {0xF7AD, 0x9C44}, //13108 #CJK UNIFIED IDEOGRAPH
    {0xF7AE, 0x9C39}, //13109 #CJK UNIFIED IDEOGRAPH
    {0xF7AF, 0x9C33}, //13110 #CJK UNIFIED IDEOGRAPH
    {0xF7B0, 0x9C41}, //13111 #CJK UNIFIED IDEOGRAPH
    {0xF7B1, 0x9C3C}, //13112 #CJK UNIFIED IDEOGRAPH
    {0xF7B2, 0x9C37}, //13113 #CJK UNIFIED IDEOGRAPH
    {0xF7B3, 0x9C34}, //13114 #CJK UNIFIED IDEOGRAPH
    {0xF7B4, 0x9C32}, //13115 #CJK UNIFIED IDEOGRAPH
    {0xF7B5, 0x9C3D}, //13116 #CJK UNIFIED IDEOGRAPH
    {0xF7B6, 0x9C36}, //13117 #CJK UNIFIED IDEOGRAPH
    {0xF7B7, 0x9DDB}, //13118 #CJK UNIFIED IDEOGRAPH
    {0xF7B8, 0x9DD2}, //13119 #CJK UNIFIED IDEOGRAPH
    {0xF7B9, 0x9DDE}, //13120 #CJK UNIFIED IDEOGRAPH
    {0xF7BA, 0x9DDA}, //13121 #CJK UNIFIED IDEOGRAPH
    {0xF7BB, 0x9DCB}, //13122 #CJK UNIFIED IDEOGRAPH
    {0xF7BC, 0x9DD0}, //13123 #CJK UNIFIED IDEOGRAPH
    {0xF7BD, 0x9DDC}, //13124 #CJK UNIFIED IDEOGRAPH
    {0xF7BE, 0x9DD1}, //13125 #CJK UNIFIED IDEOGRAPH
    {0xF7BF, 0x9DDF}, //13126 #CJK UNIFIED IDEOGRAPH
    {0xF7C0, 0x9DE9}, //13127 #CJK UNIFIED IDEOGRAPH
    {0xF7C1, 0x9DD9}, //13128 #CJK UNIFIED IDEOGRAPH
    {0xF7C2, 0x9DD8}, //13129 #CJK UNIFIED IDEOGRAPH
    {0xF7C3, 0x9DD6}, //13130 #CJK UNIFIED IDEOGRAPH
    {0xF7C4, 0x9DF5}, //13131 #CJK UNIFIED IDEOGRAPH
    {0xF7C5, 0x9DD5}, //13132 #CJK UNIFIED IDEOGRAPH
    {0xF7C6, 0x9DDD}, //13133 #CJK UNIFIED IDEOGRAPH
    {0xF7C7, 0x9EB6}, //13134 #CJK UNIFIED IDEOGRAPH
    {0xF7C8, 0x9EF0}, //13135 #CJK UNIFIED IDEOGRAPH
    {0xF7C9, 0x9F35}, //13136 #CJK UNIFIED IDEOGRAPH
    {0xF7CA, 0x9F33}, //13137 #CJK UNIFIED IDEOGRAPH
    {0xF7CB, 0x9F32}, //13138 #CJK UNIFIED IDEOGRAPH
    {0xF7CC, 0x9F42}, //13139 #CJK UNIFIED IDEOGRAPH
    {0xF7CD, 0x9F6B}, //13140 #CJK UNIFIED IDEOGRAPH
    {0xF7CE, 0x9F95}, //13141 #CJK UNIFIED IDEOGRAPH
    {0xF7CF, 0x9FA2}, //13142 #CJK UNIFIED IDEOGRAPH
    {0xF7D0, 0x513D}, //13143 #CJK UNIFIED IDEOGRAPH
    {0xF7D1, 0x5299}, //13144 #CJK UNIFIED IDEOGRAPH
    {0xF7D2, 0x58E8}, //13145 #CJK UNIFIED IDEOGRAPH
    {0xF7D3, 0x58E7}, //13146 #CJK UNIFIED IDEOGRAPH
    {0xF7D4, 0x5972}, //13147 #CJK UNIFIED IDEOGRAPH
    {0xF7D5, 0x5B4D}, //13148 #CJK UNIFIED IDEOGRAPH
    {0xF7D6, 0x5DD8}, //13149 #CJK UNIFIED IDEOGRAPH
    {0xF7D7, 0x882F}, //13150 #CJK UNIFIED IDEOGRAPH
    {0xF7D8, 0x5F4F}, //13151 #CJK UNIFIED IDEOGRAPH
    {0xF7D9, 0x6201}, //13152 #CJK UNIFIED IDEOGRAPH
    {0xF7DA, 0x6203}, //13153 #CJK UNIFIED IDEOGRAPH
    {0xF7DB, 0x6204}, //13154 #CJK UNIFIED IDEOGRAPH
    {0xF7DC, 0x6529}, //13155 #CJK UNIFIED IDEOGRAPH
    {0xF7DD, 0x6525}, //13156 #CJK UNIFIED IDEOGRAPH
    {0xF7DE, 0x6596}, //13157 #CJK UNIFIED IDEOGRAPH
    {0xF7DF, 0x66EB}, //13158 #CJK UNIFIED IDEOGRAPH
    {0xF7E0, 0x6B11}, //13159 #CJK UNIFIED IDEOGRAPH
    {0xF7E1, 0x6B12}, //13160 #CJK UNIFIED IDEOGRAPH
    {0xF7E2, 0x6B0F}, //13161 #CJK UNIFIED IDEOGRAPH
    {0xF7E3, 0x6BCA}, //13162 #CJK UNIFIED IDEOGRAPH
    {0xF7E4, 0x705B}, //13163 #CJK UNIFIED IDEOGRAPH
    {0xF7E5, 0x705A}, //13164 #CJK UNIFIED IDEOGRAPH
    {0xF7E6, 0x7222}, //13165 #CJK UNIFIED IDEOGRAPH
    {0xF7E7, 0x7382}, //13166 #CJK UNIFIED IDEOGRAPH
    {0xF7E8, 0x7381}, //13167 #CJK UNIFIED IDEOGRAPH
    {0xF7E9, 0x7383}, //13168 #CJK UNIFIED IDEOGRAPH
    {0xF7EA, 0x7670}, //13169 #CJK UNIFIED IDEOGRAPH
    {0xF7EB, 0x77D4}, //13170 #CJK UNIFIED IDEOGRAPH
    {0xF7EC, 0x7C67}, //13171 #CJK UNIFIED IDEOGRAPH
    {0xF7ED, 0x7C66}, //13172 #CJK UNIFIED IDEOGRAPH
    {0xF7EE, 0x7E95}, //13173 #CJK UNIFIED IDEOGRAPH
    {0xF7EF, 0x826C}, //13174 #CJK UNIFIED IDEOGRAPH
    {0xF7F0, 0x863A}, //13175 #CJK UNIFIED IDEOGRAPH
    {0xF7F1, 0x8640}, //13176 #CJK UNIFIED IDEOGRAPH
    {0xF7F2, 0x8639}, //13177 #CJK UNIFIED IDEOGRAPH
    {0xF7F3, 0x863C}, //13178 #CJK UNIFIED IDEOGRAPH
    {0xF7F4, 0x8631}, //13179 #CJK UNIFIED IDEOGRAPH
    {0xF7F5, 0x863B}, //13180 #CJK UNIFIED IDEOGRAPH
    {0xF7F6, 0x863E}, //13181 #CJK UNIFIED IDEOGRAPH
    {0xF7F7, 0x8830}, //13182 #CJK UNIFIED IDEOGRAPH
    {0xF7F8, 0x8832}, //13183 #CJK UNIFIED IDEOGRAPH
    {0xF7F9, 0x882E}, //13184 #CJK UNIFIED IDEOGRAPH
    {0xF7FA, 0x8833}, //13185 #CJK UNIFIED IDEOGRAPH
    {0xF7FB, 0x8976}, //13186 #CJK UNIFIED IDEOGRAPH
    {0xF7FC, 0x8974}, //13187 #CJK UNIFIED IDEOGRAPH
    {0xF7FD, 0x8973}, //13188 #CJK UNIFIED IDEOGRAPH
    {0xF7FE, 0x89FE}, //13189 #CJK UNIFIED IDEOGRAPH
    {0xF840, 0x8B8C}, //13190 #CJK UNIFIED IDEOGRAPH
    {0xF841, 0x8B8E}, //13191 #CJK UNIFIED IDEOGRAPH
    {0xF842, 0x8B8B}, //13192 #CJK UNIFIED IDEOGRAPH
    {0xF843, 0x8B88}, //13193 #CJK UNIFIED IDEOGRAPH
    {0xF844, 0x8C45}, //13194 #CJK UNIFIED IDEOGRAPH
    {0xF845, 0x8D19}, //13195 #CJK UNIFIED IDEOGRAPH
    {0xF846, 0x8E98}, //13196 #CJK UNIFIED IDEOGRAPH
    {0xF847, 0x8F64}, //13197 #CJK UNIFIED IDEOGRAPH
    {0xF848, 0x8F63}, //13198 #CJK UNIFIED IDEOGRAPH
    {0xF849, 0x91BC}, //13199 #CJK UNIFIED IDEOGRAPH
    {0xF84A, 0x9462}, //13200 #CJK UNIFIED IDEOGRAPH
    {0xF84B, 0x9455}, //13201 #CJK UNIFIED IDEOGRAPH
    {0xF84C, 0x945D}, //13202 #CJK UNIFIED IDEOGRAPH
    {0xF84D, 0x9457}, //13203 #CJK UNIFIED IDEOGRAPH
    {0xF84E, 0x945E}, //13204 #CJK UNIFIED IDEOGRAPH
    {0xF84F, 0x97C4}, //13205 #CJK UNIFIED IDEOGRAPH
    {0xF850, 0x97C5}, //13206 #CJK UNIFIED IDEOGRAPH
    {0xF851, 0x9800}, //13207 #CJK UNIFIED IDEOGRAPH
    {0xF852, 0x9A56}, //13208 #CJK UNIFIED IDEOGRAPH
    {0xF853, 0x9A59}, //13209 #CJK UNIFIED IDEOGRAPH
    {0xF854, 0x9B1E}, //13210 #CJK UNIFIED IDEOGRAPH
    {0xF855, 0x9B1F}, //13211 #CJK UNIFIED IDEOGRAPH
    {0xF856, 0x9B20}, //13212 #CJK UNIFIED IDEOGRAPH
    {0xF857, 0x9C52}, //13213 #CJK UNIFIED IDEOGRAPH
    {0xF858, 0x9C58}, //13214 #CJK UNIFIED IDEOGRAPH
    {0xF859, 0x9C50}, //13215 #CJK UNIFIED IDEOGRAPH
    {0xF85A, 0x9C4A}, //13216 #CJK UNIFIED IDEOGRAPH
    {0xF85B, 0x9C4D}, //13217 #CJK UNIFIED IDEOGRAPH
    {0xF85C, 0x9C4B}, //13218 #CJK UNIFIED IDEOGRAPH
    {0xF85D, 0x9C55}, //13219 #CJK UNIFIED IDEOGRAPH
    {0xF85E, 0x9C59}, //13220 #CJK UNIFIED IDEOGRAPH
    {0xF85F, 0x9C4C}, //13221 #CJK UNIFIED IDEOGRAPH
    {0xF860, 0x9C4E}, //13222 #CJK UNIFIED IDEOGRAPH
    {0xF861, 0x9DFB}, //13223 #CJK UNIFIED IDEOGRAPH
    {0xF862, 0x9DF7}, //13224 #CJK UNIFIED IDEOGRAPH
    {0xF863, 0x9DEF}, //13225 #CJK UNIFIED IDEOGRAPH
    {0xF864, 0x9DE3}, //13226 #CJK UNIFIED IDEOGRAPH
    {0xF865, 0x9DEB}, //13227 #CJK UNIFIED IDEOGRAPH
    {0xF866, 0x9DF8}, //13228 #CJK UNIFIED IDEOGRAPH
    {0xF867, 0x9DE4}, //13229 #CJK UNIFIED IDEOGRAPH
    {0xF868, 0x9DF6}, //13230 #CJK UNIFIED IDEOGRAPH
    {0xF869, 0x9DE1}, //13231 #CJK UNIFIED IDEOGRAPH
    {0xF86A, 0x9DEE}, //13232 #CJK UNIFIED IDEOGRAPH
    {0xF86B, 0x9DE6}, //13233 #CJK UNIFIED IDEOGRAPH
    {0xF86C, 0x9DF2}, //13234 #CJK UNIFIED IDEOGRAPH
    {0xF86D, 0x9DF0}, //13235 #CJK UNIFIED IDEOGRAPH
    {0xF86E, 0x9DE2}, //13236 #CJK UNIFIED IDEOGRAPH
    {0xF86F, 0x9DEC}, //13237 #CJK UNIFIED IDEOGRAPH
    {0xF870, 0x9DF4}, //13238 #CJK UNIFIED IDEOGRAPH
    {0xF871, 0x9DF3}, //13239 #CJK UNIFIED IDEOGRAPH
    {0xF872, 0x9DE8}, //13240 #CJK UNIFIED IDEOGRAPH
    {0xF873, 0x9DED}, //13241 #CJK UNIFIED IDEOGRAPH
    {0xF874, 0x9EC2}, //13242 #CJK UNIFIED IDEOGRAPH
    {0xF875, 0x9ED0}, //13243 #CJK UNIFIED IDEOGRAPH
    {0xF876, 0x9EF2}, //13244 #CJK UNIFIED IDEOGRAPH
    {0xF877, 0x9EF3}, //13245 #CJK UNIFIED IDEOGRAPH
    {0xF878, 0x9F06}, //13246 #CJK UNIFIED IDEOGRAPH
    {0xF879, 0x9F1C}, //13247 #CJK UNIFIED IDEOGRAPH
    {0xF87A, 0x9F38}, //13248 #CJK UNIFIED IDEOGRAPH
    {0xF87B, 0x9F37}, //13249 #CJK UNIFIED IDEOGRAPH
    {0xF87C, 0x9F36}, //13250 #CJK UNIFIED IDEOGRAPH
    {0xF87D, 0x9F43}, //13251 #CJK UNIFIED IDEOGRAPH
    {0xF87E, 0x9F4F}, //13252 #CJK UNIFIED IDEOGRAPH
    {0xF8A1, 0x9F71}, //13253 #CJK UNIFIED IDEOGRAPH
    {0xF8A2, 0x9F70}, //13254 #CJK UNIFIED IDEOGRAPH
    {0xF8A3, 0x9F6E}, //13255 #CJK UNIFIED IDEOGRAPH
    {0xF8A4, 0x9F6F}, //13256 #CJK UNIFIED IDEOGRAPH
    {0xF8A5, 0x56D3}, //13257 #CJK UNIFIED IDEOGRAPH
    {0xF8A6, 0x56CD}, //13258 #CJK UNIFIED IDEOGRAPH
    {0xF8A7, 0x5B4E}, //13259 #CJK UNIFIED IDEOGRAPH
    {0xF8A8, 0x5C6D}, //13260 #CJK UNIFIED IDEOGRAPH
    {0xF8A9, 0x652D}, //13261 #CJK UNIFIED IDEOGRAPH
    {0xF8AA, 0x66ED}, //13262 #CJK UNIFIED IDEOGRAPH
    {0xF8AB, 0x66EE}, //13263 #CJK UNIFIED IDEOGRAPH
    {0xF8AC, 0x6B13}, //13264 #CJK UNIFIED IDEOGRAPH
    {0xF8AD, 0x705F}, //13265 #CJK UNIFIED IDEOGRAPH
    {0xF8AE, 0x7061}, //13266 #CJK UNIFIED IDEOGRAPH
    {0xF8AF, 0x705D}, //13267 #CJK UNIFIED IDEOGRAPH
    {0xF8B0, 0x7060}, //13268 #CJK UNIFIED IDEOGRAPH
    {0xF8B1, 0x7223}, //13269 #CJK UNIFIED IDEOGRAPH
    {0xF8B2, 0x74DB}, //13270 #CJK UNIFIED IDEOGRAPH
    {0xF8B3, 0x74E5}, //13271 #CJK UNIFIED IDEOGRAPH
    {0xF8B4, 0x77D5}, //13272 #CJK UNIFIED IDEOGRAPH
    {0xF8B5, 0x7938}, //13273 #CJK UNIFIED IDEOGRAPH
    {0xF8B6, 0x79B7}, //13274 #CJK UNIFIED IDEOGRAPH
    {0xF8B7, 0x79B6}, //13275 #CJK UNIFIED IDEOGRAPH
    {0xF8B8, 0x7C6A}, //13276 #CJK UNIFIED IDEOGRAPH
    {0xF8B9, 0x7E97}, //13277 #CJK UNIFIED IDEOGRAPH
    {0xF8BA, 0x7F89}, //13278 #CJK UNIFIED IDEOGRAPH
    {0xF8BB, 0x826D}, //13279 #CJK UNIFIED IDEOGRAPH
    {0xF8BC, 0x8643}, //13280 #CJK UNIFIED IDEOGRAPH
    {0xF8BD, 0x8838}, //13281 #CJK UNIFIED IDEOGRAPH
    {0xF8BE, 0x8837}, //13282 #CJK UNIFIED IDEOGRAPH
    {0xF8BF, 0x8835}, //13283 #CJK UNIFIED IDEOGRAPH
    {0xF8C0, 0x884B}, //13284 #CJK UNIFIED IDEOGRAPH
    {0xF8C1, 0x8B94}, //13285 #CJK UNIFIED IDEOGRAPH
    {0xF8C2, 0x8B95}, //13286 #CJK UNIFIED IDEOGRAPH
    {0xF8C3, 0x8E9E}, //13287 #CJK UNIFIED IDEOGRAPH
    {0xF8C4, 0x8E9F}, //13288 #CJK UNIFIED IDEOGRAPH
    {0xF8C5, 0x8EA0}, //13289 #CJK UNIFIED IDEOGRAPH
    {0xF8C6, 0x8E9D}, //13290 #CJK UNIFIED IDEOGRAPH
    {0xF8C7, 0x91BE}, //13291 #CJK UNIFIED IDEOGRAPH
    {0xF8C8, 0x91BD}, //13292 #CJK UNIFIED IDEOGRAPH
    {0xF8C9, 0x91C2}, //13293 #CJK UNIFIED IDEOGRAPH
    {0xF8CA, 0x946B}, //13294 #CJK UNIFIED IDEOGRAPH
    {0xF8CB, 0x9468}, //13295 #CJK UNIFIED IDEOGRAPH
    {0xF8CC, 0x9469}, //13296 #CJK UNIFIED IDEOGRAPH
    {0xF8CD, 0x96E5}, //13297 #CJK UNIFIED IDEOGRAPH
    {0xF8CE, 0x9746}, //13298 #CJK UNIFIED IDEOGRAPH
    {0xF8CF, 0x9743}, //13299 #CJK UNIFIED IDEOGRAPH
    {0xF8D0, 0x9747}, //13300 #CJK UNIFIED IDEOGRAPH
    {0xF8D1, 0x97C7}, //13301 #CJK UNIFIED IDEOGRAPH
    {0xF8D2, 0x97E5}, //13302 #CJK UNIFIED IDEOGRAPH
    {0xF8D3, 0x9A5E}, //13303 #CJK UNIFIED IDEOGRAPH
    {0xF8D4, 0x9AD5}, //13304 #CJK UNIFIED IDEOGRAPH
    {0xF8D5, 0x9B59}, //13305 #CJK UNIFIED IDEOGRAPH
    {0xF8D6, 0x9C63}, //13306 #CJK UNIFIED IDEOGRAPH
    {0xF8D7, 0x9C67}, //13307 #CJK UNIFIED IDEOGRAPH
    {0xF8D8, 0x9C66}, //13308 #CJK UNIFIED IDEOGRAPH
    {0xF8D9, 0x9C62}, //13309 #CJK UNIFIED IDEOGRAPH
    {0xF8DA, 0x9C5E}, //13310 #CJK UNIFIED IDEOGRAPH
    {0xF8DB, 0x9C60}, //13311 #CJK UNIFIED IDEOGRAPH
    {0xF8DC, 0x9E02}, //13312 #CJK UNIFIED IDEOGRAPH
    {0xF8DD, 0x9DFE}, //13313 #CJK UNIFIED IDEOGRAPH
    {0xF8DE, 0x9E07}, //13314 #CJK UNIFIED IDEOGRAPH
    {0xF8DF, 0x9E03}, //13315 #CJK UNIFIED IDEOGRAPH
    {0xF8E0, 0x9E06}, //13316 #CJK UNIFIED IDEOGRAPH
    {0xF8E1, 0x9E05}, //13317 #CJK UNIFIED IDEOGRAPH
    {0xF8E2, 0x9E00}, //13318 #CJK UNIFIED IDEOGRAPH
    {0xF8E3, 0x9E01}, //13319 #CJK UNIFIED IDEOGRAPH
    {0xF8E4, 0x9E09}, //13320 #CJK UNIFIED IDEOGRAPH
    {0xF8E5, 0x9DFF}, //13321 #CJK UNIFIED IDEOGRAPH
    {0xF8E6, 0x9DFD}, //13322 #CJK UNIFIED IDEOGRAPH
    {0xF8E7, 0x9E04}, //13323 #CJK UNIFIED IDEOGRAPH
    {0xF8E8, 0x9EA0}, //13324 #CJK UNIFIED IDEOGRAPH
    {0xF8E9, 0x9F1E}, //13325 #CJK UNIFIED IDEOGRAPH
    {0xF8EA, 0x9F46}, //13326 #CJK UNIFIED IDEOGRAPH
    {0xF8EB, 0x9F74}, //13327 #CJK UNIFIED IDEOGRAPH
    {0xF8EC, 0x9F75}, //13328 #CJK UNIFIED IDEOGRAPH
    {0xF8ED, 0x9F76}, //13329 #CJK UNIFIED IDEOGRAPH
    {0xF8EE, 0x56D4}, //13330 #CJK UNIFIED IDEOGRAPH
    {0xF8EF, 0x652E}, //13331 #CJK UNIFIED IDEOGRAPH
    {0xF8F0, 0x65B8}, //13332 #CJK UNIFIED IDEOGRAPH
    {0xF8F1, 0x6B18}, //13333 #CJK UNIFIED IDEOGRAPH
    {0xF8F2, 0x6B19}, //13334 #CJK UNIFIED IDEOGRAPH
    {0xF8F3, 0x6B17}, //13335 #CJK UNIFIED IDEOGRAPH
    {0xF8F4, 0x6B1A}, //13336 #CJK UNIFIED IDEOGRAPH
    {0xF8F5, 0x7062}, //13337 #CJK UNIFIED IDEOGRAPH
    {0xF8F6, 0x7226}, //13338 #CJK UNIFIED IDEOGRAPH
    {0xF8F7, 0x72AA}, //13339 #CJK UNIFIED IDEOGRAPH
    {0xF8F8, 0x77D8}, //13340 #CJK UNIFIED IDEOGRAPH
    {0xF8F9, 0x77D9}, //13341 #CJK UNIFIED IDEOGRAPH
    {0xF8FA, 0x7939}, //13342 #CJK UNIFIED IDEOGRAPH
    {0xF8FB, 0x7C69}, //13343 #CJK UNIFIED IDEOGRAPH
    {0xF8FC, 0x7C6B}, //13344 #CJK UNIFIED IDEOGRAPH
    {0xF8FD, 0x7CF6}, //13345 #CJK UNIFIED IDEOGRAPH
    {0xF8FE, 0x7E9A}, //13346 #CJK UNIFIED IDEOGRAPH
    {0xF940, 0x7E98}, //13347 #CJK UNIFIED IDEOGRAPH
    {0xF941, 0x7E9B}, //13348 #CJK UNIFIED IDEOGRAPH
    {0xF942, 0x7E99}, //13349 #CJK UNIFIED IDEOGRAPH
    {0xF943, 0x81E0}, //13350 #CJK UNIFIED IDEOGRAPH
    {0xF944, 0x81E1}, //13351 #CJK UNIFIED IDEOGRAPH
    {0xF945, 0x8646}, //13352 #CJK UNIFIED IDEOGRAPH
    {0xF946, 0x8647}, //13353 #CJK UNIFIED IDEOGRAPH
    {0xF947, 0x8648}, //13354 #CJK UNIFIED IDEOGRAPH
    {0xF948, 0x8979}, //13355 #CJK UNIFIED IDEOGRAPH
    {0xF949, 0x897A}, //13356 #CJK UNIFIED IDEOGRAPH
    {0xF94A, 0x897C}, //13357 #CJK UNIFIED IDEOGRAPH
    {0xF94B, 0x897B}, //13358 #CJK UNIFIED IDEOGRAPH
    {0xF94C, 0x89FF}, //13359 #CJK UNIFIED IDEOGRAPH
    {0xF94D, 0x8B98}, //13360 #CJK UNIFIED IDEOGRAPH
    {0xF94E, 0x8B99}, //13361 #CJK UNIFIED IDEOGRAPH
    {0xF94F, 0x8EA5}, //13362 #CJK UNIFIED IDEOGRAPH
    {0xF950, 0x8EA4}, //13363 #CJK UNIFIED IDEOGRAPH
    {0xF951, 0x8EA3}, //13364 #CJK UNIFIED IDEOGRAPH
    {0xF952, 0x946E}, //13365 #CJK UNIFIED IDEOGRAPH
    {0xF953, 0x946D}, //13366 #CJK UNIFIED IDEOGRAPH
    {0xF954, 0x946F}, //13367 #CJK UNIFIED IDEOGRAPH
    {0xF955, 0x9471}, //13368 #CJK UNIFIED IDEOGRAPH
    {0xF956, 0x9473}, //13369 #CJK UNIFIED IDEOGRAPH
    {0xF957, 0x9749}, //13370 #CJK UNIFIED IDEOGRAPH
    {0xF958, 0x9872}, //13371 #CJK UNIFIED IDEOGRAPH
    {0xF959, 0x995F}, //13372 #CJK UNIFIED IDEOGRAPH
    {0xF95A, 0x9C68}, //13373 #CJK UNIFIED IDEOGRAPH
    {0xF95B, 0x9C6E}, //13374 #CJK UNIFIED IDEOGRAPH
    {0xF95C, 0x9C6D}, //13375 #CJK UNIFIED IDEOGRAPH
    {0xF95D, 0x9E0B}, //13376 #CJK UNIFIED IDEOGRAPH
    {0xF95E, 0x9E0D}, //13377 #CJK UNIFIED IDEOGRAPH
    {0xF95F, 0x9E10}, //13378 #CJK UNIFIED IDEOGRAPH
    {0xF960, 0x9E0F}, //13379 #CJK UNIFIED IDEOGRAPH
    {0xF961, 0x9E12}, //13380 #CJK UNIFIED IDEOGRAPH
    {0xF962, 0x9E11}, //13381 #CJK UNIFIED IDEOGRAPH
    {0xF963, 0x9EA1}, //13382 #CJK UNIFIED IDEOGRAPH
    {0xF964, 0x9EF5}, //13383 #CJK UNIFIED IDEOGRAPH
    {0xF965, 0x9F09}, //13384 #CJK UNIFIED IDEOGRAPH
    {0xF966, 0x9F47}, //13385 #CJK UNIFIED IDEOGRAPH
    {0xF967, 0x9F78}, //13386 #CJK UNIFIED IDEOGRAPH
    {0xF968, 0x9F7B}, //13387 #CJK UNIFIED IDEOGRAPH
    {0xF969, 0x9F7A}, //13388 #CJK UNIFIED IDEOGRAPH
    {0xF96A, 0x9F79}, //13389 #CJK UNIFIED IDEOGRAPH
    {0xF96B, 0x571E}, //13390 #CJK UNIFIED IDEOGRAPH
    {0xF96C, 0x7066}, //13391 #CJK UNIFIED IDEOGRAPH
    {0xF96D, 0x7C6F}, //13392 #CJK UNIFIED IDEOGRAPH
    {0xF96E, 0x883C}, //13393 #CJK UNIFIED IDEOGRAPH
    {0xF96F, 0x8DB2}, //13394 #CJK UNIFIED IDEOGRAPH
    {0xF970, 0x8EA6}, //13395 #CJK UNIFIED IDEOGRAPH
    {0xF971, 0x91C3}, //13396 #CJK UNIFIED IDEOGRAPH
    {0xF972, 0x9474}, //13397 #CJK UNIFIED IDEOGRAPH
    {0xF973, 0x9478}, //13398 #CJK UNIFIED IDEOGRAPH
    {0xF974, 0x9476}, //13399 #CJK UNIFIED IDEOGRAPH
    {0xF975, 0x9475}, //13400 #CJK UNIFIED IDEOGRAPH
    {0xF976, 0x9A60}, //13401 #CJK UNIFIED IDEOGRAPH
    {0xF977, 0x9C74}, //13402 #CJK UNIFIED IDEOGRAPH
    {0xF978, 0x9C73}, //13403 #CJK UNIFIED IDEOGRAPH
    {0xF979, 0x9C71}, //13404 #CJK UNIFIED IDEOGRAPH
    {0xF97A, 0x9C75}, //13405 #CJK UNIFIED IDEOGRAPH
    {0xF97B, 0x9E14}, //13406 #CJK UNIFIED IDEOGRAPH
    {0xF97C, 0x9E13}, //13407 #CJK UNIFIED IDEOGRAPH
    {0xF97D, 0x9EF6}, //13408 #CJK UNIFIED IDEOGRAPH
    {0xF97E, 0x9F0A}, //13409 #CJK UNIFIED IDEOGRAPH
    {0xF9A1, 0x9FA4}, //13410 #CJK UNIFIED IDEOGRAPH
    {0xF9A2, 0x7068}, //13411 #CJK UNIFIED IDEOGRAPH
    {0xF9A3, 0x7065}, //13412 #CJK UNIFIED IDEOGRAPH
    {0xF9A4, 0x7CF7}, //13413 #CJK UNIFIED IDEOGRAPH
    {0xF9A5, 0x866A}, //13414 #CJK UNIFIED IDEOGRAPH
    {0xF9A6, 0x883E}, //13415 #CJK UNIFIED IDEOGRAPH
    {0xF9A7, 0x883D}, //13416 #CJK UNIFIED IDEOGRAPH
    {0xF9A8, 0x883F}, //13417 #CJK UNIFIED IDEOGRAPH
    {0xF9A9, 0x8B9E}, //13418 #CJK UNIFIED IDEOGRAPH
    {0xF9AA, 0x8C9C}, //13419 #CJK UNIFIED IDEOGRAPH
    {0xF9AB, 0x8EA9}, //13420 #CJK UNIFIED IDEOGRAPH
    {0xF9AC, 0x8EC9}, //13421 #CJK UNIFIED IDEOGRAPH
    {0xF9AD, 0x974B}, //13422 #CJK UNIFIED IDEOGRAPH
    {0xF9AE, 0x9873}, //13423 #CJK UNIFIED IDEOGRAPH
    {0xF9AF, 0x9874}, //13424 #CJK UNIFIED IDEOGRAPH
    {0xF9B0, 0x98CC}, //13425 #CJK UNIFIED IDEOGRAPH
    {0xF9B1, 0x9961}, //13426 #CJK UNIFIED IDEOGRAPH
    {0xF9B2, 0x99AB}, //13427 #CJK UNIFIED IDEOGRAPH
    {0xF9B3, 0x9A64}, //13428 #CJK UNIFIED IDEOGRAPH
    {0xF9B4, 0x9A66}, //13429 #CJK UNIFIED IDEOGRAPH
    {0xF9B5, 0x9A67}, //13430 #CJK UNIFIED IDEOGRAPH
    {0xF9B6, 0x9B24}, //13431 #CJK UNIFIED IDEOGRAPH
    {0xF9B7, 0x9E15}, //13432 #CJK UNIFIED IDEOGRAPH
    {0xF9B8, 0x9E17}, //13433 #CJK UNIFIED IDEOGRAPH
    {0xF9B9, 0x9F48}, //13434 #CJK UNIFIED IDEOGRAPH
    {0xF9BA, 0x6207}, //13435 #CJK UNIFIED IDEOGRAPH
    {0xF9BB, 0x6B1E}, //13436 #CJK UNIFIED IDEOGRAPH
    {0xF9BC, 0x7227}, //13437 #CJK UNIFIED IDEOGRAPH
    {0xF9BD, 0x864C}, //13438 #CJK UNIFIED IDEOGRAPH
    {0xF9BE, 0x8EA8}, //13439 #CJK UNIFIED IDEOGRAPH
    {0xF9BF, 0x9482}, //13440 #CJK UNIFIED IDEOGRAPH
    {0xF9C0, 0x9480}, //13441 #CJK UNIFIED IDEOGRAPH
    {0xF9C1, 0x9481}, //13442 #CJK UNIFIED IDEOGRAPH
    {0xF9C2, 0x9A69}, //13443 #CJK UNIFIED IDEOGRAPH
    {0xF9C3, 0x9A68}, //13444 #CJK UNIFIED IDEOGRAPH
    {0xF9C4, 0x9B2E}, //13445 #CJK UNIFIED IDEOGRAPH
    {0xF9C5, 0x9E19}, //13446 #CJK UNIFIED IDEOGRAPH
    {0xF9C6, 0x7229}, //13447 #CJK UNIFIED IDEOGRAPH
    {0xF9C7, 0x864B}, //13448 #CJK UNIFIED IDEOGRAPH
    {0xF9C8, 0x8B9F}, //13449 #CJK UNIFIED IDEOGRAPH
    {0xF9C9, 0x9483}, //13450 #CJK UNIFIED IDEOGRAPH
    {0xF9CA, 0x9C79}, //13451 #CJK UNIFIED IDEOGRAPH
    {0xF9CB, 0x9EB7}, //13452 #CJK UNIFIED IDEOGRAPH
    {0xF9CC, 0x7675}, //13453 #CJK UNIFIED IDEOGRAPH
    {0xF9CD, 0x9A6B}, //13454 #CJK UNIFIED IDEOGRAPH
    {0xF9CE, 0x9C7A}, //13455 #CJK UNIFIED IDEOGRAPH
    {0xF9CF, 0x9E1D}, //13456 #CJK UNIFIED IDEOGRAPH
    {0xF9D0, 0x7069}, //13457 #CJK UNIFIED IDEOGRAPH
    {0xF9D1, 0x706A}, //13458 #CJK UNIFIED IDEOGRAPH
    {0xF9D2, 0x9EA4}, //13459 #CJK UNIFIED IDEOGRAPH
    {0xF9D3, 0x9F7E}, //13460 #CJK UNIFIED IDEOGRAPH
    {0xF9D4, 0x9F49}, //13461 #CJK UNIFIED IDEOGRAPH
    {0xF9D5, 0x9F98}, //13462 #CJK UNIFIED IDEOGRAPH
    {0xF9D6, 0x7881}, //13463 #CJK UNIFIED IDEOGRAPH
    {0xF9D7, 0x92B9}, //13464 #CJK UNIFIED IDEOGRAPH
    {0xF9D8, 0x88CF}, //13465 #CJK UNIFIED IDEOGRAPH
    {0xF9D9, 0x58BB}, //13466 #CJK UNIFIED IDEOGRAPH
    {0xF9DA, 0x6052}, //13467 #CJK UNIFIED IDEOGRAPH
    {0xF9DB, 0x7CA7}, //13468 #CJK UNIFIED IDEOGRAPH
    {0xF9DC, 0x5AFA}, //13469 #CJK UNIFIED IDEOGRAPH
    {0xF9DD, 0x2554}, //13470 #BOX DRAWINGS DOUBLE DOWN AND RIGHT
    {0xF9DE, 0x2566}, //13471 #BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
    {0xF9DF, 0x2557}, //13472 #BOX DRAWINGS DOUBLE DOWN AND LEFT
    {0xF9E0, 0x2560}, //13473 #BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
    {0xF9E1, 0x256C}, //13474 #BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
    {0xF9E2, 0x2563}, //13475 #BOX DRAWINGS DOUBLE VERTICAL AND LEFT
    {0xF9E3, 0x255A}, //13476 #BOX DRAWINGS DOUBLE UP AND RIGHT
    {0xF9E4, 0x2569}, //13477 #BOX DRAWINGS DOUBLE UP AND HORIZONTAL
    {0xF9E5, 0x255D}, //13478 #BOX DRAWINGS DOUBLE UP AND LEFT
    {0xF9E6, 0x2552}, //13479 #BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
    {0xF9E7, 0x2564}, //13480 #BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
    {0xF9E8, 0x2555}, //13481 #BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
    {0xF9E9, 0x255E}, //13482 #BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
    {0xF9EA, 0x256A}, //13483 #BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
    {0xF9EB, 0x2561}, //13484 #BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
    {0xF9EC, 0x2558}, //13485 #BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
    {0xF9ED, 0x2567}, //13486 #BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
    {0xF9EE, 0x255B}, //13487 #BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
    {0xF9EF, 0x2553}, //13488 #BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
    {0xF9F0, 0x2565}, //13489 #BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
    {0xF9F1, 0x2556}, //13490 #BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
    {0xF9F2, 0x255F}, //13491 #BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
    {0xF9F3, 0x256B}, //13492 #BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
    {0xF9F4, 0x2562}, //13493 #BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
    {0xF9F5, 0x2559}, //13494 #BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
    {0xF9F6, 0x2568}, //13495 #BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
    {0xF9F7, 0x255C}, //13496 #BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
    {0xF9F8, 0x2551}, //13497 #BOX DRAWINGS DOUBLE VERTICAL
    {0xF9F9, 0x2550}, //13498 #BOX DRAWINGS DOUBLE HORIZONTAL
    {0xF9FA, 0x256D}, //13499 #BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
    {0xF9FB, 0x256E}, //13500 #BOX DRAWINGS LIGHT ARC DOWN AND LEFT
    {0xF9FC, 0x2570}, //13501 #BOX DRAWINGS LIGHT ARC UP AND RIGHT
    {0xF9FD, 0x256F}, //13502 #BOX DRAWINGS LIGHT ARC UP AND LEFT
    {0xF9FE, 0x2593}, //13503 #DARK SHADE
};

#endif // DRW_CPTABLE950_H
