# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

# AutoInstallLibs class

$(dir $(call gb_AutoInstallLibs_get_target,%)).dir :
	$(if $(wildcard $(dir $@)),,mkdir -p $(dir $@))

$(call gb_AutoInstallLibs_get_target,%) : $(SRCDIR)/Repository.mk
	$(call gb_Output_announce,$*,$(true),AIL,3)
	echo "/* autogenerated library installs for group $(INSTALLMODULE) */" > $@
	$(call gb_Output_info,install module: $(INSTALLMODULE) contents: $(gb_Library_MODULE_$(INSTALLMODULE)))
	echo "#define $(SCP2ID)_ALL \ " >> $@
	$(foreach lib,$(gb_Library_MODULE_$(INSTALLMODULE)),\
		echo "    $(SCP2ID)_$(lib), \ " >> $@;)
	echo "" >> $@
	$(foreach lib,$(gb_Library_MODULE_$(INSTALLMODULE)),\
		echo "$(SCP2TEMPLATE)($(SCP2ID)_$(lib),$(call gb_Library_get_runtime_filename,$(lib)))" >> $@;)


$(call gb_AutoInstallLibs_get_clean_target,%) :
	$(call gb_Output_announce,$*,$(false),AIL,3)
	rm -f $(call gb_AutoInstallLibs_get_target,$*)

define gb_AutoInstallLibs_AutoInstallLibs
$(call gb_AutoInstallLibs_get_target,$(1)) : $(gb_Module_CURRENTMAKEFILE)
$(call gb_AutoInstallLibs_get_target,$(1)) :| $(dir $(call gb_AutoInstallLibs_get_target,$(1))).dir
$(call gb_AutoInstallLibs_get_target,$(1)) : INSTALLMODULE = $(2)
$(call gb_AutoInstallLibs_get_target,$(1)) : SCP2TEMPLATE = $(3)
$(call gb_AutoInstallLibs_get_target,$(1)) : SCP2ID = $(4)

$$(eval $$(call gb_Module_register_target,$(call gb_AutoInstallLibs_get_target,$(1)),$(call gb_AutoInstallLibs_get_clean_target,$(1))))
$(call gb_Helper_make_userfriendly_targets,$(1),AutoInstallLibs)

endef

# vim: set shiftwidth=4 tabstop=4 noexpandtab:
