/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef SC_PFILTDLG_HXX
#define SC_PFILTDLG_HXX

#include <vcl/morebtn.hxx>
#include <svtools/stdctrl.hxx>
#include <vcl/button.hxx>
#include <vcl/fixed.hxx>
#include <vcl/dialog.hxx>
#include <vcl/lstbox.hxx>
#include <vcl/combobox.hxx>
#include "address.hxx"
#include "queryparam.hxx"

//------------------------------------------------------------------

class ScViewData;
class ScDocument;
class ScQueryItem;
class TypedScStrCollection;

//==================================================================

class ScPivotFilterDlg : public ModalDialog
{
public:
                    ScPivotFilterDlg( Window* pParent,
                                      const SfxItemSet&	rArgSet, SCTAB nSourceTab );
                    ~ScPivotFilterDlg();

    const ScQueryItem&	GetOutputItem();

private:
    FixedLine       aFlCriteria;
    //----------------------------
    ListBox			aLbField1;
    ListBox			aLbCond1;
    ComboBox		aEdVal1;
    //----------------------------
    ListBox			aLbConnect1;
    ListBox			aLbField2;
    ListBox			aLbCond2;
    ComboBox		aEdVal2;
    //----------------------------
    ListBox			aLbConnect2;
    ListBox			aLbField3;
    ListBox			aLbCond3;
    ComboBox		aEdVal3;
    //----------------------------
    FixedText		aFtConnect;
    FixedText		aFtField;
    FixedText		aFtCond;
    FixedText		aFtVal;

    FixedLine       aFlOptions;
    CheckBox		aBtnCase;
    CheckBox		aBtnRegExp;
    CheckBox		aBtnUnique;
    FixedText		aFtDbAreaLabel;
    FixedInfo		aFtDbArea;
    OKButton		aBtnOk;
    CancelButton	aBtnCancel;
    HelpButton		aBtnHelp;
    MoreButton		aBtnMore;
    const String	aStrUndefined;
    const String	aStrNone;
    const String	aStrEmpty;
    const String	aStrNotEmpty;
    const String	aStrRow;
    const String	aStrColumn;

    const sal_uInt16		nWhichQuery;
    const ScQueryParam	theQueryData;
    ScQueryItem*		pOutItem;
    ScViewData*			pViewData;
    ScDocument*			pDoc;
    SCTAB				nSrcTab;

    sal_uInt16				nFieldCount;
    ComboBox*			aValueEdArr[3];
    ListBox*			aFieldLbArr[3];
    ListBox*			aCondLbArr[3];

    TypedScStrCollection*	pEntryLists[MAXCOLCOUNT];

#ifdef _PFILTDLG_CXX
private:
    void	Init			( const SfxItemSet&	rArgSet );
    void	FillFieldLists	();
    void	UpdateValueList	( sal_uInt16 nList );
    void	ClearValueList	( sal_uInt16 nList );
    sal_uInt16	GetFieldSelPos	( SCCOL nField );

    // Handler:
    DECL_LINK( LbSelectHdl, ListBox* );
    DECL_LINK( ValModifyHdl, ComboBox* );
    DECL_LINK( CheckBoxHdl,	 CheckBox* );
#endif
};


#endif // SC_PFILTDLG_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
