/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _VCL_GTKOBJECT_HXX
#define _VCL_GTKOBJECT_HXX

#include <vcl/sv.h>
#include <vcl/sysdata.hxx>
#include <vcl/salobj.hxx>
#include <plugins/gtk/gtkframe.hxx>

class GtkSalObject : public SalObject
{
    SystemChildData		m_aSystemData;
    GtkWidget*			m_pSocket;
    GdkRegion*			m_pRegion;

    // signals
    static gboolean		signalButton( GtkWidget*, GdkEventButton*, gpointer );
    static gboolean		signalFocus( GtkWidget*, GdkEventFocus*, gpointer );
    static void			signalDestroy( GtkObject*, gpointer );
public:
    GtkSalObject( GtkSalFrame* pParent, BOOL bShow = TRUE );
    virtual ~GtkSalObject();

    // overload all pure virtual methods
     virtual void					ResetClipRegion();
    virtual USHORT					GetClipRegionType();
    virtual void					BeginSetClipRegion( ULONG nRects );
    virtual void					UnionClipRegion( long nX, long nY, long nWidth, long nHeight );
    virtual void					EndSetClipRegion();

    virtual void					SetPosSize( long nX, long nY, long nWidth, long nHeight );
    virtual void					Show( BOOL bVisible );
    virtual void					Enable( BOOL nEnable );
    virtual void					GrabFocus();

    virtual void					SetBackground();
    virtual void					SetBackground( SalColor nSalColor );

        virtual void                                    SetForwardKey( BOOL bEnable );

    virtual const SystemEnvData*	GetSystemData() const;
   
};

#endif // _SV_SALOBJ_H

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
