//*File generated by libtheora with OC_COLLECT_METRICS defined at compile time.*/
#if !defined(_modedec_H)
# define _modedec_H (1)



# if defined(OC_COLLECT_METRICS)
typedef struct oc_mode_metrics oc_mode_metrics;
# endif
typedef struct oc_mode_rd      oc_mode_rd;



/*The number of extra bits of precision at which to store rate metrics.*/
# define OC_BIT_SCALE  (6)
/*The number of extra bits of precision at which to store RMSE metrics.
  This must be at least half OC_BIT_SCALE (rounded up).*/
# define OC_RMSE_SCALE (5)
/*The number of bins to partition statistics into.*/
# define OC_SAD_BINS   (24)
/*The number of bits of precision to drop from SAD scores to assign them to a
   bin.*/
# define OC_SAD_SHIFT  (9)



# if defined(OC_COLLECT_METRICS)
struct oc_mode_metrics{
  double fragw;
  double sad;
  double rate;
  double rmse;
  double sad2;
  double sadrate;
  double rate2;
  double sadrmse;
  double rmse2;
};


int             oc_has_mode_metrics;
oc_mode_metrics OC_MODE_METRICS[64][3][2][OC_SAD_BINS];
# endif



struct oc_mode_rd{
  ogg_int16_t rate;
  ogg_int16_t rmse;
};


# if !defined(OC_COLLECT_METRICS)
static const
# endif
oc_mode_rd OC_MODE_RD[64][3][2][OC_SAD_BINS]={
  {
    {
      /*Y'  qi=0  INTRA*/
      {
        {  172,  -63},{  218, 1603},{  265, 3547},{  333, 5324},
        {  424, 6541},{  520, 7452},{  615, 8306},{  706, 9139},
        {  796, 9953},{  891,10771},{  989,11586},{ 1096,12392},
        { 1205,13151},{ 1304,13829},{ 1388,14586},{ 1475,15372},
        { 1566,16084},{ 1654,16833},{ 1746,17548},{ 1838,18221},
        { 1927,18914},{ 2017,19622},{ 2102,20326},{ 2170,21128}
      },
      /*Y'  qi=0  INTER*/
      {
        {  136, -147},{   93, 1359},{  122, 2917},{  149, 4559},
        {  165, 6181},{  177, 7697},{  190, 9078},{  204,10362},
        {  220,11653},{  240,12884},{  268,14050},{  301,15223},
        {  336,16392},{  370,17564},{  404,18716},{  443,19858},
        {  482,20992},{  526,22096},{  586,23182},{  653,24238},
        {  725,25263},{  797,26287},{  874,27271},{  959,28217}
      }
    },
    {
      /*Cb  qi=0  INTRA*/
      {
        {    9,    2},{   67,  365},{  111,  742},{  129, 1183},
        {  142, 1661},{  157, 2165},{  169, 2686},{  173, 3205},
        {  181, 3685},{  190, 4166},{  196, 4618},{  202, 5034},
        {  209, 5470},{  217, 5883},{  224, 6272},{  237, 6630},
        {  253, 6962},{  260, 7315},{  275, 7663},{  287, 8010},
        {  294, 8367},{  308, 8640},{  328, 8931},{  367, 9355}
      },
      /*Cb  qi=0  INTER*/
      {
        {  129,  -50},{  123,  303},{  117,  654},{  114, 1025},
        {  113, 1434},{  112, 1854},{  117, 2271},{  122, 2682},
        {  126, 3101},{  129, 3532},{  132, 3962},{  134, 4383},
        {  136, 4802},{  139, 5188},{  142, 5544},{  145, 5904},
        {  145, 6270},{  146, 6638},{  148, 6998},{  149, 7345},
        {  150, 7697},{  153, 8045},{  154, 8401},{  153, 8788}
      }
    },
    {
      /*Cr  qi=0  INTRA*/
      {
        {    5,    4},{   58,  373},{  102,  762},{  127, 1227},
        {  139, 1710},{  147, 2210},{  156, 2712},{  165, 3178},
        {  174, 3642},{  183, 4103},{  198, 4561},{  209, 4989},
        {  217, 5373},{  225, 5788},{  235, 6194},{  245, 6587},
        {  253, 7005},{  268, 7368},{  287, 7714},{  298, 8043},
        {  304, 8410},{  318, 8695},{  327, 8926},{  342, 9294}
      },
      /*Cr  qi=0  INTER*/
      {
        {   88,   18},{   98,  337},{  108,  648},{  119, 1017},
        {  117, 1432},{  117, 1842},{  121, 2250},{  125, 2663},
        {  127, 3082},{  129, 3503},{  131, 3920},{  131, 4345},
        {  134, 4757},{  137, 5155},{  138, 5551},{  137, 5941},
        {  138, 6336},{  140, 6715},{  143, 7100},{  146, 7467},
        {  150, 7805},{  153, 8150},{  157, 8499},{  159, 8860}
      }
    }
  },
  {
    {
      /*Y'  qi=1  INTRA*/
      {
        {  180,  -58},{  226, 1601},{  279, 3502},{  358, 5179},
        {  463, 6309},{  571, 7184},{  674, 8016},{  776, 8821},
        {  878, 9601},{  985,10382},{ 1096,11169},{ 1216,11930},
        { 1333,12652},{ 1437,13332},{ 1535,14052},{ 1636,14795},
        { 1736,15477},{ 1833,16184},{ 1930,16870},{ 2030,17514},
        { 2130,18188},{ 2228,18859},{ 2326,19535},{ 2417,20310}
      },
      /*Y'  qi=1  INTER*/
      {
        {  146,  -73},{   98, 1355},{  128, 2908},{  156, 4550},
        {  173, 6168},{  188, 7635},{  203, 8959},{  221,10217},
        {  242,11464},{  269,12679},{  304,13838},{  344,14978},
        {  388,16124},{  435,17267},{  479,18403},{  529,19526},
        {  583,20640},{  645,21716},{  723,22748},{  807,23762},
        {  892,24739},{  980,25687},{ 1074,26614},{ 1179,27501}
      }
    },
    {
      /*Cb  qi=1  INTRA*/
      {
        {    9,    2},{   70,  365},{  120,  742},{  143, 1183},
        {  153, 1663},{  163, 2167},{  173, 2690},{  180, 3208},
        {  188, 3686},{  200, 4164},{  207, 4612},{  214, 5008},
        {  228, 5426},{  239, 5823},{  245, 6192},{  257, 6527},
        {  273, 6841},{  282, 7178},{  299, 7512},{  315, 7837},
        {  324, 8190},{  344, 8438},{  369, 8685},{  410, 9117}
      },
      /*Cb  qi=1  INTER*/
      {
        {   86,  -49},{   98,  303},{  108,  655},{  116, 1027},
        {  113, 1433},{  114, 1848},{  120, 2263},{  126, 2679},
        {  130, 3103},{  132, 3529},{  134, 3956},{  137, 4378},
        {  139, 4770},{  142, 5146},{  145, 5518},{  145, 5878},
        {  147, 6239},{  150, 6591},{  153, 6941},{  153, 7298},
        {  155, 7648},{  158, 7991},{  161, 8340},{  167, 8699}
      }
    },
    {
      /*Cr  qi=1  INTRA*/
      {
        {    5,    4},{   63,  373},{  111,  762},{  136, 1227},
        {  149, 1711},{  159, 2211},{  167, 2715},{  177, 3180},
        {  187, 3639},{  198, 4062},{  216, 4473},{  228, 4910},
        {  234, 5316},{  244, 5723},{  256, 6115},{  268, 6484},
        {  282, 6876},{  300, 7212},{  316, 7532},{  327, 7840},
        {  335, 8183},{  352, 8432},{  362, 8632},{  372, 8949}
      },
      /*Cr  qi=1  INTER*/
      {
        {  139,    9},{  120,  326},{  112,  649},{  116, 1028},
        {  117, 1441},{  120, 1842},{  124, 2245},{  127, 2663},
        {  129, 3087},{  130, 3513},{  132, 3932},{  134, 4344},
        {  137, 4748},{  139, 5144},{  141, 5536},{  143, 5921},
        {  143, 6297},{  145, 6665},{  148, 7030},{  152, 7392},
        {  155, 7729},{  157, 8067},{  160, 8410},{  164, 8739}
      }
    }
  },
  {
    {
      /*Y'  qi=2  INTRA*/
      {
        {  186,  -63},{  235, 1599},{  293, 3459},{  382, 5040},
        {  502, 6099},{  622, 6939},{  738, 7732},{  855, 8498},
        {  969, 9249},{ 1088,10000},{ 1214,10745},{ 1344,11462},
        { 1472,12147},{ 1589,12822},{ 1699,13505},{ 1813,14184},
        { 1925,14844},{ 2032,15535},{ 2140,16201},{ 2249,16824},
        { 2355,17461},{ 2460,18093},{ 2570,18726},{ 2665,19470}
      },
      /*Y'  qi=2  INTER*/
      {
        {  114,  -52},{  100, 1348},{  133, 2895},{  163, 4538},
        {  182, 6128},{  200, 7525},{  217, 8799},{  239,10033},
        {  267,11258},{  302,12447},{  347,13598},{  397,14723},
        {  451,15836},{  505,16967},{  566,18081},{  636,19149},
        {  711,20211},{  796,21263},{  892,22248},{  991,23201},
        { 1091,24136},{ 1204,25012},{ 1323,25848},{ 1442,26670}
      }
    },
    {
      /*Cb  qi=2  INTRA*/
      {
        {    9,    2},{   75,  366},{  127,  742},{  147, 1184},
        {  158, 1665},{  171, 2171},{  182, 2693},{  188, 3210},
        {  198, 3673},{  210, 4109},{  219, 4538},{  228, 4954},
        {  240, 5368},{  252, 5743},{  263, 6092},{  278, 6416},
        {  294, 6721},{  308, 7038},{  325, 7358},{  333, 7686},
        {  344, 8014},{  371, 8220},{  404, 8422},{  441, 8683}
      },
      /*Cb  qi=2  INTER*/
      {
        {  141, -126},{  130,  236},{  120,  594},{  113,  979},
        {  115, 1411},{  116, 1837},{  122, 2252},{  128, 2668},
        {  132, 3094},{  135, 3523},{  136, 3946},{  138, 4358},
        {  141, 4753},{  145, 5135},{  147, 5496},{  148, 5850},
        {  150, 6214},{  154, 6561},{  158, 6889},{  161, 7227},
        {  164, 7563},{  166, 7894},{  169, 8237},{  175, 8573}
      }
    },
    {
      /*Cr  qi=2  INTRA*/
      {
        {    5,    4},{   66,  373},{  114,  762},{  139, 1228},
        {  154, 1714},{  165, 2216},{  172, 2720},{  183, 3187},
        {  195, 3637},{  205, 4047},{  222, 4443},{  239, 4857},
        {  249, 5249},{  262, 5642},{  278, 6031},{  290, 6378},
        {  307, 6742},{  323, 7071},{  342, 7359},{  355, 7644},
        {  363, 7972},{  383, 8186},{  399, 8373},{  428, 8675}
      },
      /*Cr  qi=2  INTER*/
      {
        {  109,   -7},{  109,  326},{  114,  640},{  119, 1017},
        {  120, 1423},{  122, 1830},{  126, 2243},{  128, 2663},
        {  130, 3089},{  132, 3514},{  134, 3931},{  137, 4345},
        {  138, 4748},{  140, 5138},{  143, 5521},{  145, 5895},
        {  148, 6262},{  151, 6624},{  155, 6988},{  158, 7343},
        {  162, 7670},{  169, 7987},{  171, 8300},{  174, 8630}
      }
    }
  },
  {
    {
      /*Y'  qi=3  INTRA*/
      {
        {  191,  -64},{  242, 1597},{  305, 3413},{  407, 4918},
        {  541, 5923},{  672, 6731},{  797, 7504},{  924, 8251},
        { 1047, 8986},{ 1175, 9717},{ 1311,10437},{ 1453,11125},
        { 1590,11786},{ 1718,12431},{ 1838,13095},{ 1958,13784},
        { 2078,14411},{ 2196,15059},{ 2309,15712},{ 2424,16311},
        { 2538,16930},{ 2651,17541},{ 2766,18161},{ 2869,18889}
      },
      /*Y'  qi=3  INTER*/
      {
        {  147,  -56},{  103, 1351},{  138, 2897},{  169, 4523},
        {  191, 6071},{  212, 7429},{  234, 8690},{  261, 9919},
        {  296,11128},{  338,12302},{  392,13431},{  454,14530},
        {  522,15620},{  593,16713},{  664,17804},{  745,18866},
        {  844,19878},{  943,20872},{ 1050,21826},{ 1163,22748},
        { 1280,23627},{ 1406,24454},{ 1535,25254},{ 1671,26041}
      }
    },
    {
      /*Cb  qi=3  INTRA*/
      {
        {   11,    2},{   78,  366},{  131,  743},{  152, 1186},
        {  164, 1668},{  177, 2173},{  186, 2694},{  192, 3207},
        {  205, 3664},{  220, 4088},{  232, 4508},{  242, 4919},
        {  253, 5313},{  269, 5663},{  287, 5992},{  301, 6308},
        {  317, 6588},{  332, 6894},{  350, 7204},{  364, 7506},
        {  375, 7818},{  403, 8020},{  439, 8208},{  483, 8456}
      },
      /*Cb  qi=3  INTER*/
      {
        {  121,  -62},{  119,  286},{  116,  631},{  112, 1004},
        {  112, 1427},{  118, 1851},{  125, 2268},{  131, 2687},
        {  134, 3111},{  137, 3536},{  140, 3950},{  143, 4354},
        {  146, 4746},{  150, 5117},{  152, 5493},{  155, 5843},
        {  158, 6173},{  161, 6509},{  164, 6834},{  167, 7165},
        {  171, 7499},{  175, 7831},{  178, 8153},{  179, 8462}
      }
    },
    {
      /*Cr  qi=3  INTRA*/
      {
        {    5,    4},{   71,  374},{  121,  764},{  145, 1230},
        {  158, 1717},{  169, 2221},{  178, 2723},{  188, 3189},
        {  200, 3634},{  211, 4035},{  230, 4419},{  248, 4823},
        {  262, 5199},{  279, 5563},{  292, 5946},{  306, 6291},
        {  330, 6623},{  352, 6924},{  376, 7223},{  389, 7488},
        {  393, 7763},{  411, 7973},{  432, 8158},{  457, 8455}
      },
      /*Cr  qi=3  INTER*/
      {
        {   96,   17},{  107,  333},{  111,  656},{  117, 1031},
        {  120, 1440},{  123, 1848},{  128, 2257},{  131, 2679},
        {  132, 3107},{  134, 3529},{  137, 3939},{  140, 4340},
        {  142, 4738},{  145, 5130},{  148, 5500},{  150, 5854},
        {  154, 6212},{  159, 6569},{  164, 6924},{  170, 7258},
        {  174, 7567},{  178, 7883},{  183, 8190},{  196, 8493}
      }
    }
  },
  {
    {
      /*Y'  qi=4  INTRA*/
      {
        {  192,  -64},{  245, 1594},{  314, 3374},{  428, 4815},
        {  574, 5781},{  715, 6566},{  852, 7311},{  992, 8028},
        { 1128, 8727},{ 1268, 9429},{ 1411,10136},{ 1561,10799},
        { 1711,11419},{ 1849,12044},{ 1977,12684},{ 2103,13333},
        { 2232,13939},{ 2360,14569},{ 2485,15194},{ 2606,15774},
        { 2723,16370},{ 2844,16938},{ 2964,17526},{ 3073,18257}
      },
      /*Y'  qi=4  INTER*/
      {
        {  132,  -95},{  100, 1357},{  140, 2894},{  173, 4496},
        {  196, 5989},{  219, 7318},{  246, 8578},{  279, 9789},
        {  320,10973},{  374,12128},{  440,13231},{  514,14309},
        {  596,15382},{  679,16465},{  769,17527},{  872,18543},
        {  978,19537},{ 1092,20482},{ 1216,21384},{ 1343,22259},
        { 1478,23075},{ 1623,23822},{ 1775,24492},{ 1939,25083}
      }
    },
    {
      /*Cb  qi=4  INTRA*/
      {
        {   10,    2},{   80,  366},{  136,  743},{  158, 1186},
        {  169, 1670},{  181, 2176},{  193, 2696},{  200, 3206},
        {  212, 3659},{  228, 4080},{  239, 4490},{  254, 4891},
        {  271, 5271},{  284, 5605},{  301, 5919},{  318, 6225},
        {  337, 6510},{  358, 6799},{  384, 7069},{  395, 7356},
        {  409, 7640},{  439, 7840},{  471, 8023},{  521, 8202}
      },
      /*Cb  qi=4  INTER*/
      {
        {  126,  -54},{  121,  305},{  117,  662},{  112, 1042},
        {  110, 1447},{  117, 1859},{  125, 2275},{  130, 2696},
        {  134, 3121},{  137, 3540},{  140, 3956},{  143, 4352},
        {  147, 4732},{  150, 5096},{  154, 5444},{  159, 5783},
        {  163, 6120},{  165, 6452},{  169, 6781},{  174, 7106},
        {  177, 7426},{  182, 7748},{  189, 8069},{  187, 8390}
      }
    },
    {
      /*Cr  qi=4  INTRA*/
      {
        {    5,    4},{   76,  374},{  128,  764},{  150, 1230},
        {  162, 1718},{  173, 2223},{  183, 2727},{  195, 3191},
        {  208, 3629},{  219, 4019},{  240, 4385},{  263, 4773},
        {  279, 5145},{  293, 5503},{  305, 5869},{  320, 6195},
        {  346, 6506},{  370, 6792},{  396, 7055},{  418, 7299},
        {  428, 7591},{  443, 7811},{  461, 7996},{  494, 8275}
      },
      /*Cr  qi=4  INTER*/
      {
        {  110,   25},{  110,  339},{  115,  661},{  115, 1040},
        {  117, 1453},{  121, 1863},{  125, 2274},{  129, 2695},
        {  131, 3115},{  133, 3531},{  136, 3942},{  139, 4343},
        {  143, 4729},{  146, 5105},{  149, 5470},{  154, 5828},
        {  157, 6183},{  161, 6520},{  167, 6854},{  176, 7181},
        {  184, 7488},{  189, 7791},{  194, 8091},{  198, 8385}
      }
    }
  },
  {
    {
      /*Y'  qi=5  INTRA*/
      {
        {  195,  -61},{  247, 1591},{  319, 3349},{  443, 4760},
        {  600, 5698},{  751, 6454},{  901, 7161},{ 1051, 7851},
        { 1197, 8526},{ 1349, 9190},{ 1503, 9860},{ 1661,10491},
        { 1820,11089},{ 1970,11684},{ 2106,12296},{ 2241,12910},
        { 2381,13489},{ 2518,14102},{ 2651,14694},{ 2779,15243},
        { 2903,15804},{ 3033,16352},{ 3164,16905},{ 3279,17578}
      },
      /*Y'  qi=5  INTER*/
      {
        {  134,  -96},{  101, 1355},{  141, 2890},{  176, 4464},
        {  204, 5918},{  232, 7225},{  263, 8463},{  304, 9661},
        {  357,10829},{  425,11946},{  506,13015},{  597,14074},
        {  690,15134},{  791,16186},{  902,17203},{ 1020,18179},
        { 1143,19128},{ 1277,20023},{ 1419,20864},{ 1565,21660},
        { 1721,22387},{ 1886,23034},{ 2060,23581},{ 2246,24016}
      }
    },
    {
      /*Cb  qi=5  INTRA*/
      {
        {   10,    2},{   82,  366},{  138,  743},{  159, 1187},
        {  170, 1670},{  182, 2176},{  194, 2696},{  202, 3204},
        {  214, 3654},{  232, 4063},{  244, 4461},{  259, 4852},
        {  280, 5222},{  298, 5537},{  315, 5819},{  334, 6104},
        {  358, 6389},{  381, 6667},{  410, 6915},{  427, 7190},
        {  439, 7468},{  465, 7673},{  504, 7867},{  560, 8096}
      },
      /*Cb  qi=5  INTER*/
      {
        {  117,  -83},{  115,  289},{  114,  658},{  111, 1042},
        {  110, 1446},{  116, 1859},{  124, 2276},{  130, 2698},
        {  135, 3119},{  138, 3539},{  141, 3945},{  144, 4332},
        {  148, 4703},{  153, 5066},{  158, 5416},{  161, 5746},
        {  164, 6072},{  168, 6394},{  173, 6716},{  181, 7039},
        {  190, 7344},{  195, 7652},{  198, 7975},{  200, 8302}
      }
    },
    {
      /*Cr  qi=5  INTRA*/
      {
        {    6,    4},{   77,  374},{  130,  764},{  152, 1231},
        {  163, 1719},{  175, 2224},{  186, 2725},{  197, 3186},
        {  211, 3622},{  222, 4010},{  245, 4368},{  270, 4742},
        {  286, 5102},{  306, 5436},{  320, 5785},{  334, 6101},
        {  363, 6386},{  389, 6662},{  413, 6914},{  439, 7148},
        {  461, 7419},{  478, 7627},{  495, 7800},{  531, 8092}
      },
      /*Cr  qi=5  INTER*/
      {
        {  121,   19},{  112,  336},{  111,  657},{  114, 1037},
        {  115, 1451},{  120, 1861},{  125, 2272},{  128, 2692},
        {  131, 3112},{  133, 3526},{  136, 3933},{  140, 4329},
        {  143, 4707},{  147, 5072},{  151, 5432},{  157, 5789},
        {  162, 6128},{  167, 6459},{  175, 6800},{  183, 7115},
        {  191, 7402},{  199, 7692},{  207, 7984},{  216, 8259}
      }
    }
  },
  {
    {
      /*Y'  qi=6  INTRA*/
      {
        {  195,  -62},{  255, 1587},{  337, 3305},{  476, 4655},
        {  647, 5547},{  812, 6263},{  976, 6937},{ 1139, 7601},
        { 1295, 8257},{ 1455, 8903},{ 1622, 9551},{ 1794,10157},
        { 1963,10732},{ 2123,11297},{ 2269,11892},{ 2412,12506},
        { 2558,13078},{ 2706,13650},{ 2850,14213},{ 2985,14755},
        { 3118,15295},{ 3256,15813},{ 3395,16340},{ 3519,17010}
      },
      /*Y'  qi=6  INTER*/
      {
        {  155, -118},{  107, 1348},{  147, 2882},{  185, 4440},
        {  217, 5866},{  250, 7139},{  287, 8355},{  338, 9537},
        {  405,10677},{  488,11763},{  587,12810},{  693,13850},
        {  804,14888},{  924,15904},{ 1051,16883},{ 1185,17824},
        { 1327,18720},{ 1478,19567},{ 1637,20351},{ 1807,21058},
        { 1984,21690},{ 2171,22235},{ 2367,22697},{ 2568,23093}
      }
    },
    {
      /*Cb  qi=6  INTRA*/
      {
        {   11,    2},{   85,  366},{  142,  743},{  163, 1187},
        {  176, 1669},{  189, 2174},{  200, 2691},{  208, 3192},
        {  222, 3634},{  242, 4036},{  256, 4424},{  274, 4795},
        {  296, 5134},{  314, 5423},{  337, 5693},{  359, 5975},
        {  383, 6243},{  411, 6488},{  442, 6706},{  462, 6983},
        {  483, 7250},{  512, 7449},{  549, 7636},{  605, 7799}
      },
      /*Cb  qi=6  INTER*/
      {
        {  106,   -3},{  111,  332},{  117,  668},{  113, 1039},
        {  114, 1442},{  120, 1856},{  128, 2272},{  134, 2691},
        {  138, 3111},{  142, 3528},{  145, 3926},{  149, 4308},
        {  155, 4677},{  159, 5029},{  164, 5367},{  168, 5692},
        {  173, 6010},{  179, 6326},{  186, 6642},{  191, 6964},
        {  201, 7275},{  210, 7581},{  216, 7898},{  224, 8221}
      }
    },
    {
      /*Cr  qi=6  INTRA*/
      {
        {    7,    4},{   79,  374},{  133,  764},{  156, 1232},
        {  168, 1722},{  180, 2227},{  193, 2729},{  206, 3189},
        {  220, 3615},{  231, 3988},{  255, 4338},{  282, 4701},
        {  300, 5039},{  323, 5340},{  343, 5665},{  363, 5968},
        {  396, 6231},{  422, 6494},{  448, 6724},{  477, 6936},
        {  496, 7206},{  517, 7409},{  533, 7591},{  555, 7913}
      },
      /*Cr  qi=6  INTER*/
      {
        {  100,   31},{  109,  342},{  115,  660},{  116, 1039},
        {  118, 1448},{  123, 1858},{  128, 2274},{  131, 2692},
        {  134, 3109},{  136, 3523},{  139, 3926},{  143, 4312},
        {  148, 4681},{  154, 5040},{  157, 5391},{  163, 5737},
        {  171, 6069},{  178, 6396},{  185, 6720},{  195, 7027},
        {  205, 7320},{  214, 7610},{  227, 7896},{  249, 8152}
      }
    }
  },
  {
    {
      /*Y'  qi=7  INTRA*/
      {
        {  195,  -62},{  258, 1583},{  344, 3282},{  493, 4607},
        {  674, 5472},{  849, 6160},{ 1025, 6812},{ 1196, 7460},
        { 1360, 8101},{ 1528, 8730},{ 1700, 9356},{ 1879, 9940},
        { 2057,10499},{ 2225,11041},{ 2383,11606},{ 2536,12196},
        { 2691,12742},{ 2848,13295},{ 2999,13847},{ 3140,14366},
        { 3279,14887},{ 3421,15386},{ 3569,15879},{ 3712,16474}
      },
      /*Y'  qi=7  INTER*/
      {
        {  152, -129},{  108, 1347},{  149, 2880},{  189, 4422},
        {  225, 5823},{  262, 7073},{  306, 8274},{  367, 9438},
        {  446,10551},{  544,11615},{  658,12639},{  775,13657},
        {  900,14670},{ 1039,15647},{ 1183,16590},{ 1331,17495},
        { 1488,18347},{ 1654,19138},{ 1831,19864},{ 2017,20508},
        { 2212,21055},{ 2413,21536},{ 2621,21925},{ 2816,22241}
      }
    },
    {
      /*Cb  qi=7  INTRA*/
      {
        {   11,    2},{   84,  366},{  142,  744},{  164, 1187},
        {  176, 1669},{  190, 2174},{  203, 2685},{  211, 3177},
        {  225, 3621},{  243, 4022},{  261, 4396},{  282, 4755},
        {  306, 5085},{  326, 5361},{  350, 5609},{  373, 5886},
        {  401, 6149},{  432, 6382},{  467, 6582},{  494, 6836},
        {  519, 7096},{  544, 7299},{  585, 7473},{  649, 7631}
      },
      /*Cb  qi=7  INTER*/
      {
        {  127,   25},{  118,  340},{  112,  666},{  110, 1040},
        {  112, 1443},{  120, 1856},{  128, 2272},{  134, 2693},
        {  138, 3115},{  142, 3527},{  146, 3923},{  150, 4300},
        {  155, 4661},{  160, 5005},{  166, 5335},{  171, 5654},
        {  177, 5966},{  183, 6284},{  191, 6595},{  200, 6899},
        {  208, 7205},{  215, 7523},{  222, 7835},{  235, 8121}
      }
    },
    {
      /*Cr  qi=7  INTRA*/
      {
        {    6,    4},{   79,  374},{  134,  764},{  157, 1232},
        {  169, 1722},{  181, 2226},{  194, 2728},{  208, 3187},
        {  223, 3603},{  236, 3961},{  262, 4303},{  287, 4666},
        {  307, 4995},{  334, 5282},{  356, 5584},{  381, 5861},
        {  417, 6120},{  445, 6378},{  475, 6575},{  508, 6775},
        {  525, 7062},{  543, 7278},{  563, 7464},{  589, 7756}
      },
      /*Cr  qi=7  INTER*/
      {
        {   95,   24},{  110,  344},{  115,  664},{  115, 1037},
        {  117, 1448},{  123, 1859},{  128, 2275},{  131, 2692},
        {  133, 3106},{  136, 3514},{  140, 3914},{  145, 4300},
        {  150, 4664},{  153, 5019},{  159, 5362},{  166, 5698},
        {  174, 6029},{  183, 6347},{  192, 6658},{  201, 6965},
        {  211, 7258},{  224, 7537},{  236, 7813},{  248, 8078}
      }
    }
  },
  {
    {
      /*Y'  qi=8  INTRA*/
      {
        {  202,  -62},{  263, 1579},{  357, 3241},{  521, 4514},
        {  716, 5338},{  906, 5995},{ 1096, 6622},{ 1280, 7252},
        { 1455, 7877},{ 1631, 8495},{ 1813, 9102},{ 2001, 9668},
        { 2190,10201},{ 2369,10718},{ 2535,11268},{ 2700,11835},
        { 2866,12361},{ 3028,12883},{ 3186,13411},{ 3337,13913},
        { 3481,14398},{ 3632,14869},{ 3787,15334},{ 3929,15913}
      },
      /*Y'  qi=8  INTER*/
      {
        {  154, -112},{  111, 1348},{  153, 2875},{  197, 4392},
        {  237, 5760},{  279, 6990},{  333, 8171},{  407, 9316},
        {  504,10404},{  620,11437},{  749,12441},{  885,13438},
        { 1030,14416},{ 1185,15361},{ 1348,16259},{ 1517,17111},
        { 1693,17906},{ 1881,18625},{ 2080,19269},{ 2288,19822},
        { 2505,20266},{ 2731,20604},{ 2960,20837},{ 3186,20985}
      }
    },
    {
      /*Cb  qi=8  INTRA*/
      {
        {   11,    2},{   89,  366},{  149,  744},{  170, 1188},
        {  183, 1670},{  198, 2174},{  212, 2683},{  222, 3172},
        {  236, 3608},{  255, 3998},{  274, 4361},{  297, 4701},
        {  321, 5016},{  349, 5283},{  378, 5520},{  402, 5782},
        {  434, 6024},{  469, 6246},{  506, 6441},{  539, 6686},
        {  565, 6933},{  590, 7116},{  629, 7281},{  700, 7370}
      },
      /*Cb  qi=8  INTER*/
      {
        {  105,   -1},{  111,  332},{  114,  667},{  111, 1044},
        {  114, 1444},{  121, 1854},{  129, 2272},{  136, 2692},
        {  141, 3109},{  145, 3516},{  150, 3907},{  154, 4281},
        {  160, 4633},{  166, 4966},{  172, 5286},{  179, 5604},
        {  184, 5918},{  191, 6225},{  200, 6531},{  213, 6833},
        {  225, 7134},{  233, 7441},{  246, 7743},{  255, 8048}
      }
    },
    {
      /*Cr  qi=8  INTRA*/
      {
        {    6,    4},{   82,  374},{  140,  765},{  165, 1233},
        {  178, 1723},{  189, 2227},{  201, 2727},{  215, 3180},
        {  233, 3587},{  251, 3933},{  277, 4269},{  303, 4622},
        {  324, 4932},{  354, 5201},{  380, 5490},{  410, 5751},
        {  449, 5994},{  477, 6241},{  510, 6435},{  543, 6641},
        {  563, 6909},{  587, 7106},{  612, 7289},{  653, 7563}
      },
      /*Cr  qi=8  INTER*/
      {
        {  108,   12},{  109,  332},{  112,  659},{  116, 1040},
        {  119, 1445},{  124, 1857},{  130, 2274},{  133, 2692},
        {  135, 3107},{  138, 3512},{  143, 3902},{  147, 4281},
        {  153, 4641},{  160, 4985},{  167, 5326},{  175, 5660},
        {  184, 5981},{  194, 6283},{  204, 6586},{  217, 6884},
        {  230, 7168},{  241, 7452},{  257, 7723},{  263, 7987}
      }
    }
  },
  {
    {
      /*Y'  qi=9  INTRA*/
      {
        {  202,  -61},{  265, 1574},{  366, 3211},{  542, 4451},
        {  750, 5241},{  954, 5870},{ 1157, 6482},{ 1354, 7089},
        { 1539, 7692},{ 1726, 8292},{ 1921, 8872},{ 2119, 9416},
        { 2316, 9924},{ 2505,10409},{ 2681,10938},{ 2854,11483},
        { 3029,11982},{ 3204,12489},{ 3369,12999},{ 3526,13466},
        { 3677,13926},{ 3839,14359},{ 4002,14798},{ 4149,15376}
      },
      /*Y'  qi=9  INTER*/
      {
        {  149, -122},{  112, 1350},{  155, 2869},{  203, 4369},
        {  249, 5707},{  298, 6914},{  362, 8081},{  452, 9202},
        {  566,10263},{  703,11262},{  851,12236},{ 1004,13206},
        { 1166,14153},{ 1339,15058},{ 1516,15916},{ 1703,16713},
        { 1903,17437},{ 2110,18100},{ 2328,18668},{ 2559,19128},
        { 2795,19487},{ 3038,19759},{ 3280,19974},{ 3523,20082}
      }
    },
    {
      /*Cb  qi=9  INTRA*/
      {
        {   11,    2},{   90,  366},{  150,  744},{  172, 1189},
        {  184, 1670},{  199, 2172},{  215, 2679},{  226, 3164},
        {  241, 3594},{  263, 3971},{  283, 4324},{  307, 4654},
        {  335, 4948},{  367, 5195},{  401, 5419},{  426, 5676},
        {  457, 5908},{  498, 6104},{  539, 6299},{  566, 6555},
        {  597, 6797},{  627, 6970},{  669, 7125},{  728, 7283}
      },
      /*Cb  qi=9  INTER*/
      {
        {   85,  -46},{  106,  314},{  119,  666},{  113, 1040},
        {  114, 1444},{  121, 1856},{  129, 2270},{  136, 2688},
        {  142, 3104},{  146, 3507},{  150, 3888},{  157, 4253},
        {  164, 4600},{  171, 4931},{  177, 5249},{  185, 5561},
        {  193, 5868},{  203, 6171},{  214, 6475},{  225, 6771},
        {  239, 7068},{  252, 7368},{  263, 7665},{  279, 7962}
      }
    },
    {
      /*Cr  qi=9  INTRA*/
      {
        {    7,    4},{   84,  375},{  142,  765},{  167, 1234},
        {  179, 1723},{  190, 2226},{  203, 2725},{  218, 3173},
        {  238, 3571},{  257, 3910},{  288, 4231},{  317, 4564},
        {  337, 4866},{  370, 5125},{  403, 5393},{  433, 5642},
        {  475, 5866},{  509, 6100},{  539, 6298},{  575, 6487},
        {  598, 6754},{  621, 6972},{  649, 7145},{  701, 7424}
      },
      /*Cr  qi=9  INTER*/
      {
        {  101,    8},{  107,  332},{  112,  661},{  115, 1041},
        {  118, 1447},{  124, 1858},{  130, 2273},{  133, 2690},
        {  136, 3103},{  139, 3505},{  143, 3891},{  149, 4255},
        {  156, 4608},{  163, 4954},{  170, 5287},{  179, 5614},
        {  192, 5924},{  206, 6222},{  218, 6518},{  232, 6816},
        {  245, 7097},{  261, 7357},{  277, 7627},{  292, 7894}
      }
    }
  },
  {
    {
      /*Y'  qi=10  INTRA*/
      {
        {  211,  -60},{  276, 1567},{  389, 3154},{  582, 4321},
        {  807, 5059},{ 1028, 5665},{ 1246, 6262},{ 1453, 6863},
        { 1647, 7465},{ 1847, 8054},{ 2051, 8619},{ 2260, 9143},
        { 2468, 9638},{ 2664,10121},{ 2851,10632},{ 3038,11142},
        { 3221,11626},{ 3403,12114},{ 3578,12597},{ 3743,13052},
        { 3898,13494},{ 4061,13913},{ 4233,14311},{ 4398,14832}
      },
      /*Y'  qi=10  INTER*/
      {
        {  154,  -91},{  118, 1343},{  164, 2856},{  218, 4328},
        {  271, 5636},{  329, 6826},{  407, 7972},{  515, 9068},
        {  654,10092},{  810,11068},{  974,12028},{ 1150,12966},
        { 1334,13880},{ 1522,14752},{ 1722,15561},{ 1930,16300},
        { 2151,16969},{ 2385,17544},{ 2624,18031},{ 2874,18417},
        { 3134,18699},{ 3390,18914},{ 3649,19031},{ 3901,19135}
      }
    },
    {
      /*Cb  qi=10  INTRA*/
      {
        {   11,    2},{   93,  367},{  157,  745},{  181, 1190},
        {  192, 1672},{  207, 2173},{  223, 2675},{  235, 3152},
        {  251, 3574},{  277, 3934},{  303, 4264},{  331, 4574},
        {  365, 4844},{  399, 5073},{  433, 5289},{  464, 5539},
        {  499, 5759},{  542, 5931},{  585, 6126},{  610, 6389},
        {  642, 6628},{  678, 6799},{  726, 6954},{  805, 7071}
      },
      /*Cb  qi=10  INTER*/
      {
        {  119,  -59},{  117,  269},{  115,  608},{  116, 1014},
        {  118, 1437},{  127, 1851},{  135, 2263},{  143, 2676},
        {  149, 3086},{  153, 3482},{  158, 3856},{  165, 4215},
        {  173, 4557},{  182, 4882},{  190, 5191},{  199, 5495},
        {  209, 5800},{  221, 6099},{  234, 6396},{  248, 6690},
        {  265, 6978},{  283, 7270},{  297, 7575},{  313, 7874}
      }
    },
    {
      /*Cr  qi=10  INTRA*/
      {
        {    7,    4},{   87,  377},{  147,  768},{  173, 1236},
        {  187, 1726},{  198, 2230},{  212, 2725},{  230, 3165},
        {  251, 3545},{  275, 3865},{  307, 4163},{  340, 4477},
        {  367, 4758},{  403, 5010},{  436, 5277},{  470, 5513},
        {  513, 5723},{  550, 5945},{  586, 6137},{  622, 6318},
        {  648, 6579},{  674, 6780},{  702, 6944},{  729, 7237}
      },
      /*Cr  qi=10  INTER*/
      {
        {  109,   19},{  114,  326},{  118,  646},{  120, 1035},
        {  123, 1442},{  129, 1853},{  134, 2268},{  139, 2685},
        {  141, 3094},{  145, 3489},{  151, 3869},{  157, 4230},
        {  165, 4572},{  174, 4904},{  184, 5229},{  195, 5542},
        {  209, 5845},{  224, 6140},{  240, 6428},{  257, 6709},
        {  274, 6982},{  290, 7254},{  305, 7523},{  321, 7785}
      }
    }
  },
  {
    {
      /*Y'  qi=11  INTRA*/
      {
        {  216,  -62},{  278, 1563},{  399, 3133},{  605, 4265},
        {  843, 4969},{ 1078, 5554},{ 1309, 6137},{ 1529, 6718},
        { 1735, 7304},{ 1946, 7872},{ 2162, 8411},{ 2379, 8919},
        { 2597, 9388},{ 2806, 9841},{ 3005,10329},{ 3199,10821},
        { 3391,11282},{ 3578,11758},{ 3760,12221},{ 3934,12634},
        { 4089,13051},{ 4253,13447},{ 4430,13818},{ 4598,14334}
      },
      /*Y'  qi=11  INTER*/
      {
        {  153,  -95},{  119, 1342},{  167, 2852},{  226, 4307},
        {  286, 5589},{  353, 6756},{  447, 7881},{  576, 8947},
        {  734, 9940},{  908,10890},{ 1092,11824},{ 1286,12735},
        { 1488,13608},{ 1698,14431},{ 1917,15188},{ 2150,15866},
        { 2393,16462},{ 2643,16965},{ 2909,17368},{ 3185,17655},
        { 3461,17845},{ 3731,17991},{ 3991,18093},{ 4242,18199}
      }
    },
    {
      /*Cb  qi=11  INTRA*/
      {
        {   12,    2},{   94,  367},{  158,  745},{  182, 1191},
        {  194, 1673},{  209, 2173},{  225, 2670},{  239, 3138},
        {  257, 3553},{  285, 3907},{  314, 4228},{  345, 4525},
        {  382, 4780},{  420, 5001},{  457, 5206},{  486, 5454},
        {  520, 5672},{  570, 5837},{  612, 6036},{  640, 6292},
        {  682, 6499},{  719, 6665},{  763, 6827},{  828, 6982}
      },
      /*Cb  qi=11  INTER*/
      {
        {   98,  -50},{  111,  274},{  116,  608},{  115, 1015},
        {  119, 1438},{  127, 1850},{  135, 2262},{  143, 2673},
        {  150, 3077},{  155, 3468},{  161, 3838},{  168, 4190},
        {  177, 4524},{  187, 4846},{  197, 5154},{  208, 5456},
        {  219, 5751},{  233, 6043},{  248, 6336},{  264, 6626},
        {  282, 6918},{  301, 7210},{  325, 7492},{  344, 7781}
      }
    },
    {
      /*Cr  qi=11  INTRA*/
      {
        {    7,    4},{   88,  377},{  148,  768},{  174, 1237},
        {  188, 1727},{  200, 2229},{  215, 2722},{  233, 3153},
        {  256, 3527},{  281, 3839},{  316, 4124},{  355, 4410},
        {  382, 4684},{  419, 4947},{  458, 5194},{  495, 5407},
        {  539, 5611},{  576, 5833},{  615, 6028},{  655, 6195},
        {  687, 6432},{  717, 6634},{  740, 6813},{  771, 7114}
      },
      /*Cr  qi=11  INTER*/
      {
        {  101,   10},{  110,  322},{  118,  647},{  120, 1035},
        {  123, 1442},{  129, 1853},{  134, 2266},{  138, 2681},
        {  142, 3087},{  146, 3477},{  152, 3852},{  161, 4209},
        {  169, 4550},{  178, 4878},{  189, 5193},{  203, 5499},
        {  220, 5797},{  236, 6090},{  253, 6378},{  274, 6648},
        {  293, 6915},{  310, 7190},{  333, 7445},{  359, 7698}
      }
    }
  },
  {
    {
      /*Y'  qi=12  INTRA*/
      {
        {  219,  -60},{  289, 1553},{  423, 3075},{  646, 4142},
        {  901, 4805},{ 1151, 5375},{ 1393, 5949},{ 1625, 6529},
        { 1842, 7107},{ 2065, 7669},{ 2291, 8201},{ 2516, 8694},
        { 2740, 9156},{ 2957, 9602},{ 3164,10078},{ 3365,10563},
        { 3563,11006},{ 3757,11456},{ 3944,11910},{ 4118,12322},
        { 4275,12736},{ 4442,13112},{ 4625,13472},{ 4793,13992}
      },
      /*Y'  qi=12  INTER*/
      {
        {  147,  -51},{  125, 1342},{  177, 2838},{  240, 4266},
        {  306, 5525},{  384, 6683},{  496, 7791},{  645, 8834},
        {  823, 9805},{ 1016,10735},{ 1218,11647},{ 1427,12540},
        { 1644,13390},{ 1871,14180},{ 2108,14902},{ 2358,15533},
        { 2617,16070},{ 2889,16513},{ 3174,16848},{ 3467,17059},
        { 3758,17206},{ 4034,17335},{ 4295,17431},{ 4544,17551}
      }
    },
    {
      /*Cb  qi=12  INTRA*/
      {
        {   12,    2},{   96,  367},{  159,  746},{  183, 1192},
        {  198, 1673},{  215, 2171},{  234, 2662},{  249, 3116},
        {  270, 3514},{  301, 3850},{  334, 4147},{  369, 4426},
        {  410, 4680},{  447, 4905},{  485, 5106},{  522, 5341},
        {  558, 5549},{  608, 5710},{  654, 5904},{  687, 6143},
        {  733, 6345},{  782, 6502},{  825, 6658},{  890, 6833}
      },
      /*Cb  qi=12  INTER*/
      {
        {  122,   46},{  114,  328},{  113,  631},{  117, 1026},
        {  124, 1443},{  133, 1856},{  143, 2268},{  151, 2677},
        {  157, 3074},{  164, 3454},{  173, 3814},{  181, 4155},
        {  192, 4480},{  203, 4793},{  214, 5095},{  227, 5390},
        {  242, 5683},{  258, 5973},{  275, 6262},{  293, 6550},
        {  316, 6839},{  340, 7127},{  366, 7406},{  390, 7698}
      }
    },
    {
      /*Cr  qi=12  INTRA*/
      {
        {    8,    4},{   92,  378},{  152,  770},{  178, 1238},
        {  192, 1728},{  204, 2228},{  220, 2715},{  243, 3132},
        {  267, 3492},{  293, 3795},{  335, 4067},{  379, 4327},
        {  412, 4578},{  449, 4833},{  488, 5084},{  529, 5298},
        {  579, 5484},{  619, 5686},{  656, 5886},{  697, 6070},
        {  733, 6298},{  757, 6487},{  779, 6668},{  802, 6957}
      },
      /*Cr  qi=12  INTER*/
      {
        {  101,   45},{  112,  351},{  119,  665},{  122, 1044},
        {  127, 1450},{  133, 1861},{  140, 2273},{  145, 2681},
        {  150, 3082},{  156, 3464},{  163, 3828},{  172, 4176},
        {  182, 4506},{  194, 4823},{  208, 5134},{  225, 5435},
        {  242, 5728},{  259, 6015},{  281, 6293},{  305, 6561},
        {  327, 6822},{  352, 7080},{  375, 7345},{  396, 7617}
      }
    }
  },
  {
    {
      /*Y'  qi=13  INTRA*/
      {
        {  220,  -58},{  290, 1551},{  428, 3059},{  657, 4111},
        {  917, 4766},{ 1172, 5334},{ 1419, 5906},{ 1656, 6481},
        { 1877, 7054},{ 2104, 7607},{ 2334, 8134},{ 2564, 8620},
        { 2791, 9071},{ 3010, 9511},{ 3221, 9978},{ 3425,10450},
        { 3625,10896},{ 3821,11350},{ 4011,11779},{ 4189,12178},
        { 4349,12587},{ 4519,12957},{ 4702,13304},{ 4869,13828}
      },
      /*Y'  qi=13  INTER*/
      {
        {  158,  -46},{  126, 1342},{  179, 2835},{  244, 4255},
        {  313, 5504},{  397, 6654},{  516, 7754},{  674, 8786},
        {  861, 9745},{ 1061,10667},{ 1271,11568},{ 1489,12446},
        { 1712,13280},{ 1944,14059},{ 2189,14760},{ 2450,15360},
        { 2717,15880},{ 2998,16278},{ 3293,16571},{ 3591,16787},
        { 3886,16908},{ 4162,17014},{ 4426,17124},{ 4684,17257}
      }
    },
    {
      /*Cb  qi=13  INTRA*/
      {
        {   12,    2},{   97,  367},{  160,  746},{  183, 1192},
        {  198, 1673},{  216, 2170},{  235, 2659},{  251, 3110},
        {  273, 3502},{  305, 3834},{  340, 4127},{  377, 4398},
        {  418, 4648},{  459, 4863},{  499, 5058},{  534, 5301},
        {  571, 5508},{  619, 5675},{  666, 5868},{  702, 6098},
        {  749, 6301},{  794, 6459},{  835, 6617},{  889, 6808}
      },
      /*Cb  qi=13  INTER*/
      {
        {  125,   40},{  122,  323},{  117,  631},{  116, 1028},
        {  123, 1443},{  133, 1855},{  143, 2265},{  151, 2671},
        {  158, 3067},{  166, 3443},{  174, 3800},{  183, 4141},
        {  195, 4464},{  207, 4772},{  219, 5072},{  231, 5369},
        {  246, 5659},{  264, 5947},{  284, 6238},{  305, 6524},
        {  329, 6806},{  356, 7089},{  384, 7370},{  420, 7654}
      }
    },
    {
      /*Cr  qi=13  INTRA*/
      {
        {    9,    4},{   92,  378},{  153,  770},{  179, 1238},
        {  193, 1728},{  205, 2227},{  222, 2713},{  244, 3129},
        {  270, 3481},{  298, 3775},{  340, 4045},{  385, 4302},
        {  418, 4549},{  457, 4804},{  498, 5051},{  540, 5264},
        {  590, 5451},{  634, 5649},{  673, 5836},{  714, 6013},
        {  754, 6238},{  779, 6441},{  802, 6623},{  825, 6951}
      },
      /*Cr  qi=13  INTER*/
      {
        {  104,   42},{  112,  351},{  121,  665},{  123, 1044},
        {  127, 1449},{  134, 1857},{  140, 2271},{  145, 2681},
        {  150, 3079},{  156, 3460},{  164, 3820},{  172, 4161},
        {  183, 4489},{  198, 4807},{  211, 5116},{  227, 5414},
        {  247, 5705},{  267, 5988},{  293, 6262},{  319, 6527},
        {  344, 6784},{  366, 7048},{  386, 7314},{  407, 7582}
      }
    }
  },
  {
    {
      /*Y'  qi=14  INTRA*/
      {
        {  223,  -58},{  296, 1546},{  445, 3027},{  688, 4036},
        {  964, 4657},{ 1233, 5209},{ 1492, 5770},{ 1739, 6332},
        { 1975, 6889},{ 2214, 7428},{ 2450, 7942},{ 2687, 8412},
        { 2923, 8854},{ 3148, 9282},{ 3366, 9733},{ 3577,10194},
        { 3780,10617},{ 3981,11049},{ 4180,11462},{ 4362,11843},
        { 4523,12241},{ 4696,12592},{ 4884,12905},{ 5064,13397}
      },
      /*Y'  qi=14  INTER*/
      {
        {  160,  -56},{  127, 1345},{  184, 2829},{  253, 4229},
        {  328, 5456},{  424, 6594},{  563, 7675},{  741, 8681},
        {  945, 9617},{ 1162,10518},{ 1389,11395},{ 1625,12241},
        { 1865,13044},{ 2115,13779},{ 2381,14425},{ 2662,14964},
        { 2957,15398},{ 3262,15730},{ 3572,15966},{ 3878,16119},
        { 4176,16208},{ 4454,16307},{ 4713,16404},{ 4957,16495}
      }
    },
    {
      /*Cb  qi=14  INTRA*/
      {
        {   12,    2},{  104,  367},{  170,  746},{  192, 1193},
        {  207, 1674},{  226, 2166},{  246, 2647},{  266, 3086},
        {  292, 3466},{  327, 3787},{  364, 4069},{  403, 4332},
        {  449, 4572},{  493, 4792},{  533, 4985},{  570, 5211},
        {  611, 5414},{  664, 5571},{  715, 5749},{  754, 5962},
        {  801, 6166},{  845, 6335},{  890, 6485},{  956, 6676}
      },
      /*Cb  qi=14  INTER*/
      {
        {  113,   29},{  123,  351},{  123,  678},{  116, 1049},
        {  123, 1450},{  134, 1860},{  145, 2269},{  153, 2675},
        {  161, 3064},{  169, 3435},{  179, 3788},{  190, 4121},
        {  201, 4438},{  213, 4746},{  229, 5042},{  245, 5332},
        {  262, 5622},{  280, 5906},{  301, 6190},{  328, 6468},
        {  358, 6747},{  390, 7024},{  424, 7293},{  471, 7544}
      }
    },
    {
      /*Cr  qi=14  INTRA*/
      {
        {    9,    4},{   97,  378},{  161,  770},{  188, 1239},
        {  201, 1728},{  215, 2223},{  234, 2702},{  258, 3107},
        {  287, 3448},{  316, 3738},{  363, 3990},{  415, 4225},
        {  449, 4471},{  490, 4730},{  533, 4970},{  580, 5161},
        {  633, 5339},{  679, 5532},{  724, 5707},{  763, 5884},
        {  799, 6105},{  832, 6290},{  858, 6483},{  895, 6766}
      },
      /*Cr  qi=14  INTER*/
      {
        {  109,   26},{  112,  347},{  119,  673},{  122, 1052},
        {  126, 1456},{  134, 1867},{  140, 2276},{  146, 2681},
        {  152, 3076},{  158, 3452},{  167, 3808},{  178, 4144},
        {  190, 4467},{  205, 4780},{  222, 5081},{  240, 5376},
        {  261, 5663},{  285, 5943},{  314, 6206},{  342, 6461},
        {  368, 6718},{  396, 6975},{  428, 7226},{  450, 7496}
      }
    }
  },
  {
    {
      /*Y'  qi=15  INTRA*/
      {
        {  226,  -57},{  299, 1544},{  459, 3001},{  715, 3958},
        { 1000, 4550},{ 1277, 5097},{ 1548, 5655},{ 1808, 6212},
        { 2056, 6756},{ 2303, 7287},{ 2547, 7787},{ 2796, 8234},
        { 3038, 8664},{ 3268, 9082},{ 3493, 9518},{ 3715, 9963},
        { 3924,10374},{ 4129,10784},{ 4333,11183},{ 4519,11557},
        { 4686,11930},{ 4862,12255},{ 5054,12557},{ 5234,13032}
      },
      /*Y'  qi=15  INTER*/
      {
        {  154,  -48},{  127, 1344},{  188, 2822},{  263, 4200},
        {  348, 5406},{  460, 6528},{  619, 7586},{  819, 8563},
        { 1041, 9475},{ 1276,10357},{ 1519,11214},{ 1773,12029},
        { 2033,12795},{ 2306,13483},{ 2598,14062},{ 2901,14552},
        { 3214,14922},{ 3540,15165},{ 3864,15343},{ 4175,15468},
        { 4471,15564},{ 4744,15643},{ 5003,15710},{ 5249,15824}
      }
    },
    {
      /*Cb  qi=15  INTRA*/
      {
        {   12,    2},{  104,  368},{  170,  747},{  193, 1193},
        {  209, 1675},{  229, 2163},{  249, 2636},{  271, 3067},
        {  300, 3439},{  338, 3752},{  376, 4028},{  419, 4281},
        {  466, 4518},{  513, 4734},{  558, 4919},{  595, 5139},
        {  638, 5337},{  694, 5492},{  745, 5675},{  785, 5896},
        {  832, 6088},{  886, 6230},{  936, 6372},{  976, 6588}
      },
      /*Cb  qi=15  INTER*/
      {
        {  121,   33},{  119,  353},{  121,  680},{  118, 1049},
        {  124, 1449},{  134, 1858},{  145, 2266},{  155, 2665},
        {  163, 3050},{  173, 3414},{  184, 3762},{  196, 4092},
        {  210, 4404},{  225, 4705},{  240, 4999},{  258, 5288},
        {  279, 5570},{  302, 5854},{  327, 6131},{  359, 6400},
        {  395, 6671},{  433, 6939},{  471, 7211},{  513, 7470}
      }
    },
    {
      /*Cr  qi=15  INTRA*/
      {
        {    9,    4},{   97,  378},{  162,  771},{  190, 1239},
        {  204, 1728},{  217, 2221},{  237, 2694},{  263, 3092},
        {  293, 3424},{  325, 3700},{  375, 3943},{  429, 4178},
        {  468, 4415},{  514, 4658},{  558, 4899},{  605, 5089},
        {  661, 5251},{  709, 5439},{  754, 5617},{  801, 5786},
        {  837, 6002},{  865, 6194},{  898, 6373},{  945, 6631}
      },
      /*Cr  qi=15  INTER*/
      {
        {  106,   29},{  113,  349},{  118,  674},{  120, 1051},
        {  126, 1455},{  134, 1865},{  141, 2272},{  148, 2673},
        {  154, 3063},{  162, 3435},{  172, 3784},{  185, 4114},
        {  198, 4435},{  214, 4741},{  233, 5038},{  254, 5329},
        {  279, 5609},{  308, 5881},{  338, 6141},{  371, 6393},
        {  402, 6644},{  432, 6902},{  461, 7161},{  496, 7408}
      }
    }
  },
  {
    {
      /*Y'  qi=16  INTRA*/
      {
        {  232,  -56},{  313, 1533},{  489, 2937},{  765, 3835},
        { 1068, 4395},{ 1362, 4930},{ 1648, 5481},{ 1920, 6032},
        { 2179, 6572},{ 2438, 7090},{ 2695, 7574},{ 2952, 8010},
        { 3202, 8436},{ 3438, 8846},{ 3670, 9268},{ 3896, 9693},
        { 4113,10081},{ 4327,10486},{ 4534,10874},{ 4723,11217},
        { 4895,11581},{ 5074,11899},{ 5265,12170},{ 5445,12625}
      },
      /*Y'  qi=16  INTER*/
      {
        {  162,  -30},{  137, 1342},{  199, 2812},{  280, 4165},
        {  377, 5351},{  507, 6457},{  689, 7493},{  911, 8445},
        { 1155, 9337},{ 1410,10199},{ 1674,11030},{ 1949,11816},
        { 2234,12539},{ 2533,13169},{ 2849,13692},{ 3179,14093},
        { 3516,14389},{ 3857,14578},{ 4187,14712},{ 4497,14825},
        { 4790,14903},{ 5063,14976},{ 5319,15031},{ 5554,15061}
      }
    },
    {
      /*Cb  qi=16  INTRA*/
      {
        {   12,    2},{  106,  368},{  177,  747},{  202, 1193},
        {  218, 1673},{  241, 2156},{  264, 2615},{  290, 3025},
        {  323, 3378},{  363, 3680},{  405, 3945},{  452, 4190},
        {  504, 4423},{  552, 4635},{  597, 4811},{  639, 5016},
        {  685, 5223},{  741, 5381},{  799, 5544},{  844, 5748},
        {  896, 5933},{  951, 6073},{ 1000, 6210},{ 1063, 6406}
      },
      /*Cb  qi=16  INTER*/
      {
        {  128,   36},{  122,  358},{  120,  682},{  123, 1047},
        {  131, 1448},{  142, 1856},{  152, 2259},{  163, 2652},
        {  173, 3032},{  183, 3392},{  195, 3734},{  210, 4054},
        {  226, 4359},{  241, 4656},{  260, 4945},{  282, 5230},
        {  307, 5509},{  336, 5783},{  365, 6061},{  403, 6327},
        {  445, 6597},{  489, 6861},{  541, 7111},{  599, 7351}
      }
    },
    {
      /*Cr  qi=16  INTRA*/
      {
        {    9,    4},{  103,  377},{  171,  769},{  199, 1238},
        {  215, 1727},{  231, 2215},{  252, 2678},{  282, 3064},
        {  315, 3380},{  351, 3643},{  405, 3870},{  462, 4086},
        {  505, 4314},{  555, 4547},{  602, 4779},{  652, 4969},
        {  712, 5128},{  764, 5301},{  808, 5474},{  856, 5632},
        {  903, 5841},{  932, 6038},{  963, 6208},{ 1017, 6419}
      },
      /*Cr  qi=16  INTER*/
      {
        {  116,   29},{  119,  346},{  123,  675},{  126, 1054},
        {  132, 1456},{  141, 1863},{  149, 2266},{  155, 2664},
        {  161, 3048},{  170, 3413},{  181, 3757},{  195, 4081},
        {  213, 4392},{  232, 4693},{  255, 4987},{  280, 5271},
        {  310, 5539},{  342, 5801},{  377, 6057},{  414, 6307},
        {  451, 6557},{  486, 6812},{  522, 7064},{  546, 7331}
      }
    }
  },
  {
    {
      /*Y'  qi=17  INTRA*/
      {
        {  233,  -55},{  316, 1530},{  499, 2918},{  787, 3793},
        { 1101, 4337},{ 1405, 4866},{ 1700, 5409},{ 1982, 5949},
        { 2251, 6477},{ 2517, 6988},{ 2781, 7461},{ 3045, 7883},
        { 3301, 8297},{ 3542, 8696},{ 3776, 9105},{ 4006, 9518},
        { 4226, 9896},{ 4443,10285},{ 4651,10660},{ 4842,11001},
        { 5019,11341},{ 5196,11634},{ 5382,11912},{ 5561,12352}
      },
      /*Y'  qi=17  INTER*/
      {
        {  165,  -32},{  137, 1342},{  202, 2804},{  288, 4145},
        {  394, 5319},{  539, 6410},{  738, 7427},{  977, 8359},
        { 1236, 9232},{ 1505,10078},{ 1785,10891},{ 2075,11651},
        { 2376,12344},{ 2696,12932},{ 3032,13397},{ 3378,13745},
        { 3728,13983},{ 4078,14103},{ 4411,14175},{ 4714,14249},
        { 4995,14284},{ 5260,14316},{ 5510,14338},{ 5739,14362}
      }
    },
    {
      /*Cb  qi=17  INTRA*/
      {
        {   13,    2},{  106,  368},{  177,  747},{  202, 1193},
        {  219, 1671},{  240, 2149},{  266, 2603},{  294, 3007},
        {  328, 3355},{  372, 3648},{  417, 3906},{  465, 4153},
        {  519, 4380},{  572, 4578},{  619, 4758},{  660, 4971},
        {  703, 5177},{  761, 5326},{  822, 5480},{  872, 5676},
        {  929, 5850},{  981, 5994},{ 1029, 6134},{ 1102, 6293}
      },
      /*Cb  qi=17  INTER*/
      {
        {  125,   41},{  122,  359},{  123,  681},{  122, 1048},
        {  130, 1447},{  143, 1855},{  154, 2258},{  164, 2648},
        {  175, 3024},{  186, 3381},{  199, 3716},{  215, 4032},
        {  232, 4336},{  251, 4632},{  272, 4919},{  296, 5199},
        {  323, 5473},{  354, 5743},{  392, 6008},{  434, 6272},
        {  480, 6538},{  532, 6788},{  588, 7031},{  647, 7270}
      }
    },
    {
      /*Cr  qi=17  INTRA*/
      {
        {   10,    4},{  103,  377},{  170,  769},{  197, 1235},
        {  213, 1722},{  231, 2208},{  254, 2665},{  284, 3046},
        {  321, 3359},{  357, 3621},{  412, 3845},{  472, 4054},
        {  517, 4273},{  571, 4503},{  623, 4729},{  677, 4907},
        {  736, 5059},{  782, 5235},{  831, 5407},{  887, 5563},
        {  933, 5764},{  958, 5960},{  993, 6138},{ 1046, 6366}
      },
      /*Cr  qi=17  INTER*/
      {
        {  123,   35},{  121,  351},{  123,  677},{  126, 1053},
        {  132, 1453},{  141, 1860},{  149, 2263},{  156, 2659},
        {  163, 3042},{  171, 3404},{  184, 3742},{  201, 4063},
        {  219, 4370},{  241, 4666},{  266, 4956},{  296, 5237},
        {  329, 5501},{  367, 5755},{  408, 6004},{  449, 6253},
        {  488, 6496},{  528, 6740},{  569, 6988},{  622, 7226}
      }
    }
  },
  {
    {
      /*Y'  qi=18  INTRA*/
      {
        {  238,  -52},{  327, 1520},{  530, 2862},{  842, 3685},
        { 1175, 4203},{ 1496, 4717},{ 1805, 5250},{ 2102, 5779},
        { 2386, 6290},{ 2665, 6786},{ 2940, 7252},{ 3216, 7659},
        { 3486, 8051},{ 3736, 8442},{ 3979, 8836},{ 4218, 9226},
        { 4448, 9582},{ 4677, 9959},{ 4898,10317},{ 5100,10629},
        { 5285,10954},{ 5472,11246},{ 5669,11509},{ 5869,11928}
      },
      /*Y'  qi=18  INTER*/
      {
        {  153,    1},{  142, 1345},{  213, 2786},{  310, 4098},
        {  434, 5252},{  607, 6320},{  836, 7303},{ 1103, 8203},
        { 1386, 9050},{ 1682, 9865},{ 1986,10646},{ 2301,11365},
        { 2632,11993},{ 2981,12511},{ 3346,12905},{ 3719,13173},
        { 4089,13332},{ 4442,13453},{ 4770,13568},{ 5079,13650},
        { 5368,13726},{ 5638,13791},{ 5896,13846},{ 6153,13905}
      }
    },
    {
      /*Cb  qi=18  INTRA*/
      {
        {   13,    2},{  109,  368},{  182,  748},{  210, 1194},
        {  229, 1670},{  253, 2142},{  283, 2579},{  313, 2964},
        {  351, 3296},{  401, 3574},{  450, 3819},{  502, 4058},
        {  557, 4279},{  613, 4468},{  665, 4640},{  713, 4843},
        {  762, 5046},{  819, 5207},{  882, 5363},{  934, 5553},
        {  984, 5722},{ 1036, 5870},{ 1091, 6015},{ 1157, 6210}
      },
      /*Cb  qi=18  INTER*/
      {
        {  118,   18},{  125,  348},{  124,  675},{  125, 1048},
        {  134, 1448},{  147, 1853},{  159, 2250},{  171, 2632},
        {  183, 3000},{  196, 3349},{  212, 3676},{  230, 3987},
        {  250, 4286},{  273, 4575},{  299, 4855},{  327, 5131},
        {  358, 5404},{  396, 5669},{  443, 5927},{  495, 6185},
        {  548, 6439},{  611, 6683},{  679, 6919},{  738, 7153}
      }
    },
    {
      /*Cr  qi=18  INTRA*/
      {
        {   10,    4},{  107,  378},{  177,  771},{  207, 1239},
        {  225, 1726},{  244, 2203},{  269, 2642},{  304, 2999},
        {  345, 3293},{  384, 3546},{  443, 3763},{  507, 3970},
        {  558, 4187},{  615, 4402},{  665, 4620},{  723, 4798},
        {  788, 4946},{  840, 5114},{  887, 5287},{  939, 5445},
        {  990, 5643},{ 1022, 5827},{ 1060, 5985},{ 1119, 6156}
      },
      /*Cr  qi=18  INTER*/
      {
        {  124,   32},{  126,  349},{  128,  673},{  129, 1053},
        {  136, 1453},{  145, 1855},{  154, 2254},{  162, 2645},
        {  170, 3021},{  181, 3374},{  196, 3704},{  215, 4018},
        {  237, 4321},{  263, 4612},{  293, 4891},{  327, 5166},
        {  369, 5421},{  412, 5665},{  459, 5906},{  510, 6145},
        {  556, 6387},{  598, 6631},{  644, 6874},{  701, 7114}
      }
    }
  },
  {
    {
      /*Y'  qi=19  INTRA*/
      {
        {  237,  -50},{  328, 1517},{  539, 2842},{  861, 3645},
        { 1202, 4152},{ 1528, 4664},{ 1844, 5192},{ 2148, 5714},
        { 2438, 6223},{ 2725, 6708},{ 3005, 7168},{ 3282, 7567},
        { 3559, 7946},{ 3815, 8328},{ 4061, 8710},{ 4305, 9095},
        { 4538, 9445},{ 4773, 9806},{ 4995,10149},{ 5197,10447},
        { 5384,10763},{ 5574,11052},{ 5776,11301},{ 5989,11701}
      },
      /*Y'  qi=19  INTER*/
      {
        {  154,   -8},{  143, 1345},{  217, 2777},{  320, 4078},
        {  455, 5221},{  643, 6274},{  889, 7241},{ 1171, 8125},
        { 1470, 8956},{ 1778, 9756},{ 2094,10516},{ 2426,11207},
        { 2774,11805},{ 3138,12287},{ 3519,12633},{ 3901,12868},
        { 4276,13012},{ 4632,13119},{ 4964,13232},{ 5271,13321},
        { 5558,13381},{ 5831,13433},{ 6084,13493},{ 6335,13585}
      }
    },
    {
      /*Cb  qi=19  INTRA*/
      {
        {   14,    2},{  110,  368},{  184,  748},{  211, 1194},
        {  229, 1670},{  255, 2137},{  286, 2566},{  319, 2943},
        {  360, 3269},{  410, 3544},{  461, 3785},{  515, 4024},
        {  572, 4239},{  631, 4420},{  686, 4593},{  736, 4798},
        {  787, 5000},{  848, 5156},{  913, 5303},{  961, 5491},
        { 1012, 5655},{ 1062, 5798},{ 1115, 5940},{ 1165, 6131}
      },
      /*Cb  qi=19  INTER*/
      {
        {  121,   28},{  129,  349},{  130,  674},{  127, 1047},
        {  135, 1447},{  147, 1850},{  160, 2245},{  173, 2624},
        {  186, 2987},{  202, 3331},{  218, 3655},{  237, 3965},
        {  260, 4260},{  284, 4546},{  312, 4825},{  343, 5097},
        {  377, 5369},{  420, 5633},{  471, 5887},{  526, 6143},
        {  587, 6392},{  652, 6626},{  722, 6857},{  803, 7064}
      }
    },
    {
      /*Cr  qi=19  INTRA*/
      {
        {   10,    4},{  108,  378},{  178,  771},{  208, 1238},
        {  226, 1724},{  246, 2198},{  272, 2630},{  309, 2980},
        {  352, 3268},{  394, 3517},{  453, 3735},{  516, 3946},
        {  569, 4156},{  628, 4365},{  684, 4580},{  743, 4753},
        {  811, 4891},{  868, 5053},{  913, 5232},{  963, 5394},
        { 1011, 5593},{ 1046, 5775},{ 1089, 5928},{ 1147, 6126}
      },
      /*Cr  qi=19  INTER*/
      {
        {  116,   22},{  121,  344},{  126,  675},{  129, 1054},
        {  135, 1453},{  146, 1854},{  155, 2249},{  164, 2636},
        {  173, 3008},{  186, 3360},{  202, 3690},{  221, 4000},
        {  246, 4296},{  276, 4581},{  308, 4859},{  342, 5130},
        {  385, 5386},{  437, 5629},{  486, 5873},{  536, 6105},
        {  588, 6337},{  633, 6586},{  683, 6829},{  731, 7071}
      }
    }
  },
  {
    {
      /*Y'  qi=20  INTRA*/
      {
        {  238,  -46},{  346, 1504},{  574, 2782},{  913, 3545},
        { 1270, 4033},{ 1611, 4532},{ 1937, 5056},{ 2252, 5575},
        { 2554, 6075},{ 2849, 6555},{ 3134, 7019},{ 3418, 7415},
        { 3702, 7784},{ 3961, 8166},{ 4211, 8547},{ 4459, 8923},
        { 4696, 9267},{ 4934, 9623},{ 5163, 9961},{ 5365,10254},
        { 5553,10567},{ 5747,10850},{ 5952,11081},{ 6157,11446}
      },
      /*Y'  qi=20  INTER*/
      {
        {  174,   -4},{  154, 1343},{  231, 2769},{  339, 4055},
        {  482, 5187},{  682, 6232},{  942, 7187},{ 1238, 8061},
        { 1552, 8883},{ 1877, 9670},{ 2211,10413},{ 2560,11075},
        { 2926,11635},{ 3312,12073},{ 3707,12374},{ 4101,12561},
        { 4478,12685},{ 4835,12788},{ 5166,12893},{ 5473,12984},
        { 5760,13070},{ 6027,13118},{ 6286,13155},{ 6537,13181}
      }
    },
    {
      /*Cb  qi=20  INTRA*/
      {
        {   14,    2},{  116,  369},{  193,  749},{  221, 1195},
        {  241, 1667},{  270, 2125},{  304, 2538},{  342, 2898},
        {  388, 3211},{  442, 3475},{  501, 3706},{  558, 3933},
        {  615, 4146},{  676, 4326},{  735, 4494},{  786, 4697},
        {  839, 4894},{  903, 5047},{  968, 5187},{ 1017, 5370},
        { 1068, 5536},{ 1119, 5685},{ 1174, 5843},{ 1229, 6021}
      },
      /*Cb  qi=20  INTER*/
      {
        {  112,  -47},{  121,  279},{  130,  627},{  135, 1036},
        {  145, 1443},{  158, 1843},{  172, 2228},{  185, 2604},
        {  197, 2967},{  212, 3310},{  230, 3632},{  251, 3934},
        {  274, 4227},{  298, 4515},{  329, 4790},{  365, 5059},
        {  405, 5325},{  450, 5585},{  505, 5839},{  569, 6088},
        {  636, 6330},{  706, 6566},{  778, 6791},{  861, 6988}
      }
    },
    {
      /*Cr  qi=20  INTRA*/
      {
        {   13,    5},{  114,  382},{  186,  776},{  217, 1241},
        {  237, 1720},{  261, 2184},{  293, 2599},{  332, 2929},
        {  379, 3205},{  427, 3446},{  488, 3661},{  551, 3869},
        {  611, 4064},{  676, 4260},{  733, 4474},{  796, 4652},
        {  865, 4785},{  923, 4935},{  975, 5112},{ 1028, 5275},
        { 1081, 5459},{ 1121, 5645},{ 1159, 5809},{ 1209, 5986}
      },
      /*Cr  qi=20  INTER*/
      {
        {  121,  -76},{  128,  287},{  134,  657},{  137, 1050},
        {  146, 1448},{  156, 1845},{  166, 2238},{  173, 2625},
        {  183, 2995},{  197, 3339},{  213, 3665},{  235, 3972},
        {  262, 4265},{  292, 4548},{  326, 4822},{  367, 5084},
        {  416, 5335},{  470, 5576},{  523, 5816},{  572, 6058},
        {  624, 6297},{  679, 6532},{  731, 6774},{  763, 7042}
      }
    }
  },
  {
    {
      /*Y'  qi=21  INTRA*/
      {
        {  237,  -44},{  351, 1498},{  598, 2744},{  961, 3472},
        { 1338, 3941},{ 1701, 4422},{ 2052, 4923},{ 2388, 5418},
        { 2709, 5897},{ 3020, 6358},{ 3322, 6800},{ 3621, 7175},
        { 3916, 7517},{ 4189, 7870},{ 4447, 8230},{ 4702, 8585},
        { 4950, 8904},{ 5201, 9230},{ 5435, 9534},{ 5638, 9809},
        { 5833,10099},{ 6036,10352},{ 6246,10577},{ 6466,10934}
      },
      /*Y'  qi=21  INTER*/
      {
        {  176,  -12},{  156, 1344},{  241, 2750},{  368, 4008},
        {  544, 5109},{  788, 6113},{ 1091, 7023},{ 1424, 7855},
        { 1773, 8639},{ 2134, 9383},{ 2508,10068},{ 2898,10662},
        { 3307,11127},{ 3734,11447},{ 4161,11651},{ 4567,11785},
        { 4947,11882},{ 5301,11975},{ 5630,12064},{ 5938,12127},
        { 6226,12185},{ 6496,12236},{ 6752,12268},{ 7005,12319}
      }
    },
    {
      /*Cb  qi=21  INTRA*/
      {
        {   14,    2},{  117,  369},{  194,  749},{  223, 1194},
        {  245, 1662},{  277, 2109},{  315, 2508},{  359, 2854},
        {  409, 3159},{  468, 3415},{  529, 3636},{  591, 3858},
        {  654, 4063},{  721, 4232},{  785, 4396},{  839, 4597},
        {  899, 4782},{  966, 4919},{ 1032, 5062},{ 1087, 5242},
        { 1144, 5401},{ 1195, 5546},{ 1256, 5695},{ 1326, 5879}
      },
      /*Cb  qi=21  INTER*/
      {
        {   99,  -47},{  117,  279},{  131,  628},{  136, 1036},
        {  146, 1442},{  160, 1838},{  175, 2218},{  190, 2585},
        {  206, 2939},{  225, 3275},{  246, 3589},{  271, 3884},
        {  300, 4168},{  332, 4449},{  371, 4719},{  416, 4978},
        {  466, 5233},{  525, 5486},{  594, 5729},{  668, 5967},
        {  747, 6196},{  831, 6412},{  915, 6622},{ 1007, 6824}
      }
    },
    {
      /*Cr  qi=21  INTRA*/
      {
        {   14,    5},{  115,  382},{  187,  776},{  220, 1240},
        {  242, 1714},{  268, 2165},{  304, 2563},{  347, 2880},
        {  401, 3144},{  452, 3382},{  516, 3596},{  588, 3792},
        {  649, 3986},{  717, 4174},{  783, 4371},{  849, 4539},
        {  923, 4661},{  991, 4805},{ 1046, 4977},{ 1104, 5132},
        { 1161, 5319},{ 1200, 5499},{ 1230, 5671},{ 1279, 5866}
      },
      /*Cr  qi=21  INTER*/
      {
        {  120,  -74},{  126,  287},{  132,  657},{  138, 1050},
        {  146, 1447},{  158, 1841},{  169, 2229},{  178, 2608},
        {  191, 2969},{  207, 3307},{  228, 3623},{  256, 3919},
        {  289, 4204},{  327, 4481},{  372, 4745},{  420, 4998},
        {  477, 5237},{  542, 5468},{  610, 5694},{  672, 5924},
        {  730, 6162},{  791, 6397},{  850, 6632},{  911, 6874}
      }
    }
  },
  {
    {
      /*Y'  qi=22  INTRA*/
      {
        {  238,  -42},{  353, 1495},{  607, 2723},{  979, 3433},
        { 1364, 3893},{ 1735, 4369},{ 2095, 4863},{ 2439, 5351},
        { 2769, 5823},{ 3090, 6274},{ 3398, 6709},{ 3702, 7071},
        { 4004, 7395},{ 4281, 7734},{ 4546, 8080},{ 4810, 8425},
        { 5060, 8736},{ 5313, 9050},{ 5554, 9334},{ 5763, 9596},
        { 5961, 9882},{ 6165,10130},{ 6376,10341},{ 6592,10685}
      },
      /*Y'  qi=22  INTER*/
      {
        {  173,  -13},{  157, 1344},{  247, 2741},{  385, 3983},
        {  580, 5068},{  846, 6052},{ 1167, 6942},{ 1518, 7754},
        { 1886, 8517},{ 2267, 9239},{ 2661, 9895},{ 3075,10444},
        { 3511,10854},{ 3958,11122},{ 4394,11285},{ 4803,11401},
        { 5184,11500},{ 5538,11587},{ 5867,11669},{ 6176,11748},
        { 6462,11803},{ 6730,11834},{ 6987,11870},{ 7217,11864}
      }
    },
    {
      /*Cb  qi=22  INTRA*/
      {
        {   15,    2},{  117,  369},{  194,  750},{  224, 1194},
        {  247, 1660},{  280, 2104},{  320, 2500},{  366, 2844},
        {  417, 3145},{  478, 3397},{  542, 3615},{  606, 3833},
        {  671, 4032},{  739, 4198},{  803, 4362},{  862, 4554},
        {  930, 4723},{  999, 4863},{ 1063, 5005},{ 1119, 5182},
        { 1179, 5342},{ 1233, 5479},{ 1289, 5627},{ 1349, 5821}
      },
      /*Cb  qi=22  INTER*/
      {
        {  111,  -49},{  122,  279},{  129,  629},{  136, 1037},
        {  147, 1442},{  161, 1837},{  177, 2215},{  193, 2577},
        {  211, 2927},{  232, 3257},{  257, 3564},{  285, 3855},
        {  316, 4140},{  350, 4416},{  395, 4680},{  447, 4936},
        {  502, 5187},{  569, 5432},{  643, 5673},{  724, 5902},
        {  812, 6125},{  899, 6338},{  983, 6541},{ 1068, 6732}
      }
    },
    {
      /*Cr  qi=22  INTRA*/
      {
        {   14,    5},{  115,  383},{  187,  776},{  220, 1240},
        {  243, 1712},{  271, 2160},{  308, 2554},{  355, 2866},
        {  411, 3122},{  464, 3356},{  530, 3571},{  603, 3768},
        {  668, 3955},{  739, 4137},{  804, 4335},{  871, 4497},
        {  951, 4609},{ 1024, 4744},{ 1078, 4916},{ 1136, 5073},
        { 1190, 5258},{ 1228, 5443},{ 1268, 5608},{ 1333, 5773}
      },
      /*Cr  qi=22  INTER*/
      {
        {  133,  -80},{  131,  286},{  133,  659},{  138, 1052},
        {  147, 1447},{  158, 1838},{  170, 2223},{  181, 2598},
        {  195, 2955},{  214, 3289},{  237, 3601},{  266, 3897},
        {  303, 4178},{  345, 4448},{  396, 4705},{  455, 4949},
        {  519, 5188},{  586, 5420},{  656, 5638},{  722, 5862},
        {  788, 6095},{  850, 6331},{  914, 6560},{  984, 6793}
      }
    }
  },
  {
    {
      /*Y'  qi=23  INTRA*/
      {
        {  253,  -36},{  377, 1480},{  654, 2660},{ 1055, 3323},
        { 1465, 3760},{ 1855, 4222},{ 2231, 4715},{ 2589, 5204},
        { 2926, 5675},{ 3254, 6131},{ 3569, 6569},{ 3878, 6931},
        { 4185, 7250},{ 4466, 7586},{ 4731, 7939},{ 4999, 8276},
        { 5254, 8578},{ 5510, 8890},{ 5751, 9167},{ 5960, 9411},
        { 6159, 9688},{ 6361, 9943},{ 6574,10148},{ 6796,10475}
      },
      /*Y'  qi=23  INTER*/
      {
        {  180,    4},{  170, 1341},{  267, 2726},{  417, 3953},
        {  631, 5022},{  920, 5989},{ 1262, 6861},{ 1629, 7664},
        { 2010, 8421},{ 2405, 9132},{ 2816, 9767},{ 3250,10280},
        { 3703,10646},{ 4164,10869},{ 4606,11013},{ 5018,11125},
        { 5396,11218},{ 5747,11308},{ 6079,11402},{ 6387,11475},
        { 6671,11523},{ 6944,11562},{ 7201,11593},{ 7461,11641}
      }
    },
    {
      /*Cb  qi=23  INTRA*/
      {
        {   15,    2},{  124,  369},{  206,  750},{  237, 1194},
        {  263, 1655},{  299, 2086},{  344, 2463},{  396, 2789},
        {  452, 3076},{  517, 3317},{  584, 3528},{  651, 3741},
        {  718, 3936},{  789, 4096},{  859, 4259},{  917, 4457},
        {  987, 4621},{ 1058, 4752},{ 1123, 4898},{ 1178, 5078},
        { 1234, 5240},{ 1294, 5378},{ 1354, 5529},{ 1420, 5731}
      },
      /*Cb  qi=23  INTER*/
      {
        {  112,   31},{  129,  334},{  143,  655},{  149, 1043},
        {  161, 1442},{  175, 1834},{  192, 2207},{  210, 2561},
        {  230, 2902},{  254, 3226},{  280, 3531},{  311, 3821},
        {  346, 4100},{  386, 4369},{  433, 4630},{  488, 4885},
        {  554, 5132},{  630, 5373},{  715, 5600},{  802, 5824},
        {  892, 6046},{  988, 6253},{ 1082, 6450},{ 1193, 6625}
      }
    },
    {
      /*Cr  qi=23  INTRA*/
      {
        {   15,    5},{  123,  385},{  199,  779},{  234, 1240},
        {  261, 1705},{  293, 2136},{  335, 2511},{  386, 2807},
        {  445, 3055},{  502, 3282},{  572, 3492},{  648, 3684},
        {  717, 3865},{  788, 4041},{  858, 4225},{  932, 4378},
        { 1014, 4492},{ 1081, 4636},{ 1134, 4814},{ 1196, 4969},
        { 1252, 5145},{ 1292, 5331},{ 1333, 5503},{ 1397, 5678}
      },
      /*Cr  qi=23  INTER*/
      {
        {  125,   56},{  136,  363},{  144,  681},{  149, 1054},
        {  160, 1448},{  173, 1837},{  185, 2214},{  197, 2583},
        {  213, 2932},{  234, 3260},{  260, 3568},{  293, 3858},
        {  334, 4135},{  384, 4397},{  439, 4650},{  503, 4892},
        {  575, 5123},{  647, 5354},{  722, 5575},{  789, 5803},
        {  856, 6034},{  929, 6255},{  996, 6480},{ 1055, 6709}
      }
    }
  },
  {
    {
      /*Y'  qi=24  INTRA*/
      {
        {  253,  -35},{  378, 1475},{  664, 2631},{ 1075, 3275},
        { 1491, 3706},{ 1887, 4161},{ 2272, 4648},{ 2639, 5129},
        { 2986, 5586},{ 3323, 6027},{ 3646, 6447},{ 3961, 6790},
        { 4274, 7098},{ 4561, 7420},{ 4831, 7758},{ 5102, 8088},
        { 5359, 8380},{ 5621, 8674},{ 5868, 8931},{ 6081, 9163},
        { 6285, 9420},{ 6492, 9646},{ 6707, 9844},{ 6924,10173}
      },
      /*Y'  qi=24  INTER*/
      {
        {  181,   -8},{  170, 1343},{  273, 2711},{  435, 3924},
        {  671, 4977},{  985, 5925},{ 1351, 6776},{ 1743, 7553},
        { 2152, 8282},{ 2574, 8957},{ 3013, 9547},{ 3476,10000},
        { 3957,10294},{ 4433,10470},{ 4879,10590},{ 5288,10697},
        { 5669,10785},{ 6020,10862},{ 6348,10939},{ 6657,11004},
        { 6940,11052},{ 7213,11094},{ 7471,11125},{ 7718,11154}
      }
    },
    {
      /*Cb  qi=24  INTRA*/
      {
        {   15,    2},{  125,  370},{  206,  751},{  238, 1194},
        {  265, 1652},{  303, 2078},{  351, 2450},{  405, 2769},
        {  464, 3052},{  532, 3288},{  602, 3495},{  669, 3705},
        {  740, 3893},{  814, 4052},{  887, 4214},{  949, 4405},
        { 1018, 4571},{ 1091, 4702},{ 1157, 4837},{ 1214, 5014},
        { 1272, 5182},{ 1334, 5315},{ 1397, 5446},{ 1458, 5652}
      },
      /*Cb  qi=24  INTER*/
      {
        {  119,   22},{  130,  330},{  140,  655},{  148, 1043},
        {  161, 1441},{  177, 1830},{  195, 2198},{  215, 2550},
        {  238, 2887},{  264, 3205},{  293, 3505},{  326, 3792},
        {  365, 4068},{  409, 4335},{  463, 4594},{  525, 4842},
        {  597, 5083},{  682, 5314},{  773, 5540},{  869, 5760},
        {  969, 5967},{ 1068, 6161},{ 1162, 6351},{ 1253, 6526}
      }
    },
    {
      /*Cr  qi=24  INTRA*/
      {
        {   16,    5},{  123,  386},{  199,  779},{  235, 1240},
        {  263, 1702},{  297, 2128},{  342, 2494},{  395, 2788},
        {  457, 3033},{  516, 3256},{  589, 3469},{  670, 3659},
        {  739, 3836},{  812, 4004},{  884, 4181},{  959, 4332},
        { 1043, 4439},{ 1117, 4575},{ 1174, 4750},{ 1231, 4907},
        { 1293, 5074},{ 1338, 5252},{ 1378, 5430},{ 1447, 5581}
      },
      /*Cr  qi=24  INTER*/
      {
        {  125,   54},{  134,  362},{  142,  681},{  149, 1055},
        {  160, 1447},{  174, 1832},{  188, 2207},{  201, 2571},
        {  219, 2917},{  242, 3241},{  271, 3543},{  308, 3829},
        {  353, 4102},{  409, 4361},{  472, 4605},{  544, 4837},
        {  621, 5067},{  698, 5293},{  774, 5514},{  848, 5734},
        {  920, 5960},{  994, 6186},{ 1075, 6396},{ 1159, 6607}
      }
    }
  },
  {
    {
      /*Y'  qi=25  INTRA*/
      {
        {  252,  -34},{  385, 1472},{  689, 2607},{ 1120, 3223},
        { 1552, 3638},{ 1965, 4082},{ 2365, 4554},{ 2747, 5020},
        { 3107, 5473},{ 3455, 5907},{ 3786, 6317},{ 4107, 6654},
        { 4430, 6947},{ 4727, 7252},{ 5007, 7579},{ 5285, 7897},
        { 5549, 8175},{ 5814, 8451},{ 6064, 8698},{ 6280, 8925},
        { 6489, 9174},{ 6702, 9384},{ 6917, 9573},{ 7130, 9898}
      },
      /*Y'  qi=25  INTER*/
      {
        {  180,   -4},{  172, 1342},{  284, 2698},{  466, 3892},
        {  730, 4924},{ 1073, 5846},{ 1465, 6670},{ 1880, 7424},
        { 2310, 8130},{ 2755, 8780},{ 3224, 9326},{ 3719, 9714},
        { 4222, 9951},{ 4704,10101},{ 5150,10210},{ 5562,10303},
        { 5942,10388},{ 6295,10474},{ 6627,10547},{ 6932,10598},
        { 7226,10648},{ 7499,10679},{ 7744,10685},{ 7988,10712}
      }
    },
    {
      /*Cb  qi=25  INTRA*/
      {
        {   16,    2},{  126,  370},{  207,  751},{  240, 1193},
        {  269, 1647},{  309, 2066},{  360, 2429},{  419, 2740},
        {  481, 3017},{  551, 3251},{  623, 3457},{  695, 3661},
        {  768, 3847},{  845, 4005},{  922, 4160},{  984, 4345},
        { 1056, 4508},{ 1136, 4632},{ 1201, 4768},{ 1253, 4941},
        { 1316, 5099},{ 1376, 5243},{ 1440, 5383},{ 1518, 5588}
      },
      /*Cb  qi=25  INTER*/
      {
        {  106,   20},{  127,  330},{  141,  655},{  149, 1043},
        {  162, 1440},{  178, 1826},{  198, 2192},{  221, 2538},
        {  248, 2868},{  277, 3182},{  309, 3479},{  346, 3765},
        {  390, 4036},{  445, 4296},{  505, 4549},{  576, 4792},
        {  659, 5024},{  751, 5251},{  850, 5468},{  950, 5682},
        { 1055, 5881},{ 1163, 6063},{ 1263, 6249},{ 1370, 6427}
      }
    },
    {
      /*Cr  qi=25  INTRA*/
      {
        {   16,    6},{  124,  386},{  201,  780},{  238, 1238},
        {  267, 1695},{  304, 2111},{  353, 2468},{  411, 2753},
        {  474, 2995},{  536, 3217},{  615, 3426},{  698, 3617},
        {  767, 3790},{  841, 3955},{  918, 4126},{  999, 4268},
        { 1082, 4375},{ 1154, 4514},{ 1213, 4687},{ 1275, 4831},
        { 1337, 5000},{ 1379, 5182},{ 1422, 5353},{ 1489, 5502}
      },
      /*Cr  qi=25  INTER*/
      {
        {  135,   50},{  138,  361},{  143,  681},{  149, 1054},
        {  161, 1445},{  176, 1828},{  191, 2199},{  206, 2560},
        {  226, 2903},{  253, 3223},{  287, 3520},{  330, 3799},
        {  383, 4062},{  445, 4315},{  518, 4556},{  598, 4783},
        {  683, 5002},{  765, 5224},{  841, 5446},{  919, 5670},
        { 1000, 5886},{ 1081, 6094},{ 1164, 6305},{ 1233, 6523}
      }
    }
  },
  {
    {
      /*Y'  qi=26  INTRA*/
      {
        {  258,  -31},{  400, 1459},{  722, 2551},{ 1169, 3138},
        { 1615, 3542},{ 2039, 3983},{ 2450, 4461},{ 2843, 4928},
        { 3216, 5372},{ 3573, 5801},{ 3910, 6212},{ 4235, 6548},
        { 4561, 6836},{ 4859, 7132},{ 5141, 7450},{ 5422, 7763},
        { 5690, 8035},{ 5958, 8307},{ 6208, 8548},{ 6426, 8763},
        { 6637, 8999},{ 6854, 9211},{ 7072, 9398},{ 7298, 9718}
      },
      /*Y'  qi=26  INTER*/
      {
        {  178,    4},{  177, 1342},{  304, 2683},{  507, 3858},
        {  799, 4872},{ 1167, 5777},{ 1579, 6592},{ 2013, 7342},
        { 2463, 8039},{ 2932, 8668},{ 3429, 9170},{ 3952, 9500},
        { 4471, 9695},{ 4958, 9825},{ 5404, 9930},{ 5816,10028},
        { 6194,10113},{ 6545,10187},{ 6878,10268},{ 7193,10333},
        { 7482,10365},{ 7753,10399},{ 8004,10427},{ 8244,10452}
      }
    },
    {
      /*Cb  qi=26  INTRA*/
      {
        {   17,    2},{  134,  370},{  222,  751},{  258, 1192},
        {  290, 1638},{  334, 2041},{  391, 2388},{  456, 2686},
        {  523, 2953},{  595, 3181},{  672, 3382},{  749, 3580},
        {  828, 3763},{  904, 3921},{  980, 4076},{ 1050, 4257},
        { 1121, 4425},{ 1199, 4551},{ 1268, 4678},{ 1329, 4855},
        { 1391, 5012},{ 1452, 5149},{ 1514, 5292},{ 1584, 5469}
      },
      /*Cb  qi=26  INTER*/
      {
        {  133,   54},{  140,  366},{  144,  683},{  151, 1052},
        {  166, 1444},{  185, 1827},{  208, 2185},{  234, 2523},
        {  264, 2845},{  300, 3152},{  337, 3446},{  381, 3724},
        {  434, 3989},{  492, 4246},{  560, 4494},{  643, 4729},
        {  735, 4957},{  831, 5185},{  938, 5397},{ 1051, 5595},
        { 1164, 5787},{ 1272, 5969},{ 1372, 6157},{ 1465, 6357}
      }
    },
    {
      /*Cr  qi=26  INTRA*/
      {
        {   16,    5},{  134,  384},{  217,  779},{  257, 1235},
        {  291, 1682},{  333, 2078},{  387, 2417},{  448, 2694},
        {  514, 2933},{  581, 3153},{  661, 3358},{  749, 3542},
        {  825, 3713},{  902, 3879},{  981, 4048},{ 1064, 4183},
        { 1146, 4294},{ 1220, 4429},{ 1283, 4589},{ 1347, 4738},
        { 1408, 4915},{ 1456, 5089},{ 1497, 5270},{ 1555, 5473}
      },
      /*Cr  qi=26  INTER*/
      {
        {  129,   55},{  138,  367},{  143,  688},{  150, 1061},
        {  165, 1451},{  182, 1830},{  199, 2194},{  217, 2547},
        {  242, 2882},{  273, 3193},{  313, 3485},{  363, 3759},
        {  423, 4018},{  495, 4261},{  579, 4492},{  668, 4714},
        {  756, 4936},{  840, 5157},{  923, 5378},{ 1009, 5598},
        { 1094, 5809},{ 1177, 6020},{ 1264, 6230},{ 1360, 6432}
      }
    }
  },
  {
    {
      /*Y'  qi=27  INTRA*/
      {
        {  258,  -32},{  403, 1460},{  736, 2556},{ 1195, 3138},
        { 1656, 3527},{ 2097, 3946},{ 2524, 4400},{ 2933, 4849},
        { 3318, 5281},{ 3685, 5701},{ 4034, 6100},{ 4369, 6424},
        { 4700, 6697},{ 5003, 6982},{ 5293, 7287},{ 5580, 7583},
        { 5851, 7847},{ 6125, 8107},{ 6381, 8335},{ 6601, 8542},
        { 6812, 8767},{ 7031, 8964},{ 7251, 9143},{ 7460, 9436}
      },
      /*Y'  qi=27  INTER*/
      {
        {  174,    3},{  178, 1343},{  309, 2679},{  528, 3841},
        {  842, 4835},{ 1234, 5715},{ 1668, 6506},{ 2125, 7231},
        { 2600, 7901},{ 3099, 8488},{ 3628, 8935},{ 4175, 9209},
        { 4704, 9366},{ 5193, 9480},{ 5640, 9581},{ 6049, 9669},
        { 6428, 9746},{ 6780, 9819},{ 7111, 9881},{ 7420, 9936},
        { 7714, 9980},{ 7987,10006},{ 8236,10015},{ 8487, 9990}
      }
    },
    {
      /*Cb  qi=27  INTRA*/
      {
        {   17,    2},{  135,  370},{  222,  752},{  258, 1192},
        {  291, 1635},{  337, 2036},{  396, 2379},{  462, 2674},
        {  530, 2937},{  605, 3163},{  682, 3361},{  762, 3552},
        {  844, 3730},{  923, 3886},{ 1001, 4038},{ 1071, 4220},
        { 1146, 4379},{ 1228, 4497},{ 1297, 4628},{ 1354, 4804},
        { 1419, 4959},{ 1489, 5092},{ 1555, 5230},{ 1629, 5427}
      },
      /*Cb  qi=27  INTER*/
      {
        {  142,   56},{  141,  368},{  143,  683},{  151, 1052},
        {  166, 1443},{  185, 1825},{  210, 2181},{  238, 2517},
        {  270, 2838},{  307, 3141},{  348, 3429},{  395, 3704},
        {  451, 3968},{  517, 4221},{  594, 4462},{  683, 4691},
        {  778, 4916},{  882, 5135},{  996, 5338},{ 1114, 5528},
        { 1228, 5719},{ 1335, 5903},{ 1444, 6078},{ 1552, 6260}
      }
    },
    {
      /*Cr  qi=27  INTRA*/
      {
        {   15,    5},{  133,  384},{  217,  778},{  257, 1235},
        {  293, 1678},{  337, 2071},{  392, 2406},{  455, 2679},
        {  523, 2915},{  594, 3127},{  678, 3328},{  765, 3510},
        {  841, 3677},{  921, 3842},{ 1000, 4006},{ 1089, 4135},
        { 1175, 4240},{ 1248, 4381},{ 1311, 4545},{ 1380, 4682},
        { 1445, 4854},{ 1491, 5030},{ 1537, 5201},{ 1630, 5329}
      },
      /*Cr  qi=27  INTER*/
      {
        {  134,   53},{  139,  366},{  143,  688},{  151, 1060},
        {  165, 1451},{  182, 1828},{  200, 2190},{  220, 2541},
        {  245, 2874},{  279, 3183},{  323, 3469},{  379, 3740},
        {  447, 3991},{  526, 4230},{  615, 4457},{  708, 4677},
        {  803, 4892},{  896, 5105},{  983, 5317},{ 1063, 5536},
        { 1149, 5753},{ 1240, 5957},{ 1334, 6155},{ 1436, 6345}
      }
    }
  },
  {
    {
      /*Y'  qi=28  INTRA*/
      {
        {  250,  -28},{  406, 1456},{  749, 2531},{ 1221, 3097},
        { 1692, 3480},{ 2144, 3894},{ 2583, 4338},{ 3005, 4778},
        { 3399, 5202},{ 3775, 5609},{ 4132, 5991},{ 4473, 6310},
        { 4808, 6577},{ 5115, 6852},{ 5412, 7147},{ 5707, 7428},
        { 5984, 7683},{ 6264, 7933},{ 6523, 8153},{ 6739, 8345},
        { 6953, 8556},{ 7178, 8740},{ 7398, 8913},{ 7628, 9201}
      },
      /*Y'  qi=28  INTER*/
      {
        {  188,    9},{  179, 1341},{  319, 2665},{  554, 3815},
        {  890, 4796},{ 1302, 5661},{ 1760, 6433},{ 2243, 7138},
        { 2741, 7788},{ 3264, 8342},{ 3817, 8740},{ 4379, 8977},
        { 4914, 9110},{ 5401, 9211},{ 5844, 9304},{ 6249, 9392},
        { 6627, 9472},{ 6979, 9540},{ 7310, 9602},{ 7619, 9648},
        { 7907, 9685},{ 8177, 9708},{ 8427, 9706},{ 8667, 9672}
      }
    },
    {
      /*Cb  qi=28  INTRA*/
      {
        {   18,    2},{  136,  370},{  224,  752},{  260, 1190},
        {  295, 1630},{  344, 2024},{  407, 2360},{  476, 2651},
        {  547, 2911},{  626, 3132},{  705, 3328},{  786, 3516},
        {  874, 3689},{  952, 3845},{ 1031, 3997},{ 1111, 4173},
        { 1188, 4330},{ 1265, 4450},{ 1335, 4580},{ 1399, 4745},
        { 1469, 4892},{ 1537, 5027},{ 1603, 5166},{ 1658, 5359}
      },
      /*Cb  qi=28  INTER*/
      {
        {  129,   58},{  138,  367},{  143,  683},{  152, 1051},
        {  168, 1441},{  188, 1819},{  214, 2172},{  245, 2504},
        {  280, 2820},{  321, 3120},{  366, 3405},{  418, 3677},
        {  482, 3935},{  555, 4181},{  637, 4421},{  729, 4651},
        {  832, 4868},{  942, 5082},{ 1060, 5284},{ 1181, 5467},
        { 1298, 5651},{ 1412, 5835},{ 1527, 6003},{ 1644, 6157}
      }
    },
    {
      /*Cr  qi=28  INTRA*/
      {
        {   17,    5},{  134,  384},{  217,  778},{  259, 1232},
        {  297, 1672},{  344, 2057},{  403, 2387},{  467, 2658},
        {  537, 2892},{  611, 3104},{  696, 3305},{  784, 3482},
        {  865, 3638},{  950, 3796},{ 1035, 3961},{ 1122, 4093},
        { 1210, 4192},{ 1288, 4326},{ 1355, 4481},{ 1427, 4613},
        { 1489, 4791},{ 1534, 4970},{ 1585, 5132},{ 1675, 5267}
      },
      /*Cr  qi=28  INTER*/
      {
        {  132,   52},{  135,  365},{  141,  687},{  151, 1061},
        {  167, 1449},{  185, 1823},{  204, 2181},{  226, 2528},
        {  254, 2856},{  292, 3162},{  341, 3446},{  403, 3710},
        {  479, 3958},{  565, 4193},{  658, 4416},{  757, 4630},
        {  855, 4844},{  949, 5058},{ 1039, 5267},{ 1128, 5479},
        { 1216, 5696},{ 1314, 5893},{ 1422, 6075},{ 1529, 6250}
      }
    }
  },
  {
    {
      /*Y'  qi=29  INTRA*/
      {
        {  256,  -19},{  440, 1432},{  823, 2441},{ 1332, 2962},
        { 1823, 3333},{ 2290, 3743},{ 2744, 4191},{ 3179, 4635},
        { 3581, 5067},{ 3964, 5474},{ 4330, 5853},{ 4674, 6173},
        { 5012, 6435},{ 5323, 6703},{ 5626, 6990},{ 5926, 7263},
        { 6200, 7506},{ 6482, 7745},{ 6745, 7958},{ 6964, 8149},
        { 7177, 8350},{ 7401, 8529},{ 7623, 8694},{ 7865, 8975}
      },
      /*Y'  qi=29  INTER*/
      {
        {  193,   -3},{  195, 1340},{  350, 2649},{  615, 3772},
        {  987, 4730},{ 1432, 5577},{ 1915, 6337},{ 2421, 7033},
        { 2948, 7660},{ 3506, 8171},{ 4092, 8506},{ 4674, 8689},
        { 5209, 8810},{ 5690, 8915},{ 6126, 9009},{ 6531, 9093},
        { 6905, 9159},{ 7250, 9232},{ 7582, 9297},{ 7894, 9345},
        { 8183, 9382},{ 8451, 9400},{ 8704, 9415},{ 8946, 9404}
      }
    },
    {
      /*Cb  qi=29  INTRA*/
      {
        {   18,    2},{  142,  371},{  235,  752},{  276, 1186},
        {  315, 1612},{  372, 1987},{  444, 2305},{  520, 2578},
        {  597, 2824},{  682, 3035},{  769, 3224},{  856, 3410},
        {  948, 3581},{ 1033, 3730},{ 1117, 3883},{ 1196, 4059},
        { 1276, 4212},{ 1357, 4332},{ 1419, 4467},{ 1481, 4636},
        { 1561, 4780},{ 1629, 4919},{ 1689, 5071},{ 1748, 5260}
      },
      /*Cb  qi=29  INTER*/
      {
        {  146,   39},{  153,  353},{  156,  673},{  164, 1049},
        {  181, 1437},{  203, 1810},{  230, 2155},{  264, 2480},
        {  303, 2792},{  348, 3087},{  401, 3365},{  464, 3630},
        {  537, 3883},{  621, 4125},{  714, 4357},{  817, 4578},
        {  932, 4789},{ 1056, 4990},{ 1185, 5182},{ 1310, 5363},
        { 1437, 5531},{ 1559, 5709},{ 1671, 5883},{ 1783, 6059}
      }
    },
    {
      /*Cr  qi=29  INTRA*/
      {
        {   19,    6},{  142,  385},{  228,  779},{  273, 1227},
        {  317, 1650},{  373, 2011},{  440, 2322},{  512, 2584},
        {  588, 2809},{  668, 3013},{  760, 3207},{  851, 3380},
        {  936, 3533},{ 1030, 3687},{ 1118, 3853},{ 1203, 3986},
        { 1292, 4081},{ 1369, 4215},{ 1438, 4373},{ 1510, 4510},
        { 1569, 4695},{ 1619, 4871},{ 1675, 5031},{ 1775, 5166}
      },
      /*Cr  qi=29  INTER*/
      {
        {  143,    2},{  149,  356},{  155,  684},{  163, 1059},
        {  179, 1445},{  198, 1812},{  218, 2166},{  243, 2507},
        {  276, 2828},{  320, 3126},{  380, 3401},{  453, 3659},
        {  541, 3897},{  639, 4123},{  742, 4341},{  848, 4552},
        {  953, 4763},{ 1051, 4973},{ 1143, 5186},{ 1243, 5395},
        { 1350, 5596},{ 1453, 5785},{ 1569, 5957},{ 1706, 6124}
      }
    }
  },
  {
    {
      /*Y'  qi=30  INTRA*/
      {
        {  253,  -16},{  448, 1426},{  855, 2407},{ 1388, 2904},
        { 1899, 3262},{ 2386, 3661},{ 2864, 4094},{ 3323, 4518},
        { 3747, 4929},{ 4147, 5313},{ 4530, 5669},{ 4889, 5966},
        { 5235, 6209},{ 5556, 6456},{ 5869, 6717},{ 6178, 6971},
        { 6464, 7204},{ 6756, 7428},{ 7023, 7622},{ 7247, 7789},
        { 7472, 7974},{ 7704, 8141},{ 7930, 8299},{ 8183, 8558}
      },
      /*Y'  qi=30  INTER*/
      {
        {  189,   -4},{  197, 1340},{  370, 2631},{  669, 3731},
        { 1081, 4662},{ 1564, 5480},{ 2087, 6209},{ 2633, 6870},
        { 3209, 7445},{ 3821, 7868},{ 4445, 8110},{ 5032, 8243},
        { 5559, 8348},{ 6032, 8446},{ 6463, 8534},{ 6858, 8610},
        { 7222, 8671},{ 7566, 8730},{ 7891, 8790},{ 8196, 8839},
        { 8483, 8875},{ 8752, 8881},{ 9009, 8882},{ 9238, 8898}
      }
    },
    {
      /*Cb  qi=30  INTRA*/
      {
        {   18,    2},{  143,  371},{  238,  752},{  279, 1183},
        {  321, 1603},{  383, 1969},{  461, 2281},{  542, 2550},
        {  623, 2788},{  712, 2992},{  803, 3174},{  899, 3353},
        {  997, 3516},{ 1087, 3662},{ 1176, 3808},{ 1259, 3975},
        { 1340, 4129},{ 1422, 4243},{ 1496, 4370},{ 1560, 4541},
        { 1631, 4696},{ 1699, 4839},{ 1767, 4981},{ 1831, 5182}
      },
      /*Cb  qi=30  INTER*/
      {
        {  157,   37},{  158,  352},{  158,  673},{  166, 1049},
        {  184, 1435},{  208, 1803},{  239, 2141},{  276, 2460},
        {  322, 2766},{  373, 3057},{  434, 3330},{  507, 3587},
        {  591, 3833},{  685, 4069},{  788, 4294},{  903, 4507},
        { 1027, 4714},{ 1162, 4905},{ 1301, 5087},{ 1440, 5262},
        { 1568, 5430},{ 1689, 5598},{ 1817, 5759},{ 1938, 5957}
      }
    },
    {
      /*Cr  qi=30  INTRA*/
      {
        {   19,    6},{  144,  385},{  230,  778},{  276, 1224},
        {  323, 1641},{  386, 1992},{  459, 2296},{  534, 2554},
        {  614, 2772},{  699, 2971},{  798, 3160},{  893, 3329},
        {  982, 3476},{ 1083, 3624},{ 1176, 3782},{ 1264, 3908},
        { 1354, 4002},{ 1432, 4135},{ 1505, 4282},{ 1582, 4410},
        { 1648, 4591},{ 1695, 4771},{ 1756, 4922},{ 1850, 5020}
      },
      /*Cr  qi=30  INTER*/
      {
        {  141,    5},{  148,  354},{  155,  684},{  164, 1058},
        {  181, 1441},{  202, 1804},{  225, 2154},{  252, 2491},
        {  292, 2806},{  345, 3096},{  414, 3363},{  499, 3612},
        {  596, 3844},{  705, 4066},{  819, 4279},{  933, 4480},
        { 1043, 4687},{ 1147, 4899},{ 1246, 5108},{ 1354, 5308},
        { 1472, 5496},{ 1592, 5676},{ 1726, 5831},{ 1859, 5990}
      }
    }
  },
  {
    {
      /*Y'  qi=31  INTRA*/
      {
        {  253,  -12},{  454, 1419},{  882, 2378},{ 1435, 2861},
        { 1951, 3215},{ 2444, 3610},{ 2928, 4039},{ 3394, 4459},
        { 3825, 4870},{ 4228, 5259},{ 4612, 5613},{ 4975, 5905},
        { 5324, 6143},{ 5645, 6389},{ 5958, 6646},{ 6273, 6890},
        { 6558, 7114},{ 6847, 7335},{ 7115, 7527},{ 7339, 7690},
        { 7563, 7874},{ 7792, 8041},{ 8013, 8196},{ 8270, 8449}
      },
      /*Y'  qi=31  INTER*/
      {
        {  189,   -3},{  199, 1339},{  393, 2612},{  727, 3689},
        { 1177, 4597},{ 1690, 5399},{ 2238, 6117},{ 2810, 6766},
        { 3413, 7317},{ 4050, 7703},{ 4686, 7916},{ 5273, 8037},
        { 5792, 8136},{ 6260, 8234},{ 6684, 8325},{ 7074, 8394},
        { 7435, 8456},{ 7775, 8517},{ 8103, 8572},{ 8410, 8617},
        { 8694, 8644},{ 8960, 8658},{ 9224, 8670},{ 9489, 8694}
      }
    },
    {
      /*Cb  qi=31  INTRA*/
      {
        {   19,    2},{  145,  371},{  240,  752},{  281, 1181},
        {  326, 1595},{  392, 1954},{  472, 2257},{  556, 2517},
        {  640, 2750},{  730, 2951},{  825, 3131},{  922, 3310},
        { 1018, 3477},{ 1110, 3621},{ 1203, 3765},{ 1282, 3938},
        { 1361, 4096},{ 1443, 4214},{ 1516, 4340},{ 1579, 4508},
        { 1649, 4662},{ 1716, 4805},{ 1790, 4941},{ 1871, 5133}
      },
      /*Cb  qi=31  INTER*/
      {
        {  148,   37},{  152,  352},{  157,  674},{  167, 1048},
        {  186, 1432},{  212, 1795},{  248, 2128},{  291, 2442},
        {  341, 2742},{  404, 3025},{  474, 3292},{  555, 3546},
        {  651, 3784},{  757, 4013},{  867, 4235},{  993, 4441},
        { 1130, 4636},{ 1274, 4823},{ 1422, 4995},{ 1566, 5160},
        { 1703, 5323},{ 1829, 5493},{ 1954, 5663},{ 2101, 5780}
      }
    },
    {
      /*Cr  qi=31  INTRA*/
      {
        {   19,    6},{  145,  386},{  232,  778},{  278, 1221},
        {  328, 1631},{  396, 1972},{  472, 2268},{  547, 2521},
        {  628, 2738},{  715, 2936},{  817, 3120},{  913, 3291},
        { 1005, 3442},{ 1105, 3591},{ 1198, 3747},{ 1286, 3870},
        { 1378, 3961},{ 1461, 4092},{ 1532, 4244},{ 1605, 4377},
        { 1668, 4560},{ 1717, 4737},{ 1780, 4885},{ 1882, 4986}
      },
      /*Cr  qi=31  INTER*/
      {
        {  138,    6},{  148,  354},{  155,  684},{  165, 1057},
        {  184, 1437},{  207, 1796},{  233, 2141},{  266, 2472},
        {  312, 2780},{  372, 3065},{  451, 3327},{  549, 3567},
        {  660, 3794},{  779, 4006},{  906, 4208},{ 1025, 4411},
        { 1139, 4617},{ 1250, 4823},{ 1360, 5024},{ 1475, 5221},
        { 1601, 5400},{ 1739, 5557},{ 1880, 5707},{ 2019, 5854}
      }
    }
  },
  {
    {
      /*Y'  qi=32  INTRA*/
      {
        {  250,  -10},{  458, 1417},{  901, 2366},{ 1469, 2839},
        { 2000, 3182},{ 2507, 3559},{ 3007, 3966},{ 3487, 4369},
        { 3932, 4765},{ 4348, 5136},{ 4742, 5472},{ 5113, 5743},
        { 5471, 5971},{ 5798, 6206},{ 6118, 6451},{ 6437, 6686},
        { 6729, 6903},{ 7024, 7119},{ 7295, 7300},{ 7521, 7455},
        { 7744, 7627},{ 7976, 7778},{ 8202, 7925},{ 8472, 8175}
      },
      /*Y'  qi=32  INTER*/
      {
        {  192,   11},{  200, 1338},{  399, 2605},{  747, 3673},
        { 1215, 4570},{ 1751, 5350},{ 2329, 6039},{ 2936, 6653},
        { 3576, 7153},{ 4241, 7479},{ 4887, 7649},{ 5471, 7752},
        { 5987, 7842},{ 6451, 7932},{ 6874, 8009},{ 7261, 8068},
        { 7624, 8122},{ 7965, 8176},{ 8292, 8225},{ 8597, 8261},
        { 8882, 8291},{ 9155, 8301},{ 9410, 8303},{ 9639, 8288}
      }
    },
    {
      /*Cb  qi=32  INTRA*/
      {
        {   19,    2},{  145,  371},{  239,  752},{  283, 1180},
        {  329, 1593},{  398, 1950},{  483, 2252},{  569, 2511},
        {  656, 2741},{  754, 2936},{  853, 3107},{  952, 3283},
        { 1055, 3443},{ 1155, 3579},{ 1250, 3715},{ 1331, 3881},
        { 1414, 4035},{ 1498, 4155},{ 1569, 4289},{ 1634, 4460},
        { 1705, 4613},{ 1776, 4746},{ 1850, 4878},{ 1921, 5076}
      },
      /*Cb  qi=32  INTER*/
      {
        {  137,   30},{  147,  350},{  157,  674},{  168, 1048},
        {  186, 1431},{  214, 1792},{  250, 2124},{  295, 2436},
        {  350, 2733},{  413, 3013},{  487, 3279},{  575, 3529},
        {  675, 3766},{  784, 3994},{  900, 4210},{ 1030, 4410},
        { 1174, 4601},{ 1323, 4780},{ 1475, 4947},{ 1621, 5109},
        { 1760, 5266},{ 1888, 5434},{ 2019, 5608},{ 2176, 5736}
      }
    },
    {
      /*Cr  qi=32  INTRA*/
      {
        {   19,    6},{  145,  386},{  232,  778},{  281, 1219},
        {  333, 1627},{  402, 1968},{  482, 2263},{  562, 2514},
        {  648, 2726},{  738, 2917},{  842, 3100},{  945, 3261},
        { 1040, 3401},{ 1145, 3544},{ 1242, 3699},{ 1335, 3819},
        { 1433, 3906},{ 1514, 4037},{ 1586, 4183},{ 1663, 4310},
        { 1731, 4495},{ 1785, 4671},{ 1849, 4812},{ 1948, 4904}
      },
      /*Cr  qi=32  INTER*/
      {
        {  134,    6},{  146,  354},{  156,  683},{  165, 1057},
        {  184, 1437},{  208, 1794},{  235, 2136},{  270, 2466},
        {  318, 2773},{  383, 3054},{  466, 3313},{  569, 3551},
        {  687, 3770},{  812, 3979},{  937, 4180},{ 1058, 4381},
        { 1172, 4585},{ 1288, 4787},{ 1408, 4985},{ 1528, 5173},
        { 1655, 5351},{ 1796, 5507},{ 1948, 5638},{ 2094, 5762}
      }
    }
  },
  {
    {
      /*Y'  qi=33  INTRA*/
      {
        {  251,   -3},{  482, 1400},{  956, 2310},{ 1547, 2757},
        { 2093, 3091},{ 2618, 3466},{ 3134, 3876},{ 3627, 4282},
        { 4082, 4675},{ 4507, 5046},{ 4908, 5383},{ 5283, 5659},
        { 5640, 5883},{ 5971, 6103},{ 6296, 6342},{ 6615, 6576},
        { 6909, 6783},{ 7206, 6990},{ 7476, 7167},{ 7700, 7318},
        { 7924, 7482},{ 8156, 7632},{ 8390, 7783},{ 8661, 8018}
      },
      /*Y'  qi=33  INTER*/
      {
        {  203,   42},{  212, 1342},{  438, 2585},{  826, 3628},
        { 1333, 4507},{ 1902, 5276},{ 2508, 5959},{ 3143, 6559},
        { 3816, 7021},{ 4504, 7301},{ 5154, 7443},{ 5731, 7545},
        { 6241, 7640},{ 6699, 7726},{ 7118, 7804},{ 7509, 7867},
        { 7867, 7922},{ 8206, 7981},{ 8536, 8031},{ 8842, 8055},
        { 9122, 8072},{ 9399, 8088},{ 9654, 8089},{ 9879, 8087}
      }
    },
    {
      /*Cb  qi=33  INTRA*/
      {
        {   22,    2},{  159,  372},{  260,  753},{  305, 1177},
        {  357, 1577},{  434, 1917},{  523, 2204},{  614, 2451},
        {  707, 2670},{  810, 2859},{  914, 3028},{ 1015, 3204},
        { 1120, 3367},{ 1223, 3507},{ 1321, 3644},{ 1400, 3812},
        { 1481, 3965},{ 1562, 4088},{ 1635, 4224},{ 1701, 4393},
        { 1770, 4550},{ 1847, 4681},{ 1927, 4812},{ 2007, 5028}
      },
      /*Cb  qi=33  INTER*/
      {
        {  148,   39},{  157,  355},{  165,  678},{  177, 1050},
        {  197, 1428},{  228, 1781},{  269, 2105},{  322, 2411},
        {  384, 2703},{  456, 2977},{  543, 3235},{  642, 3479},
        {  753, 3710},{  872, 3932},{ 1000, 4144},{ 1144, 4339},
        { 1300, 4520},{ 1458, 4692},{ 1618, 4855},{ 1771, 5013},
        { 1908, 5175},{ 2050, 5337},{ 2195, 5501},{ 2336, 5652}
      }
    },
    {
      /*Cr  qi=33  INTRA*/
      {
        {   23,    6},{  159,  388},{  251,  781},{  303, 1215},
        {  363, 1607},{  440, 1930},{  525, 2208},{  609, 2447},
        {  698, 2656},{  793, 2847},{  898, 3028},{ 1004, 3191},
        { 1105, 3334},{ 1214, 3475},{ 1312, 3627},{ 1404, 3748},
        { 1499, 3841},{ 1581, 3971},{ 1654, 4119},{ 1728, 4253},
        { 1796, 4435},{ 1853, 4608},{ 1925, 4746},{ 2021, 4852}
      },
      /*Cr  qi=33  INTER*/
      {
        {  151,    6},{  152,  359},{  162,  686},{  173, 1058},
        {  194, 1432},{  221, 1782},{  253, 2118},{  293, 2442},
        {  351, 2741},{  428, 3014},{  524, 3266},{  641, 3495},
        {  771, 3708},{  903, 3914},{ 1036, 4112},{ 1168, 4312},
        { 1291, 4513},{ 1416, 4709},{ 1541, 4904},{ 1670, 5090},
        { 1808, 5263},{ 1962, 5409},{ 2136, 5516},{ 2329, 5593}
      }
    }
  },
  {
    {
      /*Y'  qi=34  INTRA*/
      {
        {  249,    0},{  488, 1396},{  986, 2289},{ 1601, 2724},
        { 2165, 3049},{ 2706, 3409},{ 3240, 3798},{ 3748, 4183},
        { 4214, 4561},{ 4650, 4916},{ 5062, 5232},{ 5446, 5484},
        { 5810, 5686},{ 6143, 5888},{ 6467, 6114},{ 6786, 6340},
        { 7076, 6539},{ 7371, 6728},{ 7644, 6893},{ 7861, 7037},
        { 8071, 7188},{ 8302, 7324},{ 8542, 7465},{ 8808, 7698}
      },
      /*Y'  qi=34  INTER*/
      {
        {  205,    9},{  214, 1338},{  464, 2567},{  895, 3586},
        { 1446, 4434},{ 2058, 5171},{ 2711, 5819},{ 3401, 6368},
        { 4128, 6753},{ 4846, 6963},{ 5495, 7075},{ 6064, 7158},
        { 6568, 7237},{ 7021, 7308},{ 7433, 7365},{ 7816, 7412},
        { 8173, 7454},{ 8507, 7484},{ 8827, 7504},{ 9135, 7516},
        { 9410, 7514},{ 9670, 7500},{ 9914, 7484},{10130, 7453}
      }
    },
    {
      /*Cb  qi=34  INTRA*/
      {
        {   17,    2},{  157,  371},{  261,  752},{  306, 1174},
        {  363, 1568},{  445, 1901},{  540, 2186},{  636, 2432},
        {  734, 2649},{  843, 2833},{  951, 2994},{ 1059, 3162},
        { 1169, 3320},{ 1272, 3456},{ 1372, 3588},{ 1457, 3751},
        { 1542, 3902},{ 1628, 4026},{ 1701, 4161},{ 1770, 4323},
        { 1847, 4473},{ 1915, 4604},{ 1989, 4743},{ 2079, 4962}
      },
      /*Cb  qi=34  INTER*/
      {
        {  141,   42},{  155,  356},{  165,  677},{  178, 1049},
        {  200, 1426},{  235, 1775},{  281, 2093},{  340, 2393},
        {  412, 2679},{  496, 2947},{  593, 3200},{  704, 3436},
        {  826, 3660},{  955, 3873},{ 1092, 4075},{ 1247, 4259},
        { 1417, 4424},{ 1586, 4583},{ 1748, 4738},{ 1907, 4891},
        { 2063, 5037},{ 2212, 5187},{ 2356, 5362},{ 2511, 5551}
      }
    },
    {
      /*Cr  qi=34  INTRA*/
      {
        {   18,    5},{  157,  387},{  252,  780},{  304, 1210},
        {  369, 1595},{  452, 1913},{  542, 2192},{  630, 2430},
        {  725, 2633},{  826, 2820},{  937, 2997},{ 1047, 3156},
        { 1153, 3287},{ 1267, 3420},{ 1367, 3569},{ 1462, 3690},
        { 1559, 3782},{ 1643, 3911},{ 1718, 4052},{ 1793, 4182},
        { 1864, 4364},{ 1923, 4528},{ 1992, 4664},{ 2092, 4771}
      },
      /*Cr  qi=34  INTER*/
      {
        {  139,    9},{  153,  358},{  164,  687},{  175, 1058},
        {  198, 1430},{  227, 1776},{  262, 2108},{  309, 2426},
        {  375, 2719},{  463, 2986},{  573, 3228},{  702, 3450},
        {  840, 3656},{  982, 3853},{ 1129, 4042},{ 1268, 4235},
        { 1396, 4431},{ 1533, 4617},{ 1670, 4804},{ 1815, 4972},
        { 1980, 5111},{ 2151, 5235},{ 2335, 5328},{ 2519, 5413}
      }
    }
  },
  {
    {
      /*Y'  qi=35  INTRA*/
      {
        {  242,    4},{  497, 1386},{ 1017, 2259},{ 1653, 2679},
        { 2235, 2992},{ 2795, 3342},{ 3347, 3720},{ 3871, 4093},
        { 4355, 4460},{ 4805, 4799},{ 5229, 5094},{ 5625, 5323},
        { 5997, 5512},{ 6337, 5712},{ 6671, 5931},{ 7003, 6144},
        { 7305, 6337},{ 7614, 6525},{ 7898, 6682},{ 8129, 6817},
        { 8360, 6965},{ 8601, 7095},{ 8851, 7222},{ 9128, 7438}
      },
      /*Y'  qi=35  INTER*/
      {
        {  204,    2},{  217, 1336},{  495, 2550},{  967, 3544},
        { 1558, 4367},{ 2207, 5083},{ 2895, 5709},{ 3626, 6213},
        { 4389, 6534},{ 5118, 6697},{ 5766, 6798},{ 6332, 6884},
        { 6838, 6965},{ 7296, 7043},{ 7719, 7102},{ 8111, 7154},
        { 8476, 7201},{ 8826, 7248},{ 9160, 7286},{ 9476, 7308},
        { 9774, 7329},{10054, 7343},{10316, 7339},{10575, 7351}
      }
    },
    {
      /*Cb  qi=35  INTRA*/
      {
        {   23,    2},{  162,  372},{  263,  752},{  312, 1170},
        {  373, 1557},{  462, 1883},{  563, 2158},{  667, 2396},
        {  772, 2607},{  887, 2785},{  999, 2947},{ 1112, 3113},
        { 1226, 3266},{ 1332, 3402},{ 1433, 3537},{ 1519, 3696},
        { 1609, 3845},{ 1695, 3968},{ 1772, 4099},{ 1845, 4256},
        { 1925, 4408},{ 1994, 4545},{ 2065, 4677},{ 2146, 4904}
      },
      /*Cb  qi=35  INTER*/
      {
        {  147,   34},{  157,  354},{  167,  678},{  179, 1048},
        {  203, 1422},{  241, 1768},{  293, 2083},{  359, 2379},
        {  440, 2659},{  535, 2921},{  645, 3167},{  768, 3399},
        {  897, 3619},{ 1034, 3829},{ 1182, 4024},{ 1345, 4202},
        { 1525, 4365},{ 1704, 4518},{ 1872, 4673},{ 2038, 4824},
        { 2201, 4966},{ 2358, 5126},{ 2508, 5302},{ 2648, 5479}
      }
    },
    {
      /*Cr  qi=35  INTRA*/
      {
        {   25,    6},{  162,  389},{  255,  780},{  312, 1206},
        {  382, 1583},{  470, 1894},{  565, 2166},{  657, 2399},
        {  757, 2599},{  863, 2783},{  979, 2956},{ 1096, 3110},
        { 1209, 3239},{ 1323, 3370},{ 1424, 3518},{ 1522, 3640},
        { 1620, 3738},{ 1710, 3860},{ 1792, 3985},{ 1867, 4109},
        { 1938, 4287},{ 2003, 4451},{ 2074, 4585},{ 2192, 4655}
      },
      /*Cr  qi=35  INTER*/
      {
        {  135,    8},{  154,  359},{  164,  687},{  176, 1056},
        {  202, 1425},{  234, 1769},{  274, 2098},{  328, 2411},
        {  404, 2698},{  504, 2958},{  628, 3194},{  769, 3409},
        {  918, 3608},{ 1068, 3799},{ 1215, 3990},{ 1360, 4178},
        { 1498, 4373},{ 1637, 4563},{ 1786, 4743},{ 1942, 4904},
        { 2117, 5033},{ 2299, 5148},{ 2497, 5226},{ 2705, 5259}
      }
    }
  },
  {
    {
      /*Y'  qi=36  INTRA*/
      {
        {  235,   11},{  510, 1382},{ 1051, 2249},{ 1711, 2656},
        { 2318, 2951},{ 2906, 3275},{ 3484, 3630},{ 4030, 3984},
        { 4531, 4330},{ 4995, 4651},{ 5433, 4930},{ 5837, 5147},
        { 6213, 5325},{ 6560, 5519},{ 6901, 5737},{ 7234, 5946},
        { 7539, 6134},{ 7857, 6316},{ 8153, 6471},{ 8388, 6597},
        { 8618, 6732},{ 8865, 6856},{ 9121, 6978},{ 9381, 7166}
      },
      /*Y'  qi=36  INTER*/
      {
        {  206,    6},{  219, 1335},{  520, 2535},{ 1028, 3510},
        { 1661, 4306},{ 2354, 4990},{ 3089, 5579},{ 3862, 6036},
        { 4652, 6305},{ 5389, 6436},{ 6032, 6527},{ 6597, 6606},
        { 7102, 6680},{ 7564, 6752},{ 7990, 6809},{ 8386, 6856},
        { 8762, 6900},{ 9118, 6941},{ 9456, 6975},{ 9772, 6995},
        {10074, 7009},{10355, 7020},{10617, 7016},{10868, 7004}
      }
    },
    {
      /*Cb  qi=36  INTRA*/
      {
        {   22,    2},{  163,  372},{  265,  752},{  314, 1167},
        {  379, 1551},{  471, 1873},{  577, 2144},{  684, 2375},
        {  794, 2580},{  914, 2751},{ 1031, 2909},{ 1147, 3070},
        { 1267, 3216},{ 1378, 3352},{ 1481, 3484},{ 1572, 3639},
        { 1663, 3783},{ 1750, 3905},{ 1825, 4041},{ 1898, 4197},
        { 1985, 4339},{ 2063, 4468},{ 2131, 4613},{ 2213, 4832}
      },
      /*Cb  qi=36  INTER*/
      {
        {  148,   34},{  159,  353},{  168,  678},{  181, 1047},
        {  206, 1419},{  246, 1762},{  304, 2072},{  378, 2364},
        {  466, 2640},{  571, 2898},{  691, 3139},{  821, 3366},
        {  962, 3579},{ 1108, 3782},{ 1268, 3968},{ 1443, 4138},
        { 1628, 4296},{ 1813, 4446},{ 1996, 4587},{ 2170, 4732},
        { 2335, 4877},{ 2502, 5023},{ 2662, 5204},{ 2816, 5396}
      }
    },
    {
      /*Cr  qi=36  INTRA*/
      {
        {   24,    6},{  162,  388},{  256,  780},{  314, 1203},
        {  389, 1575},{  480, 1883},{  578, 2151},{  675, 2377},
        {  780, 2570},{  890, 2750},{ 1012, 2917},{ 1138, 3062},
        { 1254, 3187},{ 1371, 3316},{ 1474, 3461},{ 1574, 3582},
        { 1678, 3671},{ 1771, 3784},{ 1846, 3917},{ 1918, 4044},
        { 1996, 4218},{ 2068, 4367},{ 2143, 4494},{ 2248, 4581}
      },
      /*Cr  qi=36  INTER*/
      {
        {  140,   10},{  157,  358},{  165,  686},{  178, 1055},
        {  204, 1422},{  239, 1763},{  282, 2088},{  343, 2397},
        {  429, 2679},{  541, 2934},{  675, 3164},{  825, 3371},
        {  980, 3566},{ 1138, 3754},{ 1295, 3937},{ 1447, 4126},
        { 1593, 4315},{ 1742, 4495},{ 1899, 4667},{ 2071, 4815},
        { 2261, 4930},{ 2466, 5024},{ 2677, 5085},{ 2901, 5092}
      }
    }
  },
  {
    {
      /*Y'  qi=37  INTRA*/
      {
        {  236,   30},{  562, 1355},{ 1128, 2197},{ 1803, 2592},
        { 2429, 2875},{ 3038, 3188},{ 3631, 3539},{ 4185, 3892},
        { 4690, 4240},{ 5159, 4563},{ 5598, 4838},{ 6002, 5050},
        { 6378, 5230},{ 6728, 5421},{ 7072, 5629},{ 7409, 5838},
        { 7717, 6024},{ 8036, 6204},{ 8333, 6356},{ 8573, 6479},
        { 8800, 6613},{ 9047, 6741},{ 9301, 6864},{ 9571, 7063}
      },
      /*Y'  qi=37  INTER*/
      {
        {  210,    5},{  222, 1332},{  548, 2519},{ 1091, 3477},
        { 1756, 4260},{ 2475, 4935},{ 3235, 5511},{ 4034, 5937},
        { 4839, 6173},{ 5573, 6290},{ 6212, 6379},{ 6772, 6459},
        { 7276, 6531},{ 7737, 6599},{ 8163, 6655},{ 8566, 6701},
        { 8944, 6745},{ 9299, 6784},{ 9636, 6814},{ 9953, 6836},
        {10257, 6854},{10549, 6867},{10813, 6863},{11053, 6834}
      }
    },
    {
      /*Cb  qi=37  INTRA*/
      {
        {   27,    2},{  179,  373},{  291,  752},{  345, 1160},
        {  416, 1532},{  515, 1843},{  627, 2103},{  739, 2327},
        {  854, 2526},{  978, 2693},{ 1102, 2846},{ 1221, 3007},
        { 1340, 3157},{ 1452, 3292},{ 1556, 3427},{ 1648, 3585},
        { 1738, 3731},{ 1824, 3859},{ 1901, 3998},{ 1972, 4147},
        { 2064, 4282},{ 2145, 4421},{ 2216, 4567},{ 2285, 4785}
      },
      /*Cb  qi=37  INTER*/
      {
        {  157,   33},{  162,  355},{  168,  679},{  182, 1045},
        {  210, 1414},{  255, 1754},{  317, 2061},{  398, 2348},
        {  496, 2619},{  611, 2872},{  740, 3108},{  880, 3331},
        { 1027, 3542},{ 1182, 3738},{ 1349, 3920},{ 1534, 4085},
        { 1732, 4234},{ 1924, 4377},{ 2105, 4527},{ 2285, 4673},
        { 2464, 4806},{ 2635, 4956},{ 2797, 5133},{ 2980, 5305}
      }
    },
    {
      /*Cr  qi=37  INTRA*/
      {
        {   36,    7},{  180,  394},{  277,  785},{  341, 1199},
        {  424, 1556},{  524, 1851},{  628, 2108},{  730, 2325},
        {  842, 2513},{  957, 2689},{ 1084, 2853},{ 1212, 3001},
        { 1330, 3129},{ 1449, 3255},{ 1553, 3398},{ 1650, 3522},
        { 1752, 3622},{ 1848, 3735},{ 1924, 3863},{ 1994, 3995},
        { 2072, 4168},{ 2145, 4323},{ 2215, 4454},{ 2324, 4538}
      },
      /*Cr  qi=37  INTER*/
      {
        {  149,    9},{  157,  359},{  166,  686},{  180, 1053},
        {  208, 1417},{  246, 1755},{  295, 2077},{  362, 2381},
        {  458, 2657},{  580, 2905},{  725, 3130},{  886, 3333},
        { 1050, 3523},{ 1213, 3707},{ 1373, 3893},{ 1529, 4078},
        { 1690, 4256},{ 1848, 4436},{ 2012, 4605},{ 2196, 4742},
        { 2397, 4844},{ 2616, 4919},{ 2839, 4964},{ 3068, 4999}
      }
    }
  },
  {
    {
      /*Y'  qi=38  INTRA*/
      {
        {  236,   32},{  570, 1352},{ 1154, 2183},{ 1846, 2567},
        { 2492, 2835},{ 3124, 3127},{ 3740, 3457},{ 4315, 3791},
        { 4844, 4115},{ 5329, 4414},{ 5780, 4670},{ 6193, 4864},
        { 6578, 5028},{ 6937, 5212},{ 7292, 5410},{ 7639, 5604},
        { 7956, 5783},{ 8286, 5953},{ 8589, 6102},{ 8830, 6217},
        { 9069, 6339},{ 9321, 6458},{ 9578, 6574},{ 9858, 6766}
      },
      /*Y'  qi=38  INTER*/
      {
        {  210,    7},{  226, 1331},{  589, 2497},{ 1187, 3424},
        { 1908, 4173},{ 2682, 4812},{ 3496, 5341},{ 4347, 5698},
        { 5176, 5876},{ 5911, 5973},{ 6546, 6054},{ 7109, 6130},
        { 7619, 6200},{ 8085, 6256},{ 8519, 6308},{ 8927, 6352},
        { 9307, 6387},{ 9672, 6424},{10024, 6455},{10352, 6479},
        {10665, 6495},{10955, 6501},{11224, 6504},{11463, 6509}
      }
    },
    {
      /*Cb  qi=38  INTRA*/
      {
        {   29,    3},{  181,  373},{  292,  752},{  350, 1157},
        {  429, 1525},{  537, 1831},{  654, 2087},{  772, 2304},
        {  894, 2495},{ 1025, 2655},{ 1151, 2804},{ 1276, 2961},
        { 1403, 3106},{ 1517, 3239},{ 1622, 3372},{ 1719, 3528},
        { 1814, 3671},{ 1905, 3797},{ 1991, 3929},{ 2062, 4081},
        { 2151, 4215},{ 2243, 4341},{ 2322, 4483},{ 2410, 4697}
      },
      /*Cb  qi=38  INTER*/
      {
        {  154,   38},{  163,  356},{  170,  678},{  185, 1045},
        {  215, 1411},{  263, 1746},{  334, 2048},{  426, 2329},
        {  538, 2592},{  666, 2838},{  809, 3068},{  961, 3283},
        { 1120, 3486},{ 1289, 3675},{ 1470, 3849},{ 1670, 4004},
        { 1877, 4148},{ 2082, 4284},{ 2279, 4419},{ 2466, 4553},
        { 2650, 4695},{ 2836, 4851},{ 3021, 5011},{ 3207, 5170}
      }
    },
    {
      /*Cr  qi=38  INTRA*/
      {
        {   38,    7},{  182,  394},{  279,  785},{  348, 1195},
        {  438, 1550},{  544, 1842},{  653, 2096},{  761, 2308},
        {  878, 2487},{ 1000, 2656},{ 1134, 2815},{ 1270, 2955},
        { 1396, 3076},{ 1519, 3199},{ 1625, 3339},{ 1725, 3460},
        { 1831, 3557},{ 1927, 3670},{ 2005, 3792},{ 2080, 3919},
        { 2167, 4082},{ 2242, 4227},{ 2309, 4364},{ 2415, 4447}
      },
      /*Cr  qi=38  INTER*/
      {
        {  149,    6},{  159,  359},{  166,  686},{  182, 1052},
        {  213, 1414},{  255, 1748},{  309, 2064},{  387, 2363},
        {  497, 2632},{  636, 2872},{  794, 3089},{  968, 3283},
        { 1145, 3465},{ 1315, 3646},{ 1483, 3826},{ 1657, 4004},
        { 1826, 4180},{ 1998, 4346},{ 2188, 4490},{ 2391, 4610},
        { 2598, 4710},{ 2828, 4770},{ 3063, 4792},{ 3257, 4848}
      }
    }
  },
  {
    {
      /*Y'  qi=39  INTRA*/
      {
        {  234,   32},{  570, 1352},{ 1155, 2183},{ 1848, 2566},
        { 2495, 2831},{ 3133, 3119},{ 3755, 3440},{ 4337, 3764},
        { 4871, 4082},{ 5364, 4373},{ 5820, 4621},{ 6237, 4809},
        { 6626, 4966},{ 6987, 5146},{ 7346, 5340},{ 7699, 5527},
        { 8024, 5697},{ 8356, 5862},{ 8660, 6005},{ 8907, 6116},
        { 9150, 6230},{ 9408, 6342},{ 9665, 6449},{ 9941, 6627}
      },
      /*Y'  qi=39  INTER*/
      {
        {  206,    9},{  225, 1331},{  589, 2497},{ 1187, 3424},
        { 1909, 4172},{ 2688, 4807},{ 3514, 5326},{ 4376, 5666},
        { 5208, 5831},{ 5944, 5921},{ 6579, 6000},{ 7142, 6075},
        { 7653, 6140},{ 8120, 6197},{ 8556, 6247},{ 8965, 6288},
        { 9347, 6324},{ 9711, 6355},{10063, 6384},{10398, 6411},
        {10700, 6425},{10994, 6428},{11271, 6426},{11496, 6430}
      }
    },
    {
      /*Cb  qi=39  INTRA*/
      {
        {   29,    3},{  180,  373},{  292,  752},{  350, 1157},
        {  429, 1524},{  537, 1829},{  655, 2084},{  775, 2300},
        {  899, 2489},{ 1028, 2648},{ 1155, 2796},{ 1281, 2950},
        { 1410, 3093},{ 1525, 3226},{ 1629, 3360},{ 1728, 3513},
        { 1828, 3654},{ 1919, 3778},{ 2002, 3911},{ 2079, 4060},
        { 2169, 4191},{ 2260, 4320},{ 2340, 4457},{ 2413, 4674}
      },
      /*Cb  qi=39  INTER*/
      {
        {  164,   35},{  165,  355},{  169,  678},{  185, 1044},
        {  214, 1410},{  263, 1746},{  334, 2048},{  426, 2328},
        {  538, 2592},{  668, 2838},{  810, 3068},{  960, 3285},
        { 1118, 3487},{ 1288, 3676},{ 1470, 3850},{ 1667, 4007},
        { 1875, 4148},{ 2081, 4283},{ 2275, 4424},{ 2466, 4561},
        { 2652, 4698},{ 2832, 4853},{ 3015, 5008},{ 3186, 5172}
      }
    },
    {
      /*Cr  qi=39  INTRA*/
      {
        {   37,    7},{  182,  394},{  279,  785},{  348, 1195},
        {  438, 1549},{  544, 1840},{  655, 2093},{  766, 2302},
        {  883, 2481},{ 1005, 2650},{ 1138, 2809},{ 1272, 2949},
        { 1397, 3070},{ 1522, 3190},{ 1632, 3327},{ 1734, 3451},
        { 1843, 3549},{ 1938, 3659},{ 2017, 3775},{ 2095, 3895},
        { 2179, 4058},{ 2256, 4208},{ 2331, 4335},{ 2441, 4401}
      },
      /*Cr  qi=39  INTER*/
      {
        {  146,    9},{  157,  360},{  168,  686},{  182, 1052},
        {  212, 1413},{  254, 1747},{  309, 2064},{  388, 2363},
        {  496, 2632},{  634, 2872},{  795, 3087},{  968, 3281},
        { 1141, 3466},{ 1313, 3647},{ 1484, 3829},{ 1653, 4008},
        { 1822, 4183},{ 1995, 4354},{ 2188, 4499},{ 2386, 4617},
        { 2592, 4709},{ 2827, 4775},{ 3069, 4802},{ 3305, 4777}
      }
    }
  },
  {
    {
      /*Y'  qi=40  INTRA*/
      {
        {  226,   38},{  594, 1336},{ 1233, 2131},{ 1973, 2495},
        { 2656, 2748},{ 3319, 3025},{ 3962, 3342},{ 4560, 3665},
        { 5107, 3977},{ 5609, 4266},{ 6073, 4511},{ 6493, 4693},
        { 6886, 4846},{ 7253, 5021},{ 7610, 5214},{ 7964, 5399},
        { 8291, 5565},{ 8627, 5726},{ 8934, 5868},{ 9183, 5979},
        { 9427, 6092},{ 9685, 6201},{ 9953, 6304},{10248, 6484}
      },
      /*Y'  qi=40  INTER*/
      {
        {  217,   -2},{  233, 1327},{  661, 2461},{ 1337, 3353},
        { 2130, 4073},{ 2967, 4690},{ 3841, 5178},{ 4739, 5469},
        { 5581, 5606},{ 6311, 5693},{ 6944, 5771},{ 7510, 5843},
        { 8025, 5907},{ 8501, 5964},{ 8944, 6014},{ 9359, 6055},
        { 9752, 6088},{10124, 6122},{10477, 6148},{10807, 6163},
        {11117, 6175},{11411, 6185},{11686, 6188},{11943, 6192}
      }
    },
    {
      /*Cb  qi=40  INTRA*/
      {
        {   29,    2},{  183,  373},{  297,  751},{  362, 1148},
        {  450, 1502},{  570, 1792},{  698, 2035},{  829, 2240},
        {  961, 2422},{ 1097, 2579},{ 1226, 2727},{ 1356, 2883},
        { 1489, 3027},{ 1606, 3163},{ 1711, 3303},{ 1807, 3459},
        { 1907, 3600},{ 2005, 3724},{ 2088, 3858},{ 2163, 4007},
        { 2257, 4127},{ 2347, 4251},{ 2426, 4396},{ 2514, 4608}
      },
      /*Cb  qi=40  INTER*/
      {
        {  155,   41},{  164,  358},{  172,  678},{  190, 1042},
        {  226, 1401},{  286, 1728},{  373, 2020},{  487, 2289},
        {  620, 2542},{  768, 2779},{  930, 3000},{ 1099, 3206},
        { 1271, 3402},{ 1459, 3582},{ 1665, 3742},{ 1886, 3883},
        { 2110, 4012},{ 2330, 4144},{ 2536, 4284},{ 2735, 4419},
        { 2944, 4551},{ 3148, 4704},{ 3347, 4840},{ 3557, 4961}
      }
    },
    {
      /*Cr  qi=40  INTRA*/
      {
        {   37,    6},{  184,  394},{  283,  783},{  359, 1185},
        {  461, 1523},{  580, 1798},{  699, 2036},{  819, 2237},
        {  946, 2411},{ 1074, 2583},{ 1211, 2746},{ 1346, 2885},
        { 1474, 3006},{ 1602, 3130},{ 1714, 3272},{ 1819, 3390},
        { 1926, 3483},{ 2023, 3598},{ 2105, 3714},{ 2181, 3841},
        { 2265, 4009},{ 2341, 4150},{ 2415, 4273},{ 2521, 4361}
      },
      /*Cr  qi=40  INTER*/
      {
        {  151,   10},{  160,  359},{  169,  686},{  186, 1049},
        {  223, 1404},{  276, 1730},{  345, 2038},{  446, 2324},
        {  579, 2581},{  740, 2809},{  920, 3014},{ 1108, 3201},
        { 1299, 3378},{ 1485, 3556},{ 1663, 3737},{ 1848, 3910},
        { 2041, 4076},{ 2237, 4231},{ 2448, 4358},{ 2676, 4452},
        { 2912, 4519},{ 3154, 4562},{ 3406, 4570},{ 3671, 4526}
      }
    }
  },
  {
    {
      /*Y'  qi=41  INTRA*/
      {
        {  220,   40},{  608, 1331},{ 1268, 2118},{ 2027, 2472},
        { 2731, 2711},{ 3421, 2968},{ 4089, 3261},{ 4710, 3558},
        { 5280, 3842},{ 5800, 4103},{ 6277, 4326},{ 6709, 4490},
        { 7111, 4632},{ 7488, 4797},{ 7858, 4979},{ 8226, 5151},
        { 8570, 5308},{ 8922, 5458},{ 9244, 5585},{ 9501, 5682},
        { 9751, 5786},{10022, 5892},{10298, 5991},{10596, 6153}
      },
      /*Y'  qi=41  INTER*/
      {
        {  219,    0},{  234, 1327},{  696, 2445},{ 1417, 3313},
        { 2263, 4001},{ 3165, 4571},{ 4109, 4982},{ 5051, 5193},
        { 5899, 5292},{ 6626, 5368},{ 7262, 5435},{ 7836, 5495},
        { 8360, 5549},{ 8842, 5597},{ 9292, 5639},{ 9718, 5675},
        {10119, 5705},{10499, 5732},{10865, 5753},{11204, 5770},
        {11519, 5782},{11819, 5788},{12093, 5785},{12335, 5762}
      }
    },
    {
      /*Cb  qi=41  INTRA*/
      {
        {   30,    3},{  184,  373},{  299,  750},{  365, 1145},
        {  458, 1495},{  583, 1782},{  717, 2020},{  852, 2218},
        {  988, 2394},{ 1129, 2545},{ 1267, 2688},{ 1405, 2834},
        { 1542, 2972},{ 1659, 3107},{ 1769, 3242},{ 1874, 3395},
        { 1977, 3532},{ 2077, 3656},{ 2166, 3791},{ 2246, 3938},
        { 2345, 4055},{ 2440, 4161},{ 2522, 4293},{ 2617, 4505}
      },
      /*Cb  qi=41  INTER*/
      {
        {  146,   41},{  161,  357},{  174,  678},{  190, 1041},
        {  229, 1398},{  293, 1722},{  388, 2011},{  514, 2274},
        {  660, 2522},{  819, 2754},{  986, 2972},{ 1161, 3174},
        { 1348, 3360},{ 1549, 3531},{ 1767, 3684},{ 2002, 3817},
        { 2237, 3945},{ 2470, 4066},{ 2695, 4187},{ 2913, 4315},
        { 3129, 4450},{ 3349, 4574},{ 3581, 4689},{ 3807, 4801}
      }
    },
    {
      /*Cr  qi=41  INTRA*/
      {
        {   39,    7},{  185,  394},{  285,  783},{  364, 1181},
        {  470, 1516},{  591, 1789},{  716, 2022},{  841, 2218},
        {  973, 2386},{ 1107, 2551},{ 1250, 2707},{ 1392, 2842},
        { 1527, 2956},{ 1654, 3079},{ 1771, 3217},{ 1887, 3327},
        { 1995, 3418},{ 2094, 3525},{ 2187, 3631},{ 2270, 3753},
        { 2351, 3917},{ 2428, 4055},{ 2508, 4171},{ 2614, 4242}
      },
      /*Cr  qi=41  INTER*/
      {
        {  146,    9},{  159,  360},{  171,  686},{  188, 1048},
        {  226, 1401},{  283, 1724},{  360, 2028},{  471, 2310},
        {  616, 2562},{  787, 2786},{  976, 2985},{ 1175, 3164},
        { 1373, 3337},{ 1564, 3512},{ 1760, 3681},{ 1961, 3846},
        { 2163, 4007},{ 2381, 4143},{ 2611, 4253},{ 2851, 4332},
        { 3118, 4372},{ 3381, 4397},{ 3624, 4407},{ 3864, 4412}
      }
    }
  },
  {
    {
      /*Y'  qi=42  INTRA*/
      {
        {  258,   53},{  689, 1302},{ 1369, 2075},{ 2137, 2422},
        { 2859, 2650},{ 3570, 2897},{ 4256, 3184},{ 4892, 3478},
        { 5469, 3758},{ 5996, 4017},{ 6480, 4240},{ 6912, 4404},
        { 7322, 4544},{ 7708, 4707},{ 8079, 4886},{ 8450, 5058},
        { 8792, 5211},{ 9146, 5355},{ 9478, 5481},{ 9735, 5578},
        { 9985, 5673},{10259, 5775},{10536, 5872},{10851, 6033}
      },
      /*Y'  qi=42  INTER*/
      {
        {  212,    3},{  236, 1325},{  712, 2436},{ 1458, 3294},
        { 2324, 3974},{ 3239, 4539},{ 4195, 4939},{ 5141, 5141},
        { 5991, 5239},{ 6719, 5314},{ 7356, 5381},{ 7930, 5443},
        { 8456, 5498},{ 8944, 5547},{ 9396, 5586},{ 9819, 5617},
        {10224, 5650},{10608, 5680},{10971, 5700},{11317, 5717},
        {11640, 5726},{11942, 5728},{12217, 5731},{12468, 5725}
      }
    },
    {
      /*Cb  qi=42  INTRA*/
      {
        {   28,    3},{  194,  372},{  318,  747},{  395, 1133},
        {  499, 1475},{  635, 1753},{  780, 1984},{  925, 2176},
        { 1070, 2345},{ 1219, 2492},{ 1364, 2631},{ 1506, 2776},
        { 1646, 2913},{ 1769, 3048},{ 1877, 3186},{ 1980, 3341},
        { 2083, 3478},{ 2183, 3601},{ 2275, 3735},{ 2360, 3880},
        { 2461, 3998},{ 2551, 4110},{ 2637, 4241},{ 2738, 4445}
      },
      /*Cb  qi=42  INTER*/
      {
        {  148,   34},{  161,  353},{  174,  677},{  191, 1040},
        {  230, 1396},{  298, 1718},{  397, 2004},{  526, 2266},
        {  676, 2513},{  840, 2743},{ 1015, 2957},{ 1199, 3156},
        { 1392, 3339},{ 1599, 3507},{ 1822, 3658},{ 2063, 3788},
        { 2306, 3908},{ 2538, 4035},{ 2765, 4160},{ 2990, 4279},
        { 3212, 4407},{ 3443, 4532},{ 3685, 4637},{ 3903, 4746}
      }
    },
    {
      /*Cr  qi=42  INTRA*/
      {
        {   40,    7},{  196,  395},{  303,  781},{  394, 1168},
        {  514, 1490},{  645, 1757},{  780, 1983},{  913, 2172},
        { 1056, 2335},{ 1203, 2490},{ 1354, 2639},{ 1499, 2774},
        { 1634, 2894},{ 1762, 3019},{ 1880, 3153},{ 1996, 3267},
        { 2101, 3368},{ 2201, 3475},{ 2295, 3579},{ 2379, 3697},
        { 2462, 3858},{ 2540, 4000},{ 2625, 4121},{ 2743, 4206}
      },
      /*Cr  qi=42  INTER*/
      {
        {  142,    7},{  162,  358},{  171,  686},{  188, 1047},
        {  227, 1398},{  286, 1720},{  367, 2023},{  482, 2303},
        {  633, 2552},{  813, 2772},{ 1010, 2967},{ 1215, 3144},
        { 1415, 3316},{ 1612, 3488},{ 1815, 3658},{ 2020, 3819},
        { 2233, 3972},{ 2458, 4106},{ 2688, 4214},{ 2937, 4286},
        { 3196, 4330},{ 3462, 4349},{ 3723, 4350},{ 3958, 4352}
      }
    }
  },
  {
    {
      /*Y'  qi=43  INTRA*/
      {
        {  256,   55},{  695, 1296},{ 1396, 2053},{ 2187, 2394},
        { 2931, 2613},{ 3655, 2854},{ 4350, 3137},{ 4993, 3425},
        { 5574, 3700},{ 6101, 3953},{ 6590, 4174},{ 7025, 4335},
        { 7428, 4471},{ 7812, 4627},{ 8183, 4799},{ 8556, 4966},
        { 8902, 5117},{ 9258, 5258},{ 9589, 5381},{ 9848, 5478},
        {10099, 5570},{10368, 5666},{10647, 5766},{10965, 5934}
      },
      /*Y'  qi=43  INTER*/
      {
        {  214,    2},{  245, 1321},{  781, 2405},{ 1591, 3238},
        { 2506, 3906},{ 3461, 4455},{ 4455, 4815},{ 5416, 4982},
        { 6257, 5075},{ 6979, 5151},{ 7613, 5217},{ 8186, 5279},
        { 8712, 5333},{ 9200, 5380},{ 9657, 5418},{10086, 5449},
        {10493, 5479},{10879, 5509},{11240, 5530},{11584, 5543},
        {11909, 5552},{12209, 5555},{12485, 5556},{12717, 5549}
      }
    },
    {
      /*Cb  qi=43  INTRA*/
      {
        {   31,    3},{  198,  373},{  322,  746},{  403, 1125},
        {  514, 1456},{  653, 1725},{  801, 1950},{  950, 2138},
        { 1095, 2307},{ 1243, 2458},{ 1385, 2602},{ 1525, 2748},
        { 1668, 2884},{ 1789, 3022},{ 1897, 3164},{ 2001, 3317},
        { 2106, 3454},{ 2204, 3579},{ 2293, 3709},{ 2378, 3855},
        { 2482, 3974},{ 2580, 4082},{ 2669, 4214},{ 2765, 4427}
      },
      /*Cb  qi=43  INTER*/
      {
        {  174,   33},{  172,  353},{  175,  677},{  197, 1037},
        {  243, 1387},{  321, 1702},{  436, 1980},{  583, 2234},
        {  750, 2473},{  930, 2697},{ 1119, 2906},{ 1315, 3099},
        { 1525, 3275},{ 1749, 3434},{ 1990, 3574},{ 2240, 3701},
        { 2488, 3822},{ 2733, 3941},{ 2979, 4054},{ 3211, 4171},
        { 3439, 4295},{ 3680, 4417},{ 3926, 4518},{ 4173, 4645}
      }
    },
    {
      /*Cr  qi=43  INTRA*/
      {
        {   42,    7},{  199,  395},{  308,  780},{  404, 1159},
        {  528, 1470},{  662, 1726},{  799, 1947},{  937, 2133},
        { 1082, 2298},{ 1227, 2458},{ 1374, 2613},{ 1515, 2754},
        { 1654, 2873},{ 1783, 2995},{ 1899, 3132},{ 2016, 3243},
        { 2122, 3341},{ 2219, 3447},{ 2312, 3553},{ 2402, 3674},
        { 2491, 3830},{ 2566, 3965},{ 2645, 4089},{ 2748, 4190}
      },
      /*Cr  qi=43  INTER*/
      {
        {  143,    9},{  161,  359},{  172,  685},{  194, 1044},
        {  240, 1390},{  308, 1705},{  402, 2000},{  534, 2272},
        {  703, 2513},{  901, 2725},{ 1114, 2913},{ 1332, 3084},
        { 1547, 3253},{ 1756, 3422},{ 1970, 3588},{ 2186, 3749},
        { 2414, 3893},{ 2658, 4008},{ 2905, 4102},{ 3172, 4164},
        { 3445, 4190},{ 3721, 4193},{ 3984, 4182},{ 4236, 4159}
      }
    }
  },
  {
    {
      /*Y'  qi=44  INTRA*/
      {
        {  246,   58},{  719, 1291},{ 1460, 2040},{ 2282, 2374},
        { 3049, 2582},{ 3792, 2805},{ 4505, 3066},{ 5168, 3336},
        { 5771, 3589},{ 6319, 3821},{ 6824, 4027},{ 7270, 4177},
        { 7690, 4300},{ 8087, 4447},{ 8472, 4613},{ 8861, 4772},
        { 9222, 4912},{ 9593, 5041},{ 9934, 5155},{10202, 5245},
        {10468, 5328},{10751, 5418},{11036, 5509},{11366, 5659}
      },
      /*Y'  qi=44  INTER*/
      {
        {  209,    5},{  247, 1320},{  824, 2388},{ 1683, 3196},
        { 2649, 3835},{ 3667, 4338},{ 4711, 4634},{ 5689, 4762},
        { 6530, 4841},{ 7256, 4909},{ 7901, 4968},{ 8488, 5021},
        { 9026, 5066},{ 9523, 5106},{ 9989, 5140},{10433, 5167},
        {10850, 5194},{11238, 5218},{11616, 5237},{11970, 5252},
        {12292, 5258},{12598, 5259},{12886, 5260},{13140, 5252}
      }
    },
    {
      /*Cb  qi=44  INTRA*/
      {
        {   31,    3},{  198,  373},{  323,  746},{  406, 1124},
        {  523, 1452},{  670, 1717},{  825, 1933},{  980, 2113},
        { 1134, 2274},{ 1286, 2419},{ 1433, 2557},{ 1583, 2697},
        { 1730, 2829},{ 1853, 2966},{ 1965, 3107},{ 2079, 3254},
        { 2190, 3390},{ 2292, 3511},{ 2384, 3637},{ 2474, 3777},
        { 2586, 3890},{ 2684, 3997},{ 2774, 4126},{ 2901, 4310}
      },
      /*Cb  qi=44  INTER*/
      {
        {  163,   43},{  170,  357},{  176,  677},{  198, 1036},
        {  247, 1384},{  331, 1695},{  458, 1970},{  620, 2219},
        {  800, 2452},{  990, 2671},{ 1188, 2873},{ 1393, 3060},
        { 1611, 3231},{ 1849, 3380},{ 2103, 3515},{ 2363, 3640},
        { 2627, 3755},{ 2892, 3861},{ 3142, 3969},{ 3387, 4089},
        { 3645, 4194},{ 3907, 4294},{ 4163, 4378},{ 4403, 4434}
      }
    },
    {
      /*Cr  qi=44  INTRA*/
      {
        {   42,    7},{  199,  395},{  309,  779},{  409, 1157},
        {  539, 1465},{  678, 1717},{  822, 1931},{  967, 2109},
        { 1121, 2266},{ 1276, 2417},{ 1429, 2567},{ 1574, 2705},
        { 1720, 2820},{ 1856, 2938},{ 1977, 3069},{ 2097, 3178},
        { 2211, 3275},{ 2309, 3382},{ 2398, 3484},{ 2496, 3596},
        { 2595, 3743},{ 2671, 3877},{ 2758, 4002},{ 2875, 4110}
      },
      /*Cr  qi=44  INTER*/
      {
        {  147,    6},{  163,  358},{  172,  685},{  194, 1043},
        {  244, 1387},{  320, 1698},{  425, 1989},{  570, 2256},
        {  753, 2493},{  961, 2698},{ 1182, 2879},{ 1407, 3046},
        { 1631, 3211},{ 1853, 3373},{ 2077, 3534},{ 2310, 3685},
        { 2553, 3819},{ 2813, 3923},{ 3084, 3994},{ 3361, 4046},
        { 3644, 4065},{ 3923, 4063},{ 4185, 4058},{ 4441, 4046}
      }
    }
  },
  {
    {
      /*Y'  qi=45  INTRA*/
      {
        {  236,   61},{  736, 1283},{ 1501, 2022},{ 2342, 2352},
        { 3126, 2552},{ 3890, 2761},{ 4623, 3009},{ 5301, 3264},
        { 5920, 3504},{ 6480, 3725},{ 6993, 3920},{ 7444, 4059},
        { 7868, 4172},{ 8275, 4312},{ 8667, 4470},{ 9062, 4623},
        { 9431, 4760},{ 9805, 4881},{10147, 4986},{10416, 5067},
        {10678, 5143},{10958, 5229},{11247, 5318},{11586, 5474}
      },
      /*Y'  qi=45  INTER*/
      {
        {  204,    7},{  254, 1317},{  882, 2366},{ 1798, 3150},
        { 2820, 3763},{ 3887, 4229},{ 4965, 4483},{ 5952, 4590},
        { 6797, 4664},{ 7528, 4728},{ 8178, 4782},{ 8770, 4830},
        { 9316, 4876},{ 9822, 4914},{10290, 4942},{10728, 4966},
        {11146, 4987},{11533, 5006},{11903, 5021},{12253, 5028},
        {12568, 5022},{12870, 5020},{13147, 5017},{13358, 4994}
      }
    },
    {
      /*Cb  qi=45  INTRA*/
      {
        {   33,    3},{  201,  373},{  328,  745},{  419, 1119},
        {  545, 1441},{  702, 1699},{  869, 1907},{ 1037, 2078},
        { 1197, 2235},{ 1355, 2378},{ 1509, 2514},{ 1663, 2652},
        { 1815, 2780},{ 1945, 2913},{ 2063, 3054},{ 2181, 3203},
        { 2295, 3337},{ 2403, 3456},{ 2496, 3582},{ 2588, 3723},
        { 2713, 3826},{ 2815, 3929},{ 2904, 4054},{ 3037, 4230}
      },
      /*Cb  qi=45  INTER*/
      {
        {  165,   38},{  173,  355},{  181,  676},{  203, 1034},
        {  257, 1378},{  355, 1683},{  497, 1951},{  672, 2195},
        {  863, 2422},{ 1062, 2636},{ 1269, 2834},{ 1490, 3013},
        { 1725, 3177},{ 1978, 3320},{ 2251, 3443},{ 2529, 3557},
        { 2805, 3665},{ 3075, 3767},{ 3336, 3877},{ 3598, 3983},
        { 3862, 4066},{ 4130, 4159},{ 4399, 4252},{ 4675, 4334}
      }
    },
    {
      /*Cr  qi=45  INTRA*/
      {
        {   43,    8},{  201,  395},{  313,  778},{  420, 1151},
        {  559, 1454},{  709, 1701},{  865, 1906},{ 1024, 2076},
        { 1187, 2228},{ 1349, 2378},{ 1507, 2528},{ 1657, 2663},
        { 1808, 2778},{ 1945, 2898},{ 2069, 3023},{ 2194, 3124},
        { 2308, 3217},{ 2413, 3324},{ 2509, 3425},{ 2607, 3540},
        { 2711, 3686},{ 2794, 3810},{ 2883, 3925},{ 3017, 4008}
      },
      /*Cr  qi=45  INTER*/
      {
        {  149,    8},{  168,  359},{  176,  685},{  199, 1042},
        {  254, 1381},{  340, 1686},{  460, 1972},{  619, 2234},
        {  814, 2464},{ 1032, 2664},{ 1266, 2839},{ 1505, 3000},
        { 1745, 3157},{ 1980, 3318},{ 2214, 3475},{ 2466, 3611},
        { 2728, 3735},{ 2999, 3829},{ 3284, 3883},{ 3574, 3919},
        { 3864, 3921},{ 4150, 3911},{ 4408, 3915},{ 4629, 3949}
      }
    }
  },
  {
    {
      /*Y'  qi=46  INTRA*/
      {
        {  234,   66},{  742, 1278},{ 1538, 2007},{ 2425, 2326},
        { 3250, 2507},{ 4031, 2706},{ 4773, 2945},{ 5455, 3190},
        { 6073, 3423},{ 6638, 3640},{ 7157, 3829},{ 7609, 3965},
        { 8032, 4080},{ 8438, 4216},{ 8837, 4371},{ 9236, 4522},
        { 9606, 4654},{ 9985, 4773},{10329, 4878},{10597, 4957},
        {10865, 5029},{11146, 5110},{11432, 5194},{11752, 5335}
      },
      /*Y'  qi=46  INTER*/
      {
        {  199,    9},{  270, 1313},{ 1002, 2320},{ 2024, 3067},
        { 3120, 3660},{ 4247, 4085},{ 5356, 4290},{ 6339, 4383},
        { 7175, 4460},{ 7906, 4525},{ 8560, 4577},{ 9159, 4626},
        { 9711, 4671},{10224, 4705},{10707, 4737},{11164, 4767},
        {11593, 4792},{12000, 4814},{12382, 4832},{12739, 4844},
        {13074, 4848},{13379, 4846},{13661, 4844},{13914, 4841}
      }
    },
    {
      /*Cb  qi=46  INTRA*/
      {
        {   27,    2},{  202,  373},{  334,  744},{  431, 1108},
        {  566, 1418},{  729, 1667},{  901, 1869},{ 1075, 2036},
        { 1239, 2192},{ 1395, 2340},{ 1548, 2481},{ 1707, 2617},
        { 1863, 2744},{ 1993, 2880},{ 2112, 3021},{ 2230, 3166},
        { 2344, 3298},{ 2455, 3416},{ 2551, 3539},{ 2641, 3676},
        { 2760, 3784},{ 2866, 3886},{ 2965, 4005},{ 3115, 4174}
      },
      /*Cb  qi=46  INTER*/
      {
        {  171,    7},{  176,  356},{  185,  677},{  213, 1030},
        {  279, 1366},{  398, 1663},{  568, 1921},{  769, 2154},
        {  982, 2372},{ 1207, 2574},{ 1444, 2758},{ 1694, 2925},
        { 1963, 3073},{ 2245, 3204},{ 2539, 3322},{ 2835, 3431},
        { 3128, 3529},{ 3411, 3623},{ 3690, 3731},{ 3966, 3827},
        { 4241, 3909},{ 4523, 3995},{ 4803, 4082},{ 5080, 4164}
      }
    },
    {
      /*Cr  qi=46  INTRA*/
      {
        {   35,    6},{  200,  393},{  319,  775},{  434, 1137},
        {  581, 1427},{  737, 1664},{  901, 1862},{ 1066, 2030},
        { 1235, 2181},{ 1397, 2333},{ 1554, 2486},{ 1705, 2625},
        { 1858, 2738},{ 1995, 2861},{ 2115, 2991},{ 2238, 3092},
        { 2354, 3186},{ 2462, 3294},{ 2560, 3392},{ 2662, 3500},
        { 2773, 3643},{ 2859, 3769},{ 2948, 3883},{ 3085, 3977}
      },
      /*Cr  qi=46  INTER*/
      {
        {  160,    8},{  168,  359},{  180,  684},{  209, 1037},
        {  277, 1370},{  382, 1667},{  525, 1942},{  712, 2192},
        {  935, 2409},{ 1184, 2594},{ 1448, 2756},{ 1712, 2911},
        { 1971, 3066},{ 2228, 3219},{ 2487, 3368},{ 2758, 3498},
        { 3045, 3602},{ 3343, 3678},{ 3651, 3720},{ 3952, 3738},
        { 4248, 3740},{ 4530, 3728},{ 4791, 3728},{ 5043, 3721}
      }
    }
  },
  {
    {
      /*Y'  qi=47  INTRA*/
      {
        {  220,   69},{  768, 1271},{ 1601, 1990},{ 2516, 2299},
        { 3361, 2472},{ 4163, 2661},{ 4926, 2886},{ 5628, 3119},
        { 6264, 3342},{ 6844, 3546},{ 7378, 3724},{ 7843, 3857},
        { 8275, 3965},{ 8692, 4095},{ 9104, 4244},{ 9513, 4387},
        { 9892, 4512},{10280, 4626},{10630, 4723},{10908, 4796},
        {11191, 4862},{11477, 4938},{11764, 5015},{12113, 5150}
      },
      /*Y'  qi=47  INTER*/
      {
        {  200,    9},{  275, 1312},{ 1023, 2314},{ 2069, 3048},
        { 3200, 3622},{ 4364, 4013},{ 5491, 4189},{ 6477, 4272},
        { 7317, 4342},{ 8051, 4400},{ 8711, 4448},{ 9318, 4494},
        { 9878, 4533},{10399, 4565},{10882, 4594},{11344, 4621},
        {11780, 4643},{12185, 4662},{12571, 4674},{12934, 4687},
        {13269, 4691},{13579, 4692},{13874, 4695},{14155, 4701}
      }
    },
    {
      /*Cb  qi=47  INTRA*/
      {
        {   37,    3},{  207,  374},{  335,  743},{  434, 1106},
        {  573, 1412},{  740, 1657},{  915, 1855},{ 1091, 2020},
        { 1256, 2175},{ 1415, 2321},{ 1570, 2460},{ 1729, 2593},
        { 1888, 2718},{ 2021, 2853},{ 2141, 2991},{ 2263, 3132},
        { 2380, 3263},{ 2493, 3381},{ 2594, 3498},{ 2691, 3630},
        { 2807, 3735},{ 2908, 3831},{ 3011, 3940},{ 3173, 4090}
      },
      /*Cb  qi=47  INTER*/
      {
        {  171,   40},{  179,  357},{  188,  678},{  215, 1029},
        {  285, 1365},{  410, 1659},{  587, 1915},{  791, 2146},
        { 1005, 2363},{ 1229, 2563},{ 1471, 2744},{ 1729, 2908},
        { 2005, 3052},{ 2296, 3181},{ 2596, 3295},{ 2901, 3399},
        { 3200, 3495},{ 3491, 3587},{ 3784, 3693},{ 4066, 3780},
        { 4349, 3848},{ 4639, 3928},{ 4922, 4000},{ 5202, 4037}
      }
    },
    {
      /*Cr  qi=47  INTRA*/
      {
        {   48,    8},{  206,  395},{  321,  775},{  438, 1134},
        {  588, 1420},{  748, 1654},{  914, 1850},{ 1081, 2016},
        { 1250, 2166},{ 1416, 2315},{ 1576, 2466},{ 1727, 2603},
        { 1884, 2713},{ 2023, 2833},{ 2143, 2960},{ 2272, 3059},
        { 2394, 3149},{ 2502, 3253},{ 2601, 3350},{ 2703, 3454},
        { 2818, 3592},{ 2908, 3719},{ 2997, 3828},{ 3151, 3903}
      },
      /*Cr  qi=47  INTER*/
      {
        {  159,    8},{  169,  360},{  182,  684},{  211, 1036},
        {  282, 1367},{  394, 1663},{  544, 1936},{  734, 2185},
        {  958, 2400},{ 1207, 2583},{ 1472, 2744},{ 1742, 2897},
        { 2010, 3049},{ 2275, 3199},{ 2542, 3345},{ 2823, 3470},
        { 3122, 3565},{ 3429, 3632},{ 3740, 3672},{ 4049, 3682},
        { 4353, 3675},{ 4629, 3678},{ 4871, 3679},{ 5116, 3695}
      }
    }
  },
  {
    {
      /*Y'  qi=48  INTRA*/
      {
        {  198,   77},{  796, 1266},{ 1666, 1983},{ 2615, 2290},
        { 3492, 2446},{ 4314, 2616},{ 5095, 2823},{ 5816, 3036},
        { 6468, 3241},{ 7061, 3433},{ 7609, 3601},{ 8085, 3724},
        { 8523, 3823},{ 8950, 3945},{ 9373, 4086},{ 9788, 4223},
        {10177, 4339},{10574, 4442},{10932, 4528},{11215, 4591},
        {11491, 4649},{11779, 4718},{12081, 4786},{12431, 4903}
      },
      /*Y'  qi=48  INTER*/
      {
        {  188,   17},{  276, 1313},{ 1090, 2296},{ 2224, 2999},
        { 3439, 3536},{ 4663, 3879},{ 5813, 4018},{ 6802, 4091},
        { 7650, 4156},{ 8397, 4209},{ 9071, 4255},{ 9691, 4297},
        {10259, 4331},{10790, 4359},{11284, 4386},{11746, 4411},
        {12184, 4428},{12599, 4444},{12985, 4456},{13337, 4464},
        {13680, 4467},{14000, 4461},{14282, 4452},{14545, 4435}
      }
    },
    {
      /*Cb  qi=48  INTRA*/
      {
        {   35,    3},{  211,  373},{  345,  741},{  456, 1099},
        {  610, 1402},{  791, 1640},{  978, 1831},{ 1164, 1992},
        { 1336, 2145},{ 1502, 2290},{ 1664, 2426},{ 1833, 2553},
        { 2000, 2670},{ 2148, 2799},{ 2279, 2931},{ 2403, 3067},
        { 2531, 3192},{ 2649, 3308},{ 2755, 3419},{ 2860, 3542},
        { 2982, 3645},{ 3084, 3740},{ 3181, 3845},{ 3354, 3966}
      },
      /*Cb  qi=48  INTER*/
      {
        {  177,   56},{  187,  367},{  194,  680},{  222, 1026},
        {  296, 1356},{  431, 1644},{  622, 1894},{  843, 2120},
        { 1075, 2329},{ 1320, 2523},{ 1583, 2698},{ 1867, 2851},
        { 2169, 2985},{ 2479, 3107},{ 2797, 3218},{ 3116, 3314},
        { 3429, 3405},{ 3739, 3495},{ 4045, 3576},{ 4338, 3661},
        { 4629, 3739},{ 4934, 3799},{ 5236, 3853},{ 5497, 3900}
      }
    },
    {
      /*Cr  qi=48  INTRA*/
      {
        {   45,    7},{  210,  392},{  333,  770},{  464, 1125},
        {  627, 1411},{  798, 1644},{  975, 1834},{ 1152, 1992},
        { 1333, 2135},{ 1511, 2277},{ 1684, 2421},{ 1845, 2553},
        { 2004, 2662},{ 2150, 2778},{ 2285, 2898},{ 2422, 2988},
        { 2547, 3071},{ 2660, 3172},{ 2765, 3270},{ 2873, 3369},
        { 2988, 3498},{ 3082, 3621},{ 3180, 3725},{ 3302, 3813}
      },
      /*Cr  qi=48  INTER*/
      {
        {  158,   13},{  174,  367},{  183,  688},{  214, 1035},
        {  292, 1359},{  413, 1648},{  577, 1916},{  781, 2160},
        { 1019, 2373},{ 1288, 2550},{ 1578, 2703},{ 1872, 2847},
        { 2163, 2991},{ 2450, 3133},{ 2738, 3265},{ 3041, 3381},
        { 3364, 3465},{ 3693, 3512},{ 4019, 3535},{ 4330, 3547},
        { 4630, 3537},{ 4902, 3535},{ 5158, 3535},{ 5402, 3514}
      }
    }
  },
  {
    {
      /*Y'  qi=49  INTRA*/
      {
        {  199,   78},{  799, 1265},{ 1680, 1978},{ 2646, 2277},
        { 3534, 2424},{ 4361, 2584},{ 5146, 2780},{ 5871, 2985},
        { 6528, 3183},{ 7126, 3365},{ 7677, 3528},{ 8159, 3647},
        { 8598, 3744},{ 9026, 3863},{ 9456, 3998},{ 9880, 4130},
        {10274, 4242},{10674, 4345},{11036, 4430},{11321, 4487},
        {11601, 4540},{11894, 4606},{12197, 4671},{12539, 4771}
      },
      /*Y'  qi=49  INTER*/
      {
        {  178,   20},{  286, 1311},{ 1143, 2277},{ 2322, 2960},
        { 3585, 3471},{ 4845, 3781},{ 6005, 3901},{ 6994, 3969},
        { 7844, 4029},{ 8595, 4078},{ 9276, 4119},{ 9903, 4159},
        {10478, 4192},{11015, 4220},{11516, 4244},{11993, 4265},
        {12437, 4286},{12855, 4304},{13245, 4315},{13605, 4323},
        {13951, 4327},{14265, 4323},{14553, 4318},{14827, 4314}
      }
    },
    {
      /*Cb  qi=49  INTRA*/
      {
        {   41,    3},{  227,  373},{  367,  741},{  481, 1097},
        {  638, 1398},{  820, 1635},{ 1008, 1826},{ 1196, 1986},
        { 1369, 2139},{ 1536, 2283},{ 1699, 2419},{ 1869, 2542},
        { 2038, 2658},{ 2187, 2786},{ 2321, 2917},{ 2447, 3052},
        { 2572, 3174},{ 2694, 3284},{ 2799, 3398},{ 2907, 3523},
        { 3036, 3620},{ 3139, 3710},{ 3237, 3811},{ 3406, 3934}
      },
      /*Cb  qi=49  INTER*/
      {
        {  178,   60},{  189,  368},{  198,  680},{  226, 1025},
        {  307, 1352},{  453, 1637},{  656, 1884},{  882, 2107},
        { 1117, 2313},{ 1373, 2500},{ 1650, 2668},{ 1946, 2817},
        { 2259, 2946},{ 2580, 3062},{ 2910, 3169},{ 3242, 3264},
        { 3568, 3350},{ 3883, 3435},{ 4196, 3515},{ 4506, 3585},
        { 4817, 3651},{ 5134, 3716},{ 5414, 3767},{ 5657, 3799}
      }
    },
    {
      /*Cr  qi=49  INTRA*/
      {
        {   54,    7},{  226,  394},{  354,  771},{  488, 1124},
        {  654, 1408},{  826, 1639},{ 1006, 1828},{ 1185, 1985},
        { 1366, 2129},{ 1543, 2269},{ 1718, 2412},{ 1881, 2544},
        { 2039, 2650},{ 2188, 2762},{ 2327, 2879},{ 2463, 2971},
        { 2583, 3055},{ 2698, 3156},{ 2807, 3252},{ 2920, 3346},
        { 3039, 3470},{ 3137, 3591},{ 3234, 3695},{ 3355, 3773}
      },
      /*Cr  qi=49  INTER*/
      {
        {  170,   13},{  178,  368},{  186,  688},{  219, 1033},
        {  301, 1355},{  434, 1642},{  609, 1906},{  820, 2147},
        { 1065, 2353},{ 1343, 2524},{ 1644, 2672},{ 1953, 2813},
        { 2252, 2953},{ 2547, 3093},{ 2856, 3217},{ 3178, 3318},
        { 3509, 3394},{ 3841, 3441},{ 4170, 3455},{ 4490, 3460},
        { 4794, 3463},{ 5069, 3459},{ 5317, 3465},{ 5535, 3515}
      }
    }
  },
  {
    {
      /*Y'  qi=50  INTRA*/
      {
        {  189,   84},{  816, 1259},{ 1758, 1962},{ 2799, 2241},
        { 3735, 2370},{ 4584, 2527},{ 5384, 2716},{ 6117, 2907},
        { 6781, 3091},{ 7387, 3264},{ 7944, 3416},{ 8430, 3527},
        { 8873, 3619},{ 9303, 3729},{ 9744, 3856},{10179, 3981},
        {10578, 4088},{10985, 4183},{11348, 4259},{11640, 4311},
        {11930, 4363},{12228, 4425},{12541, 4484},{12905, 4581}
      },
      /*Y'  qi=50  INTER*/
      {
        {  162,   24},{  316, 1305},{ 1302, 2227},{ 2595, 2882},
        { 3947, 3364},{ 5262, 3617},{ 6426, 3712},{ 7407, 3782},
        { 8257, 3843},{ 9011, 3889},{ 9698, 3930},{10329, 3966},
        {10911, 3997},{11456, 4025},{11962, 4048},{12437, 4069},
        {12885, 4085},{13308, 4100},{13708, 4114},{14077, 4122},
        {14414, 4126},{14740, 4127},{15029, 4125},{15307, 4117}
      }
    },
    {
      /*Cb  qi=50  INTRA*/
      {
        {   42,    3},{  233,  374},{  376,  739},{  497, 1086},
        {  665, 1374},{  855, 1601},{ 1051, 1784},{ 1249, 1938},
        { 1431, 2088},{ 1599, 2235},{ 1764, 2373},{ 1938, 2495},
        { 2113, 2606},{ 2270, 2726},{ 2410, 2853},{ 2538, 2985},
        { 2667, 3105},{ 2795, 3211},{ 2899, 3320},{ 3009, 3440},
        { 3136, 3532},{ 3244, 3620},{ 3354, 3712},{ 3506, 3807}
      },
      /*Cb  qi=50  INTER*/
      {
        {  177,   58},{  191,  368},{  204,  680},{  245, 1019},
        {  347, 1338},{  524, 1613},{  760, 1848},{ 1015, 2058},
        { 1277, 2252},{ 1563, 2429},{ 1875, 2585},{ 2206, 2724},
        { 2548, 2846},{ 2895, 2954},{ 3242, 3050},{ 3588, 3137},
        { 3932, 3212},{ 4272, 3279},{ 4590, 3361},{ 4903, 3430},
        { 5225, 3476},{ 5529, 3526},{ 5816, 3566},{ 6057, 3612}
      }
    },
    {
      /*Cr  qi=50  INTRA*/
      {
        {   54,    7},{  230,  394},{  362,  767},{  505, 1109},
        {  678, 1382},{  859, 1603},{ 1049, 1782},{ 1240, 1934},
        { 1429, 2076},{ 1613, 2217},{ 1790, 2359},{ 1955, 2489},
        { 2114, 2597},{ 2263, 2709},{ 2408, 2821},{ 2554, 2905},
        { 2680, 2982},{ 2799, 3081},{ 2907, 3178},{ 3015, 3265},
        { 3145, 3384},{ 3251, 3508},{ 3349, 3609},{ 3474, 3679}
      },
      /*Cr  qi=50  INTER*/
      {
        {  165,   13},{  181,  369},{  191,  687},{  237, 1027},
        {  343, 1340},{  505, 1617},{  707, 1871},{  945, 2101},
        { 1221, 2294},{ 1534, 2454},{ 1867, 2594},{ 2198, 2732},
        { 2522, 2869},{ 2851, 2999},{ 3179, 3114},{ 3526, 3196},
        { 3887, 3248},{ 4235, 3272},{ 4564, 3277},{ 4880, 3273},
        { 5179, 3269},{ 5427, 3277},{ 5666, 3261},{ 5927, 3230}
      }
    }
  },
  {
    {
      /*Y'  qi=51  INTRA*/
      {
        {  177,   88},{  843, 1254},{ 1819, 1948},{ 2894, 2216},
        { 3850, 2334},{ 4717, 2482},{ 5531, 2659},{ 6276, 2837},
        { 6951, 3012},{ 7570, 3175},{ 8137, 3319},{ 8632, 3423},
        { 9083, 3513},{ 9518, 3625},{ 9965, 3746},{10404, 3864},
        {10807, 3967},{11222, 4056},{11593, 4134},{11886, 4187},
        {12178, 4232},{12481, 4291},{12801, 4351},{13171, 4448}
      },
      /*Y'  qi=51  INTER*/
      {
        {  154,   27},{  327, 1302},{ 1401, 2196},{ 2781, 2825},
        { 4202, 3268},{ 5558, 3479},{ 6732, 3559},{ 7722, 3622},
        { 8584, 3678},{ 9352, 3722},{10049, 3758},{10691, 3791},
        {11284, 3821},{11839, 3848},{12353, 3870},{12840, 3890},
        {13299, 3909},{13730, 3923},{14142, 3936},{14503, 3942},
        {14857, 3948},{15199, 3952},{15475, 3946},{15738, 3942}
      }
    },
    {
      /*Cb  qi=51  INTRA*/
      {
        {   43,    3},{  236,  374},{  382,  737},{  510, 1079},
        {  686, 1360},{  884, 1581},{ 1087, 1759},{ 1292, 1909},
        { 1478, 2057},{ 1648, 2206},{ 1815, 2344},{ 1992, 2464},
        { 2169, 2570},{ 2324, 2689},{ 2463, 2819},{ 2592, 2952},
        { 2724, 3068},{ 2849, 3176},{ 2955, 3285},{ 3073, 3399},
        { 3203, 3492},{ 3303, 3586},{ 3409, 3673},{ 3588, 3746}
      },
      /*Cb  qi=51  INTER*/
      {
        {  176,   16},{  193,  367},{  205,  679},{  250, 1017},
        {  364, 1331},{  559, 1600},{  814, 1828},{ 1091, 2030},
        { 1378, 2217},{ 1687, 2387},{ 2026, 2536},{ 2382, 2666},
        { 2742, 2782},{ 3101, 2886},{ 3459, 2977},{ 3820, 3051},
        { 4172, 3120},{ 4515, 3184},{ 4859, 3250},{ 5181, 3315},
        { 5502, 3367},{ 5826, 3408},{ 6125, 3442},{ 6438, 3475}
      }
    },
    {
      /*Cr  qi=51  INTRA*/
      {
        {   54,    7},{  231,  394},{  367,  765},{  519, 1101},
        {  699, 1367},{  888, 1580},{ 1087, 1754},{ 1284, 1903},
        { 1478, 2043},{ 1664, 2182},{ 1846, 2321},{ 2014, 2453},
        { 2169, 2563},{ 2320, 2674},{ 2466, 2787},{ 2604, 2873},
        { 2730, 2952},{ 2851, 3050},{ 2958, 3147},{ 3067, 3234},
        { 3199, 3350},{ 3304, 3472},{ 3401, 3564},{ 3535, 3591}
      },
      /*Cr  qi=51  INTER*/
      {
        {  175,   17},{  181,  370},{  193,  687},{  242, 1024},
        {  360, 1333},{  537, 1604},{  758, 1852},{ 1019, 2073},
        { 1323, 2258},{ 1665, 2409},{ 2021, 2544},{ 2367, 2679},
        { 2709, 2810},{ 3054, 2933},{ 3407, 3031},{ 3767, 3098},
        { 4129, 3142},{ 4480, 3165},{ 4806, 3172},{ 5117, 3161},
        { 5410, 3153},{ 5681, 3160},{ 5934, 3153},{ 6166, 3158}
      }
    }
  },
  {
    {
      /*Y'  qi=52  INTRA*/
      {
        {  170,   90},{  857, 1253},{ 1862, 1943},{ 2960, 2206},
        { 3932, 2318},{ 4810, 2459},{ 5634, 2626},{ 6390, 2797},
        { 7075, 2966},{ 7703, 3123},{ 8282, 3264},{ 8785, 3366},
        { 9240, 3452},{ 9677, 3560},{10133, 3677},{10583, 3792},
        {10992, 3892},{11404, 3975},{11771, 4046},{12062, 4095},
        {12357, 4136},{12672, 4193},{12995, 4247},{13374, 4339}
      },
      /*Y'  qi=52  INTER*/
      {
        {  146,   29},{  348, 1300},{ 1460, 2181},{ 2882, 2793},
        { 4359, 3205},{ 5746, 3387},{ 6926, 3456},{ 7921, 3514},
        { 8794, 3563},{ 9573, 3601},{10281, 3635},{10935, 3667},
        {11537, 3694},{12100, 3716},{12627, 3737},{13120, 3756},
        {13580, 3771},{14019, 3784},{14437, 3796},{14807, 3803},
        {15160, 3807},{15502, 3809},{15791, 3807},{16106, 3809}
      }
    },
    {
      /*Cb  qi=52  INTRA*/
      {
        {   47,    4},{  239,  374},{  384,  737},{  515, 1077},
        {  693, 1356},{  895, 1575},{ 1101, 1752},{ 1309, 1900},
        { 1498, 2047},{ 1672, 2194},{ 1843, 2331},{ 2025, 2447},
        { 2207, 2553},{ 2367, 2670},{ 2511, 2792},{ 2646, 2921},
        { 2777, 3036},{ 2904, 3140},{ 3010, 3246},{ 3133, 3354},
        { 3269, 3445},{ 3369, 3533},{ 3475, 3614},{ 3661, 3683}
      },
      /*Cb  qi=52  INTER*/
      {
        {  175,   12},{  192,  367},{  208,  679},{  257, 1016},
        {  385, 1327},{  597, 1593},{  862, 1818},{ 1140, 2018},
        { 1427, 2202},{ 1740, 2370},{ 2086, 2515},{ 2457, 2640},
        { 2832, 2751},{ 3204, 2850},{ 3580, 2935},{ 3951, 3006},
        { 4316, 3067},{ 4669, 3128},{ 5013, 3188},{ 5360, 3240},
        { 5690, 3289},{ 6006, 3323},{ 6309, 3356},{ 6615, 3404}
      }
    },
    {
      /*Cr  qi=52  INTRA*/
      {
        {   60,    8},{  235,  395},{  369,  764},{  523, 1099},
        {  707, 1364},{  900, 1574},{ 1102, 1745},{ 1301, 1894},
        { 1501, 2033},{ 1688, 2171},{ 1873, 2307},{ 2051, 2431},
        { 2213, 2539},{ 2365, 2651},{ 2515, 2762},{ 2659, 2842},
        { 2788, 2912},{ 2911, 3008},{ 3017, 3105},{ 3128, 3189},
        { 3262, 3305},{ 3370, 3423},{ 3478, 3509},{ 3608, 3550}
      },
      /*Cr  qi=52  INTER*/
      {
        {  164,   14},{  180,  368},{  195,  687},{  249, 1022},
        {  378, 1329},{  573, 1597},{  805, 1842},{ 1066, 2062},
        { 1371, 2243},{ 1719, 2389},{ 2084, 2521},{ 2445, 2652},
        { 2804, 2779},{ 3161, 2895},{ 3526, 2986},{ 3904, 3047},
        { 4278, 3081},{ 4632, 3097},{ 4970, 3102},{ 5282, 3092},
        { 5572, 3083},{ 5839, 3081},{ 6078, 3076},{ 6334, 3081}
      }
    }
  },
  {
    {
      /*Y'  qi=53  INTRA*/
      {
        {  150,   94},{  911, 1240},{ 1970, 1915},{ 3099, 2163},
        { 4097, 2259},{ 5008, 2377},{ 5869, 2521},{ 6665, 2671},
        { 7387, 2819},{ 8047, 2956},{ 8650, 3080},{ 9175, 3168},
        { 9649, 3245},{10108, 3344},{10592, 3448},{11062, 3550},
        {11490, 3634},{11924, 3705},{12303, 3767},{12603, 3808},
        {12907, 3841},{13236, 3888},{13570, 3931},{13962, 3987}
      },
      /*Y'  qi=53  INTER*/
      {
        {  136,   29},{  354, 1297},{ 1530, 2157},{ 3034, 2733},
        { 4576, 3099},{ 5979, 3248},{ 7154, 3308},{ 8152, 3357},
        { 9030, 3402},{ 9814, 3436},{10528, 3465},{11188, 3492},
        {11797, 3515},{12371, 3537},{12907, 3556},{13406, 3571},
        {13876, 3586},{14327, 3599},{14753, 3610},{15134, 3615},
        {15499, 3621},{15849, 3624},{16142, 3623},{16375, 3620}
      }
    },
    {
      /*Cb  qi=53  INTRA*/
      {
        {   49,    4},{  243,  374},{  391,  734},{  536, 1071},
        {  732, 1347},{  948, 1561},{ 1171, 1731},{ 1394, 1872},
        { 1599, 2010},{ 1784, 2149},{ 1968, 2277},{ 2164, 2383},
        { 2356, 2478},{ 2527, 2586},{ 2682, 2701},{ 2828, 2820},
        { 2966, 2927},{ 3096, 3029},{ 3214, 3133},{ 3353, 3220},
        { 3500, 3296},{ 3617, 3384},{ 3738, 3459},{ 3930, 3511}
      },
      /*Cb  qi=53  INTER*/
      {
        {  173,   15},{  195,  365},{  210,  678},{  262, 1013},
        {  395, 1321},{  615, 1584},{  892, 1805},{ 1185, 2000},
        { 1490, 2178},{ 1823, 2338},{ 2190, 2474},{ 2574, 2594},
        { 2963, 2698},{ 3350, 2789},{ 3736, 2867},{ 4122, 2931},
        { 4499, 2988},{ 4870, 3041},{ 5224, 3091},{ 5569, 3134},
        { 5901, 3174},{ 6208, 3206},{ 6513, 3238},{ 6852, 3284}
      }
    },
    {
      /*Cr  qi=53  INTRA*/
      {
        {   62,    8},{  239,  394},{  380,  761},{  546, 1092},
        {  747, 1351},{  959, 1553},{ 1180, 1715},{ 1393, 1856},
        { 1604, 1989},{ 1807, 2117},{ 2008, 2242},{ 2193, 2360},
        { 2355, 2470},{ 2521, 2576},{ 2687, 2673},{ 2834, 2746},
        { 2969, 2809},{ 3104, 2899},{ 3220, 2994},{ 3337, 3072},
        { 3483, 3170},{ 3600, 3280},{ 3710, 3363},{ 3840, 3399}
      },
      /*Cr  qi=53  INTER*/
      {
        {  166,   14},{  184,  369},{  197,  686},{  254, 1019},
        {  389, 1323},{  590, 1589},{  832, 1831},{ 1109, 2046},
        { 1434, 2221},{ 1801, 2361},{ 2183, 2486},{ 2558, 2609},
        { 2932, 2730},{ 3312, 2833},{ 3695, 2914},{ 4084, 2969},
        { 4459, 2993},{ 4818, 3001},{ 5156, 3000},{ 5458, 2998},
        { 5745, 2987},{ 6002, 2978},{ 6251, 2973},{ 6482, 2956}
      }
    }
  },
  {
    {
      /*Y'  qi=54  INTRA*/
      {
        {  129,  101},{  972, 1233},{ 2105, 1899},{ 3305, 2128},
        { 4341, 2205},{ 5272, 2311},{ 6155, 2441},{ 6970, 2579},
        { 7707, 2717},{ 8381, 2848},{ 8997, 2967},{ 9524, 3052},
        { 9999, 3126},{10468, 3217},{10958, 3313},{11431, 3412},
        {11867, 3494},{12311, 3560},{12696, 3616},{13000, 3652},
        {13314, 3686},{13646, 3733},{13983, 3770},{14389, 3817}
      },
      /*Y'  qi=54  INTER*/
      {
        {   95,   36},{  412, 1289},{ 1752, 2102},{ 3399, 2637},
        { 5048, 2946},{ 6495, 3054},{ 7689, 3106},{ 8710, 3152},
        { 9611, 3191},{10415, 3221},{11144, 3248},{11817, 3272},
        {12439, 3294},{13021, 3312},{13565, 3329},{14078, 3343},
        {14561, 3354},{15027, 3365},{15459, 3372},{15848, 3380},
        {16226, 3386},{16574, 3387},{16878, 3383},{17133, 3368}
      }
    },
    {
      /*Cb  qi=54  INTRA*/
      {
        {   52,    4},{  251,  374},{  403,  732},{  557, 1061},
        {  765, 1327},{  990, 1535},{ 1220, 1701},{ 1454, 1838},
        { 1666, 1974},{ 1855, 2113},{ 2042, 2240},{ 2244, 2345},
        { 2440, 2435},{ 2614, 2538},{ 2777, 2648},{ 2925, 2763},
        { 3064, 2871},{ 3198, 2969},{ 3317, 3069},{ 3457, 3162},
        { 3610, 3234},{ 3726, 3314},{ 3846, 3383},{ 4052, 3419}
      },
      /*Cb  qi=54  INTER*/
      {
        {  180,   18},{  195,  366},{  215,  677},{  287, 1006},
        {  459, 1305},{  728, 1556},{ 1040, 1766},{ 1361, 1949},
        { 1702, 2115},{ 2077, 2261},{ 2486, 2387},{ 2911, 2496},
        { 3335, 2589},{ 3751, 2667},{ 4168, 2730},{ 4578, 2783},
        { 4975, 2827},{ 5356, 2869},{ 5712, 2913},{ 6069, 2955},
        { 6414, 2986},{ 6725, 3011},{ 7032, 3037},{ 7371, 3065}
      }
    },
    {
      /*Cr  qi=54  INTRA*/
      {
        {   68,    9},{  246,  394},{  390,  757},{  569, 1079},
        {  779, 1329},{  999, 1525},{ 1230, 1682},{ 1454, 1820},
        { 1673, 1950},{ 1883, 2076},{ 2088, 2199},{ 2277, 2316},
        { 2442, 2422},{ 2610, 2524},{ 2778, 2617},{ 2930, 2685},
        { 3066, 2746},{ 3201, 2833},{ 3318, 2925},{ 3437, 3004},
        { 3587, 3094},{ 3708, 3197},{ 3823, 3291},{ 3950, 3342}
      },
      /*Cr  qi=54  INTER*/
      {
        {  167,   13},{  188,  370},{  203,  685},{  277, 1012},
        {  451, 1307},{  696, 1562},{  972, 1793},{ 1283, 1995},
        { 1653, 2154},{ 2068, 2281},{ 2490, 2398},{ 2906, 2513},
        { 3320, 2620},{ 3730, 2709},{ 4141, 2772},{ 4548, 2806},
        { 4928, 2823},{ 5279, 2827},{ 5617, 2820},{ 5930, 2810},
        { 6217, 2798},{ 6475, 2794},{ 6722, 2797},{ 6968, 2809}
      }
    }
  },
  {
    {
      /*Y'  qi=55  INTRA*/
      {
        {  114,  103},{ 1030, 1222},{ 2214, 1873},{ 3445, 2091},
        { 4497, 2158},{ 5448, 2250},{ 6354, 2365},{ 7196, 2488},
        { 7964, 2612},{ 8662, 2729},{ 9301, 2834},{ 9845, 2904},
        {10335, 2970},{10825, 3052},{11337, 3138},{11833, 3228},
        {12288, 3301},{12746, 3357},{13143, 3407},{13462, 3437},
        {13781, 3463},{14124, 3503},{14483, 3535},{14916, 3572}
      },
      /*Y'  qi=55  INTER*/
      {
        {   90,   37},{  420, 1287},{ 1844, 2073},{ 3585, 2565},
        { 5291, 2829},{ 6746, 2915},{ 7941, 2958},{ 8970, 2996},
        { 9881, 3029},{10698, 3055},{11440, 3077},{12126, 3097},
        {12758, 3115},{13349, 3132},{13905, 3145},{14431, 3156},
        {14928, 3167},{15414, 3179},{15863, 3188},{16269, 3194},
        {16654, 3198},{17018, 3201},{17353, 3201},{17692, 3202}
      }
    },
    {
      /*Cb  qi=55  INTRA*/
      {
        {   51,    4},{  252,  374},{  411,  732},{  580, 1060},
        {  808, 1322},{ 1056, 1523},{ 1308, 1681},{ 1561, 1811},
        { 1789, 1941},{ 1990, 2074},{ 2189, 2195},{ 2405, 2293},
        { 2615, 2379},{ 2804, 2477},{ 2977, 2580},{ 3132, 2689},
        { 3285, 2788},{ 3431, 2883},{ 3570, 2974},{ 3725, 3048},
        { 3882, 3116},{ 4014, 3194},{ 4152, 3259},{ 4367, 3289}
      },
      /*Cb  qi=55  INTER*/
      {
        {  197,   15},{  199,  365},{  220,  676},{  290, 1004},
        {  472, 1300},{  755, 1547},{ 1087, 1751},{ 1431, 1927},
        { 1794, 2084},{ 2188, 2223},{ 2613, 2341},{ 3054, 2442},
        { 3494, 2528},{ 3925, 2601},{ 4358, 2658},{ 4778, 2697},
        { 5178, 2730},{ 5563, 2770},{ 5939, 2803},{ 6298, 2826},
        { 6633, 2855},{ 6967, 2885},{ 7278, 2904},{ 7597, 2943}
      }
    },
    {
      /*Cr  qi=55  INTRA*/
      {
        {   66,    8},{  248,  394},{  401,  758},{  596, 1078},
        {  825, 1324},{ 1066, 1512},{ 1317, 1662},{ 1559, 1794},
        { 1797, 1918},{ 2020, 2039},{ 2234, 2154},{ 2435, 2264},
        { 2614, 2367},{ 2791, 2466},{ 2971, 2552},{ 3134, 2616},
        { 3277, 2670},{ 3429, 2750},{ 3561, 2838},{ 3688, 2911},
        { 3844, 2990},{ 3976, 3084},{ 4104, 3168},{ 4243, 3212}
      },
      /*Cr  qi=55  INTER*/
      {
        {  167,   13},{  189,  369},{  205,  684},{  281, 1010},
        {  463, 1303},{  722, 1554},{ 1016, 1779},{ 1350, 1973},
        { 1741, 2125},{ 2175, 2244},{ 2617, 2356},{ 3054, 2462},
        { 3489, 2556},{ 3922, 2633},{ 4344, 2687},{ 4743, 2717},
        { 5126, 2726},{ 5477, 2724},{ 5810, 2716},{ 6117, 2709},
        { 6387, 2703},{ 6667, 2699},{ 6928, 2698},{ 7217, 2712}
      }
    }
  },
  {
    {
      /*Y'  qi=56  INTRA*/
      {
        {  100,  108},{ 1066, 1219},{ 2311, 1862},{ 3587, 2070},
        { 4665, 2128},{ 5635, 2212},{ 6559, 2319},{ 7414, 2435},
        { 8195, 2551},{ 8909, 2664},{ 9556, 2762},{10103, 2827},
        {10602, 2888},{11106, 2966},{11626, 3048},{12127, 3132},
        {12585, 3201},{13058, 3252},{13469, 3297},{13783, 3325},
        {14108, 3349},{14456, 3386},{14813, 3414},{15235, 3445}
      },
      /*Y'  qi=56  INTER*/
      {
        {   30,   38},{  479, 1282},{ 1966, 2045},{ 3780, 2511},
        { 5536, 2746},{ 7005, 2817},{ 8211, 2855},{ 9255, 2889},
        {10178, 2918},{10999, 2940},{11743, 2958},{12424, 2975},
        {13044, 2990},{13623, 3003},{14166, 3013},{14678, 3023},
        {15160, 3032},{15623, 3042},{16066, 3049},{16473, 3052},
        {16854, 3055},{17214, 3056},{17540, 3056},{17843, 3064}
      }
    },
    {
      /*Cb  qi=56  INTRA*/
      {
        {   54,    4},{  257,  374},{  417,  731},{  593, 1054},
        {  829, 1310},{ 1085, 1506},{ 1345, 1660},{ 1604, 1785},
        { 1837, 1911},{ 2044, 2041},{ 2247, 2160},{ 2463, 2255},
        { 2678, 2336},{ 2873, 2428},{ 3053, 2526},{ 3213, 2633},
        { 3368, 2729},{ 3514, 2821},{ 3652, 2907},{ 3813, 2979},
        { 3981, 3040},{ 4120, 3110},{ 4257, 3175},{ 4472, 3208}
      },
      /*Cb  qi=56  INTER*/
      {
        {  188,   14},{  202,  365},{  225,  676},{  317, 1000},
        {  532, 1290},{  832, 1531},{ 1163, 1732},{ 1510, 1903},
        { 1888, 2055},{ 2306, 2187},{ 2758, 2298},{ 3229, 2391},
        { 3691, 2473},{ 4136, 2539},{ 4575, 2587},{ 5002, 2622},
        { 5406, 2648},{ 5786, 2678},{ 6155, 2712},{ 6518, 2740},
        { 6856, 2759},{ 7167, 2779},{ 7488, 2802},{ 7779, 2811}
      }
    },
    {
      /*Cr  qi=56  INTRA*/
      {
        {   71,    9},{  253,  394},{  406,  756},{  608, 1071},
        {  845, 1310},{ 1095, 1493},{ 1355, 1639},{ 1603, 1767},
        { 1845, 1888},{ 2073, 2004},{ 2290, 2116},{ 2493, 2222},
        { 2682, 2321},{ 2864, 2416},{ 3044, 2499},{ 3210, 2557},
        { 3358, 2611},{ 3514, 2688},{ 3650, 2770},{ 3783, 2842},
        { 3938, 2916},{ 4069, 3004},{ 4208, 3086},{ 4355, 3132}
      },
      /*Cr  qi=56  INTER*/
      {
        {  176,   13},{  195,  370},{  215,  683},{  307, 1006},
        {  518, 1292},{  794, 1538},{ 1090, 1761},{ 1430, 1950},
        { 1840, 2094},{ 2298, 2210},{ 2765, 2314},{ 3228, 2414},
        { 3685, 2504},{ 4135, 2571},{ 4566, 2614},{ 4967, 2640},
        { 5345, 2644},{ 5696, 2637},{ 6018, 2631},{ 6322, 2624},
        { 6608, 2619},{ 6883, 2619},{ 7141, 2621},{ 7428, 2636}
      }
    }
  },
  {
    {
      /*Y'  qi=57  INTRA*/
      {
        {   86,  110},{ 1103, 1215},{ 2392, 1848},{ 3703, 2040},
        { 4797, 2082},{ 5787, 2154},{ 6733, 2245},{ 7613, 2343},
        { 8419, 2442},{ 9155, 2537},{ 9823, 2622},{10388, 2676},
        {10904, 2726},{11431, 2793},{11973, 2863},{12495, 2934},
        {12972, 2996},{13455, 3040},{13882, 3075},{14210, 3097},
        {14555, 3117},{14926, 3146},{15297, 3166},{15747, 3188}
      },
      /*Y'  qi=57  INTER*/
      {
        {   17,   44},{  498, 1277},{ 2101, 2010},{ 4024, 2434},
        { 5848, 2624},{ 7342, 2674},{ 8568, 2702},{ 9629, 2726},
        {10566, 2747},{11398, 2763},{12148, 2777},{12834, 2790},
        {13460, 2801},{14048, 2811},{14594, 2820},{15109, 2828},
        {15596, 2836},{16066, 2841},{16509, 2845},{16929, 2849},
        {17329, 2851},{17704, 2853},{18061, 2857},{18404, 2860}
      }
    },
    {
      /*Cb  qi=57  INTRA*/
      {
        {   54,    4},{  260,  375},{  427,  730},{  617, 1048},
        {  870, 1298},{ 1140, 1489},{ 1414, 1637},{ 1693, 1753},
        { 1943, 1871},{ 2164, 1997},{ 2384, 2110},{ 2618, 2197},
        { 2844, 2271},{ 3051, 2355},{ 3246, 2446},{ 3425, 2547},
        { 3595, 2636},{ 3751, 2719},{ 3903, 2796},{ 4081, 2855},
        { 4263, 2906},{ 4413, 2967},{ 4572, 3027},{ 4789, 3061}
      },
      /*Cb  qi=57  INTER*/
      {
        {  191,   12},{  203,  367},{  226,  676},{  324,  997},
        {  553, 1282},{  878, 1516},{ 1240, 1709},{ 1618, 1873},
        { 2022, 2018},{ 2466, 2143},{ 2948, 2245},{ 3444, 2332},
        { 3926, 2404},{ 4387, 2460},{ 4832, 2497},{ 5266, 2522},
        { 5679, 2542},{ 6075, 2561},{ 6466, 2591},{ 6828, 2617},
        { 7160, 2636},{ 7495, 2659},{ 7824, 2676},{ 8152, 2706}
      }
    },
    {
      /*Cr  qi=57  INTRA*/
      {
        {   71,    9},{  256,  395},{  417,  755},{  633, 1064},
        {  885, 1297},{ 1149, 1474},{ 1429, 1612},{ 1697, 1735},
        { 1956, 1849},{ 2201, 1959},{ 2430, 2065},{ 2646, 2165},
        { 2846, 2258},{ 3041, 2346},{ 3238, 2418},{ 3418, 2468},
        { 3573, 2518},{ 3737, 2586},{ 3892, 2660},{ 4041, 2725},
        { 4207, 2793},{ 4363, 2873},{ 4516, 2944},{ 4667, 2986}
      },
      /*Cr  qi=57  INTER*/
      {
        {  172,   15},{  194,  369},{  217,  682},{  315, 1002},
        {  540, 1283},{  840, 1523},{ 1167, 1737},{ 1542, 1917},
        { 1988, 2053},{ 2472, 2163},{ 2962, 2263},{ 3447, 2355},
        { 3924, 2430},{ 4390, 2485},{ 4825, 2521},{ 5232, 2536},
        { 5612, 2537},{ 5962, 2529},{ 6287, 2521},{ 6592, 2513},
        { 6878, 2510},{ 7161, 2509},{ 7436, 2507},{ 7687, 2514}
      }
    }
  },
  {
    {
      /*Y'  qi=58  INTRA*/
      {
        {   95,  113},{ 1165, 1212},{ 2480, 1835},{ 3807, 2017},
        { 4906, 2052},{ 5908, 2115},{ 6876, 2199},{ 7781, 2289},
        { 8612, 2381},{ 9368, 2469},{10051, 2545},{10629, 2593},
        {11161, 2639},{11702, 2701},{12256, 2764},{12795, 2829},
        {13289, 2885},{13789, 2924},{14229, 2957},{14568, 2979},
        {14920, 2996},{15303, 3022},{15683, 3038},{16122, 3056}
      },
      /*Y'  qi=58  INTER*/
      {
        {  -18,   46},{  535, 1272},{ 2219, 1981},{ 4234, 2364},
        { 6111, 2520},{ 7619, 2556},{ 8858, 2576},{ 9934, 2594},
        {10882, 2610},{11720, 2622},{12477, 2633},{13167, 2643},
        {13794, 2651},{14385, 2660},{14934, 2667},{15455, 2673},
        {15959, 2680},{16434, 2684},{16882, 2688},{17302, 2692},
        {17715, 2696},{18099, 2697},{18453, 2695},{18778, 2694}
      }
    },
    {
      /*Cb  qi=58  INTRA*/
      {
        {   54,    4},{  260,  375},{  428,  729},{  620, 1047},
        {  874, 1295},{ 1147, 1484},{ 1425, 1630},{ 1708, 1743},
        { 1963, 1858},{ 2191, 1980},{ 2417, 2088},{ 2658, 2170},
        { 2892, 2240},{ 3105, 2319},{ 3307, 2403},{ 3493, 2499},
        { 3668, 2586},{ 3832, 2666},{ 3993, 2738},{ 4180, 2790},
        { 4370, 2836},{ 4524, 2894},{ 4683, 2947},{ 4899, 2976}
      },
      /*Cb  qi=58  INTER*/
      {
        {  177,   11},{  204,  363},{  231,  674},{  338,  994},
        {  589, 1275},{  929, 1507},{ 1296, 1697},{ 1683, 1857},
        { 2104, 1995},{ 2573, 2111},{ 3085, 2206},{ 3607, 2284},
        { 4111, 2347},{ 4589, 2391},{ 5048, 2417},{ 5484, 2435},
        { 5892, 2452},{ 6298, 2473},{ 6691, 2489},{ 7071, 2512},
        { 7419, 2526},{ 7759, 2534},{ 8104, 2555},{ 8359, 2558}
      }
    },
    {
      /*Cr  qi=58  INTRA*/
      {
        {   70,    9},{  256,  395},{  418,  755},{  636, 1063},
        {  889, 1295},{ 1156, 1469},{ 1441, 1605},{ 1713, 1724},
        { 1978, 1834},{ 2231, 1939},{ 2467, 2039},{ 2688, 2135},
        { 2893, 2225},{ 3096, 2310},{ 3301, 2379},{ 3479, 2426},
        { 3638, 2470},{ 3814, 2531},{ 3974, 2601},{ 4122, 2666},
        { 4288, 2730},{ 4456, 2802},{ 4616, 2871},{ 4771, 2908}
      },
      /*Cr  qi=58  INTER*/
      {
        {  177,   13},{  196,  368},{  219,  682},{  329,  999},
        {  573, 1277},{  887, 1514},{ 1222, 1725},{ 1609, 1900},
        { 2074, 2030},{ 2584, 2132},{ 3103, 2224},{ 3617, 2305},
        { 4112, 2371},{ 4591, 2413},{ 5034, 2436},{ 5444, 2450},
        { 5823, 2447},{ 6169, 2436},{ 6506, 2430},{ 6818, 2423},
        { 7099, 2421},{ 7379, 2419},{ 7632, 2415},{ 7887, 2427}
      }
    }
  },
  {
    {
      /*Y'  qi=59  INTRA*/
      {
        {   77,  118},{ 1211, 1206},{ 2606, 1813},{ 3987, 1974},
        { 5104, 1996},{ 6120, 2050},{ 7101, 2124},{ 8017, 2205},
        { 8864, 2288},{ 9640, 2368},{10337, 2439},{10924, 2485},
        {11464, 2528},{12016, 2583},{12584, 2641},{13134, 2702},
        {13634, 2755},{14139, 2791},{14586, 2819},{14935, 2839},
        {15293, 2855},{15680, 2880},{16067, 2895},{16497, 2916}
      },
      /*Y'  qi=59  INTER*/
      {
        {  -97,   52},{  615, 1265},{ 2448, 1926},{ 4597, 2262},
        { 6529, 2387},{ 8051, 2415},{ 9307, 2430},{10397, 2444},
        {11355, 2456},{12199, 2465},{12962, 2472},{13659, 2479},
        {14294, 2486},{14890, 2493},{15450, 2499},{15975, 2503},
        {16478, 2509},{16958, 2513},{17413, 2516},{17838, 2520},
        {18260, 2521},{18653, 2521},{19009, 2521},{19314, 2518}
      }
    },
    {
      /*Cb  qi=59  INTRA*/
      {
        {   57,    4},{  268,  375},{  442,  727},{  644, 1037},
        {  911, 1277},{ 1196, 1461},{ 1484, 1603},{ 1777, 1710},
        { 2040, 1820},{ 2273, 1940},{ 2509, 2045},{ 2755, 2123},
        { 2992, 2188},{ 3211, 2264},{ 3415, 2346},{ 3607, 2436},
        { 3787, 2518},{ 3956, 2595},{ 4123, 2666},{ 4314, 2716},
        { 4506, 2758},{ 4679, 2809},{ 4842, 2859},{ 5040, 2887}
      },
      /*Cb  qi=59  INTER*/
      {
        {  206,   13},{  214,  364},{  248,  673},{  387,  987},
        {  670, 1261},{ 1029, 1483},{ 1425, 1663},{ 1854, 1810},
        { 2319, 1936},{ 2832, 2041},{ 3382, 2125},{ 3931, 2197},
        { 4457, 2250},{ 4945, 2284},{ 5403, 2306},{ 5846, 2319},
        { 6267, 2332},{ 6673, 2345},{ 7073, 2364},{ 7440, 2380},
        { 7801, 2397},{ 8163, 2409},{ 8496, 2415},{ 8729, 2411}
      }
    },
    {
      /*Cr  qi=59  INTRA*/
      {
        {   76,   10},{  261,  397},{  428,  753},{  657, 1053},
        {  922, 1277},{ 1204, 1445},{ 1501, 1575},{ 1782, 1690},
        { 2054, 1797},{ 2312, 1898},{ 2553, 1996},{ 2777, 2091},
        { 2989, 2179},{ 3200, 2259},{ 3409, 2322},{ 3588, 2366},
        { 3745, 2409},{ 3928, 2465},{ 4100, 2533},{ 4256, 2597},
        { 4424, 2654},{ 4587, 2720},{ 4753, 2783},{ 4918, 2813}
      },
      /*Cr  qi=59  INTER*/
      {
        {  179,   12},{  204,  368},{  234,  680},{  374,  993},
        {  650, 1263},{  983, 1492},{ 1344, 1694},{ 1776, 1856},
        { 2289, 1973},{ 2846, 2064},{ 3401, 2146},{ 3943, 2218},
        { 4462, 2272},{ 4941, 2305},{ 5382, 2322},{ 5794, 2329},
        { 6170, 2328},{ 6513, 2316},{ 6831, 2309},{ 7127, 2307},
        { 7424, 2308},{ 7726, 2310},{ 7981, 2305},{ 8214, 2307}
      }
    }
  },
  {
    {
      /*Y'  qi=60  INTRA*/
      {
        {   79,  120},{ 1292, 1198},{ 2759, 1784},{ 4168, 1930},
        { 5290, 1944},{ 6327, 1987},{ 7340, 2048},{ 8296, 2114},
        { 9182, 2180},{ 9993, 2245},{10718, 2303},{11331, 2338},
        {11896, 2369},{12474, 2412},{13067, 2459},{13645, 2507},
        {14171, 2553},{14697, 2583},{15169, 2602},{15533, 2614},
        {15907, 2626},{16321, 2646},{16736, 2658},{17204, 2683}
      },
      /*Y'  qi=60  INTER*/
      {
        { -152,   60},{  668, 1259},{ 2600, 1890},{ 4845, 2186},
        { 6826, 2281},{ 8373, 2295},{ 9654, 2299},{10764, 2303},
        {11734, 2307},{12588, 2310},{13359, 2312},{14068, 2315},
        {14714, 2318},{15316, 2321},{15883, 2323},{16421, 2327},
        {16931, 2330},{17412, 2330},{17873, 2331},{18305, 2334},
        {18723, 2335},{19134, 2335},{19493, 2334},{19833, 2338}
      }
    },
    {
      /*Cb  qi=60  INTRA*/
      {
        {   57,    4},{  274,  375},{  460,  727},{  688, 1035},
        {  991, 1271},{ 1311, 1448},{ 1629, 1580},{ 1948, 1676},
        { 2237, 1776},{ 2501, 1883},{ 2768, 1975},{ 3041, 2041},
        { 3303, 2096},{ 3548, 2163},{ 3782, 2235},{ 4007, 2313},
        { 4211, 2383},{ 4407, 2450},{ 4595, 2511},{ 4801, 2552},
        { 5014, 2580},{ 5210, 2615},{ 5386, 2660},{ 5575, 2707}
      },
      /*Cb  qi=60  INTER*/
      {
        {  205,   11},{  219,  362},{  258,  671},{  422,  982},
        {  728, 1252},{ 1099, 1470},{ 1504, 1645},{ 1950, 1786},
        { 2442, 1904},{ 2985, 2001},{ 3565, 2079},{ 4138, 2143},
        { 4670, 2188},{ 5160, 2212},{ 5624, 2225},{ 6074, 2233},
        { 6503, 2238},{ 6918, 2248},{ 7343, 2261},{ 7740, 2269},
        { 8098, 2280},{ 8455, 2291},{ 8792, 2296},{ 9110, 2311}
      }
    },
    {
      /*Cr  qi=60  INTRA*/
      {
        {   76,   10},{  268,  396},{  449,  751},{  710, 1047},
        { 1009, 1268},{ 1321, 1431},{ 1646, 1553},{ 1956, 1658},
        { 2258, 1752},{ 2549, 1842},{ 2822, 1930},{ 3076, 2013},
        { 3314, 2086},{ 3549, 2154},{ 3780, 2203},{ 3977, 2240},
        { 4152, 2280},{ 4347, 2328},{ 4531, 2388},{ 4702, 2438},
        { 4886, 2485},{ 5069, 2540},{ 5245, 2595},{ 5431, 2626}
      },
      /*Cr  qi=60  INTER*/
      {
        {  190,   10},{  216,  366},{  247,  678},{  406,  988},
        {  706, 1254},{ 1052, 1478},{ 1426, 1674},{ 1880, 1829},
        { 2423, 1938},{ 3009, 2023},{ 3594, 2096},{ 4157, 2158},
        { 4685, 2204},{ 5171, 2229},{ 5615, 2239},{ 6019, 2240},
        { 6395, 2238},{ 6737, 2232},{ 7045, 2224},{ 7359, 2218},
        { 7648, 2217},{ 7929, 2212},{ 8197, 2210},{ 8324, 2206}
      }
    }
  },
  {
    {
      /*Y'  qi=61  INTRA*/
      {
        {  151,  132},{ 1420, 1188},{ 2960, 1744},{ 4401, 1874},
        { 5526, 1881},{ 6583, 1914},{ 7630, 1960},{ 8628, 2009},
        { 9560, 2057},{10413, 2103},{11184, 2144},{11827, 2167},
        {12420, 2187},{13035, 2218},{13663, 2251},{14277, 2288},
        {14839, 2325},{15391, 2346},{15880, 2356},{16265, 2364},
        {16665, 2372},{17107, 2386},{17537, 2393},{18014, 2419}
      },
      /*Y'  qi=61  INTER*/
      {
        { -211,   68},{  714, 1252},{ 2759, 1850},{ 5090, 2104},
        { 7114, 2170},{ 8687, 2171},{ 9997, 2164},{11137, 2158},
        {12139, 2154},{13026, 2149},{13826, 2146},{14560, 2144},
        {15240, 2142},{15879, 2141},{16473, 2140},{17037, 2140},
        {17568, 2139},{18077, 2137},{18561, 2136},{19019, 2136},
        {19467, 2137},{19886, 2136},{20271, 2135},{20658, 2137}
      }
    },
    {
      /*Cb  qi=61  INTRA*/
      {
        {   52,    4},{  273,  374},{  469,  726},{  718, 1030},
        { 1036, 1261},{ 1370, 1431},{ 1709, 1553},{ 2050, 1638},
        { 2365, 1726},{ 2661, 1820},{ 2953, 1899},{ 3246, 1954},
        { 3527, 1998},{ 3796, 2053},{ 4049, 2115},{ 4289, 2182},
        { 4515, 2243},{ 4746, 2297},{ 4956, 2345},{ 5166, 2377},
        { 5392, 2396},{ 5602, 2426},{ 5797, 2465},{ 6007, 2505}
      },
      /*Cb  qi=61  INTER*/
      {
        {  195,   12},{  218,  359},{  258,  669},{  431,  979},
        {  756, 1245},{ 1153, 1457},{ 1585, 1626},{ 2054, 1760},
        { 2569, 1870},{ 3138, 1959},{ 3738, 2031},{ 4325, 2086},
        { 4865, 2122},{ 5368, 2139},{ 5848, 2147},{ 6307, 2150},
        { 6752, 2151},{ 7182, 2157},{ 7616, 2166},{ 8027, 2168},
        { 8408, 2174},{ 8789, 2185},{ 9148, 2186},{ 9552, 2191}
      }
    },
    {
      /*Cr  qi=61  INTRA*/
      {
        {   71,    9},{  269,  395},{  463,  749},{  743, 1041},
        { 1054, 1256},{ 1380, 1412},{ 1726, 1525},{ 2058, 1619},
        { 2385, 1704},{ 2698, 1783},{ 2999, 1858},{ 3282, 1927},
        { 3538, 1990},{ 3789, 2046},{ 4033, 2083},{ 4247, 2112},
        { 4437, 2144},{ 4649, 2186},{ 4857, 2233},{ 5038, 2275},
        { 5231, 2319},{ 5444, 2360},{ 5643, 2396},{ 5856, 2402}
      },
      /*Cr  qi=61  INTER*/
      {
        {  182,   11},{  213,  364},{  247,  677},{  415,  985},
        {  735, 1247},{ 1107, 1466},{ 1508, 1655},{ 1991, 1801},
        { 2558, 1903},{ 3165, 1981},{ 3770, 2047},{ 4348, 2099},
        { 4885, 2131},{ 5382, 2148},{ 5832, 2159},{ 6244, 2163},
        { 6618, 2156},{ 6956, 2149},{ 7279, 2145},{ 7598, 2142},
        { 7900, 2139},{ 8193, 2136},{ 8471, 2136},{ 8674, 2148}
      }
    }
  },
  {
    {
      /*Y'  qi=62  INTRA*/
      {
        {  212,  140},{ 1522, 1182},{ 3130, 1716},{ 4593, 1835},
        { 5717, 1837},{ 6787, 1865},{ 7859, 1904},{ 8888, 1946},
        { 9847, 1987},{10727, 2026},{11526, 2060},{12190, 2079},
        {12807, 2094},{13442, 2118},{14095, 2146},{14735, 2176},
        {15318, 2208},{15889, 2228},{16397, 2238},{16802, 2242},
        {17221, 2248},{17683, 2261},{18137, 2267},{18658, 2281}
      },
      /*Y'  qi=62  INTER*/
      {
        { -316,   78},{  799, 1240},{ 2994, 1795},{ 5432, 2010},
        { 7508, 2055},{ 9112, 2049},{10456, 2037},{11634, 2027},
        {12673, 2019},{13595, 2013},{14436, 2007},{15205, 2003},
        {15915, 2000},{16587, 1999},{17214, 1996},{17813, 1995},
        {18382, 1994},{18929, 1992},{19448, 1990},{19927, 1989},
        {20389, 1988},{20829, 1987},{21237, 1987},{21680, 1987}
      }
    },
    {
      /*Cb  qi=62  INTRA*/
      {
        {   49,    4},{  277,  374},{  486,  724},{  756, 1024},
        { 1095, 1249},{ 1451, 1413},{ 1813, 1529},{ 2175, 1607},
        { 2508, 1688},{ 2826, 1774},{ 3137, 1846},{ 3445, 1896},
        { 3737, 1936},{ 4017, 1986},{ 4290, 2041},{ 4552, 2099},
        { 4789, 2154},{ 5024, 2202},{ 5243, 2246},{ 5471, 2275},
        { 5706, 2292},{ 5914, 2317},{ 6119, 2348},{ 6348, 2368}
      },
      /*Cb  qi=62  INTER*/
      {
        {  192,    9},{  221,  357},{  266,  667},{  454,  974},
        {  819, 1231},{ 1256, 1434},{ 1720, 1594},{ 2219, 1720},
        { 2763, 1820},{ 3362, 1901},{ 3994, 1963},{ 4605, 2010},
        { 5163, 2039},{ 5673, 2054},{ 6161, 2059},{ 6635, 2056},
        { 7087, 2055},{ 7538, 2057},{ 7986, 2059},{ 8400, 2061},
        { 8816, 2062},{ 9215, 2070},{ 9567, 2075},{ 9845, 2067}
      }
    },
    {
      /*Cr  qi=62  INTRA*/
      {
        {   72,   10},{  274,  397},{  482,  747},{  784, 1033},
        { 1113, 1244},{ 1462, 1394},{ 1831, 1499},{ 2184, 1587},
        { 2527, 1665},{ 2858, 1738},{ 3175, 1808},{ 3472, 1871},
        { 3747, 1927},{ 4020, 1977},{ 4271, 2010},{ 4490, 2036},
        { 4689, 2063},{ 4905, 2099},{ 5122, 2141},{ 5315, 2182},
        { 5514, 2222},{ 5732, 2258},{ 5948, 2294},{ 6134, 2309}
      },
      /*Cr  qi=62  INTER*/
      {
        {  191,   12},{  219,  363},{  254,  675},{  441,  979},
        {  796, 1233},{ 1207, 1444},{ 1646, 1623},{ 2161, 1758},
        { 2759, 1852},{ 3402, 1920},{ 4039, 1976},{ 4641, 2017},
        { 5193, 2043},{ 5697, 2059},{ 6155, 2066},{ 6571, 2067},
        { 6944, 2065},{ 7280, 2061},{ 7617, 2056},{ 7921, 2051},
        { 8215, 2050},{ 8528, 2050},{ 8834, 2045},{ 9092, 2042}
      }
    }
  },
  {
    {
      /*Y'  qi=63  INTRA*/
      {
        {  189,  144},{ 1625, 1169},{ 3329, 1679},{ 4820, 1783},
        { 5949, 1778},{ 7038, 1796},{ 8150, 1821},{ 9231, 1847},
        {10239, 1873},{11165, 1896},{12008, 1915},{12714, 1922},
        {13364, 1928},{14032, 1942},{14719, 1959},{15400, 1979},
        {16023, 1998},{16624, 2011},{17158, 2017},{17589, 2018},
        {18034, 2018},{18533, 2025},{19024, 2028},{19594, 2037}
      },
      /*Y'  qi=63  INTER*/
      {
        { -370,   83},{  845, 1235},{ 3132, 1766},{ 5639, 1953},
        { 7759, 1979},{ 9395, 1961},{10771, 1939},{11982, 1920},
        {13057, 1905},{14013, 1892},{14885, 1881},{15690, 1873},
        {16431, 1865},{17127, 1858},{17777, 1853},{18396, 1847},
        {18986, 1843},{19560, 1839},{20099, 1834},{20609, 1831},
        {21083, 1830},{21530, 1828},{21962, 1828},{22387, 1829}
      }
    },
    {
      /*Cb  qi=63  INTRA*/
      {
        {   50,    4},{  279,  374},{  496,  723},{  795, 1017},
        { 1170, 1235},{ 1557, 1392},{ 1947, 1497},{ 2340, 1564},
        { 2714, 1630},{ 3071, 1700},{ 3421, 1757},{ 3757, 1795},
        { 4077, 1822},{ 4389, 1859},{ 4691, 1901},{ 4987, 1944},
        { 5261, 1984},{ 5523, 2020},{ 5767, 2058},{ 6010, 2077},
        { 6255, 2086},{ 6494, 2102},{ 6730, 2121},{ 6950, 2148}
      },
      /*Cb  qi=63  INTER*/
      {
        {  193,   11},{  220,  356},{  263,  667},{  459,  972},
        {  846, 1226},{ 1313, 1425},{ 1801, 1580},{ 2314, 1700},
        { 2871, 1796},{ 3485, 1872},{ 4132, 1928},{ 4757, 1969},
        { 5322, 1993},{ 5843, 2004},{ 6342, 2005},{ 6830, 2000},
        { 7302, 1994},{ 7775, 1991},{ 8227, 1989},{ 8660, 1985},
        { 9087, 1983},{ 9484, 1984},{ 9870, 1980},{10254, 1985}
      }
    },
    {
      /*Cr  qi=63  INTRA*/
      {
        {   70,    9},{  277,  395},{  498,  743},{  826, 1023},
        { 1189, 1227},{ 1569, 1371},{ 1968, 1468},{ 2351, 1545},
        { 2726, 1608},{ 3094, 1666},{ 3449, 1719},{ 3783, 1767},
        { 4093, 1812},{ 4389, 1849},{ 4658, 1872},{ 4895, 1890},
        { 5120, 1910},{ 5354, 1937},{ 5585, 1972},{ 5805, 2002},
        { 6034, 2035},{ 6276, 2064},{ 6515, 2084},{ 6707, 2081}
      },
      /*Cr  qi=63  INTER*/
      {
        {  187,   12},{  215,  363},{  252,  675},{  448,  977},
        {  828, 1227},{ 1272, 1432},{ 1734, 1606},{ 2265, 1736},
        { 2877, 1825},{ 3533, 1890},{ 4183, 1940},{ 4798, 1975},
        { 5362, 1996},{ 5876, 2007},{ 6343, 2013},{ 6757, 2013},
        { 7133, 2009},{ 7483, 2005},{ 7809, 2000},{ 8132, 1997},
        { 8440, 1994},{ 8752, 1990},{ 9050, 1987},{ 9270, 1989}
      }
    }
  }
};

#endif
