/* Automatically generated by gendispatch.pl.
 * Do not edit this file.  Any changes you make will be lost.
 */
static int remoteDispatchAuthList(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_auth_list_ret *ret);
static int remoteDispatchAuthListHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchAuthList(server, client, hdr, rerr, ret);
}
/* remoteDispatchAuthList body has to be implemented manually */



static int remoteDispatchAuthPolkit(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_auth_polkit_ret *ret);
static int remoteDispatchAuthPolkitHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchAuthPolkit(server, client, hdr, rerr, ret);
}
/* remoteDispatchAuthPolkit body has to be implemented manually */



static int remoteDispatchAuthSaslInit(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_auth_sasl_init_ret *ret);
static int remoteDispatchAuthSaslInitHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchAuthSaslInit(server, client, hdr, rerr, ret);
}
/* remoteDispatchAuthSaslInit body has to be implemented manually */



static int remoteDispatchAuthSaslStart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_auth_sasl_start_args *args,
    remote_auth_sasl_start_ret *ret);
static int remoteDispatchAuthSaslStartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchAuthSaslStart(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchAuthSaslStart body has to be implemented manually */



static int remoteDispatchAuthSaslStep(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_auth_sasl_step_args *args,
    remote_auth_sasl_step_ret *ret);
static int remoteDispatchAuthSaslStepHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchAuthSaslStep(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchAuthSaslStep body has to be implemented manually */



static int remoteDispatchClose(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr);
static int remoteDispatchCloseHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchClose(server, client, hdr, rerr);
}
/* remoteDispatchClose body has to be implemented manually */



static int remoteDispatchCPUBaseline(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_cpu_baseline_args *args,
    remote_cpu_baseline_ret *ret);
static int remoteDispatchCPUBaselineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchCPUBaseline(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchCPUBaseline(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_cpu_baseline_args *args,
    remote_cpu_baseline_ret *ret)
{
    int rv = -1;
    char *cpu;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((cpu = virConnectBaselineCPU(priv->conn, (const char **) args->xmlCPUs.xmlCPUs_val, args->xmlCPUs.xmlCPUs_len, args->flags)) == NULL)
        goto cleanup;

    ret->cpu = cpu;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchCPUCompare(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_cpu_compare_args *args,
    remote_cpu_compare_ret *ret);
static int remoteDispatchCPUCompareHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchCPUCompare(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchCPUCompare(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_cpu_compare_args *args,
    remote_cpu_compare_ret *ret)
{
    int rv = -1;
    int result;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((result = virConnectCompareCPU(priv->conn, args->xml, args->flags)) == VIR_CPU_COMPARE_ERROR)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainAbortJob(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_abort_job_args *args);
static int remoteDispatchDomainAbortJobHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainAbortJob(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainAbortJob(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_abort_job_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainAbortJob(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainAttachDevice(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_attach_device_args *args);
static int remoteDispatchDomainAttachDeviceHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainAttachDevice(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainAttachDevice(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_attach_device_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainAttachDevice(dom, args->xml) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainAttachDeviceFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_attach_device_flags_args *args);
static int remoteDispatchDomainAttachDeviceFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainAttachDeviceFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainAttachDeviceFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_attach_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainAttachDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainBlockJobAbort(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_block_job_abort_args *args);
static int remoteDispatchDomainBlockJobAbortHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainBlockJobAbort(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainBlockJobAbort(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_job_abort_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainBlockJobAbort(dom, args->path, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainBlockJobSetSpeed(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_block_job_set_speed_args *args);
static int remoteDispatchDomainBlockJobSetSpeedHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainBlockJobSetSpeed(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainBlockJobSetSpeed(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_job_set_speed_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainBlockJobSetSpeed(dom, args->path, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainBlockPeek(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_block_peek_args *args,
    remote_domain_block_peek_ret *ret);
static int remoteDispatchDomainBlockPeekHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainBlockPeek(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainBlockPeek body has to be implemented manually */



static int remoteDispatchDomainBlockPull(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_block_pull_args *args);
static int remoteDispatchDomainBlockPullHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainBlockPull(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainBlockPull(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_pull_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainBlockPull(dom, args->path, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainBlockStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_block_stats_args *args,
    remote_domain_block_stats_ret *ret);
static int remoteDispatchDomainBlockStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainBlockStats(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainBlockStats(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_block_stats_args *args,
    remote_domain_block_stats_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainBlockStatsStruct tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainBlockStats(dom, args->path, &tmp, sizeof tmp) < 0)
        goto cleanup;

    ret->rd_req = tmp.rd_req;
    ret->rd_bytes = tmp.rd_bytes;
    ret->wr_req = tmp.wr_req;
    ret->wr_bytes = tmp.wr_bytes;
    ret->errs = tmp.errs;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainCoreDump(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_core_dump_args *args);
static int remoteDispatchDomainCoreDumpHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainCoreDump(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainCoreDump(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_core_dump_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainCoreDump(dom, args->to, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainCreate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_create_args *args);
static int remoteDispatchDomainCreateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainCreate(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainCreate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_create_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainCreate(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainCreateWithFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_create_with_flags_args *args,
    remote_domain_create_with_flags_ret *ret);
static int remoteDispatchDomainCreateWithFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainCreateWithFlags(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainCreateWithFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_create_with_flags_args *args,
    remote_domain_create_with_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainCreateWithFlags(dom, args->flags) < 0)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_create_xml_args *args,
    remote_domain_create_xml_ret *ret);
static int remoteDispatchDomainCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainCreateXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_create_xml_args *args,
    remote_domain_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainCreateXML(priv->conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_define_xml_args *args,
    remote_domain_define_xml_ret *ret);
static int remoteDispatchDomainDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainDefineXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_define_xml_args *args,
    remote_domain_define_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainDefineXML(priv->conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_destroy_args *args);
static int remoteDispatchDomainDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainDestroy(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_destroy_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDestroy(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainDestroyFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_destroy_flags_args *args);
static int remoteDispatchDomainDestroyFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainDestroyFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainDestroyFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_destroy_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDestroyFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainDetachDevice(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_detach_device_args *args);
static int remoteDispatchDomainDetachDeviceHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainDetachDevice(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainDetachDevice(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_detach_device_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDevice(dom, args->xml) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainDetachDeviceFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_detach_device_flags_args *args);
static int remoteDispatchDomainDetachDeviceFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainDetachDeviceFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainDetachDeviceFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_detach_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainDetachDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainEventsDeregister(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_events_deregister_ret *ret);
static int remoteDispatchDomainEventsDeregisterHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainEventsDeregister(server, client, hdr, rerr, ret);
}
/* remoteDispatchDomainEventsDeregister body has to be implemented manually */



static int remoteDispatchDomainEventsDeregisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_events_deregister_any_args *args);
static int remoteDispatchDomainEventsDeregisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainEventsDeregisterAny(server, client, hdr, rerr, args);
}
/* remoteDispatchDomainEventsDeregisterAny body has to be implemented manually */



static int remoteDispatchDomainEventsRegister(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_events_register_ret *ret);
static int remoteDispatchDomainEventsRegisterHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainEventsRegister(server, client, hdr, rerr, ret);
}
/* remoteDispatchDomainEventsRegister body has to be implemented manually */



static int remoteDispatchDomainEventsRegisterAny(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_events_register_any_args *args);
static int remoteDispatchDomainEventsRegisterAnyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainEventsRegisterAny(server, client, hdr, rerr, args);
}
/* remoteDispatchDomainEventsRegisterAny body has to be implemented manually */



static int remoteDispatchDomainGetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_autostart_args *args,
    remote_domain_get_autostart_ret *ret);
static int remoteDispatchDomainGetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetAutostart(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_autostart_args *args,
    remote_domain_get_autostart_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int autostart;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetAutostart(dom, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetBlkioParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_blkio_parameters_args *args,
    remote_domain_get_blkio_parameters_ret *ret);
static int remoteDispatchDomainGetBlkioParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetBlkioParameters(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetBlkioParameters body has to be implemented manually */



static int remoteDispatchDomainGetBlockInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_block_info_args *args,
    remote_domain_get_block_info_ret *ret);
static int remoteDispatchDomainGetBlockInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetBlockInfo(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetBlockInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_block_info_args *args,
    remote_domain_get_block_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainBlockInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetBlockInfo(dom, args->path, &tmp, args->flags) < 0)
        goto cleanup;

    ret->allocation = tmp.allocation;
    ret->capacity = tmp.capacity;
    ret->physical = tmp.physical;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetBlockJobInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_block_job_info_args *args,
    remote_domain_get_block_job_info_ret *ret);
static int remoteDispatchDomainGetBlockJobInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetBlockJobInfo(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetBlockJobInfo body has to be implemented manually */



static int remoteDispatchDomainGetControlInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_control_info_args *args,
    remote_domain_get_control_info_ret *ret);
static int remoteDispatchDomainGetControlInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetControlInfo(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetControlInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_control_info_args *args,
    remote_domain_get_control_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainControlInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetControlInfo(dom, &tmp, args->flags) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->details = tmp.details;
    ret->stateTime = tmp.stateTime;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_info_args *args,
    remote_domain_get_info_ret *ret);
static int remoteDispatchDomainGetInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetInfo(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_info_args *args,
    remote_domain_get_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetInfo(dom, &tmp) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->maxMem = tmp.maxMem;
    ret->memory = tmp.memory;
    ret->nrVirtCpu = tmp.nrVirtCpu;
    ret->cpuTime = tmp.cpuTime;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetJobInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_job_info_args *args,
    remote_domain_get_job_info_ret *ret);
static int remoteDispatchDomainGetJobInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetJobInfo(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetJobInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_job_info_args *args,
    remote_domain_get_job_info_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainJobInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainGetJobInfo(dom, &tmp) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->timeElapsed = tmp.timeElapsed;
    ret->timeRemaining = tmp.timeRemaining;
    ret->dataTotal = tmp.dataTotal;
    ret->dataProcessed = tmp.dataProcessed;
    ret->dataRemaining = tmp.dataRemaining;
    ret->memTotal = tmp.memTotal;
    ret->memProcessed = tmp.memProcessed;
    ret->memRemaining = tmp.memRemaining;
    ret->fileTotal = tmp.fileTotal;
    ret->fileProcessed = tmp.fileProcessed;
    ret->fileRemaining = tmp.fileRemaining;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetMaxMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_max_memory_args *args,
    remote_domain_get_max_memory_ret *ret);
static int remoteDispatchDomainGetMaxMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetMaxMemory(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetMaxMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_max_memory_args *args,
    remote_domain_get_max_memory_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((memory = virDomainGetMaxMemory(dom)) == 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->memory, memory);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetMaxVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_max_vcpus_args *args,
    remote_domain_get_max_vcpus_ret *ret);
static int remoteDispatchDomainGetMaxVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetMaxVcpus(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetMaxVcpus(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_max_vcpus_args *args,
    remote_domain_get_max_vcpus_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((num = virDomainGetMaxVcpus(dom)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetMemoryParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_memory_parameters_args *args,
    remote_domain_get_memory_parameters_ret *ret);
static int remoteDispatchDomainGetMemoryParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetMemoryParameters(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetMemoryParameters body has to be implemented manually */



static int remoteDispatchDomainGetOSType(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_os_type_args *args,
    remote_domain_get_os_type_ret *ret);
static int remoteDispatchDomainGetOSTypeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetOSType(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetOSType(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_os_type_args *args,
    remote_domain_get_os_type_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *type;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((type = virDomainGetOSType(dom)) == NULL)
        goto cleanup;

    ret->type = type;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetSchedulerParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_scheduler_parameters_args *args,
    remote_domain_get_scheduler_parameters_ret *ret);
static int remoteDispatchDomainGetSchedulerParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetSchedulerParameters(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetSchedulerParameters body has to be implemented manually */



static int remoteDispatchDomainGetSchedulerParametersFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_scheduler_parameters_flags_args *args,
    remote_domain_get_scheduler_parameters_flags_ret *ret);
static int remoteDispatchDomainGetSchedulerParametersFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetSchedulerParametersFlags(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetSchedulerParametersFlags body has to be implemented manually */



static int remoteDispatchDomainGetSchedulerType(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_scheduler_type_args *args,
    remote_domain_get_scheduler_type_ret *ret);
static int remoteDispatchDomainGetSchedulerTypeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetSchedulerType(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetSchedulerType body has to be implemented manually */



static int remoteDispatchDomainGetSecurityLabel(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_security_label_args *args,
    remote_domain_get_security_label_ret *ret);
static int remoteDispatchDomainGetSecurityLabelHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetSecurityLabel(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetSecurityLabel body has to be implemented manually */



static int remoteDispatchDomainGetState(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_state_args *args,
    remote_domain_get_state_ret *ret);
static int remoteDispatchDomainGetStateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetState(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetState body has to be implemented manually */



static int remoteDispatchDomainGetVcpuPinInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_vcpu_pin_info_args *args,
    remote_domain_get_vcpu_pin_info_ret *ret);
static int remoteDispatchDomainGetVcpuPinInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetVcpuPinInfo(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetVcpuPinInfo body has to be implemented manually */



static int remoteDispatchDomainGetVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_vcpus_args *args,
    remote_domain_get_vcpus_ret *ret);
static int remoteDispatchDomainGetVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetVcpus(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainGetVcpus body has to be implemented manually */



static int remoteDispatchDomainGetVcpusFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_vcpus_flags_args *args,
    remote_domain_get_vcpus_flags_ret *ret);
static int remoteDispatchDomainGetVcpusFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetVcpusFlags(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetVcpusFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_vcpus_flags_args *args,
    remote_domain_get_vcpus_flags_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((num = virDomainGetVcpusFlags(dom, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_get_xml_desc_args *args,
    remote_domain_get_xml_desc_ret *ret);
static int remoteDispatchDomainGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_get_xml_desc_args *args,
    remote_domain_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((xml = virDomainGetXMLDesc(dom, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainHasCurrentSnapshot(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_has_current_snapshot_args *args,
    remote_domain_has_current_snapshot_ret *ret);
static int remoteDispatchDomainHasCurrentSnapshotHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainHasCurrentSnapshot(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainHasCurrentSnapshot(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_has_current_snapshot_args *args,
    remote_domain_has_current_snapshot_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((result = virDomainHasCurrentSnapshot(dom, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainHasManagedSaveImage(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_has_managed_save_image_args *args,
    remote_domain_has_managed_save_image_ret *ret);
static int remoteDispatchDomainHasManagedSaveImageHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainHasManagedSaveImage(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainHasManagedSaveImage(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_has_managed_save_image_args *args,
    remote_domain_has_managed_save_image_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int result;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((result = virDomainHasManagedSaveImage(dom, args->flags)) < 0)
        goto cleanup;

    ret->result = result;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainInjectNMI(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_inject_nmi_args *args);
static int remoteDispatchDomainInjectNMIHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainInjectNMI(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainInjectNMI(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_inject_nmi_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainInjectNMI(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainInterfaceStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_interface_stats_args *args,
    remote_domain_interface_stats_ret *ret);
static int remoteDispatchDomainInterfaceStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainInterfaceStats(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainInterfaceStats(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_interface_stats_args *args,
    remote_domain_interface_stats_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainInterfaceStatsStruct tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainInterfaceStats(dom, args->path, &tmp, sizeof tmp) < 0)
        goto cleanup;

    ret->rx_bytes = tmp.rx_bytes;
    ret->rx_packets = tmp.rx_packets;
    ret->rx_errs = tmp.rx_errs;
    ret->rx_drop = tmp.rx_drop;
    ret->tx_bytes = tmp.tx_bytes;
    ret->tx_packets = tmp.tx_packets;
    ret->tx_errs = tmp.tx_errs;
    ret->tx_drop = tmp.tx_drop;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainIsActive(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_is_active_args *args,
    remote_domain_is_active_ret *ret);
static int remoteDispatchDomainIsActiveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainIsActive(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainIsActive(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_is_active_args *args,
    remote_domain_is_active_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int active;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((active = virDomainIsActive(dom)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainIsPersistent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_is_persistent_args *args,
    remote_domain_is_persistent_ret *ret);
static int remoteDispatchDomainIsPersistentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainIsPersistent(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainIsPersistent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_is_persistent_args *args,
    remote_domain_is_persistent_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int persistent;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((persistent = virDomainIsPersistent(dom)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainIsUpdated(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_is_updated_args *args,
    remote_domain_is_updated_ret *ret);
static int remoteDispatchDomainIsUpdatedHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainIsUpdated(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainIsUpdated(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_is_updated_args *args,
    remote_domain_is_updated_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int updated;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((updated = virDomainIsUpdated(dom)) < 0)
        goto cleanup;

    ret->updated = updated;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainLookupByID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_id_args *args,
    remote_domain_lookup_by_id_ret *ret);
static int remoteDispatchDomainLookupByIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainLookupByID(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainLookupByID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_id_args *args,
    remote_domain_lookup_by_id_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByID(priv->conn, args->id)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_name_args *args,
    remote_domain_lookup_by_name_ret *ret);
static int remoteDispatchDomainLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainLookupByName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_name_args *args,
    remote_domain_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_uuid_args *args,
    remote_domain_lookup_by_uuid_ret *ret);
static int remoteDispatchDomainLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainLookupByUUID(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_lookup_by_uuid_args *args,
    remote_domain_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainManagedSave(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_args *args);
static int remoteDispatchDomainManagedSaveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainManagedSave(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainManagedSave(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainManagedSave(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainManagedSaveRemove(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_remove_args *args);
static int remoteDispatchDomainManagedSaveRemoveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainManagedSaveRemove(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainManagedSaveRemove(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_managed_save_remove_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainManagedSaveRemove(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainMemoryPeek(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_memory_peek_args *args,
    remote_domain_memory_peek_ret *ret);
static int remoteDispatchDomainMemoryPeekHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMemoryPeek(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainMemoryPeek body has to be implemented manually */



static int remoteDispatchDomainMemoryStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_memory_stats_args *args,
    remote_domain_memory_stats_ret *ret);
static int remoteDispatchDomainMemoryStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMemoryStats(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainMemoryStats body has to be implemented manually */



static int remoteDispatchDomainMigrateBegin3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_begin3_args *args,
    remote_domain_migrate_begin3_ret *ret);
static int remoteDispatchDomainMigrateBegin3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigrateBegin3(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainMigrateBegin3 body has to be implemented manually */



static int remoteDispatchDomainMigrateConfirm3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_confirm3_args *args);
static int remoteDispatchDomainMigrateConfirm3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigrateConfirm3(server, client, hdr, rerr, args);
}
/* remoteDispatchDomainMigrateConfirm3 body has to be implemented manually */



static int remoteDispatchDomainMigrateFinish(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish_args *args,
    remote_domain_migrate_finish_ret *ret);
static int remoteDispatchDomainMigrateFinishHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigrateFinish(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainMigrateFinish(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish_args *args,
    remote_domain_migrate_finish_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    virDomainPtr ddom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    if ((ddom = virDomainMigrateFinish(priv->conn, args->dname, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->ddom, ddom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (ddom)
        virDomainFree(ddom);
    return rv;
}



static int remoteDispatchDomainMigrateFinish2(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish2_args *args,
    remote_domain_migrate_finish2_ret *ret);
static int remoteDispatchDomainMigrateFinish2Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigrateFinish2(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainMigrateFinish2(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish2_args *args,
    remote_domain_migrate_finish2_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    virDomainPtr ddom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    if ((ddom = virDomainMigrateFinish2(priv->conn, args->dname, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags, args->retcode)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->ddom, ddom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (ddom)
        virDomainFree(ddom);
    return rv;
}



static int remoteDispatchDomainMigrateFinish3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_finish3_args *args,
    remote_domain_migrate_finish3_ret *ret);
static int remoteDispatchDomainMigrateFinish3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigrateFinish3(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainMigrateFinish3 body has to be implemented manually */



static int remoteDispatchDomainMigratePerform(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_perform_args *args);
static int remoteDispatchDomainMigratePerformHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigratePerform(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainMigratePerform(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_perform_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long flags;
    char *dname;
    unsigned long resource;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (virDomainMigratePerform(dom, args->cookie.cookie_val, args->cookie.cookie_len, args->uri, flags, dname, resource) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainMigratePerform3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_perform3_args *args,
    remote_domain_migrate_perform3_ret *ret);
static int remoteDispatchDomainMigratePerform3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigratePerform3(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainMigratePerform3 body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_args *args,
    remote_domain_migrate_prepare_ret *ret);
static int remoteDispatchDomainMigratePrepareHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigratePrepare(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainMigratePrepare body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare2(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare2_args *args,
    remote_domain_migrate_prepare2_ret *ret);
static int remoteDispatchDomainMigratePrepare2Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigratePrepare2(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainMigratePrepare2 body has to be implemented manually */



static int remoteDispatchDomainMigratePrepare3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare3_args *args,
    remote_domain_migrate_prepare3_ret *ret);
static int remoteDispatchDomainMigratePrepare3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigratePrepare3(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchDomainMigratePrepare3 body has to be implemented manually */



static int remoteDispatchDomainMigratePrepareTunnel(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel_args *args);
static int remoteDispatchDomainMigratePrepareTunnelHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigratePrepareTunnel(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainMigratePrepareTunnel(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel_args *args)
{
    int rv = -1;
    unsigned long flags;
    char *dname;
    unsigned long resource;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, hdr)))
        goto cleanup;

    if (virDomainMigratePrepareTunnel(priv->conn, st, flags, dname, resource, args->dom_xml) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virStreamFree(st);
        }
    }
    return rv;
}



static int remoteDispatchDomainMigratePrepareTunnel3(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel3_args *args,
    remote_domain_migrate_prepare_tunnel3_ret *ret);
static int remoteDispatchDomainMigratePrepareTunnel3Helper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigratePrepareTunnel3(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainMigratePrepareTunnel3(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_prepare_tunnel3_args *args,
    remote_domain_migrate_prepare_tunnel3_ret *ret)
{
    int rv = -1;
    unsigned long flags;
    char *dname;
    unsigned long resource;
    char *cookie_out = NULL;
    int cookie_out_len = 0;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    HYPER_TO_ULONG(flags, args->flags);

    HYPER_TO_ULONG(resource, args->resource);

    dname = args->dname ? *args->dname : NULL;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, hdr)))
        goto cleanup;

    if (virDomainMigratePrepareTunnel3(priv->conn, st, args->cookie_in.cookie_in_val, args->cookie_in.cookie_in_len, &cookie_out, &cookie_out_len, flags, dname, resource, args->dom_xml) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    ret->cookie_out.cookie_out_val = cookie_out;
    ret->cookie_out.cookie_out_len = cookie_out_len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(cookie_out);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virStreamFree(st);
        }
    }
    return rv;
}



static int remoteDispatchDomainMigrateSetMaxDowntime(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_max_downtime_args *args);
static int remoteDispatchDomainMigrateSetMaxDowntimeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigrateSetMaxDowntime(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainMigrateSetMaxDowntime(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_max_downtime_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainMigrateSetMaxDowntime(dom, args->downtime, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainMigrateSetMaxSpeed(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_max_speed_args *args);
static int remoteDispatchDomainMigrateSetMaxSpeedHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainMigrateSetMaxSpeed(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainMigrateSetMaxSpeed(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_migrate_set_max_speed_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long bandwidth;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(bandwidth, args->bandwidth);

    if (virDomainMigrateSetMaxSpeed(dom, bandwidth, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainOpenConsole(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_open_console_args *args);
static int remoteDispatchDomainOpenConsoleHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainOpenConsole(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainOpenConsole(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_open_console_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *devname;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    devname = args->devname ? *args->devname : NULL;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, hdr)))
        goto cleanup;

    if (virDomainOpenConsole(dom, devname, st, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virStreamFree(st);
        }
    }
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainPinVcpu(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_vcpu_args *args);
static int remoteDispatchDomainPinVcpuHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainPinVcpu(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainPinVcpu(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_vcpu_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainPinVcpu(dom, args->vcpu, (unsigned char *) args->cpumap.cpumap_val, args->cpumap.cpumap_len) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainPinVcpuFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_vcpu_flags_args *args);
static int remoteDispatchDomainPinVcpuFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainPinVcpuFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainPinVcpuFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_pin_vcpu_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainPinVcpuFlags(dom, args->vcpu, (unsigned char *) args->cpumap.cpumap_val, args->cpumap.cpumap_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainReboot(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_reboot_args *args);
static int remoteDispatchDomainRebootHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainReboot(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainReboot(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_reboot_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainReboot(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainRestore(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_restore_args *args);
static int remoteDispatchDomainRestoreHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainRestore(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainRestore(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_restore_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virDomainRestore(priv->conn, args->from) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainRestoreFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_restore_flags_args *args);
static int remoteDispatchDomainRestoreFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainRestoreFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainRestoreFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_restore_flags_args *args)
{
    int rv = -1;
    char *dxml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    dxml = args->dxml ? *args->dxml : NULL;

    if (virDomainRestoreFlags(priv->conn, args->from, dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainResume(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_resume_args *args);
static int remoteDispatchDomainResumeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainResume(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainResume(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_resume_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainResume(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainRevertToSnapshot(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_revert_to_snapshot_args *args);
static int remoteDispatchDomainRevertToSnapshotHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainRevertToSnapshot(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainRevertToSnapshot(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_revert_to_snapshot_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if (virDomainRevertToSnapshot(snapshot, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (snapshot)
        virDomainSnapshotFree(snapshot);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSave(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_save_args *args);
static int remoteDispatchDomainSaveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSave(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSave(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_save_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSave(dom, args->to) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSaveFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_save_flags_args *args);
static int remoteDispatchDomainSaveFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSaveFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSaveFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_save_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *dxml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    dxml = args->dxml ? *args->dxml : NULL;

    if (virDomainSaveFlags(dom, args->to, dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSaveImageDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_save_image_define_xml_args *args);
static int remoteDispatchDomainSaveImageDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSaveImageDefineXML(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSaveImageDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_save_image_define_xml_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virDomainSaveImageDefineXML(priv->conn, args->file, args->dxml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainSaveImageGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_save_image_get_xml_desc_args *args,
    remote_domain_save_image_get_xml_desc_ret *ret);
static int remoteDispatchDomainSaveImageGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSaveImageGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainSaveImageGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_save_image_get_xml_desc_args *args,
    remote_domain_save_image_get_xml_desc_ret *ret)
{
    int rv = -1;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((xml = virDomainSaveImageGetXMLDesc(priv->conn, args->file, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainScreenshot(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_screenshot_args *args,
    remote_domain_screenshot_ret *ret);
static int remoteDispatchDomainScreenshotHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainScreenshot(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainScreenshot(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_screenshot_args *args,
    remote_domain_screenshot_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *mime = NULL;
    char **mime_p = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, hdr)))
        goto cleanup;

    if ((mime = virDomainScreenshot(dom, st, args->screen, args->flags)) == NULL)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    if (VIR_ALLOC(mime_p) < 0) {
        virReportOOMError();
        goto cleanup;
    }
    
    *mime_p = strdup(mime);
    if (*mime_p == NULL) {
        virReportOOMError();
        goto cleanup;
    }

    ret->mime = mime_p;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(mime_p);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virStreamFree(st);
        }
    }
    if (dom)
        virDomainFree(dom);
    VIR_FREE(mime);
    return rv;
}



static int remoteDispatchDomainSendKey(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_send_key_args *args);
static int remoteDispatchDomainSendKeyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSendKey(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSendKey(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_send_key_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSendKey(dom, args->codeset, args->holdtime, args->keycodes.keycodes_val, args->keycodes.keycodes_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_autostart_args *args);
static int remoteDispatchDomainSetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetAutostart(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_autostart_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetAutostart(dom, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSetBlkioParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_blkio_parameters_args *args);
static int remoteDispatchDomainSetBlkioParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetBlkioParameters(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetBlkioParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_blkio_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((params = remoteDeserializeTypedParameters(args->params.params_val,
                                                   args->params.params_len,
                                                   REMOTE_DOMAIN_BLKIO_PARAMETERS_MAX,
                                                   &nparams)) == NULL)
        goto cleanup;

    if (virDomainSetBlkioParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    VIR_FREE(params);
    return rv;
}



static int remoteDispatchDomainSetMaxMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_max_memory_args *args);
static int remoteDispatchDomainSetMaxMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetMaxMemory(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetMaxMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_max_memory_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMaxMemory(dom, memory) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSetMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_args *args);
static int remoteDispatchDomainSetMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetMemory(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMemory(dom, memory) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSetMemoryFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_flags_args *args);
static int remoteDispatchDomainSetMemoryFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetMemoryFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetMemoryFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    unsigned long memory;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    HYPER_TO_ULONG(memory, args->memory);

    if (virDomainSetMemoryFlags(dom, memory, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSetMemoryParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_parameters_args *args);
static int remoteDispatchDomainSetMemoryParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetMemoryParameters(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetMemoryParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_memory_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((params = remoteDeserializeTypedParameters(args->params.params_val,
                                                   args->params.params_len,
                                                   REMOTE_DOMAIN_MEMORY_PARAMETERS_MAX,
                                                   &nparams)) == NULL)
        goto cleanup;

    if (virDomainSetMemoryParameters(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    VIR_FREE(params);
    return rv;
}



static int remoteDispatchDomainSetSchedulerParameters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_scheduler_parameters_args *args);
static int remoteDispatchDomainSetSchedulerParametersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetSchedulerParameters(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetSchedulerParameters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_scheduler_parameters_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((params = remoteDeserializeTypedParameters(args->params.params_val,
                                                   args->params.params_len,
                                                   REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX,
                                                   &nparams)) == NULL)
        goto cleanup;

    if (virDomainSetSchedulerParameters(dom, params, nparams) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    VIR_FREE(params);
    return rv;
}



static int remoteDispatchDomainSetSchedulerParametersFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_scheduler_parameters_flags_args *args);
static int remoteDispatchDomainSetSchedulerParametersFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetSchedulerParametersFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetSchedulerParametersFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_scheduler_parameters_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virTypedParameterPtr params = NULL;
    int nparams;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((params = remoteDeserializeTypedParameters(args->params.params_val,
                                                   args->params.params_len,
                                                   REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX,
                                                   &nparams)) == NULL)
        goto cleanup;

    if (virDomainSetSchedulerParametersFlags(dom, params, nparams, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    VIR_FREE(params);
    return rv;
}



static int remoteDispatchDomainSetVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpus_args *args);
static int remoteDispatchDomainSetVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetVcpus(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetVcpus(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpus_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpus(dom, args->nvcpus) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSetVcpusFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpus_flags_args *args);
static int remoteDispatchDomainSetVcpusFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSetVcpusFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSetVcpusFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_set_vcpus_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSetVcpusFlags(dom, args->nvcpus, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainShutdown(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_shutdown_args *args);
static int remoteDispatchDomainShutdownHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainShutdown(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainShutdown(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_shutdown_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainShutdown(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_create_xml_args *args,
    remote_domain_snapshot_create_xml_ret *ret);
static int remoteDispatchDomainSnapshotCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSnapshotCreateXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainSnapshotCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_create_xml_args *args,
    remote_domain_snapshot_create_xml_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotCreateXML(dom, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    if (snap)
        virDomainSnapshotFree(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotCurrent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_current_args *args,
    remote_domain_snapshot_current_ret *ret);
static int remoteDispatchDomainSnapshotCurrentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSnapshotCurrent(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainSnapshotCurrent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_current_args *args,
    remote_domain_snapshot_current_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotCurrent(dom, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    if (snap)
        virDomainSnapshotFree(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotDelete(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_delete_args *args);
static int remoteDispatchDomainSnapshotDeleteHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSnapshotDelete(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSnapshotDelete(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_delete_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if (virDomainSnapshotDelete(snapshot, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (snapshot)
        virDomainSnapshotFree(snapshot);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_get_xml_desc_args *args,
    remote_domain_snapshot_get_xml_desc_ret *ret);
static int remoteDispatchDomainSnapshotGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSnapshotGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainSnapshotGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_get_xml_desc_args *args,
    remote_domain_snapshot_get_xml_desc_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snapshot = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->snap.dom)))
        goto cleanup;

    if (!(snapshot = get_nonnull_domain_snapshot(dom, args->snap)))
        goto cleanup;

    if ((xml = virDomainSnapshotGetXMLDesc(snapshot, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (snapshot)
        virDomainSnapshotFree(snapshot);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotListNames(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_list_names_args *args,
    remote_domain_snapshot_list_names_ret *ret);
static int remoteDispatchDomainSnapshotListNamesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSnapshotListNames(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainSnapshotListNames(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_list_names_args *args,
    remote_domain_snapshot_list_names_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_NAMES_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_DOMAIN_SNAPSHOT_LIST_NAMES_MAX"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virDomainSnapshotListNames(dom, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSnapshotLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_lookup_by_name_args *args,
    remote_domain_snapshot_lookup_by_name_ret *ret);
static int remoteDispatchDomainSnapshotLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSnapshotLookupByName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainSnapshotLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_lookup_by_name_args *args,
    remote_domain_snapshot_lookup_by_name_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    virDomainSnapshotPtr snap = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((snap = virDomainSnapshotLookupByName(dom, args->name, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain_snapshot(&ret->snap, snap);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    if (snap)
        virDomainSnapshotFree(snap);
    return rv;
}



static int remoteDispatchDomainSnapshotNum(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_num_args *args,
    remote_domain_snapshot_num_ret *ret);
static int remoteDispatchDomainSnapshotNumHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSnapshotNum(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainSnapshotNum(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_snapshot_num_args *args,
    remote_domain_snapshot_num_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((num = virDomainSnapshotNum(dom, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainSuspend(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_suspend_args *args);
static int remoteDispatchDomainSuspendHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainSuspend(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainSuspend(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_suspend_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainSuspend(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_undefine_args *args);
static int remoteDispatchDomainUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainUndefine(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_undefine_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainUndefine(dom) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainUndefineFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_undefine_flags_args *args);
static int remoteDispatchDomainUndefineFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainUndefineFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainUndefineFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_undefine_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainUndefineFlags(dom, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainUpdateDeviceFlags(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_update_device_flags_args *args);
static int remoteDispatchDomainUpdateDeviceFlagsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainUpdateDeviceFlags(server, client, hdr, rerr, args);
}
static int remoteDispatchDomainUpdateDeviceFlags(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_update_device_flags_args *args)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if (virDomainUpdateDeviceFlags(dom, args->xml, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int remoteDispatchDomainXMLFromNative(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_xml_from_native_args *args,
    remote_domain_xml_from_native_ret *ret);
static int remoteDispatchDomainXMLFromNativeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainXMLFromNative(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainXMLFromNative(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_xml_from_native_args *args,
    remote_domain_xml_from_native_ret *ret)
{
    int rv = -1;
    char *domainXml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((domainXml = virConnectDomainXMLFromNative(priv->conn, args->nativeFormat, args->nativeConfig, args->flags)) == NULL)
        goto cleanup;

    ret->domainXml = domainXml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchDomainXMLToNative(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_domain_xml_to_native_args *args,
    remote_domain_xml_to_native_ret *ret);
static int remoteDispatchDomainXMLToNativeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchDomainXMLToNative(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchDomainXMLToNative(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_domain_xml_to_native_args *args,
    remote_domain_xml_to_native_ret *ret)
{
    int rv = -1;
    char *nativeConfig;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nativeConfig = virConnectDomainXMLToNative(priv->conn, args->nativeFormat, args->domainXml, args->flags)) == NULL)
        goto cleanup;

    ret->nativeConfig = nativeConfig;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchFindStoragePoolSources(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_find_storage_pool_sources_args *args,
    remote_find_storage_pool_sources_ret *ret);
static int remoteDispatchFindStoragePoolSourcesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchFindStoragePoolSources(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchFindStoragePoolSources(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_find_storage_pool_sources_args *args,
    remote_find_storage_pool_sources_ret *ret)
{
    int rv = -1;
    char *srcSpec;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    srcSpec = args->srcSpec ? *args->srcSpec : NULL;

    if ((xml = virConnectFindStoragePoolSources(priv->conn, args->type, srcSpec, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchGetCapabilities(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_get_capabilities_ret *ret);
static int remoteDispatchGetCapabilitiesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchGetCapabilities(server, client, hdr, rerr, ret);
}
static int remoteDispatchGetCapabilities(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_get_capabilities_ret *ret)
{
    int rv = -1;
    char *capabilities;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((capabilities = virConnectGetCapabilities(priv->conn)) == NULL)
        goto cleanup;

    ret->capabilities = capabilities;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchGetHostname(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_get_hostname_ret *ret);
static int remoteDispatchGetHostnameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchGetHostname(server, client, hdr, rerr, ret);
}
static int remoteDispatchGetHostname(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_get_hostname_ret *ret)
{
    int rv = -1;
    char *hostname;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((hostname = virConnectGetHostname(priv->conn)) == NULL)
        goto cleanup;

    ret->hostname = hostname;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchGetLibVersion(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_get_lib_version_ret *ret);
static int remoteDispatchGetLibVersionHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchGetLibVersion(server, client, hdr, rerr, ret);
}
static int remoteDispatchGetLibVersion(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_get_lib_version_ret *ret)
{
    int rv = -1;
    unsigned long lib_ver;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virConnectGetLibVersion(priv->conn, &lib_ver) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->lib_ver, lib_ver);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchGetMaxVcpus(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_get_max_vcpus_args *args,
    remote_get_max_vcpus_ret *ret);
static int remoteDispatchGetMaxVcpusHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchGetMaxVcpus(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchGetMaxVcpus(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_get_max_vcpus_args *args,
    remote_get_max_vcpus_ret *ret)
{
    int rv = -1;
    char *type;
    int max_vcpus;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    type = args->type ? *args->type : NULL;

    if ((max_vcpus = virConnectGetMaxVcpus(priv->conn, type)) < 0)
        goto cleanup;

    ret->max_vcpus = max_vcpus;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchGetSysinfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_get_sysinfo_args *args,
    remote_get_sysinfo_ret *ret);
static int remoteDispatchGetSysinfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchGetSysinfo(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchGetSysinfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_get_sysinfo_args *args,
    remote_get_sysinfo_ret *ret)
{
    int rv = -1;
    char *sysinfo;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((sysinfo = virConnectGetSysinfo(priv->conn, args->flags)) == NULL)
        goto cleanup;

    ret->sysinfo = sysinfo;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchGetType(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_get_type_ret *ret);
static int remoteDispatchGetTypeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchGetType(server, client, hdr, rerr, ret);
}
static int remoteDispatchGetType(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_get_type_ret *ret)
{
    int rv = -1;
    const char *type;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((type = virConnectGetType(priv->conn)) == NULL)
        goto cleanup;

    /* We have to strdup because remoteDispatchClientRequest will
     * free this string after it's been serialised. */
    if (!(ret->type = strdup(type))) {
        virReportOOMError();
        goto cleanup;
    }
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchGetURI(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_get_uri_ret *ret);
static int remoteDispatchGetURIHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchGetURI(server, client, hdr, rerr, ret);
}
static int remoteDispatchGetURI(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_get_uri_ret *ret)
{
    int rv = -1;
    char *uri;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((uri = virConnectGetURI(priv->conn)) == NULL)
        goto cleanup;

    ret->uri = uri;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchGetVersion(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_get_version_ret *ret);
static int remoteDispatchGetVersionHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchGetVersion(server, client, hdr, rerr, ret);
}
static int remoteDispatchGetVersion(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_get_version_ret *ret)
{
    int rv = -1;
    unsigned long hv_ver;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virConnectGetVersion(priv->conn, &hv_ver) < 0)
        goto cleanup;

    HYPER_TO_ULONG(ret->hv_ver, hv_ver);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceChangeBegin(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_change_begin_args *args);
static int remoteDispatchInterfaceChangeBeginHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceChangeBegin(server, client, hdr, rerr, args);
}
static int remoteDispatchInterfaceChangeBegin(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_change_begin_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeBegin(priv->conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceChangeCommit(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_change_commit_args *args);
static int remoteDispatchInterfaceChangeCommitHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceChangeCommit(server, client, hdr, rerr, args);
}
static int remoteDispatchInterfaceChangeCommit(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_change_commit_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeCommit(priv->conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceChangeRollback(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_change_rollback_args *args);
static int remoteDispatchInterfaceChangeRollbackHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceChangeRollback(server, client, hdr, rerr, args);
}
static int remoteDispatchInterfaceChangeRollback(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_change_rollback_args *args)
{
    int rv = -1;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virInterfaceChangeRollback(priv->conn, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchInterfaceCreate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_create_args *args);
static int remoteDispatchInterfaceCreateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceCreate(server, client, hdr, rerr, args);
}
static int remoteDispatchInterfaceCreate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_create_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if (virInterfaceCreate(iface, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}



static int remoteDispatchInterfaceDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_define_xml_args *args,
    remote_interface_define_xml_ret *ret);
static int remoteDispatchInterfaceDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceDefineXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchInterfaceDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_define_xml_args *args,
    remote_interface_define_xml_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceDefineXML(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}



static int remoteDispatchInterfaceDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_destroy_args *args);
static int remoteDispatchInterfaceDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceDestroy(server, client, hdr, rerr, args);
}
static int remoteDispatchInterfaceDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_destroy_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if (virInterfaceDestroy(iface, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}



static int remoteDispatchInterfaceGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_get_xml_desc_args *args,
    remote_interface_get_xml_desc_ret *ret);
static int remoteDispatchInterfaceGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchInterfaceGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_get_xml_desc_args *args,
    remote_interface_get_xml_desc_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if ((xml = virInterfaceGetXMLDesc(iface, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}



static int remoteDispatchInterfaceIsActive(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_is_active_args *args,
    remote_interface_is_active_ret *ret);
static int remoteDispatchInterfaceIsActiveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceIsActive(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchInterfaceIsActive(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_is_active_args *args,
    remote_interface_is_active_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    int active;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if ((active = virInterfaceIsActive(iface)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}



static int remoteDispatchInterfaceLookupByMACString(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_lookup_by_mac_string_args *args,
    remote_interface_lookup_by_mac_string_ret *ret);
static int remoteDispatchInterfaceLookupByMACStringHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceLookupByMACString(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchInterfaceLookupByMACString(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_lookup_by_mac_string_args *args,
    remote_interface_lookup_by_mac_string_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceLookupByMACString(priv->conn, args->mac)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}



static int remoteDispatchInterfaceLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_lookup_by_name_args *args,
    remote_interface_lookup_by_name_ret *ret);
static int remoteDispatchInterfaceLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceLookupByName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchInterfaceLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_lookup_by_name_args *args,
    remote_interface_lookup_by_name_ret *ret)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((iface = virInterfaceLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_interface(&ret->iface, iface);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}



static int remoteDispatchInterfaceUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_interface_undefine_args *args);
static int remoteDispatchInterfaceUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchInterfaceUndefine(server, client, hdr, rerr, args);
}
static int remoteDispatchInterfaceUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_interface_undefine_args *args)
{
    int rv = -1;
    virInterfacePtr iface = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(iface = get_nonnull_interface(priv->conn, args->iface)))
        goto cleanup;

    if (virInterfaceUndefine(iface) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (iface)
        virInterfaceFree(iface);
    return rv;
}



static int remoteDispatchIsSecure(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_is_secure_ret *ret);
static int remoteDispatchIsSecureHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchIsSecure(server, client, hdr, rerr, ret);
}
static int remoteDispatchIsSecure(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_is_secure_ret *ret)
{
    int rv = -1;
    int secure;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secure = virConnectIsSecure(priv->conn)) < 0)
        goto cleanup;

    ret->secure = secure;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchListDefinedDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_defined_domains_args *args,
    remote_list_defined_domains_ret *ret);
static int remoteDispatchListDefinedDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListDefinedDomains(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListDefinedDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_defined_domains_args *args,
    remote_list_defined_domains_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DOMAIN_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_DOMAIN_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDefinedDomains(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchListDefinedInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_defined_interfaces_args *args,
    remote_list_defined_interfaces_ret *ret);
static int remoteDispatchListDefinedInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListDefinedInterfaces(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListDefinedInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_defined_interfaces_args *args,
    remote_list_defined_interfaces_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_DEFINED_INTERFACE_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_DEFINED_INTERFACE_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDefinedInterfaces(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchListDefinedNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_defined_networks_args *args,
    remote_list_defined_networks_ret *ret);
static int remoteDispatchListDefinedNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListDefinedNetworks(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListDefinedNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_defined_networks_args *args,
    remote_list_defined_networks_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NETWORK_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NETWORK_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDefinedNetworks(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchListDefinedStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_defined_storage_pools_args *args,
    remote_list_defined_storage_pools_ret *ret);
static int remoteDispatchListDefinedStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListDefinedStoragePools(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListDefinedStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_defined_storage_pools_args *args,
    remote_list_defined_storage_pools_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_POOL_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_STORAGE_POOL_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDefinedStoragePools(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchListDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_domains_args *args,
    remote_list_domains_ret *ret);
static int remoteDispatchListDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListDomains(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_domains_args *args,
    remote_list_domains_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxids > REMOTE_DOMAIN_ID_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxids > REMOTE_DOMAIN_ID_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->ids.ids_val, args->maxids) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListDomains(priv->conn, ret->ids.ids_val, args->maxids)) < 0)
        goto cleanup;

    ret->ids.ids_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->ids.ids_val);
    }
    return rv;
}



static int remoteDispatchListInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_interfaces_args *args,
    remote_list_interfaces_ret *ret);
static int remoteDispatchListInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListInterfaces(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_interfaces_args *args,
    remote_list_interfaces_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_INTERFACE_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_INTERFACE_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListInterfaces(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchListNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_networks_args *args,
    remote_list_networks_ret *ret);
static int remoteDispatchListNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListNetworks(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_networks_args *args,
    remote_list_networks_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NETWORK_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NETWORK_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListNetworks(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchListNWFilters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_nwfilters_args *args,
    remote_list_nwfilters_ret *ret);
static int remoteDispatchListNWFiltersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListNWFilters(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListNWFilters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_nwfilters_args *args,
    remote_list_nwfilters_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NWFILTER_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NWFILTER_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListNWFilters(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchListSecrets(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_secrets_args *args,
    remote_list_secrets_ret *ret);
static int remoteDispatchListSecretsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListSecrets(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListSecrets(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_secrets_args *args,
    remote_list_secrets_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxuuids > REMOTE_SECRET_UUID_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxuuids > REMOTE_SECRET_UUID_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->uuids.uuids_val, args->maxuuids) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListSecrets(priv->conn, ret->uuids.uuids_val, args->maxuuids)) < 0)
        goto cleanup;

    ret->uuids.uuids_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->uuids.uuids_val);
    }
    return rv;
}



static int remoteDispatchListStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_list_storage_pools_args *args,
    remote_list_storage_pools_ret *ret);
static int remoteDispatchListStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchListStoragePools(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchListStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_list_storage_pools_args *args,
    remote_list_storage_pools_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_POOL_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_STORAGE_POOL_NAME_LIST_MAX"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virConnectListStoragePools(priv->conn, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchNetworkCreate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_create_args *args);
static int remoteDispatchNetworkCreateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkCreate(server, client, hdr, rerr, args);
}
static int remoteDispatchNetworkCreate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_create_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkCreate(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_create_xml_args *args,
    remote_network_create_xml_ret *ret);
static int remoteDispatchNetworkCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkCreateXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_create_xml_args *args,
    remote_network_create_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkCreateXML(priv->conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_define_xml_args *args,
    remote_network_define_xml_ret *ret);
static int remoteDispatchNetworkDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkDefineXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_define_xml_args *args,
    remote_network_define_xml_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkDefineXML(priv->conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_destroy_args *args);
static int remoteDispatchNetworkDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkDestroy(server, client, hdr, rerr, args);
}
static int remoteDispatchNetworkDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_destroy_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkDestroy(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkGetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_get_autostart_args *args,
    remote_network_get_autostart_ret *ret);
static int remoteDispatchNetworkGetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkGetAutostart(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkGetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_get_autostart_args *args,
    remote_network_get_autostart_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int autostart;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkGetAutostart(net, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkGetBridgeName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_get_bridge_name_args *args,
    remote_network_get_bridge_name_ret *ret);
static int remoteDispatchNetworkGetBridgeNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkGetBridgeName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkGetBridgeName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_get_bridge_name_args *args,
    remote_network_get_bridge_name_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    char *name;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if ((name = virNetworkGetBridgeName(net)) == NULL)
        goto cleanup;

    ret->name = name;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_get_xml_desc_args *args,
    remote_network_get_xml_desc_ret *ret);
static int remoteDispatchNetworkGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_get_xml_desc_args *args,
    remote_network_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if ((xml = virNetworkGetXMLDesc(net, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkIsActive(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_is_active_args *args,
    remote_network_is_active_ret *ret);
static int remoteDispatchNetworkIsActiveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkIsActive(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkIsActive(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_is_active_args *args,
    remote_network_is_active_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int active;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if ((active = virNetworkIsActive(net)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkIsPersistent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_is_persistent_args *args,
    remote_network_is_persistent_ret *ret);
static int remoteDispatchNetworkIsPersistentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkIsPersistent(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkIsPersistent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_is_persistent_args *args,
    remote_network_is_persistent_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    int persistent;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if ((persistent = virNetworkIsPersistent(net)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_lookup_by_name_args *args,
    remote_network_lookup_by_name_ret *ret);
static int remoteDispatchNetworkLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkLookupByName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_lookup_by_name_args *args,
    remote_network_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_lookup_by_uuid_args *args,
    remote_network_lookup_by_uuid_ret *ret);
static int remoteDispatchNetworkLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkLookupByUUID(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNetworkLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_lookup_by_uuid_args *args,
    remote_network_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((net = virNetworkLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_network(&ret->net, net);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkSetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_set_autostart_args *args);
static int remoteDispatchNetworkSetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkSetAutostart(server, client, hdr, rerr, args);
}
static int remoteDispatchNetworkSetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_set_autostart_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkSetAutostart(net, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNetworkUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_network_undefine_args *args);
static int remoteDispatchNetworkUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNetworkUndefine(server, client, hdr, rerr, args);
}
static int remoteDispatchNetworkUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_network_undefine_args *args)
{
    int rv = -1;
    virNetworkPtr net = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(net = get_nonnull_network(priv->conn, args->net)))
        goto cleanup;

    if (virNetworkUndefine(net) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (net)
        virNetworkFree(net);
    return rv;
}



static int remoteDispatchNodeDeviceCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_create_xml_args *args,
    remote_node_device_create_xml_ret *ret);
static int remoteDispatchNodeDeviceCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceCreateXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNodeDeviceCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_create_xml_args *args,
    remote_node_device_create_xml_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dev = virNodeDeviceCreateXML(priv->conn, args->xml_desc, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_destroy_args *args);
static int remoteDispatchNodeDeviceDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceDestroy(server, client, hdr, rerr, args);
}
static int remoteDispatchNodeDeviceDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_destroy_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if (virNodeDeviceDestroy(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeDeviceDettach(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_dettach_args *args);
static int remoteDispatchNodeDeviceDettachHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceDettach(server, client, hdr, rerr, args);
}
static int remoteDispatchNodeDeviceDettach(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_dettach_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if (virNodeDeviceDettach(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeDeviceGetParent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_get_parent_args *args,
    remote_node_device_get_parent_ret *ret);
static int remoteDispatchNodeDeviceGetParentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceGetParent(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchNodeDeviceGetParent body has to be implemented manually */



static int remoteDispatchNodeDeviceGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_get_xml_desc_args *args,
    remote_node_device_get_xml_desc_ret *ret);
static int remoteDispatchNodeDeviceGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNodeDeviceGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_get_xml_desc_args *args,
    remote_node_device_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if ((xml = virNodeDeviceGetXMLDesc(dev, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeDeviceListCaps(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_list_caps_args *args,
    remote_node_device_list_caps_ret *ret);
static int remoteDispatchNodeDeviceListCapsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceListCaps(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNodeDeviceListCaps(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_list_caps_args *args,
    remote_node_device_list_caps_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NODE_DEVICE_CAPS_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NODE_DEVICE_CAPS_LIST_MAX"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virNodeDeviceListCaps(dev, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeDeviceLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_lookup_by_name_args *args,
    remote_node_device_lookup_by_name_ret *ret);
static int remoteDispatchNodeDeviceLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceLookupByName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNodeDeviceLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_lookup_by_name_args *args,
    remote_node_device_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dev = virNodeDeviceLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_node_device(&ret->dev, dev);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeDeviceNumOfCaps(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_num_of_caps_args *args,
    remote_node_device_num_of_caps_ret *ret);
static int remoteDispatchNodeDeviceNumOfCapsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceNumOfCaps(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNodeDeviceNumOfCaps(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_num_of_caps_args *args,
    remote_node_device_num_of_caps_ret *ret)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if ((num = virNodeDeviceNumOfCaps(dev)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeDeviceReAttach(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_re_attach_args *args);
static int remoteDispatchNodeDeviceReAttachHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceReAttach(server, client, hdr, rerr, args);
}
static int remoteDispatchNodeDeviceReAttach(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_re_attach_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if (virNodeDeviceReAttach(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeDeviceReset(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_device_reset_args *args);
static int remoteDispatchNodeDeviceResetHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeDeviceReset(server, client, hdr, rerr, args);
}
static int remoteDispatchNodeDeviceReset(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_device_reset_args *args)
{
    int rv = -1;
    virNodeDevicePtr dev = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dev = virNodeDeviceLookupByName(priv->conn, args->name)))
        goto cleanup;

    if (virNodeDeviceReset(dev) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dev)
        virNodeDeviceFree(dev);
    return rv;
}



static int remoteDispatchNodeGetCellsFreeMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_get_cells_free_memory_args *args,
    remote_node_get_cells_free_memory_ret *ret);
static int remoteDispatchNodeGetCellsFreeMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeGetCellsFreeMemory(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNodeGetCellsFreeMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_get_cells_free_memory_args *args,
    remote_node_get_cells_free_memory_ret *ret)
{
    int rv = -1;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxcells > REMOTE_NODE_MAX_CELLS) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxcells > REMOTE_NODE_MAX_CELLS"));
        goto cleanup;
    }

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->cells.cells_val, args->maxcells) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virNodeGetCellsFreeMemory(priv->conn, (unsigned long long *)ret->cells.cells_val, args->startCell, args->maxcells)) <= 0)
        goto cleanup;

    ret->cells.cells_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->cells.cells_val);
    }
    return rv;
}



static int remoteDispatchNodeGetCPUStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_get_cpu_stats_args *args,
    remote_node_get_cpu_stats_ret *ret);
static int remoteDispatchNodeGetCPUStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeGetCPUStats(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchNodeGetCPUStats body has to be implemented manually */



static int remoteDispatchNodeGetFreeMemory(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_get_free_memory_ret *ret);
static int remoteDispatchNodeGetFreeMemoryHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeGetFreeMemory(server, client, hdr, rerr, ret);
}
static int remoteDispatchNodeGetFreeMemory(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_get_free_memory_ret *ret)
{
    int rv = -1;
    unsigned long long freeMem;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((freeMem = virNodeGetFreeMemory(priv->conn)) == 0)
        goto cleanup;

    ret->freeMem = freeMem;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNodeGetInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_get_info_ret *ret);
static int remoteDispatchNodeGetInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeGetInfo(server, client, hdr, rerr, ret);
}
static int remoteDispatchNodeGetInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_get_info_ret *ret)
{
    int rv = -1;
    virNodeInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (virNodeGetInfo(priv->conn, &tmp) < 0)
        goto cleanup;

    memcpy(ret->model, tmp.model, sizeof ret->model);
    ret->memory = tmp.memory;
    ret->cpus = tmp.cpus;
    ret->mhz = tmp.mhz;
    ret->nodes = tmp.nodes;
    ret->sockets = tmp.sockets;
    ret->cores = tmp.cores;
    ret->threads = tmp.threads;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNodeGetMemoryStats(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_get_memory_stats_args *args,
    remote_node_get_memory_stats_ret *ret);
static int remoteDispatchNodeGetMemoryStatsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeGetMemoryStats(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchNodeGetMemoryStats body has to be implemented manually */



static int remoteDispatchNodeGetSecurityModel(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_get_security_model_ret *ret);
static int remoteDispatchNodeGetSecurityModelHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeGetSecurityModel(server, client, hdr, rerr, ret);
}
/* remoteDispatchNodeGetSecurityModel body has to be implemented manually */



static int remoteDispatchNodeListDevices(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_list_devices_args *args,
    remote_node_list_devices_ret *ret);
static int remoteDispatchNodeListDevicesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeListDevices(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNodeListDevices(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_list_devices_args *args,
    remote_node_list_devices_ret *ret)
{
    int rv = -1;
    char *cap;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_NODE_DEVICE_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_NODE_DEVICE_NAME_LIST_MAX"));
        goto cleanup;
    }

    cap = args->cap ? *args->cap : NULL;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virNodeListDevices(priv->conn, cap, ret->names.names_val, args->maxnames, args->flags)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    return rv;
}



static int remoteDispatchNodeNumOfDevices(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_node_num_of_devices_args *args,
    remote_node_num_of_devices_ret *ret);
static int remoteDispatchNodeNumOfDevicesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNodeNumOfDevices(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNodeNumOfDevices(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_node_num_of_devices_args *args,
    remote_node_num_of_devices_ret *ret)
{
    int rv = -1;
    char *cap;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    cap = args->cap ? *args->cap : NULL;

    if ((num = virNodeNumOfDevices(priv->conn, cap, args->flags)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfDefinedDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_defined_domains_ret *ret);
static int remoteDispatchNumOfDefinedDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfDefinedDomains(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfDefinedDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_defined_domains_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedDomains(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfDefinedInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_defined_interfaces_ret *ret);
static int remoteDispatchNumOfDefinedInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfDefinedInterfaces(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfDefinedInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_defined_interfaces_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedInterfaces(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfDefinedNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_defined_networks_ret *ret);
static int remoteDispatchNumOfDefinedNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfDefinedNetworks(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfDefinedNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_defined_networks_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedNetworks(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfDefinedStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_defined_storage_pools_ret *ret);
static int remoteDispatchNumOfDefinedStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfDefinedStoragePools(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfDefinedStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_defined_storage_pools_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDefinedStoragePools(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfDomains(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_domains_ret *ret);
static int remoteDispatchNumOfDomainsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfDomains(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfDomains(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_domains_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfDomains(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfInterfaces(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_interfaces_ret *ret);
static int remoteDispatchNumOfInterfacesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfInterfaces(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfInterfaces(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_interfaces_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfInterfaces(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfNetworks(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_networks_ret *ret);
static int remoteDispatchNumOfNetworksHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfNetworks(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfNetworks(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_networks_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfNetworks(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfNWFilters(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_nwfilters_ret *ret);
static int remoteDispatchNumOfNWFiltersHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfNWFilters(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfNWFilters(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_nwfilters_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfNWFilters(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfSecrets(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_secrets_ret *ret);
static int remoteDispatchNumOfSecretsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfSecrets(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfSecrets(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_secrets_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfSecrets(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNumOfStoragePools(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_num_of_storage_pools_ret *ret);
static int remoteDispatchNumOfStoragePoolsHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args ATTRIBUTE_UNUSED,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNumOfStoragePools(server, client, hdr, rerr, ret);
}
static int remoteDispatchNumOfStoragePools(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_num_of_storage_pools_ret *ret)
{
    int rv = -1;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((num = virConnectNumOfStoragePools(priv->conn)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



static int remoteDispatchNWFilterDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_define_xml_args *args,
    remote_nwfilter_define_xml_ret *ret);
static int remoteDispatchNWFilterDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNWFilterDefineXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNWFilterDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_define_xml_args *args,
    remote_nwfilter_define_xml_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterDefineXML(priv->conn, args->xml)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_get_xml_desc_args *args,
    remote_nwfilter_get_xml_desc_ret *ret);
static int remoteDispatchNWFilterGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNWFilterGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNWFilterGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_get_xml_desc_args *args,
    remote_nwfilter_get_xml_desc_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(nwfilter = get_nonnull_nwfilter(priv->conn, args->nwfilter)))
        goto cleanup;

    if ((xml = virNWFilterGetXMLDesc(nwfilter, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_lookup_by_name_args *args,
    remote_nwfilter_lookup_by_name_ret *ret);
static int remoteDispatchNWFilterLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNWFilterLookupByName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNWFilterLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_lookup_by_name_args *args,
    remote_nwfilter_lookup_by_name_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_lookup_by_uuid_args *args,
    remote_nwfilter_lookup_by_uuid_ret *ret);
static int remoteDispatchNWFilterLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNWFilterLookupByUUID(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchNWFilterLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_lookup_by_uuid_args *args,
    remote_nwfilter_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((nwfilter = virNWFilterLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_nwfilter(&ret->nwfilter, nwfilter);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}



static int remoteDispatchNWFilterUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_undefine_args *args);
static int remoteDispatchNWFilterUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchNWFilterUndefine(server, client, hdr, rerr, args);
}
static int remoteDispatchNWFilterUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_nwfilter_undefine_args *args)
{
    int rv = -1;
    virNWFilterPtr nwfilter = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(nwfilter = get_nonnull_nwfilter(priv->conn, args->nwfilter)))
        goto cleanup;

    if (virNWFilterUndefine(nwfilter) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (nwfilter)
        virNWFilterFree(nwfilter);
    return rv;
}



static int remoteDispatchOpen(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_open_args *args);
static int remoteDispatchOpenHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchOpen(server, client, hdr, rerr, args);
}
/* remoteDispatchOpen body has to be implemented manually */



static int remoteDispatchSecretDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_secret_define_xml_args *args,
    remote_secret_define_xml_ret *ret);
static int remoteDispatchSecretDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchSecretDefineXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchSecretDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_define_xml_args *args,
    remote_secret_define_xml_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretDefineXML(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}



static int remoteDispatchSecretGetValue(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_secret_get_value_args *args,
    remote_secret_get_value_ret *ret);
static int remoteDispatchSecretGetValueHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchSecretGetValue(server, client, hdr, rerr, args, ret);
}
/* remoteDispatchSecretGetValue body has to be implemented manually */



static int remoteDispatchSecretGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_secret_get_xml_desc_args *args,
    remote_secret_get_xml_desc_ret *ret);
static int remoteDispatchSecretGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchSecretGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchSecretGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_get_xml_desc_args *args,
    remote_secret_get_xml_desc_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(priv->conn, args->secret)))
        goto cleanup;

    if ((xml = virSecretGetXMLDesc(secret, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}



static int remoteDispatchSecretLookupByUsage(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_secret_lookup_by_usage_args *args,
    remote_secret_lookup_by_usage_ret *ret);
static int remoteDispatchSecretLookupByUsageHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchSecretLookupByUsage(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchSecretLookupByUsage(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_lookup_by_usage_args *args,
    remote_secret_lookup_by_usage_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretLookupByUsage(priv->conn, args->usageType, args->usageID)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}



static int remoteDispatchSecretLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_secret_lookup_by_uuid_args *args,
    remote_secret_lookup_by_uuid_ret *ret);
static int remoteDispatchSecretLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchSecretLookupByUUID(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchSecretLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_lookup_by_uuid_args *args,
    remote_secret_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((secret = virSecretLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_secret(&ret->secret, secret);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}



static int remoteDispatchSecretSetValue(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_secret_set_value_args *args);
static int remoteDispatchSecretSetValueHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchSecretSetValue(server, client, hdr, rerr, args);
}
static int remoteDispatchSecretSetValue(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_set_value_args *args)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(priv->conn, args->secret)))
        goto cleanup;

    if (virSecretSetValue(secret, (const unsigned char *) args->value.value_val, args->value.value_len, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}



static int remoteDispatchSecretUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_secret_undefine_args *args);
static int remoteDispatchSecretUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchSecretUndefine(server, client, hdr, rerr, args);
}
static int remoteDispatchSecretUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_secret_undefine_args *args)
{
    int rv = -1;
    virSecretPtr secret = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(secret = get_nonnull_secret(priv->conn, args->secret)))
        goto cleanup;

    if (virSecretUndefine(secret) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (secret)
        virSecretFree(secret);
    return rv;
}



static int remoteDispatchStoragePoolBuild(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_build_args *args);
static int remoteDispatchStoragePoolBuildHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolBuild(server, client, hdr, rerr, args);
}
static int remoteDispatchStoragePoolBuild(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_build_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolBuild(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolCreate(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_create_args *args);
static int remoteDispatchStoragePoolCreateHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolCreate(server, client, hdr, rerr, args);
}
static int remoteDispatchStoragePoolCreate(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_create_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolCreate(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_create_xml_args *args,
    remote_storage_pool_create_xml_ret *ret);
static int remoteDispatchStoragePoolCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolCreateXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_create_xml_args *args,
    remote_storage_pool_create_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolCreateXML(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolDefineXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_define_xml_args *args,
    remote_storage_pool_define_xml_ret *ret);
static int remoteDispatchStoragePoolDefineXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolDefineXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolDefineXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_define_xml_args *args,
    remote_storage_pool_define_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolDefineXML(priv->conn, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolDelete(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_delete_args *args);
static int remoteDispatchStoragePoolDeleteHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolDelete(server, client, hdr, rerr, args);
}
static int remoteDispatchStoragePoolDelete(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_delete_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolDelete(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolDestroy(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_destroy_args *args);
static int remoteDispatchStoragePoolDestroyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolDestroy(server, client, hdr, rerr, args);
}
static int remoteDispatchStoragePoolDestroy(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_destroy_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolDestroy(pool) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_autostart_args *args,
    remote_storage_pool_get_autostart_ret *ret);
static int remoteDispatchStoragePoolGetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolGetAutostart(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolGetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_autostart_args *args,
    remote_storage_pool_get_autostart_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int autostart;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolGetAutostart(pool, &autostart) < 0)
        goto cleanup;

    ret->autostart = autostart;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_info_args *args,
    remote_storage_pool_get_info_ret *ret);
static int remoteDispatchStoragePoolGetInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolGetInfo(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolGetInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_info_args *args,
    remote_storage_pool_get_info_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStoragePoolInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolGetInfo(pool, &tmp) < 0)
        goto cleanup;

    ret->state = tmp.state;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    ret->available = tmp.available;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_xml_desc_args *args,
    remote_storage_pool_get_xml_desc_ret *ret);
static int remoteDispatchStoragePoolGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_get_xml_desc_args *args,
    remote_storage_pool_get_xml_desc_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((xml = virStoragePoolGetXMLDesc(pool, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolIsActive(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_is_active_args *args,
    remote_storage_pool_is_active_ret *ret);
static int remoteDispatchStoragePoolIsActiveHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolIsActive(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolIsActive(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_is_active_args *args,
    remote_storage_pool_is_active_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int active;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((active = virStoragePoolIsActive(pool)) < 0)
        goto cleanup;

    ret->active = active;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolIsPersistent(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_is_persistent_args *args,
    remote_storage_pool_is_persistent_ret *ret);
static int remoteDispatchStoragePoolIsPersistentHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolIsPersistent(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolIsPersistent(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_is_persistent_args *args,
    remote_storage_pool_is_persistent_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int persistent;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((persistent = virStoragePoolIsPersistent(pool)) < 0)
        goto cleanup;

    ret->persistent = persistent;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolListVolumes(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_list_volumes_args *args,
    remote_storage_pool_list_volumes_ret *ret);
static int remoteDispatchStoragePoolListVolumesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolListVolumes(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolListVolumes(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_list_volumes_args *args,
    remote_storage_pool_list_volumes_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int len;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (args->maxnames > REMOTE_STORAGE_VOL_NAME_LIST_MAX) {
        virNetError(VIR_ERR_INTERNAL_ERROR,
                    "%s", _("maxnames > REMOTE_STORAGE_VOL_NAME_LIST_MAX"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    /* Allocate return buffer. */
    if (VIR_ALLOC_N(ret->names.names_val, args->maxnames) < 0) {
        virReportOOMError();
        goto cleanup;
    }

    if ((len = virStoragePoolListVolumes(pool, ret->names.names_val, args->maxnames)) < 0)
        goto cleanup;

    ret->names.names_len = len;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(ret->names.names_val);
    }
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_name_args *args,
    remote_storage_pool_lookup_by_name_ret *ret);
static int remoteDispatchStoragePoolLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolLookupByName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_name_args *args,
    remote_storage_pool_lookup_by_name_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolLookupByName(priv->conn, args->name)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByUUID(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_uuid_args *args,
    remote_storage_pool_lookup_by_uuid_ret *ret);
static int remoteDispatchStoragePoolLookupByUUIDHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolLookupByUUID(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolLookupByUUID(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_uuid_args *args,
    remote_storage_pool_lookup_by_uuid_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((pool = virStoragePoolLookupByUUID(priv->conn, (unsigned char *) args->uuid)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolLookupByVolume(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_volume_args *args,
    remote_storage_pool_lookup_by_volume_ret *ret);
static int remoteDispatchStoragePoolLookupByVolumeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolLookupByVolume(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolLookupByVolume(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_lookup_by_volume_args *args,
    remote_storage_pool_lookup_by_volume_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if ((pool = virStoragePoolLookupByVolume(vol)) == NULL)
        goto cleanup;

    make_nonnull_storage_pool(&ret->pool, pool);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (vol)
        virStorageVolFree(vol);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolNumOfVolumes(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_num_of_volumes_args *args,
    remote_storage_pool_num_of_volumes_ret *ret);
static int remoteDispatchStoragePoolNumOfVolumesHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolNumOfVolumes(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStoragePoolNumOfVolumes(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_num_of_volumes_args *args,
    remote_storage_pool_num_of_volumes_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    int num;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((num = virStoragePoolNumOfVolumes(pool)) < 0)
        goto cleanup;

    ret->num = num;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolRefresh(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_refresh_args *args);
static int remoteDispatchStoragePoolRefreshHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolRefresh(server, client, hdr, rerr, args);
}
static int remoteDispatchStoragePoolRefresh(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_refresh_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolRefresh(pool, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolSetAutostart(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_set_autostart_args *args);
static int remoteDispatchStoragePoolSetAutostartHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolSetAutostart(server, client, hdr, rerr, args);
}
static int remoteDispatchStoragePoolSetAutostart(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_set_autostart_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolSetAutostart(pool, args->autostart) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStoragePoolUndefine(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_undefine_args *args);
static int remoteDispatchStoragePoolUndefineHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStoragePoolUndefine(server, client, hdr, rerr, args);
}
static int remoteDispatchStoragePoolUndefine(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_pool_undefine_args *args)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (virStoragePoolUndefine(pool) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    return rv;
}



static int remoteDispatchStorageVolCreateXML(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_create_xml_args *args,
    remote_storage_vol_create_xml_ret *ret);
static int remoteDispatchStorageVolCreateXMLHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolCreateXML(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStorageVolCreateXML(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_create_xml_args *args,
    remote_storage_vol_create_xml_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((vol = virStorageVolCreateXML(pool, args->xml, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolCreateXMLFrom(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_create_xml_from_args *args,
    remote_storage_vol_create_xml_from_ret *ret);
static int remoteDispatchStorageVolCreateXMLFromHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolCreateXMLFrom(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStorageVolCreateXMLFrom(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_create_xml_from_args *args,
    remote_storage_vol_create_xml_from_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr clonevol = NULL;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if (!(clonevol = get_nonnull_storage_vol(priv->conn, args->clonevol)))
        goto cleanup;

    if ((vol = virStorageVolCreateXMLFrom(pool, args->xml, clonevol, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    if (clonevol)
        virStorageVolFree(clonevol);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolDelete(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_delete_args *args);
static int remoteDispatchStorageVolDeleteHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolDelete(server, client, hdr, rerr, args);
}
static int remoteDispatchStorageVolDelete(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_delete_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (virStorageVolDelete(vol, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolDownload(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_download_args *args);
static int remoteDispatchStorageVolDownloadHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolDownload(server, client, hdr, rerr, args);
}
static int remoteDispatchStorageVolDownload(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_download_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, hdr)))
        goto cleanup;

    if (virStorageVolDownload(vol, st, args->offset, args->length, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, true) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virStreamFree(st);
        }
    }
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolGetInfo(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_info_args *args,
    remote_storage_vol_get_info_ret *ret);
static int remoteDispatchStorageVolGetInfoHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolGetInfo(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStorageVolGetInfo(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_info_args *args,
    remote_storage_vol_get_info_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    virStorageVolInfo tmp;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (virStorageVolGetInfo(vol, &tmp) < 0)
        goto cleanup;

    ret->type = tmp.type;
    ret->capacity = tmp.capacity;
    ret->allocation = tmp.allocation;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolGetPath(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_path_args *args,
    remote_storage_vol_get_path_ret *ret);
static int remoteDispatchStorageVolGetPathHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolGetPath(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStorageVolGetPath(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_path_args *args,
    remote_storage_vol_get_path_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    char *name;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if ((name = virStorageVolGetPath(vol)) == NULL)
        goto cleanup;

    ret->name = name;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolGetXMLDesc(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_xml_desc_args *args,
    remote_storage_vol_get_xml_desc_ret *ret);
static int remoteDispatchStorageVolGetXMLDescHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolGetXMLDesc(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStorageVolGetXMLDesc(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_get_xml_desc_args *args,
    remote_storage_vol_get_xml_desc_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    char *xml;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if ((xml = virStorageVolGetXMLDesc(vol, args->flags)) == NULL)
        goto cleanup;

    ret->xml = xml;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByKey(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_key_args *args,
    remote_storage_vol_lookup_by_key_ret *ret);
static int remoteDispatchStorageVolLookupByKeyHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolLookupByKey(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStorageVolLookupByKey(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_key_args *args,
    remote_storage_vol_lookup_by_key_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((vol = virStorageVolLookupByKey(priv->conn, args->key)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByName(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_name_args *args,
    remote_storage_vol_lookup_by_name_ret *ret);
static int remoteDispatchStorageVolLookupByNameHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolLookupByName(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStorageVolLookupByName(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_name_args *args,
    remote_storage_vol_lookup_by_name_ret *ret)
{
    int rv = -1;
    virStoragePoolPtr pool = NULL;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(pool = get_nonnull_storage_pool(priv->conn, args->pool)))
        goto cleanup;

    if ((vol = virStorageVolLookupByName(pool, args->name)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (pool)
        virStoragePoolFree(pool);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolLookupByPath(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_path_args *args,
    remote_storage_vol_lookup_by_path_ret *ret);
static int remoteDispatchStorageVolLookupByPathHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolLookupByPath(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchStorageVolLookupByPath(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_lookup_by_path_args *args,
    remote_storage_vol_lookup_by_path_ret *ret)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((vol = virStorageVolLookupByPath(priv->conn, args->path)) == NULL)
        goto cleanup;

    make_nonnull_storage_vol(&ret->vol, vol);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolUpload(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_upload_args *args);
static int remoteDispatchStorageVolUploadHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolUpload(server, client, hdr, rerr, args);
}
static int remoteDispatchStorageVolUpload(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_upload_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);
    virStreamPtr st = NULL;
    daemonClientStreamPtr stream = NULL;

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (!(st = virStreamNew(priv->conn, VIR_STREAM_NONBLOCK)))
        goto cleanup;

    if (!(stream = daemonCreateClientStream(client, st, remoteProgram, hdr)))
        goto cleanup;

    if (virStorageVolUpload(vol, st, args->offset, args->length, args->flags) < 0)
        goto cleanup;

    if (daemonAddClientStream(client, stream, false) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        if (stream) {
            virStreamAbort(st);
            daemonFreeClientStream(client, stream);
        } else {
            virStreamFree(st);
        }
    }
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchStorageVolWipe(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_wipe_args *args);
static int remoteDispatchStorageVolWipeHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret ATTRIBUTE_UNUSED)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchStorageVolWipe(server, client, hdr, rerr, args);
}
static int remoteDispatchStorageVolWipe(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_storage_vol_wipe_args *args)
{
    int rv = -1;
    virStorageVolPtr vol = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(vol = get_nonnull_storage_vol(priv->conn, args->vol)))
        goto cleanup;

    if (virStorageVolWipe(vol, args->flags) < 0)
        goto cleanup;

    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (vol)
        virStorageVolFree(vol);
    return rv;
}



static int remoteDispatchSupportsFeature(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    remote_supports_feature_args *args,
    remote_supports_feature_ret *ret);
static int remoteDispatchSupportsFeatureHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p hdr=%p rerr=%p args=%p ret=%p", server, client, hdr, rerr, args, ret);
  return remoteDispatchSupportsFeature(server, client, hdr, rerr, args, ret);
}
static int remoteDispatchSupportsFeature(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessageHeaderPtr hdr ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    remote_supports_feature_args *args,
    remote_supports_feature_ret *ret)
{
    int rv = -1;
    int supported;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virNetError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((supported = virDrvSupportsFeature(priv->conn, args->feature)) < 0)
        goto cleanup;

    ret->supported = supported;
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    return rv;
}



virNetServerProgramProc remoteProcs[] = {
{ /* Unused 0 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method Open => 1 */
   remoteDispatchOpenHelper,
   sizeof(remote_open_args),
   (xdrproc_t)xdr_remote_open_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method Close => 2 */
   remoteDispatchCloseHelper,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method GetType => 3 */
   remoteDispatchGetTypeHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_get_type_ret),
   (xdrproc_t)xdr_remote_get_type_ret,
   true 
},
{ /* Method GetVersion => 4 */
   remoteDispatchGetVersionHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_get_version_ret),
   (xdrproc_t)xdr_remote_get_version_ret,
   true 
},
{ /* Method GetMaxVcpus => 5 */
   remoteDispatchGetMaxVcpusHelper,
   sizeof(remote_get_max_vcpus_args),
   (xdrproc_t)xdr_remote_get_max_vcpus_args,
   sizeof(remote_get_max_vcpus_ret),
   (xdrproc_t)xdr_remote_get_max_vcpus_ret,
   true 
},
{ /* Method NodeGetInfo => 6 */
   remoteDispatchNodeGetInfoHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_info_ret),
   (xdrproc_t)xdr_remote_node_get_info_ret,
   true 
},
{ /* Method GetCapabilities => 7 */
   remoteDispatchGetCapabilitiesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_get_capabilities_ret),
   (xdrproc_t)xdr_remote_get_capabilities_ret,
   true 
},
{ /* Method DomainAttachDevice => 8 */
   remoteDispatchDomainAttachDeviceHelper,
   sizeof(remote_domain_attach_device_args),
   (xdrproc_t)xdr_remote_domain_attach_device_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainCreate => 9 */
   remoteDispatchDomainCreateHelper,
   sizeof(remote_domain_create_args),
   (xdrproc_t)xdr_remote_domain_create_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainCreateXML => 10 */
   remoteDispatchDomainCreateXMLHelper,
   sizeof(remote_domain_create_xml_args),
   (xdrproc_t)xdr_remote_domain_create_xml_args,
   sizeof(remote_domain_create_xml_ret),
   (xdrproc_t)xdr_remote_domain_create_xml_ret,
   true 
},
{ /* Method DomainDefineXML => 11 */
   remoteDispatchDomainDefineXMLHelper,
   sizeof(remote_domain_define_xml_args),
   (xdrproc_t)xdr_remote_domain_define_xml_args,
   sizeof(remote_domain_define_xml_ret),
   (xdrproc_t)xdr_remote_domain_define_xml_ret,
   true 
},
{ /* Method DomainDestroy => 12 */
   remoteDispatchDomainDestroyHelper,
   sizeof(remote_domain_destroy_args),
   (xdrproc_t)xdr_remote_domain_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainDetachDevice => 13 */
   remoteDispatchDomainDetachDeviceHelper,
   sizeof(remote_domain_detach_device_args),
   (xdrproc_t)xdr_remote_domain_detach_device_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetXMLDesc => 14 */
   remoteDispatchDomainGetXMLDescHelper,
   sizeof(remote_domain_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_get_xml_desc_args,
   sizeof(remote_domain_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_get_xml_desc_ret,
   true 
},
{ /* Method DomainGetAutostart => 15 */
   remoteDispatchDomainGetAutostartHelper,
   sizeof(remote_domain_get_autostart_args),
   (xdrproc_t)xdr_remote_domain_get_autostart_args,
   sizeof(remote_domain_get_autostart_ret),
   (xdrproc_t)xdr_remote_domain_get_autostart_ret,
   true 
},
{ /* Method DomainGetInfo => 16 */
   remoteDispatchDomainGetInfoHelper,
   sizeof(remote_domain_get_info_args),
   (xdrproc_t)xdr_remote_domain_get_info_args,
   sizeof(remote_domain_get_info_ret),
   (xdrproc_t)xdr_remote_domain_get_info_ret,
   true 
},
{ /* Method DomainGetMaxMemory => 17 */
   remoteDispatchDomainGetMaxMemoryHelper,
   sizeof(remote_domain_get_max_memory_args),
   (xdrproc_t)xdr_remote_domain_get_max_memory_args,
   sizeof(remote_domain_get_max_memory_ret),
   (xdrproc_t)xdr_remote_domain_get_max_memory_ret,
   true 
},
{ /* Method DomainGetMaxVcpus => 18 */
   remoteDispatchDomainGetMaxVcpusHelper,
   sizeof(remote_domain_get_max_vcpus_args),
   (xdrproc_t)xdr_remote_domain_get_max_vcpus_args,
   sizeof(remote_domain_get_max_vcpus_ret),
   (xdrproc_t)xdr_remote_domain_get_max_vcpus_ret,
   true 
},
{ /* Method DomainGetOSType => 19 */
   remoteDispatchDomainGetOSTypeHelper,
   sizeof(remote_domain_get_os_type_args),
   (xdrproc_t)xdr_remote_domain_get_os_type_args,
   sizeof(remote_domain_get_os_type_ret),
   (xdrproc_t)xdr_remote_domain_get_os_type_ret,
   true 
},
{ /* Method DomainGetVcpus => 20 */
   remoteDispatchDomainGetVcpusHelper,
   sizeof(remote_domain_get_vcpus_args),
   (xdrproc_t)xdr_remote_domain_get_vcpus_args,
   sizeof(remote_domain_get_vcpus_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpus_ret,
   true 
},
{ /* Method ListDefinedDomains => 21 */
   remoteDispatchListDefinedDomainsHelper,
   sizeof(remote_list_defined_domains_args),
   (xdrproc_t)xdr_remote_list_defined_domains_args,
   sizeof(remote_list_defined_domains_ret),
   (xdrproc_t)xdr_remote_list_defined_domains_ret,
   true 
},
{ /* Method DomainLookupByID => 22 */
   remoteDispatchDomainLookupByIDHelper,
   sizeof(remote_domain_lookup_by_id_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_id_args,
   sizeof(remote_domain_lookup_by_id_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_id_ret,
   true 
},
{ /* Method DomainLookupByName => 23 */
   remoteDispatchDomainLookupByNameHelper,
   sizeof(remote_domain_lookup_by_name_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_name_args,
   sizeof(remote_domain_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_name_ret,
   true 
},
{ /* Method DomainLookupByUUID => 24 */
   remoteDispatchDomainLookupByUUIDHelper,
   sizeof(remote_domain_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_domain_lookup_by_uuid_args,
   sizeof(remote_domain_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_domain_lookup_by_uuid_ret,
   true 
},
{ /* Method NumOfDefinedDomains => 25 */
   remoteDispatchNumOfDefinedDomainsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_defined_domains_ret),
   (xdrproc_t)xdr_remote_num_of_defined_domains_ret,
   true 
},
{ /* Method DomainPinVcpu => 26 */
   remoteDispatchDomainPinVcpuHelper,
   sizeof(remote_domain_pin_vcpu_args),
   (xdrproc_t)xdr_remote_domain_pin_vcpu_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainReboot => 27 */
   remoteDispatchDomainRebootHelper,
   sizeof(remote_domain_reboot_args),
   (xdrproc_t)xdr_remote_domain_reboot_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainResume => 28 */
   remoteDispatchDomainResumeHelper,
   sizeof(remote_domain_resume_args),
   (xdrproc_t)xdr_remote_domain_resume_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSetAutostart => 29 */
   remoteDispatchDomainSetAutostartHelper,
   sizeof(remote_domain_set_autostart_args),
   (xdrproc_t)xdr_remote_domain_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSetMaxMemory => 30 */
   remoteDispatchDomainSetMaxMemoryHelper,
   sizeof(remote_domain_set_max_memory_args),
   (xdrproc_t)xdr_remote_domain_set_max_memory_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSetMemory => 31 */
   remoteDispatchDomainSetMemoryHelper,
   sizeof(remote_domain_set_memory_args),
   (xdrproc_t)xdr_remote_domain_set_memory_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSetVcpus => 32 */
   remoteDispatchDomainSetVcpusHelper,
   sizeof(remote_domain_set_vcpus_args),
   (xdrproc_t)xdr_remote_domain_set_vcpus_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainShutdown => 33 */
   remoteDispatchDomainShutdownHelper,
   sizeof(remote_domain_shutdown_args),
   (xdrproc_t)xdr_remote_domain_shutdown_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSuspend => 34 */
   remoteDispatchDomainSuspendHelper,
   sizeof(remote_domain_suspend_args),
   (xdrproc_t)xdr_remote_domain_suspend_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainUndefine => 35 */
   remoteDispatchDomainUndefineHelper,
   sizeof(remote_domain_undefine_args),
   (xdrproc_t)xdr_remote_domain_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method ListDefinedNetworks => 36 */
   remoteDispatchListDefinedNetworksHelper,
   sizeof(remote_list_defined_networks_args),
   (xdrproc_t)xdr_remote_list_defined_networks_args,
   sizeof(remote_list_defined_networks_ret),
   (xdrproc_t)xdr_remote_list_defined_networks_ret,
   true 
},
{ /* Method ListDomains => 37 */
   remoteDispatchListDomainsHelper,
   sizeof(remote_list_domains_args),
   (xdrproc_t)xdr_remote_list_domains_args,
   sizeof(remote_list_domains_ret),
   (xdrproc_t)xdr_remote_list_domains_ret,
   true 
},
{ /* Method ListNetworks => 38 */
   remoteDispatchListNetworksHelper,
   sizeof(remote_list_networks_args),
   (xdrproc_t)xdr_remote_list_networks_args,
   sizeof(remote_list_networks_ret),
   (xdrproc_t)xdr_remote_list_networks_ret,
   true 
},
{ /* Method NetworkCreate => 39 */
   remoteDispatchNetworkCreateHelper,
   sizeof(remote_network_create_args),
   (xdrproc_t)xdr_remote_network_create_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method NetworkCreateXML => 40 */
   remoteDispatchNetworkCreateXMLHelper,
   sizeof(remote_network_create_xml_args),
   (xdrproc_t)xdr_remote_network_create_xml_args,
   sizeof(remote_network_create_xml_ret),
   (xdrproc_t)xdr_remote_network_create_xml_ret,
   true 
},
{ /* Method NetworkDefineXML => 41 */
   remoteDispatchNetworkDefineXMLHelper,
   sizeof(remote_network_define_xml_args),
   (xdrproc_t)xdr_remote_network_define_xml_args,
   sizeof(remote_network_define_xml_ret),
   (xdrproc_t)xdr_remote_network_define_xml_ret,
   true 
},
{ /* Method NetworkDestroy => 42 */
   remoteDispatchNetworkDestroyHelper,
   sizeof(remote_network_destroy_args),
   (xdrproc_t)xdr_remote_network_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method NetworkGetXMLDesc => 43 */
   remoteDispatchNetworkGetXMLDescHelper,
   sizeof(remote_network_get_xml_desc_args),
   (xdrproc_t)xdr_remote_network_get_xml_desc_args,
   sizeof(remote_network_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_network_get_xml_desc_ret,
   true 
},
{ /* Method NetworkGetAutostart => 44 */
   remoteDispatchNetworkGetAutostartHelper,
   sizeof(remote_network_get_autostart_args),
   (xdrproc_t)xdr_remote_network_get_autostart_args,
   sizeof(remote_network_get_autostart_ret),
   (xdrproc_t)xdr_remote_network_get_autostart_ret,
   true 
},
{ /* Method NetworkGetBridgeName => 45 */
   remoteDispatchNetworkGetBridgeNameHelper,
   sizeof(remote_network_get_bridge_name_args),
   (xdrproc_t)xdr_remote_network_get_bridge_name_args,
   sizeof(remote_network_get_bridge_name_ret),
   (xdrproc_t)xdr_remote_network_get_bridge_name_ret,
   true 
},
{ /* Method NetworkLookupByName => 46 */
   remoteDispatchNetworkLookupByNameHelper,
   sizeof(remote_network_lookup_by_name_args),
   (xdrproc_t)xdr_remote_network_lookup_by_name_args,
   sizeof(remote_network_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_network_lookup_by_name_ret,
   true 
},
{ /* Method NetworkLookupByUUID => 47 */
   remoteDispatchNetworkLookupByUUIDHelper,
   sizeof(remote_network_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_network_lookup_by_uuid_args,
   sizeof(remote_network_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_network_lookup_by_uuid_ret,
   true 
},
{ /* Method NetworkSetAutostart => 48 */
   remoteDispatchNetworkSetAutostartHelper,
   sizeof(remote_network_set_autostart_args),
   (xdrproc_t)xdr_remote_network_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method NetworkUndefine => 49 */
   remoteDispatchNetworkUndefineHelper,
   sizeof(remote_network_undefine_args),
   (xdrproc_t)xdr_remote_network_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method NumOfDefinedNetworks => 50 */
   remoteDispatchNumOfDefinedNetworksHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_defined_networks_ret),
   (xdrproc_t)xdr_remote_num_of_defined_networks_ret,
   true 
},
{ /* Method NumOfDomains => 51 */
   remoteDispatchNumOfDomainsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_domains_ret),
   (xdrproc_t)xdr_remote_num_of_domains_ret,
   true 
},
{ /* Method NumOfNetworks => 52 */
   remoteDispatchNumOfNetworksHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_networks_ret),
   (xdrproc_t)xdr_remote_num_of_networks_ret,
   true 
},
{ /* Method DomainCoreDump => 53 */
   remoteDispatchDomainCoreDumpHelper,
   sizeof(remote_domain_core_dump_args),
   (xdrproc_t)xdr_remote_domain_core_dump_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainRestore => 54 */
   remoteDispatchDomainRestoreHelper,
   sizeof(remote_domain_restore_args),
   (xdrproc_t)xdr_remote_domain_restore_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSave => 55 */
   remoteDispatchDomainSaveHelper,
   sizeof(remote_domain_save_args),
   (xdrproc_t)xdr_remote_domain_save_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetSchedulerType => 56 */
   remoteDispatchDomainGetSchedulerTypeHelper,
   sizeof(remote_domain_get_scheduler_type_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_type_args,
   sizeof(remote_domain_get_scheduler_type_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_type_ret,
   true 
},
{ /* Method DomainGetSchedulerParameters => 57 */
   remoteDispatchDomainGetSchedulerParametersHelper,
   sizeof(remote_domain_get_scheduler_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_args,
   sizeof(remote_domain_get_scheduler_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_ret,
   true 
},
{ /* Method DomainSetSchedulerParameters => 58 */
   remoteDispatchDomainSetSchedulerParametersHelper,
   sizeof(remote_domain_set_scheduler_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_scheduler_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method GetHostname => 59 */
   remoteDispatchGetHostnameHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_get_hostname_ret),
   (xdrproc_t)xdr_remote_get_hostname_ret,
   true 
},
{ /* Method SupportsFeature => 60 */
   remoteDispatchSupportsFeatureHelper,
   sizeof(remote_supports_feature_args),
   (xdrproc_t)xdr_remote_supports_feature_args,
   sizeof(remote_supports_feature_ret),
   (xdrproc_t)xdr_remote_supports_feature_ret,
   true 
},
{ /* Method DomainMigratePrepare => 61 */
   remoteDispatchDomainMigratePrepareHelper,
   sizeof(remote_domain_migrate_prepare_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_args,
   sizeof(remote_domain_migrate_prepare_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_ret,
   true 
},
{ /* Method DomainMigratePerform => 62 */
   remoteDispatchDomainMigratePerformHelper,
   sizeof(remote_domain_migrate_perform_args),
   (xdrproc_t)xdr_remote_domain_migrate_perform_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainMigrateFinish => 63 */
   remoteDispatchDomainMigrateFinishHelper,
   sizeof(remote_domain_migrate_finish_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish_args,
   sizeof(remote_domain_migrate_finish_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish_ret,
   true 
},
{ /* Method DomainBlockStats => 64 */
   remoteDispatchDomainBlockStatsHelper,
   sizeof(remote_domain_block_stats_args),
   (xdrproc_t)xdr_remote_domain_block_stats_args,
   sizeof(remote_domain_block_stats_ret),
   (xdrproc_t)xdr_remote_domain_block_stats_ret,
   true 
},
{ /* Method DomainInterfaceStats => 65 */
   remoteDispatchDomainInterfaceStatsHelper,
   sizeof(remote_domain_interface_stats_args),
   (xdrproc_t)xdr_remote_domain_interface_stats_args,
   sizeof(remote_domain_interface_stats_ret),
   (xdrproc_t)xdr_remote_domain_interface_stats_ret,
   true 
},
{ /* Method AuthList => 66 */
   remoteDispatchAuthListHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_list_ret),
   (xdrproc_t)xdr_remote_auth_list_ret,
   true 
},
{ /* Method AuthSaslInit => 67 */
   remoteDispatchAuthSaslInitHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_sasl_init_ret),
   (xdrproc_t)xdr_remote_auth_sasl_init_ret,
   true 
},
{ /* Method AuthSaslStart => 68 */
   remoteDispatchAuthSaslStartHelper,
   sizeof(remote_auth_sasl_start_args),
   (xdrproc_t)xdr_remote_auth_sasl_start_args,
   sizeof(remote_auth_sasl_start_ret),
   (xdrproc_t)xdr_remote_auth_sasl_start_ret,
   true 
},
{ /* Method AuthSaslStep => 69 */
   remoteDispatchAuthSaslStepHelper,
   sizeof(remote_auth_sasl_step_args),
   (xdrproc_t)xdr_remote_auth_sasl_step_args,
   sizeof(remote_auth_sasl_step_ret),
   (xdrproc_t)xdr_remote_auth_sasl_step_ret,
   true 
},
{ /* Method AuthPolkit => 70 */
   remoteDispatchAuthPolkitHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_auth_polkit_ret),
   (xdrproc_t)xdr_remote_auth_polkit_ret,
   true 
},
{ /* Method NumOfStoragePools => 71 */
   remoteDispatchNumOfStoragePoolsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_storage_pools_ret),
   (xdrproc_t)xdr_remote_num_of_storage_pools_ret,
   true 
},
{ /* Method ListStoragePools => 72 */
   remoteDispatchListStoragePoolsHelper,
   sizeof(remote_list_storage_pools_args),
   (xdrproc_t)xdr_remote_list_storage_pools_args,
   sizeof(remote_list_storage_pools_ret),
   (xdrproc_t)xdr_remote_list_storage_pools_ret,
   true 
},
{ /* Method NumOfDefinedStoragePools => 73 */
   remoteDispatchNumOfDefinedStoragePoolsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_defined_storage_pools_ret),
   (xdrproc_t)xdr_remote_num_of_defined_storage_pools_ret,
   true 
},
{ /* Method ListDefinedStoragePools => 74 */
   remoteDispatchListDefinedStoragePoolsHelper,
   sizeof(remote_list_defined_storage_pools_args),
   (xdrproc_t)xdr_remote_list_defined_storage_pools_args,
   sizeof(remote_list_defined_storage_pools_ret),
   (xdrproc_t)xdr_remote_list_defined_storage_pools_ret,
   true 
},
{ /* Method FindStoragePoolSources => 75 */
   remoteDispatchFindStoragePoolSourcesHelper,
   sizeof(remote_find_storage_pool_sources_args),
   (xdrproc_t)xdr_remote_find_storage_pool_sources_args,
   sizeof(remote_find_storage_pool_sources_ret),
   (xdrproc_t)xdr_remote_find_storage_pool_sources_ret,
   true 
},
{ /* Method StoragePoolCreateXML => 76 */
   remoteDispatchStoragePoolCreateXMLHelper,
   sizeof(remote_storage_pool_create_xml_args),
   (xdrproc_t)xdr_remote_storage_pool_create_xml_args,
   sizeof(remote_storage_pool_create_xml_ret),
   (xdrproc_t)xdr_remote_storage_pool_create_xml_ret,
   true 
},
{ /* Method StoragePoolDefineXML => 77 */
   remoteDispatchStoragePoolDefineXMLHelper,
   sizeof(remote_storage_pool_define_xml_args),
   (xdrproc_t)xdr_remote_storage_pool_define_xml_args,
   sizeof(remote_storage_pool_define_xml_ret),
   (xdrproc_t)xdr_remote_storage_pool_define_xml_ret,
   true 
},
{ /* Method StoragePoolCreate => 78 */
   remoteDispatchStoragePoolCreateHelper,
   sizeof(remote_storage_pool_create_args),
   (xdrproc_t)xdr_remote_storage_pool_create_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StoragePoolBuild => 79 */
   remoteDispatchStoragePoolBuildHelper,
   sizeof(remote_storage_pool_build_args),
   (xdrproc_t)xdr_remote_storage_pool_build_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StoragePoolDestroy => 80 */
   remoteDispatchStoragePoolDestroyHelper,
   sizeof(remote_storage_pool_destroy_args),
   (xdrproc_t)xdr_remote_storage_pool_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StoragePoolDelete => 81 */
   remoteDispatchStoragePoolDeleteHelper,
   sizeof(remote_storage_pool_delete_args),
   (xdrproc_t)xdr_remote_storage_pool_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StoragePoolUndefine => 82 */
   remoteDispatchStoragePoolUndefineHelper,
   sizeof(remote_storage_pool_undefine_args),
   (xdrproc_t)xdr_remote_storage_pool_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StoragePoolRefresh => 83 */
   remoteDispatchStoragePoolRefreshHelper,
   sizeof(remote_storage_pool_refresh_args),
   (xdrproc_t)xdr_remote_storage_pool_refresh_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StoragePoolLookupByName => 84 */
   remoteDispatchStoragePoolLookupByNameHelper,
   sizeof(remote_storage_pool_lookup_by_name_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_name_args,
   sizeof(remote_storage_pool_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_name_ret,
   true 
},
{ /* Method StoragePoolLookupByUUID => 85 */
   remoteDispatchStoragePoolLookupByUUIDHelper,
   sizeof(remote_storage_pool_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_uuid_args,
   sizeof(remote_storage_pool_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_uuid_ret,
   true 
},
{ /* Method StoragePoolLookupByVolume => 86 */
   remoteDispatchStoragePoolLookupByVolumeHelper,
   sizeof(remote_storage_pool_lookup_by_volume_args),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_volume_args,
   sizeof(remote_storage_pool_lookup_by_volume_ret),
   (xdrproc_t)xdr_remote_storage_pool_lookup_by_volume_ret,
   true 
},
{ /* Method StoragePoolGetInfo => 87 */
   remoteDispatchStoragePoolGetInfoHelper,
   sizeof(remote_storage_pool_get_info_args),
   (xdrproc_t)xdr_remote_storage_pool_get_info_args,
   sizeof(remote_storage_pool_get_info_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_info_ret,
   true 
},
{ /* Method StoragePoolGetXMLDesc => 88 */
   remoteDispatchStoragePoolGetXMLDescHelper,
   sizeof(remote_storage_pool_get_xml_desc_args),
   (xdrproc_t)xdr_remote_storage_pool_get_xml_desc_args,
   sizeof(remote_storage_pool_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_xml_desc_ret,
   true 
},
{ /* Method StoragePoolGetAutostart => 89 */
   remoteDispatchStoragePoolGetAutostartHelper,
   sizeof(remote_storage_pool_get_autostart_args),
   (xdrproc_t)xdr_remote_storage_pool_get_autostart_args,
   sizeof(remote_storage_pool_get_autostart_ret),
   (xdrproc_t)xdr_remote_storage_pool_get_autostart_ret,
   true 
},
{ /* Method StoragePoolSetAutostart => 90 */
   remoteDispatchStoragePoolSetAutostartHelper,
   sizeof(remote_storage_pool_set_autostart_args),
   (xdrproc_t)xdr_remote_storage_pool_set_autostart_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StoragePoolNumOfVolumes => 91 */
   remoteDispatchStoragePoolNumOfVolumesHelper,
   sizeof(remote_storage_pool_num_of_volumes_args),
   (xdrproc_t)xdr_remote_storage_pool_num_of_volumes_args,
   sizeof(remote_storage_pool_num_of_volumes_ret),
   (xdrproc_t)xdr_remote_storage_pool_num_of_volumes_ret,
   true 
},
{ /* Method StoragePoolListVolumes => 92 */
   remoteDispatchStoragePoolListVolumesHelper,
   sizeof(remote_storage_pool_list_volumes_args),
   (xdrproc_t)xdr_remote_storage_pool_list_volumes_args,
   sizeof(remote_storage_pool_list_volumes_ret),
   (xdrproc_t)xdr_remote_storage_pool_list_volumes_ret,
   true 
},
{ /* Method StorageVolCreateXML => 93 */
   remoteDispatchStorageVolCreateXMLHelper,
   sizeof(remote_storage_vol_create_xml_args),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_args,
   sizeof(remote_storage_vol_create_xml_ret),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_ret,
   true 
},
{ /* Method StorageVolDelete => 94 */
   remoteDispatchStorageVolDeleteHelper,
   sizeof(remote_storage_vol_delete_args),
   (xdrproc_t)xdr_remote_storage_vol_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StorageVolLookupByName => 95 */
   remoteDispatchStorageVolLookupByNameHelper,
   sizeof(remote_storage_vol_lookup_by_name_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_name_args,
   sizeof(remote_storage_vol_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_name_ret,
   true 
},
{ /* Method StorageVolLookupByKey => 96 */
   remoteDispatchStorageVolLookupByKeyHelper,
   sizeof(remote_storage_vol_lookup_by_key_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_key_args,
   sizeof(remote_storage_vol_lookup_by_key_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_key_ret,
   true 
},
{ /* Method StorageVolLookupByPath => 97 */
   remoteDispatchStorageVolLookupByPathHelper,
   sizeof(remote_storage_vol_lookup_by_path_args),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_path_args,
   sizeof(remote_storage_vol_lookup_by_path_ret),
   (xdrproc_t)xdr_remote_storage_vol_lookup_by_path_ret,
   true 
},
{ /* Method StorageVolGetInfo => 98 */
   remoteDispatchStorageVolGetInfoHelper,
   sizeof(remote_storage_vol_get_info_args),
   (xdrproc_t)xdr_remote_storage_vol_get_info_args,
   sizeof(remote_storage_vol_get_info_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_info_ret,
   true 
},
{ /* Method StorageVolGetXMLDesc => 99 */
   remoteDispatchStorageVolGetXMLDescHelper,
   sizeof(remote_storage_vol_get_xml_desc_args),
   (xdrproc_t)xdr_remote_storage_vol_get_xml_desc_args,
   sizeof(remote_storage_vol_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_xml_desc_ret,
   true 
},
{ /* Method StorageVolGetPath => 100 */
   remoteDispatchStorageVolGetPathHelper,
   sizeof(remote_storage_vol_get_path_args),
   (xdrproc_t)xdr_remote_storage_vol_get_path_args,
   sizeof(remote_storage_vol_get_path_ret),
   (xdrproc_t)xdr_remote_storage_vol_get_path_ret,
   true 
},
{ /* Method NodeGetCellsFreeMemory => 101 */
   remoteDispatchNodeGetCellsFreeMemoryHelper,
   sizeof(remote_node_get_cells_free_memory_args),
   (xdrproc_t)xdr_remote_node_get_cells_free_memory_args,
   sizeof(remote_node_get_cells_free_memory_ret),
   (xdrproc_t)xdr_remote_node_get_cells_free_memory_ret,
   true 
},
{ /* Method NodeGetFreeMemory => 102 */
   remoteDispatchNodeGetFreeMemoryHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_free_memory_ret),
   (xdrproc_t)xdr_remote_node_get_free_memory_ret,
   true 
},
{ /* Method DomainBlockPeek => 103 */
   remoteDispatchDomainBlockPeekHelper,
   sizeof(remote_domain_block_peek_args),
   (xdrproc_t)xdr_remote_domain_block_peek_args,
   sizeof(remote_domain_block_peek_ret),
   (xdrproc_t)xdr_remote_domain_block_peek_ret,
   true 
},
{ /* Method DomainMemoryPeek => 104 */
   remoteDispatchDomainMemoryPeekHelper,
   sizeof(remote_domain_memory_peek_args),
   (xdrproc_t)xdr_remote_domain_memory_peek_args,
   sizeof(remote_domain_memory_peek_ret),
   (xdrproc_t)xdr_remote_domain_memory_peek_ret,
   true 
},
{ /* Method DomainEventsRegister => 105 */
   remoteDispatchDomainEventsRegisterHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_domain_events_register_ret),
   (xdrproc_t)xdr_remote_domain_events_register_ret,
   true 
},
{ /* Method DomainEventsDeregister => 106 */
   remoteDispatchDomainEventsDeregisterHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_domain_events_deregister_ret),
   (xdrproc_t)xdr_remote_domain_events_deregister_ret,
   true 
},
{ /* Async event DomainEventLifecycle => 107 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainMigratePrepare2 => 108 */
   remoteDispatchDomainMigratePrepare2Helper,
   sizeof(remote_domain_migrate_prepare2_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare2_args,
   sizeof(remote_domain_migrate_prepare2_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare2_ret,
   true 
},
{ /* Method DomainMigrateFinish2 => 109 */
   remoteDispatchDomainMigrateFinish2Helper,
   sizeof(remote_domain_migrate_finish2_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish2_args,
   sizeof(remote_domain_migrate_finish2_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish2_ret,
   true 
},
{ /* Method GetURI => 110 */
   remoteDispatchGetURIHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_get_uri_ret),
   (xdrproc_t)xdr_remote_get_uri_ret,
   true 
},
{ /* Method NodeNumOfDevices => 111 */
   remoteDispatchNodeNumOfDevicesHelper,
   sizeof(remote_node_num_of_devices_args),
   (xdrproc_t)xdr_remote_node_num_of_devices_args,
   sizeof(remote_node_num_of_devices_ret),
   (xdrproc_t)xdr_remote_node_num_of_devices_ret,
   true 
},
{ /* Method NodeListDevices => 112 */
   remoteDispatchNodeListDevicesHelper,
   sizeof(remote_node_list_devices_args),
   (xdrproc_t)xdr_remote_node_list_devices_args,
   sizeof(remote_node_list_devices_ret),
   (xdrproc_t)xdr_remote_node_list_devices_ret,
   true 
},
{ /* Method NodeDeviceLookupByName => 113 */
   remoteDispatchNodeDeviceLookupByNameHelper,
   sizeof(remote_node_device_lookup_by_name_args),
   (xdrproc_t)xdr_remote_node_device_lookup_by_name_args,
   sizeof(remote_node_device_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_node_device_lookup_by_name_ret,
   true 
},
{ /* Method NodeDeviceGetXMLDesc => 114 */
   remoteDispatchNodeDeviceGetXMLDescHelper,
   sizeof(remote_node_device_get_xml_desc_args),
   (xdrproc_t)xdr_remote_node_device_get_xml_desc_args,
   sizeof(remote_node_device_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_node_device_get_xml_desc_ret,
   true 
},
{ /* Method NodeDeviceGetParent => 115 */
   remoteDispatchNodeDeviceGetParentHelper,
   sizeof(remote_node_device_get_parent_args),
   (xdrproc_t)xdr_remote_node_device_get_parent_args,
   sizeof(remote_node_device_get_parent_ret),
   (xdrproc_t)xdr_remote_node_device_get_parent_ret,
   true 
},
{ /* Method NodeDeviceNumOfCaps => 116 */
   remoteDispatchNodeDeviceNumOfCapsHelper,
   sizeof(remote_node_device_num_of_caps_args),
   (xdrproc_t)xdr_remote_node_device_num_of_caps_args,
   sizeof(remote_node_device_num_of_caps_ret),
   (xdrproc_t)xdr_remote_node_device_num_of_caps_ret,
   true 
},
{ /* Method NodeDeviceListCaps => 117 */
   remoteDispatchNodeDeviceListCapsHelper,
   sizeof(remote_node_device_list_caps_args),
   (xdrproc_t)xdr_remote_node_device_list_caps_args,
   sizeof(remote_node_device_list_caps_ret),
   (xdrproc_t)xdr_remote_node_device_list_caps_ret,
   true 
},
{ /* Method NodeDeviceDettach => 118 */
   remoteDispatchNodeDeviceDettachHelper,
   sizeof(remote_node_device_dettach_args),
   (xdrproc_t)xdr_remote_node_device_dettach_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method NodeDeviceReAttach => 119 */
   remoteDispatchNodeDeviceReAttachHelper,
   sizeof(remote_node_device_re_attach_args),
   (xdrproc_t)xdr_remote_node_device_re_attach_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method NodeDeviceReset => 120 */
   remoteDispatchNodeDeviceResetHelper,
   sizeof(remote_node_device_reset_args),
   (xdrproc_t)xdr_remote_node_device_reset_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetSecurityLabel => 121 */
   remoteDispatchDomainGetSecurityLabelHelper,
   sizeof(remote_domain_get_security_label_args),
   (xdrproc_t)xdr_remote_domain_get_security_label_args,
   sizeof(remote_domain_get_security_label_ret),
   (xdrproc_t)xdr_remote_domain_get_security_label_ret,
   true 
},
{ /* Method NodeGetSecurityModel => 122 */
   remoteDispatchNodeGetSecurityModelHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_node_get_security_model_ret),
   (xdrproc_t)xdr_remote_node_get_security_model_ret,
   true 
},
{ /* Method NodeDeviceCreateXML => 123 */
   remoteDispatchNodeDeviceCreateXMLHelper,
   sizeof(remote_node_device_create_xml_args),
   (xdrproc_t)xdr_remote_node_device_create_xml_args,
   sizeof(remote_node_device_create_xml_ret),
   (xdrproc_t)xdr_remote_node_device_create_xml_ret,
   true 
},
{ /* Method NodeDeviceDestroy => 124 */
   remoteDispatchNodeDeviceDestroyHelper,
   sizeof(remote_node_device_destroy_args),
   (xdrproc_t)xdr_remote_node_device_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StorageVolCreateXMLFrom => 125 */
   remoteDispatchStorageVolCreateXMLFromHelper,
   sizeof(remote_storage_vol_create_xml_from_args),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_from_args,
   sizeof(remote_storage_vol_create_xml_from_ret),
   (xdrproc_t)xdr_remote_storage_vol_create_xml_from_ret,
   true 
},
{ /* Method NumOfInterfaces => 126 */
   remoteDispatchNumOfInterfacesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_interfaces_ret),
   (xdrproc_t)xdr_remote_num_of_interfaces_ret,
   true 
},
{ /* Method ListInterfaces => 127 */
   remoteDispatchListInterfacesHelper,
   sizeof(remote_list_interfaces_args),
   (xdrproc_t)xdr_remote_list_interfaces_args,
   sizeof(remote_list_interfaces_ret),
   (xdrproc_t)xdr_remote_list_interfaces_ret,
   true 
},
{ /* Method InterfaceLookupByName => 128 */
   remoteDispatchInterfaceLookupByNameHelper,
   sizeof(remote_interface_lookup_by_name_args),
   (xdrproc_t)xdr_remote_interface_lookup_by_name_args,
   sizeof(remote_interface_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_interface_lookup_by_name_ret,
   true 
},
{ /* Method InterfaceLookupByMACString => 129 */
   remoteDispatchInterfaceLookupByMACStringHelper,
   sizeof(remote_interface_lookup_by_mac_string_args),
   (xdrproc_t)xdr_remote_interface_lookup_by_mac_string_args,
   sizeof(remote_interface_lookup_by_mac_string_ret),
   (xdrproc_t)xdr_remote_interface_lookup_by_mac_string_ret,
   true 
},
{ /* Method InterfaceGetXMLDesc => 130 */
   remoteDispatchInterfaceGetXMLDescHelper,
   sizeof(remote_interface_get_xml_desc_args),
   (xdrproc_t)xdr_remote_interface_get_xml_desc_args,
   sizeof(remote_interface_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_interface_get_xml_desc_ret,
   true 
},
{ /* Method InterfaceDefineXML => 131 */
   remoteDispatchInterfaceDefineXMLHelper,
   sizeof(remote_interface_define_xml_args),
   (xdrproc_t)xdr_remote_interface_define_xml_args,
   sizeof(remote_interface_define_xml_ret),
   (xdrproc_t)xdr_remote_interface_define_xml_ret,
   true 
},
{ /* Method InterfaceUndefine => 132 */
   remoteDispatchInterfaceUndefineHelper,
   sizeof(remote_interface_undefine_args),
   (xdrproc_t)xdr_remote_interface_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method InterfaceCreate => 133 */
   remoteDispatchInterfaceCreateHelper,
   sizeof(remote_interface_create_args),
   (xdrproc_t)xdr_remote_interface_create_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method InterfaceDestroy => 134 */
   remoteDispatchInterfaceDestroyHelper,
   sizeof(remote_interface_destroy_args),
   (xdrproc_t)xdr_remote_interface_destroy_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainXMLFromNative => 135 */
   remoteDispatchDomainXMLFromNativeHelper,
   sizeof(remote_domain_xml_from_native_args),
   (xdrproc_t)xdr_remote_domain_xml_from_native_args,
   sizeof(remote_domain_xml_from_native_ret),
   (xdrproc_t)xdr_remote_domain_xml_from_native_ret,
   true 
},
{ /* Method DomainXMLToNative => 136 */
   remoteDispatchDomainXMLToNativeHelper,
   sizeof(remote_domain_xml_to_native_args),
   (xdrproc_t)xdr_remote_domain_xml_to_native_args,
   sizeof(remote_domain_xml_to_native_ret),
   (xdrproc_t)xdr_remote_domain_xml_to_native_ret,
   true 
},
{ /* Method NumOfDefinedInterfaces => 137 */
   remoteDispatchNumOfDefinedInterfacesHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_defined_interfaces_ret),
   (xdrproc_t)xdr_remote_num_of_defined_interfaces_ret,
   true 
},
{ /* Method ListDefinedInterfaces => 138 */
   remoteDispatchListDefinedInterfacesHelper,
   sizeof(remote_list_defined_interfaces_args),
   (xdrproc_t)xdr_remote_list_defined_interfaces_args,
   sizeof(remote_list_defined_interfaces_ret),
   (xdrproc_t)xdr_remote_list_defined_interfaces_ret,
   true 
},
{ /* Method NumOfSecrets => 139 */
   remoteDispatchNumOfSecretsHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_secrets_ret),
   (xdrproc_t)xdr_remote_num_of_secrets_ret,
   true 
},
{ /* Method ListSecrets => 140 */
   remoteDispatchListSecretsHelper,
   sizeof(remote_list_secrets_args),
   (xdrproc_t)xdr_remote_list_secrets_args,
   sizeof(remote_list_secrets_ret),
   (xdrproc_t)xdr_remote_list_secrets_ret,
   true 
},
{ /* Method SecretLookupByUUID => 141 */
   remoteDispatchSecretLookupByUUIDHelper,
   sizeof(remote_secret_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_secret_lookup_by_uuid_args,
   sizeof(remote_secret_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_secret_lookup_by_uuid_ret,
   true 
},
{ /* Method SecretDefineXML => 142 */
   remoteDispatchSecretDefineXMLHelper,
   sizeof(remote_secret_define_xml_args),
   (xdrproc_t)xdr_remote_secret_define_xml_args,
   sizeof(remote_secret_define_xml_ret),
   (xdrproc_t)xdr_remote_secret_define_xml_ret,
   true 
},
{ /* Method SecretGetXMLDesc => 143 */
   remoteDispatchSecretGetXMLDescHelper,
   sizeof(remote_secret_get_xml_desc_args),
   (xdrproc_t)xdr_remote_secret_get_xml_desc_args,
   sizeof(remote_secret_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_secret_get_xml_desc_ret,
   true 
},
{ /* Method SecretSetValue => 144 */
   remoteDispatchSecretSetValueHelper,
   sizeof(remote_secret_set_value_args),
   (xdrproc_t)xdr_remote_secret_set_value_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method SecretGetValue => 145 */
   remoteDispatchSecretGetValueHelper,
   sizeof(remote_secret_get_value_args),
   (xdrproc_t)xdr_remote_secret_get_value_args,
   sizeof(remote_secret_get_value_ret),
   (xdrproc_t)xdr_remote_secret_get_value_ret,
   true 
},
{ /* Method SecretUndefine => 146 */
   remoteDispatchSecretUndefineHelper,
   sizeof(remote_secret_undefine_args),
   (xdrproc_t)xdr_remote_secret_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method SecretLookupByUsage => 147 */
   remoteDispatchSecretLookupByUsageHelper,
   sizeof(remote_secret_lookup_by_usage_args),
   (xdrproc_t)xdr_remote_secret_lookup_by_usage_args,
   sizeof(remote_secret_lookup_by_usage_ret),
   (xdrproc_t)xdr_remote_secret_lookup_by_usage_ret,
   true 
},
{ /* Method DomainMigratePrepareTunnel => 148 */
   remoteDispatchDomainMigratePrepareTunnelHelper,
   sizeof(remote_domain_migrate_prepare_tunnel_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method IsSecure => 149 */
   remoteDispatchIsSecureHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_is_secure_ret),
   (xdrproc_t)xdr_remote_is_secure_ret,
   true 
},
{ /* Method DomainIsActive => 150 */
   remoteDispatchDomainIsActiveHelper,
   sizeof(remote_domain_is_active_args),
   (xdrproc_t)xdr_remote_domain_is_active_args,
   sizeof(remote_domain_is_active_ret),
   (xdrproc_t)xdr_remote_domain_is_active_ret,
   true 
},
{ /* Method DomainIsPersistent => 151 */
   remoteDispatchDomainIsPersistentHelper,
   sizeof(remote_domain_is_persistent_args),
   (xdrproc_t)xdr_remote_domain_is_persistent_args,
   sizeof(remote_domain_is_persistent_ret),
   (xdrproc_t)xdr_remote_domain_is_persistent_ret,
   true 
},
{ /* Method NetworkIsActive => 152 */
   remoteDispatchNetworkIsActiveHelper,
   sizeof(remote_network_is_active_args),
   (xdrproc_t)xdr_remote_network_is_active_args,
   sizeof(remote_network_is_active_ret),
   (xdrproc_t)xdr_remote_network_is_active_ret,
   true 
},
{ /* Method NetworkIsPersistent => 153 */
   remoteDispatchNetworkIsPersistentHelper,
   sizeof(remote_network_is_persistent_args),
   (xdrproc_t)xdr_remote_network_is_persistent_args,
   sizeof(remote_network_is_persistent_ret),
   (xdrproc_t)xdr_remote_network_is_persistent_ret,
   true 
},
{ /* Method StoragePoolIsActive => 154 */
   remoteDispatchStoragePoolIsActiveHelper,
   sizeof(remote_storage_pool_is_active_args),
   (xdrproc_t)xdr_remote_storage_pool_is_active_args,
   sizeof(remote_storage_pool_is_active_ret),
   (xdrproc_t)xdr_remote_storage_pool_is_active_ret,
   true 
},
{ /* Method StoragePoolIsPersistent => 155 */
   remoteDispatchStoragePoolIsPersistentHelper,
   sizeof(remote_storage_pool_is_persistent_args),
   (xdrproc_t)xdr_remote_storage_pool_is_persistent_args,
   sizeof(remote_storage_pool_is_persistent_ret),
   (xdrproc_t)xdr_remote_storage_pool_is_persistent_ret,
   true 
},
{ /* Method InterfaceIsActive => 156 */
   remoteDispatchInterfaceIsActiveHelper,
   sizeof(remote_interface_is_active_args),
   (xdrproc_t)xdr_remote_interface_is_active_args,
   sizeof(remote_interface_is_active_ret),
   (xdrproc_t)xdr_remote_interface_is_active_ret,
   true 
},
{ /* Method GetLibVersion => 157 */
   remoteDispatchGetLibVersionHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_get_lib_version_ret),
   (xdrproc_t)xdr_remote_get_lib_version_ret,
   true 
},
{ /* Method CPUCompare => 158 */
   remoteDispatchCPUCompareHelper,
   sizeof(remote_cpu_compare_args),
   (xdrproc_t)xdr_remote_cpu_compare_args,
   sizeof(remote_cpu_compare_ret),
   (xdrproc_t)xdr_remote_cpu_compare_ret,
   true 
},
{ /* Method DomainMemoryStats => 159 */
   remoteDispatchDomainMemoryStatsHelper,
   sizeof(remote_domain_memory_stats_args),
   (xdrproc_t)xdr_remote_domain_memory_stats_args,
   sizeof(remote_domain_memory_stats_ret),
   (xdrproc_t)xdr_remote_domain_memory_stats_ret,
   true 
},
{ /* Method DomainAttachDeviceFlags => 160 */
   remoteDispatchDomainAttachDeviceFlagsHelper,
   sizeof(remote_domain_attach_device_flags_args),
   (xdrproc_t)xdr_remote_domain_attach_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainDetachDeviceFlags => 161 */
   remoteDispatchDomainDetachDeviceFlagsHelper,
   sizeof(remote_domain_detach_device_flags_args),
   (xdrproc_t)xdr_remote_domain_detach_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method CPUBaseline => 162 */
   remoteDispatchCPUBaselineHelper,
   sizeof(remote_cpu_baseline_args),
   (xdrproc_t)xdr_remote_cpu_baseline_args,
   sizeof(remote_cpu_baseline_ret),
   (xdrproc_t)xdr_remote_cpu_baseline_ret,
   true 
},
{ /* Method DomainGetJobInfo => 163 */
   remoteDispatchDomainGetJobInfoHelper,
   sizeof(remote_domain_get_job_info_args),
   (xdrproc_t)xdr_remote_domain_get_job_info_args,
   sizeof(remote_domain_get_job_info_ret),
   (xdrproc_t)xdr_remote_domain_get_job_info_ret,
   true 
},
{ /* Method DomainAbortJob => 164 */
   remoteDispatchDomainAbortJobHelper,
   sizeof(remote_domain_abort_job_args),
   (xdrproc_t)xdr_remote_domain_abort_job_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StorageVolWipe => 165 */
   remoteDispatchStorageVolWipeHelper,
   sizeof(remote_storage_vol_wipe_args),
   (xdrproc_t)xdr_remote_storage_vol_wipe_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainMigrateSetMaxDowntime => 166 */
   remoteDispatchDomainMigrateSetMaxDowntimeHelper,
   sizeof(remote_domain_migrate_set_max_downtime_args),
   (xdrproc_t)xdr_remote_domain_migrate_set_max_downtime_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainEventsRegisterAny => 167 */
   remoteDispatchDomainEventsRegisterAnyHelper,
   sizeof(remote_domain_events_register_any_args),
   (xdrproc_t)xdr_remote_domain_events_register_any_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainEventsDeregisterAny => 168 */
   remoteDispatchDomainEventsDeregisterAnyHelper,
   sizeof(remote_domain_events_deregister_any_args),
   (xdrproc_t)xdr_remote_domain_events_deregister_any_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Async event DomainEventReboot => 169 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Async event DomainEventRtcChange => 170 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Async event DomainEventWatchdog => 171 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Async event DomainEventIoError => 172 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Async event DomainEventGraphics => 173 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainUpdateDeviceFlags => 174 */
   remoteDispatchDomainUpdateDeviceFlagsHelper,
   sizeof(remote_domain_update_device_flags_args),
   (xdrproc_t)xdr_remote_domain_update_device_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method NWFilterLookupByName => 175 */
   remoteDispatchNWFilterLookupByNameHelper,
   sizeof(remote_nwfilter_lookup_by_name_args),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_name_args,
   sizeof(remote_nwfilter_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_name_ret,
   true 
},
{ /* Method NWFilterLookupByUUID => 176 */
   remoteDispatchNWFilterLookupByUUIDHelper,
   sizeof(remote_nwfilter_lookup_by_uuid_args),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_uuid_args,
   sizeof(remote_nwfilter_lookup_by_uuid_ret),
   (xdrproc_t)xdr_remote_nwfilter_lookup_by_uuid_ret,
   true 
},
{ /* Method NWFilterGetXMLDesc => 177 */
   remoteDispatchNWFilterGetXMLDescHelper,
   sizeof(remote_nwfilter_get_xml_desc_args),
   (xdrproc_t)xdr_remote_nwfilter_get_xml_desc_args,
   sizeof(remote_nwfilter_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_nwfilter_get_xml_desc_ret,
   true 
},
{ /* Method NumOfNWFilters => 178 */
   remoteDispatchNumOfNWFiltersHelper,
   0,
   (xdrproc_t)xdr_void,
   sizeof(remote_num_of_nwfilters_ret),
   (xdrproc_t)xdr_remote_num_of_nwfilters_ret,
   true 
},
{ /* Method ListNWFilters => 179 */
   remoteDispatchListNWFiltersHelper,
   sizeof(remote_list_nwfilters_args),
   (xdrproc_t)xdr_remote_list_nwfilters_args,
   sizeof(remote_list_nwfilters_ret),
   (xdrproc_t)xdr_remote_list_nwfilters_ret,
   true 
},
{ /* Method NWFilterDefineXML => 180 */
   remoteDispatchNWFilterDefineXMLHelper,
   sizeof(remote_nwfilter_define_xml_args),
   (xdrproc_t)xdr_remote_nwfilter_define_xml_args,
   sizeof(remote_nwfilter_define_xml_ret),
   (xdrproc_t)xdr_remote_nwfilter_define_xml_ret,
   true 
},
{ /* Method NWFilterUndefine => 181 */
   remoteDispatchNWFilterUndefineHelper,
   sizeof(remote_nwfilter_undefine_args),
   (xdrproc_t)xdr_remote_nwfilter_undefine_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainManagedSave => 182 */
   remoteDispatchDomainManagedSaveHelper,
   sizeof(remote_domain_managed_save_args),
   (xdrproc_t)xdr_remote_domain_managed_save_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainHasManagedSaveImage => 183 */
   remoteDispatchDomainHasManagedSaveImageHelper,
   sizeof(remote_domain_has_managed_save_image_args),
   (xdrproc_t)xdr_remote_domain_has_managed_save_image_args,
   sizeof(remote_domain_has_managed_save_image_ret),
   (xdrproc_t)xdr_remote_domain_has_managed_save_image_ret,
   true 
},
{ /* Method DomainManagedSaveRemove => 184 */
   remoteDispatchDomainManagedSaveRemoveHelper,
   sizeof(remote_domain_managed_save_remove_args),
   (xdrproc_t)xdr_remote_domain_managed_save_remove_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSnapshotCreateXML => 185 */
   remoteDispatchDomainSnapshotCreateXMLHelper,
   sizeof(remote_domain_snapshot_create_xml_args),
   (xdrproc_t)xdr_remote_domain_snapshot_create_xml_args,
   sizeof(remote_domain_snapshot_create_xml_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_create_xml_ret,
   true 
},
{ /* Method DomainSnapshotGetXMLDesc => 186 */
   remoteDispatchDomainSnapshotGetXMLDescHelper,
   sizeof(remote_domain_snapshot_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_snapshot_get_xml_desc_args,
   sizeof(remote_domain_snapshot_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_get_xml_desc_ret,
   true 
},
{ /* Method DomainSnapshotNum => 187 */
   remoteDispatchDomainSnapshotNumHelper,
   sizeof(remote_domain_snapshot_num_args),
   (xdrproc_t)xdr_remote_domain_snapshot_num_args,
   sizeof(remote_domain_snapshot_num_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_num_ret,
   true 
},
{ /* Method DomainSnapshotListNames => 188 */
   remoteDispatchDomainSnapshotListNamesHelper,
   sizeof(remote_domain_snapshot_list_names_args),
   (xdrproc_t)xdr_remote_domain_snapshot_list_names_args,
   sizeof(remote_domain_snapshot_list_names_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_list_names_ret,
   true 
},
{ /* Method DomainSnapshotLookupByName => 189 */
   remoteDispatchDomainSnapshotLookupByNameHelper,
   sizeof(remote_domain_snapshot_lookup_by_name_args),
   (xdrproc_t)xdr_remote_domain_snapshot_lookup_by_name_args,
   sizeof(remote_domain_snapshot_lookup_by_name_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_lookup_by_name_ret,
   true 
},
{ /* Method DomainHasCurrentSnapshot => 190 */
   remoteDispatchDomainHasCurrentSnapshotHelper,
   sizeof(remote_domain_has_current_snapshot_args),
   (xdrproc_t)xdr_remote_domain_has_current_snapshot_args,
   sizeof(remote_domain_has_current_snapshot_ret),
   (xdrproc_t)xdr_remote_domain_has_current_snapshot_ret,
   true 
},
{ /* Method DomainSnapshotCurrent => 191 */
   remoteDispatchDomainSnapshotCurrentHelper,
   sizeof(remote_domain_snapshot_current_args),
   (xdrproc_t)xdr_remote_domain_snapshot_current_args,
   sizeof(remote_domain_snapshot_current_ret),
   (xdrproc_t)xdr_remote_domain_snapshot_current_ret,
   true 
},
{ /* Method DomainRevertToSnapshot => 192 */
   remoteDispatchDomainRevertToSnapshotHelper,
   sizeof(remote_domain_revert_to_snapshot_args),
   (xdrproc_t)xdr_remote_domain_revert_to_snapshot_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSnapshotDelete => 193 */
   remoteDispatchDomainSnapshotDeleteHelper,
   sizeof(remote_domain_snapshot_delete_args),
   (xdrproc_t)xdr_remote_domain_snapshot_delete_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetBlockInfo => 194 */
   remoteDispatchDomainGetBlockInfoHelper,
   sizeof(remote_domain_get_block_info_args),
   (xdrproc_t)xdr_remote_domain_get_block_info_args,
   sizeof(remote_domain_get_block_info_ret),
   (xdrproc_t)xdr_remote_domain_get_block_info_ret,
   true 
},
{ /* Async event DomainEventIoErrorReason => 195 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainCreateWithFlags => 196 */
   remoteDispatchDomainCreateWithFlagsHelper,
   sizeof(remote_domain_create_with_flags_args),
   (xdrproc_t)xdr_remote_domain_create_with_flags_args,
   sizeof(remote_domain_create_with_flags_ret),
   (xdrproc_t)xdr_remote_domain_create_with_flags_ret,
   true 
},
{ /* Method DomainSetMemoryParameters => 197 */
   remoteDispatchDomainSetMemoryParametersHelper,
   sizeof(remote_domain_set_memory_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_memory_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetMemoryParameters => 198 */
   remoteDispatchDomainGetMemoryParametersHelper,
   sizeof(remote_domain_get_memory_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_memory_parameters_args,
   sizeof(remote_domain_get_memory_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_memory_parameters_ret,
   true 
},
{ /* Method DomainSetVcpusFlags => 199 */
   remoteDispatchDomainSetVcpusFlagsHelper,
   sizeof(remote_domain_set_vcpus_flags_args),
   (xdrproc_t)xdr_remote_domain_set_vcpus_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetVcpusFlags => 200 */
   remoteDispatchDomainGetVcpusFlagsHelper,
   sizeof(remote_domain_get_vcpus_flags_args),
   (xdrproc_t)xdr_remote_domain_get_vcpus_flags_args,
   sizeof(remote_domain_get_vcpus_flags_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpus_flags_ret,
   true 
},
{ /* Method DomainOpenConsole => 201 */
   remoteDispatchDomainOpenConsoleHelper,
   sizeof(remote_domain_open_console_args),
   (xdrproc_t)xdr_remote_domain_open_console_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainIsUpdated => 202 */
   remoteDispatchDomainIsUpdatedHelper,
   sizeof(remote_domain_is_updated_args),
   (xdrproc_t)xdr_remote_domain_is_updated_args,
   sizeof(remote_domain_is_updated_ret),
   (xdrproc_t)xdr_remote_domain_is_updated_ret,
   true 
},
{ /* Method GetSysinfo => 203 */
   remoteDispatchGetSysinfoHelper,
   sizeof(remote_get_sysinfo_args),
   (xdrproc_t)xdr_remote_get_sysinfo_args,
   sizeof(remote_get_sysinfo_ret),
   (xdrproc_t)xdr_remote_get_sysinfo_ret,
   true 
},
{ /* Method DomainSetMemoryFlags => 204 */
   remoteDispatchDomainSetMemoryFlagsHelper,
   sizeof(remote_domain_set_memory_flags_args),
   (xdrproc_t)xdr_remote_domain_set_memory_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSetBlkioParameters => 205 */
   remoteDispatchDomainSetBlkioParametersHelper,
   sizeof(remote_domain_set_blkio_parameters_args),
   (xdrproc_t)xdr_remote_domain_set_blkio_parameters_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetBlkioParameters => 206 */
   remoteDispatchDomainGetBlkioParametersHelper,
   sizeof(remote_domain_get_blkio_parameters_args),
   (xdrproc_t)xdr_remote_domain_get_blkio_parameters_args,
   sizeof(remote_domain_get_blkio_parameters_ret),
   (xdrproc_t)xdr_remote_domain_get_blkio_parameters_ret,
   true 
},
{ /* Method DomainMigrateSetMaxSpeed => 207 */
   remoteDispatchDomainMigrateSetMaxSpeedHelper,
   sizeof(remote_domain_migrate_set_max_speed_args),
   (xdrproc_t)xdr_remote_domain_migrate_set_max_speed_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StorageVolUpload => 208 */
   remoteDispatchStorageVolUploadHelper,
   sizeof(remote_storage_vol_upload_args),
   (xdrproc_t)xdr_remote_storage_vol_upload_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method StorageVolDownload => 209 */
   remoteDispatchStorageVolDownloadHelper,
   sizeof(remote_storage_vol_download_args),
   (xdrproc_t)xdr_remote_storage_vol_download_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainInjectNMI => 210 */
   remoteDispatchDomainInjectNMIHelper,
   sizeof(remote_domain_inject_nmi_args),
   (xdrproc_t)xdr_remote_domain_inject_nmi_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainScreenshot => 211 */
   remoteDispatchDomainScreenshotHelper,
   sizeof(remote_domain_screenshot_args),
   (xdrproc_t)xdr_remote_domain_screenshot_args,
   sizeof(remote_domain_screenshot_ret),
   (xdrproc_t)xdr_remote_domain_screenshot_ret,
   true 
},
{ /* Method DomainGetState => 212 */
   remoteDispatchDomainGetStateHelper,
   sizeof(remote_domain_get_state_args),
   (xdrproc_t)xdr_remote_domain_get_state_args,
   sizeof(remote_domain_get_state_ret),
   (xdrproc_t)xdr_remote_domain_get_state_ret,
   true 
},
{ /* Method DomainMigrateBegin3 => 213 */
   remoteDispatchDomainMigrateBegin3Helper,
   sizeof(remote_domain_migrate_begin3_args),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_args,
   sizeof(remote_domain_migrate_begin3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_begin3_ret,
   true 
},
{ /* Method DomainMigratePrepare3 => 214 */
   remoteDispatchDomainMigratePrepare3Helper,
   sizeof(remote_domain_migrate_prepare3_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_args,
   sizeof(remote_domain_migrate_prepare3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare3_ret,
   true 
},
{ /* Method DomainMigratePrepareTunnel3 => 215 */
   remoteDispatchDomainMigratePrepareTunnel3Helper,
   sizeof(remote_domain_migrate_prepare_tunnel3_args),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_args,
   sizeof(remote_domain_migrate_prepare_tunnel3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_prepare_tunnel3_ret,
   true 
},
{ /* Method DomainMigratePerform3 => 216 */
   remoteDispatchDomainMigratePerform3Helper,
   sizeof(remote_domain_migrate_perform3_args),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_args,
   sizeof(remote_domain_migrate_perform3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_perform3_ret,
   true 
},
{ /* Method DomainMigrateFinish3 => 217 */
   remoteDispatchDomainMigrateFinish3Helper,
   sizeof(remote_domain_migrate_finish3_args),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_args,
   sizeof(remote_domain_migrate_finish3_ret),
   (xdrproc_t)xdr_remote_domain_migrate_finish3_ret,
   true 
},
{ /* Method DomainMigrateConfirm3 => 218 */
   remoteDispatchDomainMigrateConfirm3Helper,
   sizeof(remote_domain_migrate_confirm3_args),
   (xdrproc_t)xdr_remote_domain_migrate_confirm3_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSetSchedulerParametersFlags => 219 */
   remoteDispatchDomainSetSchedulerParametersFlagsHelper,
   sizeof(remote_domain_set_scheduler_parameters_flags_args),
   (xdrproc_t)xdr_remote_domain_set_scheduler_parameters_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method InterfaceChangeBegin => 220 */
   remoteDispatchInterfaceChangeBeginHelper,
   sizeof(remote_interface_change_begin_args),
   (xdrproc_t)xdr_remote_interface_change_begin_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method InterfaceChangeCommit => 221 */
   remoteDispatchInterfaceChangeCommitHelper,
   sizeof(remote_interface_change_commit_args),
   (xdrproc_t)xdr_remote_interface_change_commit_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method InterfaceChangeRollback => 222 */
   remoteDispatchInterfaceChangeRollbackHelper,
   sizeof(remote_interface_change_rollback_args),
   (xdrproc_t)xdr_remote_interface_change_rollback_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetSchedulerParametersFlags => 223 */
   remoteDispatchDomainGetSchedulerParametersFlagsHelper,
   sizeof(remote_domain_get_scheduler_parameters_flags_args),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_flags_args,
   sizeof(remote_domain_get_scheduler_parameters_flags_ret),
   (xdrproc_t)xdr_remote_domain_get_scheduler_parameters_flags_ret,
   true 
},
{ /* Async event DomainEventControlError => 224 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainPinVcpuFlags => 225 */
   remoteDispatchDomainPinVcpuFlagsHelper,
   sizeof(remote_domain_pin_vcpu_flags_args),
   (xdrproc_t)xdr_remote_domain_pin_vcpu_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSendKey => 226 */
   remoteDispatchDomainSendKeyHelper,
   sizeof(remote_domain_send_key_args),
   (xdrproc_t)xdr_remote_domain_send_key_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method NodeGetCPUStats => 227 */
   remoteDispatchNodeGetCPUStatsHelper,
   sizeof(remote_node_get_cpu_stats_args),
   (xdrproc_t)xdr_remote_node_get_cpu_stats_args,
   sizeof(remote_node_get_cpu_stats_ret),
   (xdrproc_t)xdr_remote_node_get_cpu_stats_ret,
   true 
},
{ /* Method NodeGetMemoryStats => 228 */
   remoteDispatchNodeGetMemoryStatsHelper,
   sizeof(remote_node_get_memory_stats_args),
   (xdrproc_t)xdr_remote_node_get_memory_stats_args,
   sizeof(remote_node_get_memory_stats_ret),
   (xdrproc_t)xdr_remote_node_get_memory_stats_ret,
   true 
},
{ /* Method DomainGetControlInfo => 229 */
   remoteDispatchDomainGetControlInfoHelper,
   sizeof(remote_domain_get_control_info_args),
   (xdrproc_t)xdr_remote_domain_get_control_info_args,
   sizeof(remote_domain_get_control_info_ret),
   (xdrproc_t)xdr_remote_domain_get_control_info_ret,
   true 
},
{ /* Method DomainGetVcpuPinInfo => 230 */
   remoteDispatchDomainGetVcpuPinInfoHelper,
   sizeof(remote_domain_get_vcpu_pin_info_args),
   (xdrproc_t)xdr_remote_domain_get_vcpu_pin_info_args,
   sizeof(remote_domain_get_vcpu_pin_info_ret),
   (xdrproc_t)xdr_remote_domain_get_vcpu_pin_info_ret,
   true 
},
{ /* Method DomainUndefineFlags => 231 */
   remoteDispatchDomainUndefineFlagsHelper,
   sizeof(remote_domain_undefine_flags_args),
   (xdrproc_t)xdr_remote_domain_undefine_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSaveFlags => 232 */
   remoteDispatchDomainSaveFlagsHelper,
   sizeof(remote_domain_save_flags_args),
   (xdrproc_t)xdr_remote_domain_save_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainRestoreFlags => 233 */
   remoteDispatchDomainRestoreFlagsHelper,
   sizeof(remote_domain_restore_flags_args),
   (xdrproc_t)xdr_remote_domain_restore_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainDestroyFlags => 234 */
   remoteDispatchDomainDestroyFlagsHelper,
   sizeof(remote_domain_destroy_flags_args),
   (xdrproc_t)xdr_remote_domain_destroy_flags_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainSaveImageGetXMLDesc => 235 */
   remoteDispatchDomainSaveImageGetXMLDescHelper,
   sizeof(remote_domain_save_image_get_xml_desc_args),
   (xdrproc_t)xdr_remote_domain_save_image_get_xml_desc_args,
   sizeof(remote_domain_save_image_get_xml_desc_ret),
   (xdrproc_t)xdr_remote_domain_save_image_get_xml_desc_ret,
   true 
},
{ /* Method DomainSaveImageDefineXML => 236 */
   remoteDispatchDomainSaveImageDefineXMLHelper,
   sizeof(remote_domain_save_image_define_xml_args),
   (xdrproc_t)xdr_remote_domain_save_image_define_xml_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainBlockJobAbort => 237 */
   remoteDispatchDomainBlockJobAbortHelper,
   sizeof(remote_domain_block_job_abort_args),
   (xdrproc_t)xdr_remote_domain_block_job_abort_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainGetBlockJobInfo => 238 */
   remoteDispatchDomainGetBlockJobInfoHelper,
   sizeof(remote_domain_get_block_job_info_args),
   (xdrproc_t)xdr_remote_domain_get_block_job_info_args,
   sizeof(remote_domain_get_block_job_info_ret),
   (xdrproc_t)xdr_remote_domain_get_block_job_info_ret,
   true 
},
{ /* Method DomainBlockJobSetSpeed => 239 */
   remoteDispatchDomainBlockJobSetSpeedHelper,
   sizeof(remote_domain_block_job_set_speed_args),
   (xdrproc_t)xdr_remote_domain_block_job_set_speed_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Method DomainBlockPull => 240 */
   remoteDispatchDomainBlockPullHelper,
   sizeof(remote_domain_block_pull_args),
   (xdrproc_t)xdr_remote_domain_block_pull_args,
   0,
   (xdrproc_t)xdr_void,
   true 
},
{ /* Async event DomainEventBlockJob => 241 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true 
},
};
size_t remoteNProcs = ARRAY_CARDINALITY(remoteProcs);
