/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _REMOTE_PROTOCOL_H_RPCGEN
#define _REMOTE_PROTOCOL_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

#include <libvirt/libvirt.h>
#include "internal.h"
#include <arpa/inet.h>
#ifdef HAVE_XDR_U_INT64_T
# define xdr_uint64_t xdr_u_int64_t
#endif
#ifndef IXDR_PUT_INT32
# define IXDR_PUT_INT32 IXDR_PUT_LONG
#endif
#ifndef IXDR_GET_INT32
# define IXDR_GET_INT32 IXDR_GET_LONG
#endif
#ifndef IXDR_PUT_U_INT32
# define IXDR_PUT_U_INT32 IXDR_PUT_U_LONG
#endif
#ifndef IXDR_GET_U_INT32
# define IXDR_GET_U_INT32 IXDR_GET_U_LONG
#endif
#define REMOTE_STRING_MAX 1048576

typedef char *remote_nonnull_string;

typedef remote_nonnull_string *remote_string;
#define REMOTE_DOMAIN_ID_LIST_MAX 16384
#define REMOTE_DOMAIN_NAME_LIST_MAX 16384
#define REMOTE_CPUMAP_MAX 256
#define REMOTE_VCPUINFO_MAX 2048
#define REMOTE_CPUMAPS_MAX 16384
#define REMOTE_MIGRATE_COOKIE_MAX 16384
#define REMOTE_NETWORK_NAME_LIST_MAX 16384
#define REMOTE_INTERFACE_NAME_LIST_MAX 16384
#define REMOTE_DEFINED_INTERFACE_NAME_LIST_MAX 16384
#define REMOTE_STORAGE_POOL_NAME_LIST_MAX 4096
#define REMOTE_STORAGE_VOL_NAME_LIST_MAX 16384
#define REMOTE_NODE_DEVICE_NAME_LIST_MAX 16384
#define REMOTE_NODE_DEVICE_CAPS_LIST_MAX 65536
#define REMOTE_NWFILTER_NAME_LIST_MAX 1024
#define REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX 16
#define REMOTE_DOMAIN_BLKIO_PARAMETERS_MAX 16
#define REMOTE_DOMAIN_MEMORY_PARAMETERS_MAX 16
#define REMOTE_DOMAIN_BLOCK_IO_TUNE_PARAMETERS_MAX 16
#define REMOTE_DOMAIN_NUMA_PARAMETERS_MAX 16
#define REMOTE_NODE_CPU_STATS_MAX 16
#define REMOTE_NODE_MEMORY_STATS_MAX 16
#define REMOTE_DOMAIN_BLOCK_STATS_PARAMETERS_MAX 16
#define REMOTE_NODE_MAX_CELLS 1024
#define REMOTE_AUTH_SASL_DATA_MAX 65536
#define REMOTE_AUTH_TYPE_LIST_MAX 20
#define REMOTE_DOMAIN_MEMORY_STATS_MAX 1024
#define REMOTE_DOMAIN_SNAPSHOT_LIST_NAMES_MAX 1024
#define REMOTE_DOMAIN_BLOCK_PEEK_BUFFER_MAX 1048576
#define REMOTE_DOMAIN_MEMORY_PEEK_BUFFER_MAX 1048576
#define REMOTE_SECURITY_LABEL_LIST_MAX 64
#define REMOTE_SECURITY_MODEL_MAX VIR_SECURITY_MODEL_BUFLEN
#define REMOTE_SECURITY_LABEL_MAX VIR_SECURITY_LABEL_BUFLEN
#define REMOTE_SECURITY_DOI_MAX VIR_SECURITY_DOI_BUFLEN
#define REMOTE_SECRET_VALUE_MAX 65536
#define REMOTE_SECRET_UUID_LIST_MAX 16384
#define REMOTE_CPU_BASELINE_MAX 256
#define REMOTE_DOMAIN_SEND_KEY_MAX 16
#define REMOTE_DOMAIN_INTERFACE_PARAMETERS_MAX 16
#define REMOTE_DOMAIN_GET_CPU_STATS_NCPUS_MAX 128
#define REMOTE_DOMAIN_GET_CPU_STATS_MAX 2048
#define REMOTE_DOMAIN_DISK_ERRORS_MAX 256
#define REMOTE_NODE_MEMORY_PARAMETERS_MAX 64

typedef char remote_uuid[VIR_UUID_BUFLEN];

struct remote_nonnull_domain {
        remote_nonnull_string name;
        remote_uuid uuid;
        int id;
};
typedef struct remote_nonnull_domain remote_nonnull_domain;

struct remote_nonnull_network {
        remote_nonnull_string name;
        remote_uuid uuid;
};
typedef struct remote_nonnull_network remote_nonnull_network;

struct remote_nonnull_nwfilter {
        remote_nonnull_string name;
        remote_uuid uuid;
};
typedef struct remote_nonnull_nwfilter remote_nonnull_nwfilter;

struct remote_nonnull_interface {
        remote_nonnull_string name;
        remote_nonnull_string mac;
};
typedef struct remote_nonnull_interface remote_nonnull_interface;

struct remote_nonnull_storage_pool {
        remote_nonnull_string name;
        remote_uuid uuid;
};
typedef struct remote_nonnull_storage_pool remote_nonnull_storage_pool;

struct remote_nonnull_storage_vol {
        remote_nonnull_string pool;
        remote_nonnull_string name;
        remote_nonnull_string key;
};
typedef struct remote_nonnull_storage_vol remote_nonnull_storage_vol;

struct remote_nonnull_node_device {
        remote_nonnull_string name;
};
typedef struct remote_nonnull_node_device remote_nonnull_node_device;

struct remote_nonnull_secret {
        remote_uuid uuid;
        int usageType;
        remote_nonnull_string usageID;
};
typedef struct remote_nonnull_secret remote_nonnull_secret;

struct remote_nonnull_domain_snapshot {
        remote_nonnull_string name;
        remote_nonnull_domain dom;
};
typedef struct remote_nonnull_domain_snapshot remote_nonnull_domain_snapshot;

typedef remote_nonnull_domain *remote_domain;

typedef remote_nonnull_network *remote_network;

typedef remote_nonnull_nwfilter *remote_nwfilter;

typedef remote_nonnull_storage_pool *remote_storage_pool;

typedef remote_nonnull_storage_vol *remote_storage_vol;

typedef remote_nonnull_node_device *remote_node_device;

struct remote_error {
        int code;
        int domain;
        remote_string message;
        int level;
        remote_domain dom;
        remote_string str1;
        remote_string str2;
        remote_string str3;
        int int1;
        int int2;
        remote_network net;
};
typedef struct remote_error remote_error;

enum remote_auth_type {
        REMOTE_AUTH_NONE = 0,
        REMOTE_AUTH_SASL = 1,
        REMOTE_AUTH_POLKIT = 2,
};
typedef enum remote_auth_type remote_auth_type;

struct remote_vcpu_info {
        u_int number;
        int state;
        uint64_t cpu_time;
        int cpu;
};
typedef struct remote_vcpu_info remote_vcpu_info;

struct remote_typed_param_value {
        int type;
        union {
                int i;
                u_int ui;
                int64_t l;
                uint64_t ul;
                double d;
                int b;
                remote_nonnull_string s;
        } remote_typed_param_value_u;
};
typedef struct remote_typed_param_value remote_typed_param_value;

struct remote_typed_param {
        remote_nonnull_string field;
        remote_typed_param_value value;
};
typedef struct remote_typed_param remote_typed_param;

struct remote_node_get_cpu_stats {
        remote_nonnull_string field;
        uint64_t value;
};
typedef struct remote_node_get_cpu_stats remote_node_get_cpu_stats;

struct remote_node_get_memory_stats {
        remote_nonnull_string field;
        uint64_t value;
};
typedef struct remote_node_get_memory_stats remote_node_get_memory_stats;

struct remote_domain_disk_error {
        remote_nonnull_string disk;
        int error;
};
typedef struct remote_domain_disk_error remote_domain_disk_error;

struct remote_open_args {
        remote_string name;
        u_int flags;
};
typedef struct remote_open_args remote_open_args;

struct remote_supports_feature_args {
        int feature;
};
typedef struct remote_supports_feature_args remote_supports_feature_args;

struct remote_supports_feature_ret {
        int supported;
};
typedef struct remote_supports_feature_ret remote_supports_feature_ret;

struct remote_get_type_ret {
        remote_nonnull_string type;
};
typedef struct remote_get_type_ret remote_get_type_ret;

struct remote_get_version_ret {
        uint64_t hv_ver;
};
typedef struct remote_get_version_ret remote_get_version_ret;

struct remote_get_lib_version_ret {
        uint64_t lib_ver;
};
typedef struct remote_get_lib_version_ret remote_get_lib_version_ret;

struct remote_get_hostname_ret {
        remote_nonnull_string hostname;
};
typedef struct remote_get_hostname_ret remote_get_hostname_ret;

struct remote_get_sysinfo_args {
        u_int flags;
};
typedef struct remote_get_sysinfo_args remote_get_sysinfo_args;

struct remote_get_sysinfo_ret {
        remote_nonnull_string sysinfo;
};
typedef struct remote_get_sysinfo_ret remote_get_sysinfo_ret;

struct remote_get_uri_ret {
        remote_nonnull_string uri;
};
typedef struct remote_get_uri_ret remote_get_uri_ret;

struct remote_get_max_vcpus_args {
        remote_string type;
};
typedef struct remote_get_max_vcpus_args remote_get_max_vcpus_args;

struct remote_get_max_vcpus_ret {
        int max_vcpus;
};
typedef struct remote_get_max_vcpus_ret remote_get_max_vcpus_ret;

struct remote_node_get_info_ret {
        char model[32];
        uint64_t memory;
        int cpus;
        int mhz;
        int nodes;
        int sockets;
        int cores;
        int threads;
};
typedef struct remote_node_get_info_ret remote_node_get_info_ret;

struct remote_get_capabilities_ret {
        remote_nonnull_string capabilities;
};
typedef struct remote_get_capabilities_ret remote_get_capabilities_ret;

struct remote_node_get_cpu_stats_args {
        int cpuNum;
        int nparams;
        u_int flags;
};
typedef struct remote_node_get_cpu_stats_args remote_node_get_cpu_stats_args;

struct remote_node_get_cpu_stats_ret {
        struct {
                u_int params_len;
                remote_node_get_cpu_stats *params_val;
        } params;
        int nparams;
};
typedef struct remote_node_get_cpu_stats_ret remote_node_get_cpu_stats_ret;

struct remote_node_get_memory_stats_args {
        int nparams;
        int cellNum;
        u_int flags;
};
typedef struct remote_node_get_memory_stats_args remote_node_get_memory_stats_args;

struct remote_node_get_memory_stats_ret {
        struct {
                u_int params_len;
                remote_node_get_memory_stats *params_val;
        } params;
        int nparams;
};
typedef struct remote_node_get_memory_stats_ret remote_node_get_memory_stats_ret;

struct remote_node_get_cells_free_memory_args {
        int startCell;
        int maxcells;
};
typedef struct remote_node_get_cells_free_memory_args remote_node_get_cells_free_memory_args;

struct remote_node_get_cells_free_memory_ret {
        struct {
                u_int cells_len;
                uint64_t *cells_val;
        } cells;
};
typedef struct remote_node_get_cells_free_memory_ret remote_node_get_cells_free_memory_ret;

struct remote_node_get_free_memory_ret {
        uint64_t freeMem;
};
typedef struct remote_node_get_free_memory_ret remote_node_get_free_memory_ret;

struct remote_domain_get_scheduler_type_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_scheduler_type_args remote_domain_get_scheduler_type_args;

struct remote_domain_get_scheduler_type_ret {
        remote_nonnull_string type;
        int nparams;
};
typedef struct remote_domain_get_scheduler_type_ret remote_domain_get_scheduler_type_ret;

struct remote_domain_get_scheduler_parameters_args {
        remote_nonnull_domain dom;
        int nparams;
};
typedef struct remote_domain_get_scheduler_parameters_args remote_domain_get_scheduler_parameters_args;

struct remote_domain_get_scheduler_parameters_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
};
typedef struct remote_domain_get_scheduler_parameters_ret remote_domain_get_scheduler_parameters_ret;

struct remote_domain_get_scheduler_parameters_flags_args {
        remote_nonnull_domain dom;
        int nparams;
        u_int flags;
};
typedef struct remote_domain_get_scheduler_parameters_flags_args remote_domain_get_scheduler_parameters_flags_args;

struct remote_domain_get_scheduler_parameters_flags_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
};
typedef struct remote_domain_get_scheduler_parameters_flags_ret remote_domain_get_scheduler_parameters_flags_ret;

struct remote_domain_set_scheduler_parameters_args {
        remote_nonnull_domain dom;
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
};
typedef struct remote_domain_set_scheduler_parameters_args remote_domain_set_scheduler_parameters_args;

struct remote_domain_set_scheduler_parameters_flags_args {
        remote_nonnull_domain dom;
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        u_int flags;
};
typedef struct remote_domain_set_scheduler_parameters_flags_args remote_domain_set_scheduler_parameters_flags_args;

struct remote_domain_set_blkio_parameters_args {
        remote_nonnull_domain dom;
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        u_int flags;
};
typedef struct remote_domain_set_blkio_parameters_args remote_domain_set_blkio_parameters_args;

struct remote_domain_get_blkio_parameters_args {
        remote_nonnull_domain dom;
        int nparams;
        u_int flags;
};
typedef struct remote_domain_get_blkio_parameters_args remote_domain_get_blkio_parameters_args;

struct remote_domain_get_blkio_parameters_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        int nparams;
};
typedef struct remote_domain_get_blkio_parameters_ret remote_domain_get_blkio_parameters_ret;

struct remote_domain_set_memory_parameters_args {
        remote_nonnull_domain dom;
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        u_int flags;
};
typedef struct remote_domain_set_memory_parameters_args remote_domain_set_memory_parameters_args;

struct remote_domain_get_memory_parameters_args {
        remote_nonnull_domain dom;
        int nparams;
        u_int flags;
};
typedef struct remote_domain_get_memory_parameters_args remote_domain_get_memory_parameters_args;

struct remote_domain_get_memory_parameters_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        int nparams;
};
typedef struct remote_domain_get_memory_parameters_ret remote_domain_get_memory_parameters_ret;

struct remote_domain_block_resize_args {
        remote_nonnull_domain dom;
        remote_nonnull_string disk;
        uint64_t size;
        u_int flags;
};
typedef struct remote_domain_block_resize_args remote_domain_block_resize_args;

struct remote_domain_set_numa_parameters_args {
        remote_nonnull_domain dom;
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        u_int flags;
};
typedef struct remote_domain_set_numa_parameters_args remote_domain_set_numa_parameters_args;

struct remote_domain_get_numa_parameters_args {
        remote_nonnull_domain dom;
        int nparams;
        u_int flags;
};
typedef struct remote_domain_get_numa_parameters_args remote_domain_get_numa_parameters_args;

struct remote_domain_get_numa_parameters_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        int nparams;
};
typedef struct remote_domain_get_numa_parameters_ret remote_domain_get_numa_parameters_ret;

struct remote_domain_block_stats_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
};
typedef struct remote_domain_block_stats_args remote_domain_block_stats_args;

struct remote_domain_block_stats_ret {
        int64_t rd_req;
        int64_t rd_bytes;
        int64_t wr_req;
        int64_t wr_bytes;
        int64_t errs;
};
typedef struct remote_domain_block_stats_ret remote_domain_block_stats_ret;

struct remote_domain_block_stats_flags_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        int nparams;
        u_int flags;
};
typedef struct remote_domain_block_stats_flags_args remote_domain_block_stats_flags_args;

struct remote_domain_block_stats_flags_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        int nparams;
};
typedef struct remote_domain_block_stats_flags_ret remote_domain_block_stats_flags_ret;

struct remote_domain_interface_stats_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
};
typedef struct remote_domain_interface_stats_args remote_domain_interface_stats_args;

struct remote_domain_interface_stats_ret {
        int64_t rx_bytes;
        int64_t rx_packets;
        int64_t rx_errs;
        int64_t rx_drop;
        int64_t tx_bytes;
        int64_t tx_packets;
        int64_t tx_errs;
        int64_t tx_drop;
};
typedef struct remote_domain_interface_stats_ret remote_domain_interface_stats_ret;

struct remote_domain_set_interface_parameters_args {
        remote_nonnull_domain dom;
        remote_nonnull_string device;
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        u_int flags;
};
typedef struct remote_domain_set_interface_parameters_args remote_domain_set_interface_parameters_args;

struct remote_domain_get_interface_parameters_args {
        remote_nonnull_domain dom;
        remote_nonnull_string device;
        int nparams;
        u_int flags;
};
typedef struct remote_domain_get_interface_parameters_args remote_domain_get_interface_parameters_args;

struct remote_domain_get_interface_parameters_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        int nparams;
};
typedef struct remote_domain_get_interface_parameters_ret remote_domain_get_interface_parameters_ret;

struct remote_domain_memory_stats_args {
        remote_nonnull_domain dom;
        u_int maxStats;
        u_int flags;
};
typedef struct remote_domain_memory_stats_args remote_domain_memory_stats_args;

struct remote_domain_memory_stat {
        int tag;
        uint64_t val;
};
typedef struct remote_domain_memory_stat remote_domain_memory_stat;

struct remote_domain_memory_stats_ret {
        struct {
                u_int stats_len;
                remote_domain_memory_stat *stats_val;
        } stats;
};
typedef struct remote_domain_memory_stats_ret remote_domain_memory_stats_ret;

struct remote_domain_block_peek_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        uint64_t offset;
        u_int size;
        u_int flags;
};
typedef struct remote_domain_block_peek_args remote_domain_block_peek_args;

struct remote_domain_block_peek_ret {
        struct {
                u_int buffer_len;
                char *buffer_val;
        } buffer;
};
typedef struct remote_domain_block_peek_ret remote_domain_block_peek_ret;

struct remote_domain_memory_peek_args {
        remote_nonnull_domain dom;
        uint64_t offset;
        u_int size;
        u_int flags;
};
typedef struct remote_domain_memory_peek_args remote_domain_memory_peek_args;

struct remote_domain_memory_peek_ret {
        struct {
                u_int buffer_len;
                char *buffer_val;
        } buffer;
};
typedef struct remote_domain_memory_peek_ret remote_domain_memory_peek_ret;

struct remote_domain_get_block_info_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        u_int flags;
};
typedef struct remote_domain_get_block_info_args remote_domain_get_block_info_args;

struct remote_domain_get_block_info_ret {
        uint64_t allocation;
        uint64_t capacity;
        uint64_t physical;
};
typedef struct remote_domain_get_block_info_ret remote_domain_get_block_info_ret;

struct remote_list_domains_args {
        int maxids;
};
typedef struct remote_list_domains_args remote_list_domains_args;

struct remote_list_domains_ret {
        struct {
                u_int ids_len;
                int *ids_val;
        } ids;
};
typedef struct remote_list_domains_ret remote_list_domains_ret;

struct remote_num_of_domains_ret {
        int num;
};
typedef struct remote_num_of_domains_ret remote_num_of_domains_ret;

struct remote_domain_create_xml_args {
        remote_nonnull_string xml_desc;
        u_int flags;
};
typedef struct remote_domain_create_xml_args remote_domain_create_xml_args;

struct remote_domain_create_xml_ret {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_create_xml_ret remote_domain_create_xml_ret;

struct remote_domain_lookup_by_id_args {
        int id;
};
typedef struct remote_domain_lookup_by_id_args remote_domain_lookup_by_id_args;

struct remote_domain_lookup_by_id_ret {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_lookup_by_id_ret remote_domain_lookup_by_id_ret;

struct remote_domain_lookup_by_uuid_args {
        remote_uuid uuid;
};
typedef struct remote_domain_lookup_by_uuid_args remote_domain_lookup_by_uuid_args;

struct remote_domain_lookup_by_uuid_ret {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_lookup_by_uuid_ret remote_domain_lookup_by_uuid_ret;

struct remote_domain_lookup_by_name_args {
        remote_nonnull_string name;
};
typedef struct remote_domain_lookup_by_name_args remote_domain_lookup_by_name_args;

struct remote_domain_lookup_by_name_ret {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_lookup_by_name_ret remote_domain_lookup_by_name_ret;

struct remote_domain_suspend_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_suspend_args remote_domain_suspend_args;

struct remote_domain_resume_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_resume_args remote_domain_resume_args;

struct remote_domain_pm_suspend_for_duration_args {
        remote_nonnull_domain dom;
        u_int target;
        uint64_t duration;
        u_int flags;
};
typedef struct remote_domain_pm_suspend_for_duration_args remote_domain_pm_suspend_for_duration_args;

struct remote_domain_pm_wakeup_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_pm_wakeup_args remote_domain_pm_wakeup_args;

struct remote_domain_shutdown_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_shutdown_args remote_domain_shutdown_args;

struct remote_domain_reboot_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_reboot_args remote_domain_reboot_args;

struct remote_domain_reset_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_reset_args remote_domain_reset_args;

struct remote_domain_destroy_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_destroy_args remote_domain_destroy_args;

struct remote_domain_destroy_flags_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_destroy_flags_args remote_domain_destroy_flags_args;

struct remote_domain_get_os_type_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_os_type_args remote_domain_get_os_type_args;

struct remote_domain_get_os_type_ret {
        remote_nonnull_string type;
};
typedef struct remote_domain_get_os_type_ret remote_domain_get_os_type_ret;

struct remote_domain_get_max_memory_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_max_memory_args remote_domain_get_max_memory_args;

struct remote_domain_get_max_memory_ret {
        uint64_t memory;
};
typedef struct remote_domain_get_max_memory_ret remote_domain_get_max_memory_ret;

struct remote_domain_set_max_memory_args {
        remote_nonnull_domain dom;
        uint64_t memory;
};
typedef struct remote_domain_set_max_memory_args remote_domain_set_max_memory_args;

struct remote_domain_set_memory_args {
        remote_nonnull_domain dom;
        uint64_t memory;
};
typedef struct remote_domain_set_memory_args remote_domain_set_memory_args;

struct remote_domain_set_memory_flags_args {
        remote_nonnull_domain dom;
        uint64_t memory;
        u_int flags;
};
typedef struct remote_domain_set_memory_flags_args remote_domain_set_memory_flags_args;

struct remote_domain_get_info_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_info_args remote_domain_get_info_args;

struct remote_domain_get_info_ret {
        u_char state;
        uint64_t maxMem;
        uint64_t memory;
        u_short nrVirtCpu;
        uint64_t cpuTime;
};
typedef struct remote_domain_get_info_ret remote_domain_get_info_ret;

struct remote_domain_save_args {
        remote_nonnull_domain dom;
        remote_nonnull_string to;
};
typedef struct remote_domain_save_args remote_domain_save_args;

struct remote_domain_save_flags_args {
        remote_nonnull_domain dom;
        remote_nonnull_string to;
        remote_string dxml;
        u_int flags;
};
typedef struct remote_domain_save_flags_args remote_domain_save_flags_args;

struct remote_domain_restore_args {
        remote_nonnull_string from;
};
typedef struct remote_domain_restore_args remote_domain_restore_args;

struct remote_domain_restore_flags_args {
        remote_nonnull_string from;
        remote_string dxml;
        u_int flags;
};
typedef struct remote_domain_restore_flags_args remote_domain_restore_flags_args;

struct remote_domain_save_image_get_xml_desc_args {
        remote_nonnull_string file;
        u_int flags;
};
typedef struct remote_domain_save_image_get_xml_desc_args remote_domain_save_image_get_xml_desc_args;

struct remote_domain_save_image_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_domain_save_image_get_xml_desc_ret remote_domain_save_image_get_xml_desc_ret;

struct remote_domain_save_image_define_xml_args {
        remote_nonnull_string file;
        remote_nonnull_string dxml;
        u_int flags;
};
typedef struct remote_domain_save_image_define_xml_args remote_domain_save_image_define_xml_args;

struct remote_domain_core_dump_args {
        remote_nonnull_domain dom;
        remote_nonnull_string to;
        u_int flags;
};
typedef struct remote_domain_core_dump_args remote_domain_core_dump_args;

struct remote_domain_screenshot_args {
        remote_nonnull_domain dom;
        u_int screen;
        u_int flags;
};
typedef struct remote_domain_screenshot_args remote_domain_screenshot_args;

struct remote_domain_screenshot_ret {
        remote_string mime;
};
typedef struct remote_domain_screenshot_ret remote_domain_screenshot_ret;

struct remote_domain_get_xml_desc_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_get_xml_desc_args remote_domain_get_xml_desc_args;

struct remote_domain_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_domain_get_xml_desc_ret remote_domain_get_xml_desc_ret;

struct remote_domain_migrate_prepare_args {
        remote_string uri_in;
        uint64_t flags;
        remote_string dname;
        uint64_t resource;
};
typedef struct remote_domain_migrate_prepare_args remote_domain_migrate_prepare_args;

struct remote_domain_migrate_prepare_ret {
        struct {
                u_int cookie_len;
                char *cookie_val;
        } cookie;
        remote_string uri_out;
};
typedef struct remote_domain_migrate_prepare_ret remote_domain_migrate_prepare_ret;

struct remote_domain_migrate_perform_args {
        remote_nonnull_domain dom;
        struct {
                u_int cookie_len;
                char *cookie_val;
        } cookie;
        remote_nonnull_string uri;
        uint64_t flags;
        remote_string dname;
        uint64_t resource;
};
typedef struct remote_domain_migrate_perform_args remote_domain_migrate_perform_args;

struct remote_domain_migrate_finish_args {
        remote_nonnull_string dname;
        struct {
                u_int cookie_len;
                char *cookie_val;
        } cookie;
        remote_nonnull_string uri;
        uint64_t flags;
};
typedef struct remote_domain_migrate_finish_args remote_domain_migrate_finish_args;

struct remote_domain_migrate_finish_ret {
        remote_nonnull_domain ddom;
};
typedef struct remote_domain_migrate_finish_ret remote_domain_migrate_finish_ret;

struct remote_domain_migrate_prepare2_args {
        remote_string uri_in;
        uint64_t flags;
        remote_string dname;
        uint64_t resource;
        remote_nonnull_string dom_xml;
};
typedef struct remote_domain_migrate_prepare2_args remote_domain_migrate_prepare2_args;

struct remote_domain_migrate_prepare2_ret {
        struct {
                u_int cookie_len;
                char *cookie_val;
        } cookie;
        remote_string uri_out;
};
typedef struct remote_domain_migrate_prepare2_ret remote_domain_migrate_prepare2_ret;

struct remote_domain_migrate_finish2_args {
        remote_nonnull_string dname;
        struct {
                u_int cookie_len;
                char *cookie_val;
        } cookie;
        remote_nonnull_string uri;
        uint64_t flags;
        int retcode;
};
typedef struct remote_domain_migrate_finish2_args remote_domain_migrate_finish2_args;

struct remote_domain_migrate_finish2_ret {
        remote_nonnull_domain ddom;
};
typedef struct remote_domain_migrate_finish2_ret remote_domain_migrate_finish2_ret;

struct remote_list_defined_domains_args {
        int maxnames;
};
typedef struct remote_list_defined_domains_args remote_list_defined_domains_args;

struct remote_list_defined_domains_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_list_defined_domains_ret remote_list_defined_domains_ret;

struct remote_num_of_defined_domains_ret {
        int num;
};
typedef struct remote_num_of_defined_domains_ret remote_num_of_defined_domains_ret;

struct remote_domain_create_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_create_args remote_domain_create_args;

struct remote_domain_create_with_flags_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_create_with_flags_args remote_domain_create_with_flags_args;

struct remote_domain_create_with_flags_ret {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_create_with_flags_ret remote_domain_create_with_flags_ret;

struct remote_domain_define_xml_args {
        remote_nonnull_string xml;
};
typedef struct remote_domain_define_xml_args remote_domain_define_xml_args;

struct remote_domain_define_xml_ret {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_define_xml_ret remote_domain_define_xml_ret;

struct remote_domain_undefine_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_undefine_args remote_domain_undefine_args;

struct remote_domain_undefine_flags_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_undefine_flags_args remote_domain_undefine_flags_args;

struct remote_domain_inject_nmi_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_inject_nmi_args remote_domain_inject_nmi_args;

struct remote_domain_send_key_args {
        remote_nonnull_domain dom;
        u_int codeset;
        u_int holdtime;
        struct {
                u_int keycodes_len;
                u_int *keycodes_val;
        } keycodes;
        u_int flags;
};
typedef struct remote_domain_send_key_args remote_domain_send_key_args;

struct remote_domain_send_process_signal_args {
        remote_nonnull_domain dom;
        int64_t pid_value;
        u_int signum;
        u_int flags;
};
typedef struct remote_domain_send_process_signal_args remote_domain_send_process_signal_args;

struct remote_domain_set_vcpus_args {
        remote_nonnull_domain dom;
        u_int nvcpus;
};
typedef struct remote_domain_set_vcpus_args remote_domain_set_vcpus_args;

struct remote_domain_set_vcpus_flags_args {
        remote_nonnull_domain dom;
        u_int nvcpus;
        u_int flags;
};
typedef struct remote_domain_set_vcpus_flags_args remote_domain_set_vcpus_flags_args;

struct remote_domain_get_vcpus_flags_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_get_vcpus_flags_args remote_domain_get_vcpus_flags_args;

struct remote_domain_get_vcpus_flags_ret {
        int num;
};
typedef struct remote_domain_get_vcpus_flags_ret remote_domain_get_vcpus_flags_ret;

struct remote_domain_pin_vcpu_args {
        remote_nonnull_domain dom;
        u_int vcpu;
        struct {
                u_int cpumap_len;
                char *cpumap_val;
        } cpumap;
};
typedef struct remote_domain_pin_vcpu_args remote_domain_pin_vcpu_args;

struct remote_domain_pin_vcpu_flags_args {
        remote_nonnull_domain dom;
        u_int vcpu;
        struct {
                u_int cpumap_len;
                char *cpumap_val;
        } cpumap;
        u_int flags;
};
typedef struct remote_domain_pin_vcpu_flags_args remote_domain_pin_vcpu_flags_args;

struct remote_domain_get_vcpu_pin_info_args {
        remote_nonnull_domain dom;
        int ncpumaps;
        int maplen;
        u_int flags;
};
typedef struct remote_domain_get_vcpu_pin_info_args remote_domain_get_vcpu_pin_info_args;

struct remote_domain_get_vcpu_pin_info_ret {
        struct {
                u_int cpumaps_len;
                char *cpumaps_val;
        } cpumaps;
        int num;
};
typedef struct remote_domain_get_vcpu_pin_info_ret remote_domain_get_vcpu_pin_info_ret;

struct remote_domain_pin_emulator_args {
        remote_nonnull_domain dom;
        struct {
                u_int cpumap_len;
                char *cpumap_val;
        } cpumap;
        u_int flags;
};
typedef struct remote_domain_pin_emulator_args remote_domain_pin_emulator_args;

struct remote_domain_get_emulator_pin_info_args {
        remote_nonnull_domain dom;
        int maplen;
        u_int flags;
};
typedef struct remote_domain_get_emulator_pin_info_args remote_domain_get_emulator_pin_info_args;

struct remote_domain_get_emulator_pin_info_ret {
        struct {
                u_int cpumaps_len;
                char *cpumaps_val;
        } cpumaps;
        int ret;
};
typedef struct remote_domain_get_emulator_pin_info_ret remote_domain_get_emulator_pin_info_ret;

struct remote_domain_get_vcpus_args {
        remote_nonnull_domain dom;
        int maxinfo;
        int maplen;
};
typedef struct remote_domain_get_vcpus_args remote_domain_get_vcpus_args;

struct remote_domain_get_vcpus_ret {
        struct {
                u_int info_len;
                remote_vcpu_info *info_val;
        } info;
        struct {
                u_int cpumaps_len;
                char *cpumaps_val;
        } cpumaps;
};
typedef struct remote_domain_get_vcpus_ret remote_domain_get_vcpus_ret;

struct remote_domain_get_max_vcpus_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_max_vcpus_args remote_domain_get_max_vcpus_args;

struct remote_domain_get_max_vcpus_ret {
        int num;
};
typedef struct remote_domain_get_max_vcpus_ret remote_domain_get_max_vcpus_ret;

struct remote_domain_get_security_label_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_security_label_args remote_domain_get_security_label_args;

struct remote_domain_get_security_label_ret {
        struct {
                u_int label_len;
                char *label_val;
        } label;
        int enforcing;
};
typedef struct remote_domain_get_security_label_ret remote_domain_get_security_label_ret;

struct remote_domain_get_security_label_list_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_security_label_list_args remote_domain_get_security_label_list_args;

struct remote_domain_get_security_label_list_ret {
        struct {
                u_int labels_len;
                remote_domain_get_security_label_ret *labels_val;
        } labels;
        int ret;
};
typedef struct remote_domain_get_security_label_list_ret remote_domain_get_security_label_list_ret;

struct remote_node_get_security_model_ret {
        struct {
                u_int model_len;
                char *model_val;
        } model;
        struct {
                u_int doi_len;
                char *doi_val;
        } doi;
};
typedef struct remote_node_get_security_model_ret remote_node_get_security_model_ret;

struct remote_domain_attach_device_args {
        remote_nonnull_domain dom;
        remote_nonnull_string xml;
};
typedef struct remote_domain_attach_device_args remote_domain_attach_device_args;

struct remote_domain_attach_device_flags_args {
        remote_nonnull_domain dom;
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_domain_attach_device_flags_args remote_domain_attach_device_flags_args;

struct remote_domain_detach_device_args {
        remote_nonnull_domain dom;
        remote_nonnull_string xml;
};
typedef struct remote_domain_detach_device_args remote_domain_detach_device_args;

struct remote_domain_detach_device_flags_args {
        remote_nonnull_domain dom;
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_domain_detach_device_flags_args remote_domain_detach_device_flags_args;

struct remote_domain_update_device_flags_args {
        remote_nonnull_domain dom;
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_domain_update_device_flags_args remote_domain_update_device_flags_args;

struct remote_domain_get_autostart_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_autostart_args remote_domain_get_autostart_args;

struct remote_domain_get_autostart_ret {
        int autostart;
};
typedef struct remote_domain_get_autostart_ret remote_domain_get_autostart_ret;

struct remote_domain_set_autostart_args {
        remote_nonnull_domain dom;
        int autostart;
};
typedef struct remote_domain_set_autostart_args remote_domain_set_autostart_args;

struct remote_domain_set_metadata_args {
        remote_nonnull_domain dom;
        int type;
        remote_string metadata;
        remote_string key;
        remote_string uri;
        u_int flags;
};
typedef struct remote_domain_set_metadata_args remote_domain_set_metadata_args;

struct remote_domain_get_metadata_args {
        remote_nonnull_domain dom;
        int type;
        remote_string uri;
        u_int flags;
};
typedef struct remote_domain_get_metadata_args remote_domain_get_metadata_args;

struct remote_domain_get_metadata_ret {
        remote_nonnull_string metadata;
};
typedef struct remote_domain_get_metadata_ret remote_domain_get_metadata_ret;

struct remote_domain_block_job_abort_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        u_int flags;
};
typedef struct remote_domain_block_job_abort_args remote_domain_block_job_abort_args;

struct remote_domain_get_block_job_info_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        u_int flags;
};
typedef struct remote_domain_get_block_job_info_args remote_domain_get_block_job_info_args;

struct remote_domain_get_block_job_info_ret {
        int found;
        int type;
        uint64_t bandwidth;
        uint64_t cur;
        uint64_t end;
};
typedef struct remote_domain_get_block_job_info_ret remote_domain_get_block_job_info_ret;

struct remote_domain_block_job_set_speed_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        uint64_t bandwidth;
        u_int flags;
};
typedef struct remote_domain_block_job_set_speed_args remote_domain_block_job_set_speed_args;

struct remote_domain_block_pull_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        uint64_t bandwidth;
        u_int flags;
};
typedef struct remote_domain_block_pull_args remote_domain_block_pull_args;

struct remote_domain_block_rebase_args {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        remote_string base;
        uint64_t bandwidth;
        u_int flags;
};
typedef struct remote_domain_block_rebase_args remote_domain_block_rebase_args;

struct remote_domain_block_commit_args {
        remote_nonnull_domain dom;
        remote_nonnull_string disk;
        remote_string base;
        remote_string top;
        uint64_t bandwidth;
        u_int flags;
};
typedef struct remote_domain_block_commit_args remote_domain_block_commit_args;

struct remote_domain_set_block_io_tune_args {
        remote_nonnull_domain dom;
        remote_nonnull_string disk;
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        u_int flags;
};
typedef struct remote_domain_set_block_io_tune_args remote_domain_set_block_io_tune_args;

struct remote_domain_get_block_io_tune_args {
        remote_nonnull_domain dom;
        remote_string disk;
        int nparams;
        u_int flags;
};
typedef struct remote_domain_get_block_io_tune_args remote_domain_get_block_io_tune_args;

struct remote_domain_get_block_io_tune_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        int nparams;
};
typedef struct remote_domain_get_block_io_tune_ret remote_domain_get_block_io_tune_ret;

struct remote_domain_get_cpu_stats_args {
        remote_nonnull_domain dom;
        u_int nparams;
        int start_cpu;
        u_int ncpus;
        u_int flags;
};
typedef struct remote_domain_get_cpu_stats_args remote_domain_get_cpu_stats_args;

struct remote_domain_get_cpu_stats_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        int nparams;
};
typedef struct remote_domain_get_cpu_stats_ret remote_domain_get_cpu_stats_ret;

struct remote_domain_get_hostname_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_get_hostname_args remote_domain_get_hostname_args;

struct remote_domain_get_hostname_ret {
        remote_nonnull_string hostname;
};
typedef struct remote_domain_get_hostname_ret remote_domain_get_hostname_ret;

struct remote_num_of_networks_ret {
        int num;
};
typedef struct remote_num_of_networks_ret remote_num_of_networks_ret;

struct remote_list_networks_args {
        int maxnames;
};
typedef struct remote_list_networks_args remote_list_networks_args;

struct remote_list_networks_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_list_networks_ret remote_list_networks_ret;

struct remote_num_of_defined_networks_ret {
        int num;
};
typedef struct remote_num_of_defined_networks_ret remote_num_of_defined_networks_ret;

struct remote_list_defined_networks_args {
        int maxnames;
};
typedef struct remote_list_defined_networks_args remote_list_defined_networks_args;

struct remote_list_defined_networks_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_list_defined_networks_ret remote_list_defined_networks_ret;

struct remote_network_lookup_by_uuid_args {
        remote_uuid uuid;
};
typedef struct remote_network_lookup_by_uuid_args remote_network_lookup_by_uuid_args;

struct remote_network_lookup_by_uuid_ret {
        remote_nonnull_network net;
};
typedef struct remote_network_lookup_by_uuid_ret remote_network_lookup_by_uuid_ret;

struct remote_network_lookup_by_name_args {
        remote_nonnull_string name;
};
typedef struct remote_network_lookup_by_name_args remote_network_lookup_by_name_args;

struct remote_network_lookup_by_name_ret {
        remote_nonnull_network net;
};
typedef struct remote_network_lookup_by_name_ret remote_network_lookup_by_name_ret;

struct remote_network_create_xml_args {
        remote_nonnull_string xml;
};
typedef struct remote_network_create_xml_args remote_network_create_xml_args;

struct remote_network_create_xml_ret {
        remote_nonnull_network net;
};
typedef struct remote_network_create_xml_ret remote_network_create_xml_ret;

struct remote_network_define_xml_args {
        remote_nonnull_string xml;
};
typedef struct remote_network_define_xml_args remote_network_define_xml_args;

struct remote_network_define_xml_ret {
        remote_nonnull_network net;
};
typedef struct remote_network_define_xml_ret remote_network_define_xml_ret;

struct remote_network_undefine_args {
        remote_nonnull_network net;
};
typedef struct remote_network_undefine_args remote_network_undefine_args;

struct remote_network_update_args {
        remote_nonnull_network net;
        u_int command;
        u_int section;
        int parentIndex;
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_network_update_args remote_network_update_args;

struct remote_network_create_args {
        remote_nonnull_network net;
};
typedef struct remote_network_create_args remote_network_create_args;

struct remote_network_destroy_args {
        remote_nonnull_network net;
};
typedef struct remote_network_destroy_args remote_network_destroy_args;

struct remote_network_get_xml_desc_args {
        remote_nonnull_network net;
        u_int flags;
};
typedef struct remote_network_get_xml_desc_args remote_network_get_xml_desc_args;

struct remote_network_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_network_get_xml_desc_ret remote_network_get_xml_desc_ret;

struct remote_network_get_bridge_name_args {
        remote_nonnull_network net;
};
typedef struct remote_network_get_bridge_name_args remote_network_get_bridge_name_args;

struct remote_network_get_bridge_name_ret {
        remote_nonnull_string name;
};
typedef struct remote_network_get_bridge_name_ret remote_network_get_bridge_name_ret;

struct remote_network_get_autostart_args {
        remote_nonnull_network net;
};
typedef struct remote_network_get_autostart_args remote_network_get_autostart_args;

struct remote_network_get_autostart_ret {
        int autostart;
};
typedef struct remote_network_get_autostart_ret remote_network_get_autostart_ret;

struct remote_network_set_autostart_args {
        remote_nonnull_network net;
        int autostart;
};
typedef struct remote_network_set_autostart_args remote_network_set_autostart_args;

struct remote_num_of_nwfilters_ret {
        int num;
};
typedef struct remote_num_of_nwfilters_ret remote_num_of_nwfilters_ret;

struct remote_list_nwfilters_args {
        int maxnames;
};
typedef struct remote_list_nwfilters_args remote_list_nwfilters_args;

struct remote_list_nwfilters_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_list_nwfilters_ret remote_list_nwfilters_ret;

struct remote_nwfilter_lookup_by_uuid_args {
        remote_uuid uuid;
};
typedef struct remote_nwfilter_lookup_by_uuid_args remote_nwfilter_lookup_by_uuid_args;

struct remote_nwfilter_lookup_by_uuid_ret {
        remote_nonnull_nwfilter nwfilter;
};
typedef struct remote_nwfilter_lookup_by_uuid_ret remote_nwfilter_lookup_by_uuid_ret;

struct remote_nwfilter_lookup_by_name_args {
        remote_nonnull_string name;
};
typedef struct remote_nwfilter_lookup_by_name_args remote_nwfilter_lookup_by_name_args;

struct remote_nwfilter_lookup_by_name_ret {
        remote_nonnull_nwfilter nwfilter;
};
typedef struct remote_nwfilter_lookup_by_name_ret remote_nwfilter_lookup_by_name_ret;

struct remote_nwfilter_define_xml_args {
        remote_nonnull_string xml;
};
typedef struct remote_nwfilter_define_xml_args remote_nwfilter_define_xml_args;

struct remote_nwfilter_define_xml_ret {
        remote_nonnull_nwfilter nwfilter;
};
typedef struct remote_nwfilter_define_xml_ret remote_nwfilter_define_xml_ret;

struct remote_nwfilter_undefine_args {
        remote_nonnull_nwfilter nwfilter;
};
typedef struct remote_nwfilter_undefine_args remote_nwfilter_undefine_args;

struct remote_nwfilter_get_xml_desc_args {
        remote_nonnull_nwfilter nwfilter;
        u_int flags;
};
typedef struct remote_nwfilter_get_xml_desc_args remote_nwfilter_get_xml_desc_args;

struct remote_nwfilter_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_nwfilter_get_xml_desc_ret remote_nwfilter_get_xml_desc_ret;

struct remote_num_of_interfaces_ret {
        int num;
};
typedef struct remote_num_of_interfaces_ret remote_num_of_interfaces_ret;

struct remote_list_interfaces_args {
        int maxnames;
};
typedef struct remote_list_interfaces_args remote_list_interfaces_args;

struct remote_list_interfaces_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_list_interfaces_ret remote_list_interfaces_ret;

struct remote_num_of_defined_interfaces_ret {
        int num;
};
typedef struct remote_num_of_defined_interfaces_ret remote_num_of_defined_interfaces_ret;

struct remote_list_defined_interfaces_args {
        int maxnames;
};
typedef struct remote_list_defined_interfaces_args remote_list_defined_interfaces_args;

struct remote_list_defined_interfaces_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_list_defined_interfaces_ret remote_list_defined_interfaces_ret;

struct remote_interface_lookup_by_name_args {
        remote_nonnull_string name;
};
typedef struct remote_interface_lookup_by_name_args remote_interface_lookup_by_name_args;

struct remote_interface_lookup_by_name_ret {
        remote_nonnull_interface iface;
};
typedef struct remote_interface_lookup_by_name_ret remote_interface_lookup_by_name_ret;

struct remote_interface_lookup_by_mac_string_args {
        remote_nonnull_string mac;
};
typedef struct remote_interface_lookup_by_mac_string_args remote_interface_lookup_by_mac_string_args;

struct remote_interface_lookup_by_mac_string_ret {
        remote_nonnull_interface iface;
};
typedef struct remote_interface_lookup_by_mac_string_ret remote_interface_lookup_by_mac_string_ret;

struct remote_interface_get_xml_desc_args {
        remote_nonnull_interface iface;
        u_int flags;
};
typedef struct remote_interface_get_xml_desc_args remote_interface_get_xml_desc_args;

struct remote_interface_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_interface_get_xml_desc_ret remote_interface_get_xml_desc_ret;

struct remote_interface_define_xml_args {
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_interface_define_xml_args remote_interface_define_xml_args;

struct remote_interface_define_xml_ret {
        remote_nonnull_interface iface;
};
typedef struct remote_interface_define_xml_ret remote_interface_define_xml_ret;

struct remote_interface_undefine_args {
        remote_nonnull_interface iface;
};
typedef struct remote_interface_undefine_args remote_interface_undefine_args;

struct remote_interface_create_args {
        remote_nonnull_interface iface;
        u_int flags;
};
typedef struct remote_interface_create_args remote_interface_create_args;

struct remote_interface_destroy_args {
        remote_nonnull_interface iface;
        u_int flags;
};
typedef struct remote_interface_destroy_args remote_interface_destroy_args;

struct remote_interface_change_begin_args {
        u_int flags;
};
typedef struct remote_interface_change_begin_args remote_interface_change_begin_args;

struct remote_interface_change_commit_args {
        u_int flags;
};
typedef struct remote_interface_change_commit_args remote_interface_change_commit_args;

struct remote_interface_change_rollback_args {
        u_int flags;
};
typedef struct remote_interface_change_rollback_args remote_interface_change_rollback_args;

struct remote_auth_list_ret {
        struct {
                u_int types_len;
                remote_auth_type *types_val;
        } types;
};
typedef struct remote_auth_list_ret remote_auth_list_ret;

struct remote_auth_sasl_init_ret {
        remote_nonnull_string mechlist;
};
typedef struct remote_auth_sasl_init_ret remote_auth_sasl_init_ret;

struct remote_auth_sasl_start_args {
        remote_nonnull_string mech;
        int nil;
        struct {
                u_int data_len;
                char *data_val;
        } data;
};
typedef struct remote_auth_sasl_start_args remote_auth_sasl_start_args;

struct remote_auth_sasl_start_ret {
        int complete;
        int nil;
        struct {
                u_int data_len;
                char *data_val;
        } data;
};
typedef struct remote_auth_sasl_start_ret remote_auth_sasl_start_ret;

struct remote_auth_sasl_step_args {
        int nil;
        struct {
                u_int data_len;
                char *data_val;
        } data;
};
typedef struct remote_auth_sasl_step_args remote_auth_sasl_step_args;

struct remote_auth_sasl_step_ret {
        int complete;
        int nil;
        struct {
                u_int data_len;
                char *data_val;
        } data;
};
typedef struct remote_auth_sasl_step_ret remote_auth_sasl_step_ret;

struct remote_auth_polkit_ret {
        int complete;
};
typedef struct remote_auth_polkit_ret remote_auth_polkit_ret;

struct remote_num_of_storage_pools_ret {
        int num;
};
typedef struct remote_num_of_storage_pools_ret remote_num_of_storage_pools_ret;

struct remote_list_storage_pools_args {
        int maxnames;
};
typedef struct remote_list_storage_pools_args remote_list_storage_pools_args;

struct remote_list_storage_pools_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_list_storage_pools_ret remote_list_storage_pools_ret;

struct remote_num_of_defined_storage_pools_ret {
        int num;
};
typedef struct remote_num_of_defined_storage_pools_ret remote_num_of_defined_storage_pools_ret;

struct remote_list_defined_storage_pools_args {
        int maxnames;
};
typedef struct remote_list_defined_storage_pools_args remote_list_defined_storage_pools_args;

struct remote_list_defined_storage_pools_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_list_defined_storage_pools_ret remote_list_defined_storage_pools_ret;

struct remote_find_storage_pool_sources_args {
        remote_nonnull_string type;
        remote_string srcSpec;
        u_int flags;
};
typedef struct remote_find_storage_pool_sources_args remote_find_storage_pool_sources_args;

struct remote_find_storage_pool_sources_ret {
        remote_nonnull_string xml;
};
typedef struct remote_find_storage_pool_sources_ret remote_find_storage_pool_sources_ret;

struct remote_storage_pool_lookup_by_uuid_args {
        remote_uuid uuid;
};
typedef struct remote_storage_pool_lookup_by_uuid_args remote_storage_pool_lookup_by_uuid_args;

struct remote_storage_pool_lookup_by_uuid_ret {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_lookup_by_uuid_ret remote_storage_pool_lookup_by_uuid_ret;

struct remote_storage_pool_lookup_by_name_args {
        remote_nonnull_string name;
};
typedef struct remote_storage_pool_lookup_by_name_args remote_storage_pool_lookup_by_name_args;

struct remote_storage_pool_lookup_by_name_ret {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_lookup_by_name_ret remote_storage_pool_lookup_by_name_ret;

struct remote_storage_pool_lookup_by_volume_args {
        remote_nonnull_storage_vol vol;
};
typedef struct remote_storage_pool_lookup_by_volume_args remote_storage_pool_lookup_by_volume_args;

struct remote_storage_pool_lookup_by_volume_ret {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_lookup_by_volume_ret remote_storage_pool_lookup_by_volume_ret;

struct remote_storage_pool_create_xml_args {
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_storage_pool_create_xml_args remote_storage_pool_create_xml_args;

struct remote_storage_pool_create_xml_ret {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_create_xml_ret remote_storage_pool_create_xml_ret;

struct remote_storage_pool_define_xml_args {
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_storage_pool_define_xml_args remote_storage_pool_define_xml_args;

struct remote_storage_pool_define_xml_ret {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_define_xml_ret remote_storage_pool_define_xml_ret;

struct remote_storage_pool_build_args {
        remote_nonnull_storage_pool pool;
        u_int flags;
};
typedef struct remote_storage_pool_build_args remote_storage_pool_build_args;

struct remote_storage_pool_undefine_args {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_undefine_args remote_storage_pool_undefine_args;

struct remote_storage_pool_create_args {
        remote_nonnull_storage_pool pool;
        u_int flags;
};
typedef struct remote_storage_pool_create_args remote_storage_pool_create_args;

struct remote_storage_pool_destroy_args {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_destroy_args remote_storage_pool_destroy_args;

struct remote_storage_pool_delete_args {
        remote_nonnull_storage_pool pool;
        u_int flags;
};
typedef struct remote_storage_pool_delete_args remote_storage_pool_delete_args;

struct remote_storage_pool_refresh_args {
        remote_nonnull_storage_pool pool;
        u_int flags;
};
typedef struct remote_storage_pool_refresh_args remote_storage_pool_refresh_args;

struct remote_storage_pool_get_xml_desc_args {
        remote_nonnull_storage_pool pool;
        u_int flags;
};
typedef struct remote_storage_pool_get_xml_desc_args remote_storage_pool_get_xml_desc_args;

struct remote_storage_pool_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_storage_pool_get_xml_desc_ret remote_storage_pool_get_xml_desc_ret;

struct remote_storage_pool_get_info_args {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_get_info_args remote_storage_pool_get_info_args;

struct remote_storage_pool_get_info_ret {
        u_char state;
        uint64_t capacity;
        uint64_t allocation;
        uint64_t available;
};
typedef struct remote_storage_pool_get_info_ret remote_storage_pool_get_info_ret;

struct remote_storage_pool_get_autostart_args {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_get_autostart_args remote_storage_pool_get_autostart_args;

struct remote_storage_pool_get_autostart_ret {
        int autostart;
};
typedef struct remote_storage_pool_get_autostart_ret remote_storage_pool_get_autostart_ret;

struct remote_storage_pool_set_autostart_args {
        remote_nonnull_storage_pool pool;
        int autostart;
};
typedef struct remote_storage_pool_set_autostart_args remote_storage_pool_set_autostart_args;

struct remote_storage_pool_num_of_volumes_args {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_num_of_volumes_args remote_storage_pool_num_of_volumes_args;

struct remote_storage_pool_num_of_volumes_ret {
        int num;
};
typedef struct remote_storage_pool_num_of_volumes_ret remote_storage_pool_num_of_volumes_ret;

struct remote_storage_pool_list_volumes_args {
        remote_nonnull_storage_pool pool;
        int maxnames;
};
typedef struct remote_storage_pool_list_volumes_args remote_storage_pool_list_volumes_args;

struct remote_storage_pool_list_volumes_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_storage_pool_list_volumes_ret remote_storage_pool_list_volumes_ret;

struct remote_storage_vol_lookup_by_name_args {
        remote_nonnull_storage_pool pool;
        remote_nonnull_string name;
};
typedef struct remote_storage_vol_lookup_by_name_args remote_storage_vol_lookup_by_name_args;

struct remote_storage_vol_lookup_by_name_ret {
        remote_nonnull_storage_vol vol;
};
typedef struct remote_storage_vol_lookup_by_name_ret remote_storage_vol_lookup_by_name_ret;

struct remote_storage_vol_lookup_by_key_args {
        remote_nonnull_string key;
};
typedef struct remote_storage_vol_lookup_by_key_args remote_storage_vol_lookup_by_key_args;

struct remote_storage_vol_lookup_by_key_ret {
        remote_nonnull_storage_vol vol;
};
typedef struct remote_storage_vol_lookup_by_key_ret remote_storage_vol_lookup_by_key_ret;

struct remote_storage_vol_lookup_by_path_args {
        remote_nonnull_string path;
};
typedef struct remote_storage_vol_lookup_by_path_args remote_storage_vol_lookup_by_path_args;

struct remote_storage_vol_lookup_by_path_ret {
        remote_nonnull_storage_vol vol;
};
typedef struct remote_storage_vol_lookup_by_path_ret remote_storage_vol_lookup_by_path_ret;

struct remote_storage_vol_create_xml_args {
        remote_nonnull_storage_pool pool;
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_storage_vol_create_xml_args remote_storage_vol_create_xml_args;

struct remote_storage_vol_create_xml_ret {
        remote_nonnull_storage_vol vol;
};
typedef struct remote_storage_vol_create_xml_ret remote_storage_vol_create_xml_ret;

struct remote_storage_vol_create_xml_from_args {
        remote_nonnull_storage_pool pool;
        remote_nonnull_string xml;
        remote_nonnull_storage_vol clonevol;
        u_int flags;
};
typedef struct remote_storage_vol_create_xml_from_args remote_storage_vol_create_xml_from_args;

struct remote_storage_vol_create_xml_from_ret {
        remote_nonnull_storage_vol vol;
};
typedef struct remote_storage_vol_create_xml_from_ret remote_storage_vol_create_xml_from_ret;

struct remote_storage_vol_delete_args {
        remote_nonnull_storage_vol vol;
        u_int flags;
};
typedef struct remote_storage_vol_delete_args remote_storage_vol_delete_args;

struct remote_storage_vol_wipe_args {
        remote_nonnull_storage_vol vol;
        u_int flags;
};
typedef struct remote_storage_vol_wipe_args remote_storage_vol_wipe_args;

struct remote_storage_vol_wipe_pattern_args {
        remote_nonnull_storage_vol vol;
        u_int algorithm;
        u_int flags;
};
typedef struct remote_storage_vol_wipe_pattern_args remote_storage_vol_wipe_pattern_args;

struct remote_storage_vol_get_xml_desc_args {
        remote_nonnull_storage_vol vol;
        u_int flags;
};
typedef struct remote_storage_vol_get_xml_desc_args remote_storage_vol_get_xml_desc_args;

struct remote_storage_vol_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_storage_vol_get_xml_desc_ret remote_storage_vol_get_xml_desc_ret;

struct remote_storage_vol_get_info_args {
        remote_nonnull_storage_vol vol;
};
typedef struct remote_storage_vol_get_info_args remote_storage_vol_get_info_args;

struct remote_storage_vol_get_info_ret {
        char type;
        uint64_t capacity;
        uint64_t allocation;
};
typedef struct remote_storage_vol_get_info_ret remote_storage_vol_get_info_ret;

struct remote_storage_vol_get_path_args {
        remote_nonnull_storage_vol vol;
};
typedef struct remote_storage_vol_get_path_args remote_storage_vol_get_path_args;

struct remote_storage_vol_get_path_ret {
        remote_nonnull_string name;
};
typedef struct remote_storage_vol_get_path_ret remote_storage_vol_get_path_ret;

struct remote_storage_vol_resize_args {
        remote_nonnull_storage_vol vol;
        uint64_t capacity;
        u_int flags;
};
typedef struct remote_storage_vol_resize_args remote_storage_vol_resize_args;

struct remote_node_num_of_devices_args {
        remote_string cap;
        u_int flags;
};
typedef struct remote_node_num_of_devices_args remote_node_num_of_devices_args;

struct remote_node_num_of_devices_ret {
        int num;
};
typedef struct remote_node_num_of_devices_ret remote_node_num_of_devices_ret;

struct remote_node_list_devices_args {
        remote_string cap;
        int maxnames;
        u_int flags;
};
typedef struct remote_node_list_devices_args remote_node_list_devices_args;

struct remote_node_list_devices_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_node_list_devices_ret remote_node_list_devices_ret;

struct remote_node_device_lookup_by_name_args {
        remote_nonnull_string name;
};
typedef struct remote_node_device_lookup_by_name_args remote_node_device_lookup_by_name_args;

struct remote_node_device_lookup_by_name_ret {
        remote_nonnull_node_device dev;
};
typedef struct remote_node_device_lookup_by_name_ret remote_node_device_lookup_by_name_ret;

struct remote_node_device_lookup_scsi_host_by_wwn_args {
        remote_nonnull_string wwnn;
        remote_nonnull_string wwpn;
        u_int flags;
};
typedef struct remote_node_device_lookup_scsi_host_by_wwn_args remote_node_device_lookup_scsi_host_by_wwn_args;

struct remote_node_device_lookup_scsi_host_by_wwn_ret {
        remote_nonnull_node_device dev;
};
typedef struct remote_node_device_lookup_scsi_host_by_wwn_ret remote_node_device_lookup_scsi_host_by_wwn_ret;

struct remote_node_device_get_xml_desc_args {
        remote_nonnull_string name;
        u_int flags;
};
typedef struct remote_node_device_get_xml_desc_args remote_node_device_get_xml_desc_args;

struct remote_node_device_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_node_device_get_xml_desc_ret remote_node_device_get_xml_desc_ret;

struct remote_node_device_get_parent_args {
        remote_nonnull_string name;
};
typedef struct remote_node_device_get_parent_args remote_node_device_get_parent_args;

struct remote_node_device_get_parent_ret {
        remote_string parent;
};
typedef struct remote_node_device_get_parent_ret remote_node_device_get_parent_ret;

struct remote_node_device_num_of_caps_args {
        remote_nonnull_string name;
};
typedef struct remote_node_device_num_of_caps_args remote_node_device_num_of_caps_args;

struct remote_node_device_num_of_caps_ret {
        int num;
};
typedef struct remote_node_device_num_of_caps_ret remote_node_device_num_of_caps_ret;

struct remote_node_device_list_caps_args {
        remote_nonnull_string name;
        int maxnames;
};
typedef struct remote_node_device_list_caps_args remote_node_device_list_caps_args;

struct remote_node_device_list_caps_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_node_device_list_caps_ret remote_node_device_list_caps_ret;

struct remote_node_device_dettach_args {
        remote_nonnull_string name;
};
typedef struct remote_node_device_dettach_args remote_node_device_dettach_args;

struct remote_node_device_re_attach_args {
        remote_nonnull_string name;
};
typedef struct remote_node_device_re_attach_args remote_node_device_re_attach_args;

struct remote_node_device_reset_args {
        remote_nonnull_string name;
};
typedef struct remote_node_device_reset_args remote_node_device_reset_args;

struct remote_node_device_create_xml_args {
        remote_nonnull_string xml_desc;
        u_int flags;
};
typedef struct remote_node_device_create_xml_args remote_node_device_create_xml_args;

struct remote_node_device_create_xml_ret {
        remote_nonnull_node_device dev;
};
typedef struct remote_node_device_create_xml_ret remote_node_device_create_xml_ret;

struct remote_node_device_destroy_args {
        remote_nonnull_string name;
};
typedef struct remote_node_device_destroy_args remote_node_device_destroy_args;

struct remote_domain_events_register_ret {
        int cb_registered;
};
typedef struct remote_domain_events_register_ret remote_domain_events_register_ret;

struct remote_domain_events_deregister_ret {
        int cb_registered;
};
typedef struct remote_domain_events_deregister_ret remote_domain_events_deregister_ret;

struct remote_domain_event_lifecycle_msg {
        remote_nonnull_domain dom;
        int event;
        int detail;
};
typedef struct remote_domain_event_lifecycle_msg remote_domain_event_lifecycle_msg;

struct remote_domain_xml_from_native_args {
        remote_nonnull_string nativeFormat;
        remote_nonnull_string nativeConfig;
        u_int flags;
};
typedef struct remote_domain_xml_from_native_args remote_domain_xml_from_native_args;

struct remote_domain_xml_from_native_ret {
        remote_nonnull_string domainXml;
};
typedef struct remote_domain_xml_from_native_ret remote_domain_xml_from_native_ret;

struct remote_domain_xml_to_native_args {
        remote_nonnull_string nativeFormat;
        remote_nonnull_string domainXml;
        u_int flags;
};
typedef struct remote_domain_xml_to_native_args remote_domain_xml_to_native_args;

struct remote_domain_xml_to_native_ret {
        remote_nonnull_string nativeConfig;
};
typedef struct remote_domain_xml_to_native_ret remote_domain_xml_to_native_ret;

struct remote_num_of_secrets_ret {
        int num;
};
typedef struct remote_num_of_secrets_ret remote_num_of_secrets_ret;

struct remote_list_secrets_args {
        int maxuuids;
};
typedef struct remote_list_secrets_args remote_list_secrets_args;

struct remote_list_secrets_ret {
        struct {
                u_int uuids_len;
                remote_nonnull_string *uuids_val;
        } uuids;
};
typedef struct remote_list_secrets_ret remote_list_secrets_ret;

struct remote_secret_lookup_by_uuid_args {
        remote_uuid uuid;
};
typedef struct remote_secret_lookup_by_uuid_args remote_secret_lookup_by_uuid_args;

struct remote_secret_lookup_by_uuid_ret {
        remote_nonnull_secret secret;
};
typedef struct remote_secret_lookup_by_uuid_ret remote_secret_lookup_by_uuid_ret;

struct remote_secret_define_xml_args {
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_secret_define_xml_args remote_secret_define_xml_args;

struct remote_secret_define_xml_ret {
        remote_nonnull_secret secret;
};
typedef struct remote_secret_define_xml_ret remote_secret_define_xml_ret;

struct remote_secret_get_xml_desc_args {
        remote_nonnull_secret secret;
        u_int flags;
};
typedef struct remote_secret_get_xml_desc_args remote_secret_get_xml_desc_args;

struct remote_secret_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_secret_get_xml_desc_ret remote_secret_get_xml_desc_ret;

struct remote_secret_set_value_args {
        remote_nonnull_secret secret;
        struct {
                u_int value_len;
                char *value_val;
        } value;
        u_int flags;
};
typedef struct remote_secret_set_value_args remote_secret_set_value_args;

struct remote_secret_get_value_args {
        remote_nonnull_secret secret;
        u_int flags;
};
typedef struct remote_secret_get_value_args remote_secret_get_value_args;

struct remote_secret_get_value_ret {
        struct {
                u_int value_len;
                char *value_val;
        } value;
};
typedef struct remote_secret_get_value_ret remote_secret_get_value_ret;

struct remote_secret_undefine_args {
        remote_nonnull_secret secret;
};
typedef struct remote_secret_undefine_args remote_secret_undefine_args;

struct remote_secret_lookup_by_usage_args {
        int usageType;
        remote_nonnull_string usageID;
};
typedef struct remote_secret_lookup_by_usage_args remote_secret_lookup_by_usage_args;

struct remote_secret_lookup_by_usage_ret {
        remote_nonnull_secret secret;
};
typedef struct remote_secret_lookup_by_usage_ret remote_secret_lookup_by_usage_ret;

struct remote_domain_migrate_prepare_tunnel_args {
        uint64_t flags;
        remote_string dname;
        uint64_t resource;
        remote_nonnull_string dom_xml;
};
typedef struct remote_domain_migrate_prepare_tunnel_args remote_domain_migrate_prepare_tunnel_args;

struct remote_is_secure_ret {
        int secure;
};
typedef struct remote_is_secure_ret remote_is_secure_ret;

struct remote_domain_is_active_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_is_active_args remote_domain_is_active_args;

struct remote_domain_is_active_ret {
        int active;
};
typedef struct remote_domain_is_active_ret remote_domain_is_active_ret;

struct remote_domain_is_persistent_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_is_persistent_args remote_domain_is_persistent_args;

struct remote_domain_is_persistent_ret {
        int persistent;
};
typedef struct remote_domain_is_persistent_ret remote_domain_is_persistent_ret;

struct remote_domain_is_updated_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_is_updated_args remote_domain_is_updated_args;

struct remote_domain_is_updated_ret {
        int updated;
};
typedef struct remote_domain_is_updated_ret remote_domain_is_updated_ret;

struct remote_network_is_active_args {
        remote_nonnull_network net;
};
typedef struct remote_network_is_active_args remote_network_is_active_args;

struct remote_network_is_active_ret {
        int active;
};
typedef struct remote_network_is_active_ret remote_network_is_active_ret;

struct remote_network_is_persistent_args {
        remote_nonnull_network net;
};
typedef struct remote_network_is_persistent_args remote_network_is_persistent_args;

struct remote_network_is_persistent_ret {
        int persistent;
};
typedef struct remote_network_is_persistent_ret remote_network_is_persistent_ret;

struct remote_storage_pool_is_active_args {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_is_active_args remote_storage_pool_is_active_args;

struct remote_storage_pool_is_active_ret {
        int active;
};
typedef struct remote_storage_pool_is_active_ret remote_storage_pool_is_active_ret;

struct remote_storage_pool_is_persistent_args {
        remote_nonnull_storage_pool pool;
};
typedef struct remote_storage_pool_is_persistent_args remote_storage_pool_is_persistent_args;

struct remote_storage_pool_is_persistent_ret {
        int persistent;
};
typedef struct remote_storage_pool_is_persistent_ret remote_storage_pool_is_persistent_ret;

struct remote_interface_is_active_args {
        remote_nonnull_interface iface;
};
typedef struct remote_interface_is_active_args remote_interface_is_active_args;

struct remote_interface_is_active_ret {
        int active;
};
typedef struct remote_interface_is_active_ret remote_interface_is_active_ret;

struct remote_cpu_compare_args {
        remote_nonnull_string xml;
        u_int flags;
};
typedef struct remote_cpu_compare_args remote_cpu_compare_args;

struct remote_cpu_compare_ret {
        int result;
};
typedef struct remote_cpu_compare_ret remote_cpu_compare_ret;

struct remote_cpu_baseline_args {
        struct {
                u_int xmlCPUs_len;
                remote_nonnull_string *xmlCPUs_val;
        } xmlCPUs;
        u_int flags;
};
typedef struct remote_cpu_baseline_args remote_cpu_baseline_args;

struct remote_cpu_baseline_ret {
        remote_nonnull_string cpu;
};
typedef struct remote_cpu_baseline_ret remote_cpu_baseline_ret;

struct remote_domain_get_job_info_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_get_job_info_args remote_domain_get_job_info_args;

struct remote_domain_get_job_info_ret {
        int type;
        uint64_t timeElapsed;
        uint64_t timeRemaining;
        uint64_t dataTotal;
        uint64_t dataProcessed;
        uint64_t dataRemaining;
        uint64_t memTotal;
        uint64_t memProcessed;
        uint64_t memRemaining;
        uint64_t fileTotal;
        uint64_t fileProcessed;
        uint64_t fileRemaining;
};
typedef struct remote_domain_get_job_info_ret remote_domain_get_job_info_ret;

struct remote_domain_get_job_stats_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_get_job_stats_args remote_domain_get_job_stats_args;

struct remote_domain_get_job_stats_ret {
        int type;
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
};
typedef struct remote_domain_get_job_stats_ret remote_domain_get_job_stats_ret;

struct remote_domain_abort_job_args {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_abort_job_args remote_domain_abort_job_args;

struct remote_domain_migrate_set_max_downtime_args {
        remote_nonnull_domain dom;
        uint64_t downtime;
        u_int flags;
};
typedef struct remote_domain_migrate_set_max_downtime_args remote_domain_migrate_set_max_downtime_args;

struct remote_domain_migrate_get_compression_cache_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_migrate_get_compression_cache_args remote_domain_migrate_get_compression_cache_args;

struct remote_domain_migrate_get_compression_cache_ret {
        uint64_t cacheSize;
};
typedef struct remote_domain_migrate_get_compression_cache_ret remote_domain_migrate_get_compression_cache_ret;

struct remote_domain_migrate_set_compression_cache_args {
        remote_nonnull_domain dom;
        uint64_t cacheSize;
        u_int flags;
};
typedef struct remote_domain_migrate_set_compression_cache_args remote_domain_migrate_set_compression_cache_args;

struct remote_domain_migrate_set_max_speed_args {
        remote_nonnull_domain dom;
        uint64_t bandwidth;
        u_int flags;
};
typedef struct remote_domain_migrate_set_max_speed_args remote_domain_migrate_set_max_speed_args;

struct remote_domain_migrate_get_max_speed_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_migrate_get_max_speed_args remote_domain_migrate_get_max_speed_args;

struct remote_domain_migrate_get_max_speed_ret {
        uint64_t bandwidth;
};
typedef struct remote_domain_migrate_get_max_speed_ret remote_domain_migrate_get_max_speed_ret;

struct remote_domain_events_register_any_args {
        int eventID;
};
typedef struct remote_domain_events_register_any_args remote_domain_events_register_any_args;

struct remote_domain_events_deregister_any_args {
        int eventID;
};
typedef struct remote_domain_events_deregister_any_args remote_domain_events_deregister_any_args;

struct remote_domain_event_reboot_msg {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_event_reboot_msg remote_domain_event_reboot_msg;

struct remote_domain_event_rtc_change_msg {
        remote_nonnull_domain dom;
        int64_t offset;
};
typedef struct remote_domain_event_rtc_change_msg remote_domain_event_rtc_change_msg;

struct remote_domain_event_watchdog_msg {
        remote_nonnull_domain dom;
        int action;
};
typedef struct remote_domain_event_watchdog_msg remote_domain_event_watchdog_msg;

struct remote_domain_event_io_error_msg {
        remote_nonnull_domain dom;
        remote_nonnull_string srcPath;
        remote_nonnull_string devAlias;
        int action;
};
typedef struct remote_domain_event_io_error_msg remote_domain_event_io_error_msg;

struct remote_domain_event_io_error_reason_msg {
        remote_nonnull_domain dom;
        remote_nonnull_string srcPath;
        remote_nonnull_string devAlias;
        int action;
        remote_nonnull_string reason;
};
typedef struct remote_domain_event_io_error_reason_msg remote_domain_event_io_error_reason_msg;

struct remote_domain_event_graphics_address {
        int family;
        remote_nonnull_string node;
        remote_nonnull_string service;
};
typedef struct remote_domain_event_graphics_address remote_domain_event_graphics_address;
#define REMOTE_DOMAIN_EVENT_GRAPHICS_IDENTITY_MAX 20

struct remote_domain_event_graphics_identity {
        remote_nonnull_string type;
        remote_nonnull_string name;
};
typedef struct remote_domain_event_graphics_identity remote_domain_event_graphics_identity;

struct remote_domain_event_graphics_msg {
        remote_nonnull_domain dom;
        int phase;
        remote_domain_event_graphics_address local;
        remote_domain_event_graphics_address remote;
        remote_nonnull_string authScheme;
        struct {
                u_int subject_len;
                remote_domain_event_graphics_identity *subject_val;
        } subject;
};
typedef struct remote_domain_event_graphics_msg remote_domain_event_graphics_msg;

struct remote_domain_event_block_job_msg {
        remote_nonnull_domain dom;
        remote_nonnull_string path;
        int type;
        int status;
};
typedef struct remote_domain_event_block_job_msg remote_domain_event_block_job_msg;

struct remote_domain_event_disk_change_msg {
        remote_nonnull_domain dom;
        remote_string oldSrcPath;
        remote_string newSrcPath;
        remote_nonnull_string devAlias;
        int reason;
};
typedef struct remote_domain_event_disk_change_msg remote_domain_event_disk_change_msg;

struct remote_domain_event_tray_change_msg {
        remote_nonnull_domain dom;
        remote_nonnull_string devAlias;
        int reason;
};
typedef struct remote_domain_event_tray_change_msg remote_domain_event_tray_change_msg;

struct remote_domain_event_pmwakeup_msg {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_event_pmwakeup_msg remote_domain_event_pmwakeup_msg;

struct remote_domain_event_pmsuspend_msg {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_event_pmsuspend_msg remote_domain_event_pmsuspend_msg;

struct remote_domain_event_balloon_change_msg {
        remote_nonnull_domain dom;
        uint64_t actual;
};
typedef struct remote_domain_event_balloon_change_msg remote_domain_event_balloon_change_msg;

struct remote_domain_event_pmsuspend_disk_msg {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_event_pmsuspend_disk_msg remote_domain_event_pmsuspend_disk_msg;

struct remote_domain_managed_save_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_managed_save_args remote_domain_managed_save_args;

struct remote_domain_has_managed_save_image_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_has_managed_save_image_args remote_domain_has_managed_save_image_args;

struct remote_domain_has_managed_save_image_ret {
        int result;
};
typedef struct remote_domain_has_managed_save_image_ret remote_domain_has_managed_save_image_ret;

struct remote_domain_managed_save_remove_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_managed_save_remove_args remote_domain_managed_save_remove_args;

struct remote_domain_snapshot_create_xml_args {
        remote_nonnull_domain dom;
        remote_nonnull_string xml_desc;
        u_int flags;
};
typedef struct remote_domain_snapshot_create_xml_args remote_domain_snapshot_create_xml_args;

struct remote_domain_snapshot_create_xml_ret {
        remote_nonnull_domain_snapshot snap;
};
typedef struct remote_domain_snapshot_create_xml_ret remote_domain_snapshot_create_xml_ret;

struct remote_domain_snapshot_get_xml_desc_args {
        remote_nonnull_domain_snapshot snap;
        u_int flags;
};
typedef struct remote_domain_snapshot_get_xml_desc_args remote_domain_snapshot_get_xml_desc_args;

struct remote_domain_snapshot_get_xml_desc_ret {
        remote_nonnull_string xml;
};
typedef struct remote_domain_snapshot_get_xml_desc_ret remote_domain_snapshot_get_xml_desc_ret;

struct remote_domain_snapshot_num_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_snapshot_num_args remote_domain_snapshot_num_args;

struct remote_domain_snapshot_num_ret {
        int num;
};
typedef struct remote_domain_snapshot_num_ret remote_domain_snapshot_num_ret;

struct remote_domain_snapshot_list_names_args {
        remote_nonnull_domain dom;
        int maxnames;
        u_int flags;
};
typedef struct remote_domain_snapshot_list_names_args remote_domain_snapshot_list_names_args;

struct remote_domain_snapshot_list_names_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_domain_snapshot_list_names_ret remote_domain_snapshot_list_names_ret;

struct remote_domain_list_all_snapshots_args {
        remote_nonnull_domain dom;
        int need_results;
        u_int flags;
};
typedef struct remote_domain_list_all_snapshots_args remote_domain_list_all_snapshots_args;

struct remote_domain_list_all_snapshots_ret {
        struct {
                u_int snapshots_len;
                remote_nonnull_domain_snapshot *snapshots_val;
        } snapshots;
        int ret;
};
typedef struct remote_domain_list_all_snapshots_ret remote_domain_list_all_snapshots_ret;

struct remote_domain_snapshot_num_children_args {
        remote_nonnull_domain_snapshot snap;
        u_int flags;
};
typedef struct remote_domain_snapshot_num_children_args remote_domain_snapshot_num_children_args;

struct remote_domain_snapshot_num_children_ret {
        int num;
};
typedef struct remote_domain_snapshot_num_children_ret remote_domain_snapshot_num_children_ret;

struct remote_domain_snapshot_list_children_names_args {
        remote_nonnull_domain_snapshot snap;
        int maxnames;
        u_int flags;
};
typedef struct remote_domain_snapshot_list_children_names_args remote_domain_snapshot_list_children_names_args;

struct remote_domain_snapshot_list_children_names_ret {
        struct {
                u_int names_len;
                remote_nonnull_string *names_val;
        } names;
};
typedef struct remote_domain_snapshot_list_children_names_ret remote_domain_snapshot_list_children_names_ret;

struct remote_domain_snapshot_list_all_children_args {
        remote_nonnull_domain_snapshot snapshot;
        int need_results;
        u_int flags;
};
typedef struct remote_domain_snapshot_list_all_children_args remote_domain_snapshot_list_all_children_args;

struct remote_domain_snapshot_list_all_children_ret {
        struct {
                u_int snapshots_len;
                remote_nonnull_domain_snapshot *snapshots_val;
        } snapshots;
        int ret;
};
typedef struct remote_domain_snapshot_list_all_children_ret remote_domain_snapshot_list_all_children_ret;

struct remote_domain_snapshot_lookup_by_name_args {
        remote_nonnull_domain dom;
        remote_nonnull_string name;
        u_int flags;
};
typedef struct remote_domain_snapshot_lookup_by_name_args remote_domain_snapshot_lookup_by_name_args;

struct remote_domain_snapshot_lookup_by_name_ret {
        remote_nonnull_domain_snapshot snap;
};
typedef struct remote_domain_snapshot_lookup_by_name_ret remote_domain_snapshot_lookup_by_name_ret;

struct remote_domain_has_current_snapshot_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_has_current_snapshot_args remote_domain_has_current_snapshot_args;

struct remote_domain_has_current_snapshot_ret {
        int result;
};
typedef struct remote_domain_has_current_snapshot_ret remote_domain_has_current_snapshot_ret;

struct remote_domain_snapshot_get_parent_args {
        remote_nonnull_domain_snapshot snap;
        u_int flags;
};
typedef struct remote_domain_snapshot_get_parent_args remote_domain_snapshot_get_parent_args;

struct remote_domain_snapshot_get_parent_ret {
        remote_nonnull_domain_snapshot snap;
};
typedef struct remote_domain_snapshot_get_parent_ret remote_domain_snapshot_get_parent_ret;

struct remote_domain_snapshot_current_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_snapshot_current_args remote_domain_snapshot_current_args;

struct remote_domain_snapshot_current_ret {
        remote_nonnull_domain_snapshot snap;
};
typedef struct remote_domain_snapshot_current_ret remote_domain_snapshot_current_ret;

struct remote_domain_snapshot_is_current_args {
        remote_nonnull_domain_snapshot snap;
        u_int flags;
};
typedef struct remote_domain_snapshot_is_current_args remote_domain_snapshot_is_current_args;

struct remote_domain_snapshot_is_current_ret {
        int current;
};
typedef struct remote_domain_snapshot_is_current_ret remote_domain_snapshot_is_current_ret;

struct remote_domain_snapshot_has_metadata_args {
        remote_nonnull_domain_snapshot snap;
        u_int flags;
};
typedef struct remote_domain_snapshot_has_metadata_args remote_domain_snapshot_has_metadata_args;

struct remote_domain_snapshot_has_metadata_ret {
        int metadata;
};
typedef struct remote_domain_snapshot_has_metadata_ret remote_domain_snapshot_has_metadata_ret;

struct remote_domain_revert_to_snapshot_args {
        remote_nonnull_domain_snapshot snap;
        u_int flags;
};
typedef struct remote_domain_revert_to_snapshot_args remote_domain_revert_to_snapshot_args;

struct remote_domain_snapshot_delete_args {
        remote_nonnull_domain_snapshot snap;
        u_int flags;
};
typedef struct remote_domain_snapshot_delete_args remote_domain_snapshot_delete_args;

struct remote_domain_open_console_args {
        remote_nonnull_domain dom;
        remote_string dev_name;
        u_int flags;
};
typedef struct remote_domain_open_console_args remote_domain_open_console_args;

struct remote_domain_open_channel_args {
        remote_nonnull_domain dom;
        remote_string name;
        u_int flags;
};
typedef struct remote_domain_open_channel_args remote_domain_open_channel_args;

struct remote_storage_vol_upload_args {
        remote_nonnull_storage_vol vol;
        uint64_t offset;
        uint64_t length;
        u_int flags;
};
typedef struct remote_storage_vol_upload_args remote_storage_vol_upload_args;

struct remote_storage_vol_download_args {
        remote_nonnull_storage_vol vol;
        uint64_t offset;
        uint64_t length;
        u_int flags;
};
typedef struct remote_storage_vol_download_args remote_storage_vol_download_args;

struct remote_domain_get_state_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_get_state_args remote_domain_get_state_args;

struct remote_domain_get_state_ret {
        int state;
        int reason;
};
typedef struct remote_domain_get_state_ret remote_domain_get_state_ret;

struct remote_domain_migrate_begin3_args {
        remote_nonnull_domain dom;
        remote_string xmlin;
        uint64_t flags;
        remote_string dname;
        uint64_t resource;
};
typedef struct remote_domain_migrate_begin3_args remote_domain_migrate_begin3_args;

struct remote_domain_migrate_begin3_ret {
        struct {
                u_int cookie_out_len;
                char *cookie_out_val;
        } cookie_out;
        remote_nonnull_string xml;
};
typedef struct remote_domain_migrate_begin3_ret remote_domain_migrate_begin3_ret;

struct remote_domain_migrate_prepare3_args {
        struct {
                u_int cookie_in_len;
                char *cookie_in_val;
        } cookie_in;
        remote_string uri_in;
        uint64_t flags;
        remote_string dname;
        uint64_t resource;
        remote_nonnull_string dom_xml;
};
typedef struct remote_domain_migrate_prepare3_args remote_domain_migrate_prepare3_args;

struct remote_domain_migrate_prepare3_ret {
        struct {
                u_int cookie_out_len;
                char *cookie_out_val;
        } cookie_out;
        remote_string uri_out;
};
typedef struct remote_domain_migrate_prepare3_ret remote_domain_migrate_prepare3_ret;

struct remote_domain_migrate_prepare_tunnel3_args {
        struct {
                u_int cookie_in_len;
                char *cookie_in_val;
        } cookie_in;
        uint64_t flags;
        remote_string dname;
        uint64_t resource;
        remote_nonnull_string dom_xml;
};
typedef struct remote_domain_migrate_prepare_tunnel3_args remote_domain_migrate_prepare_tunnel3_args;

struct remote_domain_migrate_prepare_tunnel3_ret {
        struct {
                u_int cookie_out_len;
                char *cookie_out_val;
        } cookie_out;
};
typedef struct remote_domain_migrate_prepare_tunnel3_ret remote_domain_migrate_prepare_tunnel3_ret;

struct remote_domain_migrate_perform3_args {
        remote_nonnull_domain dom;
        remote_string xmlin;
        struct {
                u_int cookie_in_len;
                char *cookie_in_val;
        } cookie_in;
        remote_string dconnuri;
        remote_string uri;
        uint64_t flags;
        remote_string dname;
        uint64_t resource;
};
typedef struct remote_domain_migrate_perform3_args remote_domain_migrate_perform3_args;

struct remote_domain_migrate_perform3_ret {
        struct {
                u_int cookie_out_len;
                char *cookie_out_val;
        } cookie_out;
};
typedef struct remote_domain_migrate_perform3_ret remote_domain_migrate_perform3_ret;

struct remote_domain_migrate_finish3_args {
        remote_nonnull_string dname;
        struct {
                u_int cookie_in_len;
                char *cookie_in_val;
        } cookie_in;
        remote_string dconnuri;
        remote_string uri;
        uint64_t flags;
        int cancelled;
};
typedef struct remote_domain_migrate_finish3_args remote_domain_migrate_finish3_args;

struct remote_domain_migrate_finish3_ret {
        remote_nonnull_domain dom;
        struct {
                u_int cookie_out_len;
                char *cookie_out_val;
        } cookie_out;
};
typedef struct remote_domain_migrate_finish3_ret remote_domain_migrate_finish3_ret;

struct remote_domain_migrate_confirm3_args {
        remote_nonnull_domain dom;
        struct {
                u_int cookie_in_len;
                char *cookie_in_val;
        } cookie_in;
        uint64_t flags;
        int cancelled;
};
typedef struct remote_domain_migrate_confirm3_args remote_domain_migrate_confirm3_args;

struct remote_domain_event_control_error_msg {
        remote_nonnull_domain dom;
};
typedef struct remote_domain_event_control_error_msg remote_domain_event_control_error_msg;

struct remote_domain_get_control_info_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_get_control_info_args remote_domain_get_control_info_args;

struct remote_domain_get_control_info_ret {
        u_int state;
        u_int details;
        uint64_t stateTime;
};
typedef struct remote_domain_get_control_info_ret remote_domain_get_control_info_ret;

struct remote_domain_open_graphics_args {
        remote_nonnull_domain dom;
        u_int idx;
        u_int flags;
};
typedef struct remote_domain_open_graphics_args remote_domain_open_graphics_args;

struct remote_node_suspend_for_duration_args {
        u_int target;
        uint64_t duration;
        u_int flags;
};
typedef struct remote_node_suspend_for_duration_args remote_node_suspend_for_duration_args;

struct remote_domain_shutdown_flags_args {
        remote_nonnull_domain dom;
        u_int flags;
};
typedef struct remote_domain_shutdown_flags_args remote_domain_shutdown_flags_args;

struct remote_domain_get_disk_errors_args {
        remote_nonnull_domain dom;
        u_int maxerrors;
        u_int flags;
};
typedef struct remote_domain_get_disk_errors_args remote_domain_get_disk_errors_args;

struct remote_domain_get_disk_errors_ret {
        struct {
                u_int errors_len;
                remote_domain_disk_error *errors_val;
        } errors;
        int nerrors;
};
typedef struct remote_domain_get_disk_errors_ret remote_domain_get_disk_errors_ret;

struct remote_connect_list_all_domains_args {
        int need_results;
        u_int flags;
};
typedef struct remote_connect_list_all_domains_args remote_connect_list_all_domains_args;

struct remote_connect_list_all_domains_ret {
        struct {
                u_int domains_len;
                remote_nonnull_domain *domains_val;
        } domains;
        u_int ret;
};
typedef struct remote_connect_list_all_domains_ret remote_connect_list_all_domains_ret;

struct remote_connect_list_all_storage_pools_args {
        int need_results;
        u_int flags;
};
typedef struct remote_connect_list_all_storage_pools_args remote_connect_list_all_storage_pools_args;

struct remote_connect_list_all_storage_pools_ret {
        struct {
                u_int pools_len;
                remote_nonnull_storage_pool *pools_val;
        } pools;
        u_int ret;
};
typedef struct remote_connect_list_all_storage_pools_ret remote_connect_list_all_storage_pools_ret;

struct remote_storage_pool_list_all_volumes_args {
        remote_nonnull_storage_pool pool;
        int need_results;
        u_int flags;
};
typedef struct remote_storage_pool_list_all_volumes_args remote_storage_pool_list_all_volumes_args;

struct remote_storage_pool_list_all_volumes_ret {
        struct {
                u_int vols_len;
                remote_nonnull_storage_vol *vols_val;
        } vols;
        u_int ret;
};
typedef struct remote_storage_pool_list_all_volumes_ret remote_storage_pool_list_all_volumes_ret;

struct remote_connect_list_all_networks_args {
        int need_results;
        u_int flags;
};
typedef struct remote_connect_list_all_networks_args remote_connect_list_all_networks_args;

struct remote_connect_list_all_networks_ret {
        struct {
                u_int nets_len;
                remote_nonnull_network *nets_val;
        } nets;
        u_int ret;
};
typedef struct remote_connect_list_all_networks_ret remote_connect_list_all_networks_ret;

struct remote_connect_list_all_interfaces_args {
        int need_results;
        u_int flags;
};
typedef struct remote_connect_list_all_interfaces_args remote_connect_list_all_interfaces_args;

struct remote_connect_list_all_interfaces_ret {
        struct {
                u_int ifaces_len;
                remote_nonnull_interface *ifaces_val;
        } ifaces;
        u_int ret;
};
typedef struct remote_connect_list_all_interfaces_ret remote_connect_list_all_interfaces_ret;

struct remote_connect_list_all_node_devices_args {
        int need_results;
        u_int flags;
};
typedef struct remote_connect_list_all_node_devices_args remote_connect_list_all_node_devices_args;

struct remote_connect_list_all_node_devices_ret {
        struct {
                u_int devices_len;
                remote_nonnull_node_device *devices_val;
        } devices;
        u_int ret;
};
typedef struct remote_connect_list_all_node_devices_ret remote_connect_list_all_node_devices_ret;

struct remote_connect_list_all_nwfilters_args {
        int need_results;
        u_int flags;
};
typedef struct remote_connect_list_all_nwfilters_args remote_connect_list_all_nwfilters_args;

struct remote_connect_list_all_nwfilters_ret {
        struct {
                u_int filters_len;
                remote_nonnull_nwfilter *filters_val;
        } filters;
        u_int ret;
};
typedef struct remote_connect_list_all_nwfilters_ret remote_connect_list_all_nwfilters_ret;

struct remote_connect_list_all_secrets_args {
        int need_results;
        u_int flags;
};
typedef struct remote_connect_list_all_secrets_args remote_connect_list_all_secrets_args;

struct remote_connect_list_all_secrets_ret {
        struct {
                u_int secrets_len;
                remote_nonnull_secret *secrets_val;
        } secrets;
        u_int ret;
};
typedef struct remote_connect_list_all_secrets_ret remote_connect_list_all_secrets_ret;

struct remote_node_set_memory_parameters_args {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        u_int flags;
};
typedef struct remote_node_set_memory_parameters_args remote_node_set_memory_parameters_args;

struct remote_node_get_memory_parameters_args {
        int nparams;
        u_int flags;
};
typedef struct remote_node_get_memory_parameters_args remote_node_get_memory_parameters_args;

struct remote_node_get_memory_parameters_ret {
        struct {
                u_int params_len;
                remote_typed_param *params_val;
        } params;
        int nparams;
};
typedef struct remote_node_get_memory_parameters_ret remote_node_get_memory_parameters_ret;

struct remote_node_get_cpu_map_args {
        int need_map;
        int need_online;
        u_int flags;
};
typedef struct remote_node_get_cpu_map_args remote_node_get_cpu_map_args;

struct remote_node_get_cpu_map_ret {
        struct {
                u_int cpumap_len;
                char *cpumap_val;
        } cpumap;
        u_int online;
        int ret;
};
typedef struct remote_node_get_cpu_map_ret remote_node_get_cpu_map_ret;

struct remote_domain_fstrim_args {
        remote_nonnull_domain dom;
        remote_string mountPoint;
        uint64_t minimum;
        u_int flags;
};
typedef struct remote_domain_fstrim_args remote_domain_fstrim_args;
#define REMOTE_PROGRAM 0x20008086
#define REMOTE_PROTOCOL_VERSION 1

enum remote_procedure {
        REMOTE_PROC_OPEN = 1,
        REMOTE_PROC_CLOSE = 2,
        REMOTE_PROC_GET_TYPE = 3,
        REMOTE_PROC_GET_VERSION = 4,
        REMOTE_PROC_GET_MAX_VCPUS = 5,
        REMOTE_PROC_NODE_GET_INFO = 6,
        REMOTE_PROC_GET_CAPABILITIES = 7,
        REMOTE_PROC_DOMAIN_ATTACH_DEVICE = 8,
        REMOTE_PROC_DOMAIN_CREATE = 9,
        REMOTE_PROC_DOMAIN_CREATE_XML = 10,
        REMOTE_PROC_DOMAIN_DEFINE_XML = 11,
        REMOTE_PROC_DOMAIN_DESTROY = 12,
        REMOTE_PROC_DOMAIN_DETACH_DEVICE = 13,
        REMOTE_PROC_DOMAIN_GET_XML_DESC = 14,
        REMOTE_PROC_DOMAIN_GET_AUTOSTART = 15,
        REMOTE_PROC_DOMAIN_GET_INFO = 16,
        REMOTE_PROC_DOMAIN_GET_MAX_MEMORY = 17,
        REMOTE_PROC_DOMAIN_GET_MAX_VCPUS = 18,
        REMOTE_PROC_DOMAIN_GET_OS_TYPE = 19,
        REMOTE_PROC_DOMAIN_GET_VCPUS = 20,
        REMOTE_PROC_LIST_DEFINED_DOMAINS = 21,
        REMOTE_PROC_DOMAIN_LOOKUP_BY_ID = 22,
        REMOTE_PROC_DOMAIN_LOOKUP_BY_NAME = 23,
        REMOTE_PROC_DOMAIN_LOOKUP_BY_UUID = 24,
        REMOTE_PROC_NUM_OF_DEFINED_DOMAINS = 25,
        REMOTE_PROC_DOMAIN_PIN_VCPU = 26,
        REMOTE_PROC_DOMAIN_REBOOT = 27,
        REMOTE_PROC_DOMAIN_RESUME = 28,
        REMOTE_PROC_DOMAIN_SET_AUTOSTART = 29,
        REMOTE_PROC_DOMAIN_SET_MAX_MEMORY = 30,
        REMOTE_PROC_DOMAIN_SET_MEMORY = 31,
        REMOTE_PROC_DOMAIN_SET_VCPUS = 32,
        REMOTE_PROC_DOMAIN_SHUTDOWN = 33,
        REMOTE_PROC_DOMAIN_SUSPEND = 34,
        REMOTE_PROC_DOMAIN_UNDEFINE = 35,
        REMOTE_PROC_LIST_DEFINED_NETWORKS = 36,
        REMOTE_PROC_LIST_DOMAINS = 37,
        REMOTE_PROC_LIST_NETWORKS = 38,
        REMOTE_PROC_NETWORK_CREATE = 39,
        REMOTE_PROC_NETWORK_CREATE_XML = 40,
        REMOTE_PROC_NETWORK_DEFINE_XML = 41,
        REMOTE_PROC_NETWORK_DESTROY = 42,
        REMOTE_PROC_NETWORK_GET_XML_DESC = 43,
        REMOTE_PROC_NETWORK_GET_AUTOSTART = 44,
        REMOTE_PROC_NETWORK_GET_BRIDGE_NAME = 45,
        REMOTE_PROC_NETWORK_LOOKUP_BY_NAME = 46,
        REMOTE_PROC_NETWORK_LOOKUP_BY_UUID = 47,
        REMOTE_PROC_NETWORK_SET_AUTOSTART = 48,
        REMOTE_PROC_NETWORK_UNDEFINE = 49,
        REMOTE_PROC_NUM_OF_DEFINED_NETWORKS = 50,
        REMOTE_PROC_NUM_OF_DOMAINS = 51,
        REMOTE_PROC_NUM_OF_NETWORKS = 52,
        REMOTE_PROC_DOMAIN_CORE_DUMP = 53,
        REMOTE_PROC_DOMAIN_RESTORE = 54,
        REMOTE_PROC_DOMAIN_SAVE = 55,
        REMOTE_PROC_DOMAIN_GET_SCHEDULER_TYPE = 56,
        REMOTE_PROC_DOMAIN_GET_SCHEDULER_PARAMETERS = 57,
        REMOTE_PROC_DOMAIN_SET_SCHEDULER_PARAMETERS = 58,
        REMOTE_PROC_GET_HOSTNAME = 59,
        REMOTE_PROC_SUPPORTS_FEATURE = 60,
        REMOTE_PROC_DOMAIN_MIGRATE_PREPARE = 61,
        REMOTE_PROC_DOMAIN_MIGRATE_PERFORM = 62,
        REMOTE_PROC_DOMAIN_MIGRATE_FINISH = 63,
        REMOTE_PROC_DOMAIN_BLOCK_STATS = 64,
        REMOTE_PROC_DOMAIN_INTERFACE_STATS = 65,
        REMOTE_PROC_AUTH_LIST = 66,
        REMOTE_PROC_AUTH_SASL_INIT = 67,
        REMOTE_PROC_AUTH_SASL_START = 68,
        REMOTE_PROC_AUTH_SASL_STEP = 69,
        REMOTE_PROC_AUTH_POLKIT = 70,
        REMOTE_PROC_NUM_OF_STORAGE_POOLS = 71,
        REMOTE_PROC_LIST_STORAGE_POOLS = 72,
        REMOTE_PROC_NUM_OF_DEFINED_STORAGE_POOLS = 73,
        REMOTE_PROC_LIST_DEFINED_STORAGE_POOLS = 74,
        REMOTE_PROC_FIND_STORAGE_POOL_SOURCES = 75,
        REMOTE_PROC_STORAGE_POOL_CREATE_XML = 76,
        REMOTE_PROC_STORAGE_POOL_DEFINE_XML = 77,
        REMOTE_PROC_STORAGE_POOL_CREATE = 78,
        REMOTE_PROC_STORAGE_POOL_BUILD = 79,
        REMOTE_PROC_STORAGE_POOL_DESTROY = 80,
        REMOTE_PROC_STORAGE_POOL_DELETE = 81,
        REMOTE_PROC_STORAGE_POOL_UNDEFINE = 82,
        REMOTE_PROC_STORAGE_POOL_REFRESH = 83,
        REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_NAME = 84,
        REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_UUID = 85,
        REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_VOLUME = 86,
        REMOTE_PROC_STORAGE_POOL_GET_INFO = 87,
        REMOTE_PROC_STORAGE_POOL_GET_XML_DESC = 88,
        REMOTE_PROC_STORAGE_POOL_GET_AUTOSTART = 89,
        REMOTE_PROC_STORAGE_POOL_SET_AUTOSTART = 90,
        REMOTE_PROC_STORAGE_POOL_NUM_OF_VOLUMES = 91,
        REMOTE_PROC_STORAGE_POOL_LIST_VOLUMES = 92,
        REMOTE_PROC_STORAGE_VOL_CREATE_XML = 93,
        REMOTE_PROC_STORAGE_VOL_DELETE = 94,
        REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_NAME = 95,
        REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_KEY = 96,
        REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_PATH = 97,
        REMOTE_PROC_STORAGE_VOL_GET_INFO = 98,
        REMOTE_PROC_STORAGE_VOL_GET_XML_DESC = 99,
        REMOTE_PROC_STORAGE_VOL_GET_PATH = 100,
        REMOTE_PROC_NODE_GET_CELLS_FREE_MEMORY = 101,
        REMOTE_PROC_NODE_GET_FREE_MEMORY = 102,
        REMOTE_PROC_DOMAIN_BLOCK_PEEK = 103,
        REMOTE_PROC_DOMAIN_MEMORY_PEEK = 104,
        REMOTE_PROC_DOMAIN_EVENTS_REGISTER = 105,
        REMOTE_PROC_DOMAIN_EVENTS_DEREGISTER = 106,
        REMOTE_PROC_DOMAIN_EVENT_LIFECYCLE = 107,
        REMOTE_PROC_DOMAIN_MIGRATE_PREPARE2 = 108,
        REMOTE_PROC_DOMAIN_MIGRATE_FINISH2 = 109,
        REMOTE_PROC_GET_URI = 110,
        REMOTE_PROC_NODE_NUM_OF_DEVICES = 111,
        REMOTE_PROC_NODE_LIST_DEVICES = 112,
        REMOTE_PROC_NODE_DEVICE_LOOKUP_BY_NAME = 113,
        REMOTE_PROC_NODE_DEVICE_GET_XML_DESC = 114,
        REMOTE_PROC_NODE_DEVICE_GET_PARENT = 115,
        REMOTE_PROC_NODE_DEVICE_NUM_OF_CAPS = 116,
        REMOTE_PROC_NODE_DEVICE_LIST_CAPS = 117,
        REMOTE_PROC_NODE_DEVICE_DETTACH = 118,
        REMOTE_PROC_NODE_DEVICE_RE_ATTACH = 119,
        REMOTE_PROC_NODE_DEVICE_RESET = 120,
        REMOTE_PROC_DOMAIN_GET_SECURITY_LABEL = 121,
        REMOTE_PROC_NODE_GET_SECURITY_MODEL = 122,
        REMOTE_PROC_NODE_DEVICE_CREATE_XML = 123,
        REMOTE_PROC_NODE_DEVICE_DESTROY = 124,
        REMOTE_PROC_STORAGE_VOL_CREATE_XML_FROM = 125,
        REMOTE_PROC_NUM_OF_INTERFACES = 126,
        REMOTE_PROC_LIST_INTERFACES = 127,
        REMOTE_PROC_INTERFACE_LOOKUP_BY_NAME = 128,
        REMOTE_PROC_INTERFACE_LOOKUP_BY_MAC_STRING = 129,
        REMOTE_PROC_INTERFACE_GET_XML_DESC = 130,
        REMOTE_PROC_INTERFACE_DEFINE_XML = 131,
        REMOTE_PROC_INTERFACE_UNDEFINE = 132,
        REMOTE_PROC_INTERFACE_CREATE = 133,
        REMOTE_PROC_INTERFACE_DESTROY = 134,
        REMOTE_PROC_DOMAIN_XML_FROM_NATIVE = 135,
        REMOTE_PROC_DOMAIN_XML_TO_NATIVE = 136,
        REMOTE_PROC_NUM_OF_DEFINED_INTERFACES = 137,
        REMOTE_PROC_LIST_DEFINED_INTERFACES = 138,
        REMOTE_PROC_NUM_OF_SECRETS = 139,
        REMOTE_PROC_LIST_SECRETS = 140,
        REMOTE_PROC_SECRET_LOOKUP_BY_UUID = 141,
        REMOTE_PROC_SECRET_DEFINE_XML = 142,
        REMOTE_PROC_SECRET_GET_XML_DESC = 143,
        REMOTE_PROC_SECRET_SET_VALUE = 144,
        REMOTE_PROC_SECRET_GET_VALUE = 145,
        REMOTE_PROC_SECRET_UNDEFINE = 146,
        REMOTE_PROC_SECRET_LOOKUP_BY_USAGE = 147,
        REMOTE_PROC_DOMAIN_MIGRATE_PREPARE_TUNNEL = 148,
        REMOTE_PROC_IS_SECURE = 149,
        REMOTE_PROC_DOMAIN_IS_ACTIVE = 150,
        REMOTE_PROC_DOMAIN_IS_PERSISTENT = 151,
        REMOTE_PROC_NETWORK_IS_ACTIVE = 152,
        REMOTE_PROC_NETWORK_IS_PERSISTENT = 153,
        REMOTE_PROC_STORAGE_POOL_IS_ACTIVE = 154,
        REMOTE_PROC_STORAGE_POOL_IS_PERSISTENT = 155,
        REMOTE_PROC_INTERFACE_IS_ACTIVE = 156,
        REMOTE_PROC_GET_LIB_VERSION = 157,
        REMOTE_PROC_CPU_COMPARE = 158,
        REMOTE_PROC_DOMAIN_MEMORY_STATS = 159,
        REMOTE_PROC_DOMAIN_ATTACH_DEVICE_FLAGS = 160,
        REMOTE_PROC_DOMAIN_DETACH_DEVICE_FLAGS = 161,
        REMOTE_PROC_CPU_BASELINE = 162,
        REMOTE_PROC_DOMAIN_GET_JOB_INFO = 163,
        REMOTE_PROC_DOMAIN_ABORT_JOB = 164,
        REMOTE_PROC_STORAGE_VOL_WIPE = 165,
        REMOTE_PROC_DOMAIN_MIGRATE_SET_MAX_DOWNTIME = 166,
        REMOTE_PROC_DOMAIN_EVENTS_REGISTER_ANY = 167,
        REMOTE_PROC_DOMAIN_EVENTS_DEREGISTER_ANY = 168,
        REMOTE_PROC_DOMAIN_EVENT_REBOOT = 169,
        REMOTE_PROC_DOMAIN_EVENT_RTC_CHANGE = 170,
        REMOTE_PROC_DOMAIN_EVENT_WATCHDOG = 171,
        REMOTE_PROC_DOMAIN_EVENT_IO_ERROR = 172,
        REMOTE_PROC_DOMAIN_EVENT_GRAPHICS = 173,
        REMOTE_PROC_DOMAIN_UPDATE_DEVICE_FLAGS = 174,
        REMOTE_PROC_NWFILTER_LOOKUP_BY_NAME = 175,
        REMOTE_PROC_NWFILTER_LOOKUP_BY_UUID = 176,
        REMOTE_PROC_NWFILTER_GET_XML_DESC = 177,
        REMOTE_PROC_NUM_OF_NWFILTERS = 178,
        REMOTE_PROC_LIST_NWFILTERS = 179,
        REMOTE_PROC_NWFILTER_DEFINE_XML = 180,
        REMOTE_PROC_NWFILTER_UNDEFINE = 181,
        REMOTE_PROC_DOMAIN_MANAGED_SAVE = 182,
        REMOTE_PROC_DOMAIN_HAS_MANAGED_SAVE_IMAGE = 183,
        REMOTE_PROC_DOMAIN_MANAGED_SAVE_REMOVE = 184,
        REMOTE_PROC_DOMAIN_SNAPSHOT_CREATE_XML = 185,
        REMOTE_PROC_DOMAIN_SNAPSHOT_GET_XML_DESC = 186,
        REMOTE_PROC_DOMAIN_SNAPSHOT_NUM = 187,
        REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_NAMES = 188,
        REMOTE_PROC_DOMAIN_SNAPSHOT_LOOKUP_BY_NAME = 189,
        REMOTE_PROC_DOMAIN_HAS_CURRENT_SNAPSHOT = 190,
        REMOTE_PROC_DOMAIN_SNAPSHOT_CURRENT = 191,
        REMOTE_PROC_DOMAIN_REVERT_TO_SNAPSHOT = 192,
        REMOTE_PROC_DOMAIN_SNAPSHOT_DELETE = 193,
        REMOTE_PROC_DOMAIN_GET_BLOCK_INFO = 194,
        REMOTE_PROC_DOMAIN_EVENT_IO_ERROR_REASON = 195,
        REMOTE_PROC_DOMAIN_CREATE_WITH_FLAGS = 196,
        REMOTE_PROC_DOMAIN_SET_MEMORY_PARAMETERS = 197,
        REMOTE_PROC_DOMAIN_GET_MEMORY_PARAMETERS = 198,
        REMOTE_PROC_DOMAIN_SET_VCPUS_FLAGS = 199,
        REMOTE_PROC_DOMAIN_GET_VCPUS_FLAGS = 200,
        REMOTE_PROC_DOMAIN_OPEN_CONSOLE = 201,
        REMOTE_PROC_DOMAIN_IS_UPDATED = 202,
        REMOTE_PROC_GET_SYSINFO = 203,
        REMOTE_PROC_DOMAIN_SET_MEMORY_FLAGS = 204,
        REMOTE_PROC_DOMAIN_SET_BLKIO_PARAMETERS = 205,
        REMOTE_PROC_DOMAIN_GET_BLKIO_PARAMETERS = 206,
        REMOTE_PROC_DOMAIN_MIGRATE_SET_MAX_SPEED = 207,
        REMOTE_PROC_STORAGE_VOL_UPLOAD = 208,
        REMOTE_PROC_STORAGE_VOL_DOWNLOAD = 209,
        REMOTE_PROC_DOMAIN_INJECT_NMI = 210,
        REMOTE_PROC_DOMAIN_SCREENSHOT = 211,
        REMOTE_PROC_DOMAIN_GET_STATE = 212,
        REMOTE_PROC_DOMAIN_MIGRATE_BEGIN3 = 213,
        REMOTE_PROC_DOMAIN_MIGRATE_PREPARE3 = 214,
        REMOTE_PROC_DOMAIN_MIGRATE_PREPARE_TUNNEL3 = 215,
        REMOTE_PROC_DOMAIN_MIGRATE_PERFORM3 = 216,
        REMOTE_PROC_DOMAIN_MIGRATE_FINISH3 = 217,
        REMOTE_PROC_DOMAIN_MIGRATE_CONFIRM3 = 218,
        REMOTE_PROC_DOMAIN_SET_SCHEDULER_PARAMETERS_FLAGS = 219,
        REMOTE_PROC_INTERFACE_CHANGE_BEGIN = 220,
        REMOTE_PROC_INTERFACE_CHANGE_COMMIT = 221,
        REMOTE_PROC_INTERFACE_CHANGE_ROLLBACK = 222,
        REMOTE_PROC_DOMAIN_GET_SCHEDULER_PARAMETERS_FLAGS = 223,
        REMOTE_PROC_DOMAIN_EVENT_CONTROL_ERROR = 224,
        REMOTE_PROC_DOMAIN_PIN_VCPU_FLAGS = 225,
        REMOTE_PROC_DOMAIN_SEND_KEY = 226,
        REMOTE_PROC_NODE_GET_CPU_STATS = 227,
        REMOTE_PROC_NODE_GET_MEMORY_STATS = 228,
        REMOTE_PROC_DOMAIN_GET_CONTROL_INFO = 229,
        REMOTE_PROC_DOMAIN_GET_VCPU_PIN_INFO = 230,
        REMOTE_PROC_DOMAIN_UNDEFINE_FLAGS = 231,
        REMOTE_PROC_DOMAIN_SAVE_FLAGS = 232,
        REMOTE_PROC_DOMAIN_RESTORE_FLAGS = 233,
        REMOTE_PROC_DOMAIN_DESTROY_FLAGS = 234,
        REMOTE_PROC_DOMAIN_SAVE_IMAGE_GET_XML_DESC = 235,
        REMOTE_PROC_DOMAIN_SAVE_IMAGE_DEFINE_XML = 236,
        REMOTE_PROC_DOMAIN_BLOCK_JOB_ABORT = 237,
        REMOTE_PROC_DOMAIN_GET_BLOCK_JOB_INFO = 238,
        REMOTE_PROC_DOMAIN_BLOCK_JOB_SET_SPEED = 239,
        REMOTE_PROC_DOMAIN_BLOCK_PULL = 240,
        REMOTE_PROC_DOMAIN_EVENT_BLOCK_JOB = 241,
        REMOTE_PROC_DOMAIN_MIGRATE_GET_MAX_SPEED = 242,
        REMOTE_PROC_DOMAIN_BLOCK_STATS_FLAGS = 243,
        REMOTE_PROC_DOMAIN_SNAPSHOT_GET_PARENT = 244,
        REMOTE_PROC_DOMAIN_RESET = 245,
        REMOTE_PROC_DOMAIN_SNAPSHOT_NUM_CHILDREN = 246,
        REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_CHILDREN_NAMES = 247,
        REMOTE_PROC_DOMAIN_EVENT_DISK_CHANGE = 248,
        REMOTE_PROC_DOMAIN_OPEN_GRAPHICS = 249,
        REMOTE_PROC_NODE_SUSPEND_FOR_DURATION = 250,
        REMOTE_PROC_DOMAIN_BLOCK_RESIZE = 251,
        REMOTE_PROC_DOMAIN_SET_BLOCK_IO_TUNE = 252,
        REMOTE_PROC_DOMAIN_GET_BLOCK_IO_TUNE = 253,
        REMOTE_PROC_DOMAIN_SET_NUMA_PARAMETERS = 254,
        REMOTE_PROC_DOMAIN_GET_NUMA_PARAMETERS = 255,
        REMOTE_PROC_DOMAIN_SET_INTERFACE_PARAMETERS = 256,
        REMOTE_PROC_DOMAIN_GET_INTERFACE_PARAMETERS = 257,
        REMOTE_PROC_DOMAIN_SHUTDOWN_FLAGS = 258,
        REMOTE_PROC_STORAGE_VOL_WIPE_PATTERN = 259,
        REMOTE_PROC_STORAGE_VOL_RESIZE = 260,
        REMOTE_PROC_DOMAIN_PM_SUSPEND_FOR_DURATION = 261,
        REMOTE_PROC_DOMAIN_GET_CPU_STATS = 262,
        REMOTE_PROC_DOMAIN_GET_DISK_ERRORS = 263,
        REMOTE_PROC_DOMAIN_SET_METADATA = 264,
        REMOTE_PROC_DOMAIN_GET_METADATA = 265,
        REMOTE_PROC_DOMAIN_BLOCK_REBASE = 266,
        REMOTE_PROC_DOMAIN_PM_WAKEUP = 267,
        REMOTE_PROC_DOMAIN_EVENT_TRAY_CHANGE = 268,
        REMOTE_PROC_DOMAIN_EVENT_PMWAKEUP = 269,
        REMOTE_PROC_DOMAIN_EVENT_PMSUSPEND = 270,
        REMOTE_PROC_DOMAIN_SNAPSHOT_IS_CURRENT = 271,
        REMOTE_PROC_DOMAIN_SNAPSHOT_HAS_METADATA = 272,
        REMOTE_PROC_CONNECT_LIST_ALL_DOMAINS = 273,
        REMOTE_PROC_DOMAIN_LIST_ALL_SNAPSHOTS = 274,
        REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_ALL_CHILDREN = 275,
        REMOTE_PROC_DOMAIN_EVENT_BALLOON_CHANGE = 276,
        REMOTE_PROC_DOMAIN_GET_HOSTNAME = 277,
        REMOTE_PROC_DOMAIN_GET_SECURITY_LABEL_LIST = 278,
        REMOTE_PROC_DOMAIN_PIN_EMULATOR = 279,
        REMOTE_PROC_DOMAIN_GET_EMULATOR_PIN_INFO = 280,
        REMOTE_PROC_CONNECT_LIST_ALL_STORAGE_POOLS = 281,
        REMOTE_PROC_STORAGE_POOL_LIST_ALL_VOLUMES = 282,
        REMOTE_PROC_CONNECT_LIST_ALL_NETWORKS = 283,
        REMOTE_PROC_CONNECT_LIST_ALL_INTERFACES = 284,
        REMOTE_PROC_CONNECT_LIST_ALL_NODE_DEVICES = 285,
        REMOTE_PROC_CONNECT_LIST_ALL_NWFILTERS = 286,
        REMOTE_PROC_CONNECT_LIST_ALL_SECRETS = 287,
        REMOTE_PROC_NODE_SET_MEMORY_PARAMETERS = 288,
        REMOTE_PROC_NODE_GET_MEMORY_PARAMETERS = 289,
        REMOTE_PROC_DOMAIN_BLOCK_COMMIT = 290,
        REMOTE_PROC_NETWORK_UPDATE = 291,
        REMOTE_PROC_DOMAIN_EVENT_PMSUSPEND_DISK = 292,
        REMOTE_PROC_NODE_GET_CPU_MAP = 293,
        REMOTE_PROC_DOMAIN_FSTRIM = 294,
        REMOTE_PROC_DOMAIN_SEND_PROCESS_SIGNAL = 295,
        REMOTE_PROC_DOMAIN_OPEN_CHANNEL = 296,
        REMOTE_PROC_NODE_DEVICE_LOOKUP_SCSI_HOST_BY_WWN = 297,
        REMOTE_PROC_DOMAIN_GET_JOB_STATS = 298,
        REMOTE_PROC_DOMAIN_MIGRATE_GET_COMPRESSION_CACHE = 299,
        REMOTE_PROC_DOMAIN_MIGRATE_SET_COMPRESSION_CACHE = 300,
};
typedef enum remote_procedure remote_procedure;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_remote_nonnull_string (XDR *, remote_nonnull_string*);
extern  bool_t xdr_remote_string (XDR *, remote_string*);
extern  bool_t xdr_remote_uuid (XDR *, remote_uuid);
extern  bool_t xdr_remote_nonnull_domain (XDR *, remote_nonnull_domain*);
extern  bool_t xdr_remote_nonnull_network (XDR *, remote_nonnull_network*);
extern  bool_t xdr_remote_nonnull_nwfilter (XDR *, remote_nonnull_nwfilter*);
extern  bool_t xdr_remote_nonnull_interface (XDR *, remote_nonnull_interface*);
extern  bool_t xdr_remote_nonnull_storage_pool (XDR *, remote_nonnull_storage_pool*);
extern  bool_t xdr_remote_nonnull_storage_vol (XDR *, remote_nonnull_storage_vol*);
extern  bool_t xdr_remote_nonnull_node_device (XDR *, remote_nonnull_node_device*);
extern  bool_t xdr_remote_nonnull_secret (XDR *, remote_nonnull_secret*);
extern  bool_t xdr_remote_nonnull_domain_snapshot (XDR *, remote_nonnull_domain_snapshot*);
extern  bool_t xdr_remote_domain (XDR *, remote_domain*);
extern  bool_t xdr_remote_network (XDR *, remote_network*);
extern  bool_t xdr_remote_nwfilter (XDR *, remote_nwfilter*);
extern  bool_t xdr_remote_storage_pool (XDR *, remote_storage_pool*);
extern  bool_t xdr_remote_storage_vol (XDR *, remote_storage_vol*);
extern  bool_t xdr_remote_node_device (XDR *, remote_node_device*);
extern  bool_t xdr_remote_error (XDR *, remote_error*);
extern  bool_t xdr_remote_auth_type (XDR *, remote_auth_type*);
extern  bool_t xdr_remote_vcpu_info (XDR *, remote_vcpu_info*);
extern  bool_t xdr_remote_typed_param_value (XDR *, remote_typed_param_value*);
extern  bool_t xdr_remote_typed_param (XDR *, remote_typed_param*);
extern  bool_t xdr_remote_node_get_cpu_stats (XDR *, remote_node_get_cpu_stats*);
extern  bool_t xdr_remote_node_get_memory_stats (XDR *, remote_node_get_memory_stats*);
extern  bool_t xdr_remote_domain_disk_error (XDR *, remote_domain_disk_error*);
extern  bool_t xdr_remote_open_args (XDR *, remote_open_args*);
extern  bool_t xdr_remote_supports_feature_args (XDR *, remote_supports_feature_args*);
extern  bool_t xdr_remote_supports_feature_ret (XDR *, remote_supports_feature_ret*);
extern  bool_t xdr_remote_get_type_ret (XDR *, remote_get_type_ret*);
extern  bool_t xdr_remote_get_version_ret (XDR *, remote_get_version_ret*);
extern  bool_t xdr_remote_get_lib_version_ret (XDR *, remote_get_lib_version_ret*);
extern  bool_t xdr_remote_get_hostname_ret (XDR *, remote_get_hostname_ret*);
extern  bool_t xdr_remote_get_sysinfo_args (XDR *, remote_get_sysinfo_args*);
extern  bool_t xdr_remote_get_sysinfo_ret (XDR *, remote_get_sysinfo_ret*);
extern  bool_t xdr_remote_get_uri_ret (XDR *, remote_get_uri_ret*);
extern  bool_t xdr_remote_get_max_vcpus_args (XDR *, remote_get_max_vcpus_args*);
extern  bool_t xdr_remote_get_max_vcpus_ret (XDR *, remote_get_max_vcpus_ret*);
extern  bool_t xdr_remote_node_get_info_ret (XDR *, remote_node_get_info_ret*);
extern  bool_t xdr_remote_get_capabilities_ret (XDR *, remote_get_capabilities_ret*);
extern  bool_t xdr_remote_node_get_cpu_stats_args (XDR *, remote_node_get_cpu_stats_args*);
extern  bool_t xdr_remote_node_get_cpu_stats_ret (XDR *, remote_node_get_cpu_stats_ret*);
extern  bool_t xdr_remote_node_get_memory_stats_args (XDR *, remote_node_get_memory_stats_args*);
extern  bool_t xdr_remote_node_get_memory_stats_ret (XDR *, remote_node_get_memory_stats_ret*);
extern  bool_t xdr_remote_node_get_cells_free_memory_args (XDR *, remote_node_get_cells_free_memory_args*);
extern  bool_t xdr_remote_node_get_cells_free_memory_ret (XDR *, remote_node_get_cells_free_memory_ret*);
extern  bool_t xdr_remote_node_get_free_memory_ret (XDR *, remote_node_get_free_memory_ret*);
extern  bool_t xdr_remote_domain_get_scheduler_type_args (XDR *, remote_domain_get_scheduler_type_args*);
extern  bool_t xdr_remote_domain_get_scheduler_type_ret (XDR *, remote_domain_get_scheduler_type_ret*);
extern  bool_t xdr_remote_domain_get_scheduler_parameters_args (XDR *, remote_domain_get_scheduler_parameters_args*);
extern  bool_t xdr_remote_domain_get_scheduler_parameters_ret (XDR *, remote_domain_get_scheduler_parameters_ret*);
extern  bool_t xdr_remote_domain_get_scheduler_parameters_flags_args (XDR *, remote_domain_get_scheduler_parameters_flags_args*);
extern  bool_t xdr_remote_domain_get_scheduler_parameters_flags_ret (XDR *, remote_domain_get_scheduler_parameters_flags_ret*);
extern  bool_t xdr_remote_domain_set_scheduler_parameters_args (XDR *, remote_domain_set_scheduler_parameters_args*);
extern  bool_t xdr_remote_domain_set_scheduler_parameters_flags_args (XDR *, remote_domain_set_scheduler_parameters_flags_args*);
extern  bool_t xdr_remote_domain_set_blkio_parameters_args (XDR *, remote_domain_set_blkio_parameters_args*);
extern  bool_t xdr_remote_domain_get_blkio_parameters_args (XDR *, remote_domain_get_blkio_parameters_args*);
extern  bool_t xdr_remote_domain_get_blkio_parameters_ret (XDR *, remote_domain_get_blkio_parameters_ret*);
extern  bool_t xdr_remote_domain_set_memory_parameters_args (XDR *, remote_domain_set_memory_parameters_args*);
extern  bool_t xdr_remote_domain_get_memory_parameters_args (XDR *, remote_domain_get_memory_parameters_args*);
extern  bool_t xdr_remote_domain_get_memory_parameters_ret (XDR *, remote_domain_get_memory_parameters_ret*);
extern  bool_t xdr_remote_domain_block_resize_args (XDR *, remote_domain_block_resize_args*);
extern  bool_t xdr_remote_domain_set_numa_parameters_args (XDR *, remote_domain_set_numa_parameters_args*);
extern  bool_t xdr_remote_domain_get_numa_parameters_args (XDR *, remote_domain_get_numa_parameters_args*);
extern  bool_t xdr_remote_domain_get_numa_parameters_ret (XDR *, remote_domain_get_numa_parameters_ret*);
extern  bool_t xdr_remote_domain_block_stats_args (XDR *, remote_domain_block_stats_args*);
extern  bool_t xdr_remote_domain_block_stats_ret (XDR *, remote_domain_block_stats_ret*);
extern  bool_t xdr_remote_domain_block_stats_flags_args (XDR *, remote_domain_block_stats_flags_args*);
extern  bool_t xdr_remote_domain_block_stats_flags_ret (XDR *, remote_domain_block_stats_flags_ret*);
extern  bool_t xdr_remote_domain_interface_stats_args (XDR *, remote_domain_interface_stats_args*);
extern  bool_t xdr_remote_domain_interface_stats_ret (XDR *, remote_domain_interface_stats_ret*);
extern  bool_t xdr_remote_domain_set_interface_parameters_args (XDR *, remote_domain_set_interface_parameters_args*);
extern  bool_t xdr_remote_domain_get_interface_parameters_args (XDR *, remote_domain_get_interface_parameters_args*);
extern  bool_t xdr_remote_domain_get_interface_parameters_ret (XDR *, remote_domain_get_interface_parameters_ret*);
extern  bool_t xdr_remote_domain_memory_stats_args (XDR *, remote_domain_memory_stats_args*);
extern  bool_t xdr_remote_domain_memory_stat (XDR *, remote_domain_memory_stat*);
extern  bool_t xdr_remote_domain_memory_stats_ret (XDR *, remote_domain_memory_stats_ret*);
extern  bool_t xdr_remote_domain_block_peek_args (XDR *, remote_domain_block_peek_args*);
extern  bool_t xdr_remote_domain_block_peek_ret (XDR *, remote_domain_block_peek_ret*);
extern  bool_t xdr_remote_domain_memory_peek_args (XDR *, remote_domain_memory_peek_args*);
extern  bool_t xdr_remote_domain_memory_peek_ret (XDR *, remote_domain_memory_peek_ret*);
extern  bool_t xdr_remote_domain_get_block_info_args (XDR *, remote_domain_get_block_info_args*);
extern  bool_t xdr_remote_domain_get_block_info_ret (XDR *, remote_domain_get_block_info_ret*);
extern  bool_t xdr_remote_list_domains_args (XDR *, remote_list_domains_args*);
extern  bool_t xdr_remote_list_domains_ret (XDR *, remote_list_domains_ret*);
extern  bool_t xdr_remote_num_of_domains_ret (XDR *, remote_num_of_domains_ret*);
extern  bool_t xdr_remote_domain_create_xml_args (XDR *, remote_domain_create_xml_args*);
extern  bool_t xdr_remote_domain_create_xml_ret (XDR *, remote_domain_create_xml_ret*);
extern  bool_t xdr_remote_domain_lookup_by_id_args (XDR *, remote_domain_lookup_by_id_args*);
extern  bool_t xdr_remote_domain_lookup_by_id_ret (XDR *, remote_domain_lookup_by_id_ret*);
extern  bool_t xdr_remote_domain_lookup_by_uuid_args (XDR *, remote_domain_lookup_by_uuid_args*);
extern  bool_t xdr_remote_domain_lookup_by_uuid_ret (XDR *, remote_domain_lookup_by_uuid_ret*);
extern  bool_t xdr_remote_domain_lookup_by_name_args (XDR *, remote_domain_lookup_by_name_args*);
extern  bool_t xdr_remote_domain_lookup_by_name_ret (XDR *, remote_domain_lookup_by_name_ret*);
extern  bool_t xdr_remote_domain_suspend_args (XDR *, remote_domain_suspend_args*);
extern  bool_t xdr_remote_domain_resume_args (XDR *, remote_domain_resume_args*);
extern  bool_t xdr_remote_domain_pm_suspend_for_duration_args (XDR *, remote_domain_pm_suspend_for_duration_args*);
extern  bool_t xdr_remote_domain_pm_wakeup_args (XDR *, remote_domain_pm_wakeup_args*);
extern  bool_t xdr_remote_domain_shutdown_args (XDR *, remote_domain_shutdown_args*);
extern  bool_t xdr_remote_domain_reboot_args (XDR *, remote_domain_reboot_args*);
extern  bool_t xdr_remote_domain_reset_args (XDR *, remote_domain_reset_args*);
extern  bool_t xdr_remote_domain_destroy_args (XDR *, remote_domain_destroy_args*);
extern  bool_t xdr_remote_domain_destroy_flags_args (XDR *, remote_domain_destroy_flags_args*);
extern  bool_t xdr_remote_domain_get_os_type_args (XDR *, remote_domain_get_os_type_args*);
extern  bool_t xdr_remote_domain_get_os_type_ret (XDR *, remote_domain_get_os_type_ret*);
extern  bool_t xdr_remote_domain_get_max_memory_args (XDR *, remote_domain_get_max_memory_args*);
extern  bool_t xdr_remote_domain_get_max_memory_ret (XDR *, remote_domain_get_max_memory_ret*);
extern  bool_t xdr_remote_domain_set_max_memory_args (XDR *, remote_domain_set_max_memory_args*);
extern  bool_t xdr_remote_domain_set_memory_args (XDR *, remote_domain_set_memory_args*);
extern  bool_t xdr_remote_domain_set_memory_flags_args (XDR *, remote_domain_set_memory_flags_args*);
extern  bool_t xdr_remote_domain_get_info_args (XDR *, remote_domain_get_info_args*);
extern  bool_t xdr_remote_domain_get_info_ret (XDR *, remote_domain_get_info_ret*);
extern  bool_t xdr_remote_domain_save_args (XDR *, remote_domain_save_args*);
extern  bool_t xdr_remote_domain_save_flags_args (XDR *, remote_domain_save_flags_args*);
extern  bool_t xdr_remote_domain_restore_args (XDR *, remote_domain_restore_args*);
extern  bool_t xdr_remote_domain_restore_flags_args (XDR *, remote_domain_restore_flags_args*);
extern  bool_t xdr_remote_domain_save_image_get_xml_desc_args (XDR *, remote_domain_save_image_get_xml_desc_args*);
extern  bool_t xdr_remote_domain_save_image_get_xml_desc_ret (XDR *, remote_domain_save_image_get_xml_desc_ret*);
extern  bool_t xdr_remote_domain_save_image_define_xml_args (XDR *, remote_domain_save_image_define_xml_args*);
extern  bool_t xdr_remote_domain_core_dump_args (XDR *, remote_domain_core_dump_args*);
extern  bool_t xdr_remote_domain_screenshot_args (XDR *, remote_domain_screenshot_args*);
extern  bool_t xdr_remote_domain_screenshot_ret (XDR *, remote_domain_screenshot_ret*);
extern  bool_t xdr_remote_domain_get_xml_desc_args (XDR *, remote_domain_get_xml_desc_args*);
extern  bool_t xdr_remote_domain_get_xml_desc_ret (XDR *, remote_domain_get_xml_desc_ret*);
extern  bool_t xdr_remote_domain_migrate_prepare_args (XDR *, remote_domain_migrate_prepare_args*);
extern  bool_t xdr_remote_domain_migrate_prepare_ret (XDR *, remote_domain_migrate_prepare_ret*);
extern  bool_t xdr_remote_domain_migrate_perform_args (XDR *, remote_domain_migrate_perform_args*);
extern  bool_t xdr_remote_domain_migrate_finish_args (XDR *, remote_domain_migrate_finish_args*);
extern  bool_t xdr_remote_domain_migrate_finish_ret (XDR *, remote_domain_migrate_finish_ret*);
extern  bool_t xdr_remote_domain_migrate_prepare2_args (XDR *, remote_domain_migrate_prepare2_args*);
extern  bool_t xdr_remote_domain_migrate_prepare2_ret (XDR *, remote_domain_migrate_prepare2_ret*);
extern  bool_t xdr_remote_domain_migrate_finish2_args (XDR *, remote_domain_migrate_finish2_args*);
extern  bool_t xdr_remote_domain_migrate_finish2_ret (XDR *, remote_domain_migrate_finish2_ret*);
extern  bool_t xdr_remote_list_defined_domains_args (XDR *, remote_list_defined_domains_args*);
extern  bool_t xdr_remote_list_defined_domains_ret (XDR *, remote_list_defined_domains_ret*);
extern  bool_t xdr_remote_num_of_defined_domains_ret (XDR *, remote_num_of_defined_domains_ret*);
extern  bool_t xdr_remote_domain_create_args (XDR *, remote_domain_create_args*);
extern  bool_t xdr_remote_domain_create_with_flags_args (XDR *, remote_domain_create_with_flags_args*);
extern  bool_t xdr_remote_domain_create_with_flags_ret (XDR *, remote_domain_create_with_flags_ret*);
extern  bool_t xdr_remote_domain_define_xml_args (XDR *, remote_domain_define_xml_args*);
extern  bool_t xdr_remote_domain_define_xml_ret (XDR *, remote_domain_define_xml_ret*);
extern  bool_t xdr_remote_domain_undefine_args (XDR *, remote_domain_undefine_args*);
extern  bool_t xdr_remote_domain_undefine_flags_args (XDR *, remote_domain_undefine_flags_args*);
extern  bool_t xdr_remote_domain_inject_nmi_args (XDR *, remote_domain_inject_nmi_args*);
extern  bool_t xdr_remote_domain_send_key_args (XDR *, remote_domain_send_key_args*);
extern  bool_t xdr_remote_domain_send_process_signal_args (XDR *, remote_domain_send_process_signal_args*);
extern  bool_t xdr_remote_domain_set_vcpus_args (XDR *, remote_domain_set_vcpus_args*);
extern  bool_t xdr_remote_domain_set_vcpus_flags_args (XDR *, remote_domain_set_vcpus_flags_args*);
extern  bool_t xdr_remote_domain_get_vcpus_flags_args (XDR *, remote_domain_get_vcpus_flags_args*);
extern  bool_t xdr_remote_domain_get_vcpus_flags_ret (XDR *, remote_domain_get_vcpus_flags_ret*);
extern  bool_t xdr_remote_domain_pin_vcpu_args (XDR *, remote_domain_pin_vcpu_args*);
extern  bool_t xdr_remote_domain_pin_vcpu_flags_args (XDR *, remote_domain_pin_vcpu_flags_args*);
extern  bool_t xdr_remote_domain_get_vcpu_pin_info_args (XDR *, remote_domain_get_vcpu_pin_info_args*);
extern  bool_t xdr_remote_domain_get_vcpu_pin_info_ret (XDR *, remote_domain_get_vcpu_pin_info_ret*);
extern  bool_t xdr_remote_domain_pin_emulator_args (XDR *, remote_domain_pin_emulator_args*);
extern  bool_t xdr_remote_domain_get_emulator_pin_info_args (XDR *, remote_domain_get_emulator_pin_info_args*);
extern  bool_t xdr_remote_domain_get_emulator_pin_info_ret (XDR *, remote_domain_get_emulator_pin_info_ret*);
extern  bool_t xdr_remote_domain_get_vcpus_args (XDR *, remote_domain_get_vcpus_args*);
extern  bool_t xdr_remote_domain_get_vcpus_ret (XDR *, remote_domain_get_vcpus_ret*);
extern  bool_t xdr_remote_domain_get_max_vcpus_args (XDR *, remote_domain_get_max_vcpus_args*);
extern  bool_t xdr_remote_domain_get_max_vcpus_ret (XDR *, remote_domain_get_max_vcpus_ret*);
extern  bool_t xdr_remote_domain_get_security_label_args (XDR *, remote_domain_get_security_label_args*);
extern  bool_t xdr_remote_domain_get_security_label_ret (XDR *, remote_domain_get_security_label_ret*);
extern  bool_t xdr_remote_domain_get_security_label_list_args (XDR *, remote_domain_get_security_label_list_args*);
extern  bool_t xdr_remote_domain_get_security_label_list_ret (XDR *, remote_domain_get_security_label_list_ret*);
extern  bool_t xdr_remote_node_get_security_model_ret (XDR *, remote_node_get_security_model_ret*);
extern  bool_t xdr_remote_domain_attach_device_args (XDR *, remote_domain_attach_device_args*);
extern  bool_t xdr_remote_domain_attach_device_flags_args (XDR *, remote_domain_attach_device_flags_args*);
extern  bool_t xdr_remote_domain_detach_device_args (XDR *, remote_domain_detach_device_args*);
extern  bool_t xdr_remote_domain_detach_device_flags_args (XDR *, remote_domain_detach_device_flags_args*);
extern  bool_t xdr_remote_domain_update_device_flags_args (XDR *, remote_domain_update_device_flags_args*);
extern  bool_t xdr_remote_domain_get_autostart_args (XDR *, remote_domain_get_autostart_args*);
extern  bool_t xdr_remote_domain_get_autostart_ret (XDR *, remote_domain_get_autostart_ret*);
extern  bool_t xdr_remote_domain_set_autostart_args (XDR *, remote_domain_set_autostart_args*);
extern  bool_t xdr_remote_domain_set_metadata_args (XDR *, remote_domain_set_metadata_args*);
extern  bool_t xdr_remote_domain_get_metadata_args (XDR *, remote_domain_get_metadata_args*);
extern  bool_t xdr_remote_domain_get_metadata_ret (XDR *, remote_domain_get_metadata_ret*);
extern  bool_t xdr_remote_domain_block_job_abort_args (XDR *, remote_domain_block_job_abort_args*);
extern  bool_t xdr_remote_domain_get_block_job_info_args (XDR *, remote_domain_get_block_job_info_args*);
extern  bool_t xdr_remote_domain_get_block_job_info_ret (XDR *, remote_domain_get_block_job_info_ret*);
extern  bool_t xdr_remote_domain_block_job_set_speed_args (XDR *, remote_domain_block_job_set_speed_args*);
extern  bool_t xdr_remote_domain_block_pull_args (XDR *, remote_domain_block_pull_args*);
extern  bool_t xdr_remote_domain_block_rebase_args (XDR *, remote_domain_block_rebase_args*);
extern  bool_t xdr_remote_domain_block_commit_args (XDR *, remote_domain_block_commit_args*);
extern  bool_t xdr_remote_domain_set_block_io_tune_args (XDR *, remote_domain_set_block_io_tune_args*);
extern  bool_t xdr_remote_domain_get_block_io_tune_args (XDR *, remote_domain_get_block_io_tune_args*);
extern  bool_t xdr_remote_domain_get_block_io_tune_ret (XDR *, remote_domain_get_block_io_tune_ret*);
extern  bool_t xdr_remote_domain_get_cpu_stats_args (XDR *, remote_domain_get_cpu_stats_args*);
extern  bool_t xdr_remote_domain_get_cpu_stats_ret (XDR *, remote_domain_get_cpu_stats_ret*);
extern  bool_t xdr_remote_domain_get_hostname_args (XDR *, remote_domain_get_hostname_args*);
extern  bool_t xdr_remote_domain_get_hostname_ret (XDR *, remote_domain_get_hostname_ret*);
extern  bool_t xdr_remote_num_of_networks_ret (XDR *, remote_num_of_networks_ret*);
extern  bool_t xdr_remote_list_networks_args (XDR *, remote_list_networks_args*);
extern  bool_t xdr_remote_list_networks_ret (XDR *, remote_list_networks_ret*);
extern  bool_t xdr_remote_num_of_defined_networks_ret (XDR *, remote_num_of_defined_networks_ret*);
extern  bool_t xdr_remote_list_defined_networks_args (XDR *, remote_list_defined_networks_args*);
extern  bool_t xdr_remote_list_defined_networks_ret (XDR *, remote_list_defined_networks_ret*);
extern  bool_t xdr_remote_network_lookup_by_uuid_args (XDR *, remote_network_lookup_by_uuid_args*);
extern  bool_t xdr_remote_network_lookup_by_uuid_ret (XDR *, remote_network_lookup_by_uuid_ret*);
extern  bool_t xdr_remote_network_lookup_by_name_args (XDR *, remote_network_lookup_by_name_args*);
extern  bool_t xdr_remote_network_lookup_by_name_ret (XDR *, remote_network_lookup_by_name_ret*);
extern  bool_t xdr_remote_network_create_xml_args (XDR *, remote_network_create_xml_args*);
extern  bool_t xdr_remote_network_create_xml_ret (XDR *, remote_network_create_xml_ret*);
extern  bool_t xdr_remote_network_define_xml_args (XDR *, remote_network_define_xml_args*);
extern  bool_t xdr_remote_network_define_xml_ret (XDR *, remote_network_define_xml_ret*);
extern  bool_t xdr_remote_network_undefine_args (XDR *, remote_network_undefine_args*);
extern  bool_t xdr_remote_network_update_args (XDR *, remote_network_update_args*);
extern  bool_t xdr_remote_network_create_args (XDR *, remote_network_create_args*);
extern  bool_t xdr_remote_network_destroy_args (XDR *, remote_network_destroy_args*);
extern  bool_t xdr_remote_network_get_xml_desc_args (XDR *, remote_network_get_xml_desc_args*);
extern  bool_t xdr_remote_network_get_xml_desc_ret (XDR *, remote_network_get_xml_desc_ret*);
extern  bool_t xdr_remote_network_get_bridge_name_args (XDR *, remote_network_get_bridge_name_args*);
extern  bool_t xdr_remote_network_get_bridge_name_ret (XDR *, remote_network_get_bridge_name_ret*);
extern  bool_t xdr_remote_network_get_autostart_args (XDR *, remote_network_get_autostart_args*);
extern  bool_t xdr_remote_network_get_autostart_ret (XDR *, remote_network_get_autostart_ret*);
extern  bool_t xdr_remote_network_set_autostart_args (XDR *, remote_network_set_autostart_args*);
extern  bool_t xdr_remote_num_of_nwfilters_ret (XDR *, remote_num_of_nwfilters_ret*);
extern  bool_t xdr_remote_list_nwfilters_args (XDR *, remote_list_nwfilters_args*);
extern  bool_t xdr_remote_list_nwfilters_ret (XDR *, remote_list_nwfilters_ret*);
extern  bool_t xdr_remote_nwfilter_lookup_by_uuid_args (XDR *, remote_nwfilter_lookup_by_uuid_args*);
extern  bool_t xdr_remote_nwfilter_lookup_by_uuid_ret (XDR *, remote_nwfilter_lookup_by_uuid_ret*);
extern  bool_t xdr_remote_nwfilter_lookup_by_name_args (XDR *, remote_nwfilter_lookup_by_name_args*);
extern  bool_t xdr_remote_nwfilter_lookup_by_name_ret (XDR *, remote_nwfilter_lookup_by_name_ret*);
extern  bool_t xdr_remote_nwfilter_define_xml_args (XDR *, remote_nwfilter_define_xml_args*);
extern  bool_t xdr_remote_nwfilter_define_xml_ret (XDR *, remote_nwfilter_define_xml_ret*);
extern  bool_t xdr_remote_nwfilter_undefine_args (XDR *, remote_nwfilter_undefine_args*);
extern  bool_t xdr_remote_nwfilter_get_xml_desc_args (XDR *, remote_nwfilter_get_xml_desc_args*);
extern  bool_t xdr_remote_nwfilter_get_xml_desc_ret (XDR *, remote_nwfilter_get_xml_desc_ret*);
extern  bool_t xdr_remote_num_of_interfaces_ret (XDR *, remote_num_of_interfaces_ret*);
extern  bool_t xdr_remote_list_interfaces_args (XDR *, remote_list_interfaces_args*);
extern  bool_t xdr_remote_list_interfaces_ret (XDR *, remote_list_interfaces_ret*);
extern  bool_t xdr_remote_num_of_defined_interfaces_ret (XDR *, remote_num_of_defined_interfaces_ret*);
extern  bool_t xdr_remote_list_defined_interfaces_args (XDR *, remote_list_defined_interfaces_args*);
extern  bool_t xdr_remote_list_defined_interfaces_ret (XDR *, remote_list_defined_interfaces_ret*);
extern  bool_t xdr_remote_interface_lookup_by_name_args (XDR *, remote_interface_lookup_by_name_args*);
extern  bool_t xdr_remote_interface_lookup_by_name_ret (XDR *, remote_interface_lookup_by_name_ret*);
extern  bool_t xdr_remote_interface_lookup_by_mac_string_args (XDR *, remote_interface_lookup_by_mac_string_args*);
extern  bool_t xdr_remote_interface_lookup_by_mac_string_ret (XDR *, remote_interface_lookup_by_mac_string_ret*);
extern  bool_t xdr_remote_interface_get_xml_desc_args (XDR *, remote_interface_get_xml_desc_args*);
extern  bool_t xdr_remote_interface_get_xml_desc_ret (XDR *, remote_interface_get_xml_desc_ret*);
extern  bool_t xdr_remote_interface_define_xml_args (XDR *, remote_interface_define_xml_args*);
extern  bool_t xdr_remote_interface_define_xml_ret (XDR *, remote_interface_define_xml_ret*);
extern  bool_t xdr_remote_interface_undefine_args (XDR *, remote_interface_undefine_args*);
extern  bool_t xdr_remote_interface_create_args (XDR *, remote_interface_create_args*);
extern  bool_t xdr_remote_interface_destroy_args (XDR *, remote_interface_destroy_args*);
extern  bool_t xdr_remote_interface_change_begin_args (XDR *, remote_interface_change_begin_args*);
extern  bool_t xdr_remote_interface_change_commit_args (XDR *, remote_interface_change_commit_args*);
extern  bool_t xdr_remote_interface_change_rollback_args (XDR *, remote_interface_change_rollback_args*);
extern  bool_t xdr_remote_auth_list_ret (XDR *, remote_auth_list_ret*);
extern  bool_t xdr_remote_auth_sasl_init_ret (XDR *, remote_auth_sasl_init_ret*);
extern  bool_t xdr_remote_auth_sasl_start_args (XDR *, remote_auth_sasl_start_args*);
extern  bool_t xdr_remote_auth_sasl_start_ret (XDR *, remote_auth_sasl_start_ret*);
extern  bool_t xdr_remote_auth_sasl_step_args (XDR *, remote_auth_sasl_step_args*);
extern  bool_t xdr_remote_auth_sasl_step_ret (XDR *, remote_auth_sasl_step_ret*);
extern  bool_t xdr_remote_auth_polkit_ret (XDR *, remote_auth_polkit_ret*);
extern  bool_t xdr_remote_num_of_storage_pools_ret (XDR *, remote_num_of_storage_pools_ret*);
extern  bool_t xdr_remote_list_storage_pools_args (XDR *, remote_list_storage_pools_args*);
extern  bool_t xdr_remote_list_storage_pools_ret (XDR *, remote_list_storage_pools_ret*);
extern  bool_t xdr_remote_num_of_defined_storage_pools_ret (XDR *, remote_num_of_defined_storage_pools_ret*);
extern  bool_t xdr_remote_list_defined_storage_pools_args (XDR *, remote_list_defined_storage_pools_args*);
extern  bool_t xdr_remote_list_defined_storage_pools_ret (XDR *, remote_list_defined_storage_pools_ret*);
extern  bool_t xdr_remote_find_storage_pool_sources_args (XDR *, remote_find_storage_pool_sources_args*);
extern  bool_t xdr_remote_find_storage_pool_sources_ret (XDR *, remote_find_storage_pool_sources_ret*);
extern  bool_t xdr_remote_storage_pool_lookup_by_uuid_args (XDR *, remote_storage_pool_lookup_by_uuid_args*);
extern  bool_t xdr_remote_storage_pool_lookup_by_uuid_ret (XDR *, remote_storage_pool_lookup_by_uuid_ret*);
extern  bool_t xdr_remote_storage_pool_lookup_by_name_args (XDR *, remote_storage_pool_lookup_by_name_args*);
extern  bool_t xdr_remote_storage_pool_lookup_by_name_ret (XDR *, remote_storage_pool_lookup_by_name_ret*);
extern  bool_t xdr_remote_storage_pool_lookup_by_volume_args (XDR *, remote_storage_pool_lookup_by_volume_args*);
extern  bool_t xdr_remote_storage_pool_lookup_by_volume_ret (XDR *, remote_storage_pool_lookup_by_volume_ret*);
extern  bool_t xdr_remote_storage_pool_create_xml_args (XDR *, remote_storage_pool_create_xml_args*);
extern  bool_t xdr_remote_storage_pool_create_xml_ret (XDR *, remote_storage_pool_create_xml_ret*);
extern  bool_t xdr_remote_storage_pool_define_xml_args (XDR *, remote_storage_pool_define_xml_args*);
extern  bool_t xdr_remote_storage_pool_define_xml_ret (XDR *, remote_storage_pool_define_xml_ret*);
extern  bool_t xdr_remote_storage_pool_build_args (XDR *, remote_storage_pool_build_args*);
extern  bool_t xdr_remote_storage_pool_undefine_args (XDR *, remote_storage_pool_undefine_args*);
extern  bool_t xdr_remote_storage_pool_create_args (XDR *, remote_storage_pool_create_args*);
extern  bool_t xdr_remote_storage_pool_destroy_args (XDR *, remote_storage_pool_destroy_args*);
extern  bool_t xdr_remote_storage_pool_delete_args (XDR *, remote_storage_pool_delete_args*);
extern  bool_t xdr_remote_storage_pool_refresh_args (XDR *, remote_storage_pool_refresh_args*);
extern  bool_t xdr_remote_storage_pool_get_xml_desc_args (XDR *, remote_storage_pool_get_xml_desc_args*);
extern  bool_t xdr_remote_storage_pool_get_xml_desc_ret (XDR *, remote_storage_pool_get_xml_desc_ret*);
extern  bool_t xdr_remote_storage_pool_get_info_args (XDR *, remote_storage_pool_get_info_args*);
extern  bool_t xdr_remote_storage_pool_get_info_ret (XDR *, remote_storage_pool_get_info_ret*);
extern  bool_t xdr_remote_storage_pool_get_autostart_args (XDR *, remote_storage_pool_get_autostart_args*);
extern  bool_t xdr_remote_storage_pool_get_autostart_ret (XDR *, remote_storage_pool_get_autostart_ret*);
extern  bool_t xdr_remote_storage_pool_set_autostart_args (XDR *, remote_storage_pool_set_autostart_args*);
extern  bool_t xdr_remote_storage_pool_num_of_volumes_args (XDR *, remote_storage_pool_num_of_volumes_args*);
extern  bool_t xdr_remote_storage_pool_num_of_volumes_ret (XDR *, remote_storage_pool_num_of_volumes_ret*);
extern  bool_t xdr_remote_storage_pool_list_volumes_args (XDR *, remote_storage_pool_list_volumes_args*);
extern  bool_t xdr_remote_storage_pool_list_volumes_ret (XDR *, remote_storage_pool_list_volumes_ret*);
extern  bool_t xdr_remote_storage_vol_lookup_by_name_args (XDR *, remote_storage_vol_lookup_by_name_args*);
extern  bool_t xdr_remote_storage_vol_lookup_by_name_ret (XDR *, remote_storage_vol_lookup_by_name_ret*);
extern  bool_t xdr_remote_storage_vol_lookup_by_key_args (XDR *, remote_storage_vol_lookup_by_key_args*);
extern  bool_t xdr_remote_storage_vol_lookup_by_key_ret (XDR *, remote_storage_vol_lookup_by_key_ret*);
extern  bool_t xdr_remote_storage_vol_lookup_by_path_args (XDR *, remote_storage_vol_lookup_by_path_args*);
extern  bool_t xdr_remote_storage_vol_lookup_by_path_ret (XDR *, remote_storage_vol_lookup_by_path_ret*);
extern  bool_t xdr_remote_storage_vol_create_xml_args (XDR *, remote_storage_vol_create_xml_args*);
extern  bool_t xdr_remote_storage_vol_create_xml_ret (XDR *, remote_storage_vol_create_xml_ret*);
extern  bool_t xdr_remote_storage_vol_create_xml_from_args (XDR *, remote_storage_vol_create_xml_from_args*);
extern  bool_t xdr_remote_storage_vol_create_xml_from_ret (XDR *, remote_storage_vol_create_xml_from_ret*);
extern  bool_t xdr_remote_storage_vol_delete_args (XDR *, remote_storage_vol_delete_args*);
extern  bool_t xdr_remote_storage_vol_wipe_args (XDR *, remote_storage_vol_wipe_args*);
extern  bool_t xdr_remote_storage_vol_wipe_pattern_args (XDR *, remote_storage_vol_wipe_pattern_args*);
extern  bool_t xdr_remote_storage_vol_get_xml_desc_args (XDR *, remote_storage_vol_get_xml_desc_args*);
extern  bool_t xdr_remote_storage_vol_get_xml_desc_ret (XDR *, remote_storage_vol_get_xml_desc_ret*);
extern  bool_t xdr_remote_storage_vol_get_info_args (XDR *, remote_storage_vol_get_info_args*);
extern  bool_t xdr_remote_storage_vol_get_info_ret (XDR *, remote_storage_vol_get_info_ret*);
extern  bool_t xdr_remote_storage_vol_get_path_args (XDR *, remote_storage_vol_get_path_args*);
extern  bool_t xdr_remote_storage_vol_get_path_ret (XDR *, remote_storage_vol_get_path_ret*);
extern  bool_t xdr_remote_storage_vol_resize_args (XDR *, remote_storage_vol_resize_args*);
extern  bool_t xdr_remote_node_num_of_devices_args (XDR *, remote_node_num_of_devices_args*);
extern  bool_t xdr_remote_node_num_of_devices_ret (XDR *, remote_node_num_of_devices_ret*);
extern  bool_t xdr_remote_node_list_devices_args (XDR *, remote_node_list_devices_args*);
extern  bool_t xdr_remote_node_list_devices_ret (XDR *, remote_node_list_devices_ret*);
extern  bool_t xdr_remote_node_device_lookup_by_name_args (XDR *, remote_node_device_lookup_by_name_args*);
extern  bool_t xdr_remote_node_device_lookup_by_name_ret (XDR *, remote_node_device_lookup_by_name_ret*);
extern  bool_t xdr_remote_node_device_lookup_scsi_host_by_wwn_args (XDR *, remote_node_device_lookup_scsi_host_by_wwn_args*);
extern  bool_t xdr_remote_node_device_lookup_scsi_host_by_wwn_ret (XDR *, remote_node_device_lookup_scsi_host_by_wwn_ret*);
extern  bool_t xdr_remote_node_device_get_xml_desc_args (XDR *, remote_node_device_get_xml_desc_args*);
extern  bool_t xdr_remote_node_device_get_xml_desc_ret (XDR *, remote_node_device_get_xml_desc_ret*);
extern  bool_t xdr_remote_node_device_get_parent_args (XDR *, remote_node_device_get_parent_args*);
extern  bool_t xdr_remote_node_device_get_parent_ret (XDR *, remote_node_device_get_parent_ret*);
extern  bool_t xdr_remote_node_device_num_of_caps_args (XDR *, remote_node_device_num_of_caps_args*);
extern  bool_t xdr_remote_node_device_num_of_caps_ret (XDR *, remote_node_device_num_of_caps_ret*);
extern  bool_t xdr_remote_node_device_list_caps_args (XDR *, remote_node_device_list_caps_args*);
extern  bool_t xdr_remote_node_device_list_caps_ret (XDR *, remote_node_device_list_caps_ret*);
extern  bool_t xdr_remote_node_device_dettach_args (XDR *, remote_node_device_dettach_args*);
extern  bool_t xdr_remote_node_device_re_attach_args (XDR *, remote_node_device_re_attach_args*);
extern  bool_t xdr_remote_node_device_reset_args (XDR *, remote_node_device_reset_args*);
extern  bool_t xdr_remote_node_device_create_xml_args (XDR *, remote_node_device_create_xml_args*);
extern  bool_t xdr_remote_node_device_create_xml_ret (XDR *, remote_node_device_create_xml_ret*);
extern  bool_t xdr_remote_node_device_destroy_args (XDR *, remote_node_device_destroy_args*);
extern  bool_t xdr_remote_domain_events_register_ret (XDR *, remote_domain_events_register_ret*);
extern  bool_t xdr_remote_domain_events_deregister_ret (XDR *, remote_domain_events_deregister_ret*);
extern  bool_t xdr_remote_domain_event_lifecycle_msg (XDR *, remote_domain_event_lifecycle_msg*);
extern  bool_t xdr_remote_domain_xml_from_native_args (XDR *, remote_domain_xml_from_native_args*);
extern  bool_t xdr_remote_domain_xml_from_native_ret (XDR *, remote_domain_xml_from_native_ret*);
extern  bool_t xdr_remote_domain_xml_to_native_args (XDR *, remote_domain_xml_to_native_args*);
extern  bool_t xdr_remote_domain_xml_to_native_ret (XDR *, remote_domain_xml_to_native_ret*);
extern  bool_t xdr_remote_num_of_secrets_ret (XDR *, remote_num_of_secrets_ret*);
extern  bool_t xdr_remote_list_secrets_args (XDR *, remote_list_secrets_args*);
extern  bool_t xdr_remote_list_secrets_ret (XDR *, remote_list_secrets_ret*);
extern  bool_t xdr_remote_secret_lookup_by_uuid_args (XDR *, remote_secret_lookup_by_uuid_args*);
extern  bool_t xdr_remote_secret_lookup_by_uuid_ret (XDR *, remote_secret_lookup_by_uuid_ret*);
extern  bool_t xdr_remote_secret_define_xml_args (XDR *, remote_secret_define_xml_args*);
extern  bool_t xdr_remote_secret_define_xml_ret (XDR *, remote_secret_define_xml_ret*);
extern  bool_t xdr_remote_secret_get_xml_desc_args (XDR *, remote_secret_get_xml_desc_args*);
extern  bool_t xdr_remote_secret_get_xml_desc_ret (XDR *, remote_secret_get_xml_desc_ret*);
extern  bool_t xdr_remote_secret_set_value_args (XDR *, remote_secret_set_value_args*);
extern  bool_t xdr_remote_secret_get_value_args (XDR *, remote_secret_get_value_args*);
extern  bool_t xdr_remote_secret_get_value_ret (XDR *, remote_secret_get_value_ret*);
extern  bool_t xdr_remote_secret_undefine_args (XDR *, remote_secret_undefine_args*);
extern  bool_t xdr_remote_secret_lookup_by_usage_args (XDR *, remote_secret_lookup_by_usage_args*);
extern  bool_t xdr_remote_secret_lookup_by_usage_ret (XDR *, remote_secret_lookup_by_usage_ret*);
extern  bool_t xdr_remote_domain_migrate_prepare_tunnel_args (XDR *, remote_domain_migrate_prepare_tunnel_args*);
extern  bool_t xdr_remote_is_secure_ret (XDR *, remote_is_secure_ret*);
extern  bool_t xdr_remote_domain_is_active_args (XDR *, remote_domain_is_active_args*);
extern  bool_t xdr_remote_domain_is_active_ret (XDR *, remote_domain_is_active_ret*);
extern  bool_t xdr_remote_domain_is_persistent_args (XDR *, remote_domain_is_persistent_args*);
extern  bool_t xdr_remote_domain_is_persistent_ret (XDR *, remote_domain_is_persistent_ret*);
extern  bool_t xdr_remote_domain_is_updated_args (XDR *, remote_domain_is_updated_args*);
extern  bool_t xdr_remote_domain_is_updated_ret (XDR *, remote_domain_is_updated_ret*);
extern  bool_t xdr_remote_network_is_active_args (XDR *, remote_network_is_active_args*);
extern  bool_t xdr_remote_network_is_active_ret (XDR *, remote_network_is_active_ret*);
extern  bool_t xdr_remote_network_is_persistent_args (XDR *, remote_network_is_persistent_args*);
extern  bool_t xdr_remote_network_is_persistent_ret (XDR *, remote_network_is_persistent_ret*);
extern  bool_t xdr_remote_storage_pool_is_active_args (XDR *, remote_storage_pool_is_active_args*);
extern  bool_t xdr_remote_storage_pool_is_active_ret (XDR *, remote_storage_pool_is_active_ret*);
extern  bool_t xdr_remote_storage_pool_is_persistent_args (XDR *, remote_storage_pool_is_persistent_args*);
extern  bool_t xdr_remote_storage_pool_is_persistent_ret (XDR *, remote_storage_pool_is_persistent_ret*);
extern  bool_t xdr_remote_interface_is_active_args (XDR *, remote_interface_is_active_args*);
extern  bool_t xdr_remote_interface_is_active_ret (XDR *, remote_interface_is_active_ret*);
extern  bool_t xdr_remote_cpu_compare_args (XDR *, remote_cpu_compare_args*);
extern  bool_t xdr_remote_cpu_compare_ret (XDR *, remote_cpu_compare_ret*);
extern  bool_t xdr_remote_cpu_baseline_args (XDR *, remote_cpu_baseline_args*);
extern  bool_t xdr_remote_cpu_baseline_ret (XDR *, remote_cpu_baseline_ret*);
extern  bool_t xdr_remote_domain_get_job_info_args (XDR *, remote_domain_get_job_info_args*);
extern  bool_t xdr_remote_domain_get_job_info_ret (XDR *, remote_domain_get_job_info_ret*);
extern  bool_t xdr_remote_domain_get_job_stats_args (XDR *, remote_domain_get_job_stats_args*);
extern  bool_t xdr_remote_domain_get_job_stats_ret (XDR *, remote_domain_get_job_stats_ret*);
extern  bool_t xdr_remote_domain_abort_job_args (XDR *, remote_domain_abort_job_args*);
extern  bool_t xdr_remote_domain_migrate_set_max_downtime_args (XDR *, remote_domain_migrate_set_max_downtime_args*);
extern  bool_t xdr_remote_domain_migrate_get_compression_cache_args (XDR *, remote_domain_migrate_get_compression_cache_args*);
extern  bool_t xdr_remote_domain_migrate_get_compression_cache_ret (XDR *, remote_domain_migrate_get_compression_cache_ret*);
extern  bool_t xdr_remote_domain_migrate_set_compression_cache_args (XDR *, remote_domain_migrate_set_compression_cache_args*);
extern  bool_t xdr_remote_domain_migrate_set_max_speed_args (XDR *, remote_domain_migrate_set_max_speed_args*);
extern  bool_t xdr_remote_domain_migrate_get_max_speed_args (XDR *, remote_domain_migrate_get_max_speed_args*);
extern  bool_t xdr_remote_domain_migrate_get_max_speed_ret (XDR *, remote_domain_migrate_get_max_speed_ret*);
extern  bool_t xdr_remote_domain_events_register_any_args (XDR *, remote_domain_events_register_any_args*);
extern  bool_t xdr_remote_domain_events_deregister_any_args (XDR *, remote_domain_events_deregister_any_args*);
extern  bool_t xdr_remote_domain_event_reboot_msg (XDR *, remote_domain_event_reboot_msg*);
extern  bool_t xdr_remote_domain_event_rtc_change_msg (XDR *, remote_domain_event_rtc_change_msg*);
extern  bool_t xdr_remote_domain_event_watchdog_msg (XDR *, remote_domain_event_watchdog_msg*);
extern  bool_t xdr_remote_domain_event_io_error_msg (XDR *, remote_domain_event_io_error_msg*);
extern  bool_t xdr_remote_domain_event_io_error_reason_msg (XDR *, remote_domain_event_io_error_reason_msg*);
extern  bool_t xdr_remote_domain_event_graphics_address (XDR *, remote_domain_event_graphics_address*);
extern  bool_t xdr_remote_domain_event_graphics_identity (XDR *, remote_domain_event_graphics_identity*);
extern  bool_t xdr_remote_domain_event_graphics_msg (XDR *, remote_domain_event_graphics_msg*);
extern  bool_t xdr_remote_domain_event_block_job_msg (XDR *, remote_domain_event_block_job_msg*);
extern  bool_t xdr_remote_domain_event_disk_change_msg (XDR *, remote_domain_event_disk_change_msg*);
extern  bool_t xdr_remote_domain_event_tray_change_msg (XDR *, remote_domain_event_tray_change_msg*);
extern  bool_t xdr_remote_domain_event_pmwakeup_msg (XDR *, remote_domain_event_pmwakeup_msg*);
extern  bool_t xdr_remote_domain_event_pmsuspend_msg (XDR *, remote_domain_event_pmsuspend_msg*);
extern  bool_t xdr_remote_domain_event_balloon_change_msg (XDR *, remote_domain_event_balloon_change_msg*);
extern  bool_t xdr_remote_domain_event_pmsuspend_disk_msg (XDR *, remote_domain_event_pmsuspend_disk_msg*);
extern  bool_t xdr_remote_domain_managed_save_args (XDR *, remote_domain_managed_save_args*);
extern  bool_t xdr_remote_domain_has_managed_save_image_args (XDR *, remote_domain_has_managed_save_image_args*);
extern  bool_t xdr_remote_domain_has_managed_save_image_ret (XDR *, remote_domain_has_managed_save_image_ret*);
extern  bool_t xdr_remote_domain_managed_save_remove_args (XDR *, remote_domain_managed_save_remove_args*);
extern  bool_t xdr_remote_domain_snapshot_create_xml_args (XDR *, remote_domain_snapshot_create_xml_args*);
extern  bool_t xdr_remote_domain_snapshot_create_xml_ret (XDR *, remote_domain_snapshot_create_xml_ret*);
extern  bool_t xdr_remote_domain_snapshot_get_xml_desc_args (XDR *, remote_domain_snapshot_get_xml_desc_args*);
extern  bool_t xdr_remote_domain_snapshot_get_xml_desc_ret (XDR *, remote_domain_snapshot_get_xml_desc_ret*);
extern  bool_t xdr_remote_domain_snapshot_num_args (XDR *, remote_domain_snapshot_num_args*);
extern  bool_t xdr_remote_domain_snapshot_num_ret (XDR *, remote_domain_snapshot_num_ret*);
extern  bool_t xdr_remote_domain_snapshot_list_names_args (XDR *, remote_domain_snapshot_list_names_args*);
extern  bool_t xdr_remote_domain_snapshot_list_names_ret (XDR *, remote_domain_snapshot_list_names_ret*);
extern  bool_t xdr_remote_domain_list_all_snapshots_args (XDR *, remote_domain_list_all_snapshots_args*);
extern  bool_t xdr_remote_domain_list_all_snapshots_ret (XDR *, remote_domain_list_all_snapshots_ret*);
extern  bool_t xdr_remote_domain_snapshot_num_children_args (XDR *, remote_domain_snapshot_num_children_args*);
extern  bool_t xdr_remote_domain_snapshot_num_children_ret (XDR *, remote_domain_snapshot_num_children_ret*);
extern  bool_t xdr_remote_domain_snapshot_list_children_names_args (XDR *, remote_domain_snapshot_list_children_names_args*);
extern  bool_t xdr_remote_domain_snapshot_list_children_names_ret (XDR *, remote_domain_snapshot_list_children_names_ret*);
extern  bool_t xdr_remote_domain_snapshot_list_all_children_args (XDR *, remote_domain_snapshot_list_all_children_args*);
extern  bool_t xdr_remote_domain_snapshot_list_all_children_ret (XDR *, remote_domain_snapshot_list_all_children_ret*);
extern  bool_t xdr_remote_domain_snapshot_lookup_by_name_args (XDR *, remote_domain_snapshot_lookup_by_name_args*);
extern  bool_t xdr_remote_domain_snapshot_lookup_by_name_ret (XDR *, remote_domain_snapshot_lookup_by_name_ret*);
extern  bool_t xdr_remote_domain_has_current_snapshot_args (XDR *, remote_domain_has_current_snapshot_args*);
extern  bool_t xdr_remote_domain_has_current_snapshot_ret (XDR *, remote_domain_has_current_snapshot_ret*);
extern  bool_t xdr_remote_domain_snapshot_get_parent_args (XDR *, remote_domain_snapshot_get_parent_args*);
extern  bool_t xdr_remote_domain_snapshot_get_parent_ret (XDR *, remote_domain_snapshot_get_parent_ret*);
extern  bool_t xdr_remote_domain_snapshot_current_args (XDR *, remote_domain_snapshot_current_args*);
extern  bool_t xdr_remote_domain_snapshot_current_ret (XDR *, remote_domain_snapshot_current_ret*);
extern  bool_t xdr_remote_domain_snapshot_is_current_args (XDR *, remote_domain_snapshot_is_current_args*);
extern  bool_t xdr_remote_domain_snapshot_is_current_ret (XDR *, remote_domain_snapshot_is_current_ret*);
extern  bool_t xdr_remote_domain_snapshot_has_metadata_args (XDR *, remote_domain_snapshot_has_metadata_args*);
extern  bool_t xdr_remote_domain_snapshot_has_metadata_ret (XDR *, remote_domain_snapshot_has_metadata_ret*);
extern  bool_t xdr_remote_domain_revert_to_snapshot_args (XDR *, remote_domain_revert_to_snapshot_args*);
extern  bool_t xdr_remote_domain_snapshot_delete_args (XDR *, remote_domain_snapshot_delete_args*);
extern  bool_t xdr_remote_domain_open_console_args (XDR *, remote_domain_open_console_args*);
extern  bool_t xdr_remote_domain_open_channel_args (XDR *, remote_domain_open_channel_args*);
extern  bool_t xdr_remote_storage_vol_upload_args (XDR *, remote_storage_vol_upload_args*);
extern  bool_t xdr_remote_storage_vol_download_args (XDR *, remote_storage_vol_download_args*);
extern  bool_t xdr_remote_domain_get_state_args (XDR *, remote_domain_get_state_args*);
extern  bool_t xdr_remote_domain_get_state_ret (XDR *, remote_domain_get_state_ret*);
extern  bool_t xdr_remote_domain_migrate_begin3_args (XDR *, remote_domain_migrate_begin3_args*);
extern  bool_t xdr_remote_domain_migrate_begin3_ret (XDR *, remote_domain_migrate_begin3_ret*);
extern  bool_t xdr_remote_domain_migrate_prepare3_args (XDR *, remote_domain_migrate_prepare3_args*);
extern  bool_t xdr_remote_domain_migrate_prepare3_ret (XDR *, remote_domain_migrate_prepare3_ret*);
extern  bool_t xdr_remote_domain_migrate_prepare_tunnel3_args (XDR *, remote_domain_migrate_prepare_tunnel3_args*);
extern  bool_t xdr_remote_domain_migrate_prepare_tunnel3_ret (XDR *, remote_domain_migrate_prepare_tunnel3_ret*);
extern  bool_t xdr_remote_domain_migrate_perform3_args (XDR *, remote_domain_migrate_perform3_args*);
extern  bool_t xdr_remote_domain_migrate_perform3_ret (XDR *, remote_domain_migrate_perform3_ret*);
extern  bool_t xdr_remote_domain_migrate_finish3_args (XDR *, remote_domain_migrate_finish3_args*);
extern  bool_t xdr_remote_domain_migrate_finish3_ret (XDR *, remote_domain_migrate_finish3_ret*);
extern  bool_t xdr_remote_domain_migrate_confirm3_args (XDR *, remote_domain_migrate_confirm3_args*);
extern  bool_t xdr_remote_domain_event_control_error_msg (XDR *, remote_domain_event_control_error_msg*);
extern  bool_t xdr_remote_domain_get_control_info_args (XDR *, remote_domain_get_control_info_args*);
extern  bool_t xdr_remote_domain_get_control_info_ret (XDR *, remote_domain_get_control_info_ret*);
extern  bool_t xdr_remote_domain_open_graphics_args (XDR *, remote_domain_open_graphics_args*);
extern  bool_t xdr_remote_node_suspend_for_duration_args (XDR *, remote_node_suspend_for_duration_args*);
extern  bool_t xdr_remote_domain_shutdown_flags_args (XDR *, remote_domain_shutdown_flags_args*);
extern  bool_t xdr_remote_domain_get_disk_errors_args (XDR *, remote_domain_get_disk_errors_args*);
extern  bool_t xdr_remote_domain_get_disk_errors_ret (XDR *, remote_domain_get_disk_errors_ret*);
extern  bool_t xdr_remote_connect_list_all_domains_args (XDR *, remote_connect_list_all_domains_args*);
extern  bool_t xdr_remote_connect_list_all_domains_ret (XDR *, remote_connect_list_all_domains_ret*);
extern  bool_t xdr_remote_connect_list_all_storage_pools_args (XDR *, remote_connect_list_all_storage_pools_args*);
extern  bool_t xdr_remote_connect_list_all_storage_pools_ret (XDR *, remote_connect_list_all_storage_pools_ret*);
extern  bool_t xdr_remote_storage_pool_list_all_volumes_args (XDR *, remote_storage_pool_list_all_volumes_args*);
extern  bool_t xdr_remote_storage_pool_list_all_volumes_ret (XDR *, remote_storage_pool_list_all_volumes_ret*);
extern  bool_t xdr_remote_connect_list_all_networks_args (XDR *, remote_connect_list_all_networks_args*);
extern  bool_t xdr_remote_connect_list_all_networks_ret (XDR *, remote_connect_list_all_networks_ret*);
extern  bool_t xdr_remote_connect_list_all_interfaces_args (XDR *, remote_connect_list_all_interfaces_args*);
extern  bool_t xdr_remote_connect_list_all_interfaces_ret (XDR *, remote_connect_list_all_interfaces_ret*);
extern  bool_t xdr_remote_connect_list_all_node_devices_args (XDR *, remote_connect_list_all_node_devices_args*);
extern  bool_t xdr_remote_connect_list_all_node_devices_ret (XDR *, remote_connect_list_all_node_devices_ret*);
extern  bool_t xdr_remote_connect_list_all_nwfilters_args (XDR *, remote_connect_list_all_nwfilters_args*);
extern  bool_t xdr_remote_connect_list_all_nwfilters_ret (XDR *, remote_connect_list_all_nwfilters_ret*);
extern  bool_t xdr_remote_connect_list_all_secrets_args (XDR *, remote_connect_list_all_secrets_args*);
extern  bool_t xdr_remote_connect_list_all_secrets_ret (XDR *, remote_connect_list_all_secrets_ret*);
extern  bool_t xdr_remote_node_set_memory_parameters_args (XDR *, remote_node_set_memory_parameters_args*);
extern  bool_t xdr_remote_node_get_memory_parameters_args (XDR *, remote_node_get_memory_parameters_args*);
extern  bool_t xdr_remote_node_get_memory_parameters_ret (XDR *, remote_node_get_memory_parameters_ret*);
extern  bool_t xdr_remote_node_get_cpu_map_args (XDR *, remote_node_get_cpu_map_args*);
extern  bool_t xdr_remote_node_get_cpu_map_ret (XDR *, remote_node_get_cpu_map_ret*);
extern  bool_t xdr_remote_domain_fstrim_args (XDR *, remote_domain_fstrim_args*);
extern  bool_t xdr_remote_procedure (XDR *, remote_procedure*);

#else /* K&R C */
extern bool_t xdr_remote_nonnull_string ();
extern bool_t xdr_remote_string ();
extern bool_t xdr_remote_uuid ();
extern bool_t xdr_remote_nonnull_domain ();
extern bool_t xdr_remote_nonnull_network ();
extern bool_t xdr_remote_nonnull_nwfilter ();
extern bool_t xdr_remote_nonnull_interface ();
extern bool_t xdr_remote_nonnull_storage_pool ();
extern bool_t xdr_remote_nonnull_storage_vol ();
extern bool_t xdr_remote_nonnull_node_device ();
extern bool_t xdr_remote_nonnull_secret ();
extern bool_t xdr_remote_nonnull_domain_snapshot ();
extern bool_t xdr_remote_domain ();
extern bool_t xdr_remote_network ();
extern bool_t xdr_remote_nwfilter ();
extern bool_t xdr_remote_storage_pool ();
extern bool_t xdr_remote_storage_vol ();
extern bool_t xdr_remote_node_device ();
extern bool_t xdr_remote_error ();
extern bool_t xdr_remote_auth_type ();
extern bool_t xdr_remote_vcpu_info ();
extern bool_t xdr_remote_typed_param_value ();
extern bool_t xdr_remote_typed_param ();
extern bool_t xdr_remote_node_get_cpu_stats ();
extern bool_t xdr_remote_node_get_memory_stats ();
extern bool_t xdr_remote_domain_disk_error ();
extern bool_t xdr_remote_open_args ();
extern bool_t xdr_remote_supports_feature_args ();
extern bool_t xdr_remote_supports_feature_ret ();
extern bool_t xdr_remote_get_type_ret ();
extern bool_t xdr_remote_get_version_ret ();
extern bool_t xdr_remote_get_lib_version_ret ();
extern bool_t xdr_remote_get_hostname_ret ();
extern bool_t xdr_remote_get_sysinfo_args ();
extern bool_t xdr_remote_get_sysinfo_ret ();
extern bool_t xdr_remote_get_uri_ret ();
extern bool_t xdr_remote_get_max_vcpus_args ();
extern bool_t xdr_remote_get_max_vcpus_ret ();
extern bool_t xdr_remote_node_get_info_ret ();
extern bool_t xdr_remote_get_capabilities_ret ();
extern bool_t xdr_remote_node_get_cpu_stats_args ();
extern bool_t xdr_remote_node_get_cpu_stats_ret ();
extern bool_t xdr_remote_node_get_memory_stats_args ();
extern bool_t xdr_remote_node_get_memory_stats_ret ();
extern bool_t xdr_remote_node_get_cells_free_memory_args ();
extern bool_t xdr_remote_node_get_cells_free_memory_ret ();
extern bool_t xdr_remote_node_get_free_memory_ret ();
extern bool_t xdr_remote_domain_get_scheduler_type_args ();
extern bool_t xdr_remote_domain_get_scheduler_type_ret ();
extern bool_t xdr_remote_domain_get_scheduler_parameters_args ();
extern bool_t xdr_remote_domain_get_scheduler_parameters_ret ();
extern bool_t xdr_remote_domain_get_scheduler_parameters_flags_args ();
extern bool_t xdr_remote_domain_get_scheduler_parameters_flags_ret ();
extern bool_t xdr_remote_domain_set_scheduler_parameters_args ();
extern bool_t xdr_remote_domain_set_scheduler_parameters_flags_args ();
extern bool_t xdr_remote_domain_set_blkio_parameters_args ();
extern bool_t xdr_remote_domain_get_blkio_parameters_args ();
extern bool_t xdr_remote_domain_get_blkio_parameters_ret ();
extern bool_t xdr_remote_domain_set_memory_parameters_args ();
extern bool_t xdr_remote_domain_get_memory_parameters_args ();
extern bool_t xdr_remote_domain_get_memory_parameters_ret ();
extern bool_t xdr_remote_domain_block_resize_args ();
extern bool_t xdr_remote_domain_set_numa_parameters_args ();
extern bool_t xdr_remote_domain_get_numa_parameters_args ();
extern bool_t xdr_remote_domain_get_numa_parameters_ret ();
extern bool_t xdr_remote_domain_block_stats_args ();
extern bool_t xdr_remote_domain_block_stats_ret ();
extern bool_t xdr_remote_domain_block_stats_flags_args ();
extern bool_t xdr_remote_domain_block_stats_flags_ret ();
extern bool_t xdr_remote_domain_interface_stats_args ();
extern bool_t xdr_remote_domain_interface_stats_ret ();
extern bool_t xdr_remote_domain_set_interface_parameters_args ();
extern bool_t xdr_remote_domain_get_interface_parameters_args ();
extern bool_t xdr_remote_domain_get_interface_parameters_ret ();
extern bool_t xdr_remote_domain_memory_stats_args ();
extern bool_t xdr_remote_domain_memory_stat ();
extern bool_t xdr_remote_domain_memory_stats_ret ();
extern bool_t xdr_remote_domain_block_peek_args ();
extern bool_t xdr_remote_domain_block_peek_ret ();
extern bool_t xdr_remote_domain_memory_peek_args ();
extern bool_t xdr_remote_domain_memory_peek_ret ();
extern bool_t xdr_remote_domain_get_block_info_args ();
extern bool_t xdr_remote_domain_get_block_info_ret ();
extern bool_t xdr_remote_list_domains_args ();
extern bool_t xdr_remote_list_domains_ret ();
extern bool_t xdr_remote_num_of_domains_ret ();
extern bool_t xdr_remote_domain_create_xml_args ();
extern bool_t xdr_remote_domain_create_xml_ret ();
extern bool_t xdr_remote_domain_lookup_by_id_args ();
extern bool_t xdr_remote_domain_lookup_by_id_ret ();
extern bool_t xdr_remote_domain_lookup_by_uuid_args ();
extern bool_t xdr_remote_domain_lookup_by_uuid_ret ();
extern bool_t xdr_remote_domain_lookup_by_name_args ();
extern bool_t xdr_remote_domain_lookup_by_name_ret ();
extern bool_t xdr_remote_domain_suspend_args ();
extern bool_t xdr_remote_domain_resume_args ();
extern bool_t xdr_remote_domain_pm_suspend_for_duration_args ();
extern bool_t xdr_remote_domain_pm_wakeup_args ();
extern bool_t xdr_remote_domain_shutdown_args ();
extern bool_t xdr_remote_domain_reboot_args ();
extern bool_t xdr_remote_domain_reset_args ();
extern bool_t xdr_remote_domain_destroy_args ();
extern bool_t xdr_remote_domain_destroy_flags_args ();
extern bool_t xdr_remote_domain_get_os_type_args ();
extern bool_t xdr_remote_domain_get_os_type_ret ();
extern bool_t xdr_remote_domain_get_max_memory_args ();
extern bool_t xdr_remote_domain_get_max_memory_ret ();
extern bool_t xdr_remote_domain_set_max_memory_args ();
extern bool_t xdr_remote_domain_set_memory_args ();
extern bool_t xdr_remote_domain_set_memory_flags_args ();
extern bool_t xdr_remote_domain_get_info_args ();
extern bool_t xdr_remote_domain_get_info_ret ();
extern bool_t xdr_remote_domain_save_args ();
extern bool_t xdr_remote_domain_save_flags_args ();
extern bool_t xdr_remote_domain_restore_args ();
extern bool_t xdr_remote_domain_restore_flags_args ();
extern bool_t xdr_remote_domain_save_image_get_xml_desc_args ();
extern bool_t xdr_remote_domain_save_image_get_xml_desc_ret ();
extern bool_t xdr_remote_domain_save_image_define_xml_args ();
extern bool_t xdr_remote_domain_core_dump_args ();
extern bool_t xdr_remote_domain_screenshot_args ();
extern bool_t xdr_remote_domain_screenshot_ret ();
extern bool_t xdr_remote_domain_get_xml_desc_args ();
extern bool_t xdr_remote_domain_get_xml_desc_ret ();
extern bool_t xdr_remote_domain_migrate_prepare_args ();
extern bool_t xdr_remote_domain_migrate_prepare_ret ();
extern bool_t xdr_remote_domain_migrate_perform_args ();
extern bool_t xdr_remote_domain_migrate_finish_args ();
extern bool_t xdr_remote_domain_migrate_finish_ret ();
extern bool_t xdr_remote_domain_migrate_prepare2_args ();
extern bool_t xdr_remote_domain_migrate_prepare2_ret ();
extern bool_t xdr_remote_domain_migrate_finish2_args ();
extern bool_t xdr_remote_domain_migrate_finish2_ret ();
extern bool_t xdr_remote_list_defined_domains_args ();
extern bool_t xdr_remote_list_defined_domains_ret ();
extern bool_t xdr_remote_num_of_defined_domains_ret ();
extern bool_t xdr_remote_domain_create_args ();
extern bool_t xdr_remote_domain_create_with_flags_args ();
extern bool_t xdr_remote_domain_create_with_flags_ret ();
extern bool_t xdr_remote_domain_define_xml_args ();
extern bool_t xdr_remote_domain_define_xml_ret ();
extern bool_t xdr_remote_domain_undefine_args ();
extern bool_t xdr_remote_domain_undefine_flags_args ();
extern bool_t xdr_remote_domain_inject_nmi_args ();
extern bool_t xdr_remote_domain_send_key_args ();
extern bool_t xdr_remote_domain_send_process_signal_args ();
extern bool_t xdr_remote_domain_set_vcpus_args ();
extern bool_t xdr_remote_domain_set_vcpus_flags_args ();
extern bool_t xdr_remote_domain_get_vcpus_flags_args ();
extern bool_t xdr_remote_domain_get_vcpus_flags_ret ();
extern bool_t xdr_remote_domain_pin_vcpu_args ();
extern bool_t xdr_remote_domain_pin_vcpu_flags_args ();
extern bool_t xdr_remote_domain_get_vcpu_pin_info_args ();
extern bool_t xdr_remote_domain_get_vcpu_pin_info_ret ();
extern bool_t xdr_remote_domain_pin_emulator_args ();
extern bool_t xdr_remote_domain_get_emulator_pin_info_args ();
extern bool_t xdr_remote_domain_get_emulator_pin_info_ret ();
extern bool_t xdr_remote_domain_get_vcpus_args ();
extern bool_t xdr_remote_domain_get_vcpus_ret ();
extern bool_t xdr_remote_domain_get_max_vcpus_args ();
extern bool_t xdr_remote_domain_get_max_vcpus_ret ();
extern bool_t xdr_remote_domain_get_security_label_args ();
extern bool_t xdr_remote_domain_get_security_label_ret ();
extern bool_t xdr_remote_domain_get_security_label_list_args ();
extern bool_t xdr_remote_domain_get_security_label_list_ret ();
extern bool_t xdr_remote_node_get_security_model_ret ();
extern bool_t xdr_remote_domain_attach_device_args ();
extern bool_t xdr_remote_domain_attach_device_flags_args ();
extern bool_t xdr_remote_domain_detach_device_args ();
extern bool_t xdr_remote_domain_detach_device_flags_args ();
extern bool_t xdr_remote_domain_update_device_flags_args ();
extern bool_t xdr_remote_domain_get_autostart_args ();
extern bool_t xdr_remote_domain_get_autostart_ret ();
extern bool_t xdr_remote_domain_set_autostart_args ();
extern bool_t xdr_remote_domain_set_metadata_args ();
extern bool_t xdr_remote_domain_get_metadata_args ();
extern bool_t xdr_remote_domain_get_metadata_ret ();
extern bool_t xdr_remote_domain_block_job_abort_args ();
extern bool_t xdr_remote_domain_get_block_job_info_args ();
extern bool_t xdr_remote_domain_get_block_job_info_ret ();
extern bool_t xdr_remote_domain_block_job_set_speed_args ();
extern bool_t xdr_remote_domain_block_pull_args ();
extern bool_t xdr_remote_domain_block_rebase_args ();
extern bool_t xdr_remote_domain_block_commit_args ();
extern bool_t xdr_remote_domain_set_block_io_tune_args ();
extern bool_t xdr_remote_domain_get_block_io_tune_args ();
extern bool_t xdr_remote_domain_get_block_io_tune_ret ();
extern bool_t xdr_remote_domain_get_cpu_stats_args ();
extern bool_t xdr_remote_domain_get_cpu_stats_ret ();
extern bool_t xdr_remote_domain_get_hostname_args ();
extern bool_t xdr_remote_domain_get_hostname_ret ();
extern bool_t xdr_remote_num_of_networks_ret ();
extern bool_t xdr_remote_list_networks_args ();
extern bool_t xdr_remote_list_networks_ret ();
extern bool_t xdr_remote_num_of_defined_networks_ret ();
extern bool_t xdr_remote_list_defined_networks_args ();
extern bool_t xdr_remote_list_defined_networks_ret ();
extern bool_t xdr_remote_network_lookup_by_uuid_args ();
extern bool_t xdr_remote_network_lookup_by_uuid_ret ();
extern bool_t xdr_remote_network_lookup_by_name_args ();
extern bool_t xdr_remote_network_lookup_by_name_ret ();
extern bool_t xdr_remote_network_create_xml_args ();
extern bool_t xdr_remote_network_create_xml_ret ();
extern bool_t xdr_remote_network_define_xml_args ();
extern bool_t xdr_remote_network_define_xml_ret ();
extern bool_t xdr_remote_network_undefine_args ();
extern bool_t xdr_remote_network_update_args ();
extern bool_t xdr_remote_network_create_args ();
extern bool_t xdr_remote_network_destroy_args ();
extern bool_t xdr_remote_network_get_xml_desc_args ();
extern bool_t xdr_remote_network_get_xml_desc_ret ();
extern bool_t xdr_remote_network_get_bridge_name_args ();
extern bool_t xdr_remote_network_get_bridge_name_ret ();
extern bool_t xdr_remote_network_get_autostart_args ();
extern bool_t xdr_remote_network_get_autostart_ret ();
extern bool_t xdr_remote_network_set_autostart_args ();
extern bool_t xdr_remote_num_of_nwfilters_ret ();
extern bool_t xdr_remote_list_nwfilters_args ();
extern bool_t xdr_remote_list_nwfilters_ret ();
extern bool_t xdr_remote_nwfilter_lookup_by_uuid_args ();
extern bool_t xdr_remote_nwfilter_lookup_by_uuid_ret ();
extern bool_t xdr_remote_nwfilter_lookup_by_name_args ();
extern bool_t xdr_remote_nwfilter_lookup_by_name_ret ();
extern bool_t xdr_remote_nwfilter_define_xml_args ();
extern bool_t xdr_remote_nwfilter_define_xml_ret ();
extern bool_t xdr_remote_nwfilter_undefine_args ();
extern bool_t xdr_remote_nwfilter_get_xml_desc_args ();
extern bool_t xdr_remote_nwfilter_get_xml_desc_ret ();
extern bool_t xdr_remote_num_of_interfaces_ret ();
extern bool_t xdr_remote_list_interfaces_args ();
extern bool_t xdr_remote_list_interfaces_ret ();
extern bool_t xdr_remote_num_of_defined_interfaces_ret ();
extern bool_t xdr_remote_list_defined_interfaces_args ();
extern bool_t xdr_remote_list_defined_interfaces_ret ();
extern bool_t xdr_remote_interface_lookup_by_name_args ();
extern bool_t xdr_remote_interface_lookup_by_name_ret ();
extern bool_t xdr_remote_interface_lookup_by_mac_string_args ();
extern bool_t xdr_remote_interface_lookup_by_mac_string_ret ();
extern bool_t xdr_remote_interface_get_xml_desc_args ();
extern bool_t xdr_remote_interface_get_xml_desc_ret ();
extern bool_t xdr_remote_interface_define_xml_args ();
extern bool_t xdr_remote_interface_define_xml_ret ();
extern bool_t xdr_remote_interface_undefine_args ();
extern bool_t xdr_remote_interface_create_args ();
extern bool_t xdr_remote_interface_destroy_args ();
extern bool_t xdr_remote_interface_change_begin_args ();
extern bool_t xdr_remote_interface_change_commit_args ();
extern bool_t xdr_remote_interface_change_rollback_args ();
extern bool_t xdr_remote_auth_list_ret ();
extern bool_t xdr_remote_auth_sasl_init_ret ();
extern bool_t xdr_remote_auth_sasl_start_args ();
extern bool_t xdr_remote_auth_sasl_start_ret ();
extern bool_t xdr_remote_auth_sasl_step_args ();
extern bool_t xdr_remote_auth_sasl_step_ret ();
extern bool_t xdr_remote_auth_polkit_ret ();
extern bool_t xdr_remote_num_of_storage_pools_ret ();
extern bool_t xdr_remote_list_storage_pools_args ();
extern bool_t xdr_remote_list_storage_pools_ret ();
extern bool_t xdr_remote_num_of_defined_storage_pools_ret ();
extern bool_t xdr_remote_list_defined_storage_pools_args ();
extern bool_t xdr_remote_list_defined_storage_pools_ret ();
extern bool_t xdr_remote_find_storage_pool_sources_args ();
extern bool_t xdr_remote_find_storage_pool_sources_ret ();
extern bool_t xdr_remote_storage_pool_lookup_by_uuid_args ();
extern bool_t xdr_remote_storage_pool_lookup_by_uuid_ret ();
extern bool_t xdr_remote_storage_pool_lookup_by_name_args ();
extern bool_t xdr_remote_storage_pool_lookup_by_name_ret ();
extern bool_t xdr_remote_storage_pool_lookup_by_volume_args ();
extern bool_t xdr_remote_storage_pool_lookup_by_volume_ret ();
extern bool_t xdr_remote_storage_pool_create_xml_args ();
extern bool_t xdr_remote_storage_pool_create_xml_ret ();
extern bool_t xdr_remote_storage_pool_define_xml_args ();
extern bool_t xdr_remote_storage_pool_define_xml_ret ();
extern bool_t xdr_remote_storage_pool_build_args ();
extern bool_t xdr_remote_storage_pool_undefine_args ();
extern bool_t xdr_remote_storage_pool_create_args ();
extern bool_t xdr_remote_storage_pool_destroy_args ();
extern bool_t xdr_remote_storage_pool_delete_args ();
extern bool_t xdr_remote_storage_pool_refresh_args ();
extern bool_t xdr_remote_storage_pool_get_xml_desc_args ();
extern bool_t xdr_remote_storage_pool_get_xml_desc_ret ();
extern bool_t xdr_remote_storage_pool_get_info_args ();
extern bool_t xdr_remote_storage_pool_get_info_ret ();
extern bool_t xdr_remote_storage_pool_get_autostart_args ();
extern bool_t xdr_remote_storage_pool_get_autostart_ret ();
extern bool_t xdr_remote_storage_pool_set_autostart_args ();
extern bool_t xdr_remote_storage_pool_num_of_volumes_args ();
extern bool_t xdr_remote_storage_pool_num_of_volumes_ret ();
extern bool_t xdr_remote_storage_pool_list_volumes_args ();
extern bool_t xdr_remote_storage_pool_list_volumes_ret ();
extern bool_t xdr_remote_storage_vol_lookup_by_name_args ();
extern bool_t xdr_remote_storage_vol_lookup_by_name_ret ();
extern bool_t xdr_remote_storage_vol_lookup_by_key_args ();
extern bool_t xdr_remote_storage_vol_lookup_by_key_ret ();
extern bool_t xdr_remote_storage_vol_lookup_by_path_args ();
extern bool_t xdr_remote_storage_vol_lookup_by_path_ret ();
extern bool_t xdr_remote_storage_vol_create_xml_args ();
extern bool_t xdr_remote_storage_vol_create_xml_ret ();
extern bool_t xdr_remote_storage_vol_create_xml_from_args ();
extern bool_t xdr_remote_storage_vol_create_xml_from_ret ();
extern bool_t xdr_remote_storage_vol_delete_args ();
extern bool_t xdr_remote_storage_vol_wipe_args ();
extern bool_t xdr_remote_storage_vol_wipe_pattern_args ();
extern bool_t xdr_remote_storage_vol_get_xml_desc_args ();
extern bool_t xdr_remote_storage_vol_get_xml_desc_ret ();
extern bool_t xdr_remote_storage_vol_get_info_args ();
extern bool_t xdr_remote_storage_vol_get_info_ret ();
extern bool_t xdr_remote_storage_vol_get_path_args ();
extern bool_t xdr_remote_storage_vol_get_path_ret ();
extern bool_t xdr_remote_storage_vol_resize_args ();
extern bool_t xdr_remote_node_num_of_devices_args ();
extern bool_t xdr_remote_node_num_of_devices_ret ();
extern bool_t xdr_remote_node_list_devices_args ();
extern bool_t xdr_remote_node_list_devices_ret ();
extern bool_t xdr_remote_node_device_lookup_by_name_args ();
extern bool_t xdr_remote_node_device_lookup_by_name_ret ();
extern bool_t xdr_remote_node_device_lookup_scsi_host_by_wwn_args ();
extern bool_t xdr_remote_node_device_lookup_scsi_host_by_wwn_ret ();
extern bool_t xdr_remote_node_device_get_xml_desc_args ();
extern bool_t xdr_remote_node_device_get_xml_desc_ret ();
extern bool_t xdr_remote_node_device_get_parent_args ();
extern bool_t xdr_remote_node_device_get_parent_ret ();
extern bool_t xdr_remote_node_device_num_of_caps_args ();
extern bool_t xdr_remote_node_device_num_of_caps_ret ();
extern bool_t xdr_remote_node_device_list_caps_args ();
extern bool_t xdr_remote_node_device_list_caps_ret ();
extern bool_t xdr_remote_node_device_dettach_args ();
extern bool_t xdr_remote_node_device_re_attach_args ();
extern bool_t xdr_remote_node_device_reset_args ();
extern bool_t xdr_remote_node_device_create_xml_args ();
extern bool_t xdr_remote_node_device_create_xml_ret ();
extern bool_t xdr_remote_node_device_destroy_args ();
extern bool_t xdr_remote_domain_events_register_ret ();
extern bool_t xdr_remote_domain_events_deregister_ret ();
extern bool_t xdr_remote_domain_event_lifecycle_msg ();
extern bool_t xdr_remote_domain_xml_from_native_args ();
extern bool_t xdr_remote_domain_xml_from_native_ret ();
extern bool_t xdr_remote_domain_xml_to_native_args ();
extern bool_t xdr_remote_domain_xml_to_native_ret ();
extern bool_t xdr_remote_num_of_secrets_ret ();
extern bool_t xdr_remote_list_secrets_args ();
extern bool_t xdr_remote_list_secrets_ret ();
extern bool_t xdr_remote_secret_lookup_by_uuid_args ();
extern bool_t xdr_remote_secret_lookup_by_uuid_ret ();
extern bool_t xdr_remote_secret_define_xml_args ();
extern bool_t xdr_remote_secret_define_xml_ret ();
extern bool_t xdr_remote_secret_get_xml_desc_args ();
extern bool_t xdr_remote_secret_get_xml_desc_ret ();
extern bool_t xdr_remote_secret_set_value_args ();
extern bool_t xdr_remote_secret_get_value_args ();
extern bool_t xdr_remote_secret_get_value_ret ();
extern bool_t xdr_remote_secret_undefine_args ();
extern bool_t xdr_remote_secret_lookup_by_usage_args ();
extern bool_t xdr_remote_secret_lookup_by_usage_ret ();
extern bool_t xdr_remote_domain_migrate_prepare_tunnel_args ();
extern bool_t xdr_remote_is_secure_ret ();
extern bool_t xdr_remote_domain_is_active_args ();
extern bool_t xdr_remote_domain_is_active_ret ();
extern bool_t xdr_remote_domain_is_persistent_args ();
extern bool_t xdr_remote_domain_is_persistent_ret ();
extern bool_t xdr_remote_domain_is_updated_args ();
extern bool_t xdr_remote_domain_is_updated_ret ();
extern bool_t xdr_remote_network_is_active_args ();
extern bool_t xdr_remote_network_is_active_ret ();
extern bool_t xdr_remote_network_is_persistent_args ();
extern bool_t xdr_remote_network_is_persistent_ret ();
extern bool_t xdr_remote_storage_pool_is_active_args ();
extern bool_t xdr_remote_storage_pool_is_active_ret ();
extern bool_t xdr_remote_storage_pool_is_persistent_args ();
extern bool_t xdr_remote_storage_pool_is_persistent_ret ();
extern bool_t xdr_remote_interface_is_active_args ();
extern bool_t xdr_remote_interface_is_active_ret ();
extern bool_t xdr_remote_cpu_compare_args ();
extern bool_t xdr_remote_cpu_compare_ret ();
extern bool_t xdr_remote_cpu_baseline_args ();
extern bool_t xdr_remote_cpu_baseline_ret ();
extern bool_t xdr_remote_domain_get_job_info_args ();
extern bool_t xdr_remote_domain_get_job_info_ret ();
extern bool_t xdr_remote_domain_get_job_stats_args ();
extern bool_t xdr_remote_domain_get_job_stats_ret ();
extern bool_t xdr_remote_domain_abort_job_args ();
extern bool_t xdr_remote_domain_migrate_set_max_downtime_args ();
extern bool_t xdr_remote_domain_migrate_get_compression_cache_args ();
extern bool_t xdr_remote_domain_migrate_get_compression_cache_ret ();
extern bool_t xdr_remote_domain_migrate_set_compression_cache_args ();
extern bool_t xdr_remote_domain_migrate_set_max_speed_args ();
extern bool_t xdr_remote_domain_migrate_get_max_speed_args ();
extern bool_t xdr_remote_domain_migrate_get_max_speed_ret ();
extern bool_t xdr_remote_domain_events_register_any_args ();
extern bool_t xdr_remote_domain_events_deregister_any_args ();
extern bool_t xdr_remote_domain_event_reboot_msg ();
extern bool_t xdr_remote_domain_event_rtc_change_msg ();
extern bool_t xdr_remote_domain_event_watchdog_msg ();
extern bool_t xdr_remote_domain_event_io_error_msg ();
extern bool_t xdr_remote_domain_event_io_error_reason_msg ();
extern bool_t xdr_remote_domain_event_graphics_address ();
extern bool_t xdr_remote_domain_event_graphics_identity ();
extern bool_t xdr_remote_domain_event_graphics_msg ();
extern bool_t xdr_remote_domain_event_block_job_msg ();
extern bool_t xdr_remote_domain_event_disk_change_msg ();
extern bool_t xdr_remote_domain_event_tray_change_msg ();
extern bool_t xdr_remote_domain_event_pmwakeup_msg ();
extern bool_t xdr_remote_domain_event_pmsuspend_msg ();
extern bool_t xdr_remote_domain_event_balloon_change_msg ();
extern bool_t xdr_remote_domain_event_pmsuspend_disk_msg ();
extern bool_t xdr_remote_domain_managed_save_args ();
extern bool_t xdr_remote_domain_has_managed_save_image_args ();
extern bool_t xdr_remote_domain_has_managed_save_image_ret ();
extern bool_t xdr_remote_domain_managed_save_remove_args ();
extern bool_t xdr_remote_domain_snapshot_create_xml_args ();
extern bool_t xdr_remote_domain_snapshot_create_xml_ret ();
extern bool_t xdr_remote_domain_snapshot_get_xml_desc_args ();
extern bool_t xdr_remote_domain_snapshot_get_xml_desc_ret ();
extern bool_t xdr_remote_domain_snapshot_num_args ();
extern bool_t xdr_remote_domain_snapshot_num_ret ();
extern bool_t xdr_remote_domain_snapshot_list_names_args ();
extern bool_t xdr_remote_domain_snapshot_list_names_ret ();
extern bool_t xdr_remote_domain_list_all_snapshots_args ();
extern bool_t xdr_remote_domain_list_all_snapshots_ret ();
extern bool_t xdr_remote_domain_snapshot_num_children_args ();
extern bool_t xdr_remote_domain_snapshot_num_children_ret ();
extern bool_t xdr_remote_domain_snapshot_list_children_names_args ();
extern bool_t xdr_remote_domain_snapshot_list_children_names_ret ();
extern bool_t xdr_remote_domain_snapshot_list_all_children_args ();
extern bool_t xdr_remote_domain_snapshot_list_all_children_ret ();
extern bool_t xdr_remote_domain_snapshot_lookup_by_name_args ();
extern bool_t xdr_remote_domain_snapshot_lookup_by_name_ret ();
extern bool_t xdr_remote_domain_has_current_snapshot_args ();
extern bool_t xdr_remote_domain_has_current_snapshot_ret ();
extern bool_t xdr_remote_domain_snapshot_get_parent_args ();
extern bool_t xdr_remote_domain_snapshot_get_parent_ret ();
extern bool_t xdr_remote_domain_snapshot_current_args ();
extern bool_t xdr_remote_domain_snapshot_current_ret ();
extern bool_t xdr_remote_domain_snapshot_is_current_args ();
extern bool_t xdr_remote_domain_snapshot_is_current_ret ();
extern bool_t xdr_remote_domain_snapshot_has_metadata_args ();
extern bool_t xdr_remote_domain_snapshot_has_metadata_ret ();
extern bool_t xdr_remote_domain_revert_to_snapshot_args ();
extern bool_t xdr_remote_domain_snapshot_delete_args ();
extern bool_t xdr_remote_domain_open_console_args ();
extern bool_t xdr_remote_domain_open_channel_args ();
extern bool_t xdr_remote_storage_vol_upload_args ();
extern bool_t xdr_remote_storage_vol_download_args ();
extern bool_t xdr_remote_domain_get_state_args ();
extern bool_t xdr_remote_domain_get_state_ret ();
extern bool_t xdr_remote_domain_migrate_begin3_args ();
extern bool_t xdr_remote_domain_migrate_begin3_ret ();
extern bool_t xdr_remote_domain_migrate_prepare3_args ();
extern bool_t xdr_remote_domain_migrate_prepare3_ret ();
extern bool_t xdr_remote_domain_migrate_prepare_tunnel3_args ();
extern bool_t xdr_remote_domain_migrate_prepare_tunnel3_ret ();
extern bool_t xdr_remote_domain_migrate_perform3_args ();
extern bool_t xdr_remote_domain_migrate_perform3_ret ();
extern bool_t xdr_remote_domain_migrate_finish3_args ();
extern bool_t xdr_remote_domain_migrate_finish3_ret ();
extern bool_t xdr_remote_domain_migrate_confirm3_args ();
extern bool_t xdr_remote_domain_event_control_error_msg ();
extern bool_t xdr_remote_domain_get_control_info_args ();
extern bool_t xdr_remote_domain_get_control_info_ret ();
extern bool_t xdr_remote_domain_open_graphics_args ();
extern bool_t xdr_remote_node_suspend_for_duration_args ();
extern bool_t xdr_remote_domain_shutdown_flags_args ();
extern bool_t xdr_remote_domain_get_disk_errors_args ();
extern bool_t xdr_remote_domain_get_disk_errors_ret ();
extern bool_t xdr_remote_connect_list_all_domains_args ();
extern bool_t xdr_remote_connect_list_all_domains_ret ();
extern bool_t xdr_remote_connect_list_all_storage_pools_args ();
extern bool_t xdr_remote_connect_list_all_storage_pools_ret ();
extern bool_t xdr_remote_storage_pool_list_all_volumes_args ();
extern bool_t xdr_remote_storage_pool_list_all_volumes_ret ();
extern bool_t xdr_remote_connect_list_all_networks_args ();
extern bool_t xdr_remote_connect_list_all_networks_ret ();
extern bool_t xdr_remote_connect_list_all_interfaces_args ();
extern bool_t xdr_remote_connect_list_all_interfaces_ret ();
extern bool_t xdr_remote_connect_list_all_node_devices_args ();
extern bool_t xdr_remote_connect_list_all_node_devices_ret ();
extern bool_t xdr_remote_connect_list_all_nwfilters_args ();
extern bool_t xdr_remote_connect_list_all_nwfilters_ret ();
extern bool_t xdr_remote_connect_list_all_secrets_args ();
extern bool_t xdr_remote_connect_list_all_secrets_ret ();
extern bool_t xdr_remote_node_set_memory_parameters_args ();
extern bool_t xdr_remote_node_get_memory_parameters_args ();
extern bool_t xdr_remote_node_get_memory_parameters_ret ();
extern bool_t xdr_remote_node_get_cpu_map_args ();
extern bool_t xdr_remote_node_get_cpu_map_ret ();
extern bool_t xdr_remote_domain_fstrim_args ();
extern bool_t xdr_remote_procedure ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_REMOTE_PROTOCOL_H_RPCGEN */
