/* Automatically generated by gendispatch.pl.
 * Do not edit this file.  Any changes you make will be lost.
 */
static int qemuDispatchDomainAgentCommand(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    qemu_domain_agent_command_args *args,
    qemu_domain_agent_command_ret *ret);
static int qemuDispatchDomainAgentCommandHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p", server, client, msg, rerr, args, ret);
  return qemuDispatchDomainAgentCommand(server, client, msg, rerr, args, ret);
}
static int qemuDispatchDomainAgentCommand(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    qemu_domain_agent_command_args *args,
    qemu_domain_agent_command_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    char *result = NULL;
    char **result_p = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if (!(dom = get_nonnull_domain(priv->conn, args->dom)))
        goto cleanup;

    if ((result = virDomainQemuAgentCommand(dom, args->cmd, args->timeout, args->flags)) == NULL)
        goto cleanup;

    if (VIR_ALLOC(result_p) < 0) {
        virReportOOMError();
        goto cleanup;
    }
    
    *result_p = strdup(result);
    if (*result_p == NULL) {
        virReportOOMError();
        goto cleanup;
    }

    ret->result = result_p;
    rv = 0;

cleanup:
    if (rv < 0) {
        virNetMessageSaveError(rerr);
        VIR_FREE(result_p);
    }
    if (dom)
        virDomainFree(dom);
    VIR_FREE(result);
    return rv;
}



static int qemuDispatchDomainAttach(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    qemu_domain_attach_args *args,
    qemu_domain_attach_ret *ret);
static int qemuDispatchDomainAttachHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p", server, client, msg, rerr, args, ret);
  return qemuDispatchDomainAttach(server, client, msg, rerr, args, ret);
}
static int qemuDispatchDomainAttach(
    virNetServerPtr server ATTRIBUTE_UNUSED,
    virNetServerClientPtr client,
    virNetMessagePtr msg ATTRIBUTE_UNUSED,
    virNetMessageErrorPtr rerr,
    qemu_domain_attach_args *args,
    qemu_domain_attach_ret *ret)
{
    int rv = -1;
    virDomainPtr dom = NULL;
    struct daemonClientPrivate *priv =
        virNetServerClientGetPrivateData(client);

    if (!priv->conn) {
        virReportError(VIR_ERR_INTERNAL_ERROR, "%s", _("connection not open"));
        goto cleanup;
    }

    if ((dom = virDomainQemuAttach(priv->conn, args->pid_value, args->flags)) == NULL)
        goto cleanup;

    make_nonnull_domain(&ret->dom, dom);
    rv = 0;

cleanup:
    if (rv < 0)
        virNetMessageSaveError(rerr);
    if (dom)
        virDomainFree(dom);
    return rv;
}



static int qemuDispatchDomainMonitorCommand(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    qemu_domain_monitor_command_args *args,
    qemu_domain_monitor_command_ret *ret);
static int qemuDispatchDomainMonitorCommandHelper(
    virNetServerPtr server,
    virNetServerClientPtr client,
    virNetMessagePtr msg,
    virNetMessageErrorPtr rerr,
    void *args,
    void *ret)
{
  VIR_DEBUG("server=%p client=%p msg=%p rerr=%p args=%p ret=%p", server, client, msg, rerr, args, ret);
  return qemuDispatchDomainMonitorCommand(server, client, msg, rerr, args, ret);
}
/* qemuDispatchDomainMonitorCommand body has to be implemented manually */



virNetServerProgramProc qemuProcs[] = {
{ /* Unused 0 */
   NULL,
   0,
   (xdrproc_t)xdr_void,
   0,
   (xdrproc_t)xdr_void,
   true,
   0
},
{ /* Method DomainMonitorCommand => 1 */
   qemuDispatchDomainMonitorCommandHelper,
   sizeof(qemu_domain_monitor_command_args),
   (xdrproc_t)xdr_qemu_domain_monitor_command_args,
   sizeof(qemu_domain_monitor_command_ret),
   (xdrproc_t)xdr_qemu_domain_monitor_command_ret,
   true,
   0
},
{ /* Method DomainAttach => 2 */
   qemuDispatchDomainAttachHelper,
   sizeof(qemu_domain_attach_args),
   (xdrproc_t)xdr_qemu_domain_attach_args,
   sizeof(qemu_domain_attach_ret),
   (xdrproc_t)xdr_qemu_domain_attach_ret,
   true,
   0
},
{ /* Method DomainAgentCommand => 3 */
   qemuDispatchDomainAgentCommandHelper,
   sizeof(qemu_domain_agent_command_args),
   (xdrproc_t)xdr_qemu_domain_agent_command_args,
   sizeof(qemu_domain_agent_command_ret),
   (xdrproc_t)xdr_qemu_domain_agent_command_ret,
   true,
   0
},
};
size_t qemuNProcs = ARRAY_CARDINALITY(qemuProcs);
