/*
 * Copyright (C) 2010 Red Hat, Inc.
 * Copyright IBM Corp. 2009
 *
 * phyp_driver.c: ssh layer to access Power Hypervisors
 *
 * Authors:
 *  Eduardo Otubo <otubo at linux.vnet.ibm.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef PHYP_DRIVER_H
# define PHYP_DRIVER_H

# include "conf/capabilities.h"
# include "conf/domain_conf.h"
# include <config.h>
# include <libssh2.h>

# define LPAR_EXEC_ERR -1
# define SSH_CONN_ERR -2         /* error while trying to connect to remote host */
# define SSH_CMD_ERR -3          /* error while trying to execute the remote cmd */

typedef struct _ConnectionData ConnectionData;
typedef ConnectionData *ConnectionDataPtr;
struct _ConnectionData {
    LIBSSH2_SESSION *session;
    int sock;
};

/* This is the lpar (domain) struct that relates
 * the ID with UUID generated by the API
 * */
typedef struct _lpar lpar_t;
typedef lpar_t *lparPtr;
struct _lpar {
    unsigned char uuid[VIR_UUID_BUFLEN];
    int id;
};

/* Struct that holds how many lpars (domains) we're
 * handling and a pointer to an array of lpar structs
 * */
typedef struct _uuid_table uuid_table_t;
typedef uuid_table_t *uuid_tablePtr;
struct _uuid_table {
    int nlpars;
    lparPtr *lpars;
};

/* This is the main structure of the driver
 * */
typedef struct _phyp_driver phyp_driver_t;
typedef phyp_driver_t *phyp_driverPtr;
struct _phyp_driver {
    uuid_tablePtr uuid_table;
    virCapsPtr caps;
    virDomainXMLOptionPtr xmlopt;
    int vios_id;

    /* system_type:
     * 0 = hmc
     * 127 = ivm
     * */
    int system_type;
    char *managed_system;
};

int phypRegister(void);

#endif /* PHYP_DRIVER_H */
