/* libwpd
 * Copyright (C) 2002, 2005 William Lachance (william.lachance@sympatico.ca)
 * Copyright (C) 2002, 2004 Marc Maurer (j.m.maurer@student.utwente.nl)
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */
#include "libwpd_internal.h"
#include "WPXStream.h"

uint8_t readU8(WPXInputStream *input)
{
	size_t numBytesRead;
	uint8_t const * p = input->read(sizeof(uint8_t), numBytesRead);
	
  	if (numBytesRead != sizeof(uint8_t))
  		throw FileException();

	return WPD_LE_GET_GUINT8(p);
}

int8_t read8(WPXInputStream *input)
{
	size_t numBytesRead;
	int8_t const * p = (int8_t const *) input->read(sizeof(int8_t), numBytesRead);

  	if (numBytesRead != sizeof(int8_t))
  		throw FileException();

	return (int8_t)*(p);
}

uint16_t readU16(WPXInputStream *input, bool bigendian)
{
	size_t numBytesRead;
	uint16_t const *val = (uint16_t const *)input->read(sizeof(uint16_t), numBytesRead);

	if (numBytesRead != sizeof(uint16_t))
  		throw FileException();

	if (bigendian)
		return WPD_BE_GET_GUINT16(val);
	return WPD_LE_GET_GUINT16(val);
}

uint32_t readU32(WPXInputStream *input, bool bigendian)
{
	size_t numBytesRead;
	uint32_t const *val = (uint32_t const *)input->read(sizeof(uint32_t), numBytesRead);

	if (numBytesRead != sizeof(uint32_t))
  		throw FileException();

	if (bigendian)
		return WPD_BE_GET_GUINT32(val);
	return WPD_LE_GET_GUINT32(val);
}

// the ascii map appears stupid, but we need the const 16-bit data for now
static const uint16_t asciiMap[] =
{
	  0,   1,   2,   3,   4,   5,   6,   7,
	  8,   9,  10,  11,  12,  13,  14,  15,
	 16,  17,  18,  19,  20,  21,  22,  23,
	 24,  25,  26,  27,  28,  29,  30,  31,
	 32,  33,  34,  35,  36,  37,  38,  39,
	 40,  41,  42,  43,  44,  45,  46,  47,
	 48,  49,  50,  51,  52,  53,  54,  55,
	 56,  57,  58,  59,  60,  61,  62,  63,
	 64,  65,  66,  67,  68,  69,  70,  71,
	 72,  73,  74,  75,  76,  77,  78,  79,
	 80,  81,  82,  83,  84,  85,  86,  87,
	 88,  89,  90,  91,  92,  93,  94,  95,
	 96,  97,  98,  99, 100, 101, 102, 103,
	104, 105, 106, 107, 108, 109, 110, 111,
	112, 113, 114, 115, 116, 117, 118, 119,
	120, 121, 122, 123, 124, 125, 126, 127,
	128, 129, 130, 131, 132, 133, 134, 135,
	136, 137, 138, 139, 140, 141, 142, 143,
	144, 145, 146, 147, 148, 149, 150, 151,
	152, 153, 154, 155, 156, 157, 158, 159,
	160, 161, 162, 163, 164, 165, 166, 167,
	168, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 178, 179, 180, 181, 182, 183,
	184, 185, 186, 187, 188, 189, 190, 191,
	192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207,
	208, 209, 210, 211, 212, 213, 214, 215,
	216, 217, 218, 219, 220, 221, 222, 223,
	224, 225, 226, 227, 228, 229, 230, 231,
	232, 233, 234, 235, 236, 237, 238, 239,
	240, 241, 242, 243, 244, 245, 246, 247,
	248, 249, 250, 251, 252, 253, 254, 255,
};

/* WP6 Extended Character -> Unicode (UCS2) Mappings by Ariya Hidayat <ariyahidayat@yahoo.de> for the
   KWord project, licensed under the LGPL */

/* WP6 multinational characters (charset 1) */
static const uint16_t multinationalWP6[] = {
  0x0300, 0x00b7, 0x0303, 0x0302, 0x0335, 0x0338, 0x0301, 0x0308,
  0x0304, 0x0313, 0x0315, 0x02bc, 0x0326, 0x0315, 0x00b0, 0x0307,
  0x030b, 0x0327, 0x0328, 0x030c, 0x0337, 0x0305, 0x0306, 0x00df,
  0x0138, 0x006a, 0x00c1, 0x00e1, 0x00c2, 0x00e2, 0x00c4, 0x00e4,
  0x00c0, 0x00e0, 0x00c5, 0x00e5, 0x00c6, 0x00e6, 0x00c7, 0x00e7,
  0x00c9, 0x00e9, 0x00ca, 0x00ea, 0x00cb, 0x00eb, 0x00c8, 0x00e8,
  0x00cd, 0x00ed, 0x00ce, 0x00ee, 0x00cf, 0x00ef, 0x00cc, 0x00ec,
  0x00d1, 0x00f1, 0x00d3, 0x00f3, 0x00d4, 0x00f4, 0x00d6, 0x00f6,
  0x00d2, 0x00f2, 0x00da, 0x00fa, 0x00db, 0x00fb, 0x00dc, 0x00fc,
  0x00d9, 0x00f9, 0x0178, 0x00ff, 0x00c3, 0x00e3, 0x0110, 0x0111,
  0x00d8, 0x00f8, 0x00d5, 0x00f5, 0x00dd, 0x00fd, 0x00d0, 0x00f0,
  0x00de, 0x00fe, 0x0102, 0x0103, 0x0100, 0x0101, 0x0104, 0x0105,
  0x0106, 0x0107, 0x010c, 0x010d, 0x0108, 0x0109, 0x010a, 0x010b,
  0x010e, 0x010f, 0x011a, 0x011b, 0x0116, 0x0117, 0x0112, 0x0113,
  0x0118, 0x0119, 0x01f4, 0x01f5, 0x011e, 0x011f, 0x01e6, 0x01e7,
  0x0122, 0x0123, 0x011c, 0x011d, 0x0120, 0x0121, 0x0124, 0x0125,
  0x0126, 0x0127, 0x0130, 0x0069, 0x012a, 0x012b, 0x012e, 0x012f,
  0x0128, 0x0129, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137,
  0x0139, 0x013a, 0x013d, 0x013e, 0x013b, 0x013c, 0x013f, 0x0140,
  0x0141, 0x0142, 0x0143, 0x0144, 0x004e, 0x0149, 0x0147, 0x0148,
  0x0145, 0x0146, 0x0150, 0x0151, 0x014c, 0x014d, 0x0152, 0x0153,
  0x0154, 0x0155, 0x0158, 0x0159, 0x0156, 0x0157, 0x015a, 0x015b,
  0x0160, 0x0161, 0x015e, 0x015f, 0x015c, 0x015d, 0x0164, 0x0165,
  0x0162, 0x0163, 0x0166, 0x0167, 0x016c, 0x016d, 0x0170, 0x0171,
  0x016a, 0x016b, 0x0172, 0x0173, 0x016e, 0x016f, 0x0168, 0x0169,
  0x0174, 0x0175, 0x0176, 0x0177, 0x0179, 0x017a, 0x017d, 0x017e,
  0x017b, 0x017c, 0x014a, 0x014b, 0x0044, 0x0064, 0x004c, 0x006c,
  0x004e, 0x006e, 0x0052, 0x0072, 0x0053, 0x0073, 0x0054, 0x0074,
  0x0059, 0x0079, 0x1ef2, 0x1ef3, 0x010e, 0x010f, 0x01a0, 0x01a1,
  0x01af, 0x01b0, 0x0114, 0x0115, 0x012c, 0x012d, 0x0049, 0x0131,
  0x014e, 0x014f
};

/* WP6 phonetic symbol (charset 2) */
static const uint16_t phoneticWP6[] = {
  0x02b9, 0x02ba, 0x02bb, 0x0020, 0x02bd, 0x02bc, 0x0020, 0x02be,
  0x02bf, 0x0310, 0x02d0, 0x02d1, 0x0306, 0x032e, 0x0329, 0x02c8,
  0x02cc, 0x02c9, 0x02ca, 0x02cb, 0x02cd, 0x02ce, 0x02cf, 0x02c6,
  0x02c7, 0x02dc, 0x0325, 0x02da, 0x032d, 0x032c, 0x0323, 0x0308,
  0x0324, 0x031c, 0x031d, 0x031e, 0x031f, 0x0320, 0x0321, 0x0322,
  0x032a, 0x032b, 0x02d2, 0x02d3, 0x0020, 0x0020, 0x005f, 0x2017,
  0x033e, 0x02db, 0x0327, 0x0233, 0x030d, 0x02b0, 0x02b6, 0x0250,
  0x0251, 0x0252, 0x0253, 0x0299, 0x0254, 0x0255, 0x0297, 0x0256,
  0x0257, 0x0258, 0x0259, 0x025a, 0x025b, 0x025c, 0x025d, 0x029a,
  0x025e, 0x025f, 0x0278, 0x0261, 0x0260, 0x0262, 0x029b, 0x0263,
  0x0264, 0x0265, 0x0266, 0x0267, 0x029c, 0x0268, 0x026a, 0x0269,
  0x029d, 0x029e, 0x026b, 0x026c, 0x026d, 0x029f, 0x026e, 0x028e,
  0x026f, 0x0270, 0x0271, 0x0272, 0x0273, 0x0274, 0x0276, 0x0277,
  0x02a0, 0x0279, 0x027a, 0x027b, 0x027c, 0x027d, 0x027e, 0x027f,
  0x0280, 0x0281, 0x0282, 0x0283, 0x0284, 0x0285, 0x0286, 0x0287,
  0x0288, 0x0275, 0x0289, 0x028a, 0x028c, 0x028b, 0x028d, 0x03c7,
  0x028f, 0x0290, 0x0291, 0x0292, 0x0293, 0x0294, 0x0295, 0x0296,
  0x02a1, 0x02a2, 0x0298, 0x02a3, 0x02a4, 0x02a5, 0x02a6, 0x02a7,
  0x02a8
};

/* WP6 box drawing symbol (charset 3) */
static const uint16_t boxdrawingWP6[] = {
  0x2591, 0x2592, 0x2593, 0x2588, 0x258c, 0x2580, 0x2590, 0x2584,
  0x2500, 0x2502, 0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 0x252c,
  0x2524, 0x2534, 0x253c, 0x2550, 0x2551, 0x2554, 0x2557, 0x255d,
  0x255a, 0x2560, 0x2566, 0x2563, 0x2569, 0x256c, 0x2552, 0x2555,
  0x255b, 0x2558, 0x2553, 0x2556, 0x255c, 0x2559, 0x255e, 0x2565,
  0x2561, 0x2568, 0x255f, 0x2564, 0x2562, 0x2567, 0x256b, 0x256a,
  0x2574, 0x2575, 0x2576, 0x2577, 0x2578, 0x2579, 0x257a, 0x257b,
  0x257c, 0x257e, 0x257d, 0x257f, 0x251f, 0x2522, 0x251e, 0x2521,
  0x252e, 0x2532, 0x252d, 0x2531, 0x2527, 0x2526, 0x252a, 0x2529,
  0x2536, 0x253a, 0x2535, 0x2539, 0x2541, 0x2546, 0x253e, 0x2540,
  0x2544, 0x254a, 0x253d, 0x2545, 0x2548, 0x2543, 0x2549, 0x2547
};

/* WP6 typographic symbol (charset 4) */
static const uint16_t typographicWP6[] = {
  0x25cf, 0x25cb, 0x25a0, 0x2022, 0x002a, 0x00b6, 0x00a7, 0x00a1,
  0x00bf, 0x00ab, 0x00bb, 0x00a3, 0x00a5, 0x20a7, 0x0192, 0x00aa,
  0x00ba, 0x00bd, 0x00bc, 0x00a2, 0x00b2, 0x207f, 0x00ae, 0x00a9,
  0x00a4, 0x00be, 0x00b3, 0x201b, 0x2019, 0x2018, 0x201f, 0x201d,
  0x201c, 0x2013, 0x2014, 0x2039, 0x203a, 0x25cb, 0x25a1, 0x2020,
  0x2021, 0x2122, 0x2120, 0x211e, 0x25cf, 0x25e6, 0x25a0, 0x25aa,
  0x25a1, 0x25ab, 0x2012, 0xfb00, 0xfb03, 0xfb04, 0xfb01, 0xfb02,
  0x2026, 0x0024, 0x20a3, 0x20a2, 0x20a0, 0x20a4, 0x201a, 0x201e,
  0x2153, 0x2154, 0x215b, 0x215c, 0x215d, 0x215e, 0x24c2, 0x24c5,
  0x20ac, 0x2105, 0x2106, 0x2030, 0x2116, 0x2014, 0x00b9, 0x2409,
  0x240c, 0x240d, 0x240a, 0x2424, 0x240b, 0x267c, 0x20a9, 0x20a6,
  0x20a8, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020
};

/* WP6 iconic symbol (charset 5) */
static const uint16_t iconicWP6[] = {
  0x2661, 0x2662, 0x2667, 0x2664, 0x2642, 0x2640, 0x263c, 0x263a,
  0x263b, 0x266a, 0x266c, 0x25ac, 0x2302, 0x203c, 0x221a, 0x21a8,
  0x2310, 0x2319, 0x25d8, 0x25d9, 0x21b5, 0x2104, 0x261c, 0x23b5,
  0x2610, 0x2612, 0x2639, 0x266f, 0x266d, 0x266e, 0x260e, 0x231a,
  0x231b, 0x2701, 0x2702, 0x2703, 0x2704, 0x260e, 0x2706, 0x2707,
  0x2708, 0x2709, 0x261b, 0x261e, 0x270c, 0x270d, 0x270e, 0x270f,
  0x2710, 0x2711, 0x2712, 0x2713, 0x2714, 0x2715, 0x2716, 0x2717,
  0x2718, 0x2719, 0x271a, 0x271b, 0x271c, 0x271d, 0x271e, 0x271f,
  0x2720, 0x2721, 0x2722, 0x2723, 0x2724, 0x2725, 0x2726, 0x2727,
  0x2605, 0x2606, 0x272a, 0x272b, 0x272c, 0x272d, 0x272e, 0x272f,
  0x2730, 0x2731, 0x2732, 0x2733, 0x2734, 0x2735, 0x2736, 0x2737,
  0x2738, 0x2739, 0x273a, 0x273b, 0x273c, 0x273d, 0x273e, 0x273f,
  0x2740, 0x2741, 0x2742, 0x2743, 0x2744, 0x2745, 0x2746, 0x2747,
  0x2748, 0x2749, 0x274a, 0x274b, 0x25cf, 0x274d, 0x25a0, 0x274f,
  0x2750, 0x2751, 0x2752, 0x25b2, 0x25bc, 0x25c6, 0x2756, 0x25d7,
  0x2758, 0x2759, 0x275a, 0x275b, 0x275c, 0x275d, 0x275e, 0x2036,
  0x2033, 0x0020, 0x0020, 0x0020, 0x0020, 0x2329, 0x232a, 0x005b,
  0x005d, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x2190, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x21e8, 0x21e6,
  0x2794, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x25d6, 0x0020,
  0x0020, 0x2761, 0x2762, 0x2763, 0x2764, 0x2765, 0x2766, 0x2767,
  0x2663, 0x2666, 0x2665, 0x2660, 0x2780, 0x2781, 0x2782, 0x2783,
  0x2784, 0x2785, 0x2786, 0x2787, 0x2788, 0x2789, 0x2776, 0x2777,
  0x2778, 0x2779, 0x277a, 0x277b, 0x277c, 0x277d, 0x277e, 0x277f,
  0x2780, 0x2781, 0x2782, 0x2783, 0x2784, 0x2785, 0x2786, 0x2787,
  0x2788, 0x2789, 0x278a, 0x278b, 0x278c, 0x278d, 0x278e, 0x278f,
  0x2790, 0x2791, 0x2792, 0x2793, 0x2794, 0x2192, 0x2194, 0x2195,
  0x2798, 0x2799, 0x279a, 0x279b, 0x279c, 0x279d, 0x279e, 0x279f,
  0x27a0, 0x27a1, 0x27a2, 0x27a3, 0x27a4, 0x27a5, 0x27a6, 0x27a7,
  0x27a8, 0x27a9, 0x27aa, 0x27ab, 0x27ac, 0x27ad, 0x27ae, 0x27af,
  0x0020, 0x27b1, 0x27b2, 0x27b3, 0x27b4, 0x27b5, 0x27b6, 0x27b7,
  0x27b8, 0x27b9, 0x27ba, 0x27bb, 0x27bc, 0x27bd, 0x27be
};

/* WP6 math/scientific (charset 6) */
static const uint16_t mathWP6[] = {
  0x2212, 0x00b1, 0x2264, 0x2265, 0x221d, 0x002f, 0x2215, 0x2216,
  0x00f7, 0x2223, 0x27e8, 0x27e9, 0x223c, 0x2248, 0x2261, 0x2208,
  0x2229, 0x2225, 0x2211, 0x221e, 0x00ac, 0x2192, 0x2190, 0x2191,
  0x2193, 0x2194, 0x2195, 0x25b8, 0x25c2, 0x25b4, 0x25be, 0x22c5,
  0x00b7, 0x2218, 0x2219, 0x212b, 0x00b0, 0x00b5, 0x203e, 0x00d7,
  0x222b, 0x220f, 0x2213, 0x2207, 0x2202, 0x2032, 0x2033, 0x2192,
  0x212f, 0x2113, 0x210f, 0x2111, 0x211c, 0x2118, 0x21c4, 0x21c6,
  0x21d2, 0x21d0, 0x21d1, 0x21d3, 0x21d4, 0x21d5, 0x2197, 0x2198,
  0x2196, 0x2199, 0x222a, 0x2282, 0x2283, 0x2286, 0x2287, 0x220d,
  0x2205, 0x2308, 0x2309, 0x230a, 0x230b, 0x226a, 0x226b, 0x2220,
  0x2297, 0x2295, 0x2296, 0x0020, 0x2299, 0x2227, 0x2228, 0x22bb,
  0x22a4, 0x22a5, 0x2312, 0x22a2, 0x22a3, 0x25a1, 0x25a0, 0x25ca,
  0x25c6, 0x27e6, 0x27e7, 0x2260, 0x2262, 0x2235, 0x2234, 0x2237,
  0x222e, 0x2112, 0x212d, 0x2128, 0x2118, 0x20dd, 0x0020, 0x25c7,
  0x22c6, 0x2034, 0x2210, 0x2243, 0x2245, 0x227a, 0x227c, 0x227b,
  0x227d, 0x2203, 0x2200, 0x22d8, 0x22d9, 0x228e, 0x228a, 0x228b,
  0x2293, 0x2294, 0x228f, 0x2291, 0x22e4, 0x2290, 0x2292, 0x22e5,
  0x25b3, 0x25bd, 0x25c3, 0x25b9, 0x22c8, 0x2323, 0x2322, 0x25ef,
  0x219d, 0x21a9, 0x21aa, 0x21a3, 0x21bc, 0x21bd, 0x21c0, 0x21c1,
  0x21cc, 0x21cb, 0x21bf, 0x21be, 0x21c3, 0x21c2, 0x21c9, 0x21c7,
  0x22d3, 0x22d2, 0x22d0, 0x22d1, 0x229a, 0x229b, 0x229d, 0x2127,
  0x2221, 0x2222, 0x25c3, 0x25b9, 0x25b5, 0x25bf, 0x2214, 0x2250,
  0x2252, 0x2253, 0x224e, 0x224d, 0x22a8, 0x0020, 0x226c, 0x0285,
  0x2605, 0x226e, 0x2270, 0x226f, 0x2271, 0x2241, 0x2244, 0x2247,
  0x2249, 0x2280, 0x22e0, 0x2281, 0x22e1, 0x2284, 0x2285, 0x2288,
  0x2289, 0x0020, 0x0020, 0x22e2, 0x22e3, 0x2226, 0x2224, 0x226d,
  0x2204, 0x2209, 0x0020, 0x2130, 0x2131, 0x2102, 0x0020, 0x2115,
  0x211d, 0x225f, 0x22be, 0x220b, 0x22ef, 0x2026, 0x22ee, 0x22f1,
  0x0020, 0x20e1, 0x002b, 0x002d, 0x003d, 0x002a, 0x002f, 0x0020,
  0x0020, 0x210b, 0x2118, 0x2272, 0x2273, 0x0020
};

/* WP6 math/scientific extended (charset 7) */
static const uint16_t mathextWP6[] = {
  0x2320, 0x2321, 0x0020, 0x0020, 0x221a, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x21bc, 0x21bd, 0x0020, 0x296c, 0x296d, 0x296a, 0x296b, 0x0020, 
  0x21c9, 0x21c7, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 
  0x21be, 0x21bf, 0x21c3, 0x21c2, 0x0020, 0x2293, 0x2a05, 0x23a1, 
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020
};

/* WP6 greek (charset 8) */
static const uint16_t greekWP6[] = {
  0x0391, 0x03b1, 0x0392, 0x03b2, 0x0392, 0x03d0, 0x0393, 0x03b3,
  0x0394, 0x03b4, 0x0395, 0x03b5, 0x0396, 0x03b6, 0x0397, 0x03b7,
  0x0398, 0x03b8, 0x0399, 0x03b9, 0x039a, 0x03ba, 0x039b, 0x03bb,
  0x039c, 0x03bc, 0x039d, 0x03bd, 0x039e, 0x03be, 0x039f, 0x03bf,
  0x03a0, 0x03c0, 0x03a1, 0x03c1, 0x03a3, 0x03c3, 0x03a3, 0x03c2,
  0x03a4, 0x03c4, 0x03a5, 0x03c5, 0x03a6, 0x03c6, 0x03a7, 0x03c7,
  0x03a8, 0x03c8, 0x03a9, 0x03c9, 0x0386, 0x03ac, 0x0388, 0x03ad,
  0x0389, 0x03ae, 0x038a, 0x03af, 0x03aa, 0x03ca, 0x038c, 0x03cc,
  0x038e, 0x03cd, 0x03ab, 0x03cb, 0x038f, 0x03ce, 0x03b5, 0x03d1,
  0x03f0, 0x03d6, 0x03f1, 0x03c2, 0x03d2, 0x03d5, 0x03c9, 0x037e,
  0x0387, 0x0374, 0x0375, 0x0384, 0x00a8, 0x0385, 0x1fed, 0x1fef,
  0x1fc0, 0x1fbd, 0x1ffe, 0x037a, 0x1fce, 0x1fde, 0x1fcd, 0x1fdd,
  0x1fcf, 0x1fdf, 0x0384, 0x1fef, 0x1fc0, 0x1fbd, 0x1ffe, 0x1fce,
  0x1fde, 0x1fcd, 0x1fdd, 0x1fcf, 0x1fdf, 0x1f70, 0x1fb6, 0x1fb3,
  0x1fb4, 0x1fb2, 0x1fb7, 0x1f00, 0x1f04, 0x1f02, 0x1f06, 0x1f80,
  0x1f84, 0x1f82, 0x1f86, 0x1f01, 0x1f05, 0x1f03, 0x1f07, 0x1f81,
  0x1f85, 0x1f83, 0x1f87, 0x1f72, 0x1f10, 0x1f14, 0x1f12, 0x1f11,
  0x1f15, 0x1f13, 0x1f74, 0x1fc6, 0x1fc3, 0x1fc4, 0x1fc2, 0x1fc7,
  0x1f20, 0x1f24, 0x1f22, 0x1f26, 0x1f90, 0x1f94, 0x1f92, 0x1f96,
  0x1f21, 0x1f25, 0x1f23, 0x1f27, 0x1f91, 0x1f95, 0x1f93, 0x1f97,
  0x1f76, 0x1fd6, 0x0390, 0x1fd2, 0x1f30, 0x1f34, 0x1f32, 0x1f36,
  0x1f31, 0x1f35, 0x1f33, 0x1f37, 0x1f78, 0x1f40, 0x1f44, 0x1f42,
  0x1f41, 0x1f45, 0x1f43, 0x1fe5, 0x1fe4, 0x1f7a, 0x1fe6, 0x03b0,
  0x1fe2, 0x1f50, 0x1f54, 0x1f52, 0x1f56, 0x1f51, 0x1f55, 0x1f53,
  0x1f57, 0x1f7c, 0x1ff6, 0x1ff3, 0x1ff4, 0x1ff2, 0x1ff7, 0x1f60,
  0x1f64, 0x1f62, 0x1f66, 0x1fa0, 0x1fa4, 0x1fa2, 0x1fa6, 0x1f61,
  0x1f65, 0x1f63, 0x1f67, 0x1fa1, 0x1fa5, 0x1fa3, 0x1fa7, 0x03da,
  0x03dc, 0x03de, 0x03e0
};

/* WP6 hebrew (charset 9) */
static const uint16_t hebrewWP6[] = {
  0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7,
  0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df,
  0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7,
  0x05e8, 0x05e9, 0x05ea, 0x05be, 0x05c0, 0x05c3, 0x05f3, 0x05f4,
  0x05b0, 0x05b1, 0x05b2, 0x05b3, 0x05b4, 0x05b5, 0x05b6, 0x05b7,
  0x05b8, 0x05b9, 0x05b9, 0x05bb, 0x05bc, 0x05bd, 0x05bf, 0x05b7,
  0xfb1e, 0x05f0, 0x05f1, 0x05f2, 0xfb1f, 0x0591, 0x0596, 0x0020,
  0x05a4, 0x059a, 0x059b, 0x05a3, 0x05a5, 0x05a6, 0x05a7, 0x05a2,
  0x0592, 0x0593, 0x0594, 0x0595, 0x0597, 0x0598, 0x0599, 0x05a8,
  0x05f3, 0x05f3, 0x05f4, 0x0020, 0x05a9, 0x05a0, 0x059f, 0x05ab,
  0x05ac, 0x05af, 0x05c4, 0x0020, 0xfb30, 0xfb31, 0x05d1, 0xfb32,
  0xfb33, 0xfb34, 0xfb35, 0xfb4b, 0xfb36, 0x05d7, 0xfb38, 0xfb39,
  0xfb1d, 0xfb3b, 0xfb3a, 0x05da, 0x05da, 0x05da, 0x05da, 0x05da,
  0x05da, 0xfb3c, 0xfb3e, 0xfb40, 0x05d5, 0xfb41, 0xfb44, 0x05e4,
  0xfb46, 0xfb47, 0xfb2b, 0xfb2d, 0xfb2a, 0xfb2c, 0xfb4a, 0x05dc,
  0xfb3c, 0xfb49, 0x20aa
};

/* WP6 cyrillic (charset 10) */
static const uint16_t cyrillicWP6[] = {
  0x0410, 0x0430, 0x0411, 0x0431, 0x0412, 0x0432, 0x0413, 0x0433,
  0x0414, 0x0434, 0x0415, 0x0435, 0x0401, 0x0451, 0x0416, 0x0436,
  0x0417, 0x0437, 0x0418, 0x0438, 0x0419, 0x0439, 0x041a, 0x043a,
  0x041b, 0x043b, 0x041c, 0x043c, 0x041d, 0x043d, 0x041e, 0x043e,
  0x041f, 0x043f, 0x0420, 0x0440, 0x0421, 0x0441, 0x0422, 0x0442,
  0x0423, 0x0443, 0x0424, 0x0444, 0x0425, 0x0445, 0x0426, 0x0446,
  0x0427, 0x0447, 0x0428, 0x0448, 0x0429, 0x0449, 0x042a, 0x044a,
  0x042b, 0x044b, 0x042c, 0x044c, 0x042d, 0x044d, 0x042e, 0x044e,
  0x042f, 0x044f, 0x04d8, 0x04d9, 0x0403, 0x0453, 0x0490, 0x0491,
  0x0492, 0x0493, 0x0402, 0x0452, 0x0404, 0x0454, 0x0404, 0x0454,
  0x0496, 0x0497, 0x0405, 0x0455, 0x0020, 0x0020, 0x0418, 0x0438,
  0x0406, 0x0456, 0x0407, 0x0457, 0x0020, 0x0020, 0x0408, 0x0458,
  0x040c, 0x045c, 0x049a, 0x049b, 0x04c3, 0x04c4, 0x049c, 0x049d,
  0x0409, 0x0459, 0x04a2, 0x04a3, 0x040a, 0x045a, 0x047a, 0x047b,
  0x0460, 0x0461, 0x040b, 0x045b, 0x040e, 0x045e, 0x04ee, 0x04ef,
  0x04ae, 0x04af, 0x04b0, 0x04b1, 0x0194, 0x0263, 0x04b2, 0x04b3,
  0x0425, 0x0445, 0x04ba, 0x04bb, 0x047e, 0x047f, 0x040f, 0x045f,
  0x04b6, 0x04b7, 0x04b8, 0x04b9, 0x0428, 0x0448, 0x0462, 0x0463,
  0x0466, 0x0467, 0x046a, 0x046b, 0x046e, 0x046f, 0x0470, 0x0471,
  0x0472, 0x0473, 0x0474, 0x0475, 0x0410, 0x0430, 0x0415, 0x0435,
  0x0404, 0x0454, 0x0418, 0x0438, 0x0406, 0x0456, 0x0407, 0x0457,
  0x041e, 0x043e, 0x0423, 0x0443, 0x042b, 0x044b, 0x042d, 0x044d,
  0x042e, 0x044e, 0x042f, 0x044f, 0x0410, 0x0430, 0x0400, 0x0450,
  0x0401, 0x0451, 0x040d, 0x045d, 0x041e, 0x043e, 0x0423, 0x0443,
  0x042b, 0x044b, 0x042d, 0x044d, 0x042e, 0x044e, 0x042f, 0x044f,
  0x0301, 0x0300, 0x0308, 0x0306, 0x0326, 0x0328, 0x0304, 0x0020,
  0x201e, 0x201c, 0x10d0, 0x10d1, 0x10d2, 0x10d3, 0x10d4, 0x10d5,
  0x10d6, 0x10f1, 0x10d7, 0x10d8, 0x10d9, 0x10da, 0x10db, 0x10dc,
  0x10f2, 0x10dd, 0x10de, 0x10df, 0x10e0, 0x10e1, 0x10e2, 0x10e3,
  0x10f3, 0x10e4, 0x10e5, 0x10e6, 0x10e7, 0x10e8, 0x10e9, 0x10ea,
  0x10eb, 0x10ec, 0x10ed, 0x10ee, 0x10f4, 0x10ef, 0x10f0, 0x10f5,
  0x10f6, 0x10e3
};

/* WP6 japanese (charset 11) */
static const uint16_t japaneseWP6[] = {
  0xff61, 0xff62, 0xff63, 0xff64, 0xff65, 0xff66, 0xff67, 0xff68,
  0xff69, 0xff6a, 0xff6b, 0xff6c, 0xff6d, 0xff6e, 0xff6f, 0xff70,
  0xff71, 0xff72, 0xff73, 0xff74, 0xff75, 0xff76, 0xff77, 0xff78,
  0xff79, 0xff7a, 0xff7b, 0xff7c, 0xff7d, 0xff7e, 0xff7f, 0xff80,
  0xff81, 0xff82, 0xff83, 0xff84, 0xff85, 0xff86, 0xff87, 0xff88,
  0xff89, 0xff8a, 0xff8b, 0xff8c, 0xff8d, 0xff8e, 0xff8f, 0xff90,
  0xff91, 0xff92, 0xff93, 0xff94, 0xff95, 0xff96, 0xff97, 0xff98,
  0xff99, 0xff9a, 0xff9b, 0xff9c, 0xff9d, 0xff9e, 0xff9f
};

/* WP6 Tibetan (charset 12)
 *
 * WP6TibetanMap.h is generated automatically, so it doesn't make sense
 * to copy it in here every time it's regenerated.
 */

/* WP arabic (charset 13) */
static const uint16_t arabicWP6[] = {
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x064e, 0xfe77, 0x064f, 0xfe79, 0x0650, 0xfe7b,
  0x064b, 0x064c, 0x064c, 0x064d, 0x0652, 0xfe7f, 0x0651, 0xfe7d,
  0xfc60, 0xfcf2, 0xfc61, 0xfcf3, 0xfc62, 0xfcf4, 0x064b, 0xfc5e,
  0xfc5e, 0xfc5f, 0x0653, 0x0670, 0x0654, 0x0020, 0x060c, 0x061b,
  0x061f, 0x066d, 0x066a, 0x00bb, 0x00ab, 0x0029, 0x0028, 0x0661,
  0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 0x0669,
  0x0660, 0x0662, 0x0627, 0xfe8e, 0x0628, 0xfe91, 0xfe92, 0xfe90,
  0x062a, 0xfe97, 0xfe98, 0xfe96, 0x062b, 0xfe9b, 0xfe9c, 0xfe9a,
  0x062c, 0xfe9f, 0xfea0, 0xfe9e, 0x062d, 0xfea3, 0xfea4, 0xfea2,
  0x062e, 0xfea7, 0xfea8, 0xfea6, 0x062f, 0xfeaa, 0x0630, 0xfeac,
  0x0631, 0xfeae, 0x0632, 0xfeaf, 0x0633, 0xfeb3, 0xfeb4, 0xfeb2,
  0x0634, 0xfeb7, 0xfeb8, 0xfeb6, 0x0635, 0xfebb, 0xfebc, 0xfeba,
  0x0636, 0xfebf, 0xfec0, 0xfebe, 0x0637, 0xfec3, 0xfec4, 0xfec2,
  0x0638, 0xfec7, 0xfec8, 0xfec6, 0x0639, 0xfecb, 0xfecc, 0xfeca,
  0x063a, 0xfecf, 0xfed0, 0xfece, 0x0641, 0xfed3, 0xfed4, 0xfed2,
  0x0642, 0xfed7, 0xfed8, 0xfed6, 0x0643, 0xfedb, 0xfedc, 0xfeda,
  0x0644, 0xfedf, 0xfee0, 0xfede, 0x0645, 0xfee3, 0xfee4, 0xfee2,
  0x0646, 0xfee7, 0xfee8, 0xfee6, 0x0647, 0xfeeb, 0xfeec, 0xfeea,
  0x0629, 0xfe94, 0x0648, 0xfeee, 0x064a, 0xfef3, 0xfef4, 0xfef2,
  0x0649, 0xfef3, 0xfef4, 0xfef0, 0x0621, 0x0623, 0xfe84, 0x0625,
  0xfe88, 0x0624, 0xfe86, 0x0626, 0xfe8b, 0xfe8c, 0xfe8a, 0xfd3d,
  0xfd3c, 0x0622, 0xfe82, 0x0671, 0xfb51, 0xfefb, 0xfefc, 0xfef7,
  0xfef8, 0xfef9, 0xfefa, 0x0020, 0xfefc, 0xfef5, 0xfef6, 0x0020,
  0x0020, 0xfdf2, 0x0640, 0x0640
};

/* WP arabic script (charset 14) */
static const uint16_t arabicScriptWP6[] = {
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0615,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0615, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x06d4, 0x0020, 0x0020, 0x00b0, 0x0020, 0x065a, 0x0020,
  0x065a, 0x0659, 0x0020, 0x0020, 0x0654, 0x064c, 0xfc5e, 0x065a,
  0x065a, 0x06f4, 0x06f4, 0x06f5, 0x06f6, 0x06f6, 0x06f7, 0x06f8,
  0x067b, 0xfb54, 0xfb55, 0xfb53, 0x0680, 0xfb5c, 0xfb5d, 0xfb5b,
  0x067e, 0xfb58, 0xfb59, 0xfb57, 0x0679, 0xfb68, 0xfb69, 0xfb67,
  0x067c, 0x067c, 0x067c, 0x067c, 0x067f, 0xfb64, 0xfb65, 0xfb63,
  0x067d, 0x067d, 0x067d, 0x067d, 0x067a, 0xfb60, 0xfb61, 0xfb5f,
  0x0684, 0xfb74, 0xfb75, 0xfb73, 0x0683, 0xfb78, 0xfb79, 0xfb77,
  0x0686, 0xfb7c, 0xfb7d, 0xfb7b, 0x0687, 0xfb80, 0xfb81, 0xfb7f,
  0x0685, 0x0685, 0x0685, 0x0685, 0x0681, 0x0681, 0x0681, 0x0681,
  0x0688, 0xfb89, 0x0689, 0x0689, 0x068c, 0xfb85, 0x068e, 0xfb87,
  0x068a, 0x068a, 0x068d, 0xfb83, 0x0693, 0x0693, 0x0691, 0xfb8d,
  0x0699, 0x0699, 0x0695, 0x0695, 0x0692, 0x0692, 0x0698, 0xfb8b,
  0x0696, 0x0696, 0x075b, 0x075b, 0x069a, 0x069a, 0x069a, 0x069a,
  0x06a0, 0x06a0, 0x06a0, 0x06a0, 0x06a4, 0xfb6c, 0xfb6d, 0xfb6b,
  0x06a6, 0xfb70, 0xfb71, 0xfb6f, 0x06a9, 0xfb90, 0xfb91, 0xfb8f,
  0x0643, 0xfedb, 0xfedc, 0xfeda, 0x06aa, 0x06aa, 0x06aa, 0x06aa,
  0x06af, 0xfb94, 0xfb95, 0xfb93, 0x06af, 0xfb94, 0xfb95, 0xfb93,
  0x06ab, 0x06ab, 0x06ab, 0x06ab, 0x06b1, 0xfb9c, 0xfb9d, 0xfb9b,
  0x06b3, 0xfb98, 0xfb99, 0xfb97, 0x06b5, 0x06b5, 0x06b5, 0x06b5,
  0x0020, 0x0020, 0x06ba, 0x0020, 0x0020, 0xfb9f, 0x06bc, 0x06bc,
  0x06bc, 0x06bc, 0x06bb, 0xfba2, 0xfba3, 0xfba1, 0x06c6, 0xfbda,
  0x0020, 0x0020, 0x06ca, 0x06ca, 0x06c1, 0xfba8, 0xfba9, 0xfba7,
  0x06ce, 0x06ce, 0x06ce, 0x06ce, 0x06d2, 0xfbaf, 0x06d1, 0x06d1,
  0x06d1, 0x06d1, 0x06c0, 0xfba5
};

#include "WP6TibetanMap.h"
#include "WP6FileStructure.h"

int extendedCharacterWP6ToUCS2(uint8_t character,
			    uint8_t characterSet, const uint16_t **chars)
{
	int i;

	if (characterSet == 0)
	{
		// if characterset == 0, we have ascii. note that this is different from the doc. body
		// this is not documented in the file format specifications
		*chars = &asciiMap[character];
		return 1;
	}

	switch (characterSet)
	{
	case WP6_MULTINATIONAL_CHARACTER_SET:
		if (character < WP6_NUM_MULTINATIONAL_CHARACTERS)
			*chars = &multinationalWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;
		
	case WP6_PHONETIC_SYMBOL_CHARACTER_SET:
		if (character < WP6_NUM_PHONETIC_CHARACTERS)
			*chars = &phoneticWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_BOX_DRAWING_CHARACTER_SET:
		if (character < WP6_NUM_BOX_DRAWING_CHARACTERS)
			*chars = &boxdrawingWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_TYPOGRAPHIC_SYMBOL_CHARACTER_SET:
		if (character < WP6_NUM_TYPOGRAPHIC_CHARACTERS)
			*chars = &typographicWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_ICONIC_SYMBOL_CHARACTER_SET:
		if (character < WP6_NUM_ICONIC_CHARACTERS)
			*chars = &iconicWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_MATH_SCIENTIFIC_CHARACTER_SET:
		if (character < WP6_NUM_MATH_SCIENTIFIC_CHARACTERS)
			*chars = &mathWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_MATH_SCIENTIFIC_EXTENDED_CHARACTER_SET:
		if (character < WP6_NUM_MATH_SCIENTIFIC_EXTENDED_CHARACTERS)
			*chars = &mathextWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_GREEK_CHARACTER_SET:
		if (character < WP6_NUM_GREEK_CHARACTERS)
			*chars = &greekWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_HEBREW_CHARACTER_SET:
		if (character < WP6_NUM_HEBREW_CHARACTERS)
			*chars = &hebrewWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_CYRILLIC_CHARACTER_SET:
		if (character < WP6_NUM_CYRILLIC_CHARACTERS)
			*chars = &cyrillicWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_JAPANESE_CHARACTER_SET:
		if (character < WP6_NUM_JAPANESE_CHARACTERS)
			*chars = &japaneseWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_TIBETAN_CHARACTER_SET:
		if (tibetanMap1[character]) {
			for (i = 0; tibetanMap1[character][i]; i++)
				;
			*chars = tibetanMap1[character];
			return i;
		}
		else {
			*chars = &asciiMap[' '];
			return 1;
		}

	case WP6_ARABIC_CHARACTER_SET:
		if (character < WP6_NUM_ARABIC_CHARACTERS)
			*chars = &arabicWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP6_ARABIC_SCRIPT_CHARACTER_SET:
		if (character < WP6_NUM_ARABIC_SCRIPT_CHARACTERS)
			*chars = &arabicScriptWP6[character];
		else
			*chars = &asciiMap[' '];
		return 1;
	}

	// last resort: return whitespace
	*chars = &asciiMap[' '];
	return 1;
}

/* WP5 International 1 (charset 1) */
static const uint16_t international1WP5[] = {
  0x0300, 0x00b7, 0x0303, 0x0302, 0x0335, 0x0338, 0x0301, 0x0308,
  0x0304, 0x0313, 0x0315, 0x02bc, 0x0326, 0x0315, 0x00b0, 0x0307,
  0x030b, 0x0327, 0x0328, 0x030c, 0x0337, 0x0305, 0x0306, 0x00df,
  0x0131, 0x006a, 0x00c1, 0x00e1, 0x00c2, 0x00e2, 0x00c4, 0x00e4,
  0x00c0, 0x00e0, 0x00c5, 0x00e5, 0x00c6, 0x00e6, 0x00c7, 0x00e7,
  0x00c9, 0x00e9, 0x00ca, 0x00ea, 0x00cb, 0x00eb, 0x00c8, 0x00e8,
  0x00cd, 0x00ed, 0x00ce, 0x00ee, 0x00cf, 0x00ef, 0x00cc, 0x00ec,
  0x00d1, 0x00f1, 0x00d3, 0x00f3, 0x00d4, 0x00f4, 0x00d6, 0x00f6,
  0x00d2, 0x00f2, 0x00da, 0x00fa, 0x00db, 0x00fb, 0x00dc, 0x00fc,
  0x00d9, 0x00f9, 0x0178, 0x00ff, 0x00c3, 0x00e3, 0x0110, 0x0111,
  0x00d8, 0x00f8, 0x00d5, 0x00f5, 0x00dd, 0x00fd, 0x00d0, 0x00f0,
  0x00de, 0x00fe, 0x0102, 0x0103, 0x0100, 0x0101, 0x0104, 0x0105,
  0x0106, 0x0107, 0x010c, 0x010d, 0x0108, 0x0109, 0x010a, 0x010b,
  0x010e, 0x010f, 0x011a, 0x011b, 0x0116, 0x0117, 0x0112, 0x0113,
  0x0118, 0x0119, 0x01f4, 0x01f5, 0x011e, 0x011f, 0x01e6, 0x01e7,
  0x0122, 0x0123, 0x011c, 0x011d, 0x0120, 0x0121, 0x0124, 0x0125,
  0x0126, 0x0127, 0x0130, 0x0069, 0x012a, 0x012b, 0x012e, 0x012f,
  0x0128, 0x0129, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137,
  0x0139, 0x013a, 0x013d, 0x013e, 0x013b, 0x013c, 0x013f, 0x0140,
  0x0141, 0x0142, 0x0143, 0x0144, 0x004e, 0x0149, 0x0147, 0x0148,
  0x0145, 0x0146, 0x0150, 0x0151, 0x014c, 0x014d, 0x0152, 0x0153,
  0x0154, 0x0155, 0x0158, 0x0159, 0x0156, 0x0157, 0x015a, 0x015b,
  0x0160, 0x0161, 0x015e, 0x015f, 0x015c, 0x015d, 0x0164, 0x0165,
  0x0162, 0x0163, 0x0166, 0x0167, 0x016c, 0x016d, 0x0170, 0x0171,
  0x016a, 0x016b, 0x0172, 0x0173, 0x016e, 0x016f, 0x0168, 0x0169,
  0x0174, 0x0175, 0x0176, 0x0177, 0x0179, 0x017a, 0x017d, 0x017e,
  0x017b, 0x017c, 0x014a, 0x014b, 0x0044, 0x0064, 0x004c, 0x006c,
  0x004e, 0x006e, 0x0052, 0x0072, 0x0053, 0x0073, 0x0054, 0x0074,
  0x0059, 0x0079, 0x1ef2, 0x1ef3, 0x010e, 0x010f, 0x01a0, 0x01a1,
  0x01af, 0x01b0, 0x0114, 0x0115, 0x012c, 0x012d, 0x0049, 0x0131,
  0x014e, 0x014f
};

/* WP5 International 2 (charset 2) */
static const uint16_t international2WP5[] = {
  0x0323, 0x0324, 0x02da, 0x0325, 0x02bc, 0x032d, 0x2017, 0x005f,
  0x0138, 0x032e, 0x033e, 0x2018, 0x0020, 0x02bd, 0x02db, 0x0327,
  0x0321, 0x0322, 0x030d, 0x2019, 0x0329, 0x0020, 0x0621, 0x02be,
  0x0306, 0x0310, 0x2032, 0x2034
};

/* WP5 Box drawing (charset 3) */
static const uint16_t boxdrawingWP5[] = {
  0x2591, 0x2592, 0x2593, 0x2588, 0x258c, 0x2580, 0x2590, 0x2584,
  0x2500, 0x2502, 0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 0x252c,
  0x2524, 0x2534, 0x253c, 0x2550, 0x2551, 0x2554, 0x2557, 0x255d,
  0x255a, 0x2560, 0x2566, 0x2563, 0x2569, 0x256c, 0x2552, 0x2555,
  0x255b, 0x2558, 0x2553, 0x2556, 0x255c, 0x2559, 0x255e, 0x2565,
  0x2561, 0x2568, 0x255f, 0x2564, 0x2562, 0x2567, 0x256b, 0x256a,
  0x2574, 0x2575, 0x2576, 0x2577, 0x2578, 0x2579, 0x257a, 0x257b,
  0x257c, 0x257e, 0x257d, 0x257f, 0x251f, 0x2522, 0x251e, 0x2521,
  0x252e, 0x2532, 0x252d, 0x2531, 0x2527, 0x2526, 0x252a, 0x2529,
  0x2536, 0x253a, 0x2535, 0x2539, 0x2541, 0x2546, 0x253e, 0x2540,
  0x2544, 0x254a, 0x253d, 0x2545, 0x2548, 0x2543, 0x2549, 0x2547
};

/* WP5 Typographic symbols (charset 4) */
static const uint16_t typographicWP5[] = {
  0x25cf, 0x25cb, 0x25a0, 0x2022, 0x002a, 0x00b6, 0x00a7, 0x00a1,
  0x00bf, 0x00ab, 0x00bb, 0x00a3, 0x00a5, 0x20a7, 0x0192, 0x00aa,
  0x00ba, 0x00bd, 0x00bc, 0x00a2, 0x00b2, 0x207f, 0x00ae, 0x00a9,
  0x00a4, 0x00be, 0x00b3, 0x201b, 0x2019, 0x2018, 0x201f, 0x201d,
  0x201c, 0x2013, 0x2014, 0x2039, 0x203a, 0x25cb, 0x25a1, 0x2020,
  0x2021, 0x2122, 0x2120, 0x211e, 0x25cf, 0x25e6, 0x25a0, 0x25aa,
  0x25a1, 0x25ab, 0x2012, 0xfb00, 0xfb03, 0xfb04, 0xfb01, 0xfb02,
  0x2026, 0x0024, 0x20a3, 0x20a2, 0x20a0, 0x20a4, 0x201a, 0x201e,
  0x2153, 0x2154, 0x215b, 0x215c, 0x215d, 0x215e, 0x24c2, 0x24c5,
  0x24c4, 0x2105, 0x2106, 0x2030, 0x2116, 0x2014, 0x00b9, 0x2409,
  0x240c, 0x240d, 0x240a, 0x2424, 0x240b
};

/* WP5 Iconic symbols (charset 5) */
static const uint16_t iconicWP5[] = {
  0x2665, 0x2666, 0x2663, 0x2660, 0x2642, 0x2640, 0x263c, 0x263a,
  0x263b, 0x266a, 0x266c, 0x25ac, 0x2302, 0x203c, 0x221a, 0x21a8,
  0x2310, 0x2319, 0x25d8, 0x25d9, 0x21b5, 0x261e, 0x261c, 0x2713,
  0x2610, 0x2612, 0x2639, 0x266f, 0x266d, 0x266e, 0x260e, 0x231a,
  0x231b, 0x2104, 0x23b5
};

/* WP5 math/scientific (charset 6) */
static const uint16_t mathWP5[] = {
  0x2212, 0x00b1, 0x2264, 0x2265, 0x221d, 0x002f, 0x2215, 0x2216,
  0x00f7, 0x2223, 0x27e8, 0x27e9, 0x223c, 0x2248, 0x2261, 0x2208,
  0x2229, 0x2225, 0x2211, 0x221e, 0x00ac, 0x2192, 0x2190, 0x2191,
  0x2193, 0x2194, 0x2195, 0x25b8, 0x25c2, 0x25b4, 0x25be, 0x22c5,
  0x00b7, 0x2218, 0x2219, 0x212b, 0x00b0, 0x00b5, 0x203e, 0x00d7,
  0x222b, 0x220f, 0x2213, 0x2207, 0x2202, 0x2032, 0x2033, 0x2192,
  0x212f, 0x2113, 0x210f, 0x2111, 0x211c, 0x2118, 0x21c4, 0x21c6
};

/* WP5 math/scientific extended (charset 7) */
static const uint16_t mathextWP5[] = {
  0x2320, 0x2321, 0x23a5, 0x23bd, 0x221a, 0x0020, 0x2211, 0x220f,
  0x2210, 0x222b, 0x222e, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x23a7, 0x23a8, 0x23a9, 0x23aa, 0x0020, 0x0020, 0x0020,
  0x0020, 0x23ab, 0x23ac, 0x23ad, 0x23aa, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x222a, 0x222b, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x239b, 0x239d, 0x239c, 0x0020, 0x0020, 0x0020, 0x0020, 0x239e,
  0x23a8, 0x239f, 0x0020, 0x0020, 0x0020, 0x0020, 0x23a1, 0x23a3,
  0x23a2, 0x0020, 0x20aa, 0x0020, 0x0020, 0x23a4, 0x23a6, 0x23a5,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x22c3, 0x22c2, 0x228e, 0x2a04, 0x2294, 0x2a06, 0x2227, 0x22c0,
  0x2228, 0x22c1, 0x2297, 0x2a02, 0x2295, 0x2a01, 0x2299, 0x2a00,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x229d, 0x0020, 0x2238, 0x0020,
  0x27e6, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x27e7,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x2393, 0x2a05, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
  0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020
};

/* WP5 greek (charset 8) */
static const uint16_t greekWP5[] = {
  0x0391, 0x03b1, 0x0392, 0x03b2, 0x0392, 0x03d0, 0x0393, 0x03b3,
  0x0394, 0x03b4, 0x0395, 0x03b5, 0x0396, 0x03b6, 0x0397, 0x03b7,
  0x0398, 0x03b8, 0x0399, 0x03b9, 0x039a, 0x03ba, 0x039b, 0x03bb,
  0x039c, 0x03bc, 0x039d, 0x03bd, 0x039e, 0x03be, 0x039f, 0x03bf,
  0x03a0, 0x03c0, 0x03a1, 0x03c1, 0x03a3, 0x03c3, 0x03a3, 0x03c2,
  0x03a4, 0x03c4, 0x03a5, 0x03c5, 0x03a6, 0x03d5, 0x03a7, 0x03c7,
  0x03a8, 0x03c8, 0x03a9, 0x03c9, 0x03ac, 0x03ad, 0x03a5, 0x03af,
  0x03ca, 0x03cc, 0x03cd, 0x03cb, 0x03ce, 0x03b5, 0x03d1, 0x03f0,
  0x03d6, 0x03f1, 0x03d2, 0x03c6, 0x03c9, 0x037e, 0x0387, 0x0384,
  0x00a8, 0x0385, 0x1fed, 0x1fef, 0x1fc0, 0x1fbd, 0x1fbf, 0x1fbe,
  0x1fce, 0x1fde, 0x1fcd, 0x1fdd, 0x1fcf, 0x1fdf, 0x0384, 0x1fef,
  0x1fc0, 0x1fbd, 0x1fbf, 0x1fce, 0x1fde, 0x1fcd, 0x1fdd, 0x1fcf,
  0x1fdf, 0x1f70, 0x1fb6, 0x1fb3, 0x1fb4, 0x1fb7, 0x1f00, 0x1f04,
  0x1f02, 0x1f06, 0x1f80, 0x1f84, 0x1f86, 0x1f01, 0x1f05, 0x1f03,
  0x1f07, 0x1f81, 0x1f85, 0x1f87, 0x1f72, 0x1f10, 0x1f14, 0x1f13,
  0x1f11, 0x1f15, 0x1f13, 0x1f74, 0x1fc6, 0x1fc3, 0x1fc4, 0x1fc2,
  0x1fc7, 0x1f20, 0x1f24, 0x1f22, 0x1f26, 0x1f90, 0x1f94, 0x1f96,
  0x1f21, 0x1f25, 0x1f23, 0x1f27, 0x1f91, 0x1f95, 0x1f97, 0x1f76,
  0x1fd6, 0x0390, 0x1fd2, 0x1f30, 0x1f34, 0x1f32, 0x1f36, 0x1f31,
  0x1f35, 0x1f33, 0x1f37, 0x1f78, 0x1f40, 0x1f44, 0x1f42, 0x1f41,
  0x1f45, 0x1f43, 0x1f7a, 0x1fe6, 0x03b0, 0x1fe3, 0x1f50, 0x1f54,
  0x1f52, 0x1f56, 0x1f51, 0x1f55, 0x1f53, 0x1f57, 0x1f7c, 0x1ff6,
  0x1ff3, 0x1ff4, 0x1ff2, 0x1ff7, 0x1f60, 0x1f64, 0x1f62, 0x1f66,
  0x1fa0, 0x1fa4, 0x1fa6, 0x1f61, 0x1f65, 0x1f63, 0x1f67, 0x1fa1,
  0x1fa5, 0x1fa7, 0x0374, 0x0375, 0x03db, 0x03dd, 0x03d9, 0x03e1,
  0x0386, 0x0388, 0x0389, 0x038a, 0x038c, 0x038e, 0x038f, 0x03aa,
  0x03ab, 0x1fe5
};

/* WP5 Hebrew (charset 9) */
static const uint16_t hebrewWP5[] = {
  0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7,
  0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df,
  0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7,
  0x05e8, 0xfb2a, 0xfb2b, 0x05ea, 0xfb31, 0xfb3b, 0xfb44, 0x05b4,
  0x05b5, 0x05b6, 0x05bb, 0x05b8, 0x05b7, 0x05b0, 0x05b2, 0x05b1,
  0x05b3, 0x05c4, 0x05bc, 0x05a5
};

/* WP5 cyrillic (charset 10) */
static const uint16_t cyrillicWP5[] = {
  0x0410, 0x0430, 0x0411, 0x0431, 0x0412, 0x0432, 0x0413, 0x0433,
  0x0414, 0x0434, 0x0415, 0x0435, 0x0401, 0x0451, 0x0416, 0x0436,
  0x0417, 0x0437, 0x0418, 0x0438, 0x0419, 0x0439, 0x041a, 0x043a,
  0x041b, 0x043b, 0x041c, 0x043c, 0x041d, 0x043d, 0x041e, 0x043e,
  0x041f, 0x043f, 0x0420, 0x0440, 0x0421, 0x0441, 0x0422, 0x0442,
  0x0423, 0x0443, 0x0424, 0x0444, 0x0425, 0x0445, 0x0426, 0x0446,
  0x0427, 0x0447, 0x0428, 0x0448, 0x0429, 0x0449, 0x042a, 0x044a,
  0x042b, 0x044b, 0x042c, 0x044c, 0x042d, 0x044d, 0x042e, 0x044e,
  0x042f, 0x044f, 0x0490, 0x0491, 0x0402, 0x0452, 0x0403, 0x0453,
  0x0404, 0x0454, 0x0405, 0x0455, 0x0406, 0x0456, 0x0407, 0x0457,
  0x0408, 0x0458, 0x0409, 0x0459, 0x040a, 0x045a, 0x040b, 0x045b,
  0x040c, 0x045c, 0x040e, 0x045e, 0x040f, 0x045f, 0x0462, 0x0463,
  0x0472, 0x0473, 0x0474, 0x0475, 0x046a, 0x046b, 0x00a0, 0x00a0,
  0x0428, 0x0448, 0x00a0, 0x00a0, 0x0466, 0x0467, 0x0410, 0x0430,
  0x0415, 0x0435, 0x0418, 0x0458, 0x041e, 0x043e, 0x0423, 0x0443,
  0x042b, 0x044b, 0x042d, 0x044d, 0x042e, 0x044e, 0x042f, 0x044f,
  0x0410, 0x0430, 0x0400, 0x0450, 0x0401, 0x0451, 0x040d, 0x045d,
  0x041e, 0x043e, 0x0423, 0x0443, 0x042b, 0x044b, 0x042d, 0x044d,
  0x042e, 0x044e, 0x042f, 0x044f, 0x00b4, 0x0060
};

/* WP5 Japanese (charset 11) */
static const uint16_t japaneseWP5[] = {
  0x3041, 0x3043, 0x3045, 0x3047, 0x3049, 0x3053, 0x3083, 0x3085,
  0x3087, 0x3094, 0x3095, 0x3096, 0x3042, 0x3044, 0x3046, 0x3048,
  0x304a, 0x304b, 0x304d, 0x3047, 0x3051, 0x3053, 0x304c, 0x304e,
  0x3050, 0x3052, 0x3054, 0x3055, 0x3057, 0x3059, 0x305b, 0x305d,
  0x3056, 0x3058, 0x305a, 0x305c, 0x305e, 0x305f, 0x3051, 0x3064,
  0x3066, 0x3068, 0x3060, 0x3062, 0x3065, 0x3067, 0x3069, 0x306a,
  0x306b, 0x306c, 0x306d, 0x306e, 0x306f, 0x3072, 0x3075, 0x3078,
  0x307b, 0x3070, 0x3073, 0x3076, 0x3079, 0x307c, 0x3071, 0x3074,
  0x3077, 0x307a, 0x307d, 0x307e, 0x307f, 0x3080, 0x3081, 0x3082,
  0x3084, 0x3086, 0x3088, 0x3089, 0x308a, 0x308b, 0x308c, 0x308d,
  0x308e, 0x3092, 0x3093, 0x3014, 0x3015, 0xff3b, 0xff3d, 0x300c,
  0x300d, 0x300c, 0x300d, 0x302a, 0x3002, 0x3001, 0x309d, 0x309e,
  0x3003, 0x30fc, 0x309b, 0x309c, 0x30a1, 0x30a3, 0x30a5, 0x30a7,
  0x30a9, 0x30c3, 0x30e3, 0x30e5, 0x3057, 0x30f4, 0x30f5, 0x30f6,
  0x30a2, 0x30a4, 0x30a6, 0x30a8, 0x30aa, 0x30ab, 0x30ad, 0x30af,
  0x30b1, 0x30b3, 0x30ac, 0x30ae, 0x30b0, 0x30b2, 0x30b4, 0x30b5,
  0x30c4, 0x30b9, 0x30bb, 0x30bd, 0x30b6, 0x30b8, 0x30ba, 0x30bc,
  0x30be, 0x30bf, 0x30c1, 0x30c4, 0x30c6, 0x30c8, 0x30c0, 0x30c2,
  0x30c5, 0x30c7, 0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce,
  0x30cf, 0x30d2, 0x30d5, 0x30d8, 0x03d0, 0x30db, 0x30d3, 0x30d6,
  0x30d9, 0x30dc, 0x30d1, 0x30d4, 0x30d7, 0x30da, 0x30dd, 0x30de,
  0x30df, 0x30e0, 0x30e1, 0x30e2, 0x30e4, 0x30e6, 0x30e8, 0x30e9,
  0x30ea, 0x30ab, 0x30ec, 0x30ed, 0x30ef, 0x30f2, 0x30f3, 0x30fd,
  0x30fe
};

#include "WP5FileStructure.h"

int extendedCharacterWP5ToUCS2(uint8_t character,
			    uint8_t characterSet, const uint16_t **chars)
{
	if (characterSet == 0)
	{
		// if characterset == 0, we have ascii. note that this is different from the doc. body
		// this is not documented in the file format specifications
		*chars = &asciiMap[character];
		return 1;
	}

	switch (characterSet)
	{
	case WP5_INTERNATIONAL_1_CHARACTER_SET:
		if (character < WP5_NUM_INTERNATIONAL_1_CHARACTERS)
			*chars = &international1WP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_INTERNATIONAL_2_CHARACTER_SET:
		if (character < WP5_NUM_INTERNATIONAL_2_CHARACTERS)
			*chars = &international2WP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_BOX_DRAWING_CHARACTER_SET:
		if (character < WP5_NUM_BOX_DRAWING_CHARACTERS)
			*chars = &boxdrawingWP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_TYPOGRAPHIC_SYMBOL_CHARACTER_SET:
		if (character < WP5_NUM_TYPOGRAPHIC_CHARACTERS)
			*chars = &typographicWP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_ICONIC_SYMBOL_CHARACTER_SET:
		if (character < WP5_NUM_ICONIC_CHARACTERS)
			*chars = &iconicWP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_MATH_SCIENTIFIC_CHARACTER_SET:
		if (character < WP5_NUM_MATH_SCIENTIFIC_CHARACTERS)
			*chars = &mathWP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_MATH_SCIENTIFIC_EXTENDED_CHARACTER_SET:
		if (character < WP5_NUM_MATH_SCIENTIFIC_EXTENDED_CHARACTERS)
			*chars = &mathextWP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_GREEK_CHARACTER_SET:
		if (character < WP5_NUM_GREEK_CHARACTERS)
			*chars = &greekWP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_HEBREW_CHARACTER_SET:
		if (character < WP5_NUM_HEBREW_CHARACTERS)
			*chars = &hebrewWP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;

	case WP5_CYRILLIC_CHARACTER_SET:
		if (character < WP5_NUM_CYRILLIC_CHARACTERS)
			*chars = &cyrillicWP5[character];
			return 1;

	case WP5_JAPANESE_CHARACTER_SET:
		if (character < WP5_NUM_JAPANESE_CHARACTERS)
			*chars = &japaneseWP5[character];
		else
			*chars = &asciiMap[' '];
		return 1;
	}

	// last resort: return whitespace
	*chars = &asciiMap[' '];
	return 1;
}


_RGBSColor::_RGBSColor(uint8_t r, uint8_t g, uint8_t b, uint8_t s)
	:	m_r(r),
		m_g(g),
		m_b(b),
		m_s(s)
{
}

_RGBSColor::_RGBSColor()
	:	m_r(0),
		m_g(0),
		m_b(0),
		m_s(0)
{
}

_WPXTabStop::_WPXTabStop(float position, WPXTabAlignment alignment, uint16_t leaderCharacter, uint8_t leaderNumSpaces)
	:	m_position(position),
		m_alignment(alignment),
		m_leaderCharacter(leaderCharacter),
		m_leaderNumSpaces(leaderNumSpaces)
{
}

_WPXTabStop::_WPXTabStop()
	:	m_position(0.0f),
		m_alignment(LEFT),
		m_leaderCharacter('\0'),
		m_leaderNumSpaces(0)
{
}

_WPXColumnDefinition::_WPXColumnDefinition()
	:	m_width(0.0f),
		m_leftGutter(0.0f),
		m_rightGutter(0.0f)
{
}
