/*
 * testapi.c: libxml2 API tester program.
 *
 * Automatically generated by gentest.py from libxml2-api.xml
 *
 * See Copyright for the status of this software.
 *
 * daniel@veillard.com
 */

#ifdef HAVE_CONFIG_H
#include "libxml.h"
#else
#include <stdio.h>
#endif

#include <stdlib.h> /* for putenv() */
#include <string.h>
#include <libxml/xmlerror.h>
#include <libxml/relaxng.h>

#if defined(_WIN32) && !defined(__CYGWIN__)
#define snprintf _snprintf
#endif

static int testlibxml2(void);
static int test_module(const char *module);

static int generic_errors = 0;
static int call_tests = 0;
static int function_tests = 0;

static xmlChar chartab[1024];
static int inttab[1024];
static unsigned long longtab[1024];

static xmlDocPtr api_doc = NULL;
static xmlDtdPtr api_dtd = NULL;
static xmlNodePtr api_root = NULL;
static xmlAttrPtr api_attr = NULL;
static xmlNsPtr api_ns = NULL;

static void
structured_errors(void *userData ATTRIBUTE_UNUSED,
                  xmlErrorPtr error ATTRIBUTE_UNUSED) {
    generic_errors++;
}

static void
free_api_doc(void) {
    xmlFreeDoc(api_doc);
    api_doc = NULL;
    api_dtd = NULL;
    api_root = NULL;
    api_attr = NULL;
    api_ns = NULL;
}

static xmlDocPtr
get_api_doc(void) {
    if (api_doc == NULL) {
        api_doc = xmlReadMemory("<!DOCTYPE root [<!ELEMENT root EMPTY>]><root xmlns:h='http://example.com/' h:foo='bar'/>", 88, "root_test", NULL, 0);
	api_root = NULL;
	api_attr = NULL;
    }
    return(api_doc);
}

static xmlDtdPtr
get_api_dtd(void) {
    if ((api_dtd == NULL) || (api_dtd->type != XML_DTD_NODE)) {
        get_api_doc();
	if ((api_doc != NULL) && (api_doc->children != NULL) &&
	    (api_doc->children->type == XML_DTD_NODE))
	    api_dtd = (xmlDtdPtr) api_doc->children;
    }
    return(api_dtd);
}

static xmlNodePtr
get_api_root(void) {
    if ((api_root == NULL) || (api_root->type != XML_ELEMENT_NODE)) {
        get_api_doc();
	if ((api_doc != NULL) && (api_doc->children != NULL) &&
	    (api_doc->children->next != NULL) &&
	    (api_doc->children->next->type == XML_ELEMENT_NODE))
	    api_root = api_doc->children->next;
    }
    return(api_root);
}

static xmlNsPtr
get_api_ns(void) {
    get_api_root();
    if (api_root != NULL)
        api_ns = api_root->nsDef;
    return(api_ns);
}

static xmlAttrPtr
get_api_attr(void) {
#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_HTML_ENABLED)
    static int nr = 0;
    xmlChar name[20];
#endif

    if ((api_root == NULL) || (api_root->type != XML_ELEMENT_NODE)) {
        get_api_root();
    }
    if (api_root == NULL) 
        return(NULL);
    if (api_root->properties != NULL) {
        api_attr = api_root->properties;
        return(api_root->properties);
    }
    api_attr = NULL;
#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_HTML_ENABLED)
    snprintf((char *) name, 20, "foo%d", nr++);
    api_attr = xmlSetProp(api_root, name, (const xmlChar *) "bar");
#endif
    return(api_attr);
}

static int quiet = 0;

int main(int argc, char **argv) {
    int ret;
    int blocks, mem;

    /* access to the proxy can slow up regression tests a lot */
    putenv((char *) "http_proxy=");

    memset(chartab, 0, sizeof(chartab));
    strncpy((char *) chartab, "  chartab\n", 20);
    memset(inttab, 0, sizeof(inttab));
    memset(longtab, 0, sizeof(longtab));

    xmlInitParser();
#ifdef LIBXML_SCHEMAS_ENABLED
    xmlRelaxNGInitTypes();
#endif

    LIBXML_TEST_VERSION

    xmlSetStructuredErrorFunc(NULL, structured_errors);

    if (argc >= 2) {
        if (!strcmp(argv[1], "-q")) {
	    quiet = 1;
	    if (argc >= 3)
	        ret = test_module(argv[2]);
	    else
		ret = testlibxml2();
        } else {
	   ret = test_module(argv[1]);
	}
    } else
	ret = testlibxml2();

    xmlCleanupParser();
    blocks = xmlMemBlocks();
    mem = xmlMemUsed();
    if ((blocks != 0) || (mem != 0)) {
        printf("testapi leaked %d bytes in %d blocks\n", mem, blocks);
    }
    xmlMemoryDump();

    return (ret != 0);
}

#include <libxml/HTMLparser.h>
#include <libxml/HTMLtree.h>
#include <libxml/catalog.h>
#include <libxml/chvalid.h>
#include <libxml/dict.h>
#include <libxml/encoding.h>
#include <libxml/entities.h>
#include <libxml/hash.h>
#include <libxml/list.h>
#include <libxml/nanoftp.h>
#include <libxml/nanohttp.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/pattern.h>
#include <libxml/relaxng.h>
#include <libxml/schemasInternals.h>
#include <libxml/schematron.h>
#include <libxml/tree.h>
#include <libxml/uri.h>
#include <libxml/valid.h>
#include <libxml/xinclude.h>
#include <libxml/xmlIO.h>
#include <libxml/xmlerror.h>
#include <libxml/xmlreader.h>
#include <libxml/xmlsave.h>
#include <libxml/xmlschemas.h>
#include <libxml/xmlschemastypes.h>
#include <libxml/xmlstring.h>
#include <libxml/xmlwriter.h>
#include <libxml/xpath.h>
#include <libxml/xpointer.h>
#include <libxml/debugXML.h>

/* 
  We manually define xmlErrMemory because it's normal declaration
  is "hidden" by #ifdef IN_LIBXML
*/
void xmlErrMemory(xmlParserCtxtPtr ctxt, const char *extra);

/*
 We need some "remote" addresses, but want to avoid getting into
 name resolution delays, so we use these
*/
#define	REMOTE1GOOD	"http://localhost/"
#define	REMOTE1BAD	"http:http://http"
#define	REMOTE2GOOD	"ftp://localhost/foo"

#define gen_nb_void_ptr 2

static void *gen_void_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_void_ptr(int no ATTRIBUTE_UNUSED, void *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#if 0
#define gen_nb_const_void_ptr 2

static const void *gen_const_void_ptr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return((const void *) "immutable string");
    return(NULL);
}
static void des_const_void_ptr(int no ATTRIBUTE_UNUSED, const void *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#define gen_nb_userdata 3

static void *gen_userdata(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return((void *) &call_tests);
    if (no == 1) return((void *) -1);
    return(NULL);
}
static void des_userdata(int no ATTRIBUTE_UNUSED, void *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}


#define gen_nb_int 4

static int gen_int(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(0);
    if (no == 1) return(1);
    if (no == 2) return(-1);
    if (no == 3) return(122);
    return(-1);
}

static void des_int(int no ATTRIBUTE_UNUSED, int val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_parseroptions 5

static int gen_parseroptions(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(XML_PARSE_NOBLANKS | XML_PARSE_RECOVER);
    if (no == 1) return(XML_PARSE_NOENT | XML_PARSE_DTDLOAD | XML_PARSE_DTDATTR | XML_PARSE_DTDVALID | XML_PARSE_NOCDATA);
    if (no == 2) return(XML_PARSE_XINCLUDE | XML_PARSE_NOXINCNODE | XML_PARSE_NSCLEAN);
    if (no == 3) return(XML_PARSE_XINCLUDE | XML_PARSE_NODICT);
    return(XML_PARSE_SAX1);
}

static void des_parseroptions(int no ATTRIBUTE_UNUSED, int val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#if 0
#define gen_nb_long 5

static long gen_long(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(0);
    if (no == 1) return(1);
    if (no == 2) return(-1);
    if (no == 3) return(122);
    return(-1);
}

static void des_long(int no ATTRIBUTE_UNUSED, long val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#define gen_nb_xmlChar 4

static xmlChar gen_xmlChar(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return('a');
    if (no == 1) return(' ');
    if (no == 2) return((xmlChar) '');
    return(0);
}

static void des_xmlChar(int no ATTRIBUTE_UNUSED, xmlChar val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_unsigned_int 3

static unsigned int gen_unsigned_int(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(0);
    if (no == 1) return(1);
    if (no == 2) return(122);
    return((unsigned int) -1);
}

static void des_unsigned_int(int no ATTRIBUTE_UNUSED, unsigned int val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_unsigned_long 4

static unsigned long gen_unsigned_long(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(0);
    if (no == 1) return(1);
    if (no == 2) return(122);
    return((unsigned long) -1);
}

static void des_unsigned_long(int no ATTRIBUTE_UNUSED, unsigned long val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_double 4

static double gen_double(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(0);
    if (no == 1) return(-1.1);
#if defined(LIBXML_XPATH_ENABLED)
    if (no == 2) return(xmlXPathNAN);
#endif
    return(-1);
}

static void des_double(int no ATTRIBUTE_UNUSED, double val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_unsigned_long_ptr 2

static unsigned long *gen_unsigned_long_ptr(int no, int nr) {
    if (no == 0) return(&longtab[nr]);
    return(NULL);
}

static void des_unsigned_long_ptr(int no ATTRIBUTE_UNUSED, unsigned long *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_int_ptr 2

static int *gen_int_ptr(int no, int nr) {
    if (no == 0) return(&inttab[nr]);
    return(NULL);
}

static void des_int_ptr(int no ATTRIBUTE_UNUSED, int *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_const_char_ptr 4

static char *gen_const_char_ptr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return((char *) "foo");
    if (no == 1) return((char *) "<foo/>");
    if (no == 2) return((char *) "test/ent2");
    return(NULL);
}
static void des_const_char_ptr(int no ATTRIBUTE_UNUSED, const char *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlChar_ptr 2

static xmlChar *gen_xmlChar_ptr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(&chartab[0]);
    return(NULL);
}
static void des_xmlChar_ptr(int no ATTRIBUTE_UNUSED, xmlChar *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_FILE_ptr 2

static FILE *gen_FILE_ptr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(fopen("test.out", "a+"));
    return(NULL);
}
static void des_FILE_ptr(int no ATTRIBUTE_UNUSED, FILE *val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) fclose(val);
}

#define gen_nb_debug_FILE_ptr 2
static FILE *gen_debug_FILE_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(fopen("test.out", "a+"));
}
static void des_debug_FILE_ptr(int no ATTRIBUTE_UNUSED, FILE *val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) fclose(val);
}

#define gen_nb_const_xmlChar_ptr 5

static xmlChar *gen_const_xmlChar_ptr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return((xmlChar *) "foo");
    if (no == 1) return((xmlChar *) "<foo/>");
    if (no == 2) return((xmlChar *) "nne");
    if (no == 3) return((xmlChar *) " 2ab ");
    return(NULL);
}
static void des_const_xmlChar_ptr(int no ATTRIBUTE_UNUSED, const xmlChar *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_filepath 8

static const char *gen_filepath(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return("missing.xml");
    if (no == 1) return("<foo/>");
    if (no == 2) return("test/ent2");
    if (no == 3) return("test/valid/REC-xml-19980210.xml");
    if (no == 4) return("test/valid/dtds/xhtml1-strict.dtd");
    if (no == 5) return(REMOTE1GOOD);
    if (no == 6) return(REMOTE1BAD);
    return(NULL);
}
static void des_filepath(int no ATTRIBUTE_UNUSED, const char *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_eaten_name 2

static xmlChar *gen_eaten_name(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlStrdup(BAD_CAST "eaten"));
    return(NULL);
}
static void des_eaten_name(int no ATTRIBUTE_UNUSED, xmlChar *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_fileoutput 6

static const char *gen_fileoutput(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return("/missing.xml");
    if (no == 1) return("<foo/>");
    if (no == 2) return(REMOTE2GOOD);
    if (no == 3) return(REMOTE1GOOD);
    if (no == 4) return(REMOTE1BAD);
    return(NULL);
}
static void des_fileoutput(int no ATTRIBUTE_UNUSED, const char *val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlParserCtxtPtr 3
static xmlParserCtxtPtr gen_xmlParserCtxtPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNewParserCtxt());
    if (no == 1) return(xmlCreateMemoryParserCtxt("<doc/>", 6));
    return(NULL);
}
static void des_xmlParserCtxtPtr(int no ATTRIBUTE_UNUSED, xmlParserCtxtPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL)
        xmlFreeParserCtxt(val);
}

#define gen_nb_xmlSAXHandlerPtr 2
static xmlSAXHandlerPtr gen_xmlSAXHandlerPtr(int no, int nr ATTRIBUTE_UNUSED) {
#ifdef LIBXML_SAX1_ENABLED
    if (no == 0) return((xmlSAXHandlerPtr) &xmlDefaultSAXHandler);
#endif
    return(NULL);
}
static void des_xmlSAXHandlerPtr(int no ATTRIBUTE_UNUSED, xmlSAXHandlerPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlValidCtxtPtr 2
static xmlValidCtxtPtr gen_xmlValidCtxtPtr(int no, int nr ATTRIBUTE_UNUSED) {
#ifdef LIBXML_VALID_ENABLED
    if (no == 0) return(xmlNewValidCtxt());
#endif
    return(NULL);
}
static void des_xmlValidCtxtPtr(int no ATTRIBUTE_UNUSED, xmlValidCtxtPtr val, int nr ATTRIBUTE_UNUSED) {
#ifdef LIBXML_VALID_ENABLED
    if (val != NULL)
        xmlFreeValidCtxt(val);
#endif
}

#define gen_nb_xmlParserInputBufferPtr 8

static xmlParserInputBufferPtr gen_xmlParserInputBufferPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlParserInputBufferCreateFilename("missing.xml", XML_CHAR_ENCODING_NONE));
    if (no == 1) return(xmlParserInputBufferCreateFilename("<foo/>", XML_CHAR_ENCODING_NONE));
    if (no == 2) return(xmlParserInputBufferCreateFilename("test/ent2", XML_CHAR_ENCODING_NONE));
    if (no == 3) return(xmlParserInputBufferCreateFilename("test/valid/REC-xml-19980210.xml", XML_CHAR_ENCODING_NONE));
    if (no == 4) return(xmlParserInputBufferCreateFilename("test/valid/dtds/xhtml1-strict.dtd", XML_CHAR_ENCODING_NONE));
    if (no == 5) return(xmlParserInputBufferCreateFilename(REMOTE1GOOD, XML_CHAR_ENCODING_NONE));
    if (no == 6) return(xmlParserInputBufferCreateFilename(REMOTE1BAD, XML_CHAR_ENCODING_NONE));
    return(NULL);
}
static void des_xmlParserInputBufferPtr(int no ATTRIBUTE_UNUSED, xmlParserInputBufferPtr val, int nr ATTRIBUTE_UNUSED) {
    xmlFreeParserInputBuffer(val);
}

#define gen_nb_xmlDocPtr 4
static xmlDocPtr gen_xmlDocPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNewDoc(BAD_CAST "1.0"));
    if (no == 1) return(xmlReadMemory("<foo/>", 6, "test", NULL, 0));
    if (no == 2) return(xmlReadMemory("<!DOCTYPE foo []> <foo/>", 24, "test", NULL, 0));
    return(NULL);
}
static void des_xmlDocPtr(int no ATTRIBUTE_UNUSED, xmlDocPtr val, int nr ATTRIBUTE_UNUSED) {
    if ((val != NULL) && (val != api_doc) && (val->doc != api_doc))
        xmlFreeDoc(val);
}

#define gen_nb_xmlAttrPtr 2
static xmlAttrPtr gen_xmlAttrPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(get_api_attr());
    return(NULL);
}
static void des_xmlAttrPtr(int no, xmlAttrPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) free_api_doc();
}

#define gen_nb_xmlDictPtr 2
static xmlDictPtr gen_xmlDictPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlDictCreate());
    return(NULL);
}
static void des_xmlDictPtr(int no ATTRIBUTE_UNUSED, xmlDictPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL)
        xmlDictFree(val);
}

#define gen_nb_xmlNodePtr 3
static xmlNodePtr gen_xmlNodePtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNewPI(BAD_CAST "test", NULL));
    if (no == 1) return(get_api_root());
    return(NULL);
/*     if (no == 2) return((xmlNodePtr) get_api_doc()); */
}
static void des_xmlNodePtr(int no, xmlNodePtr val, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) {
        free_api_doc();
    } else if (val != NULL) {
        xmlUnlinkNode(val);
        xmlFreeNode(val);
    }
}

#define gen_nb_xmlDtdPtr 3
static xmlDtdPtr gen_xmlDtdPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) 
        return(xmlNewDtd(NULL, BAD_CAST "dtd", BAD_CAST"foo", BAD_CAST"bar"));
    if (no == 1) return(get_api_dtd());
    return(NULL);
}
static void des_xmlDtdPtr(int no, xmlDtdPtr val, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) free_api_doc();
    else if (val != NULL) {
        xmlUnlinkNode((xmlNodePtr) val);
        xmlFreeNode((xmlNodePtr) val);
    }
}

#define gen_nb_xmlNsPtr 2
static xmlNsPtr gen_xmlNsPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(get_api_ns());
    return(NULL);
}
static void des_xmlNsPtr(int no, xmlNsPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) free_api_doc();
}

#define gen_nb_xmlNodePtr_in 3
static xmlNodePtr gen_xmlNodePtr_in(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNewPI(BAD_CAST "test", NULL));
    if (no == 0) return(xmlNewText(BAD_CAST "text"));
    return(NULL);
}
static void des_xmlNodePtr_in(int no ATTRIBUTE_UNUSED, xmlNodePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#ifdef LIBXML_WRITER_ENABLED
#define gen_nb_xmlTextWriterPtr 2
static xmlTextWriterPtr gen_xmlTextWriterPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNewTextWriterFilename("test.out", 0));
    return(NULL);
}
static void des_xmlTextWriterPtr(int no ATTRIBUTE_UNUSED, xmlTextWriterPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) xmlFreeTextWriter(val);
}
#endif

#ifdef LIBXML_READER_ENABLED
#define gen_nb_xmlTextReaderPtr 4
static xmlTextReaderPtr gen_xmlTextReaderPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNewTextReaderFilename("test/ent2"));
    if (no == 1) return(xmlNewTextReaderFilename("test/valid/REC-xml-19980210.xml"));
    if (no == 2) return(xmlNewTextReaderFilename("test/valid/dtds/xhtml1-strict.dtd"));
    return(NULL);
}
static void des_xmlTextReaderPtr(int no ATTRIBUTE_UNUSED, xmlTextReaderPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) xmlFreeTextReader(val);
}
#endif

#define gen_nb_xmlBufferPtr 3
static const xmlChar *static_buf_content = (xmlChar *)"a static buffer";
static xmlBufferPtr gen_xmlBufferPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlBufferCreate());
    if (no == 1) return(xmlBufferCreateStatic((void *)static_buf_content, 13));
    return(NULL);
}
static void des_xmlBufferPtr(int no ATTRIBUTE_UNUSED, xmlBufferPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) {
        xmlBufferFree(val);
    }
}

#define gen_nb_xmlListPtr 2
static xmlListPtr gen_xmlListPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlListCreate(NULL, NULL));
    return(NULL);
}
static void des_xmlListPtr(int no ATTRIBUTE_UNUSED, xmlListPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) {
        xmlListDelete(val);
    }
}

#define gen_nb_xmlHashTablePtr 2
static xmlHashTablePtr gen_xmlHashTablePtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlHashCreate(10));
    return(NULL);
}
static void des_xmlHashTablePtr(int no ATTRIBUTE_UNUSED, xmlHashTablePtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) {
        xmlHashFree(val, NULL);
    }
}

#include <libxml/xpathInternals.h>

#ifdef LIBXML_XPATH_ENABLED
#define gen_nb_xmlXPathObjectPtr 5
static xmlXPathObjectPtr gen_xmlXPathObjectPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlXPathNewString(BAD_CAST "string object"));
    if (no == 1) return(xmlXPathNewFloat(1.1));
    if (no == 2) return(xmlXPathNewBoolean(1));
    if (no == 3) return(xmlXPathNewNodeSet(NULL));
    return(NULL);
}
static void des_xmlXPathObjectPtr(int no ATTRIBUTE_UNUSED, xmlXPathObjectPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) {
        xmlXPathFreeObject(val);
    }
}
#endif

#ifdef LIBXML_OUTPUT_ENABLED
#define gen_nb_xmlOutputBufferPtr 2
static xmlOutputBufferPtr gen_xmlOutputBufferPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlOutputBufferCreateFilename("test.out", NULL, 0));
    return(NULL);
}
static void des_xmlOutputBufferPtr(int no ATTRIBUTE_UNUSED, xmlOutputBufferPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) {
        xmlOutputBufferClose(val);
    }
}
#endif

#ifdef LIBXML_FTP_ENABLED
#define gen_nb_xmlNanoFTPCtxtPtr 4
static void *gen_xmlNanoFTPCtxtPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNanoFTPNewCtxt(REMOTE2GOOD));
    if (no == 1) return(xmlNanoFTPNewCtxt(REMOTE1GOOD));
    if (no == 2) return(xmlNanoFTPNewCtxt("foo"));
    return(NULL);
}
static void des_xmlNanoFTPCtxtPtr(int no ATTRIBUTE_UNUSED, void *val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) {
        xmlNanoFTPFreeCtxt(val);
    }
}
#endif

#ifdef LIBXML_HTTP_ENABLED
#define gen_nb_xmlNanoHTTPCtxtPtr 1
static void *gen_xmlNanoHTTPCtxtPtr(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNanoHTTPOpen(REMOTE1GOOD, NULL));
    if (no == 1) return(xmlNanoHTTPOpen(REMOTE2GOOD, NULL));
    if (no == 2) return(xmlNanoHTTPOpen(REMOTE1BAD, NULL));
    return(NULL);
}
static void des_xmlNanoHTTPCtxtPtr(int no ATTRIBUTE_UNUSED, void *val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL) {
	xmlNanoHTTPClose(val);
    }
}
#endif

#define gen_nb_xmlCharEncoding 4
static xmlCharEncoding gen_xmlCharEncoding(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(XML_CHAR_ENCODING_UTF8);
    if (no == 1) return(XML_CHAR_ENCODING_NONE);
    if (no == 2) return(XML_CHAR_ENCODING_8859_1);
    return(XML_CHAR_ENCODING_ERROR);
}
static void des_xmlCharEncoding(int no ATTRIBUTE_UNUSED, xmlCharEncoding val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)

#define gen_nb_xmlExpCtxtPtr 1
static xmlExpCtxtPtr gen_xmlExpCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlExpCtxtPtr(int no ATTRIBUTE_UNUSED, xmlExpCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlExpNodePtr 1
static xmlExpNodePtr gen_xmlExpNodePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlExpNodePtr(int no ATTRIBUTE_UNUSED, xmlExpNodePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#endif

#if defined(LIBXML_SCHEMAS_ENABLED)
#define gen_nb_xmlSchemaPtr 1
static xmlSchemaPtr gen_xmlSchemaPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaPtr(int no ATTRIBUTE_UNUSED, xmlSchemaPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlSchemaValidCtxtPtr 1
static xmlSchemaValidCtxtPtr gen_xmlSchemaValidCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaValidCtxtPtr(int no ATTRIBUTE_UNUSED, xmlSchemaValidCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#endif /* LIBXML_SCHEMAS_ENABLED */

#define gen_nb_xmlHashDeallocator 2
static void 
test_xmlHashDeallocator(void *payload ATTRIBUTE_UNUSED, xmlChar *name ATTRIBUTE_UNUSED) {
}

static xmlHashDeallocator gen_xmlHashDeallocator(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(test_xmlHashDeallocator);
    return(NULL);
}
static void des_xmlHashDeallocator(int no ATTRIBUTE_UNUSED, xmlHashDeallocator val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}


static void desret_int(int val ATTRIBUTE_UNUSED) {
}
static void desret_xmlChar(xmlChar val ATTRIBUTE_UNUSED) {
}
static void desret_long(long val ATTRIBUTE_UNUSED) {
}
static void desret_unsigned_long(unsigned long val ATTRIBUTE_UNUSED) {
}
static void desret_double(double val ATTRIBUTE_UNUSED) {
}
static void desret_xmlCharEncoding(xmlCharEncoding val ATTRIBUTE_UNUSED) {
}
#if 0
static void desret_const_void_ptr(void *val ATTRIBUTE_UNUSED) {
}
#endif
static void desret_void_ptr(void *val ATTRIBUTE_UNUSED) {
}
static void desret_const_char_ptr(const char *val ATTRIBUTE_UNUSED) {
}
static void desret_const_xmlChar_ptr(const xmlChar *val ATTRIBUTE_UNUSED) {
}
static void desret_xmlChar_ptr(xmlChar *val) {
    if (val != NULL)
	xmlFree(val);
}
static void desret_xmlDocPtr(xmlDocPtr val) {
    if (val != api_doc)
	xmlFreeDoc(val);
}
static void desret_xmlDictPtr(xmlDictPtr val) {
    xmlDictFree(val);
}
#ifdef LIBXML_OUTPUT_ENABLED
static void desret_xmlOutputBufferPtr(xmlOutputBufferPtr val) {
    xmlOutputBufferClose(val);
}
#endif
#ifdef LIBXML_READER_ENABLED
static void desret_xmlTextReaderPtr(xmlTextReaderPtr val) {
    xmlFreeTextReader(val);
}
#endif
static void desret_xmlNodePtr(xmlNodePtr val) {
    if ((val != NULL) && (val != api_root) && (val != (xmlNodePtr) api_doc)) {
	xmlUnlinkNode(val);
	xmlFreeNode(val);
    }
}
static void desret_xmlAttrPtr(xmlAttrPtr val) {
    if (val != NULL) {
	xmlUnlinkNode((xmlNodePtr) val);
	xmlFreeNode((xmlNodePtr) val);
    }
}
static void desret_xmlEntityPtr(xmlEntityPtr val) {
    if (val != NULL) {
	xmlUnlinkNode((xmlNodePtr) val);
	xmlFreeNode((xmlNodePtr) val);
    }
}
static void desret_xmlElementPtr(xmlElementPtr val) {
    if (val != NULL) {
	xmlUnlinkNode((xmlNodePtr) val);
    }
}
static void desret_xmlAttributePtr(xmlAttributePtr val) {
    if (val != NULL) {
	xmlUnlinkNode((xmlNodePtr) val);
    }
}
static void desret_xmlNsPtr(xmlNsPtr val ATTRIBUTE_UNUSED) {
}
static void desret_xmlDtdPtr(xmlDtdPtr val) {
    desret_xmlNodePtr((xmlNodePtr)val);
}
#ifdef LIBXML_XPATH_ENABLED
static void desret_xmlXPathObjectPtr(xmlXPathObjectPtr val) {
    xmlXPathFreeObject(val);
}
static void desret_xmlNodeSetPtr(xmlNodeSetPtr val) {
    xmlXPathFreeNodeSet(val);
}
#endif
static void desret_xmlParserCtxtPtr(xmlParserCtxtPtr val) {
    xmlFreeParserCtxt(val);
}
static void desret_xmlParserInputBufferPtr(xmlParserInputBufferPtr val) {
    xmlFreeParserInputBuffer(val);
}
static void desret_xmlParserInputPtr(xmlParserInputPtr val) {
    xmlFreeInputStream(val);
}
#ifdef LIBXML_WRITER_ENABLED
static void desret_xmlTextWriterPtr(xmlTextWriterPtr val) {
    xmlFreeTextWriter(val);
}
#endif
static void desret_xmlBufferPtr(xmlBufferPtr val) {
    xmlBufferFree(val);
}
#ifdef LIBXML_SCHEMAS_ENABLED
static void desret_xmlSchemaParserCtxtPtr(xmlSchemaParserCtxtPtr val) {
    xmlSchemaFreeParserCtxt(val);
}
static void desret_xmlSchemaTypePtr(xmlSchemaTypePtr val ATTRIBUTE_UNUSED) {
}
static void desret_xmlRelaxNGParserCtxtPtr(xmlRelaxNGParserCtxtPtr val) {
    xmlRelaxNGFreeParserCtxt(val);
}
#endif
#ifdef LIBXML_HTML_ENABLED
static void desret_const_htmlEntityDesc_ptr(const htmlEntityDesc * val ATTRIBUTE_UNUSED) {
}
#endif
#ifdef LIBXML_HTTP_ENABLED
static void desret_xmlNanoHTTPCtxtPtr(void *val) {
    xmlNanoHTTPClose(val);
}
#endif
#ifdef LIBXML_FTP_ENABLED
static void desret_xmlNanoFTPCtxtPtr(void *val) {
    xmlNanoFTPClose(val);
}
#endif
/* cut and pasted from autogenerated to avoid troubles */
#define gen_nb_const_xmlChar_ptr_ptr 1
static xmlChar ** gen_const_xmlChar_ptr_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_xmlChar_ptr_ptr(int no ATTRIBUTE_UNUSED, const xmlChar ** val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_unsigned_char_ptr 1
static unsigned char * gen_unsigned_char_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_unsigned_char_ptr(int no ATTRIBUTE_UNUSED, unsigned char * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_const_unsigned_char_ptr 1
static unsigned char * gen_const_unsigned_char_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_unsigned_char_ptr(int no ATTRIBUTE_UNUSED, const unsigned char * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#ifdef LIBXML_HTML_ENABLED
#define gen_nb_const_htmlNodePtr 1
static htmlNodePtr gen_const_htmlNodePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_htmlNodePtr(int no ATTRIBUTE_UNUSED, const htmlNodePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#ifdef LIBXML_HTML_ENABLED
#define gen_nb_htmlDocPtr 3
static htmlDocPtr gen_htmlDocPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(htmlNewDoc(NULL, NULL));
    if (no == 1) return(htmlReadMemory("<html/>", 7, "test", NULL, 0));
    return(NULL);
}
static void des_htmlDocPtr(int no ATTRIBUTE_UNUSED, htmlDocPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    if ((val != NULL) && (val != api_doc) && (val->doc != api_doc))
        xmlFreeDoc(val);
}
static void desret_htmlDocPtr(htmlDocPtr val) {
    if ((val != NULL) && (val != api_doc) && (val->doc != api_doc))
        xmlFreeDoc(val);
}
#define gen_nb_htmlParserCtxtPtr 3
static htmlParserCtxtPtr gen_htmlParserCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    if (no == 0) return(xmlNewParserCtxt());
    if (no == 1) return(htmlCreateMemoryParserCtxt("<html/>", 7));
    return(NULL);
}
static void des_htmlParserCtxtPtr(int no ATTRIBUTE_UNUSED, htmlParserCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL)
        htmlFreeParserCtxt(val);
}
static void desret_htmlParserCtxtPtr(htmlParserCtxtPtr val) {
    if (val != NULL)
        htmlFreeParserCtxt(val);
}
#endif

#ifdef LIBXML_XPATH_ENABLED
#define gen_nb_xmlNodeSetPtr 1
static xmlNodeSetPtr gen_xmlNodeSetPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlNodeSetPtr(int no ATTRIBUTE_UNUSED, xmlNodeSetPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#ifdef LIBXML_DEBUG_ENABLED
#ifdef LIBXML_XPATH_ENABLED
#define gen_nb_xmlShellCtxtPtr 1
static xmlShellCtxtPtr gen_xmlShellCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlShellCtxtPtr(int no ATTRIBUTE_UNUSED, xmlShellCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif
#endif

#ifdef LIBXML_PATTERN_ENABLED
#define gen_nb_xmlPatternPtr 1
static xmlPatternPtr gen_xmlPatternPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlPatternPtr(int no ATTRIBUTE_UNUSED, xmlPatternPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#define gen_nb_xmlElementContentPtr 1
static xmlElementContentPtr gen_xmlElementContentPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlElementContentPtr(int no ATTRIBUTE_UNUSED, xmlElementContentPtr val, int nr ATTRIBUTE_UNUSED) {
    if (val != NULL)
        xmlFreeElementContent(val);
}
static void desret_xmlElementContentPtr(xmlElementContentPtr val) {
    if (val != NULL)
        xmlFreeElementContent(val);
}

#define gen_nb_xmlParserNodeInfoSeqPtr 1
static xmlParserNodeInfoSeqPtr gen_xmlParserNodeInfoSeqPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlParserNodeInfoSeqPtr(int no ATTRIBUTE_UNUSED, xmlParserNodeInfoSeqPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static void desret_const_xmlParserNodeInfo_ptr(const xmlParserNodeInfo *val ATTRIBUTE_UNUSED) {
}

#define gen_nb_void_ptr_ptr 1
static void ** gen_void_ptr_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_void_ptr_ptr(int no ATTRIBUTE_UNUSED, void ** val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

/************************************************************************
 *									*
 *   WARNING: end of the manually maintained part of the test code	*
 *            do not remove or alter the CUT HERE line			*
 *									*
 ************************************************************************/

/* CUT HERE: everything below that line is generated */
#ifdef LIBXML_HTML_ENABLED
static void desret_htmlStatus(htmlStatus val ATTRIBUTE_UNUSED) {
}

#endif

#define gen_nb_xmlAttributeDefault 4
static xmlAttributeDefault gen_xmlAttributeDefault(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_ATTRIBUTE_FIXED);
    if (no == 2) return(XML_ATTRIBUTE_IMPLIED);
    if (no == 3) return(XML_ATTRIBUTE_NONE);
    if (no == 4) return(XML_ATTRIBUTE_REQUIRED);
    return(0);
}

static void des_xmlAttributeDefault(int no ATTRIBUTE_UNUSED, xmlAttributeDefault val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlAttributeType 4
static xmlAttributeType gen_xmlAttributeType(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_ATTRIBUTE_CDATA);
    if (no == 2) return(XML_ATTRIBUTE_ENTITIES);
    if (no == 3) return(XML_ATTRIBUTE_ENTITY);
    if (no == 4) return(XML_ATTRIBUTE_ENUMERATION);
    return(0);
}

static void des_xmlAttributeType(int no ATTRIBUTE_UNUSED, xmlAttributeType val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlBufferAllocationScheme 4
static xmlBufferAllocationScheme gen_xmlBufferAllocationScheme(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_BUFFER_ALLOC_DOUBLEIT);
    if (no == 2) return(XML_BUFFER_ALLOC_EXACT);
    if (no == 3) return(XML_BUFFER_ALLOC_HYBRID);
    if (no == 4) return(XML_BUFFER_ALLOC_IMMUTABLE);
    return(0);
}

static void des_xmlBufferAllocationScheme(int no ATTRIBUTE_UNUSED, xmlBufferAllocationScheme val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static void desret_xmlBufferAllocationScheme(xmlBufferAllocationScheme val ATTRIBUTE_UNUSED) {
}

#ifdef LIBXML_CATALOG_ENABLED
#define gen_nb_xmlCatalogAllow 4
static xmlCatalogAllow gen_xmlCatalogAllow(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_CATA_ALLOW_ALL);
    if (no == 2) return(XML_CATA_ALLOW_DOCUMENT);
    if (no == 3) return(XML_CATA_ALLOW_GLOBAL);
    if (no == 4) return(XML_CATA_ALLOW_NONE);
    return(0);
}

static void des_xmlCatalogAllow(int no ATTRIBUTE_UNUSED, xmlCatalogAllow val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static void desret_xmlCatalogAllow(xmlCatalogAllow val ATTRIBUTE_UNUSED) {
}

#endif

#ifdef LIBXML_CATALOG_ENABLED
#define gen_nb_xmlCatalogPrefer 3
static xmlCatalogPrefer gen_xmlCatalogPrefer(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_CATA_PREFER_NONE);
    if (no == 2) return(XML_CATA_PREFER_PUBLIC);
    if (no == 3) return(XML_CATA_PREFER_SYSTEM);
    return(0);
}

static void des_xmlCatalogPrefer(int no ATTRIBUTE_UNUSED, xmlCatalogPrefer val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static void desret_xmlCatalogPrefer(xmlCatalogPrefer val ATTRIBUTE_UNUSED) {
}

#endif

#define gen_nb_xmlElementContentType 4
static xmlElementContentType gen_xmlElementContentType(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_ELEMENT_CONTENT_ELEMENT);
    if (no == 2) return(XML_ELEMENT_CONTENT_OR);
    if (no == 3) return(XML_ELEMENT_CONTENT_PCDATA);
    if (no == 4) return(XML_ELEMENT_CONTENT_SEQ);
    return(0);
}

static void des_xmlElementContentType(int no ATTRIBUTE_UNUSED, xmlElementContentType val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlElementTypeVal 4
static xmlElementTypeVal gen_xmlElementTypeVal(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_ELEMENT_TYPE_ANY);
    if (no == 2) return(XML_ELEMENT_TYPE_ELEMENT);
    if (no == 3) return(XML_ELEMENT_TYPE_EMPTY);
    if (no == 4) return(XML_ELEMENT_TYPE_MIXED);
    return(0);
}

static void des_xmlElementTypeVal(int no ATTRIBUTE_UNUSED, xmlElementTypeVal val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_xmlFeature 4
static xmlFeature gen_xmlFeature(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_WITH_AUTOMATA);
    if (no == 2) return(XML_WITH_C14N);
    if (no == 3) return(XML_WITH_CATALOG);
    if (no == 4) return(XML_WITH_DEBUG);
    return(0);
}

static void des_xmlFeature(int no ATTRIBUTE_UNUSED, xmlFeature val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static void desret_xmlParserErrors(xmlParserErrors val ATTRIBUTE_UNUSED) {
}

#ifdef LIBXML_SCHEMAS_ENABLED
#define gen_nb_xmlSchemaValType 4
static xmlSchemaValType gen_xmlSchemaValType(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_SCHEMAS_ANYSIMPLETYPE);
    if (no == 2) return(XML_SCHEMAS_ANYTYPE);
    if (no == 3) return(XML_SCHEMAS_ANYURI);
    if (no == 4) return(XML_SCHEMAS_BASE64BINARY);
    return(0);
}

static void des_xmlSchemaValType(int no ATTRIBUTE_UNUSED, xmlSchemaValType val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static void desret_xmlSchemaValType(xmlSchemaValType val ATTRIBUTE_UNUSED) {
}

#endif

#ifdef LIBXML_SCHEMAS_ENABLED
#define gen_nb_xmlSchemaWhitespaceValueType 4
static xmlSchemaWhitespaceValueType gen_xmlSchemaWhitespaceValueType(int no, int nr ATTRIBUTE_UNUSED) {
    if (no == 1) return(XML_SCHEMA_WHITESPACE_COLLAPSE);
    if (no == 2) return(XML_SCHEMA_WHITESPACE_PRESERVE);
    if (no == 3) return(XML_SCHEMA_WHITESPACE_REPLACE);
    if (no == 4) return(XML_SCHEMA_WHITESPACE_UNKNOWN);
    return(0);
}

static void des_xmlSchemaWhitespaceValueType(int no ATTRIBUTE_UNUSED, xmlSchemaWhitespaceValueType val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#endif

#include <libxml/HTMLparser.h>
#include <libxml/HTMLtree.h>
#include <libxml/SAX2.h>
#include <libxml/c14n.h>
#include <libxml/catalog.h>
#include <libxml/chvalid.h>
#include <libxml/debugXML.h>
#include <libxml/dict.h>
#include <libxml/encoding.h>
#include <libxml/entities.h>
#include <libxml/hash.h>
#include <libxml/list.h>
#include <libxml/nanoftp.h>
#include <libxml/nanohttp.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/pattern.h>
#include <libxml/relaxng.h>
#include <libxml/schemasInternals.h>
#include <libxml/schematron.h>
#include <libxml/tree.h>
#include <libxml/uri.h>
#include <libxml/valid.h>
#include <libxml/xinclude.h>
#include <libxml/xmlIO.h>
#include <libxml/xmlautomata.h>
#include <libxml/xmlerror.h>
#include <libxml/xmlmodule.h>
#include <libxml/xmlreader.h>
#include <libxml/xmlregexp.h>
#include <libxml/xmlsave.h>
#include <libxml/xmlschemas.h>
#include <libxml/xmlschemastypes.h>
#include <libxml/xmlstring.h>
#include <libxml/xmlunicode.h>
#include <libxml/xmlwriter.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>
#include <libxml/xpointer.h>
static int test_HTMLparser(void);
static int test_HTMLtree(void);
static int test_SAX2(void);
static int test_c14n(void);
static int test_catalog(void);
static int test_chvalid(void);
static int test_debugXML(void);
static int test_dict(void);
static int test_encoding(void);
static int test_entities(void);
static int test_hash(void);
static int test_list(void);
static int test_nanoftp(void);
static int test_nanohttp(void);
static int test_parser(void);
static int test_parserInternals(void);
static int test_pattern(void);
static int test_relaxng(void);
static int test_schemasInternals(void);
static int test_schematron(void);
static int test_tree(void);
static int test_uri(void);
static int test_valid(void);
static int test_xinclude(void);
static int test_xmlIO(void);
static int test_xmlautomata(void);
static int test_xmlerror(void);
static int test_xmlmodule(void);
static int test_xmlreader(void);
static int test_xmlregexp(void);
static int test_xmlsave(void);
static int test_xmlschemas(void);
static int test_xmlschemastypes(void);
static int test_xmlstring(void);
static int test_xmlunicode(void);
static int test_xmlwriter(void);
static int test_xpath(void);
static int test_xpathInternals(void);
static int test_xpointer(void);

/**
 * testlibxml2:
 *
 * Main entry point of the tester for the full libxml2 module,
 * it calls all the tester entry point for each module.
 *
 * Returns the number of error found
 */
static int
testlibxml2(void)
{
    int test_ret = 0;

    test_ret += test_HTMLparser();
    test_ret += test_HTMLtree();
    test_ret += test_SAX2();
    test_ret += test_c14n();
    test_ret += test_catalog();
    test_ret += test_chvalid();
    test_ret += test_debugXML();
    test_ret += test_dict();
    test_ret += test_encoding();
    test_ret += test_entities();
    test_ret += test_hash();
    test_ret += test_list();
    test_ret += test_nanoftp();
    test_ret += test_nanohttp();
    test_ret += test_parser();
    test_ret += test_parserInternals();
    test_ret += test_pattern();
    test_ret += test_relaxng();
    test_ret += test_schemasInternals();
    test_ret += test_schematron();
    test_ret += test_tree();
    test_ret += test_uri();
    test_ret += test_valid();
    test_ret += test_xinclude();
    test_ret += test_xmlIO();
    test_ret += test_xmlautomata();
    test_ret += test_xmlerror();
    test_ret += test_xmlmodule();
    test_ret += test_xmlreader();
    test_ret += test_xmlregexp();
    test_ret += test_xmlsave();
    test_ret += test_xmlschemas();
    test_ret += test_xmlschemastypes();
    test_ret += test_xmlstring();
    test_ret += test_xmlunicode();
    test_ret += test_xmlwriter();
    test_ret += test_xpath();
    test_ret += test_xpathInternals();
    test_ret += test_xpointer();

    printf("Total: %d functions, %d tests, %d errors\n",
           function_tests, call_tests, test_ret);
    return(test_ret);
}


static int
test_UTF8ToHtml(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    unsigned char * out; /* a pointer to an array of bytes to store the result */
    int n_out;
    int * outlen; /* the length of @out */
    int n_outlen;
    unsigned char * in; /* a pointer to an array of UTF-8 chars */
    int n_in;
    int * inlen; /* the length of @in */
    int n_inlen;

    for (n_out = 0;n_out < gen_nb_unsigned_char_ptr;n_out++) {
    for (n_outlen = 0;n_outlen < gen_nb_int_ptr;n_outlen++) {
    for (n_in = 0;n_in < gen_nb_const_unsigned_char_ptr;n_in++) {
    for (n_inlen = 0;n_inlen < gen_nb_int_ptr;n_inlen++) {
        mem_base = xmlMemBlocks();
        out = gen_unsigned_char_ptr(n_out, 0);
        outlen = gen_int_ptr(n_outlen, 1);
        in = gen_const_unsigned_char_ptr(n_in, 2);
        inlen = gen_int_ptr(n_inlen, 3);

        ret_val = UTF8ToHtml(out, outlen, (const unsigned char *)in, inlen);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_char_ptr(n_out, out, 0);
        des_int_ptr(n_outlen, outlen, 1);
        des_const_unsigned_char_ptr(n_in, (const unsigned char *)in, 2);
        des_int_ptr(n_inlen, inlen, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in UTF8ToHtml",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_outlen);
            printf(" %d", n_in);
            printf(" %d", n_inlen);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_HTML_ENABLED

#define gen_nb_const_htmlElemDesc_ptr 1
static htmlElemDesc * gen_const_htmlElemDesc_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_htmlElemDesc_ptr(int no ATTRIBUTE_UNUSED, const htmlElemDesc * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_htmlAttrAllowed(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlStatus ret_val;
    htmlElemDesc * elt; /* HTML element */
    int n_elt;
    xmlChar * attr; /* HTML attribute */
    int n_attr;
    int legacy; /* whether to allow deprecated attributes */
    int n_legacy;

    for (n_elt = 0;n_elt < gen_nb_const_htmlElemDesc_ptr;n_elt++) {
    for (n_attr = 0;n_attr < gen_nb_const_xmlChar_ptr;n_attr++) {
    for (n_legacy = 0;n_legacy < gen_nb_int;n_legacy++) {
        mem_base = xmlMemBlocks();
        elt = gen_const_htmlElemDesc_ptr(n_elt, 0);
        attr = gen_const_xmlChar_ptr(n_attr, 1);
        legacy = gen_int(n_legacy, 2);

        ret_val = htmlAttrAllowed((const htmlElemDesc *)elt, (const xmlChar *)attr, legacy);
        desret_htmlStatus(ret_val);
        call_tests++;
        des_const_htmlElemDesc_ptr(n_elt, (const htmlElemDesc *)elt, 0);
        des_const_xmlChar_ptr(n_attr, (const xmlChar *)attr, 1);
        des_int(n_legacy, legacy, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlAttrAllowed",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_elt);
            printf(" %d", n_attr);
            printf(" %d", n_legacy);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_HTML_ENABLED

#define gen_nb_htmlNodePtr 1
static htmlNodePtr gen_htmlNodePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_htmlNodePtr(int no ATTRIBUTE_UNUSED, htmlNodePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_htmlAutoCloseTag(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    htmlDocPtr doc; /* the HTML document */
    int n_doc;
    xmlChar * name; /* The tag name */
    int n_name;
    htmlNodePtr elem; /* the HTML element */
    int n_elem;

    for (n_doc = 0;n_doc < gen_nb_htmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_elem = 0;n_elem < gen_nb_htmlNodePtr;n_elem++) {
        mem_base = xmlMemBlocks();
        doc = gen_htmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        elem = gen_htmlNodePtr(n_elem, 2);

        ret_val = htmlAutoCloseTag(doc, (const xmlChar *)name, elem);
        desret_int(ret_val);
        call_tests++;
        des_htmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_htmlNodePtr(n_elem, elem, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlAutoCloseTag",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlCreateMemoryParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlParserCtxtPtr ret_val;
    char * buffer; /* a pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);

        ret_val = htmlCreateMemoryParserCtxt((const char *)buffer, size);
        desret_htmlParserCtxtPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlCreateMemoryParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_HTML_ENABLED

#define gen_nb_htmlSAXHandlerPtr 1
static htmlSAXHandlerPtr gen_htmlSAXHandlerPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_htmlSAXHandlerPtr(int no ATTRIBUTE_UNUSED, htmlSAXHandlerPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_htmlCreatePushParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_PUSH_ENABLED)
    int mem_base;
    htmlParserCtxtPtr ret_val;
    htmlSAXHandlerPtr sax; /* a SAX handler */
    int n_sax;
    void * user_data; /* The user data returned on SAX callbacks */
    int n_user_data;
    char * chunk; /* a pointer to an array of chars */
    int n_chunk;
    int size; /* number of chars in the array */
    int n_size;
    const char * filename; /* an optional file name or URI */
    int n_filename;
    xmlCharEncoding enc; /* an optional encoding */
    int n_enc;

    for (n_sax = 0;n_sax < gen_nb_htmlSAXHandlerPtr;n_sax++) {
    for (n_user_data = 0;n_user_data < gen_nb_userdata;n_user_data++) {
    for (n_chunk = 0;n_chunk < gen_nb_const_char_ptr;n_chunk++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        sax = gen_htmlSAXHandlerPtr(n_sax, 0);
        user_data = gen_userdata(n_user_data, 1);
        chunk = gen_const_char_ptr(n_chunk, 2);
        size = gen_int(n_size, 3);
        filename = gen_fileoutput(n_filename, 4);
        enc = gen_xmlCharEncoding(n_enc, 5);

        ret_val = htmlCreatePushParserCtxt(sax, user_data, (const char *)chunk, size, filename, enc);
        desret_htmlParserCtxtPtr(ret_val);
        call_tests++;
        des_htmlSAXHandlerPtr(n_sax, sax, 0);
        des_userdata(n_user_data, user_data, 1);
        des_const_char_ptr(n_chunk, (const char *)chunk, 2);
        des_int(n_size, size, 3);
        des_fileoutput(n_filename, filename, 4);
        des_xmlCharEncoding(n_enc, enc, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlCreatePushParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_user_data);
            printf(" %d", n_chunk);
            printf(" %d", n_size);
            printf(" %d", n_filename);
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlCtxtReadDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;
    xmlChar * cur; /* a pointer to a zero terminated string */
    int n_cur;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of htmlParserOption(s) */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);
        cur = gen_const_xmlChar_ptr(n_cur, 1);
        URL = gen_filepath(n_URL, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        options = gen_int(n_options, 4);

        ret_val = htmlCtxtReadDoc(ctxt, (const xmlChar *)cur, URL, (const char *)encoding, options);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 1);
        des_filepath(n_URL, URL, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_int(n_options, options, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlCtxtReadDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_cur);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlCtxtReadFile(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    htmlDocPtr ret_val;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;
    const char * filename; /* a file or URL */
    int n_filename;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of htmlParserOption(s) */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);
        filename = gen_filepath(n_filename, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        options = gen_int(n_options, 3);

        ret_val = htmlCtxtReadFile(ctxt, filename, (const char *)encoding, options);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_filepath(n_filename, filename, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_int(n_options, options, 3);
        xmlResetLastError();
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlCtxtReadMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;
    char * buffer; /* a pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of htmlParserOption(s) */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);
        buffer = gen_const_char_ptr(n_buffer, 1);
        size = gen_int(n_size, 2);
        URL = gen_filepath(n_URL, 3);
        encoding = gen_const_char_ptr(n_encoding, 4);
        options = gen_int(n_options, 5);

        ret_val = htmlCtxtReadMemory(ctxt, (const char *)buffer, size, URL, (const char *)encoding, options);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_char_ptr(n_buffer, (const char *)buffer, 1);
        des_int(n_size, size, 2);
        des_filepath(n_URL, URL, 3);
        des_const_char_ptr(n_encoding, (const char *)encoding, 4);
        des_int(n_options, options, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlCtxtReadMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlCtxtReset(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);

        htmlCtxtReset(ctxt);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlCtxtReset",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlCtxtUseOptions(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;
    int options; /* a combination of htmlParserOption(s) */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);
        options = gen_int(n_options, 1);

        ret_val = htmlCtxtUseOptions(ctxt, options);
        desret_int(ret_val);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_int(n_options, options, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlCtxtUseOptions",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlElementAllowedHere(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    htmlElemDesc * parent; /* HTML parent element */
    int n_parent;
    xmlChar * elt; /* HTML element */
    int n_elt;

    for (n_parent = 0;n_parent < gen_nb_const_htmlElemDesc_ptr;n_parent++) {
    for (n_elt = 0;n_elt < gen_nb_const_xmlChar_ptr;n_elt++) {
        mem_base = xmlMemBlocks();
        parent = gen_const_htmlElemDesc_ptr(n_parent, 0);
        elt = gen_const_xmlChar_ptr(n_elt, 1);

        ret_val = htmlElementAllowedHere((const htmlElemDesc *)parent, (const xmlChar *)elt);
        desret_int(ret_val);
        call_tests++;
        des_const_htmlElemDesc_ptr(n_parent, (const htmlElemDesc *)parent, 0);
        des_const_xmlChar_ptr(n_elt, (const xmlChar *)elt, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlElementAllowedHere",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf(" %d", n_elt);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlElementStatusHere(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlStatus ret_val;
    htmlElemDesc * parent; /* HTML parent element */
    int n_parent;
    htmlElemDesc * elt; /* HTML element */
    int n_elt;

    for (n_parent = 0;n_parent < gen_nb_const_htmlElemDesc_ptr;n_parent++) {
    for (n_elt = 0;n_elt < gen_nb_const_htmlElemDesc_ptr;n_elt++) {
        mem_base = xmlMemBlocks();
        parent = gen_const_htmlElemDesc_ptr(n_parent, 0);
        elt = gen_const_htmlElemDesc_ptr(n_elt, 1);

        ret_val = htmlElementStatusHere((const htmlElemDesc *)parent, (const htmlElemDesc *)elt);
        desret_htmlStatus(ret_val);
        call_tests++;
        des_const_htmlElemDesc_ptr(n_parent, (const htmlElemDesc *)parent, 0);
        des_const_htmlElemDesc_ptr(n_elt, (const htmlElemDesc *)elt, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlElementStatusHere",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf(" %d", n_elt);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlEncodeEntities(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    unsigned char * out; /* a pointer to an array of bytes to store the result */
    int n_out;
    int * outlen; /* the length of @out */
    int n_outlen;
    unsigned char * in; /* a pointer to an array of UTF-8 chars */
    int n_in;
    int * inlen; /* the length of @in */
    int n_inlen;
    int quoteChar; /* the quote character to escape (' or ") or zero. */
    int n_quoteChar;

    for (n_out = 0;n_out < gen_nb_unsigned_char_ptr;n_out++) {
    for (n_outlen = 0;n_outlen < gen_nb_int_ptr;n_outlen++) {
    for (n_in = 0;n_in < gen_nb_const_unsigned_char_ptr;n_in++) {
    for (n_inlen = 0;n_inlen < gen_nb_int_ptr;n_inlen++) {
    for (n_quoteChar = 0;n_quoteChar < gen_nb_int;n_quoteChar++) {
        mem_base = xmlMemBlocks();
        out = gen_unsigned_char_ptr(n_out, 0);
        outlen = gen_int_ptr(n_outlen, 1);
        in = gen_const_unsigned_char_ptr(n_in, 2);
        inlen = gen_int_ptr(n_inlen, 3);
        quoteChar = gen_int(n_quoteChar, 4);

        ret_val = htmlEncodeEntities(out, outlen, (const unsigned char *)in, inlen, quoteChar);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_char_ptr(n_out, out, 0);
        des_int_ptr(n_outlen, outlen, 1);
        des_const_unsigned_char_ptr(n_in, (const unsigned char *)in, 2);
        des_int_ptr(n_inlen, inlen, 3);
        des_int(n_quoteChar, quoteChar, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlEncodeEntities",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_outlen);
            printf(" %d", n_in);
            printf(" %d", n_inlen);
            printf(" %d", n_quoteChar);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlEntityLookup(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    const htmlEntityDesc * ret_val;
    xmlChar * name; /* the entity name */
    int n_name;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);

        ret_val = htmlEntityLookup((const xmlChar *)name);
        desret_const_htmlEntityDesc_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlEntityLookup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlEntityValueLookup(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    const htmlEntityDesc * ret_val;
    unsigned int value; /* the entity's unicode value */
    int n_value;

    for (n_value = 0;n_value < gen_nb_unsigned_int;n_value++) {
        mem_base = xmlMemBlocks();
        value = gen_unsigned_int(n_value, 0);

        ret_val = htmlEntityValueLookup(value);
        desret_const_htmlEntityDesc_ptr(ret_val);
        call_tests++;
        des_unsigned_int(n_value, value, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlEntityValueLookup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlHandleOmittedElem(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    int val; /* int 0 or 1 */
    int n_val;

    for (n_val = 0;n_val < gen_nb_int;n_val++) {
        mem_base = xmlMemBlocks();
        val = gen_int(n_val, 0);

        ret_val = htmlHandleOmittedElem(val);
        desret_int(ret_val);
        call_tests++;
        des_int(n_val, val, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlHandleOmittedElem",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlIsAutoClosed(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    htmlDocPtr doc; /* the HTML document */
    int n_doc;
    htmlNodePtr elem; /* the HTML element */
    int n_elem;

    for (n_doc = 0;n_doc < gen_nb_htmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_htmlNodePtr;n_elem++) {
        mem_base = xmlMemBlocks();
        doc = gen_htmlDocPtr(n_doc, 0);
        elem = gen_htmlNodePtr(n_elem, 1);

        ret_val = htmlIsAutoClosed(doc, elem);
        desret_int(ret_val);
        call_tests++;
        des_htmlDocPtr(n_doc, doc, 0);
        des_htmlNodePtr(n_elem, elem, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlIsAutoClosed",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlIsScriptAttribute(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    xmlChar * name; /* an attribute name */
    int n_name;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);

        ret_val = htmlIsScriptAttribute((const xmlChar *)name);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlIsScriptAttribute",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNewParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlParserCtxtPtr ret_val;

        mem_base = xmlMemBlocks();

        ret_val = htmlNewParserCtxt();
        desret_htmlParserCtxtPtr(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNewParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNodeStatus(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlStatus ret_val;
    htmlNodePtr node; /* an htmlNodePtr in a tree */
    int n_node;
    int legacy; /* whether to allow deprecated elements (YES is faster here for Element nodes) */
    int n_legacy;

    for (n_node = 0;n_node < gen_nb_const_htmlNodePtr;n_node++) {
    for (n_legacy = 0;n_legacy < gen_nb_int;n_legacy++) {
        mem_base = xmlMemBlocks();
        node = gen_const_htmlNodePtr(n_node, 0);
        legacy = gen_int(n_legacy, 1);

        ret_val = htmlNodeStatus((const htmlNodePtr)node, legacy);
        desret_htmlStatus(ret_val);
        call_tests++;
        des_const_htmlNodePtr(n_node, (const htmlNodePtr)node, 0);
        des_int(n_legacy, legacy, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNodeStatus",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_legacy);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlParseCharRef(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);

        ret_val = htmlParseCharRef(ctxt);
        desret_int(ret_val);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlParseCharRef",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlParseChunk(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_PUSH_ENABLED)
    int mem_base;
    int ret_val;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;
    char * chunk; /* an char array */
    int n_chunk;
    int size; /* the size in byte of the chunk */
    int n_size;
    int terminate; /* last chunk indicator */
    int n_terminate;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
    for (n_chunk = 0;n_chunk < gen_nb_const_char_ptr;n_chunk++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_terminate = 0;n_terminate < gen_nb_int;n_terminate++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);
        chunk = gen_const_char_ptr(n_chunk, 1);
        size = gen_int(n_size, 2);
        terminate = gen_int(n_terminate, 3);

        ret_val = htmlParseChunk(ctxt, (const char *)chunk, size, terminate);
        if (ctxt != NULL) {xmlFreeDoc(ctxt->myDoc); ctxt->myDoc = NULL;}
        desret_int(ret_val);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_char_ptr(n_chunk, (const char *)chunk, 1);
        des_int(n_size, size, 2);
        des_int(n_terminate, terminate, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlParseChunk",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_chunk);
            printf(" %d", n_size);
            printf(" %d", n_terminate);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlParseDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    xmlChar * cur; /* a pointer to an array of xmlChar */
    int n_cur;
    char * encoding; /* a free form C string describing the HTML document encoding, or NULL */
    int n_encoding;

    for (n_cur = 0;n_cur < gen_nb_xmlChar_ptr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlChar_ptr(n_cur, 0);
        encoding = gen_const_char_ptr(n_encoding, 1);

        ret_val = htmlParseDoc(cur, (const char *)encoding);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_xmlChar_ptr(n_cur, cur, 0);
        des_const_char_ptr(n_encoding, (const char *)encoding, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlParseDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlParseDocument(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);

        ret_val = htmlParseDocument(ctxt);
        if (ctxt != NULL) {xmlFreeDoc(ctxt->myDoc); ctxt->myDoc = NULL;}
        desret_int(ret_val);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlParseDocument",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlParseElement(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);

        htmlParseElement(ctxt);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlParseElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlParseEntityRef(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    const htmlEntityDesc * ret_val;
    htmlParserCtxtPtr ctxt; /* an HTML parser context */
    int n_ctxt;
    xmlChar ** str; /* location to store the entity name */
    int n_str;

    for (n_ctxt = 0;n_ctxt < gen_nb_htmlParserCtxtPtr;n_ctxt++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_htmlParserCtxtPtr(n_ctxt, 0);
        str = gen_const_xmlChar_ptr_ptr(n_str, 1);

        ret_val = htmlParseEntityRef(ctxt, (const xmlChar **)str);
        desret_const_htmlEntityDesc_ptr(ret_val);
        call_tests++;
        des_htmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr_ptr(n_str, (const xmlChar **)str, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlParseEntityRef",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_str);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlParseFile(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    htmlDocPtr ret_val;
    const char * filename; /* the filename */
    int n_filename;
    char * encoding; /* a free form C string describing the HTML document encoding, or NULL */
    int n_encoding;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        filename = gen_filepath(n_filename, 0);
        encoding = gen_const_char_ptr(n_encoding, 1);

        ret_val = htmlParseFile(filename, (const char *)encoding);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        des_const_char_ptr(n_encoding, (const char *)encoding, 1);
        xmlResetLastError();
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlReadDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    xmlChar * cur; /* a pointer to a zero terminated string */
    int n_cur;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of htmlParserOption(s) */
    int n_options;

    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        cur = gen_const_xmlChar_ptr(n_cur, 0);
        URL = gen_filepath(n_URL, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        options = gen_int(n_options, 3);

        ret_val = htmlReadDoc((const xmlChar *)cur, URL, (const char *)encoding, options);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 0);
        des_filepath(n_URL, URL, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_int(n_options, options, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlReadDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlReadFile(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    const char * filename; /* a file or URL */
    int n_filename;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of htmlParserOption(s) */
    int n_options;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);
        encoding = gen_const_char_ptr(n_encoding, 1);
        options = gen_int(n_options, 2);

        ret_val = htmlReadFile(filename, (const char *)encoding, options);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        des_const_char_ptr(n_encoding, (const char *)encoding, 1);
        des_int(n_options, options, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlReadFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlReadMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    char * buffer; /* a pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of htmlParserOption(s) */
    int n_options;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);
        URL = gen_filepath(n_URL, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        options = gen_int(n_options, 4);

        ret_val = htmlReadMemory((const char *)buffer, size, URL, (const char *)encoding, options);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        des_filepath(n_URL, URL, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_int(n_options, options, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlReadMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlSAXParseDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    xmlChar * cur; /* a pointer to an array of xmlChar */
    int n_cur;
    char * encoding; /* a free form C string describing the HTML document encoding, or NULL */
    int n_encoding;
    htmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    void * userData; /* if using SAX, this pointer will be provided on callbacks. */
    int n_userData;

    for (n_cur = 0;n_cur < gen_nb_xmlChar_ptr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_sax = 0;n_sax < gen_nb_htmlSAXHandlerPtr;n_sax++) {
    for (n_userData = 0;n_userData < gen_nb_userdata;n_userData++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlChar_ptr(n_cur, 0);
        encoding = gen_const_char_ptr(n_encoding, 1);
        sax = gen_htmlSAXHandlerPtr(n_sax, 2);
        userData = gen_userdata(n_userData, 3);

        ret_val = htmlSAXParseDoc(cur, (const char *)encoding, sax, userData);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_xmlChar_ptr(n_cur, cur, 0);
        des_const_char_ptr(n_encoding, (const char *)encoding, 1);
        des_htmlSAXHandlerPtr(n_sax, sax, 2);
        des_userdata(n_userData, userData, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlSAXParseDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf(" %d", n_sax);
            printf(" %d", n_userData);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlSAXParseFile(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    const char * filename; /* the filename */
    int n_filename;
    char * encoding; /* a free form C string describing the HTML document encoding, or NULL */
    int n_encoding;
    htmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    void * userData; /* if using SAX, this pointer will be provided on callbacks. */
    int n_userData;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_sax = 0;n_sax < gen_nb_htmlSAXHandlerPtr;n_sax++) {
    for (n_userData = 0;n_userData < gen_nb_userdata;n_userData++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);
        encoding = gen_const_char_ptr(n_encoding, 1);
        sax = gen_htmlSAXHandlerPtr(n_sax, 2);
        userData = gen_userdata(n_userData, 3);

        ret_val = htmlSAXParseFile(filename, (const char *)encoding, sax, userData);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        des_const_char_ptr(n_encoding, (const char *)encoding, 1);
        des_htmlSAXHandlerPtr(n_sax, sax, 2);
        des_userdata(n_userData, userData, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlSAXParseFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_encoding);
            printf(" %d", n_sax);
            printf(" %d", n_userData);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlTagLookup(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

static int
test_HTMLparser(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing HTMLparser : 32 of 38 functions ...\n");
    test_ret += test_UTF8ToHtml();
    test_ret += test_htmlAttrAllowed();
    test_ret += test_htmlAutoCloseTag();
    test_ret += test_htmlCreateMemoryParserCtxt();
    test_ret += test_htmlCreatePushParserCtxt();
    test_ret += test_htmlCtxtReadDoc();
    test_ret += test_htmlCtxtReadFile();
    test_ret += test_htmlCtxtReadMemory();
    test_ret += test_htmlCtxtReset();
    test_ret += test_htmlCtxtUseOptions();
    test_ret += test_htmlElementAllowedHere();
    test_ret += test_htmlElementStatusHere();
    test_ret += test_htmlEncodeEntities();
    test_ret += test_htmlEntityLookup();
    test_ret += test_htmlEntityValueLookup();
    test_ret += test_htmlHandleOmittedElem();
    test_ret += test_htmlIsAutoClosed();
    test_ret += test_htmlIsScriptAttribute();
    test_ret += test_htmlNewParserCtxt();
    test_ret += test_htmlNodeStatus();
    test_ret += test_htmlParseCharRef();
    test_ret += test_htmlParseChunk();
    test_ret += test_htmlParseDoc();
    test_ret += test_htmlParseDocument();
    test_ret += test_htmlParseElement();
    test_ret += test_htmlParseEntityRef();
    test_ret += test_htmlParseFile();
    test_ret += test_htmlReadDoc();
    test_ret += test_htmlReadFile();
    test_ret += test_htmlReadMemory();
    test_ret += test_htmlSAXParseDoc();
    test_ret += test_htmlSAXParseFile();
    test_ret += test_htmlTagLookup();

    if (test_ret != 0)
	printf("Module HTMLparser: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_htmlDocContentDumpFormatOutput(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr buf; /* the HTML buffer output */
    int n_buf;
    xmlDocPtr cur; /* the document */
    int n_cur;
    char * encoding; /* the encoding string */
    int n_encoding;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_buf = 0;n_buf < gen_nb_xmlOutputBufferPtr;n_buf++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlOutputBufferPtr(n_buf, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        format = gen_int(n_format, 3);

        htmlDocContentDumpFormatOutput(buf, cur, (const char *)encoding, format);
        call_tests++;
        des_xmlOutputBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_int(n_format, format, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlDocContentDumpFormatOutput",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlDocContentDumpOutput(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr buf; /* the HTML buffer output */
    int n_buf;
    xmlDocPtr cur; /* the document */
    int n_cur;
    char * encoding; /* the encoding string */
    int n_encoding;

    for (n_buf = 0;n_buf < gen_nb_xmlOutputBufferPtr;n_buf++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlOutputBufferPtr(n_buf, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);

        htmlDocContentDumpOutput(buf, cur, (const char *)encoding);
        call_tests++;
        des_xmlOutputBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlDocContentDumpOutput",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlDocDump(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    FILE * f; /* the FILE* */
    int n_f;
    xmlDocPtr cur; /* the document */
    int n_cur;

    for (n_f = 0;n_f < gen_nb_FILE_ptr;n_f++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        f = gen_FILE_ptr(n_f, 0);
        cur = gen_xmlDocPtr(n_cur, 1);

        ret_val = htmlDocDump(f, cur);
        desret_int(ret_val);
        call_tests++;
        des_FILE_ptr(n_f, f, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlDocDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_f);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


#define gen_nb_xmlChar_ptr_ptr 1
static xmlChar ** gen_xmlChar_ptr_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlChar_ptr_ptr(int no ATTRIBUTE_UNUSED, xmlChar ** val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_htmlDocDumpMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlDocPtr cur; /* the document */
    int n_cur;
    xmlChar ** mem; /* OUT: the memory pointer */
    int n_mem;
    int * size; /* OUT: the memory length */
    int n_size;

    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_mem = 0;n_mem < gen_nb_xmlChar_ptr_ptr;n_mem++) {
    for (n_size = 0;n_size < gen_nb_int_ptr;n_size++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlDocPtr(n_cur, 0);
        mem = gen_xmlChar_ptr_ptr(n_mem, 1);
        size = gen_int_ptr(n_size, 2);

        htmlDocDumpMemory(cur, mem, size);
        call_tests++;
        des_xmlDocPtr(n_cur, cur, 0);
        des_xmlChar_ptr_ptr(n_mem, mem, 1);
        des_int_ptr(n_size, size, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlDocDumpMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_mem);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlDocDumpMemoryFormat(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlDocPtr cur; /* the document */
    int n_cur;
    xmlChar ** mem; /* OUT: the memory pointer */
    int n_mem;
    int * size; /* OUT: the memory length */
    int n_size;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_mem = 0;n_mem < gen_nb_xmlChar_ptr_ptr;n_mem++) {
    for (n_size = 0;n_size < gen_nb_int_ptr;n_size++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlDocPtr(n_cur, 0);
        mem = gen_xmlChar_ptr_ptr(n_mem, 1);
        size = gen_int_ptr(n_size, 2);
        format = gen_int(n_format, 3);

        htmlDocDumpMemoryFormat(cur, mem, size, format);
        call_tests++;
        des_xmlDocPtr(n_cur, cur, 0);
        des_xmlChar_ptr_ptr(n_mem, mem, 1);
        des_int_ptr(n_size, size, 2);
        des_int(n_format, format, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlDocDumpMemoryFormat",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_mem);
            printf(" %d", n_size);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlGetMetaEncoding(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    htmlDocPtr doc; /* the document */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_htmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_htmlDocPtr(n_doc, 0);

        ret_val = htmlGetMetaEncoding(doc);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_htmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlGetMetaEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlIsBooleanAttr(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    xmlChar * name; /* the name of the attribute to check */
    int n_name;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);

        ret_val = htmlIsBooleanAttr((const xmlChar *)name);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlIsBooleanAttr",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNewDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    xmlChar * URI; /* URI for the dtd, or NULL */
    int n_URI;
    xmlChar * ExternalID; /* the external ID of the DTD, or NULL */
    int n_ExternalID;

    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
        mem_base = xmlMemBlocks();
        URI = gen_const_xmlChar_ptr(n_URI, 0);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 1);

        ret_val = htmlNewDoc((const xmlChar *)URI, (const xmlChar *)ExternalID);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 0);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNewDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URI);
            printf(" %d", n_ExternalID);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNewDocNoDtD(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlDocPtr ret_val;
    xmlChar * URI; /* URI for the dtd, or NULL */
    int n_URI;
    xmlChar * ExternalID; /* the external ID of the DTD, or NULL */
    int n_ExternalID;

    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
        mem_base = xmlMemBlocks();
        URI = gen_const_xmlChar_ptr(n_URI, 0);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 1);

        ret_val = htmlNewDocNoDtD((const xmlChar *)URI, (const xmlChar *)ExternalID);
        desret_htmlDocPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 0);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNewDocNoDtD",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URI);
            printf(" %d", n_ExternalID);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNodeDump(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the HTML buffer output */
    int n_buf;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr cur; /* the current node */
    int n_cur;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        cur = gen_xmlNodePtr(n_cur, 2);

        ret_val = htmlNodeDump(buf, doc, cur);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_cur, cur, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNodeDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNodeDumpFile(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    FILE * out; /* the FILE pointer */
    int n_out;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr cur; /* the current node */
    int n_cur;

    for (n_out = 0;n_out < gen_nb_FILE_ptr;n_out++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
        mem_base = xmlMemBlocks();
        out = gen_FILE_ptr(n_out, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        cur = gen_xmlNodePtr(n_cur, 2);

        htmlNodeDumpFile(out, doc, cur);
        call_tests++;
        des_FILE_ptr(n_out, out, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_cur, cur, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNodeDumpFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNodeDumpFileFormat(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    FILE * out; /* the FILE pointer */
    int n_out;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr cur; /* the current node */
    int n_cur;
    char * encoding; /* the document encoding */
    int n_encoding;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_out = 0;n_out < gen_nb_FILE_ptr;n_out++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        out = gen_FILE_ptr(n_out, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        cur = gen_xmlNodePtr(n_cur, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        format = gen_int(n_format, 4);

        ret_val = htmlNodeDumpFileFormat(out, doc, cur, (const char *)encoding, format);
        desret_int(ret_val);
        call_tests++;
        des_FILE_ptr(n_out, out, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_cur, cur, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_int(n_format, format, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNodeDumpFileFormat",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNodeDumpFormatOutput(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr buf; /* the HTML buffer output */
    int n_buf;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr cur; /* the current node */
    int n_cur;
    char * encoding; /* the encoding string */
    int n_encoding;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_buf = 0;n_buf < gen_nb_xmlOutputBufferPtr;n_buf++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlOutputBufferPtr(n_buf, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        cur = gen_xmlNodePtr(n_cur, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        format = gen_int(n_format, 4);

        htmlNodeDumpFormatOutput(buf, doc, cur, (const char *)encoding, format);
        call_tests++;
        des_xmlOutputBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_cur, cur, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_int(n_format, format, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNodeDumpFormatOutput",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlNodeDumpOutput(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr buf; /* the HTML buffer output */
    int n_buf;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr cur; /* the current node */
    int n_cur;
    char * encoding; /* the encoding string */
    int n_encoding;

    for (n_buf = 0;n_buf < gen_nb_xmlOutputBufferPtr;n_buf++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlOutputBufferPtr(n_buf, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        cur = gen_xmlNodePtr(n_cur, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);

        htmlNodeDumpOutput(buf, doc, cur, (const char *)encoding);
        call_tests++;
        des_xmlOutputBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_cur, cur, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlNodeDumpOutput",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlSaveFile(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the filename (or URL) */
    int n_filename;
    xmlDocPtr cur; /* the document */
    int n_cur;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        cur = gen_xmlDocPtr(n_cur, 1);

        ret_val = htmlSaveFile(filename, cur);
        desret_int(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlSaveFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlSaveFileEnc(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the filename */
    int n_filename;
    xmlDocPtr cur; /* the document */
    int n_cur;
    char * encoding; /* the document encoding */
    int n_encoding;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);

        ret_val = htmlSaveFileEnc(filename, cur, (const char *)encoding);
        desret_int(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlSaveFileEnc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlSaveFileFormat(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the filename */
    int n_filename;
    xmlDocPtr cur; /* the document */
    int n_cur;
    char * encoding; /* the document encoding */
    int n_encoding;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        format = gen_int(n_format, 3);

        ret_val = htmlSaveFileFormat(filename, cur, (const char *)encoding, format);
        desret_int(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_int(n_format, format, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlSaveFileFormat",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlSetMetaEncoding(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    int ret_val;
    htmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * encoding; /* the encoding string */
    int n_encoding;

    for (n_doc = 0;n_doc < gen_nb_htmlDocPtr;n_doc++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_xmlChar_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        doc = gen_htmlDocPtr(n_doc, 0);
        encoding = gen_const_xmlChar_ptr(n_encoding, 1);

        ret_val = htmlSetMetaEncoding(doc, (const xmlChar *)encoding);
        desret_int(ret_val);
        call_tests++;
        des_htmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_encoding, (const xmlChar *)encoding, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlSetMetaEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_HTMLtree(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing HTMLtree : 18 of 18 functions ...\n");
    test_ret += test_htmlDocContentDumpFormatOutput();
    test_ret += test_htmlDocContentDumpOutput();
    test_ret += test_htmlDocDump();
    test_ret += test_htmlDocDumpMemory();
    test_ret += test_htmlDocDumpMemoryFormat();
    test_ret += test_htmlGetMetaEncoding();
    test_ret += test_htmlIsBooleanAttr();
    test_ret += test_htmlNewDoc();
    test_ret += test_htmlNewDocNoDtD();
    test_ret += test_htmlNodeDump();
    test_ret += test_htmlNodeDumpFile();
    test_ret += test_htmlNodeDumpFileFormat();
    test_ret += test_htmlNodeDumpFormatOutput();
    test_ret += test_htmlNodeDumpOutput();
    test_ret += test_htmlSaveFile();
    test_ret += test_htmlSaveFileEnc();
    test_ret += test_htmlSaveFileFormat();
    test_ret += test_htmlSetMetaEncoding();

    if (test_ret != 0)
	printf("Module HTMLtree: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_docbDefaultSAXHandlerInit(void) {
    int test_ret = 0;

#if defined(LIBXML_DOCB_ENABLED)
#ifdef LIBXML_DOCB_ENABLED
    int mem_base;

        mem_base = xmlMemBlocks();

        docbDefaultSAXHandlerInit();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in docbDefaultSAXHandlerInit",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_htmlDefaultSAXHandlerInit(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
#ifdef LIBXML_HTML_ENABLED
    int mem_base;

        mem_base = xmlMemBlocks();

        htmlDefaultSAXHandlerInit();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlDefaultSAXHandlerInit",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlDefaultSAXHandlerInit(void) {
    int test_ret = 0;

    int mem_base;

        mem_base = xmlMemBlocks();

        xmlDefaultSAXHandlerInit();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDefaultSAXHandlerInit",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlEnumerationPtr 1
static xmlEnumerationPtr gen_xmlEnumerationPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlEnumerationPtr(int no ATTRIBUTE_UNUSED, xmlEnumerationPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlSAX2AttributeDecl(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * elem; /* the name of the element */
    int n_elem;
    xmlChar * fullname; /* the attribute name */
    int n_fullname;
    int type; /* the attribute type */
    int n_type;
    int def; /* the type of default value */
    int n_def;
    xmlChar * defaultValue; /* the attribute default value */
    int n_defaultValue;
    xmlEnumerationPtr tree; /* the tree of enumerated value set */
    int n_tree;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_elem = 0;n_elem < gen_nb_const_xmlChar_ptr;n_elem++) {
    for (n_fullname = 0;n_fullname < gen_nb_const_xmlChar_ptr;n_fullname++) {
    for (n_type = 0;n_type < gen_nb_int;n_type++) {
    for (n_def = 0;n_def < gen_nb_int;n_def++) {
    for (n_defaultValue = 0;n_defaultValue < gen_nb_const_xmlChar_ptr;n_defaultValue++) {
    for (n_tree = 0;n_tree < gen_nb_xmlEnumerationPtr;n_tree++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        elem = gen_const_xmlChar_ptr(n_elem, 1);
        fullname = gen_const_xmlChar_ptr(n_fullname, 2);
        type = gen_int(n_type, 3);
        def = gen_int(n_def, 4);
        defaultValue = gen_const_xmlChar_ptr(n_defaultValue, 5);
        tree = gen_xmlEnumerationPtr(n_tree, 6);

        xmlSAX2AttributeDecl(ctx, (const xmlChar *)elem, (const xmlChar *)fullname, type, def, (const xmlChar *)defaultValue, tree);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_elem, (const xmlChar *)elem, 1);
        des_const_xmlChar_ptr(n_fullname, (const xmlChar *)fullname, 2);
        des_int(n_type, type, 3);
        des_int(n_def, def, 4);
        des_const_xmlChar_ptr(n_defaultValue, (const xmlChar *)defaultValue, 5);
        des_xmlEnumerationPtr(n_tree, tree, 6);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2AttributeDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_elem);
            printf(" %d", n_fullname);
            printf(" %d", n_type);
            printf(" %d", n_def);
            printf(" %d", n_defaultValue);
            printf(" %d", n_tree);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2CDataBlock(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * value; /* The pcdata content */
    int n_value;
    int len; /* the block length */
    int n_len;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);
        len = gen_int(n_len, 2);

        xmlSAX2CDataBlock(ctx, (const xmlChar *)value, len);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2CDataBlock",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_value);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2Characters(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * ch; /* a xmlChar string */
    int n_ch;
    int len; /* the number of xmlChar */
    int n_len;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_ch = 0;n_ch < gen_nb_const_xmlChar_ptr;n_ch++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        ch = gen_const_xmlChar_ptr(n_ch, 1);
        len = gen_int(n_len, 2);

        xmlSAX2Characters(ctx, (const xmlChar *)ch, len);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_ch, (const xmlChar *)ch, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2Characters",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_ch);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2Comment(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * value; /* the xmlSAX2Comment content */
    int n_value;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);

        xmlSAX2Comment(ctx, (const xmlChar *)value);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2Comment",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2ElementDecl(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* the element name */
    int n_name;
    int type; /* the element type */
    int n_type;
    xmlElementContentPtr content; /* the element value tree */
    int n_content;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_type = 0;n_type < gen_nb_int;n_type++) {
    for (n_content = 0;n_content < gen_nb_xmlElementContentPtr;n_content++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        type = gen_int(n_type, 2);
        content = gen_xmlElementContentPtr(n_content, 3);

        xmlSAX2ElementDecl(ctx, (const xmlChar *)name, type, content);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_int(n_type, type, 2);
        des_xmlElementContentPtr(n_content, content, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2ElementDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf(" %d", n_type);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2EndDocument(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        xmlSAX2EndDocument(ctx);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2EndDocument",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2EndElement(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED) || defined(LIBXML_HTML_ENABLED) || defined(LIBXML_WRITER_ENABLED) || defined(LIBXML_DOCB_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* The element name */
    int n_name;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        xmlSAX2EndElement(ctx, (const xmlChar *)name);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2EndElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAX2EndElementNs(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * localname; /* the local name of the element */
    int n_localname;
    xmlChar * prefix; /* the element namespace prefix if available */
    int n_prefix;
    xmlChar * URI; /* the element namespace name if available */
    int n_URI;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_localname = 0;n_localname < gen_nb_const_xmlChar_ptr;n_localname++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        localname = gen_const_xmlChar_ptr(n_localname, 1);
        prefix = gen_const_xmlChar_ptr(n_prefix, 2);
        URI = gen_const_xmlChar_ptr(n_URI, 3);

        xmlSAX2EndElementNs(ctx, (const xmlChar *)localname, (const xmlChar *)prefix, (const xmlChar *)URI);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_localname, (const xmlChar *)localname, 1);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 2);
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2EndElementNs",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_localname);
            printf(" %d", n_prefix);
            printf(" %d", n_URI);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2EntityDecl(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* the entity name */
    int n_name;
    int type; /* the entity type */
    int n_type;
    xmlChar * publicId; /* The public ID of the entity */
    int n_publicId;
    xmlChar * systemId; /* The system ID of the entity */
    int n_systemId;
    xmlChar * content; /* the entity value (without processing). */
    int n_content;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_type = 0;n_type < gen_nb_int;n_type++) {
    for (n_publicId = 0;n_publicId < gen_nb_const_xmlChar_ptr;n_publicId++) {
    for (n_systemId = 0;n_systemId < gen_nb_const_xmlChar_ptr;n_systemId++) {
    for (n_content = 0;n_content < gen_nb_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        type = gen_int(n_type, 2);
        publicId = gen_const_xmlChar_ptr(n_publicId, 3);
        systemId = gen_const_xmlChar_ptr(n_systemId, 4);
        content = gen_xmlChar_ptr(n_content, 5);

        xmlSAX2EntityDecl(ctx, (const xmlChar *)name, type, (const xmlChar *)publicId, (const xmlChar *)systemId, content);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_int(n_type, type, 2);
        des_const_xmlChar_ptr(n_publicId, (const xmlChar *)publicId, 3);
        des_const_xmlChar_ptr(n_systemId, (const xmlChar *)systemId, 4);
        des_xmlChar_ptr(n_content, content, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2EntityDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf(" %d", n_type);
            printf(" %d", n_publicId);
            printf(" %d", n_systemId);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2ExternalSubset(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* the root element name */
    int n_name;
    xmlChar * ExternalID; /* the external ID */
    int n_ExternalID;
    xmlChar * SystemID; /* the SYSTEM ID (e.g. filename or URL) */
    int n_SystemID;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 2);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 3);

        xmlSAX2ExternalSubset(ctx, (const xmlChar *)name, (const xmlChar *)ExternalID, (const xmlChar *)SystemID);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 2);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2ExternalSubset",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2GetColumnNumber(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        ret_val = xmlSAX2GetColumnNumber(ctx);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2GetColumnNumber",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2GetEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* The entity name */
    int n_name;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlSAX2GetEntity(ctx, (const xmlChar *)name);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2GetEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2GetLineNumber(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        ret_val = xmlSAX2GetLineNumber(ctx);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2GetLineNumber",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2GetParameterEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* The entity name */
    int n_name;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlSAX2GetParameterEntity(ctx, (const xmlChar *)name);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2GetParameterEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2GetPublicId(void) {
    int test_ret = 0;

    int mem_base;
    const xmlChar * ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        ret_val = xmlSAX2GetPublicId(ctx);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2GetPublicId",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2GetSystemId(void) {
    int test_ret = 0;

    int mem_base;
    const xmlChar * ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        ret_val = xmlSAX2GetSystemId(ctx);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2GetSystemId",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2HasExternalSubset(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        ret_val = xmlSAX2HasExternalSubset(ctx);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2HasExternalSubset",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2HasInternalSubset(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        ret_val = xmlSAX2HasInternalSubset(ctx);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2HasInternalSubset",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2IgnorableWhitespace(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * ch; /* a xmlChar string */
    int n_ch;
    int len; /* the number of xmlChar */
    int n_len;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_ch = 0;n_ch < gen_nb_const_xmlChar_ptr;n_ch++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        ch = gen_const_xmlChar_ptr(n_ch, 1);
        len = gen_int(n_len, 2);

        xmlSAX2IgnorableWhitespace(ctx, (const xmlChar *)ch, len);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_ch, (const xmlChar *)ch, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2IgnorableWhitespace",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_ch);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlSAXHandler_ptr 1
static xmlSAXHandler * gen_xmlSAXHandler_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSAXHandler_ptr(int no ATTRIBUTE_UNUSED, xmlSAXHandler * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlSAX2InitDefaultSAXHandler(void) {
    int test_ret = 0;

    int mem_base;
    xmlSAXHandler * hdlr; /* the SAX handler */
    int n_hdlr;
    int warning; /* flag if non-zero sets the handler warning procedure */
    int n_warning;

    for (n_hdlr = 0;n_hdlr < gen_nb_xmlSAXHandler_ptr;n_hdlr++) {
    for (n_warning = 0;n_warning < gen_nb_int;n_warning++) {
        mem_base = xmlMemBlocks();
        hdlr = gen_xmlSAXHandler_ptr(n_hdlr, 0);
        warning = gen_int(n_warning, 1);

        xmlSAX2InitDefaultSAXHandler(hdlr, warning);
        call_tests++;
        des_xmlSAXHandler_ptr(n_hdlr, hdlr, 0);
        des_int(n_warning, warning, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2InitDefaultSAXHandler",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_hdlr);
            printf(" %d", n_warning);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2InitDocbDefaultSAXHandler(void) {
    int test_ret = 0;

#if defined(LIBXML_DOCB_ENABLED)
    int mem_base;
    xmlSAXHandler * hdlr; /* the SAX handler */
    int n_hdlr;

    for (n_hdlr = 0;n_hdlr < gen_nb_xmlSAXHandler_ptr;n_hdlr++) {
        mem_base = xmlMemBlocks();
        hdlr = gen_xmlSAXHandler_ptr(n_hdlr, 0);

        xmlSAX2InitDocbDefaultSAXHandler(hdlr);
        call_tests++;
        des_xmlSAXHandler_ptr(n_hdlr, hdlr, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2InitDocbDefaultSAXHandler",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_hdlr);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSAX2InitHtmlDefaultSAXHandler(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    xmlSAXHandler * hdlr; /* the SAX handler */
    int n_hdlr;

    for (n_hdlr = 0;n_hdlr < gen_nb_xmlSAXHandler_ptr;n_hdlr++) {
        mem_base = xmlMemBlocks();
        hdlr = gen_xmlSAXHandler_ptr(n_hdlr, 0);

        xmlSAX2InitHtmlDefaultSAXHandler(hdlr);
        call_tests++;
        des_xmlSAXHandler_ptr(n_hdlr, hdlr, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2InitHtmlDefaultSAXHandler",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_hdlr);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSAX2InternalSubset(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* the root element name */
    int n_name;
    xmlChar * ExternalID; /* the external ID */
    int n_ExternalID;
    xmlChar * SystemID; /* the SYSTEM ID (e.g. filename or URL) */
    int n_SystemID;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 2);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 3);

        xmlSAX2InternalSubset(ctx, (const xmlChar *)name, (const xmlChar *)ExternalID, (const xmlChar *)SystemID);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 2);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2InternalSubset",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2IsStandalone(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        ret_val = xmlSAX2IsStandalone(ctx);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2IsStandalone",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2NotationDecl(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* The name of the notation */
    int n_name;
    xmlChar * publicId; /* The public ID of the entity */
    int n_publicId;
    xmlChar * systemId; /* The system ID of the entity */
    int n_systemId;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_publicId = 0;n_publicId < gen_nb_const_xmlChar_ptr;n_publicId++) {
    for (n_systemId = 0;n_systemId < gen_nb_const_xmlChar_ptr;n_systemId++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        publicId = gen_const_xmlChar_ptr(n_publicId, 2);
        systemId = gen_const_xmlChar_ptr(n_systemId, 3);

        xmlSAX2NotationDecl(ctx, (const xmlChar *)name, (const xmlChar *)publicId, (const xmlChar *)systemId);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_publicId, (const xmlChar *)publicId, 2);
        des_const_xmlChar_ptr(n_systemId, (const xmlChar *)systemId, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2NotationDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf(" %d", n_publicId);
            printf(" %d", n_systemId);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2ProcessingInstruction(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * target; /* the target name */
    int n_target;
    xmlChar * data; /* the PI data's */
    int n_data;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_target = 0;n_target < gen_nb_const_xmlChar_ptr;n_target++) {
    for (n_data = 0;n_data < gen_nb_const_xmlChar_ptr;n_data++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        target = gen_const_xmlChar_ptr(n_target, 1);
        data = gen_const_xmlChar_ptr(n_data, 2);

        xmlSAX2ProcessingInstruction(ctx, (const xmlChar *)target, (const xmlChar *)data);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_target, (const xmlChar *)target, 1);
        des_const_xmlChar_ptr(n_data, (const xmlChar *)data, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2ProcessingInstruction",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_target);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2Reference(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* The entity name */
    int n_name;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        xmlSAX2Reference(ctx, (const xmlChar *)name);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2Reference",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2ResolveEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * publicId; /* The public ID of the entity */
    int n_publicId;
    xmlChar * systemId; /* The system ID of the entity */
    int n_systemId;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_publicId = 0;n_publicId < gen_nb_const_xmlChar_ptr;n_publicId++) {
    for (n_systemId = 0;n_systemId < gen_nb_const_xmlChar_ptr;n_systemId++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        publicId = gen_const_xmlChar_ptr(n_publicId, 1);
        systemId = gen_const_xmlChar_ptr(n_systemId, 2);

        ret_val = xmlSAX2ResolveEntity(ctx, (const xmlChar *)publicId, (const xmlChar *)systemId);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_publicId, (const xmlChar *)publicId, 1);
        des_const_xmlChar_ptr(n_systemId, (const xmlChar *)systemId, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2ResolveEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_publicId);
            printf(" %d", n_systemId);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlSAXLocatorPtr 1
static xmlSAXLocatorPtr gen_xmlSAXLocatorPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSAXLocatorPtr(int no ATTRIBUTE_UNUSED, xmlSAXLocatorPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlSAX2SetDocumentLocator(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlSAXLocatorPtr loc; /* A SAX Locator */
    int n_loc;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_loc = 0;n_loc < gen_nb_xmlSAXLocatorPtr;n_loc++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        loc = gen_xmlSAXLocatorPtr(n_loc, 1);

        xmlSAX2SetDocumentLocator(ctx, loc);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_xmlSAXLocatorPtr(n_loc, loc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2SetDocumentLocator",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_loc);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2StartDocument(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        xmlSAX2StartDocument(ctx);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2StartDocument",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2StartElement(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED) || defined(LIBXML_HTML_ENABLED) || defined(LIBXML_WRITER_ENABLED) || defined(LIBXML_DOCB_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * fullname; /* The element name, including namespace prefix */
    int n_fullname;
    xmlChar ** atts; /* An array of name/value attributes pairs, NULL terminated */
    int n_atts;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_fullname = 0;n_fullname < gen_nb_const_xmlChar_ptr;n_fullname++) {
    for (n_atts = 0;n_atts < gen_nb_const_xmlChar_ptr_ptr;n_atts++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        fullname = gen_const_xmlChar_ptr(n_fullname, 1);
        atts = gen_const_xmlChar_ptr_ptr(n_atts, 2);

        xmlSAX2StartElement(ctx, (const xmlChar *)fullname, (const xmlChar **)atts);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_fullname, (const xmlChar *)fullname, 1);
        des_const_xmlChar_ptr_ptr(n_atts, (const xmlChar **)atts, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2StartElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_fullname);
            printf(" %d", n_atts);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAX2StartElementNs(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * localname; /* the local name of the element */
    int n_localname;
    xmlChar * prefix; /* the element namespace prefix if available */
    int n_prefix;
    xmlChar * URI; /* the element namespace name if available */
    int n_URI;
    int nb_namespaces; /* number of namespace definitions on that node */
    int n_nb_namespaces;
    xmlChar ** namespaces; /* pointer to the array of prefix/URI pairs namespace definitions */
    int n_namespaces;
    int nb_attributes; /* the number of attributes on that node */
    int n_nb_attributes;
    int nb_defaulted; /* the number of defaulted attributes. */
    int n_nb_defaulted;
    xmlChar ** attributes; /* pointer to the array of (localname/prefix/URI/value/end) attribute values. */
    int n_attributes;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_localname = 0;n_localname < gen_nb_const_xmlChar_ptr;n_localname++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
    for (n_nb_namespaces = 0;n_nb_namespaces < gen_nb_int;n_nb_namespaces++) {
    for (n_namespaces = 0;n_namespaces < gen_nb_const_xmlChar_ptr_ptr;n_namespaces++) {
    for (n_nb_attributes = 0;n_nb_attributes < gen_nb_int;n_nb_attributes++) {
    for (n_nb_defaulted = 0;n_nb_defaulted < gen_nb_int;n_nb_defaulted++) {
    for (n_attributes = 0;n_attributes < gen_nb_const_xmlChar_ptr_ptr;n_attributes++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        localname = gen_const_xmlChar_ptr(n_localname, 1);
        prefix = gen_const_xmlChar_ptr(n_prefix, 2);
        URI = gen_const_xmlChar_ptr(n_URI, 3);
        nb_namespaces = gen_int(n_nb_namespaces, 4);
        namespaces = gen_const_xmlChar_ptr_ptr(n_namespaces, 5);
        nb_attributes = gen_int(n_nb_attributes, 6);
        nb_defaulted = gen_int(n_nb_defaulted, 7);
        attributes = gen_const_xmlChar_ptr_ptr(n_attributes, 8);

        xmlSAX2StartElementNs(ctx, (const xmlChar *)localname, (const xmlChar *)prefix, (const xmlChar *)URI, nb_namespaces, (const xmlChar **)namespaces, nb_attributes, nb_defaulted, (const xmlChar **)attributes);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_localname, (const xmlChar *)localname, 1);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 2);
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 3);
        des_int(n_nb_namespaces, nb_namespaces, 4);
        des_const_xmlChar_ptr_ptr(n_namespaces, (const xmlChar **)namespaces, 5);
        des_int(n_nb_attributes, nb_attributes, 6);
        des_int(n_nb_defaulted, nb_defaulted, 7);
        des_const_xmlChar_ptr_ptr(n_attributes, (const xmlChar **)attributes, 8);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2StartElementNs",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_localname);
            printf(" %d", n_prefix);
            printf(" %d", n_URI);
            printf(" %d", n_nb_namespaces);
            printf(" %d", n_namespaces);
            printf(" %d", n_nb_attributes);
            printf(" %d", n_nb_defaulted);
            printf(" %d", n_attributes);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAX2UnparsedEntityDecl(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* the user data (XML parser context) */
    int n_ctx;
    xmlChar * name; /* The name of the entity */
    int n_name;
    xmlChar * publicId; /* The public ID of the entity */
    int n_publicId;
    xmlChar * systemId; /* The system ID of the entity */
    int n_systemId;
    xmlChar * notationName; /* the name of the notation */
    int n_notationName;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_publicId = 0;n_publicId < gen_nb_const_xmlChar_ptr;n_publicId++) {
    for (n_systemId = 0;n_systemId < gen_nb_const_xmlChar_ptr;n_systemId++) {
    for (n_notationName = 0;n_notationName < gen_nb_const_xmlChar_ptr;n_notationName++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        publicId = gen_const_xmlChar_ptr(n_publicId, 2);
        systemId = gen_const_xmlChar_ptr(n_systemId, 3);
        notationName = gen_const_xmlChar_ptr(n_notationName, 4);

        xmlSAX2UnparsedEntityDecl(ctx, (const xmlChar *)name, (const xmlChar *)publicId, (const xmlChar *)systemId, (const xmlChar *)notationName);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_publicId, (const xmlChar *)publicId, 2);
        des_const_xmlChar_ptr(n_systemId, (const xmlChar *)systemId, 3);
        des_const_xmlChar_ptr(n_notationName, (const xmlChar *)notationName, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAX2UnparsedEntityDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_name);
            printf(" %d", n_publicId);
            printf(" %d", n_systemId);
            printf(" %d", n_notationName);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSAXDefaultVersion(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    int ret_val;
    int version; /* the version, 1 or 2 */
    int n_version;

    for (n_version = 0;n_version < gen_nb_int;n_version++) {
        mem_base = xmlMemBlocks();
        version = gen_int(n_version, 0);

        ret_val = xmlSAXDefaultVersion(version);
        desret_int(ret_val);
        call_tests++;
        des_int(n_version, version, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXDefaultVersion",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_version);
            printf("\n");
        }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXVersion(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlSAXHandler * hdlr; /* the SAX handler */
    int n_hdlr;
    int version; /* the version, 1 or 2 */
    int n_version;

    for (n_hdlr = 0;n_hdlr < gen_nb_xmlSAXHandler_ptr;n_hdlr++) {
    for (n_version = 0;n_version < gen_nb_int;n_version++) {
        mem_base = xmlMemBlocks();
        hdlr = gen_xmlSAXHandler_ptr(n_hdlr, 0);
        version = gen_int(n_version, 1);

        ret_val = xmlSAXVersion(hdlr, version);
        desret_int(ret_val);
        call_tests++;
        des_xmlSAXHandler_ptr(n_hdlr, hdlr, 0);
        des_int(n_version, version, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXVersion",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_hdlr);
            printf(" %d", n_version);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}

static int
test_SAX2(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing SAX2 : 38 of 38 functions ...\n");
    test_ret += test_docbDefaultSAXHandlerInit();
    test_ret += test_htmlDefaultSAXHandlerInit();
    test_ret += test_xmlDefaultSAXHandlerInit();
    test_ret += test_xmlSAX2AttributeDecl();
    test_ret += test_xmlSAX2CDataBlock();
    test_ret += test_xmlSAX2Characters();
    test_ret += test_xmlSAX2Comment();
    test_ret += test_xmlSAX2ElementDecl();
    test_ret += test_xmlSAX2EndDocument();
    test_ret += test_xmlSAX2EndElement();
    test_ret += test_xmlSAX2EndElementNs();
    test_ret += test_xmlSAX2EntityDecl();
    test_ret += test_xmlSAX2ExternalSubset();
    test_ret += test_xmlSAX2GetColumnNumber();
    test_ret += test_xmlSAX2GetEntity();
    test_ret += test_xmlSAX2GetLineNumber();
    test_ret += test_xmlSAX2GetParameterEntity();
    test_ret += test_xmlSAX2GetPublicId();
    test_ret += test_xmlSAX2GetSystemId();
    test_ret += test_xmlSAX2HasExternalSubset();
    test_ret += test_xmlSAX2HasInternalSubset();
    test_ret += test_xmlSAX2IgnorableWhitespace();
    test_ret += test_xmlSAX2InitDefaultSAXHandler();
    test_ret += test_xmlSAX2InitDocbDefaultSAXHandler();
    test_ret += test_xmlSAX2InitHtmlDefaultSAXHandler();
    test_ret += test_xmlSAX2InternalSubset();
    test_ret += test_xmlSAX2IsStandalone();
    test_ret += test_xmlSAX2NotationDecl();
    test_ret += test_xmlSAX2ProcessingInstruction();
    test_ret += test_xmlSAX2Reference();
    test_ret += test_xmlSAX2ResolveEntity();
    test_ret += test_xmlSAX2SetDocumentLocator();
    test_ret += test_xmlSAX2StartDocument();
    test_ret += test_xmlSAX2StartElement();
    test_ret += test_xmlSAX2StartElementNs();
    test_ret += test_xmlSAX2UnparsedEntityDecl();
    test_ret += test_xmlSAXDefaultVersion();
    test_ret += test_xmlSAXVersion();

    if (test_ret != 0)
	printf("Module SAX2: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlC14NDocDumpMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_C14N_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the XML document for canonization */
    int n_doc;
    xmlNodeSetPtr nodes; /* the nodes set to be included in the canonized image or NULL if all document nodes should be included */
    int n_nodes;
    int mode; /* the c14n mode (see @xmlC14NMode) */
    int n_mode;
    xmlChar ** inclusive_ns_prefixes; /* the list of inclusive namespace prefixes ended with a NULL or NULL if there is no inclusive namespaces (only for exclusive canonicalization, ignored otherwise) */
    int n_inclusive_ns_prefixes;
    int with_comments; /* include comments in the result (!=0) or not (==0) */
    int n_with_comments;
    xmlChar ** doc_txt_ptr; /* the memory pointer for allocated canonical XML text; the caller of this functions is responsible for calling xmlFree() to free allocated memory */
    int n_doc_txt_ptr;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_nodes = 0;n_nodes < gen_nb_xmlNodeSetPtr;n_nodes++) {
    for (n_mode = 0;n_mode < gen_nb_int;n_mode++) {
    for (n_inclusive_ns_prefixes = 0;n_inclusive_ns_prefixes < gen_nb_xmlChar_ptr_ptr;n_inclusive_ns_prefixes++) {
    for (n_with_comments = 0;n_with_comments < gen_nb_int;n_with_comments++) {
    for (n_doc_txt_ptr = 0;n_doc_txt_ptr < gen_nb_xmlChar_ptr_ptr;n_doc_txt_ptr++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        nodes = gen_xmlNodeSetPtr(n_nodes, 1);
        mode = gen_int(n_mode, 2);
        inclusive_ns_prefixes = gen_xmlChar_ptr_ptr(n_inclusive_ns_prefixes, 3);
        with_comments = gen_int(n_with_comments, 4);
        doc_txt_ptr = gen_xmlChar_ptr_ptr(n_doc_txt_ptr, 5);

        ret_val = xmlC14NDocDumpMemory(doc, nodes, mode, inclusive_ns_prefixes, with_comments, doc_txt_ptr);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodeSetPtr(n_nodes, nodes, 1);
        des_int(n_mode, mode, 2);
        des_xmlChar_ptr_ptr(n_inclusive_ns_prefixes, inclusive_ns_prefixes, 3);
        des_int(n_with_comments, with_comments, 4);
        des_xmlChar_ptr_ptr(n_doc_txt_ptr, doc_txt_ptr, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlC14NDocDumpMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_nodes);
            printf(" %d", n_mode);
            printf(" %d", n_inclusive_ns_prefixes);
            printf(" %d", n_with_comments);
            printf(" %d", n_doc_txt_ptr);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlC14NDocSave(void) {
    int test_ret = 0;

#if defined(LIBXML_C14N_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the XML document for canonization */
    int n_doc;
    xmlNodeSetPtr nodes; /* the nodes set to be included in the canonized image or NULL if all document nodes should be included */
    int n_nodes;
    int mode; /* the c14n mode (see @xmlC14NMode) */
    int n_mode;
    xmlChar ** inclusive_ns_prefixes; /* the list of inclusive namespace prefixes ended with a NULL or NULL if there is no inclusive namespaces (only for exclusive canonicalization, ignored otherwise) */
    int n_inclusive_ns_prefixes;
    int with_comments; /* include comments in the result (!=0) or not (==0) */
    int n_with_comments;
    const char * filename; /* the filename to store canonical XML image */
    int n_filename;
    int compression; /* the compression level (zlib requred): -1 - libxml default, 0 - uncompressed, >0 - compression level */
    int n_compression;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_nodes = 0;n_nodes < gen_nb_xmlNodeSetPtr;n_nodes++) {
    for (n_mode = 0;n_mode < gen_nb_int;n_mode++) {
    for (n_inclusive_ns_prefixes = 0;n_inclusive_ns_prefixes < gen_nb_xmlChar_ptr_ptr;n_inclusive_ns_prefixes++) {
    for (n_with_comments = 0;n_with_comments < gen_nb_int;n_with_comments++) {
    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_compression = 0;n_compression < gen_nb_int;n_compression++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        nodes = gen_xmlNodeSetPtr(n_nodes, 1);
        mode = gen_int(n_mode, 2);
        inclusive_ns_prefixes = gen_xmlChar_ptr_ptr(n_inclusive_ns_prefixes, 3);
        with_comments = gen_int(n_with_comments, 4);
        filename = gen_fileoutput(n_filename, 5);
        compression = gen_int(n_compression, 6);

        ret_val = xmlC14NDocSave(doc, nodes, mode, inclusive_ns_prefixes, with_comments, filename, compression);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodeSetPtr(n_nodes, nodes, 1);
        des_int(n_mode, mode, 2);
        des_xmlChar_ptr_ptr(n_inclusive_ns_prefixes, inclusive_ns_prefixes, 3);
        des_int(n_with_comments, with_comments, 4);
        des_fileoutput(n_filename, filename, 5);
        des_int(n_compression, compression, 6);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlC14NDocSave",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_nodes);
            printf(" %d", n_mode);
            printf(" %d", n_inclusive_ns_prefixes);
            printf(" %d", n_with_comments);
            printf(" %d", n_filename);
            printf(" %d", n_compression);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlC14NDocSaveTo(void) {
    int test_ret = 0;

#if defined(LIBXML_C14N_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the XML document for canonization */
    int n_doc;
    xmlNodeSetPtr nodes; /* the nodes set to be included in the canonized image or NULL if all document nodes should be included */
    int n_nodes;
    int mode; /* the c14n mode (see @xmlC14NMode) */
    int n_mode;
    xmlChar ** inclusive_ns_prefixes; /* the list of inclusive namespace prefixes ended with a NULL or NULL if there is no inclusive namespaces (only for exclusive canonicalization, ignored otherwise) */
    int n_inclusive_ns_prefixes;
    int with_comments; /* include comments in the result (!=0) or not (==0) */
    int n_with_comments;
    xmlOutputBufferPtr buf; /* the output buffer to store canonical XML; this buffer MUST have encoder==NULL because C14N requires UTF-8 output */
    int n_buf;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_nodes = 0;n_nodes < gen_nb_xmlNodeSetPtr;n_nodes++) {
    for (n_mode = 0;n_mode < gen_nb_int;n_mode++) {
    for (n_inclusive_ns_prefixes = 0;n_inclusive_ns_prefixes < gen_nb_xmlChar_ptr_ptr;n_inclusive_ns_prefixes++) {
    for (n_with_comments = 0;n_with_comments < gen_nb_int;n_with_comments++) {
    for (n_buf = 0;n_buf < gen_nb_xmlOutputBufferPtr;n_buf++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        nodes = gen_xmlNodeSetPtr(n_nodes, 1);
        mode = gen_int(n_mode, 2);
        inclusive_ns_prefixes = gen_xmlChar_ptr_ptr(n_inclusive_ns_prefixes, 3);
        with_comments = gen_int(n_with_comments, 4);
        buf = gen_xmlOutputBufferPtr(n_buf, 5);

        ret_val = xmlC14NDocSaveTo(doc, nodes, mode, inclusive_ns_prefixes, with_comments, buf);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodeSetPtr(n_nodes, nodes, 1);
        des_int(n_mode, mode, 2);
        des_xmlChar_ptr_ptr(n_inclusive_ns_prefixes, inclusive_ns_prefixes, 3);
        des_int(n_with_comments, with_comments, 4);
        des_xmlOutputBufferPtr(n_buf, buf, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlC14NDocSaveTo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_nodes);
            printf(" %d", n_mode);
            printf(" %d", n_inclusive_ns_prefixes);
            printf(" %d", n_with_comments);
            printf(" %d", n_buf);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlC14NExecute(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

static int
test_c14n(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing c14n : 3 of 4 functions ...\n");
    test_ret += test_xmlC14NDocDumpMemory();
    test_ret += test_xmlC14NDocSave();
    test_ret += test_xmlC14NDocSaveTo();
    test_ret += test_xmlC14NExecute();

    if (test_ret != 0)
	printf("Module c14n: %d errors\n", test_ret);
    return(test_ret);
}
#ifdef LIBXML_CATALOG_ENABLED

#define gen_nb_xmlCatalogPtr 1
static xmlCatalogPtr gen_xmlCatalogPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlCatalogPtr(int no ATTRIBUTE_UNUSED, xmlCatalogPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlACatalogAdd(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    int ret_val;
    xmlCatalogPtr catal; /* a Catalog */
    int n_catal;
    xmlChar * type; /* the type of record to add to the catalog */
    int n_type;
    xmlChar * orig; /* the system, public or prefix to match */
    int n_orig;
    xmlChar * replace; /* the replacement value for the match */
    int n_replace;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
    for (n_type = 0;n_type < gen_nb_const_xmlChar_ptr;n_type++) {
    for (n_orig = 0;n_orig < gen_nb_const_xmlChar_ptr;n_orig++) {
    for (n_replace = 0;n_replace < gen_nb_const_xmlChar_ptr;n_replace++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);
        type = gen_const_xmlChar_ptr(n_type, 1);
        orig = gen_const_xmlChar_ptr(n_orig, 2);
        replace = gen_const_xmlChar_ptr(n_replace, 3);

        ret_val = xmlACatalogAdd(catal, (const xmlChar *)type, (const xmlChar *)orig, (const xmlChar *)replace);
        desret_int(ret_val);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        des_const_xmlChar_ptr(n_type, (const xmlChar *)type, 1);
        des_const_xmlChar_ptr(n_orig, (const xmlChar *)orig, 2);
        des_const_xmlChar_ptr(n_replace, (const xmlChar *)replace, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlACatalogAdd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf(" %d", n_type);
            printf(" %d", n_orig);
            printf(" %d", n_replace);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlACatalogDump(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlCatalogPtr catal; /* a Catalog */
    int n_catal;
    FILE * out; /* the file. */
    int n_out;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
    for (n_out = 0;n_out < gen_nb_FILE_ptr;n_out++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);
        out = gen_FILE_ptr(n_out, 1);

        xmlACatalogDump(catal, out);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        des_FILE_ptr(n_out, out, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlACatalogDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf(" %d", n_out);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlACatalogRemove(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    int ret_val;
    xmlCatalogPtr catal; /* a Catalog */
    int n_catal;
    xmlChar * value; /* the value to remove */
    int n_value;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);

        ret_val = xmlACatalogRemove(catal, (const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlACatalogRemove",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlACatalogResolve(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlCatalogPtr catal; /* a Catalog */
    int n_catal;
    xmlChar * pubID; /* the public ID string */
    int n_pubID;
    xmlChar * sysID; /* the system ID string */
    int n_sysID;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
    for (n_pubID = 0;n_pubID < gen_nb_const_xmlChar_ptr;n_pubID++) {
    for (n_sysID = 0;n_sysID < gen_nb_const_xmlChar_ptr;n_sysID++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);
        pubID = gen_const_xmlChar_ptr(n_pubID, 1);
        sysID = gen_const_xmlChar_ptr(n_sysID, 2);

        ret_val = xmlACatalogResolve(catal, (const xmlChar *)pubID, (const xmlChar *)sysID);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        des_const_xmlChar_ptr(n_pubID, (const xmlChar *)pubID, 1);
        des_const_xmlChar_ptr(n_sysID, (const xmlChar *)sysID, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlACatalogResolve",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf(" %d", n_pubID);
            printf(" %d", n_sysID);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlACatalogResolvePublic(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlCatalogPtr catal; /* a Catalog */
    int n_catal;
    xmlChar * pubID; /* the public ID string */
    int n_pubID;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
    for (n_pubID = 0;n_pubID < gen_nb_const_xmlChar_ptr;n_pubID++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);
        pubID = gen_const_xmlChar_ptr(n_pubID, 1);

        ret_val = xmlACatalogResolvePublic(catal, (const xmlChar *)pubID);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        des_const_xmlChar_ptr(n_pubID, (const xmlChar *)pubID, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlACatalogResolvePublic",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf(" %d", n_pubID);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlACatalogResolveSystem(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlCatalogPtr catal; /* a Catalog */
    int n_catal;
    xmlChar * sysID; /* the system ID string */
    int n_sysID;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
    for (n_sysID = 0;n_sysID < gen_nb_const_xmlChar_ptr;n_sysID++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);
        sysID = gen_const_xmlChar_ptr(n_sysID, 1);

        ret_val = xmlACatalogResolveSystem(catal, (const xmlChar *)sysID);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        des_const_xmlChar_ptr(n_sysID, (const xmlChar *)sysID, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlACatalogResolveSystem",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf(" %d", n_sysID);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlACatalogResolveURI(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlCatalogPtr catal; /* a Catalog */
    int n_catal;
    xmlChar * URI; /* the URI */
    int n_URI;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);
        URI = gen_const_xmlChar_ptr(n_URI, 1);

        ret_val = xmlACatalogResolveURI(catal, (const xmlChar *)URI);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlACatalogResolveURI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf(" %d", n_URI);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogAdd(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    int ret_val;
    xmlChar * type; /* the type of record to add to the catalog */
    int n_type;
    xmlChar * orig; /* the system, public or prefix to match */
    int n_orig;
    xmlChar * replace; /* the replacement value for the match */
    int n_replace;

    for (n_type = 0;n_type < gen_nb_const_xmlChar_ptr;n_type++) {
    for (n_orig = 0;n_orig < gen_nb_const_xmlChar_ptr;n_orig++) {
    for (n_replace = 0;n_replace < gen_nb_const_xmlChar_ptr;n_replace++) {
        mem_base = xmlMemBlocks();
        type = gen_const_xmlChar_ptr(n_type, 0);
        orig = gen_const_xmlChar_ptr(n_orig, 1);
        replace = gen_const_xmlChar_ptr(n_replace, 2);

        ret_val = xmlCatalogAdd((const xmlChar *)type, (const xmlChar *)orig, (const xmlChar *)replace);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_type, (const xmlChar *)type, 0);
        des_const_xmlChar_ptr(n_orig, (const xmlChar *)orig, 1);
        des_const_xmlChar_ptr(n_replace, (const xmlChar *)replace, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogAdd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_type);
            printf(" %d", n_orig);
            printf(" %d", n_replace);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogCleanup(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)


        xmlCatalogCleanup();
        call_tests++;
        xmlResetLastError();
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogConvert(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int ret_val;


        ret_val = xmlCatalogConvert();
        desret_int(ret_val);
        call_tests++;
        xmlResetLastError();
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogDump(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    FILE * out; /* the file. */
    int n_out;

    for (n_out = 0;n_out < gen_nb_FILE_ptr;n_out++) {
        mem_base = xmlMemBlocks();
        out = gen_FILE_ptr(n_out, 0);

        xmlCatalogDump(out);
        call_tests++;
        des_FILE_ptr(n_out, out, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogGetDefaults(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlCatalogAllow ret_val;

        mem_base = xmlMemBlocks();

        ret_val = xmlCatalogGetDefaults();
        desret_xmlCatalogAllow(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogGetDefaults",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogIsEmpty(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    int ret_val;
    xmlCatalogPtr catal; /* should this create an SGML catalog */
    int n_catal;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);

        ret_val = xmlCatalogIsEmpty(catal);
        desret_int(ret_val);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogIsEmpty",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogLocalResolve(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    void * catalogs; /* a document's list of catalogs */
    int n_catalogs;
    xmlChar * pubID; /* the public ID string */
    int n_pubID;
    xmlChar * sysID; /* the system ID string */
    int n_sysID;

    for (n_catalogs = 0;n_catalogs < gen_nb_void_ptr;n_catalogs++) {
    for (n_pubID = 0;n_pubID < gen_nb_const_xmlChar_ptr;n_pubID++) {
    for (n_sysID = 0;n_sysID < gen_nb_const_xmlChar_ptr;n_sysID++) {
        mem_base = xmlMemBlocks();
        catalogs = gen_void_ptr(n_catalogs, 0);
        pubID = gen_const_xmlChar_ptr(n_pubID, 1);
        sysID = gen_const_xmlChar_ptr(n_sysID, 2);

        ret_val = xmlCatalogLocalResolve(catalogs, (const xmlChar *)pubID, (const xmlChar *)sysID);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_void_ptr(n_catalogs, catalogs, 0);
        des_const_xmlChar_ptr(n_pubID, (const xmlChar *)pubID, 1);
        des_const_xmlChar_ptr(n_sysID, (const xmlChar *)sysID, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogLocalResolve",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catalogs);
            printf(" %d", n_pubID);
            printf(" %d", n_sysID);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogLocalResolveURI(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    void * catalogs; /* a document's list of catalogs */
    int n_catalogs;
    xmlChar * URI; /* the URI */
    int n_URI;

    for (n_catalogs = 0;n_catalogs < gen_nb_void_ptr;n_catalogs++) {
    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
        mem_base = xmlMemBlocks();
        catalogs = gen_void_ptr(n_catalogs, 0);
        URI = gen_const_xmlChar_ptr(n_URI, 1);

        ret_val = xmlCatalogLocalResolveURI(catalogs, (const xmlChar *)URI);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_void_ptr(n_catalogs, catalogs, 0);
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogLocalResolveURI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catalogs);
            printf(" %d", n_URI);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogRemove(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int ret_val;
    xmlChar * value; /* the value to remove */
    int n_value;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        value = gen_const_xmlChar_ptr(n_value, 0);

        ret_val = xmlCatalogRemove((const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        xmlResetLastError();
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogResolve(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    xmlChar * ret_val;
    xmlChar * pubID; /* the public ID string */
    int n_pubID;
    xmlChar * sysID; /* the system ID string */
    int n_sysID;

    for (n_pubID = 0;n_pubID < gen_nb_const_xmlChar_ptr;n_pubID++) {
    for (n_sysID = 0;n_sysID < gen_nb_const_xmlChar_ptr;n_sysID++) {
        pubID = gen_const_xmlChar_ptr(n_pubID, 0);
        sysID = gen_const_xmlChar_ptr(n_sysID, 1);

        ret_val = xmlCatalogResolve((const xmlChar *)pubID, (const xmlChar *)sysID);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_pubID, (const xmlChar *)pubID, 0);
        des_const_xmlChar_ptr(n_sysID, (const xmlChar *)sysID, 1);
        xmlResetLastError();
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogResolvePublic(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlChar * pubID; /* the public ID string */
    int n_pubID;

    for (n_pubID = 0;n_pubID < gen_nb_const_xmlChar_ptr;n_pubID++) {
        mem_base = xmlMemBlocks();
        pubID = gen_const_xmlChar_ptr(n_pubID, 0);

        ret_val = xmlCatalogResolvePublic((const xmlChar *)pubID);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_pubID, (const xmlChar *)pubID, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogResolvePublic",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_pubID);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogResolveSystem(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlChar * sysID; /* the system ID string */
    int n_sysID;

    for (n_sysID = 0;n_sysID < gen_nb_const_xmlChar_ptr;n_sysID++) {
        mem_base = xmlMemBlocks();
        sysID = gen_const_xmlChar_ptr(n_sysID, 0);

        ret_val = xmlCatalogResolveSystem((const xmlChar *)sysID);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_sysID, (const xmlChar *)sysID, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogResolveSystem",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sysID);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogResolveURI(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlChar * URI; /* the URI */
    int n_URI;

    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
        mem_base = xmlMemBlocks();
        URI = gen_const_xmlChar_ptr(n_URI, 0);

        ret_val = xmlCatalogResolveURI((const xmlChar *)URI);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogResolveURI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URI);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogSetDefaultPrefer(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlCatalogPrefer ret_val;
    xmlCatalogPrefer prefer; /* the default preference for delegation */
    int n_prefer;

    for (n_prefer = 0;n_prefer < gen_nb_xmlCatalogPrefer;n_prefer++) {
        mem_base = xmlMemBlocks();
        prefer = gen_xmlCatalogPrefer(n_prefer, 0);

        ret_val = xmlCatalogSetDefaultPrefer(prefer);
        desret_xmlCatalogPrefer(ret_val);
        call_tests++;
        des_xmlCatalogPrefer(n_prefer, prefer, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogSetDefaultPrefer",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_prefer);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCatalogSetDefaults(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlCatalogAllow allow; /* what catalogs should be accepted */
    int n_allow;

    for (n_allow = 0;n_allow < gen_nb_xmlCatalogAllow;n_allow++) {
        mem_base = xmlMemBlocks();
        allow = gen_xmlCatalogAllow(n_allow, 0);

        xmlCatalogSetDefaults(allow);
        call_tests++;
        des_xmlCatalogAllow(n_allow, allow, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCatalogSetDefaults",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_allow);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlConvertSGMLCatalog(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    int ret_val;
    xmlCatalogPtr catal; /* the catalog */
    int n_catal;

    for (n_catal = 0;n_catal < gen_nb_xmlCatalogPtr;n_catal++) {
        mem_base = xmlMemBlocks();
        catal = gen_xmlCatalogPtr(n_catal, 0);

        ret_val = xmlConvertSGMLCatalog(catal);
        desret_int(ret_val);
        call_tests++;
        des_xmlCatalogPtr(n_catal, catal, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlConvertSGMLCatalog",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_catal);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlInitializeCatalog(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlInitializeCatalog();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlInitializeCatalog",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlLoadACatalog(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlLoadCatalog(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int ret_val;
    const char * filename; /* a file path */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlLoadCatalog(filename);
        desret_int(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlLoadCatalogs(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    char * pathss; /* a list of directories separated by a colon or a space. */
    int n_pathss;

    for (n_pathss = 0;n_pathss < gen_nb_const_char_ptr;n_pathss++) {
        pathss = gen_const_char_ptr(n_pathss, 0);

        xmlLoadCatalogs((const char *)pathss);
        call_tests++;
        des_const_char_ptr(n_pathss, (const char *)pathss, 0);
        xmlResetLastError();
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlLoadSGMLSuperCatalog(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlNewCatalog(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlParseCatalogFile(void) {
    int test_ret = 0;

#if defined(LIBXML_CATALOG_ENABLED)
    int mem_base;
    xmlDocPtr ret_val;
    const char * filename; /* the filename */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlParseCatalogFile(filename);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseCatalogFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_catalog(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing catalog : 27 of 36 functions ...\n");
    test_ret += test_xmlACatalogAdd();
    test_ret += test_xmlACatalogDump();
    test_ret += test_xmlACatalogRemove();
    test_ret += test_xmlACatalogResolve();
    test_ret += test_xmlACatalogResolvePublic();
    test_ret += test_xmlACatalogResolveSystem();
    test_ret += test_xmlACatalogResolveURI();
    test_ret += test_xmlCatalogAdd();
    test_ret += test_xmlCatalogCleanup();
    test_ret += test_xmlCatalogConvert();
    test_ret += test_xmlCatalogDump();
    test_ret += test_xmlCatalogGetDefaults();
    test_ret += test_xmlCatalogIsEmpty();
    test_ret += test_xmlCatalogLocalResolve();
    test_ret += test_xmlCatalogLocalResolveURI();
    test_ret += test_xmlCatalogRemove();
    test_ret += test_xmlCatalogResolve();
    test_ret += test_xmlCatalogResolvePublic();
    test_ret += test_xmlCatalogResolveSystem();
    test_ret += test_xmlCatalogResolveURI();
    test_ret += test_xmlCatalogSetDefaultPrefer();
    test_ret += test_xmlCatalogSetDefaults();
    test_ret += test_xmlConvertSGMLCatalog();
    test_ret += test_xmlInitializeCatalog();
    test_ret += test_xmlLoadACatalog();
    test_ret += test_xmlLoadCatalog();
    test_ret += test_xmlLoadCatalogs();
    test_ret += test_xmlLoadSGMLSuperCatalog();
    test_ret += test_xmlNewCatalog();
    test_ret += test_xmlParseCatalogFile();

    if (test_ret != 0)
	printf("Module catalog: %d errors\n", test_ret);
    return(test_ret);
}

#define gen_nb_const_xmlChRangeGroup_ptr 1
static xmlChRangeGroup * gen_const_xmlChRangeGroup_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_xmlChRangeGroup_ptr(int no ATTRIBUTE_UNUSED, const xmlChRangeGroup * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlCharInRange(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int val; /* character to be validated */
    int n_val;
    xmlChRangeGroup * rptr; /* pointer to range to be used to validate */
    int n_rptr;

    for (n_val = 0;n_val < gen_nb_unsigned_int;n_val++) {
    for (n_rptr = 0;n_rptr < gen_nb_const_xmlChRangeGroup_ptr;n_rptr++) {
        mem_base = xmlMemBlocks();
        val = gen_unsigned_int(n_val, 0);
        rptr = gen_const_xmlChRangeGroup_ptr(n_rptr, 1);

        ret_val = xmlCharInRange(val, (const xmlChRangeGroup *)rptr);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_val, val, 0);
        des_const_xmlChRangeGroup_ptr(n_rptr, (const xmlChRangeGroup *)rptr, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCharInRange",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf(" %d", n_rptr);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsBaseChar(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int ch; /* character to validate */
    int n_ch;

    for (n_ch = 0;n_ch < gen_nb_unsigned_int;n_ch++) {
        mem_base = xmlMemBlocks();
        ch = gen_unsigned_int(n_ch, 0);

        ret_val = xmlIsBaseChar(ch);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_ch, ch, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsBaseChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ch);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsBlank(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int ch; /* character to validate */
    int n_ch;

    for (n_ch = 0;n_ch < gen_nb_unsigned_int;n_ch++) {
        mem_base = xmlMemBlocks();
        ch = gen_unsigned_int(n_ch, 0);

        ret_val = xmlIsBlank(ch);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_ch, ch, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsBlank",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ch);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsChar(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int ch; /* character to validate */
    int n_ch;

    for (n_ch = 0;n_ch < gen_nb_unsigned_int;n_ch++) {
        mem_base = xmlMemBlocks();
        ch = gen_unsigned_int(n_ch, 0);

        ret_val = xmlIsChar(ch);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_ch, ch, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ch);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsCombining(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int ch; /* character to validate */
    int n_ch;

    for (n_ch = 0;n_ch < gen_nb_unsigned_int;n_ch++) {
        mem_base = xmlMemBlocks();
        ch = gen_unsigned_int(n_ch, 0);

        ret_val = xmlIsCombining(ch);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_ch, ch, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsCombining",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ch);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsDigit(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int ch; /* character to validate */
    int n_ch;

    for (n_ch = 0;n_ch < gen_nb_unsigned_int;n_ch++) {
        mem_base = xmlMemBlocks();
        ch = gen_unsigned_int(n_ch, 0);

        ret_val = xmlIsDigit(ch);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_ch, ch, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsDigit",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ch);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsExtender(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int ch; /* character to validate */
    int n_ch;

    for (n_ch = 0;n_ch < gen_nb_unsigned_int;n_ch++) {
        mem_base = xmlMemBlocks();
        ch = gen_unsigned_int(n_ch, 0);

        ret_val = xmlIsExtender(ch);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_ch, ch, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsExtender",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ch);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsIdeographic(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int ch; /* character to validate */
    int n_ch;

    for (n_ch = 0;n_ch < gen_nb_unsigned_int;n_ch++) {
        mem_base = xmlMemBlocks();
        ch = gen_unsigned_int(n_ch, 0);

        ret_val = xmlIsIdeographic(ch);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_ch, ch, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsIdeographic",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ch);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsPubidChar(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned int ch; /* character to validate */
    int n_ch;

    for (n_ch = 0;n_ch < gen_nb_unsigned_int;n_ch++) {
        mem_base = xmlMemBlocks();
        ch = gen_unsigned_int(n_ch, 0);

        ret_val = xmlIsPubidChar(ch);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_int(n_ch, ch, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsPubidChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ch);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}

static int
test_chvalid(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing chvalid : 9 of 9 functions ...\n");
    test_ret += test_xmlCharInRange();
    test_ret += test_xmlIsBaseChar();
    test_ret += test_xmlIsBlank();
    test_ret += test_xmlIsChar();
    test_ret += test_xmlIsCombining();
    test_ret += test_xmlIsDigit();
    test_ret += test_xmlIsExtender();
    test_ret += test_xmlIsIdeographic();
    test_ret += test_xmlIsPubidChar();

    if (test_ret != 0)
	printf("Module chvalid: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlBoolToText(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    const char * ret_val;
    int boolval; /* a bool to turn into text */
    int n_boolval;

    for (n_boolval = 0;n_boolval < gen_nb_int;n_boolval++) {
        mem_base = xmlMemBlocks();
        boolval = gen_int(n_boolval, 0);

        ret_val = xmlBoolToText(boolval);
        desret_const_char_ptr(ret_val);
        call_tests++;
        des_int(n_boolval, boolval, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBoolToText",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_boolval);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugCheckDocument(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    int ret_val;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlDocPtr doc; /* the document */
    int n_doc;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlDebugCheckDocument(output, doc);
        desret_int(ret_val);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugCheckDocument",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpAttr(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlAttrPtr attr; /* the attribute */
    int n_attr;
    int depth; /* the indentation level. */
    int n_depth;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttrPtr;n_attr++) {
    for (n_depth = 0;n_depth < gen_nb_int;n_depth++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        attr = gen_xmlAttrPtr(n_attr, 1);
        depth = gen_int(n_depth, 2);

        xmlDebugDumpAttr(output, attr, depth);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlAttrPtr(n_attr, attr, 1);
        des_int(n_depth, depth, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpAttr",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_attr);
            printf(" %d", n_depth);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpAttrList(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlAttrPtr attr; /* the attribute list */
    int n_attr;
    int depth; /* the indentation level. */
    int n_depth;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttrPtr;n_attr++) {
    for (n_depth = 0;n_depth < gen_nb_int;n_depth++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        attr = gen_xmlAttrPtr(n_attr, 1);
        depth = gen_int(n_depth, 2);

        xmlDebugDumpAttrList(output, attr, depth);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlAttrPtr(n_attr, attr, 1);
        des_int(n_depth, depth, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpAttrList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_attr);
            printf(" %d", n_depth);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpDTD(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlDtdPtr dtd; /* the DTD */
    int n_dtd;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        dtd = gen_xmlDtdPtr(n_dtd, 1);

        xmlDebugDumpDTD(output, dtd);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlDtdPtr(n_dtd, dtd, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpDTD",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_dtd);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpDocument(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlDocPtr doc; /* the document */
    int n_doc;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        xmlDebugDumpDocument(output, doc);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpDocument",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpDocumentHead(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlDocPtr doc; /* the document */
    int n_doc;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        xmlDebugDumpDocumentHead(output, doc);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpDocumentHead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpEntities(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlDocPtr doc; /* the document */
    int n_doc;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        xmlDebugDumpEntities(output, doc);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpEntities",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpNode(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlNodePtr node; /* the node */
    int n_node;
    int depth; /* the indentation level. */
    int n_depth;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_depth = 0;n_depth < gen_nb_int;n_depth++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        node = gen_xmlNodePtr(n_node, 1);
        depth = gen_int(n_depth, 2);

        xmlDebugDumpNode(output, node, depth);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlNodePtr(n_node, node, 1);
        des_int(n_depth, depth, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_node);
            printf(" %d", n_depth);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpNodeList(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlNodePtr node; /* the node list */
    int n_node;
    int depth; /* the indentation level. */
    int n_depth;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_depth = 0;n_depth < gen_nb_int;n_depth++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        node = gen_xmlNodePtr(n_node, 1);
        depth = gen_int(n_depth, 2);

        xmlDebugDumpNodeList(output, node, depth);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlNodePtr(n_node, node, 1);
        des_int(n_depth, depth, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpNodeList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_node);
            printf(" %d", n_depth);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpOneNode(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlNodePtr node; /* the node */
    int n_node;
    int depth; /* the indentation level. */
    int n_depth;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_depth = 0;n_depth < gen_nb_int;n_depth++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        node = gen_xmlNodePtr(n_node, 1);
        depth = gen_int(n_depth, 2);

        xmlDebugDumpOneNode(output, node, depth);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlNodePtr(n_node, node, 1);
        des_int(n_depth, depth, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpOneNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_node);
            printf(" %d", n_depth);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDebugDumpString(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlChar * str; /* the string */
    int n_str;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        str = gen_const_xmlChar_ptr(n_str, 1);

        xmlDebugDumpString(output, (const xmlChar *)str);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDebugDumpString",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_str);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlLsCountNode(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    int ret_val;
    xmlNodePtr node; /* the node to count */
    int n_node;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);

        ret_val = xmlLsCountNode(node);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlLsCountNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlLsOneNode(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    FILE * output; /* the FILE * for the output */
    int n_output;
    xmlNodePtr node; /* the node to dump */
    int n_node;

    for (n_output = 0;n_output < gen_nb_debug_FILE_ptr;n_output++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        output = gen_debug_FILE_ptr(n_output, 0);
        node = gen_xmlNodePtr(n_node, 1);

        xmlLsOneNode(output, node);
        call_tests++;
        des_debug_FILE_ptr(n_output, output, 0);
        des_xmlNodePtr(n_node, node, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlLsOneNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


#define gen_nb_char_ptr 1
static char * gen_char_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_char_ptr(int no ATTRIBUTE_UNUSED, char * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlShell(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlShellBase(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * arg; /* unused */
    int n_arg;
    xmlNodePtr node; /* a node */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_arg = 0;n_arg < gen_nb_char_ptr;n_arg++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        arg = gen_char_ptr(n_arg, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellBase(ctxt, arg, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_arg, arg, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellBase",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_arg);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellCat(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * arg; /* unused */
    int n_arg;
    xmlNodePtr node; /* a node */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_arg = 0;n_arg < gen_nb_char_ptr;n_arg++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        arg = gen_char_ptr(n_arg, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellCat(ctxt, arg, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_arg, arg, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellCat",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_arg);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellDir(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * arg; /* unused */
    int n_arg;
    xmlNodePtr node; /* a node */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_arg = 0;n_arg < gen_nb_char_ptr;n_arg++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        arg = gen_char_ptr(n_arg, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellDir(ctxt, arg, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_arg, arg, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellDir",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_arg);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellDu(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * arg; /* unused */
    int n_arg;
    xmlNodePtr tree; /* a node defining a subtree */
    int n_tree;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_arg = 0;n_arg < gen_nb_char_ptr;n_arg++) {
    for (n_tree = 0;n_tree < gen_nb_xmlNodePtr;n_tree++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        arg = gen_char_ptr(n_arg, 1);
        tree = gen_xmlNodePtr(n_tree, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellDu(ctxt, arg, tree, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_arg, arg, 1);
        des_xmlNodePtr(n_tree, tree, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellDu",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_arg);
            printf(" %d", n_tree);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellList(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * arg; /* unused */
    int n_arg;
    xmlNodePtr node; /* a node */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_arg = 0;n_arg < gen_nb_char_ptr;n_arg++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        arg = gen_char_ptr(n_arg, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellList(ctxt, arg, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_arg, arg, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_arg);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellLoad(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * filename; /* the file name */
    int n_filename;
    xmlNodePtr node; /* unused */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_filename = 0;n_filename < gen_nb_char_ptr;n_filename++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        filename = gen_char_ptr(n_filename, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellLoad(ctxt, filename, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_filename, filename, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellLoad",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_filename);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellPrintXPathResult(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED)
    int mem_base;
    xmlXPathObjectPtr list; /* a valid result generated by an xpath evaluation */
    int n_list;

    for (n_list = 0;n_list < gen_nb_xmlXPathObjectPtr;n_list++) {
        mem_base = xmlMemBlocks();
        list = gen_xmlXPathObjectPtr(n_list, 0);

        xmlShellPrintXPathResult(list);
        call_tests++;
        des_xmlXPathObjectPtr(n_list, list, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellPrintXPathResult",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_list);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellPwd(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * buffer; /* the output buffer */
    int n_buffer;
    xmlNodePtr node; /* a node */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_buffer = 0;n_buffer < gen_nb_char_ptr;n_buffer++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        buffer = gen_char_ptr(n_buffer, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellPwd(ctxt, buffer, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_buffer, buffer, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellPwd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_buffer);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellSave(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * filename; /* the file name (optional) */
    int n_filename;
    xmlNodePtr node; /* unused */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_filename = 0;n_filename < gen_nb_char_ptr;n_filename++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        filename = gen_char_ptr(n_filename, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellSave(ctxt, filename, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_filename, filename, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellSave",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_filename);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellValidate(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED) && defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * dtd; /* the DTD URI (optional) */
    int n_dtd;
    xmlNodePtr node; /* unused */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_dtd = 0;n_dtd < gen_nb_char_ptr;n_dtd++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        dtd = gen_char_ptr(n_dtd, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellValidate(ctxt, dtd, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_dtd, dtd, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellValidate",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_dtd);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlShellWrite(void) {
    int test_ret = 0;

#if defined(LIBXML_DEBUG_ENABLED) && defined(LIBXML_XPATH_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlShellCtxtPtr ctxt; /* the shell context */
    int n_ctxt;
    char * filename; /* the file name */
    int n_filename;
    xmlNodePtr node; /* a node in the tree */
    int n_node;
    xmlNodePtr node2; /* unused */
    int n_node2;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlShellCtxtPtr;n_ctxt++) {
    for (n_filename = 0;n_filename < gen_nb_char_ptr;n_filename++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_node2 = 0;n_node2 < gen_nb_xmlNodePtr;n_node2++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlShellCtxtPtr(n_ctxt, 0);
        filename = gen_char_ptr(n_filename, 1);
        node = gen_xmlNodePtr(n_node, 2);
        node2 = gen_xmlNodePtr(n_node2, 3);

        ret_val = xmlShellWrite(ctxt, filename, node, node2);
        desret_int(ret_val);
        call_tests++;
        des_xmlShellCtxtPtr(n_ctxt, ctxt, 0);
        des_char_ptr(n_filename, filename, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr(n_node2, node2, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlShellWrite",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_filename);
            printf(" %d", n_node);
            printf(" %d", n_node2);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_debugXML(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing debugXML : 25 of 28 functions ...\n");
    test_ret += test_xmlBoolToText();
    test_ret += test_xmlDebugCheckDocument();
    test_ret += test_xmlDebugDumpAttr();
    test_ret += test_xmlDebugDumpAttrList();
    test_ret += test_xmlDebugDumpDTD();
    test_ret += test_xmlDebugDumpDocument();
    test_ret += test_xmlDebugDumpDocumentHead();
    test_ret += test_xmlDebugDumpEntities();
    test_ret += test_xmlDebugDumpNode();
    test_ret += test_xmlDebugDumpNodeList();
    test_ret += test_xmlDebugDumpOneNode();
    test_ret += test_xmlDebugDumpString();
    test_ret += test_xmlLsCountNode();
    test_ret += test_xmlLsOneNode();
    test_ret += test_xmlShell();
    test_ret += test_xmlShellBase();
    test_ret += test_xmlShellCat();
    test_ret += test_xmlShellDir();
    test_ret += test_xmlShellDu();
    test_ret += test_xmlShellList();
    test_ret += test_xmlShellLoad();
    test_ret += test_xmlShellPrintXPathResult();
    test_ret += test_xmlShellPwd();
    test_ret += test_xmlShellSave();
    test_ret += test_xmlShellValidate();
    test_ret += test_xmlShellWrite();

    if (test_ret != 0)
	printf("Module debugXML: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlDictCleanup(void) {
    int test_ret = 0;

    int mem_base;

        mem_base = xmlMemBlocks();

        xmlDictCleanup();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictCleanup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDictCreate(void) {
    int test_ret = 0;

    int mem_base;
    xmlDictPtr ret_val;

        mem_base = xmlMemBlocks();

        ret_val = xmlDictCreate();
        desret_xmlDictPtr(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictCreate",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDictCreateSub(void) {
    int test_ret = 0;

    int mem_base;
    xmlDictPtr ret_val;
    xmlDictPtr sub; /* an existing dictionnary */
    int n_sub;

    for (n_sub = 0;n_sub < gen_nb_xmlDictPtr;n_sub++) {
        mem_base = xmlMemBlocks();
        sub = gen_xmlDictPtr(n_sub, 0);

        ret_val = xmlDictCreateSub(sub);
        desret_xmlDictPtr(ret_val);
        call_tests++;
        des_xmlDictPtr(n_sub, sub, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictCreateSub",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sub);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDictExists(void) {
    int test_ret = 0;

    int mem_base;
    const xmlChar * ret_val;
    xmlDictPtr dict; /* the dictionnary */
    int n_dict;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    int len; /* the length of the name, if -1 it is recomputed */
    int n_len;

    for (n_dict = 0;n_dict < gen_nb_xmlDictPtr;n_dict++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        dict = gen_xmlDictPtr(n_dict, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlDictExists(dict, (const xmlChar *)name, len);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDictPtr(n_dict, dict, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictExists",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dict);
            printf(" %d", n_name);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDictLookup(void) {
    int test_ret = 0;

    int mem_base;
    const xmlChar * ret_val;
    xmlDictPtr dict; /* the dictionnary */
    int n_dict;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    int len; /* the length of the name, if -1 it is recomputed */
    int n_len;

    for (n_dict = 0;n_dict < gen_nb_xmlDictPtr;n_dict++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        dict = gen_xmlDictPtr(n_dict, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlDictLookup(dict, (const xmlChar *)name, len);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDictPtr(n_dict, dict, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictLookup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dict);
            printf(" %d", n_name);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDictOwns(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDictPtr dict; /* the dictionnary */
    int n_dict;
    xmlChar * str; /* the string */
    int n_str;

    for (n_dict = 0;n_dict < gen_nb_xmlDictPtr;n_dict++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        dict = gen_xmlDictPtr(n_dict, 0);
        str = gen_const_xmlChar_ptr(n_str, 1);

        ret_val = xmlDictOwns(dict, (const xmlChar *)str);
        desret_int(ret_val);
        call_tests++;
        des_xmlDictPtr(n_dict, dict, 0);
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictOwns",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dict);
            printf(" %d", n_str);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDictQLookup(void) {
    int test_ret = 0;

    int mem_base;
    const xmlChar * ret_val;
    xmlDictPtr dict; /* the dictionnary */
    int n_dict;
    xmlChar * prefix; /* the prefix */
    int n_prefix;
    xmlChar * name; /* the name */
    int n_name;

    for (n_dict = 0;n_dict < gen_nb_xmlDictPtr;n_dict++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        dict = gen_xmlDictPtr(n_dict, 0);
        prefix = gen_const_xmlChar_ptr(n_prefix, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);

        ret_val = xmlDictQLookup(dict, (const xmlChar *)prefix, (const xmlChar *)name);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDictPtr(n_dict, dict, 0);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictQLookup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dict);
            printf(" %d", n_prefix);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDictReference(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDictPtr dict; /* the dictionnary */
    int n_dict;

    for (n_dict = 0;n_dict < gen_nb_xmlDictPtr;n_dict++) {
        mem_base = xmlMemBlocks();
        dict = gen_xmlDictPtr(n_dict, 0);

        ret_val = xmlDictReference(dict);
        xmlDictFree(dict);
        desret_int(ret_val);
        call_tests++;
        des_xmlDictPtr(n_dict, dict, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictReference",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dict);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDictSize(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDictPtr dict; /* the dictionnary */
    int n_dict;

    for (n_dict = 0;n_dict < gen_nb_xmlDictPtr;n_dict++) {
        mem_base = xmlMemBlocks();
        dict = gen_xmlDictPtr(n_dict, 0);

        ret_val = xmlDictSize(dict);
        desret_int(ret_val);
        call_tests++;
        des_xmlDictPtr(n_dict, dict, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDictSize",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dict);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}

static int
test_dict(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing dict : 9 of 10 functions ...\n");
    test_ret += test_xmlDictCleanup();
    test_ret += test_xmlDictCreate();
    test_ret += test_xmlDictCreateSub();
    test_ret += test_xmlDictExists();
    test_ret += test_xmlDictLookup();
    test_ret += test_xmlDictOwns();
    test_ret += test_xmlDictQLookup();
    test_ret += test_xmlDictReference();
    test_ret += test_xmlDictSize();

    if (test_ret != 0)
	printf("Module dict: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_UTF8Toisolat1(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
#ifdef LIBXML_OUTPUT_ENABLED
    int mem_base;
    int ret_val;
    unsigned char * out; /* a pointer to an array of bytes to store the result */
    int n_out;
    int * outlen; /* the length of @out */
    int n_outlen;
    unsigned char * in; /* a pointer to an array of UTF-8 chars */
    int n_in;
    int * inlen; /* the length of @in */
    int n_inlen;

    for (n_out = 0;n_out < gen_nb_unsigned_char_ptr;n_out++) {
    for (n_outlen = 0;n_outlen < gen_nb_int_ptr;n_outlen++) {
    for (n_in = 0;n_in < gen_nb_const_unsigned_char_ptr;n_in++) {
    for (n_inlen = 0;n_inlen < gen_nb_int_ptr;n_inlen++) {
        mem_base = xmlMemBlocks();
        out = gen_unsigned_char_ptr(n_out, 0);
        outlen = gen_int_ptr(n_outlen, 1);
        in = gen_const_unsigned_char_ptr(n_in, 2);
        inlen = gen_int_ptr(n_inlen, 3);

        ret_val = UTF8Toisolat1(out, outlen, (const unsigned char *)in, inlen);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_char_ptr(n_out, out, 0);
        des_int_ptr(n_outlen, outlen, 1);
        des_const_unsigned_char_ptr(n_in, (const unsigned char *)in, 2);
        des_int_ptr(n_inlen, inlen, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in UTF8Toisolat1",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_outlen);
            printf(" %d", n_in);
            printf(" %d", n_inlen);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_isolat1ToUTF8(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    unsigned char * out; /* a pointer to an array of bytes to store the result */
    int n_out;
    int * outlen; /* the length of @out */
    int n_outlen;
    unsigned char * in; /* a pointer to an array of ISO Latin 1 chars */
    int n_in;
    int * inlen; /* the length of @in */
    int n_inlen;

    for (n_out = 0;n_out < gen_nb_unsigned_char_ptr;n_out++) {
    for (n_outlen = 0;n_outlen < gen_nb_int_ptr;n_outlen++) {
    for (n_in = 0;n_in < gen_nb_const_unsigned_char_ptr;n_in++) {
    for (n_inlen = 0;n_inlen < gen_nb_int_ptr;n_inlen++) {
        mem_base = xmlMemBlocks();
        out = gen_unsigned_char_ptr(n_out, 0);
        outlen = gen_int_ptr(n_outlen, 1);
        in = gen_const_unsigned_char_ptr(n_in, 2);
        inlen = gen_int_ptr(n_inlen, 3);

        ret_val = isolat1ToUTF8(out, outlen, (const unsigned char *)in, inlen);
        desret_int(ret_val);
        call_tests++;
        des_unsigned_char_ptr(n_out, out, 0);
        des_int_ptr(n_outlen, outlen, 1);
        des_const_unsigned_char_ptr(n_in, (const unsigned char *)in, 2);
        des_int_ptr(n_inlen, inlen, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in isolat1ToUTF8",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_outlen);
            printf(" %d", n_in);
            printf(" %d", n_inlen);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlAddEncodingAlias(void) {
    int test_ret = 0;

    int ret_val;
    char * name; /* the encoding name as parsed, in UTF-8 format (ASCII actually) */
    int n_name;
    char * alias; /* the alias name as parsed, in UTF-8 format (ASCII actually) */
    int n_alias;

    for (n_name = 0;n_name < gen_nb_const_char_ptr;n_name++) {
    for (n_alias = 0;n_alias < gen_nb_const_char_ptr;n_alias++) {
        name = gen_const_char_ptr(n_name, 0);
        alias = gen_const_char_ptr(n_alias, 1);

        ret_val = xmlAddEncodingAlias((const char *)name, (const char *)alias);
        desret_int(ret_val);
        call_tests++;
        des_const_char_ptr(n_name, (const char *)name, 0);
        des_const_char_ptr(n_alias, (const char *)alias, 1);
        xmlResetLastError();
    }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlCharEncodingHandler_ptr 1
static xmlCharEncodingHandler * gen_xmlCharEncodingHandler_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlCharEncodingHandler_ptr(int no ATTRIBUTE_UNUSED, xmlCharEncodingHandler * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlCharEncCloseFunc(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlCharEncodingHandler * handler; /* char enconding transformation data structure */
    int n_handler;

    for (n_handler = 0;n_handler < gen_nb_xmlCharEncodingHandler_ptr;n_handler++) {
        mem_base = xmlMemBlocks();
        handler = gen_xmlCharEncodingHandler_ptr(n_handler, 0);

        ret_val = xmlCharEncCloseFunc(handler);
        desret_int(ret_val);
        call_tests++;
        des_xmlCharEncodingHandler_ptr(n_handler, handler, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCharEncCloseFunc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_handler);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCharEncFirstLine(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlCharEncodingHandler * handler; /* char enconding transformation data structure */
    int n_handler;
    xmlBufferPtr out; /* an xmlBuffer for the output. */
    int n_out;
    xmlBufferPtr in; /* an xmlBuffer for the input */
    int n_in;

    for (n_handler = 0;n_handler < gen_nb_xmlCharEncodingHandler_ptr;n_handler++) {
    for (n_out = 0;n_out < gen_nb_xmlBufferPtr;n_out++) {
    for (n_in = 0;n_in < gen_nb_xmlBufferPtr;n_in++) {
        mem_base = xmlMemBlocks();
        handler = gen_xmlCharEncodingHandler_ptr(n_handler, 0);
        out = gen_xmlBufferPtr(n_out, 1);
        in = gen_xmlBufferPtr(n_in, 2);

        ret_val = xmlCharEncFirstLine(handler, out, in);
        desret_int(ret_val);
        call_tests++;
        des_xmlCharEncodingHandler_ptr(n_handler, handler, 0);
        des_xmlBufferPtr(n_out, out, 1);
        des_xmlBufferPtr(n_in, in, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCharEncFirstLine",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_handler);
            printf(" %d", n_out);
            printf(" %d", n_in);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCharEncInFunc(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlCharEncodingHandler * handler; /* char encoding transformation data structure */
    int n_handler;
    xmlBufferPtr out; /* an xmlBuffer for the output. */
    int n_out;
    xmlBufferPtr in; /* an xmlBuffer for the input */
    int n_in;

    for (n_handler = 0;n_handler < gen_nb_xmlCharEncodingHandler_ptr;n_handler++) {
    for (n_out = 0;n_out < gen_nb_xmlBufferPtr;n_out++) {
    for (n_in = 0;n_in < gen_nb_xmlBufferPtr;n_in++) {
        mem_base = xmlMemBlocks();
        handler = gen_xmlCharEncodingHandler_ptr(n_handler, 0);
        out = gen_xmlBufferPtr(n_out, 1);
        in = gen_xmlBufferPtr(n_in, 2);

        ret_val = xmlCharEncInFunc(handler, out, in);
        desret_int(ret_val);
        call_tests++;
        des_xmlCharEncodingHandler_ptr(n_handler, handler, 0);
        des_xmlBufferPtr(n_out, out, 1);
        des_xmlBufferPtr(n_in, in, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCharEncInFunc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_handler);
            printf(" %d", n_out);
            printf(" %d", n_in);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCharEncOutFunc(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlCharEncodingHandler * handler; /* char enconding transformation data structure */
    int n_handler;
    xmlBufferPtr out; /* an xmlBuffer for the output. */
    int n_out;
    xmlBufferPtr in; /* an xmlBuffer for the input */
    int n_in;

    for (n_handler = 0;n_handler < gen_nb_xmlCharEncodingHandler_ptr;n_handler++) {
    for (n_out = 0;n_out < gen_nb_xmlBufferPtr;n_out++) {
    for (n_in = 0;n_in < gen_nb_xmlBufferPtr;n_in++) {
        mem_base = xmlMemBlocks();
        handler = gen_xmlCharEncodingHandler_ptr(n_handler, 0);
        out = gen_xmlBufferPtr(n_out, 1);
        in = gen_xmlBufferPtr(n_in, 2);

        ret_val = xmlCharEncOutFunc(handler, out, in);
        desret_int(ret_val);
        call_tests++;
        des_xmlCharEncodingHandler_ptr(n_handler, handler, 0);
        des_xmlBufferPtr(n_out, out, 1);
        des_xmlBufferPtr(n_in, in, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCharEncOutFunc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_handler);
            printf(" %d", n_out);
            printf(" %d", n_in);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCleanupCharEncodingHandlers(void) {
    int test_ret = 0;



        xmlCleanupCharEncodingHandlers();
        call_tests++;
        xmlResetLastError();
    function_tests++;

    return(test_ret);
}


static int
test_xmlCleanupEncodingAliases(void) {
    int test_ret = 0;

    int mem_base;

        mem_base = xmlMemBlocks();

        xmlCleanupEncodingAliases();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCleanupEncodingAliases",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDelEncodingAlias(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    char * alias; /* the alias name as parsed, in UTF-8 format (ASCII actually) */
    int n_alias;

    for (n_alias = 0;n_alias < gen_nb_const_char_ptr;n_alias++) {
        mem_base = xmlMemBlocks();
        alias = gen_const_char_ptr(n_alias, 0);

        ret_val = xmlDelEncodingAlias((const char *)alias);
        desret_int(ret_val);
        call_tests++;
        des_const_char_ptr(n_alias, (const char *)alias, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDelEncodingAlias",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_alias);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDetectCharEncoding(void) {
    int test_ret = 0;

    int mem_base;
    xmlCharEncoding ret_val;
    unsigned char * in; /* a pointer to the first bytes of the XML entity, must be at least 2 bytes long (at least 4 if encoding is UTF4 variant). */
    int n_in;
    int len; /* pointer to the length of the buffer */
    int n_len;

    for (n_in = 0;n_in < gen_nb_const_unsigned_char_ptr;n_in++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        in = gen_const_unsigned_char_ptr(n_in, 0);
        len = gen_int(n_len, 1);

        ret_val = xmlDetectCharEncoding((const unsigned char *)in, len);
        desret_xmlCharEncoding(ret_val);
        call_tests++;
        des_const_unsigned_char_ptr(n_in, (const unsigned char *)in, 0);
        des_int(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDetectCharEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_in);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlFindCharEncodingHandler(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlGetCharEncodingHandler(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlGetCharEncodingName(void) {
    int test_ret = 0;

    int mem_base;
    const char * ret_val;
    xmlCharEncoding enc; /* the encoding */
    int n_enc;

    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        enc = gen_xmlCharEncoding(n_enc, 0);

        ret_val = xmlGetCharEncodingName(enc);
        desret_const_char_ptr(ret_val);
        call_tests++;
        des_xmlCharEncoding(n_enc, enc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetCharEncodingName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetEncodingAlias(void) {
    int test_ret = 0;

    int mem_base;
    const char * ret_val;
    char * alias; /* the alias name as parsed, in UTF-8 format (ASCII actually) */
    int n_alias;

    for (n_alias = 0;n_alias < gen_nb_const_char_ptr;n_alias++) {
        mem_base = xmlMemBlocks();
        alias = gen_const_char_ptr(n_alias, 0);

        ret_val = xmlGetEncodingAlias((const char *)alias);
        desret_const_char_ptr(ret_val);
        call_tests++;
        des_const_char_ptr(n_alias, (const char *)alias, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetEncodingAlias",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_alias);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlInitCharEncodingHandlers(void) {
    int test_ret = 0;



        xmlInitCharEncodingHandlers();
        call_tests++;
        xmlResetLastError();
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewCharEncodingHandler(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlParseCharEncoding(void) {
    int test_ret = 0;

    int mem_base;
    xmlCharEncoding ret_val;
    char * name; /* the encoding name as parsed, in UTF-8 format (ASCII actually) */
    int n_name;

    for (n_name = 0;n_name < gen_nb_const_char_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        name = gen_const_char_ptr(n_name, 0);

        ret_val = xmlParseCharEncoding((const char *)name);
        desret_xmlCharEncoding(ret_val);
        call_tests++;
        des_const_char_ptr(n_name, (const char *)name, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseCharEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlCharEncodingHandlerPtr 1
static xmlCharEncodingHandlerPtr gen_xmlCharEncodingHandlerPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlCharEncodingHandlerPtr(int no ATTRIBUTE_UNUSED, xmlCharEncodingHandlerPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlRegisterCharEncodingHandler(void) {
    int test_ret = 0;

    int mem_base;
    xmlCharEncodingHandlerPtr handler; /* the xmlCharEncodingHandlerPtr handler block */
    int n_handler;

    for (n_handler = 0;n_handler < gen_nb_xmlCharEncodingHandlerPtr;n_handler++) {
        mem_base = xmlMemBlocks();
        handler = gen_xmlCharEncodingHandlerPtr(n_handler, 0);

        xmlRegisterCharEncodingHandler(handler);
        call_tests++;
        des_xmlCharEncodingHandlerPtr(n_handler, handler, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegisterCharEncodingHandler",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_handler);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}

static int
test_encoding(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing encoding : 16 of 19 functions ...\n");
    test_ret += test_UTF8Toisolat1();
    test_ret += test_isolat1ToUTF8();
    test_ret += test_xmlAddEncodingAlias();
    test_ret += test_xmlCharEncCloseFunc();
    test_ret += test_xmlCharEncFirstLine();
    test_ret += test_xmlCharEncInFunc();
    test_ret += test_xmlCharEncOutFunc();
    test_ret += test_xmlCleanupCharEncodingHandlers();
    test_ret += test_xmlCleanupEncodingAliases();
    test_ret += test_xmlDelEncodingAlias();
    test_ret += test_xmlDetectCharEncoding();
    test_ret += test_xmlFindCharEncodingHandler();
    test_ret += test_xmlGetCharEncodingHandler();
    test_ret += test_xmlGetCharEncodingName();
    test_ret += test_xmlGetEncodingAlias();
    test_ret += test_xmlInitCharEncodingHandlers();
    test_ret += test_xmlNewCharEncodingHandler();
    test_ret += test_xmlParseCharEncoding();
    test_ret += test_xmlRegisterCharEncodingHandler();

    if (test_ret != 0)
	printf("Module encoding: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlAddDocEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * name; /* the entity name */
    int n_name;
    int type; /* the entity type XML_xxx_yyy_ENTITY */
    int n_type;
    xmlChar * ExternalID; /* the entity external ID if available */
    int n_ExternalID;
    xmlChar * SystemID; /* the entity system ID if available */
    int n_SystemID;
    xmlChar * content; /* the entity content */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_type = 0;n_type < gen_nb_int;n_type++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        type = gen_int(n_type, 2);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 3);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 4);
        content = gen_const_xmlChar_ptr(n_content, 5);

        ret_val = xmlAddDocEntity(doc, (const xmlChar *)name, type, (const xmlChar *)ExternalID, (const xmlChar *)SystemID, (const xmlChar *)content);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_int(n_type, type, 2);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 3);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 4);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddDocEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_type);
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlAddDtdEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * name; /* the entity name */
    int n_name;
    int type; /* the entity type XML_xxx_yyy_ENTITY */
    int n_type;
    xmlChar * ExternalID; /* the entity external ID if available */
    int n_ExternalID;
    xmlChar * SystemID; /* the entity system ID if available */
    int n_SystemID;
    xmlChar * content; /* the entity content */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_type = 0;n_type < gen_nb_int;n_type++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        type = gen_int(n_type, 2);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 3);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 4);
        content = gen_const_xmlChar_ptr(n_content, 5);

        ret_val = xmlAddDtdEntity(doc, (const xmlChar *)name, type, (const xmlChar *)ExternalID, (const xmlChar *)SystemID, (const xmlChar *)content);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_int(n_type, type, 2);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 3);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 4);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddDtdEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_type);
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCleanupPredefinedEntities(void) {
    int test_ret = 0;

#if defined(LIBXML_LEGACY_ENABLED)
#ifdef LIBXML_LEGACY_ENABLED
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlCleanupPredefinedEntities();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCleanupPredefinedEntities",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif
#endif

    return(test_ret);
}


#define gen_nb_xmlEntitiesTablePtr 1
static xmlEntitiesTablePtr gen_xmlEntitiesTablePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlEntitiesTablePtr(int no ATTRIBUTE_UNUSED, xmlEntitiesTablePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlCopyEntitiesTable(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlCreateEntitiesTable(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlDumpEntitiesTable(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* An XML buffer. */
    int n_buf;
    xmlEntitiesTablePtr table; /* An entity table */
    int n_table;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_table = 0;n_table < gen_nb_xmlEntitiesTablePtr;n_table++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        table = gen_xmlEntitiesTablePtr(n_table, 1);

        xmlDumpEntitiesTable(buf, table);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlEntitiesTablePtr(n_table, table, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDumpEntitiesTable",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_table);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


#define gen_nb_xmlEntityPtr 1
static xmlEntityPtr gen_xmlEntityPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlEntityPtr(int no ATTRIBUTE_UNUSED, xmlEntityPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlDumpEntityDecl(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* An XML buffer. */
    int n_buf;
    xmlEntityPtr ent; /* An entity table */
    int n_ent;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_ent = 0;n_ent < gen_nb_xmlEntityPtr;n_ent++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        ent = gen_xmlEntityPtr(n_ent, 1);

        xmlDumpEntityDecl(buf, ent);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlEntityPtr(n_ent, ent, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDumpEntityDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_ent);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlEncodeEntitiesReentrant(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlDocPtr doc; /* the document containing the string */
    int n_doc;
    xmlChar * input; /* A string to convert to XML. */
    int n_input;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_input = 0;n_input < gen_nb_const_xmlChar_ptr;n_input++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        input = gen_const_xmlChar_ptr(n_input, 1);

        ret_val = xmlEncodeEntitiesReentrant(doc, (const xmlChar *)input);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_input, (const xmlChar *)input, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlEncodeEntitiesReentrant",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_input);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlEncodeSpecialChars(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlDocPtr doc; /* the document containing the string */
    int n_doc;
    xmlChar * input; /* A string to convert to XML. */
    int n_input;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_input = 0;n_input < gen_nb_const_xmlChar_ptr;n_input++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        input = gen_const_xmlChar_ptr(n_input, 1);

        ret_val = xmlEncodeSpecialChars(doc, (const xmlChar *)input);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_input, (const xmlChar *)input, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlEncodeSpecialChars",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_input);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetDocEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    xmlDocPtr doc; /* the document referencing the entity */
    int n_doc;
    xmlChar * name; /* the entity name */
    int n_name;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlGetDocEntity(doc, (const xmlChar *)name);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetDocEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetDtdEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    xmlDocPtr doc; /* the document referencing the entity */
    int n_doc;
    xmlChar * name; /* the entity name */
    int n_name;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlGetDtdEntity(doc, (const xmlChar *)name);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetDtdEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetParameterEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    xmlDocPtr doc; /* the document referencing the entity */
    int n_doc;
    xmlChar * name; /* the entity name */
    int n_name;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlGetParameterEntity(doc, (const xmlChar *)name);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetParameterEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetPredefinedEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    xmlChar * name; /* the entity name */
    int n_name;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);

        ret_val = xmlGetPredefinedEntity((const xmlChar *)name);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetPredefinedEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlInitializePredefinedEntities(void) {
    int test_ret = 0;

#if defined(LIBXML_LEGACY_ENABLED)
#ifdef LIBXML_LEGACY_ENABLED
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlInitializePredefinedEntities();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlInitializePredefinedEntities",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlNewEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlEntityPtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * name; /* the entity name */
    int n_name;
    int type; /* the entity type XML_xxx_yyy_ENTITY */
    int n_type;
    xmlChar * ExternalID; /* the entity external ID if available */
    int n_ExternalID;
    xmlChar * SystemID; /* the entity system ID if available */
    int n_SystemID;
    xmlChar * content; /* the entity content */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_type = 0;n_type < gen_nb_int;n_type++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        type = gen_int(n_type, 2);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 3);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 4);
        content = gen_const_xmlChar_ptr(n_content, 5);

        ret_val = xmlNewEntity(doc, (const xmlChar *)name, type, (const xmlChar *)ExternalID, (const xmlChar *)SystemID, (const xmlChar *)content);
        desret_xmlEntityPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_int(n_type, type, 2);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 3);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 4);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_type);
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}

static int
test_entities(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing entities : 13 of 17 functions ...\n");
    test_ret += test_xmlAddDocEntity();
    test_ret += test_xmlAddDtdEntity();
    test_ret += test_xmlCleanupPredefinedEntities();
    test_ret += test_xmlCopyEntitiesTable();
    test_ret += test_xmlCreateEntitiesTable();
    test_ret += test_xmlDumpEntitiesTable();
    test_ret += test_xmlDumpEntityDecl();
    test_ret += test_xmlEncodeEntitiesReentrant();
    test_ret += test_xmlEncodeSpecialChars();
    test_ret += test_xmlGetDocEntity();
    test_ret += test_xmlGetDtdEntity();
    test_ret += test_xmlGetParameterEntity();
    test_ret += test_xmlGetPredefinedEntity();
    test_ret += test_xmlInitializePredefinedEntities();
    test_ret += test_xmlNewEntity();

    if (test_ret != 0)
	printf("Module entities: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlHashAddEntry(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    void * userdata; /* a pointer to the userdata */
    int n_userdata;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_userdata = 0;n_userdata < gen_nb_userdata;n_userdata++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        userdata = gen_userdata(n_userdata, 2);

        ret_val = xmlHashAddEntry(table, (const xmlChar *)name, userdata);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_userdata(n_userdata, userdata, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashAddEntry",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_userdata);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashAddEntry2(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;
    void * userdata; /* a pointer to the userdata */
    int n_userdata;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
    for (n_userdata = 0;n_userdata < gen_nb_userdata;n_userdata++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        name2 = gen_const_xmlChar_ptr(n_name2, 2);
        userdata = gen_userdata(n_userdata, 3);

        ret_val = xmlHashAddEntry2(table, (const xmlChar *)name, (const xmlChar *)name2, userdata);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 2);
        des_userdata(n_userdata, userdata, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashAddEntry2",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_name2);
            printf(" %d", n_userdata);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashAddEntry3(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;
    xmlChar * name3; /* a third name of the userdata */
    int n_name3;
    void * userdata; /* a pointer to the userdata */
    int n_userdata;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
    for (n_name3 = 0;n_name3 < gen_nb_const_xmlChar_ptr;n_name3++) {
    for (n_userdata = 0;n_userdata < gen_nb_userdata;n_userdata++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        name2 = gen_const_xmlChar_ptr(n_name2, 2);
        name3 = gen_const_xmlChar_ptr(n_name3, 3);
        userdata = gen_userdata(n_userdata, 4);

        ret_val = xmlHashAddEntry3(table, (const xmlChar *)name, (const xmlChar *)name2, (const xmlChar *)name3, userdata);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 2);
        des_const_xmlChar_ptr(n_name3, (const xmlChar *)name3, 3);
        des_userdata(n_userdata, userdata, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashAddEntry3",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_name2);
            printf(" %d", n_name3);
            printf(" %d", n_userdata);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashCopy(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlHashCreate(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlHashCreateDict(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlHashLookup(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlHashLookup(table, (const xmlChar *)name);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashLookup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashLookup2(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        name2 = gen_const_xmlChar_ptr(n_name2, 2);

        ret_val = xmlHashLookup2(table, (const xmlChar *)name, (const xmlChar *)name2);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashLookup2",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_name2);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashLookup3(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;
    xmlChar * name3; /* a third name of the userdata */
    int n_name3;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
    for (n_name3 = 0;n_name3 < gen_nb_const_xmlChar_ptr;n_name3++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        name2 = gen_const_xmlChar_ptr(n_name2, 2);
        name3 = gen_const_xmlChar_ptr(n_name3, 3);

        ret_val = xmlHashLookup3(table, (const xmlChar *)name, (const xmlChar *)name2, (const xmlChar *)name3);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 2);
        des_const_xmlChar_ptr(n_name3, (const xmlChar *)name3, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashLookup3",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_name2);
            printf(" %d", n_name3);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashQLookup(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * prefix; /* the prefix of the userdata */
    int n_prefix;
    xmlChar * name; /* the name of the userdata */
    int n_name;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        prefix = gen_const_xmlChar_ptr(n_prefix, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);

        ret_val = xmlHashQLookup(table, (const xmlChar *)prefix, (const xmlChar *)name);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashQLookup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_prefix);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashQLookup2(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * prefix; /* the prefix of the userdata */
    int n_prefix;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * prefix2; /* the second prefix of the userdata */
    int n_prefix2;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_prefix2 = 0;n_prefix2 < gen_nb_const_xmlChar_ptr;n_prefix2++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        prefix = gen_const_xmlChar_ptr(n_prefix, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        prefix2 = gen_const_xmlChar_ptr(n_prefix2, 3);
        name2 = gen_const_xmlChar_ptr(n_name2, 4);

        ret_val = xmlHashQLookup2(table, (const xmlChar *)prefix, (const xmlChar *)name, (const xmlChar *)prefix2, (const xmlChar *)name2);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_prefix2, (const xmlChar *)prefix2, 3);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashQLookup2",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_prefix);
            printf(" %d", n_name);
            printf(" %d", n_prefix2);
            printf(" %d", n_name2);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashQLookup3(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * prefix; /* the prefix of the userdata */
    int n_prefix;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * prefix2; /* the second prefix of the userdata */
    int n_prefix2;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;
    xmlChar * prefix3; /* the third prefix of the userdata */
    int n_prefix3;
    xmlChar * name3; /* a third name of the userdata */
    int n_name3;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_prefix2 = 0;n_prefix2 < gen_nb_const_xmlChar_ptr;n_prefix2++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
    for (n_prefix3 = 0;n_prefix3 < gen_nb_const_xmlChar_ptr;n_prefix3++) {
    for (n_name3 = 0;n_name3 < gen_nb_const_xmlChar_ptr;n_name3++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        prefix = gen_const_xmlChar_ptr(n_prefix, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        prefix2 = gen_const_xmlChar_ptr(n_prefix2, 3);
        name2 = gen_const_xmlChar_ptr(n_name2, 4);
        prefix3 = gen_const_xmlChar_ptr(n_prefix3, 5);
        name3 = gen_const_xmlChar_ptr(n_name3, 6);

        ret_val = xmlHashQLookup3(table, (const xmlChar *)prefix, (const xmlChar *)name, (const xmlChar *)prefix2, (const xmlChar *)name2, (const xmlChar *)prefix3, (const xmlChar *)name3);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_prefix2, (const xmlChar *)prefix2, 3);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 4);
        des_const_xmlChar_ptr(n_prefix3, (const xmlChar *)prefix3, 5);
        des_const_xmlChar_ptr(n_name3, (const xmlChar *)name3, 6);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashQLookup3",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_prefix);
            printf(" %d", n_name);
            printf(" %d", n_prefix2);
            printf(" %d", n_name2);
            printf(" %d", n_prefix3);
            printf(" %d", n_name3);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashRemoveEntry(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlHashDeallocator f; /* the deallocator function for removed item (if any) */
    int n_f;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_f = 0;n_f < gen_nb_xmlHashDeallocator;n_f++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        f = gen_xmlHashDeallocator(n_f, 2);

        ret_val = xmlHashRemoveEntry(table, (const xmlChar *)name, f);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_xmlHashDeallocator(n_f, f, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashRemoveEntry",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_f);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashRemoveEntry2(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;
    xmlHashDeallocator f; /* the deallocator function for removed item (if any) */
    int n_f;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
    for (n_f = 0;n_f < gen_nb_xmlHashDeallocator;n_f++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        name2 = gen_const_xmlChar_ptr(n_name2, 2);
        f = gen_xmlHashDeallocator(n_f, 3);

        ret_val = xmlHashRemoveEntry2(table, (const xmlChar *)name, (const xmlChar *)name2, f);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 2);
        des_xmlHashDeallocator(n_f, f, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashRemoveEntry2",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_name2);
            printf(" %d", n_f);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashRemoveEntry3(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;
    xmlChar * name3; /* a third name of the userdata */
    int n_name3;
    xmlHashDeallocator f; /* the deallocator function for removed item (if any) */
    int n_f;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
    for (n_name3 = 0;n_name3 < gen_nb_const_xmlChar_ptr;n_name3++) {
    for (n_f = 0;n_f < gen_nb_xmlHashDeallocator;n_f++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        name2 = gen_const_xmlChar_ptr(n_name2, 2);
        name3 = gen_const_xmlChar_ptr(n_name3, 3);
        f = gen_xmlHashDeallocator(n_f, 4);

        ret_val = xmlHashRemoveEntry3(table, (const xmlChar *)name, (const xmlChar *)name2, (const xmlChar *)name3, f);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 2);
        des_const_xmlChar_ptr(n_name3, (const xmlChar *)name3, 3);
        des_xmlHashDeallocator(n_f, f, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashRemoveEntry3",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_name2);
            printf(" %d", n_name3);
            printf(" %d", n_f);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashScan(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlHashScan3(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlHashScanFull(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlHashScanFull3(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlHashSize(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);

        ret_val = xmlHashSize(table);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashSize",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashUpdateEntry(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    void * userdata; /* a pointer to the userdata */
    int n_userdata;
    xmlHashDeallocator f; /* the deallocator function for replaced item (if any) */
    int n_f;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_userdata = 0;n_userdata < gen_nb_userdata;n_userdata++) {
    for (n_f = 0;n_f < gen_nb_xmlHashDeallocator;n_f++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        userdata = gen_userdata(n_userdata, 2);
        f = gen_xmlHashDeallocator(n_f, 3);

        ret_val = xmlHashUpdateEntry(table, (const xmlChar *)name, userdata, f);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_userdata(n_userdata, userdata, 2);
        des_xmlHashDeallocator(n_f, f, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashUpdateEntry",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_userdata);
            printf(" %d", n_f);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashUpdateEntry2(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;
    void * userdata; /* a pointer to the userdata */
    int n_userdata;
    xmlHashDeallocator f; /* the deallocator function for replaced item (if any) */
    int n_f;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
    for (n_userdata = 0;n_userdata < gen_nb_userdata;n_userdata++) {
    for (n_f = 0;n_f < gen_nb_xmlHashDeallocator;n_f++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        name2 = gen_const_xmlChar_ptr(n_name2, 2);
        userdata = gen_userdata(n_userdata, 3);
        f = gen_xmlHashDeallocator(n_f, 4);

        ret_val = xmlHashUpdateEntry2(table, (const xmlChar *)name, (const xmlChar *)name2, userdata, f);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 2);
        des_userdata(n_userdata, userdata, 3);
        des_xmlHashDeallocator(n_f, f, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashUpdateEntry2",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_name2);
            printf(" %d", n_userdata);
            printf(" %d", n_f);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHashUpdateEntry3(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlHashTablePtr table; /* the hash table */
    int n_table;
    xmlChar * name; /* the name of the userdata */
    int n_name;
    xmlChar * name2; /* a second name of the userdata */
    int n_name2;
    xmlChar * name3; /* a third name of the userdata */
    int n_name3;
    void * userdata; /* a pointer to the userdata */
    int n_userdata;
    xmlHashDeallocator f; /* the deallocator function for replaced item (if any) */
    int n_f;

    for (n_table = 0;n_table < gen_nb_xmlHashTablePtr;n_table++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_name2 = 0;n_name2 < gen_nb_const_xmlChar_ptr;n_name2++) {
    for (n_name3 = 0;n_name3 < gen_nb_const_xmlChar_ptr;n_name3++) {
    for (n_userdata = 0;n_userdata < gen_nb_userdata;n_userdata++) {
    for (n_f = 0;n_f < gen_nb_xmlHashDeallocator;n_f++) {
        mem_base = xmlMemBlocks();
        table = gen_xmlHashTablePtr(n_table, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        name2 = gen_const_xmlChar_ptr(n_name2, 2);
        name3 = gen_const_xmlChar_ptr(n_name3, 3);
        userdata = gen_userdata(n_userdata, 4);
        f = gen_xmlHashDeallocator(n_f, 5);

        ret_val = xmlHashUpdateEntry3(table, (const xmlChar *)name, (const xmlChar *)name2, (const xmlChar *)name3, userdata, f);
        desret_int(ret_val);
        call_tests++;
        des_xmlHashTablePtr(n_table, table, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_name2, (const xmlChar *)name2, 2);
        des_const_xmlChar_ptr(n_name3, (const xmlChar *)name3, 3);
        des_userdata(n_userdata, userdata, 4);
        des_xmlHashDeallocator(n_f, f, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHashUpdateEntry3",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_table);
            printf(" %d", n_name);
            printf(" %d", n_name2);
            printf(" %d", n_name3);
            printf(" %d", n_userdata);
            printf(" %d", n_f);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}

static int
test_hash(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing hash : 16 of 24 functions ...\n");
    test_ret += test_xmlHashAddEntry();
    test_ret += test_xmlHashAddEntry2();
    test_ret += test_xmlHashAddEntry3();
    test_ret += test_xmlHashCopy();
    test_ret += test_xmlHashCreate();
    test_ret += test_xmlHashCreateDict();
    test_ret += test_xmlHashLookup();
    test_ret += test_xmlHashLookup2();
    test_ret += test_xmlHashLookup3();
    test_ret += test_xmlHashQLookup();
    test_ret += test_xmlHashQLookup2();
    test_ret += test_xmlHashQLookup3();
    test_ret += test_xmlHashRemoveEntry();
    test_ret += test_xmlHashRemoveEntry2();
    test_ret += test_xmlHashRemoveEntry3();
    test_ret += test_xmlHashScan();
    test_ret += test_xmlHashScan3();
    test_ret += test_xmlHashScanFull();
    test_ret += test_xmlHashScanFull3();
    test_ret += test_xmlHashSize();
    test_ret += test_xmlHashUpdateEntry();
    test_ret += test_xmlHashUpdateEntry2();
    test_ret += test_xmlHashUpdateEntry3();

    if (test_ret != 0)
	printf("Module hash: %d errors\n", test_ret);
    return(test_ret);
}

#define gen_nb_xmlLinkPtr 1
static xmlLinkPtr gen_xmlLinkPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlLinkPtr(int no ATTRIBUTE_UNUSED, xmlLinkPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlLinkGetData(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlLinkPtr lk; /* a link */
    int n_lk;

    for (n_lk = 0;n_lk < gen_nb_xmlLinkPtr;n_lk++) {
        mem_base = xmlMemBlocks();
        lk = gen_xmlLinkPtr(n_lk, 0);

        ret_val = xmlLinkGetData(lk);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlLinkPtr(n_lk, lk, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlLinkGetData",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_lk);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListAppend(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* the data */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListAppend(l, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListAppend",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListClear(void) {
    int test_ret = 0;

    int mem_base;
    xmlListPtr l; /* a list */
    int n_l;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);

        xmlListClear(l);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListClear",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_const_xmlListPtr 1
static xmlListPtr gen_const_xmlListPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_xmlListPtr(int no ATTRIBUTE_UNUSED, const xmlListPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlListCopy(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr cur; /* the new list */
    int n_cur;
    xmlListPtr old; /* the old list */
    int n_old;

    for (n_cur = 0;n_cur < gen_nb_xmlListPtr;n_cur++) {
    for (n_old = 0;n_old < gen_nb_const_xmlListPtr;n_old++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlListPtr(n_cur, 0);
        old = gen_const_xmlListPtr(n_old, 1);

        ret_val = xmlListCopy(cur, (const xmlListPtr)old);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_cur, cur, 0);
        des_const_xmlListPtr(n_old, (const xmlListPtr)old, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListCopy",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_old);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListCreate(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlListDup(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlListEmpty(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);

        ret_val = xmlListEmpty(l);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListEmpty",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListEnd(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlListFront(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlListInsert(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* the data */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListInsert(l, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListInsert",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListMerge(void) {
    int test_ret = 0;

    int mem_base;
    xmlListPtr l1; /* the original list */
    int n_l1;
    xmlListPtr l2; /* the new list */
    int n_l2;

    for (n_l1 = 0;n_l1 < gen_nb_xmlListPtr;n_l1++) {
    for (n_l2 = 0;n_l2 < gen_nb_xmlListPtr;n_l2++) {
        mem_base = xmlMemBlocks();
        l1 = gen_xmlListPtr(n_l1, 0);
        l2 = gen_xmlListPtr(n_l2, 1);

        xmlListMerge(l1, l2);
        call_tests++;
        des_xmlListPtr(n_l1, l1, 0);
        des_xmlListPtr(n_l2, l2, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListMerge",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l1);
            printf(" %d", n_l2);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListPopBack(void) {
    int test_ret = 0;

    int mem_base;
    xmlListPtr l; /* a list */
    int n_l;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);

        xmlListPopBack(l);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListPopBack",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListPopFront(void) {
    int test_ret = 0;

    int mem_base;
    xmlListPtr l; /* a list */
    int n_l;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);

        xmlListPopFront(l);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListPopFront",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListPushBack(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* new data */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListPushBack(l, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListPushBack",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListPushFront(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* new data */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListPushFront(l, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListPushFront",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListRemoveAll(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* list data */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListRemoveAll(l, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListRemoveAll",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListRemoveFirst(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* list data */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListRemoveFirst(l, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListRemoveFirst",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListRemoveLast(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* list data */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListRemoveLast(l, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListRemoveLast",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListReverse(void) {
    int test_ret = 0;

    int mem_base;
    xmlListPtr l; /* a list */
    int n_l;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);

        xmlListReverse(l);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListReverse",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListReverseSearch(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* a search value */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListReverseSearch(l, data);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListReverseSearch",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListReverseWalk(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlListSearch(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    xmlListPtr l; /* a list */
    int n_l;
    void * data; /* a search value */
    int n_data;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);
        data = gen_userdata(n_data, 1);

        ret_val = xmlListSearch(l, data);
        desret_void_ptr(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        des_userdata(n_data, data, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListSearch",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListSize(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlListPtr l; /* a list */
    int n_l;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);

        ret_val = xmlListSize(l);
        desret_int(ret_val);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListSize",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListSort(void) {
    int test_ret = 0;

    int mem_base;
    xmlListPtr l; /* a list */
    int n_l;

    for (n_l = 0;n_l < gen_nb_xmlListPtr;n_l++) {
        mem_base = xmlMemBlocks();
        l = gen_xmlListPtr(n_l, 0);

        xmlListSort(l);
        call_tests++;
        des_xmlListPtr(n_l, l, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlListSort",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_l);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlListWalk(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

static int
test_list(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing list : 19 of 26 functions ...\n");
    test_ret += test_xmlLinkGetData();
    test_ret += test_xmlListAppend();
    test_ret += test_xmlListClear();
    test_ret += test_xmlListCopy();
    test_ret += test_xmlListCreate();
    test_ret += test_xmlListDup();
    test_ret += test_xmlListEmpty();
    test_ret += test_xmlListEnd();
    test_ret += test_xmlListFront();
    test_ret += test_xmlListInsert();
    test_ret += test_xmlListMerge();
    test_ret += test_xmlListPopBack();
    test_ret += test_xmlListPopFront();
    test_ret += test_xmlListPushBack();
    test_ret += test_xmlListPushFront();
    test_ret += test_xmlListRemoveAll();
    test_ret += test_xmlListRemoveFirst();
    test_ret += test_xmlListRemoveLast();
    test_ret += test_xmlListReverse();
    test_ret += test_xmlListReverseSearch();
    test_ret += test_xmlListReverseWalk();
    test_ret += test_xmlListSearch();
    test_ret += test_xmlListSize();
    test_ret += test_xmlListSort();
    test_ret += test_xmlListWalk();

    if (test_ret != 0)
	printf("Module list: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlNanoFTPCheckResponse(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* an FTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoFTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoFTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoFTPCheckResponse(ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoFTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPCheckResponse",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPCleanup(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlNanoFTPCleanup();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPCleanup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPCloseConnection(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* an FTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoFTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoFTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoFTPCloseConnection(ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoFTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPCloseConnection",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPCwd(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* an FTP context */
    int n_ctx;
    char * directory; /* a directory on the server */
    int n_directory;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoFTPCtxtPtr;n_ctx++) {
    for (n_directory = 0;n_directory < gen_nb_const_char_ptr;n_directory++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoFTPCtxtPtr(n_ctx, 0);
        directory = gen_const_char_ptr(n_directory, 1);

        ret_val = xmlNanoFTPCwd(ctx, (const char *)directory);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoFTPCtxtPtr(n_ctx, ctx, 0);
        des_const_char_ptr(n_directory, (const char *)directory, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPCwd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_directory);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPDele(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* an FTP context */
    int n_ctx;
    const char * file; /* a file or directory on the server */
    int n_file;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoFTPCtxtPtr;n_ctx++) {
    for (n_file = 0;n_file < gen_nb_filepath;n_file++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoFTPCtxtPtr(n_ctx, 0);
        file = gen_filepath(n_file, 1);

        ret_val = xmlNanoFTPDele(ctx, file);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoFTPCtxtPtr(n_ctx, ctx, 0);
        des_filepath(n_file, file, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPDele",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_file);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPGet(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlNanoFTPGetConnection(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlNanoFTPGetResponse(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* an FTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoFTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoFTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoFTPGetResponse(ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoFTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPGetResponse",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPGetSocket(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlNanoFTPInit(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlNanoFTPInit();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPInit",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPList(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlNanoFTPNewCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    void * ret_val;
    const char * URL; /* The URL used to initialize the context */
    int n_URL;

    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
        mem_base = xmlMemBlocks();
        URL = gen_filepath(n_URL, 0);

        ret_val = xmlNanoFTPNewCtxt(URL);
        desret_xmlNanoFTPCtxtPtr(ret_val);
        call_tests++;
        des_filepath(n_URL, URL, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPNewCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPOpen(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    void * ret_val;
    const char * URL; /* the URL to the resource */
    int n_URL;

    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
        mem_base = xmlMemBlocks();
        URL = gen_filepath(n_URL, 0);

        ret_val = xmlNanoFTPOpen(URL);
        desret_xmlNanoFTPCtxtPtr(ret_val);
        call_tests++;
        des_filepath(n_URL, URL, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPOpen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPProxy(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    char * host; /* the proxy host name */
    int n_host;
    int port; /* the proxy port */
    int n_port;
    char * user; /* the proxy user name */
    int n_user;
    char * passwd; /* the proxy password */
    int n_passwd;
    int type; /* the type of proxy 1 for using SITE, 2 for USER a@b */
    int n_type;

    for (n_host = 0;n_host < gen_nb_const_char_ptr;n_host++) {
    for (n_port = 0;n_port < gen_nb_int;n_port++) {
    for (n_user = 0;n_user < gen_nb_const_char_ptr;n_user++) {
    for (n_passwd = 0;n_passwd < gen_nb_const_char_ptr;n_passwd++) {
    for (n_type = 0;n_type < gen_nb_int;n_type++) {
        host = gen_const_char_ptr(n_host, 0);
        port = gen_int(n_port, 1);
        user = gen_const_char_ptr(n_user, 2);
        passwd = gen_const_char_ptr(n_passwd, 3);
        type = gen_int(n_type, 4);

        xmlNanoFTPProxy((const char *)host, port, (const char *)user, (const char *)passwd, type);
        call_tests++;
        des_const_char_ptr(n_host, (const char *)host, 0);
        des_int(n_port, port, 1);
        des_const_char_ptr(n_user, (const char *)user, 2);
        des_const_char_ptr(n_passwd, (const char *)passwd, 3);
        des_int(n_type, type, 4);
        xmlResetLastError();
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPQuit(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* an FTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoFTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoFTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoFTPQuit(ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoFTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPQuit",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPRead(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* the FTP context */
    int n_ctx;
    void * dest; /* a buffer */
    int n_dest;
    int len; /* the buffer length */
    int n_len;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoFTPCtxtPtr;n_ctx++) {
    for (n_dest = 0;n_dest < gen_nb_void_ptr;n_dest++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoFTPCtxtPtr(n_ctx, 0);
        dest = gen_void_ptr(n_dest, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlNanoFTPRead(ctx, dest, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoFTPCtxtPtr(n_ctx, ctx, 0);
        des_void_ptr(n_dest, dest, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPRead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_dest);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPScanProxy(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    const char * URL; /* The proxy URL used to initialize the proxy context */
    int n_URL;

    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
        URL = gen_filepath(n_URL, 0);

        xmlNanoFTPScanProxy(URL);
        call_tests++;
        des_filepath(n_URL, URL, 0);
        xmlResetLastError();
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoFTPUpdateURL(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* an FTP context */
    int n_ctx;
    const char * URL; /* The URL used to update the context */
    int n_URL;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoFTPCtxtPtr;n_ctx++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoFTPCtxtPtr(n_ctx, 0);
        URL = gen_filepath(n_URL, 1);

        ret_val = xmlNanoFTPUpdateURL(ctx, URL);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoFTPCtxtPtr(n_ctx, ctx, 0);
        des_filepath(n_URL, URL, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoFTPUpdateURL",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_URL);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_nanoftp(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing nanoftp : 14 of 22 functions ...\n");
    test_ret += test_xmlNanoFTPCheckResponse();
    test_ret += test_xmlNanoFTPCleanup();
    test_ret += test_xmlNanoFTPCloseConnection();
    test_ret += test_xmlNanoFTPCwd();
    test_ret += test_xmlNanoFTPDele();
    test_ret += test_xmlNanoFTPGet();
    test_ret += test_xmlNanoFTPGetConnection();
    test_ret += test_xmlNanoFTPGetResponse();
    test_ret += test_xmlNanoFTPGetSocket();
    test_ret += test_xmlNanoFTPInit();
    test_ret += test_xmlNanoFTPList();
    test_ret += test_xmlNanoFTPNewCtxt();
    test_ret += test_xmlNanoFTPOpen();
    test_ret += test_xmlNanoFTPProxy();
    test_ret += test_xmlNanoFTPQuit();
    test_ret += test_xmlNanoFTPRead();
    test_ret += test_xmlNanoFTPScanProxy();
    test_ret += test_xmlNanoFTPUpdateURL();

    if (test_ret != 0)
	printf("Module nanoftp: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlNanoHTTPAuthHeader(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    const char * ret_val;
    void * ctx; /* the HTTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoHTTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoHTTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoHTTPAuthHeader(ctx);
        desret_const_char_ptr(ret_val);
        call_tests++;
        des_xmlNanoHTTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPAuthHeader",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPCleanup(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlNanoHTTPCleanup();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPCleanup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPContentLength(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* the HTTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoHTTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoHTTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoHTTPContentLength(ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoHTTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPContentLength",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPEncoding(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    const char * ret_val;
    void * ctx; /* the HTTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoHTTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoHTTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoHTTPEncoding(ctx);
        desret_const_char_ptr(ret_val);
        call_tests++;
        des_xmlNanoHTTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


#define gen_nb_char_ptr_ptr 1
static char ** gen_char_ptr_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_char_ptr_ptr(int no ATTRIBUTE_UNUSED, char ** val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlNanoHTTPFetch(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    int ret_val;
    const char * URL; /* The URL to load */
    int n_URL;
    const char * filename; /* the filename where the content should be saved */
    int n_filename;
    char ** contentType; /* if available the Content-Type information will be returned at that location */
    int n_contentType;

    for (n_URL = 0;n_URL < gen_nb_fileoutput;n_URL++) {
    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_contentType = 0;n_contentType < gen_nb_char_ptr_ptr;n_contentType++) {
        mem_base = xmlMemBlocks();
        URL = gen_fileoutput(n_URL, 0);
        filename = gen_fileoutput(n_filename, 1);
        contentType = gen_char_ptr_ptr(n_contentType, 2);

        ret_val = xmlNanoHTTPFetch(URL, filename, contentType);
        desret_int(ret_val);
        call_tests++;
        des_fileoutput(n_URL, URL, 0);
        des_fileoutput(n_filename, filename, 1);
        des_char_ptr_ptr(n_contentType, contentType, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPFetch",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf(" %d", n_filename);
            printf(" %d", n_contentType);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPInit(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlNanoHTTPInit();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPInit",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPMimeType(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    const char * ret_val;
    void * ctx; /* the HTTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoHTTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoHTTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoHTTPMimeType(ctx);
        desret_const_char_ptr(ret_val);
        call_tests++;
        des_xmlNanoHTTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPMimeType",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPOpen(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    void * ret_val;
    const char * URL; /* The URL to load */
    int n_URL;
    char ** contentType; /* if available the Content-Type information will be returned at that location */
    int n_contentType;

    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_contentType = 0;n_contentType < gen_nb_char_ptr_ptr;n_contentType++) {
        mem_base = xmlMemBlocks();
        URL = gen_filepath(n_URL, 0);
        contentType = gen_char_ptr_ptr(n_contentType, 1);

        ret_val = xmlNanoHTTPOpen(URL, contentType);
        desret_xmlNanoHTTPCtxtPtr(ret_val);
        call_tests++;
        des_filepath(n_URL, URL, 0);
        des_char_ptr_ptr(n_contentType, contentType, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPOpen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf(" %d", n_contentType);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPOpenRedir(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    void * ret_val;
    const char * URL; /* The URL to load */
    int n_URL;
    char ** contentType; /* if available the Content-Type information will be returned at that location */
    int n_contentType;
    char ** redir; /* if available the redirected URL will be returned */
    int n_redir;

    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_contentType = 0;n_contentType < gen_nb_char_ptr_ptr;n_contentType++) {
    for (n_redir = 0;n_redir < gen_nb_char_ptr_ptr;n_redir++) {
        mem_base = xmlMemBlocks();
        URL = gen_filepath(n_URL, 0);
        contentType = gen_char_ptr_ptr(n_contentType, 1);
        redir = gen_char_ptr_ptr(n_redir, 2);

        ret_val = xmlNanoHTTPOpenRedir(URL, contentType, redir);
        desret_xmlNanoHTTPCtxtPtr(ret_val);
        call_tests++;
        des_filepath(n_URL, URL, 0);
        des_char_ptr_ptr(n_contentType, contentType, 1);
        des_char_ptr_ptr(n_redir, redir, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPOpenRedir",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf(" %d", n_contentType);
            printf(" %d", n_redir);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPRead(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* the HTTP context */
    int n_ctx;
    void * dest; /* a buffer */
    int n_dest;
    int len; /* the buffer length */
    int n_len;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoHTTPCtxtPtr;n_ctx++) {
    for (n_dest = 0;n_dest < gen_nb_void_ptr;n_dest++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoHTTPCtxtPtr(n_ctx, 0);
        dest = gen_void_ptr(n_dest, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlNanoHTTPRead(ctx, dest, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoHTTPCtxtPtr(n_ctx, ctx, 0);
        des_void_ptr(n_dest, dest, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPRead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_dest);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPRedir(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlNanoHTTPReturnCode(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    int ret_val;
    void * ctx; /* the HTTP context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_xmlNanoHTTPCtxtPtr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlNanoHTTPCtxtPtr(n_ctx, 0);

        ret_val = xmlNanoHTTPReturnCode(ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlNanoHTTPCtxtPtr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPReturnCode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPSave(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    void * ctxt; /* the HTTP context */
    int n_ctxt;
    const char * filename; /* the filename where the content should be saved */
    int n_filename;

    for (n_ctxt = 0;n_ctxt < gen_nb_void_ptr;n_ctxt++) {
    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_void_ptr(n_ctxt, 0);
        filename = gen_fileoutput(n_filename, 1);

        ret_val = xmlNanoHTTPSave(ctxt, filename);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_ctxt, ctxt, 0);
        des_fileoutput(n_filename, filename, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNanoHTTPSave",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNanoHTTPScanProxy(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    const char * URL; /* The proxy URL used to initialize the proxy context */
    int n_URL;

    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
        URL = gen_filepath(n_URL, 0);

        xmlNanoHTTPScanProxy(URL);
        call_tests++;
        des_filepath(n_URL, URL, 0);
        xmlResetLastError();
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_nanohttp(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing nanohttp : 13 of 17 functions ...\n");
    test_ret += test_xmlNanoHTTPAuthHeader();
    test_ret += test_xmlNanoHTTPCleanup();
    test_ret += test_xmlNanoHTTPContentLength();
    test_ret += test_xmlNanoHTTPEncoding();
    test_ret += test_xmlNanoHTTPFetch();
    test_ret += test_xmlNanoHTTPInit();
    test_ret += test_xmlNanoHTTPMimeType();
    test_ret += test_xmlNanoHTTPOpen();
    test_ret += test_xmlNanoHTTPOpenRedir();
    test_ret += test_xmlNanoHTTPRead();
    test_ret += test_xmlNanoHTTPRedir();
    test_ret += test_xmlNanoHTTPReturnCode();
    test_ret += test_xmlNanoHTTPSave();
    test_ret += test_xmlNanoHTTPScanProxy();

    if (test_ret != 0)
	printf("Module nanohttp: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlByteConsumed(void) {
    int test_ret = 0;

    int mem_base;
    long ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = xmlByteConsumed(ctxt);
        desret_long(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlByteConsumed",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlClearNodeInfoSeq(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserNodeInfoSeqPtr seq; /* a node info sequence pointer */
    int n_seq;

    for (n_seq = 0;n_seq < gen_nb_xmlParserNodeInfoSeqPtr;n_seq++) {
        mem_base = xmlMemBlocks();
        seq = gen_xmlParserNodeInfoSeqPtr(n_seq, 0);

        xmlClearNodeInfoSeq(seq);
        call_tests++;
        des_xmlParserNodeInfoSeqPtr(n_seq, seq, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlClearNodeInfoSeq",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_seq);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlClearParserCtxt(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        xmlClearParserCtxt(ctxt);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlClearParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCreateDocParserCtxt(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ret_val;
    xmlChar * cur; /* a pointer to an array of xmlChar */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_const_xmlChar_ptr(n_cur, 0);

        ret_val = xmlCreateDocParserCtxt((const xmlChar *)cur);
        desret_xmlParserCtxtPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCreateDocParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCreatePushParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_PUSH_ENABLED)
    int mem_base;
    xmlParserCtxtPtr ret_val;
    xmlSAXHandlerPtr sax; /* a SAX handler */
    int n_sax;
    void * user_data; /* The user data returned on SAX callbacks */
    int n_user_data;
    char * chunk; /* a pointer to an array of chars */
    int n_chunk;
    int size; /* number of chars in the array */
    int n_size;
    const char * filename; /* an optional file name or URI */
    int n_filename;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_user_data = 0;n_user_data < gen_nb_userdata;n_user_data++) {
    for (n_chunk = 0;n_chunk < gen_nb_const_char_ptr;n_chunk++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        user_data = gen_userdata(n_user_data, 1);
        chunk = gen_const_char_ptr(n_chunk, 2);
        size = gen_int(n_size, 3);
        filename = gen_fileoutput(n_filename, 4);

        ret_val = xmlCreatePushParserCtxt(sax, user_data, (const char *)chunk, size, filename);
        desret_xmlParserCtxtPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_userdata(n_user_data, user_data, 1);
        des_const_char_ptr(n_chunk, (const char *)chunk, 2);
        des_int(n_size, size, 3);
        des_fileoutput(n_filename, filename, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCreatePushParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_user_data);
            printf(" %d", n_chunk);
            printf(" %d", n_size);
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCtxtReadDoc(void) {
    int test_ret = 0;

    int mem_base;
    xmlDocPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlChar * cur; /* a pointer to a zero terminated string */
    int n_cur;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        cur = gen_const_xmlChar_ptr(n_cur, 1);
        URL = gen_filepath(n_URL, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        options = gen_parseroptions(n_options, 4);

        ret_val = xmlCtxtReadDoc(ctxt, (const xmlChar *)cur, URL, (const char *)encoding, options);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 1);
        des_filepath(n_URL, URL, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_parseroptions(n_options, options, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCtxtReadDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_cur);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCtxtReadFile(void) {
    int test_ret = 0;

    int mem_base;
    xmlDocPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    const char * filename; /* a file or URL */
    int n_filename;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        filename = gen_filepath(n_filename, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        options = gen_parseroptions(n_options, 3);

        ret_val = xmlCtxtReadFile(ctxt, filename, (const char *)encoding, options);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_filepath(n_filename, filename, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_parseroptions(n_options, options, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCtxtReadFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_filename);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCtxtReadMemory(void) {
    int test_ret = 0;

    int mem_base;
    xmlDocPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    char * buffer; /* a pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        buffer = gen_const_char_ptr(n_buffer, 1);
        size = gen_int(n_size, 2);
        URL = gen_filepath(n_URL, 3);
        encoding = gen_const_char_ptr(n_encoding, 4);
        options = gen_parseroptions(n_options, 5);

        ret_val = xmlCtxtReadMemory(ctxt, (const char *)buffer, size, URL, (const char *)encoding, options);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_char_ptr(n_buffer, (const char *)buffer, 1);
        des_int(n_size, size, 2);
        des_filepath(n_URL, URL, 3);
        des_const_char_ptr(n_encoding, (const char *)encoding, 4);
        des_parseroptions(n_options, options, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCtxtReadMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCtxtReset(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        xmlCtxtReset(ctxt);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCtxtReset",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCtxtResetPush(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    char * chunk; /* a pointer to an array of chars */
    int n_chunk;
    int size; /* number of chars in the array */
    int n_size;
    const char * filename; /* an optional file name or URI */
    int n_filename;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_chunk = 0;n_chunk < gen_nb_const_char_ptr;n_chunk++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        chunk = gen_const_char_ptr(n_chunk, 1);
        size = gen_int(n_size, 2);
        filename = gen_filepath(n_filename, 3);
        encoding = gen_const_char_ptr(n_encoding, 4);

        ret_val = xmlCtxtResetPush(ctxt, (const char *)chunk, size, filename, (const char *)encoding);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_char_ptr(n_chunk, (const char *)chunk, 1);
        des_int(n_size, size, 2);
        des_filepath(n_filename, filename, 3);
        des_const_char_ptr(n_encoding, (const char *)encoding, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCtxtResetPush",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_chunk);
            printf(" %d", n_size);
            printf(" %d", n_filename);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCtxtUseOptions(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        options = gen_parseroptions(n_options, 1);

        ret_val = xmlCtxtUseOptions(ctxt, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_parseroptions(n_options, options, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCtxtUseOptions",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetExternalEntityLoader(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlGetFeature(void) {
    int test_ret = 0;

#if defined(LIBXML_LEGACY_ENABLED)
#ifdef LIBXML_LEGACY_ENABLED
    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML/HTML parser context */
    int n_ctxt;
    char * name; /* the feature name */
    int n_name;
    void * result; /* location to store the result */
    int n_result;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_name = 0;n_name < gen_nb_const_char_ptr;n_name++) {
    for (n_result = 0;n_result < gen_nb_void_ptr;n_result++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        name = gen_const_char_ptr(n_name, 1);
        result = gen_void_ptr(n_result, 2);

        ret_val = xmlGetFeature(ctxt, (const char *)name, result);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_char_ptr(n_name, (const char *)name, 1);
        des_void_ptr(n_result, result, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetFeature",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_name);
            printf(" %d", n_result);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


#define gen_nb_const_char_ptr_ptr 1
static char ** gen_const_char_ptr_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_char_ptr_ptr(int no ATTRIBUTE_UNUSED, const char ** val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlGetFeaturesList(void) {
    int test_ret = 0;

#if defined(LIBXML_LEGACY_ENABLED)
#ifdef LIBXML_LEGACY_ENABLED
    int mem_base;
    int ret_val;
    int * len; /* the length of the features name array (input/output) */
    int n_len;
    char ** result; /* an array of string to be filled with the features name. */
    int n_result;

    for (n_len = 0;n_len < gen_nb_int_ptr;n_len++) {
    for (n_result = 0;n_result < gen_nb_const_char_ptr_ptr;n_result++) {
        mem_base = xmlMemBlocks();
        len = gen_int_ptr(n_len, 0);
        result = gen_const_char_ptr_ptr(n_result, 1);

        ret_val = xmlGetFeaturesList(len, (const char **)result);
        desret_int(ret_val);
        call_tests++;
        des_int_ptr(n_len, len, 0);
        des_const_char_ptr_ptr(n_result, (const char **)result, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetFeaturesList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_len);
            printf(" %d", n_result);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlHasFeature(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlFeature feature; /* the feature to be examined */
    int n_feature;

    for (n_feature = 0;n_feature < gen_nb_xmlFeature;n_feature++) {
        mem_base = xmlMemBlocks();
        feature = gen_xmlFeature(n_feature, 0);

        ret_val = xmlHasFeature(feature);
        desret_int(ret_val);
        call_tests++;
        des_xmlFeature(n_feature, feature, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHasFeature",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_feature);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIOParseDTD(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
#ifdef LIBXML_VALID_ENABLED
    xmlDtdPtr ret_val;
    xmlSAXHandlerPtr sax; /* the SAX handler block or NULL */
    int n_sax;
    xmlParserInputBufferPtr input; /* an Input Buffer */
    int n_input;
    xmlCharEncoding enc; /* the charset encoding if known */
    int n_enc;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_input = 0;n_input < gen_nb_xmlParserInputBufferPtr;n_input++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        input = gen_xmlParserInputBufferPtr(n_input, 1);
        enc = gen_xmlCharEncoding(n_enc, 2);

        ret_val = xmlIOParseDTD(sax, input, enc);
        input = NULL;
        desret_xmlDtdPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_xmlParserInputBufferPtr(n_input, input, 1);
        des_xmlCharEncoding(n_enc, enc, 2);
        xmlResetLastError();
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlInitNodeInfoSeq(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserNodeInfoSeqPtr seq; /* a node info sequence pointer */
    int n_seq;

    for (n_seq = 0;n_seq < gen_nb_xmlParserNodeInfoSeqPtr;n_seq++) {
        mem_base = xmlMemBlocks();
        seq = gen_xmlParserNodeInfoSeqPtr(n_seq, 0);

        xmlInitNodeInfoSeq(seq);
        call_tests++;
        des_xmlParserNodeInfoSeqPtr(n_seq, seq, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlInitNodeInfoSeq",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_seq);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlInitParser(void) {
    int test_ret = 0;

    int mem_base;

        mem_base = xmlMemBlocks();

        xmlInitParser();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlInitParser",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlInitParserCtxt(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = xmlInitParserCtxt(ctxt);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlInitParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlKeepBlanksDefault(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    int val; /* int 0 or 1 */
    int n_val;

    for (n_val = 0;n_val < gen_nb_int;n_val++) {
        mem_base = xmlMemBlocks();
        val = gen_int(n_val, 0);

        ret_val = xmlKeepBlanksDefault(val);
        desret_int(ret_val);
        call_tests++;
        des_int(n_val, val, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlKeepBlanksDefault",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlLineNumbersDefault(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    int val; /* int 0 or 1 */
    int n_val;

    for (n_val = 0;n_val < gen_nb_int;n_val++) {
        mem_base = xmlMemBlocks();
        val = gen_int(n_val, 0);

        ret_val = xmlLineNumbersDefault(val);
        desret_int(ret_val);
        call_tests++;
        des_int(n_val, val, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlLineNumbersDefault",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlLoadExternalEntity(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    const char * URL; /* the URL for the entity to load */
    int n_URL;
    char * ID; /* the Public ID for the entity to load */
    int n_ID;
    xmlParserCtxtPtr ctxt; /* the context in which the entity is called or NULL */
    int n_ctxt;

    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_ID = 0;n_ID < gen_nb_const_char_ptr;n_ID++) {
    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        URL = gen_filepath(n_URL, 0);
        ID = gen_const_char_ptr(n_ID, 1);
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 2);

        ret_val = xmlLoadExternalEntity(URL, (const char *)ID, ctxt);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_filepath(n_URL, URL, 0);
        des_const_char_ptr(n_ID, (const char *)ID, 1);
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlLoadExternalEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf(" %d", n_ID);
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewIOInputStream(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlParserInputBufferPtr input; /* an I/O Input */
    int n_input;
    xmlCharEncoding enc; /* the charset encoding if known */
    int n_enc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_input = 0;n_input < gen_nb_xmlParserInputBufferPtr;n_input++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        input = gen_xmlParserInputBufferPtr(n_input, 1);
        enc = gen_xmlCharEncoding(n_enc, 2);

        ret_val = xmlNewIOInputStream(ctxt, input, enc);
        if (ret_val != NULL) input = NULL;
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlParserInputBufferPtr(n_input, input, 1);
        des_xmlCharEncoding(n_enc, enc, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewIOInputStream",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_input);
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewParserCtxt(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ret_val;

        mem_base = xmlMemBlocks();

        ret_val = xmlNewParserCtxt();
        desret_xmlParserCtxtPtr(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlNodePtr_ptr 1
static xmlNodePtr * gen_xmlNodePtr_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlNodePtr_ptr(int no ATTRIBUTE_UNUSED, xmlNodePtr * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlParseBalancedChunkMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document the chunk pertains to */
    int n_doc;
    xmlSAXHandlerPtr sax; /* the SAX handler bloc (possibly NULL) */
    int n_sax;
    void * user_data; /* The user data returned on SAX callbacks (possibly NULL) */
    int n_user_data;
    int depth; /* Used for loop detection, use 0 */
    int n_depth;
    xmlChar * string; /* the input string in UTF8 or ISO-Latin (zero terminated) */
    int n_string;
    xmlNodePtr * lst; /* the return value for the set of parsed nodes */
    int n_lst;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_user_data = 0;n_user_data < gen_nb_userdata;n_user_data++) {
    for (n_depth = 0;n_depth < gen_nb_int;n_depth++) {
    for (n_string = 0;n_string < gen_nb_const_xmlChar_ptr;n_string++) {
    for (n_lst = 0;n_lst < gen_nb_xmlNodePtr_ptr;n_lst++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        sax = gen_xmlSAXHandlerPtr(n_sax, 1);
        user_data = gen_userdata(n_user_data, 2);
        depth = gen_int(n_depth, 3);
        string = gen_const_xmlChar_ptr(n_string, 4);
        lst = gen_xmlNodePtr_ptr(n_lst, 5);
        
#ifdef LIBXML_SAX1_ENABLED
        if (sax == (xmlSAXHandlerPtr)&xmlDefaultSAXHandler) user_data = NULL;
#endif


        ret_val = xmlParseBalancedChunkMemory(doc, sax, user_data, depth, (const xmlChar *)string, lst);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlSAXHandlerPtr(n_sax, sax, 1);
        des_userdata(n_user_data, user_data, 2);
        des_int(n_depth, depth, 3);
        des_const_xmlChar_ptr(n_string, (const xmlChar *)string, 4);
        des_xmlNodePtr_ptr(n_lst, lst, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseBalancedChunkMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_sax);
            printf(" %d", n_user_data);
            printf(" %d", n_depth);
            printf(" %d", n_string);
            printf(" %d", n_lst);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlParseBalancedChunkMemoryRecover(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document the chunk pertains to */
    int n_doc;
    xmlSAXHandlerPtr sax; /* the SAX handler bloc (possibly NULL) */
    int n_sax;
    void * user_data; /* The user data returned on SAX callbacks (possibly NULL) */
    int n_user_data;
    int depth; /* Used for loop detection, use 0 */
    int n_depth;
    xmlChar * string; /* the input string in UTF8 or ISO-Latin (zero terminated) */
    int n_string;
    xmlNodePtr * lst; /* the return value for the set of parsed nodes */
    int n_lst;
    int recover; /* return nodes even if the data is broken (use 0) */
    int n_recover;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_user_data = 0;n_user_data < gen_nb_userdata;n_user_data++) {
    for (n_depth = 0;n_depth < gen_nb_int;n_depth++) {
    for (n_string = 0;n_string < gen_nb_const_xmlChar_ptr;n_string++) {
    for (n_lst = 0;n_lst < gen_nb_xmlNodePtr_ptr;n_lst++) {
    for (n_recover = 0;n_recover < gen_nb_int;n_recover++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        sax = gen_xmlSAXHandlerPtr(n_sax, 1);
        user_data = gen_userdata(n_user_data, 2);
        depth = gen_int(n_depth, 3);
        string = gen_const_xmlChar_ptr(n_string, 4);
        lst = gen_xmlNodePtr_ptr(n_lst, 5);
        recover = gen_int(n_recover, 6);
        
#ifdef LIBXML_SAX1_ENABLED
        if (sax == (xmlSAXHandlerPtr)&xmlDefaultSAXHandler) user_data = NULL;
#endif


        ret_val = xmlParseBalancedChunkMemoryRecover(doc, sax, user_data, depth, (const xmlChar *)string, lst, recover);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlSAXHandlerPtr(n_sax, sax, 1);
        des_userdata(n_user_data, user_data, 2);
        des_int(n_depth, depth, 3);
        des_const_xmlChar_ptr(n_string, (const xmlChar *)string, 4);
        des_xmlNodePtr_ptr(n_lst, lst, 5);
        des_int(n_recover, recover, 6);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseBalancedChunkMemoryRecover",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_sax);
            printf(" %d", n_user_data);
            printf(" %d", n_depth);
            printf(" %d", n_string);
            printf(" %d", n_lst);
            printf(" %d", n_recover);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlParseChunk(void) {
    int test_ret = 0;

#if defined(LIBXML_PUSH_ENABLED)
    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    char * chunk; /* an char array */
    int n_chunk;
    int size; /* the size in byte of the chunk */
    int n_size;
    int terminate; /* last chunk indicator */
    int n_terminate;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_chunk = 0;n_chunk < gen_nb_const_char_ptr;n_chunk++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_terminate = 0;n_terminate < gen_nb_int;n_terminate++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        chunk = gen_const_char_ptr(n_chunk, 1);
        size = gen_int(n_size, 2);
        terminate = gen_int(n_terminate, 3);

        ret_val = xmlParseChunk(ctxt, (const char *)chunk, size, terminate);
        if (ctxt != NULL) {xmlFreeDoc(ctxt->myDoc); ctxt->myDoc = NULL;}
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_char_ptr(n_chunk, (const char *)chunk, 1);
        des_int(n_size, size, 2);
        des_int(n_terminate, terminate, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseChunk",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_chunk);
            printf(" %d", n_size);
            printf(" %d", n_terminate);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlParseCtxtExternalEntity(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctx; /* the existing parsing context */
    int n_ctx;
    xmlChar * URL; /* the URL for the entity to load */
    int n_URL;
    xmlChar * ID; /* the System ID for the entity to load */
    int n_ID;
    xmlNodePtr * lst; /* the return value for the set of parsed nodes */
    int n_lst;

    for (n_ctx = 0;n_ctx < gen_nb_xmlParserCtxtPtr;n_ctx++) {
    for (n_URL = 0;n_URL < gen_nb_const_xmlChar_ptr;n_URL++) {
    for (n_ID = 0;n_ID < gen_nb_const_xmlChar_ptr;n_ID++) {
    for (n_lst = 0;n_lst < gen_nb_xmlNodePtr_ptr;n_lst++) {
        mem_base = xmlMemBlocks();
        ctx = gen_xmlParserCtxtPtr(n_ctx, 0);
        URL = gen_const_xmlChar_ptr(n_URL, 1);
        ID = gen_const_xmlChar_ptr(n_ID, 2);
        lst = gen_xmlNodePtr_ptr(n_lst, 3);

        ret_val = xmlParseCtxtExternalEntity(ctx, (const xmlChar *)URL, (const xmlChar *)ID, lst);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctx, ctx, 0);
        des_const_xmlChar_ptr(n_URL, (const xmlChar *)URL, 1);
        des_const_xmlChar_ptr(n_ID, (const xmlChar *)ID, 2);
        des_xmlNodePtr_ptr(n_lst, lst, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseCtxtExternalEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_URL);
            printf(" %d", n_ID);
            printf(" %d", n_lst);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParseDTD(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
#ifdef LIBXML_VALID_ENABLED
    int mem_base;
    xmlDtdPtr ret_val;
    xmlChar * ExternalID; /* a NAME* containing the External ID of the DTD */
    int n_ExternalID;
    xmlChar * SystemID; /* a NAME* containing the URL to the DTD */
    int n_SystemID;

    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
        mem_base = xmlMemBlocks();
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 0);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 1);

        ret_val = xmlParseDTD((const xmlChar *)ExternalID, (const xmlChar *)SystemID);
        desret_xmlDtdPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 0);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseDTD",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlParseDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    xmlChar * cur; /* a pointer to an array of xmlChar */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_const_xmlChar_ptr(n_cur, 0);

        ret_val = xmlParseDoc((const xmlChar *)cur);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlParseDocument(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = xmlParseDocument(ctxt);
        if (ctxt != NULL) {xmlFreeDoc(ctxt->myDoc); ctxt->myDoc = NULL;}
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseDocument",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParseEntity(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    const char * filename; /* the filename */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlParseEntity(filename);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlParseExtParsedEnt(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = xmlParseExtParsedEnt(ctxt);
        if (ctxt != NULL) {xmlFreeDoc(ctxt->myDoc); ctxt->myDoc = NULL;}
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseExtParsedEnt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParseExternalEntity(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document the chunk pertains to */
    int n_doc;
    xmlSAXHandlerPtr sax; /* the SAX handler bloc (possibly NULL) */
    int n_sax;
    void * user_data; /* The user data returned on SAX callbacks (possibly NULL) */
    int n_user_data;
    int depth; /* Used for loop detection, use 0 */
    int n_depth;
    xmlChar * URL; /* the URL for the entity to load */
    int n_URL;
    xmlChar * ID; /* the System ID for the entity to load */
    int n_ID;
    xmlNodePtr * lst; /* the return value for the set of parsed nodes */
    int n_lst;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_user_data = 0;n_user_data < gen_nb_userdata;n_user_data++) {
    for (n_depth = 0;n_depth < gen_nb_int;n_depth++) {
    for (n_URL = 0;n_URL < gen_nb_const_xmlChar_ptr;n_URL++) {
    for (n_ID = 0;n_ID < gen_nb_const_xmlChar_ptr;n_ID++) {
    for (n_lst = 0;n_lst < gen_nb_xmlNodePtr_ptr;n_lst++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        sax = gen_xmlSAXHandlerPtr(n_sax, 1);
        user_data = gen_userdata(n_user_data, 2);
        depth = gen_int(n_depth, 3);
        URL = gen_const_xmlChar_ptr(n_URL, 4);
        ID = gen_const_xmlChar_ptr(n_ID, 5);
        lst = gen_xmlNodePtr_ptr(n_lst, 6);

        ret_val = xmlParseExternalEntity(doc, sax, user_data, depth, (const xmlChar *)URL, (const xmlChar *)ID, lst);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlSAXHandlerPtr(n_sax, sax, 1);
        des_userdata(n_user_data, user_data, 2);
        des_int(n_depth, depth, 3);
        des_const_xmlChar_ptr(n_URL, (const xmlChar *)URL, 4);
        des_const_xmlChar_ptr(n_ID, (const xmlChar *)ID, 5);
        des_xmlNodePtr_ptr(n_lst, lst, 6);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseExternalEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_sax);
            printf(" %d", n_user_data);
            printf(" %d", n_depth);
            printf(" %d", n_URL);
            printf(" %d", n_ID);
            printf(" %d", n_lst);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlParseFile(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    const char * filename; /* the filename */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlParseFile(filename);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlParseInNodeContext(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserErrors ret_val;
    xmlNodePtr node; /* the context node */
    int n_node;
    char * data; /* the input string */
    int n_data;
    int datalen; /* the input string length in bytes */
    int n_datalen;
    int options; /* a combination of xmlParserOption */
    int n_options;
    xmlNodePtr * lst; /* the return value for the set of parsed nodes */
    int n_lst;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_data = 0;n_data < gen_nb_const_char_ptr;n_data++) {
    for (n_datalen = 0;n_datalen < gen_nb_int;n_datalen++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
    for (n_lst = 0;n_lst < gen_nb_xmlNodePtr_ptr;n_lst++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        data = gen_const_char_ptr(n_data, 1);
        datalen = gen_int(n_datalen, 2);
        options = gen_parseroptions(n_options, 3);
        lst = gen_xmlNodePtr_ptr(n_lst, 4);

        ret_val = xmlParseInNodeContext(node, (const char *)data, datalen, options, lst);
        desret_xmlParserErrors(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_char_ptr(n_data, (const char *)data, 1);
        des_int(n_datalen, datalen, 2);
        des_parseroptions(n_options, options, 3);
        des_xmlNodePtr_ptr(n_lst, lst, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseInNodeContext",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_data);
            printf(" %d", n_datalen);
            printf(" %d", n_options);
            printf(" %d", n_lst);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParseMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    char * buffer; /* an pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);

        ret_val = xmlParseMemory((const char *)buffer, size);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


#define gen_nb_const_xmlParserNodeInfoPtr 1
static xmlParserNodeInfoPtr gen_const_xmlParserNodeInfoPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_xmlParserNodeInfoPtr(int no ATTRIBUTE_UNUSED, const xmlParserNodeInfoPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlParserAddNodeInfo(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlParserNodeInfoPtr info; /* a node info sequence pointer */
    int n_info;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_info = 0;n_info < gen_nb_const_xmlParserNodeInfoPtr;n_info++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        info = gen_const_xmlParserNodeInfoPtr(n_info, 1);

        xmlParserAddNodeInfo(ctxt, (const xmlParserNodeInfoPtr)info);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlParserNodeInfoPtr(n_info, (const xmlParserNodeInfoPtr)info, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserAddNodeInfo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_info);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_const_xmlParserCtxtPtr 1
static xmlParserCtxtPtr gen_const_xmlParserCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_xmlParserCtxtPtr(int no ATTRIBUTE_UNUSED, const xmlParserCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

#define gen_nb_const_xmlNodePtr 1
static xmlNodePtr gen_const_xmlNodePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_xmlNodePtr(int no ATTRIBUTE_UNUSED, const xmlNodePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlParserFindNodeInfo(void) {
    int test_ret = 0;

    int mem_base;
    const xmlParserNodeInfo * ret_val;
    xmlParserCtxtPtr ctx; /* an XML parser context */
    int n_ctx;
    xmlNodePtr node; /* an XML node within the tree */
    int n_node;

    for (n_ctx = 0;n_ctx < gen_nb_const_xmlParserCtxtPtr;n_ctx++) {
    for (n_node = 0;n_node < gen_nb_const_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        ctx = gen_const_xmlParserCtxtPtr(n_ctx, 0);
        node = gen_const_xmlNodePtr(n_node, 1);

        ret_val = xmlParserFindNodeInfo((const xmlParserCtxtPtr)ctx, (const xmlNodePtr)node);
        desret_const_xmlParserNodeInfo_ptr(ret_val);
        call_tests++;
        des_const_xmlParserCtxtPtr(n_ctx, (const xmlParserCtxtPtr)ctx, 0);
        des_const_xmlNodePtr(n_node, (const xmlNodePtr)node, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserFindNodeInfo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_const_xmlParserNodeInfoSeqPtr 1
static xmlParserNodeInfoSeqPtr gen_const_xmlParserNodeInfoSeqPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_xmlParserNodeInfoSeqPtr(int no ATTRIBUTE_UNUSED, const xmlParserNodeInfoSeqPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlParserFindNodeInfoIndex(void) {
    int test_ret = 0;

    int mem_base;
    unsigned long ret_val;
    xmlParserNodeInfoSeqPtr seq; /* a node info sequence pointer */
    int n_seq;
    xmlNodePtr node; /* an XML node pointer */
    int n_node;

    for (n_seq = 0;n_seq < gen_nb_const_xmlParserNodeInfoSeqPtr;n_seq++) {
    for (n_node = 0;n_node < gen_nb_const_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        seq = gen_const_xmlParserNodeInfoSeqPtr(n_seq, 0);
        node = gen_const_xmlNodePtr(n_node, 1);

        ret_val = xmlParserFindNodeInfoIndex((const xmlParserNodeInfoSeqPtr)seq, (const xmlNodePtr)node);
        desret_unsigned_long(ret_val);
        call_tests++;
        des_const_xmlParserNodeInfoSeqPtr(n_seq, (const xmlParserNodeInfoSeqPtr)seq, 0);
        des_const_xmlNodePtr(n_node, (const xmlNodePtr)node, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserFindNodeInfoIndex",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_seq);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlParserInputPtr 1
static xmlParserInputPtr gen_xmlParserInputPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlParserInputPtr(int no ATTRIBUTE_UNUSED, xmlParserInputPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlParserInputGrow(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserInputPtr in; /* an XML parser input */
    int n_in;
    int len; /* an indicative size for the lookahead */
    int n_len;

    for (n_in = 0;n_in < gen_nb_xmlParserInputPtr;n_in++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        in = gen_xmlParserInputPtr(n_in, 0);
        len = gen_int(n_len, 1);

        ret_val = xmlParserInputGrow(in, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserInputPtr(n_in, in, 0);
        des_int(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputGrow",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_in);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputRead(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserInputPtr in; /* an XML parser input */
    int n_in;
    int len; /* an indicative size for the lookahead */
    int n_len;

    for (n_in = 0;n_in < gen_nb_xmlParserInputPtr;n_in++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        in = gen_xmlParserInputPtr(n_in, 0);
        len = gen_int(n_len, 1);

        ret_val = xmlParserInputRead(in, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserInputPtr(n_in, in, 0);
        des_int(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputRead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_in);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlPedanticParserDefault(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    int val; /* int 0 or 1 */
    int n_val;

    for (n_val = 0;n_val < gen_nb_int;n_val++) {
        mem_base = xmlMemBlocks();
        val = gen_int(n_val, 0);

        ret_val = xmlPedanticParserDefault(val);
        desret_int(ret_val);
        call_tests++;
        des_int(n_val, val, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPedanticParserDefault",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlReadDoc(void) {
    int test_ret = 0;

    int mem_base;
    xmlDocPtr ret_val;
    xmlChar * cur; /* a pointer to a zero terminated string */
    int n_cur;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        cur = gen_const_xmlChar_ptr(n_cur, 0);
        URL = gen_filepath(n_URL, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        options = gen_parseroptions(n_options, 3);

        ret_val = xmlReadDoc((const xmlChar *)cur, URL, (const char *)encoding, options);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 0);
        des_filepath(n_URL, URL, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_parseroptions(n_options, options, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReadDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlReadFile(void) {
    int test_ret = 0;

    int mem_base;
    xmlDocPtr ret_val;
    const char * filename; /* a file or URL */
    int n_filename;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);
        encoding = gen_const_char_ptr(n_encoding, 1);
        options = gen_parseroptions(n_options, 2);

        ret_val = xmlReadFile(filename, (const char *)encoding, options);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        des_const_char_ptr(n_encoding, (const char *)encoding, 1);
        des_parseroptions(n_options, options, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReadFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlReadMemory(void) {
    int test_ret = 0;

    int mem_base;
    xmlDocPtr ret_val;
    char * buffer; /* a pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);
        URL = gen_filepath(n_URL, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        options = gen_parseroptions(n_options, 4);

        ret_val = xmlReadMemory((const char *)buffer, size, URL, (const char *)encoding, options);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        des_filepath(n_URL, URL, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_parseroptions(n_options, options, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReadMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlRecoverDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    xmlChar * cur; /* a pointer to an array of xmlChar */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_const_xmlChar_ptr(n_cur, 0);

        ret_val = xmlRecoverDoc((const xmlChar *)cur);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRecoverDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlRecoverFile(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    const char * filename; /* the filename */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlRecoverFile(filename);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRecoverFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlRecoverMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    char * buffer; /* an pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);

        ret_val = xmlRecoverMemory((const char *)buffer, size);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRecoverMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXParseDTD(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDtdPtr ret_val;
    xmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    xmlChar * ExternalID; /* a NAME* containing the External ID of the DTD */
    int n_ExternalID;
    xmlChar * SystemID; /* a NAME* containing the URL to the DTD */
    int n_SystemID;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 1);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 2);

        ret_val = xmlSAXParseDTD(sax, (const xmlChar *)ExternalID, (const xmlChar *)SystemID);
        desret_xmlDtdPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 1);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXParseDTD",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXParseDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    xmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    xmlChar * cur; /* a pointer to an array of xmlChar */
    int n_cur;
    int recovery; /* work in recovery mode, i.e. tries to read no Well Formed documents */
    int n_recovery;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
    for (n_recovery = 0;n_recovery < gen_nb_int;n_recovery++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        cur = gen_const_xmlChar_ptr(n_cur, 1);
        recovery = gen_int(n_recovery, 2);

        ret_val = xmlSAXParseDoc(sax, (const xmlChar *)cur, recovery);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 1);
        des_int(n_recovery, recovery, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXParseDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_cur);
            printf(" %d", n_recovery);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXParseEntity(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    xmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    const char * filename; /* the filename */
    int n_filename;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        filename = gen_filepath(n_filename, 1);

        ret_val = xmlSAXParseEntity(sax, filename);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_filepath(n_filename, filename, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXParseEntity",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXParseFile(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    xmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    const char * filename; /* the filename */
    int n_filename;
    int recovery; /* work in recovery mode, i.e. tries to read no Well Formed documents */
    int n_recovery;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_recovery = 0;n_recovery < gen_nb_int;n_recovery++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        filename = gen_filepath(n_filename, 1);
        recovery = gen_int(n_recovery, 2);

        ret_val = xmlSAXParseFile(sax, filename, recovery);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_filepath(n_filename, filename, 1);
        des_int(n_recovery, recovery, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXParseFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_filename);
            printf(" %d", n_recovery);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXParseFileWithData(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    xmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    const char * filename; /* the filename */
    int n_filename;
    int recovery; /* work in recovery mode, i.e. tries to read no Well Formed documents */
    int n_recovery;
    void * data; /* the userdata */
    int n_data;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_recovery = 0;n_recovery < gen_nb_int;n_recovery++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        filename = gen_filepath(n_filename, 1);
        recovery = gen_int(n_recovery, 2);
        data = gen_userdata(n_data, 3);

        ret_val = xmlSAXParseFileWithData(sax, filename, recovery, data);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_filepath(n_filename, filename, 1);
        des_int(n_recovery, recovery, 2);
        des_userdata(n_data, data, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXParseFileWithData",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_filename);
            printf(" %d", n_recovery);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXParseMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    xmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    char * buffer; /* an pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;
    int recovery; /* work in recovery mode, i.e. tries to read not Well Formed documents */
    int n_recovery;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_recovery = 0;n_recovery < gen_nb_int;n_recovery++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        buffer = gen_const_char_ptr(n_buffer, 1);
        size = gen_int(n_size, 2);
        recovery = gen_int(n_recovery, 3);

        ret_val = xmlSAXParseMemory(sax, (const char *)buffer, size, recovery);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_const_char_ptr(n_buffer, (const char *)buffer, 1);
        des_int(n_size, size, 2);
        des_int(n_recovery, recovery, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXParseMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf(" %d", n_recovery);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXParseMemoryWithData(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlDocPtr ret_val;
    xmlSAXHandlerPtr sax; /* the SAX handler block */
    int n_sax;
    char * buffer; /* an pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;
    int recovery; /* work in recovery mode, i.e. tries to read no Well Formed documents */
    int n_recovery;
    void * data; /* the userdata */
    int n_data;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_recovery = 0;n_recovery < gen_nb_int;n_recovery++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        buffer = gen_const_char_ptr(n_buffer, 1);
        size = gen_int(n_size, 2);
        recovery = gen_int(n_recovery, 3);
        data = gen_userdata(n_data, 4);

        ret_val = xmlSAXParseMemoryWithData(sax, (const char *)buffer, size, recovery, data);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_const_char_ptr(n_buffer, (const char *)buffer, 1);
        des_int(n_size, size, 2);
        des_int(n_recovery, recovery, 3);
        des_userdata(n_data, data, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXParseMemoryWithData",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf(" %d", n_recovery);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXUserParseFile(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    int ret_val;
    xmlSAXHandlerPtr sax; /* a SAX handler */
    int n_sax;
    void * user_data; /* The user data returned on SAX callbacks */
    int n_user_data;
    const char * filename; /* a file name */
    int n_filename;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_user_data = 0;n_user_data < gen_nb_userdata;n_user_data++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        user_data = gen_userdata(n_user_data, 1);
        filename = gen_filepath(n_filename, 2);
        
#ifdef LIBXML_SAX1_ENABLED
        if (sax == (xmlSAXHandlerPtr)&xmlDefaultSAXHandler) user_data = NULL;
#endif


        ret_val = xmlSAXUserParseFile(sax, user_data, filename);
        desret_int(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_userdata(n_user_data, user_data, 1);
        des_filepath(n_filename, filename, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXUserParseFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_user_data);
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSAXUserParseMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    int ret_val;
    xmlSAXHandlerPtr sax; /* a SAX handler */
    int n_sax;
    void * user_data; /* The user data returned on SAX callbacks */
    int n_user_data;
    char * buffer; /* an in-memory XML document input */
    int n_buffer;
    int size; /* the length of the XML document in bytes */
    int n_size;

    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_user_data = 0;n_user_data < gen_nb_userdata;n_user_data++) {
    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
        mem_base = xmlMemBlocks();
        sax = gen_xmlSAXHandlerPtr(n_sax, 0);
        user_data = gen_userdata(n_user_data, 1);
        buffer = gen_const_char_ptr(n_buffer, 2);
        size = gen_int(n_size, 3);
        
#ifdef LIBXML_SAX1_ENABLED
        if (sax == (xmlSAXHandlerPtr)&xmlDefaultSAXHandler) user_data = NULL;
#endif


        ret_val = xmlSAXUserParseMemory(sax, user_data, (const char *)buffer, size);
        desret_int(ret_val);
        call_tests++;
        des_xmlSAXHandlerPtr(n_sax, sax, 0);
        des_userdata(n_user_data, user_data, 1);
        des_const_char_ptr(n_buffer, (const char *)buffer, 2);
        des_int(n_size, size, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSAXUserParseMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_sax);
            printf(" %d", n_user_data);
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSetExternalEntityLoader(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSetFeature(void) {
    int test_ret = 0;

#if defined(LIBXML_LEGACY_ENABLED)
#ifdef LIBXML_LEGACY_ENABLED
    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML/HTML parser context */
    int n_ctxt;
    char * name; /* the feature name */
    int n_name;
    void * value; /* pointer to the location of the new value */
    int n_value;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_name = 0;n_name < gen_nb_const_char_ptr;n_name++) {
    for (n_value = 0;n_value < gen_nb_void_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        name = gen_const_char_ptr(n_name, 1);
        value = gen_void_ptr(n_value, 2);

        ret_val = xmlSetFeature(ctxt, (const char *)name, value);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_char_ptr(n_name, (const char *)name, 1);
        des_void_ptr(n_value, value, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSetFeature",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlSetupParserForBuffer(void) {
    int test_ret = 0;

#if defined(LIBXML_SAX1_ENABLED)
#ifdef LIBXML_SAX1_ENABLED
    int mem_base;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlChar * buffer; /* a xmlChar * buffer */
    int n_buffer;
    const char * filename; /* a file name */
    int n_filename;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_buffer = 0;n_buffer < gen_nb_const_xmlChar_ptr;n_buffer++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        buffer = gen_const_xmlChar_ptr(n_buffer, 1);
        filename = gen_filepath(n_filename, 2);

        xmlSetupParserForBuffer(ctxt, (const xmlChar *)buffer, filename);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_buffer, (const xmlChar *)buffer, 1);
        des_filepath(n_filename, filename, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSetupParserForBuffer",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_buffer);
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlStopParser(void) {
    int test_ret = 0;

#ifdef LIBXML_PUSH_ENABLED
    int mem_base;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        xmlStopParser(ctxt);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStopParser",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSubstituteEntitiesDefault(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    int val; /* int 0 or 1 */
    int n_val;

    for (n_val = 0;n_val < gen_nb_int;n_val++) {
        mem_base = xmlMemBlocks();
        val = gen_int(n_val, 0);

        ret_val = xmlSubstituteEntitiesDefault(val);
        desret_int(ret_val);
        call_tests++;
        des_int(n_val, val, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSubstituteEntitiesDefault",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}

static int
test_parser(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing parser : 61 of 70 functions ...\n");
    test_ret += test_xmlByteConsumed();
    test_ret += test_xmlClearNodeInfoSeq();
    test_ret += test_xmlClearParserCtxt();
    test_ret += test_xmlCreateDocParserCtxt();
    test_ret += test_xmlCreatePushParserCtxt();
    test_ret += test_xmlCtxtReadDoc();
    test_ret += test_xmlCtxtReadFile();
    test_ret += test_xmlCtxtReadMemory();
    test_ret += test_xmlCtxtReset();
    test_ret += test_xmlCtxtResetPush();
    test_ret += test_xmlCtxtUseOptions();
    test_ret += test_xmlGetExternalEntityLoader();
    test_ret += test_xmlGetFeature();
    test_ret += test_xmlGetFeaturesList();
    test_ret += test_xmlHasFeature();
    test_ret += test_xmlIOParseDTD();
    test_ret += test_xmlInitNodeInfoSeq();
    test_ret += test_xmlInitParser();
    test_ret += test_xmlInitParserCtxt();
    test_ret += test_xmlKeepBlanksDefault();
    test_ret += test_xmlLineNumbersDefault();
    test_ret += test_xmlLoadExternalEntity();
    test_ret += test_xmlNewIOInputStream();
    test_ret += test_xmlNewParserCtxt();
    test_ret += test_xmlParseBalancedChunkMemory();
    test_ret += test_xmlParseBalancedChunkMemoryRecover();
    test_ret += test_xmlParseChunk();
    test_ret += test_xmlParseCtxtExternalEntity();
    test_ret += test_xmlParseDTD();
    test_ret += test_xmlParseDoc();
    test_ret += test_xmlParseDocument();
    test_ret += test_xmlParseEntity();
    test_ret += test_xmlParseExtParsedEnt();
    test_ret += test_xmlParseExternalEntity();
    test_ret += test_xmlParseFile();
    test_ret += test_xmlParseInNodeContext();
    test_ret += test_xmlParseMemory();
    test_ret += test_xmlParserAddNodeInfo();
    test_ret += test_xmlParserFindNodeInfo();
    test_ret += test_xmlParserFindNodeInfoIndex();
    test_ret += test_xmlParserInputGrow();
    test_ret += test_xmlParserInputRead();
    test_ret += test_xmlPedanticParserDefault();
    test_ret += test_xmlReadDoc();
    test_ret += test_xmlReadFile();
    test_ret += test_xmlReadMemory();
    test_ret += test_xmlRecoverDoc();
    test_ret += test_xmlRecoverFile();
    test_ret += test_xmlRecoverMemory();
    test_ret += test_xmlSAXParseDTD();
    test_ret += test_xmlSAXParseDoc();
    test_ret += test_xmlSAXParseEntity();
    test_ret += test_xmlSAXParseFile();
    test_ret += test_xmlSAXParseFileWithData();
    test_ret += test_xmlSAXParseMemory();
    test_ret += test_xmlSAXParseMemoryWithData();
    test_ret += test_xmlSAXUserParseFile();
    test_ret += test_xmlSAXUserParseMemory();
    test_ret += test_xmlSetExternalEntityLoader();
    test_ret += test_xmlSetFeature();
    test_ret += test_xmlSetupParserForBuffer();
    test_ret += test_xmlStopParser();
    test_ret += test_xmlSubstituteEntitiesDefault();

    if (test_ret != 0)
	printf("Module parser: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_htmlCreateFileParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;
    htmlParserCtxtPtr ret_val;
    const char * filename; /* the filename */
    int n_filename;
    char * encoding; /* a free form C string describing the HTML document encoding, or NULL */
    int n_encoding;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        encoding = gen_const_char_ptr(n_encoding, 1);

        ret_val = htmlCreateFileParserCtxt(filename, (const char *)encoding);
        desret_htmlParserCtxtPtr(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_const_char_ptr(n_encoding, (const char *)encoding, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlCreateFileParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_htmlInitAutoClose(void) {
    int test_ret = 0;

#if defined(LIBXML_HTML_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        htmlInitAutoClose();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in htmlInitAutoClose",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_inputPop(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = inputPop(ctxt);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in inputPop",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_inputPush(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlParserInputPtr value; /* the parser input */
    int n_value;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_value = 0;n_value < gen_nb_xmlParserInputPtr;n_value++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        value = gen_xmlParserInputPtr(n_value, 1);

        ret_val = inputPush(ctxt, value);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlParserInputPtr(n_value, value, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in inputPush",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_namePop(void) {
    int test_ret = 0;

    int mem_base;
    const xmlChar * ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = namePop(ctxt);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in namePop",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_namePush(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlChar * value; /* the element name */
    int n_value;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);

        ret_val = namePush(ctxt, (const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in namePush",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_nodePop(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = nodePop(ctxt);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in nodePop",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_nodePush(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlNodePtr value; /* the element node */
    int n_value;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_value = 0;n_value < gen_nb_xmlNodePtr;n_value++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        value = gen_xmlNodePtr(n_value, 1);

        ret_val = nodePush(ctxt, value);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlNodePtr(n_value, value, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in nodePush",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCheckLanguageID(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlChar * lang; /* pointer to the string value */
    int n_lang;

    for (n_lang = 0;n_lang < gen_nb_const_xmlChar_ptr;n_lang++) {
        mem_base = xmlMemBlocks();
        lang = gen_const_xmlChar_ptr(n_lang, 0);

        ret_val = xmlCheckLanguageID((const xmlChar *)lang);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_lang, (const xmlChar *)lang, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCheckLanguageID",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_lang);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCopyChar(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    int len; /* Ignored, compatibility */
    int n_len;
    xmlChar * out; /* pointer to an array of xmlChar */
    int n_out;
    int val; /* the char value */
    int n_val;

    for (n_len = 0;n_len < gen_nb_int;n_len++) {
    for (n_out = 0;n_out < gen_nb_xmlChar_ptr;n_out++) {
    for (n_val = 0;n_val < gen_nb_int;n_val++) {
        mem_base = xmlMemBlocks();
        len = gen_int(n_len, 0);
        out = gen_xmlChar_ptr(n_out, 1);
        val = gen_int(n_val, 2);

        ret_val = xmlCopyChar(len, out, val);
        desret_int(ret_val);
        call_tests++;
        des_int(n_len, len, 0);
        des_xmlChar_ptr(n_out, out, 1);
        des_int(n_val, val, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_len);
            printf(" %d", n_out);
            printf(" %d", n_val);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCopyCharMultiByte(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlChar * out; /* pointer to an array of xmlChar */
    int n_out;
    int val; /* the char value */
    int n_val;

    for (n_out = 0;n_out < gen_nb_xmlChar_ptr;n_out++) {
    for (n_val = 0;n_val < gen_nb_int;n_val++) {
        mem_base = xmlMemBlocks();
        out = gen_xmlChar_ptr(n_out, 0);
        val = gen_int(n_val, 1);

        ret_val = xmlCopyCharMultiByte(out, val);
        desret_int(ret_val);
        call_tests++;
        des_xmlChar_ptr(n_out, out, 0);
        des_int(n_val, val, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyCharMultiByte",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_val);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCreateEntityParserCtxt(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ret_val;
    xmlChar * URL; /* the entity URL */
    int n_URL;
    xmlChar * ID; /* the entity PUBLIC ID */
    int n_ID;
    xmlChar * base; /* a possible base for the target URI */
    int n_base;

    for (n_URL = 0;n_URL < gen_nb_const_xmlChar_ptr;n_URL++) {
    for (n_ID = 0;n_ID < gen_nb_const_xmlChar_ptr;n_ID++) {
    for (n_base = 0;n_base < gen_nb_const_xmlChar_ptr;n_base++) {
        mem_base = xmlMemBlocks();
        URL = gen_const_xmlChar_ptr(n_URL, 0);
        ID = gen_const_xmlChar_ptr(n_ID, 1);
        base = gen_const_xmlChar_ptr(n_base, 2);

        ret_val = xmlCreateEntityParserCtxt((const xmlChar *)URL, (const xmlChar *)ID, (const xmlChar *)base);
        desret_xmlParserCtxtPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_URL, (const xmlChar *)URL, 0);
        des_const_xmlChar_ptr(n_ID, (const xmlChar *)ID, 1);
        des_const_xmlChar_ptr(n_base, (const xmlChar *)base, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCreateEntityParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf(" %d", n_ID);
            printf(" %d", n_base);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCreateFileParserCtxt(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ret_val;
    const char * filename; /* the filename */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);

        ret_val = xmlCreateFileParserCtxt(filename);
        desret_xmlParserCtxtPtr(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCreateFileParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCreateMemoryParserCtxt(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ret_val;
    char * buffer; /* a pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);

        ret_val = xmlCreateMemoryParserCtxt((const char *)buffer, size);
        desret_xmlParserCtxtPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCreateMemoryParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCreateURLParserCtxt(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ret_val;
    const char * filename; /* the filename or URL */
    int n_filename;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        options = gen_int(n_options, 1);

        ret_val = xmlCreateURLParserCtxt(filename, options);
        desret_xmlParserCtxtPtr(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_int(n_options, options, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCreateURLParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCurrentChar(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* the XML parser context */
    int n_ctxt;
    int * len; /* pointer to the length of the char read */
    int n_len;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_len = 0;n_len < gen_nb_int_ptr;n_len++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        len = gen_int_ptr(n_len, 1);

        ret_val = xmlCurrentChar(ctxt, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_int_ptr(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCurrentChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlErrMemory(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    char * extra; /* extra informations */
    int n_extra;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_extra = 0;n_extra < gen_nb_const_char_ptr;n_extra++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        extra = gen_const_char_ptr(n_extra, 1);

        xmlErrMemory(ctxt, (const char *)extra);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_char_ptr(n_extra, (const char *)extra, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlErrMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_extra);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsLetter(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    int c; /* an unicode character (int) */
    int n_c;

    for (n_c = 0;n_c < gen_nb_int;n_c++) {
        mem_base = xmlMemBlocks();
        c = gen_int(n_c, 0);

        ret_val = xmlIsLetter(c);
        desret_int(ret_val);
        call_tests++;
        des_int(n_c, c, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsLetter",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_c);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewEntityInputStream(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlEntityPtr entity; /* an Entity pointer */
    int n_entity;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_entity = 0;n_entity < gen_nb_xmlEntityPtr;n_entity++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        entity = gen_xmlEntityPtr(n_entity, 1);

        ret_val = xmlNewEntityInputStream(ctxt, entity);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlEntityPtr(n_entity, entity, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewEntityInputStream",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_entity);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewInputFromFile(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    const char * filename; /* the filename to use as entity */
    int n_filename;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        filename = gen_filepath(n_filename, 1);

        ret_val = xmlNewInputFromFile(ctxt, filename);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_filepath(n_filename, filename, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewInputFromFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewInputStream(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = xmlNewInputStream(ctxt);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewInputStream",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewStringInputStream(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlChar * buffer; /* an memory buffer */
    int n_buffer;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_buffer = 0;n_buffer < gen_nb_const_xmlChar_ptr;n_buffer++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        buffer = gen_const_xmlChar_ptr(n_buffer, 1);

        ret_val = xmlNewStringInputStream(ctxt, (const xmlChar *)buffer);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_buffer, (const xmlChar *)buffer, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewStringInputStream",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_buffer);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNextChar(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserCtxtPtr ctxt; /* the XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        xmlNextChar(ctxt);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNextChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputShrink(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr in; /* an XML parser input */
    int n_in;

    for (n_in = 0;n_in < gen_nb_xmlParserInputPtr;n_in++) {
        mem_base = xmlMemBlocks();
        in = gen_xmlParserInputPtr(n_in, 0);

        xmlParserInputShrink(in);
        call_tests++;
        des_xmlParserInputPtr(n_in, in, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputShrink",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_in);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlPopInput(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);

        ret_val = xmlPopInput(ctxt);
        desret_xmlChar(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPopInput",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlPushInput(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlParserInputPtr input; /* an XML parser input fragment (entity, XML fragment ...). */
    int n_input;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_input = 0;n_input < gen_nb_xmlParserInputPtr;n_input++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        input = gen_xmlParserInputPtr(n_input, 1);

        ret_val = xmlPushInput(ctxt, input);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlParserInputPtr(n_input, input, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPushInput",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_input);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSetEntityReferenceFunc(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSplitQName(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlChar * name; /* an XML parser context */
    int n_name;
    xmlChar ** prefix; /* a xmlChar ** */
    int n_prefix;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_prefix = 0;n_prefix < gen_nb_xmlChar_ptr_ptr;n_prefix++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        prefix = gen_xmlChar_ptr_ptr(n_prefix, 2);

        ret_val = xmlSplitQName(ctxt, (const xmlChar *)name, prefix);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_xmlChar_ptr_ptr(n_prefix, prefix, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSplitQName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_name);
            printf(" %d", n_prefix);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlStringCurrentChar(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* the XML parser context */
    int n_ctxt;
    xmlChar * cur; /* pointer to the beginning of the char */
    int n_cur;
    int * len; /* pointer to the length of the char read */
    int n_len;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
    for (n_len = 0;n_len < gen_nb_int_ptr;n_len++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        cur = gen_const_xmlChar_ptr(n_cur, 1);
        len = gen_int_ptr(n_len, 2);

        ret_val = xmlStringCurrentChar(ctxt, (const xmlChar *)cur, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 1);
        des_int_ptr(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStringCurrentChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_cur);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlStringDecodeEntities(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlParserCtxtPtr ctxt; /* the parser context */
    int n_ctxt;
    xmlChar * str; /* the input string */
    int n_str;
    int what; /* combination of XML_SUBSTITUTE_REF and XML_SUBSTITUTE_PEREF */
    int n_what;
    xmlChar end; /* an end marker xmlChar, 0 if none */
    int n_end;
    xmlChar end2; /* an end marker xmlChar, 0 if none */
    int n_end2;
    xmlChar end3; /* an end marker xmlChar, 0 if none */
    int n_end3;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
    for (n_what = 0;n_what < gen_nb_int;n_what++) {
    for (n_end = 0;n_end < gen_nb_xmlChar;n_end++) {
    for (n_end2 = 0;n_end2 < gen_nb_xmlChar;n_end2++) {
    for (n_end3 = 0;n_end3 < gen_nb_xmlChar;n_end3++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        str = gen_const_xmlChar_ptr(n_str, 1);
        what = gen_int(n_what, 2);
        end = gen_xmlChar(n_end, 3);
        end2 = gen_xmlChar(n_end2, 4);
        end3 = gen_xmlChar(n_end3, 5);

        ret_val = xmlStringDecodeEntities(ctxt, (const xmlChar *)str, what, end, end2, end3);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 1);
        des_int(n_what, what, 2);
        des_xmlChar(n_end, end, 3);
        des_xmlChar(n_end2, end2, 4);
        des_xmlChar(n_end3, end3, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStringDecodeEntities",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_str);
            printf(" %d", n_what);
            printf(" %d", n_end);
            printf(" %d", n_end2);
            printf(" %d", n_end3);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlStringLenDecodeEntities(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlParserCtxtPtr ctxt; /* the parser context */
    int n_ctxt;
    xmlChar * str; /* the input string */
    int n_str;
    int len; /* the string length */
    int n_len;
    int what; /* combination of XML_SUBSTITUTE_REF and XML_SUBSTITUTE_PEREF */
    int n_what;
    xmlChar end; /* an end marker xmlChar, 0 if none */
    int n_end;
    xmlChar end2; /* an end marker xmlChar, 0 if none */
    int n_end2;
    xmlChar end3; /* an end marker xmlChar, 0 if none */
    int n_end3;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
    for (n_what = 0;n_what < gen_nb_int;n_what++) {
    for (n_end = 0;n_end < gen_nb_xmlChar;n_end++) {
    for (n_end2 = 0;n_end2 < gen_nb_xmlChar;n_end2++) {
    for (n_end3 = 0;n_end3 < gen_nb_xmlChar;n_end3++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        str = gen_const_xmlChar_ptr(n_str, 1);
        len = gen_int(n_len, 2);
        what = gen_int(n_what, 3);
        end = gen_xmlChar(n_end, 4);
        end2 = gen_xmlChar(n_end2, 5);
        end3 = gen_xmlChar(n_end3, 6);

        ret_val = xmlStringLenDecodeEntities(ctxt, (const xmlChar *)str, len, what, end, end2, end3);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 1);
        des_int(n_len, len, 2);
        des_int(n_what, what, 3);
        des_xmlChar(n_end, end, 4);
        des_xmlChar(n_end2, end2, 5);
        des_xmlChar(n_end3, end3, 6);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStringLenDecodeEntities",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_str);
            printf(" %d", n_len);
            printf(" %d", n_what);
            printf(" %d", n_end);
            printf(" %d", n_end2);
            printf(" %d", n_end3);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSwitchEncoding(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* the parser context */
    int n_ctxt;
    xmlCharEncoding enc; /* the encoding value (number) */
    int n_enc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        enc = gen_xmlCharEncoding(n_enc, 1);

        ret_val = xmlSwitchEncoding(ctxt, enc);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlCharEncoding(n_enc, enc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSwitchEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSwitchInputEncoding(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* the parser context */
    int n_ctxt;
    xmlParserInputPtr input; /* the input stream */
    int n_input;
    xmlCharEncodingHandlerPtr handler; /* the encoding handler */
    int n_handler;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_input = 0;n_input < gen_nb_xmlParserInputPtr;n_input++) {
    for (n_handler = 0;n_handler < gen_nb_xmlCharEncodingHandlerPtr;n_handler++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        input = gen_xmlParserInputPtr(n_input, 1);
        handler = gen_xmlCharEncodingHandlerPtr(n_handler, 2);

        ret_val = xmlSwitchInputEncoding(ctxt, input, handler);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlParserInputPtr(n_input, input, 1);
        des_xmlCharEncodingHandlerPtr(n_handler, handler, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSwitchInputEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_input);
            printf(" %d", n_handler);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSwitchToEncoding(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserCtxtPtr ctxt; /* the parser context */
    int n_ctxt;
    xmlCharEncodingHandlerPtr handler; /* the encoding handler */
    int n_handler;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_handler = 0;n_handler < gen_nb_xmlCharEncodingHandlerPtr;n_handler++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        handler = gen_xmlCharEncodingHandlerPtr(n_handler, 1);

        ret_val = xmlSwitchToEncoding(ctxt, handler);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlCharEncodingHandlerPtr(n_handler, handler, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSwitchToEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_handler);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}

static int
test_parserInternals(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing parserInternals : 33 of 90 functions ...\n");
    test_ret += test_htmlCreateFileParserCtxt();
    test_ret += test_htmlInitAutoClose();
    test_ret += test_inputPop();
    test_ret += test_inputPush();
    test_ret += test_namePop();
    test_ret += test_namePush();
    test_ret += test_nodePop();
    test_ret += test_nodePush();
    test_ret += test_xmlCheckLanguageID();
    test_ret += test_xmlCopyChar();
    test_ret += test_xmlCopyCharMultiByte();
    test_ret += test_xmlCreateEntityParserCtxt();
    test_ret += test_xmlCreateFileParserCtxt();
    test_ret += test_xmlCreateMemoryParserCtxt();
    test_ret += test_xmlCreateURLParserCtxt();
    test_ret += test_xmlCurrentChar();
    test_ret += test_xmlErrMemory();
    test_ret += test_xmlIsLetter();
    test_ret += test_xmlNewEntityInputStream();
    test_ret += test_xmlNewInputFromFile();
    test_ret += test_xmlNewInputStream();
    test_ret += test_xmlNewStringInputStream();
    test_ret += test_xmlNextChar();
    test_ret += test_xmlParserInputShrink();
    test_ret += test_xmlPopInput();
    test_ret += test_xmlPushInput();
    test_ret += test_xmlSetEntityReferenceFunc();
    test_ret += test_xmlSplitQName();
    test_ret += test_xmlStringCurrentChar();
    test_ret += test_xmlStringDecodeEntities();
    test_ret += test_xmlStringLenDecodeEntities();
    test_ret += test_xmlSwitchEncoding();
    test_ret += test_xmlSwitchInputEncoding();
    test_ret += test_xmlSwitchToEncoding();

    if (test_ret != 0)
	printf("Module parserInternals: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlPatternFromRoot(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlPatternPtr comp; /* the precompiled pattern */
    int n_comp;

    for (n_comp = 0;n_comp < gen_nb_xmlPatternPtr;n_comp++) {
        mem_base = xmlMemBlocks();
        comp = gen_xmlPatternPtr(n_comp, 0);

        ret_val = xmlPatternFromRoot(comp);
        desret_int(ret_val);
        call_tests++;
        des_xmlPatternPtr(n_comp, comp, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPatternFromRoot",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_comp);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlPatternGetStreamCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlPatternMatch(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlPatternPtr comp; /* the precompiled pattern */
    int n_comp;
    xmlNodePtr node; /* a node */
    int n_node;

    for (n_comp = 0;n_comp < gen_nb_xmlPatternPtr;n_comp++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        comp = gen_xmlPatternPtr(n_comp, 0);
        node = gen_xmlNodePtr(n_node, 1);

        ret_val = xmlPatternMatch(comp, node);
        desret_int(ret_val);
        call_tests++;
        des_xmlPatternPtr(n_comp, comp, 0);
        des_xmlNodePtr(n_node, node, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPatternMatch",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_comp);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlPatternMaxDepth(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlPatternPtr comp; /* the precompiled pattern */
    int n_comp;

    for (n_comp = 0;n_comp < gen_nb_xmlPatternPtr;n_comp++) {
        mem_base = xmlMemBlocks();
        comp = gen_xmlPatternPtr(n_comp, 0);

        ret_val = xmlPatternMaxDepth(comp);
        desret_int(ret_val);
        call_tests++;
        des_xmlPatternPtr(n_comp, comp, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPatternMaxDepth",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_comp);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlPatternMinDepth(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlPatternPtr comp; /* the precompiled pattern */
    int n_comp;

    for (n_comp = 0;n_comp < gen_nb_xmlPatternPtr;n_comp++) {
        mem_base = xmlMemBlocks();
        comp = gen_xmlPatternPtr(n_comp, 0);

        ret_val = xmlPatternMinDepth(comp);
        desret_int(ret_val);
        call_tests++;
        des_xmlPatternPtr(n_comp, comp, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPatternMinDepth",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_comp);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlPatternStreamable(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlPatternPtr comp; /* the precompiled pattern */
    int n_comp;

    for (n_comp = 0;n_comp < gen_nb_xmlPatternPtr;n_comp++) {
        mem_base = xmlMemBlocks();
        comp = gen_xmlPatternPtr(n_comp, 0);

        ret_val = xmlPatternStreamable(comp);
        desret_int(ret_val);
        call_tests++;
        des_xmlPatternPtr(n_comp, comp, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPatternStreamable",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_comp);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlPatterncompile(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

#ifdef LIBXML_PATTERN_ENABLED

#define gen_nb_xmlStreamCtxtPtr 1
static xmlStreamCtxtPtr gen_xmlStreamCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlStreamCtxtPtr(int no ATTRIBUTE_UNUSED, xmlStreamCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlStreamPop(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlStreamCtxtPtr stream; /* the stream context */
    int n_stream;

    for (n_stream = 0;n_stream < gen_nb_xmlStreamCtxtPtr;n_stream++) {
        mem_base = xmlMemBlocks();
        stream = gen_xmlStreamCtxtPtr(n_stream, 0);

        ret_val = xmlStreamPop(stream);
        desret_int(ret_val);
        call_tests++;
        des_xmlStreamCtxtPtr(n_stream, stream, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStreamPop",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_stream);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlStreamPush(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlStreamCtxtPtr stream; /* the stream context */
    int n_stream;
    xmlChar * name; /* the current name */
    int n_name;
    xmlChar * ns; /* the namespace name */
    int n_ns;

    for (n_stream = 0;n_stream < gen_nb_xmlStreamCtxtPtr;n_stream++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ns = 0;n_ns < gen_nb_const_xmlChar_ptr;n_ns++) {
        mem_base = xmlMemBlocks();
        stream = gen_xmlStreamCtxtPtr(n_stream, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        ns = gen_const_xmlChar_ptr(n_ns, 2);

        ret_val = xmlStreamPush(stream, (const xmlChar *)name, (const xmlChar *)ns);
        desret_int(ret_val);
        call_tests++;
        des_xmlStreamCtxtPtr(n_stream, stream, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_ns, (const xmlChar *)ns, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStreamPush",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_stream);
            printf(" %d", n_name);
            printf(" %d", n_ns);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlStreamPushAttr(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlStreamCtxtPtr stream; /* the stream context */
    int n_stream;
    xmlChar * name; /* the current name */
    int n_name;
    xmlChar * ns; /* the namespace name */
    int n_ns;

    for (n_stream = 0;n_stream < gen_nb_xmlStreamCtxtPtr;n_stream++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ns = 0;n_ns < gen_nb_const_xmlChar_ptr;n_ns++) {
        mem_base = xmlMemBlocks();
        stream = gen_xmlStreamCtxtPtr(n_stream, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        ns = gen_const_xmlChar_ptr(n_ns, 2);

        ret_val = xmlStreamPushAttr(stream, (const xmlChar *)name, (const xmlChar *)ns);
        desret_int(ret_val);
        call_tests++;
        des_xmlStreamCtxtPtr(n_stream, stream, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_ns, (const xmlChar *)ns, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStreamPushAttr",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_stream);
            printf(" %d", n_name);
            printf(" %d", n_ns);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlStreamPushNode(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlStreamCtxtPtr stream; /* the stream context */
    int n_stream;
    xmlChar * name; /* the current name */
    int n_name;
    xmlChar * ns; /* the namespace name */
    int n_ns;
    int nodeType; /* the type of the node being pushed */
    int n_nodeType;

    for (n_stream = 0;n_stream < gen_nb_xmlStreamCtxtPtr;n_stream++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ns = 0;n_ns < gen_nb_const_xmlChar_ptr;n_ns++) {
    for (n_nodeType = 0;n_nodeType < gen_nb_int;n_nodeType++) {
        mem_base = xmlMemBlocks();
        stream = gen_xmlStreamCtxtPtr(n_stream, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        ns = gen_const_xmlChar_ptr(n_ns, 2);
        nodeType = gen_int(n_nodeType, 3);

        ret_val = xmlStreamPushNode(stream, (const xmlChar *)name, (const xmlChar *)ns, nodeType);
        desret_int(ret_val);
        call_tests++;
        des_xmlStreamCtxtPtr(n_stream, stream, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_ns, (const xmlChar *)ns, 2);
        des_int(n_nodeType, nodeType, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStreamPushNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_stream);
            printf(" %d", n_name);
            printf(" %d", n_ns);
            printf(" %d", n_nodeType);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlStreamWantsAnyNode(void) {
    int test_ret = 0;

#if defined(LIBXML_PATTERN_ENABLED)
    int mem_base;
    int ret_val;
    xmlStreamCtxtPtr streamCtxt; /* the stream context */
    int n_streamCtxt;

    for (n_streamCtxt = 0;n_streamCtxt < gen_nb_xmlStreamCtxtPtr;n_streamCtxt++) {
        mem_base = xmlMemBlocks();
        streamCtxt = gen_xmlStreamCtxtPtr(n_streamCtxt, 0);

        ret_val = xmlStreamWantsAnyNode(streamCtxt);
        desret_int(ret_val);
        call_tests++;
        des_xmlStreamCtxtPtr(n_streamCtxt, streamCtxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStreamWantsAnyNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_streamCtxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_pattern(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing pattern : 10 of 15 functions ...\n");
    test_ret += test_xmlPatternFromRoot();
    test_ret += test_xmlPatternGetStreamCtxt();
    test_ret += test_xmlPatternMatch();
    test_ret += test_xmlPatternMaxDepth();
    test_ret += test_xmlPatternMinDepth();
    test_ret += test_xmlPatternStreamable();
    test_ret += test_xmlPatterncompile();
    test_ret += test_xmlStreamPop();
    test_ret += test_xmlStreamPush();
    test_ret += test_xmlStreamPushAttr();
    test_ret += test_xmlStreamPushNode();
    test_ret += test_xmlStreamWantsAnyNode();

    if (test_ret != 0)
	printf("Module pattern: %d errors\n", test_ret);
    return(test_ret);
}
#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlRelaxNGPtr 1
static xmlRelaxNGPtr gen_xmlRelaxNGPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlRelaxNGPtr(int no ATTRIBUTE_UNUSED, xmlRelaxNGPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlRelaxNGDump(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    FILE * output; /* the file output */
    int n_output;
    xmlRelaxNGPtr schema; /* a schema structure */
    int n_schema;

    for (n_output = 0;n_output < gen_nb_FILE_ptr;n_output++) {
    for (n_schema = 0;n_schema < gen_nb_xmlRelaxNGPtr;n_schema++) {
        mem_base = xmlMemBlocks();
        output = gen_FILE_ptr(n_output, 0);
        schema = gen_xmlRelaxNGPtr(n_schema, 1);

        xmlRelaxNGDump(output, schema);
        call_tests++;
        des_FILE_ptr(n_output, output, 0);
        des_xmlRelaxNGPtr(n_schema, schema, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_schema);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGDumpTree(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    FILE * output; /* the file output */
    int n_output;
    xmlRelaxNGPtr schema; /* a schema structure */
    int n_schema;

    for (n_output = 0;n_output < gen_nb_FILE_ptr;n_output++) {
    for (n_schema = 0;n_schema < gen_nb_xmlRelaxNGPtr;n_schema++) {
        mem_base = xmlMemBlocks();
        output = gen_FILE_ptr(n_output, 0);
        schema = gen_xmlRelaxNGPtr(n_schema, 1);

        xmlRelaxNGDumpTree(output, schema);
        call_tests++;
        des_FILE_ptr(n_output, output, 0);
        des_xmlRelaxNGPtr(n_schema, schema, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGDumpTree",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_schema);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlRelaxNGParserCtxtPtr 1
static xmlRelaxNGParserCtxtPtr gen_xmlRelaxNGParserCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlRelaxNGParserCtxtPtr(int no ATTRIBUTE_UNUSED, xmlRelaxNGParserCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlRelaxNGValidityErrorFunc_ptr 1
static xmlRelaxNGValidityErrorFunc * gen_xmlRelaxNGValidityErrorFunc_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlRelaxNGValidityErrorFunc_ptr(int no ATTRIBUTE_UNUSED, xmlRelaxNGValidityErrorFunc * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlRelaxNGValidityWarningFunc_ptr 1
static xmlRelaxNGValidityWarningFunc * gen_xmlRelaxNGValidityWarningFunc_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlRelaxNGValidityWarningFunc_ptr(int no ATTRIBUTE_UNUSED, xmlRelaxNGValidityWarningFunc * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlRelaxNGGetParserErrors(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlRelaxNGParserCtxtPtr ctxt; /* a Relax-NG validation context */
    int n_ctxt;
    xmlRelaxNGValidityErrorFunc * err; /* the error callback result */
    int n_err;
    xmlRelaxNGValidityWarningFunc * warn; /* the warning callback result */
    int n_warn;
    void ** ctx; /* contextual data for the callbacks result */
    int n_ctx;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGParserCtxtPtr;n_ctxt++) {
    for (n_err = 0;n_err < gen_nb_xmlRelaxNGValidityErrorFunc_ptr;n_err++) {
    for (n_warn = 0;n_warn < gen_nb_xmlRelaxNGValidityWarningFunc_ptr;n_warn++) {
    for (n_ctx = 0;n_ctx < gen_nb_void_ptr_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlRelaxNGParserCtxtPtr(n_ctxt, 0);
        err = gen_xmlRelaxNGValidityErrorFunc_ptr(n_err, 1);
        warn = gen_xmlRelaxNGValidityWarningFunc_ptr(n_warn, 2);
        ctx = gen_void_ptr_ptr(n_ctx, 3);

        ret_val = xmlRelaxNGGetParserErrors(ctxt, err, warn, ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlRelaxNGParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlRelaxNGValidityErrorFunc_ptr(n_err, err, 1);
        des_xmlRelaxNGValidityWarningFunc_ptr(n_warn, warn, 2);
        des_void_ptr_ptr(n_ctx, ctx, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGGetParserErrors",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_err);
            printf(" %d", n_warn);
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlRelaxNGValidCtxtPtr 1
static xmlRelaxNGValidCtxtPtr gen_xmlRelaxNGValidCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlRelaxNGValidCtxtPtr(int no ATTRIBUTE_UNUSED, xmlRelaxNGValidCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlRelaxNGGetValidErrors(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlRelaxNGValidCtxtPtr ctxt; /* a Relax-NG validation context */
    int n_ctxt;
    xmlRelaxNGValidityErrorFunc * err; /* the error function result */
    int n_err;
    xmlRelaxNGValidityWarningFunc * warn; /* the warning function result */
    int n_warn;
    void ** ctx; /* the functions context result */
    int n_ctx;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGValidCtxtPtr;n_ctxt++) {
    for (n_err = 0;n_err < gen_nb_xmlRelaxNGValidityErrorFunc_ptr;n_err++) {
    for (n_warn = 0;n_warn < gen_nb_xmlRelaxNGValidityWarningFunc_ptr;n_warn++) {
    for (n_ctx = 0;n_ctx < gen_nb_void_ptr_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlRelaxNGValidCtxtPtr(n_ctxt, 0);
        err = gen_xmlRelaxNGValidityErrorFunc_ptr(n_err, 1);
        warn = gen_xmlRelaxNGValidityWarningFunc_ptr(n_warn, 2);
        ctx = gen_void_ptr_ptr(n_ctx, 3);

        ret_val = xmlRelaxNGGetValidErrors(ctxt, err, warn, ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlRelaxNGValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlRelaxNGValidityErrorFunc_ptr(n_err, err, 1);
        des_xmlRelaxNGValidityWarningFunc_ptr(n_warn, warn, 2);
        des_void_ptr_ptr(n_ctx, ctx, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGGetValidErrors",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_err);
            printf(" %d", n_warn);
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGInitTypes(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;

        mem_base = xmlMemBlocks();

        ret_val = xmlRelaxNGInitTypes();
        desret_int(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGInitTypes",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGNewDocParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlRelaxNGParserCtxtPtr ret_val;
    xmlDocPtr doc; /* a preparsed document tree */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);

        ret_val = xmlRelaxNGNewDocParserCtxt(doc);
        desret_xmlRelaxNGParserCtxtPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGNewDocParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGNewMemParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlRelaxNGParserCtxtPtr ret_val;
    char * buffer; /* a pointer to a char array containing the schemas */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);

        ret_val = xmlRelaxNGNewMemParserCtxt((const char *)buffer, size);
        desret_xmlRelaxNGParserCtxtPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGNewMemParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGNewParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlRelaxNGParserCtxtPtr ret_val;
    char * URL; /* the location of the schema */
    int n_URL;

    for (n_URL = 0;n_URL < gen_nb_const_char_ptr;n_URL++) {
        mem_base = xmlMemBlocks();
        URL = gen_const_char_ptr(n_URL, 0);

        ret_val = xmlRelaxNGNewParserCtxt((const char *)URL);
        desret_xmlRelaxNGParserCtxtPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_URL, (const char *)URL, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGNewParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGNewValidCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRelaxNGParse(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRelaxNGSetParserErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRelaxNGSetParserStructuredErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRelaxNGSetValidErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRelaxNGSetValidStructuredErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRelaxNGValidateDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlRelaxNGValidCtxtPtr ctxt; /* a Relax-NG validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a parsed document tree */
    int n_doc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlRelaxNGValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlRelaxNGValidateDoc(ctxt, doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlRelaxNGValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGValidateDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGValidateFullElement(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlRelaxNGValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlRelaxNGValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);

        ret_val = xmlRelaxNGValidateFullElement(ctxt, doc, elem);
        desret_int(ret_val);
        call_tests++;
        des_xmlRelaxNGValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGValidateFullElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGValidatePopElement(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlRelaxNGValidCtxtPtr ctxt; /* the RelaxNG validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlRelaxNGValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);

        ret_val = xmlRelaxNGValidatePopElement(ctxt, doc, elem);
        desret_int(ret_val);
        call_tests++;
        des_xmlRelaxNGValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGValidatePopElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGValidatePushCData(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlRelaxNGValidCtxtPtr ctxt; /* the RelaxNG validation context */
    int n_ctxt;
    xmlChar * data; /* some character data read */
    int n_data;
    int len; /* the lenght of the data */
    int n_len;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGValidCtxtPtr;n_ctxt++) {
    for (n_data = 0;n_data < gen_nb_const_xmlChar_ptr;n_data++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlRelaxNGValidCtxtPtr(n_ctxt, 0);
        data = gen_const_xmlChar_ptr(n_data, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlRelaxNGValidatePushCData(ctxt, (const xmlChar *)data, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlRelaxNGValidCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_data, (const xmlChar *)data, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGValidatePushCData",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_data);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxNGValidatePushElement(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlRelaxNGValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlRelaxNGValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);

        ret_val = xmlRelaxNGValidatePushElement(ctxt, doc, elem);
        desret_int(ret_val);
        call_tests++;
        des_xmlRelaxNGValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxNGValidatePushElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRelaxParserSetFlag(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlRelaxNGParserCtxtPtr ctxt; /* a RelaxNG parser context */
    int n_ctxt;
    int flags; /* a set of flags values */
    int n_flags;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGParserCtxtPtr;n_ctxt++) {
    for (n_flags = 0;n_flags < gen_nb_int;n_flags++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlRelaxNGParserCtxtPtr(n_ctxt, 0);
        flags = gen_int(n_flags, 1);

        ret_val = xmlRelaxParserSetFlag(ctxt, flags);
        desret_int(ret_val);
        call_tests++;
        des_xmlRelaxNGParserCtxtPtr(n_ctxt, ctxt, 0);
        des_int(n_flags, flags, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRelaxParserSetFlag",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_flags);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_relaxng(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing relaxng : 14 of 24 functions ...\n");
    test_ret += test_xmlRelaxNGDump();
    test_ret += test_xmlRelaxNGDumpTree();
    test_ret += test_xmlRelaxNGGetParserErrors();
    test_ret += test_xmlRelaxNGGetValidErrors();
    test_ret += test_xmlRelaxNGInitTypes();
    test_ret += test_xmlRelaxNGNewDocParserCtxt();
    test_ret += test_xmlRelaxNGNewMemParserCtxt();
    test_ret += test_xmlRelaxNGNewParserCtxt();
    test_ret += test_xmlRelaxNGNewValidCtxt();
    test_ret += test_xmlRelaxNGParse();
    test_ret += test_xmlRelaxNGSetParserErrors();
    test_ret += test_xmlRelaxNGSetParserStructuredErrors();
    test_ret += test_xmlRelaxNGSetValidErrors();
    test_ret += test_xmlRelaxNGSetValidStructuredErrors();
    test_ret += test_xmlRelaxNGValidateDoc();
    test_ret += test_xmlRelaxNGValidateFullElement();
    test_ret += test_xmlRelaxNGValidatePopElement();
    test_ret += test_xmlRelaxNGValidatePushCData();
    test_ret += test_xmlRelaxNGValidatePushElement();
    test_ret += test_xmlRelaxParserSetFlag();

    if (test_ret != 0)
	printf("Module relaxng: %d errors\n", test_ret);
    return(test_ret);
}
static int
test_schemasInternals(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing schemasInternals : 0 of 2 functions ...\n");

    if (test_ret != 0)
	printf("Module schemasInternals: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlSchematronNewDocParserCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchematronNewMemParserCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchematronNewParserCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

#ifdef LIBXML_SCHEMATRON_ENABLED

#define gen_nb_xmlSchematronPtr 1
static xmlSchematronPtr gen_xmlSchematronPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchematronPtr(int no ATTRIBUTE_UNUSED, xmlSchematronPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchematronNewValidCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

#ifdef LIBXML_SCHEMATRON_ENABLED

#define gen_nb_xmlSchematronParserCtxtPtr 1
static xmlSchematronParserCtxtPtr gen_xmlSchematronParserCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchematronParserCtxtPtr(int no ATTRIBUTE_UNUSED, xmlSchematronParserCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchematronParse(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

#ifdef LIBXML_SCHEMATRON_ENABLED

#define gen_nb_xmlSchematronValidCtxtPtr 1
static xmlSchematronValidCtxtPtr gen_xmlSchematronValidCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchematronValidCtxtPtr(int no ATTRIBUTE_UNUSED, xmlSchematronValidCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchematronSetValidStructuredErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchematronValidateDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMATRON_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchematronValidCtxtPtr ctxt; /* the schema validation context */
    int n_ctxt;
    xmlDocPtr instance; /* the document instace tree */
    int n_instance;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchematronValidCtxtPtr;n_ctxt++) {
    for (n_instance = 0;n_instance < gen_nb_xmlDocPtr;n_instance++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchematronValidCtxtPtr(n_ctxt, 0);
        instance = gen_xmlDocPtr(n_instance, 1);

        ret_val = xmlSchematronValidateDoc(ctxt, instance);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchematronValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_instance, instance, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchematronValidateDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_instance);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_schematron(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing schematron : 1 of 10 functions ...\n");
    test_ret += test_xmlSchematronNewDocParserCtxt();
    test_ret += test_xmlSchematronNewMemParserCtxt();
    test_ret += test_xmlSchematronNewParserCtxt();
    test_ret += test_xmlSchematronNewValidCtxt();
    test_ret += test_xmlSchematronParse();
    test_ret += test_xmlSchematronSetValidStructuredErrors();
    test_ret += test_xmlSchematronValidateDoc();

    if (test_ret != 0)
	printf("Module schematron: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlAddChild(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr parent; /* the parent node */
    int n_parent;
    xmlNodePtr cur; /* the child node */
    int n_cur;

    for (n_parent = 0;n_parent < gen_nb_xmlNodePtr;n_parent++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr_in;n_cur++) {
        mem_base = xmlMemBlocks();
        parent = gen_xmlNodePtr(n_parent, 0);
        cur = gen_xmlNodePtr_in(n_cur, 1);

        ret_val = xmlAddChild(parent, cur);
        if (ret_val == NULL) { xmlFreeNode(cur) ; cur = NULL ; }
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_parent, parent, 0);
        des_xmlNodePtr_in(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddChild",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlAddChildList(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr parent; /* the parent node */
    int n_parent;
    xmlNodePtr cur; /* the first node in the list */
    int n_cur;

    for (n_parent = 0;n_parent < gen_nb_xmlNodePtr;n_parent++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr_in;n_cur++) {
        mem_base = xmlMemBlocks();
        parent = gen_xmlNodePtr(n_parent, 0);
        cur = gen_xmlNodePtr_in(n_cur, 1);

        ret_val = xmlAddChildList(parent, cur);
        if (ret_val == NULL) { xmlFreeNodeList(cur) ; cur = NULL ; }
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_parent, parent, 0);
        des_xmlNodePtr_in(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddChildList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlAddNextSibling(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr cur; /* the child node */
    int n_cur;
    xmlNodePtr elem; /* the new node */
    int n_elem;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr_in;n_elem++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        elem = gen_xmlNodePtr_in(n_elem, 1);

        ret_val = xmlAddNextSibling(cur, elem);
        if (ret_val == NULL) { xmlFreeNode(elem) ; elem = NULL ; }
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_xmlNodePtr_in(n_elem, elem, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddNextSibling",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlAddPrevSibling(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_HTML_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr cur; /* the child node */
    int n_cur;
    xmlNodePtr elem; /* the new node */
    int n_elem;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr_in;n_elem++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        elem = gen_xmlNodePtr_in(n_elem, 1);

        ret_val = xmlAddPrevSibling(cur, elem);
        if (ret_val == NULL) { xmlFreeNode(elem) ; elem = NULL ; }
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_xmlNodePtr_in(n_elem, elem, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddPrevSibling",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlAddSibling(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr cur; /* the child node */
    int n_cur;
    xmlNodePtr elem; /* the new node */
    int n_elem;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr_in;n_elem++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        elem = gen_xmlNodePtr_in(n_elem, 1);

        ret_val = xmlAddSibling(cur, elem);
        if (ret_val == NULL) { xmlFreeNode(elem) ; elem = NULL ; }
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_xmlNodePtr_in(n_elem, elem, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddSibling",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlAttrSerializeTxtContent(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
#ifdef LIBXML_OUTPUT_ENABLED
    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlAttrPtr attr; /* the attribute node */
    int n_attr;
    xmlChar * string; /* the text content */
    int n_string;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttrPtr;n_attr++) {
    for (n_string = 0;n_string < gen_nb_const_xmlChar_ptr;n_string++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        attr = gen_xmlAttrPtr(n_attr, 2);
        string = gen_const_xmlChar_ptr(n_string, 3);

        xmlAttrSerializeTxtContent(buf, doc, attr, (const xmlChar *)string);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlAttrPtr(n_attr, attr, 2);
        des_const_xmlChar_ptr(n_string, (const xmlChar *)string, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAttrSerializeTxtContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_doc);
            printf(" %d", n_attr);
            printf(" %d", n_string);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlBufferAdd(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the buffer to dump */
    int n_buf;
    xmlChar * str; /* the #xmlChar string */
    int n_str;
    int len; /* the number of #xmlChar to add */
    int n_len;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        str = gen_const_xmlChar_ptr(n_str, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlBufferAdd(buf, (const xmlChar *)str, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferAdd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_str);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferAddHead(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the buffer */
    int n_buf;
    xmlChar * str; /* the #xmlChar string */
    int n_str;
    int len; /* the number of #xmlChar to add */
    int n_len;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        str = gen_const_xmlChar_ptr(n_str, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlBufferAddHead(buf, (const xmlChar *)str, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferAddHead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_str);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferCCat(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the buffer to dump */
    int n_buf;
    char * str; /* the C char string */
    int n_str;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_str = 0;n_str < gen_nb_const_char_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        str = gen_const_char_ptr(n_str, 1);

        ret_val = xmlBufferCCat(buf, (const char *)str);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_const_char_ptr(n_str, (const char *)str, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferCCat",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_str);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferCat(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the buffer to add to */
    int n_buf;
    xmlChar * str; /* the #xmlChar string */
    int n_str;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        str = gen_const_xmlChar_ptr(n_str, 1);

        ret_val = xmlBufferCat(buf, (const xmlChar *)str);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferCat",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_str);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_const_xmlBufferPtr 1
static xmlBufferPtr gen_const_xmlBufferPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_const_xmlBufferPtr(int no ATTRIBUTE_UNUSED, const xmlBufferPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlBufferContent(void) {
    int test_ret = 0;

    int mem_base;
    const xmlChar * ret_val;
    xmlBufferPtr buf; /* the buffer */
    int n_buf;

    for (n_buf = 0;n_buf < gen_nb_const_xmlBufferPtr;n_buf++) {
        mem_base = xmlMemBlocks();
        buf = gen_const_xmlBufferPtr(n_buf, 0);

        ret_val = xmlBufferContent((const xmlBufferPtr)buf);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlBufferPtr(n_buf, (const xmlBufferPtr)buf, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferCreate(void) {
    int test_ret = 0;

    int mem_base;
    xmlBufferPtr ret_val;

        mem_base = xmlMemBlocks();

        ret_val = xmlBufferCreate();
        desret_xmlBufferPtr(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferCreate",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferCreateSize(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlBufferCreateStatic(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlBufferDetach(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlBufferPtr buf; /* the buffer */
    int n_buf;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);

        ret_val = xmlBufferDetach(buf);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferDetach",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferEmpty(void) {
    int test_ret = 0;

    int mem_base;
    xmlBufferPtr buf; /* the buffer */
    int n_buf;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);

        xmlBufferEmpty(buf);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferEmpty",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferGrow(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the buffer */
    int n_buf;
    unsigned int len; /* the minimum free size to allocate */
    int n_len;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_len = 0;n_len < gen_nb_unsigned_int;n_len++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        len = gen_unsigned_int(n_len, 1);

        ret_val = xmlBufferGrow(buf, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_unsigned_int(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferGrow",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferLength(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the buffer */
    int n_buf;

    for (n_buf = 0;n_buf < gen_nb_const_xmlBufferPtr;n_buf++) {
        mem_base = xmlMemBlocks();
        buf = gen_const_xmlBufferPtr(n_buf, 0);

        ret_val = xmlBufferLength((const xmlBufferPtr)buf);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlBufferPtr(n_buf, (const xmlBufferPtr)buf, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferLength",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferResize(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the buffer to resize */
    int n_buf;
    unsigned int size; /* the desired size */
    int n_size;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_size = 0;n_size < gen_nb_unsigned_int;n_size++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        size = gen_unsigned_int(n_size, 1);

        ret_val = xmlBufferResize(buf, size);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_unsigned_int(n_size, size, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferResize",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferSetAllocationScheme(void) {
    int test_ret = 0;

    int mem_base;
    xmlBufferPtr buf; /* the buffer to tune */
    int n_buf;
    xmlBufferAllocationScheme scheme; /* allocation scheme to use */
    int n_scheme;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_scheme = 0;n_scheme < gen_nb_xmlBufferAllocationScheme;n_scheme++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        scheme = gen_xmlBufferAllocationScheme(n_scheme, 1);

        xmlBufferSetAllocationScheme(buf, scheme);
        if ((buf != NULL) && (scheme == XML_BUFFER_ALLOC_IMMUTABLE) && (buf->content != NULL) && (buf->content != static_buf_content)) { xmlFree(buf->content); buf->content = NULL;}
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlBufferAllocationScheme(n_scheme, scheme, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferSetAllocationScheme",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_scheme);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferShrink(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the buffer to dump */
    int n_buf;
    unsigned int len; /* the number of xmlChar to remove */
    int n_len;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_len = 0;n_len < gen_nb_unsigned_int;n_len++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        len = gen_unsigned_int(n_len, 1);

        ret_val = xmlBufferShrink(buf, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_unsigned_int(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferShrink",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferWriteCHAR(void) {
    int test_ret = 0;

    int mem_base;
    xmlBufferPtr buf; /* the XML buffer */
    int n_buf;
    xmlChar * string; /* the string to add */
    int n_string;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_string = 0;n_string < gen_nb_const_xmlChar_ptr;n_string++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        string = gen_const_xmlChar_ptr(n_string, 1);

        xmlBufferWriteCHAR(buf, (const xmlChar *)string);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_const_xmlChar_ptr(n_string, (const xmlChar *)string, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferWriteCHAR",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_string);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferWriteChar(void) {
    int test_ret = 0;

    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    char * string; /* the string to add */
    int n_string;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_string = 0;n_string < gen_nb_const_char_ptr;n_string++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        string = gen_const_char_ptr(n_string, 1);

        xmlBufferWriteChar(buf, (const char *)string);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_const_char_ptr(n_string, (const char *)string, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferWriteChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_string);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBufferWriteQuotedString(void) {
    int test_ret = 0;

    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlChar * string; /* the string to add */
    int n_string;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_string = 0;n_string < gen_nb_const_xmlChar_ptr;n_string++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        string = gen_const_xmlChar_ptr(n_string, 1);

        xmlBufferWriteQuotedString(buf, (const xmlChar *)string);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_const_xmlChar_ptr(n_string, (const xmlChar *)string, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBufferWriteQuotedString",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_string);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBuildQName(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * ncname; /* the Name */
    int n_ncname;
    xmlChar * prefix; /* the prefix */
    int n_prefix;
    xmlChar * memory; /* preallocated memory */
    int n_memory;
    int len; /* preallocated memory length */
    int n_len;

    for (n_ncname = 0;n_ncname < gen_nb_const_xmlChar_ptr;n_ncname++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
    for (n_memory = 0;n_memory < gen_nb_xmlChar_ptr;n_memory++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ncname = gen_const_xmlChar_ptr(n_ncname, 0);
        prefix = gen_const_xmlChar_ptr(n_prefix, 1);
        memory = gen_xmlChar_ptr(n_memory, 2);
        len = gen_int(n_len, 3);

        ret_val = xmlBuildQName((const xmlChar *)ncname, (const xmlChar *)prefix, memory, len);
        if ((ret_val != NULL) && (ret_val != ncname) &&
              (ret_val != prefix) && (ret_val != memory))
              xmlFree(ret_val);
	  ret_val = NULL;
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_ncname, (const xmlChar *)ncname, 0);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 1);
        des_xmlChar_ptr(n_memory, memory, 2);
        des_int(n_len, len, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBuildQName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ncname);
            printf(" %d", n_prefix);
            printf(" %d", n_memory);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlChildElementCount(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    unsigned long ret_val;
    xmlNodePtr parent; /* the parent node */
    int n_parent;

    for (n_parent = 0;n_parent < gen_nb_xmlNodePtr;n_parent++) {
        mem_base = xmlMemBlocks();
        parent = gen_xmlNodePtr(n_parent, 0);

        ret_val = xmlChildElementCount(parent);
        desret_unsigned_long(ret_val);
        call_tests++;
        des_xmlNodePtr(n_parent, parent, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlChildElementCount",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCopyDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlDocPtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    int recursive; /* if not zero do a recursive copy. */
    int n_recursive;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_recursive = 0;n_recursive < gen_nb_int;n_recursive++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        recursive = gen_int(n_recursive, 1);

        ret_val = xmlCopyDoc(doc, recursive);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_int(n_recursive, recursive, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_recursive);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCopyDtd(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlDtdPtr ret_val;
    xmlDtdPtr dtd; /* the dtd */
    int n_dtd;

    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
        mem_base = xmlMemBlocks();
        dtd = gen_xmlDtdPtr(n_dtd, 0);

        ret_val = xmlCopyDtd(dtd);
        desret_xmlDtdPtr(ret_val);
        call_tests++;
        des_xmlDtdPtr(n_dtd, dtd, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyDtd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dtd);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlCopyNamespace(void) {
    int test_ret = 0;

    int mem_base;
    xmlNsPtr ret_val;
    xmlNsPtr cur; /* the namespace */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_xmlNsPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNsPtr(n_cur, 0);

        ret_val = xmlCopyNamespace(cur);
        if (ret_val != NULL) xmlFreeNs(ret_val);
        desret_xmlNsPtr(ret_val);
        call_tests++;
        des_xmlNsPtr(n_cur, cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyNamespace",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCopyNamespaceList(void) {
    int test_ret = 0;

    int mem_base;
    xmlNsPtr ret_val;
    xmlNsPtr cur; /* the first namespace */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_xmlNsPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNsPtr(n_cur, 0);

        ret_val = xmlCopyNamespaceList(cur);
        if (ret_val != NULL) xmlFreeNsList(ret_val);
        desret_xmlNsPtr(ret_val);
        call_tests++;
        des_xmlNsPtr(n_cur, cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyNamespaceList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCopyNode(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    int extended; /* if 1 do a recursive copy (properties, namespaces and children when applicable) if 2 copy properties and namespaces (when applicable) */
    int n_extended;

    for (n_node = 0;n_node < gen_nb_const_xmlNodePtr;n_node++) {
    for (n_extended = 0;n_extended < gen_nb_int;n_extended++) {
        mem_base = xmlMemBlocks();
        node = gen_const_xmlNodePtr(n_node, 0);
        extended = gen_int(n_extended, 1);

        ret_val = xmlCopyNode((const xmlNodePtr)node, extended);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_const_xmlNodePtr(n_node, (const xmlNodePtr)node, 0);
        des_int(n_extended, extended, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_extended);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCopyNodeList(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr node; /* the first node in the list. */
    int n_node;

    for (n_node = 0;n_node < gen_nb_const_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        node = gen_const_xmlNodePtr(n_node, 0);

        ret_val = xmlCopyNodeList((const xmlNodePtr)node);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_const_xmlNodePtr(n_node, (const xmlNodePtr)node, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyNodeList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCopyProp(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr target; /* the element where the attribute will be grafted */
    int n_target;
    xmlAttrPtr cur; /* the attribute */
    int n_cur;

    for (n_target = 0;n_target < gen_nb_xmlNodePtr;n_target++) {
    for (n_cur = 0;n_cur < gen_nb_xmlAttrPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        target = gen_xmlNodePtr(n_target, 0);
        cur = gen_xmlAttrPtr(n_cur, 1);

        ret_val = xmlCopyProp(target, cur);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_target, target, 0);
        des_xmlAttrPtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_target);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCopyPropList(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr target; /* the element where the attributes will be grafted */
    int n_target;
    xmlAttrPtr cur; /* the first attribute */
    int n_cur;

    for (n_target = 0;n_target < gen_nb_xmlNodePtr;n_target++) {
    for (n_cur = 0;n_cur < gen_nb_xmlAttrPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        target = gen_xmlNodePtr(n_target, 0);
        cur = gen_xmlAttrPtr(n_cur, 1);

        ret_val = xmlCopyPropList(target, cur);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_target, target, 0);
        des_xmlAttrPtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyPropList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_target);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCreateIntSubset(void) {
    int test_ret = 0;

    int mem_base;
    xmlDtdPtr ret_val;
    xmlDocPtr doc; /* the document pointer */
    int n_doc;
    xmlChar * name; /* the DTD name */
    int n_name;
    xmlChar * ExternalID; /* the external (PUBLIC) ID */
    int n_ExternalID;
    xmlChar * SystemID; /* the system ID */
    int n_SystemID;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 2);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 3);

        ret_val = xmlCreateIntSubset(doc, (const xmlChar *)name, (const xmlChar *)ExternalID, (const xmlChar *)SystemID);
        desret_xmlDtdPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 2);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCreateIntSubset",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlDOMWrapCtxtPtr 1
static xmlDOMWrapCtxtPtr gen_xmlDOMWrapCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlDOMWrapCtxtPtr(int no ATTRIBUTE_UNUSED, xmlDOMWrapCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlDOMWrapAdoptNode(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDOMWrapCtxtPtr ctxt; /* the optional context for custom processing */
    int n_ctxt;
    xmlDocPtr sourceDoc; /* the optional sourceDoc */
    int n_sourceDoc;
    xmlNodePtr node; /* the node to start with */
    int n_node;
    xmlDocPtr destDoc; /* the destination doc */
    int n_destDoc;
    xmlNodePtr destParent; /* the optional new parent of @node in @destDoc */
    int n_destParent;
    int options; /* option flags */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlDOMWrapCtxtPtr;n_ctxt++) {
    for (n_sourceDoc = 0;n_sourceDoc < gen_nb_xmlDocPtr;n_sourceDoc++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_destDoc = 0;n_destDoc < gen_nb_xmlDocPtr;n_destDoc++) {
    for (n_destParent = 0;n_destParent < gen_nb_xmlNodePtr;n_destParent++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlDOMWrapCtxtPtr(n_ctxt, 0);
        sourceDoc = gen_xmlDocPtr(n_sourceDoc, 1);
        node = gen_xmlNodePtr(n_node, 2);
        destDoc = gen_xmlDocPtr(n_destDoc, 3);
        destParent = gen_xmlNodePtr(n_destParent, 4);
        options = gen_int(n_options, 5);

        ret_val = xmlDOMWrapAdoptNode(ctxt, sourceDoc, node, destDoc, destParent, options);
        if ((node != NULL) && (node->parent == NULL)) {xmlUnlinkNode(node);xmlFreeNode(node);node = NULL;}
        desret_int(ret_val);
        call_tests++;
        des_xmlDOMWrapCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_sourceDoc, sourceDoc, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlDocPtr(n_destDoc, destDoc, 3);
        des_xmlNodePtr(n_destParent, destParent, 4);
        des_int(n_options, options, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDOMWrapAdoptNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_sourceDoc);
            printf(" %d", n_node);
            printf(" %d", n_destDoc);
            printf(" %d", n_destParent);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDOMWrapCloneNode(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDOMWrapCtxtPtr ctxt; /* the optional context for custom processing */
    int n_ctxt;
    xmlDocPtr sourceDoc; /* the optional sourceDoc */
    int n_sourceDoc;
    xmlNodePtr node; /* the node to start with */
    int n_node;
    xmlNodePtr * resNode; /* the clone of the given @node */
    int n_resNode;
    xmlDocPtr destDoc; /* the destination doc */
    int n_destDoc;
    xmlNodePtr destParent; /* the optional new parent of @node in @destDoc */
    int n_destParent;
    int deep; /* descend into child if set */
    int n_deep;
    int options; /* option flags */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlDOMWrapCtxtPtr;n_ctxt++) {
    for (n_sourceDoc = 0;n_sourceDoc < gen_nb_xmlDocPtr;n_sourceDoc++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_resNode = 0;n_resNode < gen_nb_xmlNodePtr_ptr;n_resNode++) {
    for (n_destDoc = 0;n_destDoc < gen_nb_xmlDocPtr;n_destDoc++) {
    for (n_destParent = 0;n_destParent < gen_nb_xmlNodePtr;n_destParent++) {
    for (n_deep = 0;n_deep < gen_nb_int;n_deep++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlDOMWrapCtxtPtr(n_ctxt, 0);
        sourceDoc = gen_xmlDocPtr(n_sourceDoc, 1);
        node = gen_xmlNodePtr(n_node, 2);
        resNode = gen_xmlNodePtr_ptr(n_resNode, 3);
        destDoc = gen_xmlDocPtr(n_destDoc, 4);
        destParent = gen_xmlNodePtr(n_destParent, 5);
        deep = gen_int(n_deep, 6);
        options = gen_int(n_options, 7);

        ret_val = xmlDOMWrapCloneNode(ctxt, sourceDoc, node, resNode, destDoc, destParent, deep, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlDOMWrapCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_sourceDoc, sourceDoc, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_xmlNodePtr_ptr(n_resNode, resNode, 3);
        des_xmlDocPtr(n_destDoc, destDoc, 4);
        des_xmlNodePtr(n_destParent, destParent, 5);
        des_int(n_deep, deep, 6);
        des_int(n_options, options, 7);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDOMWrapCloneNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_sourceDoc);
            printf(" %d", n_node);
            printf(" %d", n_resNode);
            printf(" %d", n_destDoc);
            printf(" %d", n_destParent);
            printf(" %d", n_deep);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDOMWrapNewCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlDOMWrapReconcileNamespaces(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDOMWrapCtxtPtr ctxt; /* DOM wrapper context, unused at the moment */
    int n_ctxt;
    xmlNodePtr elem; /* the element-node */
    int n_elem;
    int options; /* option flags */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlDOMWrapCtxtPtr;n_ctxt++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlDOMWrapCtxtPtr(n_ctxt, 0);
        elem = gen_xmlNodePtr(n_elem, 1);
        options = gen_int(n_options, 2);

        ret_val = xmlDOMWrapReconcileNamespaces(ctxt, elem, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlDOMWrapCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlNodePtr(n_elem, elem, 1);
        des_int(n_options, options, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDOMWrapReconcileNamespaces",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_elem);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDOMWrapRemoveNode(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDOMWrapCtxtPtr ctxt; /* a DOM wrapper context */
    int n_ctxt;
    xmlDocPtr doc; /* the doc */
    int n_doc;
    xmlNodePtr node; /* the node to be removed. */
    int n_node;
    int options; /* set of options, unused at the moment */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlDOMWrapCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlDOMWrapCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        node = gen_xmlNodePtr(n_node, 2);
        options = gen_int(n_options, 3);

        ret_val = xmlDOMWrapRemoveNode(ctxt, doc, node, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlDOMWrapCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_node, node, 2);
        des_int(n_options, options, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDOMWrapRemoveNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_node);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDocCopyNode(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlDocPtr doc; /* the document */
    int n_doc;
    int extended; /* if 1 do a recursive copy (properties, namespaces and children when applicable) if 2 copy properties and namespaces (when applicable) */
    int n_extended;

    for (n_node = 0;n_node < gen_nb_const_xmlNodePtr;n_node++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_extended = 0;n_extended < gen_nb_int;n_extended++) {
        mem_base = xmlMemBlocks();
        node = gen_const_xmlNodePtr(n_node, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        extended = gen_int(n_extended, 2);

        ret_val = xmlDocCopyNode((const xmlNodePtr)node, doc, extended);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_const_xmlNodePtr(n_node, (const xmlNodePtr)node, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_int(n_extended, extended, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocCopyNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_doc);
            printf(" %d", n_extended);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDocCopyNodeList(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the target document */
    int n_doc;
    xmlNodePtr node; /* the first node in the list. */
    int n_node;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_node = 0;n_node < gen_nb_const_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        node = gen_const_xmlNodePtr(n_node, 1);

        ret_val = xmlDocCopyNodeList(doc, (const xmlNodePtr)node);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlNodePtr(n_node, (const xmlNodePtr)node, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocCopyNodeList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDocDump(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    FILE * f; /* the FILE* */
    int n_f;
    xmlDocPtr cur; /* the document */
    int n_cur;

    for (n_f = 0;n_f < gen_nb_FILE_ptr;n_f++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        f = gen_FILE_ptr(n_f, 0);
        cur = gen_xmlDocPtr(n_cur, 1);

        ret_val = xmlDocDump(f, cur);
        desret_int(ret_val);
        call_tests++;
        des_FILE_ptr(n_f, f, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_f);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDocDumpFormatMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlDocPtr cur; /* the document */
    int n_cur;
    xmlChar ** mem; /* OUT: the memory pointer */
    int n_mem;
    int * size; /* OUT: the memory length */
    int n_size;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_mem = 0;n_mem < gen_nb_xmlChar_ptr_ptr;n_mem++) {
    for (n_size = 0;n_size < gen_nb_int_ptr;n_size++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlDocPtr(n_cur, 0);
        mem = gen_xmlChar_ptr_ptr(n_mem, 1);
        size = gen_int_ptr(n_size, 2);
        format = gen_int(n_format, 3);

        xmlDocDumpFormatMemory(cur, mem, size, format);
        call_tests++;
        des_xmlDocPtr(n_cur, cur, 0);
        des_xmlChar_ptr_ptr(n_mem, mem, 1);
        des_int_ptr(n_size, size, 2);
        des_int(n_format, format, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocDumpFormatMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_mem);
            printf(" %d", n_size);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDocDumpFormatMemoryEnc(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlDocPtr out_doc; /* Document to generate XML text from */
    int n_out_doc;
    xmlChar ** doc_txt_ptr; /* Memory pointer for allocated XML text */
    int n_doc_txt_ptr;
    int * doc_txt_len; /* Length of the generated XML text */
    int n_doc_txt_len;
    char * txt_encoding; /* Character encoding to use when generating XML text */
    int n_txt_encoding;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_out_doc = 0;n_out_doc < gen_nb_xmlDocPtr;n_out_doc++) {
    for (n_doc_txt_ptr = 0;n_doc_txt_ptr < gen_nb_xmlChar_ptr_ptr;n_doc_txt_ptr++) {
    for (n_doc_txt_len = 0;n_doc_txt_len < gen_nb_int_ptr;n_doc_txt_len++) {
    for (n_txt_encoding = 0;n_txt_encoding < gen_nb_const_char_ptr;n_txt_encoding++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        out_doc = gen_xmlDocPtr(n_out_doc, 0);
        doc_txt_ptr = gen_xmlChar_ptr_ptr(n_doc_txt_ptr, 1);
        doc_txt_len = gen_int_ptr(n_doc_txt_len, 2);
        txt_encoding = gen_const_char_ptr(n_txt_encoding, 3);
        format = gen_int(n_format, 4);

        xmlDocDumpFormatMemoryEnc(out_doc, doc_txt_ptr, doc_txt_len, (const char *)txt_encoding, format);
        call_tests++;
        des_xmlDocPtr(n_out_doc, out_doc, 0);
        des_xmlChar_ptr_ptr(n_doc_txt_ptr, doc_txt_ptr, 1);
        des_int_ptr(n_doc_txt_len, doc_txt_len, 2);
        des_const_char_ptr(n_txt_encoding, (const char *)txt_encoding, 3);
        des_int(n_format, format, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocDumpFormatMemoryEnc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out_doc);
            printf(" %d", n_doc_txt_ptr);
            printf(" %d", n_doc_txt_len);
            printf(" %d", n_txt_encoding);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDocDumpMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlDocPtr cur; /* the document */
    int n_cur;
    xmlChar ** mem; /* OUT: the memory pointer */
    int n_mem;
    int * size; /* OUT: the memory length */
    int n_size;

    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_mem = 0;n_mem < gen_nb_xmlChar_ptr_ptr;n_mem++) {
    for (n_size = 0;n_size < gen_nb_int_ptr;n_size++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlDocPtr(n_cur, 0);
        mem = gen_xmlChar_ptr_ptr(n_mem, 1);
        size = gen_int_ptr(n_size, 2);

        xmlDocDumpMemory(cur, mem, size);
        call_tests++;
        des_xmlDocPtr(n_cur, cur, 0);
        des_xmlChar_ptr_ptr(n_mem, mem, 1);
        des_int_ptr(n_size, size, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocDumpMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_mem);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDocDumpMemoryEnc(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlDocPtr out_doc; /* Document to generate XML text from */
    int n_out_doc;
    xmlChar ** doc_txt_ptr; /* Memory pointer for allocated XML text */
    int n_doc_txt_ptr;
    int * doc_txt_len; /* Length of the generated XML text */
    int n_doc_txt_len;
    char * txt_encoding; /* Character encoding to use when generating XML text */
    int n_txt_encoding;

    for (n_out_doc = 0;n_out_doc < gen_nb_xmlDocPtr;n_out_doc++) {
    for (n_doc_txt_ptr = 0;n_doc_txt_ptr < gen_nb_xmlChar_ptr_ptr;n_doc_txt_ptr++) {
    for (n_doc_txt_len = 0;n_doc_txt_len < gen_nb_int_ptr;n_doc_txt_len++) {
    for (n_txt_encoding = 0;n_txt_encoding < gen_nb_const_char_ptr;n_txt_encoding++) {
        mem_base = xmlMemBlocks();
        out_doc = gen_xmlDocPtr(n_out_doc, 0);
        doc_txt_ptr = gen_xmlChar_ptr_ptr(n_doc_txt_ptr, 1);
        doc_txt_len = gen_int_ptr(n_doc_txt_len, 2);
        txt_encoding = gen_const_char_ptr(n_txt_encoding, 3);

        xmlDocDumpMemoryEnc(out_doc, doc_txt_ptr, doc_txt_len, (const char *)txt_encoding);
        call_tests++;
        des_xmlDocPtr(n_out_doc, out_doc, 0);
        des_xmlChar_ptr_ptr(n_doc_txt_ptr, doc_txt_ptr, 1);
        des_int_ptr(n_doc_txt_len, doc_txt_len, 2);
        des_const_char_ptr(n_txt_encoding, (const char *)txt_encoding, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocDumpMemoryEnc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out_doc);
            printf(" %d", n_doc_txt_ptr);
            printf(" %d", n_doc_txt_len);
            printf(" %d", n_txt_encoding);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDocFormatDump(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    FILE * f; /* the FILE* */
    int n_f;
    xmlDocPtr cur; /* the document */
    int n_cur;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_f = 0;n_f < gen_nb_FILE_ptr;n_f++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        f = gen_FILE_ptr(n_f, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        format = gen_int(n_format, 2);

        ret_val = xmlDocFormatDump(f, cur, format);
        desret_int(ret_val);
        call_tests++;
        des_FILE_ptr(n_f, f, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_int(n_format, format, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocFormatDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_f);
            printf(" %d", n_cur);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDocGetRootElement(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);

        ret_val = xmlDocGetRootElement(doc);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocGetRootElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlDocSetRootElement(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_WRITER_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr root; /* the new document root element, if root is NULL no action is taken, to remove a node from a document use xmlUnlinkNode(root) instead. */
    int n_root;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_root = 0;n_root < gen_nb_xmlNodePtr_in;n_root++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        root = gen_xmlNodePtr_in(n_root, 1);

        ret_val = xmlDocSetRootElement(doc, root);
        if (doc == NULL) { xmlFreeNode(root) ; root = NULL ; }
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr_in(n_root, root, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDocSetRootElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_root);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlElemDump(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    FILE * f; /* the FILE * for the output */
    int n_f;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr cur; /* the current node */
    int n_cur;

    for (n_f = 0;n_f < gen_nb_FILE_ptr;n_f++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
        mem_base = xmlMemBlocks();
        f = gen_FILE_ptr(n_f, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        cur = gen_xmlNodePtr(n_cur, 2);

        xmlElemDump(f, doc, cur);
        call_tests++;
        des_FILE_ptr(n_f, f, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_cur, cur, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlElemDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_f);
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlFirstElementChild(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr parent; /* the parent node */
    int n_parent;

    for (n_parent = 0;n_parent < gen_nb_xmlNodePtr;n_parent++) {
        mem_base = xmlMemBlocks();
        parent = gen_xmlNodePtr(n_parent, 0);

        ret_val = xmlFirstElementChild(parent);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_parent, parent, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlFirstElementChild",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlGetBufferAllocationScheme(void) {
    int test_ret = 0;

    int mem_base;
    xmlBufferAllocationScheme ret_val;

        mem_base = xmlMemBlocks();

        ret_val = xmlGetBufferAllocationScheme();
        desret_xmlBufferAllocationScheme(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetBufferAllocationScheme",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetCompressMode(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;

        mem_base = xmlMemBlocks();

        ret_val = xmlGetCompressMode();
        desret_int(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetCompressMode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetDocCompressMode(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);

        ret_val = xmlGetDocCompressMode(doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetDocCompressMode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetIntSubset(void) {
    int test_ret = 0;

    int mem_base;
    xmlDtdPtr ret_val;
    xmlDocPtr doc; /* the document pointer */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);

        ret_val = xmlGetIntSubset(doc);
        desret_xmlDtdPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetIntSubset",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetLastChild(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr parent; /* the parent node */
    int n_parent;

    for (n_parent = 0;n_parent < gen_nb_xmlNodePtr;n_parent++) {
        mem_base = xmlMemBlocks();
        parent = gen_xmlNodePtr(n_parent, 0);

        ret_val = xmlGetLastChild(parent);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_parent, parent, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetLastChild",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetLineNo(void) {
    int test_ret = 0;

    int mem_base;
    long ret_val;
    xmlNodePtr node; /* valid node */
    int n_node;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);

        ret_val = xmlGetLineNo(node);
        desret_long(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetLineNo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetNoNsProp(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlChar * name; /* the attribute name */
    int n_name;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlGetNoNsProp(node, (const xmlChar *)name);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetNoNsProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetNodePath(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_DEBUG_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlNodePtr node; /* a node */
    int n_node;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);

        ret_val = xmlGetNodePath(node);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetNodePath",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlGetNsList(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlGetNsProp(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlChar * name; /* the attribute name */
    int n_name;
    xmlChar * nameSpace; /* the URI of the namespace */
    int n_nameSpace;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_nameSpace = 0;n_nameSpace < gen_nb_const_xmlChar_ptr;n_nameSpace++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        nameSpace = gen_const_xmlChar_ptr(n_nameSpace, 2);

        ret_val = xmlGetNsProp(node, (const xmlChar *)name, (const xmlChar *)nameSpace);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_nameSpace, (const xmlChar *)nameSpace, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetNsProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_name);
            printf(" %d", n_nameSpace);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetProp(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlChar * name; /* the attribute name */
    int n_name;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlGetProp(node, (const xmlChar *)name);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHasNsProp(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlChar * name; /* the attribute name */
    int n_name;
    xmlChar * nameSpace; /* the URI of the namespace */
    int n_nameSpace;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_nameSpace = 0;n_nameSpace < gen_nb_const_xmlChar_ptr;n_nameSpace++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        nameSpace = gen_const_xmlChar_ptr(n_nameSpace, 2);

        ret_val = xmlHasNsProp(node, (const xmlChar *)name, (const xmlChar *)nameSpace);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_nameSpace, (const xmlChar *)nameSpace, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHasNsProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_name);
            printf(" %d", n_nameSpace);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlHasProp(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlChar * name; /* the attribute name */
    int n_name;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlHasProp(node, (const xmlChar *)name);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlHasProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsBlankNode(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlNodePtr node; /* the node */
    int n_node;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);

        ret_val = xmlIsBlankNode(node);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsBlankNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsXHTML(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlChar * systemID; /* the system identifier */
    int n_systemID;
    xmlChar * publicID; /* the public identifier */
    int n_publicID;

    for (n_systemID = 0;n_systemID < gen_nb_const_xmlChar_ptr;n_systemID++) {
    for (n_publicID = 0;n_publicID < gen_nb_const_xmlChar_ptr;n_publicID++) {
        mem_base = xmlMemBlocks();
        systemID = gen_const_xmlChar_ptr(n_systemID, 0);
        publicID = gen_const_xmlChar_ptr(n_publicID, 1);

        ret_val = xmlIsXHTML((const xmlChar *)systemID, (const xmlChar *)publicID);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_systemID, (const xmlChar *)systemID, 0);
        des_const_xmlChar_ptr(n_publicID, (const xmlChar *)publicID, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsXHTML",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_systemID);
            printf(" %d", n_publicID);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlLastElementChild(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr parent; /* the parent node */
    int n_parent;

    for (n_parent = 0;n_parent < gen_nb_xmlNodePtr;n_parent++) {
        mem_base = xmlMemBlocks();
        parent = gen_xmlNodePtr(n_parent, 0);

        ret_val = xmlLastElementChild(parent);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_parent, parent, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlLastElementChild",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNewCDataBlock(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * content; /* the CDATA block content content */
    int n_content;
    int len; /* the length of the block */
    int n_len;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlNewCDataBlock(doc, (const xmlChar *)content, len);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewCDataBlock",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_content);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewCharRef(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * name; /* the char ref string, starting with # or "&# ... ;" */
    int n_name;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlNewCharRef(doc, (const xmlChar *)name);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewCharRef",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewChild(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr parent; /* the parent node */
    int n_parent;
    xmlNsPtr ns; /* a namespace if any */
    int n_ns;
    xmlChar * name; /* the name of the child */
    int n_name;
    xmlChar * content; /* the XML content of the child if any. */
    int n_content;

    for (n_parent = 0;n_parent < gen_nb_xmlNodePtr;n_parent++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        parent = gen_xmlNodePtr(n_parent, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        content = gen_const_xmlChar_ptr(n_content, 3);

        ret_val = xmlNewChild(parent, ns, (const xmlChar *)name, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_parent, parent, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewChild",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlNewComment(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlChar * content; /* the comment content */
    int n_content;

    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        content = gen_const_xmlChar_ptr(n_content, 0);

        ret_val = xmlNewComment((const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewComment",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_content);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDoc(void) {
    int test_ret = 0;

    int mem_base;
    xmlDocPtr ret_val;
    xmlChar * version; /* xmlChar string giving the version of XML "1.0" */
    int n_version;

    for (n_version = 0;n_version < gen_nb_const_xmlChar_ptr;n_version++) {
        mem_base = xmlMemBlocks();
        version = gen_const_xmlChar_ptr(n_version, 0);

        ret_val = xmlNewDoc((const xmlChar *)version);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_version, (const xmlChar *)version, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_version);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDocComment(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * content; /* the comment content */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);

        ret_val = xmlNewDocComment(doc, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocComment",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDocFragment(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document owning the fragment */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);

        ret_val = xmlNewDocFragment(doc);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocFragment",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNewDocNode(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNsPtr ns; /* namespace if any */
    int n_ns;
    xmlChar * name; /* the node name */
    int n_name;
    xmlChar * content; /* the XML text content if any */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        content = gen_const_xmlChar_ptr(n_content, 3);

        ret_val = xmlNewDocNode(doc, ns, (const xmlChar *)name, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDocNodeEatName(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNsPtr ns; /* namespace if any */
    int n_ns;
    xmlChar * name; /* the node name */
    int n_name;
    xmlChar * content; /* the XML text content if any */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_eaten_name;n_name++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_eaten_name(n_name, 2);
        content = gen_const_xmlChar_ptr(n_content, 3);

        ret_val = xmlNewDocNodeEatName(doc, ns, name, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_eaten_name(n_name, name, 2);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocNodeEatName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDocPI(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the target document */
    int n_doc;
    xmlChar * name; /* the processing instruction name */
    int n_name;
    xmlChar * content; /* the PI content */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        content = gen_const_xmlChar_ptr(n_content, 2);

        ret_val = xmlNewDocPI(doc, (const xmlChar *)name, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocPI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDocProp(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttrPtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * name; /* the name of the attribute */
    int n_name;
    xmlChar * value; /* the value of the attribute */
    int n_value;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        value = gen_const_xmlChar_ptr(n_value, 2);

        ret_val = xmlNewDocProp(doc, (const xmlChar *)name, (const xmlChar *)value);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDocRawNode(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNsPtr ns; /* namespace if any */
    int n_ns;
    xmlChar * name; /* the node name */
    int n_name;
    xmlChar * content; /* the text content if any */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        content = gen_const_xmlChar_ptr(n_content, 3);

        ret_val = xmlNewDocRawNode(doc, ns, (const xmlChar *)name, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocRawNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlNewDocText(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * content; /* the text content */
    int n_content;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);

        ret_val = xmlNewDocText(doc, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocText",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDocTextLen(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * content; /* the text content */
    int n_content;
    int len; /* the text len. */
    int n_len;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlNewDocTextLen(doc, (const xmlChar *)content, len);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocTextLen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_content);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDtd(void) {
    int test_ret = 0;

    int mem_base;
    xmlDtdPtr ret_val;
    xmlDocPtr doc; /* the document pointer */
    int n_doc;
    xmlChar * name; /* the DTD name */
    int n_name;
    xmlChar * ExternalID; /* the external ID */
    int n_ExternalID;
    xmlChar * SystemID; /* the system ID */
    int n_SystemID;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ExternalID = 0;n_ExternalID < gen_nb_const_xmlChar_ptr;n_ExternalID++) {
    for (n_SystemID = 0;n_SystemID < gen_nb_const_xmlChar_ptr;n_SystemID++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        ExternalID = gen_const_xmlChar_ptr(n_ExternalID, 2);
        SystemID = gen_const_xmlChar_ptr(n_SystemID, 3);

        ret_val = xmlNewDtd(doc, (const xmlChar *)name, (const xmlChar *)ExternalID, (const xmlChar *)SystemID);
        desret_xmlDtdPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_ExternalID, (const xmlChar *)ExternalID, 2);
        des_const_xmlChar_ptr(n_SystemID, (const xmlChar *)SystemID, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDtd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_ExternalID);
            printf(" %d", n_SystemID);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewNode(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNsPtr ns; /* namespace if any */
    int n_ns;
    xmlChar * name; /* the node name */
    int n_name;

    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        ns = gen_xmlNsPtr(n_ns, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlNewNode(ns, (const xmlChar *)name);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNsPtr(n_ns, ns, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewNodeEatName(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNsPtr ns; /* namespace if any */
    int n_ns;
    xmlChar * name; /* the node name */
    int n_name;

    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_eaten_name;n_name++) {
        mem_base = xmlMemBlocks();
        ns = gen_xmlNsPtr(n_ns, 0);
        name = gen_eaten_name(n_name, 1);

        ret_val = xmlNewNodeEatName(ns, name);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNsPtr(n_ns, ns, 0);
        des_eaten_name(n_name, name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewNodeEatName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewNs(void) {
    int test_ret = 0;

    int mem_base;
    xmlNsPtr ret_val;
    xmlNodePtr node; /* the element carrying the namespace */
    int n_node;
    xmlChar * href; /* the URI associated */
    int n_href;
    xmlChar * prefix; /* the prefix for the namespace */
    int n_prefix;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_href = 0;n_href < gen_nb_const_xmlChar_ptr;n_href++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        href = gen_const_xmlChar_ptr(n_href, 1);
        prefix = gen_const_xmlChar_ptr(n_prefix, 2);

        ret_val = xmlNewNs(node, (const xmlChar *)href, (const xmlChar *)prefix);
        if ((node == NULL) && (ret_val != NULL)) xmlFreeNs(ret_val);
        desret_xmlNsPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_href, (const xmlChar *)href, 1);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewNs",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_href);
            printf(" %d", n_prefix);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewNsProp(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr node; /* the holding node */
    int n_node;
    xmlNsPtr ns; /* the namespace */
    int n_ns;
    xmlChar * name; /* the name of the attribute */
    int n_name;
    xmlChar * value; /* the value of the attribute */
    int n_value;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        value = gen_const_xmlChar_ptr(n_value, 3);

        ret_val = xmlNewNsProp(node, ns, (const xmlChar *)name, (const xmlChar *)value);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewNsProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewNsPropEatName(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr node; /* the holding node */
    int n_node;
    xmlNsPtr ns; /* the namespace */
    int n_ns;
    xmlChar * name; /* the name of the attribute */
    int n_name;
    xmlChar * value; /* the value of the attribute */
    int n_value;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_eaten_name;n_name++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_eaten_name(n_name, 2);
        value = gen_const_xmlChar_ptr(n_value, 3);

        ret_val = xmlNewNsPropEatName(node, ns, name, (const xmlChar *)value);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_eaten_name(n_name, name, 2);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewNsPropEatName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewPI(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlChar * name; /* the processing instruction name */
    int n_name;
    xmlChar * content; /* the PI content */
    int n_content;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);

        ret_val = xmlNewPI((const xmlChar *)name, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewPI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewProp(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_HTML_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr node; /* the holding node */
    int n_node;
    xmlChar * name; /* the name of the attribute */
    int n_name;
    xmlChar * value; /* the value of the attribute */
    int n_value;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        value = gen_const_xmlChar_ptr(n_value, 2);

        ret_val = xmlNewProp(node, (const xmlChar *)name, (const xmlChar *)value);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlNewReference(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * name; /* the reference name, or the reference string with & and ; */
    int n_name;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlNewReference(doc, (const xmlChar *)name);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewReference",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewText(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlChar * content; /* the text content */
    int n_content;

    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        content = gen_const_xmlChar_ptr(n_content, 0);

        ret_val = xmlNewText((const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewText",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_content);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewTextChild(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr parent; /* the parent node */
    int n_parent;
    xmlNsPtr ns; /* a namespace if any */
    int n_ns;
    xmlChar * name; /* the name of the child */
    int n_name;
    xmlChar * content; /* the text content of the child if any. */
    int n_content;

    for (n_parent = 0;n_parent < gen_nb_xmlNodePtr;n_parent++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        parent = gen_xmlNodePtr(n_parent, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        content = gen_const_xmlChar_ptr(n_content, 3);

        ret_val = xmlNewTextChild(parent, ns, (const xmlChar *)name, (const xmlChar *)content);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_parent, parent, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewTextChild",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_parent);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlNewTextLen(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlChar * content; /* the text content */
    int n_content;
    int len; /* the text len. */
    int n_len;

    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        content = gen_const_xmlChar_ptr(n_content, 0);
        len = gen_int(n_len, 1);

        ret_val = xmlNewTextLen((const xmlChar *)content, len);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 0);
        des_int(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewTextLen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_content);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNextElementSibling(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr node; /* the current node */
    int n_node;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);

        ret_val = xmlNextElementSibling(node);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNextElementSibling",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNodeAddContent(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr cur; /* the node being modified */
    int n_cur;
    xmlChar * content; /* extra content */
    int n_content;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);

        xmlNodeAddContent(cur, (const xmlChar *)content);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeAddContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeAddContentLen(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr cur; /* the node being modified */
    int n_cur;
    xmlChar * content; /* extra content */
    int n_content;
    int len; /* the size of @content */
    int n_len;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);
        len = gen_int(n_len, 2);

        xmlNodeAddContentLen(cur, (const xmlChar *)content, len);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeAddContentLen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_content);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeBufGetContent(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlBufferPtr buffer; /* a buffer */
    int n_buffer;
    xmlNodePtr cur; /* the node being read */
    int n_cur;

    for (n_buffer = 0;n_buffer < gen_nb_xmlBufferPtr;n_buffer++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
        mem_base = xmlMemBlocks();
        buffer = gen_xmlBufferPtr(n_buffer, 0);
        cur = gen_xmlNodePtr(n_cur, 1);

        ret_val = xmlNodeBufGetContent(buffer, cur);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buffer, buffer, 0);
        des_xmlNodePtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeBufGetContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeDump(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr cur; /* the current node */
    int n_cur;
    int level; /* the imbrication level for indenting */
    int n_level;
    int format; /* is formatting allowed */
    int n_format;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_level = 0;n_level < gen_nb_int;n_level++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        cur = gen_xmlNodePtr(n_cur, 2);
        level = gen_int(n_level, 3);
        format = gen_int(n_format, 4);

        ret_val = xmlNodeDump(buf, doc, cur, level, format);
        desret_int(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_cur, cur, 2);
        des_int(n_level, level, 3);
        des_int(n_format, format, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf(" %d", n_level);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNodeDumpOutput(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr cur; /* the current node */
    int n_cur;
    int level; /* the imbrication level for indenting */
    int n_level;
    int format; /* is formatting allowed */
    int n_format;
    char * encoding; /* an optional encoding string */
    int n_encoding;

    for (n_buf = 0;n_buf < gen_nb_xmlOutputBufferPtr;n_buf++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_level = 0;n_level < gen_nb_int;n_level++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlOutputBufferPtr(n_buf, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        cur = gen_xmlNodePtr(n_cur, 2);
        level = gen_int(n_level, 3);
        format = gen_int(n_format, 4);
        encoding = gen_const_char_ptr(n_encoding, 5);

        xmlNodeDumpOutput(buf, doc, cur, level, format, (const char *)encoding);
        call_tests++;
        des_xmlOutputBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_cur, cur, 2);
        des_int(n_level, level, 3);
        des_int(n_format, format, 4);
        des_const_char_ptr(n_encoding, (const char *)encoding, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeDumpOutput",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf(" %d", n_level);
            printf(" %d", n_format);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNodeGetBase(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlDocPtr doc; /* the document the node pertains to */
    int n_doc;
    xmlNodePtr cur; /* the node being checked */
    int n_cur;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        cur = gen_xmlNodePtr(n_cur, 1);

        ret_val = xmlNodeGetBase(doc, cur);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeGetBase",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeGetContent(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlNodePtr cur; /* the node being read */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);

        ret_val = xmlNodeGetContent(cur);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeGetContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeGetLang(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlNodePtr cur; /* the node being checked */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);

        ret_val = xmlNodeGetLang(cur);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeGetLang",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeGetSpacePreserve(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlNodePtr cur; /* the node being checked */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);

        ret_val = xmlNodeGetSpacePreserve(cur);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeGetSpacePreserve",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeIsText(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlNodePtr node; /* the node */
    int n_node;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);

        ret_val = xmlNodeIsText(node);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeIsText",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeListGetRawString(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr list; /* a Node list */
    int n_list;
    int inLine; /* should we replace entity contents or show their external form */
    int n_inLine;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_list = 0;n_list < gen_nb_xmlNodePtr;n_list++) {
    for (n_inLine = 0;n_inLine < gen_nb_int;n_inLine++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        list = gen_xmlNodePtr(n_list, 1);
        inLine = gen_int(n_inLine, 2);

        ret_val = xmlNodeListGetRawString(doc, list, inLine);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_list, list, 1);
        des_int(n_inLine, inLine, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeListGetRawString",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_list);
            printf(" %d", n_inLine);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNodeListGetString(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr list; /* a Node list */
    int n_list;
    int inLine; /* should we replace entity contents or show their external form */
    int n_inLine;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_list = 0;n_list < gen_nb_xmlNodePtr;n_list++) {
    for (n_inLine = 0;n_inLine < gen_nb_int;n_inLine++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        list = gen_xmlNodePtr(n_list, 1);
        inLine = gen_int(n_inLine, 2);

        ret_val = xmlNodeListGetString(doc, list, inLine);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_list, list, 1);
        des_int(n_inLine, inLine, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeListGetString",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_list);
            printf(" %d", n_inLine);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeSetBase(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    xmlNodePtr cur; /* the node being changed */
    int n_cur;
    xmlChar * uri; /* the new base URI */
    int n_uri;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_uri = 0;n_uri < gen_nb_const_xmlChar_ptr;n_uri++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        uri = gen_const_xmlChar_ptr(n_uri, 1);

        xmlNodeSetBase(cur, (const xmlChar *)uri);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_const_xmlChar_ptr(n_uri, (const xmlChar *)uri, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeSetBase",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_uri);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNodeSetContent(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr cur; /* the node being modified */
    int n_cur;
    xmlChar * content; /* the new value of the content */
    int n_content;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);

        xmlNodeSetContent(cur, (const xmlChar *)content);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeSetContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNodeSetContentLen(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr cur; /* the node being modified */
    int n_cur;
    xmlChar * content; /* the new value of the content */
    int n_content;
    int len; /* the size of @content */
    int n_len;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);
        len = gen_int(n_len, 2);

        xmlNodeSetContentLen(cur, (const xmlChar *)content, len);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeSetContentLen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_content);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNodeSetLang(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr cur; /* the node being changed */
    int n_cur;
    xmlChar * lang; /* the language description */
    int n_lang;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_lang = 0;n_lang < gen_nb_const_xmlChar_ptr;n_lang++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        lang = gen_const_xmlChar_ptr(n_lang, 1);

        xmlNodeSetLang(cur, (const xmlChar *)lang);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_const_xmlChar_ptr(n_lang, (const xmlChar *)lang, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeSetLang",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_lang);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNodeSetName(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr cur; /* the node being changed */
    int n_cur;
    xmlChar * name; /* the new tag name */
    int n_name;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        xmlNodeSetName(cur, (const xmlChar *)name);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeSetName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNodeSetSpacePreserve(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr cur; /* the node being changed */
    int n_cur;
    int val; /* the xml:space value ("0": default, 1: "preserve") */
    int n_val;

    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr;n_cur++) {
    for (n_val = 0;n_val < gen_nb_int;n_val++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlNodePtr(n_cur, 0);
        val = gen_int(n_val, 1);

        xmlNodeSetSpacePreserve(cur, val);
        call_tests++;
        des_xmlNodePtr(n_cur, cur, 0);
        des_int(n_val, val, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNodeSetSpacePreserve",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_val);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlPreviousElementSibling(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr node; /* the current node */
    int n_node;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);

        ret_val = xmlPreviousElementSibling(node);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPreviousElementSibling",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReconciliateNs(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr tree; /* a node defining the subtree to reconciliate */
    int n_tree;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_tree = 0;n_tree < gen_nb_xmlNodePtr;n_tree++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        tree = gen_xmlNodePtr(n_tree, 1);

        ret_val = xmlReconciliateNs(doc, tree);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_tree, tree, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReconciliateNs",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_tree);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlRemoveProp(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlAttrPtr cur; /* an attribute */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_xmlAttrPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlAttrPtr(n_cur, 0);

        ret_val = xmlRemoveProp(cur);
        cur = NULL;
        desret_int(ret_val);
        call_tests++;
        des_xmlAttrPtr(n_cur, cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRemoveProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlReplaceNode(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_WRITER_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr old; /* the old node */
    int n_old;
    xmlNodePtr cur; /* the node */
    int n_cur;

    for (n_old = 0;n_old < gen_nb_xmlNodePtr;n_old++) {
    for (n_cur = 0;n_cur < gen_nb_xmlNodePtr_in;n_cur++) {
        mem_base = xmlMemBlocks();
        old = gen_xmlNodePtr(n_old, 0);
        cur = gen_xmlNodePtr_in(n_cur, 1);

        ret_val = xmlReplaceNode(old, cur);
        if (cur != NULL) {
              xmlUnlinkNode(cur);
              xmlFreeNode(cur) ; cur = NULL ; }
          if (old != NULL) {
              xmlUnlinkNode(old);
              xmlFreeNode(old) ; old = NULL ; }
	  ret_val = NULL;
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_old, old, 0);
        des_xmlNodePtr_in(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReplaceNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_old);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveFile(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the filename (or URL) */
    int n_filename;
    xmlDocPtr cur; /* the document */
    int n_cur;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        cur = gen_xmlDocPtr(n_cur, 1);

        ret_val = xmlSaveFile(filename, cur);
        desret_int(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveFileEnc(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the filename (or URL) */
    int n_filename;
    xmlDocPtr cur; /* the document */
    int n_cur;
    char * encoding; /* the name of an encoding (or NULL) */
    int n_encoding;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);

        ret_val = xmlSaveFileEnc(filename, cur, (const char *)encoding);
        desret_int(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveFileEnc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveFileTo(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlOutputBufferPtr buf; /* an output I/O buffer */
    int n_buf;
    xmlDocPtr cur; /* the document */
    int n_cur;
    char * encoding; /* the encoding if any assuming the I/O layer handles the trancoding */
    int n_encoding;

    for (n_buf = 0;n_buf < gen_nb_xmlOutputBufferPtr;n_buf++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlOutputBufferPtr(n_buf, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);

        ret_val = xmlSaveFileTo(buf, cur, (const char *)encoding);
        buf = NULL;
        desret_int(ret_val);
        call_tests++;
        des_xmlOutputBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveFileTo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveFormatFile(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the filename (or URL) */
    int n_filename;
    xmlDocPtr cur; /* the document */
    int n_cur;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        format = gen_int(n_format, 2);

        ret_val = xmlSaveFormatFile(filename, cur, format);
        desret_int(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_int(n_format, format, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveFormatFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_cur);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveFormatFileEnc(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the filename or URL to output */
    int n_filename;
    xmlDocPtr cur; /* the document being saved */
    int n_cur;
    char * encoding; /* the name of the encoding to use or NULL. */
    int n_encoding;
    int format; /* should formatting spaces be added. */
    int n_format;

    for (n_filename = 0;n_filename < gen_nb_fileoutput;n_filename++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        filename = gen_fileoutput(n_filename, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        format = gen_int(n_format, 3);

        ret_val = xmlSaveFormatFileEnc(filename, cur, (const char *)encoding, format);
        desret_int(ret_val);
        call_tests++;
        des_fileoutput(n_filename, filename, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_int(n_format, format, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveFormatFileEnc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveFormatFileTo(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlOutputBufferPtr buf; /* an output I/O buffer */
    int n_buf;
    xmlDocPtr cur; /* the document */
    int n_cur;
    char * encoding; /* the encoding if any assuming the I/O layer handles the trancoding */
    int n_encoding;
    int format; /* should formatting spaces been added */
    int n_format;

    for (n_buf = 0;n_buf < gen_nb_xmlOutputBufferPtr;n_buf++) {
    for (n_cur = 0;n_cur < gen_nb_xmlDocPtr;n_cur++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_format = 0;n_format < gen_nb_int;n_format++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlOutputBufferPtr(n_buf, 0);
        cur = gen_xmlDocPtr(n_cur, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        format = gen_int(n_format, 3);

        ret_val = xmlSaveFormatFileTo(buf, cur, (const char *)encoding, format);
        buf = NULL;
        desret_int(ret_val);
        call_tests++;
        des_xmlOutputBufferPtr(n_buf, buf, 0);
        des_xmlDocPtr(n_cur, cur, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_int(n_format, format, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveFormatFileTo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_cur);
            printf(" %d", n_encoding);
            printf(" %d", n_format);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSearchNs(void) {
    int test_ret = 0;

    int mem_base;
    xmlNsPtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr node; /* the current node */
    int n_node;
    xmlChar * nameSpace; /* the namespace prefix */
    int n_nameSpace;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_nameSpace = 0;n_nameSpace < gen_nb_const_xmlChar_ptr;n_nameSpace++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        node = gen_xmlNodePtr(n_node, 1);
        nameSpace = gen_const_xmlChar_ptr(n_nameSpace, 2);

        ret_val = xmlSearchNs(doc, node, (const xmlChar *)nameSpace);
        desret_xmlNsPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_node, node, 1);
        des_const_xmlChar_ptr(n_nameSpace, (const xmlChar *)nameSpace, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSearchNs",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_node);
            printf(" %d", n_nameSpace);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSearchNsByHref(void) {
    int test_ret = 0;

    int mem_base;
    xmlNsPtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr node; /* the current node */
    int n_node;
    xmlChar * href; /* the namespace value */
    int n_href;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_href = 0;n_href < gen_nb_const_xmlChar_ptr;n_href++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        node = gen_xmlNodePtr(n_node, 1);
        href = gen_const_xmlChar_ptr(n_href, 2);

        ret_val = xmlSearchNsByHref(doc, node, (const xmlChar *)href);
        desret_xmlNsPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_node, node, 1);
        des_const_xmlChar_ptr(n_href, (const xmlChar *)href, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSearchNsByHref",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_node);
            printf(" %d", n_href);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSetBufferAllocationScheme(void) {
    int test_ret = 0;

    int mem_base;
    xmlBufferAllocationScheme scheme; /* allocation method to use */
    int n_scheme;

    for (n_scheme = 0;n_scheme < gen_nb_xmlBufferAllocationScheme;n_scheme++) {
        mem_base = xmlMemBlocks();
        scheme = gen_xmlBufferAllocationScheme(n_scheme, 0);

        xmlSetBufferAllocationScheme(scheme);
        call_tests++;
        des_xmlBufferAllocationScheme(n_scheme, scheme, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSetBufferAllocationScheme",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_scheme);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSetCompressMode(void) {
    int test_ret = 0;

    int mem_base;
    int mode; /* the compression ratio */
    int n_mode;

    for (n_mode = 0;n_mode < gen_nb_int;n_mode++) {
        mem_base = xmlMemBlocks();
        mode = gen_int(n_mode, 0);

        xmlSetCompressMode(mode);
        call_tests++;
        des_int(n_mode, mode, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSetCompressMode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_mode);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSetDocCompressMode(void) {
    int test_ret = 0;

    int mem_base;
    xmlDocPtr doc; /* the document */
    int n_doc;
    int mode; /* the compression ratio */
    int n_mode;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_mode = 0;n_mode < gen_nb_int;n_mode++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        mode = gen_int(n_mode, 1);

        xmlSetDocCompressMode(doc, mode);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_int(n_mode, mode, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSetDocCompressMode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_mode);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSetNs(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr node; /* a node in the document */
    int n_node;
    xmlNsPtr ns; /* a namespace pointer */
    int n_ns;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        ns = gen_xmlNsPtr(n_ns, 1);

        xmlSetNs(node, ns);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSetNs",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_ns);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSetNsProp(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_HTML_ENABLED)
    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlNsPtr ns; /* the namespace definition */
    int n_ns;
    xmlChar * name; /* the attribute name */
    int n_name;
    xmlChar * value; /* the attribute value */
    int n_value;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        value = gen_const_xmlChar_ptr(n_value, 3);

        ret_val = xmlSetNsProp(node, ns, (const xmlChar *)name, (const xmlChar *)value);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSetNsProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSetProp(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_HTML_ENABLED)
    int mem_base;
    xmlAttrPtr ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlChar * name; /* the attribute name (a QName) */
    int n_name;
    xmlChar * value; /* the attribute value */
    int n_value;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        value = gen_const_xmlChar_ptr(n_value, 2);

        ret_val = xmlSetProp(node, (const xmlChar *)name, (const xmlChar *)value);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSetProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSplitQName2(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * name; /* the full QName */
    int n_name;
    xmlChar ** prefix; /* a xmlChar ** */
    int n_prefix;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_prefix = 0;n_prefix < gen_nb_xmlChar_ptr_ptr;n_prefix++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);
        prefix = gen_xmlChar_ptr_ptr(n_prefix, 1);

        ret_val = xmlSplitQName2((const xmlChar *)name, prefix);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        des_xmlChar_ptr_ptr(n_prefix, prefix, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSplitQName2",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf(" %d", n_prefix);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSplitQName3(void) {
    int test_ret = 0;

    int mem_base;
    const xmlChar * ret_val;
    xmlChar * name; /* the full QName */
    int n_name;
    int * len; /* an int * */
    int n_len;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_len = 0;n_len < gen_nb_int_ptr;n_len++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);
        len = gen_int_ptr(n_len, 1);

        ret_val = xmlSplitQName3((const xmlChar *)name, len);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        des_int_ptr(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSplitQName3",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlStringGetNodeList(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * value; /* the value of the attribute */
    int n_value;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);

        ret_val = xmlStringGetNodeList(doc, (const xmlChar *)value);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStringGetNodeList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlStringLenGetNodeList(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * value; /* the value of the text */
    int n_value;
    int len; /* the length of the string value */
    int n_len;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlStringLenGetNodeList(doc, (const xmlChar *)value, len);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlStringLenGetNodeList",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_value);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlTextConcat(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlChar * content; /* the content */
    int n_content;
    int len; /* @content length */
    int n_len;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlTextConcat(node, (const xmlChar *)content, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextConcat",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_content);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlTextMerge(void) {
    int test_ret = 0;

    int mem_base;
    xmlNodePtr ret_val;
    xmlNodePtr first; /* the first text node */
    int n_first;
    xmlNodePtr second; /* the second text node being merged */
    int n_second;

    for (n_first = 0;n_first < gen_nb_xmlNodePtr_in;n_first++) {
    for (n_second = 0;n_second < gen_nb_xmlNodePtr_in;n_second++) {
        mem_base = xmlMemBlocks();
        first = gen_xmlNodePtr_in(n_first, 0);
        second = gen_xmlNodePtr_in(n_second, 1);

        ret_val = xmlTextMerge(first, second);
        if ((first != NULL) && (first->type != XML_TEXT_NODE)) {
              xmlUnlinkNode(second);
              xmlFreeNode(second) ; second = NULL ; }
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlNodePtr_in(n_first, first, 0);
        des_xmlNodePtr_in(n_second, second, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextMerge",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_first);
            printf(" %d", n_second);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlUnsetNsProp(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlNsPtr ns; /* the namespace definition */
    int n_ns;
    xmlChar * name; /* the attribute name */
    int n_name;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        ns = gen_xmlNsPtr(n_ns, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);

        ret_val = xmlUnsetNsProp(node, ns, (const xmlChar *)name);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_xmlNsPtr(n_ns, ns, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlUnsetNsProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_ns);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlUnsetProp(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlNodePtr node; /* the node */
    int n_node;
    xmlChar * name; /* the attribute name */
    int n_name;

    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        node = gen_xmlNodePtr(n_node, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlUnsetProp(node, (const xmlChar *)name);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_node, node, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlUnsetProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_node);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateNCName(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XPATH_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_DEBUG_ENABLED) || defined (LIBXML_HTML_ENABLED) || defined(LIBXML_SAX1_ENABLED) || defined(LIBXML_HTML_ENABLED) || defined(LIBXML_WRITER_ENABLED) || defined(LIBXML_DOCB_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    int ret_val;
    xmlChar * value; /* the value to check */
    int n_value;
    int space; /* allow spaces in front and end of the string */
    int n_space;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_space = 0;n_space < gen_nb_int;n_space++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);
        space = gen_int(n_space, 1);

        ret_val = xmlValidateNCName((const xmlChar *)value, space);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        des_int(n_space, space, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateNCName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf(" %d", n_space);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlValidateNMToken(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    int ret_val;
    xmlChar * value; /* the value to check */
    int n_value;
    int space; /* allow spaces in front and end of the string */
    int n_space;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_space = 0;n_space < gen_nb_int;n_space++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);
        space = gen_int(n_space, 1);

        ret_val = xmlValidateNMToken((const xmlChar *)value, space);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        des_int(n_space, space, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateNMToken",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf(" %d", n_space);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlValidateName(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    int ret_val;
    xmlChar * value; /* the value to check */
    int n_value;
    int space; /* allow spaces in front and end of the string */
    int n_space;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_space = 0;n_space < gen_nb_int;n_space++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);
        space = gen_int(n_space, 1);

        ret_val = xmlValidateName((const xmlChar *)value, space);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        des_int(n_space, space, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf(" %d", n_space);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlValidateQName(void) {
    int test_ret = 0;

#if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#ifdef LIBXML_TREE_ENABLED
    int mem_base;
    int ret_val;
    xmlChar * value; /* the value to check */
    int n_value;
    int space; /* allow spaces in front and end of the string */
    int n_space;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_space = 0;n_space < gen_nb_int;n_space++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);
        space = gen_int(n_space, 1);

        ret_val = xmlValidateQName((const xmlChar *)value, space);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        des_int(n_space, space, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateQName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf(" %d", n_space);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}

static int
test_tree(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing tree : 139 of 158 functions ...\n");
    test_ret += test_xmlAddChild();
    test_ret += test_xmlAddChildList();
    test_ret += test_xmlAddNextSibling();
    test_ret += test_xmlAddPrevSibling();
    test_ret += test_xmlAddSibling();
    test_ret += test_xmlAttrSerializeTxtContent();
    test_ret += test_xmlBufferAdd();
    test_ret += test_xmlBufferAddHead();
    test_ret += test_xmlBufferCCat();
    test_ret += test_xmlBufferCat();
    test_ret += test_xmlBufferContent();
    test_ret += test_xmlBufferCreate();
    test_ret += test_xmlBufferCreateSize();
    test_ret += test_xmlBufferCreateStatic();
    test_ret += test_xmlBufferDetach();
    test_ret += test_xmlBufferEmpty();
    test_ret += test_xmlBufferGrow();
    test_ret += test_xmlBufferLength();
    test_ret += test_xmlBufferResize();
    test_ret += test_xmlBufferSetAllocationScheme();
    test_ret += test_xmlBufferShrink();
    test_ret += test_xmlBufferWriteCHAR();
    test_ret += test_xmlBufferWriteChar();
    test_ret += test_xmlBufferWriteQuotedString();
    test_ret += test_xmlBuildQName();
    test_ret += test_xmlChildElementCount();
    test_ret += test_xmlCopyDoc();
    test_ret += test_xmlCopyDtd();
    test_ret += test_xmlCopyNamespace();
    test_ret += test_xmlCopyNamespaceList();
    test_ret += test_xmlCopyNode();
    test_ret += test_xmlCopyNodeList();
    test_ret += test_xmlCopyProp();
    test_ret += test_xmlCopyPropList();
    test_ret += test_xmlCreateIntSubset();
    test_ret += test_xmlDOMWrapAdoptNode();
    test_ret += test_xmlDOMWrapCloneNode();
    test_ret += test_xmlDOMWrapNewCtxt();
    test_ret += test_xmlDOMWrapReconcileNamespaces();
    test_ret += test_xmlDOMWrapRemoveNode();
    test_ret += test_xmlDocCopyNode();
    test_ret += test_xmlDocCopyNodeList();
    test_ret += test_xmlDocDump();
    test_ret += test_xmlDocDumpFormatMemory();
    test_ret += test_xmlDocDumpFormatMemoryEnc();
    test_ret += test_xmlDocDumpMemory();
    test_ret += test_xmlDocDumpMemoryEnc();
    test_ret += test_xmlDocFormatDump();
    test_ret += test_xmlDocGetRootElement();
    test_ret += test_xmlDocSetRootElement();
    test_ret += test_xmlElemDump();
    test_ret += test_xmlFirstElementChild();
    test_ret += test_xmlGetBufferAllocationScheme();
    test_ret += test_xmlGetCompressMode();
    test_ret += test_xmlGetDocCompressMode();
    test_ret += test_xmlGetIntSubset();
    test_ret += test_xmlGetLastChild();
    test_ret += test_xmlGetLineNo();
    test_ret += test_xmlGetNoNsProp();
    test_ret += test_xmlGetNodePath();
    test_ret += test_xmlGetNsList();
    test_ret += test_xmlGetNsProp();
    test_ret += test_xmlGetProp();
    test_ret += test_xmlHasNsProp();
    test_ret += test_xmlHasProp();
    test_ret += test_xmlIsBlankNode();
    test_ret += test_xmlIsXHTML();
    test_ret += test_xmlLastElementChild();
    test_ret += test_xmlNewCDataBlock();
    test_ret += test_xmlNewCharRef();
    test_ret += test_xmlNewChild();
    test_ret += test_xmlNewComment();
    test_ret += test_xmlNewDoc();
    test_ret += test_xmlNewDocComment();
    test_ret += test_xmlNewDocFragment();
    test_ret += test_xmlNewDocNode();
    test_ret += test_xmlNewDocNodeEatName();
    test_ret += test_xmlNewDocPI();
    test_ret += test_xmlNewDocProp();
    test_ret += test_xmlNewDocRawNode();
    test_ret += test_xmlNewDocText();
    test_ret += test_xmlNewDocTextLen();
    test_ret += test_xmlNewDtd();
    test_ret += test_xmlNewNode();
    test_ret += test_xmlNewNodeEatName();
    test_ret += test_xmlNewNs();
    test_ret += test_xmlNewNsProp();
    test_ret += test_xmlNewNsPropEatName();
    test_ret += test_xmlNewPI();
    test_ret += test_xmlNewProp();
    test_ret += test_xmlNewReference();
    test_ret += test_xmlNewText();
    test_ret += test_xmlNewTextChild();
    test_ret += test_xmlNewTextLen();
    test_ret += test_xmlNextElementSibling();
    test_ret += test_xmlNodeAddContent();
    test_ret += test_xmlNodeAddContentLen();
    test_ret += test_xmlNodeBufGetContent();
    test_ret += test_xmlNodeDump();
    test_ret += test_xmlNodeDumpOutput();
    test_ret += test_xmlNodeGetBase();
    test_ret += test_xmlNodeGetContent();
    test_ret += test_xmlNodeGetLang();
    test_ret += test_xmlNodeGetSpacePreserve();
    test_ret += test_xmlNodeIsText();
    test_ret += test_xmlNodeListGetRawString();
    test_ret += test_xmlNodeListGetString();
    test_ret += test_xmlNodeSetBase();
    test_ret += test_xmlNodeSetContent();
    test_ret += test_xmlNodeSetContentLen();
    test_ret += test_xmlNodeSetLang();
    test_ret += test_xmlNodeSetName();
    test_ret += test_xmlNodeSetSpacePreserve();
    test_ret += test_xmlPreviousElementSibling();
    test_ret += test_xmlReconciliateNs();
    test_ret += test_xmlRemoveProp();
    test_ret += test_xmlReplaceNode();
    test_ret += test_xmlSaveFile();
    test_ret += test_xmlSaveFileEnc();
    test_ret += test_xmlSaveFileTo();
    test_ret += test_xmlSaveFormatFile();
    test_ret += test_xmlSaveFormatFileEnc();
    test_ret += test_xmlSaveFormatFileTo();
    test_ret += test_xmlSearchNs();
    test_ret += test_xmlSearchNsByHref();
    test_ret += test_xmlSetBufferAllocationScheme();
    test_ret += test_xmlSetCompressMode();
    test_ret += test_xmlSetDocCompressMode();
    test_ret += test_xmlSetNs();
    test_ret += test_xmlSetNsProp();
    test_ret += test_xmlSetProp();
    test_ret += test_xmlSplitQName2();
    test_ret += test_xmlSplitQName3();
    test_ret += test_xmlStringGetNodeList();
    test_ret += test_xmlStringLenGetNodeList();
    test_ret += test_xmlTextConcat();
    test_ret += test_xmlTextMerge();
    test_ret += test_xmlUnsetNsProp();
    test_ret += test_xmlUnsetProp();
    test_ret += test_xmlValidateNCName();
    test_ret += test_xmlValidateNMToken();
    test_ret += test_xmlValidateName();
    test_ret += test_xmlValidateQName();

    if (test_ret != 0)
	printf("Module tree: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlBuildRelativeURI(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * URI; /* the URI reference under consideration */
    int n_URI;
    xmlChar * base; /* the base value */
    int n_base;

    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
    for (n_base = 0;n_base < gen_nb_const_xmlChar_ptr;n_base++) {
        mem_base = xmlMemBlocks();
        URI = gen_const_xmlChar_ptr(n_URI, 0);
        base = gen_const_xmlChar_ptr(n_base, 1);

        ret_val = xmlBuildRelativeURI((const xmlChar *)URI, (const xmlChar *)base);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 0);
        des_const_xmlChar_ptr(n_base, (const xmlChar *)base, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBuildRelativeURI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URI);
            printf(" %d", n_base);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlBuildURI(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * URI; /* the URI instance found in the document */
    int n_URI;
    xmlChar * base; /* the base value */
    int n_base;

    for (n_URI = 0;n_URI < gen_nb_const_xmlChar_ptr;n_URI++) {
    for (n_base = 0;n_base < gen_nb_const_xmlChar_ptr;n_base++) {
        mem_base = xmlMemBlocks();
        URI = gen_const_xmlChar_ptr(n_URI, 0);
        base = gen_const_xmlChar_ptr(n_base, 1);

        ret_val = xmlBuildURI((const xmlChar *)URI, (const xmlChar *)base);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_URI, (const xmlChar *)URI, 0);
        des_const_xmlChar_ptr(n_base, (const xmlChar *)base, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlBuildURI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URI);
            printf(" %d", n_base);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCanonicPath(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * path; /* the resource locator in a filesystem notation */
    int n_path;

    for (n_path = 0;n_path < gen_nb_const_xmlChar_ptr;n_path++) {
        mem_base = xmlMemBlocks();
        path = gen_const_xmlChar_ptr(n_path, 0);

        ret_val = xmlCanonicPath((const xmlChar *)path);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_path, (const xmlChar *)path, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCanonicPath",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_path);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCreateURI(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlNormalizeURIPath(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    char * path; /* pointer to the path string */
    int n_path;

    for (n_path = 0;n_path < gen_nb_char_ptr;n_path++) {
        mem_base = xmlMemBlocks();
        path = gen_char_ptr(n_path, 0);

        ret_val = xmlNormalizeURIPath(path);
        desret_int(ret_val);
        call_tests++;
        des_char_ptr(n_path, path, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNormalizeURIPath",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_path);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParseURI(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlParseURIRaw(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


#define gen_nb_xmlURIPtr 1
static xmlURIPtr gen_xmlURIPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlURIPtr(int no ATTRIBUTE_UNUSED, xmlURIPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlParseURIReference(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlURIPtr uri; /* pointer to an URI structure */
    int n_uri;
    char * str; /* the string to analyze */
    int n_str;

    for (n_uri = 0;n_uri < gen_nb_xmlURIPtr;n_uri++) {
    for (n_str = 0;n_str < gen_nb_const_char_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        uri = gen_xmlURIPtr(n_uri, 0);
        str = gen_const_char_ptr(n_str, 1);

        ret_val = xmlParseURIReference(uri, (const char *)str);
        desret_int(ret_val);
        call_tests++;
        des_xmlURIPtr(n_uri, uri, 0);
        des_const_char_ptr(n_str, (const char *)str, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParseURIReference",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_uri);
            printf(" %d", n_str);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlPathToURI(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * path; /* the resource locator in a filesystem notation */
    int n_path;

    for (n_path = 0;n_path < gen_nb_const_xmlChar_ptr;n_path++) {
        mem_base = xmlMemBlocks();
        path = gen_const_xmlChar_ptr(n_path, 0);

        ret_val = xmlPathToURI((const xmlChar *)path);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_path, (const xmlChar *)path, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPathToURI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_path);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlPrintURI(void) {
    int test_ret = 0;

    int mem_base;
    FILE * stream; /* a FILE* for the output */
    int n_stream;
    xmlURIPtr uri; /* pointer to an xmlURI */
    int n_uri;

    for (n_stream = 0;n_stream < gen_nb_FILE_ptr;n_stream++) {
    for (n_uri = 0;n_uri < gen_nb_xmlURIPtr;n_uri++) {
        mem_base = xmlMemBlocks();
        stream = gen_FILE_ptr(n_stream, 0);
        uri = gen_xmlURIPtr(n_uri, 1);

        xmlPrintURI(stream, uri);
        call_tests++;
        des_FILE_ptr(n_stream, stream, 0);
        des_xmlURIPtr(n_uri, uri, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPrintURI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_stream);
            printf(" %d", n_uri);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSaveUri(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlURIPtr uri; /* pointer to an xmlURI */
    int n_uri;

    for (n_uri = 0;n_uri < gen_nb_xmlURIPtr;n_uri++) {
        mem_base = xmlMemBlocks();
        uri = gen_xmlURIPtr(n_uri, 0);

        ret_val = xmlSaveUri(uri);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlURIPtr(n_uri, uri, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveUri",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_uri);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlURIEscape(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * str; /* the string of the URI to escape */
    int n_str;

    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        str = gen_const_xmlChar_ptr(n_str, 0);

        ret_val = xmlURIEscape((const xmlChar *)str);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlURIEscape",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_str);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlURIEscapeStr(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * str; /* string to escape */
    int n_str;
    xmlChar * list; /* exception list string of chars not to escape */
    int n_list;

    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
    for (n_list = 0;n_list < gen_nb_const_xmlChar_ptr;n_list++) {
        mem_base = xmlMemBlocks();
        str = gen_const_xmlChar_ptr(n_str, 0);
        list = gen_const_xmlChar_ptr(n_list, 1);

        ret_val = xmlURIEscapeStr((const xmlChar *)str, (const xmlChar *)list);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 0);
        des_const_xmlChar_ptr(n_list, (const xmlChar *)list, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlURIEscapeStr",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_str);
            printf(" %d", n_list);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlURIUnescapeString(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

static int
test_uri(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing uri : 10 of 15 functions ...\n");
    test_ret += test_xmlBuildRelativeURI();
    test_ret += test_xmlBuildURI();
    test_ret += test_xmlCanonicPath();
    test_ret += test_xmlCreateURI();
    test_ret += test_xmlNormalizeURIPath();
    test_ret += test_xmlParseURI();
    test_ret += test_xmlParseURIRaw();
    test_ret += test_xmlParseURIReference();
    test_ret += test_xmlPathToURI();
    test_ret += test_xmlPrintURI();
    test_ret += test_xmlSaveUri();
    test_ret += test_xmlURIEscape();
    test_ret += test_xmlURIEscapeStr();
    test_ret += test_xmlURIUnescapeString();

    if (test_ret != 0)
	printf("Module uri: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlAddAttributeDecl(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttributePtr ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDtdPtr dtd; /* pointer to the DTD */
    int n_dtd;
    xmlChar * elem; /* the element name */
    int n_elem;
    xmlChar * name; /* the attribute name */
    int n_name;
    xmlChar * ns; /* the attribute namespace prefix */
    int n_ns;
    xmlAttributeType type; /* the attribute type */
    int n_type;
    xmlAttributeDefault def; /* the attribute default type */
    int n_def;
    xmlChar * defaultValue; /* the attribute default value */
    int n_defaultValue;
    xmlEnumerationPtr tree; /* if it's an enumeration, the associated list */
    int n_tree;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
    for (n_elem = 0;n_elem < gen_nb_const_xmlChar_ptr;n_elem++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ns = 0;n_ns < gen_nb_const_xmlChar_ptr;n_ns++) {
    for (n_type = 0;n_type < gen_nb_xmlAttributeType;n_type++) {
    for (n_def = 0;n_def < gen_nb_xmlAttributeDefault;n_def++) {
    for (n_defaultValue = 0;n_defaultValue < gen_nb_const_xmlChar_ptr;n_defaultValue++) {
    for (n_tree = 0;n_tree < gen_nb_xmlEnumerationPtr;n_tree++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        dtd = gen_xmlDtdPtr(n_dtd, 1);
        elem = gen_const_xmlChar_ptr(n_elem, 2);
        name = gen_const_xmlChar_ptr(n_name, 3);
        ns = gen_const_xmlChar_ptr(n_ns, 4);
        type = gen_xmlAttributeType(n_type, 5);
        def = gen_xmlAttributeDefault(n_def, 6);
        defaultValue = gen_const_xmlChar_ptr(n_defaultValue, 7);
        tree = gen_xmlEnumerationPtr(n_tree, 8);

        ret_val = xmlAddAttributeDecl(ctxt, dtd, (const xmlChar *)elem, (const xmlChar *)name, (const xmlChar *)ns, type, def, (const xmlChar *)defaultValue, tree);
        desret_xmlAttributePtr(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDtdPtr(n_dtd, dtd, 1);
        des_const_xmlChar_ptr(n_elem, (const xmlChar *)elem, 2);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 3);
        des_const_xmlChar_ptr(n_ns, (const xmlChar *)ns, 4);
        des_xmlAttributeType(n_type, type, 5);
        des_xmlAttributeDefault(n_def, def, 6);
        des_const_xmlChar_ptr(n_defaultValue, (const xmlChar *)defaultValue, 7);
        des_xmlEnumerationPtr(n_tree, tree, 8);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddAttributeDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_dtd);
            printf(" %d", n_elem);
            printf(" %d", n_name);
            printf(" %d", n_ns);
            printf(" %d", n_type);
            printf(" %d", n_def);
            printf(" %d", n_defaultValue);
            printf(" %d", n_tree);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlAddElementDecl(void) {
    int test_ret = 0;

    int mem_base;
    xmlElementPtr ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDtdPtr dtd; /* pointer to the DTD */
    int n_dtd;
    xmlChar * name; /* the entity name */
    int n_name;
    xmlElementTypeVal type; /* the element type */
    int n_type;
    xmlElementContentPtr content; /* the element content tree or NULL */
    int n_content;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_type = 0;n_type < gen_nb_xmlElementTypeVal;n_type++) {
    for (n_content = 0;n_content < gen_nb_xmlElementContentPtr;n_content++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        dtd = gen_xmlDtdPtr(n_dtd, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        type = gen_xmlElementTypeVal(n_type, 3);
        content = gen_xmlElementContentPtr(n_content, 4);

        ret_val = xmlAddElementDecl(ctxt, dtd, (const xmlChar *)name, type, content);
        desret_xmlElementPtr(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDtdPtr(n_dtd, dtd, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_xmlElementTypeVal(n_type, type, 3);
        des_xmlElementContentPtr(n_content, content, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAddElementDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_dtd);
            printf(" %d", n_name);
            printf(" %d", n_type);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlAddID(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAddNotationDecl(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAddRef(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


#define gen_nb_xmlAttributeTablePtr 1
static xmlAttributeTablePtr gen_xmlAttributeTablePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlAttributeTablePtr(int no ATTRIBUTE_UNUSED, xmlAttributeTablePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlCopyAttributeTable(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlCopyDocElementContent(void) {
    int test_ret = 0;

    int mem_base;
    xmlElementContentPtr ret_val;
    xmlDocPtr doc; /* the document owning the element declaration */
    int n_doc;
    xmlElementContentPtr cur; /* An element content pointer. */
    int n_cur;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_cur = 0;n_cur < gen_nb_xmlElementContentPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        cur = gen_xmlElementContentPtr(n_cur, 1);

        ret_val = xmlCopyDocElementContent(doc, cur);
        desret_xmlElementContentPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlElementContentPtr(n_cur, cur, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyDocElementContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCopyElementContent(void) {
    int test_ret = 0;

    int mem_base;
    xmlElementContentPtr ret_val;
    xmlElementContentPtr cur; /* An element content pointer. */
    int n_cur;

    for (n_cur = 0;n_cur < gen_nb_xmlElementContentPtr;n_cur++) {
        mem_base = xmlMemBlocks();
        cur = gen_xmlElementContentPtr(n_cur, 0);

        ret_val = xmlCopyElementContent(cur);
        desret_xmlElementContentPtr(ret_val);
        call_tests++;
        des_xmlElementContentPtr(n_cur, cur, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyElementContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlElementTablePtr 1
static xmlElementTablePtr gen_xmlElementTablePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlElementTablePtr(int no ATTRIBUTE_UNUSED, xmlElementTablePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlCopyElementTable(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlCopyEnumeration(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


#define gen_nb_xmlNotationTablePtr 1
static xmlNotationTablePtr gen_xmlNotationTablePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlNotationTablePtr(int no ATTRIBUTE_UNUSED, xmlNotationTablePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlCopyNotationTable(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlCreateEnumeration(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


#define gen_nb_xmlAttributePtr 1
static xmlAttributePtr gen_xmlAttributePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlAttributePtr(int no ATTRIBUTE_UNUSED, xmlAttributePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlDumpAttributeDecl(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlAttributePtr attr; /* An attribute declaration */
    int n_attr;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttributePtr;n_attr++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        attr = gen_xmlAttributePtr(n_attr, 1);

        xmlDumpAttributeDecl(buf, attr);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlAttributePtr(n_attr, attr, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDumpAttributeDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_attr);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDumpAttributeTable(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlAttributeTablePtr table; /* An attribute table */
    int n_table;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_table = 0;n_table < gen_nb_xmlAttributeTablePtr;n_table++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        table = gen_xmlAttributeTablePtr(n_table, 1);

        xmlDumpAttributeTable(buf, table);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlAttributeTablePtr(n_table, table, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDumpAttributeTable",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_table);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


#define gen_nb_xmlElementPtr 1
static xmlElementPtr gen_xmlElementPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlElementPtr(int no ATTRIBUTE_UNUSED, xmlElementPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlDumpElementDecl(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlElementPtr elem; /* An element table */
    int n_elem;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_elem = 0;n_elem < gen_nb_xmlElementPtr;n_elem++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        elem = gen_xmlElementPtr(n_elem, 1);

        xmlDumpElementDecl(buf, elem);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlElementPtr(n_elem, elem, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDumpElementDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDumpElementTable(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlElementTablePtr table; /* An element table */
    int n_table;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_table = 0;n_table < gen_nb_xmlElementTablePtr;n_table++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        table = gen_xmlElementTablePtr(n_table, 1);

        xmlDumpElementTable(buf, table);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlElementTablePtr(n_table, table, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDumpElementTable",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_table);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


#define gen_nb_xmlNotationPtr 1
static xmlNotationPtr gen_xmlNotationPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlNotationPtr(int no ATTRIBUTE_UNUSED, xmlNotationPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlDumpNotationDecl(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlNotationPtr nota; /* A notation declaration */
    int n_nota;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_nota = 0;n_nota < gen_nb_xmlNotationPtr;n_nota++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        nota = gen_xmlNotationPtr(n_nota, 1);

        xmlDumpNotationDecl(buf, nota);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlNotationPtr(n_nota, nota, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDumpNotationDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_nota);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlDumpNotationTable(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* the XML buffer output */
    int n_buf;
    xmlNotationTablePtr table; /* A notation table */
    int n_table;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_table = 0;n_table < gen_nb_xmlNotationTablePtr;n_table++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        table = gen_xmlNotationTablePtr(n_table, 1);

        xmlDumpNotationTable(buf, table);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlNotationTablePtr(n_table, table, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlDumpNotationTable",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_table);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlGetDtdAttrDesc(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttributePtr ret_val;
    xmlDtdPtr dtd; /* a pointer to the DtD to search */
    int n_dtd;
    xmlChar * elem; /* the element name */
    int n_elem;
    xmlChar * name; /* the attribute name */
    int n_name;

    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
    for (n_elem = 0;n_elem < gen_nb_const_xmlChar_ptr;n_elem++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        dtd = gen_xmlDtdPtr(n_dtd, 0);
        elem = gen_const_xmlChar_ptr(n_elem, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);

        ret_val = xmlGetDtdAttrDesc(dtd, (const xmlChar *)elem, (const xmlChar *)name);
        desret_xmlAttributePtr(ret_val);
        call_tests++;
        des_xmlDtdPtr(n_dtd, dtd, 0);
        des_const_xmlChar_ptr(n_elem, (const xmlChar *)elem, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetDtdAttrDesc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dtd);
            printf(" %d", n_elem);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetDtdElementDesc(void) {
    int test_ret = 0;

    int mem_base;
    xmlElementPtr ret_val;
    xmlDtdPtr dtd; /* a pointer to the DtD to search */
    int n_dtd;
    xmlChar * name; /* the element name */
    int n_name;

    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        dtd = gen_xmlDtdPtr(n_dtd, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlGetDtdElementDesc(dtd, (const xmlChar *)name);
        desret_xmlElementPtr(ret_val);
        call_tests++;
        des_xmlDtdPtr(n_dtd, dtd, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetDtdElementDesc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dtd);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetDtdNotationDesc(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlGetDtdQAttrDesc(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttributePtr ret_val;
    xmlDtdPtr dtd; /* a pointer to the DtD to search */
    int n_dtd;
    xmlChar * elem; /* the element name */
    int n_elem;
    xmlChar * name; /* the attribute name */
    int n_name;
    xmlChar * prefix; /* the attribute namespace prefix */
    int n_prefix;

    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
    for (n_elem = 0;n_elem < gen_nb_const_xmlChar_ptr;n_elem++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
        mem_base = xmlMemBlocks();
        dtd = gen_xmlDtdPtr(n_dtd, 0);
        elem = gen_const_xmlChar_ptr(n_elem, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        prefix = gen_const_xmlChar_ptr(n_prefix, 3);

        ret_val = xmlGetDtdQAttrDesc(dtd, (const xmlChar *)elem, (const xmlChar *)name, (const xmlChar *)prefix);
        desret_xmlAttributePtr(ret_val);
        call_tests++;
        des_xmlDtdPtr(n_dtd, dtd, 0);
        des_const_xmlChar_ptr(n_elem, (const xmlChar *)elem, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetDtdQAttrDesc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dtd);
            printf(" %d", n_elem);
            printf(" %d", n_name);
            printf(" %d", n_prefix);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetDtdQElementDesc(void) {
    int test_ret = 0;

    int mem_base;
    xmlElementPtr ret_val;
    xmlDtdPtr dtd; /* a pointer to the DtD to search */
    int n_dtd;
    xmlChar * name; /* the element name */
    int n_name;
    xmlChar * prefix; /* the element namespace prefix */
    int n_prefix;

    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
        mem_base = xmlMemBlocks();
        dtd = gen_xmlDtdPtr(n_dtd, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        prefix = gen_const_xmlChar_ptr(n_prefix, 2);

        ret_val = xmlGetDtdQElementDesc(dtd, (const xmlChar *)name, (const xmlChar *)prefix);
        desret_xmlElementPtr(ret_val);
        call_tests++;
        des_xmlDtdPtr(n_dtd, dtd, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetDtdQElementDesc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_dtd);
            printf(" %d", n_name);
            printf(" %d", n_prefix);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetID(void) {
    int test_ret = 0;

    int mem_base;
    xmlAttrPtr ret_val;
    xmlDocPtr doc; /* pointer to the document */
    int n_doc;
    xmlChar * ID; /* the ID value */
    int n_ID;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_ID = 0;n_ID < gen_nb_const_xmlChar_ptr;n_ID++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        ID = gen_const_xmlChar_ptr(n_ID, 1);

        ret_val = xmlGetID(doc, (const xmlChar *)ID);
        desret_xmlAttrPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_ID, (const xmlChar *)ID, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlGetID",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_ID);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetRefs(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlIsID(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr elem; /* the element carrying the attribute */
    int n_elem;
    xmlAttrPtr attr; /* the attribute */
    int n_attr;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttrPtr;n_attr++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        elem = gen_xmlNodePtr(n_elem, 1);
        attr = gen_xmlAttrPtr(n_attr, 2);

        ret_val = xmlIsID(doc, elem, attr);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_elem, elem, 1);
        des_xmlAttrPtr(n_attr, attr, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsID",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf(" %d", n_attr);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsMixedElement(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * name; /* the element name */
    int n_name;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlIsMixedElement(doc, (const xmlChar *)name);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsMixedElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIsRef(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr elem; /* the element carrying the attribute */
    int n_elem;
    xmlAttrPtr attr; /* the attribute */
    int n_attr;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttrPtr;n_attr++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        elem = gen_xmlNodePtr(n_elem, 1);
        attr = gen_xmlAttrPtr(n_attr, 2);

        ret_val = xmlIsRef(doc, elem, attr);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_elem, elem, 1);
        des_xmlAttrPtr(n_attr, attr, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIsRef",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf(" %d", n_attr);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewDocElementContent(void) {
    int test_ret = 0;

    int mem_base;
    xmlElementContentPtr ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * name; /* the subelement name or NULL */
    int n_name;
    xmlElementContentType type; /* the type of element content decl */
    int n_type;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_type = 0;n_type < gen_nb_xmlElementContentType;n_type++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);
        type = gen_xmlElementContentType(n_type, 2);

        ret_val = xmlNewDocElementContent(doc, (const xmlChar *)name, type);
        xmlFreeDocElementContent(doc, ret_val); ret_val = NULL;
        desret_xmlElementContentPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        des_xmlElementContentType(n_type, type, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewDocElementContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_name);
            printf(" %d", n_type);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewElementContent(void) {
    int test_ret = 0;

    int mem_base;
    xmlElementContentPtr ret_val;
    xmlChar * name; /* the subelement name or NULL */
    int n_name;
    xmlElementContentType type; /* the type of element content decl */
    int n_type;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_type = 0;n_type < gen_nb_xmlElementContentType;n_type++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);
        type = gen_xmlElementContentType(n_type, 1);

        ret_val = xmlNewElementContent((const xmlChar *)name, type);
        desret_xmlElementContentPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        des_xmlElementContentType(n_type, type, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewElementContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf(" %d", n_type);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNewValidCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRemoveID(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlAttrPtr attr; /* the attribute */
    int n_attr;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttrPtr;n_attr++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        attr = gen_xmlAttrPtr(n_attr, 1);

        ret_val = xmlRemoveID(doc, attr);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlAttrPtr(n_attr, attr, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRemoveID",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_attr);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlRemoveRef(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlAttrPtr attr; /* the attribute */
    int n_attr;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttrPtr;n_attr++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        attr = gen_xmlAttrPtr(n_attr, 1);

        ret_val = xmlRemoveRef(doc, attr);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlAttrPtr(n_attr, attr, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRemoveRef",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_attr);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSnprintfElementContent(void) {
    int test_ret = 0;

    int mem_base;
    char * buf; /* an output buffer */
    int n_buf;
    int size; /* the buffer size */
    int n_size;
    xmlElementContentPtr content; /* An element table */
    int n_content;
    int englob; /* 1 if one must print the englobing parenthesis, 0 otherwise */
    int n_englob;

    for (n_buf = 0;n_buf < gen_nb_char_ptr;n_buf++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_content = 0;n_content < gen_nb_xmlElementContentPtr;n_content++) {
    for (n_englob = 0;n_englob < gen_nb_int;n_englob++) {
        mem_base = xmlMemBlocks();
        buf = gen_char_ptr(n_buf, 0);
        size = gen_int(n_size, 1);
        content = gen_xmlElementContentPtr(n_content, 2);
        englob = gen_int(n_englob, 3);

        xmlSnprintfElementContent(buf, size, content, englob);
        call_tests++;
        des_char_ptr(n_buf, buf, 0);
        des_int(n_size, size, 1);
        des_xmlElementContentPtr(n_content, content, 2);
        des_int(n_englob, englob, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSnprintfElementContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_size);
            printf(" %d", n_content);
            printf(" %d", n_englob);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlSprintfElementContent(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
#ifdef LIBXML_OUTPUT_ENABLED
    int mem_base;
    char * buf; /* an output buffer */
    int n_buf;
    xmlElementContentPtr content; /* An element table */
    int n_content;
    int englob; /* 1 if one must print the englobing parenthesis, 0 otherwise */
    int n_englob;

    for (n_buf = 0;n_buf < gen_nb_char_ptr;n_buf++) {
    for (n_content = 0;n_content < gen_nb_xmlElementContentPtr;n_content++) {
    for (n_englob = 0;n_englob < gen_nb_int;n_englob++) {
        mem_base = xmlMemBlocks();
        buf = gen_char_ptr(n_buf, 0);
        content = gen_xmlElementContentPtr(n_content, 1);
        englob = gen_int(n_englob, 2);

        xmlSprintfElementContent(buf, content, englob);
        call_tests++;
        des_char_ptr(n_buf, buf, 0);
        des_xmlElementContentPtr(n_content, content, 1);
        des_int(n_englob, englob, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSprintfElementContent",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_content);
            printf(" %d", n_englob);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlValidBuildContentModel(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED) && defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* a validation context */
    int n_ctxt;
    xmlElementPtr elem; /* an element declaration node */
    int n_elem;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_elem = 0;n_elem < gen_nb_xmlElementPtr;n_elem++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        elem = gen_xmlElementPtr(n_elem, 1);

        ret_val = xmlValidBuildContentModel(ctxt, elem);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlElementPtr(n_elem, elem, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidBuildContentModel",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidCtxtNormalizeAttributeValue(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context or NULL */
    int n_ctxt;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr elem; /* the parent */
    int n_elem;
    xmlChar * name; /* the attribute name */
    int n_name;
    xmlChar * value; /* the attribute value */
    int n_value;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);
        name = gen_const_xmlChar_ptr(n_name, 3);
        value = gen_const_xmlChar_ptr(n_value, 4);

        ret_val = xmlValidCtxtNormalizeAttributeValue(ctxt, doc, elem, (const xmlChar *)name, (const xmlChar *)value);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 3);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidCtxtNormalizeAttributeValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


#define gen_nb_xmlElementContent_ptr 1
static xmlElementContent * gen_xmlElementContent_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlElementContent_ptr(int no ATTRIBUTE_UNUSED, xmlElementContent * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlValidGetPotentialChildren(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
#ifdef LIBXML_VALID_ENABLED
    int mem_base;
    int ret_val;
    xmlElementContent * ctree; /* an element content tree */
    int n_ctree;
    xmlChar ** names; /* an array to store the list of child names */
    int n_names;
    int * len; /* a pointer to the number of element in the list */
    int n_len;
    int max; /* the size of the array */
    int n_max;

    for (n_ctree = 0;n_ctree < gen_nb_xmlElementContent_ptr;n_ctree++) {
    for (n_names = 0;n_names < gen_nb_const_xmlChar_ptr_ptr;n_names++) {
    for (n_len = 0;n_len < gen_nb_int_ptr;n_len++) {
    for (n_max = 0;n_max < gen_nb_int;n_max++) {
        mem_base = xmlMemBlocks();
        ctree = gen_xmlElementContent_ptr(n_ctree, 0);
        names = gen_const_xmlChar_ptr_ptr(n_names, 1);
        len = gen_int_ptr(n_len, 2);
        max = gen_int(n_max, 3);

        ret_val = xmlValidGetPotentialChildren(ctree, (const xmlChar **)names, len, max);
        desret_int(ret_val);
        call_tests++;
        des_xmlElementContent_ptr(n_ctree, ctree, 0);
        des_const_xmlChar_ptr_ptr(n_names, (const xmlChar **)names, 1);
        des_int_ptr(n_len, len, 2);
        des_int(n_max, max, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidGetPotentialChildren",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctree);
            printf(" %d", n_names);
            printf(" %d", n_len);
            printf(" %d", n_max);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlValidGetValidElements(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
#ifdef LIBXML_VALID_ENABLED
    int mem_base;
    int ret_val;
    xmlNode * prev; /* an element to insert after */
    int n_prev;
    xmlNode * next; /* an element to insert next */
    int n_next;
    xmlChar ** names; /* an array to store the list of child names */
    int n_names;
    int max; /* the size of the array */
    int n_max;

    for (n_prev = 0;n_prev < gen_nb_xmlNodePtr;n_prev++) {
    for (n_next = 0;n_next < gen_nb_xmlNodePtr;n_next++) {
    for (n_names = 0;n_names < gen_nb_const_xmlChar_ptr_ptr;n_names++) {
    for (n_max = 0;n_max < gen_nb_int;n_max++) {
        mem_base = xmlMemBlocks();
        prev = gen_xmlNodePtr(n_prev, 0);
        next = gen_xmlNodePtr(n_next, 1);
        names = gen_const_xmlChar_ptr_ptr(n_names, 2);
        max = gen_int(n_max, 3);

        ret_val = xmlValidGetValidElements(prev, next, (const xmlChar **)names, max);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_prev, prev, 0);
        des_xmlNodePtr(n_next, next, 1);
        des_const_xmlChar_ptr_ptr(n_names, (const xmlChar **)names, 2);
        des_int(n_max, max, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidGetValidElements",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_prev);
            printf(" %d", n_next);
            printf(" %d", n_names);
            printf(" %d", n_max);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlValidNormalizeAttributeValue(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlNodePtr elem; /* the parent */
    int n_elem;
    xmlChar * name; /* the attribute name */
    int n_name;
    xmlChar * value; /* the attribute value */
    int n_value;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        elem = gen_xmlNodePtr(n_elem, 1);
        name = gen_const_xmlChar_ptr(n_name, 2);
        value = gen_const_xmlChar_ptr(n_value, 3);

        ret_val = xmlValidNormalizeAttributeValue(doc, elem, (const xmlChar *)name, (const xmlChar *)value);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_xmlNodePtr(n_elem, elem, 1);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 2);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidNormalizeAttributeValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf(" %d", n_name);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateAttributeDecl(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlAttributePtr attr; /* an attribute definition */
    int n_attr;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttributePtr;n_attr++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        attr = gen_xmlAttributePtr(n_attr, 2);

        ret_val = xmlValidateAttributeDecl(ctxt, doc, attr);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlAttributePtr(n_attr, attr, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateAttributeDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_attr);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateAttributeValue(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlAttributeType type; /* an attribute type */
    int n_type;
    xmlChar * value; /* an attribute value */
    int n_value;

    for (n_type = 0;n_type < gen_nb_xmlAttributeType;n_type++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        type = gen_xmlAttributeType(n_type, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);

        ret_val = xmlValidateAttributeValue(type, (const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_xmlAttributeType(n_type, type, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateAttributeValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_type);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateDocument(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlValidateDocument(ctxt, doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateDocument",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateDocumentFinal(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlValidateDocumentFinal(ctxt, doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateDocumentFinal",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateDtd(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlDtdPtr dtd; /* a dtd instance */
    int n_dtd;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_dtd = 0;n_dtd < gen_nb_xmlDtdPtr;n_dtd++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        dtd = gen_xmlDtdPtr(n_dtd, 2);

        ret_val = xmlValidateDtd(ctxt, doc, dtd);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlDtdPtr(n_dtd, dtd, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateDtd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_dtd);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateDtdFinal(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlValidateDtdFinal(ctxt, doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateDtdFinal",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateElement(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);

        ret_val = xmlValidateElement(ctxt, doc, elem);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateElementDecl(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlElementPtr elem; /* an element definition */
    int n_elem;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlElementPtr;n_elem++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlElementPtr(n_elem, 2);

        ret_val = xmlValidateElementDecl(ctxt, doc, elem);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlElementPtr(n_elem, elem, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateElementDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateNameValue(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlChar * value; /* an Name value */
    int n_value;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);

        ret_val = xmlValidateNameValue((const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateNameValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateNamesValue(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlChar * value; /* an Names value */
    int n_value;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);

        ret_val = xmlValidateNamesValue((const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateNamesValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateNmtokenValue(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlChar * value; /* an Nmtoken value */
    int n_value;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);

        ret_val = xmlValidateNmtokenValue((const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateNmtokenValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateNmtokensValue(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlChar * value; /* an Nmtokens value */
    int n_value;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);

        ret_val = xmlValidateNmtokensValue((const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateNmtokensValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateNotationDecl(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNotationPtr nota; /* a notation definition */
    int n_nota;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_nota = 0;n_nota < gen_nb_xmlNotationPtr;n_nota++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        nota = gen_xmlNotationPtr(n_nota, 2);

        ret_val = xmlValidateNotationDecl(ctxt, doc, nota);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNotationPtr(n_nota, nota, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateNotationDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_nota);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateNotationUse(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* the document */
    int n_doc;
    xmlChar * notationName; /* the notation name to check */
    int n_notationName;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_notationName = 0;n_notationName < gen_nb_const_xmlChar_ptr;n_notationName++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        notationName = gen_const_xmlChar_ptr(n_notationName, 2);

        ret_val = xmlValidateNotationUse(ctxt, doc, (const xmlChar *)notationName);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_const_xmlChar_ptr(n_notationName, (const xmlChar *)notationName, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateNotationUse",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_notationName);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateOneAttribute(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;
    xmlAttrPtr attr; /* an attribute instance */
    int n_attr;
    xmlChar * value; /* the attribute value (without entities processing) */
    int n_value;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_attr = 0;n_attr < gen_nb_xmlAttrPtr;n_attr++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);
        attr = gen_xmlAttrPtr(n_attr, 3);
        value = gen_const_xmlChar_ptr(n_value, 4);

        ret_val = xmlValidateOneAttribute(ctxt, doc, elem, attr, (const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        des_xmlAttrPtr(n_attr, attr, 3);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateOneAttribute",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf(" %d", n_attr);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateOneElement(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);

        ret_val = xmlValidateOneElement(ctxt, doc, elem);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateOneElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateOneNamespace(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;
    xmlChar * prefix; /* the namespace prefix */
    int n_prefix;
    xmlNsPtr ns; /* an namespace declaration instance */
    int n_ns;
    xmlChar * value; /* the attribute value (without entities processing) */
    int n_value;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
    for (n_ns = 0;n_ns < gen_nb_xmlNsPtr;n_ns++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);
        prefix = gen_const_xmlChar_ptr(n_prefix, 3);
        ns = gen_xmlNsPtr(n_ns, 4);
        value = gen_const_xmlChar_ptr(n_value, 5);

        ret_val = xmlValidateOneNamespace(ctxt, doc, elem, (const xmlChar *)prefix, ns, (const xmlChar *)value);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 3);
        des_xmlNsPtr(n_ns, ns, 4);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateOneNamespace",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf(" %d", n_prefix);
            printf(" %d", n_ns);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidatePopElement(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED) && defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;
    xmlChar * qname; /* the qualified name as appearing in the serialization */
    int n_qname;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_qname = 0;n_qname < gen_nb_const_xmlChar_ptr;n_qname++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);
        qname = gen_const_xmlChar_ptr(n_qname, 3);

        ret_val = xmlValidatePopElement(ctxt, doc, elem, (const xmlChar *)qname);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        des_const_xmlChar_ptr(n_qname, (const xmlChar *)qname, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidatePopElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf(" %d", n_qname);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidatePushCData(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED) && defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlChar * data; /* some character data read */
    int n_data;
    int len; /* the lenght of the data */
    int n_len;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_data = 0;n_data < gen_nb_const_xmlChar_ptr;n_data++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        data = gen_const_xmlChar_ptr(n_data, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlValidatePushCData(ctxt, (const xmlChar *)data, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_const_xmlChar_ptr(n_data, (const xmlChar *)data, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidatePushCData",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_data);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidatePushElement(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED) && defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;
    xmlNodePtr elem; /* an element instance */
    int n_elem;
    xmlChar * qname; /* the qualified name as appearing in the serialization */
    int n_qname;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
    for (n_qname = 0;n_qname < gen_nb_const_xmlChar_ptr;n_qname++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);
        elem = gen_xmlNodePtr(n_elem, 2);
        qname = gen_const_xmlChar_ptr(n_qname, 3);

        ret_val = xmlValidatePushElement(ctxt, doc, elem, (const xmlChar *)qname);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        des_xmlNodePtr(n_elem, elem, 2);
        des_const_xmlChar_ptr(n_qname, (const xmlChar *)qname, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidatePushElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf(" %d", n_elem);
            printf(" %d", n_qname);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlValidateRoot(void) {
    int test_ret = 0;

#if defined(LIBXML_VALID_ENABLED)
    int mem_base;
    int ret_val;
    xmlValidCtxtPtr ctxt; /* the validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a document instance */
    int n_doc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlValidateRoot(ctxt, doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlValidateRoot",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_valid(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing valid : 50 of 70 functions ...\n");
    test_ret += test_xmlAddAttributeDecl();
    test_ret += test_xmlAddElementDecl();
    test_ret += test_xmlAddID();
    test_ret += test_xmlAddNotationDecl();
    test_ret += test_xmlAddRef();
    test_ret += test_xmlCopyAttributeTable();
    test_ret += test_xmlCopyDocElementContent();
    test_ret += test_xmlCopyElementContent();
    test_ret += test_xmlCopyElementTable();
    test_ret += test_xmlCopyEnumeration();
    test_ret += test_xmlCopyNotationTable();
    test_ret += test_xmlCreateEnumeration();
    test_ret += test_xmlDumpAttributeDecl();
    test_ret += test_xmlDumpAttributeTable();
    test_ret += test_xmlDumpElementDecl();
    test_ret += test_xmlDumpElementTable();
    test_ret += test_xmlDumpNotationDecl();
    test_ret += test_xmlDumpNotationTable();
    test_ret += test_xmlGetDtdAttrDesc();
    test_ret += test_xmlGetDtdElementDesc();
    test_ret += test_xmlGetDtdNotationDesc();
    test_ret += test_xmlGetDtdQAttrDesc();
    test_ret += test_xmlGetDtdQElementDesc();
    test_ret += test_xmlGetID();
    test_ret += test_xmlGetRefs();
    test_ret += test_xmlIsID();
    test_ret += test_xmlIsMixedElement();
    test_ret += test_xmlIsRef();
    test_ret += test_xmlNewDocElementContent();
    test_ret += test_xmlNewElementContent();
    test_ret += test_xmlNewValidCtxt();
    test_ret += test_xmlRemoveID();
    test_ret += test_xmlRemoveRef();
    test_ret += test_xmlSnprintfElementContent();
    test_ret += test_xmlSprintfElementContent();
    test_ret += test_xmlValidBuildContentModel();
    test_ret += test_xmlValidCtxtNormalizeAttributeValue();
    test_ret += test_xmlValidGetPotentialChildren();
    test_ret += test_xmlValidGetValidElements();
    test_ret += test_xmlValidNormalizeAttributeValue();
    test_ret += test_xmlValidateAttributeDecl();
    test_ret += test_xmlValidateAttributeValue();
    test_ret += test_xmlValidateDocument();
    test_ret += test_xmlValidateDocumentFinal();
    test_ret += test_xmlValidateDtd();
    test_ret += test_xmlValidateDtdFinal();
    test_ret += test_xmlValidateElement();
    test_ret += test_xmlValidateElementDecl();
    test_ret += test_xmlValidateNameValue();
    test_ret += test_xmlValidateNamesValue();
    test_ret += test_xmlValidateNmtokenValue();
    test_ret += test_xmlValidateNmtokensValue();
    test_ret += test_xmlValidateNotationDecl();
    test_ret += test_xmlValidateNotationUse();
    test_ret += test_xmlValidateOneAttribute();
    test_ret += test_xmlValidateOneElement();
    test_ret += test_xmlValidateOneNamespace();
    test_ret += test_xmlValidatePopElement();
    test_ret += test_xmlValidatePushCData();
    test_ret += test_xmlValidatePushElement();
    test_ret += test_xmlValidateRoot();

    if (test_ret != 0)
	printf("Module valid: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlXIncludeNewContext(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlXIncludeProcess(void) {
    int test_ret = 0;

#if defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* an XML document */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);

        ret_val = xmlXIncludeProcess(doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlXIncludeProcess",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlXIncludeProcessFlags(void) {
    int test_ret = 0;

#if defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* an XML document */
    int n_doc;
    int flags; /* a set of xmlParserOption used for parsing XML includes */
    int n_flags;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_flags = 0;n_flags < gen_nb_int;n_flags++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        flags = gen_int(n_flags, 1);

        ret_val = xmlXIncludeProcessFlags(doc, flags);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_int(n_flags, flags, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlXIncludeProcessFlags",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_flags);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlXIncludeProcessFlagsData(void) {
    int test_ret = 0;

#if defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    int ret_val;
    xmlDocPtr doc; /* an XML document */
    int n_doc;
    int flags; /* a set of xmlParserOption used for parsing XML includes */
    int n_flags;
    void * data; /* application data that will be passed to the parser context in the _private field of the parser context(s) */
    int n_data;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
    for (n_flags = 0;n_flags < gen_nb_int;n_flags++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);
        flags = gen_int(n_flags, 1);
        data = gen_userdata(n_data, 2);

        ret_val = xmlXIncludeProcessFlagsData(doc, flags, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        des_int(n_flags, flags, 1);
        des_userdata(n_data, data, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlXIncludeProcessFlagsData",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf(" %d", n_flags);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_XINCLUDE_ENABLED

#define gen_nb_xmlXIncludeCtxtPtr 1
static xmlXIncludeCtxtPtr gen_xmlXIncludeCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlXIncludeCtxtPtr(int no ATTRIBUTE_UNUSED, xmlXIncludeCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlXIncludeProcessNode(void) {
    int test_ret = 0;

#if defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    int ret_val;
    xmlXIncludeCtxtPtr ctxt; /* an existing XInclude context */
    int n_ctxt;
    xmlNodePtr node; /* a node in an XML document */
    int n_node;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlXIncludeCtxtPtr;n_ctxt++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlXIncludeCtxtPtr(n_ctxt, 0);
        node = gen_xmlNodePtr(n_node, 1);

        ret_val = xmlXIncludeProcessNode(ctxt, node);
        desret_int(ret_val);
        call_tests++;
        des_xmlXIncludeCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlNodePtr(n_node, node, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlXIncludeProcessNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlXIncludeProcessTree(void) {
    int test_ret = 0;

#if defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    int ret_val;
    xmlNodePtr tree; /* a node in an XML document */
    int n_tree;

    for (n_tree = 0;n_tree < gen_nb_xmlNodePtr;n_tree++) {
        mem_base = xmlMemBlocks();
        tree = gen_xmlNodePtr(n_tree, 0);

        ret_val = xmlXIncludeProcessTree(tree);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_tree, tree, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlXIncludeProcessTree",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_tree);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlXIncludeProcessTreeFlags(void) {
    int test_ret = 0;

#if defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    int ret_val;
    xmlNodePtr tree; /* a node in an XML document */
    int n_tree;
    int flags; /* a set of xmlParserOption used for parsing XML includes */
    int n_flags;

    for (n_tree = 0;n_tree < gen_nb_xmlNodePtr;n_tree++) {
    for (n_flags = 0;n_flags < gen_nb_int;n_flags++) {
        mem_base = xmlMemBlocks();
        tree = gen_xmlNodePtr(n_tree, 0);
        flags = gen_int(n_flags, 1);

        ret_val = xmlXIncludeProcessTreeFlags(tree, flags);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_tree, tree, 0);
        des_int(n_flags, flags, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlXIncludeProcessTreeFlags",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_tree);
            printf(" %d", n_flags);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlXIncludeProcessTreeFlagsData(void) {
    int test_ret = 0;

#if defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    int ret_val;
    xmlNodePtr tree; /* an XML node */
    int n_tree;
    int flags; /* a set of xmlParserOption used for parsing XML includes */
    int n_flags;
    void * data; /* application data that will be passed to the parser context in the _private field of the parser context(s) */
    int n_data;

    for (n_tree = 0;n_tree < gen_nb_xmlNodePtr;n_tree++) {
    for (n_flags = 0;n_flags < gen_nb_int;n_flags++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        tree = gen_xmlNodePtr(n_tree, 0);
        flags = gen_int(n_flags, 1);
        data = gen_userdata(n_data, 2);

        ret_val = xmlXIncludeProcessTreeFlagsData(tree, flags, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlNodePtr(n_tree, tree, 0);
        des_int(n_flags, flags, 1);
        des_userdata(n_data, data, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlXIncludeProcessTreeFlagsData",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_tree);
            printf(" %d", n_flags);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlXIncludeSetFlags(void) {
    int test_ret = 0;

#if defined(LIBXML_XINCLUDE_ENABLED)
    int mem_base;
    int ret_val;
    xmlXIncludeCtxtPtr ctxt; /* an XInclude processing context */
    int n_ctxt;
    int flags; /* a set of xmlParserOption used for parsing XML includes */
    int n_flags;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlXIncludeCtxtPtr;n_ctxt++) {
    for (n_flags = 0;n_flags < gen_nb_int;n_flags++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlXIncludeCtxtPtr(n_ctxt, 0);
        flags = gen_int(n_flags, 1);

        ret_val = xmlXIncludeSetFlags(ctxt, flags);
        desret_int(ret_val);
        call_tests++;
        des_xmlXIncludeCtxtPtr(n_ctxt, ctxt, 0);
        des_int(n_flags, flags, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlXIncludeSetFlags",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_flags);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_xinclude(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xinclude : 8 of 10 functions ...\n");
    test_ret += test_xmlXIncludeNewContext();
    test_ret += test_xmlXIncludeProcess();
    test_ret += test_xmlXIncludeProcessFlags();
    test_ret += test_xmlXIncludeProcessFlagsData();
    test_ret += test_xmlXIncludeProcessNode();
    test_ret += test_xmlXIncludeProcessTree();
    test_ret += test_xmlXIncludeProcessTreeFlags();
    test_ret += test_xmlXIncludeProcessTreeFlagsData();
    test_ret += test_xmlXIncludeSetFlags();

    if (test_ret != 0)
	printf("Module xinclude: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlAllocOutputBuffer(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr ret_val;
    xmlCharEncodingHandlerPtr encoder; /* the encoding converter or NULL */
    int n_encoder;

    for (n_encoder = 0;n_encoder < gen_nb_xmlCharEncodingHandlerPtr;n_encoder++) {
        mem_base = xmlMemBlocks();
        encoder = gen_xmlCharEncodingHandlerPtr(n_encoder, 0);

        ret_val = xmlAllocOutputBuffer(encoder);
        desret_xmlOutputBufferPtr(ret_val);
        call_tests++;
        des_xmlCharEncodingHandlerPtr(n_encoder, encoder, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAllocOutputBuffer",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_encoder);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlAllocParserInputBuffer(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputBufferPtr ret_val;
    xmlCharEncoding enc; /* the charset encoding if known */
    int n_enc;

    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        enc = gen_xmlCharEncoding(n_enc, 0);

        ret_val = xmlAllocParserInputBuffer(enc);
        desret_xmlParserInputBufferPtr(ret_val);
        call_tests++;
        des_xmlCharEncoding(n_enc, enc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAllocParserInputBuffer",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCheckFilename(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    char * path; /* the path to check */
    int n_path;

    for (n_path = 0;n_path < gen_nb_const_char_ptr;n_path++) {
        mem_base = xmlMemBlocks();
        path = gen_const_char_ptr(n_path, 0);

        ret_val = xmlCheckFilename((const char *)path);
        desret_int(ret_val);
        call_tests++;
        des_const_char_ptr(n_path, (const char *)path, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCheckFilename",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_path);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCheckHTTPInput(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    xmlParserCtxtPtr ctxt; /* an XML parser context */
    int n_ctxt;
    xmlParserInputPtr ret; /* an XML parser input */
    int n_ret;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
    for (n_ret = 0;n_ret < gen_nb_xmlParserInputPtr;n_ret++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 0);
        ret = gen_xmlParserInputPtr(n_ret, 1);

        ret_val = xmlCheckHTTPInput(ctxt, ret);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlParserInputPtr(n_ret, ret, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCheckHTTPInput",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_ret);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCleanupInputCallbacks(void) {
    int test_ret = 0;

    int mem_base;

        mem_base = xmlMemBlocks();

        xmlCleanupInputCallbacks();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCleanupInputCallbacks",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCleanupOutputCallbacks(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlCleanupOutputCallbacks();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCleanupOutputCallbacks",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlFileClose(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    void * context; /* the I/O context */
    int n_context;

    for (n_context = 0;n_context < gen_nb_void_ptr;n_context++) {
        mem_base = xmlMemBlocks();
        context = gen_void_ptr(n_context, 0);

        ret_val = xmlFileClose(context);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_context, context, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlFileClose",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_context);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlFileMatch(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    const char * filename; /* the URI for matching */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlFileMatch(filename);
        desret_int(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlFileMatch",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlFileOpen(void) {
    int test_ret = 0;

    int mem_base;
    void * ret_val;
    const char * filename; /* the URI for matching */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlFileOpen(filename);
        desret_void_ptr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlFileOpen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlFileRead(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    void * context; /* the I/O context */
    int n_context;
    char * buffer; /* where to drop data */
    int n_buffer;
    int len; /* number of bytes to write */
    int n_len;

    for (n_context = 0;n_context < gen_nb_void_ptr;n_context++) {
    for (n_buffer = 0;n_buffer < gen_nb_char_ptr;n_buffer++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        context = gen_void_ptr(n_context, 0);
        buffer = gen_char_ptr(n_buffer, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlFileRead(context, buffer, len);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_context, context, 0);
        des_char_ptr(n_buffer, buffer, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlFileRead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_context);
            printf(" %d", n_buffer);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlIOFTPClose(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * context; /* the I/O context */
    int n_context;

    for (n_context = 0;n_context < gen_nb_void_ptr;n_context++) {
        mem_base = xmlMemBlocks();
        context = gen_void_ptr(n_context, 0);

        ret_val = xmlIOFTPClose(context);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_context, context, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIOFTPClose",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_context);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlIOFTPMatch(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the URI for matching */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlIOFTPMatch(filename);
        desret_int(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIOFTPMatch",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlIOFTPOpen(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    void * ret_val;
    const char * filename; /* the URI for matching */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlIOFTPOpen(filename);
        desret_void_ptr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIOFTPOpen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlIOFTPRead(void) {
    int test_ret = 0;

#if defined(LIBXML_FTP_ENABLED)
    int mem_base;
    int ret_val;
    void * context; /* the I/O context */
    int n_context;
    char * buffer; /* where to drop data */
    int n_buffer;
    int len; /* number of bytes to write */
    int n_len;

    for (n_context = 0;n_context < gen_nb_void_ptr;n_context++) {
    for (n_buffer = 0;n_buffer < gen_nb_char_ptr;n_buffer++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        context = gen_void_ptr(n_context, 0);
        buffer = gen_char_ptr(n_buffer, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlIOFTPRead(context, buffer, len);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_context, context, 0);
        des_char_ptr(n_buffer, buffer, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIOFTPRead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_context);
            printf(" %d", n_buffer);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlIOHTTPClose(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    int ret_val;
    void * context; /* the I/O context */
    int n_context;

    for (n_context = 0;n_context < gen_nb_void_ptr;n_context++) {
        mem_base = xmlMemBlocks();
        context = gen_void_ptr(n_context, 0);

        ret_val = xmlIOHTTPClose(context);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_context, context, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIOHTTPClose",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_context);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlIOHTTPMatch(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    int ret_val;
    const char * filename; /* the URI for matching */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlIOHTTPMatch(filename);
        desret_int(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIOHTTPMatch",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlIOHTTPOpen(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    void * ret_val;
    const char * filename; /* the URI for matching */
    int n_filename;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);

        ret_val = xmlIOHTTPOpen(filename);
        desret_xmlNanoHTTPCtxtPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIOHTTPOpen",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlIOHTTPRead(void) {
    int test_ret = 0;

#if defined(LIBXML_HTTP_ENABLED)
    int mem_base;
    int ret_val;
    void * context; /* the I/O context */
    int n_context;
    char * buffer; /* where to drop data */
    int n_buffer;
    int len; /* number of bytes to write */
    int n_len;

    for (n_context = 0;n_context < gen_nb_void_ptr;n_context++) {
    for (n_buffer = 0;n_buffer < gen_nb_char_ptr;n_buffer++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        context = gen_void_ptr(n_context, 0);
        buffer = gen_char_ptr(n_buffer, 1);
        len = gen_int(n_len, 2);

        ret_val = xmlIOHTTPRead(context, buffer, len);
        desret_int(ret_val);
        call_tests++;
        des_void_ptr(n_context, context, 0);
        des_char_ptr(n_buffer, buffer, 1);
        des_int(n_len, len, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlIOHTTPRead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_context);
            printf(" %d", n_buffer);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNoNetExternalEntityLoader(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr ret_val;
    const char * URL; /* the URL for the entity to load */
    int n_URL;
    char * ID; /* the System ID for the entity to load */
    int n_ID;
    xmlParserCtxtPtr ctxt; /* the context in which the entity is called or NULL */
    int n_ctxt;

    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_ID = 0;n_ID < gen_nb_const_char_ptr;n_ID++) {
    for (n_ctxt = 0;n_ctxt < gen_nb_xmlParserCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        URL = gen_filepath(n_URL, 0);
        ID = gen_const_char_ptr(n_ID, 1);
        ctxt = gen_xmlParserCtxtPtr(n_ctxt, 2);

        ret_val = xmlNoNetExternalEntityLoader(URL, (const char *)ID, ctxt);
        desret_xmlParserInputPtr(ret_val);
        call_tests++;
        des_filepath(n_URL, URL, 0);
        des_const_char_ptr(n_ID, (const char *)ID, 1);
        des_xmlParserCtxtPtr(n_ctxt, ctxt, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNoNetExternalEntityLoader",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf(" %d", n_ID);
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlNormalizeWindowsPath(void) {
    int test_ret = 0;

    int mem_base;
    xmlChar * ret_val;
    xmlChar * path; /* the input file path */
    int n_path;

    for (n_path = 0;n_path < gen_nb_const_xmlChar_ptr;n_path++) {
        mem_base = xmlMemBlocks();
        path = gen_const_xmlChar_ptr(n_path, 0);

        ret_val = xmlNormalizeWindowsPath((const xmlChar *)path);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_path, (const xmlChar *)path, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNormalizeWindowsPath",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_path);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlOutputBufferCreateBuffer(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr ret_val;
    xmlBufferPtr buffer; /* a xmlBufferPtr */
    int n_buffer;
    xmlCharEncodingHandlerPtr encoder; /* the encoding converter or NULL */
    int n_encoder;

    for (n_buffer = 0;n_buffer < gen_nb_xmlBufferPtr;n_buffer++) {
    for (n_encoder = 0;n_encoder < gen_nb_xmlCharEncodingHandlerPtr;n_encoder++) {
        mem_base = xmlMemBlocks();
        buffer = gen_xmlBufferPtr(n_buffer, 0);
        encoder = gen_xmlCharEncodingHandlerPtr(n_encoder, 1);

        ret_val = xmlOutputBufferCreateBuffer(buffer, encoder);
        desret_xmlOutputBufferPtr(ret_val);
        call_tests++;
        des_xmlBufferPtr(n_buffer, buffer, 0);
        des_xmlCharEncodingHandlerPtr(n_encoder, encoder, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlOutputBufferCreateBuffer",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_encoder);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlOutputBufferCreateFd(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr ret_val;
    int fd; /* a file descriptor number */
    int n_fd;
    xmlCharEncodingHandlerPtr encoder; /* the encoding converter or NULL */
    int n_encoder;

    for (n_fd = 0;n_fd < gen_nb_int;n_fd++) {
    for (n_encoder = 0;n_encoder < gen_nb_xmlCharEncodingHandlerPtr;n_encoder++) {
        mem_base = xmlMemBlocks();
        fd = gen_int(n_fd, 0);
        encoder = gen_xmlCharEncodingHandlerPtr(n_encoder, 1);

        ret_val = xmlOutputBufferCreateFd(fd, encoder);
        desret_xmlOutputBufferPtr(ret_val);
        call_tests++;
        des_int(n_fd, fd, 0);
        des_xmlCharEncodingHandlerPtr(n_encoder, encoder, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlOutputBufferCreateFd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_fd);
            printf(" %d", n_encoder);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlOutputBufferCreateFile(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr ret_val;
    FILE * file; /* a FILE* */
    int n_file;
    xmlCharEncodingHandlerPtr encoder; /* the encoding converter or NULL */
    int n_encoder;

    for (n_file = 0;n_file < gen_nb_FILE_ptr;n_file++) {
    for (n_encoder = 0;n_encoder < gen_nb_xmlCharEncodingHandlerPtr;n_encoder++) {
        mem_base = xmlMemBlocks();
        file = gen_FILE_ptr(n_file, 0);
        encoder = gen_xmlCharEncodingHandlerPtr(n_encoder, 1);

        ret_val = xmlOutputBufferCreateFile(file, encoder);
        desret_xmlOutputBufferPtr(ret_val);
        call_tests++;
        des_FILE_ptr(n_file, file, 0);
        des_xmlCharEncodingHandlerPtr(n_encoder, encoder, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlOutputBufferCreateFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_file);
            printf(" %d", n_encoder);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlOutputBufferCreateFilename(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    xmlOutputBufferPtr ret_val;
    const char * URI; /* a C string containing the URI or filename */
    int n_URI;
    xmlCharEncodingHandlerPtr encoder; /* the encoding converter or NULL */
    int n_encoder;
    int compression; /* the compression ration (0 none, 9 max). */
    int n_compression;

    for (n_URI = 0;n_URI < gen_nb_fileoutput;n_URI++) {
    for (n_encoder = 0;n_encoder < gen_nb_xmlCharEncodingHandlerPtr;n_encoder++) {
    for (n_compression = 0;n_compression < gen_nb_int;n_compression++) {
        mem_base = xmlMemBlocks();
        URI = gen_fileoutput(n_URI, 0);
        encoder = gen_xmlCharEncodingHandlerPtr(n_encoder, 1);
        compression = gen_int(n_compression, 2);

        ret_val = xmlOutputBufferCreateFilename(URI, encoder, compression);
        desret_xmlOutputBufferPtr(ret_val);
        call_tests++;
        des_fileoutput(n_URI, URI, 0);
        des_xmlCharEncodingHandlerPtr(n_encoder, encoder, 1);
        des_int(n_compression, compression, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlOutputBufferCreateFilename",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URI);
            printf(" %d", n_encoder);
            printf(" %d", n_compression);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlOutputBufferFlush(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlOutputBufferPtr out; /* a buffered output */
    int n_out;

    for (n_out = 0;n_out < gen_nb_xmlOutputBufferPtr;n_out++) {
        mem_base = xmlMemBlocks();
        out = gen_xmlOutputBufferPtr(n_out, 0);

        ret_val = xmlOutputBufferFlush(out);
        desret_int(ret_val);
        call_tests++;
        des_xmlOutputBufferPtr(n_out, out, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlOutputBufferFlush",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlOutputBufferWrite(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlOutputBufferPtr out; /* a buffered parser output */
    int n_out;
    int len; /* the size in bytes of the array. */
    int n_len;
    char * buf; /* an char array */
    int n_buf;

    for (n_out = 0;n_out < gen_nb_xmlOutputBufferPtr;n_out++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
    for (n_buf = 0;n_buf < gen_nb_const_char_ptr;n_buf++) {
        mem_base = xmlMemBlocks();
        out = gen_xmlOutputBufferPtr(n_out, 0);
        len = gen_int(n_len, 1);
        buf = gen_const_char_ptr(n_buf, 2);

        ret_val = xmlOutputBufferWrite(out, len, (const char *)buf);
        desret_int(ret_val);
        call_tests++;
        des_xmlOutputBufferPtr(n_out, out, 0);
        des_int(n_len, len, 1);
        des_const_char_ptr(n_buf, (const char *)buf, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlOutputBufferWrite",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_len);
            printf(" %d", n_buf);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlOutputBufferWriteEscape(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlOutputBufferWriteString(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlOutputBufferPtr out; /* a buffered parser output */
    int n_out;
    char * str; /* a zero terminated C string */
    int n_str;

    for (n_out = 0;n_out < gen_nb_xmlOutputBufferPtr;n_out++) {
    for (n_str = 0;n_str < gen_nb_const_char_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        out = gen_xmlOutputBufferPtr(n_out, 0);
        str = gen_const_char_ptr(n_str, 1);

        ret_val = xmlOutputBufferWriteString(out, (const char *)str);
        desret_int(ret_val);
        call_tests++;
        des_xmlOutputBufferPtr(n_out, out, 0);
        des_const_char_ptr(n_str, (const char *)str, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlOutputBufferWriteString",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_out);
            printf(" %d", n_str);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlParserGetDirectory(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlParserInputBufferCreateFd(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputBufferPtr ret_val;
    int fd; /* a file descriptor number */
    int n_fd;
    xmlCharEncoding enc; /* the charset encoding if known */
    int n_enc;

    for (n_fd = 0;n_fd < gen_nb_int;n_fd++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        fd = gen_int(n_fd, 0);
        enc = gen_xmlCharEncoding(n_enc, 1);
        if (fd >= 0) fd = -1;

        ret_val = xmlParserInputBufferCreateFd(fd, enc);
        desret_xmlParserInputBufferPtr(ret_val);
        call_tests++;
        des_int(n_fd, fd, 0);
        des_xmlCharEncoding(n_enc, enc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputBufferCreateFd",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_fd);
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputBufferCreateFile(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputBufferPtr ret_val;
    FILE * file; /* a FILE* */
    int n_file;
    xmlCharEncoding enc; /* the charset encoding if known */
    int n_enc;

    for (n_file = 0;n_file < gen_nb_FILE_ptr;n_file++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        file = gen_FILE_ptr(n_file, 0);
        enc = gen_xmlCharEncoding(n_enc, 1);

        ret_val = xmlParserInputBufferCreateFile(file, enc);
        desret_xmlParserInputBufferPtr(ret_val);
        call_tests++;
        des_FILE_ptr(n_file, file, 0);
        des_xmlCharEncoding(n_enc, enc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputBufferCreateFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_file);
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputBufferCreateFilename(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputBufferPtr ret_val;
    const char * URI; /* a C string containing the URI or filename */
    int n_URI;
    xmlCharEncoding enc; /* the charset encoding if known */
    int n_enc;

    for (n_URI = 0;n_URI < gen_nb_fileoutput;n_URI++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        URI = gen_fileoutput(n_URI, 0);
        enc = gen_xmlCharEncoding(n_enc, 1);

        ret_val = xmlParserInputBufferCreateFilename(URI, enc);
        desret_xmlParserInputBufferPtr(ret_val);
        call_tests++;
        des_fileoutput(n_URI, URI, 0);
        des_xmlCharEncoding(n_enc, enc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputBufferCreateFilename",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URI);
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputBufferCreateMem(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputBufferPtr ret_val;
    char * mem; /* the memory input */
    int n_mem;
    int size; /* the length of the memory block */
    int n_size;
    xmlCharEncoding enc; /* the charset encoding if known */
    int n_enc;

    for (n_mem = 0;n_mem < gen_nb_const_char_ptr;n_mem++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        mem = gen_const_char_ptr(n_mem, 0);
        size = gen_int(n_size, 1);
        enc = gen_xmlCharEncoding(n_enc, 2);

        ret_val = xmlParserInputBufferCreateMem((const char *)mem, size, enc);
        desret_xmlParserInputBufferPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_mem, (const char *)mem, 0);
        des_int(n_size, size, 1);
        des_xmlCharEncoding(n_enc, enc, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputBufferCreateMem",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_mem);
            printf(" %d", n_size);
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputBufferCreateStatic(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputBufferPtr ret_val;
    char * mem; /* the memory input */
    int n_mem;
    int size; /* the length of the memory block */
    int n_size;
    xmlCharEncoding enc; /* the charset encoding if known */
    int n_enc;

    for (n_mem = 0;n_mem < gen_nb_const_char_ptr;n_mem++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
        mem_base = xmlMemBlocks();
        mem = gen_const_char_ptr(n_mem, 0);
        size = gen_int(n_size, 1);
        enc = gen_xmlCharEncoding(n_enc, 2);

        ret_val = xmlParserInputBufferCreateStatic((const char *)mem, size, enc);
        desret_xmlParserInputBufferPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_mem, (const char *)mem, 0);
        des_int(n_size, size, 1);
        des_xmlCharEncoding(n_enc, enc, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputBufferCreateStatic",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_mem);
            printf(" %d", n_size);
            printf(" %d", n_enc);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputBufferGrow(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserInputBufferPtr in; /* a buffered parser input */
    int n_in;
    int len; /* indicative value of the amount of chars to read */
    int n_len;

    for (n_in = 0;n_in < gen_nb_xmlParserInputBufferPtr;n_in++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        in = gen_xmlParserInputBufferPtr(n_in, 0);
        len = gen_int(n_len, 1);

        ret_val = xmlParserInputBufferGrow(in, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserInputBufferPtr(n_in, in, 0);
        des_int(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputBufferGrow",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_in);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputBufferPush(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserInputBufferPtr in; /* a buffered parser input */
    int n_in;
    int len; /* the size in bytes of the array. */
    int n_len;
    char * buf; /* an char array */
    int n_buf;

    for (n_in = 0;n_in < gen_nb_xmlParserInputBufferPtr;n_in++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
    for (n_buf = 0;n_buf < gen_nb_const_char_ptr;n_buf++) {
        mem_base = xmlMemBlocks();
        in = gen_xmlParserInputBufferPtr(n_in, 0);
        len = gen_int(n_len, 1);
        buf = gen_const_char_ptr(n_buf, 2);

        ret_val = xmlParserInputBufferPush(in, len, (const char *)buf);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserInputBufferPtr(n_in, in, 0);
        des_int(n_len, len, 1);
        des_const_char_ptr(n_buf, (const char *)buf, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputBufferPush",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_in);
            printf(" %d", n_len);
            printf(" %d", n_buf);
            printf("\n");
        }
    }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserInputBufferRead(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlParserInputBufferPtr in; /* a buffered parser input */
    int n_in;
    int len; /* indicative value of the amount of chars to read */
    int n_len;

    for (n_in = 0;n_in < gen_nb_xmlParserInputBufferPtr;n_in++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        in = gen_xmlParserInputBufferPtr(n_in, 0);
        len = gen_int(n_len, 1);

        ret_val = xmlParserInputBufferRead(in, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlParserInputBufferPtr(n_in, in, 0);
        des_int(n_len, len, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserInputBufferRead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_in);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlPopInputCallbacks(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;

        mem_base = xmlMemBlocks();

        ret_val = xmlPopInputCallbacks();
        desret_int(ret_val);
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlPopInputCallbacks",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlRegisterDefaultInputCallbacks(void) {
    int test_ret = 0;

    int mem_base;

        mem_base = xmlMemBlocks();

        xmlRegisterDefaultInputCallbacks();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegisterDefaultInputCallbacks",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;

    return(test_ret);
}


static int
test_xmlRegisterDefaultOutputCallbacks(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlRegisterDefaultOutputCallbacks();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegisterDefaultOutputCallbacks",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRegisterHTTPPostCallbacks(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED) && defined(LIBXML_HTTP_ENABLED)
    int mem_base;

        mem_base = xmlMemBlocks();

        xmlRegisterHTTPPostCallbacks();
        call_tests++;
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegisterHTTPPostCallbacks",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf("\n");
        }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_xmlIO(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xmlIO : 39 of 48 functions ...\n");
    test_ret += test_xmlAllocOutputBuffer();
    test_ret += test_xmlAllocParserInputBuffer();
    test_ret += test_xmlCheckFilename();
    test_ret += test_xmlCheckHTTPInput();
    test_ret += test_xmlCleanupInputCallbacks();
    test_ret += test_xmlCleanupOutputCallbacks();
    test_ret += test_xmlFileClose();
    test_ret += test_xmlFileMatch();
    test_ret += test_xmlFileOpen();
    test_ret += test_xmlFileRead();
    test_ret += test_xmlIOFTPClose();
    test_ret += test_xmlIOFTPMatch();
    test_ret += test_xmlIOFTPOpen();
    test_ret += test_xmlIOFTPRead();
    test_ret += test_xmlIOHTTPClose();
    test_ret += test_xmlIOHTTPMatch();
    test_ret += test_xmlIOHTTPOpen();
    test_ret += test_xmlIOHTTPRead();
    test_ret += test_xmlNoNetExternalEntityLoader();
    test_ret += test_xmlNormalizeWindowsPath();
    test_ret += test_xmlOutputBufferCreateBuffer();
    test_ret += test_xmlOutputBufferCreateFd();
    test_ret += test_xmlOutputBufferCreateFile();
    test_ret += test_xmlOutputBufferCreateFilename();
    test_ret += test_xmlOutputBufferFlush();
    test_ret += test_xmlOutputBufferWrite();
    test_ret += test_xmlOutputBufferWriteEscape();
    test_ret += test_xmlOutputBufferWriteString();
    test_ret += test_xmlParserGetDirectory();
    test_ret += test_xmlParserInputBufferCreateFd();
    test_ret += test_xmlParserInputBufferCreateFile();
    test_ret += test_xmlParserInputBufferCreateFilename();
    test_ret += test_xmlParserInputBufferCreateMem();
    test_ret += test_xmlParserInputBufferCreateStatic();
    test_ret += test_xmlParserInputBufferGrow();
    test_ret += test_xmlParserInputBufferPush();
    test_ret += test_xmlParserInputBufferRead();
    test_ret += test_xmlPopInputCallbacks();
    test_ret += test_xmlRegisterDefaultInputCallbacks();
    test_ret += test_xmlRegisterDefaultOutputCallbacks();
    test_ret += test_xmlRegisterHTTPPostCallbacks();

    if (test_ret != 0)
	printf("Module xmlIO: %d errors\n", test_ret);
    return(test_ret);
}
#ifdef LIBXML_AUTOMATA_ENABLED

#define gen_nb_xmlAutomataPtr 1
static xmlAutomataPtr gen_xmlAutomataPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlAutomataPtr(int no ATTRIBUTE_UNUSED, xmlAutomataPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlAutomataCompile(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataGetInitState(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataIsDeterminist(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_AUTOMATA_ENABLED)
    int mem_base;
    int ret_val;
    xmlAutomataPtr am; /* an automata */
    int n_am;

    for (n_am = 0;n_am < gen_nb_xmlAutomataPtr;n_am++) {
        mem_base = xmlMemBlocks();
        am = gen_xmlAutomataPtr(n_am, 0);

        ret_val = xmlAutomataIsDeterminist(am);
        desret_int(ret_val);
        call_tests++;
        des_xmlAutomataPtr(n_am, am, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAutomataIsDeterminist",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_am);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_AUTOMATA_ENABLED

#define gen_nb_xmlAutomataStatePtr 1
static xmlAutomataStatePtr gen_xmlAutomataStatePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlAutomataStatePtr(int no ATTRIBUTE_UNUSED, xmlAutomataStatePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlAutomataNewAllTrans(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewCountTrans(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewCountTrans2(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewCountedTrans(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewCounter(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_AUTOMATA_ENABLED)
    int mem_base;
    int ret_val;
    xmlAutomataPtr am; /* an automata */
    int n_am;
    int min; /* the minimal value on the counter */
    int n_min;
    int max; /* the maximal value on the counter */
    int n_max;

    for (n_am = 0;n_am < gen_nb_xmlAutomataPtr;n_am++) {
    for (n_min = 0;n_min < gen_nb_int;n_min++) {
    for (n_max = 0;n_max < gen_nb_int;n_max++) {
        mem_base = xmlMemBlocks();
        am = gen_xmlAutomataPtr(n_am, 0);
        min = gen_int(n_min, 1);
        max = gen_int(n_max, 2);

        ret_val = xmlAutomataNewCounter(am, min, max);
        desret_int(ret_val);
        call_tests++;
        des_xmlAutomataPtr(n_am, am, 0);
        des_int(n_min, min, 1);
        des_int(n_max, max, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAutomataNewCounter",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_am);
            printf(" %d", n_min);
            printf(" %d", n_max);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlAutomataNewCounterTrans(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewEpsilon(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewNegTrans(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewOnceTrans(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewOnceTrans2(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewState(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewTransition(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataNewTransition2(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlAutomataSetFinalState(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_AUTOMATA_ENABLED)
    int mem_base;
    int ret_val;
    xmlAutomataPtr am; /* an automata */
    int n_am;
    xmlAutomataStatePtr state; /* a state in this automata */
    int n_state;

    for (n_am = 0;n_am < gen_nb_xmlAutomataPtr;n_am++) {
    for (n_state = 0;n_state < gen_nb_xmlAutomataStatePtr;n_state++) {
        mem_base = xmlMemBlocks();
        am = gen_xmlAutomataPtr(n_am, 0);
        state = gen_xmlAutomataStatePtr(n_state, 1);

        ret_val = xmlAutomataSetFinalState(am, state);
        desret_int(ret_val);
        call_tests++;
        des_xmlAutomataPtr(n_am, am, 0);
        des_xmlAutomataStatePtr(n_state, state, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlAutomataSetFinalState",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_am);
            printf(" %d", n_state);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNewAutomata(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

static int
test_xmlautomata(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xmlautomata : 3 of 19 functions ...\n");
    test_ret += test_xmlAutomataCompile();
    test_ret += test_xmlAutomataGetInitState();
    test_ret += test_xmlAutomataIsDeterminist();
    test_ret += test_xmlAutomataNewAllTrans();
    test_ret += test_xmlAutomataNewCountTrans();
    test_ret += test_xmlAutomataNewCountTrans2();
    test_ret += test_xmlAutomataNewCountedTrans();
    test_ret += test_xmlAutomataNewCounter();
    test_ret += test_xmlAutomataNewCounterTrans();
    test_ret += test_xmlAutomataNewEpsilon();
    test_ret += test_xmlAutomataNewNegTrans();
    test_ret += test_xmlAutomataNewOnceTrans();
    test_ret += test_xmlAutomataNewOnceTrans2();
    test_ret += test_xmlAutomataNewState();
    test_ret += test_xmlAutomataNewTransition();
    test_ret += test_xmlAutomataNewTransition2();
    test_ret += test_xmlAutomataSetFinalState();
    test_ret += test_xmlNewAutomata();

    if (test_ret != 0)
	printf("Module xmlautomata: %d errors\n", test_ret);
    return(test_ret);
}

#define gen_nb_xmlGenericErrorFunc_ptr 1
static xmlGenericErrorFunc * gen_xmlGenericErrorFunc_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlGenericErrorFunc_ptr(int no ATTRIBUTE_UNUSED, xmlGenericErrorFunc * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_initGenericErrorDefaultFunc(void) {
    int test_ret = 0;

    int mem_base;
    xmlGenericErrorFunc * handler; /* the handler */
    int n_handler;

    for (n_handler = 0;n_handler < gen_nb_xmlGenericErrorFunc_ptr;n_handler++) {
        mem_base = xmlMemBlocks();
        handler = gen_xmlGenericErrorFunc_ptr(n_handler, 0);

        initGenericErrorDefaultFunc(handler);
        call_tests++;
        des_xmlGenericErrorFunc_ptr(n_handler, handler, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in initGenericErrorDefaultFunc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_handler);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


#define gen_nb_xmlErrorPtr 1
static xmlErrorPtr gen_xmlErrorPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlErrorPtr(int no ATTRIBUTE_UNUSED, xmlErrorPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}

static int
test_xmlCopyError(void) {
    int test_ret = 0;

    int mem_base;
    int ret_val;
    xmlErrorPtr from; /* a source error */
    int n_from;
    xmlErrorPtr to; /* a target error */
    int n_to;

    for (n_from = 0;n_from < gen_nb_xmlErrorPtr;n_from++) {
    for (n_to = 0;n_to < gen_nb_xmlErrorPtr;n_to++) {
        mem_base = xmlMemBlocks();
        from = gen_xmlErrorPtr(n_from, 0);
        to = gen_xmlErrorPtr(n_to, 1);

        ret_val = xmlCopyError(from, to);
        desret_int(ret_val);
        call_tests++;
        des_xmlErrorPtr(n_from, from, 0);
        des_xmlErrorPtr(n_to, to, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCopyError",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_from);
            printf(" %d", n_to);
            printf("\n");
        }
    }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlCtxtGetLastError(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlCtxtResetLastError(void) {
    int test_ret = 0;

    int mem_base;
    void * ctx; /* an XML parser context */
    int n_ctx;

    for (n_ctx = 0;n_ctx < gen_nb_void_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctx = gen_void_ptr(n_ctx, 0);

        xmlCtxtResetLastError(ctx);
        call_tests++;
        des_void_ptr(n_ctx, ctx, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlCtxtResetLastError",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlGetLastError(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlParserError(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlParserPrintFileContext(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr input; /* an xmlParserInputPtr input */
    int n_input;

    for (n_input = 0;n_input < gen_nb_xmlParserInputPtr;n_input++) {
        mem_base = xmlMemBlocks();
        input = gen_xmlParserInputPtr(n_input, 0);

        xmlParserPrintFileContext(input);
        call_tests++;
        des_xmlParserInputPtr(n_input, input, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserPrintFileContext",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_input);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserPrintFileInfo(void) {
    int test_ret = 0;

    int mem_base;
    xmlParserInputPtr input; /* an xmlParserInputPtr input */
    int n_input;

    for (n_input = 0;n_input < gen_nb_xmlParserInputPtr;n_input++) {
        mem_base = xmlMemBlocks();
        input = gen_xmlParserInputPtr(n_input, 0);

        xmlParserPrintFileInfo(input);
        call_tests++;
        des_xmlParserInputPtr(n_input, input, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlParserPrintFileInfo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_input);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlParserValidityError(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlParserValidityWarning(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlParserWarning(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlResetError(void) {
    int test_ret = 0;

    int mem_base;
    xmlErrorPtr err; /* pointer to the error. */
    int n_err;

    for (n_err = 0;n_err < gen_nb_xmlErrorPtr;n_err++) {
        mem_base = xmlMemBlocks();
        err = gen_xmlErrorPtr(n_err, 0);

        xmlResetError(err);
        call_tests++;
        des_xmlErrorPtr(n_err, err, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlResetError",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_err);
            printf("\n");
        }
    }
    function_tests++;

    return(test_ret);
}


static int
test_xmlResetLastError(void) {
    int test_ret = 0;



        xmlResetLastError();
        call_tests++;
        xmlResetLastError();
    function_tests++;

    return(test_ret);
}


static int
test_xmlSetGenericErrorFunc(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSetStructuredErrorFunc(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

static int
test_xmlerror(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xmlerror : 7 of 15 functions ...\n");
    test_ret += test_initGenericErrorDefaultFunc();
    test_ret += test_xmlCopyError();
    test_ret += test_xmlCtxtGetLastError();
    test_ret += test_xmlCtxtResetLastError();
    test_ret += test_xmlGetLastError();
    test_ret += test_xmlParserError();
    test_ret += test_xmlParserPrintFileContext();
    test_ret += test_xmlParserPrintFileInfo();
    test_ret += test_xmlParserValidityError();
    test_ret += test_xmlParserValidityWarning();
    test_ret += test_xmlParserWarning();
    test_ret += test_xmlResetError();
    test_ret += test_xmlResetLastError();
    test_ret += test_xmlSetGenericErrorFunc();
    test_ret += test_xmlSetStructuredErrorFunc();

    if (test_ret != 0)
	printf("Module xmlerror: %d errors\n", test_ret);
    return(test_ret);
}
#ifdef LIBXML_MODULES_ENABLED

#define gen_nb_xmlModulePtr 1
static xmlModulePtr gen_xmlModulePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlModulePtr(int no ATTRIBUTE_UNUSED, xmlModulePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlModuleClose(void) {
    int test_ret = 0;

#if defined(LIBXML_MODULES_ENABLED)
    int mem_base;
    int ret_val;
    xmlModulePtr module; /* the module handle */
    int n_module;

    for (n_module = 0;n_module < gen_nb_xmlModulePtr;n_module++) {
        mem_base = xmlMemBlocks();
        module = gen_xmlModulePtr(n_module, 0);

        ret_val = xmlModuleClose(module);
        desret_int(ret_val);
        call_tests++;
        des_xmlModulePtr(n_module, module, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlModuleClose",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_module);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlModuleOpen(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlModuleSymbol(void) {
    int test_ret = 0;

#if defined(LIBXML_MODULES_ENABLED)
    int mem_base;
    int ret_val;
    xmlModulePtr module; /* the module */
    int n_module;
    char * name; /* the name of the symbol */
    int n_name;
    void ** symbol; /* the resulting symbol address */
    int n_symbol;

    for (n_module = 0;n_module < gen_nb_xmlModulePtr;n_module++) {
    for (n_name = 0;n_name < gen_nb_const_char_ptr;n_name++) {
    for (n_symbol = 0;n_symbol < gen_nb_void_ptr_ptr;n_symbol++) {
        mem_base = xmlMemBlocks();
        module = gen_xmlModulePtr(n_module, 0);
        name = gen_const_char_ptr(n_name, 1);
        symbol = gen_void_ptr_ptr(n_symbol, 2);

        ret_val = xmlModuleSymbol(module, (const char *)name, symbol);
        desret_int(ret_val);
        call_tests++;
        des_xmlModulePtr(n_module, module, 0);
        des_const_char_ptr(n_name, (const char *)name, 1);
        des_void_ptr_ptr(n_symbol, symbol, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlModuleSymbol",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_module);
            printf(" %d", n_name);
            printf(" %d", n_symbol);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_xmlmodule(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xmlmodule : 2 of 4 functions ...\n");
    test_ret += test_xmlModuleClose();
    test_ret += test_xmlModuleOpen();
    test_ret += test_xmlModuleSymbol();

    if (test_ret != 0)
	printf("Module xmlmodule: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlNewTextReader(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlTextReaderPtr ret_val;
    xmlParserInputBufferPtr input; /* the xmlParserInputBufferPtr used to read data */
    int n_input;
    const char * URI; /* the URI information for the source if available */
    int n_URI;

    for (n_input = 0;n_input < gen_nb_xmlParserInputBufferPtr;n_input++) {
    for (n_URI = 0;n_URI < gen_nb_filepath;n_URI++) {
        mem_base = xmlMemBlocks();
        input = gen_xmlParserInputBufferPtr(n_input, 0);
        URI = gen_filepath(n_URI, 1);

        ret_val = xmlNewTextReader(input, URI);
        desret_xmlTextReaderPtr(ret_val);
        call_tests++;
        des_xmlParserInputBufferPtr(n_input, input, 0);
        des_filepath(n_URI, URI, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewTextReader",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_input);
            printf(" %d", n_URI);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlNewTextReaderFilename(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlTextReaderPtr ret_val;
    const char * URI; /* the URI of the resource to process */
    int n_URI;

    for (n_URI = 0;n_URI < gen_nb_filepath;n_URI++) {
        mem_base = xmlMemBlocks();
        URI = gen_filepath(n_URI, 0);

        ret_val = xmlNewTextReaderFilename(URI);
        desret_xmlTextReaderPtr(ret_val);
        call_tests++;
        des_filepath(n_URI, URI, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlNewTextReaderFilename",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URI);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReaderForDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlTextReaderPtr ret_val;
    xmlChar * cur; /* a pointer to a zero terminated string */
    int n_cur;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        cur = gen_const_xmlChar_ptr(n_cur, 0);
        URL = gen_filepath(n_URL, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        options = gen_parseroptions(n_options, 3);

        ret_val = xmlReaderForDoc((const xmlChar *)cur, URL, (const char *)encoding, options);
        desret_xmlTextReaderPtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 0);
        des_filepath(n_URL, URL, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_parseroptions(n_options, options, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReaderForDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_cur);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReaderForFile(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlTextReaderPtr ret_val;
    const char * filename; /* a file or URL */
    int n_filename;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        filename = gen_filepath(n_filename, 0);
        encoding = gen_const_char_ptr(n_encoding, 1);
        options = gen_parseroptions(n_options, 2);

        ret_val = xmlReaderForFile(filename, (const char *)encoding, options);
        desret_xmlTextReaderPtr(ret_val);
        call_tests++;
        des_filepath(n_filename, filename, 0);
        des_const_char_ptr(n_encoding, (const char *)encoding, 1);
        des_parseroptions(n_options, options, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReaderForFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_filename);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReaderForMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlTextReaderPtr ret_val;
    char * buffer; /* a pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);
        URL = gen_filepath(n_URL, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        options = gen_parseroptions(n_options, 4);

        ret_val = xmlReaderForMemory((const char *)buffer, size, URL, (const char *)encoding, options);
        desret_xmlTextReaderPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        des_filepath(n_URL, URL, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_parseroptions(n_options, options, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReaderForMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReaderNewDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* an XML reader */
    int n_reader;
    xmlChar * cur; /* a pointer to a zero terminated string */
    int n_cur;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_cur = 0;n_cur < gen_nb_const_xmlChar_ptr;n_cur++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        cur = gen_const_xmlChar_ptr(n_cur, 1);
        URL = gen_filepath(n_URL, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        options = gen_parseroptions(n_options, 4);

        ret_val = xmlReaderNewDoc(reader, (const xmlChar *)cur, URL, (const char *)encoding, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_xmlChar_ptr(n_cur, (const xmlChar *)cur, 1);
        des_filepath(n_URL, URL, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_parseroptions(n_options, options, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReaderNewDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_cur);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReaderNewFile(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* an XML reader */
    int n_reader;
    const char * filename; /* a file or URL */
    int n_filename;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        filename = gen_filepath(n_filename, 1);
        encoding = gen_const_char_ptr(n_encoding, 2);
        options = gen_parseroptions(n_options, 3);

        ret_val = xmlReaderNewFile(reader, filename, (const char *)encoding, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_filepath(n_filename, filename, 1);
        des_const_char_ptr(n_encoding, (const char *)encoding, 2);
        des_parseroptions(n_options, options, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReaderNewFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_filename);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReaderNewMemory(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* an XML reader */
    int n_reader;
    char * buffer; /* a pointer to a char array */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        buffer = gen_const_char_ptr(n_buffer, 1);
        size = gen_int(n_size, 2);
        URL = gen_filepath(n_URL, 3);
        encoding = gen_const_char_ptr(n_encoding, 4);
        options = gen_parseroptions(n_options, 5);

        ret_val = xmlReaderNewMemory(reader, (const char *)buffer, size, URL, (const char *)encoding, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_char_ptr(n_buffer, (const char *)buffer, 1);
        des_int(n_size, size, 2);
        des_filepath(n_URL, URL, 3);
        des_const_char_ptr(n_encoding, (const char *)encoding, 4);
        des_parseroptions(n_options, options, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReaderNewMemory",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReaderNewWalker(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* an XML reader */
    int n_reader;
    xmlDocPtr doc; /* a preparsed document */
    int n_doc;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlReaderNewWalker(reader, doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReaderNewWalker",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlReaderWalker(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlTextReaderPtr ret_val;
    xmlDocPtr doc; /* a preparsed document */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);

        ret_val = xmlReaderWalker(doc);
        desret_xmlTextReaderPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlReaderWalker",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderAttributeCount(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderAttributeCount(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderAttributeCount",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderBaseUri(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderBaseUri(reader);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderBaseUri",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderByteConsumed(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    long ret_val;
    xmlTextReaderPtr reader; /* an XML reader */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderByteConsumed(reader);
        desret_long(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderByteConsumed",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderClose(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderClose(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderClose",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstBaseUri(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstBaseUri(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstBaseUri",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstEncoding(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstEncoding(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstEncoding",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstLocalName(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstLocalName(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstLocalName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstName(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstName(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstNamespaceUri(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstNamespaceUri(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstNamespaceUri",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstPrefix(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstPrefix(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstPrefix",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstString(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlChar * str; /* the string to intern. */
    int n_str;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_str = 0;n_str < gen_nb_const_xmlChar_ptr;n_str++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        str = gen_const_xmlChar_ptr(n_str, 1);

        ret_val = xmlTextReaderConstString(reader, (const xmlChar *)str);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_xmlChar_ptr(n_str, (const xmlChar *)str, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstString",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_str);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstValue(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstValue(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstXmlLang(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstXmlLang(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstXmlLang",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderConstXmlVersion(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    const xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderConstXmlVersion(reader);
        desret_const_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderConstXmlVersion",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderCurrentDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlDocPtr ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderCurrentDoc(reader);
        desret_xmlDocPtr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderCurrentDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderCurrentNode(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderCurrentNode(reader);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderCurrentNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderDepth(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderDepth(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderDepth",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderExpand(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderExpand(reader);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderExpand",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderGetAttribute(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlChar * name; /* the qualified name of the attribute. */
    int n_name;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlTextReaderGetAttribute(reader, (const xmlChar *)name);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderGetAttribute",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderGetAttributeNo(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    int no; /* the zero-based index of the attribute relative to the containing element */
    int n_no;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_no = 0;n_no < gen_nb_int;n_no++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        no = gen_int(n_no, 1);

        ret_val = xmlTextReaderGetAttributeNo(reader, no);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_int(n_no, no, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderGetAttributeNo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_no);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderGetAttributeNs(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlChar * localName; /* the local name of the attribute. */
    int n_localName;
    xmlChar * namespaceURI; /* the namespace URI of the attribute. */
    int n_namespaceURI;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_localName = 0;n_localName < gen_nb_const_xmlChar_ptr;n_localName++) {
    for (n_namespaceURI = 0;n_namespaceURI < gen_nb_const_xmlChar_ptr;n_namespaceURI++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        localName = gen_const_xmlChar_ptr(n_localName, 1);
        namespaceURI = gen_const_xmlChar_ptr(n_namespaceURI, 2);

        ret_val = xmlTextReaderGetAttributeNs(reader, (const xmlChar *)localName, (const xmlChar *)namespaceURI);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_xmlChar_ptr(n_localName, (const xmlChar *)localName, 1);
        des_const_xmlChar_ptr(n_namespaceURI, (const xmlChar *)namespaceURI, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderGetAttributeNs",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_localName);
            printf(" %d", n_namespaceURI);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_READER_ENABLED

#define gen_nb_xmlTextReaderErrorFunc_ptr 1
static xmlTextReaderErrorFunc * gen_xmlTextReaderErrorFunc_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlTextReaderErrorFunc_ptr(int no ATTRIBUTE_UNUSED, xmlTextReaderErrorFunc * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlTextReaderGetErrorHandler(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlTextReaderErrorFunc * f; /* the callback function or NULL is no callback has been registered */
    int n_f;
    void ** arg; /* a user argument */
    int n_arg;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_f = 0;n_f < gen_nb_xmlTextReaderErrorFunc_ptr;n_f++) {
    for (n_arg = 0;n_arg < gen_nb_void_ptr_ptr;n_arg++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        f = gen_xmlTextReaderErrorFunc_ptr(n_f, 1);
        arg = gen_void_ptr_ptr(n_arg, 2);

        xmlTextReaderGetErrorHandler(reader, f, arg);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_xmlTextReaderErrorFunc_ptr(n_f, f, 1);
        des_void_ptr_ptr(n_arg, arg, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderGetErrorHandler",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_f);
            printf(" %d", n_arg);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderGetParserColumnNumber(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the user data (XML reader context) */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderGetParserColumnNumber(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderGetParserColumnNumber",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderGetParserLineNumber(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the user data (XML reader context) */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderGetParserLineNumber(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderGetParserLineNumber",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderGetParserProp(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    int prop; /* the xmlParserProperties to get */
    int n_prop;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_prop = 0;n_prop < gen_nb_int;n_prop++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        prop = gen_int(n_prop, 1);

        ret_val = xmlTextReaderGetParserProp(reader, prop);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_int(n_prop, prop, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderGetParserProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_prop);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderGetRemainder(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlParserInputBufferPtr ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderGetRemainder(reader);
        desret_xmlParserInputBufferPtr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderGetRemainder",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderHasAttributes(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderHasAttributes(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderHasAttributes",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderHasValue(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderHasValue(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderHasValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderIsDefault(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderIsDefault(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderIsDefault",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderIsEmptyElement(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderIsEmptyElement(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderIsEmptyElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderIsNamespaceDecl(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderIsNamespaceDecl(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderIsNamespaceDecl",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderIsValid(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderIsValid(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderIsValid",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderLocalName(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderLocalName(reader);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderLocalName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_READER_ENABLED

#define gen_nb_xmlTextReaderLocatorPtr 1
static xmlTextReaderLocatorPtr gen_xmlTextReaderLocatorPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlTextReaderLocatorPtr(int no ATTRIBUTE_UNUSED, xmlTextReaderLocatorPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlTextReaderLocatorBaseURI(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderLocatorPtr locator; /* the xmlTextReaderLocatorPtr used */
    int n_locator;

    for (n_locator = 0;n_locator < gen_nb_xmlTextReaderLocatorPtr;n_locator++) {
        mem_base = xmlMemBlocks();
        locator = gen_xmlTextReaderLocatorPtr(n_locator, 0);

        ret_val = xmlTextReaderLocatorBaseURI(locator);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderLocatorPtr(n_locator, locator, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderLocatorBaseURI",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_locator);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderLocatorLineNumber(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderLocatorPtr locator; /* the xmlTextReaderLocatorPtr used */
    int n_locator;

    for (n_locator = 0;n_locator < gen_nb_xmlTextReaderLocatorPtr;n_locator++) {
        mem_base = xmlMemBlocks();
        locator = gen_xmlTextReaderLocatorPtr(n_locator, 0);

        ret_val = xmlTextReaderLocatorLineNumber(locator);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderLocatorPtr(n_locator, locator, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderLocatorLineNumber",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_locator);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderLookupNamespace(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlChar * prefix; /* the prefix whose namespace URI is to be resolved. To return the default namespace, specify NULL */
    int n_prefix;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_prefix = 0;n_prefix < gen_nb_const_xmlChar_ptr;n_prefix++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        prefix = gen_const_xmlChar_ptr(n_prefix, 1);

        ret_val = xmlTextReaderLookupNamespace(reader, (const xmlChar *)prefix);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_xmlChar_ptr(n_prefix, (const xmlChar *)prefix, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderLookupNamespace",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_prefix);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderMoveToAttribute(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlChar * name; /* the qualified name of the attribute. */
    int n_name;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        name = gen_const_xmlChar_ptr(n_name, 1);

        ret_val = xmlTextReaderMoveToAttribute(reader, (const xmlChar *)name);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderMoveToAttribute",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderMoveToAttributeNo(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    int no; /* the zero-based index of the attribute relative to the containing element. */
    int n_no;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_no = 0;n_no < gen_nb_int;n_no++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        no = gen_int(n_no, 1);

        ret_val = xmlTextReaderMoveToAttributeNo(reader, no);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_int(n_no, no, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderMoveToAttributeNo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_no);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderMoveToAttributeNs(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlChar * localName; /* the local name of the attribute. */
    int n_localName;
    xmlChar * namespaceURI; /* the namespace URI of the attribute. */
    int n_namespaceURI;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_localName = 0;n_localName < gen_nb_const_xmlChar_ptr;n_localName++) {
    for (n_namespaceURI = 0;n_namespaceURI < gen_nb_const_xmlChar_ptr;n_namespaceURI++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        localName = gen_const_xmlChar_ptr(n_localName, 1);
        namespaceURI = gen_const_xmlChar_ptr(n_namespaceURI, 2);

        ret_val = xmlTextReaderMoveToAttributeNs(reader, (const xmlChar *)localName, (const xmlChar *)namespaceURI);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_xmlChar_ptr(n_localName, (const xmlChar *)localName, 1);
        des_const_xmlChar_ptr(n_namespaceURI, (const xmlChar *)namespaceURI, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderMoveToAttributeNs",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_localName);
            printf(" %d", n_namespaceURI);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderMoveToElement(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderMoveToElement(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderMoveToElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderMoveToFirstAttribute(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderMoveToFirstAttribute(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderMoveToFirstAttribute",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderMoveToNextAttribute(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderMoveToNextAttribute(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderMoveToNextAttribute",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderName(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderName(reader);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderName",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderNamespaceUri(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderNamespaceUri(reader);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderNamespaceUri",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderNext(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderNext(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderNext",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderNextSibling(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderNextSibling(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderNextSibling",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderNodeType(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderNodeType(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderNodeType",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderNormalization(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderNormalization(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderNormalization",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderPrefix(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderPrefix(reader);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderPrefix",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderPreserve(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlNodePtr ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderPreserve(reader);
        desret_xmlNodePtr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderPreserve",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderPreservePattern(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED) && defined(LIBXML_PATTERN_ENABLED)
#ifdef LIBXML_PATTERN_ENABLED
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlChar * pattern; /* an XPath subset pattern */
    int n_pattern;
    xmlChar ** namespaces; /* the prefix definitions, array of [URI, prefix] or NULL */
    int n_namespaces;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_pattern = 0;n_pattern < gen_nb_const_xmlChar_ptr;n_pattern++) {
    for (n_namespaces = 0;n_namespaces < gen_nb_const_xmlChar_ptr_ptr;n_namespaces++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        pattern = gen_const_xmlChar_ptr(n_pattern, 1);
        namespaces = gen_const_xmlChar_ptr_ptr(n_namespaces, 2);

        ret_val = xmlTextReaderPreservePattern(reader, (const xmlChar *)pattern, (const xmlChar **)namespaces);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_xmlChar_ptr(n_pattern, (const xmlChar *)pattern, 1);
        des_const_xmlChar_ptr_ptr(n_namespaces, (const xmlChar **)namespaces, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderPreservePattern",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_pattern);
            printf(" %d", n_namespaces);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif
#endif

    return(test_ret);
}


static int
test_xmlTextReaderQuoteChar(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderQuoteChar(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderQuoteChar",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderRead(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderRead(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderRead",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderReadAttributeValue(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderReadAttributeValue(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderReadAttributeValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderReadState(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderReadState(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderReadState",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderRelaxNGSetSchema(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED) && defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlRelaxNGPtr schema; /* a precompiled RelaxNG schema */
    int n_schema;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_schema = 0;n_schema < gen_nb_xmlRelaxNGPtr;n_schema++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        schema = gen_xmlRelaxNGPtr(n_schema, 1);

        ret_val = xmlTextReaderRelaxNGSetSchema(reader, schema);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_xmlRelaxNGPtr(n_schema, schema, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderRelaxNGSetSchema",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_schema);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderRelaxNGValidate(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED) && defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    char * rng; /* the path to a RelaxNG schema or NULL */
    int n_rng;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_rng = 0;n_rng < gen_nb_const_char_ptr;n_rng++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        rng = gen_const_char_ptr(n_rng, 1);

        ret_val = xmlTextReaderRelaxNGValidate(reader, (const char *)rng);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_char_ptr(n_rng, (const char *)rng, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderRelaxNGValidate",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_rng);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderRelaxNGValidateCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED) && defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlRelaxNGValidCtxtPtr ctxt; /* the RelaxNG schema validation context or NULL */
    int n_ctxt;
    int options; /* options (not used yet) */
    int n_options;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_ctxt = 0;n_ctxt < gen_nb_xmlRelaxNGValidCtxtPtr;n_ctxt++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        ctxt = gen_xmlRelaxNGValidCtxtPtr(n_ctxt, 1);
        options = gen_parseroptions(n_options, 2);

        ret_val = xmlTextReaderRelaxNGValidateCtxt(reader, ctxt, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_xmlRelaxNGValidCtxtPtr(n_ctxt, ctxt, 1);
        des_parseroptions(n_options, options, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderRelaxNGValidateCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_ctxt);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderSchemaValidate(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED) && defined(LIBXML_SCHEMAS_ENABLED)
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    char * xsd; /* the path to a W3C XSD schema or NULL */
    int n_xsd;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_xsd = 0;n_xsd < gen_nb_const_char_ptr;n_xsd++) {
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        xsd = gen_const_char_ptr(n_xsd, 1);

        ret_val = xmlTextReaderSchemaValidate(reader, (const char *)xsd);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_const_char_ptr(n_xsd, (const char *)xsd, 1);
        xmlResetLastError();
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderSchemaValidateCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED) && defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlSchemaValidCtxtPtr ctxt; /* the XML Schema validation context or NULL */
    int n_ctxt;
    int options; /* options (not used yet) */
    int n_options;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 1);
        options = gen_parseroptions(n_options, 2);

        ret_val = xmlTextReaderSchemaValidateCtxt(reader, ctxt, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 1);
        des_parseroptions(n_options, options, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderSchemaValidateCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_ctxt);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderSetErrorHandler(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlTextReaderSetParserProp(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    int prop; /* the xmlParserProperties to set */
    int n_prop;
    int value; /* usually 0 or 1 to (de)activate it */
    int n_value;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_prop = 0;n_prop < gen_nb_int;n_prop++) {
    for (n_value = 0;n_value < gen_nb_int;n_value++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        prop = gen_int(n_prop, 1);
        value = gen_int(n_value, 2);

        ret_val = xmlTextReaderSetParserProp(reader, prop, value);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_int(n_prop, prop, 1);
        des_int(n_value, value, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderSetParserProp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_prop);
            printf(" %d", n_value);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderSetSchema(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED) && defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;
    xmlSchemaPtr schema; /* a precompiled Schema schema */
    int n_schema;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_schema = 0;n_schema < gen_nb_xmlSchemaPtr;n_schema++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        schema = gen_xmlSchemaPtr(n_schema, 1);

        ret_val = xmlTextReaderSetSchema(reader, schema);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_xmlSchemaPtr(n_schema, schema, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderSetSchema",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_schema);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderSetStructuredErrorHandler(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlTextReaderSetup(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* an XML reader */
    int n_reader;
    xmlParserInputBufferPtr input; /* xmlParserInputBufferPtr used to feed the reader, will be destroyed with it. */
    int n_input;
    const char * URL; /* the base URL to use for the document */
    int n_URL;
    char * encoding; /* the document encoding, or NULL */
    int n_encoding;
    int options; /* a combination of xmlParserOption */
    int n_options;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
    for (n_input = 0;n_input < gen_nb_xmlParserInputBufferPtr;n_input++) {
    for (n_URL = 0;n_URL < gen_nb_filepath;n_URL++) {
    for (n_encoding = 0;n_encoding < gen_nb_const_char_ptr;n_encoding++) {
    for (n_options = 0;n_options < gen_nb_parseroptions;n_options++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);
        input = gen_xmlParserInputBufferPtr(n_input, 1);
        URL = gen_filepath(n_URL, 2);
        encoding = gen_const_char_ptr(n_encoding, 3);
        options = gen_parseroptions(n_options, 4);

        ret_val = xmlTextReaderSetup(reader, input, URL, (const char *)encoding, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        des_filepath(n_URL, URL, 2);
        des_const_char_ptr(n_encoding, (const char *)encoding, 3);
        des_parseroptions(n_options, options, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderSetup",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf(" %d", n_input);
            printf(" %d", n_URL);
            printf(" %d", n_encoding);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderStandalone(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    int ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderStandalone(reader);
        desret_int(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderStandalone",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderValue(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderValue(reader);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlTextReaderXmlLang(void) {
    int test_ret = 0;

#if defined(LIBXML_READER_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlTextReaderPtr reader; /* the xmlTextReaderPtr used */
    int n_reader;

    for (n_reader = 0;n_reader < gen_nb_xmlTextReaderPtr;n_reader++) {
        mem_base = xmlMemBlocks();
        reader = gen_xmlTextReaderPtr(n_reader, 0);

        ret_val = xmlTextReaderXmlLang(reader);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_xmlTextReaderPtr(n_reader, reader, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlTextReaderXmlLang",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_reader);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_xmlreader(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xmlreader : 76 of 86 functions ...\n");
    test_ret += test_xmlNewTextReader();
    test_ret += test_xmlNewTextReaderFilename();
    test_ret += test_xmlReaderForDoc();
    test_ret += test_xmlReaderForFile();
    test_ret += test_xmlReaderForMemory();
    test_ret += test_xmlReaderNewDoc();
    test_ret += test_xmlReaderNewFile();
    test_ret += test_xmlReaderNewMemory();
    test_ret += test_xmlReaderNewWalker();
    test_ret += test_xmlReaderWalker();
    test_ret += test_xmlTextReaderAttributeCount();
    test_ret += test_xmlTextReaderBaseUri();
    test_ret += test_xmlTextReaderByteConsumed();
    test_ret += test_xmlTextReaderClose();
    test_ret += test_xmlTextReaderConstBaseUri();
    test_ret += test_xmlTextReaderConstEncoding();
    test_ret += test_xmlTextReaderConstLocalName();
    test_ret += test_xmlTextReaderConstName();
    test_ret += test_xmlTextReaderConstNamespaceUri();
    test_ret += test_xmlTextReaderConstPrefix();
    test_ret += test_xmlTextReaderConstString();
    test_ret += test_xmlTextReaderConstValue();
    test_ret += test_xmlTextReaderConstXmlLang();
    test_ret += test_xmlTextReaderConstXmlVersion();
    test_ret += test_xmlTextReaderCurrentDoc();
    test_ret += test_xmlTextReaderCurrentNode();
    test_ret += test_xmlTextReaderDepth();
    test_ret += test_xmlTextReaderExpand();
    test_ret += test_xmlTextReaderGetAttribute();
    test_ret += test_xmlTextReaderGetAttributeNo();
    test_ret += test_xmlTextReaderGetAttributeNs();
    test_ret += test_xmlTextReaderGetErrorHandler();
    test_ret += test_xmlTextReaderGetParserColumnNumber();
    test_ret += test_xmlTextReaderGetParserLineNumber();
    test_ret += test_xmlTextReaderGetParserProp();
    test_ret += test_xmlTextReaderGetRemainder();
    test_ret += test_xmlTextReaderHasAttributes();
    test_ret += test_xmlTextReaderHasValue();
    test_ret += test_xmlTextReaderIsDefault();
    test_ret += test_xmlTextReaderIsEmptyElement();
    test_ret += test_xmlTextReaderIsNamespaceDecl();
    test_ret += test_xmlTextReaderIsValid();
    test_ret += test_xmlTextReaderLocalName();
    test_ret += test_xmlTextReaderLocatorBaseURI();
    test_ret += test_xmlTextReaderLocatorLineNumber();
    test_ret += test_xmlTextReaderLookupNamespace();
    test_ret += test_xmlTextReaderMoveToAttribute();
    test_ret += test_xmlTextReaderMoveToAttributeNo();
    test_ret += test_xmlTextReaderMoveToAttributeNs();
    test_ret += test_xmlTextReaderMoveToElement();
    test_ret += test_xmlTextReaderMoveToFirstAttribute();
    test_ret += test_xmlTextReaderMoveToNextAttribute();
    test_ret += test_xmlTextReaderName();
    test_ret += test_xmlTextReaderNamespaceUri();
    test_ret += test_xmlTextReaderNext();
    test_ret += test_xmlTextReaderNextSibling();
    test_ret += test_xmlTextReaderNodeType();
    test_ret += test_xmlTextReaderNormalization();
    test_ret += test_xmlTextReaderPrefix();
    test_ret += test_xmlTextReaderPreserve();
    test_ret += test_xmlTextReaderPreservePattern();
    test_ret += test_xmlTextReaderQuoteChar();
    test_ret += test_xmlTextReaderRead();
    test_ret += test_xmlTextReaderReadAttributeValue();
    test_ret += test_xmlTextReaderReadState();
    test_ret += test_xmlTextReaderRelaxNGSetSchema();
    test_ret += test_xmlTextReaderRelaxNGValidate();
    test_ret += test_xmlTextReaderRelaxNGValidateCtxt();
    test_ret += test_xmlTextReaderSchemaValidate();
    test_ret += test_xmlTextReaderSchemaValidateCtxt();
    test_ret += test_xmlTextReaderSetErrorHandler();
    test_ret += test_xmlTextReaderSetParserProp();
    test_ret += test_xmlTextReaderSetSchema();
    test_ret += test_xmlTextReaderSetStructuredErrorHandler();
    test_ret += test_xmlTextReaderSetup();
    test_ret += test_xmlTextReaderStandalone();
    test_ret += test_xmlTextReaderValue();
    test_ret += test_xmlTextReaderXmlLang();

    if (test_ret != 0)
	printf("Module xmlreader: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlExpCtxtNbCons(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    int ret_val;
    xmlExpCtxtPtr ctxt; /* an expression context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlExpCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlExpCtxtPtr(n_ctxt, 0);

        ret_val = xmlExpCtxtNbCons(ctxt);
        desret_int(ret_val);
        call_tests++;
        des_xmlExpCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpCtxtNbCons",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlExpCtxtNbNodes(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    int ret_val;
    xmlExpCtxtPtr ctxt; /* an expression context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlExpCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlExpCtxtPtr(n_ctxt, 0);

        ret_val = xmlExpCtxtNbNodes(ctxt);
        desret_int(ret_val);
        call_tests++;
        des_xmlExpCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpCtxtNbNodes",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlExpDump(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    xmlBufferPtr buf; /* a buffer to receive the output */
    int n_buf;
    xmlExpNodePtr expr; /* the compiled expression */
    int n_expr;

    for (n_buf = 0;n_buf < gen_nb_xmlBufferPtr;n_buf++) {
    for (n_expr = 0;n_expr < gen_nb_xmlExpNodePtr;n_expr++) {
        mem_base = xmlMemBlocks();
        buf = gen_xmlBufferPtr(n_buf, 0);
        expr = gen_xmlExpNodePtr(n_expr, 1);

        xmlExpDump(buf, expr);
        call_tests++;
        des_xmlBufferPtr(n_buf, buf, 0);
        des_xmlExpNodePtr(n_expr, expr, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buf);
            printf(" %d", n_expr);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlExpExpDerive(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlExpGetLanguage(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    int ret_val;
    xmlExpCtxtPtr ctxt; /* the expression context */
    int n_ctxt;
    xmlExpNodePtr exp; /* the expression */
    int n_exp;
    xmlChar ** langList; /* where to store the tokens */
    int n_langList;
    int len; /* the allocated lenght of @list */
    int n_len;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlExpCtxtPtr;n_ctxt++) {
    for (n_exp = 0;n_exp < gen_nb_xmlExpNodePtr;n_exp++) {
    for (n_langList = 0;n_langList < gen_nb_const_xmlChar_ptr_ptr;n_langList++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlExpCtxtPtr(n_ctxt, 0);
        exp = gen_xmlExpNodePtr(n_exp, 1);
        langList = gen_const_xmlChar_ptr_ptr(n_langList, 2);
        len = gen_int(n_len, 3);

        ret_val = xmlExpGetLanguage(ctxt, exp, (const xmlChar **)langList, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlExpCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlExpNodePtr(n_exp, exp, 1);
        des_const_xmlChar_ptr_ptr(n_langList, (const xmlChar **)langList, 2);
        des_int(n_len, len, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpGetLanguage",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_exp);
            printf(" %d", n_langList);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlExpGetStart(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    int ret_val;
    xmlExpCtxtPtr ctxt; /* the expression context */
    int n_ctxt;
    xmlExpNodePtr exp; /* the expression */
    int n_exp;
    xmlChar ** tokList; /* where to store the tokens */
    int n_tokList;
    int len; /* the allocated lenght of @list */
    int n_len;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlExpCtxtPtr;n_ctxt++) {
    for (n_exp = 0;n_exp < gen_nb_xmlExpNodePtr;n_exp++) {
    for (n_tokList = 0;n_tokList < gen_nb_const_xmlChar_ptr_ptr;n_tokList++) {
    for (n_len = 0;n_len < gen_nb_int;n_len++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlExpCtxtPtr(n_ctxt, 0);
        exp = gen_xmlExpNodePtr(n_exp, 1);
        tokList = gen_const_xmlChar_ptr_ptr(n_tokList, 2);
        len = gen_int(n_len, 3);

        ret_val = xmlExpGetStart(ctxt, exp, (const xmlChar **)tokList, len);
        desret_int(ret_val);
        call_tests++;
        des_xmlExpCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlExpNodePtr(n_exp, exp, 1);
        des_const_xmlChar_ptr_ptr(n_tokList, (const xmlChar **)tokList, 2);
        des_int(n_len, len, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpGetStart",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_exp);
            printf(" %d", n_tokList);
            printf(" %d", n_len);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlExpIsNillable(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    int ret_val;
    xmlExpNodePtr exp; /* the expression */
    int n_exp;

    for (n_exp = 0;n_exp < gen_nb_xmlExpNodePtr;n_exp++) {
        mem_base = xmlMemBlocks();
        exp = gen_xmlExpNodePtr(n_exp, 0);

        ret_val = xmlExpIsNillable(exp);
        desret_int(ret_val);
        call_tests++;
        des_xmlExpNodePtr(n_exp, exp, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpIsNillable",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_exp);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlExpMaxToken(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    int ret_val;
    xmlExpNodePtr expr; /* a compiled expression */
    int n_expr;

    for (n_expr = 0;n_expr < gen_nb_xmlExpNodePtr;n_expr++) {
        mem_base = xmlMemBlocks();
        expr = gen_xmlExpNodePtr(n_expr, 0);

        ret_val = xmlExpMaxToken(expr);
        desret_int(ret_val);
        call_tests++;
        des_xmlExpNodePtr(n_expr, expr, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpMaxToken",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_expr);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlExpNewAtom(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlExpNewCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlExpNewOr(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlExpNewRange(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlExpNewSeq(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlExpParse(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlExpRef(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    xmlExpNodePtr exp; /* the expression */
    int n_exp;

    for (n_exp = 0;n_exp < gen_nb_xmlExpNodePtr;n_exp++) {
        mem_base = xmlMemBlocks();
        exp = gen_xmlExpNodePtr(n_exp, 0);

        xmlExpRef(exp);
        call_tests++;
        des_xmlExpNodePtr(n_exp, exp, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpRef",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_exp);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlExpStringDerive(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlExpSubsume(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED) && defined(LIBXML_EXPR_ENABLED)
    int mem_base;
    int ret_val;
    xmlExpCtxtPtr ctxt; /* the expressions context */
    int n_ctxt;
    xmlExpNodePtr exp; /* the englobing expression */
    int n_exp;
    xmlExpNodePtr sub; /* the subexpression */
    int n_sub;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlExpCtxtPtr;n_ctxt++) {
    for (n_exp = 0;n_exp < gen_nb_xmlExpNodePtr;n_exp++) {
    for (n_sub = 0;n_sub < gen_nb_xmlExpNodePtr;n_sub++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlExpCtxtPtr(n_ctxt, 0);
        exp = gen_xmlExpNodePtr(n_exp, 1);
        sub = gen_xmlExpNodePtr(n_sub, 2);

        ret_val = xmlExpSubsume(ctxt, exp, sub);
        desret_int(ret_val);
        call_tests++;
        des_xmlExpCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlExpNodePtr(n_exp, exp, 1);
        des_xmlExpNodePtr(n_sub, sub, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlExpSubsume",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_exp);
            printf(" %d", n_sub);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_REGEXP_ENABLED

#define gen_nb_xmlRegExecCtxtPtr 1
static xmlRegExecCtxtPtr gen_xmlRegExecCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlRegExecCtxtPtr(int no ATTRIBUTE_UNUSED, xmlRegExecCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlRegExecErrInfo(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlRegExecCtxtPtr exec; /* a regexp execution context generating an error */
    int n_exec;
    xmlChar ** string; /* return value for the error string */
    int n_string;
    int * nbval; /* pointer to the number of accepted values IN/OUT */
    int n_nbval;
    int * nbneg; /* return number of negative transitions */
    int n_nbneg;
    xmlChar ** values; /* pointer to the array of acceptable values */
    int n_values;
    int * terminal; /* return value if this was a terminal state */
    int n_terminal;

    for (n_exec = 0;n_exec < gen_nb_xmlRegExecCtxtPtr;n_exec++) {
    for (n_string = 0;n_string < gen_nb_const_xmlChar_ptr_ptr;n_string++) {
    for (n_nbval = 0;n_nbval < gen_nb_int_ptr;n_nbval++) {
    for (n_nbneg = 0;n_nbneg < gen_nb_int_ptr;n_nbneg++) {
    for (n_values = 0;n_values < gen_nb_xmlChar_ptr_ptr;n_values++) {
    for (n_terminal = 0;n_terminal < gen_nb_int_ptr;n_terminal++) {
        mem_base = xmlMemBlocks();
        exec = gen_xmlRegExecCtxtPtr(n_exec, 0);
        string = gen_const_xmlChar_ptr_ptr(n_string, 1);
        nbval = gen_int_ptr(n_nbval, 2);
        nbneg = gen_int_ptr(n_nbneg, 3);
        values = gen_xmlChar_ptr_ptr(n_values, 4);
        terminal = gen_int_ptr(n_terminal, 5);

        ret_val = xmlRegExecErrInfo(exec, (const xmlChar **)string, nbval, nbneg, values, terminal);
        desret_int(ret_val);
        call_tests++;
        des_xmlRegExecCtxtPtr(n_exec, exec, 0);
        des_const_xmlChar_ptr_ptr(n_string, (const xmlChar **)string, 1);
        des_int_ptr(n_nbval, nbval, 2);
        des_int_ptr(n_nbneg, nbneg, 3);
        des_xmlChar_ptr_ptr(n_values, values, 4);
        des_int_ptr(n_terminal, terminal, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegExecErrInfo",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_exec);
            printf(" %d", n_string);
            printf(" %d", n_nbval);
            printf(" %d", n_nbneg);
            printf(" %d", n_values);
            printf(" %d", n_terminal);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRegExecNextValues(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlRegExecCtxtPtr exec; /* a regexp execution context */
    int n_exec;
    int * nbval; /* pointer to the number of accepted values IN/OUT */
    int n_nbval;
    int * nbneg; /* return number of negative transitions */
    int n_nbneg;
    xmlChar ** values; /* pointer to the array of acceptable values */
    int n_values;
    int * terminal; /* return value if this was a terminal state */
    int n_terminal;

    for (n_exec = 0;n_exec < gen_nb_xmlRegExecCtxtPtr;n_exec++) {
    for (n_nbval = 0;n_nbval < gen_nb_int_ptr;n_nbval++) {
    for (n_nbneg = 0;n_nbneg < gen_nb_int_ptr;n_nbneg++) {
    for (n_values = 0;n_values < gen_nb_xmlChar_ptr_ptr;n_values++) {
    for (n_terminal = 0;n_terminal < gen_nb_int_ptr;n_terminal++) {
        mem_base = xmlMemBlocks();
        exec = gen_xmlRegExecCtxtPtr(n_exec, 0);
        nbval = gen_int_ptr(n_nbval, 1);
        nbneg = gen_int_ptr(n_nbneg, 2);
        values = gen_xmlChar_ptr_ptr(n_values, 3);
        terminal = gen_int_ptr(n_terminal, 4);

        ret_val = xmlRegExecNextValues(exec, nbval, nbneg, values, terminal);
        desret_int(ret_val);
        call_tests++;
        des_xmlRegExecCtxtPtr(n_exec, exec, 0);
        des_int_ptr(n_nbval, nbval, 1);
        des_int_ptr(n_nbneg, nbneg, 2);
        des_xmlChar_ptr_ptr(n_values, values, 3);
        des_int_ptr(n_terminal, terminal, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegExecNextValues",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_exec);
            printf(" %d", n_nbval);
            printf(" %d", n_nbneg);
            printf(" %d", n_values);
            printf(" %d", n_terminal);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRegExecPushString(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlRegExecCtxtPtr exec; /* a regexp execution context or NULL to indicate the end */
    int n_exec;
    xmlChar * value; /* a string token input */
    int n_value;
    void * data; /* data associated to the token to reuse in callbacks */
    int n_data;

    for (n_exec = 0;n_exec < gen_nb_xmlRegExecCtxtPtr;n_exec++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        exec = gen_xmlRegExecCtxtPtr(n_exec, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);
        data = gen_userdata(n_data, 2);

        ret_val = xmlRegExecPushString(exec, (const xmlChar *)value, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlRegExecCtxtPtr(n_exec, exec, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        des_userdata(n_data, data, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegExecPushString",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_exec);
            printf(" %d", n_value);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRegExecPushString2(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlRegExecCtxtPtr exec; /* a regexp execution context or NULL to indicate the end */
    int n_exec;
    xmlChar * value; /* the first string token input */
    int n_value;
    xmlChar * value2; /* the second string token input */
    int n_value2;
    void * data; /* data associated to the token to reuse in callbacks */
    int n_data;

    for (n_exec = 0;n_exec < gen_nb_xmlRegExecCtxtPtr;n_exec++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_value2 = 0;n_value2 < gen_nb_const_xmlChar_ptr;n_value2++) {
    for (n_data = 0;n_data < gen_nb_userdata;n_data++) {
        mem_base = xmlMemBlocks();
        exec = gen_xmlRegExecCtxtPtr(n_exec, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);
        value2 = gen_const_xmlChar_ptr(n_value2, 2);
        data = gen_userdata(n_data, 3);

        ret_val = xmlRegExecPushString2(exec, (const xmlChar *)value, (const xmlChar *)value2, data);
        desret_int(ret_val);
        call_tests++;
        des_xmlRegExecCtxtPtr(n_exec, exec, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        des_const_xmlChar_ptr(n_value2, (const xmlChar *)value2, 2);
        des_userdata(n_data, data, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegExecPushString2",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_exec);
            printf(" %d", n_value);
            printf(" %d", n_value2);
            printf(" %d", n_data);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_REGEXP_ENABLED

#define gen_nb_xmlRegexpPtr 1
static xmlRegexpPtr gen_xmlRegexpPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlRegexpPtr(int no ATTRIBUTE_UNUSED, xmlRegexpPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlRegNewExecCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRegexpCompile(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlRegexpExec(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlRegexpPtr comp; /* the compiled regular expression */
    int n_comp;
    xmlChar * content; /* the value to check against the regular expression */
    int n_content;

    for (n_comp = 0;n_comp < gen_nb_xmlRegexpPtr;n_comp++) {
    for (n_content = 0;n_content < gen_nb_const_xmlChar_ptr;n_content++) {
        mem_base = xmlMemBlocks();
        comp = gen_xmlRegexpPtr(n_comp, 0);
        content = gen_const_xmlChar_ptr(n_content, 1);

        ret_val = xmlRegexpExec(comp, (const xmlChar *)content);
        desret_int(ret_val);
        call_tests++;
        des_xmlRegexpPtr(n_comp, comp, 0);
        des_const_xmlChar_ptr(n_content, (const xmlChar *)content, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegexpExec",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_comp);
            printf(" %d", n_content);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRegexpIsDeterminist(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    int ret_val;
    xmlRegexpPtr comp; /* the compiled regular expression */
    int n_comp;

    for (n_comp = 0;n_comp < gen_nb_xmlRegexpPtr;n_comp++) {
        mem_base = xmlMemBlocks();
        comp = gen_xmlRegexpPtr(n_comp, 0);

        ret_val = xmlRegexpIsDeterminist(comp);
        desret_int(ret_val);
        call_tests++;
        des_xmlRegexpPtr(n_comp, comp, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegexpIsDeterminist",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_comp);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlRegexpPrint(void) {
    int test_ret = 0;

#if defined(LIBXML_REGEXP_ENABLED)
    int mem_base;
    FILE * output; /* the file for the output debug */
    int n_output;
    xmlRegexpPtr regexp; /* the compiled regexp */
    int n_regexp;

    for (n_output = 0;n_output < gen_nb_FILE_ptr;n_output++) {
    for (n_regexp = 0;n_regexp < gen_nb_xmlRegexpPtr;n_regexp++) {
        mem_base = xmlMemBlocks();
        output = gen_FILE_ptr(n_output, 0);
        regexp = gen_xmlRegexpPtr(n_regexp, 1);

        xmlRegexpPrint(output, regexp);
        call_tests++;
        des_FILE_ptr(n_output, output, 0);
        des_xmlRegexpPtr(n_regexp, regexp, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlRegexpPrint",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_regexp);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_xmlregexp(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xmlregexp : 16 of 30 functions ...\n");
    test_ret += test_xmlExpCtxtNbCons();
    test_ret += test_xmlExpCtxtNbNodes();
    test_ret += test_xmlExpDump();
    test_ret += test_xmlExpExpDerive();
    test_ret += test_xmlExpGetLanguage();
    test_ret += test_xmlExpGetStart();
    test_ret += test_xmlExpIsNillable();
    test_ret += test_xmlExpMaxToken();
    test_ret += test_xmlExpNewAtom();
    test_ret += test_xmlExpNewCtxt();
    test_ret += test_xmlExpNewOr();
    test_ret += test_xmlExpNewRange();
    test_ret += test_xmlExpNewSeq();
    test_ret += test_xmlExpParse();
    test_ret += test_xmlExpRef();
    test_ret += test_xmlExpStringDerive();
    test_ret += test_xmlExpSubsume();
    test_ret += test_xmlRegExecErrInfo();
    test_ret += test_xmlRegExecNextValues();
    test_ret += test_xmlRegExecPushString();
    test_ret += test_xmlRegExecPushString2();
    test_ret += test_xmlRegNewExecCtxt();
    test_ret += test_xmlRegexpCompile();
    test_ret += test_xmlRegexpExec();
    test_ret += test_xmlRegexpIsDeterminist();
    test_ret += test_xmlRegexpPrint();

    if (test_ret != 0)
	printf("Module xmlregexp: %d errors\n", test_ret);
    return(test_ret);
}
#ifdef LIBXML_OUTPUT_ENABLED

#define gen_nb_xmlSaveCtxtPtr 1
static xmlSaveCtxtPtr gen_xmlSaveCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSaveCtxtPtr(int no ATTRIBUTE_UNUSED, xmlSaveCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSaveClose(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlSaveCtxtPtr ctxt; /* a document saving context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSaveCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSaveCtxtPtr(n_ctxt, 0);

        ret_val = xmlSaveClose(ctxt);
        desret_int(ret_val);
        call_tests++;
        des_xmlSaveCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveClose",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    long ret_val;
    xmlSaveCtxtPtr ctxt; /* a document saving context */
    int n_ctxt;
    xmlDocPtr doc; /* a document */
    int n_doc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSaveCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSaveCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlSaveDoc(ctxt, doc);
        desret_long(ret_val);
        call_tests++;
        des_xmlSaveCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveFlush(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    int ret_val;
    xmlSaveCtxtPtr ctxt; /* a document saving context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSaveCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSaveCtxtPtr(n_ctxt, 0);

        ret_val = xmlSaveFlush(ctxt);
        desret_int(ret_val);
        call_tests++;
        des_xmlSaveCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveFlush",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSaveSetAttrEscape(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSaveSetEscape(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSaveToBuffer(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSaveToFd(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSaveToFilename(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSaveTree(void) {
    int test_ret = 0;

#if defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    long ret_val;
    xmlSaveCtxtPtr ctxt; /* a document saving context */
    int n_ctxt;
    xmlNodePtr node; /* the top node of the subtree to save */
    int n_node;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSaveCtxtPtr;n_ctxt++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSaveCtxtPtr(n_ctxt, 0);
        node = gen_xmlNodePtr(n_node, 1);

        ret_val = xmlSaveTree(ctxt, node);
        desret_long(ret_val);
        call_tests++;
        des_xmlSaveCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlNodePtr(n_node, node, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSaveTree",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_xmlsave(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xmlsave : 4 of 10 functions ...\n");
    test_ret += test_xmlSaveClose();
    test_ret += test_xmlSaveDoc();
    test_ret += test_xmlSaveFlush();
    test_ret += test_xmlSaveSetAttrEscape();
    test_ret += test_xmlSaveSetEscape();
    test_ret += test_xmlSaveToBuffer();
    test_ret += test_xmlSaveToFd();
    test_ret += test_xmlSaveToFilename();
    test_ret += test_xmlSaveTree();

    if (test_ret != 0)
	printf("Module xmlsave: %d errors\n", test_ret);
    return(test_ret);
}

static int
test_xmlSchemaDump(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED) && defined(LIBXML_OUTPUT_ENABLED)
    int mem_base;
    FILE * output; /* the file output */
    int n_output;
    xmlSchemaPtr schema; /* a schema structure */
    int n_schema;

    for (n_output = 0;n_output < gen_nb_FILE_ptr;n_output++) {
    for (n_schema = 0;n_schema < gen_nb_xmlSchemaPtr;n_schema++) {
        mem_base = xmlMemBlocks();
        output = gen_FILE_ptr(n_output, 0);
        schema = gen_xmlSchemaPtr(n_schema, 1);

        xmlSchemaDump(output, schema);
        call_tests++;
        des_FILE_ptr(n_output, output, 0);
        des_xmlSchemaPtr(n_schema, schema, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaDump",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_output);
            printf(" %d", n_schema);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSchemaParserCtxtPtr 1
static xmlSchemaParserCtxtPtr gen_xmlSchemaParserCtxtPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaParserCtxtPtr(int no ATTRIBUTE_UNUSED, xmlSchemaParserCtxtPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSchemaValidityErrorFunc_ptr 1
static xmlSchemaValidityErrorFunc * gen_xmlSchemaValidityErrorFunc_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaValidityErrorFunc_ptr(int no ATTRIBUTE_UNUSED, xmlSchemaValidityErrorFunc * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSchemaValidityWarningFunc_ptr 1
static xmlSchemaValidityWarningFunc * gen_xmlSchemaValidityWarningFunc_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaValidityWarningFunc_ptr(int no ATTRIBUTE_UNUSED, xmlSchemaValidityWarningFunc * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchemaGetParserErrors(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaParserCtxtPtr ctxt; /* a XMl-Schema parser context */
    int n_ctxt;
    xmlSchemaValidityErrorFunc * err; /* the error callback result */
    int n_err;
    xmlSchemaValidityWarningFunc * warn; /* the warning callback result */
    int n_warn;
    void ** ctx; /* contextual data for the callbacks result */
    int n_ctx;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaParserCtxtPtr;n_ctxt++) {
    for (n_err = 0;n_err < gen_nb_xmlSchemaValidityErrorFunc_ptr;n_err++) {
    for (n_warn = 0;n_warn < gen_nb_xmlSchemaValidityWarningFunc_ptr;n_warn++) {
    for (n_ctx = 0;n_ctx < gen_nb_void_ptr_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaParserCtxtPtr(n_ctxt, 0);
        err = gen_xmlSchemaValidityErrorFunc_ptr(n_err, 1);
        warn = gen_xmlSchemaValidityWarningFunc_ptr(n_warn, 2);
        ctx = gen_void_ptr_ptr(n_ctx, 3);

        ret_val = xmlSchemaGetParserErrors(ctxt, err, warn, ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaParserCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlSchemaValidityErrorFunc_ptr(n_err, err, 1);
        des_xmlSchemaValidityWarningFunc_ptr(n_warn, warn, 2);
        des_void_ptr_ptr(n_ctx, ctx, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaGetParserErrors",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_err);
            printf(" %d", n_warn);
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaGetValidErrors(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* a XML-Schema validation context */
    int n_ctxt;
    xmlSchemaValidityErrorFunc * err; /* the error function result */
    int n_err;
    xmlSchemaValidityWarningFunc * warn; /* the warning function result */
    int n_warn;
    void ** ctx; /* the functions context result */
    int n_ctx;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
    for (n_err = 0;n_err < gen_nb_xmlSchemaValidityErrorFunc_ptr;n_err++) {
    for (n_warn = 0;n_warn < gen_nb_xmlSchemaValidityWarningFunc_ptr;n_warn++) {
    for (n_ctx = 0;n_ctx < gen_nb_void_ptr_ptr;n_ctx++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);
        err = gen_xmlSchemaValidityErrorFunc_ptr(n_err, 1);
        warn = gen_xmlSchemaValidityWarningFunc_ptr(n_warn, 2);
        ctx = gen_void_ptr_ptr(n_ctx, 3);

        ret_val = xmlSchemaGetValidErrors(ctxt, err, warn, ctx);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlSchemaValidityErrorFunc_ptr(n_err, err, 1);
        des_xmlSchemaValidityWarningFunc_ptr(n_warn, warn, 2);
        des_void_ptr_ptr(n_ctx, ctx, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaGetValidErrors",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_err);
            printf(" %d", n_warn);
            printf(" %d", n_ctx);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaIsValid(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* the schema validation context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);

        ret_val = xmlSchemaIsValid(ctxt);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaIsValid",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaNewDocParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlSchemaParserCtxtPtr ret_val;
    xmlDocPtr doc; /* a preparsed document tree */
    int n_doc;

    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        doc = gen_xmlDocPtr(n_doc, 0);

        ret_val = xmlSchemaNewDocParserCtxt(doc);
        desret_xmlSchemaParserCtxtPtr(ret_val);
        call_tests++;
        des_xmlDocPtr(n_doc, doc, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaNewDocParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaNewMemParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlSchemaParserCtxtPtr ret_val;
    char * buffer; /* a pointer to a char array containing the schemas */
    int n_buffer;
    int size; /* the size of the array */
    int n_size;

    for (n_buffer = 0;n_buffer < gen_nb_const_char_ptr;n_buffer++) {
    for (n_size = 0;n_size < gen_nb_int;n_size++) {
        mem_base = xmlMemBlocks();
        buffer = gen_const_char_ptr(n_buffer, 0);
        size = gen_int(n_size, 1);

        ret_val = xmlSchemaNewMemParserCtxt((const char *)buffer, size);
        desret_xmlSchemaParserCtxtPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_buffer, (const char *)buffer, 0);
        des_int(n_size, size, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaNewMemParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_buffer);
            printf(" %d", n_size);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaNewParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlSchemaParserCtxtPtr ret_val;
    char * URL; /* the location of the schema */
    int n_URL;

    for (n_URL = 0;n_URL < gen_nb_const_char_ptr;n_URL++) {
        mem_base = xmlMemBlocks();
        URL = gen_const_char_ptr(n_URL, 0);

        ret_val = xmlSchemaNewParserCtxt((const char *)URL);
        desret_xmlSchemaParserCtxtPtr(ret_val);
        call_tests++;
        des_const_char_ptr(n_URL, (const char *)URL, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaNewParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_URL);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaNewValidCtxt(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaParse(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSAXHandlerPtr_ptr 1
static xmlSAXHandlerPtr * gen_xmlSAXHandlerPtr_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSAXHandlerPtr_ptr(int no ATTRIBUTE_UNUSED, xmlSAXHandlerPtr * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchemaSAXPlug(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSchemaSAXPlugPtr 1
static xmlSchemaSAXPlugPtr gen_xmlSchemaSAXPlugPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaSAXPlugPtr(int no ATTRIBUTE_UNUSED, xmlSchemaSAXPlugPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchemaSAXUnplug(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaSAXPlugPtr plug; /* a data structure returned by xmlSchemaSAXPlug */
    int n_plug;

    for (n_plug = 0;n_plug < gen_nb_xmlSchemaSAXPlugPtr;n_plug++) {
        mem_base = xmlMemBlocks();
        plug = gen_xmlSchemaSAXPlugPtr(n_plug, 0);

        ret_val = xmlSchemaSAXUnplug(plug);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaSAXPlugPtr(n_plug, plug, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaSAXUnplug",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_plug);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaSetParserErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaSetParserStructuredErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaSetValidErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaSetValidOptions(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* a schema validation context */
    int n_ctxt;
    int options; /* a combination of xmlSchemaValidOption */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);
        options = gen_int(n_options, 1);

        ret_val = xmlSchemaSetValidOptions(ctxt, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        des_int(n_options, options, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaSetValidOptions",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaSetValidStructuredErrors(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaValidCtxtGetOptions(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* a schema validation context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);

        ret_val = xmlSchemaValidCtxtGetOptions(ctxt);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValidCtxtGetOptions",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValidCtxtGetParserCtxt(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlParserCtxtPtr ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* a schema validation context */
    int n_ctxt;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);

        ret_val = xmlSchemaValidCtxtGetParserCtxt(ctxt);
        desret_xmlParserCtxtPtr(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValidCtxtGetParserCtxt",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValidateDoc(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* a schema validation context */
    int n_ctxt;
    xmlDocPtr doc; /* a parsed document tree */
    int n_doc;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
    for (n_doc = 0;n_doc < gen_nb_xmlDocPtr;n_doc++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);
        doc = gen_xmlDocPtr(n_doc, 1);

        ret_val = xmlSchemaValidateDoc(ctxt, doc);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlDocPtr(n_doc, doc, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValidateDoc",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_doc);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValidateFile(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* a schema validation context */
    int n_ctxt;
    const char * filename; /* the URI of the instance */
    int n_filename;
    int options; /* a future set of options, currently unused */
    int n_options;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
    for (n_filename = 0;n_filename < gen_nb_filepath;n_filename++) {
    for (n_options = 0;n_options < gen_nb_int;n_options++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);
        filename = gen_filepath(n_filename, 1);
        options = gen_int(n_options, 2);

        ret_val = xmlSchemaValidateFile(ctxt, filename, options);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        des_filepath(n_filename, filename, 1);
        des_int(n_options, options, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValidateFile",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_filename);
            printf(" %d", n_options);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValidateOneElement(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* a schema validation context */
    int n_ctxt;
    xmlNodePtr elem; /* an element node */
    int n_elem;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
    for (n_elem = 0;n_elem < gen_nb_xmlNodePtr;n_elem++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);
        elem = gen_xmlNodePtr(n_elem, 1);

        ret_val = xmlSchemaValidateOneElement(ctxt, elem);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlNodePtr(n_elem, elem, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValidateOneElement",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_elem);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValidateStream(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValidCtxtPtr ctxt; /* a schema validation context */
    int n_ctxt;
    xmlParserInputBufferPtr input; /* the input to use for reading the data */
    int n_input;
    xmlCharEncoding enc; /* an optional encoding information */
    int n_enc;
    xmlSAXHandlerPtr sax; /* a SAX handler for the resulting events */
    int n_sax;
    void * user_data; /* the context to provide to the SAX handler. */
    int n_user_data;

    for (n_ctxt = 0;n_ctxt < gen_nb_xmlSchemaValidCtxtPtr;n_ctxt++) {
    for (n_input = 0;n_input < gen_nb_xmlParserInputBufferPtr;n_input++) {
    for (n_enc = 0;n_enc < gen_nb_xmlCharEncoding;n_enc++) {
    for (n_sax = 0;n_sax < gen_nb_xmlSAXHandlerPtr;n_sax++) {
    for (n_user_data = 0;n_user_data < gen_nb_userdata;n_user_data++) {
        mem_base = xmlMemBlocks();
        ctxt = gen_xmlSchemaValidCtxtPtr(n_ctxt, 0);
        input = gen_xmlParserInputBufferPtr(n_input, 1);
        enc = gen_xmlCharEncoding(n_enc, 2);
        sax = gen_xmlSAXHandlerPtr(n_sax, 3);
        user_data = gen_userdata(n_user_data, 4);

        ret_val = xmlSchemaValidateStream(ctxt, input, enc, sax, user_data);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValidCtxtPtr(n_ctxt, ctxt, 0);
        des_xmlParserInputBufferPtr(n_input, input, 1);
        des_xmlCharEncoding(n_enc, enc, 2);
        des_xmlSAXHandlerPtr(n_sax, sax, 3);
        des_userdata(n_user_data, user_data, 4);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValidateStream",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_ctxt);
            printf(" %d", n_input);
            printf(" %d", n_enc);
            printf(" %d", n_sax);
            printf(" %d", n_user_data);
            printf("\n");
        }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}

static int
test_xmlschemas(void) {
    int test_ret = 0;

    if (quiet == 0) printf("Testing xmlschemas : 15 of 25 functions ...\n");
    test_ret += test_xmlSchemaDump();
    test_ret += test_xmlSchemaGetParserErrors();
    test_ret += test_xmlSchemaGetValidErrors();
    test_ret += test_xmlSchemaIsValid();
    test_ret += test_xmlSchemaNewDocParserCtxt();
    test_ret += test_xmlSchemaNewMemParserCtxt();
    test_ret += test_xmlSchemaNewParserCtxt();
    test_ret += test_xmlSchemaNewValidCtxt();
    test_ret += test_xmlSchemaParse();
    test_ret += test_xmlSchemaSAXPlug();
    test_ret += test_xmlSchemaSAXUnplug();
    test_ret += test_xmlSchemaSetParserErrors();
    test_ret += test_xmlSchemaSetParserStructuredErrors();
    test_ret += test_xmlSchemaSetValidErrors();
    test_ret += test_xmlSchemaSetValidOptions();
    test_ret += test_xmlSchemaSetValidStructuredErrors();
    test_ret += test_xmlSchemaValidCtxtGetOptions();
    test_ret += test_xmlSchemaValidCtxtGetParserCtxt();
    test_ret += test_xmlSchemaValidateDoc();
    test_ret += test_xmlSchemaValidateFile();
    test_ret += test_xmlSchemaValidateOneElement();
    test_ret += test_xmlSchemaValidateStream();

    if (test_ret != 0)
	printf("Module xmlschemas: %d errors\n", test_ret);
    return(test_ret);
}
#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSchemaFacetPtr 1
static xmlSchemaFacetPtr gen_xmlSchemaFacetPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaFacetPtr(int no ATTRIBUTE_UNUSED, xmlSchemaFacetPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSchemaTypePtr 1
static xmlSchemaTypePtr gen_xmlSchemaTypePtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaTypePtr(int no ATTRIBUTE_UNUSED, xmlSchemaTypePtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchemaCheckFacet(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaFacetPtr facet; /* the facet */
    int n_facet;
    xmlSchemaTypePtr typeDecl; /* the schema type definition */
    int n_typeDecl;
    xmlSchemaParserCtxtPtr pctxt; /* the schema parser context or NULL */
    int n_pctxt;
    xmlChar * name; /* the optional name of the type */
    int n_name;

    for (n_facet = 0;n_facet < gen_nb_xmlSchemaFacetPtr;n_facet++) {
    for (n_typeDecl = 0;n_typeDecl < gen_nb_xmlSchemaTypePtr;n_typeDecl++) {
    for (n_pctxt = 0;n_pctxt < gen_nb_xmlSchemaParserCtxtPtr;n_pctxt++) {
    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
        mem_base = xmlMemBlocks();
        facet = gen_xmlSchemaFacetPtr(n_facet, 0);
        typeDecl = gen_xmlSchemaTypePtr(n_typeDecl, 1);
        pctxt = gen_xmlSchemaParserCtxtPtr(n_pctxt, 2);
        name = gen_const_xmlChar_ptr(n_name, 3);

        ret_val = xmlSchemaCheckFacet(facet, typeDecl, pctxt, (const xmlChar *)name);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaFacetPtr(n_facet, facet, 0);
        des_xmlSchemaTypePtr(n_typeDecl, typeDecl, 1);
        des_xmlSchemaParserCtxtPtr(n_pctxt, pctxt, 2);
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaCheckFacet",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_facet);
            printf(" %d", n_typeDecl);
            printf(" %d", n_pctxt);
            printf(" %d", n_name);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaCleanupTypes(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)


        xmlSchemaCleanupTypes();
        call_tests++;
        xmlResetLastError();
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaCollapseString(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlChar * ret_val;
    xmlChar * value; /* a value */
    int n_value;

    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
        mem_base = xmlMemBlocks();
        value = gen_const_xmlChar_ptr(n_value, 0);

        ret_val = xmlSchemaCollapseString((const xmlChar *)value);
        desret_xmlChar_ptr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaCollapseString",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_value);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSchemaValPtr 1
static xmlSchemaValPtr gen_xmlSchemaValPtr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaValPtr(int no ATTRIBUTE_UNUSED, xmlSchemaValPtr val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchemaCompareValues(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValPtr x; /* a first value */
    int n_x;
    xmlSchemaValPtr y; /* a second value */
    int n_y;

    for (n_x = 0;n_x < gen_nb_xmlSchemaValPtr;n_x++) {
    for (n_y = 0;n_y < gen_nb_xmlSchemaValPtr;n_y++) {
        mem_base = xmlMemBlocks();
        x = gen_xmlSchemaValPtr(n_x, 0);
        y = gen_xmlSchemaValPtr(n_y, 1);

        ret_val = xmlSchemaCompareValues(x, y);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValPtr(n_x, x, 0);
        des_xmlSchemaValPtr(n_y, y, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaCompareValues",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_x);
            printf(" %d", n_y);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaCompareValuesWhtsp(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValPtr x; /* a first value */
    int n_x;
    xmlSchemaWhitespaceValueType xws; /* the whitespace value of x */
    int n_xws;
    xmlSchemaValPtr y; /* a second value */
    int n_y;
    xmlSchemaWhitespaceValueType yws; /* the whitespace value of y */
    int n_yws;

    for (n_x = 0;n_x < gen_nb_xmlSchemaValPtr;n_x++) {
    for (n_xws = 0;n_xws < gen_nb_xmlSchemaWhitespaceValueType;n_xws++) {
    for (n_y = 0;n_y < gen_nb_xmlSchemaValPtr;n_y++) {
    for (n_yws = 0;n_yws < gen_nb_xmlSchemaWhitespaceValueType;n_yws++) {
        mem_base = xmlMemBlocks();
        x = gen_xmlSchemaValPtr(n_x, 0);
        xws = gen_xmlSchemaWhitespaceValueType(n_xws, 1);
        y = gen_xmlSchemaValPtr(n_y, 2);
        yws = gen_xmlSchemaWhitespaceValueType(n_yws, 3);

        ret_val = xmlSchemaCompareValuesWhtsp(x, xws, y, yws);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValPtr(n_x, x, 0);
        des_xmlSchemaWhitespaceValueType(n_xws, xws, 1);
        des_xmlSchemaValPtr(n_y, y, 2);
        des_xmlSchemaWhitespaceValueType(n_yws, yws, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaCompareValuesWhtsp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_x);
            printf(" %d", n_xws);
            printf(" %d", n_y);
            printf(" %d", n_yws);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaCopyValue(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaGetBuiltInListSimpleTypeItemType(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlSchemaTypePtr ret_val;
    xmlSchemaTypePtr type; /* the built-in simple type. */
    int n_type;

    for (n_type = 0;n_type < gen_nb_xmlSchemaTypePtr;n_type++) {
        mem_base = xmlMemBlocks();
        type = gen_xmlSchemaTypePtr(n_type, 0);

        ret_val = xmlSchemaGetBuiltInListSimpleTypeItemType(type);
        desret_xmlSchemaTypePtr(ret_val);
        call_tests++;
        des_xmlSchemaTypePtr(n_type, type, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaGetBuiltInListSimpleTypeItemType",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_type);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaGetBuiltInType(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    xmlSchemaTypePtr ret_val;
    xmlSchemaValType type; /* the type of the built in type */
    int n_type;

    for (n_type = 0;n_type < gen_nb_xmlSchemaValType;n_type++) {
        type = gen_xmlSchemaValType(n_type, 0);

        ret_val = xmlSchemaGetBuiltInType(type);
        desret_xmlSchemaTypePtr(ret_val);
        call_tests++;
        des_xmlSchemaValType(n_type, type, 0);
        xmlResetLastError();
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaGetCanonValue(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValPtr val; /* the precomputed value */
    int n_val;
    xmlChar ** retValue; /* the returned value */
    int n_retValue;

    for (n_val = 0;n_val < gen_nb_xmlSchemaValPtr;n_val++) {
    for (n_retValue = 0;n_retValue < gen_nb_const_xmlChar_ptr_ptr;n_retValue++) {
        mem_base = xmlMemBlocks();
        val = gen_xmlSchemaValPtr(n_val, 0);
        retValue = gen_const_xmlChar_ptr_ptr(n_retValue, 1);

        ret_val = xmlSchemaGetCanonValue(val, (const xmlChar **)retValue);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValPtr(n_val, val, 0);
        des_const_xmlChar_ptr_ptr(n_retValue, (const xmlChar **)retValue, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaGetCanonValue",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf(" %d", n_retValue);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaGetCanonValueWhtsp(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaValPtr val; /* the precomputed value */
    int n_val;
    xmlChar ** retValue; /* the returned value */
    int n_retValue;
    xmlSchemaWhitespaceValueType ws; /* the whitespace type of the value */
    int n_ws;

    for (n_val = 0;n_val < gen_nb_xmlSchemaValPtr;n_val++) {
    for (n_retValue = 0;n_retValue < gen_nb_const_xmlChar_ptr_ptr;n_retValue++) {
    for (n_ws = 0;n_ws < gen_nb_xmlSchemaWhitespaceValueType;n_ws++) {
        mem_base = xmlMemBlocks();
        val = gen_xmlSchemaValPtr(n_val, 0);
        retValue = gen_const_xmlChar_ptr_ptr(n_retValue, 1);
        ws = gen_xmlSchemaWhitespaceValueType(n_ws, 2);

        ret_val = xmlSchemaGetCanonValueWhtsp(val, (const xmlChar **)retValue, ws);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaValPtr(n_val, val, 0);
        des_const_xmlChar_ptr_ptr(n_retValue, (const xmlChar **)retValue, 1);
        des_xmlSchemaWhitespaceValueType(n_ws, ws, 2);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaGetCanonValueWhtsp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf(" %d", n_retValue);
            printf(" %d", n_ws);
            printf("\n");
        }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaGetFacetValueAsULong(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    unsigned long ret_val;
    xmlSchemaFacetPtr facet; /* an schemas type facet */
    int n_facet;

    for (n_facet = 0;n_facet < gen_nb_xmlSchemaFacetPtr;n_facet++) {
        mem_base = xmlMemBlocks();
        facet = gen_xmlSchemaFacetPtr(n_facet, 0);

        ret_val = xmlSchemaGetFacetValueAsULong(facet);
        desret_unsigned_long(ret_val);
        call_tests++;
        des_xmlSchemaFacetPtr(n_facet, facet, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaGetFacetValueAsULong",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_facet);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaGetPredefinedType(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlSchemaTypePtr ret_val;
    xmlChar * name; /* the type name */
    int n_name;
    xmlChar * ns; /* the URI of the namespace usually "http://www.w3.org/2001/XMLSchema" */
    int n_ns;

    for (n_name = 0;n_name < gen_nb_const_xmlChar_ptr;n_name++) {
    for (n_ns = 0;n_ns < gen_nb_const_xmlChar_ptr;n_ns++) {
        mem_base = xmlMemBlocks();
        name = gen_const_xmlChar_ptr(n_name, 0);
        ns = gen_const_xmlChar_ptr(n_ns, 1);

        ret_val = xmlSchemaGetPredefinedType((const xmlChar *)name, (const xmlChar *)ns);
        desret_xmlSchemaTypePtr(ret_val);
        call_tests++;
        des_const_xmlChar_ptr(n_name, (const xmlChar *)name, 0);
        des_const_xmlChar_ptr(n_ns, (const xmlChar *)ns, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaGetPredefinedType",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_name);
            printf(" %d", n_ns);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaGetValType(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    xmlSchemaValType ret_val;
    xmlSchemaValPtr val; /* a schemas value */
    int n_val;

    for (n_val = 0;n_val < gen_nb_xmlSchemaValPtr;n_val++) {
        mem_base = xmlMemBlocks();
        val = gen_xmlSchemaValPtr(n_val, 0);

        ret_val = xmlSchemaGetValType(val);
        desret_xmlSchemaValType(ret_val);
        call_tests++;
        des_xmlSchemaValPtr(n_val, val, 0);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaGetValType",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_val);
            printf("\n");
        }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaInitTypes(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)


        xmlSchemaInitTypes();
        call_tests++;
        xmlResetLastError();
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaIsBuiltInTypeFacet(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaTypePtr type; /* the built-in type */
    int n_type;
    int facetType; /* the facet type */
    int n_facetType;

    for (n_type = 0;n_type < gen_nb_xmlSchemaTypePtr;n_type++) {
    for (n_facetType = 0;n_facetType < gen_nb_int;n_facetType++) {
        mem_base = xmlMemBlocks();
        type = gen_xmlSchemaTypePtr(n_type, 0);
        facetType = gen_int(n_facetType, 1);

        ret_val = xmlSchemaIsBuiltInTypeFacet(type, facetType);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaTypePtr(n_type, type, 0);
        des_int(n_facetType, facetType, 1);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaIsBuiltInTypeFacet",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_type);
            printf(" %d", n_facetType);
            printf("\n");
        }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaNewFacet(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaNewNOTATIONValue(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaNewQNameValue(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}


static int
test_xmlSchemaNewStringValue(void) {
    int test_ret = 0;


    /* missing type support */
    return(test_ret);
}

#ifdef LIBXML_SCHEMAS_ENABLED

#define gen_nb_xmlSchemaValPtr_ptr 1
static xmlSchemaValPtr * gen_xmlSchemaValPtr_ptr(int no ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
    return(NULL);
}
static void des_xmlSchemaValPtr_ptr(int no ATTRIBUTE_UNUSED, xmlSchemaValPtr * val ATTRIBUTE_UNUSED, int nr ATTRIBUTE_UNUSED) {
}
#endif


static int
test_xmlSchemaValPredefTypeNode(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaTypePtr type; /* the predefined type */
    int n_type;
    xmlChar * value; /* the value to check */
    int n_value;
    xmlSchemaValPtr * val; /* the return computed value */
    int n_val;
    xmlNodePtr node; /* the node containing the value */
    int n_node;

    for (n_type = 0;n_type < gen_nb_xmlSchemaTypePtr;n_type++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_val = 0;n_val < gen_nb_xmlSchemaValPtr_ptr;n_val++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        type = gen_xmlSchemaTypePtr(n_type, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);
        val = gen_xmlSchemaValPtr_ptr(n_val, 2);
        node = gen_xmlNodePtr(n_node, 3);

        ret_val = xmlSchemaValPredefTypeNode(type, (const xmlChar *)value, val, node);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaTypePtr(n_type, type, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        des_xmlSchemaValPtr_ptr(n_val, val, 2);
        des_xmlNodePtr(n_node, node, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValPredefTypeNode",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_type);
            printf(" %d", n_value);
            printf(" %d", n_val);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValPredefTypeNodeNoNorm(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaTypePtr type; /* the predefined type */
    int n_type;
    xmlChar * value; /* the value to check */
    int n_value;
    xmlSchemaValPtr * val; /* the return computed value */
    int n_val;
    xmlNodePtr node; /* the node containing the value */
    int n_node;

    for (n_type = 0;n_type < gen_nb_xmlSchemaTypePtr;n_type++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_val = 0;n_val < gen_nb_xmlSchemaValPtr_ptr;n_val++) {
    for (n_node = 0;n_node < gen_nb_xmlNodePtr;n_node++) {
        mem_base = xmlMemBlocks();
        type = gen_xmlSchemaTypePtr(n_type, 0);
        value = gen_const_xmlChar_ptr(n_value, 1);
        val = gen_xmlSchemaValPtr_ptr(n_val, 2);
        node = gen_xmlNodePtr(n_node, 3);

        ret_val = xmlSchemaValPredefTypeNodeNoNorm(type, (const xmlChar *)value, val, node);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaTypePtr(n_type, type, 0);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 1);
        des_xmlSchemaValPtr_ptr(n_val, val, 2);
        des_xmlNodePtr(n_node, node, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValPredefTypeNodeNoNorm",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_type);
            printf(" %d", n_value);
            printf(" %d", n_val);
            printf(" %d", n_node);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValidateFacet(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaTypePtr base; /* the base type */
    int n_base;
    xmlSchemaFacetPtr facet; /* the facet to check */
    int n_facet;
    xmlChar * value; /* the lexical repr of the value to validate */
    int n_value;
    xmlSchemaValPtr val; /* the precomputed value */
    int n_val;

    for (n_base = 0;n_base < gen_nb_xmlSchemaTypePtr;n_base++) {
    for (n_facet = 0;n_facet < gen_nb_xmlSchemaFacetPtr;n_facet++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_val = 0;n_val < gen_nb_xmlSchemaValPtr;n_val++) {
        mem_base = xmlMemBlocks();
        base = gen_xmlSchemaTypePtr(n_base, 0);
        facet = gen_xmlSchemaFacetPtr(n_facet, 1);
        value = gen_const_xmlChar_ptr(n_value, 2);
        val = gen_xmlSchemaValPtr(n_val, 3);

        ret_val = xmlSchemaValidateFacet(base, facet, (const xmlChar *)value, val);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaTypePtr(n_base, base, 0);
        des_xmlSchemaFacetPtr(n_facet, facet, 1);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 2);
        des_xmlSchemaValPtr(n_val, val, 3);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValidateFacet",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_base);
            printf(" %d", n_facet);
            printf(" %d", n_value);
            printf(" %d", n_val);
            printf("\n");
        }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValidateFacetWhtsp(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaFacetPtr facet; /* the facet to check */
    int n_facet;
    xmlSchemaWhitespaceValueType fws; /* the whitespace type of the facet's value */
    int n_fws;
    xmlSchemaValType valType; /* the built-in type of the value */
    int n_valType;
    xmlChar * value; /* the lexical (or normalized for pattern) repr of the value to validate */
    int n_value;
    xmlSchemaValPtr val; /* the precomputed value */
    int n_val;
    xmlSchemaWhitespaceValueType ws; /* the whitespace type of the value */
    int n_ws;

    for (n_facet = 0;n_facet < gen_nb_xmlSchemaFacetPtr;n_facet++) {
    for (n_fws = 0;n_fws < gen_nb_xmlSchemaWhitespaceValueType;n_fws++) {
    for (n_valType = 0;n_valType < gen_nb_xmlSchemaValType;n_valType++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_val = 0;n_val < gen_nb_xmlSchemaValPtr;n_val++) {
    for (n_ws = 0;n_ws < gen_nb_xmlSchemaWhitespaceValueType;n_ws++) {
        mem_base = xmlMemBlocks();
        facet = gen_xmlSchemaFacetPtr(n_facet, 0);
        fws = gen_xmlSchemaWhitespaceValueType(n_fws, 1);
        valType = gen_xmlSchemaValType(n_valType, 2);
        value = gen_const_xmlChar_ptr(n_value, 3);
        val = gen_xmlSchemaValPtr(n_val, 4);
        ws = gen_xmlSchemaWhitespaceValueType(n_ws, 5);

        ret_val = xmlSchemaValidateFacetWhtsp(facet, fws, valType, (const xmlChar *)value, val, ws);
        desret_int(ret_val);
        call_tests++;
        des_xmlSchemaFacetPtr(n_facet, facet, 0);
        des_xmlSchemaWhitespaceValueType(n_fws, fws, 1);
        des_xmlSchemaValType(n_valType, valType, 2);
        des_const_xmlChar_ptr(n_value, (const xmlChar *)value, 3);
        des_xmlSchemaValPtr(n_val, val, 4);
        des_xmlSchemaWhitespaceValueType(n_ws, ws, 5);
        xmlResetLastError();
        if (mem_base != xmlMemBlocks()) {
            printf("Leak of %d blocks found in xmlSchemaValidateFacetWhtsp",
	           xmlMemBlocks() - mem_base);
	    test_ret++;
            printf(" %d", n_facet);
            printf(" %d", n_fws);
            printf(" %d", n_valType);
            printf(" %d", n_value);
            printf(" %d", n_val);
            printf(" %d", n_ws);
            printf("\n");
        }
    }
    }
    }
    }
    }
    }
    function_tests++;
#endif

    return(test_ret);
}


static int
test_xmlSchemaValidateLengthFacet(void) {
    int test_ret = 0;

#if defined(LIBXML_SCHEMAS_ENABLED)
    int mem_base;
    int ret_val;
    xmlSchemaTypePtr type; /* the built-in type */
    int n_type;
    xmlSchemaFacetPtr facet; /* the facet to check */
    int n_facet;
    xmlChar * value; /* the lexical repr. of the value to be validated */
    int n_value;
    xmlSchemaValPtr val; /* the precomputed value */
    int n_val;
    unsigned long * length; /* the actual length of the value */
    int n_length;

    for (n_type = 0;n_type < gen_nb_xmlSchemaTypePtr;n_type++) {
    for (n_facet = 0;n_facet < gen_nb_xmlSchemaFacetPtr;n_facet++) {
    for (n_value = 0;n_value < gen_nb_const_xmlChar_ptr;n_value++) {
    for (n_val = 0;n_val < gen_nb_xmlSchemaValPtr;n_val++) {
    for (n_length = 0;n_length < gen_nb_unsigned_long_ptr;n_length+