.\" zip_fopen_encrypted.mdoc \-- open encrypted file in zip archive for reading
.\" Copyright (C) 2011-2012 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_FOPEN_ENCRYPTED 3 "July 22, 2012" NiH
.SH "NAME"
zip_fopen_encrypted , \- .Nm zip_fopen_index_encrypted
open encrypted file in zip archive for reading
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
struct zip_file *
zip_fopen_encrypted(struct zip *archive, const char *fname, zip_flags_t flags, const char *password);
.PP
struct zip_file *
zip_fopen_index_encrypted(struct zip *archive, zip_uint64_t index, zip_flags_t flags, const char *password);
.SH "DESCRIPTION"
The
zip_fopen_encrypted
function opens the encrypted file name
\fBfname\fR
in
\fBarchive\fR
using the password given in the
\fBpassword\fR
argument.
The
\fBflags\fR
argument are the same as for
zip_fopen(3).
.PP
The
zip_fopen_index_encrypted
function opens the file at position
\fBindex,\fR
see
zip_fopen_index(3).
These functions are called automatically by
zip_fopen(3);
you only need to call them if you want to specify a non-default password
(see
zip_set_default_password(3)
).
.SH "RETURN VALUES"
Upon successful completion, a
.PP
struct zip_file
pointer is returned.
Otherwise,
\fBNULL\fR
is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
.RS
.TP 22
[ZIP_ER_NOPASSWD]
No password was provided.
.RE
.PP
The function
zip_fopen_encrypted
may also fail and set
.Va zip_err
for any of the errors specified for the routine
zip_fopen(3).
.PP
The function
zip_fopen_index_encrypted
may also fail and set
.Va zip_err
for any of the errors specified for the routine
zip_fopen_index(3).
.SH "SEE ALSO"
libzip(3),
zip_fclose(3),
zip_fopen(3),
zip_fread(3),
zip_get_num_entries(3),
zip_name_locate(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
