.\" zip_get_name.mdoc \-- get name of file by index
.\" Copyright (C) 2003-2013 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_GET_NAME 3 "February 20, 2013" NiH
.SH "NAME"
zip_get_name \- get name of file by index
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
const char *
zip_get_name(struct zip *archive, zip_uint64_t index, zip_flags_t flags);
.SH "DESCRIPTION"
The
zip_get_name
function returns the name of the file at position
\fBindex\fR
in
\fBarchive.\fR
The name is in UTF-8 encoding unless
\fBZIP_FL_ENC_RAW\fR
was specified (see below).
.PP
If
\fBflags\fR
is set to
\fBZIP_FL_UNCHANGED,\fR
the original unchanged filename is returned.
The returned string must not be modified or freed, and becomes invalid when
\fBarchive\fR
is closed.
.PP
Additionally, the following
\fBflags\fR
are supported:
.RS
.TP 21
\fBZIP_FL_ENC_RAW\fR
Return the unmodified names as it is in the ZIP archive.
.TP 21
\fBZIP_FL_ENC_GUESS\fR
(Default.)
Guess the encoding of the name in the ZIP archive and convert it
to UTF-8, if necessary.
.TP 21
\fBZIP_FL_ENC_STRICT\fR
Follow the ZIP specification and expect CP-437 encoded names in
the ZIP archive (except if they are explicitly marked as UTF-8).
Convert it to UTF-8.
.RE
.I Note:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
Upon successful completion, a pointer to the name is returned.
Otherwise,
\fBNULL\fR
and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_get_name
fails if:
.RS
.TP 4
[ZIP_ER_DELETED]
\fBindex\fR
refers to a file that has been deleted
(see
zip_delete(3)
).
.TP 4
[ZIP_ER_INVAL]
\fBindex\fR
is not a valid file index in
\fBarchive,\fR
or
\fBindex\fR
points to an added file and
\fBZIP_FL_UNCHANGED\fR
is set.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.RE
.SH "SEE ALSO"
libzip(3),
zip_name_locate(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
