.\" zip_set_archive_flag.mdoc \-- set zip archive flag
.\" Copyright (C) 2008-2012 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_SET_ARCHIVE_FLAG 3 "July 22, 2012" NiH
.SH "NAME"
zip_set_archive_flag \- set zip archive flag
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
int
zip_set_archive_flag(struct zip *archive, zip_flags_t flag, int value);
.SH "DESCRIPTION"
The
zip_set_archive_flag
function sets the flag
\fBflag\fR
for the archive
\fBarchive\fR
to the value
\fBvalue.\fR
.PP
Supported flags are:
.RS
.TP 21
\fBZIP_AFL_TORRENT\fR
Create a torrent-zipped archive.
This restricts the values that can be set from the application side.
In particular, time stamps are not saved and the order of the files in
the archive is alphabetical.
No file comments or extended attributes are allowed and the archive
comment can not be chosen.
.RE
.SH "RETURN VALUES"
Upon successful completion 0 is returned, and \-1 if an error
occurred.
.SH "SEE ALSO"
libzip(3),
zip_get_archive_flag(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
