.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zipcmp.mdoc -- compare zip archives
.\" Copyright (C) 2003-2018 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIPCMP" "1" "December 18, 2017" "NiH" "General Commands Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzipcmp\fR
\- compare contents of zip archives
.SH "SYNOPSIS"
.HP 7n
\fBzipcmp\fR
[\fB\-hipqtVv\fR]
\fIarchive1\ archive2\fR
.SH "DESCRIPTION"
\fBzipcmp\fR
compares the zip archives or directories
\fIarchive1\fR
and
\fIarchive2\fR
and checks if they contain the same files, comparing their names,
uncompressed sizes, and CRCs.
File order and compressed size differences are ignored.
.PP
Supported options:
.TP 5n
\fB\-h\fR
Display a short help message and exit.
.TP 5n
\fB\-i\fR
Compare names ignoring case distinctions.
.TP 5n
\fB\-p\fR
Enable paranoid checks.
Compares extra fields and other meta data.
(Automatically disabled if one of the archives is a directory.)
.TP 5n
\fB\-q\fR
Quiet mode.
Compare
\fB\-v\fR.
.TP 5n
\fB\-t\fR
Test zip files by comparing the contents to their checksums.
.TP 5n
\fB\-V\fR
Display version information and exit.
.TP 5n
\fB\-v\fR
Verbose mode.
Print details about differences to stdout.
(This is the default.)
.SH "EXIT STATUS"
\fBzipcmp\fR
exits 0 if the two archives contain the same files, 1 if they differ,
and >1 if an error occurred.
.SH "SEE ALSO"
zipmerge(1),
ziptool(1),
libzip(3)
.SH "HISTORY"
\fBzipcmp\fR
was added in libzip 0.6.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
