/*
  Copyright 2007-2020 David Robillard <http://drobilla.net>

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THIS SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

#undef NDEBUG

#include "lilv_test_utils.h"

#include "lilv/lilv.h"

#include <assert.h>
#include <stddef.h>

int
main(void)
{
	LilvTestEnv* const env   = lilv_test_env_new();
	LilvWorld* const   world = env->world;

	LilvNode* num = lilv_new_int(env->world, 4);
	LilvNode* uri = lilv_new_uri(env->world, "http://example.org/object");

	LilvNodes* matches = lilv_world_find_nodes(world, num, NULL, NULL);
	assert(!matches);

	matches = lilv_world_find_nodes(world, NULL, num, NULL);
	assert(!matches);

	matches = lilv_world_find_nodes(world, NULL, uri, NULL);
	assert(!matches);

	lilv_node_free(uri);
	lilv_node_free(num);

	lilv_world_unload_bundle(world, NULL);
	lilv_test_env_free(env);

	return 0;
}
