; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s

; PR31455 - https://bugs.llvm.org/show_bug.cgi?id=31455
; We have to assume that errno can be set, so we have to make a libcall in that case.
; But it's better for perf to check that the argument is valid rather than the result of
; sqrtss/sqrtsd.
; Note: This is really a test of the -partially-inline-libcalls IR pass (and we have an IR test
; for that), but we're checking the final asm to make sure that comes out as expected too.

define float @f(float %val) nounwind {
; CHECK-LABEL: f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm1, %xmm1
; CHECK-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-NEXT:    jb .LBB0_2
; CHECK-NEXT:  # %bb.1: # %.split
; CHECK-NEXT:    sqrtss %xmm0, %xmm0
; CHECK-NEXT:    retq
; CHECK-NEXT:  .LBB0_2: # %call.sqrt
; CHECK-NEXT:    jmp sqrtf # TAILCALL
  %res = tail call float @sqrtf(float %val)
  ret float %res
}

define double @d(double %val) nounwind {
; CHECK-LABEL: d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm1, %xmm1
; CHECK-NEXT:    ucomisd %xmm1, %xmm0
; CHECK-NEXT:    jb .LBB1_2
; CHECK-NEXT:  # %bb.1: # %.split
; CHECK-NEXT:    sqrtsd %xmm0, %xmm0
; CHECK-NEXT:    retq
; CHECK-NEXT:  .LBB1_2: # %call.sqrt
; CHECK-NEXT:    jmp sqrt # TAILCALL
  %res = tail call double @sqrt(double %val)
  ret double %res
}

declare float @sqrtf(float)
declare double @sqrt(double)

