//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// UNSUPPORTED: c++03, c++11, c++14, c++17

// <string_view>

//   constexpr bool starts_with(string_view x) const noexcept;

#include <string_view>
#include <cassert>

#include "test_macros.h"
#include "constexpr_char_traits.h"

int main(int, char**)
{
    {
    typedef std::string_view SV;
    const char *s = "abcde";
    SV  sv0 {};
    SV  sv1 { s, 1 };
    SV  sv2 { s, 2 };
    SV  svNot {"def", 3 };

    LIBCPP_ASSERT_NOEXCEPT(sv0.starts_with(""));

    assert ( sv0.starts_with(""));
    assert (!sv0.starts_with("a"));

    assert ( sv1.starts_with(""));
    assert ( sv1.starts_with("a"));
    assert (!sv1.starts_with("ab"));
    assert (!sv1.starts_with("abc"));
    assert (!sv1.starts_with("abcd"));
    assert (!sv1.starts_with("abcde"));
    assert (!sv1.starts_with("def"));

    assert ( sv2.starts_with(s + 5));
    assert ( sv2.starts_with("a"));
    assert ( sv2.starts_with("ab"));
    assert (!sv2.starts_with("abc"));
    assert (!sv2.starts_with("abcd"));
    assert (!sv2.starts_with("abcde"));
    assert (!sv2.starts_with("def"));

    assert ( svNot.starts_with(""));
    assert (!svNot.starts_with("a"));
    assert (!svNot.starts_with("ab"));
    assert (!svNot.starts_with("abc"));
    assert (!svNot.starts_with("abcd"));
    assert (!svNot.starts_with("abcde"));
    assert ( svNot.starts_with("def"));
    }

#if TEST_STD_VER > 11
    {
    typedef std::basic_string_view<char, constexpr_char_traits<char>> SV;
    constexpr const char *s = "abcde";
    constexpr SV  sv0 {};
    constexpr SV  sv1 { s, 1 };
    constexpr SV  sv2 { s, 2 };
    constexpr SV  svNot {"def", 3 };

    static_assert ( sv0.starts_with(""), "" );
    static_assert (!sv0.starts_with("a"), "" );

    static_assert ( sv1.starts_with(""), "" );
    static_assert ( sv1.starts_with("a"), "" );
    static_assert (!sv1.starts_with("ab"), "" );
    static_assert (!sv1.starts_with("abc"), "" );
    static_assert (!sv1.starts_with("abcd"), "" );
    static_assert (!sv1.starts_with("abcde"), "" );
    static_assert (!sv1.starts_with("def"), "" );

    static_assert ( sv2.starts_with(s + 5), "" );
    static_assert ( sv2.starts_with("a"), "" );
    static_assert ( sv2.starts_with("ab"), "" );
    static_assert (!sv2.starts_with("abc"), "" );
    static_assert (!sv2.starts_with("abcd"), "" );
    static_assert (!sv2.starts_with("abcde"), "" );
    static_assert (!sv2.starts_with("def"), "" );

    static_assert ( svNot.starts_with(""), "" );
    static_assert (!svNot.starts_with("a"), "" );
    static_assert (!svNot.starts_with("ab"), "" );
    static_assert (!svNot.starts_with("abc"), "" );
    static_assert (!svNot.starts_with("abcd"), "" );
    static_assert (!svNot.starts_with("abcde"), "" );
    static_assert ( svNot.starts_with("def"), "" );
    }
#endif

  return 0;
}
