#include <stdlib.h>
#include <string.h>

#include "basenames.h"

/* Return NAME with any leading path stripped off.  */

char *ourBaseName(char *name)
{
	char *base;

	base = strrchr(name, '/');
	return base ? base + 1 : name;
}

/** Remove the trailing slashes from a path
 * \par Description:
 * Remove the trailing slashes from the given path.
 * \par Note:
 * \par Warning:
 * Argument is modified
 * \param path	Path to strip
 * \return <path> with trailing slashes stripped
 * \sa
 ****************************************************************************/
static void stripTrailingSlashes(char *path)
{
	char *last;

	last = path + strlen(path) - 1;
	while (last > path && *last == '/')
		*last-- = '\0';
}

/** Get the directory name from a path
 * \par Description:
 * Get the directory name from the given path.  Look for the last slash, and
 * assume everything up to that is the directory.  If there isn't a slash,
 * return ".". 
 * \par Note:
 * Returned string is allocalted, and must be freed by the caller.
 * \par Warning:
 * \param path	Path to process
 * \return Directory portion of the path.
 * \sa
 ****************************************************************************/
char *ourDirName(char *path)
{
	char *slash;
	char *name;

	name = strdup(path);

	stripTrailingSlashes(name);

	slash = strrchr(name, '/');

	if (!slash) {
		/* No slash, must be current directory */
		free(name);
		/* strdup used, as the return value will be free()ed at some point */
		return strdup(".");
	}

	/* Remove final element and slash */
	*slash = '\0';
	stripTrailingSlashes(name);

	if (name[0] == '\0') {
		/* entire string was slashes */
		free (name);
		return strdup(".");
	}
	return name;
}
