/*
 * Decompiled with CFR 0.152.
 */
import com.jgoodies.plaf.FontSizeHints;
import com.jgoodies.plaf.LookUtils;
import com.jgoodies.plaf.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public final class Tiny {
    public static void main(String[] args) {
        Tiny instance = new Tiny();
        instance.configureUI();
        instance.buildInterface();
    }

    private void configureUI() {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setGlobalFontSizeHints(FontSizeHints.MIXED);
        Options.setDefaultIconSize(new Dimension(18, 18));
        String lafName = LookUtils.IS_OS_WINDOWS_XP ? Options.getCrossPlatformLookAndFeelClassName() : Options.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e);
        }
    }

    private void buildInterface() {
        JFrame frame = new JFrame();
        frame.setJMenuBar(this.buildMenuBar());
        frame.setContentPane(this.buildContentPane());
        frame.setSize(600, 400);
        this.locateOnScreen(frame);
        frame.setTitle("JGoodies :: Tiny");
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void locateOnScreen(Frame frame) {
        Dimension paneSize = frame.getSize();
        Dimension screenSize = frame.getToolkit().getScreenSize();
        frame.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", Boolean.TRUE);
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem("New..."));
        menu.add(new JMenuItem("Open..."));
        menu.add(new JMenuItem("Save"));
        menu.addSeparator();
        menu.add(new JMenuItem("Print..."));
        menuBar.add(menu);
        menu = new JMenu("Edit");
        menu.add(new JMenuItem("Cut"));
        menu.add(new JMenuItem("Copy"));
        menu.add(new JMenuItem("Paste"));
        menuBar.add(menu);
        return menuBar;
    }

    private JComponent buildContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildToolBar(), "North");
        panel.add(this.buildSplitPane(), "Center");
        panel.add(this.buildStatusBar(), "South");
        return panel;
    }

    private Component buildToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.putClientProperty("jgoodies.headerStyle", Boolean.TRUE);
        toolBar.add(this.createCenteredLabel("Tool Bar"));
        return toolBar;
    }

    private Component buildSplitPane() {
        JSplitPane splitPane = new JSplitPane(1, this.buildSideBar(), this.buildMainPanel());
        return splitPane;
    }

    private Component buildSideBar() {
        return this.createStrippedScrollPane(new JTree());
    }

    private Component buildMainPanel() {
        JEditorPane editor = new JEditorPane();
        editor.setText("This is a minimal Swing application, that demos,\nhow to install and use a JGoodies look&feel\nin a Swing application.");
        return this.createStrippedScrollPane(editor);
    }

    private Component buildStatusBar() {
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.add(this.createCenteredLabel("Status Bar"));
        return statusBar;
    }

    private JScrollPane createStrippedScrollPane(Component c) {
        JScrollPane scrollPane = new JScrollPane(c);
        scrollPane.setBorder(null);
        return scrollPane;
    }

    private Component createCenteredLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(0);
        label.setBorder(new EmptyBorder(3, 3, 3, 3));
        return label;
    }
}

