/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

final class ClearLookTab {
    ClearLookTab() {
    }

    JComponent build() {
        FormLayout fl = new FormLayout("pref:grow, 11dlu, pref:grow, 11dlu, pref:grow", "fill:0:grow, 2dlu, pref, 11dlu, fill:0:grow, 2dlu, pref, 11dlu, fill:0:grow, 2dlu, pref, 11dlu, pref");
        fl.setColumnGroups(new int[][]{{1, 3, 5}});
        fl.setRowGroups(new int[][]{{1, 5, 9}});
        PanelBuilder builder = new PanelBuilder(fl);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.buildScrollPaneInSplitPane(), cc.xy(1, 1));
        builder.addLabel("ScrollPane in SplitPane", cc.xy(1, 3, "c, c"));
        builder.add((Component)this.buildScrollPaneInEtchedBorder(), cc.xy(3, 1));
        builder.addLabel("ScrollPane in EtchedBorder", cc.xy(3, 3, "c, c"));
        builder.add((Component)this.buildScrollPaneInTabbedPane(), cc.xy(5, 1));
        builder.addLabel("ScrollPane in TabbedPane", cc.xy(5, 3, "c, c"));
        builder.add((Component)this.buildTabbedPaneInSplitPane(), cc.xy(1, 5));
        builder.addLabel("TabbedPane in SplitPane", cc.xy(1, 7, "c, c"));
        builder.add((Component)this.buildTabbedPaneInEtchedBorder(), cc.xy(3, 5));
        builder.addLabel("TabbedPane in EtchedBorder", cc.xy(3, 7, "c, c"));
        builder.add((Component)this.buildTabbedPaneInInternalFrame(), cc.xy(5, 5));
        builder.addLabel("TabbedPane in InternalFrame", cc.xy(5, 7, "c, c"));
        builder.add((Component)this.buildNestedSplitPanes(), cc.xy(1, 9));
        builder.addLabel("Nested SplitPanes", cc.xy(1, 11, "c, c"));
        builder.add((Component)this.buildEtchedInEtchedBorder(), cc.xy(3, 9));
        builder.addLabel("EtchedBorder in EtchedBorder", cc.xy(3, 11, "c, c"));
        builder.add((Component)this.buildCompoundBorderInBevelBorder(), cc.xy(5, 9));
        builder.addLabel("CompoundBorder in BevelBorder", cc.xy(5, 11, "c, c"));
        builder.add((Component)this.buildStatusBarWithBevelBorder(), cc.xyw(1, 13, 5));
        return builder.getPanel();
    }

    private JComponent buildScrollPaneInSplitPane() {
        JPanel left = new JPanel(new BorderLayout());
        left.add(new JLabel("Test"));
        JComponent textPanel = this.createTextPanel("Remove the scroll pane border", true);
        JScrollPane right = new JScrollPane(textPanel);
        right.setPreferredSize(new Dimension(40, 40));
        JSplitPane splitPane = new JSplitPane(1, left, right);
        splitPane.setDividerLocation(0.5);
        return splitPane;
    }

    private JComponent buildScrollPaneInEtchedBorder() {
        JComponent textPanel = this.createTextPanel("Remove the scroll pane border", true);
        JScrollPane scrollPane = new JScrollPane(textPanel);
        scrollPane.setPreferredSize(new Dimension(40, 40));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(scrollPane);
        panel.setBorder(new EtchedBorder());
        return panel;
    }

    private JComponent buildScrollPaneInTabbedPane() {
        JComponent textPanel = this.createTextPanel("Remove the inner border", true);
        JScrollPane scrollPane = new JScrollPane(textPanel);
        scrollPane.setPreferredSize(new Dimension(40, 40));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)scrollPane, "General");
        return tabbedPane;
    }

    private JComponent buildTabbedPaneInSplitPane() {
        JPanel left = new JPanel(new BorderLayout());
        left.add(new JLabel("Test"));
        JTabbedPane right = new JTabbedPane();
        right.addTab("1", this.createTextPanel("Consider hiding the\ntab content border", false));
        right.addTab("2", new JLabel());
        right.addTab("3", new JLabel());
        JSplitPane splitPane = new JSplitPane(1, left, right);
        splitPane.setDividerLocation(0.5);
        return splitPane;
    }

    private JComponent buildTabbedPaneInEtchedBorder() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("1", this.createTextPanel("Hide the content border", false));
        tabbedPane.addTab("2", new JLabel());
        tabbedPane.addTab("3", new JLabel());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(tabbedPane);
        panel.setBorder(new EtchedBorder());
        return panel;
    }

    private JComponent buildTabbedPaneInInternalFrame() {
        JComponent textPanel = this.createTextPanel("Hide the content border", false);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("1", textPanel);
        tabbedPane.addTab("2", new JLabel());
        tabbedPane.addTab("3", new JLabel());
        JDesktopPane desktop = new JDesktopPane();
        JInternalFrame frame = new JInternalFrame("Test", false, false, false, false);
        frame.setContentPane(tabbedPane);
        desktop.add(frame);
        frame.setBounds(0, 0, 50, 50);
        frame.setVisible(true);
        try {
            frame.setSelected(true);
            frame.setMaximum(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return desktop;
    }

    private JComponent buildNestedSplitPanes() {
        JPanel left = new JPanel(new BorderLayout());
        left.add(new JLabel("Test"));
        JTextArea upperRight = new JTextArea("Upper right");
        JComponent lowerRight = this.createTextPanel("Remove the\nsplit pane border", true);
        JSplitPane right = new JSplitPane(0, upperRight, lowerRight);
        JSplitPane main = new JSplitPane(1, left, right);
        return main;
    }

    private JComponent buildEtchedInEtchedBorder() {
        JComponent textPanel = this.createTextPanel("Remove the inner border", false);
        JPanel inner = new JPanel();
        inner.add(textPanel);
        inner.setBorder(new EtchedBorder());
        JPanel outer = new JPanel(new BorderLayout());
        outer.add(inner);
        outer.setBorder(new EtchedBorder());
        return outer;
    }

    private JComponent buildCompoundBorderInBevelBorder() {
        JComponent textPanel = this.createTextPanel("Remove the inner border", false);
        JPanel inner = new JPanel();
        inner.add(textPanel);
        inner.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(0, 1, 1, 1)));
        JPanel outer = new JPanel(new BorderLayout());
        outer.add(inner);
        outer.setBorder(new EtchedBorder());
        return outer;
    }

    private JComponent buildStatusBarWithBevelBorder() {
        JLabel statusBar = new JLabel(" Status bar with BevelBorder ");
        statusBar.setBorder(new BevelBorder(1));
        return statusBar;
    }

    private JComponent createTextPanel(String text, boolean editable) {
        JTextArea area = new JTextArea(text);
        area.setBorder(new EmptyBorder(15, 10, 0, 10));
        area.setEditable(editable);
        area.setOpaque(editable);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(area);
        return panel;
    }
}

