/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.plaf.LookUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

final class DesktopTab {
    private static final float SIZE_FACTOR = LookUtils.IS_LOW_RESOLUTION ? 1.0f : 1.175f;

    DesktopTab() {
    }

    JComponent build() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(Borders.DIALOG_BORDER);
        panel.add(new JScrollPane(this.buildDesktopPane()));
        return panel;
    }

    private JComponent buildDesktopPane() {
        int gap = (int)(10.0f * SIZE_FACTOR);
        int originX1 = 10;
        int extentX1 = (int)(193.0f * SIZE_FACTOR);
        int originX2 = originX1 + extentX1 + gap;
        int extentX2 = extentX1;
        int originX3 = originX2 + extentX2 + gap;
        int extentX3 = (int)(150.0f * SIZE_FACTOR);
        JDesktopPane desktop = new JDesktopPane();
        JInternalFrame frame = new JInternalFrame("Navigation", true, true, true, true);
        frame.setContentPane(this.buildFrame1ContentPane());
        frame.setBounds(originX1, 10, extentX1, 320);
        desktop.add(frame);
        frame.setVisible(true);
        frame = new JInternalFrame("Properties", true, false, true, true);
        frame.setContentPane(this.buildFrame2ContentPane());
        frame.setBounds(originX2, 10, extentX2, 320);
        desktop.add(frame);
        frame.setVisible(true);
        JInternalFrame palette = new JInternalFrame("Palette1", true, true, true, true);
        palette.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        palette.setContentPane(this.buildPaletteContentPane());
        palette.setBounds(originX3, 10, extentX3, 150);
        palette.setVisible(true);
        desktop.add((Component)palette, JLayeredPane.PALETTE_LAYER);
        palette = new JInternalFrame("Palette2", true, true, true, true);
        palette.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        palette.setContentPane(this.buildBackgroundTestContentPane());
        palette.setBounds(originX3, 170, extentX3, 160);
        palette.setVisible(true);
        desktop.add((Component)palette, JLayeredPane.PALETTE_LAYER);
        return desktop;
    }

    private JComponent buildFrame1ContentPane() {
        JScrollPane scrollPane = new JScrollPane(new JTree());
        scrollPane.setPreferredSize(new Dimension(100, 140));
        return scrollPane;
    }

    private JComponent buildFrame2ContentPane() {
        JScrollPane scrollPane = new JScrollPane(this.buildTable());
        scrollPane.setPreferredSize(new Dimension(100, 140));
        return scrollPane;
    }

    private JComponent buildPaletteContentPane() {
        EmptyBorder CARD_DIALOG_BORDER = new EmptyBorder(10, 6, 7, 6);
        Box box = Box.createVerticalBox();
        box.add(new JCheckBox("be consistent", true));
        box.add(Box.createVerticalStrut(6));
        box.add(new JCheckBox("use less ink", true));
        JPanel generalTab = new JPanel(new BorderLayout());
        generalTab.add(box);
        generalTab.setBorder(CARD_DIALOG_BORDER);
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.add((Component)generalTab, "General");
        tabbedPane.add((Component)new JLabel("Test1"), "Filter");
        return tabbedPane;
    }

    private JComponent buildBackgroundTestContentPane() {
        JTextArea area1 = new JTextArea("Background should be\nthe same as below.");
        area1.setBackground(UIManager.getColor("control"));
        JTextArea area2 = new JTextArea("Background should be\nthe same as above.");
        area2.setOpaque(false);
        JPanel grid = new JPanel(new GridLayout(2, 1));
        grid.add(area1);
        grid.add(area2);
        grid.setOpaque(false);
        return grid;
    }

    private JTable buildTable() {
        JTable table = new JTable(this.createSampleTableData(), new String[]{"Key", "Value"});
        table.getColumnModel().getColumn(0).setPreferredWidth(95);
        table.getColumnModel().getColumn(1).setPreferredWidth(95);
        table.setRowSelectionInterval(2, 2);
        return table;
    }

    private String[][] createSampleTableData() {
        return new String[][]{{"Name", "Karsten"}, {"Sex", "Male"}, {"Date of Birth", "5-Dec-1967"}, {"Place of Birth", "Kiel"}, {"Profession", "UI Designer"}, {"Business", "Freelancer"}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}};
    }
}

