/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class NarrowTab {
    NarrowTab() {
    }

    JComponent build() {
        FormLayout fl = new FormLayout("7dlu, right:max(50dlu;pref), 4dlu, left:pref, 0:grow", "pref, 2dlu, pref, 4dlu, pref, 4dlu, pref, 11dlu, pref, 2dlu, pref, 4dlu, pref, 4dlu, pref, 11dlu, pref, 2dlu, pref, 4dlu, pref, 4dlu, pref, 0:grow");
        PanelBuilder builder = new PanelBuilder(fl);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Unmodified Button Widths (BoxLayout)", cc.xyw(1, 1, 5));
        builder.addLabel("No Narrow Hint:", cc.xy(2, 3));
        builder.add(this.buildButtonBoxNoNarrow(), cc.xy(4, 3));
        builder.addLabel("One Narrow Hint:", cc.xy(2, 5));
        builder.add(this.buildButtonBoxOneNarrow(), cc.xy(4, 5));
        builder.addLabel("All Narrow Hints:", cc.xy(2, 7));
        builder.add(this.buildButtonBoxAllNarrow(), cc.xy(4, 7));
        builder.addSeparator("Adjusted Button Widths (FormLayout)", cc.xyw(1, 9, 5));
        builder.addLabel("No Narrow Hint:", cc.xy(2, 11));
        builder.add(this.buildButtonFormNoNarrow(), cc.xy(4, 11));
        builder.addLabel("One Narrow Hint:", cc.xy(2, 13));
        builder.add(this.buildButtonFormOneNarrow(), cc.xy(4, 13));
        builder.addLabel("All Narrow Hints:", cc.xy(2, 15));
        builder.add(this.buildButtonFormAllNarrow(), cc.xy(4, 15));
        builder.addSeparator("Equalized Button Widths (GridLayout)", cc.xyw(1, 17, 5));
        builder.addLabel("No Narrow Hint:", cc.xy(2, 19));
        builder.add(this.buildButtonGridNoNarrow(), cc.xy(4, 19));
        builder.addLabel("One Narrow Hint:", cc.xy(2, 21));
        builder.add(this.buildButtonGridOneNarrow(), cc.xy(4, 21));
        builder.addLabel("All Narrow Hints:", cc.xy(2, 23));
        builder.add(this.buildButtonGridAllNarrow(), cc.xy(4, 23));
        return builder.getPanel();
    }

    private Component buildButtonBoxNoNarrow() {
        return this.buildButtonBox(this.createButtons());
    }

    private Component buildButtonBoxOneNarrow() {
        return this.buildButtonBox(this.createButtonsWithOneNarrowHint());
    }

    private Component buildButtonBoxAllNarrow() {
        return this.buildButtonBox(this.createNarrowHintedButtons());
    }

    private Component buildButtonBox(JButton[] buttons) {
        Box box = Box.createHorizontalBox();
        for (int i = 0; i < buttons.length; ++i) {
            box.add(buttons[i]);
            box.add(Box.createHorizontalStrut(6));
        }
        return box;
    }

    private Component buildButtonFormNoNarrow() {
        return this.buildButtonForm(this.createButtons());
    }

    private Component buildButtonFormOneNarrow() {
        return this.buildButtonForm(this.createButtonsWithOneNarrowHint());
    }

    private Component buildButtonFormAllNarrow() {
        return this.buildButtonForm(this.createNarrowHintedButtons());
    }

    private Component buildButtonForm(JButton[] buttons) {
        FormLayout fl = new FormLayout("pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref", "pref");
        fl.setColumnGroups(new int[][]{{1, 3, 5, 7}});
        JPanel panel = new JPanel(fl);
        for (int i = 0; i < buttons.length; ++i) {
            panel.add((Component)buttons[i], new CellConstraints(i * 2 + 1, 1));
        }
        return panel;
    }

    private Component buildButtonGridNoNarrow() {
        return this.buildButtonGrid(this.createButtons());
    }

    private Component buildButtonGridOneNarrow() {
        return this.buildButtonGrid(this.createButtonsWithOneNarrowHint());
    }

    private Component buildButtonGridAllNarrow() {
        return this.buildButtonGrid(this.createNarrowHintedButtons());
    }

    private Component buildButtonGrid(JButton[] buttons) {
        JPanel grid = new JPanel(new GridLayout(1, 4, 6, 0));
        for (int i = 0; i < buttons.length; ++i) {
            grid.add(buttons[i]);
        }
        return grid;
    }

    private JButton createNarrowButton(String text) {
        JButton button = new JButton(text);
        button.putClientProperty("jgoodies.isNarrow", Boolean.TRUE);
        return button;
    }

    private JButton[] createButtons() {
        return new JButton[]{new JButton("Add..."), new JButton("Remove"), new JButton("Up"), new JButton("Down"), new JButton("A Long Label")};
    }

    private JButton[] createButtonsWithOneNarrowHint() {
        return new JButton[]{new JButton("Add..."), new JButton("Remove"), new JButton("Up"), new JButton("Down"), this.createNarrowButton("A Long Label")};
    }

    private JButton[] createNarrowHintedButtons() {
        return new JButton[]{this.createNarrowButton("Add..."), this.createNarrowButton("Remove"), this.createNarrowButton("Up"), this.createNarrowButton("Down"), this.createNarrowButton("A Long Label")};
    }
}

