/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif_lite.component.Factory;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

final class TabTestTab {
    TabTestTab() {
    }

    JComponent build() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(Borders.DIALOG_BORDER);
        panel.add(this.buildHorizontalSplit());
        return panel;
    }

    private JComponent buildHorizontalSplit() {
        return Factory.createStrippedSplitPane(1, this.buildNavigationPanel(), this.buildEditor(), 0.2f);
    }

    private JComponent buildNavigationPanel() {
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.putClientProperty("jgoodies.embeddedTabs", Boolean.TRUE);
        tabbedPane.addTab("Tree", Factory.createStrippedScrollPane(this.buildTree()));
        tabbedPane.addTab("Help", Factory.createStrippedScrollPane(this.buildHelp()));
        SimpleInternalFrame sif = new SimpleInternalFrame("Embedded Tabs");
        sif.setPreferredSize(new Dimension(150, 100));
        sif.add(tabbedPane);
        return sif;
    }

    private JTree buildTree() {
        JTree tree = new JTree(this.createSampleTreeModel());
        tree.putClientProperty("JTree.lineStyle", "None");
        tree.expandRow(3);
        tree.expandRow(2);
        tree.expandRow(1);
        return tree;
    }

    private JComponent buildHelp() {
        JTextArea area = new JTextArea("\n This tabbed pane uses\n embedded tabs.");
        return area;
    }

    private JComponent buildEditor() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        tabbedPane.addTab("Overview", this.buildOverviewTab());
        tabbedPane.addTab("Addresses", this.buildAddressesTab());
        SimpleInternalFrame sif = new SimpleInternalFrame("Tabbed Pane without Content Border");
        sif.setPreferredSize(new Dimension(300, 100));
        sif.add(tabbedPane);
        return sif;
    }

    private JComponent buildOverviewTab() {
        FormLayout layout = new FormLayout("right:max(50dlu;pref), 4dlu, max(35dlu;min), 2dlu, min, 2dlu, min, 2dlu, min, ", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        layout.setColumnGroups(new int[][]{{3, 5, 7, 9}});
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addLabel("File number:", cc.xy(1, 1));
        builder.add((Component)new JTextField(), cc.xyw(3, 1, 7));
        builder.addLabel("RFQ number:", cc.xy(1, 3));
        builder.add((Component)new JTextField(), cc.xyw(3, 3, 7));
        builder.addLabel("Entry date:", cc.xy(1, 5));
        builder.add((Component)new JTextField(), cc.xy(3, 5));
        builder.addLabel("Sales Person:", cc.xy(1, 7));
        builder.add((Component)new JTextField(), cc.xyw(3, 7, 7));
        builder.addLabel("BL/MBL number:", cc.xy(1, 9));
        builder.add((Component)new JTextField(), cc.xy(3, 9));
        builder.add((Component)new JTextField(), cc.xy(5, 9));
        builder.addLabel("Shipper:", cc.xy(1, 11));
        builder.add((Component)new JTextField(), cc.xy(3, 11));
        builder.add((Component)new JTextField(), cc.xyw(5, 11, 5));
        builder.addLabel("Consignee:", cc.xy(1, 13));
        builder.add((Component)new JTextField(), cc.xy(3, 13));
        builder.add((Component)new JTextField(), cc.xyw(5, 13, 5));
        builder.addLabel("Port of loading:", cc.xy(1, 15));
        builder.add((Component)new JTextField(), cc.xy(3, 15));
        builder.add((Component)new JTextField(), cc.xyw(5, 15, 5));
        builder.addLabel("Final destination:", cc.xy(1, 17));
        builder.add((Component)new JTextField(), cc.xy(3, 17));
        builder.add((Component)new JTextField(), cc.xyw(5, 17, 5));
        return builder.getPanel();
    }

    private JComponent buildAddressesTab() {
        FormLayout layout = new FormLayout("12dlu, max(85dlu;default), 25dlu, max(85dlu;default)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 21dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addTitle("Customer", cc.xy(2, 1));
        builder.add((Component)new JTextField(), cc.xy(2, 3));
        builder.add((Component)new JTextField(), cc.xy(2, 5));
        builder.add((Component)new JTextField(), cc.xy(2, 7));
        builder.add((Component)new JTextField(), cc.xy(2, 9));
        builder.addTitle("Shipper", cc.xy(4, 1));
        builder.add((Component)new JTextField(), cc.xy(4, 3));
        builder.add((Component)new JTextField(), cc.xy(4, 5));
        builder.add((Component)new JTextField(), cc.xy(4, 7));
        builder.add((Component)new JTextField(), cc.xy(4, 9));
        builder.addTitle("Consignee", cc.xy(2, 13));
        builder.add((Component)new JTextField(), cc.xy(2, 15));
        builder.add((Component)new JTextField(), cc.xy(2, 17));
        builder.add((Component)new JTextField(), cc.xy(2, 19));
        builder.add((Component)new JTextField(), cc.xy(2, 21));
        builder.addTitle("Notify", cc.xy(4, 13));
        builder.add((Component)new JTextField(), cc.xy(4, 15));
        builder.add((Component)new JTextField(), cc.xy(4, 17));
        builder.add((Component)new JTextField(), cc.xy(4, 19));
        builder.add((Component)new JTextField(), cc.xy(4, 21));
        return builder.getPanel();
    }

    private TreeModel createSampleTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Musicians");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("Drums");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Elvin Jones"));
        parent.add(new DefaultMutableTreeNode("Jack DeJohnette"));
        parent.add(new DefaultMutableTreeNode("Rashied Ali"));
        parent = new DefaultMutableTreeNode("Piano");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("McCoy Tyner"));
        parent.add(new DefaultMutableTreeNode("Sun Ra"));
        parent = new DefaultMutableTreeNode("Saxophon");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Albert Ayler"));
        parent.add(new DefaultMutableTreeNode("Archie Shepp"));
        parent.add(new DefaultMutableTreeNode("Charlie Parker"));
        parent.add(new DefaultMutableTreeNode("John Coltrane"));
        parent.add(new DefaultMutableTreeNode("Ornette Coleman"));
        parent.add(new DefaultMutableTreeNode("Pharoa Sanders"));
        parent.add(new DefaultMutableTreeNode("Sonny Rollins"));
        return new DefaultTreeModel(root);
    }
}

